# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_task_response import GetTaskResponse
from .raw_client import AsyncRawTaskClient, RawTaskClient


class TaskClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTaskClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTaskClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTaskClient
        """
        return self._raw_client

    def get(self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetTaskResponse:
        """
        Gets a task by its ID

        Parameters
        ----------
        task_id : str
            Task ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTaskResponse
            Task

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.task.get(
            task_id="task_id",
        )
        """
        _response = self._raw_client.get(task_id, request_options=request_options)
        return _response.data


class AsyncTaskClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTaskClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTaskClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTaskClient
        """
        return self._raw_client

    async def get(self, task_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetTaskResponse:
        """
        Gets a task by its ID

        Parameters
        ----------
        task_id : str
            Task ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetTaskResponse
            Task

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.task.get(
                task_id="task_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(task_id, request_options=request_options)
        return _response.data
