# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.message import Message
from .raw_client import AsyncRawMessageClient, RawMessageClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MessageClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMessageClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMessageClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMessageClient
        """
        return self._raw_client

    def update(
        self,
        message_uuid: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Updates a message.

        Parameters
        ----------
        message_uuid : str
            The UUID of the message.

        metadata : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The updated message.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.thread.message.update(
            message_uuid="messageUUID",
            metadata={"key": "value"},
        )
        """
        _response = self._raw_client.update(message_uuid, metadata=metadata, request_options=request_options)
        return _response.data


class AsyncMessageClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMessageClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMessageClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMessageClient
        """
        return self._raw_client

    async def update(
        self,
        message_uuid: str,
        *,
        metadata: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        Updates a message.

        Parameters
        ----------
        message_uuid : str
            The UUID of the message.

        metadata : typing.Dict[str, typing.Optional[typing.Any]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            The updated message.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.thread.message.update(
                message_uuid="messageUUID",
                metadata={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(message_uuid, metadata=metadata, request_options=request_options)
        return _response.data
