# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class EntityNode(UniversalBaseModel):
    attributes: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Additional attributes of the node. Dependent on node labels
    """

    created_at: str = pydantic.Field()
    """
    Creation time of the node
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Labels associated with the node
    """

    name: str = pydantic.Field()
    """
    Name of the node
    """

    relevance: typing.Optional[float] = pydantic.Field(default=None)
    """
    Relevance is an experimental rank-aligned score in [0,1] derived from Score via logit transformation.
    Only populated when using cross_encoder reranker; omitted for other reranker types (e.g., RRF).
    """

    score: typing.Optional[float] = pydantic.Field(default=None)
    """
    Score is the reranker output: sigmoid-distributed logits [0,1] when using cross_encoder reranker, or RRF ordinal rank when using rrf reranker
    """

    summary: str = pydantic.Field()
    """
    Regional summary of surrounding edges
    """

    uuid_: typing_extensions.Annotated[str, FieldMetadata(alias="uuid")] = pydantic.Field()
    """
    UUID of the node
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
