# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.fact_rating_instruction import FactRatingInstruction
from ..types.list_user_instructions_response import ListUserInstructionsResponse
from ..types.success_response import SuccessResponse
from ..types.thread import Thread
from ..types.user import User
from ..types.user_instruction import UserInstruction
from ..types.user_list_response import UserListResponse
from ..types.user_node_response import UserNodeResponse
from .raw_client import AsyncRawUserClient, RawUserClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserClient
        """
        return self._raw_client

    def list_user_summary_instructions(
        self, *, user_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListUserInstructionsResponse:
        """
        Lists all user summary instructions for a project, user.

        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to get user-specific instructions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserInstructionsResponse
            The list of instructions.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.list_user_summary_instructions(
            user_id="user_id",
        )
        """
        _response = self._raw_client.list_user_summary_instructions(user_id=user_id, request_options=request_options)
        return _response.data

    def add_user_summary_instructions(
        self,
        *,
        instructions: typing.Sequence[UserInstruction],
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Adds new summary instructions for users graphs without removing existing ones. If user_ids is empty, adds to project-wide default instructions.

        Parameters
        ----------
        instructions : typing.Sequence[UserInstruction]
            Instructions to add to the user summary generation.

        user_ids : typing.Optional[typing.Sequence[str]]
            User IDs to add the instructions to. If empty, the instructions are added to the project-wide default.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Instructions added successfully

        Examples
        --------
        from zep_cloud import UserInstruction, Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.add_user_summary_instructions(
            instructions=[
                UserInstruction(
                    name="name",
                    text="text",
                )
            ],
        )
        """
        _response = self._raw_client.add_user_summary_instructions(
            instructions=instructions, user_ids=user_ids, request_options=request_options
        )
        return _response.data

    def delete_user_summary_instructions(
        self,
        *,
        instruction_names: typing.Optional[typing.Sequence[str]] = OMIT,
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Deletes user summary/instructions for users or project wide defaults.

        Parameters
        ----------
        instruction_names : typing.Optional[typing.Sequence[str]]
            Unique identifier for the instructions to be deleted. If empty deletes all instructions.

        user_ids : typing.Optional[typing.Sequence[str]]
            Determines which users will have their custom instructions deleted. If no users are provided, the project-wide custom instructions will be effected.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Instructions deleted successfully

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.delete_user_summary_instructions()
        """
        _response = self._raw_client.delete_user_summary_instructions(
            instruction_names=instruction_names, user_ids=user_ids, request_options=request_options
        )
        return _response.data

    def add(
        self,
        *,
        user_id: str,
        disable_default_ontology: typing.Optional[bool] = OMIT,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Adds a user.

        Parameters
        ----------
        user_id : str
            The unique identifier of the user.

        disable_default_ontology : typing.Optional[bool]
            When true, disables the use of default/fallback ontology for the user's graph.

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was added.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.add(
            user_id="user_id",
        )
        """
        _response = self._raw_client.add(
            user_id=user_id,
            disable_default_ontology=disable_default_ontology,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def list_ordered(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserListResponse:
        """
        Returns all users.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of users to retrieve per page

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserListResponse
            Successfully retrieved list of users

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.list_ordered(
            page_number=1,
            page_size=1,
        )
        """
        _response = self._raw_client.list_ordered(
            page_number=page_number, page_size=page_size, request_options=request_options
        )
        return _response.data

    def get(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> User:
        """
        Returns a user.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was retrieved.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.get(
            user_id="userId",
        )
        """
        _response = self._raw_client.get(user_id, request_options=request_options)
        return _response.data

    def delete(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Deletes a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.delete(
            user_id="userId",
        )
        """
        _response = self._raw_client.delete(user_id, request_options=request_options)
        return _response.data

    def update(
        self,
        user_id: str,
        *,
        disable_default_ontology: typing.Optional[bool] = OMIT,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Updates a user.

        Parameters
        ----------
        user_id : str
            User ID

        disable_default_ontology : typing.Optional[bool]
            When true, disables the use of default/fallback ontology for the user's graph.

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata to update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was updated.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.update(
            user_id="userId",
        )
        """
        _response = self._raw_client.update(
            user_id,
            disable_default_ontology=disable_default_ontology,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def get_node(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> UserNodeResponse:
        """
        Returns a user's node.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get the node for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserNodeResponse
            Response object containing the User node.

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.get_node(
            user_id="userId",
        )
        """
        _response = self._raw_client.get_node(user_id, request_options=request_options)
        return _response.data

    def get_threads(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Thread]:
        """
        Returns all threads for a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Thread]
            OK

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.get_threads(
            user_id="userId",
        )
        """
        _response = self._raw_client.get_threads(user_id, request_options=request_options)
        return _response.data

    def warm(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Hints Zep to warm a user's graph for low-latency search

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Warm hint accepted

        Examples
        --------
        from zep_cloud import Zep

        client = Zep(
            api_key="YOUR_API_KEY",
        )
        client.user.warm(
            user_id="userId",
        )
        """
        _response = self._raw_client.warm(user_id, request_options=request_options)
        return _response.data


class AsyncUserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserClient
        """
        return self._raw_client

    async def list_user_summary_instructions(
        self, *, user_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListUserInstructionsResponse:
        """
        Lists all user summary instructions for a project, user.

        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to get user-specific instructions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListUserInstructionsResponse
            The list of instructions.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.list_user_summary_instructions(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_user_summary_instructions(
            user_id=user_id, request_options=request_options
        )
        return _response.data

    async def add_user_summary_instructions(
        self,
        *,
        instructions: typing.Sequence[UserInstruction],
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Adds new summary instructions for users graphs without removing existing ones. If user_ids is empty, adds to project-wide default instructions.

        Parameters
        ----------
        instructions : typing.Sequence[UserInstruction]
            Instructions to add to the user summary generation.

        user_ids : typing.Optional[typing.Sequence[str]]
            User IDs to add the instructions to. If empty, the instructions are added to the project-wide default.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Instructions added successfully

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep, UserInstruction

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.add_user_summary_instructions(
                instructions=[
                    UserInstruction(
                        name="name",
                        text="text",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add_user_summary_instructions(
            instructions=instructions, user_ids=user_ids, request_options=request_options
        )
        return _response.data

    async def delete_user_summary_instructions(
        self,
        *,
        instruction_names: typing.Optional[typing.Sequence[str]] = OMIT,
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResponse:
        """
        Deletes user summary/instructions for users or project wide defaults.

        Parameters
        ----------
        instruction_names : typing.Optional[typing.Sequence[str]]
            Unique identifier for the instructions to be deleted. If empty deletes all instructions.

        user_ids : typing.Optional[typing.Sequence[str]]
            Determines which users will have their custom instructions deleted. If no users are provided, the project-wide custom instructions will be effected.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Instructions deleted successfully

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.delete_user_summary_instructions()


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_user_summary_instructions(
            instruction_names=instruction_names, user_ids=user_ids, request_options=request_options
        )
        return _response.data

    async def add(
        self,
        *,
        user_id: str,
        disable_default_ontology: typing.Optional[bool] = OMIT,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Adds a user.

        Parameters
        ----------
        user_id : str
            The unique identifier of the user.

        disable_default_ontology : typing.Optional[bool]
            When true, disables the use of default/fallback ontology for the user's graph.

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata associated with the user.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was added.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.add(
                user_id="user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add(
            user_id=user_id,
            disable_default_ontology=disable_default_ontology,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def list_ordered(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserListResponse:
        """
        Returns all users.

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1

        page_size : typing.Optional[int]
            Number of users to retrieve per page

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserListResponse
            Successfully retrieved list of users

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.list_ordered(
                page_number=1,
                page_size=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_ordered(
            page_number=page_number, page_size=page_size, request_options=request_options
        )
        return _response.data

    async def get(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> User:
        """
        Returns a user.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was retrieved.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(user_id, request_options=request_options)
        return _response.data

    async def delete(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Deletes a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            OK

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.delete(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        user_id: str,
        *,
        disable_default_ontology: typing.Optional[bool] = OMIT,
        email: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        first_name: typing.Optional[str] = OMIT,
        last_name: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> User:
        """
        Updates a user.

        Parameters
        ----------
        user_id : str
            User ID

        disable_default_ontology : typing.Optional[bool]
            When true, disables the use of default/fallback ontology for the user's graph.

        email : typing.Optional[str]
            The email address of the user.

        fact_rating_instruction : typing.Optional[FactRatingInstruction]
            Optional instruction to use for fact rating.

        first_name : typing.Optional[str]
            The first name of the user.

        last_name : typing.Optional[str]
            The last name of the user.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The metadata to update

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        User
            The user that was updated.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.update(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            user_id,
            disable_default_ontology=disable_default_ontology,
            email=email,
            fact_rating_instruction=fact_rating_instruction,
            first_name=first_name,
            last_name=last_name,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def get_node(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserNodeResponse:
        """
        Returns a user's node.

        Parameters
        ----------
        user_id : str
            The user_id of the user to get the node for.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserNodeResponse
            Response object containing the User node.

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_node(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_node(user_id, request_options=request_options)
        return _response.data

    async def get_threads(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[Thread]:
        """
        Returns all threads for a user.

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Thread]
            OK

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.get_threads(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_threads(user_id, request_options=request_options)
        return _response.data

    async def warm(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Hints Zep to warm a user's graph for low-latency search

        Parameters
        ----------
        user_id : str
            User ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Warm hint accepted

        Examples
        --------
        import asyncio

        from zep_cloud import AsyncZep

        client = AsyncZep(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.user.warm(
                user_id="userId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.warm(user_id, request_options=request_options)
        return _response.data
