# cloudsmith_api
The API to the Cloudsmith Service

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: v1
- Package version: 2.0.21
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://help.cloudsmith.io](https://help.cloudsmith.io)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/cloudsmith-io/cloudsmith-api.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/cloudsmith-io/cloudsmith-api.git`)

Then import the package:
```python
import cloudsmith_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cloudsmith_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import cloudsmith_api
from cloudsmith_api.rest import ApiException
from pprint import pprint

# Configure API key authorization: apikey
configuration = cloudsmith_api.Configuration()
configuration.api_key['X-Api-Key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-Api-Key'] = 'Bearer'
# Configure HTTP basic authorization: basic
configuration = cloudsmith_api.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'

# create an instance of the API class
api_instance = cloudsmith_api.AuditLogApi(cloudsmith_api.ApiClient(configuration))
owner = 'owner_example' # str | 
page = 56 # int | A page number within the paginated result set. (optional)
page_size = 56 # int | Number of results to return per page. (optional)
query = 'query_example' # str | A search term for querying events, actors, or timestamps of log records. (optional)

try:
    # Lists audit log entries for a specific namespace.
    api_response = api_instance.audit_log_namespace_list(owner, page=page, page_size=page_size, query=query)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuditLogApi->audit_log_namespace_list: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.cloudsmith.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuditLogApi* | [**audit_log_namespace_list**](docs/AuditLogApi.md#audit_log_namespace_list) | **GET** /audit-log/{owner}/ | Lists audit log entries for a specific namespace.
*AuditLogApi* | [**audit_log_repo_list**](docs/AuditLogApi.md#audit_log_repo_list) | **GET** /audit-log/{owner}/{repo}/ | Lists audit log entries for a specific repository.
*BadgesApi* | [**badges_version_list**](docs/BadgesApi.md#badges_version_list) | **GET** /badges/version/{owner}/{repo}/{package_format}/{package_name}/{package_version}/{package_identifiers}/ | Get latest package version for a package or package group.
*DistrosApi* | [**distros_list**](docs/DistrosApi.md#distros_list) | **GET** /distros/ | Get a list of all supported distributions.
*DistrosApi* | [**distros_read**](docs/DistrosApi.md#distros_read) | **GET** /distros/{slug}/ | View for viewing/listing distributions.
*EntitlementsApi* | [**entitlements_create**](docs/EntitlementsApi.md#entitlements_create) | **POST** /entitlements/{owner}/{repo}/ | Create a specific entitlement in a repository.
*EntitlementsApi* | [**entitlements_delete**](docs/EntitlementsApi.md#entitlements_delete) | **DELETE** /entitlements/{owner}/{repo}/{identifier}/ | Delete a specific entitlement in a repository.
*EntitlementsApi* | [**entitlements_disable**](docs/EntitlementsApi.md#entitlements_disable) | **POST** /entitlements/{owner}/{repo}/{identifier}/disable/ | Disable an entitlement token in a repository.
*EntitlementsApi* | [**entitlements_enable**](docs/EntitlementsApi.md#entitlements_enable) | **POST** /entitlements/{owner}/{repo}/{identifier}/enable/ | Enable an entitlement token in a repository.
*EntitlementsApi* | [**entitlements_list**](docs/EntitlementsApi.md#entitlements_list) | **GET** /entitlements/{owner}/{repo}/ | Get a list of all entitlements in a repository.
*EntitlementsApi* | [**entitlements_partial_update**](docs/EntitlementsApi.md#entitlements_partial_update) | **PATCH** /entitlements/{owner}/{repo}/{identifier}/ | Update a specific entitlement in a repository.
*EntitlementsApi* | [**entitlements_read**](docs/EntitlementsApi.md#entitlements_read) | **GET** /entitlements/{owner}/{repo}/{identifier}/ | Get a specific entitlement in a repository.
*EntitlementsApi* | [**entitlements_refresh**](docs/EntitlementsApi.md#entitlements_refresh) | **POST** /entitlements/{owner}/{repo}/{identifier}/refresh/ | Refresh an entitlement token in a repository.
*EntitlementsApi* | [**entitlements_reset**](docs/EntitlementsApi.md#entitlements_reset) | **POST** /entitlements/{owner}/{repo}/{identifier}/reset/ | Reset the statistics for an entitlement token in a repository.
*EntitlementsApi* | [**entitlements_sync**](docs/EntitlementsApi.md#entitlements_sync) | **POST** /entitlements/{owner}/{repo}/sync/ | Synchronise tokens from a source repository.
*FilesApi* | [**files_abort**](docs/FilesApi.md#files_abort) | **POST** /files/{owner}/{repo}/{identifier}/abort/ | Abort a multipart file upload.
*FilesApi* | [**files_complete**](docs/FilesApi.md#files_complete) | **POST** /files/{owner}/{repo}/{identifier}/complete/ | Complete a multipart file upload.
*FilesApi* | [**files_create**](docs/FilesApi.md#files_create) | **POST** /files/{owner}/{repo}/ | Request URL(s) to upload new package file upload(s) to.
*FilesApi* | [**files_info**](docs/FilesApi.md#files_info) | **GET** /files/{owner}/{repo}/{identifier}/info/ | Get upload information to perform a multipart file upload.
*FilesApi* | [**files_validate**](docs/FilesApi.md#files_validate) | **POST** /files/{owner}/{repo}/validate/ | Validate parameters used for create.
*FormatsApi* | [**formats_list**](docs/FormatsApi.md#formats_list) | **GET** /formats/ | Get a list of all supported package formats.
*FormatsApi* | [**formats_read**](docs/FormatsApi.md#formats_read) | **GET** /formats/{slug}/ | Get a specific supported package format.
*MetricsApi* | [**metrics_entitlements_account_list**](docs/MetricsApi.md#metrics_entitlements_account_list) | **GET** /metrics/entitlements/{owner}/ | View for listing entitlement token metrics, across an account.
*MetricsApi* | [**metrics_entitlements_repo_list**](docs/MetricsApi.md#metrics_entitlements_repo_list) | **GET** /metrics/entitlements/{owner}/{repo}/ | View for listing entitlement token metrics, for a repository.
*MetricsApi* | [**metrics_packages_list**](docs/MetricsApi.md#metrics_packages_list) | **GET** /metrics/packages/{owner}/{repo}/ | View for listing package usage metrics, for a repository.
*NamespacesApi* | [**namespaces_list**](docs/NamespacesApi.md#namespaces_list) | **GET** /namespaces/ | Get a list of all namespaces the user belongs to.
*NamespacesApi* | [**namespaces_read**](docs/NamespacesApi.md#namespaces_read) | **GET** /namespaces/{slug}/ | Get a specific namespace that the user belongs to.
*OrgsApi* | [**orgs_delete**](docs/OrgsApi.md#orgs_delete) | **DELETE** /orgs/{org}/ | Delete the specified organization.
*OrgsApi* | [**orgs_deny_policy_create**](docs/OrgsApi.md#orgs_deny_policy_create) | **POST** /orgs/{org}/deny-policy/ | Create a package deny policy.
*OrgsApi* | [**orgs_deny_policy_delete**](docs/OrgsApi.md#orgs_deny_policy_delete) | **DELETE** /orgs/{org}/deny-policy/{slug_perm}/ | Delete a package deny policy.
*OrgsApi* | [**orgs_deny_policy_list**](docs/OrgsApi.md#orgs_deny_policy_list) | **GET** /orgs/{org}/deny-policy/ | Get a list of all package deny policies.
*OrgsApi* | [**orgs_deny_policy_partial_update**](docs/OrgsApi.md#orgs_deny_policy_partial_update) | **PATCH** /orgs/{org}/deny-policy/{slug_perm}/ | Partially update a package deny policy.
*OrgsApi* | [**orgs_deny_policy_read**](docs/OrgsApi.md#orgs_deny_policy_read) | **GET** /orgs/{org}/deny-policy/{slug_perm}/ | Get a package deny policy.
*OrgsApi* | [**orgs_deny_policy_update**](docs/OrgsApi.md#orgs_deny_policy_update) | **PUT** /orgs/{org}/deny-policy/{slug_perm}/ | Update a package deny policy.
*OrgsApi* | [**orgs_invites_create**](docs/OrgsApi.md#orgs_invites_create) | **POST** /orgs/{org}/invites/ | Create an organization invite for a specific user
*OrgsApi* | [**orgs_invites_delete**](docs/OrgsApi.md#orgs_invites_delete) | **DELETE** /orgs/{org}/invites/{slug_perm}/ | Delete a specific organization invite
*OrgsApi* | [**orgs_invites_extend**](docs/OrgsApi.md#orgs_invites_extend) | **POST** /orgs/{org}/invites/{slug_perm}/extend/ | Extend an organization invite.
*OrgsApi* | [**orgs_invites_list**](docs/OrgsApi.md#orgs_invites_list) | **GET** /orgs/{org}/invites/ | Get a list of all invites for an organization.
*OrgsApi* | [**orgs_invites_partial_update**](docs/OrgsApi.md#orgs_invites_partial_update) | **PATCH** /orgs/{org}/invites/{slug_perm}/ | Update a specific organization invite.
*OrgsApi* | [**orgs_invites_resend**](docs/OrgsApi.md#orgs_invites_resend) | **POST** /orgs/{org}/invites/{slug_perm}/resend/ | Resend an organization invite.
*OrgsApi* | [**orgs_license_policy_create**](docs/OrgsApi.md#orgs_license_policy_create) | **POST** /orgs/{org}/license-policy/ | Create a package license policy.
*OrgsApi* | [**orgs_license_policy_delete**](docs/OrgsApi.md#orgs_license_policy_delete) | **DELETE** /orgs/{org}/license-policy/{slug_perm}/ | Delete a package license policy.
*OrgsApi* | [**orgs_license_policy_evaluation_create**](docs/OrgsApi.md#orgs_license_policy_evaluation_create) | **POST** /orgs/{org}/license-policy/{policy_slug_perm}/evaluation/ | Create an evaluation request for this policy.
*OrgsApi* | [**orgs_license_policy_evaluation_list**](docs/OrgsApi.md#orgs_license_policy_evaluation_list) | **GET** /orgs/{org}/license-policy/{policy_slug_perm}/evaluation/ | List evaluation requests for this policy.
*OrgsApi* | [**orgs_license_policy_evaluation_read**](docs/OrgsApi.md#orgs_license_policy_evaluation_read) | **GET** /orgs/{org}/license-policy/{policy_slug_perm}/evaluation/{slug_perm}/ | Retrieve an evaluation request for this policy.
*OrgsApi* | [**orgs_license_policy_list**](docs/OrgsApi.md#orgs_license_policy_list) | **GET** /orgs/{org}/license-policy/ | Get a list of all package license policies.
*OrgsApi* | [**orgs_license_policy_partial_update**](docs/OrgsApi.md#orgs_license_policy_partial_update) | **PATCH** /orgs/{org}/license-policy/{slug_perm}/ | Partially update a package license policy.
*OrgsApi* | [**orgs_license_policy_read**](docs/OrgsApi.md#orgs_license_policy_read) | **GET** /orgs/{org}/license-policy/{slug_perm}/ | Get a package license policy.
*OrgsApi* | [**orgs_license_policy_update**](docs/OrgsApi.md#orgs_license_policy_update) | **PUT** /orgs/{org}/license-policy/{slug_perm}/ | Update a package license policy.
*OrgsApi* | [**orgs_license_policy_violation_list**](docs/OrgsApi.md#orgs_license_policy_violation_list) | **GET** /orgs/{org}/license-policy-violation/ | List all current license policy violations for this Organization.
*OrgsApi* | [**orgs_list**](docs/OrgsApi.md#orgs_list) | **GET** /orgs/ | Get a list of all the organizations you are associated with.
*OrgsApi* | [**orgs_members_delete**](docs/OrgsApi.md#orgs_members_delete) | **DELETE** /orgs/{org}/members/{member}/ | Removes a member from the organization.
*OrgsApi* | [**orgs_members_list**](docs/OrgsApi.md#orgs_members_list) | **GET** /orgs/{org}/members/ | Get the details for all organization members.
*OrgsApi* | [**orgs_members_partial_update**](docs/OrgsApi.md#orgs_members_partial_update) | **PATCH** /orgs/{org}/members/{member}/ | Views for working with organization members.
*OrgsApi* | [**orgs_members_read**](docs/OrgsApi.md#orgs_members_read) | **GET** /orgs/{org}/members/{member}/ | Get the details for a specific organization member.
*OrgsApi* | [**orgs_members_refresh**](docs/OrgsApi.md#orgs_members_refresh) | **POST** /orgs/{org}/members/{member}/refresh/ | Refresh a member of the organization&#39;s API key.
*OrgsApi* | [**orgs_members_remove**](docs/OrgsApi.md#orgs_members_remove) | **GET** /orgs/{org}/members/{member}/remove/ | Removes a member from the organization (deprecated, use DELETE instead).
*OrgsApi* | [**orgs_members_update_role**](docs/OrgsApi.md#orgs_members_update_role) | **PATCH** /orgs/{org}/members/{member}/update-role/ | Update a member&#39;s role in the organization.
*OrgsApi* | [**orgs_members_update_visibility**](docs/OrgsApi.md#orgs_members_update_visibility) | **PATCH** /orgs/{org}/members/{member}/update-visibility/ | Update a member&#39;s visibility in the organization.
*OrgsApi* | [**orgs_openid_connect_create**](docs/OrgsApi.md#orgs_openid_connect_create) | **POST** /orgs/{org}/openid-connect/ | Create the OpenID Connect provider settings for the org.
*OrgsApi* | [**orgs_openid_connect_delete**](docs/OrgsApi.md#orgs_openid_connect_delete) | **DELETE** /orgs/{org}/openid-connect/{slug_perm}/ | Delete a specific OpenID Connect provider setting for the org.
*OrgsApi* | [**orgs_openid_connect_list**](docs/OrgsApi.md#orgs_openid_connect_list) | **GET** /orgs/{org}/openid-connect/ | Retrieve the list of OpenID Connect provider settings for the org.
*OrgsApi* | [**orgs_openid_connect_partial_update**](docs/OrgsApi.md#orgs_openid_connect_partial_update) | **PATCH** /orgs/{org}/openid-connect/{slug_perm}/ | Update a specific OpenID Connect provider setting for the org.
*OrgsApi* | [**orgs_openid_connect_read**](docs/OrgsApi.md#orgs_openid_connect_read) | **GET** /orgs/{org}/openid-connect/{slug_perm}/ | Retrieve a specific OpenID Connect provider setting for the org.
*OrgsApi* | [**orgs_openid_connect_update**](docs/OrgsApi.md#orgs_openid_connect_update) | **PUT** /orgs/{org}/openid-connect/{slug_perm}/ | Update a specific OpenID Connect provider setting for the org.
*OrgsApi* | [**orgs_read**](docs/OrgsApi.md#orgs_read) | **GET** /orgs/{org}/ | Get the details for the specific organization.
*OrgsApi* | [**orgs_saml_authentication_partial_update**](docs/OrgsApi.md#orgs_saml_authentication_partial_update) | **PATCH** /orgs/{org}/saml-authentication | Update the SAML Authentication settings for this Organization.
*OrgsApi* | [**orgs_saml_authentication_read**](docs/OrgsApi.md#orgs_saml_authentication_read) | **GET** /orgs/{org}/saml-authentication | Retrieve the SAML Authentication settings for this Organization.
*OrgsApi* | [**orgs_saml_group_sync_create**](docs/OrgsApi.md#orgs_saml_group_sync_create) | **POST** /orgs/{org}/saml-group-sync/ | Create a new SAML Group Sync mapping within an organization.
*OrgsApi* | [**orgs_saml_group_sync_delete**](docs/OrgsApi.md#orgs_saml_group_sync_delete) | **DELETE** /orgs/{org}/saml-group-sync/{slug_perm}/ | Delete a SAML Group Sync mapping from an organization.
*OrgsApi* | [**orgs_saml_group_sync_disable**](docs/OrgsApi.md#orgs_saml_group_sync_disable) | **POST** /orgs/{org}/saml-group-sync/disable/ | Disable SAML Group Sync for this organization.
*OrgsApi* | [**orgs_saml_group_sync_enable**](docs/OrgsApi.md#orgs_saml_group_sync_enable) | **POST** /orgs/{org}/saml-group-sync/enable/ | Enable SAML Group Sync for this organization.
*OrgsApi* | [**orgs_saml_group_sync_list**](docs/OrgsApi.md#orgs_saml_group_sync_list) | **GET** /orgs/{org}/saml-group-sync/ | Get the details of all SAML Group Sync mapping within an organization.
*OrgsApi* | [**orgs_saml_group_sync_status**](docs/OrgsApi.md#orgs_saml_group_sync_status) | **GET** /orgs/{org}/saml-group-sync/status/ | Retrieve the SAML Group Sync status for this organization.
*OrgsApi* | [**orgs_services_create**](docs/OrgsApi.md#orgs_services_create) | **POST** /orgs/{org}/services/ | Create a service within an organization.
*OrgsApi* | [**orgs_services_delete**](docs/OrgsApi.md#orgs_services_delete) | **DELETE** /orgs/{org}/services/{service}/ | Delete a specific service
*OrgsApi* | [**orgs_services_list**](docs/OrgsApi.md#orgs_services_list) | **GET** /orgs/{org}/services/ | Get a list of all services within an organization.
*OrgsApi* | [**orgs_services_partial_update**](docs/OrgsApi.md#orgs_services_partial_update) | **PATCH** /orgs/{org}/services/{service}/ | Update a service within an organization.
*OrgsApi* | [**orgs_services_read**](docs/OrgsApi.md#orgs_services_read) | **GET** /orgs/{org}/services/{service}/ | Retrieve details of a single service within an organization.
*OrgsApi* | [**orgs_services_refresh**](docs/OrgsApi.md#orgs_services_refresh) | **POST** /orgs/{org}/services/{service}/refresh/ | Refresh service API token.
*OrgsApi* | [**orgs_teams_create**](docs/OrgsApi.md#orgs_teams_create) | **POST** /orgs/{org}/teams/ | Create a team for this organization.
*OrgsApi* | [**orgs_teams_delete**](docs/OrgsApi.md#orgs_teams_delete) | **DELETE** /orgs/{org}/teams/{team}/ | Delete a specific team in a organization.
*OrgsApi* | [**orgs_teams_list**](docs/OrgsApi.md#orgs_teams_list) | **GET** /orgs/{org}/teams/ | Get the details of all teams within an organization.
*OrgsApi* | [**orgs_teams_members_create**](docs/OrgsApi.md#orgs_teams_members_create) | **POST** /orgs/{org}/teams/{team}/members | Add users to a team.
*OrgsApi* | [**orgs_teams_members_list**](docs/OrgsApi.md#orgs_teams_members_list) | **GET** /orgs/{org}/teams/{team}/members | List all members for the team.
*OrgsApi* | [**orgs_teams_members_update**](docs/OrgsApi.md#orgs_teams_members_update) | **PUT** /orgs/{org}/teams/{team}/members | Replace all team members.
*OrgsApi* | [**orgs_teams_partial_update**](docs/OrgsApi.md#orgs_teams_partial_update) | **PATCH** /orgs/{org}/teams/{team}/ | Update a specific team in a organization.
*OrgsApi* | [**orgs_teams_read**](docs/OrgsApi.md#orgs_teams_read) | **GET** /orgs/{org}/teams/{team}/ | Get the details of a specific team within an organization.
*OrgsApi* | [**orgs_vulnerability_policy_create**](docs/OrgsApi.md#orgs_vulnerability_policy_create) | **POST** /orgs/{org}/vulnerability-policy/ | Create a package vulnerability policy.
*OrgsApi* | [**orgs_vulnerability_policy_delete**](docs/OrgsApi.md#orgs_vulnerability_policy_delete) | **DELETE** /orgs/{org}/vulnerability-policy/{slug_perm}/ | Delete a package vulnerability policy.
*OrgsApi* | [**orgs_vulnerability_policy_evaluation_create**](docs/OrgsApi.md#orgs_vulnerability_policy_evaluation_create) | **POST** /orgs/{org}/vulnerability-policy/{policy_slug_perm}/evaluation/ | Create an evaluation request for this policy.
*OrgsApi* | [**orgs_vulnerability_policy_evaluation_list**](docs/OrgsApi.md#orgs_vulnerability_policy_evaluation_list) | **GET** /orgs/{org}/vulnerability-policy/{policy_slug_perm}/evaluation/ | List evaluation requests for this policy.
*OrgsApi* | [**orgs_vulnerability_policy_evaluation_read**](docs/OrgsApi.md#orgs_vulnerability_policy_evaluation_read) | **GET** /orgs/{org}/vulnerability-policy/{policy_slug_perm}/evaluation/{slug_perm}/ | Retrieve an evaluation request for this policy.
*OrgsApi* | [**orgs_vulnerability_policy_list**](docs/OrgsApi.md#orgs_vulnerability_policy_list) | **GET** /orgs/{org}/vulnerability-policy/ | Get a list of all package vulnerability policies.
*OrgsApi* | [**orgs_vulnerability_policy_partial_update**](docs/OrgsApi.md#orgs_vulnerability_policy_partial_update) | **PATCH** /orgs/{org}/vulnerability-policy/{slug_perm}/ | Partially update a package vulnerability policy.
*OrgsApi* | [**orgs_vulnerability_policy_read**](docs/OrgsApi.md#orgs_vulnerability_policy_read) | **GET** /orgs/{org}/vulnerability-policy/{slug_perm}/ | Get a package vulnerability policy.
*OrgsApi* | [**orgs_vulnerability_policy_update**](docs/OrgsApi.md#orgs_vulnerability_policy_update) | **PUT** /orgs/{org}/vulnerability-policy/{slug_perm}/ | Update a package vulnerability policy.
*OrgsApi* | [**orgs_vulnerability_policy_violation_list**](docs/OrgsApi.md#orgs_vulnerability_policy_violation_list) | **GET** /orgs/{org}/vulnerability-policy-violation/ | List all current vulnerability policy violations for this Organization.
*PackagesApi* | [**packages_copy**](docs/PackagesApi.md#packages_copy) | **POST** /packages/{owner}/{repo}/{identifier}/copy/ | Copy a package to another repository.
*PackagesApi* | [**packages_delete**](docs/PackagesApi.md#packages_delete) | **DELETE** /packages/{owner}/{repo}/{identifier}/ | Delete a specific package in a repository.
*PackagesApi* | [**packages_dependencies**](docs/PackagesApi.md#packages_dependencies) | **GET** /packages/{owner}/{repo}/{identifier}/dependencies/ | Get the list of dependencies for a package. Transitive dependencies are included where supported.
*PackagesApi* | [**packages_groups_list**](docs/PackagesApi.md#packages_groups_list) | **GET** /packages/{owner}/{repo}/groups/ | Return a list of Package Groups in a repository.
*PackagesApi* | [**packages_list**](docs/PackagesApi.md#packages_list) | **GET** /packages/{owner}/{repo}/ | Get a list of all packages associated with repository.
*PackagesApi* | [**packages_move**](docs/PackagesApi.md#packages_move) | **POST** /packages/{owner}/{repo}/{identifier}/move/ | Move a package to another repository.
*PackagesApi* | [**packages_quarantine**](docs/PackagesApi.md#packages_quarantine) | **POST** /packages/{owner}/{repo}/{identifier}/quarantine/ | Quarantine or release a package.
*PackagesApi* | [**packages_read**](docs/PackagesApi.md#packages_read) | **GET** /packages/{owner}/{repo}/{identifier}/ | Get a specific package in a repository.
*PackagesApi* | [**packages_resync**](docs/PackagesApi.md#packages_resync) | **POST** /packages/{owner}/{repo}/{identifier}/resync/ | Schedule a package for resynchronisation.
*PackagesApi* | [**packages_scan**](docs/PackagesApi.md#packages_scan) | **POST** /packages/{owner}/{repo}/{identifier}/scan/ | Schedule a package for scanning.
*PackagesApi* | [**packages_status**](docs/PackagesApi.md#packages_status) | **GET** /packages/{owner}/{repo}/{identifier}/status/ | Get the synchronization status for a package.
*PackagesApi* | [**packages_tag**](docs/PackagesApi.md#packages_tag) | **POST** /packages/{owner}/{repo}/{identifier}/tag/ | Add/Replace/Remove tags for a package.
*PackagesApi* | [**packages_upload_alpine**](docs/PackagesApi.md#packages_upload_alpine) | **POST** /packages/{owner}/{repo}/upload/alpine/ | Create a new Alpine package
*PackagesApi* | [**packages_upload_cargo**](docs/PackagesApi.md#packages_upload_cargo) | **POST** /packages/{owner}/{repo}/upload/cargo/ | Create a new Cargo package
*PackagesApi* | [**packages_upload_cocoapods**](docs/PackagesApi.md#packages_upload_cocoapods) | **POST** /packages/{owner}/{repo}/upload/cocoapods/ | Create a new CocoaPods package
*PackagesApi* | [**packages_upload_composer**](docs/PackagesApi.md#packages_upload_composer) | **POST** /packages/{owner}/{repo}/upload/composer/ | Create a new Composer package
*PackagesApi* | [**packages_upload_conan**](docs/PackagesApi.md#packages_upload_conan) | **POST** /packages/{owner}/{repo}/upload/conan/ | Create a new Conan package
*PackagesApi* | [**packages_upload_conda**](docs/PackagesApi.md#packages_upload_conda) | **POST** /packages/{owner}/{repo}/upload/conda/ | Create a new Conda package
*PackagesApi* | [**packages_upload_cran**](docs/PackagesApi.md#packages_upload_cran) | **POST** /packages/{owner}/{repo}/upload/cran/ | Create a new CRAN package
*PackagesApi* | [**packages_upload_dart**](docs/PackagesApi.md#packages_upload_dart) | **POST** /packages/{owner}/{repo}/upload/dart/ | Create a new Dart package
*PackagesApi* | [**packages_upload_deb**](docs/PackagesApi.md#packages_upload_deb) | **POST** /packages/{owner}/{repo}/upload/deb/ | Create a new Debian package
*PackagesApi* | [**packages_upload_docker**](docs/PackagesApi.md#packages_upload_docker) | **POST** /packages/{owner}/{repo}/upload/docker/ | Create a new Docker package
*PackagesApi* | [**packages_upload_go**](docs/PackagesApi.md#packages_upload_go) | **POST** /packages/{owner}/{repo}/upload/go/ | Create a new Go package
*PackagesApi* | [**packages_upload_helm**](docs/PackagesApi.md#packages_upload_helm) | **POST** /packages/{owner}/{repo}/upload/helm/ | Create a new Helm package
*PackagesApi* | [**packages_upload_hex**](docs/PackagesApi.md#packages_upload_hex) | **POST** /packages/{owner}/{repo}/upload/hex/ | Create a new Hex package
*PackagesApi* | [**packages_upload_luarocks**](docs/PackagesApi.md#packages_upload_luarocks) | **POST** /packages/{owner}/{repo}/upload/luarocks/ | Create a new LuaRocks package
*PackagesApi* | [**packages_upload_maven**](docs/PackagesApi.md#packages_upload_maven) | **POST** /packages/{owner}/{repo}/upload/maven/ | Create a new Maven package
*PackagesApi* | [**packages_upload_npm**](docs/PackagesApi.md#packages_upload_npm) | **POST** /packages/{owner}/{repo}/upload/npm/ | Create a new npm package
*PackagesApi* | [**packages_upload_nuget**](docs/PackagesApi.md#packages_upload_nuget) | **POST** /packages/{owner}/{repo}/upload/nuget/ | Create a new NuGet package
*PackagesApi* | [**packages_upload_p2**](docs/PackagesApi.md#packages_upload_p2) | **POST** /packages/{owner}/{repo}/upload/p2/ | Create a new P2 package
*PackagesApi* | [**packages_upload_python**](docs/PackagesApi.md#packages_upload_python) | **POST** /packages/{owner}/{repo}/upload/python/ | Create a new Python package
*PackagesApi* | [**packages_upload_raw**](docs/PackagesApi.md#packages_upload_raw) | **POST** /packages/{owner}/{repo}/upload/raw/ | Create a new Raw package
*PackagesApi* | [**packages_upload_rpm**](docs/PackagesApi.md#packages_upload_rpm) | **POST** /packages/{owner}/{repo}/upload/rpm/ | Create a new RedHat package
*PackagesApi* | [**packages_upload_ruby**](docs/PackagesApi.md#packages_upload_ruby) | **POST** /packages/{owner}/{repo}/upload/ruby/ | Create a new Ruby package
*PackagesApi* | [**packages_upload_swift**](docs/PackagesApi.md#packages_upload_swift) | **POST** /packages/{owner}/{repo}/upload/swift/ | Create a new Swift package
*PackagesApi* | [**packages_upload_terraform**](docs/PackagesApi.md#packages_upload_terraform) | **POST** /packages/{owner}/{repo}/upload/terraform/ | Create a new Terraform package
*PackagesApi* | [**packages_upload_vagrant**](docs/PackagesApi.md#packages_upload_vagrant) | **POST** /packages/{owner}/{repo}/upload/vagrant/ | Create a new Vagrant package
*PackagesApi* | [**packages_validate_upload_alpine**](docs/PackagesApi.md#packages_validate_upload_alpine) | **POST** /packages/{owner}/{repo}/validate-upload/alpine/ | Validate parameters for create Alpine package
*PackagesApi* | [**packages_validate_upload_cargo**](docs/PackagesApi.md#packages_validate_upload_cargo) | **POST** /packages/{owner}/{repo}/validate-upload/cargo/ | Validate parameters for create Cargo package
*PackagesApi* | [**packages_validate_upload_cocoapods**](docs/PackagesApi.md#packages_validate_upload_cocoapods) | **POST** /packages/{owner}/{repo}/validate-upload/cocoapods/ | Validate parameters for create CocoaPods package
*PackagesApi* | [**packages_validate_upload_composer**](docs/PackagesApi.md#packages_validate_upload_composer) | **POST** /packages/{owner}/{repo}/validate-upload/composer/ | Validate parameters for create Composer package
*PackagesApi* | [**packages_validate_upload_conan**](docs/PackagesApi.md#packages_validate_upload_conan) | **POST** /packages/{owner}/{repo}/validate-upload/conan/ | Validate parameters for create Conan package
*PackagesApi* | [**packages_validate_upload_conda**](docs/PackagesApi.md#packages_validate_upload_conda) | **POST** /packages/{owner}/{repo}/validate-upload/conda/ | Validate parameters for create Conda package
*PackagesApi* | [**packages_validate_upload_cran**](docs/PackagesApi.md#packages_validate_upload_cran) | **POST** /packages/{owner}/{repo}/validate-upload/cran/ | Validate parameters for create CRAN package
*PackagesApi* | [**packages_validate_upload_dart**](docs/PackagesApi.md#packages_validate_upload_dart) | **POST** /packages/{owner}/{repo}/validate-upload/dart/ | Validate parameters for create Dart package
*PackagesApi* | [**packages_validate_upload_deb**](docs/PackagesApi.md#packages_validate_upload_deb) | **POST** /packages/{owner}/{repo}/validate-upload/deb/ | Validate parameters for create Debian package
*PackagesApi* | [**packages_validate_upload_docker**](docs/PackagesApi.md#packages_validate_upload_docker) | **POST** /packages/{owner}/{repo}/validate-upload/docker/ | Validate parameters for create Docker package
*PackagesApi* | [**packages_validate_upload_go**](docs/PackagesApi.md#packages_validate_upload_go) | **POST** /packages/{owner}/{repo}/validate-upload/go/ | Validate parameters for create Go package
*PackagesApi* | [**packages_validate_upload_helm**](docs/PackagesApi.md#packages_validate_upload_helm) | **POST** /packages/{owner}/{repo}/validate-upload/helm/ | Validate parameters for create Helm package
*PackagesApi* | [**packages_validate_upload_hex**](docs/PackagesApi.md#packages_validate_upload_hex) | **POST** /packages/{owner}/{repo}/validate-upload/hex/ | Validate parameters for create Hex package
*PackagesApi* | [**packages_validate_upload_luarocks**](docs/PackagesApi.md#packages_validate_upload_luarocks) | **POST** /packages/{owner}/{repo}/validate-upload/luarocks/ | Validate parameters for create LuaRocks package
*PackagesApi* | [**packages_validate_upload_maven**](docs/PackagesApi.md#packages_validate_upload_maven) | **POST** /packages/{owner}/{repo}/validate-upload/maven/ | Validate parameters for create Maven package
*PackagesApi* | [**packages_validate_upload_npm**](docs/PackagesApi.md#packages_validate_upload_npm) | **POST** /packages/{owner}/{repo}/validate-upload/npm/ | Validate parameters for create npm package
*PackagesApi* | [**packages_validate_upload_nuget**](docs/PackagesApi.md#packages_validate_upload_nuget) | **POST** /packages/{owner}/{repo}/validate-upload/nuget/ | Validate parameters for create NuGet package
*PackagesApi* | [**packages_validate_upload_p2**](docs/PackagesApi.md#packages_validate_upload_p2) | **POST** /packages/{owner}/{repo}/validate-upload/p2/ | Validate parameters for create P2 package
*PackagesApi* | [**packages_validate_upload_python**](docs/PackagesApi.md#packages_validate_upload_python) | **POST** /packages/{owner}/{repo}/validate-upload/python/ | Validate parameters for create Python package
*PackagesApi* | [**packages_validate_upload_raw**](docs/PackagesApi.md#packages_validate_upload_raw) | **POST** /packages/{owner}/{repo}/validate-upload/raw/ | Validate parameters for create Raw package
*PackagesApi* | [**packages_validate_upload_rpm**](docs/PackagesApi.md#packages_validate_upload_rpm) | **POST** /packages/{owner}/{repo}/validate-upload/rpm/ | Validate parameters for create RedHat package
*PackagesApi* | [**packages_validate_upload_ruby**](docs/PackagesApi.md#packages_validate_upload_ruby) | **POST** /packages/{owner}/{repo}/validate-upload/ruby/ | Validate parameters for create Ruby package
*PackagesApi* | [**packages_validate_upload_swift**](docs/PackagesApi.md#packages_validate_upload_swift) | **POST** /packages/{owner}/{repo}/validate-upload/swift/ | Validate parameters for create Swift package
*PackagesApi* | [**packages_validate_upload_terraform**](docs/PackagesApi.md#packages_validate_upload_terraform) | **POST** /packages/{owner}/{repo}/validate-upload/terraform/ | Validate parameters for create Terraform package
*PackagesApi* | [**packages_validate_upload_vagrant**](docs/PackagesApi.md#packages_validate_upload_vagrant) | **POST** /packages/{owner}/{repo}/validate-upload/vagrant/ | Validate parameters for create Vagrant package
*QuotaApi* | [**quota_history_read**](docs/QuotaApi.md#quota_history_read) | **GET** /quota/history/{owner}/ | Quota history for a given namespace.
*QuotaApi* | [**quota_oss_history_read**](docs/QuotaApi.md#quota_oss_history_read) | **GET** /quota/oss/history/{owner}/ | Open-source Quota history for a given namespace.
*QuotaApi* | [**quota_oss_read**](docs/QuotaApi.md#quota_oss_read) | **GET** /quota/oss/{owner}/ | Open-source Quota usage for a given namespace.
*QuotaApi* | [**quota_read**](docs/QuotaApi.md#quota_read) | **GET** /quota/{owner}/ | Quota usage for a given namespace.
*RatesApi* | [**rates_limits_list**](docs/RatesApi.md#rates_limits_list) | **GET** /rates/limits/ | Endpoint to check rate limits for current user.
*ReposApi* | [**api_repos_geoip_status**](docs/ReposApi.md#api_repos_geoip_status) | **GET** /repos/{owner}/{identifier}/geoip/status/ | Retrieve the GeoIP status for this repository.
*ReposApi* | [**repo_retention_partial_update**](docs/ReposApi.md#repo_retention_partial_update) | **PATCH** /repos/{owner}/{repo}/retention/ | Update the retention rules for the repository.
*ReposApi* | [**repo_retention_read**](docs/ReposApi.md#repo_retention_read) | **GET** /repos/{owner}/{repo}/retention/ | Retrieve the retention rules for the repository.
*ReposApi* | [**repos_create**](docs/ReposApi.md#repos_create) | **POST** /repos/{owner}/ | Create a new repository in a given namespace.
*ReposApi* | [**repos_delete**](docs/ReposApi.md#repos_delete) | **DELETE** /repos/{owner}/{identifier}/ | Delete a repository in a given namespace.
*ReposApi* | [**repos_ecdsa_create**](docs/ReposApi.md#repos_ecdsa_create) | **POST** /repos/{owner}/{identifier}/ecdsa/ | Set the active ECDSA key for the Repository.
*ReposApi* | [**repos_ecdsa_list**](docs/ReposApi.md#repos_ecdsa_list) | **GET** /repos/{owner}/{identifier}/ecdsa/ | Retrieve the active ECDSA key for the Repository.
*ReposApi* | [**repos_ecdsa_regenerate**](docs/ReposApi.md#repos_ecdsa_regenerate) | **POST** /repos/{owner}/{identifier}/ecdsa/regenerate/ | Regenerate ECDSA Key for the Repository.
*ReposApi* | [**repos_geoip_disable**](docs/ReposApi.md#repos_geoip_disable) | **POST** /repos/{owner}/{identifier}/geoip/disable/ | Disable GeoIP for this repository.
*ReposApi* | [**repos_geoip_enable**](docs/ReposApi.md#repos_geoip_enable) | **POST** /repos/{owner}/{identifier}/geoip/enable/ | Enable GeoIP for this repository.
*ReposApi* | [**repos_geoip_partial_update**](docs/ReposApi.md#repos_geoip_partial_update) | **PATCH** /repos/{owner}/{identifier}/geoip | Partially update repository geoip rules.
*ReposApi* | [**repos_geoip_read**](docs/ReposApi.md#repos_geoip_read) | **GET** /repos/{owner}/{identifier}/geoip | List all repository geoip rules.
*ReposApi* | [**repos_geoip_test**](docs/ReposApi.md#repos_geoip_test) | **POST** /repos/{owner}/{identifier}/geoip/test/ | Test a list of IP addresses against the repository&#39;s current GeoIP rules.
*ReposApi* | [**repos_geoip_update**](docs/ReposApi.md#repos_geoip_update) | **PUT** /repos/{owner}/{identifier}/geoip | Replace repository geoip rules.
*ReposApi* | [**repos_gpg_create**](docs/ReposApi.md#repos_gpg_create) | **POST** /repos/{owner}/{identifier}/gpg/ | Set the active GPG key for the Repository.
*ReposApi* | [**repos_gpg_list**](docs/ReposApi.md#repos_gpg_list) | **GET** /repos/{owner}/{identifier}/gpg/ | Retrieve the active GPG key for the Repository.
*ReposApi* | [**repos_gpg_regenerate**](docs/ReposApi.md#repos_gpg_regenerate) | **POST** /repos/{owner}/{identifier}/gpg/regenerate/ | Regenerate GPG Key for the Repository.
*ReposApi* | [**repos_namespace_list**](docs/ReposApi.md#repos_namespace_list) | **GET** /repos/{owner}/ | Get a list of all repositories within a namespace.
*ReposApi* | [**repos_partial_update**](docs/ReposApi.md#repos_partial_update) | **PATCH** /repos/{owner}/{identifier}/ | Update details about a repository in a given namespace.
*ReposApi* | [**repos_privileges_list**](docs/ReposApi.md#repos_privileges_list) | **GET** /repos/{owner}/{identifier}/privileges | List all explicity created privileges for the repository.
*ReposApi* | [**repos_privileges_partial_update**](docs/ReposApi.md#repos_privileges_partial_update) | **PATCH** /repos/{owner}/{identifier}/privileges | Modify privileges for the repository.
*ReposApi* | [**repos_privileges_update**](docs/ReposApi.md#repos_privileges_update) | **PUT** /repos/{owner}/{identifier}/privileges | Replace all existing repository privileges with those specified.
*ReposApi* | [**repos_read**](docs/ReposApi.md#repos_read) | **GET** /repos/{owner}/{identifier}/ | Get a specific repository.
*ReposApi* | [**repos_rsa_create**](docs/ReposApi.md#repos_rsa_create) | **POST** /repos/{owner}/{identifier}/rsa/ | Set the active RSA key for the Repository.
*ReposApi* | [**repos_rsa_list**](docs/ReposApi.md#repos_rsa_list) | **GET** /repos/{owner}/{identifier}/rsa/ | Retrieve the active RSA key for the Repository.
*ReposApi* | [**repos_rsa_regenerate**](docs/ReposApi.md#repos_rsa_regenerate) | **POST** /repos/{owner}/{identifier}/rsa/regenerate/ | Regenerate RSA Key for the Repository.
*ReposApi* | [**repos_transfer_region**](docs/ReposApi.md#repos_transfer_region) | **POST** /repos/{owner}/{repo}/transfer-region/ | Transfer a repository to a different region.
*ReposApi* | [**repos_upstream_cargo_create**](docs/ReposApi.md#repos_upstream_cargo_create) | **POST** /repos/{owner}/{identifier}/upstream/cargo/ | Create a Cargo upstream config for this repository.
*ReposApi* | [**repos_upstream_cargo_delete**](docs/ReposApi.md#repos_upstream_cargo_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/ | Delete a Cargo upstream config for this repository.
*ReposApi* | [**repos_upstream_cargo_list**](docs/ReposApi.md#repos_upstream_cargo_list) | **GET** /repos/{owner}/{identifier}/upstream/cargo/ | List Cargo upstream configs for this repository.
*ReposApi* | [**repos_upstream_cargo_partial_update**](docs/ReposApi.md#repos_upstream_cargo_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/ | Partially update a Cargo upstream config for this repository.
*ReposApi* | [**repos_upstream_cargo_read**](docs/ReposApi.md#repos_upstream_cargo_read) | **GET** /repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/ | Retrieve a Cargo upstream config for this repository.
*ReposApi* | [**repos_upstream_cargo_update**](docs/ReposApi.md#repos_upstream_cargo_update) | **PUT** /repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/ | Update a Cargo upstream config for this repository.
*ReposApi* | [**repos_upstream_composer_create**](docs/ReposApi.md#repos_upstream_composer_create) | **POST** /repos/{owner}/{identifier}/upstream/composer/ | Create a Composer upstream config for this repository.
*ReposApi* | [**repos_upstream_composer_delete**](docs/ReposApi.md#repos_upstream_composer_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/composer/{slug_perm}/ | Delete a Composer upstream config for this repository.
*ReposApi* | [**repos_upstream_composer_list**](docs/ReposApi.md#repos_upstream_composer_list) | **GET** /repos/{owner}/{identifier}/upstream/composer/ | List Composer upstream configs for this repository.
*ReposApi* | [**repos_upstream_composer_partial_update**](docs/ReposApi.md#repos_upstream_composer_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/composer/{slug_perm}/ | Partially update a Composer upstream config for this repository.
*ReposApi* | [**repos_upstream_composer_read**](docs/ReposApi.md#repos_upstream_composer_read) | **GET** /repos/{owner}/{identifier}/upstream/composer/{slug_perm}/ | Retrieve a Composer upstream config for this repository.
*ReposApi* | [**repos_upstream_composer_update**](docs/ReposApi.md#repos_upstream_composer_update) | **PUT** /repos/{owner}/{identifier}/upstream/composer/{slug_perm}/ | Update a Composer upstream config for this repository.
*ReposApi* | [**repos_upstream_cran_create**](docs/ReposApi.md#repos_upstream_cran_create) | **POST** /repos/{owner}/{identifier}/upstream/cran/ | Create a CRAN upstream config for this repository.
*ReposApi* | [**repos_upstream_cran_delete**](docs/ReposApi.md#repos_upstream_cran_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/cran/{slug_perm}/ | Delete a CRAN upstream config for this repository.
*ReposApi* | [**repos_upstream_cran_list**](docs/ReposApi.md#repos_upstream_cran_list) | **GET** /repos/{owner}/{identifier}/upstream/cran/ | List CRAN upstream configs for this repository.
*ReposApi* | [**repos_upstream_cran_partial_update**](docs/ReposApi.md#repos_upstream_cran_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/cran/{slug_perm}/ | Partially update a CRAN upstream config for this repository.
*ReposApi* | [**repos_upstream_cran_read**](docs/ReposApi.md#repos_upstream_cran_read) | **GET** /repos/{owner}/{identifier}/upstream/cran/{slug_perm}/ | Retrieve a CRAN upstream config for this repository.
*ReposApi* | [**repos_upstream_cran_update**](docs/ReposApi.md#repos_upstream_cran_update) | **PUT** /repos/{owner}/{identifier}/upstream/cran/{slug_perm}/ | Update a CRAN upstream config for this repository.
*ReposApi* | [**repos_upstream_dart_create**](docs/ReposApi.md#repos_upstream_dart_create) | **POST** /repos/{owner}/{identifier}/upstream/dart/ | Create a Dart upstream config for this repository.
*ReposApi* | [**repos_upstream_dart_delete**](docs/ReposApi.md#repos_upstream_dart_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/dart/{slug_perm}/ | Delete a Dart upstream config for this repository.
*ReposApi* | [**repos_upstream_dart_list**](docs/ReposApi.md#repos_upstream_dart_list) | **GET** /repos/{owner}/{identifier}/upstream/dart/ | List Dart upstream configs for this repository.
*ReposApi* | [**repos_upstream_dart_partial_update**](docs/ReposApi.md#repos_upstream_dart_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/dart/{slug_perm}/ | Partially update a Dart upstream config for this repository.
*ReposApi* | [**repos_upstream_dart_read**](docs/ReposApi.md#repos_upstream_dart_read) | **GET** /repos/{owner}/{identifier}/upstream/dart/{slug_perm}/ | Retrieve a Dart upstream config for this repository.
*ReposApi* | [**repos_upstream_dart_update**](docs/ReposApi.md#repos_upstream_dart_update) | **PUT** /repos/{owner}/{identifier}/upstream/dart/{slug_perm}/ | Update a Dart upstream config for this repository.
*ReposApi* | [**repos_upstream_deb_create**](docs/ReposApi.md#repos_upstream_deb_create) | **POST** /repos/{owner}/{identifier}/upstream/deb/ | Create a Debian upstream config for this repository.
*ReposApi* | [**repos_upstream_deb_delete**](docs/ReposApi.md#repos_upstream_deb_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/deb/{slug_perm}/ | Delete a Debian upstream config for this repository.
*ReposApi* | [**repos_upstream_deb_list**](docs/ReposApi.md#repos_upstream_deb_list) | **GET** /repos/{owner}/{identifier}/upstream/deb/ | List Debian upstream configs for this repository.
*ReposApi* | [**repos_upstream_deb_partial_update**](docs/ReposApi.md#repos_upstream_deb_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/deb/{slug_perm}/ | Partially update a Debian upstream config for this repository.
*ReposApi* | [**repos_upstream_deb_read**](docs/ReposApi.md#repos_upstream_deb_read) | **GET** /repos/{owner}/{identifier}/upstream/deb/{slug_perm}/ | Retrieve a Debian upstream config for this repository.
*ReposApi* | [**repos_upstream_deb_update**](docs/ReposApi.md#repos_upstream_deb_update) | **PUT** /repos/{owner}/{identifier}/upstream/deb/{slug_perm}/ | Update a Debian upstream config for this repository.
*ReposApi* | [**repos_upstream_docker_create**](docs/ReposApi.md#repos_upstream_docker_create) | **POST** /repos/{owner}/{identifier}/upstream/docker/ | Create a Docker upstream config for this repository.
*ReposApi* | [**repos_upstream_docker_delete**](docs/ReposApi.md#repos_upstream_docker_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/docker/{slug_perm}/ | Delete a Docker upstream config for this repository.
*ReposApi* | [**repos_upstream_docker_list**](docs/ReposApi.md#repos_upstream_docker_list) | **GET** /repos/{owner}/{identifier}/upstream/docker/ | List Docker upstream configs for this repository.
*ReposApi* | [**repos_upstream_docker_partial_update**](docs/ReposApi.md#repos_upstream_docker_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/docker/{slug_perm}/ | Partially update a Docker upstream config for this repository.
*ReposApi* | [**repos_upstream_docker_read**](docs/ReposApi.md#repos_upstream_docker_read) | **GET** /repos/{owner}/{identifier}/upstream/docker/{slug_perm}/ | Retrieve a Docker upstream config for this repository.
*ReposApi* | [**repos_upstream_docker_update**](docs/ReposApi.md#repos_upstream_docker_update) | **PUT** /repos/{owner}/{identifier}/upstream/docker/{slug_perm}/ | Update a Docker upstream config for this repository.
*ReposApi* | [**repos_upstream_go_create**](docs/ReposApi.md#repos_upstream_go_create) | **POST** /repos/{owner}/{identifier}/upstream/go/ | Create a Go upstream config for this repository.
*ReposApi* | [**repos_upstream_go_delete**](docs/ReposApi.md#repos_upstream_go_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/go/{slug_perm}/ | Delete a Go upstream config for this repository.
*ReposApi* | [**repos_upstream_go_list**](docs/ReposApi.md#repos_upstream_go_list) | **GET** /repos/{owner}/{identifier}/upstream/go/ | List Go upstream configs for this repository.
*ReposApi* | [**repos_upstream_go_partial_update**](docs/ReposApi.md#repos_upstream_go_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/go/{slug_perm}/ | Partially update a Go upstream config for this repository.
*ReposApi* | [**repos_upstream_go_read**](docs/ReposApi.md#repos_upstream_go_read) | **GET** /repos/{owner}/{identifier}/upstream/go/{slug_perm}/ | Retrieve a Go upstream config for this repository.
*ReposApi* | [**repos_upstream_go_update**](docs/ReposApi.md#repos_upstream_go_update) | **PUT** /repos/{owner}/{identifier}/upstream/go/{slug_perm}/ | Update a Go upstream config for this repository.
*ReposApi* | [**repos_upstream_helm_create**](docs/ReposApi.md#repos_upstream_helm_create) | **POST** /repos/{owner}/{identifier}/upstream/helm/ | Create a Helm upstream config for this repository.
*ReposApi* | [**repos_upstream_helm_delete**](docs/ReposApi.md#repos_upstream_helm_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/helm/{slug_perm}/ | Delete a Helm upstream config for this repository.
*ReposApi* | [**repos_upstream_helm_list**](docs/ReposApi.md#repos_upstream_helm_list) | **GET** /repos/{owner}/{identifier}/upstream/helm/ | List Helm upstream configs for this repository.
*ReposApi* | [**repos_upstream_helm_partial_update**](docs/ReposApi.md#repos_upstream_helm_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/helm/{slug_perm}/ | Partially update a Helm upstream config for this repository.
*ReposApi* | [**repos_upstream_helm_read**](docs/ReposApi.md#repos_upstream_helm_read) | **GET** /repos/{owner}/{identifier}/upstream/helm/{slug_perm}/ | Retrieve a Helm upstream config for this repository.
*ReposApi* | [**repos_upstream_helm_update**](docs/ReposApi.md#repos_upstream_helm_update) | **PUT** /repos/{owner}/{identifier}/upstream/helm/{slug_perm}/ | Update a Helm upstream config for this repository.
*ReposApi* | [**repos_upstream_hex_create**](docs/ReposApi.md#repos_upstream_hex_create) | **POST** /repos/{owner}/{identifier}/upstream/hex/ | Create a Hex upstream config for this repository.
*ReposApi* | [**repos_upstream_hex_delete**](docs/ReposApi.md#repos_upstream_hex_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/hex/{slug_perm}/ | Delete a Hex upstream config for this repository.
*ReposApi* | [**repos_upstream_hex_list**](docs/ReposApi.md#repos_upstream_hex_list) | **GET** /repos/{owner}/{identifier}/upstream/hex/ | List Hex upstream configs for this repository.
*ReposApi* | [**repos_upstream_hex_partial_update**](docs/ReposApi.md#repos_upstream_hex_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/hex/{slug_perm}/ | Partially update a Hex upstream config for this repository.
*ReposApi* | [**repos_upstream_hex_read**](docs/ReposApi.md#repos_upstream_hex_read) | **GET** /repos/{owner}/{identifier}/upstream/hex/{slug_perm}/ | Retrieve a Hex upstream config for this repository.
*ReposApi* | [**repos_upstream_hex_update**](docs/ReposApi.md#repos_upstream_hex_update) | **PUT** /repos/{owner}/{identifier}/upstream/hex/{slug_perm}/ | Update a Hex upstream config for this repository.
*ReposApi* | [**repos_upstream_maven_create**](docs/ReposApi.md#repos_upstream_maven_create) | **POST** /repos/{owner}/{identifier}/upstream/maven/ | Create a Maven upstream config for this repository.
*ReposApi* | [**repos_upstream_maven_delete**](docs/ReposApi.md#repos_upstream_maven_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/maven/{slug_perm}/ | Delete a Maven upstream config for this repository.
*ReposApi* | [**repos_upstream_maven_list**](docs/ReposApi.md#repos_upstream_maven_list) | **GET** /repos/{owner}/{identifier}/upstream/maven/ | List Maven upstream configs for this repository.
*ReposApi* | [**repos_upstream_maven_partial_update**](docs/ReposApi.md#repos_upstream_maven_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/maven/{slug_perm}/ | Partially update a Maven upstream config for this repository.
*ReposApi* | [**repos_upstream_maven_read**](docs/ReposApi.md#repos_upstream_maven_read) | **GET** /repos/{owner}/{identifier}/upstream/maven/{slug_perm}/ | Retrieve a Maven upstream config for this repository.
*ReposApi* | [**repos_upstream_maven_update**](docs/ReposApi.md#repos_upstream_maven_update) | **PUT** /repos/{owner}/{identifier}/upstream/maven/{slug_perm}/ | Update a Maven upstream config for this repository.
*ReposApi* | [**repos_upstream_npm_create**](docs/ReposApi.md#repos_upstream_npm_create) | **POST** /repos/{owner}/{identifier}/upstream/npm/ | Create a npm upstream config for this repository.
*ReposApi* | [**repos_upstream_npm_delete**](docs/ReposApi.md#repos_upstream_npm_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/npm/{slug_perm}/ | Delete a npm upstream config for this repository.
*ReposApi* | [**repos_upstream_npm_list**](docs/ReposApi.md#repos_upstream_npm_list) | **GET** /repos/{owner}/{identifier}/upstream/npm/ | List npm upstream configs for this repository.
*ReposApi* | [**repos_upstream_npm_partial_update**](docs/ReposApi.md#repos_upstream_npm_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/npm/{slug_perm}/ | Partially update a npm upstream config for this repository.
*ReposApi* | [**repos_upstream_npm_read**](docs/ReposApi.md#repos_upstream_npm_read) | **GET** /repos/{owner}/{identifier}/upstream/npm/{slug_perm}/ | Retrieve a npm upstream config for this repository.
*ReposApi* | [**repos_upstream_npm_update**](docs/ReposApi.md#repos_upstream_npm_update) | **PUT** /repos/{owner}/{identifier}/upstream/npm/{slug_perm}/ | Update a npm upstream config for this repository.
*ReposApi* | [**repos_upstream_nuget_create**](docs/ReposApi.md#repos_upstream_nuget_create) | **POST** /repos/{owner}/{identifier}/upstream/nuget/ | Create a NuGet upstream config for this repository.
*ReposApi* | [**repos_upstream_nuget_delete**](docs/ReposApi.md#repos_upstream_nuget_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/ | Delete a NuGet upstream config for this repository.
*ReposApi* | [**repos_upstream_nuget_list**](docs/ReposApi.md#repos_upstream_nuget_list) | **GET** /repos/{owner}/{identifier}/upstream/nuget/ | List NuGet upstream configs for this repository.
*ReposApi* | [**repos_upstream_nuget_partial_update**](docs/ReposApi.md#repos_upstream_nuget_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/ | Partially update a NuGet upstream config for this repository.
*ReposApi* | [**repos_upstream_nuget_read**](docs/ReposApi.md#repos_upstream_nuget_read) | **GET** /repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/ | Retrieve a NuGet upstream config for this repository.
*ReposApi* | [**repos_upstream_nuget_update**](docs/ReposApi.md#repos_upstream_nuget_update) | **PUT** /repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/ | Update a NuGet upstream config for this repository.
*ReposApi* | [**repos_upstream_python_create**](docs/ReposApi.md#repos_upstream_python_create) | **POST** /repos/{owner}/{identifier}/upstream/python/ | Create a Python upstream config for this repository.
*ReposApi* | [**repos_upstream_python_delete**](docs/ReposApi.md#repos_upstream_python_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/python/{slug_perm}/ | Delete a Python upstream config for this repository.
*ReposApi* | [**repos_upstream_python_list**](docs/ReposApi.md#repos_upstream_python_list) | **GET** /repos/{owner}/{identifier}/upstream/python/ | List Python upstream configs for this repository.
*ReposApi* | [**repos_upstream_python_partial_update**](docs/ReposApi.md#repos_upstream_python_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/python/{slug_perm}/ | Partially update a Python upstream config for this repository.
*ReposApi* | [**repos_upstream_python_read**](docs/ReposApi.md#repos_upstream_python_read) | **GET** /repos/{owner}/{identifier}/upstream/python/{slug_perm}/ | Retrieve a Python upstream config for this repository.
*ReposApi* | [**repos_upstream_python_update**](docs/ReposApi.md#repos_upstream_python_update) | **PUT** /repos/{owner}/{identifier}/upstream/python/{slug_perm}/ | Update a Python upstream config for this repository.
*ReposApi* | [**repos_upstream_rpm_create**](docs/ReposApi.md#repos_upstream_rpm_create) | **POST** /repos/{owner}/{identifier}/upstream/rpm/ | Create a RedHat upstream config for this repository.
*ReposApi* | [**repos_upstream_rpm_delete**](docs/ReposApi.md#repos_upstream_rpm_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/ | Delete a RedHat upstream config for this repository.
*ReposApi* | [**repos_upstream_rpm_list**](docs/ReposApi.md#repos_upstream_rpm_list) | **GET** /repos/{owner}/{identifier}/upstream/rpm/ | List RedHat upstream configs for this repository.
*ReposApi* | [**repos_upstream_rpm_partial_update**](docs/ReposApi.md#repos_upstream_rpm_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/ | Partially update a RedHat upstream config for this repository.
*ReposApi* | [**repos_upstream_rpm_read**](docs/ReposApi.md#repos_upstream_rpm_read) | **GET** /repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/ | Retrieve a RedHat upstream config for this repository.
*ReposApi* | [**repos_upstream_rpm_update**](docs/ReposApi.md#repos_upstream_rpm_update) | **PUT** /repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/ | Update a RedHat upstream config for this repository.
*ReposApi* | [**repos_upstream_ruby_create**](docs/ReposApi.md#repos_upstream_ruby_create) | **POST** /repos/{owner}/{identifier}/upstream/ruby/ | Create a Ruby upstream config for this repository.
*ReposApi* | [**repos_upstream_ruby_delete**](docs/ReposApi.md#repos_upstream_ruby_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/ | Delete a Ruby upstream config for this repository.
*ReposApi* | [**repos_upstream_ruby_list**](docs/ReposApi.md#repos_upstream_ruby_list) | **GET** /repos/{owner}/{identifier}/upstream/ruby/ | List Ruby upstream configs for this repository.
*ReposApi* | [**repos_upstream_ruby_partial_update**](docs/ReposApi.md#repos_upstream_ruby_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/ | Partially update a Ruby upstream config for this repository.
*ReposApi* | [**repos_upstream_ruby_read**](docs/ReposApi.md#repos_upstream_ruby_read) | **GET** /repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/ | Retrieve a Ruby upstream config for this repository.
*ReposApi* | [**repos_upstream_ruby_update**](docs/ReposApi.md#repos_upstream_ruby_update) | **PUT** /repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/ | Update a Ruby upstream config for this repository.
*ReposApi* | [**repos_upstream_swift_create**](docs/ReposApi.md#repos_upstream_swift_create) | **POST** /repos/{owner}/{identifier}/upstream/swift/ | Create a Swift upstream config for this repository.
*ReposApi* | [**repos_upstream_swift_delete**](docs/ReposApi.md#repos_upstream_swift_delete) | **DELETE** /repos/{owner}/{identifier}/upstream/swift/{slug_perm}/ | Delete a Swift upstream config for this repository.
*ReposApi* | [**repos_upstream_swift_list**](docs/ReposApi.md#repos_upstream_swift_list) | **GET** /repos/{owner}/{identifier}/upstream/swift/ | List Swift upstream configs for this repository.
*ReposApi* | [**repos_upstream_swift_partial_update**](docs/ReposApi.md#repos_upstream_swift_partial_update) | **PATCH** /repos/{owner}/{identifier}/upstream/swift/{slug_perm}/ | Partially update a Swift upstream config for this repository.
*ReposApi* | [**repos_upstream_swift_read**](docs/ReposApi.md#repos_upstream_swift_read) | **GET** /repos/{owner}/{identifier}/upstream/swift/{slug_perm}/ | Retrieve a Swift upstream config for this repository.
*ReposApi* | [**repos_upstream_swift_update**](docs/ReposApi.md#repos_upstream_swift_update) | **PUT** /repos/{owner}/{identifier}/upstream/swift/{slug_perm}/ | Update a Swift upstream config for this repository.
*ReposApi* | [**repos_user_list**](docs/ReposApi.md#repos_user_list) | **GET** /repos/ | Get a list of all repositories associated with current user.
*ReposApi* | [**repos_x509_ecdsa_list**](docs/ReposApi.md#repos_x509_ecdsa_list) | **GET** /repos/{owner}/{identifier}/x509-ecdsa/ | Retrieve the active X.509 ECDSA certificate for the Repository.
*ReposApi* | [**repos_x509_rsa_list**](docs/ReposApi.md#repos_x509_rsa_list) | **GET** /repos/{owner}/{identifier}/x509-rsa/ | Retrieve the active X.509 RSA certificate for the Repository.
*StatusApi* | [**status_check_basic**](docs/StatusApi.md#status_check_basic) | **GET** /status/check/basic/ | Endpoint to check basic API connectivity.
*StorageRegionsApi* | [**storage_regions_list**](docs/StorageRegionsApi.md#storage_regions_list) | **GET** /storage-regions/ | Get a list of all available storage regions.
*StorageRegionsApi* | [**storage_regions_read**](docs/StorageRegionsApi.md#storage_regions_read) | **GET** /storage-regions/{slug}/ | Get a specific storage region.
*UserApi* | [**user_self**](docs/UserApi.md#user_self) | **GET** /user/self/ | Provide a brief for the current user (if any).
*UserApi* | [**user_token_create**](docs/UserApi.md#user_token_create) | **POST** /user/token/ | Create or retrieve API token for a user.
*UserApi* | [**user_tokens_create**](docs/UserApi.md#user_tokens_create) | **POST** /user/tokens/ | Create an API key for the user that is currently authenticated.
*UserApi* | [**user_tokens_list**](docs/UserApi.md#user_tokens_list) | **GET** /user/tokens/ | Retrieve the API key assigned to the user that is currently authenticated.
*UserApi* | [**user_tokens_refresh**](docs/UserApi.md#user_tokens_refresh) | **PUT** /user/tokens/{slug_perm}/refresh/ | Refresh the specified API key for the user that is currently authenticated.
*UsersApi* | [**users_profile_read**](docs/UsersApi.md#users_profile_read) | **GET** /users/profile/{slug}/ | Provide a brief for the specified user (if any).
*VulnerabilitiesApi* | [**vulnerabilities_namespace_list**](docs/VulnerabilitiesApi.md#vulnerabilities_namespace_list) | **GET** /vulnerabilities/{owner}/ | Lists scan results for a specific namespace.
*VulnerabilitiesApi* | [**vulnerabilities_package_list**](docs/VulnerabilitiesApi.md#vulnerabilities_package_list) | **GET** /vulnerabilities/{owner}/{repo}/{package}/ | Lists scan results for a specific package.
*VulnerabilitiesApi* | [**vulnerabilities_read**](docs/VulnerabilitiesApi.md#vulnerabilities_read) | **GET** /vulnerabilities/{owner}/{repo}/{package}/{identifier}/ | Get a scan result.
*VulnerabilitiesApi* | [**vulnerabilities_repo_list**](docs/VulnerabilitiesApi.md#vulnerabilities_repo_list) | **GET** /vulnerabilities/{owner}/{repo}/ | Lists scan results for a specific repository.
*WebhooksApi* | [**webhooks_create**](docs/WebhooksApi.md#webhooks_create) | **POST** /webhooks/{owner}/{repo}/ | Create a specific webhook in a repository.
*WebhooksApi* | [**webhooks_delete**](docs/WebhooksApi.md#webhooks_delete) | **DELETE** /webhooks/{owner}/{repo}/{identifier}/ | Delete a specific webhook in a repository.
*WebhooksApi* | [**webhooks_list**](docs/WebhooksApi.md#webhooks_list) | **GET** /webhooks/{owner}/{repo}/ | Get a list of all webhooks in a repository.
*WebhooksApi* | [**webhooks_partial_update**](docs/WebhooksApi.md#webhooks_partial_update) | **PATCH** /webhooks/{owner}/{repo}/{identifier}/ | Update a specific webhook in a repository.
*WebhooksApi* | [**webhooks_read**](docs/WebhooksApi.md#webhooks_read) | **GET** /webhooks/{owner}/{repo}/{identifier}/ | Views for working with repository webhooks.


## Documentation For Models

 - [AllocatedLimit](docs/AllocatedLimit.md)
 - [AllocatedLimitRaw](docs/AllocatedLimitRaw.md)
 - [AlpinePackageUpload](docs/AlpinePackageUpload.md)
 - [AlpinePackageUploadRequest](docs/AlpinePackageUploadRequest.md)
 - [Architecture](docs/Architecture.md)
 - [CargoPackageUpload](docs/CargoPackageUpload.md)
 - [CargoPackageUploadRequest](docs/CargoPackageUploadRequest.md)
 - [CargoUpstream](docs/CargoUpstream.md)
 - [CargoUpstreamRequest](docs/CargoUpstreamRequest.md)
 - [CargoUpstreamRequestPatch](docs/CargoUpstreamRequestPatch.md)
 - [CocoapodsPackageUpload](docs/CocoapodsPackageUpload.md)
 - [CocoapodsPackageUploadRequest](docs/CocoapodsPackageUploadRequest.md)
 - [CommonBandwidthMetrics](docs/CommonBandwidthMetrics.md)
 - [CommonBandwidthMetricsValue](docs/CommonBandwidthMetricsValue.md)
 - [CommonDownloadsMetrics](docs/CommonDownloadsMetrics.md)
 - [CommonDownloadsMetricsValue](docs/CommonDownloadsMetricsValue.md)
 - [CommonMetrics](docs/CommonMetrics.md)
 - [ComposerPackageUpload](docs/ComposerPackageUpload.md)
 - [ComposerPackageUploadRequest](docs/ComposerPackageUploadRequest.md)
 - [ComposerUpstream](docs/ComposerUpstream.md)
 - [ComposerUpstreamRequest](docs/ComposerUpstreamRequest.md)
 - [ComposerUpstreamRequestPatch](docs/ComposerUpstreamRequestPatch.md)
 - [ConanPackageUpload](docs/ConanPackageUpload.md)
 - [ConanPackageUploadRequest](docs/ConanPackageUploadRequest.md)
 - [CondaPackageUpload](docs/CondaPackageUpload.md)
 - [CondaPackageUploadRequest](docs/CondaPackageUploadRequest.md)
 - [CranPackageUpload](docs/CranPackageUpload.md)
 - [CranPackageUploadRequest](docs/CranPackageUploadRequest.md)
 - [CranUpstream](docs/CranUpstream.md)
 - [CranUpstreamRequest](docs/CranUpstreamRequest.md)
 - [CranUpstreamRequestPatch](docs/CranUpstreamRequestPatch.md)
 - [DartPackageUpload](docs/DartPackageUpload.md)
 - [DartPackageUploadRequest](docs/DartPackageUploadRequest.md)
 - [DartUpstream](docs/DartUpstream.md)
 - [DartUpstreamRequest](docs/DartUpstreamRequest.md)
 - [DartUpstreamRequestPatch](docs/DartUpstreamRequestPatch.md)
 - [DebPackageUpload](docs/DebPackageUpload.md)
 - [DebPackageUploadRequest](docs/DebPackageUploadRequest.md)
 - [DebUpstream](docs/DebUpstream.md)
 - [DebUpstreamRequest](docs/DebUpstreamRequest.md)
 - [DebUpstreamRequestPatch](docs/DebUpstreamRequestPatch.md)
 - [Distribution](docs/Distribution.md)
 - [DistributionFull](docs/DistributionFull.md)
 - [DistributionVersion](docs/DistributionVersion.md)
 - [DockerPackageUpload](docs/DockerPackageUpload.md)
 - [DockerPackageUploadRequest](docs/DockerPackageUploadRequest.md)
 - [DockerUpstream](docs/DockerUpstream.md)
 - [DockerUpstreamRequest](docs/DockerUpstreamRequest.md)
 - [DockerUpstreamRequestPatch](docs/DockerUpstreamRequestPatch.md)
 - [EntitlementUsageMetrics](docs/EntitlementUsageMetrics.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [Eula](docs/Eula.md)
 - [Format](docs/Format.md)
 - [FormatSupport](docs/FormatSupport.md)
 - [FormatSupportUpstream](docs/FormatSupportUpstream.md)
 - [GeoIpLocation](docs/GeoIpLocation.md)
 - [GoPackageUpload](docs/GoPackageUpload.md)
 - [GoPackageUploadRequest](docs/GoPackageUploadRequest.md)
 - [GoUpstream](docs/GoUpstream.md)
 - [GoUpstreamRequest](docs/GoUpstreamRequest.md)
 - [GoUpstreamRequestPatch](docs/GoUpstreamRequestPatch.md)
 - [HelmPackageUpload](docs/HelmPackageUpload.md)
 - [HelmPackageUploadRequest](docs/HelmPackageUploadRequest.md)
 - [HelmUpstream](docs/HelmUpstream.md)
 - [HelmUpstreamRequest](docs/HelmUpstreamRequest.md)
 - [HelmUpstreamRequestPatch](docs/HelmUpstreamRequestPatch.md)
 - [HexPackageUpload](docs/HexPackageUpload.md)
 - [HexPackageUploadRequest](docs/HexPackageUploadRequest.md)
 - [HexUpstream](docs/HexUpstream.md)
 - [HexUpstreamRequest](docs/HexUpstreamRequest.md)
 - [HexUpstreamRequestPatch](docs/HexUpstreamRequestPatch.md)
 - [History](docs/History.md)
 - [HistoryFieldset](docs/HistoryFieldset.md)
 - [HistoryFieldsetRaw](docs/HistoryFieldsetRaw.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [LuarocksPackageUpload](docs/LuarocksPackageUpload.md)
 - [LuarocksPackageUploadRequest](docs/LuarocksPackageUploadRequest.md)
 - [MavenPackageUpload](docs/MavenPackageUpload.md)
 - [MavenPackageUploadRequest](docs/MavenPackageUploadRequest.md)
 - [MavenUpstream](docs/MavenUpstream.md)
 - [MavenUpstreamRequest](docs/MavenUpstreamRequest.md)
 - [MavenUpstreamRequestPatch](docs/MavenUpstreamRequestPatch.md)
 - [Namespace](docs/Namespace.md)
 - [NamespaceAuditLog](docs/NamespaceAuditLog.md)
 - [NestedLicensePolicy](docs/NestedLicensePolicy.md)
 - [NestedVulnerabilityPolicy](docs/NestedVulnerabilityPolicy.md)
 - [NestedVulnerabilityScanResults](docs/NestedVulnerabilityScanResults.md)
 - [NpmPackageUpload](docs/NpmPackageUpload.md)
 - [NpmPackageUploadRequest](docs/NpmPackageUploadRequest.md)
 - [NpmUpstream](docs/NpmUpstream.md)
 - [NpmUpstreamRequest](docs/NpmUpstreamRequest.md)
 - [NpmUpstreamRequestPatch](docs/NpmUpstreamRequestPatch.md)
 - [NugetPackageUpload](docs/NugetPackageUpload.md)
 - [NugetPackageUploadRequest](docs/NugetPackageUploadRequest.md)
 - [NugetUpstream](docs/NugetUpstream.md)
 - [NugetUpstreamRequest](docs/NugetUpstreamRequest.md)
 - [NugetUpstreamRequestPatch](docs/NugetUpstreamRequestPatch.md)
 - [Organization](docs/Organization.md)
 - [OrganizationGroupSync](docs/OrganizationGroupSync.md)
 - [OrganizationGroupSyncRequest](docs/OrganizationGroupSyncRequest.md)
 - [OrganizationGroupSyncStatus](docs/OrganizationGroupSyncStatus.md)
 - [OrganizationInvite](docs/OrganizationInvite.md)
 - [OrganizationInviteExtend](docs/OrganizationInviteExtend.md)
 - [OrganizationInviteRequest](docs/OrganizationInviteRequest.md)
 - [OrganizationInviteUpdate](docs/OrganizationInviteUpdate.md)
 - [OrganizationInviteUpdateRequestPatch](docs/OrganizationInviteUpdateRequestPatch.md)
 - [OrganizationMembership](docs/OrganizationMembership.md)
 - [OrganizationMembershipRequestPatch](docs/OrganizationMembershipRequestPatch.md)
 - [OrganizationMembershipRoleUpdate](docs/OrganizationMembershipRoleUpdate.md)
 - [OrganizationMembershipRoleUpdateRequestPatch](docs/OrganizationMembershipRoleUpdateRequestPatch.md)
 - [OrganizationMembershipVisibilityUpdate](docs/OrganizationMembershipVisibilityUpdate.md)
 - [OrganizationMembershipVisibilityUpdateRequestPatch](docs/OrganizationMembershipVisibilityUpdateRequestPatch.md)
 - [OrganizationPackageLicensePolicy](docs/OrganizationPackageLicensePolicy.md)
 - [OrganizationPackageLicensePolicyRequest](docs/OrganizationPackageLicensePolicyRequest.md)
 - [OrganizationPackageLicensePolicyRequestPatch](docs/OrganizationPackageLicensePolicyRequestPatch.md)
 - [OrganizationPackageVulnerabilityPolicy](docs/OrganizationPackageVulnerabilityPolicy.md)
 - [OrganizationPackageVulnerabilityPolicyRequest](docs/OrganizationPackageVulnerabilityPolicyRequest.md)
 - [OrganizationPackageVulnerabilityPolicyRequestPatch](docs/OrganizationPackageVulnerabilityPolicyRequestPatch.md)
 - [OrganizationSAMLAuth](docs/OrganizationSAMLAuth.md)
 - [OrganizationSAMLAuthRequestPatch](docs/OrganizationSAMLAuthRequestPatch.md)
 - [OrganizationTeam](docs/OrganizationTeam.md)
 - [OrganizationTeamInvite](docs/OrganizationTeamInvite.md)
 - [OrganizationTeamMembers](docs/OrganizationTeamMembers.md)
 - [OrganizationTeamMembership](docs/OrganizationTeamMembership.md)
 - [OrganizationTeamRequest](docs/OrganizationTeamRequest.md)
 - [OrganizationTeamRequestPatch](docs/OrganizationTeamRequestPatch.md)
 - [P2PackageUpload](docs/P2PackageUpload.md)
 - [P2PackageUploadRequest](docs/P2PackageUploadRequest.md)
 - [Package](docs/Package.md)
 - [PackageCopy](docs/PackageCopy.md)
 - [PackageCopyRequest](docs/PackageCopyRequest.md)
 - [PackageDenyPolicy](docs/PackageDenyPolicy.md)
 - [PackageDenyPolicyRequest](docs/PackageDenyPolicyRequest.md)
 - [PackageDenyPolicyRequestPatch](docs/PackageDenyPolicyRequestPatch.md)
 - [PackageDependencies](docs/PackageDependencies.md)
 - [PackageDependency](docs/PackageDependency.md)
 - [PackageFile](docs/PackageFile.md)
 - [PackageFilePartsUpload](docs/PackageFilePartsUpload.md)
 - [PackageFileUpload](docs/PackageFileUpload.md)
 - [PackageFileUploadRequest](docs/PackageFileUploadRequest.md)
 - [PackageGroup](docs/PackageGroup.md)
 - [PackageLicensePolicyEvaluationRequest](docs/PackageLicensePolicyEvaluationRequest.md)
 - [PackageLicensePolicyEvaluationRequestRequest](docs/PackageLicensePolicyEvaluationRequestRequest.md)
 - [PackageLicensePolicyViolationLog](docs/PackageLicensePolicyViolationLog.md)
 - [PackageLicensePolicyViolationLogCursorPage](docs/PackageLicensePolicyViolationLogCursorPage.md)
 - [PackageMove](docs/PackageMove.md)
 - [PackageMoveRequest](docs/PackageMoveRequest.md)
 - [PackageQuarantine](docs/PackageQuarantine.md)
 - [PackageQuarantineRequest](docs/PackageQuarantineRequest.md)
 - [PackageResync](docs/PackageResync.md)
 - [PackageStatus](docs/PackageStatus.md)
 - [PackageTag](docs/PackageTag.md)
 - [PackageTagRequest](docs/PackageTagRequest.md)
 - [PackageUsageMetrics](docs/PackageUsageMetrics.md)
 - [PackageVersionBadge](docs/PackageVersionBadge.md)
 - [PackageVulnerability](docs/PackageVulnerability.md)
 - [PackageVulnerabilityPolicyEvaluationRequest](docs/PackageVulnerabilityPolicyEvaluationRequest.md)
 - [PackageVulnerabilityPolicyEvaluationRequestRequest](docs/PackageVulnerabilityPolicyEvaluationRequestRequest.md)
 - [PackageVulnerabilityPolicyViolationLog](docs/PackageVulnerabilityPolicyViolationLog.md)
 - [PackageVulnerabilityPolicyViolationLogCursorPage](docs/PackageVulnerabilityPolicyViolationLogCursorPage.md)
 - [ProviderSettings](docs/ProviderSettings.md)
 - [ProviderSettingsRequest](docs/ProviderSettingsRequest.md)
 - [ProviderSettingsRequestPatch](docs/ProviderSettingsRequestPatch.md)
 - [PythonPackageUpload](docs/PythonPackageUpload.md)
 - [PythonPackageUploadRequest](docs/PythonPackageUploadRequest.md)
 - [PythonUpstream](docs/PythonUpstream.md)
 - [PythonUpstreamRequest](docs/PythonUpstreamRequest.md)
 - [PythonUpstreamRequestPatch](docs/PythonUpstreamRequestPatch.md)
 - [Quota](docs/Quota.md)
 - [QuotaHistory](docs/QuotaHistory.md)
 - [RateCheck](docs/RateCheck.md)
 - [RawPackageUpload](docs/RawPackageUpload.md)
 - [RawPackageUploadRequest](docs/RawPackageUploadRequest.md)
 - [Repository](docs/Repository.md)
 - [RepositoryAuditLog](docs/RepositoryAuditLog.md)
 - [RepositoryCreate](docs/RepositoryCreate.md)
 - [RepositoryCreateRequest](docs/RepositoryCreateRequest.md)
 - [RepositoryEcdsaKey](docs/RepositoryEcdsaKey.md)
 - [RepositoryEcdsaKeyCreate](docs/RepositoryEcdsaKeyCreate.md)
 - [RepositoryGeoIpCidr](docs/RepositoryGeoIpCidr.md)
 - [RepositoryGeoIpCountryCode](docs/RepositoryGeoIpCountryCode.md)
 - [RepositoryGeoIpRules](docs/RepositoryGeoIpRules.md)
 - [RepositoryGeoIpRulesRequest](docs/RepositoryGeoIpRulesRequest.md)
 - [RepositoryGeoIpRulesRequestPatch](docs/RepositoryGeoIpRulesRequestPatch.md)
 - [RepositoryGeoIpStatus](docs/RepositoryGeoIpStatus.md)
 - [RepositoryGeoIpTestAddress](docs/RepositoryGeoIpTestAddress.md)
 - [RepositoryGeoIpTestAddressResponse](docs/RepositoryGeoIpTestAddressResponse.md)
 - [RepositoryGeoIpTestAddressResponseDict](docs/RepositoryGeoIpTestAddressResponseDict.md)
 - [RepositoryGpgKey](docs/RepositoryGpgKey.md)
 - [RepositoryGpgKeyCreate](docs/RepositoryGpgKeyCreate.md)
 - [RepositoryPrivilegeDict](docs/RepositoryPrivilegeDict.md)
 - [RepositoryPrivilegeInput](docs/RepositoryPrivilegeInput.md)
 - [RepositoryPrivilegeInputRequest](docs/RepositoryPrivilegeInputRequest.md)
 - [RepositoryPrivilegeInputRequestPatch](docs/RepositoryPrivilegeInputRequestPatch.md)
 - [RepositoryRequestPatch](docs/RepositoryRequestPatch.md)
 - [RepositoryRetentionRules](docs/RepositoryRetentionRules.md)
 - [RepositoryRetentionRulesRequestPatch](docs/RepositoryRetentionRulesRequestPatch.md)
 - [RepositoryRsaKey](docs/RepositoryRsaKey.md)
 - [RepositoryRsaKeyCreate](docs/RepositoryRsaKeyCreate.md)
 - [RepositoryToken](docs/RepositoryToken.md)
 - [RepositoryTokenAction](docs/RepositoryTokenAction.md)
 - [RepositoryTokenRefresh](docs/RepositoryTokenRefresh.md)
 - [RepositoryTokenRefreshRequest](docs/RepositoryTokenRefreshRequest.md)
 - [RepositoryTokenRequest](docs/RepositoryTokenRequest.md)
 - [RepositoryTokenRequestPatch](docs/RepositoryTokenRequestPatch.md)
 - [RepositoryTokenSync](docs/RepositoryTokenSync.md)
 - [RepositoryTokenSyncRequest](docs/RepositoryTokenSyncRequest.md)
 - [RepositoryTransferRegion](docs/RepositoryTransferRegion.md)
 - [RepositoryTransferRegionRequest](docs/RepositoryTransferRegionRequest.md)
 - [RepositoryWebhook](docs/RepositoryWebhook.md)
 - [RepositoryWebhookRequest](docs/RepositoryWebhookRequest.md)
 - [RepositoryWebhookRequestPatch](docs/RepositoryWebhookRequestPatch.md)
 - [RepositoryX509EcdsaCertificate](docs/RepositoryX509EcdsaCertificate.md)
 - [RepositoryX509RsaCertificate](docs/RepositoryX509RsaCertificate.md)
 - [ResourcesRateCheck](docs/ResourcesRateCheck.md)
 - [RespositoryGeoIpEnableDisable](docs/RespositoryGeoIpEnableDisable.md)
 - [RespositoryGeoIpEnableDisableRequest](docs/RespositoryGeoIpEnableDisableRequest.md)
 - [RpmPackageUpload](docs/RpmPackageUpload.md)
 - [RpmPackageUploadRequest](docs/RpmPackageUploadRequest.md)
 - [RpmUpstream](docs/RpmUpstream.md)
 - [RpmUpstreamRequest](docs/RpmUpstreamRequest.md)
 - [RpmUpstreamRequestPatch](docs/RpmUpstreamRequestPatch.md)
 - [RubyPackageUpload](docs/RubyPackageUpload.md)
 - [RubyPackageUploadRequest](docs/RubyPackageUploadRequest.md)
 - [RubyUpstream](docs/RubyUpstream.md)
 - [RubyUpstreamRequest](docs/RubyUpstreamRequest.md)
 - [RubyUpstreamRequestPatch](docs/RubyUpstreamRequestPatch.md)
 - [Service](docs/Service.md)
 - [ServiceRequest](docs/ServiceRequest.md)
 - [ServiceRequestPatch](docs/ServiceRequestPatch.md)
 - [ServiceTeams](docs/ServiceTeams.md)
 - [StatusBasic](docs/StatusBasic.md)
 - [StorageAllocatedLimit](docs/StorageAllocatedLimit.md)
 - [StorageAllocatedLimitRaw](docs/StorageAllocatedLimitRaw.md)
 - [StorageRegion](docs/StorageRegion.md)
 - [StorageUsage](docs/StorageUsage.md)
 - [StorageUsageRaw](docs/StorageUsageRaw.md)
 - [SwiftPackageUpload](docs/SwiftPackageUpload.md)
 - [SwiftPackageUploadRequest](docs/SwiftPackageUploadRequest.md)
 - [SwiftUpstream](docs/SwiftUpstream.md)
 - [SwiftUpstreamRequest](docs/SwiftUpstreamRequest.md)
 - [SwiftUpstreamRequestPatch](docs/SwiftUpstreamRequestPatch.md)
 - [Tags](docs/Tags.md)
 - [TerraformPackageUpload](docs/TerraformPackageUpload.md)
 - [TerraformPackageUploadRequest](docs/TerraformPackageUploadRequest.md)
 - [Usage](docs/Usage.md)
 - [UsageFieldset](docs/UsageFieldset.md)
 - [UsageLimits](docs/UsageLimits.md)
 - [UsageLimitsRaw](docs/UsageLimitsRaw.md)
 - [UsageRaw](docs/UsageRaw.md)
 - [UserAuthToken](docs/UserAuthToken.md)
 - [UserAuthTokenRequest](docs/UserAuthTokenRequest.md)
 - [UserAuthenticationToken](docs/UserAuthenticationToken.md)
 - [UserBrief](docs/UserBrief.md)
 - [UserProfile](docs/UserProfile.md)
 - [VagrantPackageUpload](docs/VagrantPackageUpload.md)
 - [VagrantPackageUploadRequest](docs/VagrantPackageUploadRequest.md)
 - [Vulnerability](docs/Vulnerability.md)
 - [VulnerabilityScan](docs/VulnerabilityScan.md)
 - [VulnerabilityScanResults](docs/VulnerabilityScanResults.md)
 - [VulnerabilityScanResultsList](docs/VulnerabilityScanResultsList.md)
 - [VulnerabilityScanVersion](docs/VulnerabilityScanVersion.md)
 - [WebhookTemplate](docs/WebhookTemplate.md)


## Documentation For Authorization


## apikey

- **Type**: API key
- **API key parameter name**: X-Api-Key
- **Location**: HTTP header

## basic

- **Type**: HTTP basic authentication


## Author

support@cloudsmith.io

