# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudsmith_api.api_client import ApiClient


class OrgsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def orgs_delete(self, org, **kwargs):  # noqa: E501
        """Delete the specified organization.  # noqa: E501

        Delete the specified organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_delete(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_delete_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_delete_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_delete_with_http_info(self, org, **kwargs):  # noqa: E501
        """Delete the specified organization.  # noqa: E501

        Delete the specified organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_delete_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_deny_policy_create(self, org, **kwargs):  # noqa: E501
        """Create a package deny policy.  # noqa: E501

        Create a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param PackageDenyPolicyRequest data:
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_deny_policy_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_deny_policy_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_deny_policy_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create a package deny policy.  # noqa: E501

        Create a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param PackageDenyPolicyRequest data:
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_deny_policy_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_deny_policy_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/deny-policy/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageDenyPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_deny_policy_delete(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a package deny policy.  # noqa: E501

        Delete a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_delete(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_deny_policy_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_deny_policy_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_deny_policy_delete_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a package deny policy.  # noqa: E501

        Delete a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_delete_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_deny_policy_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_deny_policy_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_deny_policy_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/deny-policy/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_deny_policy_list(self, org, **kwargs):  # noqa: E501
        """Get a list of all package deny policies.  # noqa: E501

        Get a list of all package deny policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PackageDenyPolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_deny_policy_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_deny_policy_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_deny_policy_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get a list of all package deny policies.  # noqa: E501

        Get a list of all package deny policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PackageDenyPolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_deny_policy_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_deny_policy_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/deny-policy/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PackageDenyPolicy]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_deny_policy_partial_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Partially update a package deny policy.  # noqa: E501

        Partially update a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_partial_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param PackageDenyPolicyRequestPatch data:
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_deny_policy_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_deny_policy_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_deny_policy_partial_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Partially update a package deny policy.  # noqa: E501

        Partially update a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_partial_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param PackageDenyPolicyRequestPatch data:
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_deny_policy_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_deny_policy_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_deny_policy_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/deny-policy/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageDenyPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_deny_policy_read(self, org, slug_perm, **kwargs):  # noqa: E501
        """Get a package deny policy.  # noqa: E501

        Get a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_read(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_deny_policy_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_deny_policy_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_deny_policy_read_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Get a package deny policy.  # noqa: E501

        Get a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_read_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_deny_policy_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_deny_policy_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_deny_policy_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/deny-policy/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageDenyPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_deny_policy_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a package deny policy.  # noqa: E501

        Update a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param PackageDenyPolicyRequest data:
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_deny_policy_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_deny_policy_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_deny_policy_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a package deny policy.  # noqa: E501

        Update a package deny policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_deny_policy_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param PackageDenyPolicyRequest data:
        :return: PackageDenyPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_deny_policy_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_deny_policy_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_deny_policy_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/deny-policy/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageDenyPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_invites_create(self, org, **kwargs):  # noqa: E501
        """Create an organization invite for a specific user  # noqa: E501

        Create an organization invite for a specific user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationInviteRequest data:
        :return: OrganizationInvite
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_invites_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_invites_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_invites_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create an organization invite for a specific user  # noqa: E501

        Create an organization invite for a specific user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationInviteRequest data:
        :return: OrganizationInvite
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_invites_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_invites_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/invites/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationInvite',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_invites_delete(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a specific organization invite  # noqa: E501

        Delete a specific organization invite  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_delete(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_invites_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_invites_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_invites_delete_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a specific organization invite  # noqa: E501

        Delete a specific organization invite  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_delete_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_invites_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_invites_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_invites_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/invites/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_invites_extend(self, org, slug_perm, **kwargs):  # noqa: E501
        """Extend an organization invite.  # noqa: E501

        Extend an organization invite.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_extend(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationInviteExtend
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_invites_extend_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_invites_extend_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_invites_extend_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Extend an organization invite.  # noqa: E501

        Extend an organization invite.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_extend_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationInviteExtend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_invites_extend" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_invites_extend`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_invites_extend`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/invites/{slug_perm}/extend/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationInviteExtend',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_invites_list(self, org, **kwargs):  # noqa: E501
        """Get a list of all invites for an organization.  # noqa: E501

        Get a list of all invites for an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationInvite]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_invites_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_invites_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_invites_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get a list of all invites for an organization.  # noqa: E501

        Get a list of all invites for an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationInvite]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_invites_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_invites_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/invites/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationInvite]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_invites_partial_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a specific organization invite.  # noqa: E501

        Update a specific organization invite.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_partial_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationInviteUpdateRequestPatch data:
        :return: OrganizationInvite
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_invites_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_invites_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_invites_partial_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a specific organization invite.  # noqa: E501

        Update a specific organization invite.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_partial_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationInviteUpdateRequestPatch data:
        :return: OrganizationInvite
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_invites_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_invites_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_invites_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/invites/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationInvite',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_invites_resend(self, org, slug_perm, **kwargs):  # noqa: E501
        """Resend an organization invite.  # noqa: E501

        Resend an organization invite.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_resend(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationInviteExtend
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_invites_resend_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_invites_resend_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_invites_resend_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Resend an organization invite.  # noqa: E501

        Resend an organization invite.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_invites_resend_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationInviteExtend
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_invites_resend" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_invites_resend`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_invites_resend`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/invites/{slug_perm}/resend/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationInviteExtend',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_create(self, org, **kwargs):  # noqa: E501
        """Create a package license policy.  # noqa: E501

        Create a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationPackageLicensePolicyRequest data:
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create a package license policy.  # noqa: E501

        Create a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationPackageLicensePolicyRequest data:
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageLicensePolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_delete(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a package license policy.  # noqa: E501

        Delete a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_delete(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_delete_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a package license policy.  # noqa: E501

        Delete a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_delete_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_license_policy_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_evaluation_create(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """Create an evaluation request for this policy.  # noqa: E501

        Create an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_evaluation_create(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param PackageLicensePolicyEvaluationRequestRequest data:
        :return: PackageLicensePolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_evaluation_create_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_evaluation_create_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_evaluation_create_with_http_info(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """Create an evaluation request for this policy.  # noqa: E501

        Create an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_evaluation_create_with_http_info(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param PackageLicensePolicyEvaluationRequestRequest data:
        :return: PackageLicensePolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'policy_slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_evaluation_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_evaluation_create`")  # noqa: E501
        # verify the required parameter 'policy_slug_perm' is set
        if self.api_client.client_side_validation and ('policy_slug_perm' not in params or
                                                       params['policy_slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `policy_slug_perm` when calling `orgs_license_policy_evaluation_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'policy_slug_perm' in params:
            path_params['policy_slug_perm'] = params['policy_slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/{policy_slug_perm}/evaluation/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageLicensePolicyEvaluationRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_evaluation_list(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """List evaluation requests for this policy.  # noqa: E501

        List evaluation requests for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_evaluation_list(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PackageLicensePolicyEvaluationRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_evaluation_list_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_evaluation_list_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_evaluation_list_with_http_info(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """List evaluation requests for this policy.  # noqa: E501

        List evaluation requests for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_evaluation_list_with_http_info(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PackageLicensePolicyEvaluationRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'policy_slug_perm', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_evaluation_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_evaluation_list`")  # noqa: E501
        # verify the required parameter 'policy_slug_perm' is set
        if self.api_client.client_side_validation and ('policy_slug_perm' not in params or
                                                       params['policy_slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `policy_slug_perm` when calling `orgs_license_policy_evaluation_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'policy_slug_perm' in params:
            path_params['policy_slug_perm'] = params['policy_slug_perm']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/{policy_slug_perm}/evaluation/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PackageLicensePolicyEvaluationRequest]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_evaluation_read(self, org, policy_slug_perm, slug_perm, **kwargs):  # noqa: E501
        """Retrieve an evaluation request for this policy.  # noqa: E501

        Retrieve an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_evaluation_read(org, policy_slug_perm, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param str slug_perm: (required)
        :return: PackageLicensePolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_evaluation_read_with_http_info(org, policy_slug_perm, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_evaluation_read_with_http_info(org, policy_slug_perm, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_evaluation_read_with_http_info(self, org, policy_slug_perm, slug_perm, **kwargs):  # noqa: E501
        """Retrieve an evaluation request for this policy.  # noqa: E501

        Retrieve an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_evaluation_read_with_http_info(org, policy_slug_perm, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param str slug_perm: (required)
        :return: PackageLicensePolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'policy_slug_perm', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_evaluation_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_evaluation_read`")  # noqa: E501
        # verify the required parameter 'policy_slug_perm' is set
        if self.api_client.client_side_validation and ('policy_slug_perm' not in params or
                                                       params['policy_slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `policy_slug_perm` when calling `orgs_license_policy_evaluation_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_license_policy_evaluation_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'policy_slug_perm' in params:
            path_params['policy_slug_perm'] = params['policy_slug_perm']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/{policy_slug_perm}/evaluation/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageLicensePolicyEvaluationRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_list(self, org, **kwargs):  # noqa: E501
        """Get a list of all package license policies.  # noqa: E501

        Get a list of all package license policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationPackageLicensePolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get a list of all package license policies.  # noqa: E501

        Get a list of all package license policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationPackageLicensePolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationPackageLicensePolicy]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_partial_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Partially update a package license policy.  # noqa: E501

        Partially update a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_partial_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageLicensePolicyRequestPatch data:
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_partial_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Partially update a package license policy.  # noqa: E501

        Partially update a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_partial_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageLicensePolicyRequestPatch data:
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_license_policy_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageLicensePolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_read(self, org, slug_perm, **kwargs):  # noqa: E501
        """Get a package license policy.  # noqa: E501

        Get a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_read(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_read_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Get a package license policy.  # noqa: E501

        Get a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_read_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_license_policy_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageLicensePolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a package license policy.  # noqa: E501

        Update a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageLicensePolicyRequest data:
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a package license policy.  # noqa: E501

        Update a package license policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageLicensePolicyRequest data:
        :return: OrganizationPackageLicensePolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_license_policy_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageLicensePolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_license_policy_violation_list(self, org, **kwargs):  # noqa: E501
        """List all current license policy violations for this Organization.  # noqa: E501

        List all current license policy violations for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_violation_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str cursor: The pagination cursor value.
        :param int page_size: Number of results to return per page.
        :return: PackageLicensePolicyViolationLogCursorPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_license_policy_violation_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_license_policy_violation_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_license_policy_violation_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """List all current license policy violations for this Organization.  # noqa: E501

        List all current license policy violations for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_license_policy_violation_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str cursor: The pagination cursor value.
        :param int page_size: Number of results to return per page.
        :return: PackageLicensePolicyViolationLogCursorPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'cursor', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_license_policy_violation_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_license_policy_violation_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/license-policy-violation/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageLicensePolicyViolationLogCursorPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_list(self, **kwargs):  # noqa: E501
        """Get a list of all the organizations you are associated with.  # noqa: E501

        Get a list of all the organizations you are associated with.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[Organization]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.orgs_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def orgs_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of all the organizations you are associated with.  # noqa: E501

        Get a list of all the organizations you are associated with.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[Organization]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Organization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_delete(self, org, member, **kwargs):  # noqa: E501
        """Removes a member from the organization.  # noqa: E501

        Removes a member from the organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_delete(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_delete_with_http_info(org, member, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_delete_with_http_info(org, member, **kwargs)  # noqa: E501
            return data

    def orgs_members_delete_with_http_info(self, org, member, **kwargs):  # noqa: E501
        """Removes a member from the organization.  # noqa: E501

        Removes a member from the organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_delete_with_http_info(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'member']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_delete`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in params or
                                                       params['member'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `member` when calling `orgs_members_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'member' in params:
            path_params['member'] = params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/{member}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_list(self, org, **kwargs):  # noqa: E501
        """Get the details for all organization members.  # noqa: E501

        Get the details for all organization members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param bool is_active: Filter for active/inactive users.
        :param str query: A search term for querying of members within an Organization.Available options are: email, org, user, userslug, inactive, user_name, role
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-user_name`). Available options: user_name, role.
        :return: list[OrganizationMembership]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_members_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get the details for all organization members.  # noqa: E501

        Get the details for all organization members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param bool is_active: Filter for active/inactive users.
        :param str query: A search term for querying of members within an Organization.Available options are: email, org, user, userslug, inactive, user_name, role
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-user_name`). Available options: user_name, role.
        :return: list[OrganizationMembership]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size', 'is_active', 'query', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'is_active' in params:
            query_params.append(('is_active', params['is_active']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationMembership]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_partial_update(self, org, member, **kwargs):  # noqa: E501
        """Views for working with organization members.  # noqa: E501

        Views for working with organization members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_partial_update(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :param OrganizationMembershipRequestPatch data:
        :return: OrganizationMembership
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_partial_update_with_http_info(org, member, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_partial_update_with_http_info(org, member, **kwargs)  # noqa: E501
            return data

    def orgs_members_partial_update_with_http_info(self, org, member, **kwargs):  # noqa: E501
        """Views for working with organization members.  # noqa: E501

        Views for working with organization members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_partial_update_with_http_info(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :param OrganizationMembershipRequestPatch data:
        :return: OrganizationMembership
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'member', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_partial_update`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in params or
                                                       params['member'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `member` when calling `orgs_members_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'member' in params:
            path_params['member'] = params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/{member}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationMembership',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_read(self, org, member, **kwargs):  # noqa: E501
        """Get the details for a specific organization member.  # noqa: E501

        Get the details for a specific organization member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_read(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: OrganizationMembership
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_read_with_http_info(org, member, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_read_with_http_info(org, member, **kwargs)  # noqa: E501
            return data

    def orgs_members_read_with_http_info(self, org, member, **kwargs):  # noqa: E501
        """Get the details for a specific organization member.  # noqa: E501

        Get the details for a specific organization member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_read_with_http_info(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: OrganizationMembership
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'member']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_read`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in params or
                                                       params['member'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `member` when calling `orgs_members_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'member' in params:
            path_params['member'] = params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/{member}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationMembership',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_refresh(self, org, member, **kwargs):  # noqa: E501
        """Refresh a member of the organization's API key.  # noqa: E501

        Refresh a member of the organization's API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_refresh(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_refresh_with_http_info(org, member, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_refresh_with_http_info(org, member, **kwargs)  # noqa: E501
            return data

    def orgs_members_refresh_with_http_info(self, org, member, **kwargs):  # noqa: E501
        """Refresh a member of the organization's API key.  # noqa: E501

        Refresh a member of the organization's API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_refresh_with_http_info(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'member']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_refresh`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in params or
                                                       params['member'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `member` when calling `orgs_members_refresh`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'member' in params:
            path_params['member'] = params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/{member}/refresh/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_remove(self, org, member, **kwargs):  # noqa: E501
        """Removes a member from the organization (deprecated, use DELETE instead).  # noqa: E501

        Removes a member from the organization (deprecated, use DELETE instead).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_remove(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_remove_with_http_info(org, member, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_remove_with_http_info(org, member, **kwargs)  # noqa: E501
            return data

    def orgs_members_remove_with_http_info(self, org, member, **kwargs):  # noqa: E501
        """Removes a member from the organization (deprecated, use DELETE instead).  # noqa: E501

        Removes a member from the organization (deprecated, use DELETE instead).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_remove_with_http_info(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'member']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_remove" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_remove`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in params or
                                                       params['member'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `member` when calling `orgs_members_remove`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'member' in params:
            path_params['member'] = params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/{member}/remove/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_update_role(self, org, member, **kwargs):  # noqa: E501
        """Update a member's role in the organization.  # noqa: E501

        Update a member's role in the organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_update_role(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :param OrganizationMembershipRoleUpdateRequestPatch data:
        :return: OrganizationMembershipRoleUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_update_role_with_http_info(org, member, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_update_role_with_http_info(org, member, **kwargs)  # noqa: E501
            return data

    def orgs_members_update_role_with_http_info(self, org, member, **kwargs):  # noqa: E501
        """Update a member's role in the organization.  # noqa: E501

        Update a member's role in the organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_update_role_with_http_info(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :param OrganizationMembershipRoleUpdateRequestPatch data:
        :return: OrganizationMembershipRoleUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'member', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_update_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_update_role`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in params or
                                                       params['member'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `member` when calling `orgs_members_update_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'member' in params:
            path_params['member'] = params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/{member}/update-role/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationMembershipRoleUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_members_update_visibility(self, org, member, **kwargs):  # noqa: E501
        """Update a member's visibility in the organization.  # noqa: E501

        Update a member's visibility in the organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_update_visibility(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :param OrganizationMembershipVisibilityUpdateRequestPatch data:
        :return: OrganizationMembershipVisibilityUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_members_update_visibility_with_http_info(org, member, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_members_update_visibility_with_http_info(org, member, **kwargs)  # noqa: E501
            return data

    def orgs_members_update_visibility_with_http_info(self, org, member, **kwargs):  # noqa: E501
        """Update a member's visibility in the organization.  # noqa: E501

        Update a member's visibility in the organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_members_update_visibility_with_http_info(org, member, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str member: (required)
        :param OrganizationMembershipVisibilityUpdateRequestPatch data:
        :return: OrganizationMembershipVisibilityUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'member', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_members_update_visibility" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_members_update_visibility`")  # noqa: E501
        # verify the required parameter 'member' is set
        if self.api_client.client_side_validation and ('member' not in params or
                                                       params['member'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `member` when calling `orgs_members_update_visibility`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'member' in params:
            path_params['member'] = params['member']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/members/{member}/update-visibility/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationMembershipVisibilityUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_openid_connect_create(self, org, **kwargs):  # noqa: E501
        """Create the OpenID Connect provider settings for the org.  # noqa: E501

        Create the OpenID Connect provider settings for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param ProviderSettingsRequest data:
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_openid_connect_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_openid_connect_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_openid_connect_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create the OpenID Connect provider settings for the org.  # noqa: E501

        Create the OpenID Connect provider settings for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param ProviderSettingsRequest data:
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_openid_connect_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_openid_connect_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/openid-connect/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_openid_connect_delete(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a specific OpenID Connect provider setting for the org.  # noqa: E501

        Delete a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_delete(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_openid_connect_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_openid_connect_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_openid_connect_delete_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a specific OpenID Connect provider setting for the org.  # noqa: E501

        Delete a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_delete_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_openid_connect_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_openid_connect_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_openid_connect_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/openid-connect/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_openid_connect_list(self, org, **kwargs):  # noqa: E501
        """Retrieve the list of OpenID Connect provider settings for the org.  # noqa: E501

        Retrieve the list of OpenID Connect provider settings for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param str query: A search term for querying of OpenID Connect (OIDC) provider settings.Available options are: name, provider_url, service_account
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-name`). Available options: name.
        :return: list[ProviderSettings]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_openid_connect_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_openid_connect_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_openid_connect_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Retrieve the list of OpenID Connect provider settings for the org.  # noqa: E501

        Retrieve the list of OpenID Connect provider settings for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param str query: A search term for querying of OpenID Connect (OIDC) provider settings.Available options are: name, provider_url, service_account
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-name`). Available options: name.
        :return: list[ProviderSettings]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size', 'query', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_openid_connect_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_openid_connect_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/openid-connect/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProviderSettings]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_openid_connect_partial_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a specific OpenID Connect provider setting for the org.  # noqa: E501

        Update a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_partial_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param ProviderSettingsRequestPatch data:
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_openid_connect_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_openid_connect_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_openid_connect_partial_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a specific OpenID Connect provider setting for the org.  # noqa: E501

        Update a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_partial_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param ProviderSettingsRequestPatch data:
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_openid_connect_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_openid_connect_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_openid_connect_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/openid-connect/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_openid_connect_read(self, org, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a specific OpenID Connect provider setting for the org.  # noqa: E501

        Retrieve a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_read(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_openid_connect_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_openid_connect_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_openid_connect_read_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a specific OpenID Connect provider setting for the org.  # noqa: E501

        Retrieve a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_read_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_openid_connect_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_openid_connect_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_openid_connect_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/openid-connect/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_openid_connect_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a specific OpenID Connect provider setting for the org.  # noqa: E501

        Update a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param ProviderSettingsRequest data:
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_openid_connect_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_openid_connect_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_openid_connect_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a specific OpenID Connect provider setting for the org.  # noqa: E501

        Update a specific OpenID Connect provider setting for the org.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_openid_connect_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param ProviderSettingsRequest data:
        :return: ProviderSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_openid_connect_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_openid_connect_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_openid_connect_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/openid-connect/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_read(self, org, **kwargs):  # noqa: E501
        """Get the details for the specific organization.  # noqa: E501

        Get the details for the specific organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_read(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_read_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_read_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_read_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get the details for the specific organization.  # noqa: E501

        Get the details for the specific organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_read_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_authentication_partial_update(self, org, **kwargs):  # noqa: E501
        """Update the SAML Authentication settings for this Organization.  # noqa: E501

        Update the SAML Authentication settings for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_authentication_partial_update(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationSAMLAuthRequestPatch data:
        :return: OrganizationSAMLAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_authentication_partial_update_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_authentication_partial_update_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_saml_authentication_partial_update_with_http_info(self, org, **kwargs):  # noqa: E501
        """Update the SAML Authentication settings for this Organization.  # noqa: E501

        Update the SAML Authentication settings for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_authentication_partial_update_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationSAMLAuthRequestPatch data:
        :return: OrganizationSAMLAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_authentication_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_authentication_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-authentication', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationSAMLAuth',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_authentication_read(self, org, **kwargs):  # noqa: E501
        """Retrieve the SAML Authentication settings for this Organization.  # noqa: E501

        Retrieve the SAML Authentication settings for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_authentication_read(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: OrganizationSAMLAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_authentication_read_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_authentication_read_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_saml_authentication_read_with_http_info(self, org, **kwargs):  # noqa: E501
        """Retrieve the SAML Authentication settings for this Organization.  # noqa: E501

        Retrieve the SAML Authentication settings for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_authentication_read_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: OrganizationSAMLAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_authentication_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_authentication_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-authentication', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationSAMLAuth',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_group_sync_create(self, org, **kwargs):  # noqa: E501
        """Create a new SAML Group Sync mapping within an organization.  # noqa: E501

        Create a new SAML Group Sync mapping within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationGroupSyncRequest data:
        :return: OrganizationGroupSync
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_group_sync_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_group_sync_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_saml_group_sync_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create a new SAML Group Sync mapping within an organization.  # noqa: E501

        Create a new SAML Group Sync mapping within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationGroupSyncRequest data:
        :return: OrganizationGroupSync
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_group_sync_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_group_sync_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-group-sync/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationGroupSync',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_group_sync_delete(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a SAML Group Sync mapping from an organization.  # noqa: E501

        Delete a SAML Group Sync mapping from an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_delete(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_group_sync_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_group_sync_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_saml_group_sync_delete_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a SAML Group Sync mapping from an organization.  # noqa: E501

        Delete a SAML Group Sync mapping from an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_delete_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_group_sync_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_group_sync_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_saml_group_sync_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-group-sync/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_group_sync_disable(self, org, **kwargs):  # noqa: E501
        """Disable SAML Group Sync for this organization.  # noqa: E501

        Disable SAML Group Sync for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_disable(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_group_sync_disable_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_group_sync_disable_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_saml_group_sync_disable_with_http_info(self, org, **kwargs):  # noqa: E501
        """Disable SAML Group Sync for this organization.  # noqa: E501

        Disable SAML Group Sync for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_disable_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_group_sync_disable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_group_sync_disable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-group-sync/disable/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_group_sync_enable(self, org, **kwargs):  # noqa: E501
        """Enable SAML Group Sync for this organization.  # noqa: E501

        Enable SAML Group Sync for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_enable(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_group_sync_enable_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_group_sync_enable_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_saml_group_sync_enable_with_http_info(self, org, **kwargs):  # noqa: E501
        """Enable SAML Group Sync for this organization.  # noqa: E501

        Enable SAML Group Sync for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_enable_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_group_sync_enable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_group_sync_enable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-group-sync/enable/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_group_sync_list(self, org, **kwargs):  # noqa: E501
        """Get the details of all SAML Group Sync mapping within an organization.  # noqa: E501

        Get the details of all SAML Group Sync mapping within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationGroupSync]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_group_sync_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_group_sync_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_saml_group_sync_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get the details of all SAML Group Sync mapping within an organization.  # noqa: E501

        Get the details of all SAML Group Sync mapping within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationGroupSync]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_group_sync_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_group_sync_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-group-sync/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationGroupSync]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_saml_group_sync_status(self, org, **kwargs):  # noqa: E501
        """Retrieve the SAML Group Sync status for this organization.  # noqa: E501

        Retrieve the SAML Group Sync status for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_status(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: OrganizationGroupSyncStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_saml_group_sync_status_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_saml_group_sync_status_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_saml_group_sync_status_with_http_info(self, org, **kwargs):  # noqa: E501
        """Retrieve the SAML Group Sync status for this organization.  # noqa: E501

        Retrieve the SAML Group Sync status for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_saml_group_sync_status_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :return: OrganizationGroupSyncStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_saml_group_sync_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_saml_group_sync_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/saml-group-sync/status/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationGroupSyncStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_services_create(self, org, **kwargs):  # noqa: E501
        """Create a service within an organization.  # noqa: E501

        Create a service within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param ServiceRequest data:
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_services_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_services_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_services_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create a service within an organization.  # noqa: E501

        Create a service within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param ServiceRequest data:
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_services_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_services_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/services/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Service',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_services_delete(self, org, service, **kwargs):  # noqa: E501
        """Delete a specific service  # noqa: E501

        Delete a specific service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_delete(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_services_delete_with_http_info(org, service, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_services_delete_with_http_info(org, service, **kwargs)  # noqa: E501
            return data

    def orgs_services_delete_with_http_info(self, org, service, **kwargs):  # noqa: E501
        """Delete a specific service  # noqa: E501

        Delete a specific service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_delete_with_http_info(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'service']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_services_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_services_delete`")  # noqa: E501
        # verify the required parameter 'service' is set
        if self.api_client.client_side_validation and ('service' not in params or
                                                       params['service'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `service` when calling `orgs_services_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'service' in params:
            path_params['service'] = params['service']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/services/{service}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_services_list(self, org, **kwargs):  # noqa: E501
        """Get a list of all services within an organization.  # noqa: E501

        Get a list of all services within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param str query: A search term for querying of services within an Organization.Available options are: name, role
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-created_at`). Available options: created_at, name, role.
        :return: list[Service]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_services_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_services_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_services_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get a list of all services within an organization.  # noqa: E501

        Get a list of all services within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param str query: A search term for querying of services within an Organization.Available options are: name, role
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-created_at`). Available options: created_at, name, role.
        :return: list[Service]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size', 'query', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_services_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_services_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/services/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Service]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_services_partial_update(self, org, service, **kwargs):  # noqa: E501
        """Update a service within an organization.  # noqa: E501

        Update a service within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_partial_update(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :param ServiceRequestPatch data:
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_services_partial_update_with_http_info(org, service, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_services_partial_update_with_http_info(org, service, **kwargs)  # noqa: E501
            return data

    def orgs_services_partial_update_with_http_info(self, org, service, **kwargs):  # noqa: E501
        """Update a service within an organization.  # noqa: E501

        Update a service within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_partial_update_with_http_info(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :param ServiceRequestPatch data:
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'service', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_services_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_services_partial_update`")  # noqa: E501
        # verify the required parameter 'service' is set
        if self.api_client.client_side_validation and ('service' not in params or
                                                       params['service'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `service` when calling `orgs_services_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'service' in params:
            path_params['service'] = params['service']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/services/{service}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Service',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_services_read(self, org, service, **kwargs):  # noqa: E501
        """Retrieve details of a single service within an organization.  # noqa: E501

        Retrieve details of a single service within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_read(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_services_read_with_http_info(org, service, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_services_read_with_http_info(org, service, **kwargs)  # noqa: E501
            return data

    def orgs_services_read_with_http_info(self, org, service, **kwargs):  # noqa: E501
        """Retrieve details of a single service within an organization.  # noqa: E501

        Retrieve details of a single service within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_read_with_http_info(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'service']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_services_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_services_read`")  # noqa: E501
        # verify the required parameter 'service' is set
        if self.api_client.client_side_validation and ('service' not in params or
                                                       params['service'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `service` when calling `orgs_services_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'service' in params:
            path_params['service'] = params['service']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/services/{service}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Service',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_services_refresh(self, org, service, **kwargs):  # noqa: E501
        """Refresh service API token.  # noqa: E501

        Refresh service API token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_refresh(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_services_refresh_with_http_info(org, service, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_services_refresh_with_http_info(org, service, **kwargs)  # noqa: E501
            return data

    def orgs_services_refresh_with_http_info(self, org, service, **kwargs):  # noqa: E501
        """Refresh service API token.  # noqa: E501

        Refresh service API token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_services_refresh_with_http_info(org, service, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str service: (required)
        :return: Service
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'service']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_services_refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_services_refresh`")  # noqa: E501
        # verify the required parameter 'service' is set
        if self.api_client.client_side_validation and ('service' not in params or
                                                       params['service'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `service` when calling `orgs_services_refresh`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'service' in params:
            path_params['service'] = params['service']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/services/{service}/refresh/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Service',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_create(self, org, **kwargs):  # noqa: E501
        """Create a team for this organization.  # noqa: E501

        Create a team for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationTeamRequest data:
        :return: OrganizationTeam
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_teams_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create a team for this organization.  # noqa: E501

        Create a team for this organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationTeamRequest data:
        :return: OrganizationTeam
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationTeam',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_delete(self, org, team, **kwargs):  # noqa: E501
        """Delete a specific team in a organization.  # noqa: E501

        Delete a specific team in a organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_delete(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_delete_with_http_info(org, team, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_delete_with_http_info(org, team, **kwargs)  # noqa: E501
            return data

    def orgs_teams_delete_with_http_info(self, org, team, **kwargs):  # noqa: E501
        """Delete a specific team in a organization.  # noqa: E501

        Delete a specific team in a organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_delete_with_http_info(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'team']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_delete`")  # noqa: E501
        # verify the required parameter 'team' is set
        if self.api_client.client_side_validation and ('team' not in params or
                                                       params['team'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `team` when calling `orgs_teams_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'team' in params:
            path_params['team'] = params['team']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/{team}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_list(self, org, **kwargs):  # noqa: E501
        """Get the details of all teams within an organization.  # noqa: E501

        Get the details of all teams within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param bool for_user: Filter for teams that you are a member of.
        :param str query: A search term for querying of teams within an Organization.Available options are: name, slug, user, userslug
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-name`). Available options: name, members.
        :return: list[OrganizationTeam]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_teams_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get the details of all teams within an organization.  # noqa: E501

        Get the details of all teams within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :param bool for_user: Filter for teams that you are a member of.
        :param str query: A search term for querying of teams within an Organization.Available options are: name, slug, user, userslug
        :param str sort: A field for sorting objects in ascending or descending order. Use `-` prefix for descending order (e.g., `-name`). Available options: name, members.
        :return: list[OrganizationTeam]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size', 'for_user', 'query', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'for_user' in params:
            query_params.append(('for_user', params['for_user']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationTeam]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_members_create(self, org, team, **kwargs):  # noqa: E501
        """Add users to a team.  # noqa: E501

        Add users to a team.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_members_create(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :param OrganizationTeamMembers data:
        :return: OrganizationTeamMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_members_create_with_http_info(org, team, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_members_create_with_http_info(org, team, **kwargs)  # noqa: E501
            return data

    def orgs_teams_members_create_with_http_info(self, org, team, **kwargs):  # noqa: E501
        """Add users to a team.  # noqa: E501

        Add users to a team.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_members_create_with_http_info(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :param OrganizationTeamMembers data:
        :return: OrganizationTeamMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'team', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_members_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_members_create`")  # noqa: E501
        # verify the required parameter 'team' is set
        if self.api_client.client_side_validation and ('team' not in params or
                                                       params['team'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `team` when calling `orgs_teams_members_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'team' in params:
            path_params['team'] = params['team']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/{team}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationTeamMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_members_list(self, org, team, **kwargs):  # noqa: E501
        """List all members for the team.  # noqa: E501

        List all members for the team.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_members_list(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :return: OrganizationTeamMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_members_list_with_http_info(org, team, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_members_list_with_http_info(org, team, **kwargs)  # noqa: E501
            return data

    def orgs_teams_members_list_with_http_info(self, org, team, **kwargs):  # noqa: E501
        """List all members for the team.  # noqa: E501

        List all members for the team.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_members_list_with_http_info(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :return: OrganizationTeamMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'team']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_members_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_members_list`")  # noqa: E501
        # verify the required parameter 'team' is set
        if self.api_client.client_side_validation and ('team' not in params or
                                                       params['team'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `team` when calling `orgs_teams_members_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'team' in params:
            path_params['team'] = params['team']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/{team}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationTeamMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_members_update(self, org, team, **kwargs):  # noqa: E501
        """Replace all team members.  # noqa: E501

        Replace all team members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_members_update(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :param OrganizationTeamMembers data:
        :return: OrganizationTeamMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_members_update_with_http_info(org, team, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_members_update_with_http_info(org, team, **kwargs)  # noqa: E501
            return data

    def orgs_teams_members_update_with_http_info(self, org, team, **kwargs):  # noqa: E501
        """Replace all team members.  # noqa: E501

        Replace all team members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_members_update_with_http_info(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :param OrganizationTeamMembers data:
        :return: OrganizationTeamMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'team', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_members_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_members_update`")  # noqa: E501
        # verify the required parameter 'team' is set
        if self.api_client.client_side_validation and ('team' not in params or
                                                       params['team'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `team` when calling `orgs_teams_members_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'team' in params:
            path_params['team'] = params['team']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/{team}/members', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationTeamMembers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_partial_update(self, org, team, **kwargs):  # noqa: E501
        """Update a specific team in a organization.  # noqa: E501

        Update a specific team in a organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_partial_update(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :param OrganizationTeamRequestPatch data:
        :return: OrganizationTeam
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_partial_update_with_http_info(org, team, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_partial_update_with_http_info(org, team, **kwargs)  # noqa: E501
            return data

    def orgs_teams_partial_update_with_http_info(self, org, team, **kwargs):  # noqa: E501
        """Update a specific team in a organization.  # noqa: E501

        Update a specific team in a organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_partial_update_with_http_info(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :param OrganizationTeamRequestPatch data:
        :return: OrganizationTeam
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'team', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_partial_update`")  # noqa: E501
        # verify the required parameter 'team' is set
        if self.api_client.client_side_validation and ('team' not in params or
                                                       params['team'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `team` when calling `orgs_teams_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'team' in params:
            path_params['team'] = params['team']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/{team}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationTeam',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_teams_read(self, org, team, **kwargs):  # noqa: E501
        """Get the details of a specific team within an organization.  # noqa: E501

        Get the details of a specific team within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_read(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :return: OrganizationTeam
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_teams_read_with_http_info(org, team, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_teams_read_with_http_info(org, team, **kwargs)  # noqa: E501
            return data

    def orgs_teams_read_with_http_info(self, org, team, **kwargs):  # noqa: E501
        """Get the details of a specific team within an organization.  # noqa: E501

        Get the details of a specific team within an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_teams_read_with_http_info(org, team, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str team: (required)
        :return: OrganizationTeam
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'team']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_teams_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_teams_read`")  # noqa: E501
        # verify the required parameter 'team' is set
        if self.api_client.client_side_validation and ('team' not in params or
                                                       params['team'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `team` when calling `orgs_teams_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'team' in params:
            path_params['team'] = params['team']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/teams/{team}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationTeam',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_create(self, org, **kwargs):  # noqa: E501
        """Create a package vulnerability policy.  # noqa: E501

        Create a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_create(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationPackageVulnerabilityPolicyRequest data:
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_create_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_create_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_create_with_http_info(self, org, **kwargs):  # noqa: E501
        """Create a package vulnerability policy.  # noqa: E501

        Create a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_create_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param OrganizationPackageVulnerabilityPolicyRequest data:
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageVulnerabilityPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_delete(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a package vulnerability policy.  # noqa: E501

        Delete a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_delete(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_delete_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_delete_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Delete a package vulnerability policy.  # noqa: E501

        Delete a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_delete_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_vulnerability_policy_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_evaluation_create(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """Create an evaluation request for this policy.  # noqa: E501

        Create an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_evaluation_create(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param PackageVulnerabilityPolicyEvaluationRequestRequest data:
        :return: PackageVulnerabilityPolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_evaluation_create_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_evaluation_create_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_evaluation_create_with_http_info(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """Create an evaluation request for this policy.  # noqa: E501

        Create an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_evaluation_create_with_http_info(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param PackageVulnerabilityPolicyEvaluationRequestRequest data:
        :return: PackageVulnerabilityPolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'policy_slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_evaluation_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_evaluation_create`")  # noqa: E501
        # verify the required parameter 'policy_slug_perm' is set
        if self.api_client.client_side_validation and ('policy_slug_perm' not in params or
                                                       params['policy_slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `policy_slug_perm` when calling `orgs_vulnerability_policy_evaluation_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'policy_slug_perm' in params:
            path_params['policy_slug_perm'] = params['policy_slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/{policy_slug_perm}/evaluation/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageVulnerabilityPolicyEvaluationRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_evaluation_list(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """List evaluation requests for this policy.  # noqa: E501

        List evaluation requests for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_evaluation_list(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PackageVulnerabilityPolicyEvaluationRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_evaluation_list_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_evaluation_list_with_http_info(org, policy_slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_evaluation_list_with_http_info(self, org, policy_slug_perm, **kwargs):  # noqa: E501
        """List evaluation requests for this policy.  # noqa: E501

        List evaluation requests for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_evaluation_list_with_http_info(org, policy_slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PackageVulnerabilityPolicyEvaluationRequest]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'policy_slug_perm', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_evaluation_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_evaluation_list`")  # noqa: E501
        # verify the required parameter 'policy_slug_perm' is set
        if self.api_client.client_side_validation and ('policy_slug_perm' not in params or
                                                       params['policy_slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `policy_slug_perm` when calling `orgs_vulnerability_policy_evaluation_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'policy_slug_perm' in params:
            path_params['policy_slug_perm'] = params['policy_slug_perm']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/{policy_slug_perm}/evaluation/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PackageVulnerabilityPolicyEvaluationRequest]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_evaluation_read(self, org, policy_slug_perm, slug_perm, **kwargs):  # noqa: E501
        """Retrieve an evaluation request for this policy.  # noqa: E501

        Retrieve an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_evaluation_read(org, policy_slug_perm, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param str slug_perm: (required)
        :return: PackageVulnerabilityPolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_evaluation_read_with_http_info(org, policy_slug_perm, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_evaluation_read_with_http_info(org, policy_slug_perm, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_evaluation_read_with_http_info(self, org, policy_slug_perm, slug_perm, **kwargs):  # noqa: E501
        """Retrieve an evaluation request for this policy.  # noqa: E501

        Retrieve an evaluation request for this policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_evaluation_read_with_http_info(org, policy_slug_perm, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str policy_slug_perm: (required)
        :param str slug_perm: (required)
        :return: PackageVulnerabilityPolicyEvaluationRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'policy_slug_perm', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_evaluation_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_evaluation_read`")  # noqa: E501
        # verify the required parameter 'policy_slug_perm' is set
        if self.api_client.client_side_validation and ('policy_slug_perm' not in params or
                                                       params['policy_slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `policy_slug_perm` when calling `orgs_vulnerability_policy_evaluation_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_vulnerability_policy_evaluation_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'policy_slug_perm' in params:
            path_params['policy_slug_perm'] = params['policy_slug_perm']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/{policy_slug_perm}/evaluation/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageVulnerabilityPolicyEvaluationRequest',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_list(self, org, **kwargs):  # noqa: E501
        """Get a list of all package vulnerability policies.  # noqa: E501

        Get a list of all package vulnerability policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationPackageVulnerabilityPolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """Get a list of all package vulnerability policies.  # noqa: E501

        Get a list of all package vulnerability policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[OrganizationPackageVulnerabilityPolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationPackageVulnerabilityPolicy]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_partial_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Partially update a package vulnerability policy.  # noqa: E501

        Partially update a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_partial_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageVulnerabilityPolicyRequestPatch data:
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_partial_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_partial_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Partially update a package vulnerability policy.  # noqa: E501

        Partially update a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_partial_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageVulnerabilityPolicyRequestPatch data:
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_vulnerability_policy_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageVulnerabilityPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_read(self, org, slug_perm, **kwargs):  # noqa: E501
        """Get a package vulnerability policy.  # noqa: E501

        Get a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_read(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_read_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_read_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Get a package vulnerability policy.  # noqa: E501

        Get a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_read_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_vulnerability_policy_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageVulnerabilityPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_update(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a package vulnerability policy.  # noqa: E501

        Update a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_update(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageVulnerabilityPolicyRequest data:
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_update_with_http_info(org, slug_perm, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_update_with_http_info(self, org, slug_perm, **kwargs):  # noqa: E501
        """Update a package vulnerability policy.  # noqa: E501

        Update a package vulnerability policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_update_with_http_info(org, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str slug_perm: (required)
        :param OrganizationPackageVulnerabilityPolicyRequest data:
        :return: OrganizationPackageVulnerabilityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `orgs_vulnerability_policy_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationPackageVulnerabilityPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orgs_vulnerability_policy_violation_list(self, org, **kwargs):  # noqa: E501
        """List all current vulnerability policy violations for this Organization.  # noqa: E501

        List all current vulnerability policy violations for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_violation_list(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str cursor: The pagination cursor value.
        :param int page_size: Number of results to return per page.
        :return: PackageVulnerabilityPolicyViolationLogCursorPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orgs_vulnerability_policy_violation_list_with_http_info(org, **kwargs)  # noqa: E501
        else:
            (data) = self.orgs_vulnerability_policy_violation_list_with_http_info(org, **kwargs)  # noqa: E501
            return data

    def orgs_vulnerability_policy_violation_list_with_http_info(self, org, **kwargs):  # noqa: E501
        """List all current vulnerability policy violations for this Organization.  # noqa: E501

        List all current vulnerability policy violations for this Organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orgs_vulnerability_policy_violation_list_with_http_info(org, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org: (required)
        :param str cursor: The pagination cursor value.
        :param int page_size: Number of results to return per page.
        :return: PackageVulnerabilityPolicyViolationLogCursorPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org', 'cursor', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orgs_vulnerability_policy_violation_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org' is set
        if self.api_client.client_side_validation and ('org' not in params or
                                                       params['org'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org` when calling `orgs_vulnerability_policy_violation_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org' in params:
            path_params['org'] = params['org']  # noqa: E501

        query_params = []
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{org}/vulnerability-policy-violation/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageVulnerabilityPolicyViolationLogCursorPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
