# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class FormatSupportUpstream(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auth_modes': 'list[str]',
        'caching': 'bool',
        'indexing': 'bool',
        'indexing_behavior': 'str',
        'proxying': 'bool',
        'signature_verification': 'str'
    }

    attribute_map = {
        'auth_modes': 'auth_modes',
        'caching': 'caching',
        'indexing': 'indexing',
        'indexing_behavior': 'indexing_behavior',
        'proxying': 'proxying',
        'signature_verification': 'signature_verification'
    }

    def __init__(self, auth_modes=None, caching=None, indexing=None, indexing_behavior='Unsupported', proxying=None, signature_verification='Unsupported', _configuration=None):  # noqa: E501
        """FormatSupportUpstream - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._auth_modes = None
        self._caching = None
        self._indexing = None
        self._indexing_behavior = None
        self._proxying = None
        self._signature_verification = None
        self.discriminator = None

        self.auth_modes = auth_modes
        self.caching = caching
        self.indexing = indexing
        if indexing_behavior is not None:
            self.indexing_behavior = indexing_behavior
        self.proxying = proxying
        if signature_verification is not None:
            self.signature_verification = signature_verification

    @property
    def auth_modes(self):
        """Gets the auth_modes of this FormatSupportUpstream.

        The authentication modes supported by the upstream format

        :return: The auth_modes of this FormatSupportUpstream.
        :rtype: list[str]
        """
        return self._auth_modes

    @auth_modes.setter
    def auth_modes(self, auth_modes):
        """Sets the auth_modes of this FormatSupportUpstream.

        The authentication modes supported by the upstream format

        :param auth_modes: The auth_modes of this FormatSupportUpstream.
        :type: list[str]
        """
        if self._configuration.client_side_validation and auth_modes is None:
            raise ValueError("Invalid value for `auth_modes`, must not be `None`")  # noqa: E501
        allowed_values = ["Username and Password", "Token", "Certificate and Key"]  # noqa: E501
        if (self._configuration.client_side_validation and
                not set(auth_modes).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `auth_modes` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(auth_modes) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._auth_modes = auth_modes

    @property
    def caching(self):
        """Gets the caching of this FormatSupportUpstream.

        If true the upstream format supports caching

        :return: The caching of this FormatSupportUpstream.
        :rtype: bool
        """
        return self._caching

    @caching.setter
    def caching(self, caching):
        """Sets the caching of this FormatSupportUpstream.

        If true the upstream format supports caching

        :param caching: The caching of this FormatSupportUpstream.
        :type: bool
        """
        if self._configuration.client_side_validation and caching is None:
            raise ValueError("Invalid value for `caching`, must not be `None`")  # noqa: E501

        self._caching = caching

    @property
    def indexing(self):
        """Gets the indexing of this FormatSupportUpstream.

        If true the upstream format supports indexing

        :return: The indexing of this FormatSupportUpstream.
        :rtype: bool
        """
        return self._indexing

    @indexing.setter
    def indexing(self, indexing):
        """Sets the indexing of this FormatSupportUpstream.

        If true the upstream format supports indexing

        :param indexing: The indexing of this FormatSupportUpstream.
        :type: bool
        """
        if self._configuration.client_side_validation and indexing is None:
            raise ValueError("Invalid value for `indexing`, must not be `None`")  # noqa: E501

        self._indexing = indexing

    @property
    def indexing_behavior(self):
        """Gets the indexing_behavior of this FormatSupportUpstream.

        The behavior of the upstream when indexing

        :return: The indexing_behavior of this FormatSupportUpstream.
        :rtype: str
        """
        return self._indexing_behavior

    @indexing_behavior.setter
    def indexing_behavior(self, indexing_behavior):
        """Sets the indexing_behavior of this FormatSupportUpstream.

        The behavior of the upstream when indexing

        :param indexing_behavior: The indexing_behavior of this FormatSupportUpstream.
        :type: str
        """
        allowed_values = ["Unsupported", "Ahead-of-time (static) indexing", "Just-in-time (dynamic) indexing"]  # noqa: E501
        if (self._configuration.client_side_validation and
                indexing_behavior not in allowed_values):
            raise ValueError(
                "Invalid value for `indexing_behavior` ({0}), must be one of {1}"  # noqa: E501
                .format(indexing_behavior, allowed_values)
            )

        self._indexing_behavior = indexing_behavior

    @property
    def proxying(self):
        """Gets the proxying of this FormatSupportUpstream.

        If true the upstream format supports proxying

        :return: The proxying of this FormatSupportUpstream.
        :rtype: bool
        """
        return self._proxying

    @proxying.setter
    def proxying(self, proxying):
        """Sets the proxying of this FormatSupportUpstream.

        If true the upstream format supports proxying

        :param proxying: The proxying of this FormatSupportUpstream.
        :type: bool
        """
        if self._configuration.client_side_validation and proxying is None:
            raise ValueError("Invalid value for `proxying`, must not be `None`")  # noqa: E501

        self._proxying = proxying

    @property
    def signature_verification(self):
        """Gets the signature_verification of this FormatSupportUpstream.

        The signature verification supported by the upstream format

        :return: The signature_verification of this FormatSupportUpstream.
        :rtype: str
        """
        return self._signature_verification

    @signature_verification.setter
    def signature_verification(self, signature_verification):
        """Sets the signature_verification of this FormatSupportUpstream.

        The signature verification supported by the upstream format

        :param signature_verification: The signature_verification of this FormatSupportUpstream.
        :type: str
        """
        allowed_values = ["Unsupported", "Repository Metadata", "Packages", "Repository Metadata and Packages"]  # noqa: E501
        if (self._configuration.client_side_validation and
                signature_verification not in allowed_values):
            raise ValueError(
                "Invalid value for `signature_verification` ({0}), must be one of {1}"  # noqa: E501
                .format(signature_verification, allowed_values)
            )

        self._signature_verification = signature_verification

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FormatSupportUpstream, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FormatSupportUpstream):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FormatSupportUpstream):
            return True

        return self.to_dict() != other.to_dict()

