# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class OrganizationGroupSync(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'idp_key': 'str',
        'idp_value': 'str',
        'role': 'str',
        'slug_perm': 'str',
        'team': 'str'
    }

    attribute_map = {
        'idp_key': 'idp_key',
        'idp_value': 'idp_value',
        'role': 'role',
        'slug_perm': 'slug_perm',
        'team': 'team'
    }

    def __init__(self, idp_key=None, idp_value=None, role='Member', slug_perm=None, team=None, _configuration=None):  # noqa: E501
        """OrganizationGroupSync - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._idp_key = None
        self._idp_value = None
        self._role = None
        self._slug_perm = None
        self._team = None
        self.discriminator = None

        self.idp_key = idp_key
        self.idp_value = idp_value
        if role is not None:
            self.role = role
        if slug_perm is not None:
            self.slug_perm = slug_perm
        self.team = team

    @property
    def idp_key(self):
        """Gets the idp_key of this OrganizationGroupSync.


        :return: The idp_key of this OrganizationGroupSync.
        :rtype: str
        """
        return self._idp_key

    @idp_key.setter
    def idp_key(self, idp_key):
        """Sets the idp_key of this OrganizationGroupSync.


        :param idp_key: The idp_key of this OrganizationGroupSync.
        :type: str
        """
        if self._configuration.client_side_validation and idp_key is None:
            raise ValueError("Invalid value for `idp_key`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_key is not None and len(idp_key) > 100):
            raise ValueError("Invalid value for `idp_key`, length must be less than or equal to `100`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_key is not None and len(idp_key) < 1):
            raise ValueError("Invalid value for `idp_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._idp_key = idp_key

    @property
    def idp_value(self):
        """Gets the idp_value of this OrganizationGroupSync.


        :return: The idp_value of this OrganizationGroupSync.
        :rtype: str
        """
        return self._idp_value

    @idp_value.setter
    def idp_value(self, idp_value):
        """Sets the idp_value of this OrganizationGroupSync.


        :param idp_value: The idp_value of this OrganizationGroupSync.
        :type: str
        """
        if self._configuration.client_side_validation and idp_value is None:
            raise ValueError("Invalid value for `idp_value`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_value is not None and len(idp_value) > 100):
            raise ValueError("Invalid value for `idp_value`, length must be less than or equal to `100`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_value is not None and len(idp_value) < 1):
            raise ValueError("Invalid value for `idp_value`, length must be greater than or equal to `1`")  # noqa: E501

        self._idp_value = idp_value

    @property
    def role(self):
        """Gets the role of this OrganizationGroupSync.


        :return: The role of this OrganizationGroupSync.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this OrganizationGroupSync.


        :param role: The role of this OrganizationGroupSync.
        :type: str
        """
        allowed_values = ["Manager", "Member"]  # noqa: E501
        if (self._configuration.client_side_validation and
                role not in allowed_values):
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def slug_perm(self):
        """Gets the slug_perm of this OrganizationGroupSync.


        :return: The slug_perm of this OrganizationGroupSync.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this OrganizationGroupSync.


        :param slug_perm: The slug_perm of this OrganizationGroupSync.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def team(self):
        """Gets the team of this OrganizationGroupSync.


        :return: The team of this OrganizationGroupSync.
        :rtype: str
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this OrganizationGroupSync.


        :param team: The team of this OrganizationGroupSync.
        :type: str
        """
        if self._configuration.client_side_validation and team is None:
            raise ValueError("Invalid value for `team`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                team is not None and not re.search('^[-a-zA-Z0-9_]+$', team)):  # noqa: E501
            raise ValueError(r"Invalid value for `team`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._team = team

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrganizationGroupSync, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganizationGroupSync):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrganizationGroupSync):
            return True

        return self.to_dict() != other.to_dict()

