# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RepositoryEcdsaKeyCreate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ecdsa_passphrase': 'str',
        'ecdsa_private_key': 'str'
    }

    attribute_map = {
        'ecdsa_passphrase': 'ecdsa_passphrase',
        'ecdsa_private_key': 'ecdsa_private_key'
    }

    def __init__(self, ecdsa_passphrase=None, ecdsa_private_key=None, _configuration=None):  # noqa: E501
        """RepositoryEcdsaKeyCreate - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._ecdsa_passphrase = None
        self._ecdsa_private_key = None
        self.discriminator = None

        if ecdsa_passphrase is not None:
            self.ecdsa_passphrase = ecdsa_passphrase
        self.ecdsa_private_key = ecdsa_private_key

    @property
    def ecdsa_passphrase(self):
        """Gets the ecdsa_passphrase of this RepositoryEcdsaKeyCreate.

        The ECDSA passphrase used for signing.

        :return: The ecdsa_passphrase of this RepositoryEcdsaKeyCreate.
        :rtype: str
        """
        return self._ecdsa_passphrase

    @ecdsa_passphrase.setter
    def ecdsa_passphrase(self, ecdsa_passphrase):
        """Sets the ecdsa_passphrase of this RepositoryEcdsaKeyCreate.

        The ECDSA passphrase used for signing.

        :param ecdsa_passphrase: The ecdsa_passphrase of this RepositoryEcdsaKeyCreate.
        :type: str
        """
        if (self._configuration.client_side_validation and
                ecdsa_passphrase is not None and len(ecdsa_passphrase) < 1):
            raise ValueError("Invalid value for `ecdsa_passphrase`, length must be greater than or equal to `1`")  # noqa: E501

        self._ecdsa_passphrase = ecdsa_passphrase

    @property
    def ecdsa_private_key(self):
        """Gets the ecdsa_private_key of this RepositoryEcdsaKeyCreate.

        The ECDSA private key.

        :return: The ecdsa_private_key of this RepositoryEcdsaKeyCreate.
        :rtype: str
        """
        return self._ecdsa_private_key

    @ecdsa_private_key.setter
    def ecdsa_private_key(self, ecdsa_private_key):
        """Sets the ecdsa_private_key of this RepositoryEcdsaKeyCreate.

        The ECDSA private key.

        :param ecdsa_private_key: The ecdsa_private_key of this RepositoryEcdsaKeyCreate.
        :type: str
        """
        if self._configuration.client_side_validation and ecdsa_private_key is None:
            raise ValueError("Invalid value for `ecdsa_private_key`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                ecdsa_private_key is not None and len(ecdsa_private_key) < 1):
            raise ValueError("Invalid value for `ecdsa_private_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._ecdsa_private_key = ecdsa_private_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RepositoryEcdsaKeyCreate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositoryEcdsaKeyCreate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositoryEcdsaKeyCreate):
            return True

        return self.to_dict() != other.to_dict()

