# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RepositoryPrivilegeDict(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'privilege': 'str',
        'service': 'str',
        'team': 'str',
        'user': 'str'
    }

    attribute_map = {
        'privilege': 'privilege',
        'service': 'service',
        'team': 'team',
        'user': 'user'
    }

    def __init__(self, privilege=None, service=None, team=None, user=None, _configuration=None):  # noqa: E501
        """RepositoryPrivilegeDict - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._privilege = None
        self._service = None
        self._team = None
        self._user = None
        self.discriminator = None

        self.privilege = privilege
        if service is not None:
            self.service = service
        if team is not None:
            self.team = team
        if user is not None:
            self.user = user

    @property
    def privilege(self):
        """Gets the privilege of this RepositoryPrivilegeDict.

        The level of privilege that the user or team should be granted to the specified repository.

        :return: The privilege of this RepositoryPrivilegeDict.
        :rtype: str
        """
        return self._privilege

    @privilege.setter
    def privilege(self, privilege):
        """Sets the privilege of this RepositoryPrivilegeDict.

        The level of privilege that the user or team should be granted to the specified repository.

        :param privilege: The privilege of this RepositoryPrivilegeDict.
        :type: str
        """
        if self._configuration.client_side_validation and privilege is None:
            raise ValueError("Invalid value for `privilege`, must not be `None`")  # noqa: E501
        allowed_values = ["Admin", "Write", "Read"]  # noqa: E501
        if (self._configuration.client_side_validation and
                privilege not in allowed_values):
            raise ValueError(
                "Invalid value for `privilege` ({0}), must be one of {1}"  # noqa: E501
                .format(privilege, allowed_values)
            )

        self._privilege = privilege

    @property
    def service(self):
        """Gets the service of this RepositoryPrivilegeDict.

        The service identifier (slug).

        :return: The service of this RepositoryPrivilegeDict.
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service):
        """Sets the service of this RepositoryPrivilegeDict.

        The service identifier (slug).

        :param service: The service of this RepositoryPrivilegeDict.
        :type: str
        """
        if (self._configuration.client_side_validation and
                service is not None and len(service) < 1):
            raise ValueError("Invalid value for `service`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                service is not None and not re.search('^[-a-zA-Z0-9_]+$', service)):  # noqa: E501
            raise ValueError(r"Invalid value for `service`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._service = service

    @property
    def team(self):
        """Gets the team of this RepositoryPrivilegeDict.

        The team identifier (slug).

        :return: The team of this RepositoryPrivilegeDict.
        :rtype: str
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this RepositoryPrivilegeDict.

        The team identifier (slug).

        :param team: The team of this RepositoryPrivilegeDict.
        :type: str
        """
        if (self._configuration.client_side_validation and
                team is not None and len(team) < 1):
            raise ValueError("Invalid value for `team`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                team is not None and not re.search('^[-a-zA-Z0-9_]+$', team)):  # noqa: E501
            raise ValueError(r"Invalid value for `team`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._team = team

    @property
    def user(self):
        """Gets the user of this RepositoryPrivilegeDict.

        The user identifier (slug).

        :return: The user of this RepositoryPrivilegeDict.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this RepositoryPrivilegeDict.

        The user identifier (slug).

        :param user: The user of this RepositoryPrivilegeDict.
        :type: str
        """
        if (self._configuration.client_side_validation and
                user is not None and len(user) < 1):
            raise ValueError("Invalid value for `user`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                user is not None and not re.search('^[-a-zA-Z0-9_]+$', user)):  # noqa: E501
            raise ValueError(r"Invalid value for `user`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RepositoryPrivilegeDict, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositoryPrivilegeDict):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositoryPrivilegeDict):
            return True

        return self.to_dict() != other.to_dict()

