# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RepositoryRsaKey(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'active': 'bool',
        'created_at': 'datetime',
        'default': 'bool',
        'fingerprint': 'str',
        'fingerprint_short': 'str',
        'public_key': 'str',
        'ssh_fingerprint': 'str'
    }

    attribute_map = {
        'active': 'active',
        'created_at': 'created_at',
        'default': 'default',
        'fingerprint': 'fingerprint',
        'fingerprint_short': 'fingerprint_short',
        'public_key': 'public_key',
        'ssh_fingerprint': 'ssh_fingerprint'
    }

    def __init__(self, active=None, created_at=None, default=None, fingerprint=None, fingerprint_short=None, public_key=None, ssh_fingerprint=None, _configuration=None):  # noqa: E501
        """RepositoryRsaKey - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._active = None
        self._created_at = None
        self._default = None
        self._fingerprint = None
        self._fingerprint_short = None
        self._public_key = None
        self._ssh_fingerprint = None
        self.discriminator = None

        if active is not None:
            self.active = active
        if created_at is not None:
            self.created_at = created_at
        if default is not None:
            self.default = default
        if fingerprint is not None:
            self.fingerprint = fingerprint
        if fingerprint_short is not None:
            self.fingerprint_short = fingerprint_short
        if public_key is not None:
            self.public_key = public_key
        if ssh_fingerprint is not None:
            self.ssh_fingerprint = ssh_fingerprint

    @property
    def active(self):
        """Gets the active of this RepositoryRsaKey.

        If selected this is the active key for this repository.

        :return: The active of this RepositoryRsaKey.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this RepositoryRsaKey.

        If selected this is the active key for this repository.

        :param active: The active of this RepositoryRsaKey.
        :type: bool
        """

        self._active = active

    @property
    def created_at(self):
        """Gets the created_at of this RepositoryRsaKey.


        :return: The created_at of this RepositoryRsaKey.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this RepositoryRsaKey.


        :param created_at: The created_at of this RepositoryRsaKey.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def default(self):
        """Gets the default of this RepositoryRsaKey.

        If selected this is the default key for this repository.

        :return: The default of this RepositoryRsaKey.
        :rtype: bool
        """
        return self._default

    @default.setter
    def default(self, default):
        """Sets the default of this RepositoryRsaKey.

        If selected this is the default key for this repository.

        :param default: The default of this RepositoryRsaKey.
        :type: bool
        """

        self._default = default

    @property
    def fingerprint(self):
        """Gets the fingerprint of this RepositoryRsaKey.

        The long identifier used by RSA for this key.

        :return: The fingerprint of this RepositoryRsaKey.
        :rtype: str
        """
        return self._fingerprint

    @fingerprint.setter
    def fingerprint(self, fingerprint):
        """Sets the fingerprint of this RepositoryRsaKey.

        The long identifier used by RSA for this key.

        :param fingerprint: The fingerprint of this RepositoryRsaKey.
        :type: str
        """
        if (self._configuration.client_side_validation and
                fingerprint is not None and len(fingerprint) < 1):
            raise ValueError("Invalid value for `fingerprint`, length must be greater than or equal to `1`")  # noqa: E501

        self._fingerprint = fingerprint

    @property
    def fingerprint_short(self):
        """Gets the fingerprint_short of this RepositoryRsaKey.


        :return: The fingerprint_short of this RepositoryRsaKey.
        :rtype: str
        """
        return self._fingerprint_short

    @fingerprint_short.setter
    def fingerprint_short(self, fingerprint_short):
        """Sets the fingerprint_short of this RepositoryRsaKey.


        :param fingerprint_short: The fingerprint_short of this RepositoryRsaKey.
        :type: str
        """

        self._fingerprint_short = fingerprint_short

    @property
    def public_key(self):
        """Gets the public_key of this RepositoryRsaKey.

        The public key given to repository users.

        :return: The public_key of this RepositoryRsaKey.
        :rtype: str
        """
        return self._public_key

    @public_key.setter
    def public_key(self, public_key):
        """Sets the public_key of this RepositoryRsaKey.

        The public key given to repository users.

        :param public_key: The public_key of this RepositoryRsaKey.
        :type: str
        """
        if (self._configuration.client_side_validation and
                public_key is not None and len(public_key) < 1):
            raise ValueError("Invalid value for `public_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._public_key = public_key

    @property
    def ssh_fingerprint(self):
        """Gets the ssh_fingerprint of this RepositoryRsaKey.

        The SSH fingerprint used by RSA for this key.

        :return: The ssh_fingerprint of this RepositoryRsaKey.
        :rtype: str
        """
        return self._ssh_fingerprint

    @ssh_fingerprint.setter
    def ssh_fingerprint(self, ssh_fingerprint):
        """Sets the ssh_fingerprint of this RepositoryRsaKey.

        The SSH fingerprint used by RSA for this key.

        :param ssh_fingerprint: The ssh_fingerprint of this RepositoryRsaKey.
        :type: str
        """

        self._ssh_fingerprint = ssh_fingerprint

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RepositoryRsaKey, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositoryRsaKey):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositoryRsaKey):
            return True

        return self.to_dict() != other.to_dict()

