# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class SwiftPackageUploadRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'author_name': 'str',
        'author_org': 'str',
        'license_url': 'str',
        'name': 'str',
        'package_file': 'str',
        'readme_url': 'str',
        'repository_url': 'str',
        'republish': 'bool',
        'scope': 'str',
        'tags': 'str',
        'version': 'str'
    }

    attribute_map = {
        'author_name': 'author_name',
        'author_org': 'author_org',
        'license_url': 'license_url',
        'name': 'name',
        'package_file': 'package_file',
        'readme_url': 'readme_url',
        'repository_url': 'repository_url',
        'republish': 'republish',
        'scope': 'scope',
        'tags': 'tags',
        'version': 'version'
    }

    def __init__(self, author_name=None, author_org=None, license_url=None, name=None, package_file=None, readme_url=None, repository_url=None, republish=None, scope=None, tags=None, version=None, _configuration=None):  # noqa: E501
        """SwiftPackageUploadRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._author_name = None
        self._author_org = None
        self._license_url = None
        self._name = None
        self._package_file = None
        self._readme_url = None
        self._repository_url = None
        self._republish = None
        self._scope = None
        self._tags = None
        self._version = None
        self.discriminator = None

        if author_name is not None:
            self.author_name = author_name
        if author_org is not None:
            self.author_org = author_org
        if license_url is not None:
            self.license_url = license_url
        self.name = name
        self.package_file = package_file
        if readme_url is not None:
            self.readme_url = readme_url
        if repository_url is not None:
            self.repository_url = repository_url
        if republish is not None:
            self.republish = republish
        self.scope = scope
        if tags is not None:
            self.tags = tags
        self.version = version

    @property
    def author_name(self):
        """Gets the author_name of this SwiftPackageUploadRequest.

        The name of the author of the package.

        :return: The author_name of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._author_name

    @author_name.setter
    def author_name(self, author_name):
        """Sets the author_name of this SwiftPackageUploadRequest.

        The name of the author of the package.

        :param author_name: The author_name of this SwiftPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                author_name is not None and len(author_name) < 1):
            raise ValueError("Invalid value for `author_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._author_name = author_name

    @property
    def author_org(self):
        """Gets the author_org of this SwiftPackageUploadRequest.

        The organization of the author.

        :return: The author_org of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._author_org

    @author_org.setter
    def author_org(self, author_org):
        """Sets the author_org of this SwiftPackageUploadRequest.

        The organization of the author.

        :param author_org: The author_org of this SwiftPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                author_org is not None and len(author_org) < 1):
            raise ValueError("Invalid value for `author_org`, length must be greater than or equal to `1`")  # noqa: E501

        self._author_org = author_org

    @property
    def license_url(self):
        """Gets the license_url of this SwiftPackageUploadRequest.

        The license URL of this package.

        :return: The license_url of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._license_url

    @license_url.setter
    def license_url(self, license_url):
        """Sets the license_url of this SwiftPackageUploadRequest.

        The license URL of this package.

        :param license_url: The license_url of this SwiftPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                license_url is not None and len(license_url) > 200):
            raise ValueError("Invalid value for `license_url`, length must be less than or equal to `200`")  # noqa: E501

        self._license_url = license_url

    @property
    def name(self):
        """Gets the name of this SwiftPackageUploadRequest.

        The name of this package.

        :return: The name of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SwiftPackageUploadRequest.

        The name of this package.

        :param name: The name of this SwiftPackageUploadRequest.
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) > 200):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `200`")  # noqa: E501

        self._name = name

    @property
    def package_file(self):
        """Gets the package_file of this SwiftPackageUploadRequest.

        The primary file for the package.

        :return: The package_file of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._package_file

    @package_file.setter
    def package_file(self, package_file):
        """Sets the package_file of this SwiftPackageUploadRequest.

        The primary file for the package.

        :param package_file: The package_file of this SwiftPackageUploadRequest.
        :type: str
        """
        if self._configuration.client_side_validation and package_file is None:
            raise ValueError("Invalid value for `package_file`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                package_file is not None and len(package_file) < 1):
            raise ValueError("Invalid value for `package_file`, length must be greater than or equal to `1`")  # noqa: E501

        self._package_file = package_file

    @property
    def readme_url(self):
        """Gets the readme_url of this SwiftPackageUploadRequest.

        The URL of the readme for the package.

        :return: The readme_url of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._readme_url

    @readme_url.setter
    def readme_url(self, readme_url):
        """Sets the readme_url of this SwiftPackageUploadRequest.

        The URL of the readme for the package.

        :param readme_url: The readme_url of this SwiftPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                readme_url is not None and len(readme_url) < 1):
            raise ValueError("Invalid value for `readme_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._readme_url = readme_url

    @property
    def repository_url(self):
        """Gets the repository_url of this SwiftPackageUploadRequest.

        The URL of the SCM repository for the package.

        :return: The repository_url of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._repository_url

    @repository_url.setter
    def repository_url(self, repository_url):
        """Sets the repository_url of this SwiftPackageUploadRequest.

        The URL of the SCM repository for the package.

        :param repository_url: The repository_url of this SwiftPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                repository_url is not None and len(repository_url) < 1):
            raise ValueError("Invalid value for `repository_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._repository_url = repository_url

    @property
    def republish(self):
        """Gets the republish of this SwiftPackageUploadRequest.

        If true, the uploaded package will overwrite any others with the same attributes (e.g. same version); otherwise, it will be flagged as a duplicate.

        :return: The republish of this SwiftPackageUploadRequest.
        :rtype: bool
        """
        return self._republish

    @republish.setter
    def republish(self, republish):
        """Sets the republish of this SwiftPackageUploadRequest.

        If true, the uploaded package will overwrite any others with the same attributes (e.g. same version); otherwise, it will be flagged as a duplicate.

        :param republish: The republish of this SwiftPackageUploadRequest.
        :type: bool
        """

        self._republish = republish

    @property
    def scope(self):
        """Gets the scope of this SwiftPackageUploadRequest.

        A scope provides a namespace for related packages within the package registry.

        :return: The scope of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this SwiftPackageUploadRequest.

        A scope provides a namespace for related packages within the package registry.

        :param scope: The scope of this SwiftPackageUploadRequest.
        :type: str
        """
        if self._configuration.client_side_validation and scope is None:
            raise ValueError("Invalid value for `scope`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                scope is not None and len(scope) > 39):
            raise ValueError("Invalid value for `scope`, length must be less than or equal to `39`")  # noqa: E501
        if (self._configuration.client_side_validation and
                scope is not None and len(scope) < 1):
            raise ValueError("Invalid value for `scope`, length must be greater than or equal to `1`")  # noqa: E501

        self._scope = scope

    @property
    def tags(self):
        """Gets the tags of this SwiftPackageUploadRequest.

        A comma-separated values list of tags to add to the package.

        :return: The tags of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this SwiftPackageUploadRequest.

        A comma-separated values list of tags to add to the package.

        :param tags: The tags of this SwiftPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                tags is not None and len(tags) > 1024):
            raise ValueError("Invalid value for `tags`, length must be less than or equal to `1024`")  # noqa: E501
        if (self._configuration.client_side_validation and
                tags is not None and len(tags) < 1):
            raise ValueError("Invalid value for `tags`, length must be greater than or equal to `1`")  # noqa: E501

        self._tags = tags

    @property
    def version(self):
        """Gets the version of this SwiftPackageUploadRequest.

        The raw version for this package.

        :return: The version of this SwiftPackageUploadRequest.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this SwiftPackageUploadRequest.

        The raw version for this package.

        :param version: The version of this SwiftPackageUploadRequest.
        :type: str
        """
        if self._configuration.client_side_validation and version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                version is not None and len(version) > 128):
            raise ValueError("Invalid value for `version`, length must be less than or equal to `128`")  # noqa: E501

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SwiftPackageUploadRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SwiftPackageUploadRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SwiftPackageUploadRequest):
            return True

        return self.to_dict() != other.to_dict()

