# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class VulnerabilityScanResults(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_at': 'datetime',
        'has_vulnerabilities': 'bool',
        'identifier': 'str',
        'max_severity': 'str',
        'num_vulnerabilities': 'int',
        'package': 'PackageVulnerability',
        'scan_id': 'int',
        'scans': 'list[VulnerabilityScan]'
    }

    attribute_map = {
        'created_at': 'created_at',
        'has_vulnerabilities': 'has_vulnerabilities',
        'identifier': 'identifier',
        'max_severity': 'max_severity',
        'num_vulnerabilities': 'num_vulnerabilities',
        'package': 'package',
        'scan_id': 'scan_id',
        'scans': 'scans'
    }

    def __init__(self, created_at=None, has_vulnerabilities=None, identifier=None, max_severity='Unknown', num_vulnerabilities=None, package=None, scan_id=None, scans=None, _configuration=None):  # noqa: E501
        """VulnerabilityScanResults - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._created_at = None
        self._has_vulnerabilities = None
        self._identifier = None
        self._max_severity = None
        self._num_vulnerabilities = None
        self._package = None
        self._scan_id = None
        self._scans = None
        self.discriminator = None

        if created_at is not None:
            self.created_at = created_at
        if has_vulnerabilities is not None:
            self.has_vulnerabilities = has_vulnerabilities
        self.identifier = identifier
        if max_severity is not None:
            self.max_severity = max_severity
        if num_vulnerabilities is not None:
            self.num_vulnerabilities = num_vulnerabilities
        self.package = package
        self.scan_id = scan_id
        self.scans = scans

    @property
    def created_at(self):
        """Gets the created_at of this VulnerabilityScanResults.

        The time this scan result was stored.

        :return: The created_at of this VulnerabilityScanResults.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this VulnerabilityScanResults.

        The time this scan result was stored.

        :param created_at: The created_at of this VulnerabilityScanResults.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def has_vulnerabilities(self):
        """Gets the has_vulnerabilities of this VulnerabilityScanResults.

        Do the results contain any known vulnerabilities?

        :return: The has_vulnerabilities of this VulnerabilityScanResults.
        :rtype: bool
        """
        return self._has_vulnerabilities

    @has_vulnerabilities.setter
    def has_vulnerabilities(self, has_vulnerabilities):
        """Sets the has_vulnerabilities of this VulnerabilityScanResults.

        Do the results contain any known vulnerabilities?

        :param has_vulnerabilities: The has_vulnerabilities of this VulnerabilityScanResults.
        :type: bool
        """

        self._has_vulnerabilities = has_vulnerabilities

    @property
    def identifier(self):
        """Gets the identifier of this VulnerabilityScanResults.


        :return: The identifier of this VulnerabilityScanResults.
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this VulnerabilityScanResults.


        :param identifier: The identifier of this VulnerabilityScanResults.
        :type: str
        """
        if self._configuration.client_side_validation and identifier is None:
            raise ValueError("Invalid value for `identifier`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                identifier is not None and len(identifier) < 1):
            raise ValueError("Invalid value for `identifier`, length must be greater than or equal to `1`")  # noqa: E501

        self._identifier = identifier

    @property
    def max_severity(self):
        """Gets the max_severity of this VulnerabilityScanResults.


        :return: The max_severity of this VulnerabilityScanResults.
        :rtype: str
        """
        return self._max_severity

    @max_severity.setter
    def max_severity(self, max_severity):
        """Sets the max_severity of this VulnerabilityScanResults.


        :param max_severity: The max_severity of this VulnerabilityScanResults.
        :type: str
        """
        allowed_values = ["Unknown", "Low", "Medium", "High", "Critical"]  # noqa: E501
        if (self._configuration.client_side_validation and
                max_severity not in allowed_values):
            raise ValueError(
                "Invalid value for `max_severity` ({0}), must be one of {1}"  # noqa: E501
                .format(max_severity, allowed_values)
            )

        self._max_severity = max_severity

    @property
    def num_vulnerabilities(self):
        """Gets the num_vulnerabilities of this VulnerabilityScanResults.


        :return: The num_vulnerabilities of this VulnerabilityScanResults.
        :rtype: int
        """
        return self._num_vulnerabilities

    @num_vulnerabilities.setter
    def num_vulnerabilities(self, num_vulnerabilities):
        """Sets the num_vulnerabilities of this VulnerabilityScanResults.


        :param num_vulnerabilities: The num_vulnerabilities of this VulnerabilityScanResults.
        :type: int
        """

        self._num_vulnerabilities = num_vulnerabilities

    @property
    def package(self):
        """Gets the package of this VulnerabilityScanResults.


        :return: The package of this VulnerabilityScanResults.
        :rtype: PackageVulnerability
        """
        return self._package

    @package.setter
    def package(self, package):
        """Sets the package of this VulnerabilityScanResults.


        :param package: The package of this VulnerabilityScanResults.
        :type: PackageVulnerability
        """
        if self._configuration.client_side_validation and package is None:
            raise ValueError("Invalid value for `package`, must not be `None`")  # noqa: E501

        self._package = package

    @property
    def scan_id(self):
        """Gets the scan_id of this VulnerabilityScanResults.

        Deprecated (23-05-15): Please use 'identifier' instead. Previously: A monotonically increasing number that identified a scan within a repository.

        :return: The scan_id of this VulnerabilityScanResults.
        :rtype: int
        """
        return self._scan_id

    @scan_id.setter
    def scan_id(self, scan_id):
        """Sets the scan_id of this VulnerabilityScanResults.

        Deprecated (23-05-15): Please use 'identifier' instead. Previously: A monotonically increasing number that identified a scan within a repository.

        :param scan_id: The scan_id of this VulnerabilityScanResults.
        :type: int
        """
        if self._configuration.client_side_validation and scan_id is None:
            raise ValueError("Invalid value for `scan_id`, must not be `None`")  # noqa: E501

        self._scan_id = scan_id

    @property
    def scans(self):
        """Gets the scans of this VulnerabilityScanResults.


        :return: The scans of this VulnerabilityScanResults.
        :rtype: list[VulnerabilityScan]
        """
        return self._scans

    @scans.setter
    def scans(self, scans):
        """Sets the scans of this VulnerabilityScanResults.


        :param scans: The scans of this VulnerabilityScanResults.
        :type: list[VulnerabilityScan]
        """
        if self._configuration.client_side_validation and scans is None:
            raise ValueError("Invalid value for `scans`, must not be `None`")  # noqa: E501

        self._scans = scans

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VulnerabilityScanResults, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VulnerabilityScanResults):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VulnerabilityScanResults):
            return True

        return self.to_dict() != other.to_dict()

