"Main interface for dynamodb type defs"
from __future__ import annotations

from datetime import datetime
from typing import Dict, List
from typing_extensions import TypedDict


__all__ = (
    "ClientBatchGetItemRequestItemsKeysTypeDef",
    "ClientBatchGetItemRequestItemsTypeDef",
    "ClientBatchGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientBatchGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientBatchGetItemResponseConsumedCapacityTableTypeDef",
    "ClientBatchGetItemResponseConsumedCapacityTypeDef",
    "ClientBatchGetItemResponseResponsesTypeDef",
    "ClientBatchGetItemResponseUnprocessedKeysKeysTypeDef",
    "ClientBatchGetItemResponseUnprocessedKeysTypeDef",
    "ClientBatchGetItemResponseTypeDef",
    "ClientBatchWriteItemRequestItemsDeleteRequestKeyTypeDef",
    "ClientBatchWriteItemRequestItemsDeleteRequestTypeDef",
    "ClientBatchWriteItemRequestItemsPutRequestItemTypeDef",
    "ClientBatchWriteItemRequestItemsPutRequestTypeDef",
    "ClientBatchWriteItemRequestItemsTypeDef",
    "ClientBatchWriteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientBatchWriteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientBatchWriteItemResponseConsumedCapacityTableTypeDef",
    "ClientBatchWriteItemResponseConsumedCapacityTypeDef",
    "ClientBatchWriteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "ClientBatchWriteItemResponseItemCollectionMetricsTypeDef",
    "ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestKeyTypeDef",
    "ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestTypeDef",
    "ClientBatchWriteItemResponseUnprocessedItemsPutRequestItemTypeDef",
    "ClientBatchWriteItemResponseUnprocessedItemsPutRequestTypeDef",
    "ClientBatchWriteItemResponseUnprocessedItemsTypeDef",
    "ClientBatchWriteItemResponseTypeDef",
    "ClientCreateBackupResponseBackupDetailsTypeDef",
    "ClientCreateBackupResponseTypeDef",
    "ClientCreateGlobalTableReplicationGroupTypeDef",
    "ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef",
    "ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef",
    "ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef",
    "ClientCreateGlobalTableResponseGlobalTableDescriptionTypeDef",
    "ClientCreateGlobalTableResponseTypeDef",
    "ClientCreateTableAttributeDefinitionsTypeDef",
    "ClientCreateTableGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientCreateTableGlobalSecondaryIndexesProjectionTypeDef",
    "ClientCreateTableGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientCreateTableGlobalSecondaryIndexesTypeDef",
    "ClientCreateTableKeySchemaTypeDef",
    "ClientCreateTableLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientCreateTableLocalSecondaryIndexesProjectionTypeDef",
    "ClientCreateTableLocalSecondaryIndexesTypeDef",
    "ClientCreateTableProvisionedThroughputTypeDef",
    "ClientCreateTableResponseTableDescriptionAttributeDefinitionsTypeDef",
    "ClientCreateTableResponseTableDescriptionBillingModeSummaryTypeDef",
    "ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    "ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    "ClientCreateTableResponseTableDescriptionKeySchemaTypeDef",
    "ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    "ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    "ClientCreateTableResponseTableDescriptionProvisionedThroughputTypeDef",
    "ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "ClientCreateTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    "ClientCreateTableResponseTableDescriptionReplicasTypeDef",
    "ClientCreateTableResponseTableDescriptionRestoreSummaryTypeDef",
    "ClientCreateTableResponseTableDescriptionSSEDescriptionTypeDef",
    "ClientCreateTableResponseTableDescriptionStreamSpecificationTypeDef",
    "ClientCreateTableResponseTableDescriptionTypeDef",
    "ClientCreateTableResponseTypeDef",
    "ClientCreateTableSSESpecificationTypeDef",
    "ClientCreateTableStreamSpecificationTypeDef",
    "ClientCreateTableTagsTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionBackupDetailsTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef",
    "ClientDeleteBackupResponseBackupDescriptionTypeDef",
    "ClientDeleteBackupResponseTypeDef",
    "ClientDeleteItemExpectedAttributeValueListTypeDef",
    "ClientDeleteItemExpectedValueTypeDef",
    "ClientDeleteItemExpectedTypeDef",
    "ClientDeleteItemExpressionAttributeValuesTypeDef",
    "ClientDeleteItemKeyTypeDef",
    "ClientDeleteItemResponseAttributesTypeDef",
    "ClientDeleteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientDeleteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientDeleteItemResponseConsumedCapacityTableTypeDef",
    "ClientDeleteItemResponseConsumedCapacityTypeDef",
    "ClientDeleteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "ClientDeleteItemResponseItemCollectionMetricsTypeDef",
    "ClientDeleteItemResponseTypeDef",
    "ClientDeleteTableResponseTableDescriptionAttributeDefinitionsTypeDef",
    "ClientDeleteTableResponseTableDescriptionBillingModeSummaryTypeDef",
    "ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    "ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    "ClientDeleteTableResponseTableDescriptionKeySchemaTypeDef",
    "ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    "ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    "ClientDeleteTableResponseTableDescriptionProvisionedThroughputTypeDef",
    "ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "ClientDeleteTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    "ClientDeleteTableResponseTableDescriptionReplicasTypeDef",
    "ClientDeleteTableResponseTableDescriptionRestoreSummaryTypeDef",
    "ClientDeleteTableResponseTableDescriptionSSEDescriptionTypeDef",
    "ClientDeleteTableResponseTableDescriptionStreamSpecificationTypeDef",
    "ClientDeleteTableResponseTableDescriptionTypeDef",
    "ClientDeleteTableResponseTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionBackupDetailsTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef",
    "ClientDescribeBackupResponseBackupDescriptionTypeDef",
    "ClientDescribeBackupResponseTypeDef",
    "ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionPointInTimeRecoveryDescriptionTypeDef",
    "ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionTypeDef",
    "ClientDescribeContinuousBackupsResponseTypeDef",
    "ClientDescribeEndpointsResponseEndpointsTypeDef",
    "ClientDescribeEndpointsResponseTypeDef",
    "ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef",
    "ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef",
    "ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef",
    "ClientDescribeGlobalTableResponseGlobalTableDescriptionTypeDef",
    "ClientDescribeGlobalTableResponseTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaBillingModeSummaryTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeGlobalTableSettingsResponseReplicaSettingsTypeDef",
    "ClientDescribeGlobalTableSettingsResponseTypeDef",
    "ClientDescribeLimitsResponseTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionTypeDef",
    "ClientDescribeTableReplicaAutoScalingResponseTypeDef",
    "ClientDescribeTableResponseTableAttributeDefinitionsTypeDef",
    "ClientDescribeTableResponseTableBillingModeSummaryTypeDef",
    "ClientDescribeTableResponseTableGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientDescribeTableResponseTableGlobalSecondaryIndexesProjectionTypeDef",
    "ClientDescribeTableResponseTableGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientDescribeTableResponseTableGlobalSecondaryIndexesTypeDef",
    "ClientDescribeTableResponseTableKeySchemaTypeDef",
    "ClientDescribeTableResponseTableLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientDescribeTableResponseTableLocalSecondaryIndexesProjectionTypeDef",
    "ClientDescribeTableResponseTableLocalSecondaryIndexesTypeDef",
    "ClientDescribeTableResponseTableProvisionedThroughputTypeDef",
    "ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesTypeDef",
    "ClientDescribeTableResponseTableReplicasProvisionedThroughputOverrideTypeDef",
    "ClientDescribeTableResponseTableReplicasTypeDef",
    "ClientDescribeTableResponseTableRestoreSummaryTypeDef",
    "ClientDescribeTableResponseTableSSEDescriptionTypeDef",
    "ClientDescribeTableResponseTableStreamSpecificationTypeDef",
    "ClientDescribeTableResponseTableTypeDef",
    "ClientDescribeTableResponseTypeDef",
    "ClientDescribeTimeToLiveResponseTimeToLiveDescriptionTypeDef",
    "ClientDescribeTimeToLiveResponseTypeDef",
    "ClientGetItemKeyTypeDef",
    "ClientGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientGetItemResponseConsumedCapacityTableTypeDef",
    "ClientGetItemResponseConsumedCapacityTypeDef",
    "ClientGetItemResponseItemTypeDef",
    "ClientGetItemResponseTypeDef",
    "ClientListBackupsResponseBackupSummariesTypeDef",
    "ClientListBackupsResponseTypeDef",
    "ClientListGlobalTablesResponseGlobalTablesReplicationGroupTypeDef",
    "ClientListGlobalTablesResponseGlobalTablesTypeDef",
    "ClientListGlobalTablesResponseTypeDef",
    "ClientListTablesResponseTypeDef",
    "ClientListTagsOfResourceResponseTagsTypeDef",
    "ClientListTagsOfResourceResponseTypeDef",
    "ClientPutItemExpectedAttributeValueListTypeDef",
    "ClientPutItemExpectedValueTypeDef",
    "ClientPutItemExpectedTypeDef",
    "ClientPutItemExpressionAttributeValuesTypeDef",
    "ClientPutItemItemTypeDef",
    "ClientPutItemResponseAttributesTypeDef",
    "ClientPutItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientPutItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientPutItemResponseConsumedCapacityTableTypeDef",
    "ClientPutItemResponseConsumedCapacityTypeDef",
    "ClientPutItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "ClientPutItemResponseItemCollectionMetricsTypeDef",
    "ClientPutItemResponseTypeDef",
    "ClientQueryExclusiveStartKeyTypeDef",
    "ClientQueryExpressionAttributeValuesTypeDef",
    "ClientQueryKeyConditionsAttributeValueListTypeDef",
    "ClientQueryKeyConditionsTypeDef",
    "ClientQueryQueryFilterAttributeValueListTypeDef",
    "ClientQueryQueryFilterTypeDef",
    "ClientQueryResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientQueryResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientQueryResponseConsumedCapacityTableTypeDef",
    "ClientQueryResponseConsumedCapacityTypeDef",
    "ClientQueryResponseItemsTypeDef",
    "ClientQueryResponseLastEvaluatedKeyTypeDef",
    "ClientQueryResponseTypeDef",
    "ClientRestoreTableFromBackupGlobalSecondaryIndexOverrideKeySchemaTypeDef",
    "ClientRestoreTableFromBackupGlobalSecondaryIndexOverrideProjectionTypeDef",
    "ClientRestoreTableFromBackupGlobalSecondaryIndexOverrideProvisionedThroughputTypeDef",
    "ClientRestoreTableFromBackupGlobalSecondaryIndexOverrideTypeDef",
    "ClientRestoreTableFromBackupLocalSecondaryIndexOverrideKeySchemaTypeDef",
    "ClientRestoreTableFromBackupLocalSecondaryIndexOverrideProjectionTypeDef",
    "ClientRestoreTableFromBackupLocalSecondaryIndexOverrideTypeDef",
    "ClientRestoreTableFromBackupProvisionedThroughputOverrideTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionAttributeDefinitionsTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionBillingModeSummaryTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionKeySchemaTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionProvisionedThroughputTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionReplicasTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionRestoreSummaryTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionSSEDescriptionTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionStreamSpecificationTypeDef",
    "ClientRestoreTableFromBackupResponseTableDescriptionTypeDef",
    "ClientRestoreTableFromBackupResponseTypeDef",
    "ClientRestoreTableToPointInTimeGlobalSecondaryIndexOverrideKeySchemaTypeDef",
    "ClientRestoreTableToPointInTimeGlobalSecondaryIndexOverrideProjectionTypeDef",
    "ClientRestoreTableToPointInTimeGlobalSecondaryIndexOverrideProvisionedThroughputTypeDef",
    "ClientRestoreTableToPointInTimeGlobalSecondaryIndexOverrideTypeDef",
    "ClientRestoreTableToPointInTimeLocalSecondaryIndexOverrideKeySchemaTypeDef",
    "ClientRestoreTableToPointInTimeLocalSecondaryIndexOverrideProjectionTypeDef",
    "ClientRestoreTableToPointInTimeLocalSecondaryIndexOverrideTypeDef",
    "ClientRestoreTableToPointInTimeProvisionedThroughputOverrideTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionAttributeDefinitionsTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionBillingModeSummaryTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionKeySchemaTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionProvisionedThroughputTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionReplicasTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionRestoreSummaryTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionSSEDescriptionTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionStreamSpecificationTypeDef",
    "ClientRestoreTableToPointInTimeResponseTableDescriptionTypeDef",
    "ClientRestoreTableToPointInTimeResponseTypeDef",
    "ClientScanExclusiveStartKeyTypeDef",
    "ClientScanExpressionAttributeValuesTypeDef",
    "ClientScanResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientScanResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientScanResponseConsumedCapacityTableTypeDef",
    "ClientScanResponseConsumedCapacityTypeDef",
    "ClientScanResponseItemsTypeDef",
    "ClientScanResponseLastEvaluatedKeyTypeDef",
    "ClientScanResponseTypeDef",
    "ClientScanScanFilterAttributeValueListTypeDef",
    "ClientScanScanFilterTypeDef",
    "ClientTagResourceTagsTypeDef",
    "ClientTransactGetItemsResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientTransactGetItemsResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientTransactGetItemsResponseConsumedCapacityTableTypeDef",
    "ClientTransactGetItemsResponseConsumedCapacityTypeDef",
    "ClientTransactGetItemsResponseResponsesItemTypeDef",
    "ClientTransactGetItemsResponseResponsesTypeDef",
    "ClientTransactGetItemsResponseTypeDef",
    "ClientTransactGetItemsTransactItemsGetKeyTypeDef",
    "ClientTransactGetItemsTransactItemsGetTypeDef",
    "ClientTransactGetItemsTransactItemsTypeDef",
    "ClientTransactWriteItemsResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientTransactWriteItemsResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientTransactWriteItemsResponseConsumedCapacityTableTypeDef",
    "ClientTransactWriteItemsResponseConsumedCapacityTypeDef",
    "ClientTransactWriteItemsResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "ClientTransactWriteItemsResponseItemCollectionMetricsTypeDef",
    "ClientTransactWriteItemsResponseTypeDef",
    "ClientTransactWriteItemsTransactItemsConditionCheckExpressionAttributeValuesTypeDef",
    "ClientTransactWriteItemsTransactItemsConditionCheckKeyTypeDef",
    "ClientTransactWriteItemsTransactItemsConditionCheckTypeDef",
    "ClientTransactWriteItemsTransactItemsDeleteExpressionAttributeValuesTypeDef",
    "ClientTransactWriteItemsTransactItemsDeleteKeyTypeDef",
    "ClientTransactWriteItemsTransactItemsDeleteTypeDef",
    "ClientTransactWriteItemsTransactItemsPutExpressionAttributeValuesTypeDef",
    "ClientTransactWriteItemsTransactItemsPutItemTypeDef",
    "ClientTransactWriteItemsTransactItemsPutTypeDef",
    "ClientTransactWriteItemsTransactItemsUpdateExpressionAttributeValuesTypeDef",
    "ClientTransactWriteItemsTransactItemsUpdateKeyTypeDef",
    "ClientTransactWriteItemsTransactItemsUpdateTypeDef",
    "ClientTransactWriteItemsTransactItemsTypeDef",
    "ClientUpdateContinuousBackupsPointInTimeRecoverySpecificationTypeDef",
    "ClientUpdateContinuousBackupsResponseContinuousBackupsDescriptionPointInTimeRecoveryDescriptionTypeDef",
    "ClientUpdateContinuousBackupsResponseContinuousBackupsDescriptionTypeDef",
    "ClientUpdateContinuousBackupsResponseTypeDef",
    "ClientUpdateGlobalTableReplicaUpdatesCreateTypeDef",
    "ClientUpdateGlobalTableReplicaUpdatesDeleteTypeDef",
    "ClientUpdateGlobalTableReplicaUpdatesTypeDef",
    "ClientUpdateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientUpdateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef",
    "ClientUpdateGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef",
    "ClientUpdateGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef",
    "ClientUpdateGlobalTableResponseGlobalTableDescriptionTypeDef",
    "ClientUpdateGlobalTableResponseTypeDef",
    "ClientUpdateGlobalTableSettingsGlobalTableGlobalSecondaryIndexSettingsUpdateProvisionedWriteCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsGlobalTableGlobalSecondaryIndexSettingsUpdateProvisionedWriteCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsGlobalTableGlobalSecondaryIndexSettingsUpdateProvisionedWriteCapacityAutoScalingSettingsUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsGlobalTableGlobalSecondaryIndexSettingsUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateReplicaGlobalSecondaryIndexSettingsUpdateProvisionedReadCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateReplicaGlobalSecondaryIndexSettingsUpdateProvisionedReadCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateReplicaGlobalSecondaryIndexSettingsUpdateProvisionedReadCapacityAutoScalingSettingsUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateReplicaGlobalSecondaryIndexSettingsUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateReplicaProvisionedReadCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateReplicaProvisionedReadCapacityAutoScalingSettingsUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateReplicaProvisionedReadCapacityAutoScalingSettingsUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsReplicaSettingsUpdateTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaBillingModeSummaryTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateGlobalTableSettingsResponseReplicaSettingsTypeDef",
    "ClientUpdateGlobalTableSettingsResponseTypeDef",
    "ClientUpdateItemAttributeUpdatesValueTypeDef",
    "ClientUpdateItemAttributeUpdatesTypeDef",
    "ClientUpdateItemExpectedAttributeValueListTypeDef",
    "ClientUpdateItemExpectedValueTypeDef",
    "ClientUpdateItemExpectedTypeDef",
    "ClientUpdateItemExpressionAttributeValuesTypeDef",
    "ClientUpdateItemKeyTypeDef",
    "ClientUpdateItemResponseAttributesTypeDef",
    "ClientUpdateItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ClientUpdateItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ClientUpdateItemResponseConsumedCapacityTableTypeDef",
    "ClientUpdateItemResponseConsumedCapacityTypeDef",
    "ClientUpdateItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "ClientUpdateItemResponseItemCollectionMetricsTypeDef",
    "ClientUpdateItemResponseTypeDef",
    "ClientUpdateTableAttributeDefinitionsTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesCreateKeySchemaTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesCreateProjectionTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesCreateProvisionedThroughputTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesCreateTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesDeleteTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesUpdateProvisionedThroughputTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesUpdateTypeDef",
    "ClientUpdateTableGlobalSecondaryIndexUpdatesTypeDef",
    "ClientUpdateTableProvisionedThroughputTypeDef",
    "ClientUpdateTableReplicaAutoScalingGlobalSecondaryIndexUpdatesProvisionedWriteCapacityAutoScalingUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingGlobalSecondaryIndexUpdatesProvisionedWriteCapacityAutoScalingUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingGlobalSecondaryIndexUpdatesProvisionedWriteCapacityAutoScalingUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingGlobalSecondaryIndexUpdatesTypeDef",
    "ClientUpdateTableReplicaAutoScalingProvisionedWriteCapacityAutoScalingUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingProvisionedWriteCapacityAutoScalingUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingProvisionedWriteCapacityAutoScalingUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesReplicaGlobalSecondaryIndexUpdatesProvisionedReadCapacityAutoScalingUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesReplicaGlobalSecondaryIndexUpdatesProvisionedReadCapacityAutoScalingUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesReplicaGlobalSecondaryIndexUpdatesProvisionedReadCapacityAutoScalingUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesReplicaGlobalSecondaryIndexUpdatesTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesReplicaProvisionedReadCapacityAutoScalingUpdateScalingPolicyUpdateTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesReplicaProvisionedReadCapacityAutoScalingUpdateScalingPolicyUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesReplicaProvisionedReadCapacityAutoScalingUpdateTypeDef",
    "ClientUpdateTableReplicaAutoScalingReplicaUpdatesTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTableAutoScalingDescriptionTypeDef",
    "ClientUpdateTableReplicaAutoScalingResponseTypeDef",
    "ClientUpdateTableReplicaUpdatesCreateGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientUpdateTableReplicaUpdatesCreateGlobalSecondaryIndexesTypeDef",
    "ClientUpdateTableReplicaUpdatesCreateProvisionedThroughputOverrideTypeDef",
    "ClientUpdateTableReplicaUpdatesCreateTypeDef",
    "ClientUpdateTableReplicaUpdatesDeleteTypeDef",
    "ClientUpdateTableReplicaUpdatesUpdateGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientUpdateTableReplicaUpdatesUpdateGlobalSecondaryIndexesTypeDef",
    "ClientUpdateTableReplicaUpdatesUpdateProvisionedThroughputOverrideTypeDef",
    "ClientUpdateTableReplicaUpdatesUpdateTypeDef",
    "ClientUpdateTableReplicaUpdatesTypeDef",
    "ClientUpdateTableResponseTableDescriptionAttributeDefinitionsTypeDef",
    "ClientUpdateTableResponseTableDescriptionBillingModeSummaryTypeDef",
    "ClientUpdateTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    "ClientUpdateTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    "ClientUpdateTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ClientUpdateTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    "ClientUpdateTableResponseTableDescriptionKeySchemaTypeDef",
    "ClientUpdateTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    "ClientUpdateTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    "ClientUpdateTableResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    "ClientUpdateTableResponseTableDescriptionProvisionedThroughputTypeDef",
    "ClientUpdateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "ClientUpdateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "ClientUpdateTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    "ClientUpdateTableResponseTableDescriptionReplicasTypeDef",
    "ClientUpdateTableResponseTableDescriptionRestoreSummaryTypeDef",
    "ClientUpdateTableResponseTableDescriptionSSEDescriptionTypeDef",
    "ClientUpdateTableResponseTableDescriptionStreamSpecificationTypeDef",
    "ClientUpdateTableResponseTableDescriptionTypeDef",
    "ClientUpdateTableResponseTypeDef",
    "ClientUpdateTableSSESpecificationTypeDef",
    "ClientUpdateTableStreamSpecificationTypeDef",
    "ClientUpdateTimeToLiveResponseTimeToLiveSpecificationTypeDef",
    "ClientUpdateTimeToLiveResponseTypeDef",
    "ClientUpdateTimeToLiveTimeToLiveSpecificationTypeDef",
    "ListBackupsPaginatePaginationConfigTypeDef",
    "ListBackupsPaginateResponseBackupSummariesTypeDef",
    "ListBackupsPaginateResponseTypeDef",
    "ListTablesPaginatePaginationConfigTypeDef",
    "ListTablesPaginateResponseTypeDef",
    "ListTagsOfResourcePaginatePaginationConfigTypeDef",
    "ListTagsOfResourcePaginateResponseTagsTypeDef",
    "ListTagsOfResourcePaginateResponseTypeDef",
    "QueryPaginateExpressionAttributeValuesTypeDef",
    "QueryPaginateKeyConditionsAttributeValueListTypeDef",
    "QueryPaginateKeyConditionsTypeDef",
    "QueryPaginatePaginationConfigTypeDef",
    "QueryPaginateQueryFilterAttributeValueListTypeDef",
    "QueryPaginateQueryFilterTypeDef",
    "QueryPaginateResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "QueryPaginateResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "QueryPaginateResponseConsumedCapacityTableTypeDef",
    "QueryPaginateResponseConsumedCapacityTypeDef",
    "QueryPaginateResponseItemsTypeDef",
    "QueryPaginateResponseTypeDef",
    "ScanPaginateExpressionAttributeValuesTypeDef",
    "ScanPaginatePaginationConfigTypeDef",
    "ScanPaginateResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ScanPaginateResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ScanPaginateResponseConsumedCapacityTableTypeDef",
    "ScanPaginateResponseConsumedCapacityTypeDef",
    "ScanPaginateResponseItemsTypeDef",
    "ScanPaginateResponseTypeDef",
    "ScanPaginateScanFilterAttributeValueListTypeDef",
    "ScanPaginateScanFilterTypeDef",
    "ServiceResourceBatchGetItemRequestItemsKeysTypeDef",
    "ServiceResourceBatchGetItemRequestItemsTypeDef",
    "ServiceResourceBatchGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ServiceResourceBatchGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ServiceResourceBatchGetItemResponseConsumedCapacityTableTypeDef",
    "ServiceResourceBatchGetItemResponseConsumedCapacityTypeDef",
    "ServiceResourceBatchGetItemResponseResponsesTypeDef",
    "ServiceResourceBatchGetItemResponseUnprocessedKeysKeysTypeDef",
    "ServiceResourceBatchGetItemResponseUnprocessedKeysTypeDef",
    "ServiceResourceBatchGetItemResponseTypeDef",
    "ServiceResourceBatchWriteItemRequestItemsDeleteRequestKeyTypeDef",
    "ServiceResourceBatchWriteItemRequestItemsDeleteRequestTypeDef",
    "ServiceResourceBatchWriteItemRequestItemsPutRequestItemTypeDef",
    "ServiceResourceBatchWriteItemRequestItemsPutRequestTypeDef",
    "ServiceResourceBatchWriteItemRequestItemsTypeDef",
    "ServiceResourceBatchWriteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "ServiceResourceBatchWriteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "ServiceResourceBatchWriteItemResponseConsumedCapacityTableTypeDef",
    "ServiceResourceBatchWriteItemResponseConsumedCapacityTypeDef",
    "ServiceResourceBatchWriteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "ServiceResourceBatchWriteItemResponseItemCollectionMetricsTypeDef",
    "ServiceResourceBatchWriteItemResponseUnprocessedItemsDeleteRequestKeyTypeDef",
    "ServiceResourceBatchWriteItemResponseUnprocessedItemsDeleteRequestTypeDef",
    "ServiceResourceBatchWriteItemResponseUnprocessedItemsPutRequestItemTypeDef",
    "ServiceResourceBatchWriteItemResponseUnprocessedItemsPutRequestTypeDef",
    "ServiceResourceBatchWriteItemResponseUnprocessedItemsTypeDef",
    "ServiceResourceBatchWriteItemResponseTypeDef",
    "ServiceResourceCreateTableAttributeDefinitionsTypeDef",
    "ServiceResourceCreateTableGlobalSecondaryIndexesKeySchemaTypeDef",
    "ServiceResourceCreateTableGlobalSecondaryIndexesProjectionTypeDef",
    "ServiceResourceCreateTableGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "ServiceResourceCreateTableGlobalSecondaryIndexesTypeDef",
    "ServiceResourceCreateTableKeySchemaTypeDef",
    "ServiceResourceCreateTableLocalSecondaryIndexesKeySchemaTypeDef",
    "ServiceResourceCreateTableLocalSecondaryIndexesProjectionTypeDef",
    "ServiceResourceCreateTableLocalSecondaryIndexesTypeDef",
    "ServiceResourceCreateTableProvisionedThroughputTypeDef",
    "ServiceResourceCreateTableSSESpecificationTypeDef",
    "ServiceResourceCreateTableStreamSpecificationTypeDef",
    "ServiceResourceCreateTableTagsTypeDef",
    "TableDeleteItemExpectedAttributeValueListTypeDef",
    "TableDeleteItemExpectedValueTypeDef",
    "TableDeleteItemExpectedTypeDef",
    "TableDeleteItemExpressionAttributeValuesTypeDef",
    "TableDeleteItemKeyTypeDef",
    "TableDeleteItemResponseAttributesTypeDef",
    "TableDeleteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "TableDeleteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "TableDeleteItemResponseConsumedCapacityTableTypeDef",
    "TableDeleteItemResponseConsumedCapacityTypeDef",
    "TableDeleteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "TableDeleteItemResponseItemCollectionMetricsTypeDef",
    "TableDeleteItemResponseTypeDef",
    "TableDeleteResponseTableDescriptionAttributeDefinitionsTypeDef",
    "TableDeleteResponseTableDescriptionBillingModeSummaryTypeDef",
    "TableDeleteResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    "TableDeleteResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    "TableDeleteResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    "TableDeleteResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    "TableDeleteResponseTableDescriptionKeySchemaTypeDef",
    "TableDeleteResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    "TableDeleteResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    "TableDeleteResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    "TableDeleteResponseTableDescriptionProvisionedThroughputTypeDef",
    "TableDeleteResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "TableDeleteResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    "TableDeleteResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    "TableDeleteResponseTableDescriptionReplicasTypeDef",
    "TableDeleteResponseTableDescriptionRestoreSummaryTypeDef",
    "TableDeleteResponseTableDescriptionSSEDescriptionTypeDef",
    "TableDeleteResponseTableDescriptionStreamSpecificationTypeDef",
    "TableDeleteResponseTableDescriptionTypeDef",
    "TableDeleteResponseTypeDef",
    "TableExistsWaitWaiterConfigTypeDef",
    "TableGetItemKeyTypeDef",
    "TableGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "TableGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "TableGetItemResponseConsumedCapacityTableTypeDef",
    "TableGetItemResponseConsumedCapacityTypeDef",
    "TableGetItemResponseItemTypeDef",
    "TableGetItemResponseTypeDef",
    "TableNotExistsWaitWaiterConfigTypeDef",
    "TablePutItemExpectedAttributeValueListTypeDef",
    "TablePutItemExpectedValueTypeDef",
    "TablePutItemExpectedTypeDef",
    "TablePutItemExpressionAttributeValuesTypeDef",
    "TablePutItemItemTypeDef",
    "TablePutItemResponseAttributesTypeDef",
    "TablePutItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "TablePutItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "TablePutItemResponseConsumedCapacityTableTypeDef",
    "TablePutItemResponseConsumedCapacityTypeDef",
    "TablePutItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "TablePutItemResponseItemCollectionMetricsTypeDef",
    "TablePutItemResponseTypeDef",
    "TableQueryExclusiveStartKeyTypeDef",
    "TableQueryExpressionAttributeValuesTypeDef",
    "TableQueryKeyConditionsAttributeValueListTypeDef",
    "TableQueryKeyConditionsTypeDef",
    "TableQueryQueryFilterAttributeValueListTypeDef",
    "TableQueryQueryFilterTypeDef",
    "TableQueryResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "TableQueryResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "TableQueryResponseConsumedCapacityTableTypeDef",
    "TableQueryResponseConsumedCapacityTypeDef",
    "TableQueryResponseItemsTypeDef",
    "TableQueryResponseLastEvaluatedKeyTypeDef",
    "TableQueryResponseTypeDef",
    "TableScanExclusiveStartKeyTypeDef",
    "TableScanExpressionAttributeValuesTypeDef",
    "TableScanResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "TableScanResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "TableScanResponseConsumedCapacityTableTypeDef",
    "TableScanResponseConsumedCapacityTypeDef",
    "TableScanResponseItemsTypeDef",
    "TableScanResponseLastEvaluatedKeyTypeDef",
    "TableScanResponseTypeDef",
    "TableScanScanFilterAttributeValueListTypeDef",
    "TableScanScanFilterTypeDef",
    "TableUpdateAttributeDefinitionsTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesCreateKeySchemaTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesCreateProjectionTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesCreateProvisionedThroughputTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesCreateTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesDeleteTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesUpdateProvisionedThroughputTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesUpdateTypeDef",
    "TableUpdateGlobalSecondaryIndexUpdatesTypeDef",
    "TableUpdateItemAttributeUpdatesValueTypeDef",
    "TableUpdateItemAttributeUpdatesTypeDef",
    "TableUpdateItemExpectedAttributeValueListTypeDef",
    "TableUpdateItemExpectedValueTypeDef",
    "TableUpdateItemExpectedTypeDef",
    "TableUpdateItemExpressionAttributeValuesTypeDef",
    "TableUpdateItemKeyTypeDef",
    "TableUpdateItemResponseAttributesTypeDef",
    "TableUpdateItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    "TableUpdateItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    "TableUpdateItemResponseConsumedCapacityTableTypeDef",
    "TableUpdateItemResponseConsumedCapacityTypeDef",
    "TableUpdateItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    "TableUpdateItemResponseItemCollectionMetricsTypeDef",
    "TableUpdateItemResponseTypeDef",
    "TableUpdateProvisionedThroughputTypeDef",
    "TableUpdateReplicaUpdatesCreateGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "TableUpdateReplicaUpdatesCreateGlobalSecondaryIndexesTypeDef",
    "TableUpdateReplicaUpdatesCreateProvisionedThroughputOverrideTypeDef",
    "TableUpdateReplicaUpdatesCreateTypeDef",
    "TableUpdateReplicaUpdatesDeleteTypeDef",
    "TableUpdateReplicaUpdatesUpdateGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    "TableUpdateReplicaUpdatesUpdateGlobalSecondaryIndexesTypeDef",
    "TableUpdateReplicaUpdatesUpdateProvisionedThroughputOverrideTypeDef",
    "TableUpdateReplicaUpdatesUpdateTypeDef",
    "TableUpdateReplicaUpdatesTypeDef",
    "TableUpdateSSESpecificationTypeDef",
    "TableUpdateStreamSpecificationTypeDef",
)


_ClientBatchGetItemRequestItemsKeysTypeDef = TypedDict(
    "_ClientBatchGetItemRequestItemsKeysTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchGetItemRequestItemsKeysTypeDef(
    _ClientBatchGetItemRequestItemsKeysTypeDef
):
    """
    Type definition for `ClientBatchGetItemRequestItems` `Keys`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type,
    and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data
        type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_RequiredClientBatchGetItemRequestItemsTypeDef = TypedDict(
    "_RequiredClientBatchGetItemRequestItemsTypeDef",
    {"Keys": List[Dict[str, ClientBatchGetItemRequestItemsKeysTypeDef]]},
)
_OptionalClientBatchGetItemRequestItemsTypeDef = TypedDict(
    "_OptionalClientBatchGetItemRequestItemsTypeDef",
    {
        "AttributesToGet": List[str],
        "ConsistentRead": bool,
        "ProjectionExpression": str,
        "ExpressionAttributeNames": Dict[str, str],
    },
    total=False,
)


class ClientBatchGetItemRequestItemsTypeDef(
    _RequiredClientBatchGetItemRequestItemsTypeDef,
    _OptionalClientBatchGetItemRequestItemsTypeDef,
):
    """
    Type definition for `ClientBatchGetItem` `RequestItems`

    Represents a set of primary keys and, for each key, the attributes to retrieve from the table.

    For each primary key, you must provide *all* of the key attributes. For example, with a
    simple primary key, you only need to provide the partition key. For a composite primary key,
    you must provide *both* the partition key and the sort key.

    - **Keys** *(list) --* **[REQUIRED]**

      The primary key attribute values that define the items and the attributes associated with
      the items.

      - *(dict) --*

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data type,
            and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

            - **S** *(string) --*

              An attribute of type String. For example:

               ``"S": "Hello"``

            - **N** *(string) --*

              An attribute of type Number. For example:

               ``"N": "123.45"``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

            - **B** *(bytes) --*

              An attribute of type Binary. For example:

               ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

            - **SS** *(list) --*

              An attribute of type String Set. For example:

               ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

              - *(string) --*

            - **NS** *(list) --*

              An attribute of type Number Set. For example:

               ``"NS": ["42.2", "-19", "7.5", "3.14"]``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

              - *(string) --*

            - **BS** *(list) --*

              An attribute of type Binary Set. For example:

               ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

              - *(bytes) --*

            - **M** *(dict) --*

              An attribute of type Map. For example:

               ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the data
                  type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

            - **L** *(list) --*

              An attribute of type List. For example:

               ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data
                type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

            - **NULL** *(boolean) --*

              An attribute of type Null. For example:

               ``"NULL": true``

            - **BOOL** *(boolean) --*

              An attribute of type Boolean. For example:

               ``"BOOL": true``

    - **AttributesToGet** *(list) --*

      This is a legacy parameter. Use ``ProjectionExpression`` instead. For more information, see
      `Legacy Conditional Parameters
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html>`__
      in the *Amazon DynamoDB Developer Guide* .

      - *(string) --*

    - **ConsistentRead** *(boolean) --*

      The consistency of a read operation. If set to ``true`` , then a strongly consistent read
      is used; otherwise, an eventually consistent read is used.

    - **ProjectionExpression** *(string) --*

      A string that identifies one or more attributes to retrieve from the table. These
      attributes can include scalars, sets, or elements of a JSON document. The attributes in the
      ``ProjectionExpression`` must be separated by commas.

      If no attribute names are specified, then all attributes will be returned. If any of the
      requested attributes are not found, they will not appear in the result.

      For more information, see `Accessing Item Attributes
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html>`__
      in the *Amazon DynamoDB Developer Guide* .

    - **ExpressionAttributeNames** *(dict) --*

      One or more substitution tokens for attribute names in an expression. The following are
      some use cases for using ``ExpressionAttributeNames`` :

      * To access an attribute whose name conflicts with a DynamoDB reserved word.

      * To create a placeholder for repeating occurrences of an attribute name in an expression.

      * To prevent special characters in an attribute name from being misinterpreted in an
      expression.

      Use the **#** character in an expression to dereference an attribute name. For example,
      consider the following attribute name:

      * ``Percentile``

      The name of this attribute conflicts with a reserved word, so it cannot be used directly in
      an expression. (For the complete list of reserved words, see `Reserved Words
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html>`__ in
      the *Amazon DynamoDB Developer Guide* ). To work around this, you could specify the
      following for ``ExpressionAttributeNames`` :

      * ``{"#P":"Percentile"}``

      You could then use this substitution in an expression, as in this example:

      * ``#P = :val``

      .. note::

        Tokens that begin with the **:** character are *expression attribute values* , which are
        placeholders for the actual value at runtime.

      For more information on expression attribute names, see `Accessing Item Attributes
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html>`__
      in the *Amazon DynamoDB Developer Guide* .

      - *(string) --*

        - *(string) --*
    """


_ClientBatchGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientBatchGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientBatchGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef(
    _ClientBatchGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientBatchGetItemResponseConsumedCapacity` `GlobalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientBatchGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientBatchGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientBatchGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef(
    _ClientBatchGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientBatchGetItemResponseConsumedCapacity` `LocalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientBatchGetItemResponseConsumedCapacityTableTypeDef = TypedDict(
    "_ClientBatchGetItemResponseConsumedCapacityTableTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientBatchGetItemResponseConsumedCapacityTableTypeDef(
    _ClientBatchGetItemResponseConsumedCapacityTableTypeDef
):
    """
    Type definition for `ClientBatchGetItemResponseConsumedCapacity` `Table`

    The amount of throughput consumed on the table affected by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientBatchGetItemResponseConsumedCapacityTypeDef = TypedDict(
    "_ClientBatchGetItemResponseConsumedCapacityTypeDef",
    {
        "TableName": str,
        "CapacityUnits": float,
        "ReadCapacityUnits": float,
        "WriteCapacityUnits": float,
        "Table": ClientBatchGetItemResponseConsumedCapacityTableTypeDef,
        "LocalSecondaryIndexes": Dict[
            str, ClientBatchGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": Dict[
            str, ClientBatchGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientBatchGetItemResponseConsumedCapacityTypeDef(
    _ClientBatchGetItemResponseConsumedCapacityTypeDef
):
    """
    Type definition for `ClientBatchGetItemResponse` `ConsumedCapacity`

    The capacity units consumed by an operation. The data returned includes the total
    provisioned throughput consumed, along with statistics for the table and any indexes
    involved in the operation. ``ConsumedCapacity`` is only returned if the request asked for
    it. For more information, see `Provisioned Throughput
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **TableName** *(string) --*

      The name of the table that was affected by the operation.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed by the operation.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed by the operation.

    - **Table** *(dict) --*

      The amount of throughput consumed on the table affected by the operation.

      - **ReadCapacityUnits** *(float) --*

        The total number of read capacity units consumed on a table or an index.

      - **WriteCapacityUnits** *(float) --*

        The total number of write capacity units consumed on a table or an index.

      - **CapacityUnits** *(float) --*

        The total number of capacity units consumed on a table or an index.

    - **LocalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each local index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.

    - **GlobalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each global index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.
    """


_ClientBatchGetItemResponseResponsesTypeDef = TypedDict(
    "_ClientBatchGetItemResponseResponsesTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchGetItemResponseResponsesTypeDef(
    _ClientBatchGetItemResponseResponsesTypeDef
):
    """
    Type definition for `ClientBatchGetItemResponse` `Responses`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type,
    and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data
        type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientBatchGetItemResponseUnprocessedKeysKeysTypeDef = TypedDict(
    "_ClientBatchGetItemResponseUnprocessedKeysKeysTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchGetItemResponseUnprocessedKeysKeysTypeDef(
    _ClientBatchGetItemResponseUnprocessedKeysKeysTypeDef
):
    """
    Type definition for `ClientBatchGetItemResponseUnprocessedKeys` `Keys`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data
    type, and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the
          data type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data
        type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientBatchGetItemResponseUnprocessedKeysTypeDef = TypedDict(
    "_ClientBatchGetItemResponseUnprocessedKeysTypeDef",
    {
        "Keys": List[Dict[str, ClientBatchGetItemResponseUnprocessedKeysKeysTypeDef]],
        "AttributesToGet": List[str],
        "ConsistentRead": bool,
        "ProjectionExpression": str,
        "ExpressionAttributeNames": Dict[str, str],
    },
    total=False,
)


class ClientBatchGetItemResponseUnprocessedKeysTypeDef(
    _ClientBatchGetItemResponseUnprocessedKeysTypeDef
):
    """
    Type definition for `ClientBatchGetItemResponse` `UnprocessedKeys`

    Represents a set of primary keys and, for each key, the attributes to retrieve from the
    table.

    For each primary key, you must provide *all* of the key attributes. For example, with a
    simple primary key, you only need to provide the partition key. For a composite primary
    key, you must provide *both* the partition key and the sort key.

    - **Keys** *(list) --*

      The primary key attribute values that define the items and the attributes associated
      with the items.

      - *(dict) --*

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data
            type, and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

            - **S** *(string) --*

              An attribute of type String. For example:

               ``"S": "Hello"``

            - **N** *(string) --*

              An attribute of type Number. For example:

               ``"N": "123.45"``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

            - **B** *(bytes) --*

              An attribute of type Binary. For example:

               ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

            - **SS** *(list) --*

              An attribute of type String Set. For example:

               ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

              - *(string) --*

            - **NS** *(list) --*

              An attribute of type Number Set. For example:

               ``"NS": ["42.2", "-19", "7.5", "3.14"]``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

              - *(string) --*

            - **BS** *(list) --*

              An attribute of type Binary Set. For example:

               ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

              - *(bytes) --*

            - **M** *(dict) --*

              An attribute of type Map. For example:

               ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the
                  data type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

            - **L** *(list) --*

              An attribute of type List. For example:

               ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data
                type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

            - **NULL** *(boolean) --*

              An attribute of type Null. For example:

               ``"NULL": true``

            - **BOOL** *(boolean) --*

              An attribute of type Boolean. For example:

               ``"BOOL": true``

    - **AttributesToGet** *(list) --*

      This is a legacy parameter. Use ``ProjectionExpression`` instead. For more information,
      see `Legacy Conditional Parameters
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html>`__
      in the *Amazon DynamoDB Developer Guide* .

      - *(string) --*

    - **ConsistentRead** *(boolean) --*

      The consistency of a read operation. If set to ``true`` , then a strongly consistent
      read is used; otherwise, an eventually consistent read is used.

    - **ProjectionExpression** *(string) --*

      A string that identifies one or more attributes to retrieve from the table. These
      attributes can include scalars, sets, or elements of a JSON document. The attributes in
      the ``ProjectionExpression`` must be separated by commas.

      If no attribute names are specified, then all attributes will be returned. If any of
      the requested attributes are not found, they will not appear in the result.

      For more information, see `Accessing Item Attributes
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html>`__
      in the *Amazon DynamoDB Developer Guide* .

    - **ExpressionAttributeNames** *(dict) --*

      One or more substitution tokens for attribute names in an expression. The following are
      some use cases for using ``ExpressionAttributeNames`` :

      * To access an attribute whose name conflicts with a DynamoDB reserved word.

      * To create a placeholder for repeating occurrences of an attribute name in an
      expression.

      * To prevent special characters in an attribute name from being misinterpreted in an
      expression.

      Use the **#** character in an expression to dereference an attribute name. For example,
      consider the following attribute name:

      * ``Percentile``

      The name of this attribute conflicts with a reserved word, so it cannot be used
      directly in an expression. (For the complete list of reserved words, see `Reserved
      Words
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html>`__
      in the *Amazon DynamoDB Developer Guide* ). To work around this, you could specify the
      following for ``ExpressionAttributeNames`` :

      * ``{"#P":"Percentile"}``

      You could then use this substitution in an expression, as in this example:

      * ``#P = :val``

      .. note::

        Tokens that begin with the **:** character are *expression attribute values* , which
        are placeholders for the actual value at runtime.

      For more information on expression attribute names, see `Accessing Item Attributes
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html>`__
      in the *Amazon DynamoDB Developer Guide* .

      - *(string) --*

        - *(string) --*
    """


_ClientBatchGetItemResponseTypeDef = TypedDict(
    "_ClientBatchGetItemResponseTypeDef",
    {
        "Responses": Dict[
            str, List[Dict[str, ClientBatchGetItemResponseResponsesTypeDef]]
        ],
        "UnprocessedKeys": Dict[str, ClientBatchGetItemResponseUnprocessedKeysTypeDef],
        "ConsumedCapacity": List[ClientBatchGetItemResponseConsumedCapacityTypeDef],
    },
    total=False,
)


class ClientBatchGetItemResponseTypeDef(_ClientBatchGetItemResponseTypeDef):
    """
    Type definition for `ClientBatchGetItem` `Response`

    Represents the output of a ``BatchGetItem`` operation.

    - **Responses** *(dict) --*

      A map of table name to a list of items. Each object in ``Responses`` consists of a table
      name, along with a map of attribute data consisting of the data type and attribute value.

      - *(string) --*

        - *(list) --*

          - *(dict) --*

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data type,
                and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

                - **S** *(string) --*

                  An attribute of type String. For example:

                   ``"S": "Hello"``

                - **N** *(string) --*

                  An attribute of type Number. For example:

                   ``"N": "123.45"``

                  Numbers are sent across the network to DynamoDB as strings, to maximize
                  compatibility across languages and libraries. However, DynamoDB treats them as
                  number type attributes for mathematical operations.

                - **B** *(bytes) --*

                  An attribute of type Binary. For example:

                   ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

                - **SS** *(list) --*

                  An attribute of type String Set. For example:

                   ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

                  - *(string) --*

                - **NS** *(list) --*

                  An attribute of type Number Set. For example:

                   ``"NS": ["42.2", "-19", "7.5", "3.14"]``

                  Numbers are sent across the network to DynamoDB as strings, to maximize
                  compatibility across languages and libraries. However, DynamoDB treats them as
                  number type attributes for mathematical operations.

                  - *(string) --*

                - **BS** *(list) --*

                  An attribute of type Binary Set. For example:

                   ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

                  - *(bytes) --*

                - **M** *(dict) --*

                  An attribute of type Map. For example:

                   ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

                  - *(string) --*

                    - *(dict) --*

                      Represents the data for an attribute.

                      Each attribute value is described as a name-value pair. The name is the data
                      type, and the value is the data itself.

                      For more information, see `Data Types
                      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                      in the *Amazon DynamoDB Developer Guide* .

                - **L** *(list) --*

                  An attribute of type List. For example:

                   ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

                  - *(dict) --*

                    Represents the data for an attribute.

                    Each attribute value is described as a name-value pair. The name is the data
                    type, and the value is the data itself.

                    For more information, see `Data Types
                    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                    in the *Amazon DynamoDB Developer Guide* .

                - **NULL** *(boolean) --*

                  An attribute of type Null. For example:

                   ``"NULL": true``

                - **BOOL** *(boolean) --*

                  An attribute of type Boolean. For example:

                   ``"BOOL": true``

    - **UnprocessedKeys** *(dict) --*

      A map of tables and their respective keys that were not processed with the current response.
      The ``UnprocessedKeys`` value is in the same form as ``RequestItems`` , so the value can be
      provided directly to a subsequent ``BatchGetItem`` operation. For more information, see
      ``RequestItems`` in the Request Parameters section.

      Each element consists of:

      * ``Keys`` - An array of primary key attribute values that define specific items in the table.

      * ``ProjectionExpression`` - One or more attributes to be retrieved from the table or index.
      By default, all attributes are returned. If a requested attribute is not found, it does not
      appear in the result.

      * ``ConsistentRead`` - The consistency of a read operation. If set to ``true`` , then a
      strongly consistent read is used; otherwise, an eventually consistent read is used.

      If there are no unprocessed keys remaining, the response contains an empty
      ``UnprocessedKeys`` map.

      - *(string) --*

        - *(dict) --*

          Represents a set of primary keys and, for each key, the attributes to retrieve from the
          table.

          For each primary key, you must provide *all* of the key attributes. For example, with a
          simple primary key, you only need to provide the partition key. For a composite primary
          key, you must provide *both* the partition key and the sort key.

          - **Keys** *(list) --*

            The primary key attribute values that define the items and the attributes associated
            with the items.

            - *(dict) --*

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the data
                  type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

                  - **S** *(string) --*

                    An attribute of type String. For example:

                     ``"S": "Hello"``

                  - **N** *(string) --*

                    An attribute of type Number. For example:

                     ``"N": "123.45"``

                    Numbers are sent across the network to DynamoDB as strings, to maximize
                    compatibility across languages and libraries. However, DynamoDB treats them as
                    number type attributes for mathematical operations.

                  - **B** *(bytes) --*

                    An attribute of type Binary. For example:

                     ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

                  - **SS** *(list) --*

                    An attribute of type String Set. For example:

                     ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

                    - *(string) --*

                  - **NS** *(list) --*

                    An attribute of type Number Set. For example:

                     ``"NS": ["42.2", "-19", "7.5", "3.14"]``

                    Numbers are sent across the network to DynamoDB as strings, to maximize
                    compatibility across languages and libraries. However, DynamoDB treats them as
                    number type attributes for mathematical operations.

                    - *(string) --*

                  - **BS** *(list) --*

                    An attribute of type Binary Set. For example:

                     ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

                    - *(bytes) --*

                  - **M** *(dict) --*

                    An attribute of type Map. For example:

                     ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

                    - *(string) --*

                      - *(dict) --*

                        Represents the data for an attribute.

                        Each attribute value is described as a name-value pair. The name is the
                        data type, and the value is the data itself.

                        For more information, see `Data Types
                        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                        in the *Amazon DynamoDB Developer Guide* .

                  - **L** *(list) --*

                    An attribute of type List. For example:

                     ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

                    - *(dict) --*

                      Represents the data for an attribute.

                      Each attribute value is described as a name-value pair. The name is the data
                      type, and the value is the data itself.

                      For more information, see `Data Types
                      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                      in the *Amazon DynamoDB Developer Guide* .

                  - **NULL** *(boolean) --*

                    An attribute of type Null. For example:

                     ``"NULL": true``

                  - **BOOL** *(boolean) --*

                    An attribute of type Boolean. For example:

                     ``"BOOL": true``

          - **AttributesToGet** *(list) --*

            This is a legacy parameter. Use ``ProjectionExpression`` instead. For more information,
            see `Legacy Conditional Parameters
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html>`__
            in the *Amazon DynamoDB Developer Guide* .

            - *(string) --*

          - **ConsistentRead** *(boolean) --*

            The consistency of a read operation. If set to ``true`` , then a strongly consistent
            read is used; otherwise, an eventually consistent read is used.

          - **ProjectionExpression** *(string) --*

            A string that identifies one or more attributes to retrieve from the table. These
            attributes can include scalars, sets, or elements of a JSON document. The attributes in
            the ``ProjectionExpression`` must be separated by commas.

            If no attribute names are specified, then all attributes will be returned. If any of
            the requested attributes are not found, they will not appear in the result.

            For more information, see `Accessing Item Attributes
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html>`__
            in the *Amazon DynamoDB Developer Guide* .

          - **ExpressionAttributeNames** *(dict) --*

            One or more substitution tokens for attribute names in an expression. The following are
            some use cases for using ``ExpressionAttributeNames`` :

            * To access an attribute whose name conflicts with a DynamoDB reserved word.

            * To create a placeholder for repeating occurrences of an attribute name in an
            expression.

            * To prevent special characters in an attribute name from being misinterpreted in an
            expression.

            Use the **#** character in an expression to dereference an attribute name. For example,
            consider the following attribute name:

            * ``Percentile``

            The name of this attribute conflicts with a reserved word, so it cannot be used
            directly in an expression. (For the complete list of reserved words, see `Reserved
            Words
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html>`__
            in the *Amazon DynamoDB Developer Guide* ). To work around this, you could specify the
            following for ``ExpressionAttributeNames`` :

            * ``{"#P":"Percentile"}``

            You could then use this substitution in an expression, as in this example:

            * ``#P = :val``

            .. note::

              Tokens that begin with the **:** character are *expression attribute values* , which
              are placeholders for the actual value at runtime.

            For more information on expression attribute names, see `Accessing Item Attributes
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html>`__
            in the *Amazon DynamoDB Developer Guide* .

            - *(string) --*

              - *(string) --*

    - **ConsumedCapacity** *(list) --*

      The read capacity units consumed by the entire ``BatchGetItem`` operation.

      Each element consists of:

      * ``TableName`` - The table that consumed the provisioned throughput.

      * ``CapacityUnits`` - The total number of capacity units consumed.

      - *(dict) --*

        The capacity units consumed by an operation. The data returned includes the total
        provisioned throughput consumed, along with statistics for the table and any indexes
        involved in the operation. ``ConsumedCapacity`` is only returned if the request asked for
        it. For more information, see `Provisioned Throughput
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
        in the *Amazon DynamoDB Developer Guide* .

        - **TableName** *(string) --*

          The name of the table that was affected by the operation.

        - **CapacityUnits** *(float) --*

          The total number of capacity units consumed by the operation.

        - **ReadCapacityUnits** *(float) --*

          The total number of read capacity units consumed by the operation.

        - **WriteCapacityUnits** *(float) --*

          The total number of write capacity units consumed by the operation.

        - **Table** *(dict) --*

          The amount of throughput consumed on the table affected by the operation.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.

        - **LocalSecondaryIndexes** *(dict) --*

          The amount of throughput consumed on each local index affected by the operation.

          - *(string) --*

            - *(dict) --*

              Represents the amount of provisioned throughput capacity consumed on a table or an
              index.

              - **ReadCapacityUnits** *(float) --*

                The total number of read capacity units consumed on a table or an index.

              - **WriteCapacityUnits** *(float) --*

                The total number of write capacity units consumed on a table or an index.

              - **CapacityUnits** *(float) --*

                The total number of capacity units consumed on a table or an index.

        - **GlobalSecondaryIndexes** *(dict) --*

          The amount of throughput consumed on each global index affected by the operation.

          - *(string) --*

            - *(dict) --*

              Represents the amount of provisioned throughput capacity consumed on a table or an
              index.

              - **ReadCapacityUnits** *(float) --*

                The total number of read capacity units consumed on a table or an index.

              - **WriteCapacityUnits** *(float) --*

                The total number of write capacity units consumed on a table or an index.

              - **CapacityUnits** *(float) --*

                The total number of capacity units consumed on a table or an index.
    """


_ClientBatchWriteItemRequestItemsDeleteRequestKeyTypeDef = TypedDict(
    "_ClientBatchWriteItemRequestItemsDeleteRequestKeyTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchWriteItemRequestItemsDeleteRequestKeyTypeDef(
    _ClientBatchWriteItemRequestItemsDeleteRequestKeyTypeDef
):
    """
    Type definition for `ClientBatchWriteItemRequestItemsDeleteRequest` `Key`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type,
    and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data
        type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientBatchWriteItemRequestItemsDeleteRequestTypeDef = TypedDict(
    "_ClientBatchWriteItemRequestItemsDeleteRequestTypeDef",
    {"Key": Dict[str, ClientBatchWriteItemRequestItemsDeleteRequestKeyTypeDef]},
)


class ClientBatchWriteItemRequestItemsDeleteRequestTypeDef(
    _ClientBatchWriteItemRequestItemsDeleteRequestTypeDef
):
    """
    Type definition for `ClientBatchWriteItemRequestItems` `DeleteRequest`

    A request to perform a ``DeleteItem`` operation.

    - **Key** *(dict) --* **[REQUIRED]**

      A map of attribute name to attribute values, representing the primary key of the item
      to delete. All of the table's primary key attributes must be specified, and their data
      types must match those of the table's key schema.

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them as
            number type attributes for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them as
            number type attributes for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data
                type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the data
              type, and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``
    """


_ClientBatchWriteItemRequestItemsPutRequestItemTypeDef = TypedDict(
    "_ClientBatchWriteItemRequestItemsPutRequestItemTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchWriteItemRequestItemsPutRequestItemTypeDef(
    _ClientBatchWriteItemRequestItemsPutRequestItemTypeDef
):
    """
    Type definition for `ClientBatchWriteItemRequestItemsPutRequest` `Item`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type,
    and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data
        type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientBatchWriteItemRequestItemsPutRequestTypeDef = TypedDict(
    "_ClientBatchWriteItemRequestItemsPutRequestTypeDef",
    {"Item": Dict[str, ClientBatchWriteItemRequestItemsPutRequestItemTypeDef]},
)


class ClientBatchWriteItemRequestItemsPutRequestTypeDef(
    _ClientBatchWriteItemRequestItemsPutRequestTypeDef
):
    """
    Type definition for `ClientBatchWriteItemRequestItems` `PutRequest`

    A request to perform a ``PutItem`` operation.

    - **Item** *(dict) --* **[REQUIRED]**

      A map of attribute name to attribute values, representing the primary key of an item to
      be processed by ``PutItem`` . All of the table's primary key attributes must be
      specified, and their data types must match those of the table's key schema. If any
      attributes are present in the item that are part of an index key schema for the table,
      their types must match the index key schema.

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them as
            number type attributes for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them as
            number type attributes for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data
                type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the data
              type, and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``
    """


_ClientBatchWriteItemRequestItemsTypeDef = TypedDict(
    "_ClientBatchWriteItemRequestItemsTypeDef",
    {
        "PutRequest": ClientBatchWriteItemRequestItemsPutRequestTypeDef,
        "DeleteRequest": ClientBatchWriteItemRequestItemsDeleteRequestTypeDef,
    },
    total=False,
)


class ClientBatchWriteItemRequestItemsTypeDef(_ClientBatchWriteItemRequestItemsTypeDef):
    """
    Type definition for `ClientBatchWriteItem` `RequestItems`

    Represents an operation to perform - either ``DeleteItem`` or ``PutItem`` . You can only
    request one of these operations, not both, in a single ``WriteRequest`` . If you do need to
    perform both of these operations, you need to provide two separate ``WriteRequest`` objects.

    - **PutRequest** *(dict) --*

      A request to perform a ``PutItem`` operation.

      - **Item** *(dict) --* **[REQUIRED]**

        A map of attribute name to attribute values, representing the primary key of an item to
        be processed by ``PutItem`` . All of the table's primary key attributes must be
        specified, and their data types must match those of the table's key schema. If any
        attributes are present in the item that are part of an index key schema for the table,
        their types must match the index key schema.

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data type,
            and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

            - **S** *(string) --*

              An attribute of type String. For example:

               ``"S": "Hello"``

            - **N** *(string) --*

              An attribute of type Number. For example:

               ``"N": "123.45"``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

            - **B** *(bytes) --*

              An attribute of type Binary. For example:

               ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

            - **SS** *(list) --*

              An attribute of type String Set. For example:

               ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

              - *(string) --*

            - **NS** *(list) --*

              An attribute of type Number Set. For example:

               ``"NS": ["42.2", "-19", "7.5", "3.14"]``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

              - *(string) --*

            - **BS** *(list) --*

              An attribute of type Binary Set. For example:

               ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

              - *(bytes) --*

            - **M** *(dict) --*

              An attribute of type Map. For example:

               ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the data
                  type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

            - **L** *(list) --*

              An attribute of type List. For example:

               ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data
                type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

            - **NULL** *(boolean) --*

              An attribute of type Null. For example:

               ``"NULL": true``

            - **BOOL** *(boolean) --*

              An attribute of type Boolean. For example:

               ``"BOOL": true``

    - **DeleteRequest** *(dict) --*

      A request to perform a ``DeleteItem`` operation.

      - **Key** *(dict) --* **[REQUIRED]**

        A map of attribute name to attribute values, representing the primary key of the item
        to delete. All of the table's primary key attributes must be specified, and their data
        types must match those of the table's key schema.

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data type,
            and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

            - **S** *(string) --*

              An attribute of type String. For example:

               ``"S": "Hello"``

            - **N** *(string) --*

              An attribute of type Number. For example:

               ``"N": "123.45"``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

            - **B** *(bytes) --*

              An attribute of type Binary. For example:

               ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

            - **SS** *(list) --*

              An attribute of type String Set. For example:

               ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

              - *(string) --*

            - **NS** *(list) --*

              An attribute of type Number Set. For example:

               ``"NS": ["42.2", "-19", "7.5", "3.14"]``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them as
              number type attributes for mathematical operations.

              - *(string) --*

            - **BS** *(list) --*

              An attribute of type Binary Set. For example:

               ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

              - *(bytes) --*

            - **M** *(dict) --*

              An attribute of type Map. For example:

               ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the data
                  type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

            - **L** *(list) --*

              An attribute of type List. For example:

               ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data
                type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

            - **NULL** *(boolean) --*

              An attribute of type Null. For example:

               ``"NULL": true``

            - **BOOL** *(boolean) --*

              An attribute of type Boolean. For example:

               ``"BOOL": true``
    """


_ClientBatchWriteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientBatchWriteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef(
    _ClientBatchWriteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseConsumedCapacity` `GlobalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientBatchWriteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientBatchWriteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef(
    _ClientBatchWriteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseConsumedCapacity` `LocalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientBatchWriteItemResponseConsumedCapacityTableTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseConsumedCapacityTableTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientBatchWriteItemResponseConsumedCapacityTableTypeDef(
    _ClientBatchWriteItemResponseConsumedCapacityTableTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseConsumedCapacity` `Table`

    The amount of throughput consumed on the table affected by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientBatchWriteItemResponseConsumedCapacityTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseConsumedCapacityTypeDef",
    {
        "TableName": str,
        "CapacityUnits": float,
        "ReadCapacityUnits": float,
        "WriteCapacityUnits": float,
        "Table": ClientBatchWriteItemResponseConsumedCapacityTableTypeDef,
        "LocalSecondaryIndexes": Dict[
            str,
            ClientBatchWriteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef,
        ],
        "GlobalSecondaryIndexes": Dict[
            str,
            ClientBatchWriteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef,
        ],
    },
    total=False,
)


class ClientBatchWriteItemResponseConsumedCapacityTypeDef(
    _ClientBatchWriteItemResponseConsumedCapacityTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponse` `ConsumedCapacity`

    The capacity units consumed by an operation. The data returned includes the total
    provisioned throughput consumed, along with statistics for the table and any indexes
    involved in the operation. ``ConsumedCapacity`` is only returned if the request asked for
    it. For more information, see `Provisioned Throughput
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **TableName** *(string) --*

      The name of the table that was affected by the operation.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed by the operation.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed by the operation.

    - **Table** *(dict) --*

      The amount of throughput consumed on the table affected by the operation.

      - **ReadCapacityUnits** *(float) --*

        The total number of read capacity units consumed on a table or an index.

      - **WriteCapacityUnits** *(float) --*

        The total number of write capacity units consumed on a table or an index.

      - **CapacityUnits** *(float) --*

        The total number of capacity units consumed on a table or an index.

    - **LocalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each local index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.

    - **GlobalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each global index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.
    """


_ClientBatchWriteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchWriteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef(
    _ClientBatchWriteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseItemCollectionMetrics` `ItemCollectionKey`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data
    type, and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them as
      number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the
          data type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data
        type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientBatchWriteItemResponseItemCollectionMetricsTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseItemCollectionMetricsTypeDef",
    {
        "ItemCollectionKey": Dict[
            str,
            ClientBatchWriteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef,
        ],
        "SizeEstimateRangeGB": List[float],
    },
    total=False,
)


class ClientBatchWriteItemResponseItemCollectionMetricsTypeDef(
    _ClientBatchWriteItemResponseItemCollectionMetricsTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponse` `ItemCollectionMetrics`

    Information about item collections, if any, that were affected by the operation.
    ``ItemCollectionMetrics`` is only returned if the request asked for it. If the table
    does not have any local secondary indexes, this information is not returned in the
    response.

    - **ItemCollectionKey** *(dict) --*

      The partition key value of the item collection. This value is the same as the
      partition key value of the item.

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them as
            number type attributes for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them as
            number type attributes for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the
                data type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the data
              type, and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``

    - **SizeEstimateRangeGB** *(list) --*

      An estimate of item collection size, in gigabytes. This value is a two-element array
      containing a lower bound and an upper bound for the estimate. The estimate includes
      the size of all the items in the table, plus the size of all attributes projected
      into all of the local secondary indexes on that table. Use this estimate to measure
      whether a local secondary index is approaching its size limit.

      The estimate is subject to change over time; therefore, do not rely on the precision
      or accuracy of the estimate.

      - *(float) --*
    """


_ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestKeyTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestKeyTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestKeyTypeDef(
    _ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestKeyTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseUnprocessedItemsDeleteRequest` `Key`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data
    type, and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them
      as number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them
      as number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the
          data type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the
        data type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestTypeDef",
    {
        "Key": Dict[
            str, ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestKeyTypeDef
        ]
    },
    total=False,
)


class ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestTypeDef(
    _ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseUnprocessedItems` `DeleteRequest`

    A request to perform a ``DeleteItem`` operation.

    - **Key** *(dict) --*

      A map of attribute name to attribute values, representing the primary key of the
      item to delete. All of the table's primary key attributes must be specified, and
      their data types must match those of the table's key schema.

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them
            as number type attributes for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them
            as number type attributes for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the
                data type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the
              data type, and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``
    """


_ClientBatchWriteItemResponseUnprocessedItemsPutRequestItemTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseUnprocessedItemsPutRequestItemTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientBatchWriteItemResponseUnprocessedItemsPutRequestItemTypeDef(
    _ClientBatchWriteItemResponseUnprocessedItemsPutRequestItemTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseUnprocessedItemsPutRequest` `Item`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data
    type, and the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them
      as number type attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize
      compatibility across languages and libraries. However, DynamoDB treats them
      as number type attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the
          data type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the
        data type, and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientBatchWriteItemResponseUnprocessedItemsPutRequestTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseUnprocessedItemsPutRequestTypeDef",
    {
        "Item": Dict[
            str, ClientBatchWriteItemResponseUnprocessedItemsPutRequestItemTypeDef
        ]
    },
    total=False,
)


class ClientBatchWriteItemResponseUnprocessedItemsPutRequestTypeDef(
    _ClientBatchWriteItemResponseUnprocessedItemsPutRequestTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponseUnprocessedItems` `PutRequest`

    A request to perform a ``PutItem`` operation.

    - **Item** *(dict) --*

      A map of attribute name to attribute values, representing the primary key of an
      item to be processed by ``PutItem`` . All of the table's primary key attributes
      must be specified, and their data types must match those of the table's key schema.
      If any attributes are present in the item that are part of an index key schema for
      the table, their types must match the index key schema.

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them
            as number type attributes for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize
            compatibility across languages and libraries. However, DynamoDB treats them
            as number type attributes for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the
                data type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the
              data type, and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``
    """


_ClientBatchWriteItemResponseUnprocessedItemsTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseUnprocessedItemsTypeDef",
    {
        "PutRequest": ClientBatchWriteItemResponseUnprocessedItemsPutRequestTypeDef,
        "DeleteRequest": ClientBatchWriteItemResponseUnprocessedItemsDeleteRequestTypeDef,
    },
    total=False,
)


class ClientBatchWriteItemResponseUnprocessedItemsTypeDef(
    _ClientBatchWriteItemResponseUnprocessedItemsTypeDef
):
    """
    Type definition for `ClientBatchWriteItemResponse` `UnprocessedItems`

    Represents an operation to perform - either ``DeleteItem`` or ``PutItem`` . You can
    only request one of these operations, not both, in a single ``WriteRequest`` . If you
    do need to perform both of these operations, you need to provide two separate
    ``WriteRequest`` objects.

    - **PutRequest** *(dict) --*

      A request to perform a ``PutItem`` operation.

      - **Item** *(dict) --*

        A map of attribute name to attribute values, representing the primary key of an
        item to be processed by ``PutItem`` . All of the table's primary key attributes
        must be specified, and their data types must match those of the table's key schema.
        If any attributes are present in the item that are part of an index key schema for
        the table, their types must match the index key schema.

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data
            type, and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

            - **S** *(string) --*

              An attribute of type String. For example:

               ``"S": "Hello"``

            - **N** *(string) --*

              An attribute of type Number. For example:

               ``"N": "123.45"``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them
              as number type attributes for mathematical operations.

            - **B** *(bytes) --*

              An attribute of type Binary. For example:

               ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

            - **SS** *(list) --*

              An attribute of type String Set. For example:

               ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

              - *(string) --*

            - **NS** *(list) --*

              An attribute of type Number Set. For example:

               ``"NS": ["42.2", "-19", "7.5", "3.14"]``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them
              as number type attributes for mathematical operations.

              - *(string) --*

            - **BS** *(list) --*

              An attribute of type Binary Set. For example:

               ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

              - *(bytes) --*

            - **M** *(dict) --*

              An attribute of type Map. For example:

               ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the
                  data type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

            - **L** *(list) --*

              An attribute of type List. For example:

               ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the
                data type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

            - **NULL** *(boolean) --*

              An attribute of type Null. For example:

               ``"NULL": true``

            - **BOOL** *(boolean) --*

              An attribute of type Boolean. For example:

               ``"BOOL": true``

    - **DeleteRequest** *(dict) --*

      A request to perform a ``DeleteItem`` operation.

      - **Key** *(dict) --*

        A map of attribute name to attribute values, representing the primary key of the
        item to delete. All of the table's primary key attributes must be specified, and
        their data types must match those of the table's key schema.

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data
            type, and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

            - **S** *(string) --*

              An attribute of type String. For example:

               ``"S": "Hello"``

            - **N** *(string) --*

              An attribute of type Number. For example:

               ``"N": "123.45"``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them
              as number type attributes for mathematical operations.

            - **B** *(bytes) --*

              An attribute of type Binary. For example:

               ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

            - **SS** *(list) --*

              An attribute of type String Set. For example:

               ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

              - *(string) --*

            - **NS** *(list) --*

              An attribute of type Number Set. For example:

               ``"NS": ["42.2", "-19", "7.5", "3.14"]``

              Numbers are sent across the network to DynamoDB as strings, to maximize
              compatibility across languages and libraries. However, DynamoDB treats them
              as number type attributes for mathematical operations.

              - *(string) --*

            - **BS** *(list) --*

              An attribute of type Binary Set. For example:

               ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

              - *(bytes) --*

            - **M** *(dict) --*

              An attribute of type Map. For example:

               ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the
                  data type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

            - **L** *(list) --*

              An attribute of type List. For example:

               ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the
                data type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

            - **NULL** *(boolean) --*

              An attribute of type Null. For example:

               ``"NULL": true``

            - **BOOL** *(boolean) --*

              An attribute of type Boolean. For example:

               ``"BOOL": true``
    """


_ClientBatchWriteItemResponseTypeDef = TypedDict(
    "_ClientBatchWriteItemResponseTypeDef",
    {
        "UnprocessedItems": Dict[
            str, List[ClientBatchWriteItemResponseUnprocessedItemsTypeDef]
        ],
        "ItemCollectionMetrics": Dict[
            str, List[ClientBatchWriteItemResponseItemCollectionMetricsTypeDef]
        ],
        "ConsumedCapacity": List[ClientBatchWriteItemResponseConsumedCapacityTypeDef],
    },
    total=False,
)


class ClientBatchWriteItemResponseTypeDef(_ClientBatchWriteItemResponseTypeDef):
    """
    Type definition for `ClientBatchWriteItem` `Response`

    Represents the output of a ``BatchWriteItem`` operation.

    - **UnprocessedItems** *(dict) --*

      A map of tables and requests against those tables that were not processed. The
      ``UnprocessedItems`` value is in the same form as ``RequestItems`` , so you can provide this
      value directly to a subsequent ``BatchGetItem`` operation. For more information, see
      ``RequestItems`` in the Request Parameters section.

      Each ``UnprocessedItems`` entry consists of a table name and, for that table, a list of
      operations to perform (``DeleteRequest`` or ``PutRequest`` ).

      * ``DeleteRequest`` - Perform a ``DeleteItem`` operation on the specified item. The item to
      be deleted is identified by a ``Key`` subelement:

        * ``Key`` - A map of primary key attribute values that uniquely identify the item. Each
        entry in this map consists of an attribute name and an attribute value.

      * ``PutRequest`` - Perform a ``PutItem`` operation on the specified item. The item to be put
      is identified by an ``Item`` subelement:

        * ``Item`` - A map of attributes and their values. Each entry in this map consists of an
        attribute name and an attribute value. Attribute values must not be null; string and binary
        type attributes must have lengths greater than zero; and set type attributes must not be
        empty. Requests that contain empty values will be rejected with a ``ValidationException``
        exception. If you specify any attributes that are part of an index key, then the data types
        for those attributes must match those of the schema in the table's attribute definition.

      If there are no unprocessed items remaining, the response contains an empty
      ``UnprocessedItems`` map.

      - *(string) --*

        - *(list) --*

          - *(dict) --*

            Represents an operation to perform - either ``DeleteItem`` or ``PutItem`` . You can
            only request one of these operations, not both, in a single ``WriteRequest`` . If you
            do need to perform both of these operations, you need to provide two separate
            ``WriteRequest`` objects.

            - **PutRequest** *(dict) --*

              A request to perform a ``PutItem`` operation.

              - **Item** *(dict) --*

                A map of attribute name to attribute values, representing the primary key of an
                item to be processed by ``PutItem`` . All of the table's primary key attributes
                must be specified, and their data types must match those of the table's key schema.
                If any attributes are present in the item that are part of an index key schema for
                the table, their types must match the index key schema.

                - *(string) --*

                  - *(dict) --*

                    Represents the data for an attribute.

                    Each attribute value is described as a name-value pair. The name is the data
                    type, and the value is the data itself.

                    For more information, see `Data Types
                    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                    in the *Amazon DynamoDB Developer Guide* .

                    - **S** *(string) --*

                      An attribute of type String. For example:

                       ``"S": "Hello"``

                    - **N** *(string) --*

                      An attribute of type Number. For example:

                       ``"N": "123.45"``

                      Numbers are sent across the network to DynamoDB as strings, to maximize
                      compatibility across languages and libraries. However, DynamoDB treats them
                      as number type attributes for mathematical operations.

                    - **B** *(bytes) --*

                      An attribute of type Binary. For example:

                       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

                    - **SS** *(list) --*

                      An attribute of type String Set. For example:

                       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

                      - *(string) --*

                    - **NS** *(list) --*

                      An attribute of type Number Set. For example:

                       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

                      Numbers are sent across the network to DynamoDB as strings, to maximize
                      compatibility across languages and libraries. However, DynamoDB treats them
                      as number type attributes for mathematical operations.

                      - *(string) --*

                    - **BS** *(list) --*

                      An attribute of type Binary Set. For example:

                       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

                      - *(bytes) --*

                    - **M** *(dict) --*

                      An attribute of type Map. For example:

                       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

                      - *(string) --*

                        - *(dict) --*

                          Represents the data for an attribute.

                          Each attribute value is described as a name-value pair. The name is the
                          data type, and the value is the data itself.

                          For more information, see `Data Types
                          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                          in the *Amazon DynamoDB Developer Guide* .

                    - **L** *(list) --*

                      An attribute of type List. For example:

                       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

                      - *(dict) --*

                        Represents the data for an attribute.

                        Each attribute value is described as a name-value pair. The name is the
                        data type, and the value is the data itself.

                        For more information, see `Data Types
                        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                        in the *Amazon DynamoDB Developer Guide* .

                    - **NULL** *(boolean) --*

                      An attribute of type Null. For example:

                       ``"NULL": true``

                    - **BOOL** *(boolean) --*

                      An attribute of type Boolean. For example:

                       ``"BOOL": true``

            - **DeleteRequest** *(dict) --*

              A request to perform a ``DeleteItem`` operation.

              - **Key** *(dict) --*

                A map of attribute name to attribute values, representing the primary key of the
                item to delete. All of the table's primary key attributes must be specified, and
                their data types must match those of the table's key schema.

                - *(string) --*

                  - *(dict) --*

                    Represents the data for an attribute.

                    Each attribute value is described as a name-value pair. The name is the data
                    type, and the value is the data itself.

                    For more information, see `Data Types
                    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                    in the *Amazon DynamoDB Developer Guide* .

                    - **S** *(string) --*

                      An attribute of type String. For example:

                       ``"S": "Hello"``

                    - **N** *(string) --*

                      An attribute of type Number. For example:

                       ``"N": "123.45"``

                      Numbers are sent across the network to DynamoDB as strings, to maximize
                      compatibility across languages and libraries. However, DynamoDB treats them
                      as number type attributes for mathematical operations.

                    - **B** *(bytes) --*

                      An attribute of type Binary. For example:

                       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

                    - **SS** *(list) --*

                      An attribute of type String Set. For example:

                       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

                      - *(string) --*

                    - **NS** *(list) --*

                      An attribute of type Number Set. For example:

                       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

                      Numbers are sent across the network to DynamoDB as strings, to maximize
                      compatibility across languages and libraries. However, DynamoDB treats them
                      as number type attributes for mathematical operations.

                      - *(string) --*

                    - **BS** *(list) --*

                      An attribute of type Binary Set. For example:

                       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

                      - *(bytes) --*

                    - **M** *(dict) --*

                      An attribute of type Map. For example:

                       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

                      - *(string) --*

                        - *(dict) --*

                          Represents the data for an attribute.

                          Each attribute value is described as a name-value pair. The name is the
                          data type, and the value is the data itself.

                          For more information, see `Data Types
                          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                          in the *Amazon DynamoDB Developer Guide* .

                    - **L** *(list) --*

                      An attribute of type List. For example:

                       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

                      - *(dict) --*

                        Represents the data for an attribute.

                        Each attribute value is described as a name-value pair. The name is the
                        data type, and the value is the data itself.

                        For more information, see `Data Types
                        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                        in the *Amazon DynamoDB Developer Guide* .

                    - **NULL** *(boolean) --*

                      An attribute of type Null. For example:

                       ``"NULL": true``

                    - **BOOL** *(boolean) --*

                      An attribute of type Boolean. For example:

                       ``"BOOL": true``

    - **ItemCollectionMetrics** *(dict) --*

      A list of tables that were processed by ``BatchWriteItem`` and, for each table, information
      about any item collections that were affected by individual ``DeleteItem`` or ``PutItem``
      operations.

      Each entry consists of the following subelements:

      * ``ItemCollectionKey`` - The partition key value of the item collection. This is the same as
      the partition key value of the item.

      * ``SizeEstimateRangeGB`` - An estimate of item collection size, expressed in GB. This is a
      two-element array containing a lower bound and an upper bound for the estimate. The estimate
      includes the size of all the items in the table, plus the size of all attributes projected
      into all of the local secondary indexes on the table. Use this estimate to measure whether a
      local secondary index is approaching its size limit. The estimate is subject to change over
      time; therefore, do not rely on the precision or accuracy of the estimate.

      - *(string) --*

        - *(list) --*

          - *(dict) --*

            Information about item collections, if any, that were affected by the operation.
            ``ItemCollectionMetrics`` is only returned if the request asked for it. If the table
            does not have any local secondary indexes, this information is not returned in the
            response.

            - **ItemCollectionKey** *(dict) --*

              The partition key value of the item collection. This value is the same as the
              partition key value of the item.

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the data
                  type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

                  - **S** *(string) --*

                    An attribute of type String. For example:

                     ``"S": "Hello"``

                  - **N** *(string) --*

                    An attribute of type Number. For example:

                     ``"N": "123.45"``

                    Numbers are sent across the network to DynamoDB as strings, to maximize
                    compatibility across languages and libraries. However, DynamoDB treats them as
                    number type attributes for mathematical operations.

                  - **B** *(bytes) --*

                    An attribute of type Binary. For example:

                     ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

                  - **SS** *(list) --*

                    An attribute of type String Set. For example:

                     ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

                    - *(string) --*

                  - **NS** *(list) --*

                    An attribute of type Number Set. For example:

                     ``"NS": ["42.2", "-19", "7.5", "3.14"]``

                    Numbers are sent across the network to DynamoDB as strings, to maximize
                    compatibility across languages and libraries. However, DynamoDB treats them as
                    number type attributes for mathematical operations.

                    - *(string) --*

                  - **BS** *(list) --*

                    An attribute of type Binary Set. For example:

                     ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

                    - *(bytes) --*

                  - **M** *(dict) --*

                    An attribute of type Map. For example:

                     ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

                    - *(string) --*

                      - *(dict) --*

                        Represents the data for an attribute.

                        Each attribute value is described as a name-value pair. The name is the
                        data type, and the value is the data itself.

                        For more information, see `Data Types
                        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                        in the *Amazon DynamoDB Developer Guide* .

                  - **L** *(list) --*

                    An attribute of type List. For example:

                     ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

                    - *(dict) --*

                      Represents the data for an attribute.

                      Each attribute value is described as a name-value pair. The name is the data
                      type, and the value is the data itself.

                      For more information, see `Data Types
                      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                      in the *Amazon DynamoDB Developer Guide* .

                  - **NULL** *(boolean) --*

                    An attribute of type Null. For example:

                     ``"NULL": true``

                  - **BOOL** *(boolean) --*

                    An attribute of type Boolean. For example:

                     ``"BOOL": true``

            - **SizeEstimateRangeGB** *(list) --*

              An estimate of item collection size, in gigabytes. This value is a two-element array
              containing a lower bound and an upper bound for the estimate. The estimate includes
              the size of all the items in the table, plus the size of all attributes projected
              into all of the local secondary indexes on that table. Use this estimate to measure
              whether a local secondary index is approaching its size limit.

              The estimate is subject to change over time; therefore, do not rely on the precision
              or accuracy of the estimate.

              - *(float) --*

    - **ConsumedCapacity** *(list) --*

      The capacity units consumed by the entire ``BatchWriteItem`` operation.

      Each element consists of:

      * ``TableName`` - The table that consumed the provisioned throughput.

      * ``CapacityUnits`` - The total number of capacity units consumed.

      - *(dict) --*

        The capacity units consumed by an operation. The data returned includes the total
        provisioned throughput consumed, along with statistics for the table and any indexes
        involved in the operation. ``ConsumedCapacity`` is only returned if the request asked for
        it. For more information, see `Provisioned Throughput
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
        in the *Amazon DynamoDB Developer Guide* .

        - **TableName** *(string) --*

          The name of the table that was affected by the operation.

        - **CapacityUnits** *(float) --*

          The total number of capacity units consumed by the operation.

        - **ReadCapacityUnits** *(float) --*

          The total number of read capacity units consumed by the operation.

        - **WriteCapacityUnits** *(float) --*

          The total number of write capacity units consumed by the operation.

        - **Table** *(dict) --*

          The amount of throughput consumed on the table affected by the operation.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.

        - **LocalSecondaryIndexes** *(dict) --*

          The amount of throughput consumed on each local index affected by the operation.

          - *(string) --*

            - *(dict) --*

              Represents the amount of provisioned throughput capacity consumed on a table or an
              index.

              - **ReadCapacityUnits** *(float) --*

                The total number of read capacity units consumed on a table or an index.

              - **WriteCapacityUnits** *(float) --*

                The total number of write capacity units consumed on a table or an index.

              - **CapacityUnits** *(float) --*

                The total number of capacity units consumed on a table or an index.

        - **GlobalSecondaryIndexes** *(dict) --*

          The amount of throughput consumed on each global index affected by the operation.

          - *(string) --*

            - *(dict) --*

              Represents the amount of provisioned throughput capacity consumed on a table or an
              index.

              - **ReadCapacityUnits** *(float) --*

                The total number of read capacity units consumed on a table or an index.

              - **WriteCapacityUnits** *(float) --*

                The total number of write capacity units consumed on a table or an index.

              - **CapacityUnits** *(float) --*

                The total number of capacity units consumed on a table or an index.
    """


_ClientCreateBackupResponseBackupDetailsTypeDef = TypedDict(
    "_ClientCreateBackupResponseBackupDetailsTypeDef",
    {
        "BackupArn": str,
        "BackupName": str,
        "BackupSizeBytes": int,
        "BackupStatus": str,
        "BackupType": str,
        "BackupCreationDateTime": datetime,
        "BackupExpiryDateTime": datetime,
    },
    total=False,
)


class ClientCreateBackupResponseBackupDetailsTypeDef(
    _ClientCreateBackupResponseBackupDetailsTypeDef
):
    """
    Type definition for `ClientCreateBackupResponse` `BackupDetails`

    Contains the details of the backup created for the table.

    - **BackupArn** *(string) --*

      ARN associated with the backup.

    - **BackupName** *(string) --*

      Name of the requested backup.

    - **BackupSizeBytes** *(integer) --*

      Size of the backup in bytes.

    - **BackupStatus** *(string) --*

      Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

    - **BackupType** *(string) --*

      BackupType:

      * ``USER`` - You create and manage these using the on-demand backup feature.

      * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
      backup is automatically created and is retained for 35 days (at no additional cost). System
      backups allow you to restore the deleted table to the state it was in just before the point
      of deletion.

      * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

    - **BackupCreationDateTime** *(datetime) --*

      Time at which the backup was created. This is the request time of the backup.

    - **BackupExpiryDateTime** *(datetime) --*

      Time at which the automatic on-demand backup created by DynamoDB will expire. This
      ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.
    """


_ClientCreateBackupResponseTypeDef = TypedDict(
    "_ClientCreateBackupResponseTypeDef",
    {"BackupDetails": ClientCreateBackupResponseBackupDetailsTypeDef},
    total=False,
)


class ClientCreateBackupResponseTypeDef(_ClientCreateBackupResponseTypeDef):
    """
    Type definition for `ClientCreateBackup` `Response`

    - **BackupDetails** *(dict) --*

      Contains the details of the backup created for the table.

      - **BackupArn** *(string) --*

        ARN associated with the backup.

      - **BackupName** *(string) --*

        Name of the requested backup.

      - **BackupSizeBytes** *(integer) --*

        Size of the backup in bytes.

      - **BackupStatus** *(string) --*

        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

      - **BackupType** *(string) --*

        BackupType:

        * ``USER`` - You create and manage these using the on-demand backup feature.

        * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
        backup is automatically created and is retained for 35 days (at no additional cost). System
        backups allow you to restore the deleted table to the state it was in just before the point
        of deletion.

        * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

      - **BackupCreationDateTime** *(datetime) --*

        Time at which the backup was created. This is the request time of the backup.

      - **BackupExpiryDateTime** *(datetime) --*

        Time at which the automatic on-demand backup created by DynamoDB will expire. This
        ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.
    """


_ClientCreateGlobalTableReplicationGroupTypeDef = TypedDict(
    "_ClientCreateGlobalTableReplicationGroupTypeDef", {"RegionName": str}, total=False
)


class ClientCreateGlobalTableReplicationGroupTypeDef(
    _ClientCreateGlobalTableReplicationGroupTypeDef
):
    """
    Type definition for `ClientCreateGlobalTable` `ReplicationGroup`

    Represents the properties of a replica.

    - **RegionName** *(string) --*

      The Region where the replica needs to be created.
    """


_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef(
    _ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexes` `ProvisionedThroughputOverride`

    If not described, uses the source table GSI's read capacity settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's
      read capacity settings.
    """


_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "ProvisionedThroughputOverride": ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef,
    },
    total=False,
)


class ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef(
    _ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroup` `GlobalSecondaryIndexes`

    Represents the properties of a replica global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **ProvisionedThroughputOverride** *(dict) --*

      If not described, uses the source table GSI's read capacity settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's
        read capacity settings.
    """


_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef(
    _ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroup` `ProvisionedThroughputOverride`

    Replica-specific provisioned throughput. If not described, uses the source table's
    provisioned throughput settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's read
      capacity settings.
    """


_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef = TypedDict(
    "_ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef",
    {
        "RegionName": str,
        "ReplicaStatus": str,
        "ReplicaStatusDescription": str,
        "ReplicaStatusPercentProgress": str,
        "KMSMasterKeyId": str,
        "ProvisionedThroughputOverride": ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef,
        "GlobalSecondaryIndexes": List[
            ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef(
    _ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef
):
    """
    Type definition for `ClientCreateGlobalTableResponseGlobalTableDescription` `ReplicationGroup`

    Contains the details of the replica.

    - **RegionName** *(string) --*

      The name of the Region.

    - **ReplicaStatus** *(string) --*

      The current state of the replica:

      * ``CREATING`` - The replica is being created.

      * ``UPDATING`` - The replica is being updated.

      * ``DELETING`` - The replica is being deleted.

      * ``ACTIVE`` - The replica is ready for use.

    - **ReplicaStatusDescription** *(string) --*

      Detailed information about the replica status.

    - **ReplicaStatusPercentProgress** *(string) --*

      Specifies the progress of a Create, Update, or Delete action on the replica as a
      percentage.

    - **KMSMasterKeyId** *(string) --*

      The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
      encryption.

    - **ProvisionedThroughputOverride** *(dict) --*

      Replica-specific provisioned throughput. If not described, uses the source table's
      provisioned throughput settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's read
        capacity settings.

    - **GlobalSecondaryIndexes** *(list) --*

      Replica-specific global secondary index settings.

      - *(dict) --*

        Represents the properties of a replica global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **ProvisionedThroughputOverride** *(dict) --*

          If not described, uses the source table GSI's read capacity settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's
            read capacity settings.
    """


_ClientCreateGlobalTableResponseGlobalTableDescriptionTypeDef = TypedDict(
    "_ClientCreateGlobalTableResponseGlobalTableDescriptionTypeDef",
    {
        "ReplicationGroup": List[
            ClientCreateGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef
        ],
        "GlobalTableArn": str,
        "CreationDateTime": datetime,
        "GlobalTableStatus": str,
        "GlobalTableName": str,
    },
    total=False,
)


class ClientCreateGlobalTableResponseGlobalTableDescriptionTypeDef(
    _ClientCreateGlobalTableResponseGlobalTableDescriptionTypeDef
):
    """
    Type definition for `ClientCreateGlobalTableResponse` `GlobalTableDescription`

    Contains the details of the global table.

    - **ReplicationGroup** *(list) --*

      The Regions where the global table has replicas.

      - *(dict) --*

        Contains the details of the replica.

        - **RegionName** *(string) --*

          The name of the Region.

        - **ReplicaStatus** *(string) --*

          The current state of the replica:

          * ``CREATING`` - The replica is being created.

          * ``UPDATING`` - The replica is being updated.

          * ``DELETING`` - The replica is being deleted.

          * ``ACTIVE`` - The replica is ready for use.

        - **ReplicaStatusDescription** *(string) --*

          Detailed information about the replica status.

        - **ReplicaStatusPercentProgress** *(string) --*

          Specifies the progress of a Create, Update, or Delete action on the replica as a
          percentage.

        - **KMSMasterKeyId** *(string) --*

          The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
          encryption.

        - **ProvisionedThroughputOverride** *(dict) --*

          Replica-specific provisioned throughput. If not described, uses the source table's
          provisioned throughput settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's read
            capacity settings.

        - **GlobalSecondaryIndexes** *(list) --*

          Replica-specific global secondary index settings.

          - *(dict) --*

            Represents the properties of a replica global secondary index.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **ProvisionedThroughputOverride** *(dict) --*

              If not described, uses the source table GSI's read capacity settings.

              - **ReadCapacityUnits** *(integer) --*

                Replica-specific read capacity units. If not specified, uses the source table's
                read capacity settings.

    - **GlobalTableArn** *(string) --*

      The unique identifier of the global table.

    - **CreationDateTime** *(datetime) --*

      The creation time of the global table.

    - **GlobalTableStatus** *(string) --*

      The current state of the global table:

      * ``CREATING`` - The global table is being created.

      * ``UPDATING`` - The global table is being updated.

      * ``DELETING`` - The global table is being deleted.

      * ``ACTIVE`` - The global table is ready for use.

    - **GlobalTableName** *(string) --*

      The global table name.
    """


_ClientCreateGlobalTableResponseTypeDef = TypedDict(
    "_ClientCreateGlobalTableResponseTypeDef",
    {
        "GlobalTableDescription": ClientCreateGlobalTableResponseGlobalTableDescriptionTypeDef
    },
    total=False,
)


class ClientCreateGlobalTableResponseTypeDef(_ClientCreateGlobalTableResponseTypeDef):
    """
    Type definition for `ClientCreateGlobalTable` `Response`

    - **GlobalTableDescription** *(dict) --*

      Contains the details of the global table.

      - **ReplicationGroup** *(list) --*

        The Regions where the global table has replicas.

        - *(dict) --*

          Contains the details of the replica.

          - **RegionName** *(string) --*

            The name of the Region.

          - **ReplicaStatus** *(string) --*

            The current state of the replica:

            * ``CREATING`` - The replica is being created.

            * ``UPDATING`` - The replica is being updated.

            * ``DELETING`` - The replica is being deleted.

            * ``ACTIVE`` - The replica is ready for use.

          - **ReplicaStatusDescription** *(string) --*

            Detailed information about the replica status.

          - **ReplicaStatusPercentProgress** *(string) --*

            Specifies the progress of a Create, Update, or Delete action on the replica as a
            percentage.

          - **KMSMasterKeyId** *(string) --*

            The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
            encryption.

          - **ProvisionedThroughputOverride** *(dict) --*

            Replica-specific provisioned throughput. If not described, uses the source table's
            provisioned throughput settings.

            - **ReadCapacityUnits** *(integer) --*

              Replica-specific read capacity units. If not specified, uses the source table's read
              capacity settings.

          - **GlobalSecondaryIndexes** *(list) --*

            Replica-specific global secondary index settings.

            - *(dict) --*

              Represents the properties of a replica global secondary index.

              - **IndexName** *(string) --*

                The name of the global secondary index.

              - **ProvisionedThroughputOverride** *(dict) --*

                If not described, uses the source table GSI's read capacity settings.

                - **ReadCapacityUnits** *(integer) --*

                  Replica-specific read capacity units. If not specified, uses the source table's
                  read capacity settings.

      - **GlobalTableArn** *(string) --*

        The unique identifier of the global table.

      - **CreationDateTime** *(datetime) --*

        The creation time of the global table.

      - **GlobalTableStatus** *(string) --*

        The current state of the global table:

        * ``CREATING`` - The global table is being created.

        * ``UPDATING`` - The global table is being updated.

        * ``DELETING`` - The global table is being deleted.

        * ``ACTIVE`` - The global table is ready for use.

      - **GlobalTableName** *(string) --*

        The global table name.
    """


_ClientCreateTableAttributeDefinitionsTypeDef = TypedDict(
    "_ClientCreateTableAttributeDefinitionsTypeDef",
    {"AttributeName": str, "AttributeType": str},
)


class ClientCreateTableAttributeDefinitionsTypeDef(
    _ClientCreateTableAttributeDefinitionsTypeDef
):
    """
    Type definition for `ClientCreateTable` `AttributeDefinitions`

    Represents an attribute for describing the key schema for the table and indexes.

    - **AttributeName** *(string) --* **[REQUIRED]**

      A name for the attribute.

    - **AttributeType** *(string) --* **[REQUIRED]**

      The data type for the attribute, where:

      * ``S`` - the attribute is of type String

      * ``N`` - the attribute is of type Number

      * ``B`` - the attribute is of type Binary
    """


_ClientCreateTableGlobalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientCreateTableGlobalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
)


class ClientCreateTableGlobalSecondaryIndexesKeySchemaTypeDef(
    _ClientCreateTableGlobalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientCreateTableGlobalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes that
    make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example, a
    simple primary key would be represented by one ``KeySchemaElement`` (for the partition
    key). A composite primary key would require one ``KeySchemaElement`` for the partition key,
    and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute). The
    data type must be one of String, Number, or Binary. The attribute cannot be nested within a
    List or a Map.

    - **AttributeName** *(string) --* **[REQUIRED]**

      The name of a key attribute.

    - **KeyType** *(string) --* **[REQUIRED]**

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientCreateTableGlobalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientCreateTableGlobalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientCreateTableGlobalSecondaryIndexesProjectionTypeDef(
    _ClientCreateTableGlobalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientCreateTableGlobalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global secondary
    index. These are in addition to the primary key attributes and index key attributes, which
    are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The list
      of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across all of
      the local secondary indexes, must not exceed 20. If you project the same attribute into two
      different indexes, this counts as two distinct attributes when determining the total.

      - *(string) --*
    """


_ClientCreateTableGlobalSecondaryIndexesProvisionedThroughputTypeDef = TypedDict(
    "_ClientCreateTableGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    {"ReadCapacityUnits": int, "WriteCapacityUnits": int},
)


class ClientCreateTableGlobalSecondaryIndexesProvisionedThroughputTypeDef(
    _ClientCreateTableGlobalSecondaryIndexesProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientCreateTableGlobalSecondaryIndexes` `ProvisionedThroughput`

    Represents the provisioned throughput settings for the specified global secondary index.

    For current minimum and maximum provisioned throughput values, see `Limits
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
    *Amazon DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --* **[REQUIRED]**

      The maximum number of strongly consistent reads consumed per second before DynamoDB returns
      a ``ThrottlingException`` . For more information, see `Specifying Read and Write
      Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **WriteCapacityUnits** *(integer) --* **[REQUIRED]**

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_RequiredClientCreateTableGlobalSecondaryIndexesTypeDef = TypedDict(
    "_RequiredClientCreateTableGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[ClientCreateTableGlobalSecondaryIndexesKeySchemaTypeDef],
        "Projection": ClientCreateTableGlobalSecondaryIndexesProjectionTypeDef,
    },
)
_OptionalClientCreateTableGlobalSecondaryIndexesTypeDef = TypedDict(
    "_OptionalClientCreateTableGlobalSecondaryIndexesTypeDef",
    {
        "ProvisionedThroughput": ClientCreateTableGlobalSecondaryIndexesProvisionedThroughputTypeDef
    },
    total=False,
)


class ClientCreateTableGlobalSecondaryIndexesTypeDef(
    _RequiredClientCreateTableGlobalSecondaryIndexesTypeDef,
    _OptionalClientCreateTableGlobalSecondaryIndexesTypeDef,
):
    """
    Type definition for `ClientCreateTable` `GlobalSecondaryIndexes`

    Represents the properties of a global secondary index.

    - **IndexName** *(string) --* **[REQUIRED]**

      The name of the global secondary index. The name must be unique among all other indexes on
      this table.

    - **KeySchema** *(list) --* **[REQUIRED]**

      The complete key schema for a global secondary index, which consists of one or more pairs of
      attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute
        data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range attribute"
        derives from the way DynamoDB stores items with the same partition key physically close
        together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes that
        make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example, a
        simple primary key would be represented by one ``KeySchemaElement`` (for the partition
        key). A composite primary key would require one ``KeySchemaElement`` for the partition key,
        and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute). The
        data type must be one of String, Number, or Binary. The attribute cannot be nested within a
        List or a Map.

        - **AttributeName** *(string) --* **[REQUIRED]**

          The name of a key attribute.

        - **KeyType** *(string) --* **[REQUIRED]**

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --* **[REQUIRED]**

      Represents attributes that are copied (projected) from the table into the global secondary
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The list
        of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across all of
        the local secondary indexes, must not exceed 20. If you project the same attribute into two
        different indexes, this counts as two distinct attributes when determining the total.

        - *(string) --*

    - **ProvisionedThroughput** *(dict) --*

      Represents the provisioned throughput settings for the specified global secondary index.

      For current minimum and maximum provisioned throughput values, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
      *Amazon DynamoDB Developer Guide* .

      - **ReadCapacityUnits** *(integer) --* **[REQUIRED]**

        The maximum number of strongly consistent reads consumed per second before DynamoDB returns
        a ``ThrottlingException`` . For more information, see `Specifying Read and Write
        Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **WriteCapacityUnits** *(integer) --* **[REQUIRED]**

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` . For more information, see `Specifying Read and Write Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientCreateTableKeySchemaTypeDef = TypedDict(
    "_ClientCreateTableKeySchemaTypeDef", {"AttributeName": str, "KeyType": str}
)


class ClientCreateTableKeySchemaTypeDef(_ClientCreateTableKeySchemaTypeDef):
    """
    Type definition for `ClientCreateTable` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes that make
    up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example, a
    simple primary key would be represented by one ``KeySchemaElement`` (for the partition key). A
    composite primary key would require one ``KeySchemaElement`` for the partition key, and another
    ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute). The data
    type must be one of String, Number, or Binary. The attribute cannot be nested within a List or
    a Map.

    - **AttributeName** *(string) --* **[REQUIRED]**

      The name of a key attribute.

    - **KeyType** *(string) --* **[REQUIRED]**

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute
        data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range attribute"
        derives from the way DynamoDB stores items with the same partition key physically close
        together, in sorted order by the sort key value.
    """


_ClientCreateTableLocalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientCreateTableLocalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
)


class ClientCreateTableLocalSecondaryIndexesKeySchemaTypeDef(
    _ClientCreateTableLocalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientCreateTableLocalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes that
    make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example, a
    simple primary key would be represented by one ``KeySchemaElement`` (for the partition
    key). A composite primary key would require one ``KeySchemaElement`` for the partition key,
    and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute). The
    data type must be one of String, Number, or Binary. The attribute cannot be nested within a
    List or a Map.

    - **AttributeName** *(string) --* **[REQUIRED]**

      The name of a key attribute.

    - **KeyType** *(string) --* **[REQUIRED]**

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientCreateTableLocalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientCreateTableLocalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientCreateTableLocalSecondaryIndexesProjectionTypeDef(
    _ClientCreateTableLocalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientCreateTableLocalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the local secondary
    index. These are in addition to the primary key attributes and index key attributes, which
    are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The list
      of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across all of
      the local secondary indexes, must not exceed 20. If you project the same attribute into two
      different indexes, this counts as two distinct attributes when determining the total.

      - *(string) --*
    """


_ClientCreateTableLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientCreateTableLocalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[ClientCreateTableLocalSecondaryIndexesKeySchemaTypeDef],
        "Projection": ClientCreateTableLocalSecondaryIndexesProjectionTypeDef,
    },
)


class ClientCreateTableLocalSecondaryIndexesTypeDef(
    _ClientCreateTableLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientCreateTable` `LocalSecondaryIndexes`

    Represents the properties of a local secondary index.

    - **IndexName** *(string) --* **[REQUIRED]**

      The name of the local secondary index. The name must be unique among all other indexes on
      this table.

    - **KeySchema** *(list) --* **[REQUIRED]**

      The complete key schema for the local secondary index, consisting of one or more pairs of
      attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute
        data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range attribute"
        derives from the way DynamoDB stores items with the same partition key physically close
        together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes that
        make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example, a
        simple primary key would be represented by one ``KeySchemaElement`` (for the partition
        key). A composite primary key would require one ``KeySchemaElement`` for the partition key,
        and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute). The
        data type must be one of String, Number, or Binary. The attribute cannot be nested within a
        List or a Map.

        - **AttributeName** *(string) --* **[REQUIRED]**

          The name of a key attribute.

        - **KeyType** *(string) --* **[REQUIRED]**

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --* **[REQUIRED]**

      Represents attributes that are copied (projected) from the table into the local secondary
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The list
        of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across all of
        the local secondary indexes, must not exceed 20. If you project the same attribute into two
        different indexes, this counts as two distinct attributes when determining the total.

        - *(string) --*
    """


_ClientCreateTableProvisionedThroughputTypeDef = TypedDict(
    "_ClientCreateTableProvisionedThroughputTypeDef",
    {"ReadCapacityUnits": int, "WriteCapacityUnits": int},
)


class ClientCreateTableProvisionedThroughputTypeDef(
    _ClientCreateTableProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientCreateTable` `ProvisionedThroughput`

    Represents the provisioned throughput settings for a specified table or index. The settings can
    be modified using the ``UpdateTable`` operation.

    If you set BillingMode as ``PROVISIONED`` , you must specify this property. If you set
    BillingMode as ``PAY_PER_REQUEST`` , you cannot specify this property.

    For current minimum and maximum provisioned throughput values, see `Limits
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the *Amazon
    DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --* **[REQUIRED]**

      The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **WriteCapacityUnits** *(integer) --* **[REQUIRED]**

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientCreateTableResponseTableDescriptionAttributeDefinitionsTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionAttributeDefinitionsTypeDef",
    {"AttributeName": str, "AttributeType": str},
    total=False,
)


class ClientCreateTableResponseTableDescriptionAttributeDefinitionsTypeDef(
    _ClientCreateTableResponseTableDescriptionAttributeDefinitionsTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `AttributeDefinitions`

    Represents an attribute for describing the key schema for the table and indexes.

    - **AttributeName** *(string) --*

      A name for the attribute.

    - **AttributeType** *(string) --*

      The data type for the attribute, where:

      * ``S`` - the attribute is of type String

      * ``N`` - the attribute is of type Number

      * ``B`` - the attribute is of type Binary
    """


_ClientCreateTableResponseTableDescriptionBillingModeSummaryTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionBillingModeSummaryTypeDef",
    {"BillingMode": str, "LastUpdateToPayPerRequestDateTime": datetime},
    total=False,
)


class ClientCreateTableResponseTableDescriptionBillingModeSummaryTypeDef(
    _ClientCreateTableResponseTableDescriptionBillingModeSummaryTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `BillingModeSummary`

    Contains the details for the read/write capacity mode.

    - **BillingMode** *(string) --*

      Controls how you are charged for read and write throughput and how you manage capacity.
      This setting can be changed later.

      * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
      using ``PROVISIONED`` for predictable workloads.

      * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
      recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

    - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

      Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.
    """


_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef(
    _ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef(
    _ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
      list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    {
        "LastIncreaseDateTime": datetime,
        "LastDecreaseDateTime": datetime,
        "NumberOfDecreasesToday": int,
        "ReadCapacityUnits": int,
        "WriteCapacityUnits": int,
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef(
    _ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexes` `ProvisionedThroughput`

    Represents the provisioned throughput settings for the specified global secondary index.

    For current minimum and maximum provisioned throughput values, see `Limits
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
    the *Amazon DynamoDB Developer Guide* .

    - **LastIncreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput increase for this table.

    - **LastDecreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput decrease for this table.

    - **NumberOfDecreasesToday** *(integer) --*

      The number of provisioned throughput decreases for this table during this UTC
      calendar day. For current maximums on provisioned throughput decreases, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
      the *Amazon DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . Eventually consistent reads require less effort
      than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
      provides 100 eventually consistent ``ReadCapacityUnits`` per second.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` .
    """


_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef,
        "IndexStatus": str,
        "Backfilling": bool,
        "ProvisionedThroughput": ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef,
        "IndexSizeBytes": int,
        "ItemCount": int,
        "IndexArn": str,
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef(
    _ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `GlobalSecondaryIndexes`

    Represents the properties of a global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for a global secondary index, which consists of one or more
      pairs of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
        list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **IndexStatus** *(string) --*

      The current state of the global secondary index:

      * ``CREATING`` - The index is being created.

      * ``UPDATING`` - The index is being updated.

      * ``DELETING`` - The index is being deleted.

      * ``ACTIVE`` - The index is ready for use.

    - **Backfilling** *(boolean) --*

      Indicates whether the index is currently backfilling. *Backfilling* is the process of
      reading items from the table and determining whether they can be added to the index.
      (Not all items will qualify: For example, a partition key cannot have any duplicate
      values.) If an item can be added to the index, DynamoDB will do so. After all items
      have been processed, the backfilling operation is complete and ``Backfilling`` is false.

      You can delete an index that is being created during the ``Backfilling`` phase when
      ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
      index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
      is false.

      .. note::

        For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
        attribute does not appear in the ``DescribeTable`` output.

    - **ProvisionedThroughput** *(dict) --*

      Represents the provisioned throughput settings for the specified global secondary index.

      For current minimum and maximum provisioned throughput values, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
      the *Amazon DynamoDB Developer Guide* .

      - **LastIncreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput increase for this table.

      - **LastDecreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput decrease for this table.

      - **NumberOfDecreasesToday** *(integer) --*

        The number of provisioned throughput decreases for this table during this UTC
        calendar day. For current maximums on provisioned throughput decreases, see `Limits
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
        the *Amazon DynamoDB Developer Guide* .

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . Eventually consistent reads require less effort
        than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
        provides 100 eventually consistent ``ReadCapacityUnits`` per second.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` .

    - **IndexSizeBytes** *(integer) --*

      The total size of the specified index, in bytes. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified index. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **IndexArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the index.
    """


_ClientCreateTableResponseTableDescriptionKeySchemaTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientCreateTableResponseTableDescriptionKeySchemaTypeDef(
    _ClientCreateTableResponseTableDescriptionKeySchemaTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes that
    make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
    a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
    key). A composite primary key would require one ``KeySchemaElement`` for the partition
    key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
    The data type must be one of String, Number, or Binary. The attribute cannot be nested
    within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef(
    _ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionLocalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef(
    _ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionLocalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
      list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef,
        "IndexSizeBytes": int,
        "ItemCount": int,
        "IndexArn": str,
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesTypeDef(
    _ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `LocalSecondaryIndexes`

    Represents the properties of a local secondary index.

    - **IndexName** *(string) --*

      Represents the name of the local secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for the local secondary index, consisting of one or more pairs
      of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
        list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **IndexSizeBytes** *(integer) --*

      The total size of the specified index, in bytes. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified index. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **IndexArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the index.
    """


_ClientCreateTableResponseTableDescriptionProvisionedThroughputTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionProvisionedThroughputTypeDef",
    {
        "LastIncreaseDateTime": datetime,
        "LastDecreaseDateTime": datetime,
        "NumberOfDecreasesToday": int,
        "ReadCapacityUnits": int,
        "WriteCapacityUnits": int,
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionProvisionedThroughputTypeDef(
    _ClientCreateTableResponseTableDescriptionProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `ProvisionedThroughput`

    The provisioned throughput settings for the table, consisting of read and write capacity
    units, along with data about increases and decreases.

    - **LastIncreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput increase for this table.

    - **LastDecreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput decrease for this table.

    - **NumberOfDecreasesToday** *(integer) --*

      The number of provisioned throughput decreases for this table during this UTC calendar
      day. For current maximums on provisioned throughput decreases, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
      *Amazon DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
      strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
      100 eventually consistent ``ReadCapacityUnits`` per second.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` .
    """


_ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef(
    _ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexes` `ProvisionedThroughputOverride`

    If not described, uses the source table GSI's read capacity settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's
      read capacity settings.
    """


_ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "ProvisionedThroughputOverride": ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef,
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef(
    _ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionReplicas` `GlobalSecondaryIndexes`

    Represents the properties of a replica global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **ProvisionedThroughputOverride** *(dict) --*

      If not described, uses the source table GSI's read capacity settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's
        read capacity settings.
    """


_ClientCreateTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientCreateTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef(
    _ClientCreateTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescriptionReplicas` `ProvisionedThroughputOverride`

    Replica-specific provisioned throughput. If not described, uses the source table's
    provisioned throughput settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's read
      capacity settings.
    """


_ClientCreateTableResponseTableDescriptionReplicasTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionReplicasTypeDef",
    {
        "RegionName": str,
        "ReplicaStatus": str,
        "ReplicaStatusDescription": str,
        "ReplicaStatusPercentProgress": str,
        "KMSMasterKeyId": str,
        "ProvisionedThroughputOverride": ClientCreateTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef,
        "GlobalSecondaryIndexes": List[
            ClientCreateTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionReplicasTypeDef(
    _ClientCreateTableResponseTableDescriptionReplicasTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `Replicas`

    Contains the details of the replica.

    - **RegionName** *(string) --*

      The name of the Region.

    - **ReplicaStatus** *(string) --*

      The current state of the replica:

      * ``CREATING`` - The replica is being created.

      * ``UPDATING`` - The replica is being updated.

      * ``DELETING`` - The replica is being deleted.

      * ``ACTIVE`` - The replica is ready for use.

    - **ReplicaStatusDescription** *(string) --*

      Detailed information about the replica status.

    - **ReplicaStatusPercentProgress** *(string) --*

      Specifies the progress of a Create, Update, or Delete action on the replica as a
      percentage.

    - **KMSMasterKeyId** *(string) --*

      The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
      encryption.

    - **ProvisionedThroughputOverride** *(dict) --*

      Replica-specific provisioned throughput. If not described, uses the source table's
      provisioned throughput settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's read
        capacity settings.

    - **GlobalSecondaryIndexes** *(list) --*

      Replica-specific global secondary index settings.

      - *(dict) --*

        Represents the properties of a replica global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **ProvisionedThroughputOverride** *(dict) --*

          If not described, uses the source table GSI's read capacity settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's
            read capacity settings.
    """


_ClientCreateTableResponseTableDescriptionRestoreSummaryTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionRestoreSummaryTypeDef",
    {
        "SourceBackupArn": str,
        "SourceTableArn": str,
        "RestoreDateTime": datetime,
        "RestoreInProgress": bool,
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionRestoreSummaryTypeDef(
    _ClientCreateTableResponseTableDescriptionRestoreSummaryTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `RestoreSummary`

    Contains details for the restore.

    - **SourceBackupArn** *(string) --*

      The Amazon Resource Name (ARN) of the backup from which the table was restored.

    - **SourceTableArn** *(string) --*

      The ARN of the source table of the backup that is being restored.

    - **RestoreDateTime** *(datetime) --*

      Point in time or source backup time.

    - **RestoreInProgress** *(boolean) --*

      Indicates if a restore is in progress or not.
    """


_ClientCreateTableResponseTableDescriptionSSEDescriptionTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionSSEDescriptionTypeDef",
    {"Status": str, "SSEType": str, "KMSMasterKeyArn": str},
    total=False,
)


class ClientCreateTableResponseTableDescriptionSSEDescriptionTypeDef(
    _ClientCreateTableResponseTableDescriptionSSEDescriptionTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `SSEDescription`

    The description of the server-side encryption status on the specified table.

    - **Status** *(string) --*

      Represents the current state of server-side encryption. The only supported values are:

      * ``ENABLED`` - Server-side encryption is enabled.

      * ``UPDATING`` - Server-side encryption is being updated.

    - **SSEType** *(string) --*

      Server-side encryption type. The only supported value is:

      * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
      stored in your account and is managed by AWS KMS (AWS KMS charges apply).

    - **KMSMasterKeyArn** *(string) --*

      The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientCreateTableResponseTableDescriptionStreamSpecificationTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionStreamSpecificationTypeDef",
    {"StreamEnabled": bool, "StreamViewType": str},
    total=False,
)


class ClientCreateTableResponseTableDescriptionStreamSpecificationTypeDef(
    _ClientCreateTableResponseTableDescriptionStreamSpecificationTypeDef
):
    """
    Type definition for `ClientCreateTableResponseTableDescription` `StreamSpecification`

    The current DynamoDB Streams configuration for the table.

    - **StreamEnabled** *(boolean) --*

      Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

    - **StreamViewType** *(string) --*

      When an item in the table is modified, ``StreamViewType`` determines what information is
      written to the stream for this table. Valid values for ``StreamViewType`` are:

      * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

      * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
      stream.

      * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
      the stream.

      * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
      to the stream.
    """


_ClientCreateTableResponseTableDescriptionTypeDef = TypedDict(
    "_ClientCreateTableResponseTableDescriptionTypeDef",
    {
        "AttributeDefinitions": List[
            ClientCreateTableResponseTableDescriptionAttributeDefinitionsTypeDef
        ],
        "TableName": str,
        "KeySchema": List[ClientCreateTableResponseTableDescriptionKeySchemaTypeDef],
        "TableStatus": str,
        "CreationDateTime": datetime,
        "ProvisionedThroughput": ClientCreateTableResponseTableDescriptionProvisionedThroughputTypeDef,
        "TableSizeBytes": int,
        "ItemCount": int,
        "TableArn": str,
        "TableId": str,
        "BillingModeSummary": ClientCreateTableResponseTableDescriptionBillingModeSummaryTypeDef,
        "LocalSecondaryIndexes": List[
            ClientCreateTableResponseTableDescriptionLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": List[
            ClientCreateTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef
        ],
        "StreamSpecification": ClientCreateTableResponseTableDescriptionStreamSpecificationTypeDef,
        "LatestStreamLabel": str,
        "LatestStreamArn": str,
        "GlobalTableVersion": str,
        "Replicas": List[ClientCreateTableResponseTableDescriptionReplicasTypeDef],
        "RestoreSummary": ClientCreateTableResponseTableDescriptionRestoreSummaryTypeDef,
        "SSEDescription": ClientCreateTableResponseTableDescriptionSSEDescriptionTypeDef,
    },
    total=False,
)


class ClientCreateTableResponseTableDescriptionTypeDef(
    _ClientCreateTableResponseTableDescriptionTypeDef
):
    """
    Type definition for `ClientCreateTableResponse` `TableDescription`

    Represents the properties of the table.

    - **AttributeDefinitions** *(list) --*

      An array of ``AttributeDefinition`` objects. Each of these objects describes one attribute
      in the table and index key schema.

      Each ``AttributeDefinition`` object in this array is composed of:

      * ``AttributeName`` - The name of the attribute.

      * ``AttributeType`` - The data type for the attribute.

      - *(dict) --*

        Represents an attribute for describing the key schema for the table and indexes.

        - **AttributeName** *(string) --*

          A name for the attribute.

        - **AttributeType** *(string) --*

          The data type for the attribute, where:

          * ``S`` - the attribute is of type String

          * ``N`` - the attribute is of type Number

          * ``B`` - the attribute is of type Binary

    - **TableName** *(string) --*

      The name of the table.

    - **KeySchema** *(list) --*

      The primary key structure for the table. Each ``KeySchemaElement`` consists of:

      * ``AttributeName`` - The name of the attribute.

      * ``KeyType`` - The role of the attribute:

        * ``HASH`` - partition key

        * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      For more information about primary keys, see `Primary Key
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey>`__
      in the *Amazon DynamoDB Developer Guide* .

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes that
        make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
        a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
        key). A composite primary key would require one ``KeySchemaElement`` for the partition
        key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
        The data type must be one of String, Number, or Binary. The attribute cannot be nested
        within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **TableStatus** *(string) --*

      The current state of the table:

      * ``CREATING`` - The table is being created.

      * ``UPDATING`` - The table is being updated.

      * ``DELETING`` - The table is being deleted.

      * ``ACTIVE`` - The table is ready for use.

    - **CreationDateTime** *(datetime) --*

      The date and time when the table was created, in `UNIX epoch time
      <http://www.epochconverter.com/>`__ format.

    - **ProvisionedThroughput** *(dict) --*

      The provisioned throughput settings for the table, consisting of read and write capacity
      units, along with data about increases and decreases.

      - **LastIncreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput increase for this table.

      - **LastDecreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput decrease for this table.

      - **NumberOfDecreasesToday** *(integer) --*

        The number of provisioned throughput decreases for this table during this UTC calendar
        day. For current maximums on provisioned throughput decreases, see `Limits
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
        *Amazon DynamoDB Developer Guide* .

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
        strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
        100 eventually consistent ``ReadCapacityUnits`` per second.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` .

    - **TableSizeBytes** *(integer) --*

      The total size of the specified table, in bytes. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified table. DynamoDB updates this value approximately every
      six hours. Recent changes might not be reflected in this value.

    - **TableArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the table.

    - **TableId** *(string) --*

      Unique identifier for the table for which the backup was created.

    - **BillingModeSummary** *(dict) --*

      Contains the details for the read/write capacity mode.

      - **BillingMode** *(string) --*

        Controls how you are charged for read and write throughput and how you manage capacity.
        This setting can be changed later.

        * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
        using ``PROVISIONED`` for predictable workloads.

        * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
        recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

      - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

        Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.

    - **LocalSecondaryIndexes** *(list) --*

      Represents one or more local secondary indexes on the table. Each index is scoped to a
      given partition key value. Tables with one or more local secondary indexes are subject to
      an item collection size limit, where the amount of data within a given item collection
      cannot exceed 10 GB. Each element is composed of:

      * ``IndexName`` - The name of the local secondary index.

      * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
      schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
      same partition key as the table.

      * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected. Each attribute specification is composed of:

        * ``ProjectionType`` - One of the following:

          * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

          * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
          list of projected attributes is in ``NonKeyAttributes`` .

          * ``ALL`` - All of the table attributes are projected into the index.

        * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
        into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
        , summed across all of the secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

      * ``IndexSizeBytes`` - Represents the total size of the index, in bytes. DynamoDB updates
      this value approximately every six hours. Recent changes might not be reflected in this
      value.

      * ``ItemCount`` - Represents the number of items in the index. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

      If the table is in the ``DELETING`` state, no information about indexes will be returned.

      - *(dict) --*

        Represents the properties of a local secondary index.

        - **IndexName** *(string) --*

          Represents the name of the local secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for the local secondary index, consisting of one or more pairs
          of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **IndexSizeBytes** *(integer) --*

          The total size of the specified index, in bytes. DynamoDB updates this value
          approximately every six hours. Recent changes might not be reflected in this value.

        - **ItemCount** *(integer) --*

          The number of items in the specified index. DynamoDB updates this value approximately
          every six hours. Recent changes might not be reflected in this value.

        - **IndexArn** *(string) --*

          The Amazon Resource Name (ARN) that uniquely identifies the index.

    - **GlobalSecondaryIndexes** *(list) --*

      The global secondary indexes, if any, on the table. Each index is scoped to a given
      partition key value. Each element is composed of:

      * ``Backfilling`` - If true, then the index is currently in the backfilling phase.
      Backfilling occurs only when a new global secondary index is added to the table. It is the
      process by which DynamoDB populates the new index with data from the table. (This attribute
      does not appear for indexes that were created during a ``CreateTable`` operation.)  You can
      delete an index that is being created during the ``Backfilling`` phase when ``IndexStatus``
      is set to CREATING and ``Backfilling`` is true. You can't delete the index that is being
      created when ``IndexStatus`` is set to CREATING and ``Backfilling`` is false. (This
      attribute does not appear for indexes that were created during a ``CreateTable`` operation.)

      * ``IndexName`` - The name of the global secondary index.

      * ``IndexSizeBytes`` - The total size of the global secondary index, in bytes. DynamoDB
      updates this value approximately every six hours. Recent changes might not be reflected in
      this value.

      * ``IndexStatus`` - The current status of the global secondary index:

        * ``CREATING`` - The index is being created.

        * ``UPDATING`` - The index is being updated.

        * ``DELETING`` - The index is being deleted.

        * ``ACTIVE`` - The index is ready for use.

      * ``ItemCount`` - The number of items in the global secondary index. DynamoDB updates this
      value approximately every six hours. Recent changes might not be reflected in this value.

      * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
      schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
      same partition key as the table.

      * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected. Each attribute specification is composed of:

        * ``ProjectionType`` - One of the following:

          * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

          * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
          list of projected attributes is in ``NonKeyAttributes`` .

          * ``ALL`` - All of the table attributes are projected into the index.

        * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
        into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
        , summed across all of the secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

      * ``ProvisionedThroughput`` - The provisioned throughput settings for the global secondary
      index, consisting of read and write capacity units, along with data about increases and
      decreases.

      If the table is in the ``DELETING`` state, no information about indexes will be returned.

      - *(dict) --*

        Represents the properties of a global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for a global secondary index, which consists of one or more
          pairs of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **IndexStatus** *(string) --*

          The current state of the global secondary index:

          * ``CREATING`` - The index is being created.

          * ``UPDATING`` - The index is being updated.

          * ``DELETING`` - The index is being deleted.

          * ``ACTIVE`` - The index is ready for use.

        - **Backfilling** *(boolean) --*

          Indicates whether the index is currently backfilling. *Backfilling* is the process of
          reading items from the table and determining whether they can be added to the index.
          (Not all items will qualify: For example, a partition key cannot have any duplicate
          values.) If an item can be added to the index, DynamoDB will do so. After all items
          have been processed, the backfilling operation is complete and ``Backfilling`` is false.

          You can delete an index that is being created during the ``Backfilling`` phase when
          ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
          index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
          is false.

          .. note::

            For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
            attribute does not appear in the ``DescribeTable`` output.

        - **ProvisionedThroughput** *(dict) --*

          Represents the provisioned throughput settings for the specified global secondary index.

          For current minimum and maximum provisioned throughput values, see `Limits
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
          the *Amazon DynamoDB Developer Guide* .

          - **LastIncreaseDateTime** *(datetime) --*

            The date and time of the last provisioned throughput increase for this table.

          - **LastDecreaseDateTime** *(datetime) --*

            The date and time of the last provisioned throughput decrease for this table.

          - **NumberOfDecreasesToday** *(integer) --*

            The number of provisioned throughput decreases for this table during this UTC
            calendar day. For current maximums on provisioned throughput decreases, see `Limits
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
            the *Amazon DynamoDB Developer Guide* .

          - **ReadCapacityUnits** *(integer) --*

            The maximum number of strongly consistent reads consumed per second before DynamoDB
            returns a ``ThrottlingException`` . Eventually consistent reads require less effort
            than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
            provides 100 eventually consistent ``ReadCapacityUnits`` per second.

          - **WriteCapacityUnits** *(integer) --*

            The maximum number of writes consumed per second before DynamoDB returns a
            ``ThrottlingException`` .

        - **IndexSizeBytes** *(integer) --*

          The total size of the specified index, in bytes. DynamoDB updates this value
          approximately every six hours. Recent changes might not be reflected in this value.

        - **ItemCount** *(integer) --*

          The number of items in the specified index. DynamoDB updates this value approximately
          every six hours. Recent changes might not be reflected in this value.

        - **IndexArn** *(string) --*

          The Amazon Resource Name (ARN) that uniquely identifies the index.

    - **StreamSpecification** *(dict) --*

      The current DynamoDB Streams configuration for the table.

      - **StreamEnabled** *(boolean) --*

        Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

      - **StreamViewType** *(string) --*

        When an item in the table is modified, ``StreamViewType`` determines what information is
        written to the stream for this table. Valid values for ``StreamViewType`` are:

        * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

        * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
        stream.

        * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
        the stream.

        * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
        to the stream.

    - **LatestStreamLabel** *(string) --*

      A timestamp, in ISO 8601 format, for this stream.

      Note that ``LatestStreamLabel`` is not a unique identifier for the stream, because it is
      possible that a stream from another table might have the same timestamp. However, the
      combination of the following three elements is guaranteed to be unique:

      * AWS customer ID

      * Table name

      * ``StreamLabel``

    - **LatestStreamArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.

    - **GlobalTableVersion** *(string) --*

      Represents the version of `global tables
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html>`__ in
      use, if the table is replicated across AWS Regions.

    - **Replicas** *(list) --*

      Represents replicas of the table.

      - *(dict) --*

        Contains the details of the replica.

        - **RegionName** *(string) --*

          The name of the Region.

        - **ReplicaStatus** *(string) --*

          The current state of the replica:

          * ``CREATING`` - The replica is being created.

          * ``UPDATING`` - The replica is being updated.

          * ``DELETING`` - The replica is being deleted.

          * ``ACTIVE`` - The replica is ready for use.

        - **ReplicaStatusDescription** *(string) --*

          Detailed information about the replica status.

        - **ReplicaStatusPercentProgress** *(string) --*

          Specifies the progress of a Create, Update, or Delete action on the replica as a
          percentage.

        - **KMSMasterKeyId** *(string) --*

          The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
          encryption.

        - **ProvisionedThroughputOverride** *(dict) --*

          Replica-specific provisioned throughput. If not described, uses the source table's
          provisioned throughput settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's read
            capacity settings.

        - **GlobalSecondaryIndexes** *(list) --*

          Replica-specific global secondary index settings.

          - *(dict) --*

            Represents the properties of a replica global secondary index.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **ProvisionedThroughputOverride** *(dict) --*

              If not described, uses the source table GSI's read capacity settings.

              - **ReadCapacityUnits** *(integer) --*

                Replica-specific read capacity units. If not specified, uses the source table's
                read capacity settings.

    - **RestoreSummary** *(dict) --*

      Contains details for the restore.

      - **SourceBackupArn** *(string) --*

        The Amazon Resource Name (ARN) of the backup from which the table was restored.

      - **SourceTableArn** *(string) --*

        The ARN of the source table of the backup that is being restored.

      - **RestoreDateTime** *(datetime) --*

        Point in time or source backup time.

      - **RestoreInProgress** *(boolean) --*

        Indicates if a restore is in progress or not.

    - **SSEDescription** *(dict) --*

      The description of the server-side encryption status on the specified table.

      - **Status** *(string) --*

        Represents the current state of server-side encryption. The only supported values are:

        * ``ENABLED`` - Server-side encryption is enabled.

        * ``UPDATING`` - Server-side encryption is being updated.

      - **SSEType** *(string) --*

        Server-side encryption type. The only supported value is:

        * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
        stored in your account and is managed by AWS KMS (AWS KMS charges apply).

      - **KMSMasterKeyArn** *(string) --*

        The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientCreateTableResponseTypeDef = TypedDict(
    "_ClientCreateTableResponseTypeDef",
    {"TableDescription": ClientCreateTableResponseTableDescriptionTypeDef},
    total=False,
)


class ClientCreateTableResponseTypeDef(_ClientCreateTableResponseTypeDef):
    """
    Type definition for `ClientCreateTable` `Response`

    Represents the output of a ``CreateTable`` operation.

    - **TableDescription** *(dict) --*

      Represents the properties of the table.

      - **AttributeDefinitions** *(list) --*

        An array of ``AttributeDefinition`` objects. Each of these objects describes one attribute
        in the table and index key schema.

        Each ``AttributeDefinition`` object in this array is composed of:

        * ``AttributeName`` - The name of the attribute.

        * ``AttributeType`` - The data type for the attribute.

        - *(dict) --*

          Represents an attribute for describing the key schema for the table and indexes.

          - **AttributeName** *(string) --*

            A name for the attribute.

          - **AttributeType** *(string) --*

            The data type for the attribute, where:

            * ``S`` - the attribute is of type String

            * ``N`` - the attribute is of type Number

            * ``B`` - the attribute is of type Binary

      - **TableName** *(string) --*

        The name of the table.

      - **KeySchema** *(list) --*

        The primary key structure for the table. Each ``KeySchemaElement`` consists of:

        * ``AttributeName`` - The name of the attribute.

        * ``KeyType`` - The role of the attribute:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

        .. note::

          The partition key of an item is also known as its *hash attribute* . The term "hash
          attribute" derives from DynamoDB's usage of an internal hash function to evenly
          distribute data items across partitions, based on their partition key values.

          The sort key of an item is also known as its *range attribute* . The term "range
          attribute" derives from the way DynamoDB stores items with the same partition key
          physically close together, in sorted order by the sort key value.

        For more information about primary keys, see `Primary Key
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey>`__
        in the *Amazon DynamoDB Developer Guide* .

        - *(dict) --*

          Represents *a single element* of a key schema. A key schema specifies the attributes that
          make up the primary key of a table, or the key attributes of an index.

          A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
          a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
          key). A composite primary key would require one ``KeySchemaElement`` for the partition
          key, and another ``KeySchemaElement`` for the sort key.

          A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
          The data type must be one of String, Number, or Binary. The attribute cannot be nested
          within a List or a Map.

          - **AttributeName** *(string) --*

            The name of a key attribute.

          - **KeyType** *(string) --*

            The role that this key attribute will assume:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

      - **TableStatus** *(string) --*

        The current state of the table:

        * ``CREATING`` - The table is being created.

        * ``UPDATING`` - The table is being updated.

        * ``DELETING`` - The table is being deleted.

        * ``ACTIVE`` - The table is ready for use.

      - **CreationDateTime** *(datetime) --*

        The date and time when the table was created, in `UNIX epoch time
        <http://www.epochconverter.com/>`__ format.

      - **ProvisionedThroughput** *(dict) --*

        The provisioned throughput settings for the table, consisting of read and write capacity
        units, along with data about increases and decreases.

        - **LastIncreaseDateTime** *(datetime) --*

          The date and time of the last provisioned throughput increase for this table.

        - **LastDecreaseDateTime** *(datetime) --*

          The date and time of the last provisioned throughput decrease for this table.

        - **NumberOfDecreasesToday** *(integer) --*

          The number of provisioned throughput decreases for this table during this UTC calendar
          day. For current maximums on provisioned throughput decreases, see `Limits
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
          *Amazon DynamoDB Developer Guide* .

        - **ReadCapacityUnits** *(integer) --*

          The maximum number of strongly consistent reads consumed per second before DynamoDB
          returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
          strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
          100 eventually consistent ``ReadCapacityUnits`` per second.

        - **WriteCapacityUnits** *(integer) --*

          The maximum number of writes consumed per second before DynamoDB returns a
          ``ThrottlingException`` .

      - **TableSizeBytes** *(integer) --*

        The total size of the specified table, in bytes. DynamoDB updates this value approximately
        every six hours. Recent changes might not be reflected in this value.

      - **ItemCount** *(integer) --*

        The number of items in the specified table. DynamoDB updates this value approximately every
        six hours. Recent changes might not be reflected in this value.

      - **TableArn** *(string) --*

        The Amazon Resource Name (ARN) that uniquely identifies the table.

      - **TableId** *(string) --*

        Unique identifier for the table for which the backup was created.

      - **BillingModeSummary** *(dict) --*

        Contains the details for the read/write capacity mode.

        - **BillingMode** *(string) --*

          Controls how you are charged for read and write throughput and how you manage capacity.
          This setting can be changed later.

          * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
          using ``PROVISIONED`` for predictable workloads.

          * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
          recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

        - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

          Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.

      - **LocalSecondaryIndexes** *(list) --*

        Represents one or more local secondary indexes on the table. Each index is scoped to a
        given partition key value. Tables with one or more local secondary indexes are subject to
        an item collection size limit, where the amount of data within a given item collection
        cannot exceed 10 GB. Each element is composed of:

        * ``IndexName`` - The name of the local secondary index.

        * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
        same partition key as the table.

        * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
        index. These are in addition to the primary key attributes and index key attributes, which
        are automatically projected. Each attribute specification is composed of:

          * ``ProjectionType`` - One of the following:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
          into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
          , summed across all of the secondary indexes, must not exceed 20. If you project the same
          attribute into two different indexes, this counts as two distinct attributes when
          determining the total.

        * ``IndexSizeBytes`` - Represents the total size of the index, in bytes. DynamoDB updates
        this value approximately every six hours. Recent changes might not be reflected in this
        value.

        * ``ItemCount`` - Represents the number of items in the index. DynamoDB updates this value
        approximately every six hours. Recent changes might not be reflected in this value.

        If the table is in the ``DELETING`` state, no information about indexes will be returned.

        - *(dict) --*

          Represents the properties of a local secondary index.

          - **IndexName** *(string) --*

            Represents the name of the local secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for the local secondary index, consisting of one or more pairs
            of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the attributes
              that make up the primary key of a table, or the key attributes of an index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term "range
                  attribute" derives from the way DynamoDB stores items with the same partition key
                  physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
              list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **IndexSizeBytes** *(integer) --*

            The total size of the specified index, in bytes. DynamoDB updates this value
            approximately every six hours. Recent changes might not be reflected in this value.

          - **ItemCount** *(integer) --*

            The number of items in the specified index. DynamoDB updates this value approximately
            every six hours. Recent changes might not be reflected in this value.

          - **IndexArn** *(string) --*

            The Amazon Resource Name (ARN) that uniquely identifies the index.

      - **GlobalSecondaryIndexes** *(list) --*

        The global secondary indexes, if any, on the table. Each index is scoped to a given
        partition key value. Each element is composed of:

        * ``Backfilling`` - If true, then the index is currently in the backfilling phase.
        Backfilling occurs only when a new global secondary index is added to the table. It is the
        process by which DynamoDB populates the new index with data from the table. (This attribute
        does not appear for indexes that were created during a ``CreateTable`` operation.)  You can
        delete an index that is being created during the ``Backfilling`` phase when ``IndexStatus``
        is set to CREATING and ``Backfilling`` is true. You can't delete the index that is being
        created when ``IndexStatus`` is set to CREATING and ``Backfilling`` is false. (This
        attribute does not appear for indexes that were created during a ``CreateTable`` operation.)

        * ``IndexName`` - The name of the global secondary index.

        * ``IndexSizeBytes`` - The total size of the global secondary index, in bytes. DynamoDB
        updates this value approximately every six hours. Recent changes might not be reflected in
        this value.

        * ``IndexStatus`` - The current status of the global secondary index:

          * ``CREATING`` - The index is being created.

          * ``UPDATING`` - The index is being updated.

          * ``DELETING`` - The index is being deleted.

          * ``ACTIVE`` - The index is ready for use.

        * ``ItemCount`` - The number of items in the global secondary index. DynamoDB updates this
        value approximately every six hours. Recent changes might not be reflected in this value.

        * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
        same partition key as the table.

        * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
        index. These are in addition to the primary key attributes and index key attributes, which
        are automatically projected. Each attribute specification is composed of:

          * ``ProjectionType`` - One of the following:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
          into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
          , summed across all of the secondary indexes, must not exceed 20. If you project the same
          attribute into two different indexes, this counts as two distinct attributes when
          determining the total.

        * ``ProvisionedThroughput`` - The provisioned throughput settings for the global secondary
        index, consisting of read and write capacity units, along with data about increases and
        decreases.

        If the table is in the ``DELETING`` state, no information about indexes will be returned.

        - *(dict) --*

          Represents the properties of a global secondary index.

          - **IndexName** *(string) --*

            The name of the global secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for a global secondary index, which consists of one or more
            pairs of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the attributes
              that make up the primary key of a table, or the key attributes of an index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term "range
                  attribute" derives from the way DynamoDB stores items with the same partition key
                  physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
              list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **IndexStatus** *(string) --*

            The current state of the global secondary index:

            * ``CREATING`` - The index is being created.

            * ``UPDATING`` - The index is being updated.

            * ``DELETING`` - The index is being deleted.

            * ``ACTIVE`` - The index is ready for use.

          - **Backfilling** *(boolean) --*

            Indicates whether the index is currently backfilling. *Backfilling* is the process of
            reading items from the table and determining whether they can be added to the index.
            (Not all items will qualify: For example, a partition key cannot have any duplicate
            values.) If an item can be added to the index, DynamoDB will do so. After all items
            have been processed, the backfilling operation is complete and ``Backfilling`` is false.

            You can delete an index that is being created during the ``Backfilling`` phase when
            ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
            index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
            is false.

            .. note::

              For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
              attribute does not appear in the ``DescribeTable`` output.

          - **ProvisionedThroughput** *(dict) --*

            Represents the provisioned throughput settings for the specified global secondary index.

            For current minimum and maximum provisioned throughput values, see `Limits
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
            the *Amazon DynamoDB Developer Guide* .

            - **LastIncreaseDateTime** *(datetime) --*

              The date and time of the last provisioned throughput increase for this table.

            - **LastDecreaseDateTime** *(datetime) --*

              The date and time of the last provisioned throughput decrease for this table.

            - **NumberOfDecreasesToday** *(integer) --*

              The number of provisioned throughput decreases for this table during this UTC
              calendar day. For current maximums on provisioned throughput decreases, see `Limits
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
              the *Amazon DynamoDB Developer Guide* .

            - **ReadCapacityUnits** *(integer) --*

              The maximum number of strongly consistent reads consumed per second before DynamoDB
              returns a ``ThrottlingException`` . Eventually consistent reads require less effort
              than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
              provides 100 eventually consistent ``ReadCapacityUnits`` per second.

            - **WriteCapacityUnits** *(integer) --*

              The maximum number of writes consumed per second before DynamoDB returns a
              ``ThrottlingException`` .

          - **IndexSizeBytes** *(integer) --*

            The total size of the specified index, in bytes. DynamoDB updates this value
            approximately every six hours. Recent changes might not be reflected in this value.

          - **ItemCount** *(integer) --*

            The number of items in the specified index. DynamoDB updates this value approximately
            every six hours. Recent changes might not be reflected in this value.

          - **IndexArn** *(string) --*

            The Amazon Resource Name (ARN) that uniquely identifies the index.

      - **StreamSpecification** *(dict) --*

        The current DynamoDB Streams configuration for the table.

        - **StreamEnabled** *(boolean) --*

          Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

        - **StreamViewType** *(string) --*

          When an item in the table is modified, ``StreamViewType`` determines what information is
          written to the stream for this table. Valid values for ``StreamViewType`` are:

          * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

          * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
          stream.

          * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
          the stream.

          * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
          to the stream.

      - **LatestStreamLabel** *(string) --*

        A timestamp, in ISO 8601 format, for this stream.

        Note that ``LatestStreamLabel`` is not a unique identifier for the stream, because it is
        possible that a stream from another table might have the same timestamp. However, the
        combination of the following three elements is guaranteed to be unique:

        * AWS customer ID

        * Table name

        * ``StreamLabel``

      - **LatestStreamArn** *(string) --*

        The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.

      - **GlobalTableVersion** *(string) --*

        Represents the version of `global tables
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html>`__ in
        use, if the table is replicated across AWS Regions.

      - **Replicas** *(list) --*

        Represents replicas of the table.

        - *(dict) --*

          Contains the details of the replica.

          - **RegionName** *(string) --*

            The name of the Region.

          - **ReplicaStatus** *(string) --*

            The current state of the replica:

            * ``CREATING`` - The replica is being created.

            * ``UPDATING`` - The replica is being updated.

            * ``DELETING`` - The replica is being deleted.

            * ``ACTIVE`` - The replica is ready for use.

          - **ReplicaStatusDescription** *(string) --*

            Detailed information about the replica status.

          - **ReplicaStatusPercentProgress** *(string) --*

            Specifies the progress of a Create, Update, or Delete action on the replica as a
            percentage.

          - **KMSMasterKeyId** *(string) --*

            The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
            encryption.

          - **ProvisionedThroughputOverride** *(dict) --*

            Replica-specific provisioned throughput. If not described, uses the source table's
            provisioned throughput settings.

            - **ReadCapacityUnits** *(integer) --*

              Replica-specific read capacity units. If not specified, uses the source table's read
              capacity settings.

          - **GlobalSecondaryIndexes** *(list) --*

            Replica-specific global secondary index settings.

            - *(dict) --*

              Represents the properties of a replica global secondary index.

              - **IndexName** *(string) --*

                The name of the global secondary index.

              - **ProvisionedThroughputOverride** *(dict) --*

                If not described, uses the source table GSI's read capacity settings.

                - **ReadCapacityUnits** *(integer) --*

                  Replica-specific read capacity units. If not specified, uses the source table's
                  read capacity settings.

      - **RestoreSummary** *(dict) --*

        Contains details for the restore.

        - **SourceBackupArn** *(string) --*

          The Amazon Resource Name (ARN) of the backup from which the table was restored.

        - **SourceTableArn** *(string) --*

          The ARN of the source table of the backup that is being restored.

        - **RestoreDateTime** *(datetime) --*

          Point in time or source backup time.

        - **RestoreInProgress** *(boolean) --*

          Indicates if a restore is in progress or not.

      - **SSEDescription** *(dict) --*

        The description of the server-side encryption status on the specified table.

        - **Status** *(string) --*

          Represents the current state of server-side encryption. The only supported values are:

          * ``ENABLED`` - Server-side encryption is enabled.

          * ``UPDATING`` - Server-side encryption is being updated.

        - **SSEType** *(string) --*

          Server-side encryption type. The only supported value is:

          * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
          stored in your account and is managed by AWS KMS (AWS KMS charges apply).

        - **KMSMasterKeyArn** *(string) --*

          The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientCreateTableSSESpecificationTypeDef = TypedDict(
    "_ClientCreateTableSSESpecificationTypeDef",
    {"Enabled": bool, "SSEType": str, "KMSMasterKeyId": str},
    total=False,
)


class ClientCreateTableSSESpecificationTypeDef(
    _ClientCreateTableSSESpecificationTypeDef
):
    """
    Type definition for `ClientCreateTable` `SSESpecification`

    Represents the settings used to enable server-side encryption.

    - **Enabled** *(boolean) --*

      Indicates whether server-side encryption is done using an AWS managed CMK or an AWS owned CMK.
      If enabled (true), server-side encryption type is set to ``KMS`` and an AWS managed CMK is used
      (AWS KMS charges apply). If disabled (false) or not specified, server-side encryption is set to
      AWS owned CMK.

    - **SSEType** *(string) --*

      Server-side encryption type. The only supported value is:

      * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is stored in
      your account and is managed by AWS KMS (AWS KMS charges apply).

    - **KMSMasterKeyId** *(string) --*

      The AWS KMS customer master key (CMK) that should be used for the AWS KMS encryption. To
      specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that
      you should only provide this parameter if the key is different from the default DynamoDB
      customer master key alias/aws/dynamodb.
    """


_RequiredClientCreateTableStreamSpecificationTypeDef = TypedDict(
    "_RequiredClientCreateTableStreamSpecificationTypeDef", {"StreamEnabled": bool}
)
_OptionalClientCreateTableStreamSpecificationTypeDef = TypedDict(
    "_OptionalClientCreateTableStreamSpecificationTypeDef",
    {"StreamViewType": str},
    total=False,
)


class ClientCreateTableStreamSpecificationTypeDef(
    _RequiredClientCreateTableStreamSpecificationTypeDef,
    _OptionalClientCreateTableStreamSpecificationTypeDef,
):
    """
    Type definition for `ClientCreateTable` `StreamSpecification`

    The settings for DynamoDB Streams on the table. These settings consist of:

    * ``StreamEnabled`` - Indicates whether DynamoDB Streams is to be enabled (true) or disabled
    (false).

    * ``StreamViewType`` - When an item in the table is modified, ``StreamViewType`` determines what
    information is written to the table's stream. Valid values for ``StreamViewType`` are:

      * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

      * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
      stream.

      * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to the
      stream.

      * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written to the
      stream.

    - **StreamEnabled** *(boolean) --* **[REQUIRED]**

      Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

    - **StreamViewType** *(string) --*

      When an item in the table is modified, ``StreamViewType`` determines what information is
      written to the stream for this table. Valid values for ``StreamViewType`` are:

      * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

      * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
      stream.

      * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to the
      stream.

      * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written to the
      stream.
    """


_ClientCreateTableTagsTypeDef = TypedDict(
    "_ClientCreateTableTagsTypeDef", {"Key": str, "Value": str}
)


class ClientCreateTableTagsTypeDef(_ClientCreateTableTagsTypeDef):
    """
    Type definition for `ClientCreateTable` `Tags`

    Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single DynamoDB
    table.

    AWS-assigned tag names and values are automatically assigned the ``aws:`` prefix, which the
    user cannot assign. AWS-assigned tag names do not count towards the tag limit of 50.
    User-assigned tag names have the prefix ``user:`` in the Cost Allocation Report. You cannot
    backdate the application of a tag.

    For an overview on tagging DynamoDB resources, see `Tagging for DynamoDB
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html>`__ in the
    *Amazon DynamoDB Developer Guide* .

    - **Key** *(string) --* **[REQUIRED]**

      The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one
      tag with the same key. If you try to add an existing tag (same key), the existing tag value
      will be updated to the new value.

    - **Value** *(string) --* **[REQUIRED]**

      The value of the tag. Tag values are case-sensitive and can be null.
    """


_ClientDeleteBackupResponseBackupDescriptionBackupDetailsTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionBackupDetailsTypeDef",
    {
        "BackupArn": str,
        "BackupName": str,
        "BackupSizeBytes": int,
        "BackupStatus": str,
        "BackupType": str,
        "BackupCreationDateTime": datetime,
        "BackupExpiryDateTime": datetime,
    },
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionBackupDetailsTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionBackupDetailsTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescription` `BackupDetails`

    Contains the details of the backup created for the table.

    - **BackupArn** *(string) --*

      ARN associated with the backup.

    - **BackupName** *(string) --*

      Name of the requested backup.

    - **BackupSizeBytes** *(integer) --*

      Size of the backup in bytes.

    - **BackupStatus** *(string) --*

      Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

    - **BackupType** *(string) --*

      BackupType:

      * ``USER`` - You create and manage these using the on-demand backup feature.

      * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
      backup is automatically created and is retained for 35 days (at no additional cost).
      System backups allow you to restore the deleted table to the state it was in just before
      the point of deletion.

      * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

    - **BackupCreationDateTime** *(datetime) --*

      Time at which the backup was created. This is the request time of the backup.

    - **BackupExpiryDateTime** *(datetime) --*

      Time at which the automatic on-demand backup created by DynamoDB will expire. This
      ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableDetails` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
    partition key). A composite primary key would require one ``KeySchemaElement`` for the
    partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
    The data type must be one of String, Number, or Binary. The attribute cannot be nested
    within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef",
    {"ReadCapacityUnits": int, "WriteCapacityUnits": int},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableDetails` `ProvisionedThroughput`

    Read IOPs and Write IOPS on the table when the backup was created.

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . For more information, see `Specifying Read and
      Write Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write
      Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsTypeDef",
    {
        "TableName": str,
        "TableId": str,
        "TableArn": str,
        "TableSizeBytes": int,
        "KeySchema": List[
            ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef
        ],
        "TableCreationDateTime": datetime,
        "ProvisionedThroughput": ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef,
        "ItemCount": int,
        "BillingMode": str,
    },
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescription` `SourceTableDetails`

    Contains the details of the table when the backup was created.

    - **TableName** *(string) --*

      The name of the table for which the backup was created.

    - **TableId** *(string) --*

      Unique identifier for the table for which the backup was created.

    - **TableArn** *(string) --*

      ARN of the table for which backup was created.

    - **TableSizeBytes** *(integer) --*

      Size of the table in bytes. Note that this is an approximate value.

    - **KeySchema** *(list) --*

      Schema of the table.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
        partition key). A composite primary key would require one ``KeySchemaElement`` for the
        partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
        The data type must be one of String, Number, or Binary. The attribute cannot be nested
        within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **TableCreationDateTime** *(datetime) --*

      Time when the source table was created.

    - **ProvisionedThroughput** *(dict) --*

      Read IOPs and Write IOPS on the table when the backup was created.

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . For more information, see `Specifying Read and
        Write Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` . For more information, see `Specifying Read and Write
        Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **ItemCount** *(integer) --*

      Number of items in the table. Note that this is an approximate value.

    - **BillingMode** *(string) --*

      Controls how you are charged for read and write throughput and how you manage capacity.
      This setting can be changed later.

      * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
      using ``PROVISIONED`` for predictable workloads.

      * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
      recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the
    attributes that make up the primary key of a table, or the key attributes of an
    index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term
        "range attribute" derives from the way DynamoDB stores items with the same
        partition key physically close together, in sorted order by the sort key value.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index.
      The list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    {"ReadCapacityUnits": int, "WriteCapacityUnits": int},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexes` `ProvisionedThroughput`

    Represents the provisioned throughput settings for the specified global secondary
    index.

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . For more information, see `Specifying Read and
      Write Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write
      Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef,
        "ProvisionedThroughput": ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef,
    },
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetails` `GlobalSecondaryIndexes`

    Represents the properties of a global secondary index for the table when the backup was
    created.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for a global secondary index, which consists of one or more
      pairs of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the
        attributes that make up the primary key of a table, or the key attributes of an
        index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term
            "range attribute" derives from the way DynamoDB stores items with the same
            partition key physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index.
        The list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **ProvisionedThroughput** *(dict) --*

      Represents the provisioned throughput settings for the specified global secondary
      index.

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . For more information, see `Specifying Read and
        Write Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` . For more information, see `Specifying Read and Write
        Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the
    attributes that make up the primary key of a table, or the key attributes of an
    index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term
        "range attribute" derives from the way DynamoDB stores items with the same
        partition key physically close together, in sorted order by the sort key value.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index.
      The list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef,
    },
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetails` `LocalSecondaryIndexes`

    Represents the properties of a local secondary index for the table when the backup was
    created.

    - **IndexName** *(string) --*

      Represents the name of the local secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for a local secondary index, which consists of one or more
      pairs of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the
        attributes that make up the primary key of a table, or the key attributes of an
        index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term
            "range attribute" derives from the way DynamoDB stores items with the same
            partition key physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index.
        The list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef",
    {"Status": str, "SSEType": str, "KMSMasterKeyArn": str},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetails` `SSEDescription`

    The description of the server-side encryption status on the table when the backup was
    created.

    - **Status** *(string) --*

      Represents the current state of server-side encryption. The only supported values are:

      * ``ENABLED`` - Server-side encryption is enabled.

      * ``UPDATING`` - Server-side encryption is being updated.

    - **SSEType** *(string) --*

      Server-side encryption type. The only supported value is:

      * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
      stored in your account and is managed by AWS KMS (AWS KMS charges apply).

    - **KMSMasterKeyArn** *(string) --*

      The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef",
    {"StreamEnabled": bool, "StreamViewType": str},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetails` `StreamDescription`

    Stream settings on the table when the backup was created.

    - **StreamEnabled** *(boolean) --*

      Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

    - **StreamViewType** *(string) --*

      When an item in the table is modified, ``StreamViewType`` determines what information
      is written to the stream for this table. Valid values for ``StreamViewType`` are:

      * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
      stream.

      * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
      the stream.

      * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
      the stream.

      * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
      to the stream.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef",
    {"TimeToLiveStatus": str, "AttributeName": str},
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetails` `TimeToLiveDescription`

    Time to Live settings on the table when the backup was created.

    - **TimeToLiveStatus** *(string) --*

      The TTL status for the table.

    - **AttributeName** *(string) --*

      The name of the TTL attribute for items in the table.
    """


_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef",
    {
        "LocalSecondaryIndexes": List[
            ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": List[
            ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef
        ],
        "StreamDescription": ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef,
        "TimeToLiveDescription": ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef,
        "SSEDescription": ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef,
    },
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponseBackupDescription` `SourceTableFeatureDetails`

    Contains the details of the features enabled on the table when the backup was created. For
    example, LSIs, GSIs, streams, TTL.

    - **LocalSecondaryIndexes** *(list) --*

      Represents the LSI properties for the table when the backup was created. It includes the
      IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.

      - *(dict) --*

        Represents the properties of a local secondary index for the table when the backup was
        created.

        - **IndexName** *(string) --*

          Represents the name of the local secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for a local secondary index, which consists of one or more
          pairs of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the
            attributes that make up the primary key of a table, or the key attributes of an
            index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term
                "range attribute" derives from the way DynamoDB stores items with the same
                partition key physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index.
            The list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

    - **GlobalSecondaryIndexes** *(list) --*

      Represents the GSI properties for the table when the backup was created. It includes the
      IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at
      the time of backup.

      - *(dict) --*

        Represents the properties of a global secondary index for the table when the backup was
        created.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for a global secondary index, which consists of one or more
          pairs of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the
            attributes that make up the primary key of a table, or the key attributes of an
            index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term
                "range attribute" derives from the way DynamoDB stores items with the same
                partition key physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index.
            The list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **ProvisionedThroughput** *(dict) --*

          Represents the provisioned throughput settings for the specified global secondary
          index.

          - **ReadCapacityUnits** *(integer) --*

            The maximum number of strongly consistent reads consumed per second before DynamoDB
            returns a ``ThrottlingException`` . For more information, see `Specifying Read and
            Write Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

          - **WriteCapacityUnits** *(integer) --*

            The maximum number of writes consumed per second before DynamoDB returns a
            ``ThrottlingException`` . For more information, see `Specifying Read and Write
            Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **StreamDescription** *(dict) --*

      Stream settings on the table when the backup was created.

      - **StreamEnabled** *(boolean) --*

        Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

      - **StreamViewType** *(string) --*

        When an item in the table is modified, ``StreamViewType`` determines what information
        is written to the stream for this table. Valid values for ``StreamViewType`` are:

        * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
        stream.

        * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
        the stream.

        * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
        the stream.

        * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
        to the stream.

    - **TimeToLiveDescription** *(dict) --*

      Time to Live settings on the table when the backup was created.

      - **TimeToLiveStatus** *(string) --*

        The TTL status for the table.

      - **AttributeName** *(string) --*

        The name of the TTL attribute for items in the table.

    - **SSEDescription** *(dict) --*

      The description of the server-side encryption status on the table when the backup was
      created.

      - **Status** *(string) --*

        Represents the current state of server-side encryption. The only supported values are:

        * ``ENABLED`` - Server-side encryption is enabled.

        * ``UPDATING`` - Server-side encryption is being updated.

      - **SSEType** *(string) --*

        Server-side encryption type. The only supported value is:

        * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
        stored in your account and is managed by AWS KMS (AWS KMS charges apply).

      - **KMSMasterKeyArn** *(string) --*

        The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDeleteBackupResponseBackupDescriptionTypeDef = TypedDict(
    "_ClientDeleteBackupResponseBackupDescriptionTypeDef",
    {
        "BackupDetails": ClientDeleteBackupResponseBackupDescriptionBackupDetailsTypeDef,
        "SourceTableDetails": ClientDeleteBackupResponseBackupDescriptionSourceTableDetailsTypeDef,
        "SourceTableFeatureDetails": ClientDeleteBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef,
    },
    total=False,
)


class ClientDeleteBackupResponseBackupDescriptionTypeDef(
    _ClientDeleteBackupResponseBackupDescriptionTypeDef
):
    """
    Type definition for `ClientDeleteBackupResponse` `BackupDescription`

    Contains the description of the backup created for the table.

    - **BackupDetails** *(dict) --*

      Contains the details of the backup created for the table.

      - **BackupArn** *(string) --*

        ARN associated with the backup.

      - **BackupName** *(string) --*

        Name of the requested backup.

      - **BackupSizeBytes** *(integer) --*

        Size of the backup in bytes.

      - **BackupStatus** *(string) --*

        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

      - **BackupType** *(string) --*

        BackupType:

        * ``USER`` - You create and manage these using the on-demand backup feature.

        * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
        backup is automatically created and is retained for 35 days (at no additional cost).
        System backups allow you to restore the deleted table to the state it was in just before
        the point of deletion.

        * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

      - **BackupCreationDateTime** *(datetime) --*

        Time at which the backup was created. This is the request time of the backup.

      - **BackupExpiryDateTime** *(datetime) --*

        Time at which the automatic on-demand backup created by DynamoDB will expire. This
        ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.

    - **SourceTableDetails** *(dict) --*

      Contains the details of the table when the backup was created.

      - **TableName** *(string) --*

        The name of the table for which the backup was created.

      - **TableId** *(string) --*

        Unique identifier for the table for which the backup was created.

      - **TableArn** *(string) --*

        ARN of the table for which backup was created.

      - **TableSizeBytes** *(integer) --*

        Size of the table in bytes. Note that this is an approximate value.

      - **KeySchema** *(list) --*

        Schema of the table.

        - *(dict) --*

          Represents *a single element* of a key schema. A key schema specifies the attributes
          that make up the primary key of a table, or the key attributes of an index.

          A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
          example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
          partition key). A composite primary key would require one ``KeySchemaElement`` for the
          partition key, and another ``KeySchemaElement`` for the sort key.

          A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
          The data type must be one of String, Number, or Binary. The attribute cannot be nested
          within a List or a Map.

          - **AttributeName** *(string) --*

            The name of a key attribute.

          - **KeyType** *(string) --*

            The role that this key attribute will assume:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

      - **TableCreationDateTime** *(datetime) --*

        Time when the source table was created.

      - **ProvisionedThroughput** *(dict) --*

        Read IOPs and Write IOPS on the table when the backup was created.

        - **ReadCapacityUnits** *(integer) --*

          The maximum number of strongly consistent reads consumed per second before DynamoDB
          returns a ``ThrottlingException`` . For more information, see `Specifying Read and
          Write Requirements
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
          in the *Amazon DynamoDB Developer Guide* .

          If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

        - **WriteCapacityUnits** *(integer) --*

          The maximum number of writes consumed per second before DynamoDB returns a
          ``ThrottlingException`` . For more information, see `Specifying Read and Write
          Requirements
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
          in the *Amazon DynamoDB Developer Guide* .

          If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **ItemCount** *(integer) --*

        Number of items in the table. Note that this is an approximate value.

      - **BillingMode** *(string) --*

        Controls how you are charged for read and write throughput and how you manage capacity.
        This setting can be changed later.

        * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
        using ``PROVISIONED`` for predictable workloads.

        * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
        recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

    - **SourceTableFeatureDetails** *(dict) --*

      Contains the details of the features enabled on the table when the backup was created. For
      example, LSIs, GSIs, streams, TTL.

      - **LocalSecondaryIndexes** *(list) --*

        Represents the LSI properties for the table when the backup was created. It includes the
        IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.

        - *(dict) --*

          Represents the properties of a local secondary index for the table when the backup was
          created.

          - **IndexName** *(string) --*

            Represents the name of the local secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for a local secondary index, which consists of one or more
            pairs of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the
              attributes that make up the primary key of a table, or the key attributes of an
              index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term
                  "range attribute" derives from the way DynamoDB stores items with the same
                  partition key physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index.
              The list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

      - **GlobalSecondaryIndexes** *(list) --*

        Represents the GSI properties for the table when the backup was created. It includes the
        IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at
        the time of backup.

        - *(dict) --*

          Represents the properties of a global secondary index for the table when the backup was
          created.

          - **IndexName** *(string) --*

            The name of the global secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for a global secondary index, which consists of one or more
            pairs of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the
              attributes that make up the primary key of a table, or the key attributes of an
              index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term
                  "range attribute" derives from the way DynamoDB stores items with the same
                  partition key physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index.
              The list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **ProvisionedThroughput** *(dict) --*

            Represents the provisioned throughput settings for the specified global secondary
            index.

            - **ReadCapacityUnits** *(integer) --*

              The maximum number of strongly consistent reads consumed per second before DynamoDB
              returns a ``ThrottlingException`` . For more information, see `Specifying Read and
              Write Requirements
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
              in the *Amazon DynamoDB Developer Guide* .

              If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

            - **WriteCapacityUnits** *(integer) --*

              The maximum number of writes consumed per second before DynamoDB returns a
              ``ThrottlingException`` . For more information, see `Specifying Read and Write
              Requirements
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
              in the *Amazon DynamoDB Developer Guide* .

              If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **StreamDescription** *(dict) --*

        Stream settings on the table when the backup was created.

        - **StreamEnabled** *(boolean) --*

          Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

        - **StreamViewType** *(string) --*

          When an item in the table is modified, ``StreamViewType`` determines what information
          is written to the stream for this table. Valid values for ``StreamViewType`` are:

          * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
          stream.

          * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
          the stream.

          * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
          the stream.

          * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
          to the stream.

      - **TimeToLiveDescription** *(dict) --*

        Time to Live settings on the table when the backup was created.

        - **TimeToLiveStatus** *(string) --*

          The TTL status for the table.

        - **AttributeName** *(string) --*

          The name of the TTL attribute for items in the table.

      - **SSEDescription** *(dict) --*

        The description of the server-side encryption status on the table when the backup was
        created.

        - **Status** *(string) --*

          Represents the current state of server-side encryption. The only supported values are:

          * ``ENABLED`` - Server-side encryption is enabled.

          * ``UPDATING`` - Server-side encryption is being updated.

        - **SSEType** *(string) --*

          Server-side encryption type. The only supported value is:

          * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
          stored in your account and is managed by AWS KMS (AWS KMS charges apply).

        - **KMSMasterKeyArn** *(string) --*

          The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDeleteBackupResponseTypeDef = TypedDict(
    "_ClientDeleteBackupResponseTypeDef",
    {"BackupDescription": ClientDeleteBackupResponseBackupDescriptionTypeDef},
    total=False,
)


class ClientDeleteBackupResponseTypeDef(_ClientDeleteBackupResponseTypeDef):
    """
    Type definition for `ClientDeleteBackup` `Response`

    - **BackupDescription** *(dict) --*

      Contains the description of the backup created for the table.

      - **BackupDetails** *(dict) --*

        Contains the details of the backup created for the table.

        - **BackupArn** *(string) --*

          ARN associated with the backup.

        - **BackupName** *(string) --*

          Name of the requested backup.

        - **BackupSizeBytes** *(integer) --*

          Size of the backup in bytes.

        - **BackupStatus** *(string) --*

          Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

        - **BackupType** *(string) --*

          BackupType:

          * ``USER`` - You create and manage these using the on-demand backup feature.

          * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
          backup is automatically created and is retained for 35 days (at no additional cost).
          System backups allow you to restore the deleted table to the state it was in just before
          the point of deletion.

          * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

        - **BackupCreationDateTime** *(datetime) --*

          Time at which the backup was created. This is the request time of the backup.

        - **BackupExpiryDateTime** *(datetime) --*

          Time at which the automatic on-demand backup created by DynamoDB will expire. This
          ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.

      - **SourceTableDetails** *(dict) --*

        Contains the details of the table when the backup was created.

        - **TableName** *(string) --*

          The name of the table for which the backup was created.

        - **TableId** *(string) --*

          Unique identifier for the table for which the backup was created.

        - **TableArn** *(string) --*

          ARN of the table for which backup was created.

        - **TableSizeBytes** *(integer) --*

          Size of the table in bytes. Note that this is an approximate value.

        - **KeySchema** *(list) --*

          Schema of the table.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
            partition key). A composite primary key would require one ``KeySchemaElement`` for the
            partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
            The data type must be one of String, Number, or Binary. The attribute cannot be nested
            within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term "hash
                attribute" derives from DynamoDB's usage of an internal hash function to evenly
                distribute data items across partitions, based on their partition key values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **TableCreationDateTime** *(datetime) --*

          Time when the source table was created.

        - **ProvisionedThroughput** *(dict) --*

          Read IOPs and Write IOPS on the table when the backup was created.

          - **ReadCapacityUnits** *(integer) --*

            The maximum number of strongly consistent reads consumed per second before DynamoDB
            returns a ``ThrottlingException`` . For more information, see `Specifying Read and
            Write Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

          - **WriteCapacityUnits** *(integer) --*

            The maximum number of writes consumed per second before DynamoDB returns a
            ``ThrottlingException`` . For more information, see `Specifying Read and Write
            Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

        - **ItemCount** *(integer) --*

          Number of items in the table. Note that this is an approximate value.

        - **BillingMode** *(string) --*

          Controls how you are charged for read and write throughput and how you manage capacity.
          This setting can be changed later.

          * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
          using ``PROVISIONED`` for predictable workloads.

          * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
          recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

      - **SourceTableFeatureDetails** *(dict) --*

        Contains the details of the features enabled on the table when the backup was created. For
        example, LSIs, GSIs, streams, TTL.

        - **LocalSecondaryIndexes** *(list) --*

          Represents the LSI properties for the table when the backup was created. It includes the
          IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.

          - *(dict) --*

            Represents the properties of a local secondary index for the table when the backup was
            created.

            - **IndexName** *(string) --*

              Represents the name of the local secondary index.

            - **KeySchema** *(list) --*

              The complete key schema for a local secondary index, which consists of one or more
              pairs of attribute names and key types:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term "hash
                attribute" derives from DynamoDB's usage of an internal hash function to evenly
                distribute data items across partitions, based on their partition key values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

              - *(dict) --*

                Represents *a single element* of a key schema. A key schema specifies the
                attributes that make up the primary key of a table, or the key attributes of an
                index.

                A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
                example, a simple primary key would be represented by one ``KeySchemaElement`` (for
                the partition key). A composite primary key would require one ``KeySchemaElement``
                for the partition key, and another ``KeySchemaElement`` for the sort key.

                A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
                attribute). The data type must be one of String, Number, or Binary. The attribute
                cannot be nested within a List or a Map.

                - **AttributeName** *(string) --*

                  The name of a key attribute.

                - **KeyType** *(string) --*

                  The role that this key attribute will assume:

                  * ``HASH`` - partition key

                  * ``RANGE`` - sort key

                  .. note::

                    The partition key of an item is also known as its *hash attribute* . The term
                    "hash attribute" derives from DynamoDB's usage of an internal hash function to
                    evenly distribute data items across partitions, based on their partition key
                    values.

                    The sort key of an item is also known as its *range attribute* . The term
                    "range attribute" derives from the way DynamoDB stores items with the same
                    partition key physically close together, in sorted order by the sort key value.

            - **Projection** *(dict) --*

              Represents attributes that are copied (projected) from the table into the global
              secondary index. These are in addition to the primary key attributes and index key
              attributes, which are automatically projected.

              - **ProjectionType** *(string) --*

                The set of attributes that are projected into the index:

                * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

                * ``INCLUDE`` - Only the specified table attributes are projected into the index.
                The list of projected attributes is in ``NonKeyAttributes`` .

                * ``ALL`` - All of the table attributes are projected into the index.

              - **NonKeyAttributes** *(list) --*

                Represents the non-key attribute names which will be projected into the index.

                For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
                all of the local secondary indexes, must not exceed 20. If you project the same
                attribute into two different indexes, this counts as two distinct attributes when
                determining the total.

                - *(string) --*

        - **GlobalSecondaryIndexes** *(list) --*

          Represents the GSI properties for the table when the backup was created. It includes the
          IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at
          the time of backup.

          - *(dict) --*

            Represents the properties of a global secondary index for the table when the backup was
            created.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **KeySchema** *(list) --*

              The complete key schema for a global secondary index, which consists of one or more
              pairs of attribute names and key types:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term "hash
                attribute" derives from DynamoDB's usage of an internal hash function to evenly
                distribute data items across partitions, based on their partition key values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

              - *(dict) --*

                Represents *a single element* of a key schema. A key schema specifies the
                attributes that make up the primary key of a table, or the key attributes of an
                index.

                A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
                example, a simple primary key would be represented by one ``KeySchemaElement`` (for
                the partition key). A composite primary key would require one ``KeySchemaElement``
                for the partition key, and another ``KeySchemaElement`` for the sort key.

                A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
                attribute). The data type must be one of String, Number, or Binary. The attribute
                cannot be nested within a List or a Map.

                - **AttributeName** *(string) --*

                  The name of a key attribute.

                - **KeyType** *(string) --*

                  The role that this key attribute will assume:

                  * ``HASH`` - partition key

                  * ``RANGE`` - sort key

                  .. note::

                    The partition key of an item is also known as its *hash attribute* . The term
                    "hash attribute" derives from DynamoDB's usage of an internal hash function to
                    evenly distribute data items across partitions, based on their partition key
                    values.

                    The sort key of an item is also known as its *range attribute* . The term
                    "range attribute" derives from the way DynamoDB stores items with the same
                    partition key physically close together, in sorted order by the sort key value.

            - **Projection** *(dict) --*

              Represents attributes that are copied (projected) from the table into the global
              secondary index. These are in addition to the primary key attributes and index key
              attributes, which are automatically projected.

              - **ProjectionType** *(string) --*

                The set of attributes that are projected into the index:

                * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

                * ``INCLUDE`` - Only the specified table attributes are projected into the index.
                The list of projected attributes is in ``NonKeyAttributes`` .

                * ``ALL`` - All of the table attributes are projected into the index.

              - **NonKeyAttributes** *(list) --*

                Represents the non-key attribute names which will be projected into the index.

                For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
                all of the local secondary indexes, must not exceed 20. If you project the same
                attribute into two different indexes, this counts as two distinct attributes when
                determining the total.

                - *(string) --*

            - **ProvisionedThroughput** *(dict) --*

              Represents the provisioned throughput settings for the specified global secondary
              index.

              - **ReadCapacityUnits** *(integer) --*

                The maximum number of strongly consistent reads consumed per second before DynamoDB
                returns a ``ThrottlingException`` . For more information, see `Specifying Read and
                Write Requirements
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
                in the *Amazon DynamoDB Developer Guide* .

                If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

              - **WriteCapacityUnits** *(integer) --*

                The maximum number of writes consumed per second before DynamoDB returns a
                ``ThrottlingException`` . For more information, see `Specifying Read and Write
                Requirements
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
                in the *Amazon DynamoDB Developer Guide* .

                If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

        - **StreamDescription** *(dict) --*

          Stream settings on the table when the backup was created.

          - **StreamEnabled** *(boolean) --*

            Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

          - **StreamViewType** *(string) --*

            When an item in the table is modified, ``StreamViewType`` determines what information
            is written to the stream for this table. Valid values for ``StreamViewType`` are:

            * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
            stream.

            * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
            the stream.

            * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
            the stream.

            * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
            to the stream.

        - **TimeToLiveDescription** *(dict) --*

          Time to Live settings on the table when the backup was created.

          - **TimeToLiveStatus** *(string) --*

            The TTL status for the table.

          - **AttributeName** *(string) --*

            The name of the TTL attribute for items in the table.

        - **SSEDescription** *(dict) --*

          The description of the server-side encryption status on the table when the backup was
          created.

          - **Status** *(string) --*

            Represents the current state of server-side encryption. The only supported values are:

            * ``ENABLED`` - Server-side encryption is enabled.

            * ``UPDATING`` - Server-side encryption is being updated.

          - **SSEType** *(string) --*

            Server-side encryption type. The only supported value is:

            * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
            stored in your account and is managed by AWS KMS (AWS KMS charges apply).

          - **KMSMasterKeyArn** *(string) --*

            The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDeleteItemExpectedAttributeValueListTypeDef = TypedDict(
    "_ClientDeleteItemExpectedAttributeValueListTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientDeleteItemExpectedAttributeValueListTypeDef(
    _ClientDeleteItemExpectedAttributeValueListTypeDef
):
    """
    Type definition for `ClientDeleteItemExpected` `AttributeValueList`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and
    the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type,
        and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientDeleteItemExpectedValueTypeDef = TypedDict(
    "_ClientDeleteItemExpectedValueTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientDeleteItemExpectedValueTypeDef(_ClientDeleteItemExpectedValueTypeDef):
    """
    Type definition for `ClientDeleteItemExpected` `Value`

    Represents the data for the expected attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and the
    value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type, and
        the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientDeleteItemExpectedTypeDef = TypedDict(
    "_ClientDeleteItemExpectedTypeDef",
    {
        "Value": ClientDeleteItemExpectedValueTypeDef,
        "Exists": bool,
        "ComparisonOperator": str,
        "AttributeValueList": List[ClientDeleteItemExpectedAttributeValueListTypeDef],
    },
    total=False,
)


class ClientDeleteItemExpectedTypeDef(_ClientDeleteItemExpectedTypeDef):
    """
    Type definition for `ClientDeleteItem` `Expected`

    Represents a condition to be compared with an attribute value. This condition can be used
    with ``DeleteItem`` , ``PutItem`` , or ``UpdateItem`` operations; if the comparison evaluates
    to true, the operation succeeds; if not, the operation fails. You can use
    ``ExpectedAttributeValue`` in one of two different ways:

    * Use ``AttributeValueList`` to specify one or more values to compare against an attribute.
    Use ``ComparisonOperator`` to specify how you want to perform the comparison. If the
    comparison evaluates to true, then the conditional operation succeeds.

    * Use ``Value`` to specify a value that DynamoDB will compare against an attribute. If the
    values match, then ``ExpectedAttributeValue`` evaluates to true and the conditional operation
    succeeds. Optionally, you can also set ``Exists`` to false, indicating that you *do not*
    expect to find the attribute value in the table. In this case, the conditional operation
    succeeds only if the comparison evaluates to false.

     ``Value`` and ``Exists`` are incompatible with ``AttributeValueList`` and
     ``ComparisonOperator`` . Note that if you use both sets of parameters at once, DynamoDB will
     return a ``ValidationException`` exception.

    - **Value** *(dict) --*

      Represents the data for the expected attribute.

      Each attribute value is described as a name-value pair. The name is the data type, and the
      value is the data itself.

      For more information, see `Data Types
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
      in the *Amazon DynamoDB Developer Guide* .

      - **S** *(string) --*

        An attribute of type String. For example:

         ``"S": "Hello"``

      - **N** *(string) --*

        An attribute of type Number. For example:

         ``"N": "123.45"``

        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
        across languages and libraries. However, DynamoDB treats them as number type attributes
        for mathematical operations.

      - **B** *(bytes) --*

        An attribute of type Binary. For example:

         ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

      - **SS** *(list) --*

        An attribute of type String Set. For example:

         ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

        - *(string) --*

      - **NS** *(list) --*

        An attribute of type Number Set. For example:

         ``"NS": ["42.2", "-19", "7.5", "3.14"]``

        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
        across languages and libraries. However, DynamoDB treats them as number type attributes
        for mathematical operations.

        - *(string) --*

      - **BS** *(list) --*

        An attribute of type Binary Set. For example:

         ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

        - *(bytes) --*

      - **M** *(dict) --*

        An attribute of type Map. For example:

         ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data type,
            and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

      - **L** *(list) --*

        An attribute of type List. For example:

         ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

      - **NULL** *(boolean) --*

        An attribute of type Null. For example:

         ``"NULL": true``

      - **BOOL** *(boolean) --*

        An attribute of type Boolean. For example:

         ``"BOOL": true``

    - **Exists** *(boolean) --*

      Causes DynamoDB to evaluate the value before attempting a conditional operation:

      * If ``Exists`` is ``true`` , DynamoDB will check to see if that attribute value already
      exists in the table. If it is found, then the operation succeeds. If it is not found, the
      operation fails with a ``ConditionCheckFailedException`` .

      * If ``Exists`` is ``false`` , DynamoDB assumes that the attribute value does not exist in
      the table. If in fact the value does not exist, then the assumption is valid and the
      operation succeeds. If the value is found, despite the assumption that it does not exist,
      the operation fails with a ``ConditionCheckFailedException`` .

      The default setting for ``Exists`` is ``true`` . If you supply a ``Value`` all by itself,
      DynamoDB assumes the attribute exists: You don't have to set ``Exists`` to ``true`` ,
      because it is implied.

      DynamoDB returns a ``ValidationException`` if:

      * ``Exists`` is ``true`` but there is no ``Value`` to check. (You expect a value to exist,
      but don't specify what that value is.)

      * ``Exists`` is ``false`` but you also provide a ``Value`` . (You cannot expect an
      attribute to have a value, while also expecting it not to exist.)

    - **ComparisonOperator** *(string) --*

      A comparator for evaluating attributes in the ``AttributeValueList`` . For example, equals,
      greater than, less than, etc.

      The following comparison operators are available:

       ``EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS | BEGINS_WITH |
       IN | BETWEEN``

      The following are descriptions of each comparison operator.

      * ``EQ`` : Equal. ``EQ`` is supported for all data types, including lists and maps.
      ``AttributeValueList`` can contain only one ``AttributeValue`` element of type String,
      Number, Binary, String Set, Number Set, or Binary Set. If an item contains an
      ``AttributeValue`` element of a different type than the one provided in the request, the
      value does not match. For example, ``{"S":"6"}`` does not equal ``{"N":"6"}`` . Also,
      ``{"N":"6"}`` does not equal ``{"NS":["6", "2", "1"]}`` .

      * ``NE`` : Not equal. ``NE`` is supported for all data types, including lists and maps.
      ``AttributeValueList`` can contain only one ``AttributeValue`` of type String, Number,
      Binary, String Set, Number Set, or Binary Set. If an item contains an ``AttributeValue`` of
      a different type than the one provided in the request, the value does not match. For
      example, ``{"S":"6"}`` does not equal ``{"N":"6"}`` . Also, ``{"N":"6"}`` does not equal
      ``{"NS":["6", "2", "1"]}`` .

      * ``LE`` : Less than or equal.   ``AttributeValueList`` can contain only one
      ``AttributeValue`` element of type String, Number, or Binary (not a set type). If an item
      contains an ``AttributeValue`` element of a different type than the one provided in the
      request, the value does not match. For example, ``{"S":"6"}`` does not equal ``{"N":"6"}``
      . Also, ``{"N":"6"}`` does not compare to ``{"NS":["6", "2", "1"]}`` .

      * ``LT`` : Less than.   ``AttributeValueList`` can contain only one ``AttributeValue`` of
      type String, Number, or Binary (not a set type). If an item contains an ``AttributeValue``
      element of a different type than the one provided in the request, the value does not match.
      For example, ``{"S":"6"}`` does not equal ``{"N":"6"}`` . Also, ``{"N":"6"}`` does not
      compare to ``{"NS":["6", "2", "1"]}`` .

      * ``GE`` : Greater than or equal.   ``AttributeValueList`` can contain only one
      ``AttributeValue`` element of type String, Number, or Binary (not a set type). If an item
      contains an ``AttributeValue`` element of a different type than the one provided in the
      request, the value does not match. For example, ``{"S":"6"}`` does not equal ``{"N":"6"}``
      . Also, ``{"N":"6"}`` does not compare to ``{"NS":["6", "2", "1"]}`` .

      * ``GT`` : Greater than.   ``AttributeValueList`` can contain only one ``AttributeValue``
      element of type String, Number, or Binary (not a set type). If an item contains an
      ``AttributeValue`` element of a different type than the one provided in the request, the
      value does not match. For example, ``{"S":"6"}`` does not equal ``{"N":"6"}`` . Also,
      ``{"N":"6"}`` does not compare to ``{"NS":["6", "2", "1"]}`` .

      * ``NOT_NULL`` : The attribute exists. ``NOT_NULL`` is supported for all data types,
      including lists and maps.

      .. note::

         This operator tests for the existence of an attribute, not its data type. If the data
         type of attribute "``a`` " is null, and you evaluate it using ``NOT_NULL`` , the result
         is a Boolean ``true`` . This result is because the attribute "``a`` " exists; its data
         type is not relevant to the ``NOT_NULL`` comparison operator.

      * ``NULL`` : The attribute does not exist. ``NULL`` is supported for all data types,
      including lists and maps.

      .. note::

         This operator tests for the nonexistence of an attribute, not its data type. If the data
         type of attribute "``a`` " is null, and you evaluate it using ``NULL`` , the result is a
         Boolean ``false`` . This is because the attribute "``a`` " exists; its data type is not
         relevant to the ``NULL`` comparison operator.

      * ``CONTAINS`` : Checks for a subsequence, or value in a set.  ``AttributeValueList`` can
      contain only one ``AttributeValue`` element of type String, Number, or Binary (not a set
      type). If the target attribute of the comparison is of type String, then the operator
      checks for a substring match. If the target attribute of the comparison is of type Binary,
      then the operator looks for a subsequence of the target that matches the input. If the
      target attribute of the comparison is a set ("``SS`` ", "``NS`` ", or "``BS`` "), then the
      operator evaluates to true if it finds an exact match with any member of the set. CONTAINS
      is supported for lists: When evaluating "``a CONTAINS b`` ", "``a`` " can be a list;
      however, "``b`` " cannot be a set, a map, or a list.

      * ``NOT_CONTAINS`` : Checks for absence of a subsequence, or absence of a value in a set.
      ``AttributeValueList`` can contain only one ``AttributeValue`` element of type String,
      Number, or Binary (not a set type). If the target attribute of the comparison is a String,
      then the operator checks for the absence of a substring match. If the target attribute of
      the comparison is Binary, then the operator checks for the absence of a subsequence of the
      target that matches the input. If the target attribute of the comparison is a set ("``SS``
      ", "``NS`` ", or "``BS`` "), then the operator evaluates to true if it *does not* find an
      exact match with any member of the set. NOT_CONTAINS is supported for lists: When
      evaluating "``a NOT CONTAINS b`` ", "``a`` " can be a list; however, "``b`` " cannot be a
      set, a map, or a list.

      * ``BEGINS_WITH`` : Checks for a prefix.   ``AttributeValueList`` can contain only one
      ``AttributeValue`` of type String or Binary (not a Number or a set type). The target
      attribute of the comparison must be of type String or Binary (not a Number or a set type).

      * ``IN`` : Checks for matching elements in a list.  ``AttributeValueList`` can contain one
      or more ``AttributeValue`` elements of type String, Number, or Binary. These attributes are
      compared against an existing attribute of an item. If any elements of the input are equal
      to the item attribute, the expression evaluates to true.

      * ``BETWEEN`` : Greater than or equal to the first value, and less than or equal to the
      second value.   ``AttributeValueList`` must contain two ``AttributeValue`` elements of the
      same type, either String, Number, or Binary (not a set type). A target attribute matches if
      the target value is greater than, or equal to, the first element and less than, or equal
      to, the second element. If an item contains an ``AttributeValue`` element of a different
      type than the one provided in the request, the value does not match. For example,
      ``{"S":"6"}`` does not compare to ``{"N":"6"}`` . Also, ``{"N":"6"}`` does not compare to
      ``{"NS":["6", "2", "1"]}``

    - **AttributeValueList** *(list) --*

      One or more values to evaluate against the supplied attribute. The number of values in the
      list depends on the ``ComparisonOperator`` being used.

      For type Number, value comparisons are numeric.

      String value comparisons for greater than, equals, or less than are based on ASCII
      character code values. For example, ``a`` is greater than ``A`` , and ``a`` is greater than
      ``B`` . For a list of code values, see
      `http\\://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
      <http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters>`__ .

      For Binary, DynamoDB treats each byte of the binary data as unsigned when it compares
      binary values.

      For information on specifying data types in JSON, see `JSON Data Format
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html>`__ in
      the *Amazon DynamoDB Developer Guide* .

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type, and
        the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

        - **S** *(string) --*

          An attribute of type String. For example:

           ``"S": "Hello"``

        - **N** *(string) --*

          An attribute of type Number. For example:

           ``"N": "123.45"``

          Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
          across languages and libraries. However, DynamoDB treats them as number type attributes
          for mathematical operations.

        - **B** *(bytes) --*

          An attribute of type Binary. For example:

           ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

        - **SS** *(list) --*

          An attribute of type String Set. For example:

           ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

          - *(string) --*

        - **NS** *(list) --*

          An attribute of type Number Set. For example:

           ``"NS": ["42.2", "-19", "7.5", "3.14"]``

          Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
          across languages and libraries. However, DynamoDB treats them as number type attributes
          for mathematical operations.

          - *(string) --*

        - **BS** *(list) --*

          An attribute of type Binary Set. For example:

           ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

          - *(bytes) --*

        - **M** *(dict) --*

          An attribute of type Map. For example:

           ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

          - *(string) --*

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the data type,
              and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

        - **L** *(list) --*

          An attribute of type List. For example:

           ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data type,
            and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

        - **NULL** *(boolean) --*

          An attribute of type Null. For example:

           ``"NULL": true``

        - **BOOL** *(boolean) --*

          An attribute of type Boolean. For example:

           ``"BOOL": true``
    """


_ClientDeleteItemExpressionAttributeValuesTypeDef = TypedDict(
    "_ClientDeleteItemExpressionAttributeValuesTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientDeleteItemExpressionAttributeValuesTypeDef(
    _ClientDeleteItemExpressionAttributeValuesTypeDef
):
    """
    Type definition for `ClientDeleteItem` `ExpressionAttributeValues`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and the
    value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes for
      mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes for
      mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type, and
        the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientDeleteItemKeyTypeDef = TypedDict(
    "_ClientDeleteItemKeyTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientDeleteItemKeyTypeDef(_ClientDeleteItemKeyTypeDef):
    """
    Type definition for `ClientDeleteItem` `Key`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and the
    value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes for
      mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes for
      mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type, and
        the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientDeleteItemResponseAttributesTypeDef = TypedDict(
    "_ClientDeleteItemResponseAttributesTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientDeleteItemResponseAttributesTypeDef(
    _ClientDeleteItemResponseAttributesTypeDef
):
    """
    Type definition for `ClientDeleteItemResponse` `Attributes`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and
    the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type,
        and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientDeleteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDeleteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientDeleteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef(
    _ClientDeleteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDeleteItemResponseConsumedCapacity` `GlobalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientDeleteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDeleteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientDeleteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef(
    _ClientDeleteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDeleteItemResponseConsumedCapacity` `LocalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientDeleteItemResponseConsumedCapacityTableTypeDef = TypedDict(
    "_ClientDeleteItemResponseConsumedCapacityTableTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientDeleteItemResponseConsumedCapacityTableTypeDef(
    _ClientDeleteItemResponseConsumedCapacityTableTypeDef
):
    """
    Type definition for `ClientDeleteItemResponseConsumedCapacity` `Table`

    The amount of throughput consumed on the table affected by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientDeleteItemResponseConsumedCapacityTypeDef = TypedDict(
    "_ClientDeleteItemResponseConsumedCapacityTypeDef",
    {
        "TableName": str,
        "CapacityUnits": float,
        "ReadCapacityUnits": float,
        "WriteCapacityUnits": float,
        "Table": ClientDeleteItemResponseConsumedCapacityTableTypeDef,
        "LocalSecondaryIndexes": Dict[
            str, ClientDeleteItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": Dict[
            str, ClientDeleteItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientDeleteItemResponseConsumedCapacityTypeDef(
    _ClientDeleteItemResponseConsumedCapacityTypeDef
):
    """
    Type definition for `ClientDeleteItemResponse` `ConsumedCapacity`

    The capacity units consumed by the ``DeleteItem`` operation. The data returned includes the
    total provisioned throughput consumed, along with statistics for the table and any indexes
    involved in the operation. ``ConsumedCapacity`` is only returned if the
    ``ReturnConsumedCapacity`` parameter was specified. For more information, see `Provisioned
    Mode
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **TableName** *(string) --*

      The name of the table that was affected by the operation.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed by the operation.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed by the operation.

    - **Table** *(dict) --*

      The amount of throughput consumed on the table affected by the operation.

      - **ReadCapacityUnits** *(float) --*

        The total number of read capacity units consumed on a table or an index.

      - **WriteCapacityUnits** *(float) --*

        The total number of write capacity units consumed on a table or an index.

      - **CapacityUnits** *(float) --*

        The total number of capacity units consumed on a table or an index.

    - **LocalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each local index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.

    - **GlobalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each global index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.
    """


_ClientDeleteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef = TypedDict(
    "_ClientDeleteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientDeleteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef(
    _ClientDeleteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef
):
    """
    Type definition for `ClientDeleteItemResponseItemCollectionMetrics` `ItemCollectionKey`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and
    the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type
      attributes for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type
      attributes for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data
          type, and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type,
        and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientDeleteItemResponseItemCollectionMetricsTypeDef = TypedDict(
    "_ClientDeleteItemResponseItemCollectionMetricsTypeDef",
    {
        "ItemCollectionKey": Dict[
            str, ClientDeleteItemResponseItemCollectionMetricsItemCollectionKeyTypeDef
        ],
        "SizeEstimateRangeGB": List[float],
    },
    total=False,
)


class ClientDeleteItemResponseItemCollectionMetricsTypeDef(
    _ClientDeleteItemResponseItemCollectionMetricsTypeDef
):
    """
    Type definition for `ClientDeleteItemResponse` `ItemCollectionMetrics`

    Information about item collections, if any, that were affected by the ``DeleteItem``
    operation. ``ItemCollectionMetrics`` is only returned if the ``ReturnItemCollectionMetrics``
    parameter was specified. If the table does not have any local secondary indexes, this
    information is not returned in the response.

    Each ``ItemCollectionMetrics`` element consists of:

    * ``ItemCollectionKey`` - The partition key value of the item collection. This is the same as
    the partition key value of the item itself.

    * ``SizeEstimateRangeGB`` - An estimate of item collection size, in gigabytes. This value is
    a two-element array containing a lower bound and an upper bound for the estimate. The
    estimate includes the size of all the items in the table, plus the size of all attributes
    projected into all of the local secondary indexes on that table. Use this estimate to measure
    whether a local secondary index is approaching its size limit. The estimate is subject to
    change over time; therefore, do not rely on the precision or accuracy of the estimate.

    - **ItemCollectionKey** *(dict) --*

      The partition key value of the item collection. This value is the same as the partition key
      value of the item.

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
            across languages and libraries. However, DynamoDB treats them as number type
            attributes for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
            across languages and libraries. However, DynamoDB treats them as number type
            attributes for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data
                type, and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the data type,
              and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``

    - **SizeEstimateRangeGB** *(list) --*

      An estimate of item collection size, in gigabytes. This value is a two-element array
      containing a lower bound and an upper bound for the estimate. The estimate includes the
      size of all the items in the table, plus the size of all attributes projected into all of
      the local secondary indexes on that table. Use this estimate to measure whether a local
      secondary index is approaching its size limit.

      The estimate is subject to change over time; therefore, do not rely on the precision or
      accuracy of the estimate.

      - *(float) --*
    """


_ClientDeleteItemResponseTypeDef = TypedDict(
    "_ClientDeleteItemResponseTypeDef",
    {
        "Attributes": Dict[str, ClientDeleteItemResponseAttributesTypeDef],
        "ConsumedCapacity": ClientDeleteItemResponseConsumedCapacityTypeDef,
        "ItemCollectionMetrics": ClientDeleteItemResponseItemCollectionMetricsTypeDef,
    },
    total=False,
)


class ClientDeleteItemResponseTypeDef(_ClientDeleteItemResponseTypeDef):
    """
    Type definition for `ClientDeleteItem` `Response`

    Represents the output of a ``DeleteItem`` operation.

    - **Attributes** *(dict) --*

      A map of attribute names to ``AttributeValue`` objects, representing the item as it appeared
      before the ``DeleteItem`` operation. This map appears in the response only if
      ``ReturnValues`` was specified as ``ALL_OLD`` in the request.

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
            across languages and libraries. However, DynamoDB treats them as number type attributes
            for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
            across languages and libraries. However, DynamoDB treats them as number type attributes
            for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data type,
                and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the data type,
              and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``

    - **ConsumedCapacity** *(dict) --*

      The capacity units consumed by the ``DeleteItem`` operation. The data returned includes the
      total provisioned throughput consumed, along with statistics for the table and any indexes
      involved in the operation. ``ConsumedCapacity`` is only returned if the
      ``ReturnConsumedCapacity`` parameter was specified. For more information, see `Provisioned
      Mode
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
      in the *Amazon DynamoDB Developer Guide* .

      - **TableName** *(string) --*

        The name of the table that was affected by the operation.

      - **CapacityUnits** *(float) --*

        The total number of capacity units consumed by the operation.

      - **ReadCapacityUnits** *(float) --*

        The total number of read capacity units consumed by the operation.

      - **WriteCapacityUnits** *(float) --*

        The total number of write capacity units consumed by the operation.

      - **Table** *(dict) --*

        The amount of throughput consumed on the table affected by the operation.

        - **ReadCapacityUnits** *(float) --*

          The total number of read capacity units consumed on a table or an index.

        - **WriteCapacityUnits** *(float) --*

          The total number of write capacity units consumed on a table or an index.

        - **CapacityUnits** *(float) --*

          The total number of capacity units consumed on a table or an index.

      - **LocalSecondaryIndexes** *(dict) --*

        The amount of throughput consumed on each local index affected by the operation.

        - *(string) --*

          - *(dict) --*

            Represents the amount of provisioned throughput capacity consumed on a table or an
            index.

            - **ReadCapacityUnits** *(float) --*

              The total number of read capacity units consumed on a table or an index.

            - **WriteCapacityUnits** *(float) --*

              The total number of write capacity units consumed on a table or an index.

            - **CapacityUnits** *(float) --*

              The total number of capacity units consumed on a table or an index.

      - **GlobalSecondaryIndexes** *(dict) --*

        The amount of throughput consumed on each global index affected by the operation.

        - *(string) --*

          - *(dict) --*

            Represents the amount of provisioned throughput capacity consumed on a table or an
            index.

            - **ReadCapacityUnits** *(float) --*

              The total number of read capacity units consumed on a table or an index.

            - **WriteCapacityUnits** *(float) --*

              The total number of write capacity units consumed on a table or an index.

            - **CapacityUnits** *(float) --*

              The total number of capacity units consumed on a table or an index.

    - **ItemCollectionMetrics** *(dict) --*

      Information about item collections, if any, that were affected by the ``DeleteItem``
      operation. ``ItemCollectionMetrics`` is only returned if the ``ReturnItemCollectionMetrics``
      parameter was specified. If the table does not have any local secondary indexes, this
      information is not returned in the response.

      Each ``ItemCollectionMetrics`` element consists of:

      * ``ItemCollectionKey`` - The partition key value of the item collection. This is the same as
      the partition key value of the item itself.

      * ``SizeEstimateRangeGB`` - An estimate of item collection size, in gigabytes. This value is
      a two-element array containing a lower bound and an upper bound for the estimate. The
      estimate includes the size of all the items in the table, plus the size of all attributes
      projected into all of the local secondary indexes on that table. Use this estimate to measure
      whether a local secondary index is approaching its size limit. The estimate is subject to
      change over time; therefore, do not rely on the precision or accuracy of the estimate.

      - **ItemCollectionKey** *(dict) --*

        The partition key value of the item collection. This value is the same as the partition key
        value of the item.

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data type, and
            the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

            - **S** *(string) --*

              An attribute of type String. For example:

               ``"S": "Hello"``

            - **N** *(string) --*

              An attribute of type Number. For example:

               ``"N": "123.45"``

              Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
              across languages and libraries. However, DynamoDB treats them as number type
              attributes for mathematical operations.

            - **B** *(bytes) --*

              An attribute of type Binary. For example:

               ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

            - **SS** *(list) --*

              An attribute of type String Set. For example:

               ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

              - *(string) --*

            - **NS** *(list) --*

              An attribute of type Number Set. For example:

               ``"NS": ["42.2", "-19", "7.5", "3.14"]``

              Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
              across languages and libraries. However, DynamoDB treats them as number type
              attributes for mathematical operations.

              - *(string) --*

            - **BS** *(list) --*

              An attribute of type Binary Set. For example:

               ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

              - *(bytes) --*

            - **M** *(dict) --*

              An attribute of type Map. For example:

               ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

              - *(string) --*

                - *(dict) --*

                  Represents the data for an attribute.

                  Each attribute value is described as a name-value pair. The name is the data
                  type, and the value is the data itself.

                  For more information, see `Data Types
                  <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                  in the *Amazon DynamoDB Developer Guide* .

            - **L** *(list) --*

              An attribute of type List. For example:

               ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data type,
                and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

            - **NULL** *(boolean) --*

              An attribute of type Null. For example:

               ``"NULL": true``

            - **BOOL** *(boolean) --*

              An attribute of type Boolean. For example:

               ``"BOOL": true``

      - **SizeEstimateRangeGB** *(list) --*

        An estimate of item collection size, in gigabytes. This value is a two-element array
        containing a lower bound and an upper bound for the estimate. The estimate includes the
        size of all the items in the table, plus the size of all attributes projected into all of
        the local secondary indexes on that table. Use this estimate to measure whether a local
        secondary index is approaching its size limit.

        The estimate is subject to change over time; therefore, do not rely on the precision or
        accuracy of the estimate.

        - *(float) --*
    """


_ClientDeleteTableResponseTableDescriptionAttributeDefinitionsTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionAttributeDefinitionsTypeDef",
    {"AttributeName": str, "AttributeType": str},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionAttributeDefinitionsTypeDef(
    _ClientDeleteTableResponseTableDescriptionAttributeDefinitionsTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `AttributeDefinitions`

    Represents an attribute for describing the key schema for the table and indexes.

    - **AttributeName** *(string) --*

      A name for the attribute.

    - **AttributeType** *(string) --*

      The data type for the attribute, where:

      * ``S`` - the attribute is of type String

      * ``N`` - the attribute is of type Number

      * ``B`` - the attribute is of type Binary
    """


_ClientDeleteTableResponseTableDescriptionBillingModeSummaryTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionBillingModeSummaryTypeDef",
    {"BillingMode": str, "LastUpdateToPayPerRequestDateTime": datetime},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionBillingModeSummaryTypeDef(
    _ClientDeleteTableResponseTableDescriptionBillingModeSummaryTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `BillingModeSummary`

    Contains the details for the read/write capacity mode.

    - **BillingMode** *(string) --*

      Controls how you are charged for read and write throughput and how you manage capacity.
      This setting can be changed later.

      * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
      using ``PROVISIONED`` for predictable workloads.

      * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
      recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

    - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

      Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.
    """


_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef(
    _ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef(
    _ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
      list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    {
        "LastIncreaseDateTime": datetime,
        "LastDecreaseDateTime": datetime,
        "NumberOfDecreasesToday": int,
        "ReadCapacityUnits": int,
        "WriteCapacityUnits": int,
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef(
    _ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexes` `ProvisionedThroughput`

    Represents the provisioned throughput settings for the specified global secondary index.

    For current minimum and maximum provisioned throughput values, see `Limits
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
    the *Amazon DynamoDB Developer Guide* .

    - **LastIncreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput increase for this table.

    - **LastDecreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput decrease for this table.

    - **NumberOfDecreasesToday** *(integer) --*

      The number of provisioned throughput decreases for this table during this UTC
      calendar day. For current maximums on provisioned throughput decreases, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
      the *Amazon DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . Eventually consistent reads require less effort
      than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
      provides 100 eventually consistent ``ReadCapacityUnits`` per second.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` .
    """


_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProjectionTypeDef,
        "IndexStatus": str,
        "Backfilling": bool,
        "ProvisionedThroughput": ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesProvisionedThroughputTypeDef,
        "IndexSizeBytes": int,
        "ItemCount": int,
        "IndexArn": str,
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef(
    _ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `GlobalSecondaryIndexes`

    Represents the properties of a global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for a global secondary index, which consists of one or more
      pairs of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
        list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **IndexStatus** *(string) --*

      The current state of the global secondary index:

      * ``CREATING`` - The index is being created.

      * ``UPDATING`` - The index is being updated.

      * ``DELETING`` - The index is being deleted.

      * ``ACTIVE`` - The index is ready for use.

    - **Backfilling** *(boolean) --*

      Indicates whether the index is currently backfilling. *Backfilling* is the process of
      reading items from the table and determining whether they can be added to the index.
      (Not all items will qualify: For example, a partition key cannot have any duplicate
      values.) If an item can be added to the index, DynamoDB will do so. After all items
      have been processed, the backfilling operation is complete and ``Backfilling`` is false.

      You can delete an index that is being created during the ``Backfilling`` phase when
      ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
      index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
      is false.

      .. note::

        For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
        attribute does not appear in the ``DescribeTable`` output.

    - **ProvisionedThroughput** *(dict) --*

      Represents the provisioned throughput settings for the specified global secondary index.

      For current minimum and maximum provisioned throughput values, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
      the *Amazon DynamoDB Developer Guide* .

      - **LastIncreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput increase for this table.

      - **LastDecreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput decrease for this table.

      - **NumberOfDecreasesToday** *(integer) --*

        The number of provisioned throughput decreases for this table during this UTC
        calendar day. For current maximums on provisioned throughput decreases, see `Limits
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
        the *Amazon DynamoDB Developer Guide* .

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . Eventually consistent reads require less effort
        than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
        provides 100 eventually consistent ``ReadCapacityUnits`` per second.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` .

    - **IndexSizeBytes** *(integer) --*

      The total size of the specified index, in bytes. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified index. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **IndexArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the index.
    """


_ClientDeleteTableResponseTableDescriptionKeySchemaTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionKeySchemaTypeDef(
    _ClientDeleteTableResponseTableDescriptionKeySchemaTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes that
    make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
    a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
    key). A composite primary key would require one ``KeySchemaElement`` for the partition
    key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
    The data type must be one of String, Number, or Binary. The attribute cannot be nested
    within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef(
    _ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef(
    _ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
      list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesProjectionTypeDef,
        "IndexSizeBytes": int,
        "ItemCount": int,
        "IndexArn": str,
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesTypeDef(
    _ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `LocalSecondaryIndexes`

    Represents the properties of a local secondary index.

    - **IndexName** *(string) --*

      Represents the name of the local secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for the local secondary index, consisting of one or more pairs
      of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
        list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **IndexSizeBytes** *(integer) --*

      The total size of the specified index, in bytes. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified index. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **IndexArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the index.
    """


_ClientDeleteTableResponseTableDescriptionProvisionedThroughputTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionProvisionedThroughputTypeDef",
    {
        "LastIncreaseDateTime": datetime,
        "LastDecreaseDateTime": datetime,
        "NumberOfDecreasesToday": int,
        "ReadCapacityUnits": int,
        "WriteCapacityUnits": int,
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionProvisionedThroughputTypeDef(
    _ClientDeleteTableResponseTableDescriptionProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `ProvisionedThroughput`

    The provisioned throughput settings for the table, consisting of read and write capacity
    units, along with data about increases and decreases.

    - **LastIncreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput increase for this table.

    - **LastDecreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput decrease for this table.

    - **NumberOfDecreasesToday** *(integer) --*

      The number of provisioned throughput decreases for this table during this UTC calendar
      day. For current maximums on provisioned throughput decreases, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
      *Amazon DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
      strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
      100 eventually consistent ``ReadCapacityUnits`` per second.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` .
    """


_ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef(
    _ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexes` `ProvisionedThroughputOverride`

    If not described, uses the source table GSI's read capacity settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's
      read capacity settings.
    """


_ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "ProvisionedThroughputOverride": ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef,
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef(
    _ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionReplicas` `GlobalSecondaryIndexes`

    Represents the properties of a replica global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **ProvisionedThroughputOverride** *(dict) --*

      If not described, uses the source table GSI's read capacity settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's
        read capacity settings.
    """


_ClientDeleteTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef(
    _ClientDeleteTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescriptionReplicas` `ProvisionedThroughputOverride`

    Replica-specific provisioned throughput. If not described, uses the source table's
    provisioned throughput settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's read
      capacity settings.
    """


_ClientDeleteTableResponseTableDescriptionReplicasTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionReplicasTypeDef",
    {
        "RegionName": str,
        "ReplicaStatus": str,
        "ReplicaStatusDescription": str,
        "ReplicaStatusPercentProgress": str,
        "KMSMasterKeyId": str,
        "ProvisionedThroughputOverride": ClientDeleteTableResponseTableDescriptionReplicasProvisionedThroughputOverrideTypeDef,
        "GlobalSecondaryIndexes": List[
            ClientDeleteTableResponseTableDescriptionReplicasGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionReplicasTypeDef(
    _ClientDeleteTableResponseTableDescriptionReplicasTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `Replicas`

    Contains the details of the replica.

    - **RegionName** *(string) --*

      The name of the Region.

    - **ReplicaStatus** *(string) --*

      The current state of the replica:

      * ``CREATING`` - The replica is being created.

      * ``UPDATING`` - The replica is being updated.

      * ``DELETING`` - The replica is being deleted.

      * ``ACTIVE`` - The replica is ready for use.

    - **ReplicaStatusDescription** *(string) --*

      Detailed information about the replica status.

    - **ReplicaStatusPercentProgress** *(string) --*

      Specifies the progress of a Create, Update, or Delete action on the replica as a
      percentage.

    - **KMSMasterKeyId** *(string) --*

      The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
      encryption.

    - **ProvisionedThroughputOverride** *(dict) --*

      Replica-specific provisioned throughput. If not described, uses the source table's
      provisioned throughput settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's read
        capacity settings.

    - **GlobalSecondaryIndexes** *(list) --*

      Replica-specific global secondary index settings.

      - *(dict) --*

        Represents the properties of a replica global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **ProvisionedThroughputOverride** *(dict) --*

          If not described, uses the source table GSI's read capacity settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's
            read capacity settings.
    """


_ClientDeleteTableResponseTableDescriptionRestoreSummaryTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionRestoreSummaryTypeDef",
    {
        "SourceBackupArn": str,
        "SourceTableArn": str,
        "RestoreDateTime": datetime,
        "RestoreInProgress": bool,
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionRestoreSummaryTypeDef(
    _ClientDeleteTableResponseTableDescriptionRestoreSummaryTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `RestoreSummary`

    Contains details for the restore.

    - **SourceBackupArn** *(string) --*

      The Amazon Resource Name (ARN) of the backup from which the table was restored.

    - **SourceTableArn** *(string) --*

      The ARN of the source table of the backup that is being restored.

    - **RestoreDateTime** *(datetime) --*

      Point in time or source backup time.

    - **RestoreInProgress** *(boolean) --*

      Indicates if a restore is in progress or not.
    """


_ClientDeleteTableResponseTableDescriptionSSEDescriptionTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionSSEDescriptionTypeDef",
    {"Status": str, "SSEType": str, "KMSMasterKeyArn": str},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionSSEDescriptionTypeDef(
    _ClientDeleteTableResponseTableDescriptionSSEDescriptionTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `SSEDescription`

    The description of the server-side encryption status on the specified table.

    - **Status** *(string) --*

      Represents the current state of server-side encryption. The only supported values are:

      * ``ENABLED`` - Server-side encryption is enabled.

      * ``UPDATING`` - Server-side encryption is being updated.

    - **SSEType** *(string) --*

      Server-side encryption type. The only supported value is:

      * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
      stored in your account and is managed by AWS KMS (AWS KMS charges apply).

    - **KMSMasterKeyArn** *(string) --*

      The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDeleteTableResponseTableDescriptionStreamSpecificationTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionStreamSpecificationTypeDef",
    {"StreamEnabled": bool, "StreamViewType": str},
    total=False,
)


class ClientDeleteTableResponseTableDescriptionStreamSpecificationTypeDef(
    _ClientDeleteTableResponseTableDescriptionStreamSpecificationTypeDef
):
    """
    Type definition for `ClientDeleteTableResponseTableDescription` `StreamSpecification`

    The current DynamoDB Streams configuration for the table.

    - **StreamEnabled** *(boolean) --*

      Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

    - **StreamViewType** *(string) --*

      When an item in the table is modified, ``StreamViewType`` determines what information is
      written to the stream for this table. Valid values for ``StreamViewType`` are:

      * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

      * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
      stream.

      * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
      the stream.

      * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
      to the stream.
    """


_ClientDeleteTableResponseTableDescriptionTypeDef = TypedDict(
    "_ClientDeleteTableResponseTableDescriptionTypeDef",
    {
        "AttributeDefinitions": List[
            ClientDeleteTableResponseTableDescriptionAttributeDefinitionsTypeDef
        ],
        "TableName": str,
        "KeySchema": List[ClientDeleteTableResponseTableDescriptionKeySchemaTypeDef],
        "TableStatus": str,
        "CreationDateTime": datetime,
        "ProvisionedThroughput": ClientDeleteTableResponseTableDescriptionProvisionedThroughputTypeDef,
        "TableSizeBytes": int,
        "ItemCount": int,
        "TableArn": str,
        "TableId": str,
        "BillingModeSummary": ClientDeleteTableResponseTableDescriptionBillingModeSummaryTypeDef,
        "LocalSecondaryIndexes": List[
            ClientDeleteTableResponseTableDescriptionLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": List[
            ClientDeleteTableResponseTableDescriptionGlobalSecondaryIndexesTypeDef
        ],
        "StreamSpecification": ClientDeleteTableResponseTableDescriptionStreamSpecificationTypeDef,
        "LatestStreamLabel": str,
        "LatestStreamArn": str,
        "GlobalTableVersion": str,
        "Replicas": List[ClientDeleteTableResponseTableDescriptionReplicasTypeDef],
        "RestoreSummary": ClientDeleteTableResponseTableDescriptionRestoreSummaryTypeDef,
        "SSEDescription": ClientDeleteTableResponseTableDescriptionSSEDescriptionTypeDef,
    },
    total=False,
)


class ClientDeleteTableResponseTableDescriptionTypeDef(
    _ClientDeleteTableResponseTableDescriptionTypeDef
):
    """
    Type definition for `ClientDeleteTableResponse` `TableDescription`

    Represents the properties of a table.

    - **AttributeDefinitions** *(list) --*

      An array of ``AttributeDefinition`` objects. Each of these objects describes one attribute
      in the table and index key schema.

      Each ``AttributeDefinition`` object in this array is composed of:

      * ``AttributeName`` - The name of the attribute.

      * ``AttributeType`` - The data type for the attribute.

      - *(dict) --*

        Represents an attribute for describing the key schema for the table and indexes.

        - **AttributeName** *(string) --*

          A name for the attribute.

        - **AttributeType** *(string) --*

          The data type for the attribute, where:

          * ``S`` - the attribute is of type String

          * ``N`` - the attribute is of type Number

          * ``B`` - the attribute is of type Binary

    - **TableName** *(string) --*

      The name of the table.

    - **KeySchema** *(list) --*

      The primary key structure for the table. Each ``KeySchemaElement`` consists of:

      * ``AttributeName`` - The name of the attribute.

      * ``KeyType`` - The role of the attribute:

        * ``HASH`` - partition key

        * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      For more information about primary keys, see `Primary Key
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey>`__
      in the *Amazon DynamoDB Developer Guide* .

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes that
        make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
        a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
        key). A composite primary key would require one ``KeySchemaElement`` for the partition
        key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
        The data type must be one of String, Number, or Binary. The attribute cannot be nested
        within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **TableStatus** *(string) --*

      The current state of the table:

      * ``CREATING`` - The table is being created.

      * ``UPDATING`` - The table is being updated.

      * ``DELETING`` - The table is being deleted.

      * ``ACTIVE`` - The table is ready for use.

    - **CreationDateTime** *(datetime) --*

      The date and time when the table was created, in `UNIX epoch time
      <http://www.epochconverter.com/>`__ format.

    - **ProvisionedThroughput** *(dict) --*

      The provisioned throughput settings for the table, consisting of read and write capacity
      units, along with data about increases and decreases.

      - **LastIncreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput increase for this table.

      - **LastDecreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput decrease for this table.

      - **NumberOfDecreasesToday** *(integer) --*

        The number of provisioned throughput decreases for this table during this UTC calendar
        day. For current maximums on provisioned throughput decreases, see `Limits
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
        *Amazon DynamoDB Developer Guide* .

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
        strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
        100 eventually consistent ``ReadCapacityUnits`` per second.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` .

    - **TableSizeBytes** *(integer) --*

      The total size of the specified table, in bytes. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified table. DynamoDB updates this value approximately every
      six hours. Recent changes might not be reflected in this value.

    - **TableArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the table.

    - **TableId** *(string) --*

      Unique identifier for the table for which the backup was created.

    - **BillingModeSummary** *(dict) --*

      Contains the details for the read/write capacity mode.

      - **BillingMode** *(string) --*

        Controls how you are charged for read and write throughput and how you manage capacity.
        This setting can be changed later.

        * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
        using ``PROVISIONED`` for predictable workloads.

        * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
        recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

      - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

        Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.

    - **LocalSecondaryIndexes** *(list) --*

      Represents one or more local secondary indexes on the table. Each index is scoped to a
      given partition key value. Tables with one or more local secondary indexes are subject to
      an item collection size limit, where the amount of data within a given item collection
      cannot exceed 10 GB. Each element is composed of:

      * ``IndexName`` - The name of the local secondary index.

      * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
      schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
      same partition key as the table.

      * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected. Each attribute specification is composed of:

        * ``ProjectionType`` - One of the following:

          * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

          * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
          list of projected attributes is in ``NonKeyAttributes`` .

          * ``ALL`` - All of the table attributes are projected into the index.

        * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
        into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
        , summed across all of the secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

      * ``IndexSizeBytes`` - Represents the total size of the index, in bytes. DynamoDB updates
      this value approximately every six hours. Recent changes might not be reflected in this
      value.

      * ``ItemCount`` - Represents the number of items in the index. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

      If the table is in the ``DELETING`` state, no information about indexes will be returned.

      - *(dict) --*

        Represents the properties of a local secondary index.

        - **IndexName** *(string) --*

          Represents the name of the local secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for the local secondary index, consisting of one or more pairs
          of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **IndexSizeBytes** *(integer) --*

          The total size of the specified index, in bytes. DynamoDB updates this value
          approximately every six hours. Recent changes might not be reflected in this value.

        - **ItemCount** *(integer) --*

          The number of items in the specified index. DynamoDB updates this value approximately
          every six hours. Recent changes might not be reflected in this value.

        - **IndexArn** *(string) --*

          The Amazon Resource Name (ARN) that uniquely identifies the index.

    - **GlobalSecondaryIndexes** *(list) --*

      The global secondary indexes, if any, on the table. Each index is scoped to a given
      partition key value. Each element is composed of:

      * ``Backfilling`` - If true, then the index is currently in the backfilling phase.
      Backfilling occurs only when a new global secondary index is added to the table. It is the
      process by which DynamoDB populates the new index with data from the table. (This attribute
      does not appear for indexes that were created during a ``CreateTable`` operation.)  You can
      delete an index that is being created during the ``Backfilling`` phase when ``IndexStatus``
      is set to CREATING and ``Backfilling`` is true. You can't delete the index that is being
      created when ``IndexStatus`` is set to CREATING and ``Backfilling`` is false. (This
      attribute does not appear for indexes that were created during a ``CreateTable`` operation.)

      * ``IndexName`` - The name of the global secondary index.

      * ``IndexSizeBytes`` - The total size of the global secondary index, in bytes. DynamoDB
      updates this value approximately every six hours. Recent changes might not be reflected in
      this value.

      * ``IndexStatus`` - The current status of the global secondary index:

        * ``CREATING`` - The index is being created.

        * ``UPDATING`` - The index is being updated.

        * ``DELETING`` - The index is being deleted.

        * ``ACTIVE`` - The index is ready for use.

      * ``ItemCount`` - The number of items in the global secondary index. DynamoDB updates this
      value approximately every six hours. Recent changes might not be reflected in this value.

      * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
      schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
      same partition key as the table.

      * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected. Each attribute specification is composed of:

        * ``ProjectionType`` - One of the following:

          * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

          * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
          list of projected attributes is in ``NonKeyAttributes`` .

          * ``ALL`` - All of the table attributes are projected into the index.

        * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
        into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
        , summed across all of the secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

      * ``ProvisionedThroughput`` - The provisioned throughput settings for the global secondary
      index, consisting of read and write capacity units, along with data about increases and
      decreases.

      If the table is in the ``DELETING`` state, no information about indexes will be returned.

      - *(dict) --*

        Represents the properties of a global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for a global secondary index, which consists of one or more
          pairs of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **IndexStatus** *(string) --*

          The current state of the global secondary index:

          * ``CREATING`` - The index is being created.

          * ``UPDATING`` - The index is being updated.

          * ``DELETING`` - The index is being deleted.

          * ``ACTIVE`` - The index is ready for use.

        - **Backfilling** *(boolean) --*

          Indicates whether the index is currently backfilling. *Backfilling* is the process of
          reading items from the table and determining whether they can be added to the index.
          (Not all items will qualify: For example, a partition key cannot have any duplicate
          values.) If an item can be added to the index, DynamoDB will do so. After all items
          have been processed, the backfilling operation is complete and ``Backfilling`` is false.

          You can delete an index that is being created during the ``Backfilling`` phase when
          ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
          index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
          is false.

          .. note::

            For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
            attribute does not appear in the ``DescribeTable`` output.

        - **ProvisionedThroughput** *(dict) --*

          Represents the provisioned throughput settings for the specified global secondary index.

          For current minimum and maximum provisioned throughput values, see `Limits
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
          the *Amazon DynamoDB Developer Guide* .

          - **LastIncreaseDateTime** *(datetime) --*

            The date and time of the last provisioned throughput increase for this table.

          - **LastDecreaseDateTime** *(datetime) --*

            The date and time of the last provisioned throughput decrease for this table.

          - **NumberOfDecreasesToday** *(integer) --*

            The number of provisioned throughput decreases for this table during this UTC
            calendar day. For current maximums on provisioned throughput decreases, see `Limits
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
            the *Amazon DynamoDB Developer Guide* .

          - **ReadCapacityUnits** *(integer) --*

            The maximum number of strongly consistent reads consumed per second before DynamoDB
            returns a ``ThrottlingException`` . Eventually consistent reads require less effort
            than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
            provides 100 eventually consistent ``ReadCapacityUnits`` per second.

          - **WriteCapacityUnits** *(integer) --*

            The maximum number of writes consumed per second before DynamoDB returns a
            ``ThrottlingException`` .

        - **IndexSizeBytes** *(integer) --*

          The total size of the specified index, in bytes. DynamoDB updates this value
          approximately every six hours. Recent changes might not be reflected in this value.

        - **ItemCount** *(integer) --*

          The number of items in the specified index. DynamoDB updates this value approximately
          every six hours. Recent changes might not be reflected in this value.

        - **IndexArn** *(string) --*

          The Amazon Resource Name (ARN) that uniquely identifies the index.

    - **StreamSpecification** *(dict) --*

      The current DynamoDB Streams configuration for the table.

      - **StreamEnabled** *(boolean) --*

        Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

      - **StreamViewType** *(string) --*

        When an item in the table is modified, ``StreamViewType`` determines what information is
        written to the stream for this table. Valid values for ``StreamViewType`` are:

        * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

        * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
        stream.

        * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
        the stream.

        * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
        to the stream.

    - **LatestStreamLabel** *(string) --*

      A timestamp, in ISO 8601 format, for this stream.

      Note that ``LatestStreamLabel`` is not a unique identifier for the stream, because it is
      possible that a stream from another table might have the same timestamp. However, the
      combination of the following three elements is guaranteed to be unique:

      * AWS customer ID

      * Table name

      * ``StreamLabel``

    - **LatestStreamArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.

    - **GlobalTableVersion** *(string) --*

      Represents the version of `global tables
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html>`__ in
      use, if the table is replicated across AWS Regions.

    - **Replicas** *(list) --*

      Represents replicas of the table.

      - *(dict) --*

        Contains the details of the replica.

        - **RegionName** *(string) --*

          The name of the Region.

        - **ReplicaStatus** *(string) --*

          The current state of the replica:

          * ``CREATING`` - The replica is being created.

          * ``UPDATING`` - The replica is being updated.

          * ``DELETING`` - The replica is being deleted.

          * ``ACTIVE`` - The replica is ready for use.

        - **ReplicaStatusDescription** *(string) --*

          Detailed information about the replica status.

        - **ReplicaStatusPercentProgress** *(string) --*

          Specifies the progress of a Create, Update, or Delete action on the replica as a
          percentage.

        - **KMSMasterKeyId** *(string) --*

          The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
          encryption.

        - **ProvisionedThroughputOverride** *(dict) --*

          Replica-specific provisioned throughput. If not described, uses the source table's
          provisioned throughput settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's read
            capacity settings.

        - **GlobalSecondaryIndexes** *(list) --*

          Replica-specific global secondary index settings.

          - *(dict) --*

            Represents the properties of a replica global secondary index.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **ProvisionedThroughputOverride** *(dict) --*

              If not described, uses the source table GSI's read capacity settings.

              - **ReadCapacityUnits** *(integer) --*

                Replica-specific read capacity units. If not specified, uses the source table's
                read capacity settings.

    - **RestoreSummary** *(dict) --*

      Contains details for the restore.

      - **SourceBackupArn** *(string) --*

        The Amazon Resource Name (ARN) of the backup from which the table was restored.

      - **SourceTableArn** *(string) --*

        The ARN of the source table of the backup that is being restored.

      - **RestoreDateTime** *(datetime) --*

        Point in time or source backup time.

      - **RestoreInProgress** *(boolean) --*

        Indicates if a restore is in progress or not.

    - **SSEDescription** *(dict) --*

      The description of the server-side encryption status on the specified table.

      - **Status** *(string) --*

        Represents the current state of server-side encryption. The only supported values are:

        * ``ENABLED`` - Server-side encryption is enabled.

        * ``UPDATING`` - Server-side encryption is being updated.

      - **SSEType** *(string) --*

        Server-side encryption type. The only supported value is:

        * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
        stored in your account and is managed by AWS KMS (AWS KMS charges apply).

      - **KMSMasterKeyArn** *(string) --*

        The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDeleteTableResponseTypeDef = TypedDict(
    "_ClientDeleteTableResponseTypeDef",
    {"TableDescription": ClientDeleteTableResponseTableDescriptionTypeDef},
    total=False,
)


class ClientDeleteTableResponseTypeDef(_ClientDeleteTableResponseTypeDef):
    """
    Type definition for `ClientDeleteTable` `Response`

    Represents the output of a ``DeleteTable`` operation.

    - **TableDescription** *(dict) --*

      Represents the properties of a table.

      - **AttributeDefinitions** *(list) --*

        An array of ``AttributeDefinition`` objects. Each of these objects describes one attribute
        in the table and index key schema.

        Each ``AttributeDefinition`` object in this array is composed of:

        * ``AttributeName`` - The name of the attribute.

        * ``AttributeType`` - The data type for the attribute.

        - *(dict) --*

          Represents an attribute for describing the key schema for the table and indexes.

          - **AttributeName** *(string) --*

            A name for the attribute.

          - **AttributeType** *(string) --*

            The data type for the attribute, where:

            * ``S`` - the attribute is of type String

            * ``N`` - the attribute is of type Number

            * ``B`` - the attribute is of type Binary

      - **TableName** *(string) --*

        The name of the table.

      - **KeySchema** *(list) --*

        The primary key structure for the table. Each ``KeySchemaElement`` consists of:

        * ``AttributeName`` - The name of the attribute.

        * ``KeyType`` - The role of the attribute:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

        .. note::

          The partition key of an item is also known as its *hash attribute* . The term "hash
          attribute" derives from DynamoDB's usage of an internal hash function to evenly
          distribute data items across partitions, based on their partition key values.

          The sort key of an item is also known as its *range attribute* . The term "range
          attribute" derives from the way DynamoDB stores items with the same partition key
          physically close together, in sorted order by the sort key value.

        For more information about primary keys, see `Primary Key
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey>`__
        in the *Amazon DynamoDB Developer Guide* .

        - *(dict) --*

          Represents *a single element* of a key schema. A key schema specifies the attributes that
          make up the primary key of a table, or the key attributes of an index.

          A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
          a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
          key). A composite primary key would require one ``KeySchemaElement`` for the partition
          key, and another ``KeySchemaElement`` for the sort key.

          A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
          The data type must be one of String, Number, or Binary. The attribute cannot be nested
          within a List or a Map.

          - **AttributeName** *(string) --*

            The name of a key attribute.

          - **KeyType** *(string) --*

            The role that this key attribute will assume:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

      - **TableStatus** *(string) --*

        The current state of the table:

        * ``CREATING`` - The table is being created.

        * ``UPDATING`` - The table is being updated.

        * ``DELETING`` - The table is being deleted.

        * ``ACTIVE`` - The table is ready for use.

      - **CreationDateTime** *(datetime) --*

        The date and time when the table was created, in `UNIX epoch time
        <http://www.epochconverter.com/>`__ format.

      - **ProvisionedThroughput** *(dict) --*

        The provisioned throughput settings for the table, consisting of read and write capacity
        units, along with data about increases and decreases.

        - **LastIncreaseDateTime** *(datetime) --*

          The date and time of the last provisioned throughput increase for this table.

        - **LastDecreaseDateTime** *(datetime) --*

          The date and time of the last provisioned throughput decrease for this table.

        - **NumberOfDecreasesToday** *(integer) --*

          The number of provisioned throughput decreases for this table during this UTC calendar
          day. For current maximums on provisioned throughput decreases, see `Limits
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
          *Amazon DynamoDB Developer Guide* .

        - **ReadCapacityUnits** *(integer) --*

          The maximum number of strongly consistent reads consumed per second before DynamoDB
          returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
          strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
          100 eventually consistent ``ReadCapacityUnits`` per second.

        - **WriteCapacityUnits** *(integer) --*

          The maximum number of writes consumed per second before DynamoDB returns a
          ``ThrottlingException`` .

      - **TableSizeBytes** *(integer) --*

        The total size of the specified table, in bytes. DynamoDB updates this value approximately
        every six hours. Recent changes might not be reflected in this value.

      - **ItemCount** *(integer) --*

        The number of items in the specified table. DynamoDB updates this value approximately every
        six hours. Recent changes might not be reflected in this value.

      - **TableArn** *(string) --*

        The Amazon Resource Name (ARN) that uniquely identifies the table.

      - **TableId** *(string) --*

        Unique identifier for the table for which the backup was created.

      - **BillingModeSummary** *(dict) --*

        Contains the details for the read/write capacity mode.

        - **BillingMode** *(string) --*

          Controls how you are charged for read and write throughput and how you manage capacity.
          This setting can be changed later.

          * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
          using ``PROVISIONED`` for predictable workloads.

          * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
          recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

        - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

          Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.

      - **LocalSecondaryIndexes** *(list) --*

        Represents one or more local secondary indexes on the table. Each index is scoped to a
        given partition key value. Tables with one or more local secondary indexes are subject to
        an item collection size limit, where the amount of data within a given item collection
        cannot exceed 10 GB. Each element is composed of:

        * ``IndexName`` - The name of the local secondary index.

        * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
        same partition key as the table.

        * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
        index. These are in addition to the primary key attributes and index key attributes, which
        are automatically projected. Each attribute specification is composed of:

          * ``ProjectionType`` - One of the following:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
          into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
          , summed across all of the secondary indexes, must not exceed 20. If you project the same
          attribute into two different indexes, this counts as two distinct attributes when
          determining the total.

        * ``IndexSizeBytes`` - Represents the total size of the index, in bytes. DynamoDB updates
        this value approximately every six hours. Recent changes might not be reflected in this
        value.

        * ``ItemCount`` - Represents the number of items in the index. DynamoDB updates this value
        approximately every six hours. Recent changes might not be reflected in this value.

        If the table is in the ``DELETING`` state, no information about indexes will be returned.

        - *(dict) --*

          Represents the properties of a local secondary index.

          - **IndexName** *(string) --*

            Represents the name of the local secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for the local secondary index, consisting of one or more pairs
            of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the attributes
              that make up the primary key of a table, or the key attributes of an index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term "range
                  attribute" derives from the way DynamoDB stores items with the same partition key
                  physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
              list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **IndexSizeBytes** *(integer) --*

            The total size of the specified index, in bytes. DynamoDB updates this value
            approximately every six hours. Recent changes might not be reflected in this value.

          - **ItemCount** *(integer) --*

            The number of items in the specified index. DynamoDB updates this value approximately
            every six hours. Recent changes might not be reflected in this value.

          - **IndexArn** *(string) --*

            The Amazon Resource Name (ARN) that uniquely identifies the index.

      - **GlobalSecondaryIndexes** *(list) --*

        The global secondary indexes, if any, on the table. Each index is scoped to a given
        partition key value. Each element is composed of:

        * ``Backfilling`` - If true, then the index is currently in the backfilling phase.
        Backfilling occurs only when a new global secondary index is added to the table. It is the
        process by which DynamoDB populates the new index with data from the table. (This attribute
        does not appear for indexes that were created during a ``CreateTable`` operation.)  You can
        delete an index that is being created during the ``Backfilling`` phase when ``IndexStatus``
        is set to CREATING and ``Backfilling`` is true. You can't delete the index that is being
        created when ``IndexStatus`` is set to CREATING and ``Backfilling`` is false. (This
        attribute does not appear for indexes that were created during a ``CreateTable`` operation.)

        * ``IndexName`` - The name of the global secondary index.

        * ``IndexSizeBytes`` - The total size of the global secondary index, in bytes. DynamoDB
        updates this value approximately every six hours. Recent changes might not be reflected in
        this value.

        * ``IndexStatus`` - The current status of the global secondary index:

          * ``CREATING`` - The index is being created.

          * ``UPDATING`` - The index is being updated.

          * ``DELETING`` - The index is being deleted.

          * ``ACTIVE`` - The index is ready for use.

        * ``ItemCount`` - The number of items in the global secondary index. DynamoDB updates this
        value approximately every six hours. Recent changes might not be reflected in this value.

        * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
        same partition key as the table.

        * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
        index. These are in addition to the primary key attributes and index key attributes, which
        are automatically projected. Each attribute specification is composed of:

          * ``ProjectionType`` - One of the following:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
          into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
          , summed across all of the secondary indexes, must not exceed 20. If you project the same
          attribute into two different indexes, this counts as two distinct attributes when
          determining the total.

        * ``ProvisionedThroughput`` - The provisioned throughput settings for the global secondary
        index, consisting of read and write capacity units, along with data about increases and
        decreases.

        If the table is in the ``DELETING`` state, no information about indexes will be returned.

        - *(dict) --*

          Represents the properties of a global secondary index.

          - **IndexName** *(string) --*

            The name of the global secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for a global secondary index, which consists of one or more
            pairs of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the attributes
              that make up the primary key of a table, or the key attributes of an index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term "range
                  attribute" derives from the way DynamoDB stores items with the same partition key
                  physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
              list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **IndexStatus** *(string) --*

            The current state of the global secondary index:

            * ``CREATING`` - The index is being created.

            * ``UPDATING`` - The index is being updated.

            * ``DELETING`` - The index is being deleted.

            * ``ACTIVE`` - The index is ready for use.

          - **Backfilling** *(boolean) --*

            Indicates whether the index is currently backfilling. *Backfilling* is the process of
            reading items from the table and determining whether they can be added to the index.
            (Not all items will qualify: For example, a partition key cannot have any duplicate
            values.) If an item can be added to the index, DynamoDB will do so. After all items
            have been processed, the backfilling operation is complete and ``Backfilling`` is false.

            You can delete an index that is being created during the ``Backfilling`` phase when
            ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
            index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
            is false.

            .. note::

              For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
              attribute does not appear in the ``DescribeTable`` output.

          - **ProvisionedThroughput** *(dict) --*

            Represents the provisioned throughput settings for the specified global secondary index.

            For current minimum and maximum provisioned throughput values, see `Limits
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
            the *Amazon DynamoDB Developer Guide* .

            - **LastIncreaseDateTime** *(datetime) --*

              The date and time of the last provisioned throughput increase for this table.

            - **LastDecreaseDateTime** *(datetime) --*

              The date and time of the last provisioned throughput decrease for this table.

            - **NumberOfDecreasesToday** *(integer) --*

              The number of provisioned throughput decreases for this table during this UTC
              calendar day. For current maximums on provisioned throughput decreases, see `Limits
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
              the *Amazon DynamoDB Developer Guide* .

            - **ReadCapacityUnits** *(integer) --*

              The maximum number of strongly consistent reads consumed per second before DynamoDB
              returns a ``ThrottlingException`` . Eventually consistent reads require less effort
              than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
              provides 100 eventually consistent ``ReadCapacityUnits`` per second.

            - **WriteCapacityUnits** *(integer) --*

              The maximum number of writes consumed per second before DynamoDB returns a
              ``ThrottlingException`` .

          - **IndexSizeBytes** *(integer) --*

            The total size of the specified index, in bytes. DynamoDB updates this value
            approximately every six hours. Recent changes might not be reflected in this value.

          - **ItemCount** *(integer) --*

            The number of items in the specified index. DynamoDB updates this value approximately
            every six hours. Recent changes might not be reflected in this value.

          - **IndexArn** *(string) --*

            The Amazon Resource Name (ARN) that uniquely identifies the index.

      - **StreamSpecification** *(dict) --*

        The current DynamoDB Streams configuration for the table.

        - **StreamEnabled** *(boolean) --*

          Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

        - **StreamViewType** *(string) --*

          When an item in the table is modified, ``StreamViewType`` determines what information is
          written to the stream for this table. Valid values for ``StreamViewType`` are:

          * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

          * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
          stream.

          * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
          the stream.

          * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
          to the stream.

      - **LatestStreamLabel** *(string) --*

        A timestamp, in ISO 8601 format, for this stream.

        Note that ``LatestStreamLabel`` is not a unique identifier for the stream, because it is
        possible that a stream from another table might have the same timestamp. However, the
        combination of the following three elements is guaranteed to be unique:

        * AWS customer ID

        * Table name

        * ``StreamLabel``

      - **LatestStreamArn** *(string) --*

        The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.

      - **GlobalTableVersion** *(string) --*

        Represents the version of `global tables
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html>`__ in
        use, if the table is replicated across AWS Regions.

      - **Replicas** *(list) --*

        Represents replicas of the table.

        - *(dict) --*

          Contains the details of the replica.

          - **RegionName** *(string) --*

            The name of the Region.

          - **ReplicaStatus** *(string) --*

            The current state of the replica:

            * ``CREATING`` - The replica is being created.

            * ``UPDATING`` - The replica is being updated.

            * ``DELETING`` - The replica is being deleted.

            * ``ACTIVE`` - The replica is ready for use.

          - **ReplicaStatusDescription** *(string) --*

            Detailed information about the replica status.

          - **ReplicaStatusPercentProgress** *(string) --*

            Specifies the progress of a Create, Update, or Delete action on the replica as a
            percentage.

          - **KMSMasterKeyId** *(string) --*

            The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
            encryption.

          - **ProvisionedThroughputOverride** *(dict) --*

            Replica-specific provisioned throughput. If not described, uses the source table's
            provisioned throughput settings.

            - **ReadCapacityUnits** *(integer) --*

              Replica-specific read capacity units. If not specified, uses the source table's read
              capacity settings.

          - **GlobalSecondaryIndexes** *(list) --*

            Replica-specific global secondary index settings.

            - *(dict) --*

              Represents the properties of a replica global secondary index.

              - **IndexName** *(string) --*

                The name of the global secondary index.

              - **ProvisionedThroughputOverride** *(dict) --*

                If not described, uses the source table GSI's read capacity settings.

                - **ReadCapacityUnits** *(integer) --*

                  Replica-specific read capacity units. If not specified, uses the source table's
                  read capacity settings.

      - **RestoreSummary** *(dict) --*

        Contains details for the restore.

        - **SourceBackupArn** *(string) --*

          The Amazon Resource Name (ARN) of the backup from which the table was restored.

        - **SourceTableArn** *(string) --*

          The ARN of the source table of the backup that is being restored.

        - **RestoreDateTime** *(datetime) --*

          Point in time or source backup time.

        - **RestoreInProgress** *(boolean) --*

          Indicates if a restore is in progress or not.

      - **SSEDescription** *(dict) --*

        The description of the server-side encryption status on the specified table.

        - **Status** *(string) --*

          Represents the current state of server-side encryption. The only supported values are:

          * ``ENABLED`` - Server-side encryption is enabled.

          * ``UPDATING`` - Server-side encryption is being updated.

        - **SSEType** *(string) --*

          Server-side encryption type. The only supported value is:

          * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
          stored in your account and is managed by AWS KMS (AWS KMS charges apply).

        - **KMSMasterKeyArn** *(string) --*

          The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeBackupResponseBackupDescriptionBackupDetailsTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionBackupDetailsTypeDef",
    {
        "BackupArn": str,
        "BackupName": str,
        "BackupSizeBytes": int,
        "BackupStatus": str,
        "BackupType": str,
        "BackupCreationDateTime": datetime,
        "BackupExpiryDateTime": datetime,
    },
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionBackupDetailsTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionBackupDetailsTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescription` `BackupDetails`

    Contains the details of the backup created for the table.

    - **BackupArn** *(string) --*

      ARN associated with the backup.

    - **BackupName** *(string) --*

      Name of the requested backup.

    - **BackupSizeBytes** *(integer) --*

      Size of the backup in bytes.

    - **BackupStatus** *(string) --*

      Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

    - **BackupType** *(string) --*

      BackupType:

      * ``USER`` - You create and manage these using the on-demand backup feature.

      * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
      backup is automatically created and is retained for 35 days (at no additional cost).
      System backups allow you to restore the deleted table to the state it was in just before
      the point of deletion.

      * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

    - **BackupCreationDateTime** *(datetime) --*

      Time at which the backup was created. This is the request time of the backup.

    - **BackupExpiryDateTime** *(datetime) --*

      Time at which the automatic on-demand backup created by DynamoDB will expire. This
      ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableDetails` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
    partition key). A composite primary key would require one ``KeySchemaElement`` for the
    partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
    The data type must be one of String, Number, or Binary. The attribute cannot be nested
    within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef",
    {"ReadCapacityUnits": int, "WriteCapacityUnits": int},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableDetails` `ProvisionedThroughput`

    Read IOPs and Write IOPS on the table when the backup was created.

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . For more information, see `Specifying Read and
      Write Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write
      Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsTypeDef",
    {
        "TableName": str,
        "TableId": str,
        "TableArn": str,
        "TableSizeBytes": int,
        "KeySchema": List[
            ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsKeySchemaTypeDef
        ],
        "TableCreationDateTime": datetime,
        "ProvisionedThroughput": ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsProvisionedThroughputTypeDef,
        "ItemCount": int,
        "BillingMode": str,
    },
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescription` `SourceTableDetails`

    Contains the details of the table when the backup was created.

    - **TableName** *(string) --*

      The name of the table for which the backup was created.

    - **TableId** *(string) --*

      Unique identifier for the table for which the backup was created.

    - **TableArn** *(string) --*

      ARN of the table for which backup was created.

    - **TableSizeBytes** *(integer) --*

      Size of the table in bytes. Note that this is an approximate value.

    - **KeySchema** *(list) --*

      Schema of the table.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
        partition key). A composite primary key would require one ``KeySchemaElement`` for the
        partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
        The data type must be one of String, Number, or Binary. The attribute cannot be nested
        within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **TableCreationDateTime** *(datetime) --*

      Time when the source table was created.

    - **ProvisionedThroughput** *(dict) --*

      Read IOPs and Write IOPS on the table when the backup was created.

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . For more information, see `Specifying Read and
        Write Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` . For more information, see `Specifying Read and Write
        Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **ItemCount** *(integer) --*

      Number of items in the table. Note that this is an approximate value.

    - **BillingMode** *(string) --*

      Controls how you are charged for read and write throughput and how you manage capacity.
      This setting can be changed later.

      * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
      using ``PROVISIONED`` for predictable workloads.

      * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
      recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the
    attributes that make up the primary key of a table, or the key attributes of an
    index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term
        "range attribute" derives from the way DynamoDB stores items with the same
        partition key physically close together, in sorted order by the sort key value.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index.
      The list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    {"ReadCapacityUnits": int, "WriteCapacityUnits": int},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexes` `ProvisionedThroughput`

    Represents the provisioned throughput settings for the specified global secondary
    index.

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . For more information, see `Specifying Read and
      Write Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write
      Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

      If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProjectionTypeDef,
        "ProvisionedThroughput": ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesProvisionedThroughputTypeDef,
    },
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetails` `GlobalSecondaryIndexes`

    Represents the properties of a global secondary index for the table when the backup was
    created.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for a global secondary index, which consists of one or more
      pairs of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the
        attributes that make up the primary key of a table, or the key attributes of an
        index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term
            "range attribute" derives from the way DynamoDB stores items with the same
            partition key physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index.
        The list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **ProvisionedThroughput** *(dict) --*

      Represents the provisioned throughput settings for the specified global secondary
      index.

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . For more information, see `Specifying Read and
        Write Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` . For more information, see `Specifying Read and Write
        Requirements
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
        in the *Amazon DynamoDB Developer Guide* .

        If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the
    attributes that make up the primary key of a table, or the key attributes of an
    index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term
        "range attribute" derives from the way DynamoDB stores items with the same
        partition key physically close together, in sorted order by the sort key value.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index.
      The list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesProjectionTypeDef,
    },
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetails` `LocalSecondaryIndexes`

    Represents the properties of a local secondary index for the table when the backup was
    created.

    - **IndexName** *(string) --*

      Represents the name of the local secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for a local secondary index, which consists of one or more
      pairs of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the
        attributes that make up the primary key of a table, or the key attributes of an
        index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term
            "range attribute" derives from the way DynamoDB stores items with the same
            partition key physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index.
        The list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef",
    {"Status": str, "SSEType": str, "KMSMasterKeyArn": str},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetails` `SSEDescription`

    The description of the server-side encryption status on the table when the backup was
    created.

    - **Status** *(string) --*

      Represents the current state of server-side encryption. The only supported values are:

      * ``ENABLED`` - Server-side encryption is enabled.

      * ``UPDATING`` - Server-side encryption is being updated.

    - **SSEType** *(string) --*

      Server-side encryption type. The only supported value is:

      * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
      stored in your account and is managed by AWS KMS (AWS KMS charges apply).

    - **KMSMasterKeyArn** *(string) --*

      The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef",
    {"StreamEnabled": bool, "StreamViewType": str},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetails` `StreamDescription`

    Stream settings on the table when the backup was created.

    - **StreamEnabled** *(boolean) --*

      Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

    - **StreamViewType** *(string) --*

      When an item in the table is modified, ``StreamViewType`` determines what information
      is written to the stream for this table. Valid values for ``StreamViewType`` are:

      * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
      stream.

      * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
      the stream.

      * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
      the stream.

      * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
      to the stream.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef",
    {"TimeToLiveStatus": str, "AttributeName": str},
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetails` `TimeToLiveDescription`

    Time to Live settings on the table when the backup was created.

    - **TimeToLiveStatus** *(string) --*

      The TTL status for the table.

    - **AttributeName** *(string) --*

      The name of the TTL attribute for items in the table.
    """


_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef",
    {
        "LocalSecondaryIndexes": List[
            ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": List[
            ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsGlobalSecondaryIndexesTypeDef
        ],
        "StreamDescription": ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsStreamDescriptionTypeDef,
        "TimeToLiveDescription": ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTimeToLiveDescriptionTypeDef,
        "SSEDescription": ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsSSEDescriptionTypeDef,
    },
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponseBackupDescription` `SourceTableFeatureDetails`

    Contains the details of the features enabled on the table when the backup was created. For
    example, LSIs, GSIs, streams, TTL.

    - **LocalSecondaryIndexes** *(list) --*

      Represents the LSI properties for the table when the backup was created. It includes the
      IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.

      - *(dict) --*

        Represents the properties of a local secondary index for the table when the backup was
        created.

        - **IndexName** *(string) --*

          Represents the name of the local secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for a local secondary index, which consists of one or more
          pairs of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the
            attributes that make up the primary key of a table, or the key attributes of an
            index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term
                "range attribute" derives from the way DynamoDB stores items with the same
                partition key physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index.
            The list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

    - **GlobalSecondaryIndexes** *(list) --*

      Represents the GSI properties for the table when the backup was created. It includes the
      IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at
      the time of backup.

      - *(dict) --*

        Represents the properties of a global secondary index for the table when the backup was
        created.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for a global secondary index, which consists of one or more
          pairs of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the
            attributes that make up the primary key of a table, or the key attributes of an
            index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term
                "range attribute" derives from the way DynamoDB stores items with the same
                partition key physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index.
            The list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **ProvisionedThroughput** *(dict) --*

          Represents the provisioned throughput settings for the specified global secondary
          index.

          - **ReadCapacityUnits** *(integer) --*

            The maximum number of strongly consistent reads consumed per second before DynamoDB
            returns a ``ThrottlingException`` . For more information, see `Specifying Read and
            Write Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

          - **WriteCapacityUnits** *(integer) --*

            The maximum number of writes consumed per second before DynamoDB returns a
            ``ThrottlingException`` . For more information, see `Specifying Read and Write
            Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

    - **StreamDescription** *(dict) --*

      Stream settings on the table when the backup was created.

      - **StreamEnabled** *(boolean) --*

        Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

      - **StreamViewType** *(string) --*

        When an item in the table is modified, ``StreamViewType`` determines what information
        is written to the stream for this table. Valid values for ``StreamViewType`` are:

        * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
        stream.

        * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
        the stream.

        * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
        the stream.

        * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
        to the stream.

    - **TimeToLiveDescription** *(dict) --*

      Time to Live settings on the table when the backup was created.

      - **TimeToLiveStatus** *(string) --*

        The TTL status for the table.

      - **AttributeName** *(string) --*

        The name of the TTL attribute for items in the table.

    - **SSEDescription** *(dict) --*

      The description of the server-side encryption status on the table when the backup was
      created.

      - **Status** *(string) --*

        Represents the current state of server-side encryption. The only supported values are:

        * ``ENABLED`` - Server-side encryption is enabled.

        * ``UPDATING`` - Server-side encryption is being updated.

      - **SSEType** *(string) --*

        Server-side encryption type. The only supported value is:

        * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
        stored in your account and is managed by AWS KMS (AWS KMS charges apply).

      - **KMSMasterKeyArn** *(string) --*

        The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeBackupResponseBackupDescriptionTypeDef = TypedDict(
    "_ClientDescribeBackupResponseBackupDescriptionTypeDef",
    {
        "BackupDetails": ClientDescribeBackupResponseBackupDescriptionBackupDetailsTypeDef,
        "SourceTableDetails": ClientDescribeBackupResponseBackupDescriptionSourceTableDetailsTypeDef,
        "SourceTableFeatureDetails": ClientDescribeBackupResponseBackupDescriptionSourceTableFeatureDetailsTypeDef,
    },
    total=False,
)


class ClientDescribeBackupResponseBackupDescriptionTypeDef(
    _ClientDescribeBackupResponseBackupDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeBackupResponse` `BackupDescription`

    Contains the description of the backup created for the table.

    - **BackupDetails** *(dict) --*

      Contains the details of the backup created for the table.

      - **BackupArn** *(string) --*

        ARN associated with the backup.

      - **BackupName** *(string) --*

        Name of the requested backup.

      - **BackupSizeBytes** *(integer) --*

        Size of the backup in bytes.

      - **BackupStatus** *(string) --*

        Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

      - **BackupType** *(string) --*

        BackupType:

        * ``USER`` - You create and manage these using the on-demand backup feature.

        * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
        backup is automatically created and is retained for 35 days (at no additional cost).
        System backups allow you to restore the deleted table to the state it was in just before
        the point of deletion.

        * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

      - **BackupCreationDateTime** *(datetime) --*

        Time at which the backup was created. This is the request time of the backup.

      - **BackupExpiryDateTime** *(datetime) --*

        Time at which the automatic on-demand backup created by DynamoDB will expire. This
        ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.

    - **SourceTableDetails** *(dict) --*

      Contains the details of the table when the backup was created.

      - **TableName** *(string) --*

        The name of the table for which the backup was created.

      - **TableId** *(string) --*

        Unique identifier for the table for which the backup was created.

      - **TableArn** *(string) --*

        ARN of the table for which backup was created.

      - **TableSizeBytes** *(integer) --*

        Size of the table in bytes. Note that this is an approximate value.

      - **KeySchema** *(list) --*

        Schema of the table.

        - *(dict) --*

          Represents *a single element* of a key schema. A key schema specifies the attributes
          that make up the primary key of a table, or the key attributes of an index.

          A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
          example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
          partition key). A composite primary key would require one ``KeySchemaElement`` for the
          partition key, and another ``KeySchemaElement`` for the sort key.

          A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
          The data type must be one of String, Number, or Binary. The attribute cannot be nested
          within a List or a Map.

          - **AttributeName** *(string) --*

            The name of a key attribute.

          - **KeyType** *(string) --*

            The role that this key attribute will assume:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

      - **TableCreationDateTime** *(datetime) --*

        Time when the source table was created.

      - **ProvisionedThroughput** *(dict) --*

        Read IOPs and Write IOPS on the table when the backup was created.

        - **ReadCapacityUnits** *(integer) --*

          The maximum number of strongly consistent reads consumed per second before DynamoDB
          returns a ``ThrottlingException`` . For more information, see `Specifying Read and
          Write Requirements
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
          in the *Amazon DynamoDB Developer Guide* .

          If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

        - **WriteCapacityUnits** *(integer) --*

          The maximum number of writes consumed per second before DynamoDB returns a
          ``ThrottlingException`` . For more information, see `Specifying Read and Write
          Requirements
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
          in the *Amazon DynamoDB Developer Guide* .

          If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **ItemCount** *(integer) --*

        Number of items in the table. Note that this is an approximate value.

      - **BillingMode** *(string) --*

        Controls how you are charged for read and write throughput and how you manage capacity.
        This setting can be changed later.

        * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
        using ``PROVISIONED`` for predictable workloads.

        * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
        recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

    - **SourceTableFeatureDetails** *(dict) --*

      Contains the details of the features enabled on the table when the backup was created. For
      example, LSIs, GSIs, streams, TTL.

      - **LocalSecondaryIndexes** *(list) --*

        Represents the LSI properties for the table when the backup was created. It includes the
        IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.

        - *(dict) --*

          Represents the properties of a local secondary index for the table when the backup was
          created.

          - **IndexName** *(string) --*

            Represents the name of the local secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for a local secondary index, which consists of one or more
            pairs of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the
              attributes that make up the primary key of a table, or the key attributes of an
              index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term
                  "range attribute" derives from the way DynamoDB stores items with the same
                  partition key physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index.
              The list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

      - **GlobalSecondaryIndexes** *(list) --*

        Represents the GSI properties for the table when the backup was created. It includes the
        IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at
        the time of backup.

        - *(dict) --*

          Represents the properties of a global secondary index for the table when the backup was
          created.

          - **IndexName** *(string) --*

            The name of the global secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for a global secondary index, which consists of one or more
            pairs of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the
              attributes that make up the primary key of a table, or the key attributes of an
              index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term
                  "range attribute" derives from the way DynamoDB stores items with the same
                  partition key physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index.
              The list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **ProvisionedThroughput** *(dict) --*

            Represents the provisioned throughput settings for the specified global secondary
            index.

            - **ReadCapacityUnits** *(integer) --*

              The maximum number of strongly consistent reads consumed per second before DynamoDB
              returns a ``ThrottlingException`` . For more information, see `Specifying Read and
              Write Requirements
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
              in the *Amazon DynamoDB Developer Guide* .

              If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

            - **WriteCapacityUnits** *(integer) --*

              The maximum number of writes consumed per second before DynamoDB returns a
              ``ThrottlingException`` . For more information, see `Specifying Read and Write
              Requirements
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
              in the *Amazon DynamoDB Developer Guide* .

              If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

      - **StreamDescription** *(dict) --*

        Stream settings on the table when the backup was created.

        - **StreamEnabled** *(boolean) --*

          Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

        - **StreamViewType** *(string) --*

          When an item in the table is modified, ``StreamViewType`` determines what information
          is written to the stream for this table. Valid values for ``StreamViewType`` are:

          * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
          stream.

          * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
          the stream.

          * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
          the stream.

          * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
          to the stream.

      - **TimeToLiveDescription** *(dict) --*

        Time to Live settings on the table when the backup was created.

        - **TimeToLiveStatus** *(string) --*

          The TTL status for the table.

        - **AttributeName** *(string) --*

          The name of the TTL attribute for items in the table.

      - **SSEDescription** *(dict) --*

        The description of the server-side encryption status on the table when the backup was
        created.

        - **Status** *(string) --*

          Represents the current state of server-side encryption. The only supported values are:

          * ``ENABLED`` - Server-side encryption is enabled.

          * ``UPDATING`` - Server-side encryption is being updated.

        - **SSEType** *(string) --*

          Server-side encryption type. The only supported value is:

          * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
          stored in your account and is managed by AWS KMS (AWS KMS charges apply).

        - **KMSMasterKeyArn** *(string) --*

          The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeBackupResponseTypeDef = TypedDict(
    "_ClientDescribeBackupResponseTypeDef",
    {"BackupDescription": ClientDescribeBackupResponseBackupDescriptionTypeDef},
    total=False,
)


class ClientDescribeBackupResponseTypeDef(_ClientDescribeBackupResponseTypeDef):
    """
    Type definition for `ClientDescribeBackup` `Response`

    - **BackupDescription** *(dict) --*

      Contains the description of the backup created for the table.

      - **BackupDetails** *(dict) --*

        Contains the details of the backup created for the table.

        - **BackupArn** *(string) --*

          ARN associated with the backup.

        - **BackupName** *(string) --*

          Name of the requested backup.

        - **BackupSizeBytes** *(integer) --*

          Size of the backup in bytes.

        - **BackupStatus** *(string) --*

          Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

        - **BackupType** *(string) --*

          BackupType:

          * ``USER`` - You create and manage these using the on-demand backup feature.

          * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
          backup is automatically created and is retained for 35 days (at no additional cost).
          System backups allow you to restore the deleted table to the state it was in just before
          the point of deletion.

          * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

        - **BackupCreationDateTime** *(datetime) --*

          Time at which the backup was created. This is the request time of the backup.

        - **BackupExpiryDateTime** *(datetime) --*

          Time at which the automatic on-demand backup created by DynamoDB will expire. This
          ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.

      - **SourceTableDetails** *(dict) --*

        Contains the details of the table when the backup was created.

        - **TableName** *(string) --*

          The name of the table for which the backup was created.

        - **TableId** *(string) --*

          Unique identifier for the table for which the backup was created.

        - **TableArn** *(string) --*

          ARN of the table for which backup was created.

        - **TableSizeBytes** *(integer) --*

          Size of the table in bytes. Note that this is an approximate value.

        - **KeySchema** *(list) --*

          Schema of the table.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for the
            partition key). A composite primary key would require one ``KeySchemaElement`` for the
            partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
            The data type must be one of String, Number, or Binary. The attribute cannot be nested
            within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term "hash
                attribute" derives from DynamoDB's usage of an internal hash function to evenly
                distribute data items across partitions, based on their partition key values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **TableCreationDateTime** *(datetime) --*

          Time when the source table was created.

        - **ProvisionedThroughput** *(dict) --*

          Read IOPs and Write IOPS on the table when the backup was created.

          - **ReadCapacityUnits** *(integer) --*

            The maximum number of strongly consistent reads consumed per second before DynamoDB
            returns a ``ThrottlingException`` . For more information, see `Specifying Read and
            Write Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

          - **WriteCapacityUnits** *(integer) --*

            The maximum number of writes consumed per second before DynamoDB returns a
            ``ThrottlingException`` . For more information, see `Specifying Read and Write
            Requirements
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
            in the *Amazon DynamoDB Developer Guide* .

            If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

        - **ItemCount** *(integer) --*

          Number of items in the table. Note that this is an approximate value.

        - **BillingMode** *(string) --*

          Controls how you are charged for read and write throughput and how you manage capacity.
          This setting can be changed later.

          * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
          using ``PROVISIONED`` for predictable workloads.

          * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
          recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

      - **SourceTableFeatureDetails** *(dict) --*

        Contains the details of the features enabled on the table when the backup was created. For
        example, LSIs, GSIs, streams, TTL.

        - **LocalSecondaryIndexes** *(list) --*

          Represents the LSI properties for the table when the backup was created. It includes the
          IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.

          - *(dict) --*

            Represents the properties of a local secondary index for the table when the backup was
            created.

            - **IndexName** *(string) --*

              Represents the name of the local secondary index.

            - **KeySchema** *(list) --*

              The complete key schema for a local secondary index, which consists of one or more
              pairs of attribute names and key types:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term "hash
                attribute" derives from DynamoDB's usage of an internal hash function to evenly
                distribute data items across partitions, based on their partition key values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

              - *(dict) --*

                Represents *a single element* of a key schema. A key schema specifies the
                attributes that make up the primary key of a table, or the key attributes of an
                index.

                A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
                example, a simple primary key would be represented by one ``KeySchemaElement`` (for
                the partition key). A composite primary key would require one ``KeySchemaElement``
                for the partition key, and another ``KeySchemaElement`` for the sort key.

                A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
                attribute). The data type must be one of String, Number, or Binary. The attribute
                cannot be nested within a List or a Map.

                - **AttributeName** *(string) --*

                  The name of a key attribute.

                - **KeyType** *(string) --*

                  The role that this key attribute will assume:

                  * ``HASH`` - partition key

                  * ``RANGE`` - sort key

                  .. note::

                    The partition key of an item is also known as its *hash attribute* . The term
                    "hash attribute" derives from DynamoDB's usage of an internal hash function to
                    evenly distribute data items across partitions, based on their partition key
                    values.

                    The sort key of an item is also known as its *range attribute* . The term
                    "range attribute" derives from the way DynamoDB stores items with the same
                    partition key physically close together, in sorted order by the sort key value.

            - **Projection** *(dict) --*

              Represents attributes that are copied (projected) from the table into the global
              secondary index. These are in addition to the primary key attributes and index key
              attributes, which are automatically projected.

              - **ProjectionType** *(string) --*

                The set of attributes that are projected into the index:

                * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

                * ``INCLUDE`` - Only the specified table attributes are projected into the index.
                The list of projected attributes is in ``NonKeyAttributes`` .

                * ``ALL`` - All of the table attributes are projected into the index.

              - **NonKeyAttributes** *(list) --*

                Represents the non-key attribute names which will be projected into the index.

                For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
                all of the local secondary indexes, must not exceed 20. If you project the same
                attribute into two different indexes, this counts as two distinct attributes when
                determining the total.

                - *(string) --*

        - **GlobalSecondaryIndexes** *(list) --*

          Represents the GSI properties for the table when the backup was created. It includes the
          IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at
          the time of backup.

          - *(dict) --*

            Represents the properties of a global secondary index for the table when the backup was
            created.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **KeySchema** *(list) --*

              The complete key schema for a global secondary index, which consists of one or more
              pairs of attribute names and key types:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term "hash
                attribute" derives from DynamoDB's usage of an internal hash function to evenly
                distribute data items across partitions, based on their partition key values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

              - *(dict) --*

                Represents *a single element* of a key schema. A key schema specifies the
                attributes that make up the primary key of a table, or the key attributes of an
                index.

                A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
                example, a simple primary key would be represented by one ``KeySchemaElement`` (for
                the partition key). A composite primary key would require one ``KeySchemaElement``
                for the partition key, and another ``KeySchemaElement`` for the sort key.

                A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
                attribute). The data type must be one of String, Number, or Binary. The attribute
                cannot be nested within a List or a Map.

                - **AttributeName** *(string) --*

                  The name of a key attribute.

                - **KeyType** *(string) --*

                  The role that this key attribute will assume:

                  * ``HASH`` - partition key

                  * ``RANGE`` - sort key

                  .. note::

                    The partition key of an item is also known as its *hash attribute* . The term
                    "hash attribute" derives from DynamoDB's usage of an internal hash function to
                    evenly distribute data items across partitions, based on their partition key
                    values.

                    The sort key of an item is also known as its *range attribute* . The term
                    "range attribute" derives from the way DynamoDB stores items with the same
                    partition key physically close together, in sorted order by the sort key value.

            - **Projection** *(dict) --*

              Represents attributes that are copied (projected) from the table into the global
              secondary index. These are in addition to the primary key attributes and index key
              attributes, which are automatically projected.

              - **ProjectionType** *(string) --*

                The set of attributes that are projected into the index:

                * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

                * ``INCLUDE`` - Only the specified table attributes are projected into the index.
                The list of projected attributes is in ``NonKeyAttributes`` .

                * ``ALL`` - All of the table attributes are projected into the index.

              - **NonKeyAttributes** *(list) --*

                Represents the non-key attribute names which will be projected into the index.

                For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
                all of the local secondary indexes, must not exceed 20. If you project the same
                attribute into two different indexes, this counts as two distinct attributes when
                determining the total.

                - *(string) --*

            - **ProvisionedThroughput** *(dict) --*

              Represents the provisioned throughput settings for the specified global secondary
              index.

              - **ReadCapacityUnits** *(integer) --*

                The maximum number of strongly consistent reads consumed per second before DynamoDB
                returns a ``ThrottlingException`` . For more information, see `Specifying Read and
                Write Requirements
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
                in the *Amazon DynamoDB Developer Guide* .

                If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

              - **WriteCapacityUnits** *(integer) --*

                The maximum number of writes consumed per second before DynamoDB returns a
                ``ThrottlingException`` . For more information, see `Specifying Read and Write
                Requirements
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
                in the *Amazon DynamoDB Developer Guide* .

                If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.

        - **StreamDescription** *(dict) --*

          Stream settings on the table when the backup was created.

          - **StreamEnabled** *(boolean) --*

            Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

          - **StreamViewType** *(string) --*

            When an item in the table is modified, ``StreamViewType`` determines what information
            is written to the stream for this table. Valid values for ``StreamViewType`` are:

            * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the
            stream.

            * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to
            the stream.

            * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
            the stream.

            * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
            to the stream.

        - **TimeToLiveDescription** *(dict) --*

          Time to Live settings on the table when the backup was created.

          - **TimeToLiveStatus** *(string) --*

            The TTL status for the table.

          - **AttributeName** *(string) --*

            The name of the TTL attribute for items in the table.

        - **SSEDescription** *(dict) --*

          The description of the server-side encryption status on the table when the backup was
          created.

          - **Status** *(string) --*

            Represents the current state of server-side encryption. The only supported values are:

            * ``ENABLED`` - Server-side encryption is enabled.

            * ``UPDATING`` - Server-side encryption is being updated.

          - **SSEType** *(string) --*

            Server-side encryption type. The only supported value is:

            * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
            stored in your account and is managed by AWS KMS (AWS KMS charges apply).

          - **KMSMasterKeyArn** *(string) --*

            The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionPointInTimeRecoveryDescriptionTypeDef = TypedDict(
    "_ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionPointInTimeRecoveryDescriptionTypeDef",
    {
        "PointInTimeRecoveryStatus": str,
        "EarliestRestorableDateTime": datetime,
        "LatestRestorableDateTime": datetime,
    },
    total=False,
)


class ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionPointInTimeRecoveryDescriptionTypeDef(
    _ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionPointInTimeRecoveryDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeContinuousBackupsResponseContinuousBackupsDescription` `PointInTimeRecoveryDescription`

    The description of the point in time recovery settings applied to the table.

    - **PointInTimeRecoveryStatus** *(string) --*

      The current state of point in time recovery:

      * ``ENABLING`` - Point in time recovery is being enabled.

      * ``ENABLED`` - Point in time recovery is enabled.

      * ``DISABLED`` - Point in time recovery is disabled.

    - **EarliestRestorableDateTime** *(datetime) --*

      Specifies the earliest point in time you can restore your table to. You can restore your
      table to any point in time during the last 35 days.

    - **LatestRestorableDateTime** *(datetime) --*

       ``LatestRestorableDateTime`` is typically 5 minutes before the current time.
    """


_ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionTypeDef = TypedDict(
    "_ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionTypeDef",
    {
        "ContinuousBackupsStatus": str,
        "PointInTimeRecoveryDescription": ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionPointInTimeRecoveryDescriptionTypeDef,
    },
    total=False,
)


class ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionTypeDef(
    _ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeContinuousBackupsResponse` `ContinuousBackupsDescription`

    Represents the continuous backups and point in time recovery settings on the table.

    - **ContinuousBackupsStatus** *(string) --*

       ``ContinuousBackupsStatus`` can be one of the following states: ENABLED, DISABLED

    - **PointInTimeRecoveryDescription** *(dict) --*

      The description of the point in time recovery settings applied to the table.

      - **PointInTimeRecoveryStatus** *(string) --*

        The current state of point in time recovery:

        * ``ENABLING`` - Point in time recovery is being enabled.

        * ``ENABLED`` - Point in time recovery is enabled.

        * ``DISABLED`` - Point in time recovery is disabled.

      - **EarliestRestorableDateTime** *(datetime) --*

        Specifies the earliest point in time you can restore your table to. You can restore your
        table to any point in time during the last 35 days.

      - **LatestRestorableDateTime** *(datetime) --*

         ``LatestRestorableDateTime`` is typically 5 minutes before the current time.
    """


_ClientDescribeContinuousBackupsResponseTypeDef = TypedDict(
    "_ClientDescribeContinuousBackupsResponseTypeDef",
    {
        "ContinuousBackupsDescription": ClientDescribeContinuousBackupsResponseContinuousBackupsDescriptionTypeDef
    },
    total=False,
)


class ClientDescribeContinuousBackupsResponseTypeDef(
    _ClientDescribeContinuousBackupsResponseTypeDef
):
    """
    Type definition for `ClientDescribeContinuousBackups` `Response`

    - **ContinuousBackupsDescription** *(dict) --*

      Represents the continuous backups and point in time recovery settings on the table.

      - **ContinuousBackupsStatus** *(string) --*

         ``ContinuousBackupsStatus`` can be one of the following states: ENABLED, DISABLED

      - **PointInTimeRecoveryDescription** *(dict) --*

        The description of the point in time recovery settings applied to the table.

        - **PointInTimeRecoveryStatus** *(string) --*

          The current state of point in time recovery:

          * ``ENABLING`` - Point in time recovery is being enabled.

          * ``ENABLED`` - Point in time recovery is enabled.

          * ``DISABLED`` - Point in time recovery is disabled.

        - **EarliestRestorableDateTime** *(datetime) --*

          Specifies the earliest point in time you can restore your table to. You can restore your
          table to any point in time during the last 35 days.

        - **LatestRestorableDateTime** *(datetime) --*

           ``LatestRestorableDateTime`` is typically 5 minutes before the current time.
    """


_ClientDescribeEndpointsResponseEndpointsTypeDef = TypedDict(
    "_ClientDescribeEndpointsResponseEndpointsTypeDef",
    {"Address": str, "CachePeriodInMinutes": int},
    total=False,
)


class ClientDescribeEndpointsResponseEndpointsTypeDef(
    _ClientDescribeEndpointsResponseEndpointsTypeDef
):
    """
    Type definition for `ClientDescribeEndpointsResponse` `Endpoints`

    An endpoint information details.

    - **Address** *(string) --*

      IP address of the endpoint.

    - **CachePeriodInMinutes** *(integer) --*

      Endpoint cache time to live (TTL) value.
    """


_ClientDescribeEndpointsResponseTypeDef = TypedDict(
    "_ClientDescribeEndpointsResponseTypeDef",
    {"Endpoints": List[ClientDescribeEndpointsResponseEndpointsTypeDef]},
    total=False,
)


class ClientDescribeEndpointsResponseTypeDef(_ClientDescribeEndpointsResponseTypeDef):
    """
    Type definition for `ClientDescribeEndpoints` `Response`

    - **Endpoints** *(list) --*

      List of endpoints.

      - *(dict) --*

        An endpoint information details.

        - **Address** *(string) --*

          IP address of the endpoint.

        - **CachePeriodInMinutes** *(integer) --*

          Endpoint cache time to live (TTL) value.
    """


_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef(
    _ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexes` `ProvisionedThroughputOverride`

    If not described, uses the source table GSI's read capacity settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's
      read capacity settings.
    """


_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "ProvisionedThroughputOverride": ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef,
    },
    total=False,
)


class ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef(
    _ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroup` `GlobalSecondaryIndexes`

    Represents the properties of a replica global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **ProvisionedThroughputOverride** *(dict) --*

      If not described, uses the source table GSI's read capacity settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's
        read capacity settings.
    """


_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef(
    _ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroup` `ProvisionedThroughputOverride`

    Replica-specific provisioned throughput. If not described, uses the source table's
    provisioned throughput settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's read
      capacity settings.
    """


_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef = TypedDict(
    "_ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef",
    {
        "RegionName": str,
        "ReplicaStatus": str,
        "ReplicaStatusDescription": str,
        "ReplicaStatusPercentProgress": str,
        "KMSMasterKeyId": str,
        "ProvisionedThroughputOverride": ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupProvisionedThroughputOverrideTypeDef,
        "GlobalSecondaryIndexes": List[
            ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef(
    _ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableResponseGlobalTableDescription` `ReplicationGroup`

    Contains the details of the replica.

    - **RegionName** *(string) --*

      The name of the Region.

    - **ReplicaStatus** *(string) --*

      The current state of the replica:

      * ``CREATING`` - The replica is being created.

      * ``UPDATING`` - The replica is being updated.

      * ``DELETING`` - The replica is being deleted.

      * ``ACTIVE`` - The replica is ready for use.

    - **ReplicaStatusDescription** *(string) --*

      Detailed information about the replica status.

    - **ReplicaStatusPercentProgress** *(string) --*

      Specifies the progress of a Create, Update, or Delete action on the replica as a
      percentage.

    - **KMSMasterKeyId** *(string) --*

      The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
      encryption.

    - **ProvisionedThroughputOverride** *(dict) --*

      Replica-specific provisioned throughput. If not described, uses the source table's
      provisioned throughput settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's read
        capacity settings.

    - **GlobalSecondaryIndexes** *(list) --*

      Replica-specific global secondary index settings.

      - *(dict) --*

        Represents the properties of a replica global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **ProvisionedThroughputOverride** *(dict) --*

          If not described, uses the source table GSI's read capacity settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's
            read capacity settings.
    """


_ClientDescribeGlobalTableResponseGlobalTableDescriptionTypeDef = TypedDict(
    "_ClientDescribeGlobalTableResponseGlobalTableDescriptionTypeDef",
    {
        "ReplicationGroup": List[
            ClientDescribeGlobalTableResponseGlobalTableDescriptionReplicationGroupTypeDef
        ],
        "GlobalTableArn": str,
        "CreationDateTime": datetime,
        "GlobalTableStatus": str,
        "GlobalTableName": str,
    },
    total=False,
)


class ClientDescribeGlobalTableResponseGlobalTableDescriptionTypeDef(
    _ClientDescribeGlobalTableResponseGlobalTableDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableResponse` `GlobalTableDescription`

    Contains the details of the global table.

    - **ReplicationGroup** *(list) --*

      The Regions where the global table has replicas.

      - *(dict) --*

        Contains the details of the replica.

        - **RegionName** *(string) --*

          The name of the Region.

        - **ReplicaStatus** *(string) --*

          The current state of the replica:

          * ``CREATING`` - The replica is being created.

          * ``UPDATING`` - The replica is being updated.

          * ``DELETING`` - The replica is being deleted.

          * ``ACTIVE`` - The replica is ready for use.

        - **ReplicaStatusDescription** *(string) --*

          Detailed information about the replica status.

        - **ReplicaStatusPercentProgress** *(string) --*

          Specifies the progress of a Create, Update, or Delete action on the replica as a
          percentage.

        - **KMSMasterKeyId** *(string) --*

          The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
          encryption.

        - **ProvisionedThroughputOverride** *(dict) --*

          Replica-specific provisioned throughput. If not described, uses the source table's
          provisioned throughput settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's read
            capacity settings.

        - **GlobalSecondaryIndexes** *(list) --*

          Replica-specific global secondary index settings.

          - *(dict) --*

            Represents the properties of a replica global secondary index.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **ProvisionedThroughputOverride** *(dict) --*

              If not described, uses the source table GSI's read capacity settings.

              - **ReadCapacityUnits** *(integer) --*

                Replica-specific read capacity units. If not specified, uses the source table's
                read capacity settings.

    - **GlobalTableArn** *(string) --*

      The unique identifier of the global table.

    - **CreationDateTime** *(datetime) --*

      The creation time of the global table.

    - **GlobalTableStatus** *(string) --*

      The current state of the global table:

      * ``CREATING`` - The global table is being created.

      * ``UPDATING`` - The global table is being updated.

      * ``DELETING`` - The global table is being deleted.

      * ``ACTIVE`` - The global table is ready for use.

    - **GlobalTableName** *(string) --*

      The global table name.
    """


_ClientDescribeGlobalTableResponseTypeDef = TypedDict(
    "_ClientDescribeGlobalTableResponseTypeDef",
    {
        "GlobalTableDescription": ClientDescribeGlobalTableResponseGlobalTableDescriptionTypeDef
    },
    total=False,
)


class ClientDescribeGlobalTableResponseTypeDef(
    _ClientDescribeGlobalTableResponseTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTable` `Response`

    - **GlobalTableDescription** *(dict) --*

      Contains the details of the global table.

      - **ReplicationGroup** *(list) --*

        The Regions where the global table has replicas.

        - *(dict) --*

          Contains the details of the replica.

          - **RegionName** *(string) --*

            The name of the Region.

          - **ReplicaStatus** *(string) --*

            The current state of the replica:

            * ``CREATING`` - The replica is being created.

            * ``UPDATING`` - The replica is being updated.

            * ``DELETING`` - The replica is being deleted.

            * ``ACTIVE`` - The replica is ready for use.

          - **ReplicaStatusDescription** *(string) --*

            Detailed information about the replica status.

          - **ReplicaStatusPercentProgress** *(string) --*

            Specifies the progress of a Create, Update, or Delete action on the replica as a
            percentage.

          - **KMSMasterKeyId** *(string) --*

            The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
            encryption.

          - **ProvisionedThroughputOverride** *(dict) --*

            Replica-specific provisioned throughput. If not described, uses the source table's
            provisioned throughput settings.

            - **ReadCapacityUnits** *(integer) --*

              Replica-specific read capacity units. If not specified, uses the source table's read
              capacity settings.

          - **GlobalSecondaryIndexes** *(list) --*

            Replica-specific global secondary index settings.

            - *(dict) --*

              Represents the properties of a replica global secondary index.

              - **IndexName** *(string) --*

                The name of the global secondary index.

              - **ProvisionedThroughputOverride** *(dict) --*

                If not described, uses the source table GSI's read capacity settings.

                - **ReadCapacityUnits** *(integer) --*

                  Replica-specific read capacity units. If not specified, uses the source table's
                  read capacity settings.

      - **GlobalTableArn** *(string) --*

        The unique identifier of the global table.

      - **CreationDateTime** *(datetime) --*

        The creation time of the global table.

      - **GlobalTableStatus** *(string) --*

        The current state of the global table:

        * ``CREATING`` - The global table is being created.

        * ``UPDATING`` - The global table is being updated.

        * ``DELETING`` - The global table is being deleted.

        * ``ACTIVE`` - The global table is ready for use.

      - **GlobalTableName** *(string) --*

        The global table name.
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaBillingModeSummaryTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaBillingModeSummaryTypeDef",
    {"BillingMode": str, "LastUpdateToPayPerRequestDateTime": datetime},
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaBillingModeSummaryTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaBillingModeSummaryTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettings` `ReplicaBillingModeSummary`

    The read/write capacity mode of the replica.

    - **BillingMode** *(string) --*

      Controls how you are charged for read and write throughput and how you manage capacity.
      This setting can be changed later.

      * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
      using ``PROVISIONED`` for predictable workloads.

      * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
      recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

    - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

      Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity
      mode.
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If the
      value is true, scale in is disabled and the target tracking policy won't
      remove capacity from the scalable resource. Otherwise, scale in is enabled
      and the target tracking policy can remove capacity from the scalable
      resource. The default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if
      another alarm triggers a scale out policy during the cooldown period after a
      scale-in, application auto scaling scales out your scalable target
      immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in effect,
      the capacity that has been added by the previous scale out event that
      initiated the cooldown is calculated as part of the desired capacity for the
      next scale out. You should continuously (but not excessively) scale out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
      (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If the
        value is true, scale in is disabled and the target tracking policy won't
        remove capacity from the scalable resource. Otherwise, scale in is enabled
        and the target tracking policy can remove capacity from the scalable
        resource. The default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if
        another alarm triggers a scale out policy during the cooldown period after a
        scale-in, application auto scaling scales out your scalable target
        immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in effect,
        the capacity that has been added by the previous scale out event that
        initiated the cooldown is calculated as part of the desired capacity for the
        next scale out. You should continuously (but not excessively) scale out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
        (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettings` `ProvisionedReadCapacityAutoScalingSettings`

    Auto scaling settings for a global secondary index replica's read capacity units.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should be
      scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should be
      scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If the
            value is true, scale in is disabled and the target tracking policy won't
            remove capacity from the scalable resource. Otherwise, scale in is enabled
            and the target tracking policy can remove capacity from the scalable
            resource. The default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if
            another alarm triggers a scale out policy during the cooldown period after a
            scale-in, application auto scaling scales out your scalable target
            immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in effect,
            the capacity that has been added by the previous scale out event that
            initiated the cooldown is calculated as part of the desired capacity for the
            next scale out. You should continuously (but not excessively) scale out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
            (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If the
      value is true, scale in is disabled and the target tracking policy won't
      remove capacity from the scalable resource. Otherwise, scale in is enabled
      and the target tracking policy can remove capacity from the scalable
      resource. The default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if
      another alarm triggers a scale out policy during the cooldown period after a
      scale-in, application auto scaling scales out your scalable target
      immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in effect,
      the capacity that has been added by the previous scale out event that
      initiated the cooldown is calculated as part of the desired capacity for the
      next scale out. You should continuously (but not excessively) scale out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
      (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If the
        value is true, scale in is disabled and the target tracking policy won't
        remove capacity from the scalable resource. Otherwise, scale in is enabled
        and the target tracking policy can remove capacity from the scalable
        resource. The default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if
        another alarm triggers a scale out policy during the cooldown period after a
        scale-in, application auto scaling scales out your scalable target
        immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in effect,
        the capacity that has been added by the previous scale out event that
        initiated the cooldown is calculated as part of the desired capacity for the
        next scale out. You should continuously (but not excessively) scale out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
        (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettings` `ProvisionedWriteCapacityAutoScalingSettings`

    Auto scaling settings for a global secondary index replica's write capacity units.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should be
      scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should be
      scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If the
            value is true, scale in is disabled and the target tracking policy won't
            remove capacity from the scalable resource. Otherwise, scale in is enabled
            and the target tracking policy can remove capacity from the scalable
            resource. The default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if
            another alarm triggers a scale out policy during the cooldown period after a
            scale-in, application auto scaling scales out your scalable target
            immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in effect,
            the capacity that has been added by the previous scale out event that
            initiated the cooldown is calculated as part of the desired capacity for the
            next scale out. You should continuously (but not excessively) scale out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
            (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsTypeDef",
    {
        "IndexName": str,
        "IndexStatus": str,
        "ProvisionedReadCapacityUnits": int,
        "ProvisionedReadCapacityAutoScalingSettings": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedReadCapacityAutoScalingSettingsTypeDef,
        "ProvisionedWriteCapacityUnits": int,
        "ProvisionedWriteCapacityAutoScalingSettings": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsProvisionedWriteCapacityAutoScalingSettingsTypeDef,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettings` `ReplicaGlobalSecondaryIndexSettings`

    Represents the properties of a global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index. The name must be unique among all other
      indexes on this table.

    - **IndexStatus** *(string) --*

      The current status of the global secondary index:

      * ``CREATING`` - The global secondary index is being created.

      * ``UPDATING`` - The global secondary index is being updated.

      * ``DELETING`` - The global secondary index is being deleted.

      * ``ACTIVE`` - The global secondary index is ready for use.

    - **ProvisionedReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` .

    - **ProvisionedReadCapacityAutoScalingSettings** *(dict) --*

      Auto scaling settings for a global secondary index replica's read capacity units.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should be
        scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should be
        scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If the
              value is true, scale in is disabled and the target tracking policy won't
              remove capacity from the scalable resource. Otherwise, scale in is enabled
              and the target tracking policy can remove capacity from the scalable
              resource. The default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if
              another alarm triggers a scale out policy during the cooldown period after a
              scale-in, application auto scaling scales out your scalable target
              immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in effect,
              the capacity that has been added by the previous scale out event that
              initiated the cooldown is calculated as part of the desired capacity for the
              next scale out. You should continuously (but not excessively) scale out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
              (Base 10) or 2e-360 to 2e360 (Base 2).

    - **ProvisionedWriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` .

    - **ProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

      Auto scaling settings for a global secondary index replica's write capacity units.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should be
        scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should be
        scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If the
              value is true, scale in is disabled and the target tracking policy won't
              remove capacity from the scalable resource. Otherwise, scale in is enabled
              and the target tracking policy can remove capacity from the scalable
              resource. The default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if
              another alarm triggers a scale out policy during the cooldown period after a
              scale-in, application auto scaling scales out your scalable target
              immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in effect,
              the capacity that has been added by the previous scale out event that
              initiated the cooldown is calculated as part of the desired capacity for the
              next scale out. You should continuously (but not excessively) scale out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
              (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If the
      value is true, scale in is disabled and the target tracking policy won't remove
      capacity from the scalable resource. Otherwise, scale in is enabled and the
      target tracking policy can remove capacity from the scalable resource. The
      default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if another
      alarm triggers a scale out policy during the cooldown period after a scale-in,
      application auto scaling scales out your scalable target immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in effect, the
      capacity that has been added by the previous scale out event that initiated the
      cooldown is calculated as part of the desired capacity for the next scale out.
      You should continuously (but not excessively) scale out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
      (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If the
        value is true, scale in is disabled and the target tracking policy won't remove
        capacity from the scalable resource. Otherwise, scale in is enabled and the
        target tracking policy can remove capacity from the scalable resource. The
        default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if another
        alarm triggers a scale out policy during the cooldown period after a scale-in,
        application auto scaling scales out your scalable target immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in effect, the
        capacity that has been added by the previous scale out event that initiated the
        cooldown is calculated as part of the desired capacity for the next scale out.
        You should continuously (but not excessively) scale out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
        (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettings` `ReplicaProvisionedReadCapacityAutoScalingSettings`

    Auto scaling settings for a global table replica's read capacity units.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should be
      scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should be
      scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If the
            value is true, scale in is disabled and the target tracking policy won't remove
            capacity from the scalable resource. Otherwise, scale in is enabled and the
            target tracking policy can remove capacity from the scalable resource. The
            default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if another
            alarm triggers a scale out policy during the cooldown period after a scale-in,
            application auto scaling scales out your scalable target immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in effect, the
            capacity that has been added by the previous scale out event that initiated the
            cooldown is calculated as part of the desired capacity for the next scale out.
            You should continuously (but not excessively) scale out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
            (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If the
      value is true, scale in is disabled and the target tracking policy won't remove
      capacity from the scalable resource. Otherwise, scale in is enabled and the
      target tracking policy can remove capacity from the scalable resource. The
      default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if another
      alarm triggers a scale out policy during the cooldown period after a scale-in,
      application auto scaling scales out your scalable target immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in effect, the
      capacity that has been added by the previous scale out event that initiated the
      cooldown is calculated as part of the desired capacity for the next scale out.
      You should continuously (but not excessively) scale out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
      (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If the
        value is true, scale in is disabled and the target tracking policy won't remove
        capacity from the scalable resource. Otherwise, scale in is enabled and the
        target tracking policy can remove capacity from the scalable resource. The
        default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if another
        alarm triggers a scale out policy during the cooldown period after a scale-in,
        application auto scaling scales out your scalable target immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in effect, the
        capacity that has been added by the previous scale out event that initiated the
        cooldown is calculated as part of the desired capacity for the next scale out.
        You should continuously (but not excessively) scale out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
        (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponseReplicaSettings` `ReplicaProvisionedWriteCapacityAutoScalingSettings`

    Auto scaling settings for a global table replica's write capacity units.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should be
      scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should be
      scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If the
            value is true, scale in is disabled and the target tracking policy won't remove
            capacity from the scalable resource. Otherwise, scale in is enabled and the
            target tracking policy can remove capacity from the scalable resource. The
            default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if another
            alarm triggers a scale out policy during the cooldown period after a scale-in,
            application auto scaling scales out your scalable target immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in effect, the
            capacity that has been added by the previous scale out event that initiated the
            cooldown is calculated as part of the desired capacity for the next scale out.
            You should continuously (but not excessively) scale out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
            (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseReplicaSettingsTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseReplicaSettingsTypeDef",
    {
        "RegionName": str,
        "ReplicaStatus": str,
        "ReplicaBillingModeSummary": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaBillingModeSummaryTypeDef,
        "ReplicaProvisionedReadCapacityUnits": int,
        "ReplicaProvisionedReadCapacityAutoScalingSettings": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef,
        "ReplicaProvisionedWriteCapacityUnits": int,
        "ReplicaProvisionedWriteCapacityAutoScalingSettings": ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef,
        "ReplicaGlobalSecondaryIndexSettings": List[
            ClientDescribeGlobalTableSettingsResponseReplicaSettingsReplicaGlobalSecondaryIndexSettingsTypeDef
        ],
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseReplicaSettingsTypeDef(
    _ClientDescribeGlobalTableSettingsResponseReplicaSettingsTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettingsResponse` `ReplicaSettings`

    Represents the properties of a replica.

    - **RegionName** *(string) --*

      The Region name of the replica.

    - **ReplicaStatus** *(string) --*

      The current state of the Region:

      * ``CREATING`` - The Region is being created.

      * ``UPDATING`` - The Region is being updated.

      * ``DELETING`` - The Region is being deleted.

      * ``ACTIVE`` - The Region is ready for use.

    - **ReplicaBillingModeSummary** *(dict) --*

      The read/write capacity mode of the replica.

      - **BillingMode** *(string) --*

        Controls how you are charged for read and write throughput and how you manage capacity.
        This setting can be changed later.

        * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
        using ``PROVISIONED`` for predictable workloads.

        * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
        recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

      - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

        Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity
        mode.

    - **ReplicaProvisionedReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . For more information, see `Specifying Read and Write
      Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

    - **ReplicaProvisionedReadCapacityAutoScalingSettings** *(dict) --*

      Auto scaling settings for a global table replica's read capacity units.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should be
        scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should be
        scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If the
              value is true, scale in is disabled and the target tracking policy won't remove
              capacity from the scalable resource. Otherwise, scale in is enabled and the
              target tracking policy can remove capacity from the scalable resource. The
              default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if another
              alarm triggers a scale out policy during the cooldown period after a scale-in,
              application auto scaling scales out your scalable target immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in effect, the
              capacity that has been added by the previous scale out event that initiated the
              cooldown is calculated as part of the desired capacity for the next scale out.
              You should continuously (but not excessively) scale out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
              (Base 10) or 2e-360 to 2e360 (Base 2).

    - **ReplicaProvisionedWriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` . For more information, see `Specifying Read and Write
      Requirements
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
      in the *Amazon DynamoDB Developer Guide* .

    - **ReplicaProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

      Auto scaling settings for a global table replica's write capacity units.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should be
        scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should be
        scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If the
              value is true, scale in is disabled and the target tracking policy won't remove
              capacity from the scalable resource. Otherwise, scale in is enabled and the
              target tracking policy can remove capacity from the scalable resource. The
              default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if another
              alarm triggers a scale out policy during the cooldown period after a scale-in,
              application auto scaling scales out your scalable target immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in effect, the
              capacity that has been added by the previous scale out event that initiated the
              cooldown is calculated as part of the desired capacity for the next scale out.
              You should continuously (but not excessively) scale out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
              (Base 10) or 2e-360 to 2e360 (Base 2).

    - **ReplicaGlobalSecondaryIndexSettings** *(list) --*

      Replica global secondary index settings for the global table.

      - *(dict) --*

        Represents the properties of a global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index. The name must be unique among all other
          indexes on this table.

        - **IndexStatus** *(string) --*

          The current status of the global secondary index:

          * ``CREATING`` - The global secondary index is being created.

          * ``UPDATING`` - The global secondary index is being updated.

          * ``DELETING`` - The global secondary index is being deleted.

          * ``ACTIVE`` - The global secondary index is ready for use.

        - **ProvisionedReadCapacityUnits** *(integer) --*

          The maximum number of strongly consistent reads consumed per second before DynamoDB
          returns a ``ThrottlingException`` .

        - **ProvisionedReadCapacityAutoScalingSettings** *(dict) --*

          Auto scaling settings for a global secondary index replica's read capacity units.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should be
            scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should be
            scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If the
                  value is true, scale in is disabled and the target tracking policy won't
                  remove capacity from the scalable resource. Otherwise, scale in is enabled
                  and the target tracking policy can remove capacity from the scalable
                  resource. The default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if
                  another alarm triggers a scale out policy during the cooldown period after a
                  scale-in, application auto scaling scales out your scalable target
                  immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in effect,
                  the capacity that has been added by the previous scale out event that
                  initiated the cooldown is calculated as part of the desired capacity for the
                  next scale out. You should continuously (but not excessively) scale out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                  (Base 10) or 2e-360 to 2e360 (Base 2).

        - **ProvisionedWriteCapacityUnits** *(integer) --*

          The maximum number of writes consumed per second before DynamoDB returns a
          ``ThrottlingException`` .

        - **ProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

          Auto scaling settings for a global secondary index replica's write capacity units.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should be
            scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should be
            scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If the
                  value is true, scale in is disabled and the target tracking policy won't
                  remove capacity from the scalable resource. Otherwise, scale in is enabled
                  and the target tracking policy can remove capacity from the scalable
                  resource. The default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if
                  another alarm triggers a scale out policy during the cooldown period after a
                  scale-in, application auto scaling scales out your scalable target
                  immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in effect,
                  the capacity that has been added by the previous scale out event that
                  initiated the cooldown is calculated as part of the desired capacity for the
                  next scale out. You should continuously (but not excessively) scale out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                  (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeGlobalTableSettingsResponseTypeDef = TypedDict(
    "_ClientDescribeGlobalTableSettingsResponseTypeDef",
    {
        "GlobalTableName": str,
        "ReplicaSettings": List[
            ClientDescribeGlobalTableSettingsResponseReplicaSettingsTypeDef
        ],
    },
    total=False,
)


class ClientDescribeGlobalTableSettingsResponseTypeDef(
    _ClientDescribeGlobalTableSettingsResponseTypeDef
):
    """
    Type definition for `ClientDescribeGlobalTableSettings` `Response`

    - **GlobalTableName** *(string) --*

      The name of the global table.

    - **ReplicaSettings** *(list) --*

      The Region-specific settings for the global table.

      - *(dict) --*

        Represents the properties of a replica.

        - **RegionName** *(string) --*

          The Region name of the replica.

        - **ReplicaStatus** *(string) --*

          The current state of the Region:

          * ``CREATING`` - The Region is being created.

          * ``UPDATING`` - The Region is being updated.

          * ``DELETING`` - The Region is being deleted.

          * ``ACTIVE`` - The Region is ready for use.

        - **ReplicaBillingModeSummary** *(dict) --*

          The read/write capacity mode of the replica.

          - **BillingMode** *(string) --*

            Controls how you are charged for read and write throughput and how you manage capacity.
            This setting can be changed later.

            * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
            using ``PROVISIONED`` for predictable workloads.

            * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
            recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

          - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

            Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity
            mode.

        - **ReplicaProvisionedReadCapacityUnits** *(integer) --*

          The maximum number of strongly consistent reads consumed per second before DynamoDB
          returns a ``ThrottlingException`` . For more information, see `Specifying Read and Write
          Requirements
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
          in the *Amazon DynamoDB Developer Guide* .

        - **ReplicaProvisionedReadCapacityAutoScalingSettings** *(dict) --*

          Auto scaling settings for a global table replica's read capacity units.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should be
            scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should be
            scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If the
                  value is true, scale in is disabled and the target tracking policy won't remove
                  capacity from the scalable resource. Otherwise, scale in is enabled and the
                  target tracking policy can remove capacity from the scalable resource. The
                  default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if another
                  alarm triggers a scale out policy during the cooldown period after a scale-in,
                  application auto scaling scales out your scalable target immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in effect, the
                  capacity that has been added by the previous scale out event that initiated the
                  cooldown is calculated as part of the desired capacity for the next scale out.
                  You should continuously (but not excessively) scale out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                  (Base 10) or 2e-360 to 2e360 (Base 2).

        - **ReplicaProvisionedWriteCapacityUnits** *(integer) --*

          The maximum number of writes consumed per second before DynamoDB returns a
          ``ThrottlingException`` . For more information, see `Specifying Read and Write
          Requirements
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput>`__
          in the *Amazon DynamoDB Developer Guide* .

        - **ReplicaProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

          Auto scaling settings for a global table replica's write capacity units.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should be
            scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should be
            scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If the
                  value is true, scale in is disabled and the target tracking policy won't remove
                  capacity from the scalable resource. Otherwise, scale in is enabled and the
                  target tracking policy can remove capacity from the scalable resource. The
                  default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if another
                  alarm triggers a scale out policy during the cooldown period after a scale-in,
                  application auto scaling scales out your scalable target immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in effect, the
                  capacity that has been added by the previous scale out event that initiated the
                  cooldown is calculated as part of the desired capacity for the next scale out.
                  You should continuously (but not excessively) scale out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                  (Base 10) or 2e-360 to 2e360 (Base 2).

        - **ReplicaGlobalSecondaryIndexSettings** *(list) --*

          Replica global secondary index settings for the global table.

          - *(dict) --*

            Represents the properties of a global secondary index.

            - **IndexName** *(string) --*

              The name of the global secondary index. The name must be unique among all other
              indexes on this table.

            - **IndexStatus** *(string) --*

              The current status of the global secondary index:

              * ``CREATING`` - The global secondary index is being created.

              * ``UPDATING`` - The global secondary index is being updated.

              * ``DELETING`` - The global secondary index is being deleted.

              * ``ACTIVE`` - The global secondary index is ready for use.

            - **ProvisionedReadCapacityUnits** *(integer) --*

              The maximum number of strongly consistent reads consumed per second before DynamoDB
              returns a ``ThrottlingException`` .

            - **ProvisionedReadCapacityAutoScalingSettings** *(dict) --*

              Auto scaling settings for a global secondary index replica's read capacity units.

              - **MinimumUnits** *(integer) --*

                The minimum capacity units that a global table or global secondary index should be
                scaled down to.

              - **MaximumUnits** *(integer) --*

                The maximum capacity units that a global table or global secondary index should be
                scaled up to.

              - **AutoScalingDisabled** *(boolean) --*

                Disabled auto scaling for this global table or global secondary index.

              - **AutoScalingRoleArn** *(string) --*

                Role ARN used for configuring the auto scaling policy.

              - **ScalingPolicies** *(list) --*

                Information about the scaling policies.

                - *(dict) --*

                  Represents the properties of the scaling policy.

                  - **PolicyName** *(string) --*

                    The name of the scaling policy.

                  - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                    Represents a target tracking scaling policy configuration.

                    - **DisableScaleIn** *(boolean) --*

                      Indicates whether scale in by the target tracking policy is disabled. If the
                      value is true, scale in is disabled and the target tracking policy won't
                      remove capacity from the scalable resource. Otherwise, scale in is enabled
                      and the target tracking policy can remove capacity from the scalable
                      resource. The default value is false.

                    - **ScaleInCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale in activity completes before
                      another scale in activity can start. The cooldown period is used to block
                      subsequent scale in requests until it has expired. You should scale in
                      conservatively to protect your application's availability. However, if
                      another alarm triggers a scale out policy during the cooldown period after a
                      scale-in, application auto scaling scales out your scalable target
                      immediately.

                    - **ScaleOutCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale out activity completes before
                      another scale out activity can start. While the cooldown period is in effect,
                      the capacity that has been added by the previous scale out event that
                      initiated the cooldown is calculated as part of the desired capacity for the
                      next scale out. You should continuously (but not excessively) scale out.

                    - **TargetValue** *(float) --*

                      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                      (Base 10) or 2e-360 to 2e360 (Base 2).

            - **ProvisionedWriteCapacityUnits** *(integer) --*

              The maximum number of writes consumed per second before DynamoDB returns a
              ``ThrottlingException`` .

            - **ProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

              Auto scaling settings for a global secondary index replica's write capacity units.

              - **MinimumUnits** *(integer) --*

                The minimum capacity units that a global table or global secondary index should be
                scaled down to.

              - **MaximumUnits** *(integer) --*

                The maximum capacity units that a global table or global secondary index should be
                scaled up to.

              - **AutoScalingDisabled** *(boolean) --*

                Disabled auto scaling for this global table or global secondary index.

              - **AutoScalingRoleArn** *(string) --*

                Role ARN used for configuring the auto scaling policy.

              - **ScalingPolicies** *(list) --*

                Information about the scaling policies.

                - *(dict) --*

                  Represents the properties of the scaling policy.

                  - **PolicyName** *(string) --*

                    The name of the scaling policy.

                  - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                    Represents a target tracking scaling policy configuration.

                    - **DisableScaleIn** *(boolean) --*

                      Indicates whether scale in by the target tracking policy is disabled. If the
                      value is true, scale in is disabled and the target tracking policy won't
                      remove capacity from the scalable resource. Otherwise, scale in is enabled
                      and the target tracking policy can remove capacity from the scalable
                      resource. The default value is false.

                    - **ScaleInCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale in activity completes before
                      another scale in activity can start. The cooldown period is used to block
                      subsequent scale in requests until it has expired. You should scale in
                      conservatively to protect your application's availability. However, if
                      another alarm triggers a scale out policy during the cooldown period after a
                      scale-in, application auto scaling scales out your scalable target
                      immediately.

                    - **ScaleOutCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale out activity completes before
                      another scale out activity can start. While the cooldown period is in effect,
                      the capacity that has been added by the previous scale out event that
                      initiated the cooldown is calculated as part of the desired capacity for the
                      next scale out. You should continuously (but not excessively) scale out.

                    - **TargetValue** *(float) --*

                      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                      (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeLimitsResponseTypeDef = TypedDict(
    "_ClientDescribeLimitsResponseTypeDef",
    {
        "AccountMaxReadCapacityUnits": int,
        "AccountMaxWriteCapacityUnits": int,
        "TableMaxReadCapacityUnits": int,
        "TableMaxWriteCapacityUnits": int,
    },
    total=False,
)


class ClientDescribeLimitsResponseTypeDef(_ClientDescribeLimitsResponseTypeDef):
    """
    Type definition for `ClientDescribeLimits` `Response`

    Represents the output of a ``DescribeLimits`` operation.

    - **AccountMaxReadCapacityUnits** *(integer) --*

      The maximum total read capacity units that your account allows you to provision across all of
      your tables in this Region.

    - **AccountMaxWriteCapacityUnits** *(integer) --*

      The maximum total write capacity units that your account allows you to provision across all
      of your tables in this Region.

    - **TableMaxReadCapacityUnits** *(integer) --*

      The maximum read capacity units that your account allows you to provision for a new table
      that you are creating in this Region, including the read capacity units provisioned for its
      global secondary indexes (GSIs).

    - **TableMaxWriteCapacityUnits** *(integer) --*

      The maximum write capacity units that your account allows you to provision for a new table
      that you are creating in this Region, including the write capacity units provisioned for its
      global secondary indexes (GSIs).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If
      the value is true, scale in is disabled and the target tracking policy
      won't remove capacity from the scalable resource. Otherwise, scale in is
      enabled and the target tracking policy can remove capacity from the
      scalable resource. The default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if
      another alarm triggers a scale out policy during the cooldown period after
      a scale-in, application auto scaling scales out your scalable target
      immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in
      effect, the capacity that has been added by the previous scale out event
      that initiated the cooldown is calculated as part of the desired capacity
      for the next scale out. You should continuously (but not excessively) scale
      out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to
      1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If
        the value is true, scale in is disabled and the target tracking policy
        won't remove capacity from the scalable resource. Otherwise, scale in is
        enabled and the target tracking policy can remove capacity from the
        scalable resource. The default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if
        another alarm triggers a scale out policy during the cooldown period after
        a scale-in, application auto scaling scales out your scalable target
        immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in
        effect, the capacity that has been added by the previous scale out event
        that initiated the cooldown is calculated as part of the desired capacity
        for the next scale out. You should continuously (but not excessively) scale
        out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to
        1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexes` `ProvisionedReadCapacityAutoScalingSettings`

    Represents the auto scaling settings for a global table or global secondary index.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should
      be scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should
      be scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If
            the value is true, scale in is disabled and the target tracking policy
            won't remove capacity from the scalable resource. Otherwise, scale in is
            enabled and the target tracking policy can remove capacity from the
            scalable resource. The default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if
            another alarm triggers a scale out policy during the cooldown period after
            a scale-in, application auto scaling scales out your scalable target
            immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in
            effect, the capacity that has been added by the previous scale out event
            that initiated the cooldown is calculated as part of the desired capacity
            for the next scale out. You should continuously (but not excessively) scale
            out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to
            1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If
      the value is true, scale in is disabled and the target tracking policy
      won't remove capacity from the scalable resource. Otherwise, scale in is
      enabled and the target tracking policy can remove capacity from the
      scalable resource. The default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if
      another alarm triggers a scale out policy during the cooldown period after
      a scale-in, application auto scaling scales out your scalable target
      immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in
      effect, the capacity that has been added by the previous scale out event
      that initiated the cooldown is calculated as part of the desired capacity
      for the next scale out. You should continuously (but not excessively) scale
      out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to
      1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If
        the value is true, scale in is disabled and the target tracking policy
        won't remove capacity from the scalable resource. Otherwise, scale in is
        enabled and the target tracking policy can remove capacity from the
        scalable resource. The default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if
        another alarm triggers a scale out policy during the cooldown period after
        a scale-in, application auto scaling scales out your scalable target
        immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in
        effect, the capacity that has been added by the previous scale out event
        that initiated the cooldown is calculated as part of the desired capacity
        for the next scale out. You should continuously (but not excessively) scale
        out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to
        1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexes` `ProvisionedWriteCapacityAutoScalingSettings`

    Represents the auto scaling settings for a global table or global secondary index.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should
      be scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should
      be scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If
            the value is true, scale in is disabled and the target tracking policy
            won't remove capacity from the scalable resource. Otherwise, scale in is
            enabled and the target tracking policy can remove capacity from the
            scalable resource. The default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if
            another alarm triggers a scale out policy during the cooldown period after
            a scale-in, application auto scaling scales out your scalable target
            immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in
            effect, the capacity that has been added by the previous scale out event
            that initiated the cooldown is calculated as part of the desired capacity
            for the next scale out. You should continuously (but not excessively) scale
            out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to
            1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "IndexStatus": str,
        "ProvisionedReadCapacityAutoScalingSettings": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedReadCapacityAutoScalingSettingsTypeDef,
        "ProvisionedWriteCapacityAutoScalingSettings": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesProvisionedWriteCapacityAutoScalingSettingsTypeDef,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicas` `GlobalSecondaryIndexes`

    Represents the auto scaling configuration for a replica global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **IndexStatus** *(string) --*

      The current state of the replica global secondary index:

      * ``CREATING`` - The index is being created.

      * ``UPDATING`` - The index is being updated.

      * ``DELETING`` - The index is being deleted.

      * ``ACTIVE`` - The index is ready for use.

    - **ProvisionedReadCapacityAutoScalingSettings** *(dict) --*

      Represents the auto scaling settings for a global table or global secondary index.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should
        be scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should
        be scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If
              the value is true, scale in is disabled and the target tracking policy
              won't remove capacity from the scalable resource. Otherwise, scale in is
              enabled and the target tracking policy can remove capacity from the
              scalable resource. The default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if
              another alarm triggers a scale out policy during the cooldown period after
              a scale-in, application auto scaling scales out your scalable target
              immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in
              effect, the capacity that has been added by the previous scale out event
              that initiated the cooldown is calculated as part of the desired capacity
              for the next scale out. You should continuously (but not excessively) scale
              out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to
              1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).

    - **ProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

      Represents the auto scaling settings for a global table or global secondary index.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should
        be scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should
        be scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If
              the value is true, scale in is disabled and the target tracking policy
              won't remove capacity from the scalable resource. Otherwise, scale in is
              enabled and the target tracking policy can remove capacity from the
              scalable resource. The default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if
              another alarm triggers a scale out policy during the cooldown period after
              a scale-in, application auto scaling scales out your scalable target
              immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in
              effect, the capacity that has been added by the previous scale out event
              that initiated the cooldown is calculated as part of the desired capacity
              for the next scale out. You should continuously (but not excessively) scale
              out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to
              1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If the
      value is true, scale in is disabled and the target tracking policy won't remove
      capacity from the scalable resource. Otherwise, scale in is enabled and the
      target tracking policy can remove capacity from the scalable resource. The
      default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if another
      alarm triggers a scale out policy during the cooldown period after a scale-in,
      application auto scaling scales out your scalable target immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in effect,
      the capacity that has been added by the previous scale out event that initiated
      the cooldown is calculated as part of the desired capacity for the next scale
      out. You should continuously (but not excessively) scale out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
      (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If the
        value is true, scale in is disabled and the target tracking policy won't remove
        capacity from the scalable resource. Otherwise, scale in is enabled and the
        target tracking policy can remove capacity from the scalable resource. The
        default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if another
        alarm triggers a scale out policy during the cooldown period after a scale-in,
        application auto scaling scales out your scalable target immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in effect,
        the capacity that has been added by the previous scale out event that initiated
        the cooldown is calculated as part of the desired capacity for the next scale
        out. You should continuously (but not excessively) scale out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
        (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicas` `ReplicaProvisionedReadCapacityAutoScalingSettings`

    Represents the auto scaling settings for a global table or global secondary index.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should be
      scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should be
      scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If the
            value is true, scale in is disabled and the target tracking policy won't remove
            capacity from the scalable resource. Otherwise, scale in is enabled and the
            target tracking policy can remove capacity from the scalable resource. The
            default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if another
            alarm triggers a scale out policy during the cooldown period after a scale-in,
            application auto scaling scales out your scalable target immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in effect,
            the capacity that has been added by the previous scale out event that initiated
            the cooldown is calculated as part of the desired capacity for the next scale
            out. You should continuously (but not excessively) scale out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
            (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef",
    {
        "DisableScaleIn": bool,
        "ScaleInCooldown": int,
        "ScaleOutCooldown": int,
        "TargetValue": float,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPolicies` `TargetTrackingScalingPolicyConfiguration`

    Represents a target tracking scaling policy configuration.

    - **DisableScaleIn** *(boolean) --*

      Indicates whether scale in by the target tracking policy is disabled. If the
      value is true, scale in is disabled and the target tracking policy won't remove
      capacity from the scalable resource. Otherwise, scale in is enabled and the
      target tracking policy can remove capacity from the scalable resource. The
      default value is false.

    - **ScaleInCooldown** *(integer) --*

      The amount of time, in seconds, after a scale in activity completes before
      another scale in activity can start. The cooldown period is used to block
      subsequent scale in requests until it has expired. You should scale in
      conservatively to protect your application's availability. However, if another
      alarm triggers a scale out policy during the cooldown period after a scale-in,
      application auto scaling scales out your scalable target immediately.

    - **ScaleOutCooldown** *(integer) --*

      The amount of time, in seconds, after a scale out activity completes before
      another scale out activity can start. While the cooldown period is in effect,
      the capacity that has been added by the previous scale out event that initiated
      the cooldown is calculated as part of the desired capacity for the next scale
      out. You should continuously (but not excessively) scale out.

    - **TargetValue** *(float) --*

      The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
      (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef",
    {
        "PolicyName": str,
        "TargetTrackingScalingPolicyConfiguration": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTargetTrackingScalingPolicyConfigurationTypeDef,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettings` `ScalingPolicies`

    Represents the properties of the scaling policy.

    - **PolicyName** *(string) --*

      The name of the scaling policy.

    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

      Represents a target tracking scaling policy configuration.

      - **DisableScaleIn** *(boolean) --*

        Indicates whether scale in by the target tracking policy is disabled. If the
        value is true, scale in is disabled and the target tracking policy won't remove
        capacity from the scalable resource. Otherwise, scale in is enabled and the
        target tracking policy can remove capacity from the scalable resource. The
        default value is false.

      - **ScaleInCooldown** *(integer) --*

        The amount of time, in seconds, after a scale in activity completes before
        another scale in activity can start. The cooldown period is used to block
        subsequent scale in requests until it has expired. You should scale in
        conservatively to protect your application's availability. However, if another
        alarm triggers a scale out policy during the cooldown period after a scale-in,
        application auto scaling scales out your scalable target immediately.

      - **ScaleOutCooldown** *(integer) --*

        The amount of time, in seconds, after a scale out activity completes before
        another scale out activity can start. While the cooldown period is in effect,
        the capacity that has been added by the previous scale out event that initiated
        the cooldown is calculated as part of the desired capacity for the next scale
        out. You should continuously (but not excessively) scale out.

      - **TargetValue** *(float) --*

        The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
        (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef",
    {
        "MinimumUnits": int,
        "MaximumUnits": int,
        "AutoScalingDisabled": bool,
        "AutoScalingRoleArn": str,
        "ScalingPolicies": List[
            ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsScalingPoliciesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicas` `ReplicaProvisionedWriteCapacityAutoScalingSettings`

    Represents the auto scaling settings for a global table or global secondary index.

    - **MinimumUnits** *(integer) --*

      The minimum capacity units that a global table or global secondary index should be
      scaled down to.

    - **MaximumUnits** *(integer) --*

      The maximum capacity units that a global table or global secondary index should be
      scaled up to.

    - **AutoScalingDisabled** *(boolean) --*

      Disabled auto scaling for this global table or global secondary index.

    - **AutoScalingRoleArn** *(string) --*

      Role ARN used for configuring the auto scaling policy.

    - **ScalingPolicies** *(list) --*

      Information about the scaling policies.

      - *(dict) --*

        Represents the properties of the scaling policy.

        - **PolicyName** *(string) --*

          The name of the scaling policy.

        - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

          Represents a target tracking scaling policy configuration.

          - **DisableScaleIn** *(boolean) --*

            Indicates whether scale in by the target tracking policy is disabled. If the
            value is true, scale in is disabled and the target tracking policy won't remove
            capacity from the scalable resource. Otherwise, scale in is enabled and the
            target tracking policy can remove capacity from the scalable resource. The
            default value is false.

          - **ScaleInCooldown** *(integer) --*

            The amount of time, in seconds, after a scale in activity completes before
            another scale in activity can start. The cooldown period is used to block
            subsequent scale in requests until it has expired. You should scale in
            conservatively to protect your application's availability. However, if another
            alarm triggers a scale out policy during the cooldown period after a scale-in,
            application auto scaling scales out your scalable target immediately.

          - **ScaleOutCooldown** *(integer) --*

            The amount of time, in seconds, after a scale out activity completes before
            another scale out activity can start. While the cooldown period is in effect,
            the capacity that has been added by the previous scale out event that initiated
            the cooldown is calculated as part of the desired capacity for the next scale
            out. You should continuously (but not excessively) scale out.

          - **TargetValue** *(float) --*

            The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
            (Base 10) or 2e-360 to 2e360 (Base 2).
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasTypeDef",
    {
        "RegionName": str,
        "GlobalSecondaryIndexes": List[
            ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasGlobalSecondaryIndexesTypeDef
        ],
        "ReplicaProvisionedReadCapacityAutoScalingSettings": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedReadCapacityAutoScalingSettingsTypeDef,
        "ReplicaProvisionedWriteCapacityAutoScalingSettings": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasReplicaProvisionedWriteCapacityAutoScalingSettingsTypeDef,
        "ReplicaStatus": str,
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescription` `Replicas`

    Represents the auto scaling settings of the replica.

    - **RegionName** *(string) --*

      The Region where the replica exists.

    - **GlobalSecondaryIndexes** *(list) --*

      Replica-specific global secondary index auto scaling settings.

      - *(dict) --*

        Represents the auto scaling configuration for a replica global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **IndexStatus** *(string) --*

          The current state of the replica global secondary index:

          * ``CREATING`` - The index is being created.

          * ``UPDATING`` - The index is being updated.

          * ``DELETING`` - The index is being deleted.

          * ``ACTIVE`` - The index is ready for use.

        - **ProvisionedReadCapacityAutoScalingSettings** *(dict) --*

          Represents the auto scaling settings for a global table or global secondary index.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should
            be scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should
            be scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If
                  the value is true, scale in is disabled and the target tracking policy
                  won't remove capacity from the scalable resource. Otherwise, scale in is
                  enabled and the target tracking policy can remove capacity from the
                  scalable resource. The default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if
                  another alarm triggers a scale out policy during the cooldown period after
                  a scale-in, application auto scaling scales out your scalable target
                  immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in
                  effect, the capacity that has been added by the previous scale out event
                  that initiated the cooldown is calculated as part of the desired capacity
                  for the next scale out. You should continuously (but not excessively) scale
                  out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to
                  1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).

        - **ProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

          Represents the auto scaling settings for a global table or global secondary index.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should
            be scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should
            be scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If
                  the value is true, scale in is disabled and the target tracking policy
                  won't remove capacity from the scalable resource. Otherwise, scale in is
                  enabled and the target tracking policy can remove capacity from the
                  scalable resource. The default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if
                  another alarm triggers a scale out policy during the cooldown period after
                  a scale-in, application auto scaling scales out your scalable target
                  immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in
                  effect, the capacity that has been added by the previous scale out event
                  that initiated the cooldown is calculated as part of the desired capacity
                  for the next scale out. You should continuously (but not excessively) scale
                  out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to
                  1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).

    - **ReplicaProvisionedReadCapacityAutoScalingSettings** *(dict) --*

      Represents the auto scaling settings for a global table or global secondary index.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should be
        scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should be
        scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If the
              value is true, scale in is disabled and the target tracking policy won't remove
              capacity from the scalable resource. Otherwise, scale in is enabled and the
              target tracking policy can remove capacity from the scalable resource. The
              default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if another
              alarm triggers a scale out policy during the cooldown period after a scale-in,
              application auto scaling scales out your scalable target immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in effect,
              the capacity that has been added by the previous scale out event that initiated
              the cooldown is calculated as part of the desired capacity for the next scale
              out. You should continuously (but not excessively) scale out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
              (Base 10) or 2e-360 to 2e360 (Base 2).

    - **ReplicaProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

      Represents the auto scaling settings for a global table or global secondary index.

      - **MinimumUnits** *(integer) --*

        The minimum capacity units that a global table or global secondary index should be
        scaled down to.

      - **MaximumUnits** *(integer) --*

        The maximum capacity units that a global table or global secondary index should be
        scaled up to.

      - **AutoScalingDisabled** *(boolean) --*

        Disabled auto scaling for this global table or global secondary index.

      - **AutoScalingRoleArn** *(string) --*

        Role ARN used for configuring the auto scaling policy.

      - **ScalingPolicies** *(list) --*

        Information about the scaling policies.

        - *(dict) --*

          Represents the properties of the scaling policy.

          - **PolicyName** *(string) --*

            The name of the scaling policy.

          - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

            Represents a target tracking scaling policy configuration.

            - **DisableScaleIn** *(boolean) --*

              Indicates whether scale in by the target tracking policy is disabled. If the
              value is true, scale in is disabled and the target tracking policy won't remove
              capacity from the scalable resource. Otherwise, scale in is enabled and the
              target tracking policy can remove capacity from the scalable resource. The
              default value is false.

            - **ScaleInCooldown** *(integer) --*

              The amount of time, in seconds, after a scale in activity completes before
              another scale in activity can start. The cooldown period is used to block
              subsequent scale in requests until it has expired. You should scale in
              conservatively to protect your application's availability. However, if another
              alarm triggers a scale out policy during the cooldown period after a scale-in,
              application auto scaling scales out your scalable target immediately.

            - **ScaleOutCooldown** *(integer) --*

              The amount of time, in seconds, after a scale out activity completes before
              another scale out activity can start. While the cooldown period is in effect,
              the capacity that has been added by the previous scale out event that initiated
              the cooldown is calculated as part of the desired capacity for the next scale
              out. You should continuously (but not excessively) scale out.

            - **TargetValue** *(float) --*

              The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
              (Base 10) or 2e-360 to 2e360 (Base 2).

    - **ReplicaStatus** *(string) --*

      The current state of the replica:

      * ``CREATING`` - The replica is being created.

      * ``UPDATING`` - The replica is being updated.

      * ``DELETING`` - The replica is being deleted.

      * ``ACTIVE`` - The replica is ready for use.
    """


_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionTypeDef",
    {
        "TableName": str,
        "TableStatus": str,
        "Replicas": List[
            ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionReplicasTypeDef
        ],
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScalingResponse` `TableAutoScalingDescription`

    Represents the auto scaling properties of the table.

    - **TableName** *(string) --*

      The name of the table.

    - **TableStatus** *(string) --*

      The current state of the table:

      * ``CREATING`` - The table is being created.

      * ``UPDATING`` - The table is being updated.

      * ``DELETING`` - The table is being deleted.

      * ``ACTIVE`` - The table is ready for use.

    - **Replicas** *(list) --*

      Represents replicas of the global table.

      - *(dict) --*

        Represents the auto scaling settings of the replica.

        - **RegionName** *(string) --*

          The Region where the replica exists.

        - **GlobalSecondaryIndexes** *(list) --*

          Replica-specific global secondary index auto scaling settings.

          - *(dict) --*

            Represents the auto scaling configuration for a replica global secondary index.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **IndexStatus** *(string) --*

              The current state of the replica global secondary index:

              * ``CREATING`` - The index is being created.

              * ``UPDATING`` - The index is being updated.

              * ``DELETING`` - The index is being deleted.

              * ``ACTIVE`` - The index is ready for use.

            - **ProvisionedReadCapacityAutoScalingSettings** *(dict) --*

              Represents the auto scaling settings for a global table or global secondary index.

              - **MinimumUnits** *(integer) --*

                The minimum capacity units that a global table or global secondary index should
                be scaled down to.

              - **MaximumUnits** *(integer) --*

                The maximum capacity units that a global table or global secondary index should
                be scaled up to.

              - **AutoScalingDisabled** *(boolean) --*

                Disabled auto scaling for this global table or global secondary index.

              - **AutoScalingRoleArn** *(string) --*

                Role ARN used for configuring the auto scaling policy.

              - **ScalingPolicies** *(list) --*

                Information about the scaling policies.

                - *(dict) --*

                  Represents the properties of the scaling policy.

                  - **PolicyName** *(string) --*

                    The name of the scaling policy.

                  - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                    Represents a target tracking scaling policy configuration.

                    - **DisableScaleIn** *(boolean) --*

                      Indicates whether scale in by the target tracking policy is disabled. If
                      the value is true, scale in is disabled and the target tracking policy
                      won't remove capacity from the scalable resource. Otherwise, scale in is
                      enabled and the target tracking policy can remove capacity from the
                      scalable resource. The default value is false.

                    - **ScaleInCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale in activity completes before
                      another scale in activity can start. The cooldown period is used to block
                      subsequent scale in requests until it has expired. You should scale in
                      conservatively to protect your application's availability. However, if
                      another alarm triggers a scale out policy during the cooldown period after
                      a scale-in, application auto scaling scales out your scalable target
                      immediately.

                    - **ScaleOutCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale out activity completes before
                      another scale out activity can start. While the cooldown period is in
                      effect, the capacity that has been added by the previous scale out event
                      that initiated the cooldown is calculated as part of the desired capacity
                      for the next scale out. You should continuously (but not excessively) scale
                      out.

                    - **TargetValue** *(float) --*

                      The target value for the metric. The range is 8.515920e-109 to
                      1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).

            - **ProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

              Represents the auto scaling settings for a global table or global secondary index.

              - **MinimumUnits** *(integer) --*

                The minimum capacity units that a global table or global secondary index should
                be scaled down to.

              - **MaximumUnits** *(integer) --*

                The maximum capacity units that a global table or global secondary index should
                be scaled up to.

              - **AutoScalingDisabled** *(boolean) --*

                Disabled auto scaling for this global table or global secondary index.

              - **AutoScalingRoleArn** *(string) --*

                Role ARN used for configuring the auto scaling policy.

              - **ScalingPolicies** *(list) --*

                Information about the scaling policies.

                - *(dict) --*

                  Represents the properties of the scaling policy.

                  - **PolicyName** *(string) --*

                    The name of the scaling policy.

                  - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                    Represents a target tracking scaling policy configuration.

                    - **DisableScaleIn** *(boolean) --*

                      Indicates whether scale in by the target tracking policy is disabled. If
                      the value is true, scale in is disabled and the target tracking policy
                      won't remove capacity from the scalable resource. Otherwise, scale in is
                      enabled and the target tracking policy can remove capacity from the
                      scalable resource. The default value is false.

                    - **ScaleInCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale in activity completes before
                      another scale in activity can start. The cooldown period is used to block
                      subsequent scale in requests until it has expired. You should scale in
                      conservatively to protect your application's availability. However, if
                      another alarm triggers a scale out policy during the cooldown period after
                      a scale-in, application auto scaling scales out your scalable target
                      immediately.

                    - **ScaleOutCooldown** *(integer) --*

                      The amount of time, in seconds, after a scale out activity completes before
                      another scale out activity can start. While the cooldown period is in
                      effect, the capacity that has been added by the previous scale out event
                      that initiated the cooldown is calculated as part of the desired capacity
                      for the next scale out. You should continuously (but not excessively) scale
                      out.

                    - **TargetValue** *(float) --*

                      The target value for the metric. The range is 8.515920e-109 to
                      1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).

        - **ReplicaProvisionedReadCapacityAutoScalingSettings** *(dict) --*

          Represents the auto scaling settings for a global table or global secondary index.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should be
            scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should be
            scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If the
                  value is true, scale in is disabled and the target tracking policy won't remove
                  capacity from the scalable resource. Otherwise, scale in is enabled and the
                  target tracking policy can remove capacity from the scalable resource. The
                  default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if another
                  alarm triggers a scale out policy during the cooldown period after a scale-in,
                  application auto scaling scales out your scalable target immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in effect,
                  the capacity that has been added by the previous scale out event that initiated
                  the cooldown is calculated as part of the desired capacity for the next scale
                  out. You should continuously (but not excessively) scale out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                  (Base 10) or 2e-360 to 2e360 (Base 2).

        - **ReplicaProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

          Represents the auto scaling settings for a global table or global secondary index.

          - **MinimumUnits** *(integer) --*

            The minimum capacity units that a global table or global secondary index should be
            scaled down to.

          - **MaximumUnits** *(integer) --*

            The maximum capacity units that a global table or global secondary index should be
            scaled up to.

          - **AutoScalingDisabled** *(boolean) --*

            Disabled auto scaling for this global table or global secondary index.

          - **AutoScalingRoleArn** *(string) --*

            Role ARN used for configuring the auto scaling policy.

          - **ScalingPolicies** *(list) --*

            Information about the scaling policies.

            - *(dict) --*

              Represents the properties of the scaling policy.

              - **PolicyName** *(string) --*

                The name of the scaling policy.

              - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                Represents a target tracking scaling policy configuration.

                - **DisableScaleIn** *(boolean) --*

                  Indicates whether scale in by the target tracking policy is disabled. If the
                  value is true, scale in is disabled and the target tracking policy won't remove
                  capacity from the scalable resource. Otherwise, scale in is enabled and the
                  target tracking policy can remove capacity from the scalable resource. The
                  default value is false.

                - **ScaleInCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale in activity completes before
                  another scale in activity can start. The cooldown period is used to block
                  subsequent scale in requests until it has expired. You should scale in
                  conservatively to protect your application's availability. However, if another
                  alarm triggers a scale out policy during the cooldown period after a scale-in,
                  application auto scaling scales out your scalable target immediately.

                - **ScaleOutCooldown** *(integer) --*

                  The amount of time, in seconds, after a scale out activity completes before
                  another scale out activity can start. While the cooldown period is in effect,
                  the capacity that has been added by the previous scale out event that initiated
                  the cooldown is calculated as part of the desired capacity for the next scale
                  out. You should continuously (but not excessively) scale out.

                - **TargetValue** *(float) --*

                  The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                  (Base 10) or 2e-360 to 2e360 (Base 2).

        - **ReplicaStatus** *(string) --*

          The current state of the replica:

          * ``CREATING`` - The replica is being created.

          * ``UPDATING`` - The replica is being updated.

          * ``DELETING`` - The replica is being deleted.

          * ``ACTIVE`` - The replica is ready for use.
    """


_ClientDescribeTableReplicaAutoScalingResponseTypeDef = TypedDict(
    "_ClientDescribeTableReplicaAutoScalingResponseTypeDef",
    {
        "TableAutoScalingDescription": ClientDescribeTableReplicaAutoScalingResponseTableAutoScalingDescriptionTypeDef
    },
    total=False,
)


class ClientDescribeTableReplicaAutoScalingResponseTypeDef(
    _ClientDescribeTableReplicaAutoScalingResponseTypeDef
):
    """
    Type definition for `ClientDescribeTableReplicaAutoScaling` `Response`

    - **TableAutoScalingDescription** *(dict) --*

      Represents the auto scaling properties of the table.

      - **TableName** *(string) --*

        The name of the table.

      - **TableStatus** *(string) --*

        The current state of the table:

        * ``CREATING`` - The table is being created.

        * ``UPDATING`` - The table is being updated.

        * ``DELETING`` - The table is being deleted.

        * ``ACTIVE`` - The table is ready for use.

      - **Replicas** *(list) --*

        Represents replicas of the global table.

        - *(dict) --*

          Represents the auto scaling settings of the replica.

          - **RegionName** *(string) --*

            The Region where the replica exists.

          - **GlobalSecondaryIndexes** *(list) --*

            Replica-specific global secondary index auto scaling settings.

            - *(dict) --*

              Represents the auto scaling configuration for a replica global secondary index.

              - **IndexName** *(string) --*

                The name of the global secondary index.

              - **IndexStatus** *(string) --*

                The current state of the replica global secondary index:

                * ``CREATING`` - The index is being created.

                * ``UPDATING`` - The index is being updated.

                * ``DELETING`` - The index is being deleted.

                * ``ACTIVE`` - The index is ready for use.

              - **ProvisionedReadCapacityAutoScalingSettings** *(dict) --*

                Represents the auto scaling settings for a global table or global secondary index.

                - **MinimumUnits** *(integer) --*

                  The minimum capacity units that a global table or global secondary index should
                  be scaled down to.

                - **MaximumUnits** *(integer) --*

                  The maximum capacity units that a global table or global secondary index should
                  be scaled up to.

                - **AutoScalingDisabled** *(boolean) --*

                  Disabled auto scaling for this global table or global secondary index.

                - **AutoScalingRoleArn** *(string) --*

                  Role ARN used for configuring the auto scaling policy.

                - **ScalingPolicies** *(list) --*

                  Information about the scaling policies.

                  - *(dict) --*

                    Represents the properties of the scaling policy.

                    - **PolicyName** *(string) --*

                      The name of the scaling policy.

                    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                      Represents a target tracking scaling policy configuration.

                      - **DisableScaleIn** *(boolean) --*

                        Indicates whether scale in by the target tracking policy is disabled. If
                        the value is true, scale in is disabled and the target tracking policy
                        won't remove capacity from the scalable resource. Otherwise, scale in is
                        enabled and the target tracking policy can remove capacity from the
                        scalable resource. The default value is false.

                      - **ScaleInCooldown** *(integer) --*

                        The amount of time, in seconds, after a scale in activity completes before
                        another scale in activity can start. The cooldown period is used to block
                        subsequent scale in requests until it has expired. You should scale in
                        conservatively to protect your application's availability. However, if
                        another alarm triggers a scale out policy during the cooldown period after
                        a scale-in, application auto scaling scales out your scalable target
                        immediately.

                      - **ScaleOutCooldown** *(integer) --*

                        The amount of time, in seconds, after a scale out activity completes before
                        another scale out activity can start. While the cooldown period is in
                        effect, the capacity that has been added by the previous scale out event
                        that initiated the cooldown is calculated as part of the desired capacity
                        for the next scale out. You should continuously (but not excessively) scale
                        out.

                      - **TargetValue** *(float) --*

                        The target value for the metric. The range is 8.515920e-109 to
                        1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).

              - **ProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

                Represents the auto scaling settings for a global table or global secondary index.

                - **MinimumUnits** *(integer) --*

                  The minimum capacity units that a global table or global secondary index should
                  be scaled down to.

                - **MaximumUnits** *(integer) --*

                  The maximum capacity units that a global table or global secondary index should
                  be scaled up to.

                - **AutoScalingDisabled** *(boolean) --*

                  Disabled auto scaling for this global table or global secondary index.

                - **AutoScalingRoleArn** *(string) --*

                  Role ARN used for configuring the auto scaling policy.

                - **ScalingPolicies** *(list) --*

                  Information about the scaling policies.

                  - *(dict) --*

                    Represents the properties of the scaling policy.

                    - **PolicyName** *(string) --*

                      The name of the scaling policy.

                    - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                      Represents a target tracking scaling policy configuration.

                      - **DisableScaleIn** *(boolean) --*

                        Indicates whether scale in by the target tracking policy is disabled. If
                        the value is true, scale in is disabled and the target tracking policy
                        won't remove capacity from the scalable resource. Otherwise, scale in is
                        enabled and the target tracking policy can remove capacity from the
                        scalable resource. The default value is false.

                      - **ScaleInCooldown** *(integer) --*

                        The amount of time, in seconds, after a scale in activity completes before
                        another scale in activity can start. The cooldown period is used to block
                        subsequent scale in requests until it has expired. You should scale in
                        conservatively to protect your application's availability. However, if
                        another alarm triggers a scale out policy during the cooldown period after
                        a scale-in, application auto scaling scales out your scalable target
                        immediately.

                      - **ScaleOutCooldown** *(integer) --*

                        The amount of time, in seconds, after a scale out activity completes before
                        another scale out activity can start. While the cooldown period is in
                        effect, the capacity that has been added by the previous scale out event
                        that initiated the cooldown is calculated as part of the desired capacity
                        for the next scale out. You should continuously (but not excessively) scale
                        out.

                      - **TargetValue** *(float) --*

                        The target value for the metric. The range is 8.515920e-109 to
                        1.174271e+108 (Base 10) or 2e-360 to 2e360 (Base 2).

          - **ReplicaProvisionedReadCapacityAutoScalingSettings** *(dict) --*

            Represents the auto scaling settings for a global table or global secondary index.

            - **MinimumUnits** *(integer) --*

              The minimum capacity units that a global table or global secondary index should be
              scaled down to.

            - **MaximumUnits** *(integer) --*

              The maximum capacity units that a global table or global secondary index should be
              scaled up to.

            - **AutoScalingDisabled** *(boolean) --*

              Disabled auto scaling for this global table or global secondary index.

            - **AutoScalingRoleArn** *(string) --*

              Role ARN used for configuring the auto scaling policy.

            - **ScalingPolicies** *(list) --*

              Information about the scaling policies.

              - *(dict) --*

                Represents the properties of the scaling policy.

                - **PolicyName** *(string) --*

                  The name of the scaling policy.

                - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                  Represents a target tracking scaling policy configuration.

                  - **DisableScaleIn** *(boolean) --*

                    Indicates whether scale in by the target tracking policy is disabled. If the
                    value is true, scale in is disabled and the target tracking policy won't remove
                    capacity from the scalable resource. Otherwise, scale in is enabled and the
                    target tracking policy can remove capacity from the scalable resource. The
                    default value is false.

                  - **ScaleInCooldown** *(integer) --*

                    The amount of time, in seconds, after a scale in activity completes before
                    another scale in activity can start. The cooldown period is used to block
                    subsequent scale in requests until it has expired. You should scale in
                    conservatively to protect your application's availability. However, if another
                    alarm triggers a scale out policy during the cooldown period after a scale-in,
                    application auto scaling scales out your scalable target immediately.

                  - **ScaleOutCooldown** *(integer) --*

                    The amount of time, in seconds, after a scale out activity completes before
                    another scale out activity can start. While the cooldown period is in effect,
                    the capacity that has been added by the previous scale out event that initiated
                    the cooldown is calculated as part of the desired capacity for the next scale
                    out. You should continuously (but not excessively) scale out.

                  - **TargetValue** *(float) --*

                    The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                    (Base 10) or 2e-360 to 2e360 (Base 2).

          - **ReplicaProvisionedWriteCapacityAutoScalingSettings** *(dict) --*

            Represents the auto scaling settings for a global table or global secondary index.

            - **MinimumUnits** *(integer) --*

              The minimum capacity units that a global table or global secondary index should be
              scaled down to.

            - **MaximumUnits** *(integer) --*

              The maximum capacity units that a global table or global secondary index should be
              scaled up to.

            - **AutoScalingDisabled** *(boolean) --*

              Disabled auto scaling for this global table or global secondary index.

            - **AutoScalingRoleArn** *(string) --*

              Role ARN used for configuring the auto scaling policy.

            - **ScalingPolicies** *(list) --*

              Information about the scaling policies.

              - *(dict) --*

                Represents the properties of the scaling policy.

                - **PolicyName** *(string) --*

                  The name of the scaling policy.

                - **TargetTrackingScalingPolicyConfiguration** *(dict) --*

                  Represents a target tracking scaling policy configuration.

                  - **DisableScaleIn** *(boolean) --*

                    Indicates whether scale in by the target tracking policy is disabled. If the
                    value is true, scale in is disabled and the target tracking policy won't remove
                    capacity from the scalable resource. Otherwise, scale in is enabled and the
                    target tracking policy can remove capacity from the scalable resource. The
                    default value is false.

                  - **ScaleInCooldown** *(integer) --*

                    The amount of time, in seconds, after a scale in activity completes before
                    another scale in activity can start. The cooldown period is used to block
                    subsequent scale in requests until it has expired. You should scale in
                    conservatively to protect your application's availability. However, if another
                    alarm triggers a scale out policy during the cooldown period after a scale-in,
                    application auto scaling scales out your scalable target immediately.

                  - **ScaleOutCooldown** *(integer) --*

                    The amount of time, in seconds, after a scale out activity completes before
                    another scale out activity can start. While the cooldown period is in effect,
                    the capacity that has been added by the previous scale out event that initiated
                    the cooldown is calculated as part of the desired capacity for the next scale
                    out. You should continuously (but not excessively) scale out.

                  - **TargetValue** *(float) --*

                    The target value for the metric. The range is 8.515920e-109 to 1.174271e+108
                    (Base 10) or 2e-360 to 2e360 (Base 2).

          - **ReplicaStatus** *(string) --*

            The current state of the replica:

            * ``CREATING`` - The replica is being created.

            * ``UPDATING`` - The replica is being updated.

            * ``DELETING`` - The replica is being deleted.

            * ``ACTIVE`` - The replica is ready for use.
    """


_ClientDescribeTableResponseTableAttributeDefinitionsTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableAttributeDefinitionsTypeDef",
    {"AttributeName": str, "AttributeType": str},
    total=False,
)


class ClientDescribeTableResponseTableAttributeDefinitionsTypeDef(
    _ClientDescribeTableResponseTableAttributeDefinitionsTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `AttributeDefinitions`

    Represents an attribute for describing the key schema for the table and indexes.

    - **AttributeName** *(string) --*

      A name for the attribute.

    - **AttributeType** *(string) --*

      The data type for the attribute, where:

      * ``S`` - the attribute is of type String

      * ``N`` - the attribute is of type Number

      * ``B`` - the attribute is of type Binary
    """


_ClientDescribeTableResponseTableBillingModeSummaryTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableBillingModeSummaryTypeDef",
    {"BillingMode": str, "LastUpdateToPayPerRequestDateTime": datetime},
    total=False,
)


class ClientDescribeTableResponseTableBillingModeSummaryTypeDef(
    _ClientDescribeTableResponseTableBillingModeSummaryTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `BillingModeSummary`

    Contains the details for the read/write capacity mode.

    - **BillingMode** *(string) --*

      Controls how you are charged for read and write throughput and how you manage capacity.
      This setting can be changed later.

      * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
      using ``PROVISIONED`` for predictable workloads.

      * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
      recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

    - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

      Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.
    """


_ClientDescribeTableResponseTableGlobalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableGlobalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDescribeTableResponseTableGlobalSecondaryIndexesKeySchemaTypeDef(
    _ClientDescribeTableResponseTableGlobalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableGlobalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDescribeTableResponseTableGlobalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableGlobalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDescribeTableResponseTableGlobalSecondaryIndexesProjectionTypeDef(
    _ClientDescribeTableResponseTableGlobalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableGlobalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
      list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDescribeTableResponseTableGlobalSecondaryIndexesProvisionedThroughputTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableGlobalSecondaryIndexesProvisionedThroughputTypeDef",
    {
        "LastIncreaseDateTime": datetime,
        "LastDecreaseDateTime": datetime,
        "NumberOfDecreasesToday": int,
        "ReadCapacityUnits": int,
        "WriteCapacityUnits": int,
    },
    total=False,
)


class ClientDescribeTableResponseTableGlobalSecondaryIndexesProvisionedThroughputTypeDef(
    _ClientDescribeTableResponseTableGlobalSecondaryIndexesProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableGlobalSecondaryIndexes` `ProvisionedThroughput`

    Represents the provisioned throughput settings for the specified global secondary index.

    For current minimum and maximum provisioned throughput values, see `Limits
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
    the *Amazon DynamoDB Developer Guide* .

    - **LastIncreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput increase for this table.

    - **LastDecreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput decrease for this table.

    - **NumberOfDecreasesToday** *(integer) --*

      The number of provisioned throughput decreases for this table during this UTC
      calendar day. For current maximums on provisioned throughput decreases, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
      the *Amazon DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . Eventually consistent reads require less effort
      than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
      provides 100 eventually consistent ``ReadCapacityUnits`` per second.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` .
    """


_ClientDescribeTableResponseTableGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDescribeTableResponseTableGlobalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDescribeTableResponseTableGlobalSecondaryIndexesProjectionTypeDef,
        "IndexStatus": str,
        "Backfilling": bool,
        "ProvisionedThroughput": ClientDescribeTableResponseTableGlobalSecondaryIndexesProvisionedThroughputTypeDef,
        "IndexSizeBytes": int,
        "ItemCount": int,
        "IndexArn": str,
    },
    total=False,
)


class ClientDescribeTableResponseTableGlobalSecondaryIndexesTypeDef(
    _ClientDescribeTableResponseTableGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `GlobalSecondaryIndexes`

    Represents the properties of a global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for a global secondary index, which consists of one or more
      pairs of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
        list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **IndexStatus** *(string) --*

      The current state of the global secondary index:

      * ``CREATING`` - The index is being created.

      * ``UPDATING`` - The index is being updated.

      * ``DELETING`` - The index is being deleted.

      * ``ACTIVE`` - The index is ready for use.

    - **Backfilling** *(boolean) --*

      Indicates whether the index is currently backfilling. *Backfilling* is the process of
      reading items from the table and determining whether they can be added to the index.
      (Not all items will qualify: For example, a partition key cannot have any duplicate
      values.) If an item can be added to the index, DynamoDB will do so. After all items
      have been processed, the backfilling operation is complete and ``Backfilling`` is false.

      You can delete an index that is being created during the ``Backfilling`` phase when
      ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
      index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
      is false.

      .. note::

        For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
        attribute does not appear in the ``DescribeTable`` output.

    - **ProvisionedThroughput** *(dict) --*

      Represents the provisioned throughput settings for the specified global secondary index.

      For current minimum and maximum provisioned throughput values, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
      the *Amazon DynamoDB Developer Guide* .

      - **LastIncreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput increase for this table.

      - **LastDecreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput decrease for this table.

      - **NumberOfDecreasesToday** *(integer) --*

        The number of provisioned throughput decreases for this table during this UTC
        calendar day. For current maximums on provisioned throughput decreases, see `Limits
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
        the *Amazon DynamoDB Developer Guide* .

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . Eventually consistent reads require less effort
        than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
        provides 100 eventually consistent ``ReadCapacityUnits`` per second.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` .

    - **IndexSizeBytes** *(integer) --*

      The total size of the specified index, in bytes. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified index. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **IndexArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the index.
    """


_ClientDescribeTableResponseTableKeySchemaTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDescribeTableResponseTableKeySchemaTypeDef(
    _ClientDescribeTableResponseTableKeySchemaTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes that
    make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
    a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
    key). A composite primary key would require one ``KeySchemaElement`` for the partition
    key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
    The data type must be one of String, Number, or Binary. The attribute cannot be nested
    within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDescribeTableResponseTableLocalSecondaryIndexesKeySchemaTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableLocalSecondaryIndexesKeySchemaTypeDef",
    {"AttributeName": str, "KeyType": str},
    total=False,
)


class ClientDescribeTableResponseTableLocalSecondaryIndexesKeySchemaTypeDef(
    _ClientDescribeTableResponseTableLocalSecondaryIndexesKeySchemaTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableLocalSecondaryIndexes` `KeySchema`

    Represents *a single element* of a key schema. A key schema specifies the attributes
    that make up the primary key of a table, or the key attributes of an index.

    A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
    example, a simple primary key would be represented by one ``KeySchemaElement`` (for
    the partition key). A composite primary key would require one ``KeySchemaElement``
    for the partition key, and another ``KeySchemaElement`` for the sort key.

    A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
    attribute). The data type must be one of String, Number, or Binary. The attribute
    cannot be nested within a List or a Map.

    - **AttributeName** *(string) --*

      The name of a key attribute.

    - **KeyType** *(string) --*

      The role that this key attribute will assume:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term
        "hash attribute" derives from DynamoDB's usage of an internal hash function to
        evenly distribute data items across partitions, based on their partition key
        values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.
    """


_ClientDescribeTableResponseTableLocalSecondaryIndexesProjectionTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableLocalSecondaryIndexesProjectionTypeDef",
    {"ProjectionType": str, "NonKeyAttributes": List[str]},
    total=False,
)


class ClientDescribeTableResponseTableLocalSecondaryIndexesProjectionTypeDef(
    _ClientDescribeTableResponseTableLocalSecondaryIndexesProjectionTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableLocalSecondaryIndexes` `Projection`

    Represents attributes that are copied (projected) from the table into the global
    secondary index. These are in addition to the primary key attributes and index key
    attributes, which are automatically projected.

    - **ProjectionType** *(string) --*

      The set of attributes that are projected into the index:

      * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

      * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
      list of projected attributes is in ``NonKeyAttributes`` .

      * ``ALL`` - All of the table attributes are projected into the index.

    - **NonKeyAttributes** *(list) --*

      Represents the non-key attribute names which will be projected into the index.

      For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
      all of the local secondary indexes, must not exceed 20. If you project the same
      attribute into two different indexes, this counts as two distinct attributes when
      determining the total.

      - *(string) --*
    """


_ClientDescribeTableResponseTableLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableLocalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "KeySchema": List[
            ClientDescribeTableResponseTableLocalSecondaryIndexesKeySchemaTypeDef
        ],
        "Projection": ClientDescribeTableResponseTableLocalSecondaryIndexesProjectionTypeDef,
        "IndexSizeBytes": int,
        "ItemCount": int,
        "IndexArn": str,
    },
    total=False,
)


class ClientDescribeTableResponseTableLocalSecondaryIndexesTypeDef(
    _ClientDescribeTableResponseTableLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `LocalSecondaryIndexes`

    Represents the properties of a local secondary index.

    - **IndexName** *(string) --*

      Represents the name of the local secondary index.

    - **KeySchema** *(list) --*

      The complete key schema for the local secondary index, consisting of one or more pairs
      of attribute names and key types:

      * ``HASH`` - partition key

      * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes
        that make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
        example, a simple primary key would be represented by one ``KeySchemaElement`` (for
        the partition key). A composite primary key would require one ``KeySchemaElement``
        for the partition key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
        attribute). The data type must be one of String, Number, or Binary. The attribute
        cannot be nested within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term
            "hash attribute" derives from DynamoDB's usage of an internal hash function to
            evenly distribute data items across partitions, based on their partition key
            values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **Projection** *(dict) --*

      Represents attributes that are copied (projected) from the table into the global
      secondary index. These are in addition to the primary key attributes and index key
      attributes, which are automatically projected.

      - **ProjectionType** *(string) --*

        The set of attributes that are projected into the index:

        * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

        * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
        list of projected attributes is in ``NonKeyAttributes`` .

        * ``ALL`` - All of the table attributes are projected into the index.

      - **NonKeyAttributes** *(list) --*

        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
        all of the local secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

        - *(string) --*

    - **IndexSizeBytes** *(integer) --*

      The total size of the specified index, in bytes. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified index. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **IndexArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the index.
    """


_ClientDescribeTableResponseTableProvisionedThroughputTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableProvisionedThroughputTypeDef",
    {
        "LastIncreaseDateTime": datetime,
        "LastDecreaseDateTime": datetime,
        "NumberOfDecreasesToday": int,
        "ReadCapacityUnits": int,
        "WriteCapacityUnits": int,
    },
    total=False,
)


class ClientDescribeTableResponseTableProvisionedThroughputTypeDef(
    _ClientDescribeTableResponseTableProvisionedThroughputTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `ProvisionedThroughput`

    The provisioned throughput settings for the table, consisting of read and write capacity
    units, along with data about increases and decreases.

    - **LastIncreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput increase for this table.

    - **LastDecreaseDateTime** *(datetime) --*

      The date and time of the last provisioned throughput decrease for this table.

    - **NumberOfDecreasesToday** *(integer) --*

      The number of provisioned throughput decreases for this table during this UTC calendar
      day. For current maximums on provisioned throughput decreases, see `Limits
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
      *Amazon DynamoDB Developer Guide* .

    - **ReadCapacityUnits** *(integer) --*

      The maximum number of strongly consistent reads consumed per second before DynamoDB
      returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
      strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
      100 eventually consistent ``ReadCapacityUnits`` per second.

    - **WriteCapacityUnits** *(integer) --*

      The maximum number of writes consumed per second before DynamoDB returns a
      ``ThrottlingException`` .
    """


_ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef(
    _ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexes` `ProvisionedThroughputOverride`

    If not described, uses the source table GSI's read capacity settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's
      read capacity settings.
    """


_ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesTypeDef",
    {
        "IndexName": str,
        "ProvisionedThroughputOverride": ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesProvisionedThroughputOverrideTypeDef,
    },
    total=False,
)


class ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesTypeDef(
    _ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableReplicas` `GlobalSecondaryIndexes`

    Represents the properties of a replica global secondary index.

    - **IndexName** *(string) --*

      The name of the global secondary index.

    - **ProvisionedThroughputOverride** *(dict) --*

      If not described, uses the source table GSI's read capacity settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's
        read capacity settings.
    """


_ClientDescribeTableResponseTableReplicasProvisionedThroughputOverrideTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableReplicasProvisionedThroughputOverrideTypeDef",
    {"ReadCapacityUnits": int},
    total=False,
)


class ClientDescribeTableResponseTableReplicasProvisionedThroughputOverrideTypeDef(
    _ClientDescribeTableResponseTableReplicasProvisionedThroughputOverrideTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTableReplicas` `ProvisionedThroughputOverride`

    Replica-specific provisioned throughput. If not described, uses the source table's
    provisioned throughput settings.

    - **ReadCapacityUnits** *(integer) --*

      Replica-specific read capacity units. If not specified, uses the source table's read
      capacity settings.
    """


_ClientDescribeTableResponseTableReplicasTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableReplicasTypeDef",
    {
        "RegionName": str,
        "ReplicaStatus": str,
        "ReplicaStatusDescription": str,
        "ReplicaStatusPercentProgress": str,
        "KMSMasterKeyId": str,
        "ProvisionedThroughputOverride": ClientDescribeTableResponseTableReplicasProvisionedThroughputOverrideTypeDef,
        "GlobalSecondaryIndexes": List[
            ClientDescribeTableResponseTableReplicasGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientDescribeTableResponseTableReplicasTypeDef(
    _ClientDescribeTableResponseTableReplicasTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `Replicas`

    Contains the details of the replica.

    - **RegionName** *(string) --*

      The name of the Region.

    - **ReplicaStatus** *(string) --*

      The current state of the replica:

      * ``CREATING`` - The replica is being created.

      * ``UPDATING`` - The replica is being updated.

      * ``DELETING`` - The replica is being deleted.

      * ``ACTIVE`` - The replica is ready for use.

    - **ReplicaStatusDescription** *(string) --*

      Detailed information about the replica status.

    - **ReplicaStatusPercentProgress** *(string) --*

      Specifies the progress of a Create, Update, or Delete action on the replica as a
      percentage.

    - **KMSMasterKeyId** *(string) --*

      The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
      encryption.

    - **ProvisionedThroughputOverride** *(dict) --*

      Replica-specific provisioned throughput. If not described, uses the source table's
      provisioned throughput settings.

      - **ReadCapacityUnits** *(integer) --*

        Replica-specific read capacity units. If not specified, uses the source table's read
        capacity settings.

    - **GlobalSecondaryIndexes** *(list) --*

      Replica-specific global secondary index settings.

      - *(dict) --*

        Represents the properties of a replica global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **ProvisionedThroughputOverride** *(dict) --*

          If not described, uses the source table GSI's read capacity settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's
            read capacity settings.
    """


_ClientDescribeTableResponseTableRestoreSummaryTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableRestoreSummaryTypeDef",
    {
        "SourceBackupArn": str,
        "SourceTableArn": str,
        "RestoreDateTime": datetime,
        "RestoreInProgress": bool,
    },
    total=False,
)


class ClientDescribeTableResponseTableRestoreSummaryTypeDef(
    _ClientDescribeTableResponseTableRestoreSummaryTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `RestoreSummary`

    Contains details for the restore.

    - **SourceBackupArn** *(string) --*

      The Amazon Resource Name (ARN) of the backup from which the table was restored.

    - **SourceTableArn** *(string) --*

      The ARN of the source table of the backup that is being restored.

    - **RestoreDateTime** *(datetime) --*

      Point in time or source backup time.

    - **RestoreInProgress** *(boolean) --*

      Indicates if a restore is in progress or not.
    """


_ClientDescribeTableResponseTableSSEDescriptionTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableSSEDescriptionTypeDef",
    {"Status": str, "SSEType": str, "KMSMasterKeyArn": str},
    total=False,
)


class ClientDescribeTableResponseTableSSEDescriptionTypeDef(
    _ClientDescribeTableResponseTableSSEDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `SSEDescription`

    The description of the server-side encryption status on the specified table.

    - **Status** *(string) --*

      Represents the current state of server-side encryption. The only supported values are:

      * ``ENABLED`` - Server-side encryption is enabled.

      * ``UPDATING`` - Server-side encryption is being updated.

    - **SSEType** *(string) --*

      Server-side encryption type. The only supported value is:

      * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
      stored in your account and is managed by AWS KMS (AWS KMS charges apply).

    - **KMSMasterKeyArn** *(string) --*

      The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeTableResponseTableStreamSpecificationTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableStreamSpecificationTypeDef",
    {"StreamEnabled": bool, "StreamViewType": str},
    total=False,
)


class ClientDescribeTableResponseTableStreamSpecificationTypeDef(
    _ClientDescribeTableResponseTableStreamSpecificationTypeDef
):
    """
    Type definition for `ClientDescribeTableResponseTable` `StreamSpecification`

    The current DynamoDB Streams configuration for the table.

    - **StreamEnabled** *(boolean) --*

      Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

    - **StreamViewType** *(string) --*

      When an item in the table is modified, ``StreamViewType`` determines what information is
      written to the stream for this table. Valid values for ``StreamViewType`` are:

      * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

      * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
      stream.

      * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
      the stream.

      * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
      to the stream.
    """


_ClientDescribeTableResponseTableTypeDef = TypedDict(
    "_ClientDescribeTableResponseTableTypeDef",
    {
        "AttributeDefinitions": List[
            ClientDescribeTableResponseTableAttributeDefinitionsTypeDef
        ],
        "TableName": str,
        "KeySchema": List[ClientDescribeTableResponseTableKeySchemaTypeDef],
        "TableStatus": str,
        "CreationDateTime": datetime,
        "ProvisionedThroughput": ClientDescribeTableResponseTableProvisionedThroughputTypeDef,
        "TableSizeBytes": int,
        "ItemCount": int,
        "TableArn": str,
        "TableId": str,
        "BillingModeSummary": ClientDescribeTableResponseTableBillingModeSummaryTypeDef,
        "LocalSecondaryIndexes": List[
            ClientDescribeTableResponseTableLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": List[
            ClientDescribeTableResponseTableGlobalSecondaryIndexesTypeDef
        ],
        "StreamSpecification": ClientDescribeTableResponseTableStreamSpecificationTypeDef,
        "LatestStreamLabel": str,
        "LatestStreamArn": str,
        "GlobalTableVersion": str,
        "Replicas": List[ClientDescribeTableResponseTableReplicasTypeDef],
        "RestoreSummary": ClientDescribeTableResponseTableRestoreSummaryTypeDef,
        "SSEDescription": ClientDescribeTableResponseTableSSEDescriptionTypeDef,
    },
    total=False,
)


class ClientDescribeTableResponseTableTypeDef(_ClientDescribeTableResponseTableTypeDef):
    """
    Type definition for `ClientDescribeTableResponse` `Table`

    The properties of the table.

    - **AttributeDefinitions** *(list) --*

      An array of ``AttributeDefinition`` objects. Each of these objects describes one attribute
      in the table and index key schema.

      Each ``AttributeDefinition`` object in this array is composed of:

      * ``AttributeName`` - The name of the attribute.

      * ``AttributeType`` - The data type for the attribute.

      - *(dict) --*

        Represents an attribute for describing the key schema for the table and indexes.

        - **AttributeName** *(string) --*

          A name for the attribute.

        - **AttributeType** *(string) --*

          The data type for the attribute, where:

          * ``S`` - the attribute is of type String

          * ``N`` - the attribute is of type Number

          * ``B`` - the attribute is of type Binary

    - **TableName** *(string) --*

      The name of the table.

    - **KeySchema** *(list) --*

      The primary key structure for the table. Each ``KeySchemaElement`` consists of:

      * ``AttributeName`` - The name of the attribute.

      * ``KeyType`` - The role of the attribute:

        * ``HASH`` - partition key

        * ``RANGE`` - sort key

      .. note::

        The partition key of an item is also known as its *hash attribute* . The term "hash
        attribute" derives from DynamoDB's usage of an internal hash function to evenly
        distribute data items across partitions, based on their partition key values.

        The sort key of an item is also known as its *range attribute* . The term "range
        attribute" derives from the way DynamoDB stores items with the same partition key
        physically close together, in sorted order by the sort key value.

      For more information about primary keys, see `Primary Key
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey>`__
      in the *Amazon DynamoDB Developer Guide* .

      - *(dict) --*

        Represents *a single element* of a key schema. A key schema specifies the attributes that
        make up the primary key of a table, or the key attributes of an index.

        A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
        a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
        key). A composite primary key would require one ``KeySchemaElement`` for the partition
        key, and another ``KeySchemaElement`` for the sort key.

        A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
        The data type must be one of String, Number, or Binary. The attribute cannot be nested
        within a List or a Map.

        - **AttributeName** *(string) --*

          The name of a key attribute.

        - **KeyType** *(string) --*

          The role that this key attribute will assume:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

    - **TableStatus** *(string) --*

      The current state of the table:

      * ``CREATING`` - The table is being created.

      * ``UPDATING`` - The table is being updated.

      * ``DELETING`` - The table is being deleted.

      * ``ACTIVE`` - The table is ready for use.

    - **CreationDateTime** *(datetime) --*

      The date and time when the table was created, in `UNIX epoch time
      <http://www.epochconverter.com/>`__ format.

    - **ProvisionedThroughput** *(dict) --*

      The provisioned throughput settings for the table, consisting of read and write capacity
      units, along with data about increases and decreases.

      - **LastIncreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput increase for this table.

      - **LastDecreaseDateTime** *(datetime) --*

        The date and time of the last provisioned throughput decrease for this table.

      - **NumberOfDecreasesToday** *(integer) --*

        The number of provisioned throughput decreases for this table during this UTC calendar
        day. For current maximums on provisioned throughput decreases, see `Limits
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
        *Amazon DynamoDB Developer Guide* .

      - **ReadCapacityUnits** *(integer) --*

        The maximum number of strongly consistent reads consumed per second before DynamoDB
        returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
        strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
        100 eventually consistent ``ReadCapacityUnits`` per second.

      - **WriteCapacityUnits** *(integer) --*

        The maximum number of writes consumed per second before DynamoDB returns a
        ``ThrottlingException`` .

    - **TableSizeBytes** *(integer) --*

      The total size of the specified table, in bytes. DynamoDB updates this value approximately
      every six hours. Recent changes might not be reflected in this value.

    - **ItemCount** *(integer) --*

      The number of items in the specified table. DynamoDB updates this value approximately every
      six hours. Recent changes might not be reflected in this value.

    - **TableArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the table.

    - **TableId** *(string) --*

      Unique identifier for the table for which the backup was created.

    - **BillingModeSummary** *(dict) --*

      Contains the details for the read/write capacity mode.

      - **BillingMode** *(string) --*

        Controls how you are charged for read and write throughput and how you manage capacity.
        This setting can be changed later.

        * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
        using ``PROVISIONED`` for predictable workloads.

        * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
        recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

      - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

        Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.

    - **LocalSecondaryIndexes** *(list) --*

      Represents one or more local secondary indexes on the table. Each index is scoped to a
      given partition key value. Tables with one or more local secondary indexes are subject to
      an item collection size limit, where the amount of data within a given item collection
      cannot exceed 10 GB. Each element is composed of:

      * ``IndexName`` - The name of the local secondary index.

      * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
      schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
      same partition key as the table.

      * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected. Each attribute specification is composed of:

        * ``ProjectionType`` - One of the following:

          * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

          * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
          list of projected attributes is in ``NonKeyAttributes`` .

          * ``ALL`` - All of the table attributes are projected into the index.

        * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
        into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
        , summed across all of the secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

      * ``IndexSizeBytes`` - Represents the total size of the index, in bytes. DynamoDB updates
      this value approximately every six hours. Recent changes might not be reflected in this
      value.

      * ``ItemCount`` - Represents the number of items in the index. DynamoDB updates this value
      approximately every six hours. Recent changes might not be reflected in this value.

      If the table is in the ``DELETING`` state, no information about indexes will be returned.

      - *(dict) --*

        Represents the properties of a local secondary index.

        - **IndexName** *(string) --*

          Represents the name of the local secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for the local secondary index, consisting of one or more pairs
          of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **IndexSizeBytes** *(integer) --*

          The total size of the specified index, in bytes. DynamoDB updates this value
          approximately every six hours. Recent changes might not be reflected in this value.

        - **ItemCount** *(integer) --*

          The number of items in the specified index. DynamoDB updates this value approximately
          every six hours. Recent changes might not be reflected in this value.

        - **IndexArn** *(string) --*

          The Amazon Resource Name (ARN) that uniquely identifies the index.

    - **GlobalSecondaryIndexes** *(list) --*

      The global secondary indexes, if any, on the table. Each index is scoped to a given
      partition key value. Each element is composed of:

      * ``Backfilling`` - If true, then the index is currently in the backfilling phase.
      Backfilling occurs only when a new global secondary index is added to the table. It is the
      process by which DynamoDB populates the new index with data from the table. (This attribute
      does not appear for indexes that were created during a ``CreateTable`` operation.)  You can
      delete an index that is being created during the ``Backfilling`` phase when ``IndexStatus``
      is set to CREATING and ``Backfilling`` is true. You can't delete the index that is being
      created when ``IndexStatus`` is set to CREATING and ``Backfilling`` is false. (This
      attribute does not appear for indexes that were created during a ``CreateTable`` operation.)

      * ``IndexName`` - The name of the global secondary index.

      * ``IndexSizeBytes`` - The total size of the global secondary index, in bytes. DynamoDB
      updates this value approximately every six hours. Recent changes might not be reflected in
      this value.

      * ``IndexStatus`` - The current status of the global secondary index:

        * ``CREATING`` - The index is being created.

        * ``UPDATING`` - The index is being updated.

        * ``DELETING`` - The index is being deleted.

        * ``ACTIVE`` - The index is ready for use.

      * ``ItemCount`` - The number of items in the global secondary index. DynamoDB updates this
      value approximately every six hours. Recent changes might not be reflected in this value.

      * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
      schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
      same partition key as the table.

      * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
      index. These are in addition to the primary key attributes and index key attributes, which
      are automatically projected. Each attribute specification is composed of:

        * ``ProjectionType`` - One of the following:

          * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

          * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
          list of projected attributes is in ``NonKeyAttributes`` .

          * ``ALL`` - All of the table attributes are projected into the index.

        * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
        into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
        , summed across all of the secondary indexes, must not exceed 20. If you project the same
        attribute into two different indexes, this counts as two distinct attributes when
        determining the total.

      * ``ProvisionedThroughput`` - The provisioned throughput settings for the global secondary
      index, consisting of read and write capacity units, along with data about increases and
      decreases.

      If the table is in the ``DELETING`` state, no information about indexes will be returned.

      - *(dict) --*

        Represents the properties of a global secondary index.

        - **IndexName** *(string) --*

          The name of the global secondary index.

        - **KeySchema** *(list) --*

          The complete key schema for a global secondary index, which consists of one or more
          pairs of attribute names and key types:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

          .. note::

            The partition key of an item is also known as its *hash attribute* . The term "hash
            attribute" derives from DynamoDB's usage of an internal hash function to evenly
            distribute data items across partitions, based on their partition key values.

            The sort key of an item is also known as its *range attribute* . The term "range
            attribute" derives from the way DynamoDB stores items with the same partition key
            physically close together, in sorted order by the sort key value.

          - *(dict) --*

            Represents *a single element* of a key schema. A key schema specifies the attributes
            that make up the primary key of a table, or the key attributes of an index.

            A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
            example, a simple primary key would be represented by one ``KeySchemaElement`` (for
            the partition key). A composite primary key would require one ``KeySchemaElement``
            for the partition key, and another ``KeySchemaElement`` for the sort key.

            A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
            attribute). The data type must be one of String, Number, or Binary. The attribute
            cannot be nested within a List or a Map.

            - **AttributeName** *(string) --*

              The name of a key attribute.

            - **KeyType** *(string) --*

              The role that this key attribute will assume:

              * ``HASH`` - partition key

              * ``RANGE`` - sort key

              .. note::

                The partition key of an item is also known as its *hash attribute* . The term
                "hash attribute" derives from DynamoDB's usage of an internal hash function to
                evenly distribute data items across partitions, based on their partition key
                values.

                The sort key of an item is also known as its *range attribute* . The term "range
                attribute" derives from the way DynamoDB stores items with the same partition key
                physically close together, in sorted order by the sort key value.

        - **Projection** *(dict) --*

          Represents attributes that are copied (projected) from the table into the global
          secondary index. These are in addition to the primary key attributes and index key
          attributes, which are automatically projected.

          - **ProjectionType** *(string) --*

            The set of attributes that are projected into the index:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          - **NonKeyAttributes** *(list) --*

            Represents the non-key attribute names which will be projected into the index.

            For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
            all of the local secondary indexes, must not exceed 20. If you project the same
            attribute into two different indexes, this counts as two distinct attributes when
            determining the total.

            - *(string) --*

        - **IndexStatus** *(string) --*

          The current state of the global secondary index:

          * ``CREATING`` - The index is being created.

          * ``UPDATING`` - The index is being updated.

          * ``DELETING`` - The index is being deleted.

          * ``ACTIVE`` - The index is ready for use.

        - **Backfilling** *(boolean) --*

          Indicates whether the index is currently backfilling. *Backfilling* is the process of
          reading items from the table and determining whether they can be added to the index.
          (Not all items will qualify: For example, a partition key cannot have any duplicate
          values.) If an item can be added to the index, DynamoDB will do so. After all items
          have been processed, the backfilling operation is complete and ``Backfilling`` is false.

          You can delete an index that is being created during the ``Backfilling`` phase when
          ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
          index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
          is false.

          .. note::

            For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
            attribute does not appear in the ``DescribeTable`` output.

        - **ProvisionedThroughput** *(dict) --*

          Represents the provisioned throughput settings for the specified global secondary index.

          For current minimum and maximum provisioned throughput values, see `Limits
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
          the *Amazon DynamoDB Developer Guide* .

          - **LastIncreaseDateTime** *(datetime) --*

            The date and time of the last provisioned throughput increase for this table.

          - **LastDecreaseDateTime** *(datetime) --*

            The date and time of the last provisioned throughput decrease for this table.

          - **NumberOfDecreasesToday** *(integer) --*

            The number of provisioned throughput decreases for this table during this UTC
            calendar day. For current maximums on provisioned throughput decreases, see `Limits
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
            the *Amazon DynamoDB Developer Guide* .

          - **ReadCapacityUnits** *(integer) --*

            The maximum number of strongly consistent reads consumed per second before DynamoDB
            returns a ``ThrottlingException`` . Eventually consistent reads require less effort
            than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
            provides 100 eventually consistent ``ReadCapacityUnits`` per second.

          - **WriteCapacityUnits** *(integer) --*

            The maximum number of writes consumed per second before DynamoDB returns a
            ``ThrottlingException`` .

        - **IndexSizeBytes** *(integer) --*

          The total size of the specified index, in bytes. DynamoDB updates this value
          approximately every six hours. Recent changes might not be reflected in this value.

        - **ItemCount** *(integer) --*

          The number of items in the specified index. DynamoDB updates this value approximately
          every six hours. Recent changes might not be reflected in this value.

        - **IndexArn** *(string) --*

          The Amazon Resource Name (ARN) that uniquely identifies the index.

    - **StreamSpecification** *(dict) --*

      The current DynamoDB Streams configuration for the table.

      - **StreamEnabled** *(boolean) --*

        Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

      - **StreamViewType** *(string) --*

        When an item in the table is modified, ``StreamViewType`` determines what information is
        written to the stream for this table. Valid values for ``StreamViewType`` are:

        * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

        * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
        stream.

        * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
        the stream.

        * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
        to the stream.

    - **LatestStreamLabel** *(string) --*

      A timestamp, in ISO 8601 format, for this stream.

      Note that ``LatestStreamLabel`` is not a unique identifier for the stream, because it is
      possible that a stream from another table might have the same timestamp. However, the
      combination of the following three elements is guaranteed to be unique:

      * AWS customer ID

      * Table name

      * ``StreamLabel``

    - **LatestStreamArn** *(string) --*

      The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.

    - **GlobalTableVersion** *(string) --*

      Represents the version of `global tables
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html>`__ in
      use, if the table is replicated across AWS Regions.

    - **Replicas** *(list) --*

      Represents replicas of the table.

      - *(dict) --*

        Contains the details of the replica.

        - **RegionName** *(string) --*

          The name of the Region.

        - **ReplicaStatus** *(string) --*

          The current state of the replica:

          * ``CREATING`` - The replica is being created.

          * ``UPDATING`` - The replica is being updated.

          * ``DELETING`` - The replica is being deleted.

          * ``ACTIVE`` - The replica is ready for use.

        - **ReplicaStatusDescription** *(string) --*

          Detailed information about the replica status.

        - **ReplicaStatusPercentProgress** *(string) --*

          Specifies the progress of a Create, Update, or Delete action on the replica as a
          percentage.

        - **KMSMasterKeyId** *(string) --*

          The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
          encryption.

        - **ProvisionedThroughputOverride** *(dict) --*

          Replica-specific provisioned throughput. If not described, uses the source table's
          provisioned throughput settings.

          - **ReadCapacityUnits** *(integer) --*

            Replica-specific read capacity units. If not specified, uses the source table's read
            capacity settings.

        - **GlobalSecondaryIndexes** *(list) --*

          Replica-specific global secondary index settings.

          - *(dict) --*

            Represents the properties of a replica global secondary index.

            - **IndexName** *(string) --*

              The name of the global secondary index.

            - **ProvisionedThroughputOverride** *(dict) --*

              If not described, uses the source table GSI's read capacity settings.

              - **ReadCapacityUnits** *(integer) --*

                Replica-specific read capacity units. If not specified, uses the source table's
                read capacity settings.

    - **RestoreSummary** *(dict) --*

      Contains details for the restore.

      - **SourceBackupArn** *(string) --*

        The Amazon Resource Name (ARN) of the backup from which the table was restored.

      - **SourceTableArn** *(string) --*

        The ARN of the source table of the backup that is being restored.

      - **RestoreDateTime** *(datetime) --*

        Point in time or source backup time.

      - **RestoreInProgress** *(boolean) --*

        Indicates if a restore is in progress or not.

    - **SSEDescription** *(dict) --*

      The description of the server-side encryption status on the specified table.

      - **Status** *(string) --*

        Represents the current state of server-side encryption. The only supported values are:

        * ``ENABLED`` - Server-side encryption is enabled.

        * ``UPDATING`` - Server-side encryption is being updated.

      - **SSEType** *(string) --*

        Server-side encryption type. The only supported value is:

        * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
        stored in your account and is managed by AWS KMS (AWS KMS charges apply).

      - **KMSMasterKeyArn** *(string) --*

        The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeTableResponseTypeDef = TypedDict(
    "_ClientDescribeTableResponseTypeDef",
    {"Table": ClientDescribeTableResponseTableTypeDef},
    total=False,
)


class ClientDescribeTableResponseTypeDef(_ClientDescribeTableResponseTypeDef):
    """
    Type definition for `ClientDescribeTable` `Response`

    Represents the output of a ``DescribeTable`` operation.

    - **Table** *(dict) --*

      The properties of the table.

      - **AttributeDefinitions** *(list) --*

        An array of ``AttributeDefinition`` objects. Each of these objects describes one attribute
        in the table and index key schema.

        Each ``AttributeDefinition`` object in this array is composed of:

        * ``AttributeName`` - The name of the attribute.

        * ``AttributeType`` - The data type for the attribute.

        - *(dict) --*

          Represents an attribute for describing the key schema for the table and indexes.

          - **AttributeName** *(string) --*

            A name for the attribute.

          - **AttributeType** *(string) --*

            The data type for the attribute, where:

            * ``S`` - the attribute is of type String

            * ``N`` - the attribute is of type Number

            * ``B`` - the attribute is of type Binary

      - **TableName** *(string) --*

        The name of the table.

      - **KeySchema** *(list) --*

        The primary key structure for the table. Each ``KeySchemaElement`` consists of:

        * ``AttributeName`` - The name of the attribute.

        * ``KeyType`` - The role of the attribute:

          * ``HASH`` - partition key

          * ``RANGE`` - sort key

        .. note::

          The partition key of an item is also known as its *hash attribute* . The term "hash
          attribute" derives from DynamoDB's usage of an internal hash function to evenly
          distribute data items across partitions, based on their partition key values.

          The sort key of an item is also known as its *range attribute* . The term "range
          attribute" derives from the way DynamoDB stores items with the same partition key
          physically close together, in sorted order by the sort key value.

        For more information about primary keys, see `Primary Key
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey>`__
        in the *Amazon DynamoDB Developer Guide* .

        - *(dict) --*

          Represents *a single element* of a key schema. A key schema specifies the attributes that
          make up the primary key of a table, or the key attributes of an index.

          A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example,
          a simple primary key would be represented by one ``KeySchemaElement`` (for the partition
          key). A composite primary key would require one ``KeySchemaElement`` for the partition
          key, and another ``KeySchemaElement`` for the sort key.

          A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute).
          The data type must be one of String, Number, or Binary. The attribute cannot be nested
          within a List or a Map.

          - **AttributeName** *(string) --*

            The name of a key attribute.

          - **KeyType** *(string) --*

            The role that this key attribute will assume:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

      - **TableStatus** *(string) --*

        The current state of the table:

        * ``CREATING`` - The table is being created.

        * ``UPDATING`` - The table is being updated.

        * ``DELETING`` - The table is being deleted.

        * ``ACTIVE`` - The table is ready for use.

      - **CreationDateTime** *(datetime) --*

        The date and time when the table was created, in `UNIX epoch time
        <http://www.epochconverter.com/>`__ format.

      - **ProvisionedThroughput** *(dict) --*

        The provisioned throughput settings for the table, consisting of read and write capacity
        units, along with data about increases and decreases.

        - **LastIncreaseDateTime** *(datetime) --*

          The date and time of the last provisioned throughput increase for this table.

        - **LastDecreaseDateTime** *(datetime) --*

          The date and time of the last provisioned throughput decrease for this table.

        - **NumberOfDecreasesToday** *(integer) --*

          The number of provisioned throughput decreases for this table during this UTC calendar
          day. For current maximums on provisioned throughput decreases, see `Limits
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in the
          *Amazon DynamoDB Developer Guide* .

        - **ReadCapacityUnits** *(integer) --*

          The maximum number of strongly consistent reads consumed per second before DynamoDB
          returns a ``ThrottlingException`` . Eventually consistent reads require less effort than
          strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second provides
          100 eventually consistent ``ReadCapacityUnits`` per second.

        - **WriteCapacityUnits** *(integer) --*

          The maximum number of writes consumed per second before DynamoDB returns a
          ``ThrottlingException`` .

      - **TableSizeBytes** *(integer) --*

        The total size of the specified table, in bytes. DynamoDB updates this value approximately
        every six hours. Recent changes might not be reflected in this value.

      - **ItemCount** *(integer) --*

        The number of items in the specified table. DynamoDB updates this value approximately every
        six hours. Recent changes might not be reflected in this value.

      - **TableArn** *(string) --*

        The Amazon Resource Name (ARN) that uniquely identifies the table.

      - **TableId** *(string) --*

        Unique identifier for the table for which the backup was created.

      - **BillingModeSummary** *(dict) --*

        Contains the details for the read/write capacity mode.

        - **BillingMode** *(string) --*

          Controls how you are charged for read and write throughput and how you manage capacity.
          This setting can be changed later.

          * ``PROVISIONED`` - Sets the read/write capacity mode to ``PROVISIONED`` . We recommend
          using ``PROVISIONED`` for predictable workloads.

          * ``PAY_PER_REQUEST`` - Sets the read/write capacity mode to ``PAY_PER_REQUEST`` . We
          recommend using ``PAY_PER_REQUEST`` for unpredictable workloads.

        - **LastUpdateToPayPerRequestDateTime** *(datetime) --*

          Represents the time when ``PAY_PER_REQUEST`` was last set as the read/write capacity mode.

      - **LocalSecondaryIndexes** *(list) --*

        Represents one or more local secondary indexes on the table. Each index is scoped to a
        given partition key value. Tables with one or more local secondary indexes are subject to
        an item collection size limit, where the amount of data within a given item collection
        cannot exceed 10 GB. Each element is composed of:

        * ``IndexName`` - The name of the local secondary index.

        * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
        same partition key as the table.

        * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
        index. These are in addition to the primary key attributes and index key attributes, which
        are automatically projected. Each attribute specification is composed of:

          * ``ProjectionType`` - One of the following:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
          into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
          , summed across all of the secondary indexes, must not exceed 20. If you project the same
          attribute into two different indexes, this counts as two distinct attributes when
          determining the total.

        * ``IndexSizeBytes`` - Represents the total size of the index, in bytes. DynamoDB updates
        this value approximately every six hours. Recent changes might not be reflected in this
        value.

        * ``ItemCount`` - Represents the number of items in the index. DynamoDB updates this value
        approximately every six hours. Recent changes might not be reflected in this value.

        If the table is in the ``DELETING`` state, no information about indexes will be returned.

        - *(dict) --*

          Represents the properties of a local secondary index.

          - **IndexName** *(string) --*

            Represents the name of the local secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for the local secondary index, consisting of one or more pairs
            of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the attributes
              that make up the primary key of a table, or the key attributes of an index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term "range
                  attribute" derives from the way DynamoDB stores items with the same partition key
                  physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
              list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **IndexSizeBytes** *(integer) --*

            The total size of the specified index, in bytes. DynamoDB updates this value
            approximately every six hours. Recent changes might not be reflected in this value.

          - **ItemCount** *(integer) --*

            The number of items in the specified index. DynamoDB updates this value approximately
            every six hours. Recent changes might not be reflected in this value.

          - **IndexArn** *(string) --*

            The Amazon Resource Name (ARN) that uniquely identifies the index.

      - **GlobalSecondaryIndexes** *(list) --*

        The global secondary indexes, if any, on the table. Each index is scoped to a given
        partition key value. Each element is composed of:

        * ``Backfilling`` - If true, then the index is currently in the backfilling phase.
        Backfilling occurs only when a new global secondary index is added to the table. It is the
        process by which DynamoDB populates the new index with data from the table. (This attribute
        does not appear for indexes that were created during a ``CreateTable`` operation.)  You can
        delete an index that is being created during the ``Backfilling`` phase when ``IndexStatus``
        is set to CREATING and ``Backfilling`` is true. You can't delete the index that is being
        created when ``IndexStatus`` is set to CREATING and ``Backfilling`` is false. (This
        attribute does not appear for indexes that were created during a ``CreateTable`` operation.)

        * ``IndexName`` - The name of the global secondary index.

        * ``IndexSizeBytes`` - The total size of the global secondary index, in bytes. DynamoDB
        updates this value approximately every six hours. Recent changes might not be reflected in
        this value.

        * ``IndexStatus`` - The current status of the global secondary index:

          * ``CREATING`` - The index is being created.

          * ``UPDATING`` - The index is being updated.

          * ``DELETING`` - The index is being deleted.

          * ``ACTIVE`` - The index is ready for use.

        * ``ItemCount`` - The number of items in the global secondary index. DynamoDB updates this
        value approximately every six hours. Recent changes might not be reflected in this value.

        * ``KeySchema`` - Specifies the complete index key schema. The attribute names in the key
        schema must be between 1 and 255 characters (inclusive). The key schema must begin with the
        same partition key as the table.

        * ``Projection`` - Specifies attributes that are copied (projected) from the table into the
        index. These are in addition to the primary key attributes and index key attributes, which
        are automatically projected. Each attribute specification is composed of:

          * ``ProjectionType`` - One of the following:

            * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

            * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
            list of projected attributes is in ``NonKeyAttributes`` .

            * ``ALL`` - All of the table attributes are projected into the index.

          * ``NonKeyAttributes`` - A list of one or more non-key attribute names that are projected
          into the secondary index. The total count of attributes provided in ``NonKeyAttributes``
          , summed across all of the secondary indexes, must not exceed 20. If you project the same
          attribute into two different indexes, this counts as two distinct attributes when
          determining the total.

        * ``ProvisionedThroughput`` - The provisioned throughput settings for the global secondary
        index, consisting of read and write capacity units, along with data about increases and
        decreases.

        If the table is in the ``DELETING`` state, no information about indexes will be returned.

        - *(dict) --*

          Represents the properties of a global secondary index.

          - **IndexName** *(string) --*

            The name of the global secondary index.

          - **KeySchema** *(list) --*

            The complete key schema for a global secondary index, which consists of one or more
            pairs of attribute names and key types:

            * ``HASH`` - partition key

            * ``RANGE`` - sort key

            .. note::

              The partition key of an item is also known as its *hash attribute* . The term "hash
              attribute" derives from DynamoDB's usage of an internal hash function to evenly
              distribute data items across partitions, based on their partition key values.

              The sort key of an item is also known as its *range attribute* . The term "range
              attribute" derives from the way DynamoDB stores items with the same partition key
              physically close together, in sorted order by the sort key value.

            - *(dict) --*

              Represents *a single element* of a key schema. A key schema specifies the attributes
              that make up the primary key of a table, or the key attributes of an index.

              A ``KeySchemaElement`` represents exactly one attribute of the primary key. For
              example, a simple primary key would be represented by one ``KeySchemaElement`` (for
              the partition key). A composite primary key would require one ``KeySchemaElement``
              for the partition key, and another ``KeySchemaElement`` for the sort key.

              A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested
              attribute). The data type must be one of String, Number, or Binary. The attribute
              cannot be nested within a List or a Map.

              - **AttributeName** *(string) --*

                The name of a key attribute.

              - **KeyType** *(string) --*

                The role that this key attribute will assume:

                * ``HASH`` - partition key

                * ``RANGE`` - sort key

                .. note::

                  The partition key of an item is also known as its *hash attribute* . The term
                  "hash attribute" derives from DynamoDB's usage of an internal hash function to
                  evenly distribute data items across partitions, based on their partition key
                  values.

                  The sort key of an item is also known as its *range attribute* . The term "range
                  attribute" derives from the way DynamoDB stores items with the same partition key
                  physically close together, in sorted order by the sort key value.

          - **Projection** *(dict) --*

            Represents attributes that are copied (projected) from the table into the global
            secondary index. These are in addition to the primary key attributes and index key
            attributes, which are automatically projected.

            - **ProjectionType** *(string) --*

              The set of attributes that are projected into the index:

              * ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.

              * ``INCLUDE`` - Only the specified table attributes are projected into the index. The
              list of projected attributes is in ``NonKeyAttributes`` .

              * ``ALL`` - All of the table attributes are projected into the index.

            - **NonKeyAttributes** *(list) --*

              Represents the non-key attribute names which will be projected into the index.

              For local secondary indexes, the total count of ``NonKeyAttributes`` summed across
              all of the local secondary indexes, must not exceed 20. If you project the same
              attribute into two different indexes, this counts as two distinct attributes when
              determining the total.

              - *(string) --*

          - **IndexStatus** *(string) --*

            The current state of the global secondary index:

            * ``CREATING`` - The index is being created.

            * ``UPDATING`` - The index is being updated.

            * ``DELETING`` - The index is being deleted.

            * ``ACTIVE`` - The index is ready for use.

          - **Backfilling** *(boolean) --*

            Indicates whether the index is currently backfilling. *Backfilling* is the process of
            reading items from the table and determining whether they can be added to the index.
            (Not all items will qualify: For example, a partition key cannot have any duplicate
            values.) If an item can be added to the index, DynamoDB will do so. After all items
            have been processed, the backfilling operation is complete and ``Backfilling`` is false.

            You can delete an index that is being created during the ``Backfilling`` phase when
            ``IndexStatus`` is set to CREATING and ``Backfilling`` is true. You can't delete the
            index that is being created when ``IndexStatus`` is set to CREATING and ``Backfilling``
            is false.

            .. note::

              For indexes that were created during a ``CreateTable`` operation, the ``Backfilling``
              attribute does not appear in the ``DescribeTable`` output.

          - **ProvisionedThroughput** *(dict) --*

            Represents the provisioned throughput settings for the specified global secondary index.

            For current minimum and maximum provisioned throughput values, see `Limits
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
            the *Amazon DynamoDB Developer Guide* .

            - **LastIncreaseDateTime** *(datetime) --*

              The date and time of the last provisioned throughput increase for this table.

            - **LastDecreaseDateTime** *(datetime) --*

              The date and time of the last provisioned throughput decrease for this table.

            - **NumberOfDecreasesToday** *(integer) --*

              The number of provisioned throughput decreases for this table during this UTC
              calendar day. For current maximums on provisioned throughput decreases, see `Limits
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html>`__ in
              the *Amazon DynamoDB Developer Guide* .

            - **ReadCapacityUnits** *(integer) --*

              The maximum number of strongly consistent reads consumed per second before DynamoDB
              returns a ``ThrottlingException`` . Eventually consistent reads require less effort
              than strongly consistent reads, so a setting of 50 ``ReadCapacityUnits`` per second
              provides 100 eventually consistent ``ReadCapacityUnits`` per second.

            - **WriteCapacityUnits** *(integer) --*

              The maximum number of writes consumed per second before DynamoDB returns a
              ``ThrottlingException`` .

          - **IndexSizeBytes** *(integer) --*

            The total size of the specified index, in bytes. DynamoDB updates this value
            approximately every six hours. Recent changes might not be reflected in this value.

          - **ItemCount** *(integer) --*

            The number of items in the specified index. DynamoDB updates this value approximately
            every six hours. Recent changes might not be reflected in this value.

          - **IndexArn** *(string) --*

            The Amazon Resource Name (ARN) that uniquely identifies the index.

      - **StreamSpecification** *(dict) --*

        The current DynamoDB Streams configuration for the table.

        - **StreamEnabled** *(boolean) --*

          Indicates whether DynamoDB Streams is enabled (true) or disabled (false) on the table.

        - **StreamViewType** *(string) --*

          When an item in the table is modified, ``StreamViewType`` determines what information is
          written to the stream for this table. Valid values for ``StreamViewType`` are:

          * ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.

          * ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the
          stream.

          * ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to
          the stream.

          * ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written
          to the stream.

      - **LatestStreamLabel** *(string) --*

        A timestamp, in ISO 8601 format, for this stream.

        Note that ``LatestStreamLabel`` is not a unique identifier for the stream, because it is
        possible that a stream from another table might have the same timestamp. However, the
        combination of the following three elements is guaranteed to be unique:

        * AWS customer ID

        * Table name

        * ``StreamLabel``

      - **LatestStreamArn** *(string) --*

        The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.

      - **GlobalTableVersion** *(string) --*

        Represents the version of `global tables
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html>`__ in
        use, if the table is replicated across AWS Regions.

      - **Replicas** *(list) --*

        Represents replicas of the table.

        - *(dict) --*

          Contains the details of the replica.

          - **RegionName** *(string) --*

            The name of the Region.

          - **ReplicaStatus** *(string) --*

            The current state of the replica:

            * ``CREATING`` - The replica is being created.

            * ``UPDATING`` - The replica is being updated.

            * ``DELETING`` - The replica is being deleted.

            * ``ACTIVE`` - The replica is ready for use.

          - **ReplicaStatusDescription** *(string) --*

            Detailed information about the replica status.

          - **ReplicaStatusPercentProgress** *(string) --*

            Specifies the progress of a Create, Update, or Delete action on the replica as a
            percentage.

          - **KMSMasterKeyId** *(string) --*

            The AWS KMS customer master key (CMK) of the replica that will be used for AWS KMS
            encryption.

          - **ProvisionedThroughputOverride** *(dict) --*

            Replica-specific provisioned throughput. If not described, uses the source table's
            provisioned throughput settings.

            - **ReadCapacityUnits** *(integer) --*

              Replica-specific read capacity units. If not specified, uses the source table's read
              capacity settings.

          - **GlobalSecondaryIndexes** *(list) --*

            Replica-specific global secondary index settings.

            - *(dict) --*

              Represents the properties of a replica global secondary index.

              - **IndexName** *(string) --*

                The name of the global secondary index.

              - **ProvisionedThroughputOverride** *(dict) --*

                If not described, uses the source table GSI's read capacity settings.

                - **ReadCapacityUnits** *(integer) --*

                  Replica-specific read capacity units. If not specified, uses the source table's
                  read capacity settings.

      - **RestoreSummary** *(dict) --*

        Contains details for the restore.

        - **SourceBackupArn** *(string) --*

          The Amazon Resource Name (ARN) of the backup from which the table was restored.

        - **SourceTableArn** *(string) --*

          The ARN of the source table of the backup that is being restored.

        - **RestoreDateTime** *(datetime) --*

          Point in time or source backup time.

        - **RestoreInProgress** *(boolean) --*

          Indicates if a restore is in progress or not.

      - **SSEDescription** *(dict) --*

        The description of the server-side encryption status on the specified table.

        - **Status** *(string) --*

          Represents the current state of server-side encryption. The only supported values are:

          * ``ENABLED`` - Server-side encryption is enabled.

          * ``UPDATING`` - Server-side encryption is being updated.

        - **SSEType** *(string) --*

          Server-side encryption type. The only supported value is:

          * ``KMS`` - Server-side encryption that uses AWS Key Management Service. The key is
          stored in your account and is managed by AWS KMS (AWS KMS charges apply).

        - **KMSMasterKeyArn** *(string) --*

          The AWS KMS customer master key (CMK) ARN used for the AWS KMS encryption.
    """


_ClientDescribeTimeToLiveResponseTimeToLiveDescriptionTypeDef = TypedDict(
    "_ClientDescribeTimeToLiveResponseTimeToLiveDescriptionTypeDef",
    {"TimeToLiveStatus": str, "AttributeName": str},
    total=False,
)


class ClientDescribeTimeToLiveResponseTimeToLiveDescriptionTypeDef(
    _ClientDescribeTimeToLiveResponseTimeToLiveDescriptionTypeDef
):
    """
    Type definition for `ClientDescribeTimeToLiveResponse` `TimeToLiveDescription`

    - **TimeToLiveStatus** *(string) --*

      The TTL status for the table.

    - **AttributeName** *(string) --*

      The name of the TTL attribute for items in the table.
    """


_ClientDescribeTimeToLiveResponseTypeDef = TypedDict(
    "_ClientDescribeTimeToLiveResponseTypeDef",
    {
        "TimeToLiveDescription": ClientDescribeTimeToLiveResponseTimeToLiveDescriptionTypeDef
    },
    total=False,
)


class ClientDescribeTimeToLiveResponseTypeDef(_ClientDescribeTimeToLiveResponseTypeDef):
    """
    Type definition for `ClientDescribeTimeToLive` `Response`

    - **TimeToLiveDescription** *(dict) --*

      - **TimeToLiveStatus** *(string) --*

        The TTL status for the table.

      - **AttributeName** *(string) --*

        The name of the TTL attribute for items in the table.
    """


_ClientGetItemKeyTypeDef = TypedDict(
    "_ClientGetItemKeyTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientGetItemKeyTypeDef(_ClientGetItemKeyTypeDef):
    """
    Type definition for `ClientGetItem` `Key`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and the
    value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes for
      mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes for
      mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type, and
        the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef = TypedDict(
    "_ClientGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef(
    _ClientGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientGetItemResponseConsumedCapacity` `GlobalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef = TypedDict(
    "_ClientGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef(
    _ClientGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef
):
    """
    Type definition for `ClientGetItemResponseConsumedCapacity` `LocalSecondaryIndexes`

    Represents the amount of provisioned throughput capacity consumed on a table or an
    index.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientGetItemResponseConsumedCapacityTableTypeDef = TypedDict(
    "_ClientGetItemResponseConsumedCapacityTableTypeDef",
    {"ReadCapacityUnits": float, "WriteCapacityUnits": float, "CapacityUnits": float},
    total=False,
)


class ClientGetItemResponseConsumedCapacityTableTypeDef(
    _ClientGetItemResponseConsumedCapacityTableTypeDef
):
    """
    Type definition for `ClientGetItemResponseConsumedCapacity` `Table`

    The amount of throughput consumed on the table affected by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed on a table or an index.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed on a table or an index.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed on a table or an index.
    """


_ClientGetItemResponseConsumedCapacityTypeDef = TypedDict(
    "_ClientGetItemResponseConsumedCapacityTypeDef",
    {
        "TableName": str,
        "CapacityUnits": float,
        "ReadCapacityUnits": float,
        "WriteCapacityUnits": float,
        "Table": ClientGetItemResponseConsumedCapacityTableTypeDef,
        "LocalSecondaryIndexes": Dict[
            str, ClientGetItemResponseConsumedCapacityLocalSecondaryIndexesTypeDef
        ],
        "GlobalSecondaryIndexes": Dict[
            str, ClientGetItemResponseConsumedCapacityGlobalSecondaryIndexesTypeDef
        ],
    },
    total=False,
)


class ClientGetItemResponseConsumedCapacityTypeDef(
    _ClientGetItemResponseConsumedCapacityTypeDef
):
    """
    Type definition for `ClientGetItemResponse` `ConsumedCapacity`

    The capacity units consumed by the ``GetItem`` operation. The data returned includes the
    total provisioned throughput consumed, along with statistics for the table and any indexes
    involved in the operation. ``ConsumedCapacity`` is only returned if the
    ``ReturnConsumedCapacity`` parameter was specified. For more information, see `Read/Write
    Capacity Mode
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **TableName** *(string) --*

      The name of the table that was affected by the operation.

    - **CapacityUnits** *(float) --*

      The total number of capacity units consumed by the operation.

    - **ReadCapacityUnits** *(float) --*

      The total number of read capacity units consumed by the operation.

    - **WriteCapacityUnits** *(float) --*

      The total number of write capacity units consumed by the operation.

    - **Table** *(dict) --*

      The amount of throughput consumed on the table affected by the operation.

      - **ReadCapacityUnits** *(float) --*

        The total number of read capacity units consumed on a table or an index.

      - **WriteCapacityUnits** *(float) --*

        The total number of write capacity units consumed on a table or an index.

      - **CapacityUnits** *(float) --*

        The total number of capacity units consumed on a table or an index.

    - **LocalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each local index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.

    - **GlobalSecondaryIndexes** *(dict) --*

      The amount of throughput consumed on each global index affected by the operation.

      - *(string) --*

        - *(dict) --*

          Represents the amount of provisioned throughput capacity consumed on a table or an
          index.

          - **ReadCapacityUnits** *(float) --*

            The total number of read capacity units consumed on a table or an index.

          - **WriteCapacityUnits** *(float) --*

            The total number of write capacity units consumed on a table or an index.

          - **CapacityUnits** *(float) --*

            The total number of capacity units consumed on a table or an index.
    """


_ClientGetItemResponseItemTypeDef = TypedDict(
    "_ClientGetItemResponseItemTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientGetItemResponseItemTypeDef(_ClientGetItemResponseItemTypeDef):
    """
    Type definition for `ClientGetItemResponse` `Item`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and
    the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type,
        and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientGetItemResponseTypeDef = TypedDict(
    "_ClientGetItemResponseTypeDef",
    {
        "Item": Dict[str, ClientGetItemResponseItemTypeDef],
        "ConsumedCapacity": ClientGetItemResponseConsumedCapacityTypeDef,
    },
    total=False,
)


class ClientGetItemResponseTypeDef(_ClientGetItemResponseTypeDef):
    """
    Type definition for `ClientGetItem` `Response`

    Represents the output of a ``GetItem`` operation.

    - **Item** *(dict) --*

      A map of attribute names to ``AttributeValue`` objects, as specified by
      ``ProjectionExpression`` .

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

          - **S** *(string) --*

            An attribute of type String. For example:

             ``"S": "Hello"``

          - **N** *(string) --*

            An attribute of type Number. For example:

             ``"N": "123.45"``

            Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
            across languages and libraries. However, DynamoDB treats them as number type attributes
            for mathematical operations.

          - **B** *(bytes) --*

            An attribute of type Binary. For example:

             ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

          - **SS** *(list) --*

            An attribute of type String Set. For example:

             ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

            - *(string) --*

          - **NS** *(list) --*

            An attribute of type Number Set. For example:

             ``"NS": ["42.2", "-19", "7.5", "3.14"]``

            Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
            across languages and libraries. However, DynamoDB treats them as number type attributes
            for mathematical operations.

            - *(string) --*

          - **BS** *(list) --*

            An attribute of type Binary Set. For example:

             ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

            - *(bytes) --*

          - **M** *(dict) --*

            An attribute of type Map. For example:

             ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

            - *(string) --*

              - *(dict) --*

                Represents the data for an attribute.

                Each attribute value is described as a name-value pair. The name is the data type,
                and the value is the data itself.

                For more information, see `Data Types
                <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
                in the *Amazon DynamoDB Developer Guide* .

          - **L** *(list) --*

            An attribute of type List. For example:

             ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

            - *(dict) --*

              Represents the data for an attribute.

              Each attribute value is described as a name-value pair. The name is the data type,
              and the value is the data itself.

              For more information, see `Data Types
              <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
              in the *Amazon DynamoDB Developer Guide* .

          - **NULL** *(boolean) --*

            An attribute of type Null. For example:

             ``"NULL": true``

          - **BOOL** *(boolean) --*

            An attribute of type Boolean. For example:

             ``"BOOL": true``

    - **ConsumedCapacity** *(dict) --*

      The capacity units consumed by the ``GetItem`` operation. The data returned includes the
      total provisioned throughput consumed, along with statistics for the table and any indexes
      involved in the operation. ``ConsumedCapacity`` is only returned if the
      ``ReturnConsumedCapacity`` parameter was specified. For more information, see `Read/Write
      Capacity Mode
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html>`__
      in the *Amazon DynamoDB Developer Guide* .

      - **TableName** *(string) --*

        The name of the table that was affected by the operation.

      - **CapacityUnits** *(float) --*

        The total number of capacity units consumed by the operation.

      - **ReadCapacityUnits** *(float) --*

        The total number of read capacity units consumed by the operation.

      - **WriteCapacityUnits** *(float) --*

        The total number of write capacity units consumed by the operation.

      - **Table** *(dict) --*

        The amount of throughput consumed on the table affected by the operation.

        - **ReadCapacityUnits** *(float) --*

          The total number of read capacity units consumed on a table or an index.

        - **WriteCapacityUnits** *(float) --*

          The total number of write capacity units consumed on a table or an index.

        - **CapacityUnits** *(float) --*

          The total number of capacity units consumed on a table or an index.

      - **LocalSecondaryIndexes** *(dict) --*

        The amount of throughput consumed on each local index affected by the operation.

        - *(string) --*

          - *(dict) --*

            Represents the amount of provisioned throughput capacity consumed on a table or an
            index.

            - **ReadCapacityUnits** *(float) --*

              The total number of read capacity units consumed on a table or an index.

            - **WriteCapacityUnits** *(float) --*

              The total number of write capacity units consumed on a table or an index.

            - **CapacityUnits** *(float) --*

              The total number of capacity units consumed on a table or an index.

      - **GlobalSecondaryIndexes** *(dict) --*

        The amount of throughput consumed on each global index affected by the operation.

        - *(string) --*

          - *(dict) --*

            Represents the amount of provisioned throughput capacity consumed on a table or an
            index.

            - **ReadCapacityUnits** *(float) --*

              The total number of read capacity units consumed on a table or an index.

            - **WriteCapacityUnits** *(float) --*

              The total number of write capacity units consumed on a table or an index.

            - **CapacityUnits** *(float) --*

              The total number of capacity units consumed on a table or an index.
    """


_ClientListBackupsResponseBackupSummariesTypeDef = TypedDict(
    "_ClientListBackupsResponseBackupSummariesTypeDef",
    {
        "TableName": str,
        "TableId": str,
        "TableArn": str,
        "BackupArn": str,
        "BackupName": str,
        "BackupCreationDateTime": datetime,
        "BackupExpiryDateTime": datetime,
        "BackupStatus": str,
        "BackupType": str,
        "BackupSizeBytes": int,
    },
    total=False,
)


class ClientListBackupsResponseBackupSummariesTypeDef(
    _ClientListBackupsResponseBackupSummariesTypeDef
):
    """
    Type definition for `ClientListBackupsResponse` `BackupSummaries`

    Contains details for the backup.

    - **TableName** *(string) --*

      Name of the table.

    - **TableId** *(string) --*

      Unique identifier for the table.

    - **TableArn** *(string) --*

      ARN associated with the table.

    - **BackupArn** *(string) --*

      ARN associated with the backup.

    - **BackupName** *(string) --*

      Name of the specified backup.

    - **BackupCreationDateTime** *(datetime) --*

      Time at which the backup was created.

    - **BackupExpiryDateTime** *(datetime) --*

      Time at which the automatic on-demand backup created by DynamoDB will expire. This
      ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.

    - **BackupStatus** *(string) --*

      Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

    - **BackupType** *(string) --*

      BackupType:

      * ``USER`` - You create and manage these using the on-demand backup feature.

      * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
      backup is automatically created and is retained for 35 days (at no additional cost).
      System backups allow you to restore the deleted table to the state it was in just before
      the point of deletion.

      * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

    - **BackupSizeBytes** *(integer) --*

      Size of the backup in bytes.
    """


_ClientListBackupsResponseTypeDef = TypedDict(
    "_ClientListBackupsResponseTypeDef",
    {
        "BackupSummaries": List[ClientListBackupsResponseBackupSummariesTypeDef],
        "LastEvaluatedBackupArn": str,
    },
    total=False,
)


class ClientListBackupsResponseTypeDef(_ClientListBackupsResponseTypeDef):
    """
    Type definition for `ClientListBackups` `Response`

    - **BackupSummaries** *(list) --*

      List of ``BackupSummary`` objects.

      - *(dict) --*

        Contains details for the backup.

        - **TableName** *(string) --*

          Name of the table.

        - **TableId** *(string) --*

          Unique identifier for the table.

        - **TableArn** *(string) --*

          ARN associated with the table.

        - **BackupArn** *(string) --*

          ARN associated with the backup.

        - **BackupName** *(string) --*

          Name of the specified backup.

        - **BackupCreationDateTime** *(datetime) --*

          Time at which the backup was created.

        - **BackupExpiryDateTime** *(datetime) --*

          Time at which the automatic on-demand backup created by DynamoDB will expire. This
          ``SYSTEM`` on-demand backup expires automatically 35 days after its creation.

        - **BackupStatus** *(string) --*

          Backup can be in one of the following states: CREATING, ACTIVE, DELETED.

        - **BackupType** *(string) --*

          BackupType:

          * ``USER`` - You create and manage these using the on-demand backup feature.

          * ``SYSTEM`` - If you delete a table with point-in-time recovery enabled, a ``SYSTEM``
          backup is automatically created and is retained for 35 days (at no additional cost).
          System backups allow you to restore the deleted table to the state it was in just before
          the point of deletion.

          * ``AWS_BACKUP`` - On-demand backup created by you from AWS Backup service.

        - **BackupSizeBytes** *(integer) --*

          Size of the backup in bytes.

    - **LastEvaluatedBackupArn** *(string) --*

      The ARN of the backup last evaluated when the current page of results was returned, inclusive
      of the current page of results. This value may be specified as the
      ``ExclusiveStartBackupArn`` of a new ``ListBackups`` operation in order to fetch the next
      page of results.

      If ``LastEvaluatedBackupArn`` is empty, then the last page of results has been processed and
      there are no more results to be retrieved.

      If ``LastEvaluatedBackupArn`` is not empty, this may or may not indicate that there is more
      data to be returned. All results are guaranteed to have been returned if and only if no value
      for ``LastEvaluatedBackupArn`` is returned.
    """


_ClientListGlobalTablesResponseGlobalTablesReplicationGroupTypeDef = TypedDict(
    "_ClientListGlobalTablesResponseGlobalTablesReplicationGroupTypeDef",
    {"RegionName": str},
    total=False,
)


class ClientListGlobalTablesResponseGlobalTablesReplicationGroupTypeDef(
    _ClientListGlobalTablesResponseGlobalTablesReplicationGroupTypeDef
):
    """
    Type definition for `ClientListGlobalTablesResponseGlobalTables` `ReplicationGroup`

    Represents the properties of a replica.

    - **RegionName** *(string) --*

      The Region where the replica needs to be created.
    """


_ClientListGlobalTablesResponseGlobalTablesTypeDef = TypedDict(
    "_ClientListGlobalTablesResponseGlobalTablesTypeDef",
    {
        "GlobalTableName": str,
        "ReplicationGroup": List[
            ClientListGlobalTablesResponseGlobalTablesReplicationGroupTypeDef
        ],
    },
    total=False,
)


class ClientListGlobalTablesResponseGlobalTablesTypeDef(
    _ClientListGlobalTablesResponseGlobalTablesTypeDef
):
    """
    Type definition for `ClientListGlobalTablesResponse` `GlobalTables`

    Represents the properties of a global table.

    - **GlobalTableName** *(string) --*

      The global table name.

    - **ReplicationGroup** *(list) --*

      The Regions where the global table has replicas.

      - *(dict) --*

        Represents the properties of a replica.

        - **RegionName** *(string) --*

          The Region where the replica needs to be created.
    """


_ClientListGlobalTablesResponseTypeDef = TypedDict(
    "_ClientListGlobalTablesResponseTypeDef",
    {
        "GlobalTables": List[ClientListGlobalTablesResponseGlobalTablesTypeDef],
        "LastEvaluatedGlobalTableName": str,
    },
    total=False,
)


class ClientListGlobalTablesResponseTypeDef(_ClientListGlobalTablesResponseTypeDef):
    """
    Type definition for `ClientListGlobalTables` `Response`

    - **GlobalTables** *(list) --*

      List of global table names.

      - *(dict) --*

        Represents the properties of a global table.

        - **GlobalTableName** *(string) --*

          The global table name.

        - **ReplicationGroup** *(list) --*

          The Regions where the global table has replicas.

          - *(dict) --*

            Represents the properties of a replica.

            - **RegionName** *(string) --*

              The Region where the replica needs to be created.

    - **LastEvaluatedGlobalTableName** *(string) --*

      Last evaluated global table name.
    """


_ClientListTablesResponseTypeDef = TypedDict(
    "_ClientListTablesResponseTypeDef",
    {"TableNames": List[str], "LastEvaluatedTableName": str},
    total=False,
)


class ClientListTablesResponseTypeDef(_ClientListTablesResponseTypeDef):
    """
    Type definition for `ClientListTables` `Response`

    Represents the output of a ``ListTables`` operation.

    - **TableNames** *(list) --*

      The names of the tables associated with the current account at the current endpoint. The
      maximum size of this array is 100.

      If ``LastEvaluatedTableName`` also appears in the output, you can use this value as the
      ``ExclusiveStartTableName`` parameter in a subsequent ``ListTables`` request and obtain the
      next page of results.

      - *(string) --*

    - **LastEvaluatedTableName** *(string) --*

      The name of the last table in the current page of results. Use this value as the
      ``ExclusiveStartTableName`` in a new request to obtain the next page of results, until all
      the table names are returned.

      If you do not receive a ``LastEvaluatedTableName`` value in the response, this means that
      there are no more table names to be retrieved.
    """


_ClientListTagsOfResourceResponseTagsTypeDef = TypedDict(
    "_ClientListTagsOfResourceResponseTagsTypeDef",
    {"Key": str, "Value": str},
    total=False,
)


class ClientListTagsOfResourceResponseTagsTypeDef(
    _ClientListTagsOfResourceResponseTagsTypeDef
):
    """
    Type definition for `ClientListTagsOfResourceResponse` `Tags`

    Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single DynamoDB
    table.

    AWS-assigned tag names and values are automatically assigned the ``aws:`` prefix, which the
    user cannot assign. AWS-assigned tag names do not count towards the tag limit of 50.
    User-assigned tag names have the prefix ``user:`` in the Cost Allocation Report. You cannot
    backdate the application of a tag.

    For an overview on tagging DynamoDB resources, see `Tagging for DynamoDB
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html>`__ in the
    *Amazon DynamoDB Developer Guide* .

    - **Key** *(string) --*

      The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to
      one tag with the same key. If you try to add an existing tag (same key), the existing tag
      value will be updated to the new value.

    - **Value** *(string) --*

      The value of the tag. Tag values are case-sensitive and can be null.
    """


_ClientListTagsOfResourceResponseTypeDef = TypedDict(
    "_ClientListTagsOfResourceResponseTypeDef",
    {"Tags": List[ClientListTagsOfResourceResponseTagsTypeDef], "NextToken": str},
    total=False,
)


class ClientListTagsOfResourceResponseTypeDef(_ClientListTagsOfResourceResponseTypeDef):
    """
    Type definition for `ClientListTagsOfResource` `Response`

    - **Tags** *(list) --*

      The tags currently associated with the Amazon DynamoDB resource.

      - *(dict) --*

        Describes a tag. A tag is a key-value pair. You can add up to 50 tags to a single DynamoDB
        table.

        AWS-assigned tag names and values are automatically assigned the ``aws:`` prefix, which the
        user cannot assign. AWS-assigned tag names do not count towards the tag limit of 50.
        User-assigned tag names have the prefix ``user:`` in the Cost Allocation Report. You cannot
        backdate the application of a tag.

        For an overview on tagging DynamoDB resources, see `Tagging for DynamoDB
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html>`__ in the
        *Amazon DynamoDB Developer Guide* .

        - **Key** *(string) --*

          The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to
          one tag with the same key. If you try to add an existing tag (same key), the existing tag
          value will be updated to the new value.

        - **Value** *(string) --*

          The value of the tag. Tag values are case-sensitive and can be null.

    - **NextToken** *(string) --*

      If this value is returned, there are additional results to be displayed. To retrieve them,
      call ListTagsOfResource again, with NextToken set to this value.
    """


_ClientPutItemExpectedAttributeValueListTypeDef = TypedDict(
    "_ClientPutItemExpectedAttributeValueListTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientPutItemExpectedAttributeValueListTypeDef(
    _ClientPutItemExpectedAttributeValueListTypeDef
):
    """
    Type definition for `ClientPutItemExpected` `AttributeValueList`

    Represents the data for an attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and
    the value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type,
        and the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientPutItemExpectedValueTypeDef = TypedDict(
    "_ClientPutItemExpectedValueTypeDef",
    {
        "S": str,
        "N": str,
        "B": bytes,
        "SS": List[str],
        "NS": List[str],
        "BS": List[bytes],
        "M": Dict[str, Dict],
        "L": List[Dict],
        "NULL": bool,
        "BOOL": bool,
    },
    total=False,
)


class ClientPutItemExpectedValueTypeDef(_ClientPutItemExpectedValueTypeDef):
    """
    Type definition for `ClientPutItemExpected` `Value`

    Represents the data for the expected attribute.

    Each attribute value is described as a name-value pair. The name is the data type, and the
    value is the data itself.

    For more information, see `Data Types
    <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
    in the *Amazon DynamoDB Developer Guide* .

    - **S** *(string) --*

      An attribute of type String. For example:

       ``"S": "Hello"``

    - **N** *(string) --*

      An attribute of type Number. For example:

       ``"N": "123.45"``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

    - **B** *(bytes) --*

      An attribute of type Binary. For example:

       ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

    - **SS** *(list) --*

      An attribute of type String Set. For example:

       ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

      - *(string) --*

    - **NS** *(list) --*

      An attribute of type Number Set. For example:

       ``"NS": ["42.2", "-19", "7.5", "3.14"]``

      Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
      across languages and libraries. However, DynamoDB treats them as number type attributes
      for mathematical operations.

      - *(string) --*

    - **BS** *(list) --*

      An attribute of type Binary Set. For example:

       ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

      - *(bytes) --*

    - **M** *(dict) --*

      An attribute of type Map. For example:

       ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

      - *(string) --*

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type,
          and the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

    - **L** *(list) --*

      An attribute of type List. For example:

       ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

      - *(dict) --*

        Represents the data for an attribute.

        Each attribute value is described as a name-value pair. The name is the data type, and
        the value is the data itself.

        For more information, see `Data Types
        <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
        in the *Amazon DynamoDB Developer Guide* .

    - **NULL** *(boolean) --*

      An attribute of type Null. For example:

       ``"NULL": true``

    - **BOOL** *(boolean) --*

      An attribute of type Boolean. For example:

       ``"BOOL": true``
    """


_ClientPutItemExpectedTypeDef = TypedDict(
    "_ClientPutItemExpectedTypeDef",
    {
        "Value": ClientPutItemExpectedValueTypeDef,
        "Exists": bool,
        "ComparisonOperator": str,
        "AttributeValueList": List[ClientPutItemExpectedAttributeValueListTypeDef],
    },
    total=False,
)


class ClientPutItemExpectedTypeDef(_ClientPutItemExpectedTypeDef):
    """
    Type definition for `ClientPutItem` `Expected`

    Represents a condition to be compared with an attribute value. This condition can be used
    with ``DeleteItem`` , ``PutItem`` , or ``UpdateItem`` operations; if the comparison evaluates
    to true, the operation succeeds; if not, the operation fails. You can use
    ``ExpectedAttributeValue`` in one of two different ways:

    * Use ``AttributeValueList`` to specify one or more values to compare against an attribute.
    Use ``ComparisonOperator`` to specify how you want to perform the comparison. If the
    comparison evaluates to true, then the conditional operation succeeds.

    * Use ``Value`` to specify a value that DynamoDB will compare against an attribute. If the
    values match, then ``ExpectedAttributeValue`` evaluates to true and the conditional operation
    succeeds. Optionally, you can also set ``Exists`` to false, indicating that you *do not*
    expect to find the attribute value in the table. In this case, the conditional operation
    succeeds only if the comparison evaluates to false.

     ``Value`` and ``Exists`` are incompatible with ``AttributeValueList`` and
     ``ComparisonOperator`` . Note that if you use both sets of parameters at once, DynamoDB will
     return a ``ValidationException`` exception.

    - **Value** *(dict) --*

      Represents the data for the expected attribute.

      Each attribute value is described as a name-value pair. The name is the data type, and the
      value is the data itself.

      For more information, see `Data Types
      <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
      in the *Amazon DynamoDB Developer Guide* .

      - **S** *(string) --*

        An attribute of type String. For example:

         ``"S": "Hello"``

      - **N** *(string) --*

        An attribute of type Number. For example:

         ``"N": "123.45"``

        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
        across languages and libraries. However, DynamoDB treats them as number type attributes
        for mathematical operations.

      - **B** *(bytes) --*

        An attribute of type Binary. For example:

         ``"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"``

      - **SS** *(list) --*

        An attribute of type String Set. For example:

         ``"SS": ["Giraffe", "Hippo" ,"Zebra"]``

        - *(string) --*

      - **NS** *(list) --*

        An attribute of type Number Set. For example:

         ``"NS": ["42.2", "-19", "7.5", "3.14"]``

        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
        across languages and libraries. However, DynamoDB treats them as number type attributes
        for mathematical operations.

        - *(string) --*

      - **BS** *(list) --*

        An attribute of type Binary Set. For example:

         ``"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]``

        - *(bytes) --*

      - **M** *(dict) --*

        An attribute of type Map. For example:

         ``"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}``

        - *(string) --*

          - *(dict) --*

            Represents the data for an attribute.

            Each attribute value is described as a name-value pair. The name is the data type,
            and the value is the data itself.

            For more information, see `Data Types
            <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
            in the *Amazon DynamoDB Developer Guide* .

      - **L** *(list) --*

        An attribute of type List. For example:

         ``"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]``

        - *(dict) --*

          Represents the data for an attribute.

          Each attribute value is described as a name-value pair. The name is the data type, and
          the value is the data itself.

          For more information, see `Data Types
          <https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes>`__
          in the *Amazon DynamoDB Developer Guide* .

      - **NULL** *(boolean) --*

        An attribute of type Null. For example:

         ``"NULL": true``

      - **BOOL** *(boolean) --*

        An attribute of type Boolean. For example:

         ``"BOOL": true``

    - **Exists** *(boolean) --*

      Causes DynamoDB to evaluate the value before attempting a conditional operation:

      * If ``Exists`` is ``true`` , DynamoDB will check to see if that attribute value already
      exists in