"""Generated from gga_c_cs1.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  cs1_gamma = 0.006

  cs1_d = 0.349

  cs1_C1 = -0.018897

  cs1_C2 = 0.15524

  cs1_C3 = -0.159068

  cs1_C4 = 0.007953

  cs1_ess = lambda rs, z, xs: +f.opz_pow_n(z, 1) / 2 * f.n_spin(rs, z) ** (1 / 3) / (f.n_spin(rs, z) ** (1 / 3) + cs1_d) * (cs1_C1 + cs1_C2 * cs1_gamma ** 2 * xs ** 4 / (1 + cs1_gamma * xs ** 2) ** 2)

  cs1_eab = lambda rs, z, xt: +(1 - z ** 2) / 4 * 1 / (1 + cs1_d * f.n_total(rs) ** (-1 / 3)) * (cs1_C3 + cs1_C4 * cs1_gamma ** 2 * xt ** 4 / (1 + cs1_gamma * xt ** 2) ** 2)

  f_cs1 = lambda rs, z, xt, xs0, xs1: +cs1_eab(rs, z, xt) + cs1_ess(rs, z, xs0) + cs1_ess(rs, -z, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1: f_cs1(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  cs1_gamma = 0.006

  cs1_d = 0.349

  cs1_C1 = -0.018897

  cs1_C2 = 0.15524

  cs1_C3 = -0.159068

  cs1_C4 = 0.007953

  cs1_ess = lambda rs, z, xs: +f.opz_pow_n(z, 1) / 2 * f.n_spin(rs, z) ** (1 / 3) / (f.n_spin(rs, z) ** (1 / 3) + cs1_d) * (cs1_C1 + cs1_C2 * cs1_gamma ** 2 * xs ** 4 / (1 + cs1_gamma * xs ** 2) ** 2)

  cs1_eab = lambda rs, z, xt: +(1 - z ** 2) / 4 * 1 / (1 + cs1_d * f.n_total(rs) ** (-1 / 3)) * (cs1_C3 + cs1_C4 * cs1_gamma ** 2 * xt ** 4 / (1 + cs1_gamma * xt ** 2) ** 2)

  f_cs1 = lambda rs, z, xt, xs0, xs1: +cs1_eab(rs, z, xt) + cs1_ess(rs, z, xs0) + cs1_ess(rs, -z, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1: f_cs1(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  cs1_gamma = 0.006

  cs1_d = 0.349

  cs1_C1 = -0.018897

  cs1_C2 = 0.15524

  cs1_C3 = -0.159068

  cs1_C4 = 0.007953

  cs1_ess = lambda rs, z, xs: +f.opz_pow_n(z, 1) / 2 * f.n_spin(rs, z) ** (1 / 3) / (f.n_spin(rs, z) ** (1 / 3) + cs1_d) * (cs1_C1 + cs1_C2 * cs1_gamma ** 2 * xs ** 4 / (1 + cs1_gamma * xs ** 2) ** 2)

  cs1_eab = lambda rs, z, xt: +(1 - z ** 2) / 4 * 1 / (1 + cs1_d * f.n_total(rs) ** (-1 / 3)) * (cs1_C3 + cs1_C4 * cs1_gamma ** 2 * xt ** 4 / (1 + cs1_gamma * xt ** 2) ** 2)

  f_cs1 = lambda rs, z, xt, xs0, xs1: +cs1_eab(rs, z, xt) + cs1_ess(rs, z, xs0) + cs1_ess(rs, -z, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1: f_cs1(rs, z, xt, xs0, xs1)

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t8 = -t2 * t5 / 0.4e1 + 0.1e1 / 0.4e1
  t9 = t3 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 + 0.349e0 / t9
  t13 = 0.1e1 / t12
  t14 = t8 * t13
  t16 = s0 + 0.2e1 * s1 + s2
  t17 = t16 ** 2
  t18 = t4 ** 2
  t21 = 0.1e1 / t9 / t18 / t3
  t23 = t9 ** 2
  t28 = 0.1e1 + 0.6e-2 * t16 / t23 / t4
  t29 = t28 ** 2
  t30 = 0.1e1 / t29
  t33 = -0.159068e0 + 0.286308e-6 * t17 * t21 * t30
  t34 = t14 * t33
  t35 = 0.1e1 / t3
  t36 = t1 * t35
  t37 = 0.1e1 + t36
  t38 = t37 <= f.p.zeta_threshold
  t39 = f.my_piecewise3(t38, f.p.zeta_threshold, t37)
  t40 = r0 ** (0.1e1 / 0.3e1)
  t41 = t39 * t40
  t42 = t40 + 0.349e0
  t43 = 0.1e1 / t42
  t44 = s0 ** 2
  t45 = r0 ** 2
  t46 = t45 ** 2
  t49 = 0.1e1 / t40 / t46 / r0
  t51 = t40 ** 2
  t56 = 0.1e1 + 0.6e-2 * s0 / t51 / t45
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t61 = -0.18897e-1 + 0.5588640e-5 * t44 * t49 * t58
  t62 = t43 * t61
  t64 = t41 * t62 / 0.2e1
  t65 = 0.1e1 - t36
  t66 = t65 <= f.p.zeta_threshold
  t67 = f.my_piecewise3(t66, f.p.zeta_threshold, t65)
  t68 = r1 ** (0.1e1 / 0.3e1)
  t69 = t67 * t68
  t70 = t68 + 0.349e0
  t71 = 0.1e1 / t70
  t72 = s2 ** 2
  t73 = r1 ** 2
  t74 = t73 ** 2
  t77 = 0.1e1 / t68 / t74 / r1
  t79 = t68 ** 2
  t84 = 0.1e1 + 0.6e-2 * s2 / t79 / t73
  t85 = t84 ** 2
  t86 = 0.1e1 / t85
  t89 = -0.18897e-1 + 0.5588640e-5 * t72 * t77 * t86
  t90 = t71 * t89
  t92 = t69 * t90 / 0.2e1
  t93 = t1 * t5
  t96 = t2 / t4 / t3
  t101 = t12 ** 2
  t108 = 0.11633333333333333333333333333333333333333333333333e0 * t8 / t101 * t33 / t9 / t3
  t116 = t18 ** 2
  t121 = 0.1e1 / t29 / t28
  t125 = t14 * (-0.15269760000000000000000000000000000000000000000000e-5 * t17 / t9 / t18 / t4 * t30 + 0.91618560000000000000000000000000000000000000000000e-8 * t17 * t16 / t116 / t3 * t121)
  t126 = t35 - t93
  t127 = f.my_piecewise3(t38, 0, t126)
  t137 = t42 ** 2
  t149 = t46 ** 2
  t154 = 0.1e1 / t57 / t56
  t162 = f.my_piecewise3(t66, 0, -t126)
  vrho_0_ = t34 + t64 + t92 + t3 * ((-t93 / 0.2e1 + t96 / 0.2e1) * t13 * t33 + t108 + t125 + t127 * t40 * t62 / 0.2e1 + t39 / t51 * t62 / 0.6e1 - t39 / t40 / t137 * t61 / 0.6e1 + t41 * t43 * (-0.29806080000000000000000000000000000000000000000000e-4 * t44 / t40 / t46 / t45 * t58 + 0.17883648000000000000000000000000000000000000000000e-6 * t44 * s0 / t149 / r0 * t154) / 0.2e1 + t162 * t68 * t90 / 0.2e1)
  t172 = -t35 - t93
  t173 = f.my_piecewise3(t38, 0, t172)
  t178 = f.my_piecewise3(t66, 0, -t172)
  t188 = t70 ** 2
  t200 = t74 ** 2
  t205 = 0.1e1 / t85 / t84
  vrho_1_ = t34 + t64 + t92 + t3 * ((t93 / 0.2e1 + t96 / 0.2e1) * t13 * t33 + t108 + t125 + t173 * t40 * t62 / 0.2e1 + t178 * t68 * t90 / 0.2e1 + t67 / t79 * t90 / 0.6e1 - t67 / t68 / t188 * t89 / 0.6e1 + t69 * t71 * (-0.29806080000000000000000000000000000000000000000000e-4 * t72 / t68 / t74 / t73 * t86 + 0.17883648000000000000000000000000000000000000000000e-6 * t72 * s2 / t200 / r1 * t205) / 0.2e1)
  t215 = t16 * t21 * t30
  t219 = t17 / t116 * t121
  t222 = t14 * (0.572616e-6 * t215 - 0.3435696e-8 * t219)
  vsigma_0_ = t3 * (t222 + t41 * t43 * (0.11177280e-4 * s0 * t49 * t58 - 0.67063680e-7 * t44 / t149 * t154) / 0.2e1)
  vsigma_1_ = t3 * t8 * t13 * (0.1145232e-5 * t215 - 0.6871392e-8 * t219)
  vsigma_2_ = t3 * (t222 + t69 * t71 * (0.11177280e-4 * s2 * t77 * t86 - 0.67063680e-7 * t72 / t200 * t205) / 0.2e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  cs1_gamma = 0.006

  cs1_d = 0.349

  cs1_C1 = -0.018897

  cs1_C2 = 0.15524

  cs1_C3 = -0.159068

  cs1_C4 = 0.007953

  cs1_ess = lambda rs, z, xs: +f.opz_pow_n(z, 1) / 2 * f.n_spin(rs, z) ** (1 / 3) / (f.n_spin(rs, z) ** (1 / 3) + cs1_d) * (cs1_C1 + cs1_C2 * cs1_gamma ** 2 * xs ** 4 / (1 + cs1_gamma * xs ** 2) ** 2)

  cs1_eab = lambda rs, z, xt: +(1 - z ** 2) / 4 * 1 / (1 + cs1_d * f.n_total(rs) ** (-1 / 3)) * (cs1_C3 + cs1_C4 * cs1_gamma ** 2 * xt ** 4 / (1 + cs1_gamma * xt ** 2) ** 2)

  f_cs1 = lambda rs, z, xt, xs0, xs1: +cs1_eab(rs, z, xt) + cs1_ess(rs, z, xs0) + cs1_ess(rs, -z, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1: f_cs1(rs, z, xt, xs0, xs1)

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t4 = 0.1e1 + 0.349e0 * t2
  t5 = 0.1e1 / t4
  t6 = s0 ** 2
  t7 = r0 ** 2
  t8 = t7 ** 2
  t11 = 0.1e1 / t1 / t8 / r0
  t13 = t1 ** 2
  t15 = 0.1e1 / t13 / t7
  t18 = 0.1e1 + 0.6e-2 * s0 * t15
  t19 = t18 ** 2
  t20 = 0.1e1 / t19
  t23 = -0.159068e0 + 0.286308e-6 * t6 * t11 * t20
  t27 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, f.p.zeta_threshold, 1)
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = t27 * t29
  t33 = t29 * t1 / 0.2e1 + 0.349e0
  t34 = 0.1e1 / t33
  t35 = t1 * t34
  t36 = t6 * t28
  t40 = 0.1e1 + 0.6e-2 * s0 * t29 * t15
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t43 = t11 * t42
  t46 = -0.18897e-1 + 0.11177280e-4 * t36 * t43
  t50 = t4 ** 2
  t59 = 0.1e1 / t1 / t8 / t7
  t64 = t8 ** 2
  t67 = t6 * s0 / t64 / r0
  t69 = 0.1e1 / t19 / t18
  t81 = t33 ** 2
  t91 = 0.1e1 / t41 / t40
  vrho_0_ = t5 * t23 / 0.4e1 + t30 * t35 * t46 / 0.2e1 + r0 * (0.29083333333333333333333333333333333333333333333332e-1 / t50 * t23 / t1 / r0 + t5 * (-0.15269760000000000000000000000000000000000000000000e-5 * t6 * t59 * t20 + 0.91618560000000000000000000000000000000000000000000e-8 * t67 * t69) / 0.4e1 + t30 / t13 * t34 * t46 / 0.6e1 - t27 * t28 * t2 / t81 * t46 / 0.6e1 + t30 * t35 * (-0.59612160000000000000000000000000000000000000000000e-4 * t36 * t59 * t42 + 0.71534592000000000000000000000000000000000000000000e-6 * t67 * t91) / 0.2e1)
  t104 = t6 / t64
  vsigma_0_ = r0 * (t5 * (0.572616e-6 * s0 * t11 * t20 - 0.3435696e-8 * t104 * t69) / 0.4e1 + t30 * t35 * (0.22354560e-4 * s0 * t28 * t43 - 0.268254720e-6 * t104 * t91) / 0.2e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t4 = 0.1e1 + 0.349e0 * t2
  t5 = t4 ** 2
  t6 = 0.1e1 / t5
  t7 = s0 ** 2
  t8 = r0 ** 2
  t9 = t8 ** 2
  t12 = 0.1e1 / t1 / t9 / r0
  t14 = t1 ** 2
  t16 = 0.1e1 / t14 / t8
  t19 = 0.1e1 + 0.6e-2 * s0 * t16
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t24 = -0.159068e0 + 0.286308e-6 * t7 * t12 * t21
  t25 = t6 * t24
  t27 = 0.1e1 / t1 / r0
  t30 = 0.1e1 / t4
  t33 = 0.1e1 / t1 / t9 / t8
  t37 = t7 * s0
  t38 = t9 ** 2
  t40 = 0.1e1 / t38 / r0
  t41 = t37 * t40
  t43 = 0.1e1 / t20 / t19
  t46 = -0.15269760000000000000000000000000000000000000000000e-5 * t7 * t33 * t21 + 0.91618560000000000000000000000000000000000000000000e-8 * t41 * t43
  t50 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, f.p.zeta_threshold, 1)
  t51 = 2 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t53 = t50 * t52
  t57 = t52 * t1 / 0.2e1 + 0.349e0
  t58 = 0.1e1 / t57
  t59 = 0.1e1 / t14 * t58
  t60 = t7 * t51
  t64 = 0.1e1 + 0.6e-2 * s0 * t52 * t16
  t65 = t64 ** 2
  t66 = 0.1e1 / t65
  t67 = t12 * t66
  t70 = -0.18897e-1 + 0.11177280e-4 * t60 * t67
  t74 = t50 * t51
  t75 = t57 ** 2
  t77 = t2 / t75
  t81 = t1 * t58
  t82 = t33 * t66
  t86 = 0.1e1 / t65 / t64
  t89 = -0.59612160000000000000000000000000000000000000000000e-4 * t60 * t82 + 0.71534592000000000000000000000000000000000000000000e-6 * t41 * t86
  t104 = t8 * r0
  t107 = 0.1e1 / t1 / t9 / t104
  t111 = t38 * t8
  t113 = t37 / t111
  t116 = t7 ** 2
  t120 = t116 / t14 / t38 / t9
  t121 = t20 ** 2
  t122 = 0.1e1 / t121
  t152 = t65 ** 2
  t154 = 0.1e1 / t152 * t52
  v2rho2_0_ = 0.58166666666666666666666666666666666666666666666664e-1 * t25 * t27 + t30 * t46 / 0.2e1 + t53 * t59 * t70 / 0.3e1 - t74 * t77 * t70 / 0.3e1 + t53 * t81 * t89 + r0 * (0.67667222222222222222222222222222222222222222222217e-2 / t5 / t4 * t24 * t16 + 0.58166666666666666666666666666666666666666666666664e-1 * t6 * t46 * t27 - 0.38777777777777777777777777777777777777777777777776e-1 * t25 / t1 / t8 + t30 * (0.96708480000000000000000000000000000000000000000000e-5 * t7 * t107 * t21 - 0.13131993600000000000000000000000000000000000000000e-6 * t113 * t43 + 0.43976908800000000000000000000000000000000000000000e-9 * t120 * t122) / 0.4e1 - t53 / t14 / r0 * t58 * t70 / 0.9e1 + t53 * t59 * t89 / 0.3e1 + t50 / r0 / t75 / t57 * t70 / 0.9e1 - t74 * t77 * t89 / 0.3e1 + t53 * t81 * (0.37754368000000000000000000000000000000000000000000e-3 * t60 * t107 * t66 - 0.10253291520000000000000000000000000000000000000000e-4 * t113 * t86 + 0.34336604160000000000000000000000000000000000000000e-7 * t120 * t154) / 0.2e1)
  t166 = 0.1e1 / t38
  t167 = t7 * t166
  t170 = 0.572616e-6 * s0 * t12 * t21 - 0.3435696e-8 * t167 * t43
  t173 = s0 * t51
  t178 = 0.22354560e-4 * t173 * t67 - 0.268254720e-6 * t167 * t86
  t188 = t7 * t40
  t194 = t37 / t14 / t38 / t104
  v2rhosigma_0_ = t30 * t170 / 0.4e1 + t53 * t81 * t178 / 0.2e1 + r0 * (0.29083333333333333333333333333333333333333333333332e-1 * t6 * t170 * t27 + t30 * (-0.30539520000000000000000000000000000000000000000000e-5 * s0 * t33 * t21 + 0.45809280000000000000000000000000000000000000000000e-7 * t188 * t43 - 0.16491340800000000000000000000000000000000000000000e-9 * t194 * t122) / 0.4e1 + t53 * t59 * t178 / 0.6e1 - t74 * t77 * t178 / 0.6e1 + t53 * t81 * (-0.11922432000000000000000000000000000000000000000000e-3 * t173 * t82 + 0.35767296000000000000000000000000000000000000000000e-5 * t188 * t86 - 0.12876226560000000000000000000000000000000000000000e-7 * t194 * t154) / 0.2e1)
  t220 = s0 * t166
  t225 = t7 / t14 / t111
  v2sigma2_0_ = r0 * (t30 * (0.572616e-6 * t12 * t21 - 0.13742784e-7 * t220 * t43 + 0.61842528e-10 * t225 * t122) / 0.4e1 + t53 * t81 * (0.22354560e-4 * t51 * t12 * t66 - 0.1073018880e-5 * t220 * t86 + 0.4828584960e-8 * t225 * t154) / 0.2e1)
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t4 = 0.1e1 + 0.349e0 * t2
  t5 = t4 ** 2
  t7 = 0.1e1 / t5 / t4
  t8 = s0 ** 2
  t9 = r0 ** 2
  t10 = t9 ** 2
  t11 = t10 * r0
  t13 = 0.1e1 / t1 / t11
  t15 = t1 ** 2
  t17 = 0.1e1 / t15 / t9
  t20 = 0.1e1 + 0.6e-2 * s0 * t17
  t21 = t20 ** 2
  t22 = 0.1e1 / t21
  t25 = -0.159068e0 + 0.286308e-6 * t8 * t13 * t22
  t26 = t7 * t25
  t29 = 0.1e1 / t5
  t32 = 0.1e1 / t1 / t10 / t9
  t36 = t8 * s0
  t37 = t10 ** 2
  t40 = t36 / t37 / r0
  t42 = 0.1e1 / t21 / t20
  t45 = -0.15269760000000000000000000000000000000000000000000e-5 * t8 * t32 * t22 + 0.91618560000000000000000000000000000000000000000000e-8 * t40 * t42
  t46 = t29 * t45
  t48 = 0.1e1 / t1 / r0
  t51 = t29 * t25
  t53 = 0.1e1 / t1 / t9
  t56 = 0.1e1 / t4
  t57 = t9 * r0
  t60 = 0.1e1 / t1 / t10 / t57
  t66 = t36 / t37 / t9
  t69 = t8 ** 2
  t73 = t69 / t15 / t37 / t10
  t74 = t21 ** 2
  t75 = 0.1e1 / t74
  t78 = 0.96708480000000000000000000000000000000000000000000e-5 * t8 * t60 * t22 - 0.13131993600000000000000000000000000000000000000000e-6 * t66 * t42 + 0.43976908800000000000000000000000000000000000000000e-9 * t73 * t75
  t82 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, f.p.zeta_threshold, 1)
  t83 = 2 ** (0.1e1 / 0.3e1)
  t84 = t83 ** 2
  t85 = t82 * t84
  t87 = 0.1e1 / t15 / r0
  t90 = t84 * t1 / 0.2e1 + 0.349e0
  t91 = 0.1e1 / t90
  t92 = t87 * t91
  t93 = t8 * t83
  t97 = 0.1e1 + 0.6e-2 * s0 * t84 * t17
  t98 = t97 ** 2
  t99 = 0.1e1 / t98
  t103 = -0.18897e-1 + 0.11177280e-4 * t93 * t13 * t99
  t108 = 0.1e1 / t15 * t91
  t113 = 0.1e1 / t98 / t97
  t116 = -0.59612160000000000000000000000000000000000000000000e-4 * t93 * t32 * t99 + 0.71534592000000000000000000000000000000000000000000e-6 * t40 * t113
  t120 = t82 / r0
  t121 = t90 ** 2
  t123 = 0.1e1 / t121 / t90
  t124 = t123 * t103
  t127 = t82 * t83
  t128 = 0.1e1 / t121
  t129 = t2 * t128
  t132 = t1 * t91
  t138 = t98 ** 2
  t140 = 0.1e1 / t138 * t84
  t143 = 0.37754368000000000000000000000000000000000000000000e-3 * t93 * t60 * t99 - 0.10253291520000000000000000000000000000000000000000e-4 * t66 * t113 + 0.34336604160000000000000000000000000000000000000000e-7 * t73 * t140
  t162 = t121 ** 2
  t172 = 0.1e1 / t1 / t37
  t178 = t36 / t37 / t57
  t184 = t69 / t15 / t37 / t11
  t188 = t37 ** 2
  t191 = t69 * s0 / t1 / t188
  t217 = t5 ** 2
  t244 = -t85 * t92 * t116 / 0.3e1 + t127 * t53 * t128 * t103 / 0.27e2 + t85 * t108 * t143 / 0.2e1 - t82 / t9 * t124 / 0.9e1 - t82 * t87 / t162 * t103 * t84 / 0.18e2 - t127 * t129 * t143 / 0.2e1 + t85 * t132 * (-0.27686536533333333333333333333333333333333333333333e-2 * t93 * t172 * t99 + 0.12669571072000000000000000000000000000000000000000e-3 * t178 * t113 - 0.92708831232000000000000000000000000000000000000000e-6 * t184 * t140 + 0.43950853324800000000000000000000000000000000000000e-8 * t191 / t138 / t97 * t83) / 0.2e1 - 0.27066888888888888888888888888888888888888888888887e-1 * t26 / t15 / t57 - 0.11633333333333333333333333333333333333333333333333e0 * t46 * t53 + 0.90481481481481481481481481481481481481481481481477e-1 * t51 / t1 / t57 + t120 * t123 * t116 / 0.3e1 + 0.20300166666666666666666666666666666666666666666665e-1 * t7 * t45 * t17 + 0.23615860555555555555555555555555555555555555555553e-2 / t217 * t25 / t10 + 0.87249999999999999999999999999999999999999999999996e-1 * t29 * t78 * t48 + 0.5e1 / 0.27e2 * t85 * t17 * t91 * t103 + t56 * (-0.70919552000000000000000000000000000000000000000000e-4 * t8 * t172 * t22 + 0.16226664960000000000000000000000000000000000000000e-5 * t178 * t42 - 0.11873765376000000000000000000000000000000000000000e-7 * t184 * t75 + 0.28145221632000000000000000000000000000000000000000e-10 * t191 / t74 / t20) / 0.4e1
  v3rho3_0_ = 0.20300166666666666666666666666666666666666666666665e-1 * t26 * t17 + 0.17450000000000000000000000000000000000000000000000e0 * t46 * t48 - 0.11633333333333333333333333333333333333333333333333e0 * t51 * t53 + 0.3e1 / 0.4e1 * t56 * t78 - t85 * t92 * t103 / 0.3e1 + t85 * t108 * t116 + t120 * t124 / 0.3e1 - t127 * t129 * t116 + 0.3e1 / 0.2e1 * t85 * t132 * t143 + r0 * t244

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, f.p.zeta_threshold, 1)
  t3 = r0 ** 2
  t4 = t3 * r0
  t7 = 2 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = r0 ** (0.1e1 / 0.3e1)
  t12 = t8 * t9 / 0.2e1 + 0.349e0
  t13 = t12 ** 2
  t15 = 0.1e1 / t13 / t12
  t16 = s0 ** 2
  t17 = t16 * t7
  t18 = t3 ** 2
  t19 = t18 * r0
  t21 = 0.1e1 / t9 / t19
  t23 = t9 ** 2
  t25 = 0.1e1 / t23 / t3
  t28 = 0.1e1 + 0.6e-2 * s0 * t8 * t25
  t29 = t28 ** 2
  t30 = 0.1e1 / t29
  t34 = -0.18897e-1 + 0.11177280e-4 * t17 * t21 * t30
  t35 = t15 * t34
  t39 = t2 / t3
  t40 = t18 * t3
  t42 = 0.1e1 / t9 / t40
  t46 = t16 * s0
  t47 = t18 ** 2
  t48 = t47 * r0
  t50 = t46 / t48
  t52 = 0.1e1 / t29 / t28
  t55 = -0.59612160000000000000000000000000000000000000000000e-4 * t17 * t42 * t30 + 0.71534592000000000000000000000000000000000000000000e-6 * t50 * t52
  t56 = t15 * t55
  t60 = t2 / r0
  t63 = 0.1e1 / t9 / t18 / t4
  t69 = t46 / t47 / t3
  t72 = t16 ** 2
  t73 = t47 * t18
  t76 = t72 / t23 / t73
  t77 = t29 ** 2
  t79 = 0.1e1 / t77 * t8
  t82 = 0.37754368000000000000000000000000000000000000000000e-3 * t17 * t63 * t30 - 0.10253291520000000000000000000000000000000000000000e-4 * t69 * t52 + 0.34336604160000000000000000000000000000000000000000e-7 * t76 * t79
  t86 = 0.1e1 / t9
  t88 = 0.1e1 + 0.349e0 * t86
  t89 = t88 ** 2
  t91 = 0.1e1 / t89 / t88
  t95 = 0.1e1 + 0.6e-2 * s0 * t25
  t96 = t95 ** 2
  t97 = 0.1e1 / t96
  t101 = 0.1e1 / t96 / t95
  t104 = t96 ** 2
  t105 = 0.1e1 / t104
  t108 = 0.96708480000000000000000000000000000000000000000000e-5 * t16 * t63 * t97 - 0.13131993600000000000000000000000000000000000000000e-6 * t69 * t101 + 0.43976908800000000000000000000000000000000000000000e-9 * t76 * t105
  t112 = t89 ** 2
  t113 = 0.1e1 / t112
  t119 = -0.15269760000000000000000000000000000000000000000000e-5 * t16 * t42 * t97 + 0.91618560000000000000000000000000000000000000000000e-8 * t50 * t101
  t121 = 0.1e1 / t18
  t129 = -0.159068e0 + 0.286308e-6 * t16 * t21 * t97
  t133 = 0.1e1 / t89
  t135 = 0.1e1 / t9 / t47
  t141 = t46 / t47 / t4
  t147 = t72 / t23 / t47 / t19
  t150 = t72 * s0
  t151 = t47 ** 2
  t154 = t150 / t9 / t151
  t156 = 0.1e1 / t104 / t95
  t159 = -0.70919552000000000000000000000000000000000000000000e-4 * t16 * t135 * t97 + 0.16226664960000000000000000000000000000000000000000e-5 * t141 * t101 - 0.11873765376000000000000000000000000000000000000000e-7 * t147 * t105 + 0.28145221632000000000000000000000000000000000000000e-10 * t154 * t156
  t162 = 0.1e1 / t9 / r0
  t165 = t91 * t129
  t170 = t133 * t119
  t172 = 0.1e1 / t9 / t4
  t175 = t133 * t129
  t180 = t91 * t119
  t182 = 0.1e1 / t23 / t4
  t185 = t113 * t129
  t189 = 0.16e2 / 0.81e2 * t2 / t4 * t35 - 0.4e1 / 0.9e1 * t39 * t56 + 0.2e1 / 0.3e1 * t60 * t15 * t82 + 0.40600333333333333333333333333333333333333333333330e-1 * t91 * t108 * t25 + 0.94463442222222222222222222222222222222222222222212e-2 * t113 * t119 * t121 + 0.10989247111851851851851851851851851851851851851850e-2 / t112 / t88 * t129 * t21 + 0.11633333333333333333333333333333333333333333333333e0 * t133 * t159 * t162 + 0.12029728395061728395061728395061728395061728395061e0 * t165 / t23 / t18 + 0.36192592592592592592592592592592592592592592592592e0 * t170 * t172 - 0.30160493827160493827160493827160493827160493827159e0 * t175 / t9 / t18 - 0.10826755555555555555555555555555555555555555555555e0 * t180 * t182 - 0.18892688444444444444444444444444444444444444444442e-1 * t185 / t19
  t190 = t133 * t108
  t192 = 0.1e1 / t9 / t3
  t195 = 0.1e1 / t88
  t197 = 0.1e1 / t9 / t48
  t202 = t46 / t73
  t208 = t72 / t23 / t47 / t40
  t214 = t150 / t9 / t151 / r0
  t220 = t72 * t16 / t151 / t18
  t229 = 0.1e1 / t23 / r0
  t230 = t2 * t229
  t231 = t13 ** 2
  t232 = 0.1e1 / t231
  t244 = t2 * t7
  t245 = 0.1e1 / t13
  t246 = t86 * t245
  t256 = 0.1e1 / t77 / t28 * t7
  t259 = -0.27686536533333333333333333333333333333333333333333e-2 * t17 * t135 * t30 + 0.12669571072000000000000000000000000000000000000000e-3 * t141 * t52 - 0.92708831232000000000000000000000000000000000000000e-6 * t147 * t79 + 0.43950853324800000000000000000000000000000000000000e-8 * t154 * t256
  t263 = t2 * t8
  t264 = 0.1e1 / t12
  t265 = t9 * t264
  t283 = t229 * t264
  t287 = t192 * t245
  t292 = 0.1e1 / t23 * t264
  t296 = t25 * t264
  t310 = t232 * t34 * t8
  t313 = -0.23266666666666666666666666666666666666666666666666e0 * t190 * t192 + t195 * (0.59099626666666666666666666666666666666666666666667e-3 * t16 * t197 * t97 - 0.20118757120000000000000000000000000000000000000000e-4 * t202 * t101 + 0.24016278528000000000000000000000000000000000000000e-6 * t208 * t105 - 0.12196262707200000000000000000000000000000000000000e-8 * t214 * t156 + 0.22516177305600000000000000000000000000000000000000e-11 * t220 / t104 / t96) / 0.4e1 - 0.2e1 / 0.9e1 * t230 * t232 * t55 * t8 + 0.2e1 / 0.27e2 * t2 * t192 / t231 / t12 * t34 * t7 - 0.2e1 / 0.3e1 * t244 * t246 * t259 + t263 * t265 * (0.23072113777777777777777777777777777777777777777777e-1 * t17 * t197 * t30 - 0.15708466517333333333333333333333333333333333333333e-2 * t202 * t52 + 0.18751601049600000000000000000000000000000000000000e-4 * t208 * t79 - 0.19045369774080000000000000000000000000000000000000e-6 * t214 * t256 + 0.70321365319680000000000000000000000000000000000000e-9 * t220 / t77 / t29) / 0.2e1 - 0.2e1 / 0.3e1 * t263 * t283 * t82 + 0.4e1 / 0.27e2 * t244 * t287 * t55 + 0.2e1 / 0.3e1 * t263 * t292 * t259 + 0.20e2 / 0.27e2 * t263 * t296 * t55 - 0.4e1 / 0.27e2 * t244 * t172 * t245 * t34 - 0.40e2 / 0.81e2 * t263 * t182 * t264 * t34 + 0.4e1 / 0.27e2 * t2 * t25 * t310
  v4rho4_0_ = r0 * (t189 + t313) + t195 * t159 - 0.10826755555555555555555555555555555555555555555555e0 * t165 * t182 - 0.46533333333333333333333333333333333333333333333333e0 * t170 * t192 + 0.36192592592592592592592592592592592592592592592592e0 * t175 * t172 + 0.81200666666666666666666666666666666666666666666662e-1 * t180 * t25 + 0.94463442222222222222222222222222222222222222222212e-2 * t185 * t121 + 0.34900000000000000000000000000000000000000000000000e0 * t190 * t162 - 0.4e1 / 0.3e1 * t263 * t283 * t55 + 0.4e1 / 0.27e2 * t244 * t287 * t34 + 0.2e1 * t263 * t292 * t82 - 0.2e1 / 0.9e1 * t230 * t310 - 0.2e1 * t244 * t246 * t82 + 0.2e1 * t263 * t265 * t259 + 0.20e2 / 0.27e2 * t263 * t296 * t34 - 0.4e1 / 0.9e1 * t39 * t35 + 0.4e1 / 0.3e1 * t60 * t56

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t5 = t1 * t4
  t6 = t1 ** 2
  t7 = t3 * t2
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t11 = -0.2e1 * t5 + 0.2e1 * t9
  t12 = t2 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 + 0.349e0 / t12
  t16 = 0.1e1 / t15
  t17 = t11 * t16
  t19 = s0 + 0.2e1 * s1 + s2
  t20 = t19 ** 2
  t21 = t3 ** 2
  t26 = t12 ** 2
  t28 = 0.1e1 / t26 / t3
  t31 = 0.1e1 + 0.6e-2 * t19 * t28
  t32 = t31 ** 2
  t33 = 0.1e1 / t32
  t36 = -0.159068e0 + 0.286308e-6 * t20 / t12 / t21 / t2 * t33
  t37 = t17 * t36
  t40 = -t6 * t4 + 0.1e1
  t41 = t15 ** 2
  t42 = 0.1e1 / t41
  t43 = t40 * t42
  t45 = 0.1e1 / t12 / t2
  t46 = t36 * t45
  t48 = 0.58166666666666666666666666666666666666666666666664e-1 * t43 * t46
  t49 = t40 * t16
  t56 = t20 * t19
  t57 = t21 ** 2
  t62 = 0.1e1 / t32 / t31
  t65 = -0.15269760000000000000000000000000000000000000000000e-5 * t20 / t12 / t21 / t3 * t33 + 0.91618560000000000000000000000000000000000000000000e-8 * t56 / t57 / t2 * t62
  t67 = t49 * t65 / 0.2e1
  t68 = 0.1e1 / t2
  t69 = t1 * t68
  t70 = 0.1e1 + t69
  t71 = t70 <= f.p.zeta_threshold
  t72 = t68 - t5
  t73 = f.my_piecewise3(t71, 0, t72)
  t74 = r0 ** (0.1e1 / 0.3e1)
  t75 = t73 * t74
  t76 = t74 + 0.349e0
  t77 = 0.1e1 / t76
  t78 = s0 ** 2
  t79 = r0 ** 2
  t80 = t79 ** 2
  t85 = t74 ** 2
  t90 = 0.1e1 + 0.6e-2 * s0 / t85 / t79
  t91 = t90 ** 2
  t92 = 0.1e1 / t91
  t95 = -0.18897e-1 + 0.5588640e-5 * t78 / t74 / t80 / r0 * t92
  t96 = t77 * t95
  t97 = t75 * t96
  t98 = f.my_piecewise3(t71, f.p.zeta_threshold, t70)
  t99 = 0.1e1 / t85
  t100 = t98 * t99
  t101 = t100 * t96
  t103 = 0.1e1 / t74
  t104 = t98 * t103
  t105 = t76 ** 2
  t106 = 0.1e1 / t105
  t107 = t106 * t95
  t108 = t104 * t107
  t110 = t98 * t74
  t117 = t78 * s0
  t118 = t80 ** 2
  t123 = 0.1e1 / t91 / t90
  t126 = -0.29806080000000000000000000000000000000000000000000e-4 * t78 / t74 / t80 / t79 * t92 + 0.17883648000000000000000000000000000000000000000000e-6 * t117 / t118 / r0 * t123
  t127 = t77 * t126
  t128 = t110 * t127
  t129 = 0.1e1 - t69
  t130 = t129 <= f.p.zeta_threshold
  t132 = f.my_piecewise3(t130, 0, -t72)
  t133 = r1 ** (0.1e1 / 0.3e1)
  t134 = t132 * t133
  t135 = t133 + 0.349e0
  t136 = 0.1e1 / t135
  t137 = s2 ** 2
  t138 = r1 ** 2
  t139 = t138 ** 2
  t144 = t133 ** 2
  t149 = 0.1e1 + 0.6e-2 * s2 / t144 / t138
  t150 = t149 ** 2
  t151 = 0.1e1 / t150
  t154 = -0.18897e-1 + 0.5588640e-5 * t137 / t133 / t139 / r1 * t151
  t155 = t136 * t154
  t156 = t134 * t155
  t161 = 0.38777777777777777777777777777777777777777777777776e-1 * t43 * t36 / t12 / t3
  t171 = t11 * t42 * t46
  t175 = 0.58166666666666666666666666666666666666666666666664e-1 * t43 * t65 * t45
  t181 = 0.67667222222222222222222222222222222222222222222217e-2 * t40 / t41 / t15 * t36 * t28
  t182 = t1 * t8
  t184 = -0.2e1 * t4 + 0.2e1 * t182
  t185 = f.my_piecewise3(t71, 0, t184)
  t217 = t78 ** 2
  t222 = t91 ** 2
  t231 = f.my_piecewise3(t130, 0, -t184)
  t235 = 0.2e1 * t4
  t236 = 0.8e1 * t182
  t239 = 0.6e1 * t6 / t21
  t244 = t17 * t65
  t257 = t20 ** 2
  t262 = t32 ** 2
  t268 = t49 * (0.96708480000000000000000000000000000000000000000000e-5 * t20 / t12 / t21 / t7 * t33 - 0.13131993600000000000000000000000000000000000000000e-6 * t56 / t57 / t3 * t62 + 0.43976908800000000000000000000000000000000000000000e-9 * t257 / t26 / t57 / t21 / t262) / 0.4e1
  t269 = -t161 + t73 * t99 * t96 / 0.3e1 - t98 / t85 / r0 * t96 / 0.9e1 + 0.58166666666666666666666666666666666666666666666664e-1 * t171 + t175 + t181 + t185 * t74 * t96 / 0.2e1 + t75 * t127 - t73 * t103 * t107 / 0.3e1 + t100 * t127 / 0.3e1 - t104 * t106 * t126 / 0.3e1 + t98 / r0 / t105 / t76 * t95 / 0.9e1 + t110 * t77 * (0.18877184000000000000000000000000000000000000000000e-3 * t78 / t74 / t80 / t79 / r0 * t92 - 0.25633228800000000000000000000000000000000000000000e-5 * t117 / t118 / t79 * t123 + 0.85841510400000000000000000000000000000000000000000e-8 * t217 / t85 / t118 / t80 / t222) / 0.2e1 + t231 * t133 * t155 / 0.2e1 + (-t235 + t236 - t239) * t16 * t36 / 0.4e1 + t244 / 0.2e1 + t268
  d11 = t37 / 0.2e1 + t48 + t67 + t97 + t101 / 0.3e1 - t108 / 0.3e1 + t128 + t156 + t2 * t269
  t278 = 0.2e1 * t5 + 0.2e1 * t9
  t279 = t278 * t16
  t280 = t279 * t36
  t282 = -t68 - t5
  t283 = f.my_piecewise3(t71, 0, t282)
  t284 = t283 * t74
  t285 = t284 * t96
  t288 = f.my_piecewise3(t130, 0, -t282)
  t289 = t288 * t133
  t290 = t289 * t155
  t292 = f.my_piecewise3(t130, f.p.zeta_threshold, t129)
  t293 = 0.1e1 / t144
  t294 = t292 * t293
  t295 = t294 * t155
  t297 = 0.1e1 / t133
  t298 = t292 * t297
  t299 = t135 ** 2
  t300 = 0.1e1 / t299
  t301 = t300 * t154
  t302 = t298 * t301
  t304 = t292 * t133
  t311 = t137 * s2
  t312 = t139 ** 2
  t317 = 0.1e1 / t150 / t149
  t320 = -0.29806080000000000000000000000000000000000000000000e-4 * t137 / t133 / t139 / t138 * t151 + 0.17883648000000000000000000000000000000000000000000e-6 * t311 / t312 / r1 * t317
  t321 = t136 * t320
  t322 = t304 * t321
  t329 = t278 * t42 * t46
  t331 = t279 * t65
  t335 = 0.2e1 * t182
  t336 = f.my_piecewise3(t71, 0, t335)
  t348 = f.my_piecewise3(t130, 0, -t335)
  t360 = (t235 - t239) * t16 * t36 / 0.4e1 + 0.29083333333333333333333333333333333333333333333332e-1 * t329 + t331 / 0.4e1 + 0.29083333333333333333333333333333333333333333333332e-1 * t171 + t181 + t175 - t161 + t244 / 0.4e1 + t268 + t336 * t74 * t96 / 0.2e1 + t283 * t99 * t96 / 0.6e1 - t283 * t103 * t107 / 0.6e1 + t284 * t127 / 0.2e1 + t348 * t133 * t155 / 0.2e1 + t132 * t293 * t155 / 0.6e1 - t132 * t297 * t301 / 0.6e1 + t134 * t321 / 0.2e1
  d12 = t37 / 0.4e1 + t48 + t67 + t97 / 0.2e1 + t101 / 0.6e1 - t108 / 0.6e1 + t128 / 0.2e1 + t156 / 0.2e1 + t280 / 0.4e1 + t285 / 0.2e1 + t290 / 0.2e1 + t295 / 0.6e1 - t302 / 0.6e1 + t322 / 0.2e1 + t2 * t360
  t375 = 0.2e1 * t4 + 0.2e1 * t182
  t376 = f.my_piecewise3(t71, 0, t375)
  t381 = f.my_piecewise3(t130, 0, -t375)
  t413 = t137 ** 2
  t418 = t150 ** 2
  t431 = -t161 + t288 * t293 * t155 / 0.3e1 - t292 / t144 / r1 * t155 / 0.9e1 + 0.58166666666666666666666666666666666666666666666664e-1 * t329 + t175 + t181 + t376 * t74 * t96 / 0.2e1 + t381 * t133 * t155 / 0.2e1 + t289 * t321 - t288 * t297 * t301 / 0.3e1 + t294 * t321 / 0.3e1 - t298 * t300 * t320 / 0.3e1 + t292 / r1 / t299 / t135 * t154 / 0.9e1 + t304 * t136 * (0.18877184000000000000000000000000000000000000000000e-3 * t137 / t133 / t139 / t138 / r1 * t151 - 0.25633228800000000000000000000000000000000000000000e-5 * t311 / t312 / t138 * t317 + 0.85841510400000000000000000000000000000000000000000e-8 * t413 / t144 / t312 / t139 / t418) / 0.2e1 + (-t235 - t236 - t239) * t16 * t36 / 0.4e1 + t331 / 0.2e1 + t268
  d22 = t280 / 0.2e1 + t48 + t67 + t285 + t290 + t295 / 0.3e1 - t302 / 0.3e1 + t322 + t2 * t431
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = r0 - r1
  t3 = 0.1e1 / t1
  t4 = t2 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = t1 ** 2
  t8 = t7 * t1
  t9 = 0.1e1 / t8
  t10 = t7 ** 2
  t11 = 0.1e1 / t10
  t12 = t2 * t11
  t14 = 0.6e1 * t9 - 0.6e1 * t12
  t15 = f.my_piecewise3(t6, 0, t14)
  t16 = r0 ** (0.1e1 / 0.3e1)
  t18 = t16 + 0.349e0
  t19 = 0.1e1 / t18
  t20 = s0 ** 2
  t21 = r0 ** 2
  t22 = t21 ** 2
  t23 = t22 * r0
  t27 = t16 ** 2
  t29 = 0.1e1 / t27 / t21
  t32 = 0.1e1 + 0.6e-2 * s0 * t29
  t33 = t32 ** 2
  t34 = 0.1e1 / t33
  t37 = -0.18897e-1 + 0.5588640e-5 * t20 / t16 / t23 * t34
  t38 = t19 * t37
  t41 = 0.1e1 / t7
  t42 = t2 * t9
  t44 = -0.2e1 * t41 + 0.2e1 * t42
  t45 = f.my_piecewise3(t6, 0, t44)
  t46 = t45 * t16
  t53 = t20 * s0
  t54 = t22 ** 2
  t59 = 0.1e1 / t33 / t32
  t62 = -0.29806080000000000000000000000000000000000000000000e-4 * t20 / t16 / t22 / t21 * t34 + 0.17883648000000000000000000000000000000000000000000e-6 * t53 / t54 / r0 * t59
  t63 = t19 * t62
  t66 = 0.1e1 / t16
  t68 = t18 ** 2
  t69 = 0.1e1 / t68
  t70 = t69 * t37
  t73 = t2 * t41
  t75 = f.my_piecewise3(t6, 0, t3 - t73)
  t76 = t75 * t16
  t77 = t21 * r0
  t89 = t20 ** 2
  t94 = t33 ** 2
  t95 = 0.1e1 / t94
  t98 = 0.18877184000000000000000000000000000000000000000000e-3 * t20 / t16 / t22 / t77 * t34 - 0.25633228800000000000000000000000000000000000000000e-5 * t53 / t54 / t21 * t59 + 0.85841510400000000000000000000000000000000000000000e-8 * t89 / t27 / t54 / t22 * t95
  t99 = t19 * t98
  t102 = t75 * t66
  t103 = t69 * t62
  t105 = 0.1e1 / r0
  t108 = 0.1e1 / t68 / t18
  t109 = t108 * t37
  t112 = f.my_piecewise3(t6, f.p.zeta_threshold, t5)
  t113 = 0.1e1 / t27
  t114 = t112 * t113
  t117 = t112 * t66
  t121 = t112 * t105
  t126 = 0.1e1 / t27 / r0
  t127 = t112 * t126
  t128 = t68 ** 2
  t133 = t112 * t16
  t151 = t54 ** 2
  t164 = 0.1e1 - t4 <= f.p.zeta_threshold
  t166 = f.my_piecewise3(t164, 0, -t14)
  t167 = r1 ** (0.1e1 / 0.3e1)
  t171 = s2 ** 2
  t172 = r1 ** 2
  t173 = t172 ** 2
  t178 = t167 ** 2
  t184 = (0.1e1 + 0.6e-2 * s2 / t178 / t172) ** 2
  t189 = 0.1e1 / (t167 + 0.349e0) * (-0.18897e-1 + 0.5588640e-5 * t171 / t167 / t173 / r1 / t184)
  t194 = t2 ** 2
  t195 = t10 * t1
  t200 = t1 ** (0.1e1 / 0.3e1)
  t203 = 0.1e1 + 0.349e0 / t200
  t204 = 0.1e1 / t203
  t207 = s0 + 0.2e1 * s1 + s2
  t208 = t207 ** 2
  t212 = t200 ** 2
  t214 = 0.1e1 / t212 / t7
  t217 = 0.1e1 + 0.6e-2 * t207 * t214
  t218 = t217 ** 2
  t219 = 0.1e1 / t218
  t222 = -0.159068e0 + 0.286308e-6 * t208 / t200 / t195 * t219
  t229 = -0.6e1 * t194 * t11 - 0.2e1 * t41 + 0.8e1 * t42
  t230 = t229 * t204
  t237 = t208 * t207
  t238 = t10 ** 2
  t243 = 0.1e1 / t218 / t217
  t246 = -0.15269760000000000000000000000000000000000000000000e-5 * t208 / t200 / t10 / t7 * t219 + 0.91618560000000000000000000000000000000000000000000e-8 * t237 / t238 / t1 * t243
  t251 = 0.2e1 * t194 * t9 - 0.2e1 * t73
  t252 = t251 * t204
  t264 = t208 ** 2
  t269 = t218 ** 2
  t270 = 0.1e1 / t269
  t273 = 0.96708480000000000000000000000000000000000000000000e-5 * t208 / t200 / t10 / t8 * t219 - 0.13131993600000000000000000000000000000000000000000e-6 * t237 / t238 / t7 * t243 + 0.43976908800000000000000000000000000000000000000000e-9 * t264 / t212 / t238 / t10 * t270
  t277 = -t194 * t41 + 0.1e1
  t278 = t277 * t204
  t296 = t238 ** 2
  t307 = t15 * t16 * t38 / 0.2e1 + 0.3e1 / 0.2e1 * t46 * t63 - t45 * t66 * t70 / 0.2e1 + 0.3e1 / 0.2e1 * t76 * t99 - t102 * t103 + t75 * t105 * t109 / 0.3e1 + t114 * t99 / 0.2e1 - t117 * t69 * t98 / 0.2e1 + t121 * t108 * t62 / 0.3e1 - t127 / t128 * t37 / 0.9e1 + t133 * t19 * (-0.13843268266666666666666666666666666666666666666667e-2 * t20 / t16 / t54 * t34 + 0.31673927680000000000000000000000000000000000000000e-4 * t53 / t54 / t77 * t59 - 0.23177207808000000000000000000000000000000000000000e-6 * t89 / t27 / t54 / t23 * t95 + 0.54938566656000000000000000000000000000000000000000e-9 * t89 * s0 / t16 / t151 / t94 / t32) / 0.2e1 + t166 * t167 * t189 / 0.2e1 + (0.12e2 * t9 - 0.36e2 * t12 + 0.24e2 * t194 / t195) * t204 * t222 / 0.4e1 + 0.3e1 / 0.4e1 * t230 * t246 + 0.3e1 / 0.4e1 * t252 * t273 + t278 * (-0.70919552000000000000000000000000000000000000000000e-4 * t208 / t200 / t238 * t219 + 0.16226664960000000000000000000000000000000000000000e-5 * t237 / t238 / t8 * t243 - 0.11873765376000000000000000000000000000000000000000e-7 * t264 / t212 / t238 / t195 * t270 + 0.28145221632000000000000000000000000000000000000000e-10 * t264 * t207 / t200 / t296 / t269 / t217) / 0.4e1
  t308 = t203 ** 2
  t309 = 0.1e1 / t308
  t310 = t277 * t309
  t326 = t251 * t309
  t328 = 0.1e1 / t200 / t7
  t329 = t222 * t328
  t336 = 0.1e1 / t308 / t203
  t337 = t277 * t336
  t346 = t75 * t113
  t357 = 0.1e1 / t200 / t1
  t358 = t222 * t357
  t361 = t246 * t357
  t365 = t222 * t214
  t374 = t308 ** 2
  t380 = 0.90481481481481481481481481481481481481481481481477e-1 * t310 * t222 / t200 / t8 - t75 * t126 * t38 / 0.3e1 + 0.5e1 / 0.27e2 * t112 * t29 * t38 - t112 / t21 * t109 / 0.9e1 - 0.11633333333333333333333333333333333333333333333333e0 * t326 * t329 - 0.11633333333333333333333333333333333333333333333333e0 * t310 * t246 * t328 - 0.27066888888888888888888888888888888888888888888887e-1 * t337 * t222 / t212 / t8 + t45 * t113 * t38 / 0.2e1 + t346 * t63 - t127 * t63 / 0.3e1 + t112 / t16 / t21 * t70 / 0.27e2 + 0.87249999999999999999999999999999999999999999999996e-1 * t229 * t309 * t358 + 0.17450000000000000000000000000000000000000000000000e0 * t326 * t361 + 0.20300166666666666666666666666666666666666666666665e-1 * t251 * t336 * t365 + 0.87249999999999999999999999999999999999999999999996e-1 * t310 * t273 * t357 + 0.20300166666666666666666666666666666666666666666665e-1 * t337 * t246 * t214 + 0.23615860555555555555555555555555555555555555555553e-2 * t277 / t374 * t222 * t11
  t412 = f.my_piecewise3(t164, 0, -t44)
  d111 = t1 * (t307 + t380) + 0.3e1 / 0.4e1 * t230 * t222 + 0.3e1 / 0.2e1 * t252 * t246 + 0.3e1 / 0.4e1 * t278 * t273 - 0.11633333333333333333333333333333333333333333333333e0 * t310 * t329 + t346 * t38 - t127 * t38 / 0.3e1 + 0.17449999999999999999999999999999999999999999999999e0 * t326 * t358 + 0.17449999999999999999999999999999999999999999999999e0 * t310 * t361 + 0.20300166666666666666666666666666666666666666666665e-1 * t337 * t365 + 0.3e1 / 0.2e1 * t46 * t38 + 0.3e1 * t76 * t63 - t102 * t70 + t114 * t63 - t117 * t103 + t121 * t109 / 0.3e1 + 0.3e1 / 0.2e1 * t133 * t99 + 0.3e1 / 0.2e1 * t412 * t167 * t189

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.my_piecewise3(t6, f.p.zeta_threshold, t5)
  t8 = r0 ** (0.1e1 / 0.3e1)
  t9 = t7 * t8
  t10 = t8 + 0.349e0
  t11 = 0.1e1 / t10
  t12 = s0 ** 2
  t13 = r0 ** 2
  t14 = t13 ** 2
  t15 = t14 ** 2
  t19 = t8 ** 2
  t21 = 0.1e1 / t19 / t13
  t24 = 0.1e1 + 0.6e-2 * s0 * t21
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t29 = t12 * s0
  t30 = t13 * r0
  t35 = 0.1e1 / t25 / t24
  t38 = t12 ** 2
  t39 = t14 * r0
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = t38 * s0
  t49 = t15 ** 2
  t54 = 0.1e1 / t44 / t24
  t57 = -0.13843268266666666666666666666666666666666666666667e-2 * t12 / t8 / t15 * t26 + 0.31673927680000000000000000000000000000000000000000e-4 * t29 / t15 / t30 * t35 - 0.23177207808000000000000000000000000000000000000000e-6 * t38 / t19 / t15 / t39 * t45 + 0.54938566656000000000000000000000000000000000000000e-9 * t48 / t8 / t49 * t54
  t58 = t11 * t57
  t62 = 0.1e1 - t4 <= f.p.zeta_threshold
  t63 = t2 ** 2
  t64 = t63 * t2
  t65 = 0.1e1 / t64
  t66 = t63 ** 2
  t67 = 0.1e1 / t66
  t68 = t1 * t67
  t70 = -0.6e1 * t65 + 0.6e1 * t68
  t71 = f.my_piecewise3(t62, 0, t70)
  t72 = r1 ** (0.1e1 / 0.3e1)
  t76 = s2 ** 2
  t77 = r1 ** 2
  t78 = t77 ** 2
  t83 = t72 ** 2
  t89 = (0.1e1 + 0.6e-2 * s2 / t83 / t77) ** 2
  t94 = 0.1e1 / (t72 + 0.349e0) * (-0.18897e-1 + 0.5588640e-5 * t76 / t72 / t78 / r1 / t89)
  t97 = t1 ** 2
  t98 = 0.1e1 / t63
  t100 = -t97 * t98 + 0.1e1
  t101 = t2 ** (0.1e1 / 0.3e1)
  t104 = 0.1e1 + 0.349e0 / t101
  t105 = t104 ** 2
  t106 = 0.1e1 / t105
  t107 = t100 * t106
  t109 = s0 + 0.2e1 * s1 + s2
  t110 = t109 ** 2
  t111 = t66 * t2
  t113 = 0.1e1 / t101 / t111
  t115 = t101 ** 2
  t117 = 0.1e1 / t115 / t63
  t120 = 0.1e1 + 0.6e-2 * t109 * t117
  t121 = t120 ** 2
  t122 = 0.1e1 / t121
  t125 = -0.159068e0 + 0.286308e-6 * t110 * t113 * t122
  t127 = 0.1e1 / t101 / t64
  t128 = t125 * t127
  t131 = t1 * t98
  t133 = f.my_piecewise3(t6, 0, t3 - t131)
  t135 = 0.1e1 / t19 / r0
  t136 = t133 * t135
  t142 = -0.18897e-1 + 0.5588640e-5 * t12 / t8 / t39 * t26
  t143 = t11 * t142
  t146 = t7 * t21
  t149 = 0.1e1 / t13
  t150 = t7 * t149
  t151 = t10 ** 2
  t153 = 0.1e1 / t151 / t10
  t154 = t153 * t142
  t159 = 0.2e1 * t97 * t65 - 0.2e1 * t131
  t160 = t159 * t106
  t162 = 0.1e1 / t101 / t63
  t163 = t125 * t162
  t167 = 0.1e1 / t105 / t104
  t168 = t100 * t167
  t170 = 0.1e1 / t115 / t64
  t171 = t125 * t170
  t174 = t1 * t65
  t177 = f.my_piecewise3(t6, 0, -0.2e1 * t98 + 0.2e1 * t174)
  t178 = 0.1e1 / t19
  t179 = t177 * t178
  t182 = t133 * t178
  t183 = t14 * t13
  t189 = t15 * r0
  t194 = -0.29806080000000000000000000000000000000000000000000e-4 * t12 / t8 / t183 * t26 + 0.17883648000000000000000000000000000000000000000000e-6 * t29 / t189 * t35
  t195 = t11 * t194
  t198 = t7 * t135
  t202 = 0.1e1 / t8 / t13
  t203 = t7 * t202
  t204 = 0.1e1 / t151
  t205 = t204 * t142
  t212 = -0.6e1 * t97 * t67 + 0.8e1 * t174 - 0.2e1 * t98
  t213 = t212 * t106
  t215 = 0.1e1 / t101 / t2
  t216 = t125 * t215
  t219 = t159 * t167
  t220 = t125 * t117
  t223 = t105 ** 2
  t224 = 0.1e1 / t223
  t225 = t100 * t224
  t226 = t125 * t67
  t230 = f.my_piecewise3(t6, 0, -t70)
  t231 = t230 * t8
  t234 = t177 * t8
  t237 = 0.2e1 * t9 * t58 + 0.2e1 * t71 * t72 * t94 + 0.36192592592592592592592592592592592592592592592592e0 * t107 * t128 - 0.4e1 / 0.3e1 * t136 * t143 + 0.20e2 / 0.27e2 * t146 * t143 - 0.4e1 / 0.9e1 * t150 * t154 - 0.46533333333333333333333333333333333333333333333331e0 * t160 * t163 - 0.10826755555555555555555555555555555555555555555555e0 * t168 * t171 + 0.2e1 * t179 * t143 + 0.4e1 * t182 * t195 - 0.4e1 / 0.3e1 * t198 * t195 + 0.4e1 / 0.27e2 * t203 * t205 + 0.34899999999999999999999999999999999999999999999998e0 * t213 * t216 + 0.81200666666666666666666666666666666666666666666660e-1 * t219 * t220 + 0.94463442222222222222222222222222222222222222222212e-2 * t225 * t226 + 0.2e1 * t231 * t143 + 0.6e1 * t234 * t195
  t238 = 0.1e1 / t8
  t239 = t177 * t238
  t242 = t66 * t63
  t248 = t110 * t109
  t249 = t66 ** 2
  t250 = t249 * t2
  t254 = 0.1e1 / t121 / t120
  t257 = -0.15269760000000000000000000000000000000000000000000e-5 * t110 / t101 / t242 * t122 + 0.91618560000000000000000000000000000000000000000000e-8 * t248 / t250 * t254
  t258 = t257 * t162
  t261 = t257 * t215
  t275 = t110 ** 2
  t276 = t249 * t66
  t280 = t121 ** 2
  t281 = 0.1e1 / t280
  t284 = 0.96708480000000000000000000000000000000000000000000e-5 * t110 / t101 / t66 / t64 * t122 - 0.13131993600000000000000000000000000000000000000000e-6 * t248 / t249 / t63 * t254 + 0.43976908800000000000000000000000000000000000000000e-9 * t275 / t115 / t276 * t281
  t285 = t284 * t215
  t288 = t257 * t117
  t291 = t133 * t8
  t303 = t15 * t14
  t309 = 0.18877184000000000000000000000000000000000000000000e-3 * t12 / t8 / t14 / t30 * t26 - 0.25633228800000000000000000000000000000000000000000e-5 * t29 / t15 / t13 * t35 + 0.85841510400000000000000000000000000000000000000000e-8 * t38 / t19 / t303 * t45
  t310 = t11 * t309
  t313 = t133 * t238
  t314 = t204 * t194
  t317 = 0.1e1 / r0
  t318 = t133 * t317
  t321 = t7 * t178
  t324 = t7 * t238
  t325 = t204 * t309
  t328 = t7 * t317
  t329 = t153 * t194
  t332 = t151 ** 2
  t333 = 0.1e1 / t332
  t334 = t333 * t142
  t337 = 0.1e1 / t104
  t338 = t159 * t337
  t341 = t100 * t337
  t358 = t275 * t109
  t359 = t249 ** 2
  t364 = 0.1e1 / t280 / t120
  t367 = -0.70919552000000000000000000000000000000000000000000e-4 * t110 / t101 / t249 * t122 + 0.16226664960000000000000000000000000000000000000000e-5 * t248 / t249 / t64 * t254 - 0.11873765376000000000000000000000000000000000000000e-7 * t275 / t115 / t249 / t111 * t281 + 0.28145221632000000000000000000000000000000000000000e-10 * t358 / t101 / t359 * t364
  t371 = 0.1e1 / t111
  t374 = 0.24e2 * t97 * t371 + 0.12e2 * t65 - 0.36e2 * t68
  t375 = t374 * t337
  t377 = t212 * t337
  t418 = -0.4e1 / 0.9e1 * t198 * t333 * t194 - 0.2e1 / 0.3e1 * t177 * t135 * t143 - 0.4e1 / 0.3e1 * t136 * t195 + 0.4e1 / 0.27e2 * t133 * t202 * t205 + 0.20e2 / 0.27e2 * t146 * t195 - 0.4e1 / 0.27e2 * t7 / t8 / t30 * t205 - 0.4e1 / 0.9e1 * t133 * t149 * t154 - 0.23266666666666666666666666666666666666666666666666e0 * t213 * t163 - 0.46533333333333333333333333333333333333333333333333e0 * t160 * t258 - 0.10826755555555555555555555555555555555555555555555e0 * t219 * t171 - 0.4e1 / 0.9e1 * t150 * t329 + 0.8e1 / 0.27e2 * t146 * t334 + 0.2e1 / 0.3e1 * t321 * t58 - 0.30160493827160493827160493827160493827160493827159e0 * t107 * t125 / t101 / t66
  t463 = 0.20e2 / 0.27e2 * t133 * t21 * t143 - 0.40e2 / 0.81e2 * t7 / t19 / t30 * t143 + 0.16e2 / 0.81e2 * t7 / t30 * t154 - 0.2e1 * t313 * t325 - 0.2e1 / 0.3e1 * t324 * t204 * t57 + 0.2e1 / 0.3e1 * t328 * t153 * t309 + 0.4e1 / 0.3e1 * t318 * t329 + 0.40600333333333333333333333333333333333333333333330e-1 * t212 * t167 * t220 + 0.34900000000000000000000000000000000000000000000000e0 * t160 * t285 + 0.81200666666666666666666666666666666666666666666662e-1 * t219 * t288 + 0.94463442222222222222222222222222222222222222222212e-2 * t159 * t224 * t226 + 0.11633333333333333333333333333333333333333333333333e0 * t107 * t367 * t215 + 0.40600333333333333333333333333333333333333333333330e-1 * t168 * t284 * t117 - 0.23266666666666666666666666666666666666666666666666e0 * t107 * t284 * t162 - 0.10826755555555555555555555555555555555555555555555e0 * t168 * t257 * t170
  t479 = t1 * t371
  t481 = 0.24e2 * t67 - 0.24e2 * t479
  t482 = f.my_piecewise3(t62, 0, t481)
  t538 = -0.18892688444444444444444444444444444444444444444442e-1 * t225 * t125 * t371 + 0.2e1 / 0.3e1 * t230 * t178 * t143 + 0.2e1 * t179 * t195 + 0.2e1 * t182 * t310 - 0.2e1 / 0.3e1 * t198 * t310 + 0.4e1 / 0.27e2 * t203 * t314 + t482 * t72 * t94 / 0.2e1 + 0.36192592592592592592592592592592592592592592592592e0 * t160 * t128 + 0.36192592592592592592592592592592592592592592592592e0 * t107 * t257 * t127 + 0.12029728395061728395061728395061728395061728395061e0 * t168 * t125 / t115 / t66 - 0.4e1 / 0.9e1 * t136 * t334 + 0.4e1 / 0.27e2 * t203 / t332 / t10 * t142 + 0.2e1 * t291 * t58 + t9 * t11 * (0.11536056888888888888888888888888888888888888888889e-1 * t12 / t8 / t189 * t26 - 0.39271166293333333333333333333333333333333333333333e-3 * t29 / t303 * t35 + 0.46879002624000000000000000000000000000000000000000e-5 * t38 / t19 / t15 / t183 * t45 - 0.23806712217600000000000000000000000000000000000000e-7 * t48 / t8 / t49 / r0 * t54 + 0.43950853324800000000000000000000000000000000000000e-10 * t38 * t12 / t49 / t14 / t44 / t25) / 0.2e1
  t549 = f.my_piecewise3(t6, 0, -t481)
  t615 = 0.94463442222222222222222222222222222222222222222212e-2 * t225 * t257 * t67 + 0.10989247111851851851851851851851851851851851851850e-2 * t100 / t223 / t104 * t125 * t113 + t549 * t8 * t143 / 0.2e1 + 0.2e1 * t231 * t195 - 0.2e1 / 0.3e1 * t230 * t238 * t205 + 0.3e1 * t234 * t310 - 0.2e1 * t239 * t314 + 0.2e1 / 0.3e1 * t177 * t317 * t154 + 0.11633333333333333333333333333333333333333333333333e0 * t374 * t106 * t216 + 0.34900000000000000000000000000000000000000000000000e0 * t213 * t261 + t341 * (0.59099626666666666666666666666666666666666666666667e-3 * t110 / t101 / t250 * t122 - 0.20118757120000000000000000000000000000000000000000e-4 * t248 / t276 * t254 + 0.24016278528000000000000000000000000000000000000000e-6 * t275 / t115 / t249 / t242 * t281 - 0.12196262707200000000000000000000000000000000000000e-8 * t358 / t101 / t359 / t2 * t364 + 0.22516177305600000000000000000000000000000000000000e-11 * t275 * t110 / t359 / t66 / t280 / t121) / 0.4e1 + (-0.72e2 * t67 + 0.192e3 * t479 - 0.120e3 * t97 / t242) * t337 * t125 / 0.4e1 + t375 * t257 + 0.3e1 / 0.2e1 * t377 * t284 + t338 * t367
  t619 = -0.2e1 * t239 * t205 - 0.46533333333333333333333333333333333333333333333331e0 * t107 * t258 + 0.69799999999999999999999999999999999999999999999998e0 * t160 * t261 + 0.34899999999999999999999999999999999999999999999998e0 * t107 * t285 + 0.81200666666666666666666666666666666666666666666660e-1 * t168 * t288 + 0.6e1 * t291 * t310 - 0.4e1 * t313 * t314 + 0.4e1 / 0.3e1 * t318 * t154 + 0.2e1 * t321 * t310 - 0.2e1 * t324 * t325 + 0.4e1 / 0.3e1 * t328 * t329 - 0.4e1 / 0.9e1 * t198 * t334 + 0.3e1 * t338 * t284 + t341 * t367 + t375 * t125 + 0.3e1 * t377 * t257 + t2 * (t418 + t463 + t538 + t615)
  d1111 = t237 + t619

  res = {'v4rho4': d1111}
  return res
