"""Generated from gga_c_ft97.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  C0 = (1 - jnp.log(2)) / (2 * jnp.pi ** 2)

  C2 = f.RS_FACTOR

  cutoff = 10000000.0

  kssp0_k0 = 1.291551074

  kssp0_k1 = 0.349064173

  kssp0_r1 = 0.08327588

  fssp_A1 = 1.622118767

  fssp_A2 = 0.489958076

  fssp_A3 = 1.379021941

  fa_a1 = 0.939016

  fa_a2 = 1.73317

  kss0_k0 = 1.200801774

  kss0_k1 = 0.859614445

  kss0_k2 = -0.812904345

  kss0_r1 = 1.089338848

  kss0_r2 = 0.655638823

  fss_A4 = 4.946281353

  fss_A5 = 3.600612059

  eq15 = lambda mu: (3 + 2 * (jnp.sqrt(mu) + mu)) / (3 + 6 * (jnp.sqrt(mu) + mu))

  C1 = 4 * C0 / 3

  C3 = C2 / 3

  kssp0 = lambda rs: kssp0_k0 - kssp0_k1 * (1 - jnp.exp(-kssp0_r1 * rs ** (4 / 5)))

  fssp = lambda rs, gr: (1 + fssp_A1 * gr + fssp_A2 ** 2 * gr ** 2) * jnp.exp(-fssp_A2 ** 2 * gr ** 2) / jnp.sqrt(1 + fssp_A3 * gr / rs)

  f_factor = lambda rs: jnp.exp(-rs ** 2 / (fa_a1 * jnp.sqrt(rs) + fa_a2 * rs) ** 2)

  kss0 = lambda rs, gr=None: +kss0_k0 + kss0_k1 * (1 - jnp.exp(-kss0_r1 * jnp.sqrt(rs))) + kss0_k2 * (1 - jnp.exp(-kss0_r2 * rs ** (2 / 5)))

  fss = lambda rs, gr: (1 + fss_A4 ** 2 * gr ** 2) * jnp.exp(-fss_A4 ** 2 * gr ** 2) / jnp.sqrt(1 + fss_A5 * gr / rs)

  f_eab = lambda mu: C0 * (-xc_E1_scaled(mu) * (1 + 2 * mu * eq15(mu)) + 2 * eq15(mu))

  mu_ba = lambda rsa, ga2: C1 * rsa / jnp.maximum(kssp0(rsa) ** 2 * fssp(rsa, ga2) ** 2, 1e-60)

  mu_aa = lambda rsa, ga2: C1 * rsa / jnp.maximum(kss0(rsa) ** 2 * fss(rsa, ga2) ** 2, 1e-60)

  term1 = lambda rsa, z, ga2: f.my_piecewise3(mu_ba(rsa, ga2) >= cutoff, 0, f_eab(mu_ba(rsa, ga2)) * (1 - z) / 2)

  term2 = lambda rsa, z, ga2: f.my_piecewise3(mu_aa(rsa, ga2) >= cutoff, 0, f_eab(mu_aa(rsa, ga2)) * f_factor(rsa) * (1 + z) / 2)

  f_ft97 = lambda rs, z, xs: +term1(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2) + term2(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2)

  functional_body = lambda rs, z, xt, xs0, xs1: f_ft97(rs, z, xs0) + f_ft97(rs, -z, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  C0 = (1 - jnp.log(2)) / (2 * jnp.pi ** 2)

  C2 = f.RS_FACTOR

  cutoff = 10000000.0

  kssp0_k0 = 1.291551074

  kssp0_k1 = 0.349064173

  kssp0_r1 = 0.08327588

  fssp_A1 = 1.622118767

  fssp_A2 = 0.489958076

  fssp_A3 = 1.379021941

  fa_a1 = 0.939016

  fa_a2 = 1.73317

  kss0_k0 = 1.200801774

  kss0_k1 = 0.859614445

  kss0_k2 = -0.812904345

  kss0_r1 = 1.089338848

  kss0_r2 = 0.655638823

  fss_A4 = 4.946281353

  fss_A5 = 3.600612059

  eq15 = lambda mu: (3 + 2 * (jnp.sqrt(mu) + mu)) / (3 + 6 * (jnp.sqrt(mu) + mu))

  C1 = 4 * C0 / 3

  C3 = C2 / 3

  kssp0 = lambda rs: kssp0_k0 - kssp0_k1 * (1 - jnp.exp(-kssp0_r1 * rs ** (4 / 5)))

  fssp = lambda rs, gr: (1 + fssp_A1 * gr + fssp_A2 ** 2 * gr ** 2) * jnp.exp(-fssp_A2 ** 2 * gr ** 2) / jnp.sqrt(1 + fssp_A3 * gr / rs)

  f_factor = lambda rs: jnp.exp(-rs ** 2 / (fa_a1 * jnp.sqrt(rs) + fa_a2 * rs) ** 2)

  kss0 = lambda rs, gr=None: +kss0_k0 + kss0_k1 * (1 - jnp.exp(-kss0_r1 * jnp.sqrt(rs))) + kss0_k2 * (1 - jnp.exp(-kss0_r2 * rs ** (2 / 5)))

  fss = lambda rs, gr: (1 + fss_A4 ** 2 * gr ** 2) * jnp.exp(-fss_A4 ** 2 * gr ** 2) / jnp.sqrt(1 + fss_A5 * gr / rs)

  f_eab = lambda mu: C0 * (-xc_E1_scaled(mu) * (1 + 2 * mu * eq15(mu)) + 2 * eq15(mu))

  mu_ba = lambda rsa, ga2: C1 * rsa / jnp.maximum(kssp0(rsa) ** 2 * fssp(rsa, ga2) ** 2, 1e-60)

  mu_aa = lambda rsa, ga2: C1 * rsa / jnp.maximum(kss0(rsa) ** 2 * fss(rsa, ga2) ** 2, 1e-60)

  term1 = lambda rsa, z, ga2: f.my_piecewise3(mu_ba(rsa, ga2) >= cutoff, 0, f_eab(mu_ba(rsa, ga2)) * (1 - z) / 2)

  term2 = lambda rsa, z, ga2: f.my_piecewise3(mu_aa(rsa, ga2) >= cutoff, 0, f_eab(mu_aa(rsa, ga2)) * f_factor(rsa) * (1 + z) / 2)

  f_ft97 = lambda rs, z, xs: +term1(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2) + term2(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2)

  functional_body = lambda rs, z, xt, xs0, xs1: f_ft97(rs, z, xs0) + f_ft97(rs, -z, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  C0 = (1 - jnp.log(2)) / (2 * jnp.pi ** 2)

  C2 = f.RS_FACTOR

  cutoff = 10000000.0

  kssp0_k0 = 1.291551074

  kssp0_k1 = 0.349064173

  kssp0_r1 = 0.08327588

  fssp_A1 = 1.622118767

  fssp_A2 = 0.489958076

  fssp_A3 = 1.379021941

  fa_a1 = 0.939016

  fa_a2 = 1.73317

  kss0_k0 = 1.200801774

  kss0_k1 = 0.859614445

  kss0_k2 = -0.812904345

  kss0_r1 = 1.089338848

  kss0_r2 = 0.655638823

  fss_A4 = 4.946281353

  fss_A5 = 3.600612059

  eq15 = lambda mu: (3 + 2 * (jnp.sqrt(mu) + mu)) / (3 + 6 * (jnp.sqrt(mu) + mu))

  C1 = 4 * C0 / 3

  C3 = C2 / 3

  kssp0 = lambda rs: kssp0_k0 - kssp0_k1 * (1 - jnp.exp(-kssp0_r1 * rs ** (4 / 5)))

  fssp = lambda rs, gr: (1 + fssp_A1 * gr + fssp_A2 ** 2 * gr ** 2) * jnp.exp(-fssp_A2 ** 2 * gr ** 2) / jnp.sqrt(1 + fssp_A3 * gr / rs)

  f_factor = lambda rs: jnp.exp(-rs ** 2 / (fa_a1 * jnp.sqrt(rs) + fa_a2 * rs) ** 2)

  kss0 = lambda rs, gr=None: +kss0_k0 + kss0_k1 * (1 - jnp.exp(-kss0_r1 * jnp.sqrt(rs))) + kss0_k2 * (1 - jnp.exp(-kss0_r2 * rs ** (2 / 5)))

  fss = lambda rs, gr: (1 + fss_A4 ** 2 * gr ** 2) * jnp.exp(-fss_A4 ** 2 * gr ** 2) / jnp.sqrt(1 + fss_A5 * gr / rs)

  f_eab = lambda mu: C0 * (-xc_E1_scaled(mu) * (1 + 2 * mu * eq15(mu)) + 2 * eq15(mu))

  mu_ba = lambda rsa, ga2: C1 * rsa / jnp.maximum(kssp0(rsa) ** 2 * fssp(rsa, ga2) ** 2, 1e-60)

  mu_aa = lambda rsa, ga2: C1 * rsa / jnp.maximum(kss0(rsa) ** 2 * fss(rsa, ga2) ** 2, 1e-60)

  term1 = lambda rsa, z, ga2: f.my_piecewise3(mu_ba(rsa, ga2) >= cutoff, 0, f_eab(mu_ba(rsa, ga2)) * (1 - z) / 2)

  term2 = lambda rsa, z, ga2: f.my_piecewise3(mu_aa(rsa, ga2) >= cutoff, 0, f_eab(mu_aa(rsa, ga2)) * f_factor(rsa) * (1 + z) / 2)

  f_ft97 = lambda rs, z, xs: +term1(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2) + term2(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2)

  functional_body = lambda rs, z, xt, xs0, xs1: f_ft97(rs, z, xs0) + f_ft97(rs, -z, xs1)

  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / jnp.pi
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = t5 * t9
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 + r1
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t14
  t16 = t12 * t15
  t17 = 2 ** (0.1e1 / 0.3e1)
  t18 = r0 - r1
  t19 = 0.1e1 / t13
  t20 = t18 * t19
  t21 = 0.1e1 + t20
  t22 = 0.1e1 / t21
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t17 * t23
  t25 = 4 ** (0.1e1 / 0.5e1)
  t26 = t9 * t12
  t27 = t15 * t17
  t28 = t27 * t23
  t29 = t26 * t28
  t30 = t29 ** (0.1e1 / 0.5e1)
  t31 = t30 ** 2
  t32 = t31 ** 2
  t35 = jnp.exp(-0.20818970000000000000000000000000000000000000000000e-1 * t25 * t32)
  t37 = 0.942486901e0 + 0.349064173e0 * t35
  t38 = t37 ** 2
  t39 = t6 ** 2
  t40 = t8 ** 2
  t41 = t39 * t40
  t42 = t11 * s0
  t43 = r0 ** 2
  t44 = r0 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t47 = 0.1e1 / t45 / t43
  t52 = t6 * t8 * t7
  t53 = s0 ** 2
  t54 = t12 * t53
  t55 = t43 ** 2
  t58 = 0.1e1 / t44 / t55 / r0
  t60 = t52 * t54 * t58
  t61 = 0.55569193573523559259259259259259259259259259259259e-3 * t60
  t62 = 0.1e1 + 0.45058854638888888888888888888888888888888888888889e-1 * t41 * t42 * t47 + t61
  t63 = t62 ** 2
  t64 = t38 * t63
  t65 = jnp.exp(-t61)
  t66 = t65 ** 2
  t67 = t12 * s0
  t68 = t9 * t67
  t70 = t17 ** 2
  t71 = 0.1e1 / t23
  t72 = t70 * t71
  t74 = t68 * t47 * t14 * t72
  t76 = 0.1e1 + 0.19153082513888888888888888888888888888888888888889e-1 * t74
  t78 = t66 / t76
  t79 = t64 * t78
  t80 = 0.1e-59 < t79
  t81 = f.my_piecewise3(t80, t79, 0.1e-59)
  t82 = 0.1e1 / t81
  t83 = t24 * t82
  t85 = t10 * t16 * t83
  t86 = t85 / 0.6e1
  t87 = 0.10e8 <= t86
  t88 = xc_E1_scaled(t86)
  t89 = t5 * t26
  t90 = jnp.sqrt(0.6e1)
  t91 = t90 * t7
  t92 = t2 * t6
  t93 = t8 * t12
  t94 = t92 * t93
  t95 = t23 * t82
  t98 = jnp.sqrt(t94 * t27 * t95)
  t99 = t91 * t98
  t102 = 0.3e1 + t99 / 0.3e1 + t85 / 0.3e1
  t104 = 0.3e1 + t99 + t85
  t105 = 0.1e1 / t104
  t106 = t82 * t102 * t105
  t110 = 0.1e1 + t89 * t28 * t106 / 0.3e1
  t112 = t102 * t105
  t114 = -t88 * t110 + 0.2e1 * t112
  t115 = 0.1e1 - t20
  t119 = f.my_piecewise3(t87, 0, t5 * t114 * t115 / 0.4e1)
  t120 = jnp.sqrt(t29)
  t122 = jnp.exp(-0.54466942400000000000000000000000000000000000000000e0 * t120)
  t124 = t25 ** 2
  t125 = t124 * t25
  t128 = jnp.exp(-0.16390970575000000000000000000000000000000000000000e0 * t125 * t31)
  t130 = 0.1247511874e1 - 0.859614445e0 * t122 + 0.812904345e0 * t128
  t131 = t130 ** 2
  t132 = 0.56633563016285904187500000000000000000000000000000e-1 * t60
  t133 = 0.1e1 + t132
  t134 = t133 ** 2
  t135 = t131 * t134
  t136 = jnp.exp(-t132)
  t137 = t136 ** 2
  t139 = 0.1e1 + 0.50008500819444444444444444444444444444444444444444e-1 * t74
  t141 = t137 / t139
  t142 = t135 * t141
  t143 = 0.1e-59 < t142
  t144 = f.my_piecewise3(t143, t142, 0.1e-59)
  t145 = 0.1e1 / t144
  t146 = t24 * t145
  t148 = t10 * t16 * t146
  t149 = t148 / 0.6e1
  t150 = 0.10e8 <= t149
  t151 = xc_E1_scaled(t149)
  t152 = t23 * t145
  t155 = jnp.sqrt(t94 * t27 * t152)
  t156 = t91 * t155
  t159 = 0.3e1 + t156 / 0.3e1 + t148 / 0.3e1
  t161 = 0.3e1 + t156 + t148
  t162 = 0.1e1 / t161
  t163 = t145 * t159 * t162
  t167 = 0.1e1 + t89 * t28 * t163 / 0.3e1
  t169 = t159 * t162
  t171 = -t151 * t167 + 0.2e1 * t169
  t172 = t41 * t11
  t173 = t14 ** 2
  t174 = 0.1e1 / t173
  t175 = t174 * t70
  t176 = t23 ** 2
  t179 = 0.46950800000000000000000000000000000000000000000000e0 * t120 + 0.43329250000000000000000000000000000000000000000000e0 * t29
  t180 = t179 ** 2
  t181 = 0.1e1 / t180
  t182 = t176 * t181
  t186 = jnp.exp(-t172 * t175 * t182 / 0.4e1)
  t187 = t171 * t186
  t191 = f.my_piecewise3(t150, 0, t5 * t187 * t21 / 0.4e1)
  t192 = 0.1e1 / t115
  t193 = t192 ** (0.1e1 / 0.3e1)
  t194 = t17 * t193
  t195 = t27 * t193
  t196 = t26 * t195
  t197 = t196 ** (0.1e1 / 0.5e1)
  t198 = t197 ** 2
  t199 = t198 ** 2
  t202 = jnp.exp(-0.20818970000000000000000000000000000000000000000000e-1 * t25 * t199)
  t204 = 0.942486901e0 + 0.349064173e0 * t202
  t205 = t204 ** 2
  t206 = t11 * s2
  t207 = r1 ** 2
  t208 = r1 ** (0.1e1 / 0.3e1)
  t209 = t208 ** 2
  t211 = 0.1e1 / t209 / t207
  t215 = s2 ** 2
  t216 = t12 * t215
  t217 = t207 ** 2
  t220 = 0.1e1 / t208 / t217 / r1
  t222 = t52 * t216 * t220
  t223 = 0.55569193573523559259259259259259259259259259259259e-3 * t222
  t224 = 0.1e1 + 0.45058854638888888888888888888888888888888888888889e-1 * t41 * t206 * t211 + t223
  t225 = t224 ** 2
  t226 = t205 * t225
  t227 = jnp.exp(-t223)
  t228 = t227 ** 2
  t229 = t12 * s2
  t230 = t9 * t229
  t232 = 0.1e1 / t193
  t233 = t70 * t232
  t235 = t230 * t211 * t14 * t233
  t237 = 0.1e1 + 0.19153082513888888888888888888888888888888888888889e-1 * t235
  t239 = t228 / t237
  t240 = t226 * t239
  t241 = 0.1e-59 < t240
  t242 = f.my_piecewise3(t241, t240, 0.1e-59)
  t243 = 0.1e1 / t242
  t244 = t194 * t243
  t246 = t10 * t16 * t244
  t247 = t246 / 0.6e1
  t248 = 0.10e8 <= t247
  t249 = xc_E1_scaled(t247)
  t250 = t193 * t243
  t253 = jnp.sqrt(t94 * t27 * t250)
  t254 = t91 * t253
  t257 = 0.3e1 + t254 / 0.3e1 + t246 / 0.3e1
  t259 = 0.3e1 + t254 + t246
  t260 = 0.1e1 / t259
  t261 = t243 * t257 * t260
  t265 = 0.1e1 + t89 * t195 * t261 / 0.3e1
  t267 = t257 * t260
  t269 = -t249 * t265 + 0.2e1 * t267
  t273 = f.my_piecewise3(t248, 0, t5 * t269 * t21 / 0.4e1)
  t274 = jnp.sqrt(t196)
  t276 = jnp.exp(-0.54466942400000000000000000000000000000000000000000e0 * t274)
  t280 = jnp.exp(-0.16390970575000000000000000000000000000000000000000e0 * t125 * t198)
  t282 = 0.1247511874e1 - 0.859614445e0 * t276 + 0.812904345e0 * t280
  t283 = t282 ** 2
  t284 = 0.56633563016285904187500000000000000000000000000000e-1 * t222
  t285 = 0.1e1 + t284
  t286 = t285 ** 2
  t287 = t283 * t286
  t288 = jnp.exp(-t284)
  t289 = t288 ** 2
  t291 = 0.1e1 + 0.50008500819444444444444444444444444444444444444444e-1 * t235
  t293 = t289 / t291
  t294 = t287 * t293
  t295 = 0.1e-59 < t294
  t296 = f.my_piecewise3(t295, t294, 0.1e-59)
  t297 = 0.1e1 / t296
  t298 = t194 * t297
  t300 = t10 * t16 * t298
  t301 = t300 / 0.6e1
  t302 = 0.10e8 <= t301
  t303 = xc_E1_scaled(t301)
  t304 = t193 * t297
  t307 = jnp.sqrt(t94 * t27 * t304)
  t308 = t91 * t307
  t311 = 0.3e1 + t308 / 0.3e1 + t300 / 0.3e1
  t313 = 0.3e1 + t308 + t300
  t314 = 0.1e1 / t313
  t315 = t297 * t311 * t314
  t319 = 0.1e1 + t89 * t195 * t315 / 0.3e1
  t321 = t311 * t314
  t323 = -t303 * t319 + 0.2e1 * t321
  t324 = t193 ** 2
  t327 = 0.46950800000000000000000000000000000000000000000000e0 * t274 + 0.43329250000000000000000000000000000000000000000000e0 * t196
  t328 = t327 ** 2
  t329 = 0.1e1 / t328
  t330 = t324 * t329
  t334 = jnp.exp(-t172 * t175 * t330 / 0.4e1)
  t335 = t323 * t334
  t339 = f.my_piecewise3(t302, 0, t5 * t335 * t115 / 0.4e1)
  t344 = 0.1e1 / t2 * t3 * t39 / t8
  t345 = t11 * t14
  t350 = t88 - t344 * t345 * t72 * t81 / 0.4e1
  t352 = 0.1e1 / t14 / t13
  t353 = t12 * t352
  t355 = t10 * t353 * t83
  t356 = t355 / 0.18e2
  t357 = 0.1e1 / t176
  t358 = t27 * t357
  t359 = t21 ** 2
  t360 = 0.1e1 / t359
  t361 = t82 * t360
  t362 = t13 ** 2
  t364 = t18 / t362
  t365 = t19 - t364
  t366 = t361 * t365
  t368 = t89 * t358 * t366
  t370 = t81 ** 2
  t371 = 0.1e1 / t370
  t372 = t23 * t371
  t374 = t37 * t63 * t78
  t376 = t25 / t30
  t377 = t352 * t17
  t378 = t377 * t23
  t379 = t26 * t378
  t380 = t9 * t16
  t381 = t17 * t357
  t382 = t360 * t365
  t384 = t380 * t381 * t382
  t386 = -t379 / 0.3e1 - t384 / 0.3e1
  t391 = t38 * t62
  t394 = 0.1e1 / t45 / t43 / r0
  t402 = t52 * t54 / t44 / t55 / t43
  t410 = t76 ** 2
  t412 = t66 / t410
  t415 = t68 * t394 * t14 * t72
  t419 = t68 * t47 * t174 * t72
  t420 = 0.63843608379629629629629629629629629629629629629630e-2 * t419
  t422 = t9 * t67 * t47
  t423 = t14 * t70
  t426 = 0.1e1 / t23 / t22 * t360
  t429 = t422 * t423 * t426 * t365
  t435 = f.my_piecewise3(t80, -0.11627450473218896000000000000000000000000000000000e-1 * t374 * t376 * t386 * t35 + 0.2e1 * t391 * t78 * (-0.12015694570370370370370370370370370370370370370370e0 * t41 * t42 * t394 - 0.29636903239212564938271604938271604938271604938271e-2 * t402) + 0.59273806478425129876543209876543209876543209876542e-2 * t79 * t402 - t64 * t412 * (-0.51074886703703703703703703703703703703703703703704e-1 * t415 + t420 + 0.63843608379629629629629629629629629629629629629630e-2 * t429), 0)
  t437 = t27 * t372 * t435
  t438 = t89 * t437
  t445 = t89 * t378 * t106 / 0.9e1
  t447 = t93 * t15
  t448 = t5 * t6 * t447
  t449 = t381 * t82
  t454 = t24 * t371
  t459 = 0.1e1 / t98
  t462 = t94 * t377 * t95 / 0.3e1
  t463 = t92 * t447
  t470 = t91 * t459 * (-t462 - t463 * t381 * t366 / 0.3e1 - t94 * t437)
  t472 = t355 / 0.9e1
  t475 = t470 / 0.6e1 - t472 - t368 / 0.9e1 - t438 / 0.3e1
  t481 = t104 ** 2
  t483 = t102 / t481
  t485 = t355 / 0.3e1
  t488 = t483 * (t470 / 0.2e1 - t485 - t368 / 0.3e1 - t438)
  t500 = -t365
  t505 = f.my_piecewise3(t87, 0, t5 * (-t350 * (-t356 - t368 / 0.18e2 - t438 / 0.6e1) * t110 - t88 * (-t445 - t448 * t449 * t112 * t382 / 0.9e1 - t448 * t454 * t112 * t435 / 0.3e1 + t89 * t28 * t82 * t475 * t105 / 0.3e1 - t448 * t83 * t488 / 0.3e1) + 0.2e1 * t475 * t105 - 0.2e1 * t488) * t115 / 0.4e1 + t5 * t114 * t500 / 0.4e1)
  t510 = t151 - t344 * t345 * t72 * t144 / 0.4e1
  t512 = t10 * t353 * t146
  t513 = t512 / 0.18e2
  t514 = t145 * t360
  t515 = t514 * t365
  t517 = t89 * t358 * t515
  t519 = t144 ** 2
  t520 = 0.1e1 / t519
  t521 = t23 * t520
  t522 = t130 * t134
  t523 = 0.1e1 / t120
  t524 = t523 * t386
  t529 = t125 / t31 / t30
  t538 = t131 * t133 * t141
  t543 = t139 ** 2
  t545 = t137 / t543
  t547 = 0.16669500273148148148148148148148148148148148148148e-1 * t419
  t553 = f.my_piecewise3(t143, 0.2e1 * t522 * t141 * (0.23410285231011484000000000000000000000000000000000e0 * t524 * t122 - 0.53297164796738593500000000000000000000000000000000e-1 * t529 * t386 * t128) - 0.60409133884038297800000000000000000000000000000000e0 * t538 * t402 + 0.60409133884038297800000000000000000000000000000000e0 * t142 * t402 - t135 * t545 * (-0.13335600218518518518518518518518518518518518518518e0 * t415 + t547 + 0.16669500273148148148148148148148148148148148148148e-1 * t429), 0)
  t555 = t27 * t521 * t553
  t556 = t89 * t555
  t563 = t89 * t378 * t163 / 0.9e1
  t564 = t381 * t145
  t569 = t24 * t520
  t574 = 0.1e1 / t155
  t577 = t94 * t377 * t152 / 0.3e1
  t584 = t91 * t574 * (-t577 - t463 * t381 * t515 / 0.3e1 - t94 * t555)
  t586 = t512 / 0.9e1
  t589 = t584 / 0.6e1 - t586 - t517 / 0.9e1 - t556 / 0.3e1
  t595 = t161 ** 2
  t597 = t159 / t595
  t599 = t512 / 0.3e1
  t602 = t597 * (t584 / 0.2e1 - t599 - t517 / 0.3e1 - t556)
  t615 = t5 * t171
  t618 = 0.1e1 / t173 / t13 * t70
  t621 = t172 * t618 * t182 / 0.6e1
  t623 = t41 * t11 * t174
  t624 = t181 * t360
  t629 = t70 * t176
  t631 = 0.1e1 / t180 / t179
  t633 = 0.14443083333333333333333333333333333333333333333333e0 * t379
  t648 = f.my_piecewise3(t150, 0, t5 * (-t510 * (-t513 - t517 / 0.18e2 - t556 / 0.6e1) * t167 - t151 * (-t563 - t448 * t564 * t169 * t382 / 0.9e1 - t448 * t569 * t169 * t553 / 0.3e1 + t89 * t28 * t145 * t589 * t162 / 0.3e1 - t448 * t146 * t602 / 0.3e1) + 0.2e1 * t589 * t162 - 0.2e1 * t602) * t186 * t21 / 0.4e1 + t615 * (t621 + t623 * t72 * t624 * t365 / 0.6e1 + t623 * t629 * t631 * (0.23475400000000000000000000000000000000000000000000e0 * t524 - t633 - 0.14443083333333333333333333333333333333333333333333e0 * t384) / 0.2e1) * t186 * t21 / 0.4e1 + t5 * t187 * t365 / 0.4e1)
  t653 = t249 - t344 * t345 * t233 * t242 / 0.4e1
  t655 = t10 * t353 * t244
  t656 = t655 / 0.18e2
  t657 = 0.1e1 / t324
  t658 = t27 * t657
  t659 = t115 ** 2
  t660 = 0.1e1 / t659
  t661 = t243 * t660
  t662 = t661 * t500
  t664 = t89 * t658 * t662
  t666 = t242 ** 2
  t667 = 0.1e1 / t666
  t668 = t193 * t667
  t670 = t204 * t225 * t239
  t672 = t25 / t197
  t673 = t377 * t193
  t674 = t26 * t673
  t675 = t17 * t657
  t676 = t660 * t500
  t678 = t380 * t675 * t676
  t680 = -t674 / 0.3e1 - t678 / 0.3e1
  t685 = t237 ** 2
  t687 = t228 / t685
  t690 = t230 * t211 * t174 * t233
  t691 = 0.63843608379629629629629629629629629629629629629630e-2 * t690
  t693 = t9 * t229 * t211
  t696 = 0.1e1 / t193 / t192 * t660
  t699 = t693 * t423 * t696 * t500
  t705 = f.my_piecewise3(t241, -0.11627450473218896000000000000000000000000000000000e-1 * t670 * t672 * t680 * t202 - t226 * t687 * (t691 + 0.63843608379629629629629629629629629629629629629630e-2 * t699), 0)
  t707 = t27 * t668 * t705
  t708 = t89 * t707
  t715 = t89 * t673 * t261 / 0.9e1
  t716 = t675 * t243
  t721 = t194 * t667
  t726 = 0.1e1 / t253
  t729 = t94 * t377 * t250 / 0.3e1
  t736 = t91 * t726 * (-t729 - t463 * t675 * t662 / 0.3e1 - t94 * t707)
  t738 = t655 / 0.9e1
  t741 = t736 / 0.6e1 - t738 - t664 / 0.9e1 - t708 / 0.3e1
  t747 = t259 ** 2
  t749 = t257 / t747
  t751 = t655 / 0.3e1
  t754 = t749 * (t736 / 0.2e1 - t751 - t664 / 0.3e1 - t708)
  t770 = f.my_piecewise3(t248, 0, t5 * (-t653 * (-t656 - t664 / 0.18e2 - t708 / 0.6e1) * t265 - t249 * (-t715 - t448 * t716 * t267 * t676 / 0.9e1 - t448 * t721 * t267 * t705 / 0.3e1 + t89 * t195 * t243 * t741 * t260 / 0.3e1 - t448 * t244 * t754 / 0.3e1) + 0.2e1 * t741 * t260 - 0.2e1 * t754) * t21 / 0.4e1 + t5 * t269 * t365 / 0.4e1)
  t775 = t303 - t344 * t345 * t233 * t296 / 0.4e1
  t777 = t10 * t353 * t298
  t778 = t777 / 0.18e2
  t779 = t297 * t660
  t780 = t779 * t500
  t782 = t89 * t658 * t780
  t784 = t296 ** 2
  t785 = 0.1e1 / t784
  t786 = t193 * t785
  t787 = t282 * t286
  t788 = 0.1e1 / t274
  t789 = t788 * t680
  t794 = t125 / t198 / t197
  t802 = t291 ** 2
  t804 = t289 / t802
  t805 = 0.16669500273148148148148148148148148148148148148148e-1 * t690
  t811 = f.my_piecewise3(t295, 0.2e1 * t787 * t293 * (0.23410285231011484000000000000000000000000000000000e0 * t789 * t276 - 0.53297164796738593500000000000000000000000000000000e-1 * t794 * t680 * t280) - t287 * t804 * (t805 + 0.16669500273148148148148148148148148148148148148148e-1 * t699), 0)
  t813 = t27 * t786 * t811
  t814 = t89 * t813
  t821 = t89 * t673 * t315 / 0.9e1
  t822 = t675 * t297
  t827 = t194 * t785
  t832 = 0.1e1 / t307
  t835 = t94 * t377 * t304 / 0.3e1
  t842 = t91 * t832 * (-t835 - t463 * t675 * t780 / 0.3e1 - t94 * t813)
  t844 = t777 / 0.9e1
  t847 = t842 / 0.6e1 - t844 - t782 / 0.9e1 - t814 / 0.3e1
  t853 = t313 ** 2
  t855 = t311 / t853
  t857 = t777 / 0.3e1
  t860 = t855 * (t842 / 0.2e1 - t857 - t782 / 0.3e1 - t814)
  t873 = t5 * t323
  t876 = t172 * t618 * t330 / 0.6e1
  t877 = t329 * t660
  t882 = t70 * t324
  t884 = 0.1e1 / t328 / t327
  t886 = 0.14443083333333333333333333333333333333333333333333e0 * t674
  t901 = f.my_piecewise3(t302, 0, t5 * (-t775 * (-t778 - t782 / 0.18e2 - t814 / 0.6e1) * t319 - t303 * (-t821 - t448 * t822 * t321 * t676 / 0.9e1 - t448 * t827 * t321 * t811 / 0.3e1 + t89 * t195 * t297 * t847 * t314 / 0.3e1 - t448 * t298 * t860 / 0.3e1) + 0.2e1 * t847 * t314 - 0.2e1 * t860) * t334 * t115 / 0.4e1 + t873 * (t876 + t623 * t233 * t877 * t500 / 0.6e1 + t623 * t882 * t884 * (0.23475400000000000000000000000000000000000000000000e0 * t789 - t886 - 0.14443083333333333333333333333333333333333333333333e0 * t678) / 0.2e1) * t334 * t115 / 0.4e1 + t5 * t335 * t500 / 0.4e1)
  vrho_0_ = t119 + t191 + t273 + t339 + t13 * (t505 + t648 + t770 + t901)
  t904 = -t19 - t364
  t905 = t361 * t904
  t907 = t89 * t358 * t905
  t909 = t360 * t904
  t911 = t380 * t381 * t909
  t913 = -t379 / 0.3e1 - t911 / 0.3e1
  t920 = t422 * t423 * t426 * t904
  t926 = f.my_piecewise3(t80, -0.11627450473218896000000000000000000000000000000000e-1 * t374 * t376 * t913 * t35 - t64 * t412 * (t420 + 0.63843608379629629629629629629629629629629629629630e-2 * t920), 0)
  t928 = t27 * t372 * t926
  t929 = t89 * t928
  t948 = t91 * t459 * (-t462 - t463 * t381 * t905 / 0.3e1 - t94 * t928)
  t952 = t948 / 0.6e1 - t472 - t907 / 0.9e1 - t929 / 0.3e1
  t961 = t483 * (t948 / 0.2e1 - t485 - t907 / 0.3e1 - t929)
  t973 = -t904
  t978 = f.my_piecewise3(t87, 0, t5 * (-t350 * (-t356 - t907 / 0.18e2 - t929 / 0.6e1) * t110 - t88 * (-t445 - t448 * t449 * t112 * t909 / 0.9e1 - t448 * t454 * t112 * t926 / 0.3e1 + t89 * t28 * t82 * t952 * t105 / 0.3e1 - t448 * t83 * t961 / 0.3e1) + 0.2e1 * t952 * t105 - 0.2e1 * t961) * t115 / 0.4e1 + t5 * t114 * t973 / 0.4e1)
  t979 = t514 * t904
  t981 = t89 * t358 * t979
  t983 = t523 * t913
  t998 = f.my_piecewise3(t143, 0.2e1 * t522 * t141 * (0.23410285231011484000000000000000000000000000000000e0 * t983 * t122 - 0.53297164796738593500000000000000000000000000000000e-1 * t529 * t913 * t128) - t135 * t545 * (t547 + 0.16669500273148148148148148148148148148148148148148e-1 * t920), 0)
  t1000 = t27 * t521 * t998
  t1001 = t89 * t1000
  t1020 = t91 * t574 * (-t577 - t463 * t381 * t979 / 0.3e1 - t94 * t1000)
  t1024 = t1020 / 0.6e1 - t586 - t981 / 0.9e1 - t1001 / 0.3e1
  t1033 = t597 * (t1020 / 0.2e1 - t599 - t981 / 0.3e1 - t1001)
  t1065 = f.my_piecewise3(t150, 0, t5 * (-t510 * (-t513 - t981 / 0.18e2 - t1001 / 0.6e1) * t167 - t151 * (-t563 - t448 * t564 * t169 * t909 / 0.9e1 - t448 * t569 * t169 * t998 / 0.3e1 + t89 * t28 * t145 * t1024 * t162 / 0.3e1 - t448 * t146 * t1033 / 0.3e1) + 0.2e1 * t1024 * t162 - 0.2e1 * t1033) * t186 * t21 / 0.4e1 + t615 * (t621 + t623 * t72 * t624 * t904 / 0.6e1 + t623 * t629 * t631 * (0.23475400000000000000000000000000000000000000000000e0 * t983 - t633 - 0.14443083333333333333333333333333333333333333333333e0 * t911) / 0.2e1) * t186 * t21 / 0.4e1 + t5 * t187 * t904 / 0.4e1)
  t1066 = t661 * t973
  t1068 = t89 * t658 * t1066
  t1070 = t660 * t973
  t1072 = t380 * t675 * t1070
  t1074 = -t674 / 0.3e1 - t1072 / 0.3e1
  t1079 = t205 * t224
  t1082 = 0.1e1 / t209 / t207 / r1
  t1090 = t52 * t216 / t208 / t217 / t207
  t1100 = t230 * t1082 * t14 * t233
  t1104 = t693 * t423 * t696 * t973
  t1110 = f.my_piecewise3(t241, -0.11627450473218896000000000000000000000000000000000e-1 * t670 * t672 * t1074 * t202 + 0.2e1 * t1079 * t239 * (-0.12015694570370370370370370370370370370370370370370e0 * t41 * t206 * t1082 - 0.29636903239212564938271604938271604938271604938271e-2 * t1090) + 0.59273806478425129876543209876543209876543209876542e-2 * t240 * t1090 - t226 * t687 * (-0.51074886703703703703703703703703703703703703703704e-1 * t1100 + t691 + 0.63843608379629629629629629629629629629629629629630e-2 * t1104), 0)
  t1112 = t27 * t668 * t1110
  t1113 = t89 * t1112
  t1132 = t91 * t726 * (-t729 - t463 * t675 * t1066 / 0.3e1 - t94 * t1112)
  t1136 = t1132 / 0.6e1 - t738 - t1068 / 0.9e1 - t1113 / 0.3e1
  t1145 = t749 * (t1132 / 0.2e1 - t751 - t1068 / 0.3e1 - t1113)
  t1161 = f.my_piecewise3(t248, 0, t5 * (-t653 * (-t656 - t1068 / 0.18e2 - t1113 / 0.6e1) * t265 - t249 * (-t715 - t448 * t716 * t267 * t1070 / 0.9e1 - t448 * t721 * t267 * t1110 / 0.3e1 + t89 * t195 * t243 * t1136 * t260 / 0.3e1 - t448 * t244 * t1145 / 0.3e1) + 0.2e1 * t1136 * t260 - 0.2e1 * t1145) * t21 / 0.4e1 + t5 * t269 * t904 / 0.4e1)
  t1162 = t779 * t973
  t1164 = t89 * t658 * t1162
  t1166 = t788 * t1074
  t1177 = t283 * t285 * t293
  t1188 = f.my_piecewise3(t295, 0.2e1 * t787 * t293 * (0.23410285231011484000000000000000000000000000000000e0 * t1166 * t276 - 0.53297164796738593500000000000000000000000000000000e-1 * t794 * t1074 * t280) - 0.60409133884038297800000000000000000000000000000000e0 * t1177 * t1090 + 0.60409133884038297800000000000000000000000000000000e0 * t294 * t1090 - t287 * t804 * (-0.13335600218518518518518518518518518518518518518518e0 * t1100 + t805 + 0.16669500273148148148148148148148148148148148148148e-1 * t1104), 0)
  t1190 = t27 * t786 * t1188
  t1191 = t89 * t1190
  t1210 = t91 * t832 * (-t835 - t463 * t675 * t1162 / 0.3e1 - t94 * t1190)
  t1214 = t1210 / 0.6e1 - t844 - t1164 / 0.9e1 - t1191 / 0.3e1
  t1223 = t855 * (t1210 / 0.2e1 - t857 - t1164 / 0.3e1 - t1191)
  t1255 = f.my_piecewise3(t302, 0, t5 * (-t775 * (-t778 - t1164 / 0.18e2 - t1191 / 0.6e1) * t319 - t303 * (-t821 - t448 * t822 * t321 * t1070 / 0.9e1 - t448 * t827 * t321 * t1188 / 0.3e1 + t89 * t195 * t297 * t1214 * t314 / 0.3e1 - t448 * t298 * t1223 / 0.3e1) + 0.2e1 * t1214 * t314 - 0.2e1 * t1223) * t334 * t115 / 0.4e1 + t873 * (t876 + t623 * t233 * t877 * t973 / 0.6e1 + t623 * t882 * t884 * (0.23475400000000000000000000000000000000000000000000e0 * t1166 - t886 - 0.14443083333333333333333333333333333333333333333333e0 * t1072) / 0.2e1) * t334 * t115 / 0.4e1 + t5 * t335 * t973 / 0.4e1)
  vrho_1_ = t119 + t191 + t273 + t339 + t13 * (t978 + t1065 + t1161 + t1255)
  t1265 = t52 * t67 * t58
  t1277 = t93 * t47 * t423 * t71
  t1281 = f.my_piecewise3(t80, 0.2e1 * t391 * t78 * (0.45058854638888888888888888888888888888888888888889e-1 * t41 * t11 * t47 + 0.11113838714704711851851851851851851851851851851852e-2 * t1265) - 0.22227677429409423703703703703703703703703703703704e-2 * t79 * t1265 - 0.19153082513888888888888888888888888888888888888889e-1 * t64 * t412 * t6 * t1277, 0)
  t1291 = t92 * t8
  t1293 = t16 * t17
  t1294 = t372 * t1281
  t1296 = t91 * t459 * t1291 * t1293 * t1294
  t1299 = t89 * t27 * t1294
  t1301 = -t1296 / 0.6e1 - t1299 / 0.3e1
  t1308 = t483 * (-t1296 / 0.2e1 - t1299)
  t1321 = f.my_piecewise3(t87, 0, t5 * (t350 * t2 * t4 * t26 * t28 * t371 * t1281 * t110 / 0.6e1 - t88 * (t89 * t28 * t82 * t1301 * t105 / 0.3e1 - t448 * t454 * t112 * t1281 / 0.3e1 - t448 * t83 * t1308 / 0.3e1) + 0.2e1 * t1301 * t105 - 0.2e1 * t1308) * t115 / 0.4e1)
  t1334 = f.my_piecewise3(t143, 0.22653425206514361675000000000000000000000000000000e0 * t538 * t1265 - 0.22653425206514361675000000000000000000000000000000e0 * t142 * t1265 - 0.50008500819444444444444444444444444444444444444444e-1 * t135 * t545 * t6 * t1277, 0)
  t1345 = t521 * t1334
  t1347 = t91 * t574 * t1291 * t1293 * t1345
  t1350 = t89 * t27 * t1345
  t1352 = -t1347 / 0.6e1 - t1350 / 0.3e1
  t1359 = t597 * (-t1347 / 0.2e1 - t1350)
  t1373 = f.my_piecewise3(t150, 0, t5 * (t510 * t2 * t4 * t26 * t28 * t520 * t1334 * t167 / 0.6e1 - t151 * (t89 * t28 * t145 * t1352 * t162 / 0.3e1 - t448 * t569 * t169 * t1334 / 0.3e1 - t448 * t146 * t1359 / 0.3e1) + 0.2e1 * t1352 * t162 - 0.2e1 * t1359) * t186 * t21 / 0.4e1)
  vsigma_0_ = t13 * (t1321 + t1373)
  vsigma_1_ = 0.0e0
  t1382 = t52 * t229 * t220
  t1394 = t93 * t211 * t423 * t232
  t1398 = f.my_piecewise3(t241, 0.2e1 * t1079 * t239 * (0.45058854638888888888888888888888888888888888888889e-1 * t41 * t11 * t211 + 0.11113838714704711851851851851851851851851851851852e-2 * t1382) - 0.22227677429409423703703703703703703703703703703704e-2 * t240 * t1382 - 0.19153082513888888888888888888888888888888888888889e-1 * t226 * t687 * t6 * t1394, 0)
  t1409 = t668 * t1398
  t1411 = t91 * t726 * t1291 * t1293 * t1409
  t1414 = t89 * t27 * t1409
  t1416 = -t1411 / 0.6e1 - t1414 / 0.3e1
  t1423 = t749 * (-t1411 / 0.2e1 - t1414)
  t1436 = f.my_piecewise3(t248, 0, t5 * (t653 * t2 * t4 * t26 * t195 * t667 * t1398 * t265 / 0.6e1 - t249 * (t89 * t195 * t243 * t1416 * t260 / 0.3e1 - t448 * t721 * t267 * t1398 / 0.3e1 - t448 * t244 * t1423 / 0.3e1) + 0.2e1 * t1416 * t260 - 0.2e1 * t1423) * t21 / 0.4e1)
  t1449 = f.my_piecewise3(t295, 0.22653425206514361675000000000000000000000000000000e0 * t1177 * t1382 - 0.22653425206514361675000000000000000000000000000000e0 * t294 * t1382 - 0.50008500819444444444444444444444444444444444444444e-1 * t287 * t804 * t6 * t1394, 0)
  t1460 = t786 * t1449
  t1462 = t91 * t832 * t1291 * t1293 * t1460
  t1465 = t89 * t27 * t1460
  t1467 = -t1462 / 0.6e1 - t1465 / 0.3e1
  t1474 = t855 * (-t1462 / 0.2e1 - t1465)
  t1488 = f.my_piecewise3(t302, 0, t5 * (t775 * t2 * t4 * t26 * t195 * t785 * t1449 * t319 / 0.6e1 - t303 * (t89 * t195 * t297 * t1467 * t314 / 0.3e1 - t448 * t827 * t321 * t1449 / 0.3e1 - t448 * t298 * t1474 / 0.3e1) + 0.2e1 * t1467 * t314 - 0.2e1 * t1474) * t334 * t115 / 0.4e1)
  vsigma_2_ = t13 * (t1436 + t1488)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  C0 = (1 - jnp.log(2)) / (2 * jnp.pi ** 2)

  C2 = f.RS_FACTOR

  cutoff = 10000000.0

  kssp0_k0 = 1.291551074

  kssp0_k1 = 0.349064173

  kssp0_r1 = 0.08327588

  fssp_A1 = 1.622118767

  fssp_A2 = 0.489958076

  fssp_A3 = 1.379021941

  fa_a1 = 0.939016

  fa_a2 = 1.73317

  kss0_k0 = 1.200801774

  kss0_k1 = 0.859614445

  kss0_k2 = -0.812904345

  kss0_r1 = 1.089338848

  kss0_r2 = 0.655638823

  fss_A4 = 4.946281353

  fss_A5 = 3.600612059

  eq15 = lambda mu: (3 + 2 * (jnp.sqrt(mu) + mu)) / (3 + 6 * (jnp.sqrt(mu) + mu))

  C1 = 4 * C0 / 3

  C3 = C2 / 3

  kssp0 = lambda rs: kssp0_k0 - kssp0_k1 * (1 - jnp.exp(-kssp0_r1 * rs ** (4 / 5)))

  fssp = lambda rs, gr: (1 + fssp_A1 * gr + fssp_A2 ** 2 * gr ** 2) * jnp.exp(-fssp_A2 ** 2 * gr ** 2) / jnp.sqrt(1 + fssp_A3 * gr / rs)

  f_factor = lambda rs: jnp.exp(-rs ** 2 / (fa_a1 * jnp.sqrt(rs) + fa_a2 * rs) ** 2)

  kss0 = lambda rs, gr=None: +kss0_k0 + kss0_k1 * (1 - jnp.exp(-kss0_r1 * jnp.sqrt(rs))) + kss0_k2 * (1 - jnp.exp(-kss0_r2 * rs ** (2 / 5)))

  fss = lambda rs, gr: (1 + fss_A4 ** 2 * gr ** 2) * jnp.exp(-fss_A4 ** 2 * gr ** 2) / jnp.sqrt(1 + fss_A5 * gr / rs)

  f_eab = lambda mu: C0 * (-xc_E1_scaled(mu) * (1 + 2 * mu * eq15(mu)) + 2 * eq15(mu))

  mu_ba = lambda rsa, ga2: C1 * rsa / jnp.maximum(kssp0(rsa) ** 2 * fssp(rsa, ga2) ** 2, 1e-60)

  mu_aa = lambda rsa, ga2: C1 * rsa / jnp.maximum(kss0(rsa) ** 2 * fss(rsa, ga2) ** 2, 1e-60)

  term1 = lambda rsa, z, ga2: f.my_piecewise3(mu_ba(rsa, ga2) >= cutoff, 0, f_eab(mu_ba(rsa, ga2)) * (1 - z) / 2)

  term2 = lambda rsa, z, ga2: f.my_piecewise3(mu_aa(rsa, ga2) >= cutoff, 0, f_eab(mu_aa(rsa, ga2)) * f_factor(rsa) * (1 + z) / 2)

  f_ft97 = lambda rs, z, xs: +term1(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2) + term2(rs * (2 / (1 + z)) ** (1 / 3), z, C3 ** 2 * xs ** 2)

  functional_body = lambda rs, z, xt, xs0, xs1: f_ft97(rs, z, xs0) + f_ft97(rs, -z, xs1)

  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / jnp.pi
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = t5 * t9
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t13
  t15 = t12 * t14
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = 4 ** (0.1e1 / 0.5e1)
  t18 = t15 * t16
  t19 = t9 * t18
  t20 = t19 ** (0.1e1 / 0.5e1)
  t21 = t20 ** 2
  t22 = t21 ** 2
  t25 = jnp.exp(-0.20818970000000000000000000000000000000000000000000e-1 * t17 * t22)
  t27 = 0.942486901e0 + 0.349064173e0 * t25
  t28 = t27 ** 2
  t29 = t6 ** 2
  t30 = t8 ** 2
  t31 = t29 * t30
  t32 = t31 * t11
  t33 = t16 ** 2
  t34 = s0 * t33
  t35 = r0 ** 2
  t36 = t13 ** 2
  t38 = 0.1e1 / t36 / t35
  t42 = t8 * t7
  t44 = t6 * t42 * t12
  t45 = s0 ** 2
  t46 = t45 * t16
  t47 = t35 ** 2
  t50 = 0.1e1 / t13 / t47 / r0
  t52 = t44 * t46 * t50
  t53 = 0.11113838714704711851851851851851851851851851851852e-2 * t52
  t54 = 0.1e1 + 0.45058854638888888888888888888888888888888888888889e-1 * t32 * t34 * t38 + t53
  t55 = t54 ** 2
  t56 = t28 * t55
  t57 = jnp.exp(-t53)
  t58 = t57 ** 2
  t59 = t9 * t12
  t60 = s0 * t16
  t62 = 0.1e1 / t13 / t35
  t64 = t59 * t60 * t62
  t66 = 0.1e1 + 0.38306165027777777777777777777777777777777777777778e-1 * t64
  t68 = t58 / t66
  t69 = t56 * t68
  t70 = 0.1e-59 < t69
  t71 = f.my_piecewise3(t70, t69, 0.1e-59)
  t72 = 0.1e1 / t71
  t73 = t16 * t72
  t74 = t15 * t73
  t75 = t10 * t74
  t76 = t75 / 0.6e1
  t77 = 0.10e8 <= t76
  t78 = xc_E1_scaled(t76)
  t79 = t5 * t59
  t80 = t14 * t16
  t81 = jnp.sqrt(0.6e1)
  t82 = t81 * t7
  t83 = t2 * t6
  t84 = t83 * t8
  t86 = jnp.sqrt(t84 * t74)
  t87 = t82 * t86
  t90 = 0.3e1 + t87 / 0.3e1 + t75 / 0.3e1
  t92 = 0.3e1 + t87 + t75
  t93 = 0.1e1 / t92
  t94 = t72 * t90 * t93
  t98 = 0.1e1 + t79 * t80 * t94 / 0.3e1
  t100 = t90 * t93
  t105 = f.my_piecewise3(t77, 0, t5 * (-t78 * t98 + 0.2e1 * t100) / 0.4e1)
  t107 = jnp.sqrt(t19)
  t109 = jnp.exp(-0.54466942400000000000000000000000000000000000000000e0 * t107)
  t111 = t17 ** 2
  t115 = jnp.exp(-0.16390970575000000000000000000000000000000000000000e0 * t111 * t17 * t21)
  t117 = 0.1247511874e1 - 0.859614445e0 * t109 + 0.812904345e0 * t115
  t118 = t117 ** 2
  t119 = 0.11326712603257180837500000000000000000000000000000e0 * t52
  t120 = 0.1e1 + t119
  t121 = t120 ** 2
  t122 = t118 * t121
  t123 = jnp.exp(-t119)
  t124 = t123 ** 2
  t126 = 0.1e1 + 0.10001700163888888888888888888888888888888888888889e0 * t64
  t128 = t124 / t126
  t129 = t122 * t128
  t130 = 0.1e-59 < t129
  t131 = f.my_piecewise3(t130, t129, 0.1e-59)
  t132 = 0.1e1 / t131
  t133 = t16 * t132
  t134 = t15 * t133
  t135 = t10 * t134
  t136 = t135 / 0.6e1
  t137 = 0.10e8 <= t136
  t138 = xc_E1_scaled(t136)
  t140 = jnp.sqrt(t84 * t134)
  t141 = t82 * t140
  t144 = 0.3e1 + t141 / 0.3e1 + t135 / 0.3e1
  t146 = 0.3e1 + t141 + t135
  t147 = 0.1e1 / t146
  t148 = t132 * t144 * t147
  t152 = 0.1e1 + t79 * t80 * t148 / 0.3e1
  t154 = t144 * t147
  t156 = -t138 * t152 + 0.2e1 * t154
  t158 = 0.1e1 / t36 * t33
  t161 = 0.46950800000000000000000000000000000000000000000000e0 * t107 + 0.43329250000000000000000000000000000000000000000000e0 * t19
  t162 = t161 ** 2
  t163 = 0.1e1 / t162
  t167 = jnp.exp(-t32 * t158 * t163 / 0.4e1)
  t171 = f.my_piecewise3(t137, 0, t5 * t156 * t167 / 0.4e1)
  t177 = 0.1e1 / t2 * t3 * t29 / t8
  t178 = t11 * t13
  t183 = t78 - t177 * t178 * t33 * t71 / 0.4e1
  t185 = 0.1e1 / t13 / r0
  t186 = t12 * t185
  t187 = t186 * t73
  t188 = t10 * t187
  t190 = t71 ** 2
  t191 = 0.1e1 / t190
  t192 = t16 * t191
  t194 = 4 ** (0.1e1 / 0.15e2)
  t195 = t194 ** 2
  t196 = t195 ** 2
  t198 = t196 ** 2
  t205 = t185 * t16
  t210 = t28 * t54
  t211 = t35 * r0
  t220 = t46 / t13 / t47 / t35
  t228 = t56 * t68 * t6
  t229 = t42 * t12
  t230 = t229 * t220
  t233 = t66 ** 2
  t235 = t58 / t233
  t238 = t8 * t12
  t242 = t238 * t60 / t13 / t211
  t246 = f.my_piecewise3(t70, 0.38758168244062986666666666666666666666666666666666e-2 * t27 * t55 * t68 * t198 * t196 * t194 / t20 * t6 * t8 * t205 * t25 + 0.2e1 * t210 * t68 * (-0.12015694570370370370370370370370370370370370370370e0 * t32 * t34 / t36 / t211 - 0.59273806478425129876543209876543209876543209876544e-2 * t44 * t220) + 0.11854761295685025975308641975308641975308641975309e-1 * t228 * t230 + 0.89381051731481481481481481481481481481481481481482e-1 * t56 * t235 * t6 * t242, 0)
  t249 = t10 * t15 * t192 * t246
  t257 = t80 * t191
  t262 = 0.1e1 / t86
  t265 = t83 * t238
  t271 = t82 * t262 * (-t84 * t187 / 0.3e1 - t265 * t80 * t191 * t246)
  t275 = t271 / 0.6e1 - t188 / 0.9e1 - t249 / 0.3e1
  t281 = t80 * t72
  t282 = t92 ** 2
  t284 = t90 / t282
  t288 = t284 * (t271 / 0.2e1 - t188 / 0.3e1 - t249)
  t300 = f.my_piecewise3(t77, 0, t5 * (-t183 * (-t188 / 0.18e2 - t249 / 0.6e1) * t98 - t78 * (-t79 * t205 * t94 / 0.9e1 - t79 * t257 * t100 * t246 / 0.3e1 + t79 * t80 * t72 * t275 * t93 / 0.3e1 - t79 * t281 * t288 / 0.3e1) + 0.2e1 * t275 * t93 - 0.2e1 * t288) / 0.4e1)
  t305 = t138 - t177 * t178 * t33 * t131 / 0.4e1
  t306 = t186 * t133
  t307 = t10 * t306
  t309 = t131 ** 2
  t310 = 0.1e1 / t309
  t311 = t16 * t310
  t315 = 0.1e1 / t107 * t6 * t8
  t334 = t128 * t6
  t335 = t118 * t120 * t334
  t338 = t122 * t334
  t341 = t126 ** 2
  t343 = t124 / t341
  t349 = f.my_piecewise3(t130, 0.2e1 * t117 * t121 * t128 * (-0.78034284103371613333333333333333333333333333333334e-1 * t315 * t186 * t16 * t109 + 0.71062886395651458000000000000000000000000000000000e-1 * t196 / t21 / t20 * t6 * t8 * t185 * t16 * t115) - 0.12081826776807659560000000000000000000000000000000e1 * t335 * t230 + 0.12081826776807659560000000000000000000000000000000e1 * t338 * t230 + 0.23337300382407407407407407407407407407407407407408e0 * t122 * t343 * t6 * t242, 0)
  t352 = t10 * t15 * t311 * t349
  t360 = t80 * t310
  t365 = 0.1e1 / t140
  t373 = t82 * t365 * (-t84 * t306 / 0.3e1 - t265 * t80 * t310 * t349)
  t377 = t373 / 0.6e1 - t307 / 0.9e1 - t352 / 0.3e1
  t383 = t80 * t132
  t384 = t146 ** 2
  t386 = t144 / t384
  t390 = t386 * (t373 / 0.2e1 - t307 / 0.3e1 - t352)
  t410 = t186 * t16
  t426 = f.my_piecewise3(t137, 0, t5 * (-t305 * (-t307 / 0.18e2 - t352 / 0.6e1) * t152 - t138 * (-t79 * t205 * t148 / 0.9e1 - t79 * t360 * t154 * t349 / 0.3e1 + t79 * t80 * t132 * t377 * t147 / 0.3e1 - t79 * t383 * t390 / 0.3e1) + 0.2e1 * t377 * t147 - 0.2e1 * t390) * t167 / 0.4e1 + t5 * t156 * (t32 / t36 / r0 * t33 * t163 / 0.6e1 + t32 * t158 / t162 / t161 * (-0.78251333333333333333333333333333333333333333333333e-1 * t315 * t410 - 0.14443083333333333333333333333333333333333333333333e0 * t9 * t410) / 0.2e1) * t167 / 0.4e1)
  vrho_0_ = 0.2e1 * t105 + 0.2e1 * t171 + r0 * (0.2e1 * t300 + 0.2e1 * t426)
  t432 = t4 * t6 * t8
  t438 = t60 * t50
  t445 = t229 * t438
  t451 = t9 * t12 * t16 * t62
  t455 = f.my_piecewise3(t70, 0.2e1 * t210 * t68 * (0.45058854638888888888888888888888888888888888888889e-1 * t31 * t11 * t33 * t38 + 0.22227677429409423703703703703703703703703703703704e-2 * t44 * t438) - 0.44455354858818847407407407407407407407407407407408e-2 * t228 * t445 - 0.38306165027777777777777777777777777777777777777778e-1 * t56 * t235 * t451, 0)
  t467 = t238 * t14
  t468 = t192 * t455
  t470 = t82 * t262 * t2 * t6 * t467 * t468
  t473 = t10 * t15 * t468
  t475 = -t470 / 0.6e1 - t473 / 0.3e1
  t482 = t284 * (-t470 / 0.2e1 - t473)
  t494 = f.my_piecewise3(t77, 0, t5 * (t183 * t2 * t432 * t18 * t191 * t455 * t98 / 0.6e1 - t78 * (t79 * t80 * t72 * t475 * t93 / 0.3e1 - t79 * t257 * t100 * t455 / 0.3e1 - t79 * t281 * t482 / 0.3e1) + 0.2e1 * t475 * t93 - 0.2e1 * t482) / 0.4e1)
  t505 = f.my_piecewise3(t130, 0.45306850413028723350000000000000000000000000000000e0 * t335 * t445 - 0.45306850413028723350000000000000000000000000000000e0 * t338 * t445 - 0.10001700163888888888888888888888888888888888888889e0 * t122 * t343 * t451, 0)
  t517 = t311 * t505
  t519 = t82 * t365 * t2 * t6 * t467 * t517
  t522 = t10 * t15 * t517
  t524 = -t519 / 0.6e1 - t522 / 0.3e1
  t531 = t386 * (-t519 / 0.2e1 - t522)
  t544 = f.my_piecewise3(t137, 0, t5 * (t305 * t2 * t432 * t18 * t310 * t505 * t152 / 0.6e1 - t138 * (t79 * t80 * t132 * t524 * t147 / 0.3e1 - t79 * t360 * t154 * t505 / 0.3e1 - t79 * t383 * t531 / 0.3e1) + 0.2e1 * t524 * t147 - 0.2e1 * t531) * t167 / 0.4e1)
  vsigma_0_ = r0 * (0.2e1 * t494 + 0.2e1 * t544)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / jnp.pi
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = t5 * t9
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t13
  t15 = t12 * t14
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = 4 ** (0.1e1 / 0.5e1)
  t18 = t15 * t16
  t19 = t9 * t18
  t20 = t19 ** (0.1e1 / 0.5e1)
  t21 = t20 ** 2
  t22 = t21 ** 2
  t25 = jnp.exp(-0.20818970000000000000000000000000000000000000000000e-1 * t17 * t22)
  t27 = 0.942486901e0 + 0.349064173e0 * t25
  t28 = t27 ** 2
  t29 = t6 ** 2
  t30 = t8 ** 2
  t31 = t29 * t30
  t32 = t31 * t11
  t33 = t16 ** 2
  t34 = s0 * t33
  t35 = r0 ** 2
  t36 = t13 ** 2
  t38 = 0.1e1 / t36 / t35
  t42 = t8 * t7
  t43 = t6 * t42
  t44 = t43 * t12
  t45 = s0 ** 2
  t46 = t45 * t16
  t47 = t35 ** 2
  t48 = t47 * r0
  t50 = 0.1e1 / t13 / t48
  t52 = t44 * t46 * t50
  t53 = 0.11113838714704711851851851851851851851851851851852e-2 * t52
  t54 = 0.1e1 + 0.45058854638888888888888888888888888888888888888889e-1 * t32 * t34 * t38 + t53
  t55 = t54 ** 2
  t56 = t28 * t55
  t57 = jnp.exp(-t53)
  t58 = t57 ** 2
  t59 = t9 * t12
  t60 = s0 * t16
  t62 = 0.1e1 / t13 / t35
  t64 = t59 * t60 * t62
  t66 = 0.1e1 + 0.38306165027777777777777777777777777777777777777778e-1 * t64
  t67 = 0.1e1 / t66
  t68 = t58 * t67
  t69 = t56 * t68
  t70 = 0.1e-59 < t69
  t71 = f.my_piecewise3(t70, t69, 0.1e-59)
  t72 = 0.1e1 / t71
  t73 = t16 * t72
  t74 = t15 * t73
  t75 = t10 * t74
  t76 = t75 / 0.6e1
  t77 = 0.10e8 <= t76
  t78 = xc_E1_scaled(t76)
  t83 = 0.1e1 / t2 * t3 * t29 / t8
  t84 = t11 * t13
  t85 = t33 * t71
  t89 = t78 - t83 * t84 * t85 / 0.4e1
  t91 = 0.1e1 / t13 / r0
  t92 = t12 * t91
  t93 = t92 * t73
  t94 = t10 * t93
  t96 = t71 ** 2
  t97 = 0.1e1 / t96
  t98 = t16 * t97
  t99 = t27 * t55
  t100 = 4 ** (0.1e1 / 0.15e2)
  t101 = t100 ** 2
  t102 = t101 ** 2
  t104 = t102 ** 2
  t105 = t104 * t102 * t100
  t107 = t99 * t68 * t105
  t108 = 0.1e1 / t20
  t110 = t108 * t6 * t8
  t111 = t91 * t16
  t113 = t110 * t111 * t25
  t116 = t28 * t54
  t117 = t35 * r0
  t119 = 0.1e1 / t36 / t117
  t123 = t47 * t35
  t125 = 0.1e1 / t13 / t123
  t126 = t46 * t125
  t127 = t44 * t126
  t129 = -0.12015694570370370370370370370370370370370370370370e0 * t32 * t34 * t119 - 0.59273806478425129876543209876543209876543209876544e-2 * t127
  t131 = t116 * t68 * t129
  t133 = t68 * t6
  t134 = t56 * t133
  t135 = t42 * t12
  t136 = t135 * t126
  t139 = t66 ** 2
  t140 = 0.1e1 / t139
  t141 = t58 * t140
  t142 = t141 * t6
  t143 = t56 * t142
  t144 = t8 * t12
  t146 = 0.1e1 / t13 / t117
  t147 = t60 * t146
  t148 = t144 * t147
  t152 = f.my_piecewise3(t70, 0.38758168244062986666666666666666666666666666666666e-2 * t107 * t113 + 0.2e1 * t131 + 0.11854761295685025975308641975308641975308641975309e-1 * t134 * t136 + 0.89381051731481481481481481481481481481481481481482e-1 * t143 * t148, 0)
  t153 = t98 * t152
  t155 = t10 * t15 * t153
  t157 = -t94 / 0.18e2 - t155 / 0.6e1
  t158 = t89 * t157
  t159 = t5 * t59
  t160 = t14 * t16
  t161 = jnp.sqrt(0.6e1)
  t162 = t161 * t7
  t163 = t2 * t6
  t164 = t163 * t8
  t165 = t164 * t74
  t166 = jnp.sqrt(t165)
  t167 = t162 * t166
  t170 = 0.3e1 + t167 / 0.3e1 + t75 / 0.3e1
  t172 = 0.3e1 + t167 + t75
  t173 = 0.1e1 / t172
  t174 = t72 * t170 * t173
  t178 = 0.1e1 + t159 * t160 * t174 / 0.3e1
  t183 = t160 * t97
  t184 = t170 * t173
  t185 = t184 * t152
  t189 = 0.1e1 / t166
  t192 = t163 * t144
  t193 = t97 * t152
  t196 = -t164 * t93 / 0.3e1 - t192 * t160 * t193
  t198 = t162 * t189 * t196
  t202 = t198 / 0.6e1 - t94 / 0.9e1 - t155 / 0.3e1
  t204 = t72 * t202 * t173
  t208 = t160 * t72
  t209 = t172 ** 2
  t210 = 0.1e1 / t209
  t211 = t170 * t210
  t214 = t198 / 0.2e1 - t94 / 0.3e1 - t155
  t215 = t211 * t214
  t219 = -t159 * t111 * t174 / 0.9e1 - t159 * t183 * t185 / 0.3e1 + t159 * t160 * t204 / 0.3e1 - t159 * t208 * t215 / 0.3e1
  t221 = t202 * t173
  t227 = f.my_piecewise3(t77, 0, t5 * (-t158 * t178 - t78 * t219 - 0.2e1 * t215 + 0.2e1 * t221) / 0.4e1)
  t229 = jnp.sqrt(t19)
  t231 = jnp.exp(-0.54466942400000000000000000000000000000000000000000e0 * t229)
  t233 = t17 ** 2
  t237 = jnp.exp(-0.16390970575000000000000000000000000000000000000000e0 * t233 * t17 * t21)
  t239 = 0.1247511874e1 - 0.859614445e0 * t231 + 0.812904345e0 * t237
  t240 = t239 ** 2
  t241 = 0.11326712603257180837500000000000000000000000000000e0 * t52
  t242 = 0.1e1 + t241
  t243 = t242 ** 2
  t244 = t240 * t243
  t245 = jnp.exp(-t241)
  t246 = t245 ** 2
  t248 = 0.1e1 + 0.10001700163888888888888888888888888888888888888889e0 * t64
  t249 = 0.1e1 / t248
  t250 = t246 * t249
  t251 = t244 * t250
  t252 = 0.1e-59 < t251
  t253 = f.my_piecewise3(t252, t251, 0.1e-59)
  t254 = 0.1e1 / t253
  t255 = t16 * t254
  t256 = t15 * t255
  t257 = t10 * t256
  t258 = t257 / 0.6e1
  t259 = 0.10e8 <= t258
  t260 = xc_E1_scaled(t258)
  t261 = t33 * t253
  t265 = t260 - t83 * t84 * t261 / 0.4e1
  t266 = t92 * t255
  t267 = t10 * t266
  t269 = t253 ** 2
  t270 = 0.1e1 / t269
  t271 = t16 * t270
  t272 = t239 * t243
  t275 = 0.1e1 / t229 * t6 * t8
  t276 = t16 * t231
  t280 = t21 * t20
  t283 = t102 / t280 * t6
  t285 = t16 * t237
  t289 = -0.78034284103371613333333333333333333333333333333334e-1 * t275 * t92 * t276 + 0.71062886395651458000000000000000000000000000000000e-1 * t283 * t8 * t91 * t285
  t290 = t250 * t289
  t291 = t272 * t290
  t293 = t240 * t242
  t294 = t250 * t6
  t295 = t293 * t294
  t298 = t244 * t294
  t301 = t248 ** 2
  t303 = t246 / t301
  t304 = t303 * t6
  t305 = t244 * t304
  t309 = f.my_piecewise3(t252, 0.2e1 * t291 - 0.12081826776807659560000000000000000000000000000000e1 * t295 * t136 + 0.12081826776807659560000000000000000000000000000000e1 * t298 * t136 + 0.23337300382407407407407407407407407407407407407408e0 * t305 * t148, 0)
  t310 = t271 * t309
  t312 = t10 * t15 * t310
  t314 = -t267 / 0.18e2 - t312 / 0.6e1
  t315 = t265 * t314
  t316 = t164 * t256
  t317 = jnp.sqrt(t316)
  t318 = t162 * t317
  t321 = 0.3e1 + t318 / 0.3e1 + t257 / 0.3e1
  t323 = 0.3e1 + t318 + t257
  t324 = 0.1e1 / t323
  t325 = t254 * t321 * t324
  t329 = 0.1e1 + t159 * t160 * t325 / 0.3e1
  t334 = t160 * t270
  t335 = t321 * t324
  t336 = t335 * t309
  t340 = 0.1e1 / t317
  t343 = t270 * t309
  t346 = -t164 * t266 / 0.3e1 - t192 * t160 * t343
  t348 = t162 * t340 * t346
  t352 = t348 / 0.6e1 - t267 / 0.9e1 - t312 / 0.3e1
  t354 = t254 * t352 * t324
  t358 = t160 * t254
  t359 = t323 ** 2
  t360 = 0.1e1 / t359
  t361 = t321 * t360
  t364 = t348 / 0.2e1 - t267 / 0.3e1 - t312
  t365 = t361 * t364
  t369 = -t159 * t111 * t325 / 0.9e1 - t159 * t334 * t336 / 0.3e1 + t159 * t160 * t354 / 0.3e1 - t159 * t358 * t365 / 0.3e1
  t371 = t352 * t324
  t374 = -t260 * t369 - t315 * t329 - 0.2e1 * t365 + 0.2e1 * t371
  t375 = 0.1e1 / t36
  t376 = t375 * t33
  t379 = 0.46950800000000000000000000000000000000000000000000e0 * t229 + 0.43329250000000000000000000000000000000000000000000e0 * t19
  t380 = t379 ** 2
  t381 = 0.1e1 / t380
  t385 = jnp.exp(-t32 * t376 * t381 / 0.4e1)
  t390 = -t260 * t329 + 0.2e1 * t335
  t393 = 0.1e1 / t36 / r0 * t33
  t398 = 0.1e1 / t380 / t379
  t399 = t92 * t16
  t404 = -0.78251333333333333333333333333333333333333333333333e-1 * t275 * t399 - 0.14443083333333333333333333333333333333333333333333e0 * t9 * t399
  t405 = t398 * t404
  t409 = t32 * t393 * t381 / 0.6e1 + t32 * t376 * t405 / 0.2e1
  t415 = f.my_piecewise3(t259, 0, t5 * t390 * t409 * t385 / 0.4e1 + t5 * t374 * t385 / 0.4e1)
  t417 = t11 * t375
  t425 = t158 - t83 * t417 * t85 / 0.12e2 - t83 * t84 * t33 * t152 / 0.4e1
  t428 = t12 * t62
  t429 = t428 * t73
  t430 = t10 * t429
  t433 = t10 * t92 * t153
  t436 = 0.1e1 / t96 / t71
  t437 = t16 * t436
  t438 = t152 ** 2
  t441 = t10 * t15 * t437 * t438
  t444 = t104 * t101 * t100
  t445 = 0.1e1 / t21
  t449 = t25 ** 2
  t457 = t27 * t54 * t58
  t467 = t99 * t58
  t471 = t30 * t7
  t473 = t47 * t117
  t475 = 0.1e1 / t36 / t473
  t477 = t33 * t25
  t486 = 0.1e1 / t36 / t47
  t495 = 0.1e1 / t20 / t19
  t498 = t38 * t33
  t499 = t498 * t25
  t503 = t62 * t16
  t515 = t129 ** 2
  t523 = t59 * t147
  t531 = t46 / t13 / t473
  t539 = t56 * t68 * t29
  t541 = t30 * t4 * t11
  t542 = t45 ** 2
  t543 = t542 * t33
  t544 = t47 ** 2
  t547 = 0.1e1 / t36 / t544 / t47
  t549 = t541 * t543 * t547
  t552 = t141 * t29
  t553 = t56 * t552
  t554 = t471 * t11
  t556 = t45 * s0 * t33
  t561 = t554 * t556 / t36 / t544 / r0
  t564 = t135 * t531
  t569 = t58 / t139 / t66
  t571 = t56 * t569 * t29
  t572 = t30 * t11
  t573 = t45 * t33
  t575 = 0.1e1 / t36 / t123
  t577 = t572 * t573 * t575
  t583 = t144 * t60 / t13 / t47
  t586 = 0.30043912112701850783671895879736888888888888888888e-4 * t444 * t445 * t31 * t38 * t33 * t449 * t55 * t58 * t67 + 0.15503267297625194666666666666666666666666666666666e-1 * t457 * t67 * t105 * t108 * t9 * t91 * t16 * t25 * t129 + 0.36757506623309308790453339974048342386831275720165e-3 * t467 * t67 * t104 * t108 * t29 * t471 * t475 * t477 * t45 + 0.27713966726720452681130852345679012345679012345678e-2 * t467 * t140 * t104 * t108 * t31 * t486 * t477 * s0 + 0.10335511531750129777777777777777777777777777777778e-2 * t99 * t68 * t104 * t495 * t29 * t30 * t499 - 0.51677557658750648888888888888888888888888888888888e-2 * t107 * t110 * t503 * t25 + 0.86069881805663999735864888888888888888888888888886e-4 * t99 * t68 * t444 * t445 * t29 * t30 * t499 + 0.2e1 * t28 * t515 * t68 + 0.47419045182740103901234567901234567901234567901236e-1 * t131 * t127 + 0.35752420692592592592592592592592592592592592592592e0 * t116 * t141 * t129 * t523 + 0.2e1 * t116 * t68 * (0.44057546758024691358024691358024691358024691358023e0 * t32 * t34 * t486 + 0.37540077436335915588477366255144032921810699588478e-1 * t44 * t531) + 0.56214146151068686344714515889060010120408474317943e-3 * t539 * t549 + 0.84767282610719019344991696826703246456332876085966e-2 * t553 * t561 - 0.75080154872671831176954732510288065843621399176957e-1 * t134 * t564 + 0.63911779269006149910150891632373113854595336076819e-1 * t571 * t577 - 0.29793683910493827160493827160493827160493827160494e0 * t143 * t583
  t587 = f.my_piecewise3(t70, t586, 0)
  t590 = t10 * t15 * t98 * t587
  t600 = t111 * t97
  t607 = t111 * t72
  t611 = t160 * t436
  t621 = t144 * t14
  t622 = t5 * t6 * t621
  t623 = t98 * t170
  t634 = 0.1e1 / t166 / t165
  t635 = t196 ** 2
  t637 = t162 * t634 * t635
  t653 = t162 * t189 * (0.4e1 / 0.9e1 * t164 * t429 + 0.2e1 / 0.3e1 * t192 * t111 * t193 + 0.2e1 * t192 * t160 * t436 * t438 - t192 * t160 * t97 * t587)
  t659 = -t637 / 0.12e2 + t653 / 0.6e1 + 0.4e1 / 0.27e2 * t430 + 0.2e1 / 0.9e1 * t433 + 0.2e1 / 0.3e1 * t441 - t590 / 0.3e1
  t665 = t202 * t210
  t666 = t665 * t214
  t671 = 0.1e1 / t209 / t172
  t672 = t170 * t671
  t673 = t214 ** 2
  t674 = t672 * t673
  t684 = t211 * (-t637 / 0.4e1 + t653 / 0.2e1 + 0.4e1 / 0.9e1 * t430 + 0.2e1 / 0.3e1 * t433 + 0.2e1 * t441 - t590)
  t688 = 0.4e1 / 0.27e2 * t159 * t503 * t174 + 0.2e1 / 0.9e1 * t159 * t600 * t185 - 0.2e1 / 0.9e1 * t159 * t111 * t204 + 0.2e1 / 0.9e1 * t159 * t607 * t215 + 0.2e1 / 0.3e1 * t159 * t611 * t184 * t438 - 0.2e1 / 0.3e1 * t159 * t183 * t221 * t152 + 0.2e1 / 0.3e1 * t622 * t623 * t210 * t152 * t214 - t159 * t183 * t184 * t587 / 0.3e1 + t159 * t160 * t72 * t659 * t173 / 0.3e1 - 0.2e1 / 0.3e1 * t159 * t208 * t666 + 0.2e1 / 0.3e1 * t159 * t208 * t674 - t159 * t208 * t684 / 0.3e1
  t698 = f.my_piecewise3(t77, 0, t5 * (-t425 * t157 * t178 - t89 * (0.2e1 / 0.27e2 * t430 + t433 / 0.9e1 + t441 / 0.3e1 - t590 / 0.6e1) * t178 - 0.2e1 * t158 * t219 - t78 * t688 + 0.2e1 * t659 * t173 - 0.4e1 * t666 + 0.4e1 * t674 - 0.2e1 * t684) / 0.4e1)
  t706 = t315 - t83 * t417 * t261 / 0.12e2 - t83 * t84 * t33 * t309 / 0.4e1
  t709 = t428 * t255
  t710 = t10 * t709
  t713 = t10 * t92 * t310
  t716 = 0.1e1 / t269 / t253
  t717 = t16 * t716
  t718 = t309 ** 2
  t721 = t10 * t15 * t717 * t718
  t723 = t289 ** 2
  t727 = t239 * t242
  t740 = 0.1e1 / t229 / t19 * t29 * t30
  t741 = t11 * t38
  t760 = t30 * t38 * t33 * t237
  t776 = t240 * t29 * t541
  t782 = t250 * t29
  t783 = t293 * t782
  t786 = t303 * t29
  t787 = t293 * t786
  t792 = t244 * t782
  t795 = t244 * t786
  t802 = t246 / t301 / t248
  t804 = t244 * t802 * t29
  t809 = 0.2e1 * t723 * t243 * t250 - 0.48327307107230638240000000000000000000000000000000e1 * t727 * t290 * t127 + 0.48327307107230638240000000000000000000000000000000e1 * t291 * t127 + 0.93349201529629629629629629629629629629629629629632e0 * t272 * t303 * t289 * t523 + 0.2e1 * t272 * t250 * (-0.52022856068914408888888888888888888888888888888889e-1 * t740 * t741 * t33 * t231 + 0.10404571213782881777777777777777777777777777777778e0 * t275 * t428 * t276 - 0.70838147624726288487028977777777777777777777777777e-2 * t59 * t503 * t231 + 0.14212577279130291600000000000000000000000000000000e-1 * t104 * t102 * t101 / t280 / t19 * t29 * t760 - 0.94750515194201944000000000000000000000000000000000e-1 * t283 * t8 * t62 * t285 + 0.62122116260570178988471912000000000000000000000000e-2 * t104 * t495 * t29 * t760) + 0.29194107652957311994490614216971878720000000000000e1 * t776 * t543 * t547 * t246 * t249 - 0.11677643061182924797796245686788751488000000000000e2 * t783 * t549 - 0.22556577652685875833119884317037037037037037037038e1 * t787 * t561 + 0.76518236253115177213333333333333333333333333333333e1 * t295 * t564 + 0.58388215305914623988981228433943757440000000000000e1 * t792 * t549 + 0.22556577652685875833119884317037037037037037037038e1 * t795 * t561 - 0.76518236253115177213333333333333333333333333333333e1 * t298 * t564 + 0.43570367131097033921056241426611796982167352537724e0 * t804 * t577 - 0.77791001274691358024691358024691358024691358024693e0 * t305 * t583
  t810 = f.my_piecewise3(t252, t809, 0)
  t813 = t10 * t15 * t271 * t810
  t823 = t111 * t270
  t830 = t111 * t254
  t834 = t160 * t716
  t843 = t271 * t321
  t854 = 0.1e1 / t317 / t316
  t855 = t346 ** 2
  t857 = t162 * t854 * t855
  t873 = t162 * t340 * (0.4e1 / 0.9e1 * t164 * t709 + 0.2e1 / 0.3e1 * t192 * t111 * t343 + 0.2e1 * t192 * t160 * t716 * t718 - t192 * t160 * t270 * t810)
  t879 = -t857 / 0.12e2 + t873 / 0.6e1 + 0.4e1 / 0.27e2 * t710 + 0.2e1 / 0.9e1 * t713 + 0.2e1 / 0.3e1 * t721 - t813 / 0.3e1
  t885 = t352 * t360
  t886 = t885 * t364
  t891 = 0.1e1 / t359 / t323
  t892 = t321 * t891
  t893 = t364 ** 2
  t894 = t892 * t893
  t904 = t361 * (-t857 / 0.4e1 + t873 / 0.2e1 + 0.4e1 / 0.9e1 * t710 + 0.2e1 / 0.3e1 * t713 + 0.2e1 * t721 - t813)
  t908 = 0.4e1 / 0.27e2 * t159 * t503 * t325 + 0.2e1 / 0.9e1 * t159 * t823 * t336 - 0.2e1 / 0.9e1 * t159 * t111 * t354 + 0.2e1 / 0.9e1 * t159 * t830 * t365 + 0.2e1 / 0.3e1 * t159 * t834 * t335 * t718 - 0.2e1 / 0.3e1 * t159 * t334 * t371 * t309 + 0.2e1 / 0.3e1 * t622 * t843 * t360 * t309 * t364 - t159 * t334 * t335 * t810 / 0.3e1 + t159 * t160 * t254 * t879 * t324 / 0.3e1 - 0.2e1 / 0.3e1 * t159 * t358 * t886 + 0.2e1 / 0.3e1 * t159 * t358 * t894 - t159 * t358 * t904 / 0.3e1
  t929 = t380 ** 2
  t931 = t404 ** 2
  t936 = t741 * t33
  t939 = t428 * t16
  t942 = t9 * t939
  t954 = t409 ** 2
  t960 = f.my_piecewise3(t259, 0, t5 * (-t706 * t314 * t329 - t265 * (0.2e1 / 0.27e2 * t710 + t713 / 0.9e1 + t721 / 0.3e1 - t813 / 0.6e1) * t329 - 0.2e1 * t315 * t369 - t260 * t908 + 0.2e1 * t879 * t324 - 0.4e1 * t886 + 0.4e1 * t894 - 0.2e1 * t904) * t385 / 0.4e1 + t5 * t374 * t409 * t385 / 0.2e1 + t5 * t390 * (-0.5e1 / 0.18e2 * t32 * t498 * t381 - 0.2e1 / 0.3e1 * t32 * t393 * t405 - 0.3e1 / 0.2e1 * t32 * t376 / t929 * t931 + t32 * t376 * t398 * (-0.52167555555555555555555555555555555555555555555555e-1 * t740 * t936 + 0.10433511111111111111111111111111111111111111111111e0 * t275 * t939 + 0.19257444444444444444444444444444444444444444444444e0 * t942) / 0.2e1) * t385 / 0.4e1 + t5 * t390 * t954 * t385 / 0.4e1)
  v2rho2_0_ = 0.4e1 * t227 + 0.4e1 * t415 + r0 * (0.2e1 * t698 + 0.2e1 * t960)
  t964 = t89 * t2
  t966 = t4 * t6 * t8
  t967 = t964 * t966
  t970 = t60 * t50
  t971 = t44 * t970
  t973 = 0.45058854638888888888888888888888888888888888888889e-1 * t31 * t936 + 0.22227677429409423703703703703703703703703703703704e-2 * t971
  t974 = t68 * t973
  t975 = t116 * t974
  t977 = t135 * t970
  t980 = t56 * t141
  t984 = f.my_piecewise3(t70, 0.2e1 * t975 - 0.44455354858818847407407407407407407407407407407408e-2 * t134 * t977 - 0.38306165027777777777777777777777777777777777777778e-1 * t980 * t942, 0)
  t985 = t97 * t984
  t986 = t985 * t178
  t987 = t18 * t986
  t990 = t184 * t984
  t995 = t162 * t189 * t2 * t6
  t996 = t98 * t984
  t998 = t995 * t621 * t996
  t1000 = t15 * t996
  t1001 = t10 * t1000
  t1003 = -t998 / 0.6e1 - t1001 / 0.3e1
  t1005 = t72 * t1003 * t173
  t1009 = -t998 / 0.2e1 - t1001
  t1010 = t211 * t1009
  t1014 = t159 * t160 * t1005 / 0.3e1 - t159 * t208 * t1010 / 0.3e1 - t159 * t183 * t990 / 0.3e1
  t1016 = t1003 * t173
  t1022 = f.my_piecewise3(t77, 0, t5 * (t967 * t987 / 0.6e1 - t78 * t1014 + 0.2e1 * t1016 - 0.2e1 * t1010) / 0.4e1)
  t1024 = t265 * t2
  t1025 = t1024 * t966
  t1030 = t244 * t303
  t1034 = f.my_piecewise3(t252, 0.45306850413028723350000000000000000000000000000000e0 * t295 * t977 - 0.45306850413028723350000000000000000000000000000000e0 * t298 * t977 - 0.10001700163888888888888888888888888888888888888889e0 * t1030 * t942, 0)
  t1035 = t270 * t1034
  t1036 = t1035 * t329
  t1037 = t18 * t1036
  t1040 = t335 * t1034
  t1045 = t162 * t340 * t2 * t6
  t1046 = t271 * t1034
  t1048 = t1045 * t621 * t1046
  t1050 = t15 * t1046
  t1051 = t10 * t1050
  t1053 = -t1048 / 0.6e1 - t1051 / 0.3e1
  t1055 = t254 * t1053 * t324
  t1059 = -t1048 / 0.2e1 - t1051
  t1060 = t361 * t1059
  t1064 = -t159 * t334 * t1040 / 0.3e1 + t159 * t160 * t1055 / 0.3e1 - t159 * t358 * t1060 / 0.3e1
  t1066 = t1053 * t324
  t1069 = t1025 * t1037 / 0.6e1 - t260 * t1064 + 0.2e1 * t1066 - 0.2e1 * t1060
  t1073 = f.my_piecewise3(t259, 0, t5 * t1069 * t385 / 0.4e1)
  t1100 = t116 * t141 * t973
  t1103 = t11 * t33
  t1107 = t60 * t125
  t1125 = t135 * s0
  t1126 = t16 * t50
  t1133 = 0.1e1 / t36 / t544 / t117
  t1135 = t541 * t556 * t1133
  t1141 = t554 * t573 / t36 / t544
  t1144 = t135 * t1107
  t1164 = t572 * t33 / t36 / t48 * s0
  t1167 = t12 * t16
  t1169 = t9 * t1167 * t146
  t1172 = 0.77516336488125973333333333333333333333333333333332e-2 * t457 * t67 * t973 * t105 * t113 + 0.2e1 * t28 * t129 * t974 + 0.23709522591370051950617283950617283950617283950618e-1 * t975 * t127 + 0.17876210346296296296296296296296296296296296296296e0 * t1100 * t523 + 0.2e1 * t116 * t68 * (-0.12015694570370370370370370370370370370370370370370e0 * t31 * t1103 * t119 - 0.11854761295685025975308641975308641975308641975309e-1 * t44 * t1107) - 0.68920324918704953982100012451340641975308641975307e-4 * t467 * t67 * t29 * t471 * t104 * s0 * t33 * t575 * t108 * t25 - 0.88910709717637694814814814814814814814814814814816e-2 * t116 * t133 * t1125 * t1126 * t129 - 0.21080304806650757379267943458397503795153177869228e-3 * t539 * t1135 - 0.34058283191806748843969878189300411522633744855968e-2 * t553 * t1141 + 0.23709522591370051950617283950617283950617283950618e-1 * t134 * t1144 - 0.59387071557258112888137540740740740740740740740739e-3 * t99 * t552 * t30 * t104 * t33 * t119 * t108 * t25 - 0.76612330055555555555555555555555555555555555555556e-1 * t116 * t142 * t144 * t503 * t129 - 0.27390762543859778532921810699588477366255144032922e-1 * t571 * t1164 + 0.89381051731481481481481481481481481481481481481482e-1 * t980 * t1169
  t1173 = f.my_piecewise3(t70, t1172, 0)
  t1197 = t210 * t984
  t1217 = t162 * t634 * t164 * t18 * t985 * t196
  t1219 = t144 * t91
  t1221 = t995 * t1219 * t996
  t1226 = t436 * t984 * t152
  t1228 = t162 * t189 * t164 * t18 * t1226
  t1230 = t98 * t1173
  t1232 = t995 * t621 * t1230
  t1235 = t10 * t92 * t996
  t1238 = t159 * t160 * t1226
  t1241 = t10 * t15 * t1230
  t1243 = t1217 / 0.12e2 + t1221 / 0.18e2 + t1228 / 0.3e1 - t1232 / 0.6e1 + t1235 / 0.9e1 + 0.2e1 / 0.3e1 * t1238 - t1241 / 0.3e1
  t1249 = t1003 * t210
  t1250 = t1249 * t214
  t1262 = t665 * t1009
  t1278 = t211 * (t1217 / 0.4e1 + t1221 / 0.6e1 + t1228 - t1232 / 0.2e1 + t1235 / 0.3e1 + 0.2e1 * t1238 - t1241)
  t1282 = t159 * t600 * t990 / 0.9e1 + 0.2e1 / 0.3e1 * t622 * t437 * t170 * t173 * t984 * t152 - t159 * t183 * t221 * t984 / 0.3e1 + t622 * t623 * t1197 * t214 / 0.3e1 - t159 * t183 * t184 * t1173 / 0.3e1 - t159 * t111 * t1005 / 0.9e1 - t159 * t183 * t1016 * t152 / 0.3e1 + t159 * t160 * t72 * t1243 * t173 / 0.3e1 - t159 * t208 * t1250 / 0.3e1 + t159 * t607 * t1010 / 0.9e1 + t622 * t623 * t210 * t1009 * t152 / 0.3e1 - t159 * t208 * t1262 / 0.3e1 + 0.2e1 / 0.3e1 * t622 * t73 * t170 * t671 * t1009 * t214 - t159 * t208 * t1278 / 0.3e1
  t1292 = t425 * t2 * t966 * t987 / 0.6e1 - t967 * t399 * t986 / 0.18e2 - t964 * t4 * t59 * t611 * t984 * t178 * t152 / 0.3e1 + t967 * t18 * t97 * t1173 * t178 / 0.6e1 + t967 * t18 * t985 * t219 / 0.6e1 - t158 * t1014 - t78 * t1282 + 0.2e1 * t1243 * t173 - 0.2e1 * t1250 - 0.2e1 * t1262 + 0.4e1 * t672 * t1009 * t214 - 0.2e1 * t1278
  t1295 = f.my_piecewise3(t77, 0, t5 * t1292 / 0.4e1)
  t1312 = t1125 * t1126 * t289
  t1344 = 0.90613700826057446700000000000000000000000000000000e0 * t727 * t294 * t1312 - 0.10947790369858991997933980331364454520000000000000e1 * t776 * t556 * t1133 * t246 * t249 + 0.43791161479435967991735921325457818080000000000000e1 * t783 * t1135 + 0.90629106640255751115213820916666666666666666666669e0 * t787 * t1141 - 0.24163653553615319120000000000000000000000000000000e1 * t295 * t1144 - 0.90613700826057446700000000000000000000000000000000e0 * t272 * t294 * t1312 - 0.21895580739717983995867960662728909040000000000000e1 * t792 * t1135 - 0.90629106640255751115213820916666666666666666666669e0 * t795 * t1141 + 0.24163653553615319120000000000000000000000000000000e1 * t298 * t1144 - 0.20003400327777777777777777777777777777777777777778e0 * t272 * t304 * t144 * t503 * t289 - 0.18673014484755871680452674897119341563786008230453e0 * t804 * t1164 + 0.23337300382407407407407407407407407407407407407408e0 * t1030 * t1169
  t1345 = f.my_piecewise3(t252, t1344, 0)
  t1369 = t360 * t1034
  t1389 = t162 * t854 * t164 * t18 * t1035 * t346
  t1392 = t1045 * t1219 * t1046
  t1397 = t716 * t1034 * t309
  t1399 = t162 * t340 * t164 * t18 * t1397
  t1401 = t271 * t1345
  t1403 = t1045 * t621 * t1401
  t1406 = t10 * t92 * t1046
  t1409 = t159 * t160 * t1397
  t1412 = t10 * t15 * t1401
  t1414 = t1389 / 0.12e2 + t1392 / 0.18e2 + t1399 / 0.3e1 - t1403 / 0.6e1 + t1406 / 0.9e1 + 0.2e1 / 0.3e1 * t1409 - t1412 / 0.3e1
  t1420 = t1053 * t360
  t1421 = t1420 * t364
  t1433 = t885 * t1059
  t1449 = t361 * (t1389 / 0.4e1 + t1392 / 0.6e1 + t1399 - t1403 / 0.2e1 + t1406 / 0.3e1 + 0.2e1 * t1409 - t1412)
  t1453 = t159 * t823 * t1040 / 0.9e1 + 0.2e1 / 0.3e1 * t622 * t717 * t321 * t324 * t1034 * t309 - t159 * t334 * t371 * t1034 / 0.3e1 + t622 * t843 * t1369 * t364 / 0.3e1 - t159 * t334 * t335 * t1345 / 0.3e1 - t159 * t111 * t1055 / 0.9e1 - t159 * t334 * t1066 * t309 / 0.3e1 + t159 * t160 * t254 * t1414 * t324 / 0.3e1 - t159 * t358 * t1421 / 0.3e1 + t159 * t830 * t1060 / 0.9e1 + t622 * t843 * t360 * t1059 * t309 / 0.3e1 - t159 * t358 * t1433 / 0.3e1 + 0.2e1 / 0.3e1 * t622 * t255 * t321 * t891 * t1059 * t364 - t159 * t358 * t1449 / 0.3e1
  t1463 = t706 * t2 * t966 * t1037 / 0.6e1 - t1025 * t399 * t1036 / 0.18e2 - t1024 * t4 * t59 * t834 * t1034 * t329 * t309 / 0.3e1 + t1025 * t18 * t270 * t1345 * t329 / 0.6e1 + t1025 * t18 * t1035 * t369 / 0.6e1 - t315 * t1064 - t260 * t1453 + 0.2e1 * t1414 * t324 - 0.2e1 * t1421 - 0.2e1 * t1433 + 0.4e1 * t892 * t1059 * t364 - 0.2e1 * t1449
  t1471 = f.my_piecewise3(t259, 0, t5 * t1069 * t409 * t385 / 0.4e1 + t5 * t1463 * t385 / 0.4e1)
  v2rhosigma_0_ = 0.2e1 * t1022 + 0.2e1 * t1073 + r0 * (0.2e1 * t1295 + 0.2e1 * t1471)
  t1486 = t984 ** 2
  t1492 = t973 ** 2
  t1502 = t43 * t1167 * t50
  t1507 = 0.1e1 / t36 / t544 / t35
  t1509 = t541 * t573 * t1507
  t1513 = t554 * t34 * t475
  t1520 = t31 * t1103 * t486
  t1524 = f.my_piecewise3(t70, 0.2e1 * t28 * t1492 * t68 - 0.17782141943527538962962962962962962962962962962963e-1 * t975 * t971 - 0.15322466011111111111111111111111111111111111111111e0 * t1100 * t942 + 0.44455354858818847407407407407407407407407407407408e-2 * t116 * t68 * t1502 + 0.79051143024940340172254787968990639231824417009603e-4 * t539 * t1509 + 0.13623313276722699537587951275720164609053497942387e-2 * t553 * t1513 - 0.44455354858818847407407407407407407407407407407408e-2 * t69 * t1502 + 0.11738898233082762228395061728395061728395061728395e-1 * t56 * t569 * t1520, 0)
  t1550 = t2 ** 2
  t1554 = t572 * t375
  t1555 = t96 ** 2
  t1560 = t162 * t634 * t1550 * t29 * t1554 * t33 / t1555 * t1486
  t1562 = t437 * t1486
  t1564 = t995 * t621 * t1562
  t1566 = t98 * t1524
  t1568 = t995 * t621 * t1566
  t1571 = t10 * t15 * t1562
  t1574 = t10 * t15 * t1566
  t1576 = -t1560 / 0.3e1 + t1564 / 0.3e1 - t1568 / 0.6e1 + 0.2e1 / 0.3e1 * t1571 - t1574 / 0.3e1
  t1582 = t1249 * t1009
  t1586 = t1009 ** 2
  t1587 = t672 * t1586
  t1594 = t211 * (-t1560 + t1564 - t1568 / 0.2e1 + 0.2e1 * t1571 - t1574)
  t1608 = f.my_piecewise3(t77, 0, t5 * ((-t967 * t1000 / 0.6e1 - t83 * t84 * t33 * t984 / 0.4e1) * t2 * t966 * t987 / 0.6e1 - t967 * t18 * t436 * t1486 * t178 / 0.3e1 + t967 * t18 * t97 * t1524 * t178 / 0.6e1 + t967 * t18 * t985 * t1014 / 0.3e1 - t78 * (0.2e1 / 0.3e1 * t159 * t611 * t184 * t1486 - 0.2e1 / 0.3e1 * t159 * t183 * t1016 * t984 + 0.2e1 / 0.3e1 * t622 * t623 * t1197 * t1009 - t159 * t183 * t184 * t1524 / 0.3e1 + t159 * t160 * t72 * t1576 * t173 / 0.3e1 - 0.2e1 / 0.3e1 * t159 * t208 * t1582 + 0.2e1 / 0.3e1 * t159 * t208 * t1587 - t159 * t208 * t1594 / 0.3e1) + 0.2e1 * t1576 * t173 - 0.4e1 * t1582 + 0.4e1 * t1587 - 0.2e1 * t1594) / 0.4e1)
  t1620 = t1034 ** 2
  t1648 = f.my_piecewise3(t252, 0.41054213886971219992252426242616704450000000000000e0 * t776 * t573 * t1507 * t246 * t249 - 0.16421685554788487996900970497046681780000000000000e1 * t783 * t1509 - 0.36251642656102300446085528366666666666666666666668e0 * t787 * t1513 + 0.45306850413028723350000000000000000000000000000000e0 * t293 * t250 * t1502 + 0.82108427773942439984504852485233408900000000000000e0 * t792 * t1509 + 0.36251642656102300446085528366666666666666666666668e0 * t795 * t1513 - 0.45306850413028723350000000000000000000000000000000e0 * t251 * t1502 + 0.80027204934668021487654320987654320987654320987656e-1 * t244 * t802 * t1520, 0)
  t1677 = t269 ** 2
  t1682 = t162 * t854 * t1550 * t29 * t1554 * t33 / t1677 * t1620
  t1684 = t717 * t1620
  t1686 = t1045 * t621 * t1684
  t1688 = t271 * t1648
  t1690 = t1045 * t621 * t1688
  t1693 = t10 * t15 * t1684
  t1696 = t10 * t15 * t1688
  t1698 = -t1682 / 0.3e1 + t1686 / 0.3e1 - t1690 / 0.6e1 + 0.2e1 / 0.3e1 * t1693 - t1696 / 0.3e1
  t1704 = t1420 * t1059
  t1708 = t1059 ** 2
  t1709 = t892 * t1708
  t1716 = t361 * (-t1682 + t1686 - t1690 / 0.2e1 + 0.2e1 * t1693 - t1696)
  t1731 = f.my_piecewise3(t259, 0, t5 * ((-t1025 * t1050 / 0.6e1 - t83 * t84 * t33 * t1034 / 0.4e1) * t2 * t966 * t1037 / 0.6e1 - t1025 * t18 * t716 * t1620 * t329 / 0.3e1 + t1025 * t18 * t270 * t1648 * t329 / 0.6e1 + t1025 * t18 * t1035 * t1064 / 0.3e1 - t260 * (0.2e1 / 0.3e1 * t159 * t834 * t335 * t1620 - 0.2e1 / 0.3e1 * t159 * t334 * t1066 * t1034 + 0.2e1 / 0.3e1 * t622 * t843 * t1369 * t1059 - t159 * t334 * t335 * t1648 / 0.3e1 + t159 * t160 * t254 * t1698 * t324 / 0.3e1 - 0.2e1 / 0.3e1 * t159 * t358 * t1704 + 0.2e1 / 0.3e1 * t159 * t358 * t1709 - t159 * t358 * t1716 / 0.3e1) + 0.2e1 * t1698 * t324 - 0.4e1 * t1704 + 0.4e1 * t1709 - 0.2e1 * t1716) * t385 / 0.4e1)
  v2sigma2_0_ = r0 * (0.2e1 * t1608 + 0.2e1 * t1731)

  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / jnp.pi
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = t5 * t9
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t13
  t15 = t12 * t14
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = 4 ** (0.1e1 / 0.5e1)
  t19 = t9 * t15 * t16
  t20 = t19 ** (0.1e1 / 0.5e1)
  t21 = t20 ** 2
  t22 = t21 ** 2
  t25 = jnp.exp(-0.20818970000000000000000000000000000000000000000000e-1 * t17 * t22)
  t27 = 0.942486901e0 + 0.349064173e0 * t25
  t28 = t27 ** 2
  t29 = t6 ** 2
  t30 = t8 ** 2
  t31 = t29 * t30
  t32 = t31 * t11
  t33 = t16 ** 2
  t34 = s0 * t33
  t35 = r0 ** 2
  t36 = t13 ** 2
  t38 = 0.1e1 / t36 / t35
  t42 = t8 * t7
  t44 = t6 * t42 * t12
  t45 = s0 ** 2
  t46 = t45 * t16
  t47 = t35 ** 2
  t48 = t47 * r0
  t50 = 0.1e1 / t13 / t48
  t52 = t44 * t46 * t50
  t53 = 0.11113838714704711851851851851851851851851851851852e-2 * t52
  t54 = 0.1e1 + 0.45058854638888888888888888888888888888888888888889e-1 * t32 * t34 * t38 + t53
  t55 = t54 ** 2
  t56 = t28 * t55
  t57 = jnp.exp(-t53)
  t58 = t57 ** 2
  t59 = t9 * t12
  t60 = s0 * t16
  t62 = 0.1e1 / t13 / t35
  t64 = t59 * t60 * t62
  t66 = 0.1e1 + 0.38306165027777777777777777777777777777777777777778e-1 * t64
  t67 = 0.1e1 / t66
  t68 = t58 * t67
  t69 = t56 * t68
  t70 = 0.1e-59 < t69
  t71 = f.my_piecewise3(t70, t69, 0.1e-59)
  t72 = 0.1e1 / t71
  t73 = t16 * t72
  t74 = t15 * t73
  t75 = t10 * t74
  t76 = t75 / 0.6e1
  t77 = 0.10e8 <= t76
  t78 = xc_E1_scaled(t76)
  t83 = 0.1e1 / t2 * t3 * t29 / t8
  t84 = t11 * t13
  t85 = t33 * t71
  t89 = t78 - t83 * t84 * t85 / 0.4e1
  t91 = 0.1e1 / t13 / r0
  t92 = t12 * t91
  t93 = t92 * t73
  t94 = t10 * t93
  t96 = t71 ** 2
  t97 = 0.1e1 / t96
  t98 = t16 * t97
  t99 = t27 * t55
  t100 = 4 ** (0.1e1 / 0.15e2)
  t101 = t100 ** 2
  t102 = t101 ** 2
  t104 = t102 ** 2
  t105 = t104 * t102 * t100
  t106 = t68 * t105
  t107 = t99 * t106
  t108 = 0.1e1 / t20
  t110 = t108 * t6 * t8
  t111 = t91 * t16
  t113 = t110 * t111 * t25
  t116 = t28 * t54
  t117 = t35 * r0
  t119 = 0.1e1 / t36 / t117
  t123 = t47 * t35
  t126 = t46 / t13 / t123
  t127 = t44 * t126
  t129 = -0.12015694570370370370370370370370370370370370370370e0 * t32 * t34 * t119 - 0.59273806478425129876543209876543209876543209876544e-2 * t127
  t130 = t68 * t129
  t131 = t116 * t130
  t133 = t68 * t6
  t134 = t56 * t133
  t135 = t42 * t12
  t136 = t135 * t126
  t139 = t66 ** 2
  t140 = 0.1e1 / t139
  t141 = t58 * t140
  t142 = t141 * t6
  t143 = t56 * t142
  t144 = t8 * t12
  t146 = 0.1e1 / t13 / t117
  t147 = t60 * t146
  t148 = t144 * t147
  t152 = f.my_piecewise3(t70, 0.38758168244062986666666666666666666666666666666666e-2 * t107 * t113 + 0.2e1 * t131 + 0.11854761295685025975308641975308641975308641975309e-1 * t134 * t136 + 0.89381051731481481481481481481481481481481481481482e-1 * t143 * t148, 0)
  t153 = t98 * t152
  t155 = t10 * t15 * t153
  t157 = -t94 / 0.18e2 - t155 / 0.6e1
  t158 = t89 * t157
  t159 = 0.1e1 / t36
  t160 = t11 * t159
  t164 = t33 * t152
  t168 = t158 - t83 * t160 * t85 / 0.12e2 - t83 * t84 * t164 / 0.4e1
  t169 = t168 * t157
  t170 = t5 * t59
  t171 = t14 * t16
  t172 = jnp.sqrt(0.6e1)
  t173 = t172 * t7
  t174 = t2 * t6
  t175 = t174 * t8
  t176 = t175 * t74
  t177 = jnp.sqrt(t176)
  t178 = t173 * t177
  t181 = 0.3e1 + t178 / 0.3e1 + t75 / 0.3e1
  t183 = 0.3e1 + t178 + t75
  t184 = 0.1e1 / t183
  t185 = t72 * t181 * t184
  t189 = 0.1e1 + t170 * t171 * t185 / 0.3e1
  t191 = t12 * t62
  t192 = t191 * t73
  t193 = t10 * t192
  t196 = t10 * t92 * t153
  t199 = 0.1e1 / t96 / t71
  t200 = t16 * t199
  t201 = t152 ** 2
  t202 = t200 * t201
  t204 = t10 * t15 * t202
  t207 = t104 * t101 * t100
  t208 = 0.1e1 / t21
  t209 = t207 * t208
  t210 = t31 * t38
  t211 = t209 * t210
  t212 = t25 ** 2
  t213 = t33 * t212
  t216 = t213 * t55 * t58 * t67
  t220 = t27 * t54 * t58
  t223 = t220 * t67 * t105 * t108
  t224 = t9 * t91
  t225 = t16 * t25
  t226 = t225 * t129
  t230 = t99 * t58
  t231 = t67 * t104
  t232 = t231 * t108
  t233 = t230 * t232
  t234 = t30 * t7
  t235 = t29 * t234
  t236 = t47 * t117
  t238 = 0.1e1 / t36 / t236
  t239 = t235 * t238
  t240 = t33 * t25
  t241 = t240 * t45
  t246 = t140 * t104 * t108
  t247 = t230 * t246
  t249 = 0.1e1 / t36 / t47
  t250 = t31 * t249
  t251 = t240 * s0
  t256 = t99 * t68 * t104
  t258 = 0.1e1 / t20 / t19
  t260 = t258 * t29 * t30
  t261 = t38 * t33
  t262 = t261 * t25
  t266 = t62 * t16
  t272 = t99 * t68 * t207
  t274 = t208 * t29 * t30
  t278 = t129 ** 2
  t279 = t28 * t278
  t285 = t116 * t141 * t129
  t286 = t59 * t147
  t294 = t46 / t13 / t236
  t295 = t44 * t294
  t297 = 0.44057546758024691358024691358024691358024691358023e0 * t32 * t34 * t249 + 0.37540077436335915588477366255144032921810699588478e-1 * t295
  t298 = t68 * t297
  t299 = t116 * t298
  t302 = t56 * t68 * t29
  t303 = t30 * t4
  t304 = t303 * t11
  t305 = t45 ** 2
  t306 = t305 * t33
  t307 = t47 ** 2
  t310 = 0.1e1 / t36 / t307 / t47
  t311 = t306 * t310
  t312 = t304 * t311
  t316 = t56 * t141 * t29
  t317 = t234 * t11
  t318 = t45 * s0
  t319 = t318 * t33
  t320 = t307 * r0
  t323 = t319 / t36 / t320
  t324 = t317 * t323
  t327 = t135 * t294
  t331 = 0.1e1 / t139 / t66
  t332 = t58 * t331
  t334 = t56 * t332 * t29
  t335 = t30 * t11
  t336 = t45 * t33
  t339 = t336 / t36 / t123
  t340 = t335 * t339
  t345 = t60 / t13 / t47
  t346 = t144 * t345
  t349 = 0.30043912112701850783671895879736888888888888888888e-4 * t211 * t216 + 0.15503267297625194666666666666666666666666666666666e-1 * t223 * t224 * t226 + 0.36757506623309308790453339974048342386831275720165e-3 * t233 * t239 * t241 + 0.27713966726720452681130852345679012345679012345678e-2 * t247 * t250 * t251 + 0.10335511531750129777777777777777777777777777777778e-2 * t256 * t260 * t262 - 0.51677557658750648888888888888888888888888888888888e-2 * t107 * t110 * t266 * t25 + 0.86069881805663999735864888888888888888888888888886e-4 * t272 * t274 * t262 + 0.2e1 * t279 * t68 + 0.47419045182740103901234567901234567901234567901236e-1 * t131 * t127 + 0.35752420692592592592592592592592592592592592592592e0 * t285 * t286 + 0.2e1 * t299 + 0.56214146151068686344714515889060010120408474317943e-3 * t302 * t312 + 0.84767282610719019344991696826703246456332876085966e-2 * t316 * t324 - 0.75080154872671831176954732510288065843621399176957e-1 * t134 * t327 + 0.63911779269006149910150891632373113854595336076819e-1 * t334 * t340 - 0.29793683910493827160493827160493827160493827160494e0 * t143 * t346
  t350 = f.my_piecewise3(t70, t349, 0)
  t351 = t98 * t350
  t353 = t10 * t15 * t351
  t355 = 0.2e1 / 0.27e2 * t193 + t196 / 0.9e1 + t204 / 0.3e1 - t353 / 0.6e1
  t356 = t89 * t355
  t361 = t171 * t97
  t362 = t181 * t184
  t363 = t362 * t152
  t367 = 0.1e1 / t177
  t370 = t174 * t144
  t371 = t97 * t152
  t374 = -t175 * t93 / 0.3e1 - t370 * t171 * t371
  t376 = t173 * t367 * t374
  t380 = t376 / 0.6e1 - t94 / 0.9e1 - t155 / 0.3e1
  t382 = t72 * t380 * t184
  t386 = t171 * t72
  t387 = t183 ** 2
  t388 = 0.1e1 / t387
  t389 = t181 * t388
  t392 = t376 / 0.2e1 - t94 / 0.3e1 - t155
  t393 = t389 * t392
  t397 = -t170 * t111 * t185 / 0.9e1 - t170 * t361 * t363 / 0.3e1 + t170 * t171 * t382 / 0.3e1 - t170 * t386 * t393 / 0.3e1
  t403 = t111 * t97
  t410 = t111 * t72
  t414 = t171 * t199
  t415 = t362 * t201
  t419 = t380 * t184
  t420 = t419 * t152
  t424 = t5 * t6
  t426 = t424 * t144 * t14
  t427 = t98 * t181
  t428 = t388 * t152
  t429 = t428 * t392
  t430 = t427 * t429
  t433 = t362 * t350
  t438 = 0.1e1 / t177 / t176
  t439 = t374 ** 2
  t441 = t173 * t438 * t439
  t448 = t199 * t201
  t452 = t97 * t350
  t455 = 0.4e1 / 0.9e1 * t175 * t192 + 0.2e1 / 0.3e1 * t370 * t111 * t371 + 0.2e1 * t370 * t171 * t448 - t370 * t171 * t452
  t457 = t173 * t367 * t455
  t463 = -t441 / 0.12e2 + t457 / 0.6e1 + 0.4e1 / 0.27e2 * t193 + 0.2e1 / 0.9e1 * t196 + 0.2e1 / 0.3e1 * t204 - t353 / 0.3e1
  t465 = t72 * t463 * t184
  t469 = t380 * t388
  t470 = t469 * t392
  t475 = 0.1e1 / t387 / t183
  t476 = t181 * t475
  t477 = t392 ** 2
  t478 = t476 * t477
  t487 = -t441 / 0.4e1 + t457 / 0.2e1 + 0.4e1 / 0.9e1 * t193 + 0.2e1 / 0.3e1 * t196 + 0.2e1 * t204 - t353
  t488 = t389 * t487
  t492 = 0.4e1 / 0.27e2 * t170 * t266 * t185 + 0.2e1 / 0.9e1 * t170 * t403 * t363 - 0.2e1 / 0.9e1 * t170 * t111 * t382 + 0.2e1 / 0.9e1 * t170 * t410 * t393 + 0.2e1 / 0.3e1 * t170 * t414 * t415 - 0.2e1 / 0.3e1 * t170 * t361 * t420 + 0.2e1 / 0.3e1 * t426 * t430 - t170 * t361 * t433 / 0.3e1 + t170 * t171 * t465 / 0.3e1 - 0.2e1 / 0.3e1 * t170 * t386 * t470 + 0.2e1 / 0.3e1 * t170 * t386 * t478 - t170 * t386 * t488 / 0.3e1
  t494 = t463 * t184
  t502 = f.my_piecewise3(t77, 0, t5 * (-0.2e1 * t158 * t397 - t169 * t189 - t356 * t189 - t78 * t492 - 0.4e1 * t470 + 0.4e1 * t478 - 0.2e1 * t488 + 0.2e1 * t494) / 0.4e1)
  t504 = jnp.sqrt(t19)
  t506 = jnp.exp(-0.54466942400000000000000000000000000000000000000000e0 * t504)
  t508 = t17 ** 2
  t509 = t508 * t17
  t512 = jnp.exp(-0.16390970575000000000000000000000000000000000000000e0 * t509 * t21)
  t514 = 0.1247511874e1 - 0.859614445e0 * t506 + 0.812904345e0 * t512
  t515 = t514 ** 2
  t516 = 0.11326712603257180837500000000000000000000000000000e0 * t52
  t517 = 0.1e1 + t516
  t518 = t517 ** 2
  t519 = t515 * t518
  t520 = jnp.exp(-t516)
  t521 = t520 ** 2
  t523 = 0.1e1 + 0.10001700163888888888888888888888888888888888888889e0 * t64
  t524 = 0.1e1 / t523
  t525 = t521 * t524
  t526 = t519 * t525
  t527 = 0.1e-59 < t526
  t528 = f.my_piecewise3(t527, t526, 0.1e-59)
  t529 = 0.1e1 / t528
  t530 = t16 * t529
  t531 = t15 * t530
  t532 = t10 * t531
  t533 = t532 / 0.6e1
  t534 = 0.10e8 <= t533
  t535 = xc_E1_scaled(t533)
  t536 = t33 * t528
  t540 = t535 - t83 * t84 * t536 / 0.4e1
  t541 = t92 * t530
  t542 = t10 * t541
  t544 = t528 ** 2
  t545 = 0.1e1 / t544
  t546 = t16 * t545
  t547 = t514 * t518
  t548 = 0.1e1 / t504
  t550 = t548 * t6 * t8
  t551 = t16 * t506
  t555 = t21 * t20
  t556 = 0.1e1 / t555
  t558 = t102 * t556 * t6
  t560 = t16 * t512
  t564 = -0.78034284103371613333333333333333333333333333333334e-1 * t550 * t92 * t551 + 0.71062886395651458000000000000000000000000000000000e-1 * t558 * t8 * t91 * t560
  t565 = t525 * t564
  t566 = t547 * t565
  t568 = t515 * t517
  t569 = t525 * t6
  t570 = t568 * t569
  t573 = t519 * t569
  t576 = t523 ** 2
  t577 = 0.1e1 / t576
  t578 = t521 * t577
  t579 = t578 * t6
  t580 = t519 * t579
  t584 = f.my_piecewise3(t527, 0.2e1 * t566 - 0.12081826776807659560000000000000000000000000000000e1 * t570 * t136 + 0.12081826776807659560000000000000000000000000000000e1 * t573 * t136 + 0.23337300382407407407407407407407407407407407407408e0 * t580 * t148, 0)
  t585 = t546 * t584
  t587 = t10 * t15 * t585
  t589 = -t542 / 0.18e2 - t587 / 0.6e1
  t590 = t540 * t589
  t594 = t33 * t584
  t598 = t590 - t83 * t160 * t536 / 0.12e2 - t83 * t84 * t594 / 0.4e1
  t599 = t598 * t589
  t600 = t175 * t531
  t601 = jnp.sqrt(t600)
  t602 = t173 * t601
  t605 = 0.3e1 + t602 / 0.3e1 + t532 / 0.3e1
  t607 = 0.3e1 + t602 + t532
  t608 = 0.1e1 / t607
  t609 = t529 * t605 * t608
  t613 = 0.1e1 + t170 * t171 * t609 / 0.3e1
  t615 = t191 * t530
  t616 = t10 * t615
  t619 = t10 * t92 * t585
  t622 = 0.1e1 / t544 / t528
  t623 = t16 * t622
  t624 = t584 ** 2
  t625 = t623 * t624
  t627 = t10 * t15 * t625
  t629 = t564 ** 2
  t630 = t629 * t518
  t633 = t514 * t517
  t634 = t633 * t565
  t639 = t578 * t564
  t640 = t547 * t639
  t646 = 0.1e1 / t504 / t19 * t29 * t30
  t647 = t11 * t38
  t648 = t33 * t506
  t663 = t104 * t102 * t101 / t555 / t19 * t29
  t665 = t33 * t512
  t666 = t30 * t38 * t665
  t674 = t104 * t258 * t29
  t677 = -0.52022856068914408888888888888888888888888888888889e-1 * t646 * t647 * t648 + 0.10404571213782881777777777777777777777777777777778e0 * t550 * t191 * t551 - 0.70838147624726288487028977777777777777777777777777e-2 * t59 * t266 * t506 + 0.14212577279130291600000000000000000000000000000000e-1 * t663 * t666 - 0.94750515194201944000000000000000000000000000000000e-1 * t558 * t8 * t62 * t560 + 0.62122116260570178988471912000000000000000000000000e-2 * t674 * t666
  t678 = t525 * t677
  t679 = t547 * t678
  t682 = t515 * t29 * t304
  t688 = t525 * t29
  t689 = t568 * t688
  t692 = t578 * t29
  t693 = t568 * t692
  t698 = t519 * t688
  t701 = t519 * t692
  t707 = 0.1e1 / t576 / t523
  t708 = t521 * t707
  t710 = t519 * t708 * t29
  t715 = 0.2e1 * t630 * t525 - 0.48327307107230638240000000000000000000000000000000e1 * t634 * t127 + 0.48327307107230638240000000000000000000000000000000e1 * t566 * t127 + 0.93349201529629629629629629629629629629629629629632e0 * t640 * t286 + 0.2e1 * t679 + 0.29194107652957311994490614216971878720000000000000e1 * t682 * t306 * t310 * t521 * t524 - 0.11677643061182924797796245686788751488000000000000e2 * t689 * t312 - 0.22556577652685875833119884317037037037037037037038e1 * t693 * t324 + 0.76518236253115177213333333333333333333333333333333e1 * t570 * t327 + 0.58388215305914623988981228433943757440000000000000e1 * t698 * t312 + 0.22556577652685875833119884317037037037037037037038e1 * t701 * t324 - 0.76518236253115177213333333333333333333333333333333e1 * t573 * t327 + 0.43570367131097033921056241426611796982167352537724e0 * t710 * t340 - 0.77791001274691358024691358024691358024691358024693e0 * t580 * t346
  t716 = f.my_piecewise3(t527, t715, 0)
  t717 = t546 * t716
  t719 = t10 * t15 * t717
  t721 = 0.2e1 / 0.27e2 * t616 + t619 / 0.9e1 + t627 / 0.3e1 - t719 / 0.6e1
  t722 = t540 * t721
  t727 = t171 * t545
  t728 = t605 * t608
  t729 = t728 * t584
  t733 = 0.1e1 / t601
  t736 = t545 * t584
  t739 = -t175 * t541 / 0.3e1 - t370 * t171 * t736
  t741 = t173 * t733 * t739
  t745 = t741 / 0.6e1 - t542 / 0.9e1 - t587 / 0.3e1
  t747 = t529 * t745 * t608
  t751 = t171 * t529
  t752 = t607 ** 2
  t753 = 0.1e1 / t752
  t754 = t605 * t753
  t757 = t741 / 0.2e1 - t542 / 0.3e1 - t587
  t758 = t754 * t757
  t762 = -t170 * t111 * t609 / 0.9e1 - t170 * t727 * t729 / 0.3e1 + t170 * t171 * t747 / 0.3e1 - t170 * t751 * t758 / 0.3e1
  t768 = t111 * t545
  t775 = t111 * t529
  t779 = t171 * t622
  t780 = t728 * t624
  t784 = t745 * t608
  t785 = t784 * t584
  t789 = t546 * t605
  t790 = t753 * t584
  t791 = t790 * t757
  t792 = t789 * t791
  t795 = t728 * t716
  t800 = 0.1e1 / t601 / t600
  t801 = t739 ** 2
  t803 = t173 * t800 * t801
  t810 = t622 * t624
  t814 = t545 * t716
  t817 = 0.4e1 / 0.9e1 * t175 * t615 + 0.2e1 / 0.3e1 * t370 * t111 * t736 + 0.2e1 * t370 * t171 * t810 - t370 * t171 * t814
  t819 = t173 * t733 * t817
  t825 = -t803 / 0.12e2 + t819 / 0.6e1 + 0.4e1 / 0.27e2 * t616 + 0.2e1 / 0.9e1 * t619 + 0.2e1 / 0.3e1 * t627 - t719 / 0.3e1
  t827 = t529 * t825 * t608
  t831 = t745 * t753
  t832 = t831 * t757
  t837 = 0.1e1 / t752 / t607
  t838 = t605 * t837
  t839 = t757 ** 2
  t840 = t838 * t839
  t849 = -t803 / 0.4e1 + t819 / 0.2e1 + 0.4e1 / 0.9e1 * t616 + 0.2e1 / 0.3e1 * t619 + 0.2e1 * t627 - t719
  t850 = t754 * t849
  t854 = 0.4e1 / 0.27e2 * t170 * t266 * t609 + 0.2e1 / 0.9e1 * t170 * t768 * t729 - 0.2e1 / 0.9e1 * t170 * t111 * t747 + 0.2e1 / 0.9e1 * t170 * t775 * t758 + 0.2e1 / 0.3e1 * t170 * t779 * t780 - 0.2e1 / 0.3e1 * t170 * t727 * t785 + 0.2e1 / 0.3e1 * t426 * t792 - t170 * t727 * t795 / 0.3e1 + t170 * t171 * t827 / 0.3e1 - 0.2e1 / 0.3e1 * t170 * t751 * t832 + 0.2e1 / 0.3e1 * t170 * t751 * t840 - t170 * t751 * t850 / 0.3e1
  t856 = t825 * t608
  t861 = -t535 * t854 - 0.2e1 * t590 * t762 - t599 * t613 - t722 * t613 - 0.4e1 * t832 + 0.4e1 * t840 - 0.2e1 * t850 + 0.2e1 * t856
  t862 = t159 * t33
  t865 = 0.46950800000000000000000000000000000000000000000000e0 * t504 + 0.43329250000000000000000000000000000000000000000000e0 * t19
  t866 = t865 ** 2
  t867 = 0.1e1 / t866
  t871 = jnp.exp(-t32 * t862 * t867 / 0.4e1)
  t879 = -t535 * t762 - t590 * t613 - 0.2e1 * t758 + 0.2e1 * t784
  t881 = 0.1e1 / t36 / r0
  t882 = t881 * t33
  t887 = 0.1e1 / t866 / t865
  t888 = t92 * t16
  t893 = -0.78251333333333333333333333333333333333333333333333e-1 * t550 * t888 - 0.14443083333333333333333333333333333333333333333333e0 * t9 * t888
  t894 = t887 * t893
  t898 = t32 * t882 * t867 / 0.6e1 + t32 * t862 * t894 / 0.2e1
  t905 = -t535 * t613 + 0.2e1 * t728
  t912 = t866 ** 2
  t913 = 0.1e1 / t912
  t914 = t893 ** 2
  t915 = t913 * t914
  t922 = t191 * t16
  t927 = -0.52167555555555555555555555555555555555555555555555e-1 * t646 * t647 * t33 + 0.10433511111111111111111111111111111111111111111111e0 * t550 * t922 + 0.19257444444444444444444444444444444444444444444444e0 * t9 * t922
  t928 = t887 * t927
  t932 = -0.5e1 / 0.18e2 * t32 * t261 * t867 - 0.2e1 / 0.3e1 * t32 * t882 * t894 - 0.3e1 / 0.2e1 * t32 * t862 * t915 + t32 * t862 * t928 / 0.2e1
  t937 = t898 ** 2
  t943 = f.my_piecewise3(t534, 0, t5 * t861 * t871 / 0.4e1 + t5 * t879 * t898 * t871 / 0.2e1 + t5 * t905 * t932 * t871 / 0.4e1 + t5 * t905 * t937 * t871 / 0.4e1)
  t945 = t11 * t881
  t964 = t12 * t146
  t965 = t964 * t73
  t966 = t10 * t965
  t969 = t10 * t191 * t153
  t972 = t10 * t92 * t202
  t975 = t10 * t92 * t351
  t977 = t96 ** 2
  t978 = 0.1e1 / t977
  t980 = t201 * t152
  t983 = t10 * t15 * t16 * t978 * t980
  t986 = t171 * t199 * t152 * t350
  t987 = t170 * t986
  t988 = t508 * t208
  t989 = 0.1e1 / t320
  t992 = t212 * t55
  t997 = 0.1e1 / t123
  t1004 = t59 * t345
  t1009 = t119 * t33
  t1010 = t1009 * t25
  t1014 = t146 * t16
  t1023 = t29 * t303 * t11 * t311
  t1026 = t99 * t68
  t1029 = 0.4e1 * t31 * t160 * t33
  t1032 = t17 / t20 / t1029
  t1033 = 0.1e1 / t47
  t1034 = t7 * t1033
  t1035 = t1034 * t25
  t1041 = t508 / t21 / t19
  t1045 = t509 * t556
  t1055 = 0.25643765266892671589440539613360396843055193107924e-4 * t988 * t4 * t989 * t992 * t68 * t45 + 0.19334566531882707943596074849504844639599881481481e-3 * t988 * t7 * t997 * t992 * t141 * s0 - 0.17876210346296296296296296296296296296296296296296e1 * t285 * t1004 - 0.45048092923603098706172839506172839506172839506174e0 * t131 * t295 - 0.41342046127000519111111111111111111111111111111111e-2 * t256 * t260 * t1010 + 0.12058096787041818074074074074074074074074074074074e-1 * t107 * t110 * t1014 * t25 + 0.71128567774110155851851851851851851851851851851854e-1 * t299 * t127 + 0.33728487690641211806828709533436006072245084590766e-2 * t131 * t1023 + 0.99220910704801245866666666666666666666666666666669e-2 * t1026 * t1032 * t1035 + 0.41313543266718719873215146666666666666666666666667e-3 * t1026 * t1041 * t1035 + 0.11468072238180253699718265893319111111111111111111e-4 * t1026 * t1045 * t1035 + 0.16628380036032271608678511407407407407407407407406e-1 * t220 * t246 * t250 * t240 * t129 * s0
  t1062 = t56 * t58
  t1064 = 0.1e1 / t3 / jnp.pi
  t1066 = t305 * s0
  t1067 = t307 ** 2
  t1068 = 0.1e1 / t1067
  t1069 = t1066 * t1068
  t1074 = t307 * t48
  t1076 = t305 / t1074
  t1080 = t139 ** 2
  t1083 = t307 * t35
  t1085 = t318 / t1083
  t1093 = 0.1e1 / t36 / t48
  t1099 = t46 / t13 / t307
  t1107 = t144 * t60 * t50
  t1113 = t317 * t319 / t36 / t1083
  t1116 = t135 * t1099
  t1120 = 0.1e1 / t36 / t1074
  t1122 = t304 * t306 * t1120
  t1130 = t99 * t68 * t17
  t1139 = 0.22054503973985585274272003984429005432098765432099e-2 * t220 * t232 * t239 * t240 * t129 * t45 + 0.36176252437222062231457256503029875383471824384498e-2 * t1062 * t140 * t1064 * t1069 + 0.54551439879593668415948599247193797394299649443685e-1 * t1062 * t331 * t4 * t1076 + 0.41130014753477263595348853818152720621856424325562e0 * t1062 / t1080 * t7 * t1085 + 0.6e1 * t28 * t129 * t298 + 0.2e1 * t116 * t68 * (-0.20560188487078189300411522633744855967078189300411e1 * t32 * t34 * t1093 - 0.27529390119979671431550068587105624142661179698217e0 * t44 * t1099) + 0.12910596361213991769547325102880658436213991769547e1 * t143 * t1107 - 0.12291255978554257805023796039871970736168267032465e0 * t316 * t1113 + 0.55058780239959342863100137174211248285322359396435e0 * t134 * t1116 - 0.10680687768703050405495758018921401922877610120409e-1 * t302 * t1122 - 0.12017564845080740313468758351894755555555555555555e-3 * t209 * t31 * t119 * t216 + 0.15687052806380154677525370479767907012879519559280e-3 * t1130 * t108 * t1064 / t307 / t123 * t25 * t305
  t1142 = t99 * t141 * t17
  t1153 = t989 * t25 * t45
  t1174 = t997 * t25 * s0
  t1191 = t335 * t336 * t238
  t1195 = t235 * t11 * t323
  t1204 = t32 * t339
  t1207 = 0.23655057127331634130737019341774349548189631385460e-2 * t1142 * t108 * t4 / t307 / t117 * t25 * t318 + 0.88218015895942341097088015937716021728395061728398e-3 * t1130 * t258 * t4 * t1153 + 0.73464329055885868841201699646673268995312197530865e-4 * t99 * t68 * t508 * t208 * t4 * t1153 + 0.17835145154536012436341470302470581465020576131687e-1 * t99 * t332 * t17 * t108 * t7 / t307 * t25 * t45 + 0.66513520144129086434714045629629629629629629629629e-2 * t1142 * t258 * t7 * t1174 + 0.55389719219000765064468746981675614814814814814813e-3 * t99 * t141 * t508 * t208 * t7 * t1174 + 0.71128567774110155851851851851851851851851851851854e-1 * t279 * t133 * t136 + 0.53628631038888888888888888888888888888888888888888e0 * t279 * t142 * t148 - 0.63911779269006149910150891632373113854595336076819e0 * t334 * t1191 + 0.50860369566431411606995018096021947873799725651579e-1 * t285 * t1195 + 0.53628631038888888888888888888888888888888888888888e0 * t116 * t141 * t297 * t286 + 0.38347067561403689946090534979423868312757201646091e0 * t116 * t332 * t129 * t1204
  t1219 = t3 ** 2
  t1220 = 0.1e1 / t1219
  t1222 = t305 * t45
  t1224 = 0.1e1 / t1067 / t117
  t1225 = t1222 * t1224
  t1230 = t992 * t68
  t1257 = t210 * t240 * t129
  t1265 = 0.18026347267621110470203137527842133333333333333333e-3 * t211 * t213 * t54 * t130 - 0.34427952722265599894345955555555555555555555555555e-3 * t272 * t274 * t1010 + 0.23254900946437791999999999999999999999999999999999e-1 * t27 * t278 * t106 * t113 + 0.15993726817480090465418280961197669649769417952438e-3 * t1062 * t67 * t1220 * t1225 + 0.14421077814096888376162510022273706666666666666666e-3 * t1041 * t1034 * t1230 + 0.12009279455173947847867040451136625235285333333333e-4 * t1045 * t1034 * t1230 - 0.31006534595250389333333333333333333333333333333333e-1 * t223 * t9 * t62 * t226 - 0.42271132616805705109021340970155593744855967078189e-2 * t233 * t235 / t36 / t307 * t241 - 0.19399776708704316876791596641975308641975308641975e-1 * t247 * t31 * t1093 * t251 + 0.23254900946437791999999999999999999999999999999999e-1 * t223 * t224 * t225 * t297 + 0.62013069190500778666666666666666666666666666666665e-2 * t220 * t231 * t258 * t1257 + 0.51641929083398399841518933333333333333333333333331e-3 * t220 * t67 * t207 * t208 * t1257
  t1268 = f.my_piecewise3(t70, t1055 + t1139 + t1207 + t1265, 0)
  t1271 = t10 * t15 * t98 * t1268
  t1284 = t469 * t487
  t1301 = t2 ** 2
  t1303 = t1301 * t29 * t30
  t1312 = t173 / t177 / t1303 / t160 / t33 / t97 * t439 * t374 / 0.4e1
  t1316 = t173 * t438 * t374 * t455
  t1339 = t173 * t367 * (-0.28e2 / 0.27e2 * t175 * t965 - 0.4e1 / 0.3e1 * t370 * t266 * t371 - 0.2e1 * t370 * t111 * t448 + t370 * t111 * t452 - 0.6e1 * t370 * t171 * t978 * t980 + 0.6e1 * t370 * t986 - t370 * t171 * t97 * t1268)
  t1347 = t389 * (0.3e1 / 0.8e1 * t1312 - 0.3e1 / 0.4e1 * t1316 + t1339 / 0.2e1 - 0.28e2 / 0.27e2 * t966 - 0.4e1 / 0.3e1 * t969 - 0.2e1 * t972 + t975 - 0.6e1 * t983 + 0.6e1 * t987 - t1271)
  t1357 = t380 * t475 * t477
  t1372 = t387 ** 2
  t1376 = t181 / t1372 * t477 * t392
  t1381 = t463 * t388 * t392
  t1387 = -0.2e1 / 0.3e1 * t170 * t111 * t199 * t415 - t170 * t386 * t1284 + 0.2e1 / 0.3e1 * t170 * t410 * t470 + t170 * t410 * t488 / 0.3e1 - t170 * t361 * t362 * t1268 / 0.3e1 + 0.2e1 * t170 * t414 * t419 * t201 - t170 * t386 * t1347 / 0.3e1 - 0.2e1 * t170 * t171 * t978 * t362 * t980 + 0.2e1 * t170 * t386 * t1357 - 0.2e1 / 0.3e1 * t170 * t410 * t478 - 0.4e1 / 0.9e1 * t170 * t266 * t97 * t363 - 0.4e1 / 0.9e1 * t170 * t266 * t72 * t393 - 0.2e1 * t170 * t386 * t1376 - t170 * t386 * t1381 - t170 * t361 * t494 * t152
  t1397 = t200 * t181
  t1427 = t1312 / 0.8e1 - t1316 / 0.4e1 + t1339 / 0.6e1 - 0.28e2 / 0.81e2 * t966 - 0.4e1 / 0.9e1 * t969 - 0.2e1 / 0.3e1 * t972 + t975 / 0.3e1 - 0.2e1 * t983 + 0.2e1 * t987 - t1271 / 0.3e1
  t1443 = t424 * t144 * t91
  t1459 = -t170 * t361 * t419 * t350 + 0.2e1 / 0.3e1 * t170 * t403 * t420 + t170 * t403 * t433 / 0.3e1 - 0.2e1 * t426 * t1397 * t388 * t201 * t392 + 0.2e1 * t426 * t1397 * t184 * t152 * t350 - 0.28e2 / 0.81e2 * t170 * t1014 * t185 - t170 * t111 * t465 / 0.3e1 + 0.4e1 / 0.9e1 * t170 * t266 * t382 + t170 * t171 * t72 * t1427 * t184 / 0.3e1 + t426 * t427 * t388 * t350 * t392 - 0.2e1 * t426 * t427 * t475 * t152 * t477 - 0.2e1 / 0.3e1 * t1443 * t430 + t426 * t427 * t428 * t487 + 0.2e1 * t426 * t73 * t181 * t475 * t392 * t487 + 0.2e1 * t426 * t98 * t380 * t429
  t1472 = -(t169 + t356 + t83 * t945 * t85 / 0.18e2 - t83 * t160 * t164 / 0.6e1 - t83 * t84 * t33 * t350 / 0.4e1) * t157 * t189 - 0.2e1 * t168 * t355 * t189 - 0.3e1 * t169 * t397 - t89 * (-0.14e2 / 0.81e2 * t966 - 0.2e1 / 0.9e1 * t969 - t972 / 0.3e1 + t975 / 0.6e1 - t983 + t987 - t1271 / 0.6e1) * t189 - 0.3e1 * t356 * t397 - 0.3e1 * t158 * t492 - t78 * (t1387 + t1459) + 0.2e1 * t1427 * t184 - 0.6e1 * t1381 + 0.12e2 * t1357 - 0.6e1 * t1284 - 0.12e2 * t1376 + 0.12e2 * t476 * t392 * t487 - 0.2e1 * t1347
  t1475 = f.my_piecewise3(t77, 0, t5 * t1472 / 0.4e1)
  t1494 = t964 * t530
  t1495 = t10 * t1494
  t1498 = t10 * t191 * t585
  t1501 = t10 * t92 * t625
  t1504 = t10 * t92 * t717
  t1506 = t544 ** 2
  t1507 = 0.1e1 / t1506
  t1509 = t624 * t584
  t1512 = t10 * t15 * t16 * t1507 * t1509
  t1515 = t171 * t622 * t584 * t716
  t1516 = t170 * t1515
  t1517 = t519 * t521
  t1519 = t524 * t1220 * t1225
  t1523 = t577 * t1064 * t1069
  t1527 = t707 * t4 * t1076
  t1530 = t568 * t521
  t1535 = t576 ** 2
  t1579 = 0.16930471275192243253516934526314406233324633223330e3 * t1517 * t1519 + 0.98108878995850132274282363971149403050909652181336e2 * t1517 * t1523 + 0.37901493236147649856397125963483982862419753086423e2 * t1517 * t1527 - 0.19621775799170026454856472794229880610181930436268e3 * t1530 * t1523 - 0.37901493236147649856397125963483982862419753086423e2 * t1530 * t1527 + 0.73210661676733099976467339885674439871970736168272e1 * t1517 / t1535 * t7 * t1085 - 0.50791413825576729760550803578943218699973899669989e3 * t1530 * t1519 - 0.55468804540618892789532167012246569568000000000000e2 * t682 * t306 * t1120 * t521 * t524 + 0.25395706912788364880275401789471609349986949834995e3 * t515 * t1220 * t1222 * t1224 * t521 * t524 + 0.49054439497925066137141181985574701525454826090668e2 * t515 * t1064 * t1066 * t1068 * t521 * t577 - 0.45910941751869106328000000000000000000000000000000e2 * t566 * t295 - 0.46674600764814814814814814814814814814814814814816e1 * t640 * t1004 + 0.45910941751869106328000000000000000000000000000000e2 * t634 * t295 + 0.14002380229444444444444444444444444444444444444445e1 * t547 * t578 * t677 * t286 + 0.26142220278658220352633744855967078189300411522635e1 * t547 * t708 * t564 * t1204 - 0.72490960660845957360000000000000000000000000000000e1 * t633 * t678 * t127 - 0.70065858367097548786777474120732508928000000000000e2 * t634 * t1023
  t1627 = 0.1e1 / t504 / t1029 * t7
  t1631 = t11 * t119
  t1655 = t1034 * t512
  t1659 = t30 * t119 * t665
  t1670 = t508 ** 2
  t1676 = -0.62427427282697290666666666666666666666666666666667e0 * t1627 * t1033 * t506 + 0.20809142427565763555555555555555555555555555555556e0 * t646 * t1631 * t648 - 0.11806357937454381414504829629629629629629629629630e-2 * t6 / t30 * t12 * t1014 * t7 * t506 - 0.24277332832160057481481481481481481481481481481482e0 * t550 * t964 * t551 + 0.25973987462399639111910625185185185185185185185185e-1 * t59 * t1014 * t506 - 0.25722248709324423805258603198354014814814814814815e-2 * t32 * t1009 * t548 * t506 + 0.18192098917286773248000000000000000000000000000000e0 * t509 / t555 / t1029 * t1655 - 0.56850309116521166400000000000000000000000000000000e-1 * t663 * t1659 + 0.89455847415221057743399553280000000000000000000000e-1 * t1032 * t1655 + 0.22108453545313786933333333333333333333333333333333e0 * t558 * t8 * t146 * t560 - 0.24848846504228071595388764800000000000000000000000e-1 * t674 * t1659 + 0.32583736949879514768720843961791660800000000000000e-2 * t1670 / t22 / t19 * t1655
  t1680 = -0.13533946591611525499871930590222222222222222222223e2 * t633 * t639 * t1195 + 0.72490960660845957360000000000000000000000000000000e1 * t679 * t127 + 0.35032929183548774393388737060366254464000000000000e2 * t566 * t1023 + 0.13533946591611525499871930590222222222222222222223e2 * t640 * t1195 + 0.6e1 * t564 * t518 * t678 - 0.32707037596394519958023832259703703703703703703705e2 * t701 * t1113 + 0.14002380229444444444444444444444444444444444444445e1 * t630 * t579 * t148 + 0.17516464591774387196694368530183127232000000000000e2 * t514 * t29 * t304 * t305 * t33 * t310 * t565 - 0.72490960660845957360000000000000000000000000000000e1 * t629 * t517 * t569 * t136 + 0.72490960660845957360000000000000000000000000000000e1 * t630 * t569 * t136 + 0.22187521816247557115812866804898627827199999999999e3 * t689 * t1122 + 0.32707037596394519958023832259703703703703703703705e2 * t693 * t1113 - 0.56113373252284463289777777777777777777777777777778e2 * t570 * t1116 + 0.33709433885699588477366255144032921810699588477367e1 * t580 * t1107 + 0.56113373252284463289777777777777777777777777777778e2 * t573 * t1116 - 0.43570367131097033921056241426611796982167352537724e1 * t710 * t1191 - 0.11093760908123778557906433402449313913600000000000e3 * t698 * t1122 + 0.2e1 * t547 * t525 * t1676
  t1682 = f.my_piecewise3(t527, t1579 + t1680, 0)
  t1685 = t10 * t15 * t546 * t1682
  t1713 = t623 * t605
  t1730 = t752 ** 2
  t1734 = t605 / t1730 * t839 * t757
  t1739 = t745 * t837 * t839
  t1752 = t831 * t849
  t1763 = t173 / t601 / t1303 / t160 / t33 / t545 * t801 * t739 / 0.4e1
  t1767 = t173 * t800 * t739 * t817
  t1790 = t173 * t733 * (-0.28e2 / 0.27e2 * t175 * t1494 - 0.4e1 / 0.3e1 * t370 * t266 * t736 - 0.2e1 * t370 * t111 * t810 + t370 * t111 * t814 - 0.6e1 * t370 * t171 * t1507 * t1509 + 0.6e1 * t370 * t1515 - t370 * t171 * t545 * t1682)
  t1798 = t754 * (0.3e1 / 0.8e1 * t1763 - 0.3e1 / 0.4e1 * t1767 + t1790 / 0.2e1 - 0.28e2 / 0.27e2 * t1495 - 0.4e1 / 0.3e1 * t1498 - 0.2e1 * t1501 + t1504 - 0.6e1 * t1512 + 0.6e1 * t1516 - t1685)
  t1802 = -0.28e2 / 0.81e2 * t170 * t1014 * t609 + t426 * t789 * t753 * t716 * t757 - 0.2e1 / 0.3e1 * t1443 * t792 + 0.2e1 * t426 * t546 * t745 * t791 + 0.2e1 * t426 * t530 * t605 * t837 * t757 * t849 - 0.2e1 * t426 * t1713 * t753 * t624 * t757 + 0.2e1 * t426 * t1713 * t608 * t584 * t716 - t170 * t727 * t784 * t716 - t170 * t727 * t856 * t584 - 0.2e1 * t170 * t751 * t1734 + 0.2e1 * t170 * t751 * t1739 - 0.2e1 * t170 * t171 * t1507 * t728 * t1509 - 0.2e1 / 0.3e1 * t170 * t111 * t622 * t780 - t170 * t751 * t1752 - t170 * t751 * t1798 / 0.3e1
  t1827 = t1763 / 0.8e1 - t1767 / 0.4e1 + t1790 / 0.6e1 - 0.28e2 / 0.81e2 * t1495 - 0.4e1 / 0.9e1 * t1498 - 0.2e1 / 0.3e1 * t1501 + t1504 / 0.3e1 - 0.2e1 * t1512 + 0.2e1 * t1516 - t1685 / 0.3e1
  t1861 = t825 * t753 * t757
  t1868 = -t170 * t727 * t728 * t1682 / 0.3e1 + 0.2e1 * t170 * t779 * t784 * t624 + t170 * t775 * t850 / 0.3e1 + 0.2e1 / 0.3e1 * t170 * t775 * t832 + t170 * t171 * t529 * t1827 * t608 / 0.3e1 + 0.4e1 / 0.9e1 * t170 * t266 * t747 - t170 * t111 * t827 / 0.3e1 - 0.2e1 * t426 * t789 * t837 * t584 * t839 + t426 * t789 * t790 * t849 - 0.4e1 / 0.9e1 * t170 * t266 * t529 * t758 + 0.2e1 / 0.3e1 * t170 * t768 * t785 + t170 * t768 * t795 / 0.3e1 - 0.2e1 / 0.3e1 * t170 * t775 * t840 - t170 * t751 * t1861 - 0.4e1 / 0.9e1 * t170 * t266 * t545 * t729
  t1881 = -(t599 + t722 + t83 * t945 * t536 / 0.18e2 - t83 * t160 * t594 / 0.6e1 - t83 * t84 * t33 * t716 / 0.4e1) * t589 * t613 - 0.2e1 * t598 * t721 * t613 - 0.3e1 * t599 * t762 - t540 * (-0.14e2 / 0.81e2 * t1495 - 0.2e1 / 0.9e1 * t1498 - t1501 / 0.3e1 + t1504 / 0.6e1 - t1512 + t1516 - t1685 / 0.6e1) * t613 - 0.3e1 * t722 * t762 - 0.3e1 * t590 * t854 - t535 * (t1802 + t1868) + 0.2e1 * t1827 * t608 - 0.6e1 * t1861 + 0.12e2 * t1739 - 0.6e1 * t1752 - 0.12e2 * t1734 + 0.12e2 * t838 * t757 * t849 - 0.2e1 * t1798
  t1926 = t964 * t16
  t1952 = f.my_piecewise3(t534, 0, t5 * t1881 * t871 / 0.4e1 + 0.3e1 / 0.4e1 * t5 * t861 * t898 * t871 + 0.3e1 / 0.4e1 * t5 * t879 * t932 * t871 + 0.3e1 / 0.4e1 * t5 * t879 * t937 * t871 + t5 * t905 * (0.20e2 / 0.27e2 * t32 * t1009 * t867 + 0.5e1 / 0.3e1 * t32 * t261 * t894 + 0.3e1 * t32 * t882 * t915 - t32 * t882 * t928 + 0.6e1 * t32 * t862 / t912 / t865 * t914 * t893 - 0.9e1 / 0.2e1 * t31 * t160 * t33 * t913 * t893 * t927 + t32 * t862 * t887 * (-0.62601066666666666666666666666666666666666666666666e0 * t1627 * t1033 + 0.20867022222222222222222222222222222222222222222222e0 * t646 * t1631 * t33 - 0.24344859259259259259259259259259259259259259259259e0 * t550 * t1926 - 0.44934037037037037037037037037037037037037037037036e0 * t9 * t1926) / 0.2e1) * t871 / 0.4e1 + 0.3e1 / 0.4e1 * t5 * t905 * t932 * t898 * t871 + t5 * t905 * t937 * t898 * t871 / 0.4e1)
  v3rho3_0_ = 0.6e1 * t502 + 0.6e1 * t943 + r0 * (0.2e1 * t1475 + 0.2e1 * t1952)

  res = {'v3rho3': v3rho3_0_}
  return res
