"""Generated from gga_c_gaploc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_par1 = np.array([np.nan, 0.0471985, 1.49676, 0.00179054, -0.0324091, 0.00999978, -0.00193483, 0.000179118, -6.15798e-06, 0.015545, 0.064535], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  gap_t = lambda rs, z, xt: xt * f.n_total(rs) ** (1 / 6) / (4 * f.mphi(z) * (3 / jnp.pi) ** (1 / 6))

  gaploc_b = 14.709046

  gaploc_a1 = 6.54613 + 2

  gaploc_s = lambda xt: X2S * xt * 2 ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gaploc_alpha = lambda t: (gaploc_a1 + 3 * t ** 3) / (1 + t ** 3)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  gap_G = lambda rs, z, xt, par=None: (9 * jnp.pi / 4) ** (2 / 3) / 2.0 * gaploc_s(xt) ** gaploc_alpha(gap_t(rs, z, xt)) / rs ** 2 * (gaploc_b + gaploc_s(xt) ** 2) / (1 + gaploc_s(xt) ** gaploc_alpha(gap_t(rs, z, xt)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  gap_eps = lambda rs, z, xt, par: +(f_pw(rs, z) + gap_c1(rs, z, par) * gap_G(rs, z, xt, par)) / (1 + gap_c2(rs, z, par) * gap_G(rs, z, xt, par) + gap_c3(rs, z, par) * gap_G(rs, z, xt, par) ** 2)

  f_gap = lambda rs, z, xt: +gap_eps(rs, 0, xt, gap_par0) + f.f_zeta(z) * (gap_eps(rs, 1, xt, gap_par1) - gap_eps(rs, 0, xt, gap_par0))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_gap(rs, z, xt)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_par1 = np.array([np.nan, 0.0471985, 1.49676, 0.00179054, -0.0324091, 0.00999978, -0.00193483, 0.000179118, -6.15798e-06, 0.015545, 0.064535], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  gap_t = lambda rs, z, xt: xt * f.n_total(rs) ** (1 / 6) / (4 * f.mphi(z) * (3 / jnp.pi) ** (1 / 6))

  gaploc_b = 14.709046

  gaploc_a1 = 6.54613 + 2

  gaploc_s = lambda xt: X2S * xt * 2 ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gaploc_alpha = lambda t: (gaploc_a1 + 3 * t ** 3) / (1 + t ** 3)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  gap_G = lambda rs, z, xt, par=None: (9 * jnp.pi / 4) ** (2 / 3) / 2.0 * gaploc_s(xt) ** gaploc_alpha(gap_t(rs, z, xt)) / rs ** 2 * (gaploc_b + gaploc_s(xt) ** 2) / (1 + gaploc_s(xt) ** gaploc_alpha(gap_t(rs, z, xt)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  gap_eps = lambda rs, z, xt, par: +(f_pw(rs, z) + gap_c1(rs, z, par) * gap_G(rs, z, xt, par)) / (1 + gap_c2(rs, z, par) * gap_G(rs, z, xt, par) + gap_c3(rs, z, par) * gap_G(rs, z, xt, par) ** 2)

  f_gap = lambda rs, z, xt: +gap_eps(rs, 0, xt, gap_par0) + f.f_zeta(z) * (gap_eps(rs, 1, xt, gap_par1) - gap_eps(rs, 0, xt, gap_par0))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_gap(rs, z, xt)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t13 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t23 = 0.1e1 / t22
  t25 = t21 * t5 * t23
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t11 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t27
  t31 = jnp.log(t30)
  t33 = 0.62182e-1 * t13 * t31
  t34 = 0.1e1 <= f.p.zeta_threshold
  t35 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t36 = t35 * f.p.zeta_threshold
  t37 = f.my_piecewise3(t34, t36, 1)
  t40 = 2 ** (0.1e1 / 0.3e1)
  t43 = 0.1e1 / (0.2e1 * t40 - 0.2e1)
  t44 = (0.2e1 * t37 - 0.2e1) * t43
  t46 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t11
  t51 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t11 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t54 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t51
  t55 = jnp.log(t54)
  t56 = t46 * t55
  t58 = 0.19751789702565206228825776161588751761046270558698e-1 * t44 * t56
  t59 = t3 * t2
  t60 = 0.1e1 / t59
  t61 = t19 * t60
  t62 = t8 * t7
  t63 = t6 * t62
  t64 = 0.1e1 / t7
  t65 = t2 * t64
  t68 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t14 + 0.12382500000000000000000000000000000000000000000000e-1 * t11
  t71 = 0.1e1 + t14 * t68 / 0.2e1
  t72 = t71 ** 2
  t73 = 0.1e1 / t72
  t76 = -t33 + t58
  t78 = t1 * t59
  t79 = 0.1e1 / t62
  t80 = t6 * t79
  t81 = t78 * t80
  t84 = t19 * t20 * t2
  t87 = t5 / t22 / t7
  t88 = t84 * t87
  t90 = jnp.pi ** 2
  t91 = 0.1e1 / t90
  t92 = t7 ** 2
  t93 = 0.1e1 / t92
  t94 = t91 * t93
  t97 = t1 * t3 * t91
  t99 = 0.1e1 / t8 / t92
  t100 = t6 * t99
  t101 = t97 * t100
  t103 = -0.18780000000000000000000000000000000000000000000000e-1 * t65 + 0.13173750000000000000000000000000000000000000000000e-2 * t81 - 0.23775000000000000000000000000000000000000000000000e-3 * t88 + 0.63900000000000000000000000000000000000000000000000e-4 * t94 - 0.54014062500000000000000000000000000000000000000000e-6 * t101
  t105 = 0.36798313500000000000000000000000000000000000000000e-2 * t65 * t73 - t76 * t103
  t108 = 0.1e1 / t20
  t109 = t1 * t108
  t110 = 4 ** (0.1e1 / 0.6e1)
  t111 = t109 * t110
  t112 = t14 * t11
  t113 = t22 * t112
  t114 = 0.1e1 / t71
  t118 = t76 ** 2
  t120 = 0.19711288999999999999999999999999999999999999999999e-2 * t111 * t113 * t114 - 0.2e1 * t118
  t121 = 0.1e1 / t120
  t122 = 9 ** (0.1e1 / 0.3e1)
  t123 = t122 ** 2
  t124 = t121 * t123
  t125 = jnp.pi ** (0.1e1 / 0.3e1)
  t126 = t125 ** 2
  t128 = 6 ** (0.1e1 / 0.3e1)
  t129 = t128 ** 2
  t130 = t90 ** (0.1e1 / 0.3e1)
  t134 = s0 + 0.2e1 * s1 + s2
  t135 = jnp.sqrt(t134)
  t139 = t129 / t130 * t135 * t79 * t40 / 0.12e2
  t140 = t135 * t134
  t141 = t92 * t7
  t142 = jnp.sqrt(t7)
  t144 = 0.1e1 / t142 / t141
  t145 = t140 * t144
  t146 = t35 ** 2
  t147 = f.my_piecewise3(t34, t146, 1)
  t148 = t147 ** 2
  t150 = 0.1e1 / t148 / t147
  t151 = jnp.sqrt(0.3e1)
  t153 = jnp.sqrt(t2)
  t154 = 0.1e1 / t153
  t156 = t145 * t150 * t151 * t154
  t158 = 0.854613e1 + t156 / 0.64e2
  t160 = 0.1e1 + t156 / 0.192e3
  t161 = 0.1e1 / t160
  t162 = t158 * t161
  t163 = t139 ** t162
  t164 = t130 ** 2
  t165 = 0.1e1 / t164
  t166 = t128 * t165
  t168 = 0.1e1 / t22 / t92
  t170 = t40 ** 2
  t174 = 0.14709046e2 + t166 * t134 * t168 * t170 / 0.24e2
  t176 = 0.1e1 + t163
  t177 = 0.1e1 / t176
  t179 = t124 * t126 * t163 * t174 * t177
  t182 = -t33 + t58 + 0.13265555555555555555555555555555555555555555555555e-1 * t61 * t63 * t105 * t179
  t183 = jnp.sqrt(0.4e1)
  t184 = t76 * t183
  t185 = t112 * t114
  t188 = t6 * t22
  t192 = 0.61912500000000000000000000000000000000000000000000e-2 * t184 * t185 - 0.79593333333333333333333333333333333333333333333331e-1 * t109 * t188 * t103
  t193 = t192 * t121
  t194 = t123 * t126
  t195 = t194 * t163
  t196 = t193 * t195
  t197 = t22 * t174
  t198 = t197 * t177
  t199 = t109 * t198
  t202 = t105 * t121
  t203 = t125 * jnp.pi
  t204 = t122 * t203
  t205 = t163 ** 2
  t206 = t204 * t205
  t207 = t202 * t206
  t208 = t174 ** 2
  t209 = t62 * t208
  t210 = t176 ** 2
  t211 = 0.1e1 / t210
  t213 = t61 * t209 * t211
  t216 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t196 * t199 - 0.25000000000000000000000000000000000000000000000001e0 * t207 * t213
  t217 = 0.1e1 / t216
  t218 = t182 * t217
  t219 = r0 - r1
  t220 = t219 * t64
  t221 = 0.1e1 + t220
  t222 = t221 <= f.p.zeta_threshold
  t223 = t221 ** (0.1e1 / 0.3e1)
  t225 = f.my_piecewise3(t222, t36, t223 * t221)
  t226 = 0.1e1 - t220
  t227 = t226 <= f.p.zeta_threshold
  t228 = t226 ** (0.1e1 / 0.3e1)
  t230 = f.my_piecewise3(t227, t36, t228 * t226)
  t232 = (t225 + t230 - 0.2e1) * t43
  t233 = 0.2e1 <= f.p.zeta_threshold
  t235 = f.my_piecewise3(t233, t36, 0.2e1 * t40)
  t236 = 0.0e0 <= f.p.zeta_threshold
  t237 = f.my_piecewise3(t236, t36, 0)
  t239 = (t235 + t237 - 0.2e1) * t43
  t241 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t11
  t246 = 0.70594500000000000000000000000000000000000000000000e1 * t14 + 0.15494250000000000000000000000000000000000000000000e1 * t11 + 0.42077500000000000000000000000000000000000000000000e0 * t17 + 0.15629250000000000000000000000000000000000000000000e0 * t25
  t249 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t246
  t250 = jnp.log(t249)
  t255 = t239 * (-0.31090e-1 * t241 * t250 + t33 - 0.19751789702565206228825776161588751761046270558698e-1 * t56)
  t257 = 0.19751789702565206228825776161588751761046270558698e-1 * t239 * t56
  t260 = 0.149676e1 + 0.89527000000000000000000000000000000000000000000000e-3 * t14 + 0.11799625000000000000000000000000000000000000000000e-1 * t11
  t263 = 0.1e1 + t14 * t260 / 0.2e1
  t264 = t263 ** 2
  t265 = 0.1e1 / t264
  t268 = -t33 + t255 + t257
  t274 = -0.24306825000000000000000000000000000000000000000000e-1 * t65 + 0.18749587500000000000000000000000000000000000000000e-2 * t81 - 0.36278062500000000000000000000000000000000000000000e-3 * t88 + 0.10075387500000000000000000000000000000000000000000e-3 * t94 - 0.86596593750000000000000000000000000000000000000000e-6 * t101
  t276 = 0.33415476033750000000000000000000000000000000000000e-2 * t65 * t265 - t268 * t274
  t279 = 0.1e1 / t263
  t283 = t268 ** 2
  t285 = 0.50765919958333333333333333333333333333333333333334e-3 * t111 * t113 * t279 - 0.2e1 * t283
  t286 = 0.1e1 / t285
  t287 = t286 * t123
  t289 = f.my_piecewise3(t233, t146, t170)
  t290 = f.my_piecewise3(t236, t146, 0)
  t292 = t289 / 0.2e1 + t290 / 0.2e1
  t293 = t292 ** 2
  t295 = 0.1e1 / t293 / t292
  t298 = t145 * t295 * t151 * t154
  t300 = 0.854613e1 + t298 / 0.64e2
  t302 = 0.1e1 + t298 / 0.192e3
  t303 = 0.1e1 / t302
  t304 = t300 * t303
  t305 = t139 ** t304
  t307 = 0.1e1 + t305
  t308 = 0.1e1 / t307
  t310 = t287 * t126 * t305 * t174 * t308
  t313 = -t33 + t255 + t257 + 0.35852777777777777777777777777777777777777777777779e-2 * t61 * t63 * t276 * t310
  t314 = t268 * t183
  t315 = t112 * t279
  t321 = 0.58998125000000000000000000000000000000000000000000e-2 * t314 * t315 - 0.21511666666666666666666666666666666666666666666667e-1 * t109 * t188 * t274
  t322 = t321 * t286
  t323 = t194 * t305
  t324 = t322 * t323
  t325 = t197 * t308
  t326 = t109 * t325
  t329 = t276 * t286
  t330 = t305 ** 2
  t331 = t204 * t330
  t332 = t329 * t331
  t333 = t307 ** 2
  t334 = 0.1e1 / t333
  t336 = t61 * t209 * t334
  t339 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t324 * t326 - 0.25000000000000000000000000000000000000000000000001e0 * t332 * t336
  t340 = 0.1e1 / t339
  t342 = t313 * t340 - t218
  t343 = t232 * t342
  t346 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t80 * t31
  t347 = t27 ** 2
  t350 = 0.1e1 / t14
  t352 = t3 * t6
  t353 = t352 * t79
  t354 = t350 * t1 * t353
  t356 = t4 * t80
  t358 = t11 ** 0.5e0
  t360 = t358 * t1 * t353
  t362 = t21 * t87
  t368 = 0.10000000000000000000000000000000000000000000000000e1 * t13 / t347 * (-0.63297500000000000000000000000000000000000000000000e0 * t354 - 0.29896666666666666666666666666666666666666666666667e0 * t356 - 0.10238750000000000000000000000000000000000000000000e0 * t360 - 0.82156666666666666666666666666666666666666666666667e-1 * t362) / t30
  t371 = t352 * t79 * t55
  t373 = 0.18311555036753159941307229983139571945136646663793e-3 * t44 * t1 * t371
  t375 = t51 ** 2
  t376 = 0.1e1 / t375
  t381 = -0.86308333333333333333333333333333333333333333333334e0 * t354 - 0.30192500000000000000000000000000000000000000000000e0 * t356 - 0.55016250000000000000000000000000000000000000000000e-1 * t360 - 0.82785000000000000000000000000000000000000000000000e-1 * t362
  t383 = 0.1e1 / t54
  t384 = t376 * t381 * t383
  t386 = 0.58482233974552040708313425006184496242808878304903e0 * t44 * t46 * t384
  t387 = t6 * t8
  t392 = t2 * t93
  t406 = -t350 * t68 * t1 * t353 / 0.12e2 + t14 * (-0.66066666666666666666666666666666666666666666666667e-2 * t354 - 0.41275000000000000000000000000000000000000000000000e-2 * t356) / 0.2e1
  t410 = t346 + t368 - t373 - t386
  t413 = t78 * t100
  t416 = t84 * t5 * t168
  t418 = 0.1e1 / t141
  t419 = t91 * t418
  t424 = t97 * t6 / t8 / t141
  t426 = 0.18780000000000000000000000000000000000000000000000e-1 * t392 - 0.17565000000000000000000000000000000000000000000000e-2 * t413 + 0.39625000000000000000000000000000000000000000000000e-3 * t416 - 0.12780000000000000000000000000000000000000000000000e-3 * t419 + 0.12603281250000000000000000000000000000000000000000e-5 * t424
  t428 = -0.36798313500000000000000000000000000000000000000000e-2 * t392 * t73 - 0.73596627000000000000000000000000000000000000000000e-2 * t65 / t72 / t71 * t406 - t410 * t103 - t76 * t426
  t433 = t61 * t6
  t434 = t62 * t105
  t435 = t120 ** 2
  t436 = 0.1e1 / t435
  t440 = t9 * t112
  t446 = t110 ** 2
  t447 = t446 ** 2
  t449 = t19 / t3 * t447 * t110
  t450 = t23 * t14
  t460 = 0.13140859333333333333333333333333333333333333333333e-2 * t111 * t440 * t114 - 0.98556444999999999999999999999999999999999999999995e-3 * t449 * t450 * t114 - 0.19711288999999999999999999999999999999999999999999e-2 * t111 * t113 * t73 * t406 - 0.4e1 * t76 * t410
  t461 = t174 * t177 * t460
  t466 = t433 * t434 * t121
  t467 = t92 ** 2
  t469 = 0.1e1 / t142 / t467
  t470 = t140 * t469
  t472 = t151 * t154
  t473 = t472 * t161
  t476 = t160 ** 2
  t478 = t158 / t476
  t485 = jnp.log(t139)
  t489 = (-0.7e1 / 0.128e3 * t470 * t150 * t473 + 0.7e1 / 0.384e3 * t478 * t140 * t469 * t150 * t472) * t485 - 0.4e1 / 0.3e1 * t162 * t64
  t498 = t126 * t163
  t500 = t165 * t134
  t501 = t170 * t177
  t502 = t500 * t501
  t506 = t194 * t205
  t507 = t174 * t211
  t508 = t507 * t489
  t513 = (t346 + t368 - t373 - t386 + 0.17687407407407407407407407407407407407407407407407e-1 * t61 * t387 * t105 * t179 + 0.13265555555555555555555555555555555555555555555555e-1 * t61 * t63 * t428 * t179 - 0.13265555555555555555555555555555555555555555555555e-1 * t433 * t434 * t436 * t195 * t461 + 0.13265555555555555555555555555555555555555555555555e-1 * t466 * t195 * t489 * t174 * t177 - 0.14739506172839506172839506172839506172839506172839e-2 * t433 * t99 * t105 * t124 * t498 * t128 * t502 - 0.13265555555555555555555555555555555555555555555555e-1 * t466 * t506 * t508) * t217
  t514 = t216 ** 2
  t516 = t182 / t514
  t523 = t3 * t79
  t544 = t109 * t22
  t553 = t9 * t174
  t560 = t193 * t123 * t498 * t1
  t562 = t108 * t418 * t128
  t566 = t193 * t506
  t576 = t61 * t62
  t577 = t208 * t211
  t586 = t8 * t208
  t591 = t202 * t122
  t592 = t203 * t205
  t595 = t99 * t174
  t598 = t166 * t134 * t170
  t604 = t202 * t204 * t205 * t163
  t607 = t208 / t210 / t176
  t612 = 0.16666666666666666666666666666666666666666666666667e0 * (0.61912500000000000000000000000000000000000000000000e-2 * t410 * t183 * t185 - 0.12382500000000000000000000000000000000000000000000e-1 * t76 * t110 * t14 * t114 * t1 * t523 - 0.61912500000000000000000000000000000000000000000000e-2 * t184 * t112 * t73 * t406 - 0.53062222222222222222222222222222222222222222222221e-1 * t109 * t10 * t103 - 0.79593333333333333333333333333333333333333333333331e-1 * t109 * t188 * t426) * t121 * t195 * t199 - 0.16666666666666666666666666666666666666666666666667e0 * t192 * t436 * t195 * t544 * t461 + 0.16666666666666666666666666666666666666666666666667e0 * t196 * t489 * t1 * t108 * t198 + 0.11111111111111111111111111111111111111111111111111e0 * t196 * t109 * t553 * t177 - 0.18518518518518518518518518518518518518518518518519e-1 * t560 * t562 * t502 - 0.16666666666666666666666666666666666666666666666667e0 * t566 * t544 * t508 - 0.25000000000000000000000000000000000000000000000001e0 * t428 * t121 * t206 * t213 + 0.25000000000000000000000000000000000000000000000001e0 * t105 * t436 * t206 * t576 * t577 * t460 - 0.50000000000000000000000000000000000000000000000002e0 * t207 * t576 * t577 * t489 - 0.33333333333333333333333333333333333333333333333335e0 * t207 * t61 * t586 * t211 + 0.55555555555555555555555555555555555555555555555558e-1 * t591 * t592 * t61 * t595 * t211 * t598 + 0.50000000000000000000000000000000000000000000000002e0 * t604 * t576 * t607 * t489
  t613 = t516 * t612
  t614 = t219 * t93
  t615 = t64 - t614
  t618 = f.my_piecewise3(t222, 0, 0.4e1 / 0.3e1 * t223 * t615)
  t622 = f.my_piecewise3(t227, 0, -0.4e1 / 0.3e1 * t228 * t615)
  t629 = t246 ** 2
  t649 = t239 * (0.53236443333333333333333333333333333333333333333332e-3 * t4 * t80 * t250 + 0.99999999999999999999999999999999999999999999999999e0 * t241 / t629 * (-0.11765750000000000000000000000000000000000000000000e1 * t354 - 0.51647500000000000000000000000000000000000000000000e0 * t356 - 0.21038750000000000000000000000000000000000000000000e0 * t360 - 0.10419500000000000000000000000000000000000000000000e0 * t362) / t249 - t346 - t368 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t80 * t55 + 0.58482233974552040708313425006184496242808878304903e0 * t46 * t376 * t381 * t383)
  t652 = 0.18311555036753159941307229983139571945136646663793e-3 * t239 * t1 * t371
  t655 = 0.58482233974552040708313425006184496242808878304903e0 * t239 * t46 * t384
  t673 = -t350 * t260 * t1 * t353 / 0.12e2 + t14 * (-0.14921166666666666666666666666666666666666666666667e-3 * t354 - 0.39332083333333333333333333333333333333333333333333e-2 * t356) / 0.2e1
  t677 = t346 + t368 + t649 - t652 - t655
  t684 = 0.24306825000000000000000000000000000000000000000000e-1 * t392 - 0.24999450000000000000000000000000000000000000000000e-2 * t413 + 0.60463437500000000000000000000000000000000000000000e-3 * t416 - 0.20150775000000000000000000000000000000000000000000e-3 * t419 + 0.20205871875000000000000000000000000000000000000000e-5 * t424
  t686 = -0.33415476033750000000000000000000000000000000000000e-2 * t392 * t265 - 0.66830952067500000000000000000000000000000000000000e-2 * t65 / t264 / t263 * t673 - t677 * t274 - t268 * t684
  t691 = t62 * t276
  t692 = t285 ** 2
  t693 = 0.1e1 / t692
  t709 = 0.33843946638888888888888888888888888888888888888889e-3 * t111 * t440 * t279 - 0.25382959979166666666666666666666666666666666666667e-3 * t449 * t450 * t279 - 0.50765919958333333333333333333333333333333333333334e-3 * t111 * t113 * t265 * t673 - 0.4e1 * t268 * t677
  t710 = t174 * t308 * t709
  t715 = t433 * t691 * t286
  t717 = t472 * t303
  t720 = t302 ** 2
  t722 = t300 / t720
  t732 = (-0.7e1 / 0.128e3 * t470 * t295 * t717 + 0.7e1 / 0.384e3 * t722 * t140 * t469 * t295 * t472) * t485 - 0.4e1 / 0.3e1 * t304 * t64
  t741 = t126 * t305
  t743 = t170 * t308
  t744 = t500 * t743
  t748 = t194 * t330
  t749 = t174 * t334
  t750 = t749 * t732
  t754 = t346 + t368 + t649 - t652 - t655 + 0.47803703703703703703703703703703703703703703703705e-2 * t61 * t387 * t276 * t310 + 0.35852777777777777777777777777777777777777777777779e-2 * t61 * t63 * t686 * t310 - 0.35852777777777777777777777777777777777777777777779e-2 * t433 * t691 * t693 * t323 * t710 + 0.35852777777777777777777777777777777777777777777779e-2 * t715 * t323 * t732 * t174 * t308 - 0.39836419753086419753086419753086419753086419753088e-3 * t433 * t99 * t276 * t287 * t741 * t128 * t744 - 0.35852777777777777777777777777777777777777777777779e-2 * t715 * t748 * t750
  t756 = t339 ** 2
  t758 = t313 / t756
  t799 = t322 * t123 * t741 * t1
  t803 = t322 * t748
  t813 = t208 * t334
  t826 = t329 * t122
  t827 = t203 * t330
  t836 = t329 * t204 * t330 * t305
  t839 = t208 / t333 / t307
  t844 = 0.16666666666666666666666666666666666666666666666667e0 * (0.58998125000000000000000000000000000000000000000000e-2 * t677 * t183 * t315 - 0.11799625000000000000000000000000000000000000000000e-1 * t268 * t110 * t14 * t279 * t1 * t523 - 0.58998125000000000000000000000000000000000000000000e-2 * t314 * t112 * t265 * t673 - 0.14341111111111111111111111111111111111111111111111e-1 * t109 * t10 * t274 - 0.21511666666666666666666666666666666666666666666667e-1 * t109 * t188 * t684) * t286 * t323 * t326 - 0.16666666666666666666666666666666666666666666666667e0 * t321 * t693 * t323 * t544 * t710 + 0.16666666666666666666666666666666666666666666666667e0 * t324 * t732 * t1 * t108 * t325 + 0.11111111111111111111111111111111111111111111111111e0 * t324 * t109 * t553 * t308 - 0.18518518518518518518518518518518518518518518518519e-1 * t799 * t562 * t744 - 0.16666666666666666666666666666666666666666666666667e0 * t803 * t544 * t750 - 0.25000000000000000000000000000000000000000000000001e0 * t686 * t286 * t331 * t336 + 0.25000000000000000000000000000000000000000000000001e0 * t276 * t693 * t331 * t576 * t813 * t709 - 0.50000000000000000000000000000000000000000000000002e0 * t332 * t576 * t813 * t732 - 0.33333333333333333333333333333333333333333333333335e0 * t332 * t61 * t586 * t334 + 0.55555555555555555555555555555555555555555555555558e-1 * t826 * t827 * t61 * t595 * t334 * t598 + 0.50000000000000000000000000000000000000000000000002e0 * t836 * t576 * t839 * t732
  t847 = t232 * (t754 * t340 - t758 * t844 - t513 + t613)
  vrho_0_ = t218 + t343 + t7 * (t513 - t613 + (t618 + t622) * t43 * t342 + t847)
  t850 = -t64 - t614
  t853 = f.my_piecewise3(t222, 0, 0.4e1 / 0.3e1 * t223 * t850)
  t857 = f.my_piecewise3(t227, 0, -0.4e1 / 0.3e1 * t228 * t850)
  vrho_1_ = t218 + t343 + t7 * (t513 - t613 + (t853 + t857) * t43 * t342 + t847)
  t863 = t135 * t144
  t865 = t863 * t150 * t473
  t870 = t478 * t135 * t144 * t150 * t472
  t874 = 0.1e1 / t134
  t875 = t162 * t874
  t877 = (0.3e1 / 0.128e3 * t865 - t870 / 0.128e3) * t485 + t875 / 0.2e1
  t888 = t433 * t79 * t105 * t121 * t195 * t166 * t501
  t890 = t507 * t877
  t895 = (0.13265555555555555555555555555555555555555555555555e-1 * t466 * t195 * t877 * t174 * t177 + 0.55273148148148148148148148148148148148148148148146e-3 * t888 - 0.13265555555555555555555555555555555555555555555555e-1 * t466 * t506 * t890) * t217
  t902 = t108 * t93 * t128
  t903 = t165 * t170
  t906 = t560 * t902 * t903 * t177
  t918 = t60 * t79 * t174
  t922 = t591 * t592 * t19 * t918 * t211 * t128 * t903
  t929 = t516 * (0.16666666666666666666666666666666666666666666666667e0 * t196 * t877 * t1 * t108 * t198 + 0.69444444444444444444444444444444444444444444444446e-2 * t906 - 0.16666666666666666666666666666666666666666666666667e0 * t566 * t544 * t890 - 0.50000000000000000000000000000000000000000000000002e0 * t207 * t576 * t577 * t877 - 0.20833333333333333333333333333333333333333333333334e-1 * t922 + 0.50000000000000000000000000000000000000000000000002e0 * t604 * t576 * t607 * t877)
  t931 = t863 * t295 * t717
  t936 = t722 * t135 * t144 * t295 * t472
  t940 = t304 * t874
  t942 = (0.3e1 / 0.128e3 * t931 - t936 / 0.128e3) * t485 + t940 / 0.2e1
  t953 = t433 * t79 * t276 * t286 * t323 * t166 * t743
  t955 = t749 * t942
  t968 = t799 * t902 * t903 * t308
  t982 = t826 * t827 * t19 * t918 * t334 * t128 * t903
  vsigma_0_ = t7 * (t895 - t929 + t232 * ((0.35852777777777777777777777777777777777777777777779e-2 * t715 * t323 * t942 * t174 * t308 + 0.14938657407407407407407407407407407407407407407408e-3 * t953 - 0.35852777777777777777777777777777777777777777777779e-2 * t715 * t748 * t955) * t340 - t758 * (0.16666666666666666666666666666666666666666666666667e0 * t324 * t942 * t1 * t108 * t325 + 0.69444444444444444444444444444444444444444444444446e-2 * t968 - 0.16666666666666666666666666666666666666666666666667e0 * t803 * t544 * t955 - 0.50000000000000000000000000000000000000000000000002e0 * t332 * t576 * t813 * t942 - 0.20833333333333333333333333333333333333333333333334e-1 * t982 + 0.50000000000000000000000000000000000000000000000002e0 * t836 * t576 * t839 * t942) - t895 + t929))
  t997 = (0.3e1 / 0.64e2 * t865 - t870 / 0.64e2) * t485 + t875
  t1004 = t507 * t997
  t1009 = (0.13265555555555555555555555555555555555555555555555e-1 * t466 * t195 * t997 * t174 * t177 + 0.11054629629629629629629629629629629629629629629629e-2 * t888 - 0.13265555555555555555555555555555555555555555555555e-1 * t466 * t506 * t1004) * t217
  t1029 = t516 * (0.16666666666666666666666666666666666666666666666667e0 * t196 * t997 * t1 * t108 * t198 + 0.13888888888888888888888888888888888888888888888889e-1 * t906 - 0.16666666666666666666666666666666666666666666666667e0 * t566 * t544 * t1004 - 0.50000000000000000000000000000000000000000000000002e0 * t207 * t576 * t577 * t997 - 0.41666666666666666666666666666666666666666666666668e-1 * t922 + 0.50000000000000000000000000000000000000000000000002e0 * t604 * t576 * t607 * t997)
  t1034 = (0.3e1 / 0.64e2 * t931 - t936 / 0.64e2) * t485 + t940
  t1041 = t749 * t1034
  vsigma_1_ = t7 * (t1009 - t1029 + t232 * ((0.35852777777777777777777777777777777777777777777779e-2 * t715 * t323 * t1034 * t174 * t308 + 0.29877314814814814814814814814814814814814814814816e-3 * t953 - 0.35852777777777777777777777777777777777777777777779e-2 * t715 * t748 * t1041) * t340 - t758 * (0.16666666666666666666666666666666666666666666666667e0 * t324 * t1034 * t1 * t108 * t325 + 0.13888888888888888888888888888888888888888888888889e-1 * t968 - 0.16666666666666666666666666666666666666666666666667e0 * t803 * t544 * t1041 - 0.50000000000000000000000000000000000000000000000002e0 * t332 * t576 * t813 * t1034 - 0.41666666666666666666666666666666666666666666666668e-1 * t982 + 0.50000000000000000000000000000000000000000000000002e0 * t836 * t576 * t839 * t1034) - t1009 + t1029))
  vsigma_2_ = vsigma_0_

  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t22 = 0.1e1 / t21
  t24 = t20 * t5 * t22
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t29 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t26
  t30 = jnp.log(t29)
  t32 = 0.62182e-1 * t12 * t30
  t33 = 0.1e1 <= f.p.zeta_threshold
  t34 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t35 = t34 * f.p.zeta_threshold
  t36 = f.my_piecewise3(t33, t35, 1)
  t39 = 2 ** (0.1e1 / 0.3e1)
  t42 = 0.1e1 / (0.2e1 * t39 - 0.2e1)
  t43 = (0.2e1 * t36 - 0.2e1) * t42
  t45 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t50 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t53 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t50
  t54 = jnp.log(t53)
  t55 = t45 * t54
  t57 = 0.19751789702565206228825776161588751761046270558698e-1 * t43 * t55
  t58 = t3 * t2
  t59 = 0.1e1 / t58
  t60 = t18 * t59
  t61 = t7 * r0
  t62 = t6 * t61
  t63 = 0.1e1 / r0
  t64 = t2 * t63
  t67 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t13 + 0.12382500000000000000000000000000000000000000000000e-1 * t10
  t70 = 0.1e1 + t13 * t67 / 0.2e1
  t71 = t70 ** 2
  t72 = 0.1e1 / t71
  t75 = -t32 + t57
  t77 = t1 * t58
  t78 = 0.1e1 / t61
  t79 = t6 * t78
  t80 = t77 * t79
  t83 = t18 * t19 * t2
  t86 = t5 / t21 / r0
  t87 = t83 * t86
  t89 = jnp.pi ** 2
  t90 = 0.1e1 / t89
  t91 = r0 ** 2
  t92 = 0.1e1 / t91
  t93 = t90 * t92
  t96 = t1 * t3 * t90
  t98 = 0.1e1 / t7 / t91
  t99 = t6 * t98
  t100 = t96 * t99
  t102 = -0.18780000000000000000000000000000000000000000000000e-1 * t64 + 0.13173750000000000000000000000000000000000000000000e-2 * t80 - 0.23775000000000000000000000000000000000000000000000e-3 * t87 + 0.63900000000000000000000000000000000000000000000000e-4 * t93 - 0.54014062500000000000000000000000000000000000000000e-6 * t100
  t104 = 0.36798313500000000000000000000000000000000000000000e-2 * t64 * t72 - t75 * t102
  t107 = 0.1e1 / t19
  t108 = t1 * t107
  t109 = 4 ** (0.1e1 / 0.6e1)
  t110 = t108 * t109
  t111 = t13 * t10
  t112 = t21 * t111
  t113 = 0.1e1 / t70
  t117 = t75 ** 2
  t119 = 0.19711288999999999999999999999999999999999999999999e-2 * t110 * t112 * t113 - 0.2e1 * t117
  t120 = 0.1e1 / t119
  t121 = 9 ** (0.1e1 / 0.3e1)
  t122 = t121 ** 2
  t123 = t120 * t122
  t124 = jnp.pi ** (0.1e1 / 0.3e1)
  t125 = t124 ** 2
  t127 = 6 ** (0.1e1 / 0.3e1)
  t128 = t127 ** 2
  t129 = t89 ** (0.1e1 / 0.3e1)
  t132 = jnp.sqrt(s0)
  t136 = t128 / t129 * t132 * t78 * t39 / 0.12e2
  t137 = t132 * s0
  t138 = t91 * r0
  t139 = jnp.sqrt(r0)
  t141 = 0.1e1 / t139 / t138
  t142 = t137 * t141
  t143 = t34 ** 2
  t144 = f.my_piecewise3(t33, t143, 1)
  t145 = t144 ** 2
  t147 = 0.1e1 / t145 / t144
  t148 = jnp.sqrt(0.3e1)
  t150 = jnp.sqrt(t2)
  t151 = 0.1e1 / t150
  t153 = t142 * t147 * t148 * t151
  t155 = 0.854613e1 + t153 / 0.64e2
  t157 = 0.1e1 + t153 / 0.192e3
  t158 = 0.1e1 / t157
  t159 = t155 * t158
  t160 = t136 ** t159
  t161 = t129 ** 2
  t162 = 0.1e1 / t161
  t163 = t127 * t162
  t165 = 0.1e1 / t21 / t91
  t167 = t39 ** 2
  t171 = 0.14709046e2 + t163 * s0 * t165 * t167 / 0.24e2
  t173 = 0.1e1 + t160
  t174 = 0.1e1 / t173
  t176 = t123 * t125 * t160 * t171 * t174
  t179 = -t32 + t57 + 0.13265555555555555555555555555555555555555555555555e-1 * t60 * t62 * t104 * t176
  t180 = jnp.sqrt(0.4e1)
  t181 = t75 * t180
  t182 = t111 * t113
  t185 = t6 * t21
  t189 = 0.61912500000000000000000000000000000000000000000000e-2 * t181 * t182 - 0.79593333333333333333333333333333333333333333333331e-1 * t108 * t185 * t102
  t190 = t189 * t120
  t191 = t122 * t125
  t192 = t191 * t160
  t193 = t190 * t192
  t194 = t21 * t171
  t195 = t194 * t174
  t196 = t108 * t195
  t199 = t104 * t120
  t200 = t124 * jnp.pi
  t201 = t121 * t200
  t202 = t160 ** 2
  t203 = t201 * t202
  t204 = t199 * t203
  t205 = t171 ** 2
  t206 = t61 * t205
  t207 = t173 ** 2
  t208 = 0.1e1 / t207
  t210 = t60 * t206 * t208
  t213 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t193 * t196 - 0.25000000000000000000000000000000000000000000000001e0 * t204 * t210
  t214 = 0.1e1 / t213
  t215 = t179 * t214
  t216 = 0.2e1 <= f.p.zeta_threshold
  t218 = f.my_piecewise3(t216, t35, 0.2e1 * t39)
  t219 = 0.0e0 <= f.p.zeta_threshold
  t220 = f.my_piecewise3(t219, t35, 0)
  t222 = (t218 + t220 - 0.2e1) * t42
  t224 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t10
  t229 = 0.70594500000000000000000000000000000000000000000000e1 * t13 + 0.15494250000000000000000000000000000000000000000000e1 * t10 + 0.42077500000000000000000000000000000000000000000000e0 * t16 + 0.15629250000000000000000000000000000000000000000000e0 * t24
  t232 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t229
  t233 = jnp.log(t232)
  t238 = t222 * (-0.31090e-1 * t224 * t233 + t32 - 0.19751789702565206228825776161588751761046270558698e-1 * t55)
  t240 = 0.19751789702565206228825776161588751761046270558698e-1 * t222 * t55
  t243 = 0.149676e1 + 0.89527000000000000000000000000000000000000000000000e-3 * t13 + 0.11799625000000000000000000000000000000000000000000e-1 * t10
  t246 = 0.1e1 + t13 * t243 / 0.2e1
  t247 = t246 ** 2
  t248 = 0.1e1 / t247
  t251 = -t32 + t238 + t240
  t257 = -0.24306825000000000000000000000000000000000000000000e-1 * t64 + 0.18749587500000000000000000000000000000000000000000e-2 * t80 - 0.36278062500000000000000000000000000000000000000000e-3 * t87 + 0.10075387500000000000000000000000000000000000000000e-3 * t93 - 0.86596593750000000000000000000000000000000000000000e-6 * t100
  t259 = 0.33415476033750000000000000000000000000000000000000e-2 * t64 * t248 - t251 * t257
  t262 = 0.1e1 / t246
  t266 = t251 ** 2
  t268 = 0.50765919958333333333333333333333333333333333333334e-3 * t110 * t112 * t262 - 0.2e1 * t266
  t269 = 0.1e1 / t268
  t270 = t269 * t122
  t272 = f.my_piecewise3(t216, t143, t167)
  t273 = f.my_piecewise3(t219, t143, 0)
  t275 = t272 / 0.2e1 + t273 / 0.2e1
  t276 = t275 ** 2
  t278 = 0.1e1 / t276 / t275
  t281 = t142 * t278 * t148 * t151
  t283 = 0.854613e1 + t281 / 0.64e2
  t285 = 0.1e1 + t281 / 0.192e3
  t286 = 0.1e1 / t285
  t287 = t283 * t286
  t288 = t136 ** t287
  t290 = 0.1e1 + t288
  t291 = 0.1e1 / t290
  t293 = t270 * t125 * t288 * t171 * t291
  t296 = -t32 + t238 + t240 + 0.35852777777777777777777777777777777777777777777779e-2 * t60 * t62 * t259 * t293
  t297 = t251 * t180
  t298 = t111 * t262
  t304 = 0.58998125000000000000000000000000000000000000000000e-2 * t297 * t298 - 0.21511666666666666666666666666666666666666666666667e-1 * t108 * t185 * t257
  t305 = t304 * t269
  t306 = t191 * t288
  t307 = t305 * t306
  t308 = t194 * t291
  t309 = t108 * t308
  t312 = t259 * t269
  t313 = t288 ** 2
  t314 = t201 * t313
  t315 = t312 * t314
  t316 = t290 ** 2
  t317 = 0.1e1 / t316
  t319 = t60 * t206 * t317
  t322 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t307 * t309 - 0.25000000000000000000000000000000000000000000000001e0 * t315 * t319
  t323 = 0.1e1 / t322
  t329 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t79 * t30
  t330 = t26 ** 2
  t333 = 0.1e1 / t13
  t335 = t3 * t6
  t336 = t335 * t78
  t337 = t333 * t1 * t336
  t339 = t4 * t79
  t341 = t10 ** 0.5e0
  t343 = t341 * t1 * t336
  t345 = t20 * t86
  t351 = 0.10000000000000000000000000000000000000000000000000e1 * t12 / t330 * (-0.63297500000000000000000000000000000000000000000000e0 * t337 - 0.29896666666666666666666666666666666666666666666667e0 * t339 - 0.10238750000000000000000000000000000000000000000000e0 * t343 - 0.82156666666666666666666666666666666666666666666667e-1 * t345) / t29
  t354 = t335 * t78 * t54
  t356 = 0.18311555036753159941307229983139571945136646663793e-3 * t43 * t1 * t354
  t358 = t50 ** 2
  t359 = 0.1e1 / t358
  t364 = -0.86308333333333333333333333333333333333333333333334e0 * t337 - 0.30192500000000000000000000000000000000000000000000e0 * t339 - 0.55016250000000000000000000000000000000000000000000e-1 * t343 - 0.82785000000000000000000000000000000000000000000000e-1 * t345
  t366 = 0.1e1 / t53
  t367 = t359 * t364 * t366
  t369 = 0.58482233974552040708313425006184496242808878304903e0 * t43 * t45 * t367
  t370 = t6 * t7
  t375 = t2 * t92
  t389 = -t333 * t67 * t1 * t336 / 0.12e2 + t13 * (-0.66066666666666666666666666666666666666666666666667e-2 * t337 - 0.41275000000000000000000000000000000000000000000000e-2 * t339) / 0.2e1
  t393 = t329 + t351 - t356 - t369
  t396 = t77 * t99
  t399 = t83 * t5 * t165
  t401 = 0.1e1 / t138
  t402 = t90 * t401
  t407 = t96 * t6 / t7 / t138
  t409 = 0.18780000000000000000000000000000000000000000000000e-1 * t375 - 0.17565000000000000000000000000000000000000000000000e-2 * t396 + 0.39625000000000000000000000000000000000000000000000e-3 * t399 - 0.12780000000000000000000000000000000000000000000000e-3 * t402 + 0.12603281250000000000000000000000000000000000000000e-5 * t407
  t411 = -0.36798313500000000000000000000000000000000000000000e-2 * t375 * t72 - 0.73596627000000000000000000000000000000000000000000e-2 * t64 / t71 / t70 * t389 - t393 * t102 - t75 * t409
  t416 = t60 * t6
  t417 = t61 * t104
  t418 = t119 ** 2
  t419 = 0.1e1 / t418
  t423 = t8 * t111
  t429 = t109 ** 2
  t430 = t429 ** 2
  t432 = t18 / t3 * t430 * t109
  t433 = t22 * t13
  t443 = 0.13140859333333333333333333333333333333333333333333e-2 * t110 * t423 * t113 - 0.98556444999999999999999999999999999999999999999995e-3 * t432 * t433 * t113 - 0.19711288999999999999999999999999999999999999999999e-2 * t110 * t112 * t72 * t389 - 0.4e1 * t75 * t393
  t444 = t171 * t174 * t443
  t449 = t416 * t417 * t120
  t450 = t91 ** 2
  t452 = 0.1e1 / t139 / t450
  t453 = t137 * t452
  t455 = t148 * t151
  t456 = t455 * t158
  t459 = t157 ** 2
  t461 = t155 / t459
  t468 = jnp.log(t136)
  t472 = (-0.7e1 / 0.128e3 * t453 * t147 * t456 + 0.7e1 / 0.384e3 * t461 * t137 * t452 * t147 * t455) * t468 - 0.4e1 / 0.3e1 * t159 * t63
  t481 = t125 * t160
  t483 = t162 * s0
  t484 = t167 * t174
  t485 = t483 * t484
  t489 = t191 * t202
  t490 = t171 * t208
  t491 = t490 * t472
  t496 = (t329 + t351 - t356 - t369 + 0.17687407407407407407407407407407407407407407407407e-1 * t60 * t370 * t104 * t176 + 0.13265555555555555555555555555555555555555555555555e-1 * t60 * t62 * t411 * t176 - 0.13265555555555555555555555555555555555555555555555e-1 * t416 * t417 * t419 * t192 * t444 + 0.13265555555555555555555555555555555555555555555555e-1 * t449 * t192 * t472 * t171 * t174 - 0.14739506172839506172839506172839506172839506172839e-2 * t416 * t98 * t104 * t123 * t481 * t127 * t485 - 0.13265555555555555555555555555555555555555555555555e-1 * t449 * t489 * t491) * t214
  t497 = t213 ** 2
  t499 = t179 / t497
  t506 = t3 * t78
  t527 = t108 * t21
  t536 = t8 * t171
  t543 = t190 * t122 * t481 * t1
  t545 = t107 * t401 * t127
  t549 = t190 * t489
  t559 = t60 * t61
  t560 = t205 * t208
  t569 = t7 * t205
  t574 = t199 * t121
  t575 = t200 * t202
  t578 = t98 * t171
  t581 = t163 * s0 * t167
  t587 = t199 * t201 * t202 * t160
  t590 = t205 / t207 / t173
  t595 = 0.16666666666666666666666666666666666666666666666667e0 * (0.61912500000000000000000000000000000000000000000000e-2 * t393 * t180 * t182 - 0.12382500000000000000000000000000000000000000000000e-1 * t75 * t109 * t13 * t113 * t1 * t506 - 0.61912500000000000000000000000000000000000000000000e-2 * t181 * t111 * t72 * t389 - 0.53062222222222222222222222222222222222222222222221e-1 * t108 * t9 * t102 - 0.79593333333333333333333333333333333333333333333331e-1 * t108 * t185 * t409) * t120 * t192 * t196 - 0.16666666666666666666666666666666666666666666666667e0 * t189 * t419 * t192 * t527 * t444 + 0.16666666666666666666666666666666666666666666666667e0 * t193 * t472 * t1 * t107 * t195 + 0.11111111111111111111111111111111111111111111111111e0 * t193 * t108 * t536 * t174 - 0.18518518518518518518518518518518518518518518518519e-1 * t543 * t545 * t485 - 0.16666666666666666666666666666666666666666666666667e0 * t549 * t527 * t491 - 0.25000000000000000000000000000000000000000000000001e0 * t411 * t120 * t203 * t210 + 0.25000000000000000000000000000000000000000000000001e0 * t104 * t419 * t203 * t559 * t560 * t443 - 0.50000000000000000000000000000000000000000000000002e0 * t204 * t559 * t560 * t472 - 0.33333333333333333333333333333333333333333333333335e0 * t204 * t60 * t569 * t208 + 0.55555555555555555555555555555555555555555555555558e-1 * t574 * t575 * t60 * t578 * t208 * t581 + 0.50000000000000000000000000000000000000000000000002e0 * t587 * t559 * t590 * t472
  t596 = t499 * t595
  t600 = t229 ** 2
  t620 = t222 * (0.53236443333333333333333333333333333333333333333332e-3 * t4 * t79 * t233 + 0.99999999999999999999999999999999999999999999999999e0 * t224 / t600 * (-0.11765750000000000000000000000000000000000000000000e1 * t337 - 0.51647500000000000000000000000000000000000000000000e0 * t339 - 0.21038750000000000000000000000000000000000000000000e0 * t343 - 0.10419500000000000000000000000000000000000000000000e0 * t345) / t232 - t329 - t351 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t79 * t54 + 0.58482233974552040708313425006184496242808878304903e0 * t45 * t359 * t364 * t366)
  t623 = 0.18311555036753159941307229983139571945136646663793e-3 * t222 * t1 * t354
  t626 = 0.58482233974552040708313425006184496242808878304903e0 * t222 * t45 * t367
  t644 = -t333 * t243 * t1 * t336 / 0.12e2 + t13 * (-0.14921166666666666666666666666666666666666666666667e-3 * t337 - 0.39332083333333333333333333333333333333333333333333e-2 * t339) / 0.2e1
  t648 = t329 + t351 + t620 - t623 - t626
  t655 = 0.24306825000000000000000000000000000000000000000000e-1 * t375 - 0.24999450000000000000000000000000000000000000000000e-2 * t396 + 0.60463437500000000000000000000000000000000000000000e-3 * t399 - 0.20150775000000000000000000000000000000000000000000e-3 * t402 + 0.20205871875000000000000000000000000000000000000000e-5 * t407
  t657 = -0.33415476033750000000000000000000000000000000000000e-2 * t375 * t248 - 0.66830952067500000000000000000000000000000000000000e-2 * t64 / t247 / t246 * t644 - t648 * t257 - t251 * t655
  t662 = t61 * t259
  t663 = t268 ** 2
  t664 = 0.1e1 / t663
  t680 = 0.33843946638888888888888888888888888888888888888889e-3 * t110 * t423 * t262 - 0.25382959979166666666666666666666666666666666666667e-3 * t432 * t433 * t262 - 0.50765919958333333333333333333333333333333333333334e-3 * t110 * t112 * t248 * t644 - 0.4e1 * t251 * t648
  t681 = t171 * t291 * t680
  t686 = t416 * t662 * t269
  t688 = t455 * t286
  t691 = t285 ** 2
  t693 = t283 / t691
  t703 = (-0.7e1 / 0.128e3 * t453 * t278 * t688 + 0.7e1 / 0.384e3 * t693 * t137 * t452 * t278 * t455) * t468 - 0.4e1 / 0.3e1 * t287 * t63
  t712 = t125 * t288
  t714 = t167 * t291
  t715 = t483 * t714
  t719 = t191 * t313
  t720 = t171 * t317
  t721 = t720 * t703
  t725 = t329 + t351 + t620 - t623 - t626 + 0.47803703703703703703703703703703703703703703703705e-2 * t60 * t370 * t259 * t293 + 0.35852777777777777777777777777777777777777777777779e-2 * t60 * t62 * t657 * t293 - 0.35852777777777777777777777777777777777777777777779e-2 * t416 * t662 * t664 * t306 * t681 + 0.35852777777777777777777777777777777777777777777779e-2 * t686 * t306 * t703 * t171 * t291 - 0.39836419753086419753086419753086419753086419753088e-3 * t416 * t98 * t259 * t270 * t712 * t127 * t715 - 0.35852777777777777777777777777777777777777777777779e-2 * t686 * t719 * t721
  t727 = t322 ** 2
  t729 = t296 / t727
  t770 = t305 * t122 * t712 * t1
  t774 = t305 * t719
  t784 = t205 * t317
  t797 = t312 * t121
  t798 = t200 * t313
  t807 = t312 * t201 * t313 * t288
  t810 = t205 / t316 / t290
  t815 = 0.16666666666666666666666666666666666666666666666667e0 * (0.58998125000000000000000000000000000000000000000000e-2 * t648 * t180 * t298 - 0.11799625000000000000000000000000000000000000000000e-1 * t251 * t109 * t13 * t262 * t1 * t506 - 0.58998125000000000000000000000000000000000000000000e-2 * t297 * t111 * t248 * t644 - 0.14341111111111111111111111111111111111111111111111e-1 * t108 * t9 * t257 - 0.21511666666666666666666666666666666666666666666667e-1 * t108 * t185 * t655) * t269 * t306 * t309 - 0.16666666666666666666666666666666666666666666666667e0 * t304 * t664 * t306 * t527 * t681 + 0.16666666666666666666666666666666666666666666666667e0 * t307 * t703 * t1 * t107 * t308 + 0.11111111111111111111111111111111111111111111111111e0 * t307 * t108 * t536 * t291 - 0.18518518518518518518518518518518518518518518518519e-1 * t770 * t545 * t715 - 0.16666666666666666666666666666666666666666666666667e0 * t774 * t527 * t721 - 0.25000000000000000000000000000000000000000000000001e0 * t657 * t269 * t314 * t319 + 0.25000000000000000000000000000000000000000000000001e0 * t259 * t664 * t314 * t559 * t784 * t680 - 0.50000000000000000000000000000000000000000000000002e0 * t315 * t559 * t784 * t703 - 0.33333333333333333333333333333333333333333333333335e0 * t315 * t60 * t569 * t317 + 0.55555555555555555555555555555555555555555555555558e-1 * t797 * t798 * t60 * t578 * t317 * t581 + 0.50000000000000000000000000000000000000000000000002e0 * t807 * t559 * t810 * t703
  vrho_0_ = t215 + t43 * (t296 * t323 - t215) + r0 * (t496 - t596 + t43 * (t725 * t323 - t729 * t815 - t496 + t596))
  t821 = t132 * t141
  t832 = 0.1e1 / s0
  t835 = (0.3e1 / 0.128e3 * t821 * t147 * t456 - t461 * t132 * t141 * t147 * t455 / 0.128e3) * t468 + t159 * t832 / 0.2e1
  t848 = t490 * t835
  t853 = (0.13265555555555555555555555555555555555555555555555e-1 * t449 * t192 * t835 * t171 * t174 + 0.55273148148148148148148148148148148148148148148146e-3 * t416 * t78 * t104 * t120 * t192 * t163 * t484 - 0.13265555555555555555555555555555555555555555555555e-1 * t449 * t489 * t848) * t214
  t860 = t107 * t92 * t127
  t861 = t162 * t167
  t876 = t59 * t78 * t171
  t887 = t499 * (0.16666666666666666666666666666666666666666666666667e0 * t193 * t835 * t1 * t107 * t195 + 0.69444444444444444444444444444444444444444444444446e-2 * t543 * t860 * t861 * t174 - 0.16666666666666666666666666666666666666666666666667e0 * t549 * t527 * t848 - 0.50000000000000000000000000000000000000000000000002e0 * t204 * t559 * t560 * t835 - 0.20833333333333333333333333333333333333333333333334e-1 * t574 * t575 * t18 * t876 * t208 * t127 * t861 + 0.50000000000000000000000000000000000000000000000002e0 * t587 * t559 * t590 * t835)
  t900 = (0.3e1 / 0.128e3 * t821 * t278 * t688 - t693 * t132 * t141 * t278 * t455 / 0.128e3) * t468 + t287 * t832 / 0.2e1
  t913 = t720 * t900
  vsigma_0_ = r0 * (t853 - t887 + t43 * ((0.35852777777777777777777777777777777777777777777779e-2 * t686 * t306 * t900 * t171 * t291 + 0.14938657407407407407407407407407407407407407407408e-3 * t416 * t78 * t259 * t269 * t306 * t163 * t714 - 0.35852777777777777777777777777777777777777777777779e-2 * t686 * t719 * t913) * t323 - t729 * (0.16666666666666666666666666666666666666666666666667e0 * t307 * t900 * t1 * t107 * t308 + 0.69444444444444444444444444444444444444444444444446e-2 * t770 * t860 * t861 * t291 - 0.16666666666666666666666666666666666666666666666667e0 * t774 * t527 * t913 - 0.50000000000000000000000000000000000000000000000002e0 * t315 * t559 * t784 * t900 - 0.20833333333333333333333333333333333333333333333334e-1 * t797 * t798 * t18 * t876 * t317 * t127 * t861 + 0.50000000000000000000000000000000000000000000000002e0 * t807 * t559 * t810 * t900) - t853 + t887))

  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = t7 * r0
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t12 = t6 * t11
  t13 = t4 * t12
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t23 = 0.1e1 / t22
  t25 = t21 * t5 * t23
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t27
  t31 = jnp.log(t30)
  t34 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t40 = 0.1e1 / t14
  t41 = t40 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t53 = 0.1e1 / t22 / r0
  t54 = t5 * t53
  t55 = t21 * t54
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t61 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t64 = t63 * f.p.zeta_threshold
  t65 = f.my_piecewise3(t62, t64, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t71 = 0.1e1 / (0.2e1 * t68 - 0.2e1)
  t72 = (0.2e1 * t65 - 0.2e1) * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t78
  t82 = jnp.log(t81)
  t84 = t42 * t9 * t82
  t86 = 0.18311555036753159941307229983139571945136646663793e-3 * t73 * t84
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t101 = 0.58482233974552040708313425006184496242808878304903e0 * t89 * t99
  t102 = t3 * t2
  t103 = 0.1e1 / t102
  t104 = t19 * t103
  t105 = t6 * t7
  t106 = 0.1e1 / r0
  t107 = t2 * t106
  t110 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t14 + 0.12382500000000000000000000000000000000000000000000e-1 * t13
  t113 = 0.1e1 + t14 * t110 / 0.2e1
  t114 = t113 ** 2
  t115 = 0.1e1 / t114
  t119 = 0.62182e-1 * t36 * t31
  t120 = t88 * t82
  t122 = 0.19751789702565206228825776161588751761046270558698e-1 * t72 * t120
  t123 = -t119 + t122
  t125 = t1 * t102
  t126 = t125 * t10
  t129 = t19 * t20 * t2
  t130 = t129 * t54
  t132 = jnp.pi ** 2
  t133 = 0.1e1 / t132
  t134 = r0 ** 2
  t135 = 0.1e1 / t134
  t136 = t133 * t135
  t139 = t1 * t3 * t133
  t141 = 0.1e1 / t7 / t134
  t142 = t6 * t141
  t143 = t139 * t142
  t145 = -0.18780000000000000000000000000000000000000000000000e-1 * t107 + 0.13173750000000000000000000000000000000000000000000e-2 * t126 - 0.23775000000000000000000000000000000000000000000000e-3 * t130 + 0.63900000000000000000000000000000000000000000000000e-4 * t136 - 0.54014062500000000000000000000000000000000000000000e-6 * t143
  t147 = 0.36798313500000000000000000000000000000000000000000e-2 * t107 * t115 - t123 * t145
  t150 = 0.1e1 / t20
  t151 = t1 * t150
  t152 = 4 ** (0.1e1 / 0.6e1)
  t153 = t151 * t152
  t154 = t14 * t13
  t155 = t22 * t154
  t156 = 0.1e1 / t113
  t160 = t123 ** 2
  t162 = 0.19711288999999999999999999999999999999999999999999e-2 * t153 * t155 * t156 - 0.2e1 * t160
  t163 = 0.1e1 / t162
  t164 = 9 ** (0.1e1 / 0.3e1)
  t165 = t164 ** 2
  t166 = t163 * t165
  t167 = jnp.pi ** (0.1e1 / 0.3e1)
  t168 = t167 ** 2
  t170 = 6 ** (0.1e1 / 0.3e1)
  t171 = t170 ** 2
  t172 = t132 ** (0.1e1 / 0.3e1)
  t175 = jnp.sqrt(s0)
  t179 = t171 / t172 * t175 * t9 * t68 / 0.12e2
  t180 = t175 * s0
  t181 = t134 * r0
  t182 = jnp.sqrt(r0)
  t184 = 0.1e1 / t182 / t181
  t185 = t180 * t184
  t186 = t63 ** 2
  t187 = f.my_piecewise3(t62, t186, 1)
  t188 = t187 ** 2
  t190 = 0.1e1 / t188 / t187
  t191 = jnp.sqrt(0.3e1)
  t193 = jnp.sqrt(t2)
  t194 = 0.1e1 / t193
  t196 = t185 * t190 * t191 * t194
  t198 = 0.854613e1 + t196 / 0.64e2
  t200 = 0.1e1 + t196 / 0.192e3
  t201 = 0.1e1 / t200
  t202 = t198 * t201
  t203 = t179 ** t202
  t204 = t172 ** 2
  t205 = 0.1e1 / t204
  t206 = t170 * t205
  t208 = 0.1e1 / t22 / t134
  t210 = t68 ** 2
  t214 = 0.14709046e2 + t206 * s0 * t208 * t210 / 0.24e2
  t216 = 0.1e1 + t203
  t217 = 0.1e1 / t216
  t219 = t166 * t168 * t203 * t214 * t217
  t222 = t6 * t8
  t223 = t2 * t135
  t227 = 0.1e1 / t114 / t113
  t229 = t40 * t110 * t1
  t234 = -0.66066666666666666666666666666666666666666666666667e-2 * t44 - 0.41275000000000000000000000000000000000000000000000e-2 * t46
  t237 = -t229 * t43 / 0.12e2 + t14 * t234 / 0.2e1
  t238 = t227 * t237
  t241 = t34 + t61 - t86 - t101
  t244 = t125 * t142
  t246 = t5 * t208
  t247 = t129 * t246
  t249 = 0.1e1 / t181
  t250 = t133 * t249
  t253 = 0.1e1 / t7 / t181
  t254 = t6 * t253
  t255 = t139 * t254
  t257 = 0.18780000000000000000000000000000000000000000000000e-1 * t223 - 0.17565000000000000000000000000000000000000000000000e-2 * t244 + 0.39625000000000000000000000000000000000000000000000e-3 * t247 - 0.12780000000000000000000000000000000000000000000000e-3 * t250 + 0.12603281250000000000000000000000000000000000000000e-5 * t255
  t259 = -0.36798313500000000000000000000000000000000000000000e-2 * t223 * t115 - 0.73596627000000000000000000000000000000000000000000e-2 * t107 * t238 - t241 * t145 - t123 * t257
  t264 = t104 * t6
  t265 = t8 * t147
  t266 = t162 ** 2
  t267 = 0.1e1 / t266
  t269 = t264 * t265 * t267
  t270 = t165 * t168
  t271 = t270 * t203
  t272 = t214 * t217
  t273 = t11 * t154
  t279 = t152 ** 2
  t280 = t279 ** 2
  t281 = t280 * t152
  t282 = t19 / t3 * t281
  t283 = t23 * t14
  t287 = t115 * t237
  t293 = 0.13140859333333333333333333333333333333333333333333e-2 * t153 * t273 * t156 - 0.98556444999999999999999999999999999999999999999995e-3 * t282 * t283 * t156 - 0.19711288999999999999999999999999999999999999999999e-2 * t153 * t155 * t287 - 0.4e1 * t123 * t241
  t294 = t272 * t293
  t295 = t271 * t294
  t299 = t264 * t265 * t163
  t300 = t134 ** 2
  t302 = 0.1e1 / t182 / t300
  t303 = t180 * t302
  t305 = t191 * t194
  t306 = t305 * t201
  t309 = t200 ** 2
  t310 = 0.1e1 / t309
  t311 = t198 * t310
  t312 = t311 * t180
  t314 = t302 * t190 * t305
  t317 = -0.7e1 / 0.128e3 * t303 * t190 * t306 + 0.7e1 / 0.384e3 * t312 * t314
  t318 = jnp.log(t179)
  t322 = t317 * t318 - 0.4e1 / 0.3e1 * t202 * t106
  t323 = t322 * t214
  t325 = t271 * t323 * t217
  t328 = t141 * t147
  t330 = t264 * t328 * t166
  t331 = t168 * t203
  t332 = t331 * t170
  t333 = t205 * s0
  t334 = t210 * t217
  t335 = t333 * t334
  t336 = t332 * t335
  t339 = t203 ** 2
  t340 = t270 * t339
  t341 = t216 ** 2
  t342 = 0.1e1 / t341
  t343 = t214 * t342
  t344 = t343 * t322
  t345 = t340 * t344
  t348 = t34 + t61 - t86 - t101 + 0.17687407407407407407407407407407407407407407407407e-1 * t104 * t105 * t147 * t219 + 0.13265555555555555555555555555555555555555555555555e-1 * t104 * t222 * t259 * t219 - 0.13265555555555555555555555555555555555555555555555e-1 * t269 * t295 + 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t325 - 0.14739506172839506172839506172839506172839506172839e-2 * t330 * t336 - 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t345
  t349 = jnp.sqrt(0.4e1)
  t350 = t123 * t349
  t351 = t154 * t156
  t354 = t6 * t22
  t358 = 0.61912500000000000000000000000000000000000000000000e-2 * t350 * t351 - 0.79593333333333333333333333333333333333333333333331e-1 * t151 * t354 * t145
  t359 = t358 * t163
  t360 = t359 * t271
  t361 = t22 * t214
  t362 = t361 * t217
  t363 = t151 * t362
  t366 = t147 * t163
  t367 = t167 * jnp.pi
  t368 = t164 * t367
  t369 = t368 * t339
  t370 = t366 * t369
  t371 = t214 ** 2
  t372 = t8 * t371
  t374 = t104 * t372 * t342
  t377 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t360 * t363 - 0.25000000000000000000000000000000000000000000000001e0 * t370 * t374
  t378 = 0.1e1 / t377
  t379 = t348 * t378
  t385 = -t119 + t122 + 0.13265555555555555555555555555555555555555555555555e-1 * t104 * t222 * t147 * t219
  t386 = t377 ** 2
  t387 = 0.1e1 / t386
  t388 = t385 * t387
  t389 = t241 * t349
  t392 = t123 * t152
  t393 = t392 * t14
  t394 = t156 * t1
  t395 = t3 * t9
  t396 = t394 * t395
  t399 = t154 * t115
  t400 = t399 * t237
  t409 = 0.61912500000000000000000000000000000000000000000000e-2 * t389 * t351 - 0.12382500000000000000000000000000000000000000000000e-1 * t393 * t396 - 0.61912500000000000000000000000000000000000000000000e-2 * t350 * t400 - 0.53062222222222222222222222222222222222222222222221e-1 * t151 * t12 * t145 - 0.79593333333333333333333333333333333333333333333331e-1 * t151 * t354 * t257
  t410 = t409 * t163
  t411 = t410 * t271
  t414 = t358 * t267
  t415 = t414 * t271
  t416 = t151 * t22
  t417 = t416 * t294
  t420 = t322 * t1
  t421 = t420 * t150
  t422 = t421 * t362
  t425 = t11 * t214
  t426 = t425 * t217
  t427 = t151 * t426
  t430 = t359 * t165
  t431 = t331 * t1
  t432 = t430 * t431
  t434 = t150 * t249 * t170
  t435 = t434 * t335
  t438 = t359 * t340
  t439 = t416 * t344
  t442 = t259 * t163
  t443 = t442 * t369
  t446 = t147 * t267
  t447 = t446 * t369
  t448 = t104 * t8
  t449 = t371 * t342
  t450 = t449 * t293
  t451 = t448 * t450
  t454 = t449 * t322
  t455 = t448 * t454
  t458 = t7 * t371
  t460 = t104 * t458 * t342
  t463 = t366 * t164
  t464 = t367 * t339
  t465 = t464 * t104
  t466 = t463 * t465
  t467 = t141 * t214
  t469 = s0 * t210
  t470 = t206 * t469
  t471 = t467 * t342 * t470
  t474 = t339 * t203
  t475 = t368 * t474
  t476 = t366 * t475
  t478 = 0.1e1 / t341 / t216
  t479 = t371 * t478
  t480 = t479 * t322
  t481 = t448 * t480
  t484 = 0.16666666666666666666666666666666666666666666666667e0 * t411 * t363 - 0.16666666666666666666666666666666666666666666666667e0 * t415 * t417 + 0.16666666666666666666666666666666666666666666666667e0 * t360 * t422 + 0.11111111111111111111111111111111111111111111111111e0 * t360 * t427 - 0.18518518518518518518518518518518518518518518518519e-1 * t432 * t435 - 0.16666666666666666666666666666666666666666666666667e0 * t438 * t439 - 0.25000000000000000000000000000000000000000000000001e0 * t443 * t374 + 0.25000000000000000000000000000000000000000000000001e0 * t447 * t451 - 0.50000000000000000000000000000000000000000000000002e0 * t370 * t455 - 0.33333333333333333333333333333333333333333333333335e0 * t370 * t460 + 0.55555555555555555555555555555555555555555555555558e-1 * t466 * t471 + 0.50000000000000000000000000000000000000000000000002e0 * t476 * t481
  t485 = t388 * t484
  t487 = 0.2e1 <= f.p.zeta_threshold
  t489 = f.my_piecewise3(t487, t64, 0.2e1 * t68)
  t490 = 0.0e0 <= f.p.zeta_threshold
  t491 = f.my_piecewise3(t490, t64, 0)
  t493 = (t489 + t491 - 0.2e1) * t71
  t498 = 0.70594500000000000000000000000000000000000000000000e1 * t14 + 0.15494250000000000000000000000000000000000000000000e1 * t13 + 0.42077500000000000000000000000000000000000000000000e0 * t17 + 0.15629250000000000000000000000000000000000000000000e0 * t25
  t501 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t498
  t502 = jnp.log(t501)
  t507 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t13
  t508 = t498 ** 2
  t509 = 0.1e1 / t508
  t510 = t507 * t509
  t515 = -0.11765750000000000000000000000000000000000000000000e1 * t44 - 0.51647500000000000000000000000000000000000000000000e0 * t46 - 0.21038750000000000000000000000000000000000000000000e0 * t50 - 0.10419500000000000000000000000000000000000000000000e0 * t55
  t516 = 0.1e1 / t501
  t517 = t515 * t516
  t523 = t88 * t91
  t524 = t96 * t98
  t528 = t493 * (0.53236443333333333333333333333333333333333333333332e-3 * t4 * t10 * t502 + 0.99999999999999999999999999999999999999999999999999e0 * t510 * t517 - t34 - t61 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t10 * t82 + 0.58482233974552040708313425006184496242808878304903e0 * t523 * t524)
  t529 = t493 * t1
  t531 = 0.18311555036753159941307229983139571945136646663793e-3 * t529 * t84
  t532 = t493 * t88
  t534 = 0.58482233974552040708313425006184496242808878304903e0 * t532 * t99
  t537 = 0.149676e1 + 0.89527000000000000000000000000000000000000000000000e-3 * t14 + 0.11799625000000000000000000000000000000000000000000e-1 * t13
  t540 = 0.1e1 + t14 * t537 / 0.2e1
  t541 = t540 ** 2
  t542 = 0.1e1 / t541
  t549 = t493 * (-0.31090e-1 * t507 * t502 + t119 - 0.19751789702565206228825776161588751761046270558698e-1 * t120)
  t551 = 0.19751789702565206228825776161588751761046270558698e-1 * t493 * t120
  t552 = -t119 + t549 + t551
  t558 = -0.24306825000000000000000000000000000000000000000000e-1 * t107 + 0.18749587500000000000000000000000000000000000000000e-2 * t126 - 0.36278062500000000000000000000000000000000000000000e-3 * t130 + 0.10075387500000000000000000000000000000000000000000e-3 * t136 - 0.86596593750000000000000000000000000000000000000000e-6 * t143
  t560 = 0.33415476033750000000000000000000000000000000000000e-2 * t107 * t542 - t552 * t558
  t563 = 0.1e1 / t540
  t567 = t552 ** 2
  t569 = 0.50765919958333333333333333333333333333333333333334e-3 * t153 * t155 * t563 - 0.2e1 * t567
  t570 = 0.1e1 / t569
  t571 = t570 * t165
  t573 = f.my_piecewise3(t487, t186, t210)
  t574 = f.my_piecewise3(t490, t186, 0)
  t576 = t573 / 0.2e1 + t574 / 0.2e1
  t577 = t576 ** 2
  t579 = 0.1e1 / t577 / t576
  t582 = t185 * t579 * t191 * t194
  t584 = 0.854613e1 + t582 / 0.64e2
  t586 = 0.1e1 + t582 / 0.192e3
  t587 = 0.1e1 / t586
  t588 = t584 * t587
  t589 = t179 ** t588
  t591 = 0.1e1 + t589
  t592 = 0.1e1 / t591
  t594 = t571 * t168 * t589 * t214 * t592
  t600 = 0.1e1 / t541 / t540
  t602 = t40 * t537 * t1
  t607 = -0.14921166666666666666666666666666666666666666666667e-3 * t44 - 0.39332083333333333333333333333333333333333333333333e-2 * t46
  t610 = -t602 * t43 / 0.12e2 + t14 * t607 / 0.2e1
  t611 = t600 * t610
  t614 = t34 + t61 + t528 - t531 - t534
  t621 = 0.24306825000000000000000000000000000000000000000000e-1 * t223 - 0.24999450000000000000000000000000000000000000000000e-2 * t244 + 0.60463437500000000000000000000000000000000000000000e-3 * t247 - 0.20150775000000000000000000000000000000000000000000e-3 * t250 + 0.20205871875000000000000000000000000000000000000000e-5 * t255
  t623 = -0.33415476033750000000000000000000000000000000000000e-2 * t223 * t542 - 0.66830952067500000000000000000000000000000000000000e-2 * t107 * t611 - t614 * t558 - t552 * t621
  t628 = t8 * t560
  t629 = t569 ** 2
  t630 = 0.1e1 / t629
  t632 = t264 * t628 * t630
  t633 = t270 * t589
  t634 = t214 * t592
  t641 = t542 * t610
  t647 = 0.33843946638888888888888888888888888888888888888889e-3 * t153 * t273 * t563 - 0.25382959979166666666666666666666666666666666666667e-3 * t282 * t283 * t563 - 0.50765919958333333333333333333333333333333333333334e-3 * t153 * t155 * t641 - 0.4e1 * t552 * t614
  t648 = t634 * t647
  t649 = t633 * t648
  t653 = t264 * t628 * t570
  t655 = t305 * t587
  t658 = t586 ** 2
  t659 = 0.1e1 / t658
  t660 = t584 * t659
  t661 = t660 * t180
  t663 = t302 * t579 * t305
  t666 = -0.7e1 / 0.128e3 * t303 * t579 * t655 + 0.7e1 / 0.384e3 * t661 * t663
  t670 = t666 * t318 - 0.4e1 / 0.3e1 * t588 * t106
  t671 = t670 * t214
  t673 = t633 * t671 * t592
  t676 = t141 * t560
  t678 = t264 * t676 * t571
  t679 = t168 * t589
  t680 = t679 * t170
  t681 = t210 * t592
  t682 = t333 * t681
  t683 = t680 * t682
  t686 = t589 ** 2
  t687 = t270 * t686
  t688 = t591 ** 2
  t689 = 0.1e1 / t688
  t690 = t214 * t689
  t691 = t690 * t670
  t692 = t687 * t691
  t695 = t34 + t61 + t528 - t531 - t534 + 0.47803703703703703703703703703703703703703703703705e-2 * t104 * t105 * t560 * t594 + 0.35852777777777777777777777777777777777777777777779e-2 * t104 * t222 * t623 * t594 - 0.35852777777777777777777777777777777777777777777779e-2 * t632 * t649 + 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t673 - 0.39836419753086419753086419753086419753086419753088e-3 * t678 * t683 - 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t692
  t696 = t552 * t349
  t697 = t154 * t563
  t703 = 0.58998125000000000000000000000000000000000000000000e-2 * t696 * t697 - 0.21511666666666666666666666666666666666666666666667e-1 * t151 * t354 * t558
  t704 = t703 * t570
  t705 = t704 * t633
  t706 = t361 * t592
  t707 = t151 * t706
  t710 = t560 * t570
  t711 = t368 * t686
  t712 = t710 * t711
  t714 = t104 * t372 * t689
  t717 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t705 * t707 - 0.25000000000000000000000000000000000000000000000001e0 * t712 * t714
  t718 = 0.1e1 / t717
  t724 = -t119 + t549 + t551 + 0.35852777777777777777777777777777777777777777777779e-2 * t104 * t222 * t560 * t594
  t725 = t717 ** 2
  t726 = 0.1e1 / t725
  t727 = t724 * t726
  t728 = t614 * t349
  t731 = t552 * t152
  t732 = t731 * t14
  t733 = t563 * t1
  t734 = t733 * t395
  t737 = t154 * t542
  t738 = t737 * t610
  t747 = 0.58998125000000000000000000000000000000000000000000e-2 * t728 * t697 - 0.11799625000000000000000000000000000000000000000000e-1 * t732 * t734 - 0.58998125000000000000000000000000000000000000000000e-2 * t696 * t738 - 0.14341111111111111111111111111111111111111111111111e-1 * t151 * t12 * t558 - 0.21511666666666666666666666666666666666666666666667e-1 * t151 * t354 * t621
  t748 = t747 * t570
  t749 = t748 * t633
  t752 = t703 * t630
  t753 = t752 * t633
  t754 = t416 * t648
  t757 = t670 * t1
  t758 = t757 * t150
  t759 = t758 * t706
  t762 = t425 * t592
  t763 = t151 * t762
  t766 = t704 * t165
  t767 = t679 * t1
  t768 = t766 * t767
  t769 = t434 * t682
  t772 = t704 * t687
  t773 = t416 * t691
  t776 = t623 * t570
  t777 = t776 * t711
  t780 = t560 * t630
  t781 = t780 * t711
  t782 = t371 * t689
  t783 = t782 * t647
  t784 = t448 * t783
  t787 = t782 * t670
  t788 = t448 * t787
  t792 = t104 * t458 * t689
  t795 = t710 * t164
  t796 = t367 * t686
  t797 = t796 * t104
  t798 = t795 * t797
  t800 = t467 * t689 * t470
  t803 = t686 * t589
  t804 = t368 * t803
  t805 = t710 * t804
  t807 = 0.1e1 / t688 / t591
  t808 = t371 * t807
  t809 = t808 * t670
  t810 = t448 * t809
  t813 = 0.16666666666666666666666666666666666666666666666667e0 * t749 * t707 - 0.16666666666666666666666666666666666666666666666667e0 * t753 * t754 + 0.16666666666666666666666666666666666666666666666667e0 * t705 * t759 + 0.11111111111111111111111111111111111111111111111111e0 * t705 * t763 - 0.18518518518518518518518518518518518518518518518519e-1 * t768 * t769 - 0.16666666666666666666666666666666666666666666666667e0 * t772 * t773 - 0.25000000000000000000000000000000000000000000000001e0 * t777 * t714 + 0.25000000000000000000000000000000000000000000000001e0 * t781 * t784 - 0.50000000000000000000000000000000000000000000000002e0 * t712 * t788 - 0.33333333333333333333333333333333333333333333333335e0 * t712 * t792 + 0.55555555555555555555555555555555555555555555555558e-1 * t798 * t800 + 0.50000000000000000000000000000000000000000000000002e0 * t805 * t810
  t818 = t4 * t6
  t822 = 0.35616666666666666666666666666666666666666666666666e-1 * t818 * t9 * t38 * t59
  t824 = t42 * t141 * t82
  t826 = 0.24415406715670879921742973310852762593515528885057e-3 * t73 * t824
  t827 = t37 ** 2
  t830 = t57 ** 2
  t831 = t30 ** 2
  t835 = 0.16081824322151104821330931780901225435013347914188e2 * t36 / t827 * t830 / t831
  t836 = t300 * r0
  t838 = 0.1e1 / t182 / t836
  t839 = t180 * t838
  t841 = t839 * t190 * t306
  t843 = s0 ** 2
  t844 = t843 * s0
  t845 = t300 ** 2
  t847 = 0.1e1 / t845 / r0
  t848 = t844 * t847
  t849 = t188 ** 2
  t851 = 0.1e1 / t849 / t188
  t853 = t851 * jnp.pi * t310
  t858 = t198 / t309 / t200
  t866 = t312 * t838 * t190 * t305
  t876 = (0.63e2 / 0.256e3 * t841 - 0.49e2 / 0.8192e4 * t848 * t853 + 0.49e2 / 0.24576e5 * t858 * t844 * t847 * t851 * jnp.pi - 0.21e2 / 0.256e3 * t866) * t318 - 0.4e1 / 0.3e1 * t317 * t106 + 0.7e1 / 0.96e2 * t841 - 0.7e1 / 0.288e3 * t866 + 0.4e1 / 0.3e1 * t202 * t135
  t877 = t343 * t876
  t881 = t7 * t147
  t883 = t264 * t881 * t163
  t886 = t8 * t259
  t892 = t264 * t886 * t163
  t895 = t9 * t154
  t899 = t53 * t14
  t906 = t349 * t135
  t913 = t237 ** 2
  t918 = 0.1e1 / t154
  t922 = t20 * t5 * t208
  t929 = t42 * t141
  t933 = t918 * t19 * t922
  t935 = t41 * t929
  t937 = t4 * t142
  t942 = -t918 * t110 * t19 * t922 / 0.18e2 - t40 * t234 * t1 * t43 / 0.6e1 + t229 * t929 / 0.9e1 + t14 * (-0.44044444444444444444444444444444444444444444444445e-2 * t933 + 0.88088888888888888888888888888888888888888888888889e-2 * t935 + 0.55033333333333333333333333333333333333333333333333e-2 * t937) / 0.2e1
  t947 = t241 ** 2
  t951 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t142 * t31
  t957 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t830 * t58
  t961 = t13 ** (-0.5e0)
  t963 = t961 * t19 * t922
  t965 = t49 * t929
  t967 = t21 * t246
  t972 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t933 + 0.84396666666666666666666666666666666666666666666666e0 * t935 + 0.39862222222222222222222222222222222222222222222223e0 * t937 + 0.68258333333333333333333333333333333333333333333333e-1 * t963 + 0.13651666666666666666666666666666666666666666666667e0 * t965 + 0.13692777777777777777777777777777777777777777777778e0 * t967) * t58
  t974 = t10 * t99
  t976 = 0.10843580882781524214666447553230042011687479519034e-1 * t72 * t4 * t974
  t978 = 0.1e1 / t90 / t78
  t979 = t96 ** 2
  t981 = t978 * t979 * t98
  t983 = 0.11696446794910408141662685001236899248561775660981e1 * t89 * t981
  t990 = -0.57538888888888888888888888888888888888888888888889e0 * t933 + 0.11507777777777777777777777777777777777777777777778e1 * t935 + 0.40256666666666666666666666666666666666666666666667e0 * t937 + 0.36677500000000000000000000000000000000000000000000e-1 * t963 + 0.73355000000000000000000000000000000000000000000000e-1 * t965 + 0.13797500000000000000000000000000000000000000000000e0 * t967
  t992 = t91 * t990 * t98
  t994 = 0.58482233974552040708313425006184496242808878304903e0 * t89 * t992
  t995 = t90 ** 2
  t996 = 0.1e1 / t995
  t998 = t81 ** 2
  t999 = 0.1e1 / t998
  t1000 = t996 * t979 * t999
  t1002 = 0.17315755899375863299672358916972966258900005419821e2 * t89 * t1000
  t1003 = -t951 - t822 - t957 + t972 + t835 + t826 + t976 + t983 - t994 - t1002
  t1006 = -0.43802864444444444444444444444444444444444444444443e-3 * t153 * t895 * t156 - 0.2e-52 * t282 * t899 * t156 - 0.26281718666666666666666666666666666666666666666666e-2 * t153 * t273 * t287 + 0.19711288999999999999999999999999999999999999999999e-2 * t906 * t40 * t156 + 0.19711288999999999999999999999999999999999999999999e-2 * t282 * t283 * t287 + 0.39422577999999999999999999999999999999999999999998e-2 * t153 * t155 * t227 * t913 - 0.19711288999999999999999999999999999999999999999999e-2 * t153 * t155 * t115 * t942 - 0.4e1 * t947 - 0.4e1 * t123 * t1003
  t1007 = t272 * t1006
  t1015 = t270 * t474
  t1016 = t214 * t478
  t1017 = t322 ** 2
  t1018 = t1016 * t1017
  t1022 = t1017 * t214
  t1036 = 0.1e1 / t266 / t162
  t1039 = t293 ** 2
  t1040 = t272 * t1039
  t1049 = -t822 + t826 + t835 - 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t340 * t877 + 0.35374814814814814814814814814814814814814814814814e-1 * t883 * t325 - 0.26531111111111111111111111111111111111111111111110e-1 * t264 * t886 * t267 * t295 + 0.26531111111111111111111111111111111111111111111110e-1 * t892 * t325 - 0.13265555555555555555555555555555555555555555555555e-1 * t269 * t271 * t1007 - 0.35374814814814814814814814814814814814814814814814e-1 * t264 * t881 * t267 * t295 + 0.26531111111111111111111111111111111111111111111110e-1 * t299 * t1015 * t1018 - 0.39796666666666666666666666666666666666666666666665e-1 * t299 * t340 * t1022 * t342 + 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t271 * t1022 * t217 - 0.35374814814814814814814814814814814814814814814814e-1 * t883 * t345 - 0.26531111111111111111111111111111111111111111111110e-1 * t892 * t345 + 0.26531111111111111111111111111111111111111111111110e-1 * t264 * t265 * t1036 * t271 * t1040 + 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t271 * t876 * t214 * t217
  t1050 = t168 * t339
  t1051 = t1050 * t206
  t1052 = t342 * t322
  t1053 = t469 * t1052
  t1057 = t267 * t165
  t1061 = t217 * t293
  t1062 = t469 * t1061
  t1071 = t6 * t23
  t1076 = t2 * t249
  t1081 = t114 ** 2
  t1093 = t125 * t254
  t1098 = t129 * t5 / t22 / t181
  t1100 = 0.1e1 / t300
  t1101 = t133 * t1100
  t1106 = t139 * t6 / t7 / t300
  t1108 = -0.37560000000000000000000000000000000000000000000000e-1 * t1076 + 0.40985000000000000000000000000000000000000000000000e-2 * t1093 - 0.10566666666666666666666666666666666666666666666667e-2 * t1098 + 0.38340000000000000000000000000000000000000000000000e-3 * t1101 - 0.42010937500000000000000000000000000000000000000000e-5 * t1106
  t1110 = 0.73596627000000000000000000000000000000000000000000e-2 * t1076 * t115 + 0.14719325400000000000000000000000000000000000000000e-1 * t223 * t238 + 0.22078988100000000000000000000000000000000000000000e-1 * t107 / t1081 * t913 - 0.73596627000000000000000000000000000000000000000000e-2 * t107 * t227 * t942 - t1003 * t145 - 0.2e1 * t241 * t257 - t123 * t1108
  t1138 = 0.29479012345679012345679012345679012345679012345678e-2 * t330 * t1051 * t1053 + 0.29479012345679012345679012345679012345679012345678e-2 * t264 * t328 * t1057 * t331 * t206 * t1062 - 0.29479012345679012345679012345679012345679012345678e-2 * t330 * t331 * t322 * t170 * t335 + t976 - t957 + t972 + 0.58958024691358024691358024691358024691358024691357e-2 * t104 * t1071 * t147 * t219 + 0.13265555555555555555555555555555555555555555555555e-1 * t104 * t222 * t1110 * t219 + 0.35374814814814814814814814814814814814814814814814e-1 * t104 * t105 * t259 * t219 + t983 - t994 - t1002 - 0.29479012345679012345679012345679012345679012345678e-2 * t264 * t141 * t259 * t166 * t336 + 0.14739506172839506172839506172839506172839506172838e-2 * t264 * t253 * t147 * t166 * t336 - t951 - 0.26531111111111111111111111111111111111111111111110e-1 * t269 * t271 * t323 * t1061 + 0.26531111111111111111111111111111111111111111111110e-1 * t269 * t340 * t343 * t293 * t322
  t1140 = (t1049 + t1138) * t378
  t1141 = t348 * t387
  t1143 = 0.2e1 * t1141 * t484
  t1146 = t385 / t386 / t377
  t1147 = t484 ** 2
  t1149 = 0.2e1 * t1146 * t1147
  t1157 = t339 ** 2
  t1159 = t366 * t368 * t1157
  t1160 = t341 ** 2
  t1161 = 0.1e1 / t1160
  t1162 = t371 * t1161
  t1167 = t359 * t1015
  t1185 = t1017 * t1 * t150
  t1186 = t361 * t342
  t1190 = t104 * t7
  t1200 = -0.16666666666666666666666666666666666666666666666667e0 * t415 * t416 * t1007 + 0.25000000000000000000000000000000000000000000000001e1 * t476 * t448 * t479 * t1017 - 0.15000000000000000000000000000000000000000000000001e1 * t1159 * t448 * t1162 * t1017 + 0.33333333333333333333333333333333333333333333333334e0 * t1167 * t416 * t1018 + 0.16666666666666666666666666666666666666666666666667e0 * t360 * t876 * t1 * t150 * t362 - 0.33333333333333333333333333333333333333333333333334e0 * t409 * t267 * t271 * t417 - 0.10000000000000000000000000000000000000000000000000e1 * t370 * t448 * t449 * t1017 - 0.50000000000000000000000000000000000000000000000001e0 * t438 * t1185 * t1186 - 0.13333333333333333333333333333333333333333333333334e1 * t370 * t1190 * t454 + 0.66666666666666666666666666666666666666666666666670e0 * t447 * t1190 * t450 + 0.22222222222222222222222222222222222222222222222222e0 * t360 * t421 * t426
  t1204 = t151 * t11
  t1208 = t410 * t340
  t1243 = 0.16666666666666666666666666666666666666666666666667e0 * t360 * t1185 * t362 - 0.22222222222222222222222222222222222222222222222222e0 * t438 * t1204 * t344 - 0.33333333333333333333333333333333333333333333333334e0 * t1208 * t439 + 0.33333333333333333333333333333333333333333333333334e0 * t358 * t1036 * t271 * t416 * t1040 - 0.22222222222222222222222222222222222222222222222222e0 * t415 * t1204 * t294 + 0.50000000000000000000000000000000000000000000000002e0 * t476 * t448 * t479 * t876 + 0.25000000000000000000000000000000000000000000000001e0 * t447 * t448 * t449 * t1006 - 0.50000000000000000000000000000000000000000000000002e0 * t370 * t448 * t449 * t876 - 0.16666666666666666666666666666666666666666666666667e0 * t438 * t416 * t877 + 0.50000000000000000000000000000000000000000000000002e0 * t259 * t267 * t369 * t451 + 0.33333333333333333333333333333333333333333333333334e0 * t411 * t422 + 0.13333333333333333333333333333333333333333333333334e1 * t476 * t1190 * t480
  t1247 = t442 * t475
  t1256 = t446 * t164
  t1257 = t464 * t19
  t1258 = t1256 * t1257
  t1260 = t103 * t8 * t371
  t1261 = t342 * t293
  t1262 = t1261 * t322
  t1266 = t367 * t474
  t1267 = t1266 * t19
  t1268 = t1256 * t1267
  t1274 = t414 * t165
  t1275 = t1050 * t1
  t1276 = t1274 * t1275
  t1278 = t150 * t22 * t214
  t1282 = t331 * t322
  t1287 = t463 * t1266 * t104
  t1290 = t210 * t322
  t1295 = t1256 * t465
  t1310 = -0.10000000000000000000000000000000000000000000000000e1 * t443 * t455 + 0.10000000000000000000000000000000000000000000000000e1 * t1247 * t481 - 0.50000000000000000000000000000000000000000000000002e0 * t147 * t1036 * t369 * t448 * t449 * t1039 + 0.10000000000000000000000000000000000000000000000000e1 * t1258 * t1260 * t1262 - 0.10000000000000000000000000000000000000000000000000e1 * t1268 * t1260 * t478 * t293 * t322 + 0.33333333333333333333333333333333333333333333333334e0 * t1276 * t1278 * t1262 - 0.33333333333333333333333333333333333333333333333334e0 * t1274 * t1282 * t417 - 0.22222222222222222222222222222222222222222222222224e0 * t1287 * t467 * t478 * t170 * t333 * t1290 - 0.11111111111111111111111111111111111111111111111112e0 * t1295 * t467 * t1261 * t470 + 0.22222222222222222222222222222222222222222222222224e0 * t466 * t467 * t1052 * t470 + 0.22222222222222222222222222222222222222222222222222e0 * t411 * t427 - 0.25000000000000000000000000000000000000000000000001e0 * t1110 * t163 * t369 * t374
  t1323 = t20 * t208
  t1333 = t3 * t141
  t1353 = 0.61912500000000000000000000000000000000000000000000e-2 * t1003 * t349 * t351 - 0.24765000000000000000000000000000000000000000000000e-1 * t241 * t152 * t14 * t396 - 0.12382500000000000000000000000000000000000000000000e-1 * t389 * t400 + 0.20637500000000000000000000000000000000000000000000e-2 * t123 * t281 * t40 * t156 * t19 * t1323 + 0.24765000000000000000000000000000000000000000000000e-1 * t392 * t14 * t115 * t4 * t9 * t237 + 0.16510000000000000000000000000000000000000000000000e-1 * t393 * t394 * t1333 + 0.12382500000000000000000000000000000000000000000000e-1 * t350 * t154 * t227 * t913 - 0.61912500000000000000000000000000000000000000000000e-2 * t350 * t399 * t942 + 0.17687407407407407407407407407407407407407407407407e-1 * t151 * t10 * t145 - 0.10612444444444444444444444444444444444444444444444e0 * t151 * t12 * t257 - 0.79593333333333333333333333333333333333333333333331e-1 * t151 * t354 * t1108
  t1358 = t23 * t371
  t1365 = t9 * t214
  t1370 = t463 * t1257
  t1374 = t103 / t300 / t134 * t171
  t1376 = 0.1e1 / t172 / t132
  t1377 = t1376 * t843
  t1378 = t68 * t342
  t1384 = t150 * t1100 * t170
  t1389 = t410 * t165 * t431
  t1393 = t430 * t1050 * t151
  t1395 = t249 * t170 * t205
  t1399 = t442 * t164
  t1403 = t253 * t214
  t1417 = 0.16666666666666666666666666666666666666666666666667e0 * t1353 * t163 * t271 * t363 - 0.11111111111111111111111111111111111111111111111112e0 * t370 * t104 * t1358 * t342 - 0.66666666666666666666666666666666666666666666666670e0 * t443 * t460 - 0.37037037037037037037037037037037037037037037037037e-1 * t360 * t151 * t1365 * t217 - 0.12345679012345679012345679012345679012345679012346e-1 * t1370 * t1374 * t1377 * t1378 + 0.43209876543209876543209876543209876543209876543211e-1 * t432 * t1384 * t335 - 0.37037037037037037037037037037037037037037037037038e-1 * t1389 * t435 + 0.37037037037037037037037037037037037037037037037038e-1 * t1393 * t1395 * t1053 + 0.11111111111111111111111111111111111111111111111112e0 * t1399 * t465 * t471 - 0.55555555555555555555555555555555555555555555555562e-1 * t466 * t1403 * t342 * t470 + 0.37037037037037037037037037037037037037037037037038e-1 * t1274 * t331 * t151 * t1395 * t1062 - 0.37037037037037037037037037037037037037037037037038e-1 * t430 * t331 * t420 * t435
  t1420 = t388 * (t1200 + t1243 + t1310 + t1417)
  t1422 = 0.11696446794910408141662685001236899248561775660981e1 * t532 * t981
  t1424 = 0.58482233974552040708313425006184496242808878304903e0 * t532 * t992
  t1426 = 0.17315755899375863299672358916972966258900005419821e2 * t532 * t1000
  t1431 = t541 ** 2
  t1433 = t610 ** 2
  t1453 = -t918 * t537 * t19 * t922 / 0.18e2 - t40 * t607 * t1 * t43 / 0.6e1 + t602 * t929 / 0.9e1 + t14 * (-0.99474444444444444444444444444444444444444444444447e-4 * t933 + 0.19894888888888888888888888888888888888888888888889e-3 * t935 + 0.52442777777777777777777777777777777777777777777777e-2 * t937) / 0.2e1
  t1467 = t515 ** 2
  t1481 = t508 ** 2
  t1484 = t501 ** 2
  t1507 = -0.70981924444444444444444444444444444444444444444442e-3 * t4 * t142 * t502 - 0.34246666666666666666666666666666666666666666666666e-1 * t818 * t9 * t509 * t517 - 0.20000000000000000000000000000000000000000000000000e1 * t507 / t508 / t498 * t1467 * t516 + 0.99999999999999999999999999999999999999999999999999e0 * t510 * (-0.78438333333333333333333333333333333333333333333333e0 * t933 + 0.15687666666666666666666666666666666666666666666667e1 * t935 + 0.68863333333333333333333333333333333333333333333333e0 * t937 + 0.14025833333333333333333333333333333333333333333333e0 * t963 + 0.28051666666666666666666666666666666666666666666667e0 * t965 + 0.17365833333333333333333333333333333333333333333333e0 * t967) * t516 + 0.32164683177870697973624959794146027661627532968800e2 * t507 / t1481 * t1467 / t1484 + t951 + t822 + t957 - t972 - t835 - 0.24415406715670879921742973310852762593515528885057e-3 * t4 * t142 * t82 - 0.10843580882781524214666447553230042011687479519034e-1 * t818 * t9 * t91 * t524 - 0.11696446794910408141662685001236899248561775660981e1 * t88 * t978 * t979 * t98 + 0.58482233974552040708313425006184496242808878304903e0 * t523 * t990 * t98 + 0.17315755899375863299672358916972966258900005419821e2 * t88 * t996 * t979 * t999
  t1508 = t493 * t1507
  t1510 = 0.24415406715670879921742973310852762593515528885057e-3 * t529 * t824
  t1513 = 0.10843580882781524214666447553230042011687479519034e-1 * t493 * t4 * t974
  t1514 = -t951 - t822 - t957 + t972 + t835 + t1508 + t1510 + t1513 + t1422 - t1424 - t1426
  t1523 = -0.48613650000000000000000000000000000000000000000000e-1 * t1076 + 0.58332050000000000000000000000000000000000000000000e-2 * t1093 - 0.16123583333333333333333333333333333333333333333333e-2 * t1098 + 0.60452325000000000000000000000000000000000000000000e-3 * t1101 - 0.67352906250000000000000000000000000000000000000000e-5 * t1106
  t1525 = 0.66830952067500000000000000000000000000000000000000e-2 * t1076 * t542 + 0.13366190413500000000000000000000000000000000000000e-1 * t223 * t611 + 0.20049285620250000000000000000000000000000000000000e-1 * t107 / t1431 * t1433 - 0.66830952067500000000000000000000000000000000000000e-2 * t107 * t600 * t1453 - t1514 * t558 - 0.2e1 * t614 * t621 - t552 * t1523
  t1538 = t670 ** 2
  t1539 = t1538 * t214
  t1544 = t7 * t560
  t1546 = t264 * t1544 * t570
  t1549 = t8 * t623
  t1551 = t264 * t1549 * t570
  t1555 = 0.1e1 / t629 / t569
  t1558 = t647 ** 2
  t1559 = t634 * t1558
  t1564 = t839 * t579 * t655
  t1566 = t577 ** 2
  t1568 = 0.1e1 / t1566 / t577
  t1570 = t1568 * jnp.pi * t659
  t1575 = t584 / t658 / t586
  t1583 = t661 * t838 * t579 * t305
  t1593 = (0.63e2 / 0.256e3 * t1564 - 0.49e2 / 0.8192e4 * t848 * t1570 + 0.49e2 / 0.24576e5 * t1575 * t844 * t847 * t1568 * jnp.pi - 0.21e2 / 0.256e3 * t1583) * t318 - 0.4e1 / 0.3e1 * t666 * t106 + 0.7e1 / 0.96e2 * t1564 - 0.7e1 / 0.288e3 * t1583 + 0.4e1 / 0.3e1 * t588 * t135
  t1599 = t690 * t1593
  t1632 = t614 ** 2
  t1636 = -0.11281315546296296296296296296296296296296296296296e-3 * t153 * t895 * t563 + 0.1e-52 * t282 * t899 * t563 - 0.67687893277777777777777777777777777777777777777778e-3 * t153 * t273 * t641 + 0.50765919958333333333333333333333333333333333333334e-3 * t906 * t40 * t563 + 0.50765919958333333333333333333333333333333333333334e-3 * t282 * t283 * t641 + 0.10153183991666666666666666666666666666666666666667e-2 * t153 * t155 * t600 * t1433 - 0.50765919958333333333333333333333333333333333333334e-3 * t153 * t155 * t542 * t1453 - 0.4e1 * t1632 - 0.4e1 * t552 * t1514
  t1637 = t634 * t1636
  t1645 = -t822 + t1422 - t1424 - t1426 + 0.35852777777777777777777777777777777777777777777779e-2 * t104 * t222 * t1525 * t594 + 0.15934567901234567901234567901234567901234567901235e-2 * t104 * t1071 * t560 * t594 + 0.95607407407407407407407407407407407407407407407410e-2 * t104 * t105 * t623 * t594 + 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t633 * t1539 * t592 - 0.95607407407407407407407407407407407407407407407410e-2 * t1546 * t692 - 0.71705555555555555555555555555555555555555555555558e-2 * t1551 * t692 + 0.71705555555555555555555555555555555555555555555558e-2 * t264 * t628 * t1555 * t633 * t1559 + 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t633 * t1593 * t214 * t592 - 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t687 * t1599 - 0.71705555555555555555555555555555555555555555555558e-2 * t264 * t1549 * t630 * t649 + 0.71705555555555555555555555555555555555555555555558e-2 * t1551 * t673 - 0.35852777777777777777777777777777777777777777777779e-2 * t632 * t633 * t1637 - 0.95607407407407407407407407407407407407407407407410e-2 * t264 * t1544 * t630 * t649
  t1652 = t270 * t803
  t1653 = t214 * t807
  t1654 = t1653 * t1538
  t1658 = t168 * t686
  t1659 = t1658 * t206
  t1660 = t689 * t670
  t1661 = t469 * t1660
  t1665 = t630 * t165
  t1669 = t592 * t647
  t1670 = t469 * t1669
  t1698 = 0.95607407407407407407407407407407407407407407407410e-2 * t1546 * t673 - 0.10755833333333333333333333333333333333333333333334e-1 * t653 * t687 * t1539 * t689 + 0.71705555555555555555555555555555555555555555555558e-2 * t653 * t1652 * t1654 + t835 + 0.79672839506172839506172839506172839506172839506176e-3 * t678 * t1659 * t1661 + 0.79672839506172839506172839506172839506172839506176e-3 * t264 * t676 * t1665 * t679 * t206 * t1670 - 0.79672839506172839506172839506172839506172839506176e-3 * t678 * t679 * t670 * t170 * t682 + t1513 - 0.71705555555555555555555555555555555555555555555558e-2 * t632 * t633 * t671 * t1669 + 0.71705555555555555555555555555555555555555555555558e-2 * t632 * t687 * t690 * t647 * t670 - t957 + t972 + 0.39836419753086419753086419753086419753086419753089e-3 * t264 * t253 * t560 * t571 * t683 - 0.79672839506172839506172839506172839506172839506176e-3 * t264 * t141 * t623 * t571 * t683 + t1510 - t951 + t1508
  t1701 = t695 * t726
  t1706 = t724 / t725 / t717
  t1707 = t813 ** 2
  t1710 = t780 * t164
  t1711 = t367 * t803
  t1712 = t1711 * t19
  t1713 = t1710 * t1712
  t1719 = t796 * t19
  t1720 = t1710 * t1719
  t1721 = t689 * t647
  t1722 = t1721 * t670
  t1726 = t752 * t165
  t1727 = t1658 * t1
  t1728 = t1726 * t1727
  t1732 = t679 * t670
  t1736 = t795 * t1719
  t1737 = t68 * t689
  t1746 = t748 * t165 * t767
  t1750 = t795 * t1711 * t104
  t1753 = t210 * t670
  t1758 = t1710 * t797
  t1773 = -0.10000000000000000000000000000000000000000000000000e1 * t1713 * t1260 * t807 * t647 * t670 + 0.10000000000000000000000000000000000000000000000000e1 * t1720 * t1260 * t1722 + 0.33333333333333333333333333333333333333333333333334e0 * t1728 * t1278 * t1722 - 0.33333333333333333333333333333333333333333333333334e0 * t1726 * t1732 * t754 - 0.12345679012345679012345679012345679012345679012346e-1 * t1736 * t1374 * t1377 * t1737 + 0.43209876543209876543209876543209876543209876543211e-1 * t768 * t1384 * t682 - 0.37037037037037037037037037037037037037037037037038e-1 * t1746 * t769 - 0.22222222222222222222222222222222222222222222222224e0 * t1750 * t467 * t807 * t170 * t333 * t1753 - 0.11111111111111111111111111111111111111111111111112e0 * t1758 * t467 * t1721 * t470 + 0.22222222222222222222222222222222222222222222222224e0 * t798 * t467 * t1660 * t470 - 0.50000000000000000000000000000000000000000000000002e0 * t560 * t1555 * t711 * t448 * t782 * t1558
  t1817 = 0.58998125000000000000000000000000000000000000000000e-2 * t1514 * t349 * t697 - 0.23599250000000000000000000000000000000000000000000e-1 * t614 * t152 * t14 * t734 - 0.11799625000000000000000000000000000000000000000000e-1 * t728 * t738 + 0.19666041666666666666666666666666666666666666666667e-2 * t552 * t281 * t40 * t563 * t19 * t1323 + 0.23599250000000000000000000000000000000000000000000e-1 * t731 * t14 * t542 * t4 * t9 * t610 + 0.15732833333333333333333333333333333333333333333333e-1 * t732 * t733 * t1333 + 0.11799625000000000000000000000000000000000000000000e-1 * t696 * t154 * t600 * t1433 - 0.58998125000000000000000000000000000000000000000000e-2 * t696 * t737 * t1453 + 0.47803703703703703703703703703703703703703703703703e-2 * t151 * t10 * t558 - 0.28682222222222222222222222222222222222222222222222e-1 * t151 * t12 * t621 - 0.21511666666666666666666666666666666666666666666667e-1 * t151 * t354 * t1523
  t1844 = t766 * t1658 * t151
  t1856 = t776 * t164
  t1860 = 0.66666666666666666666666666666666666666666666666670e0 * t781 * t1190 * t783 + 0.16666666666666666666666666666666666666666666666667e0 * t1817 * t570 * t633 * t707 - 0.37037037037037037037037037037037037037037037037037e-1 * t705 * t151 * t1365 * t592 - 0.66666666666666666666666666666666666666666666666670e0 * t777 * t792 + 0.22222222222222222222222222222222222222222222222222e0 * t749 * t763 - 0.11111111111111111111111111111111111111111111111112e0 * t712 * t104 * t1358 * t689 - 0.25000000000000000000000000000000000000000000000001e0 * t1525 * t570 * t711 * t714 + 0.37037037037037037037037037037037037037037037037038e-1 * t1726 * t679 * t151 * t1395 * t1670 + 0.37037037037037037037037037037037037037037037037038e-1 * t1844 * t1395 * t1661 - 0.55555555555555555555555555555555555555555555555562e-1 * t798 * t1403 * t689 * t470 - 0.37037037037037037037037037037037037037037037037038e-1 * t766 * t679 * t757 * t769 + 0.11111111111111111111111111111111111111111111111112e0 * t1856 * t797 * t800
  t1866 = t686 ** 2
  t1868 = t710 * t368 * t1866
  t1869 = t688 ** 2
  t1870 = 0.1e1 / t1869
  t1871 = t371 * t1870
  t1884 = t704 * t1652
  t1889 = t1538 * t1 * t150
  t1890 = t361 * t689
  t1902 = t776 * t804
  t1911 = -0.50000000000000000000000000000000000000000000000002e0 * t712 * t448 * t782 * t1593 - 0.15000000000000000000000000000000000000000000000001e1 * t1868 * t448 * t1871 * t1538 - 0.10000000000000000000000000000000000000000000000000e1 * t712 * t448 * t782 * t1538 + 0.25000000000000000000000000000000000000000000000001e1 * t805 * t448 * t808 * t1538 + 0.33333333333333333333333333333333333333333333333334e0 * t1884 * t416 * t1654 - 0.50000000000000000000000000000000000000000000000001e0 * t772 * t1889 * t1890 - 0.13333333333333333333333333333333333333333333333334e1 * t712 * t1190 * t787 + 0.13333333333333333333333333333333333333333333333334e1 * t805 * t1190 * t809 - 0.10000000000000000000000000000000000000000000000000e1 * t777 * t788 + 0.10000000000000000000000000000000000000000000000000e1 * t1902 * t810 + 0.22222222222222222222222222222222222222222222222222e0 * t705 * t758 * t762 + 0.16666666666666666666666666666666666666666666666667e0 * t705 * t1889 * t706
  t1915 = t748 * t687
  t1955 = -0.22222222222222222222222222222222222222222222222222e0 * t772 * t1204 * t691 - 0.33333333333333333333333333333333333333333333333334e0 * t1915 * t773 + 0.33333333333333333333333333333333333333333333333334e0 * t703 * t1555 * t633 * t416 * t1559 - 0.22222222222222222222222222222222222222222222222222e0 * t753 * t1204 * t648 - 0.16666666666666666666666666666666666666666666666667e0 * t772 * t416 * t1599 + 0.50000000000000000000000000000000000000000000000002e0 * t623 * t630 * t711 * t784 + 0.33333333333333333333333333333333333333333333333334e0 * t749 * t759 - 0.16666666666666666666666666666666666666666666666667e0 * t753 * t416 * t1637 + 0.16666666666666666666666666666666666666666666666667e0 * t705 * t1593 * t1 * t150 * t706 - 0.33333333333333333333333333333333333333333333333334e0 * t747 * t630 * t633 * t754 + 0.50000000000000000000000000000000000000000000000002e0 * t805 * t448 * t808 * t1593 + 0.25000000000000000000000000000000000000000000000001e0 * t781 * t448 * t782 * t1636
  v2rho2_0_ = 0.2e1 * t379 - 0.2e1 * t485 + 0.2e1 * t72 * (t695 * t718 - t727 * t813 - t379 + t485) + r0 * (t1140 - t1143 + t1149 - t1420 + t72 * ((t1645 + t1698) * t718 - 0.2e1 * t1701 * t813 + 0.2e1 * t1706 * t1707 - t727 * (t1773 + t1860 + t1911 + t1955) - t1140 + t1143 - t1149 + t1420))
  t1963 = t175 * t184
  t1967 = t311 * t175
  t1969 = t184 * t190 * t305
  t1972 = 0.3e1 / 0.128e3 * t1963 * t190 * t306 - t1967 * t1969 / 0.128e3
  t1974 = 0.1e1 / s0
  t1977 = t1972 * t318 + t202 * t1974 / 0.2e1
  t1978 = t1977 * t214
  t1980 = t271 * t1978 * t217
  t1983 = t9 * t147
  t1986 = t206 * t334
  t1987 = t271 * t1986
  t1990 = t343 * t1977
  t1991 = t340 * t1990
  t1994 = 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t1980 + 0.55273148148148148148148148148148148148148148148146e-3 * t264 * t1983 * t163 * t1987 - 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t1991
  t1995 = t1994 * t378
  t1996 = t1977 * t1
  t1997 = t1996 * t150
  t1998 = t1997 * t362
  t2002 = t150 * t135 * t170
  t2003 = t205 * t210
  t2004 = t2003 * t217
  t2005 = t2002 * t2004
  t2008 = t416 * t1990
  t2011 = t449 * t1977
  t2012 = t448 * t2011
  t2016 = t103 * t9 * t214
  t2018 = t342 * t170 * t2003
  t2019 = t2016 * t2018
  t2022 = t479 * t1977
  t2023 = t448 * t2022
  t2026 = 0.16666666666666666666666666666666666666666666666667e0 * t360 * t1998 + 0.69444444444444444444444444444444444444444444444446e-2 * t432 * t2005 - 0.16666666666666666666666666666666666666666666666667e0 * t438 * t2008 - 0.50000000000000000000000000000000000000000000000002e0 * t370 * t2012 - 0.20833333333333333333333333333333333333333333333334e-1 * t1370 * t2019 + 0.50000000000000000000000000000000000000000000000002e0 * t476 * t2023
  t2027 = t388 * t2026
  t2031 = t660 * t175
  t2033 = t184 * t579 * t305
  t2036 = 0.3e1 / 0.128e3 * t1963 * t579 * t655 - t2031 * t2033 / 0.128e3
  t2040 = t2036 * t318 + t588 * t1974 / 0.2e1
  t2041 = t2040 * t214
  t2043 = t633 * t2041 * t592
  t2046 = t9 * t560
  t2049 = t206 * t681
  t2050 = t633 * t2049
  t2053 = t690 * t2040
  t2054 = t687 * t2053
  t2057 = 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t2043 + 0.14938657407407407407407407407407407407407407407408e-3 * t264 * t2046 * t570 * t2050 - 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t2054
  t2059 = t2040 * t1
  t2060 = t2059 * t150
  t2061 = t2060 * t706
  t2064 = t2003 * t592
  t2065 = t2002 * t2064
  t2068 = t416 * t2053
  t2071 = t782 * t2040
  t2072 = t448 * t2071
  t2076 = t689 * t170 * t2003
  t2077 = t2016 * t2076
  t2080 = t808 * t2040
  t2081 = t448 * t2080
  t2084 = 0.16666666666666666666666666666666666666666666666667e0 * t705 * t2061 + 0.69444444444444444444444444444444444444444444444446e-2 * t768 * t2065 - 0.16666666666666666666666666666666666666666666666667e0 * t772 * t2068 - 0.50000000000000000000000000000000000000000000000002e0 * t712 * t2072 - 0.20833333333333333333333333333333333333333333333334e-1 * t1736 * t2077 + 0.50000000000000000000000000000000000000000000000002e0 * t805 * t2081
  t2096 = t322 * t1977
  t2101 = t175 * t302
  t2103 = t2101 * t190 * t306
  t2105 = 0.1e1 / t845
  t2106 = t843 * t2105
  t2114 = t1967 * t314
  t2122 = (-0.21e2 / 0.256e3 * t2103 + 0.21e2 / 0.8192e4 * t2106 * t853 - 0.7e1 / 0.8192e4 * t858 * t843 * t2105 * t851 * jnp.pi + 0.7e1 / 0.256e3 * t2114) * t318 - 0.4e1 / 0.3e1 * t1972 * t106 - 0.7e1 / 0.256e3 * t2103 + 0.7e1 / 0.768e3 * t2114
  t2128 = t1977 * t170
  t2148 = t2003 * t1061
  t2153 = t264 * t1983 * t166
  t2157 = t1050 * t170
  t2158 = t2003 * t1052
  t2171 = t342 * t1977
  t2172 = t469 * t2171
  t2180 = t343 * t2122
  t2184 = 0.17687407407407407407407407407407407407407407407407e-1 * t883 * t1980 + 0.13265555555555555555555555555555555555555555555555e-1 * t892 * t1980 - 0.13265555555555555555555555555555555555555555555555e-1 * t269 * t271 * t1978 * t1061 + 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t271 * t2096 * t272 + 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t271 * t2122 * t214 * t217 - 0.14739506172839506172839506172839506172839506172839e-2 * t330 * t331 * t2128 * t335 - 0.39796666666666666666666666666666666666666666666665e-1 * t299 * t340 * t1978 * t1052 - 0.73697530864197530864197530864197530864197530864194e-3 * t264 * t328 * t163 * t1987 + 0.55273148148148148148148148148148148148148148148146e-3 * t264 * t9 * t259 * t163 * t1987 - 0.55273148148148148148148148148148148148148148148146e-3 * t264 * t1983 * t1057 * t332 * t2148 + 0.55273148148148148148148148148148148148148148148146e-3 * t2153 * t1282 * t1986 - 0.55273148148148148148148148148148148148148148148146e-3 * t2153 * t2157 * t2158 - 0.17687407407407407407407407407407407407407407407407e-1 * t883 * t1991 - 0.13265555555555555555555555555555555555555555555555e-1 * t892 * t1991 + 0.13265555555555555555555555555555555555555555555555e-1 * t269 * t340 * t343 * t1977 * t293 + 0.14739506172839506172839506172839506172839506172839e-2 * t330 * t1051 * t2172 + 0.26531111111111111111111111111111111111111111111110e-1 * t299 * t1015 * t1016 * t2096 - 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t340 * t2180
  t2185 = t2184 * t378
  t2186 = t1994 * t387
  t2187 = t2186 * t484
  t2188 = t1141 * t2026
  t2191 = 0.2e1 * t1146 * t2026 * t484
  t2192 = t430 * t1275
  t2197 = t103 * t141 * t214
  t2206 = t103 / t836 * t171
  t2207 = t1376 * s0
  t2212 = t430 * t1282
  t2213 = t151 * t135
  t2214 = t2213 * t1986
  t2221 = t2171 * t293
  t2225 = t478 * t1977
  t2230 = t331 * t1977
  t2254 = t2225 * t322
  t2271 = -0.69444444444444444444444444444444444444444444444446e-2 * t2192 * t2002 * t2158 + 0.27777777777777777777777777777777777777777777777779e-1 * t1370 * t2197 * t2018 - 0.20833333333333333333333333333333333333333333333334e-1 * t1399 * t1257 * t2019 + 0.46296296296296296296296296296296296296296296296298e-2 * t1370 * t2206 * t2207 * t1378 + 0.69444444444444444444444444444444444444444444444446e-2 * t2212 * t2214 - 0.69444444444444444444444444444444444444444444444446e-2 * t1274 * t431 * t2002 * t2148 + 0.50000000000000000000000000000000000000000000000002e0 * t1258 * t1260 * t2221 - 0.50000000000000000000000000000000000000000000000002e0 * t1268 * t1260 * t2225 * t293 - 0.16666666666666666666666666666666666666666666666667e0 * t1274 * t2230 * t417 + 0.16666666666666666666666666666666666666666666666667e0 * t2212 * t1998 + 0.69444444444444444444444444444444444444444444444446e-2 * t1389 * t2005 + 0.16666666666666666666666666666666666666666666666667e0 * t1276 * t1278 * t2221 - 0.15000000000000000000000000000000000000000000000001e1 * t463 * t367 * t1157 * t19 * t1260 * t1161 * t1977 * t322 - 0.10000000000000000000000000000000000000000000000000e1 * t1370 * t1260 * t2171 * t322 + 0.25000000000000000000000000000000000000000000000001e1 * t463 * t1267 * t1260 * t2254 + 0.33333333333333333333333333333333333333333333333334e0 * t430 * t168 * t474 * t1 * t1278 * t2254 - 0.50000000000000000000000000000000000000000000000001e0 * t430 * t1050 * t1977 * t439 - 0.13888888888888888888888888888888888888888888888889e-1 * t432 * t434 * t2004
  t2316 = t1365 * t342
  t2326 = t206 * t1290
  t2330 = t1365 * t478
  t2337 = -0.11111111111111111111111111111111111111111111111112e0 * t1287 * t467 * t2225 * t470 + 0.11111111111111111111111111111111111111111111111112e0 * t466 * t467 * t2171 * t470 + 0.11111111111111111111111111111111111111111111111111e0 * t360 * t1997 * t426 + 0.66666666666666666666666666666666666666666666666669e0 * t476 * t1190 * t2022 + 0.50000000000000000000000000000000000000000000000002e0 * t1247 * t2023 + 0.50000000000000000000000000000000000000000000000002e0 * t476 * t448 * t479 * t2122 + 0.16666666666666666666666666666666666666666666666667e0 * t411 * t1998 - 0.50000000000000000000000000000000000000000000000002e0 * t370 * t448 * t449 * t2122 - 0.11111111111111111111111111111111111111111111111111e0 * t438 * t1204 * t1990 - 0.66666666666666666666666666666666666666666666666669e0 * t370 * t1190 * t2011 + 0.16666666666666666666666666666666666666666666666667e0 * t360 * t2122 * t1 * t150 * t362 - 0.16666666666666666666666666666666666666666666666667e0 * t1208 * t2008 - 0.16666666666666666666666666666666666666666666666667e0 * t438 * t416 * t2180 - 0.50000000000000000000000000000000000000000000000002e0 * t443 * t2012 + 0.20833333333333333333333333333333333333333333333334e-1 * t1295 * t2316 * t206 * t210 * t293 - 0.18518518518518518518518518518518518518518518518519e-1 * t430 * t331 * t1996 * t435 - 0.41666666666666666666666666666666666666666666666668e-1 * t466 * t2316 * t2326 + 0.41666666666666666666666666666666666666666666666668e-1 * t1287 * t2330 * t2326 + 0.18518518518518518518518518518518518518518518518519e-1 * t1393 * t1395 * t2172
  t2339 = t388 * (t2271 + t2337)
  t2348 = t670 * t2040
  t2354 = t2101 * t579 * t655
  t2363 = t2031 * t663
  t2371 = (-0.21e2 / 0.256e3 * t2354 + 0.21e2 / 0.8192e4 * t2106 * t1570 - 0.7e1 / 0.8192e4 * t1575 * t843 * t2105 * t1568 * jnp.pi + 0.7e1 / 0.256e3 * t2363) * t318 - 0.4e1 / 0.3e1 * t2036 * t106 - 0.7e1 / 0.256e3 * t2354 + 0.7e1 / 0.768e3 * t2363
  t2377 = t2040 * t170
  t2397 = t2003 * t1669
  t2402 = t264 * t2046 * t571
  t2406 = t1658 * t170
  t2407 = t2003 * t1660
  t2420 = t689 * t2040
  t2421 = t469 * t2420
  t2429 = t690 * t2371
  t2433 = 0.47803703703703703703703703703703703703703703703705e-2 * t1546 * t2043 + 0.35852777777777777777777777777777777777777777777779e-2 * t1551 * t2043 - 0.35852777777777777777777777777777777777777777777779e-2 * t632 * t633 * t2041 * t1669 + 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t633 * t2348 * t634 + 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t633 * t2371 * t214 * t592 - 0.39836419753086419753086419753086419753086419753088e-3 * t678 * t679 * t2377 * t682 - 0.10755833333333333333333333333333333333333333333334e-1 * t653 * t687 * t2041 * t1660 - 0.19918209876543209876543209876543209876543209876544e-3 * t264 * t676 * t570 * t2050 + 0.14938657407407407407407407407407407407407407407408e-3 * t264 * t9 * t623 * t570 * t2050 - 0.14938657407407407407407407407407407407407407407408e-3 * t264 * t2046 * t1665 * t680 * t2397 + 0.14938657407407407407407407407407407407407407407408e-3 * t2402 * t1732 * t2049 - 0.14938657407407407407407407407407407407407407407408e-3 * t2402 * t2406 * t2407 - 0.47803703703703703703703703703703703703703703703705e-2 * t1546 * t2054 - 0.35852777777777777777777777777777777777777777777779e-2 * t1551 * t2054 + 0.35852777777777777777777777777777777777777777777779e-2 * t632 * t687 * t690 * t2040 * t647 + 0.39836419753086419753086419753086419753086419753088e-3 * t678 * t1659 * t2421 + 0.71705555555555555555555555555555555555555555555558e-2 * t653 * t1652 * t1653 * t2348 - 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t687 * t2429
  t2435 = t2057 * t726
  t2441 = t766 * t1732
  t2442 = t2213 * t2049
  t2453 = t807 * t2040
  t2454 = t2453 * t670
  t2485 = t2420 * t647
  t2492 = t679 * t2040
  t2509 = t766 * t1727
  t2513 = 0.69444444444444444444444444444444444444444444444446e-2 * t2441 * t2442 - 0.69444444444444444444444444444444444444444444444446e-2 * t1726 * t767 * t2002 * t2397 + 0.27777777777777777777777777777777777777777777777779e-1 * t1736 * t2197 * t2076 + 0.25000000000000000000000000000000000000000000000001e1 * t795 * t1712 * t1260 * t2454 - 0.13888888888888888888888888888888888888888888888889e-1 * t768 * t434 * t2064 + 0.33333333333333333333333333333333333333333333333334e0 * t766 * t168 * t803 * t1 * t1278 * t2454 - 0.50000000000000000000000000000000000000000000000001e0 * t766 * t1658 * t2040 * t773 - 0.15000000000000000000000000000000000000000000000001e1 * t795 * t367 * t1866 * t19 * t1260 * t1870 * t2040 * t670 - 0.50000000000000000000000000000000000000000000000002e0 * t1713 * t1260 * t2453 * t647 + 0.69444444444444444444444444444444444444444444444446e-2 * t1746 * t2065 + 0.16666666666666666666666666666666666666666666666667e0 * t1728 * t1278 * t2485 + 0.50000000000000000000000000000000000000000000000002e0 * t1720 * t1260 * t2485 - 0.16666666666666666666666666666666666666666666666667e0 * t1726 * t2492 * t754 + 0.16666666666666666666666666666666666666666666666667e0 * t2441 * t2061 - 0.10000000000000000000000000000000000000000000000000e1 * t1736 * t1260 * t2420 * t670 + 0.46296296296296296296296296296296296296296296296298e-2 * t1736 * t2206 * t2207 * t1737 - 0.20833333333333333333333333333333333333333333333334e-1 * t1856 * t1719 * t2077 - 0.69444444444444444444444444444444444444444444444446e-2 * t2509 * t2002 * t2407
  t2565 = t1365 * t689
  t2571 = t206 * t1753
  t2575 = t1365 * t807
  t2579 = 0.11111111111111111111111111111111111111111111111112e0 * t798 * t467 * t2420 * t470 - 0.11111111111111111111111111111111111111111111111112e0 * t1750 * t467 * t2453 * t470 - 0.50000000000000000000000000000000000000000000000002e0 * t712 * t448 * t782 * t2371 - 0.66666666666666666666666666666666666666666666666669e0 * t712 * t1190 * t2071 + 0.66666666666666666666666666666666666666666666666669e0 * t805 * t1190 * t2080 - 0.11111111111111111111111111111111111111111111111111e0 * t772 * t1204 * t2053 + 0.11111111111111111111111111111111111111111111111111e0 * t705 * t2060 * t762 + 0.50000000000000000000000000000000000000000000000002e0 * t1902 * t2081 + 0.50000000000000000000000000000000000000000000000002e0 * t805 * t448 * t808 * t2371 + 0.16666666666666666666666666666666666666666666666667e0 * t749 * t2061 + 0.16666666666666666666666666666666666666666666666667e0 * t705 * t2371 * t1 * t150 * t706 - 0.16666666666666666666666666666666666666666666666667e0 * t1915 * t2068 - 0.16666666666666666666666666666666666666666666666667e0 * t772 * t416 * t2429 - 0.50000000000000000000000000000000000000000000000002e0 * t777 * t2072 - 0.18518518518518518518518518518518518518518518518519e-1 * t766 * t679 * t2059 * t769 + 0.18518518518518518518518518518518518518518518518519e-1 * t1844 * t1395 * t2421 + 0.20833333333333333333333333333333333333333333333334e-1 * t1758 * t2565 * t206 * t210 * t647 - 0.41666666666666666666666666666666666666666666666668e-1 * t798 * t2565 * t2571 + 0.41666666666666666666666666666666666666666666666668e-1 * t1750 * t2575 * t2571
  v2rhosigma_0_ = t1995 - t2027 + t72 * (t2057 * t718 - t727 * t2084 - t1995 + t2027) + r0 * (t2185 - t2187 - t2188 + t2191 - t2339 + t72 * (t2433 * t718 - t2435 * t813 - t1701 * t2084 + 0.2e1 * t1706 * t2084 * t813 - t727 * (t2513 + t2579) - t2185 + t2187 + t2188 - t2191 + t2339))
  t2586 = t1977 ** 2
  t2587 = t2586 * t214
  t2592 = 0.1e1 / t175
  t2593 = t2592 * t184
  t2596 = 0.3e1 / 0.256e3 * t2593 * t190 * t306
  t2598 = 0.1e1 / t300 / t181
  t2599 = s0 * t2598
  t2609 = t311 * t2592 * t1969 / 0.256e3
  t2614 = 0.1e1 / t843
  t2617 = (t2596 - 0.9e1 / 0.8192e4 * t2599 * t853 + 0.3e1 / 0.8192e4 * t858 * s0 * t2598 * t851 * jnp.pi - t2609) * t318 + t1972 * t1974 / 0.2e1 + t2596 - t2609 - t202 * t2614 / 0.2e1
  t2630 = t2003 * t2171
  t2634 = t1016 * t2586
  t2638 = t343 * t2617
  t2643 = (0.13265555555555555555555555555555555555555555555555e-1 * t299 * t271 * t2587 * t217 + 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t271 * t2617 * t214 * t217 + 0.11054629629629629629629629629629629629629629629629e-2 * t2153 * t2230 * t1986 - 0.39796666666666666666666666666666666666666666666665e-1 * t299 * t340 * t2587 * t342 - 0.11054629629629629629629629629629629629629629629629e-2 * t2153 * t2157 * t2630 + 0.26531111111111111111111111111111111111111111111110e-1 * t299 * t1015 * t2634 - 0.13265555555555555555555555555555555555555555555555e-1 * t299 * t340 * t2638) * t378
  t2645 = 0.2e1 * t2186 * t2026
  t2646 = t2026 ** 2
  t2648 = 0.2e1 * t1146 * t2646
  t2650 = t2586 * t1 * t150
  t2678 = t2128 * t2003
  t2691 = t103 * t1100 * t171
  t2692 = t1376 * t68
  t2708 = 0.16666666666666666666666666666666666666666666666667e0 * t360 * t2650 * t362 + 0.16666666666666666666666666666666666666666666666667e0 * t360 * t2617 * t1 * t150 * t362 + 0.13888888888888888888888888888888888888888888888889e-1 * t430 * t2230 * t2214 - 0.50000000000000000000000000000000000000000000000001e0 * t438 * t2650 * t1186 - 0.13888888888888888888888888888888888888888888888889e-1 * t2192 * t2002 * t2630 + 0.33333333333333333333333333333333333333333333333334e0 * t1167 * t416 * t2634 - 0.16666666666666666666666666666666666666666666666667e0 * t438 * t416 * t2638 - 0.10000000000000000000000000000000000000000000000000e1 * t370 * t448 * t449 * t2586 - 0.83333333333333333333333333333333333333333333333336e-1 * t466 * t2316 * t2678 + 0.25000000000000000000000000000000000000000000000001e1 * t476 * t448 * t479 * t2586 - 0.50000000000000000000000000000000000000000000000002e0 * t370 * t448 * t449 * t2617 - 0.17361111111111111111111111111111111111111111111112e-2 * t1370 * t2691 * t2692 * t342 + 0.83333333333333333333333333333333333333333333333336e-1 * t1287 * t2330 * t2678 - 0.15000000000000000000000000000000000000000000000001e1 * t1159 * t448 * t1162 * t2586 + 0.50000000000000000000000000000000000000000000000002e0 * t476 * t448 * t479 * t2617
  t2709 = t388 * t2708
  t2710 = t2040 ** 2
  t2711 = t2710 * t214
  t2718 = 0.3e1 / 0.256e3 * t2593 * t579 * t655
  t2728 = t660 * t2592 * t2033 / 0.256e3
  t2735 = (t2718 - 0.9e1 / 0.8192e4 * t2599 * t1570 + 0.3e1 / 0.8192e4 * t1575 * s0 * t2598 * t1568 * jnp.pi - t2728) * t318 + t2036 * t1974 / 0.2e1 + t2718 - t2728 - t588 * t2614 / 0.2e1
  t2748 = t2003 * t2420
  t2752 = t1653 * t2710
  t2756 = t690 * t2735
  t2764 = t2084 ** 2
  t2768 = t2710 * t1 * t150
  t2796 = t2377 * t2003
  t2823 = 0.16666666666666666666666666666666666666666666666667e0 * t705 * t2768 * t706 + 0.16666666666666666666666666666666666666666666666667e0 * t705 * t2735 * t1 * t150 * t706 + 0.13888888888888888888888888888888888888888888888889e-1 * t766 * t2492 * t2442 - 0.50000000000000000000000000000000000000000000000001e0 * t772 * t2768 * t1890 - 0.13888888888888888888888888888888888888888888888889e-1 * t2509 * t2002 * t2748 + 0.33333333333333333333333333333333333333333333333334e0 * t1884 * t416 * t2752 - 0.16666666666666666666666666666666666666666666666667e0 * t772 * t416 * t2756 - 0.10000000000000000000000000000000000000000000000000e1 * t712 * t448 * t782 * t2710 - 0.83333333333333333333333333333333333333333333333336e-1 * t798 * t2565 * t2796 + 0.25000000000000000000000000000000000000000000000001e1 * t805 * t448 * t808 * t2710 - 0.50000000000000000000000000000000000000000000000002e0 * t712 * t448 * t782 * t2735 - 0.17361111111111111111111111111111111111111111111112e-2 * t1736 * t2691 * t2692 * t689 + 0.83333333333333333333333333333333333333333333333336e-1 * t1750 * t2575 * t2796 - 0.15000000000000000000000000000000000000000000000001e1 * t1868 * t448 * t1871 * t2710 + 0.50000000000000000000000000000000000000000000000002e0 * t805 * t448 * t808 * t2735
  v2sigma2_0_ = r0 * (t2643 - t2645 + t2648 - t2709 + t72 * ((0.35852777777777777777777777777777777777777777777779e-2 * t653 * t633 * t2711 * t592 + 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t633 * t2735 * t214 * t592 + 0.29877314814814814814814814814814814814814814814816e-3 * t2402 * t2492 * t2049 - 0.10755833333333333333333333333333333333333333333334e-1 * t653 * t687 * t2711 * t689 - 0.29877314814814814814814814814814814814814814814816e-3 * t2402 * t2406 * t2748 + 0.71705555555555555555555555555555555555555555555558e-2 * t653 * t1652 * t2752 - 0.35852777777777777777777777777777777777777777777779e-2 * t653 * t687 * t2756) * t718 - 0.2e1 * t2435 * t2084 + 0.2e1 * t1706 * t2764 - t727 * t2823 - t2643 + t2645 - t2648 + t2709))
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t8 * t7
  t10 = 0.1e1 / t9
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t24 = 0.1e1 / t23
  t26 = t22 * t5 * t24
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t28
  t32 = jnp.log(t31)
  t35 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t11 * t32
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t41 = 0.1e1 / t15
  t42 = t41 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t54 = 0.1e1 / t23 / t7
  t55 = t5 * t54
  t56 = t22 * t55
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t62 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * t60
  t63 = 0.1e1 <= f.p.zeta_threshold
  t64 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = t64 * f.p.zeta_threshold
  t66 = f.my_piecewise3(t63, t65, 1)
  t69 = 2 ** (0.1e1 / 0.3e1)
  t72 = 0.1e1 / (0.2e1 * t69 - 0.2e1)
  t73 = (0.2e1 * t66 - 0.2e1) * t72
  t74 = t73 * t1
  t79 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t82 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t79
  t83 = jnp.log(t82)
  t85 = t43 * t10 * t83
  t87 = 0.18311555036753159941307229983139571945136646663793e-3 * t74 * t85
  t89 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t90 = t73 * t89
  t91 = t79 ** 2
  t92 = 0.1e1 / t91
  t97 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t99 = 0.1e1 / t82
  t100 = t92 * t97 * t99
  t102 = 0.58482233974552040708313425006184496242808878304903e0 * t90 * t100
  t103 = t3 * t2
  t104 = 0.1e1 / t103
  t105 = t20 * t104
  t106 = t6 * t8
  t107 = 0.1e1 / t7
  t108 = t2 * t107
  t111 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t15 + 0.12382500000000000000000000000000000000000000000000e-1 * t14
  t114 = 0.1e1 + t15 * t111 / 0.2e1
  t115 = t114 ** 2
  t116 = 0.1e1 / t115
  t120 = 0.62182e-1 * t37 * t32
  t121 = t89 * t83
  t123 = 0.19751789702565206228825776161588751761046270558698e-1 * t73 * t121
  t124 = -t120 + t123
  t126 = t1 * t103
  t127 = t126 * t11
  t130 = t20 * t21 * t2
  t131 = t130 * t55
  t133 = jnp.pi ** 2
  t134 = 0.1e1 / t133
  t135 = t7 ** 2
  t136 = 0.1e1 / t135
  t137 = t134 * t136
  t140 = t1 * t3 * t134
  t142 = 0.1e1 / t8 / t135
  t143 = t6 * t142
  t144 = t140 * t143
  t146 = -0.18780000000000000000000000000000000000000000000000e-1 * t108 + 0.13173750000000000000000000000000000000000000000000e-2 * t127 - 0.23775000000000000000000000000000000000000000000000e-3 * t131 + 0.63900000000000000000000000000000000000000000000000e-4 * t137 - 0.54014062500000000000000000000000000000000000000000e-6 * t144
  t148 = 0.36798313500000000000000000000000000000000000000000e-2 * t108 * t116 - t124 * t146
  t151 = 0.1e1 / t21
  t152 = t1 * t151
  t153 = 4 ** (0.1e1 / 0.6e1)
  t154 = t152 * t153
  t155 = t15 * t14
  t156 = t23 * t155
  t157 = 0.1e1 / t114
  t161 = t124 ** 2
  t163 = 0.19711288999999999999999999999999999999999999999999e-2 * t154 * t156 * t157 - 0.2e1 * t161
  t164 = 0.1e1 / t163
  t165 = 9 ** (0.1e1 / 0.3e1)
  t166 = t165 ** 2
  t167 = t164 * t166
  t168 = jnp.pi ** (0.1e1 / 0.3e1)
  t169 = t168 ** 2
  t171 = 6 ** (0.1e1 / 0.3e1)
  t172 = t171 ** 2
  t173 = t133 ** (0.1e1 / 0.3e1)
  t177 = s0 + 0.2e1 * s1 + s2
  t178 = jnp.sqrt(t177)
  t182 = t172 / t173 * t178 * t10 * t69 / 0.12e2
  t183 = t178 * t177
  t184 = t135 * t7
  t185 = jnp.sqrt(t7)
  t188 = t183 / t185 / t184
  t189 = t64 ** 2
  t190 = f.my_piecewise3(t63, t189, 1)
  t191 = t190 ** 2
  t193 = 0.1e1 / t191 / t190
  t194 = jnp.sqrt(0.3e1)
  t196 = jnp.sqrt(t2)
  t197 = 0.1e1 / t196
  t199 = t188 * t193 * t194 * t197
  t201 = 0.854613e1 + t199 / 0.64e2
  t203 = 0.1e1 + t199 / 0.192e3
  t204 = 0.1e1 / t203
  t205 = t201 * t204
  t206 = t182 ** t205
  t207 = t173 ** 2
  t208 = 0.1e1 / t207
  t209 = t171 * t208
  t211 = 0.1e1 / t23 / t135
  t213 = t69 ** 2
  t217 = 0.14709046e2 + t209 * t177 * t211 * t213 / 0.24e2
  t219 = 0.1e1 + t206
  t220 = 0.1e1 / t219
  t222 = t167 * t169 * t206 * t217 * t220
  t225 = t6 * t9
  t226 = t2 * t136
  t230 = 0.1e1 / t115 / t114
  t232 = t41 * t111 * t1
  t237 = -0.66066666666666666666666666666666666666666666666667e-2 * t45 - 0.41275000000000000000000000000000000000000000000000e-2 * t47
  t240 = -t232 * t44 / 0.12e2 + t15 * t237 / 0.2e1
  t241 = t230 * t240
  t244 = t35 + t62 - t87 - t102
  t247 = t126 * t143
  t249 = t5 * t211
  t250 = t130 * t249
  t252 = 0.1e1 / t184
  t253 = t134 * t252
  t256 = 0.1e1 / t8 / t184
  t257 = t6 * t256
  t258 = t140 * t257
  t260 = 0.18780000000000000000000000000000000000000000000000e-1 * t226 - 0.17565000000000000000000000000000000000000000000000e-2 * t247 + 0.39625000000000000000000000000000000000000000000000e-3 * t250 - 0.12780000000000000000000000000000000000000000000000e-3 * t253 + 0.12603281250000000000000000000000000000000000000000e-5 * t258
  t262 = -0.36798313500000000000000000000000000000000000000000e-2 * t226 * t116 - 0.73596627000000000000000000000000000000000000000000e-2 * t108 * t241 - t244 * t146 - t124 * t260
  t267 = t105 * t6
  t268 = t9 * t148
  t269 = t163 ** 2
  t270 = 0.1e1 / t269
  t272 = t267 * t268 * t270
  t273 = t166 * t169
  t274 = t273 * t206
  t275 = t217 * t220
  t276 = t12 * t155
  t282 = t153 ** 2
  t283 = t282 ** 2
  t284 = t283 * t153
  t285 = t20 / t3 * t284
  t286 = t24 * t15
  t290 = t116 * t240
  t296 = 0.13140859333333333333333333333333333333333333333333e-2 * t154 * t276 * t157 - 0.98556444999999999999999999999999999999999999999995e-3 * t285 * t286 * t157 - 0.19711288999999999999999999999999999999999999999999e-2 * t154 * t156 * t290 - 0.4e1 * t124 * t244
  t297 = t275 * t296
  t298 = t274 * t297
  t302 = t267 * t268 * t164
  t303 = t135 ** 2
  t305 = 0.1e1 / t185 / t303
  t306 = t183 * t305
  t308 = t194 * t197
  t309 = t308 * t204
  t312 = t203 ** 2
  t313 = 0.1e1 / t312
  t315 = t201 * t313 * t183
  t320 = -0.7e1 / 0.128e3 * t306 * t193 * t309 + 0.7e1 / 0.384e3 * t315 * t305 * t193 * t308
  t321 = jnp.log(t182)
  t325 = t320 * t321 - 0.4e1 / 0.3e1 * t205 * t107
  t326 = t325 * t217
  t328 = t274 * t326 * t220
  t331 = t142 * t148
  t333 = t267 * t331 * t167
  t334 = t169 * t206
  t336 = t208 * t177
  t338 = t336 * t213 * t220
  t339 = t334 * t171 * t338
  t342 = t206 ** 2
  t343 = t273 * t342
  t344 = t219 ** 2
  t345 = 0.1e1 / t344
  t346 = t217 * t345
  t347 = t346 * t325
  t348 = t343 * t347
  t351 = t35 + t62 - t87 - t102 + 0.17687407407407407407407407407407407407407407407407e-1 * t105 * t106 * t148 * t222 + 0.13265555555555555555555555555555555555555555555555e-1 * t105 * t225 * t262 * t222 - 0.13265555555555555555555555555555555555555555555555e-1 * t272 * t298 + 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t328 - 0.14739506172839506172839506172839506172839506172839e-2 * t333 * t339 - 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t348
  t352 = jnp.sqrt(0.4e1)
  t353 = t124 * t352
  t354 = t155 * t157
  t357 = t6 * t23
  t361 = 0.61912500000000000000000000000000000000000000000000e-2 * t353 * t354 - 0.79593333333333333333333333333333333333333333333331e-1 * t152 * t357 * t146
  t362 = t361 * t164
  t363 = t362 * t274
  t364 = t23 * t217
  t365 = t364 * t220
  t366 = t152 * t365
  t369 = t148 * t164
  t370 = t168 * jnp.pi
  t371 = t165 * t370
  t372 = t371 * t342
  t373 = t369 * t372
  t374 = t217 ** 2
  t375 = t9 * t374
  t377 = t105 * t375 * t345
  t380 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t366 - 0.25000000000000000000000000000000000000000000000001e0 * t373 * t377
  t381 = 0.1e1 / t380
  t382 = t351 * t381
  t383 = 0.2e1 * t382
  t388 = -t120 + t123 + 0.13265555555555555555555555555555555555555555555555e-1 * t105 * t225 * t148 * t222
  t389 = t380 ** 2
  t390 = 0.1e1 / t389
  t391 = t388 * t390
  t392 = t244 * t352
  t395 = t124 * t153
  t396 = t395 * t15
  t397 = t157 * t1
  t398 = t3 * t10
  t399 = t397 * t398
  t402 = t155 * t116
  t403 = t402 * t240
  t412 = 0.61912500000000000000000000000000000000000000000000e-2 * t392 * t354 - 0.12382500000000000000000000000000000000000000000000e-1 * t396 * t399 - 0.61912500000000000000000000000000000000000000000000e-2 * t353 * t403 - 0.53062222222222222222222222222222222222222222222221e-1 * t152 * t13 * t146 - 0.79593333333333333333333333333333333333333333333331e-1 * t152 * t357 * t260
  t413 = t412 * t164
  t414 = t413 * t274
  t417 = t361 * t270
  t418 = t417 * t274
  t419 = t152 * t23
  t420 = t419 * t297
  t423 = t325 * t1
  t424 = t423 * t151
  t425 = t424 * t365
  t428 = t12 * t217
  t429 = t428 * t220
  t430 = t152 * t429
  t433 = t362 * t166
  t434 = t334 * t1
  t435 = t433 * t434
  t437 = t151 * t252 * t171
  t438 = t437 * t338
  t441 = t362 * t343
  t442 = t419 * t347
  t445 = t262 * t164
  t446 = t445 * t372
  t449 = t148 * t270
  t450 = t449 * t372
  t451 = t105 * t9
  t452 = t374 * t345
  t453 = t452 * t296
  t454 = t451 * t453
  t457 = t452 * t325
  t458 = t451 * t457
  t461 = t8 * t374
  t463 = t105 * t461 * t345
  t466 = t369 * t165
  t467 = t370 * t342
  t468 = t467 * t105
  t469 = t466 * t468
  t470 = t142 * t217
  t472 = t177 * t213
  t473 = t209 * t472
  t474 = t470 * t345 * t473
  t477 = t342 * t206
  t478 = t371 * t477
  t479 = t369 * t478
  t481 = 0.1e1 / t344 / t219
  t482 = t374 * t481
  t483 = t482 * t325
  t484 = t451 * t483
  t487 = 0.16666666666666666666666666666666666666666666666667e0 * t414 * t366 - 0.16666666666666666666666666666666666666666666666667e0 * t418 * t420 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t425 + 0.11111111111111111111111111111111111111111111111111e0 * t363 * t430 - 0.18518518518518518518518518518518518518518518518519e-1 * t435 * t438 - 0.16666666666666666666666666666666666666666666666667e0 * t441 * t442 - 0.25000000000000000000000000000000000000000000000001e0 * t446 * t377 + 0.25000000000000000000000000000000000000000000000001e0 * t450 * t454 - 0.50000000000000000000000000000000000000000000000002e0 * t373 * t458 - 0.33333333333333333333333333333333333333333333333335e0 * t373 * t463 + 0.55555555555555555555555555555555555555555555555558e-1 * t469 * t474 + 0.50000000000000000000000000000000000000000000000002e0 * t479 * t484
  t488 = t391 * t487
  t489 = 0.2e1 * t488
  t490 = r0 - r1
  t491 = t490 * t107
  t492 = 0.1e1 + t491
  t493 = t492 <= f.p.zeta_threshold
  t494 = t492 ** (0.1e1 / 0.3e1)
  t495 = t490 * t136
  t496 = t107 - t495
  t499 = f.my_piecewise3(t493, 0, 0.4e1 / 0.3e1 * t494 * t496)
  t500 = 0.1e1 - t491
  t501 = t500 <= f.p.zeta_threshold
  t502 = t500 ** (0.1e1 / 0.3e1)
  t503 = -t496
  t506 = f.my_piecewise3(t501, 0, 0.4e1 / 0.3e1 * t502 * t503)
  t508 = (t499 + t506) * t72
  t509 = 0.2e1 <= f.p.zeta_threshold
  t511 = f.my_piecewise3(t509, t65, 0.2e1 * t69)
  t512 = 0.0e0 <= f.p.zeta_threshold
  t513 = f.my_piecewise3(t512, t65, 0)
  t515 = (t511 + t513 - 0.2e1) * t72
  t517 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t522 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t525 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t522
  t526 = jnp.log(t525)
  t531 = t515 * (-0.31090e-1 * t517 * t526 + t120 - 0.19751789702565206228825776161588751761046270558698e-1 * t121)
  t533 = 0.19751789702565206228825776161588751761046270558698e-1 * t515 * t121
  t536 = 0.149676e1 + 0.89527000000000000000000000000000000000000000000000e-3 * t15 + 0.11799625000000000000000000000000000000000000000000e-1 * t14
  t539 = 0.1e1 + t15 * t536 / 0.2e1
  t540 = t539 ** 2
  t541 = 0.1e1 / t540
  t544 = -t120 + t531 + t533
  t550 = -0.24306825000000000000000000000000000000000000000000e-1 * t108 + 0.18749587500000000000000000000000000000000000000000e-2 * t127 - 0.36278062500000000000000000000000000000000000000000e-3 * t131 + 0.10075387500000000000000000000000000000000000000000e-3 * t137 - 0.86596593750000000000000000000000000000000000000000e-6 * t144
  t552 = 0.33415476033750000000000000000000000000000000000000e-2 * t108 * t541 - t544 * t550
  t555 = 0.1e1 / t539
  t559 = t544 ** 2
  t561 = 0.50765919958333333333333333333333333333333333333334e-3 * t154 * t156 * t555 - 0.2e1 * t559
  t562 = 0.1e1 / t561
  t563 = t562 * t166
  t565 = f.my_piecewise3(t509, t189, t213)
  t566 = f.my_piecewise3(t512, t189, 0)
  t568 = t565 / 0.2e1 + t566 / 0.2e1
  t569 = t568 ** 2
  t571 = 0.1e1 / t569 / t568
  t574 = t188 * t571 * t194 * t197
  t576 = 0.854613e1 + t574 / 0.64e2
  t578 = 0.1e1 + t574 / 0.192e3
  t579 = 0.1e1 / t578
  t580 = t576 * t579
  t581 = t182 ** t580
  t583 = 0.1e1 + t581
  t584 = 0.1e1 / t583
  t586 = t563 * t169 * t581 * t217 * t584
  t589 = -t120 + t531 + t533 + 0.35852777777777777777777777777777777777777777777779e-2 * t105 * t225 * t552 * t586
  t590 = t544 * t352
  t591 = t155 * t555
  t597 = 0.58998125000000000000000000000000000000000000000000e-2 * t590 * t591 - 0.21511666666666666666666666666666666666666666666667e-1 * t152 * t357 * t550
  t598 = t597 * t562
  t599 = t273 * t581
  t600 = t598 * t599
  t601 = t364 * t584
  t602 = t152 * t601
  t605 = t552 * t562
  t606 = t581 ** 2
  t607 = t371 * t606
  t608 = t605 * t607
  t609 = t583 ** 2
  t610 = 0.1e1 / t609
  t612 = t105 * t375 * t610
  t615 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t600 * t602 - 0.25000000000000000000000000000000000000000000000001e0 * t608 * t612
  t616 = 0.1e1 / t615
  t619 = -t388 * t381 + t589 * t616
  t620 = t508 * t619
  t623 = f.my_piecewise3(t493, t65, t494 * t492)
  t625 = f.my_piecewise3(t501, t65, t502 * t500)
  t627 = (t623 + t625 - 0.2e1) * t72
  t631 = t522 ** 2
  t632 = 0.1e1 / t631
  t633 = t517 * t632
  t638 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t639 = 0.1e1 / t525
  t640 = t638 * t639
  t646 = t89 * t92
  t647 = t97 * t99
  t651 = t515 * (0.53236443333333333333333333333333333333333333333332e-3 * t4 * t11 * t526 + 0.99999999999999999999999999999999999999999999999999e0 * t633 * t640 - t35 - t62 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t11 * t83 + 0.58482233974552040708313425006184496242808878304903e0 * t646 * t647)
  t652 = t515 * t1
  t654 = 0.18311555036753159941307229983139571945136646663793e-3 * t652 * t85
  t655 = t515 * t89
  t657 = 0.58482233974552040708313425006184496242808878304903e0 * t655 * t100
  t665 = 0.1e1 / t540 / t539
  t667 = t41 * t536 * t1
  t672 = -0.14921166666666666666666666666666666666666666666667e-3 * t45 - 0.39332083333333333333333333333333333333333333333333e-2 * t47
  t675 = -t667 * t44 / 0.12e2 + t15 * t672 / 0.2e1
  t676 = t665 * t675
  t679 = t35 + t62 + t651 - t654 - t657
  t686 = 0.24306825000000000000000000000000000000000000000000e-1 * t226 - 0.24999450000000000000000000000000000000000000000000e-2 * t247 + 0.60463437500000000000000000000000000000000000000000e-3 * t250 - 0.20150775000000000000000000000000000000000000000000e-3 * t253 + 0.20205871875000000000000000000000000000000000000000e-5 * t258
  t688 = -0.33415476033750000000000000000000000000000000000000e-2 * t226 * t541 - 0.66830952067500000000000000000000000000000000000000e-2 * t108 * t676 - t679 * t550 - t544 * t686
  t693 = t9 * t552
  t694 = t561 ** 2
  t695 = 0.1e1 / t694
  t697 = t267 * t693 * t695
  t698 = t217 * t584
  t705 = t541 * t675
  t711 = 0.33843946638888888888888888888888888888888888888889e-3 * t154 * t276 * t555 - 0.25382959979166666666666666666666666666666666666667e-3 * t285 * t286 * t555 - 0.50765919958333333333333333333333333333333333333334e-3 * t154 * t156 * t705 - 0.4e1 * t544 * t679
  t712 = t698 * t711
  t713 = t599 * t712
  t717 = t267 * t693 * t562
  t719 = t308 * t579
  t722 = t578 ** 2
  t723 = 0.1e1 / t722
  t725 = t576 * t723 * t183
  t730 = -0.7e1 / 0.128e3 * t306 * t571 * t719 + 0.7e1 / 0.384e3 * t725 * t305 * t571 * t308
  t734 = t730 * t321 - 0.4e1 / 0.3e1 * t580 * t107
  t735 = t734 * t217
  t737 = t599 * t735 * t584
  t740 = t142 * t552
  t742 = t267 * t740 * t563
  t743 = t169 * t581
  t746 = t336 * t213 * t584
  t747 = t743 * t171 * t746
  t750 = t273 * t606
  t751 = t217 * t610
  t752 = t751 * t734
  t753 = t750 * t752
  t756 = t35 + t62 + t651 - t654 - t657 + 0.47803703703703703703703703703703703703703703703705e-2 * t105 * t106 * t552 * t586 + 0.35852777777777777777777777777777777777777777777779e-2 * t105 * t225 * t688 * t586 - 0.35852777777777777777777777777777777777777777777779e-2 * t697 * t713 + 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t737 - 0.39836419753086419753086419753086419753086419753088e-3 * t742 * t747 - 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t753
  t758 = t615 ** 2
  t759 = 0.1e1 / t758
  t760 = t589 * t759
  t761 = t679 * t352
  t764 = t544 * t153
  t765 = t764 * t15
  t766 = t555 * t1
  t767 = t766 * t398
  t770 = t155 * t541
  t771 = t770 * t675
  t780 = 0.58998125000000000000000000000000000000000000000000e-2 * t761 * t591 - 0.11799625000000000000000000000000000000000000000000e-1 * t765 * t767 - 0.58998125000000000000000000000000000000000000000000e-2 * t590 * t771 - 0.14341111111111111111111111111111111111111111111111e-1 * t152 * t13 * t550 - 0.21511666666666666666666666666666666666666666666667e-1 * t152 * t357 * t686
  t781 = t780 * t562
  t782 = t781 * t599
  t785 = t597 * t695
  t786 = t785 * t599
  t787 = t419 * t712
  t790 = t734 * t1
  t791 = t790 * t151
  t792 = t791 * t601
  t795 = t428 * t584
  t796 = t152 * t795
  t799 = t598 * t166
  t800 = t743 * t1
  t801 = t799 * t800
  t802 = t437 * t746
  t805 = t598 * t750
  t806 = t419 * t752
  t809 = t688 * t562
  t810 = t809 * t607
  t813 = t552 * t695
  t814 = t813 * t607
  t815 = t374 * t610
  t816 = t815 * t711
  t817 = t451 * t816
  t820 = t815 * t734
  t821 = t451 * t820
  t825 = t105 * t461 * t610
  t828 = t605 * t165
  t829 = t370 * t606
  t830 = t829 * t105
  t831 = t828 * t830
  t833 = t470 * t610 * t473
  t836 = t606 * t581
  t837 = t371 * t836
  t838 = t605 * t837
  t840 = 0.1e1 / t609 / t583
  t841 = t374 * t840
  t842 = t841 * t734
  t843 = t451 * t842
  t846 = 0.16666666666666666666666666666666666666666666666667e0 * t782 * t602 - 0.16666666666666666666666666666666666666666666666667e0 * t786 * t787 + 0.16666666666666666666666666666666666666666666666667e0 * t600 * t792 + 0.11111111111111111111111111111111111111111111111111e0 * t600 * t796 - 0.18518518518518518518518518518518518518518518518519e-1 * t801 * t802 - 0.16666666666666666666666666666666666666666666666667e0 * t805 * t806 - 0.25000000000000000000000000000000000000000000000001e0 * t810 * t612 + 0.25000000000000000000000000000000000000000000000001e0 * t814 * t817 - 0.50000000000000000000000000000000000000000000000002e0 * t608 * t821 - 0.33333333333333333333333333333333333333333333333335e0 * t608 * t825 + 0.55555555555555555555555555555555555555555555555558e-1 * t831 * t833 + 0.50000000000000000000000000000000000000000000000002e0 * t838 * t843
  t848 = t756 * t616 - t760 * t846 - t382 + t488
  t850 = 0.2e1 * t627 * t848
  t851 = t4 * t6
  t855 = 0.35616666666666666666666666666666666666666666666666e-1 * t851 * t10 * t39 * t60
  t857 = t43 * t142 * t83
  t859 = 0.24415406715670879921742973310852762593515528885057e-3 * t74 * t857
  t865 = t220 * t296
  t875 = 0.1e1 / t155
  t878 = t21 * t5 * t211
  t879 = t875 * t20 * t878
  t881 = t43 * t142
  t882 = t42 * t881
  t884 = t4 * t143
  t886 = t14 ** (-0.5e0)
  t888 = t886 * t20 * t878
  t890 = t50 * t881
  t892 = t22 * t249
  t897 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t879 + 0.84396666666666666666666666666666666666666666666666e0 * t882 + 0.39862222222222222222222222222222222222222222222223e0 * t884 + 0.68258333333333333333333333333333333333333333333333e-1 * t888 + 0.13651666666666666666666666666666666666666666666667e0 * t890 + 0.13692777777777777777777777777777777777777777777778e0 * t892) * t59
  t898 = t38 ** 2
  t901 = t58 ** 2
  t902 = t31 ** 2
  t906 = 0.16081824322151104821330931780901225435013347914188e2 * t37 / t898 * t901 / t902
  t911 = t472 * t865
  t920 = t169 * t342
  t922 = t345 * t325
  t923 = t472 * t922
  t932 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t901 * t59
  t934 = t11 * t100
  t936 = 0.10843580882781524214666447553230042011687479519034e-1 * t73 * t4 * t934
  t942 = t325 ** 2
  t943 = t942 * t217
  t952 = t8 * t148
  t954 = t267 * t952 * t164
  t957 = -t855 + t859 - 0.29479012345679012345679012345679012345679012345678e-2 * t267 * t142 * t262 * t167 * t339 - 0.26531111111111111111111111111111111111111111111110e-1 * t272 * t274 * t326 * t865 + 0.26531111111111111111111111111111111111111111111110e-1 * t272 * t343 * t346 * t296 * t325 + t897 + t906 + 0.29479012345679012345679012345679012345679012345678e-2 * t267 * t331 * t270 * t166 * t334 * t209 * t911 - 0.29479012345679012345679012345679012345679012345678e-2 * t333 * t334 * t325 * t171 * t338 + 0.29479012345679012345679012345679012345679012345678e-2 * t333 * t920 * t209 * t923 - t932 + t936 + 0.14739506172839506172839506172839506172839506172838e-2 * t267 * t256 * t148 * t167 * t339 - 0.39796666666666666666666666666666666666666666666665e-1 * t302 * t343 * t943 * t345 + 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t274 * t943 * t220 - 0.35374814814814814814814814814814814814814814814814e-1 * t954 * t348
  t958 = t9 * t262
  t960 = t267 * t958 * t164
  t964 = 0.1e1 / t269 / t163
  t967 = t296 ** 2
  t968 = t275 * t967
  t972 = t10 * t155
  t976 = t54 * t15
  t983 = t352 * t136
  t990 = t240 ** 2
  t1011 = -t875 * t111 * t20 * t878 / 0.18e2 - t41 * t237 * t1 * t44 / 0.6e1 + t232 * t881 / 0.9e1 + t15 * (-0.44044444444444444444444444444444444444444444444445e-2 * t879 + 0.88088888888888888888888888888888888888888888888889e-2 * t882 + 0.55033333333333333333333333333333333333333333333333e-2 * t884) / 0.2e1
  t1016 = t244 ** 2
  t1020 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t143 * t32
  t1022 = 0.1e1 / t91 / t79
  t1023 = t97 ** 2
  t1025 = t1022 * t1023 * t99
  t1027 = 0.11696446794910408141662685001236899248561775660981e1 * t90 * t1025
  t1034 = -0.57538888888888888888888888888888888888888888888889e0 * t879 + 0.11507777777777777777777777777777777777777777777778e1 * t882 + 0.40256666666666666666666666666666666666666666666667e0 * t884 + 0.36677500000000000000000000000000000000000000000000e-1 * t888 + 0.73355000000000000000000000000000000000000000000000e-1 * t890 + 0.13797500000000000000000000000000000000000000000000e0 * t892
  t1036 = t92 * t1034 * t99
  t1038 = 0.58482233974552040708313425006184496242808878304903e0 * t90 * t1036
  t1039 = t91 ** 2
  t1040 = 0.1e1 / t1039
  t1042 = t82 ** 2
  t1043 = 0.1e1 / t1042
  t1044 = t1040 * t1023 * t1043
  t1046 = 0.17315755899375863299672358916972966258900005419821e2 * t90 * t1044
  t1047 = -t1020 - t855 - t932 + t897 + t906 + t859 + t936 + t1027 - t1038 - t1046
  t1050 = -0.43802864444444444444444444444444444444444444444443e-3 * t154 * t972 * t157 - 0.2e-52 * t285 * t976 * t157 - 0.26281718666666666666666666666666666666666666666666e-2 * t154 * t276 * t290 + 0.19711288999999999999999999999999999999999999999999e-2 * t983 * t41 * t157 + 0.19711288999999999999999999999999999999999999999999e-2 * t285 * t286 * t290 + 0.39422577999999999999999999999999999999999999999998e-2 * t154 * t156 * t230 * t990 - 0.19711288999999999999999999999999999999999999999999e-2 * t154 * t156 * t116 * t1011 - 0.4e1 * t1016 - 0.4e1 * t124 * t1047
  t1051 = t275 * t1050
  t1057 = 0.1e1 / t185 / t303 / t7
  t1058 = t183 * t1057
  t1060 = t1058 * t193 * t309
  t1062 = t177 ** 2
  t1063 = t1062 * t177
  t1064 = t303 ** 2
  t1066 = 0.1e1 / t1064 / t7
  t1067 = t1063 * t1066
  t1068 = t191 ** 2
  t1070 = 0.1e1 / t1068 / t191
  t1085 = t315 * t1057 * t193 * t308
  t1095 = (0.63e2 / 0.256e3 * t1060 - 0.49e2 / 0.8192e4 * t1067 * t1070 * jnp.pi * t313 + 0.49e2 / 0.24576e5 * t201 / t312 / t203 * t1063 * t1066 * t1070 * jnp.pi - 0.21e2 / 0.256e3 * t1085) * t321 - 0.4e1 / 0.3e1 * t320 * t107 + 0.7e1 / 0.96e2 * t1060 - 0.7e1 / 0.288e3 * t1085 + 0.4e1 / 0.3e1 * t205 * t136
  t1101 = t346 * t1095
  t1117 = t273 * t477
  t1119 = t217 * t481 * t942
  t1123 = t6 * t24
  t1128 = t2 * t252
  t1133 = t115 ** 2
  t1145 = t126 * t257
  t1150 = t130 * t5 / t23 / t184
  t1152 = 0.1e1 / t303
  t1153 = t134 * t1152
  t1158 = t140 * t6 / t8 / t303
  t1160 = -0.37560000000000000000000000000000000000000000000000e-1 * t1128 + 0.40985000000000000000000000000000000000000000000000e-2 * t1145 - 0.10566666666666666666666666666666666666666666666667e-2 * t1150 + 0.38340000000000000000000000000000000000000000000000e-3 * t1153 - 0.42010937500000000000000000000000000000000000000000e-5 * t1158
  t1162 = 0.73596627000000000000000000000000000000000000000000e-2 * t1128 * t116 + 0.14719325400000000000000000000000000000000000000000e-1 * t226 * t241 + 0.22078988100000000000000000000000000000000000000000e-1 * t108 / t1133 * t990 - 0.73596627000000000000000000000000000000000000000000e-2 * t108 * t230 * t1011 - t1047 * t146 - 0.2e1 * t244 * t260 - t124 * t1160
  t1171 = -0.26531111111111111111111111111111111111111111111110e-1 * t960 * t348 + 0.26531111111111111111111111111111111111111111111110e-1 * t267 * t268 * t964 * t274 * t968 - 0.13265555555555555555555555555555555555555555555555e-1 * t272 * t274 * t1051 + 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t274 * t1095 * t217 * t220 - 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t343 * t1101 - 0.35374814814814814814814814814814814814814814814814e-1 * t267 * t952 * t270 * t298 + 0.35374814814814814814814814814814814814814814814814e-1 * t954 * t328 - 0.26531111111111111111111111111111111111111111111110e-1 * t267 * t958 * t270 * t298 + 0.26531111111111111111111111111111111111111111111110e-1 * t960 * t328 + 0.26531111111111111111111111111111111111111111111110e-1 * t302 * t1117 * t1119 + 0.58958024691358024691358024691358024691358024691357e-2 * t105 * t1123 * t148 * t222 + 0.13265555555555555555555555555555555555555555555555e-1 * t105 * t225 * t1162 * t222 + 0.35374814814814814814814814814814814814814814814814e-1 * t105 * t106 * t262 * t222 + t1027 - t1038 - t1046 - t1020
  t1173 = (t957 + t1171) * t381
  t1176 = 0.2e1 * t351 * t390 * t487
  t1180 = t487 ** 2
  t1182 = 0.2e1 * t388 / t389 / t380 * t1180
  t1186 = t252 * t171 * t208
  t1194 = t256 * t217
  t1199 = t417 * t166
  t1209 = t449 * t165
  t1211 = t345 * t296
  t1220 = t370 * t477
  t1243 = 0.37037037037037037037037037037037037037037037037038e-1 * t433 * t920 * t152 * t1186 * t923 + 0.11111111111111111111111111111111111111111111111112e0 * t445 * t165 * t468 * t474 - 0.55555555555555555555555555555555555555555555555562e-1 * t469 * t1194 * t345 * t473 + 0.37037037037037037037037037037037037037037037037038e-1 * t1199 * t334 * t152 * t1186 * t911 - 0.37037037037037037037037037037037037037037037037038e-1 * t433 * t334 * t423 * t438 - 0.11111111111111111111111111111111111111111111111112e0 * t1209 * t468 * t470 * t1211 * t473 + 0.22222222222222222222222222222222222222222222222224e0 * t469 * t470 * t922 * t473 - 0.22222222222222222222222222222222222222222222222224e0 * t466 * t1220 * t105 * t470 * t481 * t171 * t336 * t213 * t325 + 0.33333333333333333333333333333333333333333333333334e0 * t361 * t964 * t274 * t419 * t968 + 0.50000000000000000000000000000000000000000000000002e0 * t479 * t451 * t482 * t1095 + 0.25000000000000000000000000000000000000000000000001e0 * t450 * t451 * t452 * t1050
  t1277 = t342 ** 2
  t1280 = t344 ** 2
  t1291 = t105 * t8
  t1295 = -0.50000000000000000000000000000000000000000000000002e0 * t373 * t451 * t452 * t1095 - 0.16666666666666666666666666666666666666666666666667e0 * t441 * t419 * t1101 + 0.50000000000000000000000000000000000000000000000002e0 * t262 * t270 * t372 * t454 + 0.33333333333333333333333333333333333333333333333334e0 * t414 * t425 - 0.16666666666666666666666666666666666666666666666667e0 * t418 * t419 * t1051 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t1095 * t1 * t151 * t365 - 0.33333333333333333333333333333333333333333333333334e0 * t412 * t270 * t274 * t420 - 0.10000000000000000000000000000000000000000000000000e1 * t373 * t451 * t452 * t942 + 0.25000000000000000000000000000000000000000000000001e1 * t479 * t451 * t482 * t942 - 0.15000000000000000000000000000000000000000000000001e1 * t369 * t371 * t1277 * t451 * t374 / t1280 * t942 + 0.33333333333333333333333333333333333333333333333334e0 * t362 * t1117 * t419 * t1119 + 0.13333333333333333333333333333333333333333333333334e1 * t479 * t1291 * t483
  t1303 = t152 * t12
  t1325 = t942 * t1 * t151
  t1348 = t21 * t211
  t1358 = t3 * t142
  t1378 = 0.61912500000000000000000000000000000000000000000000e-2 * t1047 * t352 * t354 - 0.24765000000000000000000000000000000000000000000000e-1 * t244 * t153 * t15 * t399 - 0.12382500000000000000000000000000000000000000000000e-1 * t392 * t403 + 0.20637500000000000000000000000000000000000000000000e-2 * t124 * t284 * t41 * t157 * t20 * t1348 + 0.24765000000000000000000000000000000000000000000000e-1 * t395 * t15 * t116 * t4 * t10 * t240 + 0.16510000000000000000000000000000000000000000000000e-1 * t396 * t397 * t1358 + 0.12382500000000000000000000000000000000000000000000e-1 * t353 * t155 * t230 * t990 - 0.61912500000000000000000000000000000000000000000000e-2 * t353 * t402 * t1011 + 0.17687407407407407407407407407407407407407407407407e-1 * t152 * t11 * t146 - 0.10612444444444444444444444444444444444444444444444e0 * t152 * t13 * t260 - 0.79593333333333333333333333333333333333333333333331e-1 * t152 * t357 * t1160
  t1383 = 0.66666666666666666666666666666666666666666666666670e0 * t450 * t1291 * t453 - 0.13333333333333333333333333333333333333333333333334e1 * t373 * t1291 * t457 - 0.22222222222222222222222222222222222222222222222222e0 * t441 * t1303 * t347 - 0.10000000000000000000000000000000000000000000000000e1 * t446 * t458 + 0.10000000000000000000000000000000000000000000000000e1 * t445 * t478 * t484 - 0.50000000000000000000000000000000000000000000000002e0 * t148 * t964 * t372 * t451 * t452 * t967 - 0.22222222222222222222222222222222222222222222222222e0 * t418 * t1303 * t297 + 0.22222222222222222222222222222222222222222222222222e0 * t363 * t424 * t429 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t1325 * t365 - 0.33333333333333333333333333333333333333333333333334e0 * t413 * t343 * t442 - 0.50000000000000000000000000000000000000000000000001e0 * t441 * t1325 * t364 * t345 + 0.16666666666666666666666666666666666666666666666667e0 * t1378 * t164 * t274 * t366
  t1384 = t24 * t374
  t1391 = t10 * t217
  t1402 = t467 * t20
  t1405 = t104 * t9 * t374
  t1406 = t1211 * t325
  t1420 = t151 * t23 * t217
  t1429 = t151 * t1152 * t171
  t1441 = t104 / t303 / t135 * t172
  t1444 = 0.1e1 / t173 / t133 * t1062
  t1450 = -0.11111111111111111111111111111111111111111111111112e0 * t373 * t105 * t1384 * t345 - 0.66666666666666666666666666666666666666666666666670e0 * t446 * t463 - 0.37037037037037037037037037037037037037037037037037e-1 * t363 * t152 * t1391 * t220 + 0.22222222222222222222222222222222222222222222222222e0 * t414 * t430 - 0.25000000000000000000000000000000000000000000000001e0 * t1162 * t164 * t372 * t377 + 0.10000000000000000000000000000000000000000000000000e1 * t1209 * t1402 * t1405 * t1406 - 0.10000000000000000000000000000000000000000000000000e1 * t1209 * t1220 * t20 * t1405 * t481 * t296 * t325 + 0.33333333333333333333333333333333333333333333333334e0 * t1199 * t920 * t1 * t1420 * t1406 - 0.33333333333333333333333333333333333333333333333334e0 * t1199 * t334 * t325 * t420 + 0.43209876543209876543209876543209876543209876543211e-1 * t435 * t1429 * t338 - 0.37037037037037037037037037037037037037037037037038e-1 * t413 * t166 * t434 * t438 - 0.12345679012345679012345679012345679012345679012346e-1 * t466 * t1402 * t1441 * t1444 * t69 * t345
  t1453 = t391 * (t1243 + t1295 + t1383 + t1450)
  t1454 = t494 ** 2
  t1455 = 0.1e1 / t1454
  t1456 = t496 ** 2
  t1459 = t490 * t252
  t1461 = -0.2e1 * t136 + 0.2e1 * t1459
  t1465 = f.my_piecewise3(t493, 0, 0.4e1 / 0.9e1 * t1455 * t1456 + 0.4e1 / 0.3e1 * t494 * t1461)
  t1466 = t502 ** 2
  t1467 = 0.1e1 / t1466
  t1468 = t503 ** 2
  t1475 = f.my_piecewise3(t501, 0, 0.4e1 / 0.9e1 * t1467 * t1468 - 0.4e1 / 0.3e1 * t502 * t1461)
  t1479 = t508 * t848
  t1482 = 0.24415406715670879921742973310852762593515528885057e-3 * t652 * t857
  t1495 = t540 ** 2
  t1497 = t675 ** 2
  t1517 = -t875 * t536 * t20 * t878 / 0.18e2 - t41 * t672 * t1 * t44 / 0.6e1 + t667 * t881 / 0.9e1 + t15 * (-0.99474444444444444444444444444444444444444444444447e-4 * t879 + 0.19894888888888888888888888888888888888888888888889e-3 * t882 + 0.52442777777777777777777777777777777777777777777777e-2 * t884) / 0.2e1
  t1531 = t638 ** 2
  t1545 = t631 ** 2
  t1548 = t525 ** 2
  t1571 = -0.70981924444444444444444444444444444444444444444442e-3 * t4 * t143 * t526 - 0.34246666666666666666666666666666666666666666666666e-1 * t851 * t10 * t632 * t640 - 0.20000000000000000000000000000000000000000000000000e1 * t517 / t631 / t522 * t1531 * t639 + 0.99999999999999999999999999999999999999999999999999e0 * t633 * (-0.78438333333333333333333333333333333333333333333333e0 * t879 + 0.15687666666666666666666666666666666666666666666667e1 * t882 + 0.68863333333333333333333333333333333333333333333333e0 * t884 + 0.14025833333333333333333333333333333333333333333333e0 * t888 + 0.28051666666666666666666666666666666666666666666667e0 * t890 + 0.17365833333333333333333333333333333333333333333333e0 * t892) * t639 + 0.32164683177870697973624959794146027661627532968800e2 * t517 / t1545 * t1531 / t1548 + t1020 + t855 + t932 - t897 - t906 - 0.24415406715670879921742973310852762593515528885057e-3 * t4 * t143 * t83 - 0.10843580882781524214666447553230042011687479519034e-1 * t851 * t10 * t92 * t647 - 0.11696446794910408141662685001236899248561775660981e1 * t89 * t1022 * t1023 * t99 + 0.58482233974552040708313425006184496242808878304903e0 * t646 * t1034 * t99 + 0.17315755899375863299672358916972966258900005419821e2 * t89 * t1040 * t1023 * t1043
  t1572 = t515 * t1571
  t1575 = 0.10843580882781524214666447553230042011687479519034e-1 * t515 * t4 * t934
  t1577 = 0.11696446794910408141662685001236899248561775660981e1 * t655 * t1025
  t1579 = 0.58482233974552040708313425006184496242808878304903e0 * t655 * t1036
  t1581 = 0.17315755899375863299672358916972966258900005419821e2 * t655 * t1044
  t1582 = -t1020 - t855 - t932 + t897 + t906 + t1572 + t1482 + t1575 + t1577 - t1579 - t1581
  t1591 = -0.48613650000000000000000000000000000000000000000000e-1 * t1128 + 0.58332050000000000000000000000000000000000000000000e-2 * t1145 - 0.16123583333333333333333333333333333333333333333333e-2 * t1150 + 0.60452325000000000000000000000000000000000000000000e-3 * t1153 - 0.67352906250000000000000000000000000000000000000000e-5 * t1158
  t1593 = 0.66830952067500000000000000000000000000000000000000e-2 * t1128 * t541 + 0.13366190413500000000000000000000000000000000000000e-1 * t226 * t676 + 0.20049285620250000000000000000000000000000000000000e-1 * t108 / t1495 * t1497 - 0.66830952067500000000000000000000000000000000000000e-2 * t108 * t665 * t1517 - t1582 * t550 - 0.2e1 * t679 * t686 - t544 * t1591
  t1598 = t584 * t711
  t1618 = t9 * t688
  t1620 = t267 * t1618 * t562
  t1623 = t1482 - t855 + 0.15934567901234567901234567901234567901234567901235e-2 * t105 * t1123 * t552 * t586 + 0.95607407407407407407407407407407407407407407407410e-2 * t105 * t106 * t688 * t586 + 0.35852777777777777777777777777777777777777777777779e-2 * t105 * t225 * t1593 * t586 + t897 + t906 - t932 - t1581 - 0.71705555555555555555555555555555555555555555555558e-2 * t697 * t599 * t735 * t1598 + 0.71705555555555555555555555555555555555555555555558e-2 * t697 * t750 * t751 * t711 * t734 + t1575 + t1572 + 0.39836419753086419753086419753086419753086419753089e-3 * t267 * t256 * t552 * t563 * t747 - 0.79672839506172839506172839506172839506172839506176e-3 * t267 * t142 * t688 * t563 * t747 - t1020 + 0.71705555555555555555555555555555555555555555555558e-2 * t1620 * t737
  t1624 = t273 * t836
  t1626 = t734 ** 2
  t1627 = t217 * t840 * t1626
  t1631 = t1626 * t217
  t1641 = 0.1e1 / t694 / t561
  t1644 = t711 ** 2
  t1645 = t698 * t1644
  t1649 = t8 * t552
  t1651 = t267 * t1649 * t562
  t1679 = t679 ** 2
  t1683 = -0.11281315546296296296296296296296296296296296296296e-3 * t154 * t972 * t555 + 0.1e-52 * t285 * t976 * t555 - 0.67687893277777777777777777777777777777777777777778e-3 * t154 * t276 * t705 + 0.50765919958333333333333333333333333333333333333334e-3 * t983 * t41 * t555 + 0.50765919958333333333333333333333333333333333333334e-3 * t285 * t286 * t705 + 0.10153183991666666666666666666666666666666666666667e-2 * t154 * t156 * t665 * t1497 - 0.50765919958333333333333333333333333333333333333334e-3 * t154 * t156 * t541 * t1517 - 0.4e1 * t1679 - 0.4e1 * t544 * t1582
  t1684 = t698 * t1683
  t1689 = t1058 * t571 * t719
  t1691 = t569 ** 2
  t1693 = 0.1e1 / t1691 / t569
  t1708 = t725 * t1057 * t571 * t308
  t1718 = (0.63e2 / 0.256e3 * t1689 - 0.49e2 / 0.8192e4 * t1067 * t1693 * jnp.pi * t723 + 0.49e2 / 0.24576e5 * t576 / t722 / t578 * t1063 * t1066 * t1693 * jnp.pi - 0.21e2 / 0.256e3 * t1708) * t321 - 0.4e1 / 0.3e1 * t730 * t107 + 0.7e1 / 0.96e2 * t1689 - 0.7e1 / 0.288e3 * t1708 + 0.4e1 / 0.3e1 * t580 * t136
  t1724 = t751 * t1718
  t1742 = t472 * t1598
  t1746 = t169 * t606
  t1748 = t610 * t734
  t1749 = t472 * t1748
  t1758 = 0.71705555555555555555555555555555555555555555555558e-2 * t717 * t1624 * t1627 - 0.10755833333333333333333333333333333333333333333334e-1 * t717 * t750 * t1631 * t610 + 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t599 * t1631 * t584 + 0.71705555555555555555555555555555555555555555555558e-2 * t267 * t693 * t1641 * t599 * t1645 - 0.95607407407407407407407407407407407407407407407410e-2 * t1651 * t753 - 0.71705555555555555555555555555555555555555555555558e-2 * t1620 * t753 - 0.35852777777777777777777777777777777777777777777779e-2 * t697 * t599 * t1684 + 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t599 * t1718 * t217 * t584 - 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t750 * t1724 - 0.95607407407407407407407407407407407407407407407410e-2 * t267 * t1649 * t695 * t713 + 0.95607407407407407407407407407407407407407407407410e-2 * t1651 * t737 - 0.71705555555555555555555555555555555555555555555558e-2 * t267 * t1618 * t695 * t713 + t1577 - t1579 + 0.79672839506172839506172839506172839506172839506176e-3 * t267 * t740 * t695 * t166 * t743 * t209 * t1742 + 0.79672839506172839506172839506172839506172839506176e-3 * t742 * t1746 * t209 * t1749 - 0.79672839506172839506172839506172839506172839506176e-3 * t742 * t743 * t734 * t171 * t746
  t1767 = t846 ** 2
  t1822 = 0.58998125000000000000000000000000000000000000000000e-2 * t1582 * t352 * t591 - 0.23599250000000000000000000000000000000000000000000e-1 * t679 * t153 * t15 * t767 - 0.11799625000000000000000000000000000000000000000000e-1 * t761 * t771 + 0.19666041666666666666666666666666666666666666666667e-2 * t544 * t284 * t41 * t555 * t20 * t1348 + 0.23599250000000000000000000000000000000000000000000e-1 * t764 * t15 * t541 * t4 * t10 * t675 + 0.15732833333333333333333333333333333333333333333333e-1 * t765 * t766 * t1358 + 0.11799625000000000000000000000000000000000000000000e-1 * t590 * t155 * t665 * t1497 - 0.58998125000000000000000000000000000000000000000000e-2 * t590 * t770 * t1517 + 0.47803703703703703703703703703703703703703703703703e-2 * t152 * t11 * t550 - 0.28682222222222222222222222222222222222222222222222e-1 * t152 * t13 * t686 - 0.21511666666666666666666666666666666666666666666667e-1 * t152 * t357 * t1591
  t1839 = t606 ** 2
  t1842 = t609 ** 2
  t1857 = 0.22222222222222222222222222222222222222222222222222e0 * t782 * t796 - 0.11111111111111111111111111111111111111111111111112e0 * t608 * t105 * t1384 * t610 - 0.66666666666666666666666666666666666666666666666670e0 * t810 * t825 - 0.25000000000000000000000000000000000000000000000001e0 * t1593 * t562 * t607 * t612 + 0.16666666666666666666666666666666666666666666666667e0 * t1822 * t562 * t599 * t602 - 0.37037037037037037037037037037037037037037037037037e-1 * t600 * t152 * t1391 * t584 + 0.25000000000000000000000000000000000000000000000001e0 * t814 * t451 * t815 * t1683 - 0.50000000000000000000000000000000000000000000000002e0 * t608 * t451 * t815 * t1718 - 0.15000000000000000000000000000000000000000000000001e1 * t605 * t371 * t1839 * t451 * t374 / t1842 * t1626 - 0.10000000000000000000000000000000000000000000000000e1 * t608 * t451 * t815 * t1626 + 0.25000000000000000000000000000000000000000000000001e1 * t838 * t451 * t841 * t1626
  t1863 = t1626 * t1 * t151
  t1905 = 0.33333333333333333333333333333333333333333333333334e0 * t598 * t1624 * t419 * t1627 - 0.50000000000000000000000000000000000000000000000001e0 * t805 * t1863 * t364 * t610 - 0.13333333333333333333333333333333333333333333333334e1 * t608 * t1291 * t820 + 0.33333333333333333333333333333333333333333333333334e0 * t782 * t792 + 0.50000000000000000000000000000000000000000000000002e0 * t838 * t451 * t841 * t1718 + 0.50000000000000000000000000000000000000000000000002e0 * t688 * t695 * t607 * t817 + 0.16666666666666666666666666666666666666666666666667e0 * t600 * t1718 * t1 * t151 * t601 - 0.16666666666666666666666666666666666666666666666667e0 * t786 * t419 * t1684 - 0.33333333333333333333333333333333333333333333333334e0 * t780 * t695 * t599 * t787 - 0.50000000000000000000000000000000000000000000000002e0 * t552 * t1641 * t607 * t451 * t815 * t1644 + 0.66666666666666666666666666666666666666666666666670e0 * t814 * t1291 * t816 + 0.22222222222222222222222222222222222222222222222222e0 * t600 * t791 * t795
  t1935 = t829 * t20
  t1949 = 0.16666666666666666666666666666666666666666666666667e0 * t600 * t1863 * t601 - 0.22222222222222222222222222222222222222222222222222e0 * t805 * t1303 * t752 - 0.33333333333333333333333333333333333333333333333334e0 * t781 * t750 * t806 + 0.33333333333333333333333333333333333333333333333334e0 * t597 * t1641 * t599 * t419 * t1645 - 0.22222222222222222222222222222222222222222222222222e0 * t786 * t1303 * t712 - 0.16666666666666666666666666666666666666666666666667e0 * t805 * t419 * t1724 + 0.13333333333333333333333333333333333333333333333334e1 * t838 * t1291 * t842 - 0.10000000000000000000000000000000000000000000000000e1 * t810 * t821 + 0.10000000000000000000000000000000000000000000000000e1 * t809 * t837 * t843 - 0.12345679012345679012345679012345679012345679012346e-1 * t828 * t1935 * t1441 * t1444 * t69 * t610 + 0.43209876543209876543209876543209876543209876543211e-1 * t801 * t1429 * t746 - 0.37037037037037037037037037037037037037037037037038e-1 * t781 * t166 * t800 * t802
  t1954 = t785 * t166
  t1964 = t813 * t165
  t1966 = t610 * t711
  t1967 = t1966 * t734
  t1971 = t370 * t836
  t2015 = -0.55555555555555555555555555555555555555555555555562e-1 * t831 * t1194 * t610 * t473 + 0.37037037037037037037037037037037037037037037037038e-1 * t1954 * t743 * t152 * t1186 * t1742 - 0.37037037037037037037037037037037037037037037037038e-1 * t799 * t743 * t790 * t802 + 0.10000000000000000000000000000000000000000000000000e1 * t1964 * t1935 * t1405 * t1967 - 0.10000000000000000000000000000000000000000000000000e1 * t1964 * t1971 * t20 * t1405 * t840 * t711 * t734 + 0.33333333333333333333333333333333333333333333333334e0 * t1954 * t1746 * t1 * t1420 * t1967 - 0.33333333333333333333333333333333333333333333333334e0 * t1954 * t743 * t734 * t787 + 0.37037037037037037037037037037037037037037037037038e-1 * t799 * t1746 * t152 * t1186 * t1749 + 0.11111111111111111111111111111111111111111111111112e0 * t809 * t165 * t830 * t833 - 0.22222222222222222222222222222222222222222222222224e0 * t828 * t1971 * t105 * t470 * t840 * t171 * t336 * t213 * t734 - 0.11111111111111111111111111111111111111111111111112e0 * t1964 * t830 * t470 * t1966 * t473 + 0.22222222222222222222222222222222222222222222222224e0 * t831 * t470 * t1748 * t473
  t2020 = t627 * ((t1623 + t1758) * t616 - 0.2e1 * t756 * t759 * t846 + 0.2e1 * t589 / t758 / t615 * t1767 - t760 * (t1857 + t1905 + t1949 + t2015) - t1173 + t1176 - t1182 + t1453)
  d11 = t383 - t489 + 0.2e1 * t620 + t850 + t7 * (t1173 - t1176 + t1182 - t1453 + (t1465 + t1475) * t72 * t619 + 0.2e1 * t1479 + t2020)
  t2023 = -t107 - t495
  t2026 = f.my_piecewise3(t493, 0, 0.4e1 / 0.3e1 * t494 * t2023)
  t2027 = -t2023
  t2030 = f.my_piecewise3(t501, 0, 0.4e1 / 0.3e1 * t502 * t2027)
  t2032 = (t2026 + t2030) * t72
  t2033 = t2032 * t619
  t2041 = f.my_piecewise3(t493, 0, 0.4e1 / 0.9e1 * t1455 * t2023 * t496 + 0.8e1 / 0.3e1 * t494 * t490 * t252)
  t2049 = f.my_piecewise3(t501, 0, 0.4e1 / 0.9e1 * t1467 * t2027 * t503 - 0.8e1 / 0.3e1 * t502 * t490 * t252)
  t2053 = t2032 * t848
  d12 = t383 - t489 + t620 + t850 + t2033 + t7 * (t1173 - t1176 + t1182 - t1453 + (t2041 + t2049) * t72 * t619 + t2053 + t1479 + t2020)
  t2057 = t2023 ** 2
  t2061 = 0.2e1 * t136 + 0.2e1 * t1459
  t2065 = f.my_piecewise3(t493, 0, 0.4e1 / 0.9e1 * t1455 * t2057 + 0.4e1 / 0.3e1 * t494 * t2061)
  t2066 = t2027 ** 2
  t2073 = f.my_piecewise3(t501, 0, 0.4e1 / 0.9e1 * t1467 * t2066 - 0.4e1 / 0.3e1 * t502 * t2061)
  d22 = t383 - t489 + 0.2e1 * t2033 + t850 + t7 * (t1173 - t1176 + t1182 - t1453 + (t2065 + t2073) * t72 * t619 + 0.2e1 * t2053 + t2020)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t8 * t7
  t10 = 0.1e1 / t9
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t24 = 0.1e1 / t23
  t26 = t22 * t5 * t24
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t28
  t32 = jnp.log(t31)
  t35 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t11 * t32
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t41 = 0.1e1 / t15
  t42 = t41 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t54 = 0.1e1 / t23 / t7
  t55 = t5 * t54
  t56 = t22 * t55
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t62 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * t60
  t63 = 0.1e1 <= f.p.zeta_threshold
  t64 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = t64 * f.p.zeta_threshold
  t66 = f.my_piecewise3(t63, t65, 1)
  t69 = 2 ** (0.1e1 / 0.3e1)
  t72 = 0.1e1 / (0.2e1 * t69 - 0.2e1)
  t73 = (0.2e1 * t66 - 0.2e1) * t72
  t74 = t73 * t1
  t79 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t82 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t79
  t83 = jnp.log(t82)
  t85 = t43 * t10 * t83
  t87 = 0.18311555036753159941307229983139571945136646663793e-3 * t74 * t85
  t89 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t90 = t73 * t89
  t91 = t79 ** 2
  t92 = 0.1e1 / t91
  t97 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t99 = 0.1e1 / t82
  t100 = t92 * t97 * t99
  t102 = 0.58482233974552040708313425006184496242808878304903e0 * t90 * t100
  t103 = t3 * t2
  t104 = 0.1e1 / t103
  t105 = t20 * t104
  t106 = t6 * t8
  t107 = 0.1e1 / t7
  t108 = t2 * t107
  t111 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t15 + 0.12382500000000000000000000000000000000000000000000e-1 * t14
  t114 = 0.1e1 + t15 * t111 / 0.2e1
  t115 = t114 ** 2
  t116 = 0.1e1 / t115
  t120 = 0.62182e-1 * t37 * t32
  t121 = t89 * t83
  t123 = 0.19751789702565206228825776161588751761046270558698e-1 * t73 * t121
  t124 = -t120 + t123
  t126 = t1 * t103
  t127 = t126 * t11
  t130 = t20 * t21 * t2
  t131 = t130 * t55
  t133 = jnp.pi ** 2
  t134 = 0.1e1 / t133
  t135 = t7 ** 2
  t136 = 0.1e1 / t135
  t137 = t134 * t136
  t140 = t1 * t3 * t134
  t142 = 0.1e1 / t8 / t135
  t143 = t6 * t142
  t144 = t140 * t143
  t146 = -0.18780000000000000000000000000000000000000000000000e-1 * t108 + 0.13173750000000000000000000000000000000000000000000e-2 * t127 - 0.23775000000000000000000000000000000000000000000000e-3 * t131 + 0.63900000000000000000000000000000000000000000000000e-4 * t137 - 0.54014062500000000000000000000000000000000000000000e-6 * t144
  t148 = 0.36798313500000000000000000000000000000000000000000e-2 * t108 * t116 - t124 * t146
  t151 = 0.1e1 / t21
  t152 = t1 * t151
  t153 = 4 ** (0.1e1 / 0.6e1)
  t154 = t152 * t153
  t155 = t15 * t14
  t156 = t23 * t155
  t157 = 0.1e1 / t114
  t161 = t124 ** 2
  t163 = 0.19711288999999999999999999999999999999999999999999e-2 * t154 * t156 * t157 - 0.2e1 * t161
  t164 = 0.1e1 / t163
  t165 = 9 ** (0.1e1 / 0.3e1)
  t166 = t165 ** 2
  t167 = t164 * t166
  t168 = jnp.pi ** (0.1e1 / 0.3e1)
  t169 = t168 ** 2
  t171 = 6 ** (0.1e1 / 0.3e1)
  t172 = t171 ** 2
  t173 = t133 ** (0.1e1 / 0.3e1)
  t177 = s0 + 0.2e1 * s1 + s2
  t178 = jnp.sqrt(t177)
  t182 = t172 / t173 * t178 * t10 * t69 / 0.12e2
  t183 = t178 * t177
  t184 = t135 * t7
  t185 = jnp.sqrt(t7)
  t188 = t183 / t185 / t184
  t189 = t64 ** 2
  t190 = f.my_piecewise3(t63, t189, 1)
  t191 = t190 ** 2
  t193 = 0.1e1 / t191 / t190
  t194 = jnp.sqrt(0.3e1)
  t196 = jnp.sqrt(t2)
  t197 = 0.1e1 / t196
  t199 = t188 * t193 * t194 * t197
  t201 = 0.854613e1 + t199 / 0.64e2
  t203 = 0.1e1 + t199 / 0.192e3
  t204 = 0.1e1 / t203
  t205 = t201 * t204
  t206 = t182 ** t205
  t207 = t173 ** 2
  t208 = 0.1e1 / t207
  t209 = t171 * t208
  t211 = 0.1e1 / t23 / t135
  t213 = t69 ** 2
  t217 = 0.14709046e2 + t209 * t177 * t211 * t213 / 0.24e2
  t219 = 0.1e1 + t206
  t220 = 0.1e1 / t219
  t222 = t167 * t169 * t206 * t217 * t220
  t225 = t6 * t9
  t226 = t2 * t136
  t230 = 0.1e1 / t115 / t114
  t232 = t41 * t111 * t1
  t237 = -0.66066666666666666666666666666666666666666666666667e-2 * t45 - 0.41275000000000000000000000000000000000000000000000e-2 * t47
  t240 = -t232 * t44 / 0.12e2 + t15 * t237 / 0.2e1
  t241 = t230 * t240
  t244 = t35 + t62 - t87 - t102
  t247 = t126 * t143
  t249 = t5 * t211
  t250 = t130 * t249
  t252 = 0.1e1 / t184
  t253 = t134 * t252
  t256 = 0.1e1 / t8 / t184
  t257 = t6 * t256
  t258 = t140 * t257
  t260 = 0.18780000000000000000000000000000000000000000000000e-1 * t226 - 0.17565000000000000000000000000000000000000000000000e-2 * t247 + 0.39625000000000000000000000000000000000000000000000e-3 * t250 - 0.12780000000000000000000000000000000000000000000000e-3 * t253 + 0.12603281250000000000000000000000000000000000000000e-5 * t258
  t262 = -0.36798313500000000000000000000000000000000000000000e-2 * t226 * t116 - 0.73596627000000000000000000000000000000000000000000e-2 * t108 * t241 - t244 * t146 - t124 * t260
  t267 = t105 * t6
  t268 = t9 * t148
  t269 = t163 ** 2
  t270 = 0.1e1 / t269
  t272 = t267 * t268 * t270
  t273 = t166 * t169
  t274 = t273 * t206
  t275 = t217 * t220
  t276 = t12 * t155
  t282 = t153 ** 2
  t283 = t282 ** 2
  t284 = t283 * t153
  t285 = t20 / t3 * t284
  t286 = t24 * t15
  t290 = t116 * t240
  t296 = 0.13140859333333333333333333333333333333333333333333e-2 * t154 * t276 * t157 - 0.98556444999999999999999999999999999999999999999995e-3 * t285 * t286 * t157 - 0.19711288999999999999999999999999999999999999999999e-2 * t154 * t156 * t290 - 0.4e1 * t124 * t244
  t297 = t275 * t296
  t298 = t274 * t297
  t302 = t267 * t268 * t164
  t303 = t135 ** 2
  t305 = 0.1e1 / t185 / t303
  t306 = t183 * t305
  t308 = t194 * t197
  t309 = t308 * t204
  t312 = t203 ** 2
  t313 = 0.1e1 / t312
  t315 = t201 * t313 * t183
  t320 = -0.7e1 / 0.128e3 * t306 * t193 * t309 + 0.7e1 / 0.384e3 * t315 * t305 * t193 * t308
  t321 = jnp.log(t182)
  t325 = t320 * t321 - 0.4e1 / 0.3e1 * t205 * t107
  t326 = t325 * t217
  t328 = t274 * t326 * t220
  t331 = t142 * t148
  t333 = t267 * t331 * t167
  t334 = t169 * t206
  t336 = t208 * t177
  t338 = t336 * t213 * t220
  t339 = t334 * t171 * t338
  t342 = t206 ** 2
  t343 = t273 * t342
  t344 = t219 ** 2
  t345 = 0.1e1 / t344
  t346 = t217 * t345
  t347 = t346 * t325
  t348 = t343 * t347
  t351 = t35 + t62 - t87 - t102 + 0.17687407407407407407407407407407407407407407407407e-1 * t105 * t106 * t148 * t222 + 0.13265555555555555555555555555555555555555555555555e-1 * t105 * t225 * t262 * t222 - 0.13265555555555555555555555555555555555555555555555e-1 * t272 * t298 + 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t328 - 0.14739506172839506172839506172839506172839506172839e-2 * t333 * t339 - 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t348
  t352 = jnp.sqrt(0.4e1)
  t353 = t124 * t352
  t354 = t155 * t157
  t357 = t6 * t23
  t361 = 0.61912500000000000000000000000000000000000000000000e-2 * t353 * t354 - 0.79593333333333333333333333333333333333333333333331e-1 * t152 * t357 * t146
  t362 = t361 * t164
  t363 = t362 * t274
  t364 = t23 * t217
  t365 = t364 * t220
  t366 = t152 * t365
  t369 = t148 * t164
  t370 = t168 * jnp.pi
  t371 = t165 * t370
  t372 = t371 * t342
  t373 = t369 * t372
  t374 = t217 ** 2
  t375 = t9 * t374
  t377 = t105 * t375 * t345
  t380 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t366 - 0.25000000000000000000000000000000000000000000000001e0 * t373 * t377
  t381 = 0.1e1 / t380
  t382 = t351 * t381
  t383 = 0.2e1 * t382
  t388 = -t120 + t123 + 0.13265555555555555555555555555555555555555555555555e-1 * t105 * t225 * t148 * t222
  t389 = t380 ** 2
  t390 = 0.1e1 / t389
  t391 = t388 * t390
  t392 = t244 * t352
  t395 = t124 * t153
  t396 = t395 * t15
  t397 = t157 * t1
  t398 = t3 * t10
  t399 = t397 * t398
  t402 = t155 * t116
  t403 = t402 * t240
  t412 = 0.61912500000000000000000000000000000000000000000000e-2 * t392 * t354 - 0.12382500000000000000000000000000000000000000000000e-1 * t396 * t399 - 0.61912500000000000000000000000000000000000000000000e-2 * t353 * t403 - 0.53062222222222222222222222222222222222222222222221e-1 * t152 * t13 * t146 - 0.79593333333333333333333333333333333333333333333331e-1 * t152 * t357 * t260
  t413 = t412 * t164
  t414 = t413 * t274
  t417 = t361 * t270
  t418 = t417 * t274
  t419 = t152 * t23
  t420 = t419 * t297
  t423 = t325 * t1
  t424 = t423 * t151
  t425 = t424 * t365
  t428 = t12 * t217
  t429 = t428 * t220
  t430 = t152 * t429
  t433 = t362 * t166
  t434 = t334 * t1
  t435 = t433 * t434
  t437 = t151 * t252 * t171
  t438 = t437 * t338
  t441 = t362 * t343
  t442 = t419 * t347
  t445 = t262 * t164
  t446 = t445 * t372
  t449 = t148 * t270
  t450 = t449 * t372
  t451 = t105 * t9
  t452 = t374 * t345
  t453 = t452 * t296
  t454 = t451 * t453
  t457 = t452 * t325
  t458 = t451 * t457
  t461 = t8 * t374
  t463 = t105 * t461 * t345
  t466 = t369 * t165
  t467 = t370 * t342
  t468 = t467 * t105
  t469 = t466 * t468
  t470 = t142 * t217
  t472 = t177 * t213
  t473 = t209 * t472
  t474 = t470 * t345 * t473
  t477 = t342 * t206
  t478 = t371 * t477
  t479 = t369 * t478
  t481 = 0.1e1 / t344 / t219
  t482 = t374 * t481
  t483 = t482 * t325
  t484 = t451 * t483
  t487 = 0.16666666666666666666666666666666666666666666666667e0 * t414 * t366 - 0.16666666666666666666666666666666666666666666666667e0 * t418 * t420 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t425 + 0.11111111111111111111111111111111111111111111111111e0 * t363 * t430 - 0.18518518518518518518518518518518518518518518518519e-1 * t435 * t438 - 0.16666666666666666666666666666666666666666666666667e0 * t441 * t442 - 0.25000000000000000000000000000000000000000000000001e0 * t446 * t377 + 0.25000000000000000000000000000000000000000000000001e0 * t450 * t454 - 0.50000000000000000000000000000000000000000000000002e0 * t373 * t458 - 0.33333333333333333333333333333333333333333333333335e0 * t373 * t463 + 0.55555555555555555555555555555555555555555555555558e-1 * t469 * t474 + 0.50000000000000000000000000000000000000000000000002e0 * t479 * t484
  t488 = t391 * t487
  t489 = 0.2e1 * t488
  t490 = r0 - r1
  t491 = t490 * t107
  t492 = 0.1e1 + t491
  t493 = t492 <= f.p.zeta_threshold
  t494 = t492 ** (0.1e1 / 0.3e1)
  t495 = t490 * t136
  t496 = t107 - t495
  t499 = f.my_piecewise3(t493, 0, 0.4e1 / 0.3e1 * t494 * t496)
  t500 = 0.1e1 - t491
  t501 = t500 <= f.p.zeta_threshold
  t502 = t500 ** (0.1e1 / 0.3e1)
  t503 = -t496
  t506 = f.my_piecewise3(t501, 0, 0.4e1 / 0.3e1 * t502 * t503)
  t508 = (t499 + t506) * t72
  t509 = 0.2e1 <= f.p.zeta_threshold
  t511 = f.my_piecewise3(t509, t65, 0.2e1 * t69)
  t512 = 0.0e0 <= f.p.zeta_threshold
  t513 = f.my_piecewise3(t512, t65, 0)
  t515 = (t511 + t513 - 0.2e1) * t72
  t517 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t522 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t525 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t522
  t526 = jnp.log(t525)
  t531 = t515 * (-0.31090e-1 * t517 * t526 + t120 - 0.19751789702565206228825776161588751761046270558698e-1 * t121)
  t533 = 0.19751789702565206228825776161588751761046270558698e-1 * t515 * t121
  t536 = 0.149676e1 + 0.89527000000000000000000000000000000000000000000000e-3 * t15 + 0.11799625000000000000000000000000000000000000000000e-1 * t14
  t539 = 0.1e1 + t15 * t536 / 0.2e1
  t540 = t539 ** 2
  t541 = 0.1e1 / t540
  t544 = -t120 + t531 + t533
  t550 = -0.24306825000000000000000000000000000000000000000000e-1 * t108 + 0.18749587500000000000000000000000000000000000000000e-2 * t127 - 0.36278062500000000000000000000000000000000000000000e-3 * t131 + 0.10075387500000000000000000000000000000000000000000e-3 * t137 - 0.86596593750000000000000000000000000000000000000000e-6 * t144
  t552 = 0.33415476033750000000000000000000000000000000000000e-2 * t108 * t541 - t544 * t550
  t555 = 0.1e1 / t539
  t559 = t544 ** 2
  t561 = 0.50765919958333333333333333333333333333333333333334e-3 * t154 * t156 * t555 - 0.2e1 * t559
  t562 = 0.1e1 / t561
  t563 = t562 * t166
  t565 = f.my_piecewise3(t509, t189, t213)
  t566 = f.my_piecewise3(t512, t189, 0)
  t568 = t565 / 0.2e1 + t566 / 0.2e1
  t569 = t568 ** 2
  t571 = 0.1e1 / t569 / t568
  t574 = t188 * t571 * t194 * t197
  t576 = 0.854613e1 + t574 / 0.64e2
  t578 = 0.1e1 + t574 / 0.192e3
  t579 = 0.1e1 / t578
  t580 = t576 * t579
  t581 = t182 ** t580
  t583 = 0.1e1 + t581
  t584 = 0.1e1 / t583
  t586 = t563 * t169 * t581 * t217 * t584
  t589 = -t120 + t531 + t533 + 0.35852777777777777777777777777777777777777777777779e-2 * t105 * t225 * t552 * t586
  t590 = t544 * t352
  t591 = t155 * t555
  t597 = 0.58998125000000000000000000000000000000000000000000e-2 * t590 * t591 - 0.21511666666666666666666666666666666666666666666667e-1 * t152 * t357 * t550
  t598 = t597 * t562
  t599 = t273 * t581
  t600 = t598 * t599
  t601 = t364 * t584
  t602 = t152 * t601
  t605 = t552 * t562
  t606 = t581 ** 2
  t607 = t371 * t606
  t608 = t605 * t607
  t609 = t583 ** 2
  t610 = 0.1e1 / t609
  t612 = t105 * t375 * t610
  t615 = 0.1e1 + 0.16666666666666666666666666666666666666666666666667e0 * t600 * t602 - 0.25000000000000000000000000000000000000000000000001e0 * t608 * t612
  t616 = 0.1e1 / t615
  t619 = -t388 * t381 + t589 * t616
  t620 = t508 * t619
  t623 = f.my_piecewise3(t493, t65, t494 * t492)
  t625 = f.my_piecewise3(t501, t65, t502 * t500)
  t627 = (t623 + t625 - 0.2e1) * t72
  t631 = t522 ** 2
  t632 = 0.1e1 / t631
  t633 = t517 * t632
  t638 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t639 = 0.1e1 / t525
  t640 = t638 * t639
  t646 = t89 * t92
  t647 = t97 * t99
  t651 = t515 * (0.53236443333333333333333333333333333333333333333332e-3 * t4 * t11 * t526 + 0.99999999999999999999999999999999999999999999999999e0 * t633 * t640 - t35 - t62 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t11 * t83 + 0.58482233974552040708313425006184496242808878304903e0 * t646 * t647)
  t652 = t515 * t1
  t654 = 0.18311555036753159941307229983139571945136646663793e-3 * t652 * t85
  t655 = t515 * t89
  t657 = 0.58482233974552040708313425006184496242808878304903e0 * t655 * t100
  t665 = 0.1e1 / t540 / t539
  t667 = t41 * t536 * t1
  t672 = -0.14921166666666666666666666666666666666666666666667e-3 * t45 - 0.39332083333333333333333333333333333333333333333333e-2 * t47
  t675 = -t667 * t44 / 0.12e2 + t15 * t672 / 0.2e1
  t676 = t665 * t675
  t679 = t35 + t62 + t651 - t654 - t657
  t686 = 0.24306825000000000000000000000000000000000000000000e-1 * t226 - 0.24999450000000000000000000000000000000000000000000e-2 * t247 + 0.60463437500000000000000000000000000000000000000000e-3 * t250 - 0.20150775000000000000000000000000000000000000000000e-3 * t253 + 0.20205871875000000000000000000000000000000000000000e-5 * t258
  t688 = -0.33415476033750000000000000000000000000000000000000e-2 * t226 * t541 - 0.66830952067500000000000000000000000000000000000000e-2 * t108 * t676 - t679 * t550 - t544 * t686
  t693 = t9 * t552
  t694 = t561 ** 2
  t695 = 0.1e1 / t694
  t697 = t267 * t693 * t695
  t698 = t217 * t584
  t705 = t541 * t675
  t711 = 0.33843946638888888888888888888888888888888888888889e-3 * t154 * t276 * t555 - 0.25382959979166666666666666666666666666666666666667e-3 * t285 * t286 * t555 - 0.50765919958333333333333333333333333333333333333334e-3 * t154 * t156 * t705 - 0.4e1 * t544 * t679
  t712 = t698 * t711
  t713 = t599 * t712
  t717 = t267 * t693 * t562
  t719 = t308 * t579
  t722 = t578 ** 2
  t723 = 0.1e1 / t722
  t725 = t576 * t723 * t183
  t730 = -0.7e1 / 0.128e3 * t306 * t571 * t719 + 0.7e1 / 0.384e3 * t725 * t305 * t571 * t308
  t734 = t730 * t321 - 0.4e1 / 0.3e1 * t580 * t107
  t735 = t734 * t217
  t737 = t599 * t735 * t584
  t740 = t142 * t552
  t742 = t267 * t740 * t563
  t743 = t169 * t581
  t746 = t336 * t213 * t584
  t747 = t743 * t171 * t746
  t750 = t273 * t606
  t751 = t217 * t610
  t752 = t751 * t734
  t753 = t750 * t752
  t756 = t35 + t62 + t651 - t654 - t657 + 0.47803703703703703703703703703703703703703703703705e-2 * t105 * t106 * t552 * t586 + 0.35852777777777777777777777777777777777777777777779e-2 * t105 * t225 * t688 * t586 - 0.35852777777777777777777777777777777777777777777779e-2 * t697 * t713 + 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t737 - 0.39836419753086419753086419753086419753086419753088e-3 * t742 * t747 - 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t753
  t758 = t615 ** 2
  t759 = 0.1e1 / t758
  t760 = t589 * t759
  t761 = t679 * t352
  t764 = t544 * t153
  t765 = t764 * t15
  t766 = t555 * t1
  t767 = t766 * t398
  t770 = t155 * t541
  t771 = t770 * t675
  t780 = 0.58998125000000000000000000000000000000000000000000e-2 * t761 * t591 - 0.11799625000000000000000000000000000000000000000000e-1 * t765 * t767 - 0.58998125000000000000000000000000000000000000000000e-2 * t590 * t771 - 0.14341111111111111111111111111111111111111111111111e-1 * t152 * t13 * t550 - 0.21511666666666666666666666666666666666666666666667e-1 * t152 * t357 * t686
  t781 = t780 * t562
  t782 = t781 * t599
  t785 = t597 * t695
  t786 = t785 * t599
  t787 = t419 * t712
  t790 = t734 * t1
  t791 = t790 * t151
  t792 = t791 * t601
  t795 = t428 * t584
  t796 = t152 * t795
  t799 = t598 * t166
  t800 = t743 * t1
  t801 = t799 * t800
  t802 = t437 * t746
  t805 = t598 * t750
  t806 = t419 * t752
  t809 = t688 * t562
  t810 = t809 * t607
  t813 = t552 * t695
  t814 = t813 * t607
  t815 = t374 * t610
  t816 = t815 * t711
  t817 = t451 * t816
  t820 = t815 * t734
  t821 = t451 * t820
  t825 = t105 * t461 * t610
  t828 = t605 * t165
  t829 = t370 * t606
  t830 = t829 * t105
  t831 = t828 * t830
  t833 = t470 * t610 * t473
  t836 = t606 * t581
  t837 = t371 * t836
  t838 = t605 * t837
  t840 = 0.1e1 / t609 / t583
  t841 = t374 * t840
  t842 = t841 * t734
  t843 = t451 * t842
  t846 = 0.16666666666666666666666666666666666666666666666667e0 * t782 * t602 - 0.16666666666666666666666666666666666666666666666667e0 * t786 * t787 + 0.16666666666666666666666666666666666666666666666667e0 * t600 * t792 + 0.11111111111111111111111111111111111111111111111111e0 * t600 * t796 - 0.18518518518518518518518518518518518518518518518519e-1 * t801 * t802 - 0.16666666666666666666666666666666666666666666666667e0 * t805 * t806 - 0.25000000000000000000000000000000000000000000000001e0 * t810 * t612 + 0.25000000000000000000000000000000000000000000000001e0 * t814 * t817 - 0.50000000000000000000000000000000000000000000000002e0 * t608 * t821 - 0.33333333333333333333333333333333333333333333333335e0 * t608 * t825 + 0.55555555555555555555555555555555555555555555555558e-1 * t831 * t833 + 0.50000000000000000000000000000000000000000000000002e0 * t838 * t843
  t848 = t756 * t616 - t760 * t846 - t382 + t488
  t850 = 0.2e1 * t627 * t848
  t852 = 0.1e1 / t91 / t79
  t853 = t97 ** 2
  t855 = t852 * t853 * t99
  t857 = 0.11696446794910408141662685001236899248561775660981e1 * t90 * t855
  t858 = 0.1e1 / t155
  t861 = t21 * t5 * t211
  t862 = t858 * t20 * t861
  t864 = t43 * t142
  t865 = t42 * t864
  t867 = t4 * t143
  t869 = t14 ** (-0.5e0)
  t871 = t869 * t20 * t861
  t873 = t50 * t864
  t875 = t22 * t249
  t877 = -0.57538888888888888888888888888888888888888888888889e0 * t862 + 0.11507777777777777777777777777777777777777777777778e1 * t865 + 0.40256666666666666666666666666666666666666666666667e0 * t867 + 0.36677500000000000000000000000000000000000000000000e-1 * t871 + 0.73355000000000000000000000000000000000000000000000e-1 * t873 + 0.13797500000000000000000000000000000000000000000000e0 * t875
  t879 = t92 * t877 * t99
  t881 = 0.58482233974552040708313425006184496242808878304903e0 * t90 * t879
  t882 = t91 ** 2
  t883 = 0.1e1 / t882
  t885 = t82 ** 2
  t886 = 0.1e1 / t885
  t887 = t883 * t853 * t886
  t889 = 0.17315755899375863299672358916972966258900005419821e2 * t90 * t887
  t890 = t325 ** 2
  t891 = t890 * t217
  t900 = t8 * t148
  t902 = t267 * t900 * t164
  t905 = t9 * t262
  t907 = t267 * t905 * t164
  t911 = 0.1e1 / t269 / t163
  t914 = t296 ** 2
  t915 = t275 * t914
  t919 = t10 * t155
  t923 = t54 * t15
  t930 = t352 * t136
  t937 = t240 ** 2
  t958 = -t858 * t111 * t20 * t861 / 0.18e2 - t41 * t237 * t1 * t44 / 0.6e1 + t232 * t864 / 0.9e1 + t15 * (-0.44044444444444444444444444444444444444444444444445e-2 * t862 + 0.88088888888888888888888888888888888888888888888889e-2 * t865 + 0.55033333333333333333333333333333333333333333333333e-2 * t867) / 0.2e1
  t963 = t244 ** 2
  t967 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t143 * t32
  t968 = t4 * t6
  t972 = 0.35616666666666666666666666666666666666666666666666e-1 * t968 * t10 * t39 * t60
  t976 = t58 ** 2
  t979 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t976 * t59
  t989 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t862 + 0.84396666666666666666666666666666666666666666666666e0 * t865 + 0.39862222222222222222222222222222222222222222222223e0 * t867 + 0.68258333333333333333333333333333333333333333333333e-1 * t871 + 0.13651666666666666666666666666666666666666666666667e0 * t873 + 0.13692777777777777777777777777777777777777777777778e0 * t875) * t59
  t990 = t38 ** 2
  t993 = t31 ** 2
  t997 = 0.16081824322151104821330931780901225435013347914188e2 * t37 / t990 * t976 / t993
  t999 = t43 * t142 * t83
  t1001 = 0.24415406715670879921742973310852762593515528885057e-3 * t74 * t999
  t1003 = t11 * t100
  t1005 = 0.10843580882781524214666447553230042011687479519034e-1 * t73 * t4 * t1003
  t1006 = -t967 - t972 - t979 + t989 + t997 + t1001 + t1005 + t857 - t881 - t889
  t1009 = -0.43802864444444444444444444444444444444444444444443e-3 * t154 * t919 * t157 - 0.2e-52 * t285 * t923 * t157 - 0.26281718666666666666666666666666666666666666666666e-2 * t154 * t276 * t290 + 0.19711288999999999999999999999999999999999999999999e-2 * t930 * t41 * t157 + 0.19711288999999999999999999999999999999999999999999e-2 * t285 * t286 * t290 + 0.39422577999999999999999999999999999999999999999998e-2 * t154 * t156 * t230 * t937 - 0.19711288999999999999999999999999999999999999999999e-2 * t154 * t156 * t116 * t958 - 0.4e1 * t963 - 0.4e1 * t124 * t1006
  t1010 = t275 * t1009
  t1016 = 0.1e1 / t185 / t303 / t7
  t1017 = t183 * t1016
  t1019 = t1017 * t193 * t309
  t1021 = t177 ** 2
  t1022 = t1021 * t177
  t1023 = t303 ** 2
  t1025 = 0.1e1 / t1023 / t7
  t1026 = t1022 * t1025
  t1027 = t191 ** 2
  t1029 = 0.1e1 / t1027 / t191
  t1044 = t315 * t1016 * t193 * t308
  t1054 = (0.63e2 / 0.256e3 * t1019 - 0.49e2 / 0.8192e4 * t1026 * t1029 * jnp.pi * t313 + 0.49e2 / 0.24576e5 * t201 / t312 / t203 * t1022 * t1025 * t1029 * jnp.pi - 0.21e2 / 0.256e3 * t1044) * t321 - 0.4e1 / 0.3e1 * t320 * t107 + 0.7e1 / 0.96e2 * t1019 - 0.7e1 / 0.288e3 * t1044 + 0.4e1 / 0.3e1 * t205 * t136
  t1060 = t346 * t1054
  t1076 = t273 * t477
  t1078 = t217 * t481 * t890
  t1082 = t857 - t881 - t889 - 0.39796666666666666666666666666666666666666666666665e-1 * t302 * t343 * t891 * t345 + 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t274 * t891 * t220 - 0.35374814814814814814814814814814814814814814814814e-1 * t902 * t348 - 0.26531111111111111111111111111111111111111111111110e-1 * t907 * t348 + 0.26531111111111111111111111111111111111111111111110e-1 * t267 * t268 * t911 * t274 * t915 - 0.13265555555555555555555555555555555555555555555555e-1 * t272 * t274 * t1010 + 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t274 * t1054 * t217 * t220 - 0.13265555555555555555555555555555555555555555555555e-1 * t302 * t343 * t1060 - 0.35374814814814814814814814814814814814814814814814e-1 * t267 * t900 * t270 * t298 + 0.35374814814814814814814814814814814814814814814814e-1 * t902 * t328 - 0.26531111111111111111111111111111111111111111111110e-1 * t267 * t905 * t270 * t298 + 0.26531111111111111111111111111111111111111111111110e-1 * t907 * t328 + 0.26531111111111111111111111111111111111111111111110e-1 * t302 * t1076 * t1078
  t1097 = t220 * t296
  t1098 = t472 * t1097
  t1107 = t169 * t342
  t1109 = t345 * t325
  t1110 = t472 * t1109
  t1123 = t6 * t24
  t1128 = t2 * t252
  t1133 = t115 ** 2
  t1145 = t126 * t257
  t1150 = t130 * t5 / t23 / t184
  t1152 = 0.1e1 / t303
  t1153 = t134 * t1152
  t1158 = t140 * t6 / t8 / t303
  t1160 = -0.37560000000000000000000000000000000000000000000000e-1 * t1128 + 0.40985000000000000000000000000000000000000000000000e-2 * t1145 - 0.10566666666666666666666666666666666666666666666667e-2 * t1150 + 0.38340000000000000000000000000000000000000000000000e-3 * t1153 - 0.42010937500000000000000000000000000000000000000000e-5 * t1158
  t1162 = 0.73596627000000000000000000000000000000000000000000e-2 * t1128 * t116 + 0.14719325400000000000000000000000000000000000000000e-1 * t226 * t241 + 0.22078988100000000000000000000000000000000000000000e-1 * t108 / t1133 * t937 - 0.73596627000000000000000000000000000000000000000000e-2 * t108 * t230 * t958 - t1006 * t146 - 0.2e1 * t244 * t260 - t124 * t1160
  t1171 = -t979 + t997 + t1005 + t989 + 0.14739506172839506172839506172839506172839506172838e-2 * t267 * t256 * t148 * t167 * t339 - 0.29479012345679012345679012345679012345679012345678e-2 * t267 * t142 * t262 * t167 * t339 + 0.29479012345679012345679012345679012345679012345678e-2 * t267 * t331 * t270 * t166 * t334 * t209 * t1098 - 0.29479012345679012345679012345679012345679012345678e-2 * t333 * t334 * t325 * t171 * t338 + 0.29479012345679012345679012345679012345679012345678e-2 * t333 * t1107 * t209 * t1110 - t972 + t1001 - 0.26531111111111111111111111111111111111111111111110e-1 * t272 * t274 * t326 * t1097 + 0.26531111111111111111111111111111111111111111111110e-1 * t272 * t343 * t346 * t296 * t325 + 0.58958024691358024691358024691358024691358024691357e-2 * t105 * t1123 * t148 * t222 + 0.13265555555555555555555555555555555555555555555555e-1 * t105 * t225 * t1162 * t222 + 0.35374814814814814814814814814814814814814814814814e-1 * t105 * t106 * t262 * t222 - t967
  t1173 = (t1082 + t1171) * t381
  t1176 = 0.2e1 * t351 * t390 * t487
  t1180 = t487 ** 2
  t1182 = 0.2e1 * t388 / t389 / t380 * t1180
  t1192 = t151 * t1152 * t171
  t1200 = t467 * t20
  t1205 = t104 / t303 / t135 * t172
  t1208 = 0.1e1 / t173 / t133 * t1021
  t1214 = t105 * t8
  t1221 = t152 * t12
  t1236 = -0.37037037037037037037037037037037037037037037037038e-1 * t433 * t334 * t423 * t438 + 0.11111111111111111111111111111111111111111111111112e0 * t445 * t165 * t468 * t474 + 0.43209876543209876543209876543209876543209876543211e-1 * t435 * t1192 * t338 - 0.37037037037037037037037037037037037037037037037038e-1 * t413 * t166 * t434 * t438 - 0.12345679012345679012345679012345679012345679012346e-1 * t466 * t1200 * t1205 * t1208 * t69 * t345 + 0.66666666666666666666666666666666666666666666666670e0 * t450 * t1214 * t453 - 0.13333333333333333333333333333333333333333333333334e1 * t373 * t1214 * t457 - 0.22222222222222222222222222222222222222222222222222e0 * t441 * t1221 * t347 - 0.10000000000000000000000000000000000000000000000000e1 * t446 * t458 + 0.10000000000000000000000000000000000000000000000000e1 * t445 * t478 * t484 - 0.50000000000000000000000000000000000000000000000002e0 * t148 * t911 * t372 * t451 * t452 * t914
  t1244 = t890 * t1 * t151
  t1248 = t449 * t165
  t1250 = t345 * t296
  t1259 = t370 * t477
  t1271 = t104 * t9 * t374
  t1272 = t1250 * t325
  t1283 = t417 * t166
  t1287 = t151 * t23 * t217
  t1298 = t252 * t171 * t208
  t1302 = t256 * t217
  t1307 = -0.22222222222222222222222222222222222222222222222222e0 * t418 * t1221 * t297 + 0.22222222222222222222222222222222222222222222222222e0 * t363 * t424 * t429 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t1244 * t365 - 0.11111111111111111111111111111111111111111111111112e0 * t1248 * t468 * t470 * t1250 * t473 + 0.22222222222222222222222222222222222222222222222224e0 * t469 * t470 * t1109 * t473 - 0.22222222222222222222222222222222222222222222222224e0 * t466 * t1259 * t105 * t470 * t481 * t171 * t336 * t213 * t325 + 0.10000000000000000000000000000000000000000000000000e1 * t1248 * t1200 * t1271 * t1272 - 0.10000000000000000000000000000000000000000000000000e1 * t1248 * t1259 * t20 * t1271 * t481 * t296 * t325 + 0.33333333333333333333333333333333333333333333333334e0 * t1283 * t1107 * t1 * t1287 * t1272 - 0.33333333333333333333333333333333333333333333333334e0 * t1283 * t334 * t325 * t420 + 0.37037037037037037037037037037037037037037037037038e-1 * t433 * t1107 * t152 * t1298 * t1110 - 0.55555555555555555555555555555555555555555555555562e-1 * t469 * t1302 * t345 * t473
  t1340 = t342 ** 2
  t1343 = t344 ** 2
  t1361 = 0.37037037037037037037037037037037037037037037037038e-1 * t1283 * t334 * t152 * t1298 * t1098 + 0.50000000000000000000000000000000000000000000000002e0 * t262 * t270 * t372 * t454 + 0.33333333333333333333333333333333333333333333333334e0 * t414 * t425 - 0.16666666666666666666666666666666666666666666666667e0 * t418 * t419 * t1010 + 0.16666666666666666666666666666666666666666666666667e0 * t363 * t1054 * t1 * t151 * t365 - 0.33333333333333333333333333333333333333333333333334e0 * t412 * t270 * t274 * t420 - 0.10000000000000000000000000000000000000000000000000e1 * t373 * t451 * t452 * t890 + 0.25000000000000000000000000000000000000000000000001e1 * t479 * t451 * t482 * t890 - 0.15000000000000000000000000000000000000000000000001e1 * t369 * t371 * t1340 * t451 * t374 / t1343 * t890 + 0.33333333333333333333333333333333333333333333333334e0 * t362 * t1076 * t419 * t1078 - 0.50000000000000000000000000000000000000000000000001e0 * t441 * t1244 * t364 * t345 + 0.13333333333333333333333333333333333333333333333334e1 * t479 * t1214 * t483
  t1403 = t21 * t211
  t1413 = t3 * t142
  t1433 = 0.61912500000000000000000000000000000000000000000000e-2 * t1006 * t352 * t354 - 0.24765000000000000000000000000000000000000000000000e-1 * t244 * t153 * t15 * t399 - 0.12382500000000000000000000000000000000000000000000e-1 * t392 * t403 + 0.20637500000000000000000000000000000000000000000000e-2 * t124 * t284 * t41 * t157 * t20 * t1403 + 0.24765000000000000000000000000000000000000000000000e-1 * t395 * t15 * t116 * t4 * t10 * t240 + 0.16510000000000000000000000000000000000000000000000e-1 * t396 * t397 * t1413 + 0.12382500000000000000000000000000000000000000000000e-1 * t353 * t155 * t230 * t937 - 0.61912500000000000000000000000000000000000000000000e-2 * t353 * t402 * t958 + 0.17687407407407407407407407407407407407407407407407e-1 * t152 * t11 * t146 - 0.10612444444444444444444444444444444444444444444444e0 * t152 * t13 * t260 - 0.79593333333333333333333333333333333333333333333331e-1 * t152 * t357 * t1160
  t1438 = t24 * t374
  t1445 = t10 * t217
  t1450 = -0.33333333333333333333333333333333333333333333333334e0 * t413 * t343 * t442 + 0.33333333333333333333333333333333333333333333333334e0 * t361 * t911 * t274 * t419 * t915 + 0.50000000000000000000000000000000000000000000000002e0 * t479 * t451 * t482 * t1054 + 0.25000000000000000000000000000000000000000000000001e0 * t450 * t451 * t452 * t1009 - 0.50000000000000000000000000000000000000000000000002e0 * t373 * t451 * t452 * t1054 - 0.16666666666666666666666666666666666666666666666667e0 * t441 * t419 * t1060 + 0.22222222222222222222222222222222222222222222222222e0 * t414 * t430 - 0.25000000000000000000000000000000000000000000000001e0 * t1162 * t164 * t372 * t377 + 0.16666666666666666666666666666666666666666666666667e0 * t1433 * t164 * t274 * t366 - 0.11111111111111111111111111111111111111111111111112e0 * t373 * t105 * t1438 * t345 - 0.66666666666666666666666666666666666666666666666670e0 * t446 * t463 - 0.37037037037037037037037037037037037037037037037037e-1 * t363 * t152 * t1445 * t220
  t1453 = t391 * (t1236 + t1307 + t1361 + t1450)
  t1454 = t494 ** 2
  t1455 = 0.1e1 / t1454
  t1456 = t496 ** 2
  t1459 = t490 * t252
  t1461 = -0.2e1 * t136 + 0.2e1 * t1459
  t1465 = f.my_piecewise3(t493, 0, 0.4e1 / 0.9e1 * t1455 * t1456 + 0.4e1 / 0.3e1 * t494 * t1461)
  t1466 = t502 ** 2
  t1467 = 0.1e1 / t1466
  t1468 = t503 ** 2
  t1475 = f.my_piecewise3(t501, 0, 0.4e1 / 0.9e1 * t1467 * t1468 - 0.4e1 / 0.3e1 * t502 * t1461)
  t1479 = t508 * t848
  t1495 = t584 * t711
  t1496 = t472 * t1495
  t1502 = 0.10843580882781524214666447553230042011687479519034e-1 * t515 * t4 * t1003
  t1513 = 0.24415406715670879921742973310852762593515528885057e-3 * t652 * t999
  t1514 = t273 * t836
  t1516 = t734 ** 2
  t1517 = t217 * t840 * t1516
  t1521 = t1516 * t217
  t1531 = 0.1e1 / t694 / t561
  t1534 = t711 ** 2
  t1535 = t698 * t1534
  t1539 = t8 * t552
  t1541 = t267 * t1539 * t562
  t1544 = t9 * t688
  t1546 = t267 * t1544 * t562
  t1549 = 0.39836419753086419753086419753086419753086419753089e-3 * t267 * t256 * t552 * t563 * t747 - 0.79672839506172839506172839506172839506172839506176e-3 * t267 * t142 * t688 * t563 * t747 + 0.79672839506172839506172839506172839506172839506176e-3 * t267 * t740 * t695 * t166 * t743 * t209 * t1496 - t979 + t997 + t1502 + t989 - 0.71705555555555555555555555555555555555555555555558e-2 * t697 * t599 * t735 * t1495 + 0.71705555555555555555555555555555555555555555555558e-2 * t697 * t750 * t751 * t711 * t734 + t1513 - t972 + 0.71705555555555555555555555555555555555555555555558e-2 * t717 * t1514 * t1517 - 0.10755833333333333333333333333333333333333333333334e-1 * t717 * t750 * t1521 * t610 + 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t599 * t1521 * t584 + 0.71705555555555555555555555555555555555555555555558e-2 * t267 * t693 * t1531 * t599 * t1535 - 0.95607407407407407407407407407407407407407407407410e-2 * t1541 * t753 - 0.71705555555555555555555555555555555555555555555558e-2 * t1546 * t753
  t1565 = t675 ** 2
  t1586 = -t858 * t536 * t20 * t861 / 0.18e2 - t41 * t672 * t1 * t44 / 0.6e1 + t667 * t864 / 0.9e1 + t15 * (-0.99474444444444444444444444444444444444444444444447e-4 * t862 + 0.19894888888888888888888888888888888888888888888889e-3 * t865 + 0.52442777777777777777777777777777777777777777777777e-2 * t867) / 0.2e1
  t1591 = t679 ** 2
  t1603 = t638 ** 2
  t1617 = t631 ** 2
  t1620 = t525 ** 2
  t1643 = -0.70981924444444444444444444444444444444444444444442e-3 * t4 * t143 * t526 - 0.34246666666666666666666666666666666666666666666666e-1 * t968 * t10 * t632 * t640 - 0.20000000000000000000000000000000000000000000000000e1 * t517 / t631 / t522 * t1603 * t639 + 0.99999999999999999999999999999999999999999999999999e0 * t633 * (-0.78438333333333333333333333333333333333333333333333e0 * t862 + 0.15687666666666666666666666666666666666666666666667e1 * t865 + 0.68863333333333333333333333333333333333333333333333e0 * t867 + 0.14025833333333333333333333333333333333333333333333e0 * t871 + 0.28051666666666666666666666666666666666666666666667e0 * t873 + 0.17365833333333333333333333333333333333333333333333e0 * t875) * t639 + 0.32164683177870697973624959794146027661627532968800e2 * t517 / t1617 * t1603 / t1620 + t967 + t972 + t979 - t989 - t997 - 0.24415406715670879921742973310852762593515528885057e-3 * t4 * t143 * t83 - 0.10843580882781524214666447553230042011687479519034e-1 * t968 * t10 * t92 * t647 - 0.11696446794910408141662685001236899248561775660981e1 * t89 * t852 * t853 * t99 + 0.58482233974552040708313425006184496242808878304903e0 * t646 * t877 * t99 + 0.17315755899375863299672358916972966258900005419821e2 * t89 * t883 * t853 * t886
  t1644 = t515 * t1643
  t1646 = 0.11696446794910408141662685001236899248561775660981e1 * t655 * t855
  t1648 = 0.58482233974552040708313425006184496242808878304903e0 * t655 * t879
  t1650 = 0.17315755899375863299672358916972966258900005419821e2 * t655 * t887
  t1651 = -t967 - t972 - t979 + t989 + t997 + t1644 + t1513 + t1502 + t1646 - t1648 - t1650
  t1654 = -0.11281315546296296296296296296296296296296296296296e-3 * t154 * t919 * t555 + 0.1e-52 * t285 * t923 * t555 - 0.67687893277777777777777777777777777777777777777778e-3 * t154 * t276 * t705 + 0.50765919958333333333333333333333333333333333333334e-3 * t930 * t41 * t555 + 0.50765919958333333333333333333333333333333333333334e-3 * t285 * t286 * t705 + 0.10153183991666666666666666666666666666666666666667e-2 * t154 * t156 * t665 * t1565 - 0.50765919958333333333333333333333333333333333333334e-3 * t154 * t156 * t541 * t1586 - 0.4e1 * t1591 - 0.4e1 * t544 * t1651
  t1655 = t698 * t1654
  t1660 = t1017 * t571 * t719
  t1662 = t569 ** 2
  t1664 = 0.1e1 / t1662 / t569
  t1679 = t725 * t1016 * t571 * t308
  t1689 = (0.63e2 / 0.256e3 * t1660 - 0.49e2 / 0.8192e4 * t1026 * t1664 * jnp.pi * t723 + 0.49e2 / 0.24576e5 * t576 / t722 / t578 * t1022 * t1025 * t1664 * jnp.pi - 0.21e2 / 0.256e3 * t1679) * t321 - 0.4e1 / 0.3e1 * t730 * t107 + 0.7e1 / 0.96e2 * t1660 - 0.7e1 / 0.288e3 * t1679 + 0.4e1 / 0.3e1 * t580 * t136
  t1695 = t751 * t1689
  t1723 = t540 ** 2
  t1739 = -0.48613650000000000000000000000000000000000000000000e-1 * t1128 + 0.58332050000000000000000000000000000000000000000000e-2 * t1145 - 0.16123583333333333333333333333333333333333333333333e-2 * t1150 + 0.60452325000000000000000000000000000000000000000000e-3 * t1153 - 0.67352906250000000000000000000000000000000000000000e-5 * t1158
  t1741 = 0.66830952067500000000000000000000000000000000000000e-2 * t1128 * t541 + 0.13366190413500000000000000000000000000000000000000e-1 * t226 * t676 + 0.20049285620250000000000000000000000000000000000000e-1 * t108 / t1723 * t1565 - 0.66830952067500000000000000000000000000000000000000e-2 * t108 * t665 * t1586 - t1651 * t550 - 0.2e1 * t679 * t686 - t544 * t1739
  t1746 = t169 * t606
  t1748 = t610 * t734
  t1749 = t472 * t1748
  t1758 = -0.35852777777777777777777777777777777777777777777779e-2 * t697 * t599 * t1655 + 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t599 * t1689 * t217 * t584 - 0.35852777777777777777777777777777777777777777777779e-2 * t717 * t750 * t1695 - 0.95607407407407407407407407407407407407407407407410e-2 * t267 * t1539 * t695 * t713 + 0.95607407407407407407407407407407407407407407407410e-2 * t1541 * t737 - 0.71705555555555555555555555555555555555555555555558e-2 * t267 * t1544 * t695 * t713 - t967 + t1644 + 0.71705555555555555555555555555555555555555555555558e-2 * t1546 * t737 + 0.15934567901234567901234567901234567901234567901235e-2 * t105 * t1123 * t552 * t586 + 0.95607407407407407407407407407407407407407407407410e-2 * t105 * t106 * t688 * t586 + 0.35852777777777777777777777777777777777777777777779e-2 * t105 * t225 * t1741 * t586 + t1646 - t1648 - t1650 + 0.79672839506172839506172839506172839506172839506176e-3 * t742 * t1746 * t209 * t1749 - 0.79672839506172839506172839506172839506172839506176e-3 * t742 * t743 * t734 * t171 * t746
  t1767 = t846 ** 2
  t1783 = t785 * t166
  t1793 = t829 * t20
  t1853 = 0.58998125000000000000000000000000000000000000000000e-2 * t1651 * t352 * t591 - 0.23599250000000000000000000000000000000000000000000e-1 * t679 * t153 * t15 * t767 - 0.11799625000000000000000000000000000000000000000000e-1 * t761 * t771 + 0.19666041666666666666666666666666666666666666666667e-2 * t544 * t284 * t41 * t555 * t20 * t1403 + 0.23599250000000000000000000000000000000000000000000e-1 * t764 * t15 * t541 * t4 * t10 * t675 + 0.15732833333333333333333333333333333333333333333333e-1 * t765 * t766 * t1413 + 0.11799625000000000000000000000000000000000000000000e-1 * t590 * t155 * t665 * t1565 - 0.58998125000000000000000000000000000000000000000000e-2 * t590 * t770 * t1586 + 0.47803703703703703703703703703703703703703703703703e-2 * t152 * t11 * t550 - 0.28682222222222222222222222222222222222222222222222e-1 * t152 * t13 * t686 - 0.21511666666666666666666666666666666666666666666667e-1 * t152 * t357 * t1739
  t1858 = 0.37037037037037037037037037037037037037037037037038e-1 * t799 * t1746 * t152 * t1298 * t1749 + 0.11111111111111111111111111111111111111111111111112e0 * t809 * t165 * t830 * t833 - 0.55555555555555555555555555555555555555555555555562e-1 * t831 * t1302 * t610 * t473 + 0.37037037037037037037037037037037037037037037037038e-1 * t1783 * t743 * t152 * t1298 * t1496 - 0.37037037037037037037037037037037037037037037037038e-1 * t799 * t743 * t790 * t802 - 0.12345679012345679012345679012345679012345679012346e-1 * t828 * t1793 * t1205 * t1208 * t69 * t610 + 0.43209876543209876543209876543209876543209876543211e-1 * t801 * t1192 * t746 - 0.37037037037037037037037037037037037037037037037038e-1 * t781 * t166 * t800 * t802 + 0.22222222222222222222222222222222222222222222222222e0 * t782 * t796 - 0.25000000000000000000000000000000000000000000000001e0 * t1741 * t562 * t607 * t612 + 0.16666666666666666666666666666666666666666666666667e0 * t1853 * t562 * t599 * t602
  t1869 = t813 * t165
  t1871 = t610 * t711
  t1872 = t1871 * t734
  t1876 = t370 * t836
  t1914 = -0.11111111111111111111111111111111111111111111111112e0 * t608 * t105 * t1438 * t610 - 0.66666666666666666666666666666666666666666666666670e0 * t810 * t825 - 0.37037037037037037037037037037037037037037037037037e-1 * t600 * t152 * t1445 * t584 + 0.10000000000000000000000000000000000000000000000000e1 * t1869 * t1793 * t1271 * t1872 - 0.10000000000000000000000000000000000000000000000000e1 * t1869 * t1876 * t20 * t1271 * t840 * t711 * t734 + 0.33333333333333333333333333333333333333333333333334e0 * t1783 * t1746 * t1 * t1287 * t1872 - 0.33333333333333333333333333333333333333333333333334e0 * t1783 * t743 * t734 * t787 + 0.10000000000000000000000000000000000000000000000000e1 * t809 * t837 * t843 - 0.50000000000000000000000000000000000000000000000002e0 * t552 * t1531 * t607 * t451 * t815 * t1534 + 0.33333333333333333333333333333333333333333333333334e0 * t597 * t1531 * t599 * t419 * t1535 - 0.22222222222222222222222222222222222222222222222222e0 * t786 * t1221 * t712 + 0.50000000000000000000000000000000000000000000000002e0 * t838 * t451 * t841 * t1689
  t1934 = t1516 * t1 * t151
  t1956 = 0.25000000000000000000000000000000000000000000000001e0 * t814 * t451 * t815 * t1654 - 0.50000000000000000000000000000000000000000000000002e0 * t608 * t451 * t815 * t1689 - 0.16666666666666666666666666666666666666666666666667e0 * t805 * t419 * t1695 + 0.66666666666666666666666666666666666666666666666670e0 * t814 * t1214 * t816 + 0.22222222222222222222222222222222222222222222222222e0 * t600 * t791 * t795 + 0.16666666666666666666666666666666666666666666666667e0 * t600 * t1934 * t601 - 0.22222222222222222222222222222222222222222222222222e0 * t805 * t1221 * t752 - 0.33333333333333333333333333333333333333333333333334e0 * t781 * t750 * t806 - 0.50000000000000000000000000000000000000000000000001e0 * t805 * t1934 * t364 * t610 - 0.13333333333333333333333333333333333333333333333334e1 * t608 * t1214 * t820 + 0.13333333333333333333333333333333333333333333333334e1 * t838 * t1214 * t842 - 0.10000000000000000000000000000000000000000000000000e1 * t810 * t821
  t1966 = t606 ** 2
  t1969 = t609 ** 2
  t2015 = -0.16666666666666666666666666666666666666666666666667e0 * t786 * t419 * t1655 - 0.33333333333333333333333333333333333333333333333334e0 * t780 * t695 * t599 * t787 + 0.33333333333333333333333333333333333333333333333334e0 * t782 * t792 - 0.15000000000000000000000000000000000000000000000001e1 * t605 * t371 * t1966 * t451 * t374 / t1969 * t1516 - 0.10000000000000000000000000000000000000000000000000e1 * t608 * t451 * t815 * t1516 + 0.25000000000000000000000000000000000000000000000001e1 * t838 * t451 * t841 * t1516 + 0.33333333333333333333333333333333333333333333333334e0 * t598 * t1514 * t419 * t1517 + 0.50000000000000000000000000000000000000000000000002e0 * t688 * t695 * t607 * t817 + 0.16666666666666666666666666666666666666666666666667e0 * t600 * t1689 * t1 * t151 * t601 - 0.22222222222222222222222222222222222222222222222224e0 * t828 * t1876 * t105 * t470 * t840 * t171 * t336 * t213 * t734 - 0.11111111111111111111111111111111111111111111111112e0 * t1869 * t830 * t470 * t1871 * t473 + 0.22222222222222222222222222222222222222222222222224e0 * t831 * t470 * t1748 * t473
  t2020 = t627 * ((t1549 + t1758) * t616 - 0.2e1 * t756 * t759 * t846 + 0.2e1 * t589 / t758 / t615 * t1767 - t760 * (t1858 + t1914 + t1956 + t2015) - t1173 + t1176 - t1182 + t1453)
  d11 = t383 - t489 + 0.2e1 * t620 + t850 + t7 * (t1173 - t1176 + t1182 - t1453 + (t1465 + t1475) * t72 * t619 + 0.2e1 * t1479 + t2020)
  t2023 = -t107 - t495
  t2026 = f.my_piecewise3(t493, 0, 0.4e1 / 0.3e1 * t494 * t2023)
  t2027 = -t2023
  t2030 = f.my_piecewise3(t501, 0, 0.4e1 / 0.3e1 * t502 * t2027)
  t2032 = (t2026 + t2030) * t72
  t2033 = t2032 * t619
  t2041 = f.my_piecewise3(t493, 0, 0.4e1 / 0.9e1 * t1455 * t2023 * t496 + 0.8e1 / 0.3e1 * t494 * t490 * t252)
  t2049 = f.my_piecewise3(t501, 0, 0.4e1 / 0.9e1 * t1467 * t2027 * t503 - 0.8e1 / 0.3e1 * t502 * t490 * t252)
  t2053 = t2032 * t848
  d12 = t383 - t489 + t620 + t850 + t2033 + t7 * (t1173 - t1176 + t1182 - t1453 + (t2041 + t2049) * t72 * t619 + t2053 + t1479 + t2020)
  t2057 = t2023 ** 2
  t2061 = 0.2e1 * t136 + 0.2e1 * t1459
  t2065 = f.my_piecewise3(t493, 0, 0.4e1 / 0.9e1 * t1455 * t2057 + 0.4e1 / 0.3e1 * t494 * t2061)
  t2066 = t2027 ** 2
  t2073 = f.my_piecewise3(t501, 0, 0.4e1 / 0.9e1 * t1467 * t2066 - 0.4e1 / 0.3e1 * t502 * t2061)
  d22 = t383 - t489 + 0.2e1 * t2033 + t850 + t7 * (t1173 - t1176 + t1182 - t1453 + (t2065 + t2073) * t72 * t619 + 0.2e1 * t2053 + t2020)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

