"""Generated from gga_c_op_pbe.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3789

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  op_enhancement = lambda xs: pbe_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3789

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  op_enhancement = lambda xs: pbe_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3789

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  op_enhancement = lambda xs: pbe_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t18 ** 2
  t20 = 0.1e1 - t19
  t21 = t20 * t2
  t24 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t27 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t28 = f.my_piecewise5(t24, t14, t27, t17, t4)
  t29 = 0.1e1 + t28
  t32 = t29 * t2 / 0.2e1 <= f.p.dens_threshold
  t33 = 3 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t38 = t34 / t36
  t39 = 4 ** (0.1e1 / 0.3e1)
  t40 = t38 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t29 <= f.p.zeta_threshold
  t43 = 0.1e1 - t28
  t44 = t43 <= f.p.zeta_threshold
  t45 = f.my_piecewise5(t42, t14, t44, t17, t28)
  t47 = (0.1e1 + t45) * t2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t49 = 0.1e1 / t48
  t51 = 6 ** (0.1e1 / 0.3e1)
  t52 = jnp.pi ** 2
  t53 = t52 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t55 = 0.1e1 / t54
  t56 = t51 * t55
  t57 = r0 ** 2
  t58 = r0 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t61 = 0.1e1 / t59 / t57
  t65 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t56 * s0 * t61
  t68 = 0.18040e1 - 0.64641600e0 / t65
  t69 = 0.1e1 / t68
  t73 = f.my_piecewise3(t32, 0, t40 * t41 * t49 * t69 / 0.9e1)
  t77 = t43 * t2 / 0.2e1 <= f.p.dens_threshold
  t78 = f.my_piecewise5(t44, t14, t42, t17, -t28)
  t80 = (0.1e1 + t78) * t2
  t81 = t80 ** (0.1e1 / 0.3e1)
  t82 = 0.1e1 / t81
  t84 = r1 ** 2
  t85 = r1 ** (0.1e1 / 0.3e1)
  t86 = t85 ** 2
  t88 = 0.1e1 / t86 / t84
  t92 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t56 * s2 * t88
  t95 = 0.18040e1 - 0.64641600e0 / t92
  t96 = 0.1e1 / t95
  t100 = f.my_piecewise3(t77, 0, t40 * t41 * t82 * t96 / 0.9e1)
  t101 = t73 + t100
  t102 = t101 == 0.0e0
  t103 = f.my_piecewise3(t102, DBL_EPSILON, t101)
  t106 = 0.361925846e1 / t103 + 0.5764e0
  t107 = t103 ** 2
  t108 = t107 ** 2
  t109 = 0.1e1 / t108
  t112 = 0.1e1 / t107 / t103
  t114 = 0.1e1 / t107
  t116 = 0.320261508740743441e2 * t109 + 0.151911844324290596e2 * t112 + 0.1801312286343e1 * t114
  t117 = 0.1e1 / t116
  t121 = f.my_piecewise3(t11, 0, -0.25000000000000000000000000000000000000000000000000e0 * t21 * t106 * t117)
  t122 = t2 ** 2
  t124 = t1 / t122
  t125 = t3 - t124
  t126 = f.my_piecewise5(t13, 0, t16, 0, t125)
  t129 = t2 * t106 * t117
  t134 = 0.25000000000000000000000000000000000000000000000000e0 * t20 * t106 * t117
  t137 = t41 / t48 / t47
  t138 = f.my_piecewise5(t24, 0, t27, 0, t125)
  t139 = f.my_piecewise5(t42, 0, t44, 0, t138)
  t146 = t39 * t41
  t148 = t38 * t146 * t49
  t149 = t68 ** 2
  t151 = t65 ** 2
  t153 = 0.1e1 / t149 / t151
  t164 = f.my_piecewise3(t32, 0, -t40 * t137 * t69 * (t139 * t2 + t45 + 0.1e1) / 0.27e2 + 0.17518270448709640211555555555555555555555555555556e-2 * t148 * t153 * t51 * t55 * s0 / t59 / t57 / r0)
  t167 = t41 / t81 / t80
  t168 = f.my_piecewise5(t44, 0, t42, 0, -t138)
  t175 = f.my_piecewise3(t77, 0, -t40 * t167 * t96 * (t168 * t2 + t78 + 0.1e1) / 0.27e2)
  t177 = f.my_piecewise3(t102, 0, t164 + t175)
  t182 = t116 ** 2
  t184 = t106 / t182
  t186 = 0.1e1 / t108 / t103
  t198 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t126 * t129 - t134 + 0.90481461500000000000000000000000000000000000000000e0 * t21 * t114 * t177 * t117 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t184 * (-0.1281046034962973764e3 * t186 * t177 - 0.455735532972871788e2 * t109 * t177 - 0.3602624572686e1 * t112 * t177))
  vrho_0_ = t2 * t198 + t121
  t200 = -t3 - t124
  t201 = f.my_piecewise5(t13, 0, t16, 0, t200)
  t205 = f.my_piecewise5(t24, 0, t27, 0, t200)
  t206 = f.my_piecewise5(t42, 0, t44, 0, t205)
  t213 = f.my_piecewise3(t32, 0, -t40 * t137 * t69 * (t206 * t2 + t45 + 0.1e1) / 0.27e2)
  t214 = f.my_piecewise5(t44, 0, t42, 0, -t205)
  t222 = t38 * t146 * t82
  t223 = t95 ** 2
  t225 = t92 ** 2
  t227 = 0.1e1 / t223 / t225
  t238 = f.my_piecewise3(t77, 0, -t40 * t167 * t96 * (t214 * t2 + t78 + 0.1e1) / 0.27e2 + 0.17518270448709640211555555555555555555555555555556e-2 * t222 * t227 * t51 * t55 * s2 / t86 / t84 / r1)
  t240 = f.my_piecewise3(t102, 0, t213 + t238)
  t256 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t201 * t129 - t134 + 0.90481461500000000000000000000000000000000000000000e0 * t21 * t114 * t240 * t117 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t184 * (-0.1281046034962973764e3 * t186 * t240 - 0.455735532972871788e2 * t109 * t240 - 0.3602624572686e1 * t112 * t240))
  vrho_1_ = t2 * t256 + t121
  t262 = f.my_piecewise3(t32, 0, -0.65693514182661150793333333333333333333333333333333e-3 * t148 * t153 * t56 * t61)
  t263 = f.my_piecewise3(t102, 0, t262)
  t279 = f.my_piecewise3(t11, 0, 0.90481461500000000000000000000000000000000000000000e0 * t21 * t114 * t263 * t117 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t184 * (-0.1281046034962973764e3 * t186 * t263 - 0.455735532972871788e2 * t109 * t263 - 0.3602624572686e1 * t112 * t263))
  vsigma_0_ = t2 * t279
  vsigma_1_ = 0.0e0
  t284 = f.my_piecewise3(t77, 0, -0.65693514182661150793333333333333333333333333333333e-3 * t222 * t227 * t56 * t88)
  t285 = f.my_piecewise3(t102, 0, t284)
  t301 = f.my_piecewise3(t11, 0, 0.90481461500000000000000000000000000000000000000000e0 * t21 * t114 * t285 * t117 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t184 * (-0.1281046034962973764e3 * t186 * t285 - 0.455735532972871788e2 * t109 * t285 - 0.3602624572686e1 * t112 * t285))
  vsigma_2_ = t2 * t301
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3789

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  op_enhancement = lambda xs: pbe_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = t9 * r0
  t11 = 0.1e1 + t7
  t14 = t11 * r0 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t18 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t20 = t16 / t18
  t21 = 4 ** (0.1e1 / 0.3e1)
  t22 = t20 * t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t11 <= f.p.zeta_threshold
  t25 = 0.1e1 - t7
  t26 = t25 <= f.p.zeta_threshold
  t27 = f.my_piecewise5(t24, t5, t26, t6, t7)
  t28 = 0.1e1 + t27
  t29 = t28 * r0
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / t30
  t33 = 6 ** (0.1e1 / 0.3e1)
  t34 = jnp.pi ** 2
  t35 = t34 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t33 * t37
  t39 = t23 ** 2
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t45 = 0.1e1 / t43 / t41
  t49 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t38 * s0 * t39 * t45
  t52 = 0.18040e1 - 0.64641600e0 / t49
  t53 = 0.1e1 / t52
  t57 = f.my_piecewise3(t14, 0, t22 * t23 * t31 * t53 / 0.9e1)
  t61 = t25 * r0 / 0.2e1 <= f.p.dens_threshold
  t62 = f.my_piecewise5(t26, t5, t24, t6, -t7)
  t63 = 0.1e1 + t62
  t64 = t63 * r0
  t65 = t64 ** (0.1e1 / 0.3e1)
  t66 = 0.1e1 / t65
  t71 = f.my_piecewise3(t61, 0, t22 * t23 * t66 * t53 / 0.9e1)
  t72 = t57 + t71
  t73 = t72 == 0.0e0
  t74 = f.my_piecewise3(t73, DBL_EPSILON, t72)
  t77 = 0.361925846e1 / t74 + 0.5764e0
  t78 = t74 ** 2
  t79 = t78 ** 2
  t80 = 0.1e1 / t79
  t83 = 0.1e1 / t78 / t74
  t85 = 0.1e1 / t78
  t87 = 0.320261508740743441e2 * t80 + 0.151911844324290596e2 * t83 + 0.1801312286343e1 * t85
  t88 = 0.1e1 / t87
  t92 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t10 * t77 * t88)
  t103 = t21 * t31
  t104 = t52 ** 2
  t105 = 0.1e1 / t104
  t108 = t49 ** 2
  t109 = 0.1e1 / t108
  t116 = t109 * t33 * t37 * s0 / t43 / t41 / r0
  t120 = f.my_piecewise3(t14, 0, -t22 * t23 / t30 / t29 * t53 * t28 / 0.27e2 + 0.35036540897419280423111111111111111111111111111111e-2 * t20 * t103 * t105 * t116)
  t128 = t21 * t66
  t134 = f.my_piecewise3(t61, 0, -t22 * t23 / t65 / t64 * t53 * t63 / 0.27e2 + 0.35036540897419280423111111111111111111111111111111e-2 * t20 * t128 * t105 * t116)
  t136 = f.my_piecewise3(t73, 0, t120 + t134)
  t141 = t87 ** 2
  t143 = t77 / t141
  t145 = 0.1e1 / t79 / t74
  t157 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t9 * t77 * t88 + 0.90481461500000000000000000000000000000000000000000e0 * t10 * t85 * t136 * t88 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t143 * (-0.1281046034962973764e3 * t145 * t136 - 0.455735532972871788e2 * t80 * t136 - 0.3602624572686e1 * t83 * t136))
  vrho_0_ = r0 * t157 + t92
  t162 = t105 * t109 * t38 * t45
  t165 = f.my_piecewise3(t14, 0, -0.13138702836532230158666666666666666666666666666667e-2 * t20 * t103 * t162)
  t169 = f.my_piecewise3(t61, 0, -0.13138702836532230158666666666666666666666666666667e-2 * t20 * t128 * t162)
  t171 = f.my_piecewise3(t73, 0, t165 + t169)
  t187 = f.my_piecewise3(t4, 0, 0.90481461500000000000000000000000000000000000000000e0 * t10 * t85 * t171 * t88 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t143 * (-0.1281046034962973764e3 * t145 * t171 - 0.455735532972871788e2 * t80 * t171 - 0.3602624572686e1 * t83 * t171))
  vsigma_0_ = r0 * t187
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = t22 ** 2
  t40 = r0 ** 2
  t41 = r0 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t44 = 0.1e1 / t42 / t40
  t48 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t37 * s0 * t38 * t44
  t51 = 0.18040e1 - 0.64641600e0 / t48
  t52 = 0.1e1 / t51
  t56 = f.my_piecewise3(t13, 0, t21 * t22 * t30 * t52 / 0.9e1)
  t60 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t61 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t62 = 0.1e1 + t61
  t63 = t62 * r0
  t64 = t63 ** (0.1e1 / 0.3e1)
  t65 = 0.1e1 / t64
  t70 = f.my_piecewise3(t60, 0, t21 * t22 * t65 * t52 / 0.9e1)
  t71 = t56 + t70
  t72 = t71 == 0.0e0
  t73 = f.my_piecewise3(t72, DBL_EPSILON, t71)
  t76 = 0.361925846e1 / t73 + 0.5764e0
  t77 = t9 * t76
  t78 = t73 ** 2
  t79 = t78 ** 2
  t80 = 0.1e1 / t79
  t83 = 0.1e1 / t78 / t73
  t85 = 0.1e1 / t78
  t87 = 0.320261508740743441e2 * t80 + 0.151911844324290596e2 * t83 + 0.1801312286343e1 * t85
  t88 = 0.1e1 / t87
  t91 = t9 * r0
  t93 = 0.1e1 / t29 / t28
  t99 = t20 * t30
  t100 = t51 ** 2
  t101 = 0.1e1 / t100
  t103 = t19 * t99 * t101
  t104 = t48 ** 2
  t105 = 0.1e1 / t104
  t106 = t105 * t32
  t107 = t36 * s0
  t108 = t40 * r0
  t110 = 0.1e1 / t42 / t108
  t111 = t107 * t110
  t112 = t106 * t111
  t116 = f.my_piecewise3(t13, 0, -t21 * t22 * t93 * t52 * t27 / 0.27e2 + 0.35036540897419280423111111111111111111111111111113e-2 * t103 * t112)
  t118 = 0.1e1 / t64 / t63
  t124 = t20 * t65
  t126 = t19 * t124 * t101
  t130 = f.my_piecewise3(t60, 0, -t21 * t22 * t118 * t52 * t62 / 0.27e2 + 0.35036540897419280423111111111111111111111111111113e-2 * t126 * t112)
  t132 = f.my_piecewise3(t72, 0, t116 + t130)
  t137 = t87 ** 2
  t138 = 0.1e1 / t137
  t139 = t76 * t138
  t141 = 0.1e1 / t79 / t73
  t148 = -0.1281046034962973764e3 * t141 * t132 - 0.455735532972871788e2 * t80 * t132 - 0.3602624572686e1 * t83 * t132
  t153 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t77 * t88 + 0.90481461500000000000000000000000000000000000000000e0 * t91 * t85 * t132 * t88 + 0.25000000000000000000000000000000000000000000000000e0 * t91 * t139 * t148)
  t155 = t9 * t85
  t162 = t132 ** 2
  t167 = t27 ** 2
  t178 = t19 * t20 * t93 * t101
  t185 = 0.1e1 / t100 / t51
  t187 = t19 * t99 * t185
  t188 = t104 ** 2
  t190 = t32 ** 2
  t191 = 0.1e1 / t188 * t190
  t193 = 0.1e1 / t34 / t33
  t194 = t191 * t193
  t195 = s0 ** 2
  t196 = t40 ** 2
  t201 = t195 / t41 / t196 / t108 * t38
  t202 = t194 * t201
  t207 = 0.1e1 / t104 / t48 * t190
  t208 = t207 * t193
  t209 = t208 * t201
  t215 = t106 * t107 / t42 / t196
  t219 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 / t29 / t40 * t52 - 0.23357693931612853615407407407407407407407407407408e-2 * t178 * t27 * t105 * t32 * t111 + 0.11048032782508804523932172516210838091207111111112e-3 * t187 * t202 + 0.17091211824133073011701709914684720197530864197533e-3 * t103 * t209 - 0.12846731662387069488474074074074074074074074074075e-1 * t103 * t215)
  t220 = t62 ** 2
  t231 = t19 * t20 * t118 * t101
  t238 = t19 * t124 * t185
  t246 = f.my_piecewise3(t60, 0, 0.4e1 / 0.81e2 * t21 * t22 / t64 / t40 * t52 - 0.23357693931612853615407407407407407407407407407408e-2 * t231 * t62 * t105 * t32 * t111 + 0.11048032782508804523932172516210838091207111111112e-3 * t238 * t202 + 0.17091211824133073011701709914684720197530864197533e-3 * t126 * t209 - 0.12846731662387069488474074074074074074074074074075e-1 * t126 * t215)
  t248 = f.my_piecewise3(t72, 0, t219 + t246)
  t253 = t91 * t85
  t254 = t132 * t138
  t259 = 0.1e1 / t137 / t87
  t260 = t76 * t259
  t261 = t148 ** 2
  t266 = 0.1e1 / t79 / t78
  t284 = f.my_piecewise3(t4, 0, 0.18096292300000000000000000000000000000000000000000e1 * t155 * t132 * t88 + 0.50000000000000000000000000000000000000000000000000e0 * t77 * t138 * t148 - 0.18096292300000000000000000000000000000000000000000e1 * t91 * t83 * t162 * t88 + 0.90481461500000000000000000000000000000000000000000e0 * t91 * t85 * t248 * t88 - 0.18096292300000000000000000000000000000000000000000e1 * t253 * t254 * t148 - 0.50000000000000000000000000000000000000000000000000e0 * t91 * t260 * t261 + 0.25000000000000000000000000000000000000000000000000e0 * t91 * t139 * (0.6405230174814868820e3 * t266 * t162 - 0.1281046034962973764e3 * t141 * t248 + 0.1822942131891487152e3 * t141 * t162 - 0.455735532972871788e2 * t80 * t248 + 0.10807873718058e2 * t80 * t162 - 0.3602624572686e1 * t83 * t248))
  v2rho2_0_ = r0 * t284 + 0.2e1 * t153
  t286 = t19 * t99
  t287 = t101 * t105
  t289 = t287 * t37 * t44
  t292 = f.my_piecewise3(t13, 0, -0.13138702836532230158666666666666666666666666666667e-2 * t286 * t289)
  t293 = t19 * t124
  t296 = f.my_piecewise3(t60, 0, -0.13138702836532230158666666666666666666666666666667e-2 * t293 * t289)
  t298 = f.my_piecewise3(t72, 0, t292 + t296)
  t303 = t141 * t298
  t305 = t80 * t298
  t309 = -0.1281046034962973764e3 * t303 - 0.455735532972871788e2 * t305 - 0.3602624572686e1 * t83 * t298
  t314 = f.my_piecewise3(t4, 0, 0.90481461500000000000000000000000000000000000000000e0 * t91 * t85 * t298 * t88 + 0.25000000000000000000000000000000000000000000000000e0 * t91 * t139 * t309)
  t315 = t298 * t88
  t322 = t36 * t44
  t331 = 0.1e1 / t41 / t196 / t40 * s0 * t38
  t332 = t194 * t331
  t335 = t208 * t331
  t339 = t287 * t37 * t110
  t343 = f.my_piecewise3(t13, 0, 0.43795676121774100528888888888888888888888888888890e-3 * t178 * t106 * t322 * t27 - 0.41430122934408016964745646935790642842026666666670e-4 * t187 * t332 - 0.64092044340499023793881412180067700740740740740745e-4 * t103 * t335 + 0.35036540897419280423111111111111111111111111111112e-2 * t286 * t339)
  t355 = f.my_piecewise3(t60, 0, 0.43795676121774100528888888888888888888888888888890e-3 * t231 * t106 * t322 * t62 - 0.41430122934408016964745646935790642842026666666670e-4 * t238 * t332 - 0.64092044340499023793881412180067700740740740740745e-4 * t126 * t335 + 0.35036540897419280423111111111111111111111111111112e-2 * t293 * t339)
  t357 = f.my_piecewise3(t72, 0, t343 + t355)
  t362 = t298 * t138
  t395 = f.my_piecewise3(t4, 0, 0.90481461500000000000000000000000000000000000000000e0 * t155 * t315 - 0.18096292300000000000000000000000000000000000000000e1 * t91 * t83 * t315 * t132 + 0.90481461500000000000000000000000000000000000000000e0 * t91 * t85 * t357 * t88 - 0.90481461500000000000000000000000000000000000000000e0 * t253 * t362 * t148 + 0.25000000000000000000000000000000000000000000000000e0 * t77 * t138 * t309 - 0.90481461500000000000000000000000000000000000000000e0 * t253 * t254 * t309 - 0.50000000000000000000000000000000000000000000000000e0 * t91 * t76 * t259 * t309 * t148 + 0.25000000000000000000000000000000000000000000000000e0 * t91 * t139 * (0.6405230174814868820e3 * t266 * t298 * t132 - 0.1281046034962973764e3 * t141 * t357 + 0.1822942131891487152e3 * t303 * t132 - 0.455735532972871788e2 * t80 * t357 + 0.10807873718058e2 * t305 * t132 - 0.3602624572686e1 * t83 * t357))
  v2rhosigma_0_ = r0 * t395 + t314
  t397 = t298 ** 2
  t406 = t193 / t41 / t196 / r0 * t38
  t407 = t191 * t406
  t410 = t207 * t406
  t414 = f.my_piecewise3(t13, 0, 0.15536296100403006361779617600921491065760000000000e-4 * t187 * t407 + 0.24034516627687133922705529567525387777777777777779e-4 * t103 * t410)
  t420 = f.my_piecewise3(t60, 0, 0.15536296100403006361779617600921491065760000000000e-4 * t238 * t407 + 0.24034516627687133922705529567525387777777777777779e-4 * t126 * t410)
  t422 = f.my_piecewise3(t72, 0, t414 + t420)
  t430 = t309 ** 2
  t451 = f.my_piecewise3(t4, 0, -0.18096292300000000000000000000000000000000000000000e1 * t91 * t83 * t397 * t88 + 0.90481461500000000000000000000000000000000000000000e0 * t91 * t85 * t422 * t88 - 0.18096292300000000000000000000000000000000000000000e1 * t253 * t362 * t309 - 0.50000000000000000000000000000000000000000000000000e0 * t91 * t260 * t430 + 0.25000000000000000000000000000000000000000000000000e0 * t91 * t139 * (0.6405230174814868820e3 * t266 * t397 - 0.1281046034962973764e3 * t141 * t422 + 0.1822942131891487152e3 * t141 * t397 - 0.455735532972871788e2 * t80 * t422 + 0.10807873718058e2 * t80 * t397 - 0.3602624572686e1 * t83 * t422))
  v2sigma2_0_ = r0 * t451
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t38 = t22 ** 2
  t40 = r0 ** 2
  t41 = r0 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t48 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t32 * t36 * s0 * t38 / t42 / t40
  t51 = 0.18040e1 - 0.64641600e0 / t48
  t52 = 0.1e1 / t51
  t56 = f.my_piecewise3(t13, 0, t21 * t22 * t30 * t52 / 0.9e1)
  t60 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t61 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t62 = 0.1e1 + t61
  t63 = t62 * r0
  t64 = t63 ** (0.1e1 / 0.3e1)
  t65 = 0.1e1 / t64
  t70 = f.my_piecewise3(t60, 0, t21 * t22 * t65 * t52 / 0.9e1)
  t71 = t56 + t70
  t72 = t71 == 0.0e0
  t73 = f.my_piecewise3(t72, DBL_EPSILON, t71)
  t74 = t73 ** 2
  t75 = 0.1e1 / t74
  t76 = t9 * t75
  t78 = 0.1e1 / t29 / t28
  t84 = t20 * t30
  t85 = t51 ** 2
  t86 = 0.1e1 / t85
  t88 = t19 * t84 * t86
  t89 = t48 ** 2
  t90 = 0.1e1 / t89
  t91 = t90 * t32
  t92 = t36 * s0
  t93 = t40 * r0
  t96 = t92 / t42 / t93
  t97 = t91 * t96
  t101 = f.my_piecewise3(t13, 0, -t21 * t22 * t78 * t52 * t27 / 0.27e2 + 0.35036540897419280423111111111111111111111111111113e-2 * t88 * t97)
  t103 = 0.1e1 / t64 / t63
  t109 = t20 * t65
  t111 = t19 * t109 * t86
  t115 = f.my_piecewise3(t60, 0, -t21 * t22 * t103 * t52 * t62 / 0.27e2 + 0.35036540897419280423111111111111111111111111111113e-2 * t111 * t97)
  t117 = f.my_piecewise3(t72, 0, t101 + t115)
  t118 = t74 ** 2
  t119 = 0.1e1 / t118
  t121 = t74 * t73
  t122 = 0.1e1 / t121
  t125 = 0.320261508740743441e2 * t119 + 0.151911844324290596e2 * t122 + 0.1801312286343e1 * t75
  t126 = 0.1e1 / t125
  t127 = t117 * t126
  t132 = 0.361925846e1 / t73 + 0.5764e0
  t133 = t9 * t132
  t134 = t125 ** 2
  t135 = 0.1e1 / t134
  t137 = 0.1e1 / t118 / t73
  t138 = t137 * t117
  t140 = t119 * t117
  t144 = -0.1281046034962973764e3 * t138 - 0.455735532972871788e2 * t140 - 0.3602624572686e1 * t122 * t117
  t148 = t9 * r0
  t149 = t117 ** 2
  t154 = t27 ** 2
  t157 = 0.1e1 / t29 / t154 / t40
  t165 = t19 * t20 * t78 * t86
  t167 = t27 * t90 * t32
  t172 = 0.1e1 / t85 / t51
  t174 = t19 * t84 * t172
  t175 = t89 ** 2
  t176 = 0.1e1 / t175
  t177 = t32 ** 2
  t180 = 0.1e1 / t34 / t33
  t181 = t176 * t177 * t180
  t182 = s0 ** 2
  t183 = t40 ** 2
  t188 = t182 / t41 / t183 / t93 * t38
  t189 = t181 * t188
  t195 = 0.1e1 / t89 / t48 * t177 * t180
  t196 = t195 * t188
  t201 = t92 / t42 / t183
  t202 = t91 * t201
  t206 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 * t157 * t52 * t154 - 0.23357693931612853615407407407407407407407407407408e-2 * t165 * t167 * t96 + 0.11048032782508804523932172516210838091207111111112e-3 * t174 * t189 + 0.17091211824133073011701709914684720197530864197533e-3 * t88 * t196 - 0.12846731662387069488474074074074074074074074074075e-1 * t88 * t202)
  t207 = t62 ** 2
  t210 = 0.1e1 / t64 / t207 / t40
  t218 = t19 * t20 * t103 * t86
  t220 = t62 * t90 * t32
  t225 = t19 * t109 * t172
  t233 = f.my_piecewise3(t60, 0, 0.4e1 / 0.81e2 * t21 * t22 * t210 * t52 * t207 - 0.23357693931612853615407407407407407407407407407408e-2 * t218 * t220 * t96 + 0.11048032782508804523932172516210838091207111111112e-3 * t225 * t189 + 0.17091211824133073011701709914684720197530864197533e-3 * t111 * t196 - 0.12846731662387069488474074074074074074074074074075e-1 * t111 * t202)
  t235 = f.my_piecewise3(t72, 0, t206 + t233)
  t240 = t148 * t75
  t241 = t117 * t135
  t242 = t241 * t144
  t246 = 0.1e1 / t134 / t125
  t248 = t144 ** 2
  t252 = t132 * t135
  t254 = 0.1e1 / t118 / t74
  t267 = 0.6405230174814868820e3 * t254 * t149 - 0.1281046034962973764e3 * t137 * t235 + 0.1822942131891487152e3 * t137 * t149 - 0.455735532972871788e2 * t119 * t235 + 0.10807873718058e2 * t119 * t149 - 0.3602624572686e1 * t122 * t235
  t272 = f.my_piecewise3(t4, 0, 0.18096292300000000000000000000000000000000000000000e1 * t76 * t127 + 0.50000000000000000000000000000000000000000000000000e0 * t133 * t135 * t144 - 0.18096292300000000000000000000000000000000000000000e1 * t148 * t122 * t149 * t126 + 0.90481461500000000000000000000000000000000000000000e0 * t148 * t75 * t235 * t126 - 0.18096292300000000000000000000000000000000000000000e1 * t240 * t242 - 0.50000000000000000000000000000000000000000000000000e0 * t148 * t132 * t246 * t248 + 0.25000000000000000000000000000000000000000000000000e0 * t148 * t252 * t267)
  t288 = t134 ** 2
  t298 = t148 * t122
  t307 = t149 * t117
  t315 = t154 * t27
  t345 = t85 ** 2
  t346 = 0.1e1 / t345
  t351 = t33 ** 2
  t352 = 0.1e1 / t351
  t355 = t183 ** 2
  t359 = t182 * s0 / t355 / t93 * t22
  t360 = 0.1e1 / t175 / t89 * t352 * t359
  t366 = 0.1e1 / t175 / t48 * t352 * t359
  t372 = t182 / t41 / t355 * t38
  t373 = t181 * t372
  t377 = t176 * t352 * t359
  t380 = t195 * t372
  t387 = t91 * t92 / t42 / t183 / r0
  t390 = -0.28e2 / 0.243e3 * t21 * t22 / t29 / t93 * t52 + 0.46715387863225707230814814814814814814814814814816e-2 * t19 * t20 * t157 * t86 * t154 * t90 * t32 * t96 - 0.11048032782508804523932172516210838091207111111112e-3 * t21 * t78 * t172 * t27 * t189 - 0.17091211824133073011701709914684720197530864197533e-3 * t21 * t78 * t86 * t27 * t196 + 0.12846731662387069488474074074074074074074074074075e-1 * t165 * t167 * t201 + 0.62707746092104582891637671051293599587477712598485e-4 * t19 * t84 * t346 * t360 + 0.19401668922831298387304049111189574387848602942528e-3 * t174 * t366 - 0.12152836060759684976325389767831921900327822222224e-2 * t174 * t373 + 0.15007107592348656582838334069074384288019327292741e-3 * t88 * t377 - 0.18800333006546380312871880906153192217283950617286e-2 * t88 * t380 + 0.59951414424472990946212345679012345679012345679017e-1 * t88 * t387
  t391 = f.my_piecewise3(t13, 0, t390)
  t392 = t207 * t62
  t436 = -0.28e2 / 0.243e3 * t21 * t22 / t64 / t93 * t52 + 0.46715387863225707230814814814814814814814814814816e-2 * t19 * t20 * t210 * t86 * t207 * t90 * t32 * t96 - 0.11048032782508804523932172516210838091207111111112e-3 * t21 * t103 * t172 * t62 * t189 - 0.17091211824133073011701709914684720197530864197533e-3 * t21 * t103 * t86 * t62 * t196 + 0.12846731662387069488474074074074074074074074074075e-1 * t218 * t220 * t201 + 0.62707746092104582891637671051293599587477712598485e-4 * t19 * t109 * t346 * t360 + 0.19401668922831298387304049111189574387848602942528e-3 * t225 * t366 - 0.12152836060759684976325389767831921900327822222224e-2 * t225 * t373 + 0.15007107592348656582838334069074384288019327292741e-3 * t111 * t377 - 0.18800333006546380312871880906153192217283950617286e-2 * t111 * t380 + 0.59951414424472990946212345679012345679012345679017e-1 * t111 * t387
  t437 = f.my_piecewise3(t60, 0, t436)
  t439 = f.my_piecewise3(t72, 0, t391 + t437)
  t479 = -0.54288876900000000000000000000000000000000000000000e1 * t9 * t122 * t149 * t126 - 0.54288876900000000000000000000000000000000000000000e1 * t76 * t242 - 0.15000000000000000000000000000000000000000000000000e1 * t133 * t246 * t248 - 0.15000000000000000000000000000000000000000000000000e1 * t148 * t132 * t246 * t144 * t267 + 0.15000000000000000000000000000000000000000000000000e1 * t148 * t132 / t288 * t248 * t144 - 0.27144438450000000000000000000000000000000000000000e1 * t240 * t241 * t267 + 0.54288876900000000000000000000000000000000000000000e1 * t298 * t149 * t135 * t144 - 0.27144438450000000000000000000000000000000000000000e1 * t240 * t235 * t135 * t144 + 0.54288876900000000000000000000000000000000000000000e1 * t148 * t119 * t307 * t126 - 0.54288876900000000000000000000000000000000000000000e1 * t298 * t127 * t235 + 0.90481461500000000000000000000000000000000000000000e0 * t148 * t75 * t439 * t126 + 0.25000000000000000000000000000000000000000000000000e0 * t148 * t252 * (-0.38431381048889212920e4 / t118 / t121 * t307 + 0.19215690524444606460e4 * t254 * t117 * t235 - 0.1281046034962973764e3 * t137 * t439 - 0.9114710659457435760e3 * t254 * t307 + 0.5468826395674461456e3 * t138 * t235 - 0.455735532972871788e2 * t119 * t439 - 0.43231494872232e2 * t137 * t307 + 0.32423621154174e2 * t140 * t235 - 0.3602624572686e1 * t122 * t439) + 0.27144438450000000000000000000000000000000000000000e1 * t76 * t235 * t126 + 0.75000000000000000000000000000000000000000000000000e0 * t133 * t135 * t267 + 0.54288876900000000000000000000000000000000000000000e1 * t240 * t117 * t246 * t248
  t480 = f.my_piecewise3(t4, 0, t479)
  v3rho3_0_ = r0 * t480 + 0.3e1 * t272

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t38 = t22 ** 2
  t40 = r0 ** 2
  t41 = r0 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t48 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t32 * t36 * s0 * t38 / t42 / t40
  t51 = 0.18040e1 - 0.64641600e0 / t48
  t52 = 0.1e1 / t51
  t56 = f.my_piecewise3(t13, 0, t21 * t22 * t30 * t52 / 0.9e1)
  t60 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t61 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t62 = 0.1e1 + t61
  t63 = t62 * r0
  t64 = t63 ** (0.1e1 / 0.3e1)
  t65 = 0.1e1 / t64
  t70 = f.my_piecewise3(t60, 0, t21 * t22 * t65 * t52 / 0.9e1)
  t71 = t56 + t70
  t72 = t71 == 0.0e0
  t73 = f.my_piecewise3(t72, DBL_EPSILON, t71)
  t74 = t73 ** 2
  t75 = t74 * t73
  t76 = 0.1e1 / t75
  t77 = t9 * t76
  t79 = 0.1e1 / t29 / t28
  t85 = t20 * t30
  t86 = t51 ** 2
  t87 = 0.1e1 / t86
  t89 = t19 * t85 * t87
  t90 = t48 ** 2
  t91 = 0.1e1 / t90
  t92 = t91 * t32
  t93 = t36 * s0
  t94 = t40 * r0
  t97 = t93 / t42 / t94
  t98 = t92 * t97
  t102 = f.my_piecewise3(t13, 0, -t21 * t22 * t79 * t52 * t27 / 0.27e2 + 0.35036540897419280423111111111111111111111111111113e-2 * t89 * t98)
  t104 = 0.1e1 / t64 / t63
  t110 = t20 * t65
  t112 = t19 * t110 * t87
  t116 = f.my_piecewise3(t60, 0, -t21 * t22 * t104 * t52 * t62 / 0.27e2 + 0.35036540897419280423111111111111111111111111111113e-2 * t112 * t98)
  t118 = f.my_piecewise3(t72, 0, t102 + t116)
  t119 = t118 ** 2
  t120 = t74 ** 2
  t121 = 0.1e1 / t120
  t124 = 0.1e1 / t74
  t126 = 0.320261508740743441e2 * t121 + 0.151911844324290596e2 * t76 + 0.1801312286343e1 * t124
  t127 = 0.1e1 / t126
  t128 = t119 * t127
  t131 = t9 * t124
  t132 = t126 ** 2
  t133 = 0.1e1 / t132
  t134 = t118 * t133
  t136 = 0.1e1 / t120 / t73
  t137 = t136 * t118
  t139 = t121 * t118
  t143 = -0.1281046034962973764e3 * t137 - 0.455735532972871788e2 * t139 - 0.3602624572686e1 * t76 * t118
  t149 = 0.361925846e1 / t73 + 0.5764e0
  t150 = t9 * t149
  t152 = 0.1e1 / t132 / t126
  t153 = t143 ** 2
  t157 = t9 * r0
  t158 = t157 * t149
  t159 = t152 * t143
  t161 = 0.1e1 / t120 / t74
  t162 = t161 * t119
  t164 = t27 ** 2
  t167 = 0.1e1 / t29 / t164 / t40
  t173 = t20 * t79
  t175 = t19 * t173 * t87
  t177 = t27 * t91 * t32
  t182 = 0.1e1 / t86 / t51
  t184 = t19 * t85 * t182
  t185 = t90 ** 2
  t186 = 0.1e1 / t185
  t187 = t32 ** 2
  t190 = 0.1e1 / t34 / t33
  t191 = t186 * t187 * t190
  t192 = s0 ** 2
  t193 = t40 ** 2
  t198 = t192 / t41 / t193 / t94 * t38
  t199 = t191 * t198
  t202 = t90 * t48
  t205 = 0.1e1 / t202 * t187 * t190
  t206 = t205 * t198
  t211 = t93 / t42 / t193
  t212 = t92 * t211
  t216 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 * t167 * t52 * t164 - 0.23357693931612853615407407407407407407407407407408e-2 * t175 * t177 * t97 + 0.11048032782508804523932172516210838091207111111112e-3 * t184 * t199 + 0.17091211824133073011701709914684720197530864197533e-3 * t89 * t206 - 0.12846731662387069488474074074074074074074074074075e-1 * t89 * t212)
  t217 = t62 ** 2
  t220 = 0.1e1 / t64 / t217 / t40
  t226 = t20 * t104
  t228 = t19 * t226 * t87
  t230 = t62 * t91 * t32
  t235 = t19 * t110 * t182
  t243 = f.my_piecewise3(t60, 0, 0.4e1 / 0.81e2 * t21 * t22 * t220 * t52 * t217 - 0.23357693931612853615407407407407407407407407407408e-2 * t228 * t230 * t97 + 0.11048032782508804523932172516210838091207111111112e-3 * t235 * t199 + 0.17091211824133073011701709914684720197530864197533e-3 * t112 * t206 - 0.12846731662387069488474074074074074074074074074075e-1 * t112 * t212)
  t245 = f.my_piecewise3(t72, 0, t216 + t243)
  t248 = t136 * t119
  t256 = 0.6405230174814868820e3 * t162 - 0.1281046034962973764e3 * t136 * t245 + 0.1822942131891487152e3 * t248 - 0.455735532972871788e2 * t121 * t245 + 0.10807873718058e2 * t121 * t119 - 0.3602624572686e1 * t76 * t245
  t257 = t159 * t256
  t260 = t132 ** 2
  t261 = 0.1e1 / t260
  t263 = t153 * t143
  t267 = t157 * t124
  t268 = t134 * t256
  t271 = t157 * t76
  t272 = t119 * t133
  t273 = t272 * t143
  t276 = t245 * t133
  t277 = t276 * t143
  t280 = t119 * t118
  t285 = t118 * t127
  t286 = t285 * t245
  t289 = t164 * t27
  t292 = 0.1e1 / t29 / t289 / t94
  t300 = t19 * t20 * t167 * t87
  t302 = t164 * t91 * t32
  t308 = t21 * t79 * t182 * t27
  t313 = t21 * t79 * t87 * t27
  t319 = t86 ** 2
  t320 = 0.1e1 / t319
  t322 = t19 * t85 * t320
  t324 = 0.1e1 / t185 / t90
  t325 = t33 ** 2
  t326 = 0.1e1 / t325
  t327 = t324 * t326
  t328 = t192 * s0
  t329 = t193 ** 2
  t333 = t328 / t329 / t94 * t22
  t334 = t327 * t333
  t338 = 0.1e1 / t185 / t48
  t339 = t338 * t326
  t340 = t339 * t333
  t346 = t192 / t41 / t329 * t38
  t347 = t191 * t346
  t350 = t186 * t326
  t351 = t350 * t333
  t354 = t205 * t346
  t360 = t93 / t42 / t193 / r0
  t361 = t92 * t360
  t364 = -0.28e2 / 0.243e3 * t21 * t22 * t292 * t52 * t289 + 0.46715387863225707230814814814814814814814814814816e-2 * t300 * t302 * t97 - 0.11048032782508804523932172516210838091207111111112e-3 * t308 * t199 - 0.17091211824133073011701709914684720197530864197533e-3 * t313 * t206 + 0.12846731662387069488474074074074074074074074074075e-1 * t175 * t177 * t211 + 0.62707746092104582891637671051293599587477712598485e-4 * t322 * t334 + 0.19401668922831298387304049111189574387848602942528e-3 * t184 * t340 - 0.12152836060759684976325389767831921900327822222224e-2 * t184 * t347 + 0.15007107592348656582838334069074384288019327292741e-3 * t89 * t351 - 0.18800333006546380312871880906153192217283950617286e-2 * t89 * t354 + 0.59951414424472990946212345679012345679012345679017e-1 * t89 * t361
  t365 = f.my_piecewise3(t13, 0, t364)
  t366 = t217 * t62
  t369 = 0.1e1 / t64 / t366 / t94
  t377 = t19 * t20 * t220 * t87
  t379 = t217 * t91 * t32
  t385 = t21 * t104 * t182 * t62
  t390 = t21 * t104 * t87 * t62
  t397 = t19 * t110 * t320
  t410 = -0.28e2 / 0.243e3 * t21 * t22 * t369 * t52 * t366 + 0.46715387863225707230814814814814814814814814814816e-2 * t377 * t379 * t97 - 0.11048032782508804523932172516210838091207111111112e-3 * t385 * t199 - 0.17091211824133073011701709914684720197530864197533e-3 * t390 * t206 + 0.12846731662387069488474074074074074074074074074075e-1 * t228 * t230 * t211 + 0.62707746092104582891637671051293599587477712598485e-4 * t397 * t334 + 0.19401668922831298387304049111189574387848602942528e-3 * t235 * t340 - 0.12152836060759684976325389767831921900327822222224e-2 * t235 * t347 + 0.15007107592348656582838334069074384288019327292741e-3 * t112 * t351 - 0.18800333006546380312871880906153192217283950617286e-2 * t112 * t354 + 0.59951414424472990946212345679012345679012345679017e-1 * t112 * t361
  t411 = f.my_piecewise3(t60, 0, t410)
  t413 = f.my_piecewise3(t72, 0, t365 + t411)
  t418 = t149 * t133
  t420 = 0.1e1 / t120 / t75
  t423 = t161 * t118
  t440 = -0.38431381048889212920e4 * t420 * t280 + 0.19215690524444606460e4 * t423 * t245 - 0.1281046034962973764e3 * t136 * t413 - 0.9114710659457435760e3 * t161 * t280 + 0.5468826395674461456e3 * t137 * t245 - 0.455735532972871788e2 * t121 * t413 - 0.43231494872232e2 * t136 * t280 + 0.32423621154174e2 * t139 * t245 - 0.3602624572686e1 * t76 * t413
  t450 = t118 * t152
  t451 = t450 * t153
  t454 = -0.54288876900000000000000000000000000000000000000000e1 * t77 * t128 - 0.54288876900000000000000000000000000000000000000000e1 * t131 * t134 * t143 - 0.15000000000000000000000000000000000000000000000000e1 * t150 * t152 * t153 - 0.15000000000000000000000000000000000000000000000000e1 * t158 * t257 + 0.15000000000000000000000000000000000000000000000000e1 * t157 * t149 * t261 * t263 - 0.27144438450000000000000000000000000000000000000000e1 * t267 * t268 + 0.54288876900000000000000000000000000000000000000000e1 * t271 * t273 - 0.27144438450000000000000000000000000000000000000000e1 * t267 * t277 + 0.54288876900000000000000000000000000000000000000000e1 * t157 * t121 * t280 * t127 - 0.54288876900000000000000000000000000000000000000000e1 * t271 * t286 + 0.90481461500000000000000000000000000000000000000000e0 * t157 * t124 * t413 * t127 + 0.25000000000000000000000000000000000000000000000000e0 * t157 * t418 * t440 + 0.27144438450000000000000000000000000000000000000000e1 * t131 * t245 * t127 + 0.75000000000000000000000000000000000000000000000000e0 * t150 * t133 * t256 + 0.54288876900000000000000000000000000000000000000000e1 * t267 * t451
  t455 = f.my_piecewise3(t4, 0, t454)
  t468 = t256 ** 2
  t472 = t245 ** 2
  t482 = t153 ** 2
  t486 = t119 ** 2
  t511 = 0.21715550760000000000000000000000000000000000000000e2 * t267 * t450 * t143 * t256 - 0.60000000000000000000000000000000000000000000000000e1 * t150 * t257 + 0.21715550760000000000000000000000000000000000000000e2 * t131 * t451 - 0.10857775380000000000000000000000000000000000000000e2 * t131 * t268 - 0.15000000000000000000000000000000000000000000000000e1 * t157 * t149 * t152 * t468 - 0.54288876900000000000000000000000000000000000000000e1 * t157 * t76 * t472 * t127 + 0.21715550760000000000000000000000000000000000000000e2 * t77 * t273 - 0.60000000000000000000000000000000000000000000000000e1 * t157 * t149 / t260 / t126 * t482 - 0.21715550760000000000000000000000000000000000000000e2 * t157 * t136 * t486 * t127 - 0.10857775380000000000000000000000000000000000000000e2 * t131 * t277 + 0.60000000000000000000000000000000000000000000000000e1 * t150 * t261 * t263 + 0.10857775380000000000000000000000000000000000000000e2 * t271 * t272 * t256 - 0.36192584600000000000000000000000000000000000000000e1 * t267 * t413 * t133 * t143 - 0.21715550760000000000000000000000000000000000000000e2 * t271 * t119 * t152 * t153 + 0.90000000000000000000000000000000000000000000000000e1 * t158 * t261 * t153 * t256
  t528 = t157 * t121
  t550 = t120 ** 2
  t577 = t164 ** 2
  t617 = t192 / t41 / t329 / r0 * t38
  t618 = t205 * t617
  t626 = t193 * t40
  t630 = t92 * t93 / t42 / t626
  t633 = t192 ** 2
  t639 = 0.1e1 / t42 / t329 / t626 * t32 * t36
  t640 = t327 * t633 * t639
  t646 = t328 / t329 / t193 * t22
  t647 = t350 * t646
  t651 = t339 * t633 * t639
  t654 = t327 * t646
  t658 = 0.1e1 / t319 / t51
  t661 = t185 ** 2
  t665 = 0.1e1 / t661 * t326 * t633 * t639
  t672 = 0.1e1 / t185 / t202 * t326 * t633 * t639
  t675 = t339 * t646
  t678 = t191 * t617
  t681 = 0.16203781414346246635100519690442562533770429629632e-2 * t308 * t347 + 0.25067110675395173750495841208204256289711934156381e-2 * t313 * t354 - 0.33972468173868028202853662551440329218106995884776e0 * t89 * t630 + 0.56786091002419870483410687045676970042463122352009e-4 * t184 * t640 - 0.33015636703167044482244334951963645433642520044029e-2 * t89 * t647 + 0.29282531683631939021419997362728733015304449122552e-4 * t89 * t651 - 0.13795704140263008236160287631284591909245096771667e-2 * t322 * t654 + 0.79094250379476225993521934536871339664523102584154e-5 * t19 * t85 * t658 * t665 + 0.36707437801420242998404402677318324266968841698296e-4 * t322 * t672 - 0.42683671630228856452068908044617063653266926473562e-2 * t184 * t675 + 0.12017804548973466254366218770411567212546401975310e-1 * t184 * t678
  t683 = f.my_piecewise3(t13, 0, -0.34257951099698851969264197530864197530864197530866e-1 * t300 * t302 * t211 + 0.29461420753356812063819126709895568243218962962966e-3 * t21 * t167 * t182 * t164 * t199 + 0.45576564864354861364537893105825920526748971193420e-3 * t21 * t167 * t87 * t164 * t206 - 0.79935219232630654594949794238683127572016460905356e-1 * t175 * t177 * t360 + 0.280e3 / 0.729e3 * t21 * t22 / t29 / t193 * t52 - 0.14533676224114664471809053497942386831275720164610e-1 * t19 * t20 * t292 * t87 * t289 * t91 * t32 * t97 - 0.83610328122806110522183561401724799449970283464647e-4 * t19 * t173 * t320 * t27 * t324 * t326 * t333 - 0.25868891897108397849738732148252765850464803923371e-3 * t19 * t173 * t182 * t27 * t338 * t326 * t333 - 0.20009476789798208777117778758765845717359103056988e-3 * t175 * t27 * t186 * t326 * t333 + 0.18591440417584753864951082229418156748203017832649e-1 * t89 * t618 + t681)
  t684 = t217 ** 2
  t763 = -0.33972468173868028202853662551440329218106995884776e0 * t112 * t630 - 0.13795704140263008236160287631284591909245096771667e-2 * t397 * t654 + 0.79094250379476225993521934536871339664523102584154e-5 * t19 * t110 * t658 * t665 + 0.36707437801420242998404402677318324266968841698296e-4 * t397 * t672 - 0.42683671630228856452068908044617063653266926473562e-2 * t235 * t675 + 0.56786091002419870483410687045676970042463122352009e-4 * t235 * t640 - 0.14533676224114664471809053497942386831275720164610e-1 * t19 * t20 * t369 * t87 * t366 * t91 * t32 * t97 - 0.83610328122806110522183561401724799449970283464647e-4 * t19 * t226 * t320 * t62 * t324 * t326 * t333 - 0.25868891897108397849738732148252765850464803923371e-3 * t19 * t226 * t182 * t62 * t338 * t326 * t333 - 0.20009476789798208777117778758765845717359103056988e-3 * t228 * t62 * t186 * t326 * t333 + 0.25067110675395173750495841208204256289711934156381e-2 * t390 * t354
  t765 = f.my_piecewise3(t60, 0, 0.280e3 / 0.729e3 * t21 * t22 / t64 / t193 * t52 + 0.18591440417584753864951082229418156748203017832649e-1 * t112 * t618 + 0.12017804548973466254366218770411567212546401975310e-1 * t235 * t678 - 0.79935219232630654594949794238683127572016460905356e-1 * t228 * t230 * t360 - 0.34257951099698851969264197530864197530864197530866e-1 * t377 * t379 * t211 + 0.29461420753356812063819126709895568243218962962966e-3 * t21 * t220 * t182 * t217 * t199 + 0.45576564864354861364537893105825920526748971193420e-3 * t21 * t220 * t87 * t217 * t206 + 0.16203781414346246635100519690442562533770429629632e-2 * t385 * t347 - 0.33015636703167044482244334951963645433642520044029e-2 * t112 * t647 + 0.29282531683631939021419997362728733015304449122552e-4 * t112 * t651 + t763)
  t767 = f.my_piecewise3(t72, 0, t683 + t765)
  t790 = 0.269019667342224490440e5 / t550 * t486 - 0.230588286293335277520e5 * t420 * t119 * t245 + 0.19215690524444606460e4 * t161 * t472 + 0.25620920699259475280e4 * t423 * t413 - 0.1281046034962973764e3 * t136 * t767 + 0.54688263956744614560e4 * t420 * t486 - 0.54688263956744614560e4 * t162 * t245 + 0.5468826395674461456e3 * t136 * t472 + 0.7291768527565948608e3 * t137 * t413 - 0.455735532972871788e2 * t121 * t767 + 0.216157474361160e3 * t161 * t486 - 0.259388969233392e3 * t248 * t245 + 0.32423621154174e2 * t121 * t472 + 0.43231494872232e2 * t139 * t413 - 0.3602624572686e1 * t76 * t767
  t804 = 0.10000000000000000000000000000000000000000000000000e1 * t150 * t133 * t440 + 0.36192584600000000000000000000000000000000000000000e1 * t131 * t413 * t127 + 0.21715550760000000000000000000000000000000000000000e2 * t9 * t121 * t280 * t127 - 0.20000000000000000000000000000000000000000000000000e1 * t158 * t159 * t440 - 0.54288876900000000000000000000000000000000000000000e1 * t267 * t276 * t256 + 0.32573326140000000000000000000000000000000000000000e2 * t528 * t128 * t245 - 0.72385169200000000000000000000000000000000000000000e1 * t271 * t285 * t413 + 0.10857775380000000000000000000000000000000000000000e2 * t267 * t245 * t152 * t153 - 0.36192584600000000000000000000000000000000000000000e1 * t267 * t134 * t440 - 0.21715550760000000000000000000000000000000000000000e2 * t528 * t280 * t133 * t143 - 0.21715550760000000000000000000000000000000000000000e2 * t267 * t118 * t261 * t263 + 0.25000000000000000000000000000000000000000000000000e0 * t157 * t418 * t790 - 0.21715550760000000000000000000000000000000000000000e2 * t77 * t286 + 0.90481461500000000000000000000000000000000000000000e0 * t157 * t124 * t767 * t127 + 0.21715550760000000000000000000000000000000000000000e2 * t271 * t134 * t143 * t245
  t806 = f.my_piecewise3(t4, 0, t511 + t804)
  v4rho4_0_ = r0 * t806 + 0.4e1 * t455

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t2 ** 2
  t20 = 0.1e1 / t19
  t21 = t1 * t20
  t22 = t3 - t21
  t23 = f.my_piecewise5(t13, 0, t16, 0, t22)
  t24 = t18 * t23
  t27 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t30 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t31 = f.my_piecewise5(t27, t14, t30, t17, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t37 / t39
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t14, t47, t17, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / t51
  t54 = 6 ** (0.1e1 / 0.3e1)
  t55 = jnp.pi ** 2
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t54 * t58
  t60 = r0 ** 2
  t61 = r0 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t68 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t59 * s0 / t62 / t60
  t71 = 0.18040e1 - 0.64641600e0 / t68
  t72 = 0.1e1 / t71
  t76 = f.my_piecewise3(t35, 0, t43 * t44 * t52 * t72 / 0.9e1)
  t80 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t81 = f.my_piecewise5(t47, t14, t45, t17, -t31)
  t82 = 0.1e1 + t81
  t83 = t82 * t2
  t84 = t83 ** (0.1e1 / 0.3e1)
  t85 = 0.1e1 / t84
  t87 = r1 ** 2
  t88 = r1 ** (0.1e1 / 0.3e1)
  t89 = t88 ** 2
  t95 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t59 * s2 / t89 / t87
  t98 = 0.18040e1 - 0.64641600e0 / t95
  t99 = 0.1e1 / t98
  t103 = f.my_piecewise3(t80, 0, t43 * t44 * t85 * t99 / 0.9e1)
  t104 = t76 + t103
  t105 = t104 == 0.0e0
  t106 = f.my_piecewise3(t105, DBL_EPSILON, t104)
  t109 = 0.361925846e1 / t106 + 0.5764e0
  t111 = t106 ** 2
  t112 = t111 ** 2
  t113 = 0.1e1 / t112
  t116 = 0.1e1 / t111 / t106
  t118 = 0.1e1 / t111
  t120 = 0.320261508740743441e2 * t113 + 0.151911844324290596e2 * t116 + 0.1801312286343e1 * t118
  t121 = 0.1e1 / t120
  t122 = t2 * t109 * t121
  t125 = t18 ** 2
  t126 = 0.1e1 - t125
  t127 = t126 * t109
  t129 = 0.25000000000000000000000000000000000000000000000000e0 * t127 * t121
  t130 = t126 * t2
  t133 = t44 / t51 / t50
  t134 = f.my_piecewise5(t27, 0, t30, 0, t22)
  t135 = f.my_piecewise5(t45, 0, t47, 0, t134)
  t137 = t135 * t2 + t48 + 0.1e1
  t142 = t42 * t44
  t144 = t41 * t142 * t52
  t145 = t71 ** 2
  t146 = 0.1e1 / t145
  t147 = t68 ** 2
  t148 = 0.1e1 / t147
  t150 = t146 * t148 * t54
  t151 = t58 * s0
  t152 = t60 * r0
  t155 = t151 / t62 / t152
  t160 = f.my_piecewise3(t35, 0, -t43 * t133 * t72 * t137 / 0.27e2 + 0.17518270448709640211555555555555555555555555555557e-2 * t144 * t150 * t155)
  t163 = t44 / t84 / t83
  t164 = f.my_piecewise5(t47, 0, t45, 0, -t134)
  t166 = t164 * t2 + t81 + 0.1e1
  t171 = f.my_piecewise3(t80, 0, -t43 * t163 * t99 * t166 / 0.27e2)
  t173 = f.my_piecewise3(t105, 0, t160 + t171)
  t175 = t118 * t173 * t121
  t178 = t120 ** 2
  t179 = 0.1e1 / t178
  t180 = t109 * t179
  t182 = 0.1e1 / t112 / t106
  t189 = -0.1281046034962973764e3 * t182 * t173 - 0.455735532972871788e2 * t113 * t173 - 0.3602624572686e1 * t116 * t173
  t190 = t180 * t189
  t194 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t24 * t122 - t129 + 0.90481461500000000000000000000000000000000000000000e0 * t130 * t175 + 0.25000000000000000000000000000000000000000000000000e0 * t130 * t190)
  t196 = t23 ** 2
  t198 = t109 * t121
  t203 = t1 / t19 / t2
  t205 = -0.2e1 * t20 + 0.2e1 * t203
  t206 = f.my_piecewise5(t13, 0, t16, 0, t205)
  t210 = t24 * t198
  t212 = t24 * t2
  t217 = t126 * t118
  t219 = t217 * t173 * t121
  t222 = t127 * t179 * t189
  t224 = t173 ** 2
  t229 = t49 ** 2
  t232 = 0.1e1 / t51 / t229 / t19
  t233 = t44 * t232
  t234 = t137 ** 2
  t240 = t43 * t133 * t146
  t246 = f.my_piecewise5(t27, 0, t30, 0, t205)
  t247 = f.my_piecewise5(t45, 0, t47, 0, t246)
  t257 = t147 ** 2
  t260 = t54 ** 2
  t263 = 0.1e1 / t56 / t55
  t264 = s0 ** 2
  t266 = t60 ** 2
  t270 = t263 * t264 / t61 / t266 / t152
  t288 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t233 * t72 * t234 - 0.11678846965806426807703703703703703703703703703704e-2 * t240 * t137 * t148 * t54 * t155 - t43 * t133 * t72 * (t247 * t2 + 0.2e1 * t135) / 0.27e2 + 0.55240163912544022619660862581054190456035555555564e-4 * t144 / t145 / t71 / t257 * t260 * t270 + 0.85456059120665365058508549573423600987654320987665e-4 * t144 * t146 / t147 / t68 * t260 * t270 - 0.64233658311935347442370370370370370370370370370376e-2 * t144 * t150 * t151 / t62 / t266)
  t289 = t82 ** 2
  t292 = 0.1e1 / t84 / t289 / t19
  t293 = t44 * t292
  t294 = t166 ** 2
  t299 = f.my_piecewise5(t47, 0, t45, 0, -t246)
  t308 = f.my_piecewise3(t80, 0, 0.4e1 / 0.81e2 * t43 * t293 * t99 * t294 - t43 * t163 * t99 * (t299 * t2 + 0.2e1 * t164) / 0.27e2)
  t310 = f.my_piecewise3(t105, 0, t288 + t308)
  t315 = t130 * t118
  t316 = t173 * t179
  t321 = 0.1e1 / t178 / t120
  t322 = t109 * t321
  t323 = t189 ** 2
  t328 = 0.1e1 / t112 / t111
  t345 = 0.50000000000000000000000000000000000000000000000000e0 * t196 * t2 * t198 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t206 * t122 + 0.10000000000000000000000000000000000000000000000000e1 * t210 - 0.36192584600000000000000000000000000000000000000000e1 * t212 * t175 - 0.10000000000000000000000000000000000000000000000000e1 * t212 * t190 + 0.18096292300000000000000000000000000000000000000000e1 * t219 + 0.50000000000000000000000000000000000000000000000000e0 * t222 - 0.18096292300000000000000000000000000000000000000000e1 * t130 * t116 * t224 * t121 + 0.90481461500000000000000000000000000000000000000000e0 * t130 * t118 * t310 * t121 - 0.18096292300000000000000000000000000000000000000000e1 * t315 * t316 * t189 - 0.50000000000000000000000000000000000000000000000000e0 * t130 * t322 * t323 + 0.25000000000000000000000000000000000000000000000000e0 * t130 * t180 * (0.6405230174814868820e3 * t328 * t224 - 0.1281046034962973764e3 * t182 * t310 + 0.1822942131891487152e3 * t182 * t224 - 0.455735532972871788e2 * t113 * t310 + 0.10807873718058e2 * t113 * t224 - 0.3602624572686e1 * t116 * t310)
  t346 = f.my_piecewise3(t11, 0, t345)
  d11 = t2 * t346 + 0.2e1 * t194
  t348 = -t3 - t21
  t349 = f.my_piecewise5(t13, 0, t16, 0, t348)
  t350 = t18 * t349
  t353 = f.my_piecewise5(t27, 0, t30, 0, t348)
  t354 = f.my_piecewise5(t45, 0, t47, 0, t353)
  t356 = t354 * t2 + t48 + 0.1e1
  t361 = f.my_piecewise3(t35, 0, -t43 * t133 * t72 * t356 / 0.27e2)
  t362 = f.my_piecewise5(t47, 0, t45, 0, -t353)
  t364 = t362 * t2 + t81 + 0.1e1
  t370 = t41 * t142 * t85
  t371 = t98 ** 2
  t372 = 0.1e1 / t371
  t373 = t95 ** 2
  t374 = 0.1e1 / t373
  t376 = t372 * t374 * t54
  t377 = t58 * s2
  t378 = t87 * r1
  t380 = 0.1e1 / t89 / t378
  t381 = t377 * t380
  t386 = f.my_piecewise3(t80, 0, -t43 * t163 * t99 * t364 / 0.27e2 + 0.17518270448709640211555555555555555555555555555557e-2 * t370 * t376 * t381)
  t388 = f.my_piecewise3(t105, 0, t361 + t386)
  t390 = t118 * t388 * t121
  t393 = t182 * t388
  t395 = t113 * t388
  t399 = -0.1281046034962973764e3 * t393 - 0.455735532972871788e2 * t395 - 0.3602624572686e1 * t116 * t388
  t400 = t180 * t399
  t404 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t350 * t122 - t129 + 0.90481461500000000000000000000000000000000000000000e0 * t130 * t390 + 0.25000000000000000000000000000000000000000000000000e0 * t130 * t400)
  t408 = 0.2e1 * t203
  t409 = f.my_piecewise5(t13, 0, t16, 0, t408)
  t413 = t350 * t198
  t415 = t350 * t2
  t425 = t388 * t121
  t426 = t217 * t425
  t432 = t41 * t142
  t443 = f.my_piecewise5(t27, 0, t30, 0, t408)
  t444 = f.my_piecewise5(t45, 0, t47, 0, t443)
  t452 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t432 * t232 * t72 * t356 * t137 - 0.58394234829032134038518518518518518518518518518522e-3 * t240 * t356 * t148 * t54 * t155 - t43 * t133 * t72 * (t444 * t2 + t135 + t354) / 0.27e2)
  t458 = f.my_piecewise5(t47, 0, t45, 0, -t443)
  t466 = t43 * t163 * t372
  t475 = f.my_piecewise3(t80, 0, 0.4e1 / 0.81e2 * t432 * t292 * t99 * t364 * t166 - t43 * t163 * t99 * (t458 * t2 + t164 + t362) / 0.27e2 - 0.58394234829032134038518518518518518518518518518523e-3 * t466 * t374 * t54 * t58 * s2 * t380 * t166)
  t477 = f.my_piecewise3(t105, 0, t452 + t475)
  t482 = t388 * t179
  t489 = t127 * t179 * t399
  t516 = 0.50000000000000000000000000000000000000000000000000e0 * t23 * t349 * t122 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t409 * t122 + 0.50000000000000000000000000000000000000000000000000e0 * t413 - 0.18096292300000000000000000000000000000000000000000e1 * t415 * t175 - 0.50000000000000000000000000000000000000000000000000e0 * t415 * t190 + 0.50000000000000000000000000000000000000000000000000e0 * t210 + 0.90481461500000000000000000000000000000000000000000e0 * t219 + 0.25000000000000000000000000000000000000000000000000e0 * t222 - 0.18096292300000000000000000000000000000000000000000e1 * t212 * t390 + 0.90481461500000000000000000000000000000000000000000e0 * t426 - 0.18096292300000000000000000000000000000000000000000e1 * t130 * t116 * t425 * t173 + 0.90481461500000000000000000000000000000000000000000e0 * t130 * t118 * t477 * t121 - 0.90481461500000000000000000000000000000000000000000e0 * t315 * t482 * t189 - 0.50000000000000000000000000000000000000000000000000e0 * t212 * t400 + 0.25000000000000000000000000000000000000000000000000e0 * t489 - 0.90481461500000000000000000000000000000000000000000e0 * t315 * t316 * t399 - 0.50000000000000000000000000000000000000000000000000e0 * t130 * t109 * t321 * t399 * t189 + 0.25000000000000000000000000000000000000000000000000e0 * t130 * t180 * (0.6405230174814868820e3 * t328 * t388 * t173 - 0.1281046034962973764e3 * t182 * t477 + 0.1822942131891487152e3 * t393 * t173 - 0.455735532972871788e2 * t113 * t477 + 0.10807873718058e2 * t395 * t173 - 0.3602624572686e1 * t116 * t477)
  t517 = f.my_piecewise3(t11, 0, t516)
  d12 = t2 * t517 + t194 + t404
  t520 = t349 ** 2
  t525 = 0.2e1 * t20 + 0.2e1 * t203
  t526 = f.my_piecewise5(t13, 0, t16, 0, t525)
  t537 = t388 ** 2
  t542 = t356 ** 2
  t547 = f.my_piecewise5(t27, 0, t30, 0, t525)
  t548 = f.my_piecewise5(t45, 0, t47, 0, t547)
  t557 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t233 * t72 * t542 - t43 * t133 * t72 * (t548 * t2 + 0.2e1 * t354) / 0.27e2)
  t558 = t364 ** 2
  t568 = f.my_piecewise5(t47, 0, t45, 0, -t547)
  t578 = t373 ** 2
  t582 = s2 ** 2
  t584 = t87 ** 2
  t588 = t263 * t582 / t88 / t584 / t378
  t606 = f.my_piecewise3(t80, 0, 0.4e1 / 0.81e2 * t43 * t293 * t99 * t558 - 0.11678846965806426807703703703703703703703703703704e-2 * t466 * t364 * t374 * t54 * t381 - t43 * t163 * t99 * (t568 * t2 + 0.2e1 * t362) / 0.27e2 + 0.55240163912544022619660862581054190456035555555564e-4 * t370 / t371 / t98 / t578 * t260 * t588 + 0.85456059120665365058508549573423600987654320987665e-4 * t370 * t372 / t373 / t95 * t260 * t588 - 0.64233658311935347442370370370370370370370370370376e-2 * t370 * t376 * t377 / t89 / t584)
  t608 = f.my_piecewise3(t105, 0, t557 + t606)
  t616 = t399 ** 2
  t636 = 0.50000000000000000000000000000000000000000000000000e0 * t520 * t2 * t198 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t526 * t122 + 0.10000000000000000000000000000000000000000000000000e1 * t413 - 0.36192584600000000000000000000000000000000000000000e1 * t415 * t390 - 0.10000000000000000000000000000000000000000000000000e1 * t415 * t400 + 0.18096292300000000000000000000000000000000000000000e1 * t426 + 0.50000000000000000000000000000000000000000000000000e0 * t489 - 0.18096292300000000000000000000000000000000000000000e1 * t130 * t116 * t537 * t121 + 0.90481461500000000000000000000000000000000000000000e0 * t130 * t118 * t608 * t121 - 0.18096292300000000000000000000000000000000000000000e1 * t315 * t482 * t399 - 0.50000000000000000000000000000000000000000000000000e0 * t130 * t322 * t616 + 0.25000000000000000000000000000000000000000000000000e0 * t130 * t180 * (0.6405230174814868820e3 * t328 * t537 - 0.1281046034962973764e3 * t182 * t608 + 0.1822942131891487152e3 * t182 * t537 - 0.455735532972871788e2 * t113 * t608 + 0.10807873718058e2 * t113 * t537 - 0.3602624572686e1 * t116 * t608)
  t637 = f.my_piecewise3(t11, 0, t636)
  d22 = t2 * t637 + 0.2e1 * t404
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t15 = 0.1e1 - t4 <= f.p.zeta_threshold
  t16 = t2 ** 2
  t17 = 0.1e1 / t16
  t19 = -t1 * t17 + t3
  t20 = f.my_piecewise5(t13, 0, t15, 0, t19)
  t21 = t20 ** 2
  t22 = t21 * t2
  t25 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t26 = f.p.zeta_threshold - 0.1e1
  t29 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t30 = -t26
  t31 = f.my_piecewise5(t25, t26, t29, t30, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t37 / t39
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t26, t47, t30, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / t51
  t54 = 6 ** (0.1e1 / 0.3e1)
  t55 = jnp.pi ** 2
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t54 * t58
  t60 = r0 ** 2
  t61 = r0 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t68 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t59 * s0 / t62 / t60
  t71 = 0.18040e1 - 0.64641600e0 / t68
  t72 = 0.1e1 / t71
  t76 = f.my_piecewise3(t35, 0, t43 * t44 * t52 * t72 / 0.9e1)
  t80 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t81 = f.my_piecewise5(t47, t26, t45, t30, -t31)
  t82 = 0.1e1 + t81
  t83 = t82 * t2
  t84 = t83 ** (0.1e1 / 0.3e1)
  t87 = r1 ** 2
  t88 = r1 ** (0.1e1 / 0.3e1)
  t89 = t88 ** 2
  t99 = 0.1e1 / (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t59 * s2 / t89 / t87))
  t103 = f.my_piecewise3(t80, 0, t43 * t44 / t84 * t99 / 0.9e1)
  t104 = t76 + t103
  t105 = t104 == 0.0e0
  t106 = f.my_piecewise3(t105, DBL_EPSILON, t104)
  t109 = 0.361925846e1 / t106 + 0.5764e0
  t110 = t106 ** 2
  t111 = t110 ** 2
  t112 = 0.1e1 / t111
  t114 = t110 * t106
  t115 = 0.1e1 / t114
  t117 = 0.1e1 / t110
  t119 = 0.320261508740743441e2 * t112 + 0.151911844324290596e2 * t115 + 0.1801312286343e1 * t117
  t120 = 0.1e1 / t119
  t121 = t109 * t120
  t124 = f.my_piecewise5(t13, t26, t15, t30, t4)
  t125 = t16 * t2
  t126 = 0.1e1 / t125
  t129 = 0.2e1 * t1 * t126 - 0.2e1 * t17
  t130 = f.my_piecewise5(t13, 0, t15, 0, t129)
  t131 = t124 * t130
  t133 = t2 * t109 * t120
  t136 = t124 * t20
  t139 = t136 * t2
  t142 = t44 / t51 / t50
  t143 = f.my_piecewise5(t25, 0, t29, 0, t19)
  t144 = f.my_piecewise5(t45, 0, t47, 0, t143)
  t146 = t144 * t2 + t48 + 0.1e1
  t151 = t42 * t44
  t153 = t41 * t151 * t52
  t154 = t71 ** 2
  t155 = 0.1e1 / t154
  t156 = t68 ** 2
  t157 = 0.1e1 / t156
  t159 = t155 * t157 * t54
  t160 = t58 * s0
  t161 = t60 * r0
  t164 = t160 / t62 / t161
  t169 = f.my_piecewise3(t35, 0, -t43 * t142 * t72 * t146 / 0.27e2 + 0.17518270448709640211555555555555555555555555555557e-2 * t153 * t159 * t164)
  t172 = t44 / t84 / t83
  t173 = f.my_piecewise5(t47, 0, t45, 0, -t143)
  t175 = t173 * t2 + t81 + 0.1e1
  t180 = f.my_piecewise3(t80, 0, -t43 * t172 * t99 * t175 / 0.27e2)
  t182 = f.my_piecewise3(t105, 0, t169 + t180)
  t183 = t117 * t182
  t184 = t183 * t120
  t187 = t119 ** 2
  t188 = 0.1e1 / t187
  t189 = t109 * t188
  t191 = 0.1e1 / t111 / t106
  t192 = t191 * t182
  t194 = t112 * t182
  t198 = -0.1281046034962973764e3 * t192 - 0.455735532972871788e2 * t194 - 0.3602624572686e1 * t115 * t182
  t199 = t189 * t198
  t202 = t124 ** 2
  t203 = 0.1e1 - t202
  t204 = t203 * t117
  t205 = t182 * t120
  t208 = t203 * t109
  t209 = t188 * t198
  t212 = t203 * t2
  t213 = t182 ** 2
  t215 = t115 * t213 * t120
  t218 = t49 ** 2
  t221 = 0.1e1 / t51 / t218 / t16
  t222 = t44 * t221
  t223 = t146 ** 2
  t229 = t43 * t142 * t155
  t231 = t146 * t157 * t54
  t235 = f.my_piecewise5(t25, 0, t29, 0, t129)
  t236 = f.my_piecewise5(t45, 0, t47, 0, t235)
  t239 = t236 * t2 + 0.2e1 * t144
  t245 = 0.1e1 / t154 / t71
  t246 = t156 ** 2
  t247 = 0.1e1 / t246
  t249 = t54 ** 2
  t250 = t245 * t247 * t249
  t253 = s0 ** 2
  t254 = 0.1e1 / t56 / t55 * t253
  t255 = t60 ** 2
  t259 = t254 / t61 / t255 / t161
  t264 = 0.1e1 / t156 / t68
  t266 = t155 * t264 * t249
  t272 = t160 / t62 / t255
  t277 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t222 * t72 * t223 - 0.11678846965806426807703703703703703703703703703704e-2 * t229 * t231 * t164 - t43 * t142 * t72 * t239 / 0.27e2 + 0.55240163912544022619660862581054190456035555555564e-4 * t153 * t250 * t259 + 0.85456059120665365058508549573423600987654320987665e-4 * t153 * t266 * t259 - 0.64233658311935347442370370370370370370370370370376e-2 * t153 * t159 * t272)
  t278 = t82 ** 2
  t281 = 0.1e1 / t84 / t278 / t16
  t283 = t175 ** 2
  t288 = f.my_piecewise5(t47, 0, t45, 0, -t235)
  t291 = t288 * t2 + 0.2e1 * t173
  t297 = f.my_piecewise3(t80, 0, 0.4e1 / 0.81e2 * t43 * t44 * t281 * t99 * t283 - t43 * t172 * t99 * t291 / 0.27e2)
  t299 = f.my_piecewise3(t105, 0, t277 + t297)
  t301 = t117 * t299 * t120
  t304 = t212 * t117
  t305 = t182 * t188
  t306 = t305 * t198
  t310 = 0.1e1 / t187 / t119
  t312 = t198 ** 2
  t313 = t109 * t310 * t312
  t317 = 0.1e1 / t111 / t110
  t330 = 0.6405230174814868820e3 * t317 * t213 - 0.1281046034962973764e3 * t191 * t299 + 0.1822942131891487152e3 * t191 * t213 - 0.455735532972871788e2 * t112 * t299 + 0.10807873718058e2 * t112 * t213 - 0.3602624572686e1 * t115 * t299
  t331 = t189 * t330
  t334 = 0.50000000000000000000000000000000000000000000000000e0 * t22 * t121 + 0.50000000000000000000000000000000000000000000000000e0 * t131 * t133 + 0.10000000000000000000000000000000000000000000000000e1 * t136 * t121 - 0.36192584600000000000000000000000000000000000000000e1 * t139 * t184 - 0.10000000000000000000000000000000000000000000000000e1 * t139 * t199 + 0.18096292300000000000000000000000000000000000000000e1 * t204 * t205 + 0.50000000000000000000000000000000000000000000000000e0 * t208 * t209 - 0.18096292300000000000000000000000000000000000000000e1 * t212 * t215 + 0.90481461500000000000000000000000000000000000000000e0 * t212 * t301 - 0.18096292300000000000000000000000000000000000000000e1 * t304 * t306 - 0.50000000000000000000000000000000000000000000000000e0 * t212 * t313 + 0.25000000000000000000000000000000000000000000000000e0 * t212 * t331
  t335 = f.my_piecewise3(t11, 0, t334)
  t337 = t187 ** 2
  t344 = t213 * t182
  t373 = t41 * t151
  t399 = t16 ** 2
  t403 = 0.6e1 * t126 - 0.6e1 * t1 / t399
  t404 = f.my_piecewise5(t25, 0, t29, 0, t403)
  t405 = f.my_piecewise5(t45, 0, t47, 0, t404)
  t413 = t154 ** 2
  t418 = t55 ** 2
  t422 = t255 ** 2
  t425 = 0.1e1 / t418 * t253 * s0 / t422 / t161
  t437 = t254 / t61 / t422
  t455 = -0.28e2 / 0.243e3 * t43 * t44 / t51 / t218 / t49 / t125 * t72 * t223 * t146 + 0.23357693931612853615407407407407407407407407407409e-2 * t43 * t222 * t155 * t223 * t157 * t54 * t164 + 0.4e1 / 0.27e2 * t373 * t221 * t72 * t146 * t239 - 0.55240163912544022619660862581054190456035555555562e-4 * t43 * t142 * t245 * t146 * t247 * t249 * t259 - 0.17518270448709640211555555555555555555555555555556e-2 * t229 * t239 * t157 * t54 * t164 - 0.85456059120665365058508549573423600987654320987662e-4 * t229 * t146 * t264 * t249 * t259 + 0.64233658311935347442370370370370370370370370370373e-2 * t229 * t231 * t272 - t43 * t142 * t72 * (t405 * t2 + 0.3e1 * t236) / 0.27e2 + 0.15676936523026145722909417762823399896869428149623e-4 * t153 / t413 / t246 / t156 * t425 + 0.48504172307078245968260122777973935969621507356322e-4 * t153 * t245 / t246 / t68 * t425 - 0.60764180303798424881626948839159609501639111111120e-3 * t153 * t250 * t437 + 0.37517768980871641457095835172685960720048318231852e-4 * t153 * t155 * t247 * t425 - 0.94001665032731901564359404530765961086419753086431e-3 * t153 * t266 * t437 + 0.29975707212236495473106172839506172839506172839509e-1 * t153 * t159 * t160 / t62 / t255 / r0
  t456 = f.my_piecewise3(t35, 0, t455)
  t472 = f.my_piecewise5(t47, 0, t45, 0, -t404)
  t481 = f.my_piecewise3(t80, 0, -0.28e2 / 0.243e3 * t43 * t44 / t84 / t278 / t82 / t125 * t99 * t283 * t175 + 0.4e1 / 0.27e2 * t373 * t281 * t99 * t175 * t291 - t43 * t172 * t99 * (t472 * t2 + 0.3e1 * t288) / 0.27e2)
  t483 = f.my_piecewise3(t105, 0, t456 + t481)
  t520 = f.my_piecewise5(t13, 0, t15, 0, t403)
  t527 = t212 * t115
  t535 = 0.15000000000000000000000000000000000000000000000000e1 * t212 * t109 / t337 * t312 * t198 + 0.54288876900000000000000000000000000000000000000000e1 * t212 * t112 * t344 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t212 * t189 * (-0.38431381048889212920e4 / t111 / t114 * t344 + 0.19215690524444606460e4 * t317 * t182 * t299 - 0.1281046034962973764e3 * t191 * t483 - 0.9114710659457435760e3 * t317 * t344 + 0.5468826395674461456e3 * t192 * t299 - 0.455735532972871788e2 * t112 * t483 - 0.43231494872232e2 * t191 * t344 + 0.32423621154174e2 * t194 * t299 - 0.3602624572686e1 * t115 * t483) + 0.90481461500000000000000000000000000000000000000000e0 * t212 * t117 * t483 * t120 - 0.30000000000000000000000000000000000000000000000000e1 * t136 * t199 - 0.10857775380000000000000000000000000000000000000000e2 * t136 * t184 - 0.54288876900000000000000000000000000000000000000000e1 * t204 * t306 + 0.15000000000000000000000000000000000000000000000000e1 * t20 * t2 * t121 * t130 - 0.15000000000000000000000000000000000000000000000000e1 * t22 * t199 - 0.54288876900000000000000000000000000000000000000000e1 * t22 * t184 + 0.50000000000000000000000000000000000000000000000000e0 * t124 * t520 * t133 + 0.10857775380000000000000000000000000000000000000000e2 * t139 * t183 * t209 - 0.54288876900000000000000000000000000000000000000000e1 * t527 * t205 * t299 + 0.10857775380000000000000000000000000000000000000000e2 * t139 * t215 + 0.30000000000000000000000000000000000000000000000000e1 * t139 * t313
  t549 = t131 * t2
  t583 = -0.15000000000000000000000000000000000000000000000000e1 * t212 * t109 * t310 * t198 * t330 + 0.54288876900000000000000000000000000000000000000000e1 * t527 * t213 * t188 * t198 - 0.27144438450000000000000000000000000000000000000000e1 * t304 * t299 * t188 * t198 - 0.54288876900000000000000000000000000000000000000000e1 * t549 * t184 - 0.15000000000000000000000000000000000000000000000000e1 * t139 * t331 - 0.15000000000000000000000000000000000000000000000000e1 * t549 * t199 + 0.54288876900000000000000000000000000000000000000000e1 * t304 * t182 * t310 * t312 - 0.54288876900000000000000000000000000000000000000000e1 * t139 * t301 - 0.27144438450000000000000000000000000000000000000000e1 * t304 * t305 * t330 + 0.15000000000000000000000000000000000000000000000000e1 * t21 * t109 * t120 + 0.27144438450000000000000000000000000000000000000000e1 * t204 * t299 * t120 + 0.75000000000000000000000000000000000000000000000000e0 * t208 * t188 * t330 - 0.54288876900000000000000000000000000000000000000000e1 * t203 * t115 * t213 * t120 + 0.15000000000000000000000000000000000000000000000000e1 * t131 * t121 - 0.15000000000000000000000000000000000000000000000000e1 * t208 * t310 * t312
  t585 = f.my_piecewise3(t11, 0, t535 + t583)
  d111 = t2 * t585 + 0.3e1 * t335

  res = {'v3rho3': d111}
  return res
