"""Generated from gga_c_op_pw91.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3706

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  op_enhancement = lambda xs: pw91_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3706

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  op_enhancement = lambda xs: pw91_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3706

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  op_enhancement = lambda xs: pw91_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t18 ** 2
  t20 = 0.1e1 - t19
  t21 = t20 * t2
  t24 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t27 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t28 = f.my_piecewise5(t24, t14, t27, t17, t4)
  t29 = 0.1e1 + t28
  t32 = t29 * t2 / 0.2e1 <= f.p.dens_threshold
  t33 = 3 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t39 = 4 ** (0.1e1 / 0.3e1)
  t40 = t34 / t36 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t29 <= f.p.zeta_threshold
  t43 = 0.1e1 - t28
  t44 = t43 <= f.p.zeta_threshold
  t45 = f.my_piecewise5(t42, t14, t44, t17, t28)
  t47 = (0.1e1 + t45) * t2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t50 = t41 / t48
  t51 = 6 ** (0.1e1 / 0.3e1)
  t52 = jnp.pi ** 2
  t53 = t52 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t55 = 0.1e1 / t54
  t56 = t51 * t55
  t57 = r0 ** 2
  t58 = r0 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t61 = 0.1e1 / t59 / t57
  t63 = t56 * s0 * t61
  t65 = jnp.exp(-0.25e2 / 0.6e1 * t63)
  t68 = (0.2743e0 - 0.1508e0 * t65) * t51
  t69 = t55 * s0
  t73 = t51 ** 2
  t76 = t73 / t53 / t52
  t77 = s0 ** 2
  t78 = t57 ** 2
  t81 = 0.1e1 / t58 / t78 / r0
  t84 = 0.69444444444444444444444444444444444444444444444444e-5 * t76 * t77 * t81
  t85 = t68 * t69 * t61 / 0.24e2 - t84
  t87 = t73 / t53
  t88 = jnp.sqrt(s0)
  t90 = 0.1e1 / t58 / r0
  t91 = t88 * t90
  t94 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t87 * t91)
  t98 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t87 * t91 * t94 + t84
  t99 = 0.1e1 / t98
  t101 = t85 * t99 + 0.1e1
  t102 = 0.1e1 / t101
  t106 = f.my_piecewise3(t32, 0, t40 * t50 * t102 / 0.9e1)
  t110 = t43 * t2 / 0.2e1 <= f.p.dens_threshold
  t111 = f.my_piecewise5(t44, t14, t42, t17, -t28)
  t113 = (0.1e1 + t111) * t2
  t114 = t113 ** (0.1e1 / 0.3e1)
  t116 = t41 / t114
  t117 = r1 ** 2
  t118 = r1 ** (0.1e1 / 0.3e1)
  t119 = t118 ** 2
  t121 = 0.1e1 / t119 / t117
  t123 = t56 * s2 * t121
  t125 = jnp.exp(-0.25e2 / 0.6e1 * t123)
  t128 = (0.2743e0 - 0.1508e0 * t125) * t51
  t129 = t55 * s2
  t133 = s2 ** 2
  t134 = t117 ** 2
  t137 = 0.1e1 / t118 / t134 / r1
  t140 = 0.69444444444444444444444444444444444444444444444444e-5 * t76 * t133 * t137
  t141 = t128 * t129 * t121 / 0.24e2 - t140
  t142 = jnp.sqrt(s2)
  t144 = 0.1e1 / t118 / r1
  t145 = t142 * t144
  t148 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t87 * t145)
  t152 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t87 * t145 * t148 + t140
  t153 = 0.1e1 / t152
  t155 = t141 * t153 + 0.1e1
  t156 = 0.1e1 / t155
  t160 = f.my_piecewise3(t110, 0, t40 * t116 * t156 / 0.9e1)
  t161 = t106 + t160
  t162 = t161 == 0.0e0
  t163 = f.my_piecewise3(t162, DBL_EPSILON, t161)
  t166 = 0.360663084e1 / t163 + 0.5764e0
  t167 = t163 ** 2
  t168 = t167 ** 2
  t169 = 0.1e1 / t168
  t172 = 0.1e1 / t167 / t163
  t174 = 0.1e1 / t167
  t176 = 0.315815266717518096e2 * t169 + 0.150327320916243744e2 * t172 + 0.1788764629788e1 * t174
  t177 = 0.1e1 / t176
  t181 = f.my_piecewise3(t11, 0, -0.25000000000000000000000000000000000000000000000000e0 * t21 * t166 * t177)
  t182 = t2 ** 2
  t184 = t1 / t182
  t185 = t3 - t184
  t186 = f.my_piecewise5(t13, 0, t16, 0, t185)
  t189 = t2 * t166 * t177
  t194 = 0.25000000000000000000000000000000000000000000000000e0 * t20 * t166 * t177
  t197 = t41 / t48 / t47
  t198 = f.my_piecewise5(t24, 0, t27, 0, t185)
  t199 = f.my_piecewise5(t42, 0, t44, 0, t198)
  t206 = t101 ** 2
  t207 = 0.1e1 / t206
  t211 = t77 / t58 / t78 / t57
  t217 = 0.1e1 / t59 / t57 / r0
  t222 = 0.37037037037037037037037037037037037037037037037037e-4 * t76 * t211
  t225 = t98 ** 2
  t227 = t85 / t225
  t237 = jnp.sqrt(0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t63)
  t238 = 0.1e1 / t237
  t250 = f.my_piecewise3(t32, 0, -t40 * t197 * t102 * (t199 * t2 + t45 + 0.1e1) / 0.27e2 - t40 * t50 * t207 * ((-0.69814814814814814814814814814814814814814814814817e-1 * t76 * t211 * t65 - t68 * t69 * t217 / 0.9e1 + t222) * t99 - t227 * (-0.21827777777777777777777777777777777777777777777777e-1 * t87 * t88 / t58 / t57 * t94 - 0.85080312222222222222222222222222222222222222222219e-1 * t56 * s0 * t217 * t238 - t222)) / 0.9e1)
  t253 = t41 / t114 / t113
  t254 = f.my_piecewise5(t44, 0, t42, 0, -t198)
  t261 = f.my_piecewise3(t110, 0, -t40 * t253 * t156 * (t254 * t2 + t111 + 0.1e1) / 0.27e2)
  t263 = f.my_piecewise3(t162, 0, t250 + t261)
  t268 = t176 ** 2
  t270 = t166 / t268
  t272 = 0.1e1 / t168 / t163
  t284 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t186 * t189 - t194 + 0.90165771000000000000000000000000000000000000000000e0 * t21 * t174 * t263 * t177 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t270 * (-0.1263261066870072384e3 * t272 * t263 - 0.450981962748731232e2 * t169 * t263 - 0.3577529259576e1 * t172 * t263))
  vrho_0_ = t2 * t284 + t181
  t286 = -t3 - t184
  t287 = f.my_piecewise5(t13, 0, t16, 0, t286)
  t291 = f.my_piecewise5(t24, 0, t27, 0, t286)
  t292 = f.my_piecewise5(t42, 0, t44, 0, t291)
  t299 = f.my_piecewise3(t32, 0, -t40 * t197 * t102 * (t292 * t2 + t45 + 0.1e1) / 0.27e2)
  t300 = f.my_piecewise5(t44, 0, t42, 0, -t291)
  t307 = t155 ** 2
  t308 = 0.1e1 / t307
  t312 = t133 / t118 / t134 / t117
  t318 = 0.1e1 / t119 / t117 / r1
  t323 = 0.37037037037037037037037037037037037037037037037037e-4 * t76 * t312
  t326 = t152 ** 2
  t328 = t141 / t326
  t338 = jnp.sqrt(0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t123)
  t339 = 0.1e1 / t338
  t351 = f.my_piecewise3(t110, 0, -t40 * t253 * t156 * (t300 * t2 + t111 + 0.1e1) / 0.27e2 - t40 * t116 * t308 * ((-0.69814814814814814814814814814814814814814814814817e-1 * t76 * t312 * t125 - t128 * t129 * t318 / 0.9e1 + t323) * t153 - t328 * (-0.21827777777777777777777777777777777777777777777777e-1 * t87 * t142 / t118 / t117 * t148 - 0.85080312222222222222222222222222222222222222222219e-1 * t56 * s2 * t318 * t339 - t323)) / 0.9e1)
  t353 = f.my_piecewise3(t162, 0, t299 + t351)
  t369 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t287 * t189 - t194 + 0.90165771000000000000000000000000000000000000000000e0 * t21 * t174 * t353 * t177 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t270 * (-0.1263261066870072384e3 * t272 * t353 - 0.450981962748731232e2 * t169 * t353 - 0.3577529259576e1 * t172 * t353))
  vrho_1_ = t2 * t369 + t181
  t380 = 0.13888888888888888888888888888888888888888888888889e-4 * t76 * s0 * t81
  t398 = f.my_piecewise3(t32, 0, -t40 * t50 * t207 * ((0.26180555555555555555555555555555555555555555555555e-1 * t76 * t81 * t65 * s0 + t68 * t55 * t61 / 0.24e2 - t380) * t99 - t227 * (0.81854166666666666666666666666666666666666666666665e-2 * t87 / t88 * t90 * t94 + 0.31905117083333333333333333333333333333333333333333e-1 * t56 * t61 * t238 + t380)) / 0.9e1)
  t399 = f.my_piecewise3(t162, 0, t398)
  t415 = f.my_piecewise3(t11, 0, 0.90165771000000000000000000000000000000000000000000e0 * t21 * t174 * t399 * t177 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t270 * (-0.1263261066870072384e3 * t272 * t399 - 0.450981962748731232e2 * t169 * t399 - 0.3577529259576e1 * t172 * t399))
  vsigma_0_ = t2 * t415
  vsigma_1_ = 0.0e0
  t425 = 0.13888888888888888888888888888888888888888888888889e-4 * t76 * s2 * t137
  t443 = f.my_piecewise3(t110, 0, -t40 * t116 * t308 * ((0.26180555555555555555555555555555555555555555555555e-1 * t76 * t137 * t125 * s2 + t128 * t55 * t121 / 0.24e2 - t425) * t153 - t328 * (0.81854166666666666666666666666666666666666666666665e-2 * t87 / t142 * t144 * t148 + 0.31905117083333333333333333333333333333333333333333e-1 * t56 * t121 * t339 + t425)) / 0.9e1)
  t444 = f.my_piecewise3(t162, 0, t443)
  t460 = f.my_piecewise3(t11, 0, 0.90165771000000000000000000000000000000000000000000e0 * t21 * t174 * t444 * t177 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t270 * (-0.1263261066870072384e3 * t272 * t444 - 0.450981962748731232e2 * t169 * t444 - 0.3577529259576e1 * t172 * t444))
  vsigma_2_ = t2 * t460
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3706

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  op_enhancement = lambda xs: pw91_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = t9 * r0
  t11 = 0.1e1 + t7
  t14 = t11 * r0 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t18 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t21 = 4 ** (0.1e1 / 0.3e1)
  t22 = t16 / t18 * t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t11 <= f.p.zeta_threshold
  t25 = 0.1e1 - t7
  t26 = t25 <= f.p.zeta_threshold
  t27 = f.my_piecewise5(t24, t5, t26, t6, t7)
  t28 = 0.1e1 + t27
  t29 = t28 * r0
  t30 = t29 ** (0.1e1 / 0.3e1)
  t32 = t23 / t30
  t33 = 6 ** (0.1e1 / 0.3e1)
  t34 = jnp.pi ** 2
  t35 = t34 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t33 * t37
  t39 = t23 ** 2
  t40 = s0 * t39
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t45 = 0.1e1 / t43 / t41
  t46 = t40 * t45
  t47 = t38 * t46
  t49 = jnp.exp(-0.25e2 / 0.6e1 * t47)
  t52 = (0.2743e0 - 0.1508e0 * t49) * t33
  t53 = t52 * t37
  t56 = t33 ** 2
  t59 = t56 / t35 / t34
  t60 = s0 ** 2
  t61 = t60 * t23
  t62 = t41 ** 2
  t65 = 0.1e1 / t42 / t62 / r0
  t68 = 0.13888888888888888888888888888888888888888888888889e-4 * t59 * t61 * t65
  t69 = t53 * t46 / 0.24e2 - t68
  t71 = t56 / t35
  t72 = jnp.sqrt(s0)
  t73 = t71 * t72
  t75 = 0.1e1 / t42 / r0
  t81 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t71 * t72 * t23 * t75)
  t82 = t23 * t75 * t81
  t85 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t73 * t82 + t68
  t86 = 0.1e1 / t85
  t88 = t69 * t86 + 0.1e1
  t89 = 0.1e1 / t88
  t93 = f.my_piecewise3(t14, 0, t22 * t32 * t89 / 0.9e1)
  t97 = t25 * r0 / 0.2e1 <= f.p.dens_threshold
  t98 = f.my_piecewise5(t26, t5, t24, t6, -t7)
  t99 = 0.1e1 + t98
  t100 = t99 * r0
  t101 = t100 ** (0.1e1 / 0.3e1)
  t103 = t23 / t101
  t107 = f.my_piecewise3(t97, 0, t22 * t103 * t89 / 0.9e1)
  t108 = t93 + t107
  t109 = t108 == 0.0e0
  t110 = f.my_piecewise3(t109, DBL_EPSILON, t108)
  t113 = 0.360663084e1 / t110 + 0.5764e0
  t114 = t110 ** 2
  t115 = t114 ** 2
  t116 = 0.1e1 / t115
  t119 = 0.1e1 / t114 / t110
  t121 = 0.1e1 / t114
  t123 = 0.315815266717518096e2 * t116 + 0.150327320916243744e2 * t119 + 0.1788764629788e1 * t121
  t124 = 0.1e1 / t123
  t128 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t10 * t113 * t124)
  t139 = t88 ** 2
  t140 = 0.1e1 / t139
  t144 = 0.1e1 / t42 / t62 / t41
  t151 = 0.1e1 / t43 / t41 / r0
  t157 = 0.74074074074074074074074074074074074074074074074075e-4 * t59 * t61 * t144
  t160 = t85 ** 2
  t162 = t69 / t160
  t173 = jnp.sqrt(0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t47)
  t174 = 0.1e1 / t173
  t181 = t140 * ((-0.13962962962962962962962962962962962962962962962963e0 * t59 * t60 * t23 * t144 * t49 - t53 * t40 * t151 / 0.9e1 + t157) * t86 - t162 * (-0.21827777777777777777777777777777777777777777777777e-1 * t73 * t23 / t42 / t41 * t81 - 0.85080312222222222222222222222222222222222222222219e-1 * t38 * s0 * t39 * t151 * t174 - t157))
  t186 = f.my_piecewise3(t14, 0, -t22 * t23 / t30 / t29 * t89 * t28 / 0.27e2 - t22 * t32 * t181 / 0.9e1)
  t198 = f.my_piecewise3(t97, 0, -t22 * t23 / t101 / t100 * t89 * t99 / 0.27e2 - t22 * t103 * t181 / 0.9e1)
  t200 = f.my_piecewise3(t109, 0, t186 + t198)
  t205 = t123 ** 2
  t207 = t113 / t205
  t209 = 0.1e1 / t115 / t110
  t221 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t9 * t113 * t124 + 0.90165771000000000000000000000000000000000000000000e0 * t10 * t121 * t200 * t124 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t207 * (-0.1263261066870072384e3 * t209 * t200 - 0.450981962748731232e2 * t116 * t200 - 0.3577529259576e1 * t119 * t200))
  vrho_0_ = r0 * t221 + t128
  t235 = 0.27777777777777777777777777777777777777777777777778e-4 * t59 * s0 * t23 * t65
  t249 = t140 * ((0.52361111111111111111111111111111111111111111111112e-1 * t59 * t23 * t65 * t49 * s0 + t52 * t37 * t39 * t45 / 0.24e2 - t235) * t86 - t162 * (0.81854166666666666666666666666666666666666666666665e-2 * t71 / t72 * t82 + 0.31905117083333333333333333333333333333333333333333e-1 * t38 * t39 * t45 * t174 + t235))
  t253 = f.my_piecewise3(t14, 0, -t22 * t32 * t249 / 0.9e1)
  t257 = f.my_piecewise3(t97, 0, -t22 * t103 * t249 / 0.9e1)
  t259 = f.my_piecewise3(t109, 0, t253 + t257)
  t275 = f.my_piecewise3(t4, 0, 0.90165771000000000000000000000000000000000000000000e0 * t10 * t121 * t259 * t124 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t207 * (-0.1263261066870072384e3 * t209 * t259 - 0.450981962748731232e2 * t116 * t259 - 0.3577529259576e1 * t119 * t259))
  vsigma_0_ = r0 * t275
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t31 = t22 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = t22 ** 2
  t39 = s0 * t38
  t40 = r0 ** 2
  t41 = r0 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t44 = 0.1e1 / t42 / t40
  t45 = t39 * t44
  t46 = t37 * t45
  t48 = jnp.exp(-0.25e2 / 0.6e1 * t46)
  t51 = (0.2743e0 - 0.1508e0 * t48) * t32
  t52 = t51 * t36
  t55 = t32 ** 2
  t58 = t55 / t34 / t33
  t59 = s0 ** 2
  t60 = t59 * t22
  t61 = t40 ** 2
  t64 = 0.1e1 / t41 / t61 / r0
  t67 = 0.13888888888888888888888888888888888888888888888889e-4 * t58 * t60 * t64
  t68 = t52 * t45 / 0.24e2 - t67
  t70 = t55 / t34
  t71 = jnp.sqrt(s0)
  t72 = t70 * t71
  t74 = 0.1e1 / t41 / r0
  t80 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t70 * t71 * t22 * t74)
  t81 = t22 * t74 * t80
  t84 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t72 * t81 + t67
  t85 = 0.1e1 / t84
  t87 = t68 * t85 + 0.1e1
  t88 = 0.1e1 / t87
  t92 = f.my_piecewise3(t13, 0, t21 * t31 * t88 / 0.9e1)
  t96 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t97 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t98 = 0.1e1 + t97
  t99 = t98 * r0
  t100 = t99 ** (0.1e1 / 0.3e1)
  t101 = 0.1e1 / t100
  t102 = t22 * t101
  t106 = f.my_piecewise3(t96, 0, t21 * t102 * t88 / 0.9e1)
  t107 = t92 + t106
  t108 = t107 == 0.0e0
  t109 = f.my_piecewise3(t108, DBL_EPSILON, t107)
  t112 = 0.360663084e1 / t109 + 0.5764e0
  t113 = t9 * t112
  t114 = t109 ** 2
  t115 = t114 ** 2
  t116 = 0.1e1 / t115
  t119 = 0.1e1 / t114 / t109
  t121 = 0.1e1 / t114
  t123 = 0.315815266717518096e2 * t116 + 0.150327320916243744e2 * t119 + 0.1788764629788e1 * t121
  t124 = 0.1e1 / t123
  t127 = t9 * r0
  t129 = 0.1e1 / t29 / t28
  t135 = t87 ** 2
  t136 = 0.1e1 / t135
  t137 = t58 * t59
  t140 = 0.1e1 / t41 / t61 / t40
  t145 = t40 * r0
  t147 = 0.1e1 / t42 / t145
  t153 = 0.74074074074074074074074074074074074074074074074075e-4 * t58 * t60 * t140
  t154 = -0.13962962962962962962962962962962962962962962962963e0 * t137 * t22 * t140 * t48 - t52 * t39 * t147 / 0.9e1 + t153
  t156 = t84 ** 2
  t157 = 0.1e1 / t156
  t158 = t68 * t157
  t162 = t22 / t41 / t40 * t80
  t165 = t37 * s0
  t168 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t46
  t169 = jnp.sqrt(t168)
  t170 = 0.1e1 / t169
  t171 = t38 * t147 * t170
  t174 = -0.21827777777777777777777777777777777777777777777777e-1 * t72 * t162 - 0.85080312222222222222222222222222222222222222222219e-1 * t165 * t171 - t153
  t176 = t154 * t85 - t158 * t174
  t177 = t136 * t176
  t182 = f.my_piecewise3(t13, 0, -t21 * t22 * t129 * t88 * t27 / 0.27e2 - t21 * t31 * t177 / 0.9e1)
  t184 = 0.1e1 / t100 / t99
  t194 = f.my_piecewise3(t96, 0, -t21 * t22 * t184 * t88 * t98 / 0.27e2 - t21 * t102 * t177 / 0.9e1)
  t196 = f.my_piecewise3(t108, 0, t182 + t194)
  t201 = t123 ** 2
  t202 = 0.1e1 / t201
  t203 = t112 * t202
  t205 = 0.1e1 / t115 / t109
  t212 = -0.1263261066870072384e3 * t205 * t196 - 0.450981962748731232e2 * t116 * t196 - 0.3577529259576e1 * t119 * t196
  t217 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t113 * t124 + 0.90165771000000000000000000000000000000000000000000e0 * t127 * t121 * t196 * t124 + 0.25000000000000000000000000000000000000000000000000e0 * t127 * t203 * t212)
  t219 = t9 * t121
  t226 = t196 ** 2
  t231 = t27 ** 2
  t241 = t19 * t20 * t22
  t242 = t129 * t136
  t248 = 0.1e1 / t135 / t87
  t249 = t176 ** 2
  t250 = t248 * t249
  t256 = 0.1e1 / t41 / t61 / t145
  t257 = t22 * t256
  t261 = t33 ** 2
  t262 = 0.1e1 / t261
  t265 = t61 ** 2
  t272 = 0.1e1 / t42 / t61
  t278 = 0.46913580246913580246913580246913580246913580246914e-3 * t58 * t60 * t256
  t281 = t154 * t157
  t286 = t68 / t156 / t84
  t287 = t174 ** 2
  t301 = 0.1e1 / t169 / t168
  t308 = t136 * ((0.12566666666666666666666666666666666666666666666667e1 * t137 * t257 * t48 - 0.18617283950617283950617283950617283950617283950617e2 * t262 * t59 * s0 / t265 / t40 * t48 + 0.11e2 / 0.27e2 * t52 * t39 * t272 - t278) * t85 - 0.2e1 * t281 * t174 + 0.2e1 * t286 * t287 - t158 * (0.50931481481481481481481481481481481481481481481480e-1 * t72 * t22 / t41 / t145 * t80 + 0.42540156111111111111111111111111111111111111111109e0 * t165 * t38 * t272 * t170 - 0.57449421445821236543209876543209876543209876543208e0 * t137 * t257 * t301 + t278))
  t313 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 / t29 / t40 * t88 + 0.2e1 / 0.27e2 * t241 * t242 * t27 * t176 + 0.2e1 / 0.9e1 * t21 * t31 * t250 - t21 * t31 * t308 / 0.9e1)
  t314 = t98 ** 2
  t323 = t184 * t136
  t335 = f.my_piecewise3(t96, 0, 0.4e1 / 0.81e2 * t21 * t22 / t100 / t40 * t88 + 0.2e1 / 0.27e2 * t241 * t323 * t98 * t176 + 0.2e1 / 0.9e1 * t21 * t102 * t250 - t21 * t102 * t308 / 0.9e1)
  t337 = f.my_piecewise3(t108, 0, t313 + t335)
  t342 = t127 * t121
  t343 = t196 * t202
  t348 = 0.1e1 / t201 / t123
  t349 = t112 * t348
  t350 = t212 ** 2
  t355 = 0.1e1 / t115 / t114
  t373 = f.my_piecewise3(t4, 0, 0.18033154200000000000000000000000000000000000000000e1 * t219 * t196 * t124 + 0.50000000000000000000000000000000000000000000000000e0 * t113 * t202 * t212 - 0.18033154200000000000000000000000000000000000000000e1 * t127 * t119 * t226 * t124 + 0.90165771000000000000000000000000000000000000000000e0 * t127 * t121 * t337 * t124 - 0.18033154200000000000000000000000000000000000000000e1 * t342 * t343 * t212 - 0.50000000000000000000000000000000000000000000000000e0 * t127 * t349 * t350 + 0.25000000000000000000000000000000000000000000000000e0 * t127 * t203 * (0.6316305334350361920e3 * t355 * t226 - 0.1263261066870072384e3 * t205 * t337 + 0.1803927850994924928e3 * t205 * t226 - 0.450981962748731232e2 * t116 * t337 + 0.10732587778728e2 * t116 * t226 - 0.3577529259576e1 * t119 * t337))
  v2rho2_0_ = r0 * t373 + 0.2e1 * t217
  t375 = t58 * t22
  t380 = t36 * t38
  t384 = s0 * t22
  t387 = 0.27777777777777777777777777777777777777777777777778e-4 * t58 * t384 * t64
  t388 = 0.52361111111111111111111111111111111111111111111112e-1 * t375 * t64 * t48 * s0 + t51 * t380 * t44 / 0.24e2 - t387
  t391 = t70 / t71
  t395 = t38 * t44 * t170
  t398 = 0.81854166666666666666666666666666666666666666666665e-2 * t391 * t81 + 0.31905117083333333333333333333333333333333333333333e-1 * t37 * t395 + t387
  t400 = -t158 * t398 + t388 * t85
  t401 = t136 * t400
  t405 = f.my_piecewise3(t13, 0, -t21 * t31 * t401 / 0.9e1)
  t409 = f.my_piecewise3(t96, 0, -t21 * t102 * t401 / 0.9e1)
  t411 = f.my_piecewise3(t108, 0, t405 + t409)
  t416 = t205 * t411
  t418 = t116 * t411
  t422 = -0.1263261066870072384e3 * t416 - 0.450981962748731232e2 * t418 - 0.3577529259576e1 * t119 * t411
  t427 = f.my_piecewise3(t4, 0, 0.90165771000000000000000000000000000000000000000000e0 * t127 * t121 * t411 * t124 + 0.25000000000000000000000000000000000000000000000000e0 * t127 * t203 * t422)
  t428 = t411 * t124
  t440 = t400 * t176
  t459 = 0.14814814814814814814814814814814814814814814814815e-3 * t58 * t384 * t140
  t462 = t388 * t157
  t479 = t136 * ((-0.41888888888888888888888888888888888888888888888889e0 * t375 * t140 * t48 * s0 + 0.69814814814814814814814814814814814814814814814816e1 * t262 / t265 / r0 * t59 * t48 - t51 * t380 * t147 / 0.9e1 + t459) * t85 - t462 * t174 - t281 * t398 + 0.2e1 * t286 * t398 * t174 - t158 * (-0.10913888888888888888888888888888888888888888888889e-1 * t391 * t162 - 0.12762046833333333333333333333333333333333333333333e0 * t37 * t171 + 0.21543533042182963703703703703703703703703703703704e0 * t375 * t140 * t301 * s0 - t459))
  t484 = f.my_piecewise3(t13, 0, t241 * t242 * t400 * t27 / 0.27e2 + 0.2e1 / 0.9e1 * t241 * t30 * t248 * t440 - t21 * t31 * t479 / 0.9e1)
  t497 = f.my_piecewise3(t96, 0, t241 * t323 * t400 * t98 / 0.27e2 + 0.2e1 / 0.9e1 * t241 * t101 * t248 * t440 - t21 * t102 * t479 / 0.9e1)
  t499 = f.my_piecewise3(t108, 0, t484 + t497)
  t504 = t411 * t202
  t537 = f.my_piecewise3(t4, 0, 0.90165771000000000000000000000000000000000000000000e0 * t219 * t428 - 0.18033154200000000000000000000000000000000000000000e1 * t127 * t119 * t428 * t196 + 0.90165771000000000000000000000000000000000000000000e0 * t127 * t121 * t499 * t124 - 0.90165771000000000000000000000000000000000000000000e0 * t342 * t504 * t212 + 0.25000000000000000000000000000000000000000000000000e0 * t113 * t202 * t422 - 0.90165771000000000000000000000000000000000000000000e0 * t342 * t343 * t422 - 0.50000000000000000000000000000000000000000000000000e0 * t127 * t112 * t348 * t422 * t212 + 0.25000000000000000000000000000000000000000000000000e0 * t127 * t203 * (0.6316305334350361920e3 * t355 * t411 * t196 - 0.1263261066870072384e3 * t205 * t499 + 0.1803927850994924928e3 * t416 * t196 - 0.450981962748731232e2 * t116 * t499 + 0.10732587778728e2 * t418 * t196 - 0.3577529259576e1 * t119 * t499))
  v2rhosigma_0_ = r0 * t537 + t427
  t539 = t411 ** 2
  t544 = t400 ** 2
  t545 = t248 * t544
  t554 = t22 * t64
  t559 = 0.27777777777777777777777777777777777777777777777778e-4 * t58 * t554
  t564 = t398 ** 2
  t582 = t136 * ((-0.26180555555555555555555555555555555555555555555556e1 * t262 / t265 * t48 * s0 + 0.10472222222222222222222222222222222222222222222222e0 * t58 * t554 * t48 - t559) * t85 - 0.2e1 * t462 * t398 + 0.2e1 * t286 * t564 - t158 * (-0.40927083333333333333333333333333333333333333333332e-2 * t70 / t71 / s0 * t81 + 0.15952558541666666666666666666666666666666666666666e-1 * t37 / s0 * t395 - 0.80788248908186113888888888888888888888888888888886e-1 * t58 * t554 * t301 + t559))
  t587 = f.my_piecewise3(t13, 0, 0.2e1 / 0.9e1 * t21 * t31 * t545 - t21 * t31 * t582 / 0.9e1)
  t595 = f.my_piecewise3(t96, 0, 0.2e1 / 0.9e1 * t21 * t102 * t545 - t21 * t102 * t582 / 0.9e1)
  t597 = f.my_piecewise3(t108, 0, t587 + t595)
  t605 = t422 ** 2
  t626 = f.my_piecewise3(t4, 0, -0.18033154200000000000000000000000000000000000000000e1 * t127 * t119 * t539 * t124 + 0.90165771000000000000000000000000000000000000000000e0 * t127 * t121 * t597 * t124 - 0.18033154200000000000000000000000000000000000000000e1 * t342 * t504 * t422 - 0.50000000000000000000000000000000000000000000000000e0 * t127 * t349 * t605 + 0.25000000000000000000000000000000000000000000000000e0 * t127 * t203 * (0.6316305334350361920e3 * t355 * t539 - 0.1263261066870072384e3 * t205 * t597 + 0.1803927850994924928e3 * t205 * t539 - 0.450981962748731232e2 * t116 * t597 + 0.10732587778728e2 * t116 * t539 - 0.3577529259576e1 * t119 * t597))
  v2sigma2_0_ = r0 * t626
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t31 = t22 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = t22 ** 2
  t39 = s0 * t38
  t40 = r0 ** 2
  t41 = r0 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t45 = t39 / t42 / t40
  t46 = t37 * t45
  t48 = jnp.exp(-0.25e2 / 0.6e1 * t46)
  t52 = (0.2743e0 - 0.1508e0 * t48) * t32 * t36
  t55 = t32 ** 2
  t58 = t55 / t34 / t33
  t59 = s0 ** 2
  t60 = t59 * t22
  t61 = t40 ** 2
  t62 = t61 * r0
  t67 = 0.13888888888888888888888888888888888888888888888889e-4 * t58 * t60 / t41 / t62
  t68 = t52 * t45 / 0.24e2 - t67
  t70 = t55 / t34
  t71 = jnp.sqrt(s0)
  t72 = t70 * t71
  t74 = 0.1e1 / t41 / r0
  t80 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t70 * t71 * t22 * t74)
  t84 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t72 * t22 * t74 * t80 + t67
  t85 = 0.1e1 / t84
  t87 = t68 * t85 + 0.1e1
  t88 = 0.1e1 / t87
  t92 = f.my_piecewise3(t13, 0, t21 * t31 * t88 / 0.9e1)
  t96 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t97 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t98 = 0.1e1 + t97
  t99 = t98 * r0
  t100 = t99 ** (0.1e1 / 0.3e1)
  t101 = 0.1e1 / t100
  t102 = t22 * t101
  t106 = f.my_piecewise3(t96, 0, t21 * t102 * t88 / 0.9e1)
  t107 = t92 + t106
  t108 = t107 == 0.0e0
  t109 = f.my_piecewise3(t108, DBL_EPSILON, t107)
  t110 = t109 ** 2
  t111 = 0.1e1 / t110
  t112 = t9 * t111
  t114 = 0.1e1 / t29 / t28
  t120 = t87 ** 2
  t121 = 0.1e1 / t120
  t122 = t58 * t59
  t125 = 0.1e1 / t41 / t61 / t40
  t130 = t40 * r0
  t132 = 0.1e1 / t42 / t130
  t138 = 0.74074074074074074074074074074074074074074074074075e-4 * t58 * t60 * t125
  t139 = -0.13962962962962962962962962962962962962962962962963e0 * t122 * t22 * t125 * t48 - t52 * t39 * t132 / 0.9e1 + t138
  t141 = t84 ** 2
  t142 = 0.1e1 / t141
  t143 = t68 * t142
  t150 = t37 * s0
  t153 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t46
  t154 = jnp.sqrt(t153)
  t155 = 0.1e1 / t154
  t159 = -0.21827777777777777777777777777777777777777777777777e-1 * t72 * t22 / t41 / t40 * t80 - 0.85080312222222222222222222222222222222222222222219e-1 * t150 * t38 * t132 * t155 - t138
  t161 = t139 * t85 - t143 * t159
  t162 = t121 * t161
  t167 = f.my_piecewise3(t13, 0, -t21 * t22 * t114 * t88 * t27 / 0.27e2 - t21 * t31 * t162 / 0.9e1)
  t169 = 0.1e1 / t100 / t99
  t179 = f.my_piecewise3(t96, 0, -t21 * t22 * t169 * t88 * t98 / 0.27e2 - t21 * t102 * t162 / 0.9e1)
  t181 = f.my_piecewise3(t108, 0, t167 + t179)
  t182 = t110 ** 2
  t183 = 0.1e1 / t182
  t185 = t110 * t109
  t186 = 0.1e1 / t185
  t189 = 0.315815266717518096e2 * t183 + 0.150327320916243744e2 * t186 + 0.1788764629788e1 * t111
  t190 = 0.1e1 / t189
  t191 = t181 * t190
  t196 = 0.360663084e1 / t109 + 0.5764e0
  t197 = t9 * t196
  t198 = t189 ** 2
  t199 = 0.1e1 / t198
  t201 = 0.1e1 / t182 / t109
  t202 = t201 * t181
  t204 = t183 * t181
  t208 = -0.1263261066870072384e3 * t202 - 0.450981962748731232e2 * t204 - 0.3577529259576e1 * t186 * t181
  t212 = t9 * r0
  t213 = t181 ** 2
  t218 = t27 ** 2
  t221 = 0.1e1 / t29 / t218 / t40
  t228 = t19 * t20 * t22
  t229 = t114 * t121
  t235 = 0.1e1 / t120 / t87
  t236 = t161 ** 2
  t237 = t235 * t236
  t243 = 0.1e1 / t41 / t61 / t130
  t244 = t22 * t243
  t248 = t33 ** 2
  t249 = 0.1e1 / t248
  t251 = t249 * t59 * s0
  t252 = t61 ** 2
  t259 = 0.1e1 / t42 / t61
  t265 = 0.46913580246913580246913580246913580246913580246914e-3 * t58 * t60 * t243
  t266 = 0.12566666666666666666666666666666666666666666666667e1 * t122 * t244 * t48 - 0.18617283950617283950617283950617283950617283950617e2 * t251 / t252 / t40 * t48 + 0.11e2 / 0.27e2 * t52 * t39 * t259 - t265
  t268 = t139 * t142
  t272 = 0.1e1 / t141 / t84
  t273 = t68 * t272
  t274 = t159 ** 2
  t288 = 0.1e1 / t154 / t153
  t292 = 0.50931481481481481481481481481481481481481481481480e-1 * t72 * t22 / t41 / t130 * t80 + 0.42540156111111111111111111111111111111111111111109e0 * t150 * t38 * t259 * t155 - 0.57449421445821236543209876543209876543209876543208e0 * t122 * t244 * t288 + t265
  t294 = -t143 * t292 - 0.2e1 * t268 * t159 + t266 * t85 + 0.2e1 * t273 * t274
  t295 = t121 * t294
  t300 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 * t221 * t88 * t218 + 0.2e1 / 0.27e2 * t228 * t229 * t27 * t161 + 0.2e1 / 0.9e1 * t21 * t31 * t237 - t21 * t31 * t295 / 0.9e1)
  t301 = t98 ** 2
  t304 = 0.1e1 / t100 / t301 / t40
  t310 = t169 * t121
  t322 = f.my_piecewise3(t96, 0, 0.4e1 / 0.81e2 * t21 * t22 * t304 * t88 * t301 + 0.2e1 / 0.27e2 * t228 * t310 * t98 * t161 + 0.2e1 / 0.9e1 * t21 * t102 * t237 - t21 * t102 * t295 / 0.9e1)
  t324 = f.my_piecewise3(t108, 0, t300 + t322)
  t329 = t212 * t111
  t330 = t181 * t199
  t331 = t330 * t208
  t335 = 0.1e1 / t198 / t189
  t337 = t208 ** 2
  t341 = t196 * t199
  t343 = 0.1e1 / t182 / t110
  t356 = 0.6316305334350361920e3 * t343 * t213 - 0.1263261066870072384e3 * t201 * t324 + 0.1803927850994924928e3 * t201 * t213 - 0.450981962748731232e2 * t183 * t324 + 0.10732587778728e2 * t183 * t213 - 0.3577529259576e1 * t186 * t324
  t361 = f.my_piecewise3(t4, 0, 0.18033154200000000000000000000000000000000000000000e1 * t112 * t191 + 0.50000000000000000000000000000000000000000000000000e0 * t197 * t199 * t208 - 0.18033154200000000000000000000000000000000000000000e1 * t212 * t186 * t213 * t190 + 0.90165771000000000000000000000000000000000000000000e0 * t212 * t111 * t324 * t190 - 0.18033154200000000000000000000000000000000000000000e1 * t329 * t331 - 0.50000000000000000000000000000000000000000000000000e0 * t212 * t196 * t335 * t337 + 0.25000000000000000000000000000000000000000000000000e0 * t212 * t341 * t356)
  t368 = t218 * t27
  t391 = t120 ** 2
  t394 = 0.1e1 / t391 * t236 * t161
  t399 = t161 * t294
  t404 = 0.1e1 / t41 / t252
  t405 = t22 * t404
  t410 = 0.1e1 / t252 / t130
  t414 = t59 ** 2
  t425 = 0.1e1 / t42 / t62
  t431 = 0.34403292181069958847736625514403292181069958847737e-2 * t58 * t60 * t404
  t442 = t141 ** 2
  t464 = t153 ** 2
  t473 = t121 * ((-0.10580823045267489711934156378600823045267489711934e2 * t122 * t405 * t48 + 0.35372839506172839506172839506172839506172839506173e3 * t251 * t410 * t48 - 0.20685871056241426611796982167352537722908093278463e3 * t249 * t414 / t42 / t252 / t62 * t37 * t38 * t48 - 0.154e3 / 0.81e2 * t52 * t39 * t425 + t431) * t85 - 0.3e1 * t266 * t142 * t159 + 0.6e1 * t139 * t272 * t274 - 0.3e1 * t268 * t292 - 0.6e1 * t68 / t442 * t274 * t159 + 0.6e1 * t273 * t159 * t292 - t143 * (-0.16977160493827160493827160493827160493827160493827e0 * t72 * t22 / t41 / t61 * t80 - 0.22499015898765432098765432098765432098765432098764e1 * t150 * t38 * t425 * t155 + 0.70854286449846191736625514403292181069958847736623e1 * t122 * t405 * t288 - 0.69825611693930441054234048790123456790123456790121e2 * t251 * t410 / t154 / t464 - t431))
  t478 = f.my_piecewise3(t13, 0, -0.28e2 / 0.243e3 * t21 * t22 / t29 / t130 * t88 - 0.4e1 / 0.27e2 * t228 * t221 * t121 * t218 * t161 - 0.2e1 / 0.9e1 * t228 * t114 * t235 * t27 * t236 + t228 * t229 * t27 * t294 / 0.9e1 - 0.2e1 / 0.3e1 * t21 * t31 * t394 + 0.2e1 / 0.3e1 * t228 * t30 * t235 * t399 - t21 * t31 * t473 / 0.9e1)
  t479 = t301 * t98
  t513 = f.my_piecewise3(t96, 0, -0.28e2 / 0.243e3 * t21 * t22 / t100 / t130 * t88 - 0.4e1 / 0.27e2 * t228 * t304 * t121 * t301 * t161 - 0.2e1 / 0.9e1 * t228 * t169 * t235 * t98 * t236 + t228 * t310 * t98 * t294 / 0.9e1 - 0.2e1 / 0.3e1 * t21 * t102 * t394 + 0.2e1 / 0.3e1 * t228 * t101 * t235 * t399 - t21 * t102 * t473 / 0.9e1)
  t515 = f.my_piecewise3(t108, 0, t478 + t513)
  t523 = t212 * t186
  t528 = t213 * t181
  t536 = t198 ** 2
  t591 = -0.15000000000000000000000000000000000000000000000000e1 * t212 * t196 * t335 * t208 * t356 + 0.90165771000000000000000000000000000000000000000000e0 * t212 * t111 * t515 * t190 + 0.27049731300000000000000000000000000000000000000000e1 * t112 * t324 * t190 + 0.54099462600000000000000000000000000000000000000000e1 * t523 * t213 * t199 * t208 + 0.54099462600000000000000000000000000000000000000000e1 * t212 * t183 * t528 * t190 - 0.54099462600000000000000000000000000000000000000000e1 * t523 * t191 * t324 + 0.15000000000000000000000000000000000000000000000000e1 * t212 * t196 / t536 * t337 * t208 + 0.25000000000000000000000000000000000000000000000000e0 * t212 * t341 * (-0.37897832006102171520e4 / t182 / t185 * t528 + 0.18948916003051085760e4 * t343 * t181 * t324 - 0.1263261066870072384e3 * t201 * t515 - 0.9019639254974624640e3 * t343 * t528 + 0.5411783552984774784e3 * t202 * t324 - 0.450981962748731232e2 * t183 * t515 - 0.42930351114912e2 * t201 * t528 + 0.32197763336184e2 * t204 * t324 - 0.3577529259576e1 * t186 * t515) + 0.75000000000000000000000000000000000000000000000000e0 * t197 * t199 * t356 + 0.54099462600000000000000000000000000000000000000000e1 * t329 * t181 * t335 * t337 - 0.27049731300000000000000000000000000000000000000000e1 * t329 * t330 * t356 - 0.15000000000000000000000000000000000000000000000000e1 * t197 * t335 * t337 - 0.54099462600000000000000000000000000000000000000000e1 * t112 * t331 - 0.54099462600000000000000000000000000000000000000000e1 * t9 * t186 * t213 * t190 - 0.27049731300000000000000000000000000000000000000000e1 * t329 * t324 * t199 * t208
  t592 = f.my_piecewise3(t4, 0, t591)
  v3rho3_0_ = r0 * t592 + 0.3e1 * t361

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t31 = t22 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = t22 ** 2
  t39 = s0 * t38
  t40 = r0 ** 2
  t41 = r0 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t45 = t39 / t42 / t40
  t46 = t37 * t45
  t48 = jnp.exp(-0.25e2 / 0.6e1 * t46)
  t52 = (0.2743e0 - 0.1508e0 * t48) * t32 * t36
  t55 = t32 ** 2
  t58 = t55 / t34 / t33
  t59 = s0 ** 2
  t60 = t59 * t22
  t61 = t40 ** 2
  t62 = t61 * r0
  t64 = 0.1e1 / t41 / t62
  t67 = 0.13888888888888888888888888888888888888888888888889e-4 * t58 * t60 * t64
  t68 = t52 * t45 / 0.24e2 - t67
  t70 = t55 / t34
  t71 = jnp.sqrt(s0)
  t72 = t70 * t71
  t74 = 0.1e1 / t41 / r0
  t80 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t70 * t71 * t22 * t74)
  t84 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t72 * t22 * t74 * t80 + t67
  t85 = 0.1e1 / t84
  t87 = t68 * t85 + 0.1e1
  t88 = 0.1e1 / t87
  t92 = f.my_piecewise3(t13, 0, t21 * t31 * t88 / 0.9e1)
  t96 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t97 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t98 = 0.1e1 + t97
  t99 = t98 * r0
  t100 = t99 ** (0.1e1 / 0.3e1)
  t101 = 0.1e1 / t100
  t102 = t22 * t101
  t106 = f.my_piecewise3(t96, 0, t21 * t102 * t88 / 0.9e1)
  t107 = t92 + t106
  t108 = t107 == 0.0e0
  t109 = f.my_piecewise3(t108, DBL_EPSILON, t107)
  t110 = t109 ** 2
  t111 = 0.1e1 / t110
  t112 = t9 * t111
  t113 = t27 ** 2
  t116 = 0.1e1 / t29 / t113 / t40
  t123 = t19 * t20 * t22
  t125 = 0.1e1 / t29 / t28
  t126 = t87 ** 2
  t127 = 0.1e1 / t126
  t128 = t125 * t127
  t129 = t58 * t59
  t130 = t61 * t40
  t132 = 0.1e1 / t41 / t130
  t137 = t40 * r0
  t139 = 0.1e1 / t42 / t137
  t145 = 0.74074074074074074074074074074074074074074074074075e-4 * t58 * t60 * t132
  t146 = -0.13962962962962962962962962962962962962962962962963e0 * t129 * t22 * t132 * t48 - t52 * t39 * t139 / 0.9e1 + t145
  t148 = t84 ** 2
  t149 = 0.1e1 / t148
  t150 = t68 * t149
  t157 = t37 * s0
  t160 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t46
  t161 = jnp.sqrt(t160)
  t162 = 0.1e1 / t161
  t166 = -0.21827777777777777777777777777777777777777777777777e-1 * t72 * t22 / t41 / t40 * t80 - 0.85080312222222222222222222222222222222222222222219e-1 * t157 * t38 * t139 * t162 - t145
  t168 = t146 * t85 - t150 * t166
  t169 = t27 * t168
  t174 = 0.1e1 / t126 / t87
  t175 = t168 ** 2
  t176 = t174 * t175
  t182 = 0.1e1 / t41 / t61 / t137
  t183 = t22 * t182
  t187 = t33 ** 2
  t188 = 0.1e1 / t187
  t190 = t188 * t59 * s0
  t191 = t61 ** 2
  t198 = 0.1e1 / t42 / t61
  t204 = 0.46913580246913580246913580246913580246913580246914e-3 * t58 * t60 * t182
  t205 = 0.12566666666666666666666666666666666666666666666667e1 * t129 * t183 * t48 - 0.18617283950617283950617283950617283950617283950617e2 * t190 / t191 / t40 * t48 + 0.11e2 / 0.27e2 * t52 * t39 * t198 - t204
  t207 = t146 * t149
  t211 = 0.1e1 / t148 / t84
  t212 = t68 * t211
  t213 = t166 ** 2
  t227 = 0.1e1 / t161 / t160
  t231 = 0.50931481481481481481481481481481481481481481481480e-1 * t72 * t22 / t41 / t137 * t80 + 0.42540156111111111111111111111111111111111111111109e0 * t157 * t38 * t198 * t162 - 0.57449421445821236543209876543209876543209876543208e0 * t129 * t183 * t227 + t204
  t233 = -t150 * t231 - 0.2e1 * t207 * t166 + t205 * t85 + 0.2e1 * t212 * t213
  t234 = t127 * t233
  t239 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 * t116 * t88 * t113 + 0.2e1 / 0.27e2 * t123 * t128 * t169 + 0.2e1 / 0.9e1 * t21 * t31 * t176 - t21 * t31 * t234 / 0.9e1)
  t240 = t98 ** 2
  t243 = 0.1e1 / t100 / t240 / t40
  t250 = 0.1e1 / t100 / t99
  t251 = t250 * t127
  t252 = t98 * t168
  t263 = f.my_piecewise3(t96, 0, 0.4e1 / 0.81e2 * t21 * t22 * t243 * t88 * t240 + 0.2e1 / 0.27e2 * t123 * t251 * t252 + 0.2e1 / 0.9e1 * t21 * t102 * t176 - t21 * t102 * t234 / 0.9e1)
  t265 = f.my_piecewise3(t108, 0, t239 + t263)
  t266 = t110 ** 2
  t267 = 0.1e1 / t266
  t269 = t110 * t109
  t270 = 0.1e1 / t269
  t273 = 0.315815266717518096e2 * t267 + 0.150327320916243744e2 * t270 + 0.1788764629788e1 * t111
  t274 = 0.1e1 / t273
  t278 = t9 * r0
  t279 = t278 * t111
  t285 = t127 * t168
  t290 = f.my_piecewise3(t13, 0, -t21 * t22 * t125 * t88 * t27 / 0.27e2 - t21 * t31 * t285 / 0.9e1)
  t300 = f.my_piecewise3(t96, 0, -t21 * t22 * t250 * t88 * t98 / 0.27e2 - t21 * t102 * t285 / 0.9e1)
  t302 = f.my_piecewise3(t108, 0, t290 + t300)
  t303 = t273 ** 2
  t304 = 0.1e1 / t303
  t305 = t302 * t304
  t307 = 0.1e1 / t266 / t110
  t308 = t302 ** 2
  t309 = t307 * t308
  t312 = 0.1e1 / t266 / t109
  t315 = t312 * t308
  t323 = 0.6316305334350361920e3 * t309 - 0.1263261066870072384e3 * t312 * t265 + 0.1803927850994924928e3 * t315 - 0.450981962748731232e2 * t267 * t265 + 0.10732587778728e2 * t267 * t308 - 0.3577529259576e1 * t270 * t265
  t324 = t305 * t323
  t327 = t265 * t304
  t328 = t312 * t302
  t330 = t267 * t302
  t334 = -0.1263261066870072384e3 * t328 - 0.450981962748731232e2 * t330 - 0.3577529259576e1 * t270 * t302
  t335 = t327 * t334
  t338 = t278 * t270
  t339 = t308 * t304
  t340 = t339 * t334
  t343 = t308 * t302
  t348 = t302 * t274
  t349 = t348 * t265
  t354 = 0.360663084e1 / t109 + 0.5764e0
  t355 = t278 * t354
  t357 = 0.1e1 / t303 / t273
  t358 = t357 * t334
  t359 = t358 * t323
  t362 = t9 * t354
  t363 = t334 ** 2
  t367 = t303 ** 2
  t368 = 0.1e1 / t367
  t370 = t363 * t334
  t374 = t113 * t27
  t377 = 0.1e1 / t29 / t374 / t137
  t383 = t116 * t127
  t388 = t125 * t174
  t397 = t126 ** 2
  t398 = 0.1e1 / t397
  t399 = t175 * t168
  t400 = t398 * t399
  t404 = t30 * t174
  t405 = t168 * t233
  t410 = 0.1e1 / t41 / t191
  t411 = t22 * t410
  t416 = 0.1e1 / t191 / t137
  t420 = t59 ** 2
  t421 = t188 * t420
  t427 = t37 * t38 * t48
  t431 = 0.1e1 / t42 / t62
  t437 = 0.34403292181069958847736625514403292181069958847737e-2 * t58 * t60 * t410
  t438 = -0.10580823045267489711934156378600823045267489711934e2 * t129 * t411 * t48 + 0.35372839506172839506172839506172839506172839506173e3 * t190 * t416 * t48 - 0.20685871056241426611796982167352537722908093278463e3 * t421 / t42 / t191 / t62 * t427 - 0.154e3 / 0.81e2 * t52 * t39 * t431 + t437
  t440 = t205 * t149
  t443 = t146 * t211
  t448 = t148 ** 2
  t449 = 0.1e1 / t448
  t450 = t68 * t449
  t451 = t213 * t166
  t454 = t166 * t231
  t470 = t160 ** 2
  t472 = 0.1e1 / t161 / t470
  t476 = -0.16977160493827160493827160493827160493827160493827e0 * t72 * t22 / t41 / t61 * t80 - 0.22499015898765432098765432098765432098765432098764e1 * t157 * t38 * t431 * t162 + 0.70854286449846191736625514403292181069958847736623e1 * t129 * t411 * t227 - 0.69825611693930441054234048790123456790123456790121e2 * t190 * t416 * t472 - t437
  t478 = -t150 * t476 - 0.3e1 * t440 * t166 - 0.3e1 * t207 * t231 + 0.6e1 * t212 * t454 + 0.6e1 * t443 * t213 + t438 * t85 - 0.6e1 * t450 * t451
  t479 = t127 * t478
  t484 = f.my_piecewise3(t13, 0, -0.28e2 / 0.243e3 * t21 * t22 * t377 * t88 * t374 - 0.4e1 / 0.27e2 * t123 * t383 * t113 * t168 - 0.2e1 / 0.9e1 * t123 * t388 * t27 * t175 + t123 * t128 * t27 * t233 / 0.9e1 - 0.2e1 / 0.3e1 * t21 * t31 * t400 + 0.2e1 / 0.3e1 * t123 * t404 * t405 - t21 * t31 * t479 / 0.9e1)
  t485 = t240 * t98
  t488 = 0.1e1 / t100 / t485 / t137
  t494 = t243 * t127
  t499 = t250 * t174
  t511 = t101 * t174
  t519 = f.my_piecewise3(t96, 0, -0.28e2 / 0.243e3 * t21 * t22 * t488 * t88 * t485 - 0.4e1 / 0.27e2 * t123 * t494 * t240 * t168 - 0.2e1 / 0.9e1 * t123 * t499 * t98 * t175 + t123 * t251 * t98 * t233 / 0.9e1 - 0.2e1 / 0.3e1 * t21 * t102 * t400 + 0.2e1 / 0.3e1 * t123 * t511 * t405 - t21 * t102 * t479 / 0.9e1)
  t521 = f.my_piecewise3(t108, 0, t484 + t519)
  t529 = t9 * t270
  t530 = t308 * t274
  t533 = t302 * t357
  t534 = t533 * t363
  t537 = t354 * t304
  t539 = 0.1e1 / t266 / t269
  t542 = t307 * t302
  t559 = -0.37897832006102171520e4 * t539 * t343 + 0.18948916003051085760e4 * t542 * t265 - 0.1263261066870072384e3 * t312 * t521 - 0.9019639254974624640e3 * t307 * t343 + 0.5411783552984774784e3 * t328 * t265 - 0.450981962748731232e2 * t267 * t521 - 0.42930351114912e2 * t312 * t343 + 0.32197763336184e2 * t330 * t265 - 0.3577529259576e1 * t270 * t521
  t566 = 0.27049731300000000000000000000000000000000000000000e1 * t112 * t265 * t274 - 0.27049731300000000000000000000000000000000000000000e1 * t279 * t324 - 0.27049731300000000000000000000000000000000000000000e1 * t279 * t335 + 0.54099462600000000000000000000000000000000000000000e1 * t338 * t340 + 0.54099462600000000000000000000000000000000000000000e1 * t278 * t267 * t343 * t274 - 0.54099462600000000000000000000000000000000000000000e1 * t338 * t349 - 0.15000000000000000000000000000000000000000000000000e1 * t355 * t359 - 0.15000000000000000000000000000000000000000000000000e1 * t362 * t357 * t363 + 0.15000000000000000000000000000000000000000000000000e1 * t278 * t354 * t368 * t370 + 0.90165771000000000000000000000000000000000000000000e0 * t278 * t111 * t521 * t274 - 0.54099462600000000000000000000000000000000000000000e1 * t112 * t305 * t334 - 0.54099462600000000000000000000000000000000000000000e1 * t529 * t530 + 0.54099462600000000000000000000000000000000000000000e1 * t279 * t534 + 0.25000000000000000000000000000000000000000000000000e0 * t278 * t537 * t559 + 0.75000000000000000000000000000000000000000000000000e0 * t362 * t304 * t323
  t567 = f.my_piecewise3(t4, 0, t566)
  t611 = t278 * t267
  t623 = 0.10000000000000000000000000000000000000000000000000e1 * t362 * t304 * t559 + 0.36066308400000000000000000000000000000000000000000e1 * t112 * t521 * t274 + 0.21639785040000000000000000000000000000000000000000e2 * t9 * t267 * t343 * t274 + 0.90000000000000000000000000000000000000000000000000e1 * t355 * t368 * t363 * t323 - 0.21639785040000000000000000000000000000000000000000e2 * t279 * t302 * t368 * t370 - 0.36066308400000000000000000000000000000000000000000e1 * t279 * t521 * t304 * t334 + 0.21639785040000000000000000000000000000000000000000e2 * t338 * t327 * t334 * t302 + 0.21639785040000000000000000000000000000000000000000e2 * t279 * t533 * t323 * t334 - 0.36066308400000000000000000000000000000000000000000e1 * t279 * t305 * t559 + 0.60000000000000000000000000000000000000000000000000e1 * t362 * t368 * t370 - 0.54099462600000000000000000000000000000000000000000e1 * t279 * t327 * t323 - 0.20000000000000000000000000000000000000000000000000e1 * t355 * t358 * t559 - 0.21639785040000000000000000000000000000000000000000e2 * t611 * t343 * t304 * t334 - 0.21639785040000000000000000000000000000000000000000e2 * t338 * t308 * t357 * t363 - 0.72132616800000000000000000000000000000000000000000e1 * t338 * t348 * t521
  t637 = t323 ** 2
  t641 = t265 ** 2
  t646 = t266 ** 2
  t648 = t308 ** 2
  t658 = t113 ** 2
  t696 = t175 ** 2
  t697 = 0.1e1 / t397 / t87 * t696
  t702 = t175 * t233
  t706 = t233 ** 2
  t707 = t174 * t706
  t711 = t168 * t478
  t717 = 0.1e1 / t41 / t191 / r0
  t718 = t22 * t717
  t723 = 0.1e1 / t191 / t61
  t730 = t421 / t42 / t191 / t130
  t735 = t191 ** 2
  t745 = 0.1e1 / t42 / t130
  t751 = 0.28669410150891632373113854595336076817558299039781e-1 * t58 * t60 * t717
  t772 = t213 ** 2
  t778 = t231 ** 2
  t808 = (0.94544773662551440329218106995884773662551440329217e2 * t129 * t718 * t48 - 0.53017887517146776406035665294924554183813443072702e4 * t190 * t723 * t48 + 0.67573845450388660265203475080018289894833104709647e4 * t730 * t427 - 0.45968602347203170248437738149672306050906873952140e4 * t188 * t420 * s0 / t41 / t735 / r0 * t58 * t22 * t48 + 0.2618e4 / 0.243e3 * t52 * t39 * t745 - t751) * t85 - 0.4e1 * t438 * t149 * t166 + 0.12e2 * t205 * t211 * t213 - 0.6e1 * t440 * t231 - 0.24e2 * t146 * t449 * t451 + 0.24e2 * t443 * t454 - 0.4e1 * t207 * t476 + 0.24e2 * t68 / t448 / t84 * t772 - 0.36e2 * t450 * t213 * t231 + 0.6e1 * t212 * t778 + 0.8e1 * t212 * t166 * t476 - t150 * (0.73567695473251028806584362139917695473251028806584e0 * t72 * t22 * t64 * t80 + 0.13631756691604938271604938271604938271604938271604e2 * t157 * t38 * t745 * t162 - 0.74237419046100108999725651577503429355281207133056e2 * t129 * t718 * t227 + 0.16292642728583769579321278051028806584362139917695e4 * t190 * t723 * t472 - 0.11787218714710830674330488092370393371742112482853e4 * t730 / t161 / t470 / t160 * t32 * t36 * t38 + t751)
  t809 = t127 * t808
  t813 = 0.280e3 / 0.729e3 * t21 * t22 / t29 / t61 * t88 + 0.112e3 / 0.243e3 * t123 * t377 * t127 * t374 * t168 + 0.16e2 / 0.27e2 * t123 * t116 * t174 * t113 * t175 - 0.8e1 / 0.27e2 * t123 * t383 * t113 * t233 + 0.8e1 / 0.9e1 * t123 * t125 * t398 * t27 * t399 - 0.8e1 / 0.9e1 * t123 * t388 * t169 * t233 + 0.4e1 / 0.27e2 * t123 * t128 * t27 * t478 + 0.8e1 / 0.3e1 * t21 * t31 * t697 - 0.4e1 * t123 * t30 * t398 * t702 + 0.2e1 / 0.3e1 * t21 * t31 * t707 + 0.8e1 / 0.9e1 * t123 * t404 * t711 - t21 * t31 * t809 / 0.9e1
  t814 = f.my_piecewise3(t13, 0, t813)
  t815 = t240 ** 2
  t867 = 0.280e3 / 0.729e3 * t21 * t22 / t100 / t61 * t88 + 0.112e3 / 0.243e3 * t123 * t488 * t127 * t485 * t168 + 0.16e2 / 0.27e2 * t123 * t243 * t174 * t240 * t175 - 0.8e1 / 0.27e2 * t123 * t494 * t240 * t233 + 0.8e1 / 0.9e1 * t123 * t250 * t398 * t98 * t399 - 0.8e1 / 0.9e1 * t123 * t499 * t252 * t233 + 0.4e1 / 0.27e2 * t123 * t251 * t98 * t478 + 0.8e1 / 0.3e1 * t21 * t102 * t697 - 0.4e1 * t123 * t101 * t398 * t702 + 0.2e1 / 0.3e1 * t21 * t102 * t707 + 0.8e1 / 0.9e1 * t123 * t511 * t711 - t21 * t102 * t809 / 0.9e1
  t868 = f.my_piecewise3(t96, 0, t867)
  t870 = f.my_piecewise3(t108, 0, t814 + t868)
  t893 = 0.265284824042715200640e5 / t646 * t648 - 0.227386992036613029120e5 * t539 * t308 * t265 + 0.18948916003051085760e4 * t307 * t641 + 0.25265221337401447680e4 * t542 * t521 - 0.1263261066870072384e3 * t312 * t870 + 0.54117835529847747840e4 * t539 * t648 - 0.54117835529847747840e4 * t309 * t265 + 0.5411783552984774784e3 * t312 * t641 + 0.7215711403979699712e3 * t328 * t521 - 0.450981962748731232e2 * t267 * t870 + 0.214651755574560e3 * t307 * t648 - 0.257582106689472e3 * t315 * t265 + 0.32197763336184e2 * t267 * t641 + 0.42930351114912e2 * t330 * t521 - 0.3577529259576e1 * t270 * t870
  t900 = t363 ** 2
  t922 = 0.32459677560000000000000000000000000000000000000000e2 * t611 * t530 * t265 + 0.10819892520000000000000000000000000000000000000000e2 * t338 * t339 * t323 + 0.10819892520000000000000000000000000000000000000000e2 * t279 * t265 * t357 * t363 - 0.21639785040000000000000000000000000000000000000000e2 * t529 * t349 - 0.15000000000000000000000000000000000000000000000000e1 * t278 * t354 * t357 * t637 - 0.54099462600000000000000000000000000000000000000000e1 * t278 * t270 * t641 * t274 + 0.25000000000000000000000000000000000000000000000000e0 * t278 * t537 * t893 - 0.60000000000000000000000000000000000000000000000000e1 * t278 * t354 / t367 / t273 * t900 - 0.21639785040000000000000000000000000000000000000000e2 * t278 * t312 * t648 * t274 + 0.90165771000000000000000000000000000000000000000000e0 * t278 * t111 * t870 * t274 + 0.21639785040000000000000000000000000000000000000000e2 * t112 * t534 - 0.10819892520000000000000000000000000000000000000000e2 * t112 * t335 - 0.10819892520000000000000000000000000000000000000000e2 * t112 * t324 - 0.60000000000000000000000000000000000000000000000000e1 * t362 * t359 + 0.21639785040000000000000000000000000000000000000000e2 * t529 * t340
  t924 = f.my_piecewise3(t4, 0, t623 + t922)
  v4rho4_0_ = r0 * t924 + 0.4e1 * t567

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t2 ** 2
  t20 = 0.1e1 / t19
  t21 = t1 * t20
  t22 = t3 - t21
  t23 = f.my_piecewise5(t13, 0, t16, 0, t22)
  t24 = t18 * t23
  t27 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t30 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t31 = f.my_piecewise5(t27, t14, t30, t17, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t37 / t39
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t14, t47, t17, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t53 = t44 / t51
  t54 = 6 ** (0.1e1 / 0.3e1)
  t55 = jnp.pi ** 2
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t54 * t58
  t60 = r0 ** 2
  t61 = r0 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t64 = 0.1e1 / t62 / t60
  t66 = t59 * s0 * t64
  t68 = jnp.exp(-0.25e2 / 0.6e1 * t66)
  t71 = (0.2743e0 - 0.1508e0 * t68) * t54
  t72 = t58 * s0
  t76 = t54 ** 2
  t79 = t76 / t56 / t55
  t80 = s0 ** 2
  t81 = t60 ** 2
  t87 = 0.69444444444444444444444444444444444444444444444444e-5 * t79 * t80 / t61 / t81 / r0
  t88 = t71 * t72 * t64 / 0.24e2 - t87
  t90 = t76 / t56
  t91 = jnp.sqrt(s0)
  t94 = t91 / t61 / r0
  t97 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t90 * t94)
  t101 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t90 * t94 * t97 + t87
  t102 = 0.1e1 / t101
  t104 = t88 * t102 + 0.1e1
  t105 = 0.1e1 / t104
  t109 = f.my_piecewise3(t35, 0, t43 * t53 * t105 / 0.9e1)
  t113 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t114 = f.my_piecewise5(t47, t14, t45, t17, -t31)
  t115 = 0.1e1 + t114
  t116 = t115 * t2
  t117 = t116 ** (0.1e1 / 0.3e1)
  t119 = t44 / t117
  t120 = r1 ** 2
  t121 = r1 ** (0.1e1 / 0.3e1)
  t122 = t121 ** 2
  t124 = 0.1e1 / t122 / t120
  t126 = t59 * s2 * t124
  t128 = jnp.exp(-0.25e2 / 0.6e1 * t126)
  t131 = (0.2743e0 - 0.1508e0 * t128) * t54
  t132 = t58 * s2
  t136 = s2 ** 2
  t137 = t120 ** 2
  t143 = 0.69444444444444444444444444444444444444444444444444e-5 * t79 * t136 / t121 / t137 / r1
  t144 = t131 * t132 * t124 / 0.24e2 - t143
  t145 = jnp.sqrt(s2)
  t148 = t145 / t121 / r1
  t151 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t90 * t148)
  t155 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t90 * t148 * t151 + t143
  t156 = 0.1e1 / t155
  t158 = t144 * t156 + 0.1e1
  t159 = 0.1e1 / t158
  t163 = f.my_piecewise3(t113, 0, t43 * t119 * t159 / 0.9e1)
  t164 = t109 + t163
  t165 = t164 == 0.0e0
  t166 = f.my_piecewise3(t165, DBL_EPSILON, t164)
  t169 = 0.360663084e1 / t166 + 0.5764e0
  t171 = t166 ** 2
  t172 = t171 ** 2
  t173 = 0.1e1 / t172
  t176 = 0.1e1 / t171 / t166
  t178 = 0.1e1 / t171
  t180 = 0.315815266717518096e2 * t173 + 0.150327320916243744e2 * t176 + 0.1788764629788e1 * t178
  t181 = 0.1e1 / t180
  t182 = t2 * t169 * t181
  t185 = t18 ** 2
  t186 = 0.1e1 - t185
  t187 = t186 * t169
  t189 = 0.25000000000000000000000000000000000000000000000000e0 * t187 * t181
  t190 = t186 * t2
  t192 = 0.1e1 / t51 / t50
  t193 = t44 * t192
  t194 = f.my_piecewise5(t27, 0, t30, 0, t22)
  t195 = f.my_piecewise5(t45, 0, t47, 0, t194)
  t197 = t195 * t2 + t48 + 0.1e1
  t202 = t104 ** 2
  t203 = 0.1e1 / t202
  t207 = t80 / t61 / t81 / t60
  t211 = t60 * r0
  t213 = 0.1e1 / t62 / t211
  t218 = 0.37037037037037037037037037037037037037037037037037e-4 * t79 * t207
  t219 = -0.69814814814814814814814814814814814814814814814817e-1 * t79 * t207 * t68 - t71 * t72 * t213 / 0.9e1 + t218
  t221 = t101 ** 2
  t222 = 0.1e1 / t221
  t223 = t88 * t222
  t232 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t66
  t233 = jnp.sqrt(t232)
  t234 = 0.1e1 / t233
  t238 = -0.21827777777777777777777777777777777777777777777777e-1 * t90 * t91 / t61 / t60 * t97 - 0.85080312222222222222222222222222222222222222222219e-1 * t59 * s0 * t213 * t234 - t218
  t240 = t219 * t102 - t223 * t238
  t246 = f.my_piecewise3(t35, 0, -t43 * t193 * t105 * t197 / 0.27e2 - t43 * t53 * t203 * t240 / 0.9e1)
  t248 = 0.1e1 / t117 / t116
  t249 = t44 * t248
  t250 = f.my_piecewise5(t47, 0, t45, 0, -t194)
  t252 = t250 * t2 + t114 + 0.1e1
  t257 = f.my_piecewise3(t113, 0, -t43 * t249 * t159 * t252 / 0.27e2)
  t259 = f.my_piecewise3(t165, 0, t246 + t257)
  t261 = t178 * t259 * t181
  t264 = t180 ** 2
  t265 = 0.1e1 / t264
  t266 = t169 * t265
  t268 = 0.1e1 / t172 / t166
  t275 = -0.1263261066870072384e3 * t268 * t259 - 0.450981962748731232e2 * t173 * t259 - 0.3577529259576e1 * t176 * t259
  t276 = t266 * t275
  t280 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t24 * t182 - t189 + 0.90165771000000000000000000000000000000000000000000e0 * t190 * t261 + 0.25000000000000000000000000000000000000000000000000e0 * t190 * t276)
  t282 = t23 ** 2
  t284 = t169 * t181
  t289 = t1 / t19 / t2
  t291 = -0.2e1 * t20 + 0.2e1 * t289
  t292 = f.my_piecewise5(t13, 0, t16, 0, t291)
  t296 = t24 * t284
  t298 = t24 * t2
  t303 = t186 * t178
  t305 = t303 * t259 * t181
  t308 = t187 * t265 * t275
  t310 = t259 ** 2
  t315 = t49 ** 2
  t318 = 0.1e1 / t51 / t315 / t19
  t319 = t44 * t318
  t320 = t197 ** 2
  t326 = t41 * t42 * t44
  t327 = t192 * t203
  t332 = f.my_piecewise5(t27, 0, t30, 0, t291)
  t333 = f.my_piecewise5(t45, 0, t47, 0, t332)
  t343 = t240 ** 2
  t351 = t80 / t61 / t81 / t211
  t355 = t55 ** 2
  t356 = 0.1e1 / t355
  t359 = t81 ** 2
  t366 = 0.1e1 / t62 / t81
  t371 = 0.23456790123456790123456790123456790123456790123457e-3 * t79 * t351
  t380 = t238 ** 2
  t406 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t319 * t105 * t320 + 0.2e1 / 0.27e2 * t326 * t327 * t197 * t240 - t43 * t193 * t105 * (t333 * t2 + 0.2e1 * t195) / 0.27e2 + 0.2e1 / 0.9e1 * t43 * t53 / t202 / t104 * t343 - t43 * t53 * t203 * ((0.62833333333333333333333333333333333333333333333335e0 * t79 * t351 * t68 - 0.46543209876543209876543209876543209876543209876545e1 * t356 * t80 * s0 / t359 / t60 * t68 + 0.11e2 / 0.27e2 * t71 * t72 * t366 - t371) * t102 - 0.2e1 * t219 * t222 * t238 + 0.2e1 * t88 / t221 / t101 * t380 - t223 * (0.50931481481481481481481481481481481481481481481480e-1 * t90 * t91 / t61 / t211 * t97 + 0.42540156111111111111111111111111111111111111111109e0 * t59 * s0 * t366 * t234 - 0.28724710722910618271604938271604938271604938271604e0 * t79 * t351 / t233 / t232 + t371)) / 0.9e1)
  t407 = t115 ** 2
  t410 = 0.1e1 / t117 / t407 / t19
  t411 = t44 * t410
  t412 = t252 ** 2
  t417 = f.my_piecewise5(t47, 0, t45, 0, -t332)
  t426 = f.my_piecewise3(t113, 0, 0.4e1 / 0.81e2 * t43 * t411 * t159 * t412 - t43 * t249 * t159 * (t417 * t2 + 0.2e1 * t250) / 0.27e2)
  t428 = f.my_piecewise3(t165, 0, t406 + t426)
  t433 = t190 * t178
  t434 = t259 * t265
  t439 = 0.1e1 / t264 / t180
  t440 = t169 * t439
  t441 = t275 ** 2
  t446 = 0.1e1 / t172 / t171
  t463 = 0.50000000000000000000000000000000000000000000000000e0 * t282 * t2 * t284 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t292 * t182 + 0.10000000000000000000000000000000000000000000000000e1 * t296 - 0.36066308400000000000000000000000000000000000000000e1 * t298 * t261 - 0.10000000000000000000000000000000000000000000000000e1 * t298 * t276 + 0.18033154200000000000000000000000000000000000000000e1 * t305 + 0.50000000000000000000000000000000000000000000000000e0 * t308 - 0.18033154200000000000000000000000000000000000000000e1 * t190 * t176 * t310 * t181 + 0.90165771000000000000000000000000000000000000000000e0 * t190 * t178 * t428 * t181 - 0.18033154200000000000000000000000000000000000000000e1 * t433 * t434 * t275 - 0.50000000000000000000000000000000000000000000000000e0 * t190 * t440 * t441 + 0.25000000000000000000000000000000000000000000000000e0 * t190 * t266 * (0.6316305334350361920e3 * t446 * t310 - 0.1263261066870072384e3 * t268 * t428 + 0.1803927850994924928e3 * t268 * t310 - 0.450981962748731232e2 * t173 * t428 + 0.10732587778728e2 * t173 * t310 - 0.3577529259576e1 * t176 * t428)
  t464 = f.my_piecewise3(t11, 0, t463)
  d11 = t2 * t464 + 0.2e1 * t280
  t466 = -t3 - t21
  t467 = f.my_piecewise5(t13, 0, t16, 0, t466)
  t468 = t18 * t467
  t471 = f.my_piecewise5(t27, 0, t30, 0, t466)
  t472 = f.my_piecewise5(t45, 0, t47, 0, t471)
  t474 = t472 * t2 + t48 + 0.1e1
  t479 = f.my_piecewise3(t35, 0, -t43 * t193 * t105 * t474 / 0.27e2)
  t480 = f.my_piecewise5(t47, 0, t45, 0, -t471)
  t482 = t480 * t2 + t114 + 0.1e1
  t487 = t158 ** 2
  t488 = 0.1e1 / t487
  t492 = t136 / t121 / t137 / t120
  t496 = t120 * r1
  t498 = 0.1e1 / t122 / t496
  t503 = 0.37037037037037037037037037037037037037037037037037e-4 * t79 * t492
  t504 = -0.69814814814814814814814814814814814814814814814817e-1 * t79 * t492 * t128 - t131 * t132 * t498 / 0.9e1 + t503
  t506 = t155 ** 2
  t507 = 0.1e1 / t506
  t508 = t144 * t507
  t517 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t126
  t518 = jnp.sqrt(t517)
  t519 = 0.1e1 / t518
  t523 = -0.21827777777777777777777777777777777777777777777777e-1 * t90 * t145 / t121 / t120 * t151 - 0.85080312222222222222222222222222222222222222222219e-1 * t59 * s2 * t498 * t519 - t503
  t525 = t504 * t156 - t508 * t523
  t531 = f.my_piecewise3(t113, 0, -t43 * t249 * t159 * t482 / 0.27e2 - t43 * t119 * t488 * t525 / 0.9e1)
  t533 = f.my_piecewise3(t165, 0, t479 + t531)
  t535 = t178 * t533 * t181
  t538 = t268 * t533
  t540 = t173 * t533
  t544 = -0.1263261066870072384e3 * t538 - 0.450981962748731232e2 * t540 - 0.3577529259576e1 * t176 * t533
  t545 = t266 * t544
  t549 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t468 * t182 - t189 + 0.90165771000000000000000000000000000000000000000000e0 * t190 * t535 + 0.25000000000000000000000000000000000000000000000000e0 * t190 * t545)
  t553 = 0.2e1 * t289
  t554 = f.my_piecewise5(t13, 0, t16, 0, t553)
  t558 = t468 * t284
  t560 = t468 * t2
  t570 = t533 * t181
  t571 = t303 * t570
  t586 = f.my_piecewise5(t27, 0, t30, 0, t553)
  t587 = f.my_piecewise5(t45, 0, t47, 0, t586)
  t595 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t326 * t318 * t105 * t474 * t197 + t326 * t327 * t474 * t240 / 0.27e2 - t43 * t193 * t105 * (t587 * t2 + t195 + t472) / 0.27e2)
  t601 = f.my_piecewise5(t47, 0, t45, 0, -t586)
  t608 = t248 * t488
  t614 = f.my_piecewise3(t113, 0, 0.4e1 / 0.81e2 * t326 * t410 * t159 * t482 * t252 - t43 * t249 * t159 * (t601 * t2 + t250 + t480) / 0.27e2 + t326 * t608 * t525 * t252 / 0.27e2)
  t616 = f.my_piecewise3(t165, 0, t595 + t614)
  t621 = t533 * t265
  t628 = t187 * t265 * t544
  t655 = 0.50000000000000000000000000000000000000000000000000e0 * t23 * t467 * t182 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t554 * t182 + 0.50000000000000000000000000000000000000000000000000e0 * t558 - 0.18033154200000000000000000000000000000000000000000e1 * t560 * t261 - 0.50000000000000000000000000000000000000000000000000e0 * t560 * t276 + 0.50000000000000000000000000000000000000000000000000e0 * t296 + 0.90165771000000000000000000000000000000000000000000e0 * t305 + 0.25000000000000000000000000000000000000000000000000e0 * t308 - 0.18033154200000000000000000000000000000000000000000e1 * t298 * t535 + 0.90165771000000000000000000000000000000000000000000e0 * t571 - 0.18033154200000000000000000000000000000000000000000e1 * t190 * t176 * t570 * t259 + 0.90165771000000000000000000000000000000000000000000e0 * t190 * t178 * t616 * t181 - 0.90165771000000000000000000000000000000000000000000e0 * t433 * t621 * t275 - 0.50000000000000000000000000000000000000000000000000e0 * t298 * t545 + 0.25000000000000000000000000000000000000000000000000e0 * t628 - 0.90165771000000000000000000000000000000000000000000e0 * t433 * t434 * t544 - 0.50000000000000000000000000000000000000000000000000e0 * t190 * t169 * t439 * t544 * t275 + 0.25000000000000000000000000000000000000000000000000e0 * t190 * t266 * (0.6316305334350361920e3 * t446 * t533 * t259 - 0.1263261066870072384e3 * t268 * t616 + 0.1803927850994924928e3 * t538 * t259 - 0.450981962748731232e2 * t173 * t616 + 0.10732587778728e2 * t540 * t259 - 0.3577529259576e1 * t176 * t616)
  t656 = f.my_piecewise3(t11, 0, t655)
  d12 = t2 * t656 + t280 + t549
  t659 = t467 ** 2
  t664 = 0.2e1 * t20 + 0.2e1 * t289
  t665 = f.my_piecewise5(t13, 0, t16, 0, t664)
  t676 = t533 ** 2
  t681 = t474 ** 2
  t686 = f.my_piecewise5(t27, 0, t30, 0, t664)
  t687 = f.my_piecewise5(t45, 0, t47, 0, t686)
  t696 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t319 * t105 * t681 - t43 * t193 * t105 * (t687 * t2 + 0.2e1 * t472) / 0.27e2)
  t697 = t482 ** 2
  t706 = f.my_piecewise5(t47, 0, t45, 0, -t686)
  t716 = t525 ** 2
  t724 = t136 / t121 / t137 / t496
  t730 = t137 ** 2
  t737 = 0.1e1 / t122 / t137
  t742 = 0.23456790123456790123456790123456790123456790123457e-3 * t79 * t724
  t751 = t523 ** 2
  t777 = f.my_piecewise3(t113, 0, 0.4e1 / 0.81e2 * t43 * t411 * t159 * t697 + 0.2e1 / 0.27e2 * t326 * t608 * t482 * t525 - t43 * t249 * t159 * (t706 * t2 + 0.2e1 * t480) / 0.27e2 + 0.2e1 / 0.9e1 * t43 * t119 / t487 / t158 * t716 - t43 * t119 * t488 * ((0.62833333333333333333333333333333333333333333333335e0 * t79 * t724 * t128 - 0.46543209876543209876543209876543209876543209876545e1 * t356 * t136 * s2 / t730 / t120 * t128 + 0.11e2 / 0.27e2 * t131 * t132 * t737 - t742) * t156 - 0.2e1 * t504 * t507 * t523 + 0.2e1 * t144 / t506 / t155 * t751 - t508 * (0.50931481481481481481481481481481481481481481481480e-1 * t90 * t145 / t121 / t496 * t151 + 0.42540156111111111111111111111111111111111111111109e0 * t59 * s2 * t737 * t519 - 0.28724710722910618271604938271604938271604938271604e0 * t79 * t724 / t518 / t517 + t742)) / 0.9e1)
  t779 = f.my_piecewise3(t165, 0, t696 + t777)
  t787 = t544 ** 2
  t807 = 0.50000000000000000000000000000000000000000000000000e0 * t659 * t2 * t284 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t665 * t182 + 0.10000000000000000000000000000000000000000000000000e1 * t558 - 0.36066308400000000000000000000000000000000000000000e1 * t560 * t535 - 0.10000000000000000000000000000000000000000000000000e1 * t560 * t545 + 0.18033154200000000000000000000000000000000000000000e1 * t571 + 0.50000000000000000000000000000000000000000000000000e0 * t628 - 0.18033154200000000000000000000000000000000000000000e1 * t190 * t176 * t676 * t181 + 0.90165771000000000000000000000000000000000000000000e0 * t190 * t178 * t779 * t181 - 0.18033154200000000000000000000000000000000000000000e1 * t433 * t621 * t544 - 0.50000000000000000000000000000000000000000000000000e0 * t190 * t440 * t787 + 0.25000000000000000000000000000000000000000000000000e0 * t190 * t266 * (0.6316305334350361920e3 * t446 * t676 - 0.1263261066870072384e3 * t268 * t779 + 0.1803927850994924928e3 * t268 * t676 - 0.450981962748731232e2 * t173 * t779 + 0.10732587778728e2 * t173 * t676 - 0.3577529259576e1 * t176 * t779)
  t808 = f.my_piecewise3(t11, 0, t807)
  d22 = t2 * t808 + 0.2e1 * t549
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t15 = 0.1e1 - t4 <= f.p.zeta_threshold
  t16 = t2 ** 2
  t17 = 0.1e1 / t16
  t19 = -t1 * t17 + t3
  t20 = f.my_piecewise5(t13, 0, t15, 0, t19)
  t21 = t20 ** 2
  t22 = t21 * t2
  t25 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t26 = f.p.zeta_threshold - 0.1e1
  t29 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t30 = -t26
  t31 = f.my_piecewise5(t25, t26, t29, t30, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t37 / t39
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t26, t47, t30, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / t51
  t53 = t44 * t52
  t54 = 6 ** (0.1e1 / 0.3e1)
  t55 = jnp.pi ** 2
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t54 * t58
  t60 = r0 ** 2
  t61 = r0 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t64 = 0.1e1 / t62 / t60
  t66 = t59 * s0 * t64
  t68 = jnp.exp(-0.25e2 / 0.6e1 * t66)
  t71 = (0.2743e0 - 0.1508e0 * t68) * t54
  t72 = t58 * s0
  t76 = t54 ** 2
  t79 = t76 / t56 / t55
  t80 = s0 ** 2
  t81 = t60 ** 2
  t82 = t81 * r0
  t87 = 0.69444444444444444444444444444444444444444444444444e-5 * t79 * t80 / t61 / t82
  t88 = t71 * t72 * t64 / 0.24e2 - t87
  t90 = t76 / t56
  t91 = jnp.sqrt(s0)
  t94 = t91 / t61 / r0
  t97 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t90 * t94)
  t101 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t90 * t94 * t97 + t87
  t102 = 0.1e1 / t101
  t104 = t88 * t102 + 0.1e1
  t105 = 0.1e1 / t104
  t109 = f.my_piecewise3(t35, 0, t43 * t53 * t105 / 0.9e1)
  t113 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t114 = f.my_piecewise5(t47, t26, t45, t30, -t31)
  t115 = 0.1e1 + t114
  t116 = t115 * t2
  t117 = t116 ** (0.1e1 / 0.3e1)
  t120 = r1 ** 2
  t121 = r1 ** (0.1e1 / 0.3e1)
  t122 = t121 ** 2
  t124 = 0.1e1 / t122 / t120
  t128 = jnp.exp(-0.25e2 / 0.6e1 * t59 * s2 * t124)
  t136 = s2 ** 2
  t137 = t120 ** 2
  t143 = 0.69444444444444444444444444444444444444444444444444e-5 * t79 * t136 / t121 / t137 / r1
  t145 = jnp.sqrt(s2)
  t148 = t145 / t121 / r1
  t151 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t90 * t148)
  t159 = 0.1e1 / (0.1e1 + ((0.2743e0 - 0.1508e0 * t128) * t54 * t58 * s2 * t124 / 0.24e2 - t143) / (0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t90 * t148 * t151 + t143))
  t163 = f.my_piecewise3(t113, 0, t43 * t44 / t117 * t159 / 0.9e1)
  t164 = t109 + t163
  t165 = t164 == 0.0e0
  t166 = f.my_piecewise3(t165, DBL_EPSILON, t164)
  t169 = 0.360663084e1 / t166 + 0.5764e0
  t170 = t166 ** 2
  t171 = t170 ** 2
  t172 = 0.1e1 / t171
  t174 = t170 * t166
  t175 = 0.1e1 / t174
  t177 = 0.1e1 / t170
  t179 = 0.315815266717518096e2 * t172 + 0.150327320916243744e2 * t175 + 0.1788764629788e1 * t177
  t180 = 0.1e1 / t179
  t181 = t169 * t180
  t184 = f.my_piecewise5(t13, t26, t15, t30, t4)
  t185 = t16 * t2
  t186 = 0.1e1 / t185
  t189 = 0.2e1 * t1 * t186 - 0.2e1 * t17
  t190 = f.my_piecewise5(t13, 0, t15, 0, t189)
  t191 = t184 * t190
  t193 = t2 * t169 * t180
  t196 = t184 * t20
  t199 = t196 * t2
  t201 = 0.1e1 / t51 / t50
  t202 = t44 * t201
  t203 = f.my_piecewise5(t25, 0, t29, 0, t19)
  t204 = f.my_piecewise5(t45, 0, t47, 0, t203)
  t206 = t204 * t2 + t48 + 0.1e1
  t211 = t104 ** 2
  t212 = 0.1e1 / t211
  t216 = t80 / t61 / t81 / t60
  t220 = t60 * r0
  t222 = 0.1e1 / t62 / t220
  t227 = 0.37037037037037037037037037037037037037037037037037e-4 * t79 * t216
  t228 = -0.69814814814814814814814814814814814814814814814817e-1 * t79 * t216 * t68 - t71 * t72 * t222 / 0.9e1 + t227
  t230 = t101 ** 2
  t231 = 0.1e1 / t230
  t232 = t88 * t231
  t241 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t66
  t242 = jnp.sqrt(t241)
  t243 = 0.1e1 / t242
  t247 = -0.21827777777777777777777777777777777777777777777777e-1 * t90 * t91 / t61 / t60 * t97 - 0.85080312222222222222222222222222222222222222222219e-1 * t59 * s0 * t222 * t243 - t227
  t249 = t228 * t102 - t232 * t247
  t255 = f.my_piecewise3(t35, 0, -t43 * t202 * t105 * t206 / 0.27e2 - t43 * t53 * t212 * t249 / 0.9e1)
  t258 = t44 / t117 / t116
  t259 = f.my_piecewise5(t47, 0, t45, 0, -t203)
  t261 = t259 * t2 + t114 + 0.1e1
  t266 = f.my_piecewise3(t113, 0, -t43 * t258 * t159 * t261 / 0.27e2)
  t268 = f.my_piecewise3(t165, 0, t255 + t266)
  t269 = t177 * t268
  t270 = t269 * t180
  t273 = t179 ** 2
  t274 = 0.1e1 / t273
  t275 = t169 * t274
  t277 = 0.1e1 / t171 / t166
  t278 = t277 * t268
  t280 = t172 * t268
  t284 = -0.1263261066870072384e3 * t278 - 0.450981962748731232e2 * t280 - 0.3577529259576e1 * t175 * t268
  t285 = t275 * t284
  t288 = t184 ** 2
  t289 = 0.1e1 - t288
  t290 = t289 * t177
  t291 = t268 * t180
  t294 = t289 * t169
  t295 = t274 * t284
  t298 = t289 * t2
  t299 = t268 ** 2
  t301 = t175 * t299 * t180
  t304 = t49 ** 2
  t307 = 0.1e1 / t51 / t304 / t16
  t309 = t206 ** 2
  t315 = t41 * t42 * t44
  t316 = t201 * t212
  t321 = f.my_piecewise5(t25, 0, t29, 0, t189)
  t322 = f.my_piecewise5(t45, 0, t47, 0, t321)
  t325 = t322 * t2 + 0.2e1 * t204
  t331 = 0.1e1 / t211 / t104
  t332 = t249 ** 2
  t340 = t80 / t61 / t81 / t220
  t344 = t55 ** 2
  t345 = 0.1e1 / t344
  t347 = t345 * t80 * s0
  t348 = t81 ** 2
  t355 = 0.1e1 / t62 / t81
  t360 = 0.23456790123456790123456790123456790123456790123457e-3 * t79 * t340
  t361 = 0.62833333333333333333333333333333333333333333333335e0 * t79 * t340 * t68 - 0.46543209876543209876543209876543209876543209876545e1 * t347 / t348 / t60 * t68 + 0.11e2 / 0.27e2 * t71 * t72 * t355 - t360
  t363 = t228 * t231
  t367 = 0.1e1 / t230 / t101
  t368 = t88 * t367
  t369 = t247 ** 2
  t383 = 0.1e1 / t242 / t241
  t387 = 0.50931481481481481481481481481481481481481481481480e-1 * t90 * t91 / t61 / t220 * t97 + 0.42540156111111111111111111111111111111111111111109e0 * t59 * s0 * t355 * t243 - 0.28724710722910618271604938271604938271604938271604e0 * t79 * t340 * t383 + t360
  t389 = t361 * t102 - t232 * t387 - 0.2e1 * t363 * t247 + 0.2e1 * t368 * t369
  t395 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t44 * t307 * t105 * t309 + 0.2e1 / 0.27e2 * t315 * t316 * t206 * t249 - t43 * t202 * t105 * t325 / 0.27e2 + 0.2e1 / 0.9e1 * t43 * t53 * t331 * t332 - t43 * t53 * t212 * t389 / 0.9e1)
  t396 = t115 ** 2
  t399 = 0.1e1 / t117 / t396 / t16
  t401 = t261 ** 2
  t406 = f.my_piecewise5(t47, 0, t45, 0, -t321)
  t409 = t406 * t2 + 0.2e1 * t259
  t415 = f.my_piecewise3(t113, 0, 0.4e1 / 0.81e2 * t43 * t44 * t399 * t159 * t401 - t43 * t258 * t159 * t409 / 0.27e2)
  t417 = f.my_piecewise3(t165, 0, t395 + t415)
  t419 = t177 * t417 * t180
  t422 = t298 * t177
  t423 = t268 * t274
  t424 = t423 * t284
  t428 = 0.1e1 / t273 / t179
  t430 = t284 ** 2
  t431 = t169 * t428 * t430
  t435 = 0.1e1 / t171 / t170
  t448 = 0.6316305334350361920e3 * t435 * t299 - 0.1263261066870072384e3 * t277 * t417 + 0.1803927850994924928e3 * t277 * t299 - 0.450981962748731232e2 * t172 * t417 + 0.10732587778728e2 * t172 * t299 - 0.3577529259576e1 * t175 * t417
  t449 = t275 * t448
  t452 = 0.50000000000000000000000000000000000000000000000000e0 * t22 * t181 + 0.50000000000000000000000000000000000000000000000000e0 * t191 * t193 + 0.10000000000000000000000000000000000000000000000000e1 * t196 * t181 - 0.36066308400000000000000000000000000000000000000000e1 * t199 * t270 - 0.10000000000000000000000000000000000000000000000000e1 * t199 * t285 + 0.18033154200000000000000000000000000000000000000000e1 * t290 * t291 + 0.50000000000000000000000000000000000000000000000000e0 * t294 * t295 - 0.18033154200000000000000000000000000000000000000000e1 * t298 * t301 + 0.90165771000000000000000000000000000000000000000000e0 * t298 * t419 - 0.18033154200000000000000000000000000000000000000000e1 * t422 * t424 - 0.50000000000000000000000000000000000000000000000000e0 * t298 * t431 + 0.25000000000000000000000000000000000000000000000000e0 * t298 * t449
  t453 = f.my_piecewise3(t11, 0, t452)
  t478 = t299 * t268
  t517 = t16 ** 2
  t521 = 0.6e1 * t186 - 0.6e1 * t1 / t517
  t522 = f.my_piecewise5(t25, 0, t29, 0, t521)
  t523 = f.my_piecewise5(t45, 0, t47, 0, t522)
  t531 = t211 ** 2
  t545 = t80 / t61 / t348
  t550 = 0.1e1 / t348 / t220
  t554 = t80 ** 2
  t564 = 0.1e1 / t62 / t82
  t569 = 0.17201646090534979423868312757201646090534979423868e-2 * t79 * t545
  t580 = t230 ** 2
  t602 = t241 ** 2
  t616 = f.my_piecewise3(t35, 0, -0.28e2 / 0.243e3 * t43 * t44 / t51 / t304 / t49 / t185 * t105 * t309 * t206 - 0.4e1 / 0.27e2 * t315 * t307 * t212 * t309 * t249 + 0.4e1 / 0.27e2 * t315 * t307 * t105 * t206 * t325 - 0.2e1 / 0.9e1 * t315 * t201 * t331 * t206 * t332 + t315 * t316 * t325 * t249 / 0.9e1 + t315 * t316 * t206 * t389 / 0.9e1 - t43 * t202 * t105 * (t523 * t2 + 0.3e1 * t322) / 0.27e2 - 0.2e1 / 0.3e1 * t43 * t53 / t531 * t332 * t249 + 0.2e1 / 0.3e1 * t315 * t52 * t331 * t249 * t389 - t43 * t53 * t212 * ((-0.52904115226337448559670781893004115226337448559672e1 * t79 * t545 * t68 + 0.88432098765432098765432098765432098765432098765435e2 * t347 * t550 * t68 - 0.51714677640603566529492455418381344307270233196161e2 * t345 * t554 / t62 / t348 / t82 * t59 * t68 - 0.154e3 / 0.81e2 * t71 * t72 * t564 + t569) * t102 - 0.3e1 * t361 * t231 * t247 + 0.6e1 * t228 * t367 * t369 - 0.3e1 * t363 * t387 - 0.6e1 * t88 / t580 * t369 * t247 + 0.6e1 * t368 * t247 * t387 - t232 * (-0.16977160493827160493827160493827160493827160493827e0 * t90 * t91 / t61 / t81 * t97 - 0.22499015898765432098765432098765432098765432098764e1 * t59 * s0 * t564 * t243 + 0.35427143224923095868312757201646090534979423868312e1 * t79 * t545 * t383 - 0.17456402923482610263558512197530864197530864197530e2 * t347 * t550 / t242 / t602 - t569)) / 0.9e1)
  t632 = f.my_piecewise5(t47, 0, t45, 0, -t522)
  t641 = f.my_piecewise3(t113, 0, -0.28e2 / 0.243e3 * t43 * t44 / t117 / t396 / t115 / t185 * t159 * t401 * t261 + 0.4e1 / 0.27e2 * t315 * t399 * t159 * t261 * t409 - t43 * t258 * t159 * (t632 * t2 + 0.3e1 * t406) / 0.27e2)
  t643 = f.my_piecewise3(t165, 0, t616 + t641)
  t670 = f.my_piecewise5(t13, 0, t15, 0, t521)
  t674 = t273 ** 2
  t685 = -0.27049731300000000000000000000000000000000000000000e1 * t422 * t423 * t448 - 0.27049731300000000000000000000000000000000000000000e1 * t422 * t417 * t274 * t284 - 0.15000000000000000000000000000000000000000000000000e1 * t199 * t449 + 0.30000000000000000000000000000000000000000000000000e1 * t199 * t431 + 0.10819892520000000000000000000000000000000000000000e2 * t199 * t301 - 0.54099462600000000000000000000000000000000000000000e1 * t199 * t419 + 0.10819892520000000000000000000000000000000000000000e2 * t199 * t269 * t295 - 0.15000000000000000000000000000000000000000000000000e1 * t294 * t428 * t430 + 0.25000000000000000000000000000000000000000000000000e0 * t298 * t275 * (-0.37897832006102171520e4 / t171 / t174 * t478 + 0.18948916003051085760e4 * t435 * t268 * t417 - 0.1263261066870072384e3 * t277 * t643 - 0.9019639254974624640e3 * t435 * t478 + 0.5411783552984774784e3 * t278 * t417 - 0.450981962748731232e2 * t172 * t643 - 0.42930351114912e2 * t277 * t478 + 0.32197763336184e2 * t280 * t417 - 0.3577529259576e1 * t175 * t643) - 0.54099462600000000000000000000000000000000000000000e1 * t290 * t424 + 0.90165771000000000000000000000000000000000000000000e0 * t298 * t177 * t643 * t180 - 0.54099462600000000000000000000000000000000000000000e1 * t22 * t270 + 0.50000000000000000000000000000000000000000000000000e0 * t184 * t670 * t193 + 0.15000000000000000000000000000000000000000000000000e1 * t298 * t169 / t674 * t430 * t284 + 0.54099462600000000000000000000000000000000000000000e1 * t298 * t172 * t478 * t180
  t694 = t298 * t175
  t728 = t191 * t2
  t733 = -0.30000000000000000000000000000000000000000000000000e1 * t196 * t285 + 0.15000000000000000000000000000000000000000000000000e1 * t20 * t2 * t181 * t190 - 0.10819892520000000000000000000000000000000000000000e2 * t196 * t270 - 0.54099462600000000000000000000000000000000000000000e1 * t694 * t291 * t417 - 0.15000000000000000000000000000000000000000000000000e1 * t298 * t169 * t428 * t284 * t448 + 0.27049731300000000000000000000000000000000000000000e1 * t290 * t417 * t180 - 0.54099462600000000000000000000000000000000000000000e1 * t289 * t175 * t299 * t180 + 0.15000000000000000000000000000000000000000000000000e1 * t191 * t181 + 0.75000000000000000000000000000000000000000000000000e0 * t294 * t274 * t448 - 0.15000000000000000000000000000000000000000000000000e1 * t22 * t285 + 0.54099462600000000000000000000000000000000000000000e1 * t422 * t268 * t428 * t430 + 0.15000000000000000000000000000000000000000000000000e1 * t21 * t169 * t180 + 0.54099462600000000000000000000000000000000000000000e1 * t694 * t299 * t274 * t284 - 0.15000000000000000000000000000000000000000000000000e1 * t728 * t285 - 0.54099462600000000000000000000000000000000000000000e1 * t728 * t270
  t735 = f.my_piecewise3(t11, 0, t685 + t733)
  d111 = t2 * t735 + 0.3e1 * t453

  res = {'v3rho3': d111}
  return res
