"""Generated from gga_c_optc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c1_raw = params.c1
  if isinstance(params_c1_raw, (str, bytes, dict)):
    params_c1 = params_c1_raw
  else:
    try:
      params_c1_seq = list(params_c1_raw)
    except TypeError:
      params_c1 = params_c1_raw
    else:
      params_c1_seq = np.asarray(params_c1_seq, dtype=np.float64)
      params_c1 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c1_seq))
  params_c2_raw = params.c2
  if isinstance(params_c2_raw, (str, bytes, dict)):
    params_c2 = params_c2_raw
  else:
    try:
      params_c2_seq = list(params_c2_raw)
    except TypeError:
      params_c2 = params_c2_raw
    else:
      params_c2_seq = np.asarray(params_c2_seq, dtype=np.float64)
      params_c2 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c2_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  optc_f2 = lambda rs, z, xt, xs0, xs1: +f_pw91(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0, xs0, 0) * f.opz_pow_n(z, 1) / 2 + f_pw91(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1, 0, xs1) * f.opz_pow_n(-z, 1) / 2

  functional_body = lambda rs, z, xt, xs0, xs1: +params_c1 * f_pw91(rs, z, xt, xs0, xs1) + (params_c2 - params_c1) * optc_f2(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c1_raw = params.c1
  if isinstance(params_c1_raw, (str, bytes, dict)):
    params_c1 = params_c1_raw
  else:
    try:
      params_c1_seq = list(params_c1_raw)
    except TypeError:
      params_c1 = params_c1_raw
    else:
      params_c1_seq = np.asarray(params_c1_seq, dtype=np.float64)
      params_c1 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c1_seq))
  params_c2_raw = params.c2
  if isinstance(params_c2_raw, (str, bytes, dict)):
    params_c2 = params_c2_raw
  else:
    try:
      params_c2_seq = list(params_c2_raw)
    except TypeError:
      params_c2 = params_c2_raw
    else:
      params_c2_seq = np.asarray(params_c2_seq, dtype=np.float64)
      params_c2 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c2_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  optc_f2 = lambda rs, z, xt, xs0, xs1: +f_pw91(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0, xs0, 0) * f.opz_pow_n(z, 1) / 2 + f_pw91(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1, 0, xs1) * f.opz_pow_n(-z, 1) / 2

  functional_body = lambda rs, z, xt, xs0, xs1: +params_c1 * f_pw91(rs, z, xt, xs0, xs1) + (params_c2 - params_c1) * optc_f2(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c1_raw = params.c1
  if isinstance(params_c1_raw, (str, bytes, dict)):
    params_c1 = params_c1_raw
  else:
    try:
      params_c1_seq = list(params_c1_raw)
    except TypeError:
      params_c1 = params_c1_raw
    else:
      params_c1_seq = np.asarray(params_c1_seq, dtype=np.float64)
      params_c1 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c1_seq))
  params_c2_raw = params.c2
  if isinstance(params_c2_raw, (str, bytes, dict)):
    params_c2 = params_c2_raw
  else:
    try:
      params_c2_seq = list(params_c2_raw)
    except TypeError:
      params_c2 = params_c2_raw
    else:
      params_c2_seq = np.asarray(params_c2_seq, dtype=np.float64)
      params_c2 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c2_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  optc_f2 = lambda rs, z, xt, xs0, xs1: +f_pw91(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0, xs0, 0) * f.opz_pow_n(z, 1) / 2 + f_pw91(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1, 0, xs1) * f.opz_pow_n(-z, 1) / 2

  functional_body = lambda rs, z, xt, xs0, xs1: +params_c1 * f_pw91(rs, z, xt, xs0, xs1) + (params_c2 - params_c1) * optc_f2(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t13 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t23 = 0.1e1 / t22
  t24 = t5 * t23
  t25 = t21 * t24
  t27 = 0.23615790870000000000000000000000000000000000000000e0 * t14 + 0.55771035800000000000000000000000000000000000000000e-1 * t11 + 0.12733319050000000000000000000000000000000000000000e-1 * t17 + 0.76629987700000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21947830050000000000000000000000000000000000000000e0 * t14 + 0.48171623250000000000000000000000000000000000000000e-1 * t11 + 0.13081894750000000000000000000000000000000000000000e-1 * t17 + 0.48591338250000000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489865900000000000000000000000000000000000000000e0 * t14 + 0.30591644850000000000000000000000000000000000000000e-1 * t11 + 0.37162376550000000000000000000000000000000000000000e-2 * t17 + 0.41939708850000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482233974552040708313425006184496242808878304904e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t85 = t58 * t80
  t87 = jnp.pi ** 2
  t88 = 0.1e1 / t87
  t89 = t88 * t19
  t90 = t87 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = jnp.pi * t19
  t103 = 0.1e1 / t90
  t105 = s0 + 0.2e1 * s1 + s2
  t107 = 0.1e1 / t8 / t35
  t108 = t105 * t107
  t110 = 0.1e1 / t99
  t112 = 0.1e1 / t3
  t113 = t112 * t5
  t114 = t110 * t19 * t113
  t117 = jnp.pi * t103
  t122 = (-0.18e0 * t31 + 0.18e0 * t84 + 0.10526802115419367327496416501113209323705598094883e0 * t85) * t87
  t123 = 0.1e1 / t91
  t124 = t1 * t123
  t125 = 0.1e1 / t100
  t126 = t124 * t125
  t129 = jnp.exp(-0.72599219320266867760696246260269014374413107911013e2 * t122 * t126)
  t130 = t129 - 0.1e1
  t131 = 0.1e1 / t130
  t132 = t105 ** 2
  t133 = t131 * t132
  t134 = t117 * t133
  t136 = 0.1e1 / t22 / t36
  t137 = t54 ** 2
  t138 = t136 * t137
  t139 = t99 ** 2
  t140 = 0.1e1 / t139
  t141 = 0.1e1 / t20
  t143 = t140 * t141 * t6
  t144 = t138 * t143
  t147 = t108 * t54 * t114 / 0.96e2 + 0.86472476387249114521841794569067296340023612750885e-3 * t134 * t144
  t149 = jnp.pi * t1
  t150 = t103 * t131
  t152 = t149 * t150 * t105
  t153 = t107 * t54
  t155 = t110 * t112 * t5
  t156 = t153 * t155
  t159 = t87 * t19
  t160 = t130 ** 2
  t161 = 0.1e1 / t160
  t162 = t123 * t161
  t164 = t159 * t162 * t132
  t167 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t152 * t156 + 0.76569489126843962091359322227627476098013824749896e-3 * t164 * t144
  t168 = 0.1e1 / t167
  t172 = 0.1e1 + 0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * t147 * t168
  t173 = jnp.log(t172)
  t177 = t2 * t90
  t180 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t11 + 0.18472500000000000000000000000000000000000000000000e-2 * t25
  t183 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t11 + 0.11800000000000000000000000000000000000000000000000e3 * t25
  t184 = 0.1e1 / t183
  t186 = t180 * t184 - 0.18535714285714285714285714285714285714285714285714e-2
  t187 = t186 * t98
  t189 = t177 * t187 * t105
  t190 = 9 ** (0.1e1 / 0.3e1)
  t191 = t190 ** 2
  t192 = t2 * t191
  t196 = t192 * t3 / t22 / t35
  t198 = t54 * t5
  t199 = t99 * t105 * t198
  t202 = jnp.exp(-0.25e2 / 0.18e2 * t196 * t199)
  t203 = t113 * t202
  t204 = t153 * t203
  t208 = params.c1 * (-t31 + t84 + 0.58482233974552040708313425006184496242808878304904e0 * t85 + 0.25507875555555555555555555555555555555555555555556e-1 * t89 * t91 * t100 * t173 + t189 * t204 / 0.2e1)
  t209 = params.c2 - params.c1
  t210 = t4 * t6
  t211 = t9 * t54
  t212 = 0.1e1 / t41
  t213 = t212 ** (0.1e1 / 0.3e1)
  t215 = t210 * t211 * t213
  t217 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t215
  t218 = jnp.sqrt(t215)
  t221 = t215 ** 0.15e1
  t223 = t21 * t5
  t224 = t23 * t137
  t225 = t213 ** 2
  t227 = t223 * t224 * t225
  t229 = 0.23615790870000000000000000000000000000000000000000e0 * t218 + 0.55771035800000000000000000000000000000000000000000e-1 * t215 + 0.12733319050000000000000000000000000000000000000000e-1 * t221 + 0.76629987700000000000000000000000000000000000000000e-2 * t227
  t231 = 0.1e1 + 0.1e1 / t229
  t232 = jnp.log(t231)
  t233 = t217 * t232
  t234 = 0.2e1 <= f.p.zeta_threshold
  t236 = f.my_piecewise3(t234, t44, 0.2e1 * t54)
  t237 = 0.0e0 <= f.p.zeta_threshold
  t238 = f.my_piecewise3(t237, t44, 0)
  t240 = (t236 + t238 - 0.2e1) * t57
  t242 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t215
  t247 = 0.21947830050000000000000000000000000000000000000000e0 * t218 + 0.48171623250000000000000000000000000000000000000000e-1 * t215 + 0.13081894750000000000000000000000000000000000000000e-1 * t221 + 0.48591338250000000000000000000000000000000000000000e-2 * t227
  t249 = 0.1e1 + 0.1e1 / t247
  t250 = jnp.log(t249)
  t253 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t215
  t258 = 0.17489865900000000000000000000000000000000000000000e0 * t218 + 0.30591644850000000000000000000000000000000000000000e-1 * t215 + 0.37162376550000000000000000000000000000000000000000e-2 * t221 + 0.41939708850000000000000000000000000000000000000000e-2 * t227
  t260 = 0.1e1 + 0.1e1 / t258
  t261 = jnp.log(t260)
  t262 = t253 * t261
  t265 = t240 * (-t242 * t250 + t233 - 0.58482233974552040708313425006184496242808878304904e0 * t262)
  t266 = t240 * t262
  t268 = f.my_piecewise3(t234, t92, t137)
  t269 = f.my_piecewise3(t237, t92, 0)
  t271 = t268 / 0.2e1 + t269 / 0.2e1
  t272 = t271 ** 2
  t273 = t272 * t271
  t274 = t91 * t273
  t275 = r0 ** 2
  t276 = r0 ** (0.1e1 / 0.3e1)
  t277 = t276 ** 2
  t279 = 0.1e1 / t277 / t275
  t280 = s0 * t279
  t281 = 0.1e1 / t272
  t282 = t281 * t19
  t283 = t280 * t282
  t284 = 0.1e1 / t213
  t285 = t8 * t284
  t286 = t113 * t285
  t295 = t124 / t273
  t298 = jnp.exp(-0.72599219320266867760696246260269014374413107911013e2 * (-0.18e0 * t233 + 0.18e0 * t265 + 0.10526802115419367327496416501113209323705598094883e0 * t266) * t87 * t295)
  t299 = t298 - 0.1e1
  t300 = 0.1e1 / t299
  t301 = s0 ** 2
  t302 = t300 * t301
  t303 = t275 ** 2
  t306 = 0.1e1 / t276 / t303 / r0
  t308 = t117 * t302 * t306
  t309 = t272 ** 2
  t310 = 0.1e1 / t309
  t311 = t310 * t141
  t312 = t6 * t22
  t313 = 0.1e1 / t225
  t314 = t312 * t313
  t315 = t311 * t314
  t318 = t283 * t286 / 0.96e2 + 0.86472476387249114521841794569067296340023612750885e-3 * t308 * t315
  t320 = t103 * t300
  t322 = t149 * t320 * s0
  t323 = t279 * t281
  t324 = t323 * t112
  t325 = t5 * t8
  t326 = t325 * t284
  t330 = t299 ** 2
  t331 = 0.1e1 / t330
  t332 = t123 * t331
  t334 = t159 * t332 * t301
  t336 = t306 * t310 * t141
  t337 = t336 * t314
  t340 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t322 * t324 * t326 + 0.76569489126843962091359322227627476098013824749896e-3 * t334 * t337
  t341 = 0.1e1 / t340
  t345 = 0.1e1 + 0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * t318 * t341
  t346 = jnp.log(t345)
  t352 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t215 + 0.18472500000000000000000000000000000000000000000000e-2 * t227
  t355 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t215 + 0.11800000000000000000000000000000000000000000000000e3 * t227
  t356 = 0.1e1 / t355
  t358 = t352 * t356 - 0.18535714285714285714285714285714285714285714285714e-2
  t359 = t358 * t271
  t361 = t177 * t359 * s0
  t363 = t279 * t112 * t5
  t365 = t192 * t3 * t54
  t371 = jnp.exp(-0.25e2 / 0.18e2 * t365 * t272 * s0 * t279 * t5)
  t372 = t285 * t371
  t373 = t363 * t372
  t376 = -t233 + t265 + 0.58482233974552040708313425006184496242808878304904e0 * t266 + 0.25507875555555555555555555555555555555555555555556e-1 * t89 * t274 * t346 + t361 * t373 / 0.2e1
  t377 = f.my_piecewise3(t42, f.p.zeta_threshold, t41)
  t379 = 0.1e1 / t48
  t380 = t379 ** (0.1e1 / 0.3e1)
  t382 = t210 * t211 * t380
  t384 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t382
  t385 = jnp.sqrt(t382)
  t388 = t382 ** 0.15e1
  t390 = t380 ** 2
  t392 = t223 * t224 * t390
  t394 = 0.23615790870000000000000000000000000000000000000000e0 * t385 + 0.55771035800000000000000000000000000000000000000000e-1 * t382 + 0.12733319050000000000000000000000000000000000000000e-1 * t388 + 0.76629987700000000000000000000000000000000000000000e-2 * t392
  t396 = 0.1e1 + 0.1e1 / t394
  t397 = jnp.log(t396)
  t398 = t384 * t397
  t400 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t382
  t405 = 0.21947830050000000000000000000000000000000000000000e0 * t385 + 0.48171623250000000000000000000000000000000000000000e-1 * t382 + 0.13081894750000000000000000000000000000000000000000e-1 * t388 + 0.48591338250000000000000000000000000000000000000000e-2 * t392
  t407 = 0.1e1 + 0.1e1 / t405
  t408 = jnp.log(t407)
  t411 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t382
  t416 = 0.17489865900000000000000000000000000000000000000000e0 * t385 + 0.30591644850000000000000000000000000000000000000000e-1 * t382 + 0.37162376550000000000000000000000000000000000000000e-2 * t388 + 0.41939708850000000000000000000000000000000000000000e-2 * t392
  t418 = 0.1e1 + 0.1e1 / t416
  t419 = jnp.log(t418)
  t420 = t411 * t419
  t423 = t240 * (-t400 * t408 + t398 - 0.58482233974552040708313425006184496242808878304904e0 * t420)
  t424 = t240 * t420
  t426 = r1 ** 2
  t427 = r1 ** (0.1e1 / 0.3e1)
  t428 = t427 ** 2
  t430 = 0.1e1 / t428 / t426
  t431 = s2 * t430
  t432 = t431 * t282
  t433 = 0.1e1 / t380
  t434 = t8 * t433
  t435 = t113 * t434
  t445 = jnp.exp(-0.72599219320266867760696246260269014374413107911013e2 * (-0.18e0 * t398 + 0.18e0 * t423 + 0.10526802115419367327496416501113209323705598094883e0 * t424) * t87 * t295)
  t446 = t445 - 0.1e1
  t447 = 0.1e1 / t446
  t448 = s2 ** 2
  t449 = t447 * t448
  t450 = t426 ** 2
  t453 = 0.1e1 / t427 / t450 / r1
  t455 = t117 * t449 * t453
  t456 = 0.1e1 / t390
  t457 = t312 * t456
  t458 = t311 * t457
  t461 = t432 * t435 / 0.96e2 + 0.86472476387249114521841794569067296340023612750885e-3 * t455 * t458
  t463 = t103 * t447
  t465 = t149 * t463 * s2
  t466 = t430 * t281
  t467 = t466 * t112
  t468 = t325 * t433
  t472 = t446 ** 2
  t473 = 0.1e1 / t472
  t474 = t123 * t473
  t476 = t159 * t474 * t448
  t478 = t453 * t310 * t141
  t479 = t478 * t457
  t482 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t465 * t467 * t468 + 0.76569489126843962091359322227627476098013824749896e-3 * t476 * t479
  t483 = 0.1e1 / t482
  t487 = 0.1e1 + 0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * t461 * t483
  t488 = jnp.log(t487)
  t494 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t382 + 0.18472500000000000000000000000000000000000000000000e-2 * t392
  t497 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t382 + 0.11800000000000000000000000000000000000000000000000e3 * t392
  t498 = 0.1e1 / t497
  t500 = t494 * t498 - 0.18535714285714285714285714285714285714285714285714e-2
  t501 = t500 * t271
  t503 = t177 * t501 * s2
  t505 = t430 * t112 * t5
  t511 = jnp.exp(-0.25e2 / 0.18e2 * t365 * t272 * s2 * t430 * t5)
  t512 = t434 * t511
  t513 = t505 * t512
  t516 = -t398 + t423 + 0.58482233974552040708313425006184496242808878304904e0 * t424 + 0.25507875555555555555555555555555555555555555555556e-1 * t89 * t274 * t488 + t503 * t513 / 0.2e1
  t517 = f.my_piecewise3(t49, f.p.zeta_threshold, t48)
  t521 = t209 * (t376 * t377 / 0.2e1 + t516 * t517 / 0.2e1)
  t523 = 0.1e1 / t8 / t7
  t524 = t6 * t523
  t526 = t4 * t524 * t30
  t527 = 0.11073577833333333333333333333333333333333333333333e-2 * t526
  t528 = t27 ** 2
  t533 = t3 * t6
  t534 = t533 * t523
  t535 = 0.1e1 / t14 * t1 * t534
  t537 = t4 * t524
  t539 = t11 ** 0.5e0
  t541 = t539 * t1 * t534
  t544 = 0.1e1 / t22 / t7
  t546 = t21 * t5 * t544
  t551 = t13 / t528 * (-0.39359651450000000000000000000000000000000000000000e-1 * t535 - 0.18590345266666666666666666666666666666666666666667e-1 * t537 - 0.63666595250000000000000000000000000000000000000000e-2 * t541 - 0.51086658466666666666666666666666666666666666666667e-2 * t546) / t29
  t554 = t33 * t32 * t37 * t83
  t555 = 0.4e1 * t554
  t556 = t36 * t7
  t557 = 0.1e1 / t556
  t559 = t34 * t557 * t83
  t560 = 0.4e1 * t559
  t562 = t32 / t35
  t563 = t39 - t562
  t566 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t563)
  t567 = -t563
  t570 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t567)
  t572 = (t566 + t570) * t57
  t574 = t38 * t572 * t82
  t578 = t65 ** 2
  t592 = t76 ** 2
  t593 = 0.1e1 / t592
  t599 = -0.29149776500000000000000000000000000000000000000000e-1 * t535 - 0.10197214950000000000000000000000000000000000000000e-1 * t537 - 0.18581188275000000000000000000000000000000000000000e-2 * t541 - 0.27959805900000000000000000000000000000000000000000e-2 * t546
  t600 = 0.1e1 / t78
  t606 = t38 * t58 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t524 * t68 + t60 / t578 * (-0.36579716750000000000000000000000000000000000000000e-1 * t535 - 0.16057207750000000000000000000000000000000000000000e-1 * t537 - 0.65409473750000000000000000000000000000000000000000e-2 * t541 - 0.32394225500000000000000000000000000000000000000000e-2 * t546) / t67 - t527 - t551 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t524 * t79 + 0.58482233974552040708313425006184496242808878304904e0 * t71 * t593 * t599 * t600)
  t607 = t572 * t80
  t612 = t58 * t1 * t533 * t523 * t79
  t613 = 0.18311555036753159941307229983139571945136646663793e-3 * t612
  t617 = t58 * t71 * t593 * t599 * t600
  t618 = 0.58482233974552040708313425006184496242808878304904e0 * t617
  t619 = t89 * t91
  t620 = t99 * t173
  t621 = 0.1e1 / t45
  t624 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t621 * t563)
  t625 = 0.1e1 / t50
  t628 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t625 * t567)
  t630 = t624 / 0.2e1 + t628 / 0.2e1
  t634 = t35 * t7
  t636 = 0.1e1 / t8 / t634
  t640 = 0.7e1 / 0.288e3 * t105 * t636 * t54 * t114
  t642 = t108 * t54 * t125
  t643 = t19 * t112
  t650 = t117 * t161 * t132 * t136
  t652 = t137 * t140 * t141
  t653 = 0.19932440099999999999999999999999999999999999999999e-3 * t526
  t654 = 0.18e0 * t551
  t655 = 0.72e0 * t554
  t656 = 0.72e0 * t559
  t658 = 0.18e0 * t606
  t660 = 0.32960799066155687894353013969651229501245963994829e-4 * t612
  t661 = 0.10526802115419367327496416501113209323705598094883e0 * t617
  t666 = t122 * t1
  t667 = t123 * t140
  t671 = -0.72599219320266867760696246260269014374413107911013e2 * (t653 + t654 + t655 - t656 + 0.18e0 * t574 + t658 + 0.10526802115419367327496416501113209323705598094883e0 * t607 - t660 - t661) * t87 * t126 + 0.21779765796080060328208873878080704312323932373304e3 * t666 * t667 * t630
  t674 = t652 * t6 * t671 * t129
  t680 = 0.1e1 / t22 / t556 * t137 * t143
  t682 = 0.40353822314049586776859504132231404958677685950413e-2 * t134 * t680
  t684 = t117 * t133 * t136
  t686 = 0.1e1 / t139 / t98
  t687 = t137 * t686
  t688 = t141 * t6
  t689 = t688 * t630
  t698 = t102 * t103
  t699 = t167 ** 2
  t701 = t147 / t699
  t702 = t149 * t103
  t705 = t702 * t161 * t105 * t107
  t707 = t54 * t110 * t112
  t713 = t636 * t54
  t716 = 0.64566115702479338842975206611570247933884297520660e-1 * t152 * t713 * t155
  t717 = t153 * t125
  t722 = t159 * t123
  t727 = t722 / t160 / t130 * t132 * t136
  t731 = 0.35732428259193848975967683706226155512406451549951e-2 * t164 * t680
  t732 = t138 * t686
  t742 = 0.1e1 / t172
  t750 = t183 ** 2
  t762 = t177 * ((-0.19388333333333333333333333333333333333333333333333e1 * t537 - 0.12315000000000000000000000000000000000000000000000e-2 * t546) * t184 - t180 / t750 * (-0.72691666666666666666666666666666666666666666666667e3 * t537 - 0.78666666666666666666666666666666666666666666666667e2 * t546)) * t98 * t105 * t204 / 0.2e1
  t770 = 0.7e1 / 0.6e1 * t189 * t713 * t203
  t771 = t153 * t112
  t777 = 0.100e3 / 0.27e2 * t192 * t3 / t22 / t634 * t199
  t778 = t98 * t105
  t789 = t527 + t551 + t555 - t560 + t574 + t606 + 0.58482233974552040708313425006184496242808878304904e0 * t607 - t613 - t618 + 0.76523626666666666666666666666666666666666666666668e-1 * t619 * t620 * t630 + 0.25507875555555555555555555555555555555555555555556e-1 * t619 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (-t640 - t642 * t643 * t5 * t630 / 0.48e2 - 0.86472476387249114521841794569067296340023612750885e-3 * t650 * t674 - t682 - 0.34588990554899645808736717827626918536009445100354e-2 * t684 * t687 * t689) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t701 * (-0.27671192443919716646989374262101534828807556080283e-1 * t705 * t707 * t5 * t671 * t129 - t716 - 0.55342384887839433293978748524203069657615112160566e-1 * t152 * t717 * t113 * t630 - 0.15313897825368792418271864445525495219602764949979e-2 * t727 * t674 - t731 - 0.30627795650737584836543728891050990439205529899958e-2 * t164 * t732 * t689)) * t742 + t762 + t177 * t186 * t630 * t105 * t204 / 0.2e1 - t770 + t189 * t771 * t5 * (t777 - 0.25e2 / 0.9e1 * t196 * t778 * t198 * t630) * t202 / 0.2e1
  t791 = t523 * t54
  t793 = t210 * t791 * t213
  t794 = 0.11073577833333333333333333333333333333333333333333e-2 * t793
  t795 = t54 * t313
  t796 = t41 ** 2
  t797 = 0.1e1 / t796
  t798 = t797 * t563
  t800 = t11 * t795 * t798
  t803 = (-t794 - 0.11073577833333333333333333333333333333333333333333e-2 * t800) * t232
  t804 = t229 ** 2
  t806 = t217 / t804
  t807 = 0.1e1 / t218
  t809 = -t793 / 0.3e1 - t800 / 0.3e1
  t810 = t807 * t809
  t812 = 0.18590345266666666666666666666666666666666666666667e-1 * t793
  t814 = t215 ** 0.5e0
  t815 = t814 * t809
  t817 = t544 * t137
  t819 = t223 * t817 * t225
  t820 = 0.51086658466666666666666666666666666666666666666667e-2 * t819
  t821 = t137 * t284
  t823 = t25 * t821 * t798
  t826 = 0.1e1 / t231
  t828 = t806 * (0.11807895435000000000000000000000000000000000000000e0 * t810 - t812 - 0.18590345266666666666666666666666666666666666666667e-1 * t800 + 0.19099978575000000000000000000000000000000000000000e-1 * t815 - t820 - 0.51086658466666666666666666666666666666666666666667e-2 * t823) * t826
  t829 = 0.53236443333333333333333333333333333333333333333333e-3 * t793
  t833 = t247 ** 2
  t835 = t242 / t833
  t837 = 0.16057207750000000000000000000000000000000000000000e-1 * t793
  t840 = 0.32394225500000000000000000000000000000000000000000e-2 * t819
  t843 = 0.1e1 / t249
  t846 = 0.31311312500000000000000000000000000000000000000000e-3 * t793
  t849 = (-t846 - 0.31311312500000000000000000000000000000000000000000e-3 * t800) * t261
  t851 = t258 ** 2
  t852 = 0.1e1 / t851
  t853 = t253 * t852
  t855 = 0.10197214950000000000000000000000000000000000000000e-1 * t793
  t858 = 0.27959805900000000000000000000000000000000000000000e-2 * t819
  t860 = 0.87449329500000000000000000000000000000000000000000e-1 * t810 - t855 - 0.10197214950000000000000000000000000000000000000000e-1 * t800 + 0.55743564825000000000000000000000000000000000000000e-2 * t815 - t858 - 0.27959805900000000000000000000000000000000000000000e-2 * t823
  t861 = 0.1e1 / t260
  t866 = t240 * (-(-t829 - 0.53236443333333333333333333333333333333333333333333e-3 * t800) * t250 + t835 * (0.10973915025000000000000000000000000000000000000000e0 * t810 - t837 - 0.16057207750000000000000000000000000000000000000000e-1 * t800 + 0.19622842125000000000000000000000000000000000000000e-1 * t815 - t840 - 0.32394225500000000000000000000000000000000000000000e-2 * t823) * t843 + t803 - t828 - 0.58482233974552040708313425006184496242808878304904e0 * t849 + 0.58482233974552040708313425006184496242808878304904e0 * t853 * t860 * t861)
  t867 = t240 * t849
  t869 = t240 * t253
  t872 = t869 * t852 * t860 * t861
  t876 = 0.1e1 / t277 / t275 / r0
  t881 = t23 * t284
  t884 = t283 * t113 * t881 / 0.288e3
  t885 = t282 * t112
  t886 = t280 * t885
  t888 = 0.1e1 / t213 / t212
  t889 = t888 * t797
  t897 = 0.1e1 / t309 / t273
  t900 = jnp.pi * t331 * t301 * t306 * t897 * t141
  t906 = -0.18e0 * t803 + 0.18e0 * t828 + 0.18e0 * t866 + 0.10526802115419367327496416501113209323705598094883e0 * t867 - 0.10526802115419367327496416501113209323705598094883e0 * t872
  t914 = 0.1e1 / t276 / t303 / t275
  t919 = t10 * t313
  t922 = 0.57648317591499409681227863046044864226682408500590e-3 * t308 * t311 * t919
  t924 = t301 * t306
  t926 = t117 * t300 * t924 * t310
  t927 = t688 * t22
  t929 = 0.1e1 / t225 / t212
  t930 = t929 * t797
  t940 = t340 ** 2
  t942 = t318 / t940
  t945 = 0.1e1 / t309 / t271
  t947 = t102 * t331 * t280 * t945
  t948 = t113 * t8
  t962 = 0.92237308146399055489964580873671782762691853600943e-2 * t322 * t324 * t24 * t284
  t963 = t300 * s0
  t965 = t702 * t963 * t279
  t966 = t281 * t112
  t967 = t966 * t5
  t968 = t8 * t888
  t973 = t87 ** 2
  t976 = t973 / t90 / t87
  t981 = t976 / t330 / t299 * t924 * t897
  t994 = 0.51046326084562641394239548151751650732009216499931e-3 * t334 * t336 * t919
  t997 = t722 * t331 * t301 * t306
  t998 = t311 * t6
  t999 = t22 * t929
  t1010 = 0.1e1 / t345
  t1014 = 0.19388333333333333333333333333333333333333333333333e1 * t793
  t1016 = 0.12315000000000000000000000000000000000000000000000e-2 * t819
  t1020 = t355 ** 2
  t1022 = t352 / t1020
  t1023 = 0.72691666666666666666666666666666666666666666666667e3 * t793
  t1025 = 0.78666666666666666666666666666666666666666666666667e2 * t819
  t1043 = t361 * t363 * t881 * t371 / 0.6e1
  t1047 = t177 * t358 * t271 * s0 * t279
  t1048 = t888 * t371
  t1053 = t88 * t90
  t1054 = t1053 * t358
  t1058 = t6 * t8
  t1060 = t191 * t54
  t1062 = t1058 * t284 * t1060 * t371
  t1065 = -t803 + t828 + t866 + 0.58482233974552040708313425006184496242808878304904e0 * t867 - 0.58482233974552040708313425006184496242808878304904e0 * t872 + 0.25507875555555555555555555555555555555555555555556e-1 * t619 * t273 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (-s0 * t876 * t282 * t286 / 0.36e2 + t884 + t886 * t325 * t889 * t563 / 0.288e3 + 0.62778342784044964327823135763173517724332468147298e-1 * t900 * t314 * t906 * t1 * t298 - 0.46118654073199527744982290436835891381345926800472e-2 * t117 * t302 * t914 * t315 + t922 + 0.57648317591499409681227863046044864226682408500590e-3 * t926 * t927 * t930 * t563) * t341 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t942 * (0.20089069690894388584903403444215525671786389807135e1 * t947 * t948 * t284 * t906 * t298 - 0.73789846517119244391971664698937426210153482880755e-1 * t322 * t876 * t281 * t112 * t326 + t962 + 0.92237308146399055489964580873671782762691853600943e-2 * t965 * t967 * t968 * t798 + 0.33353310806163204188335786414909188873612291223475e0 * t981 * t927 * t313 * t906 * t298 - 0.40837060867650113115391638521401320585607373199945e-2 * t334 * t914 * t310 * t141 * t314 + t994 + 0.51046326084562641394239548151751650732009216499931e-3 * t997 * t998 * t999 * t798)) * t1010 + t177 * ((-t1014 - 0.19388333333333333333333333333333333333333333333333e1 * t800 - t1016 - 0.12315000000000000000000000000000000000000000000000e-2 * t823) * t356 - t1022 * (-t1023 - 0.72691666666666666666666666666666666666666666666667e3 * t800 - t1025 - 0.78666666666666666666666666666666666666666666666667e2 * t823)) * t271 * s0 * t373 / 0.2e1 - 0.4e1 / 0.3e1 * t361 * t876 * t112 * t5 * t372 + t1043 + t1047 * t948 * t1048 * t798 / 0.6e1 + 0.50e2 / 0.27e2 * t1054 * t273 * t301 * t914 * t1062
  t1067 = f.my_piecewise3(t42, 0, t563)
  t1070 = t210 * t791 * t380
  t1071 = 0.11073577833333333333333333333333333333333333333333e-2 * t1070
  t1072 = t54 * t456
  t1073 = t48 ** 2
  t1074 = 0.1e1 / t1073
  t1075 = t1074 * t567
  t1077 = t11 * t1072 * t1075
  t1080 = (-t1071 - 0.11073577833333333333333333333333333333333333333333e-2 * t1077) * t397
  t1081 = t394 ** 2
  t1083 = t384 / t1081
  t1084 = 0.1e1 / t385
  t1086 = -t1070 / 0.3e1 - t1077 / 0.3e1
  t1087 = t1084 * t1086
  t1089 = 0.18590345266666666666666666666666666666666666666667e-1 * t1070
  t1091 = t382 ** 0.5e0
  t1092 = t1091 * t1086
  t1095 = t223 * t817 * t390
  t1096 = 0.51086658466666666666666666666666666666666666666667e-2 * t1095
  t1097 = t137 * t433
  t1099 = t25 * t1097 * t1075
  t1102 = 0.1e1 / t396
  t1104 = t1083 * (0.11807895435000000000000000000000000000000000000000e0 * t1087 - t1089 - 0.18590345266666666666666666666666666666666666666667e-1 * t1077 + 0.19099978575000000000000000000000000000000000000000e-1 * t1092 - t1096 - 0.51086658466666666666666666666666666666666666666667e-2 * t1099) * t1102
  t1105 = 0.53236443333333333333333333333333333333333333333333e-3 * t1070
  t1109 = t405 ** 2
  t1111 = t400 / t1109
  t1113 = 0.16057207750000000000000000000000000000000000000000e-1 * t1070
  t1116 = 0.32394225500000000000000000000000000000000000000000e-2 * t1095
  t1119 = 0.1e1 / t407
  t1122 = 0.31311312500000000000000000000000000000000000000000e-3 * t1070
  t1125 = (-t1122 - 0.31311312500000000000000000000000000000000000000000e-3 * t1077) * t419
  t1127 = t416 ** 2
  t1128 = 0.1e1 / t1127
  t1129 = t411 * t1128
  t1131 = 0.10197214950000000000000000000000000000000000000000e-1 * t1070
  t1134 = 0.27959805900000000000000000000000000000000000000000e-2 * t1095
  t1136 = 0.87449329500000000000000000000000000000000000000000e-1 * t1087 - t1131 - 0.10197214950000000000000000000000000000000000000000e-1 * t1077 + 0.55743564825000000000000000000000000000000000000000e-2 * t1092 - t1134 - 0.27959805900000000000000000000000000000000000000000e-2 * t1099
  t1137 = 0.1e1 / t418
  t1142 = t240 * (-(-t1105 - 0.53236443333333333333333333333333333333333333333333e-3 * t1077) * t408 + t1111 * (0.10973915025000000000000000000000000000000000000000e0 * t1087 - t1113 - 0.16057207750000000000000000000000000000000000000000e-1 * t1077 + 0.19622842125000000000000000000000000000000000000000e-1 * t1092 - t1116 - 0.32394225500000000000000000000000000000000000000000e-2 * t1099) * t1119 + t1080 - t1104 - 0.58482233974552040708313425006184496242808878304904e0 * t1125 + 0.58482233974552040708313425006184496242808878304904e0 * t1129 * t1136 * t1137)
  t1143 = t240 * t1125
  t1145 = t240 * t411
  t1148 = t1145 * t1128 * t1136 * t1137
  t1150 = t23 * t433
  t1153 = t432 * t113 * t1150 / 0.288e3
  t1154 = t431 * t885
  t1156 = 0.1e1 / t380 / t379
  t1157 = t1156 * t1074
  t1166 = jnp.pi * t473 * t448 * t453 * t897 * t141
  t1172 = -0.18e0 * t1080 + 0.18e0 * t1104 + 0.18e0 * t1142 + 0.10526802115419367327496416501113209323705598094883e0 * t1143 - 0.10526802115419367327496416501113209323705598094883e0 * t1148
  t1178 = t10 * t456
  t1181 = 0.57648317591499409681227863046044864226682408500590e-3 * t455 * t311 * t1178
  t1183 = t448 * t453
  t1185 = t117 * t447 * t1183 * t310
  t1187 = 0.1e1 / t390 / t379
  t1188 = t1187 * t1074
  t1198 = t482 ** 2
  t1200 = t461 / t1198
  t1203 = t102 * t473 * t431 * t945
  t1212 = 0.92237308146399055489964580873671782762691853600943e-2 * t465 * t467 * t24 * t433
  t1213 = t447 * s2
  t1215 = t702 * t1213 * t430
  t1216 = t8 * t1156
  t1225 = t976 / t472 / t446 * t1183 * t897
  t1233 = 0.51046326084562641394239548151751650732009216499931e-3 * t476 * t478 * t1178
  t1236 = t722 * t473 * t448 * t453
  t1237 = t22 * t1187
  t1248 = 0.1e1 / t487
  t1252 = 0.19388333333333333333333333333333333333333333333333e1 * t1070
  t1254 = 0.12315000000000000000000000000000000000000000000000e-2 * t1095
  t1258 = t497 ** 2
  t1260 = t494 / t1258
  t1261 = 0.72691666666666666666666666666666666666666666666667e3 * t1070
  t1263 = 0.78666666666666666666666666666666666666666666666667e2 * t1095
  t1276 = t503 * t505 * t1150 * t511 / 0.6e1
  t1280 = t177 * t500 * t271 * s2 * t430
  t1281 = t1156 * t511
  t1288 = f.my_piecewise3(t49, 0, t567)
  vrho_0_ = t208 + t521 + t7 * (params.c1 * t789 + t209 * (t1065 * t377 / 0.2e1 + t376 * t1067 / 0.2e1 + (-t1080 + t1104 + t1142 + 0.58482233974552040708313425006184496242808878304904e0 * t1143 - 0.58482233974552040708313425006184496242808878304904e0 * t1148 + 0.25507875555555555555555555555555555555555555555556e-1 * t619 * t273 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t1153 + t1154 * t325 * t1157 * t567 / 0.288e3 + 0.62778342784044964327823135763173517724332468147298e-1 * t1166 * t457 * t1172 * t1 * t445 + t1181 + 0.57648317591499409681227863046044864226682408500590e-3 * t1185 * t927 * t1188 * t567) * t483 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t1200 * (0.20089069690894388584903403444215525671786389807135e1 * t1203 * t948 * t433 * t1172 * t445 + t1212 + 0.92237308146399055489964580873671782762691853600943e-2 * t1215 * t967 * t1216 * t1075 + 0.33353310806163204188335786414909188873612291223475e0 * t1225 * t927 * t456 * t1172 * t445 + t1233 + 0.51046326084562641394239548151751650732009216499931e-3 * t1236 * t998 * t1237 * t1075)) * t1248 + t177 * ((-t1252 - 0.19388333333333333333333333333333333333333333333333e1 * t1077 - t1254 - 0.12315000000000000000000000000000000000000000000000e-2 * t1099) * t498 - t1260 * (-t1261 - 0.72691666666666666666666666666666666666666666666667e3 * t1077 - t1263 - 0.78666666666666666666666666666666666666666666666667e2 * t1099)) * t271 * s2 * t513 / 0.2e1 + t1276 + t1280 * t948 * t1281 * t1075 / 0.6e1) * t517 / 0.2e1 + t516 * t1288 / 0.2e1))
  t1295 = -t39 - t562
  t1298 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t1295)
  t1299 = -t1295
  t1302 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t1299)
  t1304 = (t1298 + t1302) * t57
  t1306 = t38 * t1304 * t82
  t1307 = t1304 * t80
  t1311 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t621 * t1295)
  t1314 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t625 * t1299)
  t1316 = t1311 / 0.2e1 + t1314 / 0.2e1
  t1333 = -0.72599219320266867760696246260269014374413107911013e2 * (t653 + t654 - t655 - t656 + 0.18e0 * t1306 + t658 + 0.10526802115419367327496416501113209323705598094883e0 * t1307 - t660 - t661) * t87 * t126 + 0.21779765796080060328208873878080704312323932373304e3 * t666 * t667 * t1316
  t1336 = t652 * t6 * t1333 * t129
  t1339 = t688 * t1316
  t1386 = t527 + t551 - t555 - t560 + t1306 + t606 + 0.58482233974552040708313425006184496242808878304904e0 * t1307 - t613 - t618 + 0.76523626666666666666666666666666666666666666666668e-1 * t619 * t620 * t1316 + 0.25507875555555555555555555555555555555555555555556e-1 * t619 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (-t640 - t642 * t643 * t5 * t1316 / 0.48e2 - 0.86472476387249114521841794569067296340023612750885e-3 * t650 * t1336 - t682 - 0.34588990554899645808736717827626918536009445100354e-2 * t684 * t687 * t1339) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t701 * (-0.27671192443919716646989374262101534828807556080283e-1 * t705 * t707 * t5 * t1333 * t129 - t716 - 0.55342384887839433293978748524203069657615112160566e-1 * t152 * t717 * t113 * t1316 - 0.15313897825368792418271864445525495219602764949979e-2 * t727 * t1336 - t731 - 0.30627795650737584836543728891050990439205529899958e-2 * t164 * t732 * t1339)) * t742 + t762 + t177 * t186 * t1316 * t105 * t204 / 0.2e1 - t770 + t189 * t771 * t5 * (t777 - 0.25e2 / 0.9e1 * t196 * t778 * t198 * t1316) * t202 / 0.2e1
  t1388 = t797 * t1295
  t1390 = t11 * t795 * t1388
  t1393 = (-t794 - 0.11073577833333333333333333333333333333333333333333e-2 * t1390) * t232
  t1395 = -t793 / 0.3e1 - t1390 / 0.3e1
  t1396 = t807 * t1395
  t1399 = t814 * t1395
  t1402 = t25 * t821 * t1388
  t1406 = t806 * (0.11807895435000000000000000000000000000000000000000e0 * t1396 - t812 - 0.18590345266666666666666666666666666666666666666667e-1 * t1390 + 0.19099978575000000000000000000000000000000000000000e-1 * t1399 - t820 - 0.51086658466666666666666666666666666666666666666667e-2 * t1402) * t826
  t1419 = (-t846 - 0.31311312500000000000000000000000000000000000000000e-3 * t1390) * t261
  t1425 = 0.87449329500000000000000000000000000000000000000000e-1 * t1396 - t855 - 0.10197214950000000000000000000000000000000000000000e-1 * t1390 + 0.55743564825000000000000000000000000000000000000000e-2 * t1399 - t858 - 0.27959805900000000000000000000000000000000000000000e-2 * t1402
  t1430 = t240 * (-(-t829 - 0.53236443333333333333333333333333333333333333333333e-3 * t1390) * t250 + t835 * (0.10973915025000000000000000000000000000000000000000e0 * t1396 - t837 - 0.16057207750000000000000000000000000000000000000000e-1 * t1390 + 0.19622842125000000000000000000000000000000000000000e-1 * t1399 - t840 - 0.32394225500000000000000000000000000000000000000000e-2 * t1402) * t843 + t1393 - t1406 - 0.58482233974552040708313425006184496242808878304904e0 * t1419 + 0.58482233974552040708313425006184496242808878304904e0 * t853 * t1425 * t861)
  t1431 = t240 * t1419
  t1435 = t869 * t852 * t1425 * t861
  t1446 = -0.18e0 * t1393 + 0.18e0 * t1406 + 0.18e0 * t1430 + 0.10526802115419367327496416501113209323705598094883e0 * t1431 - 0.10526802115419367327496416501113209323705598094883e0 * t1435
  t1508 = f.my_piecewise3(t42, 0, t1295)
  t1510 = t1074 * t1299
  t1512 = t11 * t1072 * t1510
  t1515 = (-t1071 - 0.11073577833333333333333333333333333333333333333333e-2 * t1512) * t397
  t1517 = -t1070 / 0.3e1 - t1512 / 0.3e1
  t1518 = t1084 * t1517
  t1521 = t1091 * t1517
  t1524 = t25 * t1097 * t1510
  t1528 = t1083 * (0.11807895435000000000000000000000000000000000000000e0 * t1518 - t1089 - 0.18590345266666666666666666666666666666666666666667e-1 * t1512 + 0.19099978575000000000000000000000000000000000000000e-1 * t1521 - t1096 - 0.51086658466666666666666666666666666666666666666667e-2 * t1524) * t1102
  t1541 = (-t1122 - 0.31311312500000000000000000000000000000000000000000e-3 * t1512) * t419
  t1547 = 0.87449329500000000000000000000000000000000000000000e-1 * t1518 - t1131 - 0.10197214950000000000000000000000000000000000000000e-1 * t1512 + 0.55743564825000000000000000000000000000000000000000e-2 * t1521 - t1134 - 0.27959805900000000000000000000000000000000000000000e-2 * t1524
  t1552 = t240 * (-(-t1105 - 0.53236443333333333333333333333333333333333333333333e-3 * t1512) * t408 + t1111 * (0.10973915025000000000000000000000000000000000000000e0 * t1518 - t1113 - 0.16057207750000000000000000000000000000000000000000e-1 * t1512 + 0.19622842125000000000000000000000000000000000000000e-1 * t1521 - t1116 - 0.32394225500000000000000000000000000000000000000000e-2 * t1524) * t1119 + t1515 - t1528 - 0.58482233974552040708313425006184496242808878304904e0 * t1541 + 0.58482233974552040708313425006184496242808878304904e0 * t1129 * t1547 * t1137)
  t1553 = t240 * t1541
  t1557 = t1145 * t1128 * t1547 * t1137
  t1561 = 0.1e1 / t428 / t426 / r1
  t1575 = -0.18e0 * t1515 + 0.18e0 * t1528 + 0.18e0 * t1552 + 0.10526802115419367327496416501113209323705598094883e0 * t1553 - 0.10526802115419367327496416501113209323705598094883e0 * t1557
  t1583 = 0.1e1 / t427 / t450 / t426
  t1657 = t1053 * t500
  t1663 = t1058 * t433 * t1060 * t511
  t1666 = -t1515 + t1528 + t1552 + 0.58482233974552040708313425006184496242808878304904e0 * t1553 - 0.58482233974552040708313425006184496242808878304904e0 * t1557 + 0.25507875555555555555555555555555555555555555555556e-1 * t619 * t273 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (-s2 * t1561 * t282 * t435 / 0.36e2 + t1153 + t1154 * t325 * t1157 * t1299 / 0.288e3 + 0.62778342784044964327823135763173517724332468147298e-1 * t1166 * t457 * t1575 * t1 * t445 - 0.46118654073199527744982290436835891381345926800472e-2 * t117 * t449 * t1583 * t458 + t1181 + 0.57648317591499409681227863046044864226682408500590e-3 * t1185 * t927 * t1188 * t1299) * t483 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t1200 * (0.20089069690894388584903403444215525671786389807135e1 * t1203 * t948 * t433 * t1575 * t445 - 0.73789846517119244391971664698937426210153482880755e-1 * t465 * t1561 * t281 * t112 * t468 + t1212 + 0.92237308146399055489964580873671782762691853600943e-2 * t1215 * t967 * t1216 * t1510 + 0.33353310806163204188335786414909188873612291223475e0 * t1225 * t927 * t456 * t1575 * t445 - 0.40837060867650113115391638521401320585607373199945e-2 * t476 * t1583 * t310 * t141 * t457 + t1233 + 0.51046326084562641394239548151751650732009216499931e-3 * t1236 * t998 * t1237 * t1510)) * t1248 + t177 * ((-t1252 - 0.19388333333333333333333333333333333333333333333333e1 * t1512 - t1254 - 0.12315000000000000000000000000000000000000000000000e-2 * t1524) * t498 - t1260 * (-t1261 - 0.72691666666666666666666666666666666666666666666667e3 * t1512 - t1263 - 0.78666666666666666666666666666666666666666666666667e2 * t1524)) * t271 * s2 * t513 / 0.2e1 - 0.4e1 / 0.3e1 * t503 * t1561 * t112 * t5 * t512 + t1276 + t1280 * t948 * t1281 * t1510 / 0.6e1 + 0.50e2 / 0.27e2 * t1657 * t273 * t448 * t1583 * t1663
  t1668 = f.my_piecewise3(t49, 0, t1299)
  vrho_1_ = t208 + t521 + t7 * (params.c1 * t1386 + t209 * ((-t1393 + t1406 + t1430 + 0.58482233974552040708313425006184496242808878304904e0 * t1431 - 0.58482233974552040708313425006184496242808878304904e0 * t1435 + 0.25507875555555555555555555555555555555555555555556e-1 * t619 * t273 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t884 + t886 * t325 * t889 * t1295 / 0.288e3 + 0.62778342784044964327823135763173517724332468147298e-1 * t900 * t314 * t1446 * t1 * t298 + t922 + 0.57648317591499409681227863046044864226682408500590e-3 * t926 * t927 * t930 * t1295) * t341 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t942 * (0.20089069690894388584903403444215525671786389807135e1 * t947 * t948 * t284 * t1446 * t298 + t962 + 0.92237308146399055489964580873671782762691853600943e-2 * t965 * t967 * t968 * t1388 + 0.33353310806163204188335786414909188873612291223475e0 * t981 * t927 * t313 * t1446 * t298 + t994 + 0.51046326084562641394239548151751650732009216499931e-3 * t997 * t998 * t999 * t1388)) * t1010 + t177 * ((-t1014 - 0.19388333333333333333333333333333333333333333333333e1 * t1390 - t1016 - 0.12315000000000000000000000000000000000000000000000e-2 * t1402) * t356 - t1022 * (-t1023 - 0.72691666666666666666666666666666666666666666666667e3 * t1390 - t1025 - 0.78666666666666666666666666666666666666666666666667e2 * t1402)) * t271 * s0 * t373 / 0.2e1 + t1043 + t1047 * t948 * t1048 * t1388 / 0.6e1) * t377 / 0.2e1 + t376 * t1508 / 0.2e1 + t1666 * t517 / 0.2e1 + t516 * t1668 / 0.2e1))
  t1677 = t153 * t110 * t643 * t5
  t1681 = t117 * t131 * t105 * t144
  t1689 = t149 * t150 * t156
  t1693 = t159 * t162 * t105 * t144
  t1705 = t177 * t187 * t204
  t1714 = t1053 * t186 * t100 * t105 * t557 * t137 * t6 * t191 * t202
  t1717 = params.c1 * (0.25507875555555555555555555555555555555555555555556e-1 * t619 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t1677 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t1681) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t701 * (0.27671192443919716646989374262101534828807556080283e-1 * t1689 + 0.15313897825368792418271864445525495219602764949979e-2 * t1693)) * t742 + t1705 / 0.2e1 - 0.25e2 / 0.36e2 * t1714)
  vsigma_0_ = t7 * (t1717 + t209 * (0.25507875555555555555555555555555555555555555555556e-1 * t619 * t273 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t323 * t19 * t286 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t117 * t963 * t306 * t315) * t341 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t942 * (0.27671192443919716646989374262101534828807556080283e-1 * t149 * t320 * t279 * t966 * t326 + 0.15313897825368792418271864445525495219602764949979e-2 * t159 * t332 * s0 * t337)) * t1010 + t177 * t359 * t279 * t113 * t372 / 0.2e1 - 0.25e2 / 0.36e2 * t1054 * t273 * s0 * t306 * t1062) * t377 / 0.2e1)
  vsigma_1_ = t7 * params.c1 * (0.25507875555555555555555555555555555555555555555556e-1 * t619 * t100 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t1677 / 0.48e2 + 0.34588990554899645808736717827626918536009445100354e-2 * t1681) * t168 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t701 * (0.55342384887839433293978748524203069657615112160566e-1 * t1689 + 0.30627795650737584836543728891050990439205529899958e-2 * t1693)) * t742 + t1705 - 0.25e2 / 0.18e2 * t1714)
  vsigma_2_ = t7 * (t1717 + t209 * (0.25507875555555555555555555555555555555555555555556e-1 * t619 * t273 * (0.88547815820543093270365997638724911452184179456905e0 * t102 * t103 * (t466 * t19 * t435 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t117 * t1213 * t453 * t458) * t483 - 0.88547815820543093270365997638724911452184179456905e0 * t698 * t1200 * (0.27671192443919716646989374262101534828807556080283e-1 * t149 * t463 * t430 * t966 * t468 + 0.15313897825368792418271864445525495219602764949979e-2 * t159 * t474 * s2 * t479)) * t1248 + t177 * t501 * t430 * t113 * t512 / 0.2e1 - 0.25e2 / 0.36e2 * t1657 * t273 * s2 * t453 * t1663) * t517 / 0.2e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c1_raw = params.c1
  if isinstance(params_c1_raw, (str, bytes, dict)):
    params_c1 = params_c1_raw
  else:
    try:
      params_c1_seq = list(params_c1_raw)
    except TypeError:
      params_c1 = params_c1_raw
    else:
      params_c1_seq = np.asarray(params_c1_seq, dtype=np.float64)
      params_c1 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c1_seq))
  params_c2_raw = params.c2
  if isinstance(params_c2_raw, (str, bytes, dict)):
    params_c2 = params_c2_raw
  else:
    try:
      params_c2_seq = list(params_c2_raw)
    except TypeError:
      params_c2 = params_c2_raw
    else:
      params_c2_seq = np.asarray(params_c2_seq, dtype=np.float64)
      params_c2 = np.concatenate((np.array([np.nan], dtype=np.float64), params_c2_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  pw91_C_c0 = 0.004235

  pw91_alpha = 0.09

  pw91_nu = 16 / jnp.pi * (3 * jnp.pi ** 2) ** (1 / 3)

  RS_a = np.array([np.nan, 2.568, 23.266, 0.007389], dtype=np.float64)

  RS_b = np.array([np.nan, 1, 8.723, 0.472], dtype=np.float64)

  C_xc0 = 0.002568

  C_x = -0.001667

  h_a1 = -100 * 4 / jnp.pi * (4 / (9 * jnp.pi)) ** (1 / 3)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  pw91_beta = pw91_nu * pw91_C_c0

  RG_C_xc = lambda rs: (RS_a[1] + RS_a[2] * rs + RS_a[3] * rs ** 2) / (1000 * (RS_b[1] + RS_b[2] * rs + RS_b[3] * rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  pw91_c1 = pw91_beta ** 2 / (2 * pw91_alpha)

  pw91_c2 = 2 * pw91_alpha / pw91_beta

  H1 = lambda rs, z, t: pw91_nu * (RG_C_xc(rs) - C_xc0 - 3 * C_x / 7) * f.mphi(z) ** 3 * t ** 2 * jnp.exp(h_a1 * rs * f.mphi(z) ** 4 * t ** 2)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z: pw91_c2 / (jnp.exp(-2 * pw91_alpha * f_pw(rs, z) / (f.mphi(z) ** 3 * pw91_beta ** 2)) - 1)

  H0 = lambda rs, z, t: pw91_c1 * f.mphi(z) ** 3 * jnp.log(1 + pw91_c2 * (t ** 2 + A(rs, z) * t ** 4) / (1 + A(rs, z) * t ** 2 + A(rs, z) ** 2 * t ** 4))

  f_pw91 = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + H0(rs, z, f.tt(rs, z, xt)) + H1(rs, z, f.tt(rs, z, xt))

  optc_f2 = lambda rs, z, xt, xs0, xs1: +f_pw91(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0, xs0, 0) * f.opz_pow_n(z, 1) / 2 + f_pw91(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1, 0, xs1) * f.opz_pow_n(-z, 1) / 2

  functional_body = lambda rs, z, xt, xs0, xs1: +params_c1 * f_pw91(rs, z, xt, xs0, xs1) + (params_c2 - params_c1) * optc_f2(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = t6 / t7
  t10 = t4 * t9
  t12 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t23 = t5 / t21
  t24 = t20 * t23
  t26 = 0.23615790870000000000000000000000000000000000000000e0 * t13 + 0.55771035800000000000000000000000000000000000000000e-1 * t10 + 0.12733319050000000000000000000000000000000000000000e-1 * t16 + 0.76629987700000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t33 = t32 * f.p.zeta_threshold
  t34 = f.my_piecewise3(t31, t33, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = (0.2e1 * t34 - 0.2e1) * t40
  t43 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489865900000000000000000000000000000000000000000e0 * t13 + 0.30591644850000000000000000000000000000000000000000e-1 * t10 + 0.37162376550000000000000000000000000000000000000000e-2 * t16 + 0.41939708850000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t53 = t41 * t43 * t51
  t55 = jnp.pi ** 2
  t56 = 0.1e1 / t55
  t57 = t56 * t18
  t58 = t55 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t65 = jnp.pi * t18
  t66 = 0.1e1 / t58
  t67 = r0 ** 2
  t69 = 0.1e1 / t7 / t67
  t70 = s0 * t69
  t72 = 0.1e1 / t62
  t74 = 0.1e1 / t3
  t75 = t74 * t5
  t76 = t72 * t18 * t75
  t79 = jnp.pi * t66
  t84 = 0.1e1 / t59
  t85 = t1 * t84
  t90 = jnp.exp(-0.72599219320266867760696246260269014374413107911013e2 * (-0.18e0 * t30 + 0.10526802115419367327496416501113209323705598094883e0 * t53) * t55 * t85 / t63)
  t91 = t90 - 0.1e1
  t92 = 0.1e1 / t91
  t93 = s0 ** 2
  t95 = t79 * t92 * t93
  t96 = t67 ** 2
  t98 = 0.1e1 / t21 / t96
  t99 = t37 ** 2
  t101 = t62 ** 2
  t103 = 0.1e1 / t19
  t105 = 0.1e1 / t101 * t103 * t6
  t106 = t98 * t99 * t105
  t109 = t70 * t37 * t76 / 0.96e2 + 0.86472476387249114521841794569067296340023612750885e-3 * t95 * t106
  t111 = jnp.pi * t1
  t112 = t66 * t92
  t114 = t111 * t112 * s0
  t115 = t69 * t37
  t117 = t72 * t74 * t5
  t118 = t115 * t117
  t121 = t55 * t18
  t122 = t91 ** 2
  t123 = 0.1e1 / t122
  t124 = t84 * t123
  t126 = t121 * t124 * t93
  t129 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t114 * t118 + 0.76569489126843962091359322227627476098013824749896e-3 * t126 * t106
  t130 = 0.1e1 / t129
  t134 = 0.1e1 + 0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * t109 * t130
  t135 = jnp.log(t134)
  t139 = t2 * t58
  t142 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t10 + 0.18472500000000000000000000000000000000000000000000e-2 * t24
  t145 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t10 + 0.11800000000000000000000000000000000000000000000000e3 * t24
  t146 = 0.1e1 / t145
  t148 = t142 * t146 - 0.18535714285714285714285714285714285714285714285714e-2
  t149 = t148 * t61
  t151 = t139 * t149 * s0
  t152 = 9 ** (0.1e1 / 0.3e1)
  t153 = t152 ** 2
  t154 = t2 * t153
  t156 = 0.1e1 / t21 / t67
  t164 = jnp.exp(-0.25e2 / 0.18e2 * t154 * t3 * t156 * t62 * s0 * t37 * t5)
  t165 = t75 * t164
  t166 = t115 * t165
  t171 = params.c2 - params.c1
  t173 = t4 * t9 * t37
  t175 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t173
  t176 = jnp.sqrt(t173)
  t179 = t173 ** 0.15e1
  t182 = t20 * t23 * t99
  t184 = 0.23615790870000000000000000000000000000000000000000e0 * t176 + 0.55771035800000000000000000000000000000000000000000e-1 * t173 + 0.12733319050000000000000000000000000000000000000000e-1 * t179 + 0.76629987700000000000000000000000000000000000000000e-2 * t182
  t186 = 0.1e1 + 0.1e1 / t184
  t187 = jnp.log(t186)
  t188 = t175 * t187
  t189 = 0.2e1 <= f.p.zeta_threshold
  t191 = f.my_piecewise3(t189, t33, 0.2e1 * t37)
  t192 = 0.0e0 <= f.p.zeta_threshold
  t193 = f.my_piecewise3(t192, t33, 0)
  t195 = (t191 + t193 - 0.2e1) * t40
  t197 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t173
  t202 = 0.21947830050000000000000000000000000000000000000000e0 * t176 + 0.48171623250000000000000000000000000000000000000000e-1 * t173 + 0.13081894750000000000000000000000000000000000000000e-1 * t179 + 0.48591338250000000000000000000000000000000000000000e-2 * t182
  t204 = 0.1e1 + 0.1e1 / t202
  t205 = jnp.log(t204)
  t208 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t173
  t213 = 0.17489865900000000000000000000000000000000000000000e0 * t176 + 0.30591644850000000000000000000000000000000000000000e-1 * t173 + 0.37162376550000000000000000000000000000000000000000e-2 * t179 + 0.41939708850000000000000000000000000000000000000000e-2 * t182
  t215 = 0.1e1 + 0.1e1 / t213
  t216 = jnp.log(t215)
  t217 = t208 * t216
  t220 = t195 * (-t197 * t205 + t188 - 0.58482233974552040708313425006184496242808878304904e0 * t217)
  t221 = t195 * t217
  t223 = f.my_piecewise3(t189, t60, t99)
  t224 = f.my_piecewise3(t192, t60, 0)
  t226 = t223 / 0.2e1 + t224 / 0.2e1
  t227 = t226 ** 2
  t228 = t227 * t226
  t230 = 0.1e1 / t227
  t232 = t18 * t74
  t233 = t5 * t99
  t234 = t232 * t233
  t246 = jnp.exp(-0.72599219320266867760696246260269014374413107911013e2 * (-0.18e0 * t188 + 0.18e0 * t220 + 0.10526802115419367327496416501113209323705598094883e0 * t221) * t55 * t85 / t228)
  t247 = t246 - 0.1e1
  t248 = 0.1e1 / t247
  t250 = t79 * t248 * t93
  t251 = t227 ** 2
  t252 = 0.1e1 / t251
  t255 = t103 * t6 * t37
  t256 = t98 * t252 * t255
  t259 = t70 * t230 * t234 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t250 * t256
  t261 = t66 * t248
  t263 = t111 * t261 * s0
  t264 = t69 * t230
  t265 = t75 * t99
  t266 = t264 * t265
  t269 = t247 ** 2
  t270 = 0.1e1 / t269
  t271 = t84 * t270
  t273 = t121 * t271 * t93
  t276 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t263 * t266 + 0.15313897825368792418271864445525495219602764949979e-2 * t273 * t256
  t277 = 0.1e1 / t276
  t281 = 0.1e1 + 0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * t259 * t277
  t282 = jnp.log(t281)
  t288 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t173 + 0.18472500000000000000000000000000000000000000000000e-2 * t182
  t291 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t173 + 0.11800000000000000000000000000000000000000000000000e3 * t182
  t292 = 0.1e1 / t291
  t294 = t288 * t292 - 0.18535714285714285714285714285714285714285714285714e-2
  t295 = t294 * t226
  t297 = t139 * t295 * s0
  t305 = jnp.exp(-0.25e2 / 0.9e1 * t154 * t3 * t156 * t227 * s0 * t5)
  t306 = t233 * t305
  t307 = t69 * t74 * t306
  t312 = f.my_piecewise3(t31, f.p.zeta_threshold, 1)
  t315 = 0.1e1 / t7 / r0
  t316 = t6 * t315
  t318 = t4 * t316 * t29
  t320 = t26 ** 2
  t325 = t3 * t6
  t326 = t325 * t315
  t327 = 0.1e1 / t13 * t1 * t326
  t329 = t4 * t316
  t331 = t10 ** 0.5e0
  t333 = t331 * t1 * t326
  t337 = t5 / t21 / r0
  t338 = t20 * t337
  t343 = t12 / t320 * (-0.39359651450000000000000000000000000000000000000000e-1 * t327 - 0.18590345266666666666666666666666666666666666666667e-1 * t329 - 0.63666595250000000000000000000000000000000000000000e-2 * t333 - 0.51086658466666666666666666666666666666666666666667e-2 * t338) / t28
  t347 = t41 * t1 * t325 * t315 * t51
  t350 = t48 ** 2
  t360 = t41 * t43 / t350 * (-0.29149776500000000000000000000000000000000000000000e-1 * t327 - 0.10197214950000000000000000000000000000000000000000e-1 * t329 - 0.18581188275000000000000000000000000000000000000000e-2 * t333 - 0.27959805900000000000000000000000000000000000000000e-2 * t338) / t50
  t362 = t57 * t59
  t365 = 0.1e1 / t7 / t67 / r0
  t366 = s0 * t365
  t371 = t93 * t98
  t375 = 0.1e1 / t101 / t63
  t382 = 0.19932440099999999999999999999999999999999999999999e-3 * t318 + 0.18e0 * t343 - 0.32960799066155687894353013969651229501245963994829e-4 * t347 - 0.10526802115419367327496416501113209323705598094883e0 * t360
  t388 = t96 * r0
  t390 = 0.1e1 / t21 / t388
  t392 = t390 * t99 * t105
  t400 = t65 * t66
  t401 = t129 ** 2
  t403 = t109 / t401
  t416 = t365 * t37
  t420 = t55 ** 2
  t423 = t420 / t58 / t55
  t444 = 0.1e1 / t134
  t452 = t145 ** 2
  t468 = t56 * t58
  t469 = t148 * t63
  t473 = 0.1e1 / t96 / t67
  t476 = t6 * t153 * t164
  t482 = t4 * t6
  t483 = t315 * t37
  t485 = t482 * t483 * t187
  t486 = 0.11073577833333333333333333333333333333333333333333e-2 * t485
  t487 = t184 ** 2
  t493 = t316 * t37
  t494 = 0.1e1 / t176 * t1 * t3 * t493
  t496 = t4 * t493
  t498 = t173 ** 0.5e0
  t501 = t498 * t1 * t3 * t493
  t504 = t20 * t337 * t99
  t509 = t175 / t487 * (-0.39359651450000000000000000000000000000000000000000e-1 * t494 - 0.18590345266666666666666666666666666666666666666667e-1 * t496 - 0.63666595250000000000000000000000000000000000000000e-2 * t501 - 0.51086658466666666666666666666666666666666666666667e-2 * t504) / t186
  t513 = t202 ** 2
  t527 = t213 ** 2
  t528 = 0.1e1 / t527
  t534 = -0.29149776500000000000000000000000000000000000000000e-1 * t494 - 0.10197214950000000000000000000000000000000000000000e-1 * t496 - 0.18581188275000000000000000000000000000000000000000e-2 * t501 - 0.27959805900000000000000000000000000000000000000000e-2 * t504
  t535 = 0.1e1 / t215
  t540 = t195 * (0.53236443333333333333333333333333333333333333333333e-3 * t482 * t483 * t205 + t197 / t513 * (-0.36579716750000000000000000000000000000000000000000e-1 * t494 - 0.16057207750000000000000000000000000000000000000000e-1 * t496 - 0.65409473750000000000000000000000000000000000000000e-2 * t501 - 0.32394225500000000000000000000000000000000000000000e-2 * t504) / t204 - t486 - t509 + 0.18311555036753159941307229983139571945136646663793e-3 * t482 * t483 * t216 + 0.58482233974552040708313425006184496242808878304904e0 * t208 * t528 * t534 * t535)
  t544 = t195 * t4 * t316 * t37 * t216
  t549 = t195 * t208 * t528 * t534 * t535
  t556 = 0.1e1 / t251 / t228
  t564 = 0.19932440099999999999999999999999999999999999999999e-3 * t485 + 0.18e0 * t509 + 0.18e0 * t540 - 0.32960799066155687894353013969651229501245963994829e-4 * t544 - 0.10526802115419367327496416501113209323705598094883e0 * t549
  t571 = t390 * t252 * t255
  t579 = t276 ** 2
  t581 = t259 / t579
  t618 = 0.1e1 / t281
  t626 = t291 ** 2
  t643 = t294 * t228
  t648 = t99 * t153 * t305
  vrho_0_ = params.c1 * (-t30 + 0.58482233974552040708313425006184496242808878304904e0 * t53 + 0.25507875555555555555555555555555555555555555555556e-1 * t57 * t59 * t63 * t135 + t151 * t166 / 0.2e1) + t171 * (-t188 + t220 + 0.58482233974552040708313425006184496242808878304904e0 * t221 + 0.25507875555555555555555555555555555555555555555556e-1 * t57 * t59 * t228 * t282 + t297 * t307 / 0.2e1) * t312 + r0 * (params.c1 * (0.11073577833333333333333333333333333333333333333333e-2 * t318 + t343 - 0.18311555036753159941307229983139571945136646663793e-3 * t347 - 0.58482233974552040708313425006184496242808878304904e0 * t360 + 0.25507875555555555555555555555555555555555555555556e-1 * t362 * t63 * (0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * (-0.7e1 / 0.288e3 * t366 * t37 * t76 + 0.62778342784044964327823135763173517724332468147298e-1 * jnp.pi * t123 * t371 * t99 * t375 * t103 * t6 * t382 * t1 * t90 - 0.40353822314049586776859504132231404958677685950413e-2 * t95 * t392) * t130 - 0.88547815820543093270365997638724911452184179456905e0 * t400 * t403 * (0.20089069690894388584903403444215525671786389807135e1 * t65 * t123 * s0 * t69 * t37 / t101 / t61 * t74 * t5 * t382 * t90 - 0.64566115702479338842975206611570247933884297520660e-1 * t114 * t416 * t117 + 0.33353310806163204188335786414909188873612291223475e0 * t423 / t122 / t91 * t93 * t98 * t99 * t375 * t103 * t6 * t382 * t90 - 0.35732428259193848975967683706226155512406451549951e-2 * t126 * t392)) * t444 + t139 * ((-0.19388333333333333333333333333333333333333333333333e1 * t329 - 0.12315000000000000000000000000000000000000000000000e-2 * t338) * t146 - t142 / t452 * (-0.72691666666666666666666666666666666666666666666667e3 * t329 - 0.78666666666666666666666666666666666666666666666667e2 * t338)) * t61 * s0 * t166 / 0.2e1 - 0.7e1 / 0.6e1 * t151 * t416 * t165 + 0.50e2 / 0.27e2 * t468 * t469 * t93 * t473 * t99 * t476) + t171 * (t486 + t509 + t540 - 0.18311555036753159941307229983139571945136646663793e-3 * t544 - 0.58482233974552040708313425006184496242808878304904e0 * t549 + 0.25507875555555555555555555555555555555555555555556e-1 * t362 * t228 * (0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * (-0.7e1 / 0.288e3 * t366 * t230 * t234 + 0.12555668556808992865564627152634703544866493629460e0 * jnp.pi * t270 * t371 * t556 * t255 * t564 * t1 * t246 - 0.80707644628099173553719008264462809917355371900826e-2 * t250 * t571) * t277 - 0.88547815820543093270365997638724911452184179456905e0 * t400 * t581 * (0.20089069690894388584903403444215525671786389807135e1 * t65 * t270 * s0 * t69 / t251 / t226 * t74 * t5 * t99 * t564 * t246 - 0.64566115702479338842975206611570247933884297520660e-1 * t263 * t365 * t230 * t265 + 0.66706621612326408376671572829818377747224582446949e0 * t423 / t269 / t247 * t93 * t98 * t556 * t103 * t6 * t37 * t564 * t246 - 0.71464856518387697951935367412452311024812903099902e-2 * t273 * t571)) * t618 + t139 * ((-0.19388333333333333333333333333333333333333333333333e1 * t496 - 0.12315000000000000000000000000000000000000000000000e-2 * t504) * t292 - t288 / t626 * (-0.72691666666666666666666666666666666666666666666667e3 * t496 - 0.78666666666666666666666666666666666666666666666667e2 * t504)) * t226 * s0 * t307 / 0.2e1 - 0.7e1 / 0.6e1 * t297 * t365 * t74 * t306 + 0.100e3 / 0.27e2 * t468 * t643 * t93 * t473 * t6 * t648) * t312)
  t691 = 0.1e1 / t388
  vsigma_0_ = r0 * (params.c1 * (0.25507875555555555555555555555555555555555555555556e-1 * t362 * t63 * (0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * (t115 * t72 * t232 * t5 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t79 * t92 * s0 * t106) * t130 - 0.88547815820543093270365997638724911452184179456905e0 * t400 * t403 * (0.27671192443919716646989374262101534828807556080283e-1 * t111 * t112 * t118 + 0.15313897825368792418271864445525495219602764949979e-2 * t121 * t124 * s0 * t106)) * t444 + t139 * t149 * t166 / 0.2e1 - 0.25e2 / 0.36e2 * t468 * t469 * s0 * t691 * t99 * t476) + t171 * (0.25507875555555555555555555555555555555555555555556e-1 * t362 * t228 * (0.88547815820543093270365997638724911452184179456905e0 * t65 * t66 * (t264 * t18 * t265 / 0.96e2 + 0.34588990554899645808736717827626918536009445100354e-2 * t79 * t248 * s0 * t256) * t277 - 0.88547815820543093270365997638724911452184179456905e0 * t400 * t581 * (0.27671192443919716646989374262101534828807556080283e-1 * t111 * t261 * t266 + 0.30627795650737584836543728891050990439205529899958e-2 * t121 * t271 * s0 * t256)) * t618 + t139 * t295 * t307 / 0.2e1 - 0.25e2 / 0.18e2 * t468 * t643 * s0 * t691 * t6 * t648) * t312)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t12 = t6 / t7
  t13 = t4 * t12
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t24 = t5 / t22
  t25 = t21 * t24
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t27
  t31 = jnp.log(t30)
  t34 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t54 = t5 / t22 / r0
  t55 = t21 * t54
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t61 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t64 = t63 * f.p.zeta_threshold
  t65 = f.my_piecewise3(t62, t64, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t71 = 0.1e1 / (0.2e1 * t68 - 0.2e1)
  t72 = (0.2e1 * t65 - 0.2e1) * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t78
  t82 = jnp.log(t81)
  t86 = 0.18311555036753159941307229983139571945136646663793e-3 * t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t101 = 0.58482233974552040708313425006184496242808878304903e0 * t89 * t99
  t102 = jnp.pi ** 2
  t103 = 0.1e1 / t102
  t105 = t102 ** (0.1e1 / 0.3e1)
  t106 = t105 ** 2
  t107 = t103 * t19 * t106
  t108 = t63 ** 2
  t109 = f.my_piecewise3(t62, t108, 1)
  t110 = t109 ** 2
  t111 = t110 * t109
  t112 = jnp.pi * t19
  t113 = 0.1e1 / t105
  t114 = r0 ** 2
  t115 = t114 * r0
  t117 = 0.1e1 / t7 / t115
  t118 = s0 * t117
  t120 = 0.1e1 / t110
  t122 = 0.1e1 / t3
  t123 = t122 * t5
  t124 = t120 * t19 * t123
  t136 = 0.1e1 / t106
  t137 = t102 * t1 * t136
  t140 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * (-0.62182e-1 * t36 * t31 + 0.19751789702565206228825776161588751761046270558698e-1 * t72 * t88 * t82) / t111 * t137)
  t141 = t140 - 0.1e1
  t142 = t141 ** 2
  t143 = 0.1e1 / t142
  t144 = jnp.pi * t143
  t145 = s0 ** 2
  t146 = t114 ** 2
  t148 = 0.1e1 / t22 / t146
  t149 = t145 * t148
  t150 = t68 ** 2
  t151 = t149 * t150
  t152 = t144 * t151
  t153 = t110 ** 2
  t155 = 0.1e1 / t153 / t111
  t156 = 0.1e1 / t20
  t158 = t155 * t156 * t6
  t159 = t34 + t61 - t86 - t101
  t162 = t158 * t159 * t1 * t140
  t165 = jnp.pi * t113
  t166 = 0.1e1 / t141
  t168 = t165 * t166 * t145
  t169 = t146 * r0
  t171 = 0.1e1 / t22 / t169
  t173 = 0.1e1 / t153
  t175 = t173 * t156 * t6
  t176 = t171 * t150 * t175
  t179 = -0.7e1 / 0.288e3 * t118 * t68 * t124 + 0.11300101701128093579008164437371233190379844266515e-1 * t152 * t162 - 0.40353822314049586776859504132231404958677685950414e-2 * t168 * t176
  t181 = jnp.pi * t1
  t182 = t113 * t166
  t184 = t181 * t182 * s0
  t186 = 0.1e1 / t7 / t114
  t187 = t186 * t68
  t189 = t120 * t122 * t5
  t190 = t187 * t189
  t193 = t102 * t19
  t194 = t136 * t143
  t196 = t193 * t194 * t145
  t197 = t148 * t150
  t198 = t197 * t175
  t201 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t184 * t190 + 0.76569489126843962091359322227627476098013824749894e-3 * t196 * t198
  t202 = 0.1e1 / t201
  t206 = t112 * t113
  t207 = s0 * t186
  t208 = t207 * t68
  t213 = t208 * t124 / 0.96e2 + 0.86472476387249114521841794569067296340023612750888e-3 * t168 * t198
  t214 = t201 ** 2
  t215 = 0.1e1 / t214
  t216 = t213 * t215
  t217 = t143 * s0
  t219 = t112 * t217 * t186
  t220 = t153 * t109
  t221 = 0.1e1 / t220
  t223 = t68 * t221 * t122
  t225 = t5 * t159 * t140
  t226 = t223 * t225
  t229 = t117 * t68
  t230 = t229 * t189
  t233 = t102 ** 2
  t236 = t233 / t105 / t102
  t238 = 0.1e1 / t142 / t141
  t239 = t238 * t145
  t241 = t236 * t239 * t148
  t243 = t150 * t155 * t156
  t246 = t243 * t6 * t159 * t140
  t251 = 0.36160325443609899452826126199587946209215501652845e0 * t219 * t226 - 0.64566115702479338842975206611570247933884297520660e-1 * t184 * t230 + 0.60035959451093767539004415546836539972502124202256e-1 * t241 * t246 - 0.35732428259193848975967683706226155512406451549951e-2 * t196 * t176
  t255 = 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t179 * t202 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t216 * t251
  t261 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t213 * t202
  t262 = 0.1e1 / t261
  t266 = t2 * t105
  t269 = -0.19388333333333333333333333333333333333333333333333e1 * t46 - 0.12315000000000000000000000000000000000000000000000e-2 * t55
  t272 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t13 + 0.11800000000000000000000000000000000000000000000000e3 * t25
  t273 = 0.1e1 / t272
  t277 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t13 + 0.18472500000000000000000000000000000000000000000000e-2 * t25
  t278 = t272 ** 2
  t279 = 0.1e1 / t278
  t280 = t277 * t279
  t283 = -0.72691666666666666666666666666666666666666666666667e3 * t46 - 0.78666666666666666666666666666666666666666666666667e2 * t55
  t285 = t269 * t273 - t280 * t283
  t286 = t285 * t109
  t288 = t266 * t286 * s0
  t289 = t2 * t5
  t290 = 9 ** (0.1e1 / 0.3e1)
  t291 = t290 ** 2
  t295 = 0.1e1 / t22 / t114
  t301 = jnp.exp(-0.25e2 / 0.18e2 * t289 * t291 * t3 * t295 * t110 * s0 * t68)
  t302 = t123 * t301
  t303 = t187 * t302
  t307 = t277 * t273 - 0.18535714285714285714285714285714285714285714285714e-2
  t308 = t307 * t109
  t310 = t266 * t308 * s0
  t311 = t229 * t302
  t314 = t103 * t105
  t315 = t307 * t111
  t317 = t314 * t315 * t145
  t318 = t146 * t114
  t319 = 0.1e1 / t318
  t322 = t6 * t291 * t301
  t323 = t319 * t150 * t322
  t329 = params.c2 - params.c1
  t330 = t4 * t6
  t331 = t9 * t68
  t333 = t4 * t12 * t68
  t334 = jnp.sqrt(t333)
  t337 = t333 ** 0.15e1
  t340 = t21 * t24 * t150
  t342 = 0.37978500000000000000000000000000000000000000000000e1 * t334 + 0.89690000000000000000000000000000000000000000000000e0 * t333 + 0.20477500000000000000000000000000000000000000000000e0 * t337 + 0.12323500000000000000000000000000000000000000000000e0 * t340
  t345 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t342
  t346 = jnp.log(t345)
  t349 = 0.11073577833333333333333333333333333333333333333333e-2 * t330 * t331 * t346
  t351 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t333
  t352 = t342 ** 2
  t353 = 0.1e1 / t352
  t354 = t351 * t353
  t357 = 0.1e1 / t334 * t1 * t3
  t358 = t10 * t68
  t359 = t357 * t358
  t361 = t4 * t358
  t363 = t333 ** 0.5e0
  t365 = t363 * t1 * t3
  t366 = t365 * t358
  t369 = t21 * t54 * t150
  t371 = -0.63297500000000000000000000000000000000000000000000e0 * t359 - 0.29896666666666666666666666666666666666666666666667e0 * t361 - 0.10238750000000000000000000000000000000000000000000e0 * t366 - 0.82156666666666666666666666666666666666666666666667e-1 * t369
  t372 = 0.1e1 / t345
  t373 = t371 * t372
  t375 = 0.10000000000000000000000000000000000000000000000000e1 * t354 * t373
  t376 = 0.2e1 <= f.p.zeta_threshold
  t378 = f.my_piecewise3(t376, t64, 0.2e1 * t68)
  t379 = 0.0e0 <= f.p.zeta_threshold
  t380 = f.my_piecewise3(t379, t64, 0)
  t382 = (t378 + t380 - 0.2e1) * t71
  t387 = 0.70594500000000000000000000000000000000000000000000e1 * t334 + 0.15494250000000000000000000000000000000000000000000e1 * t333 + 0.42077500000000000000000000000000000000000000000000e0 * t337 + 0.15629250000000000000000000000000000000000000000000e0 * t340
  t390 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t387
  t391 = jnp.log(t390)
  t396 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t333
  t397 = t387 ** 2
  t398 = 0.1e1 / t397
  t399 = t396 * t398
  t404 = -0.11765750000000000000000000000000000000000000000000e1 * t359 - 0.51647500000000000000000000000000000000000000000000e0 * t361 - 0.21038750000000000000000000000000000000000000000000e0 * t366 - 0.10419500000000000000000000000000000000000000000000e0 * t369
  t405 = 0.1e1 / t390
  t406 = t404 * t405
  t413 = 0.51785000000000000000000000000000000000000000000000e1 * t334 + 0.90577500000000000000000000000000000000000000000000e0 * t333 + 0.11003250000000000000000000000000000000000000000000e0 * t337 + 0.12417750000000000000000000000000000000000000000000e0 * t340
  t416 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t413
  t417 = jnp.log(t416)
  t422 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t333
  t423 = t413 ** 2
  t424 = 0.1e1 / t423
  t425 = t422 * t424
  t430 = -0.86308333333333333333333333333333333333333333333334e0 * t359 - 0.30192500000000000000000000000000000000000000000000e0 * t361 - 0.55016250000000000000000000000000000000000000000000e-1 * t366 - 0.82785000000000000000000000000000000000000000000000e-1 * t369
  t431 = 0.1e1 / t416
  t432 = t430 * t431
  t436 = t382 * (0.53236443333333333333333333333333333333333333333332e-3 * t330 * t331 * t391 + 0.99999999999999999999999999999999999999999999999999e0 * t399 * t406 - t349 - t375 + 0.18311555036753159941307229983139571945136646663793e-3 * t330 * t331 * t417 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t432)
  t437 = t382 * t4
  t438 = t68 * t417
  t441 = 0.18311555036753159941307229983139571945136646663793e-3 * t437 * t10 * t438
  t442 = t382 * t422
  t444 = t424 * t430 * t431
  t446 = 0.58482233974552040708313425006184496242808878304903e0 * t442 * t444
  t447 = f.my_piecewise3(t376, t108, t150)
  t448 = f.my_piecewise3(t379, t108, 0)
  t450 = t447 / 0.2e1 + t448 / 0.2e1
  t451 = t450 ** 2
  t452 = t451 * t450
  t453 = 0.1e1 / t451
  t455 = t19 * t122
  t456 = t5 * t150
  t457 = t455 * t456
  t461 = 0.62182e-1 * t351 * t346
  t464 = t422 * t417
  t475 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * (-t461 + t382 * (-0.31090e-1 * t396 * t391 + t461 - 0.19751789702565206228825776161588751761046270558698e-1 * t464) + 0.19751789702565206228825776161588751761046270558698e-1 * t382 * t464) / t452 * t137)
  t476 = t475 - 0.1e1
  t477 = t476 ** 2
  t478 = 0.1e1 / t477
  t479 = jnp.pi * t478
  t480 = t451 ** 2
  t482 = 0.1e1 / t480 / t452
  t484 = t479 * t149 * t482
  t485 = t156 * t6
  t486 = t485 * t68
  t487 = t349 + t375 + t436 - t441 - t446
  t490 = t486 * t487 * t1 * t475
  t493 = 0.1e1 / t476
  t495 = t165 * t493 * t145
  t496 = 0.1e1 / t480
  t498 = t171 * t496 * t486
  t501 = -0.7e1 / 0.288e3 * t118 * t453 * t457 + 0.22600203402256187158016328874742466380759688533028e-1 * t484 * t490 - 0.80707644628099173553719008264462809917355371900826e-2 * t495 * t498
  t503 = t113 * t493
  t505 = t181 * t503 * s0
  t506 = t186 * t453
  t507 = t123 * t150
  t508 = t506 * t507
  t511 = t136 * t478
  t513 = t193 * t511 * t145
  t515 = t148 * t496 * t486
  t518 = 0.1e1 + 0.27671192443919716646989374262101534828807556080282e-1 * t505 * t508 + 0.15313897825368792418271864445525495219602764949979e-2 * t513 * t515
  t519 = 0.1e1 / t518
  t528 = t207 * t453 * t457 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t495 * t515
  t529 = t518 ** 2
  t530 = 0.1e1 / t529
  t531 = t528 * t530
  t532 = t478 * s0
  t534 = t112 * t532 * t186
  t535 = t480 * t450
  t536 = 0.1e1 / t535
  t538 = t536 * t122 * t5
  t540 = t150 * t487 * t475
  t541 = t538 * t540
  t544 = t117 * t453
  t545 = t544 * t507
  t549 = 0.1e1 / t477 / t476
  t550 = t549 * t145
  t552 = t236 * t550 * t148
  t554 = t482 * t156 * t6
  t557 = t554 * t68 * t487 * t475
  t562 = 0.36160325443609899452826126199587946209215501652844e0 * t534 * t541 - 0.64566115702479338842975206611570247933884297520658e-1 * t505 * t545 + 0.12007191890218753507800883109367307994500424840451e0 * t552 * t557 - 0.71464856518387697951935367412452311024812903099902e-2 * t513 * t498
  t566 = 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t501 * t519 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t531 * t562
  t572 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t528 * t519
  t573 = 0.1e1 / t572
  t579 = -0.19388333333333333333333333333333333333333333333333e1 * t361 - 0.12315000000000000000000000000000000000000000000000e-2 * t369
  t582 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t333 + 0.11800000000000000000000000000000000000000000000000e3 * t340
  t583 = 0.1e1 / t582
  t587 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t333 + 0.18472500000000000000000000000000000000000000000000e-2 * t340
  t588 = t582 ** 2
  t589 = 0.1e1 / t588
  t590 = t587 * t589
  t593 = -0.72691666666666666666666666666666666666666666666667e3 * t361 - 0.78666666666666666666666666666666666666666666666667e2 * t369
  t595 = t579 * t583 - t590 * t593
  t596 = t595 * t450
  t598 = t266 * t596 * s0
  t606 = jnp.exp(-0.25e2 / 0.9e1 * t289 * t291 * t3 * t295 * t451 * s0)
  t607 = t456 * t606
  t608 = t186 * t122 * t607
  t612 = t587 * t583 - 0.18535714285714285714285714285714285714285714285714e-2
  t613 = t612 * t450
  t615 = t266 * t613 * s0
  t617 = t117 * t122 * t607
  t620 = t612 * t452
  t622 = t314 * t620 * t145
  t625 = t150 * t291 * t606
  t626 = t319 * t6 * t625
  t631 = f.my_piecewise3(t62, f.p.zeta_threshold, 1)
  t634 = t6 * t186
  t637 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t634 * t31
  t641 = 0.35616666666666666666666666666666666666666666666666e-1 * t330 * t9 * t38 * t59
  t645 = t57 ** 2
  t648 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t645 * t58
  t653 = t20 * t5 * t295
  t654 = 0.1e1 / t14 / t13 * t19 * t653
  t656 = t42 * t186
  t657 = t41 * t656
  t659 = t4 * t634
  t661 = t13 ** (-0.5e0)
  t663 = t661 * t19 * t653
  t665 = t49 * t656
  t667 = t5 * t295
  t668 = t21 * t667
  t673 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t654 + 0.84396666666666666666666666666666666666666666666666e0 * t657 + 0.39862222222222222222222222222222222222222222222223e0 * t659 + 0.68258333333333333333333333333333333333333333333333e-1 * t663 + 0.13651666666666666666666666666666666666666666666667e0 * t665 + 0.13692777777777777777777777777777777777777777777778e0 * t668) * t58
  t674 = t37 ** 2
  t677 = t30 ** 2
  t681 = 0.16081824322151104821330931780901225435013347914188e2 * t36 / t674 * t645 / t677
  t685 = 0.24415406715670879921742973310852762593515528885057e-3 * t73 * t42 * t186 * t82
  t689 = 0.10843580882781524214666447553230042011687479519034e-1 * t72 * t4 * t10 * t99
  t692 = t96 ** 2
  t696 = 0.11696446794910408141662685001236899248561775660981e1 * t89 / t90 / t78 * t692 * t98
  t707 = 0.58482233974552040708313425006184496242808878304903e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t654 + 0.11507777777777777777777777777777777777777777777778e1 * t657 + 0.40256666666666666666666666666666666666666666666667e0 * t659 + 0.36677500000000000000000000000000000000000000000000e-1 * t663 + 0.73355000000000000000000000000000000000000000000000e-1 * t665 + 0.13797500000000000000000000000000000000000000000000e0 * t668) * t98
  t708 = t90 ** 2
  t711 = t81 ** 2
  t715 = 0.17315755899375863299672358916972966258900005419821e2 * t89 / t708 * t692 / t711
  t717 = 0.1e1 / t7 / t146
  t718 = s0 * t717
  t722 = t102 * jnp.pi
  t723 = t722 * t238
  t725 = t153 ** 2
  t727 = 0.1e1 / t725 / t110
  t728 = t197 * t727
  t730 = t159 ** 2
  t731 = t485 * t730
  t732 = t140 ** 2
  t738 = t145 * t171
  t743 = -t637 - t641 - t648 + t673 + t681 + t685 + t689 + t696 - t707 - t715
  t749 = t722 * t143
  t752 = t19 * t136
  t758 = 0.1e1 / t22 / t318
  t760 = t758 * t150 * t175
  t768 = t179 * t215
  t774 = t213 / t214 / t201
  t775 = t251 ** 2
  t782 = 0.1e1 / t725 * t122 * t5
  t783 = t730 * t732
  t803 = t717 * t68
  t807 = t142 ** 2
  t812 = t727 * t156 * t6
  t844 = t255 ** 2
  t846 = t261 ** 2
  t847 = 0.1e1 / t846
  t861 = t283 ** 2
  t876 = t285 * t111
  t884 = t146 * t115
  t885 = 0.1e1 / t884
  t891 = 0.1e1 / t722 * t105
  t893 = t891 * t307 * t220
  t894 = t145 * s0
  t895 = t146 ** 2
  t898 = 0.1e1 / t22 / t895 / r0
  t900 = t290 * t3
  t901 = t900 * t301
  t905 = -t637 - t641 - t648 + t673 + t681 + t685 + t689 + t696 - t707 - t715 + 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * (0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * (0.35e2 / 0.432e3 * t718 * t68 * t124 + 0.29533628222694690839730625514972717420553976880296e0 * t723 * t145 * t728 * t731 * t19 * t732 * t136 - 0.10546761587719554007074286808213150977687854648747e0 * t144 * t738 * t150 * t162 + 0.11300101701128093579008164437371233190379844266515e-1 * t152 * t158 * t743 * t1 * t140 - 0.14766814111347345419865312757486358710276988440148e0 * t749 * t145 * t728 * t731 * t752 * t140 + 0.22867165977961432506887052341597796143250688705235e-1 * t168 * t760) * t202 - 0.17709563164108618654073199527744982290436835891381e1 * t206 * t768 * t251 + 0.17709563164108618654073199527744982290436835891381e1 * t206 * t774 * t775 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t216 * (0.28352283093786903206141400494373808723731817805082e2 * t723 * t208 * t782 * t783 * t136 - 0.16874818540351286411318858893141041564300567437994e1 * t112 * t217 * t117 * t226 + 0.36160325443609899452826126199587946209215501652845e0 * t219 * t223 * t5 * t743 * t140 - 0.14176141546893451603070700247186904361865908902541e2 * t749 * t208 * t782 * t730 * t136 * t140 + 0.21522038567493112947658402203856749311294765840220e0 * t184 * t803 * t189 + 0.23536244451380066489749908173089237613782685235180e1 * t102 / t807 * t151 * t812 * t783 * t1 - 0.56033562154354183036404121177047437307668649255439e0 * t236 * t239 * t171 * t246 + 0.60035959451093767539004415546836539972502124202256e-1 * t241 * t243 * t6 * t743 * t140 - 0.78454148171266888299166360576964125379275617450598e0 * t102 * t238 * t151 * t812 * t730 * t1 * t140 + 0.20248376013543181086381687433528154790363655878306e-1 * t196 * t760)) * t262 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * t844 * t847 + t266 * ((0.25851111111111111111111111111111111111111111111111e1 * t659 + 0.20525000000000000000000000000000000000000000000000e-2 * t668) * t273 - 0.2e1 * t269 * t279 * t283 + 0.2e1 * t277 / t278 / t272 * t861 - t280 * (0.96922222222222222222222222222222222222222222222222e3 * t659 + 0.13111111111111111111111111111111111111111111111111e3 * t668)) * t109 * s0 * t303 / 0.2e1 - 0.7e1 / 0.3e1 * t288 * t311 + 0.100e3 / 0.27e2 * t314 * t876 * t145 * t323 + 0.35e2 / 0.9e1 * t310 * t803 * t302 - 0.1250e4 / 0.81e2 * t317 * t885 * t150 * t322 + 0.40000e5 / 0.81e2 * t893 * t894 * t898 * t901
  t909 = 0.14764770444444444444444444444444444444444444444444e-2 * t330 * t187 * t346
  t913 = 0.35616666666666666666666666666666666666666666666666e-1 * t46 * t68 * t353 * t373
  t917 = t371 ** 2
  t920 = 0.20000000000000000000000000000000000000000000000000e1 * t351 / t352 / t342 * t917 * t372
  t925 = t667 * t150
  t926 = 0.1e1 / t334 / t333 * t19 * t20 * t925
  t928 = t634 * t68
  t929 = t357 * t928
  t931 = t4 * t928
  t933 = t333 ** (-0.5e0)
  t936 = t933 * t19 * t20 * t925
  t938 = t365 * t928
  t940 = t21 * t925
  t945 = 0.10000000000000000000000000000000000000000000000000e1 * t354 * (-0.42198333333333333333333333333333333333333333333333e0 * t926 + 0.84396666666666666666666666666666666666666666666666e0 * t929 + 0.39862222222222222222222222222222222222222222222223e0 * t931 + 0.68258333333333333333333333333333333333333333333333e-1 * t936 + 0.13651666666666666666666666666666666666666666666667e0 * t938 + 0.13692777777777777777777777777777777777777777777778e0 * t940) * t372
  t946 = t352 ** 2
  t949 = t345 ** 2
  t953 = 0.16081824322151104821330931780901225435013347914188e2 * t351 / t946 * t917 / t949
  t964 = t404 ** 2
  t978 = t397 ** 2
  t981 = t390 ** 2
  t994 = 0.1e1 / t423 / t413
  t996 = t430 ** 2
  t1006 = -0.57538888888888888888888888888888888888888888888889e0 * t926 + 0.11507777777777777777777777777777777777777777777778e1 * t929 + 0.40256666666666666666666666666666666666666666666667e0 * t931 + 0.36677500000000000000000000000000000000000000000000e-1 * t936 + 0.73355000000000000000000000000000000000000000000000e-1 * t938 + 0.13797500000000000000000000000000000000000000000000e0 * t940
  t1010 = t423 ** 2
  t1011 = 0.1e1 / t1010
  t1013 = t416 ** 2
  t1014 = 0.1e1 / t1013
  t1018 = -0.70981924444444444444444444444444444444444444444442e-3 * t330 * t187 * t391 - 0.34246666666666666666666666666666666666666666666666e-1 * t46 * t68 * t398 * t406 - 0.20000000000000000000000000000000000000000000000000e1 * t396 / t397 / t387 * t964 * t405 + 0.99999999999999999999999999999999999999999999999999e0 * t399 * (-0.78438333333333333333333333333333333333333333333333e0 * t926 + 0.15687666666666666666666666666666666666666666666667e1 * t929 + 0.68863333333333333333333333333333333333333333333333e0 * t931 + 0.14025833333333333333333333333333333333333333333333e0 * t936 + 0.28051666666666666666666666666666666666666666666667e0 * t938 + 0.17365833333333333333333333333333333333333333333333e0 * t940) * t405 + 0.32164683177870697973624959794146027661627532968800e2 * t396 / t978 * t964 / t981 + t909 + t913 + t920 - t945 - t953 - 0.24415406715670879921742973310852762593515528885057e-3 * t330 * t187 * t417 - 0.10843580882781524214666447553230042011687479519034e-1 * t46 * t68 * t424 * t432 - 0.11696446794910408141662685001236899248561775660981e1 * t422 * t994 * t996 * t431 + 0.58482233974552040708313425006184496242808878304903e0 * t425 * t1006 * t431 + 0.17315755899375863299672358916972966258900005419821e2 * t422 * t1011 * t996 * t1014
  t1019 = t382 * t1018
  t1022 = 0.24415406715670879921742973310852762593515528885057e-3 * t437 * t634 * t438
  t1026 = 0.10843580882781524214666447553230042011687479519034e-1 * t382 * t330 * t331 * t444
  t1030 = 0.11696446794910408141662685001236899248561775660981e1 * t442 * t994 * t996 * t431
  t1034 = 0.58482233974552040708313425006184496242808878304903e0 * t442 * t424 * t1006 * t431
  t1038 = 0.17315755899375863299672358916972966258900005419821e2 * t442 * t1011 * t996 * t1014
  t1042 = t722 * t549
  t1044 = t480 ** 2
  t1046 = 0.1e1 / t1044 / t451
  t1048 = t148 * t1046 * t156
  t1050 = t6 * t68
  t1051 = t487 ** 2
  t1052 = t1050 * t1051
  t1053 = t475 ** 2
  t1063 = -t909 - t913 - t920 + t945 + t953 + t1019 + t1022 + t1026 + t1030 - t1034 - t1038
  t1069 = t722 * t478
  t1077 = t758 * t496 * t486
  t1085 = t501 * t530
  t1091 = t528 / t529 / t518
  t1092 = t562 ** 2
  t1097 = t207 / t1044
  t1099 = t1051 * t1053
  t1123 = t477 ** 2
  t1126 = t149 * t1046
  t1159 = t566 ** 2
  t1161 = t572 ** 2
  t1162 = 0.1e1 / t1161
  t1176 = t593 ** 2
  t1191 = t595 * t452
  t1204 = t612 * t535
  t1208 = t900 * t606
  t1212 = -t909 - t913 - t920 + t945 + t953 + t1019 + t1022 + t1026 + t1030 - t1034 - t1038 + 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t452 * (0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * (0.35e2 / 0.432e3 * t718 * t453 * t457 + 0.59067256445389381679461251029945434841107953760586e0 * t1042 * t145 * t1048 * t1052 * t19 * t1053 * t136 - 0.21093523175439108014148573616426301955375709297493e0 * t479 * t738 * t482 * t490 + 0.22600203402256187158016328874742466380759688533028e-1 * t484 * t486 * t1063 * t1 * t475 - 0.29533628222694690839730625514972717420553976880293e0 * t1069 * t145 * t1048 * t1052 * t752 * t475 + 0.45734331955922865013774104683195592286501377410468e-1 * t495 * t1077) * t519 - 0.17709563164108618654073199527744982290436835891381e1 * t206 * t1085 * t562 + 0.17709563164108618654073199527744982290436835891381e1 * t206 * t1091 * t1092 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t531 * (0.28352283093786903206141400494373808723731817805081e2 * t1042 * t1097 * t507 * t1099 * t136 - 0.16874818540351286411318858893141041564300567437994e1 * t112 * t532 * t117 * t541 + 0.36160325443609899452826126199587946209215501652844e0 * t534 * t538 * t150 * t1063 * t475 - 0.14176141546893451603070700247186904361865908902540e2 * t1069 * t1097 * t507 * t1051 * t136 * t475 + 0.21522038567493112947658402203856749311294765840219e0 * t505 * t717 * t453 * t507 + 0.47072488902760132979499816346178475227565370470358e1 * t102 / t1123 * t1126 * t486 * t1099 * t1 - 0.11206712430870836607280824235409487461533729851088e1 * t236 * t550 * t171 * t557 + 0.12007191890218753507800883109367307994500424840451e0 * t552 * t554 * t68 * t1063 * t475 - 0.15690829634253377659833272115392825075855123490119e1 * t102 * t549 * t1126 * t486 * t1051 * t1 * t475 + 0.40496752027086362172763374867056309580727311756611e-1 * t513 * t1077)) * t573 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t452 * t1159 * t1162 + t266 * ((0.25851111111111111111111111111111111111111111111111e1 * t931 + 0.20525000000000000000000000000000000000000000000000e-2 * t940) * t583 - 0.2e1 * t579 * t589 * t593 + 0.2e1 * t587 / t588 / t582 * t1176 - t590 * (0.96922222222222222222222222222222222222222222222222e3 * t931 + 0.13111111111111111111111111111111111111111111111111e3 * t940)) * t450 * s0 * t608 / 0.2e1 - 0.7e1 / 0.3e1 * t598 * t617 + 0.200e3 / 0.27e2 * t314 * t1191 * t145 * t626 + 0.35e2 / 0.9e1 * t615 * t717 * t122 * t607 - 0.2500e4 / 0.81e2 * t622 * t885 * t6 * t625 + 0.80000e5 / 0.81e2 * t891 * t1204 * t894 * t898 * t150 * t1208
  v2rho2_0_ = 0.2e1 * params.c1 * (t34 + t61 - t86 - t101 + 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * t255 * t262 + t288 * t303 / 0.2e1 - 0.7e1 / 0.6e1 * t310 * t311 + 0.50e2 / 0.27e2 * t317 * t323) + 0.2e1 * t329 * (t349 + t375 + t436 - t441 - t446 + 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t452 * t566 * t573 + t598 * t608 / 0.2e1 - 0.7e1 / 0.6e1 * t615 * t617 + 0.100e3 / 0.27e2 * t622 * t626) * t631 + r0 * (t329 * t1212 * t631 + params.c1 * t905)
  t1218 = t455 * t5
  t1222 = t165 * t166 * s0
  t1225 = t187 * t120 * t1218 / 0.96e2 + 0.17294495277449822904368358913813459268004722550178e-2 * t1222 * t198
  t1230 = t181 * t182
  t1234 = t193 * t194 * s0
  t1237 = 0.27671192443919716646989374262101534828807556080283e-1 * t1230 * t190 + 0.15313897825368792418271864445525495219602764949979e-2 * t1234 * t198
  t1241 = 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t1225 * t202 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t216 * t1237
  t1242 = t111 * t1241
  t1246 = t266 * t308
  t1251 = 0.1e1 / t169
  t1253 = t1251 * t150 * t322
  t1262 = t165 * t493 * s0
  t1265 = t506 * t19 * t507 / 0.96e2 + 0.34588990554899645808736717827626918536009445100354e-2 * t1262 * t515
  t1270 = t181 * t503
  t1274 = t193 * t511 * s0
  t1277 = 0.27671192443919716646989374262101534828807556080282e-1 * t1270 * t508 + 0.30627795650737584836543728891050990439205529899958e-2 * t1274 * t515
  t1281 = 0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * t1265 * t519 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t531 * t1277
  t1282 = t452 * t1281
  t1286 = t266 * t613
  t1292 = t1251 * t6 * t625
  t1301 = s0 * t148
  t1313 = t1225 * t215
  t1360 = t150 * t6
  t1361 = t291 * s0
  t1371 = 0.1e1 / t22 / t895
  t1392 = t1265 * t530
  v2rhosigma_0_ = params.c1 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t1242 * t262 + t1246 * t303 / 0.2e1 - 0.25e2 / 0.36e2 * t314 * t315 * s0 * t1253) + t329 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t1282 * t573 + t1286 * t608 / 0.2e1 - 0.25e2 / 0.18e2 * t314 * t620 * s0 * t1292) * t631 + r0 * (params.c1 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * (0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * (-0.7e1 / 0.288e3 * t229 * t120 * t1218 + 0.22600203402256187158016328874742466380759688533030e-1 * t144 * t1301 * t150 * t162 - 0.80707644628099173553719008264462809917355371900831e-2 * t1222 * t176) * t202 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t1313 * t251 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t768 * t1237 + 0.17709563164108618654073199527744982290436835891381e1 * t206 * t774 * t1237 * t251 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t216 * (0.36160325443609899452826126199587946209215501652845e0 * t112 * t143 * t186 * t68 * t221 * t122 * t225 - 0.64566115702479338842975206611570247933884297520660e-1 * t1230 * t230 + 0.12007191890218753507800883109367307994500424840451e0 * t236 * t238 * s0 * t148 * t246 - 0.71464856518387697951935367412452311024812903099902e-2 * t1234 * t176)) * t262 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t1242 * t847 * t255 + t266 * t286 * t303 / 0.2e1 - 0.7e1 / 0.6e1 * t1246 * t311 + 0.575e3 / 0.108e3 * t314 * t315 * t319 * t1360 * t1361 * t301 - 0.25e2 / 0.36e2 * t314 * t876 * s0 * t1253 - 0.5000e4 / 0.27e2 * t893 * t145 * t1371 * t901) + t329 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t452 * (0.88547815820543093270365997638724911452184179456906e0 * t112 * t113 * (-0.7e1 / 0.288e3 * t544 * t19 * t507 + 0.45200406804512374316032657749484932761519377066057e-1 * t479 * t1301 * t482 * t490 - 0.16141528925619834710743801652892561983471074380165e-1 * t1262 * t498) * t519 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t1392 * t562 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t1085 * t1277 + 0.17709563164108618654073199527744982290436835891381e1 * t206 * t1091 * t1277 * t562 - 0.88547815820543093270365997638724911452184179456906e0 * t206 * t531 * (0.36160325443609899452826126199587946209215501652844e0 * t112 * t478 * t186 * t536 * t123 * t540 - 0.64566115702479338842975206611570247933884297520658e-1 * t1270 * t545 + 0.24014383780437507015601766218734615989000849680903e0 * t236 * t549 * s0 * t148 * t557 - 0.14292971303677539590387073482490462204962580619980e-1 * t1274 * t498)) * t573 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t1282 * t1162 * t566 + t266 * t596 * t608 / 0.2e1 - 0.7e1 / 0.6e1 * t1286 * t617 + 0.575e3 / 0.54e2 * t314 * t620 * t319 * t1360 * t1361 * t606 - 0.25e2 / 0.18e2 * t314 * t1191 * s0 * t1292 - 0.10000e5 / 0.27e2 * t891 * t1204 * t145 * t1371 * t150 * t1208) * t631)
  t1468 = t1237 ** 2
  t1481 = t1241 ** 2
  t1490 = 0.1e1 / t22 / t884
  t1508 = t1277 ** 2
  t1521 = t1281 ** 2
  v2sigma2_0_ = r0 * (params.c1 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * (0.15313897825368792418271864445525495219602764949980e-2 * t193 * t136 * t166 * t148 * t150 * t173 * t485 * t202 - 0.17709563164108618654073199527744982290436835891381e1 * t206 * t1313 * t1237 + 0.17709563164108618654073199527744982290436835891381e1 * t206 * t774 * t1468 - 0.40680366124061136884429391974536439485367439359448e-2 * t181 * t216 * t143 * t198) * t262 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t111 * t1481 * t847 - 0.25e2 / 0.18e2 * t314 * t315 * t1253 + 0.625e3 / 0.9e1 * t893 * s0 * t1490 * t901) + t329 * (0.25507875555555555555555555555555555555555555555556e-1 * t107 * t452 * (0.30627795650737584836543728891050990439205529899959e-2 * t193 * t136 * t493 * t148 * t496 * t156 * t1050 * t519 - 0.17709563164108618654073199527744982290436835891381e1 * t206 * t1392 * t1277 + 0.17709563164108618654073199527744982290436835891381e1 * t206 * t1091 * t1508 - 0.81360732248122273768858783949072878970734878718896e-2 * t181 * t531 * t478 * t515) * t573 - 0.25507875555555555555555555555555555555555555555556e-1 * t107 * t452 * t1521 * t1162 - 0.25e2 / 0.9e1 * t314 * t620 * t1292 + 0.1250e4 / 0.9e1 * t891 * t1204 * s0 * t1490 * t150 * t1208) * t631)

  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t13 = t6 / t8
  t14 = t4 * t13
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t25 = t5 / t23
  t26 = t22 * t25
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t28
  t32 = jnp.log(t31)
  t35 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t11 * t32
  t36 = t4 * t6
  t38 = 0.1e1 / t8 / r0
  t39 = t28 ** 2
  t40 = 0.1e1 / t39
  t41 = t38 * t40
  t43 = 0.1e1 / t15 * t1
  t44 = t3 * t6
  t45 = t44 * t38
  t46 = t43 * t45
  t48 = t6 * t38
  t49 = t4 * t48
  t51 = t14 ** 0.5e0
  t52 = t51 * t1
  t53 = t52 * t45
  t57 = t5 / t23 / r0
  t58 = t22 * t57
  t60 = -0.63297500000000000000000000000000000000000000000000e0 * t46 - 0.29896666666666666666666666666666666666666666666667e0 * t49 - 0.10238750000000000000000000000000000000000000000000e0 * t53 - 0.82156666666666666666666666666666666666666666666667e-1 * t58
  t61 = 0.1e1 / t31
  t62 = t60 * t61
  t65 = 0.35616666666666666666666666666666666666666666666666e-1 * t36 * t41 * t62
  t67 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t69 = 0.1e1 / t39 / t28
  t70 = t67 * t69
  t71 = t60 ** 2
  t72 = t71 * t61
  t74 = 0.20000000000000000000000000000000000000000000000000e1 * t70 * t72
  t75 = t67 * t40
  t78 = 0.1e1 / t15 / t14 * t20
  t79 = t21 * t5
  t81 = 0.1e1 / t23 / t7
  t82 = t79 * t81
  t83 = t78 * t82
  t85 = t44 * t10
  t86 = t43 * t85
  t88 = t4 * t11
  t90 = t14 ** (-0.5e0)
  t91 = t90 * t20
  t92 = t91 * t82
  t94 = t52 * t85
  t96 = t5 * t81
  t97 = t22 * t96
  t99 = -0.42198333333333333333333333333333333333333333333333e0 * t83 + 0.84396666666666666666666666666666666666666666666666e0 * t86 + 0.39862222222222222222222222222222222222222222222223e0 * t88 + 0.68258333333333333333333333333333333333333333333333e-1 * t92 + 0.13651666666666666666666666666666666666666666666667e0 * t94 + 0.13692777777777777777777777777777777777777777777778e0 * t97
  t100 = t99 * t61
  t102 = 0.10000000000000000000000000000000000000000000000000e1 * t75 * t100
  t103 = t39 ** 2
  t104 = 0.1e1 / t103
  t105 = t67 * t104
  t106 = t31 ** 2
  t107 = 0.1e1 / t106
  t108 = t71 * t107
  t110 = 0.16081824322151104821330931780901225435013347914188e2 * t105 * t108
  t111 = 0.1e1 <= f.p.zeta_threshold
  t112 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t113 = t112 * f.p.zeta_threshold
  t114 = f.my_piecewise3(t111, t113, 1)
  t117 = 2 ** (0.1e1 / 0.3e1)
  t120 = 0.1e1 / (0.2e1 * t117 - 0.2e1)
  t121 = (0.2e1 * t114 - 0.2e1) * t120
  t122 = t121 * t1
  t127 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t130 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t127
  t131 = jnp.log(t130)
  t135 = 0.24415406715670879921742973310852762593515528885057e-3 * t122 * t44 * t10 * t131
  t136 = t121 * t4
  t137 = t127 ** 2
  t138 = 0.1e1 / t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t46 - 0.30192500000000000000000000000000000000000000000000e0 * t49 - 0.55016250000000000000000000000000000000000000000000e-1 * t53 - 0.82785000000000000000000000000000000000000000000000e-1 * t58
  t145 = 0.1e1 / t130
  t146 = t138 * t143 * t145
  t149 = 0.10843580882781524214666447553230042011687479519034e-1 * t136 * t48 * t146
  t151 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t152 = t121 * t151
  t154 = 0.1e1 / t137 / t127
  t155 = t143 ** 2
  t157 = t154 * t155 * t145
  t159 = 0.11696446794910408141662685001236899248561775660981e1 * t152 * t157
  t166 = -0.57538888888888888888888888888888888888888888888889e0 * t83 + 0.11507777777777777777777777777777777777777777777778e1 * t86 + 0.40256666666666666666666666666666666666666666666667e0 * t88 + 0.36677500000000000000000000000000000000000000000000e-1 * t92 + 0.73355000000000000000000000000000000000000000000000e-1 * t94 + 0.13797500000000000000000000000000000000000000000000e0 * t97
  t168 = t138 * t166 * t145
  t170 = 0.58482233974552040708313425006184496242808878304903e0 * t152 * t168
  t171 = t137 ** 2
  t172 = 0.1e1 / t171
  t174 = t130 ** 2
  t175 = 0.1e1 / t174
  t176 = t172 * t155 * t175
  t178 = 0.17315755899375863299672358916972966258900005419821e2 * t152 * t176
  t179 = jnp.pi ** 2
  t180 = 0.1e1 / t179
  t182 = t179 ** (0.1e1 / 0.3e1)
  t183 = t182 ** 2
  t184 = t180 * t20 * t183
  t185 = t112 ** 2
  t186 = f.my_piecewise3(t111, t185, 1)
  t187 = t186 ** 2
  t188 = t187 * t186
  t189 = jnp.pi * t20
  t190 = 0.1e1 / t182
  t191 = t7 ** 2
  t193 = 0.1e1 / t8 / t191
  t194 = s0 * t193
  t196 = 0.1e1 / t187
  t198 = 0.1e1 / t3
  t199 = t198 * t5
  t200 = t196 * t20 * t199
  t203 = t179 * jnp.pi
  t213 = 0.1e1 / t183
  t214 = t179 * t1 * t213
  t217 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * (-0.62182e-1 * t67 * t32 + 0.19751789702565206228825776161588751761046270558698e-1 * t121 * t151 * t131) / t188 * t214)
  t218 = t217 - 0.1e1
  t219 = t218 ** 2
  t221 = 0.1e1 / t219 / t218
  t222 = t203 * t221
  t223 = s0 ** 2
  t224 = t222 * t223
  t226 = 0.1e1 / t23 / t191
  t227 = t117 ** 2
  t228 = t226 * t227
  t229 = t187 ** 2
  t230 = t229 ** 2
  t232 = 0.1e1 / t230 / t187
  t233 = t228 * t232
  t234 = t224 * t233
  t235 = 0.1e1 / t21
  t236 = t235 * t6
  t248 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t48 * t32 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t62 - 0.18311555036753159941307229983139571945136646663793e-3 * t122 * t44 * t38 * t131 - 0.58482233974552040708313425006184496242808878304903e0 * t152 * t146
  t249 = t248 ** 2
  t250 = t236 * t249
  t251 = t217 ** 2
  t252 = t20 * t251
  t253 = t252 * t213
  t254 = t250 * t253
  t257 = 0.1e1 / t219
  t258 = jnp.pi * t257
  t259 = t191 * r0
  t261 = 0.1e1 / t23 / t259
  t262 = t223 * t261
  t263 = t262 * t227
  t264 = t258 * t263
  t265 = t229 * t188
  t266 = 0.1e1 / t265
  t268 = t266 * t235 * t6
  t270 = t248 * t1 * t217
  t271 = t268 * t270
  t274 = t223 * t226
  t275 = t274 * t227
  t276 = t258 * t275
  t277 = -t35 - t65 - t74 + t102 + t110 + t135 + t149 + t159 - t170 - t178
  t280 = t268 * t277 * t1 * t217
  t283 = t203 * t257
  t284 = t283 * t223
  t285 = t284 * t233
  t286 = t20 * t213
  t287 = t286 * t217
  t288 = t250 * t287
  t291 = jnp.pi * t190
  t292 = 0.1e1 / t218
  t294 = t291 * t292 * t223
  t295 = t191 * t7
  t297 = 0.1e1 / t23 / t295
  t301 = 0.1e1 / t229 * t235 * t6
  t302 = t297 * t227 * t301
  t305 = 0.35e2 / 0.432e3 * t194 * t117 * t200 + 0.29533628222694690839730625514972717420553976880296e0 * t234 * t254 - 0.10546761587719554007074286808213150977687854648747e0 * t264 * t271 + 0.11300101701128093579008164437371233190379844266515e-1 * t276 * t280 - 0.14766814111347345419865312757486358710276988440148e0 * t285 * t288 + 0.22867165977961432506887052341597796143250688705235e-1 * t294 * t302
  t307 = jnp.pi * t1
  t310 = t307 * t190 * t292 * s0
  t311 = t10 * t117
  t313 = t196 * t198 * t5
  t317 = t179 * t20
  t320 = t317 * t213 * t257 * t223
  t321 = t228 * t301
  t324 = 0.1e1 + 0.27671192443919716646989374262101534828807556080283e-1 * t310 * t311 * t313 + 0.76569489126843962091359322227627476098013824749894e-3 * t320 * t321
  t325 = 0.1e1 / t324
  t329 = t189 * t190
  t330 = t7 * r0
  t332 = 0.1e1 / t8 / t330
  t333 = s0 * t332
  t334 = t333 * t117
  t339 = t261 * t227
  t340 = t339 * t301
  t343 = -0.7e1 / 0.288e3 * t334 * t200 + 0.11300101701128093579008164437371233190379844266515e-1 * t276 * t271 - 0.40353822314049586776859504132231404958677685950414e-2 * t294 * t340
  t344 = t324 ** 2
  t345 = 0.1e1 / t344
  t346 = t343 * t345
  t347 = t257 * s0
  t349 = t189 * t347 * t10
  t350 = t229 * t186
  t353 = t117 / t350 * t198
  t356 = t353 * t5 * t248 * t217
  t359 = t332 * t117
  t363 = t179 ** 2
  t365 = 0.1e1 / t182 / t179
  t366 = t363 * t365
  t367 = t221 * t223
  t369 = t366 * t367 * t226
  t371 = t227 * t266 * t235
  t374 = t371 * t6 * t248 * t217
  t379 = 0.36160325443609899452826126199587946209215501652845e0 * t349 * t356 - 0.64566115702479338842975206611570247933884297520660e-1 * t310 * t359 * t313 + 0.60035959451093767539004415546836539972502124202256e-1 * t369 * t374 - 0.35732428259193848975967683706226155512406451549951e-2 * t320 * t340
  t383 = s0 * t10
  t384 = t383 * t117
  t389 = t384 * t200 / 0.96e2 + 0.86472476387249114521841794569067296340023612750888e-3 * t294 * t321
  t391 = 0.1e1 / t344 / t324
  t392 = t389 * t391
  t393 = t379 ** 2
  t397 = t389 * t345
  t399 = 0.1e1 / t230
  t401 = t399 * t198 * t5
  t402 = t249 * t251
  t404 = t401 * t402 * t213
  t408 = t189 * t347 * t332
  t413 = t353 * t5 * t277 * t217
  t419 = t401 * t249 * t213 * t217
  t422 = t193 * t117
  t426 = t219 ** 2
  t427 = 0.1e1 / t426
  t428 = t179 * t427
  t431 = t232 * t235 * t6
  t433 = t431 * t402 * t1
  t437 = t366 * t367 * t261
  t442 = t371 * t6 * t277 * t217
  t445 = t179 * t221
  t449 = t431 * t249 * t1 * t217
  t454 = 0.28352283093786903206141400494373808723731817805082e2 * t222 * t384 * t404 - 0.16874818540351286411318858893141041564300567437994e1 * t408 * t356 + 0.36160325443609899452826126199587946209215501652845e0 * t349 * t413 - 0.14176141546893451603070700247186904361865908902541e2 * t283 * t384 * t419 + 0.21522038567493112947658402203856749311294765840220e0 * t310 * t422 * t313 + 0.23536244451380066489749908173089237613782685235180e1 * t428 * t275 * t433 - 0.56033562154354183036404121177047437307668649255439e0 * t437 * t374 + 0.60035959451093767539004415546836539972502124202256e-1 * t369 * t442 - 0.78454148171266888299166360576964125379275617450598e0 * t445 * t275 * t449 + 0.20248376013543181086381687433528154790363655878306e-1 * t320 * t302
  t459 = t188 * (0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t305 * t325 - 0.17709563164108618654073199527744982290436835891381e1 * t329 * t346 * t379 + 0.17709563164108618654073199527744982290436835891381e1 * t329 * t392 * t393 - 0.88547815820543093270365997638724911452184179456906e0 * t329 * t397 * t454)
  t464 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t389 * t325
  t465 = 0.1e1 / t464
  t476 = 0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t343 * t325 - 0.88547815820543093270365997638724911452184179456906e0 * t329 * t397 * t379
  t477 = t476 ** 2
  t479 = t464 ** 2
  t480 = 0.1e1 / t479
  t484 = t2 * t182
  t487 = 0.25851111111111111111111111111111111111111111111111e1 * t88 + 0.20525000000000000000000000000000000000000000000000e-2 * t97
  t490 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t14 + 0.11800000000000000000000000000000000000000000000000e3 * t26
  t491 = 0.1e1 / t490
  t495 = -0.19388333333333333333333333333333333333333333333333e1 * t49 - 0.12315000000000000000000000000000000000000000000000e-2 * t58
  t496 = t490 ** 2
  t497 = 0.1e1 / t496
  t498 = t495 * t497
  t501 = -0.72691666666666666666666666666666666666666666666667e3 * t49 - 0.78666666666666666666666666666666666666666666666667e2 * t58
  t506 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t14 + 0.18472500000000000000000000000000000000000000000000e-2 * t26
  t508 = 0.1e1 / t496 / t490
  t509 = t506 * t508
  t510 = t501 ** 2
  t513 = t506 * t497
  t516 = 0.96922222222222222222222222222222222222222222222222e3 * t88 + 0.13111111111111111111111111111111111111111111111111e3 * t97
  t518 = t487 * t491 - 0.2e1 * t498 * t501 + 0.2e1 * t509 * t510 - t513 * t516
  t521 = t484 * t518 * t186 * s0
  t522 = t2 * t5
  t523 = 9 ** (0.1e1 / 0.3e1)
  t524 = t523 ** 2
  t532 = jnp.exp(-0.25e2 / 0.18e2 * t522 * t524 * t3 * t81 * t187 * s0 * t117)
  t533 = t199 * t532
  t534 = t311 * t533
  t539 = t495 * t491 - t513 * t501
  t542 = t484 * t539 * t186 * s0
  t543 = t359 * t533
  t546 = t180 * t182
  t549 = t546 * t539 * t188 * t223
  t550 = 0.1e1 / t295
  t553 = t6 * t524 * t532
  t554 = t550 * t227 * t553
  t558 = t506 * t491 - 0.18535714285714285714285714285714285714285714285714e-2
  t561 = t484 * t558 * t186 * s0
  t562 = t422 * t533
  t567 = t546 * t558 * t188 * t223
  t568 = t191 * t330
  t569 = 0.1e1 / t568
  t571 = t569 * t227 * t553
  t575 = 0.1e1 / t203 * t182
  t577 = t575 * t558 * t350
  t578 = t223 * s0
  t579 = t191 ** 2
  t582 = 0.1e1 / t23 / t579 / r0
  t584 = t523 * t3
  t585 = t584 * t532
  t586 = t578 * t582 * t585
  t589 = -t35 - t65 - t74 + t102 + t110 + t135 + t149 + t159 - t170 - t178 + 0.25507875555555555555555555555555555555555555555556e-1 * t184 * t459 * t465 - 0.25507875555555555555555555555555555555555555555556e-1 * t184 * t188 * t477 * t480 + t521 * t534 / 0.2e1 - 0.7e1 / 0.3e1 * t542 * t543 + 0.100e3 / 0.27e2 * t549 * t554 + 0.35e2 / 0.9e1 * t561 * t562 - 0.1250e4 / 0.81e2 * t567 * t571 + 0.40000e5 / 0.81e2 * t577 * t586
  t592 = params.c2 - params.c1
  t594 = t4 * t13 * t117
  t595 = jnp.sqrt(t594)
  t598 = t594 ** 0.15e1
  t601 = t22 * t25 * t227
  t603 = 0.37978500000000000000000000000000000000000000000000e1 * t595 + 0.89690000000000000000000000000000000000000000000000e0 * t594 + 0.20477500000000000000000000000000000000000000000000e0 * t598 + 0.12323500000000000000000000000000000000000000000000e0 * t601
  t606 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t603
  t607 = jnp.log(t606)
  t610 = 0.14764770444444444444444444444444444444444444444444e-2 * t36 * t311 * t607
  t611 = t603 ** 2
  t612 = 0.1e1 / t611
  t613 = t117 * t612
  t616 = 0.1e1 / t595 * t1 * t3
  t617 = t48 * t117
  t618 = t616 * t617
  t620 = t4 * t617
  t622 = t594 ** 0.5e0
  t624 = t622 * t1 * t3
  t625 = t624 * t617
  t628 = t22 * t57 * t227
  t630 = -0.63297500000000000000000000000000000000000000000000e0 * t618 - 0.29896666666666666666666666666666666666666666666667e0 * t620 - 0.10238750000000000000000000000000000000000000000000e0 * t625 - 0.82156666666666666666666666666666666666666666666667e-1 * t628
  t631 = 0.1e1 / t606
  t632 = t630 * t631
  t633 = t613 * t632
  t635 = 0.35616666666666666666666666666666666666666666666666e-1 * t49 * t633
  t637 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t594
  t639 = 0.1e1 / t611 / t603
  t640 = t637 * t639
  t641 = t630 ** 2
  t642 = t641 * t631
  t644 = 0.20000000000000000000000000000000000000000000000000e1 * t640 * t642
  t645 = t637 * t612
  t649 = 0.1e1 / t595 / t594 * t20 * t21
  t650 = t96 * t227
  t651 = t649 * t650
  t653 = t11 * t117
  t654 = t616 * t653
  t656 = t4 * t653
  t658 = t594 ** (-0.5e0)
  t660 = t658 * t20 * t21
  t661 = t660 * t650
  t663 = t624 * t653
  t665 = t22 * t650
  t667 = -0.42198333333333333333333333333333333333333333333333e0 * t651 + 0.84396666666666666666666666666666666666666666666666e0 * t654 + 0.39862222222222222222222222222222222222222222222223e0 * t656 + 0.68258333333333333333333333333333333333333333333333e-1 * t661 + 0.13651666666666666666666666666666666666666666666667e0 * t663 + 0.13692777777777777777777777777777777777777777777778e0 * t665
  t668 = t667 * t631
  t670 = 0.10000000000000000000000000000000000000000000000000e1 * t645 * t668
  t671 = t611 ** 2
  t672 = 0.1e1 / t671
  t673 = t637 * t672
  t674 = t606 ** 2
  t675 = 0.1e1 / t674
  t676 = t641 * t675
  t678 = 0.16081824322151104821330931780901225435013347914188e2 * t673 * t676
  t679 = 0.2e1 <= f.p.zeta_threshold
  t681 = f.my_piecewise3(t679, t113, 0.2e1 * t117)
  t682 = 0.0e0 <= f.p.zeta_threshold
  t683 = f.my_piecewise3(t682, t113, 0)
  t685 = (t681 + t683 - 0.2e1) * t120
  t690 = 0.70594500000000000000000000000000000000000000000000e1 * t595 + 0.15494250000000000000000000000000000000000000000000e1 * t594 + 0.42077500000000000000000000000000000000000000000000e0 * t598 + 0.15629250000000000000000000000000000000000000000000e0 * t601
  t693 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t690
  t694 = jnp.log(t693)
  t698 = t690 ** 2
  t699 = 0.1e1 / t698
  t700 = t117 * t699
  t705 = -0.11765750000000000000000000000000000000000000000000e1 * t618 - 0.51647500000000000000000000000000000000000000000000e0 * t620 - 0.21038750000000000000000000000000000000000000000000e0 * t625 - 0.10419500000000000000000000000000000000000000000000e0 * t628
  t706 = 0.1e1 / t693
  t707 = t705 * t706
  t708 = t700 * t707
  t712 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t594
  t714 = 0.1e1 / t698 / t690
  t715 = t712 * t714
  t716 = t705 ** 2
  t717 = t716 * t706
  t720 = t712 * t699
  t727 = -0.78438333333333333333333333333333333333333333333333e0 * t651 + 0.15687666666666666666666666666666666666666666666667e1 * t654 + 0.68863333333333333333333333333333333333333333333333e0 * t656 + 0.14025833333333333333333333333333333333333333333333e0 * t661 + 0.28051666666666666666666666666666666666666666666667e0 * t663 + 0.17365833333333333333333333333333333333333333333333e0 * t665
  t728 = t727 * t706
  t731 = t698 ** 2
  t732 = 0.1e1 / t731
  t733 = t712 * t732
  t734 = t693 ** 2
  t735 = 0.1e1 / t734
  t736 = t716 * t735
  t743 = 0.51785000000000000000000000000000000000000000000000e1 * t595 + 0.90577500000000000000000000000000000000000000000000e0 * t594 + 0.11003250000000000000000000000000000000000000000000e0 * t598 + 0.12417750000000000000000000000000000000000000000000e0 * t601
  t746 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t743
  t747 = jnp.log(t746)
  t751 = t743 ** 2
  t752 = 0.1e1 / t751
  t753 = t117 * t752
  t758 = -0.86308333333333333333333333333333333333333333333334e0 * t618 - 0.30192500000000000000000000000000000000000000000000e0 * t620 - 0.55016250000000000000000000000000000000000000000000e-1 * t625 - 0.82785000000000000000000000000000000000000000000000e-1 * t628
  t759 = 0.1e1 / t746
  t760 = t758 * t759
  t761 = t753 * t760
  t765 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t594
  t767 = 0.1e1 / t751 / t743
  t768 = t765 * t767
  t769 = t758 ** 2
  t770 = t769 * t759
  t773 = t765 * t752
  t780 = -0.57538888888888888888888888888888888888888888888889e0 * t651 + 0.11507777777777777777777777777777777777777777777778e1 * t654 + 0.40256666666666666666666666666666666666666666666667e0 * t656 + 0.36677500000000000000000000000000000000000000000000e-1 * t661 + 0.73355000000000000000000000000000000000000000000000e-1 * t663 + 0.13797500000000000000000000000000000000000000000000e0 * t665
  t781 = t780 * t759
  t784 = t751 ** 2
  t785 = 0.1e1 / t784
  t786 = t765 * t785
  t787 = t746 ** 2
  t788 = 0.1e1 / t787
  t789 = t769 * t788
  t792 = -0.70981924444444444444444444444444444444444444444442e-3 * t36 * t311 * t694 - 0.34246666666666666666666666666666666666666666666666e-1 * t49 * t708 - 0.20000000000000000000000000000000000000000000000000e1 * t715 * t717 + 0.99999999999999999999999999999999999999999999999999e0 * t720 * t728 + 0.32164683177870697973624959794146027661627532968800e2 * t733 * t736 + t610 + t635 + t644 - t670 - t678 - 0.24415406715670879921742973310852762593515528885057e-3 * t36 * t311 * t747 - 0.10843580882781524214666447553230042011687479519034e-1 * t49 * t761 - 0.11696446794910408141662685001236899248561775660981e1 * t768 * t770 + 0.58482233974552040708313425006184496242808878304903e0 * t773 * t781 + 0.17315755899375863299672358916972966258900005419821e2 * t786 * t789
  t793 = t685 * t792
  t794 = t685 * t4
  t795 = t117 * t747
  t798 = 0.24415406715670879921742973310852762593515528885057e-3 * t794 * t11 * t795
  t799 = t685 * t36
  t800 = t38 * t117
  t802 = t752 * t758 * t759
  t805 = 0.10843580882781524214666447553230042011687479519034e-1 * t799 * t800 * t802
  t806 = t685 * t765
  t808 = t767 * t769 * t759
  t810 = 0.11696446794910408141662685001236899248561775660981e1 * t806 * t808
  t812 = t752 * t780 * t759
  t814 = 0.58482233974552040708313425006184496242808878304903e0 * t806 * t812
  t816 = t785 * t769 * t788
  t818 = 0.17315755899375863299672358916972966258900005419821e2 * t806 * t816
  t819 = f.my_piecewise3(t679, t185, t227)
  t820 = f.my_piecewise3(t682, t185, 0)
  t822 = t819 / 0.2e1 + t820 / 0.2e1
  t823 = t822 ** 2
  t824 = t823 * t822
  t825 = 0.1e1 / t823
  t828 = t5 * t227
  t829 = t20 * t198 * t828
  t833 = 0.62182e-1 * t637 * t607
  t836 = t765 * t747
  t847 = jnp.exp(-0.13067859477648036196925324326848422587394359423983e2 * (-t833 + t685 * (-0.31090e-1 * t712 * t694 + t833 - 0.19751789702565206228825776161588751761046270558698e-1 * t836) + 0.19751789702565206228825776161588751761046270558698e-1 * t685 * t836) / t824 * t214)
  t848 = t847 - 0.1e1
  t849 = t848 ** 2
  t851 = 0.1e1 / t849 / t848
  t852 = t203 * t851
  t853 = t852 * t223
  t854 = t823 ** 2
  t855 = t854 ** 2
  t857 = 0.1e1 / t855 / t823
  t859 = t226 * t857 * t235
  t860 = t853 * t859
  t861 = t6 * t117
  t864 = 0.11073577833333333333333333333333333333333333333333e-2 * t36 * t800 * t607
  t866 = 0.10000000000000000000000000000000000000000000000000e1 * t645 * t632
  t884 = t864 + t866 + t685 * (0.53236443333333333333333333333333333333333333333332e-3 * t36 * t800 * t694 + 0.99999999999999999999999999999999999999999999999999e0 * t720 * t707 - t864 - t866 + 0.18311555036753159941307229983139571945136646663793e-3 * t36 * t800 * t747 + 0.58482233974552040708313425006184496242808878304903e0 * t773 * t760) - 0.18311555036753159941307229983139571945136646663793e-3 * t794 * t48 * t795 - 0.58482233974552040708313425006184496242808878304903e0 * t806 * t802
  t885 = t884 ** 2
  t886 = t861 * t885
  t887 = t847 ** 2
  t888 = t20 * t887
  t889 = t888 * t213
  t890 = t886 * t889
  t893 = 0.1e1 / t849
  t894 = jnp.pi * t893
  t895 = t854 * t824
  t896 = 0.1e1 / t895
  t898 = t894 * t262 * t896
  t899 = t236 * t117
  t901 = t884 * t1 * t847
  t902 = t899 * t901
  t906 = t894 * t274 * t896
  t907 = -t610 - t635 - t644 + t670 + t678 + t793 + t798 + t805 + t810 - t814 - t818
  t910 = t899 * t907 * t1 * t847
  t913 = t203 * t893
  t914 = t913 * t223
  t915 = t914 * t859
  t916 = t286 * t847
  t917 = t886 * t916
  t920 = 0.1e1 / t848
  t922 = t291 * t920 * t223
  t923 = 0.1e1 / t854
  t925 = t297 * t923 * t899
  t928 = 0.35e2 / 0.432e3 * t194 * t825 * t829 + 0.59067256445389381679461251029945434841107953760586e0 * t860 * t890 - 0.21093523175439108014148573616426301955375709297493e0 * t898 * t902 + 0.22600203402256187158016328874742466380759688533028e-1 * t906 * t910 - 0.29533628222694690839730625514972717420553976880293e0 * t915 * t917 + 0.45734331955922865013774104683195592286501377410468e-1 * t922 * t925
  t932 = t307 * t190 * t920 * s0
  t934 = t199 * t227
  t940 = t317 * t213 * t893 * t223
  t942 = t226 * t923 * t899
  t945 = 0.1e1 + 0.27671192443919716646989374262101534828807556080282e-1 * t932 * t10 * t825 * t934 + 0.15313897825368792418271864445525495219602764949979e-2 * t940 * t942
  t946 = 0.1e1 / t945
  t956 = t261 * t923 * t899
  t959 = -0.7e1 / 0.288e3 * t333 * t825 * t829 + 0.22600203402256187158016328874742466380759688533028e-1 * t906 * t902 - 0.80707644628099173553719008264462809917355371900826e-2 * t922 * t956
  t960 = t945 ** 2
  t961 = 0.1e1 / t960
  t962 = t959 * t961
  t963 = t893 * s0
  t965 = t189 * t963 * t10
  t966 = t854 * t822
  t969 = 0.1e1 / t966 * t198 * t5
  t972 = t969 * t227 * t884 * t847
  t979 = t851 * t223
  t981 = t366 * t979 * t226
  t983 = t896 * t235 * t6
  t986 = t983 * t117 * t884 * t847
  t991 = 0.36160325443609899452826126199587946209215501652844e0 * t965 * t972 - 0.64566115702479338842975206611570247933884297520658e-1 * t932 * t332 * t825 * t934 + 0.12007191890218753507800883109367307994500424840451e0 * t981 * t986 - 0.71464856518387697951935367412452311024812903099902e-2 * t940 * t956
  t1000 = t383 * t825 * t829 / 0.96e2 + 0.17294495277449822904368358913813459268004722550177e-2 * t922 * t942
  t1002 = 0.1e1 / t960 / t945
  t1003 = t1000 * t1002
  t1004 = t991 ** 2
  t1008 = t1000 * t961
  t1009 = 0.1e1 / t855
  t1010 = t383 * t1009
  t1012 = t885 * t887
  t1014 = t934 * t1012 * t213
  t1018 = t189 * t963 * t332
  t1023 = t969 * t227 * t907 * t847
  t1029 = t934 * t885 * t213 * t847
  t1036 = t849 ** 2
  t1037 = 0.1e1 / t1036
  t1038 = t179 * t1037
  t1039 = t274 * t857
  t1042 = t899 * t1012 * t1
  t1046 = t366 * t979 * t261
  t1051 = t983 * t117 * t907 * t847
  t1054 = t179 * t851
  t1058 = t899 * t885 * t1 * t847
  t1063 = 0.28352283093786903206141400494373808723731817805081e2 * t852 * t1010 * t1014 - 0.16874818540351286411318858893141041564300567437994e1 * t1018 * t972 + 0.36160325443609899452826126199587946209215501652844e0 * t965 * t1023 - 0.14176141546893451603070700247186904361865908902540e2 * t913 * t1010 * t1029 + 0.21522038567493112947658402203856749311294765840219e0 * t932 * t193 * t825 * t934 + 0.47072488902760132979499816346178475227565370470358e1 * t1038 * t1039 * t1042 - 0.11206712430870836607280824235409487461533729851088e1 * t1046 * t986 + 0.12007191890218753507800883109367307994500424840451e0 * t981 * t1051 - 0.15690829634253377659833272115392825075855123490119e1 * t1054 * t1039 * t1058 + 0.40496752027086362172763374867056309580727311756611e-1 * t940 * t925
  t1068 = t824 * (0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t928 * t946 - 0.17709563164108618654073199527744982290436835891381e1 * t329 * t962 * t991 + 0.17709563164108618654073199527744982290436835891381e1 * t329 * t1003 * t1004 - 0.88547815820543093270365997638724911452184179456906e0 * t329 * t1008 * t1063)
  t1073 = 0.1e1 + 0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t1000 * t946
  t1074 = 0.1e1 / t1073
  t1085 = 0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t959 * t946 - 0.88547815820543093270365997638724911452184179456906e0 * t329 * t1008 * t991
  t1086 = t1085 ** 2
  t1088 = t1073 ** 2
  t1089 = 0.1e1 / t1088
  t1095 = 0.25851111111111111111111111111111111111111111111111e1 * t656 + 0.20525000000000000000000000000000000000000000000000e-2 * t665
  t1098 = 0.1000e4 + 0.21807500000000000000000000000000000000000000000000e4 * t594 + 0.11800000000000000000000000000000000000000000000000e3 * t601
  t1099 = 0.1e1 / t1098
  t1103 = -0.19388333333333333333333333333333333333333333333333e1 * t620 - 0.12315000000000000000000000000000000000000000000000e-2 * t628
  t1104 = t1098 ** 2
  t1105 = 0.1e1 / t1104
  t1106 = t1103 * t1105
  t1109 = -0.72691666666666666666666666666666666666666666666667e3 * t620 - 0.78666666666666666666666666666666666666666666666667e2 * t628
  t1114 = 0.2568e1 + 0.58165000000000000000000000000000000000000000000000e1 * t594 + 0.18472500000000000000000000000000000000000000000000e-2 * t601
  t1116 = 0.1e1 / t1104 / t1098
  t1117 = t1114 * t1116
  t1118 = t1109 ** 2
  t1121 = t1114 * t1105
  t1124 = 0.96922222222222222222222222222222222222222222222222e3 * t656 + 0.13111111111111111111111111111111111111111111111111e3 * t665
  t1126 = t1095 * t1099 - 0.2e1 * t1106 * t1109 + 0.2e1 * t1117 * t1118 - t1121 * t1124
  t1129 = t484 * t1126 * t822 * s0
  t1137 = jnp.exp(-0.25e2 / 0.9e1 * t522 * t524 * t3 * t81 * t823 * s0)
  t1138 = t828 * t1137
  t1139 = t10 * t198 * t1138
  t1144 = t1103 * t1099 - t1121 * t1109
  t1147 = t484 * t1144 * t822 * s0
  t1149 = t332 * t198 * t1138
  t1154 = t546 * t1144 * t824 * t223
  t1157 = t227 * t524 * t1137
  t1158 = t550 * t6 * t1157
  t1162 = t1114 * t1099 - 0.18535714285714285714285714285714285714285714285714e-2
  t1165 = t484 * t1162 * t822 * s0
  t1167 = t193 * t198 * t1138
  t1172 = t546 * t1162 * t824 * t223
  t1174 = t569 * t6 * t1157
  t1179 = t575 * t1162 * t966 * t578
  t1181 = t584 * t1137
  t1182 = t582 * t227 * t1181
  t1185 = -t610 - t635 - t644 + t670 + t678 + t793 + t798 + t805 + t810 - t814 - t818 + 0.25507875555555555555555555555555555555555555555556e-1 * t184 * t1068 * t1074 - 0.25507875555555555555555555555555555555555555555556e-1 * t184 * t824 * t1086 * t1089 + t1129 * t1139 / 0.2e1 - 0.7e1 / 0.3e1 * t1147 * t1149 + 0.200e3 / 0.27e2 * t1154 * t1158 + 0.35e2 / 0.9e1 * t1165 * t1167 - 0.2500e4 / 0.81e2 * t1172 * t1174 + 0.80000e5 / 0.81e2 * t1179 * t1182
  t1187 = f.my_piecewise3(t111, f.p.zeta_threshold, 1)
  t1196 = 0.1e1 / t23 / t579 / t7
  t1203 = 0.32530742648344572643999342659690126035062438557102e-1 * t136 * t48 * t157
  t1206 = 0.21687161765563048429332895106460084023374959038068e-1 * t136 * t11 * t146
  t1209 = 0.16265371324172286321999671329845063017531219278551e-1 * t136 * t48 * t168
  t1212 = 0.48159446095139119802213748237831062407565640073877e0 * t136 * t48 * t176
  t1215 = t155 * t143
  t1221 = 0.10253897021007794930818001372045340355835853271641e4 * t152 / t171 / t137 * t1215 / t174 / t130
  t1226 = 0.1e1 / t191
  t1227 = 0.1e1 / t15 / t26 * t2 * t1226 / 0.4e1
  t1230 = 0.1e1 / t23 / t330
  t1231 = t79 * t1230
  t1232 = t78 * t1231
  t1234 = t44 * t332
  t1235 = t43 * t1234
  t1237 = t6 * t332
  t1238 = t4 * t1237
  t1240 = t14 ** (-0.15e1)
  t1242 = t1240 * t2 * t1226
  t1244 = t91 * t1231
  t1246 = t52 * t1234
  t1248 = t5 * t1230
  t1249 = t22 * t1248
  t1255 = 0.58482233974552040708313425006184496242808878304903e0 * t152 * t138 * (-0.34523333333333333333333333333333333333333333333333e1 * t1227 + 0.23015555555555555555555555555555555555555555555556e1 * t1232 - 0.26851481481481481481481481481481481481481481481482e1 * t1235 - 0.93932222222222222222222222222222222222222222222223e0 * t1238 + 0.73355000000000000000000000000000000000000000000000e-1 * t1242 - 0.14671000000000000000000000000000000000000000000000e0 * t1244 - 0.17116166666666666666666666666666666666666666666667e0 * t1246 - 0.36793333333333333333333333333333333333333333333333e0 * t1249) * t145
  t1261 = 0.10389453539625517979803415350183779755340003251893e3 * t152 / t171 / t127 * t1215 * t175
  t1272 = 0.35089340384731224424988055003710697745685326982943e1 * t152 * t172 * t1215 * t145
  t1274 = 0.1e1 / t8 / t259
  t1275 = s0 * t1274
  t1279 = t363 * jnp.pi
  t1280 = t1279 * t427
  t1283 = 0.1e1 / t230 / t350
  t1285 = t1283 * t235 * t6
  t1286 = t249 * t248
  t1287 = t251 * t217
  t1293 = t339 * t232
  t1297 = t236 * t248
  t1303 = t1279 * t221
  t1310 = t223 * t297
  t1323 = t71 * t60
  t1328 = 0.51725014705706168413145063783413931475389495076352e3 * t67 / t103 / t39 * t1323 / t106 / t31
  t1340 = 0.10000000000000000000000000000000000000000000000000e1 * t75 * (-0.25319000000000000000000000000000000000000000000000e1 * t1227 + 0.16879333333333333333333333333333333333333333333333e1 * t1232 - 0.19692555555555555555555555555555555555555555555555e1 * t1235 - 0.93011851851851851851851851851851851851851851851854e0 * t1238 + 0.13651666666666666666666666666666666666666666666667e0 * t1242 - 0.27303333333333333333333333333333333333333333333333e0 * t1244 - 0.31853888888888888888888888888888888888888888888890e0 * t1246 - 0.36514074074074074074074074074074074074074074074075e0 * t1249) * t61
  t1346 = 0.96490945932906628927985590685407352610080087485128e2 * t67 / t103 / t28 * t1323 * t107
  t1351 = 0.51947267698127589899017076750918898776700016259463e2 * t152 * t172 * t166 * t175 * t143
  t1356 = 0.35089340384731224424988055003710697745685326982943e1 * t152 * t154 * t143 * t145 * t166
  t1360 = 0.71233333333333333333333333333333333333333333333333e-1 * t36 * t10 * t40 * t62
  t1363 = 0.53424999999999999999999999999999999999999999999999e-1 * t36 * t41 * t100
  t1367 = 0.85917146441092277507960503039464796886558811231548e0 * t36 * t38 * t104 * t108
  t1368 = t1328 + t1340 - t1346 - t1351 - t1272 + t1356 - t1221 - t1255 + t1360 - t1363 - t1367
  t1371 = 0.34451131037037037037037037037037037037037037037036e-2 * t4 * t1237 * t32
  t1375 = 0.48245472966453314463992795342703676305040043742564e2 * t105 * t99 * t107 * t60
  t1378 = 0.60000000000000000000000000000000000000000000000000e1 * t105 * t1323 * t61
  t1381 = 0.60000000000000000000000000000000000000000000000000e1 * t70 * t62 * t99
  t1385 = 0.10685000000000000000000000000000000000000000000000e0 * t36 * t38 * t69 * t72
  t1389 = 0.56969282336565386484066937725323112718202900731800e-3 * t122 * t44 * t332 * t131
  t1390 = t1261 + t1371 + t1375 - t1203 + t1378 - t1381 + t1385 - t1389 - t1206 + t1209 + t1212
  t1391 = t1368 + t1390
  t1397 = t236 * t277
  t1404 = t1279 * t257
  t1412 = 0.1e1 / t23 / t568
  t1414 = t1412 * t227 * t301
  t1417 = -0.455e3 / 0.1296e4 * t1275 * t117 * t200 + 0.34734717313134690805416039216483526584685190724888e2 * t1280 * t275 * t1285 * t1286 * t1287 * t365 - 0.41347079511772567175622875720961804388775567632413e1 * t224 * t1293 * t254 + 0.88600884668084072519191876544918152261661930640888e0 * t234 * t1297 * t252 * t213 * t277 - 0.34734717313134690805416039216483526584685190724887e2 * t1303 * t275 * t1285 * t1286 * t251 * t365 + 0.89647473495616209060131437869811783310346764514349e0 * t258 * t1310 * t227 * t271 - 0.15820142381579331010611430212319726466531781973121e0 * t264 * t280 + 0.20673539755886283587811437860480902194387783816207e1 * t284 * t1293 * t288 + 0.11300101701128093579008164437371233190379844266515e-1 * t276 * t268 * t1391 * t1 * t217 - 0.44300442334042036259595938272459076130830965320444e0 * t285 * t1397 * t20 * t248 * t213 * t217 + 0.57891195521891151342360065360805877641141984541478e1 * t1404 * t275 * t1285 * t1286 * t365 * t217 - 0.15244777318640955004591368227731864095500459136823e0 * t294 * t1414
  t1433 = t344 ** 2
  t1464 = t1274 * t117
  t1477 = t228 * t1283
  t1479 = t236 * t1286
  t1493 = -0.84050343231531274554606181765571155961502973883158e0 * t437 * t442 + 0.10983580743977364361883290480774977553098586443084e2 * t445 * t263 * t449 + 0.60035959451093767539004415546836539972502124202256e-1 * t369 * t371 * t6 * t1391 * t217 - 0.13498917342362120724254458289018769860242437252204e0 * t320 * t1414 + 0.99232990828254161221494901730308330533061362317785e2 * t283 * t334 * t419 + 0.36160325443609899452826126199587946209215501652845e0 * t349 * t353 * t5 * t1391 * t217 - 0.93262167125803489439853076216712580348943985307620e0 * t310 * t1464 * t313 - 0.25312227810526929616978288339711562346450851156991e1 * t408 * t413 - 0.23536244451380066489749908173089237613782685235180e1 * t445 * t223 * t233 * t1397 * t270 + 0.10252277837406933531704852189044724493708733980189e2 * t363 * t221 * t223 * t1477 * t1479 * t287 + 0.12302733404888320238045822626853669392450480776228e3 * t363 / t426 / t218 * t223 * t1477 * t1479 * t1287 * t20 * t213
  t1507 = t311 / t230 / t188
  t1509 = t199 * t1286
  t1510 = t365 * t1
  t1526 = t311 * t399
  t1563 = -0.92270500536662401785343669701402520443378605821706e2 * t363 * t427 * t223 * t1477 * t1479 * t253 + 0.47628527831201055580943503000490321711518351867124e1 * t366 * t367 * t297 * t374 + 0.18525182567005168429555220915457880845165435053272e3 * t1404 * s0 * t1507 * t1509 * t1510 * t217 - 0.32950742231932093085649871442324932659295759329252e2 * t428 * t263 * t433 + 0.70608733354140199469249724519267712841348055705540e1 * t428 * t223 * t233 * t1297 * t251 * t1 * t277 - 0.42528424640680354809212100741560713085597726707623e2 * t283 * s0 * t1526 * t199 * t277 * t248 * t213 * t217 - 0.19846598165650832244298980346061666106612272463557e3 * t222 * t334 * t404 + 0.85056849281360709618424201483121426171195453415246e2 * t222 * s0 * t1526 * t199 * t248 * t251 * t213 * t277 + 0.11115109540203101057733132549274728507099261031963e4 * t1280 * s0 * t1507 * t1509 * t1287 * t365 * t1 - 0.11115109540203101057733132549274728507099261031963e4 * t1303 * s0 * t1507 * t1509 * t251 * t365 * t1 + 0.84374092701756432056594294465705207821502837189970e1 * t189 * t347 * t193 * t356
  t1577 = 0.40000e5 / 0.27e2 * t575 * t539 * t350 * t586 - 0.80000e5 / 0.9e1 * t577 * t578 * t1196 * t585 - t1203 - t1206 + t1209 + t1212 - t1221 - t1255 + t1261 + 0.51015751111111111111111111111111111111111111111112e-1 * t184 * t188 * t477 * t476 / t479 / t464 - t1272 + 0.25507875555555555555555555555555555555555555555556e-1 * t184 * t188 * (0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t1417 * t325 - 0.26564344746162927981109799291617473435655253837072e1 * t329 * t305 * t345 * t379 + 0.53128689492325855962219598583234946871310507674143e1 * t329 * t343 * t391 * t393 - 0.26564344746162927981109799291617473435655253837072e1 * t329 * t346 * t454 - 0.53128689492325855962219598583234946871310507674143e1 * t329 * t389 / t1433 * t393 * t379 + 0.53128689492325855962219598583234946871310507674143e1 * t329 * t392 * t379 * t454 - 0.88547815820543093270365997638724911452184179456906e0 * t329 * t397 * (t1493 + t1563)) * t465 - t1381 + t1371 + t1375 - 0.76523626666666666666666666666666666666666666666668e-1 * t184 * t459 * t480 * t476 + t1378
  t1592 = t496 ** 2
  t1618 = 0.1e1 / t579
  t1624 = 0.1e1 / t363 * t182
  t1626 = t223 ** 2
  t1631 = 0.1e1 / t8 / t579 / t259
  t1643 = 0.35e2 / 0.3e1 * t542 * t562 + t484 * ((-0.60319259259259259259259259259259259259259259259259e1 * t1238 - 0.54733333333333333333333333333333333333333333333333e-2 * t1249) * t491 - 0.3e1 * t487 * t497 * t501 + 0.6e1 * t495 * t508 * t510 - 0.3e1 * t498 * t516 - 0.6e1 * t506 / t1592 * t510 * t501 + 0.6e1 * t509 * t501 * t516 - t513 * (-0.22615185185185185185185185185185185185185185185185e4 * t1238 - 0.34962962962962962962962962962962962962962962962963e3 * t1249)) * t186 * s0 * t534 / 0.2e1 + 0.50e2 / 0.9e1 * t546 * t518 * t188 * t223 * t554 - 0.1250e4 / 0.27e2 * t549 * t571 + 0.29750e5 / 0.243e3 * t567 * t1618 * t227 * t553 + 0.4000000e7 / 0.243e3 * t1624 * t558 * t265 * t1626 * t1631 * t21 * t5 * t117 * t532 - 0.455e3 / 0.27e2 * t561 * t1464 * t533 - 0.7e1 / 0.2e1 * t521 * t543 + t1328 + t1340 - t1351 + t1356 + t1360 - t1363 - t1367 + t1385 - t1389 - t1346
  t1650 = 0.1e1 / t595 / t601 * t2 * t1226 / 0.4e1
  t1652 = t1248 * t227
  t1653 = t649 * t1652
  t1655 = t1237 * t117
  t1656 = t616 * t1655
  t1658 = t4 * t1655
  t1660 = t594 ** (-0.15e1)
  t1662 = t1660 * t2 * t1226
  t1664 = t660 * t1652
  t1666 = t624 * t1655
  t1668 = t22 * t1652
  t1670 = -0.69046666666666666666666666666666666666666666666667e1 * t1650 + 0.23015555555555555555555555555555555555555555555556e1 * t1653 - 0.26851481481481481481481481481481481481481481481482e1 * t1656 - 0.93932222222222222222222222222222222222222222222223e0 * t1658 + 0.14671000000000000000000000000000000000000000000000e0 * t1662 - 0.14671000000000000000000000000000000000000000000000e0 * t1664 - 0.17116166666666666666666666666666666666666666666667e0 * t1666 - 0.36793333333333333333333333333333333333333333333333e0 * t1668
  t1674 = 0.58482233974552040708313425006184496242808878304903e0 * t806 * t752 * t1670 * t759
  t1676 = 0.1e1 / t784 / t743
  t1677 = t769 * t758
  t1681 = 0.10389453539625517979803415350183779755340003251893e3 * t806 * t1676 * t1677 * t788
  t1683 = 0.1e1 / t784 / t751
  t1686 = 0.1e1 / t787 / t746
  t1689 = 0.10253897021007794930818001372045340355835853271641e4 * t806 * t1683 * t1677 * t1686
  t1703 = 0.60000000000000000000000000000000000000000000000000e1 * t640 * t632 * t667
  t1707 = 0.48245472966453314463992795342703676305040043742564e2 * t673 * t667 * t675 * t630
  t1719 = 0.34451131037037037037037037037037037037037037037036e-2 * t36 * t359 * t607
  t1723 = t716 * t705
  t1742 = t641 * t630
  t1745 = 0.96490945932906628927985590685407352610080087485128e2 * t637 / t671 / t603 * t1742 * t675
  t1748 = 0.60000000000000000000000000000000000000000000000000e1 * t673 * t1742 * t631
  t1760 = 0.10000000000000000000000000000000000000000000000000e1 * t645 * (-0.50638000000000000000000000000000000000000000000000e1 * t1650 + 0.16879333333333333333333333333333333333333333333333e1 * t1653 - 0.19692555555555555555555555555555555555555555555555e1 * t1656 - 0.93011851851851851851851851851851851851851851851854e0 * t1658 + 0.27303333333333333333333333333333333333333333333333e0 * t1662 - 0.27303333333333333333333333333333333333333333333333e0 * t1664 - 0.31853888888888888888888888888888888888888888888890e0 * t1666 - 0.36514074074074074074074074074074074074074074074075e0 * t1668) * t631
  t1768 = 0.51725014705706168413145063783413931475389495076352e3 * t637 / t671 / t611 * t1742 / t674 / t606
  t1773 = 0.51947267698127589899017076750918898776700016259463e2 * t786 * t780 * t788 * t758 - 0.60000000000000000000000000000000000000000000000000e1 * t715 * t707 * t727 + 0.96494049533612093920874879382438082984882598906400e2 * t733 * t727 * t735 * t705 + t1703 - t1707 - 0.35089340384731224424988055003710697745685326982943e1 * t768 * t760 * t780 + 0.16562449037037037037037037037037037037037037037036e-2 * t36 * t359 * t694 + 0.56969282336565386484066937725323112718202900731800e-3 * t36 * t359 * t747 - t1719 - 0.19298809906722418784174975876487616596976519781280e3 * t712 / t731 / t690 * t1723 * t735 + 0.99999999999999999999999999999999999999999999999999e0 * t720 * (-0.94126000000000000000000000000000000000000000000000e1 * t1650 + 0.31375333333333333333333333333333333333333333333334e1 * t1653 - 0.36604555555555555555555555555555555555555555555556e1 * t1656 - 0.16068111111111111111111111111111111111111111111111e1 * t1658 + 0.56103333333333333333333333333333333333333333333332e0 * t1662 - 0.56103333333333333333333333333333333333333333333332e0 * t1664 - 0.65453888888888888888888888888888888888888888888890e0 * t1666 - 0.46308888888888888888888888888888888888888888888888e0 * t1668) * t706 + t1745 - t1748 - t1760 - t1768 - 0.10389453539625517979803415350183779755340003251893e3 * t765 * t1676 * t1677 * t788
  t1816 = 0.85917146441092277507960503039464796886558811231548e0 * t49 * t117 * t672 * t676
  t1818 = 0.71233333333333333333333333333333333333333333333333e-1 * t88 * t633
  t1821 = 0.53424999999999999999999999999999999999999999999999e-1 * t49 * t613 * t668
  t1825 = 0.10685000000000000000000000000000000000000000000000e0 * t49 * t117 * t639 * t642
  t1834 = 0.58482233974552040708313425006184496242808878304903e0 * t773 * t1670 * t759 + 0.60000000000000000000000000000000000000000000000000e1 * t733 * t1723 * t706 + 0.10253897021007794930818001372045340355835853271641e4 * t765 * t1683 * t1677 * t1686 + 0.35089340384731224424988055003710697745685326982943e1 * t786 * t1677 * t759 + 0.20691336878655965245175271659148296983999699561788e4 * t712 / t731 / t698 * t1723 / t734 / t693 - 0.48159446095139119802213748237831062407565640073877e0 * t49 * t117 * t785 * t789 + 0.21687161765563048429332895106460084023374959038068e-1 * t88 * t761 - 0.16265371324172286321999671329845063017531219278551e-1 * t49 * t753 * t781 - 0.16522997748472177549051141846252814409778063686072e1 * t49 * t117 * t732 * t736 + 0.68493333333333333333333333333333333333333333333331e-1 * t88 * t708 - 0.51369999999999999999999999999999999999999999999999e-1 * t49 * t700 * t728 + t1816 - t1818 + t1821 - t1825 + 0.10274000000000000000000000000000000000000000000000e0 * t49 * t117 * t714 * t717 + 0.32530742648344572643999342659690126035062438557102e-1 * t49 * t117 * t767 * t770
  t1836 = t685 * (t1773 + t1834)
  t1840 = 0.35089340384731224424988055003710697745685326982943e1 * t806 * t785 * t1677 * t759
  t1844 = t1279 * t1037
  t1846 = 0.1e1 / t855 / t966
  t1847 = t274 * t1846
  t1849 = t885 * t884
  t1850 = t887 * t847
  t1857 = t261 * t857 * t235
  t1861 = t861 * t884
  t1867 = t1279 * t851
  t1886 = 0.35089340384731224424988055003710697745685326982943e1 * t806 * t767 * t758 * t781
  t1889 = 0.32530742648344572643999342659690126035062438557102e-1 * t799 * t800 * t808
  t1894 = 0.51947267698127589899017076750918898776700016259463e2 * t806 * t785 * t780 * t788 * t758
  t1895 = t1886 - t1689 - t1674 + t1681 - t1703 + t1707 + t1748 + t1836 - t1889 + t1719 - t1894
  t1898 = 0.21687161765563048429332895106460084023374959038068e-1 * t799 * t311 * t802
  t1901 = 0.16265371324172286321999671329845063017531219278551e-1 * t799 * t800 * t812
  t1904 = 0.48159446095139119802213748237831062407565640073877e0 * t799 * t800 * t816
  t1907 = 0.56969282336565386484066937725323112718202900731800e-3 * t794 * t1237 * t795
  t1908 = -t1745 + t1760 + t1768 - t1816 + t1818 - t1821 - t1840 - t1898 + t1901 + t1904 + t1825 - t1907
  t1909 = t1895 + t1908
  t1915 = t861 * t907
  t1922 = t1279 * t893
  t1930 = t1412 * t923 * t899
  t1933 = -0.455e3 / 0.1296e4 * t1275 * t825 * t829 + 0.69469434626269381610832078432967053169370381449768e2 * t1844 * t1847 * t899 * t1849 * t1850 * t365 - 0.82694159023545134351245751441923608777551135264821e1 * t853 * t1857 * t890 + 0.17720176933616814503838375308983630452332386128176e1 * t860 * t1861 * t888 * t213 * t907 - 0.69469434626269381610832078432967053169370381449767e2 * t1867 * t1847 * t899 * t1849 * t887 * t365 + 0.17929494699123241812026287573962356662069352902869e1 * t894 * t1310 * t896 * t902 - 0.31640284763158662021222860424639452933063563946239e0 * t898 * t910 + 0.41347079511772567175622875720961804388775567632411e1 * t914 * t1857 * t917 + 0.22600203402256187158016328874742466380759688533028e-1 * t906 * t899 * t1909 * t1 * t847 - 0.88600884668084072519191876544918152261661930640879e0 * t915 * t1915 * t20 * t884 * t213 * t847 + 0.11578239104378230268472013072161175528228396908294e2 * t1922 * t1847 * t899 * t1849 * t365 * t847 - 0.30489554637281910009182736455463728191000918273645e0 * t922 * t1930
  t1949 = t960 ** 2
  t1965 = t226 * t1846 * t235
  t1967 = t861 * t1849
  t1982 = t262 * t857
  t2016 = -0.26997834684724241448508916578037539720484874504407e0 * t940 * t1930 + 0.20504555674813867063409704378089448987417467960378e2 * t363 * t851 * t223 * t1965 * t1967 * t916 + 0.12007191890218753507800883109367307994500424840451e0 * t981 * t983 * t117 * t1909 * t847 - 0.93262167125803489439853076216712580348943985307616e0 * t932 * t1274 * t825 * t934 - 0.16810068646306254910921236353114231192300594776632e1 * t1046 * t1051 + 0.21967161487954728723766580961549955106197172886168e2 * t1054 * t1982 * t1058 + 0.36160325443609899452826126199587946209215501652844e0 * t965 * t969 * t227 * t1909 * t847 - 0.47072488902760132979499816346178475227565370470357e1 * t1054 * t223 * t859 * t1915 * t901 + 0.24605466809776640476091645253707338784900961552454e3 * t363 / t1036 / t848 * t223 * t1965 * t1967 * t1850 * t20 * t213 - 0.18454100107332480357068733940280504088675721164340e3 * t363 * t1037 * t223 * t1965 * t1967 * t889 + 0.95257055662402111161887006000980643423036703734248e1 * t366 * t979 * t297 * t986
  t2021 = t10 / t855 / t824 * t198
  t2023 = t828 * t1849
  t2040 = t10 * t1009 * t198
  t2066 = t333 * t1009
  t2083 = 0.18525182567005168429555220915457880845165435053270e3 * t1922 * s0 * t2021 * t2023 * t1510 * t847 - 0.65901484463864186171299742884649865318591518658503e2 * t1038 * t1982 * t1042 + 0.14121746670828039893849944903853542568269611141107e2 * t1038 * t223 * t859 * t1861 * t887 * t1 * t907 - 0.42528424640680354809212100741560713085597726707620e2 * t913 * s0 * t2040 * t828 * t907 * t884 * t213 * t847 + 0.11115109540203101057733132549274728507099261031963e4 * t1844 * s0 * t2021 * t2023 * t1850 * t365 * t1 - 0.11115109540203101057733132549274728507099261031962e4 * t1867 * s0 * t2021 * t2023 * t887 * t365 * t1 + 0.84374092701756432056594294465705207821502837189969e1 * t189 * t963 * t193 * t972 - 0.19846598165650832244298980346061666106612272463557e3 * t852 * t2066 * t1014 + 0.85056849281360709618424201483121426171195453415243e2 * t852 * s0 * t2040 * t828 * t884 * t887 * t213 * t907 - 0.25312227810526929616978288339711562346450851156991e1 * t1018 * t1023 + 0.99232990828254161221494901730308330533061362317783e2 * t913 * t2066 * t1029
  t2112 = -t1674 + t1681 - t1689 + t1836 - t1703 + t1707 - t1840 + t1719 + 0.25507875555555555555555555555555555555555555555556e-1 * t184 * t824 * (0.88547815820543093270365997638724911452184179456906e0 * t189 * t190 * t1933 * t946 - 0.26564344746162927981109799291617473435655253837072e1 * t329 * t928 * t961 * t991 + 0.53128689492325855962219598583234946871310507674143e1 * t329 * t959 * t1002 * t1004 - 0.26564344746162927981109799291617473435655253837072e1 * t329 * t962 * t1063 - 0.53128689492325855962219598583234946871310507674143e1 * t329 * t1000 / t1949 * t1004 * t991 + 0.53128689492325855962219598583234946871310507674143e1 * t329 * t1003 * t991 * t1063 - 0.88547815820543093270365997638724911452184179456906e0 * t329 * t1008 * (t2016 + t2083)) * t1074 + 0.51015751111111111111111111111111111111111111111112e-1 * t184 * t824 * t1086 * t1085 / t1088 / t1073 - 0.76523626666666666666666666666666666666666666666668e-1 * t184 * t1068 * t1089 * t1085 + t1886 - t1894 - t1745 + t1748 + t1760 + t1768 + 0.16000000e8 / 0.243e3 * t1624 * t1162 * t895 * t1626 * t1631 * t227 * t79 * t1137
  t2125 = t1104 ** 2
  t2172 = t484 * ((-0.60319259259259259259259259259259259259259259259259e1 * t1658 - 0.54733333333333333333333333333333333333333333333333e-2 * t1668) * t1099 - 0.3e1 * t1095 * t1105 * t1109 + 0.6e1 * t1103 * t1116 * t1118 - 0.3e1 * t1106 * t1124 - 0.6e1 * t1114 / t2125 * t1118 * t1109 + 0.6e1 * t1117 * t1109 * t1124 - t1121 * (-0.22615185185185185185185185185185185185185185185185e4 * t1658 - 0.34962962962962962962962962962962962962962962962963e3 * t1668)) * t822 * s0 * t1139 / 0.2e1 + 0.100e3 / 0.9e1 * t546 * t1126 * t824 * t223 * t1158 - 0.2500e4 / 0.27e2 * t1154 * t1174 + 0.80000e5 / 0.27e2 * t575 * t1144 * t966 * t578 * t1182 - 0.455e3 / 0.27e2 * t1165 * t1274 * t198 * t1138 + 0.59500e5 / 0.243e3 * t1172 * t1618 * t6 * t1157 - 0.7e1 / 0.2e1 * t1129 * t1149 + 0.35e2 / 0.3e1 * t1147 * t1167 - 0.160000e6 / 0.9e1 * t1179 * t1196 * t227 * t1181 - t1889 - t1898 + t1901 + t1904 - t1816 + t1818 - t1821 + t1825 - t1907
  v3rho3_0_ = 0.3e1 * params.c1 * t589 + 0.3e1 * t592 * t1185 * t1187 + r0 * (params.c1 * (t1577 + t1643) + t592 * (t2112 + t2172) * t1187)

  res = {'v3rho3': v3rho3_0_}
  return res
