"""Generated from gga_c_revtca.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  sinc = lambda x: jnp.sin(x) / x

  sinc_taylor = lambda x: sinc_taylor_series(x)

  sinc_cutoff = DBL_EPSILON ** (1 / 4)

  revtca_aa = jnp.pi * (9 * jnp.pi / 4) ** (1 / 3)

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  msinc = lambda x: f.my_piecewise3(x <= sinc_cutoff, sinc_taylor(x), sinc(jnp.maximum(x, sinc_cutoff)))

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  revtca_fD = lambda rs, z, s: 1 - z ** 4 * (1 - msinc(revtca_aa * s / rs) ** 2)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt) * revtca_fD(rs, z, X2S * 2 ** (1 / 3) * xt)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  sinc = lambda x: jnp.sin(x) / x

  sinc_taylor = lambda x: sinc_taylor_series(x)

  sinc_cutoff = DBL_EPSILON ** (1 / 4)

  revtca_aa = jnp.pi * (9 * jnp.pi / 4) ** (1 / 3)

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  msinc = lambda x: f.my_piecewise3(x <= sinc_cutoff, sinc_taylor(x), sinc(jnp.maximum(x, sinc_cutoff)))

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  revtca_fD = lambda rs, z, s: 1 - z ** 4 * (1 - msinc(revtca_aa * s / rs) ** 2)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt) * revtca_fD(rs, z, X2S * 2 ** (1 / 3) * xt)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  sinc = lambda x: jnp.sin(x) / x

  sinc_taylor = lambda x: sinc_taylor_series(x)

  sinc_cutoff = DBL_EPSILON ** (1 / 4)

  revtca_aa = jnp.pi * (9 * jnp.pi / 4) ** (1 / 3)

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  msinc = lambda x: f.my_piecewise3(x <= sinc_cutoff, sinc_taylor(x), sinc(jnp.maximum(x, sinc_cutoff)))

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  revtca_fD = lambda rs, z, s: 1 - z ** 4 * (1 - msinc(revtca_aa * s / rs) ** 2)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt) * revtca_fD(rs, z, X2S * 2 ** (1 / 3) * xt)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = t19 * t18
  t21 = 3 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / jnp.pi
  t23 = t22 ** (0.1e1 / 0.3e1)
  t25 = 4 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t2 ** (0.1e1 / 0.3e1)
  t32 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t21 * t23 * t26 / t27
  t33 = jnp.arctan(t32)
  t35 = -0.655868e0 * t33 + 0.897889e0
  t36 = t20 * t35
  t37 = t21 ** 2
  t38 = 0.1e1 / t23
  t39 = t37 * t38
  t42 = 6 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = jnp.pi ** 2
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = 0.1e1 / t45
  t47 = t43 * t46
  t48 = 2 ** (0.1e1 / 0.3e1)
  t50 = s0 + 0.2e1 * s1 + s2
  t51 = jnp.sqrt(t50)
  t52 = t48 * t51
  t53 = t27 * t2
  t56 = t47 * t52 / t53
  t57 = t56 ** 0.230e1
  t59 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t57
  t60 = 0.1e1 / t59
  t61 = t1 ** 2
  t62 = t61 ** 2
  t63 = t2 ** 2
  t64 = t63 ** 2
  t65 = 0.1e1 / t64
  t66 = t62 * t65
  t67 = jnp.pi ** (0.1e1 / 0.3e1)
  t69 = 9 ** (0.1e1 / 0.3e1)
  t71 = t67 * jnp.pi * t69 * t47
  t73 = t3 * t37 * t38
  t76 = t71 * t52 * t73 / 0.36e2
  t77 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t78 = t76 <= t77
  t79 = t67 ** 2
  t81 = t69 ** 2
  t83 = t45 ** 2
  t86 = t79 * t44 * t81 * t42 / t83
  t87 = t48 ** 2
  t88 = t87 * t50
  t89 = 0.1e1 / t63
  t91 = t23 ** 2
  t92 = 0.1e1 / t91
  t97 = t44 ** 2
  t104 = t67 * t97 * jnp.pi * t69 * t43 / t45 / t44
  t105 = t50 ** 2
  t106 = t48 * t105
  t109 = 0.1e1 / t23 / t22
  t110 = t65 * t37 * t109
  t114 = t97 * t44
  t116 = t114 * t105 * t50
  t118 = 0.1e1 / t64 / t63
  t122 = t77 < t76
  t123 = f.my_piecewise3(t122, t76, t77)
  t124 = jnp.sin(t123)
  t125 = 0.1e1 / t123
  t127 = f.my_piecewise3(t78, 0.1e1 - t86 * t88 * t89 * t21 * t92 / 0.432e3 + t104 * t106 * t110 / 0.34560e5 - t116 * t118 / 0.322560e6, t124 * t125)
  t128 = t127 ** 2
  t129 = 0.1e1 - t128
  t131 = -t66 * t129 + 0.1e1
  t132 = t60 * t131
  t135 = 0.4e1 / 0.9e1 * t36 * t39 * t25 * t27 * t132
  t137 = t35 * t37
  t138 = t53 * t19 * t137
  t139 = t38 * t25
  t140 = 0.1e1 / t9
  t141 = t1 * t89
  t142 = t3 - t141
  t145 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t140 * t142)
  t146 = 0.1e1 / t14
  t150 = f.my_piecewise3(t13, 0, -0.2e1 / 0.3e1 * t146 * t142)
  t156 = t32 ** 2
  t161 = 0.69457230103866666666666666666666666666666666666663e0 * t20 / (0.1e1 + t156) * t132
  t166 = t59 ** 2
  t167 = 0.1e1 / t166
  t169 = t56 ** 0.130e1
  t174 = 0.48168651635187710215599851263339254184407710454627e-2 * t3 * t20 * t35 * t39 * t25 * t167 * t131 * t169 * t47 * t52
  t176 = t53 * t20 * t137
  t180 = 0.4e1 * t61 * t1 * t65 * t129
  t182 = 0.1e1 / t64 / t2
  t185 = 0.4e1 * t62 * t182 * t129
  t186 = t63 * t2
  t203 = jnp.cos(t123)
  t209 = f.my_piecewise3(t122, -t71 * t52 * t89 * t37 * t38 / 0.36e2, 0)
  t212 = t123 ** 2
  t214 = t124 / t212
  t217 = f.my_piecewise3(t78, t86 * t88 / t186 * t21 * t92 / 0.216e3 - t104 * t106 * t182 * t37 * t109 / 0.8640e4 + t116 / t64 / t186 / 0.53760e5, t203 * t209 * t125 - t214 * t209)
  t220 = 0.2e1 * t66 * t127 * t217
  vrho_0_ = t135 + t138 * t139 * t132 * (t145 / 0.2e1 + t150 / 0.2e1) + t161 + t174 + t176 * t139 * t60 * (-t180 + t185 + t220) / 0.3e1
  t226 = -t3 - t141
  t229 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t140 * t226)
  t233 = f.my_piecewise3(t13, 0, -0.2e1 / 0.3e1 * t146 * t226)
  vrho_1_ = t135 + t138 * t139 * t132 * (t229 / 0.2e1 + t233 / 0.2e1) + t161 + t174 + t176 * t139 * t60 * (t180 + t185 + t220) / 0.3e1
  t250 = 0.1e1 / t51
  t253 = t36 * t37 * t139 * t167 * t131 * t169 * t43 * t46 * t48 * t250
  t255 = t27 ** 2
  t260 = 0.1e1 / t255 / t63 * t20 * t137 * t38
  t261 = t25 * t60
  t262 = t62 * t127
  t266 = t86 * t87 * t89 * t21 * t92
  t270 = t104 * t48 * t50 * t110
  t273 = t114 * t105 * t118
  t278 = t71 * t48 * t250 * t73
  t280 = f.my_piecewise3(t122, t278 / 0.72e2, 0)
  t285 = f.my_piecewise3(t78, -t266 / 0.432e3 + t270 / 0.17280e5 - t273 / 0.107520e6, t203 * t280 * t125 - t214 * t280)
  vsigma_0_ = -0.18063244363195391330849944223752220319152891420485e-2 * t253 + 0.2e1 / 0.3e1 * t260 * t261 * t262 * t285
  t296 = f.my_piecewise3(t122, t278 / 0.36e2, 0)
  t301 = f.my_piecewise3(t78, -t266 / 0.216e3 + t270 / 0.8640e4 - t273 / 0.53760e5, t203 * t296 * t125 - t214 * t296)
  vsigma_1_ = -0.36126488726390782661699888447504440638305782840970e-2 * t253 + 0.2e1 / 0.3e1 * t260 * t261 * t262 * t301
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  sinc = lambda x: jnp.sin(x) / x

  sinc_taylor = lambda x: sinc_taylor_series(x)

  sinc_cutoff = DBL_EPSILON ** (1 / 4)

  revtca_aa = jnp.pi * (9 * jnp.pi / 4) ** (1 / 3)

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  msinc = lambda x: f.my_piecewise3(x <= sinc_cutoff, sinc_taylor(x), sinc(jnp.maximum(x, sinc_cutoff)))

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  revtca_fD = lambda rs, z, s: 1 - z ** 4 * (1 - msinc(revtca_aa * s / rs) ** 2)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt) * revtca_fD(rs, z, X2S * 2 ** (1 / 3) * xt)

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = 3 ** (0.1e1 / 0.3e1)
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t7 * t9 * t12 / t13
  t19 = jnp.arctan(t18)
  t21 = -0.655868e0 * t19 + 0.897889e0
  t22 = t6 * t21
  t23 = t7 ** 2
  t25 = 0.1e1 / t9
  t27 = 6 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / t30
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = jnp.sqrt(s0)
  t39 = t28 * t31 * t33 * t34 / t13 / r0
  t40 = t39 ** 0.230e1
  t42 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t40
  t43 = 0.1e1 / t42
  t48 = t18 ** 2
  t58 = t23 * t25 * t11
  t60 = t42 ** 2
  t62 = t39 ** 0.130e1
  t64 = 0.1e1 / t60 * t62 * t28
  t65 = t31 * t33
  vrho_0_ = 0.4e1 / 0.9e1 * t22 * t23 * t25 * t11 * t13 * t43 + 0.69457230103866666666666666666666666666666666666663e0 * t6 / (0.1e1 + t48) * t43 + 0.48168651635187710215599851263339254184407710454627e-2 / r0 * t6 * t21 * t58 * t64 * t65 * t34
  vsigma_0_ = -0.18063244363195391330849944223752220319152891420485e-2 * t22 * t58 * t64 * t65 / t34
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t5 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t6, 1)
  t8 = t7 ** 2
  t9 = t8 * t7
  t11 = 3 ** (0.1e1 / 0.3e1)
  t13 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t14 = t11 * t13
  t15 = 4 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t21 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t14 * t16 / t1
  t22 = jnp.arctan(t21)
  t24 = -0.655868e0 * t22 + 0.897889e0
  t26 = t11 ** 2
  t27 = 0.1e1 / t13
  t28 = t26 * t27
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = 0.1e1 / t32
  t34 = t30 * t33
  t35 = 2 ** (0.1e1 / 0.3e1)
  t36 = jnp.sqrt(s0)
  t37 = t35 * t36
  t39 = 0.1e1 / t1 / r0
  t41 = t34 * t37 * t39
  t42 = t41 ** 0.230e1
  t44 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t42
  t45 = 0.1e1 / t44
  t52 = t21 ** 2
  t53 = 0.1e1 + t52
  t54 = 0.1e1 / t53
  t58 = r0 ** 2
  t62 = t28 * t15
  t64 = t44 ** 2
  t65 = 0.1e1 / t64
  t66 = t41 ** 0.130e1
  t67 = t65 * t66
  t68 = t67 * t30
  t69 = t33 * t35
  t74 = t53 ** 2
  t86 = 0.1e1 / t1 / t58
  t96 = 0.1e1 / t1 / t58 / r0 * t9 * t24 * t62
  t98 = 0.1e1 / t64 / t44
  t99 = t41 ** 0.260e1
  t101 = t98 * t99 * t29
  t102 = t32 ** 2
  t103 = 0.1e1 / t102
  t104 = t35 ** 2
  t105 = t103 * t104
  t106 = t105 * s0
  t110 = t41 ** 0.30e0
  t112 = t65 * t110 * t29
  v2rho2_0_ = 0.4e1 / 0.27e2 / t2 * t9 * t24 * t28 * t15 * t45 + 0.92609640138488888888888888888888888888888888888884e0 / r0 * t9 * t54 * t45 + 0.16056217211729236738533283754446418061469236818208e-2 / t58 * t9 * t24 * t62 * t68 * t69 * t36 + 0.36778031659583040511111111111111111111111111111109e0 * t9 / t74 * t45 * t21 * t14 * t16 * t39 + 0.20073966722509356988758591749343098182802235760644e-1 * t9 * t54 * t67 * t34 * t37 * t86 + 0.83527884012674580090917586884936888612525308619053e-3 * t96 * t101 * t106 - 0.50095397700595218624223845313872824351784018872812e-1 * t96 * t112 * t106
  t125 = t9 * t24
  t126 = t125 * t62
  t127 = t105 * t86
  v2rhosigma_0_ = -0.37638687604705044353922359530018309092754192051208e-2 * t9 * t39 * t54 * t65 * t66 * t30 * t69 / t36 - 0.31322956504752967534094095081851333229696990732145e-3 * t126 * t101 * t127 + 0.18785774137723206984083941992702309131919007077304e-1 * t126 * t112 * t127
  t134 = t125 * t26
  t135 = t27 * t15
  t142 = t104 / s0 * t39
  v2sigma2_0_ = 0.11746108689282362825285285655694249961136371524554e-3 * t134 * t135 * t98 * t99 * t29 * t103 * t142 - 0.70446653016462026190314782472633659244696276539892e-2 * t134 * t135 * t65 * t110 * t29 * t103 * t142 + 0.90316221815976956654249721118761101595764457102425e-3 * t126 * t68 * t69 / t36 / s0
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = 3 ** (0.1e1 / 0.3e1)
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t7 * t9 * t12 / t13
  t19 = t18 ** 2
  t20 = 0.1e1 + t19
  t21 = 0.1e1 / t20
  t22 = t6 * t21
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / t26
  t28 = t24 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = jnp.sqrt(s0)
  t31 = t29 * t30
  t35 = t28 * t31 / t13 / r0
  t36 = t35 ** 0.230e1
  t38 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t36
  t39 = t38 ** 2
  t41 = 0.1e1 / t39 / t38
  t42 = t35 ** 0.260e1
  t43 = t41 * t42
  t45 = t26 ** 2
  t46 = 0.1e1 / t45
  t48 = t29 ** 2
  t50 = r0 ** 2
  t51 = t50 ** 2
  t52 = t13 ** 2
  t56 = t23 * t46 * t48 * s0 / t52 / t51
  t59 = 0.1e1 / t39
  t60 = t35 ** 0.30e0
  t61 = t59 * t60
  t65 = t50 * r0
  t71 = t35 ** 0.130e1
  t74 = t27 * t29 * t30
  t82 = jnp.atan(t18)
  t84 = -0.655868e0 * t82 + 0.897889e0
  t85 = t7 ** 2
  t87 = 0.1e1 / t9
  t89 = 0.1e1 / t52 / t51 / r0 * t6 * t84 * t85 * t87
  t90 = t39 ** 2
  t93 = t35 ** 0.390e1
  t94 = 0.1e1 / t25
  t96 = t30 * s0
  t102 = t35 ** 0.160e1
  t109 = t35 ** (-0.70e0)
  t115 = t20 ** 2
  t116 = 0.1e1 / t115
  t117 = t6 * t116
  t119 = t18 * t7
  t132 = 0.1e1 / t38
  t140 = t85 * t87
  t159 = t9 ** 2
  t164 = t85 * t159 * t11 / t52 / t50
  t173 = t140 * t11
  t184 = 0.1e1 / t13 / t51 * t6 * t84 * t173
  t187 = t46 * t48 * s0
  v3rho3_0_ = 0.52214539139616816995802751158798165290639964649157e-2 * t22 * t43 * t56 - 0.31315388087114596902463403128975233165171487786605e0 * t22 * t61 * t56 - 0.30110950083764035483137887624014647274203353640966e-1 / t13 / t65 * t6 * t21 * t59 * t71 * t24 * t74 + 0.43452995905773577549468091358629944725893789807942e-3 * t89 * t11 / t90 * t93 * t94 * t96 - 0.52121399623908937976732574216200618494215792578289e-1 * t89 * t11 * t41 * t102 * t94 * t96 + 0.24045790896285704939627445750658955688856329058950e0 * t89 * t11 * t59 * t109 * t94 * t96 + 0.15943933753545239999873657513889437155348866673572e-1 * t117 * t59 * t119 * t9 * t12 / t52 / t65 * t71 * t28 * t31 - 0.61739760092325925925925925925925925925925925925923e0 / t50 * t6 * t21 * t132 - 0.8e1 / 0.81e2 / t52 / r0 * t6 * t84 * t140 * t11 * t132 - 0.1e-49 / t13 / t50 * t6 * t116 * t132 * t119 * t9 * t12 + 0.15579355649288896570173188148148148148148148148147e1 * t6 / t115 / t20 * t132 * t19 * t164 - 0.38948389123222241425432970370370370370370370370367e0 * t117 * t132 * t164 - 0.10704144807819491159022189169630945374312824545471e-2 / t65 * t6 * t84 * t173 * t59 * t71 * t24 * t74 - 0.25058365203802374027275276065481066583757592585716e-2 * t184 * t43 * t23 * t187 + 0.15028619310178565587267153594161847305535205661843e0 * t184 * t61 * t23 * t187

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = t1 * r0
  t3 = r0 ** (0.1e1 / 0.3e1)
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t8, 1)
  t10 = t9 ** 2
  t11 = t10 * t9
  t13 = 3 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / jnp.pi
  t15 = t14 ** (0.1e1 / 0.3e1)
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t23 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t13 * t15 * t18 / t3
  t24 = t23 ** 2
  t25 = 0.1e1 + t24
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t31
  t33 = t29 * t32
  t34 = 2 ** (0.1e1 / 0.3e1)
  t35 = jnp.sqrt(s0)
  t36 = t34 * t35
  t40 = t33 * t36 / t3 / r0
  t41 = t40 ** 0.230e1
  t43 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t41
  t44 = 0.1e1 / t43
  t49 = t23 * t13 * t15 * t18
  t52 = t3 ** 2
  t55 = 0.1e1 / t52 / t2 * t11
  t57 = 0.1e1 / t26 / t25
  t60 = t13 ** 2
  t61 = t24 * t60
  t62 = t15 ** 2
  t63 = t62 * t17
  t67 = t1 ** 2
  t68 = t67 * t1
  t72 = jnp.atan(t23)
  t74 = -0.655868e0 * t72 + 0.897889e0
  t76 = 0.1e1 / t15
  t78 = 0.1e1 / t52 / t68 * t11 * t74 * t60 * t76
  t79 = t43 ** 2
  t80 = 0.1e1 / t79
  t82 = t40 ** (-0.70e0)
  t83 = 0.1e1 / t30
  t84 = t82 * t83
  t85 = t35 * s0
  t90 = t79 ** 2
  t91 = 0.1e1 / t90
  t93 = t40 ** 0.390e1
  t94 = t93 * t83
  t100 = 0.1e1 / t79 / t43
  t102 = t40 ** 0.160e1
  t103 = t102 * t83
  t108 = 0.1e1 / t25
  t109 = t11 * t108
  t110 = t40 ** 0.260e1
  t111 = t100 * t110
  t113 = t31 ** 2
  t114 = 0.1e1 / t113
  t116 = t34 ** 2
  t117 = t116 * s0
  t118 = t67 * r0
  t122 = t28 * t114 * t117 / t52 / t118
  t125 = t40 ** 0.30e0
  t126 = t80 * t125
  t135 = t40 ** 0.130e1
  t137 = t32 * t34
  t138 = t137 * t35
  t147 = t80 * t135 * t29
  t152 = t67 ** 2
  t156 = t60 * t76
  t157 = t156 * t17
  t158 = 0.1e1 / t152 * t11 * t74 * t157
  t161 = t40 ** 0.520e1
  t164 = s0 ** 2
  t166 = t164 * t29 * t137
  t170 = t40 ** 0.290e1
  t176 = t40 ** 0.60e0
  t182 = t40 ** (-0.170e1)
  t188 = t11 * t57
  t192 = 0.1e1 / t118
  t199 = -0.32691583697407147120987654320987654320987654320984e0 / t3 / t2 * t11 * t27 * t44 * t49 - 0.41544948398103724187128501728395061728395061728392e1 * t55 * t57 * t44 * t61 * t63 - 0.20839685443447610947677119650571094930342151851090e1 * t78 * t17 * t80 * t84 * t85 - 0.37659263118337100542872345844145952095774617833550e-2 * t78 * t17 * t91 * t94 * t85 + 0.45171879674054412913168230987373869361653686901184e0 * t78 * t17 * t100 * t103 * t85 - 0.34809692759744544663868500772532110193759976432772e-1 * t109 * t111 * t122 + 0.20876925391409731268308935419316822110114325191070e1 * t109 * t126 * t122 + 0.89217629877819364394482629997080436368009936713973e-1 / t3 / t67 * t11 * t108 * t80 * t135 * t29 * t138 - 0.74405024183211119999410401731484040058294711143336e-1 / t52 / t67 * t11 * t27 * t147 * t138 * t49 + 0.25116866667485343760775012216103398485399359246411e-4 * t158 / t90 / t43 * t161 * t83 * t166 - 0.45191115742004520651446815012975142514929541400259e-2 * t158 * t91 * t170 * t83 * t166 + 0.11814183914752692608059383489005473525355579651079e0 * t158 * t100 * t176 * t83 * t166 + 0.22442738169866657943652282700615025309599240455020e0 * t158 * t80 * t182 * t83 * t166 + 0.90052386596554859828406409327919565780832173031118e-1 * t188 * t80 * t61 * t62 * t17 * t192 * t135 * t33 * t36
  t200 = t11 * t27
  t207 = t117 / t68 * t49
  t210 = t200 * t80
  t221 = t26 ** 2
  t227 = 0.1e1 / t67
  t247 = t85 / t67 / t2
  t282 = 0.1e1 / t3 / t118 * t11 * t74 * t157
  t285 = t114 * t116 * s0
  t293 = 0.55295840928170264472631395044431548886826307123020e-2 * t200 * t100 * t110 * t28 * t114 * t207 - 0.33163382207374099199737207628890029283125642681030e0 * t210 * t125 * t28 * t114 * t207 + 0.10289960015387654320987654320987654320987654320988e1 / t2 * t11 * t108 * t44 + 0.29697713600369908855567989092776888888888888888887e2 * t11 / t221 * t44 * t24 * t23 * t14 * t227 - 0.14848856800184954427783994546388444444444444444443e2 * t188 * t44 * t23 * t14 * t227 + 0.40e2 / 0.243e3 / t52 / t1 * t11 * t74 * t156 * t17 * t44 + 0.36217496823956298542271086247545499737960666077495e-2 * t109 * t91 * t94 * t247 - 0.43442496564161191740507888964120073521812450588099e0 * t109 * t100 * t103 * t247 + 0.20041848375753342017576578002544149225709752183427e1 * t109 * t80 * t84 * t247 + 0.10386237099525931046782125432098765432098765432098e1 * t55 * t27 * t44 * t60 * t63 - 0.22513096649138714957101602331979891445208043257780e-1 * t210 * t60 * t62 * t17 * t192 * t135 * t29 * t138 + 0.17840241346365818598370315282718242290521374242450e-2 * t227 * t11 * t74 * t157 * t147 * t138 + 0.10673007401619529678283913879741935767156011656879e-1 * t282 * t111 * t28 * t285 - 0.64010785950760557130952691234393053338390690781924e0 * t282 * t126 * t28 * t285
  v4rho4_0_ = t199 + t293

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = t1 ** 2
  t3 = 0.1e1 / t2
  t4 = r0 - r1
  t5 = 0.1e1 / t1
  t6 = t4 * t5
  t7 = 0.1e1 + t6
  t8 = t7 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = t7 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = f.my_piecewise3(t8, t10, t12)
  t14 = 0.1e1 - t6
  t15 = t14 <= f.p.zeta_threshold
  t16 = t14 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = f.my_piecewise3(t15, t10, t17)
  t20 = t13 / 0.2e1 + t18 / 0.2e1
  t21 = t20 ** 2
  t22 = t21 * t20
  t24 = 3 ** (0.1e1 / 0.3e1)
  t25 = 0.1e1 / jnp.pi
  t26 = t25 ** (0.1e1 / 0.3e1)
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = t1 ** (0.1e1 / 0.3e1)
  t35 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t24 * t26 * t29 / t30
  t36 = jnp.arctan(t35)
  t38 = -0.655868e0 * t36 + 0.897889e0
  t40 = t24 ** 2
  t41 = 0.1e1 / t26
  t42 = t40 * t41
  t43 = t42 * t28
  t45 = 6 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t47 = jnp.pi ** 2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t50 = t46 / t48
  t51 = 2 ** (0.1e1 / 0.3e1)
  t53 = s0 + 0.2e1 * s1 + s2
  t54 = jnp.sqrt(t53)
  t55 = t51 * t54
  t56 = t30 * t1
  t57 = 0.1e1 / t56
  t59 = t50 * t55 * t57
  t60 = t59 ** 0.230e1
  t62 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t60
  t63 = t62 ** 2
  t64 = 0.1e1 / t63
  t65 = t4 ** 2
  t66 = t65 ** 2
  t67 = t2 ** 2
  t68 = 0.1e1 / t67
  t69 = t66 * t68
  t70 = jnp.pi ** (0.1e1 / 0.3e1)
  t72 = 9 ** (0.1e1 / 0.3e1)
  t74 = t70 * jnp.pi * t72 * t50
  t79 = t74 * t55 * t5 * t40 * t41 / 0.36e2
  t80 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t81 = t79 <= t80
  t82 = t70 ** 2
  t84 = t72 ** 2
  t86 = t48 ** 2
  t88 = t45 / t86
  t89 = t82 * t47 * t84 * t88
  t90 = t51 ** 2
  t91 = t90 * t53
  t93 = t26 ** 2
  t94 = 0.1e1 / t93
  t99 = t47 ** 2
  t106 = t70 * t99 * jnp.pi * t72 * t46 / t48 / t47
  t107 = t53 ** 2
  t108 = t51 * t107
  t111 = 0.1e1 / t26 / t25
  t118 = t99 * t47 * t107 * t53
  t120 = 0.1e1 / t67 / t2
  t124 = t80 < t79
  t125 = f.my_piecewise3(t124, t79, t80)
  t126 = jnp.sin(t125)
  t127 = 0.1e1 / t125
  t129 = f.my_piecewise3(t81, 0.1e1 - t89 * t91 * t3 * t24 * t94 / 0.432e3 + t106 * t108 * t68 * t40 * t111 / 0.34560e5 - t118 * t120 / 0.322560e6, t126 * t127)
  t130 = t129 ** 2
  t131 = 0.1e1 - t130
  t133 = -t69 * t131 + 0.1e1
  t134 = t64 * t133
  t135 = t59 ** 0.130e1
  t136 = t134 * t135
  t137 = t50 * t55
  t140 = 0.16056217211729236738533283754446418061469236818208e-2 * t3 * t22 * t38 * t43 * t136 * t137
  t141 = t5 * t22
  t143 = t141 * t38 * t43
  t144 = t65 * t4
  t145 = t144 * t68
  t147 = 0.4e1 * t145 * t131
  t149 = 0.1e1 / t67 / t1
  t150 = t66 * t149
  t152 = 0.4e1 * t150 * t131
  t153 = t2 * t1
  t154 = 0.1e1 / t153
  t170 = jnp.cos(t125)
  t176 = f.my_piecewise3(t124, -t74 * t55 * t3 * t40 * t41 / 0.36e2, 0)
  t179 = t125 ** 2
  t180 = 0.1e1 / t179
  t181 = t126 * t180
  t184 = f.my_piecewise3(t81, t89 * t91 * t154 * t24 * t94 / 0.216e3 - t106 * t108 * t149 * t40 * t111 / 0.8640e4 + t118 / t67 / t153 / 0.53760e5, t170 * t176 * t127 - t181 * t176)
  t185 = t129 * t184
  t187 = 0.2e1 * t69 * t185
  t188 = -t147 + t152 + t187
  t192 = t143 * t64 * t188 * t135 * t137
  t198 = 0.1e1 / t30 / t153 * t22 * t38 * t43
  t202 = t59 ** 0.260e1
  t204 = t88 * t91
  t207 = 0.83527884012674580090917586884936888612525308619053e-3 * t198 / t63 / t62 * t133 * t202 * t204
  t208 = t59 ** 0.30e0
  t212 = 0.50095397700595218624223845313872824351784018872812e-1 * t198 * t134 * t208 * t204
  t213 = t35 ** 2
  t214 = 0.1e1 + t213
  t215 = 0.1e1 / t214
  t216 = 0.1e1 / t62
  t220 = 0.92609640138488888888888888888888888888888888888884e0 * t141 * t215 * t216 * t133
  t221 = t21 * t215
  t222 = t216 * t133
  t223 = 0.1e1 / t11
  t224 = t4 * t3
  t225 = t5 - t224
  t228 = f.my_piecewise3(t8, 0, 0.2e1 / 0.3e1 * t223 * t225)
  t229 = 0.1e1 / t16
  t230 = -t225
  t233 = f.my_piecewise3(t15, 0, 0.2e1 / 0.3e1 * t229 * t230)
  t235 = t228 / 0.2e1 + t233 / 0.2e1
  t236 = t222 * t235
  t237 = t221 * t236
  t239 = t22 * t215
  t240 = t216 * t188
  t241 = t239 * t240
  t244 = t38 * t40
  t245 = t30 * t22 * t244
  t246 = t41 * t28
  t248 = t245 * t246 * t240
  t251 = t56 * t22 * t244
  t254 = 0.12e2 * t65 * t68 * t131
  t257 = 0.32e2 * t144 * t149 * t131
  t259 = 0.16e2 * t145 * t185
  t262 = 0.20e2 * t66 * t120 * t131
  t264 = 0.16e2 * t150 * t185
  t265 = t184 ** 2
  t267 = 0.2e1 * t69 * t265
  t278 = t67 ** 2
  t283 = t176 ** 2
  t291 = f.my_piecewise3(t124, t74 * t55 * t154 * t40 * t41 / 0.18e2, 0)
  t304 = f.my_piecewise3(t81, -t89 * t91 * t68 * t24 * t94 / 0.72e2 + t106 * t108 * t120 * t40 * t111 / 0.1728e4 - t118 / t278 / 0.7680e4, -t126 * t283 * t127 + t170 * t291 * t127 - 0.2e1 * t170 * t283 * t180 + 0.2e1 * t126 / t179 / t125 * t283 - t181 * t291)
  t307 = 0.2e1 * t69 * t129 * t304
  t317 = t5 * t21 * t38 * t42 * t28 * t64
  t321 = t317 * t133 * t235 * t135 * t137
  t323 = t30 ** 2
  t329 = 0.4e1 / 0.27e2 / t323 * t22 * t244 * t246 * t222
  t331 = t30 * t21 * t244
  t333 = t331 * t246 * t236
  t336 = t56 * t21 * t244
  t342 = 0.1e1 / t11 / t7
  t343 = t225 ** 2
  t346 = t4 * t154
  t348 = -0.2e1 * t3 + 0.2e1 * t346
  t352 = f.my_piecewise3(t8, 0, -0.2e1 / 0.9e1 * t342 * t343 + 0.2e1 / 0.3e1 * t223 * t348)
  t354 = 0.1e1 / t16 / t14
  t355 = t230 ** 2
  t362 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t354 * t355 - 0.2e1 / 0.3e1 * t229 * t348)
  t368 = t214 ** 2
  t377 = 0.36778031659583040511111111111111111111111111111109e0 * t22 / t368 * t222 * t35 * t24 * t26 * t29 * t57
  t378 = t56 * t20
  t379 = t378 * t244
  t380 = t235 ** 2
  t391 = 0.20073966722509356988758591749343098182802235760644e-1 * t239 * t136 * t50 * t55 / t30 / t2
  d11 = t140 + 0.96337303270375420431199702526678508368815420909254e-2 * t192 + t207 - t212 + t220 + 0.41674338062319999999999999999999999999999999999998e1 * t237 + 0.13891446020773333333333333333333333333333333333333e1 * t241 + 0.8e1 / 0.9e1 * t248 + t251 * t246 * t216 * (-t254 + t257 + t259 - t262 - t264 + t267 + t307) / 0.3e1 + 0.28901190981112626129359910758003552510644626272776e-1 * t321 + t329 + 0.8e1 / 0.3e1 * t333 + 0.2e1 * t336 * t246 * t240 * t235 + t336 * t246 * t222 * (t352 / 0.2e1 + t362 / 0.2e1) + t377 + 0.2e1 * t379 * t246 * t222 * t380 + t391
  t392 = t147 + t152 + t187
  t393 = t216 * t392
  t395 = t245 * t246 * t393
  t401 = t239 * t393
  t404 = -t5 - t224
  t407 = f.my_piecewise3(t8, 0, 0.2e1 / 0.3e1 * t223 * t404)
  t408 = -t404
  t411 = f.my_piecewise3(t15, 0, 0.2e1 / 0.3e1 * t229 * t408)
  t413 = t407 / 0.2e1 + t411 / 0.2e1
  t424 = f.my_piecewise3(t8, 0, -0.2e1 / 0.9e1 * t342 * t404 * t225 + 0.4e1 / 0.3e1 * t223 * t4 * t154)
  t432 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t354 * t408 * t230 - 0.4e1 / 0.3e1 * t229 * t4 * t154)
  t439 = 0.4e1 / 0.9e1 * t395 + t336 * t246 * t393 * t235 + 0.69457230103866666666666666666666666666666666666663e0 * t241 + 0.69457230103866666666666666666666666666666666666663e0 * t401 + t329 + 0.4e1 / 0.3e1 * t333 + t336 * t246 * t240 * t413 + t336 * t246 * t222 * (t424 / 0.2e1 + t432 / 0.2e1) + t377 + t140 + 0.48168651635187710215599851263339254184407710454627e-2 * t192 + t207
  t443 = t143 * t64 * t392 * t135 * t137
  t445 = t222 * t413
  t446 = t221 * t445
  t455 = t133 * t413
  t458 = t317 * t455 * t135 * t137
  t462 = t331 * t246 * t445
  t471 = -t212 + 0.48168651635187710215599851263339254184407710454627e-2 * t443 + t220 + 0.20837169031159999999999999999999999999999999999999e1 * t446 + 0.20837169031159999999999999999999999999999999999999e1 * t237 + 0.4e1 / 0.9e1 * t248 + t251 * t246 * t216 * (t254 - t262 - t264 + t267 + t307) / 0.3e1 + 0.14450595490556313064679955379001776255322313136388e-1 * t458 + 0.14450595490556313064679955379001776255322313136388e-1 * t321 + 0.4e1 / 0.3e1 * t462 + 0.2e1 * t378 * t244 * t41 * t28 * t216 * t455 * t235 + t391
  d12 = t439 + t471
  t477 = t404 ** 2
  t481 = 0.2e1 * t3 + 0.2e1 * t346
  t485 = f.my_piecewise3(t8, 0, -0.2e1 / 0.9e1 * t342 * t477 + 0.2e1 / 0.3e1 * t223 * t481)
  t486 = t408 ** 2
  t493 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t354 * t486 - 0.2e1 / 0.3e1 * t229 * t481)
  t509 = t413 ** 2
  d22 = t329 + 0.8e1 / 0.3e1 * t462 + 0.2e1 * t336 * t246 * t393 * t413 + t336 * t246 * t222 * (t485 / 0.2e1 + t493 / 0.2e1) + t377 + 0.13891446020773333333333333333333333333333333333333e1 * t401 - t212 + t140 + 0.96337303270375420431199702526678508368815420909254e-2 * t443 + t207 + t220 + 0.41674338062319999999999999999999999999999999999998e1 * t446 + 0.8e1 / 0.9e1 * t395 + t251 * t246 * t216 * (-t254 - t257 - t259 - t262 - t264 + t267 + t307) / 0.3e1 + 0.28901190981112626129359910758003552510644626272776e-1 * t458 + 0.2e1 * t379 * t246 * t222 * t509 + t391
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = 3 ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / jnp.pi
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t20 * t22
  t24 = 4 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = t2 ** (0.1e1 / 0.3e1)
  t31 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t23 * t25 / t26
  t32 = t31 ** 2
  t33 = 0.1e1 + t32
  t34 = 0.1e1 / t33
  t35 = t19 * t34
  t36 = 6 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t38 = jnp.pi ** 2
  t39 = t38 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / t39
  t41 = t37 * t40
  t42 = 2 ** (0.1e1 / 0.3e1)
  t44 = s0 + 0.2e1 * s1 + s2
  t45 = jnp.sqrt(t44)
  t46 = t42 * t45
  t47 = t26 * t2
  t48 = 0.1e1 / t47
  t50 = t41 * t46 * t48
  t51 = t50 ** 0.230e1
  t53 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t51
  t54 = 0.1e1 / t53
  t55 = t1 ** 2
  t56 = t55 * t1
  t57 = t2 ** 2
  t58 = t57 ** 2
  t59 = 0.1e1 / t58
  t60 = t56 * t59
  t61 = jnp.pi ** (0.1e1 / 0.3e1)
  t63 = 9 ** (0.1e1 / 0.3e1)
  t65 = t61 * jnp.pi * t63 * t41
  t66 = t20 ** 2
  t68 = 0.1e1 / t22
  t72 = t65 * t46 * t3 * t66 * t68 / 0.36e2
  t73 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t74 = t72 <= t73
  t75 = t61 ** 2
  t77 = t63 ** 2
  t79 = t39 ** 2
  t80 = 0.1e1 / t79
  t81 = t36 * t80
  t82 = t75 * t38 * t77 * t81
  t83 = t42 ** 2
  t84 = t83 * t44
  t85 = 0.1e1 / t57
  t87 = t22 ** 2
  t88 = 0.1e1 / t87
  t93 = t38 ** 2
  t100 = t61 * t93 * jnp.pi * t63 * t37 / t39 / t38
  t101 = t44 ** 2
  t102 = t42 * t101
  t103 = t59 * t66
  t105 = 0.1e1 / t22 / t21
  t112 = t93 * t38 * t101 * t44
  t114 = 0.1e1 / t58 / t57
  t118 = t73 < t72
  t119 = f.my_piecewise3(t118, t72, t73)
  t120 = jnp.sin(t119)
  t121 = 0.1e1 / t119
  t123 = f.my_piecewise3(t74, 0.1e1 - t82 * t84 * t85 * t20 * t88 / 0.432e3 + t100 * t102 * t103 * t105 / 0.34560e5 - t112 * t114 / 0.322560e6, t120 * t121)
  t124 = t123 ** 2
  t125 = 0.1e1 - t124
  t128 = t55 ** 2
  t129 = t58 * t2
  t130 = 0.1e1 / t129
  t131 = t128 * t130
  t134 = t128 * t59
  t135 = t57 * t2
  t136 = 0.1e1 / t135
  t148 = 0.1e1 / t58 / t135
  t152 = jnp.cos(t119)
  t158 = f.my_piecewise3(t118, -t65 * t46 * t85 * t66 * t68 / 0.36e2, 0)
  t161 = t119 ** 2
  t162 = 0.1e1 / t161
  t163 = t120 * t162
  t166 = f.my_piecewise3(t74, t82 * t84 * t136 * t20 * t88 / 0.216e3 - t100 * t102 * t130 * t66 * t105 / 0.8640e4 + t112 * t148 / 0.53760e5, t152 * t158 * t121 - t163 * t158)
  t167 = t123 * t166
  t170 = 0.4e1 * t131 * t125 - 0.4e1 * t60 * t125 + 0.2e1 * t134 * t167
  t171 = t54 * t170
  t172 = 0.1e1 / t9
  t174 = -t1 * t85 + t3
  t177 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t172 * t174)
  t178 = 0.1e1 / t14
  t179 = -t174
  t182 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t178 * t179)
  t184 = t177 / 0.2e1 + t182 / 0.2e1
  t185 = t171 * t184
  t189 = -t134 * t125 + 0.1e1
  t190 = t54 * t189
  t192 = 0.1e1 / t9 / t5
  t193 = t174 ** 2
  t198 = 0.2e1 * t1 * t136 - 0.2e1 * t85
  t202 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t192 * t193 + 0.2e1 / 0.3e1 * t172 * t198)
  t204 = 0.1e1 / t14 / t12
  t205 = t179 ** 2
  t208 = -t198
  t212 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t204 * t205 + 0.2e1 / 0.3e1 * t178 * t208)
  t214 = t202 / 0.2e1 + t212 / 0.2e1
  t215 = t190 * t214
  t218 = t19 * t18
  t219 = t85 * t218
  t220 = t34 * t54
  t225 = t184 ** 2
  t226 = t190 * t225
  t229 = t3 * t218
  t234 = jnp.atan(t31)
  t236 = -0.655868e0 * t234 + 0.897889e0
  t238 = t66 * t68
  t239 = t53 ** 2
  t240 = 0.1e1 / t239
  t241 = t24 * t240
  t242 = t238 * t241
  t245 = t50 ** 0.130e1
  t247 = t41 * t46
  t256 = t40 * t42
  t258 = t256 * t45 * t184
  t262 = t3 * t19
  t264 = t262 * t236 * t242
  t271 = 0.1e1 / t26 / t135
  t273 = t271 * t19 * t236
  t275 = 0.1e1 / t239 / t53
  t276 = t24 * t275
  t279 = t50 ** 0.260e1
  t282 = t80 * t83
  t284 = t282 * t44 * t184
  t289 = t50 ** 0.30e0
  t295 = t189 * t214
  t300 = t33 ** 2
  t301 = 0.1e1 / t300
  t302 = t218 * t301
  t304 = t189 * t31
  t307 = t26 ** 2
  t315 = 0.12502301418696000000000000000000000000000000000000e2 * t35 * t185 + 0.62511507093479999999999999999999999999999999999997e1 * t35 * t215 - 0.61739760092325925925925925925925925925925925925923e0 * t219 * t220 * t189 + 0.12502301418695999999999999999999999999999999999999e2 * t18 * t34 * t226 + 0.27782892041546666666666666666666666666666666666665e1 * t229 * t220 * t170 + 0.86703572943337878388079732274010657531933878818328e-1 * t3 * t18 * t236 * t242 * t189 * t225 * t245 * t247 + 0.14450595490556313064679955379001776255322313136387e-1 * t85 * t19 * t236 * t242 * t189 * t245 * t37 * t258 + 0.86703572943337878388079732274010657531933878818328e-1 * t264 * t170 * t245 * t37 * t258 + 0.75175095611407122081825828196443199751272777757148e-2 * t273 * t238 * t276 * t189 * t279 * t36 * t284 - 0.45085857930535696761801460782485541916605616985531e0 * t273 * t242 * t189 * t289 * t36 * t284 + 0.43351786471668939194039866137005328765966939409164e-1 * t264 * t295 * t245 * t247 + 0.15943933753545239999873657513889437155348866673572e-1 * t302 * t240 * t304 * t23 * t25 / t307 / t135 * t245 * t247
  t318 = t236 * t66
  t320 = t68 * t24
  t321 = t320 * t190
  t324 = 0.1e1 / t307
  t338 = t55 * t59
  t341 = t56 * t130
  t346 = t128 * t114
  t351 = t166 ** 2
  t364 = t58 ** 2
  t369 = t158 ** 2
  t377 = f.my_piecewise3(t118, t65 * t46 * t136 * t66 * t68 / 0.18e2, 0)
  t378 = t152 * t377
  t384 = 0.1e1 / t161 / t119
  t385 = t120 * t384
  t390 = f.my_piecewise3(t74, -t82 * t84 * t59 * t20 * t88 / 0.72e2 + t100 * t102 * t114 * t66 * t105 / 0.1728e4 - t112 / t364 / 0.7680e4, -t120 * t369 * t121 - 0.2e1 * t152 * t369 * t162 + t378 * t121 - t163 * t377 + 0.2e1 * t385 * t369)
  t391 = t123 * t390
  t394 = -0.12e2 * t338 * t125 + 0.32e2 * t341 * t125 - 0.20e2 * t346 * t125 - 0.16e2 * t131 * t167 + 0.2e1 * t134 * t351 + 0.2e1 * t134 * t391 + 0.16e2 * t60 * t167
  t395 = t54 * t394
  t401 = t1 * t59
  t445 = t369 * t158
  t446 = t152 * t445
  t459 = f.my_piecewise3(t118, -t65 * t46 * t103 * t68 / 0.6e1, 0)
  t467 = t161 ** 2
  t477 = f.my_piecewise3(t74, t82 * t84 * t130 * t20 * t88 / 0.18e2 - t100 * t102 * t148 * t66 * t105 / 0.288e3 + t112 / t364 / t2 / 0.960e3, -t446 * t121 - 0.3e1 * t120 * t158 * t121 * t377 + 0.3e1 * t120 * t445 * t162 + t152 * t459 * t121 - 0.6e1 * t378 * t162 * t158 + 0.6e1 * t446 * t384 - 0.6e1 * t120 / t467 * t445 + 0.6e1 * t385 * t158 * t377 - t163 * t459)
  t481 = -0.240e3 * t56 * t114 * t125 + 0.2e1 * t134 * t123 * t477 + 0.120e3 * t128 * t148 * t125 + 0.144e3 * t55 * t130 * t125 + 0.6e1 * t134 * t166 * t390 - 0.24e2 * t401 * t125 - 0.24e2 * t131 * t351 - 0.24e2 * t131 * t391 + 0.72e2 * t338 * t167 - 0.192e3 * t341 * t167 + 0.120e3 * t346 * t167 + 0.24e2 * t60 * t351 + 0.24e2 * t60 * t391
  t489 = 0.1e1 / t307 / t57
  t494 = t47 * t18
  t501 = t47 * t19 * t318
  t506 = t5 ** 2
  t516 = 0.6e1 * t136 - 0.6e1 * t401
  t520 = f.my_piecewise3(t6, 0, 0.8e1 / 0.27e2 / t9 / t506 * t193 * t174 - 0.2e1 / 0.3e1 * t192 * t174 * t198 + 0.2e1 / 0.3e1 * t172 * t516)
  t521 = t12 ** 2
  t534 = f.my_piecewise3(t13, 0, 0.8e1 / 0.27e2 / t14 / t521 * t205 * t179 - 0.2e1 / 0.3e1 * t204 * t179 * t208 - 0.2e1 / 0.3e1 * t178 * t516)
  t551 = t26 * t19 * t318
  t556 = 0.1e1 / t26 / t57
  t557 = t556 * t218
  t564 = 0.2e1 * t47 * t225 * t184 * t318 * t321 + 0.4e1 / 0.9e1 * t324 * t218 * t318 * t320 * t171 - 0.8e1 / 0.81e2 / t307 / t2 * t218 * t318 * t321 + 0.4e1 / 0.3e1 * t26 * t218 * t318 * t320 * t395 + t47 * t218 * t318 * t320 * t54 * t481 / 0.3e1 - 0.38948389123222241425432970370370370370370370370367e0 * t302 * t190 * t66 * t87 * t24 * t489 + 0.6e1 * t494 * t318 * t320 * t171 * t225 + 0.3e1 * t501 * t320 * t171 * t214 + t501 * t320 * t190 * (t520 / 0.2e1 + t534 / 0.2e1) + 0.15579355649288896570173188148148148148148148148147e1 * t218 / t300 / t33 * t190 * t32 * t66 * t87 * t24 * t489 + 0.4e1 * t551 * t320 * t215 - 0.1e-49 * t557 * t301 * t54 * t304 * t23 * t25
  t570 = t31 * t20 * t22 * t25 * t48
  t578 = t190 * t184
  t594 = t318 * t68
  t605 = t34 * t240
  t608 = t245 * t37
  t610 = t608 * t256 * t45
  t615 = 0.1e1 / t307 / t58 * t218
  t620 = t282 * t44
  t624 = t605 * t189
  t630 = t271 * t218
  t634 = 0.11033409497874912153333333333333333333333333333333e1 * t302 * t171 * t570 + 0.8e1 * t551 * t320 * t185 + 0.4e1 / 0.3e1 * t324 * t19 * t318 * t320 * t578 + 0.3e1 * t501 * t320 * t395 * t184 + 0.8e1 * t26 * t18 * t318 * t320 * t226 + 0.20837169031159999999999999999999999999999999999999e1 * t218 * t34 * t395 + 0.6e1 * t494 * t594 * t24 * t54 * t295 * t184 + 0.33100228493624736459999999999999999999999999999998e1 * t19 * t301 * t578 * t570 + 0.60221900167528070966275775248029294548406707281934e-1 * t557 * t605 * t170 * t610 + 0.52214539139616816995802751158798165290639964649157e-2 * t615 * t34 * t275 * t189 * t279 * t36 * t620 - 0.31315388087114596902463403128975233165171487786605e0 * t615 * t624 * t289 * t36 * t620 - 0.30110950083764035483137887624014647274203353640966e-1 * t630 * t624 * t610
  t637 = t238 * t24
  t639 = t240 * t189
  t646 = t240 * t170
  t655 = 0.1e1 / t26 / t58 * t218 * t236 * t637
  t658 = t81 * t84
  t674 = t630 * t236 * t637
  t687 = 0.1e1 / t307 / t129 * t218 * t594
  t688 = t239 ** 2
  t692 = t50 ** 0.390e1
  t693 = 0.1e1 / t38
  t695 = t45 * t44
  t701 = t50 ** 0.160e1
  t708 = t50 ** (-0.70e0)
  t724 = -0.10704144807819491159022189169630945374312824545471e-2 * t136 * t218 * t236 * t637 * t639 * t245 * t247 + 0.48168651635187710215599851263339254184407710454624e-2 * t219 * t236 * t637 * t646 * t245 * t247 - 0.25058365203802374027275276065481066583757592585716e-2 * t655 * t275 * t189 * t279 * t658 + 0.15028619310178565587267153594161847305535205661843e0 * t655 * t639 * t289 * t658 + 0.14450595490556313064679955379001776255322313136388e-1 * t229 * t236 * t637 * t240 * t394 * t245 * t247 + 0.25058365203802374027275276065481066583757592585716e-2 * t674 * t275 * t170 * t279 * t658 - 0.15028619310178565587267153594161847305535205661843e0 * t674 * t646 * t289 * t658 + 0.43452995905773577549468091358629944725893789807942e-3 * t687 * t24 / t688 * t189 * t692 * t693 * t695 - 0.52121399623908937976732574216200618494215792578289e-1 * t687 * t276 * t189 * t701 * t693 * t695 + 0.24045790896285704939627445750658955688856329058950e0 * t687 * t241 * t189 * t708 * t693 * t695 + 0.18066570050258421289882732574408788364522012184580e0 * t35 * t639 * t184 * t608 * t40 * t46 * t556 + 0.83348676124639999999999999999999999999999999999996e1 * t262 * t34 * t578
  d111 = t315 + t564 + t634 + t724

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = 3 ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / jnp.pi
  t21 = t20 ** (0.1e1 / 0.3e1)
  t22 = t19 * t21
  t23 = 4 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t2 ** (0.1e1 / 0.3e1)
  t30 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t22 * t24 / t25
  t31 = t30 ** 2
  t32 = 0.1e1 + t31
  t33 = 0.1e1 / t32
  t34 = t18 * t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = jnp.pi ** 2
  t38 = t37 ** (0.1e1 / 0.3e1)
  t39 = 0.1e1 / t38
  t40 = t36 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t43 = s0 + 0.2e1 * s1 + s2
  t44 = jnp.sqrt(t43)
  t45 = t41 * t44
  t46 = t25 * t2
  t47 = 0.1e1 / t46
  t49 = t40 * t45 * t47
  t50 = t49 ** 0.230e1
  t52 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t50
  t53 = 0.1e1 / t52
  t55 = t1 ** 2
  t56 = t55 ** 2
  t57 = t2 ** 2
  t58 = t57 ** 2
  t59 = 0.1e1 / t58
  t60 = t56 * t59
  t61 = jnp.pi ** (0.1e1 / 0.3e1)
  t63 = 9 ** (0.1e1 / 0.3e1)
  t65 = t61 * jnp.pi * t63 * t40
  t66 = t19 ** 2
  t68 = 0.1e1 / t21
  t72 = t65 * t45 * t3 * t66 * t68 / 0.36e2
  t73 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t74 = t72 <= t73
  t75 = t61 ** 2
  t77 = t63 ** 2
  t79 = t38 ** 2
  t80 = 0.1e1 / t79
  t81 = t35 * t80
  t82 = t75 * t37 * t77 * t81
  t83 = t41 ** 2
  t84 = t83 * t43
  t85 = 0.1e1 / t57
  t87 = t21 ** 2
  t88 = 0.1e1 / t87
  t93 = t37 ** 2
  t100 = t61 * t93 * jnp.pi * t63 * t36 / t38 / t37
  t101 = t43 ** 2
  t102 = t41 * t101
  t103 = t59 * t66
  t105 = 0.1e1 / t21 / t20
  t112 = t93 * t37 * t101 * t43
  t113 = t58 * t57
  t114 = 0.1e1 / t113
  t118 = t73 < t72
  t119 = f.my_piecewise3(t118, t72, t73)
  t120 = jnp.sin(t119)
  t121 = 0.1e1 / t119
  t123 = f.my_piecewise3(t74, 0.1e1 - t82 * t84 * t85 * t19 * t88 / 0.432e3 + t100 * t102 * t103 * t105 / 0.34560e5 - t112 * t114 / 0.322560e6, t120 * t121)
  t124 = t123 ** 2
  t125 = 0.1e1 - t124
  t127 = -t60 * t125 + 0.1e1
  t129 = 0.1e1 / t9 / t5
  t131 = -t1 * t85 + t3
  t132 = t131 ** 2
  t135 = 0.1e1 / t9
  t136 = t57 * t2
  t137 = 0.1e1 / t136
  t140 = 0.2e1 * t1 * t137 - 0.2e1 * t85
  t144 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t129 * t132 + 0.2e1 / 0.3e1 * t135 * t140)
  t146 = 0.1e1 / t14 / t12
  t147 = -t131
  t148 = t147 ** 2
  t151 = 0.1e1 / t14
  t152 = -t140
  t156 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t146 * t148 + 0.2e1 / 0.3e1 * t151 * t152)
  t158 = t144 / 0.2e1 + t156 / 0.2e1
  t159 = t127 * t158
  t162 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t135 * t131)
  t165 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t151 * t147)
  t167 = t162 / 0.2e1 + t165 / 0.2e1
  t168 = t159 * t167
  t171 = t3 * t18
  t173 = t53 * t127
  t174 = t167 ** 2
  t175 = t173 * t174
  t178 = t18 ** 2
  t179 = t3 * t178
  t180 = t179 * t33
  t181 = t55 * t1
  t182 = t181 * t59
  t185 = t58 * t2
  t186 = 0.1e1 / t185
  t187 = t56 * t186
  t195 = t186 * t66
  t201 = 0.1e1 / t58 / t136
  t205 = jnp.cos(t119)
  t211 = f.my_piecewise3(t118, -t65 * t45 * t85 * t66 * t68 / 0.36e2, 0)
  t214 = t119 ** 2
  t215 = 0.1e1 / t214
  t216 = t120 * t215
  t219 = f.my_piecewise3(t74, t82 * t84 * t137 * t19 * t88 / 0.216e3 - t100 * t102 * t195 * t105 / 0.8640e4 + t112 * t201 / 0.53760e5, t205 * t211 * t121 - t216 * t211)
  t220 = t123 * t219
  t223 = -0.4e1 * t182 * t125 + 0.4e1 * t187 * t125 + 0.2e1 * t60 * t220
  t224 = t53 * t223
  t225 = t224 * t167
  t228 = t173 * t158
  t231 = t85 * t178
  t233 = t173 * t167
  t236 = jnp.atan(t30)
  t238 = -0.655868e0 * t236 + 0.897889e0
  t240 = t66 * t68
  t241 = t52 ** 2
  t242 = 0.1e1 / t241
  t243 = t23 * t242
  t244 = t240 * t243
  t245 = t171 * t238 * t244
  t246 = t49 ** 0.130e1
  t249 = t40 * t45
  t253 = t32 ** 2
  t254 = 0.1e1 / t253
  t255 = t178 * t254
  t257 = t127 * t167
  t258 = t30 * t19
  t261 = t21 * t24
  t262 = t25 ** 2
  t264 = 0.1e1 / t262 / t136
  t270 = t174 * t167
  t274 = t178 * t18
  t275 = t274 * t33
  t276 = t1 * t59
  t279 = t55 * t186
  t282 = t55 * t59
  t285 = t181 * t114
  t288 = t181 * t186
  t291 = t219 ** 2
  t304 = t58 ** 2
  t305 = 0.1e1 / t304
  t309 = t211 ** 2
  t310 = t120 * t309
  t317 = f.my_piecewise3(t118, t65 * t45 * t137 * t66 * t68 / 0.18e2, 0)
  t318 = t205 * t317
  t320 = t205 * t309
  t324 = 0.1e1 / t214 / t119
  t325 = t120 * t324
  t330 = f.my_piecewise3(t74, -t82 * t84 * t59 * t19 * t88 / 0.72e2 + t100 * t102 * t114 * t66 * t105 / 0.1728e4 - t112 * t305 / 0.7680e4, -t310 * t121 + t318 * t121 - 0.2e1 * t320 * t215 - t216 * t317 + 0.2e1 * t325 * t309)
  t331 = t123 * t330
  t334 = t56 * t201
  t337 = t56 * t114
  t344 = t219 * t330
  t362 = t309 * t211
  t363 = t205 * t362
  t365 = t120 * t211
  t366 = t121 * t317
  t376 = f.my_piecewise3(t118, -t65 * t45 * t103 * t68 / 0.6e1, 0)
  t377 = t205 * t376
  t379 = t215 * t211
  t384 = t214 ** 2
  t385 = 0.1e1 / t384
  t386 = t120 * t385
  t394 = f.my_piecewise3(t74, t82 * t84 * t186 * t19 * t88 / 0.18e2 - t100 * t102 * t201 * t66 * t105 / 0.288e3 + t112 / t304 / t2 / 0.960e3, 0.3e1 * t120 * t362 * t215 + 0.6e1 * t325 * t211 * t317 - t363 * t121 + t377 * t121 - t216 * t376 - 0.6e1 * t318 * t379 + 0.6e1 * t363 * t324 - 0.6e1 * t386 * t362 - 0.3e1 * t365 * t366)
  t395 = t123 * t394
  t398 = -0.24e2 * t276 * t125 + 0.144e3 * t279 * t125 - 0.240e3 * t285 * t125 + 0.120e3 * t334 * t125 + 0.24e2 * t182 * t291 + 0.24e2 * t182 * t331 - 0.24e2 * t187 * t291 - 0.24e2 * t187 * t331 + 0.72e2 * t282 * t220 - 0.192e3 * t288 * t220 + 0.120e3 * t337 * t220 + 0.6e1 * t60 * t344 + 0.2e1 * t60 * t395
  t399 = t53 * t398
  t403 = t238 * t66
  t405 = t68 * t23
  t406 = t405 * t224
  t409 = t274 * t254
  t411 = t66 * t87
  t413 = 0.1e1 / t262 / t57
  t418 = t201 * t274
  t419 = t241 ** 2
  t420 = 0.1e1 / t419
  t423 = t49 ** 0.390e1
  t425 = 0.1e1 / t37
  t426 = t44 * t43
  t427 = t425 * t426
  t431 = t33 * t242
  t433 = t49 ** (-0.70e0)
  t440 = t405 * t173
  t443 = 0.50009205674783999999999999999999999999999999999996e2 * t34 * t53 * t168 + 0.33339470449855999999999999999999999999999999999998e2 * t171 * t33 * t175 + 0.33339470449855999999999999999999999999999999999998e2 * t180 * t225 + 0.16669735224927999999999999999999999999999999999999e2 * t180 * t228 - 0.74087712110791111111111111111111111111111111111108e1 * t231 * t33 * t233 + 0.34681429177335151355231892909604263012773551527332e0 * t245 * t159 * t167 * t246 * t249 + 0.19132720504254287999848389016667324586418640008287e0 * t255 * t242 * t257 * t258 * t261 * t264 * t246 * t249 + 0.16669735224927999999999999999999999999999999999999e2 * t270 * t33 * t173 + 0.27782892041546666666666666666666666666666666666665e1 * t275 * t399 + 0.8e1 * t46 * t270 * t403 * t406 - 0.15579355649288896570173188148148148148148148148147e1 * t409 * t224 * t411 * t23 * t413 + 0.36217496823956298542271086247545499737960666077495e-2 * t418 * t33 * t420 * t127 * t423 * t427 + 0.20041848375753342017576578002544149225709752183427e1 * t418 * t431 * t127 * t433 * t427 + 0.40e2 / 0.243e3 * t413 * t274 * t403 * t440
  t452 = t330 ** 2
  t481 = t309 ** 2
  t482 = t205 * t481
  t485 = t317 ** 2
  t492 = t120 * t481
  t520 = f.my_piecewise3(t118, 0.2e1 / 0.3e1 * t65 * t45 * t195 * t68, 0)
  t524 = 0.18e2 * t310 * t215 * t317 + 0.36e2 * t318 * t324 * t309 - 0.6e1 * t320 * t366 + 0.4e1 * t482 * t215 - 0.3e1 * t120 * t485 * t121 - 0.4e1 * t365 * t121 * t376 - 0.12e2 * t492 * t324 - 0.8e1 * t377 * t379 - 0.6e1 * t205 * t485 * t215 - 0.24e2 * t482 * t385 + 0.24e2 * t120 / t384 / t119 * t481 - 0.36e2 * t386 * t309 * t317 + 0.6e1 * t325 * t485 + 0.8e1 * t325 * t211 * t376 + t492 * t121 + t205 * t520 * t121 - t216 * t520
  t525 = f.my_piecewise3(t74, -0.5e1 / 0.18e2 * t82 * t84 * t114 * t19 * t88 + 0.7e1 / 0.288e3 * t100 * t102 * t305 * t66 * t105 - 0.3e1 / 0.320e3 * t112 / t304 / t57, t524)
  t529 = t1 * t186
  t546 = -0.1440e4 * t55 * t114 * t125 + 0.2e1 * t60 * t123 * t525 + 0.1920e4 * t181 * t201 * t125 + 0.8e1 * t60 * t219 * t394 + 0.384e3 * t529 * t125 - 0.32e2 * t187 * t395 + 0.192e3 * t276 * t220 - 0.1152e4 * t279 * t220 + 0.144e3 * t282 * t291 + 0.144e3 * t282 * t331 + 0.6e1 * t60 * t452
  t570 = -0.840e3 * t56 * t305 * t125 - 0.24e2 * t59 * t125 + 0.96e2 * t182 * t344 + 0.32e2 * t182 * t395 - 0.96e2 * t187 * t344 + 0.1920e4 * t285 * t220 - 0.960e3 * t334 * t220 - 0.384e3 * t288 * t291 - 0.384e3 * t288 * t331 + 0.240e3 * t337 * t291 + 0.240e3 * t337 * t331
  t576 = 0.1e1 / t262
  t593 = -0.12e2 * t282 * t125 + 0.32e2 * t288 * t125 - 0.20e2 * t337 * t125 + 0.16e2 * t182 * t220 - 0.16e2 * t187 * t220 + 0.2e1 * t60 * t291 + 0.2e1 * t60 * t331
  t594 = t53 * t593
  t599 = 0.1e1 / t262 / t2
  t605 = 0.1e1 / t241 / t52
  t606 = t33 * t605
  t608 = t49 ** 0.160e1
  t619 = t25 * t178 * t403
  t620 = t594 * t167
  t625 = 0.1e1 / t25 / t57
  t627 = t254 * t53
  t630 = t22 * t24
  t635 = t46 * t178 * t403
  t640 = t5 ** 2
  t642 = 0.1e1 / t9 / t640
  t646 = t129 * t131
  t650 = 0.6e1 * t137 - 0.6e1 * t276
  t654 = f.my_piecewise3(t6, 0, 0.8e1 / 0.27e2 * t642 * t132 * t131 - 0.2e1 / 0.3e1 * t646 * t140 + 0.2e1 / 0.3e1 * t135 * t650)
  t655 = t12 ** 2
  t657 = 0.1e1 / t14 / t655
  t661 = t146 * t147
  t664 = -t650
  t668 = f.my_piecewise3(t13, 0, 0.8e1 / 0.27e2 * t657 * t148 * t147 - 0.2e1 / 0.3e1 * t661 * t152 + 0.2e1 / 0.3e1 * t151 * t664)
  t670 = t654 / 0.2e1 + t668 / 0.2e1
  t676 = t576 * t178 * t403
  t677 = t405 * t228
  t683 = t87 * t23 * t413
  t688 = 0.1e1 / t25 / t136
  t689 = t688 * t274
  t695 = t46 * t18
  t696 = t695 * t403
  t705 = 0.32e2 / 0.3e1 * t25 * t270 * t403 * t440 + t46 * t274 * t403 * t405 * t53 * (t546 + t570) / 0.3e1 + 0.8e1 / 0.9e1 * t576 * t274 * t403 * t405 * t594 - 0.32e2 / 0.81e2 * t599 * t274 * t403 * t406 - 0.43442496564161191740507888964120073521812450588099e0 * t418 * t606 * t127 * t608 * t427 + 0.10386237099525931046782125432098765432098765432098e1 * t409 * t173 * t411 * t23 * t264 + 0.16e2 * t619 * t405 * t620 - 0.1e-48 * t625 * t274 * t627 * t223 * t30 * t630 + 0.6e1 * t635 * t405 * t594 * t158 + 0.4e1 * t635 * t405 * t224 * t670 + 0.8e1 / 0.3e1 * t676 * t677 - 0.46738066947866689710519564444444444444444444444440e1 * t255 * t173 * t167 * t66 * t683 - 0.32691583697407147120987654320987654320987654320984e0 * t689 * t627 * t127 * t30 * t630 + 0.12e2 * t696 * t405 * t594 * t174 + 0.4e1 * t635 * t405 * t399 * t167
  t709 = t258 * t261 * t47
  t715 = t158 ** 2
  t724 = t173 * t670
  t728 = t25 * t18
  t730 = t224 * t174
  t734 = t264 * t274
  t736 = 0.1e1 / t253 / t32
  t739 = t127 * t31
  t744 = t274 * t736
  t747 = t31 * t66 * t683
  t753 = t132 ** 2
  t759 = t140 ** 2
  t765 = -0.24e2 * t59 + 0.24e2 * t529
  t769 = f.my_piecewise3(t6, 0, -0.56e2 / 0.81e2 / t9 / t640 / t5 * t753 + 0.16e2 / 0.9e1 * t642 * t132 * t140 - 0.2e1 / 0.3e1 * t129 * t759 - 0.8e1 / 0.9e1 * t646 * t650 + 0.2e1 / 0.3e1 * t135 * t765)
  t773 = t148 ** 2
  t779 = t152 ** 2
  t788 = f.my_piecewise3(t13, 0, -0.56e2 / 0.81e2 / t14 / t655 / t12 * t773 + 0.16e2 / 0.9e1 * t657 * t148 * t152 - 0.2e1 / 0.3e1 * t146 * t779 - 0.8e1 / 0.9e1 * t661 * t664 - 0.2e1 / 0.3e1 * t151 * t765)
  t804 = t224 * t158
  t813 = 0.1e1 / t25 / t58
  t814 = t813 * t274
  t815 = t431 * t127
  t817 = t246 * t36
  t818 = t39 * t41
  t819 = t818 * t44
  t820 = t817 * t819
  t823 = t403 * t68
  t824 = t695 * t823
  t825 = t23 * t53
  t826 = t223 * t158
  t831 = 0.22066818995749824306666666666666666666666666666666e1 * t409 * t594 * t709 + 0.16e2 / 0.3e1 * t676 * t405 * t225 + 0.6e1 * t696 * t405 * t173 * t715 + 0.12e2 * t46 * t174 * t403 * t677 + 0.16e2 / 0.3e1 * t619 * t405 * t724 + 0.32e2 * t728 * t403 * t405 * t730 - 0.41544948398103724187128501728395061728395061728392e1 * t734 * t736 * t53 * t739 * t411 * t23 + 0.62317422597155586280692752592592592592592592592589e1 * t744 * t224 * t747 + t635 * t405 * t173 * (t769 / 0.2e1 + t788 / 0.2e1) + 0.16e2 / 0.3e1 * t576 * t18 * t403 * t405 * t175 - 0.32e2 / 0.27e2 * t599 * t178 * t403 * t405 * t233 + 0.16e2 * t619 * t405 * t804 + 0.13240091397449894583999999999999999999999999999999e2 * t18 * t254 * t175 * t709 + 0.89217629877819364394482629997080436368009936713973e-1 * t814 * t815 * t820 + 0.24e2 * t824 * t825 * t826 * t167
  t832 = t127 * t670
  t847 = t242 * t593
  t848 = t847 * t246
  t850 = t45 * t625
  t854 = t431 * t223
  t859 = 0.1e1 / t262 / t185
  t860 = t859 * t274
  t861 = t606 * t127
  t863 = t49 ** 0.260e1
  t864 = t863 * t35
  t865 = t80 * t83
  t866 = t865 * t43
  t867 = t864 * t866
  t871 = t49 ** 0.30e0
  t872 = t871 * t35
  t873 = t872 * t866
  t877 = 0.1e1 / t262 / t58
  t878 = t877 * t274
  t897 = t240 * t23
  t898 = t859 * t178 * t238 * t897
  t899 = t605 * t127
  t901 = t427 * t167
  t905 = t242 * t127
  t915 = 0.8e1 * t824 * t825 * t832 * t167 + 0.13240091397449894584000000000000000000000000000000e2 * t255 * t225 * t709 + 0.66200456987249472919999999999999999999999999999996e1 * t255 * t228 * t709 + 0.18695226779146675884207825777777777777777777777776e2 * t178 * t736 * t233 * t747 + 0.12044380033505614193255155049605858909681341456387e0 * t275 * t848 * t40 * t850 - 0.12044380033505614193255155049605858909681341456387e0 * t689 * t854 * t820 - 0.34809692759744544663868500772532110193759976432772e-1 * t860 * t861 * t867 + 0.20876925391409731268308935419316822110114325191070e1 * t860 * t815 * t873 + 0.20885815655846726798321100463519266116255985859664e-1 * t878 * t606 * t223 * t867 - 0.12526155234845838760985361251590093266068595114642e1 * t878 * t854 * t873 - 0.3e-49 * t255 * t233 * t258 * t261 * t625 + 0.32e2 * t728 * t823 * t825 * t168 - 0.62545679548690725572079089059440742193058951093948e0 * t898 * t899 * t608 * t901 + 0.28854949075542845927552934900790746826627594870740e1 * t898 * t905 * t433 * t901 + 0.52143595086928293059361709630355933671072547769531e-2 * t898 * t420 * t127 * t423 * t901
  t919 = t814 * t238 * t897
  t920 = t242 * t223
  t922 = t81 * t84
  t926 = t137 * t274
  t937 = 0.1e1 / t25 / t185 * t274 * t238 * t897
  t950 = t905 * t246 * t249
  t964 = t23 * t186 * t246 * t249
  t967 = t3 * t274
  t976 = t689 * t238 * t897
  t986 = t85 * t274
  t997 = t33 * t53
  t1001 = t178 * t33
  t1004 = 0.60114477240714262349068614376647389222140822647372e0 * t919 * t920 * t871 * t922 - 0.42816579231277964636088756678523781497251298181885e-2 * t926 * t238 * t897 * t920 * t246 * t249 + 0.10673007401619529678283913879741935767156011656879e-1 * t937 * t899 * t863 * t922 - 0.64010785950760557130952691234393053338390690781924e0 * t937 * t905 * t871 * t922 + 0.17840241346365818598370315282718242290521374242450e-2 * t59 * t274 * t238 * t897 * t950 + 0.11560476392445050451743964303201421004257850509110e0 * t3 * t270 * t238 * t897 * t950 - 0.22513096649138714957101602331979891445208043257780e-1 * t409 * t242 * t127 * t66 * t87 * t964 + 0.19267460654075084086239940505335701673763084181851e-1 * t967 * t238 * t897 * t242 * t398 * t246 * t249 + 0.50116730407604748054550552130962133167515185171432e-2 * t976 * t605 * t593 * t863 * t922 - 0.30057238620357131174534307188323694611070411323687e0 * t976 * t847 * t871 * t922 + 0.96337303270375420431199702526678508368815420909254e-2 * t986 * t238 * t897 * t848 * t249 - 0.10023346081520949610910110426192426633503037034286e-1 * t919 * t605 * t223 * t863 * t922 - 0.24695904036930370370370370370370370370370370370369e1 * t986 * t997 * t223 + 0.25004602837392000000000000000000000000000000000000e2 * t1001 * t620
  t1018 = t179 * t238 * t244
  t1026 = t127 * t174
  t1032 = t231 * t238 * t244
  t1036 = t818 * t44 * t167
  t1041 = t813 * t178 * t238
  t1042 = t23 * t605
  t1043 = t240 * t1042
  t1046 = t127 * t863 * t35
  t1048 = t865 * t43 * t167
  t1054 = t127 * t871 * t35
  t1063 = t688 * t178
  t1064 = t1063 * t238
  t1065 = t1064 * t1043
  t1071 = t1064 * t244
  t1082 = t305 * t274 * t238
  t1088 = t49 ** 0.520e1
  t1092 = t101 * t36 * t818
  t1096 = 0.50009205674783999999999999999999999999999999999998e2 * t34 * t730 + 0.25004602837392000000000000000000000000000000000000e2 * t1001 * t804 + 0.83348676124639999999999999999999999999999999999996e1 * t1001 * t724 + 0.55565784083093333333333333333333333333333333333330e1 * t967 * t997 * t593 + 0.10289960015387654320987654320987654320987654320988e1 * t926 * t997 * t127 + 0.57802381962225252258719821516007105021289252545552e-1 * t1018 * t832 * t246 * t249 + 0.57802381962225252258719821516007105021289252545546e-1 * t85 * t18 * t238 * t244 * t1026 * t246 * t249 + 0.57802381962225252258719821516007105021289252545546e-1 * t1032 * t223 * t246 * t36 * t1036 - 0.30070038244562848832730331278577279900509111102859e-1 * t1041 * t1043 * t1046 * t1048 + 0.18034343172214278704720584312994216766642246794213e1 * t1041 * t244 * t1054 * t1048 + 0.17340714588667575677615946454802131506386775763666e0 * t1018 * t593 * t246 * t36 * t1036 + 0.30070038244562848832730331278577279900509111102860e-1 * t1065 * t223 * t863 * t35 * t1048 - 0.18034343172214278704720584312994216766642246794212e1 * t1071 * t223 * t871 * t35 * t1048 + 0.17340714588667575677615946454802131506386775763665e0 * t1018 * t826 * t246 * t249 + 0.25116866667485343760775012216103398485399359246411e-4 * t1082 * t240 * t23 / t419 / t52 * t127 * t1088 * t425 * t1092
  t1098 = t23 * t420
  t1101 = t49 ** 0.290e1
  t1108 = t49 ** 0.60e0
  t1115 = t49 ** (-0.170e1)
  t1122 = t688 * t18 * t238
  t1141 = t865 * t43 * t158
  t1163 = t258 * t261
  t1164 = t819 * t1163
  t1173 = t114 * t274 * t254
  t1176 = t866 * t1163
  t1188 = -0.45191115742004520651446815012975142514929541400259e-2 * t1082 * t240 * t1098 * t127 * t1101 * t425 * t1092 + 0.11814183914752692608059383489005473525355579651079e0 * t1082 * t1043 * t127 * t1108 * t425 * t1092 + 0.22442738169866657943652282700615025309599240455020e0 * t1082 * t244 * t127 * t1115 * t425 * t1092 + 0.30070038244562848832730331278577279900509111102860e-1 * t1122 * t1043 * t1026 * t863 * t922 - 0.18034343172214278704720584312994216766642246794212e1 * t1122 * t244 * t1026 * t871 * t922 + 0.28901190981112626129359910758003552510644626272775e-1 * t1032 * t127 * t246 * t36 * t818 * t44 * t158 + 0.15035019122281424416365165639288639950254555551430e-1 * t1065 * t1046 * t1141 - 0.90171715861071393523602921564971083833211233971062e0 * t1071 * t1054 * t1141 + 0.90052386596554859828406409327919565780832173031118e-1 * t744 * t242 * t739 * t411 * t964 - 0.12844973769383389390826627003557134449175389454564e-1 * t137 * t178 * t238 * t244 * t257 * t246 * t249 - 0.74405024183211119999410401731484040058294711143336e-1 * t878 * t254 * t905 * t817 * t1164 + 0.63775735014180959999494630055557748621395466694290e-1 * t734 * t254 * t920 * t817 * t1164 + 0.55295840928170264472631395044431548886826307123020e-2 * t1173 * t899 * t864 * t1176 - 0.33163382207374099199737207628890029283125642681030e0 * t1173 * t905 * t872 * t1176 + 0.34681429177335151355231892909604263012773551527332e0 * t245 * t223 * t174 * t246 * t249
  t1190 = t817 * t39
  t1192 = t1190 * t45 * t167
  t1199 = t877 * t178
  t1202 = t84 * t167
  t1206 = t860 * t823
  t1209 = t423 * t425 * t426
  t1215 = t608 * t425 * t426
  t1221 = t433 * t425 * t426
  t1227 = t1190 * t850
  t1237 = 0.1e1 / t262 / t113 * t274 * t823
  t1261 = t253 ** 2
  t1276 = -0.36133140100516842579765465148817576729044024369160e0 * t1063 * t815 * t1192 + 0.72266280201033685159530930297635153458088048738321e0 * t625 * t178 * t854 * t1192 + 0.62657446967540180394963301390557798348767957578988e-1 * t1199 * t861 * t864 * t80 * t1202 + 0.17381198362309431019787236543451977890357515923177e-2 * t1206 * t1098 * t223 * t1209 - 0.20848559849563575190693029686480247397686317031316e0 * t1206 * t1042 * t223 * t1215 + 0.96183163585142819758509783002635822755425316235796e0 * t1206 * t243 * t223 * t1221 + 0.36133140100516842579765465148817576729044024369160e0 * t1001 * t905 * t158 * t1227 + 0.72266280201033685159530930297635153458088048738319e0 * t34 * t905 * t174 * t1227 - 0.37659263118337100542872345844145952095774617833550e-2 * t1237 * t1098 * t127 * t1209 + 0.45171879674054412913168230987373869361653686901184e0 * t1237 * t1042 * t127 * t1215 - 0.20839685443447610947677119650571094930342151851090e1 * t1237 * t243 * t127 * t1221 - 0.37578465704537516282956083754770279798205785343926e1 * t1199 * t815 * t872 * t80 * t1202 - 0.14848856800184954427783994546388444444444444444443e2 * t744 * t53 * t127 * t20 * t59 * t30 + 0.29697713600369908855567989092776888888888888888887e2 * t274 / t1261 * t53 * t127 * t31 * t30 * t20 * t59 + 0.16e2 / 0.9e1 * t25 * t274 * t403 * t405 * t399
  d1111 = t443 + t705 + t831 + t915 + t1004 + t1096 + t1188 + t1276

  res = {'v4rho4': d1111}
  return res
