"""Generated from gga_c_sg4.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha = 0.8

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  sg4_b0 = 3 * 0.262 / jnp.pi ** 2

  sg4_sigma = 0.07

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mbeta = lambda rs, t: sg4_b0 + sg4_sigma * t * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha = 0.8

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  sg4_b0 = 3 * 0.262 / jnp.pi ** 2

  sg4_sigma = 0.07

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mbeta = lambda rs, t: sg4_b0 + sg4_sigma * t * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha = 0.8

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  sg4_b0 = 3 * 0.262 / jnp.pi ** 2

  sg4_sigma = 0.07

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mbeta = lambda rs, t: sg4_b0 + sg4_sigma * t * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = t43 ** 2
  t88 = t45 ** 2
  t89 = f.my_piecewise3(t42, t87, t88)
  t90 = t50 ** 2
  t91 = f.my_piecewise3(t49, t87, t90)
  t93 = t89 / 0.2e1 + t91 / 0.2e1
  t95 = s0 + 0.2e1 * s1 + s2
  t96 = jnp.sqrt(t95)
  t97 = t96 * t95
  t98 = t97 * t37
  t99 = t93 ** 2
  t100 = t99 * t93
  t101 = 0.1e1 / t100
  t103 = 0.1e1 / t14 / t11
  t104 = t101 * t103
  t107 = t93 ** (0.50000000000000000000000000000000000000000000000000e-1 * t98 * t104)
  t108 = jnp.log(0.2e1)
  t109 = 0.1e1 - t108
  t110 = t107 * t109
  t111 = jnp.pi ** 2
  t112 = 0.1e1 / t111
  t116 = 0.1e1 / t8 / t7
  t118 = t54 ** 2
  t119 = t96 * t116 * t118
  t120 = 0.1e1 / t93
  t121 = 0.1e1 / t14
  t124 = jnp.exp(-t25 / 0.4e1)
  t125 = 0.1e1 - t124
  t126 = t120 * t121 * t125
  t129 = 0.786e0 * t112 + 0.17500000000000000000000000000000000000000000000000e-1 * t119 * t126
  t131 = 0.1e1 / t8 / t35
  t132 = t95 * t131
  t134 = 0.1e1 / t99
  t136 = 0.1e1 / t3
  t138 = t134 * t19 * t136 * t5
  t141 = 0.1e1 / t109
  t142 = t129 * t141
  t144 = (-t31 + t84 + t86) * t141
  t145 = t111 * t101
  t147 = jnp.exp(-t144 * t145)
  t148 = t147 - 0.1e1
  t149 = 0.1e1 / t148
  t150 = t111 * t149
  t151 = t95 ** 2
  t152 = t150 * t151
  t153 = t142 * t152
  t155 = 0.1e1 / t22 / t36
  t157 = t99 ** 2
  t158 = 0.1e1 / t157
  t160 = 0.1e1 / t20
  t162 = t1 * t160 * t6
  t163 = t155 * t118 * t158 * t162
  t166 = t132 * t54 * t138 / 0.96e2 + t153 * t163 / 0.3072e4
  t167 = t129 * t166
  t168 = t141 * t111
  t169 = t150 * t166
  t171 = t142 * t169 + 0.1e1
  t173 = t168 / t171
  t175 = t167 * t173 + 0.1e1
  t176 = jnp.log(t175)
  t177 = t112 * t100 * t176
  t178 = t110 * t177
  t179 = t6 * t116
  t182 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t179 * t30
  t183 = t27 ** 2
  t187 = t3 * t6
  t188 = t187 * t116
  t189 = t121 * t1 * t188
  t191 = t4 * t179
  t193 = t11 ** 0.5e0
  t195 = t193 * t1 * t188
  t200 = t21 * t5 / t22 / t7
  t205 = t13 / t183 * (-0.39359271665000000000000000000000000000000000000000e-1 * t189 - 0.18590165886666666666666666666666666666666666666667e-1 * t191 - 0.63665980925000000000000000000000000000000000000000e-2 * t195 - 0.51086165526666666666666666666666666666666666666667e-2 * t200) / t29
  t209 = 0.4e1 * t33 * t32 * t37 * t83
  t210 = t36 * t7
  t211 = 0.1e1 / t210
  t214 = 0.4e1 * t34 * t211 * t83
  t216 = t32 / t35
  t217 = t39 - t216
  t220 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t217)
  t221 = -t217
  t224 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t221)
  t226 = (t220 + t224) * t57
  t228 = t38 * t226 * t82
  t232 = t65 ** 2
  t246 = t76 ** 2
  t247 = 0.1e1 / t246
  t253 = -0.29149603883333333333333333333333333333333333333333e-1 * t189 - 0.10197154565000000000000000000000000000000000000000e-1 * t191 - 0.18581078242500000000000000000000000000000000000000e-2 * t195 - 0.27959640330000000000000000000000000000000000000000e-2 * t200
  t254 = 0.1e1 / t78
  t260 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t179 * t68 + t60 / t232 * (-0.36580540352500000000000000000000000000000000000000e-1 * t189 - 0.16057569282500000000000000000000000000000000000000e-1 * t191 - 0.65410946462500000000000000000000000000000000000000e-2 * t195 - 0.32394954865000000000000000000000000000000000000000e-2 * t200) / t67 - t182 - t205 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t179 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t247 * t253 * t254)
  t262 = 0.58482236226346462072622386637590534819724553404281e0 * t226 * t80
  t267 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t187 * t116 * t79
  t272 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t247 * t253 * t254
  t275 = 0.20000000000000000000000000000000000000000000000000e0 * t97 * t211 * t104
  t276 = t158 * t103
  t277 = 0.1e1 / t45
  t280 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t277 * t217)
  t281 = 0.1e1 / t50
  t284 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t281 * t221)
  t286 = t280 / 0.2e1 + t284 / 0.2e1
  t288 = t98 * t276 * t286
  t300 = 0.62500000000000000000000000000000000000000000000000e-2 * t97 / t8 / t210 * t101 / t14 / t25 * t1 * t187
  t302 = jnp.log(t93)
  t309 = t110 * t112
  t310 = t99 * t176
  t317 = 0.23333333333333333333333333333333333333333333333333e-1 * t96 * t131 * t118 * t126
  t318 = t134 * t121
  t326 = t118 * t120
  t332 = 0.29166666666666666666666666666666666666666666666667e-2 * t96 / t22 / t35 * t326 * t103 * t125 * t4 * t6
  t333 = t35 * t7
  t342 = 0.29166666666666666666666666666666666666666666666667e-2 * t96 / t333 * t326 * t121 * t19 * t20 * t5 * t124
  t343 = -t317 - 0.17500000000000000000000000000000000000000000000000e-1 * t119 * t318 * t125 * t286 + t332 - t342
  t351 = 0.7e1 / 0.288e3 * t95 / t8 / t333 * t54 * t138
  t353 = t132 * t54 * t101
  t354 = t19 * t136
  t359 = t343 * t141
  t363 = t142 * t111
  t364 = t148 ** 2
  t365 = 0.1e1 / t364
  t368 = t363 * t365 * t151 * t155
  t370 = t118 * t158 * t1
  t371 = t160 * t6
  t375 = t111 * t158
  t380 = (-(t182 + t205 + t209 - t214 + t228 + t260 + t262 - t267 - t272) * t141 * t145 + 0.3e1 * t144 * t375 * t286) * t147
  t391 = 0.7e1 / 0.4608e4 * t153 / t22 / t210 * t118 * t158 * t162
  t394 = t363 * t149 * t151 * t155
  t396 = 0.1e1 / t157 / t93
  t398 = t118 * t396 * t1
  t403 = -t351 - t353 * t354 * t5 * t286 / 0.48e2 + t359 * t152 * t163 / 0.3072e4 - t368 * t370 * t371 * t380 / 0.3072e4 - t391 - t394 * t398 * t371 * t286 / 0.768e3
  t406 = t167 * t141
  t407 = t171 ** 2
  t409 = t111 / t407
  t411 = t365 * t166
  t421 = 0.1e1 / t175
  t424 = t182 + t205 + t209 - t214 + t228 + t260 + t262 - t267 - t272 + t107 * ((-t275 - 0.15000000000000000000000000000000000000000000000000e0 * t288 + t300) * t302 + 0.50000000000000000000000000000000000000000000000000e-1 * t288) * t109 * t177 + 0.3e1 * t309 * t310 * t286 + t309 * t100 * (t343 * t166 * t173 + t129 * t403 * t173 - t406 * t409 * (t142 * t150 * t403 - t363 * t411 * t380 + t359 * t169)) * t421
  vrho_0_ = t7 * t424 + t178 - t31 + t84 + t86
  t426 = -t39 - t216
  t429 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t426)
  t430 = -t426
  t433 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t430)
  t435 = (t429 + t433) * t57
  t437 = t38 * t435 * t82
  t439 = 0.58482236226346462072622386637590534819724553404281e0 * t435 * t80
  t442 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t277 * t426)
  t445 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t281 * t430)
  t447 = t442 / 0.2e1 + t445 / 0.2e1
  t449 = t98 * t276 * t447
  t465 = -t317 - 0.17500000000000000000000000000000000000000000000000e-1 * t119 * t318 * t125 * t447 + t332 - t342
  t472 = t465 * t141
  t483 = (-(t182 + t205 - t209 - t214 + t437 + t260 + t439 - t267 - t272) * t141 * t145 + 0.3e1 * t144 * t375 * t447) * t147
  t492 = -t351 - t353 * t354 * t5 * t447 / 0.48e2 + t472 * t152 * t163 / 0.3072e4 - t368 * t370 * t371 * t483 / 0.3072e4 - t391 - t394 * t398 * t371 * t447 / 0.768e3
  t507 = t182 + t205 - t209 - t214 + t437 + t260 + t439 - t267 - t272 + t107 * ((-t275 - 0.15000000000000000000000000000000000000000000000000e0 * t449 + t300) * t302 + 0.50000000000000000000000000000000000000000000000000e-1 * t449) * t109 * t177 + 0.3e1 * t309 * t310 * t447 + t309 * t100 * (t465 * t166 * t173 + t129 * t492 * t173 - t406 * t409 * (t142 * t150 * t492 - t363 * t411 * t483 + t472 * t169)) * t421
  vrho_1_ = t7 * t507 + t178 - t31 + t84 + t86
  t515 = t107 * t96 * t37 * t103 * t302 * t109 * t112 * t176
  t520 = 0.1e1 / t96 * t116 * t326 * t121
  t523 = t520 * t125 * t166 * t173
  t528 = t131 * t54 * t134 * t354 * t5
  t539 = t97 / t36 / t35 * t54 * t396 * t121 * t125 * t168 * t149 * t162
  t543 = t142 * t150 * t95 * t163
  t545 = t528 / 0.96e2 + 0.56966145833333333333333333333333333333333333333333e-5 * t539 + t543 / 0.1536e4
  t550 = t520 * t125 * t141 * t169
  vsigma_0_ = t7 * (0.75000000000000000000000000000000000000000000000000e-1 * t515 + t309 * t100 * (0.87500000000000000000000000000000000000000000000000e-2 * t523 + t129 * t545 * t173 - t406 * t409 * (0.87500000000000000000000000000000000000000000000000e-2 * t550 + t142 * t150 * t545)) * t421)
  t567 = t528 / 0.48e2 + 0.11393229166666666666666666666666666666666666666667e-4 * t539 + t543 / 0.768e3
  vsigma_1_ = t7 * (0.15000000000000000000000000000000000000000000000000e0 * t515 + t309 * t100 * (0.17500000000000000000000000000000000000000000000000e-1 * t523 + t129 * t567 * t173 - t406 * t409 * (0.17500000000000000000000000000000000000000000000000e-1 * t550 + t142 * t150 * t567)) * t421)
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha = 0.8

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  sg4_b0 = 3 * 0.262 / jnp.pi ** 2

  sg4_sigma = 0.07

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mbeta = lambda rs, t: sg4_b0 + sg4_sigma * t * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = t32 ** 2
  t56 = f.my_piecewise3(t31, t55, 1)
  t57 = jnp.sqrt(s0)
  t58 = t57 * s0
  t59 = r0 ** 2
  t60 = t59 ** 2
  t61 = 0.1e1 / t60
  t63 = t56 ** 2
  t64 = t63 * t56
  t65 = 0.1e1 / t64
  t67 = 0.1e1 / t13 / t10
  t68 = t65 * t67
  t71 = t56 ** (0.50000000000000000000000000000000000000000000000000e-1 * t58 * t61 * t68)
  t72 = jnp.log(0.2e1)
  t73 = 0.1e1 - t72
  t74 = t71 * t73
  t75 = jnp.pi ** 2
  t76 = 0.1e1 / t75
  t80 = 0.1e1 / t7 / r0
  t82 = t37 ** 2
  t84 = 0.1e1 / t56
  t85 = 0.1e1 / t13
  t88 = jnp.exp(-t24 / 0.4e1)
  t89 = 0.1e1 - t88
  t90 = t84 * t85 * t89
  t93 = 0.786e0 * t76 + 0.17500000000000000000000000000000000000000000000000e-1 * t57 * t80 * t82 * t90
  t95 = 0.1e1 / t7 / t59
  t98 = 0.1e1 / t63
  t100 = 0.1e1 / t3
  t102 = t98 * t18 * t100 * t5
  t105 = 0.1e1 / t73
  t106 = t93 * t105
  t111 = jnp.exp(-(-t30 + t54) * t105 * t75 * t65)
  t112 = t111 - 0.1e1
  t113 = 0.1e1 / t112
  t114 = t75 * t113
  t115 = s0 ** 2
  t116 = t114 * t115
  t117 = t106 * t116
  t119 = 0.1e1 / t21 / t60
  t121 = t63 ** 2
  t122 = 0.1e1 / t121
  t124 = 0.1e1 / t19
  t126 = t1 * t124 * t6
  t127 = t119 * t82 * t122 * t126
  t130 = s0 * t95 * t37 * t102 / 0.96e2 + t117 * t127 / 0.3072e4
  t131 = t93 * t130
  t132 = t105 * t75
  t133 = t114 * t130
  t135 = t106 * t133 + 0.1e1
  t137 = t132 / t135
  t139 = t131 * t137 + 0.1e1
  t140 = jnp.log(t139)
  t143 = t6 * t80
  t146 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t143 * t29
  t147 = t26 ** 2
  t151 = t3 * t6
  t152 = t151 * t80
  t153 = t85 * t1 * t152
  t155 = t4 * t143
  t157 = t10 ** 0.5e0
  t159 = t157 * t1 * t152
  t164 = t20 * t5 / t21 / r0
  t169 = t12 / t147 * (-0.39359271665000000000000000000000000000000000000000e-1 * t153 - 0.18590165886666666666666666666666666666666666666667e-1 * t155 - 0.63665980925000000000000000000000000000000000000000e-2 * t159 - 0.51086165526666666666666666666666666666666666666667e-2 * t164) / t28
  t174 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t151 * t80 * t51
  t176 = t48 ** 2
  t187 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t176 * (-0.29149603883333333333333333333333333333333333333333e-1 * t153 - 0.10197154565000000000000000000000000000000000000000e-1 * t155 - 0.18581078242500000000000000000000000000000000000000e-2 * t159 - 0.27959640330000000000000000000000000000000000000000e-2 * t164) / t50
  t188 = t60 * r0
  t206 = jnp.log(t56)
  t212 = t74 * t76
  t220 = t82 * t84
  t227 = t59 * r0
  t237 = -0.23333333333333333333333333333333333333333333333333e-1 * t57 * t95 * t82 * t90 + 0.29166666666666666666666666666666666666666666666667e-2 * t57 / t21 / t59 * t220 * t67 * t89 * t4 * t6 - 0.29166666666666666666666666666666666666666666666667e-2 * t57 / t227 * t220 * t85 * t18 * t19 * t5 * t88
  t246 = t237 * t105
  t250 = t73 ** 2
  t252 = t93 / t250
  t253 = t75 ** 2
  t255 = t112 ** 2
  t256 = 0.1e1 / t255
  t265 = t146 + t169 - t174 - t187
  t278 = -0.7e1 / 0.288e3 * s0 / t7 / t227 * t37 * t102 + t246 * t116 * t127 / 0.3072e4 + t252 * t253 * t256 * t115 * t119 * t82 / t121 / t64 * t1 * t124 * t6 * t265 * t111 / 0.3072e4 - 0.7e1 / 0.4608e4 * t117 / t21 / t188 * t82 * t122 * t126
  t281 = t131 * t105
  t282 = t135 ** 2
  t284 = t75 / t282
  t299 = 0.1e1 / t139
  vrho_0_ = -t30 + t54 + t74 * t76 * t64 * t140 + r0 * (t146 + t169 - t174 - t187 + t71 * (-0.20000000000000000000000000000000000000000000000000e0 * t58 / t188 * t68 + 0.62500000000000000000000000000000000000000000000000e-2 * t58 / t7 / t188 * t65 / t13 / t24 * t1 * t151) * t206 * t73 * t76 * t64 * t140 + t212 * t64 * (t237 * t130 * t137 + t93 * t278 * t137 - t281 * t284 * (t252 * t253 * t256 * t130 * t265 * t65 * t111 + t106 * t114 * t278 + t246 * t133)) * t299)
  t315 = 0.1e1 / t57 * t80 * t220 * t85
  t343 = t95 * t37 * t98 * t18 * t100 * t5 / 0.96e2 + 0.56966145833333333333333333333333333333333333333333e-5 * t58 / t60 / t59 * t37 / t121 / t56 * t85 * t89 * t132 * t113 * t126 + t106 * t114 * s0 * t127 / 0.1536e4
  vsigma_0_ = r0 * (0.75000000000000000000000000000000000000000000000000e-1 * t71 * t57 * t61 * t67 * t206 * t73 * t76 * t140 + t212 * t64 * (0.87500000000000000000000000000000000000000000000000e-2 * t315 * t89 * t130 * t137 + t93 * t343 * t137 - t281 * t284 * (0.87500000000000000000000000000000000000000000000000e-2 * t315 * t89 * t105 * t133 + t106 * t114 * t343)) * t299)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t40 = 0.1e1 / t14
  t41 = t40 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = t63 ** 2
  t103 = f.my_piecewise3(t62, t102, 1)
  t104 = jnp.sqrt(s0)
  t105 = t104 * s0
  t106 = r0 ** 2
  t107 = t106 ** 2
  t108 = 0.1e1 / t107
  t110 = t103 ** 2
  t111 = t110 * t103
  t112 = 0.1e1 / t111
  t114 = 0.1e1 / t14 / t13
  t115 = t112 * t114
  t118 = t103 ** (0.50000000000000000000000000000000000000000000000000e-1 * t105 * t108 * t115)
  t119 = t107 * r0
  t120 = 0.1e1 / t119
  t125 = 0.1e1 / t7 / t119
  t130 = 0.1e1 / t14 / t25 / 0.4e1
  t132 = t130 * t1 * t42
  t135 = -0.20000000000000000000000000000000000000000000000000e0 * t105 * t120 * t115 + 0.25000000000000000000000000000000000000000000000000e-1 * t105 * t125 * t112 * t132
  t136 = t118 * t135
  t137 = jnp.log(t103)
  t139 = jnp.log(0.2e1)
  t140 = 0.1e1 - t139
  t141 = jnp.pi ** 2
  t142 = 0.1e1 / t141
  t143 = t140 * t142
  t146 = t68 ** 2
  t148 = 0.1e1 / t103
  t149 = t148 * t40
  t151 = jnp.exp(-t25 / 0.4e1)
  t152 = 0.1e1 - t151
  t153 = t149 * t152
  t156 = 0.786e0 * t142 + 0.17500000000000000000000000000000000000000000000000e-1 * t104 * t9 * t146 * t153
  t158 = 0.1e1 / t7 / t106
  t161 = 0.1e1 / t110
  t163 = 0.1e1 / t3
  t165 = t161 * t19 * t163 * t5
  t168 = 0.1e1 / t140
  t169 = t156 * t168
  t179 = jnp.exp(-(-0.621814e-1 * t36 * t31 + 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82) * t168 * t141 * t112)
  t180 = t179 - 0.1e1
  t181 = 0.1e1 / t180
  t182 = t141 * t181
  t183 = s0 ** 2
  t184 = t182 * t183
  t185 = t169 * t184
  t187 = 0.1e1 / t22 / t107
  t189 = t110 ** 2
  t190 = 0.1e1 / t189
  t192 = 0.1e1 / t20
  t194 = t1 * t192 * t6
  t195 = t187 * t146 * t190 * t194
  t198 = s0 * t158 * t68 * t165 / 0.96e2 + t185 * t195 / 0.3072e4
  t199 = t156 * t198
  t200 = t168 * t141
  t201 = t182 * t198
  t203 = t169 * t201 + 0.1e1
  t204 = 0.1e1 / t203
  t205 = t200 * t204
  t207 = t199 * t205 + 0.1e1
  t208 = jnp.log(t207)
  t210 = t143 * t111 * t208
  t214 = t118 * t140 * t142
  t220 = 0.1e1 / t22 / t106
  t222 = t146 * t148
  t225 = t4 * t6
  t226 = t114 * t152 * t225
  t229 = t106 * r0
  t230 = 0.1e1 / t229
  t234 = t20 * t5
  t235 = t234 * t151
  t236 = t40 * t19 * t235
  t239 = -0.23333333333333333333333333333333333333333333333333e-1 * t104 * t158 * t146 * t153 + 0.29166666666666666666666666666666666666666666666667e-2 * t104 * t220 * t222 * t226 - 0.29166666666666666666666666666666666666666666666667e-2 * t104 * t230 * t222 * t236
  t240 = t239 * t198
  t243 = 0.1e1 / t7 / t229
  t248 = t239 * t168
  t249 = t248 * t184
  t252 = t140 ** 2
  t253 = 0.1e1 / t252
  t254 = t156 * t253
  t255 = t141 ** 2
  t256 = t254 * t255
  t257 = t180 ** 2
  t258 = 0.1e1 / t257
  t259 = t258 * t183
  t260 = t259 * t187
  t261 = t256 * t260
  t265 = t146 / t189 / t111 * t1
  t266 = t192 * t6
  t271 = 0.11073470983333333333333333333333333333333333333333e-2 * t33 + 0.10000000000000000000000000000000000000000000000000e1 * t60 - 0.18311447306006545054854346104378990962041954983034e-3 * t85 - 0.58482236226346462072622386637590534819724553404280e0 * t100
  t273 = t266 * t271 * t179
  t274 = t265 * t273
  t278 = 0.1e1 / t22 / t119
  t281 = t278 * t146 * t190 * t194
  t284 = -0.7e1 / 0.288e3 * s0 * t243 * t68 * t165 + t249 * t195 / 0.3072e4 + t261 * t274 / 0.3072e4 - 0.7e1 / 0.4608e4 * t185 * t281
  t285 = t156 * t284
  t287 = t199 * t168
  t288 = t203 ** 2
  t290 = t141 / t288
  t292 = t255 * t258
  t293 = t254 * t292
  t294 = t198 * t271
  t295 = t112 * t179
  t296 = t294 * t295
  t298 = t182 * t284
  t300 = t169 * t298 + t248 * t201 + t293 * t296
  t301 = t290 * t300
  t303 = t240 * t205 + t285 * t205 - t287 * t301
  t305 = 0.1e1 / t207
  t309 = t6 * t158
  t312 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t309 * t31
  t316 = 0.35616666666666666666666666666666666666666666666666e-1 * t225 * t9 * t38 * t59
  t320 = t57 ** 2
  t323 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t320 * t58
  t325 = t234 * t220
  t326 = t114 * t19 * t325
  t328 = t42 * t158
  t329 = t41 * t328
  t331 = t4 * t309
  t333 = t13 ** (-0.5e0)
  t335 = t333 * t19 * t325
  t337 = t49 * t328
  t340 = t21 * t5 * t220
  t345 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t326 + 0.84396666666666666666666666666666666666666666666666e0 * t329 + 0.39862222222222222222222222222222222222222222222223e0 * t331 + 0.68258333333333333333333333333333333333333333333333e-1 * t335 + 0.13651666666666666666666666666666666666666666666667e0 * t337 + 0.13692777777777777777777777777777777777777777777778e0 * t340) * t58
  t346 = t37 ** 2
  t349 = t30 ** 2
  t353 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t346 * t320 / t349
  t357 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t158 * t82
  t361 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t364 = t96 ** 2
  t368 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t364 * t98
  t379 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t326 + 0.11507777777777777777777777777777777777777777777778e1 * t329 + 0.40256666666666666666666666666666666666666666666667e0 * t331 + 0.36677500000000000000000000000000000000000000000000e-1 * t335 + 0.73355000000000000000000000000000000000000000000000e-1 * t337 + 0.13797500000000000000000000000000000000000000000000e0 * t340) * t98
  t380 = t90 ** 2
  t383 = t81 ** 2
  t387 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t380 * t364 / t383
  t388 = t135 ** 2
  t390 = t137 ** 2
  t393 = t107 * t106
  t394 = 0.1e1 / t393
  t395 = t105 * t394
  t405 = 0.1e1 / t22 / t393
  t421 = t137 * t140
  t422 = t136 * t421
  t423 = t142 * t111
  t439 = t104 * t108 * t222
  t448 = 0.1e1 / t7 / t107
  t451 = t148 * t114
  t464 = 0.54444444444444444444444444444444444444444444444444e-1 * t104 * t243 * t146 * t153 - 0.11666666666666666666666666666666666666666666666667e-1 * t104 / t22 / t229 * t222 * t226 + 0.12638888888888888888888888888888888888888888888889e-1 * t439 * t236 + 0.58333333333333333333333333333333333333333333333334e-2 * t439 * t130 * t152 * t21 * t5 - 0.11666666666666666666666666666666666666666666666667e-1 * t104 * t448 * t146 * t451 * t2 * t151 - 0.14583333333333333333333333333333333333333333333334e-2 * t104 * t187 * t222 * t41 * t3 * t2 * t6 * t151
  t470 = t240 * t168
  t477 = t464 * t168
  t481 = t239 * t253
  t490 = t156 / t252 / t140
  t491 = t255 * t141
  t492 = t490 * t491
  t494 = 0.1e1 / t257 / t180
  t498 = t189 ** 2
  t502 = t146 / t498 / t110 * t1
  t503 = t271 ** 2
  t504 = t179 ** 2
  t514 = -t312 - t316 - t323 + t345 + t353 + t357 + t361 + t368 - t379 - t387
  t531 = 0.35e2 / 0.432e3 * s0 * t448 * t68 * t165 + t477 * t184 * t195 / 0.3072e4 + t481 * t255 * t260 * t274 / 0.1536e4 - 0.7e1 / 0.2304e4 * t249 * t281 + t492 * t494 * t183 * t187 * t502 * t266 * t503 * t504 / 0.1536e4 - 0.7e1 / 0.2304e4 * t256 * t259 * t278 * t274 + t261 * t265 * t266 * t514 * t179 / 0.3072e4 - t492 * t260 * t502 * t266 * t503 * t179 / 0.3072e4 + 0.119e3 / 0.13824e5 * t185 * t405 * t146 * t190 * t194
  t534 = t285 * t168
  t539 = t141 / t288 / t203
  t540 = t300 ** 2
  t552 = t198 * t503
  t554 = 0.1e1 / t189 / t110
  t580 = t303 ** 2
  t582 = t207 ** 2
  t583 = 0.1e1 / t582
  t586 = -t312 - t316 - t323 + t345 + t353 + t357 + t361 + t368 - t379 - t387 + t118 * t388 * t390 * t210 + t118 * (0.10000000000000000000000000000000000000000000000000e1 * t395 * t115 - 0.23333333333333333333333333333333333333333333333333e0 * t105 / t7 / t393 * t112 * t132 + 0.17361111111111111111111111111111111111111111111111e-2 * t105 * t405 * t112 / t14 / t2 * r0 * t19 * t234) * t137 * t210 + 0.2e1 * t422 * t423 * t303 * t305 + t214 * t111 * (t464 * t198 * t205 + 0.2e1 * t239 * t284 * t205 - 0.2e1 * t470 * t301 + t156 * t531 * t205 - 0.2e1 * t534 * t301 + 0.2e1 * t287 * t539 * t540 - t287 * t290 * (-t490 * t491 * t258 * t552 * t554 * t179 + 0.2e1 * t490 * t491 * t494 * t552 * t554 * t504 + t293 * t198 * t514 * t295 + 0.2e1 * t293 * t284 * t271 * t295 + t169 * t182 * t531 + 0.2e1 * t481 * t292 * t296 + t477 * t201 + 0.2e1 * t248 * t298)) * t305 - t214 * t111 * t580 * t583
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t136 * t137 * t210 + 0.2e1 * t214 * t111 * t303 * t305 + r0 * t586
  t588 = t118 * t104
  t589 = t108 * t114
  t590 = t588 * t589
  t592 = t421 * t142 * t208
  t595 = 0.1e1 / t104
  t596 = t595 * t9
  t597 = t222 * t40
  t598 = t596 * t597
  t599 = t152 * t198
  t600 = t599 * t205
  t606 = t19 * t163 * t5
  t609 = t395 * t68
  t611 = 0.1e1 / t189 / t103
  t613 = t611 * t40 * t152
  t615 = t200 * t181
  t616 = t615 * t194
  t619 = t182 * s0
  t620 = t169 * t619
  t623 = t158 * t68 * t161 * t606 / 0.96e2 + 0.56966145833333333333333333333333333333333333333333e-5 * t609 * t613 * t616 + t620 * t195 / 0.1536e4
  t624 = t156 * t623
  t626 = t152 * t168
  t627 = t626 * t201
  t630 = t182 * t623
  t632 = 0.87500000000000000000000000000000000000000000000000e-2 * t598 * t627 + t169 * t630
  t633 = t290 * t632
  t635 = 0.87500000000000000000000000000000000000000000000000e-2 * t598 * t600 + t624 * t205 - t287 * t633
  t636 = t111 * t635
  t641 = t143 * t208
  t664 = t595 * t158 * t597
  t670 = t595 * t220 * t146 * t451 * t152
  t671 = t198 * t168
  t681 = t595 * t230 * t146 * t149 * t19
  t691 = t599 * t168
  t701 = t107 * t229
  t702 = 0.1e1 / t701
  t746 = -0.7e1 / 0.288e3 * t243 * t68 * t161 * t606 - 0.34179687500000000000000000000000000000000000000000e-4 * t105 * t702 * t68 * t613 * t616 + 0.37977430555555555555555555555555555555555555555555e-5 * t105 / t7 / t701 * t68 * t611 * t114 * t152 * t615 * t606 - 0.11393229166666666666666666666666666666666666666667e-4 * t105 / t22 / t701 * t68 * t611 * t40 * t151 * t615 + 0.56966145833333333333333333333333333333333333333333e-5 * t609 / t498 * t40 * t152 * t253 * t292 * t1 * t273 + t248 * t619 * t195 / 0.1536e4 + t256 * t258 * s0 * t187 * t274 / 0.1536e4 - 0.7e1 / 0.2304e4 * t620 * t281
  t749 = t624 * t168
  t791 = -0.11666666666666666666666666666666666666666666666667e-1 * t664 * t600 + 0.14583333333333333333333333333333333333333333333333e-2 * t670 * t671 * t141 * t204 * t1 * t42 - 0.14583333333333333333333333333333333333333333333333e-2 * t681 * t235 * t671 * t141 * t204 + 0.87500000000000000000000000000000000000000000000000e-2 * t598 * t152 * t284 * t205 - 0.87500000000000000000000000000000000000000000000000e-2 * t598 * t691 * t301 + t239 * t623 * t205 + t156 * t746 * t205 - t749 * t301 - t470 * t633 - t534 * t633 + 0.2e1 * t287 * t539 * t632 * t300 - t287 * t290 * (-0.11666666666666666666666666666666666666666666666667e-1 * t664 * t627 + 0.14583333333333333333333333333333333333333333333333e-2 * t670 * t615 * t198 * t1 * t42 - 0.14583333333333333333333333333333333333333333333333e-2 * t681 * t235 * t200 * t181 * t198 + 0.87500000000000000000000000000000000000000000000000e-2 * t596 * t146 * t190 * t40 * t152 * t253 * t255 * t258 * t294 * t179 + 0.87500000000000000000000000000000000000000000000000e-2 * t598 * t626 * t298 + t248 * t630 + t293 * t623 * t271 * t295 + t169 * t182 * t746)
  v2rhosigma_0_ = 0.75000000000000000000000000000000000000000000000000e-1 * t590 * t592 + t214 * t636 * t305 + r0 * (0.75000000000000000000000000000000000000000000000000e-1 * t136 * t390 * t104 * t589 * t641 - 0.30000000000000000000000000000000000000000000000000e0 * t588 * t120 * t114 * t592 + 0.37500000000000000000000000000000000000000000000000e-1 * t588 * t125 * t130 * t137 * t641 * t225 + 0.75000000000000000000000000000000000000000000000000e-1 * t590 * t421 * t142 * t303 * t305 + t422 * t423 * t635 * t305 + t214 * t111 * t791 * t305 - t214 * t636 * t583 * t303)
  t819 = 0.1e1 / t105 * t9 * t597
  t840 = 0.19938151041666666666666666666666666666666666666667e-4 * t104 * t394 * t68 * t613 * t616 + t169 * t182 * t187 * t146 * t190 * t194 / 0.1536e4
  t845 = t632 ** 2
  t863 = t635 ** 2
  v2sigma2_0_ = r0 * (0.11718750000000000000000000000000000000000000000000e-3 * t118 * s0 * t702 * t112 * t2 * t390 * t140 * t208 + 0.37500000000000000000000000000000000000000000000000e-1 * t118 * t595 * t589 * t592 + 0.15000000000000000000000000000000000000000000000000e0 * t590 * t421 * t142 * t635 * t305 + t214 * t111 * (-0.43750000000000000000000000000000000000000000000000e-2 * t819 * t600 + 0.17500000000000000000000000000000000000000000000000e-1 * t598 * t152 * t623 * t205 - 0.17500000000000000000000000000000000000000000000000e-1 * t598 * t691 * t633 + t156 * t840 * t205 - 0.2e1 * t749 * t633 + 0.2e1 * t287 * t539 * t845 - t287 * t290 * (-0.43750000000000000000000000000000000000000000000000e-2 * t819 * t627 + 0.17500000000000000000000000000000000000000000000000e-1 * t598 * t626 * t630 + t169 * t182 * t840)) * t305 - t214 * t111 * t863 * t583)
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t12 * t28
  t31 = 0.1e1 / t13 / t10
  t32 = t31 * t18
  t33 = t19 * t5
  t34 = r0 ** 2
  t36 = 0.1e1 / t21 / t34
  t37 = t33 * t36
  t38 = t32 * t37
  t40 = 0.1e1 / t13
  t41 = t40 * t1
  t42 = t3 * t6
  t44 = 0.1e1 / t7 / t34
  t45 = t42 * t44
  t46 = t41 * t45
  t48 = t6 * t44
  t49 = t4 * t48
  t51 = t10 ** (-0.5e0)
  t52 = t51 * t18
  t53 = t52 * t37
  t55 = t10 ** 0.5e0
  t56 = t55 * t1
  t57 = t56 * t45
  t60 = t20 * t5 * t36
  t62 = -0.42198333333333333333333333333333333333333333333333e0 * t38 + 0.84396666666666666666666666666666666666666666666666e0 * t46 + 0.39862222222222222222222222222222222222222222222223e0 * t49 + 0.68258333333333333333333333333333333333333333333333e-1 * t53 + 0.13651666666666666666666666666666666666666666666667e0 * t57 + 0.13692777777777777777777777777777777777777777777778e0 * t60
  t65 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t26
  t66 = 0.1e1 / t65
  t67 = t62 * t66
  t68 = t29 * t67
  t70 = t27 ** 2
  t71 = 0.1e1 / t70
  t72 = t12 * t71
  t74 = 0.1e1 / t7 / r0
  t75 = t42 * t74
  t76 = t41 * t75
  t78 = t6 * t74
  t79 = t4 * t78
  t81 = t56 * t75
  t86 = t20 * t5 / t21 / r0
  t88 = -0.63297500000000000000000000000000000000000000000000e0 * t76 - 0.29896666666666666666666666666666666666666666666667e0 * t79 - 0.10238750000000000000000000000000000000000000000000e0 * t81 - 0.82156666666666666666666666666666666666666666666667e-1 * t86
  t89 = t88 ** 2
  t90 = t65 ** 2
  t91 = 0.1e1 / t90
  t92 = t89 * t91
  t93 = t72 * t92
  t96 = 0.1e1 / t27 / t26
  t97 = t12 * t96
  t98 = t89 * t66
  t99 = t97 * t98
  t101 = jnp.log(t65)
  t103 = t4 * t48 * t101
  t105 = 0.1e1 <= f.p.zeta_threshold
  t106 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t107 = t106 ** 2
  t108 = f.my_piecewise3(t105, t107, 1)
  t109 = jnp.sqrt(s0)
  t110 = t109 * s0
  t111 = t34 ** 2
  t112 = 0.1e1 / t111
  t114 = t108 ** 2
  t115 = t114 * t108
  t116 = 0.1e1 / t115
  t117 = t116 * t31
  t120 = t108 ** (0.50000000000000000000000000000000000000000000000000e-1 * t110 * t112 * t117)
  t121 = t111 * r0
  t122 = 0.1e1 / t121
  t127 = 0.1e1 / t7 / t121
  t132 = 0.1e1 / t13 / t24 / 0.4e1
  t133 = t132 * t1
  t134 = t133 * t42
  t137 = -0.20000000000000000000000000000000000000000000000000e0 * t110 * t122 * t117 + 0.25000000000000000000000000000000000000000000000000e-1 * t110 * t127 * t116 * t134
  t138 = t137 ** 2
  t139 = t120 * t138
  t140 = jnp.log(t108)
  t141 = t140 ** 2
  t143 = jnp.log(0.2e1)
  t144 = 0.1e1 - t143
  t145 = jnp.pi ** 2
  t146 = 0.1e1 / t145
  t150 = 2 ** (0.1e1 / 0.3e1)
  t151 = t150 ** 2
  t153 = 0.1e1 / t108
  t154 = t153 * t40
  t156 = jnp.exp(-t24 / 0.4e1)
  t157 = 0.1e1 - t156
  t158 = t154 * t157
  t161 = 0.786e0 * t146 + 0.17500000000000000000000000000000000000000000000000e-1 * t109 * t74 * t151 * t158
  t168 = 0.1e1 / t114 * t18 / t3 * t5
  t171 = 0.1e1 / t144
  t172 = t161 * t171
  t176 = f.my_piecewise3(t105, t106 * f.p.zeta_threshold, 1)
  t182 = (0.2e1 * t176 - 0.2e1) / (0.2e1 * t150 - 0.2e1)
  t184 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t189 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t192 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t189
  t193 = jnp.log(t192)
  t201 = jnp.exp(-(-0.621814e-1 * t12 * t101 + 0.19751673498613801407483339618206552048944131217655e-1 * t182 * t184 * t193) * t171 * t145 * t116)
  t202 = t201 - 0.1e1
  t204 = t145 / t202
  t205 = s0 ** 2
  t206 = t204 * t205
  t207 = t172 * t206
  t209 = 0.1e1 / t21 / t111
  t210 = t209 * t151
  t211 = t114 ** 2
  t212 = 0.1e1 / t211
  t214 = 0.1e1 / t19
  t216 = t1 * t214 * t6
  t217 = t210 * t212 * t216
  t220 = s0 * t44 * t150 * t168 / 0.96e2 + t207 * t217 / 0.3072e4
  t221 = t161 * t220
  t223 = t204 * t220
  t225 = t172 * t223 + 0.1e1
  t227 = t171 * t145 / t225
  t229 = t221 * t227 + 0.1e1
  t230 = jnp.log(t229)
  t232 = t144 * t146 * t115 * t230
  t235 = t111 * t34
  t236 = 0.1e1 / t235
  t241 = 0.1e1 / t7 / t235
  t247 = 0.1e1 / t21 / t235
  t254 = 0.1e1 / t13 / t2 * r0 / 0.48e2
  t256 = t254 * t18 * t33
  t259 = 0.10000000000000000000000000000000000000000000000000e1 * t110 * t236 * t117 - 0.23333333333333333333333333333333333333333333333333e0 * t110 * t241 * t116 * t134 + 0.83333333333333333333333333333333333333333333333333e-1 * t110 * t247 * t116 * t256
  t260 = t120 * t259
  t264 = t4 * t6
  t265 = t74 * t28
  t266 = t88 * t66
  t268 = t264 * t265 * t266
  t270 = t182 * t1
  t273 = t270 * t42 * t44 * t193
  t275 = t182 * t184
  t276 = t189 ** 2
  t278 = 0.1e1 / t276 / t189
  t283 = -0.86308333333333333333333333333333333333333333333334e0 * t76 - 0.30192500000000000000000000000000000000000000000000e0 * t79 - 0.55016250000000000000000000000000000000000000000000e-1 * t81 - 0.82785000000000000000000000000000000000000000000000e-1 * t86
  t284 = t283 ** 2
  t286 = 0.1e1 / t192
  t287 = t278 * t284 * t286
  t288 = t275 * t287
  t290 = 0.1e1 / t276
  t297 = -0.57538888888888888888888888888888888888888888888889e0 * t38 + 0.11507777777777777777777777777777777777777777777778e1 * t46 + 0.40256666666666666666666666666666666666666666666667e0 * t49 + 0.36677500000000000000000000000000000000000000000000e-1 * t53 + 0.73355000000000000000000000000000000000000000000000e-1 * t57 + 0.13797500000000000000000000000000000000000000000000e0 * t60
  t299 = t290 * t297 * t286
  t300 = t275 * t299
  t302 = t276 ** 2
  t303 = 0.1e1 / t302
  t305 = t192 ** 2
  t306 = 0.1e1 / t305
  t307 = t303 * t284 * t306
  t308 = t275 * t307
  t311 = t120 * t144 * t146
  t317 = t151 * t153
  t320 = t31 * t157 * t264
  t323 = t34 * r0
  t328 = t33 * t156
  t329 = t40 * t18 * t328
  t332 = -0.23333333333333333333333333333333333333333333333333e-1 * t109 * t44 * t151 * t158 + 0.29166666666666666666666666666666666666666666666667e-2 * t109 * t36 * t317 * t320 - 0.29166666666666666666666666666666666666666666666667e-2 * t109 / t323 * t317 * t329
  t333 = t332 * t220
  t336 = 0.1e1 / t7 / t323
  t341 = t332 * t171
  t342 = t341 * t206
  t345 = t144 ** 2
  t346 = 0.1e1 / t345
  t347 = t161 * t346
  t348 = t145 ** 2
  t349 = t347 * t348
  t350 = t202 ** 2
  t351 = 0.1e1 / t350
  t352 = t351 * t205
  t353 = t352 * t209
  t354 = t349 * t353
  t358 = t151 / t211 / t115 * t1
  t359 = t214 * t6
  t370 = t290 * t283 * t286
  t373 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t78 * t101 + 0.10000000000000000000000000000000000000000000000000e1 * t29 * t266 - 0.18311447306006545054854346104378990962041954983034e-3 * t270 * t42 * t74 * t193 - 0.58482236226346462072622386637590534819724553404280e0 * t275 * t370
  t374 = t373 * t201
  t376 = t358 * t359 * t374
  t380 = 0.1e1 / t21 / t121
  t383 = t380 * t151 * t212 * t216
  t386 = -0.7e1 / 0.288e3 * s0 * t336 * t150 * t168 + t342 * t217 / 0.3072e4 + t354 * t376 / 0.3072e4 - 0.7e1 / 0.4608e4 * t207 * t383
  t387 = t161 * t386
  t389 = t221 * t171
  t390 = t225 ** 2
  t392 = t145 / t390
  t394 = t348 * t351
  t395 = t347 * t394
  t396 = t220 * t373
  t397 = t116 * t201
  t398 = t396 * t397
  t400 = t204 * t386
  t402 = t172 * t400 + t341 * t223 + t395 * t398
  t403 = t392 * t402
  t405 = t333 * t227 + t387 * t227 - t389 * t403
  t406 = t405 ** 2
  t408 = t229 ** 2
  t409 = 0.1e1 / t408
  t418 = 0.1e1 / t21 / t323
  t424 = t109 * t112 * t317
  t429 = t132 * t157 * t20 * t5
  t433 = 0.1e1 / t7 / t111
  t435 = t109 * t433 * t151
  t437 = t2 * t156
  t438 = t153 * t31 * t437
  t442 = t109 * t209 * t317
  t443 = t3 * t2
  t445 = t443 * t6 * t156
  t446 = t41 * t445
  t449 = 0.54444444444444444444444444444444444444444444444444e-1 * t109 * t336 * t151 * t158 - 0.11666666666666666666666666666666666666666666666667e-1 * t109 * t418 * t317 * t320 + 0.12638888888888888888888888888888888888888888888889e-1 * t424 * t329 + 0.58333333333333333333333333333333333333333333333334e-2 * t424 * t429 - 0.11666666666666666666666666666666666666666666666667e-1 * t435 * t438 - 0.14583333333333333333333333333333333333333333333334e-2 * t442 * t446
  t450 = t449 * t220
  t452 = t332 * t386
  t455 = t333 * t171
  t462 = t449 * t171
  t463 = t462 * t206
  t466 = t332 * t346
  t467 = t466 * t348
  t468 = t467 * t353
  t474 = 0.1e1 / t345 / t144
  t475 = t161 * t474
  t476 = t348 * t145
  t477 = t475 * t476
  t479 = 0.1e1 / t350 / t202
  t480 = t479 * t205
  t481 = t480 * t209
  t483 = t211 ** 2
  t485 = 0.1e1 / t483 / t114
  t487 = t151 * t485 * t1
  t488 = t373 ** 2
  t489 = t201 ** 2
  t492 = t487 * t359 * t488 * t489
  t495 = t352 * t380
  t496 = t349 * t495
  t505 = t182 * t4
  t507 = t505 * t78 * t370
  t512 = -0.14764627977777777777777777777777777777777777777777e-2 * t103 - 0.35616666666666666666666666666666666666666666666666e-1 * t268 - 0.20000000000000000000000000000000000000000000000000e1 * t99 + 0.10000000000000000000000000000000000000000000000000e1 * t68 + 0.16081979498692535066756296899072713062105388428051e2 * t93 + 0.24415263074675393406472461472505321282722606644045e-3 * t273 + 0.10843581300301739842632067522386578331157260943710e-1 * t507 + 0.11696447245269292414524477327518106963944910680856e1 * t288 - 0.58482236226346462072622386637590534819724553404280e0 * t300 - 0.17315859105681463759666483083807725165579399831905e2 * t308
  t515 = t358 * t359 * t512 * t201
  t521 = t487 * t359 * t488 * t201
  t526 = t247 * t151 * t212 * t216
  t529 = 0.35e2 / 0.432e3 * s0 * t433 * t150 * t168 + t463 * t217 / 0.3072e4 + t468 * t376 / 0.1536e4 - 0.7e1 / 0.2304e4 * t342 * t383 + t477 * t481 * t492 / 0.1536e4 - 0.7e1 / 0.2304e4 * t496 * t376 + t354 * t515 / 0.3072e4 - t477 * t353 * t521 / 0.3072e4 + 0.119e3 / 0.13824e5 * t207 * t526
  t530 = t161 * t529
  t532 = t387 * t171
  t537 = t145 / t390 / t225
  t538 = t402 ** 2
  t539 = t537 * t538
  t543 = t466 * t394
  t548 = t476 * t479
  t549 = t475 * t548
  t550 = t220 * t488
  t552 = 0.1e1 / t211 / t114
  t553 = t552 * t489
  t554 = t550 * t553
  t558 = t386 * t373 * t397
  t561 = t220 * t512
  t562 = t561 * t397
  t564 = t476 * t351
  t565 = t475 * t564
  t566 = t552 * t201
  t567 = t550 * t566
  t569 = t204 * t529
  t571 = t172 * t569 + t462 * t223 + 0.2e1 * t341 * t400 + 0.2e1 * t395 * t558 + t395 * t562 + 0.2e1 * t543 * t398 + 0.2e1 * t549 * t554 - t565 * t567
  t572 = t392 * t571
  t574 = t450 * t227 + 0.2e1 * t452 * t227 + t530 * t227 + 0.2e1 * t389 * t539 - t389 * t572 - 0.2e1 * t455 * t403 - 0.2e1 * t532 * t403
  t575 = t115 * t574
  t576 = 0.1e1 / t229
  t581 = t120 * t137
  t582 = t140 * t144
  t583 = t581 * t582
  t584 = t146 * t115
  t586 = t584 * t405 * t576
  t591 = 0.60000000000000000000000000000000000000000000000000e1 * t97 * t266 * t62
  t592 = t6 * t336
  t595 = 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t592 * t101
  t596 = t284 * t283
  t600 = 0.35089341735807877243573431982554320891834732042568e1 * t275 * t303 * t596 * t286
  t608 = 0.10254018858216406658218194626490193680059335835414e4 * t275 / t302 / t276 * t596 / t305 / t192
  t610 = t132 * t2 * t112
  t612 = t33 * t418
  t613 = t32 * t612
  t615 = t42 * t336
  t616 = t41 * t615
  t618 = t4 * t592
  t620 = t10 ** (-0.15e1)
  t622 = t620 * t2 * t112
  t624 = t52 * t612
  t626 = t56 * t615
  t629 = t20 * t5 * t418
  t635 = 0.58482236226346462072622386637590534819724553404280e0 * t275 * t290 * (-0.34523333333333333333333333333333333333333333333333e1 * t610 + 0.23015555555555555555555555555555555555555555555556e1 * t613 - 0.26851481481481481481481481481481481481481481481482e1 * t616 - 0.93932222222222222222222222222222222222222222222223e0 * t618 + 0.73355000000000000000000000000000000000000000000000e-1 * t622 - 0.14671000000000000000000000000000000000000000000000e0 * t624 - 0.17116166666666666666666666666666666666666666666667e0 * t626 - 0.36793333333333333333333333333333333333333333333333e0 * t629) * t286
  t641 = 0.10389515463408878255799889850284635099347639899143e3 * t275 / t302 / t189 * t596 * t306
  t646 = t390 ** 2
  t653 = t111 * t323
  t655 = 0.1e1 / t21 / t653
  t665 = t345 ** 2
  t667 = t161 / t665
  t668 = t348 ** 2
  t669 = t667 * t668
  t670 = t350 ** 2
  t671 = 0.1e1 / t670
  t679 = t151 / t483 / t211 / t108 * t1
  t680 = t488 * t373
  t681 = t489 * t201
  t702 = 0.51947577317044391278999449251423175496738199495715e2 * t275 * t303 * t297 * t306 * t283
  t707 = 0.35089341735807877243573431982554320891834732042568e1 * t275 * t278 * t283 * t286 * t297
  t711 = 0.71233333333333333333333333333333333333333333333331e-1 * t264 * t44 * t28 * t266
  t714 = 0.53424999999999999999999999999999999999999999999999e-1 * t264 * t265 * t67
  t718 = 0.85917975471764868594145516183295969534298037676861e0 * t264 * t74 * t71 * t92
  t722 = t89 * t88
  t727 = 0.51726012919273400298984252201052768390886626637712e3 * t12 / t70 / t27 * t722 / t90 / t65
  t733 = 0.96491876992155210400537781394436278372632330568306e2 * t12 / t70 / t26 * t722 * t91
  t745 = 0.10000000000000000000000000000000000000000000000000e1 * t29 * (-0.25319000000000000000000000000000000000000000000000e1 * t610 + 0.16879333333333333333333333333333333333333333333333e1 * t613 - 0.19692555555555555555555555555555555555555555555555e1 * t616 - 0.93011851851851851851851851851851851851851851851854e0 * t618 + 0.13651666666666666666666666666666666666666666666667e0 * t622 - 0.27303333333333333333333333333333333333333333333333e0 * t624 - 0.31853888888888888888888888888888888888888888888890e0 * t626 - 0.36514074074074074074074074074074074074074074074075e0 * t629) * t66
  t748 = 0.32530743900905219527896202567159734993471782831130e-1 * t505 * t78 * t287
  t749 = -t702 - t600 + t707 + t711 - t714 - t718 + t727 - t733 + t745 - t748 - t608
  t752 = 0.21687162600603479685264135044773156662314521887420e-1 * t505 * t48 * t370
  t755 = 0.16265371950452609763948101283579867496735891415565e-1 * t505 * t78 * t299
  t758 = 0.48159733137676571081572406076840235616767705782485e0 * t505 * t78 * t307
  t762 = 0.48245938496077605200268890697218139186316165284153e2 * t72 * t62 * t91 * t88
  t765 = 0.60000000000000000000000000000000000000000000000000e1 * t72 * t722 * t66
  t769 = 0.10685000000000000000000000000000000000000000000000e0 * t264 * t74 * t96 * t98
  t773 = 0.56968947174242584615102410102512416326352748836105e-3 * t270 * t42 * t336 * t193
  t774 = -t635 + t641 - t752 + t755 + t758 + t762 + t765 - t591 + t595 + t769 - t773
  t775 = t749 + t774
  t787 = t449 * t346
  t794 = t332 * t474
  t795 = t794 * t476
  t807 = t109 * t122 * t317
  t813 = t109 * t127 * t151
  t816 = t109 * t380
  t817 = t816 * t317
  t833 = t109 * t236
  t853 = -0.18148148148148148148148148148148148148148148148148e0 * t435 * t158 + 0.51851851851851851851851851851851851851851851851853e-1 * t442 * t320 - 0.59629629629629629629629629629629629629629629629630e-1 * t807 * t329 - 0.46666666666666666666666666666666666666666666666668e-1 * t807 * t429 + 0.99166666666666666666666666666666666666666666666669e-1 * t813 * t438 + 0.13125000000000000000000000000000000000000000000000e-1 * t817 * t446 + 0.58333333333333333333333333333333333333333333333334e-1 * t813 * t153 * t254 * t157 * t2 - 0.29166666666666666666666666666666666666666666666667e-2 * t817 * t133 * t445 - 0.58333333333333333333333333333333333333333333333335e-2 * t816 * t317 * t132 * t437 * t264 - 0.19444444444444444444444444444444444444444444444445e-2 * t833 * t317 * t31 * t2 * t18 * t328 - 0.97222222222222222222222222222222222222222222222227e-3 * t833 * t317 * t32 * t19 * t2 * t5 * t156 - 0.29166666666666666666666666666666666666666666666668e-2 * t109 * t241 * t151 * t154 * t146 * t156
  t854 = t853 * t171
  t861 = t485 * t1 * t214
  t890 = -0.595e3 / 0.10368e5 * t207 * t655 * t151 * t212 * t216 - 0.7e1 / 0.1536e4 * t463 * t383 + 0.119e3 / 0.4608e4 * t342 * t526 + t669 * t671 * t205 * t209 * t679 * t359 * t680 * t681 / 0.512e3 - t669 * t481 * t679 * t359 * t680 * t489 / 0.512e3 - 0.7e1 / 0.1536e4 * t496 * t515 + 0.7e1 / 0.1536e4 * t477 * t495 * t521 + t354 * t358 * t359 * t775 * t201 / 0.3072e4 + t669 * t353 * t679 * t359 * t680 * t201 / 0.3072e4 + t787 * t348 * t353 * t376 / 0.1024e4 + t468 * t515 / 0.1024e4 + t795 * t481 * t492 / 0.512e3 - t795 * t353 * t521 / 0.1024e4 + t854 * t206 * t217 / 0.3072e4 + t477 * t480 * t210 * t861 * t6 * t373 * t489 * t512 / 0.512e3 + 0.119e3 / 0.4608e4 * t349 * t352 * t247 * t376 - t477 * t352 * t210 * t861 * t6 * t512 * t374 / 0.1024e4 - 0.7e1 / 0.768e3 * t467 * t495 * t376 - 0.7e1 / 0.768e3 * t477 * t480 * t380 * t492 - 0.455e3 / 0.1296e4 * s0 * t127 * t150 * t168
  t914 = t386 * t488
  t923 = t220 * t680
  t925 = 0.1e1 / t483 / t108
  t962 = -0.3e1 * t565 * t561 * t552 * t373 * t201 + 0.3e1 * t462 * t400 + t854 * t223 + 0.6e1 * t549 * t396 * t553 * t512 + t395 * t220 * t775 * t397 + 0.3e1 * t395 * t386 * t512 * t397 - 0.3e1 * t565 * t914 * t566 + 0.6e1 * t549 * t914 * t553 + 0.6e1 * t667 * t668 * t671 * t923 * t925 * t681 - 0.6e1 * t667 * t668 * t479 * t923 * t925 * t489 + 0.3e1 * t395 * t529 * t373 * t397 + 0.6e1 * t794 * t548 * t554 - 0.3e1 * t794 * t564 * t567 + t172 * t204 * t890 + 0.3e1 * t787 * t394 * t398 + 0.6e1 * t543 * t558 + 0.3e1 * t543 * t562 + t667 * t668 * t351 * t923 * t925 * t201 + 0.3e1 * t341 * t569
  t988 = 0.6e1 * t389 * t537 * t402 * t571 - 0.6e1 * t389 * t145 / t646 * t538 * t402 + t161 * t890 * t227 + 0.6e1 * t532 * t539 - t389 * t392 * t962 - 0.3e1 * t532 * t572 - 0.3e1 * t530 * t171 * t403 - 0.3e1 * t450 * t171 * t403 - 0.3e1 * t455 * t572 + 0.3e1 * t332 * t529 * t227 - 0.6e1 * t452 * t171 * t403 + t853 * t220 * t227 + 0.3e1 * t449 * t386 * t227 + 0.6e1 * t455 * t539
  t1004 = -t591 + t595 - t600 - t608 - t635 + t641 + t311 * t115 * t988 * t576 + t727 - t733 + t745 + 0.2e1 * t311 * t115 * t406 * t405 / t408 / t229 - t714 - t718 + t769 - t773 + t120 * t138 * t137 * t141 * t140 * t232
  t1019 = t111 ** 2
  t1043 = t141 * t144
  t1059 = -t702 + t707 + t711 - t748 - t752 + t755 + t758 + t120 * (-0.60000000000000000000000000000000000000000000000000e1 * t110 / t653 * t117 + 0.19777777777777777777777777777777777777777777777778e1 * t110 / t7 / t653 * t116 * t134 - 0.13333333333333333333333333333333333333333333333333e1 * t110 * t655 * t116 * t256 + 0.24305555555555555555555555555555555555555555555556e-1 * t110 / t1019 * t116 / t13 / t1 / t443 / t78 * t2) * t140 * t232 - 0.3e1 * t311 * t575 * t409 * t405 + t765 - 0.3e1 * t583 * t584 * t406 * t409 + 0.3e1 * t581 * t1043 * t584 * t230 * t259 + 0.3e1 * t139 * t1043 * t586 + 0.3e1 * t260 * t582 * t586 + 0.3e1 * t583 * t584 * t574 * t576 + t762
  v3rho3_0_ = 0.30000000000000000000000000000000000000000000000000e1 * t68 + 0.48245938496077605200268890697218139186316165284153e2 * t93 - 0.60000000000000000000000000000000000000000000000000e1 * t99 - 0.44293883933333333333333333333333333333333333333332e-2 * t103 + 0.3e1 * t139 * t141 * t232 + 0.3e1 * t260 * t140 * t232 - 0.10685000000000000000000000000000000000000000000000e0 * t268 + 0.73245789224026180219417384417515963848167819932136e-3 * t273 + 0.35089341735807877243573431982554320891834732042568e1 * t288 - 0.17544670867903938621786715991277160445917366021284e1 * t300 - 0.51947577317044391278999449251423175496738199495715e2 * t308 - 0.3e1 * t311 * t115 * t406 * t409 + 0.3e1 * t311 * t575 * t576 + 0.32530743900905219527896202567159734993471782831130e-1 * t507 + 0.6e1 * t583 * t586 + r0 * (t1004 + t1059)

  res = {'v3rho3': v3rho3_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = t2 ** 2
  t4 = r0 + r1
  t5 = t4 ** 2
  t6 = t5 ** 2
  t7 = 0.1e1 / t6
  t8 = t3 * t7
  t9 = 0.1e1 / t4
  t10 = t1 * t9
  t11 = 0.1e1 + t10
  t12 = t11 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t14 = t13 * f.p.zeta_threshold
  t15 = t11 ** (0.1e1 / 0.3e1)
  t16 = t15 * t11
  t17 = f.my_piecewise3(t12, t14, t16)
  t18 = 0.1e1 - t10
  t19 = t18 <= f.p.zeta_threshold
  t20 = t18 ** (0.1e1 / 0.3e1)
  t21 = t20 * t18
  t22 = f.my_piecewise3(t19, t14, t21)
  t24 = 2 ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / (0.2e1 * t24 - 0.2e1)
  t28 = (t17 + t22 - 0.2e1) * t27
  t29 = 3 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / jnp.pi
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t29 * t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = t4 ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t35 / t4
  t38 = t34 * t37
  t41 = t32 * t34 / t35
  t42 = jnp.sqrt(t41)
  t45 = t41 ** 0.15e1
  t47 = t29 ** 2
  t48 = t31 ** 2
  t49 = t47 * t48
  t50 = t35 ** 2
  t53 = t49 * t33 / t50
  t55 = 0.70594500000000000000000000000000000000000000000000e1 * t42 + 0.15494250000000000000000000000000000000000000000000e1 * t41 + 0.42077500000000000000000000000000000000000000000000e0 * t45 + 0.15629250000000000000000000000000000000000000000000e0 * t53
  t58 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t55
  t59 = jnp.log(t58)
  t64 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t41
  t65 = t55 ** 2
  t66 = 0.1e1 / t65
  t67 = t64 * t66
  t68 = 0.1e1 / t42
  t69 = t68 * t29
  t70 = t31 * t34
  t71 = t70 * t37
  t72 = t69 * t71
  t74 = t32 * t38
  t76 = t41 ** 0.5e0
  t77 = t76 * t29
  t78 = t77 * t71
  t83 = t49 * t33 / t50 / t4
  t85 = -0.11765750000000000000000000000000000000000000000000e1 * t72 - 0.51647500000000000000000000000000000000000000000000e0 * t74 - 0.21038750000000000000000000000000000000000000000000e0 * t78 - 0.10419500000000000000000000000000000000000000000000e0 * t83
  t86 = 0.1e1 / t58
  t87 = t85 * t86
  t94 = 0.37978500000000000000000000000000000000000000000000e1 * t42 + 0.89690000000000000000000000000000000000000000000000e0 * t41 + 0.20477500000000000000000000000000000000000000000000e0 * t45 + 0.12323500000000000000000000000000000000000000000000e0 * t53
  t97 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t94
  t98 = jnp.log(t97)
  t100 = t32 * t38 * t98
  t101 = 0.11073470983333333333333333333333333333333333333333e-2 * t100
  t103 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t41
  t104 = t94 ** 2
  t105 = 0.1e1 / t104
  t106 = t103 * t105
  t111 = -0.63297500000000000000000000000000000000000000000000e0 * t72 - 0.29896666666666666666666666666666666666666666666667e0 * t74 - 0.10238750000000000000000000000000000000000000000000e0 * t78 - 0.82156666666666666666666666666666666666666666666667e-1 * t83
  t112 = 0.1e1 / t97
  t113 = t111 * t112
  t114 = t106 * t113
  t115 = 0.10000000000000000000000000000000000000000000000000e1 * t114
  t120 = 0.51785000000000000000000000000000000000000000000000e1 * t42 + 0.90577500000000000000000000000000000000000000000000e0 * t41 + 0.11003250000000000000000000000000000000000000000000e0 * t45 + 0.12417750000000000000000000000000000000000000000000e0 * t53
  t123 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t120
  t124 = jnp.log(t123)
  t129 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t41
  t130 = t120 ** 2
  t131 = 0.1e1 / t130
  t132 = t129 * t131
  t137 = -0.86308333333333333333333333333333333333333333333334e0 * t72 - 0.30192500000000000000000000000000000000000000000000e0 * t74 - 0.55016250000000000000000000000000000000000000000000e-1 * t78 - 0.82785000000000000000000000000000000000000000000000e-1 * t83
  t138 = 0.1e1 / t123
  t139 = t137 * t138
  t142 = 0.53237641966666666666666666666666666666666666666666e-3 * t32 * t38 * t59 + 0.10000000000000000000000000000000000000000000000000e1 * t67 * t87 - t101 - t115 + 0.18311447306006545054854346104378990962041954983034e-3 * t32 * t38 * t124 + 0.58482236226346462072622386637590534819724553404280e0 * t132 * t139
  t143 = t28 * t142
  t144 = t8 * t143
  t145 = 0.2e1 * t144
  t146 = 0.1e1 / t5
  t147 = t1 * t146
  t148 = t9 - t147
  t151 = f.my_piecewise3(t12, 0, 0.4e1 / 0.3e1 * t15 * t148)
  t152 = -t148
  t155 = f.my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t20 * t152)
  t157 = (t151 + t155) * t27
  t158 = t129 * t124
  t159 = t157 * t158
  t161 = 0.20000000000000000000000000000000000000000000000000e1 * t114
  t162 = t28 * t29
  t164 = t70 * t37 * t124
  t165 = t162 * t164
  t166 = 0.36622894612013090109708692208757981924083909966068e-3 * t165
  t170 = 0.621814e-1 * t103 * t98
  t172 = -0.3109070e-1 * t64 * t59 + t170 - 0.19751673498613801407483339618206552048944131217655e-1 * t158
  t173 = t157 * t172
  t174 = t8 * t173
  t176 = 0.22146941966666666666666666666666666666666666666666e-2 * t100
  t177 = t2 * t1
  t178 = t177 * t7
  t179 = t28 * t172
  t180 = t178 * t179
  t181 = 0.8e1 * t180
  t182 = t6 * t4
  t183 = 0.1e1 / t182
  t184 = t3 * t183
  t185 = t184 * t179
  t186 = 0.8e1 * t185
  t187 = t28 * t129
  t189 = t131 * t137 * t138
  t190 = t187 * t189
  t191 = 0.11696447245269292414524477327518106963944910680856e1 * t190
  t192 = t13 ** 2
  t193 = t15 ** 2
  t194 = f.my_piecewise3(t12, t192, t193)
  t195 = t20 ** 2
  t196 = f.my_piecewise3(t19, t192, t195)
  t198 = t194 / 0.2e1 + t196 / 0.2e1
  t200 = s0 + 0.2e1 * s1 + s2
  t201 = jnp.sqrt(t200)
  t202 = t201 * t200
  t203 = t202 * t7
  t204 = t198 ** 2
  t205 = t204 * t198
  t206 = 0.1e1 / t205
  t208 = 0.1e1 / t42 / t41
  t209 = t206 * t208
  t212 = t198 ** (0.50000000000000000000000000000000000000000000000000e-1 * t203 * t209)
  t213 = t202 * t183
  t215 = 0.20000000000000000000000000000000000000000000000000e0 * t213 * t209
  t216 = t204 ** 2
  t217 = 0.1e1 / t216
  t218 = t217 * t208
  t219 = 0.1e1 / t15
  t222 = f.my_piecewise3(t12, 0, 0.2e1 / 0.3e1 * t219 * t148)
  t223 = 0.1e1 / t20
  t226 = f.my_piecewise3(t19, 0, 0.2e1 / 0.3e1 * t223 * t152)
  t228 = t222 / 0.2e1 + t226 / 0.2e1
  t229 = t218 * t228
  t230 = t203 * t229
  t234 = t202 / t35 / t182
  t238 = 0.1e1 / t42 / t53 / 0.4e1
  t240 = t238 * t29 * t70
  t242 = 0.25000000000000000000000000000000000000000000000000e-1 * t234 * t206 * t240
  t243 = -t215 - 0.15000000000000000000000000000000000000000000000000e0 * t230 + t242
  t244 = jnp.log(t198)
  t247 = t243 * t244 + 0.50000000000000000000000000000000000000000000000000e-1 * t230
  t248 = t212 * t247
  t249 = jnp.log(0.2e1)
  t250 = 0.1e1 - t249
  t251 = t248 * t250
  t252 = jnp.pi ** 2
  t253 = 0.1e1 / t252
  t254 = t253 * t205
  t256 = t201 * t37
  t257 = t24 ** 2
  t258 = t256 * t257
  t259 = 0.1e1 / t198
  t262 = jnp.exp(-t53 / 0.4e1)
  t263 = 0.1e1 - t262
  t264 = t259 * t68 * t263
  t267 = 0.786e0 * t253 + 0.17500000000000000000000000000000000000000000000000e-1 * t258 * t264
  t269 = 0.1e1 / t35 / t5
  t270 = t200 * t269
  t272 = 0.1e1 / t204
  t274 = 0.1e1 / t31
  t276 = t272 * t47 * t274 * t33
  t279 = 0.1e1 / t250
  t280 = t267 * t279
  t285 = (-t170 + t8 * t179 + 0.19751673498613801407483339618206552048944131217655e-1 * t28 * t158) * t279
  t286 = t252 * t206
  t288 = jnp.exp(-t285 * t286)
  t289 = t288 - 0.1e1
  t290 = 0.1e1 / t289
  t291 = t252 * t290
  t292 = t200 ** 2
  t293 = t291 * t292
  t294 = t280 * t293
  t296 = 0.1e1 / t50 / t6
  t297 = t296 * t257
  t299 = 0.1e1 / t48
  t301 = t29 * t299 * t34
  t302 = t297 * t217 * t301
  t305 = t270 * t24 * t276 / 0.96e2 + t294 * t302 / 0.3072e4
  t306 = t267 * t305
  t308 = t291 * t305
  t310 = t280 * t308 + 0.1e1
  t312 = t279 * t252 / t310
  t314 = t306 * t312 + 0.1e1
  t315 = jnp.log(t314)
  t316 = t254 * t315
  t317 = t251 * t316
  t320 = t212 * t250 * t253
  t321 = t204 * t315
  t323 = t320 * t321 * t228
  t326 = t201 * t269 * t257
  t328 = 0.23333333333333333333333333333333333333333333333333e-1 * t326 * t264
  t329 = t272 * t68
  t330 = t263 * t228
  t331 = t329 * t330
  t335 = 0.1e1 / t50 / t5
  t336 = t201 * t335
  t337 = t257 * t259
  t340 = t32 * t34
  t341 = t208 * t263 * t340
  t343 = 0.29166666666666666666666666666666666666666666666667e-2 * t336 * t337 * t341
  t344 = t5 * t4
  t345 = 0.1e1 / t344
  t346 = t201 * t345
  t349 = t48 * t33
  t351 = t68 * t47 * t349 * t262
  t353 = 0.29166666666666666666666666666666666666666666666667e-2 * t346 * t337 * t351
  t354 = -t328 - 0.17500000000000000000000000000000000000000000000000e-1 * t258 * t331 + t343 - t353
  t355 = t354 * t305
  t358 = 0.1e1 / t35 / t344
  t359 = t200 * t358
  t362 = 0.7e1 / 0.288e3 * t359 * t24 * t276
  t363 = t24 * t206
  t364 = t270 * t363
  t365 = t47 * t274
  t367 = t365 * t33 * t228
  t370 = t354 * t279
  t371 = t370 * t293
  t374 = t280 * t252
  t375 = t289 ** 2
  t376 = 0.1e1 / t375
  t377 = t376 * t292
  t378 = t377 * t296
  t379 = t374 * t378
  t381 = t257 * t217 * t29
  t382 = t299 * t34
  t383 = 0.4e1 * t180
  t384 = 0.4e1 * t185
  t385 = 0.19751673498613801407483339618206552048944131217655e-1 * t159
  t386 = 0.18311447306006545054854346104378990962041954983034e-3 * t165
  t387 = 0.58482236226346462072622386637590534819724553404280e0 * t190
  t389 = (t101 + t115 + t383 - t384 + t174 + t144 + t385 - t386 - t387) * t279
  t391 = t252 * t217
  t392 = t391 * t228
  t395 = 0.3e1 * t285 * t392 - t389 * t286
  t396 = t395 * t288
  t398 = t381 * t382 * t396
  t402 = 0.1e1 / t50 / t182
  t405 = t402 * t257 * t217 * t301
  t407 = 0.7e1 / 0.4608e4 * t294 * t405
  t408 = t290 * t292
  t409 = t408 * t296
  t410 = t374 * t409
  t412 = 0.1e1 / t216 / t198
  t414 = t257 * t412 * t29
  t416 = t414 * t382 * t228
  t419 = -t362 - t364 * t367 / 0.48e2 + t371 * t302 / 0.3072e4 - t379 * t398 / 0.3072e4 - t407 - t410 * t416 / 0.768e3
  t420 = t267 * t419
  t422 = t306 * t279
  t423 = t310 ** 2
  t425 = t252 / t423
  t427 = t376 * t305
  t428 = t427 * t396
  t430 = t291 * t419
  t432 = t280 * t430 + t370 * t308 - t374 * t428
  t433 = t425 * t432
  t435 = t355 * t312 + t420 * t312 - t422 * t433
  t437 = 0.1e1 / t314
  t439 = t320 * t205 * t435 * t437
  t442 = t254 * t435 * t437
  t445 = t247 ** 2
  t452 = 0.35616666666666666666666666666666666666666666666666e-1 * t340 * t37 * t105 * t113
  t454 = t157 * t29 * t164
  t455 = 0.36622894612013090109708692208757981924083909966068e-3 * t454
  t459 = 0.24415263074675393406472461472505321282722606644045e-3 * t162 * t70 * t269 * t124
  t462 = 0.12e2 * t2 * t7 * t179
  t465 = 0.32e2 * t177 * t183 * t179
  t466 = 0.1e1 / t193
  t467 = t148 ** 2
  t470 = t1 * t345
  t472 = -0.2e1 * t146 + 0.2e1 * t470
  t476 = f.my_piecewise3(t12, 0, 0.4e1 / 0.9e1 * t466 * t467 + 0.4e1 / 0.3e1 * t15 * t472)
  t477 = 0.1e1 / t195
  t478 = t152 ** 2
  t481 = -t472
  t485 = f.my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t477 * t478 + 0.4e1 / 0.3e1 * t20 * t481)
  t487 = (t476 + t485) * t27
  t489 = 0.19751673498613801407483339618206552048944131217655e-1 * t487 * t158
  t490 = t198 * t315
  t491 = t228 ** 2
  t495 = t6 * t5
  t496 = 0.1e1 / t495
  t499 = 0.10000000000000000000000000000000000000000000000000e1 * t202 * t496 * t209
  t500 = t213 * t229
  t507 = 0.23333333333333333333333333333333333333333333333333e0 * t202 / t35 / t495 * t206 * t240
  t508 = t412 * t208
  t510 = t203 * t508 * t491
  t513 = t234 * t217 * t238
  t516 = t513 * t228 * t29 * t70
  t518 = 0.1e1 / t16
  t524 = f.my_piecewise3(t12, 0, -0.2e1 / 0.9e1 * t518 * t467 + 0.2e1 / 0.3e1 * t219 * t472)
  t525 = 0.1e1 / t21
  t531 = f.my_piecewise3(t19, 0, -0.2e1 / 0.9e1 * t525 * t478 + 0.2e1 / 0.3e1 * t223 * t481)
  t533 = t524 / 0.2e1 + t531 / 0.2e1
  t535 = t203 * t218 * t533
  t538 = 0.1e1 / t50 / t495
  t548 = 0.17361111111111111111111111111111111111111111111111e-2 * t202 * t538 * t206 / t42 / t30 / t9 * t47 * t349
  t562 = t349 * t335
  t563 = t208 * t47 * t562
  t565 = t70 * t269
  t566 = t69 * t565
  t568 = t34 * t269
  t569 = t32 * t568
  t571 = t41 ** (-0.5e0)
  t573 = t571 * t47 * t562
  t575 = t77 * t565
  t578 = t49 * t33 * t335
  t583 = 0.10000000000000000000000000000000000000000000000000e1 * t106 * (-0.42198333333333333333333333333333333333333333333333e0 * t563 + 0.84396666666666666666666666666666666666666666666666e0 * t566 + 0.39862222222222222222222222222222222222222222222223e0 * t569 + 0.68258333333333333333333333333333333333333333333333e-1 * t573 + 0.13651666666666666666666666666666666666666666666667e0 * t575 + 0.13692777777777777777777777777777777777777777777778e0 * t578) * t112
  t587 = t111 ** 2
  t590 = 0.20000000000000000000000000000000000000000000000000e1 * t103 / t104 / t94 * t587 * t112
  t591 = t104 ** 2
  t594 = t97 ** 2
  t598 = 0.16081979498692535066756296899072713062105388428051e2 * t103 / t591 * t587 / t594
  t599 = t178 * t173
  t600 = 0.8e1 * t599
  t607 = -0.57538888888888888888888888888888888888888888888889e0 * t563 + 0.11507777777777777777777777777777777777777777777778e1 * t566 + 0.40256666666666666666666666666666666666666666666667e0 * t569 + 0.36677500000000000000000000000000000000000000000000e-1 * t573 + 0.73355000000000000000000000000000000000000000000000e-1 * t575 + 0.13797500000000000000000000000000000000000000000000e0 * t578
  t611 = 0.58482236226346462072622386637590534819724553404280e0 * t187 * t131 * t607 * t138
  t612 = t130 ** 2
  t613 = 0.1e1 / t612
  t614 = t137 ** 2
  t616 = t123 ** 2
  t617 = 0.1e1 / t616
  t620 = 0.17315859105681463759666483083807725165579399831905e2 * t187 * t613 * t614 * t617
  t621 = 0.2e1 * t251 * t442 + t212 * t445 * t250 * t316 - t452 - t455 + t459 + t462 - t465 + t489 + 0.6e1 * t320 * t490 * t491 + t212 * ((t499 + 0.12000000000000000000000000000000000000000000000000e1 * t500 - t507 + 0.60000000000000000000000000000000000000000000000000e0 * t510 - 0.15000000000000000000000000000000000000000000000000e0 * t516 - 0.15000000000000000000000000000000000000000000000000e0 * t535 + t548) * t244 + t243 * t228 * t259 - 0.20000000000000000000000000000000000000000000000000e0 * t500 - 0.20000000000000000000000000000000000000000000000000e0 * t510 + 0.25000000000000000000000000000000000000000000000000e-1 * t516 + 0.50000000000000000000000000000000000000000000000000e-1 * t535) * t250 * t316 + t583 - t590 + t598 + t600 - t611 - t620
  t623 = t157 * t129 * t189
  t624 = 0.11696447245269292414524477327518106963944910680856e1 * t623
  t631 = 0.54444444444444444444444444444444444444444444444444e-1 * t201 * t358 * t257 * t264
  t632 = t326 * t331
  t639 = 0.11666666666666666666666666666666666666666666666667e-1 * t201 / t50 / t344 * t337 * t341
  t641 = t201 * t7 * t337
  t643 = 0.12638888888888888888888888888888888888888888888889e-1 * t641 * t351
  t644 = t206 * t68
  t649 = t257 * t272
  t651 = t336 * t649 * t208
  t653 = t651 * t330 * t340
  t656 = t346 * t649 * t68
  t657 = t33 * t262
  t660 = t656 * t49 * t657 * t228
  t670 = 0.58333333333333333333333333333333333333333333333334e-2 * t641 * t238 * t263 * t49 * t33
  t672 = 0.1e1 / t35 / t6
  t679 = 0.11666666666666666666666666666666666666666666666667e-1 * t201 * t672 * t257 * t259 * t208 * t30 * t262
  t687 = 0.14583333333333333333333333333333333333333333333334e-2 * t201 * t296 * t337 * t69 * t31 * t30 * t34 * t262
  t688 = t631 + 0.46666666666666666666666666666666666666666666666666e-1 * t632 - t639 + t643 + 0.35000000000000000000000000000000000000000000000000e-1 * t258 * t644 * t263 * t491 - 0.58333333333333333333333333333333333333333333333334e-2 * t653 + 0.58333333333333333333333333333333333333333333333334e-2 * t660 - 0.17500000000000000000000000000000000000000000000000e-1 * t258 * t329 * t263 * t533 + t670 - t679 - t687
  t694 = t355 * t279
  t700 = 0.35e2 / 0.432e3 * t200 * t672 * t24 * t276
  t701 = t359 * t363
  t702 = t701 * t367
  t705 = t270 * t24 * t217
  t714 = t688 * t279
  t718 = t370 * t252
  t719 = t718 * t378
  t722 = t371 * t405
  t724 = t718 * t409
  t728 = 0.1e1 / t375 / t289
  t729 = t728 * t292
  t731 = t374 * t729 * t296
  t732 = t395 ** 2
  t733 = t288 ** 2
  t734 = t732 * t733
  t740 = t374 * t377 * t402
  t741 = t740 * t398
  t744 = t374 * t377 * t297
  t746 = t412 * t29 * t299
  t748 = t288 * t228
  t754 = 0.8e1 * t178 * t143
  t758 = 0.10843581300301739842632067522386578331157260943710e-1 * t28 * t32 * t38 * t189
  t769 = t85 ** 2
  t783 = t65 ** 2
  t786 = t58 ** 2
  t793 = 0.14764627977777777777777777777777777777777777777777e-2 * t32 * t568 * t98
  t802 = 0.1e1 / t130 / t120
  t814 = -0.70983522622222222222222222222222222222222222222221e-3 * t32 * t568 * t59 - 0.34246666666666666666666666666666666666666666666666e-1 * t340 * t37 * t66 * t87 - 0.20000000000000000000000000000000000000000000000000e1 * t64 / t65 / t55 * t769 * t86 + 0.10000000000000000000000000000000000000000000000000e1 * t67 * (-0.78438333333333333333333333333333333333333333333333e0 * t563 + 0.15687666666666666666666666666666666666666666666667e1 * t566 + 0.68863333333333333333333333333333333333333333333333e0 * t569 + 0.14025833333333333333333333333333333333333333333333e0 * t573 + 0.28051666666666666666666666666666666666666666666667e0 * t575 + 0.17365833333333333333333333333333333333333333333333e0 * t578) * t86 + 0.32163958997385070133512593798145426124210776856102e2 * t64 / t783 * t769 / t786 + t793 + t452 + t590 - t583 - t598 - 0.24415263074675393406472461472505321282722606644045e-3 * t32 * t568 * t124 - 0.10843581300301739842632067522386578331157260943710e-1 * t340 * t37 * t131 * t139 - 0.11696447245269292414524477327518106963944910680856e1 * t129 * t802 * t614 * t138 + 0.58482236226346462072622386637590534819724553404280e0 * t132 * t607 * t138 + 0.17315859105681463759666483083807725165579399831905e2 * t129 * t613 * t614 * t617
  t816 = t8 * t28 * t814
  t820 = 0.11696447245269292414524477327518106963944910680856e1 * t187 * t802 * t614 * t138
  t822 = t8 * t487 * t172
  t823 = t598 + t600 + t754 - t590 + t583 + t758 + t816 + t820 - t455 - t452 + t822
  t825 = t8 * t157 * t142
  t826 = 0.2e1 * t825
  t827 = t184 * t173
  t828 = 0.8e1 * t827
  t830 = 0.8e1 * t184 * t143
  t833 = 0.20e2 * t3 * t496 * t179
  t834 = t826 - t828 - t830 - t611 - t620 - t624 + t833 + t462 - t465 + t489 - t793 + t459
  t840 = t252 * t412
  t848 = (-(t823 + t834) * t279 * t286 + 0.6e1 * t389 * t392 - 0.12e2 * t285 * t840 * t491 + 0.3e1 * t285 * t391 * t533) * t288
  t853 = t732 * t288
  t862 = 0.119e3 / 0.13824e5 * t294 * t538 * t257 * t217 * t301
  t864 = t374 * t408 * t402
  t865 = t864 * t416
  t870 = t257 / t216 / t204 * t29
  t879 = t700 + 0.7e1 / 0.72e2 * t702 + t705 * t365 * t33 * t491 / 0.16e2 - t364 * t365 * t33 * t533 / 0.48e2 + t714 * t293 * t302 / 0.3072e4 - t719 * t398 / 0.1536e4 - 0.7e1 / 0.2304e4 * t722 - t724 * t416 / 0.384e3 + t731 * t381 * t382 * t734 / 0.1536e4 + 0.7e1 / 0.2304e4 * t741 + t744 * t746 * t34 * t395 * t748 / 0.384e3 - t379 * t381 * t382 * t848 / 0.3072e4 - t379 * t381 * t382 * t853 / 0.3072e4 + t862 + 0.7e1 / 0.576e3 * t865 + 0.5e1 / 0.768e3 * t410 * t870 * t382 * t491 - t410 * t414 * t382 * t533 / 0.768e3
  t882 = t420 * t279
  t887 = t252 / t423 / t310
  t888 = t432 ** 2
  t897 = t728 * t305
  t901 = t376 * t419
  t918 = t435 ** 2
  t920 = t314 ** 2
  t921 = 0.1e1 / t920
  t924 = t253 * t204
  t926 = t924 * t315 * t228
  t929 = t204 * t435
  t930 = t437 * t228
  t934 = -t624 + 0.3e1 * t320 * t321 * t533 + t320 * t205 * (t688 * t305 * t312 + 0.2e1 * t354 * t419 * t312 - 0.2e1 * t694 * t433 + t267 * t879 * t312 - 0.2e1 * t882 * t433 + 0.2e1 * t422 * t887 * t888 - t422 * t425 * (t280 * t291 * t879 - 0.2e1 * t374 * t901 * t396 - t374 * t427 * t848 - t374 * t427 * t853 + 0.2e1 * t374 * t897 * t734 + t714 * t308 + 0.2e1 * t370 * t430 - 0.2e1 * t718 * t428)) * t437 - t320 * t205 * t918 * t921 + t820 - t793 + t816 + 0.6e1 * t251 * t926 + t754 + t758 + 0.6e1 * t320 * t929 * t930 - t830 + t833 + t826 - t828 + t822
  d11 = t145 + 0.39503346997227602814966679236413104097888262435310e-1 * t159 + t161 - t166 + 0.2e1 * t174 + t176 + t181 - t186 - t191 + 0.2e1 * t317 + 0.6e1 * t323 + 0.2e1 * t439 + t4 * (t621 + t934)
  t938 = -t9 - t147
  t941 = f.my_piecewise3(t12, 0, 0.4e1 / 0.3e1 * t15 * t938)
  t942 = -t938
  t945 = f.my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t20 * t942)
  t947 = (t941 + t945) * t27
  t948 = t947 * t158
  t949 = 0.19751673498613801407483339618206552048944131217655e-1 * t948
  t952 = f.my_piecewise3(t12, 0, 0.2e1 / 0.3e1 * t219 * t938)
  t955 = f.my_piecewise3(t19, 0, 0.2e1 / 0.3e1 * t223 * t942)
  t957 = t952 / 0.2e1 + t955 / 0.2e1
  t958 = t263 * t957
  t959 = t329 * t958
  t962 = -t328 - 0.17500000000000000000000000000000000000000000000000e-1 * t258 * t959 + t343 - t353
  t963 = t962 * t305
  t965 = t33 * t957
  t966 = t365 * t965
  t969 = t962 * t279
  t970 = t969 * t293
  t973 = t947 * t172
  t974 = t8 * t973
  t976 = (t101 + t115 - t383 - t384 + t974 + t144 + t949 - t386 - t387) * t279
  t978 = t391 * t957
  t981 = 0.3e1 * t285 * t978 - t976 * t286
  t982 = t981 * t288
  t984 = t381 * t382 * t982
  t988 = t414 * t382 * t957
  t991 = -t362 - t364 * t966 / 0.48e2 + t970 * t302 / 0.3072e4 - t379 * t984 / 0.3072e4 - t407 - t410 * t988 / 0.768e3
  t992 = t267 * t991
  t995 = t427 * t982
  t997 = t291 * t991
  t999 = t280 * t997 + t969 * t308 - t374 * t995
  t1000 = t425 * t999
  t1002 = -t422 * t1000 + t963 * t312 + t992 * t312
  t1003 = t205 * t1002
  t1005 = t320 * t1003 * t437
  t1006 = t218 * t957
  t1007 = t203 * t1006
  t1009 = -t215 - 0.15000000000000000000000000000000000000000000000000e0 * t1007 + t242
  t1012 = t1009 * t244 + 0.50000000000000000000000000000000000000000000000000e-1 * t1007
  t1014 = t212 * t1012 * t250
  t1015 = t1014 * t316
  t1017 = t320 * t321 * t957
  t1020 = t947 * t29 * t164
  t1021 = 0.18311447306006545054854346104378990962041954983034e-3 * t1020
  t1022 = t437 * t957
  t1026 = t957 * t228
  t1033 = t254 * t1002 * t437
  t1038 = 0.18311447306006545054854346104378990962041954983034e-3 * t454
  t1040 = t947 * t129 * t189
  t1041 = 0.58482236226346462072622386637590534819724553404280e0 * t1040
  t1049 = f.my_piecewise3(t12, 0, -0.2e1 / 0.9e1 * t518 * t938 * t148 + 0.4e1 / 0.3e1 * t219 * t1 * t345)
  t1057 = f.my_piecewise3(t19, 0, -0.2e1 / 0.9e1 * t525 * t942 * t152 - 0.4e1 / 0.3e1 * t223 * t1 * t345)
  t1059 = t1049 / 0.2e1 + t1057 / 0.2e1
  t1064 = t326 * t959
  t1073 = t651 * t958 * t340
  t1077 = t656 * t49 * t657 * t957
  t1085 = t631 + 0.23333333333333333333333333333333333333333333333333e-1 * t632 - t639 + t643 + 0.23333333333333333333333333333333333333333333333333e-1 * t1064 + 0.35000000000000000000000000000000000000000000000000e-1 * t256 * t257 * t206 * t68 * t263 * t1026 - 0.29166666666666666666666666666666666666666666666667e-2 * t1073 + 0.29166666666666666666666666666666666666666666666667e-2 * t1077 - 0.17500000000000000000000000000000000000000000000000e-1 * t258 * t329 * t263 * t1059 - 0.29166666666666666666666666666666666666666666666667e-2 * t653 + t670 - t679 + 0.29166666666666666666666666666666666666666666666667e-2 * t660 - t687
  t1090 = t963 * t279
  t1095 = t701 * t966
  t1105 = t1085 * t279
  t1109 = t969 * t252
  t1110 = t1109 * t378
  t1113 = t970 * t405
  t1115 = t1109 * t409
  t1123 = t217 * t29 * t299
  t1124 = t34 * t981
  t1125 = t733 * t395
  t1130 = t740 * t984
  t1132 = t700 + 0.7e1 / 0.144e3 * t702 + 0.7e1 / 0.144e3 * t1095 + t705 * t365 * t965 * t228 / 0.16e2 - t364 * t365 * t33 * t1059 / 0.48e2 + t1105 * t293 * t302 / 0.3072e4 - t1110 * t398 / 0.3072e4 - 0.7e1 / 0.4608e4 * t1113 - t1115 * t416 / 0.768e3 - t719 * t984 / 0.3072e4 + t374 * t729 * t297 * t1123 * t1124 * t1125 / 0.1536e4 + 0.7e1 / 0.4608e4 * t1130
  t1137 = t178 * t973
  t1138 = 0.4e1 * t1137
  t1139 = t184 * t973
  t1140 = 0.4e1 * t1139
  t1141 = 0.4e1 * t599
  t1142 = -t1021 - t452 - t1038 + t459 - t462 + t583 - t590 + t598 - t1041 + t1138 - t1140 - t1141 - t611
  t1143 = 0.58482236226346462072622386637590534819724553404280e0 * t623
  t1151 = f.my_piecewise3(t12, 0, 0.4e1 / 0.9e1 * t466 * t938 * t148 + 0.8e1 / 0.3e1 * t15 * t1 * t345)
  t1159 = f.my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t477 * t942 * t152 - 0.8e1 / 0.3e1 * t20 * t1 * t345)
  t1161 = (t1151 + t1159) * t27
  t1163 = t8 * t1161 * t172
  t1165 = t8 * t947 * t142
  t1167 = 0.19751673498613801407483339618206552048944131217655e-1 * t1161 * t158
  t1168 = 0.4e1 * t827
  t1169 = -t620 - t1143 + t1163 + t1165 + t820 + t1167 - t793 + t816 + t758 - t830 + t833 + t825 - t1168
  t1186 = (-(t1142 + t1169) * t279 * t286 + 0.3e1 * t976 * t392 + 0.3e1 * t389 * t978 - 0.12e2 * t285 * t252 * t412 * t957 * t228 + 0.3e1 * t285 * t391 * t1059) * t288
  t1205 = t864 * t988
  t1215 = t744 * t746 * t1124 * t748 / 0.768e3 - t379 * t381 * t382 * t1186 / 0.3072e4 - t744 * t1123 * t1124 * t396 / 0.3072e4 - 0.7e1 / 0.4608e4 * t722 + 0.7e1 / 0.4608e4 * t741 + t862 + 0.7e1 / 0.1152e4 * t865 - t724 * t988 / 0.768e3 + t744 * t746 * t34 * t957 * t396 / 0.768e3 + 0.7e1 / 0.1152e4 * t1205 + 0.5e1 / 0.768e3 * t410 * t870 * t382 * t1026 - t410 * t414 * t382 * t1059 / 0.768e3
  t1216 = t1132 + t1215
  t1219 = t992 * t279
  t1233 = t305 * t981
  t1246 = t376 * t991
  t1251 = 0.2e1 * t280 * t252 * t728 * t1233 * t1125 - t280 * t252 * t376 * t1233 * t396 - t374 * t427 * t1186 + t280 * t291 * t1216 - t374 * t1246 * t396 - t374 * t901 * t982 + t1105 * t308 - t1109 * t428 + t370 * t997 + t969 * t430 - t718 * t995
  t1259 = t213 * t1006
  t1264 = t203 * t412 * t208 * t957 * t228
  t1268 = t513 * t957 * t29 * t70
  t1271 = t203 * t218 * t1059
  t1278 = 0.20000000000000000000000000000000000000000000000000e0 * t1259
  t1280 = 0.25000000000000000000000000000000000000000000000000e-1 * t1268
  t1286 = -t1021 + 0.3e1 * t320 * t929 * t1022 + 0.6e1 * t320 * t490 * t1026 + 0.3e1 * t1014 * t926 + t251 * t1033 - t320 * t1003 * t921 * t435 - t452 - t1038 + t459 - t462 + t583 - t590 + t598 - t1041 + 0.3e1 * t320 * t321 * t1059 + t320 * t205 * (0.2e1 * t422 * t887 * t999 * t432 + t1085 * t305 * t312 + t267 * t1216 * t312 - t422 * t425 * t1251 + t354 * t991 * t312 + t962 * t419 * t312 - t694 * t1000 - t882 * t1000 - t1090 * t433 - t1219 * t433) * t437 + t212 * ((t499 + 0.60000000000000000000000000000000000000000000000000e0 * t500 - t507 + 0.60000000000000000000000000000000000000000000000000e0 * t1259 + 0.60000000000000000000000000000000000000000000000000e0 * t1264 - 0.75000000000000000000000000000000000000000000000000e-1 * t1268 - 0.15000000000000000000000000000000000000000000000000e0 * t1271 - 0.75000000000000000000000000000000000000000000000000e-1 * t516 + t548) * t244 + t1009 * t228 * t259 - t1278 - 0.20000000000000000000000000000000000000000000000000e0 * t1264 + t1280 + 0.50000000000000000000000000000000000000000000000000e-1 * t1271) * t250 * t316 + t1138 - t1140
  t1289 = t924 * t315 * t957
  t1292 = t204 * t1002
  t1301 = t248 * t1012 * t250 * t253 * t205 * t315 + 0.3e1 * t320 * t1292 * t930 + t1014 * t442 + 0.3e1 * t251 * t1289 - t1141 - t1143 + t1163 + t1165 + t1167 - t1168 - t611 - t620 + t758 - t793 + t816 + t820 + t825 - t830 + t833
  d12 = -t166 + 0.3e1 * t323 + t317 + t439 + t949 + t161 + t385 + t1005 - t191 + t1015 + 0.3e1 * t1017 + t176 - t186 + t174 + t145 + t974 + t4 * (t1286 + t1301)
  t1304 = 0.36622894612013090109708692208757981924083909966068e-3 * t1020
  t1305 = t1002 ** 2
  t1309 = t957 ** 2
  t1315 = t203 * t508 * t1309
  t1318 = t938 ** 2
  t1322 = 0.2e1 * t146 + 0.2e1 * t470
  t1326 = f.my_piecewise3(t12, 0, -0.2e1 / 0.9e1 * t518 * t1318 + 0.2e1 / 0.3e1 * t219 * t1322)
  t1327 = t942 ** 2
  t1330 = -t1322
  t1334 = f.my_piecewise3(t19, 0, -0.2e1 / 0.9e1 * t525 * t1327 + 0.2e1 / 0.3e1 * t223 * t1330)
  t1336 = t1326 / 0.2e1 + t1334 / 0.2e1
  t1338 = t203 * t218 * t1336
  t1364 = t631 + 0.46666666666666666666666666666666666666666666666666e-1 * t1064 - t639 + t643 + 0.35000000000000000000000000000000000000000000000000e-1 * t258 * t644 * t263 * t1309 - 0.58333333333333333333333333333333333333333333333334e-2 * t1073 + 0.58333333333333333333333333333333333333333333333334e-2 * t1077 - 0.17500000000000000000000000000000000000000000000000e-1 * t258 * t329 * t263 * t1336 + t670 - t679 - t687
  t1381 = t1364 * t279
  t1390 = t981 ** 2
  t1391 = t1390 * t733
  t1402 = 0.11696447245269292414524477327518106963944910680856e1 * t1040
  t1403 = -t452 + t583 + t598 + t459 + t816 - t620 - t611 - t1402 + t833 + t465 - t793
  t1404 = 0.8e1 * t1137
  t1410 = f.my_piecewise3(t12, 0, 0.4e1 / 0.9e1 * t466 * t1318 + 0.4e1 / 0.3e1 * t15 * t1322)
  t1416 = f.my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t477 * t1327 + 0.4e1 / 0.3e1 * t20 * t1330)
  t1418 = (t1410 + t1416) * t27
  t1420 = t8 * t1418 * t172
  t1421 = 0.2e1 * t1165
  t1422 = 0.8e1 * t1139
  t1424 = 0.19751673498613801407483339618206552048944131217655e-1 * t1418 * t158
  t1425 = t758 - t1404 - t754 + t1420 + t1421 + t462 - t1422 - t830 - t590 + t1424 - t1304 + t820
  t1438 = (-(t1403 + t1425) * t279 * t286 + 0.6e1 * t976 * t978 - 0.12e2 * t285 * t840 * t1309 + 0.3e1 * t285 * t391 * t1336) * t288
  t1443 = t1390 * t288
  t1457 = t700 + 0.7e1 / 0.72e2 * t1095 + t705 * t365 * t33 * t1309 / 0.16e2 - t364 * t365 * t33 * t1336 / 0.48e2 + t1381 * t293 * t302 / 0.3072e4 - t1110 * t984 / 0.1536e4 - 0.7e1 / 0.2304e4 * t1113 - t1115 * t988 / 0.384e3 + t731 * t381 * t382 * t1391 / 0.1536e4 + 0.7e1 / 0.2304e4 * t1130 + t744 * t746 * t1124 * t288 * t957 / 0.384e3 - t379 * t381 * t382 * t1438 / 0.3072e4 - t379 * t381 * t382 * t1443 / 0.3072e4 + t862 + 0.7e1 / 0.576e3 * t1205 + 0.5e1 / 0.768e3 * t410 * t870 * t382 * t1309 - t410 * t414 * t382 * t1336 / 0.768e3
  t1462 = t999 ** 2
  t1490 = t1012 ** 2
  t1497 = -t1304 - t452 + t459 + t462 + t465 - t320 * t205 * t1305 * t921 + 0.6e1 * t320 * t490 * t1309 + t212 * ((t499 + 0.12000000000000000000000000000000000000000000000000e1 * t1259 - t507 + 0.60000000000000000000000000000000000000000000000000e0 * t1315 - 0.15000000000000000000000000000000000000000000000000e0 * t1268 - 0.15000000000000000000000000000000000000000000000000e0 * t1338 + t548) * t244 + t1009 * t957 * t259 - t1278 - 0.20000000000000000000000000000000000000000000000000e0 * t1315 + t1280 + 0.50000000000000000000000000000000000000000000000000e-1 * t1338) * t250 * t316 + 0.3e1 * t320 * t321 * t1336 + t320 * t205 * (t1364 * t305 * t312 + 0.2e1 * t962 * t991 * t312 - 0.2e1 * t1090 * t1000 + t267 * t1457 * t312 - 0.2e1 * t1219 * t1000 + 0.2e1 * t422 * t887 * t1462 - t422 * t425 * (-0.2e1 * t374 * t1246 * t982 + 0.2e1 * t374 * t897 * t1391 - t374 * t427 * t1438 - t374 * t427 * t1443 + t280 * t291 * t1457 - 0.2e1 * t1109 * t995 + t1381 * t308 + 0.2e1 * t969 * t997)) * t437 + t212 * t1490 * t250 * t316 + t583 - t590 + t598 + 0.6e1 * t320 * t1292 * t1022 - t1402
  t1502 = 0.2e1 * t1014 * t1033 + 0.6e1 * t1014 * t1289 - t1404 + t1420 + t1421 - t1422 + t1424 - t611 - t620 - t754 + t758 - t793 + t816 + t820 - t830 + t833
  d22 = -t166 + t4 * (t1497 + t1502) - t191 + 0.2e1 * t1015 + 0.6e1 * t1017 + 0.39503346997227602814966679236413104097888262435310e-1 * t948 + 0.2e1 * t1005 + t161 + t145 - t181 - t186 + 0.2e1 * t974 + t176
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = t2 ** 2
  t4 = r0 + r1
  t5 = t4 ** 2
  t6 = t5 ** 2
  t7 = 0.1e1 / t6
  t8 = t3 * t7
  t9 = 0.1e1 / t4
  t10 = t1 * t9
  t11 = 0.1e1 + t10
  t12 = t11 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t14 = t13 * f.p.zeta_threshold
  t15 = t11 ** (0.1e1 / 0.3e1)
  t16 = t15 * t11
  t17 = f.my_piecewise3(t12, t14, t16)
  t18 = 0.1e1 - t10
  t19 = t18 <= f.p.zeta_threshold
  t20 = t18 ** (0.1e1 / 0.3e1)
  t21 = t20 * t18
  t22 = f.my_piecewise3(t19, t14, t21)
  t24 = 2 ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / (0.2e1 * t24 - 0.2e1)
  t28 = (t17 + t22 - 0.2e1) * t27
  t29 = 3 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / jnp.pi
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t29 * t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = t4 ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t35 / t4
  t38 = t34 * t37
  t41 = t32 * t34 / t35
  t42 = jnp.sqrt(t41)
  t45 = t41 ** 0.15e1
  t47 = t29 ** 2
  t48 = t31 ** 2
  t49 = t47 * t48
  t50 = t35 ** 2
  t53 = t49 * t33 / t50
  t55 = 0.70594500000000000000000000000000000000000000000000e1 * t42 + 0.15494250000000000000000000000000000000000000000000e1 * t41 + 0.42077500000000000000000000000000000000000000000000e0 * t45 + 0.15629250000000000000000000000000000000000000000000e0 * t53
  t58 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t55
  t59 = jnp.log(t58)
  t64 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t41
  t65 = t55 ** 2
  t66 = 0.1e1 / t65
  t67 = t64 * t66
  t68 = 0.1e1 / t42
  t69 = t68 * t29
  t70 = t31 * t34
  t71 = t70 * t37
  t72 = t69 * t71
  t74 = t32 * t38
  t76 = t41 ** 0.5e0
  t77 = t76 * t29
  t78 = t77 * t71
  t83 = t49 * t33 / t50 / t4
  t85 = -0.11765750000000000000000000000000000000000000000000e1 * t72 - 0.51647500000000000000000000000000000000000000000000e0 * t74 - 0.21038750000000000000000000000000000000000000000000e0 * t78 - 0.10419500000000000000000000000000000000000000000000e0 * t83
  t86 = 0.1e1 / t58
  t87 = t85 * t86
  t94 = 0.37978500000000000000000000000000000000000000000000e1 * t42 + 0.89690000000000000000000000000000000000000000000000e0 * t41 + 0.20477500000000000000000000000000000000000000000000e0 * t45 + 0.12323500000000000000000000000000000000000000000000e0 * t53
  t97 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t94
  t98 = jnp.log(t97)
  t100 = t32 * t38 * t98
  t101 = 0.11073470983333333333333333333333333333333333333333e-2 * t100
  t103 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t41
  t104 = t94 ** 2
  t105 = 0.1e1 / t104
  t106 = t103 * t105
  t111 = -0.63297500000000000000000000000000000000000000000000e0 * t72 - 0.29896666666666666666666666666666666666666666666667e0 * t74 - 0.10238750000000000000000000000000000000000000000000e0 * t78 - 0.82156666666666666666666666666666666666666666666667e-1 * t83
  t112 = 0.1e1 / t97
  t113 = t111 * t112
  t114 = t106 * t113
  t115 = 0.10000000000000000000000000000000000000000000000000e1 * t114
  t120 = 0.51785000000000000000000000000000000000000000000000e1 * t42 + 0.90577500000000000000000000000000000000000000000000e0 * t41 + 0.11003250000000000000000000000000000000000000000000e0 * t45 + 0.12417750000000000000000000000000000000000000000000e0 * t53
  t123 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t120
  t124 = jnp.log(t123)
  t129 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t41
  t130 = t120 ** 2
  t131 = 0.1e1 / t130
  t132 = t129 * t131
  t137 = -0.86308333333333333333333333333333333333333333333334e0 * t72 - 0.30192500000000000000000000000000000000000000000000e0 * t74 - 0.55016250000000000000000000000000000000000000000000e-1 * t78 - 0.82785000000000000000000000000000000000000000000000e-1 * t83
  t138 = 0.1e1 / t123
  t139 = t137 * t138
  t142 = 0.53237641966666666666666666666666666666666666666666e-3 * t32 * t38 * t59 + 0.10000000000000000000000000000000000000000000000000e1 * t67 * t87 - t101 - t115 + 0.18311447306006545054854346104378990962041954983034e-3 * t32 * t38 * t124 + 0.58482236226346462072622386637590534819724553404280e0 * t132 * t139
  t143 = t28 * t142
  t144 = t8 * t143
  t145 = 0.2e1 * t144
  t146 = 0.1e1 / t5
  t147 = t1 * t146
  t148 = t9 - t147
  t151 = f.my_piecewise3(t12, 0, 0.4e1 / 0.3e1 * t15 * t148)
  t152 = -t148
  t155 = f.my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t20 * t152)
  t157 = (t151 + t155) * t27
  t158 = t129 * t124
  t159 = t157 * t158
  t161 = 0.20000000000000000000000000000000000000000000000000e1 * t114
  t162 = t28 * t29
  t164 = t70 * t37 * t124
  t165 = t162 * t164
  t166 = 0.36622894612013090109708692208757981924083909966068e-3 * t165
  t170 = 0.621814e-1 * t103 * t98
  t172 = -0.3109070e-1 * t64 * t59 + t170 - 0.19751673498613801407483339618206552048944131217655e-1 * t158
  t173 = t157 * t172
  t174 = t8 * t173
  t176 = 0.22146941966666666666666666666666666666666666666666e-2 * t100
  t177 = t2 * t1
  t178 = t177 * t7
  t179 = t28 * t172
  t180 = t178 * t179
  t181 = 0.8e1 * t180
  t182 = t6 * t4
  t183 = 0.1e1 / t182
  t184 = t3 * t183
  t185 = t184 * t179
  t186 = 0.8e1 * t185
  t187 = t15 ** 2
  t188 = 0.1e1 / t187
  t189 = t148 ** 2
  t192 = t5 * t4
  t193 = 0.1e1 / t192
  t194 = t1 * t193
  t196 = -0.2e1 * t146 + 0.2e1 * t194
  t200 = f.my_piecewise3(t12, 0, 0.4e1 / 0.9e1 * t188 * t189 + 0.4e1 / 0.3e1 * t15 * t196)
  t201 = t20 ** 2
  t202 = 0.1e1 / t201
  t203 = t152 ** 2
  t206 = -t196
  t210 = f.my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t202 * t203 + 0.4e1 / 0.3e1 * t20 * t206)
  t212 = (t200 + t210) * t27
  t214 = 0.19751673498613801407483339618206552048944131217655e-1 * t212 * t158
  t215 = t13 ** 2
  t216 = f.my_piecewise3(t12, t215, t187)
  t217 = f.my_piecewise3(t19, t215, t201)
  t219 = t216 / 0.2e1 + t217 / 0.2e1
  t221 = s0 + 0.2e1 * s1 + s2
  t222 = jnp.sqrt(t221)
  t223 = t222 * t221
  t224 = t223 * t7
  t225 = t219 ** 2
  t226 = t225 * t219
  t227 = 0.1e1 / t226
  t229 = 0.1e1 / t42 / t41
  t230 = t227 * t229
  t233 = t219 ** (0.50000000000000000000000000000000000000000000000000e-1 * t224 * t230)
  t234 = t223 * t183
  t236 = 0.20000000000000000000000000000000000000000000000000e0 * t234 * t230
  t237 = t225 ** 2
  t238 = 0.1e1 / t237
  t239 = t238 * t229
  t240 = 0.1e1 / t15
  t243 = f.my_piecewise3(t12, 0, 0.2e1 / 0.3e1 * t240 * t148)
  t244 = 0.1e1 / t20
  t247 = f.my_piecewise3(t19, 0, 0.2e1 / 0.3e1 * t244 * t152)
  t249 = t243 / 0.2e1 + t247 / 0.2e1
  t250 = t239 * t249
  t251 = t224 * t250
  t255 = t223 / t35 / t182
  t259 = 0.1e1 / t42 / t53 / 0.4e1
  t261 = t259 * t29 * t70
  t263 = 0.25000000000000000000000000000000000000000000000000e-1 * t255 * t227 * t261
  t264 = -t236 - 0.15000000000000000000000000000000000000000000000000e0 * t251 + t263
  t265 = jnp.log(t219)
  t268 = t264 * t265 + 0.50000000000000000000000000000000000000000000000000e-1 * t251
  t269 = t233 * t268
  t270 = jnp.log(0.2e1)
  t271 = 0.1e1 - t270
  t272 = t269 * t271
  t273 = jnp.pi ** 2
  t274 = 0.1e1 / t273
  t275 = t274 * t226
  t277 = 0.1e1 / t35 / t5
  t279 = t24 ** 2
  t280 = t222 * t277 * t279
  t281 = 0.1e1 / t219
  t284 = jnp.exp(-t53 / 0.4e1)
  t285 = 0.1e1 - t284
  t286 = t281 * t68 * t285
  t288 = 0.23333333333333333333333333333333333333333333333333e-1 * t280 * t286
  t289 = t222 * t37
  t290 = t289 * t279
  t291 = 0.1e1 / t225
  t292 = t291 * t68
  t293 = t285 * t249
  t294 = t292 * t293
  t298 = 0.1e1 / t50 / t5
  t299 = t222 * t298
  t300 = t279 * t281
  t303 = t32 * t34
  t304 = t229 * t285 * t303
  t306 = 0.29166666666666666666666666666666666666666666666667e-2 * t299 * t300 * t304
  t307 = t222 * t193
  t310 = t48 * t33
  t312 = t68 * t47 * t310 * t284
  t314 = 0.29166666666666666666666666666666666666666666666667e-2 * t307 * t300 * t312
  t315 = -t288 - 0.17500000000000000000000000000000000000000000000000e-1 * t290 * t294 + t306 - t314
  t316 = t221 * t277
  t319 = 0.1e1 / t31
  t321 = t291 * t47 * t319 * t33
  t327 = 0.786e0 * t274 + 0.17500000000000000000000000000000000000000000000000e-1 * t290 * t286
  t328 = 0.1e1 / t271
  t329 = t327 * t328
  t334 = (-t170 + t8 * t179 + 0.19751673498613801407483339618206552048944131217655e-1 * t28 * t158) * t328
  t335 = t273 * t227
  t337 = jnp.exp(-t334 * t335)
  t338 = t337 - 0.1e1
  t339 = 0.1e1 / t338
  t340 = t273 * t339
  t341 = t221 ** 2
  t342 = t340 * t341
  t343 = t329 * t342
  t345 = 0.1e1 / t50 / t6
  t346 = t345 * t279
  t348 = 0.1e1 / t48
  t350 = t29 * t348 * t34
  t351 = t346 * t238 * t350
  t354 = t316 * t24 * t321 / 0.96e2 + t343 * t351 / 0.3072e4
  t355 = t315 * t354
  t357 = t340 * t354
  t359 = t329 * t357 + 0.1e1
  t361 = t328 * t273 / t359
  t364 = 0.1e1 / t35 / t192
  t365 = t221 * t364
  t368 = 0.7e1 / 0.288e3 * t365 * t24 * t321
  t369 = t24 * t227
  t370 = t316 * t369
  t371 = t47 * t319
  t373 = t371 * t33 * t249
  t376 = t315 * t328
  t377 = t376 * t342
  t380 = t329 * t273
  t381 = t338 ** 2
  t382 = 0.1e1 / t381
  t383 = t382 * t341
  t384 = t383 * t345
  t385 = t380 * t384
  t387 = t279 * t238 * t29
  t388 = t348 * t34
  t389 = 0.4e1 * t180
  t390 = 0.4e1 * t185
  t391 = 0.19751673498613801407483339618206552048944131217655e-1 * t159
  t392 = 0.18311447306006545054854346104378990962041954983034e-3 * t165
  t393 = t28 * t129
  t395 = t131 * t137 * t138
  t396 = t393 * t395
  t397 = 0.58482236226346462072622386637590534819724553404280e0 * t396
  t399 = (t101 + t115 + t389 - t390 + t174 + t144 + t391 - t392 - t397) * t328
  t401 = t273 * t238
  t402 = t401 * t249
  t405 = 0.3e1 * t334 * t402 - t399 * t335
  t406 = t405 * t337
  t408 = t387 * t388 * t406
  t412 = 0.1e1 / t50 / t182
  t415 = t412 * t279 * t238 * t350
  t417 = 0.7e1 / 0.4608e4 * t343 * t415
  t418 = t339 * t341
  t419 = t418 * t345
  t420 = t380 * t419
  t422 = 0.1e1 / t237 / t219
  t424 = t279 * t422 * t29
  t426 = t424 * t388 * t249
  t429 = -t368 - t370 * t373 / 0.48e2 + t377 * t351 / 0.3072e4 - t385 * t408 / 0.3072e4 - t417 - t420 * t426 / 0.768e3
  t430 = t327 * t429
  t432 = t327 * t354
  t433 = t432 * t328
  t434 = t359 ** 2
  t436 = t273 / t434
  t438 = t382 * t354
  t439 = t438 * t406
  t441 = t340 * t429
  t443 = t329 * t441 + t376 * t357 - t380 * t439
  t444 = t436 * t443
  t446 = t355 * t361 + t430 * t361 - t433 * t444
  t448 = t432 * t361 + 0.1e1
  t449 = 0.1e1 / t448
  t451 = t275 * t446 * t449
  t454 = t274 * t225
  t455 = jnp.log(t448)
  t457 = t454 * t455 * t249
  t461 = t233 * t271 * t274
  t462 = t446 ** 2
  t464 = t448 ** 2
  t465 = 0.1e1 / t464
  t469 = 0.1e1 / t130 / t120
  t470 = t137 ** 2
  t474 = 0.11696447245269292414524477327518106963944910680856e1 * t393 * t469 * t470 * t138
  t476 = t310 * t298
  t477 = t229 * t47 * t476
  t479 = t70 * t277
  t480 = t69 * t479
  t482 = t34 * t277
  t483 = t32 * t482
  t485 = t41 ** (-0.5e0)
  t487 = t485 * t47 * t476
  t489 = t77 * t479
  t492 = t49 * t33 * t298
  t494 = -0.57538888888888888888888888888888888888888888888889e0 * t477 + 0.11507777777777777777777777777777777777777777777778e1 * t480 + 0.40256666666666666666666666666666666666666666666667e0 * t483 + 0.36677500000000000000000000000000000000000000000000e-1 * t487 + 0.73355000000000000000000000000000000000000000000000e-1 * t489 + 0.13797500000000000000000000000000000000000000000000e0 * t492
  t498 = 0.58482236226346462072622386637590534819724553404280e0 * t393 * t131 * t494 * t138
  t499 = t225 * t446
  t500 = t449 * t249
  t504 = t130 ** 2
  t505 = 0.1e1 / t504
  t507 = t123 ** 2
  t508 = 0.1e1 / t507
  t511 = 0.17315859105681463759666483083807725165579399831905e2 * t393 * t505 * t470 * t508
  t513 = t157 * t129 * t395
  t514 = 0.11696447245269292414524477327518106963944910680856e1 * t513
  t515 = t225 * t455
  t516 = 0.1e1 / t16
  t522 = f.my_piecewise3(t12, 0, -0.2e1 / 0.9e1 * t516 * t189 + 0.2e1 / 0.3e1 * t240 * t196)
  t523 = 0.1e1 / t21
  t529 = f.my_piecewise3(t19, 0, -0.2e1 / 0.9e1 * t523 * t203 + 0.2e1 / 0.3e1 * t244 * t206)
  t531 = t522 / 0.2e1 + t529 / 0.2e1
  t538 = 0.54444444444444444444444444444444444444444444444444e-1 * t222 * t364 * t279 * t286
  t539 = t280 * t294
  t546 = 0.11666666666666666666666666666666666666666666666667e-1 * t222 / t50 / t192 * t300 * t304
  t548 = t222 * t7 * t300
  t550 = 0.12638888888888888888888888888888888888888888888889e-1 * t548 * t312
  t551 = t227 * t68
  t552 = t249 ** 2
  t557 = t279 * t291
  t559 = t299 * t557 * t229
  t561 = t559 * t293 * t303
  t564 = t307 * t557 * t68
  t565 = t33 * t284
  t568 = t564 * t49 * t565 * t249
  t578 = 0.58333333333333333333333333333333333333333333333334e-2 * t548 * t259 * t285 * t49 * t33
  t580 = 0.1e1 / t35 / t6
  t587 = 0.11666666666666666666666666666666666666666666666667e-1 * t222 * t580 * t279 * t281 * t229 * t30 * t284
  t595 = 0.14583333333333333333333333333333333333333333333334e-2 * t222 * t345 * t300 * t69 * t31 * t30 * t34 * t284
  t596 = t538 + 0.46666666666666666666666666666666666666666666666666e-1 * t539 - t546 + t550 + 0.35000000000000000000000000000000000000000000000000e-1 * t290 * t551 * t285 * t552 - 0.58333333333333333333333333333333333333333333333334e-2 * t561 + 0.58333333333333333333333333333333333333333333333334e-2 * t568 - 0.17500000000000000000000000000000000000000000000000e-1 * t290 * t292 * t285 * t531 + t578 - t587 - t595
  t602 = t355 * t328
  t608 = 0.35e2 / 0.432e3 * t221 * t580 * t24 * t321
  t609 = t365 * t369
  t610 = t609 * t373
  t613 = t316 * t24 * t238
  t622 = t596 * t328
  t626 = t376 * t273
  t627 = t626 * t384
  t630 = t377 * t415
  t632 = t626 * t419
  t636 = 0.1e1 / t381 / t338
  t637 = t636 * t341
  t639 = t380 * t637 * t345
  t640 = t405 ** 2
  t641 = t337 ** 2
  t642 = t640 * t641
  t648 = t380 * t383 * t412
  t649 = t648 * t408
  t652 = t380 * t383 * t346
  t654 = t422 * t29 * t348
  t656 = t337 * t249
  t661 = t104 ** 2
  t664 = t111 ** 2
  t665 = t97 ** 2
  t669 = 0.16081979498692535066756296899072713062105388428051e2 * t103 / t661 * t664 / t665
  t670 = t178 * t173
  t671 = 0.8e1 * t670
  t673 = 0.8e1 * t178 * t143
  t679 = 0.20000000000000000000000000000000000000000000000000e1 * t103 / t104 / t94 * t664 * t112
  t689 = 0.10000000000000000000000000000000000000000000000000e1 * t106 * (-0.42198333333333333333333333333333333333333333333333e0 * t477 + 0.84396666666666666666666666666666666666666666666666e0 * t480 + 0.39862222222222222222222222222222222222222222222223e0 * t483 + 0.68258333333333333333333333333333333333333333333333e-1 * t487 + 0.13651666666666666666666666666666666666666666666667e0 * t489 + 0.13692777777777777777777777777777777777777777777778e0 * t492) * t112
  t693 = 0.10843581300301739842632067522386578331157260943710e-1 * t28 * t32 * t38 * t395
  t695 = t157 * t29 * t164
  t696 = 0.36622894612013090109708692208757981924083909966068e-3 * t695
  t700 = 0.35616666666666666666666666666666666666666666666666e-1 * t303 * t37 * t105 * t113
  t711 = t85 ** 2
  t725 = t65 ** 2
  t728 = t58 ** 2
  t735 = 0.14764627977777777777777777777777777777777777777777e-2 * t32 * t482 * t98
  t754 = -0.70983522622222222222222222222222222222222222222221e-3 * t32 * t482 * t59 - 0.34246666666666666666666666666666666666666666666666e-1 * t303 * t37 * t66 * t87 - 0.20000000000000000000000000000000000000000000000000e1 * t64 / t65 / t55 * t711 * t86 + 0.10000000000000000000000000000000000000000000000000e1 * t67 * (-0.78438333333333333333333333333333333333333333333333e0 * t477 + 0.15687666666666666666666666666666666666666666666667e1 * t480 + 0.68863333333333333333333333333333333333333333333333e0 * t483 + 0.14025833333333333333333333333333333333333333333333e0 * t487 + 0.28051666666666666666666666666666666666666666666667e0 * t489 + 0.17365833333333333333333333333333333333333333333333e0 * t492) * t86 + 0.32163958997385070133512593798145426124210776856102e2 * t64 / t725 * t711 / t728 + t735 + t700 + t679 - t689 - t669 - 0.24415263074675393406472461472505321282722606644045e-3 * t32 * t482 * t124 - 0.10843581300301739842632067522386578331157260943710e-1 * t303 * t37 * t131 * t139 - 0.11696447245269292414524477327518106963944910680856e1 * t129 * t469 * t470 * t138 + 0.58482236226346462072622386637590534819724553404280e0 * t132 * t494 * t138 + 0.17315859105681463759666483083807725165579399831905e2 * t129 * t505 * t470 * t508
  t756 = t8 * t28 * t754
  t758 = t8 * t212 * t172
  t759 = t669 + t671 + t673 - t679 + t689 + t693 + t474 - t696 - t700 + t756 + t758
  t761 = t8 * t157 * t142
  t762 = 0.2e1 * t761
  t763 = t184 * t173
  t764 = 0.8e1 * t763
  t766 = 0.8e1 * t184 * t143
  t767 = t6 * t5
  t768 = 0.1e1 / t767
  t771 = 0.20e2 * t3 * t768 * t179
  t774 = 0.12e2 * t2 * t7 * t179
  t777 = 0.32e2 * t177 * t183 * t179
  t781 = 0.24415263074675393406472461472505321282722606644045e-3 * t162 * t70 * t277 * t124
  t782 = t762 - t764 - t766 - t498 - t511 - t514 + t771 + t774 - t777 + t214 - t735 + t781
  t788 = t273 * t422
  t796 = (-(t759 + t782) * t328 * t335 + 0.6e1 * t399 * t402 - 0.12e2 * t334 * t788 * t552 + 0.3e1 * t334 * t401 * t531) * t337
  t801 = t640 * t337
  t807 = 0.1e1 / t50 / t767
  t812 = 0.119e3 / 0.13824e5 * t343 * t807 * t279 * t238 * t350
  t814 = t380 * t418 * t412
  t815 = t814 * t426
  t820 = t279 / t237 / t225 * t29
  t829 = t608 + 0.7e1 / 0.72e2 * t610 + t613 * t371 * t33 * t552 / 0.16e2 - t370 * t371 * t33 * t531 / 0.48e2 + t622 * t342 * t351 / 0.3072e4 - t627 * t408 / 0.1536e4 - 0.7e1 / 0.2304e4 * t630 - t632 * t426 / 0.384e3 + t639 * t387 * t388 * t642 / 0.1536e4 + 0.7e1 / 0.2304e4 * t649 + t652 * t654 * t34 * t405 * t656 / 0.384e3 - t385 * t387 * t388 * t796 / 0.3072e4 - t385 * t387 * t388 * t801 / 0.3072e4 + t812 + 0.7e1 / 0.576e3 * t815 + 0.5e1 / 0.768e3 * t420 * t820 * t388 * t552 - t420 * t424 * t388 * t531 / 0.768e3
  t832 = t430 * t328
  t837 = t273 / t434 / t359
  t838 = t443 ** 2
  t847 = t636 * t354
  t851 = t382 * t429
  t870 = 0.10000000000000000000000000000000000000000000000000e1 * t223 * t768 * t230
  t871 = t234 * t250
  t878 = 0.23333333333333333333333333333333333333333333333333e0 * t223 / t35 / t767 * t227 * t261
  t879 = t422 * t229
  t881 = t224 * t879 * t552
  t884 = t255 * t238 * t259
  t887 = t884 * t249 * t29 * t70
  t890 = t224 * t239 * t531
  t901 = 0.17361111111111111111111111111111111111111111111111e-2 * t223 * t807 * t227 / t42 / t30 / t9 * t47 * t310
  t913 = t275 * t455
  t915 = t219 * t455
  t919 = t214 + 0.2e1 * t272 * t451 + 0.6e1 * t272 * t457 - t461 * t226 * t462 * t465 + t474 - t498 + 0.6e1 * t461 * t499 * t500 - t511 - t514 + 0.3e1 * t461 * t515 * t531 + t461 * t226 * (t596 * t354 * t361 + 0.2e1 * t315 * t429 * t361 - 0.2e1 * t602 * t444 + t327 * t829 * t361 - 0.2e1 * t832 * t444 + 0.2e1 * t433 * t837 * t838 - t433 * t436 * (t329 * t340 * t829 - 0.2e1 * t380 * t851 * t406 - t380 * t438 * t796 - t380 * t438 * t801 + 0.2e1 * t380 * t847 * t642 + t622 * t357 + 0.2e1 * t376 * t441 - 0.2e1 * t626 * t439)) * t449 + t693 - t679 + t689 + t233 * ((t870 + 0.12000000000000000000000000000000000000000000000000e1 * t871 - t878 + 0.60000000000000000000000000000000000000000000000000e0 * t881 - 0.15000000000000000000000000000000000000000000000000e0 * t887 - 0.15000000000000000000000000000000000000000000000000e0 * t890 + t901) * t265 + t264 * t249 * t281 - 0.20000000000000000000000000000000000000000000000000e0 * t871 - 0.20000000000000000000000000000000000000000000000000e0 * t881 + 0.25000000000000000000000000000000000000000000000000e-1 * t887 + 0.50000000000000000000000000000000000000000000000000e-1 * t890) * t271 * t913 + 0.6e1 * t461 * t915 * t552
  t920 = t268 ** 2
  t924 = t233 * t920 * t271 * t913 + t669 + t671 + t673 - t696 - t700 - t735 + t756 + t758 + t762 - t764 - t766 + t771 + t774 - t777 + t781
  t927 = 0.11696447245269292414524477327518106963944910680856e1 * t396
  t928 = t272 * t913
  t931 = t461 * t515 * t249
  t935 = t461 * t226 * t446 * t449
  d11 = t145 + 0.39503346997227602814966679236413104097888262435310e-1 * t159 + t161 - t166 + 0.2e1 * t174 + t176 + t181 - t186 + t4 * (t919 + t924) - t927 + 0.2e1 * t928 + 0.6e1 * t931 + 0.2e1 * t935
  t937 = -t9 - t147
  t940 = f.my_piecewise3(t12, 0, 0.4e1 / 0.3e1 * t15 * t937)
  t941 = -t937
  t944 = f.my_piecewise3(t19, 0, 0.4e1 / 0.3e1 * t20 * t941)
  t946 = (t940 + t944) * t27
  t947 = t946 * t158
  t948 = 0.19751673498613801407483339618206552048944131217655e-1 * t947
  t951 = f.my_piecewise3(t12, 0, 0.2e1 / 0.3e1 * t240 * t937)
  t954 = f.my_piecewise3(t19, 0, 0.2e1 / 0.3e1 * t244 * t941)
  t956 = t951 / 0.2e1 + t954 / 0.2e1
  t957 = t449 * t956
  t962 = t454 * t455 * t956
  t966 = t946 * t129 * t395
  t967 = 0.58482236226346462072622386637590534819724553404280e0 * t966
  t969 = t946 * t29 * t164
  t970 = 0.18311447306006545054854346104378990962041954983034e-3 * t969
  t971 = 0.58482236226346462072622386637590534819724553404280e0 * t513
  t973 = t239 * t956
  t974 = t234 * t973
  t979 = t224 * t422 * t229 * t956 * t249
  t983 = t884 * t956 * t29 * t70
  t992 = f.my_piecewise3(t12, 0, -0.2e1 / 0.9e1 * t516 * t937 * t148 + 0.4e1 / 0.3e1 * t240 * t1 * t193)
  t1000 = f.my_piecewise3(t19, 0, -0.2e1 / 0.9e1 * t523 * t941 * t152 - 0.4e1 / 0.3e1 * t244 * t1 * t193)
  t1002 = t992 / 0.2e1 + t1000 / 0.2e1
  t1004 = t224 * t239 * t1002
  t1009 = t224 * t973
  t1011 = -t236 - 0.15000000000000000000000000000000000000000000000000e0 * t1009 + t263
  t1014 = 0.20000000000000000000000000000000000000000000000000e0 * t974
  t1016 = 0.25000000000000000000000000000000000000000000000000e-1 * t983
  t1025 = t285 * t956
  t1026 = t292 * t1025
  t1029 = -t288 - 0.17500000000000000000000000000000000000000000000000e-1 * t290 * t1026 + t306 - t314
  t1030 = t1029 * t354
  t1032 = t33 * t956
  t1033 = t371 * t1032
  t1036 = t1029 * t328
  t1037 = t1036 * t342
  t1040 = t946 * t172
  t1041 = t8 * t1040
  t1043 = (t101 + t115 - t389 - t390 + t1041 + t144 + t948 - t392 - t397) * t328
  t1045 = t401 * t956
  t1048 = -t1043 * t335 + 0.3e1 * t334 * t1045
  t1049 = t1048 * t337
  t1051 = t387 * t388 * t1049
  t1055 = t424 * t388 * t956
  t1058 = -t368 - t370 * t1033 / 0.48e2 + t1037 * t351 / 0.3072e4 - t385 * t1051 / 0.3072e4 - t417 - t420 * t1055 / 0.768e3
  t1059 = t327 * t1058
  t1062 = t438 * t1049
  t1064 = t340 * t1058
  t1066 = t1036 * t357 - t380 * t1062 + t329 * t1064
  t1067 = t436 * t1066
  t1069 = t1030 * t361 + t1059 * t361 - t433 * t1067
  t1070 = t226 * t1069
  t1076 = t1011 * t265 + 0.50000000000000000000000000000000000000000000000000e-1 * t1009
  t1083 = t233 * t1076 * t271
  t1085 = t225 * t1069
  t1089 = t956 * t249
  t1096 = t275 * t1069 * t449
  t1105 = f.my_piecewise3(t12, 0, 0.4e1 / 0.9e1 * t188 * t937 * t148 + 0.8e1 / 0.3e1 * t15 * t1 * t193)
  t1113 = f.my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t202 * t941 * t152 - 0.8e1 / 0.3e1 * t20 * t1 * t193)
  t1115 = (t1105 + t1113) * t27
  t1117 = 0.19751673498613801407483339618206552048944131217655e-1 * t1115 * t158
  t1118 = 0.3e1 * t461 * t499 * t957 + 0.3e1 * t272 * t962 - t967 + t474 - t498 - t970 - t511 - t971 + t233 * ((t870 + 0.60000000000000000000000000000000000000000000000000e0 * t871 - t878 + 0.60000000000000000000000000000000000000000000000000e0 * t974 + 0.60000000000000000000000000000000000000000000000000e0 * t979 - 0.75000000000000000000000000000000000000000000000000e-1 * t983 - 0.15000000000000000000000000000000000000000000000000e0 * t1004 - 0.75000000000000000000000000000000000000000000000000e-1 * t887 + t901) * t265 + t1011 * t249 * t281 - t1014 - 0.20000000000000000000000000000000000000000000000000e0 * t979 + t1016 + 0.50000000000000000000000000000000000000000000000000e-1 * t1004) * t271 * t913 + 0.3e1 * t461 * t515 * t1002 - t461 * t1070 * t465 * t446 + t269 * t1076 * t271 * t274 * t226 * t455 + t1083 * t451 + 0.3e1 * t461 * t1085 * t500 + 0.6e1 * t461 * t915 * t1089 + 0.3e1 * t1083 * t457 + t272 * t1096 + t693 + t1117
  t1119 = 0.18311447306006545054854346104378990962041954983034e-3 * t695
  t1120 = 0.4e1 * t763
  t1121 = 0.4e1 * t670
  t1122 = t178 * t1040
  t1123 = 0.4e1 * t1122
  t1124 = t184 * t1040
  t1125 = 0.4e1 * t1124
  t1127 = t8 * t946 * t142
  t1129 = t8 * t1115 * t172
  t1131 = t280 * t1026
  t1140 = t559 * t1025 * t303
  t1144 = t564 * t49 * t565 * t956
  t1152 = t538 + 0.23333333333333333333333333333333333333333333333333e-1 * t539 - t546 + t550 + 0.23333333333333333333333333333333333333333333333333e-1 * t1131 + 0.35000000000000000000000000000000000000000000000000e-1 * t289 * t279 * t227 * t68 * t285 * t1089 - 0.29166666666666666666666666666666666666666666666667e-2 * t1140 + 0.29166666666666666666666666666666666666666666666667e-2 * t1144 - 0.17500000000000000000000000000000000000000000000000e-1 * t290 * t292 * t285 * t1002 - 0.29166666666666666666666666666666666666666666666667e-2 * t561 + t578 - t587 + 0.29166666666666666666666666666666666666666666666667e-2 * t568 - t595
  t1157 = t1030 * t328
  t1162 = t609 * t1033
  t1172 = t1152 * t328
  t1176 = t1036 * t273
  t1177 = t1176 * t384
  t1180 = t1037 * t415
  t1182 = t1176 * t419
  t1190 = t238 * t29 * t348
  t1191 = t34 * t1048
  t1192 = t641 * t405
  t1197 = t648 * t1051
  t1199 = t608 + 0.7e1 / 0.144e3 * t610 + 0.7e1 / 0.144e3 * t1162 + t613 * t371 * t1032 * t249 / 0.16e2 - t370 * t371 * t33 * t1002 / 0.48e2 + t1172 * t342 * t351 / 0.3072e4 - t1177 * t408 / 0.3072e4 - 0.7e1 / 0.4608e4 * t1180 - t1182 * t426 / 0.768e3 - t627 * t1051 / 0.3072e4 + t380 * t637 * t346 * t1190 * t1191 * t1192 / 0.1536e4 + 0.7e1 / 0.4608e4 * t1197
  t1204 = -t967 + t474 - t498 - t970 - t511 - t971 + t693 + t1117 - t679 + t689 + t771 - t774 - t1119
  t1205 = t781 - t700 - t766 + t761 - t1120 - t735 + t756 - t1121 + t669 + t1123 - t1125 + t1127 + t1129
  t1222 = (-(t1204 + t1205) * t328 * t335 + 0.3e1 * t1043 * t402 + 0.3e1 * t399 * t1045 - 0.12e2 * t334 * t273 * t422 * t956 * t249 + 0.3e1 * t334 * t401 * t1002) * t337
  t1241 = t814 * t1055
  t1251 = t652 * t654 * t1191 * t656 / 0.768e3 - t385 * t387 * t388 * t1222 / 0.3072e4 - t652 * t1190 * t1191 * t406 / 0.3072e4 - 0.7e1 / 0.4608e4 * t630 + 0.7e1 / 0.4608e4 * t649 + t812 + 0.7e1 / 0.1152e4 * t815 - t632 * t1055 / 0.768e3 + t652 * t654 * t34 * t956 * t406 / 0.768e3 + 0.7e1 / 0.1152e4 * t1241 + 0.5e1 / 0.768e3 * t420 * t820 * t388 * t1089 - t420 * t424 * t388 * t1002 / 0.768e3
  t1252 = t1199 + t1251
  t1255 = t1059 * t328
  t1269 = t354 * t1048
  t1282 = t382 * t1058
  t1287 = 0.2e1 * t329 * t273 * t636 * t1269 * t1192 - t329 * t273 * t382 * t1269 * t406 - t380 * t851 * t1049 - t380 * t438 * t1222 + t329 * t340 * t1252 - t380 * t1282 * t406 + t1036 * t441 - t626 * t1062 + t376 * t1064 + t1172 * t357 - t1176 * t439
  t1294 = -t679 + t689 + t771 - t774 - t1119 + t781 - t700 - t766 + t761 - t1120 - t735 + t756 - t1121 + t669 + t1123 - t1125 + t1127 + t1129 + t461 * t226 * (0.2e1 * t433 * t837 * t1066 * t443 + t1029 * t429 * t361 + t315 * t1058 * t361 + t1152 * t354 * t361 + t327 * t1252 * t361 - t433 * t436 * t1287 - t602 * t1067 - t832 * t1067 - t1157 * t444 - t1255 * t444) * t449
  t1299 = t461 * t1070 * t449
  t1300 = t1083 * t913
  t1302 = t461 * t515 * t956
  d12 = -t166 + t928 + t935 + t948 + t161 + t4 * (t1118 + t1294) + 0.3e1 * t931 + t176 - t186 + t391 + t1299 - t927 + t1300 + 0.3e1 * t1302 + t174 + t145 + t1041
  t1304 = t956 ** 2
  t1308 = t1076 ** 2
  t1314 = t224 * t879 * t1304
  t1317 = t937 ** 2
  t1321 = 0.2e1 * t146 + 0.2e1 * t194
  t1325 = f.my_piecewise3(t12, 0, -0.2e1 / 0.9e1 * t516 * t1317 + 0.2e1 / 0.3e1 * t240 * t1321)
  t1326 = t941 ** 2
  t1329 = -t1321
  t1333 = f.my_piecewise3(t19, 0, -0.2e1 / 0.9e1 * t523 * t1326 + 0.2e1 / 0.3e1 * t244 * t1329)
  t1335 = t1325 / 0.2e1 + t1333 / 0.2e1
  t1337 = t224 * t239 * t1335
  t1353 = t1069 ** 2
  t1371 = t538 + 0.46666666666666666666666666666666666666666666666666e-1 * t1131 - t546 + t550 + 0.35000000000000000000000000000000000000000000000000e-1 * t290 * t551 * t285 * t1304 - 0.58333333333333333333333333333333333333333333333334e-2 * t1140 + 0.58333333333333333333333333333333333333333333333334e-2 * t1144 - 0.17500000000000000000000000000000000000000000000000e-1 * t290 * t292 * t285 * t1335 + t578 - t587 - t595
  t1388 = t1371 * t328
  t1397 = t1048 ** 2
  t1398 = t1397 * t641
  t1409 = 0.36622894612013090109708692208757981924083909966068e-3 * t969
  t1415 = f.my_piecewise3(t12, 0, 0.4e1 / 0.9e1 * t188 * t1317 + 0.4e1 / 0.3e1 * t15 * t1321)
  t1421 = f.my_piecewise3(t19, 0, 0.4e1 / 0.9e1 * t202 * t1326 + 0.4e1 / 0.3e1 * t20 * t1329)
  t1423 = (t1415 + t1421) * t27
  t1425 = t8 * t1423 * t172
  t1426 = 0.2e1 * t1127
  t1427 = -t1409 + t474 - t679 + t756 + t1425 + t1426 - t735 - t700 + t771 + t777 + t693
  t1428 = 0.8e1 * t1122
  t1429 = 0.8e1 * t1124
  t1430 = 0.11696447245269292414524477327518106963944910680856e1 * t966
  t1432 = 0.19751673498613801407483339618206552048944131217655e-1 * t1423 * t158
  t1433 = -t1428 - t673 + t774 - t1429 - t766 - t498 - t511 + t689 + t669 + t781 - t1430 + t1432
  t1446 = (-(t1427 + t1433) * t328 * t335 + 0.6e1 * t1043 * t1045 - 0.12e2 * t334 * t788 * t1304 + 0.3e1 * t334 * t401 * t1335) * t337
  t1451 = t1397 * t337
  t1465 = t608 + 0.7e1 / 0.72e2 * t1162 + t613 * t371 * t33 * t1304 / 0.16e2 - t370 * t371 * t33 * t1335 / 0.48e2 + t1388 * t342 * t351 / 0.3072e4 - t1177 * t1051 / 0.1536e4 - 0.7e1 / 0.2304e4 * t1180 - t1182 * t1055 / 0.384e3 + t639 * t387 * t388 * t1398 / 0.1536e4 + 0.7e1 / 0.2304e4 * t1197 + t652 * t654 * t1191 * t337 * t956 / 0.384e3 - t385 * t387 * t388 * t1446 / 0.3072e4 - t385 * t387 * t388 * t1451 / 0.3072e4 + t812 + 0.7e1 / 0.576e3 * t1241 + 0.5e1 / 0.768e3 * t420 * t820 * t388 * t1304 - t420 * t424 * t388 * t1335 / 0.768e3
  t1470 = t1066 ** 2
  t1501 = 0.6e1 * t461 * t915 * t1304 + t233 * t1308 * t271 * t913 + t233 * ((t870 + 0.12000000000000000000000000000000000000000000000000e1 * t974 - t878 + 0.60000000000000000000000000000000000000000000000000e0 * t1314 - 0.15000000000000000000000000000000000000000000000000e0 * t983 - 0.15000000000000000000000000000000000000000000000000e0 * t1337 + t901) * t265 + t1011 * t956 * t281 - t1014 - 0.20000000000000000000000000000000000000000000000000e0 * t1314 + t1016 + 0.50000000000000000000000000000000000000000000000000e-1 * t1337) * t271 * t913 + 0.2e1 * t1083 * t1096 + 0.6e1 * t1083 * t962 - t461 * t226 * t1353 * t465 + 0.3e1 * t461 * t515 * t1335 + t461 * t226 * (t1371 * t354 * t361 + 0.2e1 * t1029 * t1058 * t361 - 0.2e1 * t1157 * t1067 + t327 * t1465 * t361 - 0.2e1 * t1255 * t1067 + 0.2e1 * t433 * t837 * t1470 - t433 * t436 * (-0.2e1 * t380 * t1282 * t1049 + 0.2e1 * t380 * t847 * t1398 - t380 * t438 * t1446 - t380 * t438 * t1451 + t329 * t340 * t1465 + 0.2e1 * t1036 * t1064 - 0.2e1 * t1176 * t1062 + t1388 * t357)) * t449 - t1430 + t474 - t498 - t1409 - t511 + t1425 + t1432 + 0.6e1 * t461 * t1085 * t957
  t1502 = t693 - t679 + t689 + t771 + t774 + t777 + t781 - t700 - t766 - t735 + t756 - t673 + t669 - t1428 - t1429 + t1426
  d22 = t4 * (t1501 + t1502) + 0.2e1 * t1299 - t166 + 0.39503346997227602814966679236413104097888262435310e-1 * t947 + t161 + 0.2e1 * t1300 + 0.6e1 * t1302 - t927 + t145 - t181 - t186 + 0.2e1 * t1041 + t176
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

