"""Generated from gga_c_zpbeint.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = lambda rs=None, t=None: params_beta

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = lambda rs=None, t=None: params_beta

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = lambda rs=None, t=None: params_beta

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = t43 ** 2
  t88 = t45 ** 2
  t89 = f.my_piecewise3(t42, t87, t88)
  t90 = t50 ** 2
  t91 = f.my_piecewise3(t49, t87, t90)
  t93 = t89 / 0.2e1 + t91 / 0.2e1
  t95 = s0 + 0.2e1 * s1 + s2
  t96 = jnp.sqrt(t95)
  t98 = params.alpha * t96 * t95
  t99 = t93 ** 2
  t100 = t99 * t93
  t101 = 0.1e1 / t100
  t104 = 0.1e1 / t14 / t11
  t108 = t93 ** (t98 * t37 * t101 * t104 / 0.16e2)
  t109 = jnp.log(0.2e1)
  t110 = 0.1e1 - t109
  t111 = t108 * t110
  t112 = jnp.pi ** 2
  t113 = 0.1e1 / t112
  t116 = 0.1e1 / t8 / t35
  t117 = t95 * t116
  t119 = 0.1e1 / t99
  t121 = 0.1e1 / t3
  t123 = t119 * t19 * t121 * t5
  t126 = 0.1e1 / t110
  t127 = params.beta * t126
  t129 = (-t31 + t84 + t86) * t126
  t130 = t112 * t101
  t132 = jnp.exp(-t129 * t130)
  t133 = t132 - 0.1e1
  t134 = 0.1e1 / t133
  t135 = t112 * t134
  t136 = t95 ** 2
  t138 = t127 * t135 * t136
  t140 = 0.1e1 / t22 / t36
  t141 = t54 ** 2
  t143 = t99 ** 2
  t144 = 0.1e1 / t143
  t146 = 0.1e1 / t20
  t148 = t1 * t146 * t6
  t149 = t140 * t141 * t144 * t148
  t152 = t117 * t54 * t123 / 0.96e2 + t138 * t149 / 0.3072e4
  t153 = params.beta * t152
  t157 = t127 * t135 * t152 + 0.1e1
  t159 = t126 * t112 / t157
  t161 = t153 * t159 + 0.1e1
  t162 = jnp.log(t161)
  t163 = t113 * t100 * t162
  t164 = t111 * t163
  t166 = 0.1e1 / t8 / t7
  t167 = t6 * t166
  t170 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t167 * t30
  t171 = t27 ** 2
  t176 = t3 * t6
  t177 = t176 * t166
  t178 = 0.1e1 / t14 * t1 * t177
  t180 = t4 * t167
  t182 = t11 ** 0.5e0
  t184 = t182 * t1 * t177
  t189 = t21 * t5 / t22 / t7
  t194 = t13 / t171 * (-0.39359271665000000000000000000000000000000000000000e-1 * t178 - 0.18590165886666666666666666666666666666666666666667e-1 * t180 - 0.63665980925000000000000000000000000000000000000000e-2 * t184 - 0.51086165526666666666666666666666666666666666666667e-2 * t189) / t29
  t198 = 0.4e1 * t33 * t32 * t37 * t83
  t199 = t36 * t7
  t200 = 0.1e1 / t199
  t203 = 0.4e1 * t34 * t200 * t83
  t205 = t32 / t35
  t206 = t39 - t205
  t209 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t206)
  t210 = -t206
  t213 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t210)
  t215 = (t209 + t213) * t57
  t217 = t38 * t215 * t82
  t221 = t65 ** 2
  t235 = t76 ** 2
  t236 = 0.1e1 / t235
  t242 = -0.29149603883333333333333333333333333333333333333333e-1 * t178 - 0.10197154565000000000000000000000000000000000000000e-1 * t180 - 0.18581078242500000000000000000000000000000000000000e-2 * t184 - 0.27959640330000000000000000000000000000000000000000e-2 * t189
  t243 = 0.1e1 / t78
  t249 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t167 * t68 + t60 / t221 * (-0.36580540352500000000000000000000000000000000000000e-1 * t178 - 0.16057569282500000000000000000000000000000000000000e-1 * t180 - 0.65410946462500000000000000000000000000000000000000e-2 * t184 - 0.32394954865000000000000000000000000000000000000000e-2 * t189) / t67 - t170 - t194 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t167 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t236 * t242 * t243)
  t251 = 0.58482236226346462072622386637590534819724553404281e0 * t215 * t80
  t256 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t176 * t166 * t79
  t261 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t236 * t242 * t243
  t265 = t98 * t200 * t101 * t104 / 0.4e1
  t266 = t98 * t37
  t267 = t144 * t104
  t268 = 0.1e1 / t45
  t271 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t268 * t206)
  t272 = 0.1e1 / t50
  t275 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t272 * t210)
  t277 = t271 / 0.2e1 + t275 / 0.2e1
  t279 = t266 * t267 * t277
  t291 = t98 / t8 / t199 * t101 / t14 / t25 * t1 * t176 / 0.128e3
  t293 = jnp.log(t93)
  t300 = t111 * t113
  t301 = t99 * t162
  t311 = 0.7e1 / 0.288e3 * t95 / t8 / t35 / t7 * t54 * t123
  t313 = t117 * t54 * t101
  t314 = t19 * t121
  t319 = t127 * t112
  t320 = t133 ** 2
  t321 = 0.1e1 / t320
  t324 = t319 * t321 * t136 * t140
  t326 = t141 * t144 * t1
  t327 = t146 * t6
  t331 = t112 * t144
  t336 = (-(t170 + t194 + t198 - t203 + t217 + t249 + t251 - t256 - t261) * t126 * t130 + 0.3e1 * t129 * t331 * t277) * t132
  t347 = 0.7e1 / 0.4608e4 * t138 / t22 / t199 * t141 * t144 * t148
  t350 = t319 * t134 * t136 * t140
  t354 = t141 / t143 / t93 * t1
  t359 = -t311 - t313 * t314 * t5 * t277 / 0.48e2 - t324 * t326 * t327 * t336 / 0.3072e4 - t347 - t350 * t354 * t327 * t277 / 0.768e3
  t362 = t153 * t126
  t363 = t157 ** 2
  t364 = 0.1e1 / t363
  t365 = t112 * t364
  t366 = t321 * t152
  t376 = 0.1e1 / t161
  t379 = t170 + t194 + t198 - t203 + t217 + t249 + t251 - t256 - t261 + t108 * ((-t265 - 0.3e1 / 0.16e2 * t279 + t291) * t293 + t279 / 0.16e2) * t110 * t163 + 0.3e1 * t300 * t301 * t277 + t300 * t100 * (params.beta * t359 * t159 - t362 * t365 * (t127 * t135 * t359 - t319 * t366 * t336)) * t376
  vrho_0_ = t7 * t379 + t164 - t31 + t84 + t86
  t381 = -t39 - t205
  t384 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t381)
  t385 = -t381
  t388 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t385)
  t390 = (t384 + t388) * t57
  t392 = t38 * t390 * t82
  t394 = 0.58482236226346462072622386637590534819724553404281e0 * t390 * t80
  t397 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t268 * t381)
  t400 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t272 * t385)
  t402 = t397 / 0.2e1 + t400 / 0.2e1
  t404 = t266 * t267 * t402
  t427 = (-(t170 + t194 - t198 - t203 + t392 + t249 + t394 - t256 - t261) * t126 * t130 + 0.3e1 * t129 * t331 * t402) * t132
  t436 = -t311 - t313 * t314 * t5 * t402 / 0.48e2 - t324 * t326 * t327 * t427 / 0.3072e4 - t347 - t350 * t354 * t327 * t402 / 0.768e3
  t450 = t170 + t194 - t198 - t203 + t392 + t249 + t394 - t256 - t261 + t108 * ((-t265 - 0.3e1 / 0.16e2 * t404 + t291) * t293 + t404 / 0.16e2) * t110 * t163 + 0.3e1 * t300 * t301 * t402 + t300 * t100 * (params.beta * t436 * t159 - t362 * t365 * (t127 * t135 * t436 - t319 * t366 * t427)) * t376
  vrho_1_ = t7 * t450 + t164 - t31 + t84 + t86
  t459 = t108 * params.alpha * t96 * t37 * t104 * t293 * t110 * t113 * t162
  t464 = t116 * t54 * t119 * t314 * t5
  t468 = t127 * t135 * t95 * t149
  t470 = t464 / 0.96e2 + t468 / 0.1536e4
  t473 = params.beta ** 2
  t475 = t110 ** 2
  t477 = t473 * t152 / t475
  t478 = t112 ** 2
  t479 = t478 * t364
  vsigma_0_ = t7 * (0.3e1 / 0.32e2 * t459 + t300 * t100 * (-t477 * t479 * t134 * t470 + params.beta * t470 * t159) * t376)
  t491 = t464 / 0.48e2 + t468 / 0.768e3
  vsigma_1_ = t7 * (0.3e1 / 0.16e2 * t459 + t300 * t100 * (-t477 * t479 * t134 * t491 + params.beta * t491 * t159) * t376)
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  mbeta = lambda rs=None, t=None: params_beta

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  ff = lambda z, t: f.mphi(z) ** (params_alpha * t ** 3)

  mgamma = params_gamma

  BB = params_BB

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + ff(z, tp(rs, z, xt)) * fH(rs, z, tp(rs, z, xt))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = t32 ** 2
  t56 = f.my_piecewise3(t31, t55, 1)
  t57 = jnp.sqrt(s0)
  t59 = params.alpha * t57 * s0
  t60 = r0 ** 2
  t61 = t60 ** 2
  t62 = 0.1e1 / t61
  t63 = t56 ** 2
  t64 = t63 * t56
  t65 = 0.1e1 / t64
  t68 = 0.1e1 / t13 / t10
  t72 = t56 ** (t59 * t62 * t65 * t68 / 0.16e2)
  t73 = jnp.log(0.2e1)
  t74 = 0.1e1 - t73
  t75 = t72 * t74
  t76 = jnp.pi ** 2
  t77 = 0.1e1 / t76
  t80 = 0.1e1 / t7 / t60
  t83 = 0.1e1 / t63
  t85 = 0.1e1 / t3
  t87 = t83 * t18 * t85 * t5
  t90 = 0.1e1 / t74
  t91 = params.beta * t90
  t96 = jnp.exp(-(-t30 + t54) * t90 * t76 * t65)
  t97 = t96 - 0.1e1
  t98 = 0.1e1 / t97
  t99 = t76 * t98
  t100 = s0 ** 2
  t102 = t91 * t99 * t100
  t104 = 0.1e1 / t21 / t61
  t105 = t37 ** 2
  t107 = t63 ** 2
  t108 = 0.1e1 / t107
  t110 = 0.1e1 / t19
  t112 = t1 * t110 * t6
  t113 = t104 * t105 * t108 * t112
  t116 = s0 * t80 * t37 * t87 / 0.96e2 + t102 * t113 / 0.3072e4
  t117 = params.beta * t116
  t121 = t91 * t99 * t116 + 0.1e1
  t123 = t90 * t76 / t121
  t125 = t117 * t123 + 0.1e1
  t126 = jnp.log(t125)
  t130 = 0.1e1 / t7 / r0
  t131 = t6 * t130
  t134 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t131 * t29
  t135 = t26 ** 2
  t140 = t3 * t6
  t141 = t140 * t130
  t142 = 0.1e1 / t13 * t1 * t141
  t144 = t4 * t131
  t146 = t10 ** 0.5e0
  t148 = t146 * t1 * t141
  t153 = t20 * t5 / t21 / r0
  t158 = t12 / t135 * (-0.39359271665000000000000000000000000000000000000000e-1 * t142 - 0.18590165886666666666666666666666666666666666666667e-1 * t144 - 0.63665980925000000000000000000000000000000000000000e-2 * t148 - 0.51086165526666666666666666666666666666666666666667e-2 * t153) / t28
  t163 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t140 * t130 * t51
  t165 = t48 ** 2
  t176 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t165 * (-0.29149603883333333333333333333333333333333333333333e-1 * t142 - 0.10197154565000000000000000000000000000000000000000e-1 * t144 - 0.18581078242500000000000000000000000000000000000000e-2 * t148 - 0.27959640330000000000000000000000000000000000000000e-2 * t153) / t50
  t177 = t61 * r0
  t196 = jnp.log(t56)
  t198 = t74 * t77
  t202 = t75 * t77
  t210 = t74 ** 2
  t211 = 0.1e1 / t210
  t212 = params.beta * t211
  t213 = t76 ** 2
  t215 = t97 ** 2
  t216 = 0.1e1 / t215
  t225 = t134 + t158 - t163 - t176
  t238 = -0.7e1 / 0.288e3 * s0 / t7 / t60 / r0 * t37 * t87 + t212 * t213 * t216 * t100 * t104 * t105 / t107 / t64 * t1 * t110 * t6 * t225 * t96 / 0.3072e4 - 0.7e1 / 0.4608e4 * t102 / t21 / t177 * t105 * t108 * t112
  t242 = t121 ** 2
  t243 = 0.1e1 / t242
  t258 = 0.1e1 / t125
  vrho_0_ = -t30 + t54 + t75 * t77 * t64 * t126 + r0 * (t134 + t158 - t163 - t176 + t72 * (-t59 / t177 * t65 * t68 / 0.4e1 + t59 / t7 / t177 * t65 / t13 / t24 * t1 * t140 / 0.128e3) * t196 * t198 * t64 * t126 + t202 * t64 * (params.beta * t238 * t123 - t117 * t90 * t76 * t243 * (t212 * t213 * t216 * t116 * t225 * t65 * t96 + t91 * t99 * t238)) * t258)
  t281 = t80 * t37 * t83 * t18 * t85 * t5 / 0.96e2 + t91 * t99 * s0 * t113 / 0.1536e4
  t284 = params.beta ** 2
  vsigma_0_ = r0 * (0.3e1 / 0.32e2 * t72 * params.alpha * t57 * t62 * t68 * t196 * t198 * t126 + t202 * t64 * (-t284 * t116 * t211 * t213 * t243 * t98 * t281 + params.beta * t281 * t123) * t258)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = t63 ** 2
  t103 = f.my_piecewise3(t62, t102, 1)
  t104 = jnp.sqrt(s0)
  t106 = params.alpha * t104 * s0
  t107 = r0 ** 2
  t108 = t107 ** 2
  t109 = 0.1e1 / t108
  t110 = t103 ** 2
  t111 = t110 * t103
  t112 = 0.1e1 / t111
  t115 = 0.1e1 / t14 / t13
  t119 = t103 ** (t106 * t109 * t112 * t115 / 0.16e2)
  t120 = t108 * r0
  t121 = 0.1e1 / t120
  t127 = 0.1e1 / t7 / t120
  t132 = 0.1e1 / t14 / t25 / 0.4e1
  t134 = t132 * t1 * t42
  t137 = -t106 * t121 * t112 * t115 / 0.4e1 + t106 * t127 * t112 * t134 / 0.32e2
  t138 = t119 * t137
  t139 = jnp.log(t103)
  t141 = jnp.log(0.2e1)
  t142 = 0.1e1 - t141
  t143 = jnp.pi ** 2
  t144 = 0.1e1 / t143
  t145 = t142 * t144
  t147 = 0.1e1 / t7 / t107
  t150 = 0.1e1 / t110
  t152 = 0.1e1 / t3
  t154 = t150 * t19 * t152 * t5
  t157 = 0.1e1 / t142
  t158 = params.beta * t157
  t168 = jnp.exp(-(-0.621814e-1 * t36 * t31 + 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82) * t157 * t143 * t112)
  t169 = t168 - 0.1e1
  t170 = 0.1e1 / t169
  t171 = t143 * t170
  t172 = s0 ** 2
  t174 = t158 * t171 * t172
  t176 = 0.1e1 / t22 / t108
  t177 = t68 ** 2
  t179 = t110 ** 2
  t180 = 0.1e1 / t179
  t182 = 0.1e1 / t20
  t184 = t1 * t182 * t6
  t185 = t176 * t177 * t180 * t184
  t188 = s0 * t147 * t68 * t154 / 0.96e2 + t174 * t185 / 0.3072e4
  t189 = params.beta * t188
  t193 = t158 * t171 * t188 + 0.1e1
  t194 = 0.1e1 / t193
  t195 = t157 * t143 * t194
  t197 = t189 * t195 + 0.1e1
  t198 = jnp.log(t197)
  t200 = t145 * t111 * t198
  t204 = t119 * t142 * t144
  t205 = t107 * r0
  t207 = 0.1e1 / t7 / t205
  t212 = t142 ** 2
  t213 = 0.1e1 / t212
  t214 = params.beta * t213
  t215 = t143 ** 2
  t216 = t214 * t215
  t217 = t169 ** 2
  t218 = 0.1e1 / t217
  t219 = t218 * t172
  t220 = t219 * t176
  t221 = t216 * t220
  t225 = t177 / t179 / t111 * t1
  t226 = t182 * t6
  t231 = 0.11073470983333333333333333333333333333333333333333e-2 * t33 + 0.10000000000000000000000000000000000000000000000000e1 * t60 - 0.18311447306006545054854346104378990962041954983034e-3 * t85 - 0.58482236226346462072622386637590534819724553404280e0 * t100
  t234 = t225 * t226 * t231 * t168
  t238 = 0.1e1 / t22 / t120
  t241 = t238 * t177 * t180 * t184
  t244 = -0.7e1 / 0.288e3 * s0 * t207 * t68 * t154 + t221 * t234 / 0.3072e4 - 0.7e1 / 0.4608e4 * t174 * t241
  t245 = params.beta * t244
  t247 = t189 * t157
  t248 = t193 ** 2
  t249 = 0.1e1 / t248
  t250 = t143 * t249
  t252 = t214 * t215 * t218
  t254 = t112 * t168
  t259 = t252 * t188 * t231 * t254 + t158 * t171 * t244
  t260 = t250 * t259
  t262 = t245 * t195 - t247 * t260
  t264 = 0.1e1 / t197
  t268 = t6 * t147
  t271 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t268 * t31
  t272 = t4 * t6
  t276 = 0.35616666666666666666666666666666666666666666666666e-1 * t272 * t9 * t38 * t59
  t280 = t57 ** 2
  t283 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t280 * t58
  t285 = t20 * t5
  t287 = 0.1e1 / t22 / t107
  t288 = t285 * t287
  t289 = t115 * t19 * t288
  t291 = t42 * t147
  t292 = t41 * t291
  t294 = t4 * t268
  t296 = t13 ** (-0.5e0)
  t298 = t296 * t19 * t288
  t300 = t49 * t291
  t303 = t21 * t5 * t287
  t308 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t289 + 0.84396666666666666666666666666666666666666666666666e0 * t292 + 0.39862222222222222222222222222222222222222222222223e0 * t294 + 0.68258333333333333333333333333333333333333333333333e-1 * t298 + 0.13651666666666666666666666666666666666666666666667e0 * t300 + 0.13692777777777777777777777777777777777777777777778e0 * t303) * t58
  t309 = t37 ** 2
  t312 = t30 ** 2
  t316 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t309 * t280 / t312
  t320 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t147 * t82
  t324 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t327 = t96 ** 2
  t331 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t327 * t98
  t342 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t289 + 0.11507777777777777777777777777777777777777777777778e1 * t292 + 0.40256666666666666666666666666666666666666666666667e0 * t294 + 0.36677500000000000000000000000000000000000000000000e-1 * t298 + 0.73355000000000000000000000000000000000000000000000e-1 * t300 + 0.13797500000000000000000000000000000000000000000000e0 * t303) * t98
  t343 = t90 ** 2
  t346 = t81 ** 2
  t350 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t343 * t327 / t346
  t351 = t137 ** 2
  t353 = t139 ** 2
  t356 = t108 * t107
  t369 = 0.1e1 / t22 / t356
  t385 = t139 * t142
  t386 = t138 * t385
  t387 = t144 * t111
  t399 = 0.1e1 / t212 / t142
  t400 = params.beta * t399
  t401 = t215 * t143
  t402 = t400 * t401
  t404 = 0.1e1 / t217 / t169
  t408 = t179 ** 2
  t412 = t177 / t408 / t110 * t1
  t413 = t231 ** 2
  t414 = t168 ** 2
  t424 = -t271 - t276 - t283 + t308 + t316 + t320 + t324 + t331 - t342 - t350
  t441 = 0.35e2 / 0.432e3 * s0 / t7 / t108 * t68 * t154 + t402 * t404 * t172 * t176 * t412 * t226 * t413 * t414 / 0.1536e4 - 0.7e1 / 0.2304e4 * t216 * t219 * t238 * t234 + t221 * t225 * t226 * t424 * t168 / 0.3072e4 - t402 * t220 * t412 * t226 * t413 * t168 / 0.3072e4 + 0.119e3 / 0.13824e5 * t174 * t369 * t177 * t180 * t184
  t448 = 0.1e1 / t248 / t193
  t450 = t259 ** 2
  t456 = t188 * t413
  t458 = 0.1e1 / t179 / t110
  t484 = t262 ** 2
  t486 = t197 ** 2
  t487 = 0.1e1 / t486
  t490 = -t271 - t276 - t283 + t308 + t316 + t320 + t324 + t331 - t342 - t350 + t119 * t351 * t353 * t200 + t119 * (0.5e1 / 0.4e1 * t106 / t356 * t112 * t115 - 0.7e1 / 0.24e2 * t106 / t7 / t356 * t112 * t134 + 0.5e1 / 0.2304e4 * t106 * t369 * t112 / t14 / t2 * r0 * t19 * t285) * t139 * t200 + 0.2e1 * t386 * t387 * t262 * t264 + t204 * t111 * (params.beta * t441 * t195 - 0.2e1 * t245 * t157 * t260 + 0.2e1 * t247 * t143 * t448 * t450 - t247 * t250 * (-t400 * t401 * t218 * t456 * t458 * t168 + 0.2e1 * t400 * t401 * t404 * t456 * t458 * t414 + t252 * t188 * t424 * t254 + 0.2e1 * t252 * t244 * t231 * t254 + t158 * t171 * t441)) * t264 - t204 * t111 * t484 * t487
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t138 * t139 * t200 + 0.2e1 * t204 * t111 * t262 * t264 + r0 * t490
  t492 = t119 * params.alpha
  t493 = t104 * t109
  t496 = t145 * t198
  t497 = t115 * t139 * t496
  t503 = t19 * t152 * t5
  t507 = t158 * t171 * s0
  t510 = t147 * t68 * t150 * t503 / 0.96e2 + t507 * t185 / 0.1536e4
  t511 = params.beta * t510
  t513 = params.beta ** 2
  t514 = t513 * t188
  t515 = t514 * t213
  t516 = t215 * t249
  t518 = t516 * t170 * t510
  t520 = t511 * t195 - t515 * t518
  t521 = t111 * t520
  t543 = t492 * t493 * t115
  t563 = -0.7e1 / 0.288e3 * t207 * t68 * t150 * t503 + t216 * t218 * s0 * t176 * t234 / 0.1536e4 - 0.7e1 / 0.2304e4 * t507 * t241
  v2rhosigma_0_ = 0.3e1 / 0.32e2 * t492 * t493 * t497 + t204 * t521 * t264 + r0 * (0.3e1 / 0.32e2 * t138 * t353 * params.alpha * t104 * t109 * t115 * t496 - 0.3e1 / 0.8e1 * t492 * t104 * t121 * t497 + 0.3e1 / 0.64e2 * t492 * t104 * t127 * t132 * t139 * t496 * t272 + 0.3e1 / 0.32e2 * t543 * t385 * t144 * t262 * t264 + t386 * t387 * t520 * t264 + t204 * t111 * (-t514 * t399 * t401 * t249 * t218 * t510 * t231 * t112 * t168 + 0.2e1 * t514 * t213 * t215 * t448 * t170 * t510 * t259 - t515 * t516 * t170 * t563 - t513 * t244 * t213 * t518 - t511 * t157 * t260 + params.beta * t563 * t195) * t264 - t204 * t521 * t487 * t262)
  t598 = params.alpha ** 2
  t630 = t510 ** 2
  t638 = t513 * params.beta * t188 * t399
  t653 = t520 ** 2
  v2sigma2_0_ = r0 * (0.3e1 / 0.16384e5 * t119 * t598 * s0 / t108 / t205 * t112 * t2 * t353 * t142 * t198 + 0.3e1 / 0.64e2 * t492 / t104 * t109 * t497 + 0.3e1 / 0.16e2 * t543 * t385 * t144 * t520 * t264 + t204 * t111 * (t513 * t213 * t215 * t170 * t176 * t177 * t180 * t1 * t226 * t194 / 0.1536e4 - 0.2e1 * t513 * t630 * t213 * t516 * t170 + 0.2e1 * t638 * t401 * t448 * t218 * t630 - t638 * t401 * t249 * t218 * t185 / 0.1536e4) * t264 - t204 * t111 * t653 * t487)
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t12 * t28
  t31 = 0.1e1 / t13 / t10
  t32 = t31 * t18
  t33 = t19 * t5
  t34 = r0 ** 2
  t36 = 0.1e1 / t21 / t34
  t37 = t33 * t36
  t38 = t32 * t37
  t41 = 0.1e1 / t13 * t1
  t42 = t3 * t6
  t44 = 0.1e1 / t7 / t34
  t45 = t42 * t44
  t46 = t41 * t45
  t48 = t6 * t44
  t49 = t4 * t48
  t51 = t10 ** (-0.5e0)
  t52 = t51 * t18
  t53 = t52 * t37
  t55 = t10 ** 0.5e0
  t56 = t55 * t1
  t57 = t56 * t45
  t60 = t20 * t5 * t36
  t62 = -0.42198333333333333333333333333333333333333333333333e0 * t38 + 0.84396666666666666666666666666666666666666666666666e0 * t46 + 0.39862222222222222222222222222222222222222222222223e0 * t49 + 0.68258333333333333333333333333333333333333333333333e-1 * t53 + 0.13651666666666666666666666666666666666666666666667e0 * t57 + 0.13692777777777777777777777777777777777777777777778e0 * t60
  t65 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t26
  t66 = 0.1e1 / t65
  t67 = t62 * t66
  t68 = t29 * t67
  t70 = t27 ** 2
  t71 = 0.1e1 / t70
  t72 = t12 * t71
  t74 = 0.1e1 / t7 / r0
  t75 = t42 * t74
  t76 = t41 * t75
  t78 = t6 * t74
  t79 = t4 * t78
  t81 = t56 * t75
  t86 = t20 * t5 / t21 / r0
  t88 = -0.63297500000000000000000000000000000000000000000000e0 * t76 - 0.29896666666666666666666666666666666666666666666667e0 * t79 - 0.10238750000000000000000000000000000000000000000000e0 * t81 - 0.82156666666666666666666666666666666666666666666667e-1 * t86
  t89 = t88 ** 2
  t90 = t65 ** 2
  t91 = 0.1e1 / t90
  t92 = t89 * t91
  t93 = t72 * t92
  t96 = 0.1e1 / t27 / t26
  t97 = t12 * t96
  t98 = t89 * t66
  t99 = t97 * t98
  t101 = jnp.log(t65)
  t103 = t4 * t48 * t101
  t105 = 0.1e1 <= f.p.zeta_threshold
  t106 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t108 = f.my_piecewise3(t105, t106 * f.p.zeta_threshold, 1)
  t111 = 2 ** (0.1e1 / 0.3e1)
  t115 = (0.2e1 * t108 - 0.2e1) / (0.2e1 * t111 - 0.2e1)
  t116 = t115 * t4
  t121 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t122 = t121 ** 2
  t123 = 0.1e1 / t122
  t128 = -0.86308333333333333333333333333333333333333333333334e0 * t76 - 0.30192500000000000000000000000000000000000000000000e0 * t79 - 0.55016250000000000000000000000000000000000000000000e-1 * t81 - 0.82785000000000000000000000000000000000000000000000e-1 * t86
  t132 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t121
  t133 = 0.1e1 / t132
  t134 = t123 * t128 * t133
  t136 = t116 * t78 * t134
  t139 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t140 = t115 * t139
  t147 = -0.57538888888888888888888888888888888888888888888889e0 * t38 + 0.11507777777777777777777777777777777777777777777778e1 * t46 + 0.40256666666666666666666666666666666666666666666667e0 * t49 + 0.36677500000000000000000000000000000000000000000000e-1 * t53 + 0.73355000000000000000000000000000000000000000000000e-1 * t57 + 0.13797500000000000000000000000000000000000000000000e0 * t60
  t149 = t123 * t147 * t133
  t150 = t140 * t149
  t152 = t122 ** 2
  t153 = 0.1e1 / t152
  t154 = t128 ** 2
  t156 = t132 ** 2
  t157 = 0.1e1 / t156
  t158 = t153 * t154 * t157
  t159 = t140 * t158
  t162 = 0.1e1 / t122 / t121
  t164 = t162 * t154 * t133
  t165 = t140 * t164
  t167 = t106 ** 2
  t168 = f.my_piecewise3(t105, t167, 1)
  t169 = jnp.sqrt(s0)
  t171 = params.alpha * t169 * s0
  t172 = t34 ** 2
  t173 = 0.1e1 / t172
  t174 = t168 ** 2
  t175 = t174 * t168
  t176 = 0.1e1 / t175
  t181 = t168 ** (t171 * t173 * t176 * t31 / 0.16e2)
  t182 = t172 * r0
  t189 = 0.1e1 / t7 / t182
  t194 = 0.1e1 / t13 / t24 / 0.4e1
  t196 = t194 * t1 * t42
  t199 = -t171 / t182 * t176 * t31 / 0.4e1 + t171 * t189 * t176 * t196 / 0.32e2
  t200 = t181 * t199
  t201 = jnp.log(t168)
  t202 = jnp.log(0.2e1)
  t203 = 0.1e1 - t202
  t204 = t201 * t203
  t205 = t200 * t204
  t206 = jnp.pi ** 2
  t207 = 0.1e1 / t206
  t208 = t207 * t175
  t209 = t34 * r0
  t211 = 0.1e1 / t7 / t209
  t218 = 0.1e1 / t174 * t18 / t3 * t5
  t221 = t203 ** 2
  t223 = params.beta / t221
  t224 = t206 ** 2
  t225 = t223 * t224
  t228 = jnp.log(t132)
  t233 = 0.1e1 / t203
  t237 = jnp.exp(-(-0.621814e-1 * t12 * t101 + 0.19751673498613801407483339618206552048944131217655e-1 * t115 * t139 * t228) * t233 * t206 * t176)
  t238 = t237 - 0.1e1
  t239 = t238 ** 2
  t240 = 0.1e1 / t239
  t241 = s0 ** 2
  t242 = t240 * t241
  t244 = 0.1e1 / t21 / t172
  t245 = t242 * t244
  t246 = t225 * t245
  t247 = t111 ** 2
  t248 = t174 ** 2
  t252 = t247 / t248 / t175 * t1
  t253 = 0.1e1 / t19
  t254 = t253 * t6
  t258 = t88 * t66
  t261 = t115 * t1
  t268 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t78 * t101 + 0.10000000000000000000000000000000000000000000000000e1 * t29 * t258 - 0.18311447306006545054854346104378990962041954983034e-3 * t261 * t42 * t74 * t228 - 0.58482236226346462072622386637590534819724553404280e0 * t140 * t134
  t269 = t268 * t237
  t271 = t252 * t254 * t269
  t274 = params.beta * t233
  t276 = t206 / t238
  t278 = t274 * t276 * t241
  t280 = 0.1e1 / t21 / t182
  t282 = 0.1e1 / t248
  t285 = t1 * t253 * t6
  t289 = -0.7e1 / 0.288e3 * s0 * t211 * t111 * t218 + t246 * t271 / 0.3072e4 - 0.7e1 / 0.4608e4 * t278 * t280 * t247 * t282 * t285
  t290 = params.beta * t289
  t296 = t244 * t247
  t301 = s0 * t44 * t111 * t218 / 0.96e2 + t278 * t296 * t282 * t285 / 0.3072e4
  t304 = t274 * t276 * t301 + 0.1e1
  t306 = t233 * t206 / t304
  t308 = params.beta * t301
  t309 = t308 * t233
  t310 = t304 ** 2
  t312 = t206 / t310
  t314 = t223 * t224 * t240
  t315 = t301 * t268
  t316 = t176 * t237
  t321 = t274 * t276 * t289 + t314 * t315 * t316
  t322 = t312 * t321
  t324 = t290 * t306 - t309 * t322
  t325 = t324 ** 2
  t327 = t308 * t306 + 0.1e1
  t328 = t327 ** 2
  t329 = 0.1e1 / t328
  t334 = t201 ** 2
  t335 = t334 * t203
  t337 = jnp.log(t327)
  t338 = t172 * t34
  t351 = 0.1e1 / t21 / t338
  t360 = 0.1e1 / t13 / t2 * r0 * t18 * t33 / 0.48e2
  t363 = 0.5e1 / 0.4e1 * t171 / t338 * t176 * t31 - 0.7e1 / 0.24e2 * t171 / t7 / t338 * t176 * t196 + 0.5e1 / 0.48e2 * t171 * t351 * t176 * t360
  t376 = params.beta / t221 / t203
  t377 = t224 * t206
  t378 = t376 * t377
  t380 = 0.1e1 / t239 / t238
  t381 = t380 * t241
  t382 = t381 * t244
  t384 = t248 ** 2
  t386 = 0.1e1 / t384 / t174
  t388 = t247 * t386 * t1
  t389 = t268 ** 2
  t390 = t237 ** 2
  t393 = t388 * t254 * t389 * t390
  t396 = t242 * t280
  t397 = t225 * t396
  t401 = t4 * t6
  t402 = t74 * t28
  t404 = t401 * t402 * t258
  t411 = t261 * t42 * t44 * t228
  t417 = -0.14764627977777777777777777777777777777777777777777e-2 * t103 - 0.35616666666666666666666666666666666666666666666666e-1 * t404 - 0.20000000000000000000000000000000000000000000000000e1 * t99 + 0.10000000000000000000000000000000000000000000000000e1 * t68 + 0.16081979498692535066756296899072713062105388428051e2 * t93 + 0.24415263074675393406472461472505321282722606644045e-3 * t411 + 0.10843581300301739842632067522386578331157260943710e-1 * t136 + 0.11696447245269292414524477327518106963944910680856e1 * t165 - 0.58482236226346462072622386637590534819724553404280e0 * t150 - 0.17315859105681463759666483083807725165579399831905e2 * t159
  t420 = t252 * t254 * t417 * t237
  t426 = t388 * t254 * t389 * t237
  t434 = 0.35e2 / 0.432e3 * s0 / t7 / t172 * t111 * t218 + t378 * t382 * t393 / 0.1536e4 - 0.7e1 / 0.2304e4 * t397 * t271 + t246 * t420 / 0.3072e4 - t378 * t245 * t426 / 0.3072e4 + 0.119e3 / 0.13824e5 * t278 * t351 * t247 * t282 * t285
  t435 = params.beta * t434
  t437 = t290 * t233
  t442 = t206 / t310 / t304
  t443 = t321 ** 2
  t444 = t442 * t443
  t448 = t376 * t377 * t380
  t449 = t301 * t389
  t451 = 0.1e1 / t248 / t174
  t452 = t451 * t390
  t460 = t301 * t417
  t464 = t376 * t377 * t240
  t465 = t451 * t237
  t470 = 0.2e1 * t314 * t289 * t268 * t316 + t274 * t276 * t434 + t314 * t460 * t316 + 0.2e1 * t448 * t449 * t452 - t464 * t449 * t465
  t471 = t312 * t470
  t473 = t435 * t306 + 0.2e1 * t309 * t444 - t309 * t471 - 0.2e1 * t437 * t322
  t474 = 0.1e1 / t327
  t479 = t181 * t363
  t482 = t208 * t324 * t474
  t485 = t199 ** 2
  t486 = t181 * t485
  t493 = 0.48245938496077605200268890697218139186316165284153e2 * t72 * t62 * t91 * t88
  t496 = 0.60000000000000000000000000000000000000000000000000e1 * t97 * t258 * t62
  t497 = t6 * t211
  t500 = 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t497 * t101
  t504 = t89 * t88
  t507 = 0.96491876992155210400537781394436278372632330568306e2 * t12 / t70 / t26 * t504 * t91
  t510 = t154 * t128
  t516 = 0.10254018858216406658218194626490193680059335835414e4 * t140 / t152 / t122 * t510 / t156 / t132
  t518 = t181 * t203 * t207
  t523 = t221 ** 2
  t525 = params.beta / t523
  t526 = t224 ** 2
  t527 = t525 * t526
  t528 = t239 ** 2
  t529 = 0.1e1 / t528
  t537 = t247 / t384 / t248 / t168 * t1
  t538 = t389 * t268
  t539 = t390 * t237
  t552 = t386 * t1 * t253
  t576 = 0.21687162600603479685264135044773156662314521887420e-1 * t116 * t48 * t134
  t579 = 0.16265371950452609763948101283579867496735891415565e-1 * t116 * t78 * t149
  t582 = 0.48159733137676571081572406076840235616767705782485e0 * t116 * t78 * t158
  t585 = 0.32530743900905219527896202567159734993471782831130e-1 * t116 * t78 * t164
  t590 = 0.51947577317044391278999449251423175496738199495715e2 * t140 * t153 * t147 * t157 * t128
  t593 = 0.60000000000000000000000000000000000000000000000000e1 * t72 * t504 * t66
  t601 = 0.51726012919273400298984252201052768390886626637712e3 * t12 / t70 / t27 * t504 / t90 / t65
  t602 = -t576 + t579 + t582 - t585 - t516 - t590 + t493 + t593 - t496 + t601 - t507
  t604 = t194 * t2 * t173
  t607 = 0.1e1 / t21 / t209
  t608 = t33 * t607
  t609 = t32 * t608
  t611 = t42 * t211
  t612 = t41 * t611
  t614 = t4 * t497
  t616 = t10 ** (-0.15e1)
  t618 = t616 * t2 * t173
  t620 = t52 * t608
  t622 = t56 * t611
  t625 = t20 * t5 * t607
  t630 = 0.10000000000000000000000000000000000000000000000000e1 * t29 * (-0.25319000000000000000000000000000000000000000000000e1 * t604 + 0.16879333333333333333333333333333333333333333333333e1 * t609 - 0.19692555555555555555555555555555555555555555555555e1 * t612 - 0.93011851851851851851851851851851851851851851851854e0 * t614 + 0.13651666666666666666666666666666666666666666666667e0 * t618 - 0.27303333333333333333333333333333333333333333333333e0 * t620 - 0.31853888888888888888888888888888888888888888888890e0 * t622 - 0.36514074074074074074074074074074074074074074074075e0 * t625) * t66
  t636 = 0.10389515463408878255799889850284635099347639899143e3 * t140 / t152 / t121 * t510 * t157
  t649 = 0.58482236226346462072622386637590534819724553404280e0 * t140 * t123 * (-0.34523333333333333333333333333333333333333333333333e1 * t604 + 0.23015555555555555555555555555555555555555555555556e1 * t609 - 0.26851481481481481481481481481481481481481481481482e1 * t612 - 0.93932222222222222222222222222222222222222222222223e0 * t614 + 0.73355000000000000000000000000000000000000000000000e-1 * t618 - 0.14671000000000000000000000000000000000000000000000e0 * t620 - 0.17116166666666666666666666666666666666666666666667e0 * t622 - 0.36793333333333333333333333333333333333333333333333e0 * t625) * t133
  t653 = 0.35089341735807877243573431982554320891834732042568e1 * t140 * t153 * t510 * t133
  t658 = 0.35089341735807877243573431982554320891834732042568e1 * t140 * t162 * t128 * t133 * t147
  t662 = 0.71233333333333333333333333333333333333333333333331e-1 * t401 * t44 * t28 * t258
  t665 = 0.53424999999999999999999999999999999999999999999999e-1 * t401 * t402 * t67
  t669 = 0.85917975471764868594145516183295969534298037676861e0 * t401 * t74 * t71 * t92
  t673 = 0.10685000000000000000000000000000000000000000000000e0 * t401 * t74 * t96 * t98
  t677 = 0.56968947174242584615102410102512416326352748836105e-3 * t261 * t42 * t211 * t228
  t678 = t630 + t636 - t649 + t500 - t653 + t658 + t662 - t665 - t669 + t673 - t677
  t679 = t602 + t678
  t698 = t172 * t209
  t700 = 0.1e1 / t21 / t698
  t706 = -0.455e3 / 0.1296e4 * s0 * t189 * t111 * t218 + t527 * t529 * t241 * t244 * t537 * t254 * t538 * t539 / 0.512e3 - 0.7e1 / 0.768e3 * t378 * t381 * t280 * t393 + t378 * t381 * t296 * t552 * t6 * t268 * t390 * t417 / 0.512e3 - t527 * t382 * t537 * t254 * t538 * t390 / 0.512e3 + 0.119e3 / 0.4608e4 * t225 * t242 * t351 * t271 - 0.7e1 / 0.1536e4 * t397 * t420 + 0.7e1 / 0.1536e4 * t378 * t396 * t426 + t246 * t252 * t254 * t679 * t237 / 0.3072e4 - t378 * t242 * t296 * t552 * t6 * t417 * t269 / 0.1024e4 + t527 * t245 * t537 * t254 * t538 * t237 / 0.3072e4 - 0.595e3 / 0.10368e5 * t278 * t700 * t247 * t282 * t285
  t716 = t310 ** 2
  t729 = t301 * t538
  t731 = 0.1e1 / t384 / t168
  t736 = t289 * t389
  t776 = t525 * t526 * t240 * t729 * t731 * t237 - 0.6e1 * t525 * t526 * t380 * t729 * t731 * t390 + 0.6e1 * t525 * t526 * t529 * t729 * t731 * t539 - 0.3e1 * t464 * t460 * t451 * t268 * t237 + 0.3e1 * t314 * t434 * t268 * t316 + 0.3e1 * t314 * t289 * t417 * t316 + t314 * t301 * t679 * t316 + 0.6e1 * t448 * t315 * t452 * t417 + t274 * t276 * t706 + 0.6e1 * t448 * t736 * t452 - 0.3e1 * t464 * t736 * t465
  t790 = -0.3e1 * t205 * t208 * t325 * t329 + 0.3e1 * t200 * t335 * t208 * t337 * t363 + 0.3e1 * t205 * t208 * t473 * t474 + 0.3e1 * t479 * t204 * t482 + 0.3e1 * t486 * t335 * t482 + t493 - t496 + t500 - t507 - t516 + t518 * t175 * (params.beta * t706 * t306 - 0.3e1 * t435 * t233 * t322 + 0.6e1 * t437 * t444 - 0.3e1 * t437 * t471 - 0.6e1 * t309 * t206 / t716 * t443 * t321 + 0.6e1 * t309 * t442 * t321 * t470 - t309 * t312 * t776) * t474 + t636 - t649 - t653 + 0.2e1 * t518 * t175 * t325 * t324 / t328 / t327 - t576
  t797 = t203 * t207 * t175 * t337
  t799 = t175 * t473
  t819 = t172 ** 2
  t836 = t579 + t582 - t585 + t630 + t181 * t485 * t199 * t334 * t201 * t797 - 0.3e1 * t518 * t799 * t329 * t324 + t181 * (-0.15e2 / 0.2e1 * t171 / t698 * t176 * t31 + 0.89e2 / 0.36e2 * t171 / t7 / t698 * t176 * t196 - 0.5e1 / 0.3e1 * t171 * t700 * t176 * t360 + 0.35e2 / 0.1152e4 * t171 / t819 * t176 / t13 / t1 / t3 / t78) * t201 * t797 - t590 + t658 + t662 - t665 - t669 + t673 - t677 + t593 + t601
  v3rho3_0_ = 0.30000000000000000000000000000000000000000000000000e1 * t68 + 0.48245938496077605200268890697218139186316165284153e2 * t93 - 0.60000000000000000000000000000000000000000000000000e1 * t99 - 0.44293883933333333333333333333333333333333333333332e-2 * t103 + 0.32530743900905219527896202567159734993471782831130e-1 * t136 - 0.17544670867903938621786715991277160445917366021284e1 * t150 - 0.51947577317044391278999449251423175496738199495715e2 * t159 + 0.35089341735807877243573431982554320891834732042568e1 * t165 + r0 * (t790 + t836) - 0.10685000000000000000000000000000000000000000000000e0 * t404 + 0.73245789224026180219417384417515963848167819932136e-3 * t411 + 0.3e1 * t486 * t334 * t797 + 0.3e1 * t479 * t201 * t797 + 0.3e1 * t518 * t799 * t474 - 0.3e1 * t518 * t175 * t325 * t329 + 0.6e1 * t205 * t482

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(t1, t3, 1)
  t5 = jnp.sqrt(s0)
  t7 = params.alpha * t5 * s0
  t8 = r0 ** 2
  t9 = t8 ** 2
  t10 = 0.1e1 / t9
  t11 = t4 ** 2
  t12 = t11 * t4
  t13 = 0.1e1 / t12
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = 0.1e1 / jnp.pi
  t17 = t16 ** (0.1e1 / 0.3e1)
  t18 = t15 * t17
  t19 = 4 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = r0 ** (0.1e1 / 0.3e1)
  t24 = t18 * t20 / t21
  t25 = jnp.sqrt(t24)
  t27 = 0.1e1 / t25 / t24
  t31 = t4 ** (t7 * t10 * t13 * t27 / 0.16e2)
  t32 = jnp.log(0.2e1)
  t33 = 0.1e1 - t32
  t35 = jnp.pi ** 2
  t36 = 0.1e1 / t35
  t37 = t31 * t33 * t36
  t38 = t9 * r0
  t40 = 0.1e1 / t21 / t38
  t42 = 2 ** (0.1e1 / 0.3e1)
  t45 = t15 ** 2
  t49 = 0.1e1 / t11 * t45 / t17 * t19
  t52 = t33 ** 2
  t53 = t52 ** 2
  t55 = params.beta / t53
  t56 = t35 ** 2
  t57 = t56 ** 2
  t58 = t55 * t57
  t60 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t24
  t63 = t24 ** 0.15e1
  t65 = t17 ** 2
  t66 = t45 * t65
  t67 = t21 ** 2
  t70 = t66 * t19 / t67
  t72 = 0.37978500000000000000000000000000000000000000000000e1 * t25 + 0.89690000000000000000000000000000000000000000000000e0 * t24 + 0.20477500000000000000000000000000000000000000000000e0 * t63 + 0.12323500000000000000000000000000000000000000000000e0 * t70
  t75 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t72
  t76 = jnp.log(t75)
  t80 = f.my_piecewise3(t1, t2 * f.p.zeta_threshold, 1)
  t86 = (0.2e1 * t80 - 0.2e1) / (0.2e1 * t42 - 0.2e1)
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t24
  t93 = 0.51785000000000000000000000000000000000000000000000e1 * t25 + 0.90577500000000000000000000000000000000000000000000e0 * t24 + 0.11003250000000000000000000000000000000000000000000e0 * t63 + 0.12417750000000000000000000000000000000000000000000e0 * t70
  t96 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t93
  t97 = jnp.log(t96)
  t102 = 0.1e1 / t33
  t106 = jnp.exp(-(-0.621814e-1 * t60 * t76 + 0.19751673498613801407483339618206552048944131217655e-1 * t86 * t88 * t97) * t102 * t35 * t13)
  t107 = t106 - 0.1e1
  t108 = t107 ** 2
  t109 = t108 ** 2
  t110 = 0.1e1 / t109
  t111 = s0 ** 2
  t112 = t110 * t111
  t114 = 0.1e1 / t67 / t9
  t115 = t112 * t114
  t117 = t42 ** 2
  t118 = t11 ** 2
  t120 = t118 ** 2
  t122 = 0.1e1 / t120 / t118 / t4
  t124 = t117 * t122 * t15
  t125 = 0.1e1 / t65
  t126 = t125 * t20
  t128 = 0.1e1 / t21 / r0
  t129 = t20 * t128
  t133 = t72 ** 2
  t134 = 0.1e1 / t133
  t135 = t60 * t134
  t137 = 0.1e1 / t25 * t15
  t138 = t17 * t20
  t139 = t138 * t128
  t140 = t137 * t139
  t142 = t18 * t129
  t144 = t24 ** 0.5e0
  t145 = t144 * t15
  t146 = t145 * t139
  t150 = t19 / t67 / r0
  t151 = t66 * t150
  t153 = -0.63297500000000000000000000000000000000000000000000e0 * t140 - 0.29896666666666666666666666666666666666666666666667e0 * t142 - 0.10238750000000000000000000000000000000000000000000e0 * t146 - 0.82156666666666666666666666666666666666666666666667e-1 * t151
  t154 = 0.1e1 / t75
  t155 = t153 * t154
  t158 = t86 * t15
  t163 = t86 * t88
  t164 = t93 ** 2
  t165 = 0.1e1 / t164
  t170 = -0.86308333333333333333333333333333333333333333333334e0 * t140 - 0.30192500000000000000000000000000000000000000000000e0 * t142 - 0.55016250000000000000000000000000000000000000000000e-1 * t146 - 0.82785000000000000000000000000000000000000000000000e-1 * t151
  t172 = 0.1e1 / t96
  t173 = t165 * t170 * t172
  t176 = 0.11073470983333333333333333333333333333333333333333e-2 * t18 * t129 * t76 + 0.10000000000000000000000000000000000000000000000000e1 * t135 * t155 - 0.18311447306006545054854346104378990962041954983034e-3 * t158 * t138 * t128 * t97 - 0.58482236226346462072622386637590534819724553404280e0 * t163 * t173
  t177 = t176 ** 2
  t178 = t177 * t176
  t179 = t106 ** 2
  t180 = t179 * t106
  t183 = t124 * t126 * t178 * t180
  t188 = params.beta / t52 / t33
  t189 = t56 * t35
  t190 = t188 * t189
  t192 = 0.1e1 / t108 / t107
  t193 = t192 * t111
  t195 = 0.1e1 / t67 / t38
  t196 = t193 * t195
  t199 = 0.1e1 / t120 / t11
  t201 = t117 * t199 * t15
  t204 = t201 * t126 * t177 * t179
  t207 = t114 * t117
  t208 = t193 * t207
  t209 = t190 * t208
  t211 = t199 * t15 * t125
  t212 = t20 * t176
  t214 = 0.1e1 / t21 / t8
  t215 = t20 * t214
  t219 = t18 * t20
  t220 = t128 * t134
  t224 = t133 * t72
  t225 = 0.1e1 / t224
  t226 = t60 * t225
  t227 = t153 ** 2
  t228 = t227 * t154
  t231 = t27 * t45
  t232 = t65 * t19
  t234 = 0.1e1 / t67 / t8
  t235 = t232 * t234
  t236 = t231 * t235
  t238 = t138 * t214
  t239 = t137 * t238
  t241 = t18 * t215
  t243 = t24 ** (-0.5e0)
  t244 = t243 * t45
  t245 = t244 * t235
  t247 = t145 * t238
  t250 = t66 * t19 * t234
  t252 = -0.42198333333333333333333333333333333333333333333333e0 * t236 + 0.84396666666666666666666666666666666666666666666666e0 * t239 + 0.39862222222222222222222222222222222222222222222223e0 * t241 + 0.68258333333333333333333333333333333333333333333333e-1 * t245 + 0.13651666666666666666666666666666666666666666666667e0 * t247 + 0.13692777777777777777777777777777777777777777777778e0 * t250
  t253 = t252 * t154
  t256 = t133 ** 2
  t257 = 0.1e1 / t256
  t258 = t60 * t257
  t259 = t75 ** 2
  t260 = 0.1e1 / t259
  t261 = t227 * t260
  t268 = t86 * t18
  t272 = t164 * t93
  t273 = 0.1e1 / t272
  t274 = t170 ** 2
  t276 = t273 * t274 * t172
  t285 = -0.57538888888888888888888888888888888888888888888889e0 * t236 + 0.11507777777777777777777777777777777777777777777778e1 * t239 + 0.40256666666666666666666666666666666666666666666667e0 * t241 + 0.36677500000000000000000000000000000000000000000000e-1 * t245 + 0.73355000000000000000000000000000000000000000000000e-1 * t247 + 0.13797500000000000000000000000000000000000000000000e0 * t250
  t287 = t165 * t285 * t172
  t290 = t164 ** 2
  t291 = 0.1e1 / t290
  t292 = t291 * t274
  t293 = t96 ** 2
  t294 = 0.1e1 / t293
  t295 = t292 * t294
  t298 = -0.14764627977777777777777777777777777777777777777777e-2 * t18 * t215 * t76 - 0.35616666666666666666666666666666666666666666666666e-1 * t219 * t220 * t155 - 0.20000000000000000000000000000000000000000000000000e1 * t226 * t228 + 0.10000000000000000000000000000000000000000000000000e1 * t135 * t253 + 0.16081979498692535066756296899072713062105388428051e2 * t258 * t261 + 0.24415263074675393406472461472505321282722606644045e-3 * t158 * t138 * t214 * t97 + 0.10843581300301739842632067522386578331157260943710e-1 * t268 * t129 * t173 + 0.11696447245269292414524477327518106963944910680856e1 * t163 * t276 - 0.58482236226346462072622386637590534819724553404280e0 * t163 * t287 - 0.17315859105681463759666483083807725165579399831905e2 * t163 * t295
  t299 = t179 * t298
  t301 = t211 * t212 * t299
  t304 = t193 * t114
  t308 = t124 * t126 * t178 * t179
  t312 = params.beta / t52
  t313 = t312 * t56
  t314 = 0.1e1 / t108
  t315 = t314 * t111
  t316 = t9 * t8
  t318 = 0.1e1 / t67 / t316
  t319 = t315 * t318
  t320 = t313 * t319
  t324 = t117 / t118 / t12 * t15
  t325 = t176 * t106
  t327 = t324 * t126 * t325
  t330 = t315 * t195
  t331 = t313 * t330
  t334 = t324 * t126 * t298 * t106
  t338 = t177 * t106
  t340 = t201 * t126 * t338
  t343 = t315 * t114
  t344 = t313 * t343
  t346 = t268 * t215 * t173
  t349 = t268 * t129 * t287
  t352 = t268 * t129 * t295
  t355 = t268 * t129 * t276
  t358 = t294 * t170
  t360 = t163 * t291 * t285 * t358
  t363 = 0.1e1 / t290 / t164
  t364 = t274 * t170
  t367 = 0.1e1 / t293 / t96
  t368 = t363 * t364 * t367
  t369 = t163 * t368
  t372 = 0.1e1 / t290 / t93
  t374 = t372 * t364 * t294
  t375 = t163 * t374
  t379 = 0.1e1 / t25 / t70 / 0.4e1
  t380 = t379 * t16
  t381 = t380 * t10
  t383 = t8 * r0
  t385 = 0.1e1 / t67 / t383
  t386 = t232 * t385
  t387 = t231 * t386
  t390 = 0.1e1 / t21 / t383
  t391 = t138 * t390
  t392 = t137 * t391
  t394 = t20 * t390
  t395 = t18 * t394
  t397 = t24 ** (-0.15e1)
  t398 = t397 * t16
  t399 = t398 * t10
  t401 = t244 * t386
  t403 = t145 * t391
  t406 = t66 * t19 * t385
  t408 = -0.34523333333333333333333333333333333333333333333333e1 * t381 + 0.23015555555555555555555555555555555555555555555556e1 * t387 - 0.26851481481481481481481481481481481481481481481482e1 * t392 - 0.93932222222222222222222222222222222222222222222223e0 * t395 + 0.73355000000000000000000000000000000000000000000000e-1 * t399 - 0.14671000000000000000000000000000000000000000000000e0 * t401 - 0.17116166666666666666666666666666666666666666666667e0 * t403 - 0.36793333333333333333333333333333333333333333333333e0 * t406
  t410 = t165 * t408 * t172
  t411 = t163 * t410
  t413 = t252 * t260
  t415 = t258 * t413 * t153
  t417 = t227 * t153
  t418 = t417 * t154
  t419 = t258 * t418
  t422 = t226 * t155 * t252
  t424 = -0.21687162600603479685264135044773156662314521887420e-1 * t346 + 0.16265371950452609763948101283579867496735891415565e-1 * t349 + 0.48159733137676571081572406076840235616767705782485e0 * t352 - 0.32530743900905219527896202567159734993471782831130e-1 * t355 - 0.51947577317044391278999449251423175496738199495715e2 * t360 - 0.10254018858216406658218194626490193680059335835414e4 * t369 + 0.10389515463408878255799889850284635099347639899143e3 * t375 - 0.58482236226346462072622386637590534819724553404280e0 * t411 + 0.48245938496077605200268890697218139186316165284153e2 * t415 + 0.60000000000000000000000000000000000000000000000000e1 * t419 - 0.60000000000000000000000000000000000000000000000000e1 * t422
  t426 = 0.1e1 / t256 / t133
  t427 = t60 * t426
  t429 = 0.1e1 / t259 / t75
  t430 = t417 * t429
  t431 = t427 * t430
  t434 = 0.1e1 / t256 / t72
  t435 = t60 * t434
  t436 = t417 * t260
  t437 = t435 * t436
  t447 = -0.25319000000000000000000000000000000000000000000000e1 * t381 + 0.16879333333333333333333333333333333333333333333333e1 * t387 - 0.19692555555555555555555555555555555555555555555555e1 * t392 - 0.93011851851851851851851851851851851851851851851854e0 * t395 + 0.13651666666666666666666666666666666666666666666667e0 * t399 - 0.27303333333333333333333333333333333333333333333333e0 * t401 - 0.31853888888888888888888888888888888888888888888890e0 * t403 - 0.36514074074074074074074074074074074074074074074075e0 * t406
  t448 = t447 * t154
  t449 = t135 * t448
  t452 = t18 * t394 * t76
  t455 = t291 * t364 * t172
  t456 = t163 * t455
  t459 = t172 * t285
  t461 = t163 * t273 * t170 * t459
  t463 = t214 * t134
  t465 = t219 * t463 * t155
  t468 = t219 * t220 * t253
  t470 = t128 * t257
  t472 = t219 * t470 * t261
  t476 = t219 * t128 * t225 * t228
  t480 = t158 * t138 * t390 * t97
  t482 = 0.51726012919273400298984252201052768390886626637712e3 * t431 - 0.96491876992155210400537781394436278372632330568306e2 * t437 + 0.10000000000000000000000000000000000000000000000000e1 * t449 + 0.34450798614814814814814814814814814814814814814813e-2 * t452 - 0.35089341735807877243573431982554320891834732042568e1 * t456 + 0.35089341735807877243573431982554320891834732042568e1 * t461 + 0.71233333333333333333333333333333333333333333333331e-1 * t465 - 0.53424999999999999999999999999999999999999999999999e-1 * t468 - 0.85917975471764868594145516183295969534298037676861e0 * t472 + 0.10685000000000000000000000000000000000000000000000e0 * t476 - 0.56968947174242584615102410102512416326352748836105e-3 * t480
  t483 = t424 + t482
  t486 = t324 * t126 * t483 * t106
  t489 = t315 * t207
  t490 = t190 * t489
  t491 = t20 * t298
  t493 = t211 * t491 * t325
  t499 = t124 * t126 * t178 * t106
  t502 = params.beta * t102
  t504 = t35 / t107
  t506 = t502 * t504 * t111
  t507 = t9 * t383
  t509 = 0.1e1 / t67 / t507
  t511 = 0.1e1 / t118
  t514 = t15 * t125 * t20
  t518 = -0.455e3 / 0.1296e4 * s0 * t40 * t42 * t49 + t58 * t115 * t183 / 0.512e3 - 0.7e1 / 0.768e3 * t190 * t196 * t204 + t209 * t301 / 0.512e3 - t58 * t304 * t308 / 0.512e3 + 0.119e3 / 0.4608e4 * t320 * t327 - 0.7e1 / 0.1536e4 * t331 * t334 + 0.7e1 / 0.1536e4 * t190 * t330 * t340 + t344 * t486 / 0.3072e4 - t490 * t493 / 0.1024e4 + t58 * t343 * t499 / 0.3072e4 - 0.595e3 / 0.10368e5 * t506 * t509 * t117 * t511 * t514
  t519 = params.beta * t518
  t529 = s0 * t214 * t42 * t49 / 0.96e2 + t506 * t207 * t511 * t514 / 0.3072e4
  t532 = t502 * t504 * t529 + 0.1e1
  t534 = t102 * t35 / t532
  t537 = 0.1e1 / t21 / t9
  t542 = t190 * t304
  t549 = t190 * t343
  t557 = 0.35e2 / 0.432e3 * s0 * t537 * t42 * t49 + t542 * t204 / 0.1536e4 - 0.7e1 / 0.2304e4 * t331 * t327 + t344 * t334 / 0.3072e4 - t549 * t340 / 0.3072e4 + 0.119e3 / 0.13824e5 * t506 * t318 * t117 * t511 * t514
  t558 = params.beta * t557
  t559 = t558 * t102
  t560 = t532 ** 2
  t562 = t35 / t560
  t564 = t312 * t56 * t314
  t565 = t529 * t176
  t566 = t13 * t106
  t575 = t195 * t117
  t580 = -0.7e1 / 0.288e3 * s0 * t390 * t42 * t49 + t344 * t327 / 0.3072e4 - 0.7e1 / 0.4608e4 * t506 * t575 * t511 * t514
  t583 = t502 * t504 * t580 + t564 * t565 * t566
  t584 = t562 * t583
  t587 = params.beta * t580
  t588 = t587 * t102
  t591 = t35 / t560 / t532
  t592 = t583 ** 2
  t593 = t591 * t592
  t597 = t188 * t189 * t192
  t598 = t529 * t177
  t600 = 0.1e1 / t118 / t11
  t601 = t600 * t179
  t605 = t580 * t176
  t609 = t529 * t298
  t613 = t188 * t189 * t314
  t614 = t600 * t106
  t619 = t502 * t504 * t557 + 0.2e1 * t564 * t605 * t566 + t564 * t609 * t566 + 0.2e1 * t597 * t598 * t601 - t613 * t598 * t614
  t620 = t562 * t619
  t623 = params.beta * t529
  t624 = t623 * t102
  t625 = t560 ** 2
  t627 = t35 / t625
  t629 = t627 * t592 * t583
  t633 = t591 * t583 * t619
  t637 = t55 * t57 * t110
  t638 = t529 * t178
  t640 = 0.1e1 / t120 / t4
  t641 = t640 * t180
  t645 = t580 * t177
  t649 = t601 * t298
  t654 = t55 * t57 * t192
  t655 = t640 * t179
  t663 = t580 * t298
  t670 = t529 * t483
  t674 = t600 * t176 * t106
  t679 = t55 * t57 * t314
  t680 = t640 * t106
  t685 = 0.3e1 * t564 * t557 * t176 * t566 + t502 * t504 * t518 + 0.3e1 * t564 * t663 * t566 + t564 * t670 * t566 + 0.6e1 * t597 * t565 * t649 + 0.6e1 * t597 * t645 * t601 - 0.3e1 * t613 * t609 * t674 - 0.3e1 * t613 * t645 * t614 + 0.6e1 * t637 * t638 * t641 - 0.6e1 * t654 * t638 * t655 + t679 * t638 * t680
  t686 = t562 * t685
  t688 = t519 * t534 - 0.3e1 * t559 * t584 + 0.6e1 * t588 * t593 - 0.3e1 * t588 * t620 - 0.6e1 * t624 * t629 + 0.6e1 * t624 * t633 - t624 * t686
  t689 = t12 * t688
  t691 = t623 * t534 + 0.1e1
  t692 = t691 ** 2
  t693 = 0.1e1 / t692
  t696 = t587 * t534 - t624 * t584
  t697 = t693 * t696
  t707 = 0.1e1 / t21 / t316
  t711 = t379 * t15 * t138
  t720 = 0.1e1 / t25 / t16 * r0 / 0.48e2
  t722 = t720 * t45 * t232
  t725 = 0.5e1 / 0.4e1 * t7 / t316 * t13 * t27 - 0.7e1 / 0.24e2 * t7 * t707 * t13 * t711 + 0.5e1 / 0.48e2 * t7 * t318 * t13 * t722
  t726 = t725 ** 2
  t728 = jnp.log(t4)
  t729 = t728 ** 2
  t731 = t33 * t36
  t732 = jnp.log(t691)
  t734 = t731 * t12 * t732
  t739 = 0.38527786510141256865257924861472188493414164625988e1 * t268 * t129 * t374
  t742 = 0.43374325201206959370528270089546313324629043774840e-1 * t268 * t215 * t287
  t745 = 0.12842595503380418955085974953824062831138054875329e1 * t268 * t215 * t295
  t748 = 0.21687162600603479685264135044773156662314521887420e-1 * t268 * t129 * t410
  t751 = 0.38025319932552508024225805073234468230220037056326e2 * t268 * t129 * t368
  t754 = 0.13012297560362087811158481026863893997388713132452e0 * t268 * t129 * t455
  t755 = t256 ** 2
  t758 = t227 ** 2
  t759 = t259 ** 2
  t763 = 0.24955700379505800914252936827276051226357058527653e5 * t60 / t755 * t758 / t759
  t764 = t252 ** 2
  t767 = 0.48245938496077605200268890697218139186316165284153e2 * t258 * t764 * t260
  t770 = 0.67471172535210825687488420139294265171645179205307e-1 * t268 * t394 * t173
  t773 = 0.86748650402413918741056540179092626649258087549680e-1 * t268 * t215 * t276
  t774 = t696 ** 2
  t777 = 0.1e1 / t692 / t691
  t784 = t558 * t534 - 0.2e1 * t588 * t584 + 0.2e1 * t624 * t593 - t624 * t620
  t789 = 0.1e1 / t38
  t798 = -t7 * t789 * t13 * t27 / 0.4e1 + t7 * t40 * t13 * t711 / 0.32e2
  t799 = t31 * t798
  t803 = 0.1e1 / t691
  t808 = t728 * t33
  t809 = t799 * t808
  t810 = t36 * t12
  t821 = 0.62071215503128080358781102641263322069063951965254e4 * t60 / t256 / t224 * t758 * t429
  t822 = 0.12e2 * t799 * t729 * t725 * t731 * t12 * t696 * t803 + 0.12e2 * t37 * t12 * t774 * t777 * t784 - 0.12e2 * t809 * t810 * t784 * t693 * t696 + 0.3e1 * t31 * t726 * t729 * t734 - 0.4e1 * t37 * t689 * t697 - t739 - t742 - t745 + t748 + t751 + t754 + t763 + t767 + t770 + t773 - t821
  t825 = 0.24000000000000000000000000000000000000000000000000e2 * t435 * t758 * t154
  t826 = t86 * t219
  t831 = 0.13012297560362087811158481026863893997388713132452e0 * t826 * t128 * t273 * t459 * t170
  t833 = t285 * t294
  t837 = 0.19263893255070628432628962430736094246707082312995e1 * t826 * t128 * t291 * t833 * t170
  t843 = t31 * t725 * t808
  t845 = t810 * t784 * t803
  t852 = 0.34367190188705947437658206473318387813719215070744e1 * t142 * t257 * t252 * t260 * t153
  t856 = 0.42740000000000000000000000000000000000000000000000e0 * t142 * t225 * t153 * t253
  t859 = 0.36000000000000000000000000000000000000000000000000e2 * t258 * t228 * t252
  t863 = 0.64327917994770140267025187596290852248421553712204e2 * t258 * t447 * t260 * t153
  t864 = t774 * t696
  t869 = t798 ** 2
  t870 = t869 ** 2
  t872 = t729 ** 2
  t877 = 0.80000000000000000000000000000000000000000000000000e1 * t226 * t155 * t447
  t880 = 0.57895126195293126240322668836661767023579398340984e3 * t435 * t413 * t227
  t881 = t20 * t537
  t884 = 0.11483599538271604938271604938271604938271604938271e-1 * t18 * t881 * t76
  t888 = 0.31035607751564040179390551320631661034531975982628e4 * t427 * t252 * t429 * t227
  t889 = t285 ** 2
  t893 = 0.35089341735807877243573431982554320891834732042568e1 * t163 * t273 * t889 * t172
  t896 = t274 ** 2
  t900 = 0.12304822629859687989861833551788232416071203002497e5 * t163 / t290 / t272 * t896 * t367
  t901 = t31 * t870 * t872 * t734 + 0.4e1 * t809 * t810 * t688 * t803 + 0.8e1 * t809 * t810 * t864 * t777 + 0.6e1 * t843 * t845 - t825 - t831 + t837 - t852 + t856 + t859 + t863 - t877 - t880 - t884 + t888 + t893 + t900
  t906 = 0.14035736694323150897429372793021728356733892817027e2 * t163 * t372 * t896 * t172
  t910 = 0.51947577317044391278999449251423175496738199495715e2 * t163 * t291 * t889 * t294
  t913 = t720 * t16 * t40 * t219
  t915 = t380 * t789
  t917 = t232 * t114
  t918 = t231 * t917
  t920 = t138 * t537
  t921 = t137 * t920
  t923 = t18 * t881
  t925 = t24 ** (-0.25e1)
  t928 = t925 * t16 * t40 * t219
  t930 = t398 * t789
  t932 = t244 * t917
  t934 = t145 * t920
  t937 = t66 * t19 * t114
  t943 = 0.58482236226346462072622386637590534819724553404280e0 * t163 * t165 * (-0.28769444444444444444444444444444444444444444444444e1 * t913 + 0.27618666666666666666666666666666666666666666666667e2 * t915 - 0.10229135802469135802469135802469135802469135802469e2 * t918 + 0.89504938271604938271604938271604938271604938271607e1 * t921 + 0.31310740740740740740740740740740740740740740740741e1 * t923 + 0.36677500000000000000000000000000000000000000000000e-1 * t928 - 0.58684000000000000000000000000000000000000000000000e0 * t930 + 0.65204444444444444444444444444444444444444444444445e0 * t932 + 0.57053888888888888888888888888888888888888888888890e0 * t934 + 0.13490888888888888888888888888888888888888888888889e1 * t937) * t172
  t948 = t9 ** 2
  t950 = 0.1e1 / t67 / t948
  t958 = params.beta / t53 / t33
  t959 = t57 * t35
  t960 = t958 * t959
  t962 = t120 ** 2
  t965 = t117 / t962 * t15
  t966 = t177 ** 2
  t980 = -t739 - t742 - t745 + t748 + t751 + t754 + t763 + t767 + t770 + t773 - t821
  t981 = -t825 - t831 + t837 - t852 + t856 + t859 + t863 - t877 - t880 - t884 + t888 + t893
  t996 = 0.10000000000000000000000000000000000000000000000000e1 * t135 * (-0.21099166666666666666666666666666666666666666666667e1 * t913 + 0.20255200000000000000000000000000000000000000000000e2 * t915 - 0.75019259259259259259259259259259259259259259259258e1 * t918 + 0.65641851851851851851851851851851851851851851851850e1 * t921 + 0.31003950617283950617283950617283950617283950617285e1 * t923 + 0.68258333333333333333333333333333333333333333333335e-1 * t928 - 0.10921333333333333333333333333333333333333333333333e1 * t930 + 0.12134814814814814814814814814814814814814814814815e1 * t932 + 0.10617962962962962962962962962962962962962962962963e1 * t934 + 0.13388493827160493827160493827160493827160493827161e1 * t937) * t154
  t999 = 0.57895126195293126240322668836661767023579398340984e3 * t427 * t758 * t260
  t1002 = 0.60000000000000000000000000000000000000000000000000e1 * t226 * t764 * t154
  t1006 = 0.18989649058080861538367470034170805442117582945368e-2 * t158 * t138 * t537 * t97
  t1010 = 0.28493333333333333333333333333333333333333333333333e0 * t219 * t214 * t225 * t228
  t1014 = 0.68734380377411894875316412946636775627438430141488e1 * t219 * t128 * t434 * t436
  t1017 = 0.71233333333333333333333333333333333333333333333332e-1 * t219 * t220 * t448
  t1018 = t900 + t906 - t910 - t943 + t996 + t999 - t1002 + t1006 - t1010 + t1014 - t1017
  t1022 = 0.22161481481481481481481481481481481481481481481481e0 * t219 * t390 * t134 * t155
  t1026 = 0.36846163202829085479643115651216588683774907041596e2 * t219 * t128 * t426 * t430
  t1030 = 0.22911460125803964958438804315545591875812810047162e1 * t219 * t214 * t257 * t261
  t1033 = 0.14246666666666666666666666666666666666666666666666e0 * t219 * t463 * t253
  t1037 = 0.69263436422725855038665932335230900662317599327620e2 * t163 * t291 * t408 * t358
  t1042 = 0.61524113149298439949309167758941162080356015012483e4 * t163 * t363 * t274 * t367 * t285
  t1046 = 0.62337092780453269534799339101707810596085839394858e3 * t163 * t372 * t274 * t833
  t1051 = 0.46785788981077169658097909310072427855779642723424e1 * t163 * t273 * t408 * t172 * t170
  t1054 = 0.21053605041484726346144059189532592535100839225540e2 * t163 * t292 * t459
  t1057 = 0.42740000000000000000000000000000000000000000000000e0 * t219 * t470 * t418
  t1058 = t290 ** 2
  t1061 = t293 ** 2
  t1065 = 0.91082604192152556048340974007871726131433263376469e5 * t163 / t1058 * t896 / t1061
  t1069 = 0.62337092780453269534799339101707810596085839394858e3 * t163 * t363 * t896 * t294
  t1070 = -t1022 - t1026 + t1030 + t1033 - t1037 - t1042 + t1046 + t1051 - t1054 - t1057 - t1065 - t1069
  t1072 = t980 + t981 + t1018 + t1070
  t1079 = 0.1e1 / t109 / t107
  t1083 = t179 ** 2
  t1106 = -0.595e3 / 0.2592e4 * t313 * t315 * t509 * t327 + 0.13685e5 / 0.31104e5 * t506 * t950 * t117 * t511 * t514 - t960 * t343 * t965 * t126 * t966 * t106 / 0.3072e4 - 0.119e3 / 0.2304e4 * t190 * t319 * t340 - 0.7e1 / 0.1152e4 * t331 * t486 - 0.7e1 / 0.1152e4 * t58 * t330 * t499 + t344 * t324 * t126 * t1072 * t106 / 0.3072e4 + t960 * t1079 * t111 * t114 * t965 * t126 * t966 * t1083 / 0.128e3 - 0.3e1 / 0.256e3 * t960 * t115 * t965 * t126 * t966 * t180 + 0.7e1 / 0.192e3 * t58 * t196 * t308 + 0.7e1 / 0.1536e4 * t960 * t304 * t965 * t126 * t966 * t179 + 0.119e3 / 0.2304e4 * t320 * t334
  t1107 = t298 ** 2
  t1115 = t122 * t15 * t125
  t1129 = t20 * t177
  t1168 = -t549 * t201 * t126 * t1107 * t106 / 0.1024e4 + t58 * t489 * t1115 * t491 * t338 / 0.512e3 + 0.7e1 / 0.384e3 * t190 * t315 * t575 * t493 + 0.455e3 / 0.243e3 * s0 * t707 * t42 * t49 - 0.3e1 / 0.256e3 * t58 * t208 * t1115 * t1129 * t299 - t490 * t211 * t20 * t483 * t325 / 0.768e3 - 0.7e1 / 0.192e3 * t58 * t112 * t195 * t183 + 0.3e1 / 0.256e3 * t58 * t112 * t207 * t1115 * t1129 * t180 * t298 + 0.119e3 / 0.1152e4 * t190 * t193 * t318 * t204 - 0.7e1 / 0.192e3 * t190 * t193 * t575 * t301 + t542 * t201 * t126 * t1107 * t179 / 0.512e3 + t209 * t211 * t212 * t179 * t483 / 0.384e3
  t1169 = t1106 + t1168
  t1188 = t592 ** 2
  t1196 = t619 ** 2
  t1204 = t580 * t178
  t1210 = t529 * t966
  t1212 = 0.1e1 / t120 / t118
  t1223 = t557 * t177
  t1249 = 0.24e2 * t637 * t1204 * t641 + 0.24e2 * t958 * t959 * t1079 * t1210 * t1212 * t1083 - 0.36e2 * t958 * t959 * t110 * t1210 * t1212 * t180 + 0.12e2 * t597 * t1223 * t601 - 0.24e2 * t654 * t1204 * t655 + 0.4e1 * t679 * t1204 * t680 + 0.4e1 * t564 * t580 * t483 * t566 + t564 * t529 * t1072 * t566 + t502 * t504 * t1169 + 0.6e1 * t564 * t557 * t298 * t566 - 0.6e1 * t613 * t1223 * t614
  t1265 = t529 * t1107
  t1298 = 0.14e2 * t958 * t959 * t192 * t1210 * t1212 * t179 + 0.4e1 * t564 * t518 * t176 * t566 - t958 * t959 * t314 * t1210 * t1212 * t106 - 0.3e1 * t613 * t1265 * t614 + 0.6e1 * t679 * t609 * t640 * t177 * t106 - 0.4e1 * t613 * t670 * t674 - 0.12e2 * t613 * t663 * t674 + 0.8e1 * t597 * t565 * t601 * t483 - 0.36e2 * t654 * t598 * t655 * t298 + 0.24e2 * t597 * t605 * t649 + 0.6e1 * t597 * t1265 * t601 + 0.36e2 * t637 * t598 * t641 * t298
  t1302 = params.beta * t1169 * t534 - 0.4e1 * t519 * t102 * t584 + 0.12e2 * t559 * t593 - 0.6e1 * t559 * t620 - 0.24e2 * t588 * t629 + 0.24e2 * t588 * t633 - 0.4e1 * t588 * t686 + 0.24e2 * t624 * t35 / t625 / t532 * t1188 - 0.36e2 * t624 * t627 * t592 * t619 + 0.6e1 * t624 * t591 * t1196 + 0.8e1 * t624 * t591 * t583 * t685 - t624 * t562 * (t1249 + t1298)
  t1306 = t784 ** 2
  t1311 = t37 * t12 * t1302 * t803 - 0.3e1 * t37 * t12 * t1306 * t693 - t1002 + t1006 - t1010 + t1014 - t1017 - t1022 - t1026 + t1030 + t1033 + t906 - t910 - t943 + t996 + t999
  t1312 = t31 * t869
  t1313 = t729 * t33
  t1314 = t1312 * t1313
  t1317 = t774 ** 2
  t1319 = t692 ** 2
  t1325 = t31 * t869 * t798
  t1326 = t729 * t728
  t1327 = t1326 * t33
  t1330 = t810 * t696 * t803
  t1334 = t810 * t774 * t693
  t1352 = 0.1e1 / t948
  t1361 = t13 / t25 / t15 / t17 / t129 / 0.48e2
  t1364 = -0.15e2 / 0.2e1 * t7 / t507 * t13 * t27 + 0.89e2 / 0.36e2 * t7 / t21 / t507 * t13 * t711 - 0.5e1 / 0.3e1 * t7 * t509 * t13 * t722 + 0.35e2 / 0.24e2 * t7 * t1352 * t1361
  t1365 = t31 * t1364
  t1371 = t810 * t732 * t725
  t1376 = t799 * t1313
  t1395 = t948 * r0
  t1418 = -t1037 - t1042 + t1046 + t1051 - t1054 - t1057 + 0.6e1 * t1314 * t845 - 0.6e1 * t37 * t12 * t1317 / t1319 - t1065 - t1069 + 0.4e1 * t1325 * t1327 * t1330 - 0.6e1 * t843 * t1334 + 0.4e1 * t1365 * t808 * t1330 + 0.6e1 * t1312 * t1327 * t1371 - 0.6e1 * t1314 * t1334 + 0.4e1 * t1376 * t810 * t732 * t1364 + t31 * (0.105e3 / 0.2e1 * t7 * t1352 * t13 * t27 - 0.2363e4 / 0.108e3 * t7 / t21 / t948 * t13 * t711 + 0.1135e4 / 0.54e2 * t7 * t950 * t13 * t722 - 0.35e2 * t7 / t1395 * t1361 + 0.35e2 / 0.3072e4 * t7 / t21 / t1395 * t13 / t25 / t45 / t65 / t150 * t219) * t728 * t734
  t1446 = r0 * (t822 + t901 + t1311 + t1418) - 0.86748650402413918741056540179092626649258087549680e-1 * t346 + 0.65061487801810439055792405134319469986943565662260e-1 * t349 + 0.19263893255070628432628962430736094246707082312994e1 * t352 - 0.13012297560362087811158481026863893997388713132452e0 * t355 + 0.13780319445925925925925925925925925925925925925925e-1 * t452 + 0.19298375398431042080107556278887255674526466113661e3 * t415 - 0.24000000000000000000000000000000000000000000000000e2 * t422 + 0.4e1 * t37 * t689 * t803 + 0.24000000000000000000000000000000000000000000000000e2 * t419 - 0.12e2 * t809 * t1334 + 0.12e2 * t809 * t845 + 0.20690405167709360119593700880421107356354650655085e4 * t431 - 0.38596750796862084160215112557774511349052932227323e3 * t437 - 0.12e2 * t37 * t12 * t784 * t697 + 0.4e1 * t1365 * t728 * t734
  t1472 = 0.4e1 * t1325 * t1326 * t734 + 0.12e2 * t1376 * t1371 + 0.8e1 * t37 * t12 * t864 * t777 + 0.40000000000000000000000000000000000000000000000000e1 * t449 - 0.20779030926817756511599779700569270198695279798286e3 * t360 + 0.14035736694323150897429372793021728356733892817027e2 * t461 + 0.28493333333333333333333333333333333333333333333333e0 * t465 - 0.21370000000000000000000000000000000000000000000000e0 * t468 - 0.34367190188705947437658206473318387813719215070744e1 * t472 + 0.42740000000000000000000000000000000000000000000000e0 * t476 - 0.22787578869697033846040964041004966530541099534442e-2 * t480 - 0.41016075432865626632872778505960774720237343341655e4 * t369 + 0.41558061853635513023199559401138540397390559596572e3 * t375 - 0.23392894490538584829048954655036213927889821361712e1 * t411 - 0.14035736694323150897429372793021728356733892817027e2 * t456 + 0.12e2 * t1314 * t1330 + 0.12e2 * t843 * t1330
  v4rho4_0_ = t1446 + t1472

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = t5 ** (0.1e1 / 0.3e1)
  t8 = t2 ** 2
  t9 = 0.1e1 / t8
  t10 = t1 * t9
  t11 = t3 - t10
  t14 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t11)
  t15 = 0.1e1 - t4
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = -t11
  t21 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t18)
  t23 = 2 ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t27 = (t14 + t21) * t26
  t28 = 3 ** (0.1e1 / 0.3e1)
  t29 = 0.1e1 / jnp.pi
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t28 * t30
  t32 = 4 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t2 ** (0.1e1 / 0.3e1)
  t37 = t31 * t33 / t34
  t39 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t37
  t40 = jnp.sqrt(t37)
  t43 = t37 ** 0.15e1
  t45 = t28 ** 2
  t46 = t30 ** 2
  t47 = t45 * t46
  t48 = t34 ** 2
  t51 = t47 * t32 / t48
  t53 = 0.51785000000000000000000000000000000000000000000000e1 * t40 + 0.90577500000000000000000000000000000000000000000000e0 * t37 + 0.11003250000000000000000000000000000000000000000000e0 * t43 + 0.12417750000000000000000000000000000000000000000000e0 * t51
  t56 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t53
  t57 = jnp.log(t56)
  t58 = t39 * t57
  t59 = t27 * t58
  t62 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t37
  t67 = 0.37978500000000000000000000000000000000000000000000e1 * t40 + 0.89690000000000000000000000000000000000000000000000e0 * t37 + 0.20477500000000000000000000000000000000000000000000e0 * t43 + 0.12323500000000000000000000000000000000000000000000e0 * t51
  t68 = t67 ** 2
  t69 = 0.1e1 / t68
  t70 = t62 * t69
  t72 = 0.1e1 / t40 * t28
  t73 = t30 * t33
  t75 = 0.1e1 / t34 / t2
  t76 = t73 * t75
  t77 = t72 * t76
  t79 = t33 * t75
  t80 = t31 * t79
  t82 = t37 ** 0.5e0
  t83 = t82 * t28
  t84 = t83 * t76
  t89 = t47 * t32 / t48 / t2
  t91 = -0.63297500000000000000000000000000000000000000000000e0 * t77 - 0.29896666666666666666666666666666666666666666666667e0 * t80 - 0.10238750000000000000000000000000000000000000000000e0 * t84 - 0.82156666666666666666666666666666666666666666666667e-1 * t89
  t94 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t67
  t95 = 0.1e1 / t94
  t96 = t91 * t95
  t97 = t70 * t96
  t98 = 0.20000000000000000000000000000000000000000000000000e1 * t97
  t99 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t100 = t99 * f.p.zeta_threshold
  t101 = t7 * t5
  t102 = f.my_piecewise3(t6, t100, t101)
  t103 = t17 * t15
  t104 = f.my_piecewise3(t16, t100, t103)
  t106 = (t102 + t104 - 0.2e1) * t26
  t107 = t106 * t28
  t109 = t73 * t75 * t57
  t110 = t107 * t109
  t111 = 0.36622894612013090109708692208757981924083909966068e-3 * t110
  t112 = t1 ** 2
  t113 = t112 ** 2
  t114 = t8 ** 2
  t115 = 0.1e1 / t114
  t116 = t113 * t115
  t121 = 0.70594500000000000000000000000000000000000000000000e1 * t40 + 0.15494250000000000000000000000000000000000000000000e1 * t37 + 0.42077500000000000000000000000000000000000000000000e0 * t43 + 0.15629250000000000000000000000000000000000000000000e0 * t51
  t124 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t121
  t125 = jnp.log(t124)
  t130 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t37
  t131 = t121 ** 2
  t132 = 0.1e1 / t131
  t133 = t130 * t132
  t138 = -0.11765750000000000000000000000000000000000000000000e1 * t77 - 0.51647500000000000000000000000000000000000000000000e0 * t80 - 0.21038750000000000000000000000000000000000000000000e0 * t84 - 0.10419500000000000000000000000000000000000000000000e0 * t89
  t139 = 0.1e1 / t124
  t140 = t138 * t139
  t143 = jnp.log(t94)
  t145 = t31 * t79 * t143
  t146 = 0.11073470983333333333333333333333333333333333333333e-2 * t145
  t147 = 0.10000000000000000000000000000000000000000000000000e1 * t97
  t151 = t53 ** 2
  t152 = 0.1e1 / t151
  t153 = t39 * t152
  t158 = -0.86308333333333333333333333333333333333333333333334e0 * t77 - 0.30192500000000000000000000000000000000000000000000e0 * t80 - 0.55016250000000000000000000000000000000000000000000e-1 * t84 - 0.82785000000000000000000000000000000000000000000000e-1 * t89
  t159 = 0.1e1 / t56
  t160 = t158 * t159
  t163 = 0.53237641966666666666666666666666666666666666666666e-3 * t31 * t79 * t125 + 0.10000000000000000000000000000000000000000000000000e1 * t133 * t140 - t146 - t147 + 0.18311447306006545054854346104378990962041954983034e-3 * t31 * t79 * t57 + 0.58482236226346462072622386637590534819724553404280e0 * t153 * t160
  t164 = t106 * t163
  t165 = t116 * t164
  t166 = 0.2e1 * t165
  t167 = t112 * t1
  t168 = t167 * t115
  t172 = 0.621814e-1 * t62 * t143
  t174 = -0.3109070e-1 * t130 * t125 + t172 - 0.19751673498613801407483339618206552048944131217655e-1 * t58
  t175 = t106 * t174
  t176 = t168 * t175
  t177 = 0.8e1 * t176
  t178 = t114 * t2
  t179 = 0.1e1 / t178
  t180 = t113 * t179
  t181 = t180 * t175
  t182 = 0.8e1 * t181
  t183 = t27 * t174
  t184 = t116 * t183
  t186 = 0.22146941966666666666666666666666666666666666666666e-2 * t145
  t188 = 0.1e1 / t34 / t8
  t189 = t33 * t188
  t192 = 0.14764627977777777777777777777777777777777777777777e-2 * t31 * t189 * t143
  t196 = t91 ** 2
  t199 = 0.20000000000000000000000000000000000000000000000000e1 * t62 / t68 / t67 * t196 * t95
  t201 = 0.1e1 / t40 / t37
  t203 = t46 * t32
  t205 = 0.1e1 / t48 / t8
  t206 = t203 * t205
  t207 = t201 * t45 * t206
  t209 = t73 * t188
  t210 = t72 * t209
  t212 = t31 * t189
  t214 = t37 ** (-0.5e0)
  t216 = t214 * t45 * t206
  t218 = t83 * t209
  t221 = t47 * t32 * t205
  t226 = 0.10000000000000000000000000000000000000000000000000e1 * t70 * (-0.42198333333333333333333333333333333333333333333333e0 * t207 + 0.84396666666666666666666666666666666666666666666666e0 * t210 + 0.39862222222222222222222222222222222222222222222223e0 * t212 + 0.68258333333333333333333333333333333333333333333333e-1 * t216 + 0.13651666666666666666666666666666666666666666666667e0 * t218 + 0.13692777777777777777777777777777777777777777777778e0 * t221) * t95
  t227 = t68 ** 2
  t230 = t94 ** 2
  t234 = 0.16081979498692535066756296899072713062105388428051e2 * t62 / t227 * t196 / t230
  t235 = t7 ** 2
  t236 = 0.1e1 / t235
  t237 = t11 ** 2
  t240 = t8 * t2
  t241 = 0.1e1 / t240
  t242 = t1 * t241
  t244 = -0.2e1 * t9 + 0.2e1 * t242
  t248 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t236 * t237 + 0.4e1 / 0.3e1 * t7 * t244)
  t249 = t17 ** 2
  t250 = 0.1e1 / t249
  t251 = t18 ** 2
  t254 = -t244
  t258 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t250 * t251 + 0.4e1 / 0.3e1 * t17 * t254)
  t260 = (t248 + t258) * t26
  t262 = 0.19751673498613801407483339618206552048944131217655e-1 * t260 * t58
  t263 = t99 ** 2
  t264 = f.my_piecewise3(t6, t263, t235)
  t265 = f.my_piecewise3(t16, t263, t249)
  t267 = t264 / 0.2e1 + t265 / 0.2e1
  t269 = s0 + 0.2e1 * s1 + s2
  t270 = jnp.sqrt(t269)
  t272 = params.alpha * t270 * t269
  t273 = t267 ** 2
  t274 = t273 * t267
  t275 = 0.1e1 / t274
  t280 = t267 ** (t272 * t115 * t275 * t201 / 0.16e2)
  t281 = jnp.log(0.2e1)
  t282 = 0.1e1 - t281
  t284 = jnp.pi ** 2
  t285 = 0.1e1 / t284
  t286 = t280 * t282 * t285
  t287 = t269 * t188
  t291 = 0.1e1 / t30
  t293 = 0.1e1 / t273 * t45 * t291 * t32
  t296 = 0.1e1 / t282
  t297 = params.beta * t296
  t302 = (-t172 + t116 * t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t106 * t58) * t296
  t303 = t284 * t275
  t305 = jnp.exp(-t302 * t303)
  t306 = t305 - 0.1e1
  t307 = 0.1e1 / t306
  t308 = t284 * t307
  t309 = t269 ** 2
  t311 = t297 * t308 * t309
  t313 = 0.1e1 / t48 / t114
  t314 = t23 ** 2
  t315 = t313 * t314
  t316 = t273 ** 2
  t317 = 0.1e1 / t316
  t319 = 0.1e1 / t46
  t321 = t28 * t319 * t33
  t325 = t287 * t23 * t293 / 0.96e2 + t311 * t315 * t317 * t321 / 0.3072e4
  t326 = params.beta * t325
  t330 = t297 * t308 * t325 + 0.1e1
  t332 = t296 * t284 / t330
  t334 = t326 * t332 + 0.1e1
  t335 = jnp.log(t334)
  t336 = t267 * t335
  t337 = 0.1e1 / t7
  t340 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t337 * t11)
  t341 = 0.1e1 / t17
  t344 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t341 * t18)
  t346 = t340 / 0.2e1 + t344 / 0.2e1
  t347 = t346 ** 2
  t351 = t114 * t8
  t352 = 0.1e1 / t351
  t356 = 0.5e1 / 0.4e1 * t272 * t352 * t275 * t201
  t357 = t272 * t179
  t358 = t317 * t201
  t359 = t358 * t346
  t360 = t357 * t359
  t368 = 0.1e1 / t40 / t51 / 0.4e1
  t370 = t368 * t28 * t73
  t372 = 0.7e1 / 0.24e2 * t272 / t34 / t351 * t275 * t370
  t373 = t272 * t115
  t375 = 0.1e1 / t316 / t267
  t376 = t375 * t201
  t378 = t373 * t376 * t347
  t381 = 0.1e1 / t34 / t178
  t383 = t272 * t381 * t317
  t385 = t31 * t33
  t387 = t383 * t368 * t346 * t385
  t389 = 0.1e1 / t101
  t395 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t389 * t237 + 0.2e1 / 0.3e1 * t337 * t244)
  t396 = 0.1e1 / t103
  t402 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t396 * t251 + 0.2e1 / 0.3e1 * t341 * t254)
  t404 = t395 / 0.2e1 + t402 / 0.2e1
  t406 = t373 * t358 * t404
  t409 = 0.1e1 / t48 / t351
  t419 = 0.5e1 / 0.2304e4 * t272 * t409 * t275 / t40 / t29 / t3 * t45 * t203
  t421 = jnp.log(t267)
  t426 = t272 * t179 * t275 * t201 / 0.4e1
  t427 = t373 * t359
  t432 = t272 * t381 * t275 * t370 / 0.32e2
  t433 = -t426 - 0.3e1 / 0.16e2 * t427 + t432
  t435 = 0.1e1 / t267
  t444 = t285 * t274
  t445 = t444 * t335
  t448 = t116 * t27 * t163
  t449 = 0.2e1 * t448
  t450 = t180 * t183
  t451 = 0.8e1 * t450
  t454 = 0.20e2 * t113 * t352 * t175
  t457 = 0.12e2 * t112 * t115 * t175
  t460 = 0.32e2 * t167 * t179 * t175
  t471 = t138 ** 2
  t485 = t131 ** 2
  t488 = t124 ** 2
  t496 = 0.35616666666666666666666666666666666666666666666666e-1 * t385 * t75 * t69 * t96
  t505 = 0.1e1 / t151 / t53
  t507 = t158 ** 2
  t517 = -0.57538888888888888888888888888888888888888888888889e0 * t207 + 0.11507777777777777777777777777777777777777777777778e1 * t210 + 0.40256666666666666666666666666666666666666666666667e0 * t212 + 0.36677500000000000000000000000000000000000000000000e-1 * t216 + 0.73355000000000000000000000000000000000000000000000e-1 * t218 + 0.13797500000000000000000000000000000000000000000000e0 * t221
  t521 = t151 ** 2
  t522 = 0.1e1 / t521
  t524 = t56 ** 2
  t525 = 0.1e1 / t524
  t529 = -0.70983522622222222222222222222222222222222222222221e-3 * t31 * t189 * t125 - 0.34246666666666666666666666666666666666666666666666e-1 * t385 * t75 * t132 * t140 - 0.20000000000000000000000000000000000000000000000000e1 * t130 / t131 / t121 * t471 * t139 + 0.10000000000000000000000000000000000000000000000000e1 * t133 * (-0.78438333333333333333333333333333333333333333333333e0 * t207 + 0.15687666666666666666666666666666666666666666666667e1 * t210 + 0.68863333333333333333333333333333333333333333333333e0 * t212 + 0.14025833333333333333333333333333333333333333333333e0 * t216 + 0.28051666666666666666666666666666666666666666666667e0 * t218 + 0.17365833333333333333333333333333333333333333333333e0 * t221) * t139 + 0.32163958997385070133512593798145426124210776856102e2 * t130 / t485 * t471 / t488 + t192 + t496 + t199 - t226 - t234 - 0.24415263074675393406472461472505321282722606644045e-3 * t31 * t189 * t57 - 0.10843581300301739842632067522386578331157260943710e-1 * t385 * t75 * t152 * t160 - 0.11696447245269292414524477327518106963944910680856e1 * t39 * t505 * t507 * t159 + 0.58482236226346462072622386637590534819724553404280e0 * t153 * t517 * t159 + 0.17315859105681463759666483083807725165579399831905e2 * t39 * t522 * t507 * t525
  t531 = t116 * t106 * t529
  t532 = t106 * t39
  t536 = 0.11696447245269292414524477327518106963944910680856e1 * t532 * t505 * t507 * t159
  t540 = 0.17315859105681463759666483083807725165579399831905e2 * t532 * t522 * t507 * t525
  t544 = 0.58482236226346462072622386637590534819724553404280e0 * t532 * t152 * t517 * t159
  t545 = -t192 - t199 + t226 + t234 + t262 + 0.6e1 * t286 * t336 * t347 + t280 * ((t356 + 0.3e1 / 0.2e1 * t360 - t372 + 0.3e1 / 0.4e1 * t378 - 0.3e1 / 0.16e2 * t387 - 0.3e1 / 0.16e2 * t406 + t419) * t421 + t433 * t346 * t435 - t360 / 0.4e1 - t378 / 0.4e1 + t387 / 0.32e2 + t406 / 0.16e2) * t282 * t445 + t449 - t451 + t454 + t457 - t460 + t531 + t536 - t540 - t544
  t548 = t152 * t158 * t159
  t549 = t27 * t39 * t548
  t550 = 0.11696447245269292414524477327518106963944910680856e1 * t549
  t553 = t269 / t34 / t240
  t556 = 0.7e1 / 0.288e3 * t553 * t23 * t293
  t557 = t23 * t275
  t558 = t287 * t557
  t559 = t45 * t291
  t561 = t559 * t32 * t346
  t564 = t297 * t284
  t565 = t306 ** 2
  t566 = 0.1e1 / t565
  t567 = t566 * t309
  t569 = t564 * t567 * t313
  t571 = t314 * t317 * t28
  t572 = t319 * t33
  t573 = 0.4e1 * t176
  t574 = 0.4e1 * t181
  t575 = 0.19751673498613801407483339618206552048944131217655e-1 * t59
  t576 = 0.18311447306006545054854346104378990962041954983034e-3 * t110
  t577 = t532 * t548
  t578 = 0.58482236226346462072622386637590534819724553404280e0 * t577
  t580 = (t146 + t147 + t573 - t574 + t184 + t165 + t575 - t576 - t578) * t296
  t582 = t284 * t317
  t583 = t582 * t346
  t586 = 0.3e1 * t302 * t583 - t580 * t303
  t587 = t586 * t305
  t589 = t571 * t572 * t587
  t593 = 0.1e1 / t48 / t178
  t598 = 0.7e1 / 0.4608e4 * t311 * t593 * t314 * t317 * t321
  t599 = t307 * t309
  t601 = t564 * t599 * t313
  t603 = t314 * t375 * t28
  t605 = t603 * t572 * t346
  t608 = -t556 - t558 * t561 / 0.48e2 - t569 * t589 / 0.3072e4 - t598 - t601 * t605 / 0.768e3
  t609 = params.beta * t608
  t611 = t326 * t296
  t612 = t330 ** 2
  t614 = t284 / t612
  t615 = t566 * t325
  t620 = t297 * t308 * t608 - t564 * t615 * t587
  t621 = t614 * t620
  t623 = t609 * t332 - t611 * t621
  t624 = t623 ** 2
  t626 = t334 ** 2
  t627 = 0.1e1 / t626
  t632 = t433 * t421 + t427 / 0.16e2
  t633 = t632 ** 2
  t637 = t273 * t335
  t646 = 0.35e2 / 0.432e3 * t269 / t34 / t114 * t23 * t293
  t647 = t553 * t557
  t648 = t647 * t561
  t651 = t287 * t23 * t317
  t661 = 0.1e1 / t565 / t306
  t662 = t661 * t309
  t664 = t564 * t662 * t313
  t665 = t586 ** 2
  t666 = t305 ** 2
  t667 = t665 * t666
  t673 = t564 * t567 * t593
  t674 = t673 * t589
  t677 = t564 * t567 * t315
  t679 = t375 * t28 * t319
  t681 = t305 * t346
  t687 = t27 * t28 * t109
  t688 = 0.36622894612013090109708692208757981924083909966068e-3 * t687
  t689 = -t688 + t536 - t496 - t540 - t544 - t550 + t454 + t457 - t460 - t192 + t531
  t691 = t116 * t260 * t174
  t693 = 0.8e1 * t180 * t164
  t694 = t168 * t183
  t695 = 0.8e1 * t694
  t697 = 0.8e1 * t168 * t164
  t701 = 0.10843581300301739842632067522386578331157260943710e-1 * t106 * t31 * t79 * t548
  t705 = 0.24415263074675393406472461472505321282722606644045e-3 * t107 * t73 * t188 * t57
  t706 = t691 + t449 - t451 - t693 + t695 + t697 - t199 + t262 + t226 + t234 + t701 + t705
  t712 = t284 * t375
  t720 = (-(t689 + t706) * t296 * t303 + 0.6e1 * t580 * t583 - 0.12e2 * t302 * t712 * t347 + 0.3e1 * t302 * t582 * t404) * t305
  t725 = t665 * t305
  t734 = 0.119e3 / 0.13824e5 * t311 * t409 * t314 * t317 * t321
  t736 = t564 * t599 * t593
  t737 = t736 * t605
  t742 = t314 / t316 / t273 * t28
  t751 = t646 + 0.7e1 / 0.72e2 * t648 + t651 * t559 * t32 * t347 / 0.16e2 - t558 * t559 * t32 * t404 / 0.48e2 + t664 * t571 * t572 * t667 / 0.1536e4 + 0.7e1 / 0.2304e4 * t674 + t677 * t679 * t33 * t586 * t681 / 0.384e3 - t569 * t571 * t572 * t720 / 0.3072e4 - t569 * t571 * t572 * t725 / 0.3072e4 + t734 + 0.7e1 / 0.576e3 * t737 + 0.5e1 / 0.768e3 * t601 * t742 * t572 * t347 - t601 * t603 * t572 * t404 / 0.768e3
  t754 = t609 * t296
  t759 = t284 / t612 / t330
  t760 = t620 ** 2
  t764 = t661 * t325
  t768 = t566 * t608
  t783 = 0.1e1 / t334
  t786 = t280 * t632
  t787 = t786 * t282
  t789 = t444 * t623 * t783
  t792 = t273 * t623
  t793 = t783 * t346
  t797 = t285 * t273
  t799 = t797 * t335 * t346
  t802 = -t550 - t286 * t274 * t624 * t627 + t280 * t633 * t282 * t445 + 0.3e1 * t286 * t637 * t404 + t286 * t274 * (params.beta * t751 * t332 - 0.2e1 * t754 * t621 + 0.2e1 * t611 * t759 * t760 - t611 * t614 * (t297 * t308 * t751 - 0.2e1 * t564 * t768 * t587 - t564 * t615 * t720 - t564 * t615 * t725 + 0.2e1 * t564 * t764 * t667)) * t783 + 0.2e1 * t787 * t789 + 0.6e1 * t286 * t792 * t793 + t691 + t697 - t693 + t695 + 0.6e1 * t787 * t799 - t688 - t496 + t705 + t701
  t805 = 0.11696447245269292414524477327518106963944910680856e1 * t577
  t806 = t787 * t445
  t809 = t286 * t637 * t346
  t813 = t286 * t274 * t623 * t783
  d11 = 0.39503346997227602814966679236413104097888262435310e-1 * t59 + t98 - t111 + t166 + t177 - t182 + 0.2e1 * t184 + t186 + t2 * (t545 + t802) - t805 + 0.2e1 * t806 + 0.6e1 * t809 + 0.2e1 * t813
  t815 = -t3 - t10
  t818 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t815)
  t819 = -t815
  t822 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t819)
  t824 = (t818 + t822) * t26
  t825 = t824 * t174
  t826 = t116 * t825
  t830 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t337 * t815)
  t833 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t341 * t819)
  t835 = t830 / 0.2e1 + t833 / 0.2e1
  t836 = t32 * t835
  t837 = t559 * t836
  t840 = t824 * t58
  t841 = 0.19751673498613801407483339618206552048944131217655e-1 * t840
  t843 = (t146 + t147 - t573 - t574 + t826 + t165 + t841 - t576 - t578) * t296
  t845 = t582 * t835
  t848 = 0.3e1 * t302 * t845 - t843 * t303
  t849 = t848 * t305
  t851 = t571 * t572 * t849
  t855 = t603 * t572 * t835
  t858 = -t556 - t558 * t837 / 0.48e2 - t569 * t851 / 0.3072e4 - t598 - t601 * t855 / 0.768e3
  t859 = params.beta * t858
  t865 = t297 * t308 * t858 - t564 * t615 * t849
  t866 = t614 * t865
  t868 = t859 * t332 - t611 * t866
  t869 = t274 * t868
  t871 = t286 * t869 * t783
  t873 = t824 * t39 * t548
  t874 = 0.58482236226346462072622386637590534819724553404280e0 * t873
  t875 = 0.4e1 * t450
  t883 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t236 * t815 * t11 + 0.8e1 / 0.3e1 * t7 * t1 * t241)
  t891 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t250 * t819 * t18 - 0.8e1 / 0.3e1 * t17 * t1 * t241)
  t893 = (t883 + t891) * t26
  t895 = 0.19751673498613801407483339618206552048944131217655e-1 * t893 * t58
  t896 = t835 * t346
  t901 = t797 * t335 * t835
  t905 = t824 * t28 * t109
  t906 = 0.18311447306006545054854346104378990962041954983034e-3 * t905
  t907 = 0.58482236226346462072622386637590534819724553404280e0 * t549
  t908 = t168 * t825
  t909 = 0.4e1 * t908
  t910 = 0.6e1 * t286 * t336 * t896 + 0.3e1 * t787 * t901 - t192 - t199 + t226 + t234 + t448 + t454 - t457 + t531 + t536 - t540 - t544 - t874 - t875 + t895 - t906 - t907 + t909
  t911 = 0.4e1 * t694
  t912 = t180 * t825
  t913 = 0.4e1 * t912
  t915 = t116 * t893 * t174
  t917 = t116 * t824 * t163
  t925 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t389 * t815 * t11 + 0.4e1 / 0.3e1 * t337 * t1 * t241)
  t933 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t396 * t819 * t18 - 0.4e1 / 0.3e1 * t341 * t1 * t241)
  t935 = t925 / 0.2e1 + t933 / 0.2e1
  t940 = t647 * t837
  t953 = t317 * t28 * t319
  t954 = t33 * t848
  t955 = t666 * t586
  t960 = t673 * t851
  t966 = -t192 - t199 + t226 + t234 - t874 + t448 - t875 + t895 - t906 + t454 - t457 + t531 + t536
  t967 = 0.18311447306006545054854346104378990962041954983034e-3 * t687
  t968 = -t540 - t544 - t907 + t909 - t693 - t911 - t913 + t915 + t917 - t967 - t496 + t705 + t701
  t985 = (-(t966 + t968) * t296 * t303 + 0.3e1 * t843 * t583 + 0.3e1 * t580 * t845 - 0.12e2 * t302 * t284 * t375 * t835 * t346 + 0.3e1 * t302 * t582 * t935) * t305
  t1001 = t736 * t855
  t1011 = t646 + 0.7e1 / 0.144e3 * t648 + 0.7e1 / 0.144e3 * t940 + t651 * t559 * t836 * t346 / 0.16e2 - t558 * t559 * t32 * t935 / 0.48e2 + t564 * t662 * t315 * t953 * t954 * t955 / 0.1536e4 + 0.7e1 / 0.4608e4 * t960 + t677 * t679 * t954 * t681 / 0.768e3 - t569 * t571 * t572 * t985 / 0.3072e4 - t677 * t953 * t954 * t587 / 0.3072e4 + 0.7e1 / 0.4608e4 * t674 + t734 + 0.7e1 / 0.1152e4 * t737 + t677 * t679 * t33 * t835 * t587 / 0.768e3 + 0.7e1 / 0.1152e4 * t1001 + 0.5e1 / 0.768e3 * t601 * t742 * t572 * t896 - t601 * t603 * t572 * t935 / 0.768e3
  t1014 = t859 * t296
  t1023 = t325 * t848
  t1035 = t566 * t858
  t1051 = t444 * t868 * t783
  t1053 = t273 * t868
  t1057 = t358 * t835
  t1058 = t373 * t1057
  t1060 = -t426 - 0.3e1 / 0.16e2 * t1058 + t432
  t1063 = t1060 * t421 + t1058 / 0.16e2
  t1065 = t280 * t1063 * t282
  t1074 = t783 * t835
  t1079 = t357 * t1057
  t1082 = t373 * t376 * t896
  t1086 = t383 * t368 * t835 * t385
  t1089 = t373 * t358 * t935
  t1096 = t1079 / 0.4e1
  t1098 = t1086 / 0.32e2
  t1104 = -t693 - t911 - t913 + t915 + t917 + 0.3e1 * t286 * t637 * t935 + t286 * t274 * (params.beta * t1011 * t332 - t1014 * t621 - t754 * t866 + 0.2e1 * t611 * t759 * t865 * t620 - t611 * t614 * (-t297 * t284 * t566 * t1023 * t587 + 0.2e1 * t297 * t284 * t661 * t1023 * t955 + t297 * t308 * t1011 - t564 * t1035 * t587 - t564 * t615 * t985 - t564 * t768 * t849)) * t783 - t286 * t869 * t627 * t623 + t787 * t1051 + 0.3e1 * t286 * t1053 * t793 + 0.3e1 * t1065 * t799 + t786 * t1063 * t282 * t285 * t274 * t335 + t1065 * t789 - t967 - t496 + t705 + 0.3e1 * t286 * t792 * t1074 + t701 + t280 * ((t356 + 0.3e1 / 0.4e1 * t360 - t372 + 0.3e1 / 0.4e1 * t1079 + 0.3e1 / 0.4e1 * t1082 - 0.3e1 / 0.32e2 * t1086 - 0.3e1 / 0.16e2 * t1089 - 0.3e1 / 0.32e2 * t387 + t419) * t421 + t1060 * t346 * t435 - t1096 - t1082 / 0.4e1 + t1098 + t1089 / 0.16e2) * t282 * t445
  t1107 = t1065 * t445
  t1109 = t286 * t637 * t835
  d12 = t184 + t575 - t111 + t806 + t813 + t166 - t182 + t826 + t186 + 0.3e1 * t809 + t871 + t2 * (t910 + t1104) + t841 + t98 - t805 + t1107 + 0.3e1 * t1109
  t1115 = 0.11696447245269292414524477327518106963944910680856e1 * t873
  t1116 = t815 ** 2
  t1120 = 0.2e1 * t9 + 0.2e1 * t242
  t1124 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t236 * t1116 + 0.4e1 / 0.3e1 * t7 * t1120)
  t1125 = t819 ** 2
  t1128 = -t1120
  t1132 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t250 * t1125 + 0.4e1 / 0.3e1 * t17 * t1128)
  t1134 = (t1124 + t1132) * t26
  t1136 = t116 * t1134 * t174
  t1137 = 0.36622894612013090109708692208757981924083909966068e-3 * t905
  t1139 = 0.19751673498613801407483339618206552048944131217655e-1 * t1134 * t58
  t1140 = t868 ** 2
  t1144 = t835 ** 2
  t1148 = -t286 * t274 * t1140 * t627 + 0.6e1 * t286 * t336 * t1144 - t1115 + t1136 - t1137 + t1139 - t192 - t199 + t226 + t234 + t454 + t457 + t460 + t531 + t536 - t540
  t1151 = t373 * t376 * t1144
  t1159 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t389 * t1116 + 0.2e1 / 0.3e1 * t337 * t1120)
  t1165 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t396 * t1125 + 0.2e1 / 0.3e1 * t341 * t1128)
  t1167 = t1159 / 0.2e1 + t1165 / 0.2e1
  t1169 = t373 * t358 * t1167
  t1193 = t848 ** 2
  t1194 = t1193 * t666
  t1205 = 0.2e1 * t917
  t1206 = 0.8e1 * t912
  t1207 = -t540 - t544 - t1115 + t531 + t1136 + t1205 + t457 - t1206 - t693 + t226 + t234
  t1208 = 0.8e1 * t908
  t1209 = -t1208 - t697 + t460 - t192 - t1137 + t536 - t496 + t1139 + t454 - t199 + t701 + t705
  t1222 = (-(t1207 + t1209) * t296 * t303 + 0.6e1 * t843 * t845 - 0.12e2 * t302 * t712 * t1144 + 0.3e1 * t302 * t582 * t1167) * t305
  t1227 = t1193 * t305
  t1241 = t646 + 0.7e1 / 0.72e2 * t940 + t651 * t559 * t32 * t1144 / 0.16e2 - t558 * t559 * t32 * t1167 / 0.48e2 + t664 * t571 * t572 * t1194 / 0.1536e4 + 0.7e1 / 0.2304e4 * t960 + t677 * t679 * t954 * t305 * t835 / 0.384e3 - t569 * t571 * t572 * t1222 / 0.3072e4 - t569 * t571 * t572 * t1227 / 0.3072e4 + t734 + 0.7e1 / 0.576e3 * t1001 + 0.5e1 / 0.768e3 * t601 * t742 * t572 * t1144 - t601 * t603 * t572 * t1167 / 0.768e3
  t1246 = t865 ** 2
  t1269 = t1063 ** 2
  t1280 = -t544 + t280 * ((t356 + 0.3e1 / 0.2e1 * t1079 - t372 + 0.3e1 / 0.4e1 * t1151 - 0.3e1 / 0.16e2 * t1086 - 0.3e1 / 0.16e2 * t1169 + t419) * t421 + t1060 * t835 * t435 - t1096 - t1151 / 0.4e1 + t1098 + t1169 / 0.16e2) * t282 * t445 + 0.3e1 * t286 * t637 * t1167 + t286 * t274 * (params.beta * t1241 * t332 - 0.2e1 * t1014 * t866 + 0.2e1 * t611 * t759 * t1246 - t611 * t614 * (-0.2e1 * t564 * t1035 * t849 + 0.2e1 * t564 * t764 * t1194 - t564 * t615 * t1222 - t564 * t615 * t1227 + t297 * t308 * t1241)) * t783 + t280 * t1269 * t282 * t445 - t1208 + 0.2e1 * t1065 * t1051 + 0.6e1 * t286 * t1053 * t1074 + 0.6e1 * t1065 * t901 - t697 - t693 - t1206 + t1205 - t496 + t705 + t701
  d22 = t98 - t182 + 0.2e1 * t826 + 0.2e1 * t871 - t805 + 0.2e1 * t1107 + 0.6e1 * t1109 + t166 - t111 + t186 - t177 + t2 * (t1148 + t1280) + 0.39503346997227602814966679236413104097888262435310e-1 * t840
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = t5 ** (0.1e1 / 0.3e1)
  t8 = t2 ** 2
  t9 = 0.1e1 / t8
  t10 = t1 * t9
  t11 = t3 - t10
  t14 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t11)
  t15 = 0.1e1 - t4
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = -t11
  t21 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t18)
  t23 = 2 ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t27 = (t14 + t21) * t26
  t28 = 3 ** (0.1e1 / 0.3e1)
  t29 = 0.1e1 / jnp.pi
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t28 * t30
  t32 = 4 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t2 ** (0.1e1 / 0.3e1)
  t37 = t31 * t33 / t34
  t39 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t37
  t40 = jnp.sqrt(t37)
  t43 = t37 ** 0.15e1
  t45 = t28 ** 2
  t46 = t30 ** 2
  t47 = t45 * t46
  t48 = t34 ** 2
  t51 = t47 * t32 / t48
  t53 = 0.51785000000000000000000000000000000000000000000000e1 * t40 + 0.90577500000000000000000000000000000000000000000000e0 * t37 + 0.11003250000000000000000000000000000000000000000000e0 * t43 + 0.12417750000000000000000000000000000000000000000000e0 * t51
  t56 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t53
  t57 = jnp.log(t56)
  t58 = t39 * t57
  t59 = t27 * t58
  t62 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t37
  t67 = 0.37978500000000000000000000000000000000000000000000e1 * t40 + 0.89690000000000000000000000000000000000000000000000e0 * t37 + 0.20477500000000000000000000000000000000000000000000e0 * t43 + 0.12323500000000000000000000000000000000000000000000e0 * t51
  t68 = t67 ** 2
  t69 = 0.1e1 / t68
  t70 = t62 * t69
  t72 = 0.1e1 / t40 * t28
  t73 = t30 * t33
  t75 = 0.1e1 / t34 / t2
  t76 = t73 * t75
  t77 = t72 * t76
  t79 = t33 * t75
  t80 = t31 * t79
  t82 = t37 ** 0.5e0
  t83 = t82 * t28
  t84 = t83 * t76
  t89 = t47 * t32 / t48 / t2
  t91 = -0.63297500000000000000000000000000000000000000000000e0 * t77 - 0.29896666666666666666666666666666666666666666666667e0 * t80 - 0.10238750000000000000000000000000000000000000000000e0 * t84 - 0.82156666666666666666666666666666666666666666666667e-1 * t89
  t94 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t67
  t95 = 0.1e1 / t94
  t96 = t91 * t95
  t97 = t70 * t96
  t98 = 0.20000000000000000000000000000000000000000000000000e1 * t97
  t99 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t100 = t99 * f.p.zeta_threshold
  t101 = t7 * t5
  t102 = f.my_piecewise3(t6, t100, t101)
  t103 = t17 * t15
  t104 = f.my_piecewise3(t16, t100, t103)
  t106 = (t102 + t104 - 0.2e1) * t26
  t107 = t106 * t28
  t109 = t73 * t75 * t57
  t110 = t107 * t109
  t111 = 0.36622894612013090109708692208757981924083909966068e-3 * t110
  t112 = t1 ** 2
  t113 = t112 ** 2
  t114 = t8 ** 2
  t115 = 0.1e1 / t114
  t116 = t113 * t115
  t121 = 0.70594500000000000000000000000000000000000000000000e1 * t40 + 0.15494250000000000000000000000000000000000000000000e1 * t37 + 0.42077500000000000000000000000000000000000000000000e0 * t43 + 0.15629250000000000000000000000000000000000000000000e0 * t51
  t124 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t121
  t125 = jnp.log(t124)
  t130 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t37
  t131 = t121 ** 2
  t132 = 0.1e1 / t131
  t133 = t130 * t132
  t138 = -0.11765750000000000000000000000000000000000000000000e1 * t77 - 0.51647500000000000000000000000000000000000000000000e0 * t80 - 0.21038750000000000000000000000000000000000000000000e0 * t84 - 0.10419500000000000000000000000000000000000000000000e0 * t89
  t139 = 0.1e1 / t124
  t140 = t138 * t139
  t143 = jnp.log(t94)
  t145 = t31 * t79 * t143
  t146 = 0.11073470983333333333333333333333333333333333333333e-2 * t145
  t147 = 0.10000000000000000000000000000000000000000000000000e1 * t97
  t151 = t53 ** 2
  t152 = 0.1e1 / t151
  t153 = t39 * t152
  t158 = -0.86308333333333333333333333333333333333333333333334e0 * t77 - 0.30192500000000000000000000000000000000000000000000e0 * t80 - 0.55016250000000000000000000000000000000000000000000e-1 * t84 - 0.82785000000000000000000000000000000000000000000000e-1 * t89
  t159 = 0.1e1 / t56
  t160 = t158 * t159
  t163 = 0.53237641966666666666666666666666666666666666666666e-3 * t31 * t79 * t125 + 0.10000000000000000000000000000000000000000000000000e1 * t133 * t140 - t146 - t147 + 0.18311447306006545054854346104378990962041954983034e-3 * t31 * t79 * t57 + 0.58482236226346462072622386637590534819724553404280e0 * t153 * t160
  t164 = t106 * t163
  t165 = t116 * t164
  t166 = 0.2e1 * t165
  t167 = t112 * t1
  t168 = t167 * t115
  t172 = 0.621814e-1 * t62 * t143
  t174 = -0.3109070e-1 * t130 * t125 + t172 - 0.19751673498613801407483339618206552048944131217655e-1 * t58
  t175 = t106 * t174
  t176 = t168 * t175
  t177 = 0.8e1 * t176
  t178 = t114 * t2
  t179 = 0.1e1 / t178
  t180 = t113 * t179
  t181 = t180 * t175
  t182 = 0.8e1 * t181
  t183 = t27 * t174
  t184 = t116 * t183
  t186 = 0.22146941966666666666666666666666666666666666666666e-2 * t145
  t188 = 0.1e1 / t34 / t8
  t189 = t33 * t188
  t192 = 0.14764627977777777777777777777777777777777777777777e-2 * t31 * t189 * t143
  t194 = 0.8e1 * t180 * t164
  t195 = t168 * t183
  t196 = 0.8e1 * t195
  t198 = 0.8e1 * t168 * t164
  t200 = t116 * t27 * t163
  t201 = 0.2e1 * t200
  t202 = t180 * t183
  t203 = 0.8e1 * t202
  t204 = t7 ** 2
  t205 = 0.1e1 / t204
  t206 = t11 ** 2
  t209 = t8 * t2
  t210 = 0.1e1 / t209
  t211 = t1 * t210
  t213 = -0.2e1 * t9 + 0.2e1 * t211
  t217 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t205 * t206 + 0.4e1 / 0.3e1 * t7 * t213)
  t218 = t17 ** 2
  t219 = 0.1e1 / t218
  t220 = t18 ** 2
  t223 = -t213
  t227 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t219 * t220 + 0.4e1 / 0.3e1 * t17 * t223)
  t229 = (t217 + t227) * t26
  t231 = 0.19751673498613801407483339618206552048944131217655e-1 * t229 * t58
  t232 = t68 ** 2
  t235 = t91 ** 2
  t236 = t94 ** 2
  t240 = 0.16081979498692535066756296899072713062105388428051e2 * t62 / t232 * t235 / t236
  t246 = 0.20000000000000000000000000000000000000000000000000e1 * t62 / t68 / t67 * t235 * t95
  t248 = 0.1e1 / t40 / t37
  t250 = t46 * t32
  t252 = 0.1e1 / t48 / t8
  t253 = t250 * t252
  t254 = t248 * t45 * t253
  t256 = t73 * t188
  t257 = t72 * t256
  t259 = t31 * t189
  t261 = t37 ** (-0.5e0)
  t263 = t261 * t45 * t253
  t265 = t83 * t256
  t268 = t47 * t32 * t252
  t273 = 0.10000000000000000000000000000000000000000000000000e1 * t70 * (-0.42198333333333333333333333333333333333333333333333e0 * t254 + 0.84396666666666666666666666666666666666666666666666e0 * t257 + 0.39862222222222222222222222222222222222222222222223e0 * t259 + 0.68258333333333333333333333333333333333333333333333e-1 * t263 + 0.13651666666666666666666666666666666666666666666667e0 * t265 + 0.13692777777777777777777777777777777777777777777778e0 * t268) * t95
  t275 = t116 * t229 * t174
  t276 = t99 ** 2
  t277 = f.my_piecewise3(t6, t276, t204)
  t278 = f.my_piecewise3(t16, t276, t218)
  t280 = t277 / 0.2e1 + t278 / 0.2e1
  t282 = s0 + 0.2e1 * s1 + s2
  t283 = jnp.sqrt(t282)
  t285 = params.alpha * t283 * t282
  t286 = t280 ** 2
  t287 = t286 * t280
  t288 = 0.1e1 / t287
  t293 = t280 ** (t285 * t115 * t288 * t248 / 0.16e2)
  t294 = jnp.log(0.2e1)
  t295 = 0.1e1 - t294
  t297 = jnp.pi ** 2
  t298 = 0.1e1 / t297
  t299 = t293 * t295 * t298
  t300 = t282 * t188
  t304 = 0.1e1 / t30
  t306 = 0.1e1 / t286 * t45 * t304 * t32
  t309 = 0.1e1 / t295
  t310 = params.beta * t309
  t315 = (-t172 + t116 * t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t106 * t58) * t309
  t316 = t297 * t288
  t318 = jnp.exp(-t315 * t316)
  t319 = t318 - 0.1e1
  t320 = 0.1e1 / t319
  t321 = t297 * t320
  t322 = t282 ** 2
  t324 = t310 * t321 * t322
  t326 = 0.1e1 / t48 / t114
  t327 = t23 ** 2
  t328 = t326 * t327
  t329 = t286 ** 2
  t330 = 0.1e1 / t329
  t332 = 0.1e1 / t46
  t334 = t28 * t332 * t33
  t338 = t300 * t23 * t306 / 0.96e2 + t324 * t328 * t330 * t334 / 0.3072e4
  t339 = params.beta * t338
  t343 = t310 * t321 * t338 + 0.1e1
  t345 = t309 * t297 / t343
  t347 = t339 * t345 + 0.1e1
  t348 = jnp.log(t347)
  t349 = t280 * t348
  t350 = 0.1e1 / t7
  t353 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t350 * t11)
  t354 = 0.1e1 / t17
  t357 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t354 * t18)
  t359 = t353 / 0.2e1 + t357 / 0.2e1
  t360 = t359 ** 2
  t364 = t114 * t8
  t365 = 0.1e1 / t364
  t369 = 0.5e1 / 0.4e1 * t285 * t365 * t288 * t248
  t370 = t285 * t179
  t371 = t330 * t248
  t372 = t371 * t359
  t373 = t370 * t372
  t381 = 0.1e1 / t40 / t51 / 0.4e1
  t383 = t381 * t28 * t73
  t385 = 0.7e1 / 0.24e2 * t285 / t34 / t364 * t288 * t383
  t386 = t285 * t115
  t388 = 0.1e1 / t329 / t280
  t389 = t388 * t248
  t391 = t386 * t389 * t360
  t394 = 0.1e1 / t34 / t178
  t396 = t285 * t394 * t330
  t398 = t31 * t33
  t400 = t396 * t381 * t359 * t398
  t402 = 0.1e1 / t101
  t408 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t402 * t206 + 0.2e1 / 0.3e1 * t350 * t213)
  t409 = 0.1e1 / t103
  t415 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t409 * t220 + 0.2e1 / 0.3e1 * t354 * t223)
  t417 = t408 / 0.2e1 + t415 / 0.2e1
  t419 = t386 * t371 * t417
  t422 = 0.1e1 / t48 / t364
  t432 = 0.5e1 / 0.2304e4 * t285 * t422 * t288 / t40 / t29 / t3 * t45 * t250
  t434 = jnp.log(t280)
  t439 = t285 * t179 * t288 * t248 / 0.4e1
  t440 = t386 * t372
  t445 = t285 * t394 * t288 * t383 / 0.32e2
  t446 = -t439 - 0.3e1 / 0.16e2 * t440 + t445
  t448 = 0.1e1 / t280
  t457 = t298 * t287
  t458 = t457 * t348
  t462 = 0.20e2 * t113 * t365 * t175
  t465 = 0.12e2 * t112 * t115 * t175
  t468 = 0.32e2 * t167 * t179 * t175
  t469 = -t192 - t194 + t196 + t198 + t201 - t203 + t231 + t240 - t246 + t273 + t275 + 0.6e1 * t299 * t349 * t360 + t293 * ((t369 + 0.3e1 / 0.2e1 * t373 - t385 + 0.3e1 / 0.4e1 * t391 - 0.3e1 / 0.16e2 * t400 - 0.3e1 / 0.16e2 * t419 + t432) * t434 + t446 * t359 * t448 - t373 / 0.4e1 - t391 / 0.4e1 + t400 / 0.32e2 + t419 / 0.16e2) * t295 * t458 + t462 + t465 - t468
  t480 = t138 ** 2
  t494 = t131 ** 2
  t497 = t124 ** 2
  t505 = 0.35616666666666666666666666666666666666666666666666e-1 * t398 * t75 * t69 * t96
  t514 = 0.1e1 / t151 / t53
  t516 = t158 ** 2
  t526 = -0.57538888888888888888888888888888888888888888888889e0 * t254 + 0.11507777777777777777777777777777777777777777777778e1 * t257 + 0.40256666666666666666666666666666666666666666666667e0 * t259 + 0.36677500000000000000000000000000000000000000000000e-1 * t263 + 0.73355000000000000000000000000000000000000000000000e-1 * t265 + 0.13797500000000000000000000000000000000000000000000e0 * t268
  t530 = t151 ** 2
  t531 = 0.1e1 / t530
  t533 = t56 ** 2
  t534 = 0.1e1 / t533
  t538 = -0.70983522622222222222222222222222222222222222222221e-3 * t31 * t189 * t125 - 0.34246666666666666666666666666666666666666666666666e-1 * t398 * t75 * t132 * t140 - 0.20000000000000000000000000000000000000000000000000e1 * t130 / t131 / t121 * t480 * t139 + 0.10000000000000000000000000000000000000000000000000e1 * t133 * (-0.78438333333333333333333333333333333333333333333333e0 * t254 + 0.15687666666666666666666666666666666666666666666667e1 * t257 + 0.68863333333333333333333333333333333333333333333333e0 * t259 + 0.14025833333333333333333333333333333333333333333333e0 * t263 + 0.28051666666666666666666666666666666666666666666667e0 * t265 + 0.17365833333333333333333333333333333333333333333333e0 * t268) * t139 + 0.32163958997385070133512593798145426124210776856102e2 * t130 / t494 * t480 / t497 + t192 + t505 + t246 - t273 - t240 - 0.24415263074675393406472461472505321282722606644045e-3 * t31 * t189 * t57 - 0.10843581300301739842632067522386578331157260943710e-1 * t398 * t75 * t152 * t160 - 0.11696447245269292414524477327518106963944910680856e1 * t39 * t514 * t516 * t159 + 0.58482236226346462072622386637590534819724553404280e0 * t153 * t526 * t159 + 0.17315859105681463759666483083807725165579399831905e2 * t39 * t531 * t516 * t534
  t540 = t116 * t106 * t538
  t541 = t106 * t39
  t545 = 0.11696447245269292414524477327518106963944910680856e1 * t541 * t514 * t516 * t159
  t549 = 0.17315859105681463759666483083807725165579399831905e2 * t541 * t531 * t516 * t534
  t553 = 0.58482236226346462072622386637590534819724553404280e0 * t541 * t152 * t526 * t159
  t556 = t152 * t158 * t159
  t557 = t27 * t39 * t556
  t558 = 0.11696447245269292414524477327518106963944910680856e1 * t557
  t561 = t282 / t34 / t209
  t564 = 0.7e1 / 0.288e3 * t561 * t23 * t306
  t565 = t23 * t288
  t566 = t300 * t565
  t567 = t45 * t304
  t569 = t567 * t32 * t359
  t572 = t310 * t297
  t573 = t319 ** 2
  t574 = 0.1e1 / t573
  t575 = t574 * t322
  t577 = t572 * t575 * t326
  t579 = t327 * t330 * t28
  t580 = t332 * t33
  t581 = 0.4e1 * t176
  t582 = 0.4e1 * t181
  t583 = 0.19751673498613801407483339618206552048944131217655e-1 * t59
  t584 = 0.18311447306006545054854346104378990962041954983034e-3 * t110
  t585 = t541 * t556
  t586 = 0.58482236226346462072622386637590534819724553404280e0 * t585
  t588 = (t146 + t147 + t581 - t582 + t184 + t165 + t583 - t584 - t586) * t309
  t590 = t297 * t330
  t591 = t590 * t359
  t594 = 0.3e1 * t315 * t591 - t588 * t316
  t595 = t594 * t318
  t597 = t579 * t580 * t595
  t601 = 0.1e1 / t48 / t178
  t606 = 0.7e1 / 0.4608e4 * t324 * t601 * t327 * t330 * t334
  t607 = t320 * t322
  t609 = t572 * t607 * t326
  t611 = t327 * t388 * t28
  t613 = t611 * t580 * t359
  t616 = -t564 - t566 * t569 / 0.48e2 - t577 * t597 / 0.3072e4 - t606 - t609 * t613 / 0.768e3
  t617 = params.beta * t616
  t619 = t339 * t309
  t620 = t343 ** 2
  t622 = t297 / t620
  t623 = t574 * t338
  t628 = t310 * t321 * t616 - t572 * t623 * t595
  t629 = t622 * t628
  t631 = t617 * t345 - t619 * t629
  t632 = t631 ** 2
  t634 = t347 ** 2
  t635 = 0.1e1 / t634
  t640 = t446 * t434 + t440 / 0.16e2
  t641 = t640 ** 2
  t645 = t286 * t348
  t654 = 0.35e2 / 0.432e3 * t282 / t34 / t114 * t23 * t306
  t655 = t561 * t565
  t656 = t655 * t569
  t659 = t300 * t23 * t330
  t669 = 0.1e1 / t573 / t319
  t670 = t669 * t322
  t672 = t572 * t670 * t326
  t673 = t594 ** 2
  t674 = t318 ** 2
  t675 = t673 * t674
  t681 = t572 * t575 * t601
  t682 = t681 * t597
  t685 = t572 * t575 * t328
  t687 = t388 * t28 * t332
  t689 = t318 * t359
  t695 = t27 * t28 * t109
  t696 = 0.36622894612013090109708692208757981924083909966068e-3 * t695
  t697 = -t696 + t545 - t505 - t549 - t553 - t558 + t462 + t465 - t468 - t192 + t540
  t701 = 0.10843581300301739842632067522386578331157260943710e-1 * t106 * t31 * t79 * t556
  t705 = 0.24415263074675393406472461472505321282722606644045e-3 * t107 * t73 * t188 * t57
  t706 = t275 + t201 - t203 - t194 + t196 + t198 - t246 + t231 + t273 + t240 + t701 + t705
  t712 = t297 * t388
  t720 = (-(t697 + t706) * t309 * t316 + 0.6e1 * t588 * t591 - 0.12e2 * t315 * t712 * t360 + 0.3e1 * t315 * t590 * t417) * t318
  t725 = t673 * t318
  t734 = 0.119e3 / 0.13824e5 * t324 * t422 * t327 * t330 * t334
  t736 = t572 * t607 * t601
  t737 = t736 * t613
  t742 = t327 / t329 / t286 * t28
  t751 = t654 + 0.7e1 / 0.72e2 * t656 + t659 * t567 * t32 * t360 / 0.16e2 - t566 * t567 * t32 * t417 / 0.48e2 + t672 * t579 * t580 * t675 / 0.1536e4 + 0.7e1 / 0.2304e4 * t682 + t685 * t687 * t33 * t594 * t689 / 0.384e3 - t577 * t579 * t580 * t720 / 0.3072e4 - t577 * t579 * t580 * t725 / 0.3072e4 + t734 + 0.7e1 / 0.576e3 * t737 + 0.5e1 / 0.768e3 * t609 * t742 * t580 * t360 - t609 * t611 * t580 * t417 / 0.768e3
  t754 = t617 * t309
  t759 = t297 / t620 / t343
  t760 = t628 ** 2
  t764 = t669 * t338
  t768 = t574 * t616
  t783 = 0.1e1 / t347
  t786 = t293 * t640
  t787 = t786 * t295
  t789 = t457 * t631 * t783
  t792 = t286 * t631
  t793 = t783 * t359
  t797 = t298 * t286
  t799 = t797 * t348 * t359
  t802 = t540 + t545 - t549 - t553 - t558 - t299 * t287 * t632 * t635 + t293 * t641 * t295 * t458 + 0.3e1 * t299 * t645 * t417 + t299 * t287 * (params.beta * t751 * t345 - 0.2e1 * t754 * t629 + 0.2e1 * t619 * t759 * t760 - t619 * t622 * (t310 * t321 * t751 - 0.2e1 * t572 * t768 * t595 - t572 * t623 * t720 - t572 * t623 * t725 + 0.2e1 * t572 * t764 * t675)) * t783 + 0.2e1 * t787 * t789 + 0.6e1 * t299 * t792 * t793 + 0.6e1 * t787 * t799 - t696 - t505 + t705 + t701
  t805 = 0.11696447245269292414524477327518106963944910680856e1 * t585
  t806 = t787 * t458
  t809 = t299 * t645 * t359
  t813 = t299 * t287 * t631 * t783
  d11 = 0.39503346997227602814966679236413104097888262435310e-1 * t59 + t98 - t111 + t166 + t177 - t182 + 0.2e1 * t184 + t186 + t2 * (t469 + t802) - t805 + 0.2e1 * t806 + 0.6e1 * t809 + 0.2e1 * t813
  t815 = -t3 - t10
  t818 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t815)
  t819 = -t815
  t822 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t819)
  t824 = (t818 + t822) * t26
  t825 = t824 * t174
  t826 = t116 * t825
  t830 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t350 * t815)
  t833 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t354 * t819)
  t835 = t830 / 0.2e1 + t833 / 0.2e1
  t836 = t32 * t835
  t837 = t567 * t836
  t840 = t824 * t58
  t841 = 0.19751673498613801407483339618206552048944131217655e-1 * t840
  t843 = (t146 + t147 - t581 - t582 + t826 + t165 + t841 - t584 - t586) * t309
  t845 = t590 * t835
  t848 = 0.3e1 * t315 * t845 - t843 * t316
  t849 = t848 * t318
  t851 = t579 * t580 * t849
  t855 = t611 * t580 * t835
  t858 = -t564 - t566 * t837 / 0.48e2 - t577 * t851 / 0.3072e4 - t606 - t609 * t855 / 0.768e3
  t859 = params.beta * t858
  t865 = t310 * t321 * t858 - t572 * t623 * t849
  t866 = t622 * t865
  t868 = t859 * t345 - t619 * t866
  t869 = t287 * t868
  t871 = t299 * t869 * t783
  t872 = 0.4e1 * t195
  t873 = 0.4e1 * t202
  t875 = t824 * t39 * t556
  t876 = 0.58482236226346462072622386637590534819724553404280e0 * t875
  t877 = t835 * t359
  t882 = t797 * t348 * t835
  t886 = t824 * t28 * t109
  t887 = 0.18311447306006545054854346104378990962041954983034e-3 * t886
  t888 = t180 * t825
  t889 = 0.4e1 * t888
  t897 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t205 * t815 * t11 + 0.8e1 / 0.3e1 * t7 * t1 * t210)
  t905 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t219 * t819 * t18 - 0.8e1 / 0.3e1 * t17 * t1 * t210)
  t907 = (t897 + t905) * t26
  t909 = t116 * t907 * t174
  t911 = t116 * t824 * t163
  t912 = t168 * t825
  t913 = 0.4e1 * t912
  t914 = 0.6e1 * t299 * t349 * t877 + 0.3e1 * t787 * t882 - t192 - t194 + t200 + t240 - t246 + t273 + t462 - t465 + t540 - t872 - t873 - t876 - t887 - t889 + t909 + t911 + t913
  t915 = 0.58482236226346462072622386637590534819724553404280e0 * t557
  t917 = 0.19751673498613801407483339618206552048944131217655e-1 * t907 * t58
  t925 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t402 * t815 * t11 + 0.4e1 / 0.3e1 * t350 * t1 * t210)
  t933 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t409 * t819 * t18 - 0.4e1 / 0.3e1 * t354 * t1 * t210)
  t935 = t925 / 0.2e1 + t933 / 0.2e1
  t940 = t655 * t837
  t953 = t330 * t28 * t332
  t954 = t33 * t848
  t955 = t674 * t594
  t960 = t681 * t851
  t966 = -t192 - t194 - t872 + t200 - t873 + t240 - t246 + t273 - t876 - t887 - t889 + t909 + t911
  t967 = 0.18311447306006545054854346104378990962041954983034e-3 * t695
  t968 = t913 + t462 - t465 + t540 + t545 - t549 - t553 - t915 + t917 - t967 - t505 + t705 + t701
  t985 = (-(t966 + t968) * t309 * t316 + 0.3e1 * t843 * t591 + 0.3e1 * t588 * t845 - 0.12e2 * t315 * t297 * t388 * t835 * t359 + 0.3e1 * t315 * t590 * t935) * t318
  t1001 = t736 * t855
  t1011 = t654 + 0.7e1 / 0.144e3 * t656 + 0.7e1 / 0.144e3 * t940 + t659 * t567 * t836 * t359 / 0.16e2 - t566 * t567 * t32 * t935 / 0.48e2 + t572 * t670 * t328 * t953 * t954 * t955 / 0.1536e4 + 0.7e1 / 0.4608e4 * t960 + t685 * t687 * t954 * t689 / 0.768e3 - t577 * t579 * t580 * t985 / 0.3072e4 - t685 * t953 * t954 * t595 / 0.3072e4 + 0.7e1 / 0.4608e4 * t682 + t734 + 0.7e1 / 0.1152e4 * t737 + t685 * t687 * t33 * t835 * t595 / 0.768e3 + 0.7e1 / 0.1152e4 * t1001 + 0.5e1 / 0.768e3 * t609 * t742 * t580 * t877 - t609 * t611 * t580 * t935 / 0.768e3
  t1014 = t859 * t309
  t1023 = t338 * t848
  t1035 = t574 * t858
  t1051 = t457 * t868 * t783
  t1053 = t286 * t868
  t1057 = t371 * t835
  t1058 = t386 * t1057
  t1060 = -t439 - 0.3e1 / 0.16e2 * t1058 + t445
  t1063 = t1060 * t434 + t1058 / 0.16e2
  t1065 = t293 * t1063 * t295
  t1075 = t370 * t1057
  t1078 = t386 * t389 * t877
  t1082 = t396 * t381 * t835 * t398
  t1085 = t386 * t371 * t935
  t1092 = t1075 / 0.4e1
  t1094 = t1082 / 0.32e2
  t1100 = t783 * t835
  t1104 = t545 - t549 - t553 - t915 + t917 + 0.3e1 * t299 * t645 * t935 + t299 * t287 * (params.beta * t1011 * t345 - t1014 * t629 - t754 * t866 + 0.2e1 * t619 * t759 * t865 * t628 - t619 * t622 * (-t310 * t297 * t574 * t1023 * t595 + 0.2e1 * t310 * t297 * t669 * t1023 * t955 + t310 * t321 * t1011 - t572 * t1035 * t595 - t572 * t623 * t985 - t572 * t768 * t849)) * t783 - t299 * t869 * t635 * t631 + t787 * t1051 + 0.3e1 * t299 * t1053 * t793 + 0.3e1 * t1065 * t799 + t786 * t1063 * t295 * t298 * t287 * t348 - t967 - t505 + t1065 * t789 + t705 + t293 * ((t369 + 0.3e1 / 0.4e1 * t373 - t385 + 0.3e1 / 0.4e1 * t1075 + 0.3e1 / 0.4e1 * t1078 - 0.3e1 / 0.32e2 * t1082 - 0.3e1 / 0.16e2 * t1085 - 0.3e1 / 0.32e2 * t400 + t432) * t434 + t1060 * t359 * t448 - t1092 - t1078 / 0.4e1 + t1094 + t1085 / 0.16e2) * t295 * t458 + 0.3e1 * t299 * t792 * t1100 + t701
  t1107 = t1065 * t458
  t1109 = t299 * t645 * t835
  d12 = t184 + t583 - t111 + t806 + t813 + t166 - t182 + t826 + t186 + 0.3e1 * t809 + t871 + t2 * (t914 + t1104) + t841 + t98 - t805 + t1107 + 0.3e1 * t1109
  t1111 = t868 ** 2
  t1115 = t1063 ** 2
  t1120 = t835 ** 2
  t1122 = t386 * t389 * t1120
  t1125 = t815 ** 2
  t1129 = 0.2e1 * t9 + 0.2e1 * t211
  t1133 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t402 * t1125 + 0.2e1 / 0.3e1 * t350 * t1129)
  t1134 = t819 ** 2
  t1137 = -t1129
  t1141 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t409 * t1134 + 0.2e1 / 0.3e1 * t354 * t1137)
  t1143 = t1133 / 0.2e1 + t1141 / 0.2e1
  t1145 = t386 * t371 * t1143
  t1169 = t848 ** 2
  t1170 = t1169 * t674
  t1181 = 0.11696447245269292414524477327518106963944910680856e1 * t875
  t1187 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t205 * t1125 + 0.4e1 / 0.3e1 * t7 * t1129)
  t1193 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t219 * t1134 + 0.4e1 / 0.3e1 * t17 * t1137)
  t1195 = (t1187 + t1193) * t26
  t1197 = t116 * t1195 * t174
  t1198 = 0.2e1 * t911
  t1199 = 0.8e1 * t888
  t1200 = -t549 - t553 - t1181 + t540 + t1197 + t1198 + t465 - t1199 - t194 + t273 + t240
  t1201 = 0.8e1 * t912
  t1202 = 0.36622894612013090109708692208757981924083909966068e-3 * t886
  t1204 = 0.19751673498613801407483339618206552048944131217655e-1 * t1195 * t58
  t1205 = -t1201 - t198 + t468 - t192 - t1202 + t545 - t505 + t1204 + t462 - t246 + t701 + t705
  t1218 = (-(t1200 + t1205) * t309 * t316 + 0.6e1 * t843 * t845 - 0.12e2 * t315 * t712 * t1120 + 0.3e1 * t315 * t590 * t1143) * t318
  t1223 = t1169 * t318
  t1237 = t654 + 0.7e1 / 0.72e2 * t940 + t659 * t567 * t32 * t1120 / 0.16e2 - t566 * t567 * t32 * t1143 / 0.48e2 + t672 * t579 * t580 * t1170 / 0.1536e4 + 0.7e1 / 0.2304e4 * t960 + t685 * t687 * t954 * t318 * t835 / 0.384e3 - t577 * t579 * t580 * t1218 / 0.3072e4 - t577 * t579 * t580 * t1223 / 0.3072e4 + t734 + 0.7e1 / 0.576e3 * t1001 + 0.5e1 / 0.768e3 * t609 * t742 * t580 * t1120 - t609 * t611 * t580 * t1143 / 0.768e3
  t1242 = t865 ** 2
  t1265 = -t299 * t287 * t1111 * t635 + t293 * t1115 * t295 * t458 + t293 * ((t369 + 0.3e1 / 0.2e1 * t1075 - t385 + 0.3e1 / 0.4e1 * t1122 - 0.3e1 / 0.16e2 * t1082 - 0.3e1 / 0.16e2 * t1145 + t432) * t434 + t1060 * t835 * t448 - t1092 - t1122 / 0.4e1 + t1094 + t1145 / 0.16e2) * t295 * t458 + 0.3e1 * t299 * t645 * t1143 + t299 * t287 * (params.beta * t1237 * t345 - 0.2e1 * t1014 * t866 + 0.2e1 * t619 * t759 * t1242 - t619 * t622 * (-0.2e1 * t572 * t1035 * t849 + 0.2e1 * t572 * t764 * t1170 - t572 * t623 * t1218 - t572 * t623 * t1223 + t310 * t321 * t1237)) * t783 + t1197 - t192 - t194 - t198 + t240 - t246 + t273 - t1181 - t1202 - t1199 + t1198
  t1276 = 0.6e1 * t299 * t1053 * t1100 + 0.6e1 * t299 * t349 * t1120 + 0.2e1 * t1065 * t1051 + 0.6e1 * t1065 * t882 - t1201 + t1204 + t462 + t465 + t468 - t505 + t540 + t545 - t549 - t553 + t701 + t705
  d22 = t98 + t2 * (t1265 + t1276) - t182 + 0.2e1 * t826 + 0.2e1 * t871 - t805 + 0.2e1 * t1107 + 0.6e1 * t1109 + t166 - t111 + t186 - t177 + 0.39503346997227602814966679236413104097888262435310e-1 * t840
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

