"""Generated from gga_k_exp4.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  exp4_a1 = 199.81

  exp4_a2 = 4.3476

  exp4_c1 = 0.8524

  exp4_c2 = 1.2264

  exp4_f0 = lambda s: exp4_c1 * (1 - jnp.exp(-exp4_a1 * s ** 2)) + exp4_c2 * (1 - jnp.exp(-exp4_a2 * s ** 4))

  exp4_f = lambda x: exp4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, exp4_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  exp4_a1 = 199.81

  exp4_a2 = 4.3476

  exp4_c1 = 0.8524

  exp4_c2 = 1.2264

  exp4_f0 = lambda s: exp4_c1 * (1 - jnp.exp(-exp4_a1 * s ** 2)) + exp4_c2 * (1 - jnp.exp(-exp4_a2 * s ** 4))

  exp4_f = lambda x: exp4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, exp4_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  exp4_a1 = 199.81

  exp4_a2 = 4.3476

  exp4_c1 = 0.8524

  exp4_c2 = 1.2264

  exp4_f0 = lambda s: exp4_c1 * (1 - jnp.exp(-exp4_a1 * s ** 2)) + exp4_c2 * (1 - jnp.exp(-exp4_a2 * s ** 4))

  exp4_f = lambda x: exp4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, exp4_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * f.p.zeta_threshold
  t25 = t20 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = f.my_piecewise3(t21, t24, t26 * t20)
  t29 = t7 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = t28 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t46 = jnp.exp(-0.83254166666666666666666666666666666666666666666667e1 * t37 * s0 * t42)
  t48 = t32 ** 2
  t51 = t48 / t34 / t33
  t52 = s0 ** 2
  t53 = t38 ** 2
  t56 = 0.1e1 / t39 / t53 / r0
  t60 = jnp.exp(-0.75479166666666666666666666666666666666666666666667e-2 * t51 * t52 * t56)
  t62 = 0.20788e1 - 0.8524e0 * t46 - 0.12264e1 * t60
  t66 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * t62)
  t67 = r1 <= f.p.dens_threshold
  t68 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t69 = 0.1e1 + t68
  t70 = t69 <= f.p.zeta_threshold
  t71 = t69 ** (0.1e1 / 0.3e1)
  t72 = t71 ** 2
  t74 = f.my_piecewise3(t70, t24, t72 * t69)
  t75 = t74 * t30
  t76 = r1 ** 2
  t77 = r1 ** (0.1e1 / 0.3e1)
  t78 = t77 ** 2
  t80 = 0.1e1 / t78 / t76
  t84 = jnp.exp(-0.83254166666666666666666666666666666666666666666667e1 * t37 * s2 * t80)
  t86 = s2 ** 2
  t87 = t76 ** 2
  t90 = 0.1e1 / t77 / t87 / r1
  t94 = jnp.exp(-0.75479166666666666666666666666666666666666666666667e-2 * t51 * t86 * t90)
  t96 = 0.20788e1 - 0.8524e0 * t84 - 0.12264e1 * t94
  t100 = f.my_piecewise3(t67, 0, 0.3e1 / 0.20e2 * t6 * t75 * t96)
  t101 = t7 ** 2
  t103 = t17 / t101
  t104 = t8 - t103
  t105 = f.my_piecewise5(t11, 0, t15, 0, t104)
  t108 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t105)
  t113 = 0.1e1 / t29
  t117 = t6 * t28 * t113 * t62 / 0.10e2
  t137 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t108 * t30 * t62 + t117 + 0.3e1 / 0.20e2 * t6 * t31 * (-0.18924227111111111111111111111111111111111111111111e2 * t37 * s0 / t40 / t38 / r0 * t46 - 0.49369413333333333333333333333333333333333333333334e-1 * t51 * t52 / t39 / t53 / t38 * t60))
  t139 = f.my_piecewise5(t15, 0, t11, 0, -t104)
  t142 = f.my_piecewise3(t70, 0, 0.5e1 / 0.3e1 * t72 * t139)
  t150 = t6 * t74 * t113 * t96 / 0.10e2
  t152 = f.my_piecewise3(t67, 0, 0.3e1 / 0.20e2 * t6 * t142 * t30 * t96 + t150)
  vrho_0_ = t66 + t100 + t7 * (t137 + t152)
  t155 = -t8 - t103
  t156 = f.my_piecewise5(t11, 0, t15, 0, t155)
  t159 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t156)
  t165 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t159 * t30 * t62 + t117)
  t167 = f.my_piecewise5(t15, 0, t11, 0, -t155)
  t170 = f.my_piecewise3(t70, 0, 0.5e1 / 0.3e1 * t72 * t167)
  t194 = f.my_piecewise3(t67, 0, 0.3e1 / 0.20e2 * t6 * t170 * t30 * t96 + t150 + 0.3e1 / 0.20e2 * t6 * t75 * (-0.18924227111111111111111111111111111111111111111111e2 * t37 * s2 / t78 / t76 / r1 * t84 - 0.49369413333333333333333333333333333333333333333334e-1 * t51 * t86 / t77 / t87 / t76 * t94))
  vrho_1_ = t66 + t100 + t7 * (t165 + t194)
  t208 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * (0.70965851666666666666666666666666666666666666666667e1 * t37 * t42 * t46 + 0.18513530000000000000000000000000000000000000000000e-1 * t51 * s0 * t56 * t60))
  vsigma_0_ = t7 * t208
  vsigma_1_ = 0.0e0
  t220 = f.my_piecewise3(t67, 0, 0.3e1 / 0.20e2 * t6 * t75 * (0.70965851666666666666666666666666666666666666666667e1 * t37 * t80 * t84 + 0.18513530000000000000000000000000000000000000000000e-1 * t51 * s2 * t90 * t94))
  vsigma_2_ = t7 * t220
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  exp4_a1 = 199.81

  exp4_a2 = 4.3476

  exp4_c1 = 0.8524

  exp4_c2 = 1.2264

  exp4_f0 = lambda s: exp4_c1 * (1 - jnp.exp(-exp4_a1 * s ** 2)) + exp4_c2 * (1 - jnp.exp(-exp4_a2 * s ** 4))

  exp4_f = lambda x: exp4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, exp4_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = t20 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = r0 ** 2
  t35 = 0.1e1 / t22 / t33
  t39 = jnp.exp(-0.83254166666666666666666666666666666666666666666667e1 * t29 * s0 * t31 * t35)
  t41 = t24 ** 2
  t44 = t41 / t26 / t25
  t45 = s0 ** 2
  t47 = t33 ** 2
  t50 = 0.1e1 / t21 / t47 / r0
  t54 = jnp.exp(-0.15095833333333333333333333333333333333333333333333e-1 * t44 * t45 * t30 * t50)
  t56 = 0.20788e1 - 0.8524e0 * t39 - 0.12264e1 * t54
  t60 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t23 * t56)
  t87 = f.my_piecewise3(t2, 0, t7 * t20 / t21 * t56 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t23 * (-0.18924227111111111111111111111111111111111111111111e2 * t29 * s0 * t31 / t22 / t33 / r0 * t39 - 0.98738826666666666666666666666666666666666666666664e-1 * t44 * t45 * t30 / t21 / t47 / t33 * t54))
  vrho_0_ = 0.2e1 * r0 * t87 + 0.2e1 * t60
  t103 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t23 * (0.70965851666666666666666666666666666666666666666667e1 * t29 * t31 * t35 * t39 + 0.37027059999999999999999999999999999999999999999999e-1 * t44 * s0 * t30 * t50 * t54))
  vsigma_0_ = 0.2e1 * r0 * t103
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t23 = t20 / t21
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = r0 ** 2
  t34 = t21 ** 2
  t36 = 0.1e1 / t34 / t33
  t40 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t29 * s0 * t31 * t36)
  t42 = t24 ** 2
  t45 = t42 / t26 / t25
  t46 = s0 ** 2
  t48 = t33 ** 2
  t51 = 0.1e1 / t21 / t48 / r0
  t55 = jnp.exp(-0.15095833333333333333333333333333333333333333333333e-1 * t45 * t46 * t30 * t51)
  t57 = 0.20788e1 - 0.8524e0 * t40 - 0.12264e1 * t55
  t61 = t20 * t34
  t62 = t29 * s0
  t63 = t33 * r0
  t67 = t31 / t34 / t63 * t40
  t70 = t45 * t46
  t73 = 0.1e1 / t21 / t48 / t33
  t75 = t30 * t73 * t55
  t78 = -0.18924227111111111111111111111111111111111111111110e2 * t62 * t67 - 0.98738826666666666666666666666666666666666666666664e-1 * t70 * t75
  t83 = f.my_piecewise3(t2, 0, t7 * t23 * t57 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t61 * t78)
  t103 = t30 / t21 / t48 / t63
  t110 = t25 ** 2
  t113 = t24 / t27 / t110
  t114 = t46 ** 2
  t116 = t48 ** 2
  t129 = f.my_piecewise3(t2, 0, -t7 * t20 / t21 / r0 * t57 / 0.30e2 + t7 * t23 * t78 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t61 * (0.69388832740740740740740740740740740740740740740737e2 * t62 * t31 / t34 / t48 * t40 - 0.84027773757135802469135802469135802469135802469127e3 * t70 * t103 * t40 + 0.62534590222222222222222222222222222222222222222221e0 * t70 * t103 * t55 - 0.47697435868444444444444444444444444444444444444442e-1 * t113 * t114 * t31 / t34 / t116 / t48 * t55))
  v2rho2_0_ = 0.2e1 * r0 * t129 + 0.4e1 * t83
  t136 = t45 * s0
  t137 = t30 * t51
  t138 = t137 * t55
  t141 = 0.70965851666666666666666666666666666666666666666664e1 * t29 * t31 * t36 * t40 + 0.37027059999999999999999999999999999999999999999999e-1 * t136 * t138
  t145 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t61 * t141)
  t172 = f.my_piecewise3(t2, 0, t7 * t23 * t141 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t61 * (-0.18924227111111111111111111111111111111111111111110e2 * t29 * t67 + 0.31510415158925925925925925925925925925925925925923e3 * t45 * t30 * t73 * s0 * t40 - 0.19747765333333333333333333333333333333333333333333e0 * t136 * t75 + 0.17886538450666666666666666666666666666666666666666e-1 * t113 * t46 * s0 * t31 / t34 / t116 / t63 * t55))
  v2rhosigma_0_ = 0.2e1 * r0 * t172 + 0.2e1 * t145
  t192 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t61 * (-0.11816405684597222222222222222222222222222222222222e3 * t45 * t137 * t40 + 0.37027059999999999999999999999999999999999999999999e-1 * t45 * t138 - 0.67074519189999999999999999999999999999999999999998e-2 * t113 * t46 * t31 / t34 / t116 / t33 * t55))
  v2sigma2_0_ = 0.2e1 * r0 * t192
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t24 = t20 / t21 / r0
  t25 = 6 ** (0.1e1 / 0.3e1)
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t30 = t25 / t28
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = r0 ** 2
  t35 = t21 ** 2
  t41 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t30 * s0 * t32 / t35 / t34)
  t43 = t25 ** 2
  t46 = t43 / t27 / t26
  t47 = s0 ** 2
  t49 = t34 ** 2
  t50 = t49 * r0
  t56 = jnp.exp(-0.15095833333333333333333333333333333333333333333333e-1 * t46 * t47 * t31 / t21 / t50)
  t58 = 0.20788e1 - 0.8524e0 * t41 - 0.12264e1 * t56
  t63 = t20 / t21
  t64 = t30 * s0
  t65 = t34 * r0
  t72 = t46 * t47
  t80 = -0.18924227111111111111111111111111111111111111111110e2 * t64 * t32 / t35 / t65 * t41 - 0.98738826666666666666666666666666666666666666666664e-1 * t72 * t31 / t21 / t49 / t34 * t56
  t84 = t20 * t35
  t94 = t31 / t21 / t49 / t65
  t101 = t26 ** 2
  t105 = t47 ** 2
  t106 = t25 / t28 / t101 * t105
  t107 = t49 ** 2
  t115 = 0.69388832740740740740740740740740740740740740740737e2 * t64 * t32 / t35 / t49 * t41 - 0.84027773757135802469135802469135802469135802469127e3 * t72 * t94 * t41 + 0.62534590222222222222222222222222222222222222222221e0 * t72 * t94 * t56 - 0.47697435868444444444444444444444444444444444444442e-1 * t106 * t32 / t35 / t107 / t49 * t56
  t120 = f.my_piecewise3(t2, 0, -t7 * t24 * t58 / 0.30e2 + t7 * t63 * t80 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t84 * t115)
  t142 = t31 / t21 / t107
  t164 = t101 ** 2
  t168 = t107 ** 2
  t179 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 / t21 / t34 * t58 - t7 * t24 * t80 / 0.10e2 + 0.3e1 / 0.10e2 * t7 * t63 * t115 + 0.3e1 / 0.20e2 * t7 * t84 * (-0.32381455279012345679012345679012345679012345679011e3 * t64 * t32 / t35 / t50 * t41 + 0.92430551132849382716049382716049382716049382716040e4 * t72 * t142 * t41 - 0.22386119299217739588477366255144032921810699588474e6 / t101 * t47 * s0 / t107 / t65 * t41 - 0.45858699496296296296296296296296296296296296296295e1 * t72 * t142 * t56 + 0.90625128150044444444444444444444444444444444444440e0 * t106 * t32 / t35 / t107 / t50 * t56 - 0.46082082707033125925925925925925925925925925925922e-1 / t164 * t105 * t47 / t168 / t65 * t56))
  v3rho3_0_ = 0.2e1 * r0 * t179 + 0.6e1 * t120

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** 2
  t22 = r0 ** (0.1e1 / 0.3e1)
  t25 = t20 / t22 / t21
  t26 = 6 ** (0.1e1 / 0.3e1)
  t27 = jnp.pi ** 2
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = t26 / t29
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = t22 ** 2
  t41 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t31 * s0 * t33 / t35 / t21)
  t43 = t26 ** 2
  t46 = t43 / t28 / t27
  t47 = s0 ** 2
  t49 = t21 ** 2
  t50 = t49 * r0
  t56 = jnp.exp(-0.15095833333333333333333333333333333333333333333333e-1 * t46 * t47 * t32 / t22 / t50)
  t58 = 0.20788e1 - 0.8524e0 * t41 - 0.12264e1 * t56
  t64 = t20 / t22 / r0
  t65 = t31 * s0
  t66 = t21 * r0
  t73 = t46 * t47
  t74 = t49 * t21
  t81 = -0.18924227111111111111111111111111111111111111111110e2 * t65 * t33 / t35 / t66 * t41 - 0.98738826666666666666666666666666666666666666666664e-1 * t73 * t32 / t22 / t74 * t56
  t86 = t20 / t22
  t96 = t32 / t22 / t49 / t66
  t103 = t27 ** 2
  t107 = t47 ** 2
  t108 = t26 / t29 / t103 * t107
  t109 = t49 ** 2
  t110 = t109 * t49
  t117 = 0.69388832740740740740740740740740740740740740740737e2 * t65 * t33 / t35 / t49 * t41 - 0.84027773757135802469135802469135802469135802469127e3 * t73 * t96 * t41 + 0.62534590222222222222222222222222222222222222222221e0 * t73 * t96 * t56 - 0.47697435868444444444444444444444444444444444444442e-1 * t108 * t33 / t35 / t110 * t56
  t121 = t20 * t35
  t130 = t32 / t22 / t109
  t134 = 0.1e1 / t103
  t136 = t134 * t47 * s0
  t152 = t103 ** 2
  t153 = 0.1e1 / t152
  t155 = t153 * t107 * t47
  t156 = t109 ** 2
  t162 = -0.32381455279012345679012345679012345679012345679011e3 * t65 * t33 / t35 / t50 * t41 + 0.92430551132849382716049382716049382716049382716040e4 * t73 * t130 * t41 - 0.22386119299217739588477366255144032921810699588474e6 * t136 / t109 / t66 * t41 - 0.45858699496296296296296296296296296296296296296295e1 * t73 * t130 * t56 + 0.90625128150044444444444444444444444444444444444440e0 * t108 * t33 / t35 / t109 / t50 * t56 - 0.46082082707033125925925925925925925925925925925922e-1 * t155 / t156 / t66 * t56
  t167 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t25 * t58 - t7 * t64 * t81 / 0.10e2 + 0.3e1 / 0.10e2 * t7 * t86 * t117 + 0.3e1 / 0.20e2 * t7 * t121 * t162)
  t190 = t109 * r0
  t193 = t32 / t22 / t190
  t204 = 0.1e1 / t35 / t109 / t74
  t222 = t107 ** 2
  t237 = f.my_piecewise3(t2, 0, -0.14e2 / 0.135e3 * t7 * t20 / t22 / t66 * t58 + 0.8e1 / 0.45e2 * t7 * t25 * t81 - t7 * t64 * t117 / 0.5e1 + 0.2e1 / 0.5e1 * t7 * t86 * t162 + 0.3e1 / 0.20e2 * t7 * t121 * (0.18349491324773662551440329218106995884773662551440e4 * t65 * t33 / t35 / t74 * t41 - 0.91403545009151056241426611796982167352537722908084e5 * t73 * t193 * t41 + 0.49249462458279027094650205761316872427983539094642e7 * t136 / t110 * t41 - 0.49699672190852183857485139460448102423411065386364e7 * t134 * t107 * t204 * t31 * t33 * t41 + 0.38215582913580246913580246913580246913580246913579e2 * t73 * t193 * t56 - 0.14600715090840493827160493827160493827160493827159e2 * t108 * t33 * t204 * t56 + 0.17511191428672587851851851851851851851851851851850e1 * t155 / t156 / t49 * t56 - 0.37101196810573558939917695473251028806584362139914e-2 * t153 * t222 / t22 / t156 / t190 * t46 * t32 * t56))
  v4rho4_0_ = 0.2e1 * r0 * t237 + 0.8e1 * t167

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t26 = t17 * t25
  t27 = t8 - t26
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t31 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t28)
  t32 = t7 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t31 * t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = t35 / t38
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t49 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t40 * s0 / t43 / t41)
  t51 = t35 ** 2
  t54 = t51 / t37 / t36
  t55 = s0 ** 2
  t56 = t41 ** 2
  t63 = jnp.exp(-0.75479166666666666666666666666666666666666666666666e-2 * t54 * t55 / t42 / t56 / r0)
  t65 = 0.20788e1 - 0.8524e0 * t49 - 0.12264e1 * t63
  t69 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t70 = t69 ** 2
  t71 = t70 * f.p.zeta_threshold
  t73 = f.my_piecewise3(t21, t71, t23 * t20)
  t74 = 0.1e1 / t32
  t75 = t73 * t74
  t78 = t6 * t75 * t65 / 0.10e2
  t79 = t73 * t33
  t80 = t41 * r0
  t94 = -0.18924227111111111111111111111111111111111111111110e2 * t40 * s0 / t43 / t80 * t49 - 0.49369413333333333333333333333333333333333333333333e-1 * t54 * t55 / t42 / t56 / t41 * t63
  t99 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t34 * t65 + t78 + 0.3e1 / 0.20e2 * t6 * t79 * t94)
  t101 = r1 <= f.p.dens_threshold
  t102 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t103 = 0.1e1 + t102
  t104 = t103 <= f.p.zeta_threshold
  t105 = t103 ** (0.1e1 / 0.3e1)
  t106 = t105 ** 2
  t108 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t111 = f.my_piecewise3(t104, 0, 0.5e1 / 0.3e1 * t106 * t108)
  t112 = t111 * t33
  t113 = r1 ** 2
  t114 = r1 ** (0.1e1 / 0.3e1)
  t115 = t114 ** 2
  t121 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t40 * s2 / t115 / t113)
  t123 = s2 ** 2
  t124 = t113 ** 2
  t131 = jnp.exp(-0.75479166666666666666666666666666666666666666666666e-2 * t54 * t123 / t114 / t124 / r1)
  t133 = 0.20788e1 - 0.8524e0 * t121 - 0.12264e1 * t131
  t138 = f.my_piecewise3(t104, t71, t106 * t103)
  t139 = t138 * t74
  t142 = t6 * t139 * t133 / 0.10e2
  t144 = f.my_piecewise3(t101, 0, 0.3e1 / 0.20e2 * t6 * t112 * t133 + t142)
  t146 = 0.1e1 / t22
  t147 = t28 ** 2
  t152 = t17 / t24 / t7
  t154 = -0.2e1 * t25 + 0.2e1 * t152
  t155 = f.my_piecewise5(t11, 0, t15, 0, t154)
  t159 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t146 * t147 + 0.5e1 / 0.3e1 * t23 * t155)
  t166 = t6 * t31 * t74 * t65
  t172 = 0.1e1 / t32 / t7
  t176 = t6 * t73 * t172 * t65 / 0.30e2
  t178 = t6 * t75 * t94
  t189 = t55 / t42 / t56 / t80
  t196 = t36 ** 2
  t199 = t35 / t38 / t196
  t200 = t55 ** 2
  t201 = t56 ** 2
  t214 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t159 * t33 * t65 + t166 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t34 * t94 - t176 + t178 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t79 * (0.69388832740740740740740740740740740740740740740737e2 * t40 * s0 / t43 / t56 * t49 - 0.42013886878567901234567901234567901234567901234563e3 * t54 * t189 * t49 + 0.31267295111111111111111111111111111111111111111111e0 * t54 * t189 * t63 - 0.11924358967111111111111111111111111111111111111111e-1 * t199 * t200 / t43 / t201 / t56 * t63))
  t215 = 0.1e1 / t105
  t216 = t108 ** 2
  t220 = f.my_piecewise5(t15, 0, t11, 0, -t154)
  t224 = f.my_piecewise3(t104, 0, 0.10e2 / 0.9e1 * t215 * t216 + 0.5e1 / 0.3e1 * t106 * t220)
  t231 = t6 * t111 * t74 * t133
  t236 = t6 * t138 * t172 * t133 / 0.30e2
  t238 = f.my_piecewise3(t101, 0, 0.3e1 / 0.20e2 * t6 * t224 * t33 * t133 + t231 / 0.5e1 - t236)
  d11 = 0.2e1 * t99 + 0.2e1 * t144 + t7 * (t214 + t238)
  t241 = -t8 - t26
  t242 = f.my_piecewise5(t11, 0, t15, 0, t241)
  t245 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t242)
  t246 = t245 * t33
  t251 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t246 * t65 + t78)
  t253 = f.my_piecewise5(t15, 0, t11, 0, -t241)
  t256 = f.my_piecewise3(t104, 0, 0.5e1 / 0.3e1 * t106 * t253)
  t257 = t256 * t33
  t261 = t138 * t33
  t262 = t113 * r1
  t276 = -0.18924227111111111111111111111111111111111111111110e2 * t40 * s2 / t115 / t262 * t121 - 0.49369413333333333333333333333333333333333333333333e-1 * t54 * t123 / t114 / t124 / t113 * t131
  t281 = f.my_piecewise3(t101, 0, 0.3e1 / 0.20e2 * t6 * t257 * t133 + t142 + 0.3e1 / 0.20e2 * t6 * t261 * t276)
  t285 = 0.2e1 * t152
  t286 = f.my_piecewise5(t11, 0, t15, 0, t285)
  t290 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t146 * t242 * t28 + 0.5e1 / 0.3e1 * t23 * t286)
  t297 = t6 * t245 * t74 * t65
  t305 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t290 * t33 * t65 + t297 / 0.10e2 + 0.3e1 / 0.20e2 * t6 * t246 * t94 + t166 / 0.10e2 - t176 + t178 / 0.10e2)
  t309 = f.my_piecewise5(t15, 0, t11, 0, -t285)
  t313 = f.my_piecewise3(t104, 0, 0.10e2 / 0.9e1 * t215 * t253 * t108 + 0.5e1 / 0.3e1 * t106 * t309)
  t320 = t6 * t256 * t74 * t133
  t327 = t6 * t139 * t276
  t330 = f.my_piecewise3(t101, 0, 0.3e1 / 0.20e2 * t6 * t313 * t33 * t133 + t320 / 0.10e2 + t231 / 0.10e2 - t236 + 0.3e1 / 0.20e2 * t6 * t112 * t276 + t327 / 0.10e2)
  d12 = t99 + t144 + t251 + t281 + t7 * (t305 + t330)
  t335 = t242 ** 2
  t339 = 0.2e1 * t25 + 0.2e1 * t152
  t340 = f.my_piecewise5(t11, 0, t15, 0, t339)
  t344 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t146 * t335 + 0.5e1 / 0.3e1 * t23 * t340)
  t351 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t344 * t33 * t65 + t297 / 0.5e1 - t176)
  t352 = t253 ** 2
  t356 = f.my_piecewise5(t15, 0, t11, 0, -t339)
  t360 = f.my_piecewise3(t104, 0, 0.10e2 / 0.9e1 * t215 * t352 + 0.5e1 / 0.3e1 * t106 * t356)
  t379 = t123 / t114 / t124 / t262
  t386 = t123 ** 2
  t387 = t124 ** 2
  t400 = f.my_piecewise3(t101, 0, 0.3e1 / 0.20e2 * t6 * t360 * t33 * t133 + t320 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t257 * t276 - t236 + t327 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t261 * (0.69388832740740740740740740740740740740740740740737e2 * t40 * s2 / t115 / t124 * t121 - 0.42013886878567901234567901234567901234567901234563e3 * t54 * t379 * t121 + 0.31267295111111111111111111111111111111111111111111e0 * t54 * t379 * t131 - 0.11924358967111111111111111111111111111111111111111e-1 * t199 * t386 / t115 / t387 / t124 * t131))
  d22 = 0.2e1 * t251 + 0.2e1 * t281 + t7 * (t351 + t400)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t22
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t27 = -t17 * t25 + t8
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t29 = t28 ** 2
  t32 = t22 ** 2
  t34 = 0.1e1 / t24 / t7
  t37 = 0.2e1 * t17 * t34 - 0.2e1 * t25
  t38 = f.my_piecewise5(t11, 0, t15, 0, t37)
  t42 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t23 * t29 + 0.5e1 / 0.3e1 * t32 * t38)
  t43 = t7 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t45 = t42 * t44
  t46 = 6 ** (0.1e1 / 0.3e1)
  t47 = jnp.pi ** 2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t49 = t48 ** 2
  t51 = t46 / t49
  t52 = r0 ** 2
  t53 = r0 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t60 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t51 * s0 / t54 / t52)
  t62 = t46 ** 2
  t65 = t62 / t48 / t47
  t66 = s0 ** 2
  t67 = t52 ** 2
  t68 = t67 * r0
  t74 = jnp.exp(-0.75479166666666666666666666666666666666666666666666e-2 * t65 * t66 / t53 / t68)
  t76 = 0.20788e1 - 0.8524e0 * t60 - 0.12264e1 * t74
  t82 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t32 * t28)
  t83 = 0.1e1 / t43
  t84 = t82 * t83
  t88 = t82 * t44
  t89 = t52 * r0
  t103 = -0.18924227111111111111111111111111111111111111111110e2 * t51 * s0 / t54 / t89 * t60 - 0.49369413333333333333333333333333333333333333333333e-1 * t65 * t66 / t53 / t67 / t52 * t74
  t107 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t108 = t107 ** 2
  t109 = t108 * f.p.zeta_threshold
  t111 = f.my_piecewise3(t21, t109, t32 * t20)
  t113 = 0.1e1 / t43 / t7
  t114 = t111 * t113
  t118 = t111 * t83
  t122 = t111 * t44
  t132 = t66 / t53 / t67 / t89
  t139 = t47 ** 2
  t142 = t46 / t49 / t139
  t143 = t66 ** 2
  t144 = t67 ** 2
  t152 = 0.69388832740740740740740740740740740740740740740737e2 * t51 * s0 / t54 / t67 * t60 - 0.42013886878567901234567901234567901234567901234563e3 * t65 * t132 * t60 + 0.31267295111111111111111111111111111111111111111111e0 * t65 * t132 * t74 - 0.11924358967111111111111111111111111111111111111111e-1 * t142 * t143 / t54 / t144 / t67 * t74
  t157 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t45 * t76 + t6 * t84 * t76 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t88 * t103 - t6 * t114 * t76 / 0.30e2 + t6 * t118 * t103 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t122 * t152)
  t159 = r1 <= f.p.dens_threshold
  t160 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t161 = 0.1e1 + t160
  t162 = t161 <= f.p.zeta_threshold
  t163 = t161 ** (0.1e1 / 0.3e1)
  t164 = 0.1e1 / t163
  t166 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t167 = t166 ** 2
  t170 = t163 ** 2
  t172 = f.my_piecewise5(t15, 0, t11, 0, -t37)
  t176 = f.my_piecewise3(t162, 0, 0.10e2 / 0.9e1 * t164 * t167 + 0.5e1 / 0.3e1 * t170 * t172)
  t178 = r1 ** 2
  t179 = r1 ** (0.1e1 / 0.3e1)
  t180 = t179 ** 2
  t186 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t51 * s2 / t180 / t178)
  t188 = s2 ** 2
  t189 = t178 ** 2
  t196 = jnp.exp(-0.75479166666666666666666666666666666666666666666666e-2 * t65 * t188 / t179 / t189 / r1)
  t198 = 0.20788e1 - 0.8524e0 * t186 - 0.12264e1 * t196
  t204 = f.my_piecewise3(t162, 0, 0.5e1 / 0.3e1 * t170 * t166)
  t210 = f.my_piecewise3(t162, t109, t170 * t161)
  t216 = f.my_piecewise3(t159, 0, 0.3e1 / 0.20e2 * t6 * t176 * t44 * t198 + t6 * t204 * t83 * t198 / 0.5e1 - t6 * t210 * t113 * t198 / 0.30e2)
  t226 = t24 ** 2
  t230 = 0.6e1 * t34 - 0.6e1 * t17 / t226
  t231 = f.my_piecewise5(t11, 0, t15, 0, t230)
  t235 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 / t22 / t20 * t29 * t28 + 0.10e2 / 0.3e1 * t23 * t28 * t38 + 0.5e1 / 0.3e1 * t32 * t231)
  t258 = 0.1e1 / t43 / t24
  t277 = t66 / t53 / t144
  t299 = t139 ** 2
  t303 = t144 ** 2
  t314 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t235 * t44 * t76 + 0.3e1 / 0.10e2 * t6 * t42 * t83 * t76 + 0.9e1 / 0.20e2 * t6 * t45 * t103 - t6 * t82 * t113 * t76 / 0.10e2 + 0.3e1 / 0.5e1 * t6 * t84 * t103 + 0.9e1 / 0.20e2 * t6 * t88 * t152 + 0.2e1 / 0.45e2 * t6 * t111 * t258 * t76 - t6 * t114 * t103 / 0.10e2 + 0.3e1 / 0.10e2 * t6 * t118 * t152 + 0.3e1 / 0.20e2 * t6 * t122 * (-0.32381455279012345679012345679012345679012345679011e3 * t51 * s0 / t54 / t68 * t60 + 0.46215275566424691358024691358024691358024691358020e4 * t65 * t277 * t60 - 0.55965298248044348971193415637860082304526748971184e5 / t139 * t66 * s0 / t144 / t89 * t60 - 0.22929349748148148148148148148148148148148148148148e1 * t65 * t277 * t74 + 0.22656282037511111111111111111111111111111111111111e0 * t142 * t143 / t54 / t144 / t68 * t74 - 0.28801301691895703703703703703703703703703703703703e-2 / t299 * t143 * t66 / t303 / t89 * t74))
  t324 = f.my_piecewise5(t15, 0, t11, 0, -t230)
  t328 = f.my_piecewise3(t162, 0, -0.10e2 / 0.27e2 / t163 / t161 * t167 * t166 + 0.10e2 / 0.3e1 * t164 * t166 * t172 + 0.5e1 / 0.3e1 * t170 * t324)
  t346 = f.my_piecewise3(t159, 0, 0.3e1 / 0.20e2 * t6 * t328 * t44 * t198 + 0.3e1 / 0.10e2 * t6 * t176 * t83 * t198 - t6 * t204 * t113 * t198 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t210 * t258 * t198)
  d111 = 0.3e1 * t157 + 0.3e1 * t216 + t7 * (t314 + t346)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t20
  t25 = t7 ** 2
  t26 = 0.1e1 / t25
  t28 = -t17 * t26 + t8
  t29 = f.my_piecewise5(t11, 0, t15, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t7
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t17 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t11, 0, t15, 0, t40)
  t44 = t22 ** 2
  t45 = t25 ** 2
  t46 = 0.1e1 / t45
  t49 = -0.6e1 * t17 * t46 + 0.6e1 * t37
  t50 = f.my_piecewise5(t11, 0, t15, 0, t49)
  t54 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t24 * t30 * t29 + 0.10e2 / 0.3e1 * t35 * t41 + 0.5e1 / 0.3e1 * t44 * t50)
  t55 = t7 ** (0.1e1 / 0.3e1)
  t56 = t55 ** 2
  t57 = t54 * t56
  t58 = 6 ** (0.1e1 / 0.3e1)
  t59 = jnp.pi ** 2
  t60 = t59 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t63 = t58 / t61
  t64 = r0 ** 2
  t65 = r0 ** (0.1e1 / 0.3e1)
  t66 = t65 ** 2
  t72 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t63 * s0 / t66 / t64)
  t74 = t58 ** 2
  t77 = t74 / t60 / t59
  t78 = s0 ** 2
  t79 = t64 ** 2
  t80 = t79 * r0
  t86 = jnp.exp(-0.75479166666666666666666666666666666666666666666666e-2 * t77 * t78 / t65 / t80)
  t88 = 0.20788e1 - 0.8524e0 * t72 - 0.12264e1 * t86
  t97 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t34 * t30 + 0.5e1 / 0.3e1 * t44 * t41)
  t98 = 0.1e1 / t55
  t99 = t97 * t98
  t103 = t97 * t56
  t104 = t64 * r0
  t111 = t79 * t64
  t118 = -0.18924227111111111111111111111111111111111111111110e2 * t63 * s0 / t66 / t104 * t72 - 0.49369413333333333333333333333333333333333333333333e-1 * t77 * t78 / t65 / t111 * t86
  t124 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t44 * t29)
  t126 = 0.1e1 / t55 / t7
  t127 = t124 * t126
  t131 = t124 * t98
  t135 = t124 * t56
  t145 = t78 / t65 / t79 / t104
  t152 = t59 ** 2
  t155 = t58 / t61 / t152
  t156 = t78 ** 2
  t157 = t79 ** 2
  t158 = t157 * t79
  t165 = 0.69388832740740740740740740740740740740740740740737e2 * t63 * s0 / t66 / t79 * t72 - 0.42013886878567901234567901234567901234567901234563e3 * t77 * t145 * t72 + 0.31267295111111111111111111111111111111111111111111e0 * t77 * t145 * t86 - 0.11924358967111111111111111111111111111111111111111e-1 * t155 * t156 / t66 / t158 * t86
  t169 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t170 = t169 ** 2
  t171 = t170 * f.p.zeta_threshold
  t173 = f.my_piecewise3(t21, t171, t44 * t20)
  t175 = 0.1e1 / t55 / t25
  t176 = t173 * t175
  t180 = t173 * t126
  t184 = t173 * t98
  t188 = t173 * t56
  t197 = t78 / t65 / t157
  t201 = 0.1e1 / t152
  t203 = t201 * t78 * s0
  t219 = t152 ** 2
  t220 = 0.1e1 / t219
  t222 = t220 * t156 * t78
  t223 = t157 ** 2
  t229 = -0.32381455279012345679012345679012345679012345679011e3 * t63 * s0 / t66 / t80 * t72 + 0.46215275566424691358024691358024691358024691358020e4 * t77 * t197 * t72 - 0.55965298248044348971193415637860082304526748971184e5 * t203 / t157 / t104 * t72 - 0.22929349748148148148148148148148148148148148148148e1 * t77 * t197 * t86 + 0.22656282037511111111111111111111111111111111111111e0 * t155 * t156 / t66 / t157 / t80 * t86 - 0.28801301691895703703703703703703703703703703703703e-2 * t222 / t223 / t104 * t86
  t234 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t57 * t88 + 0.3e1 / 0.10e2 * t6 * t99 * t88 + 0.9e1 / 0.20e2 * t6 * t103 * t118 - t6 * t127 * t88 / 0.10e2 + 0.3e1 / 0.5e1 * t6 * t131 * t118 + 0.9e1 / 0.20e2 * t6 * t135 * t165 + 0.2e1 / 0.45e2 * t6 * t176 * t88 - t6 * t180 * t118 / 0.10e2 + 0.3e1 / 0.10e2 * t6 * t184 * t165 + 0.3e1 / 0.20e2 * t6 * t188 * t229)
  t236 = r1 <= f.p.dens_threshold
  t237 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t238 = 0.1e1 + t237
  t239 = t238 <= f.p.zeta_threshold
  t240 = t238 ** (0.1e1 / 0.3e1)
  t242 = 0.1e1 / t240 / t238
  t244 = f.my_piecewise5(t15, 0, t11, 0, -t28)
  t245 = t244 ** 2
  t249 = 0.1e1 / t240
  t250 = t249 * t244
  t252 = f.my_piecewise5(t15, 0, t11, 0, -t40)
  t255 = t240 ** 2
  t257 = f.my_piecewise5(t15, 0, t11, 0, -t49)
  t261 = f.my_piecewise3(t239, 0, -0.10e2 / 0.27e2 * t242 * t245 * t244 + 0.10e2 / 0.3e1 * t250 * t252 + 0.5e1 / 0.3e1 * t255 * t257)
  t263 = r1 ** 2
  t264 = r1 ** (0.1e1 / 0.3e1)
  t265 = t264 ** 2
  t271 = jnp.exp(-0.83254166666666666666666666666666666666666666666664e1 * t63 * s2 / t265 / t263)
  t273 = s2 ** 2
  t274 = t263 ** 2
  t281 = jnp.exp(-0.75479166666666666666666666666666666666666666666666e-2 * t77 * t273 / t264 / t274 / r1)
  t283 = 0.20788e1 - 0.8524e0 * t271 - 0.12264e1 * t281
  t292 = f.my_piecewise3(t239, 0, 0.10e2 / 0.9e1 * t249 * t245 + 0.5e1 / 0.3e1 * t255 * t252)
  t299 = f.my_piecewise3(t239, 0, 0.5e1 / 0.3e1 * t255 * t244)
  t305 = f.my_piecewise3(t239, t171, t255 * t238)
  t311 = f.my_piecewise3(t236, 0, 0.3e1 / 0.20e2 * t6 * t261 * t56 * t283 + 0.3e1 / 0.10e2 * t6 * t292 * t98 * t283 - t6 * t299 * t126 * t283 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t305 * t175 * t283)
  t319 = t157 * r0
  t322 = t78 / t65 / t319
  t333 = 0.1e1 / t66 / t157 / t111
  t350 = t156 ** 2
  t375 = t20 ** 2
  t378 = t30 ** 2
  t384 = t41 ** 2
  t393 = -0.24e2 * t46 + 0.24e2 * t17 / t45 / t7
  t394 = f.my_piecewise5(t11, 0, t15, 0, t393)
  t398 = f.my_piecewise3(t21, 0, 0.40e2 / 0.81e2 / t22 / t375 * t378 - 0.20e2 / 0.9e1 * t24 * t30 * t41 + 0.10e2 / 0.3e1 * t34 * t384 + 0.40e2 / 0.9e1 * t35 * t50 + 0.5e1 / 0.3e1 * t44 * t394)
  t431 = 0.1e1 / t55 / t36
  t436 = 0.3e1 / 0.20e2 * t6 * t188 * (0.18349491324773662551440329218106995884773662551440e4 * t63 * s0 / t66 / t111 * t72 - 0.45701772504575528120713305898491083676268861454042e5 * t77 * t322 * t72 + 0.12312365614569756773662551440329218106995884773660e7 * t203 / t158 * t72 - 0.12424918047713045964371284865112025605852766346591e7 * t201 * t156 * t333 * t63 * t72 + 0.19107791456790123456790123456790123456790123456790e2 * t77 * t322 * t86 - 0.36501787727101234567901234567901234567901234567901e1 * t155 * t156 * t333 * t86 + 0.10944494642920367407407407407407407407407407407407e0 * t222 / t223 / t79 * t86 - 0.11594124003304237168724279835390946502057613168724e-3 * t220 * t350 / t65 / t223 / t319 * t77 * t86) + 0.3e1 / 0.5e1 * t6 * t135 * t229 + 0.8e1 / 0.45e2 * t6 * t176 * t118 - t6 * t180 * t165 / 0.5e1 + 0.2e1 / 0.5e1 * t6 * t184 * t229 + 0.3e1 / 0.20e2 * t6 * t398 * t56 * t88 + 0.3e1 / 0.5e1 * t6 * t57 * t118 + 0.6e1 / 0.5e1 * t6 * t99 * t118 + 0.9e1 / 0.10e2 * t6 * t103 * t165 - 0.2e1 / 0.5e1 * t6 * t127 * t118 + 0.6e1 / 0.5e1 * t6 * t131 * t165 + 0.2e1 / 0.5e1 * t6 * t54 * t98 * t88 - t6 * t97 * t126 * t88 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t124 * t175 * t88 - 0.14e2 / 0.135e3 * t6 * t173 * t431 * t88
  t437 = f.my_piecewise3(t1, 0, t436)
  t438 = t238 ** 2
  t441 = t245 ** 2
  t447 = t252 ** 2
  t453 = f.my_piecewise5(t15, 0, t11, 0, -t393)
  t457 = f.my_piecewise3(t239, 0, 0.40e2 / 0.81e2 / t240 / t438 * t441 - 0.20e2 / 0.9e1 * t242 * t245 * t252 + 0.10e2 / 0.3e1 * t249 * t447 + 0.40e2 / 0.9e1 * t250 * t257 + 0.5e1 / 0.3e1 * t255 * t453)
  t479 = f.my_piecewise3(t236, 0, 0.3e1 / 0.20e2 * t6 * t457 * t56 * t283 + 0.2e1 / 0.5e1 * t6 * t261 * t98 * t283 - t6 * t292 * t126 * t283 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t299 * t175 * t283 - 0.14e2 / 0.135e3 * t6 * t305 * t431 * t283)
  d1111 = 0.4e1 * t234 + 0.4e1 * t311 + t7 * (t437 + t479)

  res = {'v4rho4': d1111}
  return res
