"""Generated from gga_x_2d_b86.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  _2d_b86_beta = 0.002105

  _2d_b86_gamma = 0.000119

  _2d_b86_f = lambda x: (1 + _2d_b86_beta * x ** 2) / (1 + _2d_b86_gamma * x ** 2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  _2d_b86_beta = 0.002105

  _2d_b86_gamma = 0.000119

  _2d_b86_f = lambda x: (1 + _2d_b86_beta * x ** 2) / (1 + _2d_b86_gamma * x ** 2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  _2d_b86_beta = 0.002105

  _2d_b86_gamma = 0.000119

  _2d_b86_f = lambda x: (1 + _2d_b86_beta * x ** 2) / (1 + _2d_b86_gamma * x ** 2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = r0 ** 2
  t29 = r0 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t32 = 0.1e1 / t30 / t28
  t33 = s0 * t32
  t35 = 0.1e1 + 0.2105e-2 * t33
  t36 = t27 * t35
  t38 = 0.1e1 + 0.119e-3 * t33
  t39 = 0.1e1 / t38
  t40 = t36 * t39
  t43 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t40)
  t44 = r1 <= f.p.dens_threshold
  t45 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t46 = 0.1e1 + t45
  t47 = t46 <= f.p.zeta_threshold
  t48 = t46 ** (0.1e1 / 0.3e1)
  t50 = f.my_piecewise3(t47, t22, t48 * t46)
  t51 = t5 * t50
  t52 = r1 ** 2
  t53 = r1 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t56 = 0.1e1 / t54 / t52
  t57 = s2 * t56
  t59 = 0.1e1 + 0.2105e-2 * t57
  t60 = t27 * t59
  t62 = 0.1e1 + 0.119e-3 * t57
  t63 = 0.1e1 / t62
  t64 = t60 * t63
  t67 = f.my_piecewise3(t44, 0, -0.3e1 / 0.8e1 * t51 * t64)
  t68 = t6 ** 2
  t70 = t16 / t68
  t71 = t7 - t70
  t72 = f.my_piecewise5(t10, 0, t14, 0, t71)
  t75 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t72)
  t79 = t27 ** 2
  t80 = 0.1e1 / t79
  t84 = t26 * t80 * t35 * t39 / 0.8e1
  t88 = 0.1e1 / t30 / t28 / r0
  t95 = t38 ** 2
  t96 = 0.1e1 / t95
  t103 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t75 * t40 - t84 + 0.21050000000000000000000000000000000000000000000000e-2 * t26 * t27 * s0 * t88 * t39 - 0.11900000000000000000000000000000000000000000000000e-3 * t5 * t25 * t27 * t35 * t96 * s0 * t88)
  t105 = f.my_piecewise5(t14, 0, t10, 0, -t71)
  t108 = f.my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t105)
  t115 = t51 * t80 * t59 * t63 / 0.8e1
  t117 = f.my_piecewise3(t44, 0, -0.3e1 / 0.8e1 * t5 * t108 * t64 - t115)
  vrho_0_ = t43 + t67 + t6 * (t103 + t117)
  t120 = -t7 - t70
  t121 = f.my_piecewise5(t10, 0, t14, 0, t120)
  t124 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t121)
  t129 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t124 * t40 - t84)
  t131 = f.my_piecewise5(t14, 0, t10, 0, -t120)
  t134 = f.my_piecewise3(t47, 0, 0.4e1 / 0.3e1 * t48 * t131)
  t141 = 0.1e1 / t54 / t52 / r1
  t148 = t62 ** 2
  t149 = 0.1e1 / t148
  t156 = f.my_piecewise3(t44, 0, -0.3e1 / 0.8e1 * t5 * t134 * t64 - t115 + 0.21050000000000000000000000000000000000000000000000e-2 * t51 * t27 * s2 * t141 * t63 - 0.11900000000000000000000000000000000000000000000000e-3 * t5 * t50 * t27 * t59 * t149 * s2 * t141)
  vrho_1_ = t43 + t67 + t6 * (t129 + t156)
  t168 = f.my_piecewise3(t1, 0, -0.78937500000000000000000000000000000000000000000000e-3 * t26 * t27 * t32 * t39 + 0.44625000000000000000000000000000000000000000000000e-4 * t26 * t36 * t96 * t32)
  vsigma_0_ = t6 * t168
  vsigma_1_ = 0.0e0
  t178 = f.my_piecewise3(t44, 0, -0.78937500000000000000000000000000000000000000000000e-3 * t51 * t27 * t56 * t63 + 0.44625000000000000000000000000000000000000000000000e-4 * t51 * t60 * t149 * t56)
  vsigma_2_ = t6 * t178
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  _2d_b86_beta = 0.002105

  _2d_b86_gamma = 0.000119

  _2d_b86_f = lambda x: (1 + _2d_b86_beta * x ** 2) / (1 + _2d_b86_gamma * x ** 2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, _2d_b86_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = 2 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = s0 * t21
  t23 = r0 ** 2
  t24 = t19 ** 2
  t27 = t22 / t24 / t23
  t29 = 0.1e1 + 0.2105e-2 * t27
  t32 = 0.1e1 + 0.119e-3 * t27
  t33 = 0.1e1 / t32
  t37 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t29 * t33)
  t45 = 0.1e1 / t19 / t23 / r0
  t53 = t32 ** 2
  t54 = 0.1e1 / t53
  t60 = f.my_piecewise3(t2, 0, -t18 / t24 * t29 * t33 / 0.8e1 + 0.21050000000000000000000000000000000000000000000000e-2 * t18 * t45 * s0 * t21 * t33 - 0.11900000000000000000000000000000000000000000000000e-3 * t6 * t17 * t45 * t29 * t54 * t22)
  vrho_0_ = 0.2e1 * r0 * t60 + 0.2e1 * t37
  t64 = 0.1e1 / t19 / t23
  t75 = f.my_piecewise3(t2, 0, -0.78937500000000000000000000000000000000000000000000e-3 * t18 * t64 * t21 * t33 + 0.44625000000000000000000000000000000000000000000000e-4 * t18 * t64 * t29 * t54 * t21)
  vsigma_0_ = 0.2e1 * r0 * t75
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = s0 * t23
  t25 = r0 ** 2
  t28 = t24 / t20 / t25
  t30 = 0.1e1 + 0.2105e-2 * t28
  t33 = 0.1e1 + 0.119e-3 * t28
  t34 = 0.1e1 / t33
  t38 = t25 * r0
  t40 = 0.1e1 / t19 / t38
  t42 = t23 * t34
  t48 = t33 ** 2
  t49 = 0.1e1 / t48
  t51 = t30 * t49 * t24
  t55 = f.my_piecewise3(t2, 0, -t18 / t20 * t30 * t34 / 0.8e1 + 0.21050000000000000000000000000000000000000000000000e-2 * t18 * t40 * s0 * t42 - 0.11900000000000000000000000000000000000000000000000e-3 * t6 * t17 * t40 * t51)
  t63 = t25 ** 2
  t65 = 0.1e1 / t19 / t63
  t75 = 0.1e1 / t63 / t38
  t76 = s0 ** 2
  t85 = 0.1e1 / t48 / t33
  t86 = t30 * t85
  t92 = f.my_piecewise3(t2, 0, t18 / t20 / r0 * t30 * t34 / 0.12e2 - 0.63150000000000000000000000000000000000000000000000e-2 * t18 * t65 * s0 * t42 + 0.35700000000000000000000000000000000000000000000000e-3 * t6 * t17 * t65 * t51 + 0.26719466666666666666666666666666666666666666666667e-5 * t18 * t75 * t76 * t22 * t49 - 0.15105066666666666666666666666666666666666666666666e-6 * t6 * t17 * t75 * t86 * t76 * t22)
  v2rho2_0_ = 0.2e1 * r0 * t92 + 0.4e1 * t55
  t96 = 0.1e1 / t19 / t25
  t102 = t49 * t23
  t107 = f.my_piecewise3(t2, 0, -0.78937500000000000000000000000000000000000000000000e-3 * t18 * t96 * t23 * t34 + 0.44625000000000000000000000000000000000000000000000e-4 * t18 * t96 * t30 * t102)
  t113 = 0.1e1 / t63 / t25
  t130 = f.my_piecewise3(t2, 0, 0.18418750000000000000000000000000000000000000000000e-2 * t18 * t40 * t23 * t34 - 0.10019800000000000000000000000000000000000000000000e-5 * t18 * t113 * t22 * t49 * s0 - 0.10412500000000000000000000000000000000000000000000e-3 * t18 * t40 * t30 * t102 + 0.56643999999999999999999999999999999999999999999999e-7 * t6 * t17 * t113 * t86 * t22 * s0)
  v2rhosigma_0_ = 0.2e1 * r0 * t130 + 0.2e1 * t107
  t134 = 0.1e1 / t63 / r0
  t145 = f.my_piecewise3(t2, 0, 0.37574250000000000000000000000000000000000000000000e-6 * t18 * t134 * t22 * t49 - 0.21241500000000000000000000000000000000000000000000e-7 * t18 * t134 * t30 * t85 * t22)
  v2sigma2_0_ = 0.2e1 * r0 * t145
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = s0 * t24
  t26 = r0 ** 2
  t28 = 0.1e1 / t20 / t26
  t29 = t25 * t28
  t31 = 0.1e1 + 0.2105e-2 * t29
  t34 = 0.1e1 + 0.119e-3 * t29
  t35 = 0.1e1 / t34
  t39 = t26 ** 2
  t41 = 0.1e1 / t19 / t39
  t43 = t24 * t35
  t49 = t34 ** 2
  t50 = 0.1e1 / t49
  t52 = t31 * t50 * t25
  t57 = 0.1e1 / t39 / t26 / r0
  t58 = s0 ** 2
  t60 = t23 * t50
  t67 = 0.1e1 / t49 / t34
  t70 = t31 * t67 * t58 * t23
  t74 = f.my_piecewise3(t2, 0, t18 / t20 / r0 * t31 * t35 / 0.12e2 - 0.63150000000000000000000000000000000000000000000000e-2 * t18 * t41 * s0 * t43 + 0.35700000000000000000000000000000000000000000000000e-3 * t6 * t17 * t41 * t52 + 0.26719466666666666666666666666666666666666666666667e-5 * t18 * t57 * t58 * t60 - 0.15105066666666666666666666666666666666666666666666e-6 * t6 * t17 * t57 * t70)
  t82 = 0.1e1 / t19 / t39 / r0
  t91 = t39 ** 2
  t92 = 0.1e1 / t91
  t103 = 0.1e1 / t20 / t91 / t26
  t104 = t58 * s0
  t110 = t49 ** 2
  t117 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t28 * t31 * t35 + 0.26897222222222222222222222222222222222222222222222e-1 * t18 * t82 * s0 * t43 - 0.15205555555555555555555555555555555555555555555556e-2 * t6 * t17 * t82 * t52 - 0.26719466666666666666666666666666666666666666666667e-4 * t18 * t92 * t58 * t60 + 0.15105066666666666666666666666666666666666666666666e-5 * t6 * t17 * t92 * t70 + 0.50873864533333333333333333333333333333333333333332e-8 * t18 * t103 * t104 * t67 - 0.28760046933333333333333333333333333333333333333332e-9 * t18 * t103 * t31 / t110 * t104)
  v3rho3_0_ = 0.2e1 * r0 * t117 + 0.6e1 * t74

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = s0 * t25
  t27 = t26 * t23
  t29 = 0.1e1 + 0.2105e-2 * t27
  t32 = 0.1e1 + 0.119e-3 * t27
  t33 = 0.1e1 / t32
  t37 = t19 ** 2
  t40 = 0.1e1 / t20 / t37 / r0
  t42 = t25 * t33
  t48 = t32 ** 2
  t49 = 0.1e1 / t48
  t51 = t29 * t49 * t26
  t54 = t37 ** 2
  t55 = 0.1e1 / t54
  t56 = s0 ** 2
  t58 = t24 * t49
  t65 = 0.1e1 / t48 / t32
  t68 = t29 * t65 * t56 * t24
  t73 = 0.1e1 / t21 / t54 / t19
  t74 = t56 * s0
  t80 = t48 ** 2
  t81 = 0.1e1 / t80
  t82 = t81 * t74
  t87 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t23 * t29 * t33 + 0.26897222222222222222222222222222222222222222222222e-1 * t18 * t40 * s0 * t42 - 0.15205555555555555555555555555555555555555555555556e-2 * t6 * t17 * t40 * t51 - 0.26719466666666666666666666666666666666666666666667e-4 * t18 * t55 * t56 * t58 + 0.15105066666666666666666666666666666666666666666666e-5 * t6 * t17 * t55 * t68 + 0.50873864533333333333333333333333333333333333333332e-8 * t18 * t73 * t74 * t65 - 0.28760046933333333333333333333333333333333333333332e-9 * t18 * t73 * t29 * t82)
  t89 = t19 * r0
  t96 = t37 * t19
  t98 = 0.1e1 / t20 / t96
  t108 = 0.1e1 / t54 / r0
  t119 = 0.1e1 / t21 / t54 / t89
  t130 = 0.1e1 / t20 / t54 / t96
  t131 = t56 ** 2
  t147 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t18 / t21 / t89 * t29 * t33 - 0.14267222222222222222222222222222222222222222222222e0 * t18 * t98 * s0 * t42 + 0.80655555555555555555555555555555555555555555555558e-2 * t6 * t17 * t98 * t51 + 0.24789727407407407407407407407407407407407407407408e-3 * t18 * t108 * t56 * t58 - 0.14014145185185185185185185185185185185185185185185e-4 * t6 * t17 * t108 * t68 - 0.10513932003555555555555555555555555555555555555555e-6 * t18 * t119 * t74 * t65 + 0.59437430328888888888888888888888888888888888888886e-8 * t18 * t119 * t29 * t82 + 0.64575892047644444444444444444444444444444444444442e-11 * t18 * t130 * t131 * t81 * t25 - 0.36506086240711111111111111111111111111111111111108e-12 * t6 * t17 * t130 * t29 / t80 / t32 * t131 * t25)
  v4rho4_0_ = 0.2e1 * r0 * t147 + 0.8e1 * t87

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = r0 ** 2
  t33 = r0 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t37 = s0 / t34 / t32
  t39 = 0.1e1 + 0.2105e-2 * t37
  t42 = 0.1e1 + 0.119e-3 * t37
  t43 = 0.1e1 / t42
  t44 = t31 * t39 * t43
  t47 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t48 = t47 * f.p.zeta_threshold
  t50 = f.my_piecewise3(t20, t48, t21 * t19)
  t51 = t5 * t50
  t52 = t31 ** 2
  t53 = 0.1e1 / t52
  t55 = t53 * t39 * t43
  t57 = t51 * t55 / 0.8e1
  t58 = t31 * s0
  t59 = t32 * r0
  t61 = 0.1e1 / t34 / t59
  t62 = t61 * t43
  t63 = t58 * t62
  t67 = t5 * t50 * t31
  t68 = t42 ** 2
  t69 = 0.1e1 / t68
  t70 = t39 * t69
  t72 = t70 * s0 * t61
  t76 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t44 - t57 + 0.21050000000000000000000000000000000000000000000000e-2 * t51 * t63 - 0.11900000000000000000000000000000000000000000000000e-3 * t67 * t72)
  t78 = r1 <= f.p.dens_threshold
  t79 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t80 = 0.1e1 + t79
  t81 = t80 <= f.p.zeta_threshold
  t82 = t80 ** (0.1e1 / 0.3e1)
  t84 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t87 = f.my_piecewise3(t81, 0, 0.4e1 / 0.3e1 * t82 * t84)
  t88 = t5 * t87
  t89 = r1 ** 2
  t90 = r1 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t94 = s2 / t91 / t89
  t96 = 0.1e1 + 0.2105e-2 * t94
  t99 = 0.1e1 + 0.119e-3 * t94
  t100 = 0.1e1 / t99
  t101 = t31 * t96 * t100
  t105 = f.my_piecewise3(t81, t48, t82 * t80)
  t106 = t5 * t105
  t108 = t53 * t96 * t100
  t110 = t106 * t108 / 0.8e1
  t112 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t88 * t101 - t110)
  t114 = t21 ** 2
  t115 = 0.1e1 / t114
  t116 = t26 ** 2
  t121 = t16 / t22 / t6
  t123 = -0.2e1 * t23 + 0.2e1 * t121
  t124 = f.my_piecewise5(t10, 0, t14, 0, t123)
  t128 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t115 * t116 + 0.4e1 / 0.3e1 * t21 * t124)
  t132 = t30 * t55
  t141 = 0.1e1 / t52 / t6
  t145 = t51 * t141 * t39 * t43 / 0.12e2
  t148 = t51 * t53 * s0 * t62
  t152 = t5 * t50 * t53 * t72
  t154 = t32 ** 2
  t156 = 0.1e1 / t34 / t154
  t161 = s0 ** 2
  t165 = 0.1e1 / t33 / t154 / t59
  t181 = -0.3e1 / 0.8e1 * t5 * t128 * t44 - t132 / 0.4e1 + 0.42100000000000000000000000000000000000000000000000e-2 * t30 * t63 - 0.23800000000000000000000000000000000000000000000000e-3 * t5 * t29 * t31 * t72 + t145 + 0.14033333333333333333333333333333333333333333333333e-2 * t148 - 0.79333333333333333333333333333333333333333333333333e-4 * t152 - 0.77183333333333333333333333333333333333333333333333e-2 * t51 * t58 * t156 * t43 + 0.13359733333333333333333333333333333333333333333333e-5 * t51 * t31 * t161 * t165 * t69 - 0.75525333333333333333333333333333333333333333333333e-7 * t67 * t39 / t68 / t42 * t161 * t165 + 0.43633333333333333333333333333333333333333333333333e-3 * t67 * t70 * s0 * t156
  t182 = f.my_piecewise3(t1, 0, t181)
  t183 = t82 ** 2
  t184 = 0.1e1 / t183
  t185 = t84 ** 2
  t189 = f.my_piecewise5(t14, 0, t10, 0, -t123)
  t193 = f.my_piecewise3(t81, 0, 0.4e1 / 0.9e1 * t184 * t185 + 0.4e1 / 0.3e1 * t82 * t189)
  t197 = t88 * t108
  t202 = t106 * t141 * t96 * t100 / 0.12e2
  t204 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t5 * t193 * t101 - t197 / 0.4e1 + t202)
  d11 = 0.2e1 * t76 + 0.2e1 * t112 + t6 * (t182 + t204)
  t207 = -t7 - t24
  t208 = f.my_piecewise5(t10, 0, t14, 0, t207)
  t211 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t208)
  t212 = t5 * t211
  t216 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t212 * t44 - t57)
  t218 = f.my_piecewise5(t14, 0, t10, 0, -t207)
  t221 = f.my_piecewise3(t81, 0, 0.4e1 / 0.3e1 * t82 * t218)
  t222 = t5 * t221
  t225 = t31 * s2
  t226 = t89 * r1
  t228 = 0.1e1 / t91 / t226
  t229 = t228 * t100
  t230 = t225 * t229
  t234 = t5 * t105 * t31
  t235 = t99 ** 2
  t236 = 0.1e1 / t235
  t237 = t96 * t236
  t239 = t237 * s2 * t228
  t243 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t222 * t101 - t110 + 0.21050000000000000000000000000000000000000000000000e-2 * t106 * t230 - 0.11900000000000000000000000000000000000000000000000e-3 * t234 * t239)
  t247 = 0.2e1 * t121
  t248 = f.my_piecewise5(t10, 0, t14, 0, t247)
  t252 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t115 * t208 * t26 + 0.4e1 / 0.3e1 * t21 * t248)
  t256 = t212 * t55
  t268 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t252 * t44 - t256 / 0.8e1 + 0.21050000000000000000000000000000000000000000000000e-2 * t212 * t63 - 0.11900000000000000000000000000000000000000000000000e-3 * t5 * t211 * t31 * t72 - t132 / 0.8e1 + t145 + 0.70166666666666666666666666666666666666666666666666e-3 * t148 - 0.39666666666666666666666666666666666666666666666666e-4 * t152)
  t272 = f.my_piecewise5(t14, 0, t10, 0, -t247)
  t276 = f.my_piecewise3(t81, 0, 0.4e1 / 0.9e1 * t184 * t218 * t84 + 0.4e1 / 0.3e1 * t82 * t272)
  t280 = t222 * t108
  t287 = t106 * t53 * s2 * t229
  t295 = t5 * t105 * t53 * t239
  t298 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t5 * t276 * t101 - t280 / 0.8e1 - t197 / 0.8e1 + t202 + 0.21050000000000000000000000000000000000000000000000e-2 * t88 * t230 + 0.70166666666666666666666666666666666666666666666667e-3 * t287 - 0.11900000000000000000000000000000000000000000000000e-3 * t5 * t87 * t31 * t239 - 0.39666666666666666666666666666666666666666666666667e-4 * t295)
  d12 = t76 + t112 + t216 + t243 + t6 * (t268 + t298)
  t303 = t208 ** 2
  t307 = 0.2e1 * t23 + 0.2e1 * t121
  t308 = f.my_piecewise5(t10, 0, t14, 0, t307)
  t312 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t115 * t303 + 0.4e1 / 0.3e1 * t21 * t308)
  t318 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t312 * t44 - t256 / 0.4e1 + t145)
  t319 = t218 ** 2
  t323 = f.my_piecewise5(t14, 0, t10, 0, -t307)
  t327 = f.my_piecewise3(t81, 0, 0.4e1 / 0.9e1 * t184 * t319 + 0.4e1 / 0.3e1 * t82 * t323)
  t340 = t89 ** 2
  t342 = 0.1e1 / t91 / t340
  t347 = s2 ** 2
  t351 = 0.1e1 / t90 / t340 / t226
  t367 = -0.3e1 / 0.8e1 * t5 * t327 * t101 - t280 / 0.4e1 + 0.42100000000000000000000000000000000000000000000000e-2 * t222 * t230 - 0.23800000000000000000000000000000000000000000000000e-3 * t5 * t221 * t31 * t239 + t202 + 0.14033333333333333333333333333333333333333333333333e-2 * t287 - 0.79333333333333333333333333333333333333333333333333e-4 * t295 - 0.77183333333333333333333333333333333333333333333333e-2 * t106 * t225 * t342 * t100 + 0.13359733333333333333333333333333333333333333333333e-5 * t106 * t31 * t347 * t351 * t236 - 0.75525333333333333333333333333333333333333333333333e-7 * t234 * t96 / t235 / t99 * t347 * t351 + 0.43633333333333333333333333333333333333333333333333e-3 * t234 * t237 * s2 * t342
  t368 = f.my_piecewise3(t78, 0, t367)
  d22 = 0.2e1 * t216 + 0.2e1 * t243 + t6 * (t318 + t368)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t5 * t41
  t43 = t6 ** (0.1e1 / 0.3e1)
  t44 = r0 ** 2
  t45 = r0 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t49 = s0 / t46 / t44
  t51 = 0.1e1 + 0.2105e-2 * t49
  t54 = 0.1e1 + 0.119e-3 * t49
  t55 = 0.1e1 / t54
  t56 = t43 * t51 * t55
  t61 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t62 = t5 * t61
  t63 = t43 ** 2
  t64 = 0.1e1 / t63
  t66 = t64 * t51 * t55
  t69 = t43 * s0
  t70 = t44 * r0
  t72 = 0.1e1 / t46 / t70
  t73 = t72 * t55
  t74 = t69 * t73
  t78 = t5 * t61 * t43
  t79 = t54 ** 2
  t80 = 0.1e1 / t79
  t81 = t51 * t80
  t83 = t81 * s0 * t72
  t86 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t87 = t86 * f.p.zeta_threshold
  t89 = f.my_piecewise3(t20, t87, t21 * t19)
  t90 = t5 * t89
  t92 = 0.1e1 / t63 / t6
  t94 = t92 * t51 * t55
  t97 = t64 * s0
  t98 = t97 * t73
  t102 = t5 * t89 * t64
  t105 = t44 ** 2
  t107 = 0.1e1 / t46 / t105
  t108 = t107 * t55
  t109 = t69 * t108
  t112 = s0 ** 2
  t113 = t43 * t112
  t116 = 0.1e1 / t45 / t105 / t70
  t117 = t116 * t80
  t118 = t113 * t117
  t122 = t5 * t89 * t43
  t124 = 0.1e1 / t79 / t54
  t125 = t51 * t124
  t127 = t125 * t112 * t116
  t131 = t81 * s0 * t107
  t134 = -0.3e1 / 0.8e1 * t42 * t56 - t62 * t66 / 0.4e1 + 0.42100000000000000000000000000000000000000000000000e-2 * t62 * t74 - 0.23800000000000000000000000000000000000000000000000e-3 * t78 * t83 + t90 * t94 / 0.12e2 + 0.14033333333333333333333333333333333333333333333333e-2 * t90 * t98 - 0.79333333333333333333333333333333333333333333333333e-4 * t102 * t83 - 0.77183333333333333333333333333333333333333333333333e-2 * t90 * t109 + 0.13359733333333333333333333333333333333333333333333e-5 * t90 * t118 - 0.75525333333333333333333333333333333333333333333333e-7 * t122 * t127 + 0.43633333333333333333333333333333333333333333333333e-3 * t122 * t131
  t135 = f.my_piecewise3(t1, 0, t134)
  t137 = r1 <= f.p.dens_threshold
  t138 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t139 = 0.1e1 + t138
  t140 = t139 <= f.p.zeta_threshold
  t141 = t139 ** (0.1e1 / 0.3e1)
  t142 = t141 ** 2
  t143 = 0.1e1 / t142
  t145 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t146 = t145 ** 2
  t150 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t154 = f.my_piecewise3(t140, 0, 0.4e1 / 0.9e1 * t143 * t146 + 0.4e1 / 0.3e1 * t141 * t150)
  t155 = t5 * t154
  t156 = r1 ** 2
  t157 = r1 ** (0.1e1 / 0.3e1)
  t158 = t157 ** 2
  t161 = s2 / t158 / t156
  t163 = 0.1e1 + 0.2105e-2 * t161
  t167 = 0.1e1 / (0.1e1 + 0.119e-3 * t161)
  t168 = t43 * t163 * t167
  t173 = f.my_piecewise3(t140, 0, 0.4e1 / 0.3e1 * t141 * t145)
  t174 = t5 * t173
  t176 = t64 * t163 * t167
  t180 = f.my_piecewise3(t140, t87, t141 * t139)
  t181 = t5 * t180
  t183 = t92 * t163 * t167
  t187 = f.my_piecewise3(t137, 0, -0.3e1 / 0.8e1 * t155 * t168 - t174 * t176 / 0.4e1 + t181 * t183 / 0.12e2)
  t189 = t105 ** 2
  t191 = 0.1e1 / t45 / t189
  t196 = t112 * s0
  t199 = 0.1e1 / t189 / t70
  t215 = 0.1e1 / t63 / t24
  t232 = 0.1e1 / t46 / t105 / r0
  t237 = -0.14695706666666666666666666666666666666666666666666e-4 * t90 * t113 * t191 * t80 + 0.12718466133333333333333333333333333333333333333333e-8 * t90 * t43 * t196 * t199 * t124 - 0.3e1 / 0.8e1 * t42 * t66 + 0.63150000000000000000000000000000000000000000000000e-2 * t42 * t74 + t62 * t94 / 0.4e1 + 0.42099999999999999999999999999999999999999999999999e-2 * t62 * t98 + 0.40079199999999999999999999999999999999999999999999e-5 * t62 * t118 - 0.5e1 / 0.36e2 * t90 * t215 * t51 * t55 - 0.14033333333333333333333333333333333333333333333333e-2 * t90 * t92 * s0 * t73 + 0.13359733333333333333333333333333333333333333333333e-5 * t90 * t64 * t112 * t117 - 0.75525333333333333333333333333333333333333333333332e-7 * t102 * t127 + 0.36018888888888888888888888888888888888888888888889e-1 * t90 * t69 * t232 * t55
  t238 = t79 ** 2
  t272 = t24 ** 2
  t276 = 0.6e1 * t33 - 0.6e1 * t16 / t272
  t277 = f.my_piecewise5(t10, 0, t14, 0, t276)
  t281 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t277)
  t297 = -0.71900117333333333333333333333333333333333333333332e-10 * t122 * t51 / t238 * t196 * t199 - 0.35700000000000000000000000000000000000000000000000e-3 * t5 * t41 * t43 * t83 - 0.23799999999999999999999999999999999999999999999999e-3 * t5 * t61 * t64 * t83 - 0.23155000000000000000000000000000000000000000000000e-1 * t62 * t109 - 0.22657600000000000000000000000000000000000000000000e-6 * t78 * t127 + 0.79333333333333333333333333333333333333333333333333e-4 * t5 * t89 * t92 * t83 - 0.77183333333333333333333333333333333333333333333332e-2 * t90 * t97 * t108 - 0.3e1 / 0.8e1 * t5 * t281 * t56 + 0.13090000000000000000000000000000000000000000000000e-2 * t78 * t131 + 0.43633333333333333333333333333333333333333333333333e-3 * t102 * t131 + 0.83077866666666666666666666666666666666666666666666e-6 * t122 * t125 * t112 * t191 - 0.20362222222222222222222222222222222222222222222222e-2 * t122 * t81 * s0 * t232
  t299 = f.my_piecewise3(t1, 0, t237 + t297)
  t309 = f.my_piecewise5(t14, 0, t10, 0, -t276)
  t313 = f.my_piecewise3(t140, 0, -0.8e1 / 0.27e2 / t142 / t139 * t146 * t145 + 0.4e1 / 0.3e1 * t143 * t145 * t150 + 0.4e1 / 0.3e1 * t141 * t309)
  t326 = f.my_piecewise3(t137, 0, -0.3e1 / 0.8e1 * t5 * t313 * t168 - 0.3e1 / 0.8e1 * t155 * t176 + t174 * t183 / 0.4e1 - 0.5e1 / 0.36e2 * t181 * t215 * t163 * t167)
  d111 = 0.3e1 * t135 + 0.3e1 * t187 + t6 * (t299 + t326)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = s0 ** 2
  t29 = t27 * t28
  t30 = r0 ** 2
  t31 = t30 ** 2
  t32 = t31 ** 2
  t33 = r0 ** (0.1e1 / 0.3e1)
  t35 = 0.1e1 / t33 / t32
  t36 = t33 ** 2
  t39 = s0 / t36 / t30
  t41 = 0.1e1 + 0.119e-3 * t39
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = t35 * t43
  t45 = t29 * t44
  t48 = t28 * s0
  t49 = t27 * t48
  t50 = t30 * r0
  t52 = 0.1e1 / t32 / t50
  t54 = 0.1e1 / t42 / t41
  t55 = t52 * t54
  t56 = t49 * t55
  t59 = t23 ** 2
  t60 = 0.1e1 / t59
  t61 = t6 ** 2
  t62 = 0.1e1 / t61
  t64 = -t16 * t62 + t7
  t65 = f.my_piecewise5(t10, 0, t14, 0, t64)
  t66 = t65 ** 2
  t69 = t61 * t6
  t70 = 0.1e1 / t69
  t73 = 0.2e1 * t16 * t70 - 0.2e1 * t62
  t74 = f.my_piecewise5(t10, 0, t14, 0, t73)
  t78 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t60 * t66 + 0.4e1 / 0.3e1 * t23 * t74)
  t79 = t5 * t78
  t80 = t27 ** 2
  t81 = 0.1e1 / t80
  t83 = 0.1e1 + 0.2105e-2 * t39
  t85 = 0.1e1 / t41
  t86 = t81 * t83 * t85
  t89 = t27 * s0
  t91 = 0.1e1 / t36 / t50
  t92 = t91 * t85
  t93 = t89 * t92
  t98 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t65)
  t99 = t5 * t98
  t101 = 0.1e1 / t80 / t6
  t103 = t101 * t83 * t85
  t106 = t81 * s0
  t107 = t106 * t92
  t112 = 0.1e1 / t33 / t31 / t50
  t113 = t112 * t43
  t114 = t29 * t113
  t118 = 0.1e1 / t80 / t61
  t120 = t118 * t83 * t85
  t123 = t101 * s0
  t124 = t123 * t92
  t127 = t81 * t28
  t128 = t127 * t113
  t132 = 0.1e1 / t36 / t31
  t133 = t132 * t85
  t134 = t106 * t133
  t138 = t5 * t25 * t81
  t139 = t83 * t54
  t141 = t139 * t28 * t112
  t144 = -0.14695706666666666666666666666666666666666666666666e-4 * t26 * t45 + 0.12718466133333333333333333333333333333333333333333e-8 * t26 * t56 - 0.3e1 / 0.8e1 * t79 * t86 + 0.63150000000000000000000000000000000000000000000000e-2 * t79 * t93 + t99 * t103 / 0.4e1 + 0.42099999999999999999999999999999999999999999999999e-2 * t99 * t107 + 0.40079199999999999999999999999999999999999999999999e-5 * t99 * t114 - 0.5e1 / 0.36e2 * t26 * t120 - 0.14033333333333333333333333333333333333333333333333e-2 * t26 * t124 + 0.13359733333333333333333333333333333333333333333333e-5 * t26 * t128 - 0.77183333333333333333333333333333333333333333333332e-2 * t26 * t134 - 0.75525333333333333333333333333333333333333333333332e-7 * t138 * t141
  t147 = 0.1e1 / t36 / t31 / r0
  t148 = t147 * t85
  t149 = t89 * t148
  t153 = t5 * t25 * t27
  t154 = t42 ** 2
  t155 = 0.1e1 / t154
  t156 = t83 * t155
  t158 = t156 * t48 * t52
  t162 = t5 * t78 * t27
  t163 = t83 * t43
  t165 = t163 * s0 * t91
  t169 = t5 * t98 * t81
  t172 = t89 * t133
  t176 = t5 * t98 * t27
  t180 = t5 * t25 * t101
  t184 = 0.1e1 / t59 / t19
  t188 = t60 * t65
  t191 = t61 ** 2
  t192 = 0.1e1 / t191
  t195 = -0.6e1 * t16 * t192 + 0.6e1 * t70
  t196 = f.my_piecewise5(t10, 0, t14, 0, t195)
  t200 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t184 * t66 * t65 + 0.4e1 / 0.3e1 * t188 * t74 + 0.4e1 / 0.3e1 * t23 * t196)
  t201 = t5 * t200
  t203 = t27 * t83 * t85
  t207 = t163 * s0 * t132
  t213 = t139 * t28 * t35
  t217 = t163 * s0 * t147
  t220 = 0.36018888888888888888888888888888888888888888888889e-1 * t26 * t149 - 0.71900117333333333333333333333333333333333333333332e-10 * t153 * t158 - 0.35700000000000000000000000000000000000000000000000e-3 * t162 * t165 - 0.23799999999999999999999999999999999999999999999999e-3 * t169 * t165 - 0.23155000000000000000000000000000000000000000000000e-1 * t99 * t172 - 0.22657600000000000000000000000000000000000000000000e-6 * t176 * t141 + 0.79333333333333333333333333333333333333333333333333e-4 * t180 * t165 - 0.3e1 / 0.8e1 * t201 * t203 + 0.13090000000000000000000000000000000000000000000000e-2 * t176 * t207 + 0.43633333333333333333333333333333333333333333333333e-3 * t138 * t207 + 0.83077866666666666666666666666666666666666666666666e-6 * t153 * t213 - 0.20362222222222222222222222222222222222222222222222e-2 * t153 * t217
  t222 = f.my_piecewise3(t1, 0, t144 + t220)
  t224 = r1 <= f.p.dens_threshold
  t225 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t226 = 0.1e1 + t225
  t227 = t226 <= f.p.zeta_threshold
  t228 = t226 ** (0.1e1 / 0.3e1)
  t229 = t228 ** 2
  t231 = 0.1e1 / t229 / t226
  t233 = f.my_piecewise5(t14, 0, t10, 0, -t64)
  t234 = t233 ** 2
  t238 = 0.1e1 / t229
  t239 = t238 * t233
  t241 = f.my_piecewise5(t14, 0, t10, 0, -t73)
  t245 = f.my_piecewise5(t14, 0, t10, 0, -t195)
  t249 = f.my_piecewise3(t227, 0, -0.8e1 / 0.27e2 * t231 * t234 * t233 + 0.4e1 / 0.3e1 * t239 * t241 + 0.4e1 / 0.3e1 * t228 * t245)
  t250 = t5 * t249
  t251 = r1 ** 2
  t252 = r1 ** (0.1e1 / 0.3e1)
  t253 = t252 ** 2
  t256 = s2 / t253 / t251
  t258 = 0.1e1 + 0.2105e-2 * t256
  t262 = 0.1e1 / (0.1e1 + 0.119e-3 * t256)
  t263 = t27 * t258 * t262
  t271 = f.my_piecewise3(t227, 0, 0.4e1 / 0.9e1 * t238 * t234 + 0.4e1 / 0.3e1 * t228 * t241)
  t272 = t5 * t271
  t274 = t81 * t258 * t262
  t279 = f.my_piecewise3(t227, 0, 0.4e1 / 0.3e1 * t228 * t233)
  t280 = t5 * t279
  t282 = t101 * t258 * t262
  t286 = f.my_piecewise3(t227, t22, t228 * t226)
  t287 = t5 * t286
  t289 = t118 * t258 * t262
  t293 = f.my_piecewise3(t224, 0, -0.3e1 / 0.8e1 * t250 * t263 - 0.3e1 / 0.8e1 * t272 * t274 + t280 * t282 / 0.4e1 - 0.5e1 / 0.36e2 * t287 * t289)
  t297 = 0.1e1 / t33 / t32 / r0
  t302 = t31 * t30
  t304 = 0.1e1 / t36 / t302
  t318 = t28 ** 2
  t321 = 0.1e1 / t36 / t32 / t302
  t344 = -0.82154779259259259259259259259259259259259259259258e-5 * t153 * t139 * t28 * t297 + 0.11538592592592592592592592592592592592592592592592e-1 * t153 * t163 * s0 * t304 - 0.30210133333333333333333333333333333333333333333332e-6 * t169 * t141 - 0.95866823111111111111111111111111111111111111111108e-10 * t138 * t158 - 0.28760046933333333333333333333333333333333333333333e-9 * t176 * t158 - 0.91265215601777777777777777777777777777777777777774e-13 * t153 * t83 / t154 / t41 * t318 * t321 - 0.47600000000000000000000000000000000000000000000000e-3 * t5 * t200 * t27 * t165 - 0.45315200000000000000000000000000000000000000000000e-6 * t162 * t141 + 0.31733333333333333333333333333333333333333333333332e-3 * t5 * t98 * t101 * t165 - 0.17629629629629629629629629629629629629629629629629e-3 * t5 * t25 * t118 * t165 - 0.47599999999999999999999999999999999999999999999999e-3 * t5 * t78 * t81 * t165
  t350 = 0.1e1 / t32 / t31
  t374 = 0.10070044444444444444444444444444444444444444444444e-6 * t180 * t141 + 0.11077048888888888888888888888888888888888888888889e-5 * t138 * t213 + 0.15818025813333333333333333333333333333333333333333e-8 * t153 * t156 * t48 * t350 + 0.26180000000000000000000000000000000000000000000000e-2 * t162 * t207 + 0.17453333333333333333333333333333333333333333333333e-2 * t169 * t207 + 0.33231146666666666666666666666666666666666666666667e-5 * t176 * t213 - 0.58177777777777777777777777777777777777777777777778e-3 * t180 * t207 - 0.81448888888888888888888888888888888888888888888889e-2 * t176 * t217 - 0.27149629629629629629629629629629629629629629629629e-2 * t138 * t217 + 0.48025185185185185185185185185185185185185185185184e-1 * t26 * t106 * t148 - 0.20410703703703703703703703703703703703703703703704e0 * t26 * t89 * t304 * t85
  t408 = -0.46310000000000000000000000000000000000000000000000e-1 * t79 * t172 - 0.30873333333333333333333333333333333333333333333332e-1 * t99 * t134 + 0.10291111111111111111111111111111111111111111111111e-1 * t26 * t123 * t133 - 0.19594275555555555555555555555555555555555555555554e-4 * t26 * t127 * t44 + 0.14532421037037037037037037037037037037037037037036e-3 * t26 * t29 * t297 * t43 + 0.16957954844444444444444444444444444444444444444444e-8 * t26 * t81 * t48 * t55 - 0.56133333333333333333333333333333333333333333333332e-2 * t99 * t124 + 0.53438933333333333333333333333333333333333333333332e-5 * t99 * t128 + 0.31185185185185185185185185185185185185185185185184e-2 * t26 * t118 * s0 * t92 - 0.17812977777777777777777777777777777777777777777777e-5 * t26 * t101 * t28 * t113 + 0.14407555555555555555555555555555555555555555555556e0 * t99 * t149
  t429 = 0.1e1 / t80 / t69
  t440 = t19 ** 2
  t443 = t66 ** 2
  t449 = t74 ** 2
  t458 = -0.24e2 * t192 + 0.24e2 * t16 / t191 / t6
  t459 = f.my_piecewise5(t10, 0, t14, 0, t458)
  t463 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t59 / t440 * t443 - 0.16e2 / 0.9e1 * t184 * t66 * t74 + 0.4e1 / 0.3e1 * t60 * t449 + 0.16e2 / 0.9e1 * t188 * t196 + 0.4e1 / 0.3e1 * t23 * t459)
  t467 = -0.58782826666666666666666666666666666666666666666665e-4 * t99 * t45 - 0.27980625493333333333333333333333333333333333333332e-7 * t26 * t49 * t350 * t54 + 0.50873864533333333333333333333333333333333333333332e-8 * t99 * t56 + 0.16143973011911111111111111111111111111111111111111e-11 * t26 * t27 * t318 * t321 * t155 + 0.84199999999999999999999999999999999999999999999999e-2 * t79 * t107 + 0.84200000000000000000000000000000000000000000000000e-2 * t201 * t93 + 0.80158399999999999999999999999999999999999999999999e-5 * t79 * t114 + 0.10e2 / 0.27e2 * t26 * t429 * t83 * t85 + t79 * t103 / 0.2e1 - 0.5e1 / 0.9e1 * t99 * t120 - t201 * t86 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t463 * t203
  t470 = f.my_piecewise3(t1, 0, t344 + t374 + t408 + t467)
  t471 = t226 ** 2
  t474 = t234 ** 2
  t480 = t241 ** 2
  t486 = f.my_piecewise5(t14, 0, t10, 0, -t458)
  t490 = f.my_piecewise3(t227, 0, 0.40e2 / 0.81e2 / t229 / t471 * t474 - 0.16e2 / 0.9e1 * t231 * t234 * t241 + 0.4e1 / 0.3e1 * t238 * t480 + 0.16e2 / 0.9e1 * t239 * t245 + 0.4e1 / 0.3e1 * t228 * t486)
  t505 = f.my_piecewise3(t224, 0, -0.3e1 / 0.8e1 * t5 * t490 * t263 - t250 * t274 / 0.2e1 + t272 * t282 / 0.2e1 - 0.5e1 / 0.9e1 * t280 * t289 + 0.10e2 / 0.27e2 * t287 * t429 * t258 * t262)
  d1111 = 0.4e1 * t222 + 0.4e1 * t293 + t6 * (t470 + t505)

  res = {'v4rho4': d1111}
  return res
