"""Generated from gga_x_am05.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import scipy.special as sp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  am05_d = 28.23705740248932

  am05_csi = lambda s: (3 / 2 * LambertW(s ** (3 / 2) / (2 * jnp.sqrt(6)))) ** (2 / 3)

  am05_XX = lambda s: 1 - params_alpha * s ** 2 / (1 + params_alpha * s ** 2)

  am05_fb = lambda s: jnp.pi / 3 * s / (am05_csi(s) * (am05_d + am05_csi(s) ** 2) ** (1 / 4))

  am05_flaa = lambda s: (1 + params_c * s ** 2) / (1 + params_c * s ** 2 / am05_fb(s))

  am05_f = lambda x: am05_XX(X2S * x) + (1 - am05_XX(X2S * x)) * am05_flaa(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, am05_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  am05_d = 28.23705740248932

  am05_csi = lambda s: (3 / 2 * LambertW(s ** (3 / 2) / (2 * jnp.sqrt(6)))) ** (2 / 3)

  am05_XX = lambda s: 1 - params_alpha * s ** 2 / (1 + params_alpha * s ** 2)

  am05_fb = lambda s: jnp.pi / 3 * s / (am05_csi(s) * (am05_d + am05_csi(s) ** 2) ** (1 / 4))

  am05_flaa = lambda s: (1 + params_c * s ** 2) / (1 + params_c * s ** 2 / am05_fb(s))

  am05_f = lambda x: am05_XX(X2S * x) + (1 - am05_XX(X2S * x)) * am05_flaa(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, am05_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  am05_d = 28.23705740248932

  am05_csi = lambda s: (3 / 2 * LambertW(s ** (3 / 2) / (2 * jnp.sqrt(6)))) ** (2 / 3)

  am05_XX = lambda s: 1 - params_alpha * s ** 2 / (1 + params_alpha * s ** 2)

  am05_fb = lambda s: jnp.pi / 3 * s / (am05_csi(s) * (am05_d + am05_csi(s) ** 2) ** (1 / 4))

  am05_flaa = lambda s: (1 + params_c * s ** 2) / (1 + params_c * s ** 2 / am05_fb(s))

  am05_f = lambda x: am05_XX(X2S * x) + (1 - am05_XX(X2S * x)) * am05_flaa(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, am05_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = params.alpha * t28
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = 0.1e1 / t32
  t34 = t29 * t33
  t35 = r0 ** 2
  t36 = r0 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = 0.1e1 / t37 / t35
  t41 = t33 * s0
  t42 = t41 * t39
  t45 = 0.1e1 + t29 * t42 / 0.24e2
  t46 = 0.1e1 / t45
  t50 = t29 * t41
  t51 = t39 * t46
  t52 = params.c * t28
  t55 = 0.1e1 + t52 * t42 / 0.24e2
  t56 = t28 ** 2
  t57 = params.c * t56
  t58 = 0.1e1 / t31
  t59 = jnp.sqrt(s0)
  t60 = t58 * t59
  t62 = 0.1e1 / t36 / r0
  t65 = 0.1e1 / jnp.pi
  t66 = t2 ** 2
  t67 = t65 * t66
  t68 = 2 ** (0.1e1 / 0.3e1)
  t69 = jnp.sqrt(0.12e2)
  t70 = t56 * t58
  t72 = t70 * t59 * t62
  t73 = jnp.sqrt(t72)
  t76 = jnp.sqrt(0.6e1)
  t79 = lambertw(t69 * t73 * t72 * t76 / 0.1728e4)
  t80 = t79 ** (0.1e1 / 0.3e1)
  t81 = t80 ** 2
  t83 = t68 ** 2
  t84 = t2 * t83
  t89 = (0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t84 * t80 * t79) ** (0.1e1 / 0.4e1)
  t91 = t67 * t68 * t81 * t89
  t94 = 0.1e1 + t57 * t60 * t62 * t91 / 0.8e1
  t95 = 0.1e1 / t94
  t96 = t55 * t95
  t97 = t51 * t96
  t100 = 0.1e1 - t34 * s0 * t39 * t46 / 0.24e2 + t50 * t97 / 0.24e2
  t104 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t100)
  t105 = r1 <= f.p.dens_threshold
  t106 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t107 = 0.1e1 + t106
  t108 = t107 <= f.p.zeta_threshold
  t109 = t107 ** (0.1e1 / 0.3e1)
  t111 = f.my_piecewise3(t108, t22, t109 * t107)
  t112 = t111 * t26
  t113 = r1 ** 2
  t114 = r1 ** (0.1e1 / 0.3e1)
  t115 = t114 ** 2
  t117 = 0.1e1 / t115 / t113
  t119 = t33 * s2
  t120 = t119 * t117
  t123 = 0.1e1 + t29 * t120 / 0.24e2
  t124 = 0.1e1 / t123
  t128 = t29 * t119
  t129 = t117 * t124
  t132 = 0.1e1 + t52 * t120 / 0.24e2
  t133 = jnp.sqrt(s2)
  t134 = t58 * t133
  t136 = 0.1e1 / t114 / r1
  t140 = t70 * t133 * t136
  t141 = jnp.sqrt(t140)
  t146 = lambertw(t69 * t141 * t140 * t76 / 0.1728e4)
  t147 = t146 ** (0.1e1 / 0.3e1)
  t148 = t147 ** 2
  t154 = (0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t84 * t147 * t146) ** (0.1e1 / 0.4e1)
  t156 = t67 * t68 * t148 * t154
  t159 = 0.1e1 + t57 * t134 * t136 * t156 / 0.8e1
  t160 = 0.1e1 / t159
  t161 = t132 * t160
  t162 = t129 * t161
  t165 = 0.1e1 - t34 * s2 * t117 * t124 / 0.24e2 + t128 * t162 / 0.24e2
  t169 = f.my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t5 * t112 * t165)
  t170 = t6 ** 2
  t172 = t16 / t170
  t173 = t7 - t172
  t174 = f.my_piecewise5(t10, 0, t14, 0, t173)
  t177 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t174)
  t182 = t26 ** 2
  t183 = 0.1e1 / t182
  t187 = t5 * t25 * t183 * t100 / 0.8e1
  t190 = 0.1e1 / t37 / t35 / r0
  t195 = params.alpha ** 2
  t196 = t195 * t56
  t198 = 0.1e1 / t31 / t30
  t199 = t196 * t198
  t200 = s0 ** 2
  t201 = t35 ** 2
  t204 = 0.1e1 / t36 / t201 / t35
  t206 = t45 ** 2
  t207 = 0.1e1 / t206
  t215 = t198 * t200
  t221 = params.alpha * t56
  t224 = params.c * t95
  t228 = t94 ** 2
  t230 = t55 / t228
  t232 = 0.1e1 / t36 / t35
  t234 = t57 * t60 * t232
  t237 = t67 * t68
  t240 = 0.1e1 / (0.1e1 + t79)
  t242 = t237 * t81 * t89 * t240
  t247 = t79 ** 2
  t248 = t89 ** 2
  t252 = t247 / t248 / t89 * t240
  t266 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t177 * t26 * t100 - t187 - 0.3e1 / 0.8e1 * t5 * t27 * (t34 * s0 * t190 * t46 / 0.9e1 - t199 * t200 * t204 * t207 / 0.216e3 - t50 * t190 * t46 * t96 / 0.9e1 + t196 * t215 * t204 * t207 * t96 / 0.216e3 - t221 * t215 * t204 * t46 * t224 / 0.216e3 - t50 * t51 * t230 * (-t234 * t91 / 0.6e1 - t234 * t242 / 0.6e1 - 0.3e1 / 0.8e1 * t57 * t60 * t232 * t65 * t252) / 0.24e2))
  t268 = f.my_piecewise5(t14, 0, t10, 0, -t173)
  t271 = f.my_piecewise3(t108, 0, 0.4e1 / 0.3e1 * t109 * t268)
  t279 = t5 * t111 * t183 * t165 / 0.8e1
  t281 = f.my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t5 * t271 * t26 * t165 - t279)
  vrho_0_ = t104 + t169 + t6 * (t266 + t281)
  t284 = -t7 - t172
  t285 = f.my_piecewise5(t10, 0, t14, 0, t284)
  t288 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t285)
  t294 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t288 * t26 * t100 - t187)
  t296 = f.my_piecewise5(t14, 0, t10, 0, -t284)
  t299 = f.my_piecewise3(t108, 0, 0.4e1 / 0.3e1 * t109 * t296)
  t306 = 0.1e1 / t115 / t113 / r1
  t311 = s2 ** 2
  t312 = t113 ** 2
  t315 = 0.1e1 / t114 / t312 / t113
  t317 = t123 ** 2
  t318 = 0.1e1 / t317
  t326 = t198 * t311
  t334 = params.c * t160
  t338 = t159 ** 2
  t340 = t132 / t338
  t342 = 0.1e1 / t114 / t113
  t344 = t57 * t134 * t342
  t349 = 0.1e1 / (0.1e1 + t146)
  t351 = t237 * t148 * t154 * t349
  t356 = t146 ** 2
  t357 = t154 ** 2
  t361 = t356 / t357 / t154 * t349
  t375 = f.my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t5 * t299 * t26 * t165 - t279 - 0.3e1 / 0.8e1 * t5 * t112 * (t34 * s2 * t306 * t124 / 0.9e1 - t199 * t311 * t315 * t318 / 0.216e3 - t128 * t306 * t124 * t161 / 0.9e1 + t196 * t326 * t315 * t318 * t161 / 0.216e3 - t221 * t326 * t315 * t124 * t334 / 0.216e3 - t128 * t129 * t340 * (-t344 * t156 / 0.6e1 - t344 * t351 / 0.6e1 - 0.3e1 / 0.8e1 * t57 * t134 * t342 * t65 * t361) / 0.24e2))
  vrho_1_ = t104 + t169 + t6 * (t294 + t375)
  t384 = 0.1e1 / t36 / t201 / r0
  t391 = t198 * s0
  t403 = t58 / t59
  t405 = t57 * t403 * t62
  t424 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-t29 * t33 * t39 * t46 / 0.24e2 + t199 * s0 * t384 * t207 / 0.576e3 + t34 * t97 / 0.24e2 - t196 * t391 * t384 * t207 * t96 / 0.576e3 + t221 * t391 * t384 * t46 * t224 / 0.576e3 - t50 * t51 * t230 * (t405 * t91 / 0.16e2 + t405 * t242 / 0.16e2 + 0.9e1 / 0.64e2 * t57 * t403 * t62 * t65 * t252) / 0.24e2))
  vsigma_0_ = t6 * t424
  vsigma_1_ = 0.0e0
  t431 = 0.1e1 / t114 / t312 / r1
  t438 = t198 * s2
  t450 = t58 / t133
  t452 = t57 * t450 * t136
  t471 = f.my_piecewise3(t105, 0, -0.3e1 / 0.8e1 * t5 * t112 * (-t29 * t33 * t117 * t124 / 0.24e2 + t199 * s2 * t431 * t318 / 0.576e3 + t34 * t162 / 0.24e2 - t196 * t438 * t431 * t318 * t161 / 0.576e3 + t221 * t438 * t431 * t124 * t334 / 0.576e3 - t128 * t129 * t340 * (t452 * t156 / 0.16e2 + t452 * t351 / 0.16e2 + 0.9e1 / 0.64e2 * t57 * t450 * t136 * t65 * t361) / 0.24e2))
  vsigma_2_ = t6 * t471
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  am05_d = 28.23705740248932

  am05_csi = lambda s: (3 / 2 * LambertW(s ** (3 / 2) / (2 * jnp.sqrt(6)))) ** (2 / 3)

  am05_XX = lambda s: 1 - params_alpha * s ** 2 / (1 + params_alpha * s ** 2)

  am05_fb = lambda s: jnp.pi / 3 * s / (am05_csi(s) * (am05_d + am05_csi(s) ** 2) ** (1 / 4))

  am05_flaa = lambda s: (1 + params_c * s ** 2) / (1 + params_c * s ** 2 / am05_fb(s))

  am05_f = lambda x: am05_XX(X2S * x) + (1 - am05_XX(X2S * x)) * am05_flaa(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, am05_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = params.alpha * t20
  t22 = jnp.pi ** 2
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = 0.1e1 / t24
  t26 = t21 * t25
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = s0 * t28
  t30 = r0 ** 2
  t31 = t18 ** 2
  t33 = 0.1e1 / t31 / t30
  t34 = t29 * t33
  t37 = 0.1e1 + t26 * t34 / 0.24e2
  t38 = 0.1e1 / t37
  t39 = t33 * t38
  t43 = t25 * s0
  t44 = t21 * t43
  t45 = t28 * t33
  t50 = 0.1e1 + params.c * t20 * t25 * t34 / 0.24e2
  t52 = t20 ** 2
  t53 = params.c * t52
  t54 = 0.1e1 / t23
  t55 = jnp.sqrt(s0)
  t56 = t54 * t55
  t58 = t53 * t56 * t28
  t60 = 0.1e1 / t18 / r0
  t61 = 0.1e1 / jnp.pi
  t62 = t60 * t61
  t63 = t3 ** 2
  t64 = jnp.sqrt(0.12e2)
  t68 = t52 * t54 * t55 * t27 * t60
  t69 = jnp.sqrt(t68)
  t72 = jnp.sqrt(0.6e1)
  t75 = lambertw(t64 * t69 * t68 * t72 / 0.1728e4)
  t76 = t75 ** (0.1e1 / 0.3e1)
  t77 = t76 ** 2
  t84 = (0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t3 * t28 * t76 * t75) ** (0.1e1 / 0.4e1)
  t85 = t63 * t77 * t84
  t86 = t62 * t85
  t89 = 0.1e1 + t58 * t86 / 0.8e1
  t90 = 0.1e1 / t89
  t91 = t38 * t50 * t90
  t95 = 0.1e1 - t26 * t29 * t39 / 0.24e2 + t44 * t45 * t91 / 0.24e2
  t99 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t95)
  t107 = 0.1e1 / t31 / t30 / r0
  t112 = params.alpha ** 2
  t113 = t112 * t52
  t115 = 0.1e1 / t23 / t22
  t116 = t113 * t115
  t117 = s0 ** 2
  t119 = t30 ** 2
  t122 = 0.1e1 / t18 / t119 / t30
  t123 = t37 ** 2
  t124 = 0.1e1 / t123
  t133 = t115 * t117
  t135 = t27 * t122
  t137 = t124 * t50 * t90
  t141 = params.alpha * t52
  t144 = t38 * params.c * t90
  t149 = t21 * t43 * t28
  t150 = t89 ** 2
  t152 = t50 / t150
  t155 = 0.1e1 / t18 / t30 * t61
  t162 = 0.1e1 / (0.1e1 + t75)
  t163 = t77 * t84 * t162
  t169 = t75 ** 2
  t170 = t84 ** 2
  t174 = t169 / t170 / t84 * t162
  t188 = f.my_piecewise3(t2, 0, -t6 * t17 / t31 * t95 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t26 * t29 * t107 * t38 / 0.9e1 - t116 * t117 * t27 * t122 * t124 / 0.108e3 - t44 * t28 * t107 * t91 / 0.9e1 + t113 * t133 * t135 * t137 / 0.108e3 - t141 * t133 * t135 * t144 / 0.108e3 - t149 * t39 * t152 * (-t58 * t155 * t85 / 0.6e1 - t58 * t155 * t63 * t163 / 0.6e1 - 0.3e1 / 0.8e1 * t53 * t56 * t27 * t155 * t174) / 0.24e2))
  vrho_0_ = 0.2e1 * r0 * t188 + 0.2e1 * t99
  t197 = 0.1e1 / t18 / t119 / r0
  t208 = t115 * s0
  t210 = t27 * t197
  t219 = t54 / t55
  t221 = t53 * t219 * t28
  t242 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-t26 * t45 * t38 / 0.24e2 + t116 * s0 * t27 * t197 * t124 / 0.288e3 + t21 * t25 * t28 * t39 * t50 * t90 / 0.24e2 - t113 * t208 * t210 * t137 / 0.288e3 + t141 * t208 * t210 * t144 / 0.288e3 - t149 * t39 * t152 * (t221 * t86 / 0.16e2 + t221 * t62 * t63 * t163 / 0.16e2 + 0.9e1 / 0.64e2 * t53 * t219 * t27 * t62 * t174) / 0.24e2))
  vsigma_0_ = 0.2e1 * r0 * t242
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = params.alpha * t22
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t35 = t31 * t34
  t38 = 0.1e1 + t28 * t35 / 0.24e2
  t39 = 0.1e1 / t38
  t40 = t34 * t39
  t44 = t27 * s0
  t45 = t23 * t44
  t46 = t30 * t34
  t51 = 0.1e1 + params.c * t22 * t27 * t35 / 0.24e2
  t53 = t22 ** 2
  t54 = params.c * t53
  t55 = 0.1e1 / t25
  t56 = jnp.sqrt(s0)
  t57 = t55 * t56
  t59 = t54 * t57 * t30
  t61 = 0.1e1 / t18 / r0
  t62 = 0.1e1 / jnp.pi
  t63 = t61 * t62
  t64 = t3 ** 2
  t65 = jnp.sqrt(0.12e2)
  t69 = t53 * t55 * t56 * t29 * t61
  t70 = jnp.sqrt(t69)
  t73 = jnp.sqrt(0.6e1)
  t76 = lambertw(t65 * t70 * t69 * t73 / 0.1728e4)
  t77 = t76 ** (0.1e1 / 0.3e1)
  t78 = t77 ** 2
  t84 = 0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t3 * t30 * t77 * t76
  t85 = t84 ** (0.1e1 / 0.4e1)
  t86 = t64 * t78 * t85
  t87 = t63 * t86
  t90 = 0.1e1 + t59 * t87 / 0.8e1
  t91 = 0.1e1 / t90
  t92 = t39 * t51 * t91
  t96 = 0.1e1 - t28 * t31 * t40 / 0.24e2 + t45 * t46 * t92 / 0.24e2
  t100 = t17 * t18
  t101 = t32 * r0
  t103 = 0.1e1 / t19 / t101
  t104 = t103 * t39
  t108 = params.alpha ** 2
  t109 = t108 * t53
  t111 = 0.1e1 / t25 / t24
  t112 = t109 * t111
  t113 = s0 ** 2
  t114 = t113 * t29
  t115 = t32 ** 2
  t118 = 0.1e1 / t18 / t115 / t32
  t119 = t38 ** 2
  t120 = 0.1e1 / t119
  t121 = t118 * t120
  t125 = t30 * t103
  t129 = t111 * t113
  t130 = t109 * t129
  t131 = t29 * t118
  t133 = t120 * t51 * t91
  t137 = params.alpha * t53
  t138 = t137 * t129
  t140 = t39 * params.c * t91
  t145 = t23 * t44 * t30
  t146 = t90 ** 2
  t147 = 0.1e1 / t146
  t148 = t51 * t147
  t150 = 0.1e1 / t18 / t32
  t151 = t150 * t62
  t152 = t151 * t86
  t155 = t151 * t64
  t156 = t78 * t85
  t157 = 0.1e1 + t76
  t158 = 0.1e1 / t157
  t159 = t156 * t158
  t160 = t155 * t159
  t164 = t54 * t57 * t29
  t165 = t76 ** 2
  t166 = t85 ** 2
  t167 = t166 * t85
  t168 = 0.1e1 / t167
  t169 = t165 * t168
  t170 = t169 * t158
  t171 = t151 * t170
  t174 = -t59 * t152 / 0.6e1 - t59 * t160 / 0.6e1 - 0.3e1 / 0.8e1 * t164 * t171
  t175 = t148 * t174
  t176 = t40 * t175
  t179 = t28 * t31 * t104 / 0.9e1 - t112 * t114 * t121 / 0.108e3 - t45 * t125 * t92 / 0.9e1 + t130 * t131 * t133 / 0.108e3 - t138 * t131 * t140 / 0.108e3 - t145 * t176 / 0.24e2
  t184 = f.my_piecewise3(t2, 0, -t6 * t21 * t96 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t100 * t179)
  t196 = 0.1e1 / t19 / t115
  t203 = 0.1e1 / t18 / t115 / t101
  t209 = t24 ** 2
  t210 = 0.1e1 / t209
  t211 = t108 * params.alpha * t210
  t212 = t113 * s0
  t213 = t115 ** 2
  t215 = 0.1e1 / t213 / t32
  t218 = 0.1e1 / t119 / t38
  t226 = t29 * t203
  t238 = t51 * t91
  t242 = t108 * t210
  t245 = params.c * t91
  t249 = t129 * t29
  t250 = t109 * t249
  t254 = t137 * t249
  t255 = t118 * t39
  t256 = params.c * t147
  t257 = t256 * t174
  t262 = 0.1e1 / t146 / t90
  t263 = t51 * t262
  t264 = t174 ** 2
  t270 = 0.1e1 / t18 / t101
  t271 = t270 * t62
  t275 = t271 * t64
  t282 = t157 ** 2
  t283 = 0.1e1 / t282
  t284 = t156 * t283
  t288 = t169 * t283
  t295 = 0.1e1 / t282 / t157
  t296 = t78 * t76 * t85 * t295
  t302 = t165 * t76
  t309 = t62 * t77 * t302 / t167 / t84 * t283 * t3
  t313 = t302 * t168 * t295
  t322 = -0.11e2 / 0.27e2 * t28 * t31 * t196 * t39 + t112 * t114 * t203 * t120 / 0.12e2 - 0.2e1 / 0.81e2 * t211 * t212 * t215 * t218 + 0.11e2 / 0.27e2 * t45 * t30 * t196 * t92 - t130 * t226 * t133 / 0.12e2 + t138 * t226 * t140 / 0.12e2 + 0.2e1 / 0.9e1 * t145 * t104 * t175 + 0.2e1 / 0.81e2 * t211 * t212 * t215 * t218 * t238 - 0.2e1 / 0.81e2 * t242 * t212 * t215 * t120 * t245 - t250 * t121 * t175 / 0.54e2 + t254 * t255 * t257 / 0.54e2 + t145 * t40 * t263 * t264 / 0.12e2 - t145 * t40 * t148 * (0.7e1 / 0.18e2 * t59 * t271 * t86 + 0.11e2 / 0.18e2 * t59 * t275 * t159 + 0.11e2 / 0.8e1 * t164 * t271 * t170 + 0.2e1 / 0.9e1 * t59 * t275 * t284 + 0.2e1 * t164 * t271 * t288 - t59 * t275 * t296 / 0.3e1 - 0.9e1 / 0.8e1 * t54 * t57 * t270 * t309 - 0.3e1 / 0.4e1 * t164 * t271 * t313) / 0.24e2
  t327 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t96 / 0.12e2 - t6 * t21 * t179 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t100 * t322)
  v2rho2_0_ = 0.2e1 * r0 * t327 + 0.4e1 * t184
  t336 = 0.1e1 / t18 / t115 / r0
  t337 = t336 * t120
  t342 = t23 * t27 * t30
  t346 = t111 * s0
  t348 = t29 * t336
  t357 = t55 / t56
  t359 = t54 * t357 * t30
  t362 = t63 * t64
  t367 = t54 * t357 * t29
  t371 = t359 * t87 / 0.16e2 + t359 * t362 * t159 / 0.16e2 + 0.9e1 / 0.64e2 * t367 * t63 * t170
  t372 = t148 * t371
  t373 = t40 * t372
  t376 = -t28 * t46 * t39 / 0.24e2 + t112 * s0 * t29 * t337 / 0.288e3 + t342 * t40 * t238 / 0.24e2 - t109 * t346 * t348 * t133 / 0.288e3 + t137 * t346 * t348 * t140 / 0.288e3 - t145 * t373 / 0.24e2
  t380 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t100 * t376)
  t392 = 0.1e1 / t213 / r0
  t400 = t111 * t29
  t401 = t109 * t400
  t406 = t137 * t400
  t424 = t346 * t29
  t425 = t109 * t424
  t429 = t137 * t424
  t430 = t336 * t39
  t440 = t256 * t371
  t477 = t28 * t125 * t39 / 0.9e1 - t112 * t131 * t120 * s0 / 0.36e2 + t211 * t113 * t392 * t218 / 0.108e3 - t342 * t104 * t238 / 0.9e1 + t401 * t121 * t238 * s0 / 0.36e2 - t406 * t255 * params.c * s0 * t91 / 0.36e2 - t342 * t176 / 0.24e2 - t211 * t113 * t392 * t218 * t238 / 0.108e3 + t242 * t113 * t392 * t120 * t245 / 0.108e3 + t425 * t337 * t175 / 0.288e3 - t429 * t430 * t257 / 0.288e3 + t145 * t104 * t372 / 0.9e1 - t250 * t121 * t372 / 0.108e3 + t254 * t255 * t440 / 0.108e3 + t145 * t40 * t51 * t262 * t371 * t174 / 0.12e2 - t145 * t40 * t148 * (-t359 * t152 / 0.12e2 - t359 * t160 / 0.6e1 - 0.3e1 / 0.8e1 * t367 * t171 - t359 * t155 * t284 / 0.12e2 - 0.3e1 / 0.4e1 * t367 * t151 * t288 + t359 * t155 * t296 / 0.8e1 + 0.27e2 / 0.64e2 * t54 * t357 * t150 * t309 + 0.9e1 / 0.32e2 * t367 * t151 * t313) / 0.24e2
  t482 = f.my_piecewise3(t2, 0, -t6 * t21 * t376 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t100 * t477)
  v2rhosigma_0_ = 0.2e1 * r0 * t482 + 0.2e1 * t380
  t488 = 0.1e1 / t213
  t517 = t371 ** 2
  t524 = t55 / t56 / s0
  t526 = t54 * t524 * t30
  t533 = t54 * t524 * t29
  t552 = t112 * t348 * t120 / 0.144e3 - t211 * s0 * t488 * t218 / 0.288e3 - t401 * t337 * t238 / 0.144e3 + t406 * t430 * t245 / 0.144e3 - t342 * t373 / 0.12e2 + t211 * s0 * t488 * t218 * t238 / 0.288e3 - t242 * s0 * t488 * t120 * t245 / 0.288e3 + t425 * t337 * t372 / 0.144e3 - t429 * t430 * t440 / 0.144e3 + t145 * t40 * t263 * t517 / 0.12e2 - t145 * t40 * t148 * (-t526 * t87 / 0.32e2 + t526 * t362 * t284 / 0.32e2 + 0.9e1 / 0.32e2 * t533 * t63 * t288 - 0.3e1 / 0.64e2 * t526 * t362 * t296 - 0.81e2 / 0.512e3 * t54 * t524 * t61 * t309 - 0.27e2 / 0.256e3 * t533 * t63 * t313) / 0.24e2
  t556 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t100 * t552)
  v2sigma2_0_ = 0.2e1 * r0 * t556
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = params.alpha * t23
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t33 = r0 ** 2
  t35 = 0.1e1 / t19 / t33
  t36 = t32 * t35
  t39 = 0.1e1 + t29 * t36 / 0.24e2
  t40 = 0.1e1 / t39
  t41 = t35 * t40
  t45 = t28 * s0
  t46 = t24 * t45
  t48 = params.c * t23
  t52 = 0.1e1 + t48 * t28 * t36 / 0.24e2
  t54 = t23 ** 2
  t55 = params.c * t54
  t56 = 0.1e1 / t26
  t57 = jnp.sqrt(s0)
  t58 = t56 * t57
  t60 = t55 * t58 * t31
  t62 = 0.1e1 / t18 / r0
  t63 = 0.1e1 / jnp.pi
  t65 = t3 ** 2
  t66 = jnp.sqrt(0.12e2)
  t70 = t54 * t56 * t57 * t30 * t62
  t71 = jnp.sqrt(t70)
  t74 = jnp.sqrt(0.6e1)
  t77 = scipy.special.lambertw(t66 * t71 * t70 * t74 / 0.1728e4)
  t78 = t77 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t85 = 0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t3 * t31 * t78 * t77
  t86 = t85 ** (0.1e1 / 0.4e1)
  t87 = t65 * t79 * t86
  t91 = 0.1e1 + t60 * t62 * t63 * t87 / 0.8e1
  t92 = 0.1e1 / t91
  t93 = t40 * t52 * t92
  t97 = 0.1e1 - t29 * t32 * t41 / 0.24e2 + t46 * t31 * t35 * t93 / 0.24e2
  t102 = t17 / t19
  t103 = t33 * r0
  t105 = 0.1e1 / t19 / t103
  t106 = t105 * t40
  t110 = params.alpha ** 2
  t111 = t110 * t54
  t113 = 0.1e1 / t26 / t25
  t114 = t111 * t113
  t115 = s0 ** 2
  t116 = t115 * t30
  t117 = t33 ** 2
  t120 = 0.1e1 / t18 / t117 / t33
  t121 = t39 ** 2
  t122 = 0.1e1 / t121
  t123 = t120 * t122
  t131 = t113 * t115
  t132 = t111 * t131
  t133 = t30 * t120
  t135 = t122 * t52 * t92
  t139 = params.alpha * t54
  t140 = t139 * t131
  t142 = t40 * params.c * t92
  t147 = t24 * t45 * t31
  t148 = t91 ** 2
  t149 = 0.1e1 / t148
  t150 = t52 * t149
  t153 = 0.1e1 / t18 / t33 * t63
  t158 = t79 * t86
  t159 = 0.1e1 + t77
  t160 = 0.1e1 / t159
  t161 = t158 * t160
  t166 = t55 * t58 * t30
  t167 = t77 ** 2
  t168 = t86 ** 2
  t169 = t168 * t86
  t170 = 0.1e1 / t169
  t171 = t167 * t170
  t172 = t171 * t160
  t176 = -t60 * t153 * t87 / 0.6e1 - t60 * t153 * t65 * t161 / 0.6e1 - 0.3e1 / 0.8e1 * t166 * t153 * t172
  t177 = t150 * t176
  t181 = t29 * t32 * t106 / 0.9e1 - t114 * t116 * t123 / 0.108e3 - t46 * t31 * t105 * t93 / 0.9e1 + t132 * t133 * t135 / 0.108e3 - t140 * t133 * t142 / 0.108e3 - t147 * t41 * t177 / 0.24e2
  t185 = t17 * t18
  t187 = 0.1e1 / t19 / t117
  t188 = t187 * t40
  t194 = 0.1e1 / t18 / t117 / t103
  t195 = t194 * t122
  t200 = t25 ** 2
  t201 = 0.1e1 / t200
  t202 = t110 * params.alpha * t201
  t203 = t115 * s0
  t204 = t117 ** 2
  t206 = 0.1e1 / t204 / t33
  t207 = t203 * t206
  t209 = 0.1e1 / t121 / t39
  t217 = t30 * t194
  t227 = t202 * t203
  t229 = t52 * t92
  t233 = t110 * t201
  t234 = t233 * t203
  t236 = params.c * t92
  t240 = t131 * t30
  t241 = t111 * t240
  t245 = t139 * t240
  t246 = t120 * t40
  t247 = params.c * t149
  t248 = t247 * t176
  t253 = 0.1e1 / t148 / t91
  t255 = t176 ** 2
  t256 = t52 * t253 * t255
  t261 = 0.1e1 / t18 / t103
  t262 = t261 * t63
  t266 = t262 * t65
  t273 = t159 ** 2
  t274 = 0.1e1 / t273
  t275 = t158 * t274
  t279 = t171 * t274
  t284 = t79 * t77 * t86
  t286 = 0.1e1 / t273 / t159
  t287 = t284 * t286
  t293 = t167 * t77
  t295 = t63 * t78 * t293
  t297 = 0.1e1 / t169 / t85
  t300 = t295 * t297 * t274 * t3
  t303 = t293 * t170
  t304 = t303 * t286
  t308 = 0.7e1 / 0.18e2 * t60 * t262 * t87 + 0.11e2 / 0.18e2 * t60 * t266 * t161 + 0.11e2 / 0.8e1 * t166 * t262 * t172 + 0.2e1 / 0.9e1 * t60 * t266 * t275 + 0.2e1 * t166 * t262 * t279 - t60 * t266 * t287 / 0.3e1 - 0.9e1 / 0.8e1 * t55 * t58 * t261 * t300 - 0.3e1 / 0.4e1 * t166 * t262 * t304
  t309 = t150 * t308
  t313 = -0.11e2 / 0.27e2 * t29 * t32 * t188 + t114 * t116 * t195 / 0.12e2 - 0.2e1 / 0.81e2 * t202 * t207 * t209 + 0.11e2 / 0.27e2 * t46 * t31 * t187 * t93 - t132 * t217 * t135 / 0.12e2 + t140 * t217 * t142 / 0.12e2 + 0.2e1 / 0.9e1 * t147 * t106 * t177 + 0.2e1 / 0.81e2 * t227 * t206 * t209 * t229 - 0.2e1 / 0.81e2 * t234 * t206 * t122 * t236 - t241 * t123 * t177 / 0.54e2 + t245 * t246 * t248 / 0.54e2 + t147 * t41 * t256 / 0.12e2 - t147 * t41 * t309 / 0.24e2
  t318 = f.my_piecewise3(t2, 0, t6 * t22 * t97 / 0.12e2 - t6 * t102 * t181 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t185 * t313)
  t342 = 0.1e1 / t18 / t117
  t343 = t342 * t63
  t344 = t167 ** 2
  t346 = t273 ** 2
  t348 = 0.1e1 / t346 / t159
  t354 = t55 * t58 * t342
  t360 = 0.1e1 / t346
  t387 = t343 * t65
  t396 = t85 ** 2
  t425 = -0.9e1 / 0.2e1 * t166 * t343 * t344 * t170 * t348 + 0.27e2 / 0.2e1 * t354 * t295 * t297 * t286 * t3 + 0.27e2 / 0.2e1 * t166 * t343 * t303 * t360 - 0.27e2 / 0.4e1 * t354 * t63 * t78 * t344 * t297 * t360 * t3 - 0.23e2 / 0.4e1 * t166 * t343 * t172 - 0.14e2 * t166 * t343 * t279 + 0.63e2 / 0.8e1 * t354 * t300 + 0.21e2 / 0.4e1 * t166 * t343 * t304 - 0.26e2 / 0.3e1 * t166 * t343 * t171 * t286 - 0.2e1 * t60 * t387 * t79 * t167 * t86 * t348 - 0.63e2 / 0.16e2 * t354 * t63 * t79 * t344 / t169 / t396 * t286 * t65 * t31 - 0.23e2 / 0.9e1 * t60 * t387 * t161 - 0.14e2 / 0.9e1 * t60 * t387 * t275 + 0.7e1 / 0.3e1 * t60 * t387 * t287 - 0.8e1 / 0.27e2 * t60 * t387 * t158 * t286 + 0.2e1 * t60 * t387 * t284 * t360 - 0.35e2 / 0.27e2 * t60 * t343 * t87
  t450 = t110 ** 2
  t451 = t450 * t201
  t452 = t115 ** 2
  t453 = t117 * r0
  t457 = t452 / t19 / t204 / t453
  t458 = t121 ** 2
  t459 = 0.1e1 / t458
  t469 = t28 * t31
  t474 = -t245 * t246 * params.c * t253 * t255 / 0.18e2 - 0.2e1 / 0.3e1 * t147 * t106 * t256 - t241 * t123 * t309 / 0.36e2 - t147 * t41 * t150 * t425 / 0.24e2 - t245 * t194 * t40 * t248 / 0.4e1 + t147 * t106 * t309 / 0.3e1 - 0.11e2 / 0.9e1 * t147 * t188 * t177 + t241 * t195 * t177 / 0.4e1 + t241 * t123 * t256 / 0.18e2 + t245 * t246 * t247 * t308 / 0.36e2 + 0.2e1 / 0.243e3 * t451 * t457 * t459 * t229 * t23 * t28 * t31 - 0.2e1 / 0.243e3 * t202 * t457 * t209 * t48 * t469 * t92
  t476 = 0.1e1 / t204 / t103
  t483 = t149 * t176
  t497 = t148 ** 2
  t512 = 0.1e1 / t19 / t453
  t518 = 0.1e1 / t18 / t204
  t535 = t30 * t518
  t542 = 0.38e2 / 0.81e2 * t202 * t203 * t476 * t209 + 0.2e1 / 0.27e2 * t233 * t207 * t122 * params.c * t483 - 0.2e1 / 0.243e3 * t451 * t457 * t459 * t23 * t469 - 0.2e1 / 0.27e2 * t202 * t207 * t209 * t52 * t483 - t147 * t41 * t52 / t497 * t255 * t176 / 0.4e1 + t147 * t41 * t52 * t253 * t176 * t308 / 0.4e1 + 0.154e3 / 0.81e2 * t29 * t32 * t512 * t40 - 0.341e3 / 0.486e3 * t114 * t116 * t518 * t122 - 0.38e2 / 0.81e2 * t227 * t476 * t209 * t229 + 0.38e2 / 0.81e2 * t234 * t476 * t122 * t236 - 0.154e3 / 0.81e2 * t46 * t31 * t512 * t93 + 0.341e3 / 0.486e3 * t132 * t535 * t135 - 0.341e3 / 0.486e3 * t140 * t535 * t142
  t548 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t35 * t97 + t6 * t22 * t181 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t313 - 0.3e1 / 0.8e1 * t6 * t185 * (t474 + t542))
  v3rho3_0_ = 0.2e1 * r0 * t548 + 0.6e1 * t318

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = params.alpha * t24
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = t25 * t29
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = s0 * t32
  t34 = t33 * t22
  t37 = 0.1e1 + t30 * t34 / 0.24e2
  t38 = 0.1e1 / t37
  t39 = t22 * t38
  t43 = t29 * s0
  t44 = t25 * t43
  t46 = params.c * t24
  t47 = t46 * t29
  t50 = 0.1e1 + t47 * t34 / 0.24e2
  t52 = t24 ** 2
  t53 = params.c * t52
  t54 = 0.1e1 / t27
  t55 = jnp.sqrt(s0)
  t56 = t54 * t55
  t58 = t53 * t56 * t32
  t60 = 0.1e1 / t19 / r0
  t61 = 0.1e1 / jnp.pi
  t63 = t3 ** 2
  t64 = jnp.sqrt(0.12e2)
  t68 = t52 * t54 * t55 * t31 * t60
  t69 = jnp.sqrt(t68)
  t72 = jnp.sqrt(0.6e1)
  t75 = scipy.special.lambertw(t64 * t69 * t68 * t72 / 0.1728e4)
  t76 = t75 ** (0.1e1 / 0.3e1)
  t77 = t76 ** 2
  t83 = 0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t3 * t32 * t76 * t75
  t84 = t83 ** (0.1e1 / 0.4e1)
  t85 = t63 * t77 * t84
  t89 = 0.1e1 + t58 * t60 * t61 * t85 / 0.8e1
  t90 = 0.1e1 / t89
  t91 = t38 * t50 * t90
  t95 = 0.1e1 - t30 * t33 * t39 / 0.24e2 + t44 * t32 * t22 * t91 / 0.24e2
  t101 = t17 / t20 / r0
  t102 = t18 * r0
  t104 = 0.1e1 / t20 / t102
  t105 = t104 * t38
  t109 = params.alpha ** 2
  t110 = t109 * t52
  t112 = 0.1e1 / t27 / t26
  t113 = t110 * t112
  t114 = s0 ** 2
  t115 = t114 * t31
  t116 = t18 ** 2
  t117 = t116 * t18
  t119 = 0.1e1 / t19 / t117
  t120 = t37 ** 2
  t121 = 0.1e1 / t120
  t122 = t119 * t121
  t130 = t112 * t114
  t131 = t110 * t130
  t132 = t31 * t119
  t134 = t121 * t50 * t90
  t138 = params.alpha * t52
  t139 = t138 * t130
  t141 = t38 * params.c * t90
  t146 = t25 * t43 * t32
  t147 = t89 ** 2
  t148 = 0.1e1 / t147
  t149 = t50 * t148
  t152 = 0.1e1 / t19 / t18 * t61
  t157 = t77 * t84
  t158 = 0.1e1 + t75
  t159 = 0.1e1 / t158
  t160 = t157 * t159
  t165 = t53 * t56 * t31
  t166 = t75 ** 2
  t167 = t84 ** 2
  t168 = t167 * t84
  t169 = 0.1e1 / t168
  t170 = t166 * t169
  t171 = t170 * t159
  t175 = -t58 * t152 * t85 / 0.6e1 - t58 * t152 * t63 * t160 / 0.6e1 - 0.3e1 / 0.8e1 * t165 * t152 * t171
  t176 = t149 * t175
  t180 = t30 * t33 * t105 / 0.9e1 - t113 * t115 * t122 / 0.108e3 - t44 * t32 * t104 * t91 / 0.9e1 + t131 * t132 * t134 / 0.108e3 - t139 * t132 * t141 / 0.108e3 - t146 * t39 * t176 / 0.24e2
  t185 = t17 / t20
  t187 = 0.1e1 / t20 / t116
  t188 = t187 * t38
  t194 = 0.1e1 / t19 / t116 / t102
  t195 = t194 * t121
  t200 = t26 ** 2
  t201 = 0.1e1 / t200
  t202 = t109 * params.alpha * t201
  t203 = t114 * s0
  t204 = t116 ** 2
  t206 = 0.1e1 / t204 / t18
  t207 = t203 * t206
  t209 = 0.1e1 / t120 / t37
  t217 = t31 * t194
  t227 = t202 * t203
  t229 = t50 * t90
  t233 = t109 * t201
  t234 = t233 * t203
  t236 = params.c * t90
  t240 = t130 * t31
  t241 = t110 * t240
  t245 = t138 * t240
  t246 = t119 * t38
  t247 = params.c * t148
  t248 = t247 * t175
  t253 = 0.1e1 / t147 / t89
  t254 = t50 * t253
  t255 = t175 ** 2
  t256 = t254 * t255
  t261 = 0.1e1 / t19 / t102
  t262 = t261 * t61
  t266 = t262 * t63
  t273 = t158 ** 2
  t274 = 0.1e1 / t273
  t275 = t157 * t274
  t279 = t170 * t274
  t284 = t77 * t75 * t84
  t285 = t273 * t158
  t286 = 0.1e1 / t285
  t287 = t284 * t286
  t293 = t166 * t75
  t295 = t61 * t76 * t293
  t297 = 0.1e1 / t168 / t83
  t300 = t295 * t297 * t274 * t3
  t303 = t293 * t169
  t304 = t303 * t286
  t308 = 0.7e1 / 0.18e2 * t58 * t262 * t85 + 0.11e2 / 0.18e2 * t58 * t266 * t160 + 0.11e2 / 0.8e1 * t165 * t262 * t171 + 0.2e1 / 0.9e1 * t58 * t266 * t275 + 0.2e1 * t165 * t262 * t279 - t58 * t266 * t287 / 0.3e1 - 0.9e1 / 0.8e1 * t53 * t56 * t261 * t300 - 0.3e1 / 0.4e1 * t165 * t262 * t304
  t309 = t149 * t308
  t313 = -0.11e2 / 0.27e2 * t30 * t33 * t188 + t113 * t115 * t195 / 0.12e2 - 0.2e1 / 0.81e2 * t202 * t207 * t209 + 0.11e2 / 0.27e2 * t44 * t32 * t187 * t91 - t131 * t217 * t134 / 0.12e2 + t139 * t217 * t141 / 0.12e2 + 0.2e1 / 0.9e1 * t146 * t105 * t176 + 0.2e1 / 0.81e2 * t227 * t206 * t209 * t229 - 0.2e1 / 0.81e2 * t234 * t206 * t121 * t236 - t241 * t122 * t176 / 0.54e2 + t245 * t246 * t248 / 0.54e2 + t146 * t39 * t256 / 0.12e2 - t146 * t39 * t309 / 0.24e2
  t317 = t17 * t19
  t318 = t194 * t38
  t326 = params.c * t253 * t255
  t340 = 0.1e1 / t19 / t116
  t341 = t340 * t61
  t342 = t166 ** 2
  t343 = t342 * t169
  t344 = t273 ** 2
  t346 = 0.1e1 / t344 / t158
  t347 = t343 * t346
  t352 = t53 * t56 * t340
  t355 = t295 * t297 * t286 * t3
  t358 = 0.1e1 / t344
  t359 = t303 * t358
  t364 = t61 * t76 * t342
  t366 = t297 * t358 * t3
  t367 = t364 * t366
  t381 = t170 * t286
  t385 = t341 * t63
  t387 = t77 * t166 * t84
  t388 = t387 * t346
  t394 = t83 ** 2
  t396 = 0.1e1 / t168 / t394
  t397 = t61 * t77 * t342 * t396
  t400 = t397 * t286 * t63 * t32
  t412 = t157 * t286
  t416 = t284 * t358
  t423 = -0.9e1 / 0.2e1 * t165 * t341 * t347 + 0.27e2 / 0.2e1 * t352 * t355 + 0.27e2 / 0.2e1 * t165 * t341 * t359 - 0.27e2 / 0.4e1 * t352 * t367 - 0.23e2 / 0.4e1 * t165 * t341 * t171 - 0.14e2 * t165 * t341 * t279 + 0.63e2 / 0.8e1 * t352 * t300 + 0.21e2 / 0.4e1 * t165 * t341 * t304 - 0.26e2 / 0.3e1 * t165 * t341 * t381 - 0.2e1 * t58 * t385 * t388 - 0.63e2 / 0.16e2 * t352 * t400 - 0.23e2 / 0.9e1 * t58 * t385 * t160 - 0.14e2 / 0.9e1 * t58 * t385 * t275 + 0.7e1 / 0.3e1 * t58 * t385 * t287 - 0.8e1 / 0.27e2 * t58 * t385 * t412 + 0.2e1 * t58 * t385 * t416 - 0.35e2 / 0.27e2 * t58 * t341 * t85
  t424 = t149 * t423
  t428 = t147 ** 2
  t429 = 0.1e1 / t428
  t431 = t255 * t175
  t432 = t50 * t429 * t431
  t442 = t247 * t308
  t446 = t109 ** 2
  t447 = t446 * t201
  t448 = t114 ** 2
  t449 = t116 * r0
  t453 = t448 / t20 / t204 / t449
  t454 = t120 ** 2
  t455 = 0.1e1 / t454
  t457 = t447 * t453 * t455
  t459 = t24 * t29 * t32
  t460 = t229 * t459
  t463 = -t245 * t318 * t248 / 0.4e1 + t241 * t195 * t176 / 0.4e1 - t245 * t246 * t326 / 0.18e2 + t241 * t122 * t256 / 0.18e2 - 0.2e1 / 0.3e1 * t146 * t105 * t256 - t241 * t122 * t309 / 0.36e2 - t146 * t39 * t424 / 0.24e2 - t146 * t39 * t432 / 0.4e1 + t146 * t105 * t309 / 0.3e1 - 0.11e2 / 0.9e1 * t146 * t188 * t176 + t245 * t246 * t442 / 0.36e2 + 0.2e1 / 0.243e3 * t457 * t460
  t465 = t202 * t453 * t209
  t466 = t29 * t32
  t468 = t46 * t466 * t90
  t472 = 0.1e1 / t20 / t449
  t478 = 0.1e1 / t19 / t204
  t479 = t31 * t478
  t486 = t478 * t121
  t490 = t472 * t38
  t494 = t39 * t50
  t496 = t253 * t175 * t308
  t501 = 0.1e1 / t204 / t102
  t502 = t203 * t501
  t506 = t202 * t207
  t507 = t209 * t50
  t508 = t148 * t175
  t509 = t507 * t508
  t512 = t233 * t207
  t513 = t121 * params.c
  t514 = t513 * t508
  t519 = t455 * t24 * t466
  t530 = -0.2e1 / 0.243e3 * t465 * t468 - 0.154e3 / 0.81e2 * t44 * t32 * t472 * t91 + 0.341e3 / 0.486e3 * t131 * t479 * t134 - 0.341e3 / 0.486e3 * t139 * t479 * t141 - 0.341e3 / 0.486e3 * t113 * t115 * t486 + 0.154e3 / 0.81e2 * t30 * t33 * t490 + t146 * t494 * t496 / 0.4e1 + 0.38e2 / 0.81e2 * t202 * t502 * t209 - 0.2e1 / 0.27e2 * t506 * t509 + 0.2e1 / 0.27e2 * t512 * t514 - 0.2e1 / 0.243e3 * t447 * t453 * t519 - 0.38e2 / 0.81e2 * t227 * t501 * t209 * t229 + 0.38e2 / 0.81e2 * t234 * t501 * t121 * t236
  t531 = t463 + t530
  t536 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t95 + t6 * t101 * t180 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t185 * t313 - 0.3e1 / 0.8e1 * t6 * t317 * t531)
  t553 = 0.1e1 / t19 / t204 / r0
  t554 = t31 * t553
  t559 = 0.1e1 / t20 / t117
  t576 = 0.1e1 / t204 / t116
  t586 = 0.1e1 / t19 / t449
  t587 = t586 * t61
  t596 = t53 * t56 * t586
  t631 = 0.1e1 / t344 / t273
  t636 = t342 * t75
  t646 = 0.1e1 / t344 / t285
  t657 = 0.51e2 * t165 * t587 * t347 + 0.320e3 / 0.9e1 * t165 * t587 * t170 * t358 - 0.2079e4 / 0.16e2 * t596 * t61 * t342 * t166 / t168 / t394 / t83 * t358 * t31 + 0.274e3 / 0.3e1 * t165 * t587 * t279 - 0.411e3 / 0.8e1 * t596 * t300 - 0.137e3 / 0.4e1 * t165 * t587 * t304 + 0.884e3 / 0.9e1 * t165 * t587 * t381 - 0.116e3 * t596 * t295 * t366 + 0.180e3 * t596 * t364 * t297 * t346 * t3 - 0.139e3 * t165 * t587 * t303 * t346 + 0.150e3 * t165 * t587 * t343 * t631 - 0.135e3 / 0.2e1 * t596 * t61 * t76 * t636 * t297 * t631 * t3 - 0.45e2 * t165 * t587 * t636 * t169 * t646 + 0.455e3 / 0.81e2 * t58 * t587 * t85 + 0.1037e4 / 0.36e2 * t165 * t587 * t171
  t665 = t587 * t63
  t717 = -0.153e3 * t596 * t355 - 0.153e3 * t165 * t587 * t359 + 0.153e3 / 0.2e1 * t596 * t367 + 0.274e3 / 0.27e2 * t58 * t665 * t275 - 0.137e3 / 0.9e1 * t58 * t665 * t287 + 0.272e3 / 0.81e2 * t58 * t665 * t412 - 0.68e2 / 0.3e1 * t58 * t665 * t416 + 0.357e3 / 0.8e1 * t596 * t400 - 0.189e3 / 0.4e1 * t596 * t61 * t77 * t636 * t396 * t346 * t63 * t32 + 0.84e2 * t596 * t397 * t358 * t63 * t32 + 0.1037e4 / 0.81e2 * t58 * t665 * t160 + 0.68e2 / 0.3e1 * t58 * t665 * t388 + 0.32e2 / 0.81e2 * t58 * t665 * t157 * t358 - 0.76e2 / 0.9e1 * t58 * t665 * t284 * t346 + 0.80e2 / 0.3e1 * t58 * t665 * t387 * t631 - 0.20e2 * t58 * t665 * t77 * t293 * t84 * t646
  t724 = t446 * params.alpha * t201
  t726 = t204 ** 2
  t730 = t448 * s0 / t19 / t726 / r0
  t732 = 0.1e1 / t454 / t37
  t742 = t112 * t31
  t751 = 0.3047e4 / 0.486e3 * t139 * t554 * t141 + 0.2618e4 / 0.243e3 * t44 * t32 * t559 * t91 - 0.3047e4 / 0.486e3 * t131 * t554 * t134 - 0.2618e4 / 0.243e3 * t30 * t33 * t559 * t38 + 0.3047e4 / 0.486e3 * t113 * t115 * t553 * t121 + 0.5126e4 / 0.729e3 * t227 * t576 * t209 * t229 - 0.5126e4 / 0.729e3 * t234 * t576 * t121 * t236 - t146 * t39 * t149 * (t657 + t717) / 0.24e2 + 0.16e2 / 0.2187e4 * t724 * t730 * t732 * t229 * t52 * t112 * t31 - 0.16e2 / 0.2187e4 * t447 * t730 * t455 * t53 * t742 * t90 + t245 * t246 * t247 * t423 / 0.27e2
  t769 = t448 / t20 / t204 / t117
  t794 = 0.4e1 / 0.9e1 * t146 * t105 * t424 + t241 * t195 * t309 / 0.2e1 - 0.2e1 / 0.9e1 * t241 * t122 * t432 + 0.2e1 / 0.9e1 * t245 * t246 * params.c * t429 * t431 - 0.196e3 / 0.729e3 * t447 * t769 * t455 * t460 - t245 * t318 * t442 / 0.2e1 + 0.196e3 / 0.729e3 * t202 * t769 * t209 * t468 - 0.22e2 / 0.9e1 * t146 * t188 * t309 - 0.682e3 / 0.243e3 * t241 * t486 * t176 + 0.682e3 / 0.243e3 * t245 * t478 * t38 * t248 + 0.8e1 / 0.3e1 * t146 * t105 * t432
  t799 = t255 ** 2
  t803 = t308 ** 2
  t839 = t146 * t39 * t50 / t428 / t89 * t799 + t146 * t39 * t254 * t803 / 0.4e1 - t241 * t122 * t424 / 0.27e2 + t245 * t318 * t326 - t241 * t195 * t256 + 0.616e3 / 0.81e2 * t146 * t490 * t176 + 0.44e2 / 0.9e1 * t146 * t188 * t256 + 0.2e1 / 0.9e1 * t241 * t122 * t50 * t496 - 0.2e1 / 0.9e1 * t245 * t246 * params.c * t496 + t146 * t494 * t253 * t423 * t175 / 0.3e1 - 0.3e1 / 0.2e1 * t146 * t494 * t429 * t255 * t308
  t859 = t253 * t255
  t877 = t148 * t308
  t884 = -0.8e1 / 0.3e1 * t146 * t105 * t50 * t496 - 0.8e1 / 0.243e3 * t457 * t176 * t459 + 0.8e1 / 0.243e3 * t465 * t47 * t32 * t148 * t175 - 0.5126e4 / 0.729e3 * t202 * t203 * t576 * t209 + 0.196e3 / 0.729e3 * t447 * t769 * t519 - 0.8e1 / 0.27e2 * t512 * t513 * t859 + 0.152e3 / 0.81e2 * t202 * t502 * t509 + 0.8e1 / 0.27e2 * t506 * t507 * t859 - 0.152e3 / 0.81e2 * t233 * t502 * t514 - 0.16e2 / 0.2187e4 * t724 * t730 * t732 * t52 * t742 - 0.4e1 / 0.27e2 * t506 * t507 * t877 + 0.4e1 / 0.27e2 * t512 * t513 * t877
  t891 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t104 * t95 - 0.5e1 / 0.9e1 * t6 * t23 * t180 + t6 * t101 * t313 / 0.2e1 - t6 * t185 * t531 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t317 * (t751 + t794 + t839 + t884))
  v4rho4_0_ = 0.2e1 * r0 * t891 + 0.8e1 * t536

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = params.alpha * t32
  t34 = jnp.pi ** 2
  t35 = t34 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t33 * t37
  t39 = r0 ** 2
  t40 = r0 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t43 = 0.1e1 / t41 / t39
  t45 = t37 * s0
  t46 = t45 * t43
  t49 = 0.1e1 + t33 * t46 / 0.24e2
  t50 = 0.1e1 / t49
  t54 = t33 * t45
  t55 = t43 * t50
  t56 = params.c * t32
  t59 = 0.1e1 + t56 * t46 / 0.24e2
  t60 = t32 ** 2
  t61 = params.c * t60
  t62 = 0.1e1 / t35
  t63 = jnp.sqrt(s0)
  t64 = t62 * t63
  t66 = 0.1e1 / t40 / r0
  t69 = 0.1e1 / jnp.pi
  t70 = t2 ** 2
  t71 = t69 * t70
  t72 = 2 ** (0.1e1 / 0.3e1)
  t73 = jnp.sqrt(0.12e2)
  t74 = t60 * t62
  t76 = t74 * t63 * t66
  t77 = jnp.sqrt(t76)
  t80 = jnp.sqrt(0.6e1)
  t83 = lambertw(t73 * t77 * t76 * t80 / 0.1728e4)
  t84 = t83 ** (0.1e1 / 0.3e1)
  t85 = t84 ** 2
  t87 = t72 ** 2
  t88 = t2 * t87
  t92 = 0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t88 * t84 * t83
  t93 = t92 ** (0.1e1 / 0.4e1)
  t95 = t71 * t72 * t85 * t93
  t98 = 0.1e1 + t61 * t64 * t66 * t95 / 0.8e1
  t99 = 0.1e1 / t98
  t100 = t59 * t99
  t104 = 0.1e1 - t38 * s0 * t43 * t50 / 0.24e2 + t54 * t55 * t100 / 0.24e2
  t108 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t109 = t108 * f.p.zeta_threshold
  t111 = f.my_piecewise3(t20, t109, t21 * t19)
  t112 = t30 ** 2
  t113 = 0.1e1 / t112
  t114 = t111 * t113
  t117 = t5 * t114 * t104 / 0.8e1
  t118 = t111 * t30
  t119 = t39 * r0
  t121 = 0.1e1 / t41 / t119
  t126 = params.alpha ** 2
  t127 = t126 * t60
  t129 = 0.1e1 / t35 / t34
  t130 = t127 * t129
  t131 = s0 ** 2
  t132 = t39 ** 2
  t135 = 0.1e1 / t40 / t132 / t39
  t137 = t49 ** 2
  t138 = 0.1e1 / t137
  t142 = t121 * t50
  t146 = t129 * t131
  t147 = t127 * t146
  t148 = t135 * t138
  t152 = params.alpha * t60
  t153 = t152 * t146
  t154 = t135 * t50
  t155 = params.c * t99
  t159 = t98 ** 2
  t160 = 0.1e1 / t159
  t161 = t59 * t160
  t163 = 0.1e1 / t40 / t39
  t165 = t61 * t64 * t163
  t168 = t71 * t72
  t169 = t85 * t93
  t170 = 0.1e1 + t83
  t171 = 0.1e1 / t170
  t173 = t168 * t169 * t171
  t176 = t61 * t64
  t178 = t83 ** 2
  t179 = t93 ** 2
  t180 = t179 * t93
  t181 = 0.1e1 / t180
  t182 = t178 * t181
  t183 = t182 * t171
  t187 = -t165 * t95 / 0.6e1 - t165 * t173 / 0.6e1 - 0.3e1 / 0.8e1 * t176 * t163 * t69 * t183
  t188 = t161 * t187
  t192 = t38 * s0 * t121 * t50 / 0.9e1 - t130 * t131 * t135 * t138 / 0.216e3 - t54 * t142 * t100 / 0.9e1 + t147 * t148 * t100 / 0.216e3 - t153 * t154 * t155 / 0.216e3 - t54 * t55 * t188 / 0.24e2
  t197 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t104 - t117 - 0.3e1 / 0.8e1 * t5 * t118 * t192)
  t199 = r1 <= f.p.dens_threshold
  t200 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t201 = 0.1e1 + t200
  t202 = t201 <= f.p.zeta_threshold
  t203 = t201 ** (0.1e1 / 0.3e1)
  t205 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t208 = f.my_piecewise3(t202, 0, 0.4e1 / 0.3e1 * t203 * t205)
  t209 = t208 * t30
  t210 = r1 ** 2
  t211 = r1 ** (0.1e1 / 0.3e1)
  t212 = t211 ** 2
  t214 = 0.1e1 / t212 / t210
  t216 = t37 * s2
  t217 = t216 * t214
  t220 = 0.1e1 + t33 * t217 / 0.24e2
  t221 = 0.1e1 / t220
  t225 = t33 * t216
  t226 = t214 * t221
  t229 = 0.1e1 + t56 * t217 / 0.24e2
  t230 = jnp.sqrt(s2)
  t231 = t62 * t230
  t233 = 0.1e1 / t211 / r1
  t237 = t74 * t230 * t233
  t238 = jnp.sqrt(t237)
  t243 = lambertw(t73 * t238 * t237 * t80 / 0.1728e4)
  t244 = t243 ** (0.1e1 / 0.3e1)
  t245 = t244 ** 2
  t250 = 0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t88 * t244 * t243
  t251 = t250 ** (0.1e1 / 0.4e1)
  t253 = t71 * t72 * t245 * t251
  t256 = 0.1e1 + t61 * t231 * t233 * t253 / 0.8e1
  t257 = 0.1e1 / t256
  t258 = t229 * t257
  t262 = 0.1e1 - t38 * s2 * t214 * t221 / 0.24e2 + t225 * t226 * t258 / 0.24e2
  t267 = f.my_piecewise3(t202, t109, t203 * t201)
  t268 = t267 * t113
  t271 = t5 * t268 * t262 / 0.8e1
  t273 = f.my_piecewise3(t199, 0, -0.3e1 / 0.8e1 * t5 * t209 * t262 - t271)
  t275 = t21 ** 2
  t276 = 0.1e1 / t275
  t277 = t26 ** 2
  t282 = t16 / t22 / t6
  t284 = -0.2e1 * t23 + 0.2e1 * t282
  t285 = f.my_piecewise5(t10, 0, t14, 0, t284)
  t289 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t276 * t277 + 0.4e1 / 0.3e1 * t21 * t285)
  t296 = t5 * t29 * t113 * t104
  t302 = 0.1e1 / t112 / t6
  t306 = t5 * t111 * t302 * t104 / 0.12e2
  t308 = t5 * t114 * t192
  t311 = 0.1e1 / t41 / t132
  t318 = 0.1e1 / t40 / t132 / t119
  t324 = t34 ** 2
  t325 = 0.1e1 / t324
  t326 = t126 * params.alpha * t325
  t327 = t131 * s0
  t328 = t132 ** 2
  t330 = 0.1e1 / t328 / t39
  t333 = 0.1e1 / t137 / t49
  t357 = t126 * t325
  t374 = t187 ** 2
  t380 = 0.1e1 / t40 / t119
  t382 = t61 * t64 * t380
  t387 = t380 * t69
  t391 = t170 ** 2
  t392 = 0.1e1 / t391
  t404 = 0.1e1 / t391 / t170
  t409 = t178 * t83
  t430 = -0.11e2 / 0.27e2 * t38 * s0 * t311 * t50 + t130 * t131 * t318 * t138 / 0.24e2 - t326 * t327 * t330 * t333 / 0.162e3 + 0.11e2 / 0.27e2 * t54 * t311 * t50 * t100 - t147 * t318 * t138 * t100 / 0.24e2 + t153 * t318 * t50 * t155 / 0.24e2 + 0.2e1 / 0.9e1 * t54 * t142 * t188 + t326 * t327 * t330 * t333 * t100 / 0.162e3 - t357 * t327 * t330 * t138 * t155 / 0.162e3 - t147 * t148 * t188 / 0.108e3 + t153 * t154 * params.c * t160 * t187 / 0.108e3 + t54 * t55 * t59 / t159 / t98 * t374 / 0.12e2 - t54 * t55 * t161 * (0.7e1 / 0.18e2 * t382 * t95 + 0.11e2 / 0.18e2 * t382 * t173 + 0.11e2 / 0.8e1 * t176 * t387 * t183 + 0.2e1 / 0.9e1 * t382 * t168 * t169 * t392 + 0.2e1 * t176 * t387 * t182 * t392 - t382 * t168 * t85 * t83 * t93 * t404 / 0.3e1 - 0.9e1 / 0.16e2 * t382 * t69 * t84 * t409 / t180 / t92 * t392 * t2 * t87 - 0.3e1 / 0.4e1 * t176 * t387 * t409 * t181 * t404) / 0.24e2
  t435 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t289 * t30 * t104 - t296 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t192 + t306 - t308 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t118 * t430)
  t436 = t203 ** 2
  t437 = 0.1e1 / t436
  t438 = t205 ** 2
  t442 = f.my_piecewise5(t14, 0, t10, 0, -t284)
  t446 = f.my_piecewise3(t202, 0, 0.4e1 / 0.9e1 * t437 * t438 + 0.4e1 / 0.3e1 * t203 * t442)
  t453 = t5 * t208 * t113 * t262
  t458 = t5 * t267 * t302 * t262 / 0.12e2
  t460 = f.my_piecewise3(t199, 0, -0.3e1 / 0.8e1 * t5 * t446 * t30 * t262 - t453 / 0.4e1 + t458)
  d11 = 0.2e1 * t197 + 0.2e1 * t273 + t6 * (t435 + t460)
  t463 = -t7 - t24
  t464 = f.my_piecewise5(t10, 0, t14, 0, t463)
  t467 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t464)
  t468 = t467 * t30
  t473 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t468 * t104 - t117)
  t475 = f.my_piecewise5(t14, 0, t10, 0, -t463)
  t478 = f.my_piecewise3(t202, 0, 0.4e1 / 0.3e1 * t203 * t475)
  t479 = t478 * t30
  t483 = t267 * t30
  t484 = t210 * r1
  t486 = 0.1e1 / t212 / t484
  t491 = s2 ** 2
  t492 = t210 ** 2
  t495 = 0.1e1 / t211 / t492 / t210
  t497 = t220 ** 2
  t498 = 0.1e1 / t497
  t502 = t486 * t221
  t506 = t129 * t491
  t507 = t127 * t506
  t508 = t495 * t498
  t512 = t152 * t506
  t513 = t495 * t221
  t514 = params.c * t257
  t518 = t256 ** 2
  t519 = 0.1e1 / t518
  t520 = t229 * t519
  t522 = 0.1e1 / t211 / t210
  t524 = t61 * t231 * t522
  t527 = t245 * t251
  t528 = 0.1e1 + t243
  t529 = 0.1e1 / t528
  t531 = t168 * t527 * t529
  t534 = t61 * t231
  t536 = t243 ** 2
  t537 = t251 ** 2
  t538 = t537 * t251
  t539 = 0.1e1 / t538
  t540 = t536 * t539
  t541 = t540 * t529
  t545 = -t524 * t253 / 0.6e1 - t524 * t531 / 0.6e1 - 0.3e1 / 0.8e1 * t534 * t522 * t69 * t541
  t546 = t520 * t545
  t550 = t38 * s2 * t486 * t221 / 0.9e1 - t130 * t491 * t495 * t498 / 0.216e3 - t225 * t502 * t258 / 0.9e1 + t507 * t508 * t258 / 0.216e3 - t512 * t513 * t514 / 0.216e3 - t225 * t226 * t546 / 0.24e2
  t555 = f.my_piecewise3(t199, 0, -0.3e1 / 0.8e1 * t5 * t479 * t262 - t271 - 0.3e1 / 0.8e1 * t5 * t483 * t550)
  t559 = 0.2e1 * t282
  t560 = f.my_piecewise5(t10, 0, t14, 0, t559)
  t564 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t276 * t464 * t26 + 0.4e1 / 0.3e1 * t21 * t560)
  t571 = t5 * t467 * t113 * t104
  t579 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t564 * t30 * t104 - t571 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t468 * t192 - t296 / 0.8e1 + t306 - t308 / 0.8e1)
  t583 = f.my_piecewise5(t14, 0, t10, 0, -t559)
  t587 = f.my_piecewise3(t202, 0, 0.4e1 / 0.9e1 * t437 * t475 * t205 + 0.4e1 / 0.3e1 * t203 * t583)
  t594 = t5 * t478 * t113 * t262
  t601 = t5 * t268 * t550
  t604 = f.my_piecewise3(t199, 0, -0.3e1 / 0.8e1 * t5 * t587 * t30 * t262 - t594 / 0.8e1 - t453 / 0.8e1 + t458 - 0.3e1 / 0.8e1 * t5 * t209 * t550 - t601 / 0.8e1)
  d12 = t197 + t273 + t473 + t555 + t6 * (t579 + t604)
  t609 = t464 ** 2
  t613 = 0.2e1 * t23 + 0.2e1 * t282
  t614 = f.my_piecewise5(t10, 0, t14, 0, t613)
  t618 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t276 * t609 + 0.4e1 / 0.3e1 * t21 * t614)
  t625 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t618 * t30 * t104 - t571 / 0.4e1 + t306)
  t626 = t475 ** 2
  t630 = f.my_piecewise5(t14, 0, t10, 0, -t613)
  t634 = f.my_piecewise3(t202, 0, 0.4e1 / 0.9e1 * t437 * t626 + 0.4e1 / 0.3e1 * t203 * t630)
  t645 = 0.1e1 / t212 / t492
  t652 = 0.1e1 / t211 / t492 / t484
  t657 = t491 * s2
  t658 = t492 ** 2
  t660 = 0.1e1 / t658 / t210
  t663 = 0.1e1 / t497 / t220
  t703 = t545 ** 2
  t709 = 0.1e1 / t211 / t484
  t711 = t61 * t231 * t709
  t716 = t709 * t69
  t720 = t528 ** 2
  t721 = 0.1e1 / t720
  t733 = 0.1e1 / t720 / t528
  t738 = t536 * t243
  t759 = -0.11e2 / 0.27e2 * t38 * s2 * t645 * t221 + t130 * t491 * t652 * t498 / 0.24e2 - t326 * t657 * t660 * t663 / 0.162e3 + 0.11e2 / 0.27e2 * t225 * t645 * t221 * t258 - t507 * t652 * t498 * t258 / 0.24e2 + t512 * t652 * t221 * t514 / 0.24e2 + 0.2e1 / 0.9e1 * t225 * t502 * t546 + t326 * t657 * t660 * t663 * t258 / 0.162e3 - t357 * t657 * t660 * t498 * t514 / 0.162e3 - t507 * t508 * t546 / 0.108e3 + t512 * t513 * params.c * t519 * t545 / 0.108e3 + t225 * t226 * t229 / t518 / t256 * t703 / 0.12e2 - t225 * t226 * t520 * (0.7e1 / 0.18e2 * t711 * t253 + 0.11e2 / 0.18e2 * t711 * t531 + 0.11e2 / 0.8e1 * t534 * t716 * t541 + 0.2e1 / 0.9e1 * t711 * t168 * t527 * t721 + 0.2e1 * t534 * t716 * t540 * t721 - t711 * t168 * t245 * t243 * t251 * t733 / 0.3e1 - 0.9e1 / 0.16e2 * t711 * t69 * t244 * t738 / t538 / t250 * t721 * t2 * t87 - 0.3e1 / 0.4e1 * t534 * t716 * t738 * t539 * t733) / 0.24e2
  t764 = f.my_piecewise3(t199, 0, -0.3e1 / 0.8e1 * t5 * t634 * t30 * t262 - t594 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t479 * t550 + t458 - t601 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t483 * t759)
  d22 = 0.2e1 * t473 + 0.2e1 * t555 + t6 * (t625 + t764)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = params.alpha * t44
  t46 = jnp.pi ** 2
  t47 = t46 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t50 = t45 * t49
  t51 = r0 ** 2
  t52 = r0 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / t51
  t57 = t49 * s0
  t58 = t57 * t55
  t59 = t45 * t58
  t61 = 0.1e1 + t59 / 0.24e2
  t62 = 0.1e1 / t61
  t66 = t45 * t57
  t67 = t55 * t62
  t68 = params.c * t44
  t71 = 0.1e1 + t68 * t58 / 0.24e2
  t72 = t44 ** 2
  t73 = params.c * t72
  t74 = 0.1e1 / t47
  t75 = jnp.sqrt(s0)
  t76 = t74 * t75
  t78 = 0.1e1 / t52 / r0
  t81 = 0.1e1 / jnp.pi
  t82 = t2 ** 2
  t83 = t81 * t82
  t84 = 2 ** (0.1e1 / 0.3e1)
  t85 = jnp.sqrt(0.12e2)
  t86 = t72 * t74
  t88 = t86 * t75 * t78
  t89 = jnp.sqrt(t88)
  t92 = jnp.sqrt(0.6e1)
  t95 = scipy.special.lambertw(t85 * t89 * t88 * t92 / 0.1728e4)
  t96 = t95 ** (0.1e1 / 0.3e1)
  t97 = t96 ** 2
  t99 = t84 ** 2
  t100 = t2 * t99
  t104 = 0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t100 * t96 * t95
  t105 = t104 ** (0.1e1 / 0.4e1)
  t107 = t83 * t84 * t97 * t105
  t110 = 0.1e1 + t73 * t76 * t78 * t107 / 0.8e1
  t111 = 0.1e1 / t110
  t112 = t71 * t111
  t116 = 0.1e1 - t50 * s0 * t55 * t62 / 0.24e2 + t66 * t67 * t112 / 0.24e2
  t122 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t123 = t42 ** 2
  t124 = 0.1e1 / t123
  t125 = t122 * t124
  t129 = t122 * t42
  t130 = t51 * r0
  t132 = 0.1e1 / t53 / t130
  t137 = params.alpha ** 2
  t138 = t137 * t72
  t140 = 0.1e1 / t47 / t46
  t141 = t138 * t140
  t142 = s0 ** 2
  t143 = t51 ** 2
  t146 = 0.1e1 / t52 / t143 / t51
  t148 = t61 ** 2
  t149 = 0.1e1 / t148
  t153 = t132 * t62
  t157 = t140 * t142
  t158 = t138 * t157
  t159 = t146 * t149
  t164 = params.alpha * t72 * t157
  t165 = t146 * t62
  t166 = params.c * t111
  t170 = t110 ** 2
  t171 = 0.1e1 / t170
  t172 = t71 * t171
  t174 = 0.1e1 / t52 / t51
  t176 = t73 * t76 * t174
  t179 = t83 * t84
  t180 = t97 * t105
  t181 = 0.1e1 + t95
  t182 = 0.1e1 / t181
  t184 = t179 * t180 * t182
  t187 = t73 * t76
  t189 = t95 ** 2
  t190 = t105 ** 2
  t191 = t190 * t105
  t192 = 0.1e1 / t191
  t193 = t189 * t192
  t194 = t193 * t182
  t198 = -t176 * t107 / 0.6e1 - t176 * t184 / 0.6e1 - 0.3e1 / 0.8e1 * t187 * t174 * t81 * t194
  t199 = t172 * t198
  t203 = t50 * s0 * t132 * t62 / 0.9e1 - t141 * t142 * t146 * t149 / 0.216e3 - t66 * t153 * t112 / 0.9e1 + t158 * t159 * t112 / 0.216e3 - t164 * t165 * t166 / 0.216e3 - t66 * t67 * t199 / 0.24e2
  t207 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t208 = t207 * f.p.zeta_threshold
  t210 = f.my_piecewise3(t20, t208, t21 * t19)
  t212 = 0.1e1 / t123 / t6
  t213 = t210 * t212
  t217 = t210 * t124
  t221 = t210 * t42
  t223 = 0.1e1 / t53 / t143
  t230 = 0.1e1 / t52 / t143 / t130
  t236 = t46 ** 2
  t237 = 0.1e1 / t236
  t238 = t137 * params.alpha * t237
  t239 = t142 * s0
  t240 = t143 ** 2
  t242 = 0.1e1 / t240 / t51
  t243 = t239 * t242
  t245 = 0.1e1 / t148 / t61
  t249 = t223 * t62
  t253 = t230 * t149
  t257 = t230 * t62
  t264 = t238 * t239
  t269 = t137 * t237
  t270 = t269 * t239
  t278 = params.c * t171
  t279 = t278 * t198
  t284 = 0.1e1 / t170 / t110
  t286 = t198 ** 2
  t287 = t71 * t284 * t286
  t292 = 0.1e1 / t52 / t130
  t294 = t73 * t76 * t292
  t299 = t292 * t81
  t303 = t181 ** 2
  t304 = 0.1e1 / t303
  t306 = t179 * t180 * t304
  t309 = t193 * t304
  t314 = t97 * t95 * t105
  t316 = 0.1e1 / t303 / t181
  t318 = t179 * t314 * t316
  t321 = t189 * t95
  t325 = 0.1e1 / t191 / t104
  t326 = t81 * t96 * t321 * t325
  t329 = t326 * t304 * t2 * t99
  t332 = t321 * t192
  t333 = t332 * t316
  t337 = 0.7e1 / 0.18e2 * t294 * t107 + 0.11e2 / 0.18e2 * t294 * t184 + 0.11e2 / 0.8e1 * t187 * t299 * t194 + 0.2e1 / 0.9e1 * t294 * t306 + 0.2e1 * t187 * t299 * t309 - t294 * t318 / 0.3e1 - 0.9e1 / 0.16e2 * t294 * t329 - 0.3e1 / 0.4e1 * t187 * t299 * t333
  t338 = t172 * t337
  t342 = -0.11e2 / 0.27e2 * t50 * s0 * t223 * t62 + t141 * t142 * t230 * t149 / 0.24e2 - t238 * t243 * t245 / 0.162e3 + 0.11e2 / 0.27e2 * t66 * t249 * t112 - t158 * t253 * t112 / 0.24e2 + t164 * t257 * t166 / 0.24e2 + 0.2e1 / 0.9e1 * t66 * t153 * t199 + t264 * t242 * t245 * t112 / 0.162e3 - t270 * t242 * t149 * t166 / 0.162e3 - t158 * t159 * t199 / 0.108e3 + t164 * t165 * t279 / 0.108e3 + t66 * t67 * t287 / 0.12e2 - t66 * t67 * t338 / 0.24e2
  t347 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t116 - t5 * t125 * t116 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t129 * t203 + t5 * t213 * t116 / 0.12e2 - t5 * t217 * t203 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t221 * t342)
  t349 = r1 <= f.p.dens_threshold
  t350 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t351 = 0.1e1 + t350
  t352 = t351 <= f.p.zeta_threshold
  t353 = t351 ** (0.1e1 / 0.3e1)
  t354 = t353 ** 2
  t355 = 0.1e1 / t354
  t357 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t358 = t357 ** 2
  t362 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t366 = f.my_piecewise3(t352, 0, 0.4e1 / 0.9e1 * t355 * t358 + 0.4e1 / 0.3e1 * t353 * t362)
  t368 = r1 ** 2
  t369 = r1 ** (0.1e1 / 0.3e1)
  t370 = t369 ** 2
  t372 = 0.1e1 / t370 / t368
  t374 = t49 * s2
  t375 = t374 * t372
  t379 = 0.1e1 / (0.1e1 + t45 * t375 / 0.24e2)
  t388 = jnp.sqrt(s2)
  t391 = 0.1e1 / t369 / r1
  t395 = t86 * t388 * t391
  t396 = jnp.sqrt(t395)
  t401 = scipy.special.lambertw(t85 * t396 * t395 * t92 / 0.1728e4)
  t402 = t401 ** (0.1e1 / 0.3e1)
  t403 = t402 ** 2
  t409 = (0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t100 * t402 * t401) ** (0.1e1 / 0.4e1)
  t420 = 0.1e1 - t50 * s2 * t372 * t379 / 0.24e2 + t45 * t374 * t372 * t379 * (0.1e1 + t68 * t375 / 0.24e2) / (0.1e1 + t73 * t74 * t388 * t391 * t83 * t84 * t403 * t409 / 0.8e1) / 0.24e2
  t426 = f.my_piecewise3(t352, 0, 0.4e1 / 0.3e1 * t353 * t357)
  t432 = f.my_piecewise3(t352, t208, t353 * t351)
  t438 = f.my_piecewise3(t349, 0, -0.3e1 / 0.8e1 * t5 * t366 * t42 * t420 - t5 * t426 * t124 * t420 / 0.4e1 + t5 * t432 * t212 * t420 / 0.12e2)
  t448 = t24 ** 2
  t452 = 0.6e1 * t33 - 0.6e1 * t16 / t448
  t453 = f.my_piecewise5(t10, 0, t14, 0, t452)
  t457 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t453)
  t480 = 0.1e1 / t123 / t24
  t492 = 0.1e1 / t240 / t130
  t499 = t171 * t198
  t509 = 0.1e1 / t52 / t240
  t518 = t143 * r0
  t520 = 0.1e1 / t53 / t518
  t548 = t170 ** 2
  t556 = 0.19e2 / 0.162e3 * t238 * t239 * t492 * t245 - t238 * t243 * t245 * t71 * t499 / 0.54e2 + t269 * t243 * t149 * params.c * t499 / 0.54e2 + 0.341e3 / 0.972e3 * t158 * t509 * t149 * t112 - 0.341e3 / 0.972e3 * t164 * t509 * t62 * t166 - 0.154e3 / 0.81e2 * t66 * t520 * t62 * t112 + t59 * t62 * t71 * t284 * t198 * t337 / 0.4e1 + 0.154e3 / 0.81e2 * t50 * s0 * t520 * t62 - 0.341e3 / 0.972e3 * t141 * t142 * t509 * t149 + t164 * t165 * t278 * t337 / 0.72e2 - t164 * t165 * params.c * t284 * t286 / 0.36e2 - t66 * t67 * t71 / t548 * t286 * t198 / 0.4e1
  t576 = 0.1e1 / t52 / t143
  t577 = t576 * t81
  t585 = t303 ** 2
  t586 = 0.1e1 / t585
  t591 = t189 ** 2
  t594 = 0.1e1 / t585 / t181
  t606 = t73 * t76 * t576
  t615 = t104 ** 2
  t655 = 0.21e2 / 0.4e1 * t187 * t577 * t333 - 0.26e2 / 0.3e1 * t187 * t577 * t193 * t316 + 0.27e2 / 0.2e1 * t187 * t577 * t332 * t586 - 0.9e1 / 0.2e1 * t187 * t577 * t591 * t192 * t594 - 0.23e2 / 0.4e1 * t187 * t577 * t194 - 0.14e2 * t187 * t577 * t309 - 0.2e1 * t606 * t179 * t97 * t189 * t105 * t594 - 0.63e2 / 0.16e2 * t606 * t81 * t97 * t591 / t191 / t615 * t316 * t82 * t84 - 0.27e2 / 0.8e1 * t606 * t81 * t96 * t591 * t325 * t586 * t2 * t99 + 0.63e2 / 0.16e2 * t606 * t329 - 0.8e1 / 0.27e2 * t606 * t179 * t180 * t316 + 0.2e1 * t606 * t179 * t314 * t586 + 0.27e2 / 0.4e1 * t606 * t326 * t316 * t2 * t99 - 0.35e2 / 0.27e2 * t606 * t107 - 0.23e2 / 0.9e1 * t606 * t184 - 0.14e2 / 0.9e1 * t606 * t306 + 0.7e1 / 0.3e1 * t606 * t318
  t660 = t137 ** 2
  t661 = t660 * t237
  t662 = t142 ** 2
  t665 = 0.1e1 / t53 / t240 / t518
  t666 = t662 * t665
  t668 = t148 ** 2
  t669 = 0.1e1 / t668
  t672 = t111 * t44 * t49
  t698 = t158 * t159 * t287 / 0.36e2 - 0.2e1 / 0.3e1 * t66 * t153 * t287 - 0.11e2 / 0.9e1 * t66 * t249 * t199 + t158 * t253 * t199 / 0.8e1 - t164 * t257 * t279 / 0.8e1 + t66 * t153 * t338 / 0.3e1 - t66 * t67 * t172 * t655 / 0.24e2 + t661 * t666 * t669 * t71 * t672 / 0.486e3 - t238 * t666 * t245 * params.c * t672 / 0.486e3 - t158 * t159 * t338 / 0.72e2 - t661 * t662 * t665 * t669 * t44 * t49 / 0.486e3 - 0.19e2 / 0.162e3 * t264 * t492 * t245 * t112 + 0.19e2 / 0.162e3 * t270 * t492 * t149 * t166
  t704 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t457 * t42 * t116 - 0.3e1 / 0.8e1 * t5 * t41 * t124 * t116 - 0.9e1 / 0.8e1 * t5 * t43 * t203 + t5 * t122 * t212 * t116 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t125 * t203 - 0.9e1 / 0.8e1 * t5 * t129 * t342 - 0.5e1 / 0.36e2 * t5 * t210 * t480 * t116 + t5 * t213 * t203 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t217 * t342 - 0.3e1 / 0.8e1 * t5 * t221 * (t556 + t698))
  t714 = f.my_piecewise5(t14, 0, t10, 0, -t452)
  t718 = f.my_piecewise3(t352, 0, -0.8e1 / 0.27e2 / t354 / t351 * t358 * t357 + 0.4e1 / 0.3e1 * t355 * t357 * t362 + 0.4e1 / 0.3e1 * t353 * t714)
  t736 = f.my_piecewise3(t349, 0, -0.3e1 / 0.8e1 * t5 * t718 * t42 * t420 - 0.3e1 / 0.8e1 * t5 * t366 * t124 * t420 + t5 * t426 * t212 * t420 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t432 * t480 * t420)
  d111 = 0.3e1 * t347 + 0.3e1 * t438 + t6 * (t704 + t736)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = params.alpha * t56
  t58 = jnp.pi ** 2
  t59 = t58 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t61 = 0.1e1 / t60
  t62 = t57 * t61
  t63 = r0 ** 2
  t64 = r0 ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t67 = 0.1e1 / t65 / t63
  t69 = t61 * s0
  t70 = t69 * t67
  t71 = t57 * t70
  t73 = 0.1e1 + t71 / 0.24e2
  t74 = 0.1e1 / t73
  t78 = t57 * t69
  t79 = t67 * t74
  t80 = params.c * t56
  t83 = 0.1e1 + t80 * t70 / 0.24e2
  t84 = t56 ** 2
  t85 = params.c * t84
  t86 = 0.1e1 / t59
  t87 = jnp.sqrt(s0)
  t88 = t86 * t87
  t90 = 0.1e1 / t64 / r0
  t93 = 0.1e1 / jnp.pi
  t94 = t2 ** 2
  t95 = t93 * t94
  t96 = 2 ** (0.1e1 / 0.3e1)
  t97 = jnp.sqrt(0.12e2)
  t98 = t84 * t86
  t100 = t98 * t87 * t90
  t101 = jnp.sqrt(t100)
  t104 = jnp.sqrt(0.6e1)
  t107 = scipy.special.lambertw(t97 * t101 * t100 * t104 / 0.1728e4)
  t108 = t107 ** (0.1e1 / 0.3e1)
  t109 = t108 ** 2
  t111 = t96 ** 2
  t112 = t2 * t111
  t116 = 0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t112 * t108 * t107
  t117 = t116 ** (0.1e1 / 0.4e1)
  t119 = t95 * t96 * t109 * t117
  t122 = 0.1e1 + t85 * t88 * t90 * t119 / 0.8e1
  t123 = 0.1e1 / t122
  t124 = t83 * t123
  t128 = 0.1e1 - t62 * s0 * t67 * t74 / 0.24e2 + t78 * t79 * t124 / 0.24e2
  t137 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t138 = t54 ** 2
  t139 = 0.1e1 / t138
  t140 = t137 * t139
  t144 = t137 * t54
  t145 = t63 * r0
  t147 = 0.1e1 / t65 / t145
  t152 = params.alpha ** 2
  t153 = t152 * t84
  t155 = 0.1e1 / t59 / t58
  t156 = t153 * t155
  t157 = s0 ** 2
  t158 = t63 ** 2
  t159 = t158 * t63
  t161 = 0.1e1 / t64 / t159
  t163 = t73 ** 2
  t164 = 0.1e1 / t163
  t168 = t147 * t74
  t172 = t155 * t157
  t173 = t153 * t172
  t174 = t161 * t164
  t178 = params.alpha * t84
  t179 = t178 * t172
  t180 = t161 * t74
  t181 = params.c * t123
  t185 = t122 ** 2
  t186 = 0.1e1 / t185
  t187 = t83 * t186
  t189 = 0.1e1 / t64 / t63
  t191 = t85 * t88 * t189
  t194 = t95 * t96
  t195 = t109 * t117
  t196 = 0.1e1 + t107
  t197 = 0.1e1 / t196
  t199 = t194 * t195 * t197
  t202 = t85 * t88
  t204 = t107 ** 2
  t205 = t117 ** 2
  t206 = t205 * t117
  t207 = 0.1e1 / t206
  t208 = t204 * t207
  t209 = t208 * t197
  t213 = -t191 * t119 / 0.6e1 - t191 * t199 / 0.6e1 - 0.3e1 / 0.8e1 * t202 * t189 * t93 * t209
  t214 = t187 * t213
  t218 = t62 * s0 * t147 * t74 / 0.9e1 - t156 * t157 * t161 * t164 / 0.216e3 - t78 * t168 * t124 / 0.9e1 + t173 * t174 * t124 / 0.216e3 - t179 * t180 * t181 / 0.216e3 - t78 * t79 * t214 / 0.24e2
  t224 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t226 = 0.1e1 / t138 / t6
  t227 = t224 * t226
  t231 = t224 * t139
  t235 = t224 * t54
  t237 = 0.1e1 / t65 / t158
  t244 = 0.1e1 / t64 / t158 / t145
  t250 = t58 ** 2
  t251 = 0.1e1 / t250
  t252 = t152 * params.alpha * t251
  t253 = t157 * s0
  t254 = t158 ** 2
  t256 = 0.1e1 / t254 / t63
  t257 = t253 * t256
  t259 = 0.1e1 / t163 / t73
  t263 = t237 * t74
  t267 = t244 * t164
  t271 = t244 * t74
  t278 = t252 * t253
  t283 = t152 * t251
  t284 = t283 * t253
  t292 = params.c * t186
  t293 = t292 * t213
  t298 = 0.1e1 / t185 / t122
  t299 = t83 * t298
  t300 = t213 ** 2
  t301 = t299 * t300
  t306 = 0.1e1 / t64 / t145
  t308 = t85 * t88 * t306
  t313 = t306 * t93
  t317 = t196 ** 2
  t318 = 0.1e1 / t317
  t320 = t194 * t195 * t318
  t323 = t208 * t318
  t328 = t109 * t107 * t117
  t329 = t317 * t196
  t330 = 0.1e1 / t329
  t332 = t194 * t328 * t330
  t335 = t204 * t107
  t339 = 0.1e1 / t206 / t116
  t340 = t93 * t108 * t335 * t339
  t343 = t340 * t318 * t2 * t111
  t346 = t335 * t207
  t347 = t346 * t330
  t351 = 0.7e1 / 0.18e2 * t308 * t119 + 0.11e2 / 0.18e2 * t308 * t199 + 0.11e2 / 0.8e1 * t202 * t313 * t209 + 0.2e1 / 0.9e1 * t308 * t320 + 0.2e1 * t202 * t313 * t323 - t308 * t332 / 0.3e1 - 0.9e1 / 0.16e2 * t308 * t343 - 0.3e1 / 0.4e1 * t202 * t313 * t347
  t352 = t187 * t351
  t356 = -0.11e2 / 0.27e2 * t62 * s0 * t237 * t74 + t156 * t157 * t244 * t164 / 0.24e2 - t252 * t257 * t259 / 0.162e3 + 0.11e2 / 0.27e2 * t78 * t263 * t124 - t173 * t267 * t124 / 0.24e2 + t179 * t271 * t181 / 0.24e2 + 0.2e1 / 0.9e1 * t78 * t168 * t214 + t278 * t256 * t259 * t124 / 0.162e3 - t284 * t256 * t164 * t181 / 0.162e3 - t173 * t174 * t214 / 0.108e3 + t179 * t180 * t293 / 0.108e3 + t78 * t79 * t301 / 0.12e2 - t78 * t79 * t352 / 0.24e2
  t360 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t361 = t360 * f.p.zeta_threshold
  t363 = f.my_piecewise3(t20, t361, t21 * t19)
  t365 = 0.1e1 / t138 / t25
  t366 = t363 * t365
  t370 = t363 * t226
  t374 = t363 * t139
  t378 = t363 * t54
  t380 = 0.1e1 / t64 / t254
  t381 = t380 * t164
  t385 = t252 * t257
  t386 = t259 * t83
  t387 = t186 * t213
  t388 = t386 * t387
  t391 = t283 * t257
  t392 = t164 * params.c
  t393 = t392 * t387
  t396 = t380 * t74
  t400 = t158 * r0
  t402 = 0.1e1 / t65 / t400
  t403 = t402 * t74
  t408 = 0.1e1 / t254 / t145
  t409 = t253 * t408
  t421 = t152 ** 2
  t422 = t421 * t251
  t423 = t157 ** 2
  t424 = t422 * t423
  t427 = 0.1e1 / t65 / t254 / t400
  t428 = t163 ** 2
  t429 = 0.1e1 / t428
  t431 = t56 * t61
  t446 = 0.341e3 / 0.972e3 * t173 * t381 * t124 - t385 * t388 / 0.54e2 + t391 * t393 / 0.54e2 - 0.341e3 / 0.972e3 * t179 * t396 * t181 - 0.154e3 / 0.81e2 * t78 * t403 * t124 + 0.19e2 / 0.162e3 * t252 * t409 * t259 - 0.19e2 / 0.162e3 * t278 * t408 * t259 * t124 + 0.19e2 / 0.162e3 * t284 * t408 * t164 * t181 - t424 * t427 * t429 * t431 / 0.486e3 + 0.154e3 / 0.81e2 * t62 * s0 * t402 * t74 - 0.341e3 / 0.972e3 * t156 * t157 * t380 * t164 - 0.11e2 / 0.9e1 * t78 * t263 * t214
  t456 = t423 * t427
  t460 = t123 * t56 * t61
  t461 = t429 * t83 * t460
  t466 = t259 * params.c * t460
  t473 = 0.1e1 / t64 / t158
  t474 = t473 * t93
  t478 = t208 * t330
  t482 = t317 ** 2
  t483 = 0.1e1 / t482
  t484 = t346 * t483
  t488 = t204 ** 2
  t489 = t488 * t207
  t491 = 0.1e1 / t482 / t196
  t492 = t489 * t491
  t503 = t85 * t88 * t473
  t505 = t109 * t204 * t117
  t507 = t194 * t505 * t491
  t512 = t116 ** 2
  t514 = 0.1e1 / t206 / t512
  t515 = t93 * t109 * t488 * t514
  t518 = t515 * t330 * t94 * t96
  t523 = t93 * t108 * t488 * t339
  t525 = t483 * t2 * t111
  t526 = t523 * t525
  t532 = t194 * t195 * t330
  t536 = t194 * t328 * t483
  t541 = t340 * t330 * t2 * t111
  t552 = 0.21e2 / 0.4e1 * t202 * t474 * t347 - 0.26e2 / 0.3e1 * t202 * t474 * t478 + 0.27e2 / 0.2e1 * t202 * t474 * t484 - 0.9e1 / 0.2e1 * t202 * t474 * t492 - 0.23e2 / 0.4e1 * t202 * t474 * t209 - 0.14e2 * t202 * t474 * t323 - 0.2e1 * t503 * t507 - 0.63e2 / 0.16e2 * t503 * t518 - 0.27e2 / 0.8e1 * t503 * t526 + 0.63e2 / 0.16e2 * t503 * t343 - 0.8e1 / 0.27e2 * t503 * t532 + 0.2e1 * t503 * t536 + 0.27e2 / 0.4e1 * t503 * t541 - 0.35e2 / 0.27e2 * t503 * t119 - 0.23e2 / 0.9e1 * t503 * t199 - 0.14e2 / 0.9e1 * t503 * t320 + 0.7e1 / 0.3e1 * t503 * t332
  t553 = t187 * t552
  t557 = t292 * t351
  t562 = params.c * t298 * t300
  t566 = t185 ** 2
  t567 = 0.1e1 / t566
  t569 = t300 * t213
  t570 = t83 * t567 * t569
  t580 = t74 * t83
  t581 = t298 * t213
  t582 = t581 * t351
  t583 = t580 * t582
  t586 = t173 * t267 * t214 / 0.8e1 - t179 * t271 * t293 / 0.8e1 + t78 * t168 * t352 / 0.3e1 + t422 * t456 * t461 / 0.486e3 - t252 * t456 * t466 / 0.486e3 - t173 * t174 * t352 / 0.72e2 - t78 * t79 * t553 / 0.24e2 + t179 * t180 * t557 / 0.72e2 - t179 * t180 * t562 / 0.36e2 - t78 * t79 * t570 / 0.4e1 + t173 * t174 * t301 / 0.36e2 - 0.2e1 / 0.3e1 * t78 * t168 * t301 + t71 * t583 / 0.4e1
  t587 = t446 + t586
  t592 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t128 - 0.3e1 / 0.8e1 * t5 * t140 * t128 - 0.9e1 / 0.8e1 * t5 * t144 * t218 + t5 * t227 * t128 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t231 * t218 - 0.9e1 / 0.8e1 * t5 * t235 * t356 - 0.5e1 / 0.36e2 * t5 * t366 * t128 + t5 * t370 * t218 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t374 * t356 - 0.3e1 / 0.8e1 * t5 * t378 * t587)
  t594 = r1 <= f.p.dens_threshold
  t595 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t596 = 0.1e1 + t595
  t597 = t596 <= f.p.zeta_threshold
  t598 = t596 ** (0.1e1 / 0.3e1)
  t599 = t598 ** 2
  t601 = 0.1e1 / t599 / t596
  t603 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t604 = t603 ** 2
  t608 = 0.1e1 / t599
  t609 = t608 * t603
  t611 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t615 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t619 = f.my_piecewise3(t597, 0, -0.8e1 / 0.27e2 * t601 * t604 * t603 + 0.4e1 / 0.3e1 * t609 * t611 + 0.4e1 / 0.3e1 * t598 * t615)
  t621 = r1 ** 2
  t622 = r1 ** (0.1e1 / 0.3e1)
  t623 = t622 ** 2
  t625 = 0.1e1 / t623 / t621
  t627 = t61 * s2
  t628 = t627 * t625
  t632 = 0.1e1 / (0.1e1 + t57 * t628 / 0.24e2)
  t641 = jnp.sqrt(s2)
  t644 = 0.1e1 / t622 / r1
  t648 = t98 * t641 * t644
  t649 = jnp.sqrt(t648)
  t654 = scipy.special.lambertw(t97 * t649 * t648 * t104 / 0.1728e4)
  t655 = t654 ** (0.1e1 / 0.3e1)
  t656 = t655 ** 2
  t662 = (0.2823705740248932030511071641312341561894e2 + 0.3e1 / 0.4e1 * t112 * t655 * t654) ** (0.1e1 / 0.4e1)
  t673 = 0.1e1 - t62 * s2 * t625 * t632 / 0.24e2 + t57 * t627 * t625 * t632 * (0.1e1 + t80 * t628 / 0.24e2) / (0.1e1 + t85 * t86 * t641 * t644 * t95 * t96 * t656 * t662 / 0.8e1) / 0.24e2
  t682 = f.my_piecewise3(t597, 0, 0.4e1 / 0.9e1 * t608 * t604 + 0.4e1 / 0.3e1 * t598 * t611)
  t689 = f.my_piecewise3(t597, 0, 0.4e1 / 0.3e1 * t598 * t603)
  t695 = f.my_piecewise3(t597, t361, t598 * t596)
  t701 = f.my_piecewise3(t594, 0, -0.3e1 / 0.8e1 * t5 * t619 * t54 * t673 - 0.3e1 / 0.8e1 * t5 * t682 * t139 * t673 + t5 * t689 * t226 * t673 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t695 * t365 * t673)
  t708 = 0.1e1 / t138 / t36
  t735 = t421 * params.alpha * t251
  t736 = t423 * s0
  t738 = t254 ** 2
  t741 = 0.1e1 / t64 / t738 / r0
  t743 = 0.1e1 / t428 / t73
  t750 = 0.1e1 / t254 / t158
  t757 = 0.1e1 / t65 / t254 / t159
  t777 = 0.1e1 / t64 / t400
  t779 = t85 * t88 * t777
  t780 = t488 * t107
  t794 = 0.1e1 / t482 / t317
  t802 = 0.1e1 / t482 / t329
  t837 = -0.189e3 / 0.4e1 * t779 * t93 * t109 * t780 * t514 * t491 * t94 * t96 - 0.411e3 / 0.16e2 * t779 * t343 - 0.153e3 / 0.2e1 * t779 * t541 + 0.80e2 / 0.3e1 * t779 * t194 * t505 * t794 - 0.20e2 * t779 * t194 * t109 * t335 * t117 * t802 - 0.68e2 / 0.3e1 * t779 * t536 + 0.272e3 / 0.81e2 * t779 * t532 + 0.357e3 / 0.8e1 * t779 * t518 + 0.68e2 / 0.3e1 * t779 * t507 - 0.58e2 * t779 * t340 * t525 + 0.90e2 * t779 * t523 * t491 * t2 * t111 - 0.135e3 / 0.4e1 * t779 * t93 * t108 * t780 * t339 * t794 * t2 * t111 + 0.153e3 / 0.4e1 * t779 * t526 + 0.1037e4 / 0.81e2 * t779 * t199 + 0.274e3 / 0.27e2 * t779 * t320
  t855 = t777 * t93
  t900 = -0.137e3 / 0.9e1 * t779 * t332 + 0.32e2 / 0.81e2 * t779 * t194 * t195 * t483 - 0.76e2 / 0.9e1 * t779 * t194 * t328 * t491 + 0.84e2 * t779 * t515 * t483 * t94 * t96 + 0.455e3 / 0.81e2 * t779 * t119 - 0.153e3 * t202 * t855 * t484 + 0.51e2 * t202 * t855 * t492 + 0.1037e4 / 0.36e2 * t202 * t855 * t209 + 0.884e3 / 0.9e1 * t202 * t855 * t478 - 0.137e3 / 0.4e1 * t202 * t855 * t347 - 0.2079e4 / 0.16e2 * t202 * t855 * t488 * t204 / t206 / t512 / t116 * t483 + 0.320e3 / 0.9e1 * t202 * t855 * t208 * t483 - 0.139e3 * t202 * t855 * t346 * t491 + 0.150e3 * t202 * t855 * t489 * t794 - 0.45e2 * t202 * t855 * t780 * t207 * t802 + 0.274e3 / 0.3e1 * t202 * t855 * t323
  t909 = t300 ** 2
  t913 = -0.2e1 / 0.243e3 * t422 * t456 * t429 * t187 * t431 * t213 + 0.2e1 / 0.243e3 * t252 * t456 * t259 * t80 * t61 * t186 * t213 - 0.2e1 / 0.2187e4 * t735 * t736 * t741 * t743 * t84 * t155 - 0.2563e4 / 0.1458e4 * t284 * t750 * t164 * t181 + 0.49e2 / 0.729e3 * t424 * t757 * t429 * t431 + 0.2563e4 / 0.1458e4 * t278 * t750 * t259 * t124 - 0.2563e4 / 0.1458e4 * t252 * t253 * t750 * t259 - t179 * t271 * t557 / 0.4e1 + 0.4e1 / 0.9e1 * t78 * t168 * t553 - t78 * t79 * t187 * (t837 + t900) / 0.24e2 + t78 * t79 * t83 / t566 / t122 * t909
  t914 = t736 * t741
  t918 = t123 * t84 * t155
  t953 = t351 ** 2
  t958 = 0.2e1 / 0.2187e4 * t735 * t914 * t743 * t83 * t918 - 0.2e1 / 0.2187e4 * t422 * t914 * t429 * params.c * t918 + t173 * t267 * t352 / 0.4e1 - 0.22e2 / 0.9e1 * t78 * t263 * t352 - 0.341e3 / 0.243e3 * t173 * t381 * t214 - t173 * t174 * t570 / 0.9e1 + 0.616e3 / 0.81e2 * t78 * t403 * t214 - t173 * t267 * t301 / 0.2e1 + t179 * t271 * t562 / 0.2e1 + t179 * t180 * params.c * t567 * t569 / 0.9e1 + t78 * t79 * t299 * t953 / 0.4e1
  t970 = t423 * t757
  t983 = t172 * t161
  t1002 = 0.341e3 / 0.243e3 * t179 * t396 * t293 - t173 * t174 * t553 / 0.54e2 + t179 * t180 * t292 * t552 / 0.54e2 - 0.49e2 / 0.729e3 * t422 * t970 * t461 + 0.49e2 / 0.729e3 * t252 * t970 * t466 + 0.44e2 / 0.9e1 * t78 * t263 * t301 + 0.8e1 / 0.3e1 * t78 * t168 * t570 - t178 * t983 * t74 * params.c * t582 / 0.9e1 + t71 * t580 * t581 * t552 / 0.3e1 - 0.3e1 / 0.2e1 * t71 * t580 * t567 * t300 * t351 - 0.8e1 / 0.3e1 * t57 * t69 * t147 * t583
  t1010 = 0.1e1 / t64 / t254 / r0
  t1016 = 0.1e1 / t65 / t159
  t1021 = t186 * t351
  t1031 = t298 * t300
  t1053 = t153 * t983 * t164 * t83 * t582 / 0.9e1 + 0.3047e4 / 0.972e3 * t179 * t1010 * t74 * t181 + 0.2618e4 / 0.243e3 * t78 * t1016 * t74 * t124 - t385 * t386 * t1021 / 0.27e2 + 0.38e2 / 0.81e2 * t252 * t409 * t388 - 0.38e2 / 0.81e2 * t283 * t409 * t393 - 0.2e1 / 0.27e2 * t391 * t392 * t1031 + 0.2e1 / 0.27e2 * t385 * t386 * t1031 + t391 * t392 * t1021 / 0.27e2 - 0.3047e4 / 0.972e3 * t173 * t1010 * t164 * t124 + 0.3047e4 / 0.972e3 * t156 * t157 * t1010 * t164 - 0.2618e4 / 0.243e3 * t62 * s0 * t1016 * t74
  t1074 = t19 ** 2
  t1077 = t30 ** 2
  t1083 = t41 ** 2
  t1092 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t1093 = f.my_piecewise5(t10, 0, t14, 0, t1092)
  t1097 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t1074 * t1077 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t1083 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t1093)
  t1113 = -t5 * t53 * t139 * t128 / 0.2e1 + 0.10e2 / 0.27e2 * t5 * t363 * t708 * t128 - 0.3e1 / 0.2e1 * t5 * t235 * t587 + t5 * t227 * t218 - 0.3e1 / 0.2e1 * t5 * t231 * t356 - 0.3e1 / 0.8e1 * t5 * t378 * (t913 + t958 + t1002 + t1053) - t5 * t374 * t587 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t366 * t218 + t5 * t370 * t356 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t140 * t218 - 0.9e1 / 0.4e1 * t5 * t144 * t356 - 0.3e1 / 0.8e1 * t5 * t1097 * t54 * t128 - 0.3e1 / 0.2e1 * t5 * t55 * t218 + t5 * t137 * t226 * t128 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t224 * t365 * t128
  t1114 = f.my_piecewise3(t1, 0, t1113)
  t1115 = t596 ** 2
  t1118 = t604 ** 2
  t1124 = t611 ** 2
  t1130 = f.my_piecewise5(t14, 0, t10, 0, -t1092)
  t1134 = f.my_piecewise3(t597, 0, 0.40e2 / 0.81e2 / t599 / t1115 * t1118 - 0.16e2 / 0.9e1 * t601 * t604 * t611 + 0.4e1 / 0.3e1 * t608 * t1124 + 0.16e2 / 0.9e1 * t609 * t615 + 0.4e1 / 0.3e1 * t598 * t1130)
  t1156 = f.my_piecewise3(t594, 0, -0.3e1 / 0.8e1 * t5 * t1134 * t54 * t673 - t5 * t619 * t139 * t673 / 0.2e1 + t5 * t682 * t226 * t673 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t689 * t365 * t673 + 0.10e2 / 0.27e2 * t5 * t695 * t708 * t673)
  d1111 = 0.4e1 * t592 + 0.4e1 * t701 + t6 * (t1114 + t1156)

  res = {'v4rho4': d1111}
  return res
