"""Generated from gga_x_bayesian.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  bayesian_theta0 = 1.0008

  bayesian_theta1 = 0.1926

  bayesian_theta2 = 1.8962

  bayesian_f0 = lambda s: s ** 2 / (1 + s) ** 2

  bayesian_f = lambda x: bayesian_theta0 + bayesian_f0(X2S * x) * (bayesian_theta1 + bayesian_f0(X2S * x) * bayesian_theta2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, bayesian_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  bayesian_theta0 = 1.0008

  bayesian_theta1 = 0.1926

  bayesian_theta2 = 1.8962

  bayesian_f0 = lambda s: s ** 2 / (1 + s) ** 2

  bayesian_f = lambda x: bayesian_theta0 + bayesian_f0(X2S * x) * (bayesian_theta1 + bayesian_f0(X2S * x) * bayesian_theta2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, bayesian_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  bayesian_theta0 = 1.0008

  bayesian_theta1 = 0.1926

  bayesian_theta2 = 1.8962

  bayesian_f0 = lambda s: s ** 2 / (1 + s) ** 2

  bayesian_f = lambda x: bayesian_theta0 + bayesian_f0(X2S * x) * (bayesian_theta1 + bayesian_f0(X2S * x) * bayesian_theta2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, bayesian_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = t28 / t31
  t34 = t33 * s0
  t35 = r0 ** 2
  t36 = r0 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = 0.1e1 / t37 / t35
  t40 = t28 ** 2
  t42 = t40 / t30
  t43 = jnp.sqrt(s0)
  t49 = 0.1e1 + t42 * t43 / t36 / r0 / 0.12e2
  t50 = t49 ** 2
  t51 = 0.1e1 / t50
  t52 = t39 * t51
  t57 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t33 * s0 * t39 * t51
  t58 = t52 * t57
  t61 = 0.10008e1 + t34 * t58 / 0.24e2
  t65 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t61)
  t66 = r1 <= f.p.dens_threshold
  t67 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t68 = 0.1e1 + t67
  t69 = t68 <= f.p.zeta_threshold
  t70 = t68 ** (0.1e1 / 0.3e1)
  t72 = f.my_piecewise3(t69, t22, t70 * t68)
  t73 = t72 * t26
  t74 = t33 * s2
  t75 = r1 ** 2
  t76 = r1 ** (0.1e1 / 0.3e1)
  t77 = t76 ** 2
  t79 = 0.1e1 / t77 / t75
  t80 = jnp.sqrt(s2)
  t86 = 0.1e1 + t42 * t80 / t76 / r1 / 0.12e2
  t87 = t86 ** 2
  t88 = 0.1e1 / t87
  t89 = t79 * t88
  t94 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t33 * s2 * t79 * t88
  t95 = t89 * t94
  t98 = 0.10008e1 + t74 * t95 / 0.24e2
  t102 = f.my_piecewise3(t66, 0, -0.3e1 / 0.8e1 * t5 * t73 * t98)
  t103 = t6 ** 2
  t105 = t16 / t103
  t106 = t7 - t105
  t107 = f.my_piecewise5(t10, 0, t14, 0, t106)
  t110 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t107)
  t115 = t26 ** 2
  t116 = 0.1e1 / t115
  t120 = t5 * t25 * t116 * t61 / 0.8e1
  t123 = 0.1e1 / t37 / t35 / r0
  t128 = 0.1e1 / t29
  t130 = t128 * t43 * s0
  t131 = t35 ** 2
  t135 = 0.1e1 / t50 / t49
  t136 = 0.1e1 / t131 / r0 * t135
  t155 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t26 * t61 - t120 - 0.3e1 / 0.8e1 * t5 * t27 * (-t34 * t123 * t51 * t57 / 0.9e1 + t130 * t136 * t57 / 0.18e2 + t34 * t52 * (-0.21068888888888888888888888888888888888888888888889e0 * t33 * s0 * t123 * t51 + 0.10534444444444444444444444444444444444444444444444e0 * t130 * t136) / 0.24e2))
  t157 = f.my_piecewise5(t14, 0, t10, 0, -t106)
  t160 = f.my_piecewise3(t69, 0, 0.4e1 / 0.3e1 * t70 * t157)
  t168 = t5 * t72 * t116 * t98 / 0.8e1
  t170 = f.my_piecewise3(t66, 0, -0.3e1 / 0.8e1 * t5 * t160 * t26 * t98 - t168)
  vrho_0_ = t65 + t102 + t6 * (t155 + t170)
  t173 = -t7 - t105
  t174 = f.my_piecewise5(t10, 0, t14, 0, t173)
  t177 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t174)
  t183 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t177 * t26 * t61 - t120)
  t185 = f.my_piecewise5(t14, 0, t10, 0, -t173)
  t188 = f.my_piecewise3(t69, 0, 0.4e1 / 0.3e1 * t70 * t185)
  t195 = 0.1e1 / t77 / t75 / r1
  t201 = t128 * t80 * s2
  t202 = t75 ** 2
  t206 = 0.1e1 / t87 / t86
  t207 = 0.1e1 / t202 / r1 * t206
  t226 = f.my_piecewise3(t66, 0, -0.3e1 / 0.8e1 * t5 * t188 * t26 * t98 - t168 - 0.3e1 / 0.8e1 * t5 * t73 * (-t74 * t195 * t88 * t94 / 0.9e1 + t201 * t207 * t94 / 0.18e2 + t74 * t89 * (-0.21068888888888888888888888888888888888888888888889e0 * t33 * s2 * t195 * t88 + 0.10534444444444444444444444444444444444444444444444e0 * t201 * t207) / 0.24e2))
  vrho_1_ = t65 + t102 + t6 * (t183 + t226)
  t231 = t128 * t43
  t233 = 0.1e1 / t131 * t135
  t249 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t33 * t58 / 0.24e2 - t231 * t233 * t57 / 0.48e2 + t34 * t52 * (0.79008333333333333333333333333333333333333333333333e-1 * t33 * t52 - 0.39504166666666666666666666666666666666666666666666e-1 * t231 * t233) / 0.24e2))
  vsigma_0_ = t6 * t249
  vsigma_1_ = 0.0e0
  t252 = t128 * t80
  t254 = 0.1e1 / t202 * t206
  t270 = f.my_piecewise3(t66, 0, -0.3e1 / 0.8e1 * t5 * t73 * (t33 * t95 / 0.24e2 - t252 * t254 * t94 / 0.48e2 + t74 * t89 * (0.79008333333333333333333333333333333333333333333333e-1 * t33 * t89 - 0.39504166666666666666666666666666666666666666666666e-1 * t252 * t254) / 0.24e2))
  vsigma_2_ = t6 * t270
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  bayesian_theta0 = 1.0008

  bayesian_theta1 = 0.1926

  bayesian_theta2 = 1.8962

  bayesian_f0 = lambda s: s ** 2 / (1 + s) ** 2

  bayesian_f = lambda x: bayesian_theta0 + bayesian_f0(X2S * x) * (bayesian_theta1 + bayesian_f0(X2S * x) * bayesian_theta2)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, bayesian_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = t20 / t23
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = t20 ** 2
  t37 = jnp.sqrt(s0)
  t44 = 0.1e1 + t34 / t22 * t37 * t27 / t18 / r0 / 0.12e2
  t45 = t44 ** 2
  t46 = 0.1e1 / t45
  t47 = t33 * t46
  t50 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t26 * t47
  t51 = t46 * t50
  t55 = 0.10008e1 + t26 * t33 * t51 / 0.24e2
  t59 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t55)
  t68 = t28 / t30 / t29 / r0
  t72 = 0.1e1 / t21
  t74 = t72 * t37 * s0
  t75 = t29 ** 2
  t79 = 0.1e1 / t45 / t44
  t80 = 0.1e1 / t75 / r0 * t79
  t99 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t55 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-t26 * t68 * t51 / 0.9e1 + t74 * t80 * t50 / 0.9e1 + t26 * t33 * t46 * (-0.21068888888888888888888888888888888888888888888889e0 * t26 * t68 * t46 + 0.21068888888888888888888888888888888888888888888889e0 * t74 * t80) / 0.24e2))
  vrho_0_ = 0.2e1 * r0 * t99 + 0.2e1 * t59
  t106 = t72 * t37
  t108 = 0.1e1 / t75 * t79
  t124 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t25 * t28 * t32 * t46 * t50 / 0.24e2 - t106 * t108 * t50 / 0.24e2 + t26 * t33 * t46 * (0.79008333333333333333333333333333333333333333333333e-1 * t25 * t47 - 0.79008333333333333333333333333333333333333333333333e-1 * t106 * t108) / 0.24e2))
  vsigma_0_ = 0.2e1 * r0 * t124
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = t27 * s0
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t34 = t30 * t33
  t35 = t22 ** 2
  t36 = 0.1e1 / t24
  t37 = t35 * t36
  t38 = jnp.sqrt(s0)
  t45 = 0.1e1 + t37 * t38 * t29 / t18 / r0 / 0.12e2
  t46 = t45 ** 2
  t47 = 0.1e1 / t46
  t48 = t34 * t47
  t51 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t28 * t48
  t52 = t47 * t51
  t56 = 0.10008e1 + t28 * t34 * t52 / 0.24e2
  t60 = t17 * t18
  t61 = t31 * r0
  t63 = 0.1e1 / t19 / t61
  t64 = t30 * t63
  t68 = 0.1e1 / t23
  t70 = t68 * t38 * s0
  t71 = t31 ** 2
  t72 = t71 * r0
  t73 = 0.1e1 / t72
  t75 = 0.1e1 / t46 / t45
  t76 = t73 * t75
  t80 = t64 * t47
  t85 = -0.21068888888888888888888888888888888888888888888889e0 * t28 * t80 + 0.21068888888888888888888888888888888888888888888889e0 * t70 * t76
  t86 = t47 * t85
  t90 = -t28 * t64 * t52 / 0.9e1 + t70 * t76 * t51 / 0.9e1 + t28 * t34 * t86 / 0.24e2
  t95 = f.my_piecewise3(t2, 0, -t6 * t21 * t56 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t60 * t90)
  t108 = t30 / t19 / t71
  t112 = t71 * t31
  t114 = 0.1e1 / t112 * t75
  t121 = s0 ** 2
  t122 = t68 * t121
  t125 = 0.1e1 / t18 / t71 / t61
  t126 = t46 ** 2
  t127 = 0.1e1 / t126
  t131 = t36 * t29
  t132 = t51 * t35 * t131
  t145 = t127 * t35 * t131
  t158 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t56 / 0.12e2 - t6 * t21 * t90 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t60 * (0.11e2 / 0.27e2 * t28 * t108 * t52 - 0.23e2 / 0.27e2 * t70 * t114 * t51 - 0.2e1 / 0.9e1 * t28 * t64 * t86 + t122 * t125 * t127 * t132 / 0.27e2 + 0.2e1 / 0.9e1 * t70 * t76 * t85 + t28 * t34 * t47 * (0.77252592592592592592592592592592592592592592592593e0 * t28 * t108 * t47 - 0.16152814814814814814814814814814814814814814814814e1 * t70 * t114 + 0.70229629629629629629629629629629629629629629629630e-1 * t122 * t125 * t145) / 0.24e2))
  v2rho2_0_ = 0.2e1 * r0 * t158 + 0.4e1 * t95
  t161 = t27 * t30
  t162 = t33 * t47
  t165 = t68 * t38
  t166 = 0.1e1 / t71
  t167 = t166 * t75
  t174 = 0.79008333333333333333333333333333333333333333333333e-1 * t27 * t48 - 0.79008333333333333333333333333333333333333333333333e-1 * t165 * t167
  t175 = t47 * t174
  t179 = t161 * t162 * t51 / 0.24e2 - t165 * t167 * t51 / 0.24e2 + t28 * t34 * t175 / 0.24e2
  t183 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t60 * t179)
  t191 = t68 * t73
  t192 = t75 * t51
  t199 = t68 * s0
  t201 = 0.1e1 / t18 / t112
  t233 = f.my_piecewise3(t2, 0, -t6 * t21 * t179 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t60 * (-t161 * t63 * t47 * t51 / 0.9e1 + 0.5e1 / 0.18e2 * t191 * t192 * t38 + t161 * t162 * t85 / 0.24e2 - t199 * t201 * t127 * t132 / 0.72e2 - t165 * t167 * t85 / 0.24e2 - t28 * t64 * t175 / 0.9e1 + t70 * t76 * t174 / 0.9e1 + t28 * t34 * t47 * (-0.21068888888888888888888888888888888888888888888889e0 * t27 * t80 + 0.52672222222222222222222222222222222222222222222222e0 * t191 * t75 * t38 - 0.26336111111111111111111111111111111111111111111111e-1 * t199 * t201 * t145) / 0.24e2))
  v2rhosigma_0_ = 0.2e1 * r0 * t233 + 0.2e1 * t183
  t236 = t68 * t166
  t237 = 0.1e1 / t38
  t247 = t68 / t18 / t72 * t127
  t268 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t60 * (-t236 * t192 * t237 / 0.16e2 + t161 * t162 * t174 / 0.12e2 + t247 * t132 / 0.192e3 - t165 * t167 * t174 / 0.12e2 + t28 * t34 * t47 * (-0.11851250000000000000000000000000000000000000000000e0 * t236 * t75 * t237 + 0.98760416666666666666666666666666666666666666666666e-2 * t247 * t37 * t29) / 0.24e2))
  v2sigma2_0_ = 0.2e1 * r0 * t268
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t29 = t23 * t27 * s0
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t35 = t31 * t34
  t36 = t23 ** 2
  t37 = 0.1e1 / t25
  t39 = jnp.sqrt(s0)
  t46 = 0.1e1 + t36 * t37 * t39 * t30 / t18 / r0 / 0.12e2
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t52 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t29 * t35 * t48
  t53 = t48 * t52
  t57 = 0.10008e1 + t29 * t35 * t53 / 0.24e2
  t62 = t17 / t19
  t63 = t32 * r0
  t66 = t31 / t19 / t63
  t70 = 0.1e1 / t24
  t72 = t70 * t39 * s0
  t73 = t32 ** 2
  t74 = t73 * r0
  t77 = 0.1e1 / t47 / t46
  t78 = 0.1e1 / t74 * t77
  t87 = -0.21068888888888888888888888888888888888888888888889e0 * t29 * t66 * t48 + 0.21068888888888888888888888888888888888888888888889e0 * t72 * t78
  t88 = t48 * t87
  t92 = -t29 * t66 * t53 / 0.9e1 + t72 * t78 * t52 / 0.9e1 + t29 * t35 * t88 / 0.24e2
  t96 = t17 * t18
  t99 = t31 / t19 / t73
  t105 = 0.1e1 / t73 / t32 * t77
  t112 = s0 ** 2
  t113 = t70 * t112
  t114 = t73 * t63
  t116 = 0.1e1 / t18 / t114
  t117 = t47 ** 2
  t118 = 0.1e1 / t117
  t120 = t113 * t116 * t118
  t122 = t37 * t30
  t123 = t52 * t36 * t122
  t136 = t118 * t36 * t122
  t139 = 0.77252592592592592592592592592592592592592592592593e0 * t29 * t99 * t48 - 0.16152814814814814814814814814814814814814814814814e1 * t72 * t105 + 0.70229629629629629629629629629629629629629629629630e-1 * t113 * t116 * t136
  t140 = t48 * t139
  t144 = 0.11e2 / 0.27e2 * t29 * t99 * t53 - 0.23e2 / 0.27e2 * t72 * t105 * t52 - 0.2e1 / 0.9e1 * t29 * t66 * t88 + t120 * t123 / 0.27e2 + 0.2e1 / 0.9e1 * t72 * t78 * t87 + t29 * t35 * t140 / 0.24e2
  t149 = f.my_piecewise3(t2, 0, t6 * t22 * t57 / 0.12e2 - t6 * t62 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t96 * t144)
  t163 = t31 / t19 / t74
  t168 = 0.1e1 / t114 * t77
  t175 = t73 ** 2
  t177 = 0.1e1 / t18 / t175
  t189 = t70 * t39 * t112
  t192 = 0.1e1 / t19 / t175 / r0
  t194 = 0.1e1 / t117 / t46
  t198 = t27 * t31
  t232 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t57 + t6 * t22 * t92 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t62 * t144 - 0.3e1 / 0.8e1 * t6 * t96 * (-0.154e3 / 0.81e2 * t29 * t163 * t53 + 0.502e3 / 0.81e2 * t72 * t168 * t52 + 0.11e2 / 0.9e1 * t29 * t99 * t88 - 0.5e1 / 0.9e1 * t113 * t177 * t118 * t123 - 0.23e2 / 0.9e1 * t72 * t105 * t87 - t29 * t66 * t140 / 0.3e1 + 0.8e1 / 0.81e2 * t189 * t192 * t194 * t52 * t23 * t198 + t120 * t87 * t36 * t122 / 0.9e1 + t72 * t78 * t139 / 0.3e1 + t29 * t35 * t48 * (-0.36051209876543209876543209876543209876543209876543e1 * t29 * t163 * t48 + 0.11751758024691358024691358024691358024691358024691e2 * t72 * t168 - 0.10534444444444444444444444444444444444444444444444e1 * t113 * t177 * t136 + 0.18727901234567901234567901234567901234567901234568e0 * t189 * t192 * t194 * t23 * t198) / 0.24e2))
  v3rho3_0_ = 0.2e1 * r0 * t232 + 0.6e1 * t149

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t30 = t24 * t28 * s0
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = t32 * t22
  t34 = t24 ** 2
  t35 = 0.1e1 / t26
  t37 = jnp.sqrt(s0)
  t44 = 0.1e1 + t34 * t35 * t37 * t31 / t19 / r0 / 0.12e2
  t45 = t44 ** 2
  t46 = 0.1e1 / t45
  t50 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t30 * t33 * t46
  t51 = t46 * t50
  t55 = 0.10008e1 + t30 * t33 * t51 / 0.24e2
  t61 = t17 / t20 / r0
  t62 = t18 * r0
  t64 = 0.1e1 / t20 / t62
  t65 = t32 * t64
  t69 = 0.1e1 / t25
  t71 = t69 * t37 * s0
  t72 = t18 ** 2
  t73 = t72 * r0
  t76 = 0.1e1 / t45 / t44
  t77 = 0.1e1 / t73 * t76
  t86 = -0.21068888888888888888888888888888888888888888888889e0 * t30 * t65 * t46 + 0.21068888888888888888888888888888888888888888888889e0 * t71 * t77
  t87 = t46 * t86
  t91 = -t30 * t65 * t51 / 0.9e1 + t71 * t77 * t50 / 0.9e1 + t30 * t33 * t87 / 0.24e2
  t96 = t17 / t20
  t99 = t32 / t20 / t72
  t103 = t72 * t18
  t105 = 0.1e1 / t103 * t76
  t112 = s0 ** 2
  t113 = t69 * t112
  t114 = t72 * t62
  t116 = 0.1e1 / t19 / t114
  t117 = t45 ** 2
  t118 = 0.1e1 / t117
  t120 = t113 * t116 * t118
  t122 = t35 * t31
  t123 = t50 * t34 * t122
  t136 = t118 * t34 * t122
  t139 = 0.77252592592592592592592592592592592592592592592593e0 * t30 * t99 * t46 - 0.16152814814814814814814814814814814814814814814814e1 * t71 * t105 + 0.70229629629629629629629629629629629629629629629630e-1 * t113 * t116 * t136
  t140 = t46 * t139
  t144 = 0.11e2 / 0.27e2 * t30 * t99 * t51 - 0.23e2 / 0.27e2 * t71 * t105 * t50 - 0.2e1 / 0.9e1 * t30 * t65 * t87 + t120 * t123 / 0.27e2 + 0.2e1 / 0.9e1 * t71 * t77 * t86 + t30 * t33 * t140 / 0.24e2
  t148 = t17 * t19
  t151 = t32 / t20 / t73
  t156 = 0.1e1 / t114 * t76
  t163 = t72 ** 2
  t165 = 0.1e1 / t19 / t163
  t167 = t113 * t165 * t118
  t177 = t69 * t37 * t112
  t178 = t163 * r0
  t180 = 0.1e1 / t20 / t178
  t182 = 0.1e1 / t117 / t44
  t184 = t177 * t180 * t182
  t186 = t28 * t32
  t187 = t50 * t24 * t186
  t191 = t86 * t34 * t122
  t207 = t182 * t24 * t186
  t210 = -0.36051209876543209876543209876543209876543209876543e1 * t30 * t151 * t46 + 0.11751758024691358024691358024691358024691358024691e2 * t71 * t156 - 0.10534444444444444444444444444444444444444444444444e1 * t113 * t165 * t136 + 0.18727901234567901234567901234567901234567901234568e0 * t177 * t180 * t207
  t211 = t46 * t210
  t215 = -0.154e3 / 0.81e2 * t30 * t151 * t51 + 0.502e3 / 0.81e2 * t71 * t156 * t50 + 0.11e2 / 0.9e1 * t30 * t99 * t87 - 0.5e1 / 0.9e1 * t167 * t123 - 0.23e2 / 0.9e1 * t71 * t105 * t86 - t30 * t65 * t140 / 0.3e1 + 0.8e1 / 0.81e2 * t184 * t187 + t120 * t191 / 0.9e1 + t71 * t77 * t139 / 0.3e1 + t30 * t33 * t211 / 0.24e2
  t220 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t55 + t6 * t61 * t91 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t96 * t144 - 0.3e1 / 0.8e1 * t6 * t148 * t215)
  t243 = 0.1e1 / t20 / t163 / t18
  t254 = t32 / t20 / t103
  t259 = 0.1e1 / t19 / t178
  t264 = t25 ** 2
  t267 = 0.1e1 / t264 * t112 * s0
  t272 = 0.1e1 / t163 / t72 / t117 / t45
  t280 = 0.1e1 / t163 * t76
  t317 = 0.2e1 / 0.9e1 * t120 * t139 * t34 * t122 - 0.20e2 / 0.9e1 * t167 * t191 - 0.592e3 / 0.243e3 * t177 * t243 * t182 * t187 + 0.32e2 / 0.81e2 * t184 * t86 * t24 * t186 + 0.2618e4 / 0.243e3 * t30 * t254 * t51 + 0.1627e4 / 0.243e3 * t113 * t259 * t118 * t123 + 0.160e3 / 0.243e3 * t267 * t272 * t50 + 0.4e1 / 0.9e1 * t71 * t77 * t210 - 0.11774e5 / 0.243e3 * t71 * t280 * t50 + 0.2008e4 / 0.81e2 * t71 * t156 * t86 - 0.46e2 / 0.9e1 * t71 * t105 * t139 + t30 * t33 * t46 * (0.20429018930041152263374485596707818930041152263374e2 * t30 * t254 * t46 - 0.91875962139917695473251028806584362139917695473248e2 * t71 * t280 + 0.12695956378600823045267489711934156378600823045267e2 * t113 * t259 * t136 - 0.46195489711934156378600823045267489711934156378600e1 * t177 * t243 * t207 + 0.12485267489711934156378600823045267489711934156379e1 * t267 * t272) / 0.24e2 + 0.22e2 / 0.9e1 * t30 * t99 * t140 - 0.4e1 / 0.9e1 * t30 * t65 * t211 - 0.616e3 / 0.81e2 * t30 * t151 * t87
  t322 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t64 * t55 - 0.5e1 / 0.9e1 * t6 * t23 * t91 + t6 * t61 * t144 / 0.2e1 - t6 * t96 * t215 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t148 * t317)
  v4rho4_0_ = 0.2e1 * r0 * t322 + 0.8e1 * t220

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = t37 * s0
  t39 = r0 ** 2
  t40 = r0 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t43 = 0.1e1 / t41 / t39
  t44 = t32 ** 2
  t45 = 0.1e1 / t34
  t46 = t44 * t45
  t47 = jnp.sqrt(s0)
  t53 = 0.1e1 + t46 * t47 / t40 / r0 / 0.12e2
  t54 = t53 ** 2
  t55 = 0.1e1 / t54
  t56 = t43 * t55
  t61 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t37 * s0 * t43 * t55
  t65 = 0.10008e1 + t38 * t56 * t61 / 0.24e2
  t69 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t70 = t69 * f.p.zeta_threshold
  t72 = f.my_piecewise3(t20, t70, t21 * t19)
  t73 = t30 ** 2
  t74 = 0.1e1 / t73
  t75 = t72 * t74
  t78 = t5 * t75 * t65 / 0.8e1
  t79 = t72 * t30
  t80 = t39 * r0
  t82 = 0.1e1 / t41 / t80
  t83 = t82 * t55
  t87 = 0.1e1 / t33
  t89 = t87 * t47 * s0
  t90 = t39 ** 2
  t94 = 0.1e1 / t54 / t53
  t95 = 0.1e1 / t90 / r0 * t94
  t105 = -0.21068888888888888888888888888888888888888888888889e0 * t37 * s0 * t82 * t55 + 0.10534444444444444444444444444444444444444444444444e0 * t89 * t95
  t109 = -t38 * t83 * t61 / 0.9e1 + t89 * t95 * t61 / 0.18e2 + t38 * t56 * t105 / 0.24e2
  t114 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t65 - t78 - 0.3e1 / 0.8e1 * t5 * t79 * t109)
  t116 = r1 <= f.p.dens_threshold
  t117 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t118 = 0.1e1 + t117
  t119 = t118 <= f.p.zeta_threshold
  t120 = t118 ** (0.1e1 / 0.3e1)
  t122 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t125 = f.my_piecewise3(t119, 0, 0.4e1 / 0.3e1 * t120 * t122)
  t126 = t125 * t30
  t127 = t37 * s2
  t128 = r1 ** 2
  t129 = r1 ** (0.1e1 / 0.3e1)
  t130 = t129 ** 2
  t132 = 0.1e1 / t130 / t128
  t133 = jnp.sqrt(s2)
  t139 = 0.1e1 + t46 * t133 / t129 / r1 / 0.12e2
  t140 = t139 ** 2
  t141 = 0.1e1 / t140
  t142 = t132 * t141
  t147 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t37 * s2 * t132 * t141
  t151 = 0.10008e1 + t127 * t142 * t147 / 0.24e2
  t156 = f.my_piecewise3(t119, t70, t120 * t118)
  t157 = t156 * t74
  t160 = t5 * t157 * t151 / 0.8e1
  t162 = f.my_piecewise3(t116, 0, -0.3e1 / 0.8e1 * t5 * t126 * t151 - t160)
  t164 = t21 ** 2
  t165 = 0.1e1 / t164
  t166 = t26 ** 2
  t171 = t16 / t22 / t6
  t173 = -0.2e1 * t23 + 0.2e1 * t171
  t174 = f.my_piecewise5(t10, 0, t14, 0, t173)
  t178 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t165 * t166 + 0.4e1 / 0.3e1 * t21 * t174)
  t185 = t5 * t29 * t74 * t65
  t191 = 0.1e1 / t73 / t6
  t195 = t5 * t72 * t191 * t65 / 0.12e2
  t197 = t5 * t75 * t109
  t200 = 0.1e1 / t41 / t90
  t207 = 0.1e1 / t90 / t39 * t94
  t214 = s0 ** 2
  t219 = t87 * t214 / t40 / t90 / t80
  t220 = t54 ** 2
  t221 = 0.1e1 / t220
  t248 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t178 * t30 * t65 - t185 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t109 + t195 - t197 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t79 * (0.11e2 / 0.27e2 * t38 * t200 * t55 * t61 - 0.23e2 / 0.54e2 * t89 * t207 * t61 - 0.2e1 / 0.9e1 * t38 * t83 * t105 + t219 * t221 * t61 * t46 / 0.54e2 + t89 * t95 * t105 / 0.9e1 + t38 * t56 * (0.77252592592592592592592592592592592592592592592593e0 * t37 * s0 * t200 * t55 - 0.80764074074074074074074074074074074074074074074072e0 * t89 * t207 + 0.35114814814814814814814814814814814814814814814813e-1 * t219 * t221 * t44 * t45) / 0.24e2))
  t249 = t120 ** 2
  t250 = 0.1e1 / t249
  t251 = t122 ** 2
  t255 = f.my_piecewise5(t14, 0, t10, 0, -t173)
  t259 = f.my_piecewise3(t119, 0, 0.4e1 / 0.9e1 * t250 * t251 + 0.4e1 / 0.3e1 * t120 * t255)
  t266 = t5 * t125 * t74 * t151
  t271 = t5 * t156 * t191 * t151 / 0.12e2
  t273 = f.my_piecewise3(t116, 0, -0.3e1 / 0.8e1 * t5 * t259 * t30 * t151 - t266 / 0.4e1 + t271)
  d11 = 0.2e1 * t114 + 0.2e1 * t162 + t6 * (t248 + t273)
  t276 = -t7 - t24
  t277 = f.my_piecewise5(t10, 0, t14, 0, t276)
  t280 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t277)
  t281 = t280 * t30
  t286 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t281 * t65 - t78)
  t288 = f.my_piecewise5(t14, 0, t10, 0, -t276)
  t291 = f.my_piecewise3(t119, 0, 0.4e1 / 0.3e1 * t120 * t288)
  t292 = t291 * t30
  t296 = t156 * t30
  t297 = t128 * r1
  t299 = 0.1e1 / t130 / t297
  t300 = t299 * t141
  t305 = t87 * t133 * s2
  t306 = t128 ** 2
  t310 = 0.1e1 / t140 / t139
  t311 = 0.1e1 / t306 / r1 * t310
  t321 = -0.21068888888888888888888888888888888888888888888889e0 * t37 * s2 * t299 * t141 + 0.10534444444444444444444444444444444444444444444444e0 * t305 * t311
  t325 = -t127 * t300 * t147 / 0.9e1 + t305 * t311 * t147 / 0.18e2 + t127 * t142 * t321 / 0.24e2
  t330 = f.my_piecewise3(t116, 0, -0.3e1 / 0.8e1 * t5 * t292 * t151 - t160 - 0.3e1 / 0.8e1 * t5 * t296 * t325)
  t334 = 0.2e1 * t171
  t335 = f.my_piecewise5(t10, 0, t14, 0, t334)
  t339 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t165 * t277 * t26 + 0.4e1 / 0.3e1 * t21 * t335)
  t346 = t5 * t280 * t74 * t65
  t354 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t339 * t30 * t65 - t346 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t281 * t109 - t185 / 0.8e1 + t195 - t197 / 0.8e1)
  t358 = f.my_piecewise5(t14, 0, t10, 0, -t334)
  t362 = f.my_piecewise3(t119, 0, 0.4e1 / 0.9e1 * t250 * t288 * t122 + 0.4e1 / 0.3e1 * t120 * t358)
  t369 = t5 * t291 * t74 * t151
  t376 = t5 * t157 * t325
  t379 = f.my_piecewise3(t116, 0, -0.3e1 / 0.8e1 * t5 * t362 * t30 * t151 - t369 / 0.8e1 - t266 / 0.8e1 + t271 - 0.3e1 / 0.8e1 * t5 * t126 * t325 - t376 / 0.8e1)
  d12 = t114 + t162 + t286 + t330 + t6 * (t354 + t379)
  t384 = t277 ** 2
  t388 = 0.2e1 * t23 + 0.2e1 * t171
  t389 = f.my_piecewise5(t10, 0, t14, 0, t388)
  t393 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t165 * t384 + 0.4e1 / 0.3e1 * t21 * t389)
  t400 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t393 * t30 * t65 - t346 / 0.4e1 + t195)
  t401 = t288 ** 2
  t405 = f.my_piecewise5(t14, 0, t10, 0, -t388)
  t409 = f.my_piecewise3(t119, 0, 0.4e1 / 0.9e1 * t250 * t401 + 0.4e1 / 0.3e1 * t120 * t405)
  t420 = 0.1e1 / t130 / t306
  t427 = 0.1e1 / t306 / t128 * t310
  t434 = s2 ** 2
  t439 = t87 * t434 / t129 / t306 / t297
  t440 = t140 ** 2
  t441 = 0.1e1 / t440
  t468 = f.my_piecewise3(t116, 0, -0.3e1 / 0.8e1 * t5 * t409 * t30 * t151 - t369 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t292 * t325 + t271 - t376 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t296 * (0.11e2 / 0.27e2 * t127 * t420 * t141 * t147 - 0.23e2 / 0.54e2 * t305 * t427 * t147 - 0.2e1 / 0.9e1 * t127 * t300 * t321 + t439 * t441 * t147 * t46 / 0.54e2 + t305 * t311 * t321 / 0.9e1 + t127 * t142 * (0.77252592592592592592592592592592592592592592592593e0 * t37 * s2 * t420 * t141 - 0.80764074074074074074074074074074074074074074074072e0 * t305 * t427 + 0.35114814814814814814814814814814814814814814814813e-1 * t439 * t441 * t44 * t45) / 0.24e2))
  d22 = 0.2e1 * t286 + 0.2e1 * t330 + t6 * (t400 + t468)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = t49 * s0
  t51 = r0 ** 2
  t52 = r0 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / t51
  t56 = t44 ** 2
  t57 = 0.1e1 / t46
  t58 = t56 * t57
  t59 = jnp.sqrt(s0)
  t65 = 0.1e1 + t58 * t59 / t52 / r0 / 0.12e2
  t66 = t65 ** 2
  t67 = 0.1e1 / t66
  t68 = t55 * t67
  t73 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t49 * s0 * t55 * t67
  t77 = 0.10008e1 + t50 * t68 * t73 / 0.24e2
  t83 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t84 = t42 ** 2
  t85 = 0.1e1 / t84
  t86 = t83 * t85
  t90 = t83 * t42
  t91 = t51 * r0
  t93 = 0.1e1 / t53 / t91
  t94 = t93 * t67
  t98 = 0.1e1 / t45
  t100 = t98 * t59 * s0
  t101 = t51 ** 2
  t102 = t101 * r0
  t105 = 0.1e1 / t66 / t65
  t106 = 0.1e1 / t102 * t105
  t116 = -0.21068888888888888888888888888888888888888888888889e0 * t49 * s0 * t93 * t67 + 0.10534444444444444444444444444444444444444444444444e0 * t100 * t106
  t120 = -t50 * t94 * t73 / 0.9e1 + t100 * t106 * t73 / 0.18e2 + t50 * t68 * t116 / 0.24e2
  t124 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t125 = t124 * f.p.zeta_threshold
  t127 = f.my_piecewise3(t20, t125, t21 * t19)
  t129 = 0.1e1 / t84 / t6
  t130 = t127 * t129
  t134 = t127 * t85
  t138 = t127 * t42
  t140 = 0.1e1 / t53 / t101
  t141 = t140 * t67
  t147 = 0.1e1 / t101 / t51 * t105
  t154 = s0 ** 2
  t155 = t98 * t154
  t156 = t101 * t91
  t159 = t155 / t52 / t156
  t160 = t66 ** 2
  t161 = 0.1e1 / t160
  t163 = t161 * t73 * t58
  t176 = t161 * t56 * t57
  t179 = 0.77252592592592592592592592592592592592592592592593e0 * t49 * s0 * t140 * t67 - 0.80764074074074074074074074074074074074074074074072e0 * t100 * t147 + 0.35114814814814814814814814814814814814814814814813e-1 * t159 * t176
  t183 = 0.11e2 / 0.27e2 * t50 * t141 * t73 - 0.23e2 / 0.54e2 * t100 * t147 * t73 - 0.2e1 / 0.9e1 * t50 * t94 * t116 + t159 * t163 / 0.54e2 + t100 * t106 * t116 / 0.9e1 + t50 * t68 * t179 / 0.24e2
  t188 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t77 - t5 * t86 * t77 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t90 * t120 + t5 * t130 * t77 / 0.12e2 - t5 * t134 * t120 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t138 * t183)
  t190 = r1 <= f.p.dens_threshold
  t191 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t192 = 0.1e1 + t191
  t193 = t192 <= f.p.zeta_threshold
  t194 = t192 ** (0.1e1 / 0.3e1)
  t195 = t194 ** 2
  t196 = 0.1e1 / t195
  t198 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t199 = t198 ** 2
  t203 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t207 = f.my_piecewise3(t193, 0, 0.4e1 / 0.9e1 * t196 * t199 + 0.4e1 / 0.3e1 * t194 * t203)
  t210 = r1 ** 2
  t211 = r1 ** (0.1e1 / 0.3e1)
  t212 = t211 ** 2
  t214 = 0.1e1 / t212 / t210
  t215 = jnp.sqrt(s2)
  t222 = (0.1e1 + t58 * t215 / t211 / r1 / 0.12e2) ** 2
  t223 = 0.1e1 / t222
  t233 = 0.10008e1 + t49 * s2 * t214 * t223 * (0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t49 * s2 * t214 * t223) / 0.24e2
  t239 = f.my_piecewise3(t193, 0, 0.4e1 / 0.3e1 * t194 * t198)
  t245 = f.my_piecewise3(t193, t125, t194 * t192)
  t251 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t207 * t42 * t233 - t5 * t239 * t85 * t233 / 0.4e1 + t5 * t245 * t129 * t233 / 0.12e2)
  t261 = t24 ** 2
  t265 = 0.6e1 * t33 - 0.6e1 * t16 / t261
  t266 = f.my_piecewise5(t10, 0, t14, 0, t265)
  t270 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t266)
  t293 = 0.1e1 / t84 / t24
  t305 = 0.1e1 / t53 / t102
  t311 = 0.1e1 / t156 * t105
  t318 = t101 ** 2
  t321 = t155 / t52 / t318
  t335 = t98 * t59 * t154 / t53 / t318 / r0
  t337 = 0.1e1 / t160 / t65
  t370 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t270 * t42 * t77 - 0.3e1 / 0.8e1 * t5 * t41 * t85 * t77 - 0.9e1 / 0.8e1 * t5 * t43 * t120 + t5 * t83 * t129 * t77 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t86 * t120 - 0.9e1 / 0.8e1 * t5 * t90 * t183 - 0.5e1 / 0.36e2 * t5 * t127 * t293 * t77 + t5 * t130 * t120 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t134 * t183 - 0.3e1 / 0.8e1 * t5 * t138 * (-0.154e3 / 0.81e2 * t50 * t305 * t67 * t73 + 0.251e3 / 0.81e2 * t100 * t311 * t73 + 0.11e2 / 0.9e1 * t50 * t141 * t116 - 0.5e1 / 0.18e2 * t321 * t163 - 0.23e2 / 0.18e2 * t100 * t147 * t116 - t50 * t94 * t179 / 0.3e1 + 0.4e1 / 0.81e2 * t335 * t337 * t73 * t49 + t159 * t161 * t116 * t58 / 0.18e2 + t100 * t106 * t179 / 0.6e1 + t50 * t68 * (-0.36051209876543209876543209876543209876543209876543e1 * t49 * s0 * t305 * t67 + 0.58758790123456790123456790123456790123456790123455e1 * t100 * t311 - 0.52672222222222222222222222222222222222222222222221e0 * t321 * t176 + 0.93639506172839506172839506172839506172839506172835e-1 * t335 * t337 * t44 * t48) / 0.24e2))
  t380 = f.my_piecewise5(t14, 0, t10, 0, -t265)
  t384 = f.my_piecewise3(t193, 0, -0.8e1 / 0.27e2 / t195 / t192 * t199 * t198 + 0.4e1 / 0.3e1 * t196 * t198 * t203 + 0.4e1 / 0.3e1 * t194 * t380)
  t402 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t384 * t42 * t233 - 0.3e1 / 0.8e1 * t5 * t207 * t85 * t233 + t5 * t239 * t129 * t233 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t245 * t293 * t233)
  d111 = 0.3e1 * t188 + 0.3e1 * t251 + t6 * (t370 + t402)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = 0.1e1 / t59
  t61 = t56 * t60
  t62 = t61 * s0
  t63 = r0 ** 2
  t64 = r0 ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t67 = 0.1e1 / t65 / t63
  t68 = t56 ** 2
  t69 = 0.1e1 / t58
  t70 = t68 * t69
  t71 = jnp.sqrt(s0)
  t77 = 0.1e1 + t70 * t71 / t64 / r0 / 0.12e2
  t78 = t77 ** 2
  t79 = 0.1e1 / t78
  t80 = t67 * t79
  t85 = 0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t61 * s0 * t67 * t79
  t89 = 0.10008e1 + t62 * t80 * t85 / 0.24e2
  t98 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t99 = t54 ** 2
  t100 = 0.1e1 / t99
  t101 = t98 * t100
  t105 = t98 * t54
  t106 = t63 * r0
  t108 = 0.1e1 / t65 / t106
  t109 = t108 * t79
  t113 = 0.1e1 / t57
  t115 = t113 * t71 * s0
  t116 = t63 ** 2
  t117 = t116 * r0
  t120 = 0.1e1 / t78 / t77
  t121 = 0.1e1 / t117 * t120
  t131 = -0.21068888888888888888888888888888888888888888888889e0 * t61 * s0 * t108 * t79 + 0.10534444444444444444444444444444444444444444444444e0 * t115 * t121
  t135 = -t62 * t109 * t85 / 0.9e1 + t115 * t121 * t85 / 0.18e2 + t62 * t80 * t131 / 0.24e2
  t141 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t143 = 0.1e1 / t99 / t6
  t144 = t141 * t143
  t148 = t141 * t100
  t152 = t141 * t54
  t154 = 0.1e1 / t65 / t116
  t155 = t154 * t79
  t159 = t116 * t63
  t161 = 0.1e1 / t159 * t120
  t168 = s0 ** 2
  t169 = t113 * t168
  t170 = t116 * t106
  t173 = t169 / t64 / t170
  t174 = t78 ** 2
  t175 = 0.1e1 / t174
  t177 = t175 * t85 * t70
  t190 = t175 * t68 * t69
  t193 = 0.77252592592592592592592592592592592592592592592593e0 * t61 * s0 * t154 * t79 - 0.80764074074074074074074074074074074074074074074072e0 * t115 * t161 + 0.35114814814814814814814814814814814814814814814813e-1 * t173 * t190
  t197 = 0.11e2 / 0.27e2 * t62 * t155 * t85 - 0.23e2 / 0.54e2 * t115 * t161 * t85 - 0.2e1 / 0.9e1 * t62 * t109 * t131 + t173 * t177 / 0.54e2 + t115 * t121 * t131 / 0.9e1 + t62 * t80 * t193 / 0.24e2
  t201 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t202 = t201 * f.p.zeta_threshold
  t204 = f.my_piecewise3(t20, t202, t21 * t19)
  t206 = 0.1e1 / t99 / t25
  t207 = t204 * t206
  t211 = t204 * t143
  t215 = t204 * t100
  t219 = t204 * t54
  t221 = 0.1e1 / t65 / t117
  t222 = t221 * t79
  t227 = 0.1e1 / t170 * t120
  t234 = t116 ** 2
  t237 = t169 / t64 / t234
  t247 = t113 * t71 * t168
  t248 = t234 * r0
  t251 = t247 / t65 / t248
  t253 = 0.1e1 / t174 / t77
  t255 = t253 * t85 * t61
  t259 = t175 * t131 * t70
  t274 = t253 * t56 * t60
  t277 = -0.36051209876543209876543209876543209876543209876543e1 * t61 * s0 * t221 * t79 + 0.58758790123456790123456790123456790123456790123455e1 * t115 * t227 - 0.52672222222222222222222222222222222222222222222221e0 * t237 * t190 + 0.93639506172839506172839506172839506172839506172835e-1 * t251 * t274
  t281 = -0.154e3 / 0.81e2 * t62 * t222 * t85 + 0.251e3 / 0.81e2 * t115 * t227 * t85 + 0.11e2 / 0.9e1 * t62 * t155 * t131 - 0.5e1 / 0.18e2 * t237 * t177 - 0.23e2 / 0.18e2 * t115 * t161 * t131 - t62 * t109 * t193 / 0.3e1 + 0.4e1 / 0.81e2 * t251 * t255 + t173 * t259 / 0.18e2 + t115 * t121 * t193 / 0.6e1 + t62 * t80 * t277 / 0.24e2
  t286 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t89 - 0.3e1 / 0.8e1 * t5 * t101 * t89 - 0.9e1 / 0.8e1 * t5 * t105 * t135 + t5 * t144 * t89 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t148 * t135 - 0.9e1 / 0.8e1 * t5 * t152 * t197 - 0.5e1 / 0.36e2 * t5 * t207 * t89 + t5 * t211 * t135 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t215 * t197 - 0.3e1 / 0.8e1 * t5 * t219 * t281)
  t288 = r1 <= f.p.dens_threshold
  t289 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t290 = 0.1e1 + t289
  t291 = t290 <= f.p.zeta_threshold
  t292 = t290 ** (0.1e1 / 0.3e1)
  t293 = t292 ** 2
  t295 = 0.1e1 / t293 / t290
  t297 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t298 = t297 ** 2
  t302 = 0.1e1 / t293
  t303 = t302 * t297
  t305 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t309 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t313 = f.my_piecewise3(t291, 0, -0.8e1 / 0.27e2 * t295 * t298 * t297 + 0.4e1 / 0.3e1 * t303 * t305 + 0.4e1 / 0.3e1 * t292 * t309)
  t316 = r1 ** 2
  t317 = r1 ** (0.1e1 / 0.3e1)
  t318 = t317 ** 2
  t320 = 0.1e1 / t318 / t316
  t321 = jnp.sqrt(s2)
  t328 = (0.1e1 + t70 * t321 / t317 / r1 / 0.12e2) ** 2
  t329 = 0.1e1 / t328
  t339 = 0.10008e1 + t61 * s2 * t320 * t329 * (0.1926e0 + 0.79008333333333333333333333333333333333333333333333e-1 * t61 * s2 * t320 * t329) / 0.24e2
  t348 = f.my_piecewise3(t291, 0, 0.4e1 / 0.9e1 * t302 * t298 + 0.4e1 / 0.3e1 * t292 * t305)
  t355 = f.my_piecewise3(t291, 0, 0.4e1 / 0.3e1 * t292 * t297)
  t361 = f.my_piecewise3(t291, t202, t292 * t290)
  t367 = f.my_piecewise3(t288, 0, -0.3e1 / 0.8e1 * t5 * t313 * t54 * t339 - 0.3e1 / 0.8e1 * t5 * t348 * t100 * t339 + t5 * t355 * t143 * t339 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t361 * t206 * t339)
  t370 = 0.1e1 / t99 / t36
  t393 = t169 / t64 / t248
  t401 = t247 / t65 / t234 / t63
  t409 = 0.1e1 / t65 / t159
  t415 = 0.1e1 / t234 * t120
  t422 = t57 ** 2
  t425 = 0.1e1 / t422 * t168 * s0
  t430 = 0.1e1 / t234 / t116 / t174 / t78
  t465 = t173 * t175 * t193 * t70 / 0.9e1 + 0.1627e4 / 0.486e3 * t393 * t177 - 0.10e2 / 0.9e1 * t237 * t259 - 0.296e3 / 0.243e3 * t401 * t255 + 0.16e2 / 0.81e2 * t251 * t253 * t131 * t61 + t62 * t80 * (0.20429018930041152263374485596707818930041152263374e2 * t61 * s0 * t409 * t79 - 0.45937981069958847736625514403292181069958847736624e2 * t115 * t415 + 0.63479781893004115226337448559670781893004115226335e1 * t393 * t190 - 0.23097744855967078189300411522633744855967078189300e1 * t401 * t274 + 0.31213168724279835390946502057613168724279835390945e0 * t425 * t430) / 0.24e2 - 0.4e1 / 0.9e1 * t62 * t109 * t277 - 0.616e3 / 0.81e2 * t62 * t222 * t131 + 0.22e2 / 0.9e1 * t62 * t155 * t193 - 0.23e2 / 0.9e1 * t115 * t161 * t193 + 0.40e2 / 0.243e3 * t425 * t430 * t85 + 0.2e1 / 0.9e1 * t115 * t121 * t277 - 0.5887e4 / 0.243e3 * t115 * t415 * t85 + 0.1004e4 / 0.81e2 * t115 * t227 * t131 + 0.2618e4 / 0.243e3 * t62 * t409 * t79 * t85
  t486 = t19 ** 2
  t489 = t30 ** 2
  t495 = t41 ** 2
  t504 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t505 = f.my_piecewise5(t10, 0, t14, 0, t504)
  t509 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t486 * t489 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t495 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t505)
  t523 = 0.10e2 / 0.27e2 * t5 * t204 * t370 * t89 - 0.5e1 / 0.9e1 * t5 * t141 * t206 * t89 - t5 * t53 * t100 * t89 / 0.2e1 + t5 * t98 * t143 * t89 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t219 * t465 - 0.5e1 / 0.9e1 * t5 * t207 * t135 + t5 * t211 * t197 / 0.2e1 - t5 * t215 * t281 / 0.2e1 + t5 * t144 * t135 - 0.3e1 / 0.2e1 * t5 * t148 * t197 - 0.3e1 / 0.2e1 * t5 * t152 * t281 - 0.3e1 / 0.8e1 * t5 * t509 * t54 * t89 - 0.3e1 / 0.2e1 * t5 * t55 * t135 - 0.3e1 / 0.2e1 * t5 * t101 * t135 - 0.9e1 / 0.4e1 * t5 * t105 * t197
  t524 = f.my_piecewise3(t1, 0, t523)
  t525 = t290 ** 2
  t528 = t298 ** 2
  t534 = t305 ** 2
  t540 = f.my_piecewise5(t14, 0, t10, 0, -t504)
  t544 = f.my_piecewise3(t291, 0, 0.40e2 / 0.81e2 / t293 / t525 * t528 - 0.16e2 / 0.9e1 * t295 * t298 * t305 + 0.4e1 / 0.3e1 * t302 * t534 + 0.16e2 / 0.9e1 * t303 * t309 + 0.4e1 / 0.3e1 * t292 * t540)
  t566 = f.my_piecewise3(t288, 0, -0.3e1 / 0.8e1 * t5 * t544 * t54 * t339 - t5 * t313 * t100 * t339 / 0.2e1 + t5 * t348 * t143 * t339 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t355 * t206 * t339 + 0.10e2 / 0.27e2 * t5 * t361 * t370 * t339)
  d1111 = 0.4e1 * t286 + 0.4e1 * t367 + t6 * (t524 + t566)

  res = {'v4rho4': d1111}
  return res
