"""Generated from gga_x_beefvdw.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  beefvdw_coeffs = np.array([np.nan, 1.516501714, 0.4413532099, -0.09182135241, -0.02352754331, 0.03418828455, 0.002411870076, -0.01416381352, 0.0006975895581, 0.009859205137, -0.006737855051, -0.001573330824, 0.005036146253, -0.002569472453, -0.0009874953976, 0.002033722895, -0.0008018718848, -0.0006688078723, 0.001030936331, -0.000367383866, -0.0004213635394, 0.0005761607992, -8.346503735e-05, -0.0004458447585, 0.0004601290092, -5.231775398e-06, -0.0004239570471, 0.0003750190679, 2.114938125e-05, -0.0001904911565, 7.384362421e-05], dtype=np.float64)

  beefvdw_k = 4

  beefvdw_xi = lambda p: 2 * p / (beefvdw_k + p) - 1

  beefvdw_f = lambda x: jnp.sum(jnp.array([beefvdw_coeffs[i] * P(i - 1, beefvdw_xi(X2S ** 2 * x ** 2)) for i in range(1, 30 + 1)]), axis=0)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, beefvdw_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  beefvdw_coeffs = np.array([np.nan, 1.516501714, 0.4413532099, -0.09182135241, -0.02352754331, 0.03418828455, 0.002411870076, -0.01416381352, 0.0006975895581, 0.009859205137, -0.006737855051, -0.001573330824, 0.005036146253, -0.002569472453, -0.0009874953976, 0.002033722895, -0.0008018718848, -0.0006688078723, 0.001030936331, -0.000367383866, -0.0004213635394, 0.0005761607992, -8.346503735e-05, -0.0004458447585, 0.0004601290092, -5.231775398e-06, -0.0004239570471, 0.0003750190679, 2.114938125e-05, -0.0001904911565, 7.384362421e-05], dtype=np.float64)

  beefvdw_k = 4

  beefvdw_xi = lambda p: 2 * p / (beefvdw_k + p) - 1

  beefvdw_f = lambda x: jnp.sum(jnp.array([beefvdw_coeffs[i] * P(i - 1, beefvdw_xi(X2S ** 2 * x ** 2)) for i in range(1, 30 + 1)]), axis=0)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, beefvdw_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  beefvdw_coeffs = np.array([np.nan, 1.516501714, 0.4413532099, -0.09182135241, -0.02352754331, 0.03418828455, 0.002411870076, -0.01416381352, 0.0006975895581, 0.009859205137, -0.006737855051, -0.001573330824, 0.005036146253, -0.002569472453, -0.0009874953976, 0.002033722895, -0.0008018718848, -0.0006688078723, 0.001030936331, -0.000367383866, -0.0004213635394, 0.0005761607992, -8.346503735e-05, -0.0004458447585, 0.0004601290092, -5.231775398e-06, -0.0004239570471, 0.0003750190679, 2.114938125e-05, -0.0001904911565, 7.384362421e-05], dtype=np.float64)

  beefvdw_k = 4

  beefvdw_xi = lambda p: 2 * p / (beefvdw_k + p) - 1

  beefvdw_f = lambda x: jnp.sum(jnp.array([beefvdw_coeffs[i] * P(i - 1, beefvdw_xi(X2S ** 2 * x ** 2)) for i in range(1, 30 + 1)]), axis=0)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, beefvdw_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = t28 / t31
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t42 = 0.4e1 + t33 * t39 / 0.24e2
  t43 = 0.1e1 / t42
  t45 = t33 * t39 * t43
  t47 = t45 / 0.12e2 - 0.1e1
  t48 = t47 ** 2
  t49 = t48 * t47
  t52 = t48 ** 2
  t53 = t52 * t47
  t55 = t52 * t48
  t57 = t52 ** 2
  t60 = t57 * t48
  t62 = t52 * t49
  t64 = t57 * t47
  t66 = t57 * t53
  t68 = t57 * t49
  t70 = t57 * t62
  t72 = t57 * t52
  t74 = t57 ** 2
  t76 = t57 * t55
  t78 = 0.52755620115589800943434238433837890625000000000000e0 * t49 - 0.38916037779196815968155860900878906250000000000000e0 * t48 - 0.72975787893717136018618941307067871093750000000000e1 * t53 + 0.30542034959315850167691707611083984375000000000000e2 * t55 - 0.44233229018433803621149957180023193359375000000000e3 * t57 - 0.69459735177638985467255115509033203125000000000000e0 * t52 + 0.37835396407252402359200346469879150390625000000000e4 * t60 + 0.86005730499279641302996873855590820312500000000000e2 * t62 - 0.61754786104528599733290821313858032226562500000000e3 * t64 - 0.2810240180568462991258881986141204833984375000000e4 * t66 + 0.22748997850816485208791106939315795898437500000000e4 * t68 - 0.10276426607863824396951162815093994140625000000000e5 * t70 - 0.20148245175625047025563767552375793457031250000000e5 * t72 - 0.16837084139014120539123347103595733642578125000000e6 * t74 + 0.70504541869034010050971341133117675781250000000000e5 * t76
  t79 = t74 * t47
  t81 = t74 * t48
  t83 = t74 * t49
  t85 = t74 * t55
  t87 = t74 * t52
  t89 = t74 * t62
  t91 = t74 * t53
  t93 = t74 * t64
  t95 = t74 * t57
  t97 = t74 * t60
  t99 = t74 * t72
  t101 = t74 * t68
  t106 = 0.11313514630621233134023547172546386718750000000000e1 + 0.56174007979372666952880866825580596923828125000000e5 * t79 + 0.27967048856303053872440291047096252441406250000000e6 * t81 - 0.12981481812794983921641696989536285400390625000000e6 * t83 + 0.25589479526235334610627921819686889648437500000000e6 * t85 - 0.32352403136049329184315676152706146240234375000000e6 * t87 - 0.16114215399846280594696041941642761230468750000000e6 * t89 + 0.18078200670879145335944073647260665893554687500000e6 * t91 + 0.90365611108522808258607082664966583251953125000000e5 * t93 - 0.13204466182182150467548430263996124267578125000000e6 * t95 + 0.40074935854432390114256376028060913085937500000000e5 * t97 - 0.54277774626371860319706052541732788085937500000000e4 * t99 - 0.29150193011493262291916212439537048339843750000000e5 * t101 + 0.41355861880146538749944016337394714355468750000000e4 * t74 * t66 + 0.37534251004296526982262730598449707031250000000000e-1 * t45
  t107 = t78 + t106
  t111 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t107)
  t112 = r1 <= f.p.dens_threshold
  t113 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t114 = 0.1e1 + t113
  t115 = t114 <= f.p.zeta_threshold
  t116 = t114 ** (0.1e1 / 0.3e1)
  t118 = f.my_piecewise3(t115, t22, t116 * t114)
  t119 = t118 * t26
  t120 = r1 ** 2
  t121 = r1 ** (0.1e1 / 0.3e1)
  t122 = t121 ** 2
  t124 = 0.1e1 / t122 / t120
  t125 = s2 * t124
  t128 = 0.4e1 + t33 * t125 / 0.24e2
  t129 = 0.1e1 / t128
  t131 = t33 * t125 * t129
  t133 = t131 / 0.12e2 - 0.1e1
  t134 = t133 ** 2
  t136 = t134 * t133
  t138 = t134 ** 2
  t140 = t138 * t134
  t142 = t138 * t136
  t144 = t138 * t133
  t146 = t138 ** 2
  t148 = t146 * t133
  t150 = t146 * t134
  t152 = t146 * t136
  t154 = t146 * t140
  t156 = t146 * t138
  t158 = t146 * t144
  t160 = t146 * t142
  t162 = t146 ** 2
  t164 = -0.38916037779196815968155860900878906250000000000000e0 * t134 + 0.52755620115589800943434238433837890625000000000000e0 * t136 - 0.69459735177638985467255115509033203125000000000000e0 * t138 + 0.30542034959315850167691707611083984375000000000000e2 * t140 + 0.86005730499279641302996873855590820312500000000000e2 * t142 - 0.72975787893717136018618941307067871093750000000000e1 * t144 - 0.44233229018433803621149957180023193359375000000000e3 * t146 - 0.61754786104528599733290821313858032226562500000000e3 * t148 + 0.37835396407252402359200346469879150390625000000000e4 * t150 + 0.22748997850816485208791106939315795898437500000000e4 * t152 + 0.70504541869034010050971341133117675781250000000000e5 * t154 - 0.20148245175625047025563767552375793457031250000000e5 * t156 - 0.2810240180568462991258881986141204833984375000000e4 * t158 - 0.10276426607863824396951162815093994140625000000000e5 * t160 - 0.16837084139014120539123347103595733642578125000000e6 * t162
  t165 = t162 * t136
  t167 = t162 * t133
  t169 = t162 * t138
  t171 = t162 * t134
  t173 = t162 * t140
  t175 = t162 * t144
  t177 = t162 * t146
  t179 = t162 * t148
  t181 = t162 * t142
  t183 = t162 * t152
  t185 = t162 * t150
  t189 = t162 * t156
  t192 = 0.11313514630621233134023547172546386718750000000000e1 - 0.12981481812794983921641696989536285400390625000000e6 * t165 + 0.56174007979372666952880866825580596923828125000000e5 * t167 - 0.32352403136049329184315676152706146240234375000000e6 * t169 + 0.27967048856303053872440291047096252441406250000000e6 * t171 + 0.25589479526235334610627921819686889648437500000000e6 * t173 + 0.18078200670879145335944073647260665893554687500000e6 * t175 - 0.13204466182182150467548430263996124267578125000000e6 * t177 + 0.90365611108522808258607082664966583251953125000000e5 * t179 - 0.16114215399846280594696041941642761230468750000000e6 * t181 - 0.29150193011493262291916212439537048339843750000000e5 * t183 + 0.40074935854432390114256376028060913085937500000000e5 * t185 + 0.41355861880146538749944016337394714355468750000000e4 * t162 * t158 - 0.54277774626371860319706052541732788085937500000000e4 * t189 + 0.37534251004296526982262730598449707031250000000000e-1 * t131
  t193 = t164 + t192
  t197 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t119 * t193)
  t198 = t6 ** 2
  t200 = t16 / t198
  t201 = t7 - t200
  t202 = f.my_piecewise5(t10, 0, t14, 0, t201)
  t205 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t202)
  t210 = t26 ** 2
  t211 = 0.1e1 / t210
  t215 = t5 * t25 * t211 * t107 / 0.8e1
  t221 = t33 * s0 / t36 / t34 / r0 * t43
  t223 = t28 ** 2
  t226 = t223 / t30 / t29
  t227 = s0 ** 2
  t228 = t34 ** 2
  t233 = t42 ** 2
  t234 = 0.1e1 / t233
  t236 = t226 * t227 / t35 / t228 / t34 * t234
  t238 = -0.2e1 / 0.9e1 * t221 + t236 / 0.108e3
  t269 = 0.10419483322152421429706657767295837402343750000000e7 * t93 * t238 + 0.22591402777130702064651770666241645812988281250000e7 * t95 * t238 - 0.31690718837237161122116232633590698242187500000000e7 * t89 * t238 - 0.37062695419646445367800896465778350830078125000000e7 * t85 * t238 + 0.37964221408846205205482554659247398376464843750000e7 * t87 * t238 + 0.56296854957717736143381428003311157226562500000000e7 * t91 * t238 - 0.64704806272098658368631352305412292480468750000000e7 * t83 * t238 - 0.24664815444310469451119224280118942260742187500000e7 * t81 * t238 + 0.95495813564933533819897473603487014770507812500000e6 * t74 * t238 + 0.50340687941345496970392523884773254394531250000000e7 * t79 * t238 - 0.26939334622422592862597355365753173828125000000000e7 * t70 * t238 + 0.98706358616647614071359877586364746093750000000000e6 * t66 * t238 - 0.15414639911795736595426744222640991210937500000000e6 * t76 * t238 - 0.24177894210750056430676521062850952148437500000000e6 * t68 * t238 - 0.36533122347390018886365465819835662841796875000000e5 * t72 * t238
  t298 = 0.25023897635898133729670217633247375488281250000000e5 * t60 * t238 - 0.55579307494075739759961739182472229003906250000000e4 * t57 * t238 + 0.37835396407252402359200346469879150390625000000000e5 * t64 * t238 + 0.60204011349495748912097811698913574218750000000000e3 * t55 * t238 - 0.35386583214747042896919965744018554687500000000000e4 * t62 * t238 - 0.27783894071055594186902046203613281250000000000000e1 * t49 * t238 - 0.36487893946858568009309470653533935546875000000000e2 * t52 * t238 + 0.18325220975589510100615024566650390625000000000000e3 * t53 * t238 - 0.77832075558393631936311721801757812500000000000000e0 * t47 * t238 + 0.15826686034676940283030271530151367187500000000000e1 * t48 * t238 + 0.11993199945242496237483764737844467163085937500000e6 * t99 * t238 - 0.15197776895384120889517694711685180664062500000000e6 * t101 * t238 - 0.78705521131031808188173773586750030517578125000000e6 * t97 * t238 - 0.10009133601145740528603394826253255208333333333333e0 * t221 + 0.41704723338107252202514145109388563368055555555556e-2 * t236
  t304 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t205 * t26 * t107 - t215 - 0.3e1 / 0.8e1 * t5 * t27 * (t269 + t298))
  t306 = f.my_piecewise5(t14, 0, t10, 0, -t201)
  t309 = f.my_piecewise3(t115, 0, 0.4e1 / 0.3e1 * t116 * t306)
  t317 = t5 * t118 * t211 * t193 / 0.8e1
  t319 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t309 * t26 * t193 - t317)
  vrho_0_ = t111 + t197 + t6 * (t304 + t319)
  t322 = -t7 - t200
  t323 = f.my_piecewise5(t10, 0, t14, 0, t322)
  t326 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t323)
  t332 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t326 * t26 * t107 - t215)
  t334 = f.my_piecewise5(t14, 0, t10, 0, -t322)
  t337 = f.my_piecewise3(t115, 0, 0.4e1 / 0.3e1 * t116 * t334)
  t347 = t33 * s2 / t122 / t120 / r1 * t129
  t349 = s2 ** 2
  t350 = t120 ** 2
  t355 = t128 ** 2
  t356 = 0.1e1 / t355
  t358 = t226 * t349 / t121 / t350 / t120 * t356
  t362 = -0.2e1 / 0.9e1 * t347 + t358 / 0.108e3
  t389 = -0.10009133601145740528603394826253255208333333333333e0 * t347 + 0.41704723338107252202514145109388563368055555555556e-2 * t358 - 0.64704806272098658368631352305412292480468750000000e7 * t165 * t362 + 0.50340687941345496970392523884773254394531250000000e7 * t167 * t362 - 0.24664815444310469451119224280118942260742187500000e7 * t171 * t362 + 0.95495813564933533819897473603487014770507812500000e6 * t162 * t362 - 0.15414639911795736595426744222640991210937500000000e6 * t154 * t362 - 0.26939334622422592862597355365753173828125000000000e7 * t160 * t362 - 0.36533122347390018886365465819835662841796875000000e5 * t156 * t362 + 0.98706358616647614071359877586364746093750000000000e6 * t158 * t362 - 0.24177894210750056430676521062850952148437500000000e6 * t152 * t362 + 0.37835396407252402359200346469879150390625000000000e5 * t148 * t362 + 0.25023897635898133729670217633247375488281250000000e5 * t150 * t362 - 0.35386583214747042896919965744018554687500000000000e4 * t142 * t362 - 0.55579307494075739759961739182472229003906250000000e4 * t146 * t362
  t420 = -0.36487893946858568009309470653533935546875000000000e2 * t138 * t362 + 0.18325220975589510100615024566650390625000000000000e3 * t144 * t362 + 0.60204011349495748912097811698913574218750000000000e3 * t140 * t362 + 0.15826686034676940283030271530151367187500000000000e1 * t134 * t362 - 0.27783894071055594186902046203613281250000000000000e1 * t136 * t362 - 0.77832075558393631936311721801757812500000000000000e0 * t133 * t362 + 0.11993199945242496237483764737844467163085937500000e6 * t189 * t362 - 0.15197776895384120889517694711685180664062500000000e6 * t183 * t362 - 0.78705521131031808188173773586750030517578125000000e6 * t185 * t362 + 0.10419483322152421429706657767295837402343750000000e7 * t179 * t362 + 0.22591402777130702064651770666241645812988281250000e7 * t177 * t362 - 0.37062695419646445367800896465778350830078125000000e7 * t173 * t362 - 0.31690718837237161122116232633590698242187500000000e7 * t181 * t362 + 0.56296854957717736143381428003311157226562500000000e7 * t175 * t362 + 0.37964221408846205205482554659247398376464843750000e7 * t169 * t362
  t426 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t337 * t26 * t193 - t317 - 0.3e1 / 0.8e1 * t5 * t119 * (t389 + t420))
  vrho_1_ = t111 + t197 + t6 * (t332 + t426)
  t430 = t33 * t38 * t43
  t437 = t226 * s0 / t35 / t228 / r0 * t234
  t441 = t430 / 0.12e2 - t437 / 0.288e3
  t468 = 0.37534251004296526982262730598449707031250000000000e-1 * t430 - 0.15639271251790219575942804416020711263020833333333e-2 * t437 + 0.10419483322152421429706657767295837402343750000000e7 * t93 * t441 + 0.22591402777130702064651770666241645812988281250000e7 * t95 * t441 - 0.31690718837237161122116232633590698242187500000000e7 * t89 * t441 - 0.37062695419646445367800896465778350830078125000000e7 * t85 * t441 + 0.37964221408846205205482554659247398376464843750000e7 * t87 * t441 + 0.56296854957717736143381428003311157226562500000000e7 * t91 * t441 - 0.64704806272098658368631352305412292480468750000000e7 * t83 * t441 - 0.24664815444310469451119224280118942260742187500000e7 * t81 * t441 + 0.95495813564933533819897473603487014770507812500000e6 * t74 * t441 + 0.50340687941345496970392523884773254394531250000000e7 * t79 * t441 - 0.26939334622422592862597355365753173828125000000000e7 * t70 * t441 + 0.98706358616647614071359877586364746093750000000000e6 * t66 * t441 - 0.15414639911795736595426744222640991210937500000000e6 * t76 * t441
  t499 = -0.24177894210750056430676521062850952148437500000000e6 * t68 * t441 - 0.36533122347390018886365465819835662841796875000000e5 * t72 * t441 + 0.25023897635898133729670217633247375488281250000000e5 * t60 * t441 - 0.55579307494075739759961739182472229003906250000000e4 * t57 * t441 + 0.37835396407252402359200346469879150390625000000000e5 * t64 * t441 + 0.60204011349495748912097811698913574218750000000000e3 * t55 * t441 - 0.35386583214747042896919965744018554687500000000000e4 * t62 * t441 - 0.27783894071055594186902046203613281250000000000000e1 * t49 * t441 - 0.36487893946858568009309470653533935546875000000000e2 * t52 * t441 + 0.18325220975589510100615024566650390625000000000000e3 * t53 * t441 - 0.77832075558393631936311721801757812500000000000000e0 * t47 * t441 + 0.15826686034676940283030271530151367187500000000000e1 * t48 * t441 + 0.11993199945242496237483764737844467163085937500000e6 * t99 * t441 - 0.15197776895384120889517694711685180664062500000000e6 * t101 * t441 - 0.78705521131031808188173773586750030517578125000000e6 * t97 * t441
  t504 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t468 + t499))
  vsigma_0_ = t6 * t504
  vsigma_1_ = 0.0e0
  t506 = t33 * t124 * t129
  t513 = t226 * s2 / t121 / t350 / r1 * t356
  t515 = t506 / 0.12e2 - t513 / 0.288e3
  t546 = -0.36533122347390018886365465819835662841796875000000e5 * t156 * t515 + 0.98706358616647614071359877586364746093750000000000e6 * t158 * t515 - 0.24177894210750056430676521062850952148437500000000e6 * t152 * t515 + 0.37835396407252402359200346469879150390625000000000e5 * t148 * t515 + 0.25023897635898133729670217633247375488281250000000e5 * t150 * t515 - 0.35386583214747042896919965744018554687500000000000e4 * t142 * t515 - 0.55579307494075739759961739182472229003906250000000e4 * t146 * t515 - 0.27783894071055594186902046203613281250000000000000e1 * t136 * t515 - 0.77832075558393631936311721801757812500000000000000e0 * t133 * t515 + 0.11993199945242496237483764737844467163085937500000e6 * t189 * t515 - 0.15197776895384120889517694711685180664062500000000e6 * t183 * t515 - 0.78705521131031808188173773586750030517578125000000e6 * t185 * t515 + 0.10419483322152421429706657767295837402343750000000e7 * t179 * t515 + 0.22591402777130702064651770666241645812988281250000e7 * t177 * t515 - 0.37062695419646445367800896465778350830078125000000e7 * t173 * t515
  t575 = -0.31690718837237161122116232633590698242187500000000e7 * t181 * t515 + 0.56296854957717736143381428003311157226562500000000e7 * t175 * t515 + 0.37964221408846205205482554659247398376464843750000e7 * t169 * t515 - 0.64704806272098658368631352305412292480468750000000e7 * t165 * t515 + 0.50340687941345496970392523884773254394531250000000e7 * t167 * t515 - 0.24664815444310469451119224280118942260742187500000e7 * t171 * t515 + 0.95495813564933533819897473603487014770507812500000e6 * t162 * t515 - 0.15414639911795736595426744222640991210937500000000e6 * t154 * t515 - 0.26939334622422592862597355365753173828125000000000e7 * t160 * t515 + 0.37534251004296526982262730598449707031250000000000e-1 * t506 - 0.15639271251790219575942804416020711263020833333333e-2 * t513 - 0.36487893946858568009309470653533935546875000000000e2 * t138 * t515 + 0.18325220975589510100615024566650390625000000000000e3 * t144 * t515 + 0.60204011349495748912097811698913574218750000000000e3 * t140 * t515 + 0.15826686034676940283030271530151367187500000000000e1 * t134 * t515
  t580 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t119 * (t546 + t575))
  vsigma_2_ = t6 * t580
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  beefvdw_coeffs = np.array([np.nan, 1.516501714, 0.4413532099, -0.09182135241, -0.02352754331, 0.03418828455, 0.002411870076, -0.01416381352, 0.0006975895581, 0.009859205137, -0.006737855051, -0.001573330824, 0.005036146253, -0.002569472453, -0.0009874953976, 0.002033722895, -0.0008018718848, -0.0006688078723, 0.001030936331, -0.000367383866, -0.0004213635394, 0.0005761607992, -8.346503735e-05, -0.0004458447585, 0.0004601290092, -5.231775398e-06, -0.0004239570471, 0.0003750190679, 2.114938125e-05, -0.0001904911565, 7.384362421e-05], dtype=np.float64)

  beefvdw_k = 4

  beefvdw_xi = lambda p: 2 * p / (beefvdw_k + p) - 1

  beefvdw_f = lambda x: jnp.sum(jnp.array([beefvdw_coeffs[i] * P(i - 1, beefvdw_xi(X2S ** 2 * x ** 2)) for i in range(1, 30 + 1)]), axis=0)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, beefvdw_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = t20 / t23
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t38 = 0.4e1 + t25 * s0 * t28 * t32 / 0.24e2
  t39 = 0.1e1 / t38
  t40 = t28 * t32 * t39
  t41 = t26 * t40
  t43 = t41 / 0.12e2 - 0.1e1
  t44 = t43 ** 2
  t45 = t44 ** 2
  t46 = t45 * t43
  t47 = t45 ** 2
  t48 = t47 * t46
  t50 = t47 * t45
  t52 = t47 * t44
  t54 = t44 * t43
  t55 = t47 * t54
  t57 = t47 * t43
  t59 = t45 * t54
  t62 = t45 * t44
  t67 = t47 ** 2
  t71 = t67 * t50
  t73 = t67 * t52
  t75 = -0.2810240180568462991258881986141204833984375000000e4 * t48 - 0.20148245175625047025563767552375793457031250000000e5 * t50 + 0.37835396407252402359200346469879150390625000000000e4 * t52 + 0.22748997850816485208791106939315795898437500000000e4 * t55 - 0.61754786104528599733290821313858032226562500000000e3 * t57 + 0.86005730499279641302996873855590820312500000000000e2 * t59 - 0.44233229018433803621149957180023193359375000000000e3 * t47 + 0.30542034959315850167691707611083984375000000000000e2 * t62 - 0.69459735177638985467255115509033203125000000000000e0 * t45 - 0.72975787893717136018618941307067871093750000000000e1 * t46 + 0.52755620115589800943434238433837890625000000000000e0 * t54 + 0.41355861880146538749944016337394714355468750000000e4 * t67 * t48 - 0.38916037779196815968155860900878906250000000000000e0 * t44 - 0.54277774626371860319706052541732788085937500000000e4 * t71 + 0.40074935854432390114256376028060913085937500000000e5 * t73
  t76 = t67 * t55
  t78 = t67 * t57
  t80 = t67 * t59
  t82 = t67 * t47
  t84 = t67 * t62
  t86 = t67 * t45
  t88 = t67 * t46
  t90 = t67 * t54
  t92 = t67 * t43
  t94 = t67 * t44
  t97 = t47 * t62
  t99 = t47 * t59
  t102 = 0.11313514630621233134023547172546386718750000000000e1 - 0.29150193011493262291916212439537048339843750000000e5 * t76 + 0.90365611108522808258607082664966583251953125000000e5 * t78 - 0.16114215399846280594696041941642761230468750000000e6 * t80 - 0.13204466182182150467548430263996124267578125000000e6 * t82 + 0.25589479526235334610627921819686889648437500000000e6 * t84 - 0.32352403136049329184315676152706146240234375000000e6 * t86 + 0.18078200670879145335944073647260665893554687500000e6 * t88 - 0.12981481812794983921641696989536285400390625000000e6 * t90 + 0.56174007979372666952880866825580596923828125000000e5 * t92 + 0.27967048856303053872440291047096252441406250000000e6 * t94 - 0.16837084139014120539123347103595733642578125000000e6 * t67 + 0.70504541869034010050971341133117675781250000000000e5 * t97 - 0.10276426607863824396951162815093994140625000000000e5 * t99 + 0.37534251004296526982262730598449707031250000000000e-1 * t41
  t103 = t75 + t102
  t107 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t103)
  t118 = t26 * t28 / t30 / t29 / r0 * t39
  t120 = t20 ** 2
  t123 = t120 / t22 / t21
  t124 = s0 ** 2
  t126 = t29 ** 2
  t131 = t38 ** 2
  t132 = 0.1e1 / t131
  t134 = t123 * t124 * t27 / t18 / t126 / t29 * t132
  t136 = -0.2e1 / 0.9e1 * t118 + t134 / 0.54e2
  t167 = -0.55579307494075739759961739182472229003906250000000e4 * t47 * t136 + 0.37835396407252402359200346469879150390625000000000e5 * t57 * t136 + 0.25023897635898133729670217633247375488281250000000e5 * t52 * t136 - 0.24177894210750056430676521062850952148437500000000e6 * t55 * t136 - 0.36533122347390018886365465819835662841796875000000e5 * t50 * t136 - 0.64704806272098658368631352305412292480468750000000e7 * t90 * t136 + 0.37964221408846205205482554659247398376464843750000e7 * t86 * t136 + 0.56296854957717736143381428003311157226562500000000e7 * t88 * t136 - 0.37062695419646445367800896465778350830078125000000e7 * t84 * t136 - 0.31690718837237161122116232633590698242187500000000e7 * t80 * t136 + 0.22591402777130702064651770666241645812988281250000e7 * t82 * t136 + 0.10419483322152421429706657767295837402343750000000e7 * t78 * t136 - 0.78705521131031808188173773586750030517578125000000e6 * t73 * t136 - 0.15197776895384120889517694711685180664062500000000e6 * t76 * t136 + 0.11993199945242496237483764737844467163085937500000e6 * t71 * t136
  t196 = -0.77832075558393631936311721801757812500000000000000e0 * t43 * t136 + 0.15826686034676940283030271530151367187500000000000e1 * t44 * t136 - 0.27783894071055594186902046203613281250000000000000e1 * t54 * t136 - 0.36487893946858568009309470653533935546875000000000e2 * t45 * t136 + 0.18325220975589510100615024566650390625000000000000e3 * t46 * t136 + 0.60204011349495748912097811698913574218750000000000e3 * t62 * t136 - 0.35386583214747042896919965744018554687500000000000e4 * t59 * t136 + 0.98706358616647614071359877586364746093750000000000e6 * t48 * t136 - 0.15414639911795736595426744222640991210937500000000e6 * t97 * t136 - 0.26939334622422592862597355365753173828125000000000e7 * t99 * t136 + 0.95495813564933533819897473603487014770507812500000e6 * t67 * t136 + 0.50340687941345496970392523884773254394531250000000e7 * t92 * t136 - 0.24664815444310469451119224280118942260742187500000e7 * t94 * t136 - 0.10009133601145740528603394826253255208333333333333e0 * t118 + 0.83409446676214504405028290218777126736111111111111e-2 * t134
  t202 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t103 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t167 + t196))
  vrho_0_ = 0.2e1 * r0 * t202 + 0.2e1 * t107
  t205 = t25 * t40
  t214 = t123 * s0 * t27 / t18 / t126 / r0 * t132
  t216 = t205 / 0.12e2 - t214 / 0.144e3
  t245 = 0.37534251004296526982262730598449707031250000000000e-1 * t205 + 0.37964221408846205205482554659247398376464843750000e7 * t86 * t216 + 0.56296854957717736143381428003311157226562500000000e7 * t88 * t216 - 0.37062695419646445367800896465778350830078125000000e7 * t84 * t216 - 0.31690718837237161122116232633590698242187500000000e7 * t80 * t216 + 0.22591402777130702064651770666241645812988281250000e7 * t82 * t216 + 0.10419483322152421429706657767295837402343750000000e7 * t78 * t216 - 0.78705521131031808188173773586750030517578125000000e6 * t73 * t216 - 0.15197776895384120889517694711685180664062500000000e6 * t76 * t216 + 0.11993199945242496237483764737844467163085937500000e6 * t71 * t216 - 0.77832075558393631936311721801757812500000000000000e0 * t43 * t216 + 0.15826686034676940283030271530151367187500000000000e1 * t44 * t216 - 0.27783894071055594186902046203613281250000000000000e1 * t54 * t216 - 0.36487893946858568009309470653533935546875000000000e2 * t45 * t216 + 0.18325220975589510100615024566650390625000000000000e3 * t46 * t216
  t275 = 0.60204011349495748912097811698913574218750000000000e3 * t62 * t216 - 0.35386583214747042896919965744018554687500000000000e4 * t59 * t216 - 0.55579307494075739759961739182472229003906250000000e4 * t47 * t216 + 0.37835396407252402359200346469879150390625000000000e5 * t57 * t216 + 0.25023897635898133729670217633247375488281250000000e5 * t52 * t216 - 0.24177894210750056430676521062850952148437500000000e6 * t55 * t216 - 0.36533122347390018886365465819835662841796875000000e5 * t50 * t216 + 0.98706358616647614071359877586364746093750000000000e6 * t48 * t216 - 0.15414639911795736595426744222640991210937500000000e6 * t97 * t216 - 0.26939334622422592862597355365753173828125000000000e7 * t99 * t216 + 0.95495813564933533819897473603487014770507812500000e6 * t67 * t216 + 0.50340687941345496970392523884773254394531250000000e7 * t92 * t216 - 0.24664815444310469451119224280118942260742187500000e7 * t94 * t216 - 0.64704806272098658368631352305412292480468750000000e7 * t90 * t216 - 0.31278542503580439151885608832041422526041666666667e-2 * t214
  t280 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t245 + t275))
  vsigma_0_ = 0.2e1 * r0 * t280
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = t27 * s0
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t39 = 0.4e1 + t27 * s0 * t30 * t33 / 0.24e2
  t40 = 0.1e1 / t39
  t41 = t30 * t33 * t40
  t42 = t28 * t41
  t44 = t42 / 0.12e2 - 0.1e1
  t45 = t44 ** 2
  t46 = t45 ** 2
  t47 = t46 ** 2
  t48 = t47 * t46
  t49 = t47 ** 2
  t50 = t49 * t48
  t52 = t46 * t44
  t53 = t47 * t52
  t56 = t45 * t44
  t57 = t47 * t56
  t58 = t49 * t57
  t60 = t47 * t44
  t61 = t49 * t60
  t63 = t47 * t45
  t64 = t49 * t63
  t66 = t49 * t47
  t68 = t46 * t45
  t69 = t49 * t68
  t71 = t46 * t56
  t72 = t49 * t71
  t74 = t49 * t52
  t76 = t49 * t56
  t78 = t49 * t46
  t80 = t49 * t45
  t83 = t49 * t44
  t85 = t47 * t71
  t87 = -0.54277774626371860319706052541732788085937500000000e4 * t50 + 0.41355861880146538749944016337394714355468750000000e4 * t49 * t53 - 0.29150193011493262291916212439537048339843750000000e5 * t58 + 0.90365611108522808258607082664966583251953125000000e5 * t61 + 0.40074935854432390114256376028060913085937500000000e5 * t64 - 0.13204466182182150467548430263996124267578125000000e6 * t66 + 0.25589479526235334610627921819686889648437500000000e6 * t69 - 0.16114215399846280594696041941642761230468750000000e6 * t72 + 0.18078200670879145335944073647260665893554687500000e6 * t74 - 0.12981481812794983921641696989536285400390625000000e6 * t76 - 0.32352403136049329184315676152706146240234375000000e6 * t78 + 0.27967048856303053872440291047096252441406250000000e6 * t80 - 0.16837084139014120539123347103595733642578125000000e6 * t49 + 0.56174007979372666952880866825580596923828125000000e5 * t83 - 0.10276426607863824396951162815093994140625000000000e5 * t85
  t89 = t47 * t68
  t103 = 0.11313514630621233134023547172546386718750000000000e1 - 0.2810240180568462991258881986141204833984375000000e4 * t53 + 0.70504541869034010050971341133117675781250000000000e5 * t89 - 0.20148245175625047025563767552375793457031250000000e5 * t48 + 0.37835396407252402359200346469879150390625000000000e4 * t63 + 0.22748997850816485208791106939315795898437500000000e4 * t57 - 0.61754786104528599733290821313858032226562500000000e3 * t60 + 0.86005730499279641302996873855590820312500000000000e2 * t71 - 0.44233229018433803621149957180023193359375000000000e3 * t47 + 0.30542034959315850167691707611083984375000000000000e2 * t68 - 0.69459735177638985467255115509033203125000000000000e0 * t46 - 0.72975787893717136018618941307067871093750000000000e1 * t52 + 0.52755620115589800943434238433837890625000000000000e0 * t56 - 0.38916037779196815968155860900878906250000000000000e0 * t45 + 0.37534251004296526982262730598449707031250000000000e-1 * t42
  t104 = t87 + t103
  t108 = t17 * t18
  t109 = t31 * r0
  t113 = t30 / t19 / t109 * t40
  t114 = t28 * t113
  t116 = t22 ** 2
  t119 = t116 / t24 / t23
  t120 = s0 ** 2
  t121 = t119 * t120
  t122 = t31 ** 2
  t125 = 0.1e1 / t18 / t122 / t31
  t127 = t39 ** 2
  t128 = 0.1e1 / t127
  t130 = t121 * t29 * t125 * t128
  t132 = -0.2e1 / 0.9e1 * t114 + t130 / 0.54e2
  t163 = -0.78705521131031808188173773586750030517578125000000e6 * t64 * t132 + 0.10419483322152421429706657767295837402343750000000e7 * t61 * t132 + 0.22591402777130702064651770666241645812988281250000e7 * t66 * t132 - 0.31690718837237161122116232633590698242187500000000e7 * t72 * t132 - 0.37062695419646445367800896465778350830078125000000e7 * t69 * t132 + 0.56296854957717736143381428003311157226562500000000e7 * t74 * t132 + 0.37964221408846205205482554659247398376464843750000e7 * t78 * t132 - 0.64704806272098658368631352305412292480468750000000e7 * t76 * t132 - 0.24664815444310469451119224280118942260742187500000e7 * t80 * t132 + 0.50340687941345496970392523884773254394531250000000e7 * t83 * t132 + 0.95495813564933533819897473603487014770507812500000e6 * t49 * t132 - 0.26939334622422592862597355365753173828125000000000e7 * t85 * t132 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t132 + 0.98706358616647614071359877586364746093750000000000e6 * t53 * t132 - 0.36533122347390018886365465819835662841796875000000e5 * t48 * t132
  t192 = -0.24177894210750056430676521062850952148437500000000e6 * t57 * t132 + 0.25023897635898133729670217633247375488281250000000e5 * t63 * t132 + 0.37835396407252402359200346469879150390625000000000e5 * t60 * t132 - 0.55579307494075739759961739182472229003906250000000e4 * t47 * t132 - 0.35386583214747042896919965744018554687500000000000e4 * t71 * t132 + 0.60204011349495748912097811698913574218750000000000e3 * t68 * t132 + 0.18325220975589510100615024566650390625000000000000e3 * t52 * t132 - 0.36487893946858568009309470653533935546875000000000e2 * t46 * t132 - 0.27783894071055594186902046203613281250000000000000e1 * t56 * t132 + 0.15826686034676940283030271530151367187500000000000e1 * t45 * t132 - 0.77832075558393631936311721801757812500000000000000e0 * t44 * t132 + 0.11993199945242496237483764737844467163085937500000e6 * t50 * t132 - 0.15197776895384120889517694711685180664062500000000e6 * t58 * t132 - 0.10009133601145740528603394826253255208333333333333e0 * t114 + 0.83409446676214504405028290218777126736111111111111e-2 * t130
  t193 = t163 + t192
  t198 = f.my_piecewise3(t2, 0, -t6 * t21 * t104 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t108 * t193)
  t209 = t132 ** 2
  t235 = t28 * t30 / t19 / t122 * t40
  t242 = t121 * t29 / t18 / t122 / t109 * t128
  t244 = t23 ** 2
  t245 = 0.1e1 / t244
  t248 = t122 ** 2
  t252 = 0.1e1 / t127 / t39
  t254 = t245 * t120 * s0 / t248 / t31 * t252
  t256 = 0.22e2 / 0.27e2 * t235 - t242 / 0.6e1 + 0.4e1 / 0.81e2 * t254
  t263 = -0.77832075558393631936311721801757812500000000000000e0 * t209 - 0.21580495876514031233597441911697387695312500000000e7 * t53 * t209 - 0.40409001933633889293896033048629760742187500000000e8 * t89 * t209 + 0.15279330170389365411183595776557922363281250000000e8 * t85 * t209 + 0.85579169500287344849667290604114532470703125000000e8 * t49 * t209 - 0.44396667799758845012014603704214096069335937500000e8 * t83 * t209 - 0.81537929923222179809161972224712371826171875000000e8 * t74 * t209 - 0.72888653325645470580867335057258605957031250000000e8 * t69 * t209 + 0.54219366665113684955164249598979949951171875000000e8 * t72 * t209 + 0.26048708305381053574266644418239593505859375000000e8 * t66 * t209 - 0.20463435494068270128925181132555007934570312500000e8 * t61 * t209 + 0.95495813564933533819897473603487014770507812500000e6 * t49 * t256 - 0.15197776895384120889517694711685180664062500000000e6 * t58 * t256 + 0.11993199945242496237483764737844467163085937500000e6 * t50 * t256
  t294 = -0.77832075558393631936311721801757812500000000000000e0 * t44 * t256 + 0.15826686034676940283030271530151367187500000000000e1 * t45 * t256 - 0.27783894071055594186902046203613281250000000000000e1 * t56 * t256 - 0.41033997617537126401697775721549987792968750000000e7 * t64 * t209 + 0.33580959846678989464954541265964508056640625000000e7 * t58 * t209 + 0.31653372069353880566060543060302734375000000000000e1 * t44 * t209 - 0.26595683631825062073744173169136047363281250000000e7 * t63 * t209 - 0.43839746816868022663638558983802795410156250000000e6 * t57 * t209 + 0.12831826620164189829276784086227416992187500000000e8 * t48 * t209 - 0.24770608250322930027843976020812988281250000000000e5 * t68 * t209 - 0.44463445995260591807969391345977783203125000000000e5 * t71 * t209 + 0.34051856766527162123280311822891235351562500000000e6 * t47 * t209 + 0.25023897635898133729670217633247375488281250000000e6 * t60 * t209 - 0.37062695419646445367800896465778350830078125000000e7 * t69 * t256 - 0.31690718837237161122116232633590698242187500000000e7 * t72 * t256
  t326 = 0.22591402777130702064651770666241645812988281250000e7 * t66 * t256 + 0.10419483322152421429706657767295837402343750000000e7 * t61 * t256 - 0.78705521131031808188173773586750030517578125000000e6 * t64 * t256 - 0.36487893946858568009309470653533935546875000000000e2 * t46 * t256 + 0.18325220975589510100615024566650390625000000000000e3 * t52 * t256 + 0.60204011349495748912097811698913574218750000000000e3 * t68 * t256 - 0.35386583214747042896919965744018554687500000000000e4 * t71 * t256 - 0.12293913191698745090039956938028335571289062500000e9 * t80 * t209 + 0.75928442817692410410965109318494796752929687500000e8 * t76 * t209 + 0.11822339541120724590110099880695343017578125000000e9 * t78 * t209 - 0.55579307494075739759961739182472229003906250000000e4 * t47 * t256 + 0.37835396407252402359200346469879150390625000000000e5 * t60 * t256 + 0.25023897635898133729670217633247375488281250000000e5 * t63 * t256 - 0.24177894210750056430676521062850952148437500000000e6 * t57 * t256 - 0.36533122347390018886365465819835662841796875000000e5 * t48 * t256
  t354 = 0.98706358616647614071359877586364746093750000000000e6 * t53 * t256 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t256 - 0.26939334622422592862597355365753173828125000000000e7 * t85 * t256 + 0.50340687941345496970392523884773254394531250000000e7 * t83 * t256 - 0.24664815444310469451119224280118942260742187500000e7 * t80 * t256 - 0.64704806272098658368631352305412292480468750000000e7 * t76 * t256 + 0.37964221408846205205482554659247398376464843750000e7 * t78 * t256 + 0.56296854957717736143381428003311157226562500000000e7 * t74 * t256 - 0.83351682213166782560706138610839843750000000000000e1 * t45 * t209 - 0.14595157578743427203723788261413574218750000000000e3 * t56 * t209 + 0.91626104877947550503075122833251953125000000000000e3 * t46 * t209 + 0.36122406809697449347258687019348144531250000000000e4 * t52 * t209 + 0.36700156537534381938212447696261935763888888888888e0 * t235 - 0.75068502008593053964525461196899414062500000000000e-1 * t242 + 0.22242519113657201174674210725007233796296296296296e-1 * t254
  t361 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t104 / 0.12e2 - t6 * t21 * t193 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t108 * (t263 + t294 + t326 + t354))
  v2rho2_0_ = 0.2e1 * r0 * t361 + 0.4e1 * t198
  t364 = t27 * t41
  t371 = t29 / t18 / t122 / r0 * t128
  t372 = t119 * s0 * t371
  t374 = t364 / 0.12e2 - t372 / 0.144e3
  t375 = t49 * t374
  t377 = t85 * t374
  t379 = t61 * t374
  t381 = t66 * t374
  t383 = t72 * t374
  t385 = t69 * t374
  t387 = t74 * t374
  t389 = t78 * t374
  t391 = t76 * t374
  t393 = t80 * t374
  t395 = t83 * t374
  t397 = t89 * t374
  t399 = t53 * t374
  t401 = t48 * t374
  t403 = t57 * t374
  t405 = 0.95495813564933533819897473603487014770507812500000e6 * t375 - 0.26939334622422592862597355365753173828125000000000e7 * t377 + 0.10419483322152421429706657767295837402343750000000e7 * t379 + 0.22591402777130702064651770666241645812988281250000e7 * t381 - 0.31690718837237161122116232633590698242187500000000e7 * t383 - 0.37062695419646445367800896465778350830078125000000e7 * t385 + 0.56296854957717736143381428003311157226562500000000e7 * t387 + 0.37964221408846205205482554659247398376464843750000e7 * t389 - 0.64704806272098658368631352305412292480468750000000e7 * t391 - 0.24664815444310469451119224280118942260742187500000e7 * t393 + 0.50340687941345496970392523884773254394531250000000e7 * t395 - 0.15414639911795736595426744222640991210937500000000e6 * t397 + 0.98706358616647614071359877586364746093750000000000e6 * t399 - 0.36533122347390018886365465819835662841796875000000e5 * t401 - 0.24177894210750056430676521062850952148437500000000e6 * t403
  t406 = t63 * t374
  t408 = t60 * t374
  t410 = t47 * t374
  t412 = t71 * t374
  t414 = t68 * t374
  t416 = t52 * t374
  t418 = t46 * t374
  t420 = t56 * t374
  t422 = t45 * t374
  t424 = t44 * t374
  t428 = t58 * t374
  t430 = t64 * t374
  t434 = 0.25023897635898133729670217633247375488281250000000e5 * t406 + 0.37835396407252402359200346469879150390625000000000e5 * t408 - 0.55579307494075739759961739182472229003906250000000e4 * t410 - 0.35386583214747042896919965744018554687500000000000e4 * t412 + 0.60204011349495748912097811698913574218750000000000e3 * t414 + 0.18325220975589510100615024566650390625000000000000e3 * t416 - 0.36487893946858568009309470653533935546875000000000e2 * t418 - 0.27783894071055594186902046203613281250000000000000e1 * t420 + 0.15826686034676940283030271530151367187500000000000e1 * t422 - 0.77832075558393631936311721801757812500000000000000e0 * t424 + 0.11993199945242496237483764737844467163085937500000e6 * t50 * t374 - 0.15197776895384120889517694711685180664062500000000e6 * t428 - 0.78705521131031808188173773586750030517578125000000e6 * t430 - 0.31278542503580439151885608832041422526041666666667e-2 * t372 + 0.37534251004296526982262730598449707031250000000000e-1 * t364
  t435 = t405 + t434
  t439 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t108 * t435)
  t446 = t119 * t29 * t125 * t128 * s0
  t448 = t27 * t113
  t455 = t245 * t120 / t248 / r0 * t252
  t457 = -0.2e1 / 0.9e1 * t448 + t446 / 0.18e2 - t455 / 0.54e2
  t484 = 0.25022834002864351321508487065633138020833333333333e-1 * t446 - 0.24664815444310469451119224280118942260742187500000e7 * t80 * t457 - 0.64704806272098658368631352305412292480468750000000e7 * t76 * t457 + 0.37964221408846205205482554659247398376464843750000e7 * t78 * t457 - 0.26939334622422592862597355365753173828125000000000e7 * t85 * t457 + 0.95495813564933533819897473603487014770507812500000e6 * t49 * t457 - 0.78705521131031808188173773586750030517578125000000e6 * t64 * t457 - 0.15197776895384120889517694711685180664062500000000e6 * t58 * t457 - 0.77832075558393631936311721801757812500000000000000e0 * t44 * t457 + 0.15826686034676940283030271530151367187500000000000e1 * t45 * t457 - 0.27783894071055594186902046203613281250000000000000e1 * t56 * t457 - 0.36487893946858568009309470653533935546875000000000e2 * t46 * t457 + 0.18325220975589510100615024566650390625000000000000e3 * t52 * t457 + 0.56296854957717736143381428003311157226562500000000e7 * t74 * t457
  t515 = -0.37062695419646445367800896465778350830078125000000e7 * t69 * t457 - 0.31690718837237161122116232633590698242187500000000e7 * t72 * t457 + 0.22591402777130702064651770666241645812988281250000e7 * t66 * t457 + 0.10419483322152421429706657767295837402343750000000e7 * t61 * t457 + 0.60204011349495748912097811698913574218750000000000e3 * t68 * t457 - 0.35386583214747042896919965744018554687500000000000e4 * t71 * t457 - 0.55579307494075739759961739182472229003906250000000e4 * t47 * t457 + 0.37835396407252402359200346469879150390625000000000e5 * t60 * t457 + 0.25023897635898133729670217633247375488281250000000e5 * t63 * t457 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t457 + 0.50340687941345496970392523884773254394531250000000e7 * t83 * t457 - 0.24177894210750056430676521062850952148437500000000e6 * t57 * t457 - 0.36533122347390018886365465819835662841796875000000e5 * t48 * t457 + 0.98706358616647614071359877586364746093750000000000e6 * t53 * t457 + 0.11993199945242496237483764737844467163085937500000e6 * t50 * t457
  t546 = -0.77832075558393631936311721801757812500000000000000e0 * t132 * t374 - 0.10009133601145740528603394826253255208333333333333e0 * t448 - 0.44463445995260591807969391345977783203125000000000e5 * t412 * t132 + 0.34051856766527162123280311822891235351562500000000e6 * t410 * t132 + 0.25023897635898133729670217633247375488281250000000e6 * t408 * t132 - 0.26595683631825062073744173169136047363281250000000e7 * t406 * t132 - 0.43839746816868022663638558983802795410156250000000e6 * t403 * t132 + 0.12831826620164189829276784086227416992187500000000e8 * t401 * t132 - 0.21580495876514031233597441911697387695312500000000e7 * t399 * t132 + 0.85579169500287344849667290604114532470703125000000e8 * t375 * t132 - 0.44396667799758845012014603704214096069335937500000e8 * t395 * t132 - 0.12293913191698745090039956938028335571289062500000e9 * t393 * t132 + 0.75928442817692410410965109318494796752929687500000e8 * t391 * t132 + 0.11822339541120724590110099880695343017578125000000e9 * t389 * t132 - 0.81537929923222179809161972224712371826171875000000e8 * t387 * t132
  t576 = -0.72888653325645470580867335057258605957031250000000e8 * t385 * t132 + 0.54219366665113684955164249598979949951171875000000e8 * t383 * t132 + 0.26048708305381053574266644418239593505859375000000e8 * t381 * t132 - 0.40409001933633889293896033048629760742187500000000e8 * t397 * t132 + 0.15279330170389365411183595776557922363281250000000e8 * t377 * t132 - 0.20463435494068270128925181132555007934570312500000e8 * t379 * t132 - 0.41033997617537126401697775721549987792968750000000e7 * t430 * t132 + 0.33580959846678989464954541265964508056640625000000e7 * t428 * t132 + 0.31653372069353880566060543060302734375000000000000e1 * t424 * t132 - 0.83351682213166782560706138610839843750000000000000e1 * t422 * t132 - 0.14595157578743427203723788261413574218750000000000e3 * t420 * t132 + 0.91626104877947550503075122833251953125000000000000e3 * t418 * t132 + 0.36122406809697449347258687019348144531250000000000e4 * t416 * t132 - 0.24770608250322930027843976020812988281250000000000e5 * t414 * t132 - 0.83409446676214504405028290218777126736111111111112e-2 * t455
  t583 = f.my_piecewise3(t2, 0, -t6 * t21 * t435 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t108 * (t484 + t515 + t546 + t576))
  v2rhosigma_0_ = 0.2e1 * r0 * t583 + 0.2e1 * t439
  t586 = t374 ** 2
  t588 = t119 * t371
  t614 = -0.77832075558393631936311721801757812500000000000000e0 * t586 - 0.62557085007160878303771217664082845052083333333334e-2 * t588 - 0.40409001933633889293896033048629760742187500000000e8 * t89 * t586 + 0.15279330170389365411183595776557922363281250000000e8 * t85 * t586 - 0.20463435494068270128925181132555007934570312500000e8 * t61 * t586 - 0.41033997617537126401697775721549987792968750000000e7 * t64 * t586 + 0.33580959846678989464954541265964508056640625000000e7 * t58 * t586 + 0.31653372069353880566060543060302734375000000000000e1 * t44 * t586 - 0.83351682213166782560706138610839843750000000000000e1 * t45 * t586 + 0.36122406809697449347258687019348144531250000000000e4 * t52 * t586 - 0.24770608250322930027843976020812988281250000000000e5 * t68 * t586 - 0.44463445995260591807969391345977783203125000000000e5 * t71 * t586 + 0.34051856766527162123280311822891235351562500000000e6 * t47 * t586 + 0.25023897635898133729670217633247375488281250000000e6 * t60 * t586
  t623 = t245 * s0 / t248 * t252
  t625 = -t588 / 0.72e2 + t623 / 0.144e3
  t652 = -0.26595683631825062073744173169136047363281250000000e7 * t63 * t586 - 0.43839746816868022663638558983802795410156250000000e6 * t57 * t586 + 0.60204011349495748912097811698913574218750000000000e3 * t68 * t625 - 0.35386583214747042896919965744018554687500000000000e4 * t71 * t625 - 0.55579307494075739759961739182472229003906250000000e4 * t47 * t625 + 0.37835396407252402359200346469879150390625000000000e5 * t60 * t625 + 0.25023897635898133729670217633247375488281250000000e5 * t63 * t625 - 0.26939334622422592862597355365753173828125000000000e7 * t85 * t625 + 0.95495813564933533819897473603487014770507812500000e6 * t49 * t625 + 0.12831826620164189829276784086227416992187500000000e8 * t48 * t586 - 0.21580495876514031233597441911697387695312500000000e7 * t53 * t586 - 0.44396667799758845012014603704214096069335937500000e8 * t83 * t586 - 0.12293913191698745090039956938028335571289062500000e9 * t80 * t586 + 0.75928442817692410410965109318494796752929687500000e8 * t76 * t586 + 0.11822339541120724590110099880695343017578125000000e9 * t78 * t586
  t682 = -0.81537929923222179809161972224712371826171875000000e8 * t74 * t586 - 0.72888653325645470580867335057258605957031250000000e8 * t69 * t586 + 0.54219366665113684955164249598979949951171875000000e8 * t72 * t586 + 0.26048708305381053574266644418239593505859375000000e8 * t66 * t586 - 0.24664815444310469451119224280118942260742187500000e7 * t80 * t625 - 0.64704806272098658368631352305412292480468750000000e7 * t76 * t625 + 0.37964221408846205205482554659247398376464843750000e7 * t78 * t625 + 0.56296854957717736143381428003311157226562500000000e7 * t74 * t625 - 0.37062695419646445367800896465778350830078125000000e7 * t69 * t625 - 0.31690718837237161122116232633590698242187500000000e7 * t72 * t625 + 0.22591402777130702064651770666241645812988281250000e7 * t66 * t625 - 0.14595157578743427203723788261413574218750000000000e3 * t56 * t586 + 0.91626104877947550503075122833251953125000000000000e3 * t46 * t586 + 0.10419483322152421429706657767295837402343750000000e7 * t61 * t625
  t712 = -0.15197776895384120889517694711685180664062500000000e6 * t58 * t625 + 0.11993199945242496237483764737844467163085937500000e6 * t50 * t625 - 0.77832075558393631936311721801757812500000000000000e0 * t44 * t625 + 0.15826686034676940283030271530151367187500000000000e1 * t45 * t625 - 0.27783894071055594186902046203613281250000000000000e1 * t56 * t625 - 0.36487893946858568009309470653533935546875000000000e2 * t46 * t625 + 0.18325220975589510100615024566650390625000000000000e3 * t52 * t625 - 0.78705521131031808188173773586750030517578125000000e6 * t64 * t625 + 0.85579169500287344849667290604114532470703125000000e8 * t49 * t586 - 0.24177894210750056430676521062850952148437500000000e6 * t57 * t625 - 0.36533122347390018886365465819835662841796875000000e5 * t48 * t625 + 0.98706358616647614071359877586364746093750000000000e6 * t53 * t625 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t625 + 0.50340687941345496970392523884773254394531250000000e7 * t83 * t625 + 0.31278542503580439151885608832041422526041666666667e-2 * t623
  t718 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t108 * (t614 + t652 + t682 + t712))
  v2sigma2_0_ = 0.2e1 * r0 * t718
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = t28 * s0
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t40 = 0.4e1 + t28 * s0 * t31 * t34 / 0.24e2
  t41 = 0.1e1 / t40
  t43 = t29 * t31 * t34 * t41
  t45 = t43 / 0.12e2 - 0.1e1
  t46 = t45 ** 2
  t47 = t46 ** 2
  t48 = t47 * t45
  t49 = t47 ** 2
  t50 = t49 * t48
  t51 = t49 ** 2
  t54 = t49 * t47
  t55 = t51 * t54
  t57 = t49 * t46
  t58 = t51 * t57
  t60 = t46 * t45
  t61 = t49 * t60
  t62 = t51 * t61
  t64 = t51 * t49
  t66 = t49 * t45
  t67 = t51 * t66
  t69 = t47 * t60
  t70 = t51 * t69
  t72 = t51 * t48
  t74 = t47 * t46
  t75 = t51 * t74
  t77 = t51 * t47
  t79 = t51 * t46
  t81 = t51 * t60
  t83 = t51 * t45
  t85 = t49 * t69
  t88 = 0.41355861880146538749944016337394714355468750000000e4 * t51 * t50 - 0.54277774626371860319706052541732788085937500000000e4 * t55 + 0.40074935854432390114256376028060913085937500000000e5 * t58 - 0.29150193011493262291916212439537048339843750000000e5 * t62 - 0.13204466182182150467548430263996124267578125000000e6 * t64 + 0.90365611108522808258607082664966583251953125000000e5 * t67 - 0.16114215399846280594696041941642761230468750000000e6 * t70 + 0.18078200670879145335944073647260665893554687500000e6 * t72 + 0.25589479526235334610627921819686889648437500000000e6 * t75 - 0.32352403136049329184315676152706146240234375000000e6 * t77 + 0.27967048856303053872440291047096252441406250000000e6 * t79 - 0.12981481812794983921641696989536285400390625000000e6 * t81 + 0.56174007979372666952880866825580596923828125000000e5 * t83 - 0.10276426607863824396951162815093994140625000000000e5 * t85 - 0.16837084139014120539123347103595733642578125000000e6 * t51
  t89 = t49 * t74
  t104 = 0.11313514630621233134023547172546386718750000000000e1 + 0.70504541869034010050971341133117675781250000000000e5 * t89 - 0.20148245175625047025563767552375793457031250000000e5 * t54 - 0.2810240180568462991258881986141204833984375000000e4 * t50 + 0.22748997850816485208791106939315795898437500000000e4 * t61 - 0.61754786104528599733290821313858032226562500000000e3 * t66 + 0.37835396407252402359200346469879150390625000000000e4 * t57 - 0.44233229018433803621149957180023193359375000000000e3 * t49 + 0.30542034959315850167691707611083984375000000000000e2 * t74 + 0.86005730499279641302996873855590820312500000000000e2 * t69 - 0.72975787893717136018618941307067871093750000000000e1 * t48 + 0.52755620115589800943434238433837890625000000000000e0 * t60 - 0.69459735177638985467255115509033203125000000000000e0 * t47 - 0.38916037779196815968155860900878906250000000000000e0 * t46 + 0.37534251004296526982262730598449707031250000000000e-1 * t43
  t105 = t88 + t104
  t110 = t17 / t19
  t111 = t32 * r0
  t116 = t29 * t31 / t19 / t111 * t41
  t118 = t23 ** 2
  t122 = s0 ** 2
  t123 = t118 / t25 / t24 * t122
  t124 = t32 ** 2
  t129 = t40 ** 2
  t130 = 0.1e1 / t129
  t132 = t123 * t30 / t18 / t124 / t32 * t130
  t136 = -0.2e1 / 0.9e1 * t116 + t132 / 0.54e2
  t163 = -0.10009133601145740528603394826253255208333333333333e0 * t116 + 0.83409446676214504405028290218777126736111111111111e-2 * t132 + 0.98706358616647614071359877586364746093750000000000e6 * t50 * t136 - 0.36533122347390018886365465819835662841796875000000e5 * t54 * t136 - 0.24177894210750056430676521062850952148437500000000e6 * t61 * t136 + 0.25023897635898133729670217633247375488281250000000e5 * t57 * t136 + 0.37835396407252402359200346469879150390625000000000e5 * t66 * t136 - 0.55579307494075739759961739182472229003906250000000e4 * t49 * t136 - 0.35386583214747042896919965744018554687500000000000e4 * t69 * t136 + 0.60204011349495748912097811698913574218750000000000e3 * t74 * t136 + 0.10419483322152421429706657767295837402343750000000e7 * t67 * t136 + 0.22591402777130702064651770666241645812988281250000e7 * t64 * t136 - 0.31690718837237161122116232633590698242187500000000e7 * t70 * t136 + 0.18325220975589510100615024566650390625000000000000e3 * t48 * t136 - 0.36487893946858568009309470653533935546875000000000e2 * t47 * t136
  t166 = t46 * t136
  t168 = t45 * t136
  t172 = t62 * t136
  t174 = t58 * t136
  t194 = -0.27783894071055594186902046203613281250000000000000e1 * t60 * t136 + 0.15826686034676940283030271530151367187500000000000e1 * t166 - 0.77832075558393631936311721801757812500000000000000e0 * t168 + 0.11993199945242496237483764737844467163085937500000e6 * t55 * t136 - 0.15197776895384120889517694711685180664062500000000e6 * t172 - 0.78705521131031808188173773586750030517578125000000e6 * t174 - 0.37062695419646445367800896465778350830078125000000e7 * t75 * t136 + 0.56296854957717736143381428003311157226562500000000e7 * t72 * t136 + 0.37964221408846205205482554659247398376464843750000e7 * t77 * t136 - 0.64704806272098658368631352305412292480468750000000e7 * t81 * t136 - 0.24664815444310469451119224280118942260742187500000e7 * t79 * t136 + 0.50340687941345496970392523884773254394531250000000e7 * t83 * t136 + 0.95495813564933533819897473603487014770507812500000e6 * t51 * t136 - 0.26939334622422592862597355365753173828125000000000e7 * t85 * t136 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t136
  t195 = t163 + t194
  t199 = t17 * t18
  t200 = t24 ** 2
  t201 = 0.1e1 / t200
  t203 = t201 * t122 * s0
  t204 = t124 ** 2
  t208 = 0.1e1 / t129 / t40
  t210 = t203 / t204 / t32 * t208
  t216 = t29 * t31 / t19 / t124 * t41
  t223 = t123 * t30 / t18 / t124 / t111 * t130
  t225 = t136 ** 2
  t230 = 0.22e2 / 0.27e2 * t216 - t223 / 0.6e1 + 0.4e1 / 0.81e2 * t210
  t235 = t60 * t230
  t251 = 0.22242519113657201174674210725007233796296296296296e-1 * t210 + 0.36700156537534381938212447696261935763888888888888e0 * t216 - 0.75068502008593053964525461196899414062500000000000e-1 * t223 - 0.77832075558393631936311721801757812500000000000000e0 * t225 - 0.77832075558393631936311721801757812500000000000000e0 * t45 * t230 + 0.15826686034676940283030271530151367187500000000000e1 * t46 * t230 - 0.27783894071055594186902046203613281250000000000000e1 * t235 - 0.20463435494068270128925181132555007934570312500000e8 * t67 * t225 - 0.41033997617537126401697775721549987792968750000000e7 * t58 * t225 + 0.33580959846678989464954541265964508056640625000000e7 * t62 * t225 + 0.31653372069353880566060543060302734375000000000000e1 * t45 * t225 + 0.25023897635898133729670217633247375488281250000000e6 * t66 * t225 - 0.26595683631825062073744173169136047363281250000000e7 * t57 * t225 - 0.43839746816868022663638558983802795410156250000000e6 * t61 * t225
  t262 = t67 * t230
  t264 = t47 * t230
  t266 = t48 * t230
  t268 = t74 * t230
  t270 = t69 * t230
  t272 = t49 * t230
  t274 = t66 * t230
  t282 = 0.12831826620164189829276784086227416992187500000000e8 * t54 * t225 - 0.21580495876514031233597441911697387695312500000000e7 * t50 * t225 - 0.40409001933633889293896033048629760742187500000000e8 * t89 * t225 + 0.15279330170389365411183595776557922363281250000000e8 * t85 * t225 + 0.85579169500287344849667290604114532470703125000000e8 * t51 * t225 + 0.10419483322152421429706657767295837402343750000000e7 * t262 - 0.36487893946858568009309470653533935546875000000000e2 * t264 + 0.18325220975589510100615024566650390625000000000000e3 * t266 + 0.60204011349495748912097811698913574218750000000000e3 * t268 - 0.35386583214747042896919965744018554687500000000000e4 * t270 - 0.55579307494075739759961739182472229003906250000000e4 * t272 + 0.37835396407252402359200346469879150390625000000000e5 * t274 - 0.44396667799758845012014603704214096069335937500000e8 * t83 * t225 - 0.12293913191698745090039956938028335571289062500000e9 * t79 * t225 + 0.75928442817692410410965109318494796752929687500000e8 * t81 * t225
  t300 = t51 * t230
  t302 = t83 * t230
  t304 = t79 * t230
  t306 = t81 * t230
  t308 = t77 * t230
  t310 = t72 * t230
  t314 = 0.11822339541120724590110099880695343017578125000000e9 * t77 * t225 - 0.81537929923222179809161972224712371826171875000000e8 * t72 * t225 - 0.72888653325645470580867335057258605957031250000000e8 * t75 * t225 + 0.54219366665113684955164249598979949951171875000000e8 * t70 * t225 + 0.26048708305381053574266644418239593505859375000000e8 * t64 * t225 - 0.15197776895384120889517694711685180664062500000000e6 * t62 * t230 + 0.11993199945242496237483764737844467163085937500000e6 * t55 * t230 - 0.78705521131031808188173773586750030517578125000000e6 * t58 * t230 + 0.95495813564933533819897473603487014770507812500000e6 * t300 + 0.50340687941345496970392523884773254394531250000000e7 * t302 - 0.24664815444310469451119224280118942260742187500000e7 * t304 - 0.64704806272098658368631352305412292480468750000000e7 * t306 + 0.37964221408846205205482554659247398376464843750000e7 * t308 + 0.56296854957717736143381428003311157226562500000000e7 * t310 - 0.83351682213166782560706138610839843750000000000000e1 * t46 * t225
  t327 = t75 * t230
  t329 = t70 * t230
  t331 = t64 * t230
  t333 = t57 * t230
  t335 = t61 * t230
  t337 = t54 * t230
  t339 = t50 * t230
  t341 = t89 * t230
  t343 = t85 * t230
  t345 = -0.14595157578743427203723788261413574218750000000000e3 * t60 * t225 + 0.91626104877947550503075122833251953125000000000000e3 * t47 * t225 + 0.36122406809697449347258687019348144531250000000000e4 * t48 * t225 - 0.24770608250322930027843976020812988281250000000000e5 * t74 * t225 - 0.44463445995260591807969391345977783203125000000000e5 * t69 * t225 + 0.34051856766527162123280311822891235351562500000000e6 * t49 * t225 - 0.37062695419646445367800896465778350830078125000000e7 * t327 - 0.31690718837237161122116232633590698242187500000000e7 * t329 + 0.22591402777130702064651770666241645812988281250000e7 * t331 + 0.25023897635898133729670217633247375488281250000000e5 * t333 - 0.24177894210750056430676521062850952148437500000000e6 * t335 - 0.36533122347390018886365465819835662841796875000000e5 * t337 + 0.98706358616647614071359877586364746093750000000000e6 * t339 - 0.15414639911795736595426744222640991210937500000000e6 * t341 - 0.26939334622422592862597355365753173828125000000000e7 * t343
  t347 = t251 + t282 + t314 + t345
  t352 = f.my_piecewise3(t2, 0, t6 * t22 * t105 / 0.12e2 - t6 * t110 * t195 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t199 * t347)
  t367 = t203 / t204 / t111 * t208
  t369 = t122 ** 2
  t371 = t124 * r0
  t376 = t129 ** 2
  t381 = t201 * t369 / t19 / t204 / t371 / t376 * t23 * t27 * t31
  t387 = t29 * t31 / t19 / t371 * t41
  t393 = t123 * t30 / t18 / t204 * t130
  t395 = t225 * t136
  t414 = -0.308e3 / 0.81e2 * t387 + 0.341e3 / 0.243e3 * t393 - 0.76e2 / 0.81e2 * t367 + 0.4e1 / 0.243e3 * t381
  t435 = 0.22521507872308320356703195869922637939453125000000e7 * t49 * t395 + 0.95495813564933533819897473603487014770507812500000e6 * t51 * t414 - 0.78705521131031808188173773586750030517578125000000e6 * t58 * t414 - 0.26939334622422592862597355365753173828125000000000e7 * t85 * t414 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t414 + 0.98706358616647614071359877586364746093750000000000e6 * t50 * t414 - 0.36533122347390018886365465819835662841796875000000e5 * t54 * t414 - 0.24177894210750056430676521062850952148437500000000e6 * t61 * t414 + 0.25023897635898133729670217633247375488281250000000e5 * t57 * t414 - 0.10668839380559652864441421687602996826171875000000e9 * t67 * t395 - 0.51158588735170675322312952831387519836425781250000e9 * t64 * t395
  t459 = 0.27241485413221729698624249458312988281250000000000e7 * t69 * t395 - 0.31124412196682414265578573942184448242187500000000e6 * t74 * t395 - 0.14862364950193758016706385612487792968750000000000e6 * t48 * t395 + 0.18061203404848724673629343509674072265625000000000e5 * t47 * t395 + 0.36650441951179020201230049133300781250000000000000e4 * t60 * t395 - 0.22129043745057741162071922488451004028320312500000e10 * t83 * t395 + 0.37835396407252402359200346469879150390625000000000e5 * t66 * t414 - 0.55579307494075739759961739182472229003906250000000e4 * t49 * t414 - 0.35386583214747042896919965744018554687500000000000e4 * t69 * t414 + 0.60204011349495748912097811698913574218750000000000e3 * t74 * t414 + 0.18325220975589510100615024566650390625000000000000e3 * t48 * t414
  t482 = -0.36487893946858568009309470653533935546875000000000e2 * t47 * t414 + 0.10419483322152421429706657767295837402343750000000e7 * t67 * t414 + 0.22591402777130702064651770666241645812988281250000e7 * t64 * t414 + 0.22918995255584048116775393664836883544921875000000e9 * t89 * t395 - 0.56572602707087445011454446268081665039062500000000e9 * t50 * t395 - 0.28054644639468240603676674485206604003906250000000e8 * t54 * t395 + 0.15398191944197027795132140903472900390625000000000e9 * t61 * t395 - 0.48223721498554824930002414882183074951171875000000e7 * t57 * t395 - 0.26595683631825062073744173169136047363281250000000e8 * t66 * t395 - 0.64704806272098658368631352305412292480468750000000e7 * t81 * t414 - 0.24664815444310469451119224280118942260742187500000e7 * t79 * t414
  t507 = 0.50340687941345496970392523884773254394531250000000e7 * t83 * t414 - 0.27783894071055594186902046203613281250000000000000e1 * t60 * t414 + 0.15826686034676940283030271530151367187500000000000e1 * t46 * t414 - 0.23349622667518089580893516540527343750000000000000e1 * t136 * t230 - 0.77832075558393631936311721801757812500000000000000e0 * t45 * t414 + 0.11993199945242496237483764737844467163085937500000e6 * t55 * t414 - 0.15197776895384120889517694711685180664062500000000e6 * t62 * t414 + 0.56296854957717736143381428003311157226562500000000e7 * t72 * t414 + 0.62516899932914528578239946603775024414062500000000e9 * t70 * t395 + 0.12470454332976147539687777407765388488769531250000e10 * t75 * t395 - 0.16035503731642003527790813712596893310546875000000e10 * t72 * t395
  t530 = -0.17122965283876657759924014167189598083496093750000e10 * t77 * t395 + 0.23644679082241449180220199761390686035156250000000e10 * t81 * t395 + 0.14426404135361557978083370770514011383056640625000e10 * t79 * t395 - 0.31690718837237161122116232633590698242187500000000e7 * t70 * t414 - 0.37062695419646445367800896465778350830078125000000e7 * t75 * t414 + 0.37964221408846205205482554659247398376464843750000e7 * t77 * t414 + 0.16265809999534105486549274879693984985351562500000e9 * t329 * t136 - 0.21866595997693641174260200517177581787109375000000e9 * t327 * t136 - 0.24461378976966653942748591667413711547851562500000e9 * t310 * t136 - 0.25005504663950034768211841583251953125000000000000e2 * t166 * t230 + 0.94960116208061641698181629180908203125000000000000e1 * t168 * t230
  t554 = 0.10074287954003696839486362379789352416992187500000e8 * t172 * t230 - 0.12310199285261137920509332716464996337890625000000e8 * t174 * t230 + 0.35467018623362173770330299642086029052734375000000e9 * t308 * t136 + 0.22778532845307723123289532795548439025878906250000e9 * t306 * t136 - 0.36881739575096235270119870814085006713867187500000e9 * t304 * t136 - 0.13319000339927653503604381111264228820800781250000e9 * t302 * t136 + 0.25673750850086203454900187181234359741210937500000e9 * t300 * t136 + 0.45837990511168096233550787329673767089843750000000e8 * t343 * t136 - 0.61390306482204810386775543397665023803710937500000e8 * t262 * t136 - 0.12122700580090166788168809914588928222656250000000e9 * t341 * t136 - 0.64741487629542093700792325735092163085937500000000e7 * t339 * t136
  t577 = 0.38495479860492569487830352258682250976562500000000e8 * t337 * t136 - 0.13151924045060406799091567695140838623046875000000e7 * t335 * t136 - 0.79787050895475186221232519507408142089843750000000e7 * t333 * t136 + 0.75071692907694401189010652899742126464843750000000e6 * t274 * t136 + 0.10215557029958148636984093546867370605468750000000e7 * t272 * t136 - 0.13339033798578177542390817403793334960937500000000e6 * t270 * t136 - 0.74311824750968790083531928062438964843750000000000e5 * t268 * t136 + 0.10836722042909234804177606105804443359375000000000e5 * t266 * t136 + 0.27487831463384265150922536849975585937500000000000e4 * t264 * t136 - 0.43785472736230281611171364784240722656250000000000e3 * t235 * t136 + 0.78146124916143160722799933254718780517578125000000e8 * t331 * t136
  t585 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t105 + t6 * t22 * t195 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t110 * t347 - 0.3e1 / 0.8e1 * t6 * t199 * (-0.42260786315948682231881000377513744212962962962963e0 * t367 + 0.74141730378857337248914035750024112654320987654320e-2 * t381 - 0.17126739717516044904499142258255570023148148148148e1 * t387 + 0.63205825147975880004699215476895556037808641975308e0 * t393 + 0.31653372069353880566060543060302734375000000000000e1 * t395 - 0.43785472736230281611171364784240722656250000000000e3 * t46 * t395 - 0.16670336442633356512141227722167968750000000000000e2 * t45 * t395 + 0.90668591586033271555377261418104171752929687500000e8 * t58 * t395 - 0.75474335259590036520424826297163963317871093750000e9 * t51 * t395 + 0.13692667120045975175946766496658325195312500000000e10 * t85 * t395 + t435 + t459 + t482 + t507 + t530 + t554 + t577))
  v3rho3_0_ = 0.2e1 * r0 * t585 + 0.6e1 * t352

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = t29 * s0
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t38 = 0.4e1 + t29 * s0 * t32 * t22 / 0.24e2
  t39 = 0.1e1 / t38
  t41 = t30 * t32 * t22 * t39
  t43 = t41 / 0.12e2 - 0.1e1
  t44 = t43 ** 2
  t45 = t44 ** 2
  t46 = t45 ** 2
  t47 = t46 * t45
  t48 = t46 ** 2
  t49 = t48 * t47
  t51 = t45 * t43
  t52 = t46 * t51
  t55 = t44 * t43
  t56 = t46 * t55
  t57 = t48 * t56
  t59 = t46 * t43
  t60 = t48 * t59
  t62 = t46 * t44
  t63 = t48 * t62
  t65 = t48 * t46
  t68 = t45 * t44
  t69 = t48 * t68
  t71 = t45 * t55
  t72 = t48 * t71
  t74 = t48 * t51
  t76 = t48 * t55
  t78 = t48 * t45
  t80 = t48 * t44
  t83 = t48 * t43
  t85 = -0.54277774626371860319706052541732788085937500000000e4 * t49 + 0.41355861880146538749944016337394714355468750000000e4 * t48 * t52 - 0.29150193011493262291916212439537048339843750000000e5 * t57 + 0.90365611108522808258607082664966583251953125000000e5 * t60 + 0.40074935854432390114256376028060913085937500000000e5 * t63 - 0.13204466182182150467548430263996124267578125000000e6 * t65 + 0.37534251004296526982262730598449707031250000000000e-1 * t41 + 0.25589479526235334610627921819686889648437500000000e6 * t69 - 0.16114215399846280594696041941642761230468750000000e6 * t72 + 0.18078200670879145335944073647260665893554687500000e6 * t74 - 0.12981481812794983921641696989536285400390625000000e6 * t76 - 0.32352403136049329184315676152706146240234375000000e6 * t78 + 0.27967048856303053872440291047096252441406250000000e6 * t80 - 0.16837084139014120539123347103595733642578125000000e6 * t48 + 0.56174007979372666952880866825580596923828125000000e5 * t83
  t86 = t46 * t71
  t89 = t46 * t68
  t102 = 0.11313514630621233134023547172546386718750000000000e1 - 0.10276426607863824396951162815093994140625000000000e5 * t86 - 0.2810240180568462991258881986141204833984375000000e4 * t52 + 0.70504541869034010050971341133117675781250000000000e5 * t89 - 0.20148245175625047025563767552375793457031250000000e5 * t47 + 0.37835396407252402359200346469879150390625000000000e4 * t62 + 0.22748997850816485208791106939315795898437500000000e4 * t56 - 0.61754786104528599733290821313858032226562500000000e3 * t59 + 0.86005730499279641302996873855590820312500000000000e2 * t71 - 0.44233229018433803621149957180023193359375000000000e3 * t46 - 0.72975787893717136018618941307067871093750000000000e1 * t51 + 0.30542034959315850167691707611083984375000000000000e2 * t68 - 0.69459735177638985467255115509033203125000000000000e0 * t45 - 0.38916037779196815968155860900878906250000000000000e0 * t44 + 0.52755620115589800943434238433837890625000000000000e0 * t55
  t103 = t85 + t102
  t109 = t17 / t20 / r0
  t110 = t18 * r0
  t112 = 0.1e1 / t20 / t110
  t115 = t30 * t32 * t112 * t39
  t117 = t24 ** 2
  t119 = 0.1e1 / t26 / t25
  t121 = s0 ** 2
  t122 = t117 * t119 * t121
  t123 = t18 ** 2
  t124 = t123 * t18
  t128 = t38 ** 2
  t129 = 0.1e1 / t128
  t131 = t122 * t31 / t19 / t124 * t129
  t135 = -0.2e1 / 0.9e1 * t115 + t131 / 0.54e2
  t148 = t63 * t135
  t154 = t44 * t135
  t156 = t43 * t135
  t160 = t57 * t135
  t162 = -0.10009133601145740528603394826253255208333333333333e0 * t115 + 0.83409446676214504405028290218777126736111111111111e-2 * t131 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t135 + 0.98706358616647614071359877586364746093750000000000e6 * t52 * t135 - 0.36533122347390018886365465819835662841796875000000e5 * t47 * t135 - 0.24177894210750056430676521062850952148437500000000e6 * t56 * t135 + 0.25023897635898133729670217633247375488281250000000e5 * t62 * t135 + 0.37835396407252402359200346469879150390625000000000e5 * t59 * t135 - 0.78705521131031808188173773586750030517578125000000e6 * t148 - 0.36487893946858568009309470653533935546875000000000e2 * t45 * t135 - 0.27783894071055594186902046203613281250000000000000e1 * t55 * t135 + 0.15826686034676940283030271530151367187500000000000e1 * t154 - 0.77832075558393631936311721801757812500000000000000e0 * t156 + 0.11993199945242496237483764737844467163085937500000e6 * t49 * t135 - 0.15197776895384120889517694711685180664062500000000e6 * t160
  t193 = 0.10419483322152421429706657767295837402343750000000e7 * t60 * t135 + 0.22591402777130702064651770666241645812988281250000e7 * t65 * t135 - 0.31690718837237161122116232633590698242187500000000e7 * t72 * t135 - 0.37062695419646445367800896465778350830078125000000e7 * t69 * t135 + 0.56296854957717736143381428003311157226562500000000e7 * t74 * t135 + 0.37964221408846205205482554659247398376464843750000e7 * t78 * t135 - 0.64704806272098658368631352305412292480468750000000e7 * t76 * t135 - 0.24664815444310469451119224280118942260742187500000e7 * t80 * t135 + 0.50340687941345496970392523884773254394531250000000e7 * t83 * t135 + 0.95495813564933533819897473603487014770507812500000e6 * t48 * t135 - 0.26939334622422592862597355365753173828125000000000e7 * t86 * t135 - 0.55579307494075739759961739182472229003906250000000e4 * t46 * t135 - 0.35386583214747042896919965744018554687500000000000e4 * t71 * t135 + 0.60204011349495748912097811698913574218750000000000e3 * t68 * t135 + 0.18325220975589510100615024566650390625000000000000e3 * t51 * t135
  t194 = t162 + t193
  t199 = t17 / t20
  t204 = t30 * t32 / t20 / t123 * t39
  t211 = t122 * t31 / t19 / t123 / t110 * t129
  t215 = t25 ** 2
  t216 = 0.1e1 / t215
  t218 = t216 * t121 * s0
  t219 = t123 ** 2
  t223 = 0.1e1 / t128 / t38
  t225 = t218 / t219 / t18 * t223
  t227 = 0.22e2 / 0.27e2 * t204 - t211 / 0.6e1 + 0.4e1 / 0.81e2 * t225
  t236 = t55 * t227
  t238 = t135 ** 2
  t239 = t63 * t238
  t241 = t62 * t238
  t243 = t56 * t238
  t245 = t47 * t238
  t247 = t52 * t238
  t249 = t89 * t238
  t251 = t86 * t238
  t253 = 0.36700156537534381938212447696261935763888888888888e0 * t204 - 0.75068502008593053964525461196899414062500000000000e-1 * t211 - 0.15197776895384120889517694711685180664062500000000e6 * t57 * t227 + 0.11993199945242496237483764737844467163085937500000e6 * t49 * t227 - 0.77832075558393631936311721801757812500000000000000e0 * t43 * t227 + 0.15826686034676940283030271530151367187500000000000e1 * t44 * t227 - 0.27783894071055594186902046203613281250000000000000e1 * t236 - 0.41033997617537126401697775721549987792968750000000e7 * t239 - 0.26595683631825062073744173169136047363281250000000e7 * t241 - 0.43839746816868022663638558983802795410156250000000e6 * t243 + 0.12831826620164189829276784086227416992187500000000e8 * t245 - 0.21580495876514031233597441911697387695312500000000e7 * t247 - 0.40409001933633889293896033048629760742187500000000e8 * t249 + 0.15279330170389365411183595776557922363281250000000e8 * t251
  t254 = t72 * t227
  t256 = t65 * t227
  t258 = t60 * t227
  t262 = t45 * t227
  t264 = t51 * t227
  t266 = t48 * t238
  t268 = t83 * t238
  t270 = t80 * t238
  t272 = t76 * t238
  t274 = t78 * t238
  t276 = t74 * t238
  t278 = t69 * t238
  t280 = t72 * t238
  t282 = t65 * t238
  t284 = -0.31690718837237161122116232633590698242187500000000e7 * t254 + 0.22591402777130702064651770666241645812988281250000e7 * t256 + 0.10419483322152421429706657767295837402343750000000e7 * t258 - 0.78705521131031808188173773586750030517578125000000e6 * t63 * t227 - 0.36487893946858568009309470653533935546875000000000e2 * t262 + 0.18325220975589510100615024566650390625000000000000e3 * t264 + 0.85579169500287344849667290604114532470703125000000e8 * t266 - 0.44396667799758845012014603704214096069335937500000e8 * t268 - 0.12293913191698745090039956938028335571289062500000e9 * t270 + 0.75928442817692410410965109318494796752929687500000e8 * t272 + 0.11822339541120724590110099880695343017578125000000e9 * t274 - 0.81537929923222179809161972224712371826171875000000e8 * t276 - 0.72888653325645470580867335057258605957031250000000e8 * t278 + 0.54219366665113684955164249598979949951171875000000e8 * t280 + 0.26048708305381053574266644418239593505859375000000e8 * t282
  t286 = t60 * t238
  t288 = t48 * t227
  t290 = t86 * t227
  t292 = t83 * t227
  t294 = t80 * t227
  t296 = t76 * t227
  t298 = t78 * t227
  t300 = t74 * t227
  t304 = t43 * t238
  t306 = t44 * t238
  t308 = t55 * t238
  t310 = t45 * t238
  t312 = t51 * t238
  t316 = -0.20463435494068270128925181132555007934570312500000e8 * t286 + 0.95495813564933533819897473603487014770507812500000e6 * t288 - 0.26939334622422592862597355365753173828125000000000e7 * t290 + 0.50340687941345496970392523884773254394531250000000e7 * t292 - 0.24664815444310469451119224280118942260742187500000e7 * t294 - 0.64704806272098658368631352305412292480468750000000e7 * t296 + 0.37964221408846205205482554659247398376464843750000e7 * t298 + 0.56296854957717736143381428003311157226562500000000e7 * t300 + 0.33580959846678989464954541265964508056640625000000e7 * t57 * t238 + 0.31653372069353880566060543060302734375000000000000e1 * t304 - 0.83351682213166782560706138610839843750000000000000e1 * t306 - 0.14595157578743427203723788261413574218750000000000e3 * t308 + 0.91626104877947550503075122833251953125000000000000e3 * t310 + 0.36122406809697449347258687019348144531250000000000e4 * t312 - 0.24770608250322930027843976020812988281250000000000e5 * t68 * t238
  t317 = t71 * t238
  t319 = t46 * t238
  t321 = t59 * t238
  t323 = t69 * t227
  t325 = t68 * t227
  t327 = t71 * t227
  t329 = t46 * t227
  t331 = t59 * t227
  t333 = t62 * t227
  t335 = t56 * t227
  t337 = t47 * t227
  t339 = t52 * t227
  t341 = t89 * t227
  t345 = -0.44463445995260591807969391345977783203125000000000e5 * t317 + 0.34051856766527162123280311822891235351562500000000e6 * t319 + 0.25023897635898133729670217633247375488281250000000e6 * t321 - 0.37062695419646445367800896465778350830078125000000e7 * t323 + 0.60204011349495748912097811698913574218750000000000e3 * t325 - 0.35386583214747042896919965744018554687500000000000e4 * t327 - 0.55579307494075739759961739182472229003906250000000e4 * t329 + 0.37835396407252402359200346469879150390625000000000e5 * t331 + 0.25023897635898133729670217633247375488281250000000e5 * t333 - 0.24177894210750056430676521062850952148437500000000e6 * t335 - 0.36533122347390018886365465819835662841796875000000e5 * t337 + 0.98706358616647614071359877586364746093750000000000e6 * t339 - 0.15414639911795736595426744222640991210937500000000e6 * t341 + 0.22242519113657201174674210725007233796296296296296e-1 * t225 - 0.77832075558393631936311721801757812500000000000000e0 * t238
  t347 = t253 + t284 + t316 + t345
  t351 = t17 * t19
  t352 = t123 * r0
  t357 = t30 * t32 / t20 / t352 * t39
  t363 = t122 * t31 / t19 / t219 * t129
  t365 = t238 * t135
  t405 = -0.31124412196682414265578573942184448242187500000000e6 * t68 * t365 - 0.14862364950193758016706385612487792968750000000000e6 * t51 * t365 + 0.18061203404848724673629343509674072265625000000000e5 * t45 * t365 + 0.36650441951179020201230049133300781250000000000000e4 * t55 * t365 - 0.43785472736230281611171364784240722656250000000000e3 * t44 * t365 - 0.16670336442633356512141227722167968750000000000000e2 * t43 * t365 + 0.23644679082241449180220199761390686035156250000000e10 * t76 * t365 + 0.14426404135361557978083370770514011383056640625000e10 * t80 * t365 - 0.22129043745057741162071922488451004028320312500000e10 * t83 * t365 - 0.75474335259590036520424826297163963317871093750000e9 * t48 * t365 + 0.13692667120045975175946766496658325195312500000000e10 * t86 * t365
  t416 = t218 / t219 / t110 * t223
  t418 = t121 ** 2
  t419 = t216 * t418
  t424 = t128 ** 2
  t428 = 0.1e1 / t424 * t24 * t28 * t32
  t429 = t419 / t20 / t219 / t352 * t428
  t431 = -0.308e3 / 0.81e2 * t357 + 0.341e3 / 0.243e3 * t363 - 0.76e2 / 0.81e2 * t416 + 0.4e1 / 0.243e3 * t429
  t432 = t74 * t431
  t434 = t78 * t431
  t436 = t76 * t431
  t442 = t83 * t431
  t444 = t86 * t431
  t446 = t89 * t431
  t448 = t52 * t431
  t450 = 0.22918995255584048116775393664836883544921875000000e9 * t89 * t365 - 0.56572602707087445011454446268081665039062500000000e9 * t52 * t365 + 0.56296854957717736143381428003311157226562500000000e7 * t432 + 0.37964221408846205205482554659247398376464843750000e7 * t434 - 0.64704806272098658368631352305412292480468750000000e7 * t436 - 0.48223721498554824930002414882183074951171875000000e7 * t62 * t365 - 0.26595683631825062073744173169136047363281250000000e8 * t59 * t365 + 0.50340687941345496970392523884773254394531250000000e7 * t442 - 0.26939334622422592862597355365753173828125000000000e7 * t444 - 0.15414639911795736595426744222640991210937500000000e6 * t446 + 0.98706358616647614071359877586364746093750000000000e6 * t448
  t451 = t47 * t431
  t453 = t56 * t431
  t455 = t62 * t431
  t457 = t59 * t431
  t459 = t46 * t431
  t465 = t43 * t431
  t471 = t57 * t431
  t473 = -0.36533122347390018886365465819835662841796875000000e5 * t451 - 0.24177894210750056430676521062850952148437500000000e6 * t453 + 0.25023897635898133729670217633247375488281250000000e5 * t455 + 0.37835396407252402359200346469879150390625000000000e5 * t457 - 0.55579307494075739759961739182472229003906250000000e4 * t459 - 0.51158588735170675322312952831387519836425781250000e9 * t65 * t365 + 0.62516899932914528578239946603775024414062500000000e9 * t72 * t365 - 0.77832075558393631936311721801757812500000000000000e0 * t465 + 0.11993199945242496237483764737844467163085937500000e6 * t49 * t431 - 0.17122965283876657759924014167189598083496093750000e10 * t78 * t365 - 0.15197776895384120889517694711685180664062500000000e6 * t471
  t476 = t48 * t431
  t478 = t71 * t431
  t480 = t68 * t431
  t482 = t51 * t431
  t484 = t45 * t431
  t486 = t63 * t431
  t488 = t60 * t431
  t490 = t65 * t431
  t492 = t72 * t431
  t494 = t69 * t431
  t496 = t80 * t431
  t498 = 0.95495813564933533819897473603487014770507812500000e6 * t476 - 0.35386583214747042896919965744018554687500000000000e4 * t478 + 0.60204011349495748912097811698913574218750000000000e3 * t480 + 0.18325220975589510100615024566650390625000000000000e3 * t482 - 0.36487893946858568009309470653533935546875000000000e2 * t484 - 0.78705521131031808188173773586750030517578125000000e6 * t486 + 0.10419483322152421429706657767295837402343750000000e7 * t488 + 0.22591402777130702064651770666241645812988281250000e7 * t490 - 0.31690718837237161122116232633590698242187500000000e7 * t492 - 0.37062695419646445367800896465778350830078125000000e7 * t494 - 0.24664815444310469451119224280118942260742187500000e7 * t496
  t499 = t55 * t431
  t501 = t44 * t431
  t519 = -0.27783894071055594186902046203613281250000000000000e1 * t499 + 0.15826686034676940283030271530151367187500000000000e1 * t501 - 0.23349622667518089580893516540527343750000000000000e1 * t135 * t227 + 0.31653372069353880566060543060302734375000000000000e1 * t365 - 0.42260786315948682231881000377513744212962962962963e0 * t416 - 0.74311824750968790083531928062438964843750000000000e5 * t325 * t135 + 0.10836722042909234804177606105804443359375000000000e5 * t264 * t135 + 0.27487831463384265150922536849975585937500000000000e4 * t262 * t135 - 0.43785472736230281611171364784240722656250000000000e3 * t236 * t135 - 0.61390306482204810386775543397665023803710937500000e8 * t258 * t135 + 0.78146124916143160722799933254718780517578125000000e8 * t256 * t135
  t543 = 0.16265809999534105486549274879693984985351562500000e9 * t254 * t135 - 0.21866595997693641174260200517177581787109375000000e9 * t323 * t135 - 0.24461378976966653942748591667413711547851562500000e9 * t300 * t135 - 0.25005504663950034768211841583251953125000000000000e2 * t154 * t227 + 0.94960116208061641698181629180908203125000000000000e1 * t156 * t227 + 0.10074287954003696839486362379789352416992187500000e8 * t160 * t227 - 0.12310199285261137920509332716464996337890625000000e8 * t148 * t227 + 0.45837990511168096233550787329673767089843750000000e8 * t290 * t135 + 0.35467018623362173770330299642086029052734375000000e9 * t298 * t135 + 0.22778532845307723123289532795548439025878906250000e9 * t296 * t135 - 0.36881739575096235270119870814085006713867187500000e9 * t294 * t135
  t565 = -0.13319000339927653503604381111264228820800781250000e9 * t292 * t135 + 0.25673750850086203454900187181234359741210937500000e9 * t288 * t135 - 0.12122700580090166788168809914588928222656250000000e9 * t341 * t135 - 0.64741487629542093700792325735092163085937500000000e7 * t339 * t135 + 0.38495479860492569487830352258682250976562500000000e8 * t337 * t135 - 0.13151924045060406799091567695140838623046875000000e7 * t335 * t135 - 0.79787050895475186221232519507408142089843750000000e7 * t333 * t135 + 0.75071692907694401189010652899742126464843750000000e6 * t331 * t135 + 0.10215557029958148636984093546867370605468750000000e7 * t329 * t135 - 0.13339033798578177542390817403793334960937500000000e6 * t327 * t135 + 0.74141730378857337248914035750024112654320987654320e-2 * t429
  t568 = -0.17126739717516044904499142258255570023148148148148e1 * t357 + 0.63205825147975880004699215476895556037808641975308e0 * t363 - 0.28054644639468240603676674485206604003906250000000e8 * t47 * t365 + 0.15398191944197027795132140903472900390625000000000e9 * t56 * t365 + 0.90668591586033271555377261418104171752929687500000e8 * t63 * t365 - 0.10668839380559652864441421687602996826171875000000e9 * t60 * t365 + 0.12470454332976147539687777407765388488769531250000e10 * t69 * t365 - 0.16035503731642003527790813712596893310546875000000e10 * t74 * t365 + 0.22521507872308320356703195869922637939453125000000e7 * t46 * t365 + 0.27241485413221729698624249458312988281250000000000e7 * t71 * t365 + t405 + t450 + t473 + t498 + t519 + t543 + t565
  t573 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t103 + t6 * t109 * t194 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t199 * t347 - 0.3e1 / 0.8e1 * t6 * t351 * t568)
  t592 = t419 / t20 / t219 / t124 * t428
  t596 = t219 ** 2
  t606 = t216 * t418 * s0 / t19 / t596 / r0 / t424 / t38 * t117 * t119 * t31
  t608 = t238 ** 2
  t619 = t227 ** 2
  t640 = -0.24219631923760063501311918345007876800411522633745e0 * t592 + 0.65903760336762077554590254000021433470507544581618e-2 * t606 + 0.19069039789255210789036974620819091796875000000000e8 * t68 * t608 + 0.18017206297846656285362556695938110351562500000000e8 * t71 * t608 - 0.26672098451399132161103554219007492065429687500000e10 * t65 * t608 + 0.23573833812368650604398087968707084655761718750000e10 * t60 * t608 + 0.18992023241612328339636325836181640625000000000000e2 * t238 * t227 - 0.61390306482204810386775543397665023803710937500000e8 * t60 * t619 + 0.78146124916143160722799933254718780517578125000000e8 * t65 * t619 + 0.16265809999534105486549274879693984985351562500000e9 * t72 * t619 - 0.21866595997693641174260200517177581787109375000000e9 * t69 * t619 - 0.87570945472460563222342729568481445312500000000000e3 * t43 * t608 + 0.10995132585353706060369014739990234375000000000000e5 * t44 * t608 + 0.72244813619394898694517374038696289062500000000000e5 * t55 * t608 - 0.74311824750968790083531928062438964843750000000000e6 * t45 * t608 + 0.45837990511168096233550787329673767089843750000000e8 * t86 * t619 + 0.35467018623362173770330299642086029052734375000000e9 * t78 * t619
  t649 = t30 * t32 / t20 / t124 * t39
  t656 = t122 * t31 / t19 / t219 / r0 * t129
  t661 = t218 / t219 / t123 * t223
  t665 = 0.5236e4 / 0.243e3 * t649 - 0.3047e4 / 0.243e3 * t656 + 0.10252e5 / 0.729e3 * t661 - 0.392e3 / 0.729e3 * t592 + 0.32e2 / 0.2187e4 * t606
  t698 = 0.22778532845307723123289532795548439025878906250000e9 * t76 * t619 - 0.36881739575096235270119870814085006713867187500000e9 * t80 * t619 - 0.36487893946858568009309470653533935546875000000000e2 * t45 * t665 - 0.27783894071055594186902046203613281250000000000000e1 * t55 * t665 + 0.98706358616647614071359877586364746093750000000000e6 * t52 * t665 - 0.31132830223357452774524688720703125000000000000000e1 * t135 * t431 - 0.37619374366598159975522268230366706848144531250000e11 * t48 * t608 + 0.25967527443650804360550067386925220489501953125000e11 * t83 * t608 + 0.44924890256258753442418379546642303466796875000000e11 * t80 * t608 - 0.23936115268642555866369755852222442626953125000000e9 * t46 * t608 - 0.48223721498554824930002414882183074951171875000000e8 * t59 * t608 + 0.16938011138616730574645354993820190429687500000000e10 * t62 * t608 - 0.33665573567361888724412009382247924804687500000000e9 * t56 * t608 - 0.33674557836448207408360708796453475952148437500000e11 * t78 * t608 + 0.27434999532547524587313110297083854675292968750000e11 * t74 * t608 + 0.14378886984570341572995187718868255615234375000000e11 * t69 * t608 - 0.12278061296440962077355108679533004760742187500000e11 * t72 * t608 - 0.34245930567753315519848028334379196166992187500000e11 * t76 * t608
  t736 = 0.11993199945242496237483764737844467163085937500000e6 * t49 * t665 + 0.15826686034676940283030271530151367187500000000000e1 * t44 * t665 + 0.37835396407252402359200346469879150390625000000000e5 * t59 * t665 - 0.24664815444310469451119224280118942260742187500000e7 * t80 * t665 - 0.64704806272098658368631352305412292480468750000000e7 * t76 * t665 + 0.37964221408846205205482554659247398376464843750000e7 * t78 * t665 + 0.56296854957717736143381428003311157226562500000000e7 * t74 * t665 - 0.37062695419646445367800896465778350830078125000000e7 * t69 * t665 - 0.31690718837237161122116232633590698242187500000000e7 * t72 * t665 + 0.22591402777130702064651770666241645812988281250000e7 * t65 * t665 + 0.10419483322152421429706657767295837402343750000000e7 * t60 * t665 - 0.78705521131031808188173773586750030517578125000000e6 * t63 * t665 + 0.25023897635898133729670217633247375488281250000000e5 * t62 * t665 - 0.24177894210750056430676521062850952148437500000000e6 * t56 * t665 - 0.36533122347390018886365465819835662841796875000000e5 * t47 * t665 - 0.77832075558393631936311721801757812500000000000000e0 * t43 * t665 - 0.15414639911795736595426744222640991210937500000000e6 * t89 * t665 - 0.26939334622422592862597355365753173828125000000000e7 * t86 * t665
  t771 = 0.50340687941345496970392523884773254394531250000000e7 * t83 * t665 + 0.18325220975589510100615024566650390625000000000000e3 * t51 * t665 + 0.60204011349495748912097811698913574218750000000000e3 * t68 * t665 - 0.35386583214747042896919965744018554687500000000000e4 * t71 * t665 + 0.95495813564933533819897473603487014770507812500000e6 * t48 * t665 - 0.15197776895384120889517694711685180664062500000000e6 * t57 * t665 - 0.55579307494075739759961739182472229003906250000000e4 * t46 * t665 + 0.97051525065924254458828472796781563464506172839505e1 * t649 - 0.56477463116094576649360266732580867814429012345678e1 * t656 + 0.10009559054359253491868087053298950195312500000000e7 * t457 * t135 - 0.10638273452730024829497669267654418945312500000000e8 * t455 * t135 + 0.13432383938671595785981816506385803222656250000000e8 * t471 * t135 + 0.13620742706610864849312124729156494140625000000000e7 * t459 * t135 - 0.13339033798578177542390817403793334960937500000000e6 * t71 * t619 - 0.74311824750968790083531928062438964843750000000000e5 * t68 * t619 + 0.10836722042909234804177606105804443359375000000000e5 * t51 * t619 + 0.27487831463384265150922536849975585937500000000000e4 * t45 * t619 - 0.43785472736230281611171364784240722656250000000000e3 * t55 * t619
  t808 = -0.24461378976966653942748591667413711547851562500000e9 * t74 * t619 - 0.25005504663950034768211841583251953125000000000000e2 * t44 * t619 - 0.13319000339927653503604381111264228820800781250000e9 * t83 * t619 - 0.73544383519213678514890780148506164550781250000000e10 * t47 * t608 + 0.32086593357817667363485551130771636962890625000000e10 * t52 * t608 + 0.20539000680068962763920149744987487792968750000000e11 * t89 * t608 - 0.12075893641534405843267972207546234130859375000000e11 * t86 * t608 + 0.94960116208061641698181629180908203125000000000000e1 * t43 * t619 + 0.10074287954003696839486362379789352416992187500000e8 * t57 * t619 - 0.12310199285261137920509332716464996337890625000000e8 * t63 * t619 - 0.18674647318009448559347144365310668945312500000000e7 * t51 * t608 + 0.25673750850086203454900187181234359741210937500000e9 * t48 * t619 - 0.12122700580090166788168809914588928222656250000000e9 * t89 * t619 - 0.64741487629542093700792325735092163085937500000000e7 * t52 * t619 + 0.38495479860492569487830352258682250976562500000000e8 * t47 * t619 - 0.13151924045060406799091567695140838623046875000000e7 * t56 * t619 - 0.79787050895475186221232519507408142089843750000000e7 * t62 * t619
  t842 = 0.75071692907694401189010652899742126464843750000000e6 * t59 * t619 + 0.10215557029958148636984093546867370605468750000000e7 * t46 * t619 + 0.63341751653670451789655557875770600244341563786008e1 * t661 - 0.17785378398104236723187756538391113281250000000000e6 * t478 * t135 - 0.30695153241102405193387771698832511901855468750000e10 * t282 * t227 + 0.37510139959748717146943967962265014648437500000000e10 * t280 * t227 + 0.74822725997856885238126664446592330932617187500000e10 * t278 * t227 - 0.23349622667518089580893516540527343750000000000000e1 * t619 - 0.16670336442633356512141227722167968750000000000000e2 * t608 - 0.96213022389852021166744882275581359863281250000000e10 * t276 * t227 - 0.10273779170325994655954408500313758850097656250000e11 * t274 * t227 - 0.16413599047014850560679110288619995117187500000000e8 * t486 * t135 + 0.61117320681557461644734383106231689453125000000000e8 * t444 * t135 - 0.99082433001291720111375904083251953125000000000000e5 * t480 * t135 + 0.14448962723878979738903474807739257812500000000000e5 * t482 * t135 - 0.58380630314973708814895153045654296875000000000000e3 * t499 * t135 + 0.36650441951179020201230049133300781250000000000000e4 * t484 * t135 + 0.21687746666045473982065699839591979980468750000000e9 * t492 * t135
  t880 = 0.10419483322152421429706657767295837402343750000000e9 * t490 * t135 - 0.81853741976273080515700724530220031738281250000000e8 * t488 * t135 - 0.29155461330258188232346934022903442382812500000000e9 * t494 * t135 + 0.13751397153350428870065236198902130126953125000000e10 * t249 * t227 + 0.82156002720275851055680598979949951171875000000000e10 * t251 * t227 - 0.45284601155754021912254895778298377990722656250000e10 * t266 * t227 + 0.12661348827741552226424217224121093750000000000000e2 * t465 * t135 - 0.13277426247034644697243153493070602416992187500000e11 * t268 * t227 + 0.14186807449344869508132119856834411621093750000000e11 * t272 * t227 - 0.10002201865580013907284736633300781250000000000000e3 * t304 * t227 - 0.26271283641738168966702818870544433593750000000000e4 * t306 * t227 + 0.21990265170707412120738029479980468750000000000000e5 * t308 * t227 + 0.10836722042909234804177606105804443359375000000000e6 * t310 * t227 - 0.89174189701162548100238313674926757812500000000000e6 * t312 * t227 - 0.18674647318009448559347144365310668945312500000000e7 * t325 * t238 - 0.33340672885266713024282455444335937500000000000000e2 * t501 * t135 + 0.16344891247933037819174549674987792968750000000000e8 * t317 * t227 + 0.13512904723384992214021917521953582763671875000000e8 * t319 * t227
  t917 = -0.64013036283357917186648530125617980957031250000000e9 * t286 * t227 + 0.54401154951619962933226356850862503051757812500000e9 * t239 * t227 - 0.17758667119903538004805841481685638427734375000000e9 * t442 * t135 - 0.49175652766794980360159827752113342285156250000000e9 * t496 * t135 + 0.30371377127076964164386043727397918701171875000000e9 * t436 * t135 + 0.47289358164482898360440399522781372070312500000000e9 * t434 * t135 - 0.32615171969288871923664788889884948730468750000000e9 * t432 * t135 - 0.17535898726747209065455423593521118164062500000000e7 * t453 * t135 + 0.51327306480656759317107136344909667968750000000000e8 * t451 * t135 - 0.86321983506056124934389767646789550781250000000000e7 * t448 * t135 - 0.16163600773453555717558413219451904296875000000000e9 * t446 * t135 + 0.34231667800114937939866916241645812988281250000000e9 * t476 * t135 - 0.15957410179095037244246503901481628417968750000000e9 * t321 * t227 - 0.28934232899132894958001448929309844970703125000000e8 * t241 * t227 + 0.92389151665182166770792845420837402343750000000000e9 * t243 * t227 - 0.16832786783680944362206004691123962402343750000000e9 * t245 * t227 - 0.33943561624252467006872667760848999023437500000000e10 * t247 * t227 + 0.86558424812169347868500224623084068298339843750000e10 * t270 * t227
  t925 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t112 * t103 - 0.5e1 / 0.9e1 * t6 * t23 * t194 + t6 * t109 * t347 / 0.2e1 - t6 * t199 * t568 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t351 * (t640 + t698 + t736 + t771 + t808 + t842 + t880 + t917))
  v4rho4_0_ = 0.2e1 * r0 * t925 + 0.8e1 * t573

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t43 = s0 / t40 / t38
  t46 = 0.4e1 + t37 * t43 / 0.24e2
  t47 = 0.1e1 / t46
  t49 = t37 * t43 * t47
  t51 = t49 / 0.12e2 - 0.1e1
  t52 = t51 ** 2
  t53 = t52 ** 2
  t54 = t53 * t51
  t55 = t53 ** 2
  t56 = t55 * t54
  t57 = t55 ** 2
  t60 = t52 * t51
  t61 = t55 * t60
  t62 = t57 * t61
  t64 = t55 * t53
  t65 = t57 * t64
  t67 = t55 * t51
  t68 = t57 * t67
  t70 = t55 * t52
  t71 = t57 * t70
  t73 = t57 * t55
  t75 = t53 * t52
  t76 = t57 * t75
  t78 = t53 * t60
  t79 = t57 * t78
  t81 = t57 * t53
  t83 = t57 * t54
  t85 = t57 * t52
  t87 = t57 * t60
  t90 = t57 * t51
  t92 = t55 * t78
  t94 = 0.41355861880146538749944016337394714355468750000000e4 * t57 * t56 - 0.29150193011493262291916212439537048339843750000000e5 * t62 - 0.54277774626371860319706052541732788085937500000000e4 * t65 + 0.90365611108522808258607082664966583251953125000000e5 * t68 + 0.40074935854432390114256376028060913085937500000000e5 * t71 - 0.13204466182182150467548430263996124267578125000000e6 * t73 + 0.25589479526235334610627921819686889648437500000000e6 * t76 - 0.16114215399846280594696041941642761230468750000000e6 * t79 - 0.32352403136049329184315676152706146240234375000000e6 * t81 + 0.18078200670879145335944073647260665893554687500000e6 * t83 + 0.27967048856303053872440291047096252441406250000000e6 * t85 - 0.12981481812794983921641696989536285400390625000000e6 * t87 - 0.16837084139014120539123347103595733642578125000000e6 * t57 + 0.56174007979372666952880866825580596923828125000000e5 * t90 - 0.10276426607863824396951162815093994140625000000000e5 * t92
  t96 = t55 * t75
  t110 = 0.11313514630621233134023547172546386718750000000000e1 - 0.2810240180568462991258881986141204833984375000000e4 * t56 + 0.70504541869034010050971341133117675781250000000000e5 * t96 + 0.22748997850816485208791106939315795898437500000000e4 * t61 - 0.20148245175625047025563767552375793457031250000000e5 * t64 - 0.61754786104528599733290821313858032226562500000000e3 * t67 + 0.37835396407252402359200346469879150390625000000000e4 * t70 - 0.44233229018433803621149957180023193359375000000000e3 * t55 + 0.30542034959315850167691707611083984375000000000000e2 * t75 + 0.86005730499279641302996873855590820312500000000000e2 * t78 - 0.69459735177638985467255115509033203125000000000000e0 * t53 - 0.72975787893717136018618941307067871093750000000000e1 * t54 - 0.38916037779196815968155860900878906250000000000000e0 * t52 + 0.52755620115589800943434238433837890625000000000000e0 * t60 + 0.37534251004296526982262730598449707031250000000000e-1 * t49
  t111 = t94 + t110
  t115 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t116 = t115 * f.p.zeta_threshold
  t118 = f.my_piecewise3(t20, t116, t21 * t19)
  t119 = t30 ** 2
  t120 = 0.1e1 / t119
  t121 = t118 * t120
  t124 = t5 * t121 * t111 / 0.8e1
  t125 = t118 * t30
  t126 = t38 * r0
  t131 = t37 * s0 / t40 / t126 * t47
  t133 = t32 ** 2
  t136 = t133 / t34 / t33
  t137 = s0 ** 2
  t138 = t38 ** 2
  t143 = t46 ** 2
  t144 = 0.1e1 / t143
  t146 = t136 * t137 / t39 / t138 / t38 * t144
  t148 = -0.2e1 / 0.9e1 * t131 + t146 / 0.108e3
  t179 = 0.95495813564933533819897473603487014770507812500000e6 * t57 * t148 - 0.26939334622422592862597355365753173828125000000000e7 * t92 * t148 - 0.36533122347390018886365465819835662841796875000000e5 * t64 * t148 - 0.24177894210750056430676521062850952148437500000000e6 * t61 * t148 + 0.25023897635898133729670217633247375488281250000000e5 * t70 * t148 + 0.37835396407252402359200346469879150390625000000000e5 * t67 * t148 - 0.55579307494075739759961739182472229003906250000000e4 * t55 * t148 - 0.35386583214747042896919965744018554687500000000000e4 * t78 * t148 + 0.60204011349495748912097811698913574218750000000000e3 * t75 * t148 - 0.27783894071055594186902046203613281250000000000000e1 * t60 * t148 + 0.15826686034676940283030271530151367187500000000000e1 * t52 * t148 - 0.77832075558393631936311721801757812500000000000000e0 * t51 * t148 + 0.11993199945242496237483764737844467163085937500000e6 * t65 * t148 - 0.15197776895384120889517694711685180664062500000000e6 * t62 * t148 - 0.78705521131031808188173773586750030517578125000000e6 * t71 * t148
  t208 = 0.10419483322152421429706657767295837402343750000000e7 * t68 * t148 + 0.22591402777130702064651770666241645812988281250000e7 * t73 * t148 - 0.15414639911795736595426744222640991210937500000000e6 * t96 * t148 + 0.98706358616647614071359877586364746093750000000000e6 * t56 * t148 - 0.31690718837237161122116232633590698242187500000000e7 * t79 * t148 - 0.37062695419646445367800896465778350830078125000000e7 * t76 * t148 + 0.56296854957717736143381428003311157226562500000000e7 * t83 * t148 + 0.37964221408846205205482554659247398376464843750000e7 * t81 * t148 - 0.64704806272098658368631352305412292480468750000000e7 * t87 * t148 - 0.24664815444310469451119224280118942260742187500000e7 * t85 * t148 + 0.50340687941345496970392523884773254394531250000000e7 * t90 * t148 - 0.10009133601145740528603394826253255208333333333333e0 * t131 + 0.41704723338107252202514145109388563368055555555556e-2 * t146 + 0.18325220975589510100615024566650390625000000000000e3 * t54 * t148 - 0.36487893946858568009309470653533935546875000000000e2 * t53 * t148
  t209 = t179 + t208
  t214 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t111 - t124 - 0.3e1 / 0.8e1 * t5 * t125 * t209)
  t216 = r1 <= f.p.dens_threshold
  t217 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t218 = 0.1e1 + t217
  t219 = t218 <= f.p.zeta_threshold
  t220 = t218 ** (0.1e1 / 0.3e1)
  t222 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t225 = f.my_piecewise3(t219, 0, 0.4e1 / 0.3e1 * t220 * t222)
  t226 = t225 * t30
  t227 = r1 ** 2
  t228 = r1 ** (0.1e1 / 0.3e1)
  t229 = t228 ** 2
  t232 = s2 / t229 / t227
  t235 = 0.4e1 + t37 * t232 / 0.24e2
  t236 = 0.1e1 / t235
  t238 = t37 * t232 * t236
  t240 = t238 / 0.12e2 - 0.1e1
  t241 = t240 ** 2
  t242 = t241 ** 2
  t244 = t242 * t240
  t247 = t241 * t240
  t249 = t242 * t247
  t251 = t242 ** 2
  t253 = t251 * t241
  t255 = t242 * t241
  t257 = t251 * t240
  t259 = t251 * t242
  t261 = t251 * t244
  t263 = t251 * t249
  t265 = t251 * t247
  t267 = t251 ** 2
  t269 = t251 * t255
  t271 = -0.69459735177638985467255115509033203125000000000000e0 * t242 - 0.72975787893717136018618941307067871093750000000000e1 * t244 - 0.38916037779196815968155860900878906250000000000000e0 * t241 + 0.52755620115589800943434238433837890625000000000000e0 * t247 + 0.86005730499279641302996873855590820312500000000000e2 * t249 - 0.44233229018433803621149957180023193359375000000000e3 * t251 + 0.37835396407252402359200346469879150390625000000000e4 * t253 + 0.30542034959315850167691707611083984375000000000000e2 * t255 - 0.61754786104528599733290821313858032226562500000000e3 * t257 - 0.20148245175625047025563767552375793457031250000000e5 * t259 - 0.2810240180568462991258881986141204833984375000000e4 * t261 - 0.10276426607863824396951162815093994140625000000000e5 * t263 + 0.22748997850816485208791106939315795898437500000000e4 * t265 - 0.16837084139014120539123347103595733642578125000000e6 * t267 + 0.70504541869034010050971341133117675781250000000000e5 * t269
  t272 = t267 * t241
  t274 = t267 * t242
  t276 = t267 * t240
  t278 = t267 * t244
  t280 = t267 * t247
  t282 = t267 * t255
  t284 = t267 * t249
  t286 = t267 * t251
  t288 = t267 * t265
  t290 = t267 * t257
  t292 = t267 * t259
  t294 = t267 * t253
  t299 = 0.11313514630621233134023547172546386718750000000000e1 + 0.27967048856303053872440291047096252441406250000000e6 * t272 - 0.32352403136049329184315676152706146240234375000000e6 * t274 + 0.56174007979372666952880866825580596923828125000000e5 * t276 + 0.18078200670879145335944073647260665893554687500000e6 * t278 - 0.12981481812794983921641696989536285400390625000000e6 * t280 + 0.25589479526235334610627921819686889648437500000000e6 * t282 - 0.16114215399846280594696041941642761230468750000000e6 * t284 - 0.13204466182182150467548430263996124267578125000000e6 * t286 - 0.29150193011493262291916212439537048339843750000000e5 * t288 + 0.90365611108522808258607082664966583251953125000000e5 * t290 - 0.54277774626371860319706052541732788085937500000000e4 * t292 + 0.40074935854432390114256376028060913085937500000000e5 * t294 + 0.41355861880146538749944016337394714355468750000000e4 * t267 * t261 + 0.37534251004296526982262730598449707031250000000000e-1 * t238
  t300 = t271 + t299
  t305 = f.my_piecewise3(t219, t116, t220 * t218)
  t306 = t305 * t120
  t309 = t5 * t306 * t300 / 0.8e1
  t311 = f.my_piecewise3(t216, 0, -0.3e1 / 0.8e1 * t5 * t226 * t300 - t309)
  t313 = t21 ** 2
  t314 = 0.1e1 / t313
  t315 = t26 ** 2
  t320 = t16 / t22 / t6
  t322 = -0.2e1 * t23 + 0.2e1 * t320
  t323 = f.my_piecewise5(t10, 0, t14, 0, t322)
  t327 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t314 * t315 + 0.4e1 / 0.3e1 * t21 * t323)
  t334 = t5 * t29 * t120 * t111
  t340 = 0.1e1 / t119 / t6
  t344 = t5 * t118 * t340 * t111 / 0.12e2
  t346 = t5 * t121 * t209
  t352 = t37 * s0 / t40 / t138 * t47
  t359 = t136 * t137 / t39 / t138 / t126 * t144
  t361 = t148 ** 2
  t374 = t33 ** 2
  t375 = 0.1e1 / t374
  t378 = t138 ** 2
  t384 = t375 * t137 * s0 / t378 / t38 / t143 / t46
  t386 = 0.22e2 / 0.27e2 * t352 - t359 / 0.12e2 + t384 / 0.81e2
  t401 = 0.36700156537534381938212447696261935763888888888888e0 * t352 - 0.37534251004296526982262730598449707031250000000000e-1 * t359 - 0.12293913191698745090039956938028335571289062500000e9 * t85 * t361 + 0.75928442817692410410965109318494796752929687500000e8 * t87 * t361 + 0.11822339541120724590110099880695343017578125000000e9 * t81 * t361 - 0.81537929923222179809161972224712371826171875000000e8 * t83 * t361 - 0.72888653325645470580867335057258605957031250000000e8 * t76 * t361 + 0.22591402777130702064651770666241645812988281250000e7 * t73 * t386 + 0.10419483322152421429706657767295837402343750000000e7 * t68 * t386 - 0.78705521131031808188173773586750030517578125000000e6 * t71 * t386 + 0.12831826620164189829276784086227416992187500000000e8 * t64 * t361 - 0.21580495876514031233597441911697387695312500000000e7 * t56 * t361 + 0.54219366665113684955164249598979949951171875000000e8 * t79 * t361 + 0.26048708305381053574266644418239593505859375000000e8 * t73 * t361
  t432 = 0.34051856766527162123280311822891235351562500000000e6 * t55 * t361 + 0.25023897635898133729670217633247375488281250000000e6 * t67 * t361 - 0.26595683631825062073744173169136047363281250000000e7 * t70 * t361 - 0.14595157578743427203723788261413574218750000000000e3 * t60 * t361 + 0.91626104877947550503075122833251953125000000000000e3 * t53 * t361 + 0.36122406809697449347258687019348144531250000000000e4 * t54 * t361 - 0.24770608250322930027843976020812988281250000000000e5 * t75 * t361 - 0.44463445995260591807969391345977783203125000000000e5 * t78 * t361 - 0.37062695419646445367800896465778350830078125000000e7 * t76 * t386 - 0.31690718837237161122116232633590698242187500000000e7 * t79 * t386 - 0.15197776895384120889517694711685180664062500000000e6 * t62 * t386 + 0.11993199945242496237483764737844467163085937500000e6 * t65 * t386 - 0.77832075558393631936311721801757812500000000000000e0 * t51 * t386 + 0.15826686034676940283030271530151367187500000000000e1 * t52 * t386 - 0.27783894071055594186902046203613281250000000000000e1 * t60 * t386
  t464 = -0.43839746816868022663638558983802795410156250000000e6 * t61 * t361 - 0.40409001933633889293896033048629760742187500000000e8 * t96 * t361 + 0.15279330170389365411183595776557922363281250000000e8 * t92 * t361 + 0.85579169500287344849667290604114532470703125000000e8 * t57 * t361 - 0.44396667799758845012014603704214096069335937500000e8 * t90 * t361 + 0.37835396407252402359200346469879150390625000000000e5 * t67 * t386 + 0.25023897635898133729670217633247375488281250000000e5 * t70 * t386 - 0.24177894210750056430676521062850952148437500000000e6 * t61 * t386 + 0.98706358616647614071359877586364746093750000000000e6 * t56 * t386 - 0.15414639911795736595426744222640991210937500000000e6 * t96 * t386 - 0.36533122347390018886365465819835662841796875000000e5 * t64 * t386 - 0.26939334622422592862597355365753173828125000000000e7 * t92 * t386 + 0.95495813564933533819897473603487014770507812500000e6 * t57 * t386 + 0.50340687941345496970392523884773254394531250000000e7 * t90 * t386 - 0.24664815444310469451119224280118942260742187500000e7 * t85 * t386
  t493 = -0.64704806272098658368631352305412292480468750000000e7 * t87 * t386 + 0.37964221408846205205482554659247398376464843750000e7 * t81 * t386 - 0.20463435494068270128925181132555007934570312500000e8 * t68 * t361 - 0.41033997617537126401697775721549987792968750000000e7 * t71 * t361 + 0.33580959846678989464954541265964508056640625000000e7 * t62 * t361 + 0.31653372069353880566060543060302734375000000000000e1 * t51 * t361 - 0.83351682213166782560706138610839843750000000000000e1 * t52 * t361 + 0.56296854957717736143381428003311157226562500000000e7 * t83 * t386 - 0.36487893946858568009309470653533935546875000000000e2 * t53 * t386 + 0.18325220975589510100615024566650390625000000000000e3 * t54 * t386 + 0.60204011349495748912097811698913574218750000000000e3 * t75 * t386 - 0.35386583214747042896919965744018554687500000000000e4 * t78 * t386 - 0.55579307494075739759961739182472229003906250000000e4 * t55 * t386 + 0.55606297784143002936685526812518084490740740740741e-2 * t384 - 0.77832075558393631936311721801757812500000000000000e0 * t361
  t500 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t327 * t30 * t111 - t334 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t209 + t344 - t346 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t125 * (t401 + t432 + t464 + t493))
  t501 = t220 ** 2
  t502 = 0.1e1 / t501
  t503 = t222 ** 2
  t507 = f.my_piecewise5(t14, 0, t10, 0, -t322)
  t511 = f.my_piecewise3(t219, 0, 0.4e1 / 0.9e1 * t502 * t503 + 0.4e1 / 0.3e1 * t220 * t507)
  t518 = t5 * t225 * t120 * t300
  t523 = t5 * t305 * t340 * t300 / 0.12e2
  t525 = f.my_piecewise3(t216, 0, -0.3e1 / 0.8e1 * t5 * t511 * t30 * t300 - t518 / 0.4e1 + t523)
  d11 = 0.2e1 * t214 + 0.2e1 * t311 + t6 * (t500 + t525)
  t528 = -t7 - t24
  t529 = f.my_piecewise5(t10, 0, t14, 0, t528)
  t532 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t529)
  t533 = t532 * t30
  t538 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t533 * t111 - t124)
  t540 = f.my_piecewise5(t14, 0, t10, 0, -t528)
  t543 = f.my_piecewise3(t219, 0, 0.4e1 / 0.3e1 * t220 * t540)
  t544 = t543 * t30
  t548 = t305 * t30
  t549 = t227 * r1
  t554 = t37 * s2 / t229 / t549 * t236
  t556 = s2 ** 2
  t557 = t227 ** 2
  t562 = t235 ** 2
  t563 = 0.1e1 / t562
  t565 = t136 * t556 / t228 / t557 / t227 * t563
  t567 = -0.2e1 / 0.9e1 * t554 + t565 / 0.108e3
  t598 = -0.26939334622422592862597355365753173828125000000000e7 * t263 * t567 + 0.50340687941345496970392523884773254394531250000000e7 * t276 * t567 + 0.95495813564933533819897473603487014770507812500000e6 * t267 * t567 - 0.64704806272098658368631352305412292480468750000000e7 * t280 * t567 - 0.24664815444310469451119224280118942260742187500000e7 * t272 * t567 + 0.37964221408846205205482554659247398376464843750000e7 * t274 * t567 - 0.37062695419646445367800896465778350830078125000000e7 * t282 * t567 + 0.56296854957717736143381428003311157226562500000000e7 * t278 * t567 - 0.31690718837237161122116232633590698242187500000000e7 * t284 * t567 + 0.22591402777130702064651770666241645812988281250000e7 * t286 * t567 - 0.78705521131031808188173773586750030517578125000000e6 * t294 * t567 + 0.10419483322152421429706657767295837402343750000000e7 * t290 * t567 + 0.60204011349495748912097811698913574218750000000000e3 * t255 * t567 + 0.18325220975589510100615024566650390625000000000000e3 * t244 * t567 + 0.37835396407252402359200346469879150390625000000000e5 * t257 * t567
  t627 = -0.55579307494075739759961739182472229003906250000000e4 * t251 * t567 - 0.15197776895384120889517694711685180664062500000000e6 * t288 * t567 + 0.11993199945242496237483764737844467163085937500000e6 * t292 * t567 - 0.36487893946858568009309470653533935546875000000000e2 * t242 * t567 - 0.27783894071055594186902046203613281250000000000000e1 * t247 * t567 + 0.15826686034676940283030271530151367187500000000000e1 * t241 * t567 - 0.77832075558393631936311721801757812500000000000000e0 * t240 * t567 - 0.35386583214747042896919965744018554687500000000000e4 * t249 * t567 - 0.36533122347390018886365465819835662841796875000000e5 * t259 * t567 - 0.24177894210750056430676521062850952148437500000000e6 * t265 * t567 + 0.25023897635898133729670217633247375488281250000000e5 * t253 * t567 - 0.15414639911795736595426744222640991210937500000000e6 * t269 * t567 + 0.98706358616647614071359877586364746093750000000000e6 * t261 * t567 - 0.10009133601145740528603394826253255208333333333333e0 * t554 + 0.41704723338107252202514145109388563368055555555556e-2 * t565
  t628 = t598 + t627
  t633 = f.my_piecewise3(t216, 0, -0.3e1 / 0.8e1 * t5 * t544 * t300 - t309 - 0.3e1 / 0.8e1 * t5 * t548 * t628)
  t637 = 0.2e1 * t320
  t638 = f.my_piecewise5(t10, 0, t14, 0, t637)
  t642 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t314 * t529 * t26 + 0.4e1 / 0.3e1 * t21 * t638)
  t649 = t5 * t532 * t120 * t111
  t657 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t642 * t30 * t111 - t649 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t533 * t209 - t334 / 0.8e1 + t344 - t346 / 0.8e1)
  t661 = f.my_piecewise5(t14, 0, t10, 0, -t637)
  t665 = f.my_piecewise3(t219, 0, 0.4e1 / 0.9e1 * t502 * t540 * t222 + 0.4e1 / 0.3e1 * t220 * t661)
  t672 = t5 * t543 * t120 * t300
  t679 = t5 * t306 * t628
  t682 = f.my_piecewise3(t216, 0, -0.3e1 / 0.8e1 * t5 * t665 * t30 * t300 - t672 / 0.8e1 - t518 / 0.8e1 + t523 - 0.3e1 / 0.8e1 * t5 * t226 * t628 - t679 / 0.8e1)
  d12 = t214 + t311 + t538 + t633 + t6 * (t657 + t682)
  t687 = t529 ** 2
  t691 = 0.2e1 * t23 + 0.2e1 * t320
  t692 = f.my_piecewise5(t10, 0, t14, 0, t691)
  t696 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t314 * t687 + 0.4e1 / 0.3e1 * t21 * t692)
  t703 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t696 * t30 * t111 - t649 / 0.4e1 + t344)
  t704 = t540 ** 2
  t708 = f.my_piecewise5(t14, 0, t10, 0, -t691)
  t712 = f.my_piecewise3(t219, 0, 0.4e1 / 0.9e1 * t502 * t704 + 0.4e1 / 0.3e1 * t220 * t708)
  t722 = t567 ** 2
  t751 = t37 * s2 / t229 / t557 * t236
  t758 = t136 * t556 / t228 / t557 / t549 * t563
  t762 = t557 ** 2
  t768 = t375 * t556 * s2 / t762 / t227 / t562 / t235
  t770 = 0.22e2 / 0.27e2 * t751 - t758 / 0.12e2 + t768 / 0.81e2
  t775 = -0.20463435494068270128925181132555007934570312500000e8 * t290 * t722 + 0.54219366665113684955164249598979949951171875000000e8 * t284 * t722 - 0.72888653325645470580867335057258605957031250000000e8 * t282 * t722 + 0.11822339541120724590110099880695343017578125000000e9 * t274 * t722 - 0.81537929923222179809161972224712371826171875000000e8 * t278 * t722 + 0.15279330170389365411183595776557922363281250000000e8 * t263 * t722 + 0.85579169500287344849667290604114532470703125000000e8 * t267 * t722 - 0.40409001933633889293896033048629760742187500000000e8 * t269 * t722 + 0.12831826620164189829276784086227416992187500000000e8 * t259 * t722 - 0.21580495876514031233597441911697387695312500000000e7 * t261 * t722 + 0.25023897635898133729670217633247375488281250000000e6 * t257 * t722 - 0.26595683631825062073744173169136047363281250000000e7 * t253 * t722 - 0.15197776895384120889517694711685180664062500000000e6 * t288 * t770 + 0.10419483322152421429706657767295837402343750000000e7 * t290 * t770
  t806 = -0.78705521131031808188173773586750030517578125000000e6 * t294 * t770 + 0.22591402777130702064651770666241645812988281250000e7 * t286 * t770 - 0.31690718837237161122116232633590698242187500000000e7 * t284 * t770 - 0.43839746816868022663638558983802795410156250000000e6 * t265 * t722 - 0.44463445995260591807969391345977783203125000000000e5 * t249 * t722 + 0.34051856766527162123280311822891235351562500000000e6 * t251 * t722 + 0.91626104877947550503075122833251953125000000000000e3 * t242 * t722 + 0.36122406809697449347258687019348144531250000000000e4 * t244 * t722 - 0.24770608250322930027843976020812988281250000000000e5 * t255 * t722 + 0.31653372069353880566060543060302734375000000000000e1 * t240 * t722 - 0.83351682213166782560706138610839843750000000000000e1 * t241 * t722 - 0.14595157578743427203723788261413574218750000000000e3 * t247 * t722 + 0.33580959846678989464954541265964508056640625000000e7 * t288 * t722 - 0.41033997617537126401697775721549987792968750000000e7 * t294 * t722 + 0.26048708305381053574266644418239593505859375000000e8 * t286 * t722
  t838 = -0.26939334622422592862597355365753173828125000000000e7 * t263 * t770 + 0.98706358616647614071359877586364746093750000000000e6 * t261 * t770 - 0.15414639911795736595426744222640991210937500000000e6 * t269 * t770 + 0.25023897635898133729670217633247375488281250000000e5 * t253 * t770 - 0.24177894210750056430676521062850952148437500000000e6 * t265 * t770 + 0.75928442817692410410965109318494796752929687500000e8 * t280 * t722 - 0.44396667799758845012014603704214096069335937500000e8 * t276 * t722 - 0.12293913191698745090039956938028335571289062500000e9 * t272 * t722 - 0.36533122347390018886365465819835662841796875000000e5 * t259 * t770 - 0.55579307494075739759961739182472229003906250000000e4 * t251 * t770 + 0.60204011349495748912097811698913574218750000000000e3 * t255 * t770 - 0.35386583214747042896919965744018554687500000000000e4 * t249 * t770 - 0.77832075558393631936311721801757812500000000000000e0 * t240 * t770 + 0.15826686034676940283030271530151367187500000000000e1 * t241 * t770 - 0.27783894071055594186902046203613281250000000000000e1 * t247 * t770
  t865 = -0.36487893946858568009309470653533935546875000000000e2 * t242 * t770 + 0.11993199945242496237483764737844467163085937500000e6 * t292 * t770 + 0.56296854957717736143381428003311157226562500000000e7 * t278 * t770 + 0.18325220975589510100615024566650390625000000000000e3 * t244 * t770 + 0.37835396407252402359200346469879150390625000000000e5 * t257 * t770 - 0.37062695419646445367800896465778350830078125000000e7 * t282 * t770 + 0.37964221408846205205482554659247398376464843750000e7 * t274 * t770 - 0.24664815444310469451119224280118942260742187500000e7 * t272 * t770 - 0.64704806272098658368631352305412292480468750000000e7 * t280 * t770 + 0.95495813564933533819897473603487014770507812500000e6 * t267 * t770 + 0.50340687941345496970392523884773254394531250000000e7 * t276 * t770 + 0.55606297784143002936685526812518084490740740740741e-2 * t768 + 0.36700156537534381938212447696261935763888888888888e0 * t751 - 0.37534251004296526982262730598449707031250000000000e-1 * t758 - 0.77832075558393631936311721801757812500000000000000e0 * t722
  t872 = f.my_piecewise3(t216, 0, -0.3e1 / 0.8e1 * t5 * t712 * t30 * t300 - t672 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t544 * t628 + t523 - t679 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t548 * (t775 + t806 + t838 + t865))
  d22 = 0.2e1 * t538 + 0.2e1 * t633 + t6 * (t703 + t872)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t55 = s0 / t52 / t50
  t58 = 0.4e1 + t49 * t55 / 0.24e2
  t59 = 0.1e1 / t58
  t61 = t49 * t55 * t59
  t63 = t61 / 0.12e2 - 0.1e1
  t64 = t63 ** 2
  t65 = t64 ** 2
  t66 = t65 ** 2
  t67 = t66 * t65
  t68 = t66 ** 2
  t69 = t68 * t67
  t71 = t65 * t63
  t72 = t66 * t71
  t75 = t66 * t64
  t76 = t68 * t75
  t78 = t64 * t63
  t79 = t66 * t78
  t80 = t68 * t79
  t82 = t68 * t66
  t84 = t66 * t63
  t85 = t68 * t84
  t87 = t65 * t78
  t88 = t68 * t87
  t90 = t68 * t71
  t92 = t65 * t64
  t93 = t68 * t92
  t95 = t68 * t78
  t97 = t68 * t65
  t99 = t68 * t63
  t101 = t68 * t64
  t104 = t66 * t92
  t106 = -0.54277774626371860319706052541732788085937500000000e4 * t69 + 0.41355861880146538749944016337394714355468750000000e4 * t68 * t72 + 0.40074935854432390114256376028060913085937500000000e5 * t76 - 0.29150193011493262291916212439537048339843750000000e5 * t80 - 0.13204466182182150467548430263996124267578125000000e6 * t82 + 0.90365611108522808258607082664966583251953125000000e5 * t85 - 0.16114215399846280594696041941642761230468750000000e6 * t88 + 0.18078200670879145335944073647260665893554687500000e6 * t90 + 0.25589479526235334610627921819686889648437500000000e6 * t93 - 0.12981481812794983921641696989536285400390625000000e6 * t95 - 0.32352403136049329184315676152706146240234375000000e6 * t97 + 0.56174007979372666952880866825580596923828125000000e5 * t99 + 0.27967048856303053872440291047096252441406250000000e6 * t101 - 0.16837084139014120539123347103595733642578125000000e6 * t68 + 0.70504541869034010050971341133117675781250000000000e5 * t104
  t107 = t66 * t87
  t122 = 0.11313514630621233134023547172546386718750000000000e1 - 0.10276426607863824396951162815093994140625000000000e5 * t107 - 0.20148245175625047025563767552375793457031250000000e5 * t67 - 0.2810240180568462991258881986141204833984375000000e4 * t72 + 0.37835396407252402359200346469879150390625000000000e4 * t75 + 0.22748997850816485208791106939315795898437500000000e4 * t79 - 0.44233229018433803621149957180023193359375000000000e3 * t66 - 0.61754786104528599733290821313858032226562500000000e3 * t84 + 0.86005730499279641302996873855590820312500000000000e2 * t87 - 0.72975787893717136018618941307067871093750000000000e1 * t71 + 0.30542034959315850167691707611083984375000000000000e2 * t92 + 0.52755620115589800943434238433837890625000000000000e0 * t78 - 0.69459735177638985467255115509033203125000000000000e0 * t65 - 0.38916037779196815968155860900878906250000000000000e0 * t64 + 0.37534251004296526982262730598449707031250000000000e-1 * t61
  t123 = t106 + t122
  t129 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t130 = t42 ** 2
  t131 = 0.1e1 / t130
  t132 = t129 * t131
  t136 = t129 * t42
  t137 = t50 * r0
  t142 = t49 * s0 / t52 / t137 * t59
  t144 = t44 ** 2
  t147 = t144 / t46 / t45
  t148 = s0 ** 2
  t149 = t50 ** 2
  t154 = t58 ** 2
  t155 = 0.1e1 / t154
  t157 = t147 * t148 / t51 / t149 / t50 * t155
  t161 = -0.2e1 / 0.9e1 * t142 + t157 / 0.108e3
  t184 = t84 * t161
  t188 = -0.10009133601145740528603394826253255208333333333333e0 * t142 + 0.41704723338107252202514145109388563368055555555556e-2 * t157 + 0.56296854957717736143381428003311157226562500000000e7 * t90 * t161 + 0.37964221408846205205482554659247398376464843750000e7 * t97 * t161 - 0.64704806272098658368631352305412292480468750000000e7 * t95 * t161 - 0.24664815444310469451119224280118942260742187500000e7 * t101 * t161 + 0.50340687941345496970392523884773254394531250000000e7 * t99 * t161 + 0.95495813564933533819897473603487014770507812500000e6 * t68 * t161 - 0.15414639911795736595426744222640991210937500000000e6 * t104 * t161 + 0.98706358616647614071359877586364746093750000000000e6 * t72 * t161 - 0.36533122347390018886365465819835662841796875000000e5 * t67 * t161 - 0.24177894210750056430676521062850952148437500000000e6 * t79 * t161 + 0.25023897635898133729670217633247375488281250000000e5 * t75 * t161 + 0.37835396407252402359200346469879150390625000000000e5 * t184 - 0.55579307494075739759961739182472229003906250000000e4 * t66 * t161
  t205 = t80 * t161
  t207 = t76 * t161
  t219 = -0.35386583214747042896919965744018554687500000000000e4 * t87 * t161 + 0.60204011349495748912097811698913574218750000000000e3 * t92 * t161 + 0.18325220975589510100615024566650390625000000000000e3 * t71 * t161 - 0.36487893946858568009309470653533935546875000000000e2 * t65 * t161 - 0.27783894071055594186902046203613281250000000000000e1 * t78 * t161 + 0.15826686034676940283030271530151367187500000000000e1 * t64 * t161 - 0.77832075558393631936311721801757812500000000000000e0 * t63 * t161 + 0.11993199945242496237483764737844467163085937500000e6 * t69 * t161 - 0.15197776895384120889517694711685180664062500000000e6 * t205 - 0.78705521131031808188173773586750030517578125000000e6 * t207 - 0.26939334622422592862597355365753173828125000000000e7 * t107 * t161 + 0.10419483322152421429706657767295837402343750000000e7 * t85 * t161 + 0.22591402777130702064651770666241645812988281250000e7 * t82 * t161 - 0.31690718837237161122116232633590698242187500000000e7 * t88 * t161 - 0.37062695419646445367800896465778350830078125000000e7 * t93 * t161
  t220 = t188 + t219
  t224 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t225 = t224 * f.p.zeta_threshold
  t227 = f.my_piecewise3(t20, t225, t21 * t19)
  t229 = 0.1e1 / t130 / t6
  t230 = t227 * t229
  t234 = t227 * t131
  t238 = t227 * t42
  t239 = t161 ** 2
  t245 = t49 * s0 / t52 / t149 * t59
  t252 = t147 * t148 / t51 / t149 / t137 * t155
  t276 = -0.77832075558393631936311721801757812500000000000000e0 * t239 + 0.36700156537534381938212447696261935763888888888888e0 * t245 - 0.37534251004296526982262730598449707031250000000000e-1 * t252 + 0.34051856766527162123280311822891235351562500000000e6 * t66 * t239 + 0.25023897635898133729670217633247375488281250000000e6 * t84 * t239 - 0.26595683631825062073744173169136047363281250000000e7 * t75 * t239 - 0.43839746816868022663638558983802795410156250000000e6 * t79 * t239 + 0.12831826620164189829276784086227416992187500000000e8 * t67 * t239 - 0.21580495876514031233597441911697387695312500000000e7 * t72 * t239 + 0.15279330170389365411183595776557922363281250000000e8 * t107 * t239 + 0.85579169500287344849667290604114532470703125000000e8 * t68 * t239 - 0.44396667799758845012014603704214096069335937500000e8 * t99 * t239 - 0.12293913191698745090039956938028335571289062500000e9 * t101 * t239 + 0.75928442817692410410965109318494796752929687500000e8 * t95 * t239
  t285 = t45 ** 2
  t286 = 0.1e1 / t285
  t288 = t286 * t148 * s0
  t289 = t149 ** 2
  t293 = 0.1e1 / t154 / t58
  t295 = t288 / t289 / t50 * t293
  t297 = 0.22e2 / 0.27e2 * t245 - t252 / 0.12e2 + t295 / 0.81e2
  t302 = t63 * t297
  t322 = 0.11822339541120724590110099880695343017578125000000e9 * t97 * t239 - 0.81537929923222179809161972224712371826171875000000e8 * t90 * t239 - 0.72888653325645470580867335057258605957031250000000e8 * t93 * t239 - 0.15197776895384120889517694711685180664062500000000e6 * t80 * t297 + 0.11993199945242496237483764737844467163085937500000e6 * t69 * t297 - 0.77832075558393631936311721801757812500000000000000e0 * t302 + 0.54219366665113684955164249598979949951171875000000e8 * t88 * t239 + 0.26048708305381053574266644418239593505859375000000e8 * t82 * t239 - 0.40409001933633889293896033048629760742187500000000e8 * t104 * t239 - 0.20463435494068270128925181132555007934570312500000e8 * t85 * t239 - 0.41033997617537126401697775721549987792968750000000e7 * t76 * t239 + 0.33580959846678989464954541265964508056640625000000e7 * t80 * t239 + 0.31653372069353880566060543060302734375000000000000e1 * t63 * t239 - 0.83351682213166782560706138610839843750000000000000e1 * t64 * t239 - 0.14595157578743427203723788261413574218750000000000e3 * t78 * t239
  t332 = t88 * t297
  t334 = t82 * t297
  t336 = t85 * t297
  t338 = t64 * t297
  t340 = t78 * t297
  t342 = t65 * t297
  t344 = t71 * t297
  t346 = t92 * t297
  t348 = t87 * t297
  t350 = t66 * t297
  t354 = 0.91626104877947550503075122833251953125000000000000e3 * t65 * t239 + 0.36122406809697449347258687019348144531250000000000e4 * t71 * t239 - 0.24770608250322930027843976020812988281250000000000e5 * t92 * t239 - 0.44463445995260591807969391345977783203125000000000e5 * t87 * t239 - 0.31690718837237161122116232633590698242187500000000e7 * t332 + 0.22591402777130702064651770666241645812988281250000e7 * t334 + 0.10419483322152421429706657767295837402343750000000e7 * t336 + 0.15826686034676940283030271530151367187500000000000e1 * t338 - 0.27783894071055594186902046203613281250000000000000e1 * t340 - 0.36487893946858568009309470653533935546875000000000e2 * t342 + 0.18325220975589510100615024566650390625000000000000e3 * t344 + 0.60204011349495748912097811698913574218750000000000e3 * t346 - 0.35386583214747042896919965744018554687500000000000e4 * t348 - 0.55579307494075739759961739182472229003906250000000e4 * t350 + 0.37835396407252402359200346469879150390625000000000e5 * t84 * t297
  t355 = t75 * t297
  t357 = t79 * t297
  t359 = t67 * t297
  t361 = t72 * t297
  t363 = t107 * t297
  t367 = t104 * t297
  t369 = t68 * t297
  t371 = t99 * t297
  t373 = t101 * t297
  t375 = t95 * t297
  t377 = t97 * t297
  t379 = t90 * t297
  t381 = t93 * t297
  t384 = 0.25023897635898133729670217633247375488281250000000e5 * t355 - 0.24177894210750056430676521062850952148437500000000e6 * t357 - 0.36533122347390018886365465819835662841796875000000e5 * t359 + 0.98706358616647614071359877586364746093750000000000e6 * t361 - 0.26939334622422592862597355365753173828125000000000e7 * t363 - 0.78705521131031808188173773586750030517578125000000e6 * t76 * t297 - 0.15414639911795736595426744222640991210937500000000e6 * t367 + 0.95495813564933533819897473603487014770507812500000e6 * t369 + 0.50340687941345496970392523884773254394531250000000e7 * t371 - 0.24664815444310469451119224280118942260742187500000e7 * t373 - 0.64704806272098658368631352305412292480468750000000e7 * t375 + 0.37964221408846205205482554659247398376464843750000e7 * t377 + 0.56296854957717736143381428003311157226562500000000e7 * t379 - 0.37062695419646445367800896465778350830078125000000e7 * t381 + 0.55606297784143002936685526812518084490740740740741e-2 * t295
  t386 = t276 + t322 + t354 + t384
  t391 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t123 - t5 * t132 * t123 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t136 * t220 + t5 * t230 * t123 / 0.12e2 - t5 * t234 * t220 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t238 * t386)
  t393 = r1 <= f.p.dens_threshold
  t394 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t395 = 0.1e1 + t394
  t396 = t395 <= f.p.zeta_threshold
  t397 = t395 ** (0.1e1 / 0.3e1)
  t398 = t397 ** 2
  t399 = 0.1e1 / t398
  t401 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t402 = t401 ** 2
  t406 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t410 = f.my_piecewise3(t396, 0, 0.4e1 / 0.9e1 * t399 * t402 + 0.4e1 / 0.3e1 * t397 * t406)
  t412 = r1 ** 2
  t413 = r1 ** (0.1e1 / 0.3e1)
  t414 = t413 ** 2
  t417 = s2 / t414 / t412
  t423 = t49 * t417 / (0.4e1 + t49 * t417 / 0.24e2)
  t425 = t423 / 0.12e2 - 0.1e1
  t426 = t425 ** 2
  t427 = t426 ** 2
  t430 = t426 * t425
  t432 = t427 * t430
  t434 = t427 * t425
  t436 = t427 * t426
  t438 = t427 ** 2
  t439 = t438 * t425
  t441 = t438 * t426
  t443 = t438 * t427
  t448 = t438 * t430
  t450 = t438 * t434
  t454 = t438 ** 2
  t456 = -0.69459735177638985467255115509033203125000000000000e0 * t427 - 0.38916037779196815968155860900878906250000000000000e0 * t426 + 0.52755620115589800943434238433837890625000000000000e0 * t430 + 0.86005730499279641302996873855590820312500000000000e2 * t432 - 0.72975787893717136018618941307067871093750000000000e1 * t434 + 0.30542034959315850167691707611083984375000000000000e2 * t436 - 0.61754786104528599733290821313858032226562500000000e3 * t439 + 0.37835396407252402359200346469879150390625000000000e4 * t441 - 0.20148245175625047025563767552375793457031250000000e5 * t443 - 0.44233229018433803621149957180023193359375000000000e3 * t438 + 0.70504541869034010050971341133117675781250000000000e5 * t438 * t436 + 0.22748997850816485208791106939315795898437500000000e4 * t448 - 0.2810240180568462991258881986141204833984375000000e4 * t450 - 0.10276426607863824396951162815093994140625000000000e5 * t438 * t432 - 0.16837084139014120539123347103595733642578125000000e6 * t454
  t484 = 0.11313514630621233134023547172546386718750000000000e1 + 0.56174007979372666952880866825580596923828125000000e5 * t454 * t425 + 0.27967048856303053872440291047096252441406250000000e6 * t454 * t426 + 0.18078200670879145335944073647260665893554687500000e6 * t454 * t434 - 0.12981481812794983921641696989536285400390625000000e6 * t454 * t430 - 0.32352403136049329184315676152706146240234375000000e6 * t454 * t427 - 0.13204466182182150467548430263996124267578125000000e6 * t454 * t438 + 0.25589479526235334610627921819686889648437500000000e6 * t454 * t436 + 0.90365611108522808258607082664966583251953125000000e5 * t454 * t439 - 0.16114215399846280594696041941642761230468750000000e6 * t454 * t432 - 0.54277774626371860319706052541732788085937500000000e4 * t454 * t443 + 0.40074935854432390114256376028060913085937500000000e5 * t454 * t441 - 0.29150193011493262291916212439537048339843750000000e5 * t454 * t448 + 0.41355861880146538749944016337394714355468750000000e4 * t454 * t450 + 0.37534251004296526982262730598449707031250000000000e-1 * t423
  t485 = t456 + t484
  t491 = f.my_piecewise3(t396, 0, 0.4e1 / 0.3e1 * t397 * t401)
  t497 = f.my_piecewise3(t396, t225, t397 * t395)
  t503 = f.my_piecewise3(t393, 0, -0.3e1 / 0.8e1 * t5 * t410 * t42 * t485 - t5 * t491 * t131 * t485 / 0.4e1 + t5 * t497 * t229 * t485 / 0.12e2)
  t513 = t24 ** 2
  t517 = 0.6e1 * t33 - 0.6e1 * t16 / t513
  t518 = f.my_piecewise5(t10, 0, t14, 0, t517)
  t522 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t518)
  t545 = 0.1e1 / t130 / t24
  t556 = t239 * t161
  t575 = t149 * r0
  t580 = t49 * s0 / t52 / t575 * t59
  t586 = t147 * t148 / t51 / t289 * t155
  t591 = t288 / t289 / t137 * t293
  t593 = t148 ** 2
  t599 = t154 ** 2
  t603 = t286 * t593 / t52 / t289 / t575 / t599 * t44 * t48
  t605 = -0.308e3 / 0.81e2 * t580 + 0.341e3 / 0.486e3 * t586 - 0.19e2 / 0.81e2 * t591 + t603 / 0.243e3
  t631 = 0.56296854957717736143381428003311157226562500000000e7 * t90 * t605 + 0.37964221408846205205482554659247398376464843750000e7 * t97 * t605 - 0.28054644639468240603676674485206604003906250000000e8 * t67 * t556 - 0.48223721498554824930002414882183074951171875000000e7 * t75 * t556 - 0.26595683631825062073744173169136047363281250000000e8 * t84 * t556 + 0.15398191944197027795132140903472900390625000000000e9 * t79 * t556 + 0.90668591586033271555377261418104171752929687500000e8 * t76 * t556 - 0.10668839380559652864441421687602996826171875000000e9 * t85 * t556 - 0.51158588735170675322312952831387519836425781250000e9 * t82 * t556 - 0.56572602707087445011454446268081665039062500000000e9 * t72 * t556 - 0.31690718837237161122116232633590698242187500000000e7 * t88 * t605
  t655 = -0.78705521131031808188173773586750030517578125000000e6 * t76 * t605 - 0.26939334622422592862597355365753173828125000000000e7 * t107 * t605 + 0.98706358616647614071359877586364746093750000000000e6 * t72 * t605 - 0.36533122347390018886365465819835662841796875000000e5 * t67 * t605 - 0.24177894210750056430676521062850952148437500000000e6 * t79 * t605 + 0.25023897635898133729670217633247375488281250000000e5 * t75 * t605 + 0.37835396407252402359200346469879150390625000000000e5 * t84 * t605 + 0.23644679082241449180220199761390686035156250000000e10 * t95 * t556 + 0.14426404135361557978083370770514011383056640625000e10 * t101 * t556 - 0.22129043745057741162071922488451004028320312500000e10 * t99 * t556 - 0.75474335259590036520424826297163963317871093750000e9 * t68 * t556
  t678 = 0.13692667120045975175946766496658325195312500000000e10 * t107 * t556 + 0.22918995255584048116775393664836883544921875000000e9 * t104 * t556 - 0.31124412196682414265578573942184448242187500000000e6 * t92 * t556 - 0.14862364950193758016706385612487792968750000000000e6 * t71 * t556 - 0.36487893946858568009309470653533935546875000000000e2 * t65 * t605 - 0.23349622667518089580893516540527343750000000000000e1 * t161 * t297 - 0.77832075558393631936311721801757812500000000000000e0 * t63 * t605 + 0.11993199945242496237483764737844467163085937500000e6 * t69 * t605 - 0.15197776895384120889517694711685180664062500000000e6 * t80 * t605 - 0.27783894071055594186902046203613281250000000000000e1 * t78 * t605 + 0.15826686034676940283030271530151367187500000000000e1 * t64 * t605
  t703 = 0.10419483322152421429706657767295837402343750000000e7 * t85 * t605 - 0.64704806272098658368631352305412292480468750000000e7 * t95 * t605 - 0.24664815444310469451119224280118942260742187500000e7 * t101 * t605 + 0.50340687941345496970392523884773254394531250000000e7 * t99 * t605 + 0.95495813564933533819897473603487014770507812500000e6 * t68 * t605 - 0.15414639911795736595426744222640991210937500000000e6 * t104 * t605 + 0.22521507872308320356703195869922637939453125000000e7 * t66 * t556 + 0.22591402777130702064651770666241645812988281250000e7 * t82 * t605 - 0.55579307494075739759961739182472229003906250000000e4 * t66 * t605 - 0.35386583214747042896919965744018554687500000000000e4 * t87 * t605 + 0.60204011349495748912097811698913574218750000000000e3 * t92 * t605
  t723 = 0.18325220975589510100615024566650390625000000000000e3 * t71 * t605 - 0.17126739717516044904499142258255570023148148148148e1 * t580 + 0.31602912573987940002349607738447778018904320987655e0 * t586 + 0.18535432594714334312228508937506028163580246913580e-2 * t603 + 0.22778532845307723123289532795548439025878906250000e9 * t375 * t161 - 0.36881739575096235270119870814085006713867187500000e9 * t373 * t161 - 0.13319000339927653503604381111264228820800781250000e9 * t371 * t161 + 0.25673750850086203454900187181234359741210937500000e9 * t369 * t161 + 0.45837990511168096233550787329673767089843750000000e8 * t363 * t161 - 0.64741487629542093700792325735092163085937500000000e7 * t361 * t161 - 0.61390306482204810386775543397665023803710937500000e8 * t336 * t161
  t747 = -0.12122700580090166788168809914588928222656250000000e9 * t367 * t161 + 0.38495479860492569487830352258682250976562500000000e8 * t359 * t161 - 0.13151924045060406799091567695140838623046875000000e7 * t357 * t161 - 0.79787050895475186221232519507408142089843750000000e7 * t355 * t161 + 0.10215557029958148636984093546867370605468750000000e7 * t350 * t161 - 0.13339033798578177542390817403793334960937500000000e6 * t348 * t161 - 0.74311824750968790083531928062438964843750000000000e5 * t346 * t161 + 0.10836722042909234804177606105804443359375000000000e5 * t344 * t161 + 0.27487831463384265150922536849975585937500000000000e4 * t342 * t161 - 0.43785472736230281611171364784240722656250000000000e3 * t340 * t161 + 0.78146124916143160722799933254718780517578125000000e8 * t334 * t161
  t768 = 0.94960116208061641698181629180908203125000000000000e1 * t302 * t161 - 0.25005504663950034768211841583251953125000000000000e2 * t338 * t161 - 0.21866595997693641174260200517177581787109375000000e9 * t381 * t161 + 0.16265809999534105486549274879693984985351562500000e9 * t332 * t161 + 0.10074287954003696839486362379789352416992187500000e8 * t205 * t297 - 0.12310199285261137920509332716464996337890625000000e8 * t207 * t297 + 0.75071692907694401189010652899742126464843750000000e6 * t184 * t297 - 0.24461378976966653942748591667413711547851562500000e9 * t379 * t161 + 0.35467018623362173770330299642086029052734375000000e9 * t377 * t161 - 0.10565196578987170557970250094378436053240740740741e0 * t591 + 0.31653372069353880566060543060302734375000000000000e1 * t556
  t776 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t522 * t42 * t123 - 0.3e1 / 0.8e1 * t5 * t41 * t131 * t123 - 0.9e1 / 0.8e1 * t5 * t43 * t220 + t5 * t129 * t229 * t123 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t132 * t220 - 0.9e1 / 0.8e1 * t5 * t136 * t386 - 0.5e1 / 0.36e2 * t5 * t227 * t545 * t123 + t5 * t230 * t220 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t234 * t386 - 0.3e1 / 0.8e1 * t5 * t238 * (0.62516899932914528578239946603775024414062500000000e9 * t88 * t556 + 0.12470454332976147539687777407765388488769531250000e10 * t93 * t556 - 0.16035503731642003527790813712596893310546875000000e10 * t90 * t556 - 0.17122965283876657759924014167189598083496093750000e10 * t97 * t556 + 0.18061203404848724673629343509674072265625000000000e5 * t65 * t556 + 0.36650441951179020201230049133300781250000000000000e4 * t78 * t556 - 0.43785472736230281611171364784240722656250000000000e3 * t64 * t556 - 0.16670336442633356512141227722167968750000000000000e2 * t63 * t556 + 0.27241485413221729698624249458312988281250000000000e7 * t87 * t556 - 0.37062695419646445367800896465778350830078125000000e7 * t93 * t605 + t631 + t655 + t678 + t703 + t723 + t747 + t768))
  t786 = f.my_piecewise5(t14, 0, t10, 0, -t517)
  t790 = f.my_piecewise3(t396, 0, -0.8e1 / 0.27e2 / t398 / t395 * t402 * t401 + 0.4e1 / 0.3e1 * t399 * t401 * t406 + 0.4e1 / 0.3e1 * t397 * t786)
  t808 = f.my_piecewise3(t393, 0, -0.3e1 / 0.8e1 * t5 * t790 * t42 * t485 - 0.3e1 / 0.8e1 * t5 * t410 * t131 * t485 + t5 * t491 * t229 * t485 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t497 * t545 * t485)
  d111 = 0.3e1 * t391 + 0.3e1 * t503 + t6 * (t776 + t808)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = 0.1e1 / t59
  t61 = t56 * t60
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t67 = s0 / t64 / t62
  t70 = 0.4e1 + t61 * t67 / 0.24e2
  t71 = 0.1e1 / t70
  t73 = t61 * t67 * t71
  t75 = t73 / 0.12e2 - 0.1e1
  t76 = t75 ** 2
  t77 = t76 ** 2
  t78 = t77 ** 2
  t79 = t78 ** 2
  t80 = t79 * t78
  t82 = t77 * t76
  t83 = t79 * t82
  t85 = t76 * t75
  t86 = t77 * t85
  t87 = t79 * t86
  t89 = t79 * t77
  t91 = t77 * t75
  t92 = t79 * t91
  t94 = t79 * t76
  t96 = t79 * t85
  t99 = t79 * t75
  t101 = t78 * t86
  t103 = t78 * t91
  t105 = t78 * t82
  t107 = t78 * t85
  t109 = t78 * t77
  t111 = t78 * t75
  t113 = -0.13204466182182150467548430263996124267578125000000e6 * t80 + 0.25589479526235334610627921819686889648437500000000e6 * t83 - 0.16114215399846280594696041941642761230468750000000e6 * t87 - 0.32352403136049329184315676152706146240234375000000e6 * t89 + 0.18078200670879145335944073647260665893554687500000e6 * t92 + 0.27967048856303053872440291047096252441406250000000e6 * t94 - 0.12981481812794983921641696989536285400390625000000e6 * t96 - 0.16837084139014120539123347103595733642578125000000e6 * t79 + 0.56174007979372666952880866825580596923828125000000e5 * t99 - 0.10276426607863824396951162815093994140625000000000e5 * t101 - 0.2810240180568462991258881986141204833984375000000e4 * t103 + 0.70504541869034010050971341133117675781250000000000e5 * t105 + 0.22748997850816485208791106939315795898437500000000e4 * t107 - 0.20148245175625047025563767552375793457031250000000e5 * t109 - 0.61754786104528599733290821313858032226562500000000e3 * t111
  t114 = t78 * t76
  t125 = t79 * t107
  t127 = t79 * t109
  t129 = t79 * t111
  t131 = t79 * t114
  t134 = 0.11313514630621233134023547172546386718750000000000e1 + 0.37835396407252402359200346469879150390625000000000e4 * t114 - 0.44233229018433803621149957180023193359375000000000e3 * t78 + 0.30542034959315850167691707611083984375000000000000e2 * t82 + 0.86005730499279641302996873855590820312500000000000e2 * t86 - 0.69459735177638985467255115509033203125000000000000e0 * t77 - 0.72975787893717136018618941307067871093750000000000e1 * t91 - 0.38916037779196815968155860900878906250000000000000e0 * t76 + 0.52755620115589800943434238433837890625000000000000e0 * t85 + 0.41355861880146538749944016337394714355468750000000e4 * t79 * t103 - 0.29150193011493262291916212439537048339843750000000e5 * t125 - 0.54277774626371860319706052541732788085937500000000e4 * t127 + 0.90365611108522808258607082664966583251953125000000e5 * t129 + 0.40074935854432390114256376028060913085937500000000e5 * t131 + 0.37534251004296526982262730598449707031250000000000e-1 * t73
  t135 = t113 + t134
  t144 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t145 = t54 ** 2
  t146 = 0.1e1 / t145
  t147 = t144 * t146
  t151 = t144 * t54
  t152 = t62 * r0
  t157 = t61 * s0 / t64 / t152 * t71
  t159 = t56 ** 2
  t161 = 0.1e1 / t58 / t57
  t162 = t159 * t161
  t163 = s0 ** 2
  t164 = t62 ** 2
  t165 = t164 * t62
  t169 = t70 ** 2
  t170 = 0.1e1 / t169
  t172 = t162 * t163 / t63 / t165 * t170
  t176 = -0.2e1 / 0.9e1 * t157 + t172 / 0.108e3
  t195 = t85 * t176
  t203 = -0.10009133601145740528603394826253255208333333333333e0 * t157 + 0.41704723338107252202514145109388563368055555555556e-2 * t172 - 0.36533122347390018886365465819835662841796875000000e5 * t109 * t176 - 0.24177894210750056430676521062850952148437500000000e6 * t107 * t176 + 0.25023897635898133729670217633247375488281250000000e5 * t114 * t176 + 0.37835396407252402359200346469879150390625000000000e5 * t111 * t176 - 0.55579307494075739759961739182472229003906250000000e4 * t78 * t176 - 0.35386583214747042896919965744018554687500000000000e4 * t86 * t176 + 0.60204011349495748912097811698913574218750000000000e3 * t82 * t176 + 0.18325220975589510100615024566650390625000000000000e3 * t91 * t176 - 0.36487893946858568009309470653533935546875000000000e2 * t77 * t176 - 0.27783894071055594186902046203613281250000000000000e1 * t195 + 0.15826686034676940283030271530151367187500000000000e1 * t76 * t176 - 0.77832075558393631936311721801757812500000000000000e0 * t75 * t176 + 0.11993199945242496237483764737844467163085937500000e6 * t127 * t176
  t204 = t125 * t176
  t206 = t131 * t176
  t210 = t129 * t176
  t230 = t105 * t176
  t234 = -0.15197776895384120889517694711685180664062500000000e6 * t204 - 0.78705521131031808188173773586750030517578125000000e6 * t206 - 0.26939334622422592862597355365753173828125000000000e7 * t101 * t176 + 0.10419483322152421429706657767295837402343750000000e7 * t210 + 0.22591402777130702064651770666241645812988281250000e7 * t80 * t176 - 0.31690718837237161122116232633590698242187500000000e7 * t87 * t176 - 0.37062695419646445367800896465778350830078125000000e7 * t83 * t176 + 0.56296854957717736143381428003311157226562500000000e7 * t92 * t176 + 0.37964221408846205205482554659247398376464843750000e7 * t89 * t176 - 0.64704806272098658368631352305412292480468750000000e7 * t96 * t176 - 0.24664815444310469451119224280118942260742187500000e7 * t94 * t176 + 0.50340687941345496970392523884773254394531250000000e7 * t99 * t176 + 0.95495813564933533819897473603487014770507812500000e6 * t79 * t176 - 0.15414639911795736595426744222640991210937500000000e6 * t230 + 0.98706358616647614071359877586364746093750000000000e6 * t103 * t176
  t235 = t203 + t234
  t241 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t243 = 0.1e1 / t145 / t6
  t244 = t241 * t243
  t248 = t241 * t146
  t252 = t241 * t54
  t253 = t57 ** 2
  t254 = 0.1e1 / t253
  t256 = t254 * t163 * s0
  t257 = t164 ** 2
  t261 = 0.1e1 / t169 / t70
  t263 = t256 / t257 / t62 * t261
  t269 = t61 * s0 / t64 / t164 * t71
  t276 = t162 * t163 / t63 / t164 / t152 * t170
  t281 = 0.22e2 / 0.27e2 * t269 - t276 / 0.12e2 + t263 / 0.81e2
  t284 = t75 * t281
  t286 = t76 * t281
  t290 = t77 * t281
  t292 = t91 * t281
  t294 = t176 ** 2
  t296 = t82 * t281
  t298 = t86 * t281
  t300 = t78 * t281
  t302 = t111 * t281
  t304 = 0.55606297784143002936685526812518084490740740740741e-2 * t263 + 0.36700156537534381938212447696261935763888888888888e0 * t269 - 0.37534251004296526982262730598449707031250000000000e-1 * t276 + 0.10419483322152421429706657767295837402343750000000e7 * t129 * t281 - 0.77832075558393631936311721801757812500000000000000e0 * t284 + 0.15826686034676940283030271530151367187500000000000e1 * t286 - 0.27783894071055594186902046203613281250000000000000e1 * t85 * t281 - 0.36487893946858568009309470653533935546875000000000e2 * t290 + 0.18325220975589510100615024566650390625000000000000e3 * t292 - 0.77832075558393631936311721801757812500000000000000e0 * t294 + 0.60204011349495748912097811698913574218750000000000e3 * t296 - 0.35386583214747042896919965744018554687500000000000e4 * t298 - 0.55579307494075739759961739182472229003906250000000e4 * t300 + 0.37835396407252402359200346469879150390625000000000e5 * t302
  t305 = t114 * t281
  t307 = t107 * t281
  t309 = t109 * t281
  t311 = t103 * t281
  t315 = t79 * t281
  t317 = t99 * t281
  t321 = t94 * t294
  t323 = t96 * t294
  t325 = t89 * t294
  t327 = t92 * t294
  t329 = t83 * t294
  t331 = t87 * t294
  t333 = t80 * t294
  t335 = 0.25023897635898133729670217633247375488281250000000e5 * t305 - 0.24177894210750056430676521062850952148437500000000e6 * t307 - 0.36533122347390018886365465819835662841796875000000e5 * t309 + 0.98706358616647614071359877586364746093750000000000e6 * t311 - 0.15414639911795736595426744222640991210937500000000e6 * t105 * t281 + 0.95495813564933533819897473603487014770507812500000e6 * t315 + 0.50340687941345496970392523884773254394531250000000e7 * t317 + 0.11993199945242496237483764737844467163085937500000e6 * t127 * t281 - 0.12293913191698745090039956938028335571289062500000e9 * t321 + 0.75928442817692410410965109318494796752929687500000e8 * t323 + 0.11822339541120724590110099880695343017578125000000e9 * t325 - 0.81537929923222179809161972224712371826171875000000e8 * t327 - 0.72888653325645470580867335057258605957031250000000e8 * t329 + 0.54219366665113684955164249598979949951171875000000e8 * t331 + 0.26048708305381053574266644418239593505859375000000e8 * t333
  t337 = t105 * t294
  t339 = t129 * t294
  t341 = t131 * t294
  t345 = t75 * t294
  t347 = t76 * t294
  t349 = t83 * t281
  t351 = t87 * t281
  t353 = t80 * t281
  t355 = t85 * t294
  t357 = t77 * t294
  t359 = t91 * t294
  t361 = t82 * t294
  t363 = t86 * t294
  t365 = t78 * t294
  t367 = -0.40409001933633889293896033048629760742187500000000e8 * t337 - 0.20463435494068270128925181132555007934570312500000e8 * t339 - 0.41033997617537126401697775721549987792968750000000e7 * t341 + 0.33580959846678989464954541265964508056640625000000e7 * t125 * t294 + 0.31653372069353880566060543060302734375000000000000e1 * t345 - 0.83351682213166782560706138610839843750000000000000e1 * t347 - 0.37062695419646445367800896465778350830078125000000e7 * t349 - 0.31690718837237161122116232633590698242187500000000e7 * t351 + 0.22591402777130702064651770666241645812988281250000e7 * t353 - 0.14595157578743427203723788261413574218750000000000e3 * t355 + 0.91626104877947550503075122833251953125000000000000e3 * t357 + 0.36122406809697449347258687019348144531250000000000e4 * t359 - 0.24770608250322930027843976020812988281250000000000e5 * t361 - 0.44463445995260591807969391345977783203125000000000e5 * t363 + 0.34051856766527162123280311822891235351562500000000e6 * t365
  t368 = t111 * t294
  t370 = t114 * t294
  t372 = t107 * t294
  t374 = t109 * t294
  t376 = t103 * t294
  t378 = t101 * t294
  t380 = t79 * t294
  t382 = t99 * t294
  t384 = t101 * t281
  t390 = t94 * t281
  t392 = t96 * t281
  t394 = t89 * t281
  t396 = t92 * t281
  t398 = 0.25023897635898133729670217633247375488281250000000e6 * t368 - 0.26595683631825062073744173169136047363281250000000e7 * t370 - 0.43839746816868022663638558983802795410156250000000e6 * t372 + 0.12831826620164189829276784086227416992187500000000e8 * t374 - 0.21580495876514031233597441911697387695312500000000e7 * t376 + 0.15279330170389365411183595776557922363281250000000e8 * t378 + 0.85579169500287344849667290604114532470703125000000e8 * t380 - 0.44396667799758845012014603704214096069335937500000e8 * t382 - 0.26939334622422592862597355365753173828125000000000e7 * t384 - 0.78705521131031808188173773586750030517578125000000e6 * t131 * t281 - 0.15197776895384120889517694711685180664062500000000e6 * t125 * t281 - 0.24664815444310469451119224280118942260742187500000e7 * t390 - 0.64704806272098658368631352305412292480468750000000e7 * t392 + 0.37964221408846205205482554659247398376464843750000e7 * t394 + 0.56296854957717736143381428003311157226562500000000e7 * t396
  t400 = t304 + t335 + t367 + t398
  t404 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t405 = t404 * f.p.zeta_threshold
  t407 = f.my_piecewise3(t20, t405, t21 * t19)
  t409 = 0.1e1 / t145 / t25
  t410 = t407 * t409
  t414 = t407 * t243
  t418 = t407 * t146
  t422 = t407 * t54
  t423 = t164 * r0
  t428 = t61 * s0 / t64 / t423 * t71
  t434 = t162 * t163 / t63 / t257 * t170
  t436 = t163 ** 2
  t437 = t254 * t436
  t442 = t169 ** 2
  t445 = 0.1e1 / t442 * t56 * t60
  t446 = t437 / t64 / t257 / t423 * t445
  t448 = t294 * t176
  t486 = t256 / t257 / t152 * t261
  t489 = -0.308e3 / 0.81e2 * t428 + 0.341e3 / 0.486e3 * t434 - 0.19e2 / 0.81e2 * t486 + t446 / 0.243e3
  t490 = t99 * t489
  t492 = t131 * t489
  t494 = 0.13692667120045975175946766496658325195312500000000e10 * t101 * t448 + 0.22918995255584048116775393664836883544921875000000e9 * t105 * t448 - 0.28054644639468240603676674485206604003906250000000e8 * t109 * t448 + 0.15398191944197027795132140903472900390625000000000e9 * t107 * t448 - 0.48223721498554824930002414882183074951171875000000e7 * t114 * t448 + 0.27241485413221729698624249458312988281250000000000e7 * t86 * t448 - 0.26595683631825062073744173169136047363281250000000e8 * t111 * t448 + 0.22521507872308320356703195869922637939453125000000e7 * t78 * t448 - 0.31124412196682414265578573942184448242187500000000e6 * t82 * t448 + 0.50340687941345496970392523884773254394531250000000e7 * t490 - 0.78705521131031808188173773586750030517578125000000e6 * t492
  t518 = -0.10668839380559652864441421687602996826171875000000e9 * t129 * t448 - 0.51158588735170675322312952831387519836425781250000e9 * t80 * t448 - 0.56572602707087445011454446268081665039062500000000e9 * t103 * t448 + 0.36650441951179020201230049133300781250000000000000e4 * t85 * t448 + 0.62516899932914528578239946603775024414062500000000e9 * t87 * t448 + 0.12470454332976147539687777407765388488769531250000e10 * t83 * t448 - 0.16035503731642003527790813712596893310546875000000e10 * t92 * t448 - 0.17122965283876657759924014167189598083496093750000e10 * t89 * t448 + 0.23644679082241449180220199761390686035156250000000e10 * t96 * t448 + 0.14426404135361557978083370770514011383056640625000e10 * t94 * t448 - 0.22129043745057741162071922488451004028320312500000e10 * t99 * t448
  t521 = t125 * t489
  t523 = t109 * t489
  t525 = t107 * t489
  t527 = t114 * t489
  t529 = t111 * t489
  t531 = t78 * t489
  t533 = t86 * t489
  t535 = t82 * t489
  t537 = t91 * t489
  t539 = t92 * t489
  t541 = 0.11993199945242496237483764737844467163085937500000e6 * t127 * t489 - 0.15197776895384120889517694711685180664062500000000e6 * t521 - 0.36533122347390018886365465819835662841796875000000e5 * t523 - 0.24177894210750056430676521062850952148437500000000e6 * t525 + 0.25023897635898133729670217633247375488281250000000e5 * t527 + 0.37835396407252402359200346469879150390625000000000e5 * t529 - 0.55579307494075739759961739182472229003906250000000e4 * t531 - 0.35386583214747042896919965744018554687500000000000e4 * t533 + 0.60204011349495748912097811698913574218750000000000e3 * t535 + 0.18325220975589510100615024566650390625000000000000e3 * t537 + 0.56296854957717736143381428003311157226562500000000e7 * t539
  t544 = t89 * t489
  t546 = t96 * t489
  t548 = t94 * t489
  t550 = t101 * t489
  t552 = t77 * t489
  t554 = t85 * t489
  t556 = t76 * t489
  t560 = t75 * t489
  t562 = t129 * t489
  t564 = t80 * t489
  t566 = 0.37964221408846205205482554659247398376464843750000e7 * t544 - 0.64704806272098658368631352305412292480468750000000e7 * t546 - 0.24664815444310469451119224280118942260742187500000e7 * t548 - 0.26939334622422592862597355365753173828125000000000e7 * t550 - 0.36487893946858568009309470653533935546875000000000e2 * t552 - 0.27783894071055594186902046203613281250000000000000e1 * t554 + 0.15826686034676940283030271530151367187500000000000e1 * t556 - 0.23349622667518089580893516540527343750000000000000e1 * t176 * t281 - 0.77832075558393631936311721801757812500000000000000e0 * t560 + 0.10419483322152421429706657767295837402343750000000e7 * t562 + 0.22591402777130702064651770666241645812988281250000e7 * t564
  t567 = t87 * t489
  t569 = t83 * t489
  t571 = t79 * t489
  t573 = t105 * t489
  t575 = t103 * t489
  t589 = -0.31690718837237161122116232633590698242187500000000e7 * t567 - 0.37062695419646445367800896465778350830078125000000e7 * t569 + 0.95495813564933533819897473603487014770507812500000e6 * t571 - 0.15414639911795736595426744222640991210937500000000e6 * t573 + 0.98706358616647614071359877586364746093750000000000e6 * t575 - 0.12122700580090166788168809914588928222656250000000e9 * t230 * t281 + 0.35467018623362173770330299642086029052734375000000e9 * t394 * t176 + 0.22778532845307723123289532795548439025878906250000e9 * t392 * t176 - 0.36881739575096235270119870814085006713867187500000e9 * t390 * t176 - 0.13319000339927653503604381111264228820800781250000e9 * t317 * t176 + 0.25673750850086203454900187181234359741210937500000e9 * t315 * t176
  t612 = 0.45837990511168096233550787329673767089843750000000e8 * t384 * t176 - 0.64741487629542093700792325735092163085937500000000e7 * t311 * t176 + 0.38495479860492569487830352258682250976562500000000e8 * t309 * t176 - 0.13151924045060406799091567695140838623046875000000e7 * t307 * t176 - 0.79787050895475186221232519507408142089843750000000e7 * t305 * t176 + 0.75071692907694401189010652899742126464843750000000e6 * t302 * t176 - 0.10565196578987170557970250094378436053240740740741e0 * t486 + 0.10215557029958148636984093546867370605468750000000e7 * t300 * t176 - 0.13339033798578177542390817403793334960937500000000e6 * t298 * t176 - 0.74311824750968790083531928062438964843750000000000e5 * t296 * t176 + 0.10836722042909234804177606105804443359375000000000e5 * t292 * t176
  t635 = 0.27487831463384265150922536849975585937500000000000e4 * t290 * t176 - 0.43785472736230281611171364784240722656250000000000e3 * t195 * t281 - 0.25005504663950034768211841583251953125000000000000e2 * t286 * t176 + 0.94960116208061641698181629180908203125000000000000e1 * t284 * t176 + 0.78146124916143160722799933254718780517578125000000e8 * t353 * t176 + 0.16265809999534105486549274879693984985351562500000e9 * t351 * t176 - 0.21866595997693641174260200517177581787109375000000e9 * t349 * t176 - 0.24461378976966653942748591667413711547851562500000e9 * t396 * t176 + 0.10074287954003696839486362379789352416992187500000e8 * t204 * t281 - 0.12310199285261137920509332716464996337890625000000e8 * t206 * t281 - 0.61390306482204810386775543397665023803710937500000e8 * t210 * t281
  t638 = -0.17126739717516044904499142258255570023148148148148e1 * t428 + 0.31602912573987940002349607738447778018904320987655e0 * t434 + 0.18535432594714334312228508937506028163580246913580e-2 * t446 + 0.31653372069353880566060543060302734375000000000000e1 * t448 - 0.75474335259590036520424826297163963317871093750000e9 * t79 * t448 - 0.14862364950193758016706385612487792968750000000000e6 * t91 * t448 + 0.18061203404848724673629343509674072265625000000000e5 * t77 * t448 - 0.43785472736230281611171364784240722656250000000000e3 * t76 * t448 - 0.16670336442633356512141227722167968750000000000000e2 * t75 * t448 + 0.90668591586033271555377261418104171752929687500000e8 * t131 * t448 + t494 + t518 + t541 + t566 + t589 + t612 + t635
  t643 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t135 - 0.3e1 / 0.8e1 * t5 * t147 * t135 - 0.9e1 / 0.8e1 * t5 * t151 * t235 + t5 * t244 * t135 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t248 * t235 - 0.9e1 / 0.8e1 * t5 * t252 * t400 - 0.5e1 / 0.36e2 * t5 * t410 * t135 + t5 * t414 * t235 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t418 * t400 - 0.3e1 / 0.8e1 * t5 * t422 * t638)
  t645 = r1 <= f.p.dens_threshold
  t646 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t647 = 0.1e1 + t646
  t648 = t647 <= f.p.zeta_threshold
  t649 = t647 ** (0.1e1 / 0.3e1)
  t650 = t649 ** 2
  t652 = 0.1e1 / t650 / t647
  t654 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t655 = t654 ** 2
  t659 = 0.1e1 / t650
  t660 = t659 * t654
  t662 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t666 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t670 = f.my_piecewise3(t648, 0, -0.8e1 / 0.27e2 * t652 * t655 * t654 + 0.4e1 / 0.3e1 * t660 * t662 + 0.4e1 / 0.3e1 * t649 * t666)
  t672 = r1 ** 2
  t673 = r1 ** (0.1e1 / 0.3e1)
  t674 = t673 ** 2
  t677 = s2 / t674 / t672
  t683 = t61 * t677 / (0.4e1 + t61 * t677 / 0.24e2)
  t685 = t683 / 0.12e2 - 0.1e1
  t686 = t685 ** 2
  t687 = t686 ** 2
  t688 = t687 ** 2
  t689 = t688 ** 2
  t692 = t686 * t685
  t699 = t687 * t685
  t704 = t687 * t686
  t707 = t688 * t685
  t710 = t687 * t692
  t718 = t688 * t686
  t720 = 0.27967048856303053872440291047096252441406250000000e6 * t689 * t686 - 0.12981481812794983921641696989536285400390625000000e6 * t689 * t692 + 0.56174007979372666952880866825580596923828125000000e5 * t689 * t685 - 0.32352403136049329184315676152706146240234375000000e6 * t689 * t687 + 0.18078200670879145335944073647260665893554687500000e6 * t689 * t699 - 0.13204466182182150467548430263996124267578125000000e6 * t689 * t688 + 0.25589479526235334610627921819686889648437500000000e6 * t689 * t704 + 0.90365611108522808258607082664966583251953125000000e5 * t689 * t707 - 0.16114215399846280594696041941642761230468750000000e6 * t689 * t710 + 0.86005730499279641302996873855590820312500000000000e2 * t710 - 0.38916037779196815968155860900878906250000000000000e0 * t686 - 0.72975787893717136018618941307067871093750000000000e1 * t699 + 0.30542034959315850167691707611083984375000000000000e2 * t704 - 0.61754786104528599733290821313858032226562500000000e3 * t707 + 0.37835396407252402359200346469879150390625000000000e4 * t718
  t722 = t688 * t692
  t724 = t688 * t687
  t732 = t688 * t699
  t744 = 0.11313514630621233134023547172546386718750000000000e1 - 0.44233229018433803621149957180023193359375000000000e3 * t688 + 0.22748997850816485208791106939315795898437500000000e4 * t722 - 0.20148245175625047025563767552375793457031250000000e5 * t724 + 0.40074935854432390114256376028060913085937500000000e5 * t689 * t718 - 0.29150193011493262291916212439537048339843750000000e5 * t689 * t722 - 0.54277774626371860319706052541732788085937500000000e4 * t689 * t724 + 0.41355861880146538749944016337394714355468750000000e4 * t689 * t732 + 0.37534251004296526982262730598449707031250000000000e-1 * t683 - 0.2810240180568462991258881986141204833984375000000e4 * t732 + 0.70504541869034010050971341133117675781250000000000e5 * t688 * t704 - 0.10276426607863824396951162815093994140625000000000e5 * t688 * t710 - 0.16837084139014120539123347103595733642578125000000e6 * t689 - 0.69459735177638985467255115509033203125000000000000e0 * t687 + 0.52755620115589800943434238433837890625000000000000e0 * t692
  t745 = t720 + t744
  t754 = f.my_piecewise3(t648, 0, 0.4e1 / 0.9e1 * t659 * t655 + 0.4e1 / 0.3e1 * t649 * t662)
  t761 = f.my_piecewise3(t648, 0, 0.4e1 / 0.3e1 * t649 * t654)
  t767 = f.my_piecewise3(t648, t405, t649 * t647)
  t773 = f.my_piecewise3(t645, 0, -0.3e1 / 0.8e1 * t5 * t670 * t54 * t745 - 0.3e1 / 0.8e1 * t5 * t754 * t146 * t745 + t5 * t761 * t243 * t745 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t767 * t409 * t745)
  t783 = t19 ** 2
  t786 = t30 ** 2
  t792 = t41 ** 2
  t801 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t802 = f.my_piecewise5(t10, 0, t14, 0, t801)
  t806 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t783 * t786 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t792 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t802)
  t815 = 0.1e1 / t145 / t36
  t833 = t294 ** 2
  t835 = t281 ** 2
  t840 = t256 / t257 / t164 * t261
  t844 = t257 ** 2
  t853 = t254 * t436 * s0 / t63 / t844 / r0 / t442 / t70 * t159 * t161
  t859 = t437 / t64 / t257 / t165 * t445
  t865 = t61 * s0 / t64 / t165 * t71
  t872 = t162 * t163 / t63 / t257 / r0 * t170
  t877 = 0.5236e4 / 0.243e3 * t865 - 0.3047e4 / 0.486e3 * t872 + 0.2563e4 / 0.729e3 * t840 - 0.98e2 / 0.729e3 * t859 + 0.4e1 / 0.2187e4 * t853
  t902 = -0.16670336442633356512141227722167968750000000000000e2 * t833 - 0.23349622667518089580893516540527343750000000000000e1 * t835 + 0.15835437913417612947413889468942650061085390946502e1 * t840 + 0.82379700420952596943237817500026791838134430727022e-3 * t853 - 0.60549079809400158753279795862519692001028806584362e-1 * t859 + 0.18325220975589510100615024566650390625000000000000e3 * t91 * t877 + 0.60204011349495748912097811698913574218750000000000e3 * t82 * t877 + 0.11993199945242496237483764737844467163085937500000e6 * t127 * t877 + 0.50340687941345496970392523884773254394531250000000e7 * t99 * t877 - 0.36533122347390018886365465819835662841796875000000e5 * t109 * t877 + 0.95495813564933533819897473603487014770507812500000e6 * t79 * t877 - 0.15414639911795736595426744222640991210937500000000e6 * t105 * t877 + 0.37835396407252402359200346469879150390625000000000e5 * t111 * t877 - 0.31690718837237161122116232633590698242187500000000e7 * t87 * t877 + 0.15826686034676940283030271530151367187500000000000e1 * t76 * t877 + 0.22591402777130702064651770666241645812988281250000e7 * t80 * t877 - 0.37062695419646445367800896465778350830078125000000e7 * t83 * t877
  t939 = -0.27783894071055594186902046203613281250000000000000e1 * t85 * t877 - 0.35386583214747042896919965744018554687500000000000e4 * t86 * t877 - 0.24664815444310469451119224280118942260742187500000e7 * t94 * t877 + 0.27434999532547524587313110297083854675292968750000e11 * t92 * t833 - 0.23936115268642555866369755852222442626953125000000e9 * t78 * t833 + 0.20539000680068962763920149744987487792968750000000e11 * t105 * t833 - 0.15197776895384120889517694711685180664062500000000e6 * t125 * t877 + 0.72244813619394898694517374038696289062500000000000e5 * t85 * t833 - 0.34245930567753315519848028334379196166992187500000e11 * t96 * t833 - 0.33674557836448207408360708796453475952148437500000e11 * t89 * t833 - 0.18674647318009448559347144365310668945312500000000e7 * t91 * t833 + 0.44924890256258753442418379546642303466796875000000e11 * t94 * t833 - 0.48223721498554824930002414882183074951171875000000e8 * t111 * t833 + 0.16938011138616730574645354993820190429687500000000e10 * t114 * t833 - 0.33665573567361888724412009382247924804687500000000e9 * t107 * t833 + 0.32086593357817667363485551130771636962890625000000e10 * t103 * t833 - 0.73544383519213678514890780148506164550781250000000e10 * t109 * t833 + 0.23573833812368650604398087968707084655761718750000e10 * t129 * t833
  t977 = -0.12278061296440962077355108679533004760742187500000e11 * t87 * t833 + 0.25967527443650804360550067386925220489501953125000e11 * t99 * t833 + 0.18017206297846656285362556695938110351562500000000e8 * t86 * t833 - 0.55579307494075739759961739182472229003906250000000e4 * t78 * t877 + 0.56296854957717736143381428003311157226562500000000e7 * t92 * t877 + 0.75071692907694401189010652899742126464843750000000e6 * t111 * t835 + 0.10215557029958148636984093546867370605468750000000e7 * t78 * t835 - 0.13339033798578177542390817403793334960937500000000e6 * t86 * t835 - 0.74311824750968790083531928062438964843750000000000e5 * t82 * t835 + 0.10836722042909234804177606105804443359375000000000e5 * t91 * t835 + 0.27487831463384265150922536849975585937500000000000e4 * t77 * t835 - 0.43785472736230281611171364784240722656250000000000e3 * t85 * t835 - 0.25005504663950034768211841583251953125000000000000e2 * t76 * t835 + 0.94960116208061641698181629180908203125000000000000e1 * t75 * t835 + 0.14378886984570341572995187718868255615234375000000e11 * t83 * t833 + 0.35467018623362173770330299642086029052734375000000e9 * t89 * t835 + 0.78146124916143160722799933254718780517578125000000e8 * t80 * t835 + 0.16265809999534105486549274879693984985351562500000e9 * t87 * t835
  t1014 = -0.26672098451399132161103554219007492065429687500000e10 * t80 * t833 - 0.74311824750968790083531928062438964843750000000000e6 * t77 * t833 - 0.87570945472460563222342729568481445312500000000000e3 * t75 * t833 + 0.22778532845307723123289532795548439025878906250000e9 * t96 * t835 - 0.36881739575096235270119870814085006713867187500000e9 * t94 * t835 - 0.13319000339927653503604381111264228820800781250000e9 * t99 * t835 + 0.25673750850086203454900187181234359741210937500000e9 * t79 * t835 + 0.45837990511168096233550787329673767089843750000000e8 * t101 * t835 - 0.64741487629542093700792325735092163085937500000000e7 * t103 * t835 + 0.38495479860492569487830352258682250976562500000000e8 * t109 * t835 - 0.13151924045060406799091567695140838623046875000000e7 * t107 * t835 - 0.79787050895475186221232519507408142089843750000000e7 * t114 * t835 - 0.26939334622422592862597355365753173828125000000000e7 * t101 * t877 + 0.10995132585353706060369014739990234375000000000000e5 * t76 * t833 - 0.12075893641534405843267972207546234130859375000000e11 * t101 * t833 - 0.37619374366598159975522268230366706848144531250000e11 * t79 * t833 + 0.19069039789255210789036974620819091796875000000000e8 * t82 * t833 - 0.77832075558393631936311721801757812500000000000000e0 * t75 * t877
  t1050 = -0.24177894210750056430676521062850952148437500000000e6 * t107 * t877 + 0.98706358616647614071359877586364746093750000000000e6 * t103 * t877 + 0.10419483322152421429706657767295837402343750000000e7 * t129 * t877 - 0.36487893946858568009309470653533935546875000000000e2 * t77 * t877 - 0.64704806272098658368631352305412292480468750000000e7 * t96 * t877 + 0.25023897635898133729670217633247375488281250000000e5 * t114 * t877 - 0.21866595997693641174260200517177581787109375000000e9 * t83 * t835 - 0.24461378976966653942748591667413711547851562500000e9 * t92 * t835 + 0.10074287954003696839486362379789352416992187500000e8 * t125 * t835 - 0.12310199285261137920509332716464996337890625000000e8 * t131 * t835 - 0.61390306482204810386775543397665023803710937500000e8 * t129 * t835 - 0.12122700580090166788168809914588928222656250000000e9 * t105 * t835 + 0.37964221408846205205482554659247398376464843750000e7 * t89 * t877 - 0.78705521131031808188173773586750030517578125000000e6 * t131 * t877 + 0.18992023241612328339636325836181640625000000000000e2 * t294 * t281 - 0.31132830223357452774524688720703125000000000000000e1 * t176 * t489 + 0.97051525065924254458828472796781563464506172839505e1 * t865
  t1086 = -0.28238731558047288324680133366290433907214506172840e1 * t872 + 0.34231667800114937939866916241645812988281250000000e9 * t571 * t176 - 0.17535898726747209065455423593521118164062500000000e7 * t525 * t176 + 0.61117320681557461644734383106231689453125000000000e8 * t550 * t176 - 0.89174189701162548100238313674926757812500000000000e6 * t359 * t281 + 0.12661348827741552226424217224121093750000000000000e2 * t560 * t176 + 0.21687746666045473982065699839591979980468750000000e9 * t567 * t176 - 0.32615171969288871923664788889884948730468750000000e9 * t539 * t176 - 0.33340672885266713024282455444335937500000000000000e2 * t556 * t176 + 0.74822725997856885238126664446592330932617187500000e10 * t329 * t281 - 0.99082433001291720111375904083251953125000000000000e5 * t535 * t176 - 0.17758667119903538004805841481685638427734375000000e9 * t490 * t176 - 0.15957410179095037244246503901481628417968750000000e9 * t368 * t281 + 0.10009559054359253491868087053298950195312500000000e7 * t529 * t176 + 0.37510139959748717146943967962265014648437500000000e10 * t331 * t281 + 0.21990265170707412120738029479980468750000000000000e5 * t355 * t281 + 0.82156002720275851055680598979949951171875000000000e10 * t378 * t281 + 0.51327306480656759317107136344909667968750000000000e8 * t523 * t176
  t1124 = 0.10419483322152421429706657767295837402343750000000e9 * t564 * t176 - 0.45284601155754021912254895778298377990722656250000e10 * t380 * t281 - 0.58380630314973708814895153045654296875000000000000e3 * t554 * t176 - 0.49175652766794980360159827752113342285156250000000e9 * t548 * t176 - 0.29155461330258188232346934022903442382812500000000e9 * t569 * t176 - 0.13277426247034644697243153493070602416992187500000e11 * t382 * t281 - 0.16163600773453555717558413219451904296875000000000e9 * t573 * t176 + 0.30371377127076964164386043727397918701171875000000e9 * t546 * t176 + 0.16344891247933037819174549674987792968750000000000e8 * t363 * t281 - 0.81853741976273080515700724530220031738281250000000e8 * t562 * t176 + 0.54401154951619962933226356850862503051757812500000e9 * t341 * t281 - 0.10002201865580013907284736633300781250000000000000e3 * t345 * t281 - 0.30695153241102405193387771698832511901855468750000e10 * t333 * t281 + 0.86558424812169347868500224623084068298339843750000e10 * t321 * t281 - 0.10638273452730024829497669267654418945312500000000e8 * t527 * t176 - 0.17785378398104236723187756538391113281250000000000e6 * t533 * t176 + 0.47289358164482898360440399522781372070312500000000e9 * t544 * t176 + 0.13512904723384992214021917521953582763671875000000e8 * t365 * t281
  t1161 = 0.14186807449344869508132119856834411621093750000000e11 * t323 * t281 - 0.28934232899132894958001448929309844970703125000000e8 * t370 * t281 + 0.92389151665182166770792845420837402343750000000000e9 * t372 * t281 - 0.16832786783680944362206004691123962402343750000000e9 * t374 * t281 + 0.13751397153350428870065236198902130126953125000000e10 * t337 * t281 - 0.86321983506056124934389767646789550781250000000000e7 * t575 * t176 - 0.33943561624252467006872667760848999023437500000000e10 * t376 * t281 + 0.13620742706610864849312124729156494140625000000000e7 * t531 * t176 - 0.26271283641738168966702818870544433593750000000000e4 * t347 * t281 + 0.10836722042909234804177606105804443359375000000000e6 * t357 * t281 - 0.10273779170325994655954408500313758850097656250000e11 * t325 * t281 - 0.16413599047014850560679110288619995117187500000000e8 * t492 * t176 + 0.36650441951179020201230049133300781250000000000000e4 * t552 * t176 + 0.14448962723878979738903474807739257812500000000000e5 * t537 * t176 - 0.96213022389852021166744882275581359863281250000000e10 * t327 * t281 - 0.18674647318009448559347144365310668945312500000000e7 * t361 * t281 + 0.13432383938671595785981816506385803222656250000000e8 * t521 * t176 - 0.64013036283357917186648530125617980957031250000000e9 * t339 * t281
  t1182 = t5 * t244 * t235 - 0.9e1 / 0.4e1 * t5 * t151 * t400 - 0.3e1 / 0.2e1 * t5 * t147 * t235 - 0.3e1 / 0.8e1 * t5 * t806 * t54 * t135 - 0.3e1 / 0.2e1 * t5 * t55 * t235 + 0.10e2 / 0.27e2 * t5 * t407 * t815 * t135 - 0.3e1 / 0.2e1 * t5 * t252 * t638 - 0.3e1 / 0.2e1 * t5 * t248 * t400 - 0.5e1 / 0.9e1 * t5 * t241 * t409 * t135 - t5 * t418 * t638 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t422 * (t902 + t939 + t977 + t1014 + t1050 + t1086 + t1124 + t1161) + t5 * t414 * t400 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t410 * t235 + t5 * t144 * t243 * t135 / 0.2e1 - t5 * t53 * t146 * t135 / 0.2e1
  t1183 = f.my_piecewise3(t1, 0, t1182)
  t1184 = t647 ** 2
  t1187 = t655 ** 2
  t1193 = t662 ** 2
  t1199 = f.my_piecewise5(t14, 0, t10, 0, -t801)
  t1203 = f.my_piecewise3(t648, 0, 0.40e2 / 0.81e2 / t650 / t1184 * t1187 - 0.16e2 / 0.9e1 * t652 * t655 * t662 + 0.4e1 / 0.3e1 * t659 * t1193 + 0.16e2 / 0.9e1 * t660 * t666 + 0.4e1 / 0.3e1 * t649 * t1199)
  t1225 = f.my_piecewise3(t645, 0, -0.3e1 / 0.8e1 * t5 * t1203 * t54 * t745 - t5 * t670 * t146 * t745 / 0.2e1 + t5 * t754 * t243 * t745 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t761 * t409 * t745 + 0.10e2 / 0.27e2 * t5 * t767 * t815 * t745)
  d1111 = 0.4e1 * t643 + 0.4e1 * t773 + t6 * (t1183 + t1225)

  res = {'v4rho4': d1111}
  return res
