"""Generated from gga_x_chachiyo.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  chachiyo_x = lambda x: 2 / 9 * (jnp.pi / 3) ** (1 / 3) * (2 ** (-1 / 3) * x)

  chachiyo_f0 = lambda x: (3 * x ** 2 + jnp.pi ** 2 * jnp.log(x + 1)) / ((3 * x + jnp.pi ** 2) * jnp.log(x + 1))

  chachiyo_f = lambda x: chachiyo_f0(chachiyo_x(x))

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, chachiyo_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  chachiyo_x = lambda x: 2 / 9 * (jnp.pi / 3) ** (1 / 3) * (2 ** (-1 / 3) * x)

  chachiyo_f0 = lambda x: (3 * x ** 2 + jnp.pi ** 2 * jnp.log(x + 1)) / ((3 * x + jnp.pi ** 2) * jnp.log(x + 1))

  chachiyo_f = lambda x: chachiyo_f0(chachiyo_x(x))

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, chachiyo_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  chachiyo_x = lambda x: 2 / 9 * (jnp.pi / 3) ** (1 / 3) * (2 ** (-1 / 3) * x)

  chachiyo_f0 = lambda x: (3 * x ** 2 + jnp.pi ** 2 * jnp.log(x + 1)) / ((3 * x + jnp.pi ** 2) * jnp.log(x + 1))

  chachiyo_f = lambda x: chachiyo_f0(chachiyo_x(x))

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, chachiyo_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = t3 ** 2
  t29 = t2 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 * s0
  t32 = r0 ** 2
  t33 = r0 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = 0.1e1 / t34 / t32
  t40 = jnp.pi ** 2
  t41 = t2 ** 2
  t42 = t41 * t3
  t43 = t30 ** 2
  t44 = jnp.sqrt(s0)
  t47 = 0.1e1 / t33 / r0
  t49 = t42 * t43 * t44 * t47
  t51 = t49 / 0.27e2 + 0.1e1
  t52 = jnp.log(t51)
  t54 = 0.2e1 / 0.81e2 * t29 * t31 * t36 + t40 * t52
  t57 = t49 / 0.9e1 + t40
  t58 = 0.1e1 / t57
  t59 = 0.1e1 / t52
  t60 = t58 * t59
  t61 = t27 * t54 * t60
  t64 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t61)
  t65 = r1 <= f.p.dens_threshold
  t66 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t67 = 0.1e1 + t66
  t68 = t67 <= f.p.zeta_threshold
  t69 = t67 ** (0.1e1 / 0.3e1)
  t71 = f.my_piecewise3(t68, t22, t69 * t67)
  t72 = t5 * t71
  t73 = t30 * s2
  t74 = r1 ** 2
  t75 = r1 ** (0.1e1 / 0.3e1)
  t76 = t75 ** 2
  t78 = 0.1e1 / t76 / t74
  t82 = jnp.sqrt(s2)
  t85 = 0.1e1 / t75 / r1
  t87 = t42 * t43 * t82 * t85
  t89 = t87 / 0.27e2 + 0.1e1
  t90 = jnp.log(t89)
  t92 = 0.2e1 / 0.81e2 * t29 * t73 * t78 + t40 * t90
  t95 = t87 / 0.9e1 + t40
  t96 = 0.1e1 / t95
  t97 = 0.1e1 / t90
  t98 = t96 * t97
  t99 = t27 * t92 * t98
  t102 = f.my_piecewise3(t65, 0, -0.3e1 / 0.8e1 * t72 * t99)
  t103 = t6 ** 2
  t105 = t16 / t103
  t106 = t7 - t105
  t107 = f.my_piecewise5(t10, 0, t14, 0, t106)
  t110 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t107)
  t114 = t27 ** 2
  t115 = 0.1e1 / t114
  t119 = t26 * t115 * t54 * t60 / 0.8e1
  t128 = t3 * t40 * t41 * t43
  t131 = t44 / t33 / t32
  t132 = 0.1e1 / t51
  t133 = t131 * t132
  t141 = t25 * t27
  t142 = t57 ** 2
  t145 = t141 * t54 / t142
  t146 = t59 * t43
  t151 = t141 * t54 * t58
  t152 = t52 ** 2
  t154 = 0.1e1 / t152 * t43
  t159 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t110 * t61 - t119 - 0.3e1 / 0.8e1 * t26 * t27 * (-0.16e2 / 0.243e3 * t29 * t31 / t34 / t32 / r0 - 0.4e1 / 0.81e2 * t128 * t133) * t60 - t145 * t146 * t131 / 0.6e1 - t151 * t154 * t133 / 0.18e2)
  t161 = f.my_piecewise5(t14, 0, t10, 0, -t106)
  t164 = f.my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t161)
  t171 = t72 * t115 * t92 * t98 / 0.8e1
  t173 = f.my_piecewise3(t65, 0, -0.3e1 / 0.8e1 * t5 * t164 * t99 - t171)
  vrho_0_ = t64 + t102 + t6 * (t159 + t173)
  t176 = -t7 - t105
  t177 = f.my_piecewise5(t10, 0, t14, 0, t176)
  t180 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t177)
  t185 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t180 * t61 - t119)
  t187 = f.my_piecewise5(t14, 0, t10, 0, -t176)
  t190 = f.my_piecewise3(t68, 0, 0.4e1 / 0.3e1 * t69 * t187)
  t202 = t82 / t75 / t74
  t203 = 0.1e1 / t89
  t204 = t202 * t203
  t212 = t71 * t27
  t213 = t95 ** 2
  t216 = t212 * t92 / t213
  t217 = t97 * t43
  t222 = t212 * t92 * t96
  t223 = t90 ** 2
  t225 = 0.1e1 / t223 * t43
  t230 = f.my_piecewise3(t65, 0, -0.3e1 / 0.8e1 * t5 * t190 * t99 - t171 - 0.3e1 / 0.8e1 * t72 * t27 * (-0.16e2 / 0.243e3 * t29 * t73 / t76 / t74 / r1 - 0.4e1 / 0.81e2 * t128 * t204) * t98 - t216 * t217 * t202 / 0.6e1 - t222 * t225 * t204 / 0.18e2)
  vrho_1_ = t64 + t102 + t6 * (t185 + t230)
  t237 = 0.1e1 / t44 * t47
  t238 = t237 * t132
  t253 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t27 * (0.2e1 / 0.81e2 * t29 * t30 * t36 + t128 * t238 / 0.54e2) * t60 + t145 * t146 * t237 / 0.16e2 + t151 * t154 * t238 / 0.48e2)
  vsigma_0_ = t6 * t253
  vsigma_1_ = 0.0e0
  t258 = 0.1e1 / t82 * t85
  t259 = t258 * t203
  t274 = f.my_piecewise3(t65, 0, -0.3e1 / 0.8e1 * t72 * t27 * (0.2e1 / 0.81e2 * t29 * t30 * t78 + t128 * t259 / 0.54e2) * t98 + t216 * t217 * t258 / 0.16e2 + t222 * t225 * t259 / 0.48e2)
  vsigma_2_ = t6 * t274
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  chachiyo_x = lambda x: 2 / 9 * (jnp.pi / 3) ** (1 / 3) * (2 ** (-1 / 3) * x)

  chachiyo_f0 = lambda x: (3 * x ** 2 + jnp.pi ** 2 * jnp.log(x + 1)) / ((3 * x + jnp.pi ** 2) * jnp.log(x + 1))

  chachiyo_f = lambda x: chachiyo_f0(chachiyo_x(x))

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, chachiyo_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t4 ** 2
  t21 = t3 * t20
  t22 = r0 ** 2
  t23 = t19 ** 2
  t25 = 0.1e1 / t23 / t22
  t29 = jnp.pi ** 2
  t30 = t3 ** 2
  t32 = jnp.sqrt(s0)
  t34 = 0.1e1 / t19 / r0
  t36 = t30 * t4 * t32 * t34
  t38 = 0.2e1 / 0.27e2 * t36 + 0.1e1
  t39 = jnp.log(t38)
  t41 = 0.4e1 / 0.81e2 * t21 * s0 * t25 + t29 * t39
  t44 = 0.2e1 / 0.9e1 * t36 + t29
  t45 = 0.1e1 / t44
  t46 = 0.1e1 / t39
  t47 = t45 * t46
  t51 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t41 * t47)
  t64 = t4 * t29 * t30
  t68 = 0.1e1 / t38
  t79 = t17 / t22 * t41
  t80 = t44 ** 2
  t82 = 0.1e1 / t80 * t46
  t86 = t39 ** 2
  t88 = t45 / t86
  t94 = f.my_piecewise3(t2, 0, -t18 / t23 * t41 * t47 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * (-0.32e2 / 0.243e3 * t21 * s0 / t23 / t22 / r0 - 0.8e1 / 0.81e2 * t64 * t32 / t19 / t22 * t68) * t47 - t79 * t82 * t32 / 0.3e1 - t79 * t88 * t32 * t68 / 0.9e1)
  vrho_0_ = 0.2e1 * r0 * t94 + 0.2e1 * t51
  t99 = 0.1e1 / t32
  t111 = t17 / r0 * t41
  t120 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * (0.4e1 / 0.81e2 * t21 * t25 + t64 * t99 * t34 * t68 / 0.27e2) * t47 + t111 * t82 * t99 / 0.8e1 + t111 * t88 * t99 * t68 / 0.24e2)
  vsigma_0_ = 0.2e1 * r0 * t120
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = t4 ** 2
  t23 = t3 * t22
  t24 = r0 ** 2
  t26 = 0.1e1 / t20 / t24
  t30 = jnp.pi ** 2
  t31 = t3 ** 2
  t32 = t31 * t4
  t33 = jnp.sqrt(s0)
  t35 = 0.1e1 / t19 / r0
  t37 = t32 * t33 * t35
  t39 = 0.1e1 + 0.2e1 / 0.27e2 * t37
  t40 = jnp.log(t39)
  t42 = 0.4e1 / 0.81e2 * t23 * s0 * t26 + t30 * t40
  t45 = 0.2e1 / 0.9e1 * t37 + t30
  t46 = 0.1e1 / t45
  t47 = 0.1e1 / t40
  t48 = t46 * t47
  t52 = t24 * r0
  t54 = 0.1e1 / t20 / t52
  t59 = t4 * t30 * t31
  t61 = 0.1e1 / t19 / t24
  t63 = 0.1e1 / t39
  t67 = -0.32e2 / 0.243e3 * t23 * s0 * t54 - 0.8e1 / 0.81e2 * t59 * t33 * t61 * t63
  t73 = t17 / t24
  t74 = t73 * t42
  t75 = t45 ** 2
  t76 = 0.1e1 / t75
  t77 = t76 * t47
  t78 = t77 * t33
  t81 = t40 ** 2
  t82 = 0.1e1 / t81
  t83 = t46 * t82
  t85 = t83 * t33 * t63
  t89 = f.my_piecewise3(t2, 0, -t18 * t21 * t42 * t48 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t67 * t48 - t74 * t78 / 0.3e1 - t74 * t85 / 0.9e1)
  t103 = t17 / t52 * t42
  t108 = t24 ** 2
  t111 = s0 / t20 / t108
  t115 = 0.1e1 / t19 / t52
  t121 = t22 * t30 * t3
  t122 = t39 ** 2
  t123 = 0.1e1 / t122
  t132 = t73 * t67
  t139 = t17 / t19 / t108
  t141 = 0.1e1 / t75 / t45
  t142 = t42 * t141
  t148 = t42 * t76
  t150 = t82 * s0
  t151 = t32 * t63
  t155 = t42 * t46
  t156 = t139 * t155
  t158 = 0.1e1 / t81 / t40
  t161 = t123 * t31 * t4
  t168 = t18 / t20 / r0 * t42 * t48 / 0.12e2 - t18 * t21 * t67 * t48 / 0.4e1 + 0.5e1 / 0.9e1 * t103 * t78 + 0.5e1 / 0.27e2 * t103 * t85 - 0.3e1 / 0.8e1 * t18 * t19 * (0.352e3 / 0.729e3 * t23 * t111 + 0.56e2 / 0.243e3 * t59 * t33 * t115 * t63 - 0.64e2 / 0.2187e4 * t121 * t111 * t123) * t48 - 0.2e1 / 0.3e1 * t132 * t78 - 0.2e1 / 0.9e1 * t132 * t85 - 0.16e2 / 0.81e2 * t139 * t142 * t47 * s0 * t32 - 0.16e2 / 0.243e3 * t139 * t148 * t150 * t151 - 0.16e2 / 0.729e3 * t156 * t158 * s0 * t161 - 0.8e1 / 0.729e3 * t156 * t150 * t161
  t169 = f.my_piecewise3(t2, 0, t168)
  v2rho2_0_ = 0.2e1 * r0 * t169 + 0.4e1 * t89
  t174 = 0.1e1 / t33
  t179 = 0.4e1 / 0.81e2 * t23 * t26 + t59 * t174 * t35 * t63 / 0.27e2
  t185 = t17 / r0
  t186 = t185 * t42
  t187 = t77 * t174
  t191 = t83 * t174 * t63
  t195 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t179 * t48 + t186 * t187 / 0.8e1 + t186 * t191 / 0.24e2)
  t214 = t73 * t179
  t221 = t185 * t67
  t224 = t17 * t115
  t240 = t224 * t155
  t249 = -t18 * t21 * t179 * t48 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * (-0.32e2 / 0.243e3 * t23 * t54 - 0.4e1 / 0.81e2 * t59 * t174 * t61 * t63 + 0.8e1 / 0.729e3 * t121 * t54 * t123) * t48 - t214 * t78 / 0.3e1 - t214 * t85 / 0.9e1 - t74 * t187 / 0.8e1 + t221 * t187 / 0.8e1 + 0.2e1 / 0.27e2 * t224 * t42 * t141 * t47 * t32 + 0.2e1 / 0.81e2 * t224 * t148 * t82 * t31 * t4 * t63 - t74 * t191 / 0.24e2 + t221 * t191 / 0.24e2 + 0.2e1 / 0.243e3 * t240 * t158 * t123 * t32 + t240 * t82 * t123 * t32 / 0.243e3
  t250 = f.my_piecewise3(t2, 0, t249)
  v2rhosigma_0_ = 0.2e1 * r0 * t250 + 0.2e1 * t195
  t254 = 0.1e1 / t33 / s0
  t259 = 0.1e1 / s0
  t269 = t185 * t179
  t274 = t17 * t61
  t281 = t82 * t259
  t288 = t274 * t155
  t301 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * (-t59 * t254 * t35 * t63 / 0.54e2 - t121 * t259 * t26 * t123 / 0.243e3) * t48 + t269 * t187 / 0.4e1 + t269 * t191 / 0.12e2 - t274 * t142 * t47 * t259 * t32 / 0.36e2 - t274 * t148 * t281 * t151 / 0.108e3 - t186 * t77 * t254 / 0.16e2 - t288 * t158 * t259 * t161 / 0.324e3 - t186 * t83 * t254 * t63 / 0.48e2 - t288 * t281 * t161 / 0.648e3)
  v2sigma2_0_ = 0.2e1 * r0 * t301
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = t4 ** 2
  t24 = t3 * t23
  t25 = r0 ** 2
  t27 = 0.1e1 / t20 / t25
  t31 = jnp.pi ** 2
  t32 = t3 ** 2
  t33 = t32 * t4
  t34 = jnp.sqrt(s0)
  t38 = t33 * t34 / t19 / r0
  t40 = 0.1e1 + 0.2e1 / 0.27e2 * t38
  t41 = jnp.log(t40)
  t43 = 0.4e1 / 0.81e2 * t24 * s0 * t27 + t31 * t41
  t46 = 0.2e1 / 0.9e1 * t38 + t31
  t47 = 0.1e1 / t46
  t48 = 0.1e1 / t41
  t49 = t47 * t48
  t53 = 0.1e1 / t20
  t54 = t25 * r0
  t61 = t4 * t31 * t32
  t65 = 0.1e1 / t40
  t69 = -0.32e2 / 0.243e3 * t24 * s0 / t20 / t54 - 0.8e1 / 0.81e2 * t61 * t34 / t19 / t25 * t65
  t75 = t17 / t54
  t76 = t75 * t43
  t77 = t46 ** 2
  t78 = 0.1e1 / t77
  t80 = t78 * t48 * t34
  t83 = t41 ** 2
  t84 = 0.1e1 / t83
  t87 = t47 * t84 * t34 * t65
  t90 = t25 ** 2
  t93 = s0 / t20 / t90
  t103 = t23 * t31 * t3
  t104 = t40 ** 2
  t105 = 0.1e1 / t104
  t109 = 0.352e3 / 0.729e3 * t24 * t93 + 0.56e2 / 0.243e3 * t61 * t34 / t19 / t54 * t65 - 0.64e2 / 0.2187e4 * t103 * t93 * t105
  t115 = t17 / t25
  t116 = t115 * t69
  t122 = 0.1e1 / t19 / t90
  t123 = t17 * t122
  t125 = 0.1e1 / t77 / t46
  t126 = t43 * t125
  t129 = t48 * s0 * t33
  t132 = t43 * t78
  t134 = t84 * s0
  t136 = t134 * t33 * t65
  t139 = t43 * t47
  t140 = t123 * t139
  t142 = 0.1e1 / t83 / t41
  t145 = t105 * t32 * t4
  t146 = t142 * s0 * t145
  t149 = t134 * t145
  t152 = t18 * t22 * t43 * t49 / 0.12e2 - t18 * t53 * t69 * t49 / 0.4e1 + 0.5e1 / 0.9e1 * t76 * t80 + 0.5e1 / 0.27e2 * t76 * t87 - 0.3e1 / 0.8e1 * t18 * t19 * t109 * t49 - 0.2e1 / 0.3e1 * t116 * t80 - 0.2e1 / 0.9e1 * t116 * t87 - 0.16e2 / 0.81e2 * t123 * t126 * t129 - 0.16e2 / 0.243e3 * t123 * t132 * t136 - 0.16e2 / 0.729e3 * t140 * t146 - 0.8e1 / 0.729e3 * t140 * t149
  t153 = f.my_piecewise3(t2, 0, t152)
  t155 = t90 * r0
  t158 = t17 / t19 / t155
  t169 = t17 / t20 / t90 / t25
  t170 = t77 ** 2
  t174 = t34 * s0
  t179 = t115 * t109
  t188 = t17 / t90 * t43
  t195 = t75 * t69
  t200 = s0 / t20 / t155
  t215 = 0.1e1 / t104 / t40
  t231 = t158 * t139
  t234 = 0.32e2 / 0.27e2 * t158 * t126 * t129 - 0.16e2 / 0.27e2 * t123 * t69 * t125 * t129 - 0.128e3 / 0.243e3 * t169 * t43 / t170 * t48 * t174 * t24 - t179 * t87 / 0.3e1 + t18 * t22 * t69 * t49 / 0.4e1 - 0.43e2 / 0.81e2 * t188 * t87 - 0.3e1 / 0.8e1 * t18 * t53 * t109 * t49 + 0.5e1 / 0.9e1 * t195 * t87 - 0.3e1 / 0.8e1 * t18 * t19 * (-0.4928e4 / 0.2187e4 * t24 * t200 - 0.560e3 / 0.729e3 * t61 * t34 * t122 * t65 + 0.448e3 / 0.2187e4 * t103 * t200 * t105 - 0.1024e4 / 0.59049e5 * t31 * jnp.pi * t174 / t90 / t54 * t215) * t49 - 0.5e1 / 0.36e2 * t18 * t27 * t43 * t49 + 0.32e2 / 0.81e2 * t158 * t132 * t136 + 0.32e2 / 0.243e3 * t231 * t146
  t235 = t169 * t139
  t236 = t83 ** 2
  t240 = t215 * t3 * t23
  t244 = t142 * t174
  t248 = t84 * t174
  t259 = t123 * t69 * t47
  t269 = t169 * t132
  t270 = t24 * t105
  t282 = -0.128e3 / 0.6561e4 * t235 / t236 * t174 * t240 - 0.128e3 / 0.6561e4 * t235 * t244 * t240 - 0.128e3 / 0.19683e5 * t235 * t248 * t240 + 0.16e2 / 0.243e3 * t231 * t149 - 0.16e2 / 0.81e2 * t123 * t69 * t78 * t136 - 0.16e2 / 0.243e3 * t259 * t146 - 0.8e1 / 0.243e3 * t259 * t149 - 0.128e3 / 0.729e3 * t169 * t126 * t248 * t24 * t65 - 0.128e3 / 0.2187e4 * t269 * t244 * t270 - 0.64e2 / 0.2187e4 * t269 * t248 * t270 - 0.43e2 / 0.27e2 * t188 * t80 + 0.5e1 / 0.3e1 * t195 * t80 - t179 * t80
  t284 = f.my_piecewise3(t2, 0, t234 + t282)
  v3rho3_0_ = 0.2e1 * r0 * t284 + 0.6e1 * t153

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** 2
  t15 = t14 ** 2
  t16 = t15 * t14
  t17 = r0 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = 0.1e1 / t18 / t16
  t21 = t13 * t20
  t22 = 3 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t22 * t24
  t27 = 0.1e1 / t18 / t14
  t31 = jnp.pi ** 2
  t32 = t22 ** 2
  t33 = t32 * t23
  t34 = jnp.sqrt(s0)
  t38 = t33 * t34 / t17 / r0
  t40 = 0.1e1 + 0.2e1 / 0.27e2 * t38
  t41 = jnp.log(t40)
  t43 = 0.4e1 / 0.81e2 * t25 * s0 * t27 + t31 * t41
  t45 = 0.2e1 / 0.9e1 * t38 + t31
  t46 = t45 ** 2
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t43 * t48
  t51 = 0.1e1 / t41
  t52 = t34 * s0
  t54 = t51 * t52 * t25
  t57 = t15 * r0
  t59 = 0.1e1 / t17 / t57
  t60 = t13 * t59
  t62 = 0.1e1 / t46 / t45
  t63 = t43 * t62
  t66 = t51 * s0 * t33
  t70 = 0.1e1 / t17 / t15
  t71 = t13 * t70
  t72 = t14 * r0
  t74 = 0.1e1 / t18 / t72
  t79 = t23 * t31 * t32
  t83 = 0.1e1 / t40
  t87 = -0.32e2 / 0.243e3 * t25 * s0 * t74 - 0.8e1 / 0.81e2 * t79 * t34 / t17 / t14 * t83
  t88 = t87 * t62
  t93 = t13 / t14
  t96 = s0 / t18 / t15
  t106 = t24 * t31 * t22
  t107 = t40 ** 2
  t108 = 0.1e1 / t107
  t112 = 0.352e3 / 0.729e3 * t25 * t96 + 0.56e2 / 0.243e3 * t79 * t34 / t17 / t72 * t83 - 0.64e2 / 0.2187e4 * t106 * t96 * t108
  t113 = t93 * t112
  t114 = 0.1e1 / t45
  t115 = t41 ** 2
  t116 = 0.1e1 / t115
  t119 = t114 * t116 * t34 * t83
  t124 = t22 / t23 * t13
  t126 = 0.1e1 / t18 / r0
  t128 = t114 * t51
  t133 = t13 / t15
  t134 = t133 * t43
  t137 = 0.1e1 / t18
  t143 = t13 / t72
  t144 = t143 * t87
  t149 = s0 / t18 / t57
  t159 = t31 * jnp.pi
  t160 = t159 * t52
  t161 = t15 * t72
  t164 = 0.1e1 / t107 / t40
  t168 = -0.4928e4 / 0.2187e4 * t25 * t149 - 0.560e3 / 0.729e3 * t79 * t34 * t70 * t83 + 0.448e3 / 0.2187e4 * t106 * t149 * t108 - 0.1024e4 / 0.59049e5 * t160 / t161 * t164
  t177 = t43 * t114
  t178 = t60 * t177
  t180 = 0.1e1 / t115 / t41
  t183 = t108 * t32 * t23
  t184 = t180 * s0 * t183
  t187 = t21 * t177
  t188 = t115 ** 2
  t189 = 0.1e1 / t188
  t192 = t164 * t22 * t24
  t193 = t189 * t52 * t192
  t196 = -0.128e3 / 0.243e3 * t21 * t49 * t54 + 0.32e2 / 0.27e2 * t60 * t63 * t66 - 0.16e2 / 0.27e2 * t71 * t88 * t66 - t113 * t119 / 0.3e1 + t124 * t126 * t87 * t128 / 0.4e1 - 0.43e2 / 0.81e2 * t134 * t119 - 0.3e1 / 0.8e1 * t124 * t137 * t112 * t128 + 0.5e1 / 0.9e1 * t144 * t119 - 0.3e1 / 0.8e1 * t124 * t17 * t168 * t128 - 0.5e1 / 0.36e2 * t124 * t27 * t43 * t128 + 0.32e2 / 0.243e3 * t178 * t184 - 0.128e3 / 0.6561e4 * t187 * t193
  t197 = t180 * t52
  t198 = t197 * t192
  t201 = t116 * t52
  t202 = t201 * t192
  t205 = t116 * s0
  t206 = t205 * t183
  t209 = 0.1e1 / t46
  t210 = t87 * t209
  t213 = t205 * t33 * t83
  t216 = t87 * t114
  t217 = t71 * t216
  t224 = t201 * t25 * t83
  t227 = t43 * t209
  t228 = t21 * t227
  t229 = t25 * t108
  t230 = t197 * t229
  t233 = t201 * t229
  t240 = t209 * t51 * t34
  t246 = -0.128e3 / 0.6561e4 * t187 * t198 - 0.128e3 / 0.19683e5 * t187 * t202 + 0.16e2 / 0.243e3 * t178 * t206 - 0.16e2 / 0.81e2 * t71 * t210 * t213 - 0.16e2 / 0.243e3 * t217 * t184 - 0.8e1 / 0.243e3 * t217 * t206 - 0.128e3 / 0.729e3 * t21 * t63 * t224 - 0.128e3 / 0.2187e4 * t228 * t230 - 0.64e2 / 0.2187e4 * t228 * t233 + 0.32e2 / 0.81e2 * t60 * t227 * t213 - 0.43e2 / 0.27e2 * t134 * t240 + 0.5e1 / 0.3e1 * t144 * t240 - t113 * t240
  t248 = f.my_piecewise3(t2, 0, t196 + t246)
  t250 = t15 ** 2
  t251 = t250 * r0
  t253 = t13 / t251
  t255 = s0 ** 2
  t256 = t116 * t255
  t261 = t253 * t63
  t262 = t180 * t255
  t263 = jnp.pi * t108
  t283 = t13 / t18 / t161
  t289 = t13 / t17 / t16
  t293 = t253 * t227
  t294 = t189 * t255
  t295 = t164 * jnp.pi
  t299 = t253 * t177
  t303 = t107 ** 2
  t304 = 0.1e1 / t303
  t305 = t304 * jnp.pi
  t315 = -0.4096e4 / 0.6561e4 * t253 * t49 * t256 * jnp.pi * t83 - 0.4096e4 / 0.19683e5 * t261 * t262 * t263 - 0.2048e4 / 0.19683e5 * t261 * t256 * t263 - 0.512e3 / 0.243e3 * t21 * t87 * t48 * t54 + 0.128e3 / 0.27e2 * t60 * t88 * t66 - 0.32e2 / 0.27e2 * t71 * t112 * t62 * t66 + 0.4864e4 / 0.729e3 * t283 * t49 * t54 - 0.5296e4 / 0.729e3 * t289 * t63 * t66 - 0.4096e4 / 0.59049e5 * t293 * t294 * t295 - 0.4096e4 / 0.177147e6 * t299 / t188 / t41 * t255 * t305 - 0.2048e4 / 0.59049e5 * t299 * t294 * t305 - 0.4096e4 / 0.59049e5 * t293 * t262 * t295
  t337 = t143 * t112
  t340 = s0 * t20
  t367 = t93 * t168
  t376 = t13 / t57 * t43
  t383 = t133 * t87
  t390 = -0.11264e5 / 0.531441e6 * t299 * t262 * t305 - 0.4096e4 / 0.177147e6 * t293 * t256 * t295 - 0.1024e4 / 0.177147e6 * t299 * t256 * t305 + 0.10e2 / 0.27e2 * t124 * t74 * t43 * t128 - 0.4096e4 / 0.2187e4 * t253 * t43 / t47 / t45 * t51 * t255 * jnp.pi + 0.10e2 / 0.9e1 * t337 * t119 - 0.3e1 / 0.8e1 * t124 * t17 * (0.83776e5 / 0.6561e4 * t25 * t340 + 0.7280e4 / 0.2187e4 * t79 * t34 * t59 * t83 - 0.27328e5 / 0.19683e5 * t106 * t340 * t108 + 0.14336e5 / 0.59049e5 * t160 / t250 * t164 - 0.8192e4 / 0.1594323e7 * t23 * t159 * t255 / t17 / t251 * t304 * t32) * t128 - 0.4e1 / 0.9e1 * t367 * t119 - 0.5e1 / 0.9e1 * t124 * t27 * t87 * t128 + 0.506e3 / 0.243e3 * t376 * t119 + t124 * t126 * t112 * t128 / 0.2e1 - 0.172e3 / 0.81e2 * t383 * t119 - t124 * t137 * t168 * t128 / 0.2e1
  t392 = t60 * t216
  t397 = t283 * t177
  t403 = t21 * t210
  t411 = t283 * t227
  t420 = t21 * t216
  t423 = 0.128e3 / 0.243e3 * t392 * t184 + 0.64e2 / 0.243e3 * t392 * t206 + 0.4864e4 / 0.59049e5 * t397 * t202 - 0.512e3 / 0.729e3 * t21 * t88 * t224 - 0.512e3 / 0.2187e4 * t403 * t230 - 0.256e3 / 0.2187e4 * t403 * t233 + 0.4864e4 / 0.2187e4 * t283 * t63 * t224 + 0.4864e4 / 0.6561e4 * t411 * t230 + 0.2432e4 / 0.6561e4 * t411 * t233 + 0.4864e4 / 0.19683e5 * t397 * t193 + 0.4864e4 / 0.19683e5 * t397 * t198 - 0.512e3 / 0.6561e4 * t420 * t193
  t433 = t71 * t112 * t114
  t441 = t289 * t177
  t457 = -0.512e3 / 0.6561e4 * t420 * t198 - 0.512e3 / 0.19683e5 * t420 * t202 - 0.32e2 / 0.81e2 * t71 * t112 * t209 * t213 - 0.32e2 / 0.243e3 * t433 * t184 - 0.16e2 / 0.243e3 * t433 * t206 - 0.5296e4 / 0.2187e4 * t289 * t227 * t213 - 0.5296e4 / 0.6561e4 * t441 * t184 - 0.2648e4 / 0.6561e4 * t441 * t206 + 0.128e3 / 0.81e2 * t60 * t210 * t213 - 0.4e1 / 0.3e1 * t367 * t240 + 0.506e3 / 0.81e2 * t376 * t240 - 0.172e3 / 0.27e2 * t383 * t240 + 0.10e2 / 0.3e1 * t337 * t240
  t460 = f.my_piecewise3(t2, 0, t315 + t390 + t423 + t457)
  v4rho4_0_ = 0.2e1 * r0 * t460 + 0.8e1 * t248

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = t3 ** 2
  t33 = t2 * t32
  t34 = 2 ** (0.1e1 / 0.3e1)
  t35 = t34 * s0
  t36 = r0 ** 2
  t37 = r0 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t44 = jnp.pi ** 2
  t45 = t2 ** 2
  t46 = t45 * t3
  t47 = t34 ** 2
  t48 = jnp.sqrt(s0)
  t53 = t46 * t47 * t48 / t37 / r0
  t55 = 0.1e1 + t53 / 0.27e2
  t56 = jnp.log(t55)
  t58 = 0.2e1 / 0.81e2 * t33 * t35 / t38 / t36 + t44 * t56
  t61 = t53 / 0.9e1 + t44
  t62 = 0.1e1 / t61
  t63 = 0.1e1 / t56
  t64 = t62 * t63
  t65 = t31 * t58 * t64
  t68 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t69 = t68 * f.p.zeta_threshold
  t71 = f.my_piecewise3(t20, t69, t21 * t19)
  t72 = t5 * t71
  t73 = t31 ** 2
  t74 = 0.1e1 / t73
  t76 = t74 * t58 * t64
  t78 = t72 * t76 / 0.8e1
  t79 = t36 * r0
  t87 = t3 * t44 * t45 * t47
  t90 = t48 / t37 / t36
  t91 = 0.1e1 / t55
  t92 = t90 * t91
  t95 = -0.16e2 / 0.243e3 * t33 * t35 / t38 / t79 - 0.4e1 / 0.81e2 * t87 * t92
  t97 = t31 * t95 * t64
  t100 = t71 * t31
  t101 = t61 ** 2
  t102 = 0.1e1 / t101
  t103 = t58 * t102
  t104 = t100 * t103
  t105 = t63 * t47
  t106 = t105 * t90
  t109 = t58 * t62
  t110 = t100 * t109
  t111 = t56 ** 2
  t112 = 0.1e1 / t111
  t113 = t112 * t47
  t114 = t113 * t92
  t118 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t65 - t78 - 0.3e1 / 0.8e1 * t72 * t97 - t104 * t106 / 0.6e1 - t110 * t114 / 0.18e2)
  t120 = r1 <= f.p.dens_threshold
  t121 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t122 = 0.1e1 + t121
  t123 = t122 <= f.p.zeta_threshold
  t124 = t122 ** (0.1e1 / 0.3e1)
  t126 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t129 = f.my_piecewise3(t123, 0, 0.4e1 / 0.3e1 * t124 * t126)
  t130 = t5 * t129
  t131 = t34 * s2
  t132 = r1 ** 2
  t133 = r1 ** (0.1e1 / 0.3e1)
  t134 = t133 ** 2
  t140 = jnp.sqrt(s2)
  t145 = t46 * t47 * t140 / t133 / r1
  t147 = 0.1e1 + t145 / 0.27e2
  t148 = jnp.log(t147)
  t150 = 0.2e1 / 0.81e2 * t33 * t131 / t134 / t132 + t44 * t148
  t153 = t145 / 0.9e1 + t44
  t154 = 0.1e1 / t153
  t155 = 0.1e1 / t148
  t156 = t154 * t155
  t157 = t31 * t150 * t156
  t161 = f.my_piecewise3(t123, t69, t124 * t122)
  t162 = t5 * t161
  t164 = t74 * t150 * t156
  t166 = t162 * t164 / 0.8e1
  t168 = f.my_piecewise3(t120, 0, -0.3e1 / 0.8e1 * t130 * t157 - t166)
  t172 = t48 / t37 / t79
  t173 = t172 * t91
  t177 = t21 ** 2
  t178 = 0.1e1 / t177
  t179 = t26 ** 2
  t184 = t16 / t22 / t6
  t186 = -0.2e1 * t23 + 0.2e1 * t184
  t187 = f.my_piecewise5(t10, 0, t14, 0, t186)
  t191 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t178 * t179 + 0.4e1 / 0.3e1 * t21 * t187)
  t199 = t72 * t74 * t95 * t64
  t201 = t36 ** 2
  t203 = 0.1e1 / t38 / t201
  t204 = t35 * t203
  t211 = t32 * t44 * t2 * t34
  t213 = t55 ** 2
  t214 = 0.1e1 / t213
  t224 = 0.1e1 / t73 / t6
  t228 = t72 * t224 * t58 * t64 / 0.12e2
  t229 = t71 * t74
  t231 = t229 * t103 * t106
  t237 = t30 * t76
  t239 = t29 * t31
  t259 = t204 * t214 * t45 * t3
  t270 = t229 * t109 * t114
  t285 = 0.7e1 / 0.54e2 * t110 * t113 * t173 - 0.3e1 / 0.8e1 * t5 * t191 * t65 - 0.3e1 / 0.4e1 * t30 * t97 - t199 / 0.4e1 - 0.3e1 / 0.8e1 * t72 * t31 * (0.176e3 / 0.729e3 * t33 * t204 + 0.28e2 / 0.243e3 * t87 * t173 - 0.32e2 / 0.2187e4 * t211 * s0 * t203 * t214) * t64 + t228 - t231 / 0.9e1 - t100 * t95 * t102 * t106 / 0.3e1 - t237 / 0.4e1 - t239 * t103 * t106 / 0.3e1 - 0.8e1 / 0.81e2 * t100 * t58 / t101 / t61 * t63 * t35 * t203 * t45 * t3 - 0.8e1 / 0.729e3 * t100 * t109 / t111 / t56 * t259 - 0.4e1 / 0.729e3 * t100 * t109 * t112 * t259 - t239 * t109 * t114 / 0.9e1 - t270 / 0.27e2 - t100 * t95 * t62 * t114 / 0.9e1 + 0.7e1 / 0.18e2 * t104 * t105 * t172 - 0.8e1 / 0.243e3 * t100 * t103 * t112 * t204 * t46 * t91
  t286 = f.my_piecewise3(t1, 0, t285)
  t287 = t124 ** 2
  t288 = 0.1e1 / t287
  t289 = t126 ** 2
  t293 = f.my_piecewise5(t14, 0, t10, 0, -t186)
  t297 = f.my_piecewise3(t123, 0, 0.4e1 / 0.9e1 * t288 * t289 + 0.4e1 / 0.3e1 * t124 * t293)
  t301 = t130 * t164
  t306 = t162 * t224 * t150 * t156 / 0.12e2
  t308 = f.my_piecewise3(t120, 0, -0.3e1 / 0.8e1 * t5 * t297 * t157 - t301 / 0.4e1 + t306)
  d11 = 0.2e1 * t118 + 0.2e1 * t168 + t6 * (t286 + t308)
  t311 = -t7 - t24
  t312 = f.my_piecewise5(t10, 0, t14, 0, t311)
  t315 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t312)
  t316 = t5 * t315
  t320 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t316 * t65 - t78)
  t322 = f.my_piecewise5(t14, 0, t10, 0, -t311)
  t325 = f.my_piecewise3(t123, 0, 0.4e1 / 0.3e1 * t124 * t322)
  t326 = t5 * t325
  t329 = t132 * r1
  t337 = t140 / t133 / t132
  t338 = 0.1e1 / t147
  t339 = t337 * t338
  t342 = -0.16e2 / 0.243e3 * t33 * t131 / t134 / t329 - 0.4e1 / 0.81e2 * t87 * t339
  t344 = t31 * t342 * t156
  t347 = t161 * t31
  t348 = t153 ** 2
  t349 = 0.1e1 / t348
  t350 = t150 * t349
  t351 = t347 * t350
  t352 = t155 * t47
  t353 = t352 * t337
  t356 = t150 * t154
  t357 = t347 * t356
  t358 = t148 ** 2
  t359 = 0.1e1 / t358
  t360 = t359 * t47
  t361 = t360 * t339
  t365 = f.my_piecewise3(t120, 0, -0.3e1 / 0.8e1 * t326 * t157 - t166 - 0.3e1 / 0.8e1 * t162 * t344 - t351 * t353 / 0.6e1 - t357 * t361 / 0.18e2)
  t369 = 0.2e1 * t184
  t370 = f.my_piecewise5(t10, 0, t14, 0, t369)
  t374 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t178 * t312 * t26 + 0.4e1 / 0.3e1 * t21 * t370)
  t378 = t316 * t76
  t382 = t315 * t31
  t394 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t374 * t65 - t378 / 0.8e1 - 0.3e1 / 0.8e1 * t316 * t97 - t382 * t103 * t106 / 0.6e1 - t382 * t109 * t114 / 0.18e2 - t237 / 0.8e1 + t228 - t199 / 0.8e1 - t231 / 0.18e2 - t270 / 0.54e2)
  t398 = f.my_piecewise5(t14, 0, t10, 0, -t369)
  t402 = f.my_piecewise3(t123, 0, 0.4e1 / 0.9e1 * t288 * t322 * t126 + 0.4e1 / 0.3e1 * t124 * t398)
  t406 = t326 * t164
  t413 = t162 * t74 * t342 * t156
  t415 = t129 * t31
  t419 = t161 * t74
  t421 = t419 * t350 * t353
  t427 = t419 * t356 * t361
  t430 = f.my_piecewise3(t120, 0, -0.3e1 / 0.8e1 * t5 * t402 * t157 - t406 / 0.8e1 - t301 / 0.8e1 + t306 - 0.3e1 / 0.8e1 * t130 * t344 - t413 / 0.8e1 - t415 * t350 * t353 / 0.6e1 - t421 / 0.18e2 - t415 * t356 * t361 / 0.18e2 - t427 / 0.54e2)
  d12 = t118 + t168 + t320 + t365 + t6 * (t394 + t430)
  t435 = t312 ** 2
  t439 = 0.2e1 * t23 + 0.2e1 * t184
  t440 = f.my_piecewise5(t10, 0, t14, 0, t439)
  t444 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t178 * t435 + 0.4e1 / 0.3e1 * t21 * t440)
  t450 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t444 * t65 - t378 / 0.4e1 + t228)
  t453 = t132 ** 2
  t455 = 0.1e1 / t134 / t453
  t456 = t131 * t455
  t457 = t147 ** 2
  t458 = 0.1e1 / t457
  t461 = t456 * t458 * t45 * t3
  t482 = t325 * t31
  t488 = t140 / t133 / t329
  t489 = t488 * t338
  t516 = t322 ** 2
  t520 = f.my_piecewise5(t14, 0, t10, 0, -t439)
  t524 = f.my_piecewise3(t123, 0, 0.4e1 / 0.9e1 * t288 * t516 + 0.4e1 / 0.3e1 * t124 * t520)
  t542 = -0.4e1 / 0.729e3 * t347 * t356 * t359 * t461 - 0.8e1 / 0.243e3 * t347 * t350 * t359 * t456 * t46 * t338 - 0.8e1 / 0.729e3 * t347 * t356 / t358 / t148 * t461 - t421 / 0.9e1 - t347 * t342 * t349 * t353 / 0.3e1 - t406 / 0.4e1 - t482 * t350 * t353 / 0.3e1 + t306 + 0.7e1 / 0.54e2 * t357 * t360 * t489 - 0.8e1 / 0.81e2 * t347 * t150 / t348 / t153 * t155 * t131 * t455 * t45 * t3 - 0.3e1 / 0.8e1 * t162 * t31 * (0.176e3 / 0.729e3 * t33 * t456 + 0.28e2 / 0.243e3 * t87 * t489 - 0.32e2 / 0.2187e4 * t211 * s2 * t455 * t458) * t156 - 0.3e1 / 0.8e1 * t5 * t524 * t157 - 0.3e1 / 0.4e1 * t326 * t344 - t413 / 0.4e1 - t482 * t356 * t361 / 0.9e1 - t427 / 0.27e2 - t347 * t342 * t154 * t361 / 0.9e1 + 0.7e1 / 0.18e2 * t351 * t352 * t488
  t543 = f.my_piecewise3(t120, 0, t542)
  d22 = 0.2e1 * t320 + 0.2e1 * t365 + t6 * (t450 + t543)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t23 = t21 * t22
  t24 = 3 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t24 * t26
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 * s0
  t30 = r0 ** 2
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t38 = jnp.pi ** 2
  t39 = t24 ** 2
  t40 = t39 * t25
  t41 = t28 ** 2
  t42 = jnp.sqrt(s0)
  t47 = t40 * t41 * t42 / t31 / r0
  t49 = 0.1e1 + t47 / 0.27e2
  t50 = jnp.log(t49)
  t52 = 0.2e1 / 0.81e2 * t27 * t29 / t32 / t30 + t38 * t50
  t54 = t47 / 0.9e1 + t38
  t55 = 0.1e1 / t54
  t56 = t52 * t55
  t57 = t50 ** 2
  t59 = 0.1e1 / t57 / t50
  t60 = t56 * t59
  t61 = t23 * t60
  t62 = t30 ** 2
  t64 = 0.1e1 / t32 / t62
  t65 = t29 * t64
  t66 = t49 ** 2
  t67 = 0.1e1 / t66
  t69 = t67 * t39 * t25
  t70 = t65 * t69
  t73 = 0.1e1 / t57
  t74 = t56 * t73
  t75 = t23 * t74
  t78 = t23 * t56
  t79 = t73 * t41
  t80 = t30 * r0
  t83 = t42 / t31 / t80
  t84 = 0.1e1 / t49
  t85 = t83 * t84
  t86 = t79 * t85
  t90 = t24 / t25
  t91 = t19 ** 2
  t92 = 0.1e1 / t91
  t93 = t2 ** 2
  t94 = 0.1e1 / t93
  t96 = -t12 * t94 + t3
  t97 = f.my_piecewise5(t6, 0, t10, 0, t96)
  t98 = t97 ** 2
  t102 = 0.1e1 / t93 / t2
  t105 = 0.2e1 * t12 * t102 - 0.2e1 * t94
  t106 = f.my_piecewise5(t6, 0, t10, 0, t105)
  t110 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t92 * t98 + 0.4e1 / 0.3e1 * t19 * t106)
  t111 = t90 * t110
  t113 = 0.1e1 / t50
  t114 = t55 * t113
  t115 = t22 * t52 * t114
  t120 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t97)
  t121 = t90 * t120
  t129 = t25 * t38 * t39 * t41
  t132 = t42 / t31 / t30
  t133 = t132 * t84
  t136 = -0.16e2 / 0.243e3 * t27 * t29 / t32 / t80 - 0.4e1 / 0.81e2 * t129 * t133
  t138 = t22 * t136 * t114
  t141 = t90 * t21
  t142 = t22 ** 2
  t143 = 0.1e1 / t142
  t145 = t143 * t136 * t114
  t154 = t26 * t38 * t24 * t28
  t159 = 0.176e3 / 0.729e3 * t27 * t65 + 0.28e2 / 0.243e3 * t129 * t85 - 0.32e2 / 0.2187e4 * t154 * s0 * t64 * t67
  t161 = t22 * t159 * t114
  t165 = t143 * t52 * t114
  t168 = t120 * t22
  t169 = t54 ** 2
  t170 = 0.1e1 / t169
  t171 = t52 * t170
  t172 = t168 * t171
  t173 = t113 * t41
  t174 = t173 * t132
  t178 = 0.1e1 / t142 / t2
  t180 = t178 * t52 * t114
  t183 = t21 * t143
  t184 = t183 * t171
  t187 = t136 * t170
  t188 = t23 * t187
  t192 = 0.1e1 / t169 / t54
  t193 = t52 * t192
  t194 = t193 * t113
  t195 = t23 * t194
  t198 = t29 * t64 * t39 * t25
  t201 = t171 * t73
  t202 = t23 * t201
  t203 = t40 * t84
  t204 = t65 * t203
  t207 = t168 * t56
  t208 = t79 * t133
  t211 = t183 * t56
  t214 = t136 * t55
  t215 = t23 * t214
  t218 = t23 * t171
  t219 = t173 * t83
  t222 = -0.8e1 / 0.729e3 * t61 * t70 - 0.4e1 / 0.729e3 * t75 * t70 + 0.7e1 / 0.54e2 * t78 * t86 - 0.3e1 / 0.8e1 * t111 * t115 - 0.3e1 / 0.4e1 * t121 * t138 - t141 * t145 / 0.4e1 - 0.3e1 / 0.8e1 * t141 * t161 - t121 * t165 / 0.4e1 - t172 * t174 / 0.3e1 + t141 * t180 / 0.12e2 - t184 * t174 / 0.9e1 - t188 * t174 / 0.3e1 - 0.8e1 / 0.81e2 * t195 * t198 - 0.8e1 / 0.243e3 * t202 * t204 - t207 * t208 / 0.9e1 - t211 * t208 / 0.27e2 - t215 * t208 / 0.9e1 + 0.7e1 / 0.18e2 * t218 * t219
  t223 = f.my_piecewise3(t1, 0, t222)
  t225 = r1 <= f.p.dens_threshold
  t226 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t227 = 0.1e1 + t226
  t228 = t227 <= f.p.zeta_threshold
  t229 = t227 ** (0.1e1 / 0.3e1)
  t230 = t229 ** 2
  t231 = 0.1e1 / t230
  t233 = f.my_piecewise5(t10, 0, t6, 0, -t96)
  t234 = t233 ** 2
  t238 = f.my_piecewise5(t10, 0, t6, 0, -t105)
  t242 = f.my_piecewise3(t228, 0, 0.4e1 / 0.9e1 * t231 * t234 + 0.4e1 / 0.3e1 * t229 * t238)
  t243 = t90 * t242
  t245 = r1 ** 2
  t246 = r1 ** (0.1e1 / 0.3e1)
  t247 = t246 ** 2
  t253 = jnp.sqrt(s2)
  t258 = t40 * t41 * t253 / t246 / r1
  t261 = jnp.log(0.1e1 + t258 / 0.27e2)
  t263 = 0.2e1 / 0.81e2 * t27 * t28 * s2 / t247 / t245 + t38 * t261
  t269 = 0.1e1 / (t258 / 0.9e1 + t38) / t261
  t270 = t22 * t263 * t269
  t275 = f.my_piecewise3(t228, 0, 0.4e1 / 0.3e1 * t229 * t233)
  t276 = t90 * t275
  t278 = t143 * t263 * t269
  t282 = f.my_piecewise3(t228, t18, t229 * t227)
  t283 = t90 * t282
  t285 = t178 * t263 * t269
  t289 = f.my_piecewise3(t225, 0, -0.3e1 / 0.8e1 * t243 * t270 - t276 * t278 / 0.4e1 + t283 * t285 / 0.12e2)
  t295 = t120 * t143
  t299 = t21 * t178
  t303 = t110 * t22
  t320 = t42 / t31 / t62
  t333 = 0.1e1 / t32 / t62 / r0
  t334 = t29 * t333
  t338 = -t23 * t159 * t170 * t174 / 0.2e1 - t295 * t171 * t174 / 0.3e1 + t299 * t171 * t174 / 0.9e1 - t303 * t171 * t174 / 0.2e1 - t168 * t187 * t174 - t183 * t187 * t174 / 0.3e1 + 0.7e1 / 0.6e1 * t172 * t219 + 0.7e1 / 0.18e2 * t184 * t219 + 0.7e1 / 0.6e1 * t188 * t219 - 0.35e2 / 0.27e2 * t218 * t173 * t320 - 0.4e1 / 0.243e3 * t168 * t74 * t70 - 0.4e1 / 0.243e3 * t23 * t214 * t73 * t70 + 0.56e2 / 0.243e3 * t202 * t334 * t203
  t342 = t334 * t69
  t367 = t42 * s0
  t369 = 0.1e1 / t62 / t80
  t370 = t367 * t369
  t372 = 0.1e1 / t66 / t49
  t375 = t370 * t372 * t24 * t26
  t389 = -0.4e1 / 0.729e3 * t183 * t74 * t70 + 0.28e2 / 0.729e3 * t75 * t342 - 0.8e1 / 0.729e3 * t183 * t60 * t70 + 0.56e2 / 0.729e3 * t61 * t342 - 0.8e1 / 0.81e2 * t168 * t201 * t204 - 0.8e1 / 0.243e3 * t183 * t201 * t204 - 0.8e1 / 0.81e2 * t23 * t187 * t73 * t204 - 0.8e1 / 0.243e3 * t168 * t60 * t70 - 0.8e1 / 0.243e3 * t23 * t214 * t59 * t70 - 0.64e2 / 0.19683e5 * t75 * t375 - 0.8e1 / 0.27e2 * t168 * t194 * t198 - 0.8e1 / 0.81e2 * t183 * t194 * t198 - 0.8e1 / 0.27e2 * t23 * t136 * t192 * t113 * t198
  t395 = t370 * t67 * t24 * t26
  t398 = t57 ** 2
  t425 = t320 * t84
  t445 = 0.1e1 / t142 / t93
  t458 = -0.64e2 / 0.2187e4 * t23 * t171 * t59 * t395 - 0.64e2 / 0.6561e4 * t23 * t56 / t398 * t375 + 0.56e2 / 0.81e2 * t195 * t29 * t333 * t39 * t25 - 0.64e2 / 0.729e3 * t23 * t193 * t73 * t370 * t27 * t84 - 0.64e2 / 0.6561e4 * t61 * t375 - 0.32e2 / 0.2187e4 * t202 * t395 - 0.3e1 / 0.8e1 * t141 * t143 * t159 * t114 - 0.3e1 / 0.8e1 * t141 * t22 * (-0.2464e4 / 0.2187e4 * t27 * t334 - 0.280e3 / 0.729e3 * t129 * t425 + 0.224e3 / 0.2187e4 * t154 * s0 * t333 * t67 - 0.512e3 / 0.59049e5 * t38 * jnp.pi * t367 * t369 * t372) * t114 + t121 * t180 / 0.4e1 - 0.5e1 / 0.36e2 * t141 * t445 * t52 * t114 - 0.3e1 / 0.8e1 * t111 * t165 - 0.3e1 / 0.4e1 * t121 * t145 + t141 * t178 * t136 * t114 / 0.4e1
  t467 = t93 ** 2
  t471 = 0.6e1 * t102 - 0.6e1 * t12 / t467
  t472 = f.my_piecewise5(t6, 0, t10, 0, t471)
  t476 = f.my_piecewise3(t16, 0, -0.8e1 / 0.27e2 / t91 / t15 * t98 * t97 + 0.4e1 / 0.3e1 * t92 * t97 * t106 + 0.4e1 / 0.3e1 * t19 * t472)
  t512 = t169 ** 2
  t522 = -0.3e1 / 0.8e1 * t90 * t476 * t115 - 0.9e1 / 0.8e1 * t111 * t138 - 0.9e1 / 0.8e1 * t121 * t161 + 0.7e1 / 0.54e2 * t211 * t86 - 0.35e2 / 0.81e2 * t78 * t79 * t425 + 0.7e1 / 0.18e2 * t207 * t86 + 0.7e1 / 0.18e2 * t215 * t86 - t303 * t56 * t208 / 0.6e1 - t168 * t214 * t208 / 0.3e1 - t183 * t214 * t208 / 0.9e1 - t23 * t159 * t55 * t208 / 0.6e1 - t295 * t56 * t208 / 0.9e1 + t299 * t56 * t208 / 0.27e2 - 0.64e2 / 0.243e3 * t23 * t52 / t512 * t113 * t367 * t369 * t24 * t26
  t525 = f.my_piecewise3(t1, 0, t338 + t389 + t458 + t522)
  t535 = f.my_piecewise5(t10, 0, t6, 0, -t471)
  t539 = f.my_piecewise3(t228, 0, -0.8e1 / 0.27e2 / t230 / t227 * t234 * t233 + 0.4e1 / 0.3e1 * t231 * t233 * t238 + 0.4e1 / 0.3e1 * t229 * t535)
  t552 = f.my_piecewise3(t225, 0, -0.3e1 / 0.8e1 * t90 * t539 * t270 - 0.3e1 / 0.8e1 * t243 * t278 + t276 * t285 / 0.4e1 - 0.5e1 / 0.36e2 * t283 * t445 * t263 * t269)
  d111 = 0.3e1 * t223 + 0.3e1 * t289 + t2 * (t525 + t552)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t21 * t24
  t26 = 3 ** (0.1e1 / 0.3e1)
  t27 = jnp.pi ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = t26 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 * s0
  t32 = r0 ** 2
  t33 = r0 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t40 = jnp.pi ** 2
  t41 = t26 ** 2
  t42 = t41 * t27
  t43 = t30 ** 2
  t44 = jnp.sqrt(s0)
  t49 = t42 * t43 * t44 / t33 / r0
  t51 = 0.1e1 + t49 / 0.27e2
  t52 = jnp.log(t51)
  t54 = 0.2e1 / 0.81e2 * t29 * t31 / t34 / t32 + t40 * t52
  t56 = t49 / 0.9e1 + t40
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t54 * t58
  t60 = t25 * t59
  t61 = 0.1e1 / t52
  t62 = t61 * t43
  t63 = t32 * r0
  t66 = t44 / t33 / t63
  t67 = t62 * t66
  t70 = t21 * t22
  t78 = t27 * t40 * t41 * t43
  t81 = t44 / t33 / t32
  t82 = 0.1e1 / t51
  t83 = t81 * t82
  t86 = -0.16e2 / 0.243e3 * t29 * t31 / t34 / t63 - 0.4e1 / 0.81e2 * t78 * t83
  t87 = t86 * t58
  t88 = t70 * t87
  t91 = t70 * t59
  t92 = t32 ** 2
  t95 = t44 / t33 / t92
  t96 = t62 * t95
  t100 = 0.1e1 / t34 / t92
  t101 = t31 * t100
  t104 = t66 * t82
  t109 = t28 * t40 * t26 * t30
  t111 = t51 ** 2
  t112 = 0.1e1 / t111
  t116 = 0.176e3 / 0.729e3 * t29 * t101 + 0.28e2 / 0.243e3 * t78 * t104 - 0.32e2 / 0.2187e4 * t109 * s0 * t100 * t112
  t117 = t116 * t58
  t118 = t70 * t117
  t119 = t62 * t81
  t122 = t2 ** 2
  t123 = 0.1e1 / t122
  t125 = -t12 * t123 + t3
  t126 = f.my_piecewise5(t6, 0, t10, 0, t125)
  t129 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t126)
  t130 = t129 * t24
  t131 = t130 * t59
  t135 = 0.1e1 / t23 / t2
  t136 = t21 * t135
  t137 = t136 * t59
  t140 = t19 ** 2
  t141 = 0.1e1 / t140
  t142 = t126 ** 2
  t145 = t122 * t2
  t146 = 0.1e1 / t145
  t149 = 0.2e1 * t12 * t146 - 0.2e1 * t123
  t150 = f.my_piecewise5(t6, 0, t10, 0, t149)
  t154 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t141 * t142 + 0.4e1 / 0.3e1 * t19 * t150)
  t155 = t154 * t22
  t156 = t155 * t59
  t159 = t129 * t22
  t160 = t159 * t87
  t162 = t25 * t87
  t165 = t159 * t59
  t168 = 0.1e1 / t56
  t169 = t54 * t168
  t170 = t52 ** 2
  t171 = 0.1e1 / t170
  t172 = t169 * t171
  t173 = t70 * t172
  t174 = t92 * r0
  t176 = 0.1e1 / t34 / t174
  t177 = t31 * t176
  t179 = t112 * t41 * t27
  t180 = t177 * t179
  t184 = 0.1e1 / t170 / t52
  t185 = t169 * t184
  t186 = t25 * t185
  t187 = t101 * t179
  t190 = t70 * t185
  t193 = 0.7e1 / 0.18e2 * t60 * t67 + 0.7e1 / 0.6e1 * t88 * t67 - 0.35e2 / 0.27e2 * t91 * t96 - t118 * t119 / 0.2e1 - t131 * t119 / 0.3e1 + t137 * t119 / 0.9e1 - t156 * t119 / 0.2e1 - t160 * t119 - t162 * t119 / 0.3e1 + 0.7e1 / 0.6e1 * t165 * t67 + 0.28e2 / 0.729e3 * t173 * t180 - 0.8e1 / 0.729e3 * t186 * t187 + 0.56e2 / 0.729e3 * t190 * t180
  t194 = t59 * t171
  t195 = t159 * t194
  t196 = t42 * t82
  t197 = t101 * t196
  t200 = t25 * t194
  t203 = t87 * t171
  t204 = t70 * t203
  t207 = t159 * t185
  t210 = t86 * t168
  t211 = t210 * t184
  t212 = t70 * t211
  t215 = t159 * t172
  t218 = t210 * t171
  t219 = t70 * t218
  t222 = t70 * t194
  t223 = t177 * t196
  t226 = t25 * t172
  t230 = t26 / t27
  t231 = t230 * t129
  t233 = t168 * t61
  t234 = t22 * t116 * t233
  t237 = t230 * t21
  t239 = t24 * t116 * t233
  t244 = t95 * t82
  t251 = t40 * jnp.pi
  t252 = t44 * s0
  t253 = t251 * t252
  t255 = 0.1e1 / t92 / t63
  t257 = 0.1e1 / t111 / t51
  t261 = -0.2464e4 / 0.2187e4 * t29 * t177 - 0.280e3 / 0.729e3 * t78 * t244 + 0.224e3 / 0.2187e4 * t109 * s0 * t176 * t112 - 0.512e3 / 0.59049e5 * t253 * t255 * t257
  t263 = t22 * t261 * t233
  t267 = t135 * t54 * t233
  t270 = -0.8e1 / 0.81e2 * t195 * t197 - 0.8e1 / 0.243e3 * t200 * t197 - 0.8e1 / 0.81e2 * t204 * t197 - 0.8e1 / 0.243e3 * t207 * t187 - 0.8e1 / 0.243e3 * t212 * t187 - 0.4e1 / 0.243e3 * t215 * t187 - 0.4e1 / 0.243e3 * t219 * t187 + 0.56e2 / 0.243e3 * t222 * t223 - 0.4e1 / 0.729e3 * t226 * t187 - 0.9e1 / 0.8e1 * t231 * t234 - 0.3e1 / 0.8e1 * t237 * t239 - 0.3e1 / 0.8e1 * t237 * t263 + t231 * t267 / 0.4e1
  t273 = 0.1e1 / t23 / t122
  t275 = t273 * t54 * t233
  t278 = t230 * t154
  t280 = t24 * t54 * t233
  t284 = t24 * t86 * t233
  t288 = t135 * t86 * t233
  t292 = 0.1e1 / t140 / t15
  t296 = t141 * t126
  t299 = t122 ** 2
  t300 = 0.1e1 / t299
  t303 = -0.6e1 * t12 * t300 + 0.6e1 * t146
  t304 = f.my_piecewise5(t6, 0, t10, 0, t303)
  t308 = f.my_piecewise3(t16, 0, -0.8e1 / 0.27e2 * t292 * t142 * t126 + 0.4e1 / 0.3e1 * t296 * t150 + 0.4e1 / 0.3e1 * t19 * t304)
  t309 = t230 * t308
  t311 = t22 * t54 * t233
  t315 = t22 * t86 * t233
  t318 = t25 * t169
  t319 = t171 * t43
  t320 = t319 * t104
  t323 = t70 * t169
  t324 = t319 * t244
  t327 = t159 * t169
  t330 = t70 * t210
  t333 = t155 * t169
  t334 = t319 * t83
  t337 = t159 * t210
  t340 = t25 * t210
  t343 = -0.5e1 / 0.36e2 * t237 * t275 - 0.3e1 / 0.8e1 * t278 * t280 - 0.3e1 / 0.4e1 * t231 * t284 + t237 * t288 / 0.4e1 - 0.3e1 / 0.8e1 * t309 * t311 - 0.9e1 / 0.8e1 * t278 * t315 + 0.7e1 / 0.54e2 * t318 * t320 - 0.35e2 / 0.81e2 * t323 * t324 + 0.7e1 / 0.18e2 * t327 * t320 + 0.7e1 / 0.18e2 * t330 * t320 - t333 * t334 / 0.6e1 - t337 * t334 / 0.3e1 - t340 * t334 / 0.9e1
  t344 = t116 * t168
  t345 = t70 * t344
  t348 = t130 * t169
  t351 = t136 * t169
  t354 = t57 ** 2
  t355 = 0.1e1 / t354
  t356 = t54 * t355
  t357 = t70 * t356
  t358 = t61 * t252
  t361 = t358 * t255 * t26 * t28
  t364 = t59 * t184
  t365 = t70 * t364
  t366 = t252 * t255
  t368 = t112 * t26 * t28
  t369 = t366 * t368
  t372 = t170 ** 2
  t373 = 0.1e1 / t372
  t374 = t169 * t373
  t375 = t70 * t374
  t377 = t257 * t26 * t28
  t378 = t366 * t377
  t382 = 0.1e1 / t57 / t56
  t383 = t54 * t382
  t384 = t383 * t61
  t385 = t70 * t384
  t388 = t31 * t176 * t41 * t27
  t391 = t383 * t171
  t392 = t70 * t391
  t393 = t29 * t82
  t394 = t366 * t393
  t403 = t159 * t384
  t406 = t31 * t100 * t41 * t27
  t409 = t25 * t384
  t412 = t86 * t382
  t413 = t412 * t61
  t414 = t70 * t413
  t417 = -t345 * t334 / 0.6e1 - t348 * t334 / 0.9e1 + t351 * t334 / 0.27e2 - 0.64e2 / 0.243e3 * t357 * t361 - 0.64e2 / 0.2187e4 * t365 * t369 - 0.64e2 / 0.6561e4 * t375 * t378 + 0.56e2 / 0.81e2 * t385 * t388 - 0.64e2 / 0.729e3 * t392 * t394 - 0.64e2 / 0.6561e4 * t190 * t378 - 0.32e2 / 0.2187e4 * t222 * t369 - 0.64e2 / 0.19683e5 * t173 * t378 - 0.8e1 / 0.27e2 * t403 * t406 - 0.8e1 / 0.81e2 * t409 * t406 - 0.8e1 / 0.27e2 * t414 * t406
  t420 = f.my_piecewise3(t1, 0, t193 + t270 + t343 + t417)
  t422 = r1 <= f.p.dens_threshold
  t423 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t424 = 0.1e1 + t423
  t425 = t424 <= f.p.zeta_threshold
  t426 = t424 ** (0.1e1 / 0.3e1)
  t427 = t426 ** 2
  t429 = 0.1e1 / t427 / t424
  t431 = f.my_piecewise5(t10, 0, t6, 0, -t125)
  t432 = t431 ** 2
  t436 = 0.1e1 / t427
  t437 = t436 * t431
  t439 = f.my_piecewise5(t10, 0, t6, 0, -t149)
  t443 = f.my_piecewise5(t10, 0, t6, 0, -t303)
  t447 = f.my_piecewise3(t425, 0, -0.8e1 / 0.27e2 * t429 * t432 * t431 + 0.4e1 / 0.3e1 * t437 * t439 + 0.4e1 / 0.3e1 * t426 * t443)
  t448 = t230 * t447
  t450 = r1 ** 2
  t451 = r1 ** (0.1e1 / 0.3e1)
  t452 = t451 ** 2
  t458 = jnp.sqrt(s2)
  t463 = t42 * t43 * t458 / t451 / r1
  t466 = jnp.log(0.1e1 + t463 / 0.27e2)
  t468 = 0.2e1 / 0.81e2 * t29 * t30 * s2 / t452 / t450 + t40 * t466
  t474 = 0.1e1 / (t463 / 0.9e1 + t40) / t466
  t475 = t22 * t468 * t474
  t483 = f.my_piecewise3(t425, 0, 0.4e1 / 0.9e1 * t436 * t432 + 0.4e1 / 0.3e1 * t426 * t439)
  t484 = t230 * t483
  t486 = t24 * t468 * t474
  t491 = f.my_piecewise3(t425, 0, 0.4e1 / 0.3e1 * t426 * t431)
  t492 = t230 * t491
  t494 = t135 * t468 * t474
  t498 = f.my_piecewise3(t425, t18, t426 * t424)
  t499 = t230 * t498
  t501 = t273 * t468 * t474
  t505 = f.my_piecewise3(t422, 0, -0.3e1 / 0.8e1 * t448 * t475 - 0.3e1 / 0.8e1 * t484 * t486 + t492 * t494 / 0.4e1 - 0.5e1 / 0.36e2 * t499 * t501)
  t507 = t21 * t273
  t525 = t44 / t33 / t174
  t531 = t154 * t24
  t539 = t308 * t22
  t543 = t129 * t135
  t556 = -0.20e2 / 0.81e2 * t507 * t59 * t119 + 0.14e2 / 0.9e1 * t162 * t67 + 0.14e2 / 0.3e1 * t160 * t67 + 0.14e2 / 0.9e1 * t131 * t67 - 0.140e3 / 0.27e2 * t165 * t96 - 0.140e3 / 0.27e2 * t88 * t96 - 0.140e3 / 0.81e2 * t60 * t96 + 0.455e3 / 0.81e2 * t91 * t62 * t525 - 0.14e2 / 0.27e2 * t137 * t67 - 0.2e1 / 0.3e1 * t531 * t59 * t119 - 0.2e1 / 0.3e1 * t70 * t261 * t58 * t119 - 0.2e1 / 0.3e1 * t539 * t59 * t119 + 0.4e1 / 0.9e1 * t543 * t59 * t119 - 0.4e1 / 0.3e1 * t130 * t87 * t119 - 0.2e1 / 0.3e1 * t25 * t117 * t119 - 0.2e1 * t155 * t87 * t119
  t579 = 0.1e1 / t34 / t92 / t32
  t580 = t31 * t579
  t608 = -0.2e1 * t159 * t117 * t119 + 0.7e1 / 0.3e1 * t156 * t67 + 0.7e1 / 0.3e1 * t118 * t67 + 0.4e1 / 0.9e1 * t136 * t87 * t119 - 0.32e2 / 0.243e3 * t25 * t203 * t197 - 0.32e2 / 0.81e2 * t159 * t203 * t197 + 0.224e3 / 0.243e3 * t195 * t223 + 0.224e3 / 0.243e3 * t204 * t223 - 0.3416e4 / 0.2187e4 * t222 * t580 * t196 + 0.224e3 / 0.729e3 * t200 * t223 + 0.32e2 / 0.729e3 * t136 * t194 * t197 - 0.8e1 / 0.243e3 * t155 * t172 * t187 - 0.16e2 / 0.243e3 * t159 * t218 * t187 - 0.16e2 / 0.81e2 * t70 * t117 * t171 * t197 - 0.16e2 / 0.81e2 * t155 * t194 * t197 - 0.32e2 / 0.243e3 * t130 * t194 * t197 - 0.32e2 / 0.729e3 * t130 * t185 * t187
  t622 = t580 * t179
  t656 = -0.32e2 / 0.729e3 * t25 * t211 * t187 + 0.224e3 / 0.729e3 * t207 * t180 + 0.224e3 / 0.729e3 * t212 * t180 + 0.16e2 / 0.2187e4 * t136 * t172 * t187 + 0.112e3 / 0.2187e4 * t226 * t180 - 0.1708e4 / 0.6561e4 * t173 * t622 + 0.112e3 / 0.729e3 * t215 * t180 - 0.16e2 / 0.729e3 * t25 * t218 * t187 + 0.112e3 / 0.729e3 * t219 * t180 - 0.16e2 / 0.729e3 * t130 * t172 * t187 + 0.32e2 / 0.2187e4 * t136 * t185 * t187 + 0.224e3 / 0.2187e4 * t186 * t180 - 0.3416e4 / 0.6561e4 * t190 * t622 - 0.8e1 / 0.243e3 * t70 * t344 * t171 * t187 - 0.16e2 / 0.243e3 * t155 * t185 * t187 - 0.32e2 / 0.243e3 * t159 * t211 * t187 - 0.16e2 / 0.243e3 * t70 * t344 * t184 * t187
  t668 = s0 ** 2
  t669 = t92 ** 2
  t672 = 0.1e1 / t33 / t669 / r0
  t673 = t668 * t672
  t676 = t673 * t257 * jnp.pi * t43
  t679 = t111 ** 2
  t680 = 0.1e1 / t679
  t683 = t673 * t680 * jnp.pi * t43
  t720 = -0.256e3 / 0.6561e4 * t25 * t364 * t369 - 0.32e2 / 0.81e2 * t25 * t413 * t406 - 0.32e2 / 0.27e2 * t159 * t413 * t406 + 0.224e3 / 0.81e2 * t403 * t388 - 0.1024e4 / 0.59049e5 * t365 * t676 - 0.512e3 / 0.59049e5 * t375 * t683 - 0.256e3 / 0.6561e4 * t159 * t374 * t378 - 0.256e3 / 0.6561e4 * t207 * t378 - 0.256e3 / 0.6561e4 * t70 * t210 * t373 * t378 - 0.256e3 / 0.6561e4 * t212 * t378 - 0.256e3 / 0.19683e5 * t215 * t378 - 0.3416e4 / 0.729e3 * t385 * t31 * t579 * t41 * t27 + 0.224e3 / 0.243e3 * t409 * t388 - 0.16e2 / 0.27e2 * t70 * t116 * t382 * t61 * t406 - 0.16e2 / 0.27e2 * t155 * t384 * t406 + 0.32e2 / 0.243e3 * t136 * t384 * t406 - 0.32e2 / 0.81e2 * t130 * t384 * t406
  t725 = 0.1e1 / t669
  t726 = t252 * t725
  t727 = t726 * t377
  t741 = t673 * jnp.pi * t112 * t43
  t751 = t726 * t368
  t775 = -0.256e3 / 0.59049e5 * t226 * t378 + 0.896e3 / 0.19683e5 * t173 * t727 - 0.1024e4 / 0.6561e4 * t70 * t356 * t171 * t673 * jnp.pi * t82 * t43 - 0.1024e4 / 0.19683e5 * t70 * t383 * t184 * t741 - 0.512e3 / 0.19683e5 * t392 * t741 - 0.256e3 / 0.19683e5 * t25 * t374 * t378 - 0.256e3 / 0.19683e5 * t186 * t378 + 0.896e3 / 0.2187e4 * t365 * t751 + 0.896e3 / 0.6561e4 * t375 * t727 + 0.896e3 / 0.6561e4 * t190 * t727 - 0.256e3 / 0.729e3 * t159 * t391 * t394 - 0.256e3 / 0.2187e4 * t159 * t364 * t369 - 0.128e3 / 0.2187e4 * t195 * t369 - 0.256e3 / 0.2187e4 * t25 * t391 * t394 - 0.128e3 / 0.6561e4 * t200 * t369 - 0.256e3 / 0.729e3 * t70 * t412 * t171 * t394
  t795 = 0.1e1 / t23 / t145
  t817 = t15 ** 2
  t820 = t142 ** 2
  t826 = t150 ** 2
  t835 = -0.24e2 * t300 + 0.24e2 * t12 / t299 / t2
  t836 = f.my_piecewise5(t6, 0, t10, 0, t835)
  t840 = f.my_piecewise3(t16, 0, 0.40e2 / 0.81e2 / t140 / t817 * t820 - 0.16e2 / 0.9e1 * t292 * t142 * t150 + 0.4e1 / 0.3e1 * t141 * t826 + 0.16e2 / 0.9e1 * t296 * t304 + 0.4e1 / 0.3e1 * t19 * t836)
  t850 = -0.256e3 / 0.2187e4 * t70 * t87 * t184 * t369 - 0.128e3 / 0.2187e4 * t204 * t369 - 0.1024e4 / 0.59049e5 * t70 * t59 * t373 * t676 - 0.1024e4 / 0.177147e6 * t70 * t169 / t372 / t52 * t683 - 0.5e1 / 0.9e1 * t231 * t275 + 0.10e2 / 0.27e2 * t237 * t795 * t54 * t233 + t231 * t288 - 0.5e1 / 0.9e1 * t237 * t273 * t86 * t233 - t309 * t280 / 0.2e1 + t278 * t267 / 0.2e1 - 0.3e1 / 0.2e1 * t278 * t284 - 0.3e1 / 0.2e1 * t231 * t239 + t237 * t135 * t116 * t233 / 0.2e1 - 0.3e1 / 0.8e1 * t230 * t840 * t311 - 0.3e1 / 0.2e1 * t309 * t315 - 0.9e1 / 0.4e1 * t278 * t234 - 0.3e1 / 0.2e1 * t231 * t263
  t858 = t525 * t82
  t927 = -t237 * t24 * t261 * t233 / 0.2e1 - 0.3e1 / 0.8e1 * t237 * t22 * (0.41888e5 / 0.6561e4 * t29 * t580 + 0.3640e4 / 0.2187e4 * t78 * t858 - 0.13664e5 / 0.19683e5 * t109 * s0 * t579 * t112 + 0.7168e4 / 0.59049e5 * t253 * t725 * t257 - 0.2048e4 / 0.1594323e7 * t27 * t251 * t668 * t672 * t680 * t41 * t43) * t233 - 0.140e3 / 0.243e3 * t318 * t324 + 0.455e3 / 0.243e3 * t323 * t319 * t858 - 0.14e2 / 0.81e2 * t351 * t320 + 0.896e3 / 0.243e3 * t357 * t358 * t725 * t26 * t28 - 0.256e3 / 0.243e3 * t159 * t356 * t361 - 0.256e3 / 0.729e3 * t25 * t356 * t361 - 0.256e3 / 0.243e3 * t70 * t86 * t355 * t361 - 0.4e1 / 0.9e1 * t130 * t210 * t334 + 0.4e1 / 0.27e2 * t136 * t210 * t334 - 0.2e1 / 0.9e1 * t539 * t169 * t334 - 0.2e1 / 0.3e1 * t155 * t210 * t334 - 0.2e1 / 0.3e1 * t159 * t344 * t334 - 0.2e1 / 0.9e1 * t25 * t344 * t334 - 0.2e1 / 0.9e1 * t70 * t261 * t168 * t334 + 0.4e1 / 0.27e2 * t543 * t169 * t334
  t973 = -0.20e2 / 0.243e3 * t507 * t169 * t334 - 0.2e1 / 0.9e1 * t531 * t169 * t334 + 0.14e2 / 0.27e2 * t348 * t320 + 0.14e2 / 0.27e2 * t340 * t320 - 0.140e3 / 0.81e2 * t327 * t324 - 0.140e3 / 0.81e2 * t330 * t324 + 0.7e1 / 0.9e1 * t333 * t320 + 0.14e2 / 0.9e1 * t337 * t320 + 0.7e1 / 0.9e1 * t345 * t320 - 0.1024e4 / 0.2187e4 * t70 * t54 / t354 / t56 * t61 * t668 * t672 * jnp.pi * t43 + 0.224e3 / 0.81e2 * t414 * t388 - 0.2816e4 / 0.531441e6 * t190 * t683 - 0.1024e4 / 0.177147e6 * t222 * t676 - 0.256e3 / 0.177147e6 * t173 * t683 - 0.256e3 / 0.19683e5 * t219 * t378 + 0.896e3 / 0.729e3 * t392 * t726 * t393 + 0.448e3 / 0.2187e4 * t222 * t751
  t977 = f.my_piecewise3(t1, 0, t556 + t608 + t656 + t720 + t775 + t850 + t927 + t973)
  t978 = t424 ** 2
  t981 = t432 ** 2
  t987 = t439 ** 2
  t993 = f.my_piecewise5(t10, 0, t6, 0, -t835)
  t997 = f.my_piecewise3(t425, 0, 0.40e2 / 0.81e2 / t427 / t978 * t981 - 0.16e2 / 0.9e1 * t429 * t432 * t439 + 0.4e1 / 0.3e1 * t436 * t987 + 0.16e2 / 0.9e1 * t437 * t443 + 0.4e1 / 0.3e1 * t426 * t993)
  t1012 = f.my_piecewise3(t422, 0, -0.3e1 / 0.8e1 * t230 * t997 * t475 - t448 * t486 / 0.2e1 + t484 * t494 / 0.2e1 - 0.5e1 / 0.9e1 * t492 * t501 + 0.10e2 / 0.27e2 * t499 * t795 * t468 * t474)
  d1111 = 0.4e1 * t420 + 0.4e1 * t505 + t2 * (t977 + t1012)

  res = {'v4rho4': d1111}
  return res
