"""Generated from gga_x_htbs.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  htbs_s1 = 0.6

  htbs_s2 = 2.6

  params_rpbe_kappa = KAPPA_PBE

  params_rpbe_mu = MU_PBE

  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  htbs_cc0 = htbs_s1 ** 3 * (htbs_s1 ** 2 - 5 * htbs_s1 * htbs_s2 + 10 * htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc1 = -30 * htbs_s1 ** 2 * htbs_s2 ** 2 / (htbs_s1 - htbs_s2) ** 5

  htbs_cc2 = 30 * htbs_s1 * htbs_s2 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc3 = -10 * (htbs_s1 ** 2 + 4 * htbs_s1 * htbs_s2 + htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc4 = 15 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc5 = -6 / (htbs_s1 - htbs_s2) ** 5

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  htbs_g = lambda s: htbs_cc0 + htbs_cc1 * s + htbs_cc2 * s ** 2 + htbs_cc3 * s ** 3 + htbs_cc4 * s ** 4 + htbs_cc5 * s ** 5

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  htbs_f0 = lambda s: f.my_piecewise5(s <= htbs_s1, wc_f0(s), s >= htbs_s2, rpbe_f0(s), htbs_g(s) * rpbe_f0(s) + (1 - htbs_g(s)) * wc_f0(s))

  htbs_f = lambda x: htbs_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, htbs_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  htbs_s1 = 0.6

  htbs_s2 = 2.6

  params_rpbe_kappa = KAPPA_PBE

  params_rpbe_mu = MU_PBE

  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  htbs_cc0 = htbs_s1 ** 3 * (htbs_s1 ** 2 - 5 * htbs_s1 * htbs_s2 + 10 * htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc1 = -30 * htbs_s1 ** 2 * htbs_s2 ** 2 / (htbs_s1 - htbs_s2) ** 5

  htbs_cc2 = 30 * htbs_s1 * htbs_s2 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc3 = -10 * (htbs_s1 ** 2 + 4 * htbs_s1 * htbs_s2 + htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc4 = 15 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc5 = -6 / (htbs_s1 - htbs_s2) ** 5

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  htbs_g = lambda s: htbs_cc0 + htbs_cc1 * s + htbs_cc2 * s ** 2 + htbs_cc3 * s ** 3 + htbs_cc4 * s ** 4 + htbs_cc5 * s ** 5

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  htbs_f0 = lambda s: f.my_piecewise5(s <= htbs_s1, wc_f0(s), s >= htbs_s2, rpbe_f0(s), htbs_g(s) * rpbe_f0(s) + (1 - htbs_g(s)) * wc_f0(s))

  htbs_f = lambda x: htbs_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, htbs_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  htbs_s1 = 0.6

  htbs_s2 = 2.6

  params_rpbe_kappa = KAPPA_PBE

  params_rpbe_mu = MU_PBE

  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  htbs_cc0 = htbs_s1 ** 3 * (htbs_s1 ** 2 - 5 * htbs_s1 * htbs_s2 + 10 * htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc1 = -30 * htbs_s1 ** 2 * htbs_s2 ** 2 / (htbs_s1 - htbs_s2) ** 5

  htbs_cc2 = 30 * htbs_s1 * htbs_s2 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc3 = -10 * (htbs_s1 ** 2 + 4 * htbs_s1 * htbs_s2 + htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc4 = 15 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc5 = -6 / (htbs_s1 - htbs_s2) ** 5

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  htbs_g = lambda s: htbs_cc0 + htbs_cc1 * s + htbs_cc2 * s ** 2 + htbs_cc3 * s ** 3 + htbs_cc4 * s ** 4 + htbs_cc5 * s ** 5

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  htbs_f0 = lambda s: f.my_piecewise5(s <= htbs_s1, wc_f0(s), s >= htbs_s2, rpbe_f0(s), htbs_g(s) * rpbe_f0(s) + (1 - htbs_g(s)) * wc_f0(s))

  htbs_f = lambda x: htbs_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, htbs_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t33 = t29 / t31
  t34 = jnp.sqrt(s0)
  t35 = r0 ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t35 / r0
  t39 = t33 * t34 * t37
  t40 = t39 / 0.12e2
  t41 = t40 <= 0.6e0
  t42 = t31 ** 2
  t43 = 0.1e1 / t42
  t44 = t28 * t43
  t45 = r0 ** 2
  t46 = t35 ** 2
  t48 = 0.1e1 / t46 / t45
  t49 = s0 * t48
  t50 = t44 * t49
  t53 = jnp.exp(-t50 / 0.24e2)
  t59 = t29 / t31 / t30
  t60 = s0 ** 2
  t61 = t45 ** 2
  t62 = t61 * r0
  t64 = 0.1e1 / t35 / t62
  t66 = t59 * t60 * t64
  t68 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t66
  t69 = jnp.log(t68)
  t70 = 0.8040e0 + 0.5e1 / 0.972e3 * t50 + 0.40024242767108462448559670781893004115226337448558e-2 * t44 * t49 * t53 + t69
  t73 = 0.18040e1 - 0.64641600e0 / t70
  t74 = 0.26e1 <= t40
  t75 = t30 * t28
  t76 = t43 * s0
  t80 = jnp.exp(-0.11526490914032134466556108347153123272526257600885e-2 * t75 * t76 * t48)
  t82 = 0.18040e1 - 0.8040e0 * t80
  t83 = 0.19012500000000000000000000000000000000000000000000e0 * t39
  t84 = 0.19500000000000000000000000000000000000000000000000e0 * t50
  t85 = 0.1e1 / t30
  t86 = t34 * s0
  t87 = t85 * t86
  t88 = 0.1e1 / t61
  t90 = 0.86979166666666666666666666666666666666666666666667e-1 * t87 * t88
  t91 = 0.26041666666666666666666666666666666666666666666667e-2 * t66
  t94 = t28 / t42 / t30
  t95 = t34 * t60
  t96 = t61 * t45
  t98 = 0.1e1 / t46 / t96
  t101 = 0.16276041666666666666666666666666666666666666666667e-3 * t94 * t95 * t98
  t102 = -0.40608000000000000000000000000000000000000000000000e0 + t83 - t84 + t90 - t91 + t101
  t104 = 0.14060800000000000000000000000000000000000000000000e1 - t83 + t84 - t90 + t91 - t101
  t107 = f.my_piecewise5(t41, t73, t74, t82, t102 * t82 + t104 * t73)
  t111 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t107)
  t112 = r1 <= f.p.dens_threshold
  t113 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t114 = 0.1e1 + t113
  t115 = t114 <= f.p.zeta_threshold
  t116 = t114 ** (0.1e1 / 0.3e1)
  t118 = f.my_piecewise3(t115, t22, t116 * t114)
  t119 = t118 * t26
  t120 = jnp.sqrt(s2)
  t121 = r1 ** (0.1e1 / 0.3e1)
  t123 = 0.1e1 / t121 / r1
  t125 = t33 * t120 * t123
  t126 = t125 / 0.12e2
  t127 = t126 <= 0.6e0
  t128 = r1 ** 2
  t129 = t121 ** 2
  t131 = 0.1e1 / t129 / t128
  t132 = s2 * t131
  t133 = t44 * t132
  t136 = jnp.exp(-t133 / 0.24e2)
  t140 = s2 ** 2
  t141 = t128 ** 2
  t142 = t141 * r1
  t144 = 0.1e1 / t121 / t142
  t146 = t59 * t140 * t144
  t148 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t146
  t149 = jnp.log(t148)
  t150 = 0.8040e0 + 0.5e1 / 0.972e3 * t133 + 0.40024242767108462448559670781893004115226337448558e-2 * t44 * t132 * t136 + t149
  t153 = 0.18040e1 - 0.64641600e0 / t150
  t154 = 0.26e1 <= t126
  t155 = t43 * s2
  t159 = jnp.exp(-0.11526490914032134466556108347153123272526257600885e-2 * t75 * t155 * t131)
  t161 = 0.18040e1 - 0.8040e0 * t159
  t162 = 0.19012500000000000000000000000000000000000000000000e0 * t125
  t163 = 0.19500000000000000000000000000000000000000000000000e0 * t133
  t164 = t120 * s2
  t165 = t85 * t164
  t166 = 0.1e1 / t141
  t168 = 0.86979166666666666666666666666666666666666666666667e-1 * t165 * t166
  t169 = 0.26041666666666666666666666666666666666666666666667e-2 * t146
  t170 = t120 * t140
  t171 = t141 * t128
  t173 = 0.1e1 / t129 / t171
  t176 = 0.16276041666666666666666666666666666666666666666667e-3 * t94 * t170 * t173
  t177 = -0.40608000000000000000000000000000000000000000000000e0 + t162 - t163 + t168 - t169 + t176
  t179 = 0.14060800000000000000000000000000000000000000000000e1 - t162 + t163 - t168 + t169 - t176
  t182 = f.my_piecewise5(t127, t153, t154, t161, t179 * t153 + t177 * t161)
  t186 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t119 * t182)
  t187 = t6 ** 2
  t189 = t16 / t187
  t190 = t7 - t189
  t191 = f.my_piecewise5(t10, 0, t14, 0, t190)
  t194 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t191)
  t199 = t26 ** 2
  t200 = 0.1e1 / t199
  t204 = t5 * t25 * t200 * t107 / 0.8e1
  t205 = t70 ** 2
  t206 = 0.1e1 / t205
  t207 = t45 * r0
  t209 = 0.1e1 / t46 / t207
  t210 = s0 * t209
  t211 = t44 * t210
  t218 = t60 / t35 / t96
  t222 = 0.1e1 / t68
  t226 = -0.10e2 / 0.729e3 * t211 - 0.10673131404562256652949245541838134430727023319615e-1 * t44 * t210 * t53 + 0.44471380852342736053955189757658893461362597165064e-3 * t59 * t218 * t53 - 0.73495086436683507341360564954529289234364680180832e-4 * t59 * t218 * t222
  t229 = t75 * t43
  t250 = -0.25350000000000000000000000000000000000000000000000e0 * t33 * t34 / t35 / t45 + 0.52000000000000000000000000000000000000000000000000e0 * t211 - 0.34791666666666666666666666666666666666666666666667e0 * t87 / t62 + 0.13888888888888888888888888888888888888888888888889e-1 * t59 * t218 - 0.10850694444444444444444444444444444444444444444445e-2 * t94 * t95 / t46 / t61 / t207
  t253 = t102 * t30 * t28
  t260 = t104 * t206
  t264 = f.my_piecewise5(t41, 0.64641600e0 * t206 * t226, t74, -0.24712796519684896296296296296296296296296296296298e-2 * t229 * t210 * t80, t250 * t82 - 0.24712796519684896296296296296296296296296296296298e-2 * t253 * t76 * t209 * t80 - t250 * t73 + 0.64641600e0 * t260 * t226)
  t269 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t194 * t26 * t107 - t204 - 0.3e1 / 0.8e1 * t5 * t27 * t264)
  t271 = f.my_piecewise5(t14, 0, t10, 0, -t190)
  t274 = f.my_piecewise3(t115, 0, 0.4e1 / 0.3e1 * t116 * t271)
  t282 = t5 * t118 * t200 * t182 / 0.8e1
  t284 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t274 * t26 * t182 - t282)
  vrho_0_ = t111 + t186 + t6 * (t269 + t284)
  t287 = -t7 - t189
  t288 = f.my_piecewise5(t10, 0, t14, 0, t287)
  t291 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t288)
  t297 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t291 * t26 * t107 - t204)
  t299 = f.my_piecewise5(t14, 0, t10, 0, -t287)
  t302 = f.my_piecewise3(t115, 0, 0.4e1 / 0.3e1 * t116 * t299)
  t307 = t150 ** 2
  t308 = 0.1e1 / t307
  t309 = t128 * r1
  t311 = 0.1e1 / t129 / t309
  t312 = s2 * t311
  t313 = t44 * t312
  t320 = t140 / t121 / t171
  t324 = 0.1e1 / t148
  t328 = -0.10e2 / 0.729e3 * t313 - 0.10673131404562256652949245541838134430727023319615e-1 * t44 * t312 * t136 + 0.44471380852342736053955189757658893461362597165064e-3 * t59 * t320 * t136 - 0.73495086436683507341360564954529289234364680180832e-4 * t59 * t320 * t324
  t351 = -0.25350000000000000000000000000000000000000000000000e0 * t33 * t120 / t121 / t128 + 0.52000000000000000000000000000000000000000000000000e0 * t313 - 0.34791666666666666666666666666666666666666666666667e0 * t165 / t142 + 0.13888888888888888888888888888888888888888888888889e-1 * t59 * t320 - 0.10850694444444444444444444444444444444444444444445e-2 * t94 * t170 / t129 / t141 / t309
  t354 = t177 * t30 * t28
  t361 = t179 * t308
  t365 = f.my_piecewise5(t127, 0.64641600e0 * t308 * t328, t154, -0.24712796519684896296296296296296296296296296296298e-2 * t229 * t312 * t159, t351 * t161 - 0.24712796519684896296296296296296296296296296296298e-2 * t354 * t155 * t311 * t159 - t351 * t153 + 0.64641600e0 * t361 * t328)
  t370 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t302 * t26 * t182 - t282 - 0.3e1 / 0.8e1 * t5 * t119 * t365)
  vrho_1_ = t111 + t186 + t6 * (t297 + t370)
  t373 = t44 * t48
  t378 = s0 * t64
  t385 = 0.5e1 / 0.972e3 * t373 + 0.40024242767108462448559670781893004115226337448558e-2 * t44 * t48 * t53 - 0.16676767819628526020233196159122085048010973936899e-3 * t59 * t378 * t53 + 0.27560657413756315253010211857948483462886755067812e-4 * t59 * t378 * t222
  t389 = t43 * t48 * t80
  t405 = 0.95062500000000000000000000000000000000000000000000e-1 * t33 / t34 * t37 - 0.19500000000000000000000000000000000000000000000000e0 * t373 + 0.13046875000000000000000000000000000000000000000000e0 * t85 * t34 * t88 - 0.52083333333333333333333333333333333333333333333334e-2 * t59 * t378 + 0.40690104166666666666666666666666666666666666666668e-3 * t94 * t86 * t98
  t414 = f.my_piecewise5(t41, 0.64641600e0 * t206 * t385, t74, 0.92672986948818361111111111111111111111111111111115e-3 * t75 * t389, t405 * t82 + 0.92672986948818361111111111111111111111111111111115e-3 * t253 * t389 - t405 * t73 + 0.64641600e0 * t260 * t385)
  t418 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t414)
  vsigma_0_ = t6 * t418
  vsigma_1_ = 0.0e0
  t419 = t44 * t131
  t424 = s2 * t144
  t431 = 0.5e1 / 0.972e3 * t419 + 0.40024242767108462448559670781893004115226337448558e-2 * t44 * t131 * t136 - 0.16676767819628526020233196159122085048010973936899e-3 * t59 * t424 * t136 + 0.27560657413756315253010211857948483462886755067812e-4 * t59 * t424 * t324
  t435 = t43 * t131 * t159
  t451 = 0.95062500000000000000000000000000000000000000000000e-1 * t33 / t120 * t123 - 0.19500000000000000000000000000000000000000000000000e0 * t419 + 0.13046875000000000000000000000000000000000000000000e0 * t85 * t120 * t166 - 0.52083333333333333333333333333333333333333333333334e-2 * t59 * t424 + 0.40690104166666666666666666666666666666666666666668e-3 * t94 * t164 * t173
  t460 = f.my_piecewise5(t127, 0.64641600e0 * t308 * t431, t154, 0.92672986948818361111111111111111111111111111111115e-3 * t75 * t435, t451 * t161 + 0.92672986948818361111111111111111111111111111111115e-3 * t354 * t435 - t451 * t153 + 0.64641600e0 * t361 * t431)
  t464 = f.my_piecewise3(t112, 0, -0.3e1 / 0.8e1 * t5 * t119 * t460)
  vsigma_2_ = t6 * t464
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  htbs_s1 = 0.6

  htbs_s2 = 2.6

  params_rpbe_kappa = KAPPA_PBE

  params_rpbe_mu = MU_PBE

  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  htbs_cc0 = htbs_s1 ** 3 * (htbs_s1 ** 2 - 5 * htbs_s1 * htbs_s2 + 10 * htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc1 = -30 * htbs_s1 ** 2 * htbs_s2 ** 2 / (htbs_s1 - htbs_s2) ** 5

  htbs_cc2 = 30 * htbs_s1 * htbs_s2 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc3 = -10 * (htbs_s1 ** 2 + 4 * htbs_s1 * htbs_s2 + htbs_s2 ** 2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc4 = 15 * (htbs_s1 + htbs_s2) / (htbs_s1 - htbs_s2) ** 5

  htbs_cc5 = -6 / (htbs_s1 - htbs_s2) ** 5

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  htbs_g = lambda s: htbs_cc0 + htbs_cc1 * s + htbs_cc2 * s ** 2 + htbs_cc3 * s ** 3 + htbs_cc4 * s ** 4 + htbs_cc5 * s ** 5

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  htbs_f0 = lambda s: f.my_piecewise5(s <= htbs_s1, wc_f0(s), s >= htbs_s2, rpbe_f0(s), htbs_g(s) * rpbe_f0(s) + (1 - htbs_g(s)) * wc_f0(s))

  htbs_f = lambda x: htbs_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, htbs_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = jnp.pi ** 2
  t23 = t22 ** (0.1e1 / 0.3e1)
  t25 = t21 / t23
  t26 = jnp.sqrt(s0)
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t26 * t27
  t30 = 0.1e1 / t18 / r0
  t32 = t25 * t28 * t30
  t33 = t32 / 0.12e2
  t34 = t33 <= 0.6e0
  t35 = t23 ** 2
  t36 = 0.1e1 / t35
  t37 = t20 * t36
  t38 = t27 ** 2
  t39 = s0 * t38
  t40 = r0 ** 2
  t41 = t18 ** 2
  t43 = 0.1e1 / t41 / t40
  t44 = t39 * t43
  t45 = t37 * t44
  t47 = t37 * s0
  t48 = t38 * t43
  t50 = jnp.exp(-t45 / 0.24e2)
  t51 = t48 * t50
  t56 = t21 / t23 / t22
  t57 = s0 ** 2
  t58 = t57 * t27
  t59 = t40 ** 2
  t60 = t59 * r0
  t62 = 0.1e1 / t18 / t60
  t64 = t56 * t58 * t62
  t66 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t64
  t67 = jnp.log(t66)
  t68 = 0.8040e0 + 0.5e1 / 0.972e3 * t45 + 0.40024242767108462448559670781893004115226337448558e-2 * t47 * t51 + t67
  t71 = 0.18040e1 - 0.64641600e0 / t68
  t72 = 0.26e1 <= t33
  t74 = t22 * t20 * t36
  t77 = jnp.exp(-0.11526490914032134466556108347153123272526257600885e-2 * t74 * t44)
  t79 = 0.18040e1 - 0.8040e0 * t77
  t80 = 0.19012500000000000000000000000000000000000000000000e0 * t32
  t81 = 0.19500000000000000000000000000000000000000000000000e0 * t45
  t82 = 0.1e1 / t22
  t83 = t26 * s0
  t84 = t82 * t83
  t85 = 0.1e1 / t59
  t87 = 0.17395833333333333333333333333333333333333333333333e0 * t84 * t85
  t88 = 0.52083333333333333333333333333333333333333333333333e-2 * t64
  t91 = t20 / t35 / t22
  t93 = t26 * t57 * t38
  t94 = t59 * t40
  t96 = 0.1e1 / t41 / t94
  t99 = 0.32552083333333333333333333333333333333333333333333e-3 * t91 * t93 * t96
  t100 = -0.40608000000000000000000000000000000000000000000000e0 + t80 - t81 + t87 - t88 + t99
  t102 = 0.14060800000000000000000000000000000000000000000000e1 - t80 + t81 - t87 + t88 - t99
  t105 = f.my_piecewise5(t34, t71, t72, t79, t100 * t79 + t102 * t71)
  t109 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t105)
  t115 = t68 ** 2
  t116 = 0.1e1 / t115
  t117 = t40 * r0
  t119 = 0.1e1 / t41 / t117
  t121 = t37 * t39 * t119
  t127 = t56 * t57
  t129 = 0.1e1 / t18 / t94
  t130 = t27 * t129
  t134 = 0.1e1 / t66
  t138 = -0.10e2 / 0.729e3 * t121 - 0.10673131404562256652949245541838134430727023319615e-1 * t47 * t38 * t119 * t50 + 0.88942761704685472107910379515317786922725194330129e-3 * t127 * t130 * t50 - 0.14699017287336701468272112990905857846872936036166e-3 * t127 * t130 * t134
  t142 = t39 * t119 * t77
  t163 = -0.25350000000000000000000000000000000000000000000000e0 * t25 * t28 / t18 / t40 + 0.52000000000000000000000000000000000000000000000000e0 * t121 - 0.69583333333333333333333333333333333333333333333332e0 * t84 / t60 + 0.27777777777777777777777777777777777777777777777778e-1 * t56 * t58 * t129 - 0.21701388888888888888888888888888888888888888888889e-2 * t91 * t93 / t41 / t59 / t117
  t165 = t100 * t22
  t171 = t102 * t116
  t175 = f.my_piecewise5(t34, 0.64641600e0 * t116 * t138, t72, -0.24712796519684896296296296296296296296296296296298e-2 * t74 * t142, t163 * t79 - 0.24712796519684896296296296296296296296296296296298e-2 * t165 * t37 * t142 - t163 * t71 + 0.64641600e0 * t171 * t138)
  t180 = f.my_piecewise3(t2, 0, -t6 * t17 / t41 * t105 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t175)
  vrho_0_ = 0.2e1 * r0 * t180 + 0.2e1 * t109
  t183 = t37 * t48
  t187 = t56 * s0
  t188 = t27 * t62
  t195 = 0.5e1 / 0.972e3 * t183 + 0.40024242767108462448559670781893004115226337448558e-2 * t37 * t51 - 0.33353535639257052040466392318244170096021947873798e-3 * t187 * t188 * t50 + 0.55121314827512630506020423715896966925773510135624e-4 * t187 * t188 * t134
  t218 = 0.95062500000000000000000000000000000000000000000000e-1 * t25 / t26 * t27 * t30 - 0.19500000000000000000000000000000000000000000000000e0 * t183 + 0.26093750000000000000000000000000000000000000000000e0 * t82 * t26 * t85 - 0.10416666666666666666666666666666666666666666666667e-1 * t56 * s0 * t27 * t62 + 0.81380208333333333333333333333333333333333333333332e-3 * t91 * t83 * t38 * t96
  t231 = f.my_piecewise5(t34, 0.64641600e0 * t116 * t195, t72, 0.92672986948818361111111111111111111111111111111115e-3 * t74 * t48 * t77, t218 * t79 + 0.92672986948818361111111111111111111111111111111115e-3 * t165 * t20 * t36 * t38 * t43 * t77 - t218 * t71 + 0.64641600e0 * t171 * t195)
  t235 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t231)
  vsigma_0_ = 0.2e1 * r0 * t235
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t27 = t23 / t25
  t28 = jnp.sqrt(s0)
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t28 * t29
  t32 = 0.1e1 / t18 / r0
  t34 = t27 * t30 * t32
  t35 = t34 / 0.12e2
  t36 = t35 <= 0.6e0
  t37 = t25 ** 2
  t38 = 0.1e1 / t37
  t39 = t22 * t38
  t40 = t29 ** 2
  t41 = s0 * t40
  t42 = r0 ** 2
  t44 = 0.1e1 / t19 / t42
  t45 = t41 * t44
  t46 = t39 * t45
  t48 = t39 * s0
  t49 = t40 * t44
  t51 = jnp.exp(-t46 / 0.24e2)
  t52 = t49 * t51
  t56 = 0.1e1 / t25 / t24
  t57 = t23 * t56
  t58 = s0 ** 2
  t59 = t58 * t29
  t60 = t42 ** 2
  t61 = t60 * r0
  t63 = 0.1e1 / t18 / t61
  t65 = t57 * t59 * t63
  t67 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t65
  t68 = jnp.log(t67)
  t69 = 0.8040e0 + 0.5e1 / 0.972e3 * t46 + 0.40024242767108462448559670781893004115226337448558e-2 * t48 * t52 + t68
  t72 = 0.18040e1 - 0.64641600e0 / t69
  t73 = 0.26e1 <= t35
  t75 = t24 * t22 * t38
  t78 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t75 * t45)
  t80 = 0.18040e1 - 0.8040e0 * t78
  t81 = 0.19012500000000000000000000000000000000000000000000e0 * t34
  t82 = 0.19500000000000000000000000000000000000000000000000e0 * t46
  t83 = 0.1e1 / t24
  t84 = t28 * s0
  t85 = t83 * t84
  t86 = 0.1e1 / t60
  t88 = 0.17395833333333333333333333333333333333333333333334e0 * t85 * t86
  t89 = 0.52083333333333333333333333333333333333333333333334e-2 * t65
  t92 = t22 / t37 / t24
  t94 = t28 * t58 * t40
  t95 = t60 * t42
  t97 = 0.1e1 / t19 / t95
  t100 = 0.32552083333333333333333333333333333333333333333334e-3 * t92 * t94 * t97
  t101 = -0.40608000000000000000000000000000000000000000000000e0 + t81 - t82 + t88 - t89 + t100
  t103 = 0.14060800000000000000000000000000000000000000000000e1 - t81 + t82 - t88 + t89 - t100
  t106 = f.my_piecewise5(t36, t72, t73, t80, t101 * t80 + t103 * t72)
  t110 = t17 * t18
  t111 = t69 ** 2
  t112 = 0.1e1 / t111
  t113 = t42 * r0
  t115 = 0.1e1 / t19 / t113
  t117 = t39 * t41 * t115
  t119 = t40 * t115
  t120 = t119 * t51
  t123 = t57 * t58
  t125 = 0.1e1 / t18 / t95
  t126 = t29 * t125
  t130 = 0.1e1 / t67
  t131 = t126 * t130
  t134 = -0.10e2 / 0.729e3 * t117 - 0.10673131404562256652949245541838134430727023319615e-1 * t48 * t120 + 0.88942761704685472107910379515317786922725194330129e-3 * t123 * t126 * t51 - 0.14699017287336701468272112990905857846872936036166e-3 * t123 * t131
  t137 = t115 * t78
  t138 = t41 * t137
  t142 = 0.1e1 / t18 / t42
  t147 = 0.1e1 / t61
  t153 = t60 * t113
  t155 = 0.1e1 / t19 / t153
  t159 = -0.25350000000000000000000000000000000000000000000000e0 * t27 * t30 * t142 + 0.52000000000000000000000000000000000000000000000000e0 * t117 - 0.69583333333333333333333333333333333333333333333336e0 * t85 * t147 + 0.27777777777777777777777777777777777777777777777778e-1 * t57 * t59 * t125 - 0.21701388888888888888888888888888888888888888888889e-2 * t92 * t94 * t155
  t161 = t101 * t24
  t162 = t161 * t39
  t165 = -t159
  t167 = t103 * t112
  t171 = f.my_piecewise5(t36, 0.64641600e0 * t112 * t134, t73, -0.24712796519684896296296296296296296296296296296295e-2 * t75 * t138, t159 * t80 - 0.24712796519684896296296296296296296296296296296295e-2 * t162 * t138 + t165 * t72 + 0.64641600e0 * t167 * t134)
  t176 = f.my_piecewise3(t2, 0, -t6 * t21 * t106 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t110 * t171)
  t188 = 0.1e1 / t111 / t69
  t189 = t134 ** 2
  t193 = 0.1e1 / t19 / t60
  t195 = t39 * t41 * t193
  t202 = 0.1e1 / t18 / t153
  t203 = t29 * t202
  t207 = t24 ** 2
  t208 = 0.1e1 / t207
  t209 = t58 * s0
  t211 = t60 ** 2
  t212 = t211 * t42
  t222 = t22 / t37 / t207
  t223 = t58 ** 2
  t229 = t67 ** 2
  t230 = 0.1e1 / t229
  t234 = 0.110e3 / 0.2187e4 * t195 + 0.39134815150061607727480566986739826245999085505255e-1 * t48 * t40 * t193 * t51 - 0.80048485534216924897119341563786008230452674897115e-2 * t123 * t203 * t51 + 0.11859034893958062947721383935375704923030025910684e-2 * t208 * t209 / t212 * t51 + 0.93093776153132442632390048942403766363528594895718e-3 * t123 * t203 * t130 - 0.12963666552805392106469610577525293196354413769776e-6 * t222 * t223 * t40 / t19 / t211 / t60 * t230
  t239 = t41 * t193 * t78
  t243 = t207 * t23 * t56
  t245 = t59 * t202 * t78
  t266 = 0.59150000000000000000000000000000000000000000000000e0 * t27 * t30 / t18 / t113 - 0.19066666666666666666666666666666666666666666666667e1 * t195 + 0.34791666666666666666666666666666666666666666666668e1 * t85 / t95 - 0.17592592592592592592592592592592592592592592592593e0 * t57 * t59 * t202 + 0.16637731481481481481481481481481481481481481481482e-1 * t92 * t94 / t19 / t211
  t268 = t159 * t24
  t274 = t101 * t207
  t275 = t274 * t57
  t280 = t165 * t112
  t283 = t103 * t188
  t289 = f.my_piecewise5(t36, -0.129283200e1 * t188 * t189 + 0.64641600e0 * t112 * t234, t73, 0.90613587238844619753086419753086419753086419753082e-2 * t75 * t239 - 0.15192097309038555297896599262290741081970121955379e-4 * t243 * t245, t266 * t80 - 0.49425593039369792592592592592592592592592592592590e-2 * t268 * t39 * t138 + 0.90613587238844619753086419753086419753086419753082e-2 * t162 * t239 - 0.15192097309038555297896599262290741081970121955379e-4 * t275 * t245 - t266 * t72 + 0.129283200e1 * t280 * t134 - 0.129283200e1 * t283 * t189 + 0.64641600e0 * t167 * t234)
  t294 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t106 / 0.12e2 - t6 * t21 * t171 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t110 * t289)
  v2rho2_0_ = 0.2e1 * r0 * t294 + 0.4e1 * t176
  t297 = t39 * t49
  t301 = t57 * s0
  t302 = t29 * t63
  t303 = t302 * t51
  t306 = t302 * t130
  t309 = 0.5e1 / 0.972e3 * t297 + 0.40024242767108462448559670781893004115226337448558e-2 * t39 * t52 - 0.33353535639257052040466392318244170096021947873798e-3 * t301 * t303 + 0.55121314827512630506020423715896966925773510135624e-4 * t301 * t306
  t315 = 0.1e1 / t28
  t316 = t315 * t29
  t321 = t83 * t28
  t324 = s0 * t29
  t328 = t84 * t40
  t332 = 0.95062500000000000000000000000000000000000000000000e-1 * t27 * t316 * t32 - 0.19500000000000000000000000000000000000000000000000e0 * t297 + 0.26093750000000000000000000000000000000000000000001e0 * t321 * t86 - 0.10416666666666666666666666666666666666666666666667e-1 * t57 * t324 * t63 + 0.81380208333333333333333333333333333333333333333335e-3 * t92 * t328 * t97
  t334 = t161 * t22
  t335 = t38 * t40
  t337 = t335 * t44 * t78
  t340 = -t332
  t345 = f.my_piecewise5(t36, 0.64641600e0 * t112 * t309, t73, 0.92672986948818361111111111111111111111111111111107e-3 * t75 * t49 * t78, t332 * t80 + 0.92672986948818361111111111111111111111111111111107e-3 * t334 * t337 + t340 * t72 + 0.64641600e0 * t167 * t309)
  t349 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t110 * t345)
  t356 = t39 * t119
  t381 = -0.10e2 / 0.729e3 * t356 - 0.10673131404562256652949245541838134430727023319615e-1 * t39 * t120 + 0.26682828511405641632373113854595336076817558299039e-2 * t57 * t29 * t125 * s0 * t51 - 0.44471380852342736053955189757658893461362597165064e-3 * t208 * t58 / t211 / r0 * t51 - 0.29398034574673402936544225981811715693745872072333e-3 * t301 * t131 + 0.48613749573020220399261039665719849486329051636662e-7 * t222 * t209 * t40 / t19 / t211 / t113 * t230
  t389 = t126 * s0 * t78
  t405 = -0.12675000000000000000000000000000000000000000000000e0 * t27 * t316 * t142 + 0.52000000000000000000000000000000000000000000000000e0 * t356 - 0.10437500000000000000000000000000000000000000000000e1 * t321 * t147 + 0.55555555555555555555555555555555555555555555555557e-1 * t57 * t324 * t125 - 0.54253472222222222222222222222222222222222222222223e-2 * t92 * t328 * t155
  t407 = t332 * t24
  t421 = t340 * t112
  t432 = f.my_piecewise5(t36, -0.129283200e1 * t188 * t309 * t134 + 0.64641600e0 * t112 * t381, t73, -0.24712796519684896296296296296296296296296296296295e-2 * t75 * t119 * t78 + 0.56970364908894582367112247233590279057387957332673e-5 * t243 * t389, t405 * t80 - 0.24712796519684896296296296296296296296296296296295e-2 * t407 * t39 * t138 + 0.92672986948818361111111111111111111111111111111107e-3 * t268 * t22 * t337 - 0.24712796519684896296296296296296296296296296296295e-2 * t334 * t335 * t137 + 0.56970364908894582367112247233590279057387957332673e-5 * t275 * t389 - t405 * t72 + 0.64641600e0 * t421 * t134 + 0.64641600e0 * t280 * t309 - 0.129283200e1 * t283 * t309 * t134 + 0.64641600e0 * t167 * t381)
  t437 = f.my_piecewise3(t2, 0, -t6 * t21 * t345 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t110 * t432)
  v2rhosigma_0_ = 0.2e1 * r0 * t437 + 0.2e1 * t349
  t440 = t309 ** 2
  t459 = -0.66707071278514104080932784636488340192043895747596e-3 * t57 * t303 + 0.16676767819628526020233196159122085048010973936899e-3 * t208 * s0 / t211 * t51 + 0.55121314827512630506020423715896966925773510135624e-4 * t57 * t306 - 0.18230156089882582649722889874644943557373394363748e-7 * t222 * t58 * t40 / t19 / t212 * t230
  t480 = -0.47531250000000000000000000000000000000000000000000e-1 * t27 / t84 * t29 * t32 + 0.13046875000000000000000000000000000000000000000000e0 * t83 * t315 * t86 - 0.10416666666666666666666666666666666666666666666667e-1 * t57 * t302 + 0.12207031250000000000000000000000000000000000000000e-2 * t92 * t28 * t40 * t97
  t500 = f.my_piecewise5(t36, -0.129283200e1 * t188 * t440 + 0.64641600e0 * t112 * t459, t73, -0.21363886840835468387667092712596354646520483999753e-5 * t243 * t302 * t78, t480 * t80 + 0.18534597389763672222222222222222222222222222222221e-2 * t407 * t22 * t337 - 0.21363886840835468387667092712596354646520483999753e-5 * t274 * t23 * t56 * t29 * t63 * t78 - t480 * t72 + 0.129283200e1 * t421 * t309 - 0.129283200e1 * t283 * t440 + 0.64641600e0 * t167 * t459)
  t504 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t110 * t500)
  v2sigma2_0_ = 0.2e1 * r0 * t504
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t28 = t24 / t26
  t29 = jnp.sqrt(s0)
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t35 = t28 * t31 / t18 / r0
  t36 = t35 / 0.12e2
  t37 = t36 <= 0.6e0
  t38 = t26 ** 2
  t39 = 0.1e1 / t38
  t40 = t23 * t39
  t41 = t30 ** 2
  t42 = s0 * t41
  t43 = r0 ** 2
  t45 = 0.1e1 / t19 / t43
  t46 = t42 * t45
  t47 = t40 * t46
  t49 = t40 * s0
  t52 = jnp.exp(-t47 / 0.24e2)
  t57 = 0.1e1 / t26 / t25
  t58 = t24 * t57
  t59 = s0 ** 2
  t60 = t59 * t30
  t61 = t43 ** 2
  t62 = t61 * r0
  t66 = t58 * t60 / t18 / t62
  t68 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t66
  t69 = jnp.log(t68)
  t70 = 0.8040e0 + 0.5e1 / 0.972e3 * t47 + 0.40024242767108462448559670781893004115226337448558e-2 * t49 * t41 * t45 * t52 + t69
  t73 = 0.18040e1 - 0.64641600e0 / t70
  t74 = 0.26e1 <= t36
  t76 = t25 * t23 * t39
  t79 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t76 * t46)
  t81 = 0.18040e1 - 0.8040e0 * t79
  t82 = 0.19012500000000000000000000000000000000000000000000e0 * t35
  t83 = 0.19500000000000000000000000000000000000000000000000e0 * t47
  t86 = 0.1e1 / t25 * t29 * s0
  t89 = 0.17395833333333333333333333333333333333333333333334e0 * t86 / t61
  t90 = 0.52083333333333333333333333333333333333333333333334e-2 * t66
  t93 = t23 / t38 / t25
  t95 = t29 * t59 * t41
  t96 = t61 * t43
  t101 = 0.32552083333333333333333333333333333333333333333334e-3 * t93 * t95 / t19 / t96
  t102 = -0.40608000000000000000000000000000000000000000000000e0 + t82 - t83 + t89 - t90 + t101
  t104 = 0.14060800000000000000000000000000000000000000000000e1 - t82 + t83 - t89 + t90 - t101
  t107 = f.my_piecewise5(t37, t73, t74, t81, t102 * t81 + t104 * t73)
  t112 = t17 / t19
  t113 = t70 ** 2
  t114 = 0.1e1 / t113
  t115 = t43 * r0
  t117 = 0.1e1 / t19 / t115
  t119 = t40 * t42 * t117
  t125 = t58 * t59
  t127 = 0.1e1 / t18 / t96
  t128 = t30 * t127
  t132 = 0.1e1 / t68
  t136 = -0.10e2 / 0.729e3 * t119 - 0.10673131404562256652949245541838134430727023319615e-1 * t49 * t41 * t117 * t52 + 0.88942761704685472107910379515317786922725194330129e-3 * t125 * t128 * t52 - 0.14699017287336701468272112990905857846872936036166e-3 * t125 * t128 * t132
  t140 = t42 * t117 * t79
  t155 = t61 * t115
  t161 = -0.25350000000000000000000000000000000000000000000000e0 * t28 * t31 / t18 / t43 + 0.52000000000000000000000000000000000000000000000000e0 * t119 - 0.69583333333333333333333333333333333333333333333336e0 * t86 / t62 + 0.27777777777777777777777777777777777777777777777778e-1 * t58 * t60 * t127 - 0.21701388888888888888888888888888888888888888888889e-2 * t93 * t95 / t19 / t155
  t163 = t102 * t25
  t164 = t163 * t40
  t167 = -t161
  t169 = t104 * t114
  t173 = f.my_piecewise5(t37, 0.64641600e0 * t114 * t136, t74, -0.24712796519684896296296296296296296296296296296295e-2 * t76 * t140, t161 * t81 - 0.24712796519684896296296296296296296296296296296295e-2 * t164 * t140 + t167 * t73 + 0.64641600e0 * t169 * t136)
  t177 = t17 * t18
  t179 = 0.1e1 / t113 / t70
  t180 = t136 ** 2
  t184 = 0.1e1 / t19 / t61
  t186 = t40 * t42 * t184
  t193 = 0.1e1 / t18 / t155
  t194 = t30 * t193
  t198 = t25 ** 2
  t199 = 0.1e1 / t198
  t200 = t59 * s0
  t201 = t199 * t200
  t202 = t61 ** 2
  t214 = t59 ** 2
  t215 = t23 / t38 / t198 * t214
  t220 = t68 ** 2
  t221 = 0.1e1 / t220
  t225 = 0.110e3 / 0.2187e4 * t186 + 0.39134815150061607727480566986739826245999085505255e-1 * t49 * t41 * t184 * t52 - 0.80048485534216924897119341563786008230452674897115e-2 * t125 * t194 * t52 + 0.11859034893958062947721383935375704923030025910684e-2 * t201 / t202 / t43 * t52 + 0.93093776153132442632390048942403766363528594895718e-3 * t125 * t194 * t132 - 0.12963666552805392106469610577525293196354413769776e-6 * t215 * t41 / t19 / t202 / t61 * t221
  t230 = t42 * t184 * t79
  t234 = t198 * t24 * t57
  t236 = t60 * t193 * t79
  t257 = 0.59150000000000000000000000000000000000000000000000e0 * t28 * t31 / t18 / t115 - 0.19066666666666666666666666666666666666666666666667e1 * t186 + 0.34791666666666666666666666666666666666666666666668e1 * t86 / t96 - 0.17592592592592592592592592592592592592592592592593e0 * t58 * t60 * t193 + 0.16637731481481481481481481481481481481481481481482e-1 * t93 * t95 / t19 / t202
  t260 = t161 * t25 * t40
  t266 = t102 * t198 * t58
  t269 = -t257
  t271 = t167 * t114
  t274 = t104 * t179
  t280 = f.my_piecewise5(t37, -0.129283200e1 * t179 * t180 + 0.64641600e0 * t114 * t225, t74, 0.90613587238844619753086419753086419753086419753082e-2 * t76 * t230 - 0.15192097309038555297896599262290741081970121955379e-4 * t234 * t236, t257 * t81 - 0.49425593039369792592592592592592592592592592592590e-2 * t260 * t140 + 0.90613587238844619753086419753086419753086419753082e-2 * t164 * t230 - 0.15192097309038555297896599262290741081970121955379e-4 * t266 * t236 + t269 * t73 + 0.129283200e1 * t271 * t136 - 0.129283200e1 * t274 * t180 + 0.64641600e0 * t169 * t225)
  t285 = f.my_piecewise3(t2, 0, t6 * t22 * t107 / 0.12e2 - t6 * t112 * t173 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t177 * t280)
  t297 = t113 ** 2
  t298 = 0.1e1 / t297
  t299 = t180 * t136
  t306 = 0.1e1 / t19 / t62
  t308 = t40 * t42 * t306
  t315 = 0.1e1 / t18 / t202
  t316 = t30 * t315
  t321 = 0.1e1 / t202 / t115
  t328 = 0.1e1 / t19 / t202 / t62
  t341 = t198 ** 2
  t345 = t202 ** 2
  t353 = -0.1540e4 / 0.6561e4 * t308 - 0.18262913736695416939490931260478585581466239902452e0 * t49 * t41 * t306 * t52 + 0.67398848313994991086216532032718589645887313925718e-1 * t125 * t316 * t52 - 0.22532166298520319600670629477213839353757049230299e-1 * t201 * t321 * t52 + 0.13176705437731181053023759928195227692255584345204e-3 * t199 * t214 * t328 * t40 * t41 * t52 - 0.68268769178963791263752702557762761999920969590193e-2 * t125 * t316 * t132 + 0.24630966450330245002292260097298057073073386162575e-5 * t215 * t41 * t328 * t221 - 0.45732758104069210195759153809253530181707585823428e-9 / t341 * t214 * t59 / t345 / t115 / t220 / t68
  t358 = t42 * t306 * t79
  t362 = t60 * t315 * t79
  t388 = -0.19716666666666666666666666666666666666666666666667e1 * t28 * t31 / t18 / t61 + 0.88977777777777777777777777777777777777777777777779e1 * t308 - 0.20875000000000000000000000000000000000000000000001e2 * t86 / t155 + 0.12901234567901234567901234567901234567901234567902e1 * t58 * t60 * t315 - 0.14419367283950617283950617283950617283950617283951e0 * t93 * t95 / t19 / t202 / r0
  t426 = t388 * t81 - 0.74138389559054688888888888888888888888888888888885e-2 * t257 * t25 * t40 * t140 + 0.27184076171653385925925925925925925925925925925924e-1 * t260 * t230 - 0.45576291927115665893689797786872223245910365866138e-4 * t161 * t198 * t58 * t236 - 0.42286340711460822551440329218106995884773662551438e-1 * t164 * t358 + 0.16711307039942410827686259188519815190167134150917e-3 * t266 * t362 - 0.56035702911271983251131570489766896272205936856273e-6 * t163 * t200 * t321 * t79 - t388 * t73 + 0.193924800e1 * t269 * t114 * t136 - 0.387849600e1 * t167 * t179 * t180 + 0.193924800e1 * t271 * t225 + 0.387849600e1 * t104 * t298 * t299 - 0.387849600e1 * t274 * t136 * t225 + 0.64641600e0 * t169 * t353
  t427 = f.my_piecewise5(t37, 0.387849600e1 * t298 * t299 - 0.387849600e1 * t179 * t136 * t225 + 0.64641600e0 * t114 * t353, t74, -0.42286340711460822551440329218106995884773662551438e-1 * t76 * t358 + 0.16711307039942410827686259188519815190167134150917e-3 * t234 * t362 - 0.56035702911271983251131570489766896272205936856273e-6 * t25 * t200 * t321 * t79, t426)
  t432 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t45 * t107 + t6 * t22 * t173 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t112 * t280 - 0.3e1 / 0.8e1 * t6 * t177 * t427)
  v3rho3_0_ = 0.2e1 * r0 * t432 + 0.6e1 * t285

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t29 = t25 / t27
  t30 = jnp.sqrt(s0)
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t30 * t31
  t36 = t29 * t32 / t19 / r0
  t37 = t36 / 0.12e2
  t38 = t37 <= 0.6e0
  t39 = t27 ** 2
  t40 = 0.1e1 / t39
  t41 = t24 * t40
  t42 = t31 ** 2
  t43 = s0 * t42
  t44 = t43 * t22
  t45 = t41 * t44
  t47 = t41 * s0
  t50 = jnp.exp(-t45 / 0.24e2)
  t55 = 0.1e1 / t27 / t26
  t56 = t25 * t55
  t57 = s0 ** 2
  t58 = t57 * t31
  t59 = t18 ** 2
  t60 = t59 * r0
  t62 = 0.1e1 / t19 / t60
  t64 = t56 * t58 * t62
  t66 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t64
  t67 = jnp.log(t66)
  t68 = 0.8040e0 + 0.5e1 / 0.972e3 * t45 + 0.40024242767108462448559670781893004115226337448558e-2 * t47 * t42 * t22 * t50 + t67
  t71 = 0.18040e1 - 0.64641600e0 / t68
  t72 = 0.26e1 <= t37
  t74 = t26 * t24 * t40
  t77 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t74 * t44)
  t79 = 0.18040e1 - 0.8040e0 * t77
  t80 = 0.19012500000000000000000000000000000000000000000000e0 * t36
  t81 = 0.19500000000000000000000000000000000000000000000000e0 * t45
  t84 = 0.1e1 / t26 * t30 * s0
  t87 = 0.17395833333333333333333333333333333333333333333334e0 * t84 / t59
  t88 = 0.52083333333333333333333333333333333333333333333334e-2 * t64
  t91 = t24 / t39 / t26
  t93 = t30 * t57 * t42
  t94 = t59 * t18
  t96 = 0.1e1 / t20 / t94
  t99 = 0.32552083333333333333333333333333333333333333333334e-3 * t91 * t93 * t96
  t100 = -0.40608000000000000000000000000000000000000000000000e0 + t80 - t81 + t87 - t88 + t99
  t102 = 0.14060800000000000000000000000000000000000000000000e1 - t80 + t81 - t87 + t88 - t99
  t105 = f.my_piecewise5(t38, t71, t72, t79, t100 * t79 + t102 * t71)
  t111 = t17 / t20 / r0
  t112 = t68 ** 2
  t113 = 0.1e1 / t112
  t114 = t18 * r0
  t116 = 0.1e1 / t20 / t114
  t118 = t41 * t43 * t116
  t124 = t56 * t57
  t126 = 0.1e1 / t19 / t94
  t127 = t31 * t126
  t131 = 0.1e1 / t66
  t135 = -0.10e2 / 0.729e3 * t118 - 0.10673131404562256652949245541838134430727023319615e-1 * t47 * t42 * t116 * t50 + 0.88942761704685472107910379515317786922725194330129e-3 * t124 * t127 * t50 - 0.14699017287336701468272112990905857846872936036166e-3 * t124 * t127 * t131
  t139 = t43 * t116 * t77
  t154 = t59 * t114
  t160 = -0.25350000000000000000000000000000000000000000000000e0 * t29 * t32 / t19 / t18 + 0.52000000000000000000000000000000000000000000000000e0 * t118 - 0.69583333333333333333333333333333333333333333333336e0 * t84 / t60 + 0.27777777777777777777777777777777777777777777777778e-1 * t56 * t58 * t126 - 0.21701388888888888888888888888888888888888888888889e-2 * t91 * t93 / t20 / t154
  t162 = t100 * t26
  t163 = t162 * t41
  t166 = -t160
  t168 = t102 * t113
  t172 = f.my_piecewise5(t38, 0.64641600e0 * t113 * t135, t72, -0.24712796519684896296296296296296296296296296296295e-2 * t74 * t139, t160 * t79 - 0.24712796519684896296296296296296296296296296296295e-2 * t163 * t139 + t166 * t71 + 0.64641600e0 * t168 * t135)
  t177 = t17 / t20
  t179 = 0.1e1 / t112 / t68
  t180 = t135 ** 2
  t184 = 0.1e1 / t20 / t59
  t186 = t41 * t43 * t184
  t193 = 0.1e1 / t19 / t154
  t194 = t31 * t193
  t198 = t26 ** 2
  t199 = 0.1e1 / t198
  t200 = t57 * s0
  t201 = t199 * t200
  t202 = t59 ** 2
  t203 = t202 * t18
  t214 = t57 ** 2
  t215 = t24 / t39 / t198 * t214
  t216 = t202 * t59
  t220 = t66 ** 2
  t221 = 0.1e1 / t220
  t225 = 0.110e3 / 0.2187e4 * t186 + 0.39134815150061607727480566986739826245999085505255e-1 * t47 * t42 * t184 * t50 - 0.80048485534216924897119341563786008230452674897115e-2 * t124 * t194 * t50 + 0.11859034893958062947721383935375704923030025910684e-2 * t201 / t203 * t50 + 0.93093776153132442632390048942403766363528594895718e-3 * t124 * t194 * t131 - 0.12963666552805392106469610577525293196354413769776e-6 * t215 * t42 / t20 / t216 * t221
  t230 = t43 * t184 * t77
  t234 = t198 * t25 * t55
  t236 = t58 * t193 * t77
  t257 = 0.59150000000000000000000000000000000000000000000000e0 * t29 * t32 / t19 / t114 - 0.19066666666666666666666666666666666666666666666667e1 * t186 + 0.34791666666666666666666666666666666666666666666668e1 * t84 / t94 - 0.17592592592592592592592592592592592592592592592593e0 * t56 * t58 * t193 + 0.16637731481481481481481481481481481481481481481482e-1 * t91 * t93 / t20 / t202
  t259 = t160 * t26
  t260 = t259 * t41
  t265 = t100 * t198
  t266 = t265 * t56
  t269 = -t257
  t271 = t166 * t113
  t274 = t102 * t179
  t280 = f.my_piecewise5(t38, -0.129283200e1 * t179 * t180 + 0.64641600e0 * t113 * t225, t72, 0.90613587238844619753086419753086419753086419753082e-2 * t74 * t230 - 0.15192097309038555297896599262290741081970121955379e-4 * t234 * t236, t257 * t79 - 0.49425593039369792592592592592592592592592592592590e-2 * t260 * t139 + 0.90613587238844619753086419753086419753086419753082e-2 * t163 * t230 - 0.15192097309038555297896599262290741081970121955379e-4 * t266 * t236 + t269 * t71 + 0.129283200e1 * t271 * t135 - 0.129283200e1 * t274 * t180 + 0.64641600e0 * t168 * t225)
  t284 = t17 * t19
  t285 = t112 ** 2
  t286 = 0.1e1 / t285
  t287 = t180 * t135
  t290 = t179 * t135
  t294 = 0.1e1 / t20 / t60
  t296 = t41 * t43 * t294
  t303 = 0.1e1 / t19 / t202
  t304 = t31 * t303
  t309 = 0.1e1 / t202 / t114
  t313 = t199 * t214
  t316 = 0.1e1 / t20 / t202 / t60
  t319 = t41 * t42 * t50
  t329 = t198 ** 2
  t330 = 0.1e1 / t329
  t332 = t330 * t214 * t57
  t333 = t202 ** 2
  t337 = 0.1e1 / t220 / t66
  t341 = -0.1540e4 / 0.6561e4 * t296 - 0.18262913736695416939490931260478585581466239902452e0 * t47 * t42 * t294 * t50 + 0.67398848313994991086216532032718589645887313925718e-1 * t124 * t304 * t50 - 0.22532166298520319600670629477213839353757049230299e-1 * t201 * t309 * t50 + 0.13176705437731181053023759928195227692255584345204e-3 * t313 * t316 * t319 - 0.68268769178963791263752702557762761999920969590193e-2 * t124 * t304 * t131 + 0.24630966450330245002292260097298057073073386162575e-5 * t215 * t42 * t316 * t221 - 0.45732758104069210195759153809253530181707585823428e-9 * t332 / t333 / t114 * t337
  t346 = t43 * t294 * t77
  t350 = t58 * t303 * t77
  t353 = t26 * t200
  t370 = t202 * r0
  t376 = -0.19716666666666666666666666666666666666666666666667e1 * t29 * t32 / t19 / t59 + 0.88977777777777777777777777777777777777777777777779e1 * t296 - 0.20875000000000000000000000000000000000000000000001e2 * t84 / t154 + 0.12901234567901234567901234567901234567901234567902e1 * t56 * t58 * t303 - 0.14419367283950617283950617283950617283950617283951e0 * t91 * t93 / t20 / t370
  t379 = t257 * t26 * t41
  t385 = t160 * t198 * t56
  t393 = t200 * t309 * t77
  t396 = -t376
  t398 = t269 * t113
  t401 = t166 * t179
  t406 = t102 * t286
  t409 = t135 * t225
  t414 = t376 * t79 - 0.74138389559054688888888888888888888888888888888885e-2 * t379 * t139 + 0.27184076171653385925925925925925925925925925925924e-1 * t260 * t230 - 0.45576291927115665893689797786872223245910365866138e-4 * t385 * t236 - 0.42286340711460822551440329218106995884773662551438e-1 * t163 * t346 + 0.16711307039942410827686259188519815190167134150917e-3 * t266 * t350 - 0.56035702911271983251131570489766896272205936856273e-6 * t162 * t393 + t396 * t71 + 0.193924800e1 * t398 * t135 - 0.387849600e1 * t401 * t180 + 0.193924800e1 * t271 * t225 + 0.387849600e1 * t406 * t287 - 0.387849600e1 * t274 * t409 + 0.64641600e0 * t168 * t341
  t415 = f.my_piecewise5(t38, 0.387849600e1 * t286 * t287 - 0.387849600e1 * t290 * t225 + 0.64641600e0 * t113 * t341, t72, -0.42286340711460822551440329218106995884773662551438e-1 * t74 * t346 + 0.16711307039942410827686259188519815190167134150917e-3 * t234 * t350 - 0.56035702911271983251131570489766896272205936856273e-6 * t353 * t309 * t77, t414)
  t420 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t105 + t6 * t111 * t172 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t177 * t280 - 0.3e1 / 0.8e1 * t6 * t284 * t415)
  t436 = 0.1e1 / t285 / t68
  t437 = t180 ** 2
  t443 = t225 ** 2
  t449 = t41 * t43 * t96
  t456 = 0.1e1 / t19 / t370
  t457 = t31 * t456
  t461 = 0.1e1 / t216
  t467 = 0.1e1 / t20 / t202 / t94
  t493 = t214 ** 2
  t499 = t220 ** 2
  t506 = 0.26180e5 / 0.19683e5 * t449 + 0.10348984450794069599044861047604531829497535944723e1 * t47 * t42 * t96 * t50 - 0.60224132203150363002845094751816288167454148249755e0 * t124 * t457 * t50 + 0.33771896036905017038899896695964368575251062676758e0 * t201 * t461 * t50 - 0.43043904429921858106544282432104410461368242194334e-2 * t313 * t467 * t319 + 0.29281567639402624562275022062656061538345742989342e-4 * t199 * t214 * s0 / t19 / t333 / r0 * t56 * t31 * t50 + 0.56890640982469826053127252131468968333267474658494e-1 * t124 * t457 * t131 - 0.39683223725532061392581974601202425284396011039704e-4 * t215 * t42 * t467 * t221 + 0.17378448079546299874388478447516341469048882612903e-7 * t332 / t333 / t59 * t337 - 0.20166798059079028575410218001018837907291869118661e-12 * t330 * t493 / t19 / t333 / t370 / t499 * t25 * t55 * t31
  t511 = t43 * t96 * t77
  t515 = t58 * t456 * t77
  t524 = t41 * t42 * t77
  t559 = -0.517132800e1 * t274 * t135 * t341 - 0.1551398400e2 * t102 * t436 * t437 + 0.2327097600e2 * t406 * t180 * t225 - 0.387849600e1 * t274 * t443 - 0.775699200e1 * t269 * t179 * t180 + 0.1551398400e2 * t166 * t286 * t287 - 0.1551398400e2 * t401 * t409 + 0.66845228159769643310745036754079260760668536603669e-3 * t385 * t350 - 0.16525625850609717374045300753091817243609721549240e-2 * t266 * t515 - 0.17223867212484814414615427204238283660113967719113e-8 * t265 * t214 * t467 * t524 - 0.98851186078739585185185185185185185185185185185180e-2 * t376 * t26 * t41 * t139
  t588 = 0.85438888888888888888888888888888888888888888888890e1 * t29 * t32 * t62 - 0.50420740740740740740740740740740740740740740740741e2 * t449 + 0.14612500000000000000000000000000000000000000000001e3 * t84 / t202 - 0.10751028806584362139917695473251028806584362139918e2 * t56 * t58 * t456 + 0.13938721707818930041152263374485596707818930041153e1 * t91 * t93 / t20 / t203
  t604 = -0.91152583854231331787379595573744446491820731732276e-4 * t257 * t198 * t56 * t236 + 0.64641600e0 * t168 * t506 + 0.258566400e1 * t271 * t341 + 0.258566400e1 * t396 * t113 * t135 + 0.387849600e1 * t398 * t225 + t588 * t79 - t588 * t71 + 0.12327854640479836315248945507748717179885306108380e-4 * t162 * t200 * t461 * t77 - 0.22414281164508793300452628195906758508882374742509e-5 * t259 * t393 - 0.16914536284584329020576131687242798353909465020575e0 * t260 * t346 + 0.23962259736494466112482853223593964334705075445815e0 * t163 * t511 + 0.54368152343306771851851851851851851851851851851849e-1 * t379 * t230
  t606 = f.my_piecewise5(t38, -0.1551398400e2 * t436 * t437 + 0.2327097600e2 * t286 * t180 * t225 - 0.387849600e1 * t179 * t443 - 0.517132800e1 * t290 * t341 + 0.64641600e0 * t113 * t506, t72, 0.23962259736494466112482853223593964334705075445815e0 * t74 * t511 - 0.16525625850609717374045300753091817243609721549240e-2 * t234 * t515 + 0.12327854640479836315248945507748717179885306108380e-4 * t353 * t461 * t77 - 0.17223867212484814414615427204238283660113967719113e-8 * t198 * t214 * t467 * t524, t559 + t604)
  t611 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t116 * t105 - 0.5e1 / 0.9e1 * t6 * t23 * t172 + t6 * t111 * t280 / 0.2e1 - t6 * t177 * t415 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t284 * t606)
  v4rho4_0_ = 0.2e1 * r0 * t611 + 0.8e1 * t420

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = jnp.pi ** 2
  t35 = t34 ** (0.1e1 / 0.3e1)
  t37 = t33 / t35
  t38 = jnp.sqrt(s0)
  t39 = r0 ** (0.1e1 / 0.3e1)
  t43 = t37 * t38 / t39 / r0
  t44 = t43 / 0.12e2
  t45 = t44 <= 0.6e0
  t46 = t35 ** 2
  t47 = 0.1e1 / t46
  t48 = t32 * t47
  t49 = r0 ** 2
  t50 = t39 ** 2
  t52 = 0.1e1 / t50 / t49
  t53 = s0 * t52
  t54 = t48 * t53
  t57 = jnp.exp(-t54 / 0.24e2)
  t62 = 0.1e1 / t35 / t34
  t63 = t33 * t62
  t64 = s0 ** 2
  t65 = t49 ** 2
  t66 = t65 * r0
  t70 = t63 * t64 / t39 / t66
  t72 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t70
  t73 = jnp.log(t72)
  t74 = 0.8040e0 + 0.5e1 / 0.972e3 * t54 + 0.40024242767108462448559670781893004115226337448558e-2 * t48 * t53 * t57 + t73
  t77 = 0.18040e1 - 0.64641600e0 / t74
  t78 = 0.26e1 <= t44
  t79 = t34 * t32
  t80 = t47 * s0
  t84 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t79 * t80 * t52)
  t86 = 0.18040e1 - 0.8040e0 * t84
  t87 = 0.19012500000000000000000000000000000000000000000000e0 * t43
  t88 = 0.19500000000000000000000000000000000000000000000000e0 * t54
  t89 = 0.1e1 / t34
  t91 = t89 * t38 * s0
  t94 = 0.86979166666666666666666666666666666666666666666668e-1 * t91 / t65
  t95 = 0.26041666666666666666666666666666666666666666666667e-2 * t70
  t98 = t32 / t46 / t34
  t99 = t38 * t64
  t100 = t65 * t49
  t105 = 0.16276041666666666666666666666666666666666666666667e-3 * t98 * t99 / t50 / t100
  t106 = -0.40608000000000000000000000000000000000000000000000e0 + t87 - t88 + t94 - t95 + t105
  t108 = 0.14060800000000000000000000000000000000000000000000e1 - t87 + t88 - t94 + t95 - t105
  t111 = f.my_piecewise5(t45, t77, t78, t86, t106 * t86 + t108 * t77)
  t115 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t116 = t115 * f.p.zeta_threshold
  t118 = f.my_piecewise3(t20, t116, t21 * t19)
  t119 = t30 ** 2
  t120 = 0.1e1 / t119
  t121 = t118 * t120
  t124 = t5 * t121 * t111 / 0.8e1
  t125 = t118 * t30
  t126 = t74 ** 2
  t127 = 0.1e1 / t126
  t128 = t49 * r0
  t130 = 0.1e1 / t50 / t128
  t131 = s0 * t130
  t132 = t48 * t131
  t139 = t64 / t39 / t100
  t143 = 0.1e1 / t72
  t147 = -0.10e2 / 0.729e3 * t132 - 0.10673131404562256652949245541838134430727023319615e-1 * t48 * t131 * t57 + 0.44471380852342736053955189757658893461362597165064e-3 * t63 * t139 * t57 - 0.73495086436683507341360564954529289234364680180832e-4 * t63 * t139 * t143
  t150 = t79 * t47
  t165 = t65 * t128
  t171 = -0.25350000000000000000000000000000000000000000000000e0 * t37 * t38 / t39 / t49 + 0.52000000000000000000000000000000000000000000000000e0 * t132 - 0.34791666666666666666666666666666666666666666666667e0 * t91 / t66 + 0.13888888888888888888888888888888888888888888888889e-1 * t63 * t139 - 0.10850694444444444444444444444444444444444444444445e-2 * t98 * t99 / t50 / t165
  t174 = t106 * t34 * t32
  t176 = t80 * t130 * t84
  t179 = -t171
  t181 = t108 * t127
  t185 = f.my_piecewise5(t45, 0.64641600e0 * t127 * t147, t78, -0.24712796519684896296296296296296296296296296296295e-2 * t150 * t131 * t84, t171 * t86 - 0.24712796519684896296296296296296296296296296296295e-2 * t174 * t176 + t179 * t77 + 0.64641600e0 * t181 * t147)
  t190 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t111 - t124 - 0.3e1 / 0.8e1 * t5 * t125 * t185)
  t192 = r1 <= f.p.dens_threshold
  t193 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t194 = 0.1e1 + t193
  t195 = t194 <= f.p.zeta_threshold
  t196 = t194 ** (0.1e1 / 0.3e1)
  t198 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t201 = f.my_piecewise3(t195, 0, 0.4e1 / 0.3e1 * t196 * t198)
  t202 = t201 * t30
  t203 = jnp.sqrt(s2)
  t204 = r1 ** (0.1e1 / 0.3e1)
  t208 = t37 * t203 / t204 / r1
  t209 = t208 / 0.12e2
  t210 = t209 <= 0.6e0
  t211 = r1 ** 2
  t212 = t204 ** 2
  t214 = 0.1e1 / t212 / t211
  t215 = s2 * t214
  t216 = t48 * t215
  t219 = jnp.exp(-t216 / 0.24e2)
  t223 = s2 ** 2
  t224 = t211 ** 2
  t225 = t224 * r1
  t229 = t63 * t223 / t204 / t225
  t231 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t229
  t232 = jnp.log(t231)
  t233 = 0.8040e0 + 0.5e1 / 0.972e3 * t216 + 0.40024242767108462448559670781893004115226337448558e-2 * t48 * t215 * t219 + t232
  t236 = 0.18040e1 - 0.64641600e0 / t233
  t237 = 0.26e1 <= t209
  t238 = t47 * s2
  t242 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t79 * t238 * t214)
  t244 = 0.18040e1 - 0.8040e0 * t242
  t245 = 0.19012500000000000000000000000000000000000000000000e0 * t208
  t246 = 0.19500000000000000000000000000000000000000000000000e0 * t216
  t248 = t89 * t203 * s2
  t251 = 0.86979166666666666666666666666666666666666666666668e-1 * t248 / t224
  t252 = 0.26041666666666666666666666666666666666666666666667e-2 * t229
  t253 = t203 * t223
  t254 = t224 * t211
  t259 = 0.16276041666666666666666666666666666666666666666667e-3 * t98 * t253 / t212 / t254
  t260 = -0.40608000000000000000000000000000000000000000000000e0 + t245 - t246 + t251 - t252 + t259
  t262 = 0.14060800000000000000000000000000000000000000000000e1 - t245 + t246 - t251 + t252 - t259
  t265 = f.my_piecewise5(t210, t236, t237, t244, t262 * t236 + t260 * t244)
  t270 = f.my_piecewise3(t195, t116, t196 * t194)
  t271 = t270 * t120
  t274 = t5 * t271 * t265 / 0.8e1
  t276 = f.my_piecewise3(t192, 0, -0.3e1 / 0.8e1 * t5 * t202 * t265 - t274)
  t278 = t21 ** 2
  t279 = 0.1e1 / t278
  t280 = t26 ** 2
  t285 = t16 / t22 / t6
  t287 = -0.2e1 * t23 + 0.2e1 * t285
  t288 = f.my_piecewise5(t10, 0, t14, 0, t287)
  t292 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t279 * t280 + 0.4e1 / 0.3e1 * t21 * t288)
  t299 = t5 * t29 * t120 * t111
  t305 = 0.1e1 / t119 / t6
  t309 = t5 * t118 * t305 * t111 / 0.12e2
  t311 = t5 * t121 * t185
  t314 = 0.1e1 / t126 / t74
  t315 = t147 ** 2
  t319 = 0.1e1 / t50 / t65
  t320 = s0 * t319
  t321 = t48 * t320
  t327 = 0.1e1 / t39 / t165
  t328 = t64 * t327
  t332 = t34 ** 2
  t333 = 0.1e1 / t332
  t336 = t65 ** 2
  t347 = t32 / t46 / t332
  t348 = t64 ** 2
  t353 = t72 ** 2
  t358 = 0.110e3 / 0.2187e4 * t321 + 0.39134815150061607727480566986739826245999085505255e-1 * t48 * t320 * t57 - 0.40024242767108462448559670781893004115226337448557e-2 * t63 * t328 * t57 + 0.29647587234895157369303459838439262307575064776709e-3 * t333 * t64 * s0 / t336 / t49 * t57 + 0.46546888076566221316195024471201883181764297447860e-3 * t63 * t328 * t143 - 0.32409166382013480266174026443813232990886034424442e-7 * t347 * t348 / t50 / t336 / t65 / t353
  t366 = t332 * t33 * t62
  t387 = 0.59150000000000000000000000000000000000000000000000e0 * t37 * t38 / t39 / t128 - 0.19066666666666666666666666666666666666666666666667e1 * t321 + 0.17395833333333333333333333333333333333333333333334e1 * t91 / t100 - 0.87962962962962962962962962962962962962962962962964e-1 * t63 * t328 + 0.83188657407407407407407407407407407407407407407412e-2 * t98 * t99 / t50 / t336
  t415 = f.my_piecewise5(t45, -0.129283200e1 * t314 * t315 + 0.64641600e0 * t127 * t358, t78, 0.90613587238844619753086419753086419753086419753082e-2 * t150 * t320 * t84 - 0.75960486545192776489482996311453705409850609776897e-5 * t366 * t328 * t84, t387 * t86 - 0.49425593039369792592592592592592592592592592592590e-2 * t171 * t34 * t32 * t176 + 0.90613587238844619753086419753086419753086419753082e-2 * t174 * t80 * t319 * t84 - 0.75960486545192776489482996311453705409850609776897e-5 * t106 * t332 * t33 * t62 * t64 * t327 * t84 - t387 * t77 + 0.129283200e1 * t179 * t127 * t147 - 0.129283200e1 * t108 * t314 * t315 + 0.64641600e0 * t181 * t358)
  t420 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t292 * t30 * t111 - t299 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t185 + t309 - t311 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t125 * t415)
  t421 = t196 ** 2
  t422 = 0.1e1 / t421
  t423 = t198 ** 2
  t427 = f.my_piecewise5(t14, 0, t10, 0, -t287)
  t431 = f.my_piecewise3(t195, 0, 0.4e1 / 0.9e1 * t422 * t423 + 0.4e1 / 0.3e1 * t196 * t427)
  t438 = t5 * t201 * t120 * t265
  t443 = t5 * t270 * t305 * t265 / 0.12e2
  t445 = f.my_piecewise3(t192, 0, -0.3e1 / 0.8e1 * t5 * t431 * t30 * t265 - t438 / 0.4e1 + t443)
  d11 = 0.2e1 * t190 + 0.2e1 * t276 + t6 * (t420 + t445)
  t448 = -t7 - t24
  t449 = f.my_piecewise5(t10, 0, t14, 0, t448)
  t452 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t449)
  t453 = t452 * t30
  t458 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t453 * t111 - t124)
  t460 = f.my_piecewise5(t14, 0, t10, 0, -t448)
  t463 = f.my_piecewise3(t195, 0, 0.4e1 / 0.3e1 * t196 * t460)
  t464 = t463 * t30
  t468 = t270 * t30
  t469 = t233 ** 2
  t470 = 0.1e1 / t469
  t471 = t211 * r1
  t473 = 0.1e1 / t212 / t471
  t474 = s2 * t473
  t475 = t48 * t474
  t482 = t223 / t204 / t254
  t486 = 0.1e1 / t231
  t490 = -0.10e2 / 0.729e3 * t475 - 0.10673131404562256652949245541838134430727023319615e-1 * t48 * t474 * t219 + 0.44471380852342736053955189757658893461362597165064e-3 * t63 * t482 * t219 - 0.73495086436683507341360564954529289234364680180832e-4 * t63 * t482 * t486
  t507 = t224 * t471
  t513 = -0.25350000000000000000000000000000000000000000000000e0 * t37 * t203 / t204 / t211 + 0.52000000000000000000000000000000000000000000000000e0 * t475 - 0.34791666666666666666666666666666666666666666666667e0 * t248 / t225 + 0.13888888888888888888888888888888888888888888888889e-1 * t63 * t482 - 0.10850694444444444444444444444444444444444444444445e-2 * t98 * t253 / t212 / t507
  t516 = t260 * t34 * t32
  t518 = t238 * t473 * t242
  t521 = -t513
  t523 = t262 * t470
  t527 = f.my_piecewise5(t210, 0.64641600e0 * t470 * t490, t237, -0.24712796519684896296296296296296296296296296296295e-2 * t150 * t474 * t242, t513 * t244 - 0.24712796519684896296296296296296296296296296296295e-2 * t516 * t518 + t521 * t236 + 0.64641600e0 * t523 * t490)
  t532 = f.my_piecewise3(t192, 0, -0.3e1 / 0.8e1 * t5 * t464 * t265 - t274 - 0.3e1 / 0.8e1 * t5 * t468 * t527)
  t536 = 0.2e1 * t285
  t537 = f.my_piecewise5(t10, 0, t14, 0, t536)
  t541 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t279 * t449 * t26 + 0.4e1 / 0.3e1 * t21 * t537)
  t548 = t5 * t452 * t120 * t111
  t556 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t541 * t30 * t111 - t548 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t453 * t185 - t299 / 0.8e1 + t309 - t311 / 0.8e1)
  t560 = f.my_piecewise5(t14, 0, t10, 0, -t536)
  t564 = f.my_piecewise3(t195, 0, 0.4e1 / 0.9e1 * t422 * t460 * t198 + 0.4e1 / 0.3e1 * t196 * t560)
  t571 = t5 * t463 * t120 * t265
  t578 = t5 * t271 * t527
  t581 = f.my_piecewise3(t192, 0, -0.3e1 / 0.8e1 * t5 * t564 * t30 * t265 - t571 / 0.8e1 - t438 / 0.8e1 + t443 - 0.3e1 / 0.8e1 * t5 * t202 * t527 - t578 / 0.8e1)
  d12 = t190 + t276 + t458 + t532 + t6 * (t556 + t581)
  t586 = t449 ** 2
  t590 = 0.2e1 * t23 + 0.2e1 * t285
  t591 = f.my_piecewise5(t10, 0, t14, 0, t590)
  t595 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t279 * t586 + 0.4e1 / 0.3e1 * t21 * t591)
  t602 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t595 * t30 * t111 - t548 / 0.4e1 + t309)
  t603 = t460 ** 2
  t607 = f.my_piecewise5(t14, 0, t10, 0, -t590)
  t611 = f.my_piecewise3(t195, 0, 0.4e1 / 0.9e1 * t422 * t603 + 0.4e1 / 0.3e1 * t196 * t607)
  t622 = 0.1e1 / t469 / t233
  t623 = t490 ** 2
  t627 = 0.1e1 / t212 / t224
  t628 = s2 * t627
  t629 = t48 * t628
  t635 = 0.1e1 / t204 / t507
  t636 = t223 * t635
  t642 = t224 ** 2
  t651 = t223 ** 2
  t656 = t231 ** 2
  t661 = 0.110e3 / 0.2187e4 * t629 + 0.39134815150061607727480566986739826245999085505255e-1 * t48 * t628 * t219 - 0.40024242767108462448559670781893004115226337448557e-2 * t63 * t636 * t219 + 0.29647587234895157369303459838439262307575064776709e-3 * t333 * t223 * s2 / t642 / t211 * t219 + 0.46546888076566221316195024471201883181764297447860e-3 * t63 * t636 * t486 - 0.32409166382013480266174026443813232990886034424442e-7 * t347 * t651 / t212 / t642 / t224 / t656
  t688 = 0.59150000000000000000000000000000000000000000000000e0 * t37 * t203 / t204 / t471 - 0.19066666666666666666666666666666666666666666666667e1 * t629 + 0.17395833333333333333333333333333333333333333333334e1 * t248 / t254 - 0.87962962962962962962962962962962962962962962962964e-1 * t63 * t636 + 0.83188657407407407407407407407407407407407407407412e-2 * t98 * t253 / t212 / t642
  t716 = f.my_piecewise5(t210, -0.129283200e1 * t622 * t623 + 0.64641600e0 * t470 * t661, t237, 0.90613587238844619753086419753086419753086419753082e-2 * t150 * t628 * t242 - 0.75960486545192776489482996311453705409850609776897e-5 * t366 * t636 * t242, t688 * t244 - 0.49425593039369792592592592592592592592592592592590e-2 * t513 * t34 * t32 * t518 + 0.90613587238844619753086419753086419753086419753082e-2 * t516 * t238 * t627 * t242 - 0.75960486545192776489482996311453705409850609776897e-5 * t260 * t332 * t33 * t62 * t223 * t635 * t242 - t688 * t236 + 0.129283200e1 * t521 * t470 * t490 - 0.129283200e1 * t262 * t622 * t623 + 0.64641600e0 * t523 * t661)
  t721 = f.my_piecewise3(t192, 0, -0.3e1 / 0.8e1 * t5 * t611 * t30 * t265 - t571 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t464 * t527 + t443 - t578 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t468 * t716)
  d22 = 0.2e1 * t458 + 0.2e1 * t532 + t6 * (t602 + t721)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t46 = jnp.pi ** 2
  t47 = t46 ** (0.1e1 / 0.3e1)
  t49 = t45 / t47
  t50 = jnp.sqrt(s0)
  t51 = r0 ** (0.1e1 / 0.3e1)
  t55 = t49 * t50 / t51 / r0
  t56 = t55 / 0.12e2
  t57 = t56 <= 0.6e0
  t58 = t47 ** 2
  t59 = 0.1e1 / t58
  t60 = t44 * t59
  t61 = r0 ** 2
  t62 = t51 ** 2
  t64 = 0.1e1 / t62 / t61
  t65 = s0 * t64
  t66 = t60 * t65
  t69 = jnp.exp(-t66 / 0.24e2)
  t74 = 0.1e1 / t47 / t46
  t75 = t45 * t74
  t76 = s0 ** 2
  t77 = t61 ** 2
  t78 = t77 * r0
  t82 = t75 * t76 / t51 / t78
  t84 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t82
  t85 = jnp.log(t84)
  t86 = 0.8040e0 + 0.5e1 / 0.972e3 * t66 + 0.40024242767108462448559670781893004115226337448558e-2 * t60 * t65 * t69 + t85
  t89 = 0.18040e1 - 0.64641600e0 / t86
  t90 = 0.26e1 <= t56
  t91 = t46 * t44
  t92 = t59 * s0
  t96 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t91 * t92 * t64)
  t98 = 0.18040e1 - 0.8040e0 * t96
  t99 = 0.19012500000000000000000000000000000000000000000000e0 * t55
  t100 = 0.19500000000000000000000000000000000000000000000000e0 * t66
  t101 = 0.1e1 / t46
  t103 = t101 * t50 * s0
  t106 = 0.86979166666666666666666666666666666666666666666668e-1 * t103 / t77
  t107 = 0.26041666666666666666666666666666666666666666666667e-2 * t82
  t110 = t44 / t58 / t46
  t111 = t50 * t76
  t112 = t77 * t61
  t117 = 0.16276041666666666666666666666666666666666666666667e-3 * t110 * t111 / t62 / t112
  t118 = -0.40608000000000000000000000000000000000000000000000e0 + t99 - t100 + t106 - t107 + t117
  t120 = 0.14060800000000000000000000000000000000000000000000e1 - t99 + t100 - t106 + t107 - t117
  t123 = f.my_piecewise5(t57, t89, t90, t98, t118 * t98 + t120 * t89)
  t129 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t130 = t42 ** 2
  t131 = 0.1e1 / t130
  t132 = t129 * t131
  t136 = t129 * t42
  t137 = t86 ** 2
  t138 = 0.1e1 / t137
  t139 = t61 * r0
  t141 = 0.1e1 / t62 / t139
  t142 = s0 * t141
  t143 = t60 * t142
  t150 = t76 / t51 / t112
  t154 = 0.1e1 / t84
  t158 = -0.10e2 / 0.729e3 * t143 - 0.10673131404562256652949245541838134430727023319615e-1 * t60 * t142 * t69 + 0.44471380852342736053955189757658893461362597165064e-3 * t75 * t150 * t69 - 0.73495086436683507341360564954529289234364680180832e-4 * t75 * t150 * t154
  t161 = t91 * t59
  t176 = t77 * t139
  t182 = -0.25350000000000000000000000000000000000000000000000e0 * t49 * t50 / t51 / t61 + 0.52000000000000000000000000000000000000000000000000e0 * t143 - 0.34791666666666666666666666666666666666666666666667e0 * t103 / t78 + 0.13888888888888888888888888888888888888888888888889e-1 * t75 * t150 - 0.10850694444444444444444444444444444444444444444445e-2 * t110 * t111 / t62 / t176
  t184 = t118 * t46
  t185 = t184 * t44
  t187 = t92 * t141 * t96
  t190 = -t182
  t192 = t120 * t138
  t196 = f.my_piecewise5(t57, 0.64641600e0 * t138 * t158, t90, -0.24712796519684896296296296296296296296296296296295e-2 * t161 * t142 * t96, t182 * t98 - 0.24712796519684896296296296296296296296296296296295e-2 * t185 * t187 + t190 * t89 + 0.64641600e0 * t192 * t158)
  t200 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t201 = t200 * f.p.zeta_threshold
  t203 = f.my_piecewise3(t20, t201, t21 * t19)
  t205 = 0.1e1 / t130 / t6
  t206 = t203 * t205
  t210 = t203 * t131
  t214 = t203 * t42
  t216 = 0.1e1 / t137 / t86
  t217 = t158 ** 2
  t221 = 0.1e1 / t62 / t77
  t222 = s0 * t221
  t223 = t60 * t222
  t229 = 0.1e1 / t51 / t176
  t230 = t76 * t229
  t234 = t46 ** 2
  t235 = 0.1e1 / t234
  t236 = t76 * s0
  t237 = t235 * t236
  t238 = t77 ** 2
  t249 = t44 / t58 / t234
  t250 = t76 ** 2
  t255 = t84 ** 2
  t256 = 0.1e1 / t255
  t260 = 0.110e3 / 0.2187e4 * t223 + 0.39134815150061607727480566986739826245999085505255e-1 * t60 * t222 * t69 - 0.40024242767108462448559670781893004115226337448557e-2 * t75 * t230 * t69 + 0.29647587234895157369303459838439262307575064776709e-3 * t237 / t238 / t61 * t69 + 0.46546888076566221316195024471201883181764297447860e-3 * t75 * t230 * t154 - 0.32409166382013480266174026443813232990886034424442e-7 * t249 * t250 / t62 / t238 / t77 * t256
  t268 = t234 * t45 * t74
  t289 = 0.59150000000000000000000000000000000000000000000000e0 * t49 * t50 / t51 / t139 - 0.19066666666666666666666666666666666666666666666667e1 * t223 + 0.17395833333333333333333333333333333333333333333334e1 * t103 / t112 - 0.87962962962962962962962962962962962962962962962964e-1 * t75 * t230 + 0.83188657407407407407407407407407407407407407407412e-2 * t110 * t111 / t62 / t238
  t292 = t182 * t46 * t44
  t296 = t92 * t221 * t96
  t300 = t118 * t234 * t45
  t301 = t74 * t76
  t303 = t301 * t229 * t96
  t306 = -t289
  t308 = t190 * t138
  t311 = t120 * t216
  t317 = f.my_piecewise5(t57, -0.129283200e1 * t216 * t217 + 0.64641600e0 * t138 * t260, t90, 0.90613587238844619753086419753086419753086419753082e-2 * t161 * t222 * t96 - 0.75960486545192776489482996311453705409850609776897e-5 * t268 * t230 * t96, t289 * t98 - 0.49425593039369792592592592592592592592592592592590e-2 * t292 * t187 + 0.90613587238844619753086419753086419753086419753082e-2 * t185 * t296 - 0.75960486545192776489482996311453705409850609776897e-5 * t300 * t303 + t306 * t89 + 0.129283200e1 * t308 * t158 - 0.129283200e1 * t311 * t217 + 0.64641600e0 * t192 * t260)
  t322 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t123 - t5 * t132 * t123 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t136 * t196 + t5 * t206 * t123 / 0.12e2 - t5 * t210 * t196 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t214 * t317)
  t324 = r1 <= f.p.dens_threshold
  t325 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t326 = 0.1e1 + t325
  t327 = t326 <= f.p.zeta_threshold
  t328 = t326 ** (0.1e1 / 0.3e1)
  t329 = t328 ** 2
  t330 = 0.1e1 / t329
  t332 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t333 = t332 ** 2
  t337 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t341 = f.my_piecewise3(t327, 0, 0.4e1 / 0.9e1 * t330 * t333 + 0.4e1 / 0.3e1 * t328 * t337)
  t343 = jnp.sqrt(s2)
  t344 = r1 ** (0.1e1 / 0.3e1)
  t348 = t49 * t343 / t344 / r1
  t349 = t348 / 0.12e2
  t351 = r1 ** 2
  t352 = t344 ** 2
  t354 = 0.1e1 / t352 / t351
  t355 = s2 * t354
  t356 = t60 * t355
  t359 = jnp.exp(-t356 / 0.24e2)
  t363 = s2 ** 2
  t364 = t351 ** 2
  t369 = t75 * t363 / t344 / t364 / r1
  t372 = jnp.log(0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t369)
  t376 = 0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t356 + 0.40024242767108462448559670781893004115226337448558e-2 * t60 * t355 * t359 + t372)
  t382 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t91 * t59 * s2 * t354)
  t384 = 0.18040e1 - 0.8040e0 * t382
  t385 = 0.19012500000000000000000000000000000000000000000000e0 * t348
  t386 = 0.19500000000000000000000000000000000000000000000000e0 * t356
  t391 = 0.86979166666666666666666666666666666666666666666668e-1 * t101 * t343 * s2 / t364
  t392 = 0.26041666666666666666666666666666666666666666666667e-2 * t369
  t399 = 0.16276041666666666666666666666666666666666666666667e-3 * t110 * t343 * t363 / t352 / t364 / t351
  t405 = f.my_piecewise5(t349 <= 0.6e0, t376, 0.26e1 <= t349, t384, (-0.40608000000000000000000000000000000000000000000000e0 + t385 - t386 + t391 - t392 + t399) * t384 + (0.14060800000000000000000000000000000000000000000000e1 - t385 + t386 - t391 + t392 - t399) * t376)
  t411 = f.my_piecewise3(t327, 0, 0.4e1 / 0.3e1 * t328 * t332)
  t417 = f.my_piecewise3(t327, t201, t328 * t326)
  t423 = f.my_piecewise3(t324, 0, -0.3e1 / 0.8e1 * t5 * t341 * t42 * t405 - t5 * t411 * t131 * t405 / 0.4e1 + t5 * t417 * t205 * t405 / 0.12e2)
  t433 = t24 ** 2
  t437 = 0.6e1 * t33 - 0.6e1 * t16 / t433
  t438 = f.my_piecewise5(t10, 0, t14, 0, t437)
  t442 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t438)
  t465 = 0.1e1 / t130 / t24
  t476 = t137 ** 2
  t477 = 0.1e1 / t476
  t478 = t217 * t158
  t485 = 0.1e1 / t62 / t78
  t486 = s0 * t485
  t487 = t60 * t486
  t493 = 0.1e1 / t51 / t238
  t494 = t76 * t493
  t499 = 0.1e1 / t238 / t139
  t506 = 0.1e1 / t62 / t238 / t78
  t518 = t234 ** 2
  t522 = t238 ** 2
  t530 = -0.1540e4 / 0.6561e4 * t487 - 0.18262913736695416939490931260478585581466239902452e0 * t60 * t486 * t69 + 0.33699424156997495543108266016359294822943656962859e-1 * t75 * t494 * t69 - 0.56330415746300799001676573693034598384392623075747e-2 * t237 * t499 * t69 + 0.32941763594327952632559399820488069230638960863010e-4 * t235 * t250 * t506 * t60 * t69 - 0.34134384589481895631876351278881380999960484795097e-2 * t75 * t494 * t154 + 0.61577416125825612505730650243245142682683465406440e-6 * t249 * t250 * t506 * t256 - 0.28582973815043256372349471130783456363567241139645e-10 / t518 * t250 * t76 / t522 / t139 / t255 / t84
  t562 = -0.19716666666666666666666666666666666666666666666667e1 * t49 * t50 / t51 / t77 + 0.88977777777777777777777777777777777777777777777779e1 * t487 - 0.10437500000000000000000000000000000000000000000000e2 * t103 / t176 + 0.64506172839506172839506172839506172839506172839507e0 * t75 * t494 - 0.72096836419753086419753086419753086419753086419757e-1 * t110 * t111 / t62 / t238 / r0
  t604 = t562 * t98 - 0.74138389559054688888888888888888888888888888888885e-2 * t289 * t46 * t44 * t187 + 0.27184076171653385925925925925925925925925925925924e-1 * t292 * t296 - 0.22788145963557832946844898893436111622955182933069e-4 * t182 * t234 * t45 * t303 - 0.42286340711460822551440329218106995884773662551438e-1 * t185 * t92 * t485 * t96 + 0.83556535199712054138431295942599075950835670754587e-4 * t300 * t301 * t493 * t96 - 0.14008925727817995812782892622441724068051484214068e-6 * t184 * t236 * t499 * t96 - t562 * t89 + 0.193924800e1 * t306 * t138 * t158 - 0.387849600e1 * t190 * t216 * t217 + 0.193924800e1 * t308 * t260 + 0.387849600e1 * t120 * t477 * t478 - 0.387849600e1 * t311 * t158 * t260 + 0.64641600e0 * t192 * t530
  t605 = f.my_piecewise5(t57, 0.387849600e1 * t477 * t478 - 0.387849600e1 * t216 * t158 * t260 + 0.64641600e0 * t138 * t530, t90, -0.42286340711460822551440329218106995884773662551438e-1 * t161 * t486 * t96 + 0.83556535199712054138431295942599075950835670754587e-4 * t268 * t494 * t96 - 0.14008925727817995812782892622441724068051484214068e-6 * t46 * t236 * t499 * t96, t604)
  t610 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t442 * t42 * t123 - 0.3e1 / 0.8e1 * t5 * t41 * t131 * t123 - 0.9e1 / 0.8e1 * t5 * t43 * t196 + t5 * t129 * t205 * t123 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t132 * t196 - 0.9e1 / 0.8e1 * t5 * t136 * t317 - 0.5e1 / 0.36e2 * t5 * t203 * t465 * t123 + t5 * t206 * t196 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t210 * t317 - 0.3e1 / 0.8e1 * t5 * t214 * t605)
  t620 = f.my_piecewise5(t14, 0, t10, 0, -t437)
  t624 = f.my_piecewise3(t327, 0, -0.8e1 / 0.27e2 / t329 / t326 * t333 * t332 + 0.4e1 / 0.3e1 * t330 * t332 * t337 + 0.4e1 / 0.3e1 * t328 * t620)
  t642 = f.my_piecewise3(t324, 0, -0.3e1 / 0.8e1 * t5 * t624 * t42 * t405 - 0.3e1 / 0.8e1 * t5 * t341 * t131 * t405 + t5 * t411 * t205 * t405 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t417 * t465 * t405)
  d111 = 0.3e1 * t322 + 0.3e1 * t423 + t6 * (t610 + t642)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = jnp.pi ** 2
  t59 = t58 ** (0.1e1 / 0.3e1)
  t61 = t57 / t59
  t62 = jnp.sqrt(s0)
  t63 = r0 ** (0.1e1 / 0.3e1)
  t67 = t61 * t62 / t63 / r0
  t68 = t67 / 0.12e2
  t69 = t68 <= 0.6e0
  t70 = t59 ** 2
  t71 = 0.1e1 / t70
  t72 = t56 * t71
  t73 = r0 ** 2
  t74 = t63 ** 2
  t76 = 0.1e1 / t74 / t73
  t77 = s0 * t76
  t78 = t72 * t77
  t81 = jnp.exp(-t78 / 0.24e2)
  t86 = 0.1e1 / t59 / t58
  t87 = t57 * t86
  t88 = s0 ** 2
  t89 = t73 ** 2
  t90 = t89 * r0
  t92 = 0.1e1 / t63 / t90
  t94 = t87 * t88 * t92
  t96 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t94
  t97 = jnp.log(t96)
  t98 = 0.8040e0 + 0.5e1 / 0.972e3 * t78 + 0.40024242767108462448559670781893004115226337448558e-2 * t72 * t77 * t81 + t97
  t101 = 0.18040e1 - 0.64641600e0 / t98
  t102 = 0.26e1 <= t68
  t103 = t58 * t56
  t104 = t71 * s0
  t108 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t103 * t104 * t76)
  t110 = 0.18040e1 - 0.8040e0 * t108
  t111 = 0.19012500000000000000000000000000000000000000000000e0 * t67
  t112 = 0.19500000000000000000000000000000000000000000000000e0 * t78
  t113 = 0.1e1 / t58
  t115 = t113 * t62 * s0
  t118 = 0.86979166666666666666666666666666666666666666666668e-1 * t115 / t89
  t119 = 0.26041666666666666666666666666666666666666666666667e-2 * t94
  t122 = t56 / t70 / t58
  t123 = t62 * t88
  t124 = t89 * t73
  t126 = 0.1e1 / t74 / t124
  t129 = 0.16276041666666666666666666666666666666666666666667e-3 * t122 * t123 * t126
  t130 = -0.40608000000000000000000000000000000000000000000000e0 + t111 - t112 + t118 - t119 + t129
  t132 = 0.14060800000000000000000000000000000000000000000000e1 - t111 + t112 - t118 + t119 - t129
  t135 = f.my_piecewise5(t69, t101, t102, t110, t132 * t101 + t130 * t110)
  t144 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t145 = t54 ** 2
  t146 = 0.1e1 / t145
  t147 = t144 * t146
  t151 = t144 * t54
  t152 = t98 ** 2
  t153 = 0.1e1 / t152
  t154 = t73 * r0
  t156 = 0.1e1 / t74 / t154
  t157 = s0 * t156
  t158 = t72 * t157
  t165 = t88 / t63 / t124
  t169 = 0.1e1 / t96
  t173 = -0.10e2 / 0.729e3 * t158 - 0.10673131404562256652949245541838134430727023319615e-1 * t72 * t157 * t81 + 0.44471380852342736053955189757658893461362597165064e-3 * t87 * t165 * t81 - 0.73495086436683507341360564954529289234364680180832e-4 * t87 * t165 * t169
  t176 = t103 * t71
  t191 = t89 * t154
  t197 = -0.25350000000000000000000000000000000000000000000000e0 * t61 * t62 / t63 / t73 + 0.52000000000000000000000000000000000000000000000000e0 * t158 - 0.34791666666666666666666666666666666666666666666667e0 * t115 / t90 + 0.13888888888888888888888888888888888888888888888889e-1 * t87 * t165 - 0.10850694444444444444444444444444444444444444444445e-2 * t122 * t123 / t74 / t191
  t199 = t130 * t58
  t200 = t199 * t56
  t202 = t104 * t156 * t108
  t205 = -t197
  t207 = t132 * t153
  t211 = f.my_piecewise5(t69, 0.64641600e0 * t153 * t173, t102, -0.24712796519684896296296296296296296296296296296295e-2 * t176 * t157 * t108, t197 * t110 - 0.24712796519684896296296296296296296296296296296295e-2 * t200 * t202 + t205 * t101 + 0.64641600e0 * t207 * t173)
  t217 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t219 = 0.1e1 / t145 / t6
  t220 = t217 * t219
  t224 = t217 * t146
  t228 = t217 * t54
  t230 = 0.1e1 / t152 / t98
  t231 = t173 ** 2
  t235 = 0.1e1 / t74 / t89
  t236 = s0 * t235
  t237 = t72 * t236
  t243 = 0.1e1 / t63 / t191
  t244 = t88 * t243
  t248 = t58 ** 2
  t249 = 0.1e1 / t248
  t250 = t88 * s0
  t251 = t249 * t250
  t252 = t89 ** 2
  t253 = t252 * t73
  t263 = t56 / t70 / t248
  t264 = t88 ** 2
  t265 = t252 * t89
  t269 = t96 ** 2
  t270 = 0.1e1 / t269
  t274 = 0.110e3 / 0.2187e4 * t237 + 0.39134815150061607727480566986739826245999085505255e-1 * t72 * t236 * t81 - 0.40024242767108462448559670781893004115226337448557e-2 * t87 * t244 * t81 + 0.29647587234895157369303459838439262307575064776709e-3 * t251 / t253 * t81 + 0.46546888076566221316195024471201883181764297447860e-3 * t87 * t244 * t169 - 0.32409166382013480266174026443813232990886034424442e-7 * t263 * t264 / t74 / t265 * t270
  t282 = t248 * t57 * t86
  t303 = 0.59150000000000000000000000000000000000000000000000e0 * t61 * t62 / t63 / t154 - 0.19066666666666666666666666666666666666666666666667e1 * t237 + 0.17395833333333333333333333333333333333333333333334e1 * t115 / t124 - 0.87962962962962962962962962962962962962962962962964e-1 * t87 * t244 + 0.83188657407407407407407407407407407407407407407412e-2 * t122 * t123 / t74 / t252
  t305 = t197 * t58
  t306 = t305 * t56
  t310 = t104 * t235 * t108
  t313 = t130 * t248
  t314 = t313 * t57
  t315 = t86 * t88
  t317 = t315 * t243 * t108
  t320 = -t303
  t322 = t205 * t153
  t325 = t132 * t230
  t331 = f.my_piecewise5(t69, -0.129283200e1 * t230 * t231 + 0.64641600e0 * t153 * t274, t102, 0.90613587238844619753086419753086419753086419753082e-2 * t176 * t236 * t108 - 0.75960486545192776489482996311453705409850609776897e-5 * t282 * t244 * t108, t303 * t110 - 0.49425593039369792592592592592592592592592592592590e-2 * t306 * t202 + 0.90613587238844619753086419753086419753086419753082e-2 * t200 * t310 - 0.75960486545192776489482996311453705409850609776897e-5 * t314 * t317 + t320 * t101 + 0.129283200e1 * t322 * t173 - 0.129283200e1 * t325 * t231 + 0.64641600e0 * t207 * t274)
  t335 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t336 = t335 * f.p.zeta_threshold
  t338 = f.my_piecewise3(t20, t336, t21 * t19)
  t340 = 0.1e1 / t145 / t25
  t341 = t338 * t340
  t345 = t338 * t219
  t349 = t338 * t146
  t353 = t338 * t54
  t354 = t152 ** 2
  t355 = 0.1e1 / t354
  t356 = t231 * t173
  t359 = t230 * t173
  t363 = 0.1e1 / t74 / t90
  t364 = s0 * t363
  t365 = t72 * t364
  t371 = 0.1e1 / t63 / t252
  t372 = t88 * t371
  t377 = 0.1e1 / t252 / t154
  t381 = t249 * t264
  t384 = 0.1e1 / t74 / t252 / t90
  t386 = t72 * t81
  t396 = t248 ** 2
  t397 = 0.1e1 / t396
  t399 = t397 * t264 * t88
  t400 = t252 ** 2
  t404 = 0.1e1 / t269 / t96
  t408 = -0.1540e4 / 0.6561e4 * t365 - 0.18262913736695416939490931260478585581466239902452e0 * t72 * t364 * t81 + 0.33699424156997495543108266016359294822943656962859e-1 * t87 * t372 * t81 - 0.56330415746300799001676573693034598384392623075747e-2 * t251 * t377 * t81 + 0.32941763594327952632559399820488069230638960863010e-4 * t381 * t384 * t386 - 0.34134384589481895631876351278881380999960484795097e-2 * t87 * t372 * t169 + 0.61577416125825612505730650243245142682683465406440e-6 * t263 * t264 * t384 * t270 - 0.28582973815043256372349471130783456363567241139645e-10 * t399 / t400 / t154 * t404
  t418 = t58 * t250
  t434 = t252 * r0
  t440 = -0.19716666666666666666666666666666666666666666666667e1 * t61 * t62 / t63 / t89 + 0.88977777777777777777777777777777777777777777777779e1 * t365 - 0.10437500000000000000000000000000000000000000000000e2 * t115 / t191 + 0.64506172839506172839506172839506172839506172839507e0 * t87 * t372 - 0.72096836419753086419753086419753086419753086419757e-1 * t122 * t123 / t74 / t434
  t443 = t303 * t58 * t56
  t449 = t197 * t248 * t57
  t453 = t104 * t363 * t108
  t457 = t315 * t371 * t108
  t461 = t250 * t377 * t108
  t464 = -t440
  t466 = t320 * t153
  t469 = t205 * t230
  t474 = t132 * t355
  t477 = t173 * t274
  t482 = t440 * t110 - 0.74138389559054688888888888888888888888888888888885e-2 * t443 * t202 + 0.27184076171653385925925925925925925925925925925924e-1 * t306 * t310 - 0.22788145963557832946844898893436111622955182933069e-4 * t449 * t317 - 0.42286340711460822551440329218106995884773662551438e-1 * t200 * t453 + 0.83556535199712054138431295942599075950835670754587e-4 * t314 * t457 - 0.14008925727817995812782892622441724068051484214068e-6 * t199 * t461 + t464 * t101 + 0.193924800e1 * t466 * t173 - 0.387849600e1 * t469 * t231 + 0.193924800e1 * t322 * t274 + 0.387849600e1 * t474 * t356 - 0.387849600e1 * t325 * t477 + 0.64641600e0 * t207 * t408
  t483 = f.my_piecewise5(t69, 0.387849600e1 * t355 * t356 - 0.387849600e1 * t359 * t274 + 0.64641600e0 * t153 * t408, t102, -0.42286340711460822551440329218106995884773662551438e-1 * t176 * t364 * t108 + 0.83556535199712054138431295942599075950835670754587e-4 * t282 * t372 * t108 - 0.14008925727817995812782892622441724068051484214068e-6 * t418 * t377 * t108, t482)
  t488 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t135 - 0.3e1 / 0.8e1 * t5 * t147 * t135 - 0.9e1 / 0.8e1 * t5 * t151 * t211 + t5 * t220 * t135 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t224 * t211 - 0.9e1 / 0.8e1 * t5 * t228 * t331 - 0.5e1 / 0.36e2 * t5 * t341 * t135 + t5 * t345 * t211 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t349 * t331 - 0.3e1 / 0.8e1 * t5 * t353 * t483)
  t490 = r1 <= f.p.dens_threshold
  t491 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t492 = 0.1e1 + t491
  t493 = t492 <= f.p.zeta_threshold
  t494 = t492 ** (0.1e1 / 0.3e1)
  t495 = t494 ** 2
  t497 = 0.1e1 / t495 / t492
  t499 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t500 = t499 ** 2
  t504 = 0.1e1 / t495
  t505 = t504 * t499
  t507 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t511 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t515 = f.my_piecewise3(t493, 0, -0.8e1 / 0.27e2 * t497 * t500 * t499 + 0.4e1 / 0.3e1 * t505 * t507 + 0.4e1 / 0.3e1 * t494 * t511)
  t517 = jnp.sqrt(s2)
  t518 = r1 ** (0.1e1 / 0.3e1)
  t522 = t61 * t517 / t518 / r1
  t523 = t522 / 0.12e2
  t525 = r1 ** 2
  t526 = t518 ** 2
  t528 = 0.1e1 / t526 / t525
  t529 = s2 * t528
  t530 = t72 * t529
  t533 = jnp.exp(-t530 / 0.24e2)
  t537 = s2 ** 2
  t538 = t525 ** 2
  t543 = t87 * t537 / t518 / t538 / r1
  t546 = jnp.log(0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t543)
  t550 = 0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t530 + 0.40024242767108462448559670781893004115226337448558e-2 * t72 * t529 * t533 + t546)
  t556 = jnp.exp(-0.11526490914032134466556108347153123272526257600884e-2 * t103 * t71 * s2 * t528)
  t558 = 0.18040e1 - 0.8040e0 * t556
  t559 = 0.19012500000000000000000000000000000000000000000000e0 * t522
  t560 = 0.19500000000000000000000000000000000000000000000000e0 * t530
  t565 = 0.86979166666666666666666666666666666666666666666668e-1 * t113 * t517 * s2 / t538
  t566 = 0.26041666666666666666666666666666666666666666666667e-2 * t543
  t573 = 0.16276041666666666666666666666666666666666666666667e-3 * t122 * t517 * t537 / t526 / t538 / t525
  t579 = f.my_piecewise5(t523 <= 0.6e0, t550, 0.26e1 <= t523, t558, (-0.40608000000000000000000000000000000000000000000000e0 + t559 - t560 + t565 - t566 + t573) * t558 + (0.14060800000000000000000000000000000000000000000000e1 - t559 + t560 - t565 + t566 - t573) * t550)
  t588 = f.my_piecewise3(t493, 0, 0.4e1 / 0.9e1 * t504 * t500 + 0.4e1 / 0.3e1 * t494 * t507)
  t595 = f.my_piecewise3(t493, 0, 0.4e1 / 0.3e1 * t494 * t499)
  t601 = f.my_piecewise3(t493, t336, t494 * t492)
  t607 = f.my_piecewise3(t490, 0, -0.3e1 / 0.8e1 * t5 * t515 * t54 * t579 - 0.3e1 / 0.8e1 * t5 * t588 * t146 * t579 + t5 * t595 * t219 * t579 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t601 * t340 * t579)
  t610 = 0.1e1 / t354 / t98
  t611 = t231 ** 2
  t617 = t274 ** 2
  t622 = s0 * t126
  t623 = t72 * t622
  t629 = 0.1e1 / t63 / t434
  t630 = t88 * t629
  t634 = 0.1e1 / t265
  t640 = 0.1e1 / t74 / t252 / t124
  t665 = t264 ** 2
  t671 = t269 ** 2
  t677 = 0.26180e5 / 0.19683e5 * t623 + 0.10348984450794069599044861047604531829497535944723e1 * t72 * t622 * t81 - 0.30112066101575181501422547375908144083727074124877e0 * t87 * t630 * t81 + 0.84429740092262542597249741739910921438127656691895e-1 * t251 * t634 * t81 - 0.10760976107480464526636070608026102615342060548583e-2 * t381 * t640 * t386 + 0.36601959549253280702843777578320076922932178736678e-5 * t249 * t264 * s0 / t63 / t400 / r0 * t87 * t81 + 0.28445320491234913026563626065734484166633737329247e-1 * t87 * t630 * t169 - 0.99208059313830153481454936503006063210990027599264e-5 * t263 * t264 * t640 * t270 + 0.10861530049716437421492799029697713418155551633065e-8 * t399 / t400 / t89 * t404 - 0.63021243934621964298156931253183868460287090995824e-14 * t397 * t665 / t63 / t400 / t434 / t671 * t57 * t86
  t724 = -0.56035702911271983251131570489766896272205936856273e-6 * t305 * t461 + 0.30819636601199590788122363769371792949713265270950e-5 * t199 * t250 * t634 * t108 + 0.54368152343306771851851851851851851851851851851849e-1 * t443 * t310 - 0.16914536284584329020576131687242798353909465020575e0 * t306 * t453 + 0.64641600e0 * t207 * t677 + 0.258566400e1 * t322 * t408 - 0.1551398400e2 * t132 * t610 * t611 + 0.2327097600e2 * t474 * t231 * t274 - 0.387849600e1 * t325 * t617 - 0.517132800e1 * t325 * t173 * t408 + 0.1551398400e2 * t205 * t355 * t356
  t764 = -0.85438888888888888888888888888888888888888888888890e1 * t61 * t62 * t92 + 0.50420740740740740740740740740740740740740740740741e2 * t623 - 0.73062500000000000000000000000000000000000000000000e2 * t115 / t252 + 0.53755144032921810699588477366255144032921810699589e1 * t87 * t630 - 0.69693608539094650205761316872427983539094650205765e0 * t122 * t123 / t74 / t253
  t777 = -0.1551398400e2 * t469 * t477 - 0.775699200e1 * t320 * t230 * t231 - 0.82628129253048586870226503765459086218048607746202e-3 * t314 * t315 * t629 * t108 - 0.43059668031212036036538568010595709150284919297781e-9 * t313 * t264 * t640 * t56 * t71 * t108 - 0.98851186078739585185185185185185185185185185185180e-2 * t440 * t58 * t56 * t202 - 0.45576291927115665893689797786872223245910365866138e-4 * t303 * t248 * t57 * t317 + 0.33422614079884821655372518377039630380334268301835e-3 * t449 * t457 + t764 * t101 - t764 * t110 + 0.387849600e1 * t466 * t274 + 0.258566400e1 * t464 * t153 * t173 + 0.23962259736494466112482853223593964334705075445815e0 * t200 * t104 * t126 * t108
  t779 = f.my_piecewise5(t69, -0.1551398400e2 * t610 * t611 + 0.2327097600e2 * t355 * t231 * t274 - 0.387849600e1 * t230 * t617 - 0.517132800e1 * t359 * t408 + 0.64641600e0 * t153 * t677, t102, 0.23962259736494466112482853223593964334705075445815e0 * t176 * t622 * t108 - 0.82628129253048586870226503765459086218048607746202e-3 * t282 * t630 * t108 + 0.30819636601199590788122363769371792949713265270950e-5 * t418 * t634 * t108 - 0.43059668031212036036538568010595709150284919297781e-9 * t248 * t264 * t640 * t72 * t108, t724 + t777)
  t806 = t19 ** 2
  t809 = t30 ** 2
  t815 = t41 ** 2
  t824 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t825 = f.my_piecewise5(t10, 0, t14, 0, t824)
  t829 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t806 * t809 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t815 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t825)
  t842 = 0.1e1 / t145 / t36
  t855 = -0.3e1 / 0.8e1 * t5 * t353 * t779 - t5 * t349 * t483 / 0.2e1 + t5 * t345 * t331 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t341 * t211 - 0.3e1 / 0.2e1 * t5 * t228 * t483 + t5 * t220 * t211 - 0.3e1 / 0.2e1 * t5 * t224 * t331 - 0.3e1 / 0.2e1 * t5 * t147 * t211 - 0.9e1 / 0.4e1 * t5 * t151 * t331 - 0.3e1 / 0.8e1 * t5 * t829 * t54 * t135 - 0.3e1 / 0.2e1 * t5 * t55 * t211 - 0.5e1 / 0.9e1 * t5 * t217 * t340 * t135 + 0.10e2 / 0.27e2 * t5 * t338 * t842 * t135 - t5 * t53 * t146 * t135 / 0.2e1 + t5 * t144 * t219 * t135 / 0.2e1
  t856 = f.my_piecewise3(t1, 0, t855)
  t857 = t492 ** 2
  t860 = t500 ** 2
  t866 = t507 ** 2
  t872 = f.my_piecewise5(t14, 0, t10, 0, -t824)
  t876 = f.my_piecewise3(t493, 0, 0.40e2 / 0.81e2 / t495 / t857 * t860 - 0.16e2 / 0.9e1 * t497 * t500 * t507 + 0.4e1 / 0.3e1 * t504 * t866 + 0.16e2 / 0.9e1 * t505 * t511 + 0.4e1 / 0.3e1 * t494 * t872)
  t898 = f.my_piecewise3(t490, 0, -0.3e1 / 0.8e1 * t5 * t876 * t54 * t579 - t5 * t515 * t146 * t579 / 0.2e1 + t5 * t588 * t219 * t579 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t595 * t340 * t579 + 0.10e2 / 0.27e2 * t5 * t601 * t842 * t579)
  d1111 = 0.4e1 * t488 + 0.4e1 * t607 + t6 * (t856 + t898)

  res = {'v4rho4': d1111}
  return res
