"""Generated from gga_x_ityh.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import scipy.special as sp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_attenuation = lambda a: attenuation_erf(a)

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_attenuation = lambda a: attenuation_erf(a)

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_attenuation = lambda a: attenuation_erf(a)

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = t2 ** 2
  t29 = jnp.pi * t28
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t32 * t33
  t35 = t28 * t32
  t36 = t35 * t33
  t37 = r0 ** 2
  t38 = r0 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t41 = 0.1e1 / t39 / t37
  t42 = s0 * t41
  t43 = jnp.sqrt(s0)
  t45 = 0.1e1 / t38 / r0
  t46 = t43 * t45
  t47 = jnp.arcsinh(t46)
  t50 = 0.1e1 + 0.2520e-1 * t46 * t47
  t51 = 0.1e1 / t50
  t55 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t42 * t51
  t58 = t29 * t34 / t55
  t59 = jnp.sqrt(t58)
  t61 = f.p.cam_omega / t59
  t62 = 2 ** (0.1e1 / 0.3e1)
  t63 = t19 * t6
  t64 = t63 ** (0.1e1 / 0.3e1)
  t66 = t62 / t64
  t68 = t61 * t66 / 0.2e1
  t69 = 0.135e1 <= t68
  t70 = 0.135e1 < t68
  t71 = f.my_piecewise3(t70, t68, 0.135e1)
  t72 = t71 ** 2
  t75 = t72 ** 2
  t78 = t75 * t72
  t81 = t75 ** 2
  t93 = t81 ** 2
  t97 = f.my_piecewise3(t70, 0.135e1, t68)
  t98 = jnp.sqrt(jnp.pi)
  t99 = 0.1e1 / t97
  t101 = jax.lax.erf(t99 / 0.2e1)
  t103 = t97 ** 2
  t104 = 0.1e1 / t103
  t106 = jnp.exp(-t104 / 0.4e1)
  t107 = t106 - 0.1e1
  t110 = t106 - 0.3e1 / 0.2e1 - 0.2e1 * t103 * t107
  t113 = t98 * t101 + 0.2e1 * t97 * t110
  t117 = f.my_piecewise3(t69, 0.1e1 / t72 / 0.36e2 - 0.1e1 / t75 / 0.960e3 + 0.1e1 / t78 / 0.26880e5 - 0.1e1 / t81 / 0.829440e6 + 0.1e1 / t81 / t72 / 0.28385280e8 - 0.1e1 / t81 / t75 / 0.1073479680e10 + 0.1e1 / t81 / t78 / 0.44590694400e11 - 0.1e1 / t93 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t97 * t113)
  t118 = t27 * t117
  t119 = t118 * t55
  t122 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t119)
  t123 = r1 <= f.p.dens_threshold
  t124 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t125 = 0.1e1 + t124
  t126 = t125 <= f.p.zeta_threshold
  t127 = t125 ** (0.1e1 / 0.3e1)
  t129 = f.my_piecewise3(t126, t22, t127 * t125)
  t130 = t5 * t129
  t131 = r1 ** 2
  t132 = r1 ** (0.1e1 / 0.3e1)
  t133 = t132 ** 2
  t135 = 0.1e1 / t133 / t131
  t136 = s2 * t135
  t137 = jnp.sqrt(s2)
  t139 = 0.1e1 / t132 / r1
  t140 = t137 * t139
  t141 = jnp.arcsinh(t140)
  t144 = 0.1e1 + 0.2520e-1 * t140 * t141
  t145 = 0.1e1 / t144
  t149 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t136 * t145
  t152 = t29 * t34 / t149
  t153 = jnp.sqrt(t152)
  t155 = f.p.cam_omega / t153
  t156 = t125 * t6
  t157 = t156 ** (0.1e1 / 0.3e1)
  t159 = t62 / t157
  t161 = t155 * t159 / 0.2e1
  t162 = 0.135e1 <= t161
  t163 = 0.135e1 < t161
  t164 = f.my_piecewise3(t163, t161, 0.135e1)
  t165 = t164 ** 2
  t168 = t165 ** 2
  t171 = t168 * t165
  t174 = t168 ** 2
  t186 = t174 ** 2
  t190 = f.my_piecewise3(t163, 0.135e1, t161)
  t191 = 0.1e1 / t190
  t193 = jax.lax.erf(t191 / 0.2e1)
  t195 = t190 ** 2
  t196 = 0.1e1 / t195
  t198 = jnp.exp(-t196 / 0.4e1)
  t199 = t198 - 0.1e1
  t202 = t198 - 0.3e1 / 0.2e1 - 0.2e1 * t195 * t199
  t205 = 0.2e1 * t190 * t202 + t98 * t193
  t209 = f.my_piecewise3(t162, 0.1e1 / t165 / 0.36e2 - 0.1e1 / t168 / 0.960e3 + 0.1e1 / t171 / 0.26880e5 - 0.1e1 / t174 / 0.829440e6 + 0.1e1 / t174 / t165 / 0.28385280e8 - 0.1e1 / t174 / t168 / 0.1073479680e10 + 0.1e1 / t174 / t171 / 0.44590694400e11 - 0.1e1 / t186 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t190 * t205)
  t210 = t27 * t209
  t211 = t210 * t149
  t214 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t130 * t211)
  t215 = t6 ** 2
  t217 = t16 / t215
  t218 = t7 - t217
  t219 = f.my_piecewise5(t10, 0, t14, 0, t218)
  t222 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t219)
  t226 = t27 ** 2
  t227 = 0.1e1 / t226
  t231 = t26 * t227 * t117 * t55 / 0.8e1
  t232 = t72 * t71
  t233 = 0.1e1 / t232
  t238 = f.p.cam_omega / t59 / t58 * t66 * jnp.pi
  t239 = t55 ** 2
  t241 = t33 / t239
  t245 = s0 / t39 / t37 / r0
  t249 = t50 ** 2
  t250 = 0.1e1 / t249
  t257 = jnp.sqrt(0.1e1 + t42)
  t258 = 0.1e1 / t257
  t266 = -0.24888888888888888888888888888888888888888888888889e-2 * t36 * t245 * t51 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t42 * t250 * (-0.33600000000000000000000000000000000000000000000000e-1 * t43 / t38 / t37 * t47 - 0.33600000000000000000000000000000000000000000000000e-1 * t245 * t258)
  t273 = t62 / t64 / t63
  t279 = t238 * t35 * t241 * t266 / 0.4e1 - t61 * t273 * (t219 * t6 + t18 + 0.1e1) / 0.6e1
  t280 = f.my_piecewise3(t70, t279, 0)
  t283 = t75 * t71
  t284 = 0.1e1 / t283
  t287 = t75 * t232
  t288 = 0.1e1 / t287
  t292 = 0.1e1 / t81 / t71
  t296 = 0.1e1 / t81 / t232
  t300 = 0.1e1 / t81 / t283
  t304 = 0.1e1 / t81 / t287
  t308 = 0.1e1 / t93 / t71
  t312 = f.my_piecewise3(t70, 0, t279)
  t314 = t106 * t104
  t319 = 0.1e1 / t103 / t97
  t323 = t97 * t107
  t335 = f.my_piecewise3(t69, -t233 * t280 / 0.18e2 + t284 * t280 / 0.240e3 - t288 * t280 / 0.4480e4 + t292 * t280 / 0.103680e6 - t296 * t280 / 0.2838528e7 + t300 * t280 / 0.89456640e8 - t304 * t280 / 0.3185049600e10 + t308 * t280 / 0.126340300800e12, -0.8e1 / 0.3e1 * t312 * t113 - 0.8e1 / 0.3e1 * t97 * (-t314 * t312 + 0.2e1 * t312 * t110 + 0.2e1 * t97 * (t319 * t312 * t106 / 0.2e1 - 0.4e1 * t323 * t312 - t99 * t312 * t106)))
  t344 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t222 * t119 - t231 - 0.3e1 / 0.8e1 * t26 * t27 * t335 * t55 - 0.3e1 / 0.8e1 * t26 * t118 * t266)
  t346 = f.my_piecewise5(t14, 0, t10, 0, -t218)
  t349 = f.my_piecewise3(t126, 0, 0.4e1 / 0.3e1 * t127 * t346)
  t356 = t130 * t227 * t209 * t149 / 0.8e1
  t357 = t165 * t164
  t358 = 0.1e1 / t357
  t361 = t62 / t157 / t156
  t366 = t155 * t361 * (t346 * t6 + t124 + 0.1e1) / 0.6e1
  t367 = f.my_piecewise3(t163, -t366, 0)
  t370 = t168 * t164
  t371 = 0.1e1 / t370
  t374 = t168 * t357
  t375 = 0.1e1 / t374
  t379 = 0.1e1 / t174 / t164
  t383 = 0.1e1 / t174 / t357
  t387 = 0.1e1 / t174 / t370
  t391 = 0.1e1 / t174 / t374
  t395 = 0.1e1 / t186 / t164
  t399 = f.my_piecewise3(t163, 0, -t366)
  t401 = t198 * t196
  t406 = 0.1e1 / t195 / t190
  t410 = t190 * t199
  t422 = f.my_piecewise3(t162, -t358 * t367 / 0.18e2 + t371 * t367 / 0.240e3 - t375 * t367 / 0.4480e4 + t379 * t367 / 0.103680e6 - t383 * t367 / 0.2838528e7 + t387 * t367 / 0.89456640e8 - t391 * t367 / 0.3185049600e10 + t395 * t367 / 0.126340300800e12, -0.8e1 / 0.3e1 * t399 * t205 - 0.8e1 / 0.3e1 * t190 * (-t401 * t399 + 0.2e1 * t399 * t202 + 0.2e1 * t190 * (t406 * t399 * t198 / 0.2e1 - 0.4e1 * t410 * t399 - t191 * t399 * t198)))
  t428 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t5 * t349 * t211 - t356 - 0.3e1 / 0.8e1 * t130 * t27 * t422 * t149)
  vrho_0_ = t122 + t214 + t6 * (t344 + t428)
  t431 = -t7 - t217
  t432 = f.my_piecewise5(t10, 0, t14, 0, t431)
  t435 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t432)
  t443 = t61 * t273 * (t432 * t6 + t18 + 0.1e1) / 0.6e1
  t444 = f.my_piecewise3(t70, -t443, 0)
  t462 = f.my_piecewise3(t70, 0, -t443)
  t481 = f.my_piecewise3(t69, -t233 * t444 / 0.18e2 + t284 * t444 / 0.240e3 - t288 * t444 / 0.4480e4 + t292 * t444 / 0.103680e6 - t296 * t444 / 0.2838528e7 + t300 * t444 / 0.89456640e8 - t304 * t444 / 0.3185049600e10 + t308 * t444 / 0.126340300800e12, -0.8e1 / 0.3e1 * t462 * t113 - 0.8e1 / 0.3e1 * t97 * (-t314 * t462 + 0.2e1 * t462 * t110 + 0.2e1 * t97 * (t319 * t462 * t106 / 0.2e1 - 0.4e1 * t323 * t462 - t99 * t462 * t106)))
  t487 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t435 * t119 - t231 - 0.3e1 / 0.8e1 * t26 * t27 * t481 * t55)
  t489 = f.my_piecewise5(t14, 0, t10, 0, -t431)
  t492 = f.my_piecewise3(t126, 0, 0.4e1 / 0.3e1 * t127 * t489)
  t500 = f.p.cam_omega / t153 / t152 * t159 * jnp.pi
  t501 = t149 ** 2
  t503 = t33 / t501
  t507 = s2 / t133 / t131 / r1
  t511 = t144 ** 2
  t512 = 0.1e1 / t511
  t519 = jnp.sqrt(0.1e1 + t136)
  t520 = 0.1e1 / t519
  t528 = -0.24888888888888888888888888888888888888888888888889e-2 * t36 * t507 * t145 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t136 * t512 * (-0.33600000000000000000000000000000000000000000000000e-1 * t137 / t132 / t131 * t141 - 0.33600000000000000000000000000000000000000000000000e-1 * t507 * t520)
  t538 = t500 * t35 * t503 * t528 / 0.4e1 - t155 * t361 * (t489 * t6 + t124 + 0.1e1) / 0.6e1
  t539 = f.my_piecewise3(t163, t538, 0)
  t557 = f.my_piecewise3(t163, 0, t538)
  t576 = f.my_piecewise3(t162, -t358 * t539 / 0.18e2 + t371 * t539 / 0.240e3 - t375 * t539 / 0.4480e4 + t379 * t539 / 0.103680e6 - t383 * t539 / 0.2838528e7 + t387 * t539 / 0.89456640e8 - t391 * t539 / 0.3185049600e10 + t395 * t539 / 0.126340300800e12, -0.8e1 / 0.3e1 * t557 * t205 - 0.8e1 / 0.3e1 * t190 * (-t401 * t557 + 0.2e1 * t557 * t202 + 0.2e1 * t190 * (t406 * t557 * t198 / 0.2e1 - 0.4e1 * t410 * t557 - t191 * t557 * t198)))
  t585 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t5 * t492 * t211 - t356 - 0.3e1 / 0.8e1 * t130 * t27 * t576 * t149 - 0.3e1 / 0.8e1 * t130 * t210 * t528)
  vrho_1_ = t122 + t214 + t6 * (t487 + t585)
  t603 = 0.93333333333333333333333333333333333333333333333333e-3 * t35 * t33 * t41 * t51 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t42 * t250 * (0.12600000000000000000000000000000000000000000000000e-1 / t43 * t45 * t47 + 0.12600000000000000000000000000000000000000000000000e-1 * t41 * t258)
  t607 = t238 * t35 * t241 * t603 / 0.4e1
  t608 = f.my_piecewise3(t70, t607, 0)
  t626 = f.my_piecewise3(t70, 0, t607)
  t645 = f.my_piecewise3(t69, -t233 * t608 / 0.18e2 + t284 * t608 / 0.240e3 - t288 * t608 / 0.4480e4 + t292 * t608 / 0.103680e6 - t296 * t608 / 0.2838528e7 + t300 * t608 / 0.89456640e8 - t304 * t608 / 0.3185049600e10 + t308 * t608 / 0.126340300800e12, -0.8e1 / 0.3e1 * t626 * t113 - 0.8e1 / 0.3e1 * t97 * (-t314 * t626 + 0.2e1 * t626 * t110 + 0.2e1 * t97 * (t319 * t626 * t106 / 0.2e1 - 0.4e1 * t323 * t626 - t99 * t626 * t106)))
  t653 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t27 * t645 * t55 - 0.3e1 / 0.8e1 * t26 * t118 * t603)
  vsigma_0_ = t6 * t653
  vsigma_1_ = 0.0e0
  t669 = 0.93333333333333333333333333333333333333333333333333e-3 * t35 * t33 * t135 * t145 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t136 * t512 * (0.12600000000000000000000000000000000000000000000000e-1 / t137 * t139 * t141 + 0.12600000000000000000000000000000000000000000000000e-1 * t135 * t520)
  t673 = t500 * t35 * t503 * t669 / 0.4e1
  t674 = f.my_piecewise3(t163, t673, 0)
  t692 = f.my_piecewise3(t163, 0, t673)
  t711 = f.my_piecewise3(t162, -t358 * t674 / 0.18e2 + t371 * t674 / 0.240e3 - t375 * t674 / 0.4480e4 + t379 * t674 / 0.103680e6 - t383 * t674 / 0.2838528e7 + t387 * t674 / 0.89456640e8 - t391 * t674 / 0.3185049600e10 + t395 * t674 / 0.126340300800e12, -0.8e1 / 0.3e1 * t692 * t205 - 0.8e1 / 0.3e1 * t190 * (-t401 * t692 + 0.2e1 * t692 * t202 + 0.2e1 * t190 * (t406 * t692 * t198 / 0.2e1 - 0.4e1 * t410 * t692 - t191 * t692 * t198)))
  t719 = f.my_piecewise3(t123, 0, -0.3e1 / 0.8e1 * t130 * t27 * t711 * t149 - 0.3e1 / 0.8e1 * t130 * t210 * t669)
  vsigma_2_ = t6 * t719
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_attenuation = lambda a: attenuation_erf(a)

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t3 ** 2
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t23
  t25 = 4 ** (0.1e1 / 0.3e1)
  t27 = t20 * t24
  t28 = t27 * t25
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t33 = t19 ** 2
  t35 = 0.1e1 / t33 / t32
  t36 = jnp.sqrt(s0)
  t37 = t36 * t29
  t39 = 0.1e1 / t19 / r0
  t41 = jnp.arcsinh(t37 * t39)
  t42 = t39 * t41
  t45 = 0.1e1 + 0.2520e-1 * t37 * t42
  t46 = 0.1e1 / t45
  t51 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t28 * t31 * t35 * t46
  t54 = jnp.pi * t20 * t24 * t25 / t51
  t55 = jnp.sqrt(t54)
  t57 = f.p.cam_omega / t55
  t58 = t11 * r0
  t59 = t58 ** (0.1e1 / 0.3e1)
  t61 = t29 / t59
  t63 = t57 * t61 / 0.2e1
  t64 = 0.135e1 <= t63
  t65 = 0.135e1 < t63
  t66 = f.my_piecewise3(t65, t63, 0.135e1)
  t67 = t66 ** 2
  t70 = t67 ** 2
  t73 = t70 * t67
  t76 = t70 ** 2
  t88 = t76 ** 2
  t92 = f.my_piecewise3(t65, 0.135e1, t63)
  t93 = jnp.sqrt(jnp.pi)
  t94 = 0.1e1 / t92
  t96 = jax.lax.erf(t94 / 0.2e1)
  t98 = t92 ** 2
  t99 = 0.1e1 / t98
  t101 = jnp.exp(-t99 / 0.4e1)
  t102 = t101 - 0.1e1
  t105 = t101 - 0.3e1 / 0.2e1 - 0.2e1 * t98 * t102
  t108 = 0.2e1 * t92 * t105 + t93 * t96
  t112 = f.my_piecewise3(t64, 0.1e1 / t67 / 0.36e2 - 0.1e1 / t70 / 0.960e3 + 0.1e1 / t73 / 0.26880e5 - 0.1e1 / t76 / 0.829440e6 + 0.1e1 / t76 / t67 / 0.28385280e8 - 0.1e1 / t76 / t70 / 0.1073479680e10 + 0.1e1 / t76 / t73 / 0.44590694400e11 - 0.1e1 / t88 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t92 * t108)
  t113 = t19 * t112
  t117 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t113 * t51)
  t123 = t67 * t66
  t124 = 0.1e1 / t123
  t129 = f.p.cam_omega / t55 / t54 * t61 * jnp.pi
  t130 = t51 ** 2
  t132 = t25 / t130
  t135 = 0.1e1 / t33 / t32 / r0
  t141 = t27 * t25 * s0
  t142 = t30 * t35
  t143 = t45 ** 2
  t144 = 0.1e1 / t143
  t152 = jnp.sqrt(t31 * t35 + 0.1e1)
  t153 = 0.1e1 / t152
  t162 = -0.24888888888888888888888888888888888888888888888889e-2 * t28 * t31 * t135 * t46 - 0.93333333333333333333333333333333333333333333333333e-3 * t141 * t142 * t144 * (-0.33600000000000000000000000000000000000000000000000e-1 * t37 / t19 / t32 * t41 - 0.33600000000000000000000000000000000000000000000000e-1 * t31 * t135 * t153)
  t173 = t129 * t27 * t132 * t162 / 0.4e1 - t57 * t29 / t59 / t58 * t11 / 0.6e1
  t174 = f.my_piecewise3(t65, t173, 0)
  t177 = t70 * t66
  t178 = 0.1e1 / t177
  t181 = t70 * t123
  t182 = 0.1e1 / t181
  t186 = 0.1e1 / t76 / t66
  t190 = 0.1e1 / t76 / t123
  t194 = 0.1e1 / t76 / t177
  t198 = 0.1e1 / t76 / t181
  t202 = 0.1e1 / t88 / t66
  t206 = f.my_piecewise3(t65, 0, t173)
  t208 = t101 * t99
  t213 = 0.1e1 / t98 / t92
  t217 = t92 * t102
  t229 = f.my_piecewise3(t64, -t124 * t174 / 0.18e2 + t178 * t174 / 0.240e3 - t182 * t174 / 0.4480e4 + t186 * t174 / 0.103680e6 - t190 * t174 / 0.2838528e7 + t194 * t174 / 0.89456640e8 - t198 * t174 / 0.3185049600e10 + t202 * t174 / 0.126340300800e12, -0.8e1 / 0.3e1 * t206 * t108 - 0.8e1 / 0.3e1 * t92 * (-t208 * t206 + 0.2e1 * t206 * t105 + 0.2e1 * t92 * (t213 * t206 * t101 / 0.2e1 - 0.4e1 * t217 * t206 - t94 * t206 * t101)))
  t238 = f.my_piecewise3(t2, 0, -t18 / t33 * t112 * t51 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t229 * t51 - 0.3e1 / 0.8e1 * t18 * t113 * t162)
  vrho_0_ = 0.2e1 * r0 * t238 + 0.2e1 * t117
  t255 = 0.93333333333333333333333333333333333333333333333333e-3 * t28 * t142 * t46 - 0.93333333333333333333333333333333333333333333333333e-3 * t141 * t142 * t144 * (0.12600000000000000000000000000000000000000000000000e-1 / t36 * t29 * t42 + 0.12600000000000000000000000000000000000000000000000e-1 * t142 * t153)
  t259 = t129 * t27 * t132 * t255 / 0.4e1
  t260 = f.my_piecewise3(t65, t259, 0)
  t278 = f.my_piecewise3(t65, 0, t259)
  t297 = f.my_piecewise3(t64, -t124 * t260 / 0.18e2 + t178 * t260 / 0.240e3 - t182 * t260 / 0.4480e4 + t186 * t260 / 0.103680e6 - t190 * t260 / 0.2838528e7 + t194 * t260 / 0.89456640e8 - t198 * t260 / 0.3185049600e10 + t202 * t260 / 0.126340300800e12, -0.8e1 / 0.3e1 * t278 * t108 - 0.8e1 / 0.3e1 * t92 * (-t208 * t278 + 0.2e1 * t278 * t105 + 0.2e1 * t92 * (t213 * t278 * t101 / 0.2e1 - 0.4e1 * t217 * t278 - t94 * t278 * t101)))
  t305 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t297 * t51 - 0.3e1 / 0.8e1 * t18 * t113 * t255)
  vsigma_0_ = 0.2e1 * r0 * t305
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = t3 ** 2
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = 4 ** (0.1e1 / 0.3e1)
  t29 = t22 * t26
  t30 = t29 * t27
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = s0 * t32
  t34 = r0 ** 2
  t36 = 0.1e1 / t20 / t34
  t37 = jnp.sqrt(s0)
  t38 = t37 * t31
  t40 = 0.1e1 / t19 / r0
  t42 = jnp.arcsinh(t38 * t40)
  t43 = t40 * t42
  t46 = 0.1e1 + 0.2520e-1 * t38 * t43
  t47 = 0.1e1 / t46
  t52 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t30 * t33 * t36 * t47
  t55 = jnp.pi * t22 * t26 * t27 / t52
  t56 = jnp.sqrt(t55)
  t58 = f.p.cam_omega / t56
  t59 = t11 * r0
  t60 = t59 ** (0.1e1 / 0.3e1)
  t62 = t31 / t60
  t64 = t58 * t62 / 0.2e1
  t65 = 0.135e1 <= t64
  t66 = 0.135e1 < t64
  t67 = f.my_piecewise3(t66, t64, 0.135e1)
  t68 = t67 ** 2
  t71 = t68 ** 2
  t72 = 0.1e1 / t71
  t74 = t71 * t68
  t75 = 0.1e1 / t74
  t77 = t71 ** 2
  t78 = 0.1e1 / t77
  t81 = 0.1e1 / t77 / t68
  t84 = 0.1e1 / t77 / t71
  t87 = 0.1e1 / t77 / t74
  t89 = t77 ** 2
  t90 = 0.1e1 / t89
  t93 = f.my_piecewise3(t66, 0.135e1, t64)
  t94 = jnp.sqrt(jnp.pi)
  t95 = 0.1e1 / t93
  t97 = jax.lax.erf(t95 / 0.2e1)
  t99 = t93 ** 2
  t100 = 0.1e1 / t99
  t102 = jnp.exp(-t100 / 0.4e1)
  t103 = t102 - 0.1e1
  t106 = t102 - 0.3e1 / 0.2e1 - 0.2e1 * t99 * t103
  t109 = 0.2e1 * t93 * t106 + t94 * t97
  t113 = f.my_piecewise3(t65, 0.1e1 / t68 / 0.36e2 - t72 / 0.960e3 + t75 / 0.26880e5 - t78 / 0.829440e6 + t81 / 0.28385280e8 - t84 / 0.1073479680e10 + t87 / 0.44590694400e11 - t90 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t93 * t109)
  t114 = t21 * t113
  t118 = t68 * t67
  t119 = 0.1e1 / t118
  t122 = f.p.cam_omega / t56 / t55
  t124 = t122 * t62 * jnp.pi
  t125 = t52 ** 2
  t126 = 0.1e1 / t125
  t127 = t27 * t126
  t128 = t34 * r0
  t130 = 0.1e1 / t20 / t128
  t136 = t29 * t27 * s0
  t137 = t32 * t36
  t138 = t46 ** 2
  t139 = 0.1e1 / t138
  t142 = 0.1e1 / t19 / t34 * t42
  t146 = t33 * t36 + 0.1e1
  t147 = jnp.sqrt(t146)
  t148 = 0.1e1 / t147
  t152 = -0.33600000000000000000000000000000000000000000000000e-1 * t38 * t142 - 0.33600000000000000000000000000000000000000000000000e-1 * t33 * t130 * t148
  t153 = t139 * t152
  t154 = t137 * t153
  t157 = -0.24888888888888888888888888888888888888888888888889e-2 * t30 * t33 * t130 * t47 - 0.93333333333333333333333333333333333333333333333332e-3 * t136 * t154
  t164 = t31 / t60 / t59
  t168 = t124 * t29 * t127 * t157 / 0.4e1 - t58 * t164 * t11 / 0.6e1
  t169 = f.my_piecewise3(t66, t168, 0)
  t172 = t71 * t67
  t173 = 0.1e1 / t172
  t176 = t71 * t118
  t177 = 0.1e1 / t176
  t181 = 0.1e1 / t77 / t67
  t185 = 0.1e1 / t77 / t118
  t189 = 0.1e1 / t77 / t172
  t193 = 0.1e1 / t77 / t176
  t197 = 0.1e1 / t89 / t67
  t201 = f.my_piecewise3(t66, 0, t168)
  t203 = t102 * t100
  t208 = 0.1e1 / t99 / t93
  t212 = t93 * t103
  t217 = t208 * t201 * t102 / 0.2e1 - 0.4e1 * t212 * t201 - t95 * t201 * t102
  t220 = 0.2e1 * t201 * t106 - t203 * t201 + 0.2e1 * t93 * t217
  t224 = f.my_piecewise3(t65, -t119 * t169 / 0.18e2 + t173 * t169 / 0.240e3 - t177 * t169 / 0.4480e4 + t181 * t169 / 0.103680e6 - t185 * t169 / 0.2838528e7 + t189 * t169 / 0.89456640e8 - t193 * t169 / 0.3185049600e10 + t197 * t169 / 0.126340300800e12, -0.8e1 / 0.3e1 * t201 * t109 - 0.8e1 / 0.3e1 * t93 * t220)
  t225 = t19 * t224
  t229 = t19 * t113
  t234 = f.my_piecewise3(t2, 0, -t18 * t114 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t225 * t52 - 0.3e1 / 0.8e1 * t18 * t229 * t157)
  t249 = t169 ** 2
  t252 = jnp.pi ** 2
  t254 = t25 ** 2
  t255 = 0.1e1 / t254
  t256 = t27 ** 2
  t265 = f.p.cam_omega / t56 / t3 / t255 / t256 / t126 * t62 / 0.3e1
  t266 = t3 * t255
  t267 = t125 ** 2
  t268 = 0.1e1 / t267
  t269 = t256 * t268
  t270 = t157 ** 2
  t276 = t122 * t164 * jnp.pi
  t283 = 0.1e1 / t125 / t52
  t284 = t27 * t283
  t289 = t34 ** 2
  t291 = 0.1e1 / t20 / t289
  t296 = t32 * t130
  t301 = 0.1e1 / t138 / t46
  t302 = t152 ** 2
  t315 = s0 ** 2
  t321 = 0.1e1 / t147 / t146
  t330 = 0.91259259259259259259259259259259259259259259259260e-2 * t30 * t33 * t291 * t47 + 0.49777777777777777777777777777777777777777777777778e-2 * t136 * t296 * t153 + 0.18666666666666666666666666666666666666666666666666e-2 * t136 * t137 * t301 * t302 - 0.93333333333333333333333333333333333333333333333332e-3 * t136 * t137 * t139 * (0.78400000000000000000000000000000000000000000000000e-1 * t38 / t19 / t128 * t42 + 0.16800000000000000000000000000000000000000000000000e0 * t33 * t291 * t148 - 0.89600000000000000000000000000000000000000000000000e-1 * t315 * t31 / t19 / t289 / t128 * t321)
  t335 = t11 ** 2
  t343 = 0.9e1 / 0.8e1 * t265 * t266 * t269 * t270 - t276 * t30 * t126 * t157 * t11 / 0.6e1 - t124 * t29 * t284 * t270 / 0.2e1 + t124 * t29 * t127 * t330 / 0.4e1 + 0.2e1 / 0.9e1 * t58 * t31 / t60 / t34
  t344 = f.my_piecewise3(t66, t343, 0)
  t372 = 0.1e1 / t89 / t68
  t377 = t72 * t249 / 0.6e1 - t119 * t344 / 0.18e2 - t75 * t249 / 0.48e2 + t173 * t344 / 0.240e3 + t78 * t249 / 0.640e3 - t177 * t344 / 0.4480e4 - t81 * t249 / 0.11520e5 + t181 * t344 / 0.103680e6 + t84 * t249 / 0.258048e6 - t185 * t344 / 0.2838528e7 - t87 * t249 / 0.6881280e7 + t189 * t344 / 0.89456640e8 + t90 * t249 / 0.212336640e9 - t193 * t344 / 0.3185049600e10 - t372 * t249 / 0.7431782400e10 + t197 * t344 / 0.126340300800e12
  t378 = f.my_piecewise3(t66, 0, t343)
  t383 = t99 ** 2
  t385 = 0.1e1 / t383 / t93
  t386 = t201 ** 2
  t390 = t102 * t208
  t398 = 0.1e1 / t383
  t406 = 0.1e1 / t383 / t99
  t425 = f.my_piecewise3(t65, t377, -0.8e1 / 0.3e1 * t378 * t109 - 0.16e2 / 0.3e1 * t201 * t220 - 0.8e1 / 0.3e1 * t93 * (-t385 * t386 * t102 / 0.2e1 + 0.2e1 * t390 * t386 - t203 * t378 + 0.2e1 * t378 * t106 + 0.4e1 * t201 * t217 + 0.2e1 * t93 * (-0.2e1 * t398 * t386 * t102 + t208 * t378 * t102 / 0.2e1 + t406 * t386 * t102 / 0.4e1 - 0.4e1 * t386 * t103 - t100 * t386 * t102 - 0.4e1 * t212 * t378 - t95 * t378 * t102)))
  t437 = f.my_piecewise3(t2, 0, t18 / t20 / r0 * t113 * t52 / 0.12e2 - t18 * t21 * t224 * t52 / 0.4e1 - t18 * t114 * t157 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t19 * t425 * t52 - 0.3e1 / 0.4e1 * t18 * t225 * t157 - 0.3e1 / 0.8e1 * t18 * t229 * t330)
  v2rho2_0_ = 0.2e1 * r0 * t437 + 0.4e1 * t234
  t444 = 0.1e1 / t37 * t31
  t449 = 0.12600000000000000000000000000000000000000000000000e-1 * t444 * t43 + 0.12600000000000000000000000000000000000000000000000e-1 * t137 * t148
  t450 = t139 * t449
  t451 = t137 * t450
  t454 = 0.93333333333333333333333333333333333333333333333332e-3 * t30 * t137 * t47 - 0.93333333333333333333333333333333333333333333333332e-3 * t136 * t451
  t458 = t124 * t29 * t127 * t454 / 0.4e1
  t459 = f.my_piecewise3(t66, t458, 0)
  t477 = f.my_piecewise3(t66, 0, t458)
  t489 = t208 * t477 * t102 / 0.2e1 - 0.4e1 * t212 * t477 - t95 * t477 * t102
  t492 = 0.2e1 * t477 * t106 - t203 * t477 + 0.2e1 * t93 * t489
  t496 = f.my_piecewise3(t65, -t119 * t459 / 0.18e2 + t173 * t459 / 0.240e3 - t177 * t459 / 0.4480e4 + t181 * t459 / 0.103680e6 - t185 * t459 / 0.2838528e7 + t189 * t459 / 0.89456640e8 - t193 * t459 / 0.3185049600e10 + t197 * t459 / 0.126340300800e12, -0.8e1 / 0.3e1 * t477 * t109 - 0.8e1 / 0.3e1 * t93 * t492)
  t497 = t19 * t496
  t504 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t229 * t454 - 0.3e1 / 0.8e1 * t18 * t497 * t52)
  t557 = -0.24888888888888888888888888888888888888888888888889e-2 * t30 * t296 * t47 - 0.93333333333333333333333333333333333333333333333332e-3 * t30 * t154 + 0.24888888888888888888888888888888888888888888888889e-2 * t136 * t296 * t450 + 0.18666666666666666666666666666666666666666666666666e-2 * t136 * t137 * t301 * t449 * t152 - 0.93333333333333333333333333333333333333333333333332e-3 * t136 * t137 * t139 * (-0.16800000000000000000000000000000000000000000000000e-1 * t444 * t142 - 0.50400000000000000000000000000000000000000000000000e-1 * t296 * t148 + 0.33600000000000000000000000000000000000000000000000e-1 * t31 / t19 / t289 / t34 * t321 * s0)
  t562 = 0.9e1 / 0.8e1 * t265 * t266 * t256 * t268 * t454 * t157 - t276 * t30 * t126 * t454 * t11 / 0.12e2 - t124 * t30 * t283 * t454 * t157 / 0.2e1 + t124 * t29 * t127 * t557 / 0.4e1
  t563 = f.my_piecewise3(t66, t562, 0)
  t601 = t72 * t459 * t169 / 0.6e1 - t119 * t563 / 0.18e2 - t75 * t459 * t169 / 0.48e2 + t173 * t563 / 0.240e3 + t78 * t459 * t169 / 0.640e3 - t177 * t563 / 0.4480e4 - t81 * t459 * t169 / 0.11520e5 + t181 * t563 / 0.103680e6 + t84 * t459 * t169 / 0.258048e6 - t185 * t563 / 0.2838528e7 - t87 * t459 * t169 / 0.6881280e7 + t189 * t563 / 0.89456640e8 + t90 * t459 * t169 / 0.212336640e9 - t193 * t563 / 0.3185049600e10 - t372 * t459 * t169 / 0.7431782400e10 + t197 * t563 / 0.126340300800e12
  t602 = f.my_piecewise3(t66, 0, t562)
  t607 = t102 * t477
  t621 = t102 * t201
  t646 = f.my_piecewise3(t65, t601, -0.8e1 / 0.3e1 * t602 * t109 - 0.8e1 / 0.3e1 * t477 * t220 - 0.8e1 / 0.3e1 * t201 * t492 - 0.8e1 / 0.3e1 * t93 * (-t385 * t201 * t607 / 0.2e1 + 0.2e1 * t390 * t477 * t201 - t203 * t602 + 0.2e1 * t602 * t106 + 0.2e1 * t477 * t217 + 0.2e1 * t201 * t489 + 0.2e1 * t93 * (-0.2e1 * t398 * t477 * t621 + t208 * t602 * t102 / 0.2e1 + t406 * t477 * t621 / 0.4e1 - 0.4e1 * t201 * t103 * t477 - t100 * t201 * t607 - 0.4e1 * t212 * t602 - t95 * t602 * t102)))
  t664 = f.my_piecewise3(t2, 0, -t18 * t21 * t496 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t646 * t52 - 0.3e1 / 0.8e1 * t18 * t497 * t157 - t18 * t114 * t454 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t225 * t454 - 0.3e1 / 0.8e1 * t18 * t229 * t557)
  v2rhosigma_0_ = 0.2e1 * r0 * t664 + 0.2e1 * t504
  t667 = t459 ** 2
  t670 = t454 ** 2
  t681 = t449 ** 2
  t707 = -0.18666666666666666666666666666666666666666666666666e-2 * t30 * t451 + 0.18666666666666666666666666666666666666666666666666e-2 * t136 * t137 * t301 * t681 - 0.93333333333333333333333333333333333333333333333332e-3 * t136 * t137 * t139 * (-0.63000000000000000000000000000000000000000000000000e-2 / t37 / s0 * t31 * t43 + 0.63000000000000000000000000000000000000000000000000e-2 / s0 * t32 * t36 * t148 - 0.12600000000000000000000000000000000000000000000000e-1 * t31 / t19 / t289 / r0 * t321)
  t712 = 0.9e1 / 0.8e1 * t265 * t266 * t269 * t670 - t124 * t29 * t284 * t670 / 0.2e1 + t124 * t29 * t127 * t707 / 0.4e1
  t713 = f.my_piecewise3(t66, t712, 0)
  t744 = t72 * t667 / 0.6e1 - t119 * t713 / 0.18e2 - t75 * t667 / 0.48e2 + t173 * t713 / 0.240e3 + t78 * t667 / 0.640e3 - t177 * t713 / 0.4480e4 - t81 * t667 / 0.11520e5 + t181 * t713 / 0.103680e6 + t84 * t667 / 0.258048e6 - t185 * t713 / 0.2838528e7 - t87 * t667 / 0.6881280e7 + t189 * t713 / 0.89456640e8 + t90 * t667 / 0.212336640e9 - t193 * t713 / 0.3185049600e10 - t372 * t667 / 0.7431782400e10 + t197 * t713 / 0.126340300800e12
  t745 = f.my_piecewise3(t66, 0, t712)
  t750 = t477 ** 2
  t785 = f.my_piecewise3(t65, t744, -0.8e1 / 0.3e1 * t745 * t109 - 0.16e2 / 0.3e1 * t477 * t492 - 0.8e1 / 0.3e1 * t93 * (-t385 * t750 * t102 / 0.2e1 + 0.2e1 * t390 * t750 - t203 * t745 + 0.2e1 * t745 * t106 + 0.4e1 * t477 * t489 + 0.2e1 * t93 * (-0.2e1 * t398 * t750 * t102 + t208 * t745 * t102 / 0.2e1 + t406 * t750 * t102 / 0.4e1 - 0.4e1 * t750 * t103 - t100 * t750 * t102 - 0.4e1 * t212 * t745 - t95 * t745 * t102)))
  t797 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t785 * t52 - 0.3e1 / 0.4e1 * t18 * t497 * t454 - 0.3e1 / 0.8e1 * t18 * t229 * t707)
  v2sigma2_0_ = 0.2e1 * r0 * t797
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = t3 ** 2
  t26 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t30 = t23 * t27
  t31 = t30 * t28
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = s0 * t33
  t35 = r0 ** 2
  t37 = 0.1e1 / t20 / t35
  t38 = jnp.sqrt(s0)
  t39 = t38 * t32
  t41 = 0.1e1 / t19 / r0
  t43 = jnp.asinh(t39 * t41)
  t47 = 0.1e1 + 0.2520e-1 * t39 * t41 * t43
  t48 = 0.1e1 / t47
  t53 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t31 * t34 * t37 * t48
  t56 = jnp.pi * t23 * t27 * t28 / t53
  t57 = jnp.sqrt(t56)
  t59 = f.p.cam_omega / t57
  t60 = t11 * r0
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = 0.1e1 / t61
  t63 = t32 * t62
  t65 = t59 * t63 / 0.2e1
  t66 = 0.135e1 <= t65
  t67 = 0.135e1 < t65
  t68 = f.my_piecewise3(t67, t65, 0.135e1)
  t69 = t68 ** 2
  t72 = t69 ** 2
  t73 = 0.1e1 / t72
  t75 = t72 * t69
  t76 = 0.1e1 / t75
  t78 = t72 ** 2
  t79 = 0.1e1 / t78
  t82 = 0.1e1 / t78 / t69
  t85 = 0.1e1 / t78 / t72
  t88 = 0.1e1 / t78 / t75
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t94 = f.my_piecewise3(t67, 0.135e1, t65)
  t95 = jnp.sqrt(jnp.pi)
  t96 = 0.1e1 / t94
  t98 = jnp.erf(t96 / 0.2e1)
  t100 = t94 ** 2
  t101 = 0.1e1 / t100
  t103 = jnp.exp(-t101 / 0.4e1)
  t104 = t103 - 0.1e1
  t107 = t103 - 0.3e1 / 0.2e1 - 0.2e1 * t100 * t104
  t110 = 0.2e1 * t94 * t107 + t95 * t98
  t114 = f.my_piecewise3(t66, 0.1e1 / t69 / 0.36e2 - t73 / 0.960e3 + t76 / 0.26880e5 - t79 / 0.829440e6 + t82 / 0.28385280e8 - t85 / 0.1073479680e10 + t88 / 0.44590694400e11 - t91 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t94 * t110)
  t115 = t22 * t114
  t119 = 0.1e1 / t20
  t120 = t69 * t68
  t121 = 0.1e1 / t120
  t124 = f.p.cam_omega / t57 / t56
  t126 = t124 * t63 * jnp.pi
  t127 = t53 ** 2
  t128 = 0.1e1 / t127
  t129 = t28 * t128
  t130 = t35 * r0
  t132 = 0.1e1 / t20 / t130
  t138 = t30 * t28 * s0
  t139 = t33 * t37
  t140 = t47 ** 2
  t141 = 0.1e1 / t140
  t148 = t34 * t37 + 0.1e1
  t149 = jnp.sqrt(t148)
  t150 = 0.1e1 / t149
  t154 = -0.33600000000000000000000000000000000000000000000000e-1 * t39 / t19 / t35 * t43 - 0.33600000000000000000000000000000000000000000000000e-1 * t34 * t132 * t150
  t155 = t141 * t154
  t159 = -0.24888888888888888888888888888888888888888888888889e-2 * t31 * t34 * t132 * t48 - 0.93333333333333333333333333333333333333333333333332e-3 * t138 * t139 * t155
  t166 = t32 / t61 / t60
  t170 = t126 * t30 * t129 * t159 / 0.4e1 - t59 * t166 * t11 / 0.6e1
  t171 = f.my_piecewise3(t67, t170, 0)
  t174 = t72 * t68
  t175 = 0.1e1 / t174
  t178 = t72 * t120
  t179 = 0.1e1 / t178
  t183 = 0.1e1 / t78 / t68
  t187 = 0.1e1 / t78 / t120
  t191 = 0.1e1 / t78 / t174
  t195 = 0.1e1 / t78 / t178
  t199 = 0.1e1 / t90 / t68
  t203 = f.my_piecewise3(t67, 0, t170)
  t205 = t103 * t101
  t209 = t100 * t94
  t210 = 0.1e1 / t209
  t214 = t94 * t104
  t219 = t210 * t203 * t103 / 0.2e1 - 0.4e1 * t214 * t203 - t96 * t203 * t103
  t222 = 0.2e1 * t203 * t107 - t205 * t203 + 0.2e1 * t94 * t219
  t226 = f.my_piecewise3(t66, -t121 * t171 / 0.18e2 + t175 * t171 / 0.240e3 - t179 * t171 / 0.4480e4 + t183 * t171 / 0.103680e6 - t187 * t171 / 0.2838528e7 + t191 * t171 / 0.89456640e8 - t195 * t171 / 0.3185049600e10 + t199 * t171 / 0.126340300800e12, -0.8e1 / 0.3e1 * t203 * t110 - 0.8e1 / 0.3e1 * t94 * t222)
  t227 = t119 * t226
  t231 = t119 * t114
  t235 = t171 ** 2
  t238 = jnp.pi ** 2
  t240 = t26 ** 2
  t241 = 0.1e1 / t240
  t242 = t28 ** 2
  t249 = f.p.cam_omega / t57 / t238 / t3 / t241 / t242 / t128 / 0.3e1
  t251 = t249 * t63 * t238
  t252 = t3 * t241
  t253 = t127 ** 2
  t254 = 0.1e1 / t253
  t256 = t159 ** 2
  t262 = t124 * t166 * jnp.pi
  t263 = t128 * t159
  t269 = 0.1e1 / t127 / t53
  t275 = t35 ** 2
  t277 = 0.1e1 / t20 / t275
  t282 = t33 * t132
  t287 = 0.1e1 / t140 / t47
  t288 = t154 ** 2
  t289 = t287 * t288
  t301 = s0 ** 2
  t302 = t301 * t32
  t307 = 0.1e1 / t149 / t148
  t311 = 0.78400000000000000000000000000000000000000000000000e-1 * t39 / t19 / t130 * t43 + 0.16800000000000000000000000000000000000000000000000e0 * t34 * t277 * t150 - 0.89600000000000000000000000000000000000000000000000e-1 * t302 / t19 / t275 / t130 * t307
  t312 = t141 * t311
  t316 = 0.91259259259259259259259259259259259259259259259260e-2 * t31 * t34 * t277 * t48 + 0.49777777777777777777777777777777777777777777777778e-2 * t138 * t282 * t155 + 0.18666666666666666666666666666666666666666666666666e-2 * t138 * t139 * t289 - 0.93333333333333333333333333333333333333333333333332e-3 * t138 * t139 * t312
  t321 = t11 ** 2
  t325 = t32 / t61 / t321 / t35
  t329 = 0.9e1 / 0.8e1 * t251 * t252 * t242 * t254 * t256 - t262 * t31 * t263 * t11 / 0.6e1 - t126 * t30 * t28 * t269 * t256 / 0.2e1 + t126 * t30 * t129 * t316 / 0.4e1 + 0.2e1 / 0.9e1 * t59 * t325 * t321
  t330 = f.my_piecewise3(t67, t329, 0)
  t358 = 0.1e1 / t90 / t69
  t363 = t73 * t235 / 0.6e1 - t121 * t330 / 0.18e2 - t76 * t235 / 0.48e2 + t175 * t330 / 0.240e3 + t79 * t235 / 0.640e3 - t179 * t330 / 0.4480e4 - t82 * t235 / 0.11520e5 + t183 * t330 / 0.103680e6 + t85 * t235 / 0.258048e6 - t187 * t330 / 0.2838528e7 - t88 * t235 / 0.6881280e7 + t191 * t330 / 0.89456640e8 + t91 * t235 / 0.212336640e9 - t195 * t330 / 0.3185049600e10 - t358 * t235 / 0.7431782400e10 + t199 * t330 / 0.126340300800e12
  t364 = f.my_piecewise3(t67, 0, t329)
  t369 = t100 ** 2
  t371 = 0.1e1 / t369 / t94
  t372 = t203 ** 2
  t376 = t103 * t210
  t384 = 0.1e1 / t369
  t392 = 0.1e1 / t369 / t100
  t404 = -0.2e1 * t384 * t372 * t103 + t210 * t364 * t103 / 0.2e1 + t392 * t372 * t103 / 0.4e1 - 0.4e1 * t372 * t104 - t101 * t372 * t103 - 0.4e1 * t214 * t364 - t96 * t364 * t103
  t407 = -t371 * t372 * t103 / 0.2e1 + 0.2e1 * t376 * t372 - t205 * t364 + 0.2e1 * t364 * t107 + 0.4e1 * t203 * t219 + 0.2e1 * t94 * t404
  t411 = f.my_piecewise3(t66, t363, -0.8e1 / 0.3e1 * t364 * t110 - 0.16e2 / 0.3e1 * t203 * t222 - 0.8e1 / 0.3e1 * t94 * t407)
  t412 = t19 * t411
  t416 = t19 * t226
  t420 = t19 * t114
  t425 = f.my_piecewise3(t2, 0, t18 * t115 * t53 / 0.12e2 - t18 * t227 * t53 / 0.4e1 - t18 * t231 * t159 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t412 * t53 - 0.3e1 / 0.4e1 * t18 * t416 * t159 - 0.3e1 / 0.8e1 * t18 * t420 * t316)
  t450 = t235 * t171
  t456 = t238 ** 2
  t466 = t256 * t159
  t473 = t252 * t242
  t519 = 0.1e1 / t20 / t275 / r0
  t534 = t140 ** 2
  t554 = t275 ** 2
  t564 = t148 ** 2
  t574 = -0.42587654320987654320987654320987654320987654320988e-1 * t31 * t34 * t519 * t48 - 0.27377777777777777777777777777777777777777777777778e-1 * t138 * t33 * t277 * t155 - 0.14933333333333333333333333333333333333333333333333e-1 * t138 * t282 * t289 + 0.74666666666666666666666666666666666666666666666667e-2 * t138 * t282 * t312 - 0.55999999999999999999999999999999999999999999999998e-2 * t138 * t139 / t534 * t288 * t154 + 0.55999999999999999999999999999999999999999999999998e-2 * t138 * t139 * t287 * t154 * t311 - 0.93333333333333333333333333333333333333333333333332e-3 * t138 * t139 * t141 * (-0.26133333333333333333333333333333333333333333333333e0 * t39 / t19 / t275 * t43 - 0.88853333333333333333333333333333333333333333333333e0 * t34 * t519 * t150 + 0.11050666666666666666666666666666666666666666666667e1 * t302 / t19 / t554 * t307 - 0.71680000000000000000000000000000000000000000000000e0 * t301 * s0 / t554 / t130 / t149 / t564)
  t579 = t321 * t11
  t587 = 0.15e2 / 0.16e2 * f.p.cam_omega / t57 / t269 * t32 * t62 / t253 / t127 * t466 - 0.9e1 / 0.8e1 * t249 * t166 * t238 * t473 * t254 * t256 * t11 - 0.27e2 / 0.4e1 * t251 * t252 * t242 / t253 / t53 * t466 + 0.27e2 / 0.8e1 * t251 * t473 * t254 * t159 * t316 + t124 * t325 * jnp.pi * t31 * t263 * t321 / 0.3e1 + t262 * t31 * t269 * t256 * t11 / 0.2e1 - t262 * t31 * t128 * t316 * t11 / 0.4e1 + 0.3e1 / 0.2e1 * t126 * t30 * t28 * t254 * t466 - 0.3e1 / 0.2e1 * t126 * t31 * t269 * t159 * t316 + t126 * t30 * t129 * t574 / 0.4e1 - 0.14e2 / 0.27e2 * t59 * t32 / t61 / t130
  t588 = f.my_piecewise3(t67, t587, 0)
  t611 = 0.1e1 / t90 / t120 * t450 / 0.412876800e9 - t358 * t171 * t330 / 0.2477260800e10 + t191 * t588 / 0.89456640e8 - t187 * t588 / 0.2838528e7 + t183 * t588 / 0.103680e6 - t179 * t588 / 0.4480e4 + t175 * t588 / 0.240e3 - t121 * t588 / 0.18e2 - t82 * t171 * t330 / 0.3840e4 + t187 * t450 / 0.1152e4 - t183 * t450 / 0.80e2 + 0.3e1 / 0.640e3 * t79 * t171 * t330
  t641 = t179 * t450 / 0.8e1 - t76 * t171 * t330 / 0.16e2 + t195 * t450 / 0.491520e6 - t88 * t171 * t330 / 0.2293760e7 - t199 * t450 / 0.13271040e8 + t91 * t171 * t330 / 0.70778880e8 - 0.2e1 / 0.3e1 * t175 * t450 + t73 * t171 * t330 / 0.2e1 - t191 * t450 / 0.21504e5 + t85 * t171 * t330 / 0.86016e5 + t199 * t588 / 0.126340300800e12 - t195 * t588 / 0.3185049600e10
  t643 = f.my_piecewise3(t67, 0, t587)
  t650 = t372 * t203
  t655 = t103 * t364
  t658 = t369 ** 2
  t716 = f.my_piecewise3(t66, t611 + t641, -0.8e1 / 0.3e1 * t643 * t110 - 0.8e1 * t364 * t222 - 0.8e1 * t203 * t407 - 0.8e1 / 0.3e1 * t94 * (0.7e1 / 0.2e1 * t392 * t650 * t103 - 0.3e1 / 0.2e1 * t371 * t203 * t655 - 0.1e1 / t658 * t650 * t103 / 0.4e1 - 0.6e1 * t103 * t384 * t650 + 0.6e1 * t376 * t203 * t364 - t205 * t643 + 0.2e1 * t643 * t107 + 0.6e1 * t364 * t219 + 0.6e1 * t203 * t404 + 0.2e1 * t94 * (0.15e2 / 0.2e1 * t371 * t650 * t103 - 0.6e1 * t384 * t203 * t655 - 0.5e1 / 0.2e1 / t369 / t209 * t650 * t103 + t210 * t643 * t103 / 0.2e1 + 0.3e1 / 0.4e1 * t392 * t364 * t203 * t103 + 0.1e1 / t658 / t94 * t650 * t103 / 0.8e1 - 0.12e2 * t203 * t104 * t364 - 0.3e1 * t101 * t203 * t655 - 0.4e1 * t214 * t643 - t96 * t643 * t103)))
  t731 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t37 * t114 * t53 + t18 * t22 * t226 * t53 / 0.4e1 + t18 * t115 * t159 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t119 * t411 * t53 - 0.3e1 / 0.4e1 * t18 * t227 * t159 - 0.3e1 / 0.8e1 * t18 * t231 * t316 - 0.3e1 / 0.8e1 * t18 * t19 * t716 * t53 - 0.9e1 / 0.8e1 * t18 * t412 * t159 - 0.9e1 / 0.8e1 * t18 * t416 * t316 - 0.3e1 / 0.8e1 * t18 * t420 * t574)
  v3rho3_0_ = 0.2e1 * r0 * t731 + 0.6e1 * t425

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = t3 ** 2
  t26 = 0.1e1 / jnp.pi
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = 0.1e1 / t27
  t29 = 4 ** (0.1e1 / 0.3e1)
  t30 = t28 * t29
  t31 = t24 * t28
  t32 = t31 * t29
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = s0 * t34
  t36 = jnp.sqrt(s0)
  t37 = t36 * t33
  t39 = 0.1e1 / t20 / r0
  t41 = jnp.asinh(t37 * t39)
  t45 = 0.1e1 + 0.2520e-1 * t37 * t39 * t41
  t46 = 0.1e1 / t45
  t51 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t32 * t35 * t23 * t46
  t54 = jnp.pi * t24 * t30 / t51
  t55 = jnp.sqrt(t54)
  t57 = f.p.cam_omega / t55
  t58 = t11 * r0
  t59 = t58 ** (0.1e1 / 0.3e1)
  t60 = 0.1e1 / t59
  t61 = t33 * t60
  t63 = t57 * t61 / 0.2e1
  t64 = 0.135e1 <= t63
  t65 = 0.135e1 < t63
  t66 = f.my_piecewise3(t65, t63, 0.135e1)
  t67 = t66 ** 2
  t70 = t67 ** 2
  t71 = 0.1e1 / t70
  t73 = t70 * t67
  t74 = 0.1e1 / t73
  t76 = t70 ** 2
  t77 = 0.1e1 / t76
  t80 = 0.1e1 / t76 / t67
  t83 = 0.1e1 / t76 / t70
  t86 = 0.1e1 / t76 / t73
  t88 = t76 ** 2
  t89 = 0.1e1 / t88
  t92 = f.my_piecewise3(t65, 0.135e1, t63)
  t93 = jnp.sqrt(jnp.pi)
  t94 = 0.1e1 / t92
  t96 = jnp.erf(t94 / 0.2e1)
  t98 = t92 ** 2
  t99 = 0.1e1 / t98
  t101 = jnp.exp(-t99 / 0.4e1)
  t102 = t101 - 0.1e1
  t105 = t101 - 0.3e1 / 0.2e1 - 0.2e1 * t98 * t102
  t108 = 0.2e1 * t92 * t105 + t93 * t96
  t112 = f.my_piecewise3(t64, 0.1e1 / t67 / 0.36e2 - t71 / 0.960e3 + t74 / 0.26880e5 - t77 / 0.829440e6 + t80 / 0.28385280e8 - t83 / 0.1073479680e10 + t86 / 0.44590694400e11 - t89 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t92 * t108)
  t113 = t23 * t112
  t118 = 0.1e1 / t21 / r0
  t119 = t67 * t66
  t120 = 0.1e1 / t119
  t123 = f.p.cam_omega / t55 / t54
  t125 = t123 * t61 * jnp.pi
  t126 = t51 ** 2
  t127 = 0.1e1 / t126
  t128 = t29 * t127
  t129 = t19 * r0
  t131 = 0.1e1 / t21 / t129
  t137 = t31 * t29 * s0
  t138 = t34 * t23
  t139 = t45 ** 2
  t140 = 0.1e1 / t139
  t147 = t35 * t23 + 0.1e1
  t148 = jnp.sqrt(t147)
  t149 = 0.1e1 / t148
  t153 = -0.33600000000000000000000000000000000000000000000000e-1 * t37 / t20 / t19 * t41 - 0.33600000000000000000000000000000000000000000000000e-1 * t35 * t131 * t149
  t154 = t140 * t153
  t158 = -0.24888888888888888888888888888888888888888888888889e-2 * t32 * t35 * t131 * t46 - 0.93333333333333333333333333333333333333333333333332e-3 * t137 * t138 * t154
  t164 = 0.1e1 / t59 / t58
  t165 = t33 * t164
  t169 = t125 * t31 * t128 * t158 / 0.4e1 - t57 * t165 * t11 / 0.6e1
  t170 = f.my_piecewise3(t65, t169, 0)
  t173 = t70 * t66
  t174 = 0.1e1 / t173
  t177 = t70 * t119
  t178 = 0.1e1 / t177
  t182 = 0.1e1 / t76 / t66
  t186 = 0.1e1 / t76 / t119
  t190 = 0.1e1 / t76 / t173
  t194 = 0.1e1 / t76 / t177
  t198 = 0.1e1 / t88 / t66
  t202 = f.my_piecewise3(t65, 0, t169)
  t204 = t101 * t99
  t208 = t98 * t92
  t209 = 0.1e1 / t208
  t213 = t92 * t102
  t218 = t209 * t202 * t101 / 0.2e1 - 0.4e1 * t213 * t202 - t94 * t202 * t101
  t221 = 0.2e1 * t202 * t105 - t204 * t202 + 0.2e1 * t92 * t218
  t225 = f.my_piecewise3(t64, -t120 * t170 / 0.18e2 + t174 * t170 / 0.240e3 - t178 * t170 / 0.4480e4 + t182 * t170 / 0.103680e6 - t186 * t170 / 0.2838528e7 + t190 * t170 / 0.89456640e8 - t194 * t170 / 0.3185049600e10 + t198 * t170 / 0.126340300800e12, -0.8e1 / 0.3e1 * t202 * t108 - 0.8e1 / 0.3e1 * t92 * t221)
  t226 = t118 * t225
  t230 = t118 * t112
  t234 = 0.1e1 / t21
  t235 = t170 ** 2
  t238 = jnp.pi ** 2
  t240 = t27 ** 2
  t241 = 0.1e1 / t240
  t242 = t29 ** 2
  t243 = t241 * t242
  t249 = f.p.cam_omega / t55 / t238 / t3 / t243 / t127 / 0.3e1
  t251 = t249 * t61 * t238
  t252 = t3 * t241
  t253 = t126 ** 2
  t254 = 0.1e1 / t253
  t255 = t242 * t254
  t256 = t158 ** 2
  t262 = t123 * t165 * jnp.pi
  t263 = t127 * t158
  t268 = t126 * t51
  t269 = 0.1e1 / t268
  t270 = t29 * t269
  t275 = t19 ** 2
  t277 = 0.1e1 / t21 / t275
  t282 = t34 * t131
  t287 = 0.1e1 / t139 / t45
  t288 = t153 ** 2
  t289 = t287 * t288
  t301 = s0 ** 2
  t302 = t301 * t33
  t307 = 0.1e1 / t148 / t147
  t311 = 0.78400000000000000000000000000000000000000000000000e-1 * t37 / t20 / t129 * t41 + 0.16800000000000000000000000000000000000000000000000e0 * t35 * t277 * t149 - 0.89600000000000000000000000000000000000000000000000e-1 * t302 / t20 / t275 / t129 * t307
  t312 = t140 * t311
  t316 = 0.91259259259259259259259259259259259259259259259260e-2 * t32 * t35 * t277 * t46 + 0.49777777777777777777777777777777777777777777777778e-2 * t137 * t282 * t154 + 0.18666666666666666666666666666666666666666666666666e-2 * t137 * t138 * t289 - 0.93333333333333333333333333333333333333333333333332e-3 * t137 * t138 * t312
  t321 = t11 ** 2
  t325 = t33 / t59 / t321 / t19
  t329 = 0.9e1 / 0.8e1 * t251 * t252 * t255 * t256 - t262 * t32 * t263 * t11 / 0.6e1 - t125 * t31 * t270 * t256 / 0.2e1 + t125 * t31 * t128 * t316 / 0.4e1 + 0.2e1 / 0.9e1 * t57 * t325 * t321
  t330 = f.my_piecewise3(t65, t329, 0)
  t358 = 0.1e1 / t88 / t67
  t363 = t71 * t235 / 0.6e1 - t120 * t330 / 0.18e2 - t74 * t235 / 0.48e2 + t174 * t330 / 0.240e3 + t77 * t235 / 0.640e3 - t178 * t330 / 0.4480e4 - t80 * t235 / 0.11520e5 + t182 * t330 / 0.103680e6 + t83 * t235 / 0.258048e6 - t186 * t330 / 0.2838528e7 - t86 * t235 / 0.6881280e7 + t190 * t330 / 0.89456640e8 + t89 * t235 / 0.212336640e9 - t194 * t330 / 0.3185049600e10 - t358 * t235 / 0.7431782400e10 + t198 * t330 / 0.126340300800e12
  t364 = f.my_piecewise3(t65, 0, t329)
  t369 = t98 ** 2
  t371 = 0.1e1 / t369 / t92
  t372 = t202 ** 2
  t373 = t371 * t372
  t376 = t101 * t209
  t384 = 0.1e1 / t369
  t392 = 0.1e1 / t369 / t98
  t393 = t392 * t372
  t404 = -0.2e1 * t384 * t372 * t101 + t209 * t364 * t101 / 0.2e1 + t393 * t101 / 0.4e1 - 0.4e1 * t372 * t102 - t99 * t372 * t101 - 0.4e1 * t213 * t364 - t94 * t364 * t101
  t407 = -t373 * t101 / 0.2e1 + 0.2e1 * t376 * t372 - t204 * t364 + 0.2e1 * t364 * t105 + 0.4e1 * t202 * t218 + 0.2e1 * t92 * t404
  t411 = f.my_piecewise3(t64, t363, -0.8e1 / 0.3e1 * t364 * t108 - 0.16e2 / 0.3e1 * t202 * t221 - 0.8e1 / 0.3e1 * t92 * t407)
  t412 = t234 * t411
  t416 = t234 * t225
  t420 = t234 * t112
  t424 = t238 ** 2
  t429 = f.p.cam_omega / t55 / t424 / t269 / 0.36e2
  t430 = t429 * t33
  t431 = t60 * t424
  t433 = 0.1e1 / t253 / t126
  t434 = t256 * t158
  t440 = t249 * t165 * t238
  t441 = t252 * t242
  t442 = t254 * t256
  t448 = 0.1e1 / t253 / t51
  t454 = t254 * t158
  t460 = t123 * t325 * jnp.pi
  t465 = t269 * t256
  t470 = t127 * t316
  t480 = t269 * t158
  t485 = t275 * r0
  t487 = 0.1e1 / t21 / t485
  t492 = t34 * t277
  t502 = t139 ** 2
  t503 = 0.1e1 / t502
  t505 = t503 * t288 * t153
  t509 = t287 * t153
  t510 = t509 * t311
  t522 = t275 ** 2
  t528 = t301 * s0
  t532 = t147 ** 2
  t534 = 0.1e1 / t148 / t532
  t537 = -0.26133333333333333333333333333333333333333333333333e0 * t37 / t20 / t275 * t41 - 0.88853333333333333333333333333333333333333333333333e0 * t35 * t487 * t149 + 0.11050666666666666666666666666666666666666666666667e1 * t302 / t20 / t522 * t307 - 0.71680000000000000000000000000000000000000000000000e0 * t528 / t522 / t129 * t534
  t538 = t140 * t537
  t542 = -0.42587654320987654320987654320987654320987654320988e-1 * t32 * t35 * t487 * t46 - 0.27377777777777777777777777777777777777777777777778e-1 * t137 * t492 * t154 - 0.14933333333333333333333333333333333333333333333333e-1 * t137 * t282 * t289 + 0.74666666666666666666666666666666666666666666666667e-2 * t137 * t282 * t312 - 0.55999999999999999999999999999999999999999999999998e-2 * t137 * t138 * t505 + 0.55999999999999999999999999999999999999999999999998e-2 * t137 * t138 * t510 - 0.93333333333333333333333333333333333333333333333332e-3 * t137 * t138 * t538
  t547 = t321 * t11
  t551 = t33 / t59 / t547 / t129
  t555 = 0.135e3 / 0.4e1 * t430 * t431 * t433 * t434 - 0.9e1 / 0.8e1 * t440 * t441 * t442 * t11 - 0.27e2 / 0.4e1 * t251 * t252 * t242 * t448 * t434 + 0.27e2 / 0.8e1 * t251 * t441 * t454 * t316 + t460 * t32 * t263 * t321 / 0.3e1 + t262 * t32 * t465 * t11 / 0.2e1 - t262 * t32 * t470 * t11 / 0.4e1 + 0.3e1 / 0.2e1 * t125 * t31 * t29 * t254 * t434 - 0.3e1 / 0.2e1 * t125 * t32 * t480 * t316 + t125 * t31 * t128 * t542 / 0.4e1 - 0.14e2 / 0.27e2 * t57 * t551 * t547
  t556 = f.my_piecewise3(t65, t555, 0)
  t571 = t235 * t170
  t584 = -t186 * t556 / 0.2838528e7 + t182 * t556 / 0.103680e6 - t178 * t556 / 0.4480e4 + t174 * t556 / 0.240e3 + t198 * t556 / 0.126340300800e12 - t194 * t556 / 0.3185049600e10 + t190 * t556 / 0.89456640e8 + t194 * t571 / 0.491520e6 - t86 * t170 * t330 / 0.2293760e7 - t120 * t556 / 0.18e2 - t182 * t571 / 0.80e2 + 0.3e1 / 0.640e3 * t77 * t170 * t330
  t591 = 0.1e1 / t88 / t119
  t617 = t178 * t571 / 0.8e1 - t74 * t170 * t330 / 0.16e2 + t591 * t571 / 0.412876800e9 - t358 * t170 * t330 / 0.2477260800e10 - t198 * t571 / 0.13271040e8 + t89 * t170 * t330 / 0.70778880e8 - t190 * t571 / 0.21504e5 + t83 * t170 * t330 / 0.86016e5 + t186 * t571 / 0.1152e4 - t80 * t170 * t330 / 0.3840e4 - 0.2e1 / 0.3e1 * t174 * t571 + t71 * t170 * t330 / 0.2e1
  t619 = f.my_piecewise3(t65, 0, t555)
  t626 = t372 * t202
  t630 = t371 * t202
  t631 = t101 * t364
  t634 = t369 ** 2
  t635 = 0.1e1 / t634
  t639 = t101 * t384
  t655 = t384 * t202
  t659 = 0.1e1 / t369 / t208
  t667 = t202 * t101
  t671 = 0.1e1 / t634 / t92
  t675 = t202 * t102
  t678 = t99 * t202
  t685 = 0.15e2 / 0.2e1 * t371 * t626 * t101 - 0.6e1 * t655 * t631 - 0.5e1 / 0.2e1 * t659 * t626 * t101 + t209 * t619 * t101 / 0.2e1 + 0.3e1 / 0.4e1 * t392 * t364 * t667 + t671 * t626 * t101 / 0.8e1 - 0.12e2 * t675 * t364 - 0.3e1 * t678 * t631 - 0.4e1 * t213 * t619 - t94 * t619 * t101
  t688 = 0.7e1 / 0.2e1 * t392 * t626 * t101 - 0.3e1 / 0.2e1 * t630 * t631 - t635 * t626 * t101 / 0.4e1 - 0.6e1 * t639 * t626 + 0.6e1 * t376 * t202 * t364 - t204 * t619 + 0.2e1 * t619 * t105 + 0.6e1 * t364 * t218 + 0.6e1 * t202 * t404 + 0.2e1 * t92 * t685
  t692 = f.my_piecewise3(t64, t584 + t617, -0.8e1 / 0.3e1 * t619 * t108 - 0.8e1 * t364 * t221 - 0.8e1 * t202 * t407 - 0.8e1 / 0.3e1 * t92 * t688)
  t693 = t20 * t692
  t697 = t20 * t411
  t701 = t20 * t225
  t705 = t20 * t112
  t710 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t113 * t51 + t18 * t226 * t51 / 0.4e1 + t18 * t230 * t158 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t412 * t51 - 0.3e1 / 0.4e1 * t18 * t416 * t158 - 0.3e1 / 0.8e1 * t18 * t420 * t316 - 0.3e1 / 0.8e1 * t18 * t693 * t51 - 0.9e1 / 0.8e1 * t18 * t697 * t158 - 0.9e1 / 0.8e1 * t18 * t701 * t316 - 0.3e1 / 0.8e1 * t18 * t705 * t542)
  t745 = t275 * t19
  t747 = 0.1e1 / t21 / t745
  t773 = t288 ** 2
  t783 = t311 ** 2
  t811 = t301 ** 2
  t827 = 0.24133004115226337448559670781893004115226337448560e0 * t32 * t35 * t747 * t46 + 0.17035061728395061728395061728395061728395061728395e0 * t137 * t34 * t487 * t154 + 0.10951111111111111111111111111111111111111111111111e0 * t137 * t492 * t289 - 0.54755555555555555555555555555555555555555555555556e-1 * t137 * t492 * t312 + 0.59733333333333333333333333333333333333333333333332e-1 * t137 * t282 * t505 - 0.59733333333333333333333333333333333333333333333332e-1 * t137 * t282 * t510 + 0.99555555555555555555555555555555555555555555555556e-2 * t137 * t282 * t538 + 0.22399999999999999999999999999999999999999999999999e-1 * t137 * t138 / t502 / t45 * t773 - 0.33599999999999999999999999999999999999999999999998e-1 * t137 * t138 * t503 * t288 * t311 + 0.55999999999999999999999999999999999999999999999998e-2 * t137 * t138 * t287 * t783 + 0.74666666666666666666666666666666666666666666666664e-2 * t137 * t138 * t509 * t537 - 0.93333333333333333333333333333333333333333333333332e-3 * t137 * t138 * t140 * (0.11324444444444444444444444444444444444444444444444e1 * t37 / t20 / t485 * t41 + 0.53834666666666666666666666666666666666666666666666e1 * t35 * t747 * t149 - 0.11578311111111111111111111111111111111111111111111e2 * t302 / t20 / t522 / r0 * t307 + 0.16725333333333333333333333333333333333333333333334e2 * t528 / t522 / t275 * t534 - 0.47786666666666666666666666666666666666666666666667e1 * t811 / t21 / t522 / t745 / t148 / t532 / t147 * t34)
  t857 = t253 ** 2
  t859 = t256 ** 2
  t864 = t321 ** 2
  t883 = t158 * t11 * t316
  t911 = t424 * t433
  t921 = t125 * t31 * t128 * t827 / 0.4e1 + 0.105e3 / 0.32e2 * f.p.cam_omega / t55 / t24 * t27 * t26 / t29 / t254 * t61 * jnp.pi / t857 * t859 * t32 + 0.140e3 / 0.81e2 * t57 * t33 / t59 / t275 + 0.9e1 * t440 * t441 * t448 * t434 * t11 - 0.9e1 / 0.2e1 * t249 * t33 * t164 * t238 * t3 * t243 * t254 * t883 - 0.28e2 / 0.27e2 * t123 * t551 * jnp.pi * t32 * t263 * t547 - 0.4e1 / 0.3e1 * t460 * t32 * t465 * t321 - 0.2e1 * t262 * t32 * t254 * t434 * t11 + 0.2e1 * t123 * t33 * t164 * jnp.pi * t24 * t30 * t269 * t883 + 0.405e3 / 0.2e1 * t429 * t61 * t911 * t256 * t316 + 0.81e2 / 0.2e1 * t251 * t252 * t242 * t433 * t859
  t927 = t316 ** 2
  t979 = -0.81e2 / 0.2e1 * t251 * t441 * t448 * t256 * t316 + 0.27e2 / 0.8e1 * t251 * t252 * t255 * t927 + 0.9e1 / 0.2e1 * t251 * t441 * t454 * t542 + 0.2e1 / 0.3e1 * t460 * t32 * t470 * t321 - t262 * t32 * t127 * t542 * t11 / 0.3e1 - 0.6e1 * t125 * t31 * t29 * t448 * t859 + 0.9e1 * t125 * t32 * t442 * t316 - 0.3e1 / 0.2e1 * t125 * t31 * t270 * t927 - 0.2e1 * t125 * t32 * t480 * t542 - 0.45e2 * t429 * t165 * t911 * t434 * t11 - 0.405e3 * t430 * t431 / t253 / t268 * t859 + 0.3e1 * t249 * t325 * t238 * t441 * t442 * t321
  t980 = t921 + t979
  t981 = f.my_piecewise3(t65, t980, 0)
  t984 = t235 ** 2
  t989 = t330 ** 2
  t1025 = -t186 * t981 / 0.2838528e7 + 0.13e2 / 0.21504e5 * t86 * t984 - t89 * t984 / 0.32768e5 + 0.3e1 / 0.640e3 * t77 * t989 + t190 * t981 / 0.89456640e8 - t120 * t981 / 0.18e2 - 0.11e2 / 0.1152e4 * t83 * t984 - t194 * t981 / 0.3185049600e10 + t89 * t989 / 0.70778880e8 - 0.7e1 / 0.8e1 * t77 * t984 - t74 * t989 / 0.16e2 + 0.9e1 / 0.80e2 * t80 * t984 + 0.10e2 / 0.3e1 * t74 * t984 + t198 * t981 / 0.126340300800e12 + 0.17e2 / 0.13271040e8 * t358 * t984 + t182 * t981 / 0.103680e6 + t174 * t981 / 0.240e3 - t358 * t989 / 0.2477260800e10 - t178 * t981 / 0.4480e4 - t358 * t556 * t170 / 0.1857945600e10
  t1083 = t77 * t556 * t170 / 0.160e3 + t194 * t235 * t330 / 0.81920e5 - t198 * t235 * t330 / 0.2211840e7 - t190 * t235 * t330 / 0.3584e4 - 0.3e1 / 0.40e2 * t182 * t235 * t330 - t80 * t556 * t170 / 0.2880e4 - t74 * t556 * t170 / 0.12e2 - 0.4e1 * t174 * t235 * t330 + t186 * t235 * t330 / 0.192e3 + t591 * t235 * t330 / 0.68812800e8 + t89 * t556 * t170 / 0.53084160e8 + 0.3e1 / 0.4e1 * t178 * t235 * t330 - t86 * t556 * t170 / 0.1720320e7 + 0.2e1 / 0.3e1 * t71 * t556 * t170 + t83 * t556 * t170 / 0.64512e5 - 0.19e2 / 0.412876800e9 / t88 / t70 * t984 + t71 * t989 / 0.2e1 - t80 * t989 / 0.3840e4 + t83 * t989 / 0.86016e5 - t86 * t989 / 0.2293760e7
  t1085 = f.my_piecewise3(t65, 0, t980)
  t1094 = t372 ** 2
  t1100 = t101 * t619
  t1103 = t364 ** 2
  t1166 = 0.3e1 / 0.4e1 * t392 * t1103 * t101 + 0.1e1 / t634 / t369 * t1094 * t101 / 0.16e2 - 0.12e2 * t1103 * t102 + 0.85e2 / 0.4e1 * t635 * t1094 * t101 - 0.3e1 * t99 * t1103 * t101 - 0.4e1 * t213 * t1085 - t94 * t1085 * t101 - 0.4e1 * t678 * t1100 - 0.8e1 * t655 * t1100 - 0.75e2 / 0.2e1 * t392 * t1094 * t101 + 0.45e2 * t373 * t631 - 0.15e2 * t659 * t372 * t631 - 0.16e2 * t675 * t619 + 0.3e1 / 0.4e1 * t671 * t364 * t372 * t101 + t392 * t619 * t667 - 0.6e1 * t384 * t1103 * t101 - 0.19e2 / 0.8e1 / t634 / t98 * t1094 * t101 + t209 * t1085 * t101 / 0.2e1
  t1192 = 0.15e2 / 0.4e1 * t671 * t1094 * t101 + 0.8e1 * t202 * t685 - 0.2e1 * t630 * t1100 - 0.3e1 / 0.2e1 * t371 * t1103 * t101 - 0.24e2 * t659 * t1094 * t101 + 0.21e2 * t393 * t631 - 0.3e1 / 0.2e1 * t635 * t372 * t631 + 0.2e1 * t92 * t1166 + 0.2e1 * t1085 * t105 + 0.6e1 * t376 * t1103 + 0.12e2 * t364 * t404 - 0.1e1 / t634 / t208 * t1094 * t101 / 0.8e1 - t204 * t1085 + 0.8e1 * t376 * t202 * t619 + 0.24e2 * t101 * t371 * t1094 - 0.36e2 * t639 * t372 * t364 + 0.8e1 * t619 * t218
  t1196 = f.my_piecewise3(t64, t1025 + t1083, -0.8e1 / 0.3e1 * t1085 * t108 - 0.32e2 / 0.3e1 * t619 * t221 - 0.16e2 * t364 * t407 - 0.32e2 / 0.3e1 * t202 * t688 - 0.8e1 / 0.3e1 * t92 * t1192)
  t1201 = -0.5e1 / 0.9e1 * t18 * t23 * t225 * t51 + t18 * t230 * t316 / 0.2e1 - t18 * t234 * t692 * t51 / 0.2e1 - 0.3e1 / 0.2e1 * t18 * t701 * t542 - 0.3e1 / 0.2e1 * t18 * t693 * t158 - 0.3e1 / 0.2e1 * t18 * t416 * t316 - 0.9e1 / 0.4e1 * t18 * t697 * t316 - 0.5e1 / 0.9e1 * t18 * t113 * t158 + t18 * t118 * t411 * t51 / 0.2e1 - t18 * t420 * t542 / 0.2e1 - 0.3e1 / 0.8e1 * t18 * t705 * t827 - 0.3e1 / 0.2e1 * t18 * t412 * t158 + t18 * t226 * t158 + 0.10e2 / 0.27e2 * t18 * t131 * t112 * t51 - 0.3e1 / 0.8e1 * t18 * t20 * t1196 * t51
  t1202 = f.my_piecewise3(t2, 0, t1201)
  v4rho4_0_ = 0.2e1 * r0 * t1202 + 0.8e1 * t710

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = t2 ** 2
  t33 = jnp.pi * t32
  t35 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t36 = 0.1e1 / t35
  t37 = 4 ** (0.1e1 / 0.3e1)
  t38 = t36 * t37
  t39 = t32 * t36
  t40 = t39 * t37
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t46 = s0 / t43 / t41
  t47 = jnp.sqrt(s0)
  t50 = t47 / t42 / r0
  t51 = jnp.arcsinh(t50)
  t54 = 0.1e1 + 0.2520e-1 * t50 * t51
  t55 = 0.1e1 / t54
  t59 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t46 * t55
  t62 = t33 * t38 / t59
  t63 = jnp.sqrt(t62)
  t65 = f.p.cam_omega / t63
  t66 = 2 ** (0.1e1 / 0.3e1)
  t67 = t19 * t6
  t68 = t67 ** (0.1e1 / 0.3e1)
  t70 = t66 / t68
  t72 = t65 * t70 / 0.2e1
  t73 = 0.135e1 <= t72
  t74 = 0.135e1 < t72
  t75 = f.my_piecewise3(t74, t72, 0.135e1)
  t76 = t75 ** 2
  t79 = t76 ** 2
  t80 = 0.1e1 / t79
  t82 = t79 * t76
  t83 = 0.1e1 / t82
  t85 = t79 ** 2
  t86 = 0.1e1 / t85
  t89 = 0.1e1 / t85 / t76
  t92 = 0.1e1 / t85 / t79
  t95 = 0.1e1 / t85 / t82
  t97 = t85 ** 2
  t98 = 0.1e1 / t97
  t101 = f.my_piecewise3(t74, 0.135e1, t72)
  t102 = jnp.sqrt(jnp.pi)
  t103 = 0.1e1 / t101
  t105 = jax.lax.erf(t103 / 0.2e1)
  t107 = t101 ** 2
  t108 = 0.1e1 / t107
  t110 = jnp.exp(-t108 / 0.4e1)
  t111 = t110 - 0.1e1
  t114 = t110 - 0.3e1 / 0.2e1 - 0.2e1 * t107 * t111
  t117 = 0.2e1 * t101 * t114 + t102 * t105
  t121 = f.my_piecewise3(t73, 0.1e1 / t76 / 0.36e2 - t80 / 0.960e3 + t83 / 0.26880e5 - t86 / 0.829440e6 + t89 / 0.28385280e8 - t92 / 0.1073479680e10 + t95 / 0.44590694400e11 - t98 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t101 * t117)
  t122 = t31 * t121
  t123 = t122 * t59
  t126 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t127 = t126 * f.p.zeta_threshold
  t129 = f.my_piecewise3(t20, t127, t21 * t19)
  t130 = t5 * t129
  t131 = t31 ** 2
  t132 = 0.1e1 / t131
  t133 = t132 * t121
  t134 = t133 * t59
  t136 = t130 * t134 / 0.8e1
  t137 = t76 * t75
  t138 = 0.1e1 / t137
  t141 = f.p.cam_omega / t63 / t62
  t143 = t141 * t70 * jnp.pi
  t144 = t59 ** 2
  t145 = 0.1e1 / t144
  t146 = t37 * t145
  t147 = t41 * r0
  t150 = s0 / t43 / t147
  t154 = t54 ** 2
  t155 = 0.1e1 / t154
  t161 = t46 + 0.1e1
  t162 = jnp.sqrt(t161)
  t163 = 0.1e1 / t162
  t166 = -0.33600000000000000000000000000000000000000000000000e-1 * t47 / t42 / t41 * t51 - 0.33600000000000000000000000000000000000000000000000e-1 * t150 * t163
  t167 = t155 * t166
  t171 = -0.24888888888888888888888888888888888888888888888889e-2 * t40 * t150 * t55 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t46 * t167
  t172 = t146 * t171
  t178 = t66 / t68 / t67
  t180 = t26 * t6 + t18 + 0.1e1
  t184 = t143 * t39 * t172 / 0.4e1 - t65 * t178 * t180 / 0.6e1
  t185 = f.my_piecewise3(t74, t184, 0)
  t188 = t79 * t75
  t189 = 0.1e1 / t188
  t192 = t79 * t137
  t193 = 0.1e1 / t192
  t197 = 0.1e1 / t85 / t75
  t201 = 0.1e1 / t85 / t137
  t205 = 0.1e1 / t85 / t188
  t209 = 0.1e1 / t85 / t192
  t213 = 0.1e1 / t97 / t75
  t217 = f.my_piecewise3(t74, 0, t184)
  t219 = t110 * t108
  t224 = 0.1e1 / t107 / t101
  t228 = t101 * t111
  t233 = t224 * t217 * t110 / 0.2e1 - 0.4e1 * t228 * t217 - t103 * t217 * t110
  t236 = 0.2e1 * t101 * t233 + 0.2e1 * t217 * t114 - t219 * t217
  t240 = f.my_piecewise3(t73, -t138 * t185 / 0.18e2 + t189 * t185 / 0.240e3 - t193 * t185 / 0.4480e4 + t197 * t185 / 0.103680e6 - t201 * t185 / 0.2838528e7 + t205 * t185 / 0.89456640e8 - t209 * t185 / 0.3185049600e10 + t213 * t185 / 0.126340300800e12, -0.8e1 / 0.3e1 * t101 * t236 - 0.8e1 / 0.3e1 * t217 * t117)
  t241 = t31 * t240
  t242 = t241 * t59
  t245 = t122 * t171
  t249 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t123 - t136 - 0.3e1 / 0.8e1 * t130 * t242 - 0.3e1 / 0.8e1 * t130 * t245)
  t251 = r1 <= f.p.dens_threshold
  t252 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t253 = 0.1e1 + t252
  t254 = t253 <= f.p.zeta_threshold
  t255 = t253 ** (0.1e1 / 0.3e1)
  t257 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t260 = f.my_piecewise3(t254, 0, 0.4e1 / 0.3e1 * t255 * t257)
  t261 = t5 * t260
  t262 = r1 ** 2
  t263 = r1 ** (0.1e1 / 0.3e1)
  t264 = t263 ** 2
  t267 = s2 / t264 / t262
  t268 = jnp.sqrt(s2)
  t271 = t268 / t263 / r1
  t272 = jnp.arcsinh(t271)
  t275 = 0.1e1 + 0.2520e-1 * t271 * t272
  t276 = 0.1e1 / t275
  t280 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t267 * t276
  t283 = t33 * t38 / t280
  t284 = jnp.sqrt(t283)
  t286 = f.p.cam_omega / t284
  t287 = t253 * t6
  t288 = t287 ** (0.1e1 / 0.3e1)
  t290 = t66 / t288
  t292 = t286 * t290 / 0.2e1
  t293 = 0.135e1 <= t292
  t294 = 0.135e1 < t292
  t295 = f.my_piecewise3(t294, t292, 0.135e1)
  t296 = t295 ** 2
  t299 = t296 ** 2
  t300 = 0.1e1 / t299
  t302 = t299 * t296
  t303 = 0.1e1 / t302
  t305 = t299 ** 2
  t306 = 0.1e1 / t305
  t309 = 0.1e1 / t305 / t296
  t312 = 0.1e1 / t305 / t299
  t315 = 0.1e1 / t305 / t302
  t317 = t305 ** 2
  t318 = 0.1e1 / t317
  t321 = f.my_piecewise3(t294, 0.135e1, t292)
  t322 = 0.1e1 / t321
  t324 = jax.lax.erf(t322 / 0.2e1)
  t326 = t321 ** 2
  t327 = 0.1e1 / t326
  t329 = jnp.exp(-t327 / 0.4e1)
  t330 = t329 - 0.1e1
  t333 = t329 - 0.3e1 / 0.2e1 - 0.2e1 * t326 * t330
  t336 = t102 * t324 + 0.2e1 * t321 * t333
  t340 = f.my_piecewise3(t293, 0.1e1 / t296 / 0.36e2 - t300 / 0.960e3 + t303 / 0.26880e5 - t306 / 0.829440e6 + t309 / 0.28385280e8 - t312 / 0.1073479680e10 + t315 / 0.44590694400e11 - t318 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t321 * t336)
  t341 = t31 * t340
  t342 = t341 * t280
  t346 = f.my_piecewise3(t254, t127, t255 * t253)
  t347 = t5 * t346
  t348 = t132 * t340
  t349 = t348 * t280
  t351 = t347 * t349 / 0.8e1
  t352 = t296 * t295
  t353 = 0.1e1 / t352
  t356 = t66 / t288 / t287
  t358 = t257 * t6 + t252 + 0.1e1
  t361 = t286 * t356 * t358 / 0.6e1
  t362 = f.my_piecewise3(t294, -t361, 0)
  t365 = t299 * t295
  t366 = 0.1e1 / t365
  t369 = t299 * t352
  t370 = 0.1e1 / t369
  t374 = 0.1e1 / t305 / t295
  t378 = 0.1e1 / t305 / t352
  t382 = 0.1e1 / t305 / t365
  t386 = 0.1e1 / t305 / t369
  t390 = 0.1e1 / t317 / t295
  t394 = f.my_piecewise3(t294, 0, -t361)
  t396 = t329 * t327
  t401 = 0.1e1 / t326 / t321
  t405 = t321 * t330
  t410 = t401 * t394 * t329 / 0.2e1 - 0.4e1 * t405 * t394 - t322 * t394 * t329
  t413 = 0.2e1 * t321 * t410 + 0.2e1 * t394 * t333 - t396 * t394
  t417 = f.my_piecewise3(t293, -t353 * t362 / 0.18e2 + t366 * t362 / 0.240e3 - t370 * t362 / 0.4480e4 + t374 * t362 / 0.103680e6 - t378 * t362 / 0.2838528e7 + t382 * t362 / 0.89456640e8 - t386 * t362 / 0.3185049600e10 + t390 * t362 / 0.126340300800e12, -0.8e1 / 0.3e1 * t321 * t413 - 0.8e1 / 0.3e1 * t394 * t336)
  t418 = t31 * t417
  t419 = t418 * t280
  t423 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t261 * t342 - t351 - 0.3e1 / 0.8e1 * t347 * t419)
  t425 = t21 ** 2
  t426 = 0.1e1 / t425
  t427 = t26 ** 2
  t432 = t16 / t22 / t6
  t434 = -0.2e1 * t23 + 0.2e1 * t432
  t435 = f.my_piecewise5(t10, 0, t14, 0, t434)
  t439 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t426 * t427 + 0.4e1 / 0.3e1 * t21 * t435)
  t443 = t30 * t134
  t450 = 0.1e1 / t131 / t6
  t454 = t130 * t450 * t121 * t59 / 0.12e2
  t457 = t130 * t132 * t240 * t59
  t460 = t130 * t133 * t171
  t462 = t185 ** 2
  t465 = jnp.pi ** 2
  t466 = t465 * t2
  t467 = t35 ** 2
  t468 = 0.1e1 / t467
  t469 = t37 ** 2
  t470 = t468 * t469
  t479 = t2 * t468
  t480 = t144 ** 2
  t483 = t171 ** 2
  t502 = t41 ** 2
  t505 = s0 / t43 / t502
  t514 = t166 ** 2
  t526 = s0 ** 2
  t540 = 0.91259259259259259259259259259259259259259259259260e-2 * t40 * t505 * t55 + 0.49777777777777777777777777777777777777777777777778e-2 * t40 * t150 * t167 + 0.18666666666666666666666666666666666666666666666666e-2 * t40 * t46 / t154 / t54 * t514 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t46 * t155 * (0.78400000000000000000000000000000000000000000000000e-1 * t47 / t42 / t147 * t51 + 0.16800000000000000000000000000000000000000000000000e0 * t505 * t163 - 0.44800000000000000000000000000000000000000000000000e-1 * t526 / t42 / t502 / t147 / t162 / t161)
  t545 = t19 ** 2
  t548 = 0.1e1 / t68 / t545 / t22
  t549 = t66 * t548
  t550 = t180 ** 2
  t560 = 0.3e1 / 0.8e1 * f.p.cam_omega / t63 / t466 / t470 / t145 * t70 * t465 * t479 * t469 / t480 * t483 - t141 * t178 * jnp.pi * t40 * t145 * t171 * t180 / 0.6e1 - t143 * t39 * t37 / t144 / t59 * t483 / 0.2e1 + t143 * t39 * t146 * t540 / 0.4e1 + 0.2e1 / 0.9e1 * t65 * t549 * t550 - t65 * t178 * (t435 * t6 + 0.2e1 * t26) / 0.6e1
  t561 = f.my_piecewise3(t74, t560, 0)
  t589 = 0.1e1 / t97 / t76
  t594 = t80 * t462 / 0.6e1 - t138 * t561 / 0.18e2 - t83 * t462 / 0.48e2 + t189 * t561 / 0.240e3 + t86 * t462 / 0.640e3 - t193 * t561 / 0.4480e4 - t89 * t462 / 0.11520e5 + t197 * t561 / 0.103680e6 + t92 * t462 / 0.258048e6 - t201 * t561 / 0.2838528e7 - t95 * t462 / 0.6881280e7 + t205 * t561 / 0.89456640e8 + t98 * t462 / 0.212336640e9 - t209 * t561 / 0.3185049600e10 - t589 * t462 / 0.7431782400e10 + t213 * t561 / 0.126340300800e12
  t595 = f.my_piecewise3(t74, 0, t560)
  t600 = t107 ** 2
  t602 = 0.1e1 / t600 / t101
  t603 = t217 ** 2
  t607 = t110 * t224
  t615 = 0.1e1 / t600
  t623 = 0.1e1 / t600 / t107
  t642 = f.my_piecewise3(t73, t594, -0.8e1 / 0.3e1 * t595 * t117 - 0.16e2 / 0.3e1 * t217 * t236 - 0.8e1 / 0.3e1 * t101 * (-t602 * t603 * t110 / 0.2e1 + 0.2e1 * t607 * t603 - t219 * t595 + 0.2e1 * t595 * t114 + 0.4e1 * t217 * t233 + 0.2e1 * t101 * (-0.2e1 * t615 * t603 * t110 + t224 * t595 * t110 / 0.2e1 + t623 * t603 * t110 / 0.4e1 - 0.4e1 * t603 * t111 - t108 * t603 * t110 - 0.4e1 * t228 * t595 - t103 * t595 * t110)))
  t654 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t123 - t443 / 0.4e1 - 0.3e1 / 0.4e1 * t30 * t242 - 0.3e1 / 0.4e1 * t30 * t245 + t454 - t457 / 0.4e1 - t460 / 0.4e1 - 0.3e1 / 0.8e1 * t130 * t31 * t642 * t59 - 0.3e1 / 0.4e1 * t130 * t241 * t171 - 0.3e1 / 0.8e1 * t130 * t122 * t540)
  t655 = t255 ** 2
  t656 = 0.1e1 / t655
  t657 = t257 ** 2
  t661 = f.my_piecewise5(t14, 0, t10, 0, -t434)
  t665 = f.my_piecewise3(t254, 0, 0.4e1 / 0.9e1 * t656 * t657 + 0.4e1 / 0.3e1 * t255 * t661)
  t669 = t261 * t349
  t676 = t347 * t450 * t340 * t280 / 0.12e2
  t679 = t347 * t132 * t417 * t280
  t681 = t362 ** 2
  t684 = t253 ** 2
  t687 = 0.1e1 / t288 / t684 / t22
  t688 = t66 * t687
  t689 = t358 ** 2
  t699 = 0.2e1 / 0.9e1 * t286 * t688 * t689 - t286 * t356 * (t661 * t6 + 0.2e1 * t257) / 0.6e1
  t700 = f.my_piecewise3(t294, t699, 0)
  t728 = 0.1e1 / t317 / t296
  t733 = t300 * t681 / 0.6e1 - t353 * t700 / 0.18e2 - t303 * t681 / 0.48e2 + t366 * t700 / 0.240e3 + t306 * t681 / 0.640e3 - t370 * t700 / 0.4480e4 - t309 * t681 / 0.11520e5 + t374 * t700 / 0.103680e6 + t312 * t681 / 0.258048e6 - t378 * t700 / 0.2838528e7 - t315 * t681 / 0.6881280e7 + t382 * t700 / 0.89456640e8 + t318 * t681 / 0.212336640e9 - t386 * t700 / 0.3185049600e10 - t728 * t681 / 0.7431782400e10 + t390 * t700 / 0.126340300800e12
  t734 = f.my_piecewise3(t294, 0, t699)
  t739 = t326 ** 2
  t741 = 0.1e1 / t739 / t321
  t742 = t394 ** 2
  t746 = t329 * t401
  t754 = 0.1e1 / t739
  t762 = 0.1e1 / t739 / t326
  t781 = f.my_piecewise3(t293, t733, -0.8e1 / 0.3e1 * t734 * t336 - 0.16e2 / 0.3e1 * t394 * t413 - 0.8e1 / 0.3e1 * t321 * (-t741 * t742 * t329 / 0.2e1 + 0.2e1 * t746 * t742 - t396 * t734 + 0.2e1 * t734 * t333 + 0.4e1 * t394 * t410 + 0.2e1 * t321 * (-0.2e1 * t754 * t742 * t329 + t401 * t734 * t329 / 0.2e1 + t762 * t742 * t329 / 0.4e1 - 0.4e1 * t742 * t330 - t327 * t742 * t329 - 0.4e1 * t405 * t734 - t322 * t734 * t329)))
  t787 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t5 * t665 * t342 - t669 / 0.4e1 - 0.3e1 / 0.4e1 * t261 * t419 + t676 - t679 / 0.4e1 - 0.3e1 / 0.8e1 * t347 * t31 * t781 * t280)
  d11 = 0.2e1 * t249 + 0.2e1 * t423 + t6 * (t654 + t787)
  t790 = -t7 - t24
  t791 = f.my_piecewise5(t10, 0, t14, 0, t790)
  t794 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t791)
  t795 = t5 * t794
  t799 = t791 * t6 + t18 + 0.1e1
  t800 = t178 * t799
  t802 = t65 * t800 / 0.6e1
  t803 = f.my_piecewise3(t74, -t802, 0)
  t821 = f.my_piecewise3(t74, 0, -t802)
  t833 = t224 * t821 * t110 / 0.2e1 - 0.4e1 * t228 * t821 - t103 * t821 * t110
  t836 = 0.2e1 * t101 * t833 + 0.2e1 * t821 * t114 - t219 * t821
  t840 = f.my_piecewise3(t73, -t138 * t803 / 0.18e2 + t189 * t803 / 0.240e3 - t193 * t803 / 0.4480e4 + t197 * t803 / 0.103680e6 - t201 * t803 / 0.2838528e7 + t205 * t803 / 0.89456640e8 - t209 * t803 / 0.3185049600e10 + t213 * t803 / 0.126340300800e12, -0.8e1 / 0.3e1 * t101 * t836 - 0.8e1 / 0.3e1 * t821 * t117)
  t841 = t31 * t840
  t842 = t841 * t59
  t846 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t795 * t123 - t136 - 0.3e1 / 0.8e1 * t130 * t842)
  t848 = f.my_piecewise5(t14, 0, t10, 0, -t790)
  t851 = f.my_piecewise3(t254, 0, 0.4e1 / 0.3e1 * t255 * t848)
  t852 = t5 * t851
  t857 = f.p.cam_omega / t284 / t283
  t859 = t857 * t290 * jnp.pi
  t860 = t280 ** 2
  t861 = 0.1e1 / t860
  t862 = t37 * t861
  t863 = t262 * r1
  t866 = s2 / t264 / t863
  t870 = t275 ** 2
  t871 = 0.1e1 / t870
  t877 = t267 + 0.1e1
  t878 = jnp.sqrt(t877)
  t879 = 0.1e1 / t878
  t882 = -0.33600000000000000000000000000000000000000000000000e-1 * t268 / t263 / t262 * t272 - 0.33600000000000000000000000000000000000000000000000e-1 * t866 * t879
  t883 = t871 * t882
  t887 = -0.24888888888888888888888888888888888888888888888889e-2 * t40 * t866 * t276 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t267 * t883
  t893 = t848 * t6 + t252 + 0.1e1
  t897 = t859 * t39 * t862 * t887 / 0.4e1 - t286 * t356 * t893 / 0.6e1
  t898 = f.my_piecewise3(t294, t897, 0)
  t916 = f.my_piecewise3(t294, 0, t897)
  t928 = t401 * t916 * t329 / 0.2e1 - 0.4e1 * t405 * t916 - t322 * t916 * t329
  t931 = 0.2e1 * t321 * t928 + 0.2e1 * t916 * t333 - t396 * t916
  t935 = f.my_piecewise3(t293, -t353 * t898 / 0.18e2 + t366 * t898 / 0.240e3 - t370 * t898 / 0.4480e4 + t374 * t898 / 0.103680e6 - t378 * t898 / 0.2838528e7 + t382 * t898 / 0.89456640e8 - t386 * t898 / 0.3185049600e10 + t390 * t898 / 0.126340300800e12, -0.8e1 / 0.3e1 * t321 * t931 - 0.8e1 / 0.3e1 * t916 * t336)
  t936 = t31 * t935
  t937 = t936 * t280
  t940 = t341 * t887
  t944 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t852 * t342 - t351 - 0.3e1 / 0.8e1 * t347 * t937 - 0.3e1 / 0.8e1 * t347 * t940)
  t948 = 0.2e1 * t432
  t949 = f.my_piecewise5(t10, 0, t14, 0, t948)
  t953 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t426 * t791 * t26 + 0.4e1 / 0.3e1 * t21 * t949)
  t957 = t795 * t134
  t970 = t130 * t132 * t840 * t59
  t990 = -t141 * t800 * t33 * t36 * t172 / 0.12e2 + 0.2e1 / 0.9e1 * t65 * t66 * t548 * t799 * t180 - t65 * t178 * (t949 * t6 + t26 + t791) / 0.6e1
  t991 = f.my_piecewise3(t74, t990, 0)
  t1029 = t80 * t803 * t185 / 0.6e1 - t138 * t991 / 0.18e2 - t83 * t803 * t185 / 0.48e2 + t189 * t991 / 0.240e3 + t86 * t803 * t185 / 0.640e3 - t193 * t991 / 0.4480e4 - t89 * t803 * t185 / 0.11520e5 + t197 * t991 / 0.103680e6 + t92 * t803 * t185 / 0.258048e6 - t201 * t991 / 0.2838528e7 - t95 * t803 * t185 / 0.6881280e7 + t205 * t991 / 0.89456640e8 + t98 * t803 * t185 / 0.212336640e9 - t209 * t991 / 0.3185049600e10 - t589 * t803 * t185 / 0.7431782400e10 + t213 * t991 / 0.126340300800e12
  t1030 = f.my_piecewise3(t74, 0, t990)
  t1035 = t110 * t821
  t1049 = t110 * t217
  t1074 = f.my_piecewise3(t73, t1029, -0.8e1 / 0.3e1 * t1030 * t117 - 0.8e1 / 0.3e1 * t821 * t236 - 0.8e1 / 0.3e1 * t217 * t836 - 0.8e1 / 0.3e1 * t101 * (-t602 * t217 * t1035 / 0.2e1 + 0.2e1 * t607 * t821 * t217 - t219 * t1030 + 0.2e1 * t1030 * t114 + 0.2e1 * t821 * t233 + 0.2e1 * t217 * t833 + 0.2e1 * t101 * (-0.2e1 * t615 * t821 * t1049 + t224 * t1030 * t110 / 0.2e1 + t623 * t821 * t1049 / 0.4e1 - 0.4e1 * t217 * t111 * t821 - t108 * t217 * t1035 - 0.4e1 * t228 * t1030 - t103 * t1030 * t110)))
  t1082 = -0.3e1 / 0.8e1 * t5 * t953 * t123 - t957 / 0.8e1 - 0.3e1 / 0.8e1 * t795 * t242 - 0.3e1 / 0.8e1 * t795 * t245 - t443 / 0.8e1 + t454 - t457 / 0.8e1 - t460 / 0.8e1 - 0.3e1 / 0.8e1 * t30 * t842 - t970 / 0.8e1 - 0.3e1 / 0.8e1 * t130 * t31 * t1074 * t59 - 0.3e1 / 0.8e1 * t130 * t841 * t171
  t1083 = f.my_piecewise3(t1, 0, t1082)
  t1087 = f.my_piecewise5(t14, 0, t10, 0, -t948)
  t1091 = f.my_piecewise3(t254, 0, 0.4e1 / 0.9e1 * t656 * t848 * t257 + 0.4e1 / 0.3e1 * t255 * t1087)
  t1095 = t852 * t349
  t1105 = t347 * t132 * t935 * t280
  t1111 = t857 * t356 * jnp.pi
  t1112 = t861 * t887
  t1127 = -t1111 * t40 * t1112 * t358 / 0.12e2 + 0.2e1 / 0.9e1 * t286 * t66 * t687 * t893 * t358 - t286 * t356 * (t1087 * t6 + t257 + t848) / 0.6e1
  t1128 = f.my_piecewise3(t294, t1127, 0)
  t1166 = t300 * t898 * t362 / 0.6e1 - t353 * t1128 / 0.18e2 - t303 * t898 * t362 / 0.48e2 + t366 * t1128 / 0.240e3 + t306 * t898 * t362 / 0.640e3 - t370 * t1128 / 0.4480e4 - t309 * t898 * t362 / 0.11520e5 + t374 * t1128 / 0.103680e6 + t312 * t898 * t362 / 0.258048e6 - t378 * t1128 / 0.2838528e7 - t315 * t898 * t362 / 0.6881280e7 + t382 * t1128 / 0.89456640e8 + t318 * t898 * t362 / 0.212336640e9 - t386 * t1128 / 0.3185049600e10 - t728 * t898 * t362 / 0.7431782400e10 + t390 * t1128 / 0.126340300800e12
  t1167 = f.my_piecewise3(t294, 0, t1127)
  t1172 = t329 * t916
  t1186 = t329 * t394
  t1211 = f.my_piecewise3(t293, t1166, -0.8e1 / 0.3e1 * t1167 * t336 - 0.8e1 / 0.3e1 * t916 * t413 - 0.8e1 / 0.3e1 * t394 * t931 - 0.8e1 / 0.3e1 * t321 * (-t741 * t394 * t1172 / 0.2e1 + 0.2e1 * t746 * t916 * t394 - t396 * t1167 + 0.2e1 * t1167 * t333 + 0.2e1 * t916 * t410 + 0.2e1 * t394 * t928 + 0.2e1 * t321 * (-0.2e1 * t754 * t916 * t1186 + t401 * t1167 * t329 / 0.2e1 + t762 * t916 * t1186 / 0.4e1 - 0.4e1 * t394 * t330 * t916 - t327 * t394 * t1172 - 0.4e1 * t405 * t1167 - t322 * t1167 * t329)))
  t1219 = t347 * t348 * t887
  t1224 = -0.3e1 / 0.8e1 * t5 * t1091 * t342 - t1095 / 0.8e1 - 0.3e1 / 0.8e1 * t852 * t419 - t669 / 0.8e1 + t676 - t679 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t937 - t1105 / 0.8e1 - 0.3e1 / 0.8e1 * t347 * t31 * t1211 * t280 - 0.3e1 / 0.8e1 * t261 * t940 - t1219 / 0.8e1 - 0.3e1 / 0.8e1 * t347 * t418 * t887
  t1225 = f.my_piecewise3(t251, 0, t1224)
  d12 = t249 + t423 + t846 + t944 + t6 * (t1083 + t1225)
  t1230 = t791 ** 2
  t1234 = 0.2e1 * t23 + 0.2e1 * t432
  t1235 = f.my_piecewise5(t10, 0, t14, 0, t1234)
  t1239 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t426 * t1230 + 0.4e1 / 0.3e1 * t21 * t1235)
  t1247 = t803 ** 2
  t1250 = t799 ** 2
  t1260 = 0.2e1 / 0.9e1 * t65 * t549 * t1250 - t65 * t178 * (t1235 * t6 + 0.2e1 * t791) / 0.6e1
  t1261 = f.my_piecewise3(t74, t1260, 0)
  t1292 = t80 * t1247 / 0.6e1 - t138 * t1261 / 0.18e2 - t83 * t1247 / 0.48e2 + t189 * t1261 / 0.240e3 + t86 * t1247 / 0.640e3 - t193 * t1261 / 0.4480e4 - t89 * t1247 / 0.11520e5 + t197 * t1261 / 0.103680e6 + t92 * t1247 / 0.258048e6 - t201 * t1261 / 0.2838528e7 - t95 * t1247 / 0.6881280e7 + t205 * t1261 / 0.89456640e8 + t98 * t1247 / 0.212336640e9 - t209 * t1261 / 0.3185049600e10 - t589 * t1247 / 0.7431782400e10 + t213 * t1261 / 0.126340300800e12
  t1293 = f.my_piecewise3(t74, 0, t1260)
  t1298 = t821 ** 2
  t1333 = f.my_piecewise3(t73, t1292, -0.8e1 / 0.3e1 * t1293 * t117 - 0.16e2 / 0.3e1 * t821 * t836 - 0.8e1 / 0.3e1 * t101 * (-t602 * t1298 * t110 / 0.2e1 + 0.2e1 * t607 * t1298 - t219 * t1293 + 0.2e1 * t1293 * t114 + 0.4e1 * t821 * t833 + 0.2e1 * t101 * (-0.2e1 * t615 * t1298 * t110 + t224 * t1293 * t110 / 0.2e1 + t623 * t1298 * t110 / 0.4e1 - 0.4e1 * t1298 * t111 - t108 * t1298 * t110 - 0.4e1 * t228 * t1293 - t103 * t1293 * t110)))
  t1339 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1239 * t123 - t957 / 0.4e1 - 0.3e1 / 0.4e1 * t795 * t842 + t454 - t970 / 0.4e1 - 0.3e1 / 0.8e1 * t130 * t31 * t1333 * t59)
  t1340 = t848 ** 2
  t1344 = f.my_piecewise5(t14, 0, t10, 0, -t1234)
  t1348 = f.my_piecewise3(t254, 0, 0.4e1 / 0.9e1 * t656 * t1340 + 0.4e1 / 0.3e1 * t255 * t1344)
  t1359 = t898 ** 2
  t1370 = t860 ** 2
  t1373 = t887 ** 2
  t1389 = t262 ** 2
  t1392 = s2 / t264 / t1389
  t1401 = t882 ** 2
  t1413 = s2 ** 2
  t1427 = 0.91259259259259259259259259259259259259259259259260e-2 * t40 * t1392 * t276 + 0.49777777777777777777777777777777777777777777777778e-2 * t40 * t866 * t883 + 0.18666666666666666666666666666666666666666666666666e-2 * t40 * t267 / t870 / t275 * t1401 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t267 * t871 * (0.78400000000000000000000000000000000000000000000000e-1 * t268 / t263 / t863 * t272 + 0.16800000000000000000000000000000000000000000000000e0 * t1392 * t879 - 0.44800000000000000000000000000000000000000000000000e-1 * t1413 / t263 / t1389 / t863 / t878 / t877)
  t1432 = t893 ** 2
  t1442 = 0.3e1 / 0.8e1 * f.p.cam_omega / t284 / t466 / t470 / t861 * t290 * t465 * t479 * t469 / t1370 * t1373 - t1111 * t40 * t1112 * t893 / 0.6e1 - t859 * t39 * t37 / t860 / t280 * t1373 / 0.2e1 + t859 * t39 * t862 * t1427 / 0.4e1 + 0.2e1 / 0.9e1 * t286 * t688 * t1432 - t286 * t356 * (t1344 * t6 + 0.2e1 * t848) / 0.6e1
  t1443 = f.my_piecewise3(t294, t1442, 0)
  t1474 = t300 * t1359 / 0.6e1 - t353 * t1443 / 0.18e2 - t303 * t1359 / 0.48e2 + t366 * t1443 / 0.240e3 + t306 * t1359 / 0.640e3 - t370 * t1443 / 0.4480e4 - t309 * t1359 / 0.11520e5 + t374 * t1443 / 0.103680e6 + t312 * t1359 / 0.258048e6 - t378 * t1443 / 0.2838528e7 - t315 * t1359 / 0.6881280e7 + t382 * t1443 / 0.89456640e8 + t318 * t1359 / 0.212336640e9 - t386 * t1443 / 0.3185049600e10 - t728 * t1359 / 0.7431782400e10 + t390 * t1443 / 0.126340300800e12
  t1475 = f.my_piecewise3(t294, 0, t1442)
  t1480 = t916 ** 2
  t1515 = f.my_piecewise3(t293, t1474, -0.8e1 / 0.3e1 * t1475 * t336 - 0.16e2 / 0.3e1 * t916 * t931 - 0.8e1 / 0.3e1 * t321 * (-t741 * t1480 * t329 / 0.2e1 + 0.2e1 * t746 * t1480 - t396 * t1475 + 0.2e1 * t1475 * t333 + 0.4e1 * t916 * t928 + 0.2e1 * t321 * (-0.2e1 * t754 * t1480 * t329 + t401 * t1475 * t329 / 0.2e1 + t762 * t1480 * t329 / 0.4e1 - 0.4e1 * t1480 * t330 - t327 * t1480 * t329 - 0.4e1 * t405 * t1475 - t322 * t1475 * t329)))
  t1527 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t5 * t1348 * t342 - t1095 / 0.4e1 - 0.3e1 / 0.4e1 * t852 * t937 - 0.3e1 / 0.4e1 * t852 * t940 + t676 - t1105 / 0.4e1 - t1219 / 0.4e1 - 0.3e1 / 0.8e1 * t347 * t31 * t1515 * t280 - 0.3e1 / 0.4e1 * t347 * t936 * t887 - 0.3e1 / 0.8e1 * t347 * t341 * t1427)
  d22 = 0.2e1 * t846 + 0.2e1 * t944 + t6 * (t1339 + t1527)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = t2 ** 2
  t33 = jnp.pi * t32
  t35 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t36 = 0.1e1 / t35
  t37 = 4 ** (0.1e1 / 0.3e1)
  t38 = t36 * t37
  t39 = t32 * t36
  t40 = t39 * t37
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t46 = s0 / t43 / t41
  t47 = jnp.sqrt(s0)
  t50 = t47 / t42 / r0
  t51 = jnp.arcsinh(t50)
  t54 = 0.1e1 + 0.2520e-1 * t50 * t51
  t55 = 0.1e1 / t54
  t59 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t46 * t55
  t62 = t33 * t38 / t59
  t63 = jnp.sqrt(t62)
  t65 = f.p.cam_omega / t63
  t66 = 2 ** (0.1e1 / 0.3e1)
  t67 = t19 * t6
  t68 = t67 ** (0.1e1 / 0.3e1)
  t70 = t66 / t68
  t72 = t65 * t70 / 0.2e1
  t73 = 0.135e1 <= t72
  t74 = 0.135e1 < t72
  t75 = f.my_piecewise3(t74, t72, 0.135e1)
  t76 = t75 ** 2
  t79 = t76 ** 2
  t80 = 0.1e1 / t79
  t82 = t79 * t76
  t83 = 0.1e1 / t82
  t85 = t79 ** 2
  t86 = 0.1e1 / t85
  t89 = 0.1e1 / t85 / t76
  t92 = 0.1e1 / t85 / t79
  t95 = 0.1e1 / t85 / t82
  t97 = t85 ** 2
  t98 = 0.1e1 / t97
  t101 = f.my_piecewise3(t74, 0.135e1, t72)
  t102 = jnp.sqrt(jnp.pi)
  t103 = 0.1e1 / t101
  t105 = jax.lax.erf(t103 / 0.2e1)
  t107 = t101 ** 2
  t108 = 0.1e1 / t107
  t110 = jnp.exp(-t108 / 0.4e1)
  t111 = t110 - 0.1e1
  t114 = t110 - 0.3e1 / 0.2e1 - 0.2e1 * t107 * t111
  t117 = 0.2e1 * t101 * t114 + t102 * t105
  t121 = f.my_piecewise3(t73, 0.1e1 / t76 / 0.36e2 - t80 / 0.960e3 + t83 / 0.26880e5 - t86 / 0.829440e6 + t89 / 0.28385280e8 - t92 / 0.1073479680e10 + t95 / 0.44590694400e11 - t98 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t101 * t117)
  t122 = t31 * t121
  t123 = t122 * t59
  t126 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t127 = t126 * f.p.zeta_threshold
  t129 = f.my_piecewise3(t20, t127, t21 * t19)
  t130 = t5 * t129
  t131 = t31 ** 2
  t132 = 0.1e1 / t131
  t133 = t132 * t121
  t134 = t133 * t59
  t136 = t130 * t134 / 0.8e1
  t137 = t76 * t75
  t138 = 0.1e1 / t137
  t141 = f.p.cam_omega / t63 / t62
  t143 = t141 * t70 * jnp.pi
  t144 = t59 ** 2
  t145 = 0.1e1 / t144
  t146 = t37 * t145
  t147 = t41 * r0
  t150 = s0 / t43 / t147
  t154 = t54 ** 2
  t155 = 0.1e1 / t154
  t161 = t46 + 0.1e1
  t162 = jnp.sqrt(t161)
  t163 = 0.1e1 / t162
  t166 = -0.33600000000000000000000000000000000000000000000000e-1 * t47 / t42 / t41 * t51 - 0.33600000000000000000000000000000000000000000000000e-1 * t150 * t163
  t167 = t155 * t166
  t171 = -0.24888888888888888888888888888888888888888888888889e-2 * t40 * t150 * t55 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t46 * t167
  t172 = t146 * t171
  t178 = t66 / t68 / t67
  t180 = t26 * t6 + t18 + 0.1e1
  t184 = t143 * t39 * t172 / 0.4e1 - t65 * t178 * t180 / 0.6e1
  t185 = f.my_piecewise3(t74, t184, 0)
  t188 = t79 * t75
  t189 = 0.1e1 / t188
  t192 = t79 * t137
  t193 = 0.1e1 / t192
  t197 = 0.1e1 / t85 / t75
  t201 = 0.1e1 / t85 / t137
  t205 = 0.1e1 / t85 / t188
  t209 = 0.1e1 / t85 / t192
  t213 = 0.1e1 / t97 / t75
  t217 = f.my_piecewise3(t74, 0, t184)
  t219 = t110 * t108
  t224 = 0.1e1 / t107 / t101
  t228 = t101 * t111
  t233 = t224 * t217 * t110 / 0.2e1 - 0.4e1 * t228 * t217 - t103 * t217 * t110
  t236 = 0.2e1 * t101 * t233 + 0.2e1 * t217 * t114 - t219 * t217
  t240 = f.my_piecewise3(t73, -t138 * t185 / 0.18e2 + t189 * t185 / 0.240e3 - t193 * t185 / 0.4480e4 + t197 * t185 / 0.103680e6 - t201 * t185 / 0.2838528e7 + t205 * t185 / 0.89456640e8 - t209 * t185 / 0.3185049600e10 + t213 * t185 / 0.126340300800e12, -0.8e1 / 0.3e1 * t101 * t236 - 0.8e1 / 0.3e1 * t217 * t117)
  t241 = t31 * t240
  t242 = t241 * t59
  t245 = t122 * t171
  t249 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t123 - t136 - 0.3e1 / 0.8e1 * t130 * t242 - 0.3e1 / 0.8e1 * t130 * t245)
  t251 = r1 <= f.p.dens_threshold
  t252 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t253 = 0.1e1 + t252
  t254 = t253 <= f.p.zeta_threshold
  t255 = t253 ** (0.1e1 / 0.3e1)
  t257 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t260 = f.my_piecewise3(t254, 0, 0.4e1 / 0.3e1 * t255 * t257)
  t261 = t5 * t260
  t262 = r1 ** 2
  t263 = r1 ** (0.1e1 / 0.3e1)
  t264 = t263 ** 2
  t267 = s2 / t264 / t262
  t268 = jnp.sqrt(s2)
  t271 = t268 / t263 / r1
  t272 = jnp.arcsinh(t271)
  t275 = 0.1e1 + 0.2520e-1 * t271 * t272
  t276 = 0.1e1 / t275
  t280 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t267 * t276
  t283 = t33 * t38 / t280
  t284 = jnp.sqrt(t283)
  t286 = f.p.cam_omega / t284
  t287 = t253 * t6
  t288 = t287 ** (0.1e1 / 0.3e1)
  t290 = t66 / t288
  t292 = t286 * t290 / 0.2e1
  t293 = 0.135e1 <= t292
  t294 = 0.135e1 < t292
  t295 = f.my_piecewise3(t294, t292, 0.135e1)
  t296 = t295 ** 2
  t299 = t296 ** 2
  t300 = 0.1e1 / t299
  t302 = t299 * t296
  t303 = 0.1e1 / t302
  t305 = t299 ** 2
  t306 = 0.1e1 / t305
  t309 = 0.1e1 / t305 / t296
  t312 = 0.1e1 / t305 / t299
  t315 = 0.1e1 / t305 / t302
  t317 = t305 ** 2
  t318 = 0.1e1 / t317
  t321 = f.my_piecewise3(t294, 0.135e1, t292)
  t322 = 0.1e1 / t321
  t324 = jax.lax.erf(t322 / 0.2e1)
  t326 = t321 ** 2
  t327 = 0.1e1 / t326
  t329 = jnp.exp(-t327 / 0.4e1)
  t330 = t329 - 0.1e1
  t333 = t329 - 0.3e1 / 0.2e1 - 0.2e1 * t326 * t330
  t336 = t102 * t324 + 0.2e1 * t321 * t333
  t340 = f.my_piecewise3(t293, 0.1e1 / t296 / 0.36e2 - t300 / 0.960e3 + t303 / 0.26880e5 - t306 / 0.829440e6 + t309 / 0.28385280e8 - t312 / 0.1073479680e10 + t315 / 0.44590694400e11 - t318 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t321 * t336)
  t341 = t31 * t340
  t342 = t341 * t280
  t346 = f.my_piecewise3(t254, t127, t255 * t253)
  t347 = t5 * t346
  t348 = t132 * t340
  t349 = t348 * t280
  t351 = t347 * t349 / 0.8e1
  t352 = t296 * t295
  t353 = 0.1e1 / t352
  t356 = t66 / t288 / t287
  t358 = t257 * t6 + t252 + 0.1e1
  t361 = t286 * t356 * t358 / 0.6e1
  t362 = f.my_piecewise3(t294, -t361, 0)
  t365 = t299 * t295
  t366 = 0.1e1 / t365
  t369 = t299 * t352
  t370 = 0.1e1 / t369
  t374 = 0.1e1 / t305 / t295
  t378 = 0.1e1 / t305 / t352
  t382 = 0.1e1 / t305 / t365
  t386 = 0.1e1 / t305 / t369
  t390 = 0.1e1 / t317 / t295
  t394 = f.my_piecewise3(t294, 0, -t361)
  t396 = t329 * t327
  t401 = 0.1e1 / t326 / t321
  t405 = t321 * t330
  t410 = t401 * t394 * t329 / 0.2e1 - 0.4e1 * t405 * t394 - t322 * t394 * t329
  t413 = 0.2e1 * t321 * t410 + 0.2e1 * t394 * t333 - t396 * t394
  t417 = f.my_piecewise3(t293, -t353 * t362 / 0.18e2 + t366 * t362 / 0.240e3 - t370 * t362 / 0.4480e4 + t374 * t362 / 0.103680e6 - t378 * t362 / 0.2838528e7 + t382 * t362 / 0.89456640e8 - t386 * t362 / 0.3185049600e10 + t390 * t362 / 0.126340300800e12, -0.8e1 / 0.3e1 * t321 * t413 - 0.8e1 / 0.3e1 * t394 * t336)
  t418 = t31 * t417
  t419 = t418 * t280
  t423 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t261 * t342 - t351 - 0.3e1 / 0.8e1 * t347 * t419)
  t425 = t21 ** 2
  t426 = 0.1e1 / t425
  t427 = t26 ** 2
  t432 = t16 / t22 / t6
  t434 = -0.2e1 * t23 + 0.2e1 * t432
  t435 = f.my_piecewise5(t10, 0, t14, 0, t434)
  t439 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t426 * t427 + 0.4e1 / 0.3e1 * t21 * t435)
  t443 = t30 * t134
  t450 = 0.1e1 / t131 / t6
  t454 = t130 * t450 * t121 * t59 / 0.12e2
  t457 = t130 * t132 * t240 * t59
  t460 = t130 * t133 * t171
  t462 = t185 ** 2
  t465 = jnp.pi ** 2
  t466 = t465 * t2
  t467 = t35 ** 2
  t468 = 0.1e1 / t467
  t469 = t37 ** 2
  t470 = t468 * t469
  t479 = t2 * t468
  t480 = t144 ** 2
  t483 = t171 ** 2
  t502 = t41 ** 2
  t505 = s0 / t43 / t502
  t514 = t166 ** 2
  t526 = s0 ** 2
  t540 = 0.91259259259259259259259259259259259259259259259260e-2 * t40 * t505 * t55 + 0.49777777777777777777777777777777777777777777777778e-2 * t40 * t150 * t167 + 0.18666666666666666666666666666666666666666666666666e-2 * t40 * t46 / t154 / t54 * t514 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t46 * t155 * (0.78400000000000000000000000000000000000000000000000e-1 * t47 / t42 / t147 * t51 + 0.16800000000000000000000000000000000000000000000000e0 * t505 * t163 - 0.44800000000000000000000000000000000000000000000000e-1 * t526 / t42 / t502 / t147 / t162 / t161)
  t545 = t19 ** 2
  t548 = 0.1e1 / t68 / t545 / t22
  t549 = t66 * t548
  t550 = t180 ** 2
  t560 = 0.3e1 / 0.8e1 * f.p.cam_omega / t63 / t466 / t470 / t145 * t70 * t465 * t479 * t469 / t480 * t483 - t141 * t178 * jnp.pi * t40 * t145 * t171 * t180 / 0.6e1 - t143 * t39 * t37 / t144 / t59 * t483 / 0.2e1 + t143 * t39 * t146 * t540 / 0.4e1 + 0.2e1 / 0.9e1 * t65 * t549 * t550 - t65 * t178 * (t435 * t6 + 0.2e1 * t26) / 0.6e1
  t561 = f.my_piecewise3(t74, t560, 0)
  t589 = 0.1e1 / t97 / t76
  t594 = t80 * t462 / 0.6e1 - t138 * t561 / 0.18e2 - t83 * t462 / 0.48e2 + t189 * t561 / 0.240e3 + t86 * t462 / 0.640e3 - t193 * t561 / 0.4480e4 - t89 * t462 / 0.11520e5 + t197 * t561 / 0.103680e6 + t92 * t462 / 0.258048e6 - t201 * t561 / 0.2838528e7 - t95 * t462 / 0.6881280e7 + t205 * t561 / 0.89456640e8 + t98 * t462 / 0.212336640e9 - t209 * t561 / 0.3185049600e10 - t589 * t462 / 0.7431782400e10 + t213 * t561 / 0.126340300800e12
  t595 = f.my_piecewise3(t74, 0, t560)
  t600 = t107 ** 2
  t602 = 0.1e1 / t600 / t101
  t603 = t217 ** 2
  t607 = t110 * t224
  t615 = 0.1e1 / t600
  t623 = 0.1e1 / t600 / t107
  t642 = f.my_piecewise3(t73, t594, -0.8e1 / 0.3e1 * t595 * t117 - 0.16e2 / 0.3e1 * t217 * t236 - 0.8e1 / 0.3e1 * t101 * (-t602 * t603 * t110 / 0.2e1 + 0.2e1 * t607 * t603 - t219 * t595 + 0.2e1 * t595 * t114 + 0.4e1 * t217 * t233 + 0.2e1 * t101 * (-0.2e1 * t615 * t603 * t110 + t224 * t595 * t110 / 0.2e1 + t623 * t603 * t110 / 0.4e1 - 0.4e1 * t603 * t111 - t108 * t603 * t110 - 0.4e1 * t228 * t595 - t103 * t595 * t110)))
  t654 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t439 * t123 - t443 / 0.4e1 - 0.3e1 / 0.4e1 * t30 * t242 - 0.3e1 / 0.4e1 * t30 * t245 + t454 - t457 / 0.4e1 - t460 / 0.4e1 - 0.3e1 / 0.8e1 * t130 * t31 * t642 * t59 - 0.3e1 / 0.4e1 * t130 * t241 * t171 - 0.3e1 / 0.8e1 * t130 * t122 * t540)
  t655 = t255 ** 2
  t656 = 0.1e1 / t655
  t657 = t257 ** 2
  t661 = f.my_piecewise5(t14, 0, t10, 0, -t434)
  t665 = f.my_piecewise3(t254, 0, 0.4e1 / 0.9e1 * t656 * t657 + 0.4e1 / 0.3e1 * t255 * t661)
  t669 = t261 * t349
  t676 = t347 * t450 * t340 * t280 / 0.12e2
  t679 = t347 * t132 * t417 * t280
  t681 = t362 ** 2
  t684 = t253 ** 2
  t687 = 0.1e1 / t288 / t684 / t22
  t688 = t66 * t687
  t689 = t358 ** 2
  t699 = 0.2e1 / 0.9e1 * t286 * t688 * t689 - t286 * t356 * (t661 * t6 + 0.2e1 * t257) / 0.6e1
  t700 = f.my_piecewise3(t294, t699, 0)
  t728 = 0.1e1 / t317 / t296
  t733 = t300 * t681 / 0.6e1 - t353 * t700 / 0.18e2 - t303 * t681 / 0.48e2 + t366 * t700 / 0.240e3 + t306 * t681 / 0.640e3 - t370 * t700 / 0.4480e4 - t309 * t681 / 0.11520e5 + t374 * t700 / 0.103680e6 + t312 * t681 / 0.258048e6 - t378 * t700 / 0.2838528e7 - t315 * t681 / 0.6881280e7 + t382 * t700 / 0.89456640e8 + t318 * t681 / 0.212336640e9 - t386 * t700 / 0.3185049600e10 - t728 * t681 / 0.7431782400e10 + t390 * t700 / 0.126340300800e12
  t734 = f.my_piecewise3(t294, 0, t699)
  t739 = t326 ** 2
  t741 = 0.1e1 / t739 / t321
  t742 = t394 ** 2
  t746 = t329 * t401
  t754 = 0.1e1 / t739
  t762 = 0.1e1 / t739 / t326
  t781 = f.my_piecewise3(t293, t733, -0.8e1 / 0.3e1 * t734 * t336 - 0.16e2 / 0.3e1 * t394 * t413 - 0.8e1 / 0.3e1 * t321 * (-t741 * t742 * t329 / 0.2e1 + 0.2e1 * t746 * t742 - t396 * t734 + 0.2e1 * t734 * t333 + 0.4e1 * t394 * t410 + 0.2e1 * t321 * (-0.2e1 * t754 * t742 * t329 + t401 * t734 * t329 / 0.2e1 + t762 * t742 * t329 / 0.4e1 - 0.4e1 * t742 * t330 - t327 * t742 * t329 - 0.4e1 * t405 * t734 - t322 * t734 * t329)))
  t787 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t5 * t665 * t342 - t669 / 0.4e1 - 0.3e1 / 0.4e1 * t261 * t419 + t676 - t679 / 0.4e1 - 0.3e1 / 0.8e1 * t347 * t31 * t781 * t280)
  d11 = 0.2e1 * t249 + 0.2e1 * t423 + t6 * (t654 + t787)
  t790 = -t7 - t24
  t791 = f.my_piecewise5(t10, 0, t14, 0, t790)
  t794 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t791)
  t795 = t5 * t794
  t799 = t791 * t6 + t18 + 0.1e1
  t800 = t178 * t799
  t802 = t65 * t800 / 0.6e1
  t803 = f.my_piecewise3(t74, -t802, 0)
  t821 = f.my_piecewise3(t74, 0, -t802)
  t833 = t224 * t821 * t110 / 0.2e1 - 0.4e1 * t228 * t821 - t103 * t821 * t110
  t836 = 0.2e1 * t101 * t833 + 0.2e1 * t821 * t114 - t219 * t821
  t840 = f.my_piecewise3(t73, -t138 * t803 / 0.18e2 + t189 * t803 / 0.240e3 - t193 * t803 / 0.4480e4 + t197 * t803 / 0.103680e6 - t201 * t803 / 0.2838528e7 + t205 * t803 / 0.89456640e8 - t209 * t803 / 0.3185049600e10 + t213 * t803 / 0.126340300800e12, -0.8e1 / 0.3e1 * t101 * t836 - 0.8e1 / 0.3e1 * t821 * t117)
  t841 = t31 * t840
  t842 = t841 * t59
  t846 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t795 * t123 - t136 - 0.3e1 / 0.8e1 * t130 * t842)
  t848 = f.my_piecewise5(t14, 0, t10, 0, -t790)
  t851 = f.my_piecewise3(t254, 0, 0.4e1 / 0.3e1 * t255 * t848)
  t852 = t5 * t851
  t857 = f.p.cam_omega / t284 / t283
  t859 = t857 * t290 * jnp.pi
  t860 = t280 ** 2
  t861 = 0.1e1 / t860
  t862 = t37 * t861
  t863 = t262 * r1
  t866 = s2 / t264 / t863
  t870 = t275 ** 2
  t871 = 0.1e1 / t870
  t877 = t267 + 0.1e1
  t878 = jnp.sqrt(t877)
  t879 = 0.1e1 / t878
  t882 = -0.33600000000000000000000000000000000000000000000000e-1 * t268 / t263 / t262 * t272 - 0.33600000000000000000000000000000000000000000000000e-1 * t866 * t879
  t883 = t871 * t882
  t887 = -0.24888888888888888888888888888888888888888888888889e-2 * t40 * t866 * t276 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t267 * t883
  t893 = t848 * t6 + t252 + 0.1e1
  t897 = t859 * t39 * t862 * t887 / 0.4e1 - t286 * t356 * t893 / 0.6e1
  t898 = f.my_piecewise3(t294, t897, 0)
  t916 = f.my_piecewise3(t294, 0, t897)
  t928 = t401 * t916 * t329 / 0.2e1 - 0.4e1 * t405 * t916 - t322 * t916 * t329
  t931 = 0.2e1 * t321 * t928 + 0.2e1 * t916 * t333 - t396 * t916
  t935 = f.my_piecewise3(t293, -t353 * t898 / 0.18e2 + t366 * t898 / 0.240e3 - t370 * t898 / 0.4480e4 + t374 * t898 / 0.103680e6 - t378 * t898 / 0.2838528e7 + t382 * t898 / 0.89456640e8 - t386 * t898 / 0.3185049600e10 + t390 * t898 / 0.126340300800e12, -0.8e1 / 0.3e1 * t321 * t931 - 0.8e1 / 0.3e1 * t916 * t336)
  t936 = t31 * t935
  t937 = t936 * t280
  t940 = t341 * t887
  t944 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t852 * t342 - t351 - 0.3e1 / 0.8e1 * t347 * t937 - 0.3e1 / 0.8e1 * t347 * t940)
  t948 = 0.2e1 * t432
  t949 = f.my_piecewise5(t10, 0, t14, 0, t948)
  t953 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t426 * t791 * t26 + 0.4e1 / 0.3e1 * t21 * t949)
  t957 = t795 * t134
  t970 = t130 * t132 * t840 * t59
  t990 = -t141 * t800 * t33 * t36 * t172 / 0.12e2 + 0.2e1 / 0.9e1 * t65 * t66 * t548 * t799 * t180 - t65 * t178 * (t949 * t6 + t26 + t791) / 0.6e1
  t991 = f.my_piecewise3(t74, t990, 0)
  t1029 = t80 * t803 * t185 / 0.6e1 - t138 * t991 / 0.18e2 - t83 * t803 * t185 / 0.48e2 + t189 * t991 / 0.240e3 + t86 * t803 * t185 / 0.640e3 - t193 * t991 / 0.4480e4 - t89 * t803 * t185 / 0.11520e5 + t197 * t991 / 0.103680e6 + t92 * t803 * t185 / 0.258048e6 - t201 * t991 / 0.2838528e7 - t95 * t803 * t185 / 0.6881280e7 + t205 * t991 / 0.89456640e8 + t98 * t803 * t185 / 0.212336640e9 - t209 * t991 / 0.3185049600e10 - t589 * t803 * t185 / 0.7431782400e10 + t213 * t991 / 0.126340300800e12
  t1030 = f.my_piecewise3(t74, 0, t990)
  t1035 = t110 * t821
  t1049 = t110 * t217
  t1074 = f.my_piecewise3(t73, t1029, -0.8e1 / 0.3e1 * t1030 * t117 - 0.8e1 / 0.3e1 * t821 * t236 - 0.8e1 / 0.3e1 * t217 * t836 - 0.8e1 / 0.3e1 * t101 * (-t602 * t217 * t1035 / 0.2e1 + 0.2e1 * t607 * t821 * t217 - t219 * t1030 + 0.2e1 * t1030 * t114 + 0.2e1 * t821 * t233 + 0.2e1 * t217 * t833 + 0.2e1 * t101 * (-0.2e1 * t615 * t821 * t1049 + t224 * t1030 * t110 / 0.2e1 + t623 * t821 * t1049 / 0.4e1 - 0.4e1 * t217 * t111 * t821 - t108 * t217 * t1035 - 0.4e1 * t228 * t1030 - t103 * t1030 * t110)))
  t1082 = -0.3e1 / 0.8e1 * t5 * t953 * t123 - t957 / 0.8e1 - 0.3e1 / 0.8e1 * t795 * t242 - 0.3e1 / 0.8e1 * t795 * t245 - t443 / 0.8e1 + t454 - t457 / 0.8e1 - t460 / 0.8e1 - 0.3e1 / 0.8e1 * t30 * t842 - t970 / 0.8e1 - 0.3e1 / 0.8e1 * t130 * t31 * t1074 * t59 - 0.3e1 / 0.8e1 * t130 * t841 * t171
  t1083 = f.my_piecewise3(t1, 0, t1082)
  t1087 = f.my_piecewise5(t14, 0, t10, 0, -t948)
  t1091 = f.my_piecewise3(t254, 0, 0.4e1 / 0.9e1 * t656 * t848 * t257 + 0.4e1 / 0.3e1 * t255 * t1087)
  t1095 = t852 * t349
  t1105 = t347 * t132 * t935 * t280
  t1111 = t857 * t356 * jnp.pi
  t1112 = t861 * t887
  t1127 = -t1111 * t40 * t1112 * t358 / 0.12e2 + 0.2e1 / 0.9e1 * t286 * t66 * t687 * t893 * t358 - t286 * t356 * (t1087 * t6 + t257 + t848) / 0.6e1
  t1128 = f.my_piecewise3(t294, t1127, 0)
  t1166 = t300 * t898 * t362 / 0.6e1 - t353 * t1128 / 0.18e2 - t303 * t898 * t362 / 0.48e2 + t366 * t1128 / 0.240e3 + t306 * t898 * t362 / 0.640e3 - t370 * t1128 / 0.4480e4 - t309 * t898 * t362 / 0.11520e5 + t374 * t1128 / 0.103680e6 + t312 * t898 * t362 / 0.258048e6 - t378 * t1128 / 0.2838528e7 - t315 * t898 * t362 / 0.6881280e7 + t382 * t1128 / 0.89456640e8 + t318 * t898 * t362 / 0.212336640e9 - t386 * t1128 / 0.3185049600e10 - t728 * t898 * t362 / 0.7431782400e10 + t390 * t1128 / 0.126340300800e12
  t1167 = f.my_piecewise3(t294, 0, t1127)
  t1172 = t329 * t916
  t1186 = t329 * t394
  t1211 = f.my_piecewise3(t293, t1166, -0.8e1 / 0.3e1 * t1167 * t336 - 0.8e1 / 0.3e1 * t916 * t413 - 0.8e1 / 0.3e1 * t394 * t931 - 0.8e1 / 0.3e1 * t321 * (-t741 * t394 * t1172 / 0.2e1 + 0.2e1 * t746 * t916 * t394 - t396 * t1167 + 0.2e1 * t1167 * t333 + 0.2e1 * t916 * t410 + 0.2e1 * t394 * t928 + 0.2e1 * t321 * (-0.2e1 * t754 * t916 * t1186 + t401 * t1167 * t329 / 0.2e1 + t762 * t916 * t1186 / 0.4e1 - 0.4e1 * t394 * t330 * t916 - t327 * t394 * t1172 - 0.4e1 * t405 * t1167 - t322 * t1167 * t329)))
  t1219 = t347 * t348 * t887
  t1224 = -0.3e1 / 0.8e1 * t5 * t1091 * t342 - t1095 / 0.8e1 - 0.3e1 / 0.8e1 * t852 * t419 - t669 / 0.8e1 + t676 - t679 / 0.8e1 - 0.3e1 / 0.8e1 * t261 * t937 - t1105 / 0.8e1 - 0.3e1 / 0.8e1 * t347 * t31 * t1211 * t280 - 0.3e1 / 0.8e1 * t261 * t940 - t1219 / 0.8e1 - 0.3e1 / 0.8e1 * t347 * t418 * t887
  t1225 = f.my_piecewise3(t251, 0, t1224)
  d12 = t249 + t423 + t846 + t944 + t6 * (t1083 + t1225)
  t1230 = t791 ** 2
  t1234 = 0.2e1 * t23 + 0.2e1 * t432
  t1235 = f.my_piecewise5(t10, 0, t14, 0, t1234)
  t1239 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t426 * t1230 + 0.4e1 / 0.3e1 * t21 * t1235)
  t1247 = t803 ** 2
  t1250 = t799 ** 2
  t1260 = 0.2e1 / 0.9e1 * t65 * t549 * t1250 - t65 * t178 * (t1235 * t6 + 0.2e1 * t791) / 0.6e1
  t1261 = f.my_piecewise3(t74, t1260, 0)
  t1292 = t80 * t1247 / 0.6e1 - t138 * t1261 / 0.18e2 - t83 * t1247 / 0.48e2 + t189 * t1261 / 0.240e3 + t86 * t1247 / 0.640e3 - t193 * t1261 / 0.4480e4 - t89 * t1247 / 0.11520e5 + t197 * t1261 / 0.103680e6 + t92 * t1247 / 0.258048e6 - t201 * t1261 / 0.2838528e7 - t95 * t1247 / 0.6881280e7 + t205 * t1261 / 0.89456640e8 + t98 * t1247 / 0.212336640e9 - t209 * t1261 / 0.3185049600e10 - t589 * t1247 / 0.7431782400e10 + t213 * t1261 / 0.126340300800e12
  t1293 = f.my_piecewise3(t74, 0, t1260)
  t1298 = t821 ** 2
  t1333 = f.my_piecewise3(t73, t1292, -0.8e1 / 0.3e1 * t1293 * t117 - 0.16e2 / 0.3e1 * t821 * t836 - 0.8e1 / 0.3e1 * t101 * (-t602 * t1298 * t110 / 0.2e1 + 0.2e1 * t607 * t1298 - t219 * t1293 + 0.2e1 * t1293 * t114 + 0.4e1 * t821 * t833 + 0.2e1 * t101 * (-0.2e1 * t615 * t1298 * t110 + t224 * t1293 * t110 / 0.2e1 + t623 * t1298 * t110 / 0.4e1 - 0.4e1 * t1298 * t111 - t108 * t1298 * t110 - 0.4e1 * t228 * t1293 - t103 * t1293 * t110)))
  t1339 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1239 * t123 - t957 / 0.4e1 - 0.3e1 / 0.4e1 * t795 * t842 + t454 - t970 / 0.4e1 - 0.3e1 / 0.8e1 * t130 * t31 * t1333 * t59)
  t1340 = t848 ** 2
  t1344 = f.my_piecewise5(t14, 0, t10, 0, -t1234)
  t1348 = f.my_piecewise3(t254, 0, 0.4e1 / 0.9e1 * t656 * t1340 + 0.4e1 / 0.3e1 * t255 * t1344)
  t1359 = t898 ** 2
  t1370 = t860 ** 2
  t1373 = t887 ** 2
  t1389 = t262 ** 2
  t1392 = s2 / t264 / t1389
  t1401 = t882 ** 2
  t1413 = s2 ** 2
  t1427 = 0.91259259259259259259259259259259259259259259259260e-2 * t40 * t1392 * t276 + 0.49777777777777777777777777777777777777777777777778e-2 * t40 * t866 * t883 + 0.18666666666666666666666666666666666666666666666666e-2 * t40 * t267 / t870 / t275 * t1401 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t267 * t871 * (0.78400000000000000000000000000000000000000000000000e-1 * t268 / t263 / t863 * t272 + 0.16800000000000000000000000000000000000000000000000e0 * t1392 * t879 - 0.44800000000000000000000000000000000000000000000000e-1 * t1413 / t263 / t1389 / t863 / t878 / t877)
  t1432 = t893 ** 2
  t1442 = 0.3e1 / 0.8e1 * f.p.cam_omega / t284 / t466 / t470 / t861 * t290 * t465 * t479 * t469 / t1370 * t1373 - t1111 * t40 * t1112 * t893 / 0.6e1 - t859 * t39 * t37 / t860 / t280 * t1373 / 0.2e1 + t859 * t39 * t862 * t1427 / 0.4e1 + 0.2e1 / 0.9e1 * t286 * t688 * t1432 - t286 * t356 * (t1344 * t6 + 0.2e1 * t848) / 0.6e1
  t1443 = f.my_piecewise3(t294, t1442, 0)
  t1474 = t300 * t1359 / 0.6e1 - t353 * t1443 / 0.18e2 - t303 * t1359 / 0.48e2 + t366 * t1443 / 0.240e3 + t306 * t1359 / 0.640e3 - t370 * t1443 / 0.4480e4 - t309 * t1359 / 0.11520e5 + t374 * t1443 / 0.103680e6 + t312 * t1359 / 0.258048e6 - t378 * t1443 / 0.2838528e7 - t315 * t1359 / 0.6881280e7 + t382 * t1443 / 0.89456640e8 + t318 * t1359 / 0.212336640e9 - t386 * t1443 / 0.3185049600e10 - t728 * t1359 / 0.7431782400e10 + t390 * t1443 / 0.126340300800e12
  t1475 = f.my_piecewise3(t294, 0, t1442)
  t1480 = t916 ** 2
  t1515 = f.my_piecewise3(t293, t1474, -0.8e1 / 0.3e1 * t1475 * t336 - 0.16e2 / 0.3e1 * t916 * t931 - 0.8e1 / 0.3e1 * t321 * (-t741 * t1480 * t329 / 0.2e1 + 0.2e1 * t746 * t1480 - t396 * t1475 + 0.2e1 * t1475 * t333 + 0.4e1 * t916 * t928 + 0.2e1 * t321 * (-0.2e1 * t754 * t1480 * t329 + t401 * t1475 * t329 / 0.2e1 + t762 * t1480 * t329 / 0.4e1 - 0.4e1 * t1480 * t330 - t327 * t1480 * t329 - 0.4e1 * t405 * t1475 - t322 * t1475 * t329)))
  t1527 = f.my_piecewise3(t251, 0, -0.3e1 / 0.8e1 * t5 * t1348 * t342 - t1095 / 0.4e1 - 0.3e1 / 0.4e1 * t852 * t937 - 0.3e1 / 0.4e1 * t852 * t940 + t676 - t1105 / 0.4e1 - t1219 / 0.4e1 - 0.3e1 / 0.8e1 * t347 * t31 * t1515 * t280 - 0.3e1 / 0.4e1 * t347 * t936 * t887 - 0.3e1 / 0.8e1 * t347 * t341 * t1427)
  d22 = 0.2e1 * t846 + 0.2e1 * t944 + t6 * (t1339 + t1527)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

