"""Generated from gga_x_pbepow.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  pbepow_kappa = KAPPA_PBE

  pbepow_mu = 0.2195149727645171

  pbepow_m = 100.0

  pbepow_f0 = lambda s: 1 - pbepow_mu * s ** 2 * ((pbepow_m * pbepow_mu * s ** 2 / (pbepow_m * pbepow_mu * s ** 2 + pbepow_kappa)) ** pbepow_m - 1)

  pbepow_f = lambda x: pbepow_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbepow_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  pbepow_kappa = KAPPA_PBE

  pbepow_mu = 0.2195149727645171

  pbepow_m = 100.0

  pbepow_f0 = lambda s: 1 - pbepow_mu * s ** 2 * ((pbepow_m * pbepow_mu * s ** 2 / (pbepow_m * pbepow_mu * s ** 2 + pbepow_kappa)) ** pbepow_m - 1)

  pbepow_f = lambda x: pbepow_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbepow_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  pbepow_kappa = KAPPA_PBE

  pbepow_mu = 0.2195149727645171

  pbepow_m = 100.0

  pbepow_f0 = lambda s: 1 - pbepow_mu * s ** 2 * ((pbepow_m * pbepow_mu * s ** 2 / (pbepow_m * pbepow_mu * s ** 2 + pbepow_kappa)) ** pbepow_m - 1)

  pbepow_f = lambda x: pbepow_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbepow_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = t28 / t31
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t42 = 0.91464571985215458333333333333333333333333333333333e0 * t33 * t39 + 0.8040e0
  t43 = 0.1e1 / t42
  t45 = t33 * t39 * t43
  t46 = t45 ** 0.1000e3
  t48 = 0.13344141567995010004602128620252019916507744838618e-3 * t46 - 0.1e1
  t52 = 0.1e1 - 0.91464571985215458333333333333333333333333333333333e-2 * t33 * t39 * t48
  t56 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t52)
  t57 = r1 <= f.p.dens_threshold
  t58 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t59 = 0.1e1 + t58
  t60 = t59 <= f.p.zeta_threshold
  t61 = t59 ** (0.1e1 / 0.3e1)
  t63 = f.my_piecewise3(t60, t22, t61 * t59)
  t64 = t63 * t26
  t65 = r1 ** 2
  t66 = r1 ** (0.1e1 / 0.3e1)
  t67 = t66 ** 2
  t69 = 0.1e1 / t67 / t65
  t70 = s2 * t69
  t73 = 0.91464571985215458333333333333333333333333333333333e0 * t33 * t70 + 0.8040e0
  t74 = 0.1e1 / t73
  t76 = t33 * t70 * t74
  t77 = t76 ** 0.1000e3
  t79 = 0.13344141567995010004602128620252019916507744838618e-3 * t77 - 0.1e1
  t83 = 0.1e1 - 0.91464571985215458333333333333333333333333333333333e-2 * t33 * t70 * t79
  t87 = f.my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t64 * t83)
  t88 = t6 ** 2
  t90 = t16 / t88
  t91 = t7 - t90
  t92 = f.my_piecewise5(t10, 0, t14, 0, t91)
  t95 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t92)
  t100 = t26 ** 2
  t101 = 0.1e1 / t100
  t105 = t5 * t25 * t101 * t52 / 0.8e1
  t109 = s0 / t36 / t34 / r0
  t113 = t33 * s0
  t114 = t45 ** 0.990e2
  t115 = t38 * t114
  t119 = t28 ** 2
  t122 = t119 / t30 / t29
  t123 = s0 ** 2
  t124 = t34 ** 2
  t129 = t42 ** 2
  t130 = 0.1e1 / t129
  t143 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t95 * t26 * t52 - t105 - 0.3e1 / 0.8e1 * t5 * t27 * (0.24390552529390788888888888888888888888888888888889e-1 * t33 * t109 * t48 - 0.12205161970267854711887308326685111714573814507263e-3 * t113 * t115 * (-0.8e1 / 0.3e1 * t33 * t109 * t43 + 0.24390552529390788888888888888888888888888888888889e1 * t122 * t123 / t35 / t124 / t34 * t130)))
  t145 = f.my_piecewise5(t14, 0, t10, 0, -t91)
  t148 = f.my_piecewise3(t60, 0, 0.4e1 / 0.3e1 * t61 * t145)
  t156 = t5 * t63 * t101 * t83 / 0.8e1
  t158 = f.my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t148 * t26 * t83 - t156)
  vrho_0_ = t56 + t87 + t6 * (t143 + t158)
  t161 = -t7 - t90
  t162 = f.my_piecewise5(t10, 0, t14, 0, t161)
  t165 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t162)
  t171 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t165 * t26 * t52 - t105)
  t173 = f.my_piecewise5(t14, 0, t10, 0, -t161)
  t176 = f.my_piecewise3(t60, 0, 0.4e1 / 0.3e1 * t61 * t173)
  t184 = s2 / t67 / t65 / r1
  t188 = t33 * s2
  t189 = t76 ** 0.990e2
  t190 = t69 * t189
  t194 = s2 ** 2
  t195 = t65 ** 2
  t200 = t73 ** 2
  t201 = 0.1e1 / t200
  t214 = f.my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t176 * t26 * t83 - t156 - 0.3e1 / 0.8e1 * t5 * t64 * (0.24390552529390788888888888888888888888888888888889e-1 * t33 * t184 * t79 - 0.12205161970267854711887308326685111714573814507263e-3 * t188 * t190 * (-0.8e1 / 0.3e1 * t33 * t184 * t74 + 0.24390552529390788888888888888888888888888888888889e1 * t122 * t194 / t66 / t195 / t65 * t201)))
  vrho_1_ = t56 + t87 + t6 * (t171 + t214)
  t237 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-0.91464571985215458333333333333333333333333333333333e-2 * t33 * t38 * t48 - 0.12205161970267854711887308326685111714573814507263e-3 * t113 * t115 * (t33 * t38 * t43 - 0.91464571985215458333333333333333333333333333333333e0 * t122 * s0 / t35 / t124 / r0 * t130)))
  vsigma_0_ = t6 * t237
  vsigma_1_ = 0.0e0
  t258 = f.my_piecewise3(t57, 0, -0.3e1 / 0.8e1 * t5 * t64 * (-0.91464571985215458333333333333333333333333333333333e-2 * t33 * t69 * t79 - 0.12205161970267854711887308326685111714573814507263e-3 * t188 * t190 * (t33 * t69 * t74 - 0.91464571985215458333333333333333333333333333333333e0 * t122 * s2 / t66 / t195 / r1 * t201)))
  vsigma_2_ = t6 * t258
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  pbepow_kappa = KAPPA_PBE

  pbepow_mu = 0.2195149727645171

  pbepow_m = 100.0

  pbepow_f0 = lambda s: 1 - pbepow_mu * s ** 2 * ((pbepow_m * pbepow_mu * s ** 2 / (pbepow_m * pbepow_mu * s ** 2 + pbepow_kappa)) ** pbepow_m - 1)

  pbepow_f = lambda x: pbepow_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbepow_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = t20 / t23
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t38 = 0.91464571985215458333333333333333333333333333333333e0 * t25 * s0 * t28 * t32 + 0.8040e0
  t39 = 0.1e1 / t38
  t40 = t33 * t39
  t41 = t26 * t40
  t42 = t41 ** 0.1000e3
  t44 = 0.13344141567995010004602128620252019916507744838618e-3 * t42 - 0.1e1
  t45 = t33 * t44
  t48 = 0.1e1 - 0.91464571985215458333333333333333333333333333333333e-2 * t26 * t45
  t52 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t48)
  t61 = t28 / t30 / t29 / r0
  t65 = t41 ** 0.990e2
  t69 = t20 ** 2
  t72 = t69 / t22 / t21
  t73 = s0 ** 2
  t75 = t29 ** 2
  t80 = t38 ** 2
  t81 = 0.1e1 / t80
  t95 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t48 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (0.24390552529390788888888888888888888888888888888889e-1 * t26 * t61 * t44 - 0.12205161970267854711887308326685111714573814507263e-3 * t26 * t33 * t65 * (-0.8e1 / 0.3e1 * t26 * t61 * t39 + 0.48781105058781577777777777777777777777777777777778e1 * t72 * t73 * t27 / t18 / t75 / t29 * t81)))
  vrho_0_ = 0.2e1 * r0 * t95 + 0.2e1 * t52
  t118 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-0.91464571985215458333333333333333333333333333333333e-2 * t25 * t45 - 0.12205161970267854711887308326685111714573814507263e-3 * t26 * t33 * t65 * (t25 * t40 - 0.18292914397043091666666666666666666666666666666667e1 * t72 * s0 * t27 / t18 / t75 / r0 * t81)))
  vsigma_0_ = 0.2e1 * r0 * t118
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = t27 * s0
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t34 = t30 * t33
  t35 = s0 * t30
  t39 = 0.91464571985215458333333333333333333333333333333336e0 * t27 * t35 * t33 + 0.8040e0
  t40 = 0.1e1 / t39
  t41 = t34 * t40
  t42 = t28 * t41
  t43 = t42 ** 0.1000e3
  t45 = 0.13344141567995010004602128620252019916507744838662e-3 * t43 - 0.1e1
  t46 = t34 * t45
  t49 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t28 * t46
  t53 = t17 * t18
  t54 = t31 * r0
  t57 = t30 / t19 / t54
  t58 = t57 * t45
  t61 = t42 ** 0.990e2
  t62 = t57 * t40
  t65 = t22 ** 2
  t68 = t65 / t24 / t23
  t69 = s0 ** 2
  t70 = t68 * t69
  t71 = t31 ** 2
  t74 = 0.1e1 / t18 / t71 / t31
  t76 = t39 ** 2
  t77 = 0.1e1 / t76
  t81 = -0.8e1 / 0.3e1 * t28 * t62 + 0.48781105058781577777777777777777777777777777777780e1 * t70 * t29 * t74 * t77
  t82 = t61 * t81
  t86 = 0.24390552529390788888888888888888888888888888888890e-1 * t28 * t58 - 0.12205161970267854711887308326685111714573814507304e-3 * t28 * t34 * t82
  t91 = f.my_piecewise3(t2, 0, -t6 * t21 * t49 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t53 * t86)
  t104 = t30 / t19 / t71
  t111 = t42 ** 0.980e2
  t112 = t81 ** 2
  t127 = t23 ** 2
  t128 = 0.1e1 / t127
  t131 = t71 ** 2
  t135 = 0.1e1 / t76 / t39
  t149 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t49 / 0.12e2 - t6 * t21 * t86 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t53 * (-0.89432025941099559259259259259259259259259259259263e-1 * t28 * t104 * t45 + 0.65094197174761891796732311075653929144393677372287e-3 * t28 * t57 * t82 - 0.12083110350565176164768435243418260597428076362231e-1 * t28 * t34 * t111 * t112 - 0.12205161970267854711887308326685111714573814507304e-3 * t28 * t34 * t61 * (0.88e2 / 0.9e1 * t28 * t104 * t40 - 0.43902994552903420000000000000000000000000000000002e2 * t70 * t29 / t18 / t71 / t54 * t77 + 0.28555154529070627664905953299205925925925925925929e3 * t128 * t69 * s0 / t131 / t31 * t135)))
  v2rho2_0_ = 0.2e1 * r0 * t149 + 0.4e1 * t91
  t160 = t29 / t18 / t71 / r0 * t77
  t163 = t27 * t41 - 0.18292914397043091666666666666666666666666666666667e1 * t68 * s0 * t160
  t164 = t61 * t163
  t168 = -0.91464571985215458333333333333333333333333333333336e-2 * t27 * t46 - 0.12205161970267854711887308326685111714573814507304e-3 * t28 * t34 * t164
  t172 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t53 * t168)
  t178 = t27 * t30
  t179 = t33 * t61
  t215 = f.my_piecewise3(t2, 0, -t6 * t21 * t168 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t53 * (0.24390552529390788888888888888888888888888888888890e-1 * t27 * t58 - 0.12205161970267854711887308326685111714573814507304e-3 * t178 * t179 * t81 + 0.32547098587380945898366155537826964572196838686144e-3 * t28 * t57 * t164 - 0.12083110350565176164768435243418260597428076362231e-1 * t27 * t35 * t33 * t111 * t163 * t81 - 0.12205161970267854711887308326685111714573814507304e-3 * t28 * t34 * t61 * (-0.8e1 / 0.3e1 * t27 * t62 + 0.14634331517634473333333333333333333333333333333334e2 * t68 * t29 * t74 * t77 * s0 - 0.10708182948401485374339732487202222222222222222223e3 * t128 * t69 / t131 / r0 * t135)))
  v2rhosigma_0_ = 0.2e1 * r0 * t215 + 0.2e1 * t172
  t221 = t163 ** 2
  t242 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t53 * (-0.24410323940535709423774616653370223429147629014608e-3 * t178 * t179 * t163 - 0.12083110350565176164768435243418260597428076362231e-1 * t28 * t34 * t111 * t221 - 0.12205161970267854711887308326685111714573814507304e-3 * t28 * t34 * t61 * (-0.36585828794086183333333333333333333333333333333334e1 * t68 * t160 + 0.40155686056505570153773996827008333333333333333334e2 * t128 * s0 / t131 * t135)))
  v2sigma2_0_ = 0.2e1 * r0 * t242
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = t28 * s0
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t35 = t31 * t34
  t36 = s0 * t31
  t40 = 0.91464571985215458333333333333333333333333333333336e0 * t28 * t36 * t34 + 0.8040e0
  t41 = 0.1e1 / t40
  t43 = t29 * t35 * t41
  t44 = t43 ** 0.1000e3
  t46 = 0.13344141567995010004602128620252019916507744838662e-3 * t44 - 0.1e1
  t50 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t29 * t35 * t46
  t55 = t17 / t19
  t56 = t32 * r0
  t59 = t31 / t19 / t56
  t63 = t43 ** 0.990e2
  t67 = t23 ** 2
  t71 = s0 ** 2
  t72 = t67 / t25 / t24 * t71
  t73 = t32 ** 2
  t78 = t40 ** 2
  t79 = 0.1e1 / t78
  t83 = -0.8e1 / 0.3e1 * t29 * t59 * t41 + 0.48781105058781577777777777777777777777777777777780e1 * t72 * t30 / t18 / t73 / t32 * t79
  t84 = t63 * t83
  t88 = 0.24390552529390788888888888888888888888888888888890e-1 * t29 * t59 * t46 - 0.12205161970267854711887308326685111714573814507304e-3 * t29 * t35 * t84
  t92 = t17 * t18
  t95 = t31 / t19 / t73
  t102 = t43 ** 0.980e2
  t103 = t83 ** 2
  t104 = t102 * t103
  t118 = t24 ** 2
  t119 = 0.1e1 / t118
  t121 = t119 * t71 * s0
  t122 = t73 ** 2
  t126 = 0.1e1 / t78 / t40
  t130 = 0.88e2 / 0.9e1 * t29 * t95 * t41 - 0.43902994552903420000000000000000000000000000000002e2 * t72 * t30 / t18 / t73 / t56 * t79 + 0.28555154529070627664905953299205925925925925925929e3 * t121 / t122 / t32 * t126
  t131 = t63 * t130
  t135 = -0.89432025941099559259259259259259259259259259259263e-1 * t29 * t95 * t46 + 0.65094197174761891796732311075653929144393677372287e-3 * t29 * t59 * t84 - 0.12083110350565176164768435243418260597428076362231e-1 * t29 * t35 * t104 - 0.12205161970267854711887308326685111714573814507304e-3 * t29 * t35 * t131
  t140 = f.my_piecewise3(t2, 0, t6 * t22 * t50 / 0.12e2 - t6 * t55 * t88 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t92 * t135)
  t152 = t73 * r0
  t155 = t31 / t19 / t152
  t168 = t43 ** 0.970e2
  t194 = t71 ** 2
  t200 = t78 ** 2
  t217 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t50 + t6 * t22 * t88 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t55 * t135 - 0.3e1 / 0.8e1 * t6 * t92 * (0.41734945439179794320987654320987654320987654320989e0 * t29 * t155 * t46 - 0.35801808446119040488202771091609661029416522554758e-2 * t29 * t95 * t84 + 0.96664882804521409318147481947346084779424610897847e-1 * t29 * t59 * t104 + 0.97641295762142837695098466613480893716590516058431e-3 * t29 * t59 * t131 - 0.11841448143553872641473066538549895385479514834986e1 * t29 * t35 * t168 * t103 * t83 - 0.36249331051695528494305305730254781792284229086693e-1 * t28 * t36 * t34 * t102 * t83 * t130 - 0.12205161970267854711887308326685111714573814507304e-3 * t29 * t35 * t63 * (-0.1232e4 / 0.27e2 * t29 * t155 * t41 + 0.36965237388987817827160493827160493827160493827162e3 * t72 * t30 / t18 / t122 * t79 - 0.54254793605234192563321311268491259259259259259265e4 * t121 / t122 / t56 * t126 + 0.20894279895785053161670658928873892136360168318028e4 * t119 * t194 / t19 / t122 / t152 / t200 * t23 * t27 * t31)))
  v3rho3_0_ = 0.2e1 * r0 * t217 + 0.6e1 * t140

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = t29 * s0
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = t32 * t22
  t34 = s0 * t32
  t38 = 0.91464571985215458333333333333333333333333333333336e0 * t29 * t34 * t22 + 0.8040e0
  t39 = 0.1e1 / t38
  t41 = t30 * t33 * t39
  t42 = t41 ** 0.1000e3
  t44 = 0.13344141567995010004602128620252019916507744838662e-3 * t42 - 0.1e1
  t48 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t30 * t33 * t44
  t54 = t17 / t20 / r0
  t55 = t18 * r0
  t57 = 0.1e1 / t20 / t55
  t58 = t32 * t57
  t62 = t41 ** 0.990e2
  t66 = t24 ** 2
  t68 = 0.1e1 / t26 / t25
  t70 = s0 ** 2
  t71 = t66 * t68 * t70
  t72 = t18 ** 2
  t73 = t72 * t18
  t77 = t38 ** 2
  t78 = 0.1e1 / t77
  t82 = -0.8e1 / 0.3e1 * t30 * t58 * t39 + 0.48781105058781577777777777777777777777777777777780e1 * t71 * t31 / t19 / t73 * t78
  t83 = t62 * t82
  t87 = 0.24390552529390788888888888888888888888888888888890e-1 * t30 * t58 * t44 - 0.12205161970267854711887308326685111714573814507304e-3 * t30 * t33 * t83
  t92 = t17 / t20
  t95 = t32 / t20 / t72
  t102 = t41 ** 0.980e2
  t103 = t82 ** 2
  t104 = t102 * t103
  t118 = t25 ** 2
  t119 = 0.1e1 / t118
  t121 = t119 * t70 * s0
  t122 = t72 ** 2
  t126 = 0.1e1 / t77 / t38
  t130 = 0.88e2 / 0.9e1 * t30 * t95 * t39 - 0.43902994552903420000000000000000000000000000000002e2 * t71 * t31 / t19 / t72 / t55 * t78 + 0.28555154529070627664905953299205925925925925925929e3 * t121 / t122 / t18 * t126
  t131 = t62 * t130
  t135 = -0.89432025941099559259259259259259259259259259259263e-1 * t30 * t95 * t44 + 0.65094197174761891796732311075653929144393677372287e-3 * t30 * t58 * t83 - 0.12083110350565176164768435243418260597428076362231e-1 * t30 * t33 * t104 - 0.12205161970267854711887308326685111714573814507304e-3 * t30 * t33 * t131
  t139 = t17 * t19
  t140 = t72 * r0
  t143 = t32 / t20 / t140
  t156 = t41 ** 0.970e2
  t158 = t156 * t103 * t82
  t162 = t29 * t34
  t163 = t22 * t102
  t164 = t82 * t130
  t182 = t70 ** 2
  t183 = t119 * t182
  t188 = t77 ** 2
  t192 = 0.1e1 / t188 * t24 * t28 * t32
  t195 = -0.1232e4 / 0.27e2 * t30 * t143 * t39 + 0.36965237388987817827160493827160493827160493827162e3 * t71 * t31 / t19 / t122 * t78 - 0.54254793605234192563321311268491259259259259259265e4 * t121 / t122 / t55 * t126 + 0.20894279895785053161670658928873892136360168318028e4 * t183 / t20 / t122 / t140 * t192
  t196 = t62 * t195
  t200 = 0.41734945439179794320987654320987654320987654320989e0 * t30 * t143 * t44 - 0.35801808446119040488202771091609661029416522554758e-2 * t30 * t95 * t83 + 0.96664882804521409318147481947346084779424610897847e-1 * t30 * t58 * t104 + 0.97641295762142837695098466613480893716590516058431e-3 * t30 * t58 * t131 - 0.11841448143553872641473066538549895385479514834986e1 * t30 * t33 * t158 - 0.36249331051695528494305305730254781792284229086693e-1 * t162 * t163 * t164 - 0.12205161970267854711887308326685111714573814507304e-3 * t30 * t33 * t196
  t205 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t48 + t6 * t54 * t87 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t92 * t135 - 0.3e1 / 0.8e1 * t6 * t139 * t200)
  t222 = t32 / t20 / t73
  t245 = t41 ** 0.960e2
  t246 = t103 ** 2
  t256 = t130 ** 2
  t288 = t122 ** 2
  t305 = -0.23649802415535216781893004115226337448559670781894e1 * t30 * t222 * t44 + 0.22276680810918514081548390901446011307192502922960e-1 * t30 * t143 * t83 - 0.70887580723315700166641486761387128838244714658421e0 * t30 * t95 * t104 - 0.71603616892238080976405542183219322058833045109516e-2 * t30 * t95 * t131 + 0.12630878019790797484237937641119888411178149157319e2 * t30 * t58 * t158 + 0.38665953121808563727258992778938433911769844359139e0 * t162 * t57 * t102 * t164 + 0.13018839434952378359346462215130785828878735474458e-2 * t30 * t58 * t196 - 0.11486204699247256462228874542393398523915129389936e3 * t30 * t33 * t245 * t246 - 0.71048688861323235848838399231299372312877089009917e1 * t162 * t22 * t156 * t103 * t130 - 0.36249331051695528494305305730254781792284229086693e-1 * t30 * t33 * t102 * t256 - 0.48332441402260704659073740973673042389712305448924e-1 * t162 * t163 * t82 * t195 - 0.12205161970267854711887308326685111714573814507304e-3 * t30 * t33 * t62 * (0.20944e5 / 0.81e2 * t30 * t222 * t39 - 0.33030228247579437219753086419753086419753086419754e4 * t71 * t31 / t19 / t122 / r0 * t78 + 0.81318734508897798561282175895405320164609053497951e5 * t121 / t122 / t72 * t126 - 0.68254647659564506994790819167654714312109883172225e5 * t183 / t20 / t122 / t73 * t192 + 0.40769842508955138980591442084440762162096860551558e5 * t119 * t182 * s0 / t19 / t288 / r0 / t188 / t38 * t66 * t68 * t31)
  t310 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t57 * t48 - 0.5e1 / 0.9e1 * t6 * t23 * t87 + t6 * t54 * t135 / 0.2e1 - t6 * t92 * t200 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t139 * t305)
  v4rho4_0_ = 0.2e1 * r0 * t310 + 0.8e1 * t205

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t43 = s0 * t42
  t46 = 0.91464571985215458333333333333333333333333333333336e0 * t37 * t43 + 0.8040e0
  t47 = 0.1e1 / t46
  t49 = t37 * t43 * t47
  t50 = t49 ** 0.1000e3
  t52 = 0.13344141567995010004602128620252019916507744838662e-3 * t50 - 0.1e1
  t56 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t37 * t43 * t52
  t60 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t61 = t60 * f.p.zeta_threshold
  t63 = f.my_piecewise3(t20, t61, t21 * t19)
  t64 = t30 ** 2
  t65 = 0.1e1 / t64
  t66 = t63 * t65
  t69 = t5 * t66 * t56 / 0.8e1
  t70 = t63 * t30
  t71 = t38 * r0
  t73 = 0.1e1 / t40 / t71
  t74 = s0 * t73
  t78 = t37 * s0
  t79 = t49 ** 0.990e2
  t80 = t42 * t79
  t84 = t32 ** 2
  t87 = t84 / t34 / t33
  t88 = s0 ** 2
  t89 = t38 ** 2
  t94 = t46 ** 2
  t95 = 0.1e1 / t94
  t99 = -0.8e1 / 0.3e1 * t37 * t74 * t47 + 0.24390552529390788888888888888888888888888888888890e1 * t87 * t88 / t39 / t89 / t38 * t95
  t103 = 0.24390552529390788888888888888888888888888888888890e-1 * t37 * t74 * t52 - 0.12205161970267854711887308326685111714573814507304e-3 * t78 * t80 * t99
  t108 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t56 - t69 - 0.3e1 / 0.8e1 * t5 * t70 * t103)
  t110 = r1 <= f.p.dens_threshold
  t111 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t112 = 0.1e1 + t111
  t113 = t112 <= f.p.zeta_threshold
  t114 = t112 ** (0.1e1 / 0.3e1)
  t116 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t119 = f.my_piecewise3(t113, 0, 0.4e1 / 0.3e1 * t114 * t116)
  t120 = t119 * t30
  t121 = r1 ** 2
  t122 = r1 ** (0.1e1 / 0.3e1)
  t123 = t122 ** 2
  t125 = 0.1e1 / t123 / t121
  t126 = s2 * t125
  t129 = 0.91464571985215458333333333333333333333333333333336e0 * t37 * t126 + 0.8040e0
  t130 = 0.1e1 / t129
  t132 = t37 * t126 * t130
  t133 = t132 ** 0.1000e3
  t135 = 0.13344141567995010004602128620252019916507744838662e-3 * t133 - 0.1e1
  t139 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t37 * t126 * t135
  t144 = f.my_piecewise3(t113, t61, t114 * t112)
  t145 = t144 * t65
  t148 = t5 * t145 * t139 / 0.8e1
  t150 = f.my_piecewise3(t110, 0, -0.3e1 / 0.8e1 * t5 * t120 * t139 - t148)
  t152 = t21 ** 2
  t153 = 0.1e1 / t152
  t154 = t26 ** 2
  t159 = t16 / t22 / t6
  t161 = -0.2e1 * t23 + 0.2e1 * t159
  t162 = f.my_piecewise5(t10, 0, t14, 0, t161)
  t166 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t153 * t154 + 0.4e1 / 0.3e1 * t21 * t162)
  t173 = t5 * t29 * t65 * t56
  t179 = 0.1e1 / t64 / t6
  t183 = t5 * t63 * t179 * t56 / 0.12e2
  t185 = t5 * t66 * t103
  t189 = s0 / t40 / t89
  t197 = t49 ** 0.980e2
  t199 = t99 ** 2
  t213 = t33 ** 2
  t214 = 0.1e1 / t213
  t217 = t89 ** 2
  t234 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t166 * t30 * t56 - t173 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t103 + t183 - t185 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t70 * (-0.89432025941099559259259259259259259259259259259263e-1 * t37 * t189 * t52 + 0.65094197174761891796732311075653929144393677372287e-3 * t78 * t73 * t79 * t99 - 0.12083110350565176164768435243418260597428076362231e-1 * t78 * t42 * t197 * t199 - 0.12205161970267854711887308326685111714573814507304e-3 * t78 * t80 * (0.88e2 / 0.9e1 * t37 * t189 * t47 - 0.21951497276451710000000000000000000000000000000001e2 * t87 * t88 / t39 / t89 / t71 * t95 + 0.71387886322676569162264883248014814814814814814821e2 * t214 * t88 * s0 / t217 / t38 / t94 / t46)))
  t235 = t114 ** 2
  t236 = 0.1e1 / t235
  t237 = t116 ** 2
  t241 = f.my_piecewise5(t14, 0, t10, 0, -t161)
  t245 = f.my_piecewise3(t113, 0, 0.4e1 / 0.9e1 * t236 * t237 + 0.4e1 / 0.3e1 * t114 * t241)
  t252 = t5 * t119 * t65 * t139
  t257 = t5 * t144 * t179 * t139 / 0.12e2
  t259 = f.my_piecewise3(t110, 0, -0.3e1 / 0.8e1 * t5 * t245 * t30 * t139 - t252 / 0.4e1 + t257)
  d11 = 0.2e1 * t108 + 0.2e1 * t150 + t6 * (t234 + t259)
  t262 = -t7 - t24
  t263 = f.my_piecewise5(t10, 0, t14, 0, t262)
  t266 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t263)
  t267 = t266 * t30
  t272 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t267 * t56 - t69)
  t274 = f.my_piecewise5(t14, 0, t10, 0, -t262)
  t277 = f.my_piecewise3(t113, 0, 0.4e1 / 0.3e1 * t114 * t274)
  t278 = t277 * t30
  t282 = t144 * t30
  t283 = t121 * r1
  t285 = 0.1e1 / t123 / t283
  t286 = s2 * t285
  t290 = t37 * s2
  t291 = t132 ** 0.990e2
  t292 = t125 * t291
  t296 = s2 ** 2
  t297 = t121 ** 2
  t302 = t129 ** 2
  t303 = 0.1e1 / t302
  t307 = -0.8e1 / 0.3e1 * t37 * t286 * t130 + 0.24390552529390788888888888888888888888888888888890e1 * t87 * t296 / t122 / t297 / t121 * t303
  t311 = 0.24390552529390788888888888888888888888888888888890e-1 * t37 * t286 * t135 - 0.12205161970267854711887308326685111714573814507304e-3 * t290 * t292 * t307
  t316 = f.my_piecewise3(t110, 0, -0.3e1 / 0.8e1 * t5 * t278 * t139 - t148 - 0.3e1 / 0.8e1 * t5 * t282 * t311)
  t320 = 0.2e1 * t159
  t321 = f.my_piecewise5(t10, 0, t14, 0, t320)
  t325 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t153 * t263 * t26 + 0.4e1 / 0.3e1 * t21 * t321)
  t332 = t5 * t266 * t65 * t56
  t340 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t325 * t30 * t56 - t332 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t267 * t103 - t173 / 0.8e1 + t183 - t185 / 0.8e1)
  t344 = f.my_piecewise5(t14, 0, t10, 0, -t320)
  t348 = f.my_piecewise3(t113, 0, 0.4e1 / 0.9e1 * t236 * t274 * t116 + 0.4e1 / 0.3e1 * t114 * t344)
  t355 = t5 * t277 * t65 * t139
  t362 = t5 * t145 * t311
  t365 = f.my_piecewise3(t110, 0, -0.3e1 / 0.8e1 * t5 * t348 * t30 * t139 - t355 / 0.8e1 - t252 / 0.8e1 + t257 - 0.3e1 / 0.8e1 * t5 * t120 * t311 - t362 / 0.8e1)
  d12 = t108 + t150 + t272 + t316 + t6 * (t340 + t365)
  t370 = t263 ** 2
  t374 = 0.2e1 * t23 + 0.2e1 * t159
  t375 = f.my_piecewise5(t10, 0, t14, 0, t374)
  t379 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t153 * t370 + 0.4e1 / 0.3e1 * t21 * t375)
  t386 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t379 * t30 * t56 - t332 / 0.4e1 + t183)
  t387 = t274 ** 2
  t391 = f.my_piecewise5(t14, 0, t10, 0, -t374)
  t395 = f.my_piecewise3(t113, 0, 0.4e1 / 0.9e1 * t236 * t387 + 0.4e1 / 0.3e1 * t114 * t391)
  t407 = s2 / t123 / t297
  t415 = t132 ** 0.980e2
  t417 = t307 ** 2
  t433 = t297 ** 2
  t450 = f.my_piecewise3(t110, 0, -0.3e1 / 0.8e1 * t5 * t395 * t30 * t139 - t355 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t278 * t311 + t257 - t362 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t282 * (-0.89432025941099559259259259259259259259259259259263e-1 * t37 * t407 * t135 + 0.65094197174761891796732311075653929144393677372287e-3 * t290 * t285 * t291 * t307 - 0.12083110350565176164768435243418260597428076362231e-1 * t290 * t125 * t415 * t417 - 0.12205161970267854711887308326685111714573814507304e-3 * t290 * t292 * (0.88e2 / 0.9e1 * t37 * t407 * t130 - 0.21951497276451710000000000000000000000000000000001e2 * t87 * t296 / t122 / t297 / t283 * t303 + 0.71387886322676569162264883248014814814814814814821e2 * t214 * t296 * s2 / t433 / t121 / t302 / t129)))
  d22 = 0.2e1 * t272 + 0.2e1 * t316 + t6 * (t386 + t450)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t54 = 0.1e1 / t52 / t50
  t55 = s0 * t54
  t58 = 0.91464571985215458333333333333333333333333333333336e0 * t49 * t55 + 0.8040e0
  t59 = 0.1e1 / t58
  t61 = t49 * t55 * t59
  t62 = t61 ** 0.1000e3
  t64 = 0.13344141567995010004602128620252019916507744838662e-3 * t62 - 0.1e1
  t68 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t49 * t55 * t64
  t74 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t75 = t42 ** 2
  t76 = 0.1e1 / t75
  t77 = t74 * t76
  t81 = t74 * t42
  t82 = t50 * r0
  t84 = 0.1e1 / t52 / t82
  t85 = s0 * t84
  t89 = t49 * s0
  t90 = t61 ** 0.990e2
  t91 = t54 * t90
  t95 = t44 ** 2
  t98 = t95 / t46 / t45
  t99 = s0 ** 2
  t100 = t50 ** 2
  t105 = t58 ** 2
  t106 = 0.1e1 / t105
  t110 = -0.8e1 / 0.3e1 * t49 * t85 * t59 + 0.24390552529390788888888888888888888888888888888890e1 * t98 * t99 / t51 / t100 / t50 * t106
  t114 = 0.24390552529390788888888888888888888888888888888890e-1 * t49 * t85 * t64 - 0.12205161970267854711887308326685111714573814507304e-3 * t89 * t91 * t110
  t118 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t119 = t118 * f.p.zeta_threshold
  t121 = f.my_piecewise3(t20, t119, t21 * t19)
  t123 = 0.1e1 / t75 / t6
  t124 = t121 * t123
  t128 = t121 * t76
  t132 = t121 * t42
  t134 = 0.1e1 / t52 / t100
  t135 = s0 * t134
  t139 = t84 * t90
  t143 = t61 ** 0.980e2
  t144 = t54 * t143
  t145 = t110 ** 2
  t159 = t45 ** 2
  t160 = 0.1e1 / t159
  t162 = t160 * t99 * s0
  t163 = t100 ** 2
  t167 = 0.1e1 / t105 / t58
  t171 = 0.88e2 / 0.9e1 * t49 * t135 * t59 - 0.21951497276451710000000000000000000000000000000001e2 * t98 * t99 / t51 / t100 / t82 * t106 + 0.71387886322676569162264883248014814814814814814821e2 * t162 / t163 / t50 * t167
  t175 = -0.89432025941099559259259259259259259259259259259263e-1 * t49 * t135 * t64 + 0.65094197174761891796732311075653929144393677372287e-3 * t89 * t139 * t110 - 0.12083110350565176164768435243418260597428076362231e-1 * t89 * t144 * t145 - 0.12205161970267854711887308326685111714573814507304e-3 * t89 * t91 * t171
  t180 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t68 - t5 * t77 * t68 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t81 * t114 + t5 * t124 * t68 / 0.12e2 - t5 * t128 * t114 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t132 * t175)
  t182 = r1 <= f.p.dens_threshold
  t183 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t184 = 0.1e1 + t183
  t185 = t184 <= f.p.zeta_threshold
  t186 = t184 ** (0.1e1 / 0.3e1)
  t187 = t186 ** 2
  t188 = 0.1e1 / t187
  t190 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t191 = t190 ** 2
  t195 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t199 = f.my_piecewise3(t185, 0, 0.4e1 / 0.9e1 * t188 * t191 + 0.4e1 / 0.3e1 * t186 * t195)
  t201 = r1 ** 2
  t202 = r1 ** (0.1e1 / 0.3e1)
  t203 = t202 ** 2
  t206 = s2 / t203 / t201
  t213 = (t49 * t206 / (0.91464571985215458333333333333333333333333333333336e0 * t49 * t206 + 0.8040e0)) ** 0.1000e3
  t219 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t49 * t206 * (0.13344141567995010004602128620252019916507744838662e-3 * t213 - 0.1e1)
  t225 = f.my_piecewise3(t185, 0, 0.4e1 / 0.3e1 * t186 * t190)
  t231 = f.my_piecewise3(t185, t119, t186 * t184)
  t237 = f.my_piecewise3(t182, 0, -0.3e1 / 0.8e1 * t5 * t199 * t42 * t219 - t5 * t225 * t76 * t219 / 0.4e1 + t5 * t231 * t123 * t219 / 0.12e2)
  t247 = t24 ** 2
  t251 = 0.6e1 * t33 - 0.6e1 * t16 / t247
  t252 = f.my_piecewise5(t10, 0, t14, 0, t251)
  t256 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t252)
  t279 = 0.1e1 / t75 / t24
  t290 = t100 * r0
  t293 = s0 / t52 / t290
  t308 = t61 ** 0.970e2
  t332 = t99 ** 2
  t338 = t105 ** 2
  t353 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t256 * t42 * t68 - 0.3e1 / 0.8e1 * t5 * t41 * t76 * t68 - 0.9e1 / 0.8e1 * t5 * t43 * t114 + t5 * t74 * t123 * t68 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t77 * t114 - 0.9e1 / 0.8e1 * t5 * t81 * t175 - 0.5e1 / 0.36e2 * t5 * t121 * t279 * t68 + t5 * t124 * t114 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t128 * t175 - 0.3e1 / 0.8e1 * t5 * t132 * (0.41734945439179794320987654320987654320987654320989e0 * t49 * t293 * t64 - 0.35801808446119040488202771091609661029416522554758e-2 * t89 * t134 * t90 * t110 + 0.96664882804521409318147481947346084779424610897847e-1 * t89 * t84 * t143 * t145 + 0.97641295762142837695098466613480893716590516058431e-3 * t89 * t139 * t171 - 0.11841448143553872641473066538549895385479514834986e1 * t89 * t54 * t308 * t145 * t110 - 0.36249331051695528494305305730254781792284229086693e-1 * t89 * t144 * t110 * t171 - 0.12205161970267854711887308326685111714573814507304e-3 * t89 * t91 * (-0.1232e4 / 0.27e2 * t49 * t293 * t59 + 0.18482618694493908913580246913580246913580246913581e3 * t98 * t99 / t51 / t163 * t106 - 0.13563698401308548140830327817122814814814814814816e4 * t162 / t163 / t82 * t167 + 0.52235699739462632904176647322184730340900420795069e3 * t160 * t332 / t52 / t163 / t290 / t338 * t44 * t48)))
  t363 = f.my_piecewise5(t14, 0, t10, 0, -t251)
  t367 = f.my_piecewise3(t185, 0, -0.8e1 / 0.27e2 / t187 / t184 * t191 * t190 + 0.4e1 / 0.3e1 * t188 * t190 * t195 + 0.4e1 / 0.3e1 * t186 * t363)
  t385 = f.my_piecewise3(t182, 0, -0.3e1 / 0.8e1 * t5 * t367 * t42 * t219 - 0.3e1 / 0.8e1 * t5 * t199 * t76 * t219 + t5 * t225 * t123 * t219 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t231 * t279 * t219)
  d111 = 0.3e1 * t180 + 0.3e1 * t237 + t6 * (t353 + t385)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = 0.1e1 / t59
  t61 = t56 * t60
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t66 = 0.1e1 / t64 / t62
  t67 = s0 * t66
  t70 = 0.91464571985215458333333333333333333333333333333336e0 * t61 * t67 + 0.8040e0
  t71 = 0.1e1 / t70
  t73 = t61 * t67 * t71
  t74 = t73 ** 0.1000e3
  t76 = 0.13344141567995010004602128620252019916507744838662e-3 * t74 - 0.1e1
  t80 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t61 * t67 * t76
  t89 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t90 = t54 ** 2
  t91 = 0.1e1 / t90
  t92 = t89 * t91
  t96 = t89 * t54
  t97 = t62 * r0
  t99 = 0.1e1 / t64 / t97
  t100 = s0 * t99
  t104 = t61 * s0
  t105 = t73 ** 0.990e2
  t106 = t66 * t105
  t110 = t56 ** 2
  t112 = 0.1e1 / t58 / t57
  t113 = t110 * t112
  t114 = s0 ** 2
  t115 = t62 ** 2
  t116 = t115 * t62
  t120 = t70 ** 2
  t121 = 0.1e1 / t120
  t125 = -0.8e1 / 0.3e1 * t61 * t100 * t71 + 0.24390552529390788888888888888888888888888888888890e1 * t113 * t114 / t63 / t116 * t121
  t129 = 0.24390552529390788888888888888888888888888888888890e-1 * t61 * t100 * t76 - 0.12205161970267854711887308326685111714573814507304e-3 * t104 * t106 * t125
  t135 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t137 = 0.1e1 / t90 / t6
  t138 = t135 * t137
  t142 = t135 * t91
  t146 = t135 * t54
  t148 = 0.1e1 / t64 / t115
  t149 = s0 * t148
  t153 = t99 * t105
  t157 = t73 ** 0.980e2
  t158 = t66 * t157
  t159 = t125 ** 2
  t173 = t57 ** 2
  t174 = 0.1e1 / t173
  t176 = t174 * t114 * s0
  t177 = t115 ** 2
  t181 = 0.1e1 / t120 / t70
  t185 = 0.88e2 / 0.9e1 * t61 * t149 * t71 - 0.21951497276451710000000000000000000000000000000001e2 * t113 * t114 / t63 / t115 / t97 * t121 + 0.71387886322676569162264883248014814814814814814821e2 * t176 / t177 / t62 * t181
  t189 = -0.89432025941099559259259259259259259259259259259263e-1 * t61 * t149 * t76 + 0.65094197174761891796732311075653929144393677372287e-3 * t104 * t153 * t125 - 0.12083110350565176164768435243418260597428076362231e-1 * t104 * t158 * t159 - 0.12205161970267854711887308326685111714573814507304e-3 * t104 * t106 * t185
  t193 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t194 = t193 * f.p.zeta_threshold
  t196 = f.my_piecewise3(t20, t194, t21 * t19)
  t198 = 0.1e1 / t90 / t25
  t199 = t196 * t198
  t203 = t196 * t137
  t207 = t196 * t91
  t211 = t196 * t54
  t212 = t115 * r0
  t214 = 0.1e1 / t64 / t212
  t215 = s0 * t214
  t219 = t148 * t105
  t223 = t99 * t157
  t230 = t73 ** 0.970e2
  t231 = t66 * t230
  t232 = t159 * t125
  t236 = t125 * t185
  t254 = t114 ** 2
  t255 = t174 * t254
  t260 = t120 ** 2
  t263 = 0.1e1 / t260 * t56 * t60
  t266 = -0.1232e4 / 0.27e2 * t61 * t215 * t71 + 0.18482618694493908913580246913580246913580246913581e3 * t113 * t114 / t63 / t177 * t121 - 0.13563698401308548140830327817122814814814814814816e4 * t176 / t177 / t97 * t181 + 0.52235699739462632904176647322184730340900420795069e3 * t255 / t64 / t177 / t212 * t263
  t270 = 0.41734945439179794320987654320987654320987654320989e0 * t61 * t215 * t76 - 0.35801808446119040488202771091609661029416522554758e-2 * t104 * t219 * t125 + 0.96664882804521409318147481947346084779424610897847e-1 * t104 * t223 * t159 + 0.97641295762142837695098466613480893716590516058431e-3 * t104 * t153 * t185 - 0.11841448143553872641473066538549895385479514834986e1 * t104 * t231 * t232 - 0.36249331051695528494305305730254781792284229086693e-1 * t104 * t158 * t236 - 0.12205161970267854711887308326685111714573814507304e-3 * t104 * t106 * t266
  t275 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t80 - 0.3e1 / 0.8e1 * t5 * t92 * t80 - 0.9e1 / 0.8e1 * t5 * t96 * t129 + t5 * t138 * t80 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t142 * t129 - 0.9e1 / 0.8e1 * t5 * t146 * t189 - 0.5e1 / 0.36e2 * t5 * t199 * t80 + t5 * t203 * t129 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t207 * t189 - 0.3e1 / 0.8e1 * t5 * t211 * t270)
  t277 = r1 <= f.p.dens_threshold
  t278 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t279 = 0.1e1 + t278
  t280 = t279 <= f.p.zeta_threshold
  t281 = t279 ** (0.1e1 / 0.3e1)
  t282 = t281 ** 2
  t284 = 0.1e1 / t282 / t279
  t286 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t287 = t286 ** 2
  t291 = 0.1e1 / t282
  t292 = t291 * t286
  t294 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t298 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t302 = f.my_piecewise3(t280, 0, -0.8e1 / 0.27e2 * t284 * t287 * t286 + 0.4e1 / 0.3e1 * t292 * t294 + 0.4e1 / 0.3e1 * t281 * t298)
  t304 = r1 ** 2
  t305 = r1 ** (0.1e1 / 0.3e1)
  t306 = t305 ** 2
  t309 = s2 / t306 / t304
  t316 = (t61 * t309 / (0.91464571985215458333333333333333333333333333333336e0 * t61 * t309 + 0.8040e0)) ** 0.1000e3
  t322 = 0.1e1 - 0.91464571985215458333333333333333333333333333333336e-2 * t61 * t309 * (0.13344141567995010004602128620252019916507744838662e-3 * t316 - 0.1e1)
  t331 = f.my_piecewise3(t280, 0, 0.4e1 / 0.9e1 * t291 * t287 + 0.4e1 / 0.3e1 * t281 * t294)
  t338 = f.my_piecewise3(t280, 0, 0.4e1 / 0.3e1 * t281 * t286)
  t344 = f.my_piecewise3(t280, t194, t281 * t279)
  t350 = f.my_piecewise3(t277, 0, -0.3e1 / 0.8e1 * t5 * t302 * t54 * t322 - 0.3e1 / 0.8e1 * t5 * t331 * t91 * t322 + t5 * t338 * t137 * t322 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t344 * t198 * t322)
  t353 = 0.1e1 / t90 / t36
  t372 = s0 / t64 / t116
  t397 = t73 ** 0.960e2
  t399 = t159 ** 2
  t407 = t185 ** 2
  t438 = t177 ** 2
  t453 = -0.23649802415535216781893004115226337448559670781894e1 * t61 * t372 * t76 + 0.22276680810918514081548390901446011307192502922960e-1 * t104 * t214 * t105 * t125 - 0.70887580723315700166641486761387128838244714658421e0 * t104 * t148 * t157 * t159 - 0.71603616892238080976405542183219322058833045109516e-2 * t104 * t219 * t185 + 0.12630878019790797484237937641119888411178149157319e2 * t104 * t99 * t230 * t232 + 0.38665953121808563727258992778938433911769844359139e0 * t104 * t223 * t236 + 0.13018839434952378359346462215130785828878735474458e-2 * t104 * t153 * t266 - 0.11486204699247256462228874542393398523915129389936e3 * t104 * t66 * t397 * t399 - 0.71048688861323235848838399231299372312877089009917e1 * t104 * t231 * t159 * t185 - 0.36249331051695528494305305730254781792284229086693e-1 * t104 * t158 * t407 - 0.48332441402260704659073740973673042389712305448924e-1 * t104 * t158 * t125 * t266 - 0.12205161970267854711887308326685111714573814507304e-3 * t104 * t106 * (0.20944e5 / 0.81e2 * t61 * t372 * t71 - 0.16515114123789718609876543209876543209876543209877e4 * t113 * t114 / t63 / t177 / r0 * t121 + 0.20329683627224449640320543973851330041152263374488e5 * t176 / t177 / t115 * t181 - 0.17063661914891126748697704791913678578027470793056e5 * t255 / t64 / t177 / t116 * t263 + 0.50962303136193923725739302605550952702621075689447e4 * t174 * t254 * s0 / t63 / t438 / r0 / t260 / t70 * t110 * t112)
  t480 = t19 ** 2
  t483 = t30 ** 2
  t489 = t41 ** 2
  t498 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t499 = f.my_piecewise5(t10, 0, t14, 0, t498)
  t503 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t480 * t483 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t489 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t499)
  t511 = 0.10e2 / 0.27e2 * t5 * t196 * t353 * t80 - 0.5e1 / 0.9e1 * t5 * t135 * t198 * t80 + t5 * t89 * t137 * t80 / 0.2e1 - t5 * t53 * t91 * t80 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t211 * t453 + t5 * t203 * t189 / 0.2e1 - t5 * t207 * t270 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t146 * t270 - 0.5e1 / 0.9e1 * t5 * t199 * t129 - 0.3e1 / 0.2e1 * t5 * t92 * t129 - 0.9e1 / 0.4e1 * t5 * t96 * t189 + t5 * t138 * t129 - 0.3e1 / 0.2e1 * t5 * t142 * t189 - 0.3e1 / 0.8e1 * t5 * t503 * t54 * t80 - 0.3e1 / 0.2e1 * t5 * t55 * t129
  t512 = f.my_piecewise3(t1, 0, t511)
  t513 = t279 ** 2
  t516 = t287 ** 2
  t522 = t294 ** 2
  t528 = f.my_piecewise5(t14, 0, t10, 0, -t498)
  t532 = f.my_piecewise3(t280, 0, 0.40e2 / 0.81e2 / t282 / t513 * t516 - 0.16e2 / 0.9e1 * t284 * t287 * t294 + 0.4e1 / 0.3e1 * t291 * t522 + 0.16e2 / 0.9e1 * t292 * t298 + 0.4e1 / 0.3e1 * t281 * t528)
  t554 = f.my_piecewise3(t277, 0, -0.3e1 / 0.8e1 * t5 * t532 * t54 * t322 - t5 * t302 * t91 * t322 / 0.2e1 + t5 * t331 * t137 * t322 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t338 * t198 * t322 + 0.10e2 / 0.27e2 * t5 * t344 * t353 * t322)
  d1111 = 0.4e1 * t275 + 0.4e1 * t350 + t6 * (t512 + t554)

  res = {'v4rho4': d1111}
  return res
