"""Generated from gga_x_pbetrans.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  pbetrans_kappa_pbe = 0.814

  pbetrans_kappa_revpbe = 1.227

  pbetrans_mu = 0.219

  pbetrans_alpha = 2 * (3 * jnp.pi ** 2) ** (1 / 3)

  pbetrans_beta = 3

  pbetrans_fermi = lambda s: 1 / (1 + jnp.exp(-pbetrans_alpha * (s - pbetrans_beta)))

  pbetrans_kappa = lambda s: (1 - pbetrans_fermi(s)) * pbetrans_kappa_revpbe + pbetrans_fermi(s) * pbetrans_kappa_pbe

  pbetrans_f0 = lambda s: 1 + pbetrans_kappa(s) * (1 - pbetrans_kappa(s) / (pbetrans_kappa(s) + pbetrans_mu * s ** 2))

  pbetrans_f = lambda x: pbetrans_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbetrans_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  pbetrans_kappa_pbe = 0.814

  pbetrans_kappa_revpbe = 1.227

  pbetrans_mu = 0.219

  pbetrans_alpha = 2 * (3 * jnp.pi ** 2) ** (1 / 3)

  pbetrans_beta = 3

  pbetrans_fermi = lambda s: 1 / (1 + jnp.exp(-pbetrans_alpha * (s - pbetrans_beta)))

  pbetrans_kappa = lambda s: (1 - pbetrans_fermi(s)) * pbetrans_kappa_revpbe + pbetrans_fermi(s) * pbetrans_kappa_pbe

  pbetrans_f0 = lambda s: 1 + pbetrans_kappa(s) * (1 - pbetrans_kappa(s) / (pbetrans_kappa(s) + pbetrans_mu * s ** 2))

  pbetrans_f = lambda x: pbetrans_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbetrans_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  pbetrans_kappa_pbe = 0.814

  pbetrans_kappa_revpbe = 1.227

  pbetrans_mu = 0.219

  pbetrans_alpha = 2 * (3 * jnp.pi ** 2) ** (1 / 3)

  pbetrans_beta = 3

  pbetrans_fermi = lambda s: 1 / (1 + jnp.exp(-pbetrans_alpha * (s - pbetrans_beta)))

  pbetrans_kappa = lambda s: (1 - pbetrans_fermi(s)) * pbetrans_kappa_revpbe + pbetrans_fermi(s) * pbetrans_kappa_pbe

  pbetrans_f0 = lambda s: 1 + pbetrans_kappa(s) * (1 - pbetrans_kappa(s) / (pbetrans_kappa(s) + pbetrans_mu * s ** 2))

  pbetrans_f = lambda x: pbetrans_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbetrans_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = jnp.pi ** 2
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = t2 * t29
  t31 = 6 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = t32 / t29
  t35 = jnp.sqrt(s0)
  t36 = r0 ** (0.1e1 / 0.3e1)
  t38 = 0.1e1 / t36 / r0
  t45 = jnp.exp(-0.2e1 * t30 * (t34 * t35 * t38 / 0.12e2 - 0.3e1))
  t46 = 0.1e1 + t45
  t48 = 0.413e0 / t46
  t49 = 0.1227e1 - t48
  t50 = t29 ** 2
  t52 = t31 / t50
  t53 = r0 ** 2
  t54 = t36 ** 2
  t56 = 0.1e1 / t54 / t53
  t60 = 0.1227e1 - t48 + 0.91250000000000000000000000000000000000000000000000e-2 * t52 * s0 * t56
  t61 = 0.1e1 / t60
  t63 = -t49 * t61 + 0.1e1
  t65 = t49 * t63 + 0.1e1
  t69 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t65)
  t70 = r1 <= f.p.dens_threshold
  t71 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = t72 ** (0.1e1 / 0.3e1)
  t76 = f.my_piecewise3(t73, t22, t74 * t72)
  t77 = t76 * t26
  t78 = jnp.sqrt(s2)
  t79 = r1 ** (0.1e1 / 0.3e1)
  t81 = 0.1e1 / t79 / r1
  t88 = jnp.exp(-0.2e1 * t30 * (t34 * t78 * t81 / 0.12e2 - 0.3e1))
  t89 = 0.1e1 + t88
  t91 = 0.413e0 / t89
  t92 = 0.1227e1 - t91
  t93 = r1 ** 2
  t94 = t79 ** 2
  t96 = 0.1e1 / t94 / t93
  t100 = 0.1227e1 - t91 + 0.91250000000000000000000000000000000000000000000000e-2 * t52 * s2 * t96
  t101 = 0.1e1 / t100
  t103 = -t92 * t101 + 0.1e1
  t105 = t92 * t103 + 0.1e1
  t109 = f.my_piecewise3(t70, 0, -0.3e1 / 0.8e1 * t5 * t77 * t105)
  t110 = t6 ** 2
  t112 = t16 / t110
  t113 = t7 - t112
  t114 = f.my_piecewise5(t10, 0, t14, 0, t113)
  t117 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t114)
  t122 = t26 ** 2
  t123 = 0.1e1 / t122
  t127 = t5 * t25 * t123 * t65 / 0.8e1
  t128 = t46 ** 2
  t131 = 0.1e1 / t128 * t2 * t32
  t134 = t35 / t36 / t53
  t135 = t45 * t63
  t139 = t45 * t61
  t143 = t60 ** 2
  t145 = t49 / t143
  t164 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t117 * t26 * t65 - t127 - 0.3e1 / 0.8e1 * t5 * t27 * (0.91777777777777777777777777777777777777777777777778e-1 * t131 * t134 * t135 + t49 * (-0.91777777777777777777777777777777777777777777777778e-1 * t131 * t134 * t139 + t145 * (0.91777777777777777777777777777777777777777777777778e-1 * t131 * t134 * t45 - 0.24333333333333333333333333333333333333333333333333e-1 * t52 * s0 / t54 / t53 / r0))))
  t166 = f.my_piecewise5(t14, 0, t10, 0, -t113)
  t169 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t74 * t166)
  t177 = t5 * t76 * t123 * t105 / 0.8e1
  t179 = f.my_piecewise3(t70, 0, -0.3e1 / 0.8e1 * t5 * t169 * t26 * t105 - t177)
  vrho_0_ = t69 + t109 + t6 * (t164 + t179)
  t182 = -t7 - t112
  t183 = f.my_piecewise5(t10, 0, t14, 0, t182)
  t186 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t183)
  t192 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t186 * t26 * t65 - t127)
  t194 = f.my_piecewise5(t14, 0, t10, 0, -t182)
  t197 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t74 * t194)
  t202 = t89 ** 2
  t205 = 0.1e1 / t202 * t2 * t32
  t208 = t78 / t79 / t93
  t209 = t88 * t103
  t213 = t88 * t101
  t217 = t100 ** 2
  t219 = t92 / t217
  t238 = f.my_piecewise3(t70, 0, -0.3e1 / 0.8e1 * t5 * t197 * t26 * t105 - t177 - 0.3e1 / 0.8e1 * t5 * t77 * (0.91777777777777777777777777777777777777777777777778e-1 * t205 * t208 * t209 + t92 * (-0.91777777777777777777777777777777777777777777777778e-1 * t205 * t208 * t213 + t219 * (0.91777777777777777777777777777777777777777777777778e-1 * t205 * t208 * t88 - 0.24333333333333333333333333333333333333333333333333e-1 * t52 * s2 / t94 / t93 / r1))))
  vrho_1_ = t69 + t109 + t6 * (t192 + t238)
  t242 = 0.1e1 / t35 * t38
  t262 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-0.34416666666666666666666666666666666666666666666667e-1 * t131 * t242 * t135 + t49 * (0.34416666666666666666666666666666666666666666666667e-1 * t131 * t242 * t139 + t145 * (-0.34416666666666666666666666666666666666666666666667e-1 * t131 * t242 * t45 + 0.91250000000000000000000000000000000000000000000000e-2 * t52 * t56))))
  vsigma_0_ = t6 * t262
  vsigma_1_ = 0.0e0
  t264 = 0.1e1 / t78 * t81
  t284 = f.my_piecewise3(t70, 0, -0.3e1 / 0.8e1 * t5 * t77 * (-0.34416666666666666666666666666666666666666666666667e-1 * t205 * t264 * t209 + t92 * (0.34416666666666666666666666666666666666666666666667e-1 * t205 * t264 * t213 + t219 * (-0.34416666666666666666666666666666666666666666666667e-1 * t205 * t264 * t88 + 0.91250000000000000000000000000000000000000000000000e-2 * t52 * t96))))
  vsigma_2_ = t6 * t284
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  pbetrans_kappa_pbe = 0.814

  pbetrans_kappa_revpbe = 1.227

  pbetrans_mu = 0.219

  pbetrans_alpha = 2 * (3 * jnp.pi ** 2) ** (1 / 3)

  pbetrans_beta = 3

  pbetrans_fermi = lambda s: 1 / (1 + jnp.exp(-pbetrans_alpha * (s - pbetrans_beta)))

  pbetrans_kappa = lambda s: (1 - pbetrans_fermi(s)) * pbetrans_kappa_revpbe + pbetrans_fermi(s) * pbetrans_kappa_pbe

  pbetrans_f0 = lambda s: 1 + pbetrans_kappa(s) * (1 - pbetrans_kappa(s) / (pbetrans_kappa(s) + pbetrans_mu * s ** 2))

  pbetrans_f = lambda x: pbetrans_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, pbetrans_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = jnp.pi ** 2
  t21 = t20 ** (0.1e1 / 0.3e1)
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t27 = jnp.sqrt(s0)
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t27 * t28
  t31 = 0.1e1 / t18 / r0
  t38 = jnp.exp(-0.2e1 * t3 * t21 * (t24 / t21 * t29 * t31 / 0.12e2 - 0.3e1))
  t39 = 0.1e1 + t38
  t41 = 0.413e0 / t39
  t42 = 0.1227e1 - t41
  t43 = t21 ** 2
  t45 = t23 / t43
  t46 = t28 ** 2
  t47 = s0 * t46
  t48 = r0 ** 2
  t49 = t18 ** 2
  t51 = 0.1e1 / t49 / t48
  t55 = 0.1227e1 - t41 + 0.91250000000000000000000000000000000000000000000000e-2 * t45 * t47 * t51
  t56 = 0.1e1 / t55
  t58 = -t42 * t56 + 0.1e1
  t60 = t42 * t58 + 0.1e1
  t64 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t60)
  t70 = t39 ** 2
  t72 = 0.1e1 / t70 * t3
  t74 = t72 * t24 * t27
  t76 = 0.1e1 / t18 / t48
  t77 = t28 * t76
  t78 = t38 * t58
  t82 = t38 * t56
  t86 = t55 ** 2
  t88 = t42 / t86
  t89 = t72 * t24
  t109 = f.my_piecewise3(t2, 0, -t6 * t17 / t49 * t60 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (0.91777777777777777777777777777777777777777777777778e-1 * t74 * t77 * t78 + t42 * (-0.91777777777777777777777777777777777777777777777778e-1 * t74 * t77 * t82 + t88 * (0.91777777777777777777777777777777777777777777777778e-1 * t89 * t29 * t76 * t38 - 0.24333333333333333333333333333333333333333333333333e-1 * t45 * t47 / t49 / t48 / r0))))
  vrho_0_ = 0.2e1 * r0 * t109 + 0.2e1 * t64
  t112 = 0.1e1 / t27
  t114 = t72 * t24 * t112
  t115 = t28 * t31
  t138 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-0.34416666666666666666666666666666666666666666666667e-1 * t114 * t115 * t78 + t42 * (0.34416666666666666666666666666666666666666666666667e-1 * t114 * t115 * t82 + t88 * (-0.34416666666666666666666666666666666666666666666667e-1 * t89 * t112 * t28 * t31 * t38 + 0.91250000000000000000000000000000000000000000000000e-2 * t45 * t46 * t51))))
  vsigma_0_ = 0.2e1 * r0 * t138
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = jnp.pi ** 2
  t23 = t22 ** (0.1e1 / 0.3e1)
  t25 = 6 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t29 = jnp.sqrt(s0)
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t33 = 0.1e1 / t18 / r0
  t40 = jnp.exp(-0.2e1 * t3 * t23 * (t26 / t23 * t31 * t33 / 0.12e2 - 0.3e1))
  t41 = 0.1e1 + t40
  t43 = 0.413e0 / t41
  t44 = 0.1227e1 - t43
  t45 = t23 ** 2
  t47 = t25 / t45
  t48 = t30 ** 2
  t49 = s0 * t48
  t50 = r0 ** 2
  t52 = 0.1e1 / t19 / t50
  t56 = 0.1227e1 - t43 + 0.91249999999999999999999999999999999999999999999998e-2 * t47 * t49 * t52
  t57 = 0.1e1 / t56
  t59 = -t44 * t57 + 0.1e1
  t61 = t44 * t59 + 0.1e1
  t65 = t17 * t18
  t66 = t41 ** 2
  t67 = 0.1e1 / t66
  t68 = t67 * t3
  t70 = t68 * t26 * t29
  t72 = 0.1e1 / t18 / t50
  t73 = t30 * t72
  t74 = t40 * t59
  t75 = t73 * t74
  t78 = t40 * t57
  t79 = t73 * t78
  t82 = t56 ** 2
  t83 = 0.1e1 / t82
  t84 = t44 * t83
  t85 = t68 * t26
  t86 = t72 * t40
  t90 = t50 * r0
  t92 = 0.1e1 / t19 / t90
  t96 = 0.91777777777777777777777777777777777777777777777778e-1 * t85 * t31 * t86 - 0.24333333333333333333333333333333333333333333333333e-1 * t47 * t49 * t92
  t98 = -0.91777777777777777777777777777777777777777777777778e-1 * t70 * t79 + t84 * t96
  t100 = 0.91777777777777777777777777777777777777777777777778e-1 * t70 * t75 + t44 * t98
  t105 = f.my_piecewise3(t2, 0, -t6 * t21 * t61 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t65 * t100)
  t118 = t3 ** 2
  t119 = 0.1e1 / t66 / t41 * t118
  t120 = t25 * s0
  t121 = t119 * t120
  t122 = t50 ** 2
  t124 = 0.1e1 / t19 / t122
  t125 = t48 * t124
  t126 = t40 ** 2
  t127 = t126 * t59
  t132 = 0.1e1 / t18 / t90
  t133 = t30 * t132
  t137 = t67 * t118
  t138 = t137 * t120
  t142 = t40 * t98
  t146 = t126 * t57
  t156 = t40 * t83
  t157 = t156 * t96
  t163 = t44 / t82 / t56
  t164 = t96 ** 2
  t167 = t119 * t25
  t176 = t137 * t25
  t193 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t61 / 0.12e2 - t6 * t21 * t100 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t65 * (-0.24474074074074074074074074074074074074074074074074e0 * t121 * t125 * t127 - 0.21414814814814814814814814814814814814814814814815e0 * t70 * t133 * t74 + 0.12237037037037037037037037037037037037037037037037e0 * t138 * t125 * t74 + 0.18355555555555555555555555555555555555555555555556e0 * t70 * t73 * t142 + t44 * (0.24474074074074074074074074074074074074074074074074e0 * t121 * t125 * t146 + 0.21414814814814814814814814814814814814814814814815e0 * t70 * t133 * t78 - 0.12237037037037037037037037037037037037037037037037e0 * t138 * t125 * t78 + 0.18355555555555555555555555555555555555555555555556e0 * t70 * t73 * t157 - 0.2e1 * t163 * t164 + t84 * (-0.24474074074074074074074074074074074074074074074074e0 * t167 * t49 * t124 * t126 - 0.21414814814814814814814814814814814814814814814815e0 * t85 * t31 * t132 * t40 + 0.12237037037037037037037037037037037037037037037037e0 * t176 * t49 * t124 * t40 + 0.89222222222222222222222222222222222222222222222221e-1 * t47 * t49 * t124))))
  v2rho2_0_ = 0.2e1 * r0 * t193 + 0.4e1 * t105
  t196 = 0.1e1 / t29
  t198 = t68 * t26 * t196
  t199 = t30 * t33
  t200 = t199 * t74
  t203 = t199 * t78
  t206 = t196 * t30
  t207 = t33 * t40
  t211 = t48 * t52
  t214 = -0.34416666666666666666666666666666666666666666666667e-1 * t85 * t206 * t207 + 0.91249999999999999999999999999999999999999999999998e-2 * t47 * t211
  t216 = 0.34416666666666666666666666666666666666666666666667e-1 * t198 * t203 + t84 * t214
  t218 = -0.34416666666666666666666666666666666666666666666667e-1 * t198 * t200 + t44 * t216
  t222 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t65 * t218)
  t226 = t48 * t92
  t238 = t40 * t216
  t253 = t156 * t214
  t280 = f.my_piecewise3(t2, 0, -t6 * t21 * t218 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t65 * (0.91777777777777777777777777777777777777777777777779e-1 * t167 * t226 * t127 + 0.45888888888888888888888888888888888888888888888889e-1 * t198 * t75 - 0.45888888888888888888888888888888888888888888888889e-1 * t176 * t226 * t74 - 0.34416666666666666666666666666666666666666666666667e-1 * t198 * t199 * t142 + 0.91777777777777777777777777777777777777777777777778e-1 * t70 * t73 * t238 + t44 * (-0.91777777777777777777777777777777777777777777777779e-1 * t167 * t226 * t146 - 0.45888888888888888888888888888888888888888888888889e-1 * t198 * t79 + 0.45888888888888888888888888888888888888888888888889e-1 * t176 * t226 * t78 - 0.34416666666666666666666666666666666666666666666667e-1 * t198 * t199 * t157 + 0.91777777777777777777777777777777777777777777777778e-1 * t70 * t73 * t253 - 0.2e1 * t163 * t214 * t96 + t84 * (0.91777777777777777777777777777777777777777777777779e-1 * t167 * t226 * t126 + 0.45888888888888888888888888888888888888888888888889e-1 * t85 * t206 * t86 - 0.45888888888888888888888888888888888888888888888889e-1 * t176 * t226 * t40 - 0.24333333333333333333333333333333333333333333333333e-1 * t47 * t226))))
  v2rhosigma_0_ = 0.2e1 * r0 * t280 + 0.2e1 * t222
  t283 = 0.1e1 / s0
  t284 = t25 * t283
  t285 = t119 * t284
  t290 = 0.1e1 / t29 / s0
  t292 = t68 * t26 * t290
  t295 = t137 * t284
  t313 = t214 ** 2
  t316 = t283 * t48
  t337 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t65 * (-0.34416666666666666666666666666666666666666666666667e-1 * t285 * t211 * t127 + 0.17208333333333333333333333333333333333333333333334e-1 * t292 * t200 + 0.17208333333333333333333333333333333333333333333334e-1 * t295 * t211 * t74 - 0.68833333333333333333333333333333333333333333333334e-1 * t198 * t199 * t238 + t44 * (0.34416666666666666666666666666666666666666666666667e-1 * t285 * t211 * t146 - 0.17208333333333333333333333333333333333333333333334e-1 * t292 * t203 - 0.17208333333333333333333333333333333333333333333334e-1 * t295 * t211 * t78 - 0.68833333333333333333333333333333333333333333333334e-1 * t198 * t199 * t253 - 0.2e1 * t163 * t313 + t84 * (-0.34416666666666666666666666666666666666666666666667e-1 * t167 * t316 * t52 * t126 + 0.17208333333333333333333333333333333333333333333334e-1 * t85 * t290 * t30 * t207 + 0.17208333333333333333333333333333333333333333333334e-1 * t176 * t316 * t52 * t40))))
  v2sigma2_0_ = 0.2e1 * r0 * t337
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t26 = 6 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t30 = jnp.sqrt(s0)
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t30 * t31
  t41 = jnp.exp(-0.2e1 * t3 * t24 * (t27 / t24 * t32 / t18 / r0 / 0.12e2 - 0.3e1))
  t42 = 0.1e1 + t41
  t44 = 0.413e0 / t42
  t45 = 0.1227e1 - t44
  t46 = t24 ** 2
  t48 = t26 / t46
  t49 = t31 ** 2
  t50 = s0 * t49
  t51 = r0 ** 2
  t53 = 0.1e1 / t19 / t51
  t57 = 0.1227e1 - t44 + 0.91249999999999999999999999999999999999999999999998e-2 * t48 * t50 * t53
  t58 = 0.1e1 / t57
  t60 = -t45 * t58 + 0.1e1
  t62 = t45 * t60 + 0.1e1
  t67 = t17 / t19
  t68 = t42 ** 2
  t69 = 0.1e1 / t68
  t70 = t69 * t3
  t72 = t70 * t27 * t30
  t74 = 0.1e1 / t18 / t51
  t75 = t31 * t74
  t76 = t41 * t60
  t80 = t41 * t58
  t84 = t57 ** 2
  t85 = 0.1e1 / t84
  t86 = t45 * t85
  t87 = t70 * t27
  t92 = t51 * r0
  t98 = 0.91777777777777777777777777777777777777777777777778e-1 * t87 * t32 * t74 * t41 - 0.24333333333333333333333333333333333333333333333333e-1 * t48 * t50 / t19 / t92
  t100 = -0.91777777777777777777777777777777777777777777777778e-1 * t72 * t75 * t80 + t86 * t98
  t102 = 0.91777777777777777777777777777777777777777777777778e-1 * t72 * t75 * t76 + t45 * t100
  t106 = t17 * t18
  t108 = 0.1e1 / t68 / t42
  t109 = t3 ** 2
  t110 = t108 * t109
  t111 = t26 * s0
  t112 = t110 * t111
  t113 = t51 ** 2
  t115 = 0.1e1 / t19 / t113
  t116 = t49 * t115
  t117 = t41 ** 2
  t118 = t117 * t60
  t123 = 0.1e1 / t18 / t92
  t124 = t31 * t123
  t128 = t69 * t109
  t129 = t128 * t111
  t133 = t41 * t100
  t137 = t117 * t58
  t147 = t41 * t85
  t148 = t147 * t98
  t153 = 0.1e1 / t84 / t57
  t154 = t45 * t153
  t155 = t98 ** 2
  t158 = t110 * t26
  t167 = t128 * t26
  t175 = -0.24474074074074074074074074074074074074074074074074e0 * t158 * t50 * t115 * t117 - 0.21414814814814814814814814814814814814814814814815e0 * t87 * t32 * t123 * t41 + 0.12237037037037037037037037037037037037037037037037e0 * t167 * t50 * t115 * t41 + 0.89222222222222222222222222222222222222222222222221e-1 * t48 * t50 * t115
  t177 = 0.24474074074074074074074074074074074074074074074074e0 * t112 * t116 * t137 + 0.21414814814814814814814814814814814814814814814815e0 * t72 * t124 * t80 - 0.12237037037037037037037037037037037037037037037037e0 * t129 * t116 * t80 + 0.18355555555555555555555555555555555555555555555556e0 * t72 * t75 * t148 - 0.2e1 * t154 * t155 + t86 * t175
  t179 = -0.24474074074074074074074074074074074074074074074074e0 * t112 * t116 * t118 - 0.21414814814814814814814814814814814814814814814815e0 * t72 * t124 * t76 + 0.12237037037037037037037037037037037037037037037037e0 * t129 * t116 * t76 + 0.18355555555555555555555555555555555555555555555556e0 * t72 * t75 * t133 + t45 * t177
  t184 = f.my_piecewise3(t2, 0, t6 * t22 * t62 / 0.12e2 - t6 * t67 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t106 * t179)
  t196 = t68 ** 2
  t198 = t30 * s0
  t199 = 0.1e1 / t196 * t198
  t201 = 0.1e1 / t113 / t92
  t203 = t201 * t117 * t41
  t209 = 0.1e1 / t19 / t113 / r0
  t210 = t49 * t209
  t214 = t108 * t198
  t215 = t201 * t117
  t224 = 0.1e1 / t18 / t113
  t225 = t31 * t224
  t235 = t69 * t198
  t236 = t201 * t41
  t285 = t84 ** 2
  t317 = -0.58737777777777777777777777777777777777777777777778e1 * t199 * t203 * t58 - 0.17131851851851851851851851851851851851851851851852e1 * t112 * t210 * t137 + 0.58737777777777777777777777777777777777777777777777e1 * t214 * t215 * t58 - 0.73422222222222222222222222222222222222222222222223e0 * t112 * t116 * t117 * t85 * t98 - 0.71382716049382716049382716049382716049382716049383e0 * t72 * t225 * t80 + 0.85659259259259259259259259259259259259259259259259e0 * t129 * t210 * t80 - 0.64244444444444444444444444444444444444444444444446e0 * t72 * t124 * t148 - 0.97896296296296296296296296296296296296296296296296e0 * t235 * t236 * t58 + 0.36711111111111111111111111111111111111111111111112e0 * t129 * t116 * t148 - 0.55066666666666666666666666666666666666666666666668e0 * t72 * t75 * t41 * t153 * t155 + 0.27533333333333333333333333333333333333333333333334e0 * t72 * t75 * t147 * t175 + 0.6e1 * t45 / t285 * t155 * t98 - 0.6e1 * t154 * t98 * t175 + t86 * (0.58737777777777777777777777777777777777777777777778e1 * t199 * t203 + 0.17131851851851851851851851851851851851851851851852e1 * t158 * t50 * t209 * t117 - 0.58737777777777777777777777777777777777777777777777e1 * t214 * t215 + 0.71382716049382716049382716049382716049382716049383e0 * t87 * t32 * t224 * t41 - 0.85659259259259259259259259259259259259259259259259e0 * t167 * t50 * t209 * t41 + 0.97896296296296296296296296296296296296296296296296e0 * t235 * t236 - 0.41637037037037037037037037037037037037037037037036e0 * t48 * t50 * t209)
  t319 = 0.58737777777777777777777777777777777777777777777778e1 * t199 * t203 * t60 + 0.17131851851851851851851851851851851851851851851852e1 * t112 * t210 * t118 - 0.58737777777777777777777777777777777777777777777777e1 * t214 * t215 * t60 - 0.73422222222222222222222222222222222222222222222223e0 * t112 * t116 * t117 * t100 + 0.71382716049382716049382716049382716049382716049383e0 * t72 * t225 * t76 - 0.85659259259259259259259259259259259259259259259259e0 * t129 * t210 * t76 - 0.64244444444444444444444444444444444444444444444446e0 * t72 * t124 * t133 + 0.97896296296296296296296296296296296296296296296296e0 * t235 * t236 * t60 + 0.36711111111111111111111111111111111111111111111112e0 * t129 * t116 * t133 + 0.27533333333333333333333333333333333333333333333334e0 * t72 * t75 * t41 * t177 + t45 * t317
  t324 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t53 * t62 + t6 * t22 * t102 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t67 * t179 - 0.3e1 / 0.8e1 * t6 * t106 * t319)
  v3rho3_0_ = 0.2e1 * r0 * t324 + 0.6e1 * t184

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t27 = 6 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t31 = jnp.sqrt(s0)
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t31 * t32
  t42 = jnp.exp(-0.2e1 * t3 * t25 * (t28 / t25 * t33 / t19 / r0 / 0.12e2 - 0.3e1))
  t43 = 0.1e1 + t42
  t45 = 0.413e0 / t43
  t46 = 0.1227e1 - t45
  t47 = t25 ** 2
  t49 = t27 / t47
  t50 = t32 ** 2
  t51 = s0 * t50
  t55 = 0.1227e1 - t45 + 0.91249999999999999999999999999999999999999999999998e-2 * t49 * t51 * t22
  t56 = 0.1e1 / t55
  t58 = -t46 * t56 + 0.1e1
  t60 = t46 * t58 + 0.1e1
  t66 = t17 / t20 / r0
  t67 = t43 ** 2
  t68 = 0.1e1 / t67
  t69 = t68 * t3
  t70 = t28 * t31
  t71 = t69 * t70
  t73 = 0.1e1 / t19 / t18
  t74 = t32 * t73
  t75 = t42 * t58
  t79 = t42 * t56
  t83 = t55 ** 2
  t84 = 0.1e1 / t83
  t85 = t46 * t84
  t86 = t69 * t28
  t87 = t73 * t42
  t91 = t18 * r0
  t93 = 0.1e1 / t20 / t91
  t97 = 0.91777777777777777777777777777777777777777777777778e-1 * t86 * t33 * t87 - 0.24333333333333333333333333333333333333333333333333e-1 * t49 * t51 * t93
  t99 = -0.91777777777777777777777777777777777777777777777778e-1 * t71 * t74 * t79 + t85 * t97
  t101 = 0.91777777777777777777777777777777777777777777777778e-1 * t71 * t74 * t75 + t46 * t99
  t106 = t17 / t20
  t108 = 0.1e1 / t67 / t43
  t109 = t3 ** 2
  t110 = t108 * t109
  t111 = t27 * s0
  t112 = t110 * t111
  t113 = t18 ** 2
  t115 = 0.1e1 / t20 / t113
  t116 = t50 * t115
  t117 = t42 ** 2
  t118 = t117 * t58
  t123 = 0.1e1 / t19 / t91
  t124 = t32 * t123
  t128 = t68 * t109
  t129 = t128 * t111
  t133 = t42 * t99
  t137 = t117 * t56
  t147 = t42 * t84
  t148 = t147 * t97
  t153 = 0.1e1 / t83 / t55
  t154 = t46 * t153
  t155 = t97 ** 2
  t158 = t110 * t27
  t167 = t128 * t27
  t175 = -0.24474074074074074074074074074074074074074074074074e0 * t158 * t51 * t115 * t117 - 0.21414814814814814814814814814814814814814814814815e0 * t86 * t33 * t123 * t42 + 0.12237037037037037037037037037037037037037037037037e0 * t167 * t51 * t115 * t42 + 0.89222222222222222222222222222222222222222222222221e-1 * t49 * t51 * t115
  t177 = 0.24474074074074074074074074074074074074074074074074e0 * t112 * t116 * t137 + 0.21414814814814814814814814814814814814814814814815e0 * t71 * t124 * t79 - 0.12237037037037037037037037037037037037037037037037e0 * t129 * t116 * t79 + 0.18355555555555555555555555555555555555555555555556e0 * t71 * t74 * t148 - 0.2e1 * t154 * t155 + t85 * t175
  t179 = -0.24474074074074074074074074074074074074074074074074e0 * t112 * t116 * t118 - 0.21414814814814814814814814814814814814814814814815e0 * t71 * t124 * t75 + 0.12237037037037037037037037037037037037037037037037e0 * t129 * t116 * t75 + 0.18355555555555555555555555555555555555555555555556e0 * t71 * t74 * t133 + t46 * t177
  t183 = t17 * t19
  t184 = t67 ** 2
  t185 = 0.1e1 / t184
  t186 = t31 * s0
  t187 = t185 * t186
  t189 = 0.1e1 / t113 / t91
  t190 = t117 * t42
  t191 = t189 * t190
  t195 = t113 * r0
  t197 = 0.1e1 / t20 / t195
  t198 = t50 * t197
  t202 = t108 * t186
  t203 = t189 * t117
  t207 = t117 * t99
  t212 = 0.1e1 / t19 / t113
  t213 = t32 * t212
  t223 = t68 * t186
  t224 = t189 * t42
  t231 = t42 * t177
  t244 = t117 * t84
  t245 = t244 * t97
  t265 = t42 * t153 * t155
  t269 = t147 * t175
  t273 = t83 ** 2
  t274 = 0.1e1 / t273
  t275 = t46 * t274
  t276 = t155 * t97
  t303 = 0.58737777777777777777777777777777777777777777777778e1 * t187 * t191 + 0.17131851851851851851851851851851851851851851851852e1 * t158 * t51 * t197 * t117 - 0.58737777777777777777777777777777777777777777777777e1 * t202 * t203 + 0.71382716049382716049382716049382716049382716049383e0 * t86 * t33 * t212 * t42 - 0.85659259259259259259259259259259259259259259259259e0 * t167 * t51 * t197 * t42 + 0.97896296296296296296296296296296296296296296296296e0 * t223 * t224 - 0.41637037037037037037037037037037037037037037037036e0 * t49 * t51 * t197
  t305 = -0.58737777777777777777777777777777777777777777777778e1 * t187 * t191 * t56 - 0.17131851851851851851851851851851851851851851851852e1 * t112 * t198 * t137 + 0.58737777777777777777777777777777777777777777777777e1 * t202 * t203 * t56 - 0.73422222222222222222222222222222222222222222222223e0 * t112 * t116 * t245 - 0.71382716049382716049382716049382716049382716049383e0 * t71 * t213 * t79 + 0.85659259259259259259259259259259259259259259259259e0 * t129 * t198 * t79 - 0.64244444444444444444444444444444444444444444444446e0 * t71 * t124 * t148 - 0.97896296296296296296296296296296296296296296296296e0 * t223 * t224 * t56 + 0.36711111111111111111111111111111111111111111111112e0 * t129 * t116 * t148 - 0.55066666666666666666666666666666666666666666666668e0 * t71 * t74 * t265 + 0.27533333333333333333333333333333333333333333333334e0 * t71 * t74 * t269 + 0.6e1 * t275 * t276 - 0.6e1 * t154 * t97 * t175 + t85 * t303
  t307 = 0.58737777777777777777777777777777777777777777777778e1 * t187 * t191 * t58 + 0.17131851851851851851851851851851851851851851851852e1 * t112 * t198 * t118 - 0.58737777777777777777777777777777777777777777777777e1 * t202 * t203 * t58 - 0.73422222222222222222222222222222222222222222222223e0 * t112 * t116 * t207 + 0.71382716049382716049382716049382716049382716049383e0 * t71 * t213 * t75 - 0.85659259259259259259259259259259259259259259259259e0 * t129 * t198 * t75 - 0.64244444444444444444444444444444444444444444444446e0 * t71 * t124 * t133 + 0.97896296296296296296296296296296296296296296296296e0 * t223 * t224 * t58 + 0.36711111111111111111111111111111111111111111111112e0 * t129 * t116 * t133 + 0.27533333333333333333333333333333333333333333333334e0 * t71 * t74 * t231 + t46 * t305
  t312 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t60 + t6 * t66 * t101 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t106 * t179 - 0.3e1 / 0.8e1 * t6 * t183 * t307)
  t334 = s0 ** 2
  t335 = t68 * t334
  t336 = t113 ** 2
  t339 = 0.1e1 / t19 / t336 / r0
  t341 = t335 * t339 * t3
  t342 = t28 * t32
  t350 = 0.1e1 / t19 / t195
  t351 = t32 * t350
  t357 = 0.1e1 / t20 / t113 / t18
  t358 = t50 * t357
  t365 = 0.1e1 / t336
  t366 = t365 * t117
  t370 = t365 * t42
  t374 = t365 * t190
  t391 = 0.1e1 / t184 / t43 * t334
  t393 = t117 ** 2
  t400 = t185 * t334
  t412 = t108 * t334
  t437 = -0.52211358024691358024691358024691358024691358024692e1 * t391 * t339 * t393 * t3 * t342 - 0.82232888888888888888888888888888888888888888888890e2 * t187 * t374 + 0.78317037037037037037037037037037037037037037037037e1 * t400 * t339 * t190 * t3 * t342 - 0.11611588477366255144032921810699588477366255144033e2 * t158 * t51 * t357 * t117 + 0.82232888888888888888888888888888888888888888888888e2 * t202 * t366 - 0.30456625514403292181069958847736625514403292181069e1 * t412 * t339 * t117 * t3 * t342 - 0.30932510288065843621399176954732510288065843621399e1 * t86 * t33 * t350 * t42 + 0.58057942386831275720164609053497942386831275720164e1 * t167 * t51 * t357 * t42 - 0.13705481481481481481481481481481481481481481481481e2 * t223 * t370 + 0.21754732510288065843621399176954732510288065843621e0 * t335 * t339 * t3 * t28 * t32 * t42 + 0.23594320987654320987654320987654320987654320987654e1 * t49 * t51 * t357
  t442 = t155 ** 2
  t445 = t175 ** 2
  t461 = t391 * t339 * t393
  t463 = t56 * t3 * t342
  t466 = -0.8e1 * t154 * t97 * t303 - 0.82232888888888888888888888888888888888888888888888e2 * t202 * t366 * t56 + 0.13705481481481481481481481481481481481481481481481e2 * t223 * t370 * t56 + 0.82232888888888888888888888888888888888888888888890e2 * t187 * t374 * t56 - 0.23495111111111111111111111111111111111111111111112e2 * t202 * t189 * t245 + 0.39158518518518518518518518518518518518518518518520e1 * t223 * t189 * t148 + 0.23495111111111111111111111111111111111111111111112e2 * t187 * t189 * t190 * t84 * t97 + t85 * t437 - 0.24e2 * t46 / t273 / t55 * t442 - 0.6e1 * t154 * t445 - 0.58057942386831275720164609053497942386831275720164e1 * t129 * t358 * t79 + 0.30932510288065843621399176954732510288065843621399e1 * t71 * t351 * t79 + 0.11611588477366255144032921810699588477366255144033e2 * t112 * t358 * t137 - 0.21754732510288065843621399176954732510288065843621e0 * t341 * t342 * t79 + 0.52211358024691358024691358024691358024691358024692e1 * t461 * t463
  t468 = t400 * t339 * t190
  t472 = t412 * t339 * t117
  t524 = -0.78317037037037037037037037037037037037037037037037e1 * t468 * t463 + 0.30456625514403292181069958847736625514403292181069e1 * t472 * t463 - 0.14684444444444444444444444444444444444444444444445e1 * t129 * t116 * t265 + 0.22026666666666666666666666666666666666666666666667e1 * t71 * t74 * t42 * t274 * t276 + 0.29368888888888888888888888888888888888888888888890e1 * t112 * t116 * t117 * t153 * t155 + 0.73422222222222222222222222222222222222222222222224e0 * t129 * t116 * t269 + 0.36711111111111111111111111111111111111111111111112e0 * t71 * t74 * t147 * t303 + 0.28553086419753086419753086419753086419753086419753e1 * t71 * t213 * t148 - 0.34263703703703703703703703703703703703703703703704e1 * t129 * t198 * t148 - 0.12848888888888888888888888888888888888888888888889e1 * t71 * t124 * t269 + 0.68527407407407407407407407407407407407407407407408e1 * t112 * t198 * t245 - 0.14684444444444444444444444444444444444444444444445e1 * t112 * t116 * t244 * t175 + 0.25697777777777777777777777777777777777777777777778e1 * t71 * t124 * t265 + 0.36e2 * t275 * t155 * t175 - 0.22026666666666666666666666666666666666666666666668e1 * t69 * t70 * t32 * t87 * t153 * t97 * t175
  t556 = t58 * t3 * t342
  t570 = -0.23495111111111111111111111111111111111111111111112e2 * t202 * t203 * t99 - 0.13705481481481481481481481481481481481481481481481e2 * t223 * t370 * t58 + 0.39158518518518518518518518518518518518518518518520e1 * t223 * t224 * t99 + 0.28553086419753086419753086419753086419753086419753e1 * t71 * t213 * t133 + 0.58057942386831275720164609053497942386831275720164e1 * t129 * t358 * t75 - 0.34263703703703703703703703703703703703703703703704e1 * t129 * t198 * t133 - 0.52211358024691358024691358024691358024691358024692e1 * t461 * t556 + 0.78317037037037037037037037037037037037037037037037e1 * t468 * t556 + 0.68527407407407407407407407407407407407407407407408e1 * t112 * t198 * t207 - 0.30456625514403292181069958847736625514403292181069e1 * t472 * t556 - 0.14684444444444444444444444444444444444444444444445e1 * t112 * t116 * t117 * t177
  t576 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t93 * t60 - 0.5e1 / 0.9e1 * t6 * t23 * t101 + t6 * t66 * t179 / 0.2e1 - t6 * t106 * t307 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t183 * (0.36711111111111111111111111111111111111111111111112e0 * t71 * t74 * t42 * t305 - 0.12848888888888888888888888888888888888888888888889e1 * t71 * t124 * t231 + 0.21754732510288065843621399176954732510288065843621e0 * t341 * t342 * t75 + 0.73422222222222222222222222222222222222222222222224e0 * t129 * t116 * t231 - 0.30932510288065843621399176954732510288065843621399e1 * t71 * t351 * t75 - 0.11611588477366255144032921810699588477366255144033e2 * t112 * t358 * t118 + t46 * (t466 + t524) - 0.82232888888888888888888888888888888888888888888890e2 * t187 * t374 * t58 + 0.23495111111111111111111111111111111111111111111112e2 * t187 * t191 * t99 + 0.82232888888888888888888888888888888888888888888888e2 * t202 * t366 * t58 + t570))
  v4rho4_0_ = 0.2e1 * r0 * t576 + 0.8e1 * t312

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = jnp.pi ** 2
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t2 * t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = t36 / t33
  t39 = jnp.sqrt(s0)
  t40 = r0 ** (0.1e1 / 0.3e1)
  t49 = jnp.exp(-0.2e1 * t34 * (t38 * t39 / t40 / r0 / 0.12e2 - 0.3e1))
  t50 = 0.1e1 + t49
  t52 = 0.413e0 / t50
  t53 = 0.1227e1 - t52
  t54 = t33 ** 2
  t56 = t35 / t54
  t57 = r0 ** 2
  t58 = t40 ** 2
  t64 = 0.1227e1 - t52 + 0.91249999999999999999999999999999999999999999999998e-2 * t56 * s0 / t58 / t57
  t65 = 0.1e1 / t64
  t67 = -t53 * t65 + 0.1e1
  t69 = t53 * t67 + 0.1e1
  t73 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t74 = t73 * f.p.zeta_threshold
  t76 = f.my_piecewise3(t20, t74, t21 * t19)
  t77 = t30 ** 2
  t78 = 0.1e1 / t77
  t79 = t76 * t78
  t82 = t5 * t79 * t69 / 0.8e1
  t83 = t76 * t30
  t84 = t50 ** 2
  t85 = 0.1e1 / t84
  t86 = t85 * t2
  t87 = t86 * t36
  t89 = 0.1e1 / t40 / t57
  t90 = t39 * t89
  t91 = t49 * t67
  t95 = t49 * t65
  t99 = t64 ** 2
  t100 = 0.1e1 / t99
  t101 = t53 * t100
  t105 = t57 * r0
  t111 = 0.91777777777777777777777777777777777777777777777778e-1 * t87 * t90 * t49 - 0.24333333333333333333333333333333333333333333333333e-1 * t56 * s0 / t58 / t105
  t113 = -0.91777777777777777777777777777777777777777777777778e-1 * t87 * t90 * t95 + t101 * t111
  t115 = 0.91777777777777777777777777777777777777777777777778e-1 * t87 * t90 * t91 + t53 * t113
  t120 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t69 - t82 - 0.3e1 / 0.8e1 * t5 * t83 * t115)
  t122 = r1 <= f.p.dens_threshold
  t123 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t124 = 0.1e1 + t123
  t125 = t124 <= f.p.zeta_threshold
  t126 = t124 ** (0.1e1 / 0.3e1)
  t128 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t131 = f.my_piecewise3(t125, 0, 0.4e1 / 0.3e1 * t126 * t128)
  t132 = t131 * t30
  t133 = jnp.sqrt(s2)
  t134 = r1 ** (0.1e1 / 0.3e1)
  t143 = jnp.exp(-0.2e1 * t34 * (t38 * t133 / t134 / r1 / 0.12e2 - 0.3e1))
  t144 = 0.1e1 + t143
  t146 = 0.413e0 / t144
  t147 = 0.1227e1 - t146
  t148 = r1 ** 2
  t149 = t134 ** 2
  t155 = 0.1227e1 - t146 + 0.91249999999999999999999999999999999999999999999998e-2 * t56 * s2 / t149 / t148
  t156 = 0.1e1 / t155
  t158 = -t147 * t156 + 0.1e1
  t160 = t147 * t158 + 0.1e1
  t165 = f.my_piecewise3(t125, t74, t126 * t124)
  t166 = t165 * t78
  t169 = t5 * t166 * t160 / 0.8e1
  t171 = f.my_piecewise3(t122, 0, -0.3e1 / 0.8e1 * t5 * t132 * t160 - t169)
  t173 = t21 ** 2
  t174 = 0.1e1 / t173
  t175 = t26 ** 2
  t180 = t16 / t22 / t6
  t182 = -0.2e1 * t23 + 0.2e1 * t180
  t183 = f.my_piecewise5(t10, 0, t14, 0, t182)
  t187 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t174 * t175 + 0.4e1 / 0.3e1 * t21 * t183)
  t194 = t5 * t29 * t78 * t69
  t200 = 0.1e1 / t77 / t6
  t204 = t5 * t76 * t200 * t69 / 0.12e2
  t206 = t5 * t79 * t115
  t210 = t2 ** 2
  t212 = 0.1e1 / t84 / t50 * t210 * t35
  t213 = t57 ** 2
  t216 = s0 / t58 / t213
  t217 = t49 ** 2
  t224 = t39 / t40 / t105
  t229 = t85 * t210 * t35
  t257 = t111 ** 2
  t280 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t187 * t30 * t69 - t194 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t115 + t204 - t206 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t83 * (-0.24474074074074074074074074074074074074074074074074e0 * t212 * t216 * t217 * t67 - 0.21414814814814814814814814814814814814814814814815e0 * t87 * t224 * t91 + 0.12237037037037037037037037037037037037037037037037e0 * t229 * t216 * t91 + 0.18355555555555555555555555555555555555555555555556e0 * t87 * t90 * t49 * t113 + t53 * (0.24474074074074074074074074074074074074074074074074e0 * t212 * t216 * t217 * t65 + 0.21414814814814814814814814814814814814814814814815e0 * t87 * t224 * t95 - 0.12237037037037037037037037037037037037037037037037e0 * t229 * t216 * t95 + 0.18355555555555555555555555555555555555555555555556e0 * t86 * t36 * t39 * t89 * t49 * t100 * t111 - 0.2e1 * t53 / t99 / t64 * t257 + t101 * (-0.24474074074074074074074074074074074074074074074074e0 * t212 * t216 * t217 - 0.21414814814814814814814814814814814814814814814815e0 * t87 * t224 * t49 + 0.12237037037037037037037037037037037037037037037037e0 * t229 * t216 * t49 + 0.89222222222222222222222222222222222222222222222221e-1 * t56 * t216))))
  t281 = t126 ** 2
  t282 = 0.1e1 / t281
  t283 = t128 ** 2
  t287 = f.my_piecewise5(t14, 0, t10, 0, -t182)
  t291 = f.my_piecewise3(t125, 0, 0.4e1 / 0.9e1 * t282 * t283 + 0.4e1 / 0.3e1 * t126 * t287)
  t298 = t5 * t131 * t78 * t160
  t303 = t5 * t165 * t200 * t160 / 0.12e2
  t305 = f.my_piecewise3(t122, 0, -0.3e1 / 0.8e1 * t5 * t291 * t30 * t160 - t298 / 0.4e1 + t303)
  d11 = 0.2e1 * t120 + 0.2e1 * t171 + t6 * (t280 + t305)
  t308 = -t7 - t24
  t309 = f.my_piecewise5(t10, 0, t14, 0, t308)
  t312 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t309)
  t313 = t312 * t30
  t318 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t313 * t69 - t82)
  t320 = f.my_piecewise5(t14, 0, t10, 0, -t308)
  t323 = f.my_piecewise3(t125, 0, 0.4e1 / 0.3e1 * t126 * t320)
  t324 = t323 * t30
  t328 = t165 * t30
  t329 = t144 ** 2
  t330 = 0.1e1 / t329
  t331 = t330 * t2
  t332 = t331 * t36
  t334 = 0.1e1 / t134 / t148
  t335 = t133 * t334
  t336 = t143 * t158
  t340 = t143 * t156
  t344 = t155 ** 2
  t345 = 0.1e1 / t344
  t346 = t147 * t345
  t350 = t148 * r1
  t356 = 0.91777777777777777777777777777777777777777777777778e-1 * t332 * t335 * t143 - 0.24333333333333333333333333333333333333333333333333e-1 * t56 * s2 / t149 / t350
  t358 = -0.91777777777777777777777777777777777777777777777778e-1 * t332 * t335 * t340 + t346 * t356
  t360 = 0.91777777777777777777777777777777777777777777777778e-1 * t332 * t335 * t336 + t147 * t358
  t365 = f.my_piecewise3(t122, 0, -0.3e1 / 0.8e1 * t5 * t324 * t160 - t169 - 0.3e1 / 0.8e1 * t5 * t328 * t360)
  t369 = 0.2e1 * t180
  t370 = f.my_piecewise5(t10, 0, t14, 0, t369)
  t374 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t174 * t309 * t26 + 0.4e1 / 0.3e1 * t21 * t370)
  t381 = t5 * t312 * t78 * t69
  t389 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t374 * t30 * t69 - t381 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t313 * t115 - t194 / 0.8e1 + t204 - t206 / 0.8e1)
  t393 = f.my_piecewise5(t14, 0, t10, 0, -t369)
  t397 = f.my_piecewise3(t125, 0, 0.4e1 / 0.9e1 * t282 * t320 * t128 + 0.4e1 / 0.3e1 * t126 * t393)
  t404 = t5 * t323 * t78 * t160
  t411 = t5 * t166 * t360
  t414 = f.my_piecewise3(t122, 0, -0.3e1 / 0.8e1 * t5 * t397 * t30 * t160 - t404 / 0.8e1 - t298 / 0.8e1 + t303 - 0.3e1 / 0.8e1 * t5 * t132 * t360 - t411 / 0.8e1)
  d12 = t120 + t171 + t318 + t365 + t6 * (t389 + t414)
  t419 = t309 ** 2
  t423 = 0.2e1 * t23 + 0.2e1 * t180
  t424 = f.my_piecewise5(t10, 0, t14, 0, t423)
  t428 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t174 * t419 + 0.4e1 / 0.3e1 * t21 * t424)
  t435 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t428 * t30 * t69 - t381 / 0.4e1 + t204)
  t436 = t320 ** 2
  t440 = f.my_piecewise5(t14, 0, t10, 0, -t423)
  t444 = f.my_piecewise3(t125, 0, 0.4e1 / 0.9e1 * t282 * t436 + 0.4e1 / 0.3e1 * t126 * t440)
  t457 = 0.1e1 / t329 / t144 * t210 * t35
  t458 = t148 ** 2
  t461 = s2 / t149 / t458
  t462 = t143 ** 2
  t469 = t133 / t134 / t350
  t474 = t330 * t210 * t35
  t502 = t356 ** 2
  t525 = f.my_piecewise3(t122, 0, -0.3e1 / 0.8e1 * t5 * t444 * t30 * t160 - t404 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t324 * t360 + t303 - t411 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t328 * (-0.24474074074074074074074074074074074074074074074074e0 * t457 * t461 * t462 * t158 - 0.21414814814814814814814814814814814814814814814815e0 * t332 * t469 * t336 + 0.12237037037037037037037037037037037037037037037037e0 * t474 * t461 * t336 + 0.18355555555555555555555555555555555555555555555556e0 * t332 * t335 * t143 * t358 + t147 * (0.24474074074074074074074074074074074074074074074074e0 * t457 * t461 * t462 * t156 + 0.21414814814814814814814814814814814814814814814815e0 * t332 * t469 * t340 - 0.12237037037037037037037037037037037037037037037037e0 * t474 * t461 * t340 + 0.18355555555555555555555555555555555555555555555556e0 * t331 * t36 * t133 * t334 * t143 * t345 * t356 - 0.2e1 * t147 / t344 / t155 * t502 + t346 * (-0.24474074074074074074074074074074074074074074074074e0 * t457 * t461 * t462 - 0.21414814814814814814814814814814814814814814814815e0 * t332 * t469 * t143 + 0.12237037037037037037037037037037037037037037037037e0 * t474 * t461 * t143 + 0.89222222222222222222222222222222222222222222222221e-1 * t56 * t461))))
  d22 = 0.2e1 * t318 + 0.2e1 * t365 + t6 * (t435 + t525)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = jnp.pi ** 2
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = t2 * t45
  t47 = 6 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t50 = t48 / t45
  t51 = jnp.sqrt(s0)
  t52 = r0 ** (0.1e1 / 0.3e1)
  t61 = jnp.exp(-0.2e1 * t46 * (t50 * t51 / t52 / r0 / 0.12e2 - 0.3e1))
  t62 = 0.1e1 + t61
  t64 = 0.413e0 / t62
  t65 = 0.1227e1 - t64
  t66 = t45 ** 2
  t68 = t47 / t66
  t69 = r0 ** 2
  t70 = t52 ** 2
  t76 = 0.1227e1 - t64 + 0.91249999999999999999999999999999999999999999999998e-2 * t68 * s0 / t70 / t69
  t77 = 0.1e1 / t76
  t79 = -t65 * t77 + 0.1e1
  t81 = t65 * t79 + 0.1e1
  t87 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t88 = t42 ** 2
  t89 = 0.1e1 / t88
  t90 = t87 * t89
  t94 = t87 * t42
  t95 = t62 ** 2
  t96 = 0.1e1 / t95
  t97 = t96 * t2
  t98 = t97 * t48
  t100 = 0.1e1 / t52 / t69
  t101 = t51 * t100
  t102 = t61 * t79
  t106 = t61 * t77
  t110 = t76 ** 2
  t111 = 0.1e1 / t110
  t112 = t65 * t111
  t116 = t69 * r0
  t122 = 0.91777777777777777777777777777777777777777777777778e-1 * t98 * t101 * t61 - 0.24333333333333333333333333333333333333333333333333e-1 * t68 * s0 / t70 / t116
  t124 = -0.91777777777777777777777777777777777777777777777778e-1 * t98 * t101 * t106 + t112 * t122
  t126 = 0.91777777777777777777777777777777777777777777777778e-1 * t98 * t101 * t102 + t65 * t124
  t130 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t131 = t130 * f.p.zeta_threshold
  t133 = f.my_piecewise3(t20, t131, t21 * t19)
  t135 = 0.1e1 / t88 / t6
  t136 = t133 * t135
  t140 = t133 * t89
  t144 = t133 * t42
  t146 = 0.1e1 / t95 / t62
  t147 = t2 ** 2
  t148 = t146 * t147
  t149 = t148 * t47
  t150 = t69 ** 2
  t152 = 0.1e1 / t70 / t150
  t153 = s0 * t152
  t154 = t61 ** 2
  t155 = t154 * t79
  t160 = 0.1e1 / t52 / t116
  t161 = t51 * t160
  t165 = t96 * t147
  t166 = t165 * t47
  t170 = t61 * t124
  t174 = t154 * t77
  t185 = t97 * t48 * t51
  t186 = t100 * t61
  t187 = t111 * t122
  t192 = 0.1e1 / t110 / t76
  t193 = t65 * t192
  t194 = t122 ** 2
  t208 = -0.24474074074074074074074074074074074074074074074074e0 * t149 * t153 * t154 - 0.21414814814814814814814814814814814814814814814815e0 * t98 * t161 * t61 + 0.12237037037037037037037037037037037037037037037037e0 * t166 * t153 * t61 + 0.89222222222222222222222222222222222222222222222221e-1 * t68 * t153
  t210 = 0.24474074074074074074074074074074074074074074074074e0 * t149 * t153 * t174 + 0.21414814814814814814814814814814814814814814814815e0 * t98 * t161 * t106 - 0.12237037037037037037037037037037037037037037037037e0 * t166 * t153 * t106 + 0.18355555555555555555555555555555555555555555555556e0 * t185 * t186 * t187 - 0.2e1 * t193 * t194 + t112 * t208
  t212 = -0.24474074074074074074074074074074074074074074074074e0 * t149 * t153 * t155 - 0.21414814814814814814814814814814814814814814814815e0 * t98 * t161 * t102 + 0.12237037037037037037037037037037037037037037037037e0 * t166 * t153 * t102 + 0.18355555555555555555555555555555555555555555555556e0 * t98 * t101 * t170 + t65 * t210
  t217 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t81 - t5 * t90 * t81 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t94 * t126 + t5 * t136 * t81 / 0.12e2 - t5 * t140 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t144 * t212)
  t219 = r1 <= f.p.dens_threshold
  t220 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t221 = 0.1e1 + t220
  t222 = t221 <= f.p.zeta_threshold
  t223 = t221 ** (0.1e1 / 0.3e1)
  t224 = t223 ** 2
  t225 = 0.1e1 / t224
  t227 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t228 = t227 ** 2
  t232 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t236 = f.my_piecewise3(t222, 0, 0.4e1 / 0.9e1 * t225 * t228 + 0.4e1 / 0.3e1 * t223 * t232)
  t238 = jnp.sqrt(s2)
  t239 = r1 ** (0.1e1 / 0.3e1)
  t248 = jnp.exp(-0.2e1 * t46 * (t50 * t238 / t239 / r1 / 0.12e2 - 0.3e1))
  t251 = 0.413e0 / (0.1e1 + t248)
  t252 = 0.1227e1 - t251
  t253 = r1 ** 2
  t254 = t239 ** 2
  t265 = 0.1e1 + t252 * (0.1e1 - t252 / (0.1227e1 - t251 + 0.91249999999999999999999999999999999999999999999998e-2 * t68 * s2 / t254 / t253))
  t271 = f.my_piecewise3(t222, 0, 0.4e1 / 0.3e1 * t223 * t227)
  t277 = f.my_piecewise3(t222, t131, t223 * t221)
  t283 = f.my_piecewise3(t219, 0, -0.3e1 / 0.8e1 * t5 * t236 * t42 * t265 - t5 * t271 * t89 * t265 / 0.4e1 + t5 * t277 * t135 * t265 / 0.12e2)
  t293 = t24 ** 2
  t297 = 0.6e1 * t33 - 0.6e1 * t16 / t293
  t298 = f.my_piecewise5(t10, 0, t14, 0, t297)
  t302 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t298)
  t325 = 0.1e1 / t88 / t24
  t336 = t95 ** 2
  t338 = t51 * s0
  t339 = 0.1e1 / t336 * t338
  t341 = 0.1e1 / t150 / t116
  t343 = t341 * t154 * t61
  t350 = s0 / t70 / t150 / r0
  t354 = t146 * t338
  t355 = t341 * t154
  t365 = t51 / t52 / t150
  t375 = t96 * t338
  t376 = t341 * t61
  t396 = t47 * s0
  t428 = t110 ** 2
  t456 = -0.29368888888888888888888888888888888888888888888889e1 * t339 * t343 * t77 - 0.17131851851851851851851851851851851851851851851852e1 * t149 * t350 * t174 + 0.29368888888888888888888888888888888888888888888889e1 * t354 * t355 * t77 - 0.73422222222222222222222222222222222222222222222223e0 * t148 * t396 * t152 * t154 * t187 - 0.71382716049382716049382716049382716049382716049383e0 * t98 * t365 * t106 + 0.85659259259259259259259259259259259259259259259259e0 * t166 * t350 * t106 - 0.64244444444444444444444444444444444444444444444446e0 * t185 * t160 * t61 * t187 - 0.48948148148148148148148148148148148148148148148148e0 * t375 * t376 * t77 + 0.36711111111111111111111111111111111111111111111112e0 * t165 * t396 * t152 * t61 * t187 - 0.55066666666666666666666666666666666666666666666668e0 * t185 * t186 * t192 * t194 + 0.27533333333333333333333333333333333333333333333334e0 * t185 * t186 * t111 * t208 + 0.6e1 * t65 / t428 * t194 * t122 - 0.6e1 * t193 * t122 * t208 + t112 * (0.29368888888888888888888888888888888888888888888889e1 * t339 * t343 + 0.17131851851851851851851851851851851851851851851852e1 * t149 * t350 * t154 - 0.29368888888888888888888888888888888888888888888889e1 * t354 * t355 + 0.71382716049382716049382716049382716049382716049383e0 * t98 * t365 * t61 - 0.85659259259259259259259259259259259259259259259259e0 * t166 * t350 * t61 + 0.48948148148148148148148148148148148148148148148148e0 * t375 * t376 - 0.41637037037037037037037037037037037037037037037036e0 * t68 * t350)
  t458 = 0.29368888888888888888888888888888888888888888888889e1 * t339 * t343 * t79 + 0.17131851851851851851851851851851851851851851851852e1 * t149 * t350 * t155 - 0.29368888888888888888888888888888888888888888888889e1 * t354 * t355 * t79 - 0.73422222222222222222222222222222222222222222222223e0 * t149 * t153 * t154 * t124 + 0.71382716049382716049382716049382716049382716049383e0 * t98 * t365 * t102 - 0.85659259259259259259259259259259259259259259259259e0 * t166 * t350 * t102 - 0.64244444444444444444444444444444444444444444444446e0 * t98 * t161 * t170 + 0.48948148148148148148148148148148148148148148148148e0 * t375 * t376 * t79 + 0.36711111111111111111111111111111111111111111111112e0 * t166 * t153 * t170 + 0.27533333333333333333333333333333333333333333333334e0 * t98 * t101 * t61 * t210 + t65 * t456
  t463 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t302 * t42 * t81 - 0.3e1 / 0.8e1 * t5 * t41 * t89 * t81 - 0.9e1 / 0.8e1 * t5 * t43 * t126 + t5 * t87 * t135 * t81 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t90 * t126 - 0.9e1 / 0.8e1 * t5 * t94 * t212 - 0.5e1 / 0.36e2 * t5 * t133 * t325 * t81 + t5 * t136 * t126 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t140 * t212 - 0.3e1 / 0.8e1 * t5 * t144 * t458)
  t473 = f.my_piecewise5(t14, 0, t10, 0, -t297)
  t477 = f.my_piecewise3(t222, 0, -0.8e1 / 0.27e2 / t224 / t221 * t228 * t227 + 0.4e1 / 0.3e1 * t225 * t227 * t232 + 0.4e1 / 0.3e1 * t223 * t473)
  t495 = f.my_piecewise3(t219, 0, -0.3e1 / 0.8e1 * t5 * t477 * t42 * t265 - 0.3e1 / 0.8e1 * t5 * t236 * t89 * t265 + t5 * t271 * t135 * t265 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t277 * t325 * t265)
  d111 = 0.3e1 * t217 + 0.3e1 * t283 + t6 * (t463 + t495)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = jnp.pi ** 2
  t57 = t56 ** (0.1e1 / 0.3e1)
  t58 = t2 * t57
  t59 = 6 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t62 = t60 / t57
  t63 = jnp.sqrt(s0)
  t64 = r0 ** (0.1e1 / 0.3e1)
  t73 = jnp.exp(-0.2e1 * t58 * (t62 * t63 / t64 / r0 / 0.12e2 - 0.3e1))
  t74 = 0.1e1 + t73
  t76 = 0.413e0 / t74
  t77 = 0.1227e1 - t76
  t78 = t57 ** 2
  t80 = t59 / t78
  t81 = r0 ** 2
  t82 = t64 ** 2
  t88 = 0.1227e1 - t76 + 0.91249999999999999999999999999999999999999999999998e-2 * t80 * s0 / t82 / t81
  t89 = 0.1e1 / t88
  t91 = -t77 * t89 + 0.1e1
  t93 = t77 * t91 + 0.1e1
  t102 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t103 = t54 ** 2
  t104 = 0.1e1 / t103
  t105 = t102 * t104
  t109 = t102 * t54
  t110 = t74 ** 2
  t111 = 0.1e1 / t110
  t112 = t111 * t2
  t113 = t112 * t60
  t115 = 0.1e1 / t64 / t81
  t116 = t63 * t115
  t117 = t73 * t91
  t121 = t73 * t89
  t125 = t88 ** 2
  t126 = 0.1e1 / t125
  t127 = t77 * t126
  t131 = t81 * r0
  t137 = 0.91777777777777777777777777777777777777777777777778e-1 * t113 * t116 * t73 - 0.24333333333333333333333333333333333333333333333333e-1 * t80 * s0 / t82 / t131
  t139 = -0.91777777777777777777777777777777777777777777777778e-1 * t113 * t116 * t121 + t127 * t137
  t141 = 0.91777777777777777777777777777777777777777777777778e-1 * t113 * t116 * t117 + t77 * t139
  t147 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t149 = 0.1e1 / t103 / t6
  t150 = t147 * t149
  t154 = t147 * t104
  t158 = t147 * t54
  t160 = 0.1e1 / t110 / t74
  t161 = t2 ** 2
  t162 = t160 * t161
  t163 = t162 * t59
  t164 = t81 ** 2
  t166 = 0.1e1 / t82 / t164
  t167 = s0 * t166
  t168 = t73 ** 2
  t169 = t168 * t91
  t174 = 0.1e1 / t64 / t131
  t175 = t63 * t174
  t179 = t111 * t161
  t180 = t179 * t59
  t184 = t73 * t139
  t188 = t168 * t89
  t199 = t112 * t60 * t63
  t200 = t115 * t73
  t201 = t126 * t137
  t206 = 0.1e1 / t125 / t88
  t207 = t77 * t206
  t208 = t137 ** 2
  t222 = -0.24474074074074074074074074074074074074074074074074e0 * t163 * t167 * t168 - 0.21414814814814814814814814814814814814814814814815e0 * t113 * t175 * t73 + 0.12237037037037037037037037037037037037037037037037e0 * t180 * t167 * t73 + 0.89222222222222222222222222222222222222222222222221e-1 * t80 * t167
  t224 = 0.24474074074074074074074074074074074074074074074074e0 * t163 * t167 * t188 + 0.21414814814814814814814814814814814814814814814815e0 * t113 * t175 * t121 - 0.12237037037037037037037037037037037037037037037037e0 * t180 * t167 * t121 + 0.18355555555555555555555555555555555555555555555556e0 * t199 * t200 * t201 - 0.2e1 * t207 * t208 + t127 * t222
  t226 = -0.24474074074074074074074074074074074074074074074074e0 * t163 * t167 * t169 - 0.21414814814814814814814814814814814814814814814815e0 * t113 * t175 * t117 + 0.12237037037037037037037037037037037037037037037037e0 * t180 * t167 * t117 + 0.18355555555555555555555555555555555555555555555556e0 * t113 * t116 * t184 + t77 * t224
  t230 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t231 = t230 * f.p.zeta_threshold
  t233 = f.my_piecewise3(t20, t231, t21 * t19)
  t235 = 0.1e1 / t103 / t25
  t236 = t233 * t235
  t240 = t233 * t149
  t244 = t233 * t104
  t248 = t233 * t54
  t249 = t110 ** 2
  t250 = 0.1e1 / t249
  t251 = t63 * s0
  t252 = t250 * t251
  t254 = 0.1e1 / t164 / t131
  t255 = t168 * t73
  t256 = t254 * t255
  t260 = t164 * r0
  t262 = 0.1e1 / t82 / t260
  t263 = s0 * t262
  t267 = t160 * t251
  t268 = t254 * t168
  t272 = t168 * t139
  t277 = 0.1e1 / t64 / t164
  t278 = t63 * t277
  t288 = t111 * t251
  t289 = t254 * t73
  t296 = t73 * t224
  t309 = t59 * s0
  t310 = t162 * t309
  t311 = t166 * t168
  t321 = t174 * t73
  t328 = t179 * t309
  t329 = t166 * t73
  t333 = t206 * t208
  t337 = t126 * t222
  t341 = t125 ** 2
  t342 = 0.1e1 / t341
  t343 = t77 * t342
  t344 = t208 * t137
  t367 = 0.29368888888888888888888888888888888888888888888889e1 * t252 * t256 + 0.17131851851851851851851851851851851851851851851852e1 * t163 * t263 * t168 - 0.29368888888888888888888888888888888888888888888889e1 * t267 * t268 + 0.71382716049382716049382716049382716049382716049383e0 * t113 * t278 * t73 - 0.85659259259259259259259259259259259259259259259259e0 * t180 * t263 * t73 + 0.48948148148148148148148148148148148148148148148148e0 * t288 * t289 - 0.41637037037037037037037037037037037037037037037036e0 * t80 * t263
  t369 = -0.29368888888888888888888888888888888888888888888889e1 * t252 * t256 * t89 - 0.17131851851851851851851851851851851851851851851852e1 * t163 * t263 * t188 + 0.29368888888888888888888888888888888888888888888889e1 * t267 * t268 * t89 - 0.73422222222222222222222222222222222222222222222223e0 * t310 * t311 * t201 - 0.71382716049382716049382716049382716049382716049383e0 * t113 * t278 * t121 + 0.85659259259259259259259259259259259259259259259259e0 * t180 * t263 * t121 - 0.64244444444444444444444444444444444444444444444446e0 * t199 * t321 * t201 - 0.48948148148148148148148148148148148148148148148148e0 * t288 * t289 * t89 + 0.36711111111111111111111111111111111111111111111112e0 * t328 * t329 * t201 - 0.55066666666666666666666666666666666666666666666668e0 * t199 * t200 * t333 + 0.27533333333333333333333333333333333333333333333334e0 * t199 * t200 * t337 + 0.6e1 * t343 * t344 - 0.6e1 * t207 * t137 * t222 + t127 * t367
  t371 = 0.29368888888888888888888888888888888888888888888889e1 * t252 * t256 * t91 + 0.17131851851851851851851851851851851851851851851852e1 * t163 * t263 * t169 - 0.29368888888888888888888888888888888888888888888889e1 * t267 * t268 * t91 - 0.73422222222222222222222222222222222222222222222223e0 * t163 * t167 * t272 + 0.71382716049382716049382716049382716049382716049383e0 * t113 * t278 * t117 - 0.85659259259259259259259259259259259259259259259259e0 * t180 * t263 * t117 - 0.64244444444444444444444444444444444444444444444446e0 * t113 * t175 * t184 + 0.48948148148148148148148148148148148148148148148148e0 * t288 * t289 * t91 + 0.36711111111111111111111111111111111111111111111112e0 * t180 * t167 * t184 + 0.27533333333333333333333333333333333333333333333334e0 * t113 * t116 * t296 + t77 * t369
  t376 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t93 - 0.3e1 / 0.8e1 * t5 * t105 * t93 - 0.9e1 / 0.8e1 * t5 * t109 * t141 + t5 * t150 * t93 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t154 * t141 - 0.9e1 / 0.8e1 * t5 * t158 * t226 - 0.5e1 / 0.36e2 * t5 * t236 * t93 + t5 * t240 * t141 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t244 * t226 - 0.3e1 / 0.8e1 * t5 * t248 * t371)
  t378 = r1 <= f.p.dens_threshold
  t379 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t380 = 0.1e1 + t379
  t381 = t380 <= f.p.zeta_threshold
  t382 = t380 ** (0.1e1 / 0.3e1)
  t383 = t382 ** 2
  t385 = 0.1e1 / t383 / t380
  t387 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t388 = t387 ** 2
  t392 = 0.1e1 / t383
  t393 = t392 * t387
  t395 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t399 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t403 = f.my_piecewise3(t381, 0, -0.8e1 / 0.27e2 * t385 * t388 * t387 + 0.4e1 / 0.3e1 * t393 * t395 + 0.4e1 / 0.3e1 * t382 * t399)
  t405 = jnp.sqrt(s2)
  t406 = r1 ** (0.1e1 / 0.3e1)
  t415 = jnp.exp(-0.2e1 * t58 * (t62 * t405 / t406 / r1 / 0.12e2 - 0.3e1))
  t418 = 0.413e0 / (0.1e1 + t415)
  t419 = 0.1227e1 - t418
  t420 = r1 ** 2
  t421 = t406 ** 2
  t432 = 0.1e1 + t419 * (0.1e1 - t419 / (0.1227e1 - t418 + 0.91249999999999999999999999999999999999999999999998e-2 * t80 * s2 / t421 / t420))
  t441 = f.my_piecewise3(t381, 0, 0.4e1 / 0.9e1 * t392 * t388 + 0.4e1 / 0.3e1 * t382 * t395)
  t448 = f.my_piecewise3(t381, 0, 0.4e1 / 0.3e1 * t382 * t387)
  t454 = f.my_piecewise3(t381, t231, t382 * t380)
  t460 = f.my_piecewise3(t378, 0, -0.3e1 / 0.8e1 * t5 * t403 * t54 * t432 - 0.3e1 / 0.8e1 * t5 * t441 * t104 * t432 + t5 * t448 * t149 * t432 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t454 * t235 * t432)
  t465 = s0 ** 2
  t467 = t164 ** 2
  t470 = 0.1e1 / t64 / t467 / r0
  t471 = t111 * t465 * t470
  t472 = t2 * t60
  t489 = s0 / t82 / t164 / t81
  t502 = 0.1e1 / t249 / t74 * t465 * t470
  t503 = t168 ** 2
  t509 = t250 * t465 * t470
  t519 = t160 * t465 * t470
  t527 = 0.1e1 / t467
  t528 = t527 * t255
  t535 = t527 * t168
  t539 = t527 * t73
  t584 = 0.41116444444444444444444444444444444444444444444444e2 * t252 * t528 * t89 - 0.41116444444444444444444444444444444444444444444445e2 * t267 * t535 * t89 + 0.68527407407407407407407407407407407407407407407408e1 * t288 * t539 * t89 - 0.8e1 * t207 * t137 * t367 + 0.36e2 * t343 * t208 * t222 + 0.22026666666666666666666666666666666666666666666667e1 * t199 * t200 * t342 * t344 + 0.73422222222222222222222222222222222222222222222224e0 * t328 * t329 * t337 + 0.36711111111111111111111111111111111111111111111112e0 * t199 * t200 * t126 * t367 + 0.28553086419753086419753086419753086419753086419753e1 * t199 * t277 * t73 * t201 - 0.34263703703703703703703703703703703703703703703704e1 * t328 * t262 * t73 * t201 - 0.12848888888888888888888888888888888888888888888889e1 * t199 * t321 * t337 + 0.68527407407407407407407407407407407407407407407408e1 * t310 * t262 * t168 * t201 - 0.14684444444444444444444444444444444444444444444445e1 * t310 * t311 * t337 + 0.29368888888888888888888888888888888888888888888890e1 * t310 * t311 * t333 + 0.25697777777777777777777777777777777777777777777778e1 * t199 * t321 * t333
  t607 = t63 / t64 / t260
  t661 = -0.26105679012345679012345679012345679012345679012346e1 * t502 * t503 * t2 * t60 - 0.41116444444444444444444444444444444444444444444444e2 * t252 * t528 + 0.39158518518518518518518518518518518518518518518518e1 * t509 * t255 * t2 * t60 - 0.11611588477366255144032921810699588477366255144033e2 * t163 * t489 * t168 + 0.41116444444444444444444444444444444444444444444445e2 * t267 * t535 - 0.15228312757201646090534979423868312757201646090535e1 * t519 * t168 * t2 * t60 - 0.30932510288065843621399176954732510288065843621399e1 * t113 * t607 * t73 + 0.58057942386831275720164609053497942386831275720164e1 * t180 * t489 * t73 - 0.68527407407407407407407407407407407407407407407408e1 * t288 * t539 + 0.10877366255144032921810699588477366255144032921811e0 * t471 * t472 * t73 + 0.23594320987654320987654320987654320987654320987654e1 * t80 * t489
  t666 = t208 ** 2
  t669 = t222 ** 2
  t677 = -0.14684444444444444444444444444444444444444444444445e1 * t328 * t329 * t333 - 0.10877366255144032921810699588477366255144032921811e0 * t471 * t472 * t121 + 0.26105679012345679012345679012345679012345679012346e1 * t502 * t503 * t89 * t472 - 0.39158518518518518518518518518518518518518518518518e1 * t509 * t255 * t89 * t472 + 0.15228312757201646090534979423868312757201646090535e1 * t519 * t188 * t472 - 0.58057942386831275720164609053497942386831275720164e1 * t180 * t489 * t121 + 0.30932510288065843621399176954732510288065843621399e1 * t113 * t607 * t121 + 0.11611588477366255144032921810699588477366255144033e2 * t163 * t489 * t188 + 0.19579259259259259259259259259259259259259259259260e1 * t288 * t254 * t73 * t126 * t137 - 0.11747555555555555555555555555555555555555555555556e2 * t267 * t254 * t168 * t126 * t137 + 0.11747555555555555555555555555555555555555555555556e2 * t252 * t254 * t255 * t126 * t137 + t127 * t661 - 0.24e2 * t77 / t341 / t88 * t666 - 0.6e1 * t207 * t669 - 0.22026666666666666666666666666666666666666666666668e1 * t199 * t200 * t206 * t137 * t222
  t698 = 0.68527407407407407407407407407407407407407407407408e1 * t163 * t263 * t272 - 0.15228312757201646090534979423868312757201646090535e1 * t519 * t169 * t472 - 0.14684444444444444444444444444444444444444444444445e1 * t163 * t167 * t168 * t224 - 0.41116444444444444444444444444444444444444444444444e2 * t252 * t528 * t91 + t77 * (t584 + t677) + 0.41116444444444444444444444444444444444444444444445e2 * t267 * t535 * t91 - 0.11747555555555555555555555555555555555555555555556e2 * t267 * t268 * t139 - 0.68527407407407407407407407407407407407407407407408e1 * t288 * t539 * t91 + 0.19579259259259259259259259259259259259259259259260e1 * t288 * t289 * t139 - 0.11611588477366255144032921810699588477366255144033e2 * t163 * t489 * t169 - 0.30932510288065843621399176954732510288065843621399e1 * t113 * t607 * t117
  t720 = t19 ** 2
  t723 = t30 ** 2
  t729 = t41 ** 2
  t738 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t739 = f.my_piecewise5(t10, 0, t14, 0, t738)
  t743 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t720 * t723 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t729 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t739)
  t758 = 0.1e1 / t103 / t36
  t775 = -0.3e1 / 0.8e1 * t5 * t248 * (0.11747555555555555555555555555555555555555555555556e2 * t252 * t256 * t139 + 0.10877366255144032921810699588477366255144032921811e0 * t471 * t472 * t117 + 0.73422222222222222222222222222222222222222222222224e0 * t180 * t167 * t296 + 0.36711111111111111111111111111111111111111111111112e0 * t113 * t116 * t73 * t369 + 0.28553086419753086419753086419753086419753086419753e1 * t113 * t278 * t184 + 0.58057942386831275720164609053497942386831275720164e1 * t180 * t489 * t117 - 0.34263703703703703703703703703703703703703703703704e1 * t180 * t263 * t184 - 0.12848888888888888888888888888888888888888888888889e1 * t113 * t175 * t296 - 0.26105679012345679012345679012345679012345679012346e1 * t502 * t503 * t91 * t472 + 0.39158518518518518518518518518518518518518518518518e1 * t509 * t255 * t91 * t472 + t698) - 0.5e1 / 0.9e1 * t5 * t236 * t141 + t5 * t240 * t226 / 0.2e1 - t5 * t244 * t371 / 0.2e1 + t5 * t150 * t141 - 0.3e1 / 0.2e1 * t5 * t154 * t226 - 0.3e1 / 0.2e1 * t5 * t158 * t371 - 0.3e1 / 0.8e1 * t5 * t743 * t54 * t93 - 0.3e1 / 0.2e1 * t5 * t55 * t141 - 0.3e1 / 0.2e1 * t5 * t105 * t141 - 0.9e1 / 0.4e1 * t5 * t109 * t226 + 0.10e2 / 0.27e2 * t5 * t233 * t758 * t93 - 0.5e1 / 0.9e1 * t5 * t147 * t235 * t93 - t5 * t53 * t104 * t93 / 0.2e1 + t5 * t102 * t149 * t93 / 0.2e1
  t776 = f.my_piecewise3(t1, 0, t775)
  t777 = t380 ** 2
  t780 = t388 ** 2
  t786 = t395 ** 2
  t792 = f.my_piecewise5(t14, 0, t10, 0, -t738)
  t796 = f.my_piecewise3(t381, 0, 0.40e2 / 0.81e2 / t383 / t777 * t780 - 0.16e2 / 0.9e1 * t385 * t388 * t395 + 0.4e1 / 0.3e1 * t392 * t786 + 0.16e2 / 0.9e1 * t393 * t399 + 0.4e1 / 0.3e1 * t382 * t792)
  t818 = f.my_piecewise3(t378, 0, -0.3e1 / 0.8e1 * t5 * t796 * t54 * t432 - t5 * t403 * t104 * t432 / 0.2e1 + t5 * t441 * t149 * t432 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t448 * t235 * t432 + 0.10e2 / 0.27e2 * t5 * t454 * t758 * t432)
  d1111 = 0.4e1 * t376 + 0.4e1 * t460 + t6 * (t776 + t818)

  res = {'v4rho4': d1111}
  return res
