"""Generated from gga_x_sfat.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = t2 ** 2
  t29 = jnp.pi * t28
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t32 * t33
  t35 = t28 * t32
  t36 = t35 * t33
  t37 = r0 ** 2
  t38 = r0 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t41 = 0.1e1 / t39 / t37
  t42 = s0 * t41
  t43 = jnp.sqrt(s0)
  t45 = 0.1e1 / t38 / r0
  t46 = t43 * t45
  t47 = jnp.arcsinh(t46)
  t50 = 0.1e1 + 0.2520e-1 * t46 * t47
  t51 = 0.1e1 / t50
  t55 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t42 * t51
  t58 = t29 * t34 / t55
  t59 = jnp.sqrt(t58)
  t61 = f.p.cam_omega / t59
  t62 = 2 ** (0.1e1 / 0.3e1)
  t63 = t19 * t6
  t64 = t63 ** (0.1e1 / 0.3e1)
  t66 = t62 / t64
  t68 = t61 * t66 / 0.2e1
  t69 = 0.192e1 <= t68
  t70 = 0.192e1 < t68
  t71 = f.my_piecewise3(t70, t68, 0.192e1)
  t72 = t71 ** 2
  t73 = t72 ** 2
  t76 = t73 * t72
  t79 = t73 ** 2
  t82 = t79 * t72
  t85 = t79 * t73
  t88 = t79 * t76
  t91 = t79 ** 2
  t115 = t91 ** 2
  t126 = -0.1e1 / t73 / 0.30e2 + 0.1e1 / t76 / 0.70e2 - 0.1e1 / t79 / 0.135e3 + 0.1e1 / t82 / 0.231e3 - 0.1e1 / t85 / 0.364e3 + 0.1e1 / t88 / 0.540e3 - 0.1e1 / t91 / 0.765e3 + 0.1e1 / t91 / t72 / 0.1045e4 - 0.1e1 / t91 / t73 / 0.1386e4 + 0.1e1 / t91 / t76 / 0.1794e4 - 0.1e1 / t91 / t79 / 0.2275e4 + 0.1e1 / t91 / t82 / 0.2835e4 - 0.1e1 / t91 / t85 / 0.3480e4 + 0.1e1 / t91 / t88 / 0.4216e4 - 0.1e1 / t115 / 0.5049e4 + 0.1e1 / t115 / t72 / 0.5985e4 - 0.1e1 / t115 / t73 / 0.7030e4 + 0.1e1 / t72 / 0.9e1
  t127 = f.my_piecewise3(t70, 0.192e1, t68)
  t128 = jnp.arctan2(0.1e1, t127)
  t129 = t127 ** 2
  t130 = t129 + 0.3e1
  t131 = 0.1e1 / t129
  t132 = 0.1e1 + t131
  t133 = jnp.log(t132)
  t135 = -t130 * t133 + 0.1e1
  t138 = t128 + t127 * t135 / 0.4e1
  t142 = f.my_piecewise3(t69, t126, 0.1e1 - 0.8e1 / 0.3e1 * t127 * t138)
  t143 = t27 * t142
  t144 = t143 * t55
  t147 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t144)
  t148 = r1 <= f.p.dens_threshold
  t149 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t150 = 0.1e1 + t149
  t151 = t150 <= f.p.zeta_threshold
  t152 = t150 ** (0.1e1 / 0.3e1)
  t154 = f.my_piecewise3(t151, t22, t152 * t150)
  t155 = t5 * t154
  t156 = r1 ** 2
  t157 = r1 ** (0.1e1 / 0.3e1)
  t158 = t157 ** 2
  t160 = 0.1e1 / t158 / t156
  t161 = s2 * t160
  t162 = jnp.sqrt(s2)
  t164 = 0.1e1 / t157 / r1
  t165 = t162 * t164
  t166 = jnp.arcsinh(t165)
  t169 = 0.1e1 + 0.2520e-1 * t165 * t166
  t170 = 0.1e1 / t169
  t174 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t161 * t170
  t177 = t29 * t34 / t174
  t178 = jnp.sqrt(t177)
  t180 = f.p.cam_omega / t178
  t181 = t150 * t6
  t182 = t181 ** (0.1e1 / 0.3e1)
  t184 = t62 / t182
  t186 = t180 * t184 / 0.2e1
  t187 = 0.192e1 <= t186
  t188 = 0.192e1 < t186
  t189 = f.my_piecewise3(t188, t186, 0.192e1)
  t190 = t189 ** 2
  t191 = t190 ** 2
  t194 = t191 * t190
  t197 = t191 ** 2
  t200 = t197 * t190
  t203 = t197 * t191
  t206 = t197 * t194
  t209 = t197 ** 2
  t233 = t209 ** 2
  t244 = -0.1e1 / t191 / 0.30e2 + 0.1e1 / t194 / 0.70e2 - 0.1e1 / t197 / 0.135e3 + 0.1e1 / t200 / 0.231e3 - 0.1e1 / t203 / 0.364e3 + 0.1e1 / t206 / 0.540e3 - 0.1e1 / t209 / 0.765e3 + 0.1e1 / t209 / t190 / 0.1045e4 - 0.1e1 / t209 / t191 / 0.1386e4 + 0.1e1 / t209 / t194 / 0.1794e4 - 0.1e1 / t209 / t197 / 0.2275e4 + 0.1e1 / t209 / t200 / 0.2835e4 - 0.1e1 / t209 / t203 / 0.3480e4 + 0.1e1 / t209 / t206 / 0.4216e4 - 0.1e1 / t233 / 0.5049e4 + 0.1e1 / t233 / t190 / 0.5985e4 - 0.1e1 / t233 / t191 / 0.7030e4 + 0.1e1 / t190 / 0.9e1
  t245 = f.my_piecewise3(t188, 0.192e1, t186)
  t246 = jnp.arctan2(0.1e1, t245)
  t247 = t245 ** 2
  t248 = t247 + 0.3e1
  t249 = 0.1e1 / t247
  t250 = 0.1e1 + t249
  t251 = jnp.log(t250)
  t253 = -t248 * t251 + 0.1e1
  t256 = t246 + t245 * t253 / 0.4e1
  t260 = f.my_piecewise3(t187, t244, 0.1e1 - 0.8e1 / 0.3e1 * t245 * t256)
  t261 = t27 * t260
  t262 = t261 * t174
  t265 = f.my_piecewise3(t148, 0, -0.3e1 / 0.8e1 * t155 * t262)
  t266 = t6 ** 2
  t268 = t16 / t266
  t269 = t7 - t268
  t270 = f.my_piecewise5(t10, 0, t14, 0, t269)
  t273 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t270)
  t277 = t27 ** 2
  t278 = 0.1e1 / t277
  t282 = t26 * t278 * t142 * t55 / 0.8e1
  t283 = t73 * t71
  t284 = 0.1e1 / t283
  t289 = f.p.cam_omega / t59 / t58 * t66 * jnp.pi
  t290 = t55 ** 2
  t292 = t33 / t290
  t296 = s0 / t39 / t37 / r0
  t300 = t50 ** 2
  t301 = 0.1e1 / t300
  t308 = jnp.sqrt(0.1e1 + t42)
  t309 = 0.1e1 / t308
  t317 = -0.24888888888888888888888888888888888888888888888889e-2 * t36 * t296 * t51 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t42 * t301 * (-0.33600000000000000000000000000000000000000000000000e-1 * t43 / t38 / t37 * t47 - 0.33600000000000000000000000000000000000000000000000e-1 * t296 * t309)
  t324 = t62 / t64 / t63
  t330 = t289 * t35 * t292 * t317 / 0.4e1 - t61 * t324 * (t270 * t6 + t18 + 0.1e1) / 0.6e1
  t331 = f.my_piecewise3(t70, t330, 0)
  t334 = t72 * t71
  t335 = t73 * t334
  t336 = 0.1e1 / t335
  t339 = t79 * t71
  t340 = 0.1e1 / t339
  t343 = t79 * t334
  t344 = 0.1e1 / t343
  t347 = t79 * t283
  t348 = 0.1e1 / t347
  t351 = t79 * t335
  t352 = 0.1e1 / t351
  t356 = 0.1e1 / t91 / t71
  t360 = 0.1e1 / t91 / t334
  t364 = 0.1e1 / t91 / t283
  t368 = 0.1e1 / t91 / t335
  t372 = 0.1e1 / t91 / t339
  t376 = 0.1e1 / t91 / t343
  t380 = 0.1e1 / t91 / t347
  t384 = 0.1e1 / t91 / t351
  t388 = 0.1e1 / t115 / t71
  t392 = 0.1e1 / t115 / t334
  t396 = 0.1e1 / t115 / t283
  t399 = 0.1e1 / t334
  t402 = 0.2e1 / 0.15e2 * t284 * t331 - 0.3e1 / 0.35e2 * t336 * t331 + 0.8e1 / 0.135e3 * t340 * t331 - 0.10e2 / 0.231e3 * t344 * t331 + 0.3e1 / 0.91e2 * t348 * t331 - 0.7e1 / 0.270e3 * t352 * t331 + 0.16e2 / 0.765e3 * t356 * t331 - 0.18e2 / 0.1045e4 * t360 * t331 + 0.10e2 / 0.693e3 * t364 * t331 - 0.11e2 / 0.897e3 * t368 * t331 + 0.24e2 / 0.2275e4 * t372 * t331 - 0.26e2 / 0.2835e4 * t376 * t331 + 0.7e1 / 0.870e3 * t380 * t331 - 0.15e2 / 0.2108e4 * t384 * t331 + 0.32e2 / 0.5049e4 * t388 * t331 - 0.34e2 / 0.5985e4 * t392 * t331 + 0.18e2 / 0.3515e4 * t396 * t331 - 0.2e1 / 0.9e1 * t399 * t331
  t403 = f.my_piecewise3(t70, 0, t330)
  t406 = 0.1e1 / t132
  t414 = t130 / t129 / t127
  t425 = f.my_piecewise3(t69, t402, -0.8e1 / 0.3e1 * t403 * t138 - 0.8e1 / 0.3e1 * t127 * (-t131 * t403 * t406 + t403 * t135 / 0.4e1 + t127 * (-0.2e1 * t127 * t403 * t133 + 0.2e1 * t414 * t403 * t406) / 0.4e1))
  t434 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t273 * t144 - t282 - 0.3e1 / 0.8e1 * t26 * t27 * t425 * t55 - 0.3e1 / 0.8e1 * t26 * t143 * t317)
  t436 = f.my_piecewise5(t14, 0, t10, 0, -t269)
  t439 = f.my_piecewise3(t151, 0, 0.4e1 / 0.3e1 * t152 * t436)
  t446 = t155 * t278 * t260 * t174 / 0.8e1
  t447 = t191 * t189
  t448 = 0.1e1 / t447
  t451 = t62 / t182 / t181
  t456 = t180 * t451 * (t436 * t6 + t149 + 0.1e1) / 0.6e1
  t457 = f.my_piecewise3(t188, -t456, 0)
  t460 = t190 * t189
  t461 = t191 * t460
  t462 = 0.1e1 / t461
  t465 = t197 * t189
  t466 = 0.1e1 / t465
  t469 = t197 * t460
  t470 = 0.1e1 / t469
  t473 = t197 * t447
  t474 = 0.1e1 / t473
  t477 = t197 * t461
  t478 = 0.1e1 / t477
  t482 = 0.1e1 / t209 / t189
  t486 = 0.1e1 / t209 / t460
  t490 = 0.1e1 / t209 / t447
  t494 = 0.1e1 / t209 / t461
  t498 = 0.1e1 / t209 / t465
  t502 = 0.1e1 / t209 / t469
  t506 = 0.1e1 / t209 / t473
  t510 = 0.1e1 / t209 / t477
  t514 = 0.1e1 / t233 / t189
  t518 = 0.1e1 / t233 / t460
  t522 = 0.1e1 / t233 / t447
  t525 = 0.1e1 / t460
  t528 = 0.2e1 / 0.15e2 * t448 * t457 - 0.3e1 / 0.35e2 * t462 * t457 + 0.8e1 / 0.135e3 * t466 * t457 - 0.10e2 / 0.231e3 * t470 * t457 + 0.3e1 / 0.91e2 * t474 * t457 - 0.7e1 / 0.270e3 * t478 * t457 + 0.16e2 / 0.765e3 * t482 * t457 - 0.18e2 / 0.1045e4 * t486 * t457 + 0.10e2 / 0.693e3 * t490 * t457 - 0.11e2 / 0.897e3 * t494 * t457 + 0.24e2 / 0.2275e4 * t498 * t457 - 0.26e2 / 0.2835e4 * t502 * t457 + 0.7e1 / 0.870e3 * t506 * t457 - 0.15e2 / 0.2108e4 * t510 * t457 + 0.32e2 / 0.5049e4 * t514 * t457 - 0.34e2 / 0.5985e4 * t518 * t457 + 0.18e2 / 0.3515e4 * t522 * t457 - 0.2e1 / 0.9e1 * t525 * t457
  t529 = f.my_piecewise3(t188, 0, -t456)
  t532 = 0.1e1 / t250
  t540 = t248 / t247 / t245
  t551 = f.my_piecewise3(t187, t528, -0.8e1 / 0.3e1 * t529 * t256 - 0.8e1 / 0.3e1 * t245 * (-t249 * t529 * t532 + t529 * t253 / 0.4e1 + t245 * (-0.2e1 * t245 * t529 * t251 + 0.2e1 * t540 * t529 * t532) / 0.4e1))
  t557 = f.my_piecewise3(t148, 0, -0.3e1 / 0.8e1 * t5 * t439 * t262 - t446 - 0.3e1 / 0.8e1 * t155 * t27 * t551 * t174)
  vrho_0_ = t147 + t265 + t6 * (t434 + t557)
  t560 = -t7 - t268
  t561 = f.my_piecewise5(t10, 0, t14, 0, t560)
  t564 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t561)
  t572 = t61 * t324 * (t561 * t6 + t18 + 0.1e1) / 0.6e1
  t573 = f.my_piecewise3(t70, -t572, 0)
  t610 = 0.2e1 / 0.15e2 * t284 * t573 - 0.3e1 / 0.35e2 * t336 * t573 + 0.8e1 / 0.135e3 * t340 * t573 - 0.10e2 / 0.231e3 * t344 * t573 + 0.3e1 / 0.91e2 * t348 * t573 - 0.7e1 / 0.270e3 * t352 * t573 + 0.16e2 / 0.765e3 * t356 * t573 - 0.18e2 / 0.1045e4 * t360 * t573 + 0.10e2 / 0.693e3 * t364 * t573 - 0.11e2 / 0.897e3 * t368 * t573 + 0.24e2 / 0.2275e4 * t372 * t573 - 0.26e2 / 0.2835e4 * t376 * t573 + 0.7e1 / 0.870e3 * t380 * t573 - 0.15e2 / 0.2108e4 * t384 * t573 + 0.32e2 / 0.5049e4 * t388 * t573 - 0.34e2 / 0.5985e4 * t392 * t573 + 0.18e2 / 0.3515e4 * t396 * t573 - 0.2e1 / 0.9e1 * t399 * t573
  t611 = f.my_piecewise3(t70, 0, -t572)
  t629 = f.my_piecewise3(t69, t610, -0.8e1 / 0.3e1 * t611 * t138 - 0.8e1 / 0.3e1 * t127 * (-t131 * t611 * t406 + t611 * t135 / 0.4e1 + t127 * (-0.2e1 * t127 * t611 * t133 + 0.2e1 * t414 * t611 * t406) / 0.4e1))
  t635 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t564 * t144 - t282 - 0.3e1 / 0.8e1 * t26 * t27 * t629 * t55)
  t637 = f.my_piecewise5(t14, 0, t10, 0, -t560)
  t640 = f.my_piecewise3(t151, 0, 0.4e1 / 0.3e1 * t152 * t637)
  t648 = f.p.cam_omega / t178 / t177 * t184 * jnp.pi
  t649 = t174 ** 2
  t651 = t33 / t649
  t655 = s2 / t158 / t156 / r1
  t659 = t169 ** 2
  t660 = 0.1e1 / t659
  t667 = jnp.sqrt(0.1e1 + t161)
  t668 = 0.1e1 / t667
  t676 = -0.24888888888888888888888888888888888888888888888889e-2 * t36 * t655 * t170 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t161 * t660 * (-0.33600000000000000000000000000000000000000000000000e-1 * t162 / t157 / t156 * t166 - 0.33600000000000000000000000000000000000000000000000e-1 * t655 * t668)
  t686 = t648 * t35 * t651 * t676 / 0.4e1 - t180 * t451 * (t637 * t6 + t149 + 0.1e1) / 0.6e1
  t687 = f.my_piecewise3(t188, t686, 0)
  t724 = 0.2e1 / 0.15e2 * t448 * t687 - 0.3e1 / 0.35e2 * t462 * t687 + 0.8e1 / 0.135e3 * t466 * t687 - 0.10e2 / 0.231e3 * t470 * t687 + 0.3e1 / 0.91e2 * t474 * t687 - 0.7e1 / 0.270e3 * t478 * t687 + 0.16e2 / 0.765e3 * t482 * t687 - 0.18e2 / 0.1045e4 * t486 * t687 + 0.10e2 / 0.693e3 * t490 * t687 - 0.11e2 / 0.897e3 * t494 * t687 + 0.24e2 / 0.2275e4 * t498 * t687 - 0.26e2 / 0.2835e4 * t502 * t687 + 0.7e1 / 0.870e3 * t506 * t687 - 0.15e2 / 0.2108e4 * t510 * t687 + 0.32e2 / 0.5049e4 * t514 * t687 - 0.34e2 / 0.5985e4 * t518 * t687 + 0.18e2 / 0.3515e4 * t522 * t687 - 0.2e1 / 0.9e1 * t525 * t687
  t725 = f.my_piecewise3(t188, 0, t686)
  t743 = f.my_piecewise3(t187, t724, -0.8e1 / 0.3e1 * t725 * t256 - 0.8e1 / 0.3e1 * t245 * (-t249 * t725 * t532 + t725 * t253 / 0.4e1 + t245 * (-0.2e1 * t245 * t725 * t251 + 0.2e1 * t540 * t725 * t532) / 0.4e1))
  t752 = f.my_piecewise3(t148, 0, -0.3e1 / 0.8e1 * t5 * t640 * t262 - t446 - 0.3e1 / 0.8e1 * t155 * t27 * t743 * t174 - 0.3e1 / 0.8e1 * t155 * t261 * t676)
  vrho_1_ = t147 + t265 + t6 * (t635 + t752)
  t770 = 0.93333333333333333333333333333333333333333333333333e-3 * t35 * t33 * t41 * t51 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t42 * t301 * (0.12600000000000000000000000000000000000000000000000e-1 / t43 * t45 * t47 + 0.12600000000000000000000000000000000000000000000000e-1 * t41 * t309)
  t774 = t289 * t35 * t292 * t770 / 0.4e1
  t775 = f.my_piecewise3(t70, t774, 0)
  t812 = 0.2e1 / 0.15e2 * t284 * t775 - 0.3e1 / 0.35e2 * t336 * t775 + 0.8e1 / 0.135e3 * t340 * t775 - 0.10e2 / 0.231e3 * t344 * t775 + 0.3e1 / 0.91e2 * t348 * t775 - 0.7e1 / 0.270e3 * t352 * t775 + 0.16e2 / 0.765e3 * t356 * t775 - 0.18e2 / 0.1045e4 * t360 * t775 + 0.10e2 / 0.693e3 * t364 * t775 - 0.11e2 / 0.897e3 * t368 * t775 + 0.24e2 / 0.2275e4 * t372 * t775 - 0.26e2 / 0.2835e4 * t376 * t775 + 0.7e1 / 0.870e3 * t380 * t775 - 0.15e2 / 0.2108e4 * t384 * t775 + 0.32e2 / 0.5049e4 * t388 * t775 - 0.34e2 / 0.5985e4 * t392 * t775 + 0.18e2 / 0.3515e4 * t396 * t775 - 0.2e1 / 0.9e1 * t399 * t775
  t813 = f.my_piecewise3(t70, 0, t774)
  t831 = f.my_piecewise3(t69, t812, -0.8e1 / 0.3e1 * t813 * t138 - 0.8e1 / 0.3e1 * t127 * (-t131 * t813 * t406 + t813 * t135 / 0.4e1 + t127 * (-0.2e1 * t127 * t813 * t133 + 0.2e1 * t414 * t813 * t406) / 0.4e1))
  t839 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t27 * t831 * t55 - 0.3e1 / 0.8e1 * t26 * t143 * t770)
  vsigma_0_ = t6 * t839
  vsigma_1_ = 0.0e0
  t855 = 0.93333333333333333333333333333333333333333333333333e-3 * t35 * t33 * t160 * t170 - 0.93333333333333333333333333333333333333333333333333e-3 * t36 * t161 * t660 * (0.12600000000000000000000000000000000000000000000000e-1 / t162 * t164 * t166 + 0.12600000000000000000000000000000000000000000000000e-1 * t160 * t668)
  t859 = t648 * t35 * t651 * t855 / 0.4e1
  t860 = f.my_piecewise3(t188, t859, 0)
  t897 = 0.2e1 / 0.15e2 * t448 * t860 - 0.3e1 / 0.35e2 * t462 * t860 + 0.8e1 / 0.135e3 * t466 * t860 - 0.10e2 / 0.231e3 * t470 * t860 + 0.3e1 / 0.91e2 * t474 * t860 - 0.7e1 / 0.270e3 * t478 * t860 + 0.16e2 / 0.765e3 * t482 * t860 - 0.18e2 / 0.1045e4 * t486 * t860 + 0.10e2 / 0.693e3 * t490 * t860 - 0.11e2 / 0.897e3 * t494 * t860 + 0.24e2 / 0.2275e4 * t498 * t860 - 0.26e2 / 0.2835e4 * t502 * t860 + 0.7e1 / 0.870e3 * t506 * t860 - 0.15e2 / 0.2108e4 * t510 * t860 + 0.32e2 / 0.5049e4 * t514 * t860 - 0.34e2 / 0.5985e4 * t518 * t860 + 0.18e2 / 0.3515e4 * t522 * t860 - 0.2e1 / 0.9e1 * t525 * t860
  t898 = f.my_piecewise3(t188, 0, t859)
  t916 = f.my_piecewise3(t187, t897, -0.8e1 / 0.3e1 * t898 * t256 - 0.8e1 / 0.3e1 * t245 * (-t249 * t898 * t532 + t898 * t253 / 0.4e1 + t245 * (-0.2e1 * t245 * t898 * t251 + 0.2e1 * t540 * t898 * t532) / 0.4e1))
  t924 = f.my_piecewise3(t148, 0, -0.3e1 / 0.8e1 * t155 * t27 * t916 * t174 - 0.3e1 / 0.8e1 * t155 * t261 * t855)
  vsigma_2_ = t6 * t924
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  ityh_enhancement = lambda xs: b88_f(xs)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t3 ** 2
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t23
  t25 = 4 ** (0.1e1 / 0.3e1)
  t27 = t20 * t24
  t28 = t27 * t25
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t33 = t19 ** 2
  t35 = 0.1e1 / t33 / t32
  t36 = jnp.sqrt(s0)
  t37 = t36 * t29
  t39 = 0.1e1 / t19 / r0
  t41 = jnp.arcsinh(t37 * t39)
  t42 = t39 * t41
  t45 = 0.1e1 + 0.2520e-1 * t37 * t42
  t46 = 0.1e1 / t45
  t51 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t28 * t31 * t35 * t46
  t54 = jnp.pi * t20 * t24 * t25 / t51
  t55 = jnp.sqrt(t54)
  t57 = f.p.cam_omega / t55
  t58 = t11 * r0
  t59 = t58 ** (0.1e1 / 0.3e1)
  t61 = t29 / t59
  t63 = t57 * t61 / 0.2e1
  t64 = 0.192e1 <= t63
  t65 = 0.192e1 < t63
  t66 = f.my_piecewise3(t65, t63, 0.192e1)
  t67 = t66 ** 2
  t68 = t67 ** 2
  t71 = t68 * t67
  t74 = t68 ** 2
  t77 = t74 * t67
  t80 = t74 * t68
  t83 = t74 * t71
  t86 = t74 ** 2
  t110 = t86 ** 2
  t121 = -0.1e1 / t68 / 0.30e2 + 0.1e1 / t71 / 0.70e2 - 0.1e1 / t74 / 0.135e3 + 0.1e1 / t77 / 0.231e3 - 0.1e1 / t80 / 0.364e3 + 0.1e1 / t83 / 0.540e3 - 0.1e1 / t86 / 0.765e3 + 0.1e1 / t86 / t67 / 0.1045e4 - 0.1e1 / t86 / t68 / 0.1386e4 + 0.1e1 / t86 / t71 / 0.1794e4 - 0.1e1 / t86 / t74 / 0.2275e4 + 0.1e1 / t86 / t77 / 0.2835e4 - 0.1e1 / t86 / t80 / 0.3480e4 + 0.1e1 / t86 / t83 / 0.4216e4 - 0.1e1 / t110 / 0.5049e4 + 0.1e1 / t110 / t67 / 0.5985e4 - 0.1e1 / t110 / t68 / 0.7030e4 + 0.1e1 / t67 / 0.9e1
  t122 = f.my_piecewise3(t65, 0.192e1, t63)
  t123 = jnp.arctan2(0.1e1, t122)
  t124 = t122 ** 2
  t125 = t124 + 0.3e1
  t126 = 0.1e1 / t124
  t127 = 0.1e1 + t126
  t128 = jnp.log(t127)
  t130 = -t125 * t128 + 0.1e1
  t133 = t123 + t122 * t130 / 0.4e1
  t137 = f.my_piecewise3(t64, t121, 0.1e1 - 0.8e1 / 0.3e1 * t122 * t133)
  t138 = t19 * t137
  t142 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t138 * t51)
  t148 = t68 * t66
  t149 = 0.1e1 / t148
  t154 = f.p.cam_omega / t55 / t54 * t61 * jnp.pi
  t155 = t51 ** 2
  t157 = t25 / t155
  t160 = 0.1e1 / t33 / t32 / r0
  t166 = t27 * t25 * s0
  t167 = t30 * t35
  t168 = t45 ** 2
  t169 = 0.1e1 / t168
  t177 = jnp.sqrt(t31 * t35 + 0.1e1)
  t178 = 0.1e1 / t177
  t187 = -0.24888888888888888888888888888888888888888888888889e-2 * t28 * t31 * t160 * t46 - 0.93333333333333333333333333333333333333333333333333e-3 * t166 * t167 * t169 * (-0.33600000000000000000000000000000000000000000000000e-1 * t37 / t19 / t32 * t41 - 0.33600000000000000000000000000000000000000000000000e-1 * t31 * t160 * t178)
  t198 = t154 * t27 * t157 * t187 / 0.4e1 - t57 * t29 / t59 / t58 * t11 / 0.6e1
  t199 = f.my_piecewise3(t65, t198, 0)
  t202 = t67 * t66
  t203 = t68 * t202
  t204 = 0.1e1 / t203
  t207 = t74 * t66
  t208 = 0.1e1 / t207
  t211 = t74 * t202
  t212 = 0.1e1 / t211
  t215 = t74 * t148
  t216 = 0.1e1 / t215
  t219 = t74 * t203
  t220 = 0.1e1 / t219
  t224 = 0.1e1 / t86 / t66
  t228 = 0.1e1 / t86 / t202
  t232 = 0.1e1 / t86 / t148
  t236 = 0.1e1 / t86 / t203
  t240 = 0.1e1 / t86 / t207
  t244 = 0.1e1 / t86 / t211
  t248 = 0.1e1 / t86 / t215
  t252 = 0.1e1 / t86 / t219
  t256 = 0.1e1 / t110 / t66
  t260 = 0.1e1 / t110 / t202
  t264 = 0.1e1 / t110 / t148
  t267 = 0.1e1 / t202
  t270 = 0.2e1 / 0.15e2 * t149 * t199 - 0.3e1 / 0.35e2 * t204 * t199 + 0.8e1 / 0.135e3 * t208 * t199 - 0.10e2 / 0.231e3 * t212 * t199 + 0.3e1 / 0.91e2 * t216 * t199 - 0.7e1 / 0.270e3 * t220 * t199 + 0.16e2 / 0.765e3 * t224 * t199 - 0.18e2 / 0.1045e4 * t228 * t199 + 0.10e2 / 0.693e3 * t232 * t199 - 0.11e2 / 0.897e3 * t236 * t199 + 0.24e2 / 0.2275e4 * t240 * t199 - 0.26e2 / 0.2835e4 * t244 * t199 + 0.7e1 / 0.870e3 * t248 * t199 - 0.15e2 / 0.2108e4 * t252 * t199 + 0.32e2 / 0.5049e4 * t256 * t199 - 0.34e2 / 0.5985e4 * t260 * t199 + 0.18e2 / 0.3515e4 * t264 * t199 - 0.2e1 / 0.9e1 * t267 * t199
  t271 = f.my_piecewise3(t65, 0, t198)
  t274 = 0.1e1 / t127
  t282 = t125 / t124 / t122
  t293 = f.my_piecewise3(t64, t270, -0.8e1 / 0.3e1 * t271 * t133 - 0.8e1 / 0.3e1 * t122 * (-t126 * t271 * t274 + t271 * t130 / 0.4e1 + t122 * (-0.2e1 * t122 * t271 * t128 + 0.2e1 * t282 * t271 * t274) / 0.4e1))
  t302 = f.my_piecewise3(t2, 0, -t18 / t33 * t137 * t51 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t293 * t51 - 0.3e1 / 0.8e1 * t18 * t138 * t187)
  vrho_0_ = 0.2e1 * r0 * t302 + 0.2e1 * t142
  t319 = 0.93333333333333333333333333333333333333333333333333e-3 * t28 * t167 * t46 - 0.93333333333333333333333333333333333333333333333333e-3 * t166 * t167 * t169 * (0.12600000000000000000000000000000000000000000000000e-1 / t36 * t29 * t42 + 0.12600000000000000000000000000000000000000000000000e-1 * t167 * t178)
  t323 = t154 * t27 * t157 * t319 / 0.4e1
  t324 = f.my_piecewise3(t65, t323, 0)
  t361 = 0.2e1 / 0.15e2 * t149 * t324 - 0.3e1 / 0.35e2 * t204 * t324 + 0.8e1 / 0.135e3 * t208 * t324 - 0.10e2 / 0.231e3 * t212 * t324 + 0.3e1 / 0.91e2 * t216 * t324 - 0.7e1 / 0.270e3 * t220 * t324 + 0.16e2 / 0.765e3 * t224 * t324 - 0.18e2 / 0.1045e4 * t228 * t324 + 0.10e2 / 0.693e3 * t232 * t324 - 0.11e2 / 0.897e3 * t236 * t324 + 0.24e2 / 0.2275e4 * t240 * t324 - 0.26e2 / 0.2835e4 * t244 * t324 + 0.7e1 / 0.870e3 * t248 * t324 - 0.15e2 / 0.2108e4 * t252 * t324 + 0.32e2 / 0.5049e4 * t256 * t324 - 0.34e2 / 0.5985e4 * t260 * t324 + 0.18e2 / 0.3515e4 * t264 * t324 - 0.2e1 / 0.9e1 * t267 * t324
  t362 = f.my_piecewise3(t65, 0, t323)
  t380 = f.my_piecewise3(t64, t361, -0.8e1 / 0.3e1 * t362 * t133 - 0.8e1 / 0.3e1 * t122 * (-t126 * t362 * t274 + t362 * t130 / 0.4e1 + t122 * (-0.2e1 * t122 * t362 * t128 + 0.2e1 * t282 * t362 * t274) / 0.4e1))
  t388 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t380 * t51 - 0.3e1 / 0.8e1 * t18 * t138 * t319)
  vsigma_0_ = 0.2e1 * r0 * t388
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = t3 ** 2
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = 4 ** (0.1e1 / 0.3e1)
  t29 = t22 * t26
  t30 = t29 * t27
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = s0 * t32
  t34 = r0 ** 2
  t36 = 0.1e1 / t20 / t34
  t37 = jnp.sqrt(s0)
  t38 = t37 * t31
  t40 = 0.1e1 / t19 / r0
  t42 = jnp.asinh(t38 * t40)
  t43 = t40 * t42
  t46 = 0.1e1 + 0.2520e-1 * t38 * t43
  t47 = 0.1e1 / t46
  t52 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t30 * t33 * t36 * t47
  t55 = jnp.pi * t22 * t26 * t27 / t52
  t56 = jnp.sqrt(t55)
  t58 = f.p.cam_omega / t56
  t59 = t11 * r0
  t60 = t59 ** (0.1e1 / 0.3e1)
  t62 = t31 / t60
  t64 = t58 * t62 / 0.2e1
  t65 = 0.192e1 <= t64
  t66 = 0.192e1 < t64
  t67 = f.my_piecewise3(t66, t64, 0.192e1)
  t68 = t67 ** 2
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t72 = t69 * t68
  t73 = 0.1e1 / t72
  t75 = t69 ** 2
  t76 = 0.1e1 / t75
  t78 = t75 * t68
  t79 = 0.1e1 / t78
  t81 = t75 * t69
  t82 = 0.1e1 / t81
  t84 = t75 * t72
  t85 = 0.1e1 / t84
  t87 = t75 ** 2
  t88 = 0.1e1 / t87
  t91 = 0.1e1 / t87 / t68
  t94 = 0.1e1 / t87 / t69
  t97 = 0.1e1 / t87 / t72
  t100 = 0.1e1 / t87 / t75
  t103 = 0.1e1 / t87 / t78
  t106 = 0.1e1 / t87 / t81
  t109 = 0.1e1 / t87 / t84
  t111 = t87 ** 2
  t112 = 0.1e1 / t111
  t115 = 0.1e1 / t111 / t68
  t118 = 0.1e1 / t111 / t69
  t122 = -t70 / 0.30e2 + t73 / 0.70e2 - t76 / 0.135e3 + t79 / 0.231e3 - t82 / 0.364e3 + t85 / 0.540e3 - t88 / 0.765e3 + t91 / 0.1045e4 - t94 / 0.1386e4 + t97 / 0.1794e4 - t100 / 0.2275e4 + t103 / 0.2835e4 - t106 / 0.3480e4 + t109 / 0.4216e4 - t112 / 0.5049e4 + t115 / 0.5985e4 - t118 / 0.7030e4 + 0.1e1 / t68 / 0.9e1
  t123 = f.my_piecewise3(t66, 0.192e1, t64)
  t124 = jnp.atan2(0.1e1, t123)
  t125 = t123 ** 2
  t126 = t125 + 0.3e1
  t127 = 0.1e1 / t125
  t128 = 0.1e1 + t127
  t129 = jnp.log(t128)
  t131 = -t126 * t129 + 0.1e1
  t134 = t124 + t123 * t131 / 0.4e1
  t138 = f.my_piecewise3(t65, t122, 0.1e1 - 0.8e1 / 0.3e1 * t123 * t134)
  t139 = t21 * t138
  t143 = t69 * t67
  t144 = 0.1e1 / t143
  t147 = f.p.cam_omega / t56 / t55
  t149 = t147 * t62 * jnp.pi
  t150 = t52 ** 2
  t151 = 0.1e1 / t150
  t152 = t27 * t151
  t153 = t34 * r0
  t155 = 0.1e1 / t20 / t153
  t161 = t29 * t27 * s0
  t162 = t32 * t36
  t163 = t46 ** 2
  t164 = 0.1e1 / t163
  t167 = 0.1e1 / t19 / t34 * t42
  t171 = t33 * t36 + 0.1e1
  t172 = jnp.sqrt(t171)
  t173 = 0.1e1 / t172
  t177 = -0.33600000000000000000000000000000000000000000000000e-1 * t38 * t167 - 0.33600000000000000000000000000000000000000000000000e-1 * t33 * t155 * t173
  t178 = t164 * t177
  t179 = t162 * t178
  t182 = -0.24888888888888888888888888888888888888888888888889e-2 * t30 * t33 * t155 * t47 - 0.93333333333333333333333333333333333333333333333332e-3 * t161 * t179
  t189 = t31 / t60 / t59
  t193 = t149 * t29 * t152 * t182 / 0.4e1 - t58 * t189 * t11 / 0.6e1
  t194 = f.my_piecewise3(t66, t193, 0)
  t197 = t68 * t67
  t198 = t69 * t197
  t199 = 0.1e1 / t198
  t202 = t75 * t67
  t203 = 0.1e1 / t202
  t206 = t75 * t197
  t207 = 0.1e1 / t206
  t210 = t75 * t143
  t211 = 0.1e1 / t210
  t214 = t75 * t198
  t215 = 0.1e1 / t214
  t219 = 0.1e1 / t87 / t67
  t223 = 0.1e1 / t87 / t197
  t227 = 0.1e1 / t87 / t143
  t231 = 0.1e1 / t87 / t198
  t235 = 0.1e1 / t87 / t202
  t239 = 0.1e1 / t87 / t206
  t243 = 0.1e1 / t87 / t210
  t247 = 0.1e1 / t87 / t214
  t251 = 0.1e1 / t111 / t67
  t255 = 0.1e1 / t111 / t197
  t259 = 0.1e1 / t111 / t143
  t262 = 0.1e1 / t197
  t265 = 0.2e1 / 0.15e2 * t144 * t194 - 0.3e1 / 0.35e2 * t199 * t194 + 0.8e1 / 0.135e3 * t203 * t194 - 0.10e2 / 0.231e3 * t207 * t194 + 0.3e1 / 0.91e2 * t211 * t194 - 0.7e1 / 0.270e3 * t215 * t194 + 0.16e2 / 0.765e3 * t219 * t194 - 0.18e2 / 0.1045e4 * t223 * t194 + 0.10e2 / 0.693e3 * t227 * t194 - 0.11e2 / 0.897e3 * t231 * t194 + 0.24e2 / 0.2275e4 * t235 * t194 - 0.26e2 / 0.2835e4 * t239 * t194 + 0.7e1 / 0.870e3 * t243 * t194 - 0.15e2 / 0.2108e4 * t247 * t194 + 0.32e2 / 0.5049e4 * t251 * t194 - 0.34e2 / 0.5985e4 * t255 * t194 + 0.18e2 / 0.3515e4 * t259 * t194 - 0.2e1 / 0.9e1 * t262 * t194
  t266 = f.my_piecewise3(t66, 0, t193)
  t269 = 0.1e1 / t128
  t276 = 0.1e1 / t125 / t123
  t277 = t126 * t276
  t278 = t266 * t269
  t281 = -0.2e1 * t123 * t266 * t129 + 0.2e1 * t277 * t278
  t284 = -t127 * t266 * t269 + t266 * t131 / 0.4e1 + t123 * t281 / 0.4e1
  t288 = f.my_piecewise3(t65, t265, -0.8e1 / 0.3e1 * t123 * t284 - 0.8e1 / 0.3e1 * t266 * t134)
  t289 = t19 * t288
  t293 = t19 * t138
  t298 = f.my_piecewise3(t2, 0, -t18 * t139 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t289 * t52 - 0.3e1 / 0.8e1 * t18 * t293 * t182)
  t313 = jnp.pi ** 2
  t315 = t25 ** 2
  t316 = 0.1e1 / t315
  t317 = t27 ** 2
  t326 = f.p.cam_omega / t56 / t3 / t316 / t317 / t151 * t62 / 0.3e1
  t327 = t3 * t316
  t328 = t150 ** 2
  t329 = 0.1e1 / t328
  t330 = t317 * t329
  t331 = t182 ** 2
  t337 = t147 * t189 * jnp.pi
  t344 = 0.1e1 / t150 / t52
  t345 = t27 * t344
  t350 = t34 ** 2
  t352 = 0.1e1 / t20 / t350
  t357 = t32 * t155
  t362 = 0.1e1 / t163 / t46
  t363 = t177 ** 2
  t376 = s0 ** 2
  t382 = 0.1e1 / t172 / t171
  t391 = 0.91259259259259259259259259259259259259259259259260e-2 * t30 * t33 * t352 * t47 + 0.49777777777777777777777777777777777777777777777778e-2 * t161 * t357 * t178 + 0.18666666666666666666666666666666666666666666666666e-2 * t161 * t162 * t362 * t363 - 0.93333333333333333333333333333333333333333333333332e-3 * t161 * t162 * t164 * (0.78400000000000000000000000000000000000000000000000e-1 * t38 / t19 / t153 * t42 + 0.16800000000000000000000000000000000000000000000000e0 * t33 * t352 * t173 - 0.89600000000000000000000000000000000000000000000000e-1 * t376 * t31 / t19 / t350 / t153 * t382)
  t396 = t11 ** 2
  t404 = 0.9e1 / 0.8e1 * t326 * t327 * t330 * t331 - t337 * t30 * t151 * t182 * t11 / 0.6e1 - t149 * t29 * t345 * t331 / 0.2e1 + t149 * t29 * t152 * t391 / 0.4e1 + 0.2e1 / 0.9e1 * t58 * t31 / t60 / t34
  t405 = f.my_piecewise3(t66, t404, 0)
  t440 = t194 ** 2
  t443 = -0.2e1 / 0.9e1 * t262 * t405 - 0.34e2 / 0.5985e4 * t255 * t405 + 0.18e2 / 0.3515e4 * t259 * t405 - 0.15e2 / 0.2108e4 * t247 * t405 + 0.32e2 / 0.5049e4 * t251 * t405 - 0.26e2 / 0.2835e4 * t239 * t405 + 0.7e1 / 0.870e3 * t243 * t405 - 0.11e2 / 0.897e3 * t231 * t405 + 0.24e2 / 0.2275e4 * t235 * t405 - 0.18e2 / 0.1045e4 * t223 * t405 + 0.10e2 / 0.693e3 * t227 * t405 + 0.16e2 / 0.765e3 * t219 * t405 + 0.3e1 / 0.91e2 * t211 * t405 - 0.7e1 / 0.270e3 * t215 * t405 + 0.8e1 / 0.135e3 * t203 * t405 - 0.10e2 / 0.231e3 * t207 * t405 + 0.2e1 / 0.15e2 * t144 * t405 + 0.10e2 / 0.21e2 * t82 * t440
  t465 = 0.1e1 / t111 / t72
  t482 = -0.3e1 / 0.7e1 * t85 * t440 - 0.3e1 / 0.35e2 * t199 * t405 - 0.10e2 / 0.33e2 * t97 * t440 - 0.2e1 / 0.3e1 * t73 * t440 + 0.3e1 / 0.5e1 * t76 * t440 - 0.8e1 / 0.15e2 * t79 * t440 - 0.7e1 / 0.30e2 * t109 * t440 + 0.7e1 / 0.18e2 * t88 * t440 - 0.16e2 / 0.45e2 * t91 * t440 + 0.18e2 / 0.55e2 * t94 * t440 - 0.18e2 / 0.95e2 * t465 * t440 + 0.11e2 / 0.39e2 * t100 * t440 - 0.24e2 / 0.91e2 * t103 * t440 + 0.26e2 / 0.105e3 * t106 * t440 + 0.2e1 / 0.3e1 * t70 * t440 + 0.15e2 / 0.68e2 * t112 * t440 - 0.32e2 / 0.153e3 * t115 * t440 + 0.34e2 / 0.171e3 * t118 * t440
  t484 = f.my_piecewise3(t66, 0, t404)
  t489 = t266 ** 2
  t495 = t125 ** 2
  t497 = 0.1e1 / t495 / t123
  t499 = t128 ** 2
  t500 = 0.1e1 / t499
  t516 = t126 / t495
  t525 = t126 / t495 / t125
  t536 = f.my_piecewise3(t65, t443 + t482, -0.8e1 / 0.3e1 * t484 * t134 - 0.16e2 / 0.3e1 * t266 * t284 - 0.8e1 / 0.3e1 * t123 * (0.2e1 * t276 * t489 * t269 - t127 * t484 * t269 - 0.2e1 * t497 * t489 * t500 + t484 * t131 / 0.4e1 + t266 * t281 / 0.2e1 + t123 * (-0.2e1 * t123 * t484 * t129 + 0.8e1 * t127 * t489 * t269 + 0.2e1 * t277 * t484 * t269 - 0.6e1 * t516 * t489 * t269 + 0.4e1 * t525 * t489 * t500 - 0.2e1 * t489 * t129) / 0.4e1))
  t548 = f.my_piecewise3(t2, 0, t18 / t20 / r0 * t138 * t52 / 0.12e2 - t18 * t21 * t288 * t52 / 0.4e1 - t18 * t139 * t182 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t19 * t536 * t52 - 0.3e1 / 0.4e1 * t18 * t289 * t182 - 0.3e1 / 0.8e1 * t18 * t293 * t391)
  v2rho2_0_ = 0.2e1 * r0 * t548 + 0.4e1 * t298
  t555 = 0.1e1 / t37 * t31
  t560 = 0.12600000000000000000000000000000000000000000000000e-1 * t555 * t43 + 0.12600000000000000000000000000000000000000000000000e-1 * t162 * t173
  t561 = t164 * t560
  t562 = t162 * t561
  t565 = 0.93333333333333333333333333333333333333333333333332e-3 * t30 * t162 * t47 - 0.93333333333333333333333333333333333333333333333332e-3 * t161 * t562
  t569 = t149 * t29 * t152 * t565 / 0.4e1
  t570 = f.my_piecewise3(t66, t569, 0)
  t607 = 0.2e1 / 0.15e2 * t144 * t570 - 0.3e1 / 0.35e2 * t199 * t570 + 0.8e1 / 0.135e3 * t203 * t570 - 0.10e2 / 0.231e3 * t207 * t570 + 0.3e1 / 0.91e2 * t211 * t570 - 0.7e1 / 0.270e3 * t215 * t570 + 0.16e2 / 0.765e3 * t219 * t570 - 0.18e2 / 0.1045e4 * t223 * t570 + 0.10e2 / 0.693e3 * t227 * t570 - 0.11e2 / 0.897e3 * t231 * t570 + 0.24e2 / 0.2275e4 * t235 * t570 - 0.26e2 / 0.2835e4 * t239 * t570 + 0.7e1 / 0.870e3 * t243 * t570 - 0.15e2 / 0.2108e4 * t247 * t570 + 0.32e2 / 0.5049e4 * t251 * t570 - 0.34e2 / 0.5985e4 * t255 * t570 + 0.18e2 / 0.3515e4 * t259 * t570 - 0.2e1 / 0.9e1 * t262 * t570
  t608 = f.my_piecewise3(t66, 0, t569)
  t610 = t127 * t608
  t616 = t608 * t269
  t619 = -0.2e1 * t123 * t608 * t129 + 0.2e1 * t277 * t616
  t622 = -t610 * t269 + t608 * t131 / 0.4e1 + t123 * t619 / 0.4e1
  t626 = f.my_piecewise3(t65, t607, -0.8e1 / 0.3e1 * t123 * t622 - 0.8e1 / 0.3e1 * t608 * t134)
  t627 = t19 * t626
  t634 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t293 * t565 - 0.3e1 / 0.8e1 * t18 * t627 * t52)
  t684 = -0.24888888888888888888888888888888888888888888888889e-2 * t30 * t357 * t47 - 0.93333333333333333333333333333333333333333333333332e-3 * t30 * t179 + 0.24888888888888888888888888888888888888888888888889e-2 * t161 * t357 * t561 + 0.18666666666666666666666666666666666666666666666666e-2 * t161 * t162 * t362 * t560 * t177 - 0.93333333333333333333333333333333333333333333333332e-3 * t161 * t162 * t164 * (-0.16800000000000000000000000000000000000000000000000e-1 * t555 * t167 - 0.50400000000000000000000000000000000000000000000000e-1 * t357 * t173 + 0.33600000000000000000000000000000000000000000000000e-1 * t31 / t19 / t350 / t34 * t382 * s0)
  t689 = 0.9e1 / 0.8e1 * t326 * t327 * t317 * t329 * t565 * t182 - t337 * t30 * t151 * t565 * t11 / 0.12e2 - t149 * t30 * t344 * t565 * t182 / 0.2e1 + t149 * t29 * t152 * t684 / 0.4e1
  t690 = f.my_piecewise3(t66, t689, 0)
  t727 = 0.8e1 / 0.135e3 * t203 * t690 - 0.3e1 / 0.35e2 * t199 * t690 + 0.2e1 / 0.15e2 * t144 * t690 - 0.34e2 / 0.5985e4 * t255 * t690 - 0.15e2 / 0.2108e4 * t247 * t690 + 0.18e2 / 0.3515e4 * t259 * t690 - 0.2e1 / 0.9e1 * t262 * t690 - 0.26e2 / 0.2835e4 * t239 * t690 + 0.32e2 / 0.5049e4 * t251 * t690 + 0.24e2 / 0.2275e4 * t235 * t690 + 0.10e2 / 0.693e3 * t227 * t690 + 0.7e1 / 0.870e3 * t243 * t690 + 0.16e2 / 0.765e3 * t219 * t690 - 0.18e2 / 0.1045e4 * t223 * t690 - 0.11e2 / 0.897e3 * t231 * t690 + 0.3e1 / 0.91e2 * t211 * t690 - 0.7e1 / 0.270e3 * t215 * t690 - 0.10e2 / 0.231e3 * t207 * t690
  t782 = 0.3e1 / 0.5e1 * t76 * t570 * t194 - 0.8e1 / 0.15e2 * t79 * t570 * t194 - 0.3e1 / 0.7e1 * t85 * t570 * t194 + 0.7e1 / 0.18e2 * t88 * t570 * t194 - 0.16e2 / 0.45e2 * t91 * t570 * t194 - 0.2e1 / 0.3e1 * t73 * t570 * t194 - 0.10e2 / 0.33e2 * t97 * t570 * t194 + 0.11e2 / 0.39e2 * t100 * t570 * t194 - 0.24e2 / 0.91e2 * t103 * t570 * t194 + 0.10e2 / 0.21e2 * t82 * t570 * t194 + 0.26e2 / 0.105e3 * t106 * t570 * t194 - 0.7e1 / 0.30e2 * t109 * t570 * t194 + 0.15e2 / 0.68e2 * t112 * t570 * t194 + 0.18e2 / 0.55e2 * t94 * t570 * t194 - 0.32e2 / 0.153e3 * t115 * t570 * t194 + 0.34e2 / 0.171e3 * t118 * t570 * t194 - 0.18e2 / 0.95e2 * t465 * t570 * t194 + 0.2e1 / 0.3e1 * t70 * t570 * t194
  t784 = f.my_piecewise3(t66, 0, t689)
  t828 = f.my_piecewise3(t65, t727 + t782, -0.8e1 / 0.3e1 * t784 * t134 - 0.8e1 / 0.3e1 * t608 * t284 - 0.8e1 / 0.3e1 * t266 * t622 - 0.8e1 / 0.3e1 * t123 * (0.2e1 * t276 * t608 * t278 - t127 * t784 * t269 - 0.2e1 * t497 * t608 * t500 * t266 + t784 * t131 / 0.4e1 + t608 * t281 / 0.4e1 + t266 * t619 / 0.4e1 + t123 * (0.4e1 * t525 * t608 * t500 * t266 - 0.2e1 * t123 * t784 * t129 - 0.2e1 * t266 * t608 * t129 - 0.6e1 * t516 * t616 * t266 + 0.2e1 * t277 * t784 * t269 + 0.8e1 * t610 * t278) / 0.4e1))
  t846 = f.my_piecewise3(t2, 0, -t18 * t21 * t626 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t828 * t52 - 0.3e1 / 0.8e1 * t18 * t627 * t182 - t18 * t139 * t565 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t289 * t565 - 0.3e1 / 0.8e1 * t18 * t293 * t684)
  v2rhosigma_0_ = 0.2e1 * r0 * t846 + 0.2e1 * t634
  t849 = t565 ** 2
  t860 = t560 ** 2
  t886 = -0.18666666666666666666666666666666666666666666666666e-2 * t30 * t562 + 0.18666666666666666666666666666666666666666666666666e-2 * t161 * t162 * t362 * t860 - 0.93333333333333333333333333333333333333333333333332e-3 * t161 * t162 * t164 * (-0.63000000000000000000000000000000000000000000000000e-2 / t37 / s0 * t31 * t43 + 0.63000000000000000000000000000000000000000000000000e-2 / s0 * t32 * t36 * t173 - 0.12600000000000000000000000000000000000000000000000e-1 * t31 / t19 / t350 / r0 * t382)
  t891 = 0.9e1 / 0.8e1 * t326 * t327 * t330 * t849 - t149 * t29 * t345 * t849 / 0.2e1 + t149 * t29 * t152 * t886 / 0.4e1
  t892 = f.my_piecewise3(t66, t891, 0)
  t919 = t570 ** 2
  t930 = -0.15e2 / 0.2108e4 * t247 * t892 + 0.32e2 / 0.5049e4 * t251 * t892 + 0.18e2 / 0.3515e4 * t259 * t892 - 0.2e1 / 0.9e1 * t262 * t892 + 0.7e1 / 0.870e3 * t243 * t892 - 0.34e2 / 0.5985e4 * t255 * t892 + 0.10e2 / 0.693e3 * t227 * t892 - 0.10e2 / 0.231e3 * t207 * t892 - 0.26e2 / 0.2835e4 * t239 * t892 + 0.3e1 / 0.91e2 * t211 * t892 - 0.7e1 / 0.270e3 * t215 * t892 - 0.3e1 / 0.35e2 * t199 * t892 + 0.8e1 / 0.135e3 * t203 * t892 - 0.10e2 / 0.33e2 * t97 * t919 - 0.2e1 / 0.3e1 * t73 * t919 + 0.3e1 / 0.5e1 * t76 * t919 - 0.8e1 / 0.15e2 * t79 * t919 + 0.2e1 / 0.15e2 * t144 * t892
  t967 = 0.15e2 / 0.68e2 * t112 * t919 + 0.10e2 / 0.21e2 * t82 * t919 - 0.3e1 / 0.7e1 * t85 * t919 + 0.7e1 / 0.18e2 * t88 * t919 - 0.16e2 / 0.45e2 * t91 * t919 + 0.18e2 / 0.55e2 * t94 * t919 + 0.2e1 / 0.3e1 * t70 * t919 + 0.11e2 / 0.39e2 * t100 * t919 - 0.24e2 / 0.91e2 * t103 * t919 + 0.26e2 / 0.105e3 * t106 * t919 - 0.7e1 / 0.30e2 * t109 * t919 - 0.32e2 / 0.153e3 * t115 * t919 + 0.34e2 / 0.171e3 * t118 * t919 - 0.18e2 / 0.95e2 * t465 * t919 + 0.16e2 / 0.765e3 * t219 * t892 - 0.18e2 / 0.1045e4 * t223 * t892 - 0.11e2 / 0.897e3 * t231 * t892 + 0.24e2 / 0.2275e4 * t235 * t892
  t969 = f.my_piecewise3(t66, 0, t891)
  t974 = t608 ** 2
  t1011 = f.my_piecewise3(t65, t930 + t967, -0.8e1 / 0.3e1 * t969 * t134 - 0.16e2 / 0.3e1 * t608 * t622 - 0.8e1 / 0.3e1 * t123 * (0.2e1 * t276 * t974 * t269 - t127 * t969 * t269 - 0.2e1 * t497 * t974 * t500 + t969 * t131 / 0.4e1 + t608 * t619 / 0.2e1 + t123 * (-0.2e1 * t123 * t969 * t129 + 0.8e1 * t127 * t974 * t269 + 0.2e1 * t277 * t969 * t269 - 0.6e1 * t516 * t974 * t269 + 0.4e1 * t525 * t974 * t500 - 0.2e1 * t974 * t129) / 0.4e1))
  t1023 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t1011 * t52 - 0.3e1 / 0.4e1 * t18 * t627 * t565 - 0.3e1 / 0.8e1 * t18 * t293 * t886)
  v2sigma2_0_ = 0.2e1 * r0 * t1023

  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = t3 ** 2
  t26 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t30 = t23 * t27
  t31 = t30 * t28
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = s0 * t33
  t35 = r0 ** 2
  t37 = 0.1e1 / t20 / t35
  t38 = jnp.sqrt(s0)
  t39 = t38 * t32
  t41 = 0.1e1 / t19 / r0
  t43 = jnp.asinh(t39 * t41)
  t47 = 0.1e1 + 0.2520e-1 * t39 * t41 * t43
  t48 = 0.1e1 / t47
  t53 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t31 * t34 * t37 * t48
  t56 = jnp.pi * t23 * t27 * t28 / t53
  t57 = jnp.sqrt(t56)
  t59 = f.p.cam_omega / t57
  t60 = t11 * r0
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = 0.1e1 / t61
  t63 = t32 * t62
  t65 = t59 * t63 / 0.2e1
  t66 = 0.192e1 <= t65
  t67 = 0.192e1 < t65
  t68 = f.my_piecewise3(t67, t65, 0.192e1)
  t69 = t68 ** 2
  t70 = t69 ** 2
  t71 = 0.1e1 / t70
  t73 = t70 * t69
  t74 = 0.1e1 / t73
  t76 = t70 ** 2
  t77 = 0.1e1 / t76
  t79 = t76 * t69
  t80 = 0.1e1 / t79
  t82 = t76 * t70
  t83 = 0.1e1 / t82
  t85 = t76 * t73
  t86 = 0.1e1 / t85
  t88 = t76 ** 2
  t89 = 0.1e1 / t88
  t92 = 0.1e1 / t88 / t69
  t95 = 0.1e1 / t88 / t70
  t98 = 0.1e1 / t88 / t73
  t101 = 0.1e1 / t88 / t76
  t104 = 0.1e1 / t88 / t79
  t107 = 0.1e1 / t88 / t82
  t110 = 0.1e1 / t88 / t85
  t112 = t88 ** 2
  t113 = 0.1e1 / t112
  t116 = 0.1e1 / t112 / t69
  t119 = 0.1e1 / t112 / t70
  t123 = -t71 / 0.30e2 + t74 / 0.70e2 - t77 / 0.135e3 + t80 / 0.231e3 - t83 / 0.364e3 + t86 / 0.540e3 - t89 / 0.765e3 + t92 / 0.1045e4 - t95 / 0.1386e4 + t98 / 0.1794e4 - t101 / 0.2275e4 + t104 / 0.2835e4 - t107 / 0.3480e4 + t110 / 0.4216e4 - t113 / 0.5049e4 + t116 / 0.5985e4 - t119 / 0.7030e4 + 0.1e1 / t69 / 0.9e1
  t124 = f.my_piecewise3(t67, 0.192e1, t65)
  t125 = jnp.atan2(0.1e1, t124)
  t126 = t124 ** 2
  t127 = t126 + 0.3e1
  t128 = 0.1e1 / t126
  t129 = 0.1e1 + t128
  t130 = jnp.log(t129)
  t132 = -t127 * t130 + 0.1e1
  t135 = t125 + t124 * t132 / 0.4e1
  t139 = f.my_piecewise3(t66, t123, 0.1e1 - 0.8e1 / 0.3e1 * t124 * t135)
  t140 = t22 * t139
  t144 = 0.1e1 / t20
  t145 = t70 * t68
  t146 = 0.1e1 / t145
  t149 = f.p.cam_omega / t57 / t56
  t151 = t149 * t63 * jnp.pi
  t152 = t53 ** 2
  t153 = 0.1e1 / t152
  t154 = t28 * t153
  t155 = t35 * r0
  t157 = 0.1e1 / t20 / t155
  t163 = t30 * t28 * s0
  t164 = t33 * t37
  t165 = t47 ** 2
  t166 = 0.1e1 / t165
  t173 = t34 * t37 + 0.1e1
  t174 = jnp.sqrt(t173)
  t175 = 0.1e1 / t174
  t179 = -0.33600000000000000000000000000000000000000000000000e-1 * t39 / t19 / t35 * t43 - 0.33600000000000000000000000000000000000000000000000e-1 * t34 * t157 * t175
  t180 = t166 * t179
  t184 = -0.24888888888888888888888888888888888888888888888889e-2 * t31 * t34 * t157 * t48 - 0.93333333333333333333333333333333333333333333333332e-3 * t163 * t164 * t180
  t191 = t32 / t61 / t60
  t195 = t151 * t30 * t154 * t184 / 0.4e1 - t59 * t191 * t11 / 0.6e1
  t196 = f.my_piecewise3(t67, t195, 0)
  t199 = t69 * t68
  t200 = t70 * t199
  t201 = 0.1e1 / t200
  t204 = t76 * t68
  t205 = 0.1e1 / t204
  t208 = t76 * t199
  t209 = 0.1e1 / t208
  t212 = t76 * t145
  t213 = 0.1e1 / t212
  t216 = t76 * t200
  t217 = 0.1e1 / t216
  t221 = 0.1e1 / t88 / t68
  t225 = 0.1e1 / t88 / t199
  t229 = 0.1e1 / t88 / t145
  t233 = 0.1e1 / t88 / t200
  t237 = 0.1e1 / t88 / t204
  t241 = 0.1e1 / t88 / t208
  t245 = 0.1e1 / t88 / t212
  t249 = 0.1e1 / t88 / t216
  t253 = 0.1e1 / t112 / t68
  t257 = 0.1e1 / t112 / t199
  t261 = 0.1e1 / t112 / t145
  t264 = 0.1e1 / t199
  t267 = 0.2e1 / 0.15e2 * t146 * t196 - 0.3e1 / 0.35e2 * t201 * t196 + 0.8e1 / 0.135e3 * t205 * t196 - 0.10e2 / 0.231e3 * t209 * t196 + 0.3e1 / 0.91e2 * t213 * t196 - 0.7e1 / 0.270e3 * t217 * t196 + 0.16e2 / 0.765e3 * t221 * t196 - 0.18e2 / 0.1045e4 * t225 * t196 + 0.10e2 / 0.693e3 * t229 * t196 - 0.11e2 / 0.897e3 * t233 * t196 + 0.24e2 / 0.2275e4 * t237 * t196 - 0.26e2 / 0.2835e4 * t241 * t196 + 0.7e1 / 0.870e3 * t245 * t196 - 0.15e2 / 0.2108e4 * t249 * t196 + 0.32e2 / 0.5049e4 * t253 * t196 - 0.34e2 / 0.5985e4 * t257 * t196 + 0.18e2 / 0.3515e4 * t261 * t196 - 0.2e1 / 0.9e1 * t264 * t196
  t268 = f.my_piecewise3(t67, 0, t195)
  t271 = 0.1e1 / t129
  t277 = t126 * t124
  t278 = 0.1e1 / t277
  t279 = t127 * t278
  t280 = t268 * t271
  t283 = -0.2e1 * t124 * t268 * t130 + 0.2e1 * t279 * t280
  t286 = -t128 * t268 * t271 + t268 * t132 / 0.4e1 + t124 * t283 / 0.4e1
  t290 = f.my_piecewise3(t66, t267, -0.8e1 / 0.3e1 * t124 * t286 - 0.8e1 / 0.3e1 * t268 * t135)
  t291 = t144 * t290
  t295 = t144 * t139
  t299 = jnp.pi ** 2
  t301 = t26 ** 2
  t302 = 0.1e1 / t301
  t303 = t28 ** 2
  t310 = f.p.cam_omega / t57 / t299 / t3 / t302 / t303 / t153 / 0.3e1
  t312 = t310 * t63 * t299
  t313 = t3 * t302
  t314 = t152 ** 2
  t315 = 0.1e1 / t314
  t317 = t184 ** 2
  t323 = t149 * t191 * jnp.pi
  t324 = t153 * t184
  t330 = 0.1e1 / t152 / t53
  t336 = t35 ** 2
  t338 = 0.1e1 / t20 / t336
  t343 = t33 * t157
  t348 = 0.1e1 / t165 / t47
  t349 = t179 ** 2
  t350 = t348 * t349
  t362 = s0 ** 2
  t363 = t362 * t32
  t368 = 0.1e1 / t174 / t173
  t372 = 0.78400000000000000000000000000000000000000000000000e-1 * t39 / t19 / t155 * t43 + 0.16800000000000000000000000000000000000000000000000e0 * t34 * t338 * t175 - 0.89600000000000000000000000000000000000000000000000e-1 * t363 / t19 / t336 / t155 * t368
  t373 = t166 * t372
  t377 = 0.91259259259259259259259259259259259259259259259260e-2 * t31 * t34 * t338 * t48 + 0.49777777777777777777777777777777777777777777777778e-2 * t163 * t343 * t180 + 0.18666666666666666666666666666666666666666666666666e-2 * t163 * t164 * t350 - 0.93333333333333333333333333333333333333333333333332e-3 * t163 * t164 * t373
  t382 = t11 ** 2
  t386 = t32 / t61 / t382 / t35
  t390 = 0.9e1 / 0.8e1 * t312 * t313 * t303 * t315 * t317 - t323 * t31 * t324 * t11 / 0.6e1 - t151 * t30 * t28 * t330 * t317 / 0.2e1 + t151 * t30 * t154 * t377 / 0.4e1 + 0.2e1 / 0.9e1 * t59 * t386 * t382
  t391 = f.my_piecewise3(t67, t390, 0)
  t410 = t196 ** 2
  t429 = -0.11e2 / 0.897e3 * t233 * t391 + 0.18e2 / 0.3515e4 * t261 * t391 - 0.2e1 / 0.9e1 * t264 * t391 - 0.18e2 / 0.1045e4 * t225 * t391 + 0.10e2 / 0.693e3 * t229 * t391 - 0.7e1 / 0.270e3 * t217 * t391 + 0.8e1 / 0.135e3 * t205 * t391 + 0.2e1 / 0.15e2 * t146 * t391 - 0.3e1 / 0.35e2 * t201 * t391 - 0.2e1 / 0.3e1 * t74 * t410 - 0.10e2 / 0.231e3 * t209 * t391 + 0.3e1 / 0.5e1 * t77 * t410 - 0.8e1 / 0.15e2 * t80 * t410 + 0.10e2 / 0.21e2 * t83 * t410 - 0.3e1 / 0.7e1 * t86 * t410 + 0.7e1 / 0.18e2 * t89 * t410 - 0.16e2 / 0.45e2 * t92 * t410 + 0.18e2 / 0.55e2 * t95 * t410
  t449 = 0.1e1 / t112 / t73
  t468 = -0.10e2 / 0.33e2 * t98 * t410 + 0.2e1 / 0.3e1 * t71 * t410 + 0.11e2 / 0.39e2 * t101 * t410 - 0.24e2 / 0.91e2 * t104 * t410 + 0.26e2 / 0.105e3 * t107 * t410 - 0.7e1 / 0.30e2 * t110 * t410 + 0.15e2 / 0.68e2 * t113 * t410 - 0.32e2 / 0.153e3 * t116 * t410 + 0.34e2 / 0.171e3 * t119 * t410 - 0.18e2 / 0.95e2 * t449 * t410 + 0.32e2 / 0.5049e4 * t253 * t391 - 0.34e2 / 0.5985e4 * t257 * t391 + 0.7e1 / 0.870e3 * t245 * t391 - 0.15e2 / 0.2108e4 * t249 * t391 + 0.24e2 / 0.2275e4 * t237 * t391 - 0.26e2 / 0.2835e4 * t241 * t391 + 0.3e1 / 0.91e2 * t213 * t391 + 0.16e2 / 0.765e3 * t221 * t391
  t470 = f.my_piecewise3(t67, 0, t390)
  t475 = t268 ** 2
  t479 = t128 * t470
  t481 = t126 ** 2
  t483 = 0.1e1 / t481 / t124
  t485 = t129 ** 2
  t486 = 0.1e1 / t485
  t501 = 0.1e1 / t481
  t502 = t127 * t501
  t506 = t470 * t271
  t510 = 0.1e1 / t481 / t126
  t511 = t127 * t510
  t515 = -0.2e1 * t124 * t470 * t130 + 0.8e1 * t128 * t475 * t271 - 0.6e1 * t502 * t475 * t271 + 0.4e1 * t511 * t475 * t486 - 0.2e1 * t475 * t130 + 0.2e1 * t279 * t506
  t518 = 0.2e1 * t278 * t475 * t271 - t479 * t271 - 0.2e1 * t483 * t475 * t486 + t470 * t132 / 0.4e1 + t268 * t283 / 0.2e1 + t124 * t515 / 0.4e1
  t522 = f.my_piecewise3(t66, t429 + t468, -0.8e1 / 0.3e1 * t470 * t135 - 0.16e2 / 0.3e1 * t268 * t286 - 0.8e1 / 0.3e1 * t124 * t518)
  t523 = t19 * t522
  t527 = t19 * t290
  t531 = t19 * t139
  t536 = f.my_piecewise3(t2, 0, t18 * t140 * t53 / 0.12e2 - t18 * t291 * t53 / 0.4e1 - t18 * t295 * t184 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t523 * t53 - 0.3e1 / 0.4e1 * t18 * t527 * t184 - 0.3e1 / 0.8e1 * t18 * t531 * t377)
  t598 = -0.16e2 / 0.15e2 * t92 * t391 * t196 - 0.9e1 / 0.7e1 * t86 * t196 * t391 + 0.45e2 / 0.68e2 * t113 * t196 * t391 + 0.10e2 / 0.7e1 * t83 * t196 * t391 - 0.54e2 / 0.95e2 * t449 * t391 * t196 - 0.7e1 / 0.10e2 * t110 * t391 * t196 + 0.9e1 / 0.5e1 * t77 * t391 * t196 - 0.8e1 / 0.5e1 * t80 * t196 * t391 + 0.34e2 / 0.57e2 * t119 * t391 * t196 + 0.7e1 / 0.6e1 * t89 * t196 * t391 - 0.72e2 / 0.91e2 * t104 * t196 * t391 - 0.2e1 * t74 * t196 * t391 + 0.26e2 / 0.35e2 * t107 * t391 * t196
  t614 = t299 ** 2
  t624 = t317 * t184
  t631 = t313 * t303
  t677 = 0.1e1 / t20 / t336 / r0
  t692 = t165 ** 2
  t712 = t336 ** 2
  t722 = t173 ** 2
  t732 = -0.42587654320987654320987654320987654320987654320988e-1 * t31 * t34 * t677 * t48 - 0.27377777777777777777777777777777777777777777777778e-1 * t163 * t33 * t338 * t180 - 0.14933333333333333333333333333333333333333333333333e-1 * t163 * t343 * t350 + 0.74666666666666666666666666666666666666666666666667e-2 * t163 * t343 * t373 - 0.55999999999999999999999999999999999999999999999998e-2 * t163 * t164 / t692 * t349 * t179 + 0.55999999999999999999999999999999999999999999999998e-2 * t163 * t164 * t348 * t179 * t372 - 0.93333333333333333333333333333333333333333333333332e-3 * t163 * t164 * t166 * (-0.26133333333333333333333333333333333333333333333333e0 * t39 / t19 / t336 * t43 - 0.88853333333333333333333333333333333333333333333333e0 * t34 * t677 * t175 + 0.11050666666666666666666666666666666666666666666667e1 * t363 / t19 / t712 * t368 - 0.71680000000000000000000000000000000000000000000000e0 * t362 * s0 / t712 / t155 / t174 / t722)
  t737 = t382 * t11
  t745 = 0.15e2 / 0.16e2 * f.p.cam_omega / t57 / t330 * t32 * t62 / t314 / t152 * t624 - 0.9e1 / 0.8e1 * t310 * t191 * t299 * t631 * t315 * t317 * t11 - 0.27e2 / 0.4e1 * t312 * t313 * t303 / t314 / t53 * t624 + 0.27e2 / 0.8e1 * t312 * t631 * t315 * t184 * t377 + t149 * t386 * jnp.pi * t31 * t324 * t382 / 0.3e1 + t323 * t31 * t330 * t317 * t11 / 0.2e1 - t323 * t31 * t153 * t377 * t11 / 0.4e1 + 0.3e1 / 0.2e1 * t151 * t30 * t28 * t315 * t624 - 0.3e1 / 0.2e1 * t151 * t31 * t330 * t184 * t377 + t151 * t30 * t154 * t732 / 0.4e1 - 0.14e2 / 0.27e2 * t59 * t32 / t61 / t155
  t746 = f.my_piecewise3(t67, t745, 0)
  t755 = t410 * t196
  t766 = -0.10e2 / 0.11e2 * t98 * t391 * t196 + 0.11e2 / 0.13e2 * t101 * t391 * t196 - 0.32e2 / 0.51e2 * t116 * t196 * t391 + 0.2e1 * t71 * t196 * t391 + 0.54e2 / 0.55e2 * t95 * t391 * t196 - 0.26e2 / 0.2835e4 * t241 * t746 + 0.32e2 / 0.5049e4 * t253 * t746 - 0.10e2 / 0.231e3 * t209 * t746 + 0.24e2 / 0.2275e4 * t237 * t746 - 0.24e2 / 0.5e1 * t205 * t755 + 0.32e2 / 0.5e1 * t225 * t755 - 0.88e2 / 0.13e2 * t237 * t755 - 0.8e1 / 0.3e1 * t146 * t755 + 0.18e2 / 0.3515e4 * t261 * t746
  t796 = 0.3e1 / 0.91e2 * t213 * t746 - 0.120e3 / 0.17e2 * t253 * t755 - 0.56e2 / 0.9e1 * t221 * t755 + 0.64e2 / 0.9e1 * t257 * t755 - 0.18e2 / 0.1045e4 * t225 * t746 + 0.7e1 / 0.870e3 * t245 * t746 - 0.11e2 / 0.897e3 * t233 * t746 - 0.104e3 / 0.15e2 * t245 * t755 + 0.48e2 / 0.7e1 * t241 * t755 + 0.36e2 / 0.5e1 / t112 / t200 * t755 - 0.40e2 / 0.7e1 * t213 * t755 - 0.136e3 / 0.19e2 * t261 * t755 + 0.4e1 * t201 * t755
  t825 = 0.20e2 / 0.3e1 * t233 * t755 - 0.2e1 / 0.9e1 * t264 * t746 + 0.16e2 / 0.3e1 * t209 * t755 + 0.2e1 / 0.15e2 * t146 * t746 - 0.72e2 / 0.11e2 * t229 * t755 + 0.7e1 * t249 * t755 + 0.8e1 / 0.135e3 * t205 * t746 - 0.34e2 / 0.5985e4 * t257 * t746 + 0.10e2 / 0.693e3 * t229 * t746 + 0.16e2 / 0.765e3 * t221 * t746 + 0.6e1 * t217 * t755 - 0.15e2 / 0.2108e4 * t249 * t746 - 0.3e1 / 0.35e2 * t201 * t746 - 0.7e1 / 0.270e3 * t217 * t746
  t828 = f.my_piecewise3(t67, 0, t745)
  t835 = t475 * t268
  t851 = t481 ** 2
  t855 = 0.1e1 / t485 / t129
  t904 = -0.6e1 * t268 * t130 * t470 - 0.24e2 * t835 * t278 * t271 - 0.2e1 * t124 * t828 * t130 + 0.24e2 * t479 * t280 + 0.24e2 * t483 * t835 * t486 + 0.24e2 * t127 * t483 * t835 * t271 - 0.18e2 * t502 * t280 * t470 - 0.36e2 * t127 / t481 / t277 * t835 * t486 + 0.2e1 * t279 * t828 * t271 + 0.12e2 * t511 * t470 * t486 * t268 + 0.16e2 * t127 / t851 / t124 * t835 * t855
  t911 = f.my_piecewise3(t66, t598 + t766 + t796 + t825, -0.8e1 / 0.3e1 * t828 * t135 - 0.8e1 * t470 * t286 - 0.8e1 * t268 * t518 - 0.8e1 / 0.3e1 * t124 * (-0.6e1 * t501 * t835 * t271 + 0.6e1 * t278 * t268 * t506 + 0.14e2 * t510 * t835 * t486 - t128 * t828 * t271 - 0.6e1 * t483 * t470 * t486 * t268 - 0.8e1 / t851 * t835 * t855 + t828 * t132 / 0.4e1 + 0.3e1 / 0.4e1 * t470 * t283 + 0.3e1 / 0.4e1 * t268 * t515 + t124 * t904 / 0.4e1))
  t926 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t37 * t139 * t53 + t18 * t22 * t290 * t53 / 0.4e1 + t18 * t140 * t184 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t144 * t522 * t53 - 0.3e1 / 0.4e1 * t18 * t291 * t184 - 0.3e1 / 0.8e1 * t18 * t295 * t377 - 0.3e1 / 0.8e1 * t18 * t19 * t911 * t53 - 0.9e1 / 0.8e1 * t18 * t523 * t184 - 0.9e1 / 0.8e1 * t18 * t527 * t377 - 0.3e1 / 0.8e1 * t18 * t531 * t732)
  v3rho3_0_ = 0.2e1 * r0 * t926 + 0.6e1 * t536

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t3 / t4 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = t3 ** 2
  t26 = 0.1e1 / jnp.pi
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = 0.1e1 / t27
  t29 = 4 ** (0.1e1 / 0.3e1)
  t30 = t28 * t29
  t31 = t24 * t28
  t32 = t31 * t29
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = s0 * t34
  t36 = jnp.sqrt(s0)
  t37 = t36 * t33
  t39 = 0.1e1 / t20 / r0
  t41 = jnp.asinh(t37 * t39)
  t45 = 0.1e1 + 0.2520e-1 * t37 * t39 * t41
  t46 = 0.1e1 / t45
  t51 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t32 * t35 * t23 * t46
  t54 = jnp.pi * t24 * t30 / t51
  t55 = jnp.sqrt(t54)
  t57 = f.p.cam_omega / t55
  t58 = t11 * r0
  t59 = t58 ** (0.1e1 / 0.3e1)
  t60 = 0.1e1 / t59
  t61 = t33 * t60
  t63 = t57 * t61 / 0.2e1
  t64 = 0.192e1 <= t63
  t65 = 0.192e1 < t63
  t66 = f.my_piecewise3(t65, t63, 0.192e1)
  t67 = t66 ** 2
  t68 = t67 ** 2
  t69 = 0.1e1 / t68
  t71 = t68 * t67
  t72 = 0.1e1 / t71
  t74 = t68 ** 2
  t75 = 0.1e1 / t74
  t77 = t74 * t67
  t78 = 0.1e1 / t77
  t80 = t74 * t68
  t81 = 0.1e1 / t80
  t83 = t74 * t71
  t84 = 0.1e1 / t83
  t86 = t74 ** 2
  t87 = 0.1e1 / t86
  t90 = 0.1e1 / t86 / t67
  t93 = 0.1e1 / t86 / t68
  t96 = 0.1e1 / t86 / t71
  t99 = 0.1e1 / t86 / t74
  t102 = 0.1e1 / t86 / t77
  t105 = 0.1e1 / t86 / t80
  t108 = 0.1e1 / t86 / t83
  t110 = t86 ** 2
  t111 = 0.1e1 / t110
  t114 = 0.1e1 / t110 / t67
  t117 = 0.1e1 / t110 / t68
  t121 = -t69 / 0.30e2 + t72 / 0.70e2 - t75 / 0.135e3 + t78 / 0.231e3 - t81 / 0.364e3 + t84 / 0.540e3 - t87 / 0.765e3 + t90 / 0.1045e4 - t93 / 0.1386e4 + t96 / 0.1794e4 - t99 / 0.2275e4 + t102 / 0.2835e4 - t105 / 0.3480e4 + t108 / 0.4216e4 - t111 / 0.5049e4 + t114 / 0.5985e4 - t117 / 0.7030e4 + 0.1e1 / t67 / 0.9e1
  t122 = f.my_piecewise3(t65, 0.192e1, t63)
  t123 = jnp.atan2(0.1e1, t122)
  t124 = t122 ** 2
  t125 = t124 + 0.3e1
  t126 = 0.1e1 / t124
  t127 = 0.1e1 + t126
  t128 = jnp.log(t127)
  t130 = -t125 * t128 + 0.1e1
  t133 = t123 + t122 * t130 / 0.4e1
  t137 = f.my_piecewise3(t64, t121, 0.1e1 - 0.8e1 / 0.3e1 * t122 * t133)
  t138 = t23 * t137
  t143 = 0.1e1 / t21 / r0
  t144 = t68 * t66
  t145 = 0.1e1 / t144
  t148 = f.p.cam_omega / t55 / t54
  t150 = t148 * t61 * jnp.pi
  t151 = t51 ** 2
  t152 = 0.1e1 / t151
  t153 = t29 * t152
  t154 = t19 * r0
  t156 = 0.1e1 / t21 / t154
  t162 = t31 * t29 * s0
  t163 = t34 * t23
  t164 = t45 ** 2
  t165 = 0.1e1 / t164
  t172 = t35 * t23 + 0.1e1
  t173 = jnp.sqrt(t172)
  t174 = 0.1e1 / t173
  t178 = -0.33600000000000000000000000000000000000000000000000e-1 * t37 / t20 / t19 * t41 - 0.33600000000000000000000000000000000000000000000000e-1 * t35 * t156 * t174
  t179 = t165 * t178
  t183 = -0.24888888888888888888888888888888888888888888888889e-2 * t32 * t35 * t156 * t46 - 0.93333333333333333333333333333333333333333333333332e-3 * t162 * t163 * t179
  t189 = 0.1e1 / t59 / t58
  t190 = t33 * t189
  t194 = t150 * t31 * t153 * t183 / 0.4e1 - t57 * t190 * t11 / 0.6e1
  t195 = f.my_piecewise3(t65, t194, 0)
  t198 = t67 * t66
  t199 = t68 * t198
  t200 = 0.1e1 / t199
  t203 = t74 * t66
  t204 = 0.1e1 / t203
  t207 = t74 * t198
  t208 = 0.1e1 / t207
  t211 = t74 * t144
  t212 = 0.1e1 / t211
  t215 = t74 * t199
  t216 = 0.1e1 / t215
  t220 = 0.1e1 / t86 / t66
  t224 = 0.1e1 / t86 / t198
  t228 = 0.1e1 / t86 / t144
  t232 = 0.1e1 / t86 / t199
  t236 = 0.1e1 / t86 / t203
  t240 = 0.1e1 / t86 / t207
  t244 = 0.1e1 / t86 / t211
  t248 = 0.1e1 / t86 / t215
  t252 = 0.1e1 / t110 / t66
  t256 = 0.1e1 / t110 / t198
  t260 = 0.1e1 / t110 / t144
  t263 = 0.1e1 / t198
  t266 = 0.2e1 / 0.15e2 * t145 * t195 - 0.3e1 / 0.35e2 * t200 * t195 + 0.8e1 / 0.135e3 * t204 * t195 - 0.10e2 / 0.231e3 * t208 * t195 + 0.3e1 / 0.91e2 * t212 * t195 - 0.7e1 / 0.270e3 * t216 * t195 + 0.16e2 / 0.765e3 * t220 * t195 - 0.18e2 / 0.1045e4 * t224 * t195 + 0.10e2 / 0.693e3 * t228 * t195 - 0.11e2 / 0.897e3 * t232 * t195 + 0.24e2 / 0.2275e4 * t236 * t195 - 0.26e2 / 0.2835e4 * t240 * t195 + 0.7e1 / 0.870e3 * t244 * t195 - 0.15e2 / 0.2108e4 * t248 * t195 + 0.32e2 / 0.5049e4 * t252 * t195 - 0.34e2 / 0.5985e4 * t256 * t195 + 0.18e2 / 0.3515e4 * t260 * t195 - 0.2e1 / 0.9e1 * t263 * t195
  t267 = f.my_piecewise3(t65, 0, t194)
  t270 = 0.1e1 / t127
  t276 = t124 * t122
  t277 = 0.1e1 / t276
  t278 = t125 * t277
  t279 = t267 * t270
  t282 = -0.2e1 * t122 * t267 * t128 + 0.2e1 * t278 * t279
  t285 = -t126 * t267 * t270 + t267 * t130 / 0.4e1 + t122 * t282 / 0.4e1
  t289 = f.my_piecewise3(t64, t266, -0.8e1 / 0.3e1 * t122 * t285 - 0.8e1 / 0.3e1 * t267 * t133)
  t290 = t143 * t289
  t294 = t143 * t137
  t298 = 0.1e1 / t21
  t299 = jnp.pi ** 2
  t301 = t27 ** 2
  t302 = 0.1e1 / t301
  t303 = t29 ** 2
  t304 = t302 * t303
  t310 = f.p.cam_omega / t55 / t299 / t3 / t304 / t152 / 0.3e1
  t312 = t310 * t61 * t299
  t313 = t3 * t302
  t314 = t151 ** 2
  t315 = 0.1e1 / t314
  t316 = t303 * t315
  t317 = t183 ** 2
  t323 = t148 * t190 * jnp.pi
  t324 = t152 * t183
  t329 = t151 * t51
  t330 = 0.1e1 / t329
  t331 = t29 * t330
  t336 = t19 ** 2
  t338 = 0.1e1 / t21 / t336
  t343 = t34 * t156
  t348 = 0.1e1 / t164 / t45
  t349 = t178 ** 2
  t350 = t348 * t349
  t362 = s0 ** 2
  t363 = t362 * t33
  t368 = 0.1e1 / t173 / t172
  t372 = 0.78400000000000000000000000000000000000000000000000e-1 * t37 / t20 / t154 * t41 + 0.16800000000000000000000000000000000000000000000000e0 * t35 * t338 * t174 - 0.89600000000000000000000000000000000000000000000000e-1 * t363 / t20 / t336 / t154 * t368
  t373 = t165 * t372
  t377 = 0.91259259259259259259259259259259259259259259259260e-2 * t32 * t35 * t338 * t46 + 0.49777777777777777777777777777777777777777777777778e-2 * t162 * t343 * t179 + 0.18666666666666666666666666666666666666666666666666e-2 * t162 * t163 * t350 - 0.93333333333333333333333333333333333333333333333332e-3 * t162 * t163 * t373
  t382 = t11 ** 2
  t386 = t33 / t59 / t382 / t19
  t390 = 0.9e1 / 0.8e1 * t312 * t313 * t316 * t317 - t323 * t32 * t324 * t11 / 0.6e1 - t150 * t31 * t331 * t317 / 0.2e1 + t150 * t31 * t153 * t377 / 0.4e1 + 0.2e1 / 0.9e1 * t57 * t386 * t382
  t391 = f.my_piecewise3(t65, t390, 0)
  t406 = t195 ** 2
  t416 = 0.1e1 / t110 / t71
  t431 = -0.2e1 / 0.9e1 * t263 * t391 + 0.18e2 / 0.3515e4 * t260 * t391 - 0.15e2 / 0.2108e4 * t248 * t391 - 0.34e2 / 0.5985e4 * t256 * t391 - 0.26e2 / 0.2835e4 * t240 * t391 + 0.32e2 / 0.5049e4 * t252 * t391 - 0.11e2 / 0.897e3 * t232 * t391 + 0.2e1 / 0.3e1 * t69 * t406 + 0.15e2 / 0.68e2 * t111 * t406 - 0.32e2 / 0.153e3 * t114 * t406 + 0.34e2 / 0.171e3 * t117 * t406 - 0.18e2 / 0.95e2 * t416 * t406 + 0.11e2 / 0.39e2 * t99 * t406 - 0.24e2 / 0.91e2 * t102 * t406 + 0.26e2 / 0.105e3 * t105 * t406 - 0.7e1 / 0.30e2 * t108 * t406 + 0.7e1 / 0.18e2 * t87 * t406 - 0.16e2 / 0.45e2 * t90 * t406
  t458 = t220 * t391
  t468 = 0.18e2 / 0.55e2 * t93 * t406 - 0.10e2 / 0.33e2 * t96 * t406 - 0.2e1 / 0.3e1 * t72 * t406 + 0.3e1 / 0.5e1 * t75 * t406 - 0.8e1 / 0.15e2 * t78 * t406 + 0.10e2 / 0.21e2 * t81 * t406 - 0.3e1 / 0.7e1 * t84 * t406 - 0.3e1 / 0.35e2 * t200 * t391 + 0.8e1 / 0.135e3 * t204 * t391 + 0.2e1 / 0.15e2 * t145 * t391 - 0.10e2 / 0.231e3 * t208 * t391 + 0.3e1 / 0.91e2 * t212 * t391 - 0.7e1 / 0.270e3 * t216 * t391 + 0.16e2 / 0.765e3 * t458 + 0.10e2 / 0.693e3 * t228 * t391 + 0.24e2 / 0.2275e4 * t236 * t391 - 0.18e2 / 0.1045e4 * t224 * t391 + 0.7e1 / 0.870e3 * t244 * t391
  t470 = f.my_piecewise3(t65, 0, t390)
  t475 = t267 ** 2
  t476 = t277 * t475
  t479 = t126 * t470
  t481 = t124 ** 2
  t483 = 0.1e1 / t481 / t122
  t485 = t127 ** 2
  t486 = 0.1e1 / t485
  t501 = 0.1e1 / t481
  t502 = t125 * t501
  t503 = t475 * t270
  t506 = t470 * t270
  t510 = 0.1e1 / t481 / t124
  t511 = t125 * t510
  t512 = t475 * t486
  t515 = -0.2e1 * t122 * t470 * t128 + 0.8e1 * t126 * t475 * t270 - 0.2e1 * t475 * t128 + 0.2e1 * t278 * t506 - 0.6e1 * t502 * t503 + 0.4e1 * t511 * t512
  t518 = 0.2e1 * t476 * t270 - t479 * t270 - 0.2e1 * t483 * t475 * t486 + t470 * t130 / 0.4e1 + t267 * t282 / 0.2e1 + t122 * t515 / 0.4e1
  t522 = f.my_piecewise3(t64, t431 + t468, -0.8e1 / 0.3e1 * t470 * t133 - 0.16e2 / 0.3e1 * t267 * t285 - 0.8e1 / 0.3e1 * t122 * t518)
  t523 = t298 * t522
  t527 = t298 * t289
  t531 = t298 * t137
  t550 = t72 * t195
  t574 = 0.26e2 / 0.35e2 * t105 * t195 * t391 + 0.9e1 / 0.5e1 * t75 * t195 * t391 + 0.34e2 / 0.57e2 * t117 * t391 * t195 + 0.7e1 / 0.6e1 * t87 * t391 * t195 - 0.32e2 / 0.51e2 * t114 * t195 * t391 - 0.2e1 * t550 * t391 + 0.45e2 / 0.68e2 * t111 * t195 * t391 - 0.8e1 / 0.5e1 * t78 * t195 * t391 - 0.7e1 / 0.10e2 * t108 * t391 * t195 - 0.10e2 / 0.11e2 * t96 * t391 * t195 + 0.54e2 / 0.55e2 * t93 * t391 * t195 + 0.10e2 / 0.7e1 * t81 * t195 * t391 - 0.54e2 / 0.95e2 * t416 * t391 * t195
  t590 = t406 * t195
  t599 = t299 ** 2
  t604 = f.p.cam_omega / t55 / t599 / t330 / 0.36e2
  t605 = t604 * t33
  t606 = t60 * t599
  t608 = 0.1e1 / t314 / t151
  t609 = t317 * t183
  t615 = t310 * t190 * t299
  t616 = t313 * t303
  t617 = t315 * t317
  t623 = 0.1e1 / t314 / t51
  t629 = t315 * t183
  t635 = t148 * t386 * jnp.pi
  t640 = t330 * t317
  t645 = t152 * t377
  t655 = t330 * t183
  t660 = t336 * r0
  t662 = 0.1e1 / t21 / t660
  t667 = t34 * t338
  t677 = t164 ** 2
  t678 = 0.1e1 / t677
  t680 = t678 * t349 * t178
  t684 = t348 * t178
  t685 = t684 * t372
  t697 = t336 ** 2
  t703 = t362 * s0
  t707 = t172 ** 2
  t709 = 0.1e1 / t173 / t707
  t712 = -0.26133333333333333333333333333333333333333333333333e0 * t37 / t20 / t336 * t41 - 0.88853333333333333333333333333333333333333333333333e0 * t35 * t662 * t174 + 0.11050666666666666666666666666666666666666666666667e1 * t363 / t20 / t697 * t368 - 0.71680000000000000000000000000000000000000000000000e0 * t703 / t697 / t154 * t709
  t713 = t165 * t712
  t717 = -0.42587654320987654320987654320987654320987654320988e-1 * t32 * t35 * t662 * t46 - 0.27377777777777777777777777777777777777777777777778e-1 * t162 * t667 * t179 - 0.14933333333333333333333333333333333333333333333333e-1 * t162 * t343 * t350 + 0.74666666666666666666666666666666666666666666666667e-2 * t162 * t343 * t373 - 0.55999999999999999999999999999999999999999999999998e-2 * t162 * t163 * t680 + 0.55999999999999999999999999999999999999999999999998e-2 * t162 * t163 * t685 - 0.93333333333333333333333333333333333333333333333332e-3 * t162 * t163 * t713
  t722 = t382 * t11
  t726 = t33 / t59 / t722 / t154
  t730 = 0.135e3 / 0.4e1 * t605 * t606 * t608 * t609 - 0.9e1 / 0.8e1 * t615 * t616 * t617 * t11 - 0.27e2 / 0.4e1 * t312 * t313 * t303 * t623 * t609 + 0.27e2 / 0.8e1 * t312 * t616 * t629 * t377 + t635 * t32 * t324 * t382 / 0.3e1 + t323 * t32 * t640 * t11 / 0.2e1 - t323 * t32 * t645 * t11 / 0.4e1 + 0.3e1 / 0.2e1 * t150 * t31 * t29 * t315 * t609 - 0.3e1 / 0.2e1 * t150 * t32 * t655 * t377 + t150 * t31 * t153 * t717 / 0.4e1 - 0.14e2 / 0.27e2 * t57 * t726 * t722
  t731 = f.my_piecewise3(t65, t730, 0)
  t742 = 0.2e1 * t69 * t391 * t195 - 0.9e1 / 0.7e1 * t84 * t195 * t391 + 0.11e2 / 0.13e2 * t99 * t195 * t391 - 0.16e2 / 0.15e2 * t90 * t195 * t391 - 0.72e2 / 0.91e2 * t102 * t195 * t391 - 0.120e3 / 0.17e2 * t252 * t590 - 0.136e3 / 0.19e2 * t260 * t590 - 0.56e2 / 0.9e1 * t220 * t590 + 0.6e1 * t216 * t590 - 0.2e1 / 0.9e1 * t263 * t731 - 0.11e2 / 0.897e3 * t232 * t731 + 0.64e2 / 0.9e1 * t256 * t590 + 0.48e2 / 0.7e1 * t240 * t590 + 0.20e2 / 0.3e1 * t232 * t590
  t770 = 0.24e2 / 0.2275e4 * t236 * t731 + 0.7e1 / 0.870e3 * t244 * t731 - 0.18e2 / 0.1045e4 * t224 * t731 - 0.104e3 / 0.15e2 * t244 * t590 + 0.18e2 / 0.3515e4 * t260 * t731 - 0.24e2 / 0.5e1 * t204 * t590 - 0.88e2 / 0.13e2 * t236 * t590 + 0.32e2 / 0.5e1 * t224 * t590 - 0.72e2 / 0.11e2 * t228 * t590 - 0.26e2 / 0.2835e4 * t240 * t731 - 0.8e1 / 0.3e1 * t145 * t590 + 0.4e1 * t200 * t590 + 0.2e1 / 0.15e2 * t145 * t731
  t794 = 0.1e1 / t110 / t199
  t801 = 0.10e2 / 0.693e3 * t228 * t731 - 0.7e1 / 0.270e3 * t216 * t731 + 0.16e2 / 0.3e1 * t208 * t590 - 0.10e2 / 0.231e3 * t208 * t731 - 0.3e1 / 0.35e2 * t200 * t731 + 0.8e1 / 0.135e3 * t204 * t731 + 0.32e2 / 0.5049e4 * t252 * t731 + 0.3e1 / 0.91e2 * t212 * t731 - 0.40e2 / 0.7e1 * t212 * t590 - 0.34e2 / 0.5985e4 * t256 * t731 + 0.16e2 / 0.765e3 * t220 * t731 + 0.36e2 / 0.5e1 * t794 * t590 + 0.7e1 * t248 * t590 - 0.15e2 / 0.2108e4 * t248 * t731
  t804 = f.my_piecewise3(t65, 0, t730)
  t811 = t475 * t267
  t815 = t277 * t267
  t821 = t126 * t804
  t823 = t483 * t470
  t824 = t486 * t267
  t827 = t481 ** 2
  t828 = 0.1e1 / t827
  t831 = 0.1e1 / t485 / t127
  t840 = t267 * t128
  t854 = t125 * t483
  t862 = 0.1e1 / t481 / t276
  t863 = t125 * t862
  t867 = t804 * t270
  t870 = t470 * t486
  t875 = 0.1e1 / t827 / t122
  t876 = t125 * t875
  t880 = -0.2e1 * t122 * t804 * t128 + 0.12e2 * t511 * t870 * t267 - 0.24e2 * t811 * t277 * t270 + 0.24e2 * t854 * t811 * t270 - 0.18e2 * t502 * t279 * t470 + 0.24e2 * t483 * t811 * t486 - 0.36e2 * t863 * t811 * t486 + 0.16e2 * t876 * t811 * t831 + 0.2e1 * t278 * t867 + 0.24e2 * t479 * t279 - 0.6e1 * t840 * t470
  t883 = -0.6e1 * t501 * t811 * t270 + 0.6e1 * t815 * t506 + 0.14e2 * t510 * t811 * t486 - t821 * t270 - 0.6e1 * t823 * t824 - 0.8e1 * t828 * t811 * t831 + t804 * t130 / 0.4e1 + 0.3e1 / 0.4e1 * t470 * t282 + 0.3e1 / 0.4e1 * t267 * t515 + t122 * t880 / 0.4e1
  t887 = f.my_piecewise3(t64, t574 + t742 + t770 + t801, -0.8e1 / 0.3e1 * t804 * t133 - 0.8e1 * t470 * t285 - 0.8e1 * t267 * t518 - 0.8e1 / 0.3e1 * t122 * t883)
  t888 = t20 * t887
  t892 = t20 * t522
  t896 = t20 * t289
  t900 = t20 * t137
  t905 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t138 * t51 + t18 * t290 * t51 / 0.4e1 + t18 * t294 * t183 / 0.4e1 - 0.3e1 / 0.8e1 * t18 * t523 * t51 - 0.3e1 / 0.4e1 * t18 * t527 * t183 - 0.3e1 / 0.8e1 * t18 * t531 * t377 - 0.3e1 / 0.8e1 * t18 * t888 * t51 - 0.9e1 / 0.8e1 * t18 * t892 * t183 - 0.9e1 / 0.8e1 * t18 * t896 * t377 - 0.3e1 / 0.8e1 * t18 * t900 * t717)
  t941 = -0.112e3 / 0.3e1 * t458 * t406 + 0.40e2 * t232 * t406 * t391 - 0.528e3 / 0.13e2 * t236 * t406 * t391 - 0.12e2 / 0.7e1 * t84 * t731 * t195 - 0.8e1 / 0.3e1 * t550 * t731 + 0.192e3 / 0.5e1 * t224 * t406 * t391 - 0.144e3 / 0.5e1 * t204 * t406 * t391 + 0.288e3 / 0.7e1 * t240 * t406 * t391 - 0.240e3 / 0.7e1 * t212 * t406 * t391 + 0.8e1 / 0.3e1 * t69 * t731 * t195 - 0.72e2 / 0.95e2 * t416 * t731 * t195
  t975 = 0.24e2 * t200 * t406 * t391 + 0.32e2 * t208 * t406 * t391 - 0.96e2 / 0.91e2 * t102 * t731 * t195 - 0.720e3 / 0.17e2 * t252 * t406 * t391 - 0.32e2 / 0.15e2 * t78 * t731 * t195 + 0.72e2 / 0.55e2 * t93 * t731 * t195 + 0.15e2 / 0.17e2 * t111 * t731 * t195 - 0.64e2 / 0.45e2 * t90 * t731 * t195 - 0.16e2 * t145 * t406 * t391 - 0.816e3 / 0.19e2 * t260 * t406 * t391 - 0.208e3 / 0.5e1 * t244 * t406 * t391
  t1010 = 0.40e2 / 0.21e2 * t81 * t731 * t195 + 0.42e2 * t248 * t406 * t391 - 0.14e2 / 0.15e2 * t108 * t731 * t195 + 0.12e2 / 0.5e1 * t75 * t731 * t195 + 0.44e2 / 0.39e2 * t99 * t731 * t195 + 0.128e3 / 0.3e1 * t256 * t406 * t391 + 0.14e2 / 0.9e1 * t87 * t731 * t195 + 0.104e3 / 0.105e3 * t105 * t731 * t195 + 0.216e3 / 0.5e1 * t794 * t406 * t391 - 0.40e2 / 0.33e2 * t96 * t731 * t195 - 0.128e3 / 0.153e3 * t114 * t731 * t195
  t1021 = t599 * t608
  t1028 = t317 ** 2
  t1049 = t183 * t11 * t377
  t1066 = t314 ** 2
  t1072 = t382 ** 2
  t1080 = t336 * t19
  t1082 = 0.1e1 / t21 / t1080
  t1108 = t349 ** 2
  t1118 = t372 ** 2
  t1146 = t362 ** 2
  t1162 = 0.24133004115226337448559670781893004115226337448560e0 * t32 * t35 * t1082 * t46 + 0.17035061728395061728395061728395061728395061728395e0 * t162 * t34 * t662 * t179 + 0.10951111111111111111111111111111111111111111111111e0 * t162 * t667 * t350 - 0.54755555555555555555555555555555555555555555555556e-1 * t162 * t667 * t373 + 0.59733333333333333333333333333333333333333333333332e-1 * t162 * t343 * t680 - 0.59733333333333333333333333333333333333333333333332e-1 * t162 * t343 * t685 + 0.99555555555555555555555555555555555555555555555556e-2 * t162 * t343 * t713 + 0.22399999999999999999999999999999999999999999999999e-1 * t162 * t163 / t677 / t45 * t1108 - 0.33599999999999999999999999999999999999999999999998e-1 * t162 * t163 * t678 * t349 * t372 + 0.55999999999999999999999999999999999999999999999998e-2 * t162 * t163 * t348 * t1118 + 0.74666666666666666666666666666666666666666666666664e-2 * t162 * t163 * t684 * t712 - 0.93333333333333333333333333333333333333333333333332e-3 * t162 * t163 * t165 * (0.11324444444444444444444444444444444444444444444444e1 * t37 / t20 / t660 * t41 + 0.53834666666666666666666666666666666666666666666666e1 * t35 * t1082 * t174 - 0.11578311111111111111111111111111111111111111111111e2 * t363 / t20 / t697 / r0 * t368 + 0.16725333333333333333333333333333333333333333333334e2 * t703 / t697 / t336 * t709 - 0.47786666666666666666666666666666666666666666666667e1 * t1146 / t21 / t697 / t1080 / t173 / t707 / t172 * t34)
  t1181 = -0.45e2 * t604 * t190 * t1021 * t609 * t11 - 0.405e3 * t605 * t606 / t314 / t329 * t1028 + 0.405e3 / 0.2e1 * t604 * t61 * t1021 * t317 * t377 - 0.2e1 * t323 * t32 * t315 * t609 * t11 + 0.2e1 * t148 * t33 * t189 * jnp.pi * t24 * t30 * t330 * t1049 + 0.105e3 / 0.32e2 * f.p.cam_omega / t55 / t24 * t27 * t26 / t29 / t315 * t61 * jnp.pi / t1066 * t1028 * t32 + 0.140e3 / 0.81e2 * t57 * t33 / t59 / t336 + t150 * t31 * t153 * t1162 / 0.4e1 - t323 * t32 * t152 * t717 * t11 / 0.3e1 - 0.6e1 * t150 * t31 * t29 * t623 * t1028 + 0.9e1 * t150 * t32 * t617 * t377
  t1182 = t377 ** 2
  t1242 = -0.3e1 / 0.2e1 * t150 * t31 * t331 * t1182 - 0.2e1 * t150 * t32 * t655 * t717 + 0.3e1 * t310 * t386 * t299 * t616 * t617 * t382 + 0.9e1 * t615 * t616 * t623 * t609 * t11 - 0.9e1 / 0.2e1 * t310 * t33 * t189 * t299 * t3 * t304 * t315 * t1049 - 0.28e2 / 0.27e2 * t148 * t726 * jnp.pi * t32 * t324 * t722 - 0.4e1 / 0.3e1 * t635 * t32 * t640 * t382 + 0.81e2 / 0.2e1 * t312 * t313 * t303 * t608 * t1028 - 0.81e2 / 0.2e1 * t312 * t616 * t623 * t317 * t377 + 0.27e2 / 0.8e1 * t312 * t313 * t316 * t1182 + 0.9e1 / 0.2e1 * t312 * t616 * t629 * t717 + 0.2e1 / 0.3e1 * t635 * t32 * t645 * t382
  t1243 = t1181 + t1242
  t1244 = f.my_piecewise3(t65, t1243, 0)
  t1247 = t406 ** 2
  t1250 = t391 ** 2
  t1265 = -0.432e3 / 0.11e2 * t228 * t406 * t391 + 0.136e3 / 0.171e3 * t117 * t731 * t195 + 0.36e2 * t216 * t406 * t391 + 0.24e2 / 0.2275e4 * t236 * t1244 + 0.216e3 / 0.5e1 * t78 * t1247 + 0.11e2 / 0.13e2 * t99 * t1250 + 0.2200e4 / 0.13e2 * t102 * t1247 + 0.2e1 * t69 * t1250 - 0.34e2 / 0.5985e4 * t256 * t1244 + 0.10e2 / 0.7e1 * t81 * t1250 - 0.176e3 / 0.3e1 * t81 * t1247 + 0.7e1 / 0.870e3 * t244 * t1244
  t1292 = -0.18e2 / 0.1045e4 * t224 * t1244 - 0.2240e4 / 0.9e1 * t117 * t1247 + 0.952e3 / 0.9e1 * t90 * t1247 + 0.3960e4 / 0.17e2 * t114 * t1247 - 0.9e1 / 0.7e1 * t84 * t1250 + 0.32e2 / 0.5049e4 * t252 * t1244 - 0.1404e4 / 0.5e1 / t110 / t74 * t1247 + 0.34e2 / 0.57e2 * t117 * t1250 + 0.9e1 / 0.5e1 * t75 * t1250 - 0.2e1 / 0.9e1 * t263 * t1244 + 0.7e1 / 0.6e1 * t87 * t1250
  t1315 = 0.40e2 / 0.3e1 * t72 * t1247 + 0.3e1 / 0.91e2 * t212 * t1244 + 0.10e2 / 0.693e3 * t228 * t1244 + 0.26e2 / 0.35e2 * t105 * t1250 + 0.54e2 / 0.55e2 * t93 * t1250 - 0.7e1 / 0.270e3 * t216 * t1244 - 0.90e2 * t87 * t1247 + 0.8e1 / 0.135e3 * t204 * t1244 - 0.2e1 * t72 * t1250 - 0.72e2 / 0.91e2 * t102 * t1250 + 0.3016e4 / 0.15e2 * t108 * t1247
  t1339 = -0.217e3 * t111 * t1247 + 0.1512e4 / 0.11e2 * t96 * t1247 - 0.7e1 / 0.10e2 * t108 * t1250 + 0.2e1 / 0.15e2 * t145 * t1244 - 0.26e2 / 0.2835e4 * t240 * t1244 - 0.11e2 / 0.897e3 * t232 * t1244 - 0.1296e4 / 0.7e1 * t105 * t1247 - 0.608e3 / 0.5e1 * t93 * t1247 - 0.28e2 * t75 * t1247 + 0.18e2 / 0.3515e4 * t260 * t1244 - 0.10e2 / 0.231e3 * t208 * t1244
  t1364 = -0.16e2 / 0.15e2 * t90 * t1250 - 0.3e1 / 0.35e2 * t200 * t1244 + 0.45e2 / 0.68e2 * t111 * t1250 - 0.32e2 / 0.51e2 * t114 * t1250 - 0.54e2 / 0.95e2 * t416 * t1250 - 0.10e2 / 0.11e2 * t96 * t1250 - 0.15e2 / 0.2108e4 * t248 * t1244 + 0.16e2 / 0.765e3 * t220 * t1244 + 0.520e3 / 0.7e1 * t84 * t1247 - 0.460e3 / 0.3e1 * t99 * t1247 + 0.5032e4 / 0.19e2 * t416 * t1247 - 0.8e1 / 0.5e1 * t78 * t1250
  t1368 = f.my_piecewise3(t65, 0, t1243)
  t1377 = t475 ** 2
  t1393 = t470 ** 2
  t1410 = t485 ** 2
  t1411 = 0.1e1 / t1410
  t1446 = 0.96e2 * t125 / t827 / t481 * t1377 * t1411 + 0.128e3 * t828 * t1377 * t831 - 0.6e1 * t1393 * t128 + 0.16e2 * t511 * t804 * t486 * t267 + 0.24e2 * t126 * t1393 * t270 - 0.144e3 * t476 * t506 + 0.12e2 * t511 * t1393 * t486 + 0.300e3 * t125 * t828 * t1377 * t486 + 0.96e2 * t876 * t470 * t831 * t475 - 0.120e3 * t511 * t1377 * t270 + 0.144e3 * t854 * t503 * t470
  t1480 = -0.8e1 * t840 * t804 - 0.216e3 * t863 * t512 * t470 + 0.32e2 * t821 * t279 - 0.24e2 * t502 * t279 * t804 - 0.240e3 * t1377 * t510 * t486 - 0.2e1 * t122 * t1368 * t128 + 0.120e3 * t1377 * t501 * t270 + 0.144e3 * t823 * t512 + 0.2e1 * t278 * t1368 * t270 - 0.288e3 * t125 / t827 / t124 * t1377 * t831 - 0.18e2 * t502 * t1393 * t270
  t1499 = 0.120e3 * t875 * t1377 * t831 - t126 * t1368 * t270 - 0.8e1 * t483 * t804 * t824 + 0.84e2 * t510 * t475 * t870 + 0.3e1 / 0.2e1 * t470 * t515 + t1368 * t130 / 0.4e1 + 0.6e1 * t277 * t1393 * t270 + 0.8e1 * t815 * t867 - 0.6e1 * t483 * t1393 * t486 - 0.48e2 * t828 * t470 * t831 * t475 + t267 * t880 + t122 * (t1446 + t1480) / 0.4e1 + t804 * t282 - 0.96e2 * t862 * t1377 * t486 - 0.48e2 / t827 / t276 * t1377 * t1411 + 0.24e2 * t483 * t1377 * t270 - 0.36e2 * t501 * t475 * t506
  t1503 = f.my_piecewise3(t64, t941 + t975 + t1010 + t1265 + t1292 + t1315 + t1339 + t1364, -0.8e1 / 0.3e1 * t1368 * t133 - 0.32e2 / 0.3e1 * t804 * t285 - 0.16e2 * t470 * t518 - 0.32e2 / 0.3e1 * t267 * t883 - 0.8e1 / 0.3e1 * t122 * t1499)
  t1550 = -0.9e1 / 0.4e1 * t18 * t892 * t377 - 0.3e1 / 0.8e1 * t18 * t20 * t1503 * t51 + t18 * t290 * t183 - 0.3e1 / 0.2e1 * t18 * t523 * t183 - 0.3e1 / 0.2e1 * t18 * t896 * t717 - 0.3e1 / 0.8e1 * t18 * t900 * t1162 - 0.5e1 / 0.9e1 * t18 * t23 * t289 * t51 + 0.10e2 / 0.27e2 * t18 * t156 * t137 * t51 + t18 * t294 * t377 / 0.2e1 - t18 * t298 * t887 * t51 / 0.2e1 - 0.3e1 / 0.2e1 * t18 * t888 * t183 - t18 * t531 * t717 / 0.2e1 - 0.5e1 / 0.9e1 * t18 * t138 * t183 + t18 * t143 * t522 * t51 / 0.2e1 - 0.3e1 / 0.2e1 * t18 * t527 * t377
  t1551 = f.my_piecewise3(t2, 0, t1550)
  v4rho4_0_ = 0.2e1 * r0 * t1551 + 0.8e1 * t905

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t32 = t24 * t6
  t33 = 0.1e1 / t32
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t5 * t41
  t43 = t6 ** (0.1e1 / 0.3e1)
  t44 = t2 ** 2
  t45 = jnp.pi * t44
  t47 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t48 = 0.1e1 / t47
  t49 = 4 ** (0.1e1 / 0.3e1)
  t50 = t48 * t49
  t51 = t44 * t48
  t52 = t51 * t49
  t53 = r0 ** 2
  t54 = r0 ** (0.1e1 / 0.3e1)
  t55 = t54 ** 2
  t57 = 0.1e1 / t55 / t53
  t58 = s0 * t57
  t59 = jnp.sqrt(s0)
  t62 = t59 / t54 / r0
  t63 = jnp.asinh(t62)
  t66 = 0.1e1 + 0.2520e-1 * t62 * t63
  t67 = 0.1e1 / t66
  t71 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t52 * t58 * t67
  t74 = t45 * t50 / t71
  t75 = jnp.sqrt(t74)
  t77 = f.p.cam_omega / t75
  t78 = 2 ** (0.1e1 / 0.3e1)
  t79 = t19 * t6
  t80 = t79 ** (0.1e1 / 0.3e1)
  t81 = 0.1e1 / t80
  t82 = t78 * t81
  t84 = t77 * t82 / 0.2e1
  t85 = 0.192e1 <= t84
  t86 = 0.192e1 < t84
  t87 = f.my_piecewise3(t86, t84, 0.192e1)
  t88 = t87 ** 2
  t89 = t88 ** 2
  t90 = t89 ** 2
  t91 = t90 ** 2
  t93 = 0.1e1 / t91 / t88
  t96 = 0.1e1 / t91 / t89
  t98 = t89 * t88
  t100 = 0.1e1 / t91 / t98
  t103 = 0.1e1 / t91 / t90
  t105 = t90 * t88
  t107 = 0.1e1 / t91 / t105
  t109 = t90 * t89
  t111 = 0.1e1 / t91 / t109
  t113 = t90 * t98
  t115 = 0.1e1 / t91 / t113
  t117 = t91 ** 2
  t118 = 0.1e1 / t117
  t121 = 0.1e1 / t117 / t88
  t124 = 0.1e1 / t117 / t89
  t126 = 0.1e1 / t89
  t128 = 0.1e1 / t98
  t130 = 0.1e1 / t90
  t132 = 0.1e1 / t105
  t134 = 0.1e1 / t109
  t136 = 0.1e1 / t113
  t138 = 0.1e1 / t91
  t142 = t93 / 0.1045e4 - t96 / 0.1386e4 + t100 / 0.1794e4 - t103 / 0.2275e4 + t107 / 0.2835e4 - t111 / 0.3480e4 + t115 / 0.4216e4 - t118 / 0.5049e4 + t121 / 0.5985e4 - t124 / 0.7030e4 - t126 / 0.30e2 + t128 / 0.70e2 - t130 / 0.135e3 + t132 / 0.231e3 - t134 / 0.364e3 + t136 / 0.540e3 - t138 / 0.765e3 + 0.1e1 / t88 / 0.9e1
  t143 = f.my_piecewise3(t86, 0.192e1, t84)
  t144 = jnp.atan2(0.1e1, t143)
  t145 = t143 ** 2
  t146 = t145 + 0.3e1
  t147 = 0.1e1 / t145
  t148 = 0.1e1 + t147
  t149 = jnp.log(t148)
  t151 = -t146 * t149 + 0.1e1
  t154 = t144 + t143 * t151 / 0.4e1
  t158 = f.my_piecewise3(t85, t142, 0.1e1 - 0.8e1 / 0.3e1 * t143 * t154)
  t159 = t43 * t158
  t160 = t159 * t71
  t165 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t166 = t5 * t165
  t167 = t43 ** 2
  t168 = 0.1e1 / t167
  t169 = t168 * t158
  t170 = t169 * t71
  t173 = t88 * t87
  t175 = 0.1e1 / t91 / t173
  t178 = f.p.cam_omega / t75 / t74
  t180 = t178 * t82 * jnp.pi
  t181 = t71 ** 2
  t182 = 0.1e1 / t181
  t183 = t49 * t182
  t184 = t53 * r0
  t187 = s0 / t55 / t184
  t191 = t66 ** 2
  t192 = 0.1e1 / t191
  t198 = t58 + 0.1e1
  t199 = jnp.sqrt(t198)
  t200 = 0.1e1 / t199
  t203 = -0.33600000000000000000000000000000000000000000000000e-1 * t59 / t54 / t53 * t63 - 0.33600000000000000000000000000000000000000000000000e-1 * t187 * t200
  t204 = t192 * t203
  t208 = -0.24888888888888888888888888888888888888888888888889e-2 * t52 * t187 * t67 - 0.93333333333333333333333333333333333333333333333332e-3 * t52 * t58 * t204
  t215 = t78 / t80 / t79
  t217 = t28 * t6 + t18 + 0.1e1
  t221 = t180 * t51 * t183 * t208 / 0.4e1 - t77 * t215 * t217 / 0.6e1
  t222 = f.my_piecewise3(t86, t221, 0)
  t225 = t89 * t87
  t227 = 0.1e1 / t91 / t225
  t230 = t89 * t173
  t232 = 0.1e1 / t91 / t230
  t235 = t90 * t87
  t237 = 0.1e1 / t91 / t235
  t240 = t90 * t173
  t242 = 0.1e1 / t91 / t240
  t245 = t90 * t225
  t247 = 0.1e1 / t91 / t245
  t250 = t90 * t230
  t252 = 0.1e1 / t91 / t250
  t256 = 0.1e1 / t117 / t87
  t260 = 0.1e1 / t117 / t173
  t264 = 0.1e1 / t117 / t225
  t267 = 0.1e1 / t225
  t270 = 0.1e1 / t230
  t273 = 0.1e1 / t235
  t276 = 0.1e1 / t240
  t279 = 0.1e1 / t245
  t282 = 0.1e1 / t250
  t286 = 0.1e1 / t91 / t87
  t289 = 0.1e1 / t173
  t292 = -0.18e2 / 0.1045e4 * t175 * t222 + 0.10e2 / 0.693e3 * t227 * t222 - 0.11e2 / 0.897e3 * t232 * t222 + 0.24e2 / 0.2275e4 * t237 * t222 - 0.26e2 / 0.2835e4 * t242 * t222 + 0.7e1 / 0.870e3 * t247 * t222 - 0.15e2 / 0.2108e4 * t252 * t222 + 0.32e2 / 0.5049e4 * t256 * t222 - 0.34e2 / 0.5985e4 * t260 * t222 + 0.18e2 / 0.3515e4 * t264 * t222 + 0.2e1 / 0.15e2 * t267 * t222 - 0.3e1 / 0.35e2 * t270 * t222 + 0.8e1 / 0.135e3 * t273 * t222 - 0.10e2 / 0.231e3 * t276 * t222 + 0.3e1 / 0.91e2 * t279 * t222 - 0.7e1 / 0.270e3 * t282 * t222 + 0.16e2 / 0.765e3 * t286 * t222 - 0.2e1 / 0.9e1 * t289 * t222
  t293 = f.my_piecewise3(t86, 0, t221)
  t296 = 0.1e1 / t148
  t302 = t145 * t143
  t303 = 0.1e1 / t302
  t304 = t146 * t303
  t305 = t293 * t296
  t308 = -0.2e1 * t143 * t293 * t149 + 0.2e1 * t304 * t305
  t311 = -t147 * t293 * t296 + t293 * t151 / 0.4e1 + t143 * t308 / 0.4e1
  t315 = f.my_piecewise3(t85, t292, -0.8e1 / 0.3e1 * t143 * t311 - 0.8e1 / 0.3e1 * t293 * t154)
  t316 = t43 * t315
  t317 = t316 * t71
  t320 = t159 * t208
  t323 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t324 = t323 * f.p.zeta_threshold
  t326 = f.my_piecewise3(t20, t324, t21 * t19)
  t327 = t5 * t326
  t329 = 0.1e1 / t167 / t6
  t330 = t329 * t158
  t331 = t330 * t71
  t334 = t168 * t315
  t335 = t334 * t71
  t338 = t169 * t208
  t341 = jnp.pi ** 2
  t343 = t47 ** 2
  t344 = 0.1e1 / t343
  t345 = t49 ** 2
  t352 = f.p.cam_omega / t75 / t341 / t2 / t344 / t345 / t182 / 0.3e1
  t354 = t352 * t82 * t341
  t355 = t2 * t344
  t356 = t181 ** 2
  t357 = 0.1e1 / t356
  t359 = t208 ** 2
  t365 = t178 * t215 * jnp.pi
  t366 = t182 * t208
  t372 = 0.1e1 / t181 / t71
  t378 = t53 ** 2
  t381 = s0 / t55 / t378
  t389 = 0.1e1 / t191 / t66
  t390 = t203 ** 2
  t391 = t389 * t390
  t402 = s0 ** 2
  t408 = 0.1e1 / t199 / t198
  t411 = 0.78400000000000000000000000000000000000000000000000e-1 * t59 / t54 / t184 * t63 + 0.16800000000000000000000000000000000000000000000000e0 * t381 * t200 - 0.44800000000000000000000000000000000000000000000000e-1 * t402 / t54 / t378 / t184 * t408
  t412 = t192 * t411
  t416 = 0.91259259259259259259259259259259259259259259259260e-2 * t52 * t381 * t67 + 0.49777777777777777777777777777777777777777777777778e-2 * t52 * t187 * t204 + 0.18666666666666666666666666666666666666666666666666e-2 * t52 * t58 * t391 - 0.93333333333333333333333333333333333333333333333332e-3 * t52 * t58 * t412
  t421 = t19 ** 2
  t424 = 0.1e1 / t80 / t421 / t24
  t425 = t78 * t424
  t426 = t217 ** 2
  t432 = t37 * t6 + 0.2e1 * t28
  t436 = 0.9e1 / 0.8e1 * t354 * t355 * t345 * t357 * t359 - t365 * t52 * t366 * t217 / 0.6e1 - t180 * t51 * t49 * t372 * t359 / 0.2e1 + t180 * t51 * t183 * t416 / 0.4e1 + 0.2e1 / 0.9e1 * t77 * t425 * t426 - t77 * t215 * t432 / 0.6e1
  t437 = f.my_piecewise3(t86, t436, 0)
  t440 = t222 ** 2
  t474 = 0.1e1 / t117 / t98
  t477 = -0.7e1 / 0.270e3 * t282 * t437 + 0.7e1 / 0.18e2 * t138 * t440 + 0.18e2 / 0.55e2 * t96 * t440 - 0.2e1 / 0.9e1 * t289 * t437 - 0.16e2 / 0.45e2 * t93 * t440 + 0.11e2 / 0.39e2 * t103 * t440 + 0.26e2 / 0.105e3 * t111 * t440 + 0.16e2 / 0.765e3 * t286 * t437 + 0.3e1 / 0.91e2 * t279 * t437 + 0.7e1 / 0.870e3 * t247 * t437 - 0.15e2 / 0.2108e4 * t252 * t437 + 0.32e2 / 0.5049e4 * t256 * t437 + 0.3e1 / 0.5e1 * t130 * t440 - 0.2e1 / 0.3e1 * t128 * t440 - 0.34e2 / 0.5985e4 * t260 * t437 - 0.7e1 / 0.30e2 * t115 * t440 + 0.2e1 / 0.3e1 * t126 * t440 - 0.18e2 / 0.95e2 * t474 * t440
  t514 = 0.34e2 / 0.171e3 * t124 * t440 + 0.10e2 / 0.21e2 * t134 * t440 - 0.8e1 / 0.15e2 * t132 * t440 - 0.24e2 / 0.91e2 * t107 * t440 + 0.2e1 / 0.15e2 * t267 * t437 + 0.8e1 / 0.135e3 * t273 * t437 + 0.15e2 / 0.68e2 * t118 * t440 + 0.18e2 / 0.3515e4 * t264 * t437 - 0.32e2 / 0.153e3 * t121 * t440 - 0.3e1 / 0.7e1 * t136 * t440 - 0.3e1 / 0.35e2 * t270 * t437 + 0.10e2 / 0.693e3 * t227 * t437 - 0.18e2 / 0.1045e4 * t175 * t437 - 0.10e2 / 0.231e3 * t276 * t437 + 0.24e2 / 0.2275e4 * t237 * t437 - 0.10e2 / 0.33e2 * t100 * t440 - 0.11e2 / 0.897e3 * t232 * t437 - 0.26e2 / 0.2835e4 * t242 * t437
  t516 = f.my_piecewise3(t86, 0, t436)
  t521 = t293 ** 2
  t525 = t147 * t516
  t527 = t145 ** 2
  t529 = 0.1e1 / t527 / t143
  t531 = t148 ** 2
  t532 = 0.1e1 / t531
  t547 = 0.1e1 / t527
  t548 = t146 * t547
  t552 = t516 * t296
  t556 = 0.1e1 / t527 / t145
  t557 = t146 * t556
  t561 = -0.2e1 * t143 * t516 * t149 + 0.8e1 * t147 * t521 * t296 - 0.6e1 * t548 * t521 * t296 + 0.4e1 * t557 * t521 * t532 - 0.2e1 * t521 * t149 + 0.2e1 * t304 * t552
  t564 = 0.2e1 * t303 * t521 * t296 - t525 * t296 - 0.2e1 * t529 * t521 * t532 + t516 * t151 / 0.4e1 + t293 * t308 / 0.2e1 + t143 * t561 / 0.4e1
  t568 = f.my_piecewise3(t85, t477 + t514, -0.8e1 / 0.3e1 * t516 * t154 - 0.16e2 / 0.3e1 * t293 * t311 - 0.8e1 / 0.3e1 * t143 * t564)
  t569 = t43 * t568
  t570 = t569 * t71
  t573 = t316 * t208
  t576 = t159 * t416
  t580 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t42 * t160 - t166 * t170 / 0.4e1 - 0.3e1 / 0.4e1 * t166 * t317 - 0.3e1 / 0.4e1 * t166 * t320 + t327 * t331 / 0.12e2 - t327 * t335 / 0.4e1 - t327 * t338 / 0.4e1 - 0.3e1 / 0.8e1 * t327 * t570 - 0.3e1 / 0.4e1 * t327 * t573 - 0.3e1 / 0.8e1 * t327 * t576)
  t582 = r1 <= f.p.dens_threshold
  t583 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t584 = 0.1e1 + t583
  t585 = t584 <= f.p.zeta_threshold
  t586 = t584 ** (0.1e1 / 0.3e1)
  t587 = t586 ** 2
  t588 = 0.1e1 / t587
  t590 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t591 = t590 ** 2
  t595 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t599 = f.my_piecewise3(t585, 0, 0.4e1 / 0.9e1 * t588 * t591 + 0.4e1 / 0.3e1 * t586 * t595)
  t600 = t5 * t599
  t601 = r1 ** 2
  t602 = r1 ** (0.1e1 / 0.3e1)
  t603 = t602 ** 2
  t607 = jnp.sqrt(s2)
  t610 = t607 / t602 / r1
  t611 = jnp.asinh(t610)
  t619 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t52 * s2 / t603 / t601 / (0.1e1 + 0.2520e-1 * t610 * t611)
  t623 = jnp.sqrt(t45 * t50 / t619)
  t625 = f.p.cam_omega / t623
  t626 = t584 * t6
  t627 = t626 ** (0.1e1 / 0.3e1)
  t631 = t625 * t78 / t627 / 0.2e1
  t632 = 0.192e1 <= t631
  t633 = 0.192e1 < t631
  t634 = f.my_piecewise3(t633, t631, 0.192e1)
  t635 = t634 ** 2
  t636 = t635 ** 2
  t637 = t636 ** 2
  t638 = t637 ** 2
  t640 = 0.1e1 / t638 / t635
  t643 = 0.1e1 / t638 / t636
  t645 = t636 * t635
  t647 = 0.1e1 / t638 / t645
  t650 = 0.1e1 / t638 / t637
  t652 = t637 * t635
  t654 = 0.1e1 / t638 / t652
  t656 = t637 * t636
  t658 = 0.1e1 / t638 / t656
  t660 = t637 * t645
  t662 = 0.1e1 / t638 / t660
  t664 = t638 ** 2
  t665 = 0.1e1 / t664
  t668 = 0.1e1 / t664 / t635
  t671 = 0.1e1 / t664 / t636
  t673 = 0.1e1 / t636
  t675 = 0.1e1 / t645
  t677 = 0.1e1 / t637
  t679 = 0.1e1 / t652
  t681 = 0.1e1 / t656
  t683 = 0.1e1 / t660
  t685 = 0.1e1 / t638
  t689 = t640 / 0.1045e4 - t643 / 0.1386e4 + t647 / 0.1794e4 - t650 / 0.2275e4 + t654 / 0.2835e4 - t658 / 0.3480e4 + t662 / 0.4216e4 - t665 / 0.5049e4 + t668 / 0.5985e4 - t671 / 0.7030e4 - t673 / 0.30e2 + t675 / 0.70e2 - t677 / 0.135e3 + t679 / 0.231e3 - t681 / 0.364e3 + t683 / 0.540e3 - t685 / 0.765e3 + 0.1e1 / t635 / 0.9e1
  t690 = f.my_piecewise3(t633, 0.192e1, t631)
  t691 = jnp.atan2(0.1e1, t690)
  t692 = t690 ** 2
  t693 = t692 + 0.3e1
  t694 = 0.1e1 / t692
  t695 = 0.1e1 + t694
  t696 = jnp.log(t695)
  t698 = -t693 * t696 + 0.1e1
  t701 = t691 + t690 * t698 / 0.4e1
  t705 = f.my_piecewise3(t632, t689, 0.1e1 - 0.8e1 / 0.3e1 * t690 * t701)
  t707 = t43 * t705 * t619
  t712 = f.my_piecewise3(t585, 0, 0.4e1 / 0.3e1 * t586 * t590)
  t713 = t5 * t712
  t715 = t168 * t705 * t619
  t718 = t635 * t634
  t720 = 0.1e1 / t638 / t718
  t723 = t78 / t627 / t626
  t725 = t590 * t6 + t583 + 0.1e1
  t728 = t625 * t723 * t725 / 0.6e1
  t729 = f.my_piecewise3(t633, -t728, 0)
  t732 = t636 * t634
  t734 = 0.1e1 / t638 / t732
  t737 = t636 * t718
  t739 = 0.1e1 / t638 / t737
  t742 = t637 * t634
  t744 = 0.1e1 / t638 / t742
  t747 = t637 * t718
  t749 = 0.1e1 / t638 / t747
  t752 = t637 * t732
  t754 = 0.1e1 / t638 / t752
  t757 = t637 * t737
  t759 = 0.1e1 / t638 / t757
  t763 = 0.1e1 / t664 / t634
  t767 = 0.1e1 / t664 / t718
  t771 = 0.1e1 / t664 / t732
  t774 = 0.1e1 / t732
  t777 = 0.1e1 / t737
  t780 = 0.1e1 / t742
  t783 = 0.1e1 / t747
  t786 = 0.1e1 / t752
  t789 = 0.1e1 / t757
  t793 = 0.1e1 / t638 / t634
  t796 = 0.1e1 / t718
  t799 = -0.18e2 / 0.1045e4 * t720 * t729 + 0.10e2 / 0.693e3 * t734 * t729 - 0.11e2 / 0.897e3 * t739 * t729 + 0.24e2 / 0.2275e4 * t744 * t729 - 0.26e2 / 0.2835e4 * t749 * t729 + 0.7e1 / 0.870e3 * t754 * t729 - 0.15e2 / 0.2108e4 * t759 * t729 + 0.32e2 / 0.5049e4 * t763 * t729 - 0.34e2 / 0.5985e4 * t767 * t729 + 0.18e2 / 0.3515e4 * t771 * t729 + 0.2e1 / 0.15e2 * t774 * t729 - 0.3e1 / 0.35e2 * t777 * t729 + 0.8e1 / 0.135e3 * t780 * t729 - 0.10e2 / 0.231e3 * t783 * t729 + 0.3e1 / 0.91e2 * t786 * t729 - 0.7e1 / 0.270e3 * t789 * t729 + 0.16e2 / 0.765e3 * t793 * t729 - 0.2e1 / 0.9e1 * t796 * t729
  t800 = f.my_piecewise3(t633, 0, -t728)
  t803 = 0.1e1 / t695
  t809 = t692 * t690
  t810 = 0.1e1 / t809
  t811 = t693 * t810
  t812 = t800 * t803
  t815 = -0.2e1 * t690 * t800 * t696 + 0.2e1 * t811 * t812
  t818 = -t694 * t800 * t803 + t800 * t698 / 0.4e1 + t690 * t815 / 0.4e1
  t822 = f.my_piecewise3(t632, t799, -0.8e1 / 0.3e1 * t690 * t818 - 0.8e1 / 0.3e1 * t800 * t701)
  t824 = t43 * t822 * t619
  t828 = f.my_piecewise3(t585, t324, t586 * t584)
  t829 = t5 * t828
  t831 = t329 * t705 * t619
  t835 = t168 * t822 * t619
  t838 = t729 ** 2
  t843 = t584 ** 2
  t846 = 0.1e1 / t627 / t843 / t24
  t848 = t725 ** 2
  t854 = t595 * t6 + 0.2e1 * t590
  t858 = 0.2e1 / 0.9e1 * t625 * t78 * t846 * t848 - t625 * t723 * t854 / 0.6e1
  t859 = f.my_piecewise3(t633, t858, 0)
  t883 = 0.1e1 / t664 / t645
  t894 = 0.15e2 / 0.68e2 * t665 * t838 - 0.32e2 / 0.153e3 * t668 * t838 + 0.18e2 / 0.3515e4 * t771 * t859 + 0.7e1 / 0.18e2 * t685 * t838 - 0.18e2 / 0.1045e4 * t720 * t859 + 0.10e2 / 0.693e3 * t734 * t859 + 0.10e2 / 0.21e2 * t681 * t838 + 0.18e2 / 0.55e2 * t643 * t838 + 0.16e2 / 0.765e3 * t793 * t859 - 0.7e1 / 0.30e2 * t662 * t838 + 0.3e1 / 0.91e2 * t786 * t859 + 0.2e1 / 0.3e1 * t673 * t838 + 0.34e2 / 0.171e3 * t671 * t838 - 0.18e2 / 0.95e2 * t883 * t838 - 0.2e1 / 0.3e1 * t675 * t838 - 0.3e1 / 0.35e2 * t777 * t859 - 0.34e2 / 0.5985e4 * t767 * t859 + 0.32e2 / 0.5049e4 * t763 * t859
  t931 = 0.3e1 / 0.5e1 * t677 * t838 - 0.26e2 / 0.2835e4 * t749 * t859 + 0.7e1 / 0.870e3 * t754 * t859 - 0.15e2 / 0.2108e4 * t759 * t859 - 0.3e1 / 0.7e1 * t683 * t838 - 0.8e1 / 0.15e2 * t679 * t838 + 0.2e1 / 0.15e2 * t774 * t859 - 0.24e2 / 0.91e2 * t654 * t838 + 0.8e1 / 0.135e3 * t780 * t859 - 0.2e1 / 0.9e1 * t796 * t859 - 0.10e2 / 0.33e2 * t647 * t838 - 0.16e2 / 0.45e2 * t640 * t838 - 0.11e2 / 0.897e3 * t739 * t859 - 0.10e2 / 0.231e3 * t783 * t859 + 0.26e2 / 0.105e3 * t658 * t838 + 0.11e2 / 0.39e2 * t650 * t838 - 0.7e1 / 0.270e3 * t789 * t859 + 0.24e2 / 0.2275e4 * t744 * t859
  t933 = f.my_piecewise3(t633, 0, t858)
  t938 = t800 ** 2
  t942 = t694 * t933
  t944 = t692 ** 2
  t946 = 0.1e1 / t944 / t690
  t948 = t695 ** 2
  t949 = 0.1e1 / t948
  t964 = 0.1e1 / t944
  t965 = t693 * t964
  t969 = t933 * t803
  t973 = 0.1e1 / t944 / t692
  t974 = t693 * t973
  t978 = -0.2e1 * t690 * t933 * t696 + 0.8e1 * t694 * t938 * t803 - 0.6e1 * t965 * t938 * t803 + 0.4e1 * t974 * t938 * t949 - 0.2e1 * t938 * t696 + 0.2e1 * t811 * t969
  t981 = 0.2e1 * t810 * t938 * t803 - t942 * t803 - 0.2e1 * t946 * t938 * t949 + t933 * t698 / 0.4e1 + t800 * t815 / 0.2e1 + t690 * t978 / 0.4e1
  t985 = f.my_piecewise3(t632, t894 + t931, -0.8e1 / 0.3e1 * t933 * t701 - 0.16e2 / 0.3e1 * t800 * t818 - 0.8e1 / 0.3e1 * t690 * t981)
  t987 = t43 * t985 * t619
  t991 = f.my_piecewise3(t582, 0, -0.3e1 / 0.8e1 * t600 * t707 - t713 * t715 / 0.4e1 - 0.3e1 / 0.4e1 * t713 * t824 + t829 * t831 / 0.12e2 - t829 * t835 / 0.4e1 - 0.3e1 / 0.8e1 * t829 * t987)
  t1005 = t341 ** 2
  t1015 = t359 * t208
  t1022 = t355 * t345
  t1073 = s0 / t55 / t378 / r0
  t1086 = t191 ** 2
  t1107 = t378 ** 2
  t1117 = t198 ** 2
  t1127 = -0.42587654320987654320987654320987654320987654320988e-1 * t52 * t1073 * t67 - 0.27377777777777777777777777777777777777777777777778e-1 * t52 * t381 * t204 - 0.14933333333333333333333333333333333333333333333333e-1 * t52 * t187 * t391 + 0.74666666666666666666666666666666666666666666666667e-2 * t52 * t187 * t412 - 0.55999999999999999999999999999999999999999999999998e-2 * t52 * t58 / t1086 * t390 * t203 + 0.55999999999999999999999999999999999999999999999998e-2 * t51 * t49 * s0 * t57 * t389 * t203 * t411 - 0.93333333333333333333333333333333333333333333333332e-3 * t52 * t58 * t192 * (-0.26133333333333333333333333333333333333333333333333e0 * t59 / t54 / t378 * t63 - 0.88853333333333333333333333333333333333333333333333e0 * t1073 * t200 + 0.55253333333333333333333333333333333333333333333333e0 * t402 / t54 / t1107 * t408 - 0.17920000000000000000000000000000000000000000000000e0 * t402 * s0 / t1107 / t184 / t199 / t1117)
  t1146 = t24 ** 2
  t1150 = 0.6e1 * t33 - 0.6e1 * t16 / t1146
  t1151 = f.my_piecewise5(t10, 0, t14, 0, t1150)
  t1158 = 0.15e2 / 0.16e2 * f.p.cam_omega / t75 / t372 * t78 * t81 / t356 / t181 * t1015 - 0.9e1 / 0.8e1 * t352 * t215 * t341 * t1022 * t357 * t359 * t217 - 0.27e2 / 0.4e1 * t354 * t355 * t345 / t356 / t71 * t1015 + 0.27e2 / 0.8e1 * t354 * t1022 * t357 * t208 * t416 + t178 * t425 * jnp.pi * t52 * t366 * t426 / 0.3e1 + t365 * t52 * t372 * t359 * t217 / 0.2e1 - t365 * t52 * t182 * t416 * t217 / 0.4e1 - t365 * t52 * t366 * t432 / 0.4e1 + 0.3e1 / 0.2e1 * t180 * t51 * t49 * t357 * t1015 - 0.3e1 / 0.2e1 * t180 * t52 * t372 * t208 * t416 + t180 * t51 * t183 * t1127 / 0.4e1 - 0.14e2 / 0.27e2 * t77 * t78 / t80 / t421 / t19 / t32 * t426 * t217 + 0.2e1 / 0.3e1 * t77 * t78 * t424 * t217 * t432 - t77 * t215 * (t1151 * t6 + 0.3e1 * t37) / 0.6e1
  t1159 = f.my_piecewise3(t86, t1158, 0)
  t1166 = t440 * t222
  t1187 = 0.3e1 / 0.91e2 * t279 * t1159 - 0.34e2 / 0.5985e4 * t260 * t1159 - 0.10e2 / 0.231e3 * t276 * t1159 + 0.4e1 * t270 * t1166 + 0.64e2 / 0.9e1 * t260 * t1166 - 0.2e1 / 0.9e1 * t289 * t1159 + 0.24e2 / 0.2275e4 * t237 * t1159 - 0.24e2 / 0.5e1 * t273 * t1166 - 0.8e1 / 0.3e1 * t267 * t1166 + 0.7e1 / 0.870e3 * t247 * t1159 + 0.8e1 / 0.135e3 * t273 * t1159 + 0.20e2 / 0.3e1 * t232 * t1166 - 0.72e2 / 0.11e2 * t227 * t1166
  t1218 = -0.88e2 / 0.13e2 * t237 * t1166 + 0.10e2 / 0.693e3 * t227 * t1159 - 0.120e3 / 0.17e2 * t256 * t1166 + 0.32e2 / 0.5e1 * t175 * t1166 + 0.7e1 * t252 * t1166 + 0.18e2 / 0.3515e4 * t264 * t1159 - 0.3e1 / 0.35e2 * t270 * t1159 - 0.11e2 / 0.897e3 * t232 * t1159 + 0.36e2 / 0.5e1 / t117 / t230 * t1166 - 0.56e2 / 0.9e1 * t286 * t1166 - 0.26e2 / 0.2835e4 * t242 * t1159 - 0.15e2 / 0.2108e4 * t252 * t1159 - 0.136e3 / 0.19e2 * t264 * t1166 + 0.2e1 / 0.15e2 * t267 * t1159
  t1250 = 0.6e1 * t282 * t1166 + 0.32e2 / 0.5049e4 * t256 * t1159 - 0.40e2 / 0.7e1 * t279 * t1166 + 0.16e2 / 0.3e1 * t276 * t1166 - 0.7e1 / 0.270e3 * t282 * t1159 - 0.18e2 / 0.1045e4 * t175 * t1159 + 0.48e2 / 0.7e1 * t242 * t1166 + 0.16e2 / 0.765e3 * t286 * t1159 - 0.104e3 / 0.15e2 * t247 * t1166 + 0.45e2 / 0.68e2 * t118 * t222 * t437 - 0.8e1 / 0.5e1 * t132 * t222 * t437 + 0.54e2 / 0.55e2 * t96 * t437 * t222 - 0.32e2 / 0.51e2 * t121 * t222 * t437
  t1293 = -0.10e2 / 0.11e2 * t100 * t222 * t437 + 0.11e2 / 0.13e2 * t103 * t437 * t222 - 0.72e2 / 0.91e2 * t107 * t437 * t222 - 0.16e2 / 0.15e2 * t93 * t437 * t222 + 0.34e2 / 0.57e2 * t124 * t437 * t222 - 0.7e1 / 0.10e2 * t115 * t437 * t222 - 0.9e1 / 0.7e1 * t136 * t437 * t222 + 0.26e2 / 0.35e2 * t111 * t222 * t437 + 0.9e1 / 0.5e1 * t130 * t222 * t437 - 0.2e1 * t128 * t437 * t222 + 0.10e2 / 0.7e1 * t134 * t437 * t222 - 0.54e2 / 0.95e2 * t474 * t437 * t222 + 0.2e1 * t126 * t437 * t222 + 0.7e1 / 0.6e1 * t138 * t437 * t222
  t1296 = f.my_piecewise3(t86, 0, t1158)
  t1303 = t521 * t293
  t1319 = t527 ** 2
  t1323 = 0.1e1 / t531 / t148
  t1372 = -0.6e1 * t293 * t149 * t516 - 0.24e2 * t1303 * t303 * t296 - 0.2e1 * t143 * t1296 * t149 + 0.24e2 * t525 * t305 + 0.24e2 * t529 * t1303 * t532 + 0.24e2 * t146 * t529 * t1303 * t296 - 0.18e2 * t548 * t305 * t516 - 0.36e2 * t146 / t527 / t302 * t1303 * t532 + 0.2e1 * t304 * t1296 * t296 + 0.12e2 * t557 * t516 * t532 * t293 + 0.16e2 * t146 / t1319 / t143 * t1303 * t1323
  t1379 = f.my_piecewise3(t85, t1187 + t1218 + t1250 + t1293, -0.8e1 / 0.3e1 * t1296 * t154 - 0.8e1 * t516 * t311 - 0.8e1 * t293 * t564 - 0.8e1 / 0.3e1 * t143 * (-0.6e1 * t547 * t1303 * t296 + 0.6e1 * t303 * t293 * t552 + 0.14e2 * t556 * t1303 * t532 - t147 * t1296 * t296 - 0.6e1 * t529 * t516 * t532 * t293 - 0.8e1 / t1319 * t1303 * t1323 + t1296 * t151 / 0.4e1 + 0.3e1 / 0.4e1 * t516 * t308 + 0.3e1 / 0.4e1 * t293 * t561 + t143 * t1372 / 0.4e1))
  t1388 = 0.1e1 / t167 / t24
  t1404 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t1151)
  t1437 = t166 * t331 / 0.4e1 - 0.3e1 / 0.8e1 * t42 * t170 - 0.3e1 / 0.4e1 * t166 * t335 - 0.3e1 / 0.4e1 * t327 * t334 * t208 - 0.3e1 / 0.8e1 * t327 * t169 * t416 - 0.3e1 / 0.8e1 * t327 * t43 * t1379 * t71 - 0.3e1 / 0.8e1 * t327 * t159 * t1127 - 0.5e1 / 0.36e2 * t327 * t1388 * t158 * t71 - 0.3e1 / 0.8e1 * t5 * t1404 * t160 - 0.9e1 / 0.8e1 * t42 * t317 - 0.9e1 / 0.8e1 * t166 * t576 + t327 * t329 * t315 * t71 / 0.4e1 + t327 * t330 * t208 / 0.4e1 - 0.3e1 / 0.8e1 * t327 * t168 * t568 * t71 - 0.9e1 / 0.4e1 * t166 * t573 - 0.9e1 / 0.8e1 * t327 * t569 * t208 - 0.9e1 / 0.8e1 * t327 * t316 * t416 - 0.3e1 / 0.4e1 * t166 * t338 - 0.9e1 / 0.8e1 * t166 * t570 - 0.9e1 / 0.8e1 * t42 * t320
  t1438 = f.my_piecewise3(t1, 0, t1437)
  t1448 = f.my_piecewise5(t14, 0, t10, 0, -t1150)
  t1452 = f.my_piecewise3(t585, 0, -0.8e1 / 0.27e2 / t587 / t584 * t591 * t590 + 0.4e1 / 0.3e1 * t588 * t590 * t595 + 0.4e1 / 0.3e1 * t586 * t1448)
  t1478 = t838 * t729
  t1503 = -0.14e2 / 0.27e2 * t625 * t78 / t627 / t843 / t584 / t32 * t848 * t725 + 0.2e1 / 0.3e1 * t625 * t78 * t846 * t725 * t854 - t625 * t723 * (t1448 * t6 + 0.3e1 * t595) / 0.6e1
  t1504 = f.my_piecewise3(t633, t1503, 0)
  t1527 = 0.4e1 * t777 * t1478 + 0.16e2 / 0.3e1 * t783 * t1478 - 0.3e1 / 0.35e2 * t777 * t1504 + 0.2e1 / 0.15e2 * t774 * t1504 + 0.64e2 / 0.9e1 * t767 * t1478 - 0.40e2 / 0.7e1 * t786 * t1478 - 0.2e1 / 0.9e1 * t796 * t1504 + 0.7e1 / 0.870e3 * t754 * t1504 + 0.3e1 / 0.91e2 * t786 * t1504 - 0.56e2 / 0.9e1 * t793 * t1478 - 0.18e2 / 0.1045e4 * t720 * t1504 + 0.48e2 / 0.7e1 * t749 * t1478 - 0.136e3 / 0.19e2 * t771 * t1478
  t1556 = -0.88e2 / 0.13e2 * t744 * t1478 + 0.16e2 / 0.765e3 * t793 * t1504 - 0.34e2 / 0.5985e4 * t767 * t1504 - 0.11e2 / 0.897e3 * t739 * t1504 + 0.7e1 * t759 * t1478 - 0.24e2 / 0.5e1 * t780 * t1478 - 0.120e3 / 0.17e2 * t763 * t1478 + 0.20e2 / 0.3e1 * t739 * t1478 + 0.6e1 * t789 * t1478 + 0.24e2 / 0.2275e4 * t744 * t1504 - 0.26e2 / 0.2835e4 * t749 * t1504 - 0.8e1 / 0.3e1 * t774 * t1478 + 0.8e1 / 0.135e3 * t780 * t1504 - 0.104e3 / 0.15e2 * t754 * t1478
  t1590 = -0.72e2 / 0.11e2 * t734 * t1478 - 0.7e1 / 0.270e3 * t789 * t1504 + 0.18e2 / 0.3515e4 * t771 * t1504 + 0.10e2 / 0.693e3 * t734 * t1504 + 0.36e2 / 0.5e1 / t664 / t737 * t1478 + 0.32e2 / 0.5049e4 * t763 * t1504 + 0.32e2 / 0.5e1 * t720 * t1478 - 0.10e2 / 0.231e3 * t783 * t1504 - 0.15e2 / 0.2108e4 * t759 * t1504 + 0.11e2 / 0.13e2 * t650 * t729 * t859 - 0.54e2 / 0.95e2 * t883 * t859 * t729 - 0.9e1 / 0.7e1 * t683 * t859 * t729 - 0.7e1 / 0.10e2 * t662 * t859 * t729
  t1633 = 0.54e2 / 0.55e2 * t643 * t729 * t859 - 0.32e2 / 0.51e2 * t668 * t729 * t859 + 0.45e2 / 0.68e2 * t665 * t859 * t729 + 0.7e1 / 0.6e1 * t685 * t859 * t729 + 0.10e2 / 0.7e1 * t681 * t729 * t859 - 0.72e2 / 0.91e2 * t654 * t729 * t859 - 0.2e1 * t675 * t729 * t859 + 0.34e2 / 0.57e2 * t671 * t859 * t729 + 0.26e2 / 0.35e2 * t658 * t859 * t729 + 0.9e1 / 0.5e1 * t677 * t859 * t729 - 0.16e2 / 0.15e2 * t640 * t859 * t729 + 0.2e1 * t673 * t859 * t729 - 0.8e1 / 0.5e1 * t679 * t729 * t859 - 0.10e2 / 0.11e2 * t647 * t859 * t729
  t1636 = f.my_piecewise3(t633, 0, t1503)
  t1643 = t938 * t800
  t1659 = t944 ** 2
  t1663 = 0.1e1 / t948 / t695
  t1712 = -0.6e1 * t800 * t696 * t933 - 0.24e2 * t1643 * t810 * t803 - 0.2e1 * t690 * t1636 * t696 + 0.24e2 * t942 * t812 + 0.24e2 * t946 * t1643 * t949 + 0.24e2 * t693 * t946 * t1643 * t803 - 0.18e2 * t965 * t812 * t933 - 0.36e2 * t693 / t944 / t809 * t1643 * t949 + 0.2e1 * t811 * t1636 * t803 + 0.12e2 * t974 * t933 * t949 * t800 + 0.16e2 * t693 / t1659 / t690 * t1643 * t1663
  t1719 = f.my_piecewise3(t632, t1527 + t1556 + t1590 + t1633, -0.8e1 / 0.3e1 * t1636 * t701 - 0.8e1 * t933 * t818 - 0.8e1 * t800 * t981 - 0.8e1 / 0.3e1 * t690 * (-0.6e1 * t964 * t1643 * t803 + 0.6e1 * t810 * t800 * t969 + 0.14e2 * t973 * t1643 * t949 - t694 * t1636 * t803 - 0.6e1 * t946 * t933 * t949 * t800 - 0.8e1 / t1659 * t1643 * t1663 + t1636 * t698 / 0.4e1 + 0.3e1 / 0.4e1 * t933 * t815 + 0.3e1 / 0.4e1 * t800 * t978 + t690 * t1712 / 0.4e1))
  t1725 = f.my_piecewise3(t582, 0, -0.3e1 / 0.8e1 * t5 * t1452 * t707 - 0.3e1 / 0.8e1 * t600 * t715 - 0.9e1 / 0.8e1 * t600 * t824 + t713 * t831 / 0.4e1 - 0.3e1 / 0.4e1 * t713 * t835 - 0.9e1 / 0.8e1 * t713 * t987 - 0.5e1 / 0.36e2 * t829 * t1388 * t705 * t619 + t829 * t329 * t822 * t619 / 0.4e1 - 0.3e1 / 0.8e1 * t829 * t168 * t985 * t619 - 0.3e1 / 0.8e1 * t829 * t43 * t1719 * t619)
  d111 = 0.3e1 * t580 + 0.3e1 * t991 + t6 * (t1438 + t1725)

  res = {'v3rho3': d111}
  return res
