"""Generated from gga_x_sg4.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  sg4_mu1 = 0.042

  sg4_nu_MGE4 = -0.195

  sg4_mu2 = 0.26 - sg4_mu1

  sg4_k2 = -sg4_mu2 ** 2 / sg4_nu_MGE4

  sg4_k1 = 0.804 - sg4_k2

  sg4_f0 = lambda s: 1 + sg4_k1 + sg4_k2 - sg4_k1 * (1 - sg4_mu1 * s ** 2 / sg4_k1) / (1 - (sg4_mu1 * s ** 2 / sg4_k1) ** 5) - sg4_k2 / (1 + sg4_mu2 * s ** 2 / sg4_k2)

  sg4_f = lambda x: sg4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, sg4_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  sg4_mu1 = 0.042

  sg4_nu_MGE4 = -0.195

  sg4_mu2 = 0.26 - sg4_mu1

  sg4_k2 = -sg4_mu2 ** 2 / sg4_nu_MGE4

  sg4_k1 = 0.804 - sg4_k2

  sg4_f0 = lambda s: 1 + sg4_k1 + sg4_k2 - sg4_k1 * (1 - sg4_mu1 * s ** 2 / sg4_k1) / (1 - (sg4_mu1 * s ** 2 / sg4_k1) ** 5) - sg4_k2 / (1 + sg4_mu2 * s ** 2 / sg4_k2)

  sg4_f = lambda x: sg4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, sg4_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  sg4_mu1 = 0.042

  sg4_nu_MGE4 = -0.195

  sg4_mu2 = 0.26 - sg4_mu1

  sg4_k2 = -sg4_mu2 ** 2 / sg4_nu_MGE4

  sg4_k1 = 0.804 - sg4_k2

  sg4_f0 = lambda s: 1 + sg4_k1 + sg4_k2 - sg4_k1 * (1 - sg4_mu1 * s ** 2 / sg4_k1) / (1 - (sg4_mu1 * s ** 2 / sg4_k1) ** 5) - sg4_k2 / (1 + sg4_mu2 * s ** 2 / sg4_k2)

  sg4_f = lambda x: sg4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, sg4_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t40 = t33 * s0 * t38
  t42 = 0.56028717948717948717948717948717948717948717948718e0 - 0.17500000000000000000000000000000000000000000000000e-2 * t40
  t43 = t28 ** 2
  t44 = t29 ** 2
  t47 = 0.1e1 / t30 / t44 / t29
  t48 = t43 * t47
  t49 = s0 ** 2
  t50 = t49 ** 2
  t51 = t50 * s0
  t52 = t34 ** 2
  t54 = t52 ** 2
  t57 = 0.1e1 / t35 / t54 / t52 / r0
  t61 = 0.1e1 - 0.17835614159590036508886426167904464920033894373558e-11 * t48 * t51 * t57
  t62 = 0.1e1 / t61
  t65 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t40
  t68 = 0.18040000000000000000000000000000000000000000000000e1 - t42 * t62 - 0.24371282051282051282051282051282051282051282051282e0 / t65
  t72 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t68)
  t73 = r1 <= f.p.dens_threshold
  t74 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t75 = 0.1e1 + t74
  t76 = t75 <= f.p.zeta_threshold
  t77 = t75 ** (0.1e1 / 0.3e1)
  t79 = f.my_piecewise3(t76, t22, t77 * t75)
  t80 = t79 * t26
  t81 = r1 ** 2
  t82 = r1 ** (0.1e1 / 0.3e1)
  t83 = t82 ** 2
  t85 = 0.1e1 / t83 / t81
  t87 = t33 * s2 * t85
  t89 = 0.56028717948717948717948717948717948717948717948718e0 - 0.17500000000000000000000000000000000000000000000000e-2 * t87
  t90 = s2 ** 2
  t91 = t90 ** 2
  t92 = t91 * s2
  t93 = t81 ** 2
  t95 = t93 ** 2
  t98 = 0.1e1 / t82 / t95 / t93 / r1
  t102 = 0.1e1 - 0.17835614159590036508886426167904464920033894373558e-11 * t48 * t92 * t98
  t103 = 0.1e1 / t102
  t106 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t87
  t109 = 0.18040000000000000000000000000000000000000000000000e1 - t89 * t103 - 0.24371282051282051282051282051282051282051282051282e0 / t106
  t113 = f.my_piecewise3(t73, 0, -0.3e1 / 0.8e1 * t5 * t80 * t109)
  t114 = t6 ** 2
  t116 = t16 / t114
  t117 = t7 - t116
  t118 = f.my_piecewise5(t10, 0, t14, 0, t117)
  t121 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t118)
  t126 = t26 ** 2
  t127 = 0.1e1 / t126
  t131 = t5 * t25 * t127 * t68 / 0.8e1
  t134 = 0.1e1 / t36 / t34 / r0
  t139 = t61 ** 2
  t142 = t42 / t139 * t43
  t151 = t65 ** 2
  t153 = 0.1e1 / t151 * t28
  t163 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t121 * t26 * t68 - t131 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.46666666666666666666666666666666666666666666666667e-2 * t33 * s0 * t134 * t62 + 0.23780818879453382011848568223872619893378525831411e-10 * t142 * t47 * t51 / t35 / t54 / t52 / t34 - 0.24222222222222222222222222222222222222222222222223e-1 * t153 * t32 * s0 * t134))
  t165 = f.my_piecewise5(t14, 0, t10, 0, -t117)
  t168 = f.my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t165)
  t176 = t5 * t79 * t127 * t109 / 0.8e1
  t178 = f.my_piecewise3(t73, 0, -0.3e1 / 0.8e1 * t5 * t168 * t26 * t109 - t176)
  vrho_0_ = t72 + t113 + t6 * (t163 + t178)
  t181 = -t7 - t116
  t182 = f.my_piecewise5(t10, 0, t14, 0, t181)
  t185 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t182)
  t191 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t185 * t26 * t68 - t131)
  t193 = f.my_piecewise5(t14, 0, t10, 0, -t181)
  t196 = f.my_piecewise3(t76, 0, 0.4e1 / 0.3e1 * t77 * t193)
  t203 = 0.1e1 / t83 / t81 / r1
  t208 = t102 ** 2
  t211 = t89 / t208 * t43
  t220 = t106 ** 2
  t222 = 0.1e1 / t220 * t28
  t232 = f.my_piecewise3(t73, 0, -0.3e1 / 0.8e1 * t5 * t196 * t26 * t109 - t176 - 0.3e1 / 0.8e1 * t5 * t80 * (-0.46666666666666666666666666666666666666666666666667e-2 * t33 * s2 * t203 * t103 + 0.23780818879453382011848568223872619893378525831411e-10 * t211 * t47 * t92 / t82 / t95 / t93 / t81 - 0.24222222222222222222222222222222222222222222222223e-1 * t222 * t32 * s2 * t203))
  vrho_1_ = t72 + t113 + t6 * (t191 + t232)
  t249 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.17500000000000000000000000000000000000000000000000e-2 * t33 * t38 * t62 - 0.89178070797950182544432130839522324600169471867790e-11 * t142 * t47 * t50 * t57 + 0.90833333333333333333333333333333333333333333333335e-2 * t153 * t32 * t38))
  vsigma_0_ = t6 * t249
  vsigma_1_ = 0.0e0
  t264 = f.my_piecewise3(t73, 0, -0.3e1 / 0.8e1 * t5 * t80 * (0.17500000000000000000000000000000000000000000000000e-2 * t33 * t85 * t103 - 0.89178070797950182544432130839522324600169471867790e-11 * t211 * t47 * t91 * t98 + 0.90833333333333333333333333333333333333333333333335e-2 * t222 * t32 * t85))
  vsigma_2_ = t6 * t264
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  sg4_mu1 = 0.042

  sg4_nu_MGE4 = -0.195

  sg4_mu2 = 0.26 - sg4_mu1

  sg4_k2 = -sg4_mu2 ** 2 / sg4_nu_MGE4

  sg4_k1 = 0.804 - sg4_k2

  sg4_f0 = lambda s: 1 + sg4_k1 + sg4_k2 - sg4_k1 * (1 - sg4_mu1 * s ** 2 / sg4_k1) / (1 - (sg4_mu1 * s ** 2 / sg4_k1) ** 5) - sg4_k2 / (1 + sg4_mu2 * s ** 2 / sg4_k2)

  sg4_f = lambda x: sg4_f0(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, sg4_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t34 = t25 * t28 * t32
  t36 = 0.56028717948717948717948717948717948717948717948718e0 - 0.17500000000000000000000000000000000000000000000000e-2 * t34
  t37 = t20 ** 2
  t38 = t21 ** 2
  t41 = 0.1e1 / t22 / t38 / t21
  t43 = s0 ** 2
  t44 = t43 ** 2
  t45 = t44 * s0
  t47 = t29 ** 2
  t49 = t47 ** 2
  t52 = 0.1e1 / t18 / t49 / t47 / r0
  t56 = 0.1e1 - 0.14268491327672029207109140934323571936027115498846e-10 * t37 * t41 * t45 * t26 * t52
  t57 = 0.1e1 / t56
  t60 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t34
  t63 = 0.18040000000000000000000000000000000000000000000000e1 - t36 * t57 - 0.24371282051282051282051282051282051282051282051282e0 / t60
  t67 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t63)
  t76 = 0.1e1 / t30 / t29 / r0
  t81 = t56 ** 2
  t84 = t36 / t81 * t37
  t94 = t60 ** 2
  t96 = 0.1e1 / t94 * t20
  t106 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t63 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.46666666666666666666666666666666666666666666666667e-2 * t25 * s0 * t27 * t76 * t57 + 0.19024655103562705609478854579098095914702820665128e-9 * t84 * t41 * t45 * t26 / t18 / t49 / t47 / t29 - 0.24222222222222222222222222222222222222222222222223e-1 * t96 * t24 * t28 * t76))
  vrho_0_ = 0.2e1 * r0 * t106 + 0.2e1 * t67
  t126 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.17500000000000000000000000000000000000000000000000e-2 * t25 * t27 * t32 * t57 - 0.71342456638360146035545704671617859680135577494230e-10 * t84 * t41 * t44 * t26 * t52 + 0.90833333333333333333333333333333333333333333333335e-2 * t96 * t24 * t27 * t32))
  vsigma_0_ = 0.2e1 * r0 * t126
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t27 = t22 * t26
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t35 = t27 * t30 * t33
  t37 = 0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t35
  t38 = t22 ** 2
  t39 = t23 ** 2
  t42 = 0.1e1 / t24 / t39 / t23
  t44 = s0 ** 2
  t45 = t44 ** 2
  t46 = t45 * s0
  t48 = t31 ** 2
  t49 = t48 * r0
  t50 = t48 ** 2
  t53 = 0.1e1 / t18 / t50 / t49
  t57 = 0.1e1 - 0.14268491327672029207109140934323571936027115498846e-10 * t38 * t42 * t46 * t28 * t53
  t58 = 0.1e1 / t57
  t62 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t35
  t65 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * t37 * t58 - 0.24371282051282051282051282051282051282051282051282e0 / t62
  t69 = t17 * t18
  t70 = t27 * s0
  t71 = t31 * r0
  t73 = 0.1e1 / t19 / t71
  t75 = t29 * t73 * t58
  t78 = t57 ** 2
  t79 = 0.1e1 / t78
  t81 = t37 * t79 * t38
  t82 = t42 * t46
  t83 = t48 * t31
  t87 = t28 / t18 / t50 / t83
  t91 = t62 ** 2
  t93 = 0.1e1 / t91 * t22
  t94 = t93 * t26
  t98 = -0.46666666666666666666666666666666666666666666666667e-2 * t70 * t75 + 0.10659270348691522892662675568686879832086007049176e-9 * t81 * t82 * t87 - 0.24222222222222222222222222222222222222222222222223e-1 * t94 * t30 * t73
  t103 = f.my_piecewise3(t2, 0, -t6 * t21 * t65 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t69 * t98)
  t115 = 0.1e1 / t19 / t48
  t120 = t39 ** 2
  t121 = 0.1e1 / t120
  t124 = t50 ** 2
  t133 = t37 / t78 / t57 * t22
  t136 = 0.1e1 / t25 / t120 / t39
  t137 = t45 ** 2
  t148 = t48 * t71
  t158 = 0.1e1 / t91 / t62 * t38
  t160 = 0.1e1 / t24 / t23
  t161 = t158 * t160
  t176 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t65 / 0.12e2 - t6 * t21 * t98 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t69 * (0.17111111111111111111111111111111111111111111111111e-1 * t70 * t29 * t115 * t58 + 0.21307613715990230282616317128589867424467159144944e-10 * t121 * t45 * t44 / t124 / t31 * t79 - 0.24334673044738656190907596580906515339757352720737e-18 * t133 * t136 * t137 * t44 * t29 / t19 / t124 / t50 / t48 - 0.15278287499791182812816501648451194425989943437152e-8 * t81 * t82 * t28 / t18 / t50 / t148 - 0.96296296296296296296296296296296296296296296296299e-2 * t161 * t44 * t28 / t18 / t148 + 0.88814814814814814814814814814814814814814814814818e-1 * t94 * t30 * t115))
  v2rho2_0_ = 0.2e1 * r0 * t176 + 0.4e1 * t103
  t183 = t42 * t45
  t184 = t28 * t53
  t188 = t26 * t29
  t192 = 0.17500000000000000000000000000000000000000000000000e-2 * t27 * t29 * t33 * t58 - 0.39972263807593210847485033382575799370322526434408e-10 * t81 * t183 * t184 + 0.90833333333333333333333333333333333333333333333335e-2 * t93 * t188 * t33
  t196 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t69 * t192)
  t235 = f.my_piecewise3(t2, 0, -t6 * t21 * t192 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t69 * (-0.46666666666666666666666666666666666666666666666667e-2 * t27 * t75 - 0.79903551434963363559811189232212002841751846793539e-11 * t121 / t124 / r0 * t79 * t46 + 0.91255023917769960715903487178399432524090072702758e-19 * t133 * t136 * t137 * s0 * t29 / t19 / t124 / t50 / t71 + 0.53296351743457614463313377843434399160430035245877e-9 * t81 * t183 * t87 + 0.36111111111111111111111111111111111111111111111112e-2 * t161 * t28 / t18 / t83 * s0 - 0.24222222222222222222222222222222222222222222222223e-1 * t93 * t188 * t73))
  v2rhosigma_0_ = 0.2e1 * r0 * t235 + 0.2e1 * t196
  t267 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t69 * (0.29963831788111261334929195962079501065656942547577e-11 * t121 / t124 * t79 * t45 - 0.34220633969163735268463807691899787196533777263534e-19 * t133 * t136 * t137 * t29 / t19 / t124 / t50 / t31 - 0.15988905523037284338994013353030319748129010573763e-9 * t81 * t42 * t44 * s0 * t184 - 0.13541666666666666666666666666666666666666666666667e-2 * t158 * t160 * t28 / t18 / t49))
  v2sigma2_0_ = 0.2e1 * r0 * t267
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t36 = t28 * t31 * t34
  t38 = 0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t36
  t39 = t23 ** 2
  t40 = t24 ** 2
  t41 = t40 * t24
  t43 = 0.1e1 / t25 / t41
  t45 = s0 ** 2
  t46 = t45 ** 2
  t47 = t46 * s0
  t49 = t32 ** 2
  t50 = t49 * r0
  t51 = t49 ** 2
  t52 = t51 * t50
  t58 = 0.1e1 - 0.14268491327672029207109140934323571936027115498846e-10 * t39 * t43 * t47 * t29 / t18 / t52
  t59 = 0.1e1 / t58
  t63 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t36
  t66 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * t38 * t59 - 0.24371282051282051282051282051282051282051282051282e0 / t63
  t71 = t17 / t19
  t72 = t28 * s0
  t73 = t32 * r0
  t75 = 0.1e1 / t19 / t73
  t80 = t58 ** 2
  t81 = 0.1e1 / t80
  t83 = t38 * t81 * t39
  t84 = t43 * t47
  t93 = t63 ** 2
  t96 = 0.1e1 / t93 * t23 * t27
  t100 = -0.46666666666666666666666666666666666666666666666667e-2 * t72 * t30 * t75 * t59 + 0.10659270348691522892662675568686879832086007049176e-9 * t83 * t84 * t29 / t18 / t51 / t49 / t32 - 0.24222222222222222222222222222222222222222222222223e-1 * t96 * t31 * t75
  t104 = t17 * t18
  t106 = 0.1e1 / t19 / t49
  t111 = t40 ** 2
  t112 = 0.1e1 / t111
  t114 = t112 * t46 * t45
  t115 = t51 ** 2
  t122 = 0.1e1 / t80 / t58
  t124 = t38 * t122 * t23
  t128 = t46 ** 2
  t130 = 0.1e1 / t26 / t111 / t40 * t128 * t45
  t139 = t49 * t73
  t152 = 0.1e1 / t93 / t63 * t39 / t25 / t24
  t153 = t45 * t29
  t162 = 0.17111111111111111111111111111111111111111111111111e-1 * t72 * t30 * t106 * t59 + 0.21307613715990230282616317128589867424467159144944e-10 * t114 / t115 / t32 * t81 - 0.24334673044738656190907596580906515339757352720737e-18 * t124 * t130 * t30 / t19 / t115 / t51 / t49 - 0.15278287499791182812816501648451194425989943437152e-8 * t83 * t84 * t29 / t18 / t51 / t139 - 0.96296296296296296296296296296296296296296296296299e-2 * t152 * t153 / t18 / t139 + 0.88814814814814814814814814814814814814814814814818e-1 * t96 * t31 * t106
  t167 = f.my_piecewise3(t2, 0, t6 * t22 * t66 / 0.12e2 - t6 * t71 * t100 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t104 * t162)
  t180 = 0.1e1 / t19 / t50
  t190 = t45 * s0
  t191 = t128 * t190
  t193 = t115 ** 2
  t195 = 0.1e1 / t18 / t193
  t211 = t80 ** 2
  t214 = t111 ** 2
  t220 = t51 * t73
  t239 = t93 ** 2
  t260 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t66 + t6 * t22 * t100 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t71 * t162 - 0.3e1 / 0.8e1 * t6 * t104 * (-0.79851851851851851851851851851851851851851851851851e-1 * t72 * t30 * t180 * t59 - 0.57530557033173621763064056247192642046061329691349e-9 * t114 / t115 / t73 * t81 - 0.81074000405331248201383586763655740496372523159807e-20 * t112 * t191 * t195 * t122 * t39 * t43 * t29 - 0.40537000202665624100691793381827870248186261579907e-20 * t39 / t25 / t111 / t41 * t191 * t29 * t195 * t122 + 0.16666515422428214873909558480057383615483979914577e-26 * t38 / t211 / t214 / t40 * t128 * t46 * t190 / t193 / t220 + 0.10463909409237622162090266529789801596095661669917e-16 * t124 * t130 * t30 / t19 / t115 / t52 + 0.23426707499679813646318635860958498119851246603633e-7 * t83 * t84 * t29 / t18 / t115 - 0.34454638124362895005096839959225280326197757390419e-1 / t239 / t40 * t190 / t220 + 0.10592592592592592592592592592592592592592592592593e0 * t152 * t153 / t18 / t51 - 0.41446913580246913580246913580246913580246913580248e0 * t96 * t31 * t180))
  v3rho3_0_ = 0.2e1 * r0 * t260 + 0.6e1 * t167

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t34 = t29 * t32 * t22
  t36 = 0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t34
  t37 = t24 ** 2
  t38 = t25 ** 2
  t39 = t38 * t25
  t41 = 0.1e1 / t26 / t39
  t43 = s0 ** 2
  t44 = t43 ** 2
  t45 = t44 * s0
  t47 = t18 ** 2
  t48 = t47 * r0
  t49 = t47 ** 2
  t50 = t49 * t48
  t56 = 0.1e1 - 0.14268491327672029207109140934323571936027115498846e-10 * t37 * t41 * t45 * t30 / t19 / t50
  t57 = 0.1e1 / t56
  t61 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t34
  t64 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * t36 * t57 - 0.24371282051282051282051282051282051282051282051282e0 / t61
  t70 = t17 / t20 / r0
  t71 = t29 * s0
  t72 = t18 * r0
  t74 = 0.1e1 / t20 / t72
  t79 = t56 ** 2
  t80 = 0.1e1 / t79
  t82 = t36 * t80 * t37
  t83 = t41 * t45
  t84 = t47 * t18
  t85 = t49 * t84
  t92 = t61 ** 2
  t95 = 0.1e1 / t92 * t24 * t28
  t99 = -0.46666666666666666666666666666666666666666666666667e-2 * t71 * t31 * t74 * t57 + 0.10659270348691522892662675568686879832086007049176e-9 * t82 * t83 * t30 / t19 / t85 - 0.24222222222222222222222222222222222222222222222223e-1 * t95 * t32 * t74
  t104 = t17 / t20
  t106 = 0.1e1 / t20 / t47
  t111 = t38 ** 2
  t112 = 0.1e1 / t111
  t114 = t112 * t44 * t43
  t115 = t49 ** 2
  t122 = 0.1e1 / t79 / t56
  t124 = t36 * t122 * t24
  t127 = 0.1e1 / t27 / t111 / t38
  t128 = t44 ** 2
  t130 = t127 * t128 * t43
  t131 = t49 * t47
  t139 = t47 * t72
  t152 = 0.1e1 / t92 / t61 * t37 / t26 / t25
  t153 = t43 * t30
  t162 = 0.17111111111111111111111111111111111111111111111111e-1 * t71 * t31 * t106 * t57 + 0.21307613715990230282616317128589867424467159144944e-10 * t114 / t115 / t18 * t80 - 0.24334673044738656190907596580906515339757352720737e-18 * t124 * t130 * t31 / t20 / t115 / t131 - 0.15278287499791182812816501648451194425989943437152e-8 * t82 * t83 * t30 / t19 / t49 / t139 - 0.96296296296296296296296296296296296296296296296299e-2 * t152 * t153 / t19 / t139 + 0.88814814814814814814814814814814814814814814814818e-1 * t95 * t32 * t106
  t166 = t17 * t19
  t168 = 0.1e1 / t20 / t48
  t178 = t43 * s0
  t179 = t128 * t178
  t180 = t112 * t179
  t181 = t115 ** 2
  t183 = 0.1e1 / t19 / t181
  t186 = t41 * t30
  t187 = t122 * t37 * t186
  t194 = t37 / t26 / t111 / t39 * t179
  t199 = t79 ** 2
  t200 = 0.1e1 / t199
  t201 = t36 * t200
  t202 = t111 ** 2
  t203 = t202 * t38
  t204 = 0.1e1 / t203
  t207 = t204 * t128 * t44 * t178
  t208 = t49 * t72
  t227 = t92 ** 2
  t229 = 0.1e1 / t38
  t230 = 0.1e1 / t227 * t229
  t243 = -0.79851851851851851851851851851851851851851851851851e-1 * t71 * t31 * t168 * t57 - 0.57530557033173621763064056247192642046061329691349e-9 * t114 / t115 / t72 * t80 - 0.81074000405331248201383586763655740496372523159807e-20 * t180 * t183 * t187 - 0.40537000202665624100691793381827870248186261579907e-20 * t194 * t30 * t183 * t122 + 0.16666515422428214873909558480057383615483979914577e-26 * t201 * t207 / t181 / t208 + 0.10463909409237622162090266529789801596095661669917e-16 * t124 * t130 * t31 / t20 / t115 / t50 + 0.23426707499679813646318635860958498119851246603633e-7 * t82 * t83 * t30 / t19 / t115 - 0.34454638124362895005096839959225280326197757390419e-1 * t230 * t178 / t208 + 0.10592592592592592592592592592592592592592592592593e0 * t152 * t153 / t19 / t49 - 0.41446913580246913580246913580246913580246913580248e0 * t95 * t32 * t168
  t248 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t64 + t6 * t70 * t99 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t104 * t162 - 0.3e1 / 0.8e1 * t6 * t166 * t243)
  t264 = 0.1e1 / t20 / t84
  t276 = 0.1e1 / t19 / t181 / r0
  t280 = t128 ** 2
  t284 = 0.1e1 / t20 / t181 / t85
  t299 = t31 * t284
  t314 = t49 * r0
  t365 = 0.45249382716049382716049382716049382716049382716049e0 * t71 * t31 * t264 * t57 + 0.13454574305330275410678725582419579619249651713413e-7 * t114 / t115 / t47 * t80 + 0.48103906907163207266154261479769072694514363741486e-18 * t180 * t276 * t187 + 0.27763288120395539897594087678209378139581206930996e-28 * t112 * t280 * t284 * t200 * t24 * t127 * t31 + 0.30537873486008103489187817680976995586966983723530e-18 * t194 * t30 * t276 * t122 + 0.13881644060197769948797043839104689069790603465499e-28 * t24 / t27 / t203 * t280 * t299 * t200 + 0.13881644060197769948797043839104689069790603465499e-28 * t29 * t280 * t299 * t200 * t204 - 0.12682988307596219218830807257405822012601078228038e-35 * t36 / t199 / t56 * t204 * t280 * t44 / t19 / t181 / t115 / t314 * t37 * t186 - 0.14333203263288264791562220292849349909316222726536e-24 * t201 * t207 / t181 / t131 - 0.36391151612126397074825038042491198884199356696488e-15 * t124 * t130 * t31 / t20 / t115 / t85 - 0.38263622249477028955653771906232213595757036119267e-6 * t82 * t83 * t30 / t19 / t115 / r0 - 0.13697562557086166209977336986847970771882900491604e-1 / t227 / t61 * t229 * t44 / t20 / t85 * t24 * t28 * t31 + 0.75800203873598369011213047910295616717635066258923e0 * t230 * t178 / t131 - 0.10474897119341563786008230452674897119341563786009e1 * t152 * t153 / t19 / t314 + 0.23486584362139917695473251028806584362139917695474e1 * t95 * t32 * t264
  t370 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t74 * t64 - 0.5e1 / 0.9e1 * t6 * t23 * t99 + t6 * t70 * t162 / 0.2e1 - t6 * t104 * t243 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t166 * t365)
  v4rho4_0_ = 0.2e1 * r0 * t370 + 0.8e1 * t248

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t44 = t37 * s0 / t40 / t38
  t46 = 0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t44
  t47 = t32 ** 2
  t48 = t33 ** 2
  t51 = 0.1e1 / t34 / t48 / t33
  t52 = t47 * t51
  t53 = s0 ** 2
  t54 = t53 ** 2
  t55 = t54 * s0
  t56 = t38 ** 2
  t58 = t56 ** 2
  t65 = 0.1e1 - 0.17835614159590036508886426167904464920033894373557e-11 * t52 * t55 / t39 / t58 / t56 / r0
  t66 = 0.1e1 / t65
  t70 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t44
  t73 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * t46 * t66 - 0.24371282051282051282051282051282051282051282051282e0 / t70
  t77 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t78 = t77 * f.p.zeta_threshold
  t80 = f.my_piecewise3(t20, t78, t21 * t19)
  t81 = t30 ** 2
  t82 = 0.1e1 / t81
  t83 = t80 * t82
  t86 = t5 * t83 * t73 / 0.8e1
  t87 = t80 * t30
  t88 = t38 * r0
  t90 = 0.1e1 / t40 / t88
  t95 = t65 ** 2
  t96 = 0.1e1 / t95
  t98 = t46 * t96 * t47
  t99 = t51 * t55
  t107 = t70 ** 2
  t109 = 0.1e1 / t107 * t32
  t110 = t36 * s0
  t114 = -0.46666666666666666666666666666666666666666666666667e-2 * t37 * s0 * t90 * t66 + 0.13324087935864403615828344460858599790107508811469e-10 * t98 * t99 / t39 / t58 / t56 / t38 - 0.24222222222222222222222222222222222222222222222223e-1 * t109 * t110 * t90
  t119 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t73 - t86 - 0.3e1 / 0.8e1 * t5 * t87 * t114)
  t121 = r1 <= f.p.dens_threshold
  t122 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t123 = 0.1e1 + t122
  t124 = t123 <= f.p.zeta_threshold
  t125 = t123 ** (0.1e1 / 0.3e1)
  t127 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t130 = f.my_piecewise3(t124, 0, 0.4e1 / 0.3e1 * t125 * t127)
  t131 = t130 * t30
  t132 = r1 ** 2
  t133 = r1 ** (0.1e1 / 0.3e1)
  t134 = t133 ** 2
  t138 = t37 * s2 / t134 / t132
  t140 = 0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t138
  t141 = s2 ** 2
  t142 = t141 ** 2
  t143 = t142 * s2
  t144 = t132 ** 2
  t146 = t144 ** 2
  t153 = 0.1e1 - 0.17835614159590036508886426167904464920033894373557e-11 * t52 * t143 / t133 / t146 / t144 / r1
  t154 = 0.1e1 / t153
  t158 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t138
  t161 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * t140 * t154 - 0.24371282051282051282051282051282051282051282051282e0 / t158
  t166 = f.my_piecewise3(t124, t78, t125 * t123)
  t167 = t166 * t82
  t170 = t5 * t167 * t161 / 0.8e1
  t172 = f.my_piecewise3(t121, 0, -0.3e1 / 0.8e1 * t5 * t131 * t161 - t170)
  t174 = t21 ** 2
  t175 = 0.1e1 / t174
  t176 = t26 ** 2
  t181 = t16 / t22 / t6
  t183 = -0.2e1 * t23 + 0.2e1 * t181
  t184 = f.my_piecewise5(t10, 0, t14, 0, t183)
  t188 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t175 * t176 + 0.4e1 / 0.3e1 * t21 * t184)
  t195 = t5 * t29 * t82 * t73
  t201 = 0.1e1 / t81 / t6
  t205 = t5 * t80 * t201 * t73 / 0.12e2
  t207 = t5 * t83 * t114
  t210 = 0.1e1 / t40 / t56
  t215 = t48 ** 2
  t216 = 0.1e1 / t215
  t219 = t58 ** 2
  t231 = 0.1e1 / t35 / t215 / t48
  t232 = t54 ** 2
  t242 = t56 * t88
  t253 = 0.1e1 / t34 / t33
  t268 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t188 * t30 * t73 - t195 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t114 + t205 - t207 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t87 * (0.17111111111111111111111111111111111111111111111111e-1 * t37 * s0 * t210 * t66 + 0.13317258572493893926635198205368667140291974465589e-11 * t216 * t54 * t53 / t219 / t38 * t96 - 0.38022926632404150298293119657666430218370863626145e-20 * t46 / t95 / t65 * t32 * t231 * t232 * t53 / t40 / t219 / t58 / t56 - 0.19097859374738978516020627060563993032487429296439e-9 * t98 * t99 / t39 / t58 / t242 - 0.48148148148148148148148148148148148148148148148150e-2 / t107 / t70 * t47 * t253 * t53 / t39 / t242 + 0.88814814814814814814814814814814814814814814814818e-1 * t109 * t110 * t210))
  t269 = t125 ** 2
  t270 = 0.1e1 / t269
  t271 = t127 ** 2
  t275 = f.my_piecewise5(t14, 0, t10, 0, -t183)
  t279 = f.my_piecewise3(t124, 0, 0.4e1 / 0.9e1 * t270 * t271 + 0.4e1 / 0.3e1 * t125 * t275)
  t286 = t5 * t130 * t82 * t161
  t291 = t5 * t166 * t201 * t161 / 0.12e2
  t293 = f.my_piecewise3(t121, 0, -0.3e1 / 0.8e1 * t5 * t279 * t30 * t161 - t286 / 0.4e1 + t291)
  d11 = 0.2e1 * t119 + 0.2e1 * t172 + t6 * (t268 + t293)
  t296 = -t7 - t24
  t297 = f.my_piecewise5(t10, 0, t14, 0, t296)
  t300 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t297)
  t301 = t300 * t30
  t306 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t301 * t73 - t86)
  t308 = f.my_piecewise5(t14, 0, t10, 0, -t296)
  t311 = f.my_piecewise3(t124, 0, 0.4e1 / 0.3e1 * t125 * t308)
  t312 = t311 * t30
  t316 = t166 * t30
  t317 = t132 * r1
  t319 = 0.1e1 / t134 / t317
  t324 = t153 ** 2
  t325 = 0.1e1 / t324
  t327 = t140 * t325 * t47
  t328 = t51 * t143
  t336 = t158 ** 2
  t338 = 0.1e1 / t336 * t32
  t339 = t36 * s2
  t343 = -0.46666666666666666666666666666666666666666666666667e-2 * t37 * s2 * t319 * t154 + 0.13324087935864403615828344460858599790107508811469e-10 * t327 * t328 / t133 / t146 / t144 / t132 - 0.24222222222222222222222222222222222222222222222223e-1 * t338 * t339 * t319
  t348 = f.my_piecewise3(t121, 0, -0.3e1 / 0.8e1 * t5 * t312 * t161 - t170 - 0.3e1 / 0.8e1 * t5 * t316 * t343)
  t352 = 0.2e1 * t181
  t353 = f.my_piecewise5(t10, 0, t14, 0, t352)
  t357 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t175 * t297 * t26 + 0.4e1 / 0.3e1 * t21 * t353)
  t364 = t5 * t300 * t82 * t73
  t372 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t357 * t30 * t73 - t364 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t301 * t114 - t195 / 0.8e1 + t205 - t207 / 0.8e1)
  t376 = f.my_piecewise5(t14, 0, t10, 0, -t352)
  t380 = f.my_piecewise3(t124, 0, 0.4e1 / 0.9e1 * t270 * t308 * t127 + 0.4e1 / 0.3e1 * t125 * t376)
  t387 = t5 * t311 * t82 * t161
  t394 = t5 * t167 * t343
  t397 = f.my_piecewise3(t121, 0, -0.3e1 / 0.8e1 * t5 * t380 * t30 * t161 - t387 / 0.8e1 - t286 / 0.8e1 + t291 - 0.3e1 / 0.8e1 * t5 * t131 * t343 - t394 / 0.8e1)
  d12 = t119 + t172 + t306 + t348 + t6 * (t372 + t397)
  t402 = t297 ** 2
  t406 = 0.2e1 * t23 + 0.2e1 * t181
  t407 = f.my_piecewise5(t10, 0, t14, 0, t406)
  t411 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t175 * t402 + 0.4e1 / 0.3e1 * t21 * t407)
  t418 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t411 * t30 * t73 - t364 / 0.4e1 + t205)
  t419 = t308 ** 2
  t423 = f.my_piecewise5(t14, 0, t10, 0, -t406)
  t427 = f.my_piecewise3(t124, 0, 0.4e1 / 0.9e1 * t270 * t419 + 0.4e1 / 0.3e1 * t125 * t423)
  t438 = 0.1e1 / t134 / t144
  t445 = t146 ** 2
  t455 = t142 ** 2
  t465 = t144 * t317
  t489 = f.my_piecewise3(t121, 0, -0.3e1 / 0.8e1 * t5 * t427 * t30 * t161 - t387 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t312 * t343 + t291 - t394 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t316 * (0.17111111111111111111111111111111111111111111111111e-1 * t37 * s2 * t438 * t154 + 0.13317258572493893926635198205368667140291974465589e-11 * t216 * t142 * t141 / t445 / t132 * t325 - 0.38022926632404150298293119657666430218370863626145e-20 * t140 / t324 / t153 * t32 * t231 * t455 * t141 / t134 / t445 / t146 / t144 - 0.19097859374738978516020627060563993032487429296439e-9 * t327 * t328 / t133 / t146 / t465 - 0.48148148148148148148148148148148148148148148148150e-2 / t336 / t158 * t47 * t253 * t141 / t133 / t465 + 0.88814814814814814814814814814814814814814814814818e-1 * t338 * t339 * t438))
  d22 = 0.2e1 * t306 + 0.2e1 * t348 + t6 * (t418 + t489)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t56 = t49 * s0 / t52 / t50
  t58 = 0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t56
  t59 = t44 ** 2
  t60 = t45 ** 2
  t61 = t60 * t45
  t63 = 0.1e1 / t46 / t61
  t64 = t59 * t63
  t65 = s0 ** 2
  t66 = t65 ** 2
  t67 = t66 * s0
  t68 = t50 ** 2
  t69 = t68 * r0
  t70 = t68 ** 2
  t71 = t70 * t69
  t77 = 0.1e1 - 0.17835614159590036508886426167904464920033894373557e-11 * t64 * t67 / t51 / t71
  t78 = 0.1e1 / t77
  t82 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t56
  t85 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * t58 * t78 - 0.24371282051282051282051282051282051282051282051282e0 / t82
  t91 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t92 = t42 ** 2
  t93 = 0.1e1 / t92
  t94 = t91 * t93
  t98 = t91 * t42
  t99 = t50 * r0
  t101 = 0.1e1 / t52 / t99
  t106 = t77 ** 2
  t107 = 0.1e1 / t106
  t109 = t58 * t107 * t59
  t110 = t63 * t67
  t118 = t82 ** 2
  t120 = 0.1e1 / t118 * t44
  t121 = t48 * s0
  t125 = -0.46666666666666666666666666666666666666666666666667e-2 * t49 * s0 * t101 * t78 + 0.13324087935864403615828344460858599790107508811469e-10 * t109 * t110 / t51 / t70 / t68 / t50 - 0.24222222222222222222222222222222222222222222222223e-1 * t120 * t121 * t101
  t129 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t130 = t129 * f.p.zeta_threshold
  t132 = f.my_piecewise3(t20, t130, t21 * t19)
  t134 = 0.1e1 / t92 / t6
  t135 = t132 * t134
  t139 = t132 * t93
  t143 = t132 * t42
  t145 = 0.1e1 / t52 / t68
  t150 = t60 ** 2
  t151 = 0.1e1 / t150
  t153 = t151 * t66 * t65
  t154 = t70 ** 2
  t161 = 0.1e1 / t106 / t77
  t163 = t58 * t161 * t44
  t167 = t66 ** 2
  t169 = 0.1e1 / t47 / t150 / t60 * t167 * t65
  t177 = t68 * t99
  t186 = 0.1e1 / t118 / t82 * t59
  t189 = 0.1e1 / t46 / t45 * t65
  t198 = 0.17111111111111111111111111111111111111111111111111e-1 * t49 * s0 * t145 * t78 + 0.13317258572493893926635198205368667140291974465589e-11 * t153 / t154 / t50 * t107 - 0.38022926632404150298293119657666430218370863626145e-20 * t163 * t169 / t52 / t154 / t70 / t68 - 0.19097859374738978516020627060563993032487429296439e-9 * t109 * t110 / t51 / t70 / t177 - 0.48148148148148148148148148148148148148148148148150e-2 * t186 * t189 / t51 / t177 + 0.88814814814814814814814814814814814814814814814818e-1 * t120 * t121 * t145
  t203 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t85 - t5 * t94 * t85 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t98 * t125 + t5 * t135 * t85 / 0.12e2 - t5 * t139 * t125 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t143 * t198)
  t205 = r1 <= f.p.dens_threshold
  t206 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t207 = 0.1e1 + t206
  t208 = t207 <= f.p.zeta_threshold
  t209 = t207 ** (0.1e1 / 0.3e1)
  t210 = t209 ** 2
  t211 = 0.1e1 / t210
  t213 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t214 = t213 ** 2
  t218 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t222 = f.my_piecewise3(t208, 0, 0.4e1 / 0.9e1 * t211 * t214 + 0.4e1 / 0.3e1 * t209 * t218)
  t224 = r1 ** 2
  t225 = r1 ** (0.1e1 / 0.3e1)
  t226 = t225 ** 2
  t230 = t49 * s2 / t226 / t224
  t233 = s2 ** 2
  t234 = t233 ** 2
  t236 = t224 ** 2
  t238 = t236 ** 2
  t253 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * (0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t230) / (0.1e1 - 0.17835614159590036508886426167904464920033894373557e-11 * t64 * t234 * s2 / t225 / t238 / t236 / r1) - 0.24371282051282051282051282051282051282051282051282e0 / (0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t230)
  t259 = f.my_piecewise3(t208, 0, 0.4e1 / 0.3e1 * t209 * t213)
  t265 = f.my_piecewise3(t208, t130, t209 * t207)
  t271 = f.my_piecewise3(t205, 0, -0.3e1 / 0.8e1 * t5 * t222 * t42 * t253 - t5 * t259 * t93 * t253 / 0.4e1 + t5 * t265 * t134 * t253 / 0.12e2)
  t281 = t24 ** 2
  t285 = 0.6e1 * t33 - 0.6e1 * t16 / t281
  t286 = f.my_piecewise5(t10, 0, t14, 0, t285)
  t290 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t286)
  t313 = 0.1e1 / t92 / t24
  t325 = 0.1e1 / t52 / t69
  t335 = t65 * s0
  t336 = t167 * t335
  t338 = t154 ** 2
  t340 = 0.1e1 / t51 / t338
  t354 = t106 ** 2
  t357 = t150 ** 2
  t363 = t70 * t99
  t380 = t118 ** 2
  t401 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t290 * t42 * t85 - 0.3e1 / 0.8e1 * t5 * t41 * t93 * t85 - 0.9e1 / 0.8e1 * t5 * t43 * t125 + t5 * t91 * t134 * t85 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t94 * t125 - 0.9e1 / 0.8e1 * t5 * t98 * t198 - 0.5e1 / 0.36e2 * t5 * t132 * t313 * t85 + t5 * t135 * t125 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t139 * t198 - 0.3e1 / 0.8e1 * t5 * t143 * (-0.79851851851851851851851851851851851851851851851851e-1 * t49 * s0 * t325 * t78 - 0.35956598145733513601915035154495401278788331057090e-10 * t153 / t154 / t99 * t107 - 0.63339062816665037657330927159106047262791033718592e-22 * t151 * t336 * t340 * t161 * t59 * t63 - 0.31669531408332518828665463579553023631395516859296e-22 * t59 / t46 / t150 / t61 * t336 * t340 * t161 + 0.16275893967215053587802303203181038686996074135325e-29 * t58 / t354 / t357 / t60 * t167 * t66 * t335 / t338 / t363 + 0.16349858451933784628266041452796564993899471359242e-18 * t163 * t169 / t52 / t154 / t71 + 0.29283384374599767057898294826198122649814058254540e-8 * t109 * t110 / t51 / t154 - 0.86136595310907237512742099898063200815494393476047e-2 / t380 / t60 * t335 / t363 + 0.52962962962962962962962962962962962962962962962965e-1 * t186 * t189 / t51 / t70 - 0.41446913580246913580246913580246913580246913580248e0 * t120 * t121 * t325))
  t411 = f.my_piecewise5(t14, 0, t10, 0, -t285)
  t415 = f.my_piecewise3(t208, 0, -0.8e1 / 0.27e2 / t210 / t207 * t214 * t213 + 0.4e1 / 0.3e1 * t211 * t213 * t218 + 0.4e1 / 0.3e1 * t209 * t411)
  t433 = f.my_piecewise3(t205, 0, -0.3e1 / 0.8e1 * t5 * t415 * t42 * t253 - 0.3e1 / 0.8e1 * t5 * t222 * t93 * t253 + t5 * t259 * t134 * t253 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t265 * t313 * t253)
  d111 = 0.3e1 * t203 + 0.3e1 * t271 + t6 * (t401 + t433)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = 0.1e1 / t59
  t61 = t56 * t60
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t68 = t61 * s0 / t64 / t62
  t70 = 0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t68
  t71 = t56 ** 2
  t72 = t57 ** 2
  t73 = t72 * t57
  t75 = 0.1e1 / t58 / t73
  t76 = t71 * t75
  t77 = s0 ** 2
  t78 = t77 ** 2
  t79 = t78 * s0
  t80 = t62 ** 2
  t81 = t80 * r0
  t82 = t80 ** 2
  t83 = t82 * t81
  t89 = 0.1e1 - 0.17835614159590036508886426167904464920033894373557e-11 * t76 * t79 / t63 / t83
  t90 = 0.1e1 / t89
  t94 = 0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t68
  t97 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * t70 * t90 - 0.24371282051282051282051282051282051282051282051282e0 / t94
  t106 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t107 = t54 ** 2
  t108 = 0.1e1 / t107
  t109 = t106 * t108
  t113 = t106 * t54
  t114 = t62 * r0
  t116 = 0.1e1 / t64 / t114
  t121 = t89 ** 2
  t122 = 0.1e1 / t121
  t124 = t70 * t122 * t71
  t125 = t75 * t79
  t126 = t80 * t62
  t127 = t82 * t126
  t133 = t94 ** 2
  t135 = 0.1e1 / t133 * t56
  t136 = t60 * s0
  t140 = -0.46666666666666666666666666666666666666666666666667e-2 * t61 * s0 * t116 * t90 + 0.13324087935864403615828344460858599790107508811469e-10 * t124 * t125 / t63 / t127 - 0.24222222222222222222222222222222222222222222222223e-1 * t135 * t136 * t116
  t146 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t148 = 0.1e1 / t107 / t6
  t149 = t146 * t148
  t153 = t146 * t108
  t157 = t146 * t54
  t159 = 0.1e1 / t64 / t80
  t164 = t72 ** 2
  t165 = 0.1e1 / t164
  t167 = t165 * t78 * t77
  t168 = t82 ** 2
  t175 = 0.1e1 / t121 / t89
  t177 = t70 * t175 * t56
  t180 = 0.1e1 / t59 / t164 / t72
  t181 = t78 ** 2
  t183 = t180 * t181 * t77
  t184 = t82 * t80
  t191 = t80 * t114
  t200 = 0.1e1 / t133 / t94 * t71
  t203 = 0.1e1 / t58 / t57 * t77
  t212 = 0.17111111111111111111111111111111111111111111111111e-1 * t61 * s0 * t159 * t90 + 0.13317258572493893926635198205368667140291974465589e-11 * t167 / t168 / t62 * t122 - 0.38022926632404150298293119657666430218370863626145e-20 * t177 * t183 / t64 / t168 / t184 - 0.19097859374738978516020627060563993032487429296439e-9 * t124 * t125 / t63 / t82 / t191 - 0.48148148148148148148148148148148148148148148148150e-2 * t200 * t203 / t63 / t191 + 0.88814814814814814814814814814814814814814814814818e-1 * t135 * t136 * t159
  t216 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t217 = t216 * f.p.zeta_threshold
  t219 = f.my_piecewise3(t20, t217, t21 * t19)
  t221 = 0.1e1 / t107 / t25
  t222 = t219 * t221
  t226 = t219 * t148
  t230 = t219 * t108
  t234 = t219 * t54
  t236 = 0.1e1 / t64 / t81
  t246 = t77 * s0
  t247 = t181 * t246
  t248 = t165 * t247
  t249 = t168 ** 2
  t251 = 0.1e1 / t63 / t249
  t254 = t175 * t71 * t75
  t260 = t71 / t58 / t164 / t73
  t265 = t121 ** 2
  t266 = 0.1e1 / t265
  t267 = t70 * t266
  t268 = t164 ** 2
  t269 = t268 * t72
  t270 = 0.1e1 / t269
  t273 = t270 * t181 * t78 * t246
  t274 = t82 * t114
  t291 = t133 ** 2
  t293 = 0.1e1 / t72
  t294 = 0.1e1 / t291 * t293
  t307 = -0.79851851851851851851851851851851851851851851851851e-1 * t61 * s0 * t236 * t90 - 0.35956598145733513601915035154495401278788331057090e-10 * t167 / t168 / t114 * t122 - 0.63339062816665037657330927159106047262791033718592e-22 * t248 * t251 * t254 - 0.31669531408332518828665463579553023631395516859296e-22 * t260 * t247 * t251 * t175 + 0.16275893967215053587802303203181038686996074135325e-29 * t267 * t273 / t249 / t274 + 0.16349858451933784628266041452796564993899471359242e-18 * t177 * t183 / t64 / t168 / t83 + 0.29283384374599767057898294826198122649814058254540e-8 * t124 * t125 / t63 / t168 - 0.86136595310907237512742099898063200815494393476047e-2 * t294 * t246 / t274 + 0.52962962962962962962962962962962962962962962962965e-1 * t200 * t203 / t63 / t82 - 0.41446913580246913580246913580246913580246913580248e0 * t135 * t136 * t236
  t312 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t97 - 0.3e1 / 0.8e1 * t5 * t109 * t97 - 0.9e1 / 0.8e1 * t5 * t113 * t140 + t5 * t149 * t97 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t153 * t140 - 0.9e1 / 0.8e1 * t5 * t157 * t212 - 0.5e1 / 0.36e2 * t5 * t222 * t97 + t5 * t226 * t140 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t230 * t212 - 0.3e1 / 0.8e1 * t5 * t234 * t307)
  t314 = r1 <= f.p.dens_threshold
  t315 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t316 = 0.1e1 + t315
  t317 = t316 <= f.p.zeta_threshold
  t318 = t316 ** (0.1e1 / 0.3e1)
  t319 = t318 ** 2
  t321 = 0.1e1 / t319 / t316
  t323 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t324 = t323 ** 2
  t328 = 0.1e1 / t319
  t329 = t328 * t323
  t331 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t335 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t339 = f.my_piecewise3(t317, 0, -0.8e1 / 0.27e2 * t321 * t324 * t323 + 0.4e1 / 0.3e1 * t329 * t331 + 0.4e1 / 0.3e1 * t318 * t335)
  t341 = r1 ** 2
  t342 = r1 ** (0.1e1 / 0.3e1)
  t343 = t342 ** 2
  t347 = t61 * s2 / t343 / t341
  t350 = s2 ** 2
  t351 = t350 ** 2
  t353 = t341 ** 2
  t355 = t353 ** 2
  t370 = 0.18040000000000000000000000000000000000000000000000e1 - 0.56028717948717948717948717948717948717948717948718e0 * (0.1e1 - 0.31233982573039466940030753459764223475140953357253e-2 * t347) / (0.1e1 - 0.17835614159590036508886426167904464920033894373557e-11 * t76 * t351 * s2 / t342 / t355 / t353 / r1) - 0.24371282051282051282051282051282051282051282051282e0 / (0.1e1 + 0.37270642201834862385321100917431192660550458715597e-1 * t347)
  t379 = f.my_piecewise3(t317, 0, 0.4e1 / 0.9e1 * t328 * t324 + 0.4e1 / 0.3e1 * t318 * t331)
  t386 = f.my_piecewise3(t317, 0, 0.4e1 / 0.3e1 * t318 * t323)
  t392 = f.my_piecewise3(t317, t217, t318 * t316)
  t398 = f.my_piecewise3(t314, 0, -0.3e1 / 0.8e1 * t5 * t339 * t54 * t370 - 0.3e1 / 0.8e1 * t5 * t379 * t108 * t370 + t5 * t386 * t148 * t370 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t392 * t221 * t370)
  t401 = 0.1e1 / t64 / t126
  t413 = 0.1e1 / t63 / t249 / r0
  t417 = t181 ** 2
  t421 = 0.1e1 / t64 / t249 / t127
  t448 = t82 * r0
  t496 = 0.45249382716049382716049382716049382716049382716049e0 * t61 * s0 * t401 * t90 + 0.84091089408314221316742034890122372620310323208825e-9 * t167 / t168 / t80 * t122 + 0.37581177271221255676683016781069588042589346673031e-20 * t248 * t413 * t254 + 0.27112586055073769431244226248251345839434772393546e-31 * t165 * t417 * t421 * t266 * t56 * t180 + 0.23857713660943830850927982563263277802317956034003e-20 * t260 * t247 * t413 * t175 + 0.13556293027536884715622113124125672919717386196773e-31 * t56 / t59 / t269 * t417 * t421 * t266 + 0.13556293027536884715622113124125672919717386196773e-31 * t61 * t417 * t421 * t266 * t270 - 0.15482163461421166038611825265387966323975925571331e-39 * t70 / t265 / t89 * t270 * t417 * t78 / t63 / t249 / t168 / t448 * t76 - 0.13997268811804946085509980754735693270816623756380e-27 * t267 * t273 / t249 / t184 - 0.56861174393947495429414121941392498256561494838253e-17 * t177 * t183 / t64 / t168 / t127 - 0.47829527811846286194567214882790266994696295149082e-7 * t124 * t125 / t63 / t168 / r0 - 0.34243906392715415524943342467119926929707251229010e-2 / t291 / t94 * t293 * t78 / t64 / t127 * t56 * t60 + 0.18950050968399592252803261977573904179408766564730e0 * t294 * t246 / t184 - 0.52374485596707818930041152263374485596707818930042e0 * t200 * t203 / t63 / t448 + 0.23486584362139917695473251028806584362139917695474e1 * t135 * t136 * t401
  t512 = t19 ** 2
  t515 = t30 ** 2
  t521 = t41 ** 2
  t530 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t531 = f.my_piecewise5(t10, 0, t14, 0, t530)
  t535 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t512 * t515 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t521 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t531)
  t567 = 0.1e1 / t107 / t36
  t572 = -0.3e1 / 0.8e1 * t5 * t234 * t496 - 0.3e1 / 0.2e1 * t5 * t157 * t307 - 0.5e1 / 0.9e1 * t5 * t222 * t140 + t5 * t226 * t212 / 0.2e1 - t5 * t230 * t307 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t535 * t54 * t97 - 0.3e1 / 0.2e1 * t5 * t55 * t140 - 0.3e1 / 0.2e1 * t5 * t109 * t140 - 0.9e1 / 0.4e1 * t5 * t113 * t212 + t5 * t149 * t140 - 0.3e1 / 0.2e1 * t5 * t153 * t212 - t5 * t53 * t108 * t97 / 0.2e1 + t5 * t106 * t148 * t97 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t146 * t221 * t97 + 0.10e2 / 0.27e2 * t5 * t219 * t567 * t97
  t573 = f.my_piecewise3(t1, 0, t572)
  t574 = t316 ** 2
  t577 = t324 ** 2
  t583 = t331 ** 2
  t589 = f.my_piecewise5(t14, 0, t10, 0, -t530)
  t593 = f.my_piecewise3(t317, 0, 0.40e2 / 0.81e2 / t319 / t574 * t577 - 0.16e2 / 0.9e1 * t321 * t324 * t331 + 0.4e1 / 0.3e1 * t328 * t583 + 0.16e2 / 0.9e1 * t329 * t335 + 0.4e1 / 0.3e1 * t318 * t589)
  t615 = f.my_piecewise3(t314, 0, -0.3e1 / 0.8e1 * t5 * t593 * t54 * t370 - t5 * t339 * t108 * t370 / 0.2e1 + t5 * t379 * t148 * t370 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t386 * t221 * t370 + 0.10e2 / 0.27e2 * t5 * t392 * t567 * t370)
  d1111 = 0.4e1 * t312 + 0.4e1 * t398 + t6 * (t573 + t615)

  res = {'v4rho4': d1111}
  return res
