"""Generated from gga_x_wc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  wc_f = lambda x: wc_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, wc_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  wc_f = lambda x: wc_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, wc_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  wc_f = lambda x: wc_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, wc_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = t28 / t31
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t40 = t33 * t39
  t43 = jnp.exp(-t40 / 0.24e2)
  t47 = t28 ** 2
  t50 = t47 / t30 / t29
  t51 = s0 ** 2
  t52 = t34 ** 2
  t55 = 0.1e1 / t35 / t52 / r0
  t59 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t50 * t51 * t55
  t60 = jnp.log(t59)
  t61 = 0.8040e0 + 0.5e1 / 0.972e3 * t40 + 0.40024242767108462448559670781893004115226337448558e-2 * t33 * t39 * t43 + t60
  t64 = 0.18040e1 - 0.64641600e0 / t61
  t68 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t25 * t26 * t64)
  t69 = r1 <= f.p.dens_threshold
  t70 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t71 = 0.1e1 + t70
  t72 = t71 <= f.p.zeta_threshold
  t73 = t71 ** (0.1e1 / 0.3e1)
  t75 = f.my_piecewise3(t72, t22, t73 * t71)
  t77 = r1 ** 2
  t78 = r1 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t81 = 0.1e1 / t79 / t77
  t82 = s2 * t81
  t83 = t33 * t82
  t86 = jnp.exp(-t83 / 0.24e2)
  t90 = s2 ** 2
  t91 = t77 ** 2
  t94 = 0.1e1 / t78 / t91 / r1
  t98 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t50 * t90 * t94
  t99 = jnp.log(t98)
  t100 = 0.8040e0 + 0.5e1 / 0.972e3 * t83 + 0.40024242767108462448559670781893004115226337448558e-2 * t33 * t82 * t86 + t99
  t103 = 0.18040e1 - 0.64641600e0 / t100
  t107 = f.my_piecewise3(t69, 0, -0.3e1 / 0.8e1 * t5 * t75 * t26 * t103)
  t108 = t6 ** 2
  t110 = t16 / t108
  t111 = t7 - t110
  t112 = f.my_piecewise5(t10, 0, t14, 0, t111)
  t115 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t112)
  t120 = t26 ** 2
  t121 = 0.1e1 / t120
  t125 = t5 * t25 * t121 * t64 / 0.8e1
  t126 = t5 * t25
  t127 = t61 ** 2
  t129 = t26 / t127
  t133 = s0 / t36 / t34 / r0
  t142 = t51 / t35 / t52 / t34
  t146 = 0.1e1 / t59
  t155 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t115 * t26 * t64 - t125 - 0.24240600000000000000000000000000000000000000000000e0 * t126 * t129 * (-0.10e2 / 0.729e3 * t33 * t133 - 0.10673131404562256652949245541838134430727023319615e-1 * t33 * t133 * t43 + 0.44471380852342736053955189757658893461362597165064e-3 * t50 * t142 * t43 - 0.73495086436683507341360564954529289234364680180832e-4 * t50 * t142 * t146))
  t157 = f.my_piecewise5(t14, 0, t10, 0, -t111)
  t160 = f.my_piecewise3(t72, 0, 0.4e1 / 0.3e1 * t73 * t157)
  t168 = t5 * t75 * t121 * t103 / 0.8e1
  t170 = f.my_piecewise3(t69, 0, -0.3e1 / 0.8e1 * t5 * t160 * t26 * t103 - t168)
  vrho_0_ = t68 + t107 + t6 * (t155 + t170)
  t173 = -t7 - t110
  t174 = f.my_piecewise5(t10, 0, t14, 0, t173)
  t177 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t174)
  t183 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t177 * t26 * t64 - t125)
  t185 = f.my_piecewise5(t14, 0, t10, 0, -t173)
  t188 = f.my_piecewise3(t72, 0, 0.4e1 / 0.3e1 * t73 * t185)
  t193 = t5 * t75
  t194 = t100 ** 2
  t196 = t26 / t194
  t200 = s2 / t79 / t77 / r1
  t209 = t90 / t78 / t91 / t77
  t213 = 0.1e1 / t98
  t222 = f.my_piecewise3(t69, 0, -0.3e1 / 0.8e1 * t5 * t188 * t26 * t103 - t168 - 0.24240600000000000000000000000000000000000000000000e0 * t193 * t196 * (-0.10e2 / 0.729e3 * t33 * t200 - 0.10673131404562256652949245541838134430727023319615e-1 * t33 * t200 * t86 + 0.44471380852342736053955189757658893461362597165064e-3 * t50 * t209 * t86 - 0.73495086436683507341360564954529289234364680180832e-4 * t50 * t209 * t213))
  vrho_1_ = t68 + t107 + t6 * (t183 + t222)
  t230 = s0 * t55
  t241 = f.my_piecewise3(t1, 0, -0.24240600000000000000000000000000000000000000000000e0 * t126 * t129 * (0.5e1 / 0.972e3 * t33 * t38 + 0.40024242767108462448559670781893004115226337448558e-2 * t33 * t38 * t43 - 0.16676767819628526020233196159122085048010973936899e-3 * t50 * t230 * t43 + 0.27560657413756315253010211857948483462886755067812e-4 * t50 * t230 * t146))
  vsigma_0_ = t6 * t241
  vsigma_1_ = 0.0e0
  t247 = s2 * t94
  t258 = f.my_piecewise3(t69, 0, -0.24240600000000000000000000000000000000000000000000e0 * t193 * t196 * (0.5e1 / 0.972e3 * t33 * t81 + 0.40024242767108462448559670781893004115226337448558e-2 * t33 * t81 * t86 - 0.16676767819628526020233196159122085048010973936899e-3 * t50 * t247 * t86 + 0.27560657413756315253010211857948483462886755067812e-4 * t50 * t247 * t213))
  vsigma_2_ = t6 * t258
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  wc_mu = 0.2195149727645171

  wc_kappa = KAPPA_PBE

  wc_c = 146 / 2025 * (4 / 9) - 73 / 405 * (2 / 3) + (wc_mu - MU_GE)

  wc_f0_aux = lambda s: wc_kappa + MU_GE * s ** 2 + (wc_mu - MU_GE) * s ** 2 * jnp.exp(-s ** 2) + jnp.log(1 + wc_c * s ** 4)

  wc_f0 = lambda s: 1 + wc_kappa * (1 - wc_kappa / wc_f0_aux(s))

  wc_f = lambda x: wc_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, wc_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = t20 / t23
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t34 = t25 * t28 * t32
  t36 = t25 * s0
  t37 = t27 * t32
  t39 = jnp.exp(-t34 / 0.24e2)
  t40 = t37 * t39
  t43 = t20 ** 2
  t46 = t43 / t22 / t21
  t47 = s0 ** 2
  t49 = t29 ** 2
  t52 = 0.1e1 / t18 / t49 / r0
  t56 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t46 * t47 * t26 * t52
  t57 = jnp.log(t56)
  t58 = 0.8040e0 + 0.5e1 / 0.972e3 * t34 + 0.40024242767108462448559670781893004115226337448558e-2 * t36 * t40 + t57
  t61 = 0.18040e1 - 0.64641600e0 / t58
  t65 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t17 * t18 * t61)
  t71 = t6 * t17
  t72 = t58 ** 2
  t74 = t18 / t72
  t77 = 0.1e1 / t30 / t29 / r0
  t85 = t46 * t47
  t89 = t26 / t18 / t49 / t29
  t93 = 0.1e1 / t56
  t102 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t61 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t71 * t74 * (-0.10e2 / 0.729e3 * t25 * t28 * t77 - 0.10673131404562256652949245541838134430727023319615e-1 * t36 * t27 * t77 * t39 + 0.88942761704685472107910379515317786922725194330129e-3 * t85 * t89 * t39 - 0.14699017287336701468272112990905857846872936036166e-3 * t85 * t89 * t93))
  vrho_0_ = 0.2e1 * r0 * t102 + 0.2e1 * t65
  t109 = t46 * s0
  t110 = t26 * t52
  t121 = f.my_piecewise3(t2, 0, -0.24240600000000000000000000000000000000000000000000e0 * t71 * t74 * (0.5e1 / 0.972e3 * t25 * t37 + 0.40024242767108462448559670781893004115226337448558e-2 * t25 * t40 - 0.33353535639257052040466392318244170096021947873798e-3 * t109 * t110 * t39 + 0.55121314827512630506020423715896966925773510135624e-4 * t109 * t110 * t93))
  vsigma_0_ = 0.2e1 * r0 * t121
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = 0.1e1 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t35 = t27 * t30 * t33
  t37 = t27 * s0
  t38 = t29 * t33
  t40 = jnp.exp(-t35 / 0.24e2)
  t41 = t38 * t40
  t44 = t22 ** 2
  t47 = t44 / t24 / t23
  t48 = s0 ** 2
  t50 = t31 ** 2
  t53 = 0.1e1 / t18 / t50 / r0
  t57 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t47 * t48 * t28 * t53
  t58 = jnp.log(t57)
  t59 = 0.8040e0 + 0.5e1 / 0.972e3 * t35 + 0.40024242767108462448559670781893004115226337448558e-2 * t37 * t41 + t58
  t62 = 0.18040e1 - 0.64641600e0 / t59
  t66 = t6 * t17
  t67 = t59 ** 2
  t68 = 0.1e1 / t67
  t69 = t18 * t68
  t70 = t31 * r0
  t72 = 0.1e1 / t19 / t70
  t76 = t29 * t72
  t77 = t76 * t40
  t80 = t47 * t48
  t83 = 0.1e1 / t18 / t50 / t31
  t84 = t28 * t83
  t88 = 0.1e1 / t57
  t89 = t84 * t88
  t92 = -0.10e2 / 0.729e3 * t27 * t30 * t72 - 0.10673131404562256652949245541838134430727023319615e-1 * t37 * t77 + 0.88942761704685472107910379515317786922725194330129e-3 * t80 * t84 * t40 - 0.14699017287336701468272112990905857846872936036166e-3 * t80 * t89
  t97 = f.my_piecewise3(t2, 0, -t6 * t17 * t20 * t62 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t66 * t69 * t92)
  t105 = t20 * t68
  t111 = t18 / t67 / t59
  t112 = t92 ** 2
  t117 = 0.1e1 / t19 / t50
  t128 = t28 / t18 / t50 / t70
  t132 = t23 ** 2
  t133 = 0.1e1 / t132
  t134 = t48 * s0
  t136 = t50 ** 2
  t137 = t136 * t31
  t147 = t22 / t25 / t132
  t148 = t48 ** 2
  t154 = t57 ** 2
  t155 = 0.1e1 / t154
  t164 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t62 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t66 * t105 * t92 + 0.48481200000000000000000000000000000000000000000000e0 * t66 * t111 * t112 - 0.24240600000000000000000000000000000000000000000000e0 * t66 * t69 * (0.110e3 / 0.2187e4 * t27 * t30 * t117 + 0.39134815150061607727480566986739826245999085505255e-1 * t37 * t29 * t117 * t40 - 0.80048485534216924897119341563786008230452674897115e-2 * t80 * t128 * t40 + 0.11859034893958062947721383935375704923030025910684e-2 * t133 * t134 / t137 * t40 + 0.93093776153132442632390048942403766363528594895718e-3 * t80 * t128 * t88 - 0.12963666552805392106469610577525293196354413769776e-6 * t147 * t148 * t29 / t19 / t136 / t50 * t155))
  v2rho2_0_ = 0.2e1 * r0 * t164 + 0.4e1 * t97
  t171 = t47 * s0
  t172 = t28 * t53
  t173 = t172 * t40
  t176 = t172 * t88
  t179 = 0.5e1 / 0.972e3 * t27 * t38 + 0.40024242767108462448559670781893004115226337448558e-2 * t27 * t41 - 0.33353535639257052040466392318244170096021947873798e-3 * t171 * t173 + 0.55121314827512630506020423715896966925773510135624e-4 * t171 * t176
  t183 = f.my_piecewise3(t2, 0, -0.24240600000000000000000000000000000000000000000000e0 * t66 * t69 * t179)
  t221 = f.my_piecewise3(t2, 0, -0.80802000000000000000000000000000000000000000000000e-1 * t66 * t105 * t179 + 0.48481200000000000000000000000000000000000000000000e0 * t66 * t111 * t179 * t92 - 0.24240600000000000000000000000000000000000000000000e0 * t66 * t69 * (-0.10e2 / 0.729e3 * t27 * t76 - 0.10673131404562256652949245541838134430727023319615e-1 * t27 * t77 + 0.26682828511405641632373113854595336076817558299039e-2 * t47 * t28 * t83 * s0 * t40 - 0.44471380852342736053955189757658893461362597165064e-3 * t133 * t48 / t136 / r0 * t40 - 0.29398034574673402936544225981811715693745872072333e-3 * t171 * t89 + 0.48613749573020220399261039665719849486329051636662e-7 * t147 * t134 * t29 / t19 / t136 / t70 * t155))
  v2rhosigma_0_ = 0.2e1 * r0 * t221 + 0.2e1 * t183
  t224 = t179 ** 2
  t249 = f.my_piecewise3(t2, 0, 0.48481200000000000000000000000000000000000000000000e0 * t66 * t111 * t224 - 0.24240600000000000000000000000000000000000000000000e0 * t66 * t69 * (-0.66707071278514104080932784636488340192043895747596e-3 * t47 * t173 + 0.16676767819628526020233196159122085048010973936899e-3 * t133 * s0 / t136 * t40 + 0.55121314827512630506020423715896966925773510135624e-4 * t47 * t176 - 0.18230156089882582649722889874644943557373394363748e-7 * t147 * t48 * t29 / t19 / t137 * t155))
  v2sigma2_0_ = 0.2e1 * r0 * t249
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = t23 / t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t36 = t28 * t31 * t34
  t38 = t28 * s0
  t41 = jnp.exp(-t36 / 0.24e2)
  t45 = t23 ** 2
  t48 = t45 / t25 / t24
  t49 = s0 ** 2
  t51 = t32 ** 2
  t52 = t51 * r0
  t58 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t48 * t49 * t29 / t18 / t52
  t59 = jnp.log(t58)
  t60 = 0.8040e0 + 0.5e1 / 0.972e3 * t36 + 0.40024242767108462448559670781893004115226337448558e-2 * t38 * t30 * t34 * t41 + t59
  t63 = 0.18040e1 - 0.64641600e0 / t60
  t67 = t6 * t17
  t68 = 0.1e1 / t19
  t69 = t60 ** 2
  t70 = 0.1e1 / t69
  t71 = t68 * t70
  t72 = t32 * r0
  t74 = 0.1e1 / t19 / t72
  t82 = t48 * t49
  t86 = t29 / t18 / t51 / t32
  t90 = 0.1e1 / t58
  t94 = -0.10e2 / 0.729e3 * t28 * t31 * t74 - 0.10673131404562256652949245541838134430727023319615e-1 * t38 * t30 * t74 * t41 + 0.88942761704685472107910379515317786922725194330129e-3 * t82 * t86 * t41 - 0.14699017287336701468272112990905857846872936036166e-3 * t82 * t86 * t90
  t99 = 0.1e1 / t69 / t60
  t100 = t18 * t99
  t101 = t94 ** 2
  t105 = t18 * t70
  t107 = 0.1e1 / t19 / t51
  t118 = t29 / t18 / t51 / t72
  t122 = t24 ** 2
  t123 = 0.1e1 / t122
  t125 = t123 * t49 * s0
  t126 = t51 ** 2
  t138 = t49 ** 2
  t139 = t23 / t26 / t122 * t138
  t144 = t58 ** 2
  t145 = 0.1e1 / t144
  t149 = 0.110e3 / 0.2187e4 * t28 * t31 * t107 + 0.39134815150061607727480566986739826245999085505255e-1 * t38 * t30 * t107 * t41 - 0.80048485534216924897119341563786008230452674897115e-2 * t82 * t118 * t41 + 0.11859034893958062947721383935375704923030025910684e-2 * t125 / t126 / t32 * t41 + 0.93093776153132442632390048942403766363528594895718e-3 * t82 * t118 * t90 - 0.12963666552805392106469610577525293196354413769776e-6 * t139 * t30 / t19 / t126 / t51 * t145
  t154 = f.my_piecewise3(t2, 0, t6 * t17 * t21 * t63 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t67 * t71 * t94 + 0.48481200000000000000000000000000000000000000000000e0 * t67 * t100 * t101 - 0.24240600000000000000000000000000000000000000000000e0 * t67 * t105 * t149)
  t171 = t69 ** 2
  t183 = 0.1e1 / t19 / t52
  t193 = t29 / t18 / t126
  t205 = 0.1e1 / t19 / t126 / t52
  t218 = t122 ** 2
  t222 = t126 ** 2
  t235 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t63 + 0.16160400000000000000000000000000000000000000000000e0 * t67 * t21 * t70 * t94 + 0.48481200000000000000000000000000000000000000000000e0 * t67 * t68 * t99 * t101 - 0.24240600000000000000000000000000000000000000000000e0 * t67 * t71 * t149 - 0.14544360000000000000000000000000000000000000000000e1 * t67 * t18 / t171 * t101 * t94 + 0.14544360000000000000000000000000000000000000000000e1 * t67 * t100 * t94 * t149 - 0.24240600000000000000000000000000000000000000000000e0 * t67 * t105 * (-0.1540e4 / 0.6561e4 * t28 * t31 * t183 - 0.18262913736695416939490931260478585581466239902452e0 * t38 * t30 * t183 * t41 + 0.67398848313994991086216532032718589645887313925718e-1 * t82 * t193 * t41 - 0.22532166298520319600670629477213839353757049230299e-1 * t125 / t126 / t72 * t41 + 0.13176705437731181053023759928195227692255584345204e-3 * t123 * t138 * t205 * t28 * t30 * t41 - 0.68268769178963791263752702557762761999920969590193e-2 * t82 * t193 * t90 + 0.24630966450330245002292260097298057073073386162575e-5 * t139 * t30 * t205 * t145 - 0.45732758104069210195759153809253530181707585823428e-9 / t218 * t138 * t49 / t222 / t72 / t144 / t58))
  v3rho3_0_ = 0.2e1 * r0 * t235 + 0.6e1 * t154

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t34 = t29 * t32 * t22
  t36 = t29 * s0
  t39 = jnp.exp(-t34 / 0.24e2)
  t43 = t24 ** 2
  t45 = 0.1e1 / t26 / t25
  t46 = t43 * t45
  t47 = s0 ** 2
  t49 = t18 ** 2
  t50 = t49 * r0
  t56 = 0.1e1 + 0.27560657413756315253010211857948483462886755067812e-4 * t46 * t47 * t30 / t19 / t50
  t57 = jnp.log(t56)
  t58 = 0.8040e0 + 0.5e1 / 0.972e3 * t34 + 0.40024242767108462448559670781893004115226337448558e-2 * t36 * t31 * t22 * t39 + t57
  t61 = 0.18040e1 - 0.64641600e0 / t58
  t65 = t6 * t17
  t67 = 0.1e1 / t20 / r0
  t68 = t58 ** 2
  t69 = 0.1e1 / t68
  t70 = t67 * t69
  t71 = t18 * r0
  t73 = 0.1e1 / t20 / t71
  t81 = t46 * t47
  t82 = t49 * t18
  t85 = t30 / t19 / t82
  t89 = 0.1e1 / t56
  t93 = -0.10e2 / 0.729e3 * t29 * t32 * t73 - 0.10673131404562256652949245541838134430727023319615e-1 * t36 * t31 * t73 * t39 + 0.88942761704685472107910379515317786922725194330129e-3 * t81 * t85 * t39 - 0.14699017287336701468272112990905857846872936036166e-3 * t81 * t85 * t89
  t97 = 0.1e1 / t20
  t99 = 0.1e1 / t68 / t58
  t100 = t97 * t99
  t101 = t93 ** 2
  t105 = t97 * t69
  t107 = 0.1e1 / t20 / t49
  t118 = t30 / t19 / t49 / t71
  t122 = t25 ** 2
  t123 = 0.1e1 / t122
  t125 = t123 * t47 * s0
  t126 = t49 ** 2
  t138 = t47 ** 2
  t139 = t24 / t27 / t122 * t138
  t140 = t126 * t49
  t144 = t56 ** 2
  t145 = 0.1e1 / t144
  t149 = 0.110e3 / 0.2187e4 * t29 * t32 * t107 + 0.39134815150061607727480566986739826245999085505255e-1 * t36 * t31 * t107 * t39 - 0.80048485534216924897119341563786008230452674897115e-2 * t81 * t118 * t39 + 0.11859034893958062947721383935375704923030025910684e-2 * t125 / t126 / t18 * t39 + 0.93093776153132442632390048942403766363528594895718e-3 * t81 * t118 * t89 - 0.12963666552805392106469610577525293196354413769776e-6 * t139 * t31 / t20 / t140 * t145
  t153 = t68 ** 2
  t154 = 0.1e1 / t153
  t155 = t19 * t154
  t156 = t101 * t93
  t160 = t19 * t99
  t161 = t93 * t149
  t165 = t19 * t69
  t167 = 0.1e1 / t20 / t50
  t177 = t30 / t19 / t126
  t186 = t123 * t138
  t189 = 0.1e1 / t20 / t126 / t50
  t192 = t29 * t31 * t39
  t202 = t122 ** 2
  t203 = 0.1e1 / t202
  t205 = t203 * t138 * t47
  t206 = t126 ** 2
  t210 = 0.1e1 / t144 / t56
  t214 = -0.1540e4 / 0.6561e4 * t29 * t32 * t167 - 0.18262913736695416939490931260478585581466239902452e0 * t36 * t31 * t167 * t39 + 0.67398848313994991086216532032718589645887313925718e-1 * t81 * t177 * t39 - 0.22532166298520319600670629477213839353757049230299e-1 * t125 / t126 / t71 * t39 + 0.13176705437731181053023759928195227692255584345204e-3 * t186 * t189 * t192 - 0.68268769178963791263752702557762761999920969590193e-2 * t81 * t177 * t89 + 0.24630966450330245002292260097298057073073386162575e-5 * t139 * t31 * t189 * t145 - 0.45732758104069210195759153809253530181707585823428e-9 * t205 / t206 / t71 * t210
  t219 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t22 * t61 + 0.16160400000000000000000000000000000000000000000000e0 * t65 * t70 * t93 + 0.48481200000000000000000000000000000000000000000000e0 * t65 * t100 * t101 - 0.24240600000000000000000000000000000000000000000000e0 * t65 * t105 * t149 - 0.14544360000000000000000000000000000000000000000000e1 * t65 * t155 * t156 + 0.14544360000000000000000000000000000000000000000000e1 * t65 * t160 * t161 - 0.24240600000000000000000000000000000000000000000000e0 * t65 * t165 * t214)
  t249 = t101 ** 2
  t257 = t149 ** 2
  t266 = 0.1e1 / t20 / t82
  t274 = t126 * r0
  t277 = t30 / t19 / t274
  t287 = 0.1e1 / t20 / t126 / t82
  t313 = t138 ** 2
  t319 = t144 ** 2
  t330 = 0.10e2 / 0.27e2 * t6 * t17 * t73 * t61 - 0.35912000000000000000000000000000000000000000000000e0 * t65 * t22 * t69 * t93 - 0.64641600000000000000000000000000000000000000000000e0 * t65 * t67 * t99 * t101 + 0.32320800000000000000000000000000000000000000000000e0 * t65 * t70 * t149 - 0.19392480000000000000000000000000000000000000000000e1 * t65 * t97 * t154 * t156 + 0.19392480000000000000000000000000000000000000000000e1 * t65 * t100 * t161 - 0.32320800000000000000000000000000000000000000000000e0 * t65 * t105 * t214 + 0.58177440000000000000000000000000000000000000000000e1 * t65 * t19 / t153 / t58 * t249 - 0.87266160000000000000000000000000000000000000000000e1 * t65 * t155 * t101 * t149 + 0.14544360000000000000000000000000000000000000000000e1 * t65 * t160 * t257 + 0.19392480000000000000000000000000000000000000000000e1 * t65 * t160 * t93 * t214 - 0.24240600000000000000000000000000000000000000000000e0 * t65 * t165 * (0.26180e5 / 0.19683e5 * t29 * t32 * t266 + 0.10348984450794069599044861047604531829497535944723e1 * t36 * t31 * t266 * t39 - 0.60224132203150363002845094751816288167454148249755e0 * t81 * t277 * t39 + 0.33771896036905017038899896695964368575251062676758e0 * t125 / t140 * t39 - 0.43043904429921858106544282432104410461368242194334e-2 * t186 * t287 * t192 + 0.29281567639402624562275022062656061538345742989342e-4 * t123 * t138 * s0 / t19 / t206 / r0 * t46 * t30 * t39 + 0.56890640982469826053127252131468968333267474658494e-1 * t81 * t277 * t89 - 0.39683223725532061392581974601202425284396011039704e-4 * t139 * t31 * t287 * t145 + 0.17378448079546299874388478447516341469048882612903e-7 * t205 / t206 / t49 * t210 - 0.20166798059079028575410218001018837907291869118661e-12 * t203 * t313 / t19 / t206 / t274 / t319 * t43 * t45 * t30)
  t331 = f.my_piecewise3(t2, 0, t330)
  v4rho4_0_ = 0.2e1 * r0 * t331 + 0.8e1 * t219

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t43 = s0 / t40 / t38
  t44 = t37 * t43
  t47 = jnp.exp(-t44 / 0.24e2)
  t51 = t32 ** 2
  t54 = t51 / t34 / t33
  t55 = s0 ** 2
  t56 = t38 ** 2
  t63 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t54 * t55 / t39 / t56 / r0
  t64 = jnp.log(t63)
  t65 = 0.8040e0 + 0.5e1 / 0.972e3 * t44 + 0.40024242767108462448559670781893004115226337448558e-2 * t37 * t43 * t47 + t64
  t68 = 0.18040e1 - 0.64641600e0 / t65
  t72 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t73 = t72 * f.p.zeta_threshold
  t75 = f.my_piecewise3(t20, t73, t21 * t19)
  t76 = t30 ** 2
  t77 = 0.1e1 / t76
  t81 = t5 * t75 * t77 * t68 / 0.8e1
  t82 = t5 * t75
  t83 = t65 ** 2
  t84 = 0.1e1 / t83
  t85 = t30 * t84
  t86 = t38 * r0
  t89 = s0 / t40 / t86
  t98 = t55 / t39 / t56 / t38
  t102 = 0.1e1 / t63
  t106 = -0.10e2 / 0.729e3 * t37 * t89 - 0.10673131404562256652949245541838134430727023319615e-1 * t37 * t89 * t47 + 0.44471380852342736053955189757658893461362597165064e-3 * t54 * t98 * t47 - 0.73495086436683507341360564954529289234364680180832e-4 * t54 * t98 * t102
  t107 = t85 * t106
  t111 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t29 * t30 * t68 - t81 - 0.24240600000000000000000000000000000000000000000000e0 * t82 * t107)
  t113 = r1 <= f.p.dens_threshold
  t114 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t115 = 0.1e1 + t114
  t116 = t115 <= f.p.zeta_threshold
  t117 = t115 ** (0.1e1 / 0.3e1)
  t119 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t122 = f.my_piecewise3(t116, 0, 0.4e1 / 0.3e1 * t117 * t119)
  t124 = r1 ** 2
  t125 = r1 ** (0.1e1 / 0.3e1)
  t126 = t125 ** 2
  t129 = s2 / t126 / t124
  t130 = t37 * t129
  t133 = jnp.exp(-t130 / 0.24e2)
  t137 = s2 ** 2
  t138 = t124 ** 2
  t145 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t54 * t137 / t125 / t138 / r1
  t146 = jnp.log(t145)
  t147 = 0.8040e0 + 0.5e1 / 0.972e3 * t130 + 0.40024242767108462448559670781893004115226337448558e-2 * t37 * t129 * t133 + t146
  t150 = 0.18040e1 - 0.64641600e0 / t147
  t155 = f.my_piecewise3(t116, t73, t117 * t115)
  t159 = t5 * t155 * t77 * t150 / 0.8e1
  t161 = f.my_piecewise3(t113, 0, -0.3e1 / 0.8e1 * t5 * t122 * t30 * t150 - t159)
  t163 = t21 ** 2
  t164 = 0.1e1 / t163
  t165 = t26 ** 2
  t170 = t16 / t22 / t6
  t172 = -0.2e1 * t23 + 0.2e1 * t170
  t173 = f.my_piecewise5(t10, 0, t14, 0, t172)
  t177 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t164 * t165 + 0.4e1 / 0.3e1 * t21 * t173)
  t184 = t5 * t29 * t77 * t68
  t190 = 0.1e1 / t76 / t6
  t194 = t5 * t75 * t190 * t68 / 0.12e2
  t197 = t82 * t77 * t84 * t106
  t202 = t106 ** 2
  t208 = s0 / t40 / t56
  t217 = t55 / t39 / t56 / t86
  t221 = t33 ** 2
  t222 = 0.1e1 / t221
  t225 = t56 ** 2
  t236 = t32 / t35 / t221
  t237 = t55 ** 2
  t242 = t63 ** 2
  t252 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t177 * t30 * t68 - t184 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t5 * t29 * t107 + t194 - 0.16160400000000000000000000000000000000000000000000e0 * t197 + 0.48481200000000000000000000000000000000000000000000e0 * t82 * t30 / t83 / t65 * t202 - 0.24240600000000000000000000000000000000000000000000e0 * t82 * t85 * (0.110e3 / 0.2187e4 * t37 * t208 + 0.39134815150061607727480566986739826245999085505255e-1 * t37 * t208 * t47 - 0.40024242767108462448559670781893004115226337448557e-2 * t54 * t217 * t47 + 0.29647587234895157369303459838439262307575064776709e-3 * t222 * t55 * s0 / t225 / t38 * t47 + 0.46546888076566221316195024471201883181764297447860e-3 * t54 * t217 * t102 - 0.32409166382013480266174026443813232990886034424442e-7 * t236 * t237 / t40 / t225 / t56 / t242))
  t253 = t117 ** 2
  t254 = 0.1e1 / t253
  t255 = t119 ** 2
  t259 = f.my_piecewise5(t14, 0, t10, 0, -t172)
  t263 = f.my_piecewise3(t116, 0, 0.4e1 / 0.9e1 * t254 * t255 + 0.4e1 / 0.3e1 * t117 * t259)
  t270 = t5 * t122 * t77 * t150
  t275 = t5 * t155 * t190 * t150 / 0.12e2
  t277 = f.my_piecewise3(t113, 0, -0.3e1 / 0.8e1 * t5 * t263 * t30 * t150 - t270 / 0.4e1 + t275)
  d11 = 0.2e1 * t111 + 0.2e1 * t161 + t6 * (t252 + t277)
  t280 = -t7 - t24
  t281 = f.my_piecewise5(t10, 0, t14, 0, t280)
  t284 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t281)
  t290 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t284 * t30 * t68 - t81)
  t292 = f.my_piecewise5(t14, 0, t10, 0, -t280)
  t295 = f.my_piecewise3(t116, 0, 0.4e1 / 0.3e1 * t117 * t292)
  t300 = t5 * t155
  t301 = t147 ** 2
  t302 = 0.1e1 / t301
  t303 = t30 * t302
  t304 = t124 * r1
  t307 = s2 / t126 / t304
  t316 = t137 / t125 / t138 / t124
  t320 = 0.1e1 / t145
  t324 = -0.10e2 / 0.729e3 * t37 * t307 - 0.10673131404562256652949245541838134430727023319615e-1 * t37 * t307 * t133 + 0.44471380852342736053955189757658893461362597165064e-3 * t54 * t316 * t133 - 0.73495086436683507341360564954529289234364680180832e-4 * t54 * t316 * t320
  t325 = t303 * t324
  t329 = f.my_piecewise3(t113, 0, -0.3e1 / 0.8e1 * t5 * t295 * t30 * t150 - t159 - 0.24240600000000000000000000000000000000000000000000e0 * t300 * t325)
  t333 = 0.2e1 * t170
  t334 = f.my_piecewise5(t10, 0, t14, 0, t333)
  t338 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t164 * t281 * t26 + 0.4e1 / 0.3e1 * t21 * t334)
  t345 = t5 * t284 * t77 * t68
  t353 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t338 * t30 * t68 - t345 / 0.8e1 - 0.24240600000000000000000000000000000000000000000000e0 * t5 * t284 * t107 - t184 / 0.8e1 + t194 - 0.80802000000000000000000000000000000000000000000000e-1 * t197)
  t357 = f.my_piecewise5(t14, 0, t10, 0, -t333)
  t361 = f.my_piecewise3(t116, 0, 0.4e1 / 0.9e1 * t254 * t292 * t119 + 0.4e1 / 0.3e1 * t117 * t357)
  t368 = t5 * t295 * t77 * t150
  t376 = t300 * t77 * t302 * t324
  t379 = f.my_piecewise3(t113, 0, -0.3e1 / 0.8e1 * t5 * t361 * t30 * t150 - t368 / 0.8e1 - t270 / 0.8e1 + t275 - 0.24240600000000000000000000000000000000000000000000e0 * t5 * t122 * t325 - 0.80802000000000000000000000000000000000000000000000e-1 * t376)
  d12 = t111 + t161 + t290 + t329 + t6 * (t353 + t379)
  t384 = t281 ** 2
  t388 = 0.2e1 * t23 + 0.2e1 * t170
  t389 = f.my_piecewise5(t10, 0, t14, 0, t388)
  t393 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t164 * t384 + 0.4e1 / 0.3e1 * t21 * t389)
  t400 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t393 * t30 * t68 - t345 / 0.4e1 + t194)
  t401 = t292 ** 2
  t405 = f.my_piecewise5(t14, 0, t10, 0, -t388)
  t409 = f.my_piecewise3(t116, 0, 0.4e1 / 0.9e1 * t254 * t401 + 0.4e1 / 0.3e1 * t117 * t405)
  t422 = t324 ** 2
  t428 = s2 / t126 / t138
  t437 = t137 / t125 / t138 / t304
  t443 = t138 ** 2
  t452 = t137 ** 2
  t457 = t145 ** 2
  t467 = f.my_piecewise3(t113, 0, -0.3e1 / 0.8e1 * t5 * t409 * t30 * t150 - t368 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t5 * t295 * t325 + t275 - 0.16160400000000000000000000000000000000000000000000e0 * t376 + 0.48481200000000000000000000000000000000000000000000e0 * t300 * t30 / t301 / t147 * t422 - 0.24240600000000000000000000000000000000000000000000e0 * t300 * t303 * (0.110e3 / 0.2187e4 * t37 * t428 + 0.39134815150061607727480566986739826245999085505255e-1 * t37 * t428 * t133 - 0.40024242767108462448559670781893004115226337448557e-2 * t54 * t437 * t133 + 0.29647587234895157369303459838439262307575064776709e-3 * t222 * t137 * s2 / t443 / t124 * t133 + 0.46546888076566221316195024471201883181764297447860e-3 * t54 * t437 * t320 - 0.32409166382013480266174026443813232990886034424442e-7 * t236 * t452 / t126 / t443 / t138 / t457))
  d22 = 0.2e1 * t290 + 0.2e1 * t329 + t6 * (t400 + t467)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t49 = t44 / t47
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t55 = s0 / t52 / t50
  t56 = t49 * t55
  t59 = jnp.exp(-t56 / 0.24e2)
  t63 = t44 ** 2
  t66 = t63 / t46 / t45
  t67 = s0 ** 2
  t68 = t50 ** 2
  t69 = t68 * r0
  t75 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t66 * t67 / t51 / t69
  t76 = jnp.log(t75)
  t77 = 0.8040e0 + 0.5e1 / 0.972e3 * t56 + 0.40024242767108462448559670781893004115226337448558e-2 * t49 * t55 * t59 + t76
  t80 = 0.18040e1 - 0.64641600e0 / t77
  t86 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t87 = t42 ** 2
  t88 = 0.1e1 / t87
  t93 = t5 * t86
  t94 = t77 ** 2
  t95 = 0.1e1 / t94
  t96 = t42 * t95
  t97 = t50 * r0
  t100 = s0 / t52 / t97
  t109 = t67 / t51 / t68 / t50
  t113 = 0.1e1 / t75
  t117 = -0.10e2 / 0.729e3 * t49 * t100 - 0.10673131404562256652949245541838134430727023319615e-1 * t49 * t100 * t59 + 0.44471380852342736053955189757658893461362597165064e-3 * t66 * t109 * t59 - 0.73495086436683507341360564954529289234364680180832e-4 * t66 * t109 * t113
  t118 = t96 * t117
  t121 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t122 = t121 * f.p.zeta_threshold
  t124 = f.my_piecewise3(t20, t122, t21 * t19)
  t126 = 0.1e1 / t87 / t6
  t131 = t5 * t124
  t132 = t88 * t95
  t133 = t132 * t117
  t137 = 0.1e1 / t94 / t77
  t138 = t42 * t137
  t139 = t117 ** 2
  t140 = t138 * t139
  t145 = s0 / t52 / t68
  t154 = t67 / t51 / t68 / t97
  t158 = t45 ** 2
  t159 = 0.1e1 / t158
  t161 = t159 * t67 * s0
  t162 = t68 ** 2
  t173 = t44 / t47 / t158
  t174 = t67 ** 2
  t179 = t75 ** 2
  t180 = 0.1e1 / t179
  t184 = 0.110e3 / 0.2187e4 * t49 * t145 + 0.39134815150061607727480566986739826245999085505255e-1 * t49 * t145 * t59 - 0.40024242767108462448559670781893004115226337448557e-2 * t66 * t154 * t59 + 0.29647587234895157369303459838439262307575064776709e-3 * t161 / t162 / t50 * t59 + 0.46546888076566221316195024471201883181764297447860e-3 * t66 * t154 * t113 - 0.32409166382013480266174026443813232990886034424442e-7 * t173 * t174 / t52 / t162 / t68 * t180
  t185 = t96 * t184
  t189 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t41 * t42 * t80 - t5 * t86 * t88 * t80 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t93 * t118 + t5 * t124 * t126 * t80 / 0.12e2 - 0.16160400000000000000000000000000000000000000000000e0 * t131 * t133 + 0.48481200000000000000000000000000000000000000000000e0 * t131 * t140 - 0.24240600000000000000000000000000000000000000000000e0 * t131 * t185)
  t191 = r1 <= f.p.dens_threshold
  t192 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t193 = 0.1e1 + t192
  t194 = t193 <= f.p.zeta_threshold
  t195 = t193 ** (0.1e1 / 0.3e1)
  t196 = t195 ** 2
  t197 = 0.1e1 / t196
  t199 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t200 = t199 ** 2
  t204 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t208 = f.my_piecewise3(t194, 0, 0.4e1 / 0.9e1 * t197 * t200 + 0.4e1 / 0.3e1 * t195 * t204)
  t210 = r1 ** 2
  t211 = r1 ** (0.1e1 / 0.3e1)
  t212 = t211 ** 2
  t215 = s2 / t212 / t210
  t216 = t49 * t215
  t219 = jnp.exp(-t216 / 0.24e2)
  t223 = s2 ** 2
  t224 = t210 ** 2
  t232 = jnp.log(0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t66 * t223 / t211 / t224 / r1)
  t236 = 0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t216 + 0.40024242767108462448559670781893004115226337448558e-2 * t49 * t215 * t219 + t232)
  t242 = f.my_piecewise3(t194, 0, 0.4e1 / 0.3e1 * t195 * t199)
  t248 = f.my_piecewise3(t194, t122, t195 * t193)
  t254 = f.my_piecewise3(t191, 0, -0.3e1 / 0.8e1 * t5 * t208 * t42 * t236 - t5 * t242 * t88 * t236 / 0.4e1 + t5 * t248 * t126 * t236 / 0.12e2)
  t260 = t94 ** 2
  t281 = t24 ** 2
  t285 = 0.6e1 * t33 - 0.6e1 * t16 / t281
  t286 = f.my_piecewise5(t10, 0, t14, 0, t285)
  t290 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t286)
  t311 = 0.1e1 / t87 / t24
  t325 = s0 / t52 / t69
  t333 = t67 / t51 / t162
  t345 = 0.1e1 / t52 / t162 / t69
  t357 = t158 ** 2
  t361 = t162 ** 2
  t373 = 0.48481200000000000000000000000000000000000000000000e0 * t131 * t88 * t137 * t139 - 0.14544360000000000000000000000000000000000000000000e1 * t131 * t42 / t260 * t139 * t117 + 0.14544360000000000000000000000000000000000000000000e1 * t131 * t138 * t117 * t184 + 0.14544360000000000000000000000000000000000000000000e1 * t93 * t140 - 0.3e1 / 0.8e1 * t5 * t290 * t42 * t80 - 0.3e1 / 0.8e1 * t5 * t41 * t88 * t80 - 0.72721800000000000000000000000000000000000000000000e0 * t5 * t41 * t118 + t5 * t86 * t126 * t80 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t93 * t133 - 0.72721800000000000000000000000000000000000000000000e0 * t93 * t185 - 0.5e1 / 0.36e2 * t5 * t124 * t311 * t80 + 0.16160400000000000000000000000000000000000000000000e0 * t131 * t126 * t95 * t117 - 0.24240600000000000000000000000000000000000000000000e0 * t131 * t132 * t184 - 0.24240600000000000000000000000000000000000000000000e0 * t131 * t96 * (-0.1540e4 / 0.6561e4 * t49 * t325 - 0.18262913736695416939490931260478585581466239902452e0 * t49 * t325 * t59 + 0.33699424156997495543108266016359294822943656962859e-1 * t66 * t333 * t59 - 0.56330415746300799001676573693034598384392623075747e-2 * t161 / t162 / t97 * t59 + 0.32941763594327952632559399820488069230638960863010e-4 * t159 * t174 * t345 * t49 * t59 - 0.34134384589481895631876351278881380999960484795097e-2 * t66 * t333 * t113 + 0.61577416125825612505730650243245142682683465406440e-6 * t173 * t174 * t345 * t180 - 0.28582973815043256372349471130783456363567241139645e-10 / t357 * t174 * t67 / t361 / t97 / t179 / t75)
  t374 = f.my_piecewise3(t1, 0, t373)
  t384 = f.my_piecewise5(t14, 0, t10, 0, -t285)
  t388 = f.my_piecewise3(t194, 0, -0.8e1 / 0.27e2 / t196 / t193 * t200 * t199 + 0.4e1 / 0.3e1 * t197 * t199 * t204 + 0.4e1 / 0.3e1 * t195 * t384)
  t406 = f.my_piecewise3(t191, 0, -0.3e1 / 0.8e1 * t5 * t388 * t42 * t236 - 0.3e1 / 0.8e1 * t5 * t208 * t88 * t236 + t5 * t242 * t126 * t236 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t248 * t311 * t236)
  d111 = 0.3e1 * t189 + 0.3e1 * t254 + t6 * (t374 + t406)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = 6 ** (0.1e1 / 0.3e1)
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = t30 / t33
  t36 = r0 ** 2
  t37 = r0 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t41 = s0 / t38 / t36
  t42 = t35 * t41
  t45 = jnp.exp(-t42 / 0.24e2)
  t49 = t30 ** 2
  t51 = 0.1e1 / t32 / t31
  t52 = t49 * t51
  t53 = s0 ** 2
  t54 = t36 ** 2
  t55 = t54 * r0
  t61 = 0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t52 * t53 / t37 / t55
  t62 = jnp.log(t61)
  t63 = 0.8040e0 + 0.5e1 / 0.972e3 * t42 + 0.40024242767108462448559670781893004115226337448558e-2 * t35 * t41 * t45 + t62
  t64 = t63 ** 2
  t66 = 0.1e1 / t64 / t63
  t67 = t29 * t66
  t68 = t36 * r0
  t71 = s0 / t38 / t68
  t77 = t54 * t36
  t80 = t53 / t37 / t77
  t84 = 0.1e1 / t61
  t88 = -0.10e2 / 0.729e3 * t35 * t71 - 0.10673131404562256652949245541838134430727023319615e-1 * t35 * t71 * t45 + 0.44471380852342736053955189757658893461362597165064e-3 * t52 * t80 * t45 - 0.73495086436683507341360564954529289234364680180832e-4 * t52 * t80 * t84
  t89 = t88 ** 2
  t90 = t67 * t89
  t93 = t64 ** 2
  t94 = 0.1e1 / t93
  t95 = t27 * t94
  t96 = t89 * t88
  t97 = t95 * t96
  t100 = t27 * t66
  t103 = s0 / t38 / t54
  t112 = t53 / t37 / t54 / t68
  t116 = t31 ** 2
  t117 = 0.1e1 / t116
  t119 = t117 * t53 * s0
  t120 = t54 ** 2
  t131 = t30 / t33 / t116
  t132 = t53 ** 2
  t133 = t120 * t54
  t137 = t61 ** 2
  t138 = 0.1e1 / t137
  t142 = 0.110e3 / 0.2187e4 * t35 * t103 + 0.39134815150061607727480566986739826245999085505255e-1 * t35 * t103 * t45 - 0.40024242767108462448559670781893004115226337448557e-2 * t52 * t112 * t45 + 0.29647587234895157369303459838439262307575064776709e-3 * t119 / t120 / t36 * t45 + 0.46546888076566221316195024471201883181764297447860e-3 * t52 * t112 * t84 - 0.32409166382013480266174026443813232990886034424442e-7 * t131 * t132 / t38 / t133 * t138
  t143 = t88 * t142
  t144 = t100 * t143
  t147 = t6 ** 2
  t148 = 0.1e1 / t147
  t150 = -t16 * t148 + t7
  t151 = f.my_piecewise5(t10, 0, t14, 0, t150)
  t154 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t151)
  t155 = t5 * t154
  t156 = t100 * t89
  t159 = t23 ** 2
  t161 = 0.1e1 / t159 / t19
  t162 = t151 ** 2
  t166 = 0.1e1 / t159
  t167 = t166 * t151
  t168 = t147 * t6
  t169 = 0.1e1 / t168
  t172 = 0.2e1 * t16 * t169 - 0.2e1 * t148
  t173 = f.my_piecewise5(t10, 0, t14, 0, t172)
  t176 = t147 ** 2
  t177 = 0.1e1 / t176
  t180 = -0.6e1 * t16 * t177 + 0.6e1 * t169
  t181 = f.my_piecewise5(t10, 0, t14, 0, t180)
  t185 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t161 * t162 * t151 + 0.4e1 / 0.3e1 * t167 * t173 + 0.4e1 / 0.3e1 * t23 * t181)
  t189 = 0.18040e1 - 0.64641600e0 / t63
  t198 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t166 * t162 + 0.4e1 / 0.3e1 * t23 * t173)
  t203 = t5 * t198
  t204 = 0.1e1 / t64
  t205 = t27 * t204
  t206 = t205 * t88
  t210 = 0.1e1 / t28 / t6
  t215 = t29 * t204
  t216 = t215 * t88
  t219 = t205 * t142
  t223 = 0.1e1 / t28 / t147
  t228 = t210 * t204
  t229 = t228 * t88
  t232 = t215 * t142
  t237 = s0 / t38 / t55
  t245 = t53 / t37 / t120
  t254 = t117 * t132
  t257 = 0.1e1 / t38 / t120 / t55
  t259 = t35 * t45
  t269 = t116 ** 2
  t270 = 0.1e1 / t269
  t272 = t270 * t132 * t53
  t273 = t120 ** 2
  t277 = 0.1e1 / t137 / t61
  t281 = -0.1540e4 / 0.6561e4 * t35 * t237 - 0.18262913736695416939490931260478585581466239902452e0 * t35 * t237 * t45 + 0.33699424156997495543108266016359294822943656962859e-1 * t52 * t245 * t45 - 0.56330415746300799001676573693034598384392623075747e-2 * t119 / t120 / t68 * t45 + 0.32941763594327952632559399820488069230638960863010e-4 * t254 * t257 * t259 - 0.34134384589481895631876351278881380999960484795097e-2 * t52 * t245 * t84 + 0.61577416125825612505730650243245142682683465406440e-6 * t131 * t132 * t257 * t138 - 0.28582973815043256372349471130783456363567241139645e-10 * t272 / t273 / t68 * t277
  t282 = t205 * t281
  t285 = 0.48481200000000000000000000000000000000000000000000e0 * t26 * t90 - 0.14544360000000000000000000000000000000000000000000e1 * t26 * t97 + 0.14544360000000000000000000000000000000000000000000e1 * t26 * t144 + 0.14544360000000000000000000000000000000000000000000e1 * t155 * t156 - 0.3e1 / 0.8e1 * t5 * t185 * t27 * t189 - 0.3e1 / 0.8e1 * t5 * t198 * t29 * t189 - 0.72721800000000000000000000000000000000000000000000e0 * t203 * t206 + t5 * t154 * t210 * t189 / 0.4e1 - 0.48481200000000000000000000000000000000000000000000e0 * t155 * t216 - 0.72721800000000000000000000000000000000000000000000e0 * t155 * t219 - 0.5e1 / 0.36e2 * t5 * t25 * t223 * t189 + 0.16160400000000000000000000000000000000000000000000e0 * t26 * t229 - 0.24240600000000000000000000000000000000000000000000e0 * t26 * t232 - 0.24240600000000000000000000000000000000000000000000e0 * t26 * t282
  t286 = f.my_piecewise3(t1, 0, t285)
  t288 = r1 <= f.p.dens_threshold
  t289 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t290 = 0.1e1 + t289
  t291 = t290 <= f.p.zeta_threshold
  t292 = t290 ** (0.1e1 / 0.3e1)
  t293 = t292 ** 2
  t295 = 0.1e1 / t293 / t290
  t297 = f.my_piecewise5(t14, 0, t10, 0, -t150)
  t298 = t297 ** 2
  t302 = 0.1e1 / t293
  t303 = t302 * t297
  t305 = f.my_piecewise5(t14, 0, t10, 0, -t172)
  t309 = f.my_piecewise5(t14, 0, t10, 0, -t180)
  t313 = f.my_piecewise3(t291, 0, -0.8e1 / 0.27e2 * t295 * t298 * t297 + 0.4e1 / 0.3e1 * t303 * t305 + 0.4e1 / 0.3e1 * t292 * t309)
  t315 = r1 ** 2
  t316 = r1 ** (0.1e1 / 0.3e1)
  t317 = t316 ** 2
  t320 = s2 / t317 / t315
  t321 = t35 * t320
  t324 = jnp.exp(-t321 / 0.24e2)
  t328 = s2 ** 2
  t329 = t315 ** 2
  t337 = jnp.log(0.1e1 + 0.13780328706878157626505105928974241731443377533906e-4 * t52 * t328 / t316 / t329 / r1)
  t341 = 0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t321 + 0.40024242767108462448559670781893004115226337448558e-2 * t35 * t320 * t324 + t337)
  t350 = f.my_piecewise3(t291, 0, 0.4e1 / 0.9e1 * t302 * t298 + 0.4e1 / 0.3e1 * t292 * t305)
  t357 = f.my_piecewise3(t291, 0, 0.4e1 / 0.3e1 * t292 * t297)
  t363 = f.my_piecewise3(t291, t22, t292 * t290)
  t369 = f.my_piecewise3(t288, 0, -0.3e1 / 0.8e1 * t5 * t313 * t27 * t341 - 0.3e1 / 0.8e1 * t5 * t350 * t29 * t341 + t5 * t357 * t210 * t341 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t363 * t223 * t341)
  t392 = t89 ** 2
  t396 = t142 ** 2
  t406 = s0 / t38 / t77
  t412 = t120 * r0
  t415 = t53 / t37 / t412
  t425 = 0.1e1 / t38 / t120 / t77
  t450 = t132 ** 2
  t456 = t137 ** 2
  t472 = 0.32320800000000000000000000000000000000000000000000e0 * t26 * t228 * t142 - 0.32320800000000000000000000000000000000000000000000e0 * t26 * t215 * t281 - 0.35912000000000000000000000000000000000000000000000e0 * t26 * t223 * t204 * t88 + 0.64641600000000000000000000000000000000000000000000e0 * t155 * t229 + 0.19392480000000000000000000000000000000000000000000e1 * t155 * t90 - 0.19392480000000000000000000000000000000000000000000e1 * t26 * t29 * t94 * t96 + 0.58177440000000000000000000000000000000000000000000e1 * t26 * t27 / t93 / t63 * t392 + 0.14544360000000000000000000000000000000000000000000e1 * t26 * t100 * t396 - 0.64641600000000000000000000000000000000000000000000e0 * t26 * t210 * t66 * t89 - 0.24240600000000000000000000000000000000000000000000e0 * t26 * t205 * (0.26180e5 / 0.19683e5 * t35 * t406 + 0.10348984450794069599044861047604531829497535944723e1 * t35 * t406 * t45 - 0.30112066101575181501422547375908144083727074124877e0 * t52 * t415 * t45 + 0.84429740092262542597249741739910921438127656691895e-1 * t119 / t133 * t45 - 0.10760976107480464526636070608026102615342060548583e-2 * t254 * t425 * t259 + 0.36601959549253280702843777578320076922932178736678e-5 * t117 * t132 * s0 / t37 / t273 / r0 * t52 * t45 + 0.28445320491234913026563626065734484166633737329247e-1 * t52 * t415 * t84 - 0.99208059313830153481454936503006063210990027599264e-5 * t131 * t132 * t425 * t138 + 0.10861530049716437421492799029697713418155551633065e-8 * t272 / t273 / t54 * t277 - 0.63021243934621964298156931253183868460287090995824e-14 * t270 * t450 / t37 / t273 / t412 / t456 * t49 * t51) - 0.96962400000000000000000000000000000000000000000000e0 * t155 * t232 - 0.96962400000000000000000000000000000000000000000000e0 * t155 * t282 - 0.96962400000000000000000000000000000000000000000000e0 * t203 * t216
  t482 = t19 ** 2
  t485 = t162 ** 2
  t491 = t173 ** 2
  t500 = -0.24e2 * t177 + 0.24e2 * t16 / t176 / t6
  t501 = f.my_piecewise5(t10, 0, t14, 0, t500)
  t505 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t159 / t482 * t485 - 0.16e2 / 0.9e1 * t161 * t162 * t173 + 0.4e1 / 0.3e1 * t166 * t491 + 0.16e2 / 0.9e1 * t167 * t181 + 0.4e1 / 0.3e1 * t23 * t501)
  t523 = 0.1e1 / t28 / t168
  t541 = -0.14544360000000000000000000000000000000000000000000e1 * t203 * t219 - 0.96962400000000000000000000000000000000000000000000e0 * t5 * t185 * t206 + 0.29088720000000000000000000000000000000000000000000e1 * t203 * t156 - 0.58177440000000000000000000000000000000000000000000e1 * t155 * t97 - 0.3e1 / 0.8e1 * t5 * t505 * t27 * t189 - 0.5e1 / 0.9e1 * t5 * t154 * t223 * t189 - t5 * t185 * t29 * t189 / 0.2e1 + t5 * t198 * t210 * t189 / 0.2e1 + 0.10e2 / 0.27e2 * t5 * t25 * t523 * t189 + 0.19392480000000000000000000000000000000000000000000e1 * t26 * t67 * t143 - 0.87266160000000000000000000000000000000000000000000e1 * t26 * t95 * t89 * t142 + 0.58177440000000000000000000000000000000000000000000e1 * t155 * t144 + 0.19392480000000000000000000000000000000000000000000e1 * t26 * t100 * t88 * t281
  t543 = f.my_piecewise3(t1, 0, t472 + t541)
  t544 = t290 ** 2
  t547 = t298 ** 2
  t553 = t305 ** 2
  t559 = f.my_piecewise5(t14, 0, t10, 0, -t500)
  t563 = f.my_piecewise3(t291, 0, 0.40e2 / 0.81e2 / t293 / t544 * t547 - 0.16e2 / 0.9e1 * t295 * t298 * t305 + 0.4e1 / 0.3e1 * t302 * t553 + 0.16e2 / 0.9e1 * t303 * t309 + 0.4e1 / 0.3e1 * t292 * t559)
  t585 = f.my_piecewise3(t288, 0, -0.3e1 / 0.8e1 * t5 * t563 * t27 * t341 - t5 * t313 * t29 * t341 / 0.2e1 + t5 * t350 * t210 * t341 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t357 * t223 * t341 + 0.10e2 / 0.27e2 * t5 * t363 * t523 * t341)
  d1111 = 0.4e1 * t286 + 0.4e1 * t369 + t6 * (t543 + t585)

  res = {'v4rho4': d1111}
  return res
