"""Generated from gga_xc_b97.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))
  params_c_x_raw = params.c_x
  if isinstance(params_c_x_raw, (str, bytes, dict)):
    params_c_x = params_c_x_raw
  else:
    try:
      params_c_x_seq = list(params_c_x_raw)
    except TypeError:
      params_c_x = params_c_x_raw
    else:
      params_c_x_seq = np.asarray(params_c_x_seq, dtype=np.float64)
      params_c_x = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_x_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  params_alpha = 1

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: +b97_f(f_lda_x, 0.004, params_c_x, 0, np.array([np.nan, 0, 0, 0, 0, 0], dtype=np.float64), rs, z, xs0, xs1) + b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))
  params_c_x_raw = params.c_x
  if isinstance(params_c_x_raw, (str, bytes, dict)):
    params_c_x = params_c_x_raw
  else:
    try:
      params_c_x_seq = list(params_c_x_raw)
    except TypeError:
      params_c_x = params_c_x_raw
    else:
      params_c_x_seq = np.asarray(params_c_x_seq, dtype=np.float64)
      params_c_x = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_x_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  params_alpha = 1

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: +b97_f(f_lda_x, 0.004, params_c_x, 0, np.array([np.nan, 0, 0, 0, 0, 0], dtype=np.float64), rs, z, xs0, xs1) + b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))
  params_c_x_raw = params.c_x
  if isinstance(params_c_x_raw, (str, bytes, dict)):
    params_c_x = params_c_x_raw
  else:
    try:
      params_c_x_seq = list(params_c_x_raw)
    except TypeError:
      params_c_x = params_c_x_raw
    else:
      params_c_x_seq = np.asarray(params_c_x_seq, dtype=np.float64)
      params_c_x = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_x_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  params_alpha = 1

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: +b97_f(f_lda_x, 0.004, params_c_x, 0, np.array([np.nan, 0, 0, 0, 0, 0], dtype=np.float64), rs, z, xs0, xs1) + b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 0.1e1 + t5
  t7 = t6 <= f.p.zeta_threshold
  t8 = r0 <= f.p.dens_threshold or t7
  t9 = f.my_piecewise3(t7, f.p.zeta_threshold, t6)
  t10 = r0 * t4
  t12 = 0.2e1 * t10 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t13
  t15 = 2 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t17 = t10 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t12, t14, t16 / t17 / 0.2e1)
  t22 = t21 ** 2
  t27 = t3 / t22 / t21 / 0.2e1 <= f.p.dens_threshold
  t28 = 3 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** (0.1e1 / 0.3e1)
  t32 = t28 / t29 * t16
  t34 = t13 * f.p.zeta_threshold
  t36 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t34, 0.2e1 * t15)
  t37 = t3 ** (0.1e1 / 0.3e1)
  t38 = t36 * t37
  t39 = 0.1e1 / t21
  t43 = f.my_piecewise3(t27, 0, -0.3e1 / 0.16e2 * t32 * t38 * t39)
  t44 = 0.0e0 <= f.p.dens_threshold
  t46 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t34, 0)
  t47 = t46 * t37
  t51 = f.my_piecewise3(t44, 0, -0.3e1 / 0.16e2 * t32 * t47 * t39)
  t52 = t43 + t51
  t55 = f.my_piecewise3(t8, 0, t9 * t52 / 0.2e1)
  t56 = params.c_x[0]
  t57 = params.c_x[1]
  t58 = t57 * s0
  t59 = r0 ** 2
  t60 = r0 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t63 = 0.1e1 / t61 / t59
  t64 = s0 * t63
  t66 = 0.1e1 + 0.4e-2 * t64
  t67 = 0.1e1 / t66
  t71 = params.c_x[2]
  t72 = s0 ** 2
  t73 = t71 * t72
  t74 = t59 ** 2
  t75 = t74 * r0
  t77 = 0.1e1 / t60 / t75
  t78 = t66 ** 2
  t79 = 0.1e1 / t78
  t80 = t77 * t79
  t83 = params.c_x[3]
  t84 = t72 * s0
  t85 = t83 * t84
  t86 = t74 ** 2
  t87 = 0.1e1 / t86
  t89 = 0.1e1 / t78 / t66
  t90 = t87 * t89
  t93 = params.c_x[4]
  t94 = t72 ** 2
  t95 = t93 * t94
  t98 = 0.1e1 / t61 / t86 / t59
  t99 = t78 ** 2
  t100 = 0.1e1 / t99
  t101 = t98 * t100
  t104 = t56 + 0.4e-2 * t58 * t63 * t67 + 0.16e-4 * t73 * t80 + 0.64e-7 * t85 * t90 + 0.256e-9 * t95 * t101
  t105 = t55 * t104
  t107 = 0.1e1 - t5
  t108 = t107 <= f.p.zeta_threshold
  t109 = r1 <= f.p.dens_threshold or t108
  t110 = f.my_piecewise3(t108, f.p.zeta_threshold, t107)
  t111 = r1 * t4
  t113 = 0.2e1 * t111 <= f.p.zeta_threshold
  t114 = t111 ** (0.1e1 / 0.3e1)
  t118 = f.my_piecewise3(t113, t14, t16 / t114 / 0.2e1)
  t119 = t118 ** 2
  t124 = t3 / t119 / t118 / 0.2e1 <= f.p.dens_threshold
  t125 = 0.1e1 / t118
  t129 = f.my_piecewise3(t124, 0, -0.3e1 / 0.16e2 * t32 * t38 * t125)
  t133 = f.my_piecewise3(t44, 0, -0.3e1 / 0.16e2 * t32 * t47 * t125)
  t134 = t129 + t133
  t137 = f.my_piecewise3(t109, 0, t110 * t134 / 0.2e1)
  t138 = t57 * s2
  t139 = r1 ** 2
  t140 = r1 ** (0.1e1 / 0.3e1)
  t141 = t140 ** 2
  t143 = 0.1e1 / t141 / t139
  t144 = s2 * t143
  t146 = 0.1e1 + 0.4e-2 * t144
  t147 = 0.1e1 / t146
  t151 = s2 ** 2
  t152 = t71 * t151
  t153 = t139 ** 2
  t154 = t153 * r1
  t156 = 0.1e1 / t140 / t154
  t157 = t146 ** 2
  t158 = 0.1e1 / t157
  t159 = t156 * t158
  t162 = t151 * s2
  t163 = t83 * t162
  t164 = t153 ** 2
  t165 = 0.1e1 / t164
  t167 = 0.1e1 / t157 / t146
  t168 = t165 * t167
  t171 = t151 ** 2
  t172 = t93 * t171
  t175 = 0.1e1 / t141 / t164 / t139
  t176 = t157 ** 2
  t177 = 0.1e1 / t176
  t178 = t175 * t177
  t181 = t56 + 0.4e-2 * t138 * t143 * t147 + 0.16e-4 * t152 * t159 + 0.64e-7 * t163 * t168 + 0.256e-9 * t172 * t178
  t182 = t137 * t181
  t184 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t185 = t28 * t184
  t186 = 4 ** (0.1e1 / 0.3e1)
  t187 = t186 ** 2
  t188 = t185 * t187
  t189 = 0.1e1 / t37
  t190 = t189 * t15
  t191 = t6 ** (0.1e1 / 0.3e1)
  t193 = f.my_piecewise3(t7, t14, 0.1e1 / t191)
  t195 = t188 * t190 * t193
  t197 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t195
  t198 = jnp.sqrt(t195)
  t201 = t195 ** 0.15e1
  t203 = t28 ** 2
  t204 = t184 ** 2
  t205 = t203 * t204
  t206 = t205 * t186
  t207 = t37 ** 2
  t208 = 0.1e1 / t207
  t209 = t208 * t16
  t210 = t193 ** 2
  t212 = t206 * t209 * t210
  t214 = 0.23615790870000000000000000000000000000000000000000e0 * t198 + 0.55771035800000000000000000000000000000000000000000e-1 * t195 + 0.12733319050000000000000000000000000000000000000000e-1 * t201 + 0.76629987700000000000000000000000000000000000000000e-2 * t212
  t216 = 0.1e1 + 0.1e1 / t214
  t217 = jnp.log(t216)
  t218 = t197 * t217
  t222 = 0.1e1 / (0.2e1 * t15 - 0.2e1)
  t223 = (t36 + t46 - 0.2e1) * t222
  t225 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t195
  t230 = 0.21947830050000000000000000000000000000000000000000e0 * t198 + 0.48171623250000000000000000000000000000000000000000e-1 * t195 + 0.13081894750000000000000000000000000000000000000000e-1 * t201 + 0.48591338250000000000000000000000000000000000000000e-2 * t212
  t232 = 0.1e1 + 0.1e1 / t230
  t233 = jnp.log(t232)
  t236 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t195
  t241 = 0.17489865900000000000000000000000000000000000000000e0 * t198 + 0.30591644850000000000000000000000000000000000000000e-1 * t195 + 0.37162376550000000000000000000000000000000000000000e-2 * t201 + 0.41939708850000000000000000000000000000000000000000e-2 * t212
  t243 = 0.1e1 + 0.1e1 / t241
  t244 = jnp.log(t243)
  t245 = t236 * t244
  t251 = -t218 + t223 * (-t225 * t233 + t218 - 0.58482233974552040708313425006184496242808878304904e0 * t245) + 0.58482233974552040708313425006184496242808878304904e0 * t223 * t245
  t254 = f.my_piecewise3(t8, 0, t9 * t251 / 0.2e1)
  t255 = params.c_ss[0]
  t256 = params.c_ss[1]
  t257 = t256 * s0
  t259 = 0.1e1 + 0.2e0 * t64
  t260 = 0.1e1 / t259
  t264 = params.c_ss[2]
  t265 = t264 * t72
  t266 = t259 ** 2
  t267 = 0.1e1 / t266
  t268 = t77 * t267
  t271 = params.c_ss[3]
  t272 = t271 * t84
  t274 = 0.1e1 / t266 / t259
  t275 = t87 * t274
  t278 = params.c_ss[4]
  t279 = t278 * t94
  t280 = t266 ** 2
  t281 = 0.1e1 / t280
  t282 = t98 * t281
  t285 = t255 + 0.2e0 * t257 * t63 * t260 + 0.4e-1 * t265 * t268 + 0.8e-2 * t272 * t275 + 0.16e-2 * t279 * t282
  t286 = t254 * t285
  t287 = t107 ** (0.1e1 / 0.3e1)
  t289 = f.my_piecewise3(t108, t14, 0.1e1 / t287)
  t291 = t188 * t190 * t289
  t293 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t291
  t294 = jnp.sqrt(t291)
  t297 = t291 ** 0.15e1
  t299 = t289 ** 2
  t301 = t206 * t209 * t299
  t303 = 0.23615790870000000000000000000000000000000000000000e0 * t294 + 0.55771035800000000000000000000000000000000000000000e-1 * t291 + 0.12733319050000000000000000000000000000000000000000e-1 * t297 + 0.76629987700000000000000000000000000000000000000000e-2 * t301
  t305 = 0.1e1 + 0.1e1 / t303
  t306 = jnp.log(t305)
  t307 = t293 * t306
  t309 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t291
  t314 = 0.21947830050000000000000000000000000000000000000000e0 * t294 + 0.48171623250000000000000000000000000000000000000000e-1 * t291 + 0.13081894750000000000000000000000000000000000000000e-1 * t297 + 0.48591338250000000000000000000000000000000000000000e-2 * t301
  t316 = 0.1e1 + 0.1e1 / t314
  t317 = jnp.log(t316)
  t320 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t291
  t325 = 0.17489865900000000000000000000000000000000000000000e0 * t294 + 0.30591644850000000000000000000000000000000000000000e-1 * t291 + 0.37162376550000000000000000000000000000000000000000e-2 * t297 + 0.41939708850000000000000000000000000000000000000000e-2 * t301
  t327 = 0.1e1 + 0.1e1 / t325
  t328 = jnp.log(t327)
  t329 = t320 * t328
  t335 = -t307 + t223 * (-t309 * t317 + t307 - 0.58482233974552040708313425006184496242808878304904e0 * t329) + 0.58482233974552040708313425006184496242808878304904e0 * t223 * t329
  t338 = f.my_piecewise3(t109, 0, t110 * t335 / 0.2e1)
  t339 = t256 * s2
  t341 = 0.1e1 + 0.2e0 * t144
  t342 = 0.1e1 / t341
  t346 = t264 * t151
  t347 = t341 ** 2
  t348 = 0.1e1 / t347
  t349 = t156 * t348
  t352 = t271 * t162
  t354 = 0.1e1 / t347 / t341
  t355 = t165 * t354
  t358 = t278 * t171
  t359 = t347 ** 2
  t360 = 0.1e1 / t359
  t361 = t175 * t360
  t364 = t255 + 0.2e0 * t339 * t143 * t342 + 0.4e-1 * t346 * t349 + 0.8e-2 * t352 * t355 + 0.16e-2 * t358 * t361
  t365 = t338 * t364
  t367 = t185 * t187 * t189
  t369 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t367
  t370 = jnp.sqrt(t367)
  t373 = t367 ** 0.15e1
  t376 = t205 * t186 * t208
  t378 = 0.23615790870000000000000000000000000000000000000000e0 * t370 + 0.55771035800000000000000000000000000000000000000000e-1 * t367 + 0.12733319050000000000000000000000000000000000000000e-1 * t373 + 0.76629987700000000000000000000000000000000000000000e-2 * t376
  t380 = 0.1e1 + 0.1e1 / t378
  t381 = jnp.log(t380)
  t382 = t369 * t381
  t383 = t2 ** 2
  t384 = t383 ** 2
  t385 = t3 ** 2
  t386 = t385 ** 2
  t387 = 0.1e1 / t386
  t388 = t384 * t387
  t389 = t191 * t6
  t390 = f.my_piecewise3(t7, t34, t389)
  t391 = t287 * t107
  t392 = f.my_piecewise3(t108, t34, t391)
  t394 = (t390 + t392 - 0.2e1) * t222
  t396 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t367
  t401 = 0.21947830050000000000000000000000000000000000000000e0 * t370 + 0.48171623250000000000000000000000000000000000000000e-1 * t367 + 0.13081894750000000000000000000000000000000000000000e-1 * t373 + 0.48591338250000000000000000000000000000000000000000e-2 * t376
  t403 = 0.1e1 + 0.1e1 / t401
  t404 = jnp.log(t403)
  t407 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t367
  t412 = 0.17489865900000000000000000000000000000000000000000e0 * t370 + 0.30591644850000000000000000000000000000000000000000e-1 * t367 + 0.37162376550000000000000000000000000000000000000000e-2 * t373 + 0.41939708850000000000000000000000000000000000000000e-2 * t376
  t414 = 0.1e1 + 0.1e1 / t412
  t415 = jnp.log(t414)
  t416 = t407 * t415
  t418 = -t396 * t404 + t382 - 0.58482233974552040708313425006184496242808878304904e0 * t416
  t419 = t394 * t418
  t423 = -t382 + t388 * t419 + 0.58482233974552040708313425006184496242808878304904e0 * t394 * t416 - t254 - t338
  t425 = params.c_ab[1]
  t426 = 0.30000000000000000000000000000000000000000000000000e-2 * t64
  t427 = 0.30000000000000000000000000000000000000000000000000e-2 * t144
  t428 = t426 + t427
  t429 = t425 * t428
  t430 = 0.1e1 + t426 + t427
  t431 = 0.1e1 / t430
  t433 = params.c_ab[2]
  t434 = t428 ** 2
  t435 = t433 * t434
  t436 = t430 ** 2
  t437 = 0.1e1 / t436
  t439 = params.c_ab[3]
  t440 = t434 * t428
  t441 = t439 * t440
  t443 = 0.1e1 / t436 / t430
  t445 = params.c_ab[4]
  t446 = t434 ** 2
  t447 = t445 * t446
  t448 = t436 ** 2
  t449 = 0.1e1 / t448
  t451 = t429 * t431 + t435 * t437 + t441 * t443 + t447 * t449 + params.c_ab[0]
  t452 = t423 * t451
  t453 = 0.1e1 / t385
  t454 = t2 * t453
  t455 = t4 - t454
  t456 = f.my_piecewise3(t7, 0, t455)
  t458 = t36 * t208
  t461 = t32 * t458 * t39 / 0.16e2
  t462 = 0.1e1 / t22
  t465 = t16 / t17 / t10
  t466 = r0 * t453
  t470 = f.my_piecewise3(t12, 0, -t465 * (t4 - t466) / 0.6e1)
  t471 = t462 * t470
  t476 = f.my_piecewise3(t27, 0, -t461 + 0.3e1 / 0.16e2 * t32 * t38 * t471)
  t477 = t46 * t208
  t480 = t32 * t477 * t39 / 0.16e2
  t485 = f.my_piecewise3(t44, 0, -t480 + 0.3e1 / 0.16e2 * t32 * t47 * t471)
  t490 = f.my_piecewise3(t8, 0, t456 * t52 / 0.2e1 + t9 * (t476 + t485) / 0.2e1)
  t492 = t59 * r0
  t494 = 0.1e1 / t61 / t492
  t499 = t74 * t59
  t501 = 0.1e1 / t60 / t499
  t502 = t501 * t79
  t509 = 0.1e1 / t86 / r0
  t510 = t509 * t89
  t518 = 0.1e1 / t61 / t86 / t492
  t519 = t518 * t100
  t524 = t94 * s0
  t528 = 0.1e1 / t60 / t86 / t499
  t530 = 0.1e1 / t99 / t66
  t536 = -t455
  t537 = f.my_piecewise3(t108, 0, t536)
  t541 = t32 * t458 * t125 / 0.16e2
  t542 = 0.1e1 / t119
  t545 = t16 / t114 / t111
  t546 = r1 * t453
  t549 = f.my_piecewise3(t113, 0, t545 * t546 / 0.6e1)
  t550 = t542 * t549
  t555 = f.my_piecewise3(t124, 0, -t541 + 0.3e1 / 0.16e2 * t32 * t38 * t550)
  t558 = t32 * t477 * t125 / 0.16e2
  t563 = f.my_piecewise3(t44, 0, -t558 + 0.3e1 / 0.16e2 * t32 * t47 * t550)
  t568 = f.my_piecewise3(t109, 0, t537 * t134 / 0.2e1 + t110 * (t555 + t563) / 0.2e1)
  t572 = 0.1e1 / t37 / t3
  t573 = t572 * t15
  t575 = t188 * t573 * t193
  t576 = 0.11073577833333333333333333333333333333333333333333e-2 * t575
  t577 = 0.1e1 / t389
  t580 = f.my_piecewise3(t7, 0, -t577 * t455 / 0.3e1)
  t582 = t188 * t190 * t580
  t585 = (-t576 + 0.33220733500000000000000000000000000000000000000000e-2 * t582) * t217
  t586 = t214 ** 2
  t588 = t197 / t586
  t589 = 0.1e1 / t198
  t590 = t575 / 0.3e1
  t591 = -t590 + t582
  t592 = t589 * t591
  t594 = 0.18590345266666666666666666666666666666666666666667e-1 * t575
  t596 = t195 ** 0.5e0
  t597 = t596 * t591
  t600 = 0.1e1 / t207 / t3
  t601 = t600 * t16
  t603 = t206 * t601 * t210
  t604 = 0.51086658466666666666666666666666666666666666666667e-2 * t603
  t607 = t206 * t209 * t193 * t580
  t610 = 0.1e1 / t216
  t612 = t588 * (0.11807895435000000000000000000000000000000000000000e0 * t592 - t594 + 0.55771035800000000000000000000000000000000000000000e-1 * t582 + 0.19099978575000000000000000000000000000000000000000e-1 * t597 - t604 + 0.15325997540000000000000000000000000000000000000000e-1 * t607) * t610
  t613 = 0.53236443333333333333333333333333333333333333333333e-3 * t575
  t617 = t230 ** 2
  t619 = t225 / t617
  t621 = 0.16057207750000000000000000000000000000000000000000e-1 * t575
  t624 = 0.32394225500000000000000000000000000000000000000000e-2 * t603
  t627 = 0.1e1 / t232
  t630 = 0.31311312500000000000000000000000000000000000000000e-3 * t575
  t633 = (-t630 + 0.93933937500000000000000000000000000000000000000000e-3 * t582) * t244
  t635 = t241 ** 2
  t636 = 0.1e1 / t635
  t637 = t236 * t636
  t639 = 0.10197214950000000000000000000000000000000000000000e-1 * t575
  t642 = 0.27959805900000000000000000000000000000000000000000e-2 * t603
  t644 = 0.87449329500000000000000000000000000000000000000000e-1 * t592 - t639 + 0.30591644850000000000000000000000000000000000000000e-1 * t582 + 0.55743564825000000000000000000000000000000000000000e-2 * t597 - t642 + 0.83879417700000000000000000000000000000000000000000e-2 * t607
  t645 = 0.1e1 / t243
  t653 = t223 * t236
  t662 = f.my_piecewise3(t8, 0, t456 * t251 / 0.2e1 + t9 * (-t585 + t612 + t223 * (-(-t613 + 0.15970933000000000000000000000000000000000000000000e-2 * t582) * t233 + t619 * (0.10973915025000000000000000000000000000000000000000e0 * t592 - t621 + 0.48171623250000000000000000000000000000000000000000e-1 * t582 + 0.19622842125000000000000000000000000000000000000000e-1 * t597 - t624 + 0.97182676500000000000000000000000000000000000000000e-2 * t607) * t627 + t585 - t612 - 0.58482233974552040708313425006184496242808878304904e0 * t633 + 0.58482233974552040708313425006184496242808878304904e0 * t637 * t644 * t645) + 0.58482233974552040708313425006184496242808878304904e0 * t223 * t633 - 0.58482233974552040708313425006184496242808878304904e0 * t653 * t636 * t644 * t645) / 0.2e1)
  t668 = t501 * t267
  t674 = t509 * t274
  t680 = t518 * t281
  t687 = 0.1e1 / t280 / t259
  t695 = t188 * t573 * t289
  t696 = 0.11073577833333333333333333333333333333333333333333e-2 * t695
  t697 = 0.1e1 / t391
  t700 = f.my_piecewise3(t108, 0, -t697 * t536 / 0.3e1)
  t702 = t188 * t190 * t700
  t705 = (-t696 + 0.33220733500000000000000000000000000000000000000000e-2 * t702) * t306
  t706 = t303 ** 2
  t708 = t293 / t706
  t709 = 0.1e1 / t294
  t710 = t695 / 0.3e1
  t711 = -t710 + t702
  t712 = t709 * t711
  t714 = 0.18590345266666666666666666666666666666666666666667e-1 * t695
  t716 = t291 ** 0.5e0
  t717 = t716 * t711
  t720 = t206 * t601 * t299
  t721 = 0.51086658466666666666666666666666666666666666666667e-2 * t720
  t724 = t206 * t209 * t289 * t700
  t727 = 0.1e1 / t305
  t729 = t708 * (0.11807895435000000000000000000000000000000000000000e0 * t712 - t714 + 0.55771035800000000000000000000000000000000000000000e-1 * t702 + 0.19099978575000000000000000000000000000000000000000e-1 * t717 - t721 + 0.15325997540000000000000000000000000000000000000000e-1 * t724) * t727
  t730 = 0.53236443333333333333333333333333333333333333333333e-3 * t695
  t734 = t314 ** 2
  t736 = t309 / t734
  t738 = 0.16057207750000000000000000000000000000000000000000e-1 * t695
  t741 = 0.32394225500000000000000000000000000000000000000000e-2 * t720
  t744 = 0.1e1 / t316
  t747 = 0.31311312500000000000000000000000000000000000000000e-3 * t695
  t750 = (-t747 + 0.93933937500000000000000000000000000000000000000000e-3 * t702) * t328
  t752 = t325 ** 2
  t753 = 0.1e1 / t752
  t754 = t320 * t753
  t756 = 0.10197214950000000000000000000000000000000000000000e-1 * t695
  t759 = 0.27959805900000000000000000000000000000000000000000e-2 * t720
  t761 = 0.87449329500000000000000000000000000000000000000000e-1 * t712 - t756 + 0.30591644850000000000000000000000000000000000000000e-1 * t702 + 0.55743564825000000000000000000000000000000000000000e-2 * t717 - t759 + 0.83879417700000000000000000000000000000000000000000e-2 * t724
  t762 = 0.1e1 / t327
  t770 = t223 * t320
  t779 = f.my_piecewise3(t109, 0, t537 * t335 / 0.2e1 + t110 * (-t705 + t729 + t223 * (-(-t730 + 0.15970933000000000000000000000000000000000000000000e-2 * t702) * t317 + t736 * (0.10973915025000000000000000000000000000000000000000e0 * t712 - t738 + 0.48171623250000000000000000000000000000000000000000e-1 * t702 + 0.19622842125000000000000000000000000000000000000000e-1 * t717 - t741 + 0.97182676500000000000000000000000000000000000000000e-2 * t724) * t744 + t705 - t729 - 0.58482233974552040708313425006184496242808878304904e0 * t750 + 0.58482233974552040708313425006184496242808878304904e0 * t754 * t761 * t762) + 0.58482233974552040708313425006184496242808878304904e0 * t223 * t750 - 0.58482233974552040708313425006184496242808878304904e0 * t770 * t753 * t761 * t762) / 0.2e1)
  t781 = t187 * t572
  t784 = 0.11073577833333333333333333333333333333333333333333e-2 * t185 * t781 * t381
  t785 = t378 ** 2
  t790 = t184 * t187
  t791 = t790 * t572
  t792 = 0.1e1 / t370 * t28 * t791
  t794 = t185 * t781
  t796 = t367 ** 0.5e0
  t798 = t796 * t28 * t791
  t801 = t205 * t186 * t600
  t806 = t369 / t785 * (-0.39359651450000000000000000000000000000000000000000e-1 * t792 - 0.18590345266666666666666666666666666666666666666667e-1 * t794 - 0.63666595250000000000000000000000000000000000000000e-2 * t798 - 0.51086658466666666666666666666666666666666666666667e-2 * t801) / t380
  t810 = 0.4e1 * t383 * t2 * t387 * t419
  t815 = 0.4e1 * t384 / t386 / t3 * t419
  t818 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t191 * t455)
  t821 = f.my_piecewise3(t108, 0, 0.4e1 / 0.3e1 * t287 * t536)
  t823 = (t818 + t821) * t222
  t829 = t401 ** 2
  t843 = t412 ** 2
  t844 = 0.1e1 / t843
  t850 = -0.29149776500000000000000000000000000000000000000000e-1 * t792 - 0.10197214950000000000000000000000000000000000000000e-1 * t794 - 0.18581188275000000000000000000000000000000000000000e-2 * t798 - 0.27959805900000000000000000000000000000000000000000e-2 * t801
  t851 = 0.1e1 / t414
  t857 = t388 * t394 * (0.53236443333333333333333333333333333333333333333333e-3 * t185 * t781 * t404 + t396 / t829 * (-0.36579716750000000000000000000000000000000000000000e-1 * t792 - 0.16057207750000000000000000000000000000000000000000e-1 * t794 - 0.65409473750000000000000000000000000000000000000000e-2 * t798 - 0.32394225500000000000000000000000000000000000000000e-2 * t801) / t403 - t784 - t806 + 0.18311555036753159941307229983139571945136646663793e-3 * t185 * t781 * t415 + 0.58482233974552040708313425006184496242808878304904e0 * t407 * t844 * t850 * t851)
  t864 = 0.18311555036753159941307229983139571945136646663793e-3 * t394 * t28 * t790 * t572 * t415
  t869 = 0.58482233974552040708313425006184496242808878304904e0 * t394 * t407 * t844 * t850 * t851
  t870 = t784 + t806 + t810 - t815 + t388 * t823 * t418 + t857 + 0.58482233974552040708313425006184496242808878304904e0 * t823 * t416 - t864 - t869 - t662 - t779
  t877 = t437 * s0 * t494
  t880 = t433 * t428
  t884 = t443 * s0 * t494
  t887 = t439 * t434
  t891 = t449 * s0 * t494
  t894 = t445 * t440
  t898 = 0.1e1 / t448 / t430
  vrho_0_ = t105 + t182 + t286 + t365 + t452 + t3 * (t490 * t104 + t55 * (-0.10666666666666666666666666666666666666666666666667e-1 * t58 * t494 * t67 + 0.42666666666666666666666666666666666666666666666668e-4 * t57 * t72 * t502 - 0.85333333333333333333333333333333333333333333333333e-4 * t73 * t502 + 0.34133333333333333333333333333333333333333333333334e-6 * t71 * t84 * t510 - 0.512e-6 * t85 * t510 + 0.20480000000000000000000000000000000000000000000001e-8 * t83 * t94 * t519 - 0.27306666666666666666666666666666666666666666666667e-8 * t95 * t519 + 0.10922666666666666666666666666666666666666666666667e-10 * t93 * t524 * t528 * t530) + t568 * t181 + t662 * t285 + t254 * (-0.53333333333333333333333333333333333333333333333333e0 * t257 * t494 * t260 + 0.10666666666666666666666666666666666666666666666667e0 * t256 * t72 * t668 - 0.21333333333333333333333333333333333333333333333333e0 * t265 * t668 + 0.42666666666666666666666666666666666666666666666668e-1 * t264 * t84 * t674 - 0.64e-1 * t272 * t674 + 0.12800000000000000000000000000000000000000000000000e-1 * t271 * t94 * t680 - 0.17066666666666666666666666666666666666666666666667e-1 * t279 * t680 + 0.34133333333333333333333333333333333333333333333333e-2 * t278 * t524 * t528 * t687) + t779 * t364 + t870 * t451 + t423 * (-0.80000000000000000000000000000000000000000000000000e-2 * t425 * s0 * t494 * t431 + 0.80000000000000000000000000000000000000000000000000e-2 * t429 * t877 - 0.16000000000000000000000000000000000000000000000000e-1 * t880 * t877 + 0.16000000000000000000000000000000000000000000000000e-1 * t435 * t884 - 0.24000000000000000000000000000000000000000000000000e-1 * t887 * t884 + 0.24000000000000000000000000000000000000000000000000e-1 * t441 * t891 - 0.32000000000000000000000000000000000000000000000000e-1 * t894 * t891 + 0.32000000000000000000000000000000000000000000000000e-1 * t447 * t898 * s0 * t494))
  t907 = -t4 - t454
  t908 = f.my_piecewise3(t7, 0, t907)
  t912 = f.my_piecewise3(t12, 0, t465 * t466 / 0.6e1)
  t913 = t462 * t912
  t918 = f.my_piecewise3(t27, 0, -t461 + 0.3e1 / 0.16e2 * t32 * t38 * t913)
  t923 = f.my_piecewise3(t44, 0, -t480 + 0.3e1 / 0.16e2 * t32 * t47 * t913)
  t928 = f.my_piecewise3(t8, 0, t908 * t52 / 0.2e1 + t9 * (t918 + t923) / 0.2e1)
  t930 = -t907
  t931 = f.my_piecewise3(t108, 0, t930)
  t936 = f.my_piecewise3(t113, 0, -t545 * (t4 - t546) / 0.6e1)
  t937 = t542 * t936
  t942 = f.my_piecewise3(t124, 0, -t541 + 0.3e1 / 0.16e2 * t32 * t38 * t937)
  t947 = f.my_piecewise3(t44, 0, -t558 + 0.3e1 / 0.16e2 * t32 * t47 * t937)
  t952 = f.my_piecewise3(t109, 0, t931 * t134 / 0.2e1 + t110 * (t942 + t947) / 0.2e1)
  t954 = t139 * r1
  t956 = 0.1e1 / t141 / t954
  t961 = t153 * t139
  t963 = 0.1e1 / t140 / t961
  t964 = t963 * t158
  t971 = 0.1e1 / t164 / r1
  t972 = t971 * t167
  t980 = 0.1e1 / t141 / t164 / t954
  t981 = t980 * t177
  t986 = t171 * s2
  t990 = 0.1e1 / t140 / t164 / t961
  t992 = 0.1e1 / t176 / t146
  t1001 = f.my_piecewise3(t7, 0, -t577 * t907 / 0.3e1)
  t1003 = t188 * t190 * t1001
  t1006 = (-t576 + 0.33220733500000000000000000000000000000000000000000e-2 * t1003) * t217
  t1007 = -t590 + t1003
  t1008 = t589 * t1007
  t1011 = t596 * t1007
  t1015 = t206 * t209 * t193 * t1001
  t1019 = t588 * (0.11807895435000000000000000000000000000000000000000e0 * t1008 - t594 + 0.55771035800000000000000000000000000000000000000000e-1 * t1003 + 0.19099978575000000000000000000000000000000000000000e-1 * t1011 - t604 + 0.15325997540000000000000000000000000000000000000000e-1 * t1015) * t610
  t1032 = (-t630 + 0.93933937500000000000000000000000000000000000000000e-3 * t1003) * t244
  t1038 = 0.87449329500000000000000000000000000000000000000000e-1 * t1008 - t639 + 0.30591644850000000000000000000000000000000000000000e-1 * t1003 + 0.55743564825000000000000000000000000000000000000000e-2 * t1011 - t642 + 0.83879417700000000000000000000000000000000000000000e-2 * t1015
  t1054 = f.my_piecewise3(t8, 0, t908 * t251 / 0.2e1 + t9 * (-t1006 + t1019 + t223 * (-(-t613 + 0.15970933000000000000000000000000000000000000000000e-2 * t1003) * t233 + t619 * (0.10973915025000000000000000000000000000000000000000e0 * t1008 - t621 + 0.48171623250000000000000000000000000000000000000000e-1 * t1003 + 0.19622842125000000000000000000000000000000000000000e-1 * t1011 - t624 + 0.97182676500000000000000000000000000000000000000000e-2 * t1015) * t627 + t1006 - t1019 - 0.58482233974552040708313425006184496242808878304904e0 * t1032 + 0.58482233974552040708313425006184496242808878304904e0 * t637 * t1038 * t645) + 0.58482233974552040708313425006184496242808878304904e0 * t223 * t1032 - 0.58482233974552040708313425006184496242808878304904e0 * t653 * t636 * t1038 * t645) / 0.2e1)
  t1059 = f.my_piecewise3(t108, 0, -t697 * t930 / 0.3e1)
  t1061 = t188 * t190 * t1059
  t1064 = (-t696 + 0.33220733500000000000000000000000000000000000000000e-2 * t1061) * t306
  t1065 = -t710 + t1061
  t1066 = t709 * t1065
  t1069 = t716 * t1065
  t1073 = t206 * t209 * t289 * t1059
  t1077 = t708 * (0.11807895435000000000000000000000000000000000000000e0 * t1066 - t714 + 0.55771035800000000000000000000000000000000000000000e-1 * t1061 + 0.19099978575000000000000000000000000000000000000000e-1 * t1069 - t721 + 0.15325997540000000000000000000000000000000000000000e-1 * t1073) * t727
  t1090 = (-t747 + 0.93933937500000000000000000000000000000000000000000e-3 * t1061) * t328
  t1096 = 0.87449329500000000000000000000000000000000000000000e-1 * t1066 - t756 + 0.30591644850000000000000000000000000000000000000000e-1 * t1061 + 0.55743564825000000000000000000000000000000000000000e-2 * t1069 - t759 + 0.83879417700000000000000000000000000000000000000000e-2 * t1073
  t1112 = f.my_piecewise3(t109, 0, t931 * t335 / 0.2e1 + t110 * (-t1064 + t1077 + t223 * (-(-t730 + 0.15970933000000000000000000000000000000000000000000e-2 * t1061) * t317 + t736 * (0.10973915025000000000000000000000000000000000000000e0 * t1066 - t738 + 0.48171623250000000000000000000000000000000000000000e-1 * t1061 + 0.19622842125000000000000000000000000000000000000000e-1 * t1069 - t741 + 0.97182676500000000000000000000000000000000000000000e-2 * t1073) * t744 + t1064 - t1077 - 0.58482233974552040708313425006184496242808878304904e0 * t1090 + 0.58482233974552040708313425006184496242808878304904e0 * t754 * t1096 * t762) + 0.58482233974552040708313425006184496242808878304904e0 * t223 * t1090 - 0.58482233974552040708313425006184496242808878304904e0 * t770 * t753 * t1096 * t762) / 0.2e1)
  t1118 = t963 * t348
  t1124 = t971 * t354
  t1130 = t980 * t360
  t1137 = 0.1e1 / t359 / t341
  t1145 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t191 * t907)
  t1148 = f.my_piecewise3(t108, 0, 0.4e1 / 0.3e1 * t287 * t930)
  t1150 = (t1145 + t1148) * t222
  t1155 = t784 + t806 - t810 - t815 + t388 * t1150 * t418 + t857 + 0.58482233974552040708313425006184496242808878304904e0 * t1150 * t416 - t864 - t869 - t1054 - t1112
  t1162 = t437 * s2 * t956
  t1168 = t443 * s2 * t956
  t1174 = t449 * s2 * t956
  vrho_1_ = t105 + t182 + t286 + t365 + t452 + t3 * (t928 * t104 + t952 * t181 + t137 * (-0.10666666666666666666666666666666666666666666666667e-1 * t138 * t956 * t147 + 0.42666666666666666666666666666666666666666666666668e-4 * t57 * t151 * t964 - 0.85333333333333333333333333333333333333333333333333e-4 * t152 * t964 + 0.34133333333333333333333333333333333333333333333334e-6 * t71 * t162 * t972 - 0.512e-6 * t163 * t972 + 0.20480000000000000000000000000000000000000000000001e-8 * t83 * t171 * t981 - 0.27306666666666666666666666666666666666666666666667e-8 * t172 * t981 + 0.10922666666666666666666666666666666666666666666667e-10 * t93 * t986 * t990 * t992) + t1054 * t285 + t1112 * t364 + t338 * (-0.53333333333333333333333333333333333333333333333333e0 * t339 * t956 * t342 + 0.10666666666666666666666666666666666666666666666667e0 * t256 * t151 * t1118 - 0.21333333333333333333333333333333333333333333333333e0 * t346 * t1118 + 0.42666666666666666666666666666666666666666666666668e-1 * t264 * t162 * t1124 - 0.64e-1 * t352 * t1124 + 0.12800000000000000000000000000000000000000000000000e-1 * t271 * t171 * t1130 - 0.17066666666666666666666666666666666666666666666667e-1 * t358 * t1130 + 0.34133333333333333333333333333333333333333333333333e-2 * t278 * t986 * t990 * t1137) + t1155 * t451 + t423 * (-0.80000000000000000000000000000000000000000000000000e-2 * t425 * s2 * t956 * t431 + 0.80000000000000000000000000000000000000000000000000e-2 * t429 * t1162 - 0.16000000000000000000000000000000000000000000000000e-1 * t880 * t1162 + 0.16000000000000000000000000000000000000000000000000e-1 * t435 * t1168 - 0.24000000000000000000000000000000000000000000000000e-1 * t887 * t1168 + 0.24000000000000000000000000000000000000000000000000e-1 * t441 * t1174 - 0.32000000000000000000000000000000000000000000000000e-1 * t894 * t1174 + 0.32000000000000000000000000000000000000000000000000e-1 * t447 * t898 * s2 * t956))
  t1207 = 0.1e1 / t60 / t86 / t75
  t1239 = t437 * t63
  t1244 = t443 * t63
  t1249 = t449 * t63
  vsigma_0_ = t3 * (t55 * (0.4e-2 * t57 * t63 * t67 - 0.16e-4 * t58 * t80 + 0.32e-4 * t71 * s0 * t80 - 0.128e-6 * t73 * t90 + 0.192e-6 * t83 * t72 * t90 - 0.768e-9 * t85 * t101 + 0.1024e-8 * t93 * t84 * t101 - 0.4096e-11 * t95 * t1207 * t530) + t254 * (0.2e0 * t256 * t63 * t260 - 0.4e-1 * t257 * t268 + 0.8e-1 * t264 * s0 * t268 - 0.16e-1 * t265 * t275 + 0.24e-1 * t271 * t72 * t275 - 0.48e-2 * t272 * t282 + 0.64e-2 * t278 * t84 * t282 - 0.128e-2 * t279 * t1207 * t687) + t423 * (0.30000000000000000000000000000000000000000000000000e-2 * t425 * t63 * t431 - 0.30000000000000000000000000000000000000000000000000e-2 * t429 * t1239 + 0.60000000000000000000000000000000000000000000000000e-2 * t880 * t1239 - 0.60000000000000000000000000000000000000000000000000e-2 * t435 * t1244 + 0.90000000000000000000000000000000000000000000000000e-2 * t887 * t1244 - 0.90000000000000000000000000000000000000000000000000e-2 * t441 * t1249 + 0.12000000000000000000000000000000000000000000000000e-1 * t894 * t1249 - 0.12000000000000000000000000000000000000000000000000e-1 * t447 * t898 * t63))
  vsigma_1_ = 0.0e0
  t1280 = 0.1e1 / t140 / t164 / t154
  t1312 = t437 * t143
  t1317 = t443 * t143
  t1322 = t449 * t143
  vsigma_2_ = t3 * (t137 * (0.4e-2 * t57 * t143 * t147 - 0.16e-4 * t138 * t159 + 0.32e-4 * t71 * s2 * t159 - 0.128e-6 * t152 * t168 + 0.192e-6 * t83 * t151 * t168 - 0.768e-9 * t163 * t178 + 0.1024e-8 * t93 * t162 * t178 - 0.4096e-11 * t172 * t1280 * t992) + t338 * (0.2e0 * t256 * t143 * t342 - 0.4e-1 * t339 * t349 + 0.8e-1 * t264 * s2 * t349 - 0.16e-1 * t346 * t355 + 0.24e-1 * t271 * t151 * t355 - 0.48e-2 * t352 * t361 + 0.64e-2 * t278 * t162 * t361 - 0.128e-2 * t358 * t1280 * t1137) + t423 * (0.30000000000000000000000000000000000000000000000000e-2 * t425 * t143 * t431 - 0.30000000000000000000000000000000000000000000000000e-2 * t429 * t1312 + 0.60000000000000000000000000000000000000000000000000e-2 * t880 * t1312 - 0.60000000000000000000000000000000000000000000000000e-2 * t435 * t1317 + 0.90000000000000000000000000000000000000000000000000e-2 * t887 * t1317 - 0.90000000000000000000000000000000000000000000000000e-2 * t441 * t1322 + 0.12000000000000000000000000000000000000000000000000e-1 * t894 * t1322 - 0.12000000000000000000000000000000000000000000000000e-1 * t447 * t898 * t143))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_ab_raw = params.c_ab
  if isinstance(params_c_ab_raw, (str, bytes, dict)):
    params_c_ab = params_c_ab_raw
  else:
    try:
      params_c_ab_seq = list(params_c_ab_raw)
    except TypeError:
      params_c_ab = params_c_ab_raw
    else:
      params_c_ab_seq = np.asarray(params_c_ab_seq, dtype=np.float64)
      params_c_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ab_seq))
  params_c_ss_raw = params.c_ss
  if isinstance(params_c_ss_raw, (str, bytes, dict)):
    params_c_ss = params_c_ss_raw
  else:
    try:
      params_c_ss_seq = list(params_c_ss_raw)
    except TypeError:
      params_c_ss = params_c_ss_raw
    else:
      params_c_ss_seq = np.asarray(params_c_ss_seq, dtype=np.float64)
      params_c_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_ss_seq))
  params_c_x_raw = params.c_x
  if isinstance(params_c_x_raw, (str, bytes, dict)):
    params_c_x = params_c_x_raw
  else:
    try:
      params_c_x_seq = list(params_c_x_raw)
    except TypeError:
      params_c_x = params_c_x_raw
    else:
      params_c_x_seq = np.asarray(params_c_x_seq, dtype=np.float64)
      params_c_x = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_x_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  params_alpha = 1

  b97_g = lambda gamma, cc, x: jnp.sum(jnp.array([cc[i] * (gamma * x ** 2 / (1 + gamma * x ** 2)) ** (i - 1) for i in range(1, 5 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  b97_fpar = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: +lda_stoll_par(f, params, lda_func, rs, z) * b97_g(mgamma, cc, xs0) + lda_stoll_par(f, params, lda_func, rs, -z) * b97_g(mgamma, cc, xs1)

  b97_fperp = lambda lda_func, mgamma, cc, rs, z, xs0, xs1: lda_stoll_perp(f, params, lda_func, rs, z) * b97_g(mgamma, cc, jnp.sqrt(xs0 ** 2 + xs1 ** 2) / jnp.sqrt(2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  b97_f = lambda lda_func, gamma_ss, cc_ss, gamma_ab, cc_ab, rs, z, xs0, xs1: +b97_fpar(lda_func, gamma_ss, cc_ss, rs, z, xs0, xs1) + b97_fperp(lda_func, gamma_ab, cc_ab, rs, z, xs0, xs1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: +b97_f(f_lda_x, 0.004, params_c_x, 0, np.array([np.nan, 0, 0, 0, 0, 0], dtype=np.float64), rs, z, xs0, xs1) + b97_f(f_pw, 0.2, params_c_ss, 0.006, params_c_ab, rs, z, xs0, xs1)

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = f.my_piecewise3(t3, 0.1e1 / t6, 1)
  t9 = t8 ** 2
  t14 = r0 / t9 / t8 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = jnp.pi ** (0.1e1 / 0.3e1)
  t19 = 2 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t15 / t16 * t20
  t23 = t6 * f.p.zeta_threshold
  t25 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t23, 0.2e1 * t19)
  t26 = r0 ** (0.1e1 / 0.3e1)
  t28 = 0.1e1 / t8
  t32 = f.my_piecewise3(t14, 0, -0.3e1 / 0.16e2 * t21 * t25 * t26 * t28)
  t33 = 0.0e0 <= f.p.dens_threshold
  t35 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t23, 0)
  t40 = f.my_piecewise3(t33, 0, -0.3e1 / 0.16e2 * t21 * t35 * t26 * t28)
  t44 = f.my_piecewise3(t4, 0, t5 * (t32 + t40) / 0.2e1)
  t46 = params.c_x[1]
  t47 = t46 * s0
  t48 = r0 ** 2
  t49 = t26 ** 2
  t51 = 0.1e1 / t49 / t48
  t52 = t20 * t51
  t54 = s0 * t20 * t51
  t56 = 0.1e1 + 0.4e-2 * t54
  t57 = 0.1e1 / t56
  t61 = params.c_x[2]
  t62 = s0 ** 2
  t63 = t61 * t62
  t64 = t48 ** 2
  t65 = t64 * r0
  t68 = t19 / t26 / t65
  t69 = t56 ** 2
  t70 = 0.1e1 / t69
  t71 = t68 * t70
  t74 = params.c_x[3]
  t75 = t62 * s0
  t76 = t74 * t75
  t77 = t64 ** 2
  t78 = 0.1e1 / t77
  t80 = 0.1e1 / t69 / t56
  t81 = t78 * t80
  t84 = params.c_x[4]
  t85 = t62 ** 2
  t86 = t84 * t85
  t90 = t20 / t49 / t77 / t48
  t91 = t69 ** 2
  t92 = 0.1e1 / t91
  t93 = t90 * t92
  t96 = params.c_x[0] + 0.4e-2 * t47 * t52 * t57 + 0.32e-4 * t63 * t71 + 0.256e-6 * t76 * t81 + 0.1024e-8 * t86 * t93
  t100 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t101 = t15 * t100
  t102 = 4 ** (0.1e1 / 0.3e1)
  t103 = t102 ** 2
  t104 = t101 * t103
  t105 = 0.1e1 / t26
  t108 = t104 * t105 * t19 * t8
  t110 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t108
  t111 = jnp.sqrt(t108)
  t114 = t108 ** 0.15e1
  t116 = t15 ** 2
  t117 = t100 ** 2
  t118 = t116 * t117
  t119 = t118 * t102
  t120 = 0.1e1 / t49
  t123 = t119 * t120 * t20 * t9
  t125 = 0.23615790870000000000000000000000000000000000000000e0 * t111 + 0.55771035800000000000000000000000000000000000000000e-1 * t108 + 0.12733319050000000000000000000000000000000000000000e-1 * t114 + 0.76629987700000000000000000000000000000000000000000e-2 * t123
  t127 = 0.1e1 + 0.1e1 / t125
  t128 = jnp.log(t127)
  t129 = t110 * t128
  t133 = 0.1e1 / (0.2e1 * t19 - 0.2e1)
  t134 = (t25 + t35 - 0.2e1) * t133
  t136 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t108
  t141 = 0.21947830050000000000000000000000000000000000000000e0 * t111 + 0.48171623250000000000000000000000000000000000000000e-1 * t108 + 0.13081894750000000000000000000000000000000000000000e-1 * t114 + 0.48591338250000000000000000000000000000000000000000e-2 * t123
  t143 = 0.1e1 + 0.1e1 / t141
  t144 = jnp.log(t143)
  t147 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t108
  t152 = 0.17489865900000000000000000000000000000000000000000e0 * t111 + 0.30591644850000000000000000000000000000000000000000e-1 * t108 + 0.37162376550000000000000000000000000000000000000000e-2 * t114 + 0.41939708850000000000000000000000000000000000000000e-2 * t123
  t154 = 0.1e1 + 0.1e1 / t152
  t155 = jnp.log(t154)
  t156 = t147 * t155
  t165 = f.my_piecewise3(t4, 0, t5 * (-t129 + t134 * (-t136 * t144 + t129 - 0.58482233974552040708313425006184496242808878304904e0 * t156) + 0.58482233974552040708313425006184496242808878304904e0 * t134 * t156) / 0.2e1)
  t167 = params.c_ss[1]
  t168 = t167 * s0
  t170 = 0.1e1 + 0.2e0 * t54
  t171 = 0.1e1 / t170
  t175 = params.c_ss[2]
  t176 = t175 * t62
  t177 = t170 ** 2
  t178 = 0.1e1 / t177
  t179 = t68 * t178
  t182 = params.c_ss[3]
  t183 = t182 * t75
  t185 = 0.1e1 / t177 / t170
  t186 = t78 * t185
  t189 = params.c_ss[4]
  t190 = t189 * t85
  t191 = t177 ** 2
  t192 = 0.1e1 / t191
  t193 = t90 * t192
  t196 = params.c_ss[0] + 0.2e0 * t168 * t52 * t171 + 0.8e-1 * t176 * t179 + 0.32e-1 * t183 * t186 + 0.64e-2 * t190 * t193
  t200 = t101 * t103 * t105
  t202 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t200
  t203 = jnp.sqrt(t200)
  t206 = t200 ** 0.15e1
  t209 = t118 * t102 * t120
  t211 = 0.23615790870000000000000000000000000000000000000000e0 * t203 + 0.55771035800000000000000000000000000000000000000000e-1 * t200 + 0.12733319050000000000000000000000000000000000000000e-1 * t206 + 0.76629987700000000000000000000000000000000000000000e-2 * t209
  t213 = 0.1e1 + 0.1e1 / t211
  t214 = jnp.log(t213)
  t216 = f.my_piecewise3(t3, t23, 1)
  t219 = (0.2e1 * t216 - 0.2e1) * t133
  t221 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t200
  t226 = 0.17489865900000000000000000000000000000000000000000e0 * t203 + 0.30591644850000000000000000000000000000000000000000e-1 * t200 + 0.37162376550000000000000000000000000000000000000000e-2 * t206 + 0.41939708850000000000000000000000000000000000000000e-2 * t209
  t228 = 0.1e1 + 0.1e1 / t226
  t229 = jnp.log(t228)
  t234 = -t202 * t214 + 0.58482233974552040708313425006184496242808878304904e0 * t219 * t221 * t229 - 0.2e1 * t165
  t236 = params.c_ab[1]
  t237 = t236 * s0
  t239 = 0.1e1 + 0.6e-2 * t54
  t240 = 0.1e1 / t239
  t244 = params.c_ab[2]
  t245 = t244 * t62
  t246 = t239 ** 2
  t247 = 0.1e1 / t246
  t248 = t68 * t247
  t251 = params.c_ab[3]
  t252 = t251 * t75
  t254 = 0.1e1 / t246 / t239
  t255 = t78 * t254
  t258 = params.c_ab[4]
  t259 = t258 * t85
  t260 = t246 ** 2
  t261 = 0.1e1 / t260
  t262 = t90 * t261
  t265 = params.c_ab[0] + 0.6e-2 * t237 * t52 * t240 + 0.72e-4 * t245 * t248 + 0.864e-6 * t252 * t255 + 0.5184e-8 * t259 * t262
  t271 = f.my_piecewise3(t14, 0, -t21 * t25 * t120 * t28 / 0.16e2)
  t276 = f.my_piecewise3(t33, 0, -t21 * t35 * t120 * t28 / 0.16e2)
  t280 = f.my_piecewise3(t4, 0, t5 * (t271 + t276) / 0.2e1)
  t283 = t48 * r0
  t286 = t20 / t49 / t283
  t291 = t64 * t48
  t294 = t19 / t26 / t291
  t295 = t294 * t70
  t302 = 0.1e1 / t77 / r0
  t303 = t302 * t80
  t311 = 0.1e1 / t49 / t77 / t283
  t313 = t311 * t92 * t20
  t318 = t85 * s0
  t323 = t19 / t26 / t77 / t291
  t325 = 0.1e1 / t91 / t56
  t333 = 0.1e1 / t26 / r0
  t334 = t333 * t19
  t338 = 0.11073577833333333333333333333333333333333333333333e-2 * t104 * t334 * t8 * t128
  t339 = t125 ** 2
  t345 = t103 * t333
  t346 = t19 * t8
  t347 = t345 * t346
  t348 = 0.1e1 / t111 * t15 * t100 * t347
  t351 = t104 * t334 * t8
  t353 = t108 ** 0.5e0
  t356 = t353 * t15 * t100 * t347
  t359 = 0.1e1 / t49 / r0
  t362 = t119 * t359 * t20 * t9
  t367 = t110 / t339 * (-0.39359651450000000000000000000000000000000000000000e-1 * t348 - 0.18590345266666666666666666666666666666666666666667e-1 * t351 - 0.63666595250000000000000000000000000000000000000000e-2 * t356 - 0.51086658466666666666666666666666666666666666666667e-2 * t362) / t127
  t372 = t141 ** 2
  t387 = t152 ** 2
  t388 = 0.1e1 / t387
  t394 = -0.29149776500000000000000000000000000000000000000000e-1 * t348 - 0.10197214950000000000000000000000000000000000000000e-1 * t351 - 0.18581188275000000000000000000000000000000000000000e-2 * t356 - 0.27959805900000000000000000000000000000000000000000e-2 * t362
  t395 = 0.1e1 / t154
  t414 = f.my_piecewise3(t4, 0, t5 * (t338 + t367 + t134 * (0.53236443333333333333333333333333333333333333333333e-3 * t104 * t334 * t8 * t144 + t136 / t372 * (-0.36579716750000000000000000000000000000000000000000e-1 * t348 - 0.16057207750000000000000000000000000000000000000000e-1 * t351 - 0.65409473750000000000000000000000000000000000000000e-2 * t356 - 0.32394225500000000000000000000000000000000000000000e-2 * t362) / t143 - t338 - t367 + 0.18311555036753159941307229983139571945136646663793e-3 * t104 * t334 * t8 * t155 + 0.58482233974552040708313425006184496242808878304904e0 * t147 * t388 * t394 * t395) - 0.18311555036753159941307229983139571945136646663793e-3 * t134 * t101 * t345 * t346 * t155 - 0.58482233974552040708313425006184496242808878304904e0 * t134 * t147 * t388 * t394 * t395) / 0.2e1)
  t421 = t294 * t178
  t427 = t302 * t185
  t434 = t311 * t192 * t20
  t441 = 0.1e1 / t191 / t170
  t451 = t211 ** 2
  t456 = t100 * t103
  t457 = t456 * t333
  t458 = 0.1e1 / t203 * t15 * t457
  t460 = t101 * t345
  t462 = t200 ** 0.5e0
  t464 = t462 * t15 * t457
  t467 = t118 * t102 * t359
  t479 = t226 ** 2
  t498 = t294 * t247
  t504 = t302 * t254
  t511 = t311 * t261 * t20
  t518 = 0.1e1 / t260 / t239
  vrho_0_ = 0.2e1 * t44 * t96 + 0.2e1 * t165 * t196 + t234 * t265 + r0 * (0.2e1 * t280 * t96 + 0.2e1 * t44 * (-0.10666666666666666666666666666666666666666666666667e-1 * t47 * t286 * t57 + 0.85333333333333333333333333333333333333333333333336e-4 * t46 * t62 * t295 - 0.17066666666666666666666666666666666666666666666667e-3 * t63 * t295 + 0.13653333333333333333333333333333333333333333333334e-5 * t61 * t75 * t303 - 0.2048e-5 * t76 * t303 + 0.81920000000000000000000000000000000000000000000003e-8 * t74 * t85 * t313 - 0.10922666666666666666666666666666666666666666666667e-7 * t86 * t313 + 0.87381333333333333333333333333333333333333333333336e-10 * t84 * t318 * t323 * t325) + 0.2e1 * t414 * t196 + 0.2e1 * t165 * (-0.53333333333333333333333333333333333333333333333333e0 * t168 * t286 * t171 + 0.21333333333333333333333333333333333333333333333334e0 * t167 * t62 * t421 - 0.42666666666666666666666666666666666666666666666667e0 * t176 * t421 + 0.17066666666666666666666666666666666666666666666667e0 * t175 * t75 * t427 - 0.256e0 * t183 * t427 + 0.51200000000000000000000000000000000000000000000000e-1 * t182 * t85 * t434 - 0.68266666666666666666666666666666666666666666666667e-1 * t190 * t434 + 0.27306666666666666666666666666666666666666666666668e-1 * t189 * t318 * t323 * t441) + (0.11073577833333333333333333333333333333333333333333e-2 * t101 * t345 * t214 + t202 / t451 * (-0.39359651450000000000000000000000000000000000000000e-1 * t458 - 0.18590345266666666666666666666666666666666666666667e-1 * t460 - 0.63666595250000000000000000000000000000000000000000e-2 * t464 - 0.51086658466666666666666666666666666666666666666667e-2 * t467) / t213 - 0.18311555036753159941307229983139571945136646663793e-3 * t219 * t15 * t456 * t333 * t229 - 0.58482233974552040708313425006184496242808878304904e0 * t219 * t221 / t479 * (-0.29149776500000000000000000000000000000000000000000e-1 * t458 - 0.10197214950000000000000000000000000000000000000000e-1 * t460 - 0.18581188275000000000000000000000000000000000000000e-2 * t464 - 0.27959805900000000000000000000000000000000000000000e-2 * t467) / t228 - 0.2e1 * t414) * t265 + t234 * (-0.16000000000000000000000000000000000000000000000000e-1 * t237 * t286 * t240 + 0.19200000000000000000000000000000000000000000000000e-3 * t236 * t62 * t498 - 0.38400000000000000000000000000000000000000000000000e-3 * t245 * t498 + 0.46080000000000000000000000000000000000000000000000e-5 * t244 * t75 * t504 - 0.6912e-5 * t252 * t504 + 0.41472000000000000000000000000000000000000000000000e-7 * t251 * t85 * t511 - 0.55296000000000000000000000000000000000000000000000e-7 * t259 * t511 + 0.66355200000000000000000000000000000000000000000000e-9 * t258 * t318 * t323 * t518))
  t548 = t19 / t26 / t77 / t65
  vsigma_0_ = r0 * (0.2e1 * t44 * (0.4e-2 * t46 * t20 * t51 * t57 - 0.32e-4 * t47 * t71 + 0.64e-4 * t61 * s0 * t71 - 0.512e-6 * t63 * t81 + 0.768e-6 * t74 * t62 * t81 - 0.3072e-8 * t76 * t93 + 0.4096e-8 * t84 * t75 * t93 - 0.32768e-10 * t86 * t548 * t325) + 0.2e1 * t165 * (0.2e0 * t167 * t20 * t51 * t171 - 0.8e-1 * t168 * t179 + 0.16e0 * t175 * s0 * t179 - 0.64e-1 * t176 * t186 + 0.96e-1 * t182 * t62 * t186 - 0.192e-1 * t183 * t193 + 0.256e-1 * t189 * t75 * t193 - 0.1024e-1 * t190 * t548 * t441) + t234 * (0.6e-2 * t236 * t20 * t51 * t240 - 0.72e-4 * t237 * t248 + 0.144e-3 * t244 * s0 * t248 - 0.1728e-5 * t245 * t255 + 0.2592e-5 * t251 * t62 * t255 - 0.15552e-7 * t252 * t262 + 0.20736e-7 * t258 * t75 * t262 - 0.248832e-9 * t259 * t548 * t518))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = f.my_piecewise3(t3, 0.1e1 / t6, 1)
  t9 = t8 ** 2
  t14 = r0 / t9 / t8 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = jnp.pi ** (0.1e1 / 0.3e1)
  t19 = 2 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t15 / t16 * t20
  t23 = t6 * f.p.zeta_threshold
  t25 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t23, 0.2e1 * t19)
  t26 = r0 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t30 = 0.1e1 / t8
  t34 = f.my_piecewise3(t14, 0, -t21 * t25 * t28 * t30 / 0.16e2)
  t35 = 0.0e0 <= f.p.dens_threshold
  t37 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t23, 0)
  t42 = f.my_piecewise3(t35, 0, -t21 * t37 * t28 * t30 / 0.16e2)
  t46 = f.my_piecewise3(t4, 0, t5 * (t34 + t42) / 0.2e1)
  t48 = params.c_x[1]
  t49 = t48 * s0
  t50 = r0 ** 2
  t52 = 0.1e1 / t27 / t50
  t53 = t20 * t52
  t55 = s0 * t20 * t52
  t57 = 0.1e1 + 0.4e-2 * t55
  t58 = 0.1e1 / t57
  t62 = params.c_x[2]
  t63 = s0 ** 2
  t64 = t62 * t63
  t65 = t50 ** 2
  t66 = t65 * r0
  t68 = 0.1e1 / t26 / t66
  t69 = t19 * t68
  t70 = t57 ** 2
  t71 = 0.1e1 / t70
  t72 = t69 * t71
  t75 = params.c_x[3]
  t76 = t63 * s0
  t77 = t75 * t76
  t78 = t65 ** 2
  t79 = 0.1e1 / t78
  t81 = 0.1e1 / t70 / t57
  t82 = t79 * t81
  t85 = params.c_x[4]
  t86 = t63 ** 2
  t87 = t85 * t86
  t88 = t78 * t50
  t91 = t20 / t27 / t88
  t92 = t70 ** 2
  t93 = 0.1e1 / t92
  t94 = t91 * t93
  t97 = params.c_x[0] + 0.4e-2 * t49 * t53 * t58 + 0.32e-4 * t64 * t72 + 0.256e-6 * t77 * t82 + 0.1024e-8 * t87 * t94
  t104 = f.my_piecewise3(t14, 0, -0.3e1 / 0.16e2 * t21 * t25 * t26 * t30)
  t109 = f.my_piecewise3(t35, 0, -0.3e1 / 0.16e2 * t21 * t37 * t26 * t30)
  t113 = f.my_piecewise3(t4, 0, t5 * (t104 + t109) / 0.2e1)
  t114 = t50 * r0
  t116 = 0.1e1 / t27 / t114
  t117 = t20 * t116
  t121 = t48 * t63
  t122 = t65 * t50
  t124 = 0.1e1 / t26 / t122
  t125 = t19 * t124
  t126 = t125 * t71
  t131 = t62 * t76
  t133 = 0.1e1 / t78 / r0
  t134 = t133 * t81
  t139 = t75 * t86
  t142 = 0.1e1 / t27 / t78 / t114
  t144 = t142 * t93 * t20
  t149 = t86 * s0
  t150 = t85 * t149
  t154 = t19 / t26 / t78 / t122
  t156 = 0.1e1 / t92 / t57
  t157 = t154 * t156
  t160 = -0.10666666666666666666666666666666666666666666666667e-1 * t49 * t117 * t58 + 0.85333333333333333333333333333333333333333333333336e-4 * t121 * t126 - 0.17066666666666666666666666666666666666666666666667e-3 * t64 * t126 + 0.13653333333333333333333333333333333333333333333334e-5 * t131 * t134 - 0.2048e-5 * t77 * t134 + 0.81920000000000000000000000000000000000000000000003e-8 * t139 * t144 - 0.10922666666666666666666666666666666666666666666667e-7 * t87 * t144 + 0.87381333333333333333333333333333333333333333333336e-10 * t150 * t157
  t164 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t165 = t15 * t164
  t166 = 4 ** (0.1e1 / 0.3e1)
  t167 = t166 ** 2
  t168 = t165 * t167
  t170 = 0.1e1 / t26 / r0
  t171 = t170 * t19
  t172 = 0.1e1 / t26
  t175 = t168 * t172 * t19 * t8
  t176 = jnp.sqrt(t175)
  t179 = t175 ** 0.15e1
  t181 = t15 ** 2
  t182 = t164 ** 2
  t183 = t181 * t182
  t184 = t183 * t166
  t187 = t184 * t28 * t20 * t9
  t189 = 0.37978500000000000000000000000000000000000000000000e1 * t176 + 0.89690000000000000000000000000000000000000000000000e0 * t175 + 0.20477500000000000000000000000000000000000000000000e0 * t179 + 0.12323500000000000000000000000000000000000000000000e0 * t187
  t192 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t189
  t193 = jnp.log(t192)
  t194 = t8 * t193
  t197 = 0.11073577833333333333333333333333333333333333333333e-2 * t168 * t171 * t194
  t199 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t175
  t200 = t189 ** 2
  t201 = 0.1e1 / t200
  t202 = t199 * t201
  t205 = 0.1e1 / t176 * t15 * t164
  t206 = t167 * t170
  t207 = t19 * t8
  t208 = t206 * t207
  t209 = t205 * t208
  t211 = t171 * t8
  t212 = t168 * t211
  t214 = t175 ** 0.5e0
  t216 = t214 * t15 * t164
  t217 = t216 * t208
  t220 = 0.1e1 / t27 / r0
  t223 = t184 * t220 * t20 * t9
  t225 = -0.63297500000000000000000000000000000000000000000000e0 * t209 - 0.29896666666666666666666666666666666666666666666667e0 * t212 - 0.10238750000000000000000000000000000000000000000000e0 * t217 - 0.82156666666666666666666666666666666666666666666667e-1 * t223
  t226 = 0.1e1 / t192
  t229 = 0.10000000000000000000000000000000000000000000000000e1 * t202 * t225 * t226
  t233 = 0.1e1 / (0.2e1 * t19 - 0.2e1)
  t234 = (t25 + t37 - 0.2e1) * t233
  t239 = 0.70594500000000000000000000000000000000000000000000e1 * t176 + 0.15494250000000000000000000000000000000000000000000e1 * t175 + 0.42077500000000000000000000000000000000000000000000e0 * t179 + 0.15629250000000000000000000000000000000000000000000e0 * t187
  t242 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t239
  t243 = jnp.log(t242)
  t244 = t8 * t243
  t249 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t175
  t250 = t239 ** 2
  t251 = 0.1e1 / t250
  t252 = t249 * t251
  t257 = -0.11765750000000000000000000000000000000000000000000e1 * t209 - 0.51647500000000000000000000000000000000000000000000e0 * t212 - 0.21038750000000000000000000000000000000000000000000e0 * t217 - 0.10419500000000000000000000000000000000000000000000e0 * t223
  t258 = 0.1e1 / t242
  t266 = 0.51785000000000000000000000000000000000000000000000e1 * t176 + 0.90577500000000000000000000000000000000000000000000e0 * t175 + 0.11003250000000000000000000000000000000000000000000e0 * t179 + 0.12417750000000000000000000000000000000000000000000e0 * t187
  t269 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t266
  t270 = jnp.log(t269)
  t271 = t8 * t270
  t276 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t175
  t277 = t266 ** 2
  t278 = 0.1e1 / t277
  t279 = t276 * t278
  t284 = -0.86308333333333333333333333333333333333333333333334e0 * t209 - 0.30192500000000000000000000000000000000000000000000e0 * t212 - 0.55016250000000000000000000000000000000000000000000e-1 * t217 - 0.82785000000000000000000000000000000000000000000000e-1 * t223
  t285 = 0.1e1 / t269
  t291 = t234 * t165
  t292 = t207 * t270
  t296 = t234 * t276
  t298 = t278 * t284 * t285
  t304 = f.my_piecewise3(t4, 0, t5 * (t197 + t229 + t234 * (0.53236443333333333333333333333333333333333333333332e-3 * t168 * t171 * t244 + 0.99999999999999999999999999999999999999999999999999e0 * t252 * t257 * t258 - t197 - t229 + 0.18311555036753159941307229983139571945136646663793e-3 * t168 * t171 * t271 + 0.58482233974552040708313425006184496242808878304903e0 * t279 * t284 * t285) - 0.18311555036753159941307229983139571945136646663793e-3 * t291 * t206 * t292 - 0.58482233974552040708313425006184496242808878304903e0 * t296 * t298) / 0.2e1)
  t306 = params.c_ss[1]
  t307 = t306 * s0
  t309 = 0.1e1 + 0.2e0 * t55
  t310 = 0.1e1 / t309
  t314 = params.c_ss[2]
  t315 = t314 * t63
  t316 = t309 ** 2
  t317 = 0.1e1 / t316
  t318 = t69 * t317
  t321 = params.c_ss[3]
  t322 = t321 * t76
  t324 = 0.1e1 / t316 / t309
  t325 = t79 * t324
  t328 = params.c_ss[4]
  t329 = t328 * t86
  t330 = t316 ** 2
  t331 = 0.1e1 / t330
  t332 = t91 * t331
  t335 = params.c_ss[0] + 0.2e0 * t307 * t53 * t310 + 0.8e-1 * t315 * t318 + 0.32e-1 * t322 * t325 + 0.64e-2 * t329 * t332
  t339 = 0.62182e-1 * t199 * t193
  t342 = t276 * t270
  t351 = f.my_piecewise3(t4, 0, t5 * (-t339 + t234 * (-0.31090e-1 * t249 * t243 + t339 - 0.19751789702565206228825776161588751761046270558698e-1 * t342) + 0.19751789702565206228825776161588751761046270558698e-1 * t234 * t342) / 0.2e1)
  t355 = t306 * t63
  t356 = t125 * t317
  t361 = t314 * t76
  t362 = t133 * t324
  t367 = t321 * t86
  t369 = t142 * t331 * t20
  t374 = t328 * t149
  t376 = 0.1e1 / t330 / t309
  t377 = t154 * t376
  t380 = -0.53333333333333333333333333333333333333333333333333e0 * t307 * t117 * t310 + 0.21333333333333333333333333333333333333333333333334e0 * t355 * t356 - 0.42666666666666666666666666666666666666666666666667e0 * t315 * t356 + 0.17066666666666666666666666666666666666666666666667e0 * t361 * t362 - 0.256e0 * t322 * t362 + 0.51200000000000000000000000000000000000000000000000e-1 * t367 * t369 - 0.68266666666666666666666666666666666666666666666667e-1 * t329 * t369 + 0.27306666666666666666666666666666666666666666666668e-1 * t374 * t377
  t384 = t165 * t167 * t172
  t385 = jnp.sqrt(t384)
  t388 = t384 ** 0.15e1
  t391 = t183 * t166 * t28
  t393 = 0.37978500000000000000000000000000000000000000000000e1 * t385 + 0.89690000000000000000000000000000000000000000000000e0 * t384 + 0.20477500000000000000000000000000000000000000000000e0 * t388 + 0.12323500000000000000000000000000000000000000000000e0 * t391
  t396 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t393
  t397 = jnp.log(t396)
  t402 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t384
  t403 = t393 ** 2
  t404 = 0.1e1 / t403
  t405 = t402 * t404
  t407 = 0.1e1 / t385 * t15
  t408 = t164 * t167
  t409 = t408 * t170
  t410 = t407 * t409
  t412 = t165 * t206
  t414 = t384 ** 0.5e0
  t415 = t414 * t15
  t416 = t415 * t409
  t419 = t183 * t166 * t220
  t421 = -0.63297500000000000000000000000000000000000000000000e0 * t410 - 0.29896666666666666666666666666666666666666666666667e0 * t412 - 0.10238750000000000000000000000000000000000000000000e0 * t416 - 0.82156666666666666666666666666666666666666666666667e-1 * t419
  t422 = 0.1e1 / t396
  t423 = t421 * t422
  t426 = f.my_piecewise3(t3, t23, 1)
  t429 = (0.2e1 * t426 - 0.2e1) * t233
  t430 = t429 * t15
  t435 = 0.51785000000000000000000000000000000000000000000000e1 * t385 + 0.90577500000000000000000000000000000000000000000000e0 * t384 + 0.11003250000000000000000000000000000000000000000000e0 * t388 + 0.12417750000000000000000000000000000000000000000000e0 * t391
  t438 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t435
  t439 = jnp.log(t438)
  t445 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t384
  t446 = t429 * t445
  t447 = t435 ** 2
  t448 = 0.1e1 / t447
  t453 = -0.86308333333333333333333333333333333333333333333334e0 * t410 - 0.30192500000000000000000000000000000000000000000000e0 * t412 - 0.55016250000000000000000000000000000000000000000000e-1 * t416 - 0.82785000000000000000000000000000000000000000000000e-1 * t419
  t455 = 0.1e1 / t438
  t456 = t448 * t453 * t455
  t460 = 0.11073577833333333333333333333333333333333333333333e-2 * t165 * t206 * t397 + 0.10000000000000000000000000000000000000000000000000e1 * t405 * t423 - 0.18311555036753159941307229983139571945136646663793e-3 * t430 * t408 * t170 * t439 - 0.58482233974552040708313425006184496242808878304903e0 * t446 * t456 - 0.2e1 * t304
  t462 = params.c_ab[1]
  t463 = t462 * s0
  t465 = 0.1e1 + 0.6e-2 * t55
  t466 = 0.1e1 / t465
  t470 = params.c_ab[2]
  t471 = t470 * t63
  t472 = t465 ** 2
  t473 = 0.1e1 / t472
  t474 = t69 * t473
  t477 = params.c_ab[3]
  t478 = t477 * t76
  t480 = 0.1e1 / t472 / t465
  t481 = t79 * t480
  t484 = params.c_ab[4]
  t485 = t484 * t86
  t486 = t472 ** 2
  t487 = 0.1e1 / t486
  t488 = t91 * t487
  t491 = params.c_ab[0] + 0.6e-2 * t463 * t53 * t466 + 0.72e-4 * t471 * t474 + 0.864e-6 * t478 * t481 + 0.5184e-8 * t485 * t488
  t500 = -0.62182e-1 * t402 * t397 + 0.19751789702565206228825776161588751761046270558698e-1 * t429 * t445 * t439 - 0.2e1 * t351
  t504 = t462 * t63
  t505 = t125 * t473
  t510 = t470 * t76
  t511 = t133 * t480
  t516 = t477 * t86
  t518 = t142 * t487 * t20
  t523 = t484 * t149
  t525 = 0.1e1 / t486 / t465
  t526 = t154 * t525
  t529 = -0.16000000000000000000000000000000000000000000000000e-1 * t463 * t117 * t466 + 0.19200000000000000000000000000000000000000000000000e-3 * t504 * t505 - 0.38400000000000000000000000000000000000000000000000e-3 * t471 * t505 + 0.46080000000000000000000000000000000000000000000000e-5 * t510 * t511 - 0.6912e-5 * t478 * t511 + 0.41472000000000000000000000000000000000000000000000e-7 * t516 * t518 - 0.55296000000000000000000000000000000000000000000000e-7 * t485 * t518 + 0.66355200000000000000000000000000000000000000000000e-9 * t523 * t526
  t536 = f.my_piecewise3(t14, 0, t21 * t25 * t220 * t30 / 0.24e2)
  t541 = f.my_piecewise3(t35, 0, t21 * t37 * t220 * t30 / 0.24e2)
  t545 = f.my_piecewise3(t4, 0, t5 * (t536 + t541) / 0.2e1)
  t552 = t20 / t27 / t65
  t556 = t65 * t114
  t559 = t19 / t26 / t556
  t560 = t559 * t71
  t564 = 0.1e1 / t88
  t565 = t564 * t81
  t575 = 0.1e1 / t27 / t78 / t65
  t577 = t575 * t93 * t20
  t587 = 0.1e1 / t26 / t78 / t556
  t589 = t587 * t156 * t19
  t596 = t86 * t63
  t598 = t78 ** 2
  t600 = 0.1e1 / t598 / t50
  t602 = 0.1e1 / t92 / t70
  t606 = 0.39111111111111111111111111111111111111111111111112e-1 * t49 * t552 * t58 - 0.76800000000000000000000000000000000000000000000003e-3 * t121 * t560 + 0.36408888888888888888888888888888888888888888888891e-5 * t48 * t76 * t565 + 0.10808888888888888888888888888888888888888888888889e-2 * t64 * t560 - 0.19569777777777777777777777777777777777777777777779e-4 * t131 * t565 + 0.43690666666666666666666666666666666666666666666670e-7 * t62 * t86 * t577 + 0.18432e-4 * t77 * t565 - 0.16110933333333333333333333333333333333333333333334e-6 * t139 * t577 + 0.69905066666666666666666666666666666666666666666671e-9 * t75 * t149 * t589 + 0.12743111111111111111111111111111111111111111111112e-6 * t87 * t577 - 0.21845333333333333333333333333333333333333333333334e-8 * t150 * t589 + 0.93206755555555555555555555555555555555555555555561e-11 * t85 * t596 * t600 * t602
  t610 = 0.1e1 / t26 / t50
  t611 = t610 * t19
  t614 = 0.14764770444444444444444444444444444444444444444444e-2 * t168 * t611 * t194
  t619 = 0.35616666666666666666666666666666666666666666666666e-1 * t412 * t207 * t201 * t225 * t226
  t623 = t225 ** 2
  t626 = 0.20000000000000000000000000000000000000000000000000e1 * t199 / t200 / t189 * t623 * t226
  t631 = t166 * t52
  t633 = t631 * t20 * t9
  t634 = 0.1e1 / t176 / t175 * t181 * t182 * t633
  t636 = t167 * t610
  t637 = t636 * t207
  t638 = t205 * t637
  t641 = t168 * t611 * t8
  t643 = t175 ** (-0.5e0)
  t646 = t643 * t181 * t182 * t633
  t648 = t216 * t637
  t651 = t184 * t53 * t9
  t656 = 0.10000000000000000000000000000000000000000000000000e1 * t202 * (-0.42198333333333333333333333333333333333333333333333e0 * t634 + 0.84396666666666666666666666666666666666666666666666e0 * t638 + 0.39862222222222222222222222222222222222222222222223e0 * t641 + 0.68258333333333333333333333333333333333333333333333e-1 * t646 + 0.13651666666666666666666666666666666666666666666667e0 * t648 + 0.13692777777777777777777777777777777777777777777778e0 * t651) * t226
  t657 = t200 ** 2
  t660 = t192 ** 2
  t664 = 0.16081824322151104821330931780901225435013347914188e2 * t199 / t657 * t623 / t660
  t676 = t257 ** 2
  t690 = t250 ** 2
  t693 = t242 ** 2
  t705 = 0.1e1 / t277 / t266
  t707 = t284 ** 2
  t717 = -0.57538888888888888888888888888888888888888888888889e0 * t634 + 0.11507777777777777777777777777777777777777777777778e1 * t638 + 0.40256666666666666666666666666666666666666666666667e0 * t641 + 0.36677500000000000000000000000000000000000000000000e-1 * t646 + 0.73355000000000000000000000000000000000000000000000e-1 * t648 + 0.13797500000000000000000000000000000000000000000000e0 * t651
  t721 = t277 ** 2
  t722 = 0.1e1 / t721
  t724 = t269 ** 2
  t725 = 0.1e1 / t724
  t729 = -0.70981924444444444444444444444444444444444444444442e-3 * t168 * t611 * t244 - 0.34246666666666666666666666666666666666666666666666e-1 * t412 * t207 * t251 * t257 * t258 - 0.20000000000000000000000000000000000000000000000000e1 * t249 / t250 / t239 * t676 * t258 + 0.99999999999999999999999999999999999999999999999999e0 * t252 * (-0.78438333333333333333333333333333333333333333333333e0 * t634 + 0.15687666666666666666666666666666666666666666666667e1 * t638 + 0.68863333333333333333333333333333333333333333333333e0 * t641 + 0.14025833333333333333333333333333333333333333333333e0 * t646 + 0.28051666666666666666666666666666666666666666666667e0 * t648 + 0.17365833333333333333333333333333333333333333333333e0 * t651) * t258 + 0.32164683177870697973624959794146027661627532968800e2 * t249 / t690 * t676 / t693 + t614 + t619 + t626 - t656 - t664 - 0.24415406715670879921742973310852762593515528885057e-3 * t168 * t611 * t271 - 0.10843580882781524214666447553230042011687479519034e-1 * t412 * t207 * t298 - 0.11696446794910408141662685001236899248561775660981e1 * t276 * t705 * t707 * t285 + 0.58482233974552040708313425006184496242808878304903e0 * t279 * t717 * t285 + 0.17315755899375863299672358916972966258900005419821e2 * t276 * t722 * t707 * t725
  t750 = -t614 - t619 - t626 + t656 + t664 + t234 * t729 + 0.24415406715670879921742973310852762593515528885057e-3 * t291 * t636 * t292 + 0.10843580882781524214666447553230042011687479519034e-1 * t234 * t168 * t211 * t298 + 0.11696446794910408141662685001236899248561775660981e1 * t296 * t705 * t707 * t285 - 0.58482233974552040708313425006184496242808878304903e0 * t296 * t278 * t717 * t285 - 0.17315755899375863299672358916972966258900005419821e2 * t296 * t722 * t707 * t725
  t753 = f.my_piecewise3(t4, 0, t5 * t750 / 0.2e1)
  t761 = t559 * t317
  t765 = t564 * t324
  t774 = t575 * t331 * t20
  t783 = t587 * t376 * t19
  t792 = 0.1e1 / t330 / t316
  t796 = 0.19555555555555555555555555555555555555555555555555e1 * t307 * t552 * t310 - 0.19200000000000000000000000000000000000000000000001e1 * t355 * t761 + 0.45511111111111111111111111111111111111111111111114e0 * t306 * t76 * t765 + 0.27022222222222222222222222222222222222222222222222e1 * t315 * t761 - 0.24462222222222222222222222222222222222222222222223e1 * t361 * t765 + 0.27306666666666666666666666666666666666666666666667e0 * t314 * t86 * t774 + 0.2304e1 * t322 * t765 - 0.10069333333333333333333333333333333333333333333333e1 * t367 * t774 + 0.21845333333333333333333333333333333333333333333334e0 * t321 * t149 * t783 + 0.79644444444444444444444444444444444444444444444445e0 * t329 * t774 - 0.68266666666666666666666666666666666666666666666669e0 * t374 * t783 + 0.14563555555555555555555555555555555555555555555557e0 * t328 * t596 * t600 * t792
  t809 = t421 ** 2
  t817 = t182 * t166 * t52
  t818 = 0.1e1 / t385 / t384 * t181 * t817
  t820 = t408 * t610
  t821 = t407 * t820
  t823 = t165 * t636
  t825 = t384 ** (-0.5e0)
  t827 = t825 * t181 * t817
  t829 = t415 * t820
  t831 = t183 * t631
  t837 = t403 ** 2
  t840 = t396 ** 2
  t855 = t453 ** 2
  t871 = t447 ** 2
  t874 = t438 ** 2
  t880 = -0.14764770444444444444444444444444444444444444444444e-2 * t165 * t636 * t397 - 0.35616666666666666666666666666666666666666666666666e-1 * t168 * t170 * t404 * t423 - 0.20000000000000000000000000000000000000000000000000e1 * t402 / t403 / t393 * t809 * t422 + 0.10000000000000000000000000000000000000000000000000e1 * t405 * (-0.42198333333333333333333333333333333333333333333333e0 * t818 + 0.84396666666666666666666666666666666666666666666666e0 * t821 + 0.39862222222222222222222222222222222222222222222223e0 * t823 + 0.68258333333333333333333333333333333333333333333333e-1 * t827 + 0.13651666666666666666666666666666666666666666666667e0 * t829 + 0.13692777777777777777777777777777777777777777777778e0 * t831) * t422 + 0.16081824322151104821330931780901225435013347914188e2 * t402 / t837 * t809 / t840 + 0.24415406715670879921742973310852762593515528885057e-3 * t430 * t408 * t610 * t439 + 0.10843580882781524214666447553230042011687479519034e-1 * t429 * t165 * t206 * t456 + 0.11696446794910408141662685001236899248561775660981e1 * t446 / t447 / t435 * t855 * t455 - 0.58482233974552040708313425006184496242808878304903e0 * t446 * t448 * (-0.57538888888888888888888888888888888888888888888889e0 * t818 + 0.11507777777777777777777777777777777777777777777778e1 * t821 + 0.40256666666666666666666666666666666666666666666667e0 * t823 + 0.36677500000000000000000000000000000000000000000000e-1 * t827 + 0.73355000000000000000000000000000000000000000000000e-1 * t829 + 0.13797500000000000000000000000000000000000000000000e0 * t831) * t455 - 0.17315755899375863299672358916972966258900005419821e2 * t446 / t871 * t855 / t874 - 0.2e1 * t753
  t887 = t559 * t473
  t891 = t564 * t480
  t900 = t575 * t487 * t20
  t909 = t587 * t525 * t19
  t918 = 0.1e1 / t486 / t472
  t922 = 0.58666666666666666666666666666666666666666666666667e-1 * t463 * t552 * t466 - 0.17280000000000000000000000000000000000000000000000e-2 * t504 * t887 + 0.12288000000000000000000000000000000000000000000000e-4 * t462 * t76 * t891 + 0.24320000000000000000000000000000000000000000000000e-2 * t471 * t887 - 0.66048000000000000000000000000000000000000000000000e-4 * t510 * t891 + 0.22118400000000000000000000000000000000000000000000e-6 * t470 * t86 * t900 + 0.62208e-4 * t478 * t891 - 0.81561600000000000000000000000000000000000000000000e-6 * t516 * t900 + 0.53084160000000000000000000000000000000000000000000e-8 * t477 * t149 * t909 + 0.64512000000000000000000000000000000000000000000000e-6 * t485 * t900 - 0.16588800000000000000000000000000000000000000000000e-7 * t523 * t909 + 0.10616832000000000000000000000000000000000000000000e-9 * t484 * t596 * t600 * t918
  v2rho2_0_ = 0.4e1 * t46 * t97 + 0.4e1 * t113 * t160 + 0.4e1 * t304 * t335 + 0.4e1 * t351 * t380 + 0.2e1 * t460 * t491 + 0.2e1 * t500 * t529 + r0 * (0.2e1 * t113 * t606 + 0.4e1 * t46 * t160 + 0.4e1 * t304 * t380 + 0.2e1 * t753 * t335 + 0.2e1 * t351 * t796 + 0.2e1 * t460 * t529 + t880 * t491 + t500 * t922 + 0.2e1 * t545 * t97)
  t926 = t48 * t20
  t932 = t62 * s0
  t937 = t75 * t63
  t942 = t85 * t76
  t948 = t19 / t26 / t78 / t66
  t949 = t948 * t156
  t952 = 0.4e-2 * t926 * t52 * t58 - 0.32e-4 * t49 * t72 + 0.64e-4 * t932 * t72 - 0.512e-6 * t64 * t82 + 0.768e-6 * t937 * t82 - 0.3072e-8 * t77 * t94 + 0.4096e-8 * t942 * t94 - 0.32768e-10 * t87 * t949
  t955 = t306 * t20
  t961 = t314 * s0
  t966 = t321 * t63
  t971 = t328 * t76
  t974 = t948 * t376
  t977 = 0.2e0 * t955 * t52 * t310 - 0.8e-1 * t307 * t318 + 0.16e0 * t961 * t318 - 0.64e-1 * t315 * t325 + 0.96e-1 * t966 * t325 - 0.192e-1 * t322 * t332 + 0.256e-1 * t971 * t332 - 0.1024e-1 * t329 * t974
  t980 = t462 * t20
  t986 = t470 * s0
  t991 = t477 * t63
  t996 = t484 * t76
  t999 = t948 * t525
  t1002 = 0.6e-2 * t980 * t52 * t466 - 0.72e-4 * t463 * t474 + 0.144e-3 * t986 * t474 - 0.1728e-5 * t471 * t481 + 0.2592e-5 * t991 * t481 - 0.15552e-7 * t478 * t488 + 0.20736e-7 * t996 * t488 - 0.248832e-9 * t485 * t999
  t1009 = t48 * t19
  t1033 = 0.1e1 / t598 / r0
  t1037 = -0.10666666666666666666666666666666666666666666666667e-1 * t926 * t116 * t58 + 0.25600000000000000000000000000000000000000000000001e-3 * t1009 * t124 * t71 * s0 - 0.13653333333333333333333333333333333333333333333334e-5 * t121 * t134 - 0.34133333333333333333333333333333333333333333333333e-3 * t932 * t126 + 0.68266666666666666666666666666666666666666666666668e-5 * t64 * t134 - 0.16384000000000000000000000000000000000000000000001e-7 * t131 * t144 - 0.6144e-5 * t937 * t134 + 0.57344000000000000000000000000000000000000000000001e-7 * t77 * t144 - 0.26214400000000000000000000000000000000000000000001e-9 * t139 * t157 - 0.43690666666666666666666666666666666666666666666667e-7 * t942 * t144 + 0.78643200000000000000000000000000000000000000000001e-9 * t87 * t157 - 0.34952533333333333333333333333333333333333333333334e-11 * t150 * t1033 * t602
  t1045 = t306 * t19
  t1071 = -0.53333333333333333333333333333333333333333333333333e0 * t955 * t116 * t310 + 0.64000000000000000000000000000000000000000000000001e0 * t1045 * t124 * t317 * s0 - 0.17066666666666666666666666666666666666666666666667e0 * t355 * t362 - 0.85333333333333333333333333333333333333333333333333e0 * t961 * t356 + 0.85333333333333333333333333333333333333333333333334e0 * t315 * t362 - 0.10240000000000000000000000000000000000000000000000e0 * t361 * t369 - 0.768e0 * t966 * t362 + 0.35840000000000000000000000000000000000000000000000e0 * t322 * t369 - 0.81920000000000000000000000000000000000000000000003e-1 * t367 * t377 - 0.27306666666666666666666666666666666666666666666667e0 * t971 * t369 + 0.24576000000000000000000000000000000000000000000000e0 * t329 * t377 - 0.54613333333333333333333333333333333333333333333335e-1 * t374 * t1033 * t792
  t1078 = t462 * t19
  t1104 = -0.16000000000000000000000000000000000000000000000000e-1 * t980 * t116 * t466 + 0.57600000000000000000000000000000000000000000000000e-3 * t1078 * t124 * t473 * s0 - 0.46080000000000000000000000000000000000000000000000e-5 * t504 * t511 - 0.76800000000000000000000000000000000000000000000000e-3 * t986 * t505 + 0.23040000000000000000000000000000000000000000000000e-4 * t471 * t511 - 0.82944000000000000000000000000000000000000000000000e-7 * t510 * t518 - 0.20736e-4 * t991 * t511 + 0.29030400000000000000000000000000000000000000000000e-6 * t478 * t518 - 0.19906560000000000000000000000000000000000000000000e-8 * t516 * t526 - 0.22118400000000000000000000000000000000000000000000e-6 * t996 * t518 + 0.59719680000000000000000000000000000000000000000000e-8 * t485 * t526 - 0.39813120000000000000000000000000000000000000000000e-10 * t523 * t1033 * t918
  v2rhosigma_0_ = 0.2e1 * t113 * t952 + 0.2e1 * t351 * t977 + t500 * t1002 + r0 * (t460 * t1002 + 0.2e1 * t113 * t1037 + 0.2e1 * t351 * t1071 + t500 * t1104 + 0.2e1 * t304 * t977 + 0.2e1 * t46 * t952)
  t1108 = t68 * t71
  t1132 = 0.1e1 / t598
  t1136 = -0.64e-4 * t1009 * t1108 + 0.512e-6 * t49 * t82 + 0.64e-4 * t62 * t19 * t1108 - 0.2048e-5 * t932 * t82 + 0.6144e-8 * t64 * t94 + 0.1536e-5 * t75 * s0 * t82 - 0.18432e-7 * t937 * t94 + 0.98304e-10 * t77 * t949 + 0.12288e-7 * t85 * t63 * t94 - 0.262144e-9 * t942 * t949 + 0.1310720e-11 * t87 * t1132 * t602
  t1139 = t68 * t317
  t1166 = -0.16e0 * t1045 * t1139 + 0.64e-1 * t307 * t325 + 0.16e0 * t314 * t19 * t1139 - 0.256e0 * t961 * t325 + 0.384e-1 * t315 * t332 + 0.192e0 * t321 * s0 * t325 - 0.1152e0 * t966 * t332 + 0.3072e-1 * t322 * t974 + 0.768e-1 * t328 * t63 * t332 - 0.8192e-1 * t971 * t974 + 0.20480e-1 * t329 * t1132 * t792
  t1169 = t68 * t473
  t1196 = -0.144e-3 * t1078 * t1169 + 0.1728e-5 * t463 * t481 + 0.144e-3 * t470 * t19 * t1169 - 0.6912e-5 * t986 * t481 + 0.31104e-7 * t471 * t488 + 0.5184e-5 * t477 * s0 * t481 - 0.93312e-7 * t991 * t488 + 0.746496e-9 * t478 * t999 + 0.62208e-7 * t484 * t63 * t488 - 0.1990656e-8 * t996 * t999 + 0.14929920e-10 * t485 * t1132 * t918
  v2sigma2_0_ = r0 * (0.2e1 * t113 * t1136 + 0.2e1 * t351 * t1166 + t500 * t1196)

  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = f.my_piecewise3(t3, 0.1e1 / t6, 1)
  t9 = t8 ** 2
  t10 = t9 * t8
  t14 = r0 / t10 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = jnp.pi ** (0.1e1 / 0.3e1)
  t19 = 2 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t15 / t16 * t20
  t23 = t6 * f.p.zeta_threshold
  t25 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t23, 0.2e1 * t19)
  t26 = r0 ** 2
  t27 = t26 * r0
  t28 = r0 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = 0.1e1 / t29 / t27
  t33 = 0.1e1 / t8
  t37 = f.my_piecewise3(t14, 0, 0.5e1 / 0.27e2 * t21 * t25 * t31 * t33)
  t38 = 0.0e0 <= f.p.dens_threshold
  t40 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t23, 0)
  t45 = f.my_piecewise3(t38, 0, 0.5e1 / 0.27e2 * t21 * t40 * t31 * t33)
  t49 = f.my_piecewise3(t4, 0, t5 * (t37 + t45) / 0.2e1)
  t51 = params.c_x[1]
  t52 = t51 * s0
  t54 = 0.1e1 / t29 / t26
  t55 = t20 * t54
  t57 = s0 * t20 * t54
  t59 = 0.1e1 + 0.4e-2 * t57
  t60 = 0.1e1 / t59
  t64 = params.c_x[2]
  t65 = s0 ** 2
  t66 = t64 * t65
  t67 = t26 ** 2
  t68 = t67 * r0
  t70 = 0.1e1 / t28 / t68
  t71 = t19 * t70
  t72 = t59 ** 2
  t73 = 0.1e1 / t72
  t77 = params.c_x[3]
  t78 = t65 * s0
  t79 = t77 * t78
  t80 = t67 ** 2
  t81 = 0.1e1 / t80
  t82 = t72 * t59
  t83 = 0.1e1 / t82
  t87 = params.c_x[4]
  t88 = t65 ** 2
  t89 = t87 * t88
  t90 = t80 * t26
  t93 = t20 / t29 / t90
  t94 = t72 ** 2
  t95 = 0.1e1 / t94
  t99 = params.c_x[0] + 0.4e-2 * t52 * t55 * t60 + 0.32e-4 * t66 * t71 * t73 + 0.256e-6 * t79 * t81 * t83 + 0.1024e-8 * t89 * t93 * t95
  t106 = f.my_piecewise3(t14, 0, -0.5e1 / 0.72e2 * t21 * t25 * t54 * t33)
  t111 = f.my_piecewise3(t38, 0, -0.5e1 / 0.72e2 * t21 * t40 * t54 * t33)
  t115 = f.my_piecewise3(t4, 0, t5 * (t106 + t111) / 0.2e1)
  t116 = t20 * t31
  t120 = t51 * t65
  t121 = t67 * t26
  t124 = t19 / t28 / t121
  t125 = t124 * t73
  t130 = t64 * t78
  t131 = t80 * r0
  t132 = 0.1e1 / t131
  t133 = t132 * t83
  t138 = t77 * t88
  t139 = t80 * t27
  t141 = 0.1e1 / t29 / t139
  t143 = t141 * t95 * t20
  t148 = t88 * s0
  t149 = t87 * t148
  t150 = t80 * t121
  t153 = t19 / t28 / t150
  t155 = 0.1e1 / t94 / t59
  t159 = -0.10666666666666666666666666666666666666666666666667e-1 * t52 * t116 * t60 + 0.85333333333333333333333333333333333333333333333336e-4 * t120 * t125 - 0.17066666666666666666666666666666666666666666666667e-3 * t66 * t125 + 0.13653333333333333333333333333333333333333333333334e-5 * t130 * t133 - 0.2048e-5 * t79 * t133 + 0.81920000000000000000000000000000000000000000000003e-8 * t138 * t143 - 0.10922666666666666666666666666666666666666666666667e-7 * t89 * t143 + 0.87381333333333333333333333333333333333333333333336e-10 * t149 * t153 * t155
  t163 = 0.1e1 / t29 / r0
  t168 = f.my_piecewise3(t14, 0, t21 * t25 * t163 * t33 / 0.24e2)
  t173 = f.my_piecewise3(t38, 0, t21 * t40 * t163 * t33 / 0.24e2)
  t177 = f.my_piecewise3(t4, 0, t5 * (t168 + t173) / 0.2e1)
  t179 = 0.1e1 / t29 / t67
  t180 = t20 * t179
  t184 = t67 * t27
  t187 = t19 / t28 / t184
  t188 = t187 * t73
  t191 = t51 * t78
  t192 = 0.1e1 / t90
  t193 = t192 * t83
  t200 = t64 * t88
  t201 = t80 * t67
  t203 = 0.1e1 / t29 / t201
  t205 = t203 * t95 * t20
  t212 = t77 * t148
  t215 = 0.1e1 / t28 / t80 / t184
  t217 = t215 * t155 * t19
  t224 = t88 * t65
  t225 = t87 * t224
  t226 = t80 ** 2
  t228 = 0.1e1 / t226 / t26
  t230 = 0.1e1 / t94 / t72
  t234 = 0.39111111111111111111111111111111111111111111111112e-1 * t52 * t180 * t60 - 0.76800000000000000000000000000000000000000000000003e-3 * t120 * t188 + 0.36408888888888888888888888888888888888888888888891e-5 * t191 * t193 + 0.10808888888888888888888888888888888888888888888889e-2 * t66 * t188 - 0.19569777777777777777777777777777777777777777777779e-4 * t130 * t193 + 0.43690666666666666666666666666666666666666666666670e-7 * t200 * t205 + 0.18432e-4 * t79 * t193 - 0.16110933333333333333333333333333333333333333333334e-6 * t138 * t205 + 0.69905066666666666666666666666666666666666666666671e-9 * t212 * t217 + 0.12743111111111111111111111111111111111111111111112e-6 * t89 * t205 - 0.21845333333333333333333333333333333333333333333334e-8 * t149 * t217 + 0.93206755555555555555555555555555555555555555555561e-11 * t225 * t228 * t230
  t237 = 0.1e1 / t29
  t242 = f.my_piecewise3(t14, 0, -t21 * t25 * t237 * t33 / 0.16e2)
  t247 = f.my_piecewise3(t38, 0, -t21 * t40 * t237 * t33 / 0.16e2)
  t251 = f.my_piecewise3(t4, 0, t5 * (t242 + t247) / 0.2e1)
  t254 = t20 / t29 / t68
  t260 = t19 / t28 / t80
  t261 = t260 * t73
  t264 = 0.1e1 / t139
  t265 = t264 * t83
  t268 = t51 * t88
  t271 = 0.1e1 / t29 / t80 / t68
  t273 = t271 * t95 * t20
  t282 = t64 * t148
  t284 = 0.1e1 / t28 / t226
  t286 = t284 * t155 * t19
  t295 = t77 * t224
  t297 = 0.1e1 / t226 / t27
  t298 = t297 * t230
  t307 = t88 * t78
  t308 = t87 * t307
  t311 = 0.1e1 / t29 / t226 / t68
  t313 = 0.1e1 / t94 / t82
  t318 = -0.18251851851851851851851851851851851851851851851852e0 * t52 * t254 * t60 + 0.64663703703703703703703703703703703703703703703706e-2 * t120 * t261 - 0.69176888888888888888888888888888888888888888888893e-4 * t191 * t265 + 0.11650844444444444444444444444444444444444444444445e-6 * t268 * t273 - 0.79265185185185185185185185185185185185185185185186e-2 * t66 * t261 + 0.24181570370370370370370370370370370370370370370372e-3 * t130 * t265 - 0.11796480000000000000000000000000000000000000000001e-5 * t200 * t273 + 0.37282702222222222222222222222222222222222222222226e-8 * t282 * t286 - 0.184320e-3 * t79 * t265 + 0.26305422222222222222222222222222222222222222222223e-5 * t138 * t273 - 0.24466773333333333333333333333333333333333333333335e-7 * t212 * t286 + 0.74565404444444444444444444444444444444444444444451e-10 * t295 * t298 - 0.16141274074074074074074074074074074074074074074075e-5 * t89 * t273 + 0.44370299259259259259259259259259259259259259259262e-7 * t149 * t286 - 0.40078904888888888888888888888888888888888888888891e-9 * t225 * t298 + 0.59652323555555555555555555555555555555555555555561e-12 * t308 * t311 * t313 * t20
  t325 = f.my_piecewise3(t14, 0, -0.3e1 / 0.16e2 * t21 * t25 * t28 * t33)
  t330 = f.my_piecewise3(t38, 0, -0.3e1 / 0.16e2 * t21 * t40 * t28 * t33)
  t334 = f.my_piecewise3(t4, 0, t5 * (t325 + t330) / 0.2e1)
  t335 = 0.1e1 / t201
  t336 = t335 * t83
  t343 = 0.1e1 / t226 / t67
  t344 = t343 * t230
  t352 = 0.1e1 / t29 / t150
  t354 = t352 * t95 * t20
  t360 = 0.1e1 / t28 / t226 / r0
  t362 = t360 * t155 * t19
  t378 = 0.1e1 / t29 / t226 / t121
  t380 = t378 * t313 * t20
  t387 = t88 ** 2
  t391 = 0.1e1 / t28 / t226 / t131
  t392 = t94 ** 2
  t400 = t19 / t28 / t131
  t401 = t400 * t73
  t408 = t20 / t29 / t121
  t414 = 0.10368442469135802469135802469135802469135802469136e-2 * t191 * t336 - 0.29981708641975308641975308641975308641975308641977e-2 * t130 * t336 + 0.39768215703703703703703703703703703703703703703709e-9 * t64 * t224 * t344 - 0.40265318400000000000000000000000000000000000000004e-8 * t295 * t344 + 0.12347823849876543209876543209876543209876543209877e-7 * t225 * t344 - 0.38059425185185185185185185185185185185185185185188e-5 * t268 * t354 + 0.99420539259259259259259259259259259259259259259267e-8 * t51 * t148 * t362 + 0.23859958518518518518518518518518518518518518518520e-4 * t200 * t354 - 0.16155837629629629629629629629629629629629629629631e-6 * t282 * t362 + 0.2027520e-2 * t79 * t336 - 0.41848983703703703703703703703703703703703703703705e-4 * t138 * t354 + 0.62409690074074074074074074074074074074074074074078e-6 * t212 * t362 + 0.47721858844444444444444444444444444444444444444450e-11 * t77 * t307 * t380 - 0.86245376000000000000000000000000000000000000000006e-6 * t149 * t362 - 0.38575169232592592592592592592592592592592592592596e-10 * t308 * t380 + 0.89080803176296296296296296296296296296296296296308e-13 * t87 * t387 * t391 / t392 * t19 + 0.66054320987654320987654320987654320987654320987655e-1 * t66 * t401 + 0.22059741234567901234567901234567901234567901234569e-4 * t89 * t354 + 0.10342716049382716049382716049382716049382716049383e1 * t52 * t408 * t60 - 0.57780148148148148148148148148148148148148148148150e-1 * t120 * t401
  t420 = 0.1e1 / (0.2e1 * t19 - 0.2e1)
  t421 = (t25 + t40 - 0.2e1) * t420
  t422 = 0.1e1 / jnp.pi
  t423 = t422 ** (0.1e1 / 0.3e1)
  t424 = t15 * t423
  t425 = 4 ** (0.1e1 / 0.3e1)
  t426 = t425 ** 2
  t427 = t424 * t426
  t428 = 0.1e1 / t28
  t431 = t427 * t428 * t19 * t8
  t433 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t431
  t434 = t421 * t433
  t435 = jnp.sqrt(t431)
  t438 = t431 ** 0.15e1
  t440 = t15 ** 2
  t441 = t423 ** 2
  t442 = t440 * t441
  t443 = t442 * t425
  t446 = t443 * t237 * t20 * t9
  t448 = 0.51785000000000000000000000000000000000000000000000e1 * t435 + 0.90577500000000000000000000000000000000000000000000e0 * t431 + 0.11003250000000000000000000000000000000000000000000e0 * t438 + 0.12417750000000000000000000000000000000000000000000e0 * t446
  t449 = t448 ** 2
  t450 = t449 ** 2
  t452 = 0.1e1 / t450 / t449
  t456 = 0.1e1 / t435 / t431 * t440 * t441
  t457 = t425 * t54
  t458 = t20 * t9
  t459 = t457 * t458
  t460 = t456 * t459
  t464 = 0.1e1 / t435 * t15 * t423
  t466 = 0.1e1 / t28 / t26
  t467 = t426 * t466
  t468 = t19 * t8
  t469 = t467 * t468
  t470 = t464 * t469
  t472 = t466 * t19
  t473 = t472 * t8
  t474 = t427 * t473
  t476 = t431 ** (-0.5e0)
  t478 = t476 * t440 * t441
  t479 = t478 * t459
  t481 = t431 ** 0.5e0
  t483 = t481 * t15 * t423
  t484 = t483 * t469
  t487 = t443 * t55 * t9
  t489 = -0.57538888888888888888888888888888888888888888888889e0 * t460 + 0.11507777777777777777777777777777777777777777777778e1 * t470 + 0.40256666666666666666666666666666666666666666666667e0 * t474 + 0.36677500000000000000000000000000000000000000000000e-1 * t479 + 0.73355000000000000000000000000000000000000000000000e-1 * t484 + 0.13797500000000000000000000000000000000000000000000e0 * t487
  t493 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t448
  t494 = t493 ** 2
  t496 = 0.1e1 / t494 / t493
  t498 = 0.1e1 / t28 / r0
  t499 = t426 * t498
  t500 = t499 * t468
  t501 = t464 * t500
  t503 = t498 * t19
  t504 = t503 * t8
  t505 = t427 * t504
  t507 = t483 * t500
  t511 = t443 * t163 * t20 * t9
  t513 = -0.86308333333333333333333333333333333333333333333334e0 * t501 - 0.30192500000000000000000000000000000000000000000000e0 * t505 - 0.55016250000000000000000000000000000000000000000000e-1 * t507 - 0.82785000000000000000000000000000000000000000000000e-1 * t511
  t514 = t513 ** 2
  t515 = t496 * t514
  t520 = t424 * t499 * t19
  t525 = 0.37978500000000000000000000000000000000000000000000e1 * t435 + 0.89690000000000000000000000000000000000000000000000e0 * t431 + 0.20477500000000000000000000000000000000000000000000e0 * t438 + 0.12323500000000000000000000000000000000000000000000e0 * t446
  t526 = t525 ** 2
  t527 = t526 ** 2
  t528 = 0.1e1 / t527
  t536 = -0.42198333333333333333333333333333333333333333333333e0 * t460 + 0.84396666666666666666666666666666666666666666666666e0 * t470 + 0.39862222222222222222222222222222222222222222222223e0 * t474 + 0.68258333333333333333333333333333333333333333333333e-1 * t479 + 0.13651666666666666666666666666666666666666666666667e0 * t484 + 0.13692777777777777777777777777777777777777777777778e0 * t487
  t539 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t525
  t540 = t539 ** 2
  t541 = 0.1e1 / t540
  t547 = -0.63297500000000000000000000000000000000000000000000e0 * t501 - 0.29896666666666666666666666666666666666666666666667e0 * t505 - 0.10238750000000000000000000000000000000000000000000e0 * t507 - 0.82156666666666666666666666666666666666666666666667e-1 * t511
  t548 = t536 * t541 * t547
  t551 = 0.34366858576436911003184201215785918754623524492620e1 * t520 * t8 * t528 * t548
  t552 = t526 * t525
  t553 = 0.1e1 / t552
  t555 = 0.1e1 / t539
  t556 = t547 * t555
  t557 = t556 * t536
  t560 = 0.42740000000000000000000000000000000000000000000000e0 * t520 * t8 * t553 * t557
  t561 = 0.1e1 / t450
  t562 = t489 ** 2
  t564 = 0.1e1 / t494
  t568 = t449 * t448
  t570 = 0.1e1 / t450 / t568
  t571 = t514 ** 2
  t577 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t431
  t579 = 0.1e1 / t527 / t526
  t580 = t577 * t579
  t581 = t547 ** 2
  t582 = t581 ** 2
  t585 = 0.57894567559743977356791354411244411566048052491077e3 * t580 * t582 * t541
  t590 = 0.1e1 / t568
  t591 = t590 * t513
  t592 = 0.1e1 / t493
  t596 = 0.1e1 / t435 / t446 * t422 / 0.4e1
  t597 = 0.1e1 / t67
  t598 = t597 * t10
  t599 = t596 * t598
  t601 = t425 * t31
  t602 = t601 * t458
  t603 = t456 * t602
  t606 = 0.1e1 / t28 / t27
  t607 = t426 * t606
  t608 = t607 * t468
  t609 = t464 * t608
  t611 = t606 * t19
  t612 = t611 * t8
  t613 = t427 * t612
  t615 = t431 ** (-0.15e1)
  t616 = t615 * t422
  t617 = t616 * t598
  t619 = t478 * t602
  t621 = t483 * t608
  t624 = t443 * t116 * t9
  t626 = -0.69046666666666666666666666666666666666666666666667e1 * t599 + 0.23015555555555555555555555555555555555555555555556e1 * t603 - 0.26851481481481481481481481481481481481481481481482e1 * t609 - 0.93932222222222222222222222222222222222222222222223e0 * t613 + 0.14671000000000000000000000000000000000000000000000e0 * t617 - 0.14671000000000000000000000000000000000000000000000e0 * t619 - 0.17116166666666666666666666666666666666666666666667e0 * t621 - 0.36793333333333333333333333333333333333333333333333e0 * t624
  t627 = t592 * t626
  t631 = t450 ** 2
  t632 = 0.1e1 / t631
  t634 = t494 ** 2
  t635 = 0.1e1 / t634
  t639 = 0.1e1 / t449
  t641 = t422 / r0
  t647 = t9 ** 2
  t648 = t70 * t647
  t651 = t424 * t426 * t19
  t652 = 0.1e1 / t435 / t641 / t10 * t422 * t648 * t651 / 0.96e2
  t654 = 0.1e1 / t68
  t655 = t654 * t10
  t656 = t596 * t655
  t658 = t425 * t179
  t659 = t658 * t458
  t660 = t456 * t659
  t663 = 0.1e1 / t28 / t67
  t664 = t426 * t663
  t665 = t664 * t468
  t666 = t464 * t665
  t668 = t663 * t19
  t670 = t427 * t668 * t8
  t672 = t431 ** (-0.25e1)
  t675 = t672 * t422 * t648 * t651
  t677 = t616 * t655
  t679 = t478 * t659
  t681 = t483 * t665
  t684 = t443 * t180 * t9
  t686 = -0.57538888888888888888888888888888888888888888888889e1 * t652 + 0.55237333333333333333333333333333333333333333333334e2 * t656 - 0.10229135802469135802469135802469135802469135802469e2 * t660 + 0.89504938271604938271604938271604938271604938271607e1 * t666 + 0.31310740740740740740740740740740740740740740740741e1 * t670 + 0.73355000000000000000000000000000000000000000000000e-1 * t675 - 0.11736800000000000000000000000000000000000000000000e1 * t677 + 0.65204444444444444444444444444444444444444444444445e0 * t679 + 0.57053888888888888888888888888888888888888888888890e0 * t681 + 0.13490888888888888888888888888888888888888888888889e1 * t684
  t695 = 0.70594500000000000000000000000000000000000000000000e1 * t435 + 0.15494250000000000000000000000000000000000000000000e1 * t431 + 0.42077500000000000000000000000000000000000000000000e0 * t438 + 0.15629250000000000000000000000000000000000000000000e0 * t446
  t696 = t695 ** 2
  t697 = t696 * t695
  t698 = 0.1e1 / t697
  t704 = -0.11765750000000000000000000000000000000000000000000e1 * t501 - 0.51647500000000000000000000000000000000000000000000e0 * t505 - 0.21038750000000000000000000000000000000000000000000e0 * t507 - 0.10419500000000000000000000000000000000000000000000e0 * t511
  t707 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t695
  t708 = 0.1e1 / t707
  t709 = t704 * t708
  t716 = -0.78438333333333333333333333333333333333333333333333e0 * t460 + 0.15687666666666666666666666666666666666666666666667e1 * t470 + 0.68863333333333333333333333333333333333333333333333e0 * t474 + 0.14025833333333333333333333333333333333333333333333e0 * t479 + 0.28051666666666666666666666666666666666666666666667e0 * t484 + 0.17365833333333333333333333333333333333333333333333e0 * t487
  t717 = t709 * t716
  t721 = t433 * t561
  t726 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t431
  t727 = t696 ** 2
  t731 = t704 ** 2
  t732 = t731 ** 2
  t733 = t707 ** 2
  t735 = 0.1e1 / t733 / t707
  t740 = 0.1e1 / t727 / t695
  t741 = t726 * t740
  t746 = 0.1e1 / t450 / t448
  t747 = t433 * t746
  t755 = t433 * t639
  t764 = 0.1e1 / t727 / t696
  t765 = t726 * t764
  t766 = 0.1e1 / t733
  t770 = t433 * t452
  t774 = t727 ** 2
  t777 = t733 ** 2
  t782 = 0.1e1 / t696
  t783 = t726 * t782
  t798 = 0.1e1 / t727
  t799 = t726 * t798
  t800 = t716 ** 2
  t804 = t433 * t590
  t808 = t551 - t560 + 0.41096000000000000000000000000000000000000000000000e0 * t520 * t8 * t698 * t717 + 0.51947267698127589899017076750918898776700016259463e2 * t721 * t562 * t564 - 0.24829604254387158294210325990977956380799639474146e5 * t726 / t727 / t697 * t732 * t735 - 0.24000000000000000000000000000000000000000000000000e2 * t741 * t732 * t708 - 0.14035736153892489769995222001484279098274130793177e2 * t747 * t571 * t592 - 0.12304676425209353916981601646454408427003023925970e5 * t433 * t570 * t571 * t496 - t585 + 0.58482233974552040708313425006184496242808878304903e0 * t755 * t686 * t592 + 0.91080982599109921218848830805163797795664001346962e5 * t433 * t632 * t571 * t635 + 0.11579285944033451270504985525892569958185911868768e4 * t765 * t732 * t766 + 0.62336721237753107878820492101102678532040019511358e3 * t770 * t571 * t564 + 0.19965908856856833623520686708731068173688999255505e6 * t726 / t774 * t732 / t777 + 0.99999999999999999999999999999999999999999999999999e0 * t783 * (-0.78438333333333333333333333333333333333333333333333e1 * t652 + 0.75300800000000000000000000000000000000000000000001e2 * t656 - 0.13944592592592592592592592592592592592592592592593e2 * t660 + 0.12201518518518518518518518518518518518518518518519e2 * t666 + 0.53560370370370370370370370370370370370370370370370e1 * t670 + 0.28051666666666666666666666666666666666666666666666e0 * t675 - 0.44882666666666666666666666666666666666666666666666e1 * t677 + 0.24934814814814814814814814814814814814814814814815e1 * t679 + 0.21817962962962962962962962962962962962962962962963e1 * t681 + 0.16979925925925925925925925925925925925925925925926e1 * t684) * t708 + 0.96494049533612093920874879382438082984882598906400e2 * t799 * t800 * t766 - 0.35089340384731224424988055003710697745685326982943e1 * t804 * t562 * t592
  t809 = t577 * t528
  t818 = -0.50638000000000000000000000000000000000000000000000e1 * t599 + 0.16879333333333333333333333333333333333333333333333e1 * t603 - 0.19692555555555555555555555555555555555555555555555e1 * t609 - 0.93011851851851851851851851851851851851851851851854e0 * t613 + 0.27303333333333333333333333333333333333333333333333e0 * t617 - 0.27303333333333333333333333333333333333333333333333e0 * t619 - 0.31853888888888888888888888888888888888888888888890e0 * t621 - 0.36514074074074074074074074074074074074074074074075e0 * t624
  t822 = 0.64327297288604419285323727123604901740053391656752e2 * t809 * t818 * t541 * t547
  t823 = t581 * t555
  t826 = 0.36000000000000000000000000000000000000000000000000e2 * t809 * t823 * t536
  t827 = t726 * t698
  t836 = -0.94126000000000000000000000000000000000000000000000e1 * t599 + 0.31375333333333333333333333333333333333333333333334e1 * t603 - 0.36604555555555555555555555555555555555555555555556e1 * t609 - 0.16068111111111111111111111111111111111111111111111e1 * t613 + 0.56103333333333333333333333333333333333333333333332e0 * t617 - 0.56103333333333333333333333333333333333333333333332e0 * t619 - 0.65453888888888888888888888888888888888888888888890e0 * t621 - 0.46308888888888888888888888888888888888888888888888e0 * t624
  t840 = t731 * t766
  t844 = t731 * t708
  t849 = 0.1e1 / t540 / t539
  t853 = 0.31035008823423701047887038270048358885233697045812e4 * t580 * t581 * t849 * t536
  t862 = t514 * t564
  t866 = t514 * t592
  t881 = 0.1e1 / t527 / t525
  t882 = t577 * t881
  t883 = t581 * t541
  t886 = 0.57894567559743977356791354411244411566048052491077e3 * t882 * t883 * t536
  t887 = t577 * t553
  t888 = t818 * t555
  t891 = 0.80000000000000000000000000000000000000000000000000e1 * t887 * t888 * t547
  t892 = jnp.log(t539)
  t893 = t8 * t892
  t896 = 0.11483710345679012345679012345679012345679012345679e-1 * t427 * t668 * t893
  t897 = jnp.log(t493)
  t898 = t8 * t897
  t902 = -t822 - t826 - 0.80000000000000000000000000000000000000000000000000e1 * t827 * t709 * t836 - 0.11579285944033451270504985525892569958185911868768e4 * t741 * t840 * t716 + 0.36000000000000000000000000000000000000000000000000e2 * t799 * t844 * t716 - t853 + 0.12865873271148279189449983917658411064651013187520e3 * t799 * t836 * t766 * t704 + 0.12414802127193579147105162995488978190399819737073e5 * t765 * t716 * t735 * t731 - 0.62336721237753107878820492101102678532040019511357e3 * t747 * t862 * t489 + 0.21053604230838734654992833002226418647411196189766e2 * t721 * t866 * t489 - 0.46785787179641632566650740004947596994247102643924e1 * t804 * t627 * t513 + 0.69263023597503453198689435667891865035600021679284e2 * t721 * t626 * t564 * t513 + 0.61523382126046769584908008232272042135015119629847e4 * t770 * t515 * t489 + t886 + t891 + t896 - 0.18989760778855128828022312575107704239400966910600e-2 * t427 * t668 * t898
  t904 = jnp.log(t707)
  t905 = t8 * t904
  t909 = t424 * t499
  t910 = t731 * t704
  t921 = t424 * t467
  t922 = 0.1e1 / t526
  t925 = t468 * t922 * t536 * t555
  t927 = 0.14246666666666666666666666666666666666666666666666e0 * t921 * t925
  t930 = t468 * t528 * t581 * t541
  t932 = 0.22911239050957940668789467477190612503082349661746e1 * t921 * t930
  t933 = t581 * t547
  t938 = 0.42740000000000000000000000000000000000000000000000e0 * t909 * t468 * t528 * t933 * t555
  t943 = 0.68733717152873822006368402431571837509247048985239e1 * t909 * t468 * t881 * t933 * t541
  t948 = 0.71233333333333333333333333333333333333333333333332e-1 * t909 * t468 * t922 * t818 * t555
  t949 = t424 * t607
  t952 = t468 * t922 * t547 * t555
  t954 = 0.22161481481481481481481481481481481481481481481481e0 * t949 * t952
  t959 = 0.36845452142031360632963667101718523854302450326054e2 * t909 * t468 * t579 * t933 * t849
  t960 = t514 * t513
  t962 = t561 * t960 * t592
  t967 = t746 * t960 * t564
  t972 = t639 * t489 * t592
  t973 = t468 * t972
  t978 = t468 * t782 * t704 * t708
  t982 = t639 * t513 * t592
  t983 = t468 * t982
  t996 = -0.55208163456790123456790123456790123456790123456787e-2 * t427 * t668 * t905 + 0.13218398198777742039240913477002251527822450948858e2 * t909 * t468 * t740 * t910 * t766 - 0.14172186339420759128595382735072640214240860886520e3 * t909 * t468 * t764 * t910 * t735 - t927 - t932 + t938 - t943 + t948 + t954 + t959 - 0.13012297059337829057599737063876050414024975422841e0 * t909 * t468 * t962 + 0.38527556876111295841770998590264849926052512059102e1 * t909 * t468 * t967 + 0.43374323531126096858665790212920168046749918076136e-1 * t921 * t973 - 0.21309037037037037037037037037037037037037037037036e0 * t949 * t978 - 0.67471169937307261780146784775653594739388761451767e-1 * t949 * t983 - 0.41096000000000000000000000000000000000000000000000e0 * t909 * t468 * t798 * t910 * t708 - 0.68493333333333333333333333333333333333333333333332e-1 * t909 * t468 * t782 * t836 * t708
  t998 = t639 * t626 * t592
  t1003 = t452 * t960 * t496
  t1007 = t561 * t514
  t1008 = t1007 * t564
  t1009 = t468 * t1008
  t1014 = t468 * t698 * t731 * t708
  t1018 = t590 * t514 * t592
  t1019 = t468 * t1018
  t1024 = t468 * t553 * t581 * t555
  t1026 = 0.28493333333333333333333333333333333333333333333334e0 * t921 * t1024
  t1029 = t468 * t782 * t716 * t708
  t1034 = t468 * t798 * t731 * t766
  t1038 = t513 * t564
  t1039 = t1038 * t489
  t1044 = t513 * t592
  t1045 = t1044 * t489
  t1051 = t716 * t766 * t704
  t1055 = t536 ** 2
  t1058 = 0.48245472966453314463992795342703676305040043742564e2 * t809 * t1055 * t541
  t1061 = 0.24000000000000000000000000000000000000000000000000e2 * t882 * t582 * t555
  t1064 = 0.60000000000000000000000000000000000000000000000000e1 * t887 * t1055 * t555
  t1070 = 0.62070017646847402095774076540096717770467394091622e4 * t577 / t527 / t552 * t582 * t849
  t1071 = t577 * t922
  t1085 = 0.10000000000000000000000000000000000000000000000000e1 * t1071 * (-0.42198333333333333333333333333333333333333333333333e1 * t652 + 0.40510400000000000000000000000000000000000000000000e2 * t656 - 0.75019259259259259259259259259259259259259259259258e1 * t660 + 0.65641851851851851851851851851851851851851851851850e1 * t666 + 0.31003950617283950617283950617283950617283950617285e1 * t670 + 0.13651666666666666666666666666666666666666666666666e0 * t675 - 0.21842666666666666666666666666666666666666666666666e1 * t677 + 0.12134814814814814814814814814814814814814814814815e1 * t679 + 0.10617962962962962962962962962962962962962962962963e1 * t681 + 0.13388493827160493827160493827160493827160493827161e1 * t684) * t555
  t1086 = t527 ** 2
  t1089 = t540 ** 2
  t1093 = 0.24954977986735470914321699422701391789612506067521e5 * t577 / t1086 * t582 / t1089
  t1097 = -0.21687161765563048429332895106460084023374959038068e-1 * t909 * t468 * t998 - 0.38024868119570572868450088421334803819557955882337e2 * t909 * t468 * t1003 + 0.12842518958703765280590332863421616642017504019700e1 * t921 * t1009 - 0.27397333333333333333333333333333333333333333333333e0 * t921 * t1014 - 0.86748647062252193717331580425840336093499836152272e-1 * t921 * t1019 + t1026 + 0.13698666666666666666666666666666666666666666666666e0 * t921 * t1029 + 0.44061327329259140130803044923340838426074836496192e1 * t921 * t1034 - 0.19263778438055647920885499295132424963026256029551e1 * t520 * t8 * t561 * t1039 + 0.13012297059337829057599737063876050414024975422841e0 * t520 * t8 * t590 * t1045 - 0.66091990993888710196204567385011257639112254744288e1 * t520 * t8 * t798 * t1051 - t1058 + t1061 + t1064 + t1070 - t1085 - t1093 - 0.60000000000000000000000000000000000000000000000000e1 * t827 * t800 * t708
  t1101 = -0.61523382126046769584908008232272042135015119629847e4 * t434 * t452 * t489 * t515 - t551 + t560 - 0.51947267698127589899017076750918898776700016259463e2 * t434 * t561 * t562 * t564 + 0.12304676425209353916981601646454408427003023925970e5 * t434 * t570 * t571 * t496 + t585 - 0.62336721237753107878820492101102678532040019511358e3 * t434 * t452 * t571 * t564 + 0.46785787179641632566650740004947596994247102643924e1 * t434 * t591 * t627 - 0.91080982599109921218848830805163797795664001346962e5 * t434 * t632 * t571 * t635 - 0.58482233974552040708313425006184496242808878304903e0 * t434 * t639 * t686 * t592 + t421 * (t808 + t902 + t996 + t1097)
  t1102 = t421 * t427
  t1124 = t822 + t826 + t853 - t886 - t891 + 0.13012297059337829057599737063876050414024975422841e0 * t1102 * t504 * t962 - 0.43374323531126096858665790212920168046749918076136e-1 * t1102 * t473 * t972 - 0.12842518958703765280590332863421616642017504019700e1 * t1102 * t473 * t1008 + 0.21687161765563048429332895106460084023374959038068e-1 * t1102 * t504 * t998 + 0.38024868119570572868450088421334803819557955882337e2 * t1102 * t504 * t1003 - 0.38527556876111295841770998590264849926052512059102e1 * t1102 * t504 * t967 + 0.67471169937307261780146784775653594739388761451767e-1 * t1102 * t612 * t982
  t1129 = t421 * t424
  t1130 = t468 * t897
  t1135 = t423 * t426
  t1136 = t1135 * t498
  t1137 = t421 * t15 * t1136
  t1142 = 0.86748647062252193717331580425840336093499836152272e-1 * t1102 * t473 * t1018 - t896 + t927 + t932 - t938 + t943 - t948 - t954 + 0.18989760778855128828022312575107704239400966910600e-2 * t1129 * t664 * t1130 - t959 - t1026 + 0.19263778438055647920885499295132424963026256029551e1 * t1137 * t468 * t561 * t1039
  t1147 = t592 * t489
  t1167 = -0.13012297059337829057599737063876050414024975422841e0 * t1137 * t468 * t590 * t1045 - 0.21053604230838734654992833002226418647411196189766e2 * t434 * t1007 * t1147 + 0.62336721237753107878820492101102678532040019511357e3 * t434 * t746 * t489 * t862 - 0.69263023597503453198689435667891865035600021679284e2 * t434 * t561 * t626 * t1038 + 0.14035736153892489769995222001484279098274130793177e2 * t434 * t746 * t571 * t592 + 0.35089340384731224424988055003710697745685326982943e1 * t434 * t590 * t562 * t592 + t1058 - t1061 - t1064 - t1070 + t1085 + t1093
  t1172 = f.my_piecewise3(t4, 0, t5 * (t1101 + t1124 + t1142 + t1167) / 0.2e1)
  t1174 = params.c_ss[1]
  t1175 = t1174 * s0
  t1177 = 0.1e1 + 0.2e0 * t57
  t1178 = 0.1e1 / t1177
  t1182 = params.c_ss[2]
  t1183 = t1182 * t65
  t1184 = t1177 ** 2
  t1185 = 0.1e1 / t1184
  t1189 = params.c_ss[3]
  t1190 = t1189 * t78
  t1191 = t1184 * t1177
  t1192 = 0.1e1 / t1191
  t1196 = params.c_ss[4]
  t1197 = t1196 * t88
  t1198 = t1184 ** 2
  t1199 = 0.1e1 / t1198
  t1203 = params.c_ss[0] + 0.2e0 * t1175 * t55 * t1178 + 0.8e-1 * t1183 * t71 * t1185 + 0.32e-1 * t1190 * t81 * t1192 + 0.64e-2 * t1197 * t93 * t1199
  t1226 = 0.51725014705706168413145063783413931475389495076352e3 * t580 * t933 * t849
  t1229 = 0.34451131037037037037037037037037037037037037037036e-2 * t427 * t611 * t893
  t1236 = -0.51947267698127589899017076750918898776700016259463e2 * t434 * t561 * t489 * t1038 + 0.35089340384731224424988055003710697745685326982943e1 * t434 * t591 * t1147 - 0.35089340384731224424988055003710697745685326982943e1 * t434 * t962 - 0.21687161765563048429332895106460084023374959038068e-1 * t1102 * t473 * t982 + 0.16265371324172286321999671329845063017531219278551e-1 * t1102 * t504 * t972 + 0.48159446095139119802213748237831062407565640073877e0 * t1102 * t504 * t1008 + t1226 + t1229 - 0.10253897021007794930818001372045340355835853271641e4 * t434 * t1003 + 0.10389453539625517979803415350183779755340003251893e3 * t434 * t967 - 0.58482233974552040708313425006184496242808878304903e0 * t434 * t998
  t1239 = 0.96490945932906628927985590685407352610080087485128e2 * t882 * t933 * t541
  t1241 = 0.10000000000000000000000000000000000000000000000000e1 * t1071 * t888
  t1243 = 0.48245472966453314463992795342703676305040043742564e2 * t809 * t548
  t1246 = 0.60000000000000000000000000000000000000000000000000e1 * t809 * t933 * t555
  t1248 = 0.60000000000000000000000000000000000000000000000000e1 * t887 * t557
  t1281 = -t1229 - 0.10389453539625517979803415350183779755340003251893e3 * t747 * t960 * t564 + 0.60000000000000000000000000000000000000000000000000e1 * t799 * t910 * t708 + 0.35089340384731224424988055003710697745685326982943e1 * t721 * t960 * t592 + 0.58482233974552040708313425006184496242808878304903e0 * t755 * t627 + 0.10253897021007794930818001372045340355835853271641e4 * t770 * t960 * t496 + 0.99999999999999999999999999999999999999999999999999e0 * t783 * t836 * t708 + 0.20691336878655965245175271659148296983999699561788e4 * t765 * t910 * t735 - t1226 + t1239 - t1241 - t1246 - 0.19298809906722418784174975876487616596976519781280e3 * t741 * t910 * t766 - 0.60000000000000000000000000000000000000000000000000e1 * t827 * t717 + 0.96494049533612093920874879382438082984882598906400e2 * t799 * t1051 - 0.35089340384731224424988055003710697745685326982943e1 * t804 * t1045
  t1285 = 0.71233333333333333333333333333333333333333333333333e-1 * t921 * t952
  t1287 = 0.53424999999999999999999999999999999999999999999999e-1 * t909 * t925
  t1289 = 0.85917146441092277507960503039464796886558811231548e0 * t909 * t930
  t1291 = 0.10685000000000000000000000000000000000000000000000e0 * t909 * t1024
  t1314 = 0.51947267698127589899017076750918898776700016259463e2 * t721 * t1039 - t1243 + t1248 - t1285 + t1287 + t1289 - t1291 + 0.10274000000000000000000000000000000000000000000000e0 * t909 * t1014 + 0.32530742648344572643999342659690126035062438557102e-1 * t909 * t1019 - 0.48159446095139119802213748237831062407565640073877e0 * t909 * t1009 + 0.21687161765563048429332895106460084023374959038068e-1 * t921 * t983 - 0.16265371324172286321999671329845063017531219278551e-1 * t909 * t973 + 0.68493333333333333333333333333333333333333333333331e-1 * t921 * t978 - 0.51369999999999999999999999999999999999999999999999e-1 * t909 * t1029 - 0.16522997748472177549051141846252814409778063686072e1 * t909 * t1034 + 0.16562449037037037037037037037037037037037037037036e-2 * t427 * t611 * t905 + 0.56969282336565386484066937725323112718202900731800e-3 * t427 * t611 * t898
  t1320 = -t1239 + t1241 + t1243 + t1246 - t1248 - 0.32530742648344572643999342659690126035062438557102e-1 * t1102 * t504 * t1018 + t421 * (t1281 + t1314) + t1285 - t1287 - t1289 + t1291 - 0.56969282336565386484066937725323112718202900731800e-3 * t1129 * t607 * t1130
  t1324 = f.my_piecewise3(t4, 0, t5 * (t1236 + t1320) / 0.2e1)
  t1328 = t1174 * t65
  t1329 = t124 * t1185
  t1334 = t1182 * t78
  t1335 = t132 * t1192
  t1340 = t1189 * t88
  t1342 = t141 * t1199 * t20
  t1347 = t1196 * t148
  t1349 = 0.1e1 / t1198 / t1177
  t1353 = -0.53333333333333333333333333333333333333333333333333e0 * t1175 * t116 * t1178 + 0.21333333333333333333333333333333333333333333333334e0 * t1328 * t1329 - 0.42666666666666666666666666666666666666666666666667e0 * t1183 * t1329 + 0.17066666666666666666666666666666666666666666666667e0 * t1334 * t1335 - 0.256e0 * t1190 * t1335 + 0.51200000000000000000000000000000000000000000000000e-1 * t1340 * t1342 - 0.68266666666666666666666666666666666666666666666667e-1 * t1197 * t1342 + 0.27306666666666666666666666666666666666666666666668e-1 * t1347 * t153 * t1349
  t1358 = 0.14764770444444444444444444444444444444444444444444e-2 * t427 * t472 * t893
  t1360 = 0.35616666666666666666666666666666666666666666666666e-1 * t909 * t952
  t1362 = 0.20000000000000000000000000000000000000000000000000e1 * t887 * t823
  t1365 = 0.10000000000000000000000000000000000000000000000000e1 * t1071 * t536 * t555
  t1367 = 0.16081824322151104821330931780901225435013347914188e2 * t809 * t883
  t1391 = -0.70981924444444444444444444444444444444444444444442e-3 * t427 * t472 * t905 - 0.34246666666666666666666666666666666666666666666666e-1 * t909 * t978 - 0.20000000000000000000000000000000000000000000000000e1 * t827 * t844 + 0.99999999999999999999999999999999999999999999999999e0 * t783 * t716 * t708 + 0.32164683177870697973624959794146027661627532968800e2 * t799 * t840 + t1358 + t1360 + t1362 - t1365 - t1367 - 0.24415406715670879921742973310852762593515528885057e-3 * t427 * t472 * t898 - 0.10843580882781524214666447553230042011687479519034e-1 * t909 * t983 - 0.11696446794910408141662685001236899248561775660981e1 * t804 * t866 + 0.58482233974552040708313425006184496242808878304903e0 * t755 * t1147 + 0.17315755899375863299672358916972966258900005419821e2 * t721 * t862
  t1405 = -t1358 - t1360 - t1362 + t1365 + t1367 + t421 * t1391 + 0.24415406715670879921742973310852762593515528885057e-3 * t1129 * t467 * t1130 + 0.10843580882781524214666447553230042011687479519034e-1 * t1102 * t504 * t982 + 0.11696446794910408141662685001236899248561775660981e1 * t434 * t1018 - 0.58482233974552040708313425006184496242808878304903e0 * t434 * t972 - 0.17315755899375863299672358916972966258900005419821e2 * t434 * t1008
  t1408 = f.my_piecewise3(t4, 0, t5 * t1405 / 0.2e1)
  t1412 = t187 * t1185
  t1415 = t1174 * t78
  t1416 = t192 * t1192
  t1423 = t1182 * t88
  t1425 = t203 * t1199 * t20
  t1432 = t1189 * t148
  t1434 = t215 * t1349 * t19
  t1441 = t1196 * t224
  t1443 = 0.1e1 / t1198 / t1184
  t1447 = 0.19555555555555555555555555555555555555555555555555e1 * t1175 * t180 * t1178 - 0.19200000000000000000000000000000000000000000000001e1 * t1328 * t1412 + 0.45511111111111111111111111111111111111111111111114e0 * t1415 * t1416 + 0.27022222222222222222222222222222222222222222222222e1 * t1183 * t1412 - 0.24462222222222222222222222222222222222222222222223e1 * t1334 * t1416 + 0.27306666666666666666666666666666666666666666666667e0 * t1423 * t1425 + 0.2304e1 * t1190 * t1416 - 0.10069333333333333333333333333333333333333333333333e1 * t1340 * t1425 + 0.21845333333333333333333333333333333333333333333334e0 * t1432 * t1434 + 0.79644444444444444444444444444444444444444444444445e0 * t1197 * t1425 - 0.68266666666666666666666666666666666666666666666669e0 * t1347 * t1434 + 0.14563555555555555555555555555555555555555555555557e0 * t1441 * t228 * t1443
  t1452 = 0.11073577833333333333333333333333333333333333333333e-2 * t427 * t503 * t893
  t1454 = 0.10000000000000000000000000000000000000000000000000e1 * t1071 * t556
  t1475 = f.my_piecewise3(t4, 0, t5 * (t1452 + t1454 + t421 * (0.53236443333333333333333333333333333333333333333332e-3 * t427 * t503 * t905 + 0.99999999999999999999999999999999999999999999999999e0 * t783 * t709 - t1452 - t1454 + 0.18311555036753159941307229983139571945136646663793e-3 * t427 * t503 * t898 + 0.58482233974552040708313425006184496242808878304903e0 * t755 * t1044) - 0.18311555036753159941307229983139571945136646663793e-3 * t1129 * t499 * t1130 - 0.58482233974552040708313425006184496242808878304903e0 * t434 * t982) / 0.2e1)
  t1479 = t260 * t1185
  t1482 = t264 * t1192
  t1485 = t1174 * t88
  t1487 = t271 * t1199 * t20
  t1496 = t1182 * t148
  t1498 = t284 * t1349 * t19
  t1507 = t1189 * t224
  t1508 = t297 * t1443
  t1517 = t1196 * t307
  t1519 = 0.1e1 / t1198 / t1191
  t1524 = -0.91259259259259259259259259259259259259259259259257e1 * t1175 * t254 * t1178 + 0.16165925925925925925925925925925925925925925925927e2 * t1328 * t1479 - 0.86471111111111111111111111111111111111111111111117e1 * t1415 * t1482 + 0.72817777777777777777777777777777777777777777777782e0 * t1485 * t1487 - 0.19816296296296296296296296296296296296296296296296e2 * t1183 * t1479 + 0.30226962962962962962962962962962962962962962962964e2 * t1334 * t1482 - 0.73728000000000000000000000000000000000000000000002e1 * t1423 * t1487 + 0.11650844444444444444444444444444444444444444444445e1 * t1496 * t1498 - 0.23040e2 * t1190 * t1482 + 0.16440888888888888888888888888888888888888888888889e2 * t1340 * t1487 - 0.76458666666666666666666666666666666666666666666668e1 * t1432 * t1498 + 0.11650844444444444444444444444444444444444444444445e1 * t1507 * t1508 - 0.10088296296296296296296296296296296296296296296296e2 * t1197 * t1487 + 0.13865718518518518518518518518518518518518518518519e2 * t1347 * t1498 - 0.62623288888888888888888888888888888888888888888894e1 * t1441 * t1508 + 0.46603377777777777777777777777777777777777777777782e0 * t1517 * t311 * t1519 * t20
  t1528 = 0.62182e-1 * t577 * t892
  t1531 = t433 * t897
  t1540 = f.my_piecewise3(t4, 0, t5 * (-t1528 + t421 * (-0.31090e-1 * t726 * t904 + t1528 - 0.19751789702565206228825776161588751761046270558698e-1 * t1531) + 0.19751789702565206228825776161588751761046270558698e-1 * t421 * t1531) / 0.2e1)
  t1542 = t19 * t360 * t1349
  t1546 = t378 * t1519 * t20
  t1550 = t1198 ** 2
  t1556 = t400 * t1185
  t1560 = t352 * t1199 * t20
  t1570 = t335 * t1192
  t1592 = t343 * t1443
  t1599 = -0.26951680000000000000000000000000000000000000000000e3 * t1347 * t1542 - 0.30136850962962962962962962962962962962962962962965e2 * t1517 * t1546 + 0.34797188740740740740740740740740740740740740740745e1 * t1196 * t387 * t391 / t1550 * t19 - 0.14445037037037037037037037037037037037037037037037e3 * t1328 * t1556 - 0.23787140740740740740740740740740740740740740740743e2 * t1485 * t1560 + 0.31068918518518518518518518518518518518518518518521e1 * t1174 * t148 * t1542 + 0.14912474074074074074074074074074074074074074074074e3 * t1423 * t1560 - 0.50486992592592592592592592592592592592592592592595e2 * t1496 * t1542 + 0.253440e3 * t1190 * t1570 - 0.26155614814814814814814814814814814814814814814815e3 * t1340 * t1560 + 0.19503028148148148148148148148148148148148148148148e3 * t1432 * t1542 + 0.37282702222222222222222222222222222222222222222224e1 * t1189 * t307 * t1546 + 0.13787338271604938271604938271604938271604938271605e3 * t1197 * t1560 + 0.51713580246913580246913580246913580246913580246912e2 * t1175 * t408 * t1178 + 0.16513580246913580246913580246913580246913580246913e3 * t1183 * t1556 + 0.12960553086419753086419753086419753086419753086421e3 * t1415 * t1570 - 0.37477135802469135802469135802469135802469135802470e3 * t1334 * t1570 + 0.62137837037037037037037037037037037037037037037042e1 * t1182 * t224 * t1592 - 0.62914560000000000000000000000000000000000000000004e2 * t1507 * t1592 + 0.19293474765432098765432098765432098765432098765434e3 * t1441 * t1592
  t1603 = t424 * t426 * t428
  t1604 = jnp.sqrt(t1603)
  t1607 = t1603 ** 0.15e1
  t1610 = t442 * t425 * t237
  t1612 = 0.37978500000000000000000000000000000000000000000000e1 * t1604 + 0.89690000000000000000000000000000000000000000000000e0 * t1603 + 0.20477500000000000000000000000000000000000000000000e0 * t1607 + 0.12323500000000000000000000000000000000000000000000e0 * t1610
  t1615 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t1612
  t1616 = jnp.log(t1615)
  t1621 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t1603
  t1622 = t1612 ** 2
  t1623 = t1622 * t1612
  t1624 = 0.1e1 / t1623
  t1625 = t1621 * t1624
  t1629 = 0.1e1 / t1604 / t1610 * t422 / 0.4e1
  t1630 = t1629 * t597
  t1634 = 0.1e1 / t1604 / t1603 * t440
  t1635 = t441 * t425
  t1636 = t1635 * t31
  t1637 = t1634 * t1636
  t1640 = 0.1e1 / t1604 * t15
  t1641 = t1135 * t606
  t1642 = t1640 * t1641
  t1645 = t1603 ** (-0.15e1)
  t1646 = t1645 * t422
  t1647 = t1646 * t597
  t1649 = t1603 ** (-0.5e0)
  t1650 = t1649 * t440
  t1651 = t1650 * t1636
  t1653 = t1603 ** 0.5e0
  t1654 = t1653 * t15
  t1655 = t1654 * t1641
  t1657 = t442 * t601
  t1659 = -0.25319000000000000000000000000000000000000000000000e1 * t1630 + 0.16879333333333333333333333333333333333333333333333e1 * t1637 - 0.19692555555555555555555555555555555555555555555555e1 * t1642 - 0.93011851851851851851851851851851851851851851851854e0 * t949 + 0.13651666666666666666666666666666666666666666666667e0 * t1647 - 0.27303333333333333333333333333333333333333333333333e0 * t1651 - 0.31853888888888888888888888888888888888888888888890e0 * t1655 - 0.36514074074074074074074074074074074074074074074075e0 * t1657
  t1660 = 0.1e1 / t1615
  t1661 = t1659 * t1660
  t1662 = t1640 * t1136
  t1665 = t1654 * t1136
  t1668 = t442 * t425 * t163
  t1670 = -0.63297500000000000000000000000000000000000000000000e0 * t1662 - 0.29896666666666666666666666666666666666666666666667e0 * t909 - 0.10238750000000000000000000000000000000000000000000e0 * t1665 - 0.82156666666666666666666666666666666666666666666667e-1 * t1668
  t1674 = f.my_piecewise3(t3, t23, 1)
  t1677 = (0.2e1 * t1674 - 0.2e1) * t420
  t1679 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t1603
  t1680 = t1677 * t1679
  t1685 = 0.51785000000000000000000000000000000000000000000000e1 * t1604 + 0.90577500000000000000000000000000000000000000000000e0 * t1603 + 0.11003250000000000000000000000000000000000000000000e0 * t1607 + 0.12417750000000000000000000000000000000000000000000e0 * t1610
  t1686 = t1685 ** 2
  t1687 = t1686 ** 2
  t1688 = 0.1e1 / t1687
  t1697 = -0.34523333333333333333333333333333333333333333333333e1 * t1630 + 0.23015555555555555555555555555555555555555555555556e1 * t1637 - 0.26851481481481481481481481481481481481481481481482e1 * t1642 - 0.93932222222222222222222222222222222222222222222223e0 * t949 + 0.73355000000000000000000000000000000000000000000000e-1 * t1647 - 0.14671000000000000000000000000000000000000000000000e0 * t1651 - 0.17116166666666666666666666666666666666666666666667e0 * t1655 - 0.36793333333333333333333333333333333333333333333333e0 * t1657
  t1701 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t1685
  t1702 = t1701 ** 2
  t1703 = 0.1e1 / t1702
  t1708 = -0.86308333333333333333333333333333333333333333333334e0 * t1662 - 0.30192500000000000000000000000000000000000000000000e0 * t909 - 0.55016250000000000000000000000000000000000000000000e-1 * t1665 - 0.82785000000000000000000000000000000000000000000000e-1 * t1668
  t1709 = t1703 * t1708
  t1714 = 0.1e1 / t1687 / t1686
  t1715 = t1635 * t54
  t1716 = t1634 * t1715
  t1718 = t1135 * t466
  t1719 = t1640 * t1718
  t1722 = t1650 * t1715
  t1724 = t1654 * t1718
  t1726 = t442 * t457
  t1728 = -0.57538888888888888888888888888888888888888888888889e0 * t1716 + 0.11507777777777777777777777777777777777777777777778e1 * t1719 + 0.40256666666666666666666666666666666666666666666667e0 * t921 + 0.36677500000000000000000000000000000000000000000000e-1 * t1722 + 0.73355000000000000000000000000000000000000000000000e-1 * t1724 + 0.13797500000000000000000000000000000000000000000000e0 * t1726
  t1731 = 0.1e1 / t1702 / t1701
  t1732 = t1708 ** 2
  t1737 = t1688 * t1732
  t1738 = 0.1e1 / t1701
  t1739 = t1738 * t1728
  t1743 = t1622 ** 2
  t1745 = 0.1e1 / t1743 / t1612
  t1747 = t1670 ** 2
  t1748 = t1747 * t1670
  t1749 = t1615 ** 2
  t1750 = 0.1e1 / t1749
  t1751 = t1748 * t1750
  t1755 = t1677 * t15
  t1756 = jnp.log(t1701)
  t1762 = 0.1e1 / t1687 / t1685
  t1769 = 0.1e1 / t1743 / t1622
  t1770 = t1621 * t1769
  t1771 = t1747 ** 2
  t1775 = t1743 ** 2
  t1778 = t1749 ** 2
  t1783 = 0.1e1 / t1622
  t1784 = t1621 * t1783
  t1790 = 0.1e1 / t1604 / t641 * t422 * t70 * t427 / 0.48e2
  t1792 = t1629 * t654
  t1794 = t1635 * t179
  t1795 = t1634 * t1794
  t1797 = t1135 * t663
  t1798 = t1640 * t1797
  t1800 = t424 * t664
  t1802 = t1603 ** (-0.25e1)
  t1805 = t1802 * t422 * t70 * t427
  t1807 = t1646 * t654
  t1809 = t1650 * t1794
  t1811 = t1654 * t1797
  t1813 = t442 * t658
  t1819 = -0.11483710345679012345679012345679012345679012345679e-1 * t424 * t664 * t1616 - 0.80000000000000000000000000000000000000000000000000e1 * t1625 * t1661 * t1670 - 0.69263023597503453198689435667891865035600021679284e2 * t1680 * t1688 * t1697 * t1709 - 0.61523382126046769584908008232272042135015119629847e4 * t1680 * t1714 * t1728 * t1731 * t1732 - 0.21053604230838734654992833002226418647411196189766e2 * t1680 * t1737 * t1739 + 0.68733717152873822006368402431571837509247048985239e1 * t427 * t498 * t1745 * t1751 + 0.18989760778855128828022312575107704239400966910600e-2 * t1755 * t1135 * t663 * t1756 + 0.62336721237753107878820492101102678532040019511357e3 * t1680 * t1762 * t1728 * t1703 * t1732 + 0.57894567559743977356791354411244411566048052491077e3 * t1770 * t1771 * t1750 + 0.24954977986735470914321699422701391789612506067521e5 * t1621 / t1775 * t1771 / t1778 + 0.10000000000000000000000000000000000000000000000000e1 * t1784 * (-0.21099166666666666666666666666666666666666666666667e1 * t1790 + 0.20255200000000000000000000000000000000000000000000e2 * t1792 - 0.75019259259259259259259259259259259259259259259258e1 * t1795 + 0.65641851851851851851851851851851851851851851851850e1 * t1798 + 0.31003950617283950617283950617283950617283950617285e1 * t1800 + 0.68258333333333333333333333333333333333333333333335e-1 * t1805 - 0.10921333333333333333333333333333333333333333333333e1 * t1807 + 0.12134814814814814814814814814814814814814814814815e1 * t1809 + 0.10617962962962962962962962962962962962962962962963e1 * t1811 + 0.13388493827160493827160493827160493827160493827161e1 * t1813) * t1660
  t1824 = 0.1e1 / t1749 / t1615
  t1828 = 0.1e1 / t1743
  t1829 = t1621 * t1828
  t1836 = -0.42198333333333333333333333333333333333333333333333e0 * t1716 + 0.84396666666666666666666666666666666666666666666666e0 * t1719 + 0.39862222222222222222222222222222222222222222222223e0 * t921 + 0.68258333333333333333333333333333333333333333333333e-1 * t1722 + 0.13651666666666666666666666666666666666666666666667e0 * t1724 + 0.13692777777777777777777777777777777777777777777778e0 * t1726
  t1837 = t1836 ** 2
  t1844 = t1621 * t1745
  t1848 = t1747 * t1660
  t1856 = t1747 * t1750
  t1860 = t1687 ** 2
  t1862 = t1732 ** 2
  t1864 = t1702 ** 2
  t1869 = 0.1e1 / t1686
  t1885 = t1686 * t1685
  t1886 = 0.1e1 / t1885
  t1887 = t1728 ** 2
  t1902 = -0.62070017646847402095774076540096717770467394091622e4 * t1621 / t1743 / t1623 * t1771 * t1824 + 0.48245472966453314463992795342703676305040043742564e2 * t1829 * t1837 * t1750 - 0.60000000000000000000000000000000000000000000000000e1 * t1625 * t1837 * t1660 - 0.24000000000000000000000000000000000000000000000000e2 * t1844 * t1771 * t1660 + 0.36000000000000000000000000000000000000000000000000e2 * t1829 * t1848 * t1836 + 0.64327297288604419285323727123604901740053391656752e2 * t1829 * t1659 * t1750 * t1670 - 0.57894567559743977356791354411244411566048052491077e3 * t1844 * t1856 * t1836 - 0.91080982599109921218848830805163797795664001346962e5 * t1680 / t1860 * t1862 / t1864 - 0.58482233974552040708313425006184496242808878304903e0 * t1680 * t1869 * (-0.28769444444444444444444444444444444444444444444444e1 * t1790 + 0.27618666666666666666666666666666666666666666666667e2 * t1792 - 0.10229135802469135802469135802469135802469135802469e2 * t1795 + 0.89504938271604938271604938271604938271604938271607e1 * t1798 + 0.31310740740740740740740740740740740740740740740741e1 * t1800 + 0.36677500000000000000000000000000000000000000000000e-1 * t1805 - 0.58684000000000000000000000000000000000000000000000e0 * t1807 + 0.65204444444444444444444444444444444444444444444445e0 * t1809 + 0.57053888888888888888888888888888888888888888888890e0 * t1811 + 0.13490888888888888888888888888888888888888888888889e1 * t1813) * t1738 + 0.35089340384731224424988055003710697745685326982943e1 * t1680 * t1886 * t1887 * t1738 + 0.12304676425209353916981601646454408427003023925970e5 * t1680 / t1687 / t1885 * t1862 * t1731 - 0.62336721237753107878820492101102678532040019511358e3 * t1680 * t1714 * t1862 * t1703
  t1913 = t1670 * t1660
  t1925 = t1886 * t1708
  t1930 = t466 * t1783
  t1931 = t1836 * t1660
  t1935 = t498 * t1828
  t1936 = t1748 * t1660
  t1940 = t498 * t1783
  t1945 = t1748 * t1824
  t1949 = t1677 * t424
  t1951 = t1886 * t1732 * t1738
  t1955 = t1732 * t1708
  t1957 = t1688 * t1955 * t1738
  t1961 = -0.51947267698127589899017076750918898776700016259463e2 * t1680 * t1688 * t1887 * t1703 + 0.14035736153892489769995222001484279098274130793177e2 * t1680 * t1762 * t1862 * t1738 - 0.22161481481481481481481481481481481481481481481481e0 * t427 * t606 * t1783 * t1913 - 0.28493333333333333333333333333333333333333333333334e0 * t427 * t466 * t1624 * t1848 + 0.22911239050957940668789467477190612503082349661746e1 * t427 * t466 * t1828 * t1856 + 0.46785787179641632566650740004947596994247102643924e1 * t1680 * t1925 * t1738 * t1697 + 0.14246666666666666666666666666666666666666666666666e0 * t427 * t1930 * t1931 - 0.42740000000000000000000000000000000000000000000000e0 * t427 * t1935 * t1936 - 0.71233333333333333333333333333333333333333333333332e-1 * t427 * t1940 * t1661 - 0.36845452142031360632963667101718523854302450326054e2 * t427 * t498 * t1769 * t1945 + 0.86748647062252193717331580425840336093499836152272e-1 * t1949 * t467 * t1951 + 0.13012297059337829057599737063876050414024975422841e0 * t1949 * t499 * t1957
  t1963 = t1869 * t1728 * t1738
  t1967 = t1737 * t1703
  t1972 = t1869 * t1697 * t1738
  t1977 = t1714 * t1955 * t1731
  t1982 = t1762 * t1955 * t1703
  t1987 = t1869 * t1708 * t1738
  t2005 = t1677 * t427
  t2017 = -0.43374323531126096858665790212920168046749918076136e-1 * t1949 * t467 * t1963 - 0.12842518958703765280590332863421616642017504019700e1 * t1949 * t467 * t1967 + 0.21687161765563048429332895106460084023374959038068e-1 * t1949 * t499 * t1972 + 0.38024868119570572868450088421334803819557955882337e2 * t1949 * t499 * t1977 - 0.38527556876111295841770998590264849926052512059102e1 * t1949 * t499 * t1982 + 0.67471169937307261780146784775653594739388761451767e-1 * t1949 * t607 * t1987 - 0.2e1 * t1172 + 0.31035008823423701047887038270048358885233697045812e4 * t1770 * t1747 * t1824 * t1836 - 0.34366858576436911003184201215785918754623524492620e1 * t909 * t1828 * t1836 * t1750 * t1670 + 0.42740000000000000000000000000000000000000000000000e0 * t909 * t1624 * t1670 * t1931 - 0.13012297059337829057599737063876050414024975422841e0 * t2005 * t498 * t1886 * t1739 * t1708 + 0.19263778438055647920885499295132424963026256029551e1 * t2005 * t498 * t1688 * t1728 * t1703 * t1708
  t2021 = params.c_ab[1]
  t2022 = t2021 * s0
  t2024 = 0.1e1 + 0.6e-2 * t57
  t2025 = 0.1e1 / t2024
  t2029 = params.c_ab[2]
  t2030 = t2029 * t65
  t2031 = t2024 ** 2
  t2032 = 0.1e1 / t2031
  t2036 = params.c_ab[3]
  t2037 = t2036 * t78
  t2038 = t2031 * t2024
  t2039 = 0.1e1 / t2038
  t2043 = params.c_ab[4]
  t2044 = t2043 * t88
  t2045 = t2031 ** 2
  t2046 = 0.1e1 / t2045
  t2050 = params.c_ab[0] + 0.6e-2 * t2022 * t55 * t2025 + 0.72e-4 * t2030 * t71 * t2032 + 0.864e-6 * t2037 * t81 * t2039 + 0.5184e-8 * t2044 * t93 * t2046
  t2082 = 0.51725014705706168413145063783413931475389495076352e3 * t1770 * t1945 - 0.96490945932906628927985590685407352610080087485128e2 * t1844 * t1751 + 0.10000000000000000000000000000000000000000000000000e1 * t1784 * t1661 - 0.21687161765563048429332895106460084023374959038068e-1 * t1949 * t467 * t1987 + 0.16265371324172286321999671329845063017531219278551e-1 * t1949 * t499 * t1963 + 0.48159446095139119802213748237831062407565640073877e0 * t1949 * t499 * t1967 + 0.60000000000000000000000000000000000000000000000000e1 * t1829 * t1936 - 0.60000000000000000000000000000000000000000000000000e1 * t1625 * t1913 * t1836 + 0.48245472966453314463992795342703676305040043742564e2 * t1829 * t1836 * t1750 * t1670 - 0.51947267698127589899017076750918898776700016259463e2 * t1680 * t1688 * t1728 * t1709 - 0.35089340384731224424988055003710697745685326982943e1 * t1680 * t1957
  t2116 = 0.35089340384731224424988055003710697745685326982943e1 * t1680 * t1925 * t1739 + 0.71233333333333333333333333333333333333333333333333e-1 * t427 * t1930 * t1913 - 0.53424999999999999999999999999999999999999999999999e-1 * t427 * t1940 * t1931 - 0.85917146441092277507960503039464796886558811231548e0 * t427 * t1935 * t1856 - 0.10253897021007794930818001372045340355835853271641e4 * t1680 * t1977 - 0.58482233974552040708313425006184496242808878304903e0 * t1680 * t1972 + 0.10389453539625517979803415350183779755340003251893e3 * t1680 * t1982 + 0.34451131037037037037037037037037037037037037037036e-2 * t424 * t607 * t1616 + 0.10685000000000000000000000000000000000000000000000e0 * t427 * t498 * t1624 * t1848 - 0.56969282336565386484066937725323112718202900731800e-3 * t1755 * t1135 * t606 * t1756 - 0.32530742648344572643999342659690126035062438557102e-1 * t1949 * t499 * t1951 - 0.2e1 * t1324
  t2117 = t2082 + t2116
  t2121 = t2021 * t65
  t2122 = t124 * t2032
  t2127 = t2029 * t78
  t2128 = t132 * t2039
  t2133 = t2036 * t88
  t2135 = t141 * t2046 * t20
  t2140 = t2043 * t148
  t2142 = 0.1e1 / t2045 / t2024
  t2146 = -0.16000000000000000000000000000000000000000000000000e-1 * t2022 * t116 * t2025 + 0.19200000000000000000000000000000000000000000000000e-3 * t2121 * t2122 - 0.38400000000000000000000000000000000000000000000000e-3 * t2030 * t2122 + 0.46080000000000000000000000000000000000000000000000e-5 * t2127 * t2128 - 0.6912e-5 * t2037 * t2128 + 0.41472000000000000000000000000000000000000000000000e-7 * t2133 * t2135 - 0.55296000000000000000000000000000000000000000000000e-7 * t2044 * t2135 + 0.66355200000000000000000000000000000000000000000000e-9 * t2140 * t153 * t2142
  t2175 = -0.14764770444444444444444444444444444444444444444444e-2 * t424 * t467 * t1616 - 0.35616666666666666666666666666666666666666666666666e-1 * t427 * t1940 * t1913 - 0.20000000000000000000000000000000000000000000000000e1 * t1625 * t1848 + 0.10000000000000000000000000000000000000000000000000e1 * t1784 * t1931 + 0.16081824322151104821330931780901225435013347914188e2 * t1829 * t1856 + 0.24415406715670879921742973310852762593515528885057e-3 * t1755 * t1135 * t466 * t1756 + 0.10843580882781524214666447553230042011687479519034e-1 * t1949 * t499 * t1987 + 0.11696446794910408141662685001236899248561775660981e1 * t1680 * t1951 - 0.58482233974552040708313425006184496242808878304903e0 * t1680 * t1963 - 0.17315755899375863299672358916972966258900005419821e2 * t1680 * t1967 - 0.2e1 * t1408
  t2179 = t187 * t2032
  t2182 = t2021 * t78
  t2183 = t192 * t2039
  t2190 = t2029 * t88
  t2192 = t203 * t2046 * t20
  t2199 = t2036 * t148
  t2201 = t215 * t2142 * t19
  t2208 = t2043 * t224
  t2210 = 0.1e1 / t2045 / t2031
  t2214 = 0.58666666666666666666666666666666666666666666666667e-1 * t2022 * t180 * t2025 - 0.17280000000000000000000000000000000000000000000000e-2 * t2121 * t2179 + 0.12288000000000000000000000000000000000000000000000e-4 * t2182 * t2183 + 0.24320000000000000000000000000000000000000000000000e-2 * t2030 * t2179 - 0.66048000000000000000000000000000000000000000000000e-4 * t2127 * t2183 + 0.22118400000000000000000000000000000000000000000000e-6 * t2190 * t2192 + 0.62208e-4 * t2037 * t2183 - 0.81561600000000000000000000000000000000000000000000e-6 * t2133 * t2192 + 0.53084160000000000000000000000000000000000000000000e-8 * t2199 * t2201 + 0.64512000000000000000000000000000000000000000000000e-6 * t2044 * t2192 - 0.16588800000000000000000000000000000000000000000000e-7 * t2140 * t2201 + 0.10616832000000000000000000000000000000000000000000e-9 * t2208 * t228 * t2210
  t2229 = 0.11073577833333333333333333333333333333333333333333e-2 * t424 * t499 * t1616 + 0.10000000000000000000000000000000000000000000000000e1 * t1784 * t1913 - 0.18311555036753159941307229983139571945136646663793e-3 * t1755 * t1135 * t498 * t1756 - 0.58482233974552040708313425006184496242808878304903e0 * t1680 * t1987 - 0.2e1 * t1475
  t2233 = t260 * t2032
  t2236 = t264 * t2039
  t2239 = t2021 * t88
  t2241 = t271 * t2046 * t20
  t2250 = t2029 * t148
  t2252 = t284 * t2142 * t19
  t2261 = t2036 * t224
  t2262 = t297 * t2210
  t2271 = t2043 * t307
  t2273 = 0.1e1 / t2045 / t2038
  t2278 = -0.27377777777777777777777777777777777777777777777778e0 * t2022 * t254 * t2025 + 0.14549333333333333333333333333333333333333333333333e-1 * t2121 * t2233 - 0.23347200000000000000000000000000000000000000000000e-3 * t2182 * t2236 + 0.58982400000000000000000000000000000000000000000000e-6 * t2239 * t2241 - 0.17834666666666666666666666666666666666666666666667e-1 * t2030 * t2233 + 0.81612800000000000000000000000000000000000000000000e-3 * t2127 * t2236 - 0.59719680000000000000000000000000000000000000000000e-5 * t2190 * t2241 + 0.28311552000000000000000000000000000000000000000000e-7 * t2250 * t2252 - 0.622080e-3 * t2037 * t2236 + 0.13317120000000000000000000000000000000000000000000e-4 * t2133 * t2241 - 0.18579456000000000000000000000000000000000000000000e-6 * t2199 * t2252 + 0.84934656000000000000000000000000000000000000000000e-9 * t2261 * t2262 - 0.81715200000000000000000000000000000000000000000000e-5 * t2044 * t2241 + 0.33693696000000000000000000000000000000000000000000e-6 * t2140 * t2252 - 0.45652377600000000000000000000000000000000000000000e-8 * t2208 * t2262 + 0.10192158720000000000000000000000000000000000000000e-10 * t2271 * t311 * t2273 * t20
  t2287 = -0.62182e-1 * t1621 * t1616 + 0.19751789702565206228825776161588751761046270558698e-1 * t1677 * t1679 * t1756 - 0.2e1 * t1540
  t2288 = t335 * t2039
  t2294 = t343 * t2210
  t2301 = t400 * t2032
  t2305 = t20 * t352 * t2046
  t2312 = t2045 ** 2
  t2324 = t360 * t2142 * t19
  t2339 = t378 * t2273 * t20
  t2346 = 0.34993493333333333333333333333333333333333333333333e-2 * t2182 * t2288 - 0.10118826666666666666666666666666666666666666666667e-1 * t2127 * t2288 + 0.45298483200000000000000000000000000000000000000000e-8 * t2029 * t224 * t2294 - 0.45864714240000000000000000000000000000000000000000e-7 * t2261 * t2294 + 0.14064943104000000000000000000000000000000000000000e-6 * t2208 * t2294 + 0.14862222222222222222222222222222222222222222222222e0 * t2030 * t2301 + 0.11167744000000000000000000000000000000000000000000e-3 * t2044 * t2305 + 0.15514074074074074074074074074074074074074074074074e1 * t2022 * t408 * t2025 + 0.22830435532800000000000000000000000000000000000000e-11 * t2043 * t387 * t391 / t2312 * t19 - 0.13000533333333333333333333333333333333333333333333e0 * t2121 * t2301 - 0.19267584000000000000000000000000000000000000000000e-4 * t2239 * t2305 + 0.75497472000000000000000000000000000000000000000000e-7 * t2021 * t148 * t2324 + 0.12079104000000000000000000000000000000000000000000e-3 * t2190 * t2305 - 0.12268339200000000000000000000000000000000000000000e-5 * t2250 * t2324 + 0.6842880e-2 * t2037 * t2288 - 0.21186048000000000000000000000000000000000000000000e-3 * t2133 * t2305 + 0.47392358400000000000000000000000000000000000000000e-5 * t2199 * t2324 + 0.81537269760000000000000000000000000000000000000000e-10 * t2036 * t307 * t2339 - 0.65492582400000000000000000000000000000000000000000e-5 * t2140 * t2324 - 0.65909293056000000000000000000000000000000000000000e-9 * t2271 * t2339
  t2348 = 0.2e1 * t49 * t99 + 0.8e1 * t115 * t159 + 0.12e2 * t177 * t234 + 0.8e1 * t251 * t318 + 0.2e1 * t334 * t414 + 0.2e1 * t1172 * t1203 + 0.8e1 * t1324 * t1353 + 0.12e2 * t1408 * t1447 + 0.8e1 * t1475 * t1524 + 0.2e1 * t1540 * t1599 + (t1819 + t1902 + t1961 + t2017) * t2050 + 0.4e1 * t2117 * t2146 + 0.6e1 * t2175 * t2214 + 0.4e1 * t2229 * t2278 + t2287 * t2346
  v4rho4_0_ = r0 * t2348 + 0.8e1 * t115 * t99 + 0.8e1 * t1324 * t1203 + 0.24e2 * t1408 * t1353 + 0.24e2 * t1475 * t1447 + 0.8e1 * t1540 * t1524 + 0.24e2 * t177 * t159 + 0.4e1 * t2117 * t2050 + 0.12e2 * t2175 * t2146 + 0.12e2 * t2229 * t2214 + 0.4e1 * t2287 * t2278 + 0.24e2 * t251 * t234 + 0.8e1 * t334 * t318

  res = {'v4rho4': v4rho4_0_}
  return res
