"""Generated from hyb_mgga_x_m05.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_csi_HF_raw = params.csi_HF
  if isinstance(params_csi_HF_raw, (str, bytes, dict)):
    params_csi_HF = params_csi_HF_raw
  else:
    try:
      params_csi_HF_seq = list(params_csi_HF_raw)
    except TypeError:
      params_csi_HF = params_csi_HF_raw
    else:
      params_csi_HF_seq = np.asarray(params_csi_HF_seq, dtype=np.float64)
      params_csi_HF = np.concatenate((np.array([np.nan], dtype=np.float64), params_csi_HF_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  m05_f = lambda x, u, t: +params_csi_HF * pbe_f(x) * mgga_series_w(params_a, 12, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m05_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_csi_HF_raw = params.csi_HF
  if isinstance(params_csi_HF_raw, (str, bytes, dict)):
    params_csi_HF = params_csi_HF_raw
  else:
    try:
      params_csi_HF_seq = list(params_csi_HF_raw)
    except TypeError:
      params_csi_HF = params_csi_HF_raw
    else:
      params_csi_HF_seq = np.asarray(params_csi_HF_seq, dtype=np.float64)
      params_csi_HF = np.concatenate((np.array([np.nan], dtype=np.float64), params_csi_HF_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  m05_f = lambda x, u, t: +params_csi_HF * pbe_f(x) * mgga_series_w(params_a, 12, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m05_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_csi_HF_raw = params.csi_HF
  if isinstance(params_csi_HF_raw, (str, bytes, dict)):
    params_csi_HF = params_csi_HF_raw
  else:
    try:
      params_csi_HF_seq = list(params_csi_HF_raw)
    except TypeError:
      params_csi_HF = params_csi_HF_raw
    else:
      params_csi_HF_seq = np.asarray(params_csi_HF_seq, dtype=np.float64)
      params_csi_HF = np.concatenate((np.array([np.nan], dtype=np.float64), params_csi_HF_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  m05_f = lambda x, u, t: +params_csi_HF * pbe_f(x) * mgga_series_w(params_a, 12, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m05_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = t27 * params.csi_HF
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = 0.1e1 / t32
  t34 = t29 * t33
  t35 = r0 ** 2
  t36 = r0 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = 0.1e1 / t37 / t35
  t43 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t34 * s0 * t39
  t46 = 0.18040e1 - 0.64641600e0 / t43
  t47 = params.a[0]
  t48 = params.a[1]
  t49 = t29 ** 2
  t51 = 0.3e1 / 0.10e2 * t49 * t32
  t53 = 0.1e1 / t37 / r0
  t54 = tau0 * t53
  t55 = t51 - t54
  t56 = t48 * t55
  t57 = t51 + t54
  t58 = 0.1e1 / t57
  t60 = params.a[2]
  t61 = t55 ** 2
  t62 = t60 * t61
  t63 = t57 ** 2
  t64 = 0.1e1 / t63
  t66 = params.a[3]
  t67 = t61 * t55
  t68 = t66 * t67
  t69 = t63 * t57
  t70 = 0.1e1 / t69
  t72 = params.a[4]
  t73 = t61 ** 2
  t74 = t72 * t73
  t75 = t63 ** 2
  t76 = 0.1e1 / t75
  t78 = params.a[5]
  t79 = t73 * t55
  t80 = t78 * t79
  t82 = 0.1e1 / t75 / t57
  t84 = params.a[6]
  t85 = t73 * t61
  t86 = t84 * t85
  t88 = 0.1e1 / t75 / t63
  t90 = params.a[7]
  t91 = t73 * t67
  t92 = t90 * t91
  t94 = 0.1e1 / t75 / t69
  t96 = params.a[8]
  t97 = t73 ** 2
  t98 = t96 * t97
  t99 = t75 ** 2
  t100 = 0.1e1 / t99
  t102 = params.a[9]
  t103 = t97 * t55
  t104 = t102 * t103
  t106 = 0.1e1 / t99 / t57
  t108 = params.a[10]
  t109 = t97 * t61
  t110 = t108 * t109
  t112 = 0.1e1 / t99 / t63
  t114 = params.a[11]
  t116 = t114 * t97 * t67
  t118 = 0.1e1 / t99 / t69
  t120 = t98 * t100 + t104 * t106 + t110 * t112 + t116 * t118 + t56 * t58 + t62 * t64 + t68 * t70 + t74 * t76 + t80 * t82 + t86 * t88 + t92 * t94 + t47
  t121 = t46 * t120
  t122 = t28 * t121
  t125 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t122)
  t126 = r1 <= f.p.dens_threshold
  t127 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t128 = 0.1e1 + t127
  t129 = t128 <= f.p.zeta_threshold
  t130 = t128 ** (0.1e1 / 0.3e1)
  t132 = f.my_piecewise3(t129, t22, t130 * t128)
  t133 = t5 * t132
  t134 = r1 ** 2
  t135 = r1 ** (0.1e1 / 0.3e1)
  t136 = t135 ** 2
  t138 = 0.1e1 / t136 / t134
  t142 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t34 * s2 * t138
  t145 = 0.18040e1 - 0.64641600e0 / t142
  t147 = 0.1e1 / t136 / r1
  t148 = tau1 * t147
  t149 = t51 - t148
  t150 = t48 * t149
  t151 = t51 + t148
  t152 = 0.1e1 / t151
  t154 = t149 ** 2
  t155 = t60 * t154
  t156 = t151 ** 2
  t157 = 0.1e1 / t156
  t159 = t154 * t149
  t160 = t66 * t159
  t161 = t156 * t151
  t162 = 0.1e1 / t161
  t164 = t154 ** 2
  t165 = t72 * t164
  t166 = t156 ** 2
  t167 = 0.1e1 / t166
  t169 = t164 * t149
  t170 = t78 * t169
  t172 = 0.1e1 / t166 / t151
  t174 = t164 * t154
  t175 = t84 * t174
  t177 = 0.1e1 / t166 / t156
  t179 = t164 * t159
  t180 = t90 * t179
  t182 = 0.1e1 / t166 / t161
  t184 = t164 ** 2
  t185 = t96 * t184
  t186 = t166 ** 2
  t187 = 0.1e1 / t186
  t189 = t184 * t149
  t190 = t102 * t189
  t192 = 0.1e1 / t186 / t151
  t194 = t184 * t154
  t195 = t108 * t194
  t197 = 0.1e1 / t186 / t156
  t200 = t114 * t184 * t159
  t202 = 0.1e1 / t186 / t161
  t204 = t150 * t152 + t155 * t157 + t160 * t162 + t165 * t167 + t170 * t172 + t175 * t177 + t180 * t182 + t185 * t187 + t190 * t192 + t195 * t197 + t200 * t202 + t47
  t205 = t145 * t204
  t206 = t28 * t205
  t209 = f.my_piecewise3(t126, 0, -0.3e1 / 0.8e1 * t133 * t206)
  t210 = t6 ** 2
  t212 = t16 / t210
  t213 = t7 - t212
  t214 = f.my_piecewise5(t10, 0, t14, 0, t213)
  t217 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t214)
  t221 = t27 ** 2
  t223 = 0.1e1 / t221 * params.csi_HF
  t226 = t26 * t223 * t121 / 0.8e1
  t229 = t5 * t25 * t27 * params.csi_HF
  t230 = t43 ** 2
  t232 = 0.1e1 / t230 * t29
  t247 = t64 * tau0 * t39
  t250 = t60 * t55
  t254 = t70 * tau0 * t39
  t257 = t66 * t61
  t261 = t76 * tau0 * t39
  t264 = t72 * t67
  t268 = t82 * tau0 * t39
  t271 = t78 * t73
  t275 = t88 * tau0 * t39
  t278 = t84 * t79
  t281 = 0.5e1 / 0.3e1 * t48 * tau0 * t39 * t58 + 0.5e1 / 0.3e1 * t56 * t247 + 0.10e2 / 0.3e1 * t250 * t247 + 0.10e2 / 0.3e1 * t62 * t254 + 0.5e1 * t257 * t254 + 0.5e1 * t68 * t261 + 0.20e2 / 0.3e1 * t264 * t261 + 0.20e2 / 0.3e1 * t74 * t268 + 0.25e2 / 0.3e1 * t271 * t268 + 0.25e2 / 0.3e1 * t80 * t275 + 0.10e2 * t278 * t275
  t283 = t94 * tau0 * t39
  t286 = t90 * t85
  t290 = t100 * tau0 * t39
  t293 = t96 * t91
  t297 = t106 * tau0 * t39
  t300 = t102 * t97
  t304 = t112 * tau0 * t39
  t307 = t108 * t103
  t311 = t118 * tau0 * t39
  t314 = t114 * t109
  t318 = 0.1e1 / t99 / t75
  t323 = 0.10e2 * t86 * t283 + 0.35e2 / 0.3e1 * t286 * t283 + 0.35e2 / 0.3e1 * t92 * t290 + 0.40e2 / 0.3e1 * t293 * t290 + 0.40e2 / 0.3e1 * t98 * t297 + 0.15e2 * t300 * t297 + 0.15e2 * t104 * t304 + 0.50e2 / 0.3e1 * t307 * t304 + 0.50e2 / 0.3e1 * t110 * t311 + 0.55e2 / 0.3e1 * t314 * t311 + 0.55e2 / 0.3e1 * t116 * t318 * tau0 * t39
  t330 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t217 * t122 - t226 + 0.59124162764395035714000000000000000000000000000000e-2 * t229 * t232 * t33 * s0 / t37 / t35 / r0 * t120 - 0.3e1 / 0.8e1 * t26 * t28 * t46 * (t281 + t323))
  t332 = f.my_piecewise5(t14, 0, t10, 0, -t213)
  t335 = f.my_piecewise3(t129, 0, 0.4e1 / 0.3e1 * t130 * t332)
  t341 = t133 * t223 * t205 / 0.8e1
  t343 = f.my_piecewise3(t126, 0, -0.3e1 / 0.8e1 * t5 * t335 * t206 - t341)
  vrho_0_ = t125 + t209 + t6 * (t330 + t343)
  t346 = -t7 - t212
  t347 = f.my_piecewise5(t10, 0, t14, 0, t346)
  t350 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t347)
  t355 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t350 * t122 - t226)
  t357 = f.my_piecewise5(t14, 0, t10, 0, -t346)
  t360 = f.my_piecewise3(t129, 0, 0.4e1 / 0.3e1 * t130 * t357)
  t366 = t5 * t132 * t27 * params.csi_HF
  t367 = t142 ** 2
  t369 = 0.1e1 / t367 * t29
  t384 = t157 * tau1 * t138
  t387 = t60 * t149
  t391 = t162 * tau1 * t138
  t394 = t66 * t154
  t398 = t167 * tau1 * t138
  t401 = t72 * t159
  t405 = t172 * tau1 * t138
  t408 = t78 * t164
  t412 = t177 * tau1 * t138
  t415 = t84 * t169
  t418 = 0.5e1 / 0.3e1 * t48 * tau1 * t138 * t152 + 0.5e1 / 0.3e1 * t150 * t384 + 0.10e2 / 0.3e1 * t387 * t384 + 0.10e2 / 0.3e1 * t155 * t391 + 0.5e1 * t394 * t391 + 0.5e1 * t160 * t398 + 0.20e2 / 0.3e1 * t401 * t398 + 0.20e2 / 0.3e1 * t165 * t405 + 0.25e2 / 0.3e1 * t408 * t405 + 0.25e2 / 0.3e1 * t170 * t412 + 0.10e2 * t415 * t412
  t420 = t182 * tau1 * t138
  t423 = t90 * t174
  t427 = t187 * tau1 * t138
  t430 = t96 * t179
  t434 = t192 * tau1 * t138
  t437 = t102 * t184
  t441 = t197 * tau1 * t138
  t444 = t108 * t189
  t448 = t202 * tau1 * t138
  t451 = t114 * t194
  t455 = 0.1e1 / t186 / t166
  t460 = 0.10e2 * t175 * t420 + 0.35e2 / 0.3e1 * t423 * t420 + 0.35e2 / 0.3e1 * t180 * t427 + 0.40e2 / 0.3e1 * t430 * t427 + 0.40e2 / 0.3e1 * t185 * t434 + 0.15e2 * t437 * t434 + 0.15e2 * t190 * t441 + 0.50e2 / 0.3e1 * t444 * t441 + 0.50e2 / 0.3e1 * t195 * t448 + 0.55e2 / 0.3e1 * t451 * t448 + 0.55e2 / 0.3e1 * t200 * t455 * tau1 * t138
  t467 = f.my_piecewise3(t126, 0, -0.3e1 / 0.8e1 * t5 * t360 * t206 - t341 + 0.59124162764395035714000000000000000000000000000000e-2 * t366 * t369 * t33 * s2 / t136 / t134 / r1 * t204 - 0.3e1 / 0.8e1 * t133 * t28 * t145 * (t418 + t460))
  vrho_1_ = t125 + t209 + t6 * (t355 + t467)
  t475 = f.my_piecewise3(t1, 0, -0.22171561036648138392750000000000000000000000000000e-2 * t229 * t232 * t33 * t39 * t120)
  vsigma_0_ = t6 * t475
  vsigma_1_ = 0.0e0
  t481 = f.my_piecewise3(t126, 0, -0.22171561036648138392750000000000000000000000000000e-2 * t366 * t369 * t33 * t138 * t204)
  vsigma_2_ = t6 * t481
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t484 = t64 * t53
  t488 = t70 * t53
  t493 = t76 * t53
  t498 = t82 * t53
  t503 = t88 * t53
  t508 = -t48 * t53 * t58 - 0.2e1 * t250 * t484 - 0.3e1 * t257 * t488 - 0.4e1 * t264 * t493 - 0.5e1 * t271 * t498 - 0.6e1 * t278 * t503 - t56 * t484 - 0.2e1 * t62 * t488 - 0.3e1 * t68 * t493 - 0.4e1 * t74 * t498 - 0.5e1 * t80 * t503
  t509 = t94 * t53
  t514 = t100 * t53
  t519 = t106 * t53
  t524 = t112 * t53
  t529 = t118 * t53
  t537 = -0.11e2 * t116 * t318 * t53 - 0.9e1 * t104 * t524 - 0.10e2 * t110 * t529 - 0.7e1 * t286 * t509 - 0.8e1 * t293 * t514 - 0.9e1 * t300 * t519 - 0.10e2 * t307 * t524 - 0.11e2 * t314 * t529 - 0.6e1 * t86 * t509 - 0.7e1 * t92 * t514 - 0.8e1 * t98 * t519
  t543 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t28 * t46 * (t508 + t537))
  vtau_0_ = t6 * t543
  t546 = t157 * t147
  t550 = t162 * t147
  t555 = t167 * t147
  t560 = t172 * t147
  t565 = t177 * t147
  t570 = -t48 * t147 * t152 - t150 * t546 - 0.2e1 * t155 * t550 - 0.3e1 * t160 * t555 - 0.4e1 * t165 * t560 - 0.5e1 * t170 * t565 - 0.2e1 * t387 * t546 - 0.3e1 * t394 * t550 - 0.4e1 * t401 * t555 - 0.5e1 * t408 * t560 - 0.6e1 * t415 * t565
  t571 = t182 * t147
  t576 = t187 * t147
  t581 = t192 * t147
  t586 = t197 * t147
  t591 = t202 * t147
  t599 = -0.11e2 * t200 * t455 * t147 - 0.6e1 * t175 * t571 - 0.7e1 * t180 * t576 - 0.8e1 * t185 * t581 - 0.9e1 * t190 * t586 - 0.10e2 * t195 * t591 - 0.7e1 * t423 * t571 - 0.8e1 * t430 * t576 - 0.9e1 * t437 * t581 - 0.10e2 * t444 * t586 - 0.11e2 * t451 * t591
  t605 = f.my_piecewise3(t126, 0, -0.3e1 / 0.8e1 * t133 * t28 * t145 * (t570 + t599))
  vtau_1_ = t6 * t605
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_csi_HF_raw = params.csi_HF
  if isinstance(params_csi_HF_raw, (str, bytes, dict)):
    params_csi_HF = params_csi_HF_raw
  else:
    try:
      params_csi_HF_seq = list(params_csi_HF_raw)
    except TypeError:
      params_csi_HF = params_csi_HF_raw
    else:
      params_csi_HF_seq = np.asarray(params_csi_HF_seq, dtype=np.float64)
      params_csi_HF = np.concatenate((np.array([np.nan], dtype=np.float64), params_csi_HF_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  m05_f = lambda x, u, t: +params_csi_HF * pbe_f(x) * mgga_series_w(params_a, 12, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m05_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 * params.csi_HF
  t21 = 6 ** (0.1e1 / 0.3e1)
  t22 = jnp.pi ** 2
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = 0.1e1 / t24
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = s0 * t28
  t30 = r0 ** 2
  t31 = t19 ** 2
  t33 = 0.1e1 / t31 / t30
  t37 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t21 * t25 * t29 * t33
  t40 = 0.18040e1 - 0.64641600e0 / t37
  t42 = params.a[1]
  t43 = t21 ** 2
  t45 = 0.3e1 / 0.10e2 * t43 * t24
  t46 = tau0 * t28
  t48 = 0.1e1 / t31 / r0
  t49 = t46 * t48
  t50 = t45 - t49
  t51 = t42 * t50
  t52 = t45 + t49
  t53 = 0.1e1 / t52
  t55 = params.a[2]
  t56 = t50 ** 2
  t57 = t55 * t56
  t58 = t52 ** 2
  t59 = 0.1e1 / t58
  t61 = params.a[3]
  t62 = t56 * t50
  t63 = t61 * t62
  t64 = t58 * t52
  t65 = 0.1e1 / t64
  t67 = params.a[4]
  t68 = t56 ** 2
  t69 = t67 * t68
  t70 = t58 ** 2
  t71 = 0.1e1 / t70
  t73 = params.a[5]
  t74 = t68 * t50
  t75 = t73 * t74
  t77 = 0.1e1 / t70 / t52
  t79 = params.a[6]
  t80 = t68 * t56
  t81 = t79 * t80
  t83 = 0.1e1 / t70 / t58
  t85 = params.a[7]
  t86 = t68 * t62
  t87 = t85 * t86
  t89 = 0.1e1 / t70 / t64
  t91 = params.a[8]
  t92 = t68 ** 2
  t93 = t91 * t92
  t94 = t70 ** 2
  t95 = 0.1e1 / t94
  t97 = params.a[9]
  t98 = t92 * t50
  t99 = t97 * t98
  t101 = 0.1e1 / t94 / t52
  t103 = params.a[10]
  t104 = t92 * t56
  t105 = t103 * t104
  t107 = 0.1e1 / t94 / t58
  t109 = params.a[11]
  t111 = t109 * t92 * t62
  t113 = 0.1e1 / t94 / t64
  t115 = t99 * t101 + t105 * t107 + t111 * t113 + t51 * t53 + t57 * t59 + t63 * t65 + t69 * t71 + t75 * t77 + t81 * t83 + t87 * t89 + t93 * t95 + params.a[0]
  t116 = t40 * t115
  t120 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t20 * t116)
  t132 = t37 ** 2
  t134 = 0.1e1 / t132 * t21
  t146 = t46 * t33
  t149 = t55 * t50
  t156 = t61 * t56
  t163 = t67 * t62
  t170 = t73 * t68
  t177 = t79 * t74
  t181 = 0.5e1 / 0.3e1 * t42 * tau0 * t28 * t33 * t53 + 0.5e1 / 0.3e1 * t51 * t59 * t146 + 0.10e2 / 0.3e1 * t149 * t59 * t146 + 0.10e2 / 0.3e1 * t57 * t65 * t146 + 0.5e1 * t156 * t65 * t146 + 0.5e1 * t63 * t71 * t146 + 0.20e2 / 0.3e1 * t163 * t71 * t146 + 0.20e2 / 0.3e1 * t69 * t77 * t146 + 0.25e2 / 0.3e1 * t170 * t77 * t146 + 0.25e2 / 0.3e1 * t75 * t83 * t146 + 0.10e2 * t177 * t83 * t146
  t185 = t85 * t80
  t192 = t91 * t86
  t199 = t97 * t92
  t206 = t103 * t98
  t213 = t109 * t104
  t218 = 0.1e1 / t94 / t70
  t222 = 0.10e2 * t81 * t89 * t146 + 0.35e2 / 0.3e1 * t185 * t89 * t146 + 0.35e2 / 0.3e1 * t87 * t95 * t146 + 0.40e2 / 0.3e1 * t192 * t95 * t146 + 0.40e2 / 0.3e1 * t93 * t101 * t146 + 0.15e2 * t199 * t101 * t146 + 0.15e2 * t99 * t107 * t146 + 0.50e2 / 0.3e1 * t206 * t107 * t146 + 0.50e2 / 0.3e1 * t105 * t113 * t146 + 0.55e2 / 0.3e1 * t213 * t113 * t146 + 0.55e2 / 0.3e1 * t111 * t218 * t146
  t229 = f.my_piecewise3(t2, 0, -t18 / t31 * params.csi_HF * t116 / 0.8e1 + 0.59124162764395035714000000000000000000000000000000e-2 * t6 * t17 / t19 / t30 / r0 * params.csi_HF * t134 * t25 * t29 * t115 - 0.3e1 / 0.8e1 * t18 * t20 * t40 * (t181 + t222))
  vrho_0_ = 0.2e1 * r0 * t229 + 0.2e1 * t120
  t242 = f.my_piecewise3(t2, 0, -0.22171561036648138392750000000000000000000000000000e-2 * t6 * t17 / t19 / t30 * params.csi_HF * t134 * t25 * t28 * t115)
  vsigma_0_ = 0.2e1 * r0 * t242
  vlapl_0_ = 0.0e0
  t248 = t59 * t28 * t48
  t253 = t65 * t28 * t48
  t259 = t71 * t28 * t48
  t265 = t77 * t28 * t48
  t271 = t83 * t28 * t48
  t276 = -t42 * t28 * t48 * t53 - 0.2e1 * t149 * t248 - 0.3e1 * t156 * t253 - 0.4e1 * t163 * t259 - 0.5e1 * t170 * t265 - 0.6e1 * t177 * t271 - t51 * t248 - 0.2e1 * t57 * t253 - 0.3e1 * t63 * t259 - 0.4e1 * t69 * t265 - 0.5e1 * t75 * t271
  t278 = t89 * t28 * t48
  t284 = t95 * t28 * t48
  t290 = t101 * t28 * t48
  t296 = t107 * t28 * t48
  t302 = t113 * t28 * t48
  t311 = -0.11e2 * t111 * t218 * t28 * t48 - 0.10e2 * t105 * t302 - 0.7e1 * t185 * t278 - 0.8e1 * t192 * t284 - 0.9e1 * t199 * t290 - 0.10e2 * t206 * t296 - 0.11e2 * t213 * t302 - 0.6e1 * t81 * t278 - 0.7e1 * t87 * t284 - 0.8e1 * t93 * t290 - 0.9e1 * t99 * t296
  t317 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t20 * t40 * (t276 + t311))
  vtau_0_ = 0.2e1 * r0 * t317
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 * params.csi_HF
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t20 / t32
  t38 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t23 * t27 * t31 * t34
  t41 = 0.18040e1 - 0.64641600e0 / t38
  t43 = params.a[1]
  t44 = t23 ** 2
  t46 = 0.3e1 / 0.10e2 * t44 * t26
  t47 = tau0 * t30
  t49 = 0.1e1 / t20 / r0
  t50 = t47 * t49
  t51 = t46 - t50
  t52 = t43 * t51
  t53 = t46 + t50
  t54 = 0.1e1 / t53
  t56 = params.a[2]
  t57 = t51 ** 2
  t58 = t56 * t57
  t59 = t53 ** 2
  t60 = 0.1e1 / t59
  t62 = params.a[3]
  t63 = t57 * t51
  t64 = t62 * t63
  t65 = t59 * t53
  t66 = 0.1e1 / t65
  t68 = params.a[4]
  t69 = t57 ** 2
  t70 = t68 * t69
  t71 = t59 ** 2
  t72 = 0.1e1 / t71
  t74 = params.a[5]
  t75 = t69 * t51
  t76 = t74 * t75
  t77 = t71 * t53
  t78 = 0.1e1 / t77
  t80 = params.a[6]
  t81 = t69 * t57
  t82 = t80 * t81
  t84 = 0.1e1 / t71 / t59
  t86 = params.a[7]
  t87 = t69 * t63
  t88 = t86 * t87
  t90 = 0.1e1 / t71 / t65
  t92 = params.a[8]
  t93 = t69 ** 2
  t94 = t92 * t93
  t95 = t71 ** 2
  t96 = 0.1e1 / t95
  t98 = params.a[9]
  t99 = t93 * t51
  t100 = t98 * t99
  t102 = 0.1e1 / t95 / t53
  t104 = params.a[10]
  t105 = t93 * t57
  t106 = t104 * t105
  t108 = 0.1e1 / t95 / t59
  t110 = params.a[11]
  t112 = t110 * t93 * t63
  t114 = 0.1e1 / t95 / t65
  t116 = t100 * t102 + t106 * t108 + t112 * t114 + t52 * t54 + t58 * t60 + t64 * t66 + t70 * t72 + t76 * t78 + t82 * t84 + t88 * t90 + t94 * t96 + params.a[0]
  t117 = t41 * t116
  t121 = t32 * r0
  t126 = t6 * t17 / t19 / t121 * params.csi_HF
  t127 = t38 ** 2
  t130 = 0.1e1 / t127 * t23 * t27
  t132 = t130 * t31 * t116
  t135 = t19 * params.csi_HF
  t136 = t43 * tau0
  t141 = t52 * t60
  t142 = t47 * t34
  t145 = t56 * t51
  t146 = t145 * t60
  t149 = t58 * t66
  t152 = t62 * t57
  t153 = t152 * t66
  t156 = t64 * t72
  t159 = t68 * t63
  t160 = t159 * t72
  t163 = t70 * t78
  t166 = t74 * t69
  t167 = t166 * t78
  t170 = t76 * t84
  t173 = t80 * t75
  t174 = t173 * t84
  t177 = 0.5e1 / 0.3e1 * t136 * t30 * t34 * t54 + 0.5e1 / 0.3e1 * t141 * t142 + 0.10e2 / 0.3e1 * t146 * t142 + 0.10e2 / 0.3e1 * t149 * t142 + 0.5e1 * t153 * t142 + 0.5e1 * t156 * t142 + 0.20e2 / 0.3e1 * t160 * t142 + 0.20e2 / 0.3e1 * t163 * t142 + 0.25e2 / 0.3e1 * t167 * t142 + 0.25e2 / 0.3e1 * t170 * t142 + 0.10e2 * t174 * t142
  t178 = t82 * t90
  t181 = t86 * t81
  t182 = t181 * t90
  t185 = t88 * t96
  t188 = t92 * t87
  t189 = t188 * t96
  t192 = t94 * t102
  t195 = t98 * t93
  t196 = t195 * t102
  t199 = t100 * t108
  t202 = t104 * t99
  t203 = t202 * t108
  t206 = t106 * t114
  t209 = t110 * t105
  t210 = t209 * t114
  t214 = 0.1e1 / t95 / t71
  t215 = t112 * t214
  t218 = 0.10e2 * t178 * t142 + 0.35e2 / 0.3e1 * t182 * t142 + 0.35e2 / 0.3e1 * t185 * t142 + 0.40e2 / 0.3e1 * t189 * t142 + 0.40e2 / 0.3e1 * t192 * t142 + 0.15e2 * t196 * t142 + 0.15e2 * t199 * t142 + 0.50e2 / 0.3e1 * t203 * t142 + 0.50e2 / 0.3e1 * t206 * t142 + 0.55e2 / 0.3e1 * t210 * t142 + 0.55e2 / 0.3e1 * t215 * t142
  t219 = t177 + t218
  t220 = t41 * t219
  t225 = f.my_piecewise3(t2, 0, -t18 * t22 * t117 / 0.8e1 + 0.59124162764395035714000000000000000000000000000004e-2 * t126 * t132 - 0.3e1 / 0.8e1 * t18 * t135 * t220)
  t231 = t32 ** 2
  t253 = s0 ** 2
  t265 = tau0 ** 2
  t269 = 0.1e1 / t19 / t231 / r0
  t270 = t265 * t29 * t269
  t313 = 0.100e3 / 0.3e1 * t62 * t51 * t66 * t270 + 0.100e3 * t152 * t72 * t270 + 0.200e3 / 0.3e1 * t64 * t78 * t270 + 0.200e3 / 0.3e1 * t68 * t57 * t72 * t270 + 0.1600e4 / 0.9e1 * t159 * t78 * t270 + 0.1000e4 / 0.9e1 * t70 * t84 * t270 + 0.1000e4 / 0.9e1 * t74 * t63 * t78 * t270 + 0.2500e4 / 0.9e1 * t166 * t84 * t270 + 0.500e3 / 0.3e1 * t76 * t90 * t270 + 0.500e3 / 0.3e1 * t80 * t69 * t84 * t270 + 0.400e3 * t173 * t90 * t270 + 0.700e3 / 0.3e1 * t82 * t96 * t270 + 0.700e3 / 0.3e1 * t86 * t75 * t90 * t270
  t362 = 0.4900e4 / 0.9e1 * t181 * t96 * t270 + 0.2800e4 / 0.9e1 * t88 * t102 * t270 + 0.2800e4 / 0.9e1 * t92 * t81 * t96 * t270 + 0.6400e4 / 0.9e1 * t188 * t102 * t270 + 0.400e3 * t94 * t108 * t270 + 0.400e3 * t98 * t87 * t102 * t270 + 0.900e3 * t195 * t108 * t270 + 0.500e3 * t100 * t114 * t270 + 0.500e3 * t104 * t93 * t108 * t270 + 0.10000e5 / 0.9e1 * t202 * t114 * t270 + 0.5500e4 / 0.9e1 * t106 * t214 * t270 + 0.5500e4 / 0.9e1 * t110 * t99 * t114 * t270 + 0.12100e5 / 0.9e1 * t209 * t214 * t270 + 0.2200e4 / 0.3e1 * t112 / t95 / t77 * t270
  t365 = 0.1e1 / t20 / t121
  t366 = t47 * t365
  t393 = -0.280e3 / 0.9e1 * t185 * t366 - 0.320e3 / 0.9e1 * t189 * t366 - 0.320e3 / 0.9e1 * t192 * t366 - 0.40e2 * t196 * t366 - 0.40e2 * t199 * t366 - 0.400e3 / 0.9e1 * t203 * t366 - 0.400e3 / 0.9e1 * t206 * t366 - 0.440e3 / 0.9e1 * t210 * t366 - 0.440e3 / 0.9e1 * t215 * t366 - 0.40e2 / 0.3e1 * t156 * t366 - 0.160e3 / 0.9e1 * t160 * t366 - 0.160e3 / 0.9e1 * t163 * t366 - 0.200e3 / 0.9e1 * t167 * t366
  t421 = t29 * t269 * t60
  t431 = -0.200e3 / 0.9e1 * t170 * t366 - 0.80e2 / 0.3e1 * t174 * t366 - 0.80e2 / 0.3e1 * t178 * t366 - 0.280e3 / 0.9e1 * t182 * t366 - 0.40e2 / 0.9e1 * t141 * t366 - 0.80e2 / 0.9e1 * t146 * t366 - 0.80e2 / 0.9e1 * t149 * t366 - 0.40e2 / 0.3e1 * t153 * t366 + 0.100e3 / 0.9e1 * t52 * t66 * t270 + 0.400e3 / 0.9e1 * t145 * t66 * t270 + 0.100e3 / 0.3e1 * t58 * t72 * t270 + 0.100e3 / 0.9e1 * t43 * t265 * t421 + 0.100e3 / 0.9e1 * t56 * t265 * t421 - 0.40e2 / 0.9e1 * t136 * t30 * t365 * t54
  t439 = f.my_piecewise3(t2, 0, t18 * t49 * params.csi_HF * t117 / 0.12e2 - 0.17737248829318510714200000000000000000000000000001e-1 * t6 * t17 / t19 / t231 * params.csi_HF * t132 - t18 * t22 * t220 / 0.4e1 + 0.57682839906449121414493270962060930666666666666673e-3 * t6 * t17 / t231 / t121 * params.csi_HF / t127 / t38 * t44 / t25 / t24 * t253 * t29 * t116 + 0.11824832552879007142800000000000000000000000000001e-1 * t126 * t130 * t31 * t219 - 0.3e1 / 0.8e1 * t18 * t135 * t41 * (t313 + t362 + t393 + t431))
  v2rho2_0_ = 0.2e1 * r0 * t439 + 0.4e1 * t225
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = t22 * params.csi_HF
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t33 = r0 ** 2
  t35 = 0.1e1 / t20 / t33
  t39 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t24 * t28 * t32 * t35
  t42 = 0.18040e1 - 0.64641600e0 / t39
  t44 = params.a[1]
  t45 = t24 ** 2
  t47 = 0.3e1 / 0.10e2 * t45 * t27
  t48 = tau0 * t31
  t49 = t48 * t22
  t50 = t47 - t49
  t51 = t44 * t50
  t52 = t47 + t49
  t53 = 0.1e1 / t52
  t55 = params.a[2]
  t56 = t50 ** 2
  t57 = t55 * t56
  t58 = t52 ** 2
  t59 = 0.1e1 / t58
  t61 = params.a[3]
  t62 = t56 * t50
  t63 = t61 * t62
  t64 = t58 * t52
  t65 = 0.1e1 / t64
  t67 = params.a[4]
  t68 = t56 ** 2
  t69 = t67 * t68
  t70 = t58 ** 2
  t71 = 0.1e1 / t70
  t73 = params.a[5]
  t74 = t68 * t50
  t75 = t73 * t74
  t76 = t70 * t52
  t77 = 0.1e1 / t76
  t79 = params.a[6]
  t80 = t68 * t56
  t81 = t79 * t80
  t82 = t70 * t58
  t83 = 0.1e1 / t82
  t85 = params.a[7]
  t86 = t68 * t62
  t87 = t85 * t86
  t89 = 0.1e1 / t70 / t64
  t91 = params.a[8]
  t92 = t68 ** 2
  t93 = t91 * t92
  t94 = t70 ** 2
  t95 = 0.1e1 / t94
  t97 = params.a[9]
  t98 = t92 * t50
  t99 = t97 * t98
  t101 = 0.1e1 / t94 / t52
  t103 = params.a[10]
  t104 = t92 * t56
  t105 = t103 * t104
  t107 = 0.1e1 / t94 / t58
  t109 = params.a[11]
  t111 = t109 * t92 * t62
  t113 = 0.1e1 / t94 / t64
  t115 = t99 * t101 + t105 * t107 + t111 * t113 + t51 * t53 + t57 * t59 + t63 * t65 + t69 * t71 + t75 * t77 + t81 * t83 + t87 * t89 + t93 * t95 + params.a[0]
  t116 = t42 * t115
  t120 = t33 ** 2
  t125 = t6 * t17 / t19 / t120 * params.csi_HF
  t126 = t39 ** 2
  t129 = 0.1e1 / t126 * t24 * t28
  t131 = t129 * t32 * t115
  t135 = 0.1e1 / t20 * params.csi_HF
  t136 = t44 * tau0
  t141 = t51 * t59
  t142 = t48 * t35
  t145 = t55 * t50
  t146 = t145 * t59
  t149 = t57 * t65
  t152 = t61 * t56
  t153 = t152 * t65
  t156 = t63 * t71
  t159 = t67 * t62
  t160 = t159 * t71
  t163 = t69 * t77
  t166 = t73 * t68
  t167 = t166 * t77
  t170 = t75 * t83
  t173 = t79 * t74
  t174 = t173 * t83
  t177 = 0.5e1 / 0.3e1 * t136 * t31 * t35 * t53 + 0.5e1 / 0.3e1 * t141 * t142 + 0.10e2 / 0.3e1 * t146 * t142 + 0.10e2 / 0.3e1 * t149 * t142 + 0.5e1 * t153 * t142 + 0.5e1 * t156 * t142 + 0.20e2 / 0.3e1 * t160 * t142 + 0.20e2 / 0.3e1 * t163 * t142 + 0.25e2 / 0.3e1 * t167 * t142 + 0.25e2 / 0.3e1 * t170 * t142 + 0.10e2 * t174 * t142
  t178 = t81 * t89
  t181 = t85 * t80
  t182 = t181 * t89
  t185 = t87 * t95
  t188 = t91 * t86
  t189 = t188 * t95
  t192 = t93 * t101
  t195 = t97 * t92
  t196 = t195 * t101
  t199 = t99 * t107
  t202 = t103 * t98
  t203 = t202 * t107
  t206 = t105 * t113
  t209 = t109 * t104
  t210 = t209 * t113
  t214 = 0.1e1 / t94 / t70
  t215 = t111 * t214
  t218 = 0.10e2 * t178 * t142 + 0.35e2 / 0.3e1 * t182 * t142 + 0.35e2 / 0.3e1 * t185 * t142 + 0.40e2 / 0.3e1 * t189 * t142 + 0.40e2 / 0.3e1 * t192 * t142 + 0.15e2 * t196 * t142 + 0.15e2 * t199 * t142 + 0.50e2 / 0.3e1 * t203 * t142 + 0.50e2 / 0.3e1 * t206 * t142 + 0.55e2 / 0.3e1 * t210 * t142 + 0.55e2 / 0.3e1 * t215 * t142
  t219 = t177 + t218
  t220 = t42 * t219
  t224 = t33 * r0
  t229 = t6 * t17 / t120 / t224 * params.csi_HF
  t235 = 0.1e1 / t126 / t39 * t45 / t26 / t25
  t236 = s0 ** 2
  t237 = t236 * t30
  t239 = t235 * t237 * t115
  t246 = t6 * t17 / t19 / t224 * params.csi_HF
  t248 = t129 * t32 * t219
  t251 = t19 * params.csi_HF
  t252 = t105 * t214
  t253 = tau0 ** 2
  t254 = t253 * t30
  t257 = 0.1e1 / t19 / t120 / r0
  t258 = t254 * t257
  t261 = t109 * t98
  t262 = t261 * t113
  t265 = t209 * t214
  t269 = 0.1e1 / t94 / t76
  t270 = t111 * t269
  t274 = 0.1e1 / t20 / t224
  t275 = t48 * t274
  t294 = 0.5500e4 / 0.9e1 * t252 * t258 + 0.5500e4 / 0.9e1 * t262 * t258 + 0.12100e5 / 0.9e1 * t265 * t258 + 0.2200e4 / 0.3e1 * t270 * t258 - 0.280e3 / 0.9e1 * t185 * t275 - 0.320e3 / 0.9e1 * t189 * t275 - 0.320e3 / 0.9e1 * t192 * t275 - 0.40e2 * t196 * t275 - 0.40e2 * t199 * t275 - 0.400e3 / 0.9e1 * t203 * t275 - 0.400e3 / 0.9e1 * t206 * t275 - 0.440e3 / 0.9e1 * t210 * t275 - 0.440e3 / 0.9e1 * t215 * t275
  t319 = t51 * t65
  t322 = t145 * t65
  t325 = -0.40e2 / 0.3e1 * t156 * t275 - 0.160e3 / 0.9e1 * t160 * t275 - 0.160e3 / 0.9e1 * t163 * t275 - 0.200e3 / 0.9e1 * t167 * t275 - 0.200e3 / 0.9e1 * t170 * t275 - 0.80e2 / 0.3e1 * t174 * t275 - 0.80e2 / 0.3e1 * t178 * t275 - 0.280e3 / 0.9e1 * t182 * t275 - 0.40e2 / 0.9e1 * t141 * t275 - 0.80e2 / 0.9e1 * t146 * t275 - 0.80e2 / 0.9e1 * t149 * t275 - 0.40e2 / 0.3e1 * t153 * t275 + 0.100e3 / 0.9e1 * t319 * t258 + 0.400e3 / 0.9e1 * t322 * t258
  t327 = t57 * t71
  t330 = t61 * t50
  t331 = t330 * t65
  t334 = t152 * t71
  t337 = t63 * t77
  t340 = t67 * t56
  t341 = t340 * t71
  t344 = t159 * t77
  t347 = t69 * t83
  t350 = t73 * t62
  t351 = t350 * t77
  t354 = t166 * t83
  t357 = t75 * t89
  t360 = t79 * t68
  t361 = t360 * t83
  t364 = t173 * t89
  t367 = t81 * t95
  t370 = 0.100e3 / 0.3e1 * t327 * t258 + 0.100e3 / 0.3e1 * t331 * t258 + 0.100e3 * t334 * t258 + 0.200e3 / 0.3e1 * t337 * t258 + 0.200e3 / 0.3e1 * t341 * t258 + 0.1600e4 / 0.9e1 * t344 * t258 + 0.1000e4 / 0.9e1 * t347 * t258 + 0.1000e4 / 0.9e1 * t351 * t258 + 0.2500e4 / 0.9e1 * t354 * t258 + 0.500e3 / 0.3e1 * t357 * t258 + 0.500e3 / 0.3e1 * t361 * t258 + 0.400e3 * t364 * t258 + 0.700e3 / 0.3e1 * t367 * t258
  t371 = t85 * t74
  t372 = t371 * t89
  t375 = t181 * t95
  t378 = t87 * t101
  t381 = t91 * t80
  t382 = t381 * t95
  t385 = t188 * t101
  t388 = t93 * t107
  t391 = t97 * t86
  t392 = t391 * t101
  t395 = t195 * t107
  t398 = t99 * t113
  t401 = t103 * t92
  t402 = t401 * t107
  t405 = t202 * t113
  t408 = t44 * t253
  t410 = t30 * t257 * t59
  t413 = t55 * t253
  t420 = 0.700e3 / 0.3e1 * t372 * t258 + 0.4900e4 / 0.9e1 * t375 * t258 + 0.2800e4 / 0.9e1 * t378 * t258 + 0.2800e4 / 0.9e1 * t382 * t258 + 0.6400e4 / 0.9e1 * t385 * t258 + 0.400e3 * t388 * t258 + 0.400e3 * t392 * t258 + 0.900e3 * t395 * t258 + 0.500e3 * t398 * t258 + 0.500e3 * t402 * t258 + 0.10000e5 / 0.9e1 * t405 * t258 + 0.100e3 / 0.9e1 * t408 * t410 + 0.100e3 / 0.9e1 * t413 * t410 - 0.40e2 / 0.9e1 * t136 * t31 * t274 * t53
  t422 = t294 + t325 + t370 + t420
  t423 = t42 * t422
  t428 = f.my_piecewise3(t2, 0, t18 * t23 * t116 / 0.12e2 - 0.17737248829318510714200000000000000000000000000001e-1 * t125 * t131 - t18 * t135 * t220 / 0.4e1 + 0.57682839906449121414493270962060930666666666666673e-3 * t229 * t239 + 0.11824832552879007142800000000000000000000000000001e-1 * t246 * t248 - 0.3e1 / 0.8e1 * t18 * t251 * t423)
  t442 = t120 ** 2
  t443 = 0.1e1 / t442
  t454 = t25 ** 2
  t463 = t126 ** 2
  t480 = 0.1e1 / t20 / t120
  t481 = t48 * t480
  t490 = 0.1e1 / t19 / t120 / t33
  t491 = t254 * t490
  t508 = 0.4400e4 / 0.27e2 * t206 * t481 + 0.4840e4 / 0.27e2 * t210 * t481 + 0.4840e4 / 0.27e2 * t215 * t481 - 0.20000e5 / 0.9e1 * t354 * t491 - 0.4000e4 / 0.3e1 * t357 * t491 - 0.4000e4 / 0.3e1 * t361 * t491 - 0.3200e4 * t364 * t491 - 0.5600e4 / 0.3e1 * t367 * t491 - 0.5600e4 / 0.3e1 * t372 * t491 - 0.800e3 / 0.9e1 * t319 * t491 - 0.3200e4 * t388 * t491
  t533 = -0.3200e4 * t392 * t491 - 0.7200e4 * t395 * t491 - 0.4000e4 * t398 * t491 - 0.4000e4 * t402 * t491 - 0.80000e5 / 0.9e1 * t405 * t491 - 0.44000e5 / 0.9e1 * t252 * t491 - 0.44000e5 / 0.9e1 * t262 * t491 - 0.96800e5 / 0.9e1 * t265 * t491 - 0.17600e5 / 0.3e1 * t270 * t491 - 0.800e3 * t334 * t491 - 0.1600e4 / 0.3e1 * t337 * t491 - 0.39200e5 / 0.9e1 * t375 * t491
  t559 = 0.880e3 / 0.27e2 * t146 * t481 + 0.880e3 / 0.27e2 * t149 * t481 + 0.440e3 / 0.9e1 * t153 * t481 + 0.1760e4 / 0.27e2 * t160 * t481 + 0.1760e4 / 0.27e2 * t163 * t481 + 0.2200e4 / 0.27e2 * t167 * t481 + 0.2200e4 / 0.27e2 * t170 * t481 + 0.880e3 / 0.9e1 * t174 * t481 + 0.880e3 / 0.9e1 * t178 * t481 - 0.22400e5 / 0.9e1 * t378 * t491 - 0.22400e5 / 0.9e1 * t382 * t491 - 0.51200e5 / 0.9e1 * t385 * t491
  t584 = 0.3080e4 / 0.27e2 * t182 * t481 + 0.440e3 / 0.27e2 * t141 * t481 + 0.3520e4 / 0.27e2 * t189 * t481 + 0.3520e4 / 0.27e2 * t192 * t481 + 0.440e3 / 0.3e1 * t196 * t481 + 0.440e3 / 0.3e1 * t199 * t481 + 0.4400e4 / 0.27e2 * t203 * t481 + 0.440e3 / 0.9e1 * t156 * t481 + 0.3080e4 / 0.27e2 * t185 * t481 - 0.3200e4 / 0.9e1 * t322 * t491 - 0.800e3 / 0.3e1 * t327 * t491 - 0.800e3 / 0.3e1 * t331 * t491
  t595 = t253 * tau0
  t597 = t113 * t595 * t443
  t601 = t214 * t595 * t443
  t605 = t269 * t595 * t443
  t622 = t71 * t595 * t443
  t625 = -0.1600e4 / 0.3e1 * t341 * t491 - 0.12800e5 / 0.9e1 * t344 * t491 - 0.8000e4 / 0.9e1 * t347 * t491 - 0.8000e4 / 0.9e1 * t351 * t491 + 0.50000e5 * t401 * t597 + 0.550000e6 / 0.9e1 * t202 * t601 + 0.220000e6 / 0.9e1 * t105 * t605 + 0.55000e5 / 0.3e1 * t109 * t92 * t597 + 0.605000e6 / 0.9e1 * t261 * t601 + 0.242000e6 / 0.3e1 * t209 * t605 + 0.286000e6 / 0.9e1 * t111 / t94 / t82 * t595 * t443 + 0.1000e4 / 0.9e1 * t51 * t622
  t629 = t77 * t595 * t443
  t637 = t83 * t595 * t443
  t648 = t89 * t595 * t443
  t658 = 0.2000e4 / 0.3e1 * t145 * t622 + 0.4000e4 / 0.9e1 * t57 * t629 + 0.1000e4 * t330 * t622 + 0.2000e4 * t152 * t629 + 0.10000e5 / 0.9e1 * t63 * t637 + 0.4000e4 / 0.9e1 * t67 * t50 * t622 + 0.8000e4 / 0.3e1 * t340 * t629 + 0.40000e5 / 0.9e1 * t159 * t637 + 0.20000e5 / 0.9e1 * t69 * t648 + 0.10000e5 / 0.9e1 * t73 * t56 * t629 + 0.50000e5 / 0.9e1 * t350 * t637 + 0.25000e5 / 0.3e1 * t166 * t648
  t661 = t95 * t595 * t443
  t672 = t101 * t595 * t443
  t683 = t107 * t595 * t443
  t693 = 0.35000e5 / 0.9e1 * t75 * t661 + 0.20000e5 / 0.9e1 * t79 * t62 * t637 + 0.10000e5 * t360 * t648 + 0.14000e5 * t173 * t661 + 0.56000e5 / 0.9e1 * t81 * t672 + 0.35000e5 / 0.9e1 * t85 * t68 * t648 + 0.49000e5 / 0.3e1 * t371 * t661 + 0.196000e6 / 0.9e1 * t181 * t672 + 0.28000e5 / 0.3e1 * t87 * t683 + 0.56000e5 / 0.9e1 * t91 * t74 * t661 + 0.224000e6 / 0.9e1 * t381 * t672 + 0.32000e5 * t188 * t683
  t700 = t30 * t490 * t59
  t719 = t443 * t65
  t728 = 0.40000e5 / 0.3e1 * t93 * t597 + 0.28000e5 / 0.3e1 * t97 * t80 * t672 - 0.800e3 / 0.9e1 * t408 * t700 - 0.800e3 / 0.9e1 * t413 * t700 + 0.440e3 / 0.27e2 * t136 * t31 * t480 * t53 + 0.36000e5 * t391 * t683 + 0.45000e5 * t195 * t597 + 0.55000e5 / 0.3e1 * t99 * t601 + 0.40000e5 / 0.3e1 * t103 * t86 * t683 + 0.2000e4 / 0.9e1 * t55 * t595 * t719 + 0.1000e4 / 0.9e1 * t61 * t595 * t719 + 0.1000e4 / 0.9e1 * t44 * t595 * t719
  t737 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t35 * params.csi_HF * t116 + 0.75547541310060323412333333333333333333333333333337e-1 * t6 * t17 * t257 * params.csi_HF * t131 + t18 * t23 * t220 / 0.4e1 - 0.57682839906449121414493270962060930666666666666673e-2 * t6 * t17 * t443 * params.csi_HF * t239 - 0.53211746487955532142600000000000000000000000000004e-1 * t125 * t248 - 0.3e1 / 0.8e1 * t18 * t135 * t423 + 0.50648988124176715967079377483126046972065229612999e-3 * t3 / t4 / t454 * t17 / t20 / t442 / t33 * params.csi_HF / t463 * t236 * s0 * t115 + 0.17304851971934736424347981288618279200000000000002e-2 * t229 * t235 * t237 * t219 + 0.17737248829318510714200000000000000000000000000001e-1 * t246 * t129 * t32 * t422 - 0.3e1 / 0.8e1 * t18 * t251 * t42 * (t508 + t533 + t559 + t584 + t625 + t658 + t693 + t728))
  v3rho3_0_ = 0.2e1 * r0 * t737 + 0.6e1 * t428

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = t23 * params.csi_HF
  t25 = 6 ** (0.1e1 / 0.3e1)
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = t25 * t29
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = s0 * t32
  t37 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t30 * t33 * t23
  t40 = 0.18040e1 - 0.64641600e0 / t37
  t42 = params.a[1]
  t43 = t25 ** 2
  t45 = 0.3e1 / 0.10e2 * t43 * t28
  t46 = tau0 * t32
  t48 = 0.1e1 / t21 / r0
  t49 = t46 * t48
  t50 = t45 - t49
  t51 = t42 * t50
  t52 = t45 + t49
  t53 = 0.1e1 / t52
  t55 = params.a[2]
  t56 = t50 ** 2
  t57 = t55 * t56
  t58 = t52 ** 2
  t59 = 0.1e1 / t58
  t61 = params.a[3]
  t62 = t56 * t50
  t63 = t61 * t62
  t64 = t58 * t52
  t65 = 0.1e1 / t64
  t67 = params.a[4]
  t68 = t56 ** 2
  t69 = t67 * t68
  t70 = t58 ** 2
  t71 = 0.1e1 / t70
  t73 = params.a[5]
  t74 = t68 * t50
  t75 = t73 * t74
  t76 = t70 * t52
  t77 = 0.1e1 / t76
  t79 = params.a[6]
  t80 = t68 * t56
  t81 = t79 * t80
  t82 = t70 * t58
  t83 = 0.1e1 / t82
  t85 = params.a[7]
  t86 = t68 * t62
  t87 = t85 * t86
  t88 = t70 * t64
  t89 = 0.1e1 / t88
  t91 = params.a[8]
  t92 = t68 ** 2
  t93 = t91 * t92
  t94 = t70 ** 2
  t95 = 0.1e1 / t94
  t97 = params.a[9]
  t98 = t92 * t50
  t99 = t97 * t98
  t101 = 0.1e1 / t94 / t52
  t103 = params.a[10]
  t104 = t92 * t56
  t105 = t103 * t104
  t107 = 0.1e1 / t94 / t58
  t109 = params.a[11]
  t111 = t109 * t92 * t62
  t113 = 0.1e1 / t94 / t64
  t115 = t99 * t101 + t105 * t107 + t111 * t113 + t51 * t53 + t57 * t59 + t63 * t65 + t69 * t71 + t75 * t77 + t81 * t83 + t87 * t89 + t93 * t95 + params.a[0]
  t116 = t40 * t115
  t120 = t19 ** 2
  t121 = t120 * r0
  t123 = 0.1e1 / t20 / t121
  t126 = t6 * t17 * t123 * params.csi_HF
  t127 = t37 ** 2
  t130 = 0.1e1 / t127 * t25 * t29
  t132 = t130 * t33 * t115
  t135 = t48 * params.csi_HF
  t136 = t42 * tau0
  t141 = t51 * t59
  t142 = t46 * t23
  t145 = t55 * t50
  t146 = t145 * t59
  t149 = t57 * t65
  t152 = t61 * t56
  t153 = t152 * t65
  t156 = t63 * t71
  t159 = t67 * t62
  t160 = t159 * t71
  t163 = t69 * t77
  t166 = t73 * t68
  t167 = t166 * t77
  t170 = t75 * t83
  t173 = t79 * t74
  t174 = t173 * t83
  t177 = 0.5e1 / 0.3e1 * t136 * t32 * t23 * t53 + 0.5e1 / 0.3e1 * t141 * t142 + 0.10e2 / 0.3e1 * t146 * t142 + 0.10e2 / 0.3e1 * t149 * t142 + 0.5e1 * t153 * t142 + 0.5e1 * t156 * t142 + 0.20e2 / 0.3e1 * t160 * t142 + 0.20e2 / 0.3e1 * t163 * t142 + 0.25e2 / 0.3e1 * t167 * t142 + 0.25e2 / 0.3e1 * t170 * t142 + 0.10e2 * t174 * t142
  t178 = t81 * t89
  t181 = t85 * t80
  t182 = t181 * t89
  t185 = t87 * t95
  t188 = t91 * t86
  t189 = t188 * t95
  t192 = t93 * t101
  t195 = t97 * t92
  t196 = t195 * t101
  t199 = t99 * t107
  t202 = t103 * t98
  t203 = t202 * t107
  t206 = t105 * t113
  t209 = t109 * t104
  t210 = t209 * t113
  t214 = 0.1e1 / t94 / t70
  t215 = t111 * t214
  t218 = 0.10e2 * t178 * t142 + 0.35e2 / 0.3e1 * t182 * t142 + 0.35e2 / 0.3e1 * t185 * t142 + 0.40e2 / 0.3e1 * t189 * t142 + 0.40e2 / 0.3e1 * t192 * t142 + 0.15e2 * t196 * t142 + 0.15e2 * t199 * t142 + 0.50e2 / 0.3e1 * t203 * t142 + 0.50e2 / 0.3e1 * t206 * t142 + 0.55e2 / 0.3e1 * t210 * t142 + 0.55e2 / 0.3e1 * t215 * t142
  t219 = t177 + t218
  t220 = t40 * t219
  t224 = t120 ** 2
  t225 = 0.1e1 / t224
  t228 = t6 * t17 * t225 * params.csi_HF
  t234 = 0.1e1 / t127 / t37 * t43 / t27 / t26
  t235 = s0 ** 2
  t236 = t235 * t31
  t238 = t234 * t236 * t115
  t245 = t6 * t17 / t20 / t120 * params.csi_HF
  t247 = t130 * t33 * t219
  t251 = 0.1e1 / t21 * params.csi_HF
  t252 = tau0 ** 2
  t253 = t42 * t252
  t255 = t31 * t123 * t59
  t258 = t55 * t252
  t261 = t19 * r0
  t263 = 0.1e1 / t21 / t261
  t268 = t93 * t107
  t269 = t252 * t31
  t270 = t269 * t123
  t273 = t97 * t86
  t274 = t273 * t101
  t277 = t195 * t107
  t280 = t99 * t113
  t283 = t103 * t92
  t284 = t283 * t107
  t287 = t202 * t113
  t290 = t105 * t214
  t293 = t109 * t98
  t294 = t293 * t113
  t297 = t209 * t214
  t301 = 0.1e1 / t94 / t76
  t302 = t111 * t301
  t305 = 0.100e3 / 0.9e1 * t253 * t255 + 0.100e3 / 0.9e1 * t258 * t255 - 0.40e2 / 0.9e1 * t136 * t32 * t263 * t53 + 0.400e3 * t268 * t270 + 0.400e3 * t274 * t270 + 0.900e3 * t277 * t270 + 0.500e3 * t280 * t270 + 0.500e3 * t284 * t270 + 0.10000e5 / 0.9e1 * t287 * t270 + 0.5500e4 / 0.9e1 * t290 * t270 + 0.5500e4 / 0.9e1 * t294 * t270 + 0.12100e5 / 0.9e1 * t297 * t270 + 0.2200e4 / 0.3e1 * t302 * t270
  t306 = t46 * t263
  t335 = -0.280e3 / 0.9e1 * t185 * t306 - 0.320e3 / 0.9e1 * t189 * t306 - 0.320e3 / 0.9e1 * t192 * t306 - 0.40e2 * t196 * t306 - 0.40e2 * t199 * t306 - 0.400e3 / 0.9e1 * t203 * t306 - 0.400e3 / 0.9e1 * t206 * t306 - 0.440e3 / 0.9e1 * t210 * t306 - 0.440e3 / 0.9e1 * t215 * t306 - 0.40e2 / 0.3e1 * t156 * t306 - 0.160e3 / 0.9e1 * t160 * t306 - 0.160e3 / 0.9e1 * t163 * t306 - 0.200e3 / 0.9e1 * t167 * t306 - 0.200e3 / 0.9e1 * t170 * t306
  t351 = t51 * t65
  t354 = t145 * t65
  t357 = t57 * t71
  t360 = t61 * t50
  t361 = t360 * t65
  t364 = t152 * t71
  t367 = t63 * t77
  t370 = -0.80e2 / 0.3e1 * t174 * t306 - 0.80e2 / 0.3e1 * t178 * t306 - 0.280e3 / 0.9e1 * t182 * t306 - 0.40e2 / 0.9e1 * t141 * t306 - 0.80e2 / 0.9e1 * t146 * t306 - 0.80e2 / 0.9e1 * t149 * t306 - 0.40e2 / 0.3e1 * t153 * t306 + 0.100e3 / 0.9e1 * t351 * t270 + 0.400e3 / 0.9e1 * t354 * t270 + 0.100e3 / 0.3e1 * t357 * t270 + 0.100e3 / 0.3e1 * t361 * t270 + 0.100e3 * t364 * t270 + 0.200e3 / 0.3e1 * t367 * t270
  t371 = t67 * t56
  t372 = t371 * t71
  t375 = t159 * t77
  t378 = t69 * t83
  t381 = t73 * t62
  t382 = t381 * t77
  t385 = t166 * t83
  t388 = t75 * t89
  t391 = t79 * t68
  t392 = t391 * t83
  t395 = t173 * t89
  t398 = t81 * t95
  t401 = t85 * t74
  t402 = t401 * t89
  t405 = t181 * t95
  t408 = t87 * t101
  t411 = t91 * t80
  t412 = t411 * t95
  t415 = t188 * t101
  t418 = 0.200e3 / 0.3e1 * t372 * t270 + 0.1600e4 / 0.9e1 * t375 * t270 + 0.1000e4 / 0.9e1 * t378 * t270 + 0.1000e4 / 0.9e1 * t382 * t270 + 0.2500e4 / 0.9e1 * t385 * t270 + 0.500e3 / 0.3e1 * t388 * t270 + 0.500e3 / 0.3e1 * t392 * t270 + 0.400e3 * t395 * t270 + 0.700e3 / 0.3e1 * t398 * t270 + 0.700e3 / 0.3e1 * t402 * t270 + 0.4900e4 / 0.9e1 * t405 * t270 + 0.2800e4 / 0.9e1 * t408 * t270 + 0.2800e4 / 0.9e1 * t412 * t270 + 0.6400e4 / 0.9e1 * t415 * t270
  t420 = t305 + t335 + t370 + t418
  t421 = t40 * t420
  t425 = t26 ** 2
  t428 = t3 / t4 / t425
  t431 = 0.1e1 / t21 / t224 / t19
  t433 = t428 * t17 * t431
  t434 = t127 ** 2
  t436 = params.csi_HF / t434
  t437 = t235 * s0
  t439 = t436 * t437 * t115
  t442 = t120 * t261
  t446 = t6 * t17 / t442 * params.csi_HF
  t448 = t234 * t236 * t219
  t455 = t6 * t17 / t20 / t261 * params.csi_HF
  t457 = t130 * t33 * t420
  t460 = t20 * params.csi_HF
  t461 = t252 * tau0
  t462 = t107 * t461
  t463 = t462 * t225
  t466 = t113 * t461
  t467 = t466 * t225
  t470 = t97 * t80
  t471 = t101 * t461
  t472 = t471 * t225
  t475 = t120 * t19
  t477 = 0.1e1 / t20 / t475
  t479 = t31 * t477 * t59
  t485 = 0.1e1 / t21 / t120
  t494 = t214 * t461
  t495 = t494 * t225
  t498 = t103 * t86
  t503 = 0.32000e5 * t188 * t463 + 0.40000e5 / 0.3e1 * t93 * t467 + 0.28000e5 / 0.3e1 * t470 * t472 - 0.800e3 / 0.9e1 * t253 * t479 - 0.800e3 / 0.9e1 * t258 * t479 + 0.440e3 / 0.27e2 * t136 * t32 * t485 * t53 + 0.36000e5 * t273 * t463 + 0.45000e5 * t195 * t467 + 0.55000e5 / 0.3e1 * t99 * t495 + 0.40000e5 / 0.3e1 * t498 * t463 + 0.50000e5 * t283 * t467
  t506 = t301 * t461
  t507 = t506 * t225
  t510 = t109 * t92
  t518 = 0.1e1 / t94 / t82
  t519 = t518 * t461
  t523 = t71 * t461
  t524 = t523 * t225
  t529 = t77 * t461
  t530 = t529 * t225
  t537 = t83 * t461
  t538 = t537 * t225
  t541 = 0.550000e6 / 0.9e1 * t202 * t495 + 0.220000e6 / 0.9e1 * t105 * t507 + 0.55000e5 / 0.3e1 * t510 * t467 + 0.605000e6 / 0.9e1 * t293 * t495 + 0.242000e6 / 0.3e1 * t209 * t507 + 0.286000e6 / 0.9e1 * t111 * t519 * t225 + 0.1000e4 / 0.9e1 * t51 * t524 + 0.2000e4 / 0.3e1 * t145 * t524 + 0.4000e4 / 0.9e1 * t57 * t530 + 0.1000e4 * t360 * t524 + 0.2000e4 * t152 * t530 + 0.10000e5 / 0.9e1 * t63 * t538
  t543 = t67 * t50
  t550 = t89 * t461
  t551 = t550 * t225
  t554 = t73 * t56
  t561 = t95 * t461
  t562 = t561 * t225
  t565 = t79 * t62
  t574 = 0.4000e4 / 0.9e1 * t543 * t524 + 0.8000e4 / 0.3e1 * t371 * t530 + 0.40000e5 / 0.9e1 * t159 * t538 + 0.20000e5 / 0.9e1 * t69 * t551 + 0.10000e5 / 0.9e1 * t554 * t530 + 0.50000e5 / 0.9e1 * t381 * t538 + 0.25000e5 / 0.3e1 * t166 * t551 + 0.35000e5 / 0.9e1 * t75 * t562 + 0.20000e5 / 0.9e1 * t565 * t538 + 0.10000e5 * t391 * t551 + 0.14000e5 * t173 * t562 + 0.56000e5 / 0.9e1 * t81 * t472
  t575 = t85 * t68
  t584 = t91 * t74
  t589 = t46 * t485
  t602 = 0.35000e5 / 0.9e1 * t575 * t551 + 0.49000e5 / 0.3e1 * t401 * t562 + 0.196000e6 / 0.9e1 * t181 * t472 + 0.28000e5 / 0.3e1 * t87 * t463 + 0.56000e5 / 0.9e1 * t584 * t562 + 0.224000e6 / 0.9e1 * t411 * t472 + 0.440e3 / 0.27e2 * t141 * t589 + 0.3520e4 / 0.27e2 * t189 * t589 + 0.3520e4 / 0.27e2 * t192 * t589 + 0.440e3 / 0.3e1 * t196 * t589 + 0.440e3 / 0.3e1 * t199 * t589 + 0.4400e4 / 0.27e2 * t203 * t589
  t615 = t269 * t477
  t630 = 0.4400e4 / 0.27e2 * t206 * t589 + 0.4840e4 / 0.27e2 * t210 * t589 + 0.4840e4 / 0.27e2 * t215 * t589 + 0.440e3 / 0.9e1 * t156 * t589 + 0.3080e4 / 0.27e2 * t185 * t589 - 0.800e3 / 0.9e1 * t351 * t615 - 0.3200e4 / 0.9e1 * t354 * t615 - 0.800e3 / 0.3e1 * t357 * t615 - 0.800e3 / 0.3e1 * t361 * t615 - 0.1600e4 / 0.3e1 * t372 * t615 - 0.12800e5 / 0.9e1 * t375 * t615 - 0.8000e4 / 0.9e1 * t378 * t615
  t655 = -0.8000e4 / 0.9e1 * t382 * t615 - 0.20000e5 / 0.9e1 * t385 * t615 - 0.4000e4 / 0.3e1 * t388 * t615 - 0.4000e4 / 0.3e1 * t392 * t615 - 0.3200e4 * t395 * t615 - 0.5600e4 / 0.3e1 * t398 * t615 - 0.5600e4 / 0.3e1 * t402 * t615 - 0.3200e4 * t268 * t615 - 0.3200e4 * t274 * t615 - 0.7200e4 * t277 * t615 - 0.4000e4 * t280 * t615 - 0.4000e4 * t284 * t615
  t681 = -0.80000e5 / 0.9e1 * t287 * t615 - 0.44000e5 / 0.9e1 * t290 * t615 - 0.44000e5 / 0.9e1 * t294 * t615 - 0.96800e5 / 0.9e1 * t297 * t615 - 0.17600e5 / 0.3e1 * t302 * t615 - 0.800e3 * t364 * t615 - 0.1600e4 / 0.3e1 * t367 * t615 + 0.880e3 / 0.27e2 * t146 * t589 + 0.880e3 / 0.27e2 * t149 * t589 + 0.440e3 / 0.9e1 * t153 * t589 + 0.1760e4 / 0.27e2 * t160 * t589 + 0.1760e4 / 0.27e2 * t163 * t589
  t700 = t55 * t461
  t701 = t225 * t65
  t704 = t61 * t461
  t707 = t42 * t461
  t710 = 0.2200e4 / 0.27e2 * t167 * t589 + 0.2200e4 / 0.27e2 * t170 * t589 + 0.880e3 / 0.9e1 * t174 * t589 - 0.39200e5 / 0.9e1 * t405 * t615 - 0.22400e5 / 0.9e1 * t408 * t615 - 0.22400e5 / 0.9e1 * t412 * t615 - 0.51200e5 / 0.9e1 * t415 * t615 + 0.880e3 / 0.9e1 * t178 * t589 + 0.3080e4 / 0.27e2 * t182 * t589 + 0.2000e4 / 0.9e1 * t700 * t701 + 0.1000e4 / 0.9e1 * t704 * t701 + 0.1000e4 / 0.9e1 * t707 * t701
  t713 = t503 + t541 + t574 + t602 + t630 + t655 + t681 + t710
  t714 = t40 * t713
  t719 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t24 * t116 + 0.75547541310060323412333333333333333333333333333337e-1 * t126 * t132 + t18 * t135 * t220 / 0.4e1 - 0.57682839906449121414493270962060930666666666666673e-2 * t228 * t238 - 0.53211746487955532142600000000000000000000000000004e-1 * t245 * t247 - 0.3e1 / 0.8e1 * t18 * t251 * t421 + 0.50648988124176715967079377483126046972065229612999e-3 * t433 * t439 + 0.17304851971934736424347981288618279200000000000002e-2 * t446 * t448 + 0.17737248829318510714200000000000000000000000000001e-1 * t455 * t457 - 0.3e1 / 0.8e1 * t18 * t460 * t714)
  t729 = 0.1e1 / t224 / r0
  t730 = t466 * t729
  t733 = t494 * t729
  t736 = t506 * t729
  t744 = t462 * t729
  t750 = 0.1e1 / t20 / t442
  t752 = t31 * t750 * t59
  t756 = 0.1e1 / t21 / t121
  t767 = t471 * t729
  t770 = t252 ** 2
  t773 = t32 * t431 * t71
  t785 = t561 * t729
  t788 = -0.880000e6 / 0.3e1 * t510 * t730 - 0.9680000e7 / 0.9e1 * t293 * t733 - 0.3872000e7 / 0.3e1 * t209 * t736 - 0.4576000e7 / 0.9e1 * t111 * t519 * t729 - 0.880000e6 / 0.3e1 * t99 * t733 - 0.640000e6 / 0.3e1 * t498 * t744 - 0.800000e6 * t283 * t730 + 0.54400e5 / 0.81e2 * t258 * t752 - 0.6160e4 / 0.81e2 * t136 * t32 * t756 * t53 - 0.576000e6 * t273 * t744 - 0.720000e6 * t195 * t730 - 0.640000e6 / 0.3e1 * t93 * t730 - 0.448000e6 / 0.3e1 * t470 * t767 + 0.20000e5 / 0.27e2 * t67 * t770 * t773 + 0.20000e5 / 0.27e2 * t42 * t770 * t773 + 0.20000e5 / 0.9e1 * t55 * t770 * t773 + 0.20000e5 / 0.9e1 * t61 * t770 * t773 - 0.784000e6 / 0.3e1 * t401 * t785
  t801 = t523 * t729
  t806 = t529 * t729
  t815 = t537 * t729
  t818 = t550 * t729
  t829 = -0.3136000e7 / 0.9e1 * t181 * t767 - 0.448000e6 / 0.3e1 * t87 * t744 - 0.896000e6 / 0.9e1 * t584 * t785 - 0.3584000e7 / 0.9e1 * t411 * t767 - 0.512000e6 * t188 * t744 + 0.54400e5 / 0.81e2 * t253 * t752 - 0.16000e5 / 0.9e1 * t51 * t801 - 0.32000e5 / 0.3e1 * t145 * t801 - 0.64000e5 / 0.9e1 * t57 * t806 - 0.16000e5 * t360 * t801 - 0.64000e5 / 0.9e1 * t543 * t801 - 0.128000e6 / 0.3e1 * t371 * t806 - 0.640000e6 / 0.9e1 * t159 * t815 - 0.320000e6 / 0.9e1 * t69 * t818 - 0.160000e6 / 0.9e1 * t554 * t806 - 0.800000e6 / 0.9e1 * t381 * t815 - 0.400000e6 / 0.3e1 * t166 * t818 - 0.320000e6 / 0.9e1 * t565 * t815
  t851 = t770 * t431 * t32
  t861 = t269 * t750
  t874 = -0.160000e6 * t391 * t818 - 0.224000e6 * t173 * t785 - 0.896000e6 / 0.9e1 * t81 * t767 - 0.560000e6 / 0.9e1 * t575 * t818 - 0.560000e6 / 0.9e1 * t75 * t785 - 0.32000e5 * t152 * t806 - 0.160000e6 / 0.9e1 * t63 * t815 - 0.8800000e7 / 0.9e1 * t202 * t733 - 0.3520000e7 / 0.9e1 * t105 * t736 + 0.1100000e7 / 0.3e1 * t99 * t301 * t851 + 0.1400000e7 / 0.9e1 * t103 * t80 * t107 * t851 + 0.8000000e7 / 0.9e1 * t498 * t113 * t851 + 0.217600e6 / 0.9e1 * t274 * t861 + 0.54400e5 * t277 * t861 + 0.272000e6 / 0.9e1 * t280 * t861 + 0.272000e6 / 0.9e1 * t284 * t861 + 0.5440000e7 / 0.81e2 * t287 * t861 + 0.2992000e7 / 0.81e2 * t290 * t861
  t918 = 0.2992000e7 / 0.81e2 * t294 * t861 + 0.6582400e7 / 0.81e2 * t297 * t861 + 0.1196800e7 / 0.27e2 * t302 * t861 + 0.54400e5 / 0.9e1 * t364 * t861 + 0.8960000e7 / 0.27e2 * t584 * t101 * t851 + 0.2240000e7 / 0.3e1 * t411 * t107 * t851 + 0.6400000e7 / 0.9e1 * t188 * t113 * t851 + 0.2200000e7 / 0.9e1 * t93 * t214 * t851 + 0.280000e6 / 0.3e1 * t97 * t74 * t101 * t851 + 0.560000e6 * t470 * t107 * t851 + 0.272000e6 / 0.27e2 * t388 * t861 + 0.272000e6 / 0.27e2 * t392 * t861 + 0.544000e6 / 0.81e2 * t382 * t861 + 0.1360000e7 / 0.81e2 * t385 * t861 + 0.217600e6 / 0.81e2 * t354 * t861 + 0.54400e5 / 0.27e2 * t357 * t861 + 0.54400e5 / 0.27e2 * t361 * t861 + 0.108800e6 / 0.27e2 * t372 * t861
  t925 = t46 * t756
  t958 = 0.870400e6 / 0.81e2 * t375 * t861 + 0.544000e6 / 0.81e2 * t378 * t861 - 0.49280e5 / 0.81e2 * t192 * t925 - 0.6160e4 / 0.9e1 * t196 * t925 - 0.6160e4 / 0.9e1 * t199 * t925 - 0.61600e5 / 0.81e2 * t203 * t925 + 0.108800e6 / 0.27e2 * t367 * t861 + 0.217600e6 / 0.9e1 * t395 * t861 + 0.380800e6 / 0.27e2 * t398 * t861 + 0.380800e6 / 0.27e2 * t402 * t861 + 0.54400e5 / 0.81e2 * t351 * t861 + 0.217600e6 / 0.9e1 * t268 * t861 - 0.61600e5 / 0.81e2 * t206 * t925 - 0.67760e5 / 0.81e2 * t210 * t925 - 0.67760e5 / 0.81e2 * t215 * t925 - 0.6160e4 / 0.27e2 * t156 * t925 - 0.43120e5 / 0.81e2 * t185 * t925 + 0.1523200e7 / 0.81e2 * t408 * t861
  t1003 = 0.1523200e7 / 0.81e2 * t412 * t861 + 0.3481600e7 / 0.81e2 * t415 * t861 - 0.12320e5 / 0.27e2 * t178 * t925 - 0.43120e5 / 0.81e2 * t182 * t925 - 0.6160e4 / 0.81e2 * t141 * t925 - 0.49280e5 / 0.81e2 * t189 * t925 + 0.2665600e7 / 0.81e2 * t405 * t861 + 0.100000e6 / 0.9e1 * t79 * t56 * t83 * t851 + 0.800000e6 / 0.9e1 * t565 * t89 * t851 + 0.700000e6 / 0.3e1 * t391 * t95 * t851 + 0.2240000e7 / 0.9e1 * t173 * t101 * t851 + 0.280000e6 / 0.3e1 * t81 * t107 * t851 + 0.700000e6 / 0.27e2 * t85 * t62 * t89 * t851 - 0.12320e5 / 0.27e2 * t174 * t925 - 0.12320e5 / 0.81e2 * t146 * t925 - 0.12320e5 / 0.81e2 * t149 * t925 - 0.6160e4 / 0.27e2 * t153 * t925 - 0.24640e5 / 0.81e2 * t160 * t925
  t1060 = -0.24640e5 / 0.81e2 * t163 * t925 - 0.30800e5 / 0.81e2 * t167 * t925 - 0.30800e5 / 0.81e2 * t170 * t925 + 0.1200000e7 * t273 * t113 * t851 + 0.3920000e7 / 0.9e1 * t181 * t107 * t851 + 0.1400000e7 / 0.9e1 * t87 * t113 * t851 + 0.1400000e7 / 0.27e2 * t91 * t68 * t95 * t851 + 0.2200000e7 / 0.9e1 * t109 * t86 * t113 * t851 + 0.12100000e8 / 0.9e1 * t510 * t214 * t851 + 0.24200000e8 / 0.9e1 * t293 * t301 * t851 + 0.62920000e8 / 0.27e2 * t209 * t518 * t851 + 0.20020000e8 / 0.27e2 * t111 / t94 / t88 * t851 + 0.1100000e7 * t195 * t214 * t851 + 0.4900000e7 / 0.27e2 * t575 * t95 * t851 + 0.3920000e7 / 0.9e1 * t401 * t101 * t851 + 0.400000e6 / 0.9e1 * t371 * t83 * t851 + 0.1600000e7 / 0.27e2 * t159 * t89 * t851 + 0.700000e6 / 0.27e2 * t69 * t95 * t851
  t1107 = t729 * t65
  t1114 = 0.100000e6 / 0.27e2 * t73 * t50 * t77 * t851 + 0.1000000e7 / 0.27e2 * t554 * t83 * t851 + 0.1000000e7 / 0.9e1 * t381 * t89 * t851 + 0.3500000e7 / 0.27e2 * t166 * t95 * t851 + 0.1400000e7 / 0.27e2 * t75 * t101 * t851 + 0.20000e5 / 0.27e2 * t51 * t77 * t851 + 0.160000e6 / 0.27e2 * t145 * t77 * t851 + 0.100000e6 / 0.27e2 * t57 * t83 * t851 + 0.40000e5 / 0.3e1 * t360 * t77 * t851 + 0.200000e6 / 0.9e1 * t152 * t83 * t851 + 0.100000e6 / 0.9e1 * t63 * t89 * t851 + 0.320000e6 / 0.27e2 * t543 * t77 * t851 + 0.5500000e7 / 0.3e1 * t283 * t214 * t851 + 0.44000000e8 / 0.27e2 * t202 * t301 * t851 + 0.14300000e8 / 0.27e2 * t105 * t518 * t851 - 0.32000e5 / 0.9e1 * t700 * t1107 - 0.16000e5 / 0.9e1 * t704 * t1107 - 0.16000e5 / 0.9e1 * t707 * t1107
  t1163 = t235 ** 2
  t1178 = -0.5e1 / 0.9e1 * t18 * t24 * t220 + 0.10e2 / 0.27e2 * t18 * t263 * params.csi_HF * t116 - 0.3e1 / 0.8e1 * t18 * t460 * t40 * (t788 + t829 + t874 + t918 + t958 + t1003 + t1060 + t1114) + 0.20259595249670686386831750993250418788826091845200e-2 * t433 * t436 * t437 * t219 - t18 * t251 * t714 / 0.2e1 + t18 * t135 * t421 / 0.2e1 - 0.10467457545663187966529738013179383040893480786686e-1 * t428 * t17 / t21 / t224 / t261 * t439 - 0.40073043651423301983933333333333333333333333333336e0 * t6 * t17 * t477 * params.csi_HF * t132 + 0.30219016524024129364933333333333333333333333333336e0 * t126 * t247 + 0.53516857024316684867890979170356530118518518518524e-1 * t6 * t17 * t729 * params.csi_HF * t238 - 0.23073135962579648565797308384824372266666666666669e-1 * t228 * t448 - 0.10642349297591106428520000000000000000000000000001e0 * t245 * t457 + 0.49414272216128897098646245549604736963326257894305e-4 * t428 * t17 / t20 / t224 / t475 * params.csi_HF / t434 / t37 * t1163 * t115 * t30 * t32 + 0.34609703943869472848695962577236558400000000000004e-2 * t446 * t234 * t236 * t420 + 0.23649665105758014285600000000000000000000000000001e-1 * t455 * t130 * t33 * t713
  t1179 = f.my_piecewise3(t2, 0, t1178)
  v4rho4_0_ = 0.2e1 * r0 * t1179 + 0.8e1 * t719

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = t31 * params.csi_HF
  t33 = 6 ** (0.1e1 / 0.3e1)
  t34 = jnp.pi ** 2
  t35 = t34 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t33 * t37
  t39 = r0 ** 2
  t40 = r0 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t43 = 0.1e1 / t41 / t39
  t47 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t38 * s0 * t43
  t50 = 0.18040e1 - 0.64641600e0 / t47
  t51 = params.a[0]
  t52 = params.a[1]
  t53 = t33 ** 2
  t55 = 0.3e1 / 0.10e2 * t53 * t36
  t58 = tau0 / t41 / r0
  t59 = t55 - t58
  t60 = t52 * t59
  t61 = t55 + t58
  t62 = 0.1e1 / t61
  t64 = params.a[2]
  t65 = t59 ** 2
  t66 = t64 * t65
  t67 = t61 ** 2
  t68 = 0.1e1 / t67
  t70 = params.a[3]
  t71 = t65 * t59
  t72 = t70 * t71
  t73 = t67 * t61
  t74 = 0.1e1 / t73
  t76 = params.a[4]
  t77 = t65 ** 2
  t78 = t76 * t77
  t79 = t67 ** 2
  t80 = 0.1e1 / t79
  t82 = params.a[5]
  t83 = t77 * t59
  t84 = t82 * t83
  t85 = t79 * t61
  t86 = 0.1e1 / t85
  t88 = params.a[6]
  t89 = t77 * t65
  t90 = t88 * t89
  t92 = 0.1e1 / t79 / t67
  t94 = params.a[7]
  t95 = t77 * t71
  t96 = t94 * t95
  t98 = 0.1e1 / t79 / t73
  t100 = params.a[8]
  t101 = t77 ** 2
  t102 = t100 * t101
  t103 = t79 ** 2
  t104 = 0.1e1 / t103
  t106 = params.a[9]
  t107 = t101 * t59
  t108 = t106 * t107
  t110 = 0.1e1 / t103 / t61
  t112 = params.a[10]
  t113 = t101 * t65
  t114 = t112 * t113
  t116 = 0.1e1 / t103 / t67
  t118 = params.a[11]
  t120 = t118 * t101 * t71
  t122 = 0.1e1 / t103 / t73
  t124 = t102 * t104 + t108 * t110 + t114 * t116 + t120 * t122 + t60 * t62 + t66 * t68 + t72 * t74 + t78 * t80 + t84 * t86 + t90 * t92 + t96 * t98 + t51
  t125 = t50 * t124
  t126 = t32 * t125
  t129 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t130 = t129 * f.p.zeta_threshold
  t132 = f.my_piecewise3(t20, t130, t21 * t19)
  t133 = t5 * t132
  t134 = t31 ** 2
  t135 = 0.1e1 / t134
  t136 = t135 * params.csi_HF
  t137 = t136 * t125
  t139 = t133 * t137 / 0.8e1
  t142 = t5 * t132 * t31 * params.csi_HF
  t143 = t47 ** 2
  t146 = 0.1e1 / t143 * t33 * t37
  t147 = t39 * r0
  t149 = 0.1e1 / t41 / t147
  t150 = s0 * t149
  t152 = t146 * t150 * t124
  t155 = t52 * tau0
  t159 = t68 * tau0
  t160 = t159 * t43
  t163 = t64 * t59
  t166 = t74 * tau0
  t167 = t166 * t43
  t170 = t70 * t65
  t173 = t80 * tau0
  t174 = t173 * t43
  t177 = t76 * t71
  t180 = t86 * tau0
  t181 = t180 * t43
  t184 = t82 * t77
  t187 = t92 * tau0
  t188 = t187 * t43
  t191 = t88 * t83
  t194 = 0.5e1 / 0.3e1 * t155 * t43 * t62 + 0.5e1 / 0.3e1 * t60 * t160 + 0.10e2 / 0.3e1 * t163 * t160 + 0.10e2 / 0.3e1 * t66 * t167 + 0.5e1 * t170 * t167 + 0.5e1 * t72 * t174 + 0.20e2 / 0.3e1 * t177 * t174 + 0.20e2 / 0.3e1 * t78 * t181 + 0.25e2 / 0.3e1 * t184 * t181 + 0.25e2 / 0.3e1 * t84 * t188 + 0.10e2 * t191 * t188
  t195 = t98 * tau0
  t196 = t195 * t43
  t199 = t94 * t89
  t202 = t104 * tau0
  t203 = t202 * t43
  t206 = t100 * t95
  t209 = t110 * tau0
  t210 = t209 * t43
  t213 = t106 * t101
  t216 = t116 * tau0
  t217 = t216 * t43
  t220 = t112 * t107
  t223 = t122 * tau0
  t224 = t223 * t43
  t227 = t118 * t113
  t231 = 0.1e1 / t103 / t79
  t232 = t231 * tau0
  t236 = 0.10e2 * t90 * t196 + 0.35e2 / 0.3e1 * t199 * t196 + 0.35e2 / 0.3e1 * t96 * t203 + 0.40e2 / 0.3e1 * t206 * t203 + 0.40e2 / 0.3e1 * t102 * t210 + 0.15e2 * t213 * t210 + 0.15e2 * t108 * t217 + 0.50e2 / 0.3e1 * t220 * t217 + 0.50e2 / 0.3e1 * t114 * t224 + 0.55e2 / 0.3e1 * t227 * t224 + 0.55e2 / 0.3e1 * t120 * t232 * t43
  t237 = t194 + t236
  t238 = t50 * t237
  t239 = t32 * t238
  t243 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t126 - t139 + 0.59124162764395035714000000000000000000000000000004e-2 * t142 * t152 - 0.3e1 / 0.8e1 * t133 * t239)
  t245 = r1 <= f.p.dens_threshold
  t246 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t247 = 0.1e1 + t246
  t248 = t247 <= f.p.zeta_threshold
  t249 = t247 ** (0.1e1 / 0.3e1)
  t251 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t254 = f.my_piecewise3(t248, 0, 0.4e1 / 0.3e1 * t249 * t251)
  t255 = t5 * t254
  t256 = r1 ** 2
  t257 = r1 ** (0.1e1 / 0.3e1)
  t258 = t257 ** 2
  t260 = 0.1e1 / t258 / t256
  t264 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t38 * s2 * t260
  t267 = 0.18040e1 - 0.64641600e0 / t264
  t270 = tau1 / t258 / r1
  t271 = t55 - t270
  t272 = t52 * t271
  t273 = t55 + t270
  t274 = 0.1e1 / t273
  t276 = t271 ** 2
  t277 = t64 * t276
  t278 = t273 ** 2
  t279 = 0.1e1 / t278
  t281 = t276 * t271
  t282 = t70 * t281
  t283 = t278 * t273
  t284 = 0.1e1 / t283
  t286 = t276 ** 2
  t287 = t76 * t286
  t288 = t278 ** 2
  t289 = 0.1e1 / t288
  t291 = t286 * t271
  t292 = t82 * t291
  t293 = t288 * t273
  t294 = 0.1e1 / t293
  t296 = t286 * t276
  t297 = t88 * t296
  t299 = 0.1e1 / t288 / t278
  t301 = t286 * t281
  t302 = t94 * t301
  t304 = 0.1e1 / t288 / t283
  t306 = t286 ** 2
  t307 = t100 * t306
  t308 = t288 ** 2
  t309 = 0.1e1 / t308
  t311 = t306 * t271
  t312 = t106 * t311
  t314 = 0.1e1 / t308 / t273
  t316 = t306 * t276
  t317 = t112 * t316
  t319 = 0.1e1 / t308 / t278
  t322 = t118 * t306 * t281
  t324 = 0.1e1 / t308 / t283
  t326 = t272 * t274 + t277 * t279 + t282 * t284 + t287 * t289 + t292 * t294 + t297 * t299 + t302 * t304 + t307 * t309 + t312 * t314 + t317 * t319 + t322 * t324 + t51
  t327 = t267 * t326
  t328 = t32 * t327
  t332 = f.my_piecewise3(t248, t130, t249 * t247)
  t333 = t5 * t332
  t334 = t136 * t327
  t336 = t333 * t334 / 0.8e1
  t338 = f.my_piecewise3(t245, 0, -0.3e1 / 0.8e1 * t255 * t328 - t336)
  t340 = t21 ** 2
  t341 = 0.1e1 / t340
  t342 = t26 ** 2
  t347 = t16 / t22 / t6
  t349 = -0.2e1 * t23 + 0.2e1 * t347
  t350 = f.my_piecewise5(t10, 0, t14, 0, t349)
  t354 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t341 * t342 + 0.4e1 / 0.3e1 * t21 * t350)
  t358 = t30 * t137
  t369 = 0.1e1 / t134 / t6 * params.csi_HF
  t372 = t133 * t369 * t125 / 0.12e2
  t376 = t5 * t132 * t135 * params.csi_HF * t152
  t379 = t133 * t136 * t238
  t385 = 0.1e1 / t35 / t34
  t387 = s0 ** 2
  t388 = t39 ** 2
  t411 = tau0 ** 2
  t415 = 0.1e1 / t40 / t388 / r0
  t416 = t415 * t68
  t423 = t74 * t411 * t415
  t427 = t80 * t411 * t415
  t433 = t159 * t149
  t438 = t166 * t149
  t443 = t173 * t149
  t448 = t180 * t149
  t451 = -0.40e2 / 0.9e1 * t155 * t149 * t62 + 0.50e2 / 0.9e1 * t52 * t411 * t416 + 0.50e2 / 0.9e1 * t64 * t411 * t416 + 0.200e3 / 0.9e1 * t163 * t423 + 0.50e2 / 0.3e1 * t66 * t427 + 0.50e2 / 0.3e1 * t70 * t59 * t423 - 0.40e2 / 0.9e1 * t60 * t433 - 0.80e2 / 0.9e1 * t163 * t433 - 0.80e2 / 0.9e1 * t66 * t438 - 0.40e2 / 0.3e1 * t170 * t438 - 0.40e2 / 0.3e1 * t72 * t443 - 0.160e3 / 0.9e1 * t177 * t443 - 0.160e3 / 0.9e1 * t78 * t448
  t454 = t187 * t149
  t459 = t195 * t149
  t464 = t202 * t149
  t469 = t209 * t149
  t474 = t216 * t149
  t479 = t223 * t149
  t487 = -0.200e3 / 0.9e1 * t184 * t448 - 0.200e3 / 0.9e1 * t84 * t454 - 0.80e2 / 0.3e1 * t191 * t454 - 0.80e2 / 0.3e1 * t90 * t459 - 0.280e3 / 0.9e1 * t199 * t459 - 0.280e3 / 0.9e1 * t96 * t464 - 0.320e3 / 0.9e1 * t206 * t464 - 0.320e3 / 0.9e1 * t102 * t469 - 0.40e2 * t213 * t469 - 0.40e2 * t108 * t474 - 0.400e3 / 0.9e1 * t220 * t474 - 0.400e3 / 0.9e1 * t114 * t479 - 0.440e3 / 0.9e1 * t227 * t479 - 0.440e3 / 0.9e1 * t120 * t232 * t149
  t491 = t104 * t411 * t415
  t495 = t110 * t411 * t415
  t499 = t116 * t411 * t415
  t508 = t122 * t411 * t415
  t517 = t231 * t411 * t415
  t533 = 0.1400e4 / 0.9e1 * t100 * t89 * t491 + 0.3200e4 / 0.9e1 * t206 * t495 + 0.200e3 * t102 * t499 + 0.200e3 * t106 * t95 * t495 + 0.450e3 * t213 * t499 + 0.250e3 * t108 * t508 + 0.250e3 * t112 * t101 * t499 + 0.5000e4 / 0.9e1 * t220 * t508 + 0.2750e4 / 0.9e1 * t114 * t517 + 0.2750e4 / 0.9e1 * t118 * t107 * t508 + 0.6050e4 / 0.9e1 * t227 * t517 + 0.1100e4 / 0.3e1 * t120 / t103 / t85 * t411 * t415 + 0.50e2 * t170 * t427
  t535 = t86 * t411 * t415
  t544 = t92 * t411 * t415
  t553 = t98 * t411 * t415
  t572 = 0.100e3 / 0.3e1 * t72 * t535 + 0.100e3 / 0.3e1 * t76 * t65 * t427 + 0.800e3 / 0.9e1 * t177 * t535 + 0.500e3 / 0.9e1 * t78 * t544 + 0.500e3 / 0.9e1 * t82 * t71 * t535 + 0.1250e4 / 0.9e1 * t184 * t544 + 0.250e3 / 0.3e1 * t84 * t553 + 0.250e3 / 0.3e1 * t88 * t77 * t544 + 0.200e3 * t191 * t553 + 0.350e3 / 0.3e1 * t90 * t491 + 0.350e3 / 0.3e1 * t94 * t83 * t553 + 0.2450e4 / 0.9e1 * t199 * t491 + 0.1400e4 / 0.9e1 * t96 * t495 + 0.50e2 / 0.9e1 * t60 * t423
  t579 = -0.3e1 / 0.8e1 * t5 * t354 * t126 - t358 / 0.4e1 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t29 * t31 * params.csi_HF * t152 - 0.3e1 / 0.4e1 * t30 * t239 + t372 + 0.39416108509596690476000000000000000000000000000002e-2 * t376 - t379 / 0.4e1 + 0.28841419953224560707246635481030465333333333333337e-3 * t142 / t143 / t47 * t53 * t385 * t387 / t40 / t388 / t147 * t124 - 0.21678859680278179761800000000000000000000000000001e-1 * t142 * t146 * s0 / t41 / t388 * t124 + 0.11824832552879007142800000000000000000000000000001e-1 * t142 * t146 * t150 * t237 - 0.3e1 / 0.8e1 * t133 * t32 * t50 * (t451 + t487 + t533 + t572)
  t580 = f.my_piecewise3(t1, 0, t579)
  t581 = t249 ** 2
  t582 = 0.1e1 / t581
  t583 = t251 ** 2
  t587 = f.my_piecewise5(t14, 0, t10, 0, -t349)
  t591 = f.my_piecewise3(t248, 0, 0.4e1 / 0.9e1 * t582 * t583 + 0.4e1 / 0.3e1 * t249 * t587)
  t595 = t255 * t334
  t599 = t333 * t369 * t327 / 0.12e2
  t601 = f.my_piecewise3(t245, 0, -0.3e1 / 0.8e1 * t5 * t591 * t328 - t595 / 0.4e1 + t599)
  d11 = 0.2e1 * t243 + 0.2e1 * t338 + t6 * (t580 + t601)
  t604 = -t7 - t24
  t605 = f.my_piecewise5(t10, 0, t14, 0, t604)
  t608 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t605)
  t609 = t5 * t608
  t613 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t609 * t126 - t139)
  t615 = f.my_piecewise5(t14, 0, t10, 0, -t604)
  t618 = f.my_piecewise3(t248, 0, 0.4e1 / 0.3e1 * t249 * t615)
  t619 = t5 * t618
  t624 = t5 * t332 * t31 * params.csi_HF
  t625 = t264 ** 2
  t628 = 0.1e1 / t625 * t33 * t37
  t629 = t256 * r1
  t631 = 0.1e1 / t258 / t629
  t632 = s2 * t631
  t634 = t628 * t632 * t326
  t637 = t52 * tau1
  t641 = t279 * tau1
  t642 = t641 * t260
  t645 = t64 * t271
  t648 = t284 * tau1
  t649 = t648 * t260
  t652 = t70 * t276
  t655 = t289 * tau1
  t656 = t655 * t260
  t659 = t76 * t281
  t662 = t294 * tau1
  t663 = t662 * t260
  t666 = t82 * t286
  t669 = t299 * tau1
  t670 = t669 * t260
  t673 = t88 * t291
  t676 = 0.5e1 / 0.3e1 * t637 * t260 * t274 + 0.5e1 / 0.3e1 * t272 * t642 + 0.10e2 / 0.3e1 * t645 * t642 + 0.10e2 / 0.3e1 * t277 * t649 + 0.5e1 * t652 * t649 + 0.5e1 * t282 * t656 + 0.20e2 / 0.3e1 * t659 * t656 + 0.20e2 / 0.3e1 * t287 * t663 + 0.25e2 / 0.3e1 * t666 * t663 + 0.25e2 / 0.3e1 * t292 * t670 + 0.10e2 * t673 * t670
  t677 = t304 * tau1
  t678 = t677 * t260
  t681 = t94 * t296
  t684 = t309 * tau1
  t685 = t684 * t260
  t688 = t100 * t301
  t691 = t314 * tau1
  t692 = t691 * t260
  t695 = t106 * t306
  t698 = t319 * tau1
  t699 = t698 * t260
  t702 = t112 * t311
  t705 = t324 * tau1
  t706 = t705 * t260
  t709 = t118 * t316
  t713 = 0.1e1 / t308 / t288
  t714 = t713 * tau1
  t718 = 0.10e2 * t297 * t678 + 0.35e2 / 0.3e1 * t681 * t678 + 0.35e2 / 0.3e1 * t302 * t685 + 0.40e2 / 0.3e1 * t688 * t685 + 0.40e2 / 0.3e1 * t307 * t692 + 0.15e2 * t695 * t692 + 0.15e2 * t312 * t699 + 0.50e2 / 0.3e1 * t702 * t699 + 0.50e2 / 0.3e1 * t317 * t706 + 0.55e2 / 0.3e1 * t709 * t706 + 0.55e2 / 0.3e1 * t322 * t714 * t260
  t719 = t676 + t718
  t720 = t267 * t719
  t721 = t32 * t720
  t725 = f.my_piecewise3(t245, 0, -0.3e1 / 0.8e1 * t619 * t328 - t336 + 0.59124162764395035714000000000000000000000000000004e-2 * t624 * t634 - 0.3e1 / 0.8e1 * t333 * t721)
  t729 = 0.2e1 * t347
  t730 = f.my_piecewise5(t10, 0, t14, 0, t729)
  t734 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t341 * t605 * t26 + 0.4e1 / 0.3e1 * t21 * t730)
  t738 = t609 * t137
  t751 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t734 * t126 - t738 / 0.8e1 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t608 * t31 * params.csi_HF * t152 - 0.3e1 / 0.8e1 * t609 * t239 - t358 / 0.8e1 + t372 + 0.19708054254798345238000000000000000000000000000001e-2 * t376 - t379 / 0.8e1)
  t755 = f.my_piecewise5(t14, 0, t10, 0, -t729)
  t759 = f.my_piecewise3(t248, 0, 0.4e1 / 0.9e1 * t582 * t615 * t251 + 0.4e1 / 0.3e1 * t249 * t755)
  t763 = t619 * t334
  t774 = t5 * t332 * t135 * params.csi_HF * t634
  t779 = t333 * t136 * t720
  t782 = f.my_piecewise3(t245, 0, -0.3e1 / 0.8e1 * t5 * t759 * t328 - t763 / 0.8e1 - t595 / 0.8e1 + t599 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t254 * t31 * params.csi_HF * t634 + 0.19708054254798345238000000000000000000000000000001e-2 * t774 - 0.3e1 / 0.8e1 * t255 * t721 - t779 / 0.8e1)
  d12 = t243 + t338 + t613 + t725 + t6 * (t751 + t782)
  t787 = t605 ** 2
  t791 = 0.2e1 * t23 + 0.2e1 * t347
  t792 = f.my_piecewise5(t10, 0, t14, 0, t791)
  t796 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t341 * t787 + 0.4e1 / 0.3e1 * t21 * t792)
  t802 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t796 * t126 - t738 / 0.4e1 + t372)
  t803 = t615 ** 2
  t807 = f.my_piecewise5(t14, 0, t10, 0, -t791)
  t811 = f.my_piecewise3(t248, 0, 0.4e1 / 0.9e1 * t582 * t803 + 0.4e1 / 0.3e1 * t249 * t807)
  t829 = s2 ** 2
  t830 = t256 ** 2
  t853 = tau1 ** 2
  t857 = 0.1e1 / t257 / t830 / r1
  t858 = t857 * t279
  t865 = t319 * t853 * t857
  t869 = t324 * t853 * t857
  t878 = t713 * t853 * t857
  t893 = t294 * t853 * t857
  t898 = t289 * t853 * t857
  t901 = -0.40e2 / 0.9e1 * t637 * t631 * t274 + 0.50e2 / 0.9e1 * t52 * t853 * t858 + 0.50e2 / 0.9e1 * t64 * t853 * t858 + 0.450e3 * t695 * t865 + 0.250e3 * t312 * t869 + 0.250e3 * t112 * t306 * t865 + 0.5000e4 / 0.9e1 * t702 * t869 + 0.2750e4 / 0.9e1 * t317 * t878 + 0.2750e4 / 0.9e1 * t118 * t311 * t869 + 0.6050e4 / 0.9e1 * t709 * t878 + 0.1100e4 / 0.3e1 * t322 / t308 / t293 * t853 * t857 + 0.100e3 / 0.3e1 * t282 * t893 + 0.100e3 / 0.3e1 * t76 * t276 * t898
  t905 = t299 * t853 * t857
  t914 = t304 * t853 * t857
  t923 = t309 * t853 * t857
  t932 = t314 * t853 * t857
  t936 = t284 * t853 * t857
  t943 = 0.800e3 / 0.9e1 * t659 * t893 + 0.500e3 / 0.9e1 * t287 * t905 + 0.500e3 / 0.9e1 * t82 * t281 * t893 + 0.1250e4 / 0.9e1 * t666 * t905 + 0.250e3 / 0.3e1 * t292 * t914 + 0.250e3 / 0.3e1 * t88 * t286 * t905 + 0.200e3 * t673 * t914 + 0.350e3 / 0.3e1 * t297 * t923 + 0.350e3 / 0.3e1 * t94 * t291 * t914 + 0.2450e4 / 0.9e1 * t681 * t923 + 0.1400e4 / 0.9e1 * t302 * t932 + 0.50e2 / 0.9e1 * t272 * t936 + 0.200e3 / 0.9e1 * t645 * t936 + 0.50e2 / 0.3e1 * t277 * t898
  t950 = t684 * t631
  t953 = t691 * t631
  t958 = t698 * t631
  t963 = t705 * t631
  t971 = t641 * t631
  t976 = t648 * t631
  t979 = 0.50e2 / 0.3e1 * t70 * t271 * t936 + 0.50e2 * t652 * t898 - 0.320e3 / 0.9e1 * t688 * t950 - 0.320e3 / 0.9e1 * t307 * t953 - 0.40e2 * t695 * t953 - 0.40e2 * t312 * t958 - 0.400e3 / 0.9e1 * t702 * t958 - 0.400e3 / 0.9e1 * t317 * t963 - 0.440e3 / 0.9e1 * t709 * t963 - 0.440e3 / 0.9e1 * t322 * t714 * t631 - 0.40e2 / 0.9e1 * t272 * t971 - 0.80e2 / 0.9e1 * t645 * t971 - 0.80e2 / 0.9e1 * t277 * t976
  t982 = t655 * t631
  t987 = t662 * t631
  t992 = t669 * t631
  t997 = t677 * t631
  t1014 = -0.40e2 / 0.3e1 * t652 * t976 - 0.40e2 / 0.3e1 * t282 * t982 - 0.160e3 / 0.9e1 * t659 * t982 - 0.160e3 / 0.9e1 * t287 * t987 - 0.200e3 / 0.9e1 * t666 * t987 - 0.200e3 / 0.9e1 * t292 * t992 - 0.80e2 / 0.3e1 * t673 * t992 - 0.80e2 / 0.3e1 * t297 * t997 - 0.280e3 / 0.9e1 * t681 * t997 - 0.280e3 / 0.9e1 * t302 * t950 + 0.1400e4 / 0.9e1 * t100 * t296 * t923 + 0.3200e4 / 0.9e1 * t688 * t932 + 0.200e3 * t307 * t865 + 0.200e3 * t106 * t301 * t932
  t1021 = -0.3e1 / 0.8e1 * t5 * t811 * t328 - t763 / 0.4e1 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t618 * t31 * params.csi_HF * t634 - 0.3e1 / 0.4e1 * t619 * t721 + t599 + 0.39416108509596690476000000000000000000000000000002e-2 * t774 - t779 / 0.4e1 + 0.28841419953224560707246635481030465333333333333337e-3 * t624 / t625 / t264 * t53 * t385 * t829 / t257 / t830 / t629 * t326 - 0.21678859680278179761800000000000000000000000000001e-1 * t624 * t628 * s2 / t258 / t830 * t326 + 0.11824832552879007142800000000000000000000000000001e-1 * t624 * t628 * t632 * t719 - 0.3e1 / 0.8e1 * t333 * t32 * t267 * (t901 + t943 + t979 + t1014)
  t1022 = f.my_piecewise3(t245, 0, t1021)
  d22 = 0.2e1 * t613 + 0.2e1 * t725 + t6 * (t802 + t1022)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t5 * t41
  t43 = t6 ** (0.1e1 / 0.3e1)
  t44 = t43 * params.csi_HF
  t45 = 6 ** (0.1e1 / 0.3e1)
  t46 = jnp.pi ** 2
  t47 = t46 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t50 = t45 * t49
  t51 = r0 ** 2
  t52 = r0 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / t51
  t59 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t50 * s0 * t55
  t62 = 0.18040e1 - 0.64641600e0 / t59
  t63 = params.a[0]
  t64 = params.a[1]
  t65 = t45 ** 2
  t67 = 0.3e1 / 0.10e2 * t65 * t48
  t70 = tau0 / t53 / r0
  t71 = t67 - t70
  t72 = t64 * t71
  t73 = t67 + t70
  t74 = 0.1e1 / t73
  t76 = params.a[2]
  t77 = t71 ** 2
  t78 = t76 * t77
  t79 = t73 ** 2
  t80 = 0.1e1 / t79
  t82 = params.a[3]
  t83 = t77 * t71
  t84 = t82 * t83
  t85 = t79 * t73
  t86 = 0.1e1 / t85
  t88 = params.a[4]
  t89 = t77 ** 2
  t90 = t88 * t89
  t91 = t79 ** 2
  t92 = 0.1e1 / t91
  t94 = params.a[5]
  t95 = t89 * t71
  t96 = t94 * t95
  t97 = t91 * t73
  t98 = 0.1e1 / t97
  t100 = params.a[6]
  t101 = t89 * t77
  t102 = t100 * t101
  t103 = t91 * t79
  t104 = 0.1e1 / t103
  t106 = params.a[7]
  t107 = t89 * t83
  t108 = t106 * t107
  t110 = 0.1e1 / t91 / t85
  t112 = params.a[8]
  t113 = t89 ** 2
  t114 = t112 * t113
  t115 = t91 ** 2
  t116 = 0.1e1 / t115
  t118 = params.a[9]
  t119 = t113 * t71
  t120 = t118 * t119
  t122 = 0.1e1 / t115 / t73
  t124 = params.a[10]
  t125 = t113 * t77
  t126 = t124 * t125
  t128 = 0.1e1 / t115 / t79
  t130 = params.a[11]
  t132 = t130 * t113 * t83
  t134 = 0.1e1 / t115 / t85
  t136 = t102 * t104 + t108 * t110 + t114 * t116 + t120 * t122 + t126 * t128 + t132 * t134 + t72 * t74 + t78 * t80 + t84 * t86 + t90 * t92 + t96 * t98 + t63
  t137 = t62 * t136
  t138 = t44 * t137
  t143 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t144 = t5 * t143
  t145 = t43 ** 2
  t146 = 0.1e1 / t145
  t147 = t146 * params.csi_HF
  t148 = t147 * t137
  t153 = t5 * t143 * t43 * params.csi_HF
  t154 = t59 ** 2
  t157 = 0.1e1 / t154 * t45 * t49
  t158 = t51 * r0
  t160 = 0.1e1 / t53 / t158
  t161 = s0 * t160
  t163 = t157 * t161 * t136
  t166 = t64 * tau0
  t170 = t80 * tau0
  t171 = t170 * t55
  t174 = t76 * t71
  t177 = t86 * tau0
  t178 = t177 * t55
  t181 = t82 * t77
  t184 = t92 * tau0
  t185 = t184 * t55
  t188 = t88 * t83
  t191 = t98 * tau0
  t192 = t191 * t55
  t195 = t94 * t89
  t198 = t104 * tau0
  t199 = t198 * t55
  t202 = t100 * t95
  t205 = 0.5e1 / 0.3e1 * t166 * t55 * t74 + 0.5e1 / 0.3e1 * t72 * t171 + 0.10e2 / 0.3e1 * t174 * t171 + 0.10e2 / 0.3e1 * t78 * t178 + 0.5e1 * t181 * t178 + 0.5e1 * t84 * t185 + 0.20e2 / 0.3e1 * t188 * t185 + 0.20e2 / 0.3e1 * t90 * t192 + 0.25e2 / 0.3e1 * t195 * t192 + 0.25e2 / 0.3e1 * t96 * t199 + 0.10e2 * t202 * t199
  t206 = t110 * tau0
  t207 = t206 * t55
  t210 = t106 * t101
  t213 = t116 * tau0
  t214 = t213 * t55
  t217 = t112 * t107
  t220 = t122 * tau0
  t221 = t220 * t55
  t224 = t118 * t113
  t227 = t128 * tau0
  t228 = t227 * t55
  t231 = t124 * t119
  t234 = t134 * tau0
  t235 = t234 * t55
  t238 = t130 * t125
  t242 = 0.1e1 / t115 / t91
  t243 = t242 * tau0
  t247 = 0.10e2 * t102 * t207 + 0.35e2 / 0.3e1 * t210 * t207 + 0.35e2 / 0.3e1 * t108 * t214 + 0.40e2 / 0.3e1 * t217 * t214 + 0.40e2 / 0.3e1 * t114 * t221 + 0.15e2 * t224 * t221 + 0.15e2 * t120 * t228 + 0.50e2 / 0.3e1 * t231 * t228 + 0.50e2 / 0.3e1 * t126 * t235 + 0.55e2 / 0.3e1 * t238 * t235 + 0.55e2 / 0.3e1 * t132 * t243 * t55
  t248 = t205 + t247
  t249 = t62 * t248
  t250 = t44 * t249
  t253 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t254 = t253 * f.p.zeta_threshold
  t256 = f.my_piecewise3(t20, t254, t21 * t19)
  t257 = t5 * t256
  t259 = 0.1e1 / t145 / t6
  t260 = t259 * params.csi_HF
  t261 = t260 * t137
  t266 = t5 * t256 * t146 * params.csi_HF
  t269 = t147 * t249
  t272 = t256 * t43
  t274 = t5 * t272 * params.csi_HF
  t280 = 0.1e1 / t154 / t59 * t65 / t47 / t46
  t281 = s0 ** 2
  t282 = t51 ** 2
  t286 = t281 / t52 / t282 / t158
  t288 = t280 * t286 * t136
  t292 = 0.1e1 / t53 / t282
  t293 = s0 * t292
  t295 = t157 * t293 * t136
  t299 = t157 * t161 * t248
  t305 = tau0 ** 2
  t306 = t64 * t305
  t307 = t282 * r0
  t309 = 0.1e1 / t52 / t307
  t310 = t309 * t80
  t313 = t76 * t305
  t316 = t242 * t305
  t317 = t316 * t309
  t321 = 0.1e1 / t115 / t97
  t322 = t321 * t305
  t326 = t98 * t305
  t327 = t326 * t309
  t330 = t104 * t305
  t331 = t330 * t309
  t334 = t94 * t83
  t339 = t110 * t305
  t340 = t339 * t309
  t343 = t100 * t89
  t348 = t116 * t305
  t349 = t348 * t309
  t352 = -0.40e2 / 0.9e1 * t166 * t160 * t74 + 0.50e2 / 0.9e1 * t306 * t310 + 0.50e2 / 0.9e1 * t313 * t310 + 0.6050e4 / 0.9e1 * t238 * t317 + 0.1100e4 / 0.3e1 * t132 * t322 * t309 + 0.800e3 / 0.9e1 * t188 * t327 + 0.500e3 / 0.9e1 * t90 * t331 + 0.500e3 / 0.9e1 * t334 * t327 + 0.1250e4 / 0.9e1 * t195 * t331 + 0.250e3 / 0.3e1 * t96 * t340 + 0.250e3 / 0.3e1 * t343 * t331 + 0.200e3 * t202 * t340 + 0.350e3 / 0.3e1 * t102 * t349
  t353 = t106 * t95
  t358 = t122 * t305
  t359 = t358 * t309
  t362 = t86 * t305
  t363 = t362 * t309
  t368 = t92 * t305
  t369 = t368 * t309
  t372 = t82 * t71
  t375 = t170 * t160
  t380 = t177 * t160
  t385 = t184 * t160
  t390 = t191 * t160
  t393 = 0.350e3 / 0.3e1 * t353 * t340 + 0.2450e4 / 0.9e1 * t210 * t349 + 0.1400e4 / 0.9e1 * t108 * t359 + 0.50e2 / 0.9e1 * t72 * t363 + 0.200e3 / 0.9e1 * t174 * t363 + 0.50e2 / 0.3e1 * t78 * t369 + 0.50e2 / 0.3e1 * t372 * t363 - 0.40e2 / 0.9e1 * t72 * t375 - 0.80e2 / 0.9e1 * t174 * t375 - 0.80e2 / 0.9e1 * t78 * t380 - 0.40e2 / 0.3e1 * t181 * t380 - 0.40e2 / 0.3e1 * t84 * t385 - 0.160e3 / 0.9e1 * t188 * t385 - 0.160e3 / 0.9e1 * t90 * t390
  t397 = t198 * t160
  t402 = t206 * t160
  t407 = t213 * t160
  t412 = t220 * t160
  t417 = t227 * t160
  t422 = t234 * t160
  t427 = -0.200e3 / 0.9e1 * t195 * t390 - 0.200e3 / 0.9e1 * t96 * t397 - 0.80e2 / 0.3e1 * t202 * t397 - 0.80e2 / 0.3e1 * t102 * t402 - 0.280e3 / 0.9e1 * t210 * t402 - 0.280e3 / 0.9e1 * t108 * t407 - 0.320e3 / 0.9e1 * t217 * t407 - 0.320e3 / 0.9e1 * t114 * t412 - 0.40e2 * t224 * t412 - 0.40e2 * t120 * t417 - 0.400e3 / 0.9e1 * t231 * t417 - 0.400e3 / 0.9e1 * t126 * t422 - 0.440e3 / 0.9e1 * t238 * t422
  t431 = t112 * t101
  t436 = t128 * t305
  t437 = t436 * t309
  t440 = t118 * t107
  t445 = t134 * t305
  t446 = t445 * t309
  t449 = t124 * t113
  t456 = t130 * t119
  t463 = t88 * t77
  t466 = -0.440e3 / 0.9e1 * t132 * t243 * t160 + 0.1400e4 / 0.9e1 * t431 * t349 + 0.3200e4 / 0.9e1 * t217 * t359 + 0.200e3 * t114 * t437 + 0.200e3 * t440 * t359 + 0.450e3 * t224 * t437 + 0.250e3 * t120 * t446 + 0.250e3 * t449 * t437 + 0.5000e4 / 0.9e1 * t231 * t446 + 0.2750e4 / 0.9e1 * t126 * t317 + 0.2750e4 / 0.9e1 * t456 * t446 + 0.50e2 * t181 * t369 + 0.100e3 / 0.3e1 * t84 * t327 + 0.100e3 / 0.3e1 * t463 * t369
  t468 = t352 + t393 + t427 + t466
  t469 = t62 * t468
  t470 = t44 * t469
  t473 = -0.3e1 / 0.8e1 * t42 * t138 - t144 * t148 / 0.4e1 + 0.11824832552879007142800000000000000000000000000001e-1 * t153 * t163 - 0.3e1 / 0.4e1 * t144 * t250 + t257 * t261 / 0.12e2 + 0.39416108509596690476000000000000000000000000000002e-2 * t266 * t163 - t257 * t269 / 0.4e1 + 0.28841419953224560707246635481030465333333333333337e-3 * t274 * t288 - 0.21678859680278179761800000000000000000000000000001e-1 * t274 * t295 + 0.11824832552879007142800000000000000000000000000001e-1 * t274 * t299 - 0.3e1 / 0.8e1 * t257 * t470
  t474 = f.my_piecewise3(t1, 0, t473)
  t476 = r1 <= f.p.dens_threshold
  t477 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t478 = 0.1e1 + t477
  t479 = t478 <= f.p.zeta_threshold
  t480 = t478 ** (0.1e1 / 0.3e1)
  t481 = t480 ** 2
  t482 = 0.1e1 / t481
  t484 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t485 = t484 ** 2
  t489 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t493 = f.my_piecewise3(t479, 0, 0.4e1 / 0.9e1 * t482 * t485 + 0.4e1 / 0.3e1 * t480 * t489)
  t494 = t5 * t493
  t495 = r1 ** 2
  t496 = r1 ** (0.1e1 / 0.3e1)
  t497 = t496 ** 2
  t509 = tau1 / t497 / r1
  t510 = t67 - t509
  t512 = t67 + t509
  t515 = t510 ** 2
  t517 = t512 ** 2
  t520 = t515 * t510
  t522 = t517 * t512
  t525 = t515 ** 2
  t527 = t517 ** 2
  t545 = t525 ** 2
  t547 = t527 ** 2
  t565 = t63 + t64 * t510 / t512 + t76 * t515 / t517 + t82 * t520 / t522 + t88 * t525 / t527 + t94 * t525 * t510 / t527 / t512 + t100 * t525 * t515 / t527 / t517 + t106 * t525 * t520 / t527 / t522 + t112 * t545 / t547 + t118 * t545 * t510 / t547 / t512 + t124 * t545 * t515 / t547 / t517 + t130 * t545 * t520 / t547 / t522
  t566 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t50 * s2 / t497 / t495)) * t565
  t567 = t44 * t566
  t572 = f.my_piecewise3(t479, 0, 0.4e1 / 0.3e1 * t480 * t484)
  t573 = t5 * t572
  t574 = t147 * t566
  t578 = f.my_piecewise3(t479, t254, t480 * t478)
  t579 = t5 * t578
  t580 = t260 * t566
  t584 = f.my_piecewise3(t476, 0, -0.3e1 / 0.8e1 * t494 * t567 - t573 * t574 / 0.4e1 + t579 * t580 / 0.12e2)
  t625 = -0.65036579040834539285400000000000000000000000000005e-1 * t153 * t295 - 0.21678859680278179761800000000000000000000000000001e-1 * t266 * t295 - 0.65036579040834539285400000000000000000000000000005e-1 * t274 * t157 * t293 * t248 + 0.17737248829318510714200000000000000000000000000001e-1 * t274 * t157 * t161 * t468 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t143 * t146 * params.csi_HF * t163 + 0.35474497658637021428400000000000000000000000000003e-1 * t153 * t299 + 0.86524259859673682121739906443091396000000000000011e-3 * t153 * t288 - 0.39416108509596690476000000000000000000000000000003e-2 * t5 * t256 * t259 * params.csi_HF * t163 + 0.11824832552879007142800000000000000000000000000001e-1 * t266 * t299 + 0.28841419953224560707246635481030465333333333333336e-3 * t266 * t288 + 0.86524259859673682121739906443091396000000000000011e-3 * t274 * t280 * t286 * t248 + 0.17737248829318510714200000000000000000000000000001e-1 * t5 * t41 * t43 * params.csi_HF * t163
  t626 = t282 ** 2
  t652 = t24 ** 2
  t656 = 0.6e1 * t33 - 0.6e1 * t16 / t652
  t657 = f.my_piecewise5(t10, 0, t14, 0, t656)
  t661 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t657)
  t673 = 0.1e1 / t145 / t24 * params.csi_HF
  t681 = t305 * tau0
  t683 = 0.1e1 / t626
  t684 = t683 * t86
  t695 = 0.1e1 / t52 / t282 / t51
  t696 = t695 * t80
  t704 = t227 * t292
  t707 = t234 * t292
  t715 = t198 * t292
  t718 = 0.250e3 / 0.9e1 * t64 * t681 * t684 + 0.500e3 / 0.9e1 * t76 * t681 * t684 + 0.250e3 / 0.9e1 * t82 * t681 * t684 - 0.400e3 / 0.9e1 * t306 * t696 - 0.400e3 / 0.9e1 * t313 * t696 + 0.440e3 / 0.27e2 * t166 * t292 * t74 + 0.4400e4 / 0.27e2 * t231 * t704 + 0.4400e4 / 0.27e2 * t126 * t707 + 0.4840e4 / 0.27e2 * t238 * t707 + 0.4840e4 / 0.27e2 * t132 * t243 * t292 + 0.880e3 / 0.9e1 * t202 * t715
  t719 = t206 * t292
  t724 = t213 * t292
  t729 = t220 * t292
  t735 = t128 * t681 * t683
  t739 = t92 * t681 * t683
  t742 = t445 * t695
  t746 = t321 * t681 * t683
  t757 = 0.880e3 / 0.9e1 * t102 * t719 + 0.3080e4 / 0.27e2 * t210 * t719 + 0.3080e4 / 0.27e2 * t108 * t724 + 0.3520e4 / 0.27e2 * t217 * t724 + 0.3520e4 / 0.27e2 * t114 * t729 + 0.440e3 / 0.3e1 * t224 * t729 + 0.7000e4 / 0.3e1 * t108 * t735 + 0.250e3 / 0.9e1 * t72 * t739 - 0.22000e5 / 0.9e1 * t456 * t742 + 0.60500e5 / 0.3e1 * t238 * t746 + 0.71500e5 / 0.9e1 * t132 / t115 / t103 * t681 * t683 + 0.250e3 * t372 * t739
  t760 = t98 * t681 * t683
  t763 = t348 * t695
  t766 = t358 * t695
  t769 = t436 * t695
  t782 = t316 * t695
  t790 = 0.500e3 * t181 * t760 - 0.11200e5 / 0.9e1 * t431 * t763 - 0.25600e5 / 0.9e1 * t217 * t766 - 0.1600e4 * t114 * t769 - 0.1600e4 * t440 * t766 - 0.3600e4 * t224 * t769 - 0.2000e4 * t120 * t742 - 0.2000e4 * t449 * t769 - 0.40000e5 / 0.9e1 * t231 * t742 - 0.22000e5 / 0.9e1 * t126 * t782 - 0.48400e5 / 0.9e1 * t238 * t782 - 0.8800e4 / 0.3e1 * t132 * t322 * t695
  t793 = t116 * t681 * t683
  t797 = t122 * t681 * t683
  t802 = t330 * t695
  t805 = t339 * t695
  t816 = t191 * t292
  t821 = t362 * t695
  t824 = 0.14000e5 / 0.9e1 * t112 * t95 * t793 + 0.56000e5 / 0.9e1 * t431 * t797 + 0.8000e4 * t217 * t735 - 0.2000e4 / 0.3e1 * t343 * t802 - 0.1600e4 * t202 * t805 - 0.2800e4 / 0.3e1 * t102 * t763 - 0.2800e4 / 0.3e1 * t353 * t805 - 0.19600e5 / 0.9e1 * t210 * t763 - 0.11200e5 / 0.9e1 * t108 * t766 + 0.2200e4 / 0.27e2 * t195 * t816 + 0.2200e4 / 0.27e2 * t96 * t715 - 0.400e3 / 0.9e1 * t72 * t821
  t829 = t368 * t695
  t834 = t170 * t292
  t839 = t177 * t292
  t844 = t184 * t292
  t851 = t326 * t695
  t856 = -0.1600e4 / 0.9e1 * t174 * t821 - 0.400e3 / 0.3e1 * t78 * t829 - 0.400e3 / 0.3e1 * t372 * t821 + 0.440e3 / 0.27e2 * t72 * t834 + 0.880e3 / 0.27e2 * t174 * t834 + 0.880e3 / 0.27e2 * t78 * t839 + 0.440e3 / 0.9e1 * t181 * t839 + 0.440e3 / 0.9e1 * t84 * t844 + 0.1760e4 / 0.27e2 * t188 * t844 + 0.1760e4 / 0.27e2 * t90 * t816 - 0.6400e4 / 0.9e1 * t188 * t851 - 0.4000e4 / 0.9e1 * t90 * t802
  t876 = t104 * t681 * t683
  t884 = -0.4000e4 / 0.9e1 * t334 * t851 - 0.10000e5 / 0.9e1 * t195 * t802 - 0.2000e4 / 0.3e1 * t96 * t805 - 0.400e3 * t181 * t829 - 0.800e3 / 0.3e1 * t84 * t851 - 0.800e3 / 0.3e1 * t463 * t829 + 0.440e3 / 0.3e1 * t120 * t704 + 0.500e3 / 0.3e1 * t174 * t739 + 0.1000e4 / 0.9e1 * t78 * t760 + 0.2500e4 / 0.9e1 * t84 * t876 + 0.1000e4 / 0.9e1 * t88 * t71 * t739 + 0.2000e4 / 0.3e1 * t463 * t760
  t889 = t110 * t681 * t683
  t915 = 0.10000e5 / 0.9e1 * t188 * t876 + 0.5000e4 / 0.9e1 * t90 * t889 + 0.2500e4 / 0.9e1 * t94 * t77 * t760 + 0.12500e5 / 0.9e1 * t334 * t876 + 0.6250e4 / 0.3e1 * t195 * t889 + 0.8750e4 / 0.9e1 * t96 * t793 + 0.5000e4 / 0.9e1 * t100 * t83 * t876 + 0.2500e4 * t343 * t889 + 0.3500e4 * t202 * t793 + 0.14000e5 / 0.9e1 * t102 * t797 + 0.8750e4 / 0.9e1 * t106 * t89 * t889 + 0.12250e5 / 0.3e1 * t353 * t793
  t919 = t134 * t681 * t683
  t930 = t242 * t681 * t683
  t947 = 0.49000e5 / 0.9e1 * t210 * t797 + 0.10000e5 / 0.3e1 * t114 * t919 + 0.7000e4 / 0.3e1 * t118 * t101 * t797 + 0.9000e4 * t440 * t735 + 0.11250e5 * t224 * t919 + 0.13750e5 / 0.3e1 * t120 * t930 + 0.10000e5 / 0.3e1 * t124 * t107 * t735 + 0.12500e5 * t449 * t919 + 0.137500e6 / 0.9e1 * t231 * t930 + 0.55000e5 / 0.9e1 * t126 * t746 + 0.13750e5 / 0.3e1 * t130 * t113 * t919 + 0.151250e6 / 0.9e1 * t456 * t930
  t958 = t46 ** 2
  t963 = t154 ** 2
  t974 = -0.31725561948547016777971299029133511866666666666670e-2 * t274 * t280 * t281 / t52 / t626 * t136 + 0.10116801184129817222173333333333333333333333333334e0 * t274 * t157 * s0 / t53 / t307 * t136 - 0.3e1 / 0.8e1 * t257 * t147 * t469 - 0.3e1 / 0.8e1 * t5 * t661 * t138 - 0.9e1 / 0.8e1 * t42 * t250 - 0.3e1 / 0.4e1 * t144 * t269 - 0.9e1 / 0.8e1 * t144 * t470 - 0.5e1 / 0.36e2 * t257 * t673 * t137 - 0.3e1 / 0.8e1 * t42 * t148 + t144 * t261 / 0.4e1 - 0.3e1 / 0.8e1 * t257 * t44 * t62 * (t718 + t757 + t790 + t824 + t856 + t884 + t915 + t947) + t257 * t260 * t249 / 0.4e1 + 0.12662247031044178991769844370781511743016307403250e-3 * t2 / t3 / t958 * t272 * params.csi_HF / t963 * t281 * s0 / t626 / t158 * t136
  t976 = f.my_piecewise3(t1, 0, t625 + t974)
  t986 = f.my_piecewise5(t14, 0, t10, 0, -t656)
  t990 = f.my_piecewise3(t479, 0, -0.8e1 / 0.27e2 / t481 / t478 * t485 * t484 + 0.4e1 / 0.3e1 * t482 * t484 * t489 + 0.4e1 / 0.3e1 * t480 * t986)
  t1002 = f.my_piecewise3(t476, 0, -0.3e1 / 0.8e1 * t5 * t990 * t567 - 0.3e1 / 0.8e1 * t494 * t574 + t573 * t580 / 0.4e1 - 0.5e1 / 0.36e2 * t579 * t673 * t566)
  d111 = 0.3e1 * t474 + 0.3e1 * t584 + t6 * (t976 + t1002)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t25 * t28
  t31 = t5 * t29 * params.csi_HF
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t46 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t37 * s0 * t42
  t47 = t46 ** 2
  t50 = 0.1e1 / t47 * t32 * t36
  t51 = t38 ** 2
  t53 = 0.1e1 / t40 / t51
  t54 = s0 * t53
  t55 = params.a[0]
  t56 = params.a[1]
  t57 = t32 ** 2
  t59 = 0.3e1 / 0.10e2 * t57 * t35
  t62 = tau0 / t40 / r0
  t63 = t59 - t62
  t64 = t56 * t63
  t65 = t59 + t62
  t66 = 0.1e1 / t65
  t68 = params.a[2]
  t69 = t63 ** 2
  t70 = t68 * t69
  t71 = t65 ** 2
  t72 = 0.1e1 / t71
  t74 = params.a[3]
  t75 = t69 * t63
  t76 = t74 * t75
  t77 = t71 * t65
  t78 = 0.1e1 / t77
  t80 = params.a[4]
  t81 = t69 ** 2
  t82 = t80 * t81
  t83 = t71 ** 2
  t84 = 0.1e1 / t83
  t86 = params.a[5]
  t87 = t81 * t63
  t88 = t86 * t87
  t89 = t83 * t65
  t90 = 0.1e1 / t89
  t92 = params.a[6]
  t93 = t81 * t69
  t94 = t92 * t93
  t95 = t83 * t71
  t96 = 0.1e1 / t95
  t98 = params.a[7]
  t99 = t81 * t75
  t100 = t98 * t99
  t101 = t83 * t77
  t102 = 0.1e1 / t101
  t104 = params.a[8]
  t105 = t81 ** 2
  t106 = t104 * t105
  t107 = t83 ** 2
  t108 = 0.1e1 / t107
  t110 = params.a[9]
  t111 = t105 * t63
  t112 = t110 * t111
  t114 = 0.1e1 / t107 / t65
  t116 = params.a[10]
  t117 = t105 * t69
  t118 = t116 * t117
  t120 = 0.1e1 / t107 / t71
  t122 = params.a[11]
  t124 = t122 * t105 * t75
  t126 = 0.1e1 / t107 / t77
  t128 = t100 * t102 + t106 * t108 + t112 * t114 + t118 * t120 + t124 * t126 + t64 * t66 + t70 * t72 + t76 * t78 + t82 * t84 + t88 * t90 + t94 * t96 + t55
  t130 = t50 * t54 * t128
  t133 = t25 * t26
  t134 = t133 * params.csi_HF
  t135 = t5 * t134
  t136 = t56 * tau0
  t140 = t72 * tau0
  t141 = t140 * t42
  t144 = t68 * t63
  t147 = t78 * tau0
  t148 = t147 * t42
  t151 = t74 * t69
  t154 = t84 * tau0
  t155 = t154 * t42
  t158 = t80 * t75
  t161 = t90 * tau0
  t162 = t161 * t42
  t165 = t86 * t81
  t168 = t96 * tau0
  t169 = t168 * t42
  t172 = t92 * t87
  t175 = 0.5e1 / 0.3e1 * t136 * t42 * t66 + 0.5e1 / 0.3e1 * t64 * t141 + 0.10e2 / 0.3e1 * t144 * t141 + 0.10e2 / 0.3e1 * t70 * t148 + 0.5e1 * t151 * t148 + 0.5e1 * t76 * t155 + 0.20e2 / 0.3e1 * t158 * t155 + 0.20e2 / 0.3e1 * t82 * t162 + 0.25e2 / 0.3e1 * t165 * t162 + 0.25e2 / 0.3e1 * t88 * t169 + 0.10e2 * t172 * t169
  t176 = t102 * tau0
  t177 = t176 * t42
  t180 = t98 * t93
  t183 = t108 * tau0
  t184 = t183 * t42
  t187 = t104 * t99
  t190 = t114 * tau0
  t191 = t190 * t42
  t194 = t110 * t105
  t197 = t120 * tau0
  t198 = t197 * t42
  t201 = t116 * t111
  t204 = t126 * tau0
  t205 = t204 * t42
  t208 = t122 * t117
  t212 = 0.1e1 / t107 / t83
  t213 = t212 * tau0
  t217 = 0.10e2 * t94 * t177 + 0.35e2 / 0.3e1 * t180 * t177 + 0.35e2 / 0.3e1 * t100 * t184 + 0.40e2 / 0.3e1 * t187 * t184 + 0.40e2 / 0.3e1 * t106 * t191 + 0.15e2 * t194 * t191 + 0.15e2 * t112 * t198 + 0.50e2 / 0.3e1 * t201 * t198 + 0.50e2 / 0.3e1 * t118 * t205 + 0.55e2 / 0.3e1 * t208 * t205 + 0.55e2 / 0.3e1 * t124 * t213 * t42
  t218 = t175 + t217
  t220 = t50 * t54 * t218
  t223 = t38 * r0
  t225 = 0.1e1 / t40 / t223
  t226 = s0 * t225
  t230 = tau0 ** 2
  t231 = t56 * t230
  t232 = t51 * r0
  t234 = 0.1e1 / t39 / t232
  t235 = t234 * t72
  t238 = t68 * t230
  t241 = t102 * t230
  t242 = t241 * t234
  t245 = t92 * t81
  t246 = t96 * t230
  t247 = t246 * t234
  t252 = t108 * t230
  t253 = t252 * t234
  t256 = t98 * t87
  t261 = t114 * t230
  t262 = t261 * t234
  t265 = t78 * t230
  t266 = t265 * t234
  t271 = t84 * t230
  t272 = t271 * t234
  t275 = -0.40e2 / 0.9e1 * t136 * t225 * t66 + 0.50e2 / 0.9e1 * t231 * t235 + 0.50e2 / 0.9e1 * t238 * t235 + 0.250e3 / 0.3e1 * t88 * t242 + 0.250e3 / 0.3e1 * t245 * t247 + 0.200e3 * t172 * t242 + 0.350e3 / 0.3e1 * t94 * t253 + 0.350e3 / 0.3e1 * t256 * t242 + 0.2450e4 / 0.9e1 * t180 * t253 + 0.1400e4 / 0.9e1 * t100 * t262 + 0.50e2 / 0.9e1 * t64 * t266 + 0.200e3 / 0.9e1 * t144 * t266 + 0.50e2 / 0.3e1 * t70 * t272
  t276 = t74 * t63
  t279 = t140 * t225
  t284 = t147 * t225
  t289 = t154 * t225
  t294 = t161 * t225
  t299 = t168 * t225
  t304 = t176 * t225
  t309 = t183 * t225
  t312 = 0.50e2 / 0.3e1 * t276 * t266 - 0.40e2 / 0.9e1 * t64 * t279 - 0.80e2 / 0.9e1 * t144 * t279 - 0.80e2 / 0.9e1 * t70 * t284 - 0.40e2 / 0.3e1 * t151 * t284 - 0.40e2 / 0.3e1 * t76 * t289 - 0.160e3 / 0.9e1 * t158 * t289 - 0.160e3 / 0.9e1 * t82 * t294 - 0.200e3 / 0.9e1 * t165 * t294 - 0.200e3 / 0.9e1 * t88 * t299 - 0.80e2 / 0.3e1 * t172 * t299 - 0.80e2 / 0.3e1 * t94 * t304 - 0.280e3 / 0.9e1 * t180 * t304 - 0.280e3 / 0.9e1 * t100 * t309
  t316 = t190 * t225
  t321 = t197 * t225
  t326 = t204 * t225
  t334 = t104 * t93
  t339 = t120 * t230
  t340 = t339 * t234
  t343 = t110 * t99
  t348 = -0.320e3 / 0.9e1 * t187 * t309 - 0.320e3 / 0.9e1 * t106 * t316 - 0.40e2 * t194 * t316 - 0.40e2 * t112 * t321 - 0.400e3 / 0.9e1 * t201 * t321 - 0.400e3 / 0.9e1 * t118 * t326 - 0.440e3 / 0.9e1 * t208 * t326 - 0.440e3 / 0.9e1 * t124 * t213 * t225 + 0.1400e4 / 0.9e1 * t334 * t253 + 0.3200e4 / 0.9e1 * t187 * t262 + 0.200e3 * t106 * t340 + 0.200e3 * t343 * t262 + 0.450e3 * t194 * t340
  t349 = t126 * t230
  t350 = t349 * t234
  t353 = t116 * t105
  t360 = t212 * t230
  t361 = t360 * t234
  t364 = t122 * t111
  t370 = 0.1e1 / t107 / t89
  t371 = t370 * t230
  t375 = t90 * t230
  t376 = t375 * t234
  t379 = t80 * t69
  t386 = t86 * t75
  t391 = 0.250e3 * t112 * t350 + 0.250e3 * t353 * t340 + 0.5000e4 / 0.9e1 * t201 * t350 + 0.50e2 * t151 * t272 + 0.2750e4 / 0.9e1 * t118 * t361 + 0.2750e4 / 0.9e1 * t364 * t350 + 0.6050e4 / 0.9e1 * t208 * t361 + 0.1100e4 / 0.3e1 * t124 * t371 * t234 + 0.100e3 / 0.3e1 * t76 * t376 + 0.100e3 / 0.3e1 * t379 * t272 + 0.800e3 / 0.9e1 * t158 * t376 + 0.500e3 / 0.9e1 * t82 * t247 + 0.500e3 / 0.9e1 * t386 * t376 + 0.1250e4 / 0.9e1 * t165 * t247
  t393 = t275 + t312 + t348 + t391
  t395 = t50 * t226 * t393
  t398 = t6 ** 2
  t399 = 0.1e1 / t398
  t401 = -t16 * t399 + t7
  t402 = f.my_piecewise5(t10, 0, t14, 0, t401)
  t405 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t402)
  t408 = t5 * t405 * t28 * params.csi_HF
  t410 = t50 * t226 * t128
  t413 = t405 * t26
  t415 = t5 * t413 * params.csi_HF
  t417 = t50 * t226 * t218
  t425 = 0.1e1 / t47 / t46 * t57 / t34 / t33
  t426 = s0 ** 2
  t429 = 0.1e1 / t39 / t51 / t223
  t430 = t426 * t429
  t432 = t425 * t430 * t128
  t436 = 0.1e1 / t27 / t6
  t439 = t5 * t25 * t436 * params.csi_HF
  t447 = t425 * t430 * t218
  t450 = t23 ** 2
  t451 = 0.1e1 / t450
  t452 = t402 ** 2
  t455 = t398 * t6
  t456 = 0.1e1 / t455
  t459 = 0.2e1 * t16 * t456 - 0.2e1 * t399
  t460 = f.my_piecewise5(t10, 0, t14, 0, t459)
  t464 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t451 * t452 + 0.4e1 / 0.3e1 * t23 * t460)
  t467 = t5 * t464 * t26 * params.csi_HF
  t470 = t51 ** 2
  t473 = t426 / t39 / t470
  t475 = t425 * t473 * t128
  t478 = -0.21678859680278179761800000000000000000000000000001e-1 * t31 * t130 - 0.65036579040834539285400000000000000000000000000005e-1 * t135 * t220 + 0.17737248829318510714200000000000000000000000000001e-1 * t135 * t395 + 0.11824832552879007142800000000000000000000000000001e-1 * t408 * t410 + 0.35474497658637021428400000000000000000000000000003e-1 * t415 * t417 + 0.86524259859673682121739906443091396000000000000011e-3 * t415 * t432 - 0.39416108509596690476000000000000000000000000000003e-2 * t439 * t410 + 0.11824832552879007142800000000000000000000000000001e-1 * t31 * t417 + 0.28841419953224560707246635481030465333333333333336e-3 * t31 * t432 + 0.86524259859673682121739906443091396000000000000011e-3 * t135 * t447 + 0.17737248829318510714200000000000000000000000000001e-1 * t467 * t410 - 0.31725561948547016777971299029133511866666666666670e-2 * t135 * t475
  t480 = 0.1e1 / t40 / t232
  t481 = s0 * t480
  t483 = t50 * t481 * t128
  t488 = t5 * t464
  t489 = t26 * params.csi_HF
  t492 = 0.18040e1 - 0.64641600e0 / t46
  t493 = t492 * t218
  t494 = t489 * t493
  t497 = t5 * t405
  t498 = t28 * params.csi_HF
  t499 = t498 * t493
  t502 = t492 * t393
  t503 = t489 * t502
  t506 = t5 * t25
  t508 = 0.1e1 / t27 / t398
  t509 = t508 * params.csi_HF
  t510 = t492 * t128
  t511 = t509 * t510
  t514 = t498 * t510
  t517 = t436 * params.csi_HF
  t518 = t517 * t510
  t521 = t230 * tau0
  t522 = t56 * t521
  t523 = 0.1e1 / t470
  t524 = t523 * t78
  t527 = t68 * t521
  t530 = t74 * t521
  t533 = t51 * t38
  t535 = 0.1e1 / t39 / t533
  t536 = t535 * t72
  t544 = t339 * t535
  t547 = t349 * t535
  t550 = t360 * t535
  t553 = t176 * t53
  t558 = 0.250e3 / 0.9e1 * t522 * t524 + 0.500e3 / 0.9e1 * t527 * t524 + 0.250e3 / 0.9e1 * t530 * t524 - 0.400e3 / 0.9e1 * t231 * t536 - 0.400e3 / 0.9e1 * t238 * t536 + 0.440e3 / 0.27e2 * t136 * t53 * t66 - 0.2000e4 * t353 * t544 - 0.40000e5 / 0.9e1 * t201 * t547 - 0.22000e5 / 0.9e1 * t118 * t550 + 0.880e3 / 0.9e1 * t94 * t553 + 0.3080e4 / 0.27e2 * t180 * t553
  t559 = t183 * t53
  t564 = t190 * t53
  t567 = t120 * t521
  t568 = t567 * t523
  t571 = t84 * t521
  t572 = t571 * t523
  t577 = t90 * t521
  t578 = t577 * t523
  t581 = t96 * t521
  t582 = t581 * t523
  t585 = t80 * t63
  t592 = t102 * t521
  t593 = t592 * t523
  t596 = 0.3080e4 / 0.27e2 * t100 * t559 + 0.3520e4 / 0.27e2 * t187 * t559 + 0.3520e4 / 0.27e2 * t106 * t564 + 0.7000e4 / 0.3e1 * t100 * t568 + 0.250e3 / 0.9e1 * t64 * t572 + 0.500e3 / 0.3e1 * t144 * t572 + 0.1000e4 / 0.9e1 * t70 * t578 + 0.2500e4 / 0.9e1 * t76 * t582 + 0.1000e4 / 0.9e1 * t585 * t572 + 0.2000e4 / 0.3e1 * t379 * t578 + 0.10000e5 / 0.9e1 * t158 * t582 + 0.5000e4 / 0.9e1 * t82 * t593
  t598 = t86 * t69
  t605 = t108 * t521
  t606 = t605 * t523
  t609 = t92 * t75
  t614 = t246 * t535
  t617 = t241 * t535
  t620 = t271 * t535
  t623 = t375 * t535
  t630 = 0.2500e4 / 0.9e1 * t598 * t578 + 0.12500e5 / 0.9e1 * t386 * t582 + 0.6250e4 / 0.3e1 * t165 * t593 + 0.8750e4 / 0.9e1 * t88 * t606 + 0.5000e4 / 0.9e1 * t609 * t582 + 0.2500e4 * t245 * t593 - 0.10000e5 / 0.9e1 * t165 * t614 - 0.2000e4 / 0.3e1 * t88 * t617 - 0.400e3 * t151 * t620 - 0.800e3 / 0.3e1 * t76 * t623 - 0.800e3 / 0.3e1 * t379 * t620 + 0.440e3 / 0.3e1 * t194 * t564
  t631 = t197 * t53
  t636 = t204 * t53
  t644 = t168 * t53
  t649 = t114 * t521
  t650 = t649 * t523
  t653 = t98 * t81
  t660 = t126 * t521
  t661 = t660 * t523
  t664 = 0.440e3 / 0.3e1 * t112 * t631 + 0.4400e4 / 0.27e2 * t201 * t631 + 0.4400e4 / 0.27e2 * t118 * t636 + 0.4840e4 / 0.27e2 * t208 * t636 + 0.4840e4 / 0.27e2 * t124 * t213 * t53 + 0.880e3 / 0.9e1 * t172 * t644 + 0.3500e4 * t172 * t606 + 0.14000e5 / 0.9e1 * t94 * t650 + 0.8750e4 / 0.9e1 * t653 * t593 + 0.12250e5 / 0.3e1 * t256 * t606 + 0.49000e5 / 0.9e1 * t180 * t650 + 0.10000e5 / 0.3e1 * t106 * t661
  t667 = t110 * t93
  t674 = t212 * t521
  t675 = t674 * t523
  t678 = t116 * t99
  t685 = t370 * t521
  t686 = t685 * t523
  t689 = t122 * t105
  t697 = 0.1e1 / t107 / t95
  t698 = t697 * t521
  t702 = 0.7000e4 / 0.3e1 * t667 * t650 + 0.9000e4 * t343 * t568 + 0.11250e5 * t194 * t661 + 0.13750e5 / 0.3e1 * t112 * t675 + 0.10000e5 / 0.3e1 * t678 * t568 + 0.12500e5 * t353 * t661 + 0.137500e6 / 0.9e1 * t201 * t675 + 0.55000e5 / 0.9e1 * t118 * t686 + 0.13750e5 / 0.3e1 * t689 * t661 + 0.151250e6 / 0.9e1 * t364 * t675 + 0.60500e5 / 0.3e1 * t208 * t686 + 0.71500e5 / 0.9e1 * t124 * t698 * t523
  t707 = t252 * t535
  t710 = t261 * t535
  t728 = t104 * t87
  t731 = 0.250e3 * t276 * t572 + 0.500e3 * t151 * t578 - 0.11200e5 / 0.9e1 * t334 * t707 - 0.25600e5 / 0.9e1 * t187 * t710 - 0.1600e4 * t106 * t544 - 0.1600e4 * t343 * t710 - 0.3600e4 * t194 * t544 - 0.2000e4 * t112 * t547 - 0.22000e5 / 0.9e1 * t364 * t547 - 0.48400e5 / 0.9e1 * t208 * t550 - 0.8800e4 / 0.3e1 * t124 * t371 * t535 + 0.14000e5 / 0.9e1 * t728 * t606
  t749 = t161 * t53
  t756 = t265 * t535
  t759 = 0.56000e5 / 0.9e1 * t334 * t650 + 0.8000e4 * t187 * t568 - 0.2000e4 / 0.3e1 * t245 * t614 - 0.1600e4 * t172 * t617 - 0.2800e4 / 0.3e1 * t94 * t707 - 0.2800e4 / 0.3e1 * t256 * t617 - 0.19600e5 / 0.9e1 * t180 * t707 - 0.11200e5 / 0.9e1 * t100 * t710 + 0.1760e4 / 0.27e2 * t82 * t749 + 0.2200e4 / 0.27e2 * t165 * t749 + 0.2200e4 / 0.27e2 * t88 * t644 - 0.400e3 / 0.9e1 * t64 * t756
  t766 = t140 * t53
  t771 = t147 * t53
  t776 = t154 * t53
  t787 = -0.1600e4 / 0.9e1 * t144 * t756 - 0.400e3 / 0.3e1 * t70 * t620 - 0.400e3 / 0.3e1 * t276 * t756 + 0.440e3 / 0.27e2 * t64 * t766 + 0.880e3 / 0.27e2 * t144 * t766 + 0.880e3 / 0.27e2 * t70 * t771 + 0.440e3 / 0.9e1 * t151 * t771 + 0.440e3 / 0.9e1 * t76 * t776 + 0.1760e4 / 0.27e2 * t158 * t776 - 0.6400e4 / 0.9e1 * t158 * t623 - 0.4000e4 / 0.9e1 * t82 * t614 - 0.4000e4 / 0.9e1 * t386 * t623
  t790 = t558 + t596 + t630 + t664 + t702 + t731 + t759 + t787
  t791 = t492 * t790
  t792 = t489 * t791
  t795 = t517 * t493
  t798 = t498 * t502
  t802 = 0.1e1 / t450 / t19
  t806 = t451 * t402
  t809 = t398 ** 2
  t810 = 0.1e1 / t809
  t813 = -0.6e1 * t16 * t810 + 0.6e1 * t456
  t814 = f.my_piecewise5(t10, 0, t14, 0, t813)
  t818 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t802 * t452 * t402 + 0.4e1 / 0.3e1 * t806 * t460 + 0.4e1 / 0.3e1 * t23 * t814)
  t819 = t5 * t818
  t820 = t489 * t510
  t823 = t33 ** 2
  t826 = t2 / t3 / t823
  t827 = t826 * t133
  t828 = t47 ** 2
  t830 = params.csi_HF / t828
  t831 = t426 * s0
  t834 = t831 / t470 / t223
  t836 = t830 * t834 * t128
  t839 = 0.10116801184129817222173333333333333333333333333334e0 * t135 * t483 - 0.65036579040834539285400000000000000000000000000005e-1 * t415 * t130 - 0.9e1 / 0.8e1 * t488 * t494 - 0.3e1 / 0.4e1 * t497 * t499 - 0.9e1 / 0.8e1 * t497 * t503 - 0.5e1 / 0.36e2 * t506 * t511 - 0.3e1 / 0.8e1 * t488 * t514 + t497 * t518 / 0.4e1 - 0.3e1 / 0.8e1 * t506 * t792 + t506 * t795 / 0.4e1 - 0.3e1 / 0.8e1 * t506 * t798 - 0.3e1 / 0.8e1 * t819 * t820 + 0.12662247031044178991769844370781511743016307403250e-3 * t827 * t836
  t841 = f.my_piecewise3(t1, 0, t478 + t839)
  t843 = r1 <= f.p.dens_threshold
  t844 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t845 = 0.1e1 + t844
  t846 = t845 <= f.p.zeta_threshold
  t847 = t845 ** (0.1e1 / 0.3e1)
  t848 = t847 ** 2
  t850 = 0.1e1 / t848 / t845
  t852 = f.my_piecewise5(t14, 0, t10, 0, -t401)
  t853 = t852 ** 2
  t857 = 0.1e1 / t848
  t858 = t857 * t852
  t860 = f.my_piecewise5(t14, 0, t10, 0, -t459)
  t864 = f.my_piecewise5(t14, 0, t10, 0, -t813)
  t868 = f.my_piecewise3(t846, 0, -0.8e1 / 0.27e2 * t850 * t853 * t852 + 0.4e1 / 0.3e1 * t858 * t860 + 0.4e1 / 0.3e1 * t847 * t864)
  t869 = t5 * t868
  t870 = r1 ** 2
  t871 = r1 ** (0.1e1 / 0.3e1)
  t872 = t871 ** 2
  t884 = tau1 / t872 / r1
  t885 = t59 - t884
  t887 = t59 + t884
  t890 = t885 ** 2
  t892 = t887 ** 2
  t895 = t890 * t885
  t897 = t892 * t887
  t900 = t890 ** 2
  t902 = t892 ** 2
  t920 = t900 ** 2
  t922 = t902 ** 2
  t940 = t55 + t56 * t885 / t887 + t68 * t890 / t892 + t74 * t895 / t897 + t80 * t900 / t902 + t86 * t900 * t885 / t902 / t887 + t92 * t900 * t890 / t902 / t892 + t98 * t900 * t895 / t902 / t897 + t104 * t920 / t922 + t110 * t920 * t885 / t922 / t887 + t116 * t920 * t890 / t922 / t892 + t122 * t920 * t895 / t922 / t897
  t941 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t37 * s2 / t872 / t870)) * t940
  t942 = t489 * t941
  t950 = f.my_piecewise3(t846, 0, 0.4e1 / 0.9e1 * t857 * t853 + 0.4e1 / 0.3e1 * t847 * t860)
  t951 = t5 * t950
  t952 = t498 * t941
  t957 = f.my_piecewise3(t846, 0, 0.4e1 / 0.3e1 * t847 * t852)
  t958 = t5 * t957
  t959 = t517 * t941
  t963 = f.my_piecewise3(t846, t22, t847 * t845)
  t964 = t5 * t963
  t965 = t509 * t941
  t969 = f.my_piecewise3(t843, 0, -0.3e1 / 0.8e1 * t869 * t942 - 0.3e1 / 0.8e1 * t951 * t952 + t958 * t959 / 0.4e1 - 0.5e1 / 0.36e2 * t964 * t965)
  t1003 = t470 * r0
  t1017 = 0.34609703943869472848695962577236558400000000000004e-2 * t415 * t447 + 0.17304851971934736424347981288618279200000000000002e-2 * t135 * t425 * t430 * t393 + 0.23649665105758014285600000000000000000000000000001e-1 * t5 * t818 * t26 * params.csi_HF * t410 - 0.15766443403838676190400000000000000000000000000001e-1 * t5 * t405 * t436 * params.csi_HF * t410 - 0.57328540043402297592315555555555555555555555555559e0 * t135 * t50 * s0 / t40 / t533 * t128 - 0.86715438721112719047200000000000000000000000000007e-1 * t408 * t130 + 0.23649665105758014285600000000000000000000000000001e-1 * t5 * t464 * t28 * params.csi_HF * t410 - 0.13007315808166907857080000000000000000000000000001e0 * t467 * t130 + 0.31373055704674272147104951262143139512592592592596e-1 * t135 * t425 * t426 / t39 / t1003 * t128 + 0.13489068245506422962897777777777777777777777777779e0 * t31 * t483 - 0.86715438721112719047200000000000000000000000000007e-1 * t31 * t220 - 0.42300749264729355703961732038844682488888888888892e-2 * t31 * t475
  t1032 = t426 ** 2
  t1067 = -0.12690224779418806711188519611653404746666666666668e-1 * t135 * t425 * t473 * t218 + 0.87591352243548201057777777777777777777777777777784e-2 * t5 * t25 * t508 * params.csi_HF * t410 + 0.28905146240370906349066666666666666666666666666668e-1 * t439 * t130 + 0.12353568054032224274661561387401184240831564473577e-4 * t826 * t134 / t828 / t46 * t1032 / t40 / t470 / t533 * t128 * t32 * t36 - 0.13007315808166907857080000000000000000000000000001e0 * t135 * t50 * t54 * t393 + 0.70948995317274042856800000000000000000000000000005e-1 * t415 * t395 + 0.23649665105758014285600000000000000000000000000001e-1 * t135 * t50 * t226 * t790 + 0.70948995317274042856800000000000000000000000000005e-1 * t467 * t417 + 0.17304851971934736424347981288618279200000000000002e-2 * t467 * t432 - 0.12690224779418806711188519611653404746666666666668e-1 * t415 * t475 + 0.40467204736519268888693333333333333333333333333336e0 * t415 * t483 + 0.40467204736519268888693333333333333333333333333336e0 * t135 * t50 * t481 * t218 - 0.26014631616333815714160000000000000000000000000002e0 * t415 * t220
  t1086 = t230 ** 2
  t1090 = 0.1e1 / t40 / t470 / t38
  t1091 = t1090 * t84
  t1103 = 0.1e1 / t1003
  t1104 = t1103 * t78
  t1111 = t429 * t72
  t1116 = t592 * t1103
  t1119 = t605 * t1103
  t1122 = t649 * t1103
  t1125 = t183 * t480
  t1130 = t190 * t480
  t1133 = t567 * t1103
  t1136 = t571 * t1103
  t1139 = -0.6160e4 / 0.81e2 * t136 * t480 * t66 + 0.5000e4 / 0.27e2 * t56 * t1086 * t1091 + 0.5000e4 / 0.9e1 * t68 * t1086 * t1091 + 0.5000e4 / 0.27e2 * t80 * t1086 * t1091 + 0.5000e4 / 0.9e1 * t74 * t1086 * t1091 - 0.4000e4 / 0.9e1 * t522 * t1104 - 0.8000e4 / 0.9e1 * t527 * t1104 - 0.4000e4 / 0.9e1 * t530 * t1104 + 0.27200e5 / 0.81e2 * t231 * t1111 + 0.27200e5 / 0.81e2 * t238 * t1111 - 0.40000e5 * t245 * t1116 - 0.56000e5 * t172 * t1119 - 0.224000e6 / 0.9e1 * t94 * t1122 - 0.43120e5 / 0.81e2 * t100 * t1125 - 0.49280e5 / 0.81e2 * t187 * t1125 - 0.49280e5 / 0.81e2 * t106 * t1130 - 0.112000e6 / 0.3e1 * t100 * t1133 - 0.4000e4 / 0.9e1 * t64 * t1136
  t1142 = t577 * t1103
  t1145 = t581 * t1103
  t1152 = t339 * t429
  t1155 = t349 * t429
  t1158 = t360 * t429
  t1163 = t197 * t480
  t1168 = t204 * t480
  t1176 = t168 * t480
  t1179 = t176 * t480
  t1186 = -0.8000e4 / 0.3e1 * t144 * t1136 - 0.16000e5 / 0.9e1 * t70 * t1142 - 0.40000e5 / 0.9e1 * t76 * t1145 - 0.16000e5 / 0.9e1 * t585 * t1136 - 0.32000e5 / 0.3e1 * t379 * t1142 + 0.136000e6 / 0.9e1 * t353 * t1152 + 0.2720000e7 / 0.81e2 * t201 * t1155 + 0.1496000e7 / 0.81e2 * t118 * t1158 - 0.6160e4 / 0.9e1 * t194 * t1130 - 0.6160e4 / 0.9e1 * t112 * t1163 - 0.61600e5 / 0.81e2 * t201 * t1163 - 0.61600e5 / 0.81e2 * t118 * t1168 - 0.67760e5 / 0.81e2 * t208 * t1168 - 0.67760e5 / 0.81e2 * t124 * t213 * t480 - 0.12320e5 / 0.27e2 * t172 * t1176 - 0.12320e5 / 0.27e2 * t94 * t1179 - 0.43120e5 / 0.81e2 * t180 * t1179 - 0.8000e4 * t151 * t1142
  t1188 = t252 * t429
  t1191 = t261 * t429
  t1205 = t120 * t1086 * t1090
  t1209 = t126 * t1086 * t1090
  t1213 = t90 * t1086 * t1090
  t1220 = t660 * t1103
  t1223 = t674 * t1103
  t1232 = t685 * t1103
  t1235 = 0.761600e6 / 0.81e2 * t334 * t1188 + 0.1740800e7 / 0.81e2 * t187 * t1191 + 0.108800e6 / 0.9e1 * t106 * t1152 + 0.108800e6 / 0.9e1 * t343 * t1191 + 0.27200e5 * t194 * t1152 + 0.136000e6 / 0.9e1 * t112 * t1155 + 0.761600e6 / 0.81e2 * t100 * t1191 + 0.980000e6 / 0.9e1 * t180 * t1205 + 0.350000e6 / 0.9e1 * t100 * t1209 + 0.5000e4 / 0.27e2 * t64 * t1213 - 0.112000e6 / 0.3e1 * t667 * t1122 - 0.144000e6 * t343 * t1133 - 0.180000e6 * t194 * t1220 - 0.220000e6 / 0.3e1 * t112 * t1223 - 0.160000e6 / 0.3e1 * t678 * t1133 - 0.200000e6 * t353 * t1220 - 0.2200000e7 / 0.9e1 * t201 * t1223 - 0.880000e6 / 0.9e1 * t118 * t1232
  t1239 = t96 * t1086 * t1090
  t1250 = t154 * t480
  t1253 = t161 * t480
  t1258 = t265 * t429
  t1263 = t271 * t429
  t1268 = t140 * t480
  t1273 = t147 * t480
  t1280 = 0.10000e5 / 0.3e1 * t276 * t1213 + 0.50000e5 / 0.9e1 * t151 * t1239 - 0.224000e6 / 0.9e1 * t728 * t1119 - 0.896000e6 / 0.9e1 * t334 * t1122 - 0.128000e6 * t187 * t1133 - 0.160000e6 / 0.3e1 * t106 * t1220 - 0.24640e5 / 0.81e2 * t158 * t1250 - 0.30800e5 / 0.81e2 * t165 * t1253 - 0.30800e5 / 0.81e2 * t88 * t1176 + 0.27200e5 / 0.81e2 * t64 * t1258 + 0.108800e6 / 0.81e2 * t144 * t1258 + 0.27200e5 / 0.27e2 * t70 * t1263 + 0.27200e5 / 0.27e2 * t276 * t1258 - 0.6160e4 / 0.81e2 * t64 * t1268 - 0.12320e5 / 0.81e2 * t144 * t1268 - 0.12320e5 / 0.81e2 * t70 * t1273 - 0.6160e4 / 0.27e2 * t151 * t1273 - 0.6160e4 / 0.27e2 * t76 * t1250
  t1316 = t375 * t429
  t1322 = -0.24640e5 / 0.81e2 * t82 * t1253 - 0.220000e6 / 0.3e1 * t689 * t1220 - 0.2420000e7 / 0.9e1 * t364 * t1223 - 0.968000e6 / 0.3e1 * t208 * t1232 - 0.1144000e7 / 0.9e1 * t124 * t698 * t1103 - 0.4000e4 * t276 * t1136 - 0.140000e6 / 0.9e1 * t653 * t1116 - 0.196000e6 / 0.3e1 * t256 * t1119 - 0.784000e6 / 0.9e1 * t180 * t1122 - 0.160000e6 / 0.9e1 * t158 * t1145 - 0.80000e5 / 0.9e1 * t82 * t1116 - 0.40000e5 / 0.9e1 * t598 * t1142 - 0.200000e6 / 0.9e1 * t386 * t1145 - 0.100000e6 / 0.3e1 * t165 * t1116 - 0.140000e6 / 0.9e1 * t88 * t1119 - 0.80000e5 / 0.9e1 * t609 * t1145 + 0.272000e6 / 0.81e2 * t386 * t1316 + 0.350000e6 / 0.9e1 * t116 * t93 * t1205
  t1326 = t212 * t1086 * t1090
  t1330 = t370 * t1086 * t1090
  t1334 = t697 * t1086 * t1090
  t1353 = t102 * t1086 * t1090
  t1357 = t108 * t1086 * t1090
  t1361 = t114 * t1086 * t1090
  t1377 = 0.2000000e7 / 0.9e1 * t678 * t1209 + 0.1375000e7 / 0.3e1 * t353 * t1326 + 0.11000000e8 / 0.27e2 * t201 * t1330 + 0.3575000e7 / 0.27e2 * t118 * t1334 + 0.550000e6 / 0.9e1 * t122 * t99 * t1209 + 0.3025000e7 / 0.9e1 * t689 * t1326 + 0.6050000e7 / 0.9e1 * t364 * t1330 + 0.15730000e8 / 0.27e2 * t208 * t1334 + 0.5005000e7 / 0.27e2 * t124 / t107 / t101 * t1086 * t1090 + 0.200000e6 / 0.9e1 * t609 * t1353 + 0.175000e6 / 0.3e1 * t245 * t1357 + 0.560000e6 / 0.9e1 * t172 * t1361 + 0.70000e5 / 0.3e1 * t94 * t1205 + 0.175000e6 / 0.27e2 * t98 * t75 * t1353 + 0.1225000e7 / 0.27e2 * t653 * t1357 + 0.980000e6 / 0.9e1 * t256 * t1361 + 0.1600000e7 / 0.9e1 * t187 * t1209 + 0.550000e6 / 0.9e1 * t106 * t1326
  t1418 = 0.70000e5 / 0.3e1 * t110 * t87 * t1361 + 0.140000e6 * t667 * t1205 + 0.300000e6 * t343 * t1209 + 0.275000e6 * t194 * t1326 + 0.275000e6 / 0.3e1 * t112 * t1330 + 0.40000e5 / 0.27e2 * t144 * t1213 + 0.25000e5 / 0.27e2 * t70 * t1239 + 0.25000e5 / 0.9e1 * t76 * t1353 + 0.80000e5 / 0.27e2 * t585 * t1213 + 0.100000e6 / 0.9e1 * t379 * t1239 + 0.400000e6 / 0.27e2 * t158 * t1353 + 0.175000e6 / 0.27e2 * t82 * t1357 + 0.25000e5 / 0.27e2 * t86 * t63 * t1213 + 0.250000e6 / 0.27e2 * t598 * t1239 + 0.250000e6 / 0.9e1 * t386 * t1353 + 0.875000e6 / 0.27e2 * t165 * t1357 + 0.350000e6 / 0.27e2 * t88 * t1361 + 0.25000e5 / 0.9e1 * t92 * t69 * t1239
  t1426 = t246 * t429
  t1429 = t241 * t429
  t1459 = 0.1496000e7 / 0.81e2 * t364 * t1155 + 0.3291200e7 / 0.81e2 * t208 * t1158 + 0.598400e6 / 0.27e2 * t124 * t371 * t429 + 0.136000e6 / 0.27e2 * t245 * t1426 + 0.108800e6 / 0.9e1 * t172 * t1429 + 0.190400e6 / 0.27e2 * t94 * t1188 + 0.190400e6 / 0.27e2 * t256 * t1429 + 0.1332800e7 / 0.81e2 * t180 * t1188 + 0.54400e5 / 0.27e2 * t76 * t1316 + 0.54400e5 / 0.27e2 * t379 * t1263 + 0.680000e6 / 0.81e2 * t165 * t1426 + 0.136000e6 / 0.27e2 * t88 * t1429 + 0.27200e5 / 0.9e1 * t151 * t1263 + 0.350000e6 / 0.27e2 * t104 * t81 * t1357 + 0.2240000e7 / 0.27e2 * t728 * t1361 + 0.560000e6 / 0.3e1 * t334 * t1205 + 0.435200e6 / 0.81e2 * t158 * t1316 + 0.272000e6 / 0.81e2 * t82 * t1426
  t1469 = 0.1e1 / t27 / t455 * params.csi_HF
  t1477 = t19 ** 2
  t1480 = t452 ** 2
  t1486 = t460 ** 2
  t1495 = -0.24e2 * t810 + 0.24e2 * t16 / t809 / t6
  t1496 = f.my_piecewise5(t10, 0, t14, 0, t1495)
  t1500 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t450 / t1477 * t1480 - 0.16e2 / 0.9e1 * t802 * t452 * t460 + 0.4e1 / 0.3e1 * t451 * t1486 + 0.16e2 / 0.9e1 * t806 * t814 + 0.4e1 / 0.3e1 * t23 * t1496)
  t1504 = -0.15766443403838676190400000000000000000000000000001e-1 * t439 * t417 - 0.38455226604299414276328847308040620444444444444449e-3 * t439 * t432 + 0.47299330211516028571200000000000000000000000000004e-1 * t408 * t417 + 0.23649665105758014285600000000000000000000000000001e-1 * t31 * t395 + 0.11536567981289824282898654192412186133333333333335e-2 * t31 * t447 + 0.11536567981289824282898654192412186133333333333335e-2 * t408 * t432 - 0.3e1 / 0.2e1 * t497 * t792 - 0.3e1 / 0.8e1 * t506 * t489 * t492 * (t1139 + t1186 + t1235 + t1280 + t1322 + t1377 + t1418 + t1459) + 0.10e2 / 0.27e2 * t506 * t1469 * t510 + t488 * t518 / 0.2e1 - 0.5e1 / 0.9e1 * t497 * t511 - 0.3e1 / 0.8e1 * t5 * t1500 * t820
  t1542 = -0.3e1 / 0.2e1 * t819 * t494 - 0.9e1 / 0.4e1 * t488 * t503 - 0.3e1 / 0.2e1 * t497 * t798 + t497 * t795 + t506 * t517 * t502 / 0.2e1 - t819 * t514 / 0.2e1 - 0.3e1 / 0.2e1 * t488 * t499 - 0.5e1 / 0.9e1 * t506 * t509 * t493 - t506 * t498 * t791 / 0.2e1 + 0.16882996041392238655693125827708682324021743204332e-3 * t826 * t29 * t836 + 0.50648988124176715967079377483126046972065229613000e-3 * t827 * t830 * t834 * t218 - 0.27856943468297193781893657615719325834635876287150e-2 * t827 * t830 * t831 / t470 / t51 * t128 + 0.50648988124176715967079377483126046972065229613000e-3 * t826 * t413 * t836
  t1545 = f.my_piecewise3(t1, 0, t1017 + t1067 + t1504 + t1542)
  t1546 = t845 ** 2
  t1549 = t853 ** 2
  t1555 = t860 ** 2
  t1561 = f.my_piecewise5(t14, 0, t10, 0, -t1495)
  t1565 = f.my_piecewise3(t846, 0, 0.40e2 / 0.81e2 / t848 / t1546 * t1549 - 0.16e2 / 0.9e1 * t850 * t853 * t860 + 0.4e1 / 0.3e1 * t857 * t1555 + 0.16e2 / 0.9e1 * t858 * t864 + 0.4e1 / 0.3e1 * t847 * t1561)
  t1579 = f.my_piecewise3(t843, 0, -0.3e1 / 0.8e1 * t5 * t1565 * t942 - t869 * t952 / 0.2e1 + t951 * t959 / 0.2e1 - 0.5e1 / 0.9e1 * t958 * t965 + 0.10e2 / 0.27e2 * t964 * t1469 * t941)
  d1111 = 0.4e1 * t841 + 0.4e1 * t969 + t6 * (t1545 + t1579)

  res = {'v4rho4': d1111}
  return res
