"""Generated from lda_c_vwn.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = t11 / 0.4e1
  t13 = jnp.sqrt(t11)
  t15 = t12 + 0.18637200000000000000000000000000000000000000000000e1 * t13 + 0.129352e2
  t16 = 0.1e1 / t15
  t20 = jnp.log(t4 * t10 * t16 / 0.4e1)
  t21 = 0.310907e-1 * t20
  t22 = t13 + 0.372744e1
  t25 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t22)
  t26 = 0.38783294878113014394824731224995739188004877421366e-1 * t25
  t27 = t13 / 0.2e1
  t28 = t27 + 0.10498e0
  t29 = t28 ** 2
  t31 = jnp.log(t29 * t16)
  t32 = 0.96902277115443742137603943210562149050493484994510e-3 * t31
  t33 = jnp.pi ** 2
  t34 = 0.1e1 / t33
  t36 = t12 + 0.56553500000000000000000000000000000000000000000000e0 * t13 + 0.130045e2
  t37 = 0.1e1 / t36
  t41 = jnp.log(t4 * t10 * t37 / 0.4e1)
  t42 = t13 + 0.113107e1
  t45 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t42)
  t47 = t27 + 0.47584e-2
  t48 = t47 ** 2
  t50 = jnp.log(t48 * t37)
  t53 = t34 * (t41 + 0.31770800474394146398819696256107927053514547209957e0 * t45 + 0.41403379428206274608377249480129098139321562919141e-3 * t50)
  t54 = r0 - r1
  t55 = 0.1e1 / t7
  t56 = t54 * t55
  t57 = 0.1e1 + t56
  t58 = t57 <= f.p.zeta_threshold
  t59 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t60 = t59 * f.p.zeta_threshold
  t61 = t57 ** (0.1e1 / 0.3e1)
  t63 = f.my_piecewise3(t58, t60, t61 * t57)
  t64 = 0.1e1 - t56
  t65 = t64 <= f.p.zeta_threshold
  t66 = t64 ** (0.1e1 / 0.3e1)
  t68 = f.my_piecewise3(t65, t60, t66 * t64)
  t69 = t63 + t68 - 0.2e1
  t70 = t53 * t69
  t71 = 2 ** (0.1e1 / 0.3e1)
  t72 = t71 - 0.1e1
  t74 = 0.1e1 / t72 / 0.2e1
  t75 = t54 ** 2
  t76 = t75 ** 2
  t77 = t7 ** 2
  t78 = t77 ** 2
  t79 = 0.1e1 / t78
  t83 = 0.9e1 / 0.4e1 * t72
  t84 = t74 * (-t76 * t79 + 0.1e1) * t83
  t86 = t70 * t84 / 0.6e1
  t88 = t12 + 0.35302100000000000000000000000000000000000000000000e1 * t13 + 0.180578e2
  t89 = 0.1e1 / t88
  t93 = jnp.log(t4 * t10 * t89 / 0.4e1)
  t95 = t13 + 0.706042e1
  t98 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t95)
  t100 = t27 + 0.32500e0
  t101 = t100 ** 2
  t103 = jnp.log(t101 * t89)
  t105 = 0.1554535e-1 * t93 + 0.52491393169780936217021346072241076933841385384498e-1 * t98 + 0.22478670955426118383265363956423012380560746650571e-2 * t103 - t21 - t26 - t32
  t106 = t105 * t69
  t107 = t74 * t76
  t108 = t107 * t79
  t109 = t106 * t108
  t111 = 0.1e1 / t8 / t7
  t112 = t6 * t111
  t116 = t4 * t6
  t117 = t15 ** 2
  t118 = 0.1e1 / t117
  t120 = t4 * t112
  t121 = t120 / 0.12e2
  t122 = 0.1e1 / t13
  t124 = t3 * t6
  t126 = t122 * t1 * t124 * t111
  t128 = -t121 - 0.31062000000000000000000000000000000000000000000000e0 * t126
  t133 = t1 ** 2
  t135 = 0.1e1 / t3
  t137 = t5 * t8
  t140 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t112 * t16 / 0.12e2 - t116 * t9 * t118 * t128 / 0.4e1) * t133 * t135 * t137 * t15
  t141 = t22 ** 2
  t142 = 0.1e1 / t141
  t151 = 0.39765745675026770180313930393880960493473766078662e-1 * t142 * t122 * t1 * t124 * t111 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t142)
  t162 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t28 * t16 * t122 * t120 / 0.6e1 - t29 * t118 * t128) / t29 * t15
  t166 = t36 ** 2
  t167 = 0.1e1 / t166
  t170 = -t121 - 0.94255833333333333333333333333333333333333333333334e-1 * t126
  t180 = t42 ** 2
  t181 = 0.1e1 / t180
  t206 = t34 * ((-t4 * t112 * t37 / 0.12e2 - t116 * t9 * t167 * t170 / 0.4e1) * t133 * t135 * t137 * t36 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t181 * t122 * t1 * t124 * t111 / (0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t181) + 0.41403379428206274608377249480129098139321562919141e-3 * (-t47 * t37 * t122 * t120 / 0.6e1 - t48 * t167 * t170) / t48 * t36) * t69 * t84 / 0.6e1
  t208 = t54 / t77
  t209 = t55 - t208
  t212 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t209)
  t216 = f.my_piecewise3(t65, 0, -0.4e1 / 0.3e1 * t66 * t209)
  t217 = t212 + t216
  t221 = t75 * t54
  t222 = t221 * t79
  t224 = 0.1e1 / t78 / t7
  t225 = t76 * t224
  t235 = t88 ** 2
  t236 = 0.1e1 / t235
  t239 = -t121 - 0.58836833333333333333333333333333333333333333333333e0 * t126
  t249 = t95 ** 2
  t250 = 0.1e1 / t249
  t273 = (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t112 * t89 / 0.12e2 - t116 * t9 * t236 * t239 / 0.4e1) * t133 * t135 * t137 * t88 + 0.41388824077869423260215065147117773567486474051459e-1 * t250 * t122 * t1 * t124 * t111 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t250) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t100 * t89 * t122 * t120 / 0.6e1 - t101 * t236 * t239) / t101 * t88 - t140 - t151 - t162) * t69 * t108
  t279 = 0.4e1 * t106 * t74 * t221 * t79
  t282 = 0.4e1 * t106 * t107 * t224
  vrho_0_ = t21 + t26 + t32 - t86 + t109 + t7 * (t140 + t151 + t162 - t206 - t53 * t217 * t84 / 0.6e1 - t70 * t74 * (-0.4e1 * t222 + 0.4e1 * t225) * t83 / 0.6e1 + t273 + t105 * t217 * t108 + t279 - t282)
  t285 = -t55 - t208
  t288 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t285)
  t292 = f.my_piecewise3(t65, 0, -0.4e1 / 0.3e1 * t66 * t285)
  t293 = t288 + t292
  vrho_1_ = t21 + t26 + t32 - t86 + t109 + t7 * (t140 + t151 + t162 - t206 - t53 * t293 * t84 / 0.6e1 - t70 * t74 * (0.4e1 * t222 + 0.4e1 * t225) * t83 / 0.6e1 + t273 + t105 * t293 * t108 - t279 - t282)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = t10 / 0.4e1
  t12 = jnp.sqrt(t10)
  t14 = t11 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t15 = 0.1e1 / t14
  t19 = jnp.log(t4 * t9 * t15 / 0.4e1)
  t21 = t12 + 0.372744e1
  t24 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t21)
  t26 = t12 / 0.2e1
  t27 = t26 + 0.10498e0
  t28 = t27 ** 2
  t30 = jnp.log(t28 * t15)
  t32 = jnp.pi ** 2
  t33 = 0.1e1 / t32
  t35 = t11 + 0.56553500000000000000000000000000000000000000000000e0 * t12 + 0.130045e2
  t36 = 0.1e1 / t35
  t40 = jnp.log(t4 * t9 * t36 / 0.4e1)
  t41 = t12 + 0.113107e1
  t44 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t41)
  t46 = t26 + 0.47584e-2
  t47 = t46 ** 2
  t49 = jnp.log(t47 * t36)
  t54 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t56 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t54 * f.p.zeta_threshold, 1)
  t59 = 2 ** (0.1e1 / 0.3e1)
  t60 = t59 - 0.1e1
  t65 = 0.9e1 / 0.4e1 * t56 - 0.9e1 / 0.4e1
  t69 = 0.1e1 / t7 / r0
  t70 = t6 * t69
  t74 = t4 * t6
  t75 = t14 ** 2
  t76 = 0.1e1 / t75
  t78 = t4 * t70
  t79 = t78 / 0.12e2
  t80 = 0.1e1 / t12
  t82 = t3 * t6
  t84 = t80 * t1 * t82 * t69
  t86 = -t79 - 0.31062000000000000000000000000000000000000000000000e0 * t84
  t91 = t1 ** 2
  t93 = 0.1e1 / t3
  t95 = t5 * t7
  t99 = t21 ** 2
  t100 = 0.1e1 / t99
  t124 = t35 ** 2
  t125 = 0.1e1 / t124
  t128 = -t79 - 0.94255833333333333333333333333333333333333333333334e-1 * t84
  t138 = t41 ** 2
  t139 = 0.1e1 / t138
  vrho_0_ = 0.310907e-1 * t19 + 0.38783294878113014394824731224995739188004877421366e-1 * t24 + 0.96902277115443742137603943210562149050493484994510e-3 * t30 - t33 * (t40 + 0.31770800474394146398819696256107927053514547209957e0 * t44 + 0.41403379428206274608377249480129098139321562919141e-3 * t49) * t65 / 0.6e1 + r0 * (0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t70 * t15 / 0.12e2 - t74 * t8 * t76 * t86 / 0.4e1) * t91 * t93 * t95 * t14 + 0.39765745675026770180313930393880960493473766078662e-1 * t100 * t80 * t1 * t82 * t69 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t100) + 0.96902277115443742137603943210562149050493484994510e-3 * (-t27 * t15 * t80 * t78 / 0.6e1 - t28 * t76 * t86) / t28 * t14 - t33 * ((-t4 * t70 * t36 / 0.12e2 - t74 * t8 * t125 * t128 / 0.4e1) * t91 * t93 * t95 * t35 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t139 * t80 * t1 * t82 * t69 / (0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t139) + 0.41403379428206274608377249480129098139321562919141e-3 * (-t46 * t36 * t80 * t78 / 0.6e1 - t47 * t125 * t128) / t47 * t35) * t65 / 0.6e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t13 = t4 * t6 * t11
  t14 = t13 / 0.4e1
  t15 = jnp.sqrt(t13)
  t17 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t15 + 0.129352e2
  t18 = 0.1e1 / t17
  t22 = t4 * t6
  t23 = t17 ** 2
  t24 = 0.1e1 / t23
  t25 = t11 * t24
  t26 = t4 * t10
  t27 = t26 / 0.12e2
  t28 = 0.1e1 / t15
  t29 = t28 * t1
  t30 = t3 * t6
  t32 = t29 * t30 * t9
  t34 = -t27 - 0.31062000000000000000000000000000000000000000000000e0 * t32
  t39 = t1 ** 2
  t41 = 0.1e1 / t3
  t42 = (-t4 * t10 * t18 / 0.12e2 - t22 * t25 * t34 / 0.4e1) * t39 * t41
  t43 = t5 * t7
  t44 = t43 * t17
  t47 = t15 + 0.372744e1
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t51 = t49 * t28 * t1
  t53 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t49
  t54 = 0.1e1 / t53
  t59 = t15 / 0.2e1
  t60 = t59 + 0.10498e0
  t61 = t60 * t18
  t62 = t61 * t28
  t65 = t60 ** 2
  t66 = t65 * t24
  t68 = -t62 * t26 / 0.6e1 - t66 * t34
  t69 = 0.1e1 / t65
  t70 = t68 * t69
  t73 = jnp.pi ** 2
  t74 = 0.1e1 / t73
  t76 = t14 + 0.56553500000000000000000000000000000000000000000000e0 * t15 + 0.130045e2
  t77 = 0.1e1 / t76
  t81 = t76 ** 2
  t82 = 0.1e1 / t81
  t83 = t11 * t82
  t85 = -t27 - 0.94255833333333333333333333333333333333333333333334e-1 * t32
  t91 = (-t4 * t10 * t77 / 0.12e2 - t22 * t83 * t85 / 0.4e1) * t39 * t41
  t92 = t43 * t76
  t95 = t15 + 0.113107e1
  t96 = t95 ** 2
  t97 = 0.1e1 / t96
  t99 = t97 * t28 * t1
  t101 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t97
  t102 = 0.1e1 / t101
  t107 = t59 + 0.47584e-2
  t108 = t107 * t77
  t109 = t108 * t28
  t112 = t107 ** 2
  t113 = t112 * t82
  t115 = -t109 * t26 / 0.6e1 - t113 * t85
  t116 = 0.1e1 / t112
  t117 = t115 * t116
  t123 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t125 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t123 * f.p.zeta_threshold, 1)
  t128 = 2 ** (0.1e1 / 0.3e1)
  t129 = t128 - 0.1e1
  t134 = 0.9e1 * t125 - 0.9e1
  t137 = r0 ** 2
  t139 = 0.1e1 / t7 / t137
  t140 = t6 * t139
  t142 = t4 * t140 * t18
  t149 = 0.1e1 / t23 / t17
  t151 = t34 ** 2
  t155 = t4 * t140
  t156 = t155 / 0.9e1
  t158 = 0.1e1 / t15 / t13
  t160 = t3 ** 2
  t161 = t160 * t5
  t162 = t7 ** 2
  t164 = 0.1e1 / t162 / t137
  t166 = t158 * t39 * t161 * t164
  t169 = t29 * t30 * t139
  t171 = t156 - 0.20708000000000000000000000000000000000000000000000e0 * t166 + 0.41416000000000000000000000000000000000000000000000e0 * t169
  t181 = t5 / t162
  t205 = t48 ** 2
  t210 = t53 ** 2
  t225 = t39 * t160 * t5 * t164
  t248 = t4 * t140 * t77
  t255 = 0.1e1 / t81 / t76
  t257 = t85 ** 2
  t263 = t156 - 0.62837222222222222222222222222222222222222222222223e-1 * t166 + 0.12567444444444444444444444444444444444444444444445e0 * t169
  t295 = t96 ** 2
  t300 = t101 ** 2
  t338 = 0.10363566666666666666666666666666666666666666666667e-1 * (t142 / 0.9e1 + t22 * t9 * t24 * t34 / 0.6e1 + t22 * t11 * t149 * t151 / 0.2e1 - t22 * t25 * t171 / 0.4e1) * t39 * t41 * t44 + 0.34545222222222222222222222222222222222222222222223e-2 * t42 * t181 * t17 + 0.10363566666666666666666666666666666666666666666667e-1 * t42 * t43 * t34 + 0.13255248558342256726771310131293653497824588692887e-1 / t48 / t47 * t1 * t3 * t140 * t54 + 0.26510497116684513453542620262587306995649177385775e-1 * t49 * t158 * t39 * t161 * t164 * t54 - 0.53020994233369026907085240525174613991298354771549e-1 * t51 * t30 * t139 * t54 - 0.50167127350538589836488394571946851238131125013746e0 / t205 / t47 * t1 * t3 * t140 / t210 + 0.96902277115443742137603943210562149050493484994510e-3 * (t142 / 0.72e2 + t60 * t24 * t29 * t30 * t9 * t34 / 0.3e1 - t61 * t158 * t225 / 0.9e1 + 0.2e1 / 0.9e1 * t62 * t155 + 0.2e1 * t65 * t149 * t151 - t66 * t171) * t69 * t17 + 0.16150379519240623689600657201760358175082247499085e-3 * t68 / t65 / t60 * t17 * t28 * t26 + 0.96902277115443742137603943210562149050493484994510e-3 * t70 * t34 - t74 * ((t248 / 0.9e1 + t22 * t9 * t82 * t85 / 0.6e1 + t22 * t11 * t255 * t257 / 0.2e1 - t22 * t83 * t263 / 0.4e1) * t39 * t41 * t92 / 0.3e1 + t91 * t181 * t76 / 0.9e1 + t91 * t43 * t85 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 / t96 / t95 * t1 * t3 * t140 * t102 + 0.25145208020597448648343800944658141583651393365495e0 * t97 * t158 * t39 * t161 * t164 * t102 - 0.50290416041194897296687601889316283167302786730989e0 * t99 * t30 * t139 * t102 - 0.63791733988157656503906862782236557702656491548799e1 / t295 / t95 * t1 * t3 * t140 / t300 + 0.41403379428206274608377249480129098139321562919141e-3 * (t248 / 0.72e2 + t107 * t82 * t29 * t30 * t9 * t85 / 0.3e1 - t108 * t158 * t225 / 0.9e1 + 0.2e1 / 0.9e1 * t109 * t155 + 0.2e1 * t112 * t255 * t257 - t113 * t263) * t116 * t76 + 0.69005632380343791013962082466881830232202604865235e-4 * t115 / t112 / t107 * t76 * t28 * t26 + 0.41403379428206274608377249480129098139321562919141e-3 * t117 * t85) * t134 / 0.24e2
  v2rho2_0_ = 0.20727133333333333333333333333333333333333333333334e-1 * t42 * t44 + 0.79531491350053540360627860787761920986947532157324e-1 * t51 * t30 * t9 * t54 + 0.19380455423088748427520788642112429810098696998902e-2 * t70 * t17 - t74 * (t91 * t92 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t99 * t30 * t9 * t102 + 0.41403379428206274608377249480129098139321562919141e-3 * t117 * t76) * t134 / 0.12e2 + r0 * t338
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t14 = t4 * t6 * t12
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t21 = t4 * t11 * t19
  t23 = t4 * t6
  t25 = 0.1e1 / t8 / r0
  t26 = t18 ** 2
  t27 = 0.1e1 / t26
  t28 = t25 * t27
  t29 = t6 * t25
  t30 = t4 * t29
  t31 = t30 / 0.12e2
  t32 = 0.1e1 / t16
  t33 = t32 * t1
  t34 = t3 * t6
  t36 = t33 * t34 * t25
  t38 = -t31 - 0.31062000000000000000000000000000000000000000000000e0 * t36
  t43 = 0.1e1 / t26 / t18
  t44 = t12 * t43
  t45 = t38 ** 2
  t49 = t12 * t27
  t50 = t4 * t11
  t51 = t50 / 0.9e1
  t53 = 0.1e1 / t16 / t14
  t54 = t1 ** 2
  t55 = t53 * t54
  t56 = t3 ** 2
  t57 = t56 * t5
  t58 = t8 ** 2
  t60 = 0.1e1 / t58 / t7
  t62 = t55 * t57 * t60
  t65 = t33 * t34 * t10
  t67 = t51 - 0.20708000000000000000000000000000000000000000000000e0 * t62 + 0.41416000000000000000000000000000000000000000000000e0 * t65
  t73 = 0.1e1 / t3
  t74 = (t21 / 0.9e1 + t23 * t28 * t38 / 0.6e1 + t23 * t44 * t45 / 0.2e1 - t23 * t49 * t67 / 0.4e1) * t54 * t73
  t75 = t5 * t8
  t76 = t75 * t18
  t87 = (-t4 * t29 * t19 / 0.12e2 - t23 * t49 * t38 / 0.4e1) * t54 * t73
  t89 = t5 / t58
  t90 = t89 * t18
  t93 = t75 * t38
  t96 = t16 + 0.372744e1
  t97 = t96 ** 2
  t100 = 0.1e1 / t97 / t96 * t1
  t101 = t100 * t3
  t102 = 0.1e1 / t97
  t104 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t102
  t105 = 0.1e1 / t104
  t110 = t102 * t53 * t54
  t116 = t102 * t32 * t1
  t121 = t97 ** 2
  t124 = 0.1e1 / t121 / t96 * t1
  t125 = t124 * t3
  t126 = t104 ** 2
  t127 = 0.1e1 / t126
  t132 = t16 / 0.2e1
  t133 = t132 + 0.10498e0
  t134 = t133 * t27
  t135 = t134 * t33
  t140 = t133 * t19
  t141 = t140 * t53
  t142 = t54 * t56
  t144 = t142 * t5 * t60
  t147 = t140 * t32
  t150 = t133 ** 2
  t151 = t150 * t43
  t154 = t150 * t27
  t156 = t21 / 0.72e2 + t135 * t34 * t25 * t38 / 0.3e1 - t141 * t144 / 0.9e1 + 0.2e1 / 0.9e1 * t147 * t50 + 0.2e1 * t151 * t45 - t154 * t67
  t157 = 0.1e1 / t150
  t158 = t156 * t157
  t164 = -t147 * t30 / 0.6e1 - t154 * t38
  t166 = 0.1e1 / t150 / t133
  t167 = t164 * t166
  t168 = t18 * t32
  t169 = t167 * t168
  t172 = t164 * t157
  t175 = jnp.pi ** 2
  t176 = 0.1e1 / t175
  t178 = t15 + 0.56553500000000000000000000000000000000000000000000e0 * t16 + 0.130045e2
  t179 = 0.1e1 / t178
  t181 = t4 * t11 * t179
  t183 = t178 ** 2
  t184 = 0.1e1 / t183
  t185 = t25 * t184
  t187 = -t31 - 0.94255833333333333333333333333333333333333333333334e-1 * t36
  t192 = 0.1e1 / t183 / t178
  t193 = t12 * t192
  t194 = t187 ** 2
  t198 = t12 * t184
  t201 = t51 - 0.62837222222222222222222222222222222222222222222223e-1 * t62 + 0.12567444444444444444444444444444444444444444444445e0 * t65
  t207 = (t181 / 0.9e1 + t23 * t185 * t187 / 0.6e1 + t23 * t193 * t194 / 0.2e1 - t23 * t198 * t201 / 0.4e1) * t54 * t73
  t208 = t75 * t178
  t219 = (-t4 * t29 * t179 / 0.12e2 - t23 * t198 * t187 / 0.4e1) * t54 * t73
  t220 = t89 * t178
  t223 = t75 * t187
  t226 = t16 + 0.113107e1
  t227 = t226 ** 2
  t230 = 0.1e1 / t227 / t226 * t1
  t231 = t230 * t3
  t232 = 0.1e1 / t227
  t234 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t232
  t235 = 0.1e1 / t234
  t240 = t232 * t53 * t54
  t246 = t232 * t32 * t1
  t251 = t227 ** 2
  t254 = 0.1e1 / t251 / t226 * t1
  t255 = t254 * t3
  t256 = t234 ** 2
  t257 = 0.1e1 / t256
  t262 = t132 + 0.47584e-2
  t263 = t262 * t184
  t264 = t263 * t33
  t269 = t262 * t179
  t270 = t269 * t53
  t273 = t269 * t32
  t276 = t262 ** 2
  t277 = t276 * t192
  t280 = t276 * t184
  t282 = t181 / 0.72e2 + t264 * t34 * t25 * t187 / 0.3e1 - t270 * t144 / 0.9e1 + 0.2e1 / 0.9e1 * t273 * t50 + 0.2e1 * t277 * t194 - t280 * t201
  t283 = 0.1e1 / t276
  t284 = t282 * t283
  t290 = -t273 * t30 / 0.6e1 - t280 * t187
  t292 = 0.1e1 / t276 / t262
  t293 = t290 * t292
  t294 = t178 * t32
  t295 = t293 * t294
  t298 = t290 * t283
  t304 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t306 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t304 * f.p.zeta_threshold, 1)
  t309 = 2 ** (0.1e1 / 0.3e1)
  t310 = t309 - 0.1e1
  t315 = 0.9e1 * t306 - 0.9e1
  t326 = t7 * r0
  t328 = 0.1e1 / t8 / t326
  t329 = t6 * t328
  t337 = t5 / t58 / r0
  t345 = t4 * t329 * t19
  t349 = t23 * t10 * t27 * t38
  t358 = t26 ** 2
  t359 = 0.1e1 / t358
  t361 = t45 * t38
  t365 = t38 * t67
  t369 = t4 * t329
  t370 = 0.7e1 / 0.27e2 * t369
  t374 = 0.1e1 / t16 / t142 / t89 / 0.4e1
  t376 = t7 ** 2
  t377 = 0.1e1 / t376
  t378 = t374 * t2 * t377
  t381 = 0.1e1 / t58 / t326
  t383 = t55 * t57 * t381
  t386 = t33 * t34 * t328
  t388 = -t370 - 0.12424800000000000000000000000000000000000000000000e1 * t378 + 0.82832000000000000000000000000000000000000000000000e0 * t383 - 0.96637333333333333333333333333333333333333333333333e0 * t386
  t398 = t2 * t377
  t414 = t4 * t329 * t179
  t418 = t23 * t10 * t184 * t187
  t427 = t183 ** 2
  t428 = 0.1e1 / t427
  t430 = t194 * t187
  t434 = t187 * t201
  t441 = -t370 - 0.37702333333333333333333333333333333333333333333334e0 * t378 + 0.25134888888888888888888888888888888888888888888890e0 * t383 - 0.29324037037037037037037037037037037037037037037038e0 * t386
  t472 = 0.1e1 / t56
  t474 = t1 * t472 * t6
  t475 = t328 * t2
  t481 = t5 * t381
  t482 = t142 * t481
  t493 = -0.11e2 / 0.216e3 * t414 - t418 / 0.24e2 - t262 * t192 * t33 * t34 * t25 * t194 + t263 * t55 * t57 * t60 * t187 / 0.3e1 - 0.2e1 / 0.3e1 * t264 * t34 * t10 * t187 + t264 * t34 * t25 * t201 / 0.2e1 + t474 * t475 * t179 / 0.432e3 - 0.2e1 / 0.3e1 * t269 * t378 + 0.4e1 / 0.9e1 * t270 * t482 - 0.14e2 / 0.27e2 * t273 * t369 - 0.6e1 * t276 * t428 * t430 + 0.6e1 * t277 * t434 - t280 * t441
  t509 = 0.15087124812358469189006280566794884950190836019297e1 * t232 * t374 * t398 * t235 + 0.23390302462324474051432516353486737824307380234560e2 * t255 * t329 * t257 + t219 * t75 * t201 / 0.3e1 + 0.2e1 / 0.3e1 * t207 * t223 + 0.2e1 / 0.9e1 * t219 * t89 * t187 + (-0.7e1 / 0.27e2 * t414 - t418 / 0.3e1 - t23 * t25 * t192 * t194 / 0.2e1 + t23 * t185 * t201 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t428 * t430 + 0.3e1 / 0.2e1 * t23 * t193 * t434 - t23 * t198 * t441 / 0.4e1) * t54 * t73 * t208 / 0.3e1 - 0.92007509840458388018616109955842440309603473153646e-4 * t295 * t50 + 0.41403379428206274608377249480129098139321562919141e-3 * t493 * t283 * t178 + 0.82806758856412549216754498960258196278643125838282e-3 * t284 * t187 + 0.41403379428206274608377249480129098139321562919141e-3 * t298 * t201 - 0.10058083208238979459337520377863256633460557346198e1 * t240 * t57 * t381 * t235 + 0.11734430409612142702560440440840466072370650237231e1 * t246 * t34 * t328 * t235
  t555 = t251 ** 2
  t565 = t276 ** 2
  t571 = 0.13801126476068758202792416493376366046440520973047e-3 * t282 * t292 * t294 * t30 + 0.13801126476068758202792416493376366046440520973047e-3 * t293 * t187 * t32 * t30 + 0.46003754920229194009308054977921220154801736576823e-4 * t293 * t178 * t53 * t144 + 0.2e1 / 0.9e1 * t207 * t220 - 0.2e1 / 0.27e2 * t219 * t337 * t178 - 0.46099548037761989188630301731873259570027554503406e0 * t231 * t329 * t235 + 0.25145208020597448648343800944658141583651393365494e0 / t251 * t54 * t56 * t481 * t235 * t32 - 0.29769475861140239701823202631710393594573029389440e2 / t251 / t227 * t54 * t56 * t481 * t257 * t32 + 0.20954340017164540540286500787215117986376161137912e-1 * t230 * t472 * t329 * t2 * t235 - 0.10631955664692942750651143797039426283776081924800e1 * t254 * t472 * t329 * t2 * t257 + 0.86312224513605868227832795632565231845861115350066e3 / t555 * t54 * t56 * t481 / t256 / t234 * t32 + 0.17251408095085947753490520616720457558050651216309e-4 * t290 / t565 * t178 * t50
  t615 = -0.11e2 / 0.216e3 * t345 - t349 / 0.24e2 - t133 * t43 * t33 * t34 * t25 * t45 + t134 * t55 * t57 * t60 * t38 / 0.3e1 - 0.2e1 / 0.3e1 * t135 * t34 * t10 * t38 + t135 * t34 * t25 * t67 / 0.2e1 + t474 * t475 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t140 * t378 + 0.4e1 / 0.9e1 * t141 * t482 - 0.14e2 / 0.27e2 * t147 * t369 - 0.6e1 * t150 * t359 * t361 + 0.6e1 * t151 * t365 - t154 * t388
  t621 = 0.20727133333333333333333333333333333333333333333334e-1 * t74 * t93 + 0.69090444444444444444444444444444444444444444444446e-2 * t87 * t89 * t38 + 0.10363566666666666666666666666666666666666666666667e-1 * t87 * t75 * t67 + 0.18394613361864149606712411343047178787314745838373e1 * t125 * t329 * t127 + 0.69090444444444444444444444444444444444444444444446e-2 * t74 * t90 - 0.23030148148148148148148148148148148148148148148149e-2 * t87 * t337 * t18 - 0.48602578047254941331494803814743396158690158540586e-1 * t101 * t329 * t105 + 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t345 - t349 / 0.3e1 - t23 * t25 * t43 * t45 / 0.2e1 + t23 * t28 * t67 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t359 * t361 + 0.3e1 / 0.2e1 * t23 * t44 * t365 - t23 * t49 * t388 / 0.4e1) * t54 * t73 * t76 - t176 * (t509 + t571) * t315 / 0.24e2 + 0.15906298270010708072125572157552384197389506431465e0 * t102 * t374 * t398 * t105 + 0.96902277115443742137603943210562149050493484994510e-3 * t615 * t157 * t18 + 0.19380455423088748427520788642112429810098696998902e-2 * t158 * t38
  t671 = t121 ** 2
  t681 = t150 ** 2
  t687 = 0.96902277115443742137603943210562149050493484994510e-3 * t172 * t67 - 0.21533839358987498252800876269013810900109663332113e-3 * t169 * t50 + 0.32300759038481247379201314403520716350164494998170e-3 * t156 * t166 * t168 * t30 + 0.32300759038481247379201314403520716350164494998170e-3 * t167 * t38 * t32 * t30 + 0.10766919679493749126400438134506905450054831666057e-3 * t167 * t18 * t53 * t144 - 0.10604198846673805381417048105034922798259670954310e0 * t110 * t57 * t381 * t105 + 0.12371565321119439611653222789207409931302949446695e0 * t116 * t34 * t328 * t105 + 0.26510497116684513453542620262587306995649177385774e-1 / t121 * t54 * t56 * t481 * t105 * t32 - 0.23411326096918008590361250800241863911127858339748e1 / t121 / t97 * t54 * t56 * t481 * t127 * t32 + 0.22092080930570427877952183552156089163040981154812e-2 * t100 * t472 * t329 * t2 * t105 - 0.83611878917564316394147324286578085396885208356242e-1 * t124 * t472 * t329 * t2 * t127 + 0.50631328524251801700246888250186209051365905137714e2 / t671 * t54 * t56 * t481 / t126 / t104 * t32 + 0.40375948798101559224001643004400895437705618747712e-4 * t164 / t681 * t18 * t50
  v3rho3_0_ = 0.31090700000000000000000000000000000000000000000001e-1 * t74 * t76 + 0.10363566666666666666666666666666666666666666666667e-1 * t87 * t90 + 0.31090700000000000000000000000000000000000000000001e-1 * t87 * t93 + 0.39765745675026770180313930393880960493473766078662e-1 * t101 * t11 * t105 + 0.79531491350053540360627860787761920986947532157324e-1 * t110 * t57 * t60 * t105 - 0.15906298270010708072125572157552384197389506431465e0 * t116 * t34 * t10 * t105 - 0.15050138205161576950946518371584055371439337504124e1 * t125 * t11 * t127 + 0.29070683134633122641281182963168644715148045498353e-2 * t158 * t18 + 0.48451138557721871068801971605281074525246742497255e-3 * t169 * t30 + 0.29070683134633122641281182963168644715148045498353e-2 * t172 * t38 - t176 * (t207 * t208 / 0.3e1 + t219 * t220 / 0.9e1 + t219 * t223 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 * t231 * t11 * t235 + 0.25145208020597448648343800944658141583651393365495e0 * t240 * t57 * t60 * t235 - 0.50290416041194897296687601889316283167302786730989e0 * t246 * t34 * t10 * t235 - 0.63791733988157656503906862782236557702656491548799e1 * t255 * t11 * t257 + 0.41403379428206274608377249480129098139321562919141e-3 * t284 * t178 + 0.69005632380343791013962082466881830232202604865235e-4 * t295 * t30 + 0.41403379428206274608377249480129098139321562919141e-3 * t298 * t187) * t315 / 0.8e1 + r0 * (t621 + t687)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t14 = t4 * t6 * t12
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t21 = t4 * t11 * t19
  t23 = t16 / 0.2e1
  t24 = t23 + 0.10498e0
  t25 = t18 ** 2
  t26 = 0.1e1 / t25
  t27 = t24 * t26
  t28 = 0.1e1 / t16
  t29 = t28 * t1
  t30 = t27 * t29
  t31 = t3 * t6
  t33 = 0.1e1 / t8 / r0
  t34 = t6 * t33
  t35 = t4 * t34
  t36 = t35 / 0.12e2
  t38 = t29 * t31 * t33
  t40 = -t36 - 0.31062000000000000000000000000000000000000000000000e0 * t38
  t41 = t33 * t40
  t45 = t24 * t19
  t47 = 0.1e1 / t16 / t14
  t48 = t45 * t47
  t49 = t1 ** 2
  t50 = t3 ** 2
  t51 = t49 * t50
  t52 = t8 ** 2
  t54 = 0.1e1 / t52 / t7
  t55 = t5 * t54
  t56 = t51 * t55
  t59 = t45 * t28
  t60 = t4 * t11
  t63 = t24 ** 2
  t65 = 0.1e1 / t25 / t18
  t66 = t63 * t65
  t67 = t40 ** 2
  t70 = t63 * t26
  t71 = t60 / 0.9e1
  t72 = t47 * t49
  t73 = t50 * t5
  t75 = t72 * t73 * t54
  t78 = t29 * t31 * t10
  t80 = t71 - 0.20708000000000000000000000000000000000000000000000e0 * t75 + 0.41416000000000000000000000000000000000000000000000e0 * t78
  t82 = t21 / 0.72e2 + t30 * t31 * t41 / 0.3e1 - t48 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t59 * t60 + 0.2e1 * t66 * t67 - t70 * t80
  t84 = 0.1e1 / t63 / t24
  t85 = t82 * t84
  t86 = t18 * t28
  t87 = t85 * t86
  t93 = -t59 * t35 / 0.6e1 - t70 * t40
  t94 = t93 * t84
  t95 = t40 * t28
  t96 = t94 * t95
  t99 = t18 * t47
  t100 = t94 * t99
  t103 = t94 * t86
  t107 = t4 * t6
  t108 = t33 * t26
  t112 = t12 * t65
  t116 = t12 * t26
  t122 = 0.1e1 / t3
  t123 = (t21 / 0.9e1 + t107 * t108 * t40 / 0.6e1 + t107 * t112 * t67 / 0.2e1 - t107 * t116 * t80 / 0.4e1) * t49 * t122
  t124 = t5 * t8
  t125 = t124 * t40
  t136 = (-t4 * t34 * t19 / 0.12e2 - t107 * t116 * t40 / 0.4e1) * t49 * t122
  t138 = t5 / t52
  t139 = t138 * t40
  t142 = t124 * t80
  t145 = t16 + 0.372744e1
  t146 = t145 ** 2
  t147 = t146 ** 2
  t149 = 0.1e1 / t147 / t145
  t150 = t149 * t1
  t151 = t150 * t3
  t152 = t7 * r0
  t154 = 0.1e1 / t8 / t152
  t155 = t6 * t154
  t156 = 0.1e1 / t146
  t158 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t156
  t159 = t158 ** 2
  t160 = 0.1e1 / t159
  t164 = t138 * t18
  t169 = t5 / t52 / r0
  t170 = t169 * t18
  t173 = t146 * t145
  t174 = 0.1e1 / t173
  t175 = t174 * t1
  t177 = 0.1e1 / t158
  t182 = t4 * t155 * t19
  t184 = t10 * t26
  t186 = t107 * t184 * t40
  t188 = t33 * t65
  t195 = t25 ** 2
  t196 = 0.1e1 / t195
  t197 = t12 * t196
  t198 = t67 * t40
  t202 = t40 * t80
  t206 = t4 * t155
  t207 = 0.7e1 / 0.27e2 * t206
  t211 = 0.1e1 / t16 / t51 / t138 / 0.4e1
  t212 = t211 * t2
  t213 = t7 ** 2
  t214 = 0.1e1 / t213
  t215 = t212 * t214
  t218 = 0.1e1 / t52 / t152
  t220 = t72 * t73 * t218
  t223 = t29 * t31 * t154
  t225 = -t207 - 0.12424800000000000000000000000000000000000000000000e1 * t215 + 0.82832000000000000000000000000000000000000000000000e0 * t220 - 0.96637333333333333333333333333333333333333333333333e0 * t223
  t231 = (-0.7e1 / 0.27e2 * t182 - t186 / 0.3e1 - t107 * t188 * t67 / 0.2e1 + t107 * t108 * t80 / 0.4e1 - 0.3e1 / 0.2e1 * t107 * t197 * t198 + 0.3e1 / 0.2e1 * t107 * t112 * t202 - t107 * t116 * t225 / 0.4e1) * t49 * t122
  t232 = t124 * t18
  t236 = t156 * t47 * t49
  t241 = 0.12920303615392498951680525761408286540065797999268e-2 * t87 * t35 + 0.12920303615392498951680525761408286540065797999268e-2 * t96 * t35 + 0.43067678717974996505601752538027621800219326664227e-3 * t100 * t56 - 0.86135357435949993011203505076055243600438653328453e-3 * t103 * t60 + 0.82908533333333333333333333333333333333333333333336e-1 * t123 * t125 + 0.27636177777777777777777777777777777777777777777779e-1 * t136 * t139 + 0.41454266666666666666666666666666666666666666666668e-1 * t136 * t142 + 0.73578453447456598426849645372188715149258983353495e1 * t151 * t155 * t160 + 0.27636177777777777777777777777777777777777777777779e-1 * t123 * t164 - 0.92120592592592592592592592592592592592592592592596e-2 * t136 * t170 - 0.19441031218901976532597921525897358463476063416235e0 * t175 * t3 * t155 * t177 + 0.41454266666666666666666666666666666666666666666668e-1 * t231 * t232 - 0.42416795386695221525668192420139691193038683817240e0 * t236 * t73 * t218 * t177
  t243 = t156 * t28 * t1
  t248 = 0.1e1 / t147
  t249 = t248 * t49
  t250 = t249 * t50
  t251 = t5 * t218
  t252 = t177 * t28
  t257 = 0.1e1 / t147 / t146
  t258 = t257 * t49
  t259 = t258 * t50
  t260 = t160 * t28
  t264 = 0.1e1 / t50
  t265 = t175 * t264
  t266 = t2 * t177
  t270 = t150 * t264
  t271 = t2 * t160
  t275 = t147 ** 2
  t276 = 0.1e1 / t275
  t277 = t276 * t49
  t278 = t277 * t50
  t280 = 0.1e1 / t159 / t158
  t281 = t280 * t28
  t285 = t63 ** 2
  t286 = 0.1e1 / t285
  t287 = t93 * t286
  t288 = t287 * t18
  t291 = jnp.pi ** 2
  t292 = 0.1e1 / t291
  t293 = t16 + 0.113107e1
  t294 = t293 ** 2
  t295 = 0.1e1 / t294
  t296 = t295 * t211
  t297 = t2 * t214
  t299 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t295
  t300 = 0.1e1 / t299
  t304 = t294 ** 2
  t306 = 0.1e1 / t304 / t293
  t307 = t306 * t1
  t309 = t299 ** 2
  t310 = 0.1e1 / t309
  t315 = t15 + 0.56553500000000000000000000000000000000000000000000e0 * t16 + 0.130045e2
  t316 = 0.1e1 / t315
  t320 = t315 ** 2
  t321 = 0.1e1 / t320
  t322 = t12 * t321
  t324 = -t36 - 0.94255833333333333333333333333333333333333333333334e-1 * t38
  t330 = (-t4 * t34 * t316 / 0.12e2 - t107 * t322 * t324 / 0.4e1) * t49 * t122
  t333 = t71 - 0.62837222222222222222222222222222222222222222222223e-1 * t75 + 0.12567444444444444444444444444444444444444444444445e0 * t78
  t334 = t124 * t333
  t338 = t4 * t11 * t316
  t340 = t33 * t321
  t345 = 0.1e1 / t320 / t315
  t346 = t12 * t345
  t347 = t324 ** 2
  t356 = (t338 / 0.9e1 + t107 * t340 * t324 / 0.6e1 + t107 * t346 * t347 / 0.2e1 - t107 * t322 * t333 / 0.4e1) * t49 * t122
  t357 = t124 * t324
  t360 = t138 * t324
  t364 = t4 * t155 * t316
  t366 = t10 * t321
  t368 = t107 * t366 * t324
  t370 = t33 * t345
  t377 = t320 ** 2
  t378 = 0.1e1 / t377
  t379 = t12 * t378
  t380 = t347 * t324
  t384 = t324 * t333
  t391 = -t207 - 0.37702333333333333333333333333333333333333333333334e0 * t215 + 0.25134888888888888888888888888888888888888888888890e0 * t220 - 0.29324037037037037037037037037037037037037037037038e0 * t223
  t397 = (-0.7e1 / 0.27e2 * t364 - t368 / 0.3e1 - t107 * t370 * t347 / 0.2e1 + t107 * t340 * t333 / 0.4e1 - 0.3e1 / 0.2e1 * t107 * t379 * t380 + 0.3e1 / 0.2e1 * t107 * t346 * t384 - t107 * t322 * t391 / 0.4e1) * t49 * t122
  t398 = t124 * t315
  t401 = t23 + 0.47584e-2
  t402 = t401 * t316
  t403 = t402 * t28
  t406 = t401 ** 2
  t407 = t406 * t321
  t409 = -t403 * t35 / 0.6e1 - t407 * t324
  t411 = 0.1e1 / t406 / t401
  t412 = t409 * t411
  t413 = t315 * t28
  t414 = t412 * t413
  t419 = t401 * t345
  t420 = t419 * t29
  t424 = t401 * t321
  t425 = t424 * t72
  t430 = t424 * t29
  t440 = t1 * t264 * t6
  t441 = t154 * t2
  t447 = t402 * t47
  t448 = t51 * t251
  t453 = t406 * t378
  t456 = t406 * t345
  t460 = -0.11e2 / 0.216e3 * t364 - t368 / 0.24e2 - t420 * t31 * t33 * t347 + t425 * t73 * t54 * t324 / 0.3e1 - 0.2e1 / 0.3e1 * t430 * t31 * t10 * t324 + t430 * t31 * t33 * t333 / 0.2e1 + t440 * t441 * t316 / 0.432e3 - 0.2e1 / 0.3e1 * t402 * t215 + 0.4e1 / 0.9e1 * t447 * t448 - 0.14e2 / 0.27e2 * t403 * t206 - 0.6e1 * t453 * t380 + 0.6e1 * t456 * t384 - t407 * t391
  t461 = 0.1e1 / t406
  t462 = t460 * t461
  t466 = t33 * t324
  t477 = t338 / 0.72e2 + t430 * t31 * t466 / 0.3e1 - t447 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t403 * t60 + 0.2e1 * t456 * t347 - t407 * t333
  t478 = t477 * t461
  t481 = t409 * t461
  t485 = t295 * t47 * t49
  t491 = t295 * t28 * t1
  t496 = 0.15087124812358469189006280566794884950190836019297e1 * t296 * t297 * t300 + 0.23390302462324474051432516353486737824307380234560e2 * t307 * t3 * t155 * t310 + t330 * t334 / 0.3e1 + 0.2e1 / 0.3e1 * t356 * t357 + 0.2e1 / 0.9e1 * t330 * t360 + t397 * t398 / 0.3e1 - 0.92007509840458388018616109955842440309603473153646e-4 * t414 * t60 + 0.41403379428206274608377249480129098139321562919141e-3 * t462 * t315 + 0.82806758856412549216754498960258196278643125838282e-3 * t478 * t324 + 0.41403379428206274608377249480129098139321562919141e-3 * t481 * t333 - 0.10058083208238979459337520377863256633460557346198e1 * t485 * t73 * t218 * t300 + 0.11734430409612142702560440440840466072370650237231e1 * t491 * t31 * t154 * t300
  t497 = t477 * t411
  t498 = t497 * t413
  t501 = t324 * t28
  t502 = t412 * t501
  t505 = t315 * t47
  t506 = t412 * t505
  t509 = t138 * t315
  t512 = t169 * t315
  t515 = t294 * t293
  t516 = 0.1e1 / t515
  t517 = t516 * t1
  t522 = 0.1e1 / t304
  t523 = t522 * t49
  t524 = t523 * t50
  t525 = t300 * t28
  t530 = 0.1e1 / t304 / t294
  t531 = t530 * t49
  t532 = t531 * t50
  t533 = t310 * t28
  t537 = t517 * t264
  t538 = t2 * t300
  t542 = t307 * t264
  t543 = t2 * t310
  t547 = t304 ** 2
  t548 = 0.1e1 / t547
  t549 = t548 * t49
  t550 = t549 * t50
  t552 = 0.1e1 / t309 / t299
  t553 = t552 * t28
  t557 = t406 ** 2
  t558 = 0.1e1 / t557
  t559 = t409 * t558
  t560 = t559 * t315
  t563 = 0.13801126476068758202792416493376366046440520973047e-3 * t498 * t35 + 0.13801126476068758202792416493376366046440520973047e-3 * t502 * t35 + 0.46003754920229194009308054977921220154801736576823e-4 * t506 * t56 + 0.2e1 / 0.9e1 * t356 * t509 - 0.2e1 / 0.27e2 * t330 * t512 - 0.46099548037761989188630301731873259570027554503406e0 * t517 * t3 * t155 * t300 + 0.25145208020597448648343800944658141583651393365494e0 * t524 * t251 * t525 - 0.29769475861140239701823202631710393594573029389440e2 * t532 * t251 * t533 + 0.20954340017164540540286500787215117986376161137912e-1 * t537 * t155 * t538 - 0.10631955664692942750651143797039426283776081924800e1 * t542 * t155 * t543 + 0.86312224513605868227832795632565231845861115350066e3 * t550 * t251 * t553 + 0.17251408095085947753490520616720457558050651216309e-4 * t560 * t60
  t567 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t569 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t567 * f.p.zeta_threshold, 1)
  t572 = 2 ** (0.1e1 / 0.3e1)
  t573 = t572 - 0.1e1
  t578 = 0.9e1 * t569 - 0.9e1
  t581 = t156 * t211
  t587 = t24 * t65
  t588 = t587 * t29
  t592 = t27 * t72
  t614 = t63 * t196
  t620 = -0.11e2 / 0.216e3 * t182 - t186 / 0.24e2 - t588 * t31 * t33 * t67 + t592 * t73 * t54 * t40 / 0.3e1 - 0.2e1 / 0.3e1 * t30 * t31 * t10 * t40 + t30 * t31 * t33 * t80 / 0.2e1 + t440 * t441 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t45 * t215 + 0.4e1 / 0.9e1 * t48 * t448 - 0.14e2 / 0.27e2 * t59 * t206 - 0.6e1 * t614 * t198 + 0.6e1 * t66 * t202 - t70 * t225
  t621 = 0.1e1 / t63
  t622 = t620 * t621
  t628 = t122 * t5
  t631 = 0.1e1 / t52 / t213
  t632 = t631 * t2
  t644 = 0.1e1 / t16 / t2 * r0 / 0.48e2
  t646 = t213 * r0
  t648 = 0.1e1 / t8 / t646
  t649 = t2 * t648
  t672 = t73 * t218 * t28
  t683 = 0.96902277115443742137603943210562149050493484994510e-3 * t85 * t95 * t35 + 0.44184161861140855755904367104312178326081962309624e-2 * t249 * t628 * t632 * t252 - 0.39018876828196680983935418000403106518546430566246e0 * t258 * t628 * t632 * t260 + 0.13255248558342256726771310131293653497824588692887e0 * t156 * t644 * t649 * t177 * t1 * t31 - 0.64601518076962494758402628807041432700328989996340e-3 * t87 * t60 - 0.64601518076962494758402628807041432700328989996340e-3 * t96 * t60 + 0.32300759038481247379201314403520716350164494998170e-3 * t85 * t99 * t56 + 0.84385547540419669500411480416977015085609841896189e1 * t277 * t628 * t632 * t281 + 0.53834598397468745632002190672534527250274158330283e-4 * t93 / t285 / t24 * t18 * t49 * t672 + 0.48451138557721871068801971605281074525246742497255e-3 * t620 * t84 * t86 * t35 + 0.50245625170970829256535377961032225433589214441597e-3 * t103 * t206 - 0.43067678717974996505601752538027621800219326664227e-3 * t100 * t448
  t687 = t264 * t6 * t441
  t699 = 0.1e1 / t646
  t740 = t159 ** 2
  t753 = 0.67293247996835932040002738340668159062842697912856e-5 * t287 * t18 * t1 * t687 + 0.48451138557721871068801971605281074525246742497255e-3 * t94 * t80 * t28 * t35 + 0.32300759038481247379201314403520716350164494998170e-3 * t94 * t40 * t47 * t56 - 0.46822652193836017180722501600483727822255716679496e1 * t257 * t2 * t699 * t160 * t47 + 0.53020994233369026907085240525174613991298354771548e-1 * t248 * t2 * t699 * t177 * t47 + 0.10363566666666666666666666666666666666666666666667e-1 * t231 * t164 - 0.69090444444444444444444444444444444444444444444446e-2 * t136 * t169 * t40 + 0.17673664744456342302361746841724871330432784923849e-1 * t149 * t2 * t631 * t177 * t49 * t628 - 0.26755801253620581246127143771704987327003266673998e1 / t147 / t173 * t2 * t631 * t160 * t49 * t628 + 0.12657832131062950425061722062546552262841476284429e3 / t275 / t145 * t2 * t631 * t280 * t49 * t628 - 0.19162434373246948642083122762742588170998040494372e4 / t275 / t173 * t2 * t631 / t740 * t49 * t628 + 0.12112784639430467767200492901320268631311685624314e-3 * t82 * t286 * t18 * t60 + 0.12112784639430467767200492901320268631311685624314e-3 * t287 * t40 * t60
  t756 = 0.1e1 / t8 / t213
  t757 = t6 * t756
  t764 = t5 * t631
  t785 = t4 * t757 * t19
  t789 = t107 * t154 * t26 * t40
  t793 = t107 * t10 * t65 * t67
  t796 = t107 * t184 * t80
  t809 = 0.1e1 / t195 / t18
  t811 = t67 ** 2
  t815 = t67 * t80
  t819 = t80 ** 2
  t823 = t40 * t225
  t827 = t4 * t757
  t828 = 0.70e2 / 0.81e2 * t827
  t829 = t644 * t2
  t831 = t829 * t648 * t107
  t833 = t212 * t699
  t836 = t72 * t73 * t631
  t839 = t29 * t31 * t756
  t841 = t828 - 0.10354000000000000000000000000000000000000000000000e1 * t831 + 0.99398400000000000000000000000000000000000000000000e1 * t833 - 0.36814222222222222222222222222222222222222222222222e1 * t836 + 0.32212444444444444444444444444444444444444444444444e1 * t839
  t845 = 0.70e2 / 0.81e2 * t785 + 0.28e2 / 0.27e2 * t789 + 0.4e1 / 0.3e1 * t793 - 0.2e1 / 0.3e1 * t796 + 0.2e1 * t107 * t33 * t196 * t198 - 0.2e1 * t107 * t188 * t202 + t107 * t108 * t225 / 0.3e1 + 0.6e1 * t107 * t12 * t809 * t811 - 0.9e1 * t107 * t197 * t815 + 0.3e1 / 0.2e1 * t107 * t112 * t819 + 0.2e1 * t107 * t112 * t823 - t107 * t116 * t841 / 0.4e1
  t860 = -0.16200859349084980443831601271581132052896719513529e-1 * t265 * t757 * t266 + 0.61315377872880498689041371143490595957715819461244e0 * t270 * t757 * t271 + 0.17168305804406539632931583920177366868160429449149e2 * t259 * t764 * t260 - 0.37129640917784654580181051383469886637668330434323e3 * t278 * t764 * t281 - 0.41238551070398132038844075964024699771009831488983e0 * t243 * t31 * t756 * t177 - 0.19441031218901976532597921525897358463476063416234e0 * t250 * t764 * t252 + 0.47129772651883579472964658244599656881154093130267e0 * t236 * t73 * t631 * t177 - 0.14804514559303905048800602434946994993825393540828e-3 * t288 * t206 + 0.10363566666666666666666666666666666666666666666667e-1 * t845 * t49 * t122 * t232 - 0.77340987998746992664586274965084728992118817729523e1 * t151 * t757 * t160 + 0.31090700000000000000000000000000000000000000000001e-1 * t123 * t142 + 0.31090700000000000000000000000000000000000000000001e-1 * t231 * t125 + 0.64601518076962494758402628807041432700328989996342e-3 * t94 * t18 * t215
  t922 = 0.20701689714103137304188624740064549069660781459570e-3 * t460 * t411 * t413 * t35 + 0.41403379428206274608377249480129098139321562919141e-3 * t497 * t501 * t35 - 0.27602252952137516405584832986752732092881041946094e-3 * t498 * t60 - 0.27602252952137516405584832986752732092881041946094e-3 * t502 * t60 - 0.18401501968091677603723221991168488061920694630729e-3 * t506 * t448 + 0.12572604010298724324171900472329070791825696682747e1 * t295 * t644 * t649 * t300 * t1 * t31 + 0.21468418962773623871010425656363236072240810402517e-3 * t414 * t206 + 0.23001877460114597004654027488960610077400868288412e-4 * t409 / t557 / t401 * t315 * t49 * t672 + 0.41908680034329081080573001574430235972752322275824e-1 * t523 * t628 * t632 * t525 - 0.49615793101900399503038671052850655990955048982400e1 * t531 * t628 * t632 * t533 + 0.14385370752267644704638799272094205307643519225011e3 * t549 * t628 * t632 * t553 + 0.28752346825143246255817534361200762596751085360514e-5 * t559 * t315 * t1 * t687
  t934 = t2 * t699
  t963 = t4 * t757 * t316
  t967 = t107 * t154 * t321 * t324
  t971 = t107 * t10 * t345 * t347
  t974 = t107 * t366 * t333
  t987 = 0.1e1 / t377 / t315
  t989 = t347 ** 2
  t993 = t347 * t333
  t997 = t333 ** 2
  t1001 = t324 * t391
  t1009 = t828 - 0.31418611111111111111111111111111111111111111111112e0 * t831 + 0.30161866666666666666666666666666666666666666666668e1 * t833 - 0.11171061728395061728395061728395061728395061728396e1 * t836 + 0.97746790123456790123456790123456790123456790123460e0 * t839
  t1013 = 0.70e2 / 0.81e2 * t963 + 0.28e2 / 0.27e2 * t967 + 0.4e1 / 0.3e1 * t971 - 0.2e1 / 0.3e1 * t974 + 0.2e1 * t107 * t33 * t378 * t380 - 0.2e1 * t107 * t370 * t384 + t107 * t340 * t391 / 0.3e1 + 0.6e1 * t107 * t12 * t987 * t989 - 0.9e1 * t107 * t379 * t993 + 0.3e1 / 0.2e1 * t107 * t346 * t997 + 0.2e1 * t107 * t346 * t1001 - t107 * t322 * t1009 / 0.4e1
  t1021 = t648 * t1 * t31
  t1062 = t756 * t2
  t1066 = -0.5e1 / 0.9e1 * t402 * t829 * t1021 + 0.56e2 / 0.27e2 * t430 * t31 * t154 * t324 + 0.4e1 * t401 * t378 * t29 * t31 * t33 * t380 + 0.8e1 / 0.3e1 * t420 * t31 * t10 * t347 - 0.16e2 / 0.9e1 * t425 * t73 * t218 * t324 - 0.4e1 / 0.3e1 * t419 * t72 * t73 * t54 * t347 + 0.2e1 / 0.3e1 * t425 * t73 * t54 * t333 - 0.4e1 / 0.3e1 * t430 * t31 * t10 * t333 + 0.2e1 / 0.3e1 * t430 * t31 * t33 * t391 + 0.16e2 / 0.3e1 * t402 * t833 + 0.185e3 / 0.864e3 * t963 - 0.11e2 / 0.648e3 * t440 * t1062 * t316
  t1080 = t51 * t764
  t1097 = t971 / 0.6e1 + 0.8e1 / 0.3e1 * t424 * t211 * t297 * t324 - t974 / 0.12e2 + 0.11e2 / 0.54e2 * t967 - t440 * t441 * t321 * t324 / 0.108e3 + 0.140e3 / 0.81e2 * t403 * t827 - 0.160e3 / 0.81e2 * t447 * t1080 - 0.4e1 * t420 * t31 * t466 * t333 - 0.36e2 * t453 * t993 + 0.8e1 * t456 * t1001 + 0.6e1 * t456 * t997 + 0.24e2 * t406 * t987 * t989 - t407 * t1009
  t1102 = 0.13801126476068758202792416493376366046440520973047e-3 * t497 * t505 * t56 + 0.13801126476068758202792416493376366046440520973047e-3 * t412 * t324 * t47 * t56 + 0.20701689714103137304188624740064549069660781459570e-3 * t412 * t333 * t28 * t35 - 0.12069699849886775351205024453435907960152668815438e2 * t296 * t934 * t300 + 0.17262444902721173645566559126513046369172223070013e4 * t548 * t2 * t699 * t552 * t47 + 0.50290416041194897296687601889316283167302786730988e0 * t522 * t2 * t699 * t300 * t47 - 0.59538951722280479403646405263420787189146058778880e2 * t530 * t2 * t699 * t310 * t47 + 0.19382764515877199999765013228173984137397949052568e1 * t516 * t756 * t300 * t107 - 0.98345589898409720443523080122614693124928757804400e2 * t306 * t756 * t310 * t107 + t356 * t334 + t1013 * t49 * t122 * t398 / 0.3e1 + t397 * t357 + 0.41403379428206274608377249480129098139321562919141e-3 * (t1066 + t1097) * t461 * t315
  t1135 = 0.41403379428206274608377249480129098139321562919141e-3 * t481 * t391 + 0.12421013828461882382513174844038729441796468875742e-2 * t478 * t333 + 0.12421013828461882382513174844038729441796468875742e-2 * t462 * t324 + t330 * t124 * t391 / 0.3e1 + 0.2e1 / 0.3e1 * t356 * t360 - 0.2e1 / 0.9e1 * t330 * t169 * t324 + 0.27602252952137516405584832986752732092881041946094e-3 * t412 * t315 * t215 - 0.2e1 / 0.9e1 * t356 * t512 + 0.10e2 / 0.81e2 * t330 * t55 * t315 + t397 * t509 / 0.3e1 + t330 * t138 * t333 / 0.3e1 - 0.39114768032040475675201468136134886907902167457437e1 * t491 * t31 * t756 * t300
  t1162 = t309 ** 2
  t1196 = 0.16763472013731632432229200629772094389100928910329e0 * t306 * t2 * t631 * t300 * t49 * t628 - 0.34022258127017416802083660150526164108083462159360e2 / t304 / t515 * t2 * t631 * t310 * t49 * t628 + 0.21578056128401467056958198908141307961465278837517e4 / t547 / t293 * t2 * t631 * t552 * t49 * t628 - 0.43793683962271420729973795871593892966464398384137e5 / t547 / t515 * t2 * t631 / t1162 * t49 * t628 - 0.18439819215104795675452120692749303828011021801362e1 * t524 * t764 * t525 + 0.51754224285257843260471561850161372674151953648927e-4 * t477 * t558 * t315 * t60 + 0.51754224285257843260471561850161372674151953648927e-4 * t559 * t324 * t60 - 0.15366516012587329729543433910624419856675851501136e0 * t537 * t757 * t538 + 0.77967674874414913504775054511622459414357934115200e1 * t542 * t757 * t543 - 0.63255163015315141762798575594641677712852387793133e-4 * t560 * t206 + 0.21830948964836175781337015263254288636020221552256e3 * t532 * t764 * t533 - 0.63295631309977636700410716797214503353631484590049e4 * t550 * t764 * t553 + 0.44702592036617686485944535012725585037602477094213e1 * t485 * t73 * t631 * t300
  t1253 = 0.4e1 * t24 * t196 * t29 * t31 * t33 * t198 + 0.8e1 / 0.3e1 * t588 * t31 * t10 * t67 - 0.16e2 / 0.9e1 * t592 * t73 * t218 * t40 + 0.56e2 / 0.27e2 * t30 * t31 * t154 * t40 - 0.4e1 / 0.3e1 * t587 * t72 * t73 * t54 * t67 + 0.2e1 / 0.3e1 * t592 * t73 * t54 * t80 - 0.4e1 / 0.3e1 * t30 * t31 * t10 * t80 + 0.2e1 / 0.3e1 * t30 * t31 * t33 * t225 - 0.5e1 / 0.9e1 * t45 * t829 * t1021 + t793 / 0.6e1 - t796 / 0.12e2 - 0.11e2 / 0.648e3 * t440 * t1062 * t19
  t1284 = 0.8e1 / 0.3e1 * t27 * t211 * t297 * t40 + 0.11e2 / 0.54e2 * t789 - 0.4e1 * t588 * t31 * t41 * t80 - 0.36e2 * t614 * t815 + 0.8e1 * t66 * t823 + 0.16e2 / 0.3e1 * t45 * t833 + 0.185e3 / 0.864e3 * t785 - t70 * t841 + 0.24e2 * t63 * t809 * t811 + 0.6e1 * t66 * t819 - t440 * t441 * t26 * t40 / 0.108e3 - 0.160e3 / 0.81e2 * t48 * t1080 + 0.140e3 / 0.81e2 * t59 * t827
  t1289 = t82 * t621
  t1292 = t93 * t621
  t1297 = 0.20727133333333333333333333333333333333333333333334e-1 * t123 * t139 + 0.20435174860777645787105769785744382475812907568201e0 * t174 * t756 * t177 * t107 - 0.69090444444444444444444444444444444444444444444446e-2 * t123 * t170 + 0.38383580246913580246913580246913580246913580246915e-2 * t136 * t55 * t18 + 0.10363566666666666666666666666666666666666666666667e-1 * t136 * t124 * t225 + 0.10363566666666666666666666666666666666666666666667e-1 * t136 * t138 * t80 - t292 * (t922 + t1102 + t1135 + t1196) * t578 / 0.24e2 - 0.12725038616008566457700457726041907357911605145172e1 * t581 * t934 * t177 + 0.10126265704850360340049377650037241810273181027543e3 * t276 * t2 * t699 * t280 * t47 + 0.96902277115443742137603943210562149050493484994510e-3 * (t1253 + t1284) * t621 * t18 + 0.29070683134633122641281182963168644715148045498353e-2 * t1289 * t80 + 0.96902277115443742137603943210562149050493484994510e-3 * t1292 * t225 + 0.29070683134633122641281182963168644715148045498353e-2 * t622 * t40
  t1305 = 0.49486261284477758446612891156829639725211797786780e0 * t243 * t31 * t154 * t177 + 0.10604198846673805381417048105034922798259670954310e0 * t250 * t251 * t252 - 0.93645304387672034361445003200967455644511433358993e1 * t259 * t251 * t260 + 0.88368323722281711511808734208624356652163924619249e-2 * t265 * t155 * t266 - 0.33444751567025726557658929714631234158754083342496e0 * t270 * t155 * t271 + 0.20252531409700720680098755300074483620546362055085e3 * t278 * t251 * t281 + 0.16150379519240623689600657201760358175082247499085e-3 * t288 * t60 - t292 * (t496 + t563) * t578 / 0.6e1 + 0.63625193080042832288502288630209536789558025725859e0 * t581 * t297 * t177 + 0.38760910846177496855041577284224859620197393997804e-2 * t622 * t18 + r0 * (t683 + t753 + t860 + t1297) + 0.77521821692354993710083154568449719240394787995608e-2 * t1289 * t40 + 0.38760910846177496855041577284224859620197393997804e-2 * t1292 * t80
  v4rho4_0_ = t241 + t1305

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t23 = t4 * t6
  t24 = t18 ** 2
  t25 = 0.1e1 / t24
  t26 = t12 * t25
  t27 = t4 * t11
  t28 = t27 / 0.12e2
  t29 = 0.1e1 / t16
  t30 = t29 * t1
  t31 = t3 * t6
  t33 = t30 * t31 * t10
  t35 = -t28 - 0.31062000000000000000000000000000000000000000000000e0 * t33
  t40 = t1 ** 2
  t42 = 0.1e1 / t3
  t43 = (-t4 * t11 * t19 / 0.12e2 - t23 * t26 * t35 / 0.4e1) * t40 * t42
  t44 = t5 * t8
  t45 = t44 * t18
  t46 = t43 * t45
  t47 = 0.20727133333333333333333333333333333333333333333334e-1 * t46
  t48 = t16 + 0.372744e1
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t52 = t50 * t29 * t1
  t54 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t50
  t55 = 0.1e1 / t54
  t58 = t52 * t31 * t10 * t55
  t59 = 0.79531491350053540360627860787761920986947532157324e-1 * t58
  t60 = t16 / 0.2e1
  t61 = t60 + 0.10498e0
  t62 = t61 * t19
  t63 = t62 * t29
  t66 = t61 ** 2
  t67 = t66 * t25
  t69 = -t63 * t27 / 0.6e1 - t67 * t35
  t70 = 0.1e1 / t66
  t71 = t69 * t70
  t72 = t71 * t18
  t73 = 0.19380455423088748427520788642112429810098696998902e-2 * t72
  t74 = jnp.pi ** 2
  t75 = 0.1e1 / t74
  t77 = t15 + 0.56553500000000000000000000000000000000000000000000e0 * t16 + 0.130045e2
  t78 = 0.1e1 / t77
  t82 = t77 ** 2
  t83 = 0.1e1 / t82
  t84 = t12 * t83
  t86 = -t28 - 0.94255833333333333333333333333333333333333333333334e-1 * t33
  t92 = (-t4 * t11 * t78 / 0.12e2 - t23 * t84 * t86 / 0.4e1) * t40 * t42
  t93 = t44 * t77
  t96 = t16 + 0.113107e1
  t97 = t96 ** 2
  t98 = 0.1e1 / t97
  t100 = t98 * t29 * t1
  t102 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t98
  t103 = 0.1e1 / t102
  t108 = t60 + 0.47584e-2
  t109 = t108 * t78
  t110 = t109 * t29
  t113 = t108 ** 2
  t114 = t113 * t83
  t116 = -t110 * t27 / 0.6e1 - t114 * t86
  t117 = 0.1e1 / t113
  t118 = t116 * t117
  t122 = t75 * (t92 * t93 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t100 * t31 * t10 * t103 + 0.41403379428206274608377249480129098139321562919141e-3 * t118 * t77)
  t123 = r0 - r1
  t124 = 0.1e1 / t7
  t125 = t123 * t124
  t126 = 0.1e1 + t125
  t127 = t126 <= f.p.zeta_threshold
  t128 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t129 = t128 * f.p.zeta_threshold
  t130 = t126 ** (0.1e1 / 0.3e1)
  t132 = f.my_piecewise3(t127, t129, t130 * t126)
  t133 = 0.1e1 - t125
  t134 = t133 <= f.p.zeta_threshold
  t135 = t133 ** (0.1e1 / 0.3e1)
  t137 = f.my_piecewise3(t134, t129, t135 * t133)
  t138 = t132 + t137 - 0.2e1
  t139 = t122 * t138
  t140 = 2 ** (0.1e1 / 0.3e1)
  t141 = t140 - 0.1e1
  t143 = 0.1e1 / t141 / 0.2e1
  t144 = t123 ** 2
  t145 = t144 ** 2
  t146 = t7 ** 2
  t147 = t146 ** 2
  t148 = 0.1e1 / t147
  t152 = 0.9e1 * t141
  t153 = t143 * (-t145 * t148 + 0.1e1) * t152
  t155 = t139 * t153 / 0.12e2
  t159 = jnp.log(t4 * t13 * t78 / 0.4e1)
  t162 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t96)
  t165 = jnp.log(t113 * t78)
  t168 = t75 * (t159 + 0.31770800474394146398819696256107927053514547209957e0 * t162 + 0.41403379428206274608377249480129098139321562919141e-3 * t165)
  t169 = 0.1e1 / t146
  t170 = t123 * t169
  t171 = t124 - t170
  t174 = f.my_piecewise3(t127, 0, 0.4e1 / 0.3e1 * t130 * t171)
  t175 = -t171
  t178 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t175)
  t179 = t174 + t178
  t180 = t168 * t179
  t181 = t180 * t153
  t183 = t168 * t138
  t184 = t144 * t123
  t185 = t184 * t148
  t187 = 0.1e1 / t147 / t7
  t188 = t145 * t187
  t192 = t143 * (-0.4e1 * t185 + 0.4e1 * t188) * t152
  t193 = t183 * t192
  t196 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t197 = 0.1e1 / t196
  t201 = t196 ** 2
  t202 = 0.1e1 / t201
  t203 = t12 * t202
  t205 = -t28 - 0.58836833333333333333333333333333333333333333333333e0 * t33
  t211 = (-t4 * t11 * t197 / 0.12e2 - t23 * t203 * t205 / 0.4e1) * t40 * t42
  t212 = t44 * t196
  t215 = t16 + 0.706042e1
  t216 = t215 ** 2
  t217 = 0.1e1 / t216
  t219 = t217 * t29 * t1
  t221 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t217
  t222 = 0.1e1 / t221
  t227 = t60 + 0.32500e0
  t228 = t227 * t197
  t229 = t228 * t29
  t232 = t227 ** 2
  t233 = t232 * t202
  t235 = -t229 * t27 / 0.6e1 - t233 * t205
  t236 = 0.1e1 / t232
  t237 = t235 * t236
  t243 = 0.51817833333333333333333333333333333333333333333333e-2 * t211 * t212 + 0.41388824077869423260215065147117773567486474051458e-1 * t219 * t31 * t10 * t222 + 0.22478670955426118383265363956423012380560746650571e-2 * t237 * t196 - 0.10363566666666666666666666666666666666666666666667e-1 * t46 - 0.39765745675026770180313930393880960493473766078662e-1 * t58 - 0.96902277115443742137603943210562149050493484994510e-3 * t72
  t244 = t243 * t138
  t245 = t143 * t145
  t246 = t245 * t148
  t248 = 0.2e1 * t244 * t246
  t252 = jnp.log(t4 * t13 * t197 / 0.4e1)
  t256 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t215)
  t259 = jnp.log(t232 * t197)
  t264 = jnp.log(t4 * t13 * t19 / 0.4e1)
  t268 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t48)
  t271 = jnp.log(t66 * t19)
  t273 = 0.1554535e-1 * t252 + 0.52491393169780936217021346072241076933841385384497e-1 * t256 + 0.22478670955426118383265363956423012380560746650571e-2 * t259 - 0.310907e-1 * t264 - 0.38783294878113014394824731224995739188004877421366e-1 * t268 - 0.96902277115443742137603943210562149050493484994510e-3 * t271
  t274 = t273 * t179
  t275 = t274 * t246
  t277 = t273 * t138
  t278 = t143 * t184
  t279 = t278 * t148
  t281 = 0.8e1 * t277 * t279
  t282 = t245 * t187
  t284 = 0.8e1 * t277 * t282
  t286 = 0.1e1 / t8 / t146
  t287 = t6 * t286
  t289 = t4 * t287 * t78
  t296 = 0.1e1 / t82 / t77
  t298 = t86 ** 2
  t302 = t4 * t287
  t303 = t302 / 0.9e1
  t305 = 0.1e1 / t16 / t14
  t307 = t3 ** 2
  t308 = t307 * t5
  t309 = t8 ** 2
  t311 = 0.1e1 / t309 / t146
  t313 = t305 * t40 * t308 * t311
  t316 = t30 * t31 * t286
  t318 = t303 - 0.62837222222222222222222222222222222222222222222223e-1 * t313 + 0.12567444444444444444444444444444444444444444444445e0 * t316
  t328 = t5 / t309
  t352 = t97 ** 2
  t357 = t102 ** 2
  t372 = t40 * t307 * t5 * t311
  t398 = t75 * ((t289 / 0.9e1 + t23 * t10 * t83 * t86 / 0.6e1 + t23 * t12 * t296 * t298 / 0.2e1 - t23 * t84 * t318 / 0.4e1) * t40 * t42 * t93 / 0.3e1 + t92 * t328 * t77 / 0.9e1 + t92 * t44 * t86 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 / t97 / t96 * t1 * t3 * t287 * t103 + 0.25145208020597448648343800944658141583651393365495e0 * t98 * t305 * t40 * t308 * t311 * t103 - 0.50290416041194897296687601889316283167302786730989e0 * t100 * t31 * t286 * t103 - 0.63791733988157656503906862782236557702656491548799e1 / t352 / t96 * t1 * t3 * t287 / t357 + 0.41403379428206274608377249480129098139321562919141e-3 * (t289 / 0.72e2 + t108 * t83 * t30 * t31 * t10 * t86 / 0.3e1 - t109 * t305 * t372 / 0.9e1 + 0.2e1 / 0.9e1 * t110 * t302 + 0.2e1 * t113 * t296 * t298 - t114 * t318) * t117 * t77 + 0.69005632380343791013962082466881830232202604865235e-4 * t116 / t113 / t108 * t77 * t29 * t27 + 0.41403379428206274608377249480129098139321562919141e-3 * t118 * t86) * t138 * t153 / 0.24e2
  t400 = t122 * t179 * t153
  t402 = t139 * t192
  t404 = t130 ** 2
  t405 = 0.1e1 / t404
  t406 = t171 ** 2
  t410 = 0.1e1 / t146 / t7
  t411 = t123 * t410
  t413 = -0.2e1 * t169 + 0.2e1 * t411
  t417 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t405 * t406 + 0.4e1 / 0.3e1 * t130 * t413)
  t418 = t135 ** 2
  t419 = 0.1e1 / t418
  t420 = t175 ** 2
  t427 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t419 * t420 - 0.4e1 / 0.3e1 * t135 * t413)
  t428 = t417 + t427
  t433 = 0.1e1 / t147 / t146
  t436 = 0.20e2 * t277 * t245 * t433
  t443 = 0.16150379519240623689600657201760358175082247499085e-3 * t69 / t66 / t61 * t18 * t29 * t27
  t449 = 0.26510497116684513453542620262587306995649177385775e-1 * t50 * t305 * t40 * t308 * t311 * t55
  t453 = 0.53020994233369026907085240525174613991298354771549e-1 * t52 * t31 * t286 * t55
  t455 = t4 * t287 * t19
  t469 = 0.1e1 / t24 / t18
  t471 = t35 ** 2
  t476 = t303 - 0.20708000000000000000000000000000000000000000000000e0 * t313 + 0.41416000000000000000000000000000000000000000000000e0 * t316
  t481 = 0.96902277115443742137603943210562149050493484994510e-3 * (t455 / 0.72e2 + t61 * t25 * t30 * t31 * t10 * t35 / 0.3e1 - t62 * t305 * t372 / 0.9e1 + 0.2e1 / 0.9e1 * t63 * t302 + 0.2e1 * t66 * t469 * t471 - t67 * t476) * t70 * t18
  t483 = 0.96902277115443742137603943210562149050493484994510e-3 * t71 * t35
  t485 = 0.8e1 * t244 * t279
  t487 = 0.8e1 * t244 * t282
  t489 = t4 * t287 * t197
  t496 = 0.1e1 / t201 / t196
  t498 = t205 ** 2
  t504 = t303 - 0.39224555555555555555555555555555555555555555555555e0 * t313 + 0.78449111111111111111111111111111111111111111111110e0 * t316
  t536 = t216 ** 2
  t541 = t221 ** 2
  t591 = 0.10363566666666666666666666666666666666666666666667e-1 * (t455 / 0.9e1 + t23 * t10 * t25 * t35 / 0.6e1 + t23 * t12 * t469 * t471 / 0.2e1 - t23 * t26 * t476 / 0.4e1) * t40 * t42 * t45
  t594 = 0.34545222222222222222222222222222222222222222222223e-2 * t43 * t328 * t18
  t597 = 0.10363566666666666666666666666666666666666666666667e-1 * t43 * t44 * t35
  t604 = 0.13255248558342256726771310131293653497824588692887e-1 / t49 / t48 * t1 * t3 * t287 * t55
  t605 = t49 ** 2
  t610 = t54 ** 2
  t614 = 0.50167127350538589836488394571946851238131125013746e0 / t605 / t48 * t1 * t3 * t287 / t610
  t615 = 0.51817833333333333333333333333333333333333333333333e-2 * (t489 / 0.9e1 + t23 * t10 * t202 * t205 / 0.6e1 + t23 * t12 * t496 * t498 / 0.2e1 - t23 * t203 * t504 / 0.4e1) * t40 * t42 * t212 + 0.17272611111111111111111111111111111111111111111111e-2 * t211 * t328 * t196 + 0.51817833333333333333333333333333333333333333333333e-2 * t211 * t44 * t205 + 0.13796274692623141086738355049039257855828824683819e-1 / t216 / t215 * t1 * t3 * t287 * t222 + 0.27592549385246282173476710098078515711657649367639e-1 * t217 * t305 * t40 * t308 * t311 * t222 - 0.55185098770492564346953420196157031423315298735277e-1 * t219 * t31 * t286 * t222 - 0.30878365944746984533884071665444263610784010246137e0 / t536 / t215 * t1 * t3 * t287 / t541 + 0.22478670955426118383265363956423012380560746650571e-2 * (t489 / 0.72e2 + t227 * t202 * t30 * t31 * t10 * t205 / 0.3e1 - t228 * t305 * t372 / 0.9e1 + 0.2e1 / 0.9e1 * t229 * t302 + 0.2e1 * t232 * t496 * t498 - t233 * t504) * t236 * t196 + 0.37464451592376863972108939927371687300934577750952e-3 * t235 / t232 / t227 * t196 * t29 * t27 + 0.22478670955426118383265363956423012380560746650571e-2 * t237 * t205 - t591 - t594 - t597 - t604 - t449 + t453 + t614 - t481 - t443 - t483
  t617 = t615 * t138 * t246
  t618 = -t398 - t400 / 0.12e2 - t402 / 0.12e2 - t168 * t428 * t153 / 0.24e2 + t436 + t443 + t449 - t453 + t481 + t483 + t485 - t487 + t617
  t622 = 0.12e2 * t277 * t143 * t144 * t148
  t625 = 0.32e2 * t277 * t278 * t187
  t626 = t274 * t279
  t628 = t274 * t282
  t631 = t243 * t179 * t246
  t638 = 0.12e2 * t144 * t148
  t640 = 0.32e2 * t184 * t187
  t642 = 0.20e2 * t145 * t433
  t648 = t622 - t625 + 0.8e1 * t626 - 0.8e1 * t628 + 0.2e1 * t631 + t273 * t428 * t246 + t591 + t594 + t597 + t604 - t614 - t180 * t192 / 0.12e2 - t183 * t143 * (-t638 + t640 - t642) * t152 / 0.24e2
  d11 = t47 + t59 + t73 - t155 - t181 / 0.12e2 - t193 / 0.12e2 + t248 + 0.2e1 * t275 + t281 - t284 + t7 * (t618 + t648)
  t653 = -t124 - t170
  t656 = f.my_piecewise3(t127, 0, 0.4e1 / 0.3e1 * t130 * t653)
  t657 = -t653
  t660 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t657)
  t661 = t656 + t660
  t662 = t168 * t661
  t663 = t662 * t153
  t668 = t143 * (0.4e1 * t185 + 0.4e1 * t188) * t152
  t669 = t183 * t668
  t671 = t273 * t661
  t672 = t671 * t246
  t675 = t139 * t668
  t678 = t122 * t661 * t153
  t694 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t405 * t653 * t171 + 0.8e1 / 0.3e1 * t130 * t123 * t410)
  t702 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t419 * t657 * t175 - 0.8e1 / 0.3e1 * t135 * t123 * t410)
  t703 = t694 + t702
  t709 = t671 * t279
  t711 = t671 * t282
  t716 = t243 * t661 * t246
  t717 = -t662 * t192 / 0.24e2 - t675 / 0.24e2 - t678 / 0.24e2 - t180 * t668 / 0.24e2 - t183 * t143 * (t638 - t642) * t152 / 0.24e2 - t168 * t703 * t153 / 0.24e2 - t398 - t400 / 0.24e2 - t402 / 0.24e2 + 0.4e1 * t709 - 0.4e1 * t711 + t273 * t703 * t246 + t716 + t436 + t443
  t720 = t449 - t453 + t481 + t483 - t487 + t617 - t622 - 0.4e1 * t626 - 0.4e1 * t628 + t631 + t591 + t594 + t597 + t604 - t614
  d12 = t47 + t59 + t73 - t155 - t181 / 0.24e2 - t193 / 0.24e2 + t248 + t275 - t284 - t663 / 0.24e2 - t669 / 0.24e2 + t672 + t7 * (t717 + t720)
  t731 = t653 ** 2
  t735 = 0.2e1 * t169 + 0.2e1 * t411
  t739 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t405 * t731 + 0.4e1 / 0.3e1 * t130 * t735)
  t740 = t657 ** 2
  t747 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t419 * t740 - 0.4e1 / 0.3e1 * t135 * t735)
  t748 = t739 + t747
  t761 = -t183 * t143 * (-t638 - t640 - t642) * t152 / 0.24e2 - t168 * t748 * t153 / 0.24e2 - t662 * t668 / 0.12e2 - t675 / 0.12e2 - t678 / 0.12e2 - t398 + t273 * t748 * t246 - 0.8e1 * t709 - 0.8e1 * t711 + 0.2e1 * t716 + t436 + t443 + t449
  t762 = -t453 + t481 + t483 - t485 - t487 + t617 + t622 + t625 + t591 + t594 + t597 + t604 - t614
  d22 = t47 + t59 + t73 - t155 - t663 / 0.12e2 - t669 / 0.12e2 + t248 + 0.2e1 * t672 - t281 - t284 + t7 * (t761 + t762)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = jnp.pi ** 2
  t2 = 0.1e1 / t1
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / jnp.pi
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t3 * t5
  t7 = 4 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = r0 + r1
  t10 = t9 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t10
  t12 = t8 * t11
  t13 = t6 * t12
  t14 = t13 / 0.4e1
  t15 = jnp.sqrt(t13)
  t17 = t14 + 0.56553500000000000000000000000000000000000000000000e0 * t15 + 0.130045e2
  t18 = 0.1e1 / t17
  t22 = jnp.log(t6 * t12 * t18 / 0.4e1)
  t23 = t15 + 0.113107e1
  t26 = jnp.atan(0.71231089178181179907634622339714221951452652573438e1 / t23)
  t28 = t15 / 0.2e1
  t29 = t28 + 0.47584e-2
  t30 = t29 ** 2
  t32 = jnp.log(t30 * t18)
  t35 = t2 * (t22 + 0.31770800474394146398819696256107927053514547209957e0 * t26 + 0.41403379428206274608377249480129098139321562919141e-3 * t32)
  t36 = r0 - r1
  t37 = 0.1e1 / t9
  t38 = t36 * t37
  t39 = 0.1e1 + t38
  t40 = t39 <= f.p.zeta_threshold
  t41 = t39 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = t9 ** 2
  t45 = 0.1e1 / t44
  t47 = -t36 * t45 + t37
  t48 = t47 ** 2
  t51 = t44 * t9
  t52 = 0.1e1 / t51
  t55 = 0.2e1 * t36 * t52 - 0.2e1 * t45
  t59 = f.my_piecewise3(t40, 0, 0.4e1 / 0.9e1 * t43 * t48 + 0.4e1 / 0.3e1 * t41 * t55)
  t60 = 0.1e1 - t38
  t61 = t60 <= f.p.zeta_threshold
  t62 = t60 ** (0.1e1 / 0.3e1)
  t63 = t62 ** 2
  t64 = 0.1e1 / t63
  t65 = -t47
  t66 = t65 ** 2
  t69 = -t55
  t73 = f.my_piecewise3(t61, 0, 0.4e1 / 0.9e1 * t64 * t66 + 0.4e1 / 0.3e1 * t62 * t69)
  t74 = t59 + t73
  t75 = t35 * t74
  t76 = 2 ** (0.1e1 / 0.3e1)
  t77 = t76 - 0.1e1
  t79 = 0.1e1 / t77 / 0.2e1
  t80 = t36 ** 2
  t81 = t80 ** 2
  t82 = t44 ** 2
  t83 = 0.1e1 / t82
  t87 = 0.9e1 * t77
  t88 = t79 * (-t81 * t83 + 0.1e1) * t87
  t93 = f.my_piecewise3(t40, 0, 0.4e1 / 0.3e1 * t41 * t47)
  t96 = f.my_piecewise3(t61, 0, 0.4e1 / 0.3e1 * t62 * t65)
  t97 = t93 + t96
  t98 = t35 * t97
  t99 = t80 * t36
  t102 = 0.1e1 / t82 / t9
  t107 = t79 * (0.4e1 * t81 * t102 - 0.4e1 * t99 * t83) * t87
  t110 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t111 = t110 * f.p.zeta_threshold
  t113 = f.my_piecewise3(t40, t111, t41 * t39)
  t115 = f.my_piecewise3(t61, t111, t62 * t60)
  t116 = t113 + t115 - 0.2e1
  t117 = t35 * t116
  t123 = 0.1e1 / t82 / t44
  t128 = t79 * (0.32e2 * t99 * t102 - 0.20e2 * t81 * t123 - 0.12e2 * t80 * t83) * t87
  t132 = 0.1e1 / t10 / t44
  t133 = t8 * t132
  t135 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t15 + 0.129352e2
  t136 = 0.1e1 / t135
  t138 = t6 * t133 * t136
  t140 = t6 * t8
  t142 = 0.1e1 / t10 / t9
  t143 = t135 ** 2
  t144 = 0.1e1 / t143
  t145 = t142 * t144
  t146 = t8 * t142
  t147 = t6 * t146
  t148 = t147 / 0.12e2
  t149 = 0.1e1 / t15
  t150 = t149 * t3
  t151 = t5 * t8
  t153 = t150 * t151 * t142
  t155 = -t148 - 0.31062000000000000000000000000000000000000000000000e0 * t153
  t160 = 0.1e1 / t143 / t135
  t161 = t11 * t160
  t162 = t155 ** 2
  t166 = t11 * t144
  t167 = t6 * t133
  t168 = t167 / 0.9e1
  t170 = 0.1e1 / t15 / t13
  t171 = t3 ** 2
  t172 = t170 * t171
  t173 = t5 ** 2
  t174 = t173 * t7
  t175 = t10 ** 2
  t177 = 0.1e1 / t175 / t44
  t179 = t172 * t174 * t177
  t182 = t150 * t151 * t132
  t184 = t168 - 0.20708000000000000000000000000000000000000000000000e0 * t179 + 0.41416000000000000000000000000000000000000000000000e0 * t182
  t190 = 0.1e1 / t5
  t191 = (t138 / 0.9e1 + t140 * t145 * t155 / 0.6e1 + t140 * t161 * t162 / 0.2e1 - t140 * t166 * t184 / 0.4e1) * t171 * t190
  t192 = t7 * t10
  t193 = t192 * t135
  t194 = t191 * t193
  t204 = (-t6 * t146 * t136 / 0.12e2 - t140 * t166 * t155 / 0.4e1) * t171 * t190
  t206 = t7 / t175
  t207 = t206 * t135
  t208 = t204 * t207
  t210 = t192 * t155
  t211 = t204 * t210
  t213 = t15 + 0.372744e1
  t214 = t213 ** 2
  t217 = 0.1e1 / t214 / t213 * t3
  t218 = t217 * t5
  t219 = 0.1e1 / t214
  t221 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t219
  t222 = 0.1e1 / t221
  t224 = t218 * t133 * t222
  t226 = t214 ** 2
  t229 = 0.1e1 / t226 / t213 * t3
  t230 = t229 * t5
  t231 = t221 ** 2
  t232 = 0.1e1 / t231
  t234 = t230 * t133 * t232
  t237 = t6 * t133 * t18
  t239 = t17 ** 2
  t240 = 0.1e1 / t239
  t241 = t142 * t240
  t243 = -t148 - 0.94255833333333333333333333333333333333333333333334e-1 * t153
  t248 = 0.1e1 / t239 / t17
  t249 = t11 * t248
  t250 = t243 ** 2
  t254 = t11 * t240
  t257 = t168 - 0.62837222222222222222222222222222222222222222222223e-1 * t179 + 0.12567444444444444444444444444444444444444444444445e0 * t182
  t263 = (t237 / 0.9e1 + t140 * t241 * t243 / 0.6e1 + t140 * t249 * t250 / 0.2e1 - t140 * t254 * t257 / 0.4e1) * t171 * t190
  t264 = t192 * t17
  t275 = (-t6 * t146 * t18 / 0.12e2 - t140 * t254 * t243 / 0.4e1) * t171 * t190
  t276 = t206 * t17
  t279 = t192 * t243
  t282 = t23 ** 2
  t285 = 0.1e1 / t282 / t23 * t3
  t286 = t285 * t5
  t287 = 0.1e1 / t282
  t289 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t287
  t290 = 0.1e1 / t289
  t295 = t287 * t170 * t171
  t301 = t287 * t149 * t3
  t306 = t282 ** 2
  t309 = 0.1e1 / t306 / t23 * t3
  t310 = t309 * t5
  t311 = t289 ** 2
  t312 = 0.1e1 / t311
  t317 = t29 * t240
  t318 = t317 * t150
  t323 = t29 * t18
  t324 = t323 * t170
  t325 = t171 * t173
  t327 = t325 * t7 * t177
  t330 = t323 * t149
  t333 = t30 * t248
  t336 = t30 * t240
  t338 = t237 / 0.72e2 + t318 * t151 * t142 * t243 / 0.3e1 - t324 * t327 / 0.9e1 + 0.2e1 / 0.9e1 * t330 * t167 + 0.2e1 * t333 * t250 - t336 * t257
  t339 = 0.1e1 / t30
  t340 = t338 * t339
  t346 = -t330 * t147 / 0.6e1 - t336 * t243
  t348 = 0.1e1 / t30 / t29
  t349 = t346 * t348
  t350 = t17 * t149
  t351 = t349 * t350
  t354 = t346 * t339
  t358 = t2 * (t263 * t264 / 0.3e1 + t275 * t276 / 0.9e1 + t275 * t279 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 * t286 * t133 * t290 + 0.25145208020597448648343800944658141583651393365495e0 * t295 * t174 * t177 * t290 - 0.50290416041194897296687601889316283167302786730989e0 * t301 * t151 * t132 * t290 - 0.63791733988157656503906862782236557702656491548799e1 * t310 * t133 * t312 + 0.41403379428206274608377249480129098139321562919141e-3 * t340 * t17 + 0.69005632380343791013962082466881830232202604865235e-4 * t351 * t147 + 0.41403379428206274608377249480129098139321562919141e-3 * t354 * t243)
  t359 = t358 * t116
  t371 = t2 * (t275 * t264 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t301 * t151 * t142 * t290 + 0.41403379428206274608377249480129098139321562919141e-3 * t354 * t17)
  t372 = t371 * t97
  t375 = t371 * t116
  t379 = t14 + 0.35302100000000000000000000000000000000000000000000e1 * t15 + 0.180578e2
  t380 = 0.1e1 / t379
  t382 = t6 * t133 * t380
  t384 = t379 ** 2
  t385 = 0.1e1 / t384
  t386 = t142 * t385
  t388 = -t148 - 0.58836833333333333333333333333333333333333333333333e0 * t153
  t393 = 0.1e1 / t384 / t379
  t394 = t11 * t393
  t395 = t388 ** 2
  t399 = t11 * t385
  t402 = t168 - 0.39224555555555555555555555555555555555555555555555e0 * t179 + 0.78449111111111111111111111111111111111111111111110e0 * t182
  t408 = (t382 / 0.9e1 + t140 * t386 * t388 / 0.6e1 + t140 * t394 * t395 / 0.2e1 - t140 * t399 * t402 / 0.4e1) * t171 * t190
  t409 = t192 * t379
  t420 = (-t6 * t146 * t380 / 0.12e2 - t140 * t399 * t388 / 0.4e1) * t171 * t190
  t421 = t206 * t379
  t424 = t192 * t388
  t427 = t15 + 0.706042e1
  t428 = t427 ** 2
  t431 = 0.1e1 / t428 / t427 * t3
  t432 = t431 * t5
  t433 = 0.1e1 / t428
  t435 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t433
  t436 = 0.1e1 / t435
  t441 = t433 * t170 * t171
  t447 = t433 * t149 * t3
  t452 = t428 ** 2
  t455 = 0.1e1 / t452 / t427 * t3
  t456 = t455 * t5
  t457 = t435 ** 2
  t458 = 0.1e1 / t457
  t463 = t28 + 0.32500e0
  t464 = t463 * t385
  t465 = t464 * t150
  t470 = t463 * t380
  t471 = t470 * t170
  t474 = t470 * t149
  t477 = t463 ** 2
  t478 = t477 * t393
  t481 = t477 * t385
  t483 = t382 / 0.72e2 + t465 * t151 * t142 * t388 / 0.3e1 - t471 * t327 / 0.9e1 + 0.2e1 / 0.9e1 * t474 * t167 + 0.2e1 * t478 * t395 - t481 * t402
  t484 = 0.1e1 / t477
  t485 = t483 * t484
  t491 = -t474 * t147 / 0.6e1 - t481 * t388
  t493 = 0.1e1 / t477 / t463
  t494 = t491 * t493
  t495 = t379 * t149
  t496 = t494 * t495
  t499 = t491 * t484
  t507 = t219 * t170 * t171
  t510 = t507 * t174 * t177 * t222
  t513 = t219 * t149 * t3
  t516 = t513 * t151 * t132 * t222
  t520 = t28 + 0.10498e0
  t521 = t520 * t144
  t522 = t521 * t150
  t527 = t520 * t136
  t528 = t527 * t170
  t531 = t527 * t149
  t534 = t520 ** 2
  t535 = t534 * t160
  t538 = t534 * t144
  t540 = t138 / 0.72e2 + t522 * t151 * t142 * t155 / 0.3e1 - t528 * t327 / 0.9e1 + 0.2e1 / 0.9e1 * t531 * t167 + 0.2e1 * t535 * t162 - t538 * t184
  t541 = 0.1e1 / t534
  t542 = t540 * t541
  t543 = t542 * t135
  t548 = -t531 * t147 / 0.6e1 - t538 * t155
  t550 = 0.1e1 / t534 / t520
  t551 = t548 * t550
  t552 = t135 * t149
  t553 = t551 * t552
  t554 = t553 * t147
  t556 = t548 * t541
  t557 = t556 * t155
  t559 = 0.51817833333333333333333333333333333333333333333333e-2 * t408 * t409 + 0.17272611111111111111111111111111111111111111111111e-2 * t420 * t421 + 0.51817833333333333333333333333333333333333333333333e-2 * t420 * t424 + 0.13796274692623141086738355049039257855828824683819e-1 * t432 * t133 * t436 + 0.27592549385246282173476710098078515711657649367639e-1 * t441 * t174 * t177 * t436 - 0.55185098770492564346953420196157031423315298735277e-1 * t447 * t151 * t132 * t436 - 0.30878365944746984533884071665444263610784010246137e0 * t456 * t133 * t458 + 0.22478670955426118383265363956423012380560746650571e-2 * t485 * t379 + 0.37464451592376863972108939927371687300934577750952e-3 * t496 * t147 + 0.22478670955426118383265363956423012380560746650571e-2 * t499 * t388 - 0.10363566666666666666666666666666666666666666666667e-1 * t194 - 0.34545222222222222222222222222222222222222222222223e-2 * t208 - 0.10363566666666666666666666666666666666666666666667e-1 * t211 - 0.13255248558342256726771310131293653497824588692887e-1 * t224 - 0.26510497116684513453542620262587306995649177385775e-1 * t510 + 0.53020994233369026907085240525174613991298354771549e-1 * t516 + 0.50167127350538589836488394571946851238131125013746e0 * t234 - 0.96902277115443742137603943210562149050493484994510e-3 * t543 - 0.16150379519240623689600657201760358175082247499085e-3 * t554 - 0.96902277115443742137603943210562149050493484994510e-3 * t557
  t560 = t559 * t116
  t561 = t79 * t81
  t562 = t561 * t83
  t568 = jnp.log(t6 * t12 * t380 / 0.4e1)
  t572 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t427)
  t575 = jnp.log(t477 * t380)
  t580 = jnp.log(t6 * t12 * t136 / 0.4e1)
  t584 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t213)
  t587 = jnp.log(t534 * t136)
  t589 = 0.1554535e-1 * t568 + 0.52491393169780936217021346072241076933841385384497e-1 * t572 + 0.22478670955426118383265363956423012380560746650571e-2 * t575 - 0.310907e-1 * t580 - 0.38783294878113014394824731224995739188004877421366e-1 * t584 - 0.96902277115443742137603943210562149050493484994510e-3 * t587
  t590 = t589 * t116
  t591 = t561 * t123
  t594 = -t75 * t88 / 0.8e1 - t98 * t107 / 0.4e1 - t117 * t128 / 0.8e1 + 0.31090700000000000000000000000000000000000000000001e-1 * t194 + 0.10363566666666666666666666666666666666666666666667e-1 * t208 + 0.31090700000000000000000000000000000000000000000001e-1 * t211 + 0.39765745675026770180313930393880960493473766078662e-1 * t224 - 0.15050138205161576950946518371584055371439337504124e1 * t234 - t359 * t88 / 0.8e1 - t372 * t88 / 0.4e1 - t375 * t107 / 0.4e1 + 0.3e1 * t560 * t562 + 0.60e2 * t590 * t591
  t595 = t79 * t80
  t596 = t595 * t83
  t615 = 0.51817833333333333333333333333333333333333333333333e-2 * t420 * t409 + 0.41388824077869423260215065147117773567486474051458e-1 * t447 * t151 * t142 * t436 + 0.22478670955426118383265363956423012380560746650571e-2 * t499 * t379 - 0.10363566666666666666666666666666666666666666666667e-1 * t204 * t193 - 0.39765745675026770180313930393880960493473766078662e-1 * t513 * t151 * t142 * t222 - 0.96902277115443742137603943210562149050493484994510e-3 * t556 * t135
  t616 = t615 * t97
  t619 = t615 * t116
  t620 = t561 * t102
  t623 = t589 * t74
  t626 = t79 * t99
  t627 = t626 * t83
  t630 = t626 * t102
  t633 = t589 * t97
  t638 = t36 * t83
  t645 = 0.1e1 / t82 / t51
  t659 = 0.1e1 / t10 / t51
  t660 = t8 * t659
  t662 = t6 * t660 * t136
  t666 = t140 * t132 * t144 * t155
  t675 = t143 ** 2
  t676 = 0.1e1 / t675
  t678 = t162 * t155
  t682 = t155 * t184
  t686 = t6 * t660
  t687 = 0.7e1 / 0.27e2 * t686
  t691 = 0.1e1 / t15 / t325 / t206 / 0.4e1
  t693 = t691 * t4 * t83
  t696 = 0.1e1 / t175 / t51
  t698 = t172 * t174 * t696
  t701 = t150 * t151 * t659
  t703 = -t687 - 0.12424800000000000000000000000000000000000000000000e1 * t693 + 0.82832000000000000000000000000000000000000000000000e0 * t698 - 0.96637333333333333333333333333333333333333333333333e0 * t701
  t711 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t662 - t666 / 0.3e1 - t140 * t142 * t160 * t162 / 0.2e1 + t140 * t145 * t184 / 0.4e1 - 0.3e1 / 0.2e1 * t140 * t11 * t676 * t678 + 0.3e1 / 0.2e1 * t140 * t161 * t682 - t140 * t166 * t703 / 0.4e1) * t171 * t190 * t193
  t714 = 0.48602578047254941331494803814743396158690158540586e-1 * t218 * t660 * t222
  t717 = t7 / t175 / t9
  t720 = 0.23030148148148148148148148148148148148148148148149e-2 * t204 * t717 * t135
  t722 = 0.69090444444444444444444444444444444444444444444446e-2 * t191 * t207
  t734 = 0.6e1 * t52 - 0.6e1 * t638
  t738 = f.my_piecewise3(t40, 0, -0.8e1 / 0.27e2 / t42 / t39 * t48 * t47 + 0.4e1 / 0.3e1 * t43 * t47 * t55 + 0.4e1 / 0.3e1 * t41 * t734)
  t751 = f.my_piecewise3(t61, 0, -0.8e1 / 0.27e2 / t63 / t60 * t66 * t65 + 0.4e1 / 0.3e1 * t64 * t65 * t69 - 0.4e1 / 0.3e1 * t62 * t734)
  t752 = t738 + t751
  t764 = 0.18394613361864149606712411343047178787314745838373e1 * t230 * t660 * t232
  t765 = -t117 * t79 * (0.144e3 * t80 * t102 - 0.240e3 * t99 * t123 + 0.120e3 * t81 * t645 - 0.24e2 * t638) * t87 / 0.24e2 - t371 * t74 * t88 / 0.8e1 - t372 * t107 / 0.4e1 + t711 - t714 - t720 + t722 - t375 * t128 / 0.8e1 - t35 * t752 * t88 / 0.24e2 - t75 * t107 / 0.8e1 - t98 * t128 / 0.8e1 - t359 * t107 / 0.8e1 + t764
  t768 = 0.10363566666666666666666666666666666666666666666667e-1 * t204 * t192 * t184
  t771 = 0.69090444444444444444444444444444444444444444444446e-2 * t204 * t206 * t155
  t773 = 0.20727133333333333333333333333333333333333333333334e-1 * t191 * t210
  t789 = t6 * t660 * t18
  t793 = t140 * t132 * t240 * t243
  t802 = t239 ** 2
  t803 = 0.1e1 / t802
  t805 = t250 * t243
  t809 = t243 * t257
  t816 = -t687 - 0.37702333333333333333333333333333333333333333333334e0 * t693 + 0.25134888888888888888888888888888888888888888888890e0 * t698 - 0.29324037037037037037037037037037037037037037037038e0 * t701
  t826 = t4 * t83
  t852 = 0.23390302462324474051432516353486737824307380234560e2 * t310 * t660 * t312 + t275 * t192 * t257 / 0.3e1 + 0.2e1 / 0.9e1 * t275 * t206 * t243 + 0.2e1 / 0.3e1 * t263 * t279 + (-0.7e1 / 0.27e2 * t789 - t793 / 0.3e1 - t140 * t142 * t248 * t250 / 0.2e1 + t140 * t241 * t257 / 0.4e1 - 0.3e1 / 0.2e1 * t140 * t11 * t803 * t805 + 0.3e1 / 0.2e1 * t140 * t249 * t809 - t140 * t254 * t816 / 0.4e1) * t171 * t190 * t264 / 0.3e1 + 0.15087124812358469189006280566794884950190836019297e1 * t287 * t691 * t826 * t290 - 0.92007509840458388018616109955842440309603473153646e-4 * t351 * t167 + 0.13801126476068758202792416493376366046440520973047e-3 * t349 * t243 * t149 * t147 + 0.46003754920229194009308054977921220154801736576823e-4 * t349 * t17 * t170 * t327 + 0.13801126476068758202792416493376366046440520973047e-3 * t338 * t348 * t350 * t147 - 0.10058083208238979459337520377863256633460557346198e1 * t295 * t174 * t696 * t290 + 0.11734430409612142702560440440840466072370650237231e1 * t301 * t151 * t659 * t290
  t873 = 0.1e1 / t173
  t875 = t3 * t873 * t8
  t876 = t659 * t4
  t882 = t7 * t696
  t883 = t325 * t882
  t894 = -0.11e2 / 0.216e3 * t789 - t793 / 0.24e2 - t29 * t248 * t150 * t151 * t142 * t250 + t317 * t172 * t174 * t177 * t243 / 0.3e1 - 0.2e1 / 0.3e1 * t318 * t151 * t132 * t243 + t318 * t151 * t142 * t257 / 0.2e1 + t875 * t876 * t18 / 0.432e3 - 0.2e1 / 0.3e1 * t323 * t693 + 0.4e1 / 0.9e1 * t324 * t883 - 0.14e2 / 0.27e2 * t330 * t686 - 0.6e1 * t30 * t803 * t805 + 0.6e1 * t333 * t809 - t336 * t816
  t935 = t306 ** 2
  t945 = t30 ** 2
  t951 = 0.41403379428206274608377249480129098139321562919141e-3 * t894 * t339 * t17 + 0.82806758856412549216754498960258196278643125838282e-3 * t340 * t243 + 0.41403379428206274608377249480129098139321562919141e-3 * t354 * t257 + 0.2e1 / 0.9e1 * t263 * t276 - 0.2e1 / 0.27e2 * t275 * t717 * t17 - 0.46099548037761989188630301731873259570027554503406e0 * t286 * t660 * t290 + 0.25145208020597448648343800944658141583651393365494e0 / t306 * t171 * t173 * t882 * t290 * t149 - 0.29769475861140239701823202631710393594573029389440e2 / t306 / t282 * t171 * t173 * t882 * t312 * t149 + 0.20954340017164540540286500787215117986376161137912e-1 * t285 * t873 * t660 * t4 * t290 - 0.10631955664692942750651143797039426283776081924800e1 * t309 * t873 * t660 * t4 * t312 + 0.86312224513605868227832795632565231845861115350066e3 / t935 * t171 * t173 * t882 / t311 / t289 * t149 + 0.17251408095085947753490520616720457558050651216309e-4 * t346 / t945 * t17 * t167
  t966 = 0.15906298270010708072125572157552384197389506431465e0 * t219 * t691 * t826 * t222
  t972 = 0.10604198846673805381417048105034922798259670954310e0 * t507 * t174 * t696 * t222
  t976 = 0.12371565321119439611653222789207409931302949446695e0 * t513 * t151 * t659 * t222
  t977 = t534 ** 2
  t982 = 0.40375948798101559224001643004400895437705618747712e-4 * t548 / t977 * t135 * t167
  t989 = 0.26510497116684513453542620262587306995649177385774e-1 / t226 * t171 * t173 * t882 * t222 * t149
  t990 = t768 + t771 + t773 - t358 * t97 * t88 / 0.8e1 - t2 * (t852 + t951) * t116 * t88 / 0.24e2 + 0.60e2 * t619 * t591 + 0.12e2 * t623 * t627 - 0.12e2 * t623 * t620 + t966 - 0.96e2 * t619 * t630 - t972 + t976 + t982 + t989
  t999 = 0.23411326096918008590361250800241863911127858339748e1 / t226 / t214 * t171 * t173 * t882 * t232 * t149
  t1004 = 0.22092080930570427877952183552156089163040981154812e-2 * t217 * t873 * t660 * t4 * t222
  t1009 = 0.83611878917564316394147324286578085396885208356242e-1 * t229 * t873 * t660 * t4 * t232
  t1010 = t226 ** 2
  t1019 = 0.50631328524251801700246888250186209051365905137714e2 / t1010 * t171 * t173 * t882 / t231 / t221 * t149
  t1021 = 0.19380455423088748427520788642112429810098696998902e-2 * t542 * t155
  t1023 = 0.96902277115443742137603943210562149050493484994510e-3 * t556 * t184
  t1059 = -0.11e2 / 0.216e3 * t662 - t666 / 0.24e2 - t520 * t160 * t150 * t151 * t142 * t162 + t521 * t172 * t174 * t177 * t155 / 0.3e1 - 0.2e1 / 0.3e1 * t522 * t151 * t132 * t155 + t522 * t151 * t142 * t184 / 0.2e1 + t875 * t876 * t136 / 0.432e3 - 0.2e1 / 0.3e1 * t527 * t693 + 0.4e1 / 0.9e1 * t528 * t883 - 0.14e2 / 0.27e2 * t531 * t686 - 0.6e1 * t534 * t676 * t678 + 0.6e1 * t535 * t682 - t538 * t703
  t1062 = 0.96902277115443742137603943210562149050493484994510e-3 * t1059 * t541 * t135
  t1064 = 0.21533839358987498252800876269013810900109663332113e-3 * t553 * t167
  t1068 = 0.10766919679493749126400438134506905450054831666057e-3 * t551 * t135 * t170 * t327
  t1072 = 0.32300759038481247379201314403520716350164494998170e-3 * t540 * t550 * t552 * t147
  t1076 = 0.32300759038481247379201314403520716350164494998170e-3 * t551 * t155 * t149 * t147
  t1100 = t6 * t660 * t380
  t1104 = t140 * t132 * t385 * t388
  t1113 = t384 ** 2
  t1114 = 0.1e1 / t1113
  t1116 = t395 * t388
  t1120 = t388 * t402
  t1127 = -t687 - 0.23534733333333333333333333333333333333333333333333e1 * t693 + 0.15689822222222222222222222222222222222222222222222e1 * t698 - 0.18304792592592592592592592592592592592592592592592e1 * t701
  t1136 = 0.11322067513073894329090826277329563323954137090250e1 * t456 * t660 * t458 + 0.51817833333333333333333333333333333333333333333333e-2 * t420 * t192 * t402 + 0.34545222222222222222222222222222222222222222222222e-2 * t420 * t206 * t388 - 0.11515074074074074074074074074074074074074074074074e-2 * t420 * t717 * t379 - 0.50586340539618183984707301846477278804705690507337e-1 * t432 * t660 * t436 + 0.10363566666666666666666666666666666666666666666667e-1 * t408 * t424 + 0.34545222222222222222222222222222222222222222222222e-2 * t408 * t421 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t1100 - t1104 / 0.3e1 - t140 * t142 * t393 * t395 / 0.2e1 + t140 * t386 * t402 / 0.4e1 - 0.3e1 / 0.2e1 * t140 * t11 * t1114 * t1116 + 0.3e1 / 0.2e1 * t140 * t394 * t1120 - t140 * t399 * t1127 / 0.4e1) * t171 * t190 * t409 - t711 + t714 + t720 - t722
  t1141 = -t764 - t768 - t771 - t773 - t966 + 0.16555529631147769304086026058847109426994589620583e0 * t433 * t691 * t826 * t436 + t972 - t976 - t982 - t989 + t999 - t1004
  t1143 = t477 ** 2
  t1174 = t452 ** 2
  t1192 = t1009 - t1019 + 0.93661128980942159930272349818429218252336444377380e-4 * t491 / t1143 * t379 * t167 + 0.27592549385246282173476710098078515711657649367638e-1 / t452 * t171 * t173 * t882 * t436 * t149 - 0.14409904107548592782479233443873989685032538114864e1 / t452 / t428 * t171 * t173 * t882 * t458 * t149 + 0.22993791154371901811230591748398763093048041139699e-2 * t431 * t873 * t660 * t4 * t436 - 0.51463943241244974223140119442407106017973350410227e-1 * t455 * t873 * t660 * t4 * t458 + 0.18429583437767336287475605998441200095133403022660e2 / t1174 * t171 * t173 * t882 / t457 / t435 * t149 - 0.11037019754098512869390684039231406284663059747056e0 * t441 * t174 * t696 * t436 + 0.12876523046448265014289131379103307332106903038231e0 * t447 * t151 * t659 * t436 - t1021 - t1023
  t1246 = -0.11e2 / 0.216e3 * t1100 - t1104 / 0.24e2 - t463 * t393 * t150 * t151 * t142 * t395 + t464 * t172 * t174 * t177 * t388 / 0.3e1 - 0.2e1 / 0.3e1 * t465 * t151 * t132 * t388 + t465 * t151 * t142 * t402 / 0.2e1 + t875 * t876 * t380 / 0.432e3 - 0.2e1 / 0.3e1 * t470 * t693 + 0.4e1 / 0.9e1 * t471 * t883 - 0.14e2 / 0.27e2 * t474 * t686 - 0.6e1 * t477 * t1114 * t1116 + 0.6e1 * t478 * t1120 - t481 * t1127
  t1250 = -t1062 + 0.74928903184753727944217879854743374601869155501904e-3 * t483 * t493 * t495 * t147 + 0.74928903184753727944217879854743374601869155501904e-3 * t494 * t388 * t149 * t147 + 0.24976301061584575981405959951581124867289718500635e-3 * t494 * t379 * t170 * t327 - 0.49952602123169151962811919903162249734579437001269e-3 * t496 * t167 + t1064 - t1068 - t1072 - t1076 + 0.44957341910852236766530727912846024761121493301142e-2 * t485 * t388 + 0.22478670955426118383265363956423012380560746650571e-2 * t499 * t402 + 0.22478670955426118383265363956423012380560746650571e-2 * t1246 * t484 * t379
  t1255 = -t999 + t1004 - t1009 + t1019 + t1021 + t1023 + t1062 - t1064 + t1068 + t1072 + t1076 + 0.3e1 * t559 * t97 * t562 + (t1136 + t1141 + t1192 + t1250) * t116 * t562
  t1290 = 0.24e2 * t590 * t79 * t36 * t83 - 0.144e3 * t590 * t595 * t102 + 0.240e3 * t590 * t626 * t123 - 0.120e3 * t590 * t561 * t645 + t589 * t752 * t562 + 0.3e1 * t615 * t74 * t562 - 0.12e2 * t560 * t620 + 0.12e2 * t560 * t627 + 0.60e2 * t633 * t591 + 0.36e2 * t619 * t596 + 0.36e2 * t633 * t596 - 0.24e2 * t616 * t620 + 0.24e2 * t616 * t627 - 0.96e2 * t633 * t630
  t1299 = 0.36e2 * t590 * t596 + 0.6e1 * t616 * t562 - 0.24e2 * t619 * t620 + 0.3e1 * t623 * t562 + 0.24e2 * t619 * t627 - 0.96e2 * t590 * t630 + 0.24e2 * t633 * t627 - 0.24e2 * t633 * t620 + t9 * (t765 + t990 + t1255 + t1290) + 0.79531491350053540360627860787761920986947532157324e-1 * t510 - 0.15906298270010708072125572157552384197389506431465e0 * t516 + 0.29070683134633122641281182963168644715148045498353e-2 * t543 + 0.29070683134633122641281182963168644715148045498353e-2 * t557 + 0.48451138557721871068801971605281074525246742497255e-3 * t554
  d111 = t594 + t1299

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** 2
  t9 = t7 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t12 = t6 * t11
  t13 = 0.1e1 / t9
  t14 = t6 * t13
  t15 = t4 * t14
  t16 = t15 / 0.4e1
  t17 = jnp.sqrt(t15)
  t19 = t16 + 0.35302100000000000000000000000000000000000000000000e1 * t17 + 0.180578e2
  t20 = 0.1e1 / t19
  t22 = t4 * t12 * t20
  t24 = t4 * t6
  t26 = 0.1e1 / t9 / t7
  t27 = t19 ** 2
  t28 = 0.1e1 / t27
  t29 = t26 * t28
  t30 = t6 * t26
  t31 = t4 * t30
  t32 = t31 / 0.12e2
  t33 = 0.1e1 / t17
  t34 = t33 * t1
  t35 = t3 * t6
  t37 = t34 * t35 * t26
  t39 = -t32 - 0.58836833333333333333333333333333333333333333333333e0 * t37
  t44 = 0.1e1 / t27 / t19
  t45 = t13 * t44
  t46 = t39 ** 2
  t50 = t13 * t28
  t51 = t4 * t12
  t52 = t51 / 0.9e1
  t54 = 0.1e1 / t17 / t15
  t55 = t1 ** 2
  t56 = t54 * t55
  t57 = t3 ** 2
  t58 = t57 * t5
  t59 = t9 ** 2
  t61 = 0.1e1 / t59 / t8
  t63 = t56 * t58 * t61
  t66 = t34 * t35 * t11
  t68 = t52 - 0.39224555555555555555555555555555555555555555555555e0 * t63 + 0.78449111111111111111111111111111111111111111111110e0 * t66
  t74 = 0.1e1 / t3
  t75 = (t22 / 0.9e1 + t24 * t29 * t39 / 0.6e1 + t24 * t45 * t46 / 0.2e1 - t24 * t50 * t68 / 0.4e1) * t55 * t74
  t76 = t5 * t9
  t77 = t76 * t19
  t88 = (-t4 * t30 * t20 / 0.12e2 - t24 * t50 * t39 / 0.4e1) * t55 * t74
  t90 = t5 / t59
  t91 = t90 * t19
  t94 = t76 * t39
  t97 = t17 + 0.706042e1
  t98 = t97 ** 2
  t99 = t98 * t97
  t100 = 0.1e1 / t99
  t101 = t100 * t1
  t102 = t101 * t3
  t103 = 0.1e1 / t98
  t105 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t103
  t106 = 0.1e1 / t105
  t111 = t103 * t54 * t55
  t117 = t103 * t33 * t1
  t122 = t98 ** 2
  t124 = 0.1e1 / t122 / t97
  t125 = t124 * t1
  t126 = t125 * t3
  t127 = t105 ** 2
  t128 = 0.1e1 / t127
  t133 = t17 / 0.2e1
  t134 = t133 + 0.32500e0
  t135 = t134 * t28
  t136 = t135 * t34
  t137 = t26 * t39
  t141 = t134 * t20
  t142 = t141 * t54
  t143 = t55 * t57
  t144 = t5 * t61
  t145 = t143 * t144
  t148 = t141 * t33
  t151 = t134 ** 2
  t152 = t151 * t44
  t155 = t151 * t28
  t157 = t22 / 0.72e2 + t136 * t35 * t137 / 0.3e1 - t142 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t148 * t51 + 0.2e1 * t152 * t46 - t155 * t68
  t158 = 0.1e1 / t151
  t159 = t157 * t158
  t165 = -t148 * t31 / 0.6e1 - t155 * t39
  t167 = 0.1e1 / t151 / t134
  t168 = t165 * t167
  t169 = t19 * t33
  t170 = t168 * t169
  t173 = t165 * t158
  t177 = t16 + 0.18637200000000000000000000000000000000000000000000e1 * t17 + 0.129352e2
  t178 = 0.1e1 / t177
  t180 = t4 * t12 * t178
  t182 = t177 ** 2
  t183 = 0.1e1 / t182
  t184 = t26 * t183
  t186 = -t32 - 0.31062000000000000000000000000000000000000000000000e0 * t37
  t191 = 0.1e1 / t182 / t177
  t192 = t13 * t191
  t193 = t186 ** 2
  t197 = t13 * t183
  t200 = t52 - 0.20708000000000000000000000000000000000000000000000e0 * t63 + 0.41416000000000000000000000000000000000000000000000e0 * t66
  t206 = (t180 / 0.9e1 + t24 * t184 * t186 / 0.6e1 + t24 * t192 * t193 / 0.2e1 - t24 * t197 * t200 / 0.4e1) * t55 * t74
  t207 = t76 * t177
  t218 = (-t4 * t30 * t178 / 0.12e2 - t24 * t197 * t186 / 0.4e1) * t55 * t74
  t219 = t90 * t177
  t222 = t76 * t186
  t225 = t17 + 0.372744e1
  t226 = t225 ** 2
  t227 = t226 * t225
  t228 = 0.1e1 / t227
  t229 = t228 * t1
  t230 = t229 * t3
  t231 = 0.1e1 / t226
  t233 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t231
  t234 = 0.1e1 / t233
  t239 = t231 * t54 * t55
  t245 = t231 * t33 * t1
  t250 = t226 ** 2
  t252 = 0.1e1 / t250 / t225
  t253 = t252 * t1
  t254 = t253 * t3
  t255 = t233 ** 2
  t256 = 0.1e1 / t255
  t261 = t133 + 0.10498e0
  t262 = t261 * t183
  t263 = t262 * t34
  t264 = t26 * t186
  t268 = t261 * t178
  t269 = t268 * t54
  t272 = t268 * t33
  t275 = t261 ** 2
  t276 = t275 * t191
  t279 = t275 * t183
  t281 = t180 / 0.72e2 + t263 * t35 * t264 / 0.3e1 - t269 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t272 * t51 + 0.2e1 * t276 * t193 - t279 * t200
  t282 = 0.1e1 / t275
  t283 = t281 * t282
  t289 = -t272 * t31 / 0.6e1 - t279 * t186
  t291 = 0.1e1 / t275 / t261
  t292 = t289 * t291
  t293 = t177 * t33
  t294 = t292 * t293
  t297 = t289 * t282
  t300 = 0.51817833333333333333333333333333333333333333333333e-2 * t75 * t77 + 0.17272611111111111111111111111111111111111111111111e-2 * t88 * t91 + 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t94 + 0.13796274692623141086738355049039257855828824683819e-1 * t102 * t12 * t106 + 0.27592549385246282173476710098078515711657649367639e-1 * t111 * t58 * t61 * t106 - 0.55185098770492564346953420196157031423315298735277e-1 * t117 * t35 * t11 * t106 - 0.30878365944746984533884071665444263610784010246137e0 * t126 * t12 * t128 + 0.22478670955426118383265363956423012380560746650571e-2 * t159 * t19 + 0.37464451592376863972108939927371687300934577750952e-3 * t170 * t31 + 0.22478670955426118383265363956423012380560746650571e-2 * t173 * t39 - 0.10363566666666666666666666666666666666666666666667e-1 * t206 * t207 - 0.34545222222222222222222222222222222222222222222223e-2 * t218 * t219 - 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t222 - 0.13255248558342256726771310131293653497824588692887e-1 * t230 * t12 * t234 - 0.26510497116684513453542620262587306995649177385775e-1 * t239 * t58 * t61 * t234 + 0.53020994233369026907085240525174613991298354771549e-1 * t245 * t35 * t11 * t234 + 0.50167127350538589836488394571946851238131125013746e0 * t254 * t12 * t256 - 0.96902277115443742137603943210562149050493484994510e-3 * t283 * t177 - 0.16150379519240623689600657201760358175082247499085e-3 * t294 * t31 - 0.96902277115443742137603943210562149050493484994510e-3 * t297 * t186
  t301 = r0 - r1
  t302 = 0.1e1 / t7
  t303 = t301 * t302
  t304 = 0.1e1 + t303
  t305 = t304 <= f.p.zeta_threshold
  t306 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t307 = t306 * f.p.zeta_threshold
  t308 = t304 ** (0.1e1 / 0.3e1)
  t310 = f.my_piecewise3(t305, t307, t308 * t304)
  t311 = 0.1e1 - t303
  t312 = t311 <= f.p.zeta_threshold
  t313 = t311 ** (0.1e1 / 0.3e1)
  t315 = f.my_piecewise3(t312, t307, t313 * t311)
  t316 = t310 + t315 - 0.2e1
  t317 = t300 * t316
  t318 = 2 ** (0.1e1 / 0.3e1)
  t319 = t318 - 0.1e1
  t321 = 0.1e1 / t319 / 0.2e1
  t322 = t301 ** 2
  t323 = t322 * t301
  t324 = t321 * t323
  t325 = t8 ** 2
  t326 = 0.1e1 / t325
  t327 = t324 * t326
  t333 = jnp.log(t4 * t14 * t20 / 0.4e1)
  t337 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t97)
  t340 = jnp.log(t151 * t20)
  t345 = jnp.log(t4 * t14 * t178 / 0.4e1)
  t349 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t225)
  t352 = jnp.log(t275 * t178)
  t354 = 0.1554535e-1 * t333 + 0.52491393169780936217021346072241076933841385384497e-1 * t337 + 0.22478670955426118383265363956423012380560746650571e-2 * t340 - 0.310907e-1 * t345 - 0.38783294878113014394824731224995739188004877421366e-1 * t349 - 0.96902277115443742137603943210562149050493484994510e-3 * t352
  t355 = t308 ** 2
  t356 = 0.1e1 / t355
  t357 = 0.1e1 / t8
  t359 = -t301 * t357 + t302
  t360 = t359 ** 2
  t363 = t8 * t7
  t364 = 0.1e1 / t363
  t367 = 0.2e1 * t301 * t364 - 0.2e1 * t357
  t371 = f.my_piecewise3(t305, 0, 0.4e1 / 0.9e1 * t356 * t360 + 0.4e1 / 0.3e1 * t308 * t367)
  t372 = t313 ** 2
  t373 = 0.1e1 / t372
  t374 = -t359
  t375 = t374 ** 2
  t378 = -t367
  t382 = f.my_piecewise3(t312, 0, 0.4e1 / 0.9e1 * t373 * t375 + 0.4e1 / 0.3e1 * t313 * t378)
  t383 = t371 + t382
  t384 = t354 * t383
  t385 = t322 ** 2
  t386 = t321 * t385
  t387 = t325 * t7
  t388 = 0.1e1 / t387
  t389 = t386 * t388
  t394 = f.my_piecewise3(t305, 0, 0.4e1 / 0.3e1 * t308 * t359)
  t397 = f.my_piecewise3(t312, 0, 0.4e1 / 0.3e1 * t313 * t374)
  t398 = t394 + t397
  t399 = t354 * t398
  t400 = t321 * t322
  t401 = t400 * t326
  t404 = t324 * t388
  t423 = 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t77 + 0.41388824077869423260215065147117773567486474051458e-1 * t117 * t35 * t26 * t106 + 0.22478670955426118383265363956423012380560746650571e-2 * t173 * t19 - 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t207 - 0.39765745675026770180313930393880960493473766078662e-1 * t245 * t35 * t26 * t234 - 0.96902277115443742137603943210562149050493484994510e-3 * t297 * t177
  t424 = t423 * t316
  t426 = 0.1e1 / t325 / t8
  t427 = t386 * t426
  t433 = 0.1e1 / t17 / t143 / t90 / 0.4e1
  t434 = t103 * t433
  t435 = t2 * t326
  t439 = t231 * t433
  t441 = t439 * t435 * t234
  t444 = 0.1e1 / t9 / t363
  t445 = t6 * t444
  t447 = t4 * t445 * t178
  t449 = t11 * t183
  t451 = t24 * t449 * t186
  t453 = t26 * t191
  t460 = t182 ** 2
  t461 = 0.1e1 / t460
  t462 = t13 * t461
  t463 = t193 * t186
  t467 = t186 * t200
  t471 = t4 * t445
  t472 = 0.7e1 / 0.27e2 * t471
  t473 = t433 * t2
  t474 = t473 * t326
  t477 = 0.1e1 / t59 / t363
  t479 = t56 * t58 * t477
  t482 = t34 * t35 * t444
  t484 = -t472 - 0.12424800000000000000000000000000000000000000000000e1 * t474 + 0.82832000000000000000000000000000000000000000000000e0 * t479 - 0.96637333333333333333333333333333333333333333333333e0 * t482
  t490 = (-0.7e1 / 0.27e2 * t447 - t451 / 0.3e1 - t24 * t453 * t193 / 0.2e1 + t24 * t184 * t200 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t462 * t463 + 0.3e1 / 0.2e1 * t24 * t192 * t467 - t24 * t197 * t484 / 0.4e1) * t55 * t74
  t491 = t490 * t207
  t494 = t230 * t445 * t234
  t498 = t5 / t59 / t7
  t499 = t498 * t177
  t500 = t218 * t499
  t502 = t76 * t68
  t508 = t206 * t222
  t511 = t4 * t445 * t20
  t513 = t11 * t28
  t515 = t24 * t513 * t39
  t517 = t26 * t44
  t524 = t27 ** 2
  t525 = 0.1e1 / t524
  t526 = t13 * t525
  t527 = t46 * t39
  t531 = t39 * t68
  t538 = -t472 - 0.23534733333333333333333333333333333333333333333333e1 * t474 + 0.15689822222222222222222222222222222222222222222222e1 * t479 - 0.18304792592592592592592592592592592592592592592592e1 * t482
  t544 = (-0.7e1 / 0.27e2 * t511 - t515 / 0.3e1 - t24 * t517 * t46 / 0.2e1 + t24 * t29 * t68 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t526 * t527 + 0.3e1 / 0.2e1 * t24 * t45 * t531 - t24 * t50 * t538 / 0.4e1) * t55 * t74
  t549 = t90 * t39
  t552 = t206 * t219
  t554 = 0.16555529631147769304086026058847109426994589620583e0 * t434 * t435 * t106 - 0.15906298270010708072125572157552384197389506431465e0 * t441 - 0.10363566666666666666666666666666666666666666666667e-1 * t491 + 0.48602578047254941331494803814743396158690158540586e-1 * t494 + 0.23030148148148148148148148148148148148148148148149e-2 * t500 + 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t502 + 0.11322067513073894329090826277329563323954137090250e1 * t126 * t445 * t128 - 0.20727133333333333333333333333333333333333333333334e-1 * t508 + 0.51817833333333333333333333333333333333333333333333e-2 * t544 * t77 + 0.10363566666666666666666666666666666666666666666667e-1 * t75 * t94 + 0.34545222222222222222222222222222222222222222222222e-2 * t88 * t549 - 0.69090444444444444444444444444444444444444444444446e-2 * t552
  t555 = t498 * t19
  t564 = t254 * t445 * t256
  t566 = t76 * t200
  t567 = t218 * t566
  t569 = t90 * t186
  t570 = t218 * t569
  t572 = t281 * t291
  t573 = t572 * t293
  t574 = t573 * t31
  t576 = t157 * t167
  t577 = t576 * t169
  t580 = t39 * t33
  t581 = t168 * t580
  t584 = t19 * t54
  t585 = t168 * t584
  t588 = t177 * t54
  t589 = t292 * t588
  t590 = t589 * t145
  t592 = t294 * t51
  t594 = -0.11515074074074074074074074074074074074074074074074e-2 * t88 * t555 - 0.50586340539618183984707301846477278804705690507337e-1 * t102 * t445 * t106 + 0.34545222222222222222222222222222222222222222222222e-2 * t75 * t91 - 0.18394613361864149606712411343047178787314745838373e1 * t564 - 0.10363566666666666666666666666666666666666666666667e-1 * t567 - 0.69090444444444444444444444444444444444444444444446e-2 * t570 - 0.32300759038481247379201314403520716350164494998170e-3 * t574 + 0.74928903184753727944217879854743374601869155501904e-3 * t577 * t31 + 0.74928903184753727944217879854743374601869155501904e-3 * t581 * t31 + 0.24976301061584575981405959951581124867289718500635e-3 * t585 * t145 - 0.10766919679493749126400438134506905450054831666057e-3 * t590 + 0.21533839358987498252800876269013810900109663332113e-3 * t592
  t598 = t186 * t33
  t599 = t292 * t598
  t600 = t599 * t31
  t602 = t250 ** 2
  t603 = 0.1e1 / t602
  t604 = t603 * t55
  t605 = t604 * t57
  t606 = t5 * t477
  t608 = 0.1e1 / t255 / t233
  t609 = t608 * t33
  t611 = t605 * t606 * t609
  t613 = t151 ** 2
  t614 = 0.1e1 / t613
  t615 = t165 * t614
  t616 = t615 * t19
  t619 = 0.1e1 / t122
  t620 = t619 * t55
  t621 = t620 * t57
  t622 = t106 * t33
  t627 = 0.1e1 / t122 / t98
  t628 = t627 * t55
  t629 = t628 * t57
  t630 = t128 * t33
  t634 = 0.1e1 / t57
  t635 = t101 * t634
  t636 = t2 * t106
  t640 = t125 * t634
  t641 = t2 * t128
  t645 = t122 ** 2
  t646 = 0.1e1 / t645
  t647 = t646 * t55
  t648 = t647 * t57
  t650 = 0.1e1 / t127 / t105
  t651 = t650 * t33
  t665 = t239 * t58 * t477 * t234
  t667 = -0.49952602123169151962811919903162249734579437001269e-3 * t170 * t51 - 0.32300759038481247379201314403520716350164494998170e-3 * t600 - 0.50631328524251801700246888250186209051365905137714e2 * t611 + 0.93661128980942159930272349818429218252336444377380e-4 * t616 * t51 + 0.27592549385246282173476710098078515711657649367638e-1 * t621 * t606 * t622 - 0.14409904107548592782479233443873989685032538114864e1 * t629 * t606 * t630 + 0.22993791154371901811230591748398763093048041139699e-2 * t635 * t445 * t636 - 0.51463943241244974223140119442407106017973350410227e-1 * t640 * t445 * t641 + 0.18429583437767336287475605998441200095133403022660e2 * t648 * t606 * t651 - 0.11037019754098512869390684039231406284663059747056e0 * t111 * t58 * t477 * t106 + 0.12876523046448265014289131379103307332106903038231e0 * t117 * t35 * t444 * t106 + 0.10604198846673805381417048105034922798259670954310e0 * t665
  t670 = t245 * t35 * t444 * t234
  t672 = t275 ** 2
  t673 = 0.1e1 / t672
  t674 = t289 * t673
  t675 = t674 * t177
  t676 = t675 * t51
  t678 = 0.1e1 / t250
  t679 = t678 * t55
  t680 = t679 * t57
  t681 = t234 * t33
  t683 = t680 * t606 * t681
  t686 = 0.1e1 / t250 / t226
  t687 = t686 * t55
  t688 = t687 * t57
  t689 = t256 * t33
  t691 = t688 * t606 * t689
  t693 = t229 * t634
  t694 = t2 * t234
  t696 = t693 * t445 * t694
  t698 = t253 * t634
  t699 = t2 * t256
  t701 = t698 * t445 * t699
  t707 = t134 * t44
  t708 = t707 * t34
  t712 = t135 * t56
  t726 = t1 * t634 * t6
  t727 = t444 * t2
  t733 = t143 * t606
  t738 = t151 * t525
  t744 = -0.11e2 / 0.216e3 * t511 - t515 / 0.24e2 - t708 * t35 * t26 * t46 + t712 * t58 * t61 * t39 / 0.3e1 - 0.2e1 / 0.3e1 * t136 * t35 * t11 * t39 + t136 * t35 * t26 * t68 / 0.2e1 + t726 * t727 * t20 / 0.432e3 - 0.2e1 / 0.3e1 * t141 * t474 + 0.4e1 / 0.9e1 * t142 * t733 - 0.14e2 / 0.27e2 * t148 * t471 - 0.6e1 * t738 * t527 + 0.6e1 * t152 * t531 - t155 * t538
  t745 = t744 * t158
  t750 = t261 * t191
  t751 = t750 * t34
  t755 = t262 * t56
  t777 = t275 * t461
  t783 = -0.11e2 / 0.216e3 * t447 - t451 / 0.24e2 - t751 * t35 * t26 * t193 + t755 * t58 * t61 * t186 / 0.3e1 - 0.2e1 / 0.3e1 * t263 * t35 * t11 * t186 + t263 * t35 * t26 * t200 / 0.2e1 + t726 * t727 * t178 / 0.432e3 - 0.2e1 / 0.3e1 * t268 * t474 + 0.4e1 / 0.9e1 * t269 * t733 - 0.14e2 / 0.27e2 * t272 * t471 - 0.6e1 * t777 * t463 + 0.6e1 * t276 * t467 - t279 * t484
  t784 = t783 * t282
  t785 = t784 * t177
  t787 = t297 * t200
  t789 = t283 * t186
  t793 = -0.12371565321119439611653222789207409931302949446695e0 * t670 - 0.40375948798101559224001643004400895437705618747712e-4 * t676 - 0.26510497116684513453542620262587306995649177385774e-1 * t683 + 0.23411326096918008590361250800241863911127858339748e1 * t691 - 0.22092080930570427877952183552156089163040981154812e-2 * t696 + 0.83611878917564316394147324286578085396885208356242e-1 * t701 + 0.22478670955426118383265363956423012380560746650571e-2 * t173 * t68 + 0.22478670955426118383265363956423012380560746650571e-2 * t745 * t19 - 0.96902277115443742137603943210562149050493484994510e-3 * t785 - 0.96902277115443742137603943210562149050493484994510e-3 * t787 - 0.19380455423088748427520788642112429810098696998902e-2 * t789 + 0.44957341910852236766530727912846024761121493301142e-2 * t159 * t39
  t795 = t554 + t594 + t667 + t793
  t796 = t795 * t316
  t797 = t386 * t326
  t810 = 0.48e2 * t317 * t327 - 0.48e2 * t384 * t389 + 0.144e3 * t399 * t401 - 0.384e3 * t399 * t404 + 0.240e3 * t424 * t427 + 0.4e1 * t796 * t797 - 0.384e3 * t424 * t404 + 0.48e2 * t384 * t327 - 0.48e2 * t317 * t389 + 0.63625193080042832288502288630209536789558025725859e0 * t441 + 0.41454266666666666666666666666666666666666666666668e-1 * t491 - 0.19441031218901976532597921525897358463476063416235e0 * t494 - 0.92120592592592592592592592592592592592592592592596e-2 * t500
  t825 = 0.82908533333333333333333333333333333333333333333336e-1 * t508 + 0.27636177777777777777777777777777777777777777777779e-1 * t552 + 0.73578453447456598426849645372188715149258983353495e1 * t564 + 0.41454266666666666666666666666666666666666666666668e-1 * t567 + 0.27636177777777777777777777777777777777777777777779e-1 * t570 + 0.12920303615392498951680525761408286540065797999268e-2 * t574 + 0.43067678717974996505601752538027621800219326664227e-3 * t590 - 0.86135357435949993011203505076055243600438653328453e-3 * t592 + 0.12920303615392498951680525761408286540065797999268e-2 * t600 + 0.20252531409700720680098755300074483620546362055085e3 * t611 - 0.42416795386695221525668192420139691193038683817240e0 * t665 + 0.49486261284477758446612891156829639725211797786780e0 * t670 + 0.16150379519240623689600657201760358175082247499085e-3 * t676 + 0.10604198846673805381417048105034922798259670954310e0 * t683
  t830 = t423 * t383
  t833 = t354 * t316
  t834 = t321 * t301
  t835 = t834 * t326
  t838 = t423 * t398
  t842 = 0.1e1 / t355 / t304
  t846 = t356 * t359
  t849 = t301 * t326
  t851 = 0.6e1 * t364 - 0.6e1 * t849
  t855 = f.my_piecewise3(t305, 0, -0.8e1 / 0.27e2 * t842 * t360 * t359 + 0.4e1 / 0.3e1 * t846 * t367 + 0.4e1 / 0.3e1 * t308 * t851)
  t857 = 0.1e1 / t372 / t311
  t861 = t373 * t374
  t864 = -t851
  t868 = f.my_piecewise3(t312, 0, -0.8e1 / 0.27e2 * t857 * t375 * t374 + 0.4e1 / 0.3e1 * t861 * t378 + 0.4e1 / 0.3e1 * t313 * t864)
  t869 = t855 + t868
  t870 = t354 * t869
  t875 = t400 * t388
  t878 = t324 * t426
  t882 = 0.1e1 / t325 / t363
  t883 = t386 * t882
  t888 = t300 * t398
  t893 = -0.93645304387672034361445003200967455644511433358993e1 * t691 + 0.88368323722281711511808734208624356652163924619249e-2 * t696 - 0.33444751567025726557658929714631234158754083342496e0 * t701 + 0.12e2 * t830 * t797 + 0.96e2 * t833 * t835 - 0.96e2 * t838 * t389 + 0.4e1 * t870 * t797 + 0.144e3 * t424 * t401 - 0.576e3 * t833 * t875 + 0.960e3 * t833 * t878 - 0.480e3 * t833 * t883 + 0.240e3 * t399 * t427 + 0.12e2 * t888 * t797 + 0.96e2 * t838 * t327
  t897 = jnp.pi ** 2
  t898 = 0.1e1 / t897
  t900 = t16 + 0.56553500000000000000000000000000000000000000000000e0 * t17 + 0.130045e2
  t901 = 0.1e1 / t900
  t903 = t4 * t12 * t901
  t905 = t900 ** 2
  t906 = 0.1e1 / t905
  t907 = t26 * t906
  t909 = -t32 - 0.94255833333333333333333333333333333333333333333334e-1 * t37
  t914 = 0.1e1 / t905 / t900
  t915 = t13 * t914
  t916 = t909 ** 2
  t920 = t13 * t906
  t923 = t52 - 0.62837222222222222222222222222222222222222222222223e-1 * t63 + 0.12567444444444444444444444444444444444444444444445e0 * t66
  t929 = (t903 / 0.9e1 + t24 * t907 * t909 / 0.6e1 + t24 * t915 * t916 / 0.2e1 - t24 * t920 * t923 / 0.4e1) * t55 * t74
  t930 = t76 * t900
  t941 = (-t4 * t30 * t901 / 0.12e2 - t24 * t920 * t909 / 0.4e1) * t55 * t74
  t942 = t90 * t900
  t945 = t76 * t909
  t948 = t17 + 0.113107e1
  t949 = t948 ** 2
  t950 = t949 * t948
  t952 = 0.1e1 / t950 * t1
  t953 = t952 * t3
  t954 = 0.1e1 / t949
  t956 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t954
  t957 = 0.1e1 / t956
  t962 = t954 * t54 * t55
  t968 = t954 * t33 * t1
  t973 = t949 ** 2
  t975 = 0.1e1 / t973 / t948
  t976 = t975 * t1
  t977 = t976 * t3
  t978 = t956 ** 2
  t979 = 0.1e1 / t978
  t984 = t133 + 0.47584e-2
  t985 = t984 * t906
  t986 = t985 * t34
  t987 = t26 * t909
  t991 = t984 * t901
  t992 = t991 * t54
  t995 = t991 * t33
  t998 = t984 ** 2
  t999 = t998 * t914
  t1002 = t998 * t906
  t1004 = t903 / 0.72e2 + t986 * t35 * t987 / 0.3e1 - t992 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t995 * t51 + 0.2e1 * t999 * t916 - t1002 * t923
  t1005 = 0.1e1 / t998
  t1006 = t1004 * t1005
  t1012 = -t995 * t31 / 0.6e1 - t1002 * t909
  t1014 = 0.1e1 / t998 / t984
  t1015 = t1012 * t1014
  t1016 = t900 * t33
  t1017 = t1015 * t1016
  t1020 = t1012 * t1005
  t1024 = t898 * (t929 * t930 / 0.3e1 + t941 * t942 / 0.9e1 + t941 * t945 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 * t953 * t12 * t957 + 0.25145208020597448648343800944658141583651393365495e0 * t962 * t58 * t61 * t957 - 0.50290416041194897296687601889316283167302786730989e0 * t968 * t35 * t11 * t957 - 0.63791733988157656503906862782236557702656491548799e1 * t977 * t12 * t979 + 0.41403379428206274608377249480129098139321562919141e-3 * t1006 * t900 + 0.69005632380343791013962082466881830232202604865235e-4 * t1017 * t31 + 0.41403379428206274608377249480129098139321562919141e-3 * t1020 * t909)
  t1025 = t1024 * t316
  t1031 = 0.9e1 * t319
  t1032 = t321 * (-0.4e1 * t323 * t326 + 0.4e1 * t385 * t388) * t1031
  t1044 = t898 * (t941 * t930 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t968 * t35 * t26 * t957 + 0.41403379428206274608377249480129098139321562919141e-3 * t1020 * t900)
  t1045 = t1044 * t383
  t1049 = t321 * (-t385 * t326 + 0.1e1) * t1031
  t1052 = t1024 * t398
  t1065 = t304 ** 2
  t1068 = t360 ** 2
  t1074 = t367 ** 2
  t1079 = t301 * t388
  t1081 = -0.24e2 * t326 + 0.24e2 * t1079
  t1085 = f.my_piecewise3(t305, 0, 0.40e2 / 0.81e2 / t355 / t1065 * t1068 - 0.16e2 / 0.9e1 * t842 * t360 * t367 + 0.4e1 / 0.3e1 * t356 * t1074 + 0.16e2 / 0.9e1 * t846 * t851 + 0.4e1 / 0.3e1 * t308 * t1081)
  t1086 = t311 ** 2
  t1089 = t375 ** 2
  t1095 = t378 ** 2
  t1104 = f.my_piecewise3(t312, 0, 0.40e2 / 0.81e2 / t372 / t1086 * t1089 - 0.16e2 / 0.9e1 * t857 * t375 * t378 + 0.4e1 / 0.3e1 * t373 * t1095 + 0.16e2 / 0.9e1 * t861 * t864 - 0.4e1 / 0.3e1 * t313 * t1081)
  t1105 = t1085 + t1104
  t1122 = t354 * t1105 * t797 + 0.1440e4 * t833 * t400 * t426 + 0.4e1 * t423 * t869 * t797 + 0.48e2 * t888 * t327 - 0.16e2 * t796 * t389 - 0.480e3 * t399 * t883 - 0.384e3 * t838 * t404 + 0.96e2 * t424 * t835 - 0.576e3 * t424 * t875 + 0.960e3 * t424 * t878 - 0.480e3 * t424 * t883 + 0.240e3 * t838 * t427
  t1124 = 0.31090700000000000000000000000000000000000000000001e-1 * t206 * t566
  t1126 = 0.20727133333333333333333333333333333333333333333334e-1 * t206 * t569
  t1129 = 0.64601518076962494758402628807041432700328989996342e-3 * t292 * t177 * t474
  t1131 = 0.1e1 / t9 / t325
  t1135 = 0.20435174860777645787105769785744382475812907568201e0 * t228 * t1131 * t234 * t24
  t1139 = 0.77340987998746992664586274965084728992118817729523e1 * t252 * t1131 * t256 * t24
  t1140 = t6 * t1131
  t1142 = t4 * t1140 * t178
  t1146 = t24 * t444 * t183 * t186
  t1150 = t24 * t11 * t191 * t193
  t1153 = t24 * t449 * t200
  t1166 = 0.1e1 / t460 / t177
  t1168 = t193 ** 2
  t1172 = t193 * t200
  t1176 = t200 ** 2
  t1180 = t186 * t484
  t1184 = t4 * t1140
  t1185 = 0.70e2 / 0.81e2 * t1184
  t1189 = 0.1e1 / t17 / t2 / t302 / 0.48e2
  t1190 = t1189 * t2
  t1192 = 0.1e1 / t9 / t387
  t1194 = t1190 * t1192 * t24
  t1196 = t473 * t388
  t1199 = 0.1e1 / t59 / t325
  t1201 = t56 * t58 * t1199
  t1204 = t34 * t35 * t1131
  t1206 = t1185 - 0.10354000000000000000000000000000000000000000000000e1 * t1194 + 0.99398400000000000000000000000000000000000000000000e1 * t1196 - 0.36814222222222222222222222222222222222222222222222e1 * t1201 + 0.32212444444444444444444444444444444444444444444444e1 * t1204
  t1210 = 0.70e2 / 0.81e2 * t1142 + 0.28e2 / 0.27e2 * t1146 + 0.4e1 / 0.3e1 * t1150 - 0.2e1 / 0.3e1 * t1153 + 0.2e1 * t24 * t26 * t461 * t463 - 0.2e1 * t24 * t453 * t467 + t24 * t184 * t484 / 0.3e1 + 0.6e1 * t24 * t13 * t1166 * t1168 - 0.9e1 * t24 * t462 * t1172 + 0.3e1 / 0.2e1 * t24 * t192 * t1176 + 0.2e1 * t24 * t192 * t1180 - t24 * t197 * t1206 / 0.4e1
  t1214 = 0.10363566666666666666666666666666666666666666666667e-1 * t1210 * t55 * t74 * t207
  t1217 = 0.69090444444444444444444444444444444444444444444446e-2 * t218 * t498 * t186
  t1219 = 0.31090700000000000000000000000000000000000000000001e-1 * t490 * t222
  t1222 = 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t76 * t484
  t1225 = 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t90 * t200
  t1227 = 0.69090444444444444444444444444444444444444444444446e-2 * t206 * t499
  t1229 = 0.10363566666666666666666666666666666666666666666667e-1 * t490 * t219
  t1232 = 0.38383580246913580246913580246913580246913580246915e-2 * t218 * t144 * t177
  t1233 = t1124 + t1126 + t1129 + t1135 - t1139 + t1214 - t1217 + t1219 + t1222 + t1225 - t1227 + t1229 + t1232
  t1242 = jnp.log(t4 * t14 * t901 / 0.4e1)
  t1245 = jnp.atan(0.71231089178181179907634622339714221951452652573438e1 / t948)
  t1248 = jnp.log(t998 * t901)
  t1251 = t898 * (t1242 + 0.31770800474394146398819696256107927053514547209957e0 * t1245 + 0.41403379428206274608377249480129098139321562919141e-3 * t1248)
  t1252 = t1251 * t398
  t1262 = t321 * (0.144e3 * t322 * t388 - 0.240e3 * t323 * t426 + 0.120e3 * t385 * t882 - 0.24e2 * t849) * t1031
  t1265 = t1251 * t316
  t1272 = t325 ** 2
  t1273 = 0.1e1 / t1272
  t1285 = t255 ** 2
  t1288 = t74 * t5
  t1291 = 0.19162434373246948642083122762742588170998040494372e4 / t602 / t227 * t2 * t1199 / t1285 * t55 * t1288
  t1295 = 0.47129772651883579472964658244599656881154093130267e0 * t239 * t58 * t1199 * t234
  t1301 = 0.17673664744456342302361746841724871330432784923849e-1 * t252 * t2 * t1199 * t234 * t55 * t1288
  t1309 = 0.26755801253620581246127143771704987327003266673998e1 / t250 / t227 * t2 * t1199 * t256 * t55 * t1288
  t1317 = 0.12657832131062950425061722062546552262841476284429e3 / t602 / t225 * t2 * t1199 * t608 * t55 * t1288
  t1321 = 0.41238551070398132038844075964024699771009831488983e0 * t245 * t35 * t1131 * t234
  t1322 = t5 * t1199
  t1325 = 0.19441031218901976532597921525897358463476063416234e0 * t680 * t1322 * t681
  t1328 = 0.17168305804406539632931583920177366868160429449148e2 * t688 * t1322 * t689
  t1329 = -0.192e3 * t317 * t404 + 0.16e2 * t796 * t327 - t1252 * t1262 / 0.6e1 - t1265 * t321 * (-0.840e3 * t385 * t1273 - 0.1440e4 * t322 * t426 + 0.1920e4 * t323 * t882 + 0.384e3 * t1079 - 0.24e2 * t326) * t1031 / 0.24e2 - t1291 + t1295 + t1301 - t1309 + t1317 - t1321 - t1325 + t1328
  t1331 = 0.14804514559303905048800602434946994993825393540828e-3 * t675 * t471
  t1335 = 0.12112784639430467767200492901320268631311685624314e-3 * t281 * t673 * t177 * t51
  t1338 = 0.16200859349084980443831601271581132052896719513529e-1 * t693 * t1140 * t694
  t1341 = 0.61315377872880498689041371143490595957715819461244e0 * t698 * t1140 * t699
  t1344 = 0.37129640917784654580181051383469886637668330434323e3 * t605 * t1322 * t609
  t1347 = 0.12112784639430467767200492901320268631311685624314e-3 * t674 * t186 * t51
  t1354 = t1251 * t869
  t1359 = t1044 * t316
  t1373 = t90 * t909
  t1376 = t76 * t923
  t1382 = t4 * t445 * t901
  t1384 = t11 * t906
  t1386 = t24 * t1384 * t909
  t1388 = t26 * t914
  t1395 = t905 ** 2
  t1396 = 0.1e1 / t1395
  t1397 = t13 * t1396
  t1398 = t916 * t909
  t1402 = t909 * t923
  t1409 = -t472 - 0.37702333333333333333333333333333333333333333333334e0 * t474 + 0.25134888888888888888888888888888888888888888888890e0 * t479 - 0.29324037037037037037037037037037037037037037037038e0 * t482
  t1415 = (-0.7e1 / 0.27e2 * t1382 - t1386 / 0.3e1 - t24 * t1388 * t916 / 0.2e1 + t24 * t907 * t923 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t1397 * t1398 + 0.3e1 / 0.2e1 * t24 * t915 * t1402 - t24 * t920 * t1409 / 0.4e1) * t55 * t74
  t1423 = 0.1e1 / t973
  t1424 = t1423 * t55
  t1425 = t1424 * t57
  t1426 = t957 * t33
  t1431 = 0.1e1 / t973 / t949
  t1432 = t1431 * t55
  t1433 = t1432 * t57
  t1434 = t979 * t33
  t1438 = t952 * t634
  t1439 = t2 * t957
  t1443 = -0.10058083208238979459337520377863256633460557346198e1 * t962 * t58 * t477 * t957 + 0.11734430409612142702560440440840466072370650237231e1 * t968 * t35 * t444 * t957 + 0.23390302462324474051432516353486737824307380234560e2 * t977 * t445 * t979 + 0.2e1 / 0.9e1 * t941 * t1373 + t941 * t1376 / 0.3e1 + 0.2e1 / 0.3e1 * t929 * t945 + t1415 * t930 / 0.3e1 - 0.92007509840458388018616109955842440309603473153646e-4 * t1017 * t51 - 0.46099548037761989188630301731873259570027554503406e0 * t953 * t445 * t957 + 0.25145208020597448648343800944658141583651393365494e0 * t1425 * t606 * t1426 - 0.29769475861140239701823202631710393594573029389440e2 * t1433 * t606 * t1434 + 0.20954340017164540540286500787215117986376161137912e-1 * t1438 * t445 * t1439
  t1444 = t976 * t634
  t1445 = t2 * t979
  t1451 = t984 * t914
  t1452 = t1451 * t34
  t1456 = t985 * t56
  t1478 = t998 * t1396
  t1484 = -0.11e2 / 0.216e3 * t1382 - t1386 / 0.24e2 - t1452 * t35 * t26 * t916 + t1456 * t58 * t61 * t909 / 0.3e1 - 0.2e1 / 0.3e1 * t986 * t35 * t11 * t909 + t986 * t35 * t26 * t923 / 0.2e1 + t726 * t727 * t901 / 0.432e3 - 0.2e1 / 0.3e1 * t991 * t474 + 0.4e1 / 0.9e1 * t992 * t733 - 0.14e2 / 0.27e2 * t995 * t471 - 0.6e1 * t1478 * t1398 + 0.6e1 * t999 * t1402 - t1002 * t1409
  t1485 = t1484 * t1005
  t1492 = t909 * t33
  t1493 = t1015 * t1492
  t1496 = t900 * t54
  t1497 = t1015 * t1496
  t1500 = t1004 * t1014
  t1501 = t1500 * t1016
  t1504 = t973 ** 2
  t1505 = 0.1e1 / t1504
  t1506 = t1505 * t55
  t1507 = t1506 * t57
  t1509 = 0.1e1 / t978 / t956
  t1510 = t1509 * t33
  t1514 = t998 ** 2
  t1515 = 0.1e1 / t1514
  t1516 = t1012 * t1515
  t1517 = t1516 * t900
  t1522 = t498 * t900
  t1525 = t954 * t433
  t1529 = -0.10631955664692942750651143797039426283776081924800e1 * t1444 * t445 * t1445 + 0.41403379428206274608377249480129098139321562919141e-3 * t1485 * t900 + 0.82806758856412549216754498960258196278643125838282e-3 * t1006 * t909 + 0.41403379428206274608377249480129098139321562919141e-3 * t1020 * t923 + 0.13801126476068758202792416493376366046440520973047e-3 * t1493 * t31 + 0.46003754920229194009308054977921220154801736576823e-4 * t1497 * t145 + 0.13801126476068758202792416493376366046440520973047e-3 * t1501 * t31 + 0.86312224513605868227832795632565231845861115350066e3 * t1507 * t606 * t1510 + 0.17251408095085947753490520616720457558050651216309e-4 * t1517 * t51 + 0.2e1 / 0.9e1 * t929 * t942 - 0.2e1 / 0.27e2 * t941 * t1522 + 0.15087124812358469189006280566794884950190836019297e1 * t1525 * t435 * t957
  t1531 = t898 * (t1443 + t1529)
  t1532 = t1531 * t316
  t1535 = t1044 * t398
  t1544 = t321 * (-0.12e2 * t322 * t326 + 0.32e2 * t323 * t388 - 0.20e2 * t385 * t426) * t1031
  t1547 = -t1331 + t1335 - t1338 + t1341 - t1344 + t1347 - t1024 * t383 * t1049 / 0.4e1 - t1251 * t1105 * t1049 / 0.24e2 - t1354 * t1032 / 0.6e1 - t1045 * t1032 / 0.2e1 - t1359 * t1262 / 0.6e1 - t1532 * t1032 / 0.6e1 - t1535 * t1544 / 0.2e1
  t1555 = -t1124 - t1126 - t1129 - t1135 + t1139 - t1214 + t1217 - t1219 - t1222 - t1225 + t1227 - t1229
  t1556 = -t1232 + t1291 - t1295 - t1301 + t1309 - t1317 + t1321 + t1325 - t1328 + t1331 - t1335 + t1338 - t1341
  t1565 = 0.53020994233369026907085240525174613991298354771548e-1 * t678 * t2 * t388 * t234 * t54
  t1570 = 0.46822652193836017180722501600483727822255716679496e1 * t686 * t2 * t388 * t256 * t54
  t1571 = t2 * t388
  t1574 = 0.12725038616008566457700457726041907357911605145172e1 * t439 * t1571 * t234
  t1579 = 0.10126265704850360340049377650037241810273181027543e3 * t603 * t2 * t388 * t608 * t54
  t1592 = t1344 - t1347 + 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t90 * t68 - t1565 + t1570 + t1574 - t1579 + 0.51817833333333333333333333333333333333333333333333e-2 * t544 * t91 + 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t76 * t538 + 0.19191790123456790123456790123456790123456790123457e-2 * t88 * t144 * t19 + 0.15545350000000000000000000000000000000000000000000e-1 * t75 * t502 + 0.15545350000000000000000000000000000000000000000000e-1 * t544 * t94
  t1622 = t127 ** 2
  t1654 = -0.34545222222222222222222222222222222222222222222222e-2 * t88 * t498 * t39 + 0.18395032923497521448984473398719010474438432911759e-1 * t124 * t2 * t1199 * t106 * t55 * t1288 - 0.16468461837198391751404838221570273925751472131273e1 / t122 / t99 * t2 * t1199 * t128 * t55 * t1288 + 0.46073958594418340718689014996103000237833507556650e2 / t645 / t97 * t2 * t1199 * t650 * t55 * t1288 - 0.41248484411876216403621151040619215743173669759529e3 / t645 / t99 * t2 * t1199 / t1622 * t55 * t1288 - 0.20234536215847273593882920738590911521882276202934e0 * t621 * t1322 * t622 + 0.10567263012202301373818104525507592435690527950900e2 * t629 * t1322 * t630 - 0.16862113513206061328235767282159092934901896835780e-1 * t635 * t1140 * t636 + 0.37740225043579647763636087591098544413180456967501e0 * t640 * t1140 * t641 - 0.13515027854362713277482111065523546736431162216617e3 * t648 * t1322 * t651 + 0.49053421129326723863958595729917361265169154431359e0 * t111 * t58 * t1199 * t106 + 0.28098338694282647979081704945528765475700933313214e-3 * t615 * t39 * t51 - 0.42921743488160883380963771263677691107023010127437e0 * t117 * t35 * t1131 * t106
  t1679 = t2 * t1192
  t1684 = 0.13255248558342256726771310131293653497824588692887e0 * t231 * t1189 * t1679 * t234 * t1 * t35
  t1687 = 0.96902277115443742137603943210562149050493484994510e-3 * t572 * t598 * t31
  t1689 = 0.50245625170970829256535377961032225433589214441597e-3 * t294 * t471
  t1691 = 0.43067678717974996505601752538027621800219326664227e-3 * t589 * t733
  t1693 = 0.64601518076962494758402628807041432700328989996340e-3 * t573 * t51
  t1694 = 0.28098338694282647979081704945528765475700933313214e-3 * t157 * t614 * t19 * t51 - 0.34342413959678791974433194933424046692523362938372e-3 * t616 * t471 - 0.34545222222222222222222222222222222222222222222222e-2 * t75 * t555 + 0.14985780636950745588843575970948674920373831100381e-2 * t168 * t19 * t474 + 0.21269256817794009175388297367268855861069438054221e0 * t100 * t1131 * t106 * t24 - 0.47604147498151601156404610484226573066625349129460e1 * t124 * t1131 * t128 * t24 + 0.10363566666666666666666666666666666666666666666667e-1 * t75 * t549 - t1684 - t1687 - t1689 + t1691 + t1693
  t1696 = 0.64601518076962494758402628807041432700328989996340e-3 * t599 * t51
  t1700 = 0.48451138557721871068801971605281074525246742497255e-3 * t292 * t200 * t33 * t31
  t1704 = 0.32300759038481247379201314403520716350164494998170e-3 * t292 * t186 * t54 * t145
  t1708 = 0.48451138557721871068801971605281074525246742497255e-3 * t783 * t291 * t293 * t31
  t1711 = 0.32300759038481247379201314403520716350164494998170e-3 * t572 * t588 * t145
  t1715 = t634 * t6 * t727
  t1717 = 0.67293247996835932040002738340668159062842697912856e-5 * t674 * t177 * t1 * t1715
  t1724 = t58 * t477 * t33
  t1726 = 0.53834598397468745632002190672534527250274158330283e-4 * t289 / t672 / t261 * t177 * t55 * t1724
  t1728 = t1199 * t2
  t1731 = 0.44184161861140855755904367104312178326081962309624e-2 * t679 * t1288 * t1728 * t681
  t1735 = 0.39018876828196680983935418000403106518546430566246e0 * t687 * t1288 * t1728 * t689
  t1739 = 0.84385547540419669500411480416977015085609841896189e1 * t604 * t1288 * t1728 * t609
  t1753 = t1696 - t1700 - t1704 - t1708 - t1711 - t1717 - t1726 - t1731 + t1735 - t1739 - 0.13244423704918215443268820847077687541595671696467e1 * t434 * t1571 * t106 + 0.36859166875534672574951211996882400190266806045320e2 * t646 * t2 * t388 * t650 * t54 + 0.55185098770492564346953420196157031423315298735276e-1 * t619 * t2 * t388 * t106 * t54
  t1760 = t1131 * t2
  t1770 = t24 * t11 * t44 * t46
  t1773 = t24 * t513 * t68
  t1775 = t46 * t68
  t1778 = t39 * t538
  t1782 = t4 * t1140 * t20
  t1786 = t24 * t444 * t28 * t39
  t1792 = t143 * t1322
  t1801 = -0.11e2 / 0.648e3 * t726 * t1760 * t20 + 0.8e1 / 0.3e1 * t135 * t433 * t435 * t39 + t1770 / 0.6e1 - t1773 / 0.12e2 - 0.36e2 * t738 * t1775 + 0.8e1 * t152 * t1778 + 0.185e3 / 0.864e3 * t1782 + 0.11e2 / 0.54e2 * t1786 - t726 * t727 * t28 * t39 / 0.108e3 - 0.160e3 / 0.81e2 * t142 * t1792 + 0.140e3 / 0.81e2 * t148 * t1184 - 0.4e1 * t708 * t35 * t137 * t68
  t1805 = 0.1e1 / t524 / t19
  t1807 = t46 ** 2
  t1810 = t68 ** 2
  t1817 = t1185 - 0.19612277777777777777777777777777777777777777777777e1 * t1194 + 0.18827786666666666666666666666666666666666666666666e2 * t1196 - 0.69732543209876543209876543209876543209876543209875e1 * t1201 + 0.61015975308641975308641975308641975308641975308640e1 * t1204
  t1838 = t1192 * t1 * t35
  t1859 = 0.16e2 / 0.3e1 * t141 * t1196 + 0.24e2 * t151 * t1805 * t1807 + 0.6e1 * t152 * t1810 - t155 * t1817 - 0.4e1 / 0.3e1 * t707 * t56 * t58 * t61 * t46 + 0.2e1 / 0.3e1 * t712 * t58 * t61 * t68 - 0.4e1 / 0.3e1 * t136 * t35 * t11 * t68 + 0.2e1 / 0.3e1 * t136 * t35 * t26 * t538 - 0.5e1 / 0.9e1 * t141 * t1190 * t1838 + 0.56e2 / 0.27e2 * t136 * t35 * t444 * t39 + 0.4e1 * t134 * t525 * t34 * t35 * t26 * t527 + 0.8e1 / 0.3e1 * t708 * t35 * t11 * t46 - 0.16e2 / 0.9e1 * t712 * t58 * t477 * t39
  t1865 = 0.29070683134633122641281182963168644715148045498353e-2 * t784 * t186
  t1867 = 0.29070683134633122641281182963168644715148045498353e-2 * t283 * t200
  t1875 = 0.96902277115443742137603943210562149050493484994510e-3 * t297 * t484
  t1903 = 0.185e3 / 0.864e3 * t1142 + 0.11e2 / 0.54e2 * t1146 + t1150 / 0.6e1 - t1153 / 0.12e2 + 0.8e1 / 0.3e1 * t262 * t433 * t435 * t186 - 0.11e2 / 0.648e3 * t726 * t1760 * t178 - t726 * t727 * t183 * t186 / 0.108e3 - 0.160e3 / 0.81e2 * t269 * t1792 + 0.140e3 / 0.81e2 * t272 * t1184 + 0.16e2 / 0.3e1 * t268 * t1196 - 0.4e1 * t751 * t35 * t264 * t200 - 0.36e2 * t777 * t1172
  t1950 = 0.8e1 * t276 * t1180 + 0.24e2 * t275 * t1166 * t1168 - t279 * t1206 + 0.6e1 * t276 * t1176 + 0.8e1 / 0.3e1 * t751 * t35 * t11 * t193 - 0.4e1 / 0.3e1 * t750 * t56 * t58 * t61 * t193 + 0.2e1 / 0.3e1 * t755 * t58 * t61 * t200 - 0.4e1 / 0.3e1 * t263 * t35 * t11 * t200 + 0.2e1 / 0.3e1 * t263 * t35 * t26 * t484 - 0.5e1 / 0.9e1 * t268 * t1190 * t1838 - 0.16e2 / 0.9e1 * t755 * t58 * t477 * t186 + 0.56e2 / 0.27e2 * t263 * t35 * t444 * t186 + 0.4e1 * t261 * t461 * t34 * t35 * t26 * t463
  t1954 = 0.96902277115443742137603943210562149050493484994510e-3 * (t1903 + t1950) * t282 * t177
  t1965 = -0.28819808215097185564958466887747979370065076229728e1 * t627 * t2 * t388 * t128 * t54 + 0.22478670955426118383265363956423012380560746650571e-2 * (t1801 + t1859) * t158 * t19 - t1865 - t1867 + 0.67436012866278355149796091869269037141682239951713e-2 * t745 * t39 + 0.67436012866278355149796091869269037141682239951713e-2 * t159 * t68 + 0.22478670955426118383265363956423012380560746650571e-2 * t173 * t538 - t1875 - t1954 + 0.13796274692623141086738355049039257855828824683819e0 * t103 * t1189 * t1679 * t106 * t1 * t35 - 0.14985780636950745588843575970948674920373831100381e-2 * t577 * t51 - 0.14985780636950745588843575970948674920373831100381e-2 * t581 * t51
  t2041 = 0.70e2 / 0.81e2 * t1782 + 0.28e2 / 0.27e2 * t1786 + 0.4e1 / 0.3e1 * t1770 - 0.2e1 / 0.3e1 * t1773 + 0.2e1 * t24 * t26 * t525 * t527 - 0.2e1 * t24 * t517 * t531 + t24 * t29 * t538 / 0.3e1 + 0.6e1 * t24 * t13 * t1805 * t1807 - 0.9e1 * t24 * t526 * t1775 + 0.3e1 / 0.2e1 * t24 * t45 * t1810 + 0.2e1 * t24 * t45 * t1778 - t24 * t50 * t1817 / 0.4e1
  t2046 = -0.99905204246338303925623839806324499469158874002539e-3 * t585 * t733 + 0.45987582308743803622461183496797526186096082279398e-2 * t620 * t1288 * t1728 * t622 - 0.24016506845914321304132055739789982808387563524773e0 * t628 * t1288 * t1728 * t630 + 0.11655607162072802124656114644071191604735201966963e-2 * t170 * t471 + 0.11239335477713059191632681978211506190280373325286e-2 * t744 * t167 * t169 * t31 + 0.22478670955426118383265363956423012380560746650571e-2 * t576 * t580 * t31 + 0.74928903184753727944217879854743374601869155501904e-3 * t576 * t584 * t145 + 0.11239335477713059191632681978211506190280373325286e-2 * t168 * t68 * t33 * t31 + 0.74928903184753727944217879854743374601869155501904e-3 * t168 * t39 * t54 * t145 + 0.15610188163490359988378724969738203042056074062897e-4 * t615 * t19 * t1 * t1715 + 0.30715972396278893812459343330735333491889005037766e1 * t647 * t1288 * t1728 * t651 + 0.12488150530792287990702979975790562433644859250317e-3 * t165 / t613 / t134 * t19 * t55 * t1724 + 0.51817833333333333333333333333333333333333333333333e-2 * t2041 * t55 * t74 * t77
  t2063 = 0.24e2 * t833 * t321 * t326 - t1025 * t1544 / 0.4e1 + (t1555 + t1556 + t1592 + t1654 + t1694 + t1753 + t1965 + t2046) * t316 * t797 + 0.72e2 * t317 * t401 + 0.96e2 * t399 * t835 - 0.576e3 * t399 * t875 + t1565 - t1570 - t1574 + t1579 - t1052 * t1032 / 0.2e1 - t1531 * t398 * t1049 / 0.6e1
  t2067 = t1251 * t383
  t2094 = -t1044 * t869 * t1049 / 0.6e1 - t2067 * t1544 / 0.4e1 + 0.48e2 * t830 * t327 - 0.48e2 * t888 * t389 + 0.4e1 * t795 * t398 * t797 + 0.120e3 * t384 * t427 + 0.72e2 * t384 * t401 - 0.192e3 * t384 * t404 - 0.48e2 * t830 * t389 - 0.384e3 * t833 * t834 * t388 + 0.120e3 * t317 * t427 - 0.16e2 * t870 * t389 + 0.144e3 * t838 * t401
  t2109 = 0.840e3 * t833 * t386 * t1273 + 0.6e1 * t300 * t383 * t797 - 0.1920e4 * t833 * t324 * t882 + 0.16e2 * t870 * t327 + 0.960e3 * t399 * t878 + t1684 + t1687 + t1689 - t1691 - t1693 - t1696 + t1700
  t2133 = t4 * t1140 * t901
  t2137 = t24 * t444 * t906 * t909
  t2141 = t24 * t11 * t914 * t916
  t2144 = t24 * t1384 * t923
  t2157 = 0.1e1 / t1395 / t900
  t2159 = t916 ** 2
  t2163 = t916 * t923
  t2167 = t923 ** 2
  t2171 = t909 * t1409
  t2179 = t1185 - 0.31418611111111111111111111111111111111111111111112e0 * t1194 + 0.30161866666666666666666666666666666666666666666668e1 * t1196 - 0.11171061728395061728395061728395061728395061728396e1 * t1201 + 0.97746790123456790123456790123456790123456790123460e0 * t1204
  t2183 = 0.70e2 / 0.81e2 * t2133 + 0.28e2 / 0.27e2 * t2137 + 0.4e1 / 0.3e1 * t2141 - 0.2e1 / 0.3e1 * t2144 + 0.2e1 * t24 * t26 * t1396 * t1398 - 0.2e1 * t24 * t1388 * t1402 + t24 * t907 * t1409 / 0.3e1 + 0.6e1 * t24 * t13 * t2157 * t2159 - 0.9e1 * t24 * t1397 * t2163 + 0.3e1 / 0.2e1 * t24 * t915 * t2167 + 0.2e1 * t24 * t915 * t2171 - t24 * t920 * t2179 / 0.4e1
  t2196 = t978 ** 2
  t2214 = 0.50290416041194897296687601889316283167302786730988e0 * t1423 * t2 * t388 * t957 * t54 - 0.59538951722280479403646405263420787189146058778880e2 * t1431 * t2 * t388 * t979 * t54 - 0.12069699849886775351205024453435907960152668815438e2 * t1525 * t1571 * t957 + 0.17262444902721173645566559126513046369172223070013e4 * t1505 * t2 * t388 * t1509 * t54 + t941 * t76 * t1409 / 0.3e1 + t1415 * t945 + t2183 * t55 * t74 * t930 / 0.3e1 + 0.51754224285257843260471561850161372674151953648927e-4 * t1004 * t1515 * t900 * t51 - 0.43793683962271420729973795871593892966464398384137e5 / t1504 / t950 * t2 * t1199 / t2196 * t55 * t1288 + 0.51754224285257843260471561850161372674151953648927e-4 * t1516 * t909 * t51 - 0.18439819215104795675452120692749303828011021801362e1 * t1425 * t1322 * t1426 + 0.16763472013731632432229200629772094389100928910329e0 * t975 * t2 * t1199 * t957 * t55 * t1288
  t2279 = -0.36e2 * t1478 * t2163 + 0.8e1 * t999 * t2171 + 0.16e2 / 0.3e1 * t991 * t1196 + 0.185e3 / 0.864e3 * t2133 - 0.4e1 * t1452 * t35 * t987 * t923 - t726 * t727 * t906 * t909 / 0.108e3 - 0.160e3 / 0.81e2 * t992 * t1792 + 0.140e3 / 0.81e2 * t995 * t1184 - t1002 * t2179 + 0.24e2 * t998 * t2157 * t2159 + 0.6e1 * t999 * t2167 + 0.11e2 / 0.54e2 * t2137
  t2327 = t2141 / 0.6e1 - t2144 / 0.12e2 - 0.11e2 / 0.648e3 * t726 * t1760 * t901 + 0.8e1 / 0.3e1 * t985 * t433 * t435 * t909 - 0.5e1 / 0.9e1 * t991 * t1190 * t1838 + 0.8e1 / 0.3e1 * t1452 * t35 * t11 * t916 - 0.16e2 / 0.9e1 * t1456 * t58 * t477 * t909 + 0.56e2 / 0.27e2 * t986 * t35 * t444 * t909 + 0.4e1 * t984 * t1396 * t34 * t35 * t26 * t1398 - 0.4e1 / 0.3e1 * t1451 * t56 * t58 * t61 * t916 + 0.2e1 / 0.3e1 * t1456 * t58 * t61 * t923 - 0.4e1 / 0.3e1 * t986 * t35 * t11 * t923 + 0.2e1 / 0.3e1 * t986 * t35 * t26 * t1409
  t2338 = -0.34022258127017416802083660150526164108083462159360e2 / t973 / t950 * t2 * t1199 * t979 * t55 * t1288 + 0.21578056128401467056958198908141307961465278837517e4 / t1504 / t948 * t2 * t1199 * t1509 * t55 * t1288 - 0.63255163015315141762798575594641677712852387793133e-4 * t1517 * t471 + 0.21830948964836175781337015263254288636020221552256e3 * t1433 * t1322 * t1434 - 0.63295631309977636700410716797214503353631484590049e4 * t1507 * t1322 * t1510 - 0.15366516012587329729543433910624419856675851501136e0 * t1438 * t1140 * t1439 + 0.77967674874414913504775054511622459414357934115200e1 * t1444 * t1140 * t1445 + 0.44702592036617686485944535012725585037602477094213e1 * t962 * t58 * t1199 * t957 - 0.39114768032040475675201468136134886907902167457437e1 * t968 * t35 * t1131 * t957 + 0.41403379428206274608377249480129098139321562919141e-3 * (t2279 + t2327) * t1005 * t900 + 0.41403379428206274608377249480129098139321562919141e-3 * t1020 * t1409 + 0.12421013828461882382513174844038729441796468875742e-2 * t1006 * t923 + 0.12421013828461882382513174844038729441796468875742e-2 * t1485 * t909
  t2371 = 0.10e2 / 0.81e2 * t941 * t144 * t900 - 0.2e1 / 0.9e1 * t929 * t1522 + t941 * t90 * t923 / 0.3e1 + t929 * t1376 + 0.27602252952137516405584832986752732092881041946094e-3 * t1015 * t900 * t474 + t1415 * t942 / 0.3e1 - 0.2e1 / 0.9e1 * t941 * t498 * t909 + 0.19382764515877199999765013228173984137397949052569e1 * t953 * t1140 * t957 - 0.98345589898409720443523080122614693124928757804400e2 * t977 * t1140 * t979 + 0.2e1 / 0.3e1 * t929 * t1373 + 0.21468418962773623871010425656363236072240810402517e-3 * t1017 * t471 + 0.20701689714103137304188624740064549069660781459570e-3 * t1484 * t1014 * t1016 * t31
  t2421 = 0.41403379428206274608377249480129098139321562919141e-3 * t1500 * t1492 * t31 + 0.23001877460114597004654027488960610077400868288412e-4 * t1012 / t1514 / t984 * t900 * t55 * t1724 + 0.12572604010298724324171900472329070791825696682747e1 * t954 * t1189 * t1679 * t957 * t1 * t35 + 0.41908680034329081080573001574430235972752322275824e-1 * t1424 * t1288 * t1728 * t1426 - 0.49615793101900399503038671052850655990955048982400e1 * t1432 * t1288 * t1728 * t1434 + 0.14385370752267644704638799272094205307643519225011e3 * t1506 * t1288 * t1728 * t1510 - 0.27602252952137516405584832986752732092881041946094e-3 * t1501 * t51 - 0.27602252952137516405584832986752732092881041946094e-3 * t1493 * t51 - 0.18401501968091677603723221991168488061920694630729e-3 * t1497 * t733 + 0.20701689714103137304188624740064549069660781459570e-3 * t1015 * t923 * t33 * t31 + 0.13801126476068758202792416493376366046440520973047e-3 * t1015 * t909 * t54 * t145 + 0.13801126476068758202792416493376366046440520973047e-3 * t1500 * t1496 * t145 + 0.28752346825143246255817534361200762596751085360514e-5 * t1516 * t900 * t1 * t1715
  t2428 = t1704 + t1708 + t1711 + t1717 + t1726 + t1731 - t1735 + t1739 + t1865 + t1867 + t1875 + t1954 - t898 * (t2214 + t2338 + t2371 + t2421) * t316 * t1049 / 0.24e2
  t2446 = 0.38760910846177496855041577284224859620197393997804e-2 * t785 + 0.38760910846177496855041577284224859620197393997804e-2 * t787 + 0.77521821692354993710083154568449719240394787995608e-2 * t789 - t1025 * t1032 / 0.2e1 - t1045 * t1049 / 0.2e1 - t1052 * t1049 / 0.2e1 + t7 * (t1122 + t1233 + t1329 + t1547 + t2063 + t2094 + t2109 + t2428) - t1532 * t1049 / 0.6e1 - t1252 * t1544 / 0.2e1 - t1359 * t1544 / 0.2e1 - t1354 * t1049 / 0.6e1 - t2067 * t1032 / 0.2e1 - t1265 * t1262 / 0.6e1 - t1535 * t1032
  d1111 = t810 + t825 + t893 + t2446

  res = {'v4rho4': d1111}
  return res
