"""Generated from lda_c_vwn_3.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + DMC(rs, z) / DRPA(rs, z) * f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + DMC(rs, z) / DRPA(rs, z) * f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + DMC(rs, z) / DRPA(rs, z) * f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = t11 / 0.4e1
  t13 = jnp.sqrt(t11)
  t15 = t12 + 0.18637200000000000000000000000000000000000000000000e1 * t13 + 0.129352e2
  t16 = 0.1e1 / t15
  t20 = jnp.log(t4 * t10 * t16 / 0.4e1)
  t21 = 0.310907e-1 * t20
  t22 = t13 + 0.372744e1
  t25 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t22)
  t26 = 0.38783294878113014394824731224995739188004877421366e-1 * t25
  t27 = t13 / 0.2e1
  t28 = t27 + 0.10498e0
  t29 = t28 ** 2
  t31 = jnp.log(t29 * t16)
  t32 = 0.96902277115443742137603943210562149050493484994510e-3 * t31
  t34 = t12 + 0.35302100000000000000000000000000000000000000000000e1 * t13 + 0.180578e2
  t35 = 0.1e1 / t34
  t39 = jnp.log(t4 * t10 * t35 / 0.4e1)
  t41 = t13 + 0.706042e1
  t44 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t41)
  t46 = t27 + 0.32500e0
  t47 = t46 ** 2
  t49 = jnp.log(t47 * t35)
  t51 = 0.1554535e-1 * t39 + 0.52491393169780936217021346072241076933841385384498e-1 * t44 + 0.22478670955426118383265363956423012380560746650571e-2 * t49 - t21 - t26 - t32
  t53 = t12 + 0.10061550000000000000000000000000000000000000000000e2 * t13 + 0.101578e3
  t54 = 0.1e1 / t53
  t58 = jnp.log(t4 * t10 * t54 / 0.4e1)
  t60 = t13 + 0.201231e2
  t63 = jnp.arctan(0.11716852777089929792201907797022178188779527234376e1 / t60)
  t65 = t27 + 0.743294e0
  t66 = t65 ** 2
  t68 = jnp.log(t66 * t54)
  t71 = t12 + 0.65360000000000000000000000000000000000000000000000e1 * t13 + 0.427198e2
  t72 = 0.1e1 / t71
  t76 = jnp.log(t4 * t10 * t72 / 0.4e1)
  t78 = t13 + 0.130720e2
  t81 = jnp.arctan(0.44899888641287296627004984787798591621072237693345e-1 / t78)
  t83 = t27 + 0.409286e0
  t84 = t83 ** 2
  t86 = jnp.log(t84 * t72)
  t88 = 0.1554535e-1 * t58 + 0.61881802979060631480216141626488805225499304723700e0 * t63 + 0.26673100072733151593315970562575695370840511204614e-2 * t68 - 0.310907e-1 * t76 - 0.20521972937837502661166379517614390730124411627871e2 * t81 - 0.44313737677495382697984551091739236689629774931818e-2 * t86
  t89 = 0.1e1 / t88
  t90 = t51 * t89
  t91 = jnp.pi ** 2
  t92 = 0.1e1 / t91
  t94 = t12 + 0.53417500000000000000000000000000000000000000000000e0 * t13 + 0.114813e2
  t95 = 0.1e1 / t94
  t99 = jnp.log(t4 * t10 * t95 / 0.4e1)
  t100 = t13 + 0.106835e1
  t103 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t100)
  t105 = t27 + 0.228344e0
  t106 = t105 ** 2
  t108 = jnp.log(t106 * t95)
  t111 = t92 * (t99 + 0.32323836906055067299704130765928097906535029214057e0 * t103 + 0.21608710360898267021763215722876235716176892439270e-1 * t108)
  t112 = t90 * t111
  t113 = r0 - r1
  t114 = 0.1e1 / t7
  t115 = t113 * t114
  t116 = 0.1e1 + t115
  t117 = t116 <= f.p.zeta_threshold
  t118 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t119 = t118 * f.p.zeta_threshold
  t120 = t116 ** (0.1e1 / 0.3e1)
  t122 = f.my_piecewise3(t117, t119, t120 * t116)
  t123 = 0.1e1 - t115
  t124 = t123 <= f.p.zeta_threshold
  t125 = t123 ** (0.1e1 / 0.3e1)
  t127 = f.my_piecewise3(t124, t119, t125 * t123)
  t128 = t122 + t127 - 0.2e1
  t129 = 2 ** (0.1e1 / 0.3e1)
  t130 = t129 - 0.1e1
  t132 = 0.1e1 / t130 / 0.2e1
  t133 = t128 * t132
  t134 = t113 ** 2
  t135 = t134 ** 2
  t136 = t7 ** 2
  t137 = t136 ** 2
  t138 = 0.1e1 / t137
  t141 = 0.9e1 / 0.4e1 * t130
  t142 = (-t135 * t138 + 0.1e1) * t141
  t143 = t133 * t142
  t145 = t112 * t143 / 0.6e1
  t146 = t51 * t128
  t147 = t132 * t135
  t148 = t147 * t138
  t149 = t146 * t148
  t151 = 0.1e1 / t8 / t7
  t152 = t6 * t151
  t156 = t4 * t6
  t157 = t15 ** 2
  t158 = 0.1e1 / t157
  t160 = t4 * t152
  t161 = t160 / 0.12e2
  t162 = 0.1e1 / t13
  t164 = t3 * t6
  t166 = t162 * t1 * t164 * t151
  t168 = -t161 - 0.31062000000000000000000000000000000000000000000000e0 * t166
  t173 = t1 ** 2
  t175 = 0.1e1 / t3
  t177 = t5 * t8
  t180 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t152 * t16 / 0.12e2 - t156 * t9 * t158 * t168 / 0.4e1) * t173 * t175 * t177 * t15
  t181 = t22 ** 2
  t182 = 0.1e1 / t181
  t191 = 0.39765745675026770180313930393880960493473766078662e-1 * t182 * t162 * t1 * t164 * t151 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t182)
  t202 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t28 * t16 * t162 * t160 / 0.6e1 - t29 * t158 * t168) / t29 * t15
  t206 = t34 ** 2
  t207 = 0.1e1 / t206
  t210 = -t161 - 0.58836833333333333333333333333333333333333333333333e0 * t166
  t220 = t41 ** 2
  t221 = 0.1e1 / t220
  t242 = 0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t152 * t35 / 0.12e2 - t156 * t9 * t207 * t210 / 0.4e1) * t173 * t175 * t177 * t34 + 0.41388824077869423260215065147117773567486474051459e-1 * t221 * t162 * t1 * t164 * t151 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t221) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t46 * t35 * t162 * t160 / 0.6e1 - t47 * t207 * t210) / t47 * t34 - t180 - t191 - t202
  t246 = t242 * t89 * t111 * t143 / 0.6e1
  t247 = t88 ** 2
  t254 = t53 ** 2
  t255 = 0.1e1 / t254
  t258 = -t161 - 0.16769250000000000000000000000000000000000000000000e1 * t166
  t268 = t60 ** 2
  t269 = 0.1e1 / t268
  t293 = t71 ** 2
  t294 = 0.1e1 / t293
  t297 = -t161 - 0.10893333333333333333333333333333333333333333333333e1 * t166
  t307 = t78 ** 2
  t308 = 0.1e1 / t307
  t333 = t51 / t247 * t111 * t133 * t142 * (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t152 * t54 / 0.12e2 - t156 * t9 * t255 * t258 / 0.4e1) * t173 * t175 * t177 * t53 + 0.12084332918108974174888840683936962325623378790503e0 * t269 * t162 * t1 * t164 * t151 / (0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t269) + 0.26673100072733151593315970562575695370840511204614e-2 * (-t65 * t54 * t162 * t160 / 0.6e1 - t66 * t255 * t258) / t66 * t53 - 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t152 * t72 / 0.12e2 - t156 * t9 * t294 * t297 / 0.4e1) * t173 * t175 * t177 * t71 - 0.15357238326806922974073998139716493771837789312610e0 * t308 * t162 * t1 * t164 * t151 / (0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t308) - 0.44313737677495382697984551091739236689629774931818e-2 * (-t83 * t72 * t162 * t160 / 0.6e1 - t84 * t294 * t297) / t84 * t71) / 0.6e1
  t337 = t94 ** 2
  t338 = 0.1e1 / t337
  t341 = -t161 - 0.89029166666666666666666666666666666666666666666667e-1 * t166
  t351 = t100 ** 2
  t352 = 0.1e1 / t351
  t377 = t90 * t92 * ((-t4 * t152 * t95 / 0.12e2 - t156 * t9 * t338 * t341 / 0.4e1) * t173 * t175 * t177 * t94 / 0.3e1 + 0.36052240899892258526768857735182864136354273012771e0 * t352 * t162 * t1 * t164 * t151 / (0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t352) + 0.21608710360898267021763215722876235716176892439270e-1 * (-t105 * t95 * t162 * t160 / 0.6e1 - t106 * t338 * t341) / t106 * t94) * t143 / 0.6e1
  t379 = t113 / t136
  t380 = t114 - t379
  t383 = f.my_piecewise3(t117, 0, 0.4e1 / 0.3e1 * t120 * t380)
  t387 = f.my_piecewise3(t124, 0, -0.4e1 / 0.3e1 * t125 * t380)
  t388 = t383 + t387
  t393 = t134 * t113
  t394 = t393 * t138
  t396 = 0.1e1 / t137 / t7
  t397 = t135 * t396
  t405 = t242 * t128 * t148
  t411 = 0.4e1 * t146 * t132 * t393 * t138
  t414 = 0.4e1 * t146 * t147 * t396
  t415 = t180 + t191 + t202 - t246 + t333 - t377 - t112 * t388 * t132 * t142 / 0.6e1 - t112 * t133 * (-0.4e1 * t394 + 0.4e1 * t397) * t141 / 0.6e1 + t405 + t51 * t388 * t148 + t411 - t414
  vrho_0_ = t7 * t415 - t145 + t149 + t21 + t26 + t32
  t417 = -t114 - t379
  t420 = f.my_piecewise3(t117, 0, 0.4e1 / 0.3e1 * t120 * t417)
  t424 = f.my_piecewise3(t124, 0, -0.4e1 / 0.3e1 * t125 * t417)
  t425 = t420 + t424
  t438 = t180 + t191 + t202 - t246 + t333 - t377 - t112 * t425 * t132 * t142 / 0.6e1 - t112 * t133 * (0.4e1 * t394 + 0.4e1 * t397) * t141 / 0.6e1 + t405 + t51 * t425 * t148 - t411 - t414
  vrho_1_ = t7 * t438 - t145 + t149 + t21 + t26 + t32
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  DRPA = lambda rs, z=None: +f_aux(A_rpa[2], b_rpa[2], c_rpa[2], x0_rpa[2], rs) - f_aux(A_rpa[1], b_rpa[1], c_rpa[1], x0_rpa[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + DMC(rs, z) / DRPA(rs, z) * f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = t10 / 0.4e1
  t12 = jnp.sqrt(t10)
  t14 = t11 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t15 = 0.1e1 / t14
  t19 = jnp.log(t4 * t9 * t15 / 0.4e1)
  t20 = 0.310907e-1 * t19
  t21 = t12 + 0.372744e1
  t24 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t21)
  t25 = 0.38783294878113014394824731224995739188004877421366e-1 * t24
  t26 = t12 / 0.2e1
  t27 = t26 + 0.10498e0
  t28 = t27 ** 2
  t30 = jnp.log(t28 * t15)
  t31 = 0.96902277115443742137603943210562149050493484994510e-3 * t30
  t33 = t11 + 0.35302100000000000000000000000000000000000000000000e1 * t12 + 0.180578e2
  t34 = 0.1e1 / t33
  t38 = jnp.log(t4 * t9 * t34 / 0.4e1)
  t40 = t12 + 0.706042e1
  t43 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t40)
  t45 = t26 + 0.32500e0
  t46 = t45 ** 2
  t48 = jnp.log(t46 * t34)
  t50 = 0.1554535e-1 * t38 + 0.52491393169780936217021346072241076933841385384498e-1 * t43 + 0.22478670955426118383265363956423012380560746650571e-2 * t48 - t20 - t25 - t31
  t52 = t11 + 0.10061550000000000000000000000000000000000000000000e2 * t12 + 0.101578e3
  t53 = 0.1e1 / t52
  t57 = jnp.log(t4 * t9 * t53 / 0.4e1)
  t59 = t12 + 0.201231e2
  t62 = jnp.arctan(0.11716852777089929792201907797022178188779527234376e1 / t59)
  t64 = t26 + 0.743294e0
  t65 = t64 ** 2
  t67 = jnp.log(t65 * t53)
  t70 = t11 + 0.65360000000000000000000000000000000000000000000000e1 * t12 + 0.427198e2
  t71 = 0.1e1 / t70
  t75 = jnp.log(t4 * t9 * t71 / 0.4e1)
  t77 = t12 + 0.130720e2
  t80 = jnp.arctan(0.44899888641287296627004984787798591621072237693345e-1 / t77)
  t82 = t26 + 0.409286e0
  t83 = t82 ** 2
  t85 = jnp.log(t83 * t71)
  t87 = 0.1554535e-1 * t57 + 0.61881802979060631480216141626488805225499304723700e0 * t62 + 0.26673100072733151593315970562575695370840511204614e-2 * t67 - 0.310907e-1 * t75 - 0.20521972937837502661166379517614390730124411627871e2 * t80 - 0.44313737677495382697984551091739236689629774931818e-2 * t85
  t88 = 0.1e1 / t87
  t90 = jnp.pi ** 2
  t91 = 0.1e1 / t90
  t92 = t50 * t88 * t91
  t94 = t11 + 0.53417500000000000000000000000000000000000000000000e0 * t12 + 0.114813e2
  t95 = 0.1e1 / t94
  t99 = jnp.log(t4 * t9 * t95 / 0.4e1)
  t100 = t12 + 0.106835e1
  t103 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t100)
  t105 = t26 + 0.228344e0
  t106 = t105 ** 2
  t108 = jnp.log(t106 * t95)
  t110 = t99 + 0.32323836906055067299704130765928097906535029214057e0 * t103 + 0.21608710360898267021763215722876235716176892439270e-1 * t108
  t112 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t114 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t112 * f.p.zeta_threshold, 1)
  t116 = 0.2e1 * t114 - 0.2e1
  t118 = 2 ** (0.1e1 / 0.3e1)
  t119 = t118 - 0.1e1
  t121 = 0.1e1 / t119 / 0.2e1
  t122 = 0.9e1 / 0.4e1 * t119
  t123 = t121 * t122
  t124 = t110 * t116 * t123
  t128 = 0.1e1 / t7 / r0
  t129 = t6 * t128
  t133 = t4 * t6
  t134 = t14 ** 2
  t135 = 0.1e1 / t134
  t137 = t4 * t129
  t138 = t137 / 0.12e2
  t139 = 0.1e1 / t12
  t141 = t3 * t6
  t143 = t139 * t1 * t141 * t128
  t145 = -t138 - 0.31062000000000000000000000000000000000000000000000e0 * t143
  t150 = t1 ** 2
  t152 = 0.1e1 / t3
  t154 = t5 * t7
  t157 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t129 * t15 / 0.12e2 - t133 * t8 * t135 * t145 / 0.4e1) * t150 * t152 * t154 * t14
  t158 = t21 ** 2
  t159 = 0.1e1 / t158
  t168 = 0.39765745675026770180313930393880960493473766078662e-1 * t159 * t139 * t1 * t141 * t128 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t159)
  t179 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t27 * t15 * t139 * t137 / 0.6e1 - t28 * t135 * t145) / t28 * t14
  t183 = t33 ** 2
  t184 = 0.1e1 / t183
  t187 = -t138 - 0.58836833333333333333333333333333333333333333333333e0 * t143
  t197 = t40 ** 2
  t198 = 0.1e1 / t197
  t224 = t87 ** 2
  t233 = t52 ** 2
  t234 = 0.1e1 / t233
  t237 = -t138 - 0.16769250000000000000000000000000000000000000000000e1 * t143
  t247 = t59 ** 2
  t248 = 0.1e1 / t247
  t272 = t70 ** 2
  t273 = 0.1e1 / t272
  t276 = -t138 - 0.10893333333333333333333333333333333333333333333333e1 * t143
  t286 = t77 ** 2
  t287 = 0.1e1 / t286
  t316 = t94 ** 2
  t317 = 0.1e1 / t316
  t320 = -t138 - 0.89029166666666666666666666666666666666666666666667e-1 * t143
  t330 = t100 ** 2
  t331 = 0.1e1 / t330
  vrho_0_ = t20 + t25 + t31 - t92 * t124 / 0.6e1 + r0 * (t157 + t168 + t179 - (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t129 * t34 / 0.12e2 - t133 * t8 * t184 * t187 / 0.4e1) * t150 * t152 * t154 * t33 + 0.41388824077869423260215065147117773567486474051459e-1 * t198 * t139 * t1 * t141 * t128 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t198) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t45 * t34 * t139 * t137 / 0.6e1 - t46 * t184 * t187) / t46 * t33 - t157 - t168 - t179) * t88 * t91 * t124 / 0.6e1 + t50 / t224 * t91 * t110 * t116 * t121 * t122 * (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t129 * t53 / 0.12e2 - t133 * t8 * t234 * t237 / 0.4e1) * t150 * t152 * t154 * t52 + 0.12084332918108974174888840683936962325623378790503e0 * t248 * t139 * t1 * t141 * t128 / (0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t248) + 0.26673100072733151593315970562575695370840511204614e-2 * (-t64 * t53 * t139 * t137 / 0.6e1 - t65 * t234 * t237) / t65 * t52 - 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t129 * t71 / 0.12e2 - t133 * t8 * t273 * t276 / 0.4e1) * t150 * t152 * t154 * t70 - 0.15357238326806922974073998139716493771837789312610e0 * t287 * t139 * t1 * t141 * t128 / (0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t287) - 0.44313737677495382697984551091739236689629774931818e-2 * (-t82 * t71 * t139 * t137 / 0.6e1 - t83 * t273 * t276) / t83 * t70) / 0.6e1 - t92 * ((-t4 * t129 * t95 / 0.12e2 - t133 * t8 * t317 * t320 / 0.4e1) * t150 * t152 * t154 * t94 / 0.3e1 + 0.36052240899892258526768857735182864136354273012771e0 * t331 * t139 * t1 * t141 * t128 / (0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t331) + 0.21608710360898267021763215722876235716176892439270e-1 * (-t105 * t95 * t139 * t137 / 0.6e1 - t106 * t317 * t320) / t106 * t94) * t116 * t123 / 0.6e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t12 = t6 * t11
  t13 = t4 * t12
  t14 = t13 / 0.4e1
  t15 = jnp.sqrt(t13)
  t17 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t15 + 0.129352e2
  t18 = 0.1e1 / t17
  t22 = t4 * t6
  t23 = t17 ** 2
  t24 = 0.1e1 / t23
  t25 = t11 * t24
  t26 = t4 * t10
  t27 = t26 / 0.12e2
  t28 = 0.1e1 / t15
  t29 = t28 * t1
  t30 = t3 * t6
  t32 = t29 * t30 * t9
  t34 = -t27 - 0.31062000000000000000000000000000000000000000000000e0 * t32
  t39 = t1 ** 2
  t41 = 0.1e1 / t3
  t42 = (-t4 * t10 * t18 / 0.12e2 - t22 * t25 * t34 / 0.4e1) * t39 * t41
  t43 = t5 * t7
  t44 = t43 * t17
  t45 = t42 * t44
  t47 = t15 + 0.372744e1
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t51 = t49 * t28 * t1
  t53 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t49
  t54 = 0.1e1 / t53
  t57 = t51 * t30 * t9 * t54
  t59 = t15 / 0.2e1
  t60 = t59 + 0.10498e0
  t61 = t60 * t18
  t62 = t61 * t28
  t65 = t60 ** 2
  t66 = t65 * t24
  t68 = -t62 * t26 / 0.6e1 - t66 * t34
  t69 = 0.1e1 / t65
  t70 = t68 * t69
  t71 = t70 * t17
  t74 = t14 + 0.35302100000000000000000000000000000000000000000000e1 * t15 + 0.180578e2
  t75 = 0.1e1 / t74
  t79 = t74 ** 2
  t80 = 0.1e1 / t79
  t81 = t11 * t80
  t83 = -t27 - 0.58836833333333333333333333333333333333333333333333e0 * t32
  t89 = (-t4 * t10 * t75 / 0.12e2 - t22 * t81 * t83 / 0.4e1) * t39 * t41
  t90 = t43 * t74
  t93 = t15 + 0.706042e1
  t94 = t93 ** 2
  t95 = 0.1e1 / t94
  t97 = t95 * t28 * t1
  t99 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t95
  t100 = 0.1e1 / t99
  t105 = t59 + 0.32500e0
  t106 = t105 * t75
  t107 = t106 * t28
  t110 = t105 ** 2
  t111 = t110 * t80
  t113 = -t107 * t26 / 0.6e1 - t111 * t83
  t114 = 0.1e1 / t110
  t115 = t113 * t114
  t121 = 0.51817833333333333333333333333333333333333333333333e-2 * t89 * t90 + 0.41388824077869423260215065147117773567486474051458e-1 * t97 * t30 * t9 * t100 + 0.22478670955426118383265363956423012380560746650571e-2 * t115 * t74 - 0.10363566666666666666666666666666666666666666666667e-1 * t45 - 0.39765745675026770180313930393880960493473766078662e-1 * t57 - 0.96902277115443742137603943210562149050493484994510e-3 * t71
  t123 = t14 + 0.10061550000000000000000000000000000000000000000000e2 * t15 + 0.101578e3
  t124 = 0.1e1 / t123
  t128 = jnp.log(t4 * t12 * t124 / 0.4e1)
  t130 = t15 + 0.201231e2
  t133 = jnp.arctan(0.11716852777089929792201907797022178188779527234376e1 / t130)
  t135 = t59 + 0.743294e0
  t136 = t135 ** 2
  t138 = jnp.log(t136 * t124)
  t141 = t14 + 0.65360000000000000000000000000000000000000000000000e1 * t15 + 0.427198e2
  t142 = 0.1e1 / t141
  t146 = jnp.log(t4 * t12 * t142 / 0.4e1)
  t148 = t15 + 0.130720e2
  t151 = jnp.arctan(0.44899888641287296627004984787798591621072237693345e-1 / t148)
  t153 = t59 + 0.409286e0
  t154 = t153 ** 2
  t156 = jnp.log(t154 * t142)
  t158 = 0.1554535e-1 * t128 + 0.61881802979060631480216141626488805225499304723700e0 * t133 + 0.26673100072733151593315970562575695370840511204614e-2 * t138 - 0.310907e-1 * t146 - 0.20521972937837502661166379517614390730124411627871e2 * t151 - 0.44313737677495382697984551091739236689629774931818e-2 * t156
  t159 = 0.1e1 / t158
  t161 = jnp.pi ** 2
  t162 = 0.1e1 / t161
  t163 = t121 * t159 * t162
  t165 = t14 + 0.53417500000000000000000000000000000000000000000000e0 * t15 + 0.114813e2
  t166 = 0.1e1 / t165
  t170 = jnp.log(t4 * t12 * t166 / 0.4e1)
  t171 = t15 + 0.106835e1
  t174 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t171)
  t176 = t59 + 0.228344e0
  t177 = t176 ** 2
  t179 = jnp.log(t177 * t166)
  t181 = t170 + 0.32323836906055067299704130765928097906535029214058e0 * t174 + 0.21608710360898267021763215722876235716176892439270e-1 * t179
  t183 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t185 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t183 * f.p.zeta_threshold, 1)
  t187 = 0.2e1 * t185 - 0.2e1
  t189 = 2 ** (0.1e1 / 0.3e1)
  t190 = t189 - 0.1e1
  t192 = 0.1e1 / t190 / 0.2e1
  t193 = 0.9e1 * t190
  t194 = t192 * t193
  t195 = t181 * t187 * t194
  t201 = jnp.log(t4 * t12 * t75 / 0.4e1)
  t205 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t93)
  t208 = jnp.log(t110 * t75)
  t213 = jnp.log(t4 * t12 * t18 / 0.4e1)
  t217 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t47)
  t220 = jnp.log(t65 * t18)
  t222 = 0.1554535e-1 * t201 + 0.52491393169780936217021346072241076933841385384497e-1 * t205 + 0.22478670955426118383265363956423012380560746650571e-2 * t208 - 0.310907e-1 * t213 - 0.38783294878113014394824731224995739188004877421366e-1 * t217 - 0.96902277115443742137603943210562149050493484994510e-3 * t220
  t223 = t158 ** 2
  t224 = 0.1e1 / t223
  t225 = t222 * t224
  t226 = t162 * t181
  t227 = t225 * t226
  t228 = t187 * t192
  t232 = t123 ** 2
  t233 = 0.1e1 / t232
  t234 = t11 * t233
  t236 = -t27 - 0.16769250000000000000000000000000000000000000000000e1 * t32
  t242 = (-t4 * t10 * t124 / 0.12e2 - t22 * t234 * t236 / 0.4e1) * t39 * t41
  t243 = t43 * t123
  t246 = t130 ** 2
  t247 = 0.1e1 / t246
  t249 = t247 * t28 * t1
  t251 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t247
  t252 = 0.1e1 / t251
  t257 = t135 * t124
  t258 = t257 * t28
  t261 = t136 * t233
  t263 = -t258 * t26 / 0.6e1 - t261 * t236
  t264 = 0.1e1 / t136
  t265 = t263 * t264
  t271 = t141 ** 2
  t272 = 0.1e1 / t271
  t273 = t11 * t272
  t275 = -t27 - 0.10893333333333333333333333333333333333333333333333e1 * t32
  t281 = (-t4 * t10 * t142 / 0.12e2 - t22 * t273 * t275 / 0.4e1) * t39 * t41
  t282 = t43 * t141
  t285 = t148 ** 2
  t286 = 0.1e1 / t285
  t288 = t286 * t28 * t1
  t290 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t286
  t291 = 0.1e1 / t290
  t296 = t153 * t142
  t297 = t296 * t28
  t300 = t154 * t272
  t302 = -t297 * t26 / 0.6e1 - t300 * t275
  t303 = 0.1e1 / t154
  t304 = t302 * t303
  t307 = 0.51817833333333333333333333333333333333333333333333e-2 * t242 * t243 + 0.12084332918108974174888840683936962325623378790503e0 * t249 * t30 * t9 * t252 + 0.26673100072733151593315970562575695370840511204614e-2 * t265 * t123 - 0.10363566666666666666666666666666666666666666666667e-1 * t281 * t282 - 0.15357238326806922974073998139716493771837789312610e0 * t288 * t30 * t9 * t291 - 0.44313737677495382697984551091739236689629774931818e-2 * t304 * t141
  t309 = t228 * t193 * t307
  t313 = t222 * t159 * t162
  t317 = t165 ** 2
  t318 = 0.1e1 / t317
  t319 = t11 * t318
  t321 = -t27 - 0.89029166666666666666666666666666666666666666666667e-1 * t32
  t327 = (-t4 * t10 * t166 / 0.12e2 - t22 * t319 * t321 / 0.4e1) * t39 * t41
  t328 = t43 * t165
  t331 = t171 ** 2
  t332 = 0.1e1 / t331
  t334 = t332 * t28 * t1
  t336 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t332
  t337 = 0.1e1 / t336
  t342 = t176 * t166
  t343 = t342 * t28
  t346 = t177 * t318
  t348 = -t343 * t26 / 0.6e1 - t346 * t321
  t349 = 0.1e1 / t177
  t350 = t348 * t349
  t353 = t327 * t328 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t334 * t30 * t9 * t337 + 0.21608710360898267021763215722876235716176892439270e-1 * t350 * t165
  t355 = t353 * t187 * t194
  t358 = r0 ** 2
  t360 = 0.1e1 / t7 / t358
  t361 = t6 * t360
  t363 = t4 * t361 * t18
  t370 = 0.1e1 / t23 / t17
  t372 = t34 ** 2
  t376 = t4 * t361
  t377 = t376 / 0.9e1
  t379 = 0.1e1 / t15 / t13
  t381 = t3 ** 2
  t382 = t381 * t5
  t383 = t7 ** 2
  t385 = 0.1e1 / t383 / t358
  t387 = t379 * t39 * t382 * t385
  t390 = t29 * t30 * t360
  t392 = t377 - 0.20708000000000000000000000000000000000000000000000e0 * t387 + 0.41416000000000000000000000000000000000000000000000e0 * t390
  t400 = 0.10363566666666666666666666666666666666666666666667e-1 * (t363 / 0.9e1 + t22 * t9 * t24 * t34 / 0.6e1 + t22 * t11 * t370 * t372 / 0.2e1 - t22 * t25 * t392 / 0.4e1) * t39 * t41 * t44
  t402 = t5 / t383
  t405 = 0.34545222222222222222222222222222222222222222222223e-2 * t42 * t402 * t17
  t408 = 0.10363566666666666666666666666666666666666666666667e-1 * t42 * t43 * t34
  t415 = 0.13255248558342256726771310131293653497824588692887e-1 / t48 / t47 * t1 * t3 * t361 * t54
  t421 = 0.26510497116684513453542620262587306995649177385775e-1 * t49 * t379 * t39 * t382 * t385 * t54
  t425 = 0.53020994233369026907085240525174613991298354771549e-1 * t51 * t30 * t360 * t54
  t426 = t48 ** 2
  t431 = t53 ** 2
  t435 = 0.50167127350538589836488394571946851238131125013746e0 / t426 / t47 * t1 * t3 * t361 / t431
  t446 = t39 * t381 * t5 * t385
  t458 = 0.96902277115443742137603943210562149050493484994510e-3 * (t363 / 0.72e2 + t60 * t24 * t29 * t30 * t9 * t34 / 0.3e1 - t61 * t379 * t446 / 0.9e1 + 0.2e1 / 0.9e1 * t62 * t376 + 0.2e1 * t65 * t370 * t372 - t66 * t392) * t69 * t17
  t465 = 0.16150379519240623689600657201760358175082247499085e-3 * t68 / t65 / t60 * t17 * t28 * t26
  t467 = 0.96902277115443742137603943210562149050493484994510e-3 * t70 * t34
  t469 = t4 * t361 * t75
  t476 = 0.1e1 / t79 / t74
  t478 = t83 ** 2
  t484 = t377 - 0.39224555555555555555555555555555555555555555555555e0 * t387 + 0.78449111111111111111111111111111111111111111111110e0 * t390
  t516 = t94 ** 2
  t521 = t99 ** 2
  t555 = 0.51817833333333333333333333333333333333333333333333e-2 * (t469 / 0.9e1 + t22 * t9 * t80 * t83 / 0.6e1 + t22 * t11 * t476 * t478 / 0.2e1 - t22 * t81 * t484 / 0.4e1) * t39 * t41 * t90 + 0.17272611111111111111111111111111111111111111111111e-2 * t89 * t402 * t74 + 0.51817833333333333333333333333333333333333333333333e-2 * t89 * t43 * t83 + 0.13796274692623141086738355049039257855828824683819e-1 / t94 / t93 * t1 * t3 * t361 * t100 + 0.27592549385246282173476710098078515711657649367639e-1 * t95 * t379 * t39 * t382 * t385 * t100 - 0.55185098770492564346953420196157031423315298735277e-1 * t97 * t30 * t360 * t100 - 0.30878365944746984533884071665444263610784010246137e0 / t516 / t93 * t1 * t3 * t361 / t521 + 0.22478670955426118383265363956423012380560746650571e-2 * (t469 / 0.72e2 + t105 * t80 * t29 * t30 * t9 * t83 / 0.3e1 - t106 * t379 * t446 / 0.9e1 + 0.2e1 / 0.9e1 * t107 * t376 + 0.2e1 * t110 * t476 * t478 - t111 * t484) * t114 * t74 + 0.37464451592376863972108939927371687300934577750952e-3 * t113 / t110 / t105 * t74 * t28 * t26 + 0.22478670955426118383265363956423012380560746650571e-2 * t115 * t83 - t400 - t405 - t408 - t415 - t421 + t425 + t435 - t458 - t465 - t467
  t570 = t307 ** 2
  t580 = t4 * t361 * t124
  t587 = 0.1e1 / t232 / t123
  t589 = t236 ** 2
  t595 = t377 - 0.11179500000000000000000000000000000000000000000000e1 * t387 + 0.22359000000000000000000000000000000000000000000000e1 * t390
  t627 = t246 ** 2
  t632 = t251 ** 2
  t667 = t4 * t361 * t142
  t674 = 0.1e1 / t271 / t141
  t676 = t275 ** 2
  t682 = t377 - 0.72622222222222222222222222222222222222222222222220e0 * t387 + 0.14524444444444444444444444444444444444444444444444e1 * t390
  t714 = t285 ** 2
  t719 = t290 ** 2
  t753 = 0.51817833333333333333333333333333333333333333333333e-2 * (t580 / 0.9e1 + t22 * t9 * t233 * t236 / 0.6e1 + t22 * t11 * t587 * t589 / 0.2e1 - t22 * t234 * t595 / 0.4e1) * t39 * t41 * t243 + 0.17272611111111111111111111111111111111111111111111e-2 * t242 * t402 * t123 + 0.51817833333333333333333333333333333333333333333333e-2 * t242 * t43 * t236 + 0.40281109727029913916296135613123207752077929301677e-1 / t246 / t130 * t1 * t3 * t361 * t252 + 0.80562219454059827832592271226246415504155858603353e-1 * t247 * t379 * t39 * t382 * t385 * t252 - 0.16112443890811965566518454245249283100831171720671e0 * t249 * t30 * t360 * t252 - 0.55299776073946902741997911947426632387660200240483e-1 / t627 / t130 * t1 * t3 * t361 / t632 + 0.26673100072733151593315970562575695370840511204614e-2 * (t580 / 0.72e2 + t135 * t233 * t29 * t30 * t9 * t236 / 0.3e1 - t257 * t379 * t446 / 0.9e1 + 0.2e1 / 0.9e1 * t258 * t376 + 0.2e1 * t136 * t587 * t589 - t261 * t595) * t264 * t123 + 0.44455166787888585988859950937626158951400852007690e-3 * t263 / t136 / t135 * t123 * t28 * t26 + 0.26673100072733151593315970562575695370840511204614e-2 * t265 * t236 - 0.10363566666666666666666666666666666666666666666667e-1 * (t667 / 0.9e1 + t22 * t9 * t272 * t275 / 0.6e1 + t22 * t11 * t674 * t676 / 0.2e1 - t22 * t273 * t682 / 0.4e1) * t39 * t41 * t282 - 0.34545222222222222222222222222222222222222222222223e-2 * t281 * t402 * t141 - 0.10363566666666666666666666666666666666666666666667e-1 * t281 * t43 * t275 - 0.51190794422689743246913327132388312572792631042033e-1 / t285 / t148 * t1 * t3 * t361 * t291 - 0.10238158884537948649382665426477662514558526208407e0 * t286 * t379 * t39 * t382 * t385 * t291 + 0.20476317769075897298765330852955325029117052416813e0 * t288 * t30 * t360 * t291 + 0.10320064155614252238577726749889483814674994418074e-3 / t714 / t148 * t1 * t3 * t361 / t719 - 0.44313737677495382697984551091739236689629774931818e-2 * (t667 / 0.72e2 + t153 * t272 * t29 * t30 * t9 * t275 / 0.3e1 - t296 * t379 * t446 / 0.9e1 + 0.2e1 / 0.9e1 * t297 * t376 + 0.2e1 * t154 * t674 * t676 - t300 * t682) * t303 * t141 - 0.73856229462492304496640918486232061149382958219697e-3 * t302 / t154 / t153 * t141 * t28 * t26 - 0.44313737677495382697984551091739236689629774931818e-2 * t304 * t275
  t759 = t4 * t361 * t166
  t766 = 0.1e1 / t317 / t165
  t768 = t321 ** 2
  t774 = t377 - 0.59352777777777777777777777777777777777777777777778e-1 * t387 + 0.11870555555555555555555555555555555555555555555556e0 * t390
  t806 = t331 ** 2
  t811 = t336 ** 2
  t850 = t400 + t405 + t408 + t415 + t421 - t425 - t435 + t458 + t465 + t467 - t555 * t159 * t162 * t195 / 0.24e2 + t121 * t224 * t226 * t309 / 0.12e2 - t163 * t355 / 0.12e2 - t222 / t223 / t158 * t226 * t228 * t193 * t570 / 0.12e2 + t225 * t162 * t353 * t309 / 0.12e2 + t227 * t228 * t193 * t753 / 0.24e2 - t313 * ((t759 / 0.9e1 + t22 * t9 * t318 * t321 / 0.6e1 + t22 * t11 * t766 * t768 / 0.2e1 - t22 * t319 * t774 / 0.4e1) * t39 * t41 * t328 / 0.3e1 + t327 * t402 * t165 / 0.9e1 + t327 * t43 * t321 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 / t331 / t171 * t1 * t3 * t361 * t337 + 0.24034827266594839017845905156788576090902848675181e0 * t332 * t379 * t39 * t382 * t385 * t337 - 0.48069654533189678035691810313577152181805697350363e0 * t334 * t30 * t360 * t337 - 0.53818578849327899137148388724908565251436770250246e1 / t806 / t171 * t1 * t3 * t361 / t811 + 0.21608710360898267021763215722876235716176892439270e-1 * (t759 / 0.72e2 + t176 * t318 * t29 * t30 * t9 * t321 / 0.3e1 - t342 * t379 * t446 / 0.9e1 + 0.2e1 / 0.9e1 * t343 * t376 + 0.2e1 * t177 * t766 * t768 - t346 * t774) * t349 * t165 + 0.36014517268163778369605359538127059526961487398783e-2 * t348 / t177 / t176 * t165 * t28 * t26 + 0.21608710360898267021763215722876235716176892439270e-1 * t350 * t321) * t187 * t194 / 0.24e2
  v2rho2_0_ = 0.20727133333333333333333333333333333333333333333334e-1 * t45 + 0.79531491350053540360627860787761920986947532157324e-1 * t57 + 0.19380455423088748427520788642112429810098696998902e-2 * t71 - t163 * t195 / 0.12e2 + t227 * t309 / 0.12e2 - t313 * t355 / 0.12e2 + r0 * t850
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = jnp.sqrt(t10)
  t12 = t11 / 0.2e1
  t13 = t12 + 0.10498e0
  t14 = t10 / 0.4e1
  t16 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t11 + 0.129352e2
  t17 = 0.1e1 / t16
  t18 = t13 * t17
  t19 = 0.1e1 / t11
  t20 = t18 * t19
  t22 = 0.1e1 / t7 / r0
  t23 = t6 * t22
  t24 = t4 * t23
  t27 = t13 ** 2
  t28 = t16 ** 2
  t29 = 0.1e1 / t28
  t30 = t27 * t29
  t31 = t24 / 0.12e2
  t32 = t19 * t1
  t33 = t3 * t6
  t35 = t32 * t33 * t22
  t37 = -t31 - 0.31062000000000000000000000000000000000000000000000e0 * t35
  t39 = -t20 * t24 / 0.6e1 - t30 * t37
  t41 = 0.1e1 / t27 / t13
  t42 = t39 * t41
  t43 = t16 * t19
  t44 = t42 * t43
  t45 = r0 ** 2
  t47 = 0.1e1 / t7 / t45
  t48 = t6 * t47
  t49 = t4 * t48
  t51 = 0.21533839358987498252800876269013810900109663332113e-3 * t44 * t49
  t52 = t27 ** 2
  t57 = 0.40375948798101559224001643004400895437705618747712e-4 * t39 / t52 * t16 * t49
  t58 = t11 + 0.372744e1
  t59 = t58 ** 2
  t60 = t59 ** 2
  t62 = t1 ** 2
  t64 = t3 ** 2
  t66 = t45 * r0
  t67 = t7 ** 2
  t69 = 0.1e1 / t67 / t66
  t70 = t5 * t69
  t71 = 0.1e1 / t59
  t73 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t71
  t74 = 0.1e1 / t73
  t78 = 0.26510497116684513453542620262587306995649177385774e-1 / t60 * t62 * t64 * t70 * t74 * t19
  t83 = t73 ** 2
  t84 = 0.1e1 / t83
  t88 = 0.23411326096918008590361250800241863911127858339748e1 / t60 / t59 * t62 * t64 * t70 * t84 * t19
  t91 = 0.1e1 / t59 / t58 * t1
  t92 = 0.1e1 / t64
  t95 = 0.1e1 / t7 / t66
  t96 = t6 * t95
  t100 = 0.22092080930570427877952183552156089163040981154812e-2 * t91 * t92 * t96 * t2 * t74
  t103 = 0.1e1 / t60 / t58 * t1
  t108 = 0.83611878917564316394147324286578085396885208356242e-1 * t103 * t92 * t96 * t2 * t84
  t109 = t60 ** 2
  t118 = 0.50631328524251801700246888250186209051365905137714e2 / t109 * t62 * t64 * t70 / t83 / t73 * t19
  t119 = t12 + 0.32500e0
  t121 = t14 + 0.35302100000000000000000000000000000000000000000000e1 * t11 + 0.180578e2
  t122 = 0.1e1 / t121
  t123 = t119 * t122
  t124 = t123 * t19
  t127 = t119 ** 2
  t128 = t121 ** 2
  t129 = 0.1e1 / t128
  t130 = t127 * t129
  t132 = -t31 - 0.58836833333333333333333333333333333333333333333333e0 * t35
  t134 = -t124 * t24 / 0.6e1 - t130 * t132
  t136 = 0.1e1 / t127 / t119
  t137 = t134 * t136
  t138 = t121 * t19
  t139 = t137 * t138
  t142 = t11 + 0.706042e1
  t143 = t142 ** 2
  t144 = 0.1e1 / t143
  t146 = 0.1e1 / t11 / t10
  t148 = t144 * t146 * t62
  t149 = t64 * t5
  t151 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t144
  t152 = 0.1e1 / t151
  t158 = t144 * t19 * t1
  t164 = t71 * t146 * t62
  t168 = 0.10604198846673805381417048105034922798259670954310e0 * t164 * t149 * t69 * t74
  t170 = t71 * t19 * t1
  t174 = 0.12371565321119439611653222789207409931302949446695e0 * t170 * t33 * t95 * t74
  t175 = -0.49952602123169151962811919903162249734579437001269e-3 * t139 * t49 + t51 - t57 - t78 + t88 - t100 + t108 - t118 - 0.11037019754098512869390684039231406284663059747056e0 * t148 * t149 * t69 * t152 + 0.12876523046448265014289131379103307332106903038231e0 * t158 * t33 * t95 * t152 + t168 - t174
  t176 = t127 ** 2
  t182 = t143 ** 2
  t185 = 0.1e1 / t182 / t142 * t1
  t187 = t151 ** 2
  t188 = 0.1e1 / t187
  t193 = t182 ** 2
  t220 = 0.1e1 / t143 / t142 * t1
  t227 = t4 * t48 * t122
  t229 = t119 * t129
  t230 = t229 * t32
  t235 = t123 * t146
  t236 = t62 * t64
  t238 = 0.1e1 / t67 / t45
  t240 = t236 * t5 * t238
  t246 = 0.1e1 / t128 / t121
  t247 = t127 * t246
  t248 = t132 ** 2
  t251 = t49 / 0.9e1
  t252 = t146 * t62
  t254 = t252 * t149 * t238
  t257 = t32 * t33 * t47
  t259 = t251 - 0.39224555555555555555555555555555555555555555555555e0 * t254 + 0.78449111111111111111111111111111111111111111111110e0 * t257
  t261 = t227 / 0.72e2 + t230 * t33 * t22 * t132 / 0.3e1 - t235 * t240 / 0.9e1 + 0.2e1 / 0.9e1 * t124 * t49 + 0.2e1 * t247 * t248 - t130 * t259
  t275 = t4 * t48 * t17
  t277 = t13 * t29
  t278 = t277 * t32
  t283 = t18 * t146
  t289 = 0.1e1 / t28 / t16
  t290 = t27 * t289
  t291 = t37 ** 2
  t296 = t251 - 0.20708000000000000000000000000000000000000000000000e0 * t254 + 0.41416000000000000000000000000000000000000000000000e0 * t257
  t298 = t275 / 0.72e2 + t278 * t33 * t22 * t37 / 0.3e1 - t283 * t240 / 0.9e1 + 0.2e1 / 0.9e1 * t20 * t49 + 0.2e1 * t290 * t291 - t30 * t296
  t302 = 0.32300759038481247379201314403520716350164494998170e-3 * t298 * t41 * t43 * t24
  t306 = 0.32300759038481247379201314403520716350164494998170e-3 * t42 * t37 * t19 * t24
  t310 = 0.10766919679493749126400438134506905450054831666057e-3 * t42 * t16 * t146 * t240
  t311 = 0.93661128980942159930272349818429218252336444377380e-4 * t134 / t176 * t121 * t49 - 0.51463943241244974223140119442407106017973350410227e-1 * t185 * t92 * t96 * t2 * t188 + 0.18429583437767336287475605998441200095133403022660e2 / t193 * t62 * t64 * t70 / t187 / t151 * t19 + 0.27592549385246282173476710098078515711657649367638e-1 / t182 * t62 * t64 * t70 * t152 * t19 - 0.14409904107548592782479233443873989685032538114864e1 / t182 / t143 * t62 * t64 * t70 * t188 * t19 + 0.22993791154371901811230591748398763093048041139699e-2 * t220 * t92 * t96 * t2 * t152 + 0.74928903184753727944217879854743374601869155501904e-3 * t261 * t136 * t138 * t24 + 0.74928903184753727944217879854743374601869155501904e-3 * t137 * t132 * t19 * t24 + 0.24976301061584575981405959951581124867289718500635e-3 * t137 * t121 * t146 * t240 - t302 - t306 - t310
  t314 = t5 / t67
  t318 = 0.1e1 / t11 / t236 / t314 / 0.4e1
  t320 = t45 ** 2
  t321 = 0.1e1 / t320
  t322 = t2 * t321
  t326 = 0.1e1 / t127
  t327 = t261 * t326
  t330 = t134 * t326
  t334 = t4 * t96 * t122
  t336 = t4 * t6
  t339 = t336 * t47 * t129 * t132
  t360 = t1 * t92 * t6
  t361 = t95 * t2
  t366 = t318 * t2 * t321
  t369 = t236 * t70
  t372 = t4 * t96
  t375 = t128 ** 2
  t376 = 0.1e1 / t375
  t378 = t248 * t132
  t381 = t132 * t259
  t384 = 0.7e1 / 0.27e2 * t372
  t387 = t252 * t149 * t69
  t390 = t32 * t33 * t95
  t392 = -t384 - 0.23534733333333333333333333333333333333333333333333e1 * t366 + 0.15689822222222222222222222222222222222222222222222e1 * t387 - 0.18304792592592592592592592592592592592592592592592e1 * t390
  t394 = -0.11e2 / 0.216e3 * t334 - t339 / 0.24e2 - t119 * t246 * t32 * t33 * t22 * t248 + t229 * t252 * t149 * t238 * t132 / 0.3e1 - 0.2e1 / 0.3e1 * t230 * t33 * t47 * t132 + t230 * t33 * t22 * t259 / 0.2e1 + t360 * t361 * t122 / 0.432e3 - 0.2e1 / 0.3e1 * t123 * t366 + 0.4e1 / 0.9e1 * t235 * t369 - 0.14e2 / 0.27e2 * t124 * t372 - 0.6e1 * t127 * t376 * t378 + 0.6e1 * t247 * t381 - t130 * t392
  t399 = t4 * t96 * t17
  t403 = t336 * t47 * t29 * t37
  t432 = t28 ** 2
  t433 = 0.1e1 / t432
  t435 = t291 * t37
  t438 = t37 * t296
  t444 = -t384 - 0.12424800000000000000000000000000000000000000000000e1 * t366 + 0.82832000000000000000000000000000000000000000000000e0 * t387 - 0.96637333333333333333333333333333333333333333333333e0 * t390
  t446 = -0.11e2 / 0.216e3 * t399 - t403 / 0.24e2 - t13 * t289 * t32 * t33 * t22 * t291 + t277 * t252 * t149 * t238 * t37 / 0.3e1 - 0.2e1 / 0.3e1 * t278 * t33 * t47 * t37 + t278 * t33 * t22 * t296 / 0.2e1 + t360 * t361 * t17 / 0.432e3 - 0.2e1 / 0.3e1 * t18 * t366 + 0.4e1 / 0.9e1 * t283 * t369 - 0.14e2 / 0.27e2 * t20 * t372 - 0.6e1 * t27 * t433 * t435 + 0.6e1 * t290 * t438 - t30 * t444
  t447 = 0.1e1 / t27
  t450 = 0.96902277115443742137603943210562149050493484994510e-3 * t446 * t447 * t16
  t451 = t298 * t447
  t453 = 0.19380455423088748427520788642112429810098696998902e-2 * t451 * t37
  t454 = t39 * t447
  t456 = 0.96902277115443742137603943210562149050493484994510e-3 * t454 * t296
  t460 = 0.15906298270010708072125572157552384197389506431465e0 * t71 * t318 * t322 * t74
  t464 = t8 * t129
  t470 = 0.1e1 / t3
  t471 = (-t4 * t23 * t122 / 0.12e2 - t336 * t464 * t132 / 0.4e1) * t62 * t470
  t474 = t5 / t67 / r0
  t478 = t220 * t3
  t483 = t22 * t129
  t487 = t8 * t246
  t496 = (t227 / 0.9e1 + t336 * t483 * t132 / 0.6e1 + t336 * t487 * t248 / 0.2e1 - t336 * t464 * t259 / 0.4e1) * t62 * t470
  t497 = t314 * t121
  t503 = 0.16555529631147769304086026058847109426994589620583e0 * t144 * t318 * t322 * t152 + 0.44957341910852236766530727912846024761121493301142e-2 * t327 * t132 + 0.22478670955426118383265363956423012380560746650571e-2 * t330 * t259 + 0.22478670955426118383265363956423012380560746650571e-2 * t394 * t326 * t121 - t450 - t453 - t456 - t460 - 0.11515074074074074074074074074074074074074074074074e-2 * t471 * t474 * t121 - 0.50586340539618183984707301846477278804705690507337e-1 * t478 * t96 * t152 + 0.34545222222222222222222222222222222222222222222222e-2 * t496 * t497 + 0.34545222222222222222222222222222222222222222222222e-2 * t471 * t314 * t132
  t504 = t5 * t7
  t508 = t504 * t132
  t533 = t504 * t121
  t536 = t185 * t3
  t543 = t8 * t29
  t549 = (-t4 * t23 * t17 / 0.12e2 - t336 * t543 * t37 / 0.4e1) * t62 * t470
  t552 = 0.69090444444444444444444444444444444444444444444446e-2 * t549 * t314 * t37
  t554 = t22 * t29
  t558 = t8 * t289
  t567 = (t275 / 0.9e1 + t336 * t554 * t37 / 0.6e1 + t336 * t558 * t291 / 0.2e1 - t336 * t543 * t296 / 0.4e1) * t62 * t470
  t568 = t504 * t37
  t570 = 0.20727133333333333333333333333333333333333333333334e-1 * t567 * t568
  t593 = t504 * t16
  t595 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t399 - t403 / 0.3e1 - t336 * t22 * t289 * t291 / 0.2e1 + t336 * t554 * t296 / 0.4e1 - 0.3e1 / 0.2e1 * t336 * t8 * t433 * t435 + 0.3e1 / 0.2e1 * t336 * t558 * t438 - t336 * t543 * t444 / 0.4e1) * t62 * t470 * t593
  t596 = t314 * t16
  t598 = 0.69090444444444444444444444444444444444444444444446e-2 * t567 * t596
  t601 = 0.23030148148148148148148148148148148148148148148149e-2 * t549 * t474 * t16
  t602 = t91 * t3
  t605 = 0.48602578047254941331494803814743396158690158540586e-1 * t602 * t96 * t74
  t606 = t103 * t3
  t609 = 0.18394613361864149606712411343047178787314745838373e1 * t606 * t96 * t84
  t612 = 0.10363566666666666666666666666666666666666666666667e-1 * t549 * t504 * t296
  t613 = 0.51817833333333333333333333333333333333333333333333e-2 * t471 * t504 * t259 + 0.10363566666666666666666666666666666666666666666667e-1 * t496 * t508 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t334 - t339 / 0.3e1 - t336 * t22 * t246 * t248 / 0.2e1 + t336 * t483 * t259 / 0.4e1 - 0.3e1 / 0.2e1 * t336 * t8 * t376 * t378 + 0.3e1 / 0.2e1 * t336 * t487 * t381 - t336 * t464 * t392 / 0.4e1) * t62 * t470 * t533 + 0.11322067513073894329090826277329563323954137090250e1 * t536 * t96 * t188 - t552 - t570 - t595 - t598 + t601 + t605 - t609 - t612
  t617 = t14 + 0.10061550000000000000000000000000000000000000000000e2 * t11 + 0.101578e3
  t618 = 0.1e1 / t617
  t622 = jnp.log(t4 * t9 * t618 / 0.4e1)
  t624 = t11 + 0.201231e2
  t627 = jnp.atan(0.11716852777089929792201907797022178188779527234376e1 / t624)
  t629 = t12 + 0.743294e0
  t630 = t629 ** 2
  t632 = jnp.log(t630 * t618)
  t635 = t14 + 0.65360000000000000000000000000000000000000000000000e1 * t11 + 0.427198e2
  t636 = 0.1e1 / t635
  t640 = jnp.log(t4 * t9 * t636 / 0.4e1)
  t642 = t11 + 0.130720e2
  t645 = jnp.atan(0.44899888641287296627004984787798591621072237693345e-1 / t642)
  t647 = t12 + 0.409286e0
  t648 = t647 ** 2
  t650 = jnp.log(t648 * t636)
  t652 = 0.1554535e-1 * t622 + 0.61881802979060631480216141626488805225499304723700e0 * t627 + 0.26673100072733151593315970562575695370840511204614e-2 * t632 - 0.310907e-1 * t640 - 0.20521972937837502661166379517614390730124411627871e2 * t645 - 0.44313737677495382697984551091739236689629774931818e-2 * t650
  t653 = 0.1e1 / t652
  t655 = jnp.pi ** 2
  t656 = 0.1e1 / t655
  t659 = t14 + 0.53417500000000000000000000000000000000000000000000e0 * t11 + 0.114813e2
  t660 = 0.1e1 / t659
  t664 = jnp.log(t4 * t9 * t660 / 0.4e1)
  t665 = t11 + 0.106835e1
  t668 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t665)
  t670 = t12 + 0.228344e0
  t671 = t670 ** 2
  t673 = jnp.log(t671 * t660)
  t675 = t664 + 0.32323836906055067299704130765928097906535029214058e0 * t668 + 0.21608710360898267021763215722876235716176892439270e-1 * t673
  t677 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t679 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t677 * f.p.zeta_threshold, 1)
  t681 = 0.2e1 * t679 - 0.2e1
  t683 = 2 ** (0.1e1 / 0.3e1)
  t684 = t683 - 0.1e1
  t686 = 0.1e1 / t684 / 0.2e1
  t687 = 0.9e1 * t684
  t688 = t686 * t687
  t689 = t675 * t681 * t688
  t695 = jnp.log(t4 * t9 * t122 / 0.4e1)
  t699 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t142)
  t702 = jnp.log(t127 * t122)
  t707 = jnp.log(t4 * t9 * t17 / 0.4e1)
  t711 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t58)
  t714 = jnp.log(t27 * t17)
  t716 = 0.1554535e-1 * t695 + 0.52491393169780936217021346072241076933841385384497e-1 * t699 + 0.22478670955426118383265363956423012380560746650571e-2 * t702 - 0.310907e-1 * t707 - 0.38783294878113014394824731224995739188004877421366e-1 * t711 - 0.96902277115443742137603943210562149050493484994510e-3 * t714
  t718 = t716 * t653 * t656
  t719 = t665 ** 2
  t720 = 0.1e1 / t719
  t723 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t720
  t724 = 0.1e1 / t723
  t728 = t670 * t660
  t729 = t728 * t19
  t732 = t659 ** 2
  t733 = 0.1e1 / t732
  t734 = t671 * t733
  t736 = -t31 - 0.89029166666666666666666666666666666666666666666667e-1 * t35
  t738 = -t729 * t24 / 0.6e1 - t734 * t736
  t739 = 0.1e1 / t671
  t740 = t738 * t739
  t743 = t251 - 0.59352777777777777777777777777777777777777777777778e-1 * t254 + 0.11870555555555555555555555555555555555555555555556e0 * t257
  t747 = t4 * t48 * t660
  t749 = t670 * t733
  t750 = t749 * t32
  t755 = t728 * t146
  t761 = 0.1e1 / t732 / t659
  t762 = t671 * t761
  t763 = t736 ** 2
  t767 = t747 / 0.72e2 + t750 * t33 * t22 * t736 / 0.3e1 - t755 * t240 / 0.9e1 + 0.2e1 / 0.9e1 * t729 * t49 + 0.2e1 * t762 * t763 - t734 * t743
  t768 = t767 * t739
  t772 = t4 * t96 * t660
  t776 = t336 * t47 * t733 * t736
  t805 = t732 ** 2
  t806 = 0.1e1 / t805
  t808 = t763 * t736
  t811 = t736 * t743
  t817 = -t384 - 0.35611666666666666666666666666666666666666666666667e0 * t366 + 0.23741111111111111111111111111111111111111111111111e0 * t387 - 0.27697962962962962962962962962962962962962962962964e0 * t390
  t819 = -0.11e2 / 0.216e3 * t772 - t776 / 0.24e2 - t670 * t761 * t32 * t33 * t22 * t763 + t749 * t252 * t149 * t238 * t736 / 0.3e1 - 0.2e1 / 0.3e1 * t750 * t33 * t47 * t736 + t750 * t33 * t22 * t743 / 0.2e1 + t360 * t361 * t660 / 0.432e3 - 0.2e1 / 0.3e1 * t728 * t366 + 0.4e1 / 0.9e1 * t755 * t369 - 0.14e2 / 0.27e2 * t729 * t372 - 0.6e1 * t671 * t806 * t808 + 0.6e1 * t762 * t811 - t734 * t817
  t823 = t719 ** 2
  t826 = 0.1e1 / t823 / t665 * t1
  t827 = t826 * t3
  t828 = t723 ** 2
  t829 = 0.1e1 / t828
  t836 = t8 * t733
  t842 = (-t4 * t23 * t660 / 0.12e2 - t336 * t836 * t736 / 0.4e1) * t62 * t470
  t847 = t22 * t733
  t851 = t8 * t761
  t860 = (t747 / 0.9e1 + t336 * t847 * t736 / 0.6e1 + t336 * t851 * t763 / 0.2e1 - t336 * t836 * t743 / 0.4e1) * t62 * t470
  t861 = t504 * t736
  t868 = 0.1e1 / t671 / t670
  t869 = t738 * t868
  t870 = t659 * t19
  t871 = t869 * t870
  t896 = t504 * t659
  t907 = 0.14420896359956903410707543094073145654541709205109e1 * t720 * t318 * t322 * t724 + 0.21608710360898267021763215722876235716176892439270e-1 * t740 * t743 + 0.43217420721796534043526431445752471432353784878540e-1 * t768 * t736 + 0.21608710360898267021763215722876235716176892439270e-1 * t819 * t739 * t659 + 0.19733478911420229683621075865799807258860149091757e2 * t827 * t96 * t829 + t842 * t504 * t743 / 0.3e1 + 0.2e1 / 0.3e1 * t860 * t861 + 0.2e1 / 0.9e1 * t842 * t314 * t736 - 0.48019356357551704492807146050836079369281983198377e-2 * t871 * t49 + (-0.7e1 / 0.27e2 * t772 - t776 / 0.3e1 - t336 * t22 * t761 * t763 / 0.2e1 + t336 * t847 * t743 / 0.4e1 - 0.3e1 / 0.2e1 * t336 * t8 * t806 * t808 + 0.3e1 / 0.2e1 * t336 * t851 * t811 - t336 * t836 * t817 / 0.4e1) * t62 * t470 * t896 / 0.3e1 + 0.72029034536327556739210719076254119053922974797566e-2 * t869 * t736 * t19 * t24 + 0.24009678178775852246403573025418039684640991599189e-2 * t869 * t659 * t146 * t240
  t909 = t720 * t19 * t1
  t919 = t720 * t146 * t62
  t924 = t671 ** 2
  t932 = 0.1e1 / t719 / t665 * t1
  t933 = t932 * t3
  t962 = t823 ** 2
  t972 = t314 * t659
  t978 = 0.11216252724410924874994755739834668842421329381751e1 * t909 * t33 * t95 * t724 + 0.72029034536327556739210719076254119053922974797566e-2 * t767 * t868 * t870 * t24 - 0.96139309066379356071383620627154304363611394700724e0 * t919 * t149 * t69 * t724 + 0.90036293170409445924013398845317648817403718496958e-3 * t738 / t924 * t659 * t49 - 0.44063849988757204866050826120779056166655222571167e0 * t933 * t96 * t724 + 0.24034827266594839017845905156788576090902848675182e0 / t823 * t62 * t64 * t70 * t724 * t19 - 0.25115336796353019597335914738290663784003826116781e2 / t823 / t719 * t62 * t64 * t70 * t829 * t19 + 0.20029022722162365848204920963990480075752373895984e-1 * t932 * t92 * t96 * t2 * t724 - 0.89697631415546498561913981208180942085727950417076e0 * t826 * t92 * t96 * t2 * t829 + 0.64272053155397178166610502978456596616246611440970e3 / t962 * t62 * t64 * t70 / t828 / t723 * t19 + 0.2e1 / 0.9e1 * t860 * t972 - 0.2e1 / 0.27e2 * t842 * t474 * t659
  t1010 = t567 * t593
  t1012 = t549 * t596
  t1014 = t549 * t568
  t1017 = t602 * t48 * t74
  t1021 = t164 * t149 * t238 * t74
  t1025 = t170 * t33 * t47 * t74
  t1028 = t606 * t48 * t84
  t1030 = t451 * t16
  t1032 = t44 * t24
  t1034 = t454 * t37
  t1036 = 0.51817833333333333333333333333333333333333333333333e-2 * t496 * t533 + 0.17272611111111111111111111111111111111111111111111e-2 * t471 * t497 + 0.51817833333333333333333333333333333333333333333333e-2 * t471 * t508 + 0.13796274692623141086738355049039257855828824683819e-1 * t478 * t48 * t152 + 0.27592549385246282173476710098078515711657649367639e-1 * t148 * t149 * t238 * t152 - 0.55185098770492564346953420196157031423315298735277e-1 * t158 * t33 * t47 * t152 - 0.30878365944746984533884071665444263610784010246137e0 * t536 * t48 * t188 + 0.22478670955426118383265363956423012380560746650571e-2 * t327 * t121 + 0.37464451592376863972108939927371687300934577750952e-3 * t139 * t24 + 0.22478670955426118383265363956423012380560746650571e-2 * t330 * t132 - 0.10363566666666666666666666666666666666666666666667e-1 * t1010 - 0.34545222222222222222222222222222222222222222222223e-2 * t1012 - 0.10363566666666666666666666666666666666666666666667e-1 * t1014 - 0.13255248558342256726771310131293653497824588692887e-1 * t1017 - 0.26510497116684513453542620262587306995649177385775e-1 * t1021 + 0.53020994233369026907085240525174613991298354771549e-1 * t1025 + 0.50167127350538589836488394571946851238131125013746e0 * t1028 - 0.96902277115443742137603943210562149050493484994510e-3 * t1030 - 0.16150379519240623689600657201760358175082247499085e-3 * t1032 - 0.96902277115443742137603943210562149050493484994510e-3 * t1034
  t1038 = t1036 * t653 * t656
  t1047 = t842 * t896 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t909 * t33 * t22 * t724 + 0.21608710360898267021763215722876235716176892439270e-1 * t740 * t659
  t1049 = t1047 * t681 * t688
  t1068 = 0.51817833333333333333333333333333333333333333333333e-2 * t471 * t533 + 0.41388824077869423260215065147117773567486474051458e-1 * t158 * t33 * t22 * t152 + 0.22478670955426118383265363956423012380560746650571e-2 * t330 * t121 - 0.10363566666666666666666666666666666666666666666667e-1 * t549 * t593 - 0.39765745675026770180313930393880960493473766078662e-1 * t170 * t33 * t22 * t74 - 0.96902277115443742137603943210562149050493484994510e-3 * t454 * t16
  t1070 = t1068 * t653 * t656
  t1097 = t860 * t896 / 0.3e1 + t842 * t972 / 0.9e1 + t842 * t861 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t933 * t48 * t724 + 0.24034827266594839017845905156788576090902848675181e0 * t919 * t149 * t238 * t724 - 0.48069654533189678035691810313577152181805697350363e0 * t909 * t33 * t47 * t724 - 0.53818578849327899137148388724908565251436770250246e1 * t827 * t48 * t829 + 0.21608710360898267021763215722876235716176892439270e-1 * t768 * t659 + 0.36014517268163778369605359538127059526961487398783e-2 * t871 * t24 + 0.21608710360898267021763215722876235716176892439270e-1 * t740 * t736
  t1099 = t1097 * t681 * t688
  t1102 = t652 ** 2
  t1104 = 0.1e1 / t1102 / t652
  t1106 = t656 * t675
  t1108 = t681 * t686
  t1112 = t617 ** 2
  t1113 = 0.1e1 / t1112
  t1114 = t8 * t1113
  t1116 = -t31 - 0.16769250000000000000000000000000000000000000000000e1 * t35
  t1122 = (-t4 * t23 * t618 / 0.12e2 - t336 * t1114 * t1116 / 0.4e1) * t62 * t470
  t1123 = t504 * t617
  t1126 = t624 ** 2
  t1127 = 0.1e1 / t1126
  t1129 = t1127 * t19 * t1
  t1131 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t1127
  t1132 = 0.1e1 / t1131
  t1137 = t629 * t618
  t1138 = t1137 * t19
  t1141 = t630 * t1113
  t1143 = -t1138 * t24 / 0.6e1 - t1141 * t1116
  t1144 = 0.1e1 / t630
  t1145 = t1143 * t1144
  t1151 = t635 ** 2
  t1152 = 0.1e1 / t1151
  t1153 = t8 * t1152
  t1155 = -t31 - 0.10893333333333333333333333333333333333333333333333e1 * t35
  t1161 = (-t4 * t23 * t636 / 0.12e2 - t336 * t1153 * t1155 / 0.4e1) * t62 * t470
  t1162 = t504 * t635
  t1165 = t642 ** 2
  t1166 = 0.1e1 / t1165
  t1168 = t1166 * t19 * t1
  t1170 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t1166
  t1171 = 0.1e1 / t1170
  t1176 = t647 * t636
  t1177 = t1176 * t19
  t1180 = t648 * t1152
  t1182 = -t1177 * t24 / 0.6e1 - t1180 * t1155
  t1183 = 0.1e1 / t648
  t1184 = t1182 * t1183
  t1187 = 0.51817833333333333333333333333333333333333333333333e-2 * t1122 * t1123 + 0.12084332918108974174888840683936962325623378790503e0 * t1129 * t33 * t22 * t1132 + 0.26673100072733151593315970562575695370840511204614e-2 * t1145 * t617 - 0.10363566666666666666666666666666666666666666666667e-1 * t1161 * t1162 - 0.15357238326806922974073998139716493771837789312610e0 * t1168 * t33 * t22 * t1171 - 0.44313737677495382697984551091739236689629774931818e-2 * t1184 * t635
  t1188 = t1187 ** 2
  t1190 = t1108 * t687 * t1188
  t1193 = 0.1e1 / t1102
  t1194 = t716 * t1193
  t1195 = t1194 * t1106
  t1197 = t4 * t96 * t618
  t1201 = t336 * t47 * t1113 * t1116
  t1204 = 0.1e1 / t1112 / t617
  t1206 = t1116 ** 2
  t1210 = t22 * t1113
  t1213 = t251 - 0.11179500000000000000000000000000000000000000000000e1 * t254 + 0.22359000000000000000000000000000000000000000000000e1 * t257
  t1217 = t1112 ** 2
  t1218 = 0.1e1 / t1217
  t1220 = t1206 * t1116
  t1224 = t8 * t1204
  t1225 = t1116 * t1213
  t1232 = -t384 - 0.67077000000000000000000000000000000000000000000000e1 * t366 + 0.44718000000000000000000000000000000000000000000000e1 * t387 - 0.52171000000000000000000000000000000000000000000000e1 * t390
  t1241 = t1165 ** 2
  t1244 = 0.1e1 / t1241 / t642 * t1
  t1245 = t1244 * t3
  t1246 = t1170 ** 2
  t1247 = 0.1e1 / t1246
  t1252 = t4 * t48 * t618
  t1265 = (t1252 / 0.9e1 + t336 * t1210 * t1116 / 0.6e1 + t336 * t1224 * t1206 / 0.2e1 - t336 * t1114 * t1213 / 0.4e1) * t62 * t470
  t1266 = t504 * t1116
  t1274 = 0.1e1 / t1165 / t642 * t1
  t1275 = t1274 * t3
  t1280 = t4 * t48 * t636
  t1282 = t22 * t1152
  t1287 = 0.1e1 / t1151 / t635
  t1288 = t8 * t1287
  t1289 = t1155 ** 2
  t1295 = t251 - 0.72622222222222222222222222222222222222222222222220e0 * t254 + 0.14524444444444444444444444444444444444444444444444e1 * t257
  t1301 = (t1280 / 0.9e1 + t336 * t1282 * t1155 / 0.6e1 + t336 * t1288 * t1289 / 0.2e1 - t336 * t1153 * t1295 / 0.4e1) * t62 * t470
  t1302 = t314 * t635
  t1310 = 0.1e1 / t1126 / t624 * t1
  t1311 = t1310 * t3
  t1315 = t314 * t617
  t1321 = t504 * t1155
  t1325 = t4 * t96 * t636
  t1329 = t336 * t47 * t1152 * t1155
  t1338 = t1151 ** 2
  t1339 = 0.1e1 / t1338
  t1341 = t1289 * t1155
  t1345 = t1155 * t1295
  t1352 = -t384 - 0.43573333333333333333333333333333333333333333333332e1 * t366 + 0.29048888888888888888888888888888888888888888888888e1 * t387 - 0.33890370370370370370370370370370370370370370370369e1 * t390
  t1361 = 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t1197 - t1201 / 0.3e1 - t336 * t22 * t1204 * t1206 / 0.2e1 + t336 * t1210 * t1213 / 0.4e1 - 0.3e1 / 0.2e1 * t336 * t8 * t1218 * t1220 + 0.3e1 / 0.2e1 * t336 * t1224 * t1225 - t336 * t1114 * t1232 / 0.4e1) * t62 * t470 * t1123 - 0.37840235237252258208118331416261440653808312866271e-3 * t1245 * t96 * t1247 + 0.10363566666666666666666666666666666666666666666667e-1 * t1265 * t1266 + 0.34545222222222222222222222222222222222222222222222e-2 * t1122 * t314 * t1116 + 0.18769957954986239190534886615209047943357298048745e0 * t1275 * t96 * t1171 - 0.69090444444444444444444444444444444444444444444446e-2 * t1301 * t1302 + 0.23030148148148148148148148148148148148148148148149e-2 * t1161 * t474 * t635 - 0.14769740233244301769308583058145176175761907410615e0 * t1311 * t96 * t1132 + 0.34545222222222222222222222222222222222222222222222e-2 * t1265 * t1315 - 0.11515074074074074074074074074074074074074074074074e-2 * t1122 * t474 * t617 - 0.20727133333333333333333333333333333333333333333334e-1 * t1301 * t1321 - 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t1325 - t1329 / 0.3e1 - t336 * t22 * t1287 * t1289 / 0.2e1 + t336 * t1282 * t1295 / 0.4e1 - 0.3e1 / 0.2e1 * t336 * t8 * t1339 * t1341 + 0.3e1 / 0.2e1 * t336 * t1288 * t1345 - t336 * t1153 * t1352 / 0.4e1) * t62 * t470 * t1162
  t1362 = t1126 ** 2
  t1365 = 0.1e1 / t1362 / t624 * t1
  t1366 = t1365 * t3
  t1367 = t1131 ** 2
  t1368 = 0.1e1 / t1367
  t1382 = t629 * t1113
  t1383 = t1382 * t32
  t1388 = t1137 * t146
  t1393 = t630 * t1204
  t1397 = t1252 / 0.72e2 + t1383 * t33 * t22 * t1116 / 0.3e1 - t1388 * t240 / 0.9e1 + 0.2e1 / 0.9e1 * t1138 * t49 + 0.2e1 * t1393 * t1206 - t1141 * t1213
  t1399 = 0.1e1 / t630 / t629
  t1401 = t617 * t19
  t1405 = t1143 * t1399
  t1414 = t1405 * t1401
  t1418 = 0.1e1 / t648 / t647
  t1419 = t1182 * t1418
  t1420 = t635 * t19
  t1421 = t1419 * t1420
  t1433 = t647 * t1152
  t1434 = t1433 * t32
  t1439 = t1176 * t146
  t1444 = t648 * t1287
  t1448 = t1280 / 0.72e2 + t1434 * t33 * t22 * t1155 / 0.3e1 - t1439 * t240 / 0.9e1 + 0.2e1 / 0.9e1 * t1177 * t49 + 0.2e1 * t1444 * t1289 - t1180 * t1295
  t1453 = 0.20276584560447197672065901047389765208808740088178e0 * t1366 * t96 * t1368 + 0.51817833333333333333333333333333333333333333333333e-2 * t1122 * t504 * t1213 - 0.69090444444444444444444444444444444444444444444446e-2 * t1161 * t314 * t1155 - 0.10363566666666666666666666666666666666666666666667e-1 * t1161 * t504 * t1295 + 0.88910333575777171977719901875252317902801704015380e-3 * t1397 * t1399 * t1401 * t24 + 0.88910333575777171977719901875252317902801704015380e-3 * t1405 * t1116 * t19 * t24 + 0.29636777858592390659239967291750772634267234671793e-3 * t1405 * t617 * t146 * t240 - 0.59273555717184781318479934583501545268534469343587e-3 * t1414 * t49 + 0.98474972616656405995521224648309414865843944292929e-3 * t1421 * t49 - 0.14771245892498460899328183697246412229876591643939e-2 * t1419 * t1155 * t19 * t24 - 0.49237486308328202997760612324154707432921972146465e-3 * t1419 * t635 * t146 * t240 - 0.14771245892498460899328183697246412229876591643939e-2 * t1448 * t1418 * t1420 * t24
  t1455 = t648 ** 2
  t1486 = t1241 ** 2
  t1496 = t630 ** 2
  t1527 = t1362 ** 2
  t1537 = -0.18464057365623076124160229621558015287345739554924e-3 * t1182 / t1455 * t635 * t49 - 0.10238158884537948649382665426477662514558526208407e0 / t1241 * t62 * t64 * t70 * t1171 * t19 + 0.48160299392866510446696058166150924468483307284345e-3 / t1241 / t1165 * t62 * t64 * t70 * t1247 * t19 - 0.85317990704482905411522211887313854287987718403392e-2 * t1274 * t92 * t96 * t2 * t1171 + 0.17200106926023753730962877916482473024458324030124e-4 * t1244 * t92 * t96 * t2 * t1247 - 0.55480664900582220034593859007405864987692769991566e-6 / t1486 * t62 * t64 * t70 / t1246 / t1170 * t19 + 0.11113791696972146497214987734406539737850213001922e-3 * t1143 / t1496 * t617 * t49 + 0.80562219454059827832592271226246415504155858603354e-1 / t1362 * t62 * t64 * t70 * t1132 * t19 - 0.25806562167841887946265692242132428447574760112225e0 / t1362 / t1126 * t62 * t64 * t70 * t1368 * t19 + 0.67135182878383189860493559355205346253463215502794e-2 * t1310 * t92 * t96 * t2 * t1132 - 0.92166293456578171236663186579044387312767000400800e-2 * t1365 * t92 * t96 * t2 * t1368 + 0.20244826120247034261608782614550005883535036385819e0 / t1527 * t62 * t64 * t70 / t1367 / t1131 * t19
  t1543 = t1166 * t146 * t62
  t1549 = t1127 * t146 * t62
  t1595 = -0.11e2 / 0.216e3 * t1197 - t1201 / 0.24e2 - t629 * t1204 * t32 * t33 * t22 * t1206 + t1382 * t252 * t149 * t238 * t1116 / 0.3e1 - 0.2e1 / 0.3e1 * t1383 * t33 * t47 * t1116 + t1383 * t33 * t22 * t1213 / 0.2e1 + t360 * t361 * t618 / 0.432e3 - 0.2e1 / 0.3e1 * t1137 * t366 + 0.4e1 / 0.9e1 * t1388 * t369 - 0.14e2 / 0.27e2 * t1138 * t372 - 0.6e1 * t630 * t1218 * t1220 + 0.6e1 * t1393 * t1225 - t1141 * t1232
  t1599 = t1397 * t1144
  t1639 = -0.11e2 / 0.216e3 * t1325 - t1329 / 0.24e2 - t647 * t1287 * t32 * t33 * t22 * t1289 + t1433 * t252 * t149 * t238 * t1155 / 0.3e1 - 0.2e1 / 0.3e1 * t1434 * t33 * t47 * t1155 + t1434 * t33 * t22 * t1295 / 0.2e1 + t360 * t361 * t636 / 0.432e3 - 0.2e1 / 0.3e1 * t1176 * t366 + 0.4e1 / 0.9e1 * t1439 * t369 - 0.14e2 / 0.27e2 * t1177 * t372 - 0.6e1 * t648 * t1339 * t1341 + 0.6e1 * t1444 * t1345 - t1180 * t1352
  t1643 = t1448 * t1183
  t1654 = -0.47778074794510427030452438656895758401273122305897e0 * t1168 * t33 * t95 * t1171 + 0.40952635538151794597530661705910650058234104833627e0 * t1543 * t149 * t69 * t1171 - 0.32224887781623931133036908490498566201662343441341e0 * t1549 * t149 * t69 * t1132 + 0.37595702411894586321876393238914993901939400681566e0 * t1129 * t33 * t95 * t1132 - 0.44313737677495382697984551091739236689629774931818e-2 * t1184 * t1295 + 0.26673100072733151593315970562575695370840511204614e-2 * t1595 * t1144 * t617 + 0.53346200145466303186631941125151390741681022409228e-2 * t1599 * t1116 + 0.26673100072733151593315970562575695370840511204614e-2 * t1145 * t1213 - 0.44313737677495382697984551091739236689629774931818e-2 * t1639 * t1183 * t635 - 0.88627475354990765395969102183478473379259549863636e-2 * t1643 * t1155 + 0.48337331672435896699555362735747849302493515162012e0 * t1127 * t318 * t322 * t1132 - 0.61428953307227691896295992558865975087351157250442e0 * t1166 * t318 * t322 * t1171
  t1661 = t1102 ** 2
  t1670 = t656 * t1047
  t1671 = t1194 * t1670
  t1724 = 0.51817833333333333333333333333333333333333333333333e-2 * t1265 * t1123 + 0.17272611111111111111111111111111111111111111111111e-2 * t1122 * t1315 + 0.51817833333333333333333333333333333333333333333333e-2 * t1122 * t1266 + 0.40281109727029913916296135613123207752077929301677e-1 * t1311 * t48 * t1132 + 0.80562219454059827832592271226246415504155858603353e-1 * t1549 * t149 * t238 * t1132 - 0.16112443890811965566518454245249283100831171720671e0 * t1129 * t33 * t47 * t1132 - 0.55299776073946902741997911947426632387660200240483e-1 * t1366 * t48 * t1368 + 0.26673100072733151593315970562575695370840511204614e-2 * t1599 * t617 + 0.44455166787888585988859950937626158951400852007690e-3 * t1414 * t24 + 0.26673100072733151593315970562575695370840511204614e-2 * t1145 * t1116 - 0.10363566666666666666666666666666666666666666666667e-1 * t1301 * t1162 - 0.34545222222222222222222222222222222222222222222223e-2 * t1161 * t1302 - 0.10363566666666666666666666666666666666666666666667e-1 * t1161 * t1321 - 0.51190794422689743246913327132388312572792631042033e-1 * t1275 * t48 * t1171 - 0.10238158884537948649382665426477662514558526208407e0 * t1543 * t149 * t238 * t1171 + 0.20476317769075897298765330852955325029117052416813e0 * t1168 * t33 * t47 * t1171 + 0.10320064155614252238577726749889483814674994418074e-3 * t1245 * t48 * t1247 - 0.44313737677495382697984551091739236689629774931818e-2 * t1643 * t635 - 0.73856229462492304496640918486232061149382958219697e-3 * t1421 * t24 - 0.44313737677495382697984551091739236689629774931818e-2 * t1184 * t1155
  t1726 = t1108 * t687 * t1724
  t1731 = t687 * t1187
  t1732 = t1108 * t1731
  t1735 = t1068 * t1193
  t1736 = t1735 * t1106
  t1739 = -t51 + t57 + t78 - t88 + t100 - t108 + t118 - (t175 + t311 + t503 + t613) * t653 * t656 * t689 / 0.24e2 - t168 + t174 - t718 * (t907 + t978) * t681 * t688 / 0.24e2 - t1038 * t1049 / 0.8e1 - t1070 * t1099 / 0.8e1 - t1068 * t1104 * t1106 * t1190 / 0.4e1 + t1195 * t1108 * t687 * (t1361 + t1453 + t1537 + t1654) / 0.24e2 + t716 / t1661 * t1106 * t1108 * t687 * t1188 * t1187 / 0.4e1 + t1671 * t1726 / 0.8e1 + t1194 * t656 * t1097 * t1732 / 0.8e1 + t1736 * t1726 / 0.8e1
  t1740 = t716 * t1104
  t1751 = t1740 * t1106
  t1756 = -t1740 * t1670 * t1190 / 0.4e1 + t1036 * t1193 * t1106 * t1732 / 0.8e1 + t1735 * t1670 * t1732 / 0.4e1 + t302 + t306 + t310 - t1751 * t1108 * t1731 * t1724 / 0.4e1 + t450 + t453 + t456 + t460 + t552 + t570 + t595 + t598 - t601 - t605 + t609 + t612
  v3rho3_0_ = r0 * (t1739 + t1756) + t1671 * t1732 / 0.4e1 + t1736 * t1732 / 0.4e1 - t1751 * t1190 / 0.4e1 + t1195 * t1726 / 0.8e1 + 0.48451138557721871068801971605281074525246742497255e-3 * t1032 - t718 * t1099 / 0.8e1 - t1070 * t1049 / 0.4e1 - t1038 * t689 / 0.8e1 + 0.79531491350053540360627860787761920986947532157324e-1 * t1021 - 0.15906298270010708072125572157552384197389506431465e0 * t1025 + 0.31090700000000000000000000000000000000000000000001e-1 * t1010 + 0.10363566666666666666666666666666666666666666666667e-1 * t1012 + 0.31090700000000000000000000000000000000000000000001e-1 * t1014 + 0.39765745675026770180313930393880960493473766078662e-1 * t1017 - 0.15050138205161576950946518371584055371439337504124e1 * t1028 + 0.29070683134633122641281182963168644715148045498353e-2 * t1030 + 0.29070683134633122641281182963168644715148045498353e-2 * t1034

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t21 = t4 * t11 * t19
  t23 = t16 / 0.2e1
  t24 = t23 + 0.10498e0
  t25 = t18 ** 2
  t26 = 0.1e1 / t25
  t27 = t24 * t26
  t28 = 0.1e1 / t16
  t29 = t28 * t1
  t30 = t27 * t29
  t31 = t3 * t6
  t33 = 0.1e1 / t8 / r0
  t34 = t6 * t33
  t35 = t4 * t34
  t36 = t35 / 0.12e2
  t38 = t29 * t31 * t33
  t40 = -t36 - 0.31062000000000000000000000000000000000000000000000e0 * t38
  t41 = t33 * t40
  t45 = t24 * t19
  t47 = 0.1e1 / t16 / t14
  t48 = t45 * t47
  t49 = t1 ** 2
  t50 = t3 ** 2
  t51 = t49 * t50
  t52 = t8 ** 2
  t54 = 0.1e1 / t52 / t7
  t55 = t5 * t54
  t56 = t51 * t55
  t59 = t45 * t28
  t60 = t4 * t11
  t63 = t24 ** 2
  t65 = 0.1e1 / t25 / t18
  t66 = t63 * t65
  t67 = t40 ** 2
  t70 = t63 * t26
  t71 = t60 / 0.9e1
  t72 = t47 * t49
  t73 = t50 * t5
  t75 = t72 * t73 * t54
  t78 = t29 * t31 * t10
  t80 = t71 - 0.20708000000000000000000000000000000000000000000000e0 * t75 + 0.41416000000000000000000000000000000000000000000000e0 * t78
  t82 = t21 / 0.72e2 + t30 * t31 * t41 / 0.3e1 - t48 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t59 * t60 + 0.2e1 * t66 * t67 - t70 * t80
  t83 = 0.1e1 / t63
  t84 = t82 * t83
  t85 = t84 * t40
  t90 = -t59 * t35 / 0.6e1 - t70 * t40
  t91 = t90 * t83
  t92 = t91 * t80
  t95 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t96 = 0.1e1 / t95
  t100 = jnp.log(t4 * t13 * t96 / 0.4e1)
  t102 = t16 + 0.706042e1
  t105 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t102)
  t107 = t23 + 0.32500e0
  t108 = t107 ** 2
  t110 = jnp.log(t108 * t96)
  t115 = jnp.log(t4 * t13 * t19 / 0.4e1)
  t117 = t16 + 0.372744e1
  t120 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t117)
  t123 = jnp.log(t63 * t19)
  t125 = 0.1554535e-1 * t100 + 0.52491393169780936217021346072241076933841385384497e-1 * t105 + 0.22478670955426118383265363956423012380560746650571e-2 * t110 - 0.310907e-1 * t115 - 0.38783294878113014394824731224995739188004877421366e-1 * t120 - 0.96902277115443742137603943210562149050493484994510e-3 * t123
  t127 = t15 + 0.10061550000000000000000000000000000000000000000000e2 * t16 + 0.101578e3
  t128 = 0.1e1 / t127
  t132 = jnp.log(t4 * t13 * t128 / 0.4e1)
  t134 = t16 + 0.201231e2
  t137 = jnp.atan(0.11716852777089929792201907797022178188779527234376e1 / t134)
  t139 = t23 + 0.743294e0
  t140 = t139 ** 2
  t142 = jnp.log(t140 * t128)
  t145 = t15 + 0.65360000000000000000000000000000000000000000000000e1 * t16 + 0.427198e2
  t146 = 0.1e1 / t145
  t150 = jnp.log(t4 * t13 * t146 / 0.4e1)
  t152 = t16 + 0.130720e2
  t155 = jnp.atan(0.44899888641287296627004984787798591621072237693345e-1 / t152)
  t157 = t23 + 0.409286e0
  t158 = t157 ** 2
  t160 = jnp.log(t158 * t146)
  t162 = 0.1554535e-1 * t132 + 0.61881802979060631480216141626488805225499304723700e0 * t137 + 0.26673100072733151593315970562575695370840511204614e-2 * t142 - 0.310907e-1 * t150 - 0.20521972937837502661166379517614390730124411627871e2 * t155 - 0.44313737677495382697984551091739236689629774931818e-2 * t160
  t163 = t162 ** 2
  t165 = 0.1e1 / t163 / t162
  t166 = t125 * t165
  t167 = jnp.pi ** 2
  t168 = 0.1e1 / t167
  t170 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t171 = 0.1e1 / t170
  t175 = jnp.log(t4 * t13 * t171 / 0.4e1)
  t176 = t16 + 0.106835e1
  t179 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t176)
  t181 = t23 + 0.228344e0
  t182 = t181 ** 2
  t184 = jnp.log(t182 * t171)
  t186 = t175 + 0.32323836906055067299704130765928097906535029214058e0 * t179 + 0.21608710360898267021763215722876235716176892439270e-1 * t184
  t187 = t168 * t186
  t188 = t166 * t187
  t190 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t192 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t190 * f.p.zeta_threshold, 1)
  t194 = 0.2e1 * t192 - 0.2e1
  t195 = 2 ** (0.1e1 / 0.3e1)
  t196 = t195 - 0.1e1
  t198 = 0.1e1 / t196 / 0.2e1
  t199 = t194 * t198
  t200 = 0.9e1 * t196
  t204 = t4 * t6
  t205 = t127 ** 2
  t206 = 0.1e1 / t205
  t207 = t12 * t206
  t209 = -t36 - 0.16769250000000000000000000000000000000000000000000e1 * t38
  t215 = 0.1e1 / t3
  t216 = (-t4 * t34 * t128 / 0.12e2 - t204 * t207 * t209 / 0.4e1) * t49 * t215
  t217 = t5 * t8
  t218 = t217 * t127
  t221 = t134 ** 2
  t222 = 0.1e1 / t221
  t224 = t222 * t28 * t1
  t226 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t222
  t227 = 0.1e1 / t226
  t232 = t139 * t128
  t233 = t232 * t28
  t236 = t140 * t206
  t238 = -t233 * t35 / 0.6e1 - t236 * t209
  t239 = 0.1e1 / t140
  t240 = t238 * t239
  t246 = t145 ** 2
  t247 = 0.1e1 / t246
  t248 = t12 * t247
  t250 = -t36 - 0.10893333333333333333333333333333333333333333333333e1 * t38
  t256 = (-t4 * t34 * t146 / 0.12e2 - t204 * t248 * t250 / 0.4e1) * t49 * t215
  t257 = t217 * t145
  t260 = t152 ** 2
  t261 = 0.1e1 / t260
  t263 = t261 * t28 * t1
  t265 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t261
  t266 = 0.1e1 / t265
  t271 = t157 * t146
  t272 = t271 * t28
  t275 = t158 * t247
  t277 = -t272 * t35 / 0.6e1 - t275 * t250
  t278 = 0.1e1 / t158
  t279 = t277 * t278
  t282 = 0.51817833333333333333333333333333333333333333333333e-2 * t216 * t218 + 0.12084332918108974174888840683936962325623378790503e0 * t224 * t31 * t33 * t227 + 0.26673100072733151593315970562575695370840511204614e-2 * t240 * t127 - 0.10363566666666666666666666666666666666666666666667e-1 * t256 * t257 - 0.15357238326806922974073998139716493771837789312610e0 * t263 * t31 * t33 * t266 - 0.44313737677495382697984551091739236689629774931818e-2 * t279 * t145
  t283 = t200 * t282
  t285 = t4 * t11 * t128
  t287 = t33 * t206
  t292 = 0.1e1 / t205 / t127
  t293 = t12 * t292
  t294 = t209 ** 2
  t300 = t71 - 0.11179500000000000000000000000000000000000000000000e1 * t75 + 0.22359000000000000000000000000000000000000000000000e1 * t78
  t306 = (t285 / 0.9e1 + t204 * t287 * t209 / 0.6e1 + t204 * t293 * t294 / 0.2e1 - t204 * t207 * t300 / 0.4e1) * t49 * t215
  t310 = t5 / t52
  t311 = t310 * t127
  t314 = t217 * t209
  t317 = t221 * t134
  t319 = 0.1e1 / t317 * t1
  t320 = t319 * t3
  t325 = t222 * t47 * t49
  t334 = t221 ** 2
  t336 = 0.1e1 / t334 / t134
  t337 = t336 * t1
  t338 = t337 * t3
  t339 = t226 ** 2
  t340 = 0.1e1 / t339
  t345 = t139 * t206
  t346 = t345 * t29
  t347 = t33 * t209
  t351 = t232 * t47
  t356 = t140 * t292
  t360 = t285 / 0.72e2 + t346 * t31 * t347 / 0.3e1 - t351 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t233 * t60 + 0.2e1 * t356 * t294 - t236 * t300
  t361 = t360 * t239
  t365 = 0.1e1 / t140 / t139
  t366 = t238 * t365
  t367 = t127 * t28
  t368 = t366 * t367
  t374 = t4 * t11 * t146
  t376 = t33 * t247
  t381 = 0.1e1 / t246 / t145
  t382 = t12 * t381
  t383 = t250 ** 2
  t389 = t71 - 0.72622222222222222222222222222222222222222222222220e0 * t75 + 0.14524444444444444444444444444444444444444444444444e1 * t78
  t395 = (t374 / 0.9e1 + t204 * t376 * t250 / 0.6e1 + t204 * t382 * t383 / 0.2e1 - t204 * t248 * t389 / 0.4e1) * t49 * t215
  t398 = t310 * t145
  t401 = t217 * t250
  t404 = t260 * t152
  t406 = 0.1e1 / t404 * t1
  t407 = t406 * t3
  t412 = t261 * t47 * t49
  t421 = t260 ** 2
  t423 = 0.1e1 / t421 / t152
  t424 = t423 * t1
  t425 = t424 * t3
  t426 = t265 ** 2
  t427 = 0.1e1 / t426
  t432 = t157 * t247
  t433 = t432 * t29
  t434 = t33 * t250
  t438 = t271 * t47
  t443 = t158 * t381
  t447 = t374 / 0.72e2 + t433 * t31 * t434 / 0.3e1 - t438 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t272 * t60 + 0.2e1 * t443 * t383 - t275 * t389
  t448 = t447 * t278
  t452 = 0.1e1 / t158 / t157
  t453 = t277 * t452
  t454 = t145 * t28
  t455 = t453 * t454
  t460 = 0.51817833333333333333333333333333333333333333333333e-2 * t306 * t218 + 0.17272611111111111111111111111111111111111111111111e-2 * t216 * t311 + 0.51817833333333333333333333333333333333333333333333e-2 * t216 * t314 + 0.40281109727029913916296135613123207752077929301677e-1 * t320 * t11 * t227 + 0.80562219454059827832592271226246415504155858603353e-1 * t325 * t73 * t54 * t227 - 0.16112443890811965566518454245249283100831171720671e0 * t224 * t31 * t10 * t227 - 0.55299776073946902741997911947426632387660200240483e-1 * t338 * t11 * t340 + 0.26673100072733151593315970562575695370840511204614e-2 * t361 * t127 + 0.44455166787888585988859950937626158951400852007690e-3 * t368 * t35 + 0.26673100072733151593315970562575695370840511204614e-2 * t240 * t209 - 0.10363566666666666666666666666666666666666666666667e-1 * t395 * t257 - 0.34545222222222222222222222222222222222222222222223e-2 * t256 * t398 - 0.10363566666666666666666666666666666666666666666667e-1 * t256 * t401 - 0.51190794422689743246913327132388312572792631042033e-1 * t407 * t11 * t266 - 0.10238158884537948649382665426477662514558526208407e0 * t412 * t73 * t54 * t266 + 0.20476317769075897298765330852955325029117052416813e0 * t263 * t31 * t10 * t266 + 0.10320064155614252238577726749889483814674994418074e-3 * t425 * t11 * t427 - 0.44313737677495382697984551091739236689629774931818e-2 * t448 * t145 - 0.73856229462492304496640918486232061149382958219697e-3 * t455 * t35 - 0.44313737677495382697984551091739236689629774931818e-2 * t279 * t250
  t462 = t199 * t283 * t460
  t464 = t7 * r0
  t466 = 0.1e1 / t8 / t464
  t467 = t6 * t466
  t469 = t4 * t467 * t19
  t471 = t10 * t26
  t473 = t204 * t471 * t40
  t475 = t24 * t65
  t476 = t475 * t29
  t480 = t27 * t72
  t493 = 0.1e1 / t50
  t495 = t1 * t493 * t6
  t496 = t466 * t2
  t503 = 0.1e1 / t16 / t51 / t310 / 0.4e1
  t504 = t503 * t2
  t505 = t7 ** 2
  t506 = 0.1e1 / t505
  t507 = t504 * t506
  t511 = 0.1e1 / t52 / t464
  t512 = t5 * t511
  t513 = t51 * t512
  t516 = t4 * t467
  t519 = t25 ** 2
  t520 = 0.1e1 / t519
  t521 = t63 * t520
  t522 = t67 * t40
  t525 = t40 * t80
  t528 = 0.7e1 / 0.27e2 * t516
  t531 = t72 * t73 * t511
  t534 = t29 * t31 * t466
  t536 = -t528 - 0.12424800000000000000000000000000000000000000000000e1 * t507 + 0.82832000000000000000000000000000000000000000000000e0 * t531 - 0.96637333333333333333333333333333333333333333333333e0 * t534
  t538 = -0.11e2 / 0.216e3 * t469 - t473 / 0.24e2 - t476 * t31 * t33 * t67 + t480 * t73 * t54 * t40 / 0.3e1 - 0.2e1 / 0.3e1 * t30 * t31 * t10 * t40 + t30 * t31 * t33 * t80 / 0.2e1 + t495 * t496 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t45 * t507 + 0.4e1 / 0.9e1 * t48 * t513 - 0.14e2 / 0.27e2 * t59 * t516 - 0.6e1 * t521 * t522 + 0.6e1 * t66 * t525 - t70 * t536
  t539 = t538 * t83
  t540 = t539 * t18
  t542 = t117 ** 2
  t543 = 0.1e1 / t542
  t544 = t543 * t503
  t545 = t2 * t506
  t547 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t543
  t548 = 0.1e1 / t547
  t550 = t544 * t545 * t548
  t552 = 0.1e1 / t163
  t553 = t125 * t552
  t557 = t170 ** 2
  t558 = 0.1e1 / t557
  t559 = t12 * t558
  t561 = -t36 - 0.89029166666666666666666666666666666666666666666667e-1 * t38
  t567 = (-t4 * t34 * t171 / 0.12e2 - t204 * t559 * t561 / 0.4e1) * t49 * t215
  t568 = t217 * t170
  t571 = t176 ** 2
  t572 = 0.1e1 / t571
  t574 = t572 * t28 * t1
  t576 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t572
  t577 = 0.1e1 / t576
  t582 = t181 * t171
  t583 = t582 * t28
  t586 = t182 * t558
  t588 = -t583 * t35 / 0.6e1 - t586 * t561
  t589 = 0.1e1 / t182
  t590 = t588 * t589
  t593 = t567 * t568 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t574 * t31 * t33 * t577 + 0.21608710360898267021763215722876235716176892439270e-1 * t590 * t170
  t594 = t168 * t593
  t595 = t553 * t594
  t597 = t199 * t200 * t460
  t600 = t163 ** 2
  t601 = 0.1e1 / t600
  t602 = t125 * t601
  t603 = t602 * t187
  t604 = t282 ** 2
  t607 = t199 * t200 * t604 * t282
  t612 = t95 ** 2
  t613 = 0.1e1 / t612
  t614 = t12 * t613
  t616 = -t36 - 0.58836833333333333333333333333333333333333333333333e0 * t38
  t622 = (-t4 * t34 * t96 / 0.12e2 - t204 * t614 * t616 / 0.4e1) * t49 * t215
  t623 = t217 * t95
  t626 = t102 ** 2
  t627 = 0.1e1 / t626
  t629 = t627 * t28 * t1
  t631 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t627
  t632 = 0.1e1 / t631
  t637 = t107 * t96
  t638 = t637 * t28
  t641 = t108 * t613
  t643 = -t638 * t35 / 0.6e1 - t641 * t616
  t644 = 0.1e1 / t108
  t645 = t643 * t644
  t651 = t12 * t26
  t657 = (-t4 * t34 * t19 / 0.12e2 - t204 * t651 * t40 / 0.4e1) * t49 * t215
  t658 = t217 * t18
  t662 = t543 * t28 * t1
  t669 = 0.51817833333333333333333333333333333333333333333333e-2 * t622 * t623 + 0.41388824077869423260215065147117773567486474051458e-1 * t629 * t31 * t33 * t632 + 0.22478670955426118383265363956423012380560746650571e-2 * t645 * t95 - 0.10363566666666666666666666666666666666666666666667e-1 * t657 * t658 - 0.39765745675026770180313930393880960493473766078662e-1 * t662 * t31 * t33 * t548 - 0.96902277115443742137603943210562149050493484994510e-3 * t91 * t18
  t670 = t669 * t165
  t671 = t670 * t187
  t672 = t200 * t604
  t673 = t199 * t672
  t675 = t553 * t187
  t680 = t5 / t52 / r0
  t681 = t680 * t127
  t688 = t4 * t467 * t146
  t690 = t10 * t247
  t692 = t204 * t690 * t250
  t694 = t33 * t381
  t701 = t246 ** 2
  t702 = 0.1e1 / t701
  t703 = t12 * t702
  t704 = t383 * t250
  t708 = t250 * t389
  t715 = -t528 - 0.43573333333333333333333333333333333333333333333332e1 * t507 + 0.29048888888888888888888888888888888888888888888888e1 * t531 - 0.33890370370370370370370370370370370370370370370369e1 * t534
  t721 = (-0.7e1 / 0.27e2 * t688 - t692 / 0.3e1 - t204 * t694 * t383 / 0.2e1 + t204 * t376 * t389 / 0.4e1 - 0.3e1 / 0.2e1 * t204 * t703 * t704 + 0.3e1 / 0.2e1 * t204 * t382 * t708 - t204 * t248 * t715 / 0.4e1) * t49 * t215
  t727 = t217 * t300
  t730 = t319 * t493
  t731 = t2 * t227
  t735 = t337 * t493
  t736 = t2 * t340
  t740 = t334 ** 2
  t741 = 0.1e1 / t740
  t742 = t741 * t49
  t743 = t742 * t50
  t745 = 0.1e1 / t339 / t226
  t746 = t745 * t28
  t752 = t680 * t145
  t758 = 0.34545222222222222222222222222222222222222222222222e-2 * t306 * t311 - 0.11515074074074074074074074074074074074074074074074e-2 * t216 * t681 - 0.37840235237252258208118331416261440653808312866271e-3 * t425 * t467 * t427 - 0.10363566666666666666666666666666666666666666666667e-1 * t721 * t257 + 0.20276584560447197672065901047389765208808740088178e0 * t338 * t467 * t340 + 0.51817833333333333333333333333333333333333333333333e-2 * t216 * t727 + 0.67135182878383189860493559355205346253463215502794e-2 * t730 * t467 * t731 - 0.92166293456578171236663186579044387312767000400800e-2 * t735 * t467 * t736 + 0.20244826120247034261608782614550005883535036385819e0 * t743 * t512 * t746 - 0.69090444444444444444444444444444444444444444444446e-2 * t395 * t398 + 0.23030148148148148148148148148148148148148148148149e-2 * t256 * t752 - 0.14769740233244301769308583058145176175761907410615e0 * t320 * t467 * t227
  t760 = t4 * t467 * t128
  t762 = t10 * t206
  t764 = t204 * t762 * t209
  t766 = t33 * t292
  t773 = t205 ** 2
  t774 = 0.1e1 / t773
  t775 = t12 * t774
  t776 = t294 * t209
  t780 = t209 * t300
  t787 = -t528 - 0.67077000000000000000000000000000000000000000000000e1 * t507 + 0.44718000000000000000000000000000000000000000000000e1 * t531 - 0.52171000000000000000000000000000000000000000000000e1 * t534
  t793 = (-0.7e1 / 0.27e2 * t760 - t764 / 0.3e1 - t204 * t766 * t294 / 0.2e1 + t204 * t287 * t300 / 0.4e1 - 0.3e1 / 0.2e1 * t204 * t775 * t776 + 0.3e1 / 0.2e1 * t204 * t293 * t780 - t204 * t207 * t787 / 0.4e1) * t49 * t215
  t798 = t310 * t250
  t801 = t217 * t389
  t809 = t447 * t452
  t810 = t809 * t454
  t813 = t250 * t28
  t814 = t453 * t813
  t817 = t145 * t47
  t818 = t453 * t817
  t821 = t360 * t365
  t822 = t821 * t367
  t825 = t209 * t28
  t826 = t366 * t825
  t829 = t127 * t47
  t830 = t366 * t829
  t833 = 0.51817833333333333333333333333333333333333333333333e-2 * t793 * t218 - 0.20727133333333333333333333333333333333333333333334e-1 * t395 * t401 - 0.69090444444444444444444444444444444444444444444446e-2 * t256 * t798 - 0.10363566666666666666666666666666666666666666666667e-1 * t256 * t801 + 0.18769957954986239190534886615209047943357298048745e0 * t407 * t467 * t266 + 0.98474972616656405995521224648309414865843944292929e-3 * t455 * t60 - 0.14771245892498460899328183697246412229876591643939e-2 * t810 * t35 - 0.14771245892498460899328183697246412229876591643939e-2 * t814 * t35 - 0.49237486308328202997760612324154707432921972146465e-3 * t818 * t56 + 0.88910333575777171977719901875252317902801704015380e-3 * t822 * t35 + 0.88910333575777171977719901875252317902801704015380e-3 * t826 * t35 + 0.29636777858592390659239967291750772634267234671793e-3 * t830 * t56
  t837 = t158 ** 2
  t838 = 0.1e1 / t837
  t839 = t277 * t838
  t840 = t839 * t145
  t843 = 0.1e1 / t421
  t844 = t843 * t49
  t845 = t844 * t50
  t846 = t266 * t28
  t867 = 0.1e1 / t421 / t260
  t868 = t867 * t49
  t869 = t868 * t50
  t870 = t427 * t28
  t874 = t406 * t493
  t875 = t2 * t266
  t879 = t424 * t493
  t880 = t2 * t427
  t884 = t421 ** 2
  t885 = 0.1e1 / t884
  t886 = t885 * t49
  t887 = t886 * t50
  t889 = 0.1e1 / t426 / t265
  t890 = t889 * t28
  t894 = t140 ** 2
  t895 = 0.1e1 / t894
  t896 = t238 * t895
  t897 = t896 * t127
  t900 = -0.59273555717184781318479934583501545268534469343587e-3 * t368 * t60 - 0.18464057365623076124160229621558015287345739554924e-3 * t840 * t60 - 0.10238158884537948649382665426477662514558526208407e0 * t845 * t512 * t846 - 0.47778074794510427030452438656895758401273122305897e0 * t263 * t31 * t466 * t266 + 0.40952635538151794597530661705910650058234104833627e0 * t412 * t73 * t511 * t266 - 0.32224887781623931133036908490498566201662343441341e0 * t325 * t73 * t511 * t227 + 0.37595702411894586321876393238914993901939400681566e0 * t224 * t31 * t466 * t227 + 0.48160299392866510446696058166150924468483307284345e-3 * t869 * t512 * t870 - 0.85317990704482905411522211887313854287987718403392e-2 * t874 * t467 * t875 + 0.17200106926023753730962877916482473024458324030124e-4 * t879 * t467 * t880 - 0.55480664900582220034593859007405864987692769991566e-6 * t887 * t512 * t890 + 0.11113791696972146497214987734406539737850213001922e-3 * t897 * t60
  t901 = 0.1e1 / t334
  t902 = t901 * t49
  t903 = t902 * t50
  t904 = t227 * t28
  t909 = 0.1e1 / t334 / t221
  t910 = t909 * t49
  t911 = t910 * t50
  t912 = t340 * t28
  t916 = t261 * t503
  t920 = t222 * t503
  t926 = t310 * t209
  t935 = t139 * t292
  t936 = t935 * t29
  t940 = t345 * t72
  t962 = t140 * t774
  t968 = -0.11e2 / 0.216e3 * t760 - t764 / 0.24e2 - t936 * t31 * t33 * t294 + t940 * t73 * t54 * t209 / 0.3e1 - 0.2e1 / 0.3e1 * t346 * t31 * t10 * t209 + t346 * t31 * t33 * t300 / 0.2e1 + t495 * t496 * t128 / 0.432e3 - 0.2e1 / 0.3e1 * t232 * t507 + 0.4e1 / 0.9e1 * t351 * t513 - 0.14e2 / 0.27e2 * t233 * t516 - 0.6e1 * t962 * t776 + 0.6e1 * t356 * t780 - t236 * t787
  t969 = t968 * t239
  t978 = t157 * t381
  t979 = t978 * t29
  t983 = t432 * t72
  t1005 = t158 * t702
  t1011 = -0.11e2 / 0.216e3 * t688 - t692 / 0.24e2 - t979 * t31 * t33 * t383 + t983 * t73 * t54 * t250 / 0.3e1 - 0.2e1 / 0.3e1 * t433 * t31 * t10 * t250 + t433 * t31 * t33 * t389 / 0.2e1 + t495 * t496 * t146 / 0.432e3 - 0.2e1 / 0.3e1 * t271 * t507 + 0.4e1 / 0.9e1 * t438 * t513 - 0.14e2 / 0.27e2 * t272 * t516 - 0.6e1 * t1005 * t704 + 0.6e1 * t443 * t708 - t275 * t715
  t1012 = t1011 * t278
  t1015 = 0.80562219454059827832592271226246415504155858603354e-1 * t903 * t512 * t904 - 0.25806562167841887946265692242132428447574760112225e0 * t911 * t512 * t912 - 0.61428953307227691896295992558865975087351157250442e0 * t916 * t545 * t266 + 0.48337331672435896699555362735747849302493515162012e0 * t920 * t545 * t227 + 0.10363566666666666666666666666666666666666666666667e-1 * t306 * t314 + 0.34545222222222222222222222222222222222222222222222e-2 * t216 * t926 - 0.88627475354990765395969102183478473379259549863636e-2 * t448 * t250 - 0.44313737677495382697984551091739236689629774931818e-2 * t279 * t389 + 0.26673100072733151593315970562575695370840511204614e-2 * t969 * t127 + 0.53346200145466303186631941125151390741681022409228e-2 * t361 * t209 + 0.26673100072733151593315970562575695370840511204614e-2 * t240 * t300 - 0.44313737677495382697984551091739236689629774931818e-2 * t1012 * t145
  t1017 = t758 + t833 + t900 + t1015
  t1019 = t199 * t200 * t1017
  t1022 = t669 * t552
  t1023 = t1022 * t594
  t1024 = t199 * t283
  t1030 = t4 * t11 * t96
  t1032 = t107 * t613
  t1033 = t1032 * t29
  t1034 = t33 * t616
  t1038 = t637 * t47
  t1044 = 0.1e1 / t612 / t95
  t1045 = t108 * t1044
  t1046 = t616 ** 2
  t1051 = t71 - 0.39224555555555555555555555555555555555555555555555e0 * t75 + 0.78449111111111111111111111111111111111111111111110e0 * t78
  t1053 = t1030 / 0.72e2 + t1033 * t31 * t1034 / 0.3e1 - t1038 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t638 * t60 + 0.2e1 * t1045 * t1046 - t641 * t1051
  t1054 = t1053 * t644
  t1060 = t4 * t467 * t96
  t1062 = t10 * t613
  t1064 = t204 * t1062 * t616
  t1066 = t107 * t1044
  t1067 = t1066 * t29
  t1071 = t1032 * t72
  t1093 = t612 ** 2
  t1094 = 0.1e1 / t1093
  t1095 = t108 * t1094
  t1096 = t1046 * t616
  t1099 = t616 * t1051
  t1105 = -t528 - 0.23534733333333333333333333333333333333333333333333e1 * t507 + 0.15689822222222222222222222222222222222222222222222e1 * t531 - 0.18304792592592592592592592592592592592592592592592e1 * t534
  t1107 = -0.11e2 / 0.216e3 * t1060 - t1064 / 0.24e2 - t1067 * t31 * t33 * t1046 + t1071 * t73 * t54 * t616 / 0.3e1 - 0.2e1 / 0.3e1 * t1033 * t31 * t10 * t616 + t1033 * t31 * t33 * t1051 / 0.2e1 + t495 * t496 * t96 / 0.432e3 - 0.2e1 / 0.3e1 * t637 * t507 + 0.4e1 / 0.9e1 * t1038 * t513 - 0.14e2 / 0.27e2 * t638 * t516 - 0.6e1 * t1095 * t1096 + 0.6e1 * t1045 * t1099 - t641 * t1105
  t1108 = t1107 * t644
  t1111 = t627 * t503
  t1116 = t680 * t18
  t1117 = t657 * t1116
  t1121 = t33 * t65
  t1125 = t33 * t26
  t1129 = t12 * t520
  t1133 = t12 * t65
  t1142 = (-0.7e1 / 0.27e2 * t469 - t473 / 0.3e1 - t204 * t1121 * t67 / 0.2e1 + t204 * t1125 * t80 / 0.4e1 - 0.3e1 / 0.2e1 * t204 * t1129 * t522 + 0.3e1 / 0.2e1 * t204 * t1133 * t525 - t204 * t651 * t536 / 0.4e1) * t49 * t215
  t1143 = t1142 * t658
  t1145 = t626 ** 2
  t1147 = 0.1e1 / t1145 / t102
  t1148 = t1147 * t1
  t1149 = t1148 * t3
  t1150 = t631 ** 2
  t1151 = 0.1e1 / t1150
  t1155 = t310 * t616
  t1158 = -0.19380455423088748427520788642112429810098696998902e-2 * t85 - 0.96902277115443742137603943210562149050493484994510e-3 * t92 - 0.96902277115443742137603943210562149050493484994510e-3 * t540 + 0.44957341910852236766530727912846024761121493301142e-2 * t1054 * t616 + 0.22478670955426118383265363956423012380560746650571e-2 * t645 * t1051 + 0.22478670955426118383265363956423012380560746650571e-2 * t1108 * t95 + 0.16555529631147769304086026058847109426994589620583e0 * t1111 * t545 * t632 - 0.15906298270010708072125572157552384197389506431465e0 * t550 + 0.23030148148148148148148148148148148148148148148149e-2 * t1117 - 0.10363566666666666666666666666666666666666666666667e-1 * t1143 + 0.11322067513073894329090826277329563323954137090250e1 * t1149 * t467 * t1151 + 0.34545222222222222222222222222222222222222222222222e-2 * t622 * t1155
  t1159 = t217 * t1051
  t1163 = 0.1e1 / t63 / t24
  t1164 = t82 * t1163
  t1165 = t18 * t28
  t1166 = t1164 * t1165
  t1167 = t1166 * t35
  t1169 = t310 * t40
  t1170 = t657 * t1169
  t1184 = (t21 / 0.9e1 + t204 * t1125 * t40 / 0.6e1 + t204 * t1133 * t67 / 0.2e1 - t204 * t651 * t80 / 0.4e1) * t49 * t215
  t1185 = t217 * t40
  t1186 = t1184 * t1185
  t1190 = t33 * t1044
  t1194 = t33 * t613
  t1198 = t12 * t1094
  t1202 = t12 * t1044
  t1211 = (-0.7e1 / 0.27e2 * t1060 - t1064 / 0.3e1 - t204 * t1190 * t1046 / 0.2e1 + t204 * t1194 * t1051 / 0.4e1 - 0.3e1 / 0.2e1 * t204 * t1198 * t1096 + 0.3e1 / 0.2e1 * t204 * t1202 * t1099 - t204 * t614 * t1105 / 0.4e1) * t49 * t215
  t1214 = t310 * t18
  t1215 = t1184 * t1214
  t1217 = t680 * t95
  t1220 = t626 * t102
  t1222 = 0.1e1 / t1220 * t1
  t1223 = t1222 * t3
  t1239 = (t1030 / 0.9e1 + t204 * t1194 * t616 / 0.6e1 + t204 * t1202 * t1046 / 0.2e1 - t204 * t614 * t1051 / 0.4e1) * t49 * t215
  t1240 = t310 * t95
  t1243 = t542 * t117
  t1245 = 0.1e1 / t1243 * t1
  t1246 = t1245 * t3
  t1248 = t1246 * t467 * t548
  t1250 = t542 ** 2
  t1252 = 0.1e1 / t1250 / t117
  t1253 = t1252 * t1
  t1254 = t1253 * t3
  t1255 = t547 ** 2
  t1256 = 0.1e1 / t1255
  t1258 = t1254 * t467 * t1256
  t1260 = t217 * t80
  t1261 = t657 * t1260
  t1263 = 0.51817833333333333333333333333333333333333333333333e-2 * t622 * t1159 - 0.32300759038481247379201314403520716350164494998170e-3 * t1167 - 0.69090444444444444444444444444444444444444444444446e-2 * t1170 - 0.20727133333333333333333333333333333333333333333334e-1 * t1186 + 0.51817833333333333333333333333333333333333333333333e-2 * t1211 * t623 - 0.69090444444444444444444444444444444444444444444446e-2 * t1215 - 0.11515074074074074074074074074074074074074074074074e-2 * t622 * t1217 - 0.50586340539618183984707301846477278804705690507337e-1 * t1223 * t467 * t632 + 0.34545222222222222222222222222222222222222222222222e-2 * t1239 * t1240 + 0.48602578047254941331494803814743396158690158540586e-1 * t1248 - 0.18394613361864149606712411343047178787314745838373e1 * t1258 - 0.10363566666666666666666666666666666666666666666667e-1 * t1261
  t1265 = t217 * t616
  t1268 = t63 ** 2
  t1269 = 0.1e1 / t1268
  t1270 = t90 * t1269
  t1271 = t1270 * t18
  t1272 = t1271 * t60
  t1274 = 0.1e1 / t1250
  t1275 = t1274 * t49
  t1276 = t1275 * t50
  t1277 = t548 * t28
  t1279 = t1276 * t512 * t1277
  t1282 = 0.1e1 / t1250 / t542
  t1283 = t1282 * t49
  t1284 = t1283 * t50
  t1285 = t1256 * t28
  t1287 = t1284 * t512 * t1285
  t1289 = t1245 * t493
  t1290 = t2 * t548
  t1292 = t1289 * t467 * t1290
  t1294 = t1253 * t493
  t1295 = t2 * t1256
  t1297 = t1294 * t467 * t1295
  t1299 = t1250 ** 2
  t1300 = 0.1e1 / t1299
  t1301 = t1300 * t49
  t1302 = t1301 * t50
  t1304 = 0.1e1 / t1255 / t547
  t1305 = t1304 * t28
  t1307 = t1302 * t512 * t1305
  t1310 = t627 * t47 * t49
  t1320 = t543 * t47 * t49
  t1323 = t1320 * t73 * t511 * t548
  t1327 = t662 * t31 * t466 * t548
  t1329 = t108 ** 2
  t1330 = 0.1e1 / t1329
  t1331 = t643 * t1330
  t1332 = t1331 * t95
  t1335 = 0.10363566666666666666666666666666666666666666666667e-1 * t1239 * t1265 - 0.40375948798101559224001643004400895437705618747712e-4 * t1272 - 0.26510497116684513453542620262587306995649177385774e-1 * t1279 + 0.23411326096918008590361250800241863911127858339748e1 * t1287 - 0.22092080930570427877952183552156089163040981154812e-2 * t1292 + 0.83611878917564316394147324286578085396885208356242e-1 * t1297 - 0.50631328524251801700246888250186209051365905137714e2 * t1307 - 0.11037019754098512869390684039231406284663059747056e0 * t1310 * t73 * t511 * t632 + 0.12876523046448265014289131379103307332106903038231e0 * t629 * t31 * t466 * t632 + 0.10604198846673805381417048105034922798259670954310e0 * t1323 - 0.12371565321119439611653222789207409931302949446695e0 * t1327 + 0.93661128980942159930272349818429218252336444377380e-4 * t1332 * t60
  t1336 = t1148 * t493
  t1337 = t2 * t1151
  t1341 = t1145 ** 2
  t1342 = 0.1e1 / t1341
  t1343 = t1342 * t49
  t1344 = t1343 * t50
  t1346 = 0.1e1 / t1150 / t631
  t1347 = t1346 * t28
  t1351 = 0.1e1 / t1145
  t1352 = t1351 * t49
  t1353 = t1352 * t50
  t1354 = t632 * t28
  t1359 = 0.1e1 / t1145 / t626
  t1360 = t1359 * t49
  t1361 = t1360 * t50
  t1362 = t1151 * t28
  t1366 = t1222 * t493
  t1367 = t2 * t632
  t1371 = t90 * t1163
  t1372 = t40 * t28
  t1373 = t1371 * t1372
  t1374 = t1373 * t35
  t1377 = 0.1e1 / t108 / t107
  t1378 = t643 * t1377
  t1379 = t95 * t28
  t1380 = t1378 * t1379
  t1383 = t1371 * t1165
  t1384 = t1383 * t60
  t1386 = t1053 * t1377
  t1387 = t1386 * t1379
  t1390 = t616 * t28
  t1391 = t1378 * t1390
  t1394 = t95 * t47
  t1395 = t1378 * t1394
  t1398 = t18 * t47
  t1399 = t1371 * t1398
  t1400 = t1399 * t56
  t1402 = -0.51463943241244974223140119442407106017973350410227e-1 * t1336 * t467 * t1337 + 0.18429583437767336287475605998441200095133403022660e2 * t1344 * t512 * t1347 + 0.27592549385246282173476710098078515711657649367638e-1 * t1353 * t512 * t1354 - 0.14409904107548592782479233443873989685032538114864e1 * t1361 * t512 * t1362 + 0.22993791154371901811230591748398763093048041139699e-2 * t1366 * t467 * t1367 - 0.32300759038481247379201314403520716350164494998170e-3 * t1374 - 0.49952602123169151962811919903162249734579437001269e-3 * t1380 * t60 + 0.21533839358987498252800876269013810900109663332113e-3 * t1384 + 0.74928903184753727944217879854743374601869155501904e-3 * t1387 * t35 + 0.74928903184753727944217879854743374601869155501904e-3 * t1391 * t35 + 0.24976301061584575981405959951581124867289718500635e-3 * t1395 * t56 - 0.10766919679493749126400438134506905450054831666057e-3 * t1400
  t1404 = t1158 + t1263 + t1335 + t1402
  t1405 = 0.1e1 / t162
  t1407 = t1404 * t1405 * t168
  t1409 = t198 * t200
  t1410 = t186 * t194 * t1409
  t1418 = t166 * t594
  t1423 = 0.12112784639430467767200492901320268631311685624314e-3 * t82 * t1269 * t18 * t60
  t1426 = 0.12112784639430467767200492901320268631311685624314e-3 * t1270 * t40 * t60
  t1428 = 0.1e1 / t52 / t505
  t1429 = t5 * t1428
  t1432 = 0.19441031218901976532597921525897358463476063416234e0 * t1276 * t1429 * t1277
  t1435 = 0.17168305804406539632931583920177366868160429449148e2 * t1284 * t1429 * t1285
  t1438 = 0.37129640917784654580181051383469886637668330434323e3 * t1302 * t1429 * t1305
  t1440 = 0.14804514559303905048800602434946994993825393540828e-3 * t1271 * t516
  t1442 = 0.1e1 / t8 / t505
  t1446 = 0.41238551070398132038844075964024699771009831488983e0 * t662 * t31 * t1442 * t548
  t1452 = t215 * t5
  t1455 = 0.12657832131062950425061722062546552262841476284429e3 / t1299 / t117 * t2 * t1428 * t1304 * t49 * t1452
  t1460 = t1255 ** 2
  t1465 = 0.19162434373246948642083122762742588170998040494372e4 / t1299 / t1243 * t2 * t1428 / t1460 * t49 * t1452
  t1466 = t6 * t1442
  t1482 = 0.37740225043579647763636087591098544413180456967501e0 * t1336 * t1466 * t1337 - t1423 - t1426 - 0.20234536215847273593882920738590911521882276202934e0 * t1353 * t1429 * t1354 + t1432 - t1435 + t1438 + t1440 + t1446 - 0.34342413959678791974433194933424046692523362938372e-3 * t1332 * t516 + 0.28098338694282647979081704945528765475700933313214e-3 * t1053 * t1330 * t95 * t60 + 0.28098338694282647979081704945528765475700933313214e-3 * t1331 * t616 * t60
  t1501 = t1150 ** 2
  t1531 = 0.16200859349084980443831601271581132052896719513529e-1 * t1289 * t1466 * t1290
  t1534 = 0.61315377872880498689041371143490595957715819461244e0 * t1294 * t1466 * t1295
  t1538 = 0.10567263012202301373818104525507592435690527950900e2 * t1361 * t1429 * t1362 - 0.13515027854362713277482111065523546736431162216617e3 * t1344 * t1429 * t1347 - t1455 + t1465 + 0.46073958594418340718689014996103000237833507556650e2 / t1341 / t102 * t2 * t1428 * t1346 * t49 * t1452 - 0.41248484411876216403621151040619215743173669759529e3 / t1341 / t1220 * t2 * t1428 / t1501 * t49 * t1452 + 0.18395032923497521448984473398719010474438432911759e-1 * t1147 * t2 * t1428 * t632 * t49 * t1452 - 0.16468461837198391751404838221570273925751472131273e1 / t1145 / t1220 * t2 * t1428 * t1151 * t49 * t1452 + 0.49053421129326723863958595729917361265169154431359e0 * t1310 * t73 * t1428 * t632 - 0.42921743488160883380963771263677691107023010127437e0 * t629 * t31 * t1442 * t632 + t1531 - t1534 - 0.16862113513206061328235767282159092934901896835780e-1 * t1366 * t1466 * t1367
  t1540 = t505 * r0
  t1541 = 0.1e1 / t1540
  t1542 = t2 * t1541
  t1545 = 0.12725038616008566457700457726041907357911605145172e1 * t544 * t1542 * t548
  t1550 = 0.10126265704850360340049377650037241810273181027543e3 * t1300 * t2 * t1541 * t1304 * t47
  t1555 = 0.53020994233369026907085240525174613991298354771548e-1 * t1274 * t2 * t1541 * t548 * t47
  t1560 = 0.46822652193836017180722501600483727822255716679496e1 * t1282 * t2 * t1541 * t1256 * t47
  t1566 = 0.17673664744456342302361746841724871330432784923849e-1 * t1252 * t2 * t1428 * t548 * t49 * t1452
  t1574 = 0.26755801253620581246127143771704987327003266673998e1 / t1250 / t1243 * t2 * t1428 * t1256 * t49 * t1452
  t1578 = 0.47129772651883579472964658244599656881154093130267e0 * t1320 * t73 * t1428 * t548
  t1583 = t1428 * t2
  t1586 = 0.84385547540419669500411480416977015085609841896189e1 * t1301 * t1452 * t1583 * t1305
  t1593 = t73 * t511 * t28
  t1595 = 0.53834598397468745632002190672534527250274158330283e-4 * t90 / t1268 / t24 * t18 * t49 * t1593
  t1599 = t4 * t1466 * t96
  t1603 = t204 * t466 * t613 * t616
  t1607 = t204 * t10 * t1044 * t1046
  t1610 = t204 * t1062 * t1051
  t1623 = 0.1e1 / t1093 / t95
  t1625 = t1046 ** 2
  t1629 = t1046 * t1051
  t1633 = t1051 ** 2
  t1637 = t616 * t1105
  t1641 = t4 * t1466
  t1642 = 0.70e2 / 0.81e2 * t1641
  t1647 = 0.1e1 / t16 / t2 * r0 / 0.48e2
  t1648 = t1647 * t2
  t1650 = 0.1e1 / t8 / t1540
  t1652 = t1648 * t1650 * t204
  t1654 = t504 * t1541
  t1657 = t72 * t73 * t1428
  t1660 = t29 * t31 * t1442
  t1662 = t1642 - 0.19612277777777777777777777777777777777777777777777e1 * t1652 + 0.18827786666666666666666666666666666666666666666666e2 * t1654 - 0.69732543209876543209876543209876543209876543209875e1 * t1657 + 0.61015975308641975308641975308641975308641975308640e1 * t1660
  t1666 = 0.70e2 / 0.81e2 * t1599 + 0.28e2 / 0.27e2 * t1603 + 0.4e1 / 0.3e1 * t1607 - 0.2e1 / 0.3e1 * t1610 + 0.2e1 * t204 * t33 * t1094 * t1096 - 0.2e1 * t204 * t1190 * t1099 + t204 * t1194 * t1105 / 0.3e1 + 0.6e1 * t204 * t12 * t1623 * t1625 - 0.9e1 * t204 * t1198 * t1629 + 0.3e1 / 0.2e1 * t204 * t1202 * t1633 + 0.2e1 * t204 * t1202 * t1637 - t204 * t614 * t1662 / 0.4e1
  t1671 = t1545 - t1550 - t1555 + t1560 - t1566 + t1574 - t1578 - 0.13244423704918215443268820847077687541595671696467e1 * t1111 * t1542 * t632 - t1586 - t1595 + 0.10363566666666666666666666666666666666666666666667e-1 * t1239 * t1155 + 0.51817833333333333333333333333333333333333333333333e-2 * t1666 * t49 * t215 * t623
  t1679 = 0.31090700000000000000000000000000000000000000000001e-1 * t1184 * t1260
  t1682 = 0.10363566666666666666666666666666666666666666666667e-1 * t657 * t217 * t536
  t1684 = 0.10363566666666666666666666666666666666666666666667e-1 * t1142 * t1214
  t1687 = 0.20435174860777645787105769785744382475812907568201e0 * t1246 * t1466 * t548
  t1690 = 0.77340987998746992664586274965084728992118817729523e1 * t1254 * t1466 * t1256
  t1692 = t4 * t1466 * t19
  t1696 = t204 * t466 * t26 * t40
  t1700 = t204 * t10 * t65 * t67
  t1703 = t204 * t471 * t80
  t1716 = 0.1e1 / t519 / t18
  t1718 = t67 ** 2
  t1722 = t67 * t80
  t1726 = t80 ** 2
  t1730 = t40 * t536
  t1738 = t1642 - 0.10354000000000000000000000000000000000000000000000e1 * t1652 + 0.99398400000000000000000000000000000000000000000000e1 * t1654 - 0.36814222222222222222222222222222222222222222222222e1 * t1657 + 0.32212444444444444444444444444444444444444444444444e1 * t1660
  t1742 = 0.70e2 / 0.81e2 * t1692 + 0.28e2 / 0.27e2 * t1696 + 0.4e1 / 0.3e1 * t1700 - 0.2e1 / 0.3e1 * t1703 + 0.2e1 * t204 * t33 * t520 * t522 - 0.2e1 * t204 * t1121 * t525 + t204 * t1125 * t536 / 0.3e1 + 0.6e1 * t204 * t12 * t1716 * t1718 - 0.9e1 * t204 * t1129 * t1722 + 0.3e1 / 0.2e1 * t204 * t1133 * t1726 + 0.2e1 * t204 * t1133 * t1730 - t204 * t651 * t1738 / 0.4e1
  t1746 = 0.10363566666666666666666666666666666666666666666667e-1 * t1742 * t49 * t215 * t658
  t1749 = 0.64601518076962494758402628807041432700328989996342e-3 * t1371 * t18 * t507
  t1751 = 0.20727133333333333333333333333333333333333333333334e-1 * t1184 * t1169
  t1754 = 0.38383580246913580246913580246913580246913580246915e-2 * t657 * t55 * t18
  t1757 = 0.10363566666666666666666666666666666666666666666667e-1 * t657 * t310 * t80
  t1760 = 0.69090444444444444444444444444444444444444444444446e-2 * t657 * t680 * t40
  t1761 = -0.47604147498151601156404610484226573066625349129460e1 * t1149 * t1466 * t1151 - 0.34545222222222222222222222222222222222222222222222e-2 * t622 * t680 * t616 - t1679 - t1682 - t1684 - t1687 + t1690 - t1746 - t1749 - t1751 - t1754 - t1757 + t1760
  t1765 = 0.31090700000000000000000000000000000000000000000001e-1 * t1142 * t1185
  t1767 = 0.69090444444444444444444444444444444444444444444446e-2 * t1184 * t1116
  t1801 = -t1765 + t1767 - 0.28819808215097185564958466887747979370065076229728e1 * t1359 * t2 * t1541 * t1151 * t47 + 0.36859166875534672574951211996882400190266806045320e2 * t1342 * t2 * t1541 * t1346 * t47 + 0.55185098770492564346953420196157031423315298735276e-1 * t1351 * t2 * t1541 * t632 * t47 + 0.15545350000000000000000000000000000000000000000000e-1 * t1211 * t1265 + 0.51817833333333333333333333333333333333333333333333e-2 * t622 * t310 * t1051 + 0.15545350000000000000000000000000000000000000000000e-1 * t1239 * t1159 + 0.51817833333333333333333333333333333333333333333333e-2 * t622 * t217 * t1105 + 0.19191790123456790123456790123456790123456790123457e-2 * t622 * t55 * t95 + 0.21269256817794009175388297367268855861069438054221e0 * t1223 * t1466 * t632 + 0.51817833333333333333333333333333333333333333333333e-2 * t1211 * t1240
  t1810 = 0.48451138557721871068801971605281074525246742497255e-3 * t538 * t1163 * t1165 * t35
  t1813 = 0.96902277115443742137603943210562149050493484994510e-3 * t1164 * t1372 * t35
  t1817 = 0.48451138557721871068801971605281074525246742497255e-3 * t1371 * t80 * t28 * t35
  t1821 = 0.32300759038481247379201314403520716350164494998170e-3 * t1371 * t40 * t47 * t56
  t1825 = t493 * t6 * t496
  t1827 = 0.67293247996835932040002738340668159062842697912856e-5 * t1270 * t18 * t1 * t1825
  t1830 = 0.32300759038481247379201314403520716350164494998170e-3 * t1164 * t1398 * t56
  t1832 = t2 * t1650
  t1837 = 0.13255248558342256726771310131293653497824588692887e0 * t543 * t1647 * t1832 * t548 * t1 * t31
  t1841 = 0.44184161861140855755904367104312178326081962309624e-2 * t1275 * t1452 * t1583 * t1277
  t1845 = 0.39018876828196680983935418000403106518546430566246e0 * t1283 * t1452 * t1583 * t1285
  t1852 = t1442 * t2
  t1871 = t51 * t1429
  t1876 = 0.16e2 / 0.3e1 * t45 * t1654 + 0.8e1 / 0.3e1 * t27 * t503 * t545 * t40 - 0.11e2 / 0.648e3 * t495 * t1852 * t19 - 0.36e2 * t521 * t1722 + 0.8e1 * t66 * t1730 + 0.11e2 / 0.54e2 * t1696 + t1700 / 0.6e1 - t1703 / 0.12e2 - 0.4e1 * t476 * t31 * t41 * t80 - t495 * t496 * t26 * t40 / 0.108e3 - 0.160e3 / 0.81e2 * t48 * t1871 + 0.140e3 / 0.81e2 * t59 * t1641
  t1915 = t1650 * t1 * t31
  t1924 = 0.185e3 / 0.864e3 * t1692 + 0.4e1 * t24 * t520 * t29 * t31 * t33 * t522 + 0.8e1 / 0.3e1 * t476 * t31 * t10 * t67 - 0.16e2 / 0.9e1 * t480 * t73 * t511 * t40 + 0.56e2 / 0.27e2 * t30 * t31 * t466 * t40 - 0.4e1 / 0.3e1 * t475 * t72 * t73 * t54 * t67 + 0.2e1 / 0.3e1 * t480 * t73 * t54 * t80 - 0.4e1 / 0.3e1 * t30 * t31 * t10 * t80 + 0.2e1 / 0.3e1 * t30 * t31 * t33 * t536 - 0.5e1 / 0.9e1 * t45 * t1648 * t1915 - t70 * t1738 + 0.24e2 * t63 * t1716 * t1718 + 0.6e1 * t66 * t1726
  t1928 = 0.96902277115443742137603943210562149050493484994510e-3 * (t1876 + t1924) * t83 * t18
  t1957 = -t495 * t496 * t613 * t616 / 0.108e3 - 0.160e3 / 0.81e2 * t1038 * t1871 + 0.140e3 / 0.81e2 * t638 * t1641 - 0.36e2 * t1095 * t1629 + 0.8e1 * t1045 * t1637 + 0.11e2 / 0.54e2 * t1603 + t1607 / 0.6e1 - t1610 / 0.12e2 - 0.4e1 * t1067 * t31 * t1034 * t1051 + 0.16e2 / 0.3e1 * t637 * t1654 - 0.11e2 / 0.648e3 * t495 * t1852 * t96 + 0.8e1 / 0.3e1 * t1032 * t503 * t545 * t616
  t2003 = 0.185e3 / 0.864e3 * t1599 + 0.24e2 * t108 * t1623 * t1625 + 0.6e1 * t1045 * t1633 - t641 * t1662 + 0.4e1 * t107 * t1094 * t29 * t31 * t33 * t1096 + 0.8e1 / 0.3e1 * t1067 * t31 * t10 * t1046 - 0.16e2 / 0.9e1 * t1071 * t73 * t511 * t616 + 0.56e2 / 0.27e2 * t1033 * t31 * t466 * t616 - 0.4e1 / 0.3e1 * t1066 * t72 * t73 * t54 * t1046 + 0.2e1 / 0.3e1 * t1071 * t73 * t54 * t1051 - 0.4e1 / 0.3e1 * t1033 * t31 * t10 * t1051 + 0.2e1 / 0.3e1 * t1033 * t31 * t33 * t1105 - 0.5e1 / 0.9e1 * t637 * t1648 * t1915
  t2008 = -0.34545222222222222222222222222222222222222222222222e-2 * t1239 * t1217 + 0.14985780636950745588843575970948674920373831100381e-2 * t1378 * t95 * t507 - t1810 - t1813 - t1817 - t1821 - t1827 - t1830 - t1837 - t1841 + t1845 - t1928 + 0.22478670955426118383265363956423012380560746650571e-2 * (t1957 + t2003) * t644 * t95
  t2017 = 0.29070683134633122641281182963168644715148045498353e-2 * t539 * t40
  t2019 = 0.29070683134633122641281182963168644715148045498353e-2 * t84 * t80
  t2021 = 0.96902277115443742137603943210562149050493484994510e-3 * t91 * t536
  t2023 = 0.64601518076962494758402628807041432700328989996340e-3 * t1373 * t60
  t2025 = 0.50245625170970829256535377961032225433589214441597e-3 * t1383 * t516
  t2027 = 0.64601518076962494758402628807041432700328989996340e-3 * t1166 * t60
  t2029 = 0.43067678717974996505601752538027621800219326664227e-3 * t1399 * t513
  t2038 = 0.67436012866278355149796091869269037141682239951713e-2 * t1108 * t616 + 0.67436012866278355149796091869269037141682239951713e-2 * t1054 * t1051 + 0.22478670955426118383265363956423012380560746650571e-2 * t645 * t1105 - t2017 - t2019 - t2021 + t2023 - t2025 + t2027 + t2029 + 0.45987582308743803622461183496797526186096082279398e-2 * t1352 * t1452 * t1583 * t1354 - 0.24016506845914321304132055739789982808387563524773e0 * t1360 * t1452 * t1583 * t1362
  t2086 = 0.30715972396278893812459343330735333491889005037766e1 * t1343 * t1452 * t1583 * t1347 + 0.11655607162072802124656114644071191604735201966963e-2 * t1380 * t516 + 0.13796274692623141086738355049039257855828824683819e0 * t627 * t1647 * t1832 * t632 * t1 * t31 + 0.12488150530792287990702979975790562433644859250317e-3 * t643 / t1329 / t107 * t95 * t49 * t1593 - 0.14985780636950745588843575970948674920373831100381e-2 * t1387 * t60 - 0.14985780636950745588843575970948674920373831100381e-2 * t1391 * t60 - 0.99905204246338303925623839806324499469158874002539e-3 * t1395 * t513 + 0.11239335477713059191632681978211506190280373325286e-2 * t1107 * t1377 * t1379 * t35 + 0.22478670955426118383265363956423012380560746650571e-2 * t1386 * t1390 * t35 + 0.11239335477713059191632681978211506190280373325286e-2 * t1378 * t1051 * t28 * t35 + 0.74928903184753727944217879854743374601869155501904e-3 * t1378 * t616 * t47 * t56 + 0.15610188163490359988378724969738203042056074062897e-4 * t1331 * t95 * t1 * t1825 + 0.74928903184753727944217879854743374601869155501904e-3 * t1386 * t1394 * t56
  t2094 = -t671 * t462 + 0.3e1 / 0.2e1 * t603 * t199 * t672 * t460 - t1418 * t462 + t1423 + t1426 - t1432 + t1435 - t1438 - t1440 - t1446 + t1455 - t1465 - (t1482 + t1538 + t1671 + t1761 + t1801 + t2008 + t2038 + t2086) * t1405 * t168 * t1410 / 0.24e2 - t1531 + t1534 - t1545 + t1550 + t1555 - t1560
  t2095 = t572 * t503
  t2099 = t571 ** 2
  t2101 = 0.1e1 / t2099 / t176
  t2102 = t2101 * t1
  t2103 = t2102 * t3
  t2104 = t576 ** 2
  t2105 = 0.1e1 / t2104
  t2111 = t71 - 0.59352777777777777777777777777777777777777777777778e-1 * t75 + 0.11870555555555555555555555555555555555555555555556e0 * t78
  t2112 = t217 * t2111
  t2116 = t4 * t11 * t171
  t2118 = t33 * t558
  t2123 = 0.1e1 / t557 / t170
  t2124 = t12 * t2123
  t2125 = t561 ** 2
  t2134 = (t2116 / 0.9e1 + t204 * t2118 * t561 / 0.6e1 + t204 * t2124 * t2125 / 0.2e1 - t204 * t559 * t2111 / 0.4e1) * t49 * t215
  t2135 = t217 * t561
  t2138 = t310 * t561
  t2142 = t181 * t558
  t2143 = t2142 * t29
  t2144 = t33 * t561
  t2148 = t582 * t47
  t2153 = t182 * t2123
  t2157 = t2116 / 0.72e2 + t2143 * t31 * t2144 / 0.3e1 - t2148 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t583 * t60 + 0.2e1 * t2153 * t2125 - t586 * t2111
  t2158 = t2157 * t589
  t2164 = t4 * t467 * t171
  t2166 = t10 * t558
  t2168 = t204 * t2166 * t561
  t2170 = t181 * t2123
  t2171 = t2170 * t29
  t2175 = t2142 * t72
  t2197 = t557 ** 2
  t2198 = 0.1e1 / t2197
  t2199 = t182 * t2198
  t2200 = t2125 * t561
  t2203 = t561 * t2111
  t2209 = -t528 - 0.35611666666666666666666666666666666666666666666667e0 * t507 + 0.23741111111111111111111111111111111111111111111111e0 * t531 - 0.27697962962962962962962962962962962962962962962964e0 * t534
  t2211 = -0.11e2 / 0.216e3 * t2164 - t2168 / 0.24e2 - t2171 * t31 * t33 * t2125 + t2175 * t73 * t54 * t561 / 0.3e1 - 0.2e1 / 0.3e1 * t2143 * t31 * t10 * t561 + t2143 * t31 * t33 * t2111 / 0.2e1 + t495 * t496 * t171 / 0.432e3 - 0.2e1 / 0.3e1 * t582 * t507 + 0.4e1 / 0.9e1 * t2148 * t513 - 0.14e2 / 0.27e2 * t583 * t516 - 0.6e1 * t2199 * t2200 + 0.6e1 * t2153 * t2203 - t586 * t2209
  t2212 = t2211 * t589
  t2216 = 0.1e1 / t182 / t181
  t2217 = t588 * t2216
  t2218 = t170 * t28
  t2219 = t2217 * t2218
  t2224 = t33 * t2123
  t2231 = t12 * t2198
  t2243 = (-0.7e1 / 0.27e2 * t2164 - t2168 / 0.3e1 - t204 * t2224 * t2125 / 0.2e1 + t204 * t2118 * t2111 / 0.4e1 - 0.3e1 / 0.2e1 * t204 * t2231 * t2200 + 0.3e1 / 0.2e1 * t204 * t2124 * t2203 - t204 * t559 * t2209 / 0.4e1) * t49 * t215
  t2246 = t182 ** 2
  t2247 = 0.1e1 / t2246
  t2248 = t588 * t2247
  t2249 = t2248 * t170
  t2252 = t571 * t176
  t2253 = 0.1e1 / t2252
  t2254 = t2253 * t1
  t2255 = t2254 * t3
  t2259 = 0.14420896359956903410707543094073145654541709205109e1 * t2095 * t545 * t577 + 0.19733478911420229683621075865799807258860149091757e2 * t2103 * t467 * t2105 + t567 * t2112 / 0.3e1 + 0.2e1 / 0.3e1 * t2134 * t2135 + 0.2e1 / 0.9e1 * t567 * t2138 + 0.43217420721796534043526431445752471432353784878540e-1 * t2158 * t561 + 0.21608710360898267021763215722876235716176892439270e-1 * t590 * t2111 + 0.21608710360898267021763215722876235716176892439270e-1 * t2212 * t170 - 0.48019356357551704492807146050836079369281983198377e-2 * t2219 * t60 + t2243 * t568 / 0.3e1 + 0.90036293170409445924013398845317648817403718496958e-3 * t2249 * t60 - 0.44063849988757204866050826120779056166655222571167e0 * t2255 * t467 * t577
  t2260 = 0.1e1 / t2099
  t2261 = t2260 * t49
  t2262 = t2261 * t50
  t2263 = t577 * t28
  t2268 = 0.1e1 / t2099 / t571
  t2269 = t2268 * t49
  t2270 = t2269 * t50
  t2271 = t2105 * t28
  t2275 = t2254 * t493
  t2276 = t2 * t577
  t2280 = t2102 * t493
  t2281 = t2 * t2105
  t2285 = t2099 ** 2
  t2286 = 0.1e1 / t2285
  t2287 = t2286 * t49
  t2288 = t2287 * t50
  t2290 = 0.1e1 / t2104 / t576
  t2291 = t2290 * t28
  t2295 = t310 * t170
  t2298 = t680 * t170
  t2301 = t2157 * t2216
  t2302 = t2301 * t2218
  t2305 = t561 * t28
  t2306 = t2217 * t2305
  t2309 = t170 * t47
  t2310 = t2217 * t2309
  t2318 = t572 * t47 * t49
  t2323 = 0.24034827266594839017845905156788576090902848675182e0 * t2262 * t512 * t2263 - 0.25115336796353019597335914738290663784003826116781e2 * t2270 * t512 * t2271 + 0.20029022722162365848204920963990480075752373895984e-1 * t2275 * t467 * t2276 - 0.89697631415546498561913981208180942085727950417076e0 * t2280 * t467 * t2281 + 0.64272053155397178166610502978456596616246611440970e3 * t2288 * t512 * t2291 + 0.2e1 / 0.9e1 * t2134 * t2295 - 0.2e1 / 0.27e2 * t567 * t2298 + 0.72029034536327556739210719076254119053922974797566e-2 * t2302 * t35 + 0.72029034536327556739210719076254119053922974797566e-2 * t2306 * t35 + 0.24009678178775852246403573025418039684640991599189e-2 * t2310 * t56 + 0.11216252724410924874994755739834668842421329381751e1 * t574 * t31 * t466 * t577 - 0.96139309066379356071383620627154304363611394700724e0 * t2318 * t73 * t511 * t577
  t2324 = t2259 + t2323
  t2357 = t2134 * t568 / 0.3e1 + t567 * t2295 / 0.9e1 + t567 * t2135 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t2255 * t11 * t577 + 0.24034827266594839017845905156788576090902848675181e0 * t2318 * t73 * t54 * t577 - 0.48069654533189678035691810313577152181805697350363e0 * t574 * t31 * t10 * t577 - 0.53818578849327899137148388724908565251436770250246e1 * t2103 * t11 * t2105 + 0.21608710360898267021763215722876235716176892439270e-1 * t2158 * t170 + 0.36014517268163778369605359538127059526961487398783e-2 * t2219 * t35 + 0.21608710360898267021763215722876235716176892439270e-1 * t590 * t561
  t2358 = t168 * t2357
  t2359 = t553 * t2358
  t2368 = t1022 * t187
  t2375 = t604 ** 2
  t2433 = 0.51817833333333333333333333333333333333333333333333e-2 * t1239 * t623 + 0.17272611111111111111111111111111111111111111111111e-2 * t622 * t1240 + 0.51817833333333333333333333333333333333333333333333e-2 * t622 * t1265 + 0.13796274692623141086738355049039257855828824683819e-1 * t1223 * t11 * t632 + 0.27592549385246282173476710098078515711657649367639e-1 * t1310 * t73 * t54 * t632 - 0.55185098770492564346953420196157031423315298735277e-1 * t629 * t31 * t10 * t632 - 0.30878365944746984533884071665444263610784010246137e0 * t1149 * t11 * t1151 + 0.22478670955426118383265363956423012380560746650571e-2 * t1054 * t95 + 0.37464451592376863972108939927371687300934577750952e-3 * t1380 * t35 + 0.22478670955426118383265363956423012380560746650571e-2 * t645 * t616 - 0.10363566666666666666666666666666666666666666666667e-1 * t1184 * t658 - 0.34545222222222222222222222222222222222222222222223e-2 * t657 * t1214 - 0.10363566666666666666666666666666666666666666666667e-1 * t657 * t1185 - 0.13255248558342256726771310131293653497824588692887e-1 * t1246 * t11 * t548 - 0.26510497116684513453542620262587306995649177385775e-1 * t1320 * t73 * t54 * t548 + 0.53020994233369026907085240525174613991298354771549e-1 * t662 * t31 * t10 * t548 + 0.50167127350538589836488394571946851238131125013746e0 * t1254 * t11 * t1256 - 0.96902277115443742137603943210562149050493484994510e-3 * t84 * t18 - 0.16150379519240623689600657201760358175082247499085e-3 * t1383 * t35 - 0.96902277115443742137603943210562149050493484994510e-3 * t91 * t40
  t2434 = t2433 * t552
  t2435 = t2434 * t187
  t2438 = t1566 - t1574 + t1578 + t553 * t168 * t2324 * t1024 / 0.6e1 + t602 * t594 * t607 + t2359 * t597 / 0.4e1 + t1022 * t2358 * t1024 / 0.2e1 + t669 * t601 * t187 * t607 + t2368 * t1019 / 0.6e1 + t1586 + t1595 - t125 / t600 / t162 * t187 * t199 * t200 * t2375 + t1679 + t1682 + t1684 + t1687 - t1690 + t1023 * t597 / 0.2e1 + t2435 * t597 / 0.4e1
  t2448 = t593 * t194 * t1409
  t2452 = t2433 * t1405 * t168
  t2454 = t2357 * t194 * t1409
  t2458 = t125 * t1405 * t168
  t2504 = t4 * t1466 * t171
  t2506 = t2111 ** 2
  t2510 = 0.1e1 / t2197 / t170
  t2512 = t2125 ** 2
  t2519 = t1642 - 0.29676388888888888888888888888888888888888888888889e0 * t1652 + 0.28489333333333333333333333333333333333333333333334e1 * t1654 - 0.10551604938271604938271604938271604938271604938272e1 * t1657 + 0.92326543209876543209876543209876543209876543209880e0 * t1660
  t2527 = t204 * t466 * t558 * t561
  t2531 = t204 * t10 * t2123 * t2125
  t2534 = t204 * t2166 * t2111
  t2547 = 0.16e2 / 0.3e1 * t582 * t1654 + 0.185e3 / 0.864e3 * t2504 + 0.6e1 * t2153 * t2506 + 0.24e2 * t182 * t2510 * t2512 - t586 * t2519 - 0.4e1 * t2171 * t31 * t2144 * t2111 + 0.11e2 / 0.54e2 * t2527 + t2531 / 0.6e1 - t2534 / 0.12e2 + 0.8e1 / 0.3e1 * t2142 * t503 * t545 * t561 - 0.11e2 / 0.648e3 * t495 * t1852 * t171 - 0.4e1 / 0.3e1 * t2143 * t31 * t10 * t2111
  t2590 = t561 * t2209
  t2593 = t2125 * t2111
  t2596 = 0.2e1 / 0.3e1 * t2143 * t31 * t33 * t2209 - 0.5e1 / 0.9e1 * t582 * t1648 * t1915 + 0.56e2 / 0.27e2 * t2143 * t31 * t466 * t561 + 0.4e1 * t181 * t2198 * t29 * t31 * t33 * t2200 + 0.8e1 / 0.3e1 * t2171 * t31 * t10 * t2125 - 0.16e2 / 0.9e1 * t2175 * t73 * t511 * t561 - 0.4e1 / 0.3e1 * t2170 * t72 * t73 * t54 * t2125 + 0.2e1 / 0.3e1 * t2175 * t73 * t54 * t2111 + 0.140e3 / 0.81e2 * t583 * t1641 - t495 * t496 * t558 * t561 / 0.108e3 - 0.160e3 / 0.81e2 * t2148 * t1871 + 0.8e1 * t2153 * t2590 - 0.36e2 * t2199 * t2593
  t2605 = 0.27010887951122833777204019653595294645221115549088e-2 * t2157 * t2247 * t170 * t60 + 0.27010887951122833777204019653595294645221115549088e-2 * t2248 * t561 * t60 - 0.17625539995502881946420330448311622466662089028467e1 * t2262 * t1429 * t2263 + 0.16023218177729892678563936771192384060601899116788e0 * t2101 * t2 * t1428 * t577 * t49 * t1452 - 0.28703242052974879539812473986617901467432944133464e2 / t2099 / t2252 * t2 * t1428 * t2105 * t49 * t1452 - 0.11536717087965522728566034475258516523633367364087e2 * t2095 * t1542 * t577 + 0.48069654533189678035691810313577152181805697350364e0 * t2260 * t2 * t1541 * t577 * t47 - 0.50230673592706039194671829476581327568007652233562e2 * t2268 * t2 * t1541 * t2105 * t47 + 0.12854410631079435633322100595691319323249322288194e4 * t2286 * t2 * t1541 * t2290 * t47 + 0.21608710360898267021763215722876235716176892439270e-1 * (t2547 + t2596) * t589 * t170 + 0.64826131082694801065289647168628707148530677317810e-1 * t2212 * t561 + 0.64826131082694801065289647168628707148530677317810e-1 * t2158 * t2111
  t2661 = 0.70e2 / 0.81e2 * t2504 + 0.28e2 / 0.27e2 * t2527 + 0.4e1 / 0.3e1 * t2531 - 0.2e1 / 0.3e1 * t2534 + 0.2e1 * t204 * t33 * t2198 * t2200 - 0.2e1 * t204 * t2224 * t2203 + t204 * t2118 * t2209 / 0.3e1 + 0.6e1 * t204 * t12 * t2510 * t2512 - 0.9e1 * t204 * t2231 * t2593 + 0.3e1 / 0.2e1 * t204 * t2124 * t2506 + 0.2e1 * t204 * t2124 * t2590 - t204 * t559 * t2519 / 0.4e1
  t2672 = 0.21608710360898267021763215722876235716176892439270e-1 * t590 * t2209 + 0.2e1 / 0.3e1 * t2134 * t2138 + t567 * t310 * t2111 / 0.3e1 + t2134 * t2112 + t567 * t217 * t2209 / 0.3e1 + 0.14405806907265511347842143815250823810784594959513e-1 * t2217 * t170 * t507 - 0.2e1 / 0.9e1 * t567 * t680 * t561 + 0.18526846018000188409589551891691194070070945853786e1 * t2253 * t1442 * t577 * t204 - 0.82970309059380511169770432617567371429298354135795e2 * t2101 * t1442 * t2105 * t204 + t2661 * t49 * t215 * t568 / 0.3e1 + t2243 * t2135 + 0.10e2 / 0.81e2 * t567 * t55 * t170 + t2243 * t2295 / 0.3e1
  t2707 = t2104 ** 2
  t2725 = -0.2e1 / 0.9e1 * t2134 * t2298 + 0.10712008859232863027768417163076099436041101906828e3 * t2287 * t1452 * t1583 * t2291 + 0.12004839089387926123201786512709019842320495799594e-2 * t588 / t2246 / t181 * t170 * t49 * t1593 + 0.11204516483428731048321667411861751852832462746288e-1 * t2219 * t516 + 0.10804355180449133510881607861438117858088446219635e-1 * t2211 * t2216 * t2218 * t35 - 0.14405806907265511347842143815250823810784594959513e-1 * t2302 * t60 + 0.16068013288849294541652625744614149154061652860242e4 / t2285 / t176 * t2 * t1428 * t2290 * t49 * t1452 - 0.28783485915536592493215570496151025048490758133637e5 / t2285 / t2252 * t2 * t1428 / t2707 * t49 * t1452 - 0.33013307495816796838804912909949804566381363448884e-2 * t2249 * t516 + 0.18417913650658881038046337474746486774936139152306e3 * t2270 * t1429 * t2271 - 0.47132838980624597322181035517534837518580848390044e4 * t2288 * t1429 * t2291 - 0.37387509081369749583315852466115562808071097939170e1 * t574 * t31 * t1442 * t577
  t2772 = -0.14687949996252401622016942040259685388885074190388e0 * t2275 * t1466 * t2276 + 0.65778263038067432278736919552666024196200496972522e1 * t2280 * t1466 * t2281 + 0.42728581807279713809503831389846357494938397644766e1 * t2318 * t73 * t1428 * t577 - 0.14405806907265511347842143815250823810784594959513e-1 * t2306 * t60 - 0.96038712715103408985614292101672158738563966396755e-2 * t2310 * t513 + 0.21608710360898267021763215722876235716176892439270e-1 * t2301 * t2305 * t35 + 0.10804355180449133510881607861438117858088446219635e-1 * t2217 * t2111 * t28 * t35 + 0.12017413633297419508922952578394288045451424337591e1 * t572 * t1647 * t1832 * t577 * t1 * t31 + 0.72029034536327556739210719076254119053922974797566e-2 * t2301 * t2309 * t56 + 0.72029034536327556739210719076254119053922974797566e-2 * t2217 * t561 * t47 * t56 + 0.15006048861734907654002233140886274802900619749493e-3 * t2248 * t170 * t1 * t1825 + 0.40058045444324731696409841927980960151504747791968e-1 * t2261 * t1452 * t1583 * t2263 - 0.41858894660588365995559857897151106306673043527969e1 * t2269 * t1452 * t1583 * t2271
  t2782 = t2434 * t594 * t1024 / 0.2e1 + t1746 + t1749 + t1751 + t1754 + t1757 - t1760 + t1765 - t1767 - t188 * t199 * t283 * t1017 / 0.3e1 - t1407 * t2448 / 0.6e1 - t2452 * t2454 / 0.4e1 - t2458 * (t2605 + t2672 + t2725 + t2772) * t194 * t1409 / 0.24e2 - t166 * t2358 * t673 / 0.2e1 + t1810 + t1813 + t1817 + t1821 + t1827
  t2795 = t460 ** 2
  t2836 = t426 ** 2
  t2849 = -0.34545222222222222222222222222222222222222222222222e-2 * t216 * t680 * t209 - 0.12531900803964862107292131079638331300646466893855e1 * t224 * t31 * t1442 * t227 - 0.40750569555564537156454955026157312372117447673715e-3 * t897 * t516 - 0.55392172096869228372480688864674045862037218664772e-3 * t447 * t838 * t145 * t60 - 0.55392172096869228372480688864674045862037218664772e-3 * t839 * t250 * t60 + 0.67701543673951279121920841945712722720267711701388e-3 * t840 * t516 - 0.49232467444147672564361943527150587252539691368716e-1 * t730 * t1466 * t731 + 0.67588615201490658906886336824632550696029133627253e-1 * t735 * t1466 * t736 - 0.13870166225145555008648464751851466246923192497891e-5 / t884 / t152 * t2 * t1428 * t889 * t49 * t1452 + 0.11184902043957375558974121975893022381518862430300e-8 / t884 / t404 * t2 * t1428 / t2836 * t49 * t1452 + 0.33341375090916439491644963203219619213550639005767e-3 * t360 * t895 * t127 * t60 + 0.33341375090916439491644963203219619213550639005767e-3 * t896 * t209 * t60
  t2912 = t339 ** 2
  t2918 = 0.75079831819944956762139546460836191773429192194982e0 * t845 * t1429 * t846 - 0.14846205821514491791846440584003337647925693349601e1 * t743 * t1429 * t746 - 0.35317552888102107660910442655177344610221092008520e-2 * t869 * t1429 * t870 + 0.40685820927093628025368829938764300990974697993815e-5 * t887 * t1429 * t890 + 0.53708146302706551888394847484164277002770572402236e-1 * t336 * t2 * t1428 * t227 * t49 * t1452 - 0.29493213906105014795732219705294203940085440128257e0 / t334 / t317 * t2 * t1428 * t340 * t49 * t1452 - 0.68254392563586324329217769509851083430390174722713e-1 * t423 * t2 * t1428 * t266 * t49 * t1452 + 0.55040342163276011939081209332743913678266636896394e-3 / t421 / t404 * t2 * t1428 * t427 * t49 * t1452 - 0.18201171350289686487791405202626955581437379926057e1 * t412 * t73 * t1428 * t266 + 0.62566526516620797301782955384030159811190993495820e-1 * t874 * t1466 * t875 - 0.12613411745750752736039443805420480217936104288757e-3 * t879 * t1466 * t880 + 0.50612065300617585654021956536375014708837590964548e0 / t740 / t134 * t2 * t1428 * t745 * t49 * t1452 - 0.27793036455358846894255932804679737051689835140790e0 / t740 / t317 * t2 * t1428 / t2912 * t49 * t1452
  t2953 = -0.59078960932977207077234332232580704703047629642460e0 * t903 * t1429 * t904 + 0.18924812256417384493928174310897114194888157415632e1 * t911 * t1429 * t912 + 0.15926024931503475676817479552298586133757707435299e1 * t263 * t31 * t1442 * t266 + 0.14322172347388413836905292662443807200738819307263e1 * t325 * t73 * t1428 * t227 + 0.15545350000000000000000000000000000000000000000000e-1 * t306 * t727 + 0.69090444444444444444444444444444444444444444444446e-2 * t256 * t680 * t250 - 0.10363566666666666666666666666666666666666666666667e-1 * t721 * t398 - 0.10363566666666666666666666666666666666666666666667e-1 * t256 * t310 * t389 - 0.31090700000000000000000000000000000000000000000001e-1 * t395 * t801 - 0.10363566666666666666666666666666666666666666666667e-1 * t256 * t217 * t715 + 0.10363566666666666666666666666666666666666666666667e-1 * t306 * t926 + 0.51817833333333333333333333333333333333333333333333e-2 * t793 * t311
  t2993 = -0.34545222222222222222222222222222222222222222222222e-2 * t306 * t681 - 0.38383580246913580246913580246913580246913580246915e-2 * t256 * t55 * t145 + 0.62100044162504450620956542403564945284453474340086e0 * t320 * t1466 * t227 + 0.15545350000000000000000000000000000000000000000000e-1 * t793 * t314 - 0.31090700000000000000000000000000000000000000000001e-1 * t721 * t401 + 0.69090444444444444444444444444444444444444444444446e-2 * t395 * t752 + 0.19191790123456790123456790123456790123456790123457e-2 * t216 * t55 * t127 + 0.15910098906571972201140662072746287547623949727864e-2 * t425 * t1466 * t427 + 0.51817833333333333333333333333333333333333333333333e-2 * t216 * t217 * t787 + 0.49143162645782153517036794047092780069880925800353e1 * t916 * t1542 * t266 - 0.38669865337948717359644290188598279441994812129610e1 * t920 * t1542 * t227 + 0.40489652240494068523217565229100011767070072771638e0 * t741 * t2 * t1541 * t745 * t47 - 0.51613124335683775892531384484264856895149520224450e0 * t909 * t2 * t1541 * t340 * t47
  t3017 = t4 * t1466 * t128
  t3021 = t204 * t466 * t206 * t209
  t3025 = t204 * t10 * t292 * t294
  t3028 = t204 * t762 * t300
  t3041 = 0.1e1 / t773 / t127
  t3043 = t294 ** 2
  t3047 = t294 * t300
  t3051 = t300 ** 2
  t3055 = t209 * t787
  t3063 = t1642 - 0.55897500000000000000000000000000000000000000000000e1 * t1652 + 0.53661600000000000000000000000000000000000000000000e2 * t1654 - 0.19874666666666666666666666666666666666666666666667e2 * t1657 + 0.17390333333333333333333333333333333333333333333333e2 * t1660
  t3067 = 0.70e2 / 0.81e2 * t3017 + 0.28e2 / 0.27e2 * t3021 + 0.4e1 / 0.3e1 * t3025 - 0.2e1 / 0.3e1 * t3028 + 0.2e1 * t204 * t33 * t774 * t776 - 0.2e1 * t204 * t766 * t780 + t204 * t287 * t787 / 0.3e1 + 0.6e1 * t204 * t12 * t3041 * t3043 - 0.9e1 * t204 * t775 * t3047 + 0.3e1 / 0.2e1 * t204 * t293 * t3051 + 0.2e1 * t204 * t293 * t3055 - t204 * t207 * t3063 / 0.4e1
  t3090 = t4 * t1466 * t146
  t3094 = t204 * t466 * t247 * t250
  t3098 = t204 * t10 * t381 * t383
  t3101 = t204 * t690 * t389
  t3114 = 0.1e1 / t701 / t145
  t3116 = t383 ** 2
  t3120 = t383 * t389
  t3124 = t389 ** 2
  t3128 = t250 * t715
  t3136 = t1642 - 0.36311111111111111111111111111111111111111111111110e1 * t1652 + 0.34858666666666666666666666666666666666666666666666e2 * t1654 - 0.12910617283950617283950617283950617283950617283950e2 * t1657 + 0.11296790123456790123456790123456790123456790123456e2 * t1660
  t3140 = 0.70e2 / 0.81e2 * t3090 + 0.28e2 / 0.27e2 * t3094 + 0.4e1 / 0.3e1 * t3098 - 0.2e1 / 0.3e1 * t3101 + 0.2e1 * t204 * t33 * t702 * t704 - 0.2e1 * t204 * t694 * t708 + t204 * t376 * t715 / 0.3e1 + 0.6e1 * t204 * t12 * t3114 * t3116 - 0.9e1 * t204 * t703 * t3120 + 0.3e1 / 0.2e1 * t204 * t382 * t3124 + 0.2e1 * t204 * t382 * t3128 - t204 * t248 * t3136 / 0.4e1
  t3145 = 0.16112443890811965566518454245249283100831171720671e0 * t901 * t2 * t1541 * t227 * t47 - 0.11096132980116444006918771801481172997538553998313e-5 * t885 * t2 * t1541 * t889 * t47 + 0.96320598785733020893392116332301848936966614568690e-3 * t867 * t2 * t1541 * t427 * t47 - 0.20476317769075897298765330852955325029117052416814e0 * t843 * t2 * t1541 * t266 * t47 + 0.51817833333333333333333333333333333333333333333333e-2 * t3067 * t49 * t215 * t218 - 0.78919141401646687505658045995765315216388639523133e0 * t407 * t1466 * t266 + 0.51817833333333333333333333333333333333333333333333e-2 * t216 * t310 * t300 - 0.29542491784996921798656367394492824459753183287879e-2 * t453 * t145 * t507 - 0.20727133333333333333333333333333333333333333333334e-1 * t395 * t798 - 0.85253821447334808393913447585616058264309475370748e0 * t338 * t1466 * t340 + 0.17782066715155434395543980375050463580560340803076e-2 * t366 * t127 * t507 - 0.10363566666666666666666666666666666666666666666667e-1 * t3140 * t49 * t215 * t257
  t3173 = 0.8e1 / 0.3e1 * t345 * t503 * t545 * t209 - t495 * t496 * t206 * t209 / 0.108e3 - 0.160e3 / 0.81e2 * t351 * t1871 + 0.140e3 / 0.81e2 * t233 * t1641 - 0.4e1 * t936 * t31 * t347 * t300 + 0.16e2 / 0.3e1 * t232 * t1654 - 0.11e2 / 0.648e3 * t495 * t1852 * t128 + 0.11e2 / 0.54e2 * t3021 + t3025 / 0.6e1 - t3028 / 0.12e2 + 0.185e3 / 0.864e3 * t3017 - 0.36e2 * t962 * t3047
  t3220 = 0.8e1 * t356 * t3055 - t236 * t3063 + 0.24e2 * t140 * t3041 * t3043 + 0.6e1 * t356 * t3051 + 0.4e1 * t139 * t774 * t29 * t31 * t33 * t776 + 0.8e1 / 0.3e1 * t936 * t31 * t10 * t294 - 0.16e2 / 0.9e1 * t940 * t73 * t511 * t209 + 0.56e2 / 0.27e2 * t346 * t31 * t466 * t209 - 0.4e1 / 0.3e1 * t935 * t72 * t73 * t54 * t294 + 0.2e1 / 0.3e1 * t940 * t73 * t54 * t300 - 0.4e1 / 0.3e1 * t346 * t31 * t10 * t300 + 0.2e1 / 0.3e1 * t346 * t31 * t33 * t787 - 0.5e1 / 0.9e1 * t232 * t1648 * t1915
  t3264 = 0.11e2 / 0.54e2 * t3094 + t3098 / 0.6e1 - t3101 / 0.12e2 - t495 * t496 * t247 * t250 / 0.108e3 + 0.140e3 / 0.81e2 * t272 * t1641 - 0.160e3 / 0.81e2 * t438 * t1871 + 0.8e1 / 0.3e1 * t432 * t503 * t545 * t250 - 0.11e2 / 0.648e3 * t495 * t1852 * t146 + 0.8e1 * t443 * t3128 - 0.36e2 * t1005 * t3120 - 0.4e1 * t979 * t31 * t434 * t389 + 0.185e3 / 0.864e3 * t3090
  t3311 = 0.16e2 / 0.3e1 * t271 * t1654 - t275 * t3136 + 0.24e2 * t158 * t3114 * t3116 + 0.6e1 * t443 * t3124 - 0.5e1 / 0.9e1 * t271 * t1648 * t1915 - 0.16e2 / 0.9e1 * t983 * t73 * t511 * t250 + 0.56e2 / 0.27e2 * t433 * t31 * t466 * t250 + 0.4e1 * t157 * t702 * t29 * t31 * t33 * t704 + 0.8e1 / 0.3e1 * t979 * t31 * t10 * t383 - 0.4e1 / 0.3e1 * t978 * t72 * t73 * t54 * t383 + 0.2e1 / 0.3e1 * t983 * t73 * t54 * t389 - 0.4e1 / 0.3e1 * t433 * t31 * t10 * t389 + 0.2e1 / 0.3e1 * t433 * t31 * t33 * t715
  t3335 = 0.26673100072733151593315970562575695370840511204614e-2 * (t3173 + t3220) * t239 * t127 + 0.80019300218199454779947911687727086112521533613842e-2 * t361 * t300 + 0.26673100072733151593315970562575695370840511204614e-2 * t240 * t787 + 0.80019300218199454779947911687727086112521533613842e-2 * t969 * t209 - 0.13294121303248614809395365327521771006888932479545e-1 * t448 * t389 - 0.44313737677495382697984551091739236689629774931818e-2 * t279 * t715 - 0.13294121303248614809395365327521771006888932479545e-1 * t1012 * t250 - 0.44313737677495382697984551091739236689629774931818e-2 * (t3264 + t3311) * t278 * t145 + 0.13336550036366575796657985281287847685420255602307e-2 * t968 * t365 * t367 * t35 + 0.14818388929296195329619983645875386317133617335896e-3 * t238 / t894 / t139 * t127 * t49 * t1593 + 0.29542491784996921798656367394492824459753183287878e-2 * t810 * t60 - 0.22977493610553161398954952417938863468696920335017e-2 * t455 * t516 - 0.22156868838747691348992275545869618344814887465909e-2 * t453 * t389 * t28 * t35
  t3373 = -0.14771245892498460899328183697246412229876591643939e-2 * t453 * t250 * t47 * t56 - 0.30773428942705126873600382702596692145576232591541e-4 * t839 * t145 * t1 * t1825 + 0.29542491784996921798656367394492824459753183287878e-2 * t814 * t60 + 0.19694994523331281199104244929661882973168788858586e-2 * t818 * t513 - 0.22156868838747691348992275545869618344814887465909e-2 * t1011 * t452 * t454 * t35 + 0.13830496334009782307645318069483693895991376180170e-2 * t368 * t516 - 0.17782066715155434395543980375050463580560340803076e-2 * t826 * t60 - 0.11854711143436956263695986916700309053706893868717e-2 * t830 * t513 - 0.17782066715155434395543980375050463580560340803076e-2 * t822 * t60 - 0.17063598140896581082304442377462770857597543680678e-1 * t844 * t1452 * t1583 * t846 + 0.80267165654777517411160096943584874114138845473912e-4 * t868 * t1452 * t1583 * t870 - 0.92467774834303700057656431679009774979487949985947e-7 * t886 * t1452 * t1583 * t890
  t3429 = -0.44313737677495382697984551091739236689629774931817e-2 * t809 * t813 * t35 - 0.14771245892498460899328183697246412229876591643939e-2 * t809 * t817 * t56 - 0.51190794422689743246913327132388312572792631042035e0 * t261 * t1647 * t1832 * t266 * t1 * t31 + 0.40281109727029913916296135613123207752077929301677e0 * t222 * t1647 * t1832 * t227 * t1 * t31 - 0.24618743154164101498880306162077353716460986073232e-3 * t277 / t837 / t157 * t145 * t49 * t1593 + 0.13336550036366575796657985281287847685420255602307e-2 * t366 * t300 * t28 * t35 + 0.88910333575777171977719901875252317902801704015380e-3 * t366 * t209 * t47 * t56 + 0.18522986161620244162024979557344232896417021669871e-4 * t896 * t127 * t1 * t1825 + 0.26673100072733151593315970562575695370840511204614e-2 * t821 * t825 * t35 + 0.88910333575777171977719901875252317902801704015380e-3 * t821 * t829 * t56 + 0.13427036575676637972098711871041069250692643100559e-1 * t902 * t1452 * t1583 * t904 - 0.43010936946403146577109487070220714079291266853706e-1 * t910 * t1452 * t1583 * t912 + 0.33741376867078390436014637690916676472558393976364e-1 * t742 * t1452 * t1583 * t746
  t3438 = t669 * t1405 * t168
  t3440 = t2324 * t194 * t1409
  t3443 = t1830 + t1837 + t1841 - t1845 - t2433 * t165 * t187 * t673 / 0.2e1 + t1928 + t2017 + t2019 + t2021 + t1404 * t552 * t187 * t1024 / 0.6e1 - t670 * t594 * t673 - t2023 + t2025 - t2027 - t2029 + t595 * t1019 / 0.6e1 - t188 * t199 * t200 * t2795 / 0.4e1 + t675 * t199 * t200 * (t2849 + t2918 + t2953 + t2993 + t3145 + t3335 + t3373 + t3429) / 0.24e2 - t3438 * t3440 / 0.6e1
  t3455 = 0.77521821692354993710083154568449719240394787995608e-2 * t85 + 0.38760910846177496855041577284224859620197393997804e-2 * t92 - t188 * t462 + 0.38760910846177496855041577284224859620197393997804e-2 * t540 + 0.63625193080042832288502288630209536789558025725859e0 * t550 + t595 * t597 / 0.2e1 + t603 * t607 - t671 * t673 + t675 * t1019 / 0.6e1 + t1023 * t1024 - t1407 * t1410 / 0.6e1 + r0 * (t2094 + t2438 + t2782 + t3443) - 0.92120592592592592592592592592592592592592592592596e-2 * t1117 + 0.41454266666666666666666666666666666666666666666668e-1 * t1143 + 0.12920303615392498951680525761408286540065797999268e-2 * t1167 + t2435 * t1024 / 0.2e1 - t1418 * t673 + 0.27636177777777777777777777777777777777777777777779e-1 * t1170 + 0.82908533333333333333333333333333333333333333333336e-1 * t1186
  t3481 = 0.27636177777777777777777777777777777777777777777779e-1 * t1215 - 0.19441031218901976532597921525897358463476063416235e0 * t1248 + 0.73578453447456598426849645372188715149258983353495e1 * t1258 + 0.41454266666666666666666666666666666666666666666668e-1 * t1261 + t2368 * t597 / 0.2e1 + t2359 * t1024 / 0.2e1 + 0.16150379519240623689600657201760358175082247499085e-3 * t1272 + 0.10604198846673805381417048105034922798259670954310e0 * t1279 - 0.93645304387672034361445003200967455644511433358993e1 * t1287 + 0.88368323722281711511808734208624356652163924619249e-2 * t1292 - 0.33444751567025726557658929714631234158754083342496e0 * t1297 + 0.20252531409700720680098755300074483620546362055085e3 * t1307 - 0.42416795386695221525668192420139691193038683817240e0 * t1323 + 0.49486261284477758446612891156829639725211797786780e0 * t1327 - t2458 * t3440 / 0.6e1 + 0.12920303615392498951680525761408286540065797999268e-2 * t1374 - 0.86135357435949993011203505076055243600438653328453e-3 * t1384 + 0.43067678717974996505601752538027621800219326664227e-3 * t1400 - t3438 * t2454 / 0.2e1 - t2452 * t2448 / 0.2e1
  v4rho4_0_ = t3455 + t3481

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = 3 ** (0.1e1 / 0.3e1)
  t4 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = t2 * t4
  t6 = 4 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** 2
  t9 = t1 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t12 = t7 * t11
  t13 = 0.1e1 / t9
  t14 = t7 * t13
  t15 = t5 * t14
  t16 = t15 / 0.4e1
  t17 = jnp.sqrt(t15)
  t19 = t16 + 0.35302100000000000000000000000000000000000000000000e1 * t17 + 0.180578e2
  t20 = 0.1e1 / t19
  t22 = t5 * t12 * t20
  t24 = t5 * t7
  t26 = 0.1e1 / t9 / t1
  t27 = t19 ** 2
  t28 = 0.1e1 / t27
  t30 = t7 * t26
  t31 = t5 * t30
  t32 = t31 / 0.12e2
  t33 = 0.1e1 / t17
  t34 = t33 * t2
  t35 = t4 * t7
  t37 = t34 * t35 * t26
  t39 = -t32 - 0.58836833333333333333333333333333333333333333333333e0 * t37
  t44 = 0.1e1 / t27 / t19
  t46 = t39 ** 2
  t50 = t13 * t28
  t51 = t5 * t12
  t52 = t51 / 0.9e1
  t54 = 0.1e1 / t17 / t15
  t55 = t2 ** 2
  t57 = t4 ** 2
  t58 = t57 * t6
  t59 = t9 ** 2
  t61 = 0.1e1 / t59 / t8
  t63 = t54 * t55 * t58 * t61
  t66 = t34 * t35 * t11
  t68 = t52 - 0.39224555555555555555555555555555555555555555555555e0 * t63 + 0.78449111111111111111111111111111111111111111111110e0 * t66
  t74 = 0.1e1 / t4
  t76 = t6 * t9
  t77 = t76 * t19
  t88 = (-t5 * t30 * t20 / 0.12e2 - t24 * t50 * t39 / 0.4e1) * t55 * t74
  t90 = t6 / t59
  t97 = t17 + 0.706042e1
  t98 = t97 ** 2
  t103 = 0.1e1 / t98
  t105 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t103
  t106 = 0.1e1 / t105
  t117 = t103 * t33 * t2
  t122 = t98 ** 2
  t127 = t105 ** 2
  t133 = t17 / 0.2e1
  t134 = t133 + 0.32500e0
  t141 = t134 * t20
  t145 = t55 * t57 * t6 * t61
  t148 = t141 * t33
  t151 = t134 ** 2
  t155 = t151 * t28
  t158 = 0.1e1 / t151
  t165 = -t148 * t31 / 0.6e1 - t155 * t39
  t173 = t165 * t158
  t177 = t16 + 0.18637200000000000000000000000000000000000000000000e1 * t17 + 0.129352e2
  t178 = 0.1e1 / t177
  t180 = t5 * t12 * t178
  t182 = t177 ** 2
  t183 = 0.1e1 / t182
  t186 = -t32 - 0.31062000000000000000000000000000000000000000000000e0 * t37
  t191 = 0.1e1 / t182 / t177
  t193 = t186 ** 2
  t197 = t13 * t183
  t200 = t52 - 0.20708000000000000000000000000000000000000000000000e0 * t63 + 0.41416000000000000000000000000000000000000000000000e0 * t66
  t207 = t76 * t177
  t209 = 0.10363566666666666666666666666666666666666666666667e-1 * (t180 / 0.9e1 + t24 * t26 * t183 * t186 / 0.6e1 + t24 * t13 * t191 * t193 / 0.2e1 - t24 * t197 * t200 / 0.4e1) * t55 * t74 * t207
  t218 = (-t5 * t30 * t178 / 0.12e2 - t24 * t197 * t186 / 0.4e1) * t55 * t74
  t221 = 0.34545222222222222222222222222222222222222222222223e-2 * t218 * t90 * t177
  t224 = 0.10363566666666666666666666666666666666666666666667e-1 * t218 * t76 * t186
  t225 = t17 + 0.372744e1
  t226 = t225 ** 2
  t231 = 0.1e1 / t226
  t233 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t231
  t234 = 0.1e1 / t233
  t237 = 0.13255248558342256726771310131293653497824588692887e-1 / t226 / t225 * t2 * t4 * t12 * t234
  t243 = 0.26510497116684513453542620262587306995649177385775e-1 * t231 * t54 * t55 * t58 * t61 * t234
  t245 = t231 * t33 * t2
  t249 = 0.53020994233369026907085240525174613991298354771549e-1 * t245 * t35 * t11 * t234
  t250 = t226 ** 2
  t255 = t233 ** 2
  t259 = 0.50167127350538589836488394571946851238131125013746e0 / t250 / t225 * t2 * t4 * t12 / t255
  t261 = t133 + 0.10498e0
  t268 = t261 * t178
  t272 = t268 * t33
  t275 = t261 ** 2
  t279 = t275 * t183
  t282 = 0.1e1 / t275
  t285 = 0.96902277115443742137603943210562149050493484994510e-3 * (t180 / 0.72e2 + t261 * t183 * t34 * t35 * t26 * t186 / 0.3e1 - t268 * t54 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t272 * t51 + 0.2e1 * t275 * t191 * t193 - t279 * t200) * t282 * t177
  t289 = -t272 * t31 / 0.6e1 - t279 * t186
  t296 = 0.16150379519240623689600657201760358175082247499085e-3 * t289 / t275 / t261 * t177 * t33 * t31
  t297 = t289 * t282
  t299 = 0.96902277115443742137603943210562149050493484994510e-3 * t297 * t186
  t300 = 0.51817833333333333333333333333333333333333333333333e-2 * (t22 / 0.9e1 + t24 * t26 * t28 * t39 / 0.6e1 + t24 * t13 * t44 * t46 / 0.2e1 - t24 * t50 * t68 / 0.4e1) * t55 * t74 * t77 + 0.17272611111111111111111111111111111111111111111111e-2 * t88 * t90 * t19 + 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t76 * t39 + 0.13796274692623141086738355049039257855828824683819e-1 / t98 / t97 * t2 * t4 * t12 * t106 + 0.27592549385246282173476710098078515711657649367639e-1 * t103 * t54 * t55 * t58 * t61 * t106 - 0.55185098770492564346953420196157031423315298735277e-1 * t117 * t35 * t11 * t106 - 0.30878365944746984533884071665444263610784010246137e0 / t122 / t97 * t2 * t4 * t12 / t127 + 0.22478670955426118383265363956423012380560746650571e-2 * (t22 / 0.72e2 + t134 * t28 * t34 * t35 * t26 * t39 / 0.3e1 - t141 * t54 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t148 * t51 + 0.2e1 * t151 * t44 * t46 - t155 * t68) * t158 * t19 + 0.37464451592376863972108939927371687300934577750952e-3 * t165 / t151 / t134 * t19 * t33 * t31 + 0.22478670955426118383265363956423012380560746650571e-2 * t173 * t39 - t209 - t221 - t224 - t237 - t243 + t249 + t259 - t285 - t296 - t299
  t301 = r0 - r1
  t302 = 0.1e1 / t1
  t303 = t301 * t302
  t304 = 0.1e1 + t303
  t305 = t304 <= f.p.zeta_threshold
  t306 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t307 = t306 * f.p.zeta_threshold
  t308 = t304 ** (0.1e1 / 0.3e1)
  t310 = f.my_piecewise3(t305, t307, t308 * t304)
  t311 = 0.1e1 - t303
  t312 = t311 <= f.p.zeta_threshold
  t313 = t311 ** (0.1e1 / 0.3e1)
  t315 = f.my_piecewise3(t312, t307, t313 * t311)
  t316 = t310 + t315 - 0.2e1
  t318 = 2 ** (0.1e1 / 0.3e1)
  t319 = t318 - 0.1e1
  t321 = 0.1e1 / t319 / 0.2e1
  t322 = t301 ** 2
  t323 = t322 ** 2
  t324 = t321 * t323
  t325 = t8 ** 2
  t326 = 0.1e1 / t325
  t327 = t324 * t326
  t328 = t300 * t316 * t327
  t337 = t218 * t207
  t341 = t245 * t35 * t26 * t234
  t343 = t297 * t177
  t345 = 0.51817833333333333333333333333333333333333333333333e-2 * t88 * t77 + 0.41388824077869423260215065147117773567486474051458e-1 * t117 * t35 * t26 * t106 + 0.22478670955426118383265363956423012380560746650571e-2 * t173 * t19 - 0.10363566666666666666666666666666666666666666666667e-1 * t337 - 0.39765745675026770180313930393880960493473766078662e-1 * t341 - 0.96902277115443742137603943210562149050493484994510e-3 * t343
  t346 = t345 * t316
  t347 = t322 * t301
  t348 = t321 * t347
  t349 = t348 * t326
  t351 = 0.8e1 * t346 * t349
  t353 = 0.1e1 / t325 / t1
  t354 = t324 * t353
  t356 = 0.8e1 * t346 * t354
  t360 = jnp.log(t5 * t14 * t20 / 0.4e1)
  t364 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t97)
  t367 = jnp.log(t151 * t20)
  t372 = jnp.log(t5 * t14 * t178 / 0.4e1)
  t376 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t225)
  t379 = jnp.log(t275 * t178)
  t381 = 0.1554535e-1 * t360 + 0.52491393169780936217021346072241076933841385384497e-1 * t364 + 0.22478670955426118383265363956423012380560746650571e-2 * t367 - 0.310907e-1 * t372 - 0.38783294878113014394824731224995739188004877421366e-1 * t376 - 0.96902277115443742137603943210562149050493484994510e-3 * t379
  t382 = t308 ** 2
  t383 = 0.1e1 / t382
  t384 = 0.1e1 / t8
  t385 = t301 * t384
  t386 = t302 - t385
  t387 = t386 ** 2
  t391 = 0.1e1 / t8 / t1
  t392 = t301 * t391
  t394 = -0.2e1 * t384 + 0.2e1 * t392
  t398 = f.my_piecewise3(t305, 0, 0.4e1 / 0.9e1 * t383 * t387 + 0.4e1 / 0.3e1 * t308 * t394)
  t399 = t313 ** 2
  t400 = 0.1e1 / t399
  t401 = -t386
  t402 = t401 ** 2
  t409 = f.my_piecewise3(t312, 0, 0.4e1 / 0.9e1 * t400 * t402 - 0.4e1 / 0.3e1 * t313 * t394)
  t410 = t398 + t409
  t414 = t16 + 0.10061550000000000000000000000000000000000000000000e2 * t17 + 0.101578e3
  t415 = 0.1e1 / t414
  t419 = jnp.log(t5 * t14 * t415 / 0.4e1)
  t421 = t17 + 0.201231e2
  t424 = jnp.arctan(0.11716852777089929792201907797022178188779527234376e1 / t421)
  t426 = t133 + 0.743294e0
  t427 = t426 ** 2
  t429 = jnp.log(t427 * t415)
  t432 = t16 + 0.65360000000000000000000000000000000000000000000000e1 * t17 + 0.427198e2
  t433 = 0.1e1 / t432
  t437 = jnp.log(t5 * t14 * t433 / 0.4e1)
  t439 = t17 + 0.130720e2
  t442 = jnp.arctan(0.44899888641287296627004984787798591621072237693345e-1 / t439)
  t444 = t133 + 0.409286e0
  t445 = t444 ** 2
  t447 = jnp.log(t445 * t433)
  t449 = 0.1554535e-1 * t419 + 0.61881802979060631480216141626488805225499304723700e0 * t424 + 0.26673100072733151593315970562575695370840511204614e-2 * t429 - 0.310907e-1 * t437 - 0.20521972937837502661166379517614390730124411627871e2 * t442 - 0.44313737677495382697984551091739236689629774931818e-2 * t447
  t450 = 0.1e1 / t449
  t451 = t345 * t450
  t452 = jnp.pi ** 2
  t453 = 0.1e1 / t452
  t455 = t16 + 0.53417500000000000000000000000000000000000000000000e0 * t17 + 0.114813e2
  t456 = 0.1e1 / t455
  t460 = jnp.log(t5 * t14 * t456 / 0.4e1)
  t461 = t17 + 0.106835e1
  t464 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t461)
  t466 = t133 + 0.228344e0
  t467 = t466 ** 2
  t469 = jnp.log(t467 * t456)
  t472 = t453 * (t460 + 0.32323836906055067299704130765928097906535029214058e0 * t464 + 0.21608710360898267021763215722876235716176892439270e-1 * t469)
  t473 = t451 * t472
  t476 = f.my_piecewise3(t305, 0, 0.4e1 / 0.3e1 * t308 * t386)
  t479 = f.my_piecewise3(t312, 0, 0.4e1 / 0.3e1 * t313 * t401)
  t480 = t476 + t479
  t481 = t480 * t321
  t484 = 0.9e1 * t319
  t485 = (-t323 * t326 + 0.1e1) * t484
  t486 = t481 * t485
  t487 = t473 * t486
  t489 = t316 * t321
  t490 = t347 * t326
  t491 = t323 * t353
  t494 = (-0.4e1 * t490 + 0.4e1 * t491) * t484
  t495 = t489 * t494
  t496 = t473 * t495
  t498 = t381 * t450
  t500 = t5 * t12 * t456
  t502 = t455 ** 2
  t503 = 0.1e1 / t502
  t506 = -t32 - 0.89029166666666666666666666666666666666666666666667e-1 * t37
  t511 = 0.1e1 / t502 / t455
  t513 = t506 ** 2
  t517 = t13 * t503
  t520 = t52 - 0.59352777777777777777777777777777777777777777777778e-1 * t63 + 0.11870555555555555555555555555555555555555555555556e0 * t66
  t527 = t76 * t455
  t538 = (-t5 * t30 * t456 / 0.12e2 - t24 * t517 * t506 / 0.4e1) * t55 * t74
  t545 = t461 ** 2
  t550 = 0.1e1 / t545
  t552 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t550
  t553 = 0.1e1 / t552
  t564 = t550 * t33 * t2
  t569 = t545 ** 2
  t574 = t552 ** 2
  t586 = t466 * t456
  t590 = t586 * t33
  t596 = t467 * t503
  t599 = 0.1e1 / t467
  t606 = -t590 * t31 / 0.6e1 - t596 * t506
  t614 = t606 * t599
  t620 = t489 * t485
  t622 = t498 * t453 * ((t500 / 0.9e1 + t24 * t26 * t503 * t506 / 0.6e1 + t24 * t13 * t511 * t513 / 0.2e1 - t24 * t517 * t520 / 0.4e1) * t55 * t74 * t527 / 0.3e1 + t538 * t90 * t455 / 0.9e1 + t538 * t76 * t506 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 / t545 / t461 * t2 * t4 * t12 * t553 + 0.24034827266594839017845905156788576090902848675181e0 * t550 * t54 * t55 * t58 * t61 * t553 - 0.48069654533189678035691810313577152181805697350363e0 * t564 * t35 * t11 * t553 - 0.53818578849327899137148388724908565251436770250246e1 / t569 / t461 * t2 * t4 * t12 / t574 + 0.21608710360898267021763215722876235716176892439270e-1 * (t500 / 0.72e2 + t466 * t503 * t34 * t35 * t26 * t506 / 0.3e1 - t586 * t54 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t590 * t51 + 0.2e1 * t467 * t511 * t513 - t596 * t520) * t599 * t455 + 0.36014517268163778369605359538127059526961487398783e-2 * t606 / t467 / t466 * t455 * t33 * t31 + 0.21608710360898267021763215722876235716176892439270e-1 * t614 * t506) * t620 / 0.24e2
  t632 = t453 * (t538 * t527 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t564 * t35 * t26 * t553 + 0.21608710360898267021763215722876235716176892439270e-1 * t614 * t455)
  t633 = t498 * t632
  t634 = t633 * t486
  t636 = t633 * t495
  t638 = t498 * t472
  t647 = 0.12e2 * t322 * t326
  t649 = 0.32e2 * t347 * t353
  t651 = 0.1e1 / t325 / t8
  t653 = 0.20e2 * t323 * t651
  t662 = t300 * t450 * t472 * t620 / 0.24e2
  t665 = t451 * t632 * t620 / 0.12e2
  t666 = t328 + t351 - t356 + t381 * t410 * t327 + t285 + t299 - t487 / 0.12e2 - t496 / 0.12e2 - t622 - t634 / 0.12e2 - t636 / 0.12e2 - t638 * t410 * t321 * t485 / 0.24e2 - t638 * t481 * t494 / 0.12e2 - t638 * t489 * (-t647 + t649 - t653) * t484 / 0.24e2 - t662 - t665 + t296 + t209
  t667 = t449 ** 2
  t668 = 0.1e1 / t667
  t674 = t414 ** 2
  t675 = 0.1e1 / t674
  t676 = t13 * t675
  t678 = -t32 - 0.16769250000000000000000000000000000000000000000000e1 * t37
  t684 = (-t5 * t30 * t415 / 0.12e2 - t24 * t676 * t678 / 0.4e1) * t55 * t74
  t685 = t76 * t414
  t688 = t421 ** 2
  t689 = 0.1e1 / t688
  t691 = t689 * t33 * t2
  t693 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t689
  t694 = 0.1e1 / t693
  t699 = t426 * t415
  t700 = t699 * t33
  t703 = t427 * t675
  t705 = -t700 * t31 / 0.6e1 - t703 * t678
  t706 = 0.1e1 / t427
  t707 = t705 * t706
  t713 = t432 ** 2
  t714 = 0.1e1 / t713
  t715 = t13 * t714
  t717 = -t32 - 0.10893333333333333333333333333333333333333333333333e1 * t37
  t723 = (-t5 * t30 * t433 / 0.12e2 - t24 * t715 * t717 / 0.4e1) * t55 * t74
  t724 = t76 * t432
  t727 = t439 ** 2
  t728 = 0.1e1 / t727
  t730 = t728 * t33 * t2
  t732 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t728
  t733 = 0.1e1 / t732
  t738 = t444 * t433
  t739 = t738 * t33
  t742 = t445 * t714
  t744 = -t739 * t31 / 0.6e1 - t742 * t717
  t745 = 0.1e1 / t445
  t746 = t744 * t745
  t749 = 0.51817833333333333333333333333333333333333333333333e-2 * t684 * t685 + 0.12084332918108974174888840683936962325623378790503e0 * t691 * t35 * t26 * t694 + 0.26673100072733151593315970562575695370840511204614e-2 * t707 * t414 - 0.10363566666666666666666666666666666666666666666667e-1 * t723 * t724 - 0.15357238326806922974073998139716493771837789312610e0 * t730 * t35 * t26 * t733 - 0.44313737677495382697984551091739236689629774931818e-2 * t746 * t432
  t750 = t485 * t749
  t751 = t489 * t750
  t753 = t345 * t668 * t472 * t751 / 0.12e2
  t754 = t381 * t668
  t757 = t754 * t632 * t751 / 0.12e2
  t758 = t754 * t472
  t760 = t758 * t481 * t750
  t764 = t758 * t489 * t494 * t749
  t767 = t5 * t12 * t415
  t774 = 0.1e1 / t674 / t414
  t776 = t678 ** 2
  t782 = t52 - 0.11179500000000000000000000000000000000000000000000e1 * t63 + 0.22359000000000000000000000000000000000000000000000e1 * t66
  t814 = t688 ** 2
  t819 = t693 ** 2
  t854 = t5 * t12 * t433
  t861 = 0.1e1 / t713 / t432
  t863 = t717 ** 2
  t869 = t52 - 0.72622222222222222222222222222222222222222222222220e0 * t63 + 0.14524444444444444444444444444444444444444444444444e1 * t66
  t901 = t727 ** 2
  t906 = t732 ** 2
  t940 = 0.51817833333333333333333333333333333333333333333333e-2 * (t767 / 0.9e1 + t24 * t26 * t675 * t678 / 0.6e1 + t24 * t13 * t774 * t776 / 0.2e1 - t24 * t676 * t782 / 0.4e1) * t55 * t74 * t685 + 0.17272611111111111111111111111111111111111111111111e-2 * t684 * t90 * t414 + 0.51817833333333333333333333333333333333333333333333e-2 * t684 * t76 * t678 + 0.40281109727029913916296135613123207752077929301677e-1 / t688 / t421 * t2 * t4 * t12 * t694 + 0.80562219454059827832592271226246415504155858603353e-1 * t689 * t54 * t55 * t58 * t61 * t694 - 0.16112443890811965566518454245249283100831171720671e0 * t691 * t35 * t11 * t694 - 0.55299776073946902741997911947426632387660200240483e-1 / t814 / t421 * t2 * t4 * t12 / t819 + 0.26673100072733151593315970562575695370840511204614e-2 * (t767 / 0.72e2 + t426 * t675 * t34 * t35 * t26 * t678 / 0.3e1 - t699 * t54 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t700 * t51 + 0.2e1 * t427 * t774 * t776 - t703 * t782) * t706 * t414 + 0.44455166787888585988859950937626158951400852007690e-3 * t705 / t427 / t426 * t414 * t33 * t31 + 0.26673100072733151593315970562575695370840511204614e-2 * t707 * t678 - 0.10363566666666666666666666666666666666666666666667e-1 * (t854 / 0.9e1 + t24 * t26 * t714 * t717 / 0.6e1 + t24 * t13 * t861 * t863 / 0.2e1 - t24 * t715 * t869 / 0.4e1) * t55 * t74 * t724 - 0.34545222222222222222222222222222222222222222222223e-2 * t723 * t90 * t432 - 0.10363566666666666666666666666666666666666666666667e-1 * t723 * t76 * t717 - 0.51190794422689743246913327132388312572792631042033e-1 / t727 / t439 * t2 * t4 * t12 * t733 - 0.10238158884537948649382665426477662514558526208407e0 * t728 * t54 * t55 * t58 * t61 * t733 + 0.20476317769075897298765330852955325029117052416813e0 * t730 * t35 * t11 * t733 + 0.10320064155614252238577726749889483814674994418074e-3 / t901 / t439 * t2 * t4 * t12 / t906 - 0.44313737677495382697984551091739236689629774931818e-2 * (t854 / 0.72e2 + t444 * t714 * t34 * t35 * t26 * t717 / 0.3e1 - t738 * t54 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t739 * t51 + 0.2e1 * t445 * t861 * t863 - t742 * t869) * t745 * t432 - 0.73856229462492304496640918486232061149382958219697e-3 * t744 / t445 / t444 * t432 * t33 * t31 - 0.44313737677495382697984551091739236689629774931818e-2 * t746 * t717
  t944 = t758 * t489 * t485 * t940 / 0.24e2
  t949 = t749 ** 2
  t953 = t381 / t667 / t449 * t472 * t489 * t485 * t949 / 0.12e2
  t954 = t381 * t316
  t957 = 0.20e2 * t954 * t324 * t651
  t961 = 0.12e2 * t954 * t321 * t322 * t326
  t964 = 0.32e2 * t954 * t348 * t353
  t965 = t381 * t480
  t966 = t965 * t349
  t968 = t965 * t354
  t971 = t345 * t480 * t327
  t973 = t221 + t224 + t237 - t259 + t753 + t757 + t760 / 0.12e2 + t764 / 0.12e2 + t944 - t953 + t243 - t249 + t957 + t961 - t964 + 0.8e1 * t966 - 0.8e1 * t968 + 0.2e1 * t971
  t977 = 0.2e1 * t346 * t327
  t978 = t965 * t327
  t981 = 0.8e1 * t954 * t349
  t983 = 0.8e1 * t954 * t354
  t984 = 0.79531491350053540360627860787761920986947532157324e-1 * t341
  t986 = t758 * t751 / 0.12e2
  t987 = 0.19380455423088748427520788642112429810098696998902e-2 * t343
  t988 = 0.20727133333333333333333333333333333333333333333334e-1 * t337
  t989 = t638 * t495
  t992 = t473 * t620 / 0.12e2
  t993 = t638 * t486
  t996 = t633 * t620 / 0.12e2
  d11 = t1 * (t666 + t973) + t977 + 0.2e1 * t978 + t981 - t983 + t984 + t986 + t987 + t988 - t989 / 0.12e2 - t992 - t993 / 0.12e2 - t996
  t997 = -t302 - t385
  t1000 = f.my_piecewise3(t305, 0, 0.4e1 / 0.3e1 * t308 * t997)
  t1001 = -t997
  t1004 = f.my_piecewise3(t312, 0, 0.4e1 / 0.3e1 * t313 * t1001)
  t1005 = t1000 + t1004
  t1006 = t1005 * t321
  t1007 = t1006 * t485
  t1008 = t633 * t1007
  t1017 = f.my_piecewise3(t305, 0, 0.4e1 / 0.9e1 * t383 * t997 * t386 + 0.8e1 / 0.3e1 * t308 * t301 * t391)
  t1025 = f.my_piecewise3(t312, 0, 0.4e1 / 0.9e1 * t400 * t1001 * t401 - 0.8e1 / 0.3e1 * t313 * t301 * t391)
  t1026 = t1017 + t1025
  t1036 = (0.4e1 * t490 + 0.4e1 * t491) * t484
  t1037 = t489 * t1036
  t1038 = t473 * t1037
  t1040 = t633 * t1037
  t1050 = t328 - t356 + t285 + t299 - t1008 / 0.24e2 - t638 * t1026 * t321 * t485 / 0.24e2 - t638 * t1006 * t494 / 0.24e2 - t1038 / 0.24e2 - t1040 / 0.24e2 - t638 * t481 * t1036 / 0.24e2 - t638 * t489 * (t647 - t653) * t484 / 0.24e2
  t1051 = t473 * t1007
  t1057 = -t1051 / 0.24e2 - t487 / 0.24e2 - t496 / 0.24e2 - t622 - t634 / 0.24e2 - t636 / 0.24e2 - t662 - t665 + t296 + t209 + t221
  t1060 = t758 * t1006 * t750
  t1064 = t758 * t489 * t1036 * t749
  t1068 = t224 + t237 - t259 + t1060 / 0.24e2 + t1064 / 0.24e2 + t753 + t757 + t760 / 0.24e2 + t764 / 0.24e2 + t944 - t953
  t1071 = t381 * t1005
  t1072 = t1071 * t349
  t1074 = t1071 * t354
  t1077 = t345 * t1005 * t327
  t1080 = t381 * t1026 * t327 + 0.4e1 * t1072 - 0.4e1 * t1074 + t1077 + t243 - t249 + t957 - t961 - 0.4e1 * t966 - 0.4e1 * t968 + t971
  t1084 = t1071 * t327
  t1085 = t638 * t1037
  t1087 = t638 * t1007
  d12 = t978 + t1 * (t1050 + t1057 + t1068 + t1080) + t988 + t987 - t983 + t977 + t1084 + t984 - t1085 / 0.24e2 - t996 - t1087 / 0.24e2 - t992 - t989 / 0.24e2 - t993 / 0.24e2 + t986
  t1097 = t328 - t351 - t356 + t285 + t299 - t1008 / 0.12e2 - t1038 / 0.12e2 - t1040 / 0.12e2 - t1051 / 0.12e2 - t622 - t662 - t665 + t296 + t209 + t221 + t224 + t237 - t259
  t1100 = t997 ** 2
  t1104 = 0.2e1 * t384 + 0.2e1 * t392
  t1108 = f.my_piecewise3(t305, 0, 0.4e1 / 0.9e1 * t383 * t1100 + 0.4e1 / 0.3e1 * t308 * t1104)
  t1109 = t1001 ** 2
  t1116 = f.my_piecewise3(t312, 0, 0.4e1 / 0.9e1 * t400 * t1109 - 0.4e1 / 0.3e1 * t313 * t1104)
  t1117 = t1108 + t1116
  t1135 = t1060 / 0.12e2 + t1064 / 0.12e2 + t753 + t757 + t944 - t953 + t243 - t249 + t957 + t961 + t964 + t381 * t1117 * t327 - 0.8e1 * t1072 - 0.8e1 * t1074 + 0.2e1 * t1077 - t638 * t489 * (-t647 - t649 - t653) * t484 / 0.24e2 - t638 * t1117 * t321 * t485 / 0.24e2 - t638 * t1006 * t1036 / 0.12e2
  d22 = t988 + t977 + 0.2e1 * t1084 - t981 - t983 + t984 - t1085 / 0.12e2 + t986 + t1 * (t1097 + t1135) - t992 + t987 - t996 - t1087 / 0.12e2
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t19 = 0.1e1 / t18
  t23 = t4 * t6
  t24 = t18 ** 2
  t25 = 0.1e1 / t24
  t26 = t12 * t25
  t27 = t4 * t11
  t28 = t27 / 0.12e2
  t29 = 0.1e1 / t16
  t30 = t29 * t1
  t31 = t3 * t6
  t33 = t30 * t31 * t10
  t35 = -t28 - 0.58836833333333333333333333333333333333333333333333e0 * t33
  t40 = t1 ** 2
  t42 = 0.1e1 / t3
  t43 = (-t4 * t11 * t19 / 0.12e2 - t23 * t26 * t35 / 0.4e1) * t40 * t42
  t44 = t5 * t8
  t45 = t44 * t18
  t48 = t16 + 0.706042e1
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t52 = t50 * t29 * t1
  t54 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t50
  t55 = 0.1e1 / t54
  t60 = t16 / 0.2e1
  t61 = t60 + 0.32500e0
  t62 = t61 * t19
  t63 = t62 * t29
  t66 = t61 ** 2
  t67 = t66 * t25
  t69 = -t63 * t27 / 0.6e1 - t67 * t35
  t70 = 0.1e1 / t66
  t71 = t69 * t70
  t75 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t76 = 0.1e1 / t75
  t80 = t75 ** 2
  t81 = 0.1e1 / t80
  t82 = t12 * t81
  t84 = -t28 - 0.31062000000000000000000000000000000000000000000000e0 * t33
  t90 = (-t4 * t11 * t76 / 0.12e2 - t23 * t82 * t84 / 0.4e1) * t40 * t42
  t91 = t44 * t75
  t94 = t16 + 0.372744e1
  t95 = t94 ** 2
  t96 = 0.1e1 / t95
  t98 = t96 * t29 * t1
  t100 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t96
  t101 = 0.1e1 / t100
  t106 = t60 + 0.10498e0
  t107 = t106 * t76
  t108 = t107 * t29
  t111 = t106 ** 2
  t112 = t111 * t81
  t114 = -t108 * t27 / 0.6e1 - t112 * t84
  t115 = 0.1e1 / t111
  t116 = t114 * t115
  t119 = 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t45 + 0.41388824077869423260215065147117773567486474051458e-1 * t52 * t31 * t10 * t55 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t18 - 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t91 - 0.39765745675026770180313930393880960493473766078662e-1 * t98 * t31 * t10 * t101 - 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t75
  t120 = r0 - r1
  t121 = 0.1e1 / t7
  t122 = t120 * t121
  t123 = 0.1e1 + t122
  t124 = t123 <= f.p.zeta_threshold
  t125 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t126 = t125 * f.p.zeta_threshold
  t127 = t123 ** (0.1e1 / 0.3e1)
  t129 = f.my_piecewise3(t124, t126, t127 * t123)
  t130 = 0.1e1 - t122
  t131 = t130 <= f.p.zeta_threshold
  t132 = t130 ** (0.1e1 / 0.3e1)
  t134 = f.my_piecewise3(t131, t126, t132 * t130)
  t135 = t129 + t134 - 0.2e1
  t136 = t119 * t135
  t137 = 2 ** (0.1e1 / 0.3e1)
  t138 = t137 - 0.1e1
  t140 = 0.1e1 / t138 / 0.2e1
  t141 = t120 ** 2
  t142 = t141 ** 2
  t143 = t140 * t142
  t144 = t7 ** 2
  t145 = t144 ** 2
  t147 = 0.1e1 / t145 / t7
  t148 = t143 * t147
  t154 = jnp.log(t4 * t13 * t19 / 0.4e1)
  t158 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t48)
  t161 = jnp.log(t66 * t19)
  t166 = jnp.log(t4 * t13 * t76 / 0.4e1)
  t170 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t94)
  t173 = jnp.log(t111 * t76)
  t175 = 0.1554535e-1 * t154 + 0.52491393169780936217021346072241076933841385384497e-1 * t158 + 0.22478670955426118383265363956423012380560746650571e-2 * t161 - 0.310907e-1 * t166 - 0.38783294878113014394824731224995739188004877421366e-1 * t170 - 0.96902277115443742137603943210562149050493484994510e-3 * t173
  t176 = t127 ** 2
  t177 = 0.1e1 / t176
  t178 = 0.1e1 / t144
  t180 = -t120 * t178 + t121
  t181 = t180 ** 2
  t184 = t144 * t7
  t185 = 0.1e1 / t184
  t188 = 0.2e1 * t120 * t185 - 0.2e1 * t178
  t192 = f.my_piecewise3(t124, 0, 0.4e1 / 0.9e1 * t177 * t181 + 0.4e1 / 0.3e1 * t127 * t188)
  t193 = t132 ** 2
  t194 = 0.1e1 / t193
  t195 = -t180
  t196 = t195 ** 2
  t199 = -t188
  t203 = f.my_piecewise3(t131, 0, 0.4e1 / 0.9e1 * t194 * t196 + 0.4e1 / 0.3e1 * t132 * t199)
  t204 = t192 + t203
  t205 = t175 * t204
  t206 = 0.1e1 / t145
  t207 = t143 * t206
  t211 = 0.1e1 / t8 / t144
  t212 = t6 * t211
  t214 = t4 * t212 * t19
  t216 = t10 * t25
  t221 = 0.1e1 / t24 / t18
  t222 = t12 * t221
  t223 = t35 ** 2
  t227 = t4 * t212
  t228 = t227 / 0.9e1
  t230 = 0.1e1 / t16 / t14
  t231 = t230 * t40
  t232 = t3 ** 2
  t233 = t232 * t5
  t234 = t8 ** 2
  t236 = 0.1e1 / t234 / t144
  t238 = t231 * t233 * t236
  t241 = t30 * t31 * t211
  t243 = t228 - 0.39224555555555555555555555555555555555555555555555e0 * t238 + 0.78449111111111111111111111111111111111111111111110e0 * t241
  t249 = (t214 / 0.9e1 + t23 * t216 * t35 / 0.6e1 + t23 * t222 * t223 / 0.2e1 - t23 * t26 * t243 / 0.4e1) * t40 * t42
  t253 = t5 / t234
  t254 = t253 * t18
  t257 = t44 * t35
  t262 = 0.1e1 / t49 / t48 * t1
  t263 = t262 * t3
  t268 = t50 * t230 * t40
  t277 = t49 ** 2
  t280 = 0.1e1 / t277 / t48 * t1
  t281 = t280 * t3
  t282 = t54 ** 2
  t283 = 0.1e1 / t282
  t288 = t61 * t25
  t289 = t288 * t30
  t294 = t62 * t230
  t295 = t40 * t232
  t297 = t295 * t5 * t236
  t302 = t66 * t221
  t306 = t214 / 0.72e2 + t289 * t31 * t10 * t35 / 0.3e1 - t294 * t297 / 0.9e1 + 0.2e1 / 0.9e1 * t63 * t227 + 0.2e1 * t302 * t223 - t67 * t243
  t307 = t306 * t70
  t311 = 0.1e1 / t66 / t61
  t312 = t69 * t311
  t313 = t18 * t29
  t314 = t312 * t313
  t320 = t4 * t212 * t76
  t322 = t10 * t81
  t327 = 0.1e1 / t80 / t75
  t328 = t12 * t327
  t329 = t84 ** 2
  t335 = t228 - 0.20708000000000000000000000000000000000000000000000e0 * t238 + 0.41416000000000000000000000000000000000000000000000e0 * t241
  t341 = (t320 / 0.9e1 + t23 * t322 * t84 / 0.6e1 + t23 * t328 * t329 / 0.2e1 - t23 * t82 * t335 / 0.4e1) * t40 * t42
  t342 = t341 * t91
  t344 = t253 * t75
  t345 = t90 * t344
  t347 = t44 * t84
  t348 = t90 * t347
  t352 = 0.1e1 / t95 / t94 * t1
  t353 = t352 * t3
  t355 = t353 * t212 * t101
  t358 = t96 * t230 * t40
  t361 = t358 * t233 * t236 * t101
  t365 = t98 * t31 * t211 * t101
  t367 = t95 ** 2
  t370 = 0.1e1 / t367 / t94 * t1
  t371 = t370 * t3
  t372 = t100 ** 2
  t373 = 0.1e1 / t372
  t375 = t371 * t212 * t373
  t378 = t106 * t81
  t379 = t378 * t30
  t384 = t107 * t230
  t389 = t111 * t327
  t393 = t320 / 0.72e2 + t379 * t31 * t10 * t84 / 0.3e1 - t384 * t297 / 0.9e1 + 0.2e1 / 0.9e1 * t108 * t227 + 0.2e1 * t389 * t329 - t112 * t335
  t394 = t393 * t115
  t395 = t394 * t75
  t398 = 0.1e1 / t111 / t106
  t399 = t114 * t398
  t400 = t75 * t29
  t401 = t399 * t400
  t402 = t401 * t27
  t404 = t116 * t84
  t406 = 0.51817833333333333333333333333333333333333333333333e-2 * t249 * t45 + 0.17272611111111111111111111111111111111111111111111e-2 * t43 * t254 + 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t257 + 0.13796274692623141086738355049039257855828824683819e-1 * t263 * t212 * t55 + 0.27592549385246282173476710098078515711657649367639e-1 * t268 * t233 * t236 * t55 - 0.55185098770492564346953420196157031423315298735277e-1 * t52 * t31 * t211 * t55 - 0.30878365944746984533884071665444263610784010246137e0 * t281 * t212 * t283 + 0.22478670955426118383265363956423012380560746650571e-2 * t307 * t18 + 0.37464451592376863972108939927371687300934577750952e-3 * t314 * t27 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t35 - 0.10363566666666666666666666666666666666666666666667e-1 * t342 - 0.34545222222222222222222222222222222222222222222223e-2 * t345 - 0.10363566666666666666666666666666666666666666666667e-1 * t348 - 0.13255248558342256726771310131293653497824588692887e-1 * t355 - 0.26510497116684513453542620262587306995649177385775e-1 * t361 + 0.53020994233369026907085240525174613991298354771549e-1 * t365 + 0.50167127350538589836488394571946851238131125013746e0 * t375 - 0.96902277115443742137603943210562149050493484994510e-3 * t395 - 0.16150379519240623689600657201760358175082247499085e-3 * t402 - 0.96902277115443742137603943210562149050493484994510e-3 * t404
  t407 = t406 * t135
  t410 = t175 * t135
  t412 = 0.1e1 / t145 / t144
  t413 = t143 * t412
  t416 = t140 * t141
  t417 = t416 * t206
  t420 = t141 * t120
  t421 = t140 * t420
  t422 = t421 * t147
  t427 = f.my_piecewise3(t124, 0, 0.4e1 / 0.3e1 * t127 * t180)
  t430 = f.my_piecewise3(t131, 0, 0.4e1 / 0.3e1 * t132 * t195)
  t431 = t427 + t430
  t432 = t175 * t431
  t433 = t421 * t206
  t441 = t15 + 0.10061550000000000000000000000000000000000000000000e2 * t16 + 0.101578e3
  t442 = 0.1e1 / t441
  t446 = jnp.log(t4 * t13 * t442 / 0.4e1)
  t448 = t16 + 0.201231e2
  t451 = jnp.atan(0.11716852777089929792201907797022178188779527234376e1 / t448)
  t453 = t60 + 0.743294e0
  t454 = t453 ** 2
  t456 = jnp.log(t454 * t442)
  t459 = t15 + 0.65360000000000000000000000000000000000000000000000e1 * t16 + 0.427198e2
  t460 = 0.1e1 / t459
  t464 = jnp.log(t4 * t13 * t460 / 0.4e1)
  t466 = t16 + 0.130720e2
  t469 = jnp.atan(0.44899888641287296627004984787798591621072237693345e-1 / t466)
  t471 = t60 + 0.409286e0
  t472 = t471 ** 2
  t474 = jnp.log(t472 * t460)
  t476 = 0.1554535e-1 * t446 + 0.61881802979060631480216141626488805225499304723700e0 * t451 + 0.26673100072733151593315970562575695370840511204614e-2 * t456 - 0.310907e-1 * t464 - 0.20521972937837502661166379517614390730124411627871e2 * t469 - 0.44313737677495382697984551091739236689629774931818e-2 * t474
  t477 = 0.1e1 / t476
  t478 = t175 * t477
  t479 = jnp.pi ** 2
  t480 = 0.1e1 / t479
  t482 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t483 = 0.1e1 / t482
  t485 = t4 * t212 * t483
  t487 = t482 ** 2
  t488 = 0.1e1 / t487
  t489 = t10 * t488
  t491 = -t28 - 0.89029166666666666666666666666666666666666666666667e-1 * t33
  t496 = 0.1e1 / t487 / t482
  t497 = t12 * t496
  t498 = t491 ** 2
  t502 = t12 * t488
  t505 = t228 - 0.59352777777777777777777777777777777777777777777778e-1 * t238 + 0.11870555555555555555555555555555555555555555555556e0 * t241
  t511 = (t485 / 0.9e1 + t23 * t489 * t491 / 0.6e1 + t23 * t497 * t498 / 0.2e1 - t23 * t502 * t505 / 0.4e1) * t40 * t42
  t512 = t44 * t482
  t523 = (-t4 * t11 * t483 / 0.12e2 - t23 * t502 * t491 / 0.4e1) * t40 * t42
  t524 = t253 * t482
  t527 = t44 * t491
  t530 = t16 + 0.106835e1
  t531 = t530 ** 2
  t534 = 0.1e1 / t531 / t530 * t1
  t535 = t534 * t3
  t536 = 0.1e1 / t531
  t538 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t536
  t539 = 0.1e1 / t538
  t544 = t536 * t230 * t40
  t550 = t536 * t29 * t1
  t555 = t531 ** 2
  t558 = 0.1e1 / t555 / t530 * t1
  t559 = t558 * t3
  t560 = t538 ** 2
  t561 = 0.1e1 / t560
  t566 = t60 + 0.228344e0
  t567 = t566 * t488
  t568 = t567 * t30
  t573 = t566 * t483
  t574 = t573 * t230
  t577 = t573 * t29
  t580 = t566 ** 2
  t581 = t580 * t496
  t584 = t580 * t488
  t586 = t485 / 0.72e2 + t568 * t31 * t10 * t491 / 0.3e1 - t574 * t297 / 0.9e1 + 0.2e1 / 0.9e1 * t577 * t227 + 0.2e1 * t581 * t498 - t584 * t505
  t587 = 0.1e1 / t580
  t588 = t586 * t587
  t594 = -t577 * t27 / 0.6e1 - t584 * t491
  t596 = 0.1e1 / t580 / t566
  t597 = t594 * t596
  t598 = t482 * t29
  t599 = t597 * t598
  t602 = t594 * t587
  t606 = t480 * (t511 * t512 / 0.3e1 + t523 * t524 / 0.9e1 + t523 * t527 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t535 * t212 * t539 + 0.24034827266594839017845905156788576090902848675181e0 * t544 * t233 * t236 * t539 - 0.48069654533189678035691810313577152181805697350363e0 * t550 * t31 * t211 * t539 - 0.53818578849327899137148388724908565251436770250246e1 * t559 * t212 * t561 + 0.21608710360898267021763215722876235716176892439270e-1 * t588 * t482 + 0.36014517268163778369605359538127059526961487398783e-2 * t599 * t27 + 0.21608710360898267021763215722876235716176892439270e-1 * t602 * t491)
  t607 = t478 * t606
  t608 = t135 * t140
  t610 = -t142 * t206 + 0.1e1
  t611 = 0.9e1 * t138
  t612 = t610 * t611
  t613 = t608 * t612
  t625 = t480 * (t523 * t512 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t550 * t31 * t10 * t539 + 0.21608710360898267021763215722876235716176892439270e-1 * t602 * t482)
  t626 = t478 * t625
  t627 = t431 * t140
  t628 = t627 * t612
  t635 = (0.4e1 * t142 * t147 - 0.4e1 * t420 * t206) * t611
  t636 = t608 * t635
  t639 = t119 * t477
  t640 = t639 * t625
  t646 = jnp.log(t4 * t13 * t483 / 0.4e1)
  t649 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t530)
  t652 = jnp.log(t580 * t483)
  t655 = t480 * (t646 + 0.32323836906055067299704130765928097906535029214058e0 * t649 + 0.21608710360898267021763215722876235716176892439270e-1 * t652)
  t656 = t639 * t655
  t662 = t406 * t477
  t663 = t662 * t655
  t666 = t478 * t655
  t667 = t204 * t140
  t668 = t667 * t612
  t671 = -0.24e2 * t136 * t148 + 0.3e1 * t205 * t207 + 0.3e1 * t407 * t207 + 0.60e2 * t410 * t413 + 0.36e2 * t410 * t417 - 0.96e2 * t410 * t422 + 0.24e2 * t432 * t433 - 0.24e2 * t432 * t148 + 0.24e2 * t136 * t433 - t607 * t613 / 0.8e1 - t626 * t628 / 0.4e1 - t626 * t636 / 0.4e1 - t640 * t613 / 0.4e1 - t656 * t628 / 0.4e1 - t656 * t636 / 0.4e1 + 0.48451138557721871068801971605281074525246742497255e-3 * t402 - t663 * t613 / 0.8e1 - t666 * t668 / 0.8e1
  t672 = t627 * t635
  t682 = (-0.12e2 * t141 * t206 - 0.20e2 * t142 * t412 + 0.32e2 * t420 * t147) * t611
  t683 = t608 * t682
  t695 = t476 ** 2
  t696 = 0.1e1 / t695
  t697 = t119 * t696
  t698 = t697 * t655
  t702 = t441 ** 2
  t703 = 0.1e1 / t702
  t704 = t12 * t703
  t706 = -t28 - 0.16769250000000000000000000000000000000000000000000e1 * t33
  t712 = (-t4 * t11 * t442 / 0.12e2 - t23 * t704 * t706 / 0.4e1) * t40 * t42
  t713 = t44 * t441
  t716 = t448 ** 2
  t717 = 0.1e1 / t716
  t719 = t717 * t29 * t1
  t721 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t717
  t722 = 0.1e1 / t721
  t727 = t453 * t442
  t728 = t727 * t29
  t731 = t454 * t703
  t733 = -t728 * t27 / 0.6e1 - t731 * t706
  t734 = 0.1e1 / t454
  t735 = t733 * t734
  t741 = t459 ** 2
  t742 = 0.1e1 / t741
  t743 = t12 * t742
  t745 = -t28 - 0.10893333333333333333333333333333333333333333333333e1 * t33
  t751 = (-t4 * t11 * t460 / 0.12e2 - t23 * t743 * t745 / 0.4e1) * t40 * t42
  t752 = t44 * t459
  t755 = t466 ** 2
  t756 = 0.1e1 / t755
  t758 = t756 * t29 * t1
  t760 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t756
  t761 = 0.1e1 / t760
  t766 = t471 * t460
  t767 = t766 * t29
  t770 = t472 * t742
  t772 = -t767 * t27 / 0.6e1 - t770 * t745
  t773 = 0.1e1 / t472
  t774 = t772 * t773
  t777 = 0.51817833333333333333333333333333333333333333333333e-2 * t712 * t713 + 0.12084332918108974174888840683936962325623378790503e0 * t719 * t31 * t10 * t722 + 0.26673100072733151593315970562575695370840511204614e-2 * t735 * t441 - 0.10363566666666666666666666666666666666666666666667e-1 * t751 * t752 - 0.15357238326806922974073998139716493771837789312610e0 * t758 * t31 * t10 * t761 - 0.44313737677495382697984551091739236689629774931818e-2 * t774 * t459
  t778 = t612 * t777
  t779 = t608 * t778
  t782 = t175 * t696
  t783 = t782 * t625
  t786 = t782 * t655
  t787 = t627 * t778
  t790 = t635 * t777
  t791 = t608 * t790
  t795 = t4 * t212 * t442
  t797 = t10 * t703
  t802 = 0.1e1 / t702 / t441
  t803 = t12 * t802
  t804 = t706 ** 2
  t810 = t228 - 0.11179500000000000000000000000000000000000000000000e1 * t238 + 0.22359000000000000000000000000000000000000000000000e1 * t241
  t816 = (t795 / 0.9e1 + t23 * t797 * t706 / 0.6e1 + t23 * t803 * t804 / 0.2e1 - t23 * t704 * t810 / 0.4e1) * t40 * t42
  t819 = t253 * t441
  t822 = t44 * t706
  t827 = 0.1e1 / t716 / t448 * t1
  t828 = t827 * t3
  t833 = t717 * t230 * t40
  t842 = t716 ** 2
  t845 = 0.1e1 / t842 / t448 * t1
  t846 = t845 * t3
  t847 = t721 ** 2
  t848 = 0.1e1 / t847
  t853 = t453 * t703
  t854 = t853 * t30
  t859 = t727 * t230
  t864 = t454 * t802
  t868 = t795 / 0.72e2 + t854 * t31 * t10 * t706 / 0.3e1 - t859 * t297 / 0.9e1 + 0.2e1 / 0.9e1 * t728 * t227 + 0.2e1 * t864 * t804 - t731 * t810
  t869 = t868 * t734
  t873 = 0.1e1 / t454 / t453
  t874 = t733 * t873
  t875 = t441 * t29
  t876 = t874 * t875
  t882 = t4 * t212 * t460
  t884 = t10 * t742
  t889 = 0.1e1 / t741 / t459
  t890 = t12 * t889
  t891 = t745 ** 2
  t897 = t228 - 0.72622222222222222222222222222222222222222222222220e0 * t238 + 0.14524444444444444444444444444444444444444444444444e1 * t241
  t903 = (t882 / 0.9e1 + t23 * t884 * t745 / 0.6e1 + t23 * t890 * t891 / 0.2e1 - t23 * t743 * t897 / 0.4e1) * t40 * t42
  t906 = t253 * t459
  t909 = t44 * t745
  t914 = 0.1e1 / t755 / t466 * t1
  t915 = t914 * t3
  t920 = t756 * t230 * t40
  t929 = t755 ** 2
  t932 = 0.1e1 / t929 / t466 * t1
  t933 = t932 * t3
  t934 = t760 ** 2
  t935 = 0.1e1 / t934
  t940 = t471 * t742
  t941 = t940 * t30
  t946 = t766 * t230
  t951 = t472 * t889
  t955 = t882 / 0.72e2 + t941 * t31 * t10 * t745 / 0.3e1 - t946 * t297 / 0.9e1 + 0.2e1 / 0.9e1 * t767 * t227 + 0.2e1 * t951 * t891 - t770 * t897
  t956 = t955 * t773
  t960 = 0.1e1 / t472 / t471
  t961 = t772 * t960
  t962 = t459 * t29
  t963 = t961 * t962
  t968 = 0.51817833333333333333333333333333333333333333333333e-2 * t816 * t713 + 0.17272611111111111111111111111111111111111111111111e-2 * t712 * t819 + 0.51817833333333333333333333333333333333333333333333e-2 * t712 * t822 + 0.40281109727029913916296135613123207752077929301677e-1 * t828 * t212 * t722 + 0.80562219454059827832592271226246415504155858603353e-1 * t833 * t233 * t236 * t722 - 0.16112443890811965566518454245249283100831171720671e0 * t719 * t31 * t211 * t722 - 0.55299776073946902741997911947426632387660200240483e-1 * t846 * t212 * t848 + 0.26673100072733151593315970562575695370840511204614e-2 * t869 * t441 + 0.44455166787888585988859950937626158951400852007690e-3 * t876 * t27 + 0.26673100072733151593315970562575695370840511204614e-2 * t735 * t706 - 0.10363566666666666666666666666666666666666666666667e-1 * t903 * t752 - 0.34545222222222222222222222222222222222222222222223e-2 * t751 * t906 - 0.10363566666666666666666666666666666666666666666667e-1 * t751 * t909 - 0.51190794422689743246913327132388312572792631042033e-1 * t915 * t212 * t761 - 0.10238158884537948649382665426477662514558526208407e0 * t920 * t233 * t236 * t761 + 0.20476317769075897298765330852955325029117052416813e0 * t758 * t31 * t211 * t761 + 0.10320064155614252238577726749889483814674994418074e-3 * t933 * t212 * t935 - 0.44313737677495382697984551091739236689629774931818e-2 * t956 * t459 - 0.73856229462492304496640918486232061149382958219697e-3 * t963 * t27 - 0.44313737677495382697984551091739236689629774931818e-2 * t774 * t745
  t969 = t612 * t968
  t970 = t608 * t969
  t974 = 0.1e1 / t695 / t476
  t975 = t175 * t974
  t976 = t975 * t655
  t977 = t777 ** 2
  t978 = t612 * t977
  t979 = t608 * t978
  t982 = t119 * t431
  t996 = t120 * t206
  t998 = 0.6e1 * t185 - 0.6e1 * t996
  t1002 = f.my_piecewise3(t124, 0, -0.8e1 / 0.27e2 / t176 / t123 * t181 * t180 + 0.4e1 / 0.3e1 * t177 * t180 * t188 + 0.4e1 / 0.3e1 * t127 * t998)
  t1015 = f.my_piecewise3(t131, 0, -0.8e1 / 0.27e2 / t193 / t130 * t196 * t195 + 0.4e1 / 0.3e1 * t194 * t195 * t199 - 0.4e1 / 0.3e1 * t132 * t998)
  t1016 = t1002 + t1015
  t1029 = 0.1e1 / t145 / t184
  t1038 = 0.1e1 / t8 / t184
  t1039 = t6 * t1038
  t1041 = t4 * t1039 * t76
  t1045 = t23 * t211 * t81 * t84
  t1065 = 0.1e1 / t232
  t1067 = t1 * t1065 * t6
  t1068 = t1038 * t2
  t1075 = 0.1e1 / t16 / t295 / t253 / 0.4e1
  t1077 = t1075 * t2 * t206
  t1081 = 0.1e1 / t234 / t184
  t1082 = t5 * t1081
  t1083 = t295 * t1082
  t1086 = t4 * t1039
  t1089 = t80 ** 2
  t1090 = 0.1e1 / t1089
  t1092 = t329 * t84
  t1095 = t84 * t335
  t1098 = 0.7e1 / 0.27e2 * t1086
  t1101 = t231 * t233 * t1081
  t1104 = t30 * t31 * t1038
  t1106 = -t1098 - 0.12424800000000000000000000000000000000000000000000e1 * t1077 + 0.82832000000000000000000000000000000000000000000000e0 * t1101 - 0.96637333333333333333333333333333333333333333333333e0 * t1104
  t1108 = -0.11e2 / 0.216e3 * t1041 - t1045 / 0.24e2 - t106 * t327 * t30 * t31 * t10 * t329 + t378 * t231 * t233 * t236 * t84 / 0.3e1 - 0.2e1 / 0.3e1 * t379 * t31 * t211 * t84 + t379 * t31 * t10 * t335 / 0.2e1 + t1067 * t1068 * t76 / 0.432e3 - 0.2e1 / 0.3e1 * t107 * t1077 + 0.4e1 / 0.9e1 * t384 * t1083 - 0.14e2 / 0.27e2 * t108 * t1086 - 0.6e1 * t111 * t1090 * t1092 + 0.6e1 * t389 * t1095 - t112 * t1106
  t1111 = 0.96902277115443742137603943210562149050493484994510e-3 * t1108 * t115 * t75
  t1114 = 0.19380455423088748427520788642112429810098696998902e-2 * t394 * t84
  t1116 = 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t335
  t1120 = 0.10604198846673805381417048105034922798259670954310e0 * t358 * t233 * t1081 * t101
  t1124 = 0.12371565321119439611653222789207409931302949446695e0 * t98 * t31 * t1038 * t101
  t1125 = t111 ** 2
  t1130 = 0.40375948798101559224001643004400895437705618747712e-4 * t114 / t1125 * t75 * t227
  t1131 = t367 ** 2
  t1140 = 0.50631328524251801700246888250186209051365905137714e2 / t1131 * t40 * t232 * t1082 / t372 / t100 * t29
  t1147 = 0.26510497116684513453542620262587306995649177385774e-1 / t367 * t40 * t232 * t1082 * t101 * t29
  t1155 = 0.23411326096918008590361250800241863911127858339748e1 / t367 / t95 * t40 * t232 * t1082 * t373 * t29
  t1160 = 0.22092080930570427877952183552156089163040981154812e-2 * t352 * t1065 * t1039 * t2 * t101
  t1165 = 0.83611878917564316394147324286578085396885208356242e-1 * t370 * t1065 * t1039 * t2 * t373
  t1168 = 0.36e2 * t136 * t417 + t1114 + t1116 - t1120 + t1124 + t1130 + t1140 + t1147 - t1155 + t1160 - t1165
  t1229 = t472 ** 2
  t1245 = t929 ** 2
  t1270 = -0.25806562167841887946265692242132428447574760112225e0 / t842 / t716 * t40 * t232 * t1082 * t848 * t29 + 0.67135182878383189860493559355205346253463215502794e-2 * t827 * t1065 * t1039 * t2 * t722 - 0.32224887781623931133036908490498566201662343441341e0 * t833 * t233 * t1081 * t722 + 0.37595702411894586321876393238914993901939400681566e0 * t719 * t31 * t1038 * t722 + 0.40952635538151794597530661705910650058234104833627e0 * t920 * t233 * t1081 * t761 - 0.47778074794510427030452438656895758401273122305897e0 * t758 * t31 * t1038 * t761 - 0.18464057365623076124160229621558015287345739554924e-3 * t772 / t1229 * t459 * t227 - 0.85317990704482905411522211887313854287987718403392e-2 * t914 * t1065 * t1039 * t2 * t761 + 0.17200106926023753730962877916482473024458324030124e-4 * t932 * t1065 * t1039 * t2 * t935 - 0.55480664900582220034593859007405864987692769991566e-6 / t1245 * t40 * t232 * t1082 / t934 / t760 * t29 - 0.10238158884537948649382665426477662514558526208407e0 / t929 * t40 * t232 * t1082 * t761 * t29 + 0.48160299392866510446696058166150924468483307284345e-3 / t929 / t755 * t40 * t232 * t1082 * t935 * t29
  t1271 = t454 ** 2
  t1282 = t842 ** 2
  t1300 = t4 * t1039 * t460
  t1304 = t23 * t211 * t742 * t745
  t1313 = t741 ** 2
  t1314 = 0.1e1 / t1313
  t1316 = t891 * t745
  t1320 = t745 * t897
  t1327 = -t1098 - 0.43573333333333333333333333333333333333333333333332e1 * t1077 + 0.29048888888888888888888888888888888888888888888888e1 * t1101 - 0.33890370370370370370370370370370370370370370370369e1 * t1104
  t1349 = t5 / t234 / t7
  t1359 = 0.11113791696972146497214987734406539737850213001922e-3 * t733 / t1271 * t441 * t227 - 0.92166293456578171236663186579044387312767000400800e-2 * t845 * t1065 * t1039 * t2 * t848 + 0.20244826120247034261608782614550005883535036385819e0 / t1282 * t40 * t232 * t1082 / t847 / t721 * t29 + 0.80562219454059827832592271226246415504155858603354e-1 / t842 * t40 * t232 * t1082 * t722 * t29 - 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t1300 - t1304 / 0.3e1 - t23 * t10 * t889 * t891 / 0.2e1 + t23 * t884 * t897 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t1314 * t1316 + 0.3e1 / 0.2e1 * t23 * t890 * t1320 - t23 * t743 * t1327 / 0.4e1) * t40 * t42 * t752 + 0.20276584560447197672065901047389765208808740088178e0 * t846 * t1039 * t848 + 0.51817833333333333333333333333333333333333333333333e-2 * t712 * t44 * t810 + 0.34545222222222222222222222222222222222222222222222e-2 * t712 * t253 * t706 + 0.10363566666666666666666666666666666666666666666667e-1 * t816 * t822 - 0.11515074074074074074074074074074074074074074074074e-2 * t712 * t1349 * t441 - 0.14769740233244301769308583058145176175761907410615e0 * t828 * t1039 * t722 - 0.37840235237252258208118331416261440653808312866271e-3 * t933 * t1039 * t935
  t1370 = t4 * t1039 * t442
  t1374 = t23 * t211 * t703 * t706
  t1383 = t702 ** 2
  t1384 = 0.1e1 / t1383
  t1386 = t804 * t706
  t1390 = t706 * t810
  t1397 = -t1098 - 0.67077000000000000000000000000000000000000000000000e1 * t1077 + 0.44718000000000000000000000000000000000000000000000e1 * t1101 - 0.52171000000000000000000000000000000000000000000000e1 * t1104
  t1417 = t2 * t206
  t1460 = -0.11e2 / 0.216e3 * t1370 - t1374 / 0.24e2 - t453 * t802 * t30 * t31 * t10 * t804 + t853 * t231 * t233 * t236 * t706 / 0.3e1 - 0.2e1 / 0.3e1 * t854 * t31 * t211 * t706 + t854 * t31 * t10 * t810 / 0.2e1 + t1067 * t1068 * t442 / 0.432e3 - 0.2e1 / 0.3e1 * t727 * t1077 + 0.4e1 / 0.9e1 * t859 * t1083 - 0.14e2 / 0.27e2 * t728 * t1086 - 0.6e1 * t454 * t1384 * t1386 + 0.6e1 * t864 * t1390 - t731 * t1397
  t1466 = -0.10363566666666666666666666666666666666666666666667e-1 * t751 * t44 * t897 - 0.69090444444444444444444444444444444444444444444446e-2 * t751 * t253 * t745 - 0.20727133333333333333333333333333333333333333333334e-1 * t903 * t909 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t1370 - t1374 / 0.3e1 - t23 * t10 * t802 * t804 / 0.2e1 + t23 * t797 * t810 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t1384 * t1386 + 0.3e1 / 0.2e1 * t23 * t803 * t1390 - t23 * t704 * t1397 / 0.4e1) * t40 * t42 * t713 + 0.34545222222222222222222222222222222222222222222222e-2 * t816 * t819 + 0.23030148148148148148148148148148148148148148148149e-2 * t751 * t1349 * t459 + 0.18769957954986239190534886615209047943357298048745e0 * t915 * t1039 * t761 - 0.69090444444444444444444444444444444444444444444446e-2 * t903 * t906 - 0.61428953307227691896295992558865975087351157250442e0 * t756 * t1075 * t1417 * t761 + 0.48337331672435896699555362735747849302493515162012e0 * t717 * t1075 * t1417 * t722 + 0.26673100072733151593315970562575695370840511204614e-2 * t1460 * t734 * t441 + 0.53346200145466303186631941125151390741681022409228e-2 * t869 * t706
  t1504 = -0.11e2 / 0.216e3 * t1300 - t1304 / 0.24e2 - t471 * t889 * t30 * t31 * t10 * t891 + t940 * t231 * t233 * t236 * t745 / 0.3e1 - 0.2e1 / 0.3e1 * t941 * t31 * t211 * t745 + t941 * t31 * t10 * t897 / 0.2e1 + t1067 * t1068 * t460 / 0.432e3 - 0.2e1 / 0.3e1 * t766 * t1077 + 0.4e1 / 0.9e1 * t946 * t1083 - 0.14e2 / 0.27e2 * t767 * t1086 - 0.6e1 * t472 * t1314 * t1316 + 0.6e1 * t951 * t1320 - t770 * t1327
  t1540 = -0.44313737677495382697984551091739236689629774931818e-2 * t774 * t897 - 0.44313737677495382697984551091739236689629774931818e-2 * t1504 * t773 * t459 - 0.88627475354990765395969102183478473379259549863636e-2 * t956 * t745 + 0.26673100072733151593315970562575695370840511204614e-2 * t735 * t810 - 0.59273555717184781318479934583501545268534469343587e-3 * t876 * t227 + 0.88910333575777171977719901875252317902801704015380e-3 * t874 * t706 * t29 * t27 + 0.29636777858592390659239967291750772634267234671793e-3 * t874 * t441 * t230 * t297 + 0.88910333575777171977719901875252317902801704015380e-3 * t868 * t873 * t875 * t27 - 0.14771245892498460899328183697246412229876591643939e-2 * t955 * t960 * t962 * t27 - 0.14771245892498460899328183697246412229876591643939e-2 * t961 * t745 * t29 * t27 - 0.49237486308328202997760612324154707432921972146465e-3 * t961 * t459 * t230 * t297 + 0.98474972616656405995521224648309414865843944292929e-3 * t963 * t227
  t1554 = t695 ** 2
  t1579 = t783 * t791 / 0.4e1 + t783 * t787 / 0.4e1 + t786 * t608 * t612 * (t1270 + t1359 + t1466 + t1540) / 0.24e2 + t786 * t608 * t635 * t968 / 0.8e1 + t786 * t627 * t969 / 0.8e1 + t175 / t1554 * t655 * t608 * t612 * t977 * t777 / 0.4e1 - t976 * t627 * t978 / 0.4e1 - t976 * t608 * t635 * t977 / 0.4e1 - t119 * t974 * t655 * t979 / 0.4e1 - t975 * t625 * t979 / 0.4e1 + t698 * t970 / 0.8e1
  t1648 = -t626 * t668 / 0.8e1 - t666 * t1016 * t140 * t612 / 0.24e2 - t666 * t667 * t635 / 0.8e1 - t656 * t672 / 0.4e1 - t626 * t672 / 0.4e1 - t666 * t627 * t682 / 0.8e1 - t656 * t683 / 0.8e1 - t663 * t628 / 0.8e1 - t663 * t636 / 0.8e1 - t656 * t668 / 0.8e1 - t662 * t625 * t613 / 0.8e1
  t1673 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t1041 - t1045 / 0.3e1 - t23 * t10 * t327 * t329 / 0.2e1 + t23 * t322 * t335 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t1090 * t1092 + 0.3e1 / 0.2e1 * t23 * t328 * t1095 - t23 * t82 * t1106 / 0.4e1) * t40 * t42 * t91
  t1675 = 0.69090444444444444444444444444444444444444444444446e-2 * t341 * t344
  t1678 = 0.18394613361864149606712411343047178787314745838373e1 * t371 * t1039 * t373
  t1681 = 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t44 * t335
  t1684 = 0.69090444444444444444444444444444444444444444444446e-2 * t90 * t253 * t84
  t1686 = 0.20727133333333333333333333333333333333333333333334e-1 * t341 * t347
  t1690 = 0.15906298270010708072125572157552384197389506431465e0 * t96 * t1075 * t1417 * t101
  t1692 = t4 * t1039 * t19
  t1696 = t23 * t211 * t25 * t35
  t1725 = t24 ** 2
  t1726 = 0.1e1 / t1725
  t1728 = t223 * t35
  t1731 = t35 * t243
  t1737 = -t1098 - 0.23534733333333333333333333333333333333333333333333e1 * t1077 + 0.15689822222222222222222222222222222222222222222222e1 * t1101 - 0.18304792592592592592592592592592592592592592592592e1 * t1104
  t1739 = -0.11e2 / 0.216e3 * t1692 - t1696 / 0.24e2 - t61 * t221 * t30 * t31 * t10 * t223 + t288 * t231 * t233 * t236 * t35 / 0.3e1 - 0.2e1 / 0.3e1 * t289 * t31 * t211 * t35 + t289 * t31 * t10 * t243 / 0.2e1 + t1067 * t1068 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t62 * t1077 + 0.4e1 / 0.9e1 * t294 * t1083 - 0.14e2 / 0.27e2 * t63 * t1086 - 0.6e1 * t66 * t1726 * t1728 + 0.6e1 * t302 * t1731 - t67 * t1737
  t1773 = -t1111 - t1114 + 0.22478670955426118383265363956423012380560746650571e-2 * t1739 * t70 * t18 + 0.44957341910852236766530727912846024761121493301142e-2 * t307 * t35 - t1116 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t243 - 0.14409904107548592782479233443873989685032538114864e1 / t277 / t49 * t40 * t232 * t1082 * t283 * t29 + 0.22993791154371901811230591748398763093048041139699e-2 * t262 * t1065 * t1039 * t2 * t55 - 0.51463943241244974223140119442407106017973350410227e-1 * t280 * t1065 * t1039 * t2 * t283 - 0.11037019754098512869390684039231406284663059747056e0 * t268 * t233 * t1081 * t55 + 0.12876523046448265014289131379103307332106903038231e0 * t52 * t31 * t1038 * t55 + t1120
  t1774 = t66 ** 2
  t1780 = t277 ** 2
  t1800 = -t1124 - t1130 - t1140 - t1147 + t1155 - t1160 + t1165 + 0.93661128980942159930272349818429218252336444377380e-4 * t69 / t1774 * t18 * t227 + 0.18429583437767336287475605998441200095133403022660e2 / t1780 * t40 * t232 * t1082 / t282 / t54 * t29 + 0.27592549385246282173476710098078515711657649367638e-1 / t277 * t40 * t232 * t1082 * t55 * t29 - t1673 + 0.11322067513073894329090826277329563323954137090250e1 * t281 * t1039 * t283
  t1841 = 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t44 * t243 + 0.34545222222222222222222222222222222222222222222222e-2 * t43 * t253 * t35 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t1692 - t1696 / 0.3e1 - t23 * t10 * t221 * t223 / 0.2e1 + t23 * t216 * t243 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t1726 * t1728 + 0.3e1 / 0.2e1 * t23 * t222 * t1731 - t23 * t26 * t1737 / 0.4e1) * t40 * t42 * t45 - t1675 - t1678 - t1681 - 0.50586340539618183984707301846477278804705690507337e-1 * t263 * t1039 * t55 - t1684 - t1686 - t1690 + 0.16555529631147769304086026058847109426994589620583e0 * t50 * t1075 * t1417 * t55 + 0.10363566666666666666666666666666666666666666666667e-1 * t249 * t257
  t1849 = 0.48602578047254941331494803814743396158690158540586e-1 * t353 * t1039 * t101
  t1852 = 0.23030148148148148148148148148148148148148148148149e-2 * t90 * t1349 * t75
  t1864 = 0.32300759038481247379201314403520716350164494998170e-3 * t393 * t398 * t400 * t27
  t1868 = 0.32300759038481247379201314403520716350164494998170e-3 * t399 * t84 * t29 * t27
  t1872 = 0.10766919679493749126400438134506905450054831666057e-3 * t399 * t75 * t230 * t297
  t1874 = 0.21533839358987498252800876269013810900109663332113e-3 * t401 * t227
  t1881 = 0.34545222222222222222222222222222222222222222222222e-2 * t249 * t254 - 0.11515074074074074074074074074074074074074074074074e-2 * t43 * t1349 * t18 + t1849 + t1852 + 0.74928903184753727944217879854743374601869155501904e-3 * t312 * t35 * t29 * t27 + 0.24976301061584575981405959951581124867289718500635e-3 * t312 * t18 * t230 * t297 - t1864 - t1868 - t1872 + t1874 - 0.49952602123169151962811919903162249734579437001269e-3 * t314 * t227 + 0.74928903184753727944217879854743374601869155501904e-3 * t306 * t311 * t313 * t27
  t1883 = t1773 + t1800 + t1841 + t1881
  t1894 = t1673 + t1675 + t1678 + t1681 + t1684 + t1686 + t1690 + t1883 * t135 * t207 - t975 * t655 * t135 * t140 * t610 * t611 * t968 * t777 / 0.4e1 - t1849 - t1852
  t1909 = t580 ** 2
  t1915 = t555 ** 2
  t1966 = 0.90036293170409445924013398845317648817403718496958e-3 * t594 / t1909 * t482 * t227 + 0.64272053155397178166610502978456596616246611440970e3 / t1915 * t40 * t232 * t1082 / t560 / t538 * t29 - 0.2e1 / 0.27e2 * t523 * t1349 * t482 - 0.44063849988757204866050826120779056166655222571167e0 * t535 * t1039 * t539 + 0.24034827266594839017845905156788576090902848675182e0 / t555 * t40 * t232 * t1082 * t539 * t29 - 0.25115336796353019597335914738290663784003826116781e2 / t555 / t531 * t40 * t232 * t1082 * t561 * t29 + 0.20029022722162365848204920963990480075752373895984e-1 * t534 * t1065 * t1039 * t2 * t539 - 0.89697631415546498561913981208180942085727950417076e0 * t558 * t1065 * t1039 * t2 * t561 + 0.2e1 / 0.9e1 * t511 * t524 + 0.19733478911420229683621075865799807258860149091757e2 * t559 * t1039 * t561 + t523 * t44 * t505 / 0.3e1 + 0.2e1 / 0.3e1 * t511 * t527
  t1971 = t4 * t1039 * t483
  t1975 = t23 * t211 * t488 * t491
  t1984 = t487 ** 2
  t1985 = 0.1e1 / t1984
  t1987 = t498 * t491
  t1991 = t491 * t505
  t1998 = -t1098 - 0.35611666666666666666666666666666666666666666666667e0 * t1077 + 0.23741111111111111111111111111111111111111111111111e0 * t1101 - 0.27697962962962962962962962962962962962962962962964e0 * t1104
  t2060 = -0.11e2 / 0.216e3 * t1971 - t1975 / 0.24e2 - t566 * t496 * t30 * t31 * t10 * t498 + t567 * t231 * t233 * t236 * t491 / 0.3e1 - 0.2e1 / 0.3e1 * t568 * t31 * t211 * t491 + t568 * t31 * t10 * t505 / 0.2e1 + t1067 * t1068 * t483 / 0.432e3 - 0.2e1 / 0.3e1 * t573 * t1077 + 0.4e1 / 0.9e1 * t574 * t1083 - 0.14e2 / 0.27e2 * t577 * t1086 - 0.6e1 * t580 * t1985 * t1987 + 0.6e1 * t581 * t1991 - t584 * t1998
  t2076 = 0.2e1 / 0.9e1 * t523 * t253 * t491 + (-0.7e1 / 0.27e2 * t1971 - t1975 / 0.3e1 - t23 * t10 * t496 * t498 / 0.2e1 + t23 * t489 * t505 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t1985 * t1987 + 0.3e1 / 0.2e1 * t23 * t497 * t1991 - t23 * t502 * t1998 / 0.4e1) * t40 * t42 * t512 / 0.3e1 + 0.14420896359956903410707543094073145654541709205109e1 * t536 * t1075 * t1417 * t539 + 0.72029034536327556739210719076254119053922974797566e-2 * t586 * t596 * t598 * t27 + 0.72029034536327556739210719076254119053922974797566e-2 * t597 * t491 * t29 * t27 + 0.24009678178775852246403573025418039684640991599189e-2 * t597 * t482 * t230 * t297 - 0.48019356357551704492807146050836079369281983198377e-2 * t599 * t227 + 0.21608710360898267021763215722876235716176892439270e-1 * t2060 * t587 * t482 + 0.43217420721796534043526431445752471432353784878540e-1 * t588 * t491 + 0.21608710360898267021763215722876235716176892439270e-1 * t602 * t505 - 0.96139309066379356071383620627154304363611394700724e0 * t544 * t233 * t1081 * t539 + 0.11216252724410924874994755739834668842421329381751e1 * t550 * t31 * t1038 * t539
  t2082 = 0.12e2 * t407 * t433 + t1864 + t1868 + t1872 - t1874 - t1883 * t477 * t655 * t613 / 0.24e2 - t640 * t636 / 0.4e1 - t640 * t628 / 0.4e1 - t607 * t628 / 0.8e1 - t607 * t636 / 0.8e1 - t478 * t480 * (t1966 + t2076) * t613 / 0.24e2
  t2087 = -t666 * t672 / 0.4e1 - t666 * t683 / 0.8e1 + 0.29070683134633122641281182963168644715148045498353e-2 * t395 + 0.29070683134633122641281182963168644715148045498353e-2 * t404 + 0.31090700000000000000000000000000000000000000000001e-1 * t342 + 0.10363566666666666666666666666666666666666666666667e-1 * t345 + 0.31090700000000000000000000000000000000000000000001e-1 * t348 + 0.39765745675026770180313930393880960493473766078662e-1 * t355 - 0.15050138205161576950946518371584055371439337504124e1 * t375 + 0.79531491350053540360627860787761920986947532157324e-1 * t361 - 0.15906298270010708072125572157552384197389506431465e0 * t365 + t698 * t779 / 0.4e1 + t783 * t779 / 0.4e1 + t786 * t787 / 0.4e1 + t786 * t791 / 0.4e1 + t786 * t970 / 0.8e1 - t976 * t979 / 0.4e1 + 0.6e1 * t982 * t207 + t7 * (0.24e2 * t410 * t140 * t120 * t206 + t406 * t696 * t655 * t779 / 0.8e1 + t786 * t608 * t682 * t777 / 0.8e1 - t666 * t608 * (0.120e3 * t142 * t1029 + 0.144e3 * t141 * t147 - 0.240e3 * t420 * t412 - 0.24e2 * t996) * t611 / 0.24e2 + t783 * t970 / 0.8e1 - t626 * t683 / 0.8e1 + t698 * t791 / 0.4e1 - 0.96e2 * t136 * t422 - 0.12e2 * t407 * t148 + 0.24e2 * t982 * t433 - 0.24e2 * t982 * t148 - 0.96e2 * t432 * t422 + t698 * t787 / 0.4e1 + 0.60e2 * t136 * t413 + 0.36e2 * t432 * t417 + 0.60e2 * t432 * t413 + 0.12e2 * t205 * t433 - 0.12e2 * t205 * t148 + t1579 + t2082 + t1894 + t1648 + t1111 + t1168 + t786 * t667 * t778 / 0.8e1 + t786 * t627 * t790 / 0.4e1 + t782 * t606 * t779 / 0.8e1 - t639 * t606 * t613 / 0.8e1 + 0.3e1 * t406 * t431 * t207 + t175 * t1016 * t207 + 0.240e3 * t410 * t421 * t412 - 0.120e3 * t410 * t143 * t1029 - 0.144e3 * t410 * t416 * t147 + 0.3e1 * t119 * t204 * t207 + t697 * t625 * t779 / 0.4e1)
  d111 = t671 + t2087

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 + r1
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / jnp.pi
  t4 = t3 ** (0.1e1 / 0.3e1)
  t5 = t2 * t4
  t6 = 4 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t1
  t11 = t7 * t10
  t12 = 0.1e1 / t8
  t13 = t7 * t12
  t14 = t5 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t19 = 0.1e1 / t18
  t23 = t5 * t7
  t24 = t18 ** 2
  t25 = 0.1e1 / t24
  t26 = t12 * t25
  t27 = t5 * t11
  t28 = t27 / 0.12e2
  t29 = 0.1e1 / t16
  t30 = t29 * t2
  t31 = t4 * t7
  t33 = t30 * t31 * t10
  t35 = -t28 - 0.58836833333333333333333333333333333333333333333333e0 * t33
  t40 = t2 ** 2
  t42 = 0.1e1 / t4
  t43 = (-t5 * t11 * t19 / 0.12e2 - t23 * t26 * t35 / 0.4e1) * t40 * t42
  t44 = t6 * t8
  t45 = t44 * t18
  t48 = t16 + 0.706042e1
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t52 = t50 * t29 * t2
  t54 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t50
  t55 = 0.1e1 / t54
  t60 = t16 / 0.2e1
  t61 = t60 + 0.32500e0
  t62 = t61 * t19
  t63 = t62 * t29
  t66 = t61 ** 2
  t67 = t66 * t25
  t69 = -t63 * t27 / 0.6e1 - t67 * t35
  t70 = 0.1e1 / t66
  t71 = t69 * t70
  t75 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t76 = 0.1e1 / t75
  t80 = t75 ** 2
  t81 = 0.1e1 / t80
  t82 = t12 * t81
  t84 = -t28 - 0.31062000000000000000000000000000000000000000000000e0 * t33
  t90 = (-t5 * t11 * t76 / 0.12e2 - t23 * t82 * t84 / 0.4e1) * t40 * t42
  t91 = t44 * t75
  t94 = t16 + 0.372744e1
  t95 = t94 ** 2
  t96 = 0.1e1 / t95
  t98 = t96 * t29 * t2
  t100 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t96
  t101 = 0.1e1 / t100
  t106 = t60 + 0.10498e0
  t107 = t106 * t76
  t108 = t107 * t29
  t111 = t106 ** 2
  t112 = t111 * t81
  t114 = -t108 * t27 / 0.6e1 - t112 * t84
  t115 = 0.1e1 / t111
  t116 = t114 * t115
  t119 = 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t45 + 0.41388824077869423260215065147117773567486474051458e-1 * t52 * t31 * t10 * t55 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t18 - 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t91 - 0.39765745675026770180313930393880960493473766078662e-1 * t98 * t31 * t10 * t101 - 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t75
  t120 = r0 - r1
  t121 = 0.1e1 / t1
  t122 = t120 * t121
  t123 = 0.1e1 + t122
  t124 = t123 <= f.p.zeta_threshold
  t125 = t123 ** (0.1e1 / 0.3e1)
  t126 = t1 ** 2
  t127 = 0.1e1 / t126
  t129 = -t120 * t127 + t121
  t132 = f.my_piecewise3(t124, 0, 0.4e1 / 0.3e1 * t125 * t129)
  t133 = 0.1e1 - t122
  t134 = t133 <= f.p.zeta_threshold
  t135 = t133 ** (0.1e1 / 0.3e1)
  t136 = -t129
  t139 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t136)
  t140 = t132 + t139
  t141 = t119 * t140
  t142 = 2 ** (0.1e1 / 0.3e1)
  t143 = t142 - 0.1e1
  t145 = 0.1e1 / t143 / 0.2e1
  t146 = t120 ** 2
  t147 = t146 * t120
  t148 = t145 * t147
  t149 = t126 ** 2
  t150 = t149 * t1
  t151 = 0.1e1 / t150
  t152 = t148 * t151
  t155 = t126 * t1
  t157 = 0.1e1 / t8 / t155
  t158 = t7 * t157
  t160 = t5 * t158 * t76
  t163 = 0.1e1 / t8 / t126
  t164 = t163 * t81
  t166 = t23 * t164 * t84
  t169 = 0.1e1 / t80 / t75
  t170 = t106 * t169
  t171 = t170 * t30
  t172 = t84 ** 2
  t176 = t106 * t81
  t178 = 0.1e1 / t16 / t14
  t179 = t178 * t40
  t180 = t176 * t179
  t181 = t4 ** 2
  t182 = t181 * t6
  t183 = t8 ** 2
  t185 = 0.1e1 / t183 / t126
  t190 = t176 * t30
  t195 = t7 * t163
  t196 = t5 * t195
  t197 = t196 / 0.9e1
  t199 = t179 * t182 * t185
  t202 = t30 * t31 * t163
  t204 = t197 - 0.20708000000000000000000000000000000000000000000000e0 * t199 + 0.41416000000000000000000000000000000000000000000000e0 * t202
  t209 = 0.1e1 / t181
  t211 = t2 * t209 * t7
  t212 = t157 * t3
  t216 = t40 * t181
  t218 = t6 / t183
  t222 = 0.1e1 / t16 / t216 / t218 / 0.4e1
  t223 = t222 * t3
  t224 = 0.1e1 / t149
  t225 = t223 * t224
  t228 = t107 * t178
  t230 = 0.1e1 / t183 / t155
  t231 = t6 * t230
  t232 = t216 * t231
  t235 = t5 * t158
  t238 = t80 ** 2
  t239 = 0.1e1 / t238
  t240 = t111 * t239
  t241 = t172 * t84
  t244 = t111 * t169
  t245 = t84 * t204
  t248 = 0.7e1 / 0.27e2 * t235
  t251 = t179 * t182 * t230
  t254 = t30 * t31 * t157
  t256 = -t248 - 0.12424800000000000000000000000000000000000000000000e1 * t225 + 0.82832000000000000000000000000000000000000000000000e0 * t251 - 0.96637333333333333333333333333333333333333333333333e0 * t254
  t258 = -0.11e2 / 0.216e3 * t160 - t166 / 0.24e2 - t171 * t31 * t10 * t172 + t180 * t182 * t185 * t84 / 0.3e1 - 0.2e1 / 0.3e1 * t190 * t31 * t163 * t84 + t190 * t31 * t10 * t204 / 0.2e1 + t211 * t212 * t76 / 0.432e3 - 0.2e1 / 0.3e1 * t107 * t225 + 0.4e1 / 0.9e1 * t228 * t232 - 0.14e2 / 0.27e2 * t108 * t235 - 0.6e1 * t240 * t241 + 0.6e1 * t244 * t245 - t112 * t256
  t259 = t258 * t115
  t260 = t259 * t75
  t263 = t5 * t195 * t76
  t265 = t10 * t84
  t269 = t6 * t185
  t270 = t216 * t269
  t278 = t263 / 0.72e2 + t190 * t31 * t265 / 0.3e1 - t228 * t270 / 0.9e1 + 0.2e1 / 0.9e1 * t108 * t196 + 0.2e1 * t244 * t172 - t112 * t204
  t279 = t278 * t115
  t280 = t279 * t84
  t282 = t116 * t204
  t286 = t10 * t169
  t290 = t10 * t81
  t294 = t12 * t239
  t298 = t12 * t169
  t307 = (-0.7e1 / 0.27e2 * t160 - t166 / 0.3e1 - t23 * t286 * t172 / 0.2e1 + t23 * t290 * t204 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t294 * t241 + 0.3e1 / 0.2e1 * t23 * t298 * t245 - t23 * t82 * t256 / 0.4e1) * t40 * t42
  t308 = t307 * t91
  t311 = t5 * t158 * t19
  t313 = t163 * t25
  t315 = t23 * t313 * t35
  t318 = 0.1e1 / t24 / t18
  t319 = t10 * t318
  t320 = t35 ** 2
  t324 = t10 * t25
  t327 = t197 - 0.39224555555555555555555555555555555555555555555555e0 * t199 + 0.78449111111111111111111111111111111111111111111110e0 * t202
  t331 = t24 ** 2
  t332 = 0.1e1 / t331
  t333 = t12 * t332
  t334 = t320 * t35
  t338 = t12 * t318
  t339 = t35 * t327
  t346 = -t248 - 0.23534733333333333333333333333333333333333333333333e1 * t225 + 0.15689822222222222222222222222222222222222222222222e1 * t251 - 0.18304792592592592592592592592592592592592592592592e1 * t254
  t352 = (-0.7e1 / 0.27e2 * t311 - t315 / 0.3e1 - t23 * t319 * t320 / 0.2e1 + t23 * t324 * t327 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t333 * t334 + 0.3e1 / 0.2e1 * t23 * t338 * t339 - t23 * t26 * t346 / 0.4e1) * t40 * t42
  t355 = t49 * t48
  t356 = 0.1e1 / t355
  t357 = t356 * t2
  t358 = t357 * t4
  t362 = t49 ** 2
  t364 = 0.1e1 / t362 / t48
  t365 = t364 * t2
  t366 = t365 * t4
  t367 = t54 ** 2
  t368 = 0.1e1 / t367
  t372 = t218 * t35
  t375 = t44 * t327
  t380 = t6 / t183 / t1
  t381 = t380 * t18
  t396 = (t263 / 0.9e1 + t23 * t290 * t84 / 0.6e1 + t23 * t298 * t172 / 0.2e1 - t23 * t82 * t204 / 0.4e1) * t40 * t42
  t397 = t218 * t75
  t398 = t396 * t397
  t400 = t44 * t84
  t401 = t396 * t400
  t403 = -0.96902277115443742137603943210562149050493484994510e-3 * t260 - 0.19380455423088748427520788642112429810098696998902e-2 * t280 - 0.96902277115443742137603943210562149050493484994510e-3 * t282 - 0.10363566666666666666666666666666666666666666666667e-1 * t308 + 0.51817833333333333333333333333333333333333333333333e-2 * t352 * t45 - 0.50586340539618183984707301846477278804705690507337e-1 * t358 * t158 * t55 + 0.11322067513073894329090826277329563323954137090250e1 * t366 * t158 * t368 + 0.34545222222222222222222222222222222222222222222222e-2 * t43 * t372 + 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t375 - 0.11515074074074074074074074074074074074074074074074e-2 * t43 * t381 - 0.69090444444444444444444444444444444444444444444446e-2 * t398 - 0.20727133333333333333333333333333333333333333333334e-1 * t401
  t404 = t95 ** 2
  t406 = 0.1e1 / t404 / t94
  t407 = t406 * t2
  t408 = t407 * t4
  t409 = t100 ** 2
  t410 = 0.1e1 / t409
  t412 = t408 * t158 * t410
  t415 = t5 * t195 * t19
  t428 = (t415 / 0.9e1 + t23 * t324 * t35 / 0.6e1 + t23 * t338 * t320 / 0.2e1 - t23 * t26 * t327 / 0.4e1) * t40 * t42
  t429 = t44 * t35
  t432 = t380 * t75
  t433 = t90 * t432
  t435 = t218 * t84
  t436 = t90 * t435
  t438 = t95 * t94
  t439 = 0.1e1 / t438
  t440 = t439 * t2
  t441 = t440 * t4
  t443 = t441 * t158 * t101
  t445 = t44 * t204
  t446 = t90 * t445
  t448 = t218 * t18
  t452 = 0.1e1 / t362 / t49
  t453 = t452 * t40
  t454 = t453 * t181
  t455 = t368 * t29
  t459 = t357 * t209
  t460 = t3 * t55
  t464 = t365 * t209
  t465 = t3 * t368
  t470 = t50 * t178 * t40
  t479 = -0.18394613361864149606712411343047178787314745838373e1 * t412 + 0.10363566666666666666666666666666666666666666666667e-1 * t428 * t429 + 0.23030148148148148148148148148148148148148148148149e-2 * t433 - 0.69090444444444444444444444444444444444444444444446e-2 * t436 + 0.48602578047254941331494803814743396158690158540586e-1 * t443 - 0.10363566666666666666666666666666666666666666666667e-1 * t446 + 0.34545222222222222222222222222222222222222222222222e-2 * t428 * t448 - 0.14409904107548592782479233443873989685032538114864e1 * t454 * t231 * t455 + 0.22993791154371901811230591748398763093048041139699e-2 * t459 * t158 * t460 - 0.51463943241244974223140119442407106017973350410227e-1 * t464 * t158 * t465 - 0.11037019754098512869390684039231406284663059747056e0 * t470 * t182 * t230 * t55 + 0.12876523046448265014289131379103307332106903038231e0 * t52 * t31 * t157 * t55
  t481 = 0.1e1 / t404
  t482 = t481 * t40
  t483 = t482 * t181
  t484 = t101 * t29
  t486 = t483 * t231 * t484
  t489 = 0.1e1 / t404 / t95
  t490 = t489 * t40
  t491 = t490 * t181
  t492 = t410 * t29
  t494 = t491 * t231 * t492
  t496 = t404 ** 2
  t497 = 0.1e1 / t496
  t498 = t497 * t40
  t499 = t498 * t181
  t501 = 0.1e1 / t409 / t100
  t502 = t501 * t29
  t504 = t499 * t231 * t502
  t507 = t96 * t178 * t40
  t510 = t507 * t182 * t230 * t101
  t514 = t98 * t31 * t157 * t101
  t516 = t407 * t209
  t517 = t3 * t410
  t519 = t516 * t158 * t517
  t521 = t440 * t209
  t522 = t3 * t101
  t524 = t521 * t158 * t522
  t526 = t111 ** 2
  t527 = 0.1e1 / t526
  t528 = t114 * t527
  t529 = t528 * t75
  t530 = t529 * t196
  t532 = t66 ** 2
  t533 = 0.1e1 / t532
  t534 = t69 * t533
  t535 = t534 * t18
  t538 = t362 ** 2
  t539 = 0.1e1 / t538
  t540 = t539 * t40
  t541 = t540 * t181
  t543 = 0.1e1 / t367 / t54
  t544 = t543 * t29
  t548 = 0.1e1 / t362
  t549 = t548 * t40
  t550 = t549 * t181
  t551 = t55 * t29
  t556 = t61 * t25
  t557 = t556 * t30
  t558 = t10 * t35
  t562 = t62 * t178
  t567 = t66 * t318
  t571 = t415 / 0.72e2 + t557 * t31 * t558 / 0.3e1 - t562 * t270 / 0.9e1 + 0.2e1 / 0.9e1 * t63 * t196 + 0.2e1 * t567 * t320 - t67 * t327
  t572 = t571 * t70
  t575 = -0.26510497116684513453542620262587306995649177385774e-1 * t486 + 0.23411326096918008590361250800241863911127858339748e1 * t494 - 0.50631328524251801700246888250186209051365905137714e2 * t504 + 0.10604198846673805381417048105034922798259670954310e0 * t510 - 0.12371565321119439611653222789207409931302949446695e0 * t514 + 0.83611878917564316394147324286578085396885208356242e-1 * t519 - 0.22092080930570427877952183552156089163040981154812e-2 * t524 - 0.40375948798101559224001643004400895437705618747712e-4 * t530 + 0.93661128980942159930272349818429218252336444377380e-4 * t535 * t196 + 0.18429583437767336287475605998441200095133403022660e2 * t541 * t231 * t544 + 0.27592549385246282173476710098078515711657649367638e-1 * t550 * t231 * t551 + 0.44957341910852236766530727912846024761121493301142e-2 * t572 * t35
  t580 = t61 * t318
  t581 = t580 * t30
  t585 = t556 * t179
  t607 = t66 * t332
  t613 = -0.11e2 / 0.216e3 * t311 - t315 / 0.24e2 - t581 * t31 * t10 * t320 + t585 * t182 * t185 * t35 / 0.3e1 - 0.2e1 / 0.3e1 * t557 * t31 * t163 * t35 + t557 * t31 * t10 * t327 / 0.2e1 + t211 * t212 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t62 * t225 + 0.4e1 / 0.9e1 * t562 * t232 - 0.14e2 / 0.27e2 * t63 * t235 - 0.6e1 * t607 * t334 + 0.6e1 * t567 * t339 - t67 * t346
  t614 = t613 * t70
  t618 = 0.1e1 / t66 / t61
  t619 = t69 * t618
  t620 = t18 * t178
  t621 = t619 * t620
  t625 = 0.1e1 / t111 / t106
  t626 = t278 * t625
  t627 = t75 * t29
  t628 = t626 * t627
  t629 = t628 * t27
  t631 = t114 * t625
  t632 = t84 * t29
  t633 = t631 * t632
  t634 = t633 * t27
  t636 = t631 * t627
  t637 = t636 * t196
  t639 = t18 * t29
  t640 = t619 * t639
  t643 = t75 * t178
  t644 = t631 * t643
  t645 = t644 * t270
  t647 = t571 * t618
  t648 = t647 * t639
  t651 = t35 * t29
  t652 = t619 * t651
  t655 = t50 * t222
  t656 = t3 * t224
  t660 = t96 * t222
  t662 = t660 * t656 * t101
  t664 = 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t327 + 0.22478670955426118383265363956423012380560746650571e-2 * t614 * t18 + 0.24976301061584575981405959951581124867289718500635e-3 * t621 * t270 - 0.32300759038481247379201314403520716350164494998170e-3 * t629 - 0.32300759038481247379201314403520716350164494998170e-3 * t634 + 0.21533839358987498252800876269013810900109663332113e-3 * t637 - 0.49952602123169151962811919903162249734579437001269e-3 * t640 * t196 - 0.10766919679493749126400438134506905450054831666057e-3 * t645 + 0.74928903184753727944217879854743374601869155501904e-3 * t648 * t27 + 0.74928903184753727944217879854743374601869155501904e-3 * t652 * t27 + 0.16555529631147769304086026058847109426994589620583e0 * t655 * t656 * t55 - 0.15906298270010708072125572157552384197389506431465e0 * t662
  t666 = t403 + t479 + t575 + t664
  t667 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t668 = t667 * f.p.zeta_threshold
  t670 = f.my_piecewise3(t124, t668, t125 * t123)
  t672 = f.my_piecewise3(t134, t668, t135 * t133)
  t673 = t670 + t672 - 0.2e1
  t674 = t666 * t673
  t675 = t148 * t224
  t681 = jnp.log(t5 * t13 * t19 / 0.4e1)
  t685 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t48)
  t688 = jnp.log(t66 * t19)
  t693 = jnp.log(t5 * t13 * t76 / 0.4e1)
  t697 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t94)
  t700 = jnp.log(t111 * t76)
  t702 = 0.1554535e-1 * t681 + 0.52491393169780936217021346072241076933841385384497e-1 * t685 + 0.22478670955426118383265363956423012380560746650571e-2 * t688 - 0.310907e-1 * t693 - 0.38783294878113014394824731224995739188004877421366e-1 * t697 - 0.96902277115443742137603943210562149050493484994510e-3 * t700
  t703 = t702 * t140
  t705 = 0.1e1 / t149 / t126
  t706 = t148 * t705
  t709 = t146 ** 2
  t710 = t145 * t709
  t711 = t710 * t705
  t715 = t15 + 0.10061550000000000000000000000000000000000000000000e2 * t16 + 0.101578e3
  t716 = 0.1e1 / t715
  t720 = jnp.log(t5 * t13 * t716 / 0.4e1)
  t722 = t16 + 0.201231e2
  t725 = jnp.atan(0.11716852777089929792201907797022178188779527234376e1 / t722)
  t727 = t60 + 0.743294e0
  t728 = t727 ** 2
  t730 = jnp.log(t728 * t716)
  t733 = t15 + 0.65360000000000000000000000000000000000000000000000e1 * t16 + 0.427198e2
  t734 = 0.1e1 / t733
  t738 = jnp.log(t5 * t13 * t734 / 0.4e1)
  t740 = t16 + 0.130720e2
  t743 = jnp.atan(0.44899888641287296627004984787798591621072237693345e-1 / t740)
  t745 = t60 + 0.409286e0
  t746 = t745 ** 2
  t748 = jnp.log(t746 * t734)
  t750 = 0.1554535e-1 * t720 + 0.61881802979060631480216141626488805225499304723700e0 * t725 + 0.26673100072733151593315970562575695370840511204614e-2 * t730 - 0.310907e-1 * t738 - 0.20521972937837502661166379517614390730124411627871e2 * t743 - 0.44313737677495382697984551091739236689629774931818e-2 * t748
  t751 = 0.1e1 / t750
  t752 = t119 * t751
  t753 = jnp.pi ** 2
  t754 = 0.1e1 / t753
  t756 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t757 = 0.1e1 / t756
  t761 = jnp.log(t5 * t13 * t757 / 0.4e1)
  t762 = t16 + 0.106835e1
  t765 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t762)
  t767 = t60 + 0.228344e0
  t768 = t767 ** 2
  t770 = jnp.log(t768 * t757)
  t773 = t754 * (t761 + 0.32323836906055067299704130765928097906535029214058e0 * t765 + 0.21608710360898267021763215722876235716176892439270e-1 * t770)
  t774 = t752 * t773
  t775 = t125 ** 2
  t777 = 0.1e1 / t775 / t123
  t778 = t129 ** 2
  t782 = 0.1e1 / t775
  t783 = t782 * t129
  t784 = 0.1e1 / t155
  t787 = 0.2e1 * t120 * t784 - 0.2e1 * t127
  t790 = t120 * t224
  t792 = 0.6e1 * t784 - 0.6e1 * t790
  t796 = f.my_piecewise3(t124, 0, -0.8e1 / 0.27e2 * t777 * t778 * t129 + 0.4e1 / 0.3e1 * t783 * t787 + 0.4e1 / 0.3e1 * t125 * t792)
  t797 = t135 ** 2
  t799 = 0.1e1 / t797 / t133
  t800 = t136 ** 2
  t804 = 0.1e1 / t797
  t805 = t804 * t136
  t806 = -t787
  t809 = -t792
  t813 = f.my_piecewise3(t134, 0, -0.8e1 / 0.27e2 * t799 * t800 * t136 + 0.4e1 / 0.3e1 * t805 * t806 + 0.4e1 / 0.3e1 * t135 * t809)
  t814 = t796 + t813
  t815 = t814 * t145
  t817 = -t709 * t224 + 0.1e1
  t818 = 0.9e1 * t143
  t819 = t817 * t818
  t820 = t815 * t819
  t828 = f.my_piecewise3(t124, 0, 0.4e1 / 0.9e1 * t782 * t778 + 0.4e1 / 0.3e1 * t125 * t787)
  t834 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t804 * t800 + 0.4e1 / 0.3e1 * t135 * t806)
  t835 = t828 + t834
  t836 = t835 * t145
  t840 = -0.4e1 * t147 * t224 + 0.4e1 * t709 * t151
  t841 = t840 * t818
  t842 = t836 * t841
  t897 = 0.51817833333333333333333333333333333333333333333333e-2 * t428 * t45 + 0.17272611111111111111111111111111111111111111111111e-2 * t43 * t448 + 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t429 + 0.13796274692623141086738355049039257855828824683819e-1 * t358 * t195 * t55 + 0.27592549385246282173476710098078515711657649367639e-1 * t470 * t182 * t185 * t55 - 0.55185098770492564346953420196157031423315298735277e-1 * t52 * t31 * t163 * t55 - 0.30878365944746984533884071665444263610784010246137e0 * t366 * t195 * t368 + 0.22478670955426118383265363956423012380560746650571e-2 * t572 * t18 + 0.37464451592376863972108939927371687300934577750952e-3 * t640 * t27 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t35 - 0.10363566666666666666666666666666666666666666666667e-1 * t396 * t91 - 0.34545222222222222222222222222222222222222222222223e-2 * t90 * t397 - 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t400 - 0.13255248558342256726771310131293653497824588692887e-1 * t441 * t195 * t101 - 0.26510497116684513453542620262587306995649177385775e-1 * t507 * t182 * t185 * t101 + 0.53020994233369026907085240525174613991298354771549e-1 * t98 * t31 * t163 * t101 + 0.50167127350538589836488394571946851238131125013746e0 * t408 * t195 * t410 - 0.96902277115443742137603943210562149050493484994510e-3 * t279 * t75 - 0.16150379519240623689600657201760358175082247499085e-3 * t636 * t27 - 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t84
  t898 = t897 * t140
  t901 = t666 * t751
  t905 = t756 ** 2
  t906 = 0.1e1 / t905
  t907 = t12 * t906
  t909 = -t28 - 0.89029166666666666666666666666666666666666666666667e-1 * t33
  t915 = (-t5 * t11 * t757 / 0.12e2 - t23 * t907 * t909 / 0.4e1) * t40 * t42
  t916 = t44 * t756
  t919 = t762 ** 2
  t920 = 0.1e1 / t919
  t922 = t920 * t29 * t2
  t924 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t920
  t925 = 0.1e1 / t924
  t930 = t767 * t757
  t931 = t930 * t29
  t934 = t768 * t906
  t936 = -t931 * t27 / 0.6e1 - t934 * t909
  t937 = 0.1e1 / t768
  t938 = t936 * t937
  t942 = t754 * (t915 * t916 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t922 * t31 * t10 * t925 + 0.21608710360898267021763215722876235716176892439270e-1 * t938 * t756)
  t944 = t673 * t145
  t945 = t944 * t819
  t948 = t710 * t151
  t951 = t897 * t751
  t952 = t951 * t773
  t953 = t836 * t819
  t956 = t919 ** 2
  t958 = 0.1e1 / t956 / t762
  t959 = t958 * t2
  t960 = t959 * t4
  t961 = t924 ** 2
  t962 = 0.1e1 / t961
  t966 = t920 * t222
  t970 = t768 ** 2
  t971 = 0.1e1 / t970
  t972 = t936 * t971
  t973 = t972 * t756
  t976 = t919 * t762
  t977 = 0.1e1 / t976
  t978 = t977 * t2
  t979 = t978 * t4
  t983 = 0.1e1 / t956
  t984 = t983 * t40
  t985 = t984 * t181
  t986 = t925 * t29
  t991 = 0.1e1 / t956 / t919
  t992 = t991 * t40
  t993 = t992 * t181
  t994 = t962 * t29
  t998 = t978 * t209
  t999 = t3 * t925
  t1003 = t959 * t209
  t1004 = t3 * t962
  t1008 = t956 ** 2
  t1009 = 0.1e1 / t1008
  t1010 = t1009 * t40
  t1011 = t1010 * t181
  t1013 = 0.1e1 / t961 / t924
  t1014 = t1013 * t29
  t1018 = t380 * t756
  t1022 = t5 * t195 * t757
  t1024 = t10 * t906
  t1029 = 0.1e1 / t905 / t756
  t1030 = t12 * t1029
  t1031 = t909 ** 2
  t1037 = t197 - 0.59352777777777777777777777777777777777777777777778e-1 * t199 + 0.11870555555555555555555555555555555555555555555556e0 * t202
  t1043 = (t1022 / 0.9e1 + t23 * t1024 * t909 / 0.6e1 + t23 * t1030 * t1031 / 0.2e1 - t23 * t907 * t1037 / 0.4e1) * t40 * t42
  t1044 = t218 * t756
  t1047 = t44 * t1037
  t1050 = 0.19733478911420229683621075865799807258860149091757e2 * t960 * t158 * t962 + 0.14420896359956903410707543094073145654541709205109e1 * t966 * t656 * t925 + 0.90036293170409445924013398845317648817403718496958e-3 * t973 * t196 - 0.44063849988757204866050826120779056166655222571167e0 * t979 * t158 * t925 + 0.24034827266594839017845905156788576090902848675182e0 * t985 * t231 * t986 - 0.25115336796353019597335914738290663784003826116781e2 * t993 * t231 * t994 + 0.20029022722162365848204920963990480075752373895984e-1 * t998 * t158 * t999 - 0.89697631415546498561913981208180942085727950417076e0 * t1003 * t158 * t1004 + 0.64272053155397178166610502978456596616246611440970e3 * t1011 * t231 * t1014 - 0.2e1 / 0.27e2 * t915 * t1018 + 0.2e1 / 0.9e1 * t1043 * t1044 + t915 * t1047 / 0.3e1
  t1051 = t218 * t909
  t1054 = t44 * t909
  t1058 = t5 * t158 * t757
  t1060 = t163 * t906
  t1062 = t23 * t1060 * t909
  t1064 = t10 * t1029
  t1071 = t905 ** 2
  t1072 = 0.1e1 / t1071
  t1073 = t12 * t1072
  t1074 = t1031 * t909
  t1078 = t909 * t1037
  t1085 = -t248 - 0.35611666666666666666666666666666666666666666666667e0 * t225 + 0.23741111111111111111111111111111111111111111111111e0 * t251 - 0.27697962962962962962962962962962962962962962962964e0 * t254
  t1091 = (-0.7e1 / 0.27e2 * t1058 - t1062 / 0.3e1 - t23 * t1064 * t1031 / 0.2e1 + t23 * t1024 * t1037 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t1073 * t1074 + 0.3e1 / 0.2e1 * t23 * t1030 * t1078 - t23 * t907 * t1085 / 0.4e1) * t40 * t42
  t1095 = t767 * t906
  t1096 = t1095 * t30
  t1097 = t10 * t909
  t1101 = t930 * t178
  t1106 = t768 * t1029
  t1110 = t1022 / 0.72e2 + t1096 * t31 * t1097 / 0.3e1 - t1101 * t270 / 0.9e1 + 0.2e1 / 0.9e1 * t931 * t196 + 0.2e1 * t1106 * t1031 - t934 * t1037
  t1112 = 0.1e1 / t768 / t767
  t1113 = t1110 * t1112
  t1114 = t756 * t29
  t1115 = t1113 * t1114
  t1118 = t936 * t1112
  t1119 = t909 * t29
  t1120 = t1118 * t1119
  t1123 = t756 * t178
  t1124 = t1118 * t1123
  t1128 = t920 * t178 * t40
  t1137 = t1118 * t1114
  t1142 = t767 * t1029
  t1143 = t1142 * t30
  t1147 = t1095 * t179
  t1169 = t768 * t1072
  t1175 = -0.11e2 / 0.216e3 * t1058 - t1062 / 0.24e2 - t1143 * t31 * t10 * t1031 + t1147 * t182 * t185 * t909 / 0.3e1 - 0.2e1 / 0.3e1 * t1096 * t31 * t163 * t909 + t1096 * t31 * t10 * t1037 / 0.2e1 + t211 * t212 * t757 / 0.432e3 - 0.2e1 / 0.3e1 * t930 * t225 + 0.4e1 / 0.9e1 * t1101 * t232 - 0.14e2 / 0.27e2 * t931 * t235 - 0.6e1 * t1169 * t1074 + 0.6e1 * t1106 * t1078 - t934 * t1085
  t1176 = t1175 * t937
  t1179 = t1110 * t937
  t1184 = 0.2e1 / 0.9e1 * t915 * t1051 + 0.2e1 / 0.3e1 * t1043 * t1054 + t1091 * t916 / 0.3e1 + 0.72029034536327556739210719076254119053922974797566e-2 * t1115 * t27 + 0.72029034536327556739210719076254119053922974797566e-2 * t1120 * t27 + 0.24009678178775852246403573025418039684640991599189e-2 * t1124 * t270 - 0.96139309066379356071383620627154304363611394700724e0 * t1128 * t182 * t230 * t925 + 0.11216252724410924874994755739834668842421329381751e1 * t922 * t31 * t157 * t925 - 0.48019356357551704492807146050836079369281983198377e-2 * t1137 * t196 + 0.21608710360898267021763215722876235716176892439270e-1 * t1176 * t756 + 0.43217420721796534043526431445752471432353784878540e-1 * t1179 * t909 + 0.21608710360898267021763215722876235716176892439270e-1 * t938 * t1037
  t1186 = t754 * (t1050 + t1184)
  t1190 = -0.384e3 * t141 * t152 + 0.16e2 * t674 * t675 + 0.960e3 * t703 * t706 + 0.240e3 * t141 * t711 - t774 * t820 / 0.6e1 - t774 * t842 / 0.2e1 + 0.48e2 * t898 * t675 - t901 * t942 * t945 / 0.6e1 - 0.16e2 * t674 * t948 - t952 * t953 / 0.4e1 - t752 * t1186 * t945 / 0.6e1
  t1193 = 0.1e1 / t183 / t149
  t1196 = t42 * t6
  t1199 = 0.17673664744456342302361746841724871330432784923849e-1 * t406 * t3 * t1193 * t101 * t40 * t1196
  t1207 = 0.26755801253620581246127143771704987327003266673998e1 / t404 / t438 * t3 * t1193 * t410 * t40 * t1196
  t1215 = 0.12657832131062950425061722062546552262841476284429e3 / t496 / t94 * t3 * t1193 * t501 * t40 * t1196
  t1220 = t409 ** 2
  t1225 = 0.19162434373246948642083122762742588170998040494372e4 / t496 / t438 * t3 * t1193 / t1220 * t40 * t1196
  t1227 = 0.1e1 / t8 / t149
  t1228 = t7 * t1227
  t1231 = 0.16200859349084980443831601271581132052896719513529e-1 * t521 * t1228 * t522
  t1234 = 0.61315377872880498689041371143490595957715819461244e0 * t516 * t1228 * t517
  t1238 = 0.12112784639430467767200492901320268631311685624314e-3 * t278 * t527 * t75 * t196
  t1240 = 0.14804514559303905048800602434946994993825393540828e-3 * t529 * t235
  t1244 = 0.47129772651883579472964658244599656881154093130267e0 * t507 * t182 * t1193 * t101
  t1248 = 0.41238551070398132038844075964024699771009831488983e0 * t98 * t31 * t1227 * t101
  t1249 = t6 * t1193
  t1252 = 0.19441031218901976532597921525897358463476063416234e0 * t483 * t1249 * t484
  t1253 = t1199 - t1207 + t1215 - t1225 - t1231 + t1234 + t1238 - t1240 + t1244 - t1248 - t1252
  t1257 = 0.17168305804406539632931583920177366868160429449148e2 * t491 * t1249 * t492
  t1260 = 0.37129640917784654580181051383469886637668330434323e3 * t499 * t1249 * t502
  t1263 = 0.12112784639430467767200492901320268631311685624314e-3 * t528 * t84 * t196
  t1265 = 0.31090700000000000000000000000000000000000000000001e-1 * t396 * t445
  t1268 = 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t44 * t256
  t1272 = 0.20435174860777645787105769785744382475812907568201e0 * t439 * t1227 * t101 * t23
  t1276 = 0.77340987998746992664586274965084728992118817729523e1 * t406 * t1227 * t410 * t23
  t1279 = 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t218 * t204
  t1281 = 0.10363566666666666666666666666666666666666666666667e-1 * t307 * t397
  t1284 = 0.38383580246913580246913580246913580246913580246915e-2 * t90 * t269 * t75
  t1285 = t750 ** 2
  t1286 = 0.1e1 / t1285
  t1287 = t119 * t1286
  t1288 = t1287 * t773
  t1292 = t733 ** 2
  t1293 = 0.1e1 / t1292
  t1294 = t12 * t1293
  t1296 = -t28 - 0.10893333333333333333333333333333333333333333333333e1 * t33
  t1302 = (-t5 * t11 * t734 / 0.12e2 - t23 * t1294 * t1296 / 0.4e1) * t40 * t42
  t1303 = t218 * t1296
  t1308 = t197 - 0.72622222222222222222222222222222222222222222222220e0 * t199 + 0.14524444444444444444444444444444444444444444444444e1 * t202
  t1309 = t44 * t1308
  t1315 = t715 ** 2
  t1316 = 0.1e1 / t1315
  t1317 = t12 * t1316
  t1319 = -t28 - 0.16769250000000000000000000000000000000000000000000e1 * t33
  t1325 = (-t5 * t11 * t716 / 0.12e2 - t23 * t1317 * t1319 / 0.4e1) * t40 * t42
  t1328 = t197 - 0.11179500000000000000000000000000000000000000000000e1 * t199 + 0.22359000000000000000000000000000000000000000000000e1 * t202
  t1329 = t44 * t1328
  t1332 = t727 * t716
  t1333 = t1332 * t29
  t1336 = t728 * t1316
  t1338 = -t1333 * t27 / 0.6e1 - t1336 * t1319
  t1340 = 0.1e1 / t728 / t727
  t1341 = t1338 * t1340
  t1342 = t715 * t29
  t1343 = t1341 * t1342
  t1346 = t745 * t734
  t1347 = t1346 * t29
  t1350 = t746 * t1293
  t1352 = -t1347 * t27 / 0.6e1 - t1350 * t1296
  t1354 = 0.1e1 / t746 / t745
  t1355 = t1352 * t1354
  t1356 = t1296 * t29
  t1357 = t1355 * t1356
  t1360 = t733 * t178
  t1361 = t1355 * t1360
  t1365 = t5 * t195 * t734
  t1367 = t745 * t1293
  t1368 = t1367 * t30
  t1369 = t10 * t1296
  t1373 = t1346 * t178
  t1379 = 0.1e1 / t1292 / t733
  t1380 = t746 * t1379
  t1381 = t1296 ** 2
  t1385 = t1365 / 0.72e2 + t1368 * t31 * t1369 / 0.3e1 - t1373 * t270 / 0.9e1 + 0.2e1 / 0.9e1 * t1347 * t196 + 0.2e1 * t1380 * t1381 - t1350 * t1308
  t1386 = t1385 * t1354
  t1387 = t733 * t29
  t1388 = t1386 * t1387
  t1392 = t5 * t195 * t716
  t1394 = t727 * t1316
  t1395 = t1394 * t30
  t1396 = t10 * t1319
  t1400 = t1332 * t178
  t1406 = 0.1e1 / t1315 / t715
  t1407 = t728 * t1406
  t1408 = t1319 ** 2
  t1412 = t1392 / 0.72e2 + t1395 * t31 * t1396 / 0.3e1 - t1400 * t270 / 0.9e1 + 0.2e1 / 0.9e1 * t1333 * t196 + 0.2e1 * t1407 * t1408 - t1336 * t1328
  t1413 = t1412 * t1340
  t1414 = t1413 * t1342
  t1417 = t1319 * t29
  t1418 = t1341 * t1417
  t1421 = t715 * t178
  t1422 = t1341 * t1421
  t1425 = t1355 * t1387
  t1428 = t740 ** 2
  t1429 = 0.1e1 / t1428
  t1430 = t1429 * t222
  t1432 = 0.1e1 + 0.20160000000000000000000000000000000000000000000000e-2 * t1429
  t1433 = 0.1e1 / t1432
  t1437 = -0.69090444444444444444444444444444444444444444444446e-2 * t1302 * t1303 - 0.10363566666666666666666666666666666666666666666667e-1 * t1302 * t1309 + 0.51817833333333333333333333333333333333333333333333e-2 * t1325 * t1329 - 0.59273555717184781318479934583501545268534469343587e-3 * t1343 * t196 - 0.14771245892498460899328183697246412229876591643939e-2 * t1357 * t27 - 0.49237486308328202997760612324154707432921972146465e-3 * t1361 * t270 - 0.14771245892498460899328183697246412229876591643939e-2 * t1388 * t27 + 0.88910333575777171977719901875252317902801704015380e-3 * t1414 * t27 + 0.88910333575777171977719901875252317902801704015380e-3 * t1418 * t27 + 0.29636777858592390659239967291750772634267234671793e-3 * t1422 * t270 + 0.98474972616656405995521224648309414865843944292929e-3 * t1425 * t196 - 0.61428953307227691896295992558865975087351157250442e0 * t1430 * t656 * t1433
  t1438 = t722 ** 2
  t1439 = 0.1e1 / t1438
  t1440 = t1439 * t222
  t1442 = 0.1e1 + 0.13728463900000000000000000000000000000000000000000e1 * t1439
  t1443 = 0.1e1 / t1442
  t1448 = t10 * t1316
  t1452 = t12 * t1406
  t1461 = (t1392 / 0.9e1 + t23 * t1448 * t1319 / 0.6e1 + t23 * t1452 * t1408 / 0.2e1 - t23 * t1317 * t1328 / 0.4e1) * t40 * t42
  t1462 = t218 * t715
  t1465 = t380 * t715
  t1468 = t1438 ** 2
  t1470 = 0.1e1 / t1468 / t722
  t1471 = t1470 * t2
  t1472 = t1471 * t4
  t1473 = t1442 ** 2
  t1474 = 0.1e1 / t1473
  t1479 = t10 * t1293
  t1483 = t12 * t1379
  t1492 = (t1365 / 0.9e1 + t23 * t1479 * t1296 / 0.6e1 + t23 * t1483 * t1381 / 0.2e1 - t23 * t1294 * t1308 / 0.4e1) * t40 * t42
  t1493 = t44 * t1296
  t1496 = t1428 * t740
  t1497 = 0.1e1 / t1496
  t1498 = t1497 * t2
  t1499 = t1498 * t4
  t1504 = t5 * t158 * t734
  t1506 = t163 * t1293
  t1508 = t23 * t1506 * t1296
  t1510 = t10 * t1379
  t1517 = t1292 ** 2
  t1518 = 0.1e1 / t1517
  t1519 = t12 * t1518
  t1520 = t1381 * t1296
  t1524 = t1296 * t1308
  t1531 = -t248 - 0.43573333333333333333333333333333333333333333333332e1 * t225 + 0.29048888888888888888888888888888888888888888888888e1 * t251 - 0.33890370370370370370370370370370370370370370370369e1 * t254
  t1537 = (-0.7e1 / 0.27e2 * t1504 - t1508 / 0.3e1 - t23 * t1510 * t1381 / 0.2e1 + t23 * t1479 * t1308 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t1519 * t1520 + 0.3e1 / 0.2e1 * t23 * t1483 * t1524 - t23 * t1294 * t1531 / 0.4e1) * t40 * t42
  t1538 = t44 * t733
  t1541 = t218 * t733
  t1544 = t380 * t733
  t1547 = t1438 * t722
  t1548 = 0.1e1 / t1547
  t1549 = t1548 * t2
  t1550 = t1549 * t4
  t1555 = t5 * t158 * t716
  t1557 = t163 * t1316
  t1559 = t23 * t1557 * t1319
  t1561 = t10 * t1406
  t1568 = t1315 ** 2
  t1569 = 0.1e1 / t1568
  t1570 = t12 * t1569
  t1571 = t1408 * t1319
  t1575 = t1319 * t1328
  t1582 = -t248 - 0.67077000000000000000000000000000000000000000000000e1 * t225 + 0.44718000000000000000000000000000000000000000000000e1 * t251 - 0.52171000000000000000000000000000000000000000000000e1 * t254
  t1588 = (-0.7e1 / 0.27e2 * t1555 - t1559 / 0.3e1 - t23 * t1561 * t1408 / 0.2e1 + t23 * t1448 * t1328 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t1570 * t1571 + 0.3e1 / 0.2e1 * t23 * t1452 * t1575 - t23 * t1317 * t1582 / 0.4e1) * t40 * t42
  t1589 = t44 * t715
  t1592 = t1428 ** 2
  t1594 = 0.1e1 / t1592 / t740
  t1595 = t1594 * t2
  t1596 = t1595 * t4
  t1597 = t1432 ** 2
  t1598 = 0.1e1 / t1597
  t1602 = 0.48337331672435896699555362735747849302493515162012e0 * t1440 * t656 * t1443 + 0.34545222222222222222222222222222222222222222222222e-2 * t1461 * t1462 - 0.11515074074074074074074074074074074074074074074074e-2 * t1325 * t1465 + 0.20276584560447197672065901047389765208808740088178e0 * t1472 * t158 * t1474 - 0.20727133333333333333333333333333333333333333333334e-1 * t1492 * t1493 + 0.18769957954986239190534886615209047943357298048745e0 * t1499 * t158 * t1433 - 0.10363566666666666666666666666666666666666666666667e-1 * t1537 * t1538 - 0.69090444444444444444444444444444444444444444444446e-2 * t1492 * t1541 + 0.23030148148148148148148148148148148148148148148149e-2 * t1302 * t1544 - 0.14769740233244301769308583058145176175761907410615e0 * t1550 * t158 * t1443 + 0.51817833333333333333333333333333333333333333333333e-2 * t1588 * t1589 - 0.37840235237252258208118331416261440653808312866271e-3 * t1596 * t158 * t1598
  t1604 = t44 * t1319
  t1607 = t218 * t1319
  t1611 = t1439 * t29 * t2
  t1616 = t746 ** 2
  t1617 = 0.1e1 / t1616
  t1618 = t1352 * t1617
  t1619 = t1618 * t733
  t1622 = t1592 ** 2
  t1623 = 0.1e1 / t1622
  t1624 = t1623 * t40
  t1625 = t1624 * t181
  t1627 = 0.1e1 / t1597 / t1432
  t1628 = t1627 * t29
  t1632 = 0.1e1 / t1592
  t1633 = t1632 * t40
  t1634 = t1633 * t181
  t1635 = t1433 * t29
  t1640 = 0.1e1 / t1592 / t1428
  t1641 = t1640 * t40
  t1642 = t1641 * t181
  t1643 = t1598 * t29
  t1647 = t1498 * t209
  t1648 = t3 * t1433
  t1652 = t1595 * t209
  t1653 = t3 * t1598
  t1657 = t728 ** 2
  t1658 = 0.1e1 / t1657
  t1659 = t1338 * t1658
  t1660 = t1659 * t715
  t1663 = t1468 ** 2
  t1664 = 0.1e1 / t1663
  t1665 = t1664 * t40
  t1666 = t1665 * t181
  t1668 = 0.1e1 / t1473 / t1442
  t1669 = t1668 * t29
  t1673 = 0.1e1 / t1468
  t1674 = t1673 * t40
  t1675 = t1674 * t181
  t1676 = t1443 * t29
  t1680 = 0.10363566666666666666666666666666666666666666666667e-1 * t1461 * t1604 + 0.34545222222222222222222222222222222222222222222222e-2 * t1325 * t1607 + 0.37595702411894586321876393238914993901939400681566e0 * t1611 * t31 * t157 * t1443 - 0.18464057365623076124160229621558015287345739554924e-3 * t1619 * t196 - 0.55480664900582220034593859007405864987692769991566e-6 * t1625 * t231 * t1628 - 0.10238158884537948649382665426477662514558526208407e0 * t1634 * t231 * t1635 + 0.48160299392866510446696058166150924468483307284345e-3 * t1642 * t231 * t1643 - 0.85317990704482905411522211887313854287987718403392e-2 * t1647 * t158 * t1648 + 0.17200106926023753730962877916482473024458324030124e-4 * t1652 * t158 * t1653 + 0.11113791696972146497214987734406539737850213001922e-3 * t1660 * t196 + 0.20244826120247034261608782614550005883535036385819e0 * t1666 * t231 * t1669 + 0.80562219454059827832592271226246415504155858603354e-1 * t1675 * t231 * t1676
  t1682 = 0.1e1 / t1468 / t1438
  t1683 = t1682 * t40
  t1684 = t1683 * t181
  t1685 = t1474 * t29
  t1689 = t1549 * t209
  t1690 = t3 * t1443
  t1694 = t1471 * t209
  t1695 = t3 * t1474
  t1700 = t1429 * t178 * t40
  t1706 = t1429 * t29 * t2
  t1712 = t1439 * t178 * t40
  t1719 = t745 * t1379
  t1720 = t1719 * t30
  t1724 = t1367 * t179
  t1746 = t746 * t1518
  t1752 = -0.11e2 / 0.216e3 * t1504 - t1508 / 0.24e2 - t1720 * t31 * t10 * t1381 + t1724 * t182 * t185 * t1296 / 0.3e1 - 0.2e1 / 0.3e1 * t1368 * t31 * t163 * t1296 + t1368 * t31 * t10 * t1308 / 0.2e1 + t211 * t212 * t734 / 0.432e3 - 0.2e1 / 0.3e1 * t1346 * t225 + 0.4e1 / 0.9e1 * t1373 * t232 - 0.14e2 / 0.27e2 * t1347 * t235 - 0.6e1 * t1746 * t1520 + 0.6e1 * t1380 * t1524 - t1350 * t1531
  t1753 = 0.1e1 / t746
  t1754 = t1752 * t1753
  t1757 = 0.1e1 / t728
  t1758 = t1412 * t1757
  t1761 = t1338 * t1757
  t1764 = t1385 * t1753
  t1767 = t1352 * t1753
  t1772 = t727 * t1406
  t1773 = t1772 * t30
  t1777 = t1394 * t179
  t1799 = t728 * t1569
  t1805 = -0.11e2 / 0.216e3 * t1555 - t1559 / 0.24e2 - t1773 * t31 * t10 * t1408 + t1777 * t182 * t185 * t1319 / 0.3e1 - 0.2e1 / 0.3e1 * t1395 * t31 * t163 * t1319 + t1395 * t31 * t10 * t1328 / 0.2e1 + t211 * t212 * t716 / 0.432e3 - 0.2e1 / 0.3e1 * t1332 * t225 + 0.4e1 / 0.9e1 * t1400 * t232 - 0.14e2 / 0.27e2 * t1333 * t235 - 0.6e1 * t1799 * t1571 + 0.6e1 * t1407 * t1575 - t1336 * t1582
  t1806 = t1805 * t1757
  t1809 = -0.25806562167841887946265692242132428447574760112225e0 * t1684 * t231 * t1685 + 0.67135182878383189860493559355205346253463215502794e-2 * t1689 * t158 * t1690 - 0.92166293456578171236663186579044387312767000400800e-2 * t1694 * t158 * t1695 + 0.40952635538151794597530661705910650058234104833627e0 * t1700 * t182 * t230 * t1433 - 0.47778074794510427030452438656895758401273122305897e0 * t1706 * t31 * t157 * t1433 - 0.32224887781623931133036908490498566201662343441341e0 * t1712 * t182 * t230 * t1443 - 0.44313737677495382697984551091739236689629774931818e-2 * t1754 * t733 + 0.53346200145466303186631941125151390741681022409228e-2 * t1758 * t1319 + 0.26673100072733151593315970562575695370840511204614e-2 * t1761 * t1328 - 0.88627475354990765395969102183478473379259549863636e-2 * t1764 * t1296 - 0.44313737677495382697984551091739236689629774931818e-2 * t1767 * t1308 + 0.26673100072733151593315970562575695370840511204614e-2 * t1806 * t715
  t1811 = t1437 + t1602 + t1680 + t1809
  t1812 = t819 * t1811
  t1813 = t944 * t1812
  t1816 = t1257 - t1260 + t1263 + t1265 + t1268 + t1272 - t1276 + t1279 + t1281 + t1284 + t1288 * t1813 / 0.6e1
  t1817 = t123 ** 2
  t1820 = t778 ** 2
  t1826 = t787 ** 2
  t1831 = t120 * t151
  t1833 = -0.24e2 * t224 + 0.24e2 * t1831
  t1837 = f.my_piecewise3(t124, 0, 0.40e2 / 0.81e2 / t775 / t1817 * t1820 - 0.16e2 / 0.9e1 * t777 * t778 * t787 + 0.4e1 / 0.3e1 * t782 * t1826 + 0.16e2 / 0.9e1 * t783 * t792 + 0.4e1 / 0.3e1 * t125 * t1833)
  t1838 = t133 ** 2
  t1841 = t800 ** 2
  t1847 = t806 ** 2
  t1856 = f.my_piecewise3(t134, 0, 0.40e2 / 0.81e2 / t797 / t1838 * t1841 - 0.16e2 / 0.9e1 * t799 * t800 * t806 + 0.4e1 / 0.3e1 * t804 * t1847 + 0.16e2 / 0.9e1 * t805 * t809 - 0.4e1 / 0.3e1 * t135 * t1833)
  t1857 = t1837 + t1856
  t1859 = t710 * t224
  t1861 = t752 * t942
  t1862 = t140 * t145
  t1863 = t1862 * t841
  t1865 = t702 * t751
  t1893 = t754 * (t1043 * t916 / 0.3e1 + t915 * t1044 / 0.9e1 + t915 * t1054 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t979 * t195 * t925 + 0.24034827266594839017845905156788576090902848675181e0 * t1128 * t182 * t185 * t925 - 0.48069654533189678035691810313577152181805697350363e0 * t922 * t31 * t163 * t925 - 0.53818578849327899137148388724908565251436770250246e1 * t960 * t195 * t962 + 0.21608710360898267021763215722876235716176892439270e-1 * t1179 * t756 + 0.36014517268163778369605359538127059526961487398783e-2 * t1137 * t27 + 0.21608710360898267021763215722876235716176892439270e-1 * t938 * t909)
  t1894 = t1865 * t1893
  t1897 = t1865 * t942
  t1907 = (-0.12e2 * t146 * t224 + 0.32e2 * t147 * t151 - 0.20e2 * t709 * t705) * t818
  t1908 = t1862 * t1907
  t1911 = t702 * t1286
  t1929 = 0.51817833333333333333333333333333333333333333333333e-2 * t1325 * t1589 + 0.12084332918108974174888840683936962325623378790503e0 * t1611 * t31 * t10 * t1443 + 0.26673100072733151593315970562575695370840511204614e-2 * t1761 * t715 - 0.10363566666666666666666666666666666666666666666667e-1 * t1302 * t1538 - 0.15357238326806922974073998139716493771837789312610e0 * t1706 * t31 * t10 * t1433 - 0.44313737677495382697984551091739236689629774931818e-2 * t1767 * t733
  t1930 = t819 * t1929
  t1931 = t944 * t1930
  t1934 = t1907 * t1929
  t1935 = t944 * t1934
  t1938 = t1911 * t773
  t1945 = 0.1e1 / t149 / t155
  t1949 = (0.144e3 * t146 * t151 - 0.240e3 * t147 * t705 + 0.120e3 * t709 * t1945 - 0.24e2 * t790) * t818
  t2006 = 0.51817833333333333333333333333333333333333333333333e-2 * t1461 * t1589 + 0.17272611111111111111111111111111111111111111111111e-2 * t1325 * t1462 + 0.51817833333333333333333333333333333333333333333333e-2 * t1325 * t1604 + 0.40281109727029913916296135613123207752077929301677e-1 * t1550 * t195 * t1443 + 0.80562219454059827832592271226246415504155858603353e-1 * t1712 * t182 * t185 * t1443 - 0.16112443890811965566518454245249283100831171720671e0 * t1611 * t31 * t163 * t1443 - 0.55299776073946902741997911947426632387660200240483e-1 * t1472 * t195 * t1474 + 0.26673100072733151593315970562575695370840511204614e-2 * t1758 * t715 + 0.44455166787888585988859950937626158951400852007690e-3 * t1343 * t27 + 0.26673100072733151593315970562575695370840511204614e-2 * t1761 * t1319 - 0.10363566666666666666666666666666666666666666666667e-1 * t1492 * t1538 - 0.34545222222222222222222222222222222222222222222223e-2 * t1302 * t1541 - 0.10363566666666666666666666666666666666666666666667e-1 * t1302 * t1493 - 0.51190794422689743246913327132388312572792631042033e-1 * t1499 * t195 * t1433 - 0.10238158884537948649382665426477662514558526208407e0 * t1700 * t182 * t185 * t1433 + 0.20476317769075897298765330852955325029117052416813e0 * t1706 * t31 * t163 * t1433 + 0.10320064155614252238577726749889483814674994418074e-3 * t1596 * t195 * t1598 - 0.44313737677495382697984551091739236689629774931818e-2 * t1764 * t733 - 0.73856229462492304496640918486232061149382958219697e-3 * t1425 * t27 - 0.44313737677495382697984551091739236689629774931818e-2 * t1767 * t1296
  t2007 = t819 * t2006
  t2011 = t951 * t942
  t2012 = t1862 * t819
  t2017 = t702 * t1857 * t1859 - t1861 * t1863 - t1894 * t953 / 0.4e1 - t1897 * t842 / 0.2e1 - t1897 * t1908 / 0.2e1 + t1911 * t1186 * t1931 / 0.6e1 + t1288 * t1935 / 0.2e1 + t1938 * t944 * t1949 * t1929 / 0.6e1 + t1938 * t836 * t2007 / 0.4e1 - t2011 * t2012 / 0.2e1 - t1861 * t953 / 0.2e1
  t2020 = t702 * t835
  t2021 = t145 * t146
  t2022 = t2021 * t224
  t2025 = t702 * t673
  t2026 = t145 * t120
  t2030 = t702 * t814
  t2033 = t752 * t1893
  t2034 = t944 * t841
  t2039 = t944 * t1907
  t2044 = t901 * t773
  t2047 = t1865 * t1186
  t2052 = t897 * t1286
  t2053 = t2052 * t773
  t2054 = t1862 * t1930
  t2057 = 0.72e2 * t2020 * t2022 - 0.384e3 * t2025 * t2026 * t151 - 0.16e2 * t2030 * t948 - t2033 * t2034 / 0.2e1 - t2011 * t2034 / 0.2e1 - t1894 * t2039 / 0.4e1 - t2033 * t2012 / 0.2e1 - t2044 * t2012 / 0.6e1 - t2047 * t2012 / 0.6e1 - t1894 * t1863 / 0.2e1 + t2053 * t2054 / 0.2e1
  t2061 = t841 * t1929
  t2065 = t836 * t1930
  t2068 = t1911 * t942
  t2073 = t841 * t2006
  t2074 = t944 * t2073
  t2077 = t1911 * t1893
  t2080 = t1285 ** 2
  t2085 = t1929 ** 2
  t2086 = t2085 ** 2
  t2090 = t1287 * t942
  t2091 = t944 * t2061
  t2093 = t1862 * t2007
  t2102 = t182 * t230 * t29
  t2104 = 0.53834598397468745632002190672534527250274158330283e-4 * t114 / t526 / t106 * t75 * t40 * t2102
  t2105 = t1938 * t815 * t1930 / 0.6e1 + t1938 * t836 * t2061 / 0.2e1 + t1288 * t2065 / 0.2e1 + t2068 * t2065 / 0.2e1 + t2068 * t1935 / 0.2e1 + t1288 * t2074 / 0.2e1 + t2077 * t2054 / 0.2e1 - t702 / t2080 / t750 * t773 * t944 * t819 * t2086 + t2090 * t2091 + t1288 * t2093 / 0.2e1 + t2104
  t2108 = t1193 * t3
  t2111 = 0.84385547540419669500411480416977015085609841896189e1 * t498 * t1196 * t2108 * t502
  t2115 = 0.44184161861140855755904367104312178326081962309624e-2 * t482 * t1196 * t2108 * t484
  t2124 = t944 * t2007
  t2130 = t1862 * t2061
  t2136 = 0.1e1 / t1285 / t750
  t2137 = t702 * t2136
  t2138 = t2137 * t773
  t2139 = t2006 ** 2
  t2146 = t2111 + t2115 - t952 * t2039 / 0.4e1 + t2077 * t2091 / 0.2e1 + t666 * t1286 * t773 * t1931 / 0.6e1 + t2053 * t2124 / 0.4e1 + t1938 * t1862 * t2073 / 0.2e1 + t1288 * t2130 + t1938 * t1862 * t1934 / 0.2e1 - t2138 * t944 * t819 * t2139 / 0.4e1 + t2090 * t2124 / 0.2e1
  t2152 = t1865 * t773
  t2209 = t1597 ** 2
  t2217 = 0.55040342163276011939081209332743913678266636896394e-3 / t1592 / t1496 * t3 * t1193 * t1598 * t40 * t1196 + 0.50612065300617585654021956536375014708837590964548e0 / t1663 / t722 * t3 * t1193 * t1668 * t40 * t1196 - 0.55392172096869228372480688864674045862037218664772e-3 * t1385 * t1617 * t733 * t196 - 0.40750569555564537156454955026157312372117447673715e-3 * t1660 * t235 - 0.55392172096869228372480688864674045862037218664772e-3 * t1618 * t1296 * t196 + 0.62566526516620797301782955384030159811190993495820e-1 * t1647 * t1228 * t1648 - 0.12613411745750752736039443805420480217936104288757e-3 * t1652 * t1228 * t1653 - 0.49232467444147672564361943527150587252539691368716e-1 * t1689 * t1228 * t1690 + 0.67588615201490658906886336824632550696029133627253e-1 * t1694 * t1228 * t1695 - 0.13870166225145555008648464751851466246923192497891e-5 / t1622 / t740 * t3 * t1193 * t1627 * t40 * t1196 + 0.11184902043957375558974121975893022381518862430300e-8 / t1622 / t1496 * t3 * t1193 / t2209 * t40 * t1196 + 0.67701543673951279121920841945712722720267711701388e-3 * t1619 * t235
  t2257 = t1473 ** 2
  t2277 = 0.33341375090916439491644963203219619213550639005767e-3 * t1412 * t1658 * t715 * t196 + 0.33341375090916439491644963203219619213550639005767e-3 * t1659 * t1319 * t196 - 0.59078960932977207077234332232580704703047629642460e0 * t1675 * t1249 * t1676 + 0.18924812256417384493928174310897114194888157415632e1 * t1684 * t1249 * t1685 + 0.40685820927093628025368829938764300990974697993815e-5 * t1625 * t1249 * t1628 - 0.18201171350289686487791405202626955581437379926057e1 * t1700 * t182 * t1193 * t1433 + 0.15926024931503475676817479552298586133757707435299e1 * t1706 * t31 * t1227 * t1433 + 0.14322172347388413836905292662443807200738819307263e1 * t1712 * t182 * t1193 * t1443 - 0.12531900803964862107292131079638331300646466893855e1 * t1611 * t31 * t1227 * t1443 - 0.14846205821514491791846440584003337647925693349601e1 * t1666 * t1249 * t1669 - 0.27793036455358846894255932804679737051689835140790e0 / t1663 / t1547 * t3 * t1193 / t2257 * t40 * t1196 + 0.53708146302706551888394847484164277002770572402236e-1 * t1470 * t3 * t1193 * t1443 * t40 * t1196 - 0.29493213906105014795732219705294203940085440128257e0 / t1468 / t1547 * t3 * t1193 * t1474 * t40 * t1196
  t2315 = 0.75079831819944956762139546460836191773429192194982e0 * t1634 * t1249 * t1635 - 0.35317552888102107660910442655177344610221092008520e-2 * t1642 * t1249 * t1643 - 0.68254392563586324329217769509851083430390174722713e-1 * t1594 * t3 * t1193 * t1433 * t40 * t1196 + 0.15545350000000000000000000000000000000000000000000e-1 * t1588 * t1604 - 0.10363566666666666666666666666666666666666666666667e-1 * t1302 * t44 * t1531 + 0.15545350000000000000000000000000000000000000000000e-1 * t1461 * t1329 - 0.10363566666666666666666666666666666666666666666667e-1 * t1302 * t218 * t1308 + 0.10363566666666666666666666666666666666666666666667e-1 * t1461 * t1607 + 0.69090444444444444444444444444444444444444444444446e-2 * t1302 * t380 * t1296 + 0.17782066715155434395543980375050463580560340803076e-2 * t1341 * t715 * t225 + 0.51817833333333333333333333333333333333333333333333e-2 * t1588 * t1462 + 0.62100044162504450620956542403564945284453474340086e0 * t1548 * t1227 * t1443 * t23
  t2343 = 0.1e1 / t16 / t3 / t121 / 0.48e2
  t2346 = 0.1e1 / t8 / t150
  t2347 = t3 * t2346
  t2360 = t5 * t1228 * t716
  t2364 = t23 * t157 * t1316 * t1319
  t2368 = t23 * t163 * t1406 * t1408
  t2371 = t23 * t1557 * t1328
  t2384 = 0.1e1 / t1568 / t715
  t2386 = t1408 ** 2
  t2390 = t1408 * t1328
  t2394 = t1328 ** 2
  t2398 = t1319 * t1582
  t2402 = t5 * t1228
  t2403 = 0.70e2 / 0.81e2 * t2402
  t2404 = t2343 * t3
  t2406 = t2404 * t2346 * t23
  t2408 = t223 * t151
  t2411 = t179 * t182 * t1193
  t2414 = t30 * t31 * t1227
  t2416 = t2403 - 0.55897500000000000000000000000000000000000000000000e1 * t2406 + 0.53661600000000000000000000000000000000000000000000e2 * t2408 - 0.19874666666666666666666666666666666666666666666667e2 * t2411 + 0.17390333333333333333333333333333333333333333333333e2 * t2414
  t2420 = 0.70e2 / 0.81e2 * t2360 + 0.28e2 / 0.27e2 * t2364 + 0.4e1 / 0.3e1 * t2368 - 0.2e1 / 0.3e1 * t2371 + 0.2e1 * t23 * t10 * t1569 * t1571 - 0.2e1 * t23 * t1561 * t1575 + t23 * t1448 * t1582 / 0.3e1 + 0.6e1 * t23 * t12 * t2384 * t2386 - 0.9e1 * t23 * t1570 * t2390 + 0.3e1 / 0.2e1 * t23 * t1452 * t2394 + 0.2e1 * t23 * t1452 * t2398 - t23 * t1317 * t2416 / 0.4e1
  t2429 = t5 * t1228 * t734
  t2433 = t23 * t157 * t1293 * t1296
  t2437 = t23 * t163 * t1379 * t1381
  t2440 = t23 * t1506 * t1308
  t2453 = 0.1e1 / t1517 / t733
  t2455 = t1381 ** 2
  t2459 = t1381 * t1308
  t2463 = t1308 ** 2
  t2467 = t1296 * t1531
  t2475 = t2403 - 0.36311111111111111111111111111111111111111111111110e1 * t2406 + 0.34858666666666666666666666666666666666666666666666e2 * t2408 - 0.12910617283950617283950617283950617283950617283950e2 * t2411 + 0.11296790123456790123456790123456790123456790123456e2 * t2414
  t2479 = 0.70e2 / 0.81e2 * t2429 + 0.28e2 / 0.27e2 * t2433 + 0.4e1 / 0.3e1 * t2437 - 0.2e1 / 0.3e1 * t2440 + 0.2e1 * t23 * t10 * t1518 * t1520 - 0.2e1 * t23 * t1510 * t1524 + t23 * t1479 * t1531 / 0.3e1 + 0.6e1 * t23 * t12 * t2453 * t2455 - 0.9e1 * t23 * t1519 * t2459 + 0.3e1 / 0.2e1 * t23 * t1483 * t2463 + 0.2e1 * t23 * t1483 * t2467 - t23 * t1294 * t2475 / 0.4e1
  t2487 = -0.85253821447334808393913447585616058264309475370748e0 * t1470 * t1227 * t1474 * t23 - 0.34545222222222222222222222222222222222222222222222e-2 * t1461 * t1465 + 0.88910333575777171977719901875252317902801704015380e-3 * t1341 * t1319 * t178 * t270 - 0.44313737677495382697984551091739236689629774931817e-2 * t1386 * t1356 * t27 - 0.22156868838747691348992275545869618344814887465909e-2 * t1355 * t1308 * t29 * t27 - 0.14771245892498460899328183697246412229876591643939e-2 * t1355 * t1296 * t178 * t270 - 0.14771245892498460899328183697246412229876591643939e-2 * t1386 * t1360 * t270 - 0.51190794422689743246913327132388312572792631042035e0 * t1429 * t2343 * t2347 * t1433 * t2 * t31 + 0.40281109727029913916296135613123207752077929301677e0 * t1439 * t2343 * t2347 * t1443 * t2 * t31 + 0.51817833333333333333333333333333333333333333333333e-2 * t2420 * t40 * t42 * t1589 + 0.51817833333333333333333333333333333333333333333333e-2 * t1325 * t44 * t1582 - 0.10363566666666666666666666666666666666666666666667e-1 * t2479 * t40 * t42 * t1538 - 0.34545222222222222222222222222222222222222222222222e-2 * t1325 * t380 * t1319
  t2523 = 0.51817833333333333333333333333333333333333333333333e-2 * t1325 * t218 * t1328 - 0.31090700000000000000000000000000000000000000000001e-1 * t1492 * t1309 - 0.20727133333333333333333333333333333333333333333334e-1 * t1492 * t1303 - 0.31090700000000000000000000000000000000000000000001e-1 * t1537 * t1493 - 0.29542491784996921798656367394492824459753183287879e-2 * t1355 * t733 * t225 + 0.69090444444444444444444444444444444444444444444446e-2 * t1492 * t1544 - 0.38383580246913580246913580246913580246913580246915e-2 * t1302 * t269 * t733 - 0.10363566666666666666666666666666666666666666666667e-1 * t1537 * t1541 - 0.78919141401646687505658045995765315216388639523133e0 * t1497 * t1227 * t1433 * t23 + 0.15910098906571972201140662072746287547623949727864e-2 * t1594 * t1227 * t1598 * t23 + 0.26673100072733151593315970562575695370840511204614e-2 * t1413 * t1417 * t27 + 0.88910333575777171977719901875252317902801704015380e-3 * t1413 * t1421 * t270
  t2527 = t209 * t7 * t212
  t2571 = -0.30773428942705126873600382702596692145576232591541e-4 * t1618 * t733 * t2 * t2527 + 0.13427036575676637972098711871041069250692643100559e-1 * t1674 * t1196 * t2108 * t1676 - 0.43010936946403146577109487070220714079291266853706e-1 * t1683 * t1196 * t2108 * t1685 + 0.33741376867078390436014637690916676472558393976364e-1 * t1665 * t1196 * t2108 * t1669 - 0.22977493610553161398954952417938863468696920335017e-2 * t1425 * t235 + 0.29542491784996921798656367394492824459753183287878e-2 * t1388 * t196 + 0.13830496334009782307645318069483693895991376180170e-2 * t1343 * t235 + 0.29542491784996921798656367394492824459753183287878e-2 * t1357 * t196 + 0.19694994523331281199104244929661882973168788858586e-2 * t1361 * t232 + 0.13336550036366575796657985281287847685420255602307e-2 * t1341 * t1328 * t29 * t27 - 0.22156868838747691348992275545869618344814887465909e-2 * t1752 * t1354 * t1387 * t27 + 0.14818388929296195329619983645875386317133617335896e-3 * t1338 / t1657 / t727 * t715 * t40 * t2102 - 0.17063598140896581082304442377462770857597543680678e-1 * t1633 * t1196 * t2108 * t1635
  t2602 = t3 * t151
  t2619 = 0.80267165654777517411160096943584874114138845473912e-4 * t1641 * t1196 * t2108 * t1643 - 0.92467774834303700057656431679009774979487949985947e-7 * t1624 * t1196 * t2108 * t1628 - 0.24618743154164101498880306162077353716460986073232e-3 * t1352 / t1616 / t745 * t733 * t40 * t2102 - 0.17782066715155434395543980375050463580560340803076e-2 * t1414 * t196 - 0.17782066715155434395543980375050463580560340803076e-2 * t1418 * t196 - 0.11854711143436956263695986916700309053706893868717e-2 * t1422 * t232 + 0.18522986161620244162024979557344232896417021669871e-4 * t1659 * t715 * t2 * t2527 + 0.13336550036366575796657985281287847685420255602307e-2 * t1805 * t1340 * t1342 * t27 - 0.38669865337948717359644290188598279441994812129610e1 * t1440 * t2602 * t1443 + 0.49143162645782153517036794047092780069880925800353e1 * t1430 * t2602 * t1433 - 0.11096132980116444006918771801481172997538553998313e-5 * t1623 * t3 * t151 * t1627 * t178 - 0.20476317769075897298765330852955325029117052416814e0 * t1632 * t3 * t151 * t1433 * t178
  t2653 = t216 * t1249
  t2693 = t2346 * t2 * t31
  t2696 = 0.140e3 / 0.81e2 * t1347 * t2402 - t211 * t212 * t1293 * t1296 / 0.108e3 - 0.160e3 / 0.81e2 * t1373 * t2653 + 0.4e1 * t745 * t1518 * t30 * t31 * t10 * t1520 + 0.8e1 / 0.3e1 * t1720 * t31 * t163 * t1381 - 0.16e2 / 0.9e1 * t1724 * t182 * t230 * t1296 + 0.56e2 / 0.27e2 * t1368 * t31 * t157 * t1296 - 0.4e1 / 0.3e1 * t1719 * t179 * t182 * t185 * t1381 + 0.2e1 / 0.3e1 * t1724 * t182 * t185 * t1308 - 0.4e1 / 0.3e1 * t1368 * t31 * t163 * t1308 + 0.2e1 / 0.3e1 * t1368 * t31 * t10 * t1531 - 0.5e1 / 0.9e1 * t1346 * t2404 * t2693
  t2717 = t1227 * t3
  t2725 = -0.4e1 * t1720 * t31 * t1369 * t1308 + 0.11e2 / 0.54e2 * t2433 + t2437 / 0.6e1 - t2440 / 0.12e2 - 0.36e2 * t1746 * t2459 + 0.8e1 * t1380 * t2467 + 0.16e2 / 0.3e1 * t1346 * t2408 + 0.185e3 / 0.864e3 * t2429 + 0.24e2 * t746 * t2453 * t2455 + 0.6e1 * t1380 * t2463 - t1350 * t2475 - 0.11e2 / 0.648e3 * t211 * t2717 * t734 + 0.8e1 / 0.3e1 * t1367 * t222 * t656 * t1296
  t2779 = 0.16e2 / 0.3e1 * t1332 * t2408 - 0.160e3 / 0.81e2 * t1400 * t2653 - t211 * t212 * t1316 * t1319 / 0.108e3 + 0.140e3 / 0.81e2 * t1333 * t2402 - 0.11e2 / 0.648e3 * t211 * t2717 * t716 + 0.8e1 / 0.3e1 * t1394 * t222 * t656 * t1319 - 0.4e1 / 0.3e1 * t1772 * t179 * t182 * t185 * t1408 + 0.2e1 / 0.3e1 * t1777 * t182 * t185 * t1328 - 0.4e1 / 0.3e1 * t1395 * t31 * t163 * t1328 + 0.2e1 / 0.3e1 * t1395 * t31 * t10 * t1582 - 0.5e1 / 0.9e1 * t1332 * t2404 * t2693 + 0.8e1 / 0.3e1 * t1773 * t31 * t163 * t1408
  t2812 = -0.16e2 / 0.9e1 * t1777 * t182 * t230 * t1319 + 0.56e2 / 0.27e2 * t1395 * t31 * t157 * t1319 + 0.4e1 * t727 * t1569 * t30 * t31 * t10 * t1571 - 0.4e1 * t1773 * t31 * t1396 * t1328 + 0.11e2 / 0.54e2 * t2364 + t2368 / 0.6e1 - t2371 / 0.12e2 + 0.8e1 * t1407 * t2398 - 0.36e2 * t1799 * t2390 + 0.185e3 / 0.864e3 * t2360 - t1336 * t2416 + 0.24e2 * t728 * t2384 * t2386 + 0.6e1 * t1407 * t2394
  t2817 = 0.96320598785733020893392116332301848936966614568690e-3 * t1640 * t3 * t151 * t1598 * t178 + 0.40489652240494068523217565229100011767070072771638e0 * t1664 * t3 * t151 * t1668 * t178 + 0.16112443890811965566518454245249283100831171720671e0 * t1673 * t3 * t151 * t1443 * t178 - 0.51613124335683775892531384484264856895149520224450e0 * t1682 * t3 * t151 * t1474 * t178 + 0.19191790123456790123456790123456790123456790123457e-2 * t1325 * t269 * t715 - 0.13294121303248614809395365327521771006888932479545e-1 * t1754 * t1296 + 0.80019300218199454779947911687727086112521533613842e-2 * t1806 * t1319 - 0.44313737677495382697984551091739236689629774931818e-2 * (t2696 + t2725) * t1753 * t733 + 0.26673100072733151593315970562575695370840511204614e-2 * t1761 * t1582 + 0.80019300218199454779947911687727086112521533613842e-2 * t1758 * t1328 - 0.13294121303248614809395365327521771006888932479545e-1 * t1764 * t1308 - 0.44313737677495382697984551091739236689629774931818e-2 * t1767 * t1531 + 0.26673100072733151593315970562575695370840511204614e-2 * (t2779 + t2812) * t1757 * t715
  t2827 = 0.64601518076962494758402628807041432700328989996342e-3 * t631 * t75 * t225
  t2840 = 0.96902277115443742137603943210562149050493484994510e-3 * t626 * t632 * t27
  t2841 = t2077 * t2124 / 0.4e1 - t951 * t1893 * t945 / 0.4e1 - t2152 * t836 * t1907 / 0.4e1 + t1938 * t944 * t841 * t1811 / 0.6e1 + t1938 * t944 * t819 * (t2217 + t2277 + t2315 + t2487 + t2523 + t2571 + t2619 + t2817) / 0.24e2 + t2827 + t1938 * t1862 * t1812 / 0.6e1 + 0.4e1 * t119 * t814 * t1859 - t2047 * t2034 / 0.6e1 - 0.48e2 * t898 * t948 + t2840
  t2848 = 0.48451138557721871068801971605281074525246742497255e-3 * t631 * t204 * t29 * t27
  t2852 = 0.48451138557721871068801971605281074525246742497255e-3 * t258 * t625 * t627 * t27
  t2856 = 0.67293247996835932040002738340668159062842697912856e-5 * t528 * t75 * t2 * t2527
  t2860 = 0.39018876828196680983935418000403106518546430566246e0 * t490 * t1196 * t2108 * t492
  t2861 = t897 * t673
  t2866 = t119 * t673
  t2867 = t2026 * t224
  t2878 = t2848 + t2852 + t2856 - t2860 - 0.192e3 * t2861 * t152 + 0.120e3 * t2020 * t711 + 0.96e2 * t2866 * t2867 + 0.96e2 * t703 * t2867 + t1287 * t1893 * t1931 / 0.2e1 + t2053 * t2091 / 0.2e1 + t2068 * t2130
  t2880 = t119 * t2136
  t2881 = t2880 * t773
  t2882 = t841 * t2085
  t2883 = t944 * t2882
  t2885 = t2137 * t942
  t2887 = t819 * t2085
  t2888 = t1862 * t2887
  t2896 = 0.1e1 / t2080
  t2899 = t2085 * t1929
  t2900 = t819 * t2899
  t2901 = t944 * t2900
  t2903 = t702 * t2896
  t2906 = t2903 * t773
  t2912 = t2090 * t2054 - t2881 * t2883 - t2885 * t2883 - t2881 * t2888 - t2885 * t2888 - t2138 * t836 * t2887 / 0.2e1 - t2138 * t1862 * t2882 + t119 * t2896 * t773 * t2901 + t2903 * t942 * t2901 + t2906 * t1862 * t2900 + t2906 * t944 * t841 * t2899
  t2918 = t944 * t2887
  t2927 = t367 ** 2
  t2953 = -0.41248484411876216403621151040619215743173669759529e3 / t538 / t355 * t3 * t1193 / t2927 * t40 * t1196 + 0.18395032923497521448984473398719010474438432911759e-1 * t364 * t3 * t1193 * t55 * t40 * t1196 - 0.16468461837198391751404838221570273925751472131273e1 / t362 / t355 * t3 * t1193 * t368 * t40 * t1196 - t1199 + t1207 - t1215 + t1225 + t1231 - t1234 - t1238 - 0.20234536215847273593882920738590911521882276202934e0 * t550 * t1249 * t551 + 0.10567263012202301373818104525507592435690527950900e2 * t454 * t1249 * t455
  t2980 = -0.13515027854362713277482111065523546736431162216617e3 * t541 * t1249 * t544 - 0.16862113513206061328235767282159092934901896835780e-1 * t459 * t1228 * t460 + t1240 - 0.34342413959678791974433194933424046692523362938372e-3 * t535 * t235 + 0.28098338694282647979081704945528765475700933313214e-3 * t571 * t533 * t18 * t196 + 0.28098338694282647979081704945528765475700933313214e-3 * t534 * t35 * t196 + 0.46073958594418340718689014996103000237833507556650e2 / t538 / t48 * t3 * t1193 * t543 * t40 * t1196 - t1244 + t1248 + t1252 - t1257 + t1260 + 0.37740225043579647763636087591098544413180456967501e0 * t464 * t1228 * t465
  t3000 = 0.49053421129326723863958595729917361265169154431359e0 * t470 * t182 * t1193 * t55 - 0.42921743488160883380963771263677691107023010127437e0 * t52 * t31 * t1227 * t55 - t1263 + 0.15545350000000000000000000000000000000000000000000e-1 * t428 * t375 - t1265 - t1268 + 0.51817833333333333333333333333333333333333333333333e-2 * t352 * t448 + 0.14985780636950745588843575970948674920373831100381e-2 * t619 * t18 * t225 - t1272 + t1276 + 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t218 * t327 - t1279
  t3002 = t5 * t1228 * t19
  t3006 = t23 * t157 * t25 * t35
  t3010 = t23 * t163 * t318 * t320
  t3013 = t23 * t313 * t327
  t3026 = 0.1e1 / t331 / t18
  t3028 = t320 ** 2
  t3032 = t320 * t327
  t3036 = t327 ** 2
  t3040 = t35 * t346
  t3048 = t2403 - 0.19612277777777777777777777777777777777777777777777e1 * t2406 + 0.18827786666666666666666666666666666666666666666666e2 * t2408 - 0.69732543209876543209876543209876543209876543209875e1 * t2411 + 0.61015975308641975308641975308641975308641975308640e1 * t2414
  t3052 = 0.70e2 / 0.81e2 * t3002 + 0.28e2 / 0.27e2 * t3006 + 0.4e1 / 0.3e1 * t3010 - 0.2e1 / 0.3e1 * t3013 + 0.2e1 * t23 * t10 * t332 * t334 - 0.2e1 * t23 * t319 * t339 + t23 * t324 * t346 / 0.3e1 + 0.6e1 * t23 * t12 * t3026 * t3028 - 0.9e1 * t23 * t333 * t3032 + 0.3e1 / 0.2e1 * t23 * t338 * t3036 + 0.2e1 * t23 * t338 * t3040 - t23 * t26 * t3048 / 0.4e1
  t3077 = 0.51817833333333333333333333333333333333333333333333e-2 * t3052 * t40 * t42 * t45 - t1281 - t1284 + 0.10363566666666666666666666666666666666666666666667e-1 * t428 * t372 - 0.34545222222222222222222222222222222222222222222222e-2 * t43 * t380 * t35 + 0.45987582308743803622461183496797526186096082279398e-2 * t549 * t1196 * t2108 * t551 - 0.24016506845914321304132055739789982808387563524773e0 * t453 * t1196 * t2108 * t455 - t2104 + 0.12488150530792287990702979975790562433644859250317e-3 * t69 / t532 / t61 * t18 * t40 * t2102 - t2111 - t2115 - t2827 - t2840
  t3107 = -t2848 - t2852 - t2856 + t2860 + 0.74928903184753727944217879854743374601869155501904e-3 * t647 * t620 * t270 + 0.74928903184753727944217879854743374601869155501904e-3 * t619 * t35 * t178 * t270 + 0.15610188163490359988378724969738203042056074062897e-4 * t534 * t18 * t2 * t2527 + 0.22478670955426118383265363956423012380560746650571e-2 * t647 * t651 * t27 + 0.11239335477713059191632681978211506190280373325286e-2 * t619 * t327 * t29 * t27 + 0.15545350000000000000000000000000000000000000000000e-1 * t352 * t429 + 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t44 * t346 + 0.21269256817794009175388297367268855861069438054221e0 * t356 * t1227 * t55 * t23
  t3113 = 0.64601518076962494758402628807041432700328989996340e-3 * t628 * t196
  t3123 = 0.13255248558342256726771310131293653497824588692887e0 * t96 * t2343 * t2347 * t101 * t2 * t31
  t3137 = 0.32300759038481247379201314403520716350164494998170e-3 * t631 * t84 * t178 * t270
  t3139 = 0.43067678717974996505601752538027621800219326664227e-3 * t644 * t232
  t3148 = 0.32300759038481247379201314403520716350164494998170e-3 * t626 * t643 * t270
  t3151 = -0.47604147498151601156404610484226573066625349129460e1 * t364 * t1227 * t368 * t23 + t3113 + 0.30715972396278893812459343330735333491889005037766e1 * t540 * t1196 * t2108 * t544 - t3123 + 0.13796274692623141086738355049039257855828824683819e0 * t50 * t2343 * t2347 * t55 * t2 * t31 + 0.11239335477713059191632681978211506190280373325286e-2 * t613 * t618 * t639 * t27 - t3137 + t3139 - 0.14985780636950745588843575970948674920373831100381e-2 * t648 * t196 - 0.14985780636950745588843575970948674920373831100381e-2 * t652 * t196 - 0.99905204246338303925623839806324499469158874002539e-3 * t621 * t232 - t3148 + 0.11655607162072802124656114644071191604735201966963e-2 * t640 * t235
  t3154 = 0.64601518076962494758402628807041432700328989996340e-3 * t633 * t196
  t3156 = 0.50245625170970829256535377961032225433589214441597e-3 * t636 * t235
  t3177 = 0.12725038616008566457700457726041907357911605145172e1 * t660 * t2602 * t101
  t3182 = 0.53020994233369026907085240525174613991298354771548e-1 * t481 * t3 * t151 * t101 * t178
  t3187 = 0.46822652193836017180722501600483727822255716679496e1 * t489 * t3 * t151 * t410 * t178
  t3192 = 0.10126265704850360340049377650037241810273181027543e3 * t497 * t3 * t151 * t501 * t178
  t3201 = t172 * t204
  t3204 = t84 * t256
  t3237 = -0.160e3 / 0.81e2 * t228 * t2653 + 0.140e3 / 0.81e2 * t108 * t2402 - t211 * t212 * t81 * t84 / 0.108e3 - 0.36e2 * t240 * t3201 + 0.8e1 * t244 * t3204 - 0.5e1 / 0.9e1 * t107 * t2404 * t2693 - 0.4e1 / 0.3e1 * t170 * t179 * t182 * t185 * t172 + 0.2e1 / 0.3e1 * t180 * t182 * t185 * t204 - 0.4e1 / 0.3e1 * t190 * t31 * t163 * t204 + 0.56e2 / 0.27e2 * t190 * t31 * t157 * t84 + 0.4e1 * t106 * t239 * t30 * t31 * t10 * t241 + 0.8e1 / 0.3e1 * t171 * t31 * t163 * t172
  t3249 = t5 * t1228 * t76
  t3266 = t2403 - 0.10354000000000000000000000000000000000000000000000e1 * t2406 + 0.99398400000000000000000000000000000000000000000000e1 * t2408 - 0.36814222222222222222222222222222222222222222222222e1 * t2411 + 0.32212444444444444444444444444444444444444444444444e1 * t2414
  t3269 = 0.1e1 / t238 / t75
  t3271 = t172 ** 2
  t3274 = t204 ** 2
  t3279 = t23 * t157 * t81 * t84
  t3283 = t23 * t163 * t169 * t172
  t3286 = t23 * t164 * t204
  t3288 = -0.16e2 / 0.9e1 * t180 * t182 * t230 * t84 + 0.2e1 / 0.3e1 * t190 * t31 * t10 * t256 + 0.16e2 / 0.3e1 * t107 * t2408 + 0.185e3 / 0.864e3 * t3249 + 0.8e1 / 0.3e1 * t176 * t222 * t656 * t84 - 0.11e2 / 0.648e3 * t211 * t2717 * t76 - 0.4e1 * t171 * t31 * t265 * t204 - t112 * t3266 + 0.24e2 * t111 * t3269 * t3271 + 0.6e1 * t244 * t3274 + 0.11e2 / 0.54e2 * t3279 + t3283 / 0.6e1 - t3286 / 0.12e2
  t3292 = 0.96902277115443742137603943210562149050493484994510e-3 * (t3237 + t3288) * t115 * t75
  t3294 = 0.29070683134633122641281182963168644715148045498353e-2 * t259 * t84
  t3295 = t3154 - t3156 - 0.13244423704918215443268820847077687541595671696467e1 * t655 * t2602 * t55 - 0.28819808215097185564958466887747979370065076229728e1 * t452 * t3 * t151 * t368 * t178 + 0.36859166875534672574951211996882400190266806045320e2 * t539 * t3 * t151 * t543 * t178 + 0.55185098770492564346953420196157031423315298735276e-1 * t548 * t3 * t151 * t55 * t178 + t3177 - t3182 + t3187 - t3192 - t3292 - t3294
  t3333 = 0.140e3 / 0.81e2 * t63 * t2402 - t211 * t212 * t25 * t35 / 0.108e3 - 0.160e3 / 0.81e2 * t562 * t2653 + 0.11e2 / 0.54e2 * t3006 + t3010 / 0.6e1 - t3013 / 0.12e2 - 0.4e1 / 0.3e1 * t557 * t31 * t163 * t327 + 0.2e1 / 0.3e1 * t557 * t31 * t10 * t346 - 0.5e1 / 0.9e1 * t62 * t2404 * t2693 + 0.4e1 * t61 * t332 * t30 * t31 * t10 * t334 + 0.8e1 / 0.3e1 * t581 * t31 * t163 * t320 - 0.4e1 / 0.3e1 * t580 * t179 * t182 * t185 * t320
  t3370 = -0.16e2 / 0.9e1 * t585 * t182 * t230 * t35 + 0.56e2 / 0.27e2 * t557 * t31 * t157 * t35 + 0.2e1 / 0.3e1 * t585 * t182 * t185 * t327 + 0.8e1 * t567 * t3040 - 0.4e1 * t581 * t31 * t558 * t327 + 0.16e2 / 0.3e1 * t62 * t2408 + 0.185e3 / 0.864e3 * t3002 - 0.11e2 / 0.648e3 * t211 * t2717 * t19 - t67 * t3048 + 0.24e2 * t66 * t3026 * t3028 + 0.6e1 * t567 * t3036 + 0.8e1 / 0.3e1 * t556 * t222 * t656 * t35 - 0.36e2 * t607 * t3032
  t3380 = 0.29070683134633122641281182963168644715148045498353e-2 * t279 * t204
  t3382 = 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t256
  t3415 = 0.70e2 / 0.81e2 * t3249 + 0.28e2 / 0.27e2 * t3279 + 0.4e1 / 0.3e1 * t3283 - 0.2e1 / 0.3e1 * t3286 + 0.2e1 * t23 * t10 * t239 * t241 - 0.2e1 * t23 * t286 * t245 + t23 * t290 * t256 / 0.3e1 + 0.6e1 * t23 * t12 * t3269 * t3271 - 0.9e1 * t23 * t294 * t3201 + 0.3e1 / 0.2e1 * t23 * t298 * t3274 + 0.2e1 * t23 * t298 * t3204 - t23 * t82 * t3266 / 0.4e1
  t3419 = 0.10363566666666666666666666666666666666666666666667e-1 * t3415 * t40 * t42 * t91
  t3426 = 0.31090700000000000000000000000000000000000000000001e-1 * t307 * t400
  t3428 = 0.69090444444444444444444444444444444444444444444446e-2 * t396 * t432
  t3431 = 0.69090444444444444444444444444444444444444444444446e-2 * t90 * t380 * t84
  t3433 = 0.20727133333333333333333333333333333333333333333334e-1 * t396 * t435
  t3434 = 0.22478670955426118383265363956423012380560746650571e-2 * (t3333 + t3370) * t70 * t18 + 0.67436012866278355149796091869269037141682239951713e-2 * t572 * t327 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t346 - t3380 - t3382 + 0.67436012866278355149796091869269037141682239951713e-2 * t614 * t35 - t3419 - 0.34545222222222222222222222222222222222222222222222e-2 * t428 * t381 + 0.19191790123456790123456790123456790123456790123457e-2 * t43 * t269 * t18 - t3426 + t3428 + t3431 - t3433
  t3437 = t2953 + t2980 + t3000 + t3077 + t3107 + t3151 + t3295 + t3434
  t3457 = t2052 * t942 * t1931 / 0.2e1 - t2137 * t1893 * t2918 / 0.2e1 - t2880 * t942 * t2918 + t3437 * t673 * t1859 + 0.1440e4 * t2025 * t2021 * t705 + t2068 * t1813 / 0.6e1 - t952 * t1863 / 0.2e1 + 0.24e2 * t2025 * t145 * t224 + 0.6e1 * t897 * t835 * t1859 + 0.120e3 * t2861 * t711 + 0.16e2 * t2030 * t675
  t3458 = t119 * t835
  t3467 = t944 * t1949
  t3470 = t2021 * t151
  t3510 = -0.14405806907265511347842143815250823810784594959513e-1 * t1115 * t196 - 0.14405806907265511347842143815250823810784594959513e-1 * t1120 * t196 - 0.96038712715103408985614292101672158738563966396755e-2 * t1124 * t232 + 0.14405806907265511347842143815250823810784594959513e-1 * t1118 * t756 * t225 + t1091 * t1044 / 0.3e1 + t915 * t44 * t1085 / 0.3e1 - 0.2e1 / 0.9e1 * t915 * t380 * t909 + 0.2e1 / 0.3e1 * t1043 * t1051 + t1043 * t1047 + 0.12017413633297419508922952578394288045451424337591e1 * t920 * t2343 * t2347 * t925 * t2 * t31 + 0.12004839089387926123201786512709019842320495799594e-2 * t936 / t970 / t767 * t756 * t40 * t2102 + 0.15006048861734907654002233140886274802900619749493e-3 * t972 * t756 * t2 * t2527
  t3553 = t961 ** 2
  t3561 = 0.21608710360898267021763215722876235716176892439270e-1 * t1113 * t1119 * t27 + 0.72029034536327556739210719076254119053922974797566e-2 * t1113 * t1123 * t270 + 0.10804355180449133510881607861438117858088446219635e-1 * t1118 * t1037 * t29 * t27 + 0.72029034536327556739210719076254119053922974797566e-2 * t1118 * t909 * t178 * t270 + 0.10804355180449133510881607861438117858088446219635e-1 * t1175 * t1112 * t1114 * t27 + 0.40058045444324731696409841927980960151504747791968e-1 * t984 * t1196 * t2108 * t986 - 0.41858894660588365995559857897151106306673043527969e1 * t992 * t1196 * t2108 * t994 + 0.18417913650658881038046337474746486774936139152306e3 * t993 * t1249 * t994 - 0.47132838980624597322181035517534837518580848390044e4 * t1011 * t1249 * t1014 - 0.14687949996252401622016942040259685388885074190388e0 * t998 * t1228 * t999 + 0.65778263038067432278736919552666024196200496972522e1 * t1003 * t1228 * t1004 - 0.28783485915536592493215570496151025048490758133637e5 / t1008 / t976 * t3 * t1193 / t3553 * t40 * t1196 - 0.33013307495816796838804912909949804566381363448884e-2 * t973 * t235
  t3604 = t5 * t1228 * t757
  t3608 = t23 * t157 * t906 * t909
  t3612 = t23 * t163 * t1029 * t1031
  t3615 = t23 * t1060 * t1037
  t3628 = 0.1e1 / t1071 / t756
  t3630 = t1031 ** 2
  t3634 = t1031 * t1037
  t3638 = t1037 ** 2
  t3642 = t909 * t1085
  t3650 = t2403 - 0.29676388888888888888888888888888888888888888888889e0 * t2406 + 0.28489333333333333333333333333333333333333333333334e1 * t2408 - 0.10551604938271604938271604938271604938271604938272e1 * t2411 + 0.92326543209876543209876543209876543209876543209880e0 * t2414
  t3654 = 0.70e2 / 0.81e2 * t3604 + 0.28e2 / 0.27e2 * t3608 + 0.4e1 / 0.3e1 * t3612 - 0.2e1 / 0.3e1 * t3615 + 0.2e1 * t23 * t10 * t1072 * t1074 - 0.2e1 * t23 * t1064 * t1078 + t23 * t1024 * t1085 / 0.3e1 + 0.6e1 * t23 * t12 * t3628 * t3630 - 0.9e1 * t23 * t1073 * t3634 + 0.3e1 / 0.2e1 * t23 * t1030 * t3638 + 0.2e1 * t23 * t1030 * t3642 - t23 * t907 * t3650 / 0.4e1
  t3668 = 0.42728581807279713809503831389846357494938397644766e1 * t1128 * t182 * t1193 * t925 - 0.37387509081369749583315852466115562808071097939170e1 * t922 * t31 * t1227 * t925 + 0.27010887951122833777204019653595294645221115549088e-2 * t1110 * t971 * t756 * t196 + 0.27010887951122833777204019653595294645221115549088e-2 * t972 * t909 * t196 - 0.17625539995502881946420330448311622466662089028467e1 * t985 * t1249 * t986 + 0.16023218177729892678563936771192384060601899116788e0 * t958 * t3 * t1193 * t925 * t40 * t1196 - 0.28703242052974879539812473986617901467432944133464e2 / t956 / t976 * t3 * t1193 * t962 * t40 * t1196 + 0.16068013288849294541652625744614149154061652860242e4 / t1008 / t762 * t3 * t1193 * t1013 * t40 * t1196 + t3654 * t40 * t42 * t916 / 0.3e1 + 0.10e2 / 0.81e2 * t915 * t269 * t756 - 0.2e1 / 0.9e1 * t1043 * t1018 + 0.18526846018000188409589551891691194070070945853786e1 * t977 * t1227 * t925 * t23
  t3743 = 0.8e1 / 0.3e1 * t1143 * t31 * t163 * t1031 - 0.4e1 / 0.3e1 * t1142 * t179 * t182 * t185 * t1031 + 0.2e1 / 0.3e1 * t1147 * t182 * t185 * t1037 - 0.4e1 / 0.3e1 * t1096 * t31 * t163 * t1037 + 0.2e1 / 0.3e1 * t1096 * t31 * t10 * t1085 - 0.5e1 / 0.9e1 * t930 * t2404 * t2693 - 0.16e2 / 0.9e1 * t1147 * t182 * t230 * t909 + 0.56e2 / 0.27e2 * t1096 * t31 * t157 * t909 + 0.4e1 * t767 * t1072 * t30 * t31 * t10 * t1074 - 0.4e1 * t1143 * t31 * t1097 * t1037 - t211 * t212 * t906 * t909 / 0.108e3 + 0.8e1 / 0.3e1 * t1095 * t222 * t656 * t909
  t3767 = -0.11e2 / 0.648e3 * t211 * t2717 * t757 - 0.160e3 / 0.81e2 * t1101 * t2653 + 0.140e3 / 0.81e2 * t931 * t2402 + 0.185e3 / 0.864e3 * t3604 + 0.16e2 / 0.3e1 * t930 * t2408 - 0.36e2 * t1169 * t3634 + 0.8e1 * t1106 * t3642 + t3612 / 0.6e1 + 0.11e2 / 0.54e2 * t3608 - t3615 / 0.12e2 - t934 * t3650 + 0.24e2 * t768 * t3628 * t3630 + 0.6e1 * t1106 * t3638
  t3785 = -0.11536717087965522728566034475258516523633367364087e2 * t966 * t2602 * t925 + 0.12854410631079435633322100595691319323249322288194e4 * t1009 * t3 * t151 * t1013 * t178 + 0.48069654533189678035691810313577152181805697350364e0 * t983 * t3 * t151 * t925 * t178 - 0.50230673592706039194671829476581327568007652233562e2 * t991 * t3 * t151 * t962 * t178 + 0.10712008859232863027768417163076099436041101906828e3 * t1010 * t1196 * t2108 * t1014 + 0.11204516483428731048321667411861751852832462746288e-1 * t1137 * t235 + 0.21608710360898267021763215722876235716176892439270e-1 * (t3743 + t3767) * t937 * t756 + 0.21608710360898267021763215722876235716176892439270e-1 * t938 * t1085 + 0.64826131082694801065289647168628707148530677317810e-1 * t1176 * t909 + 0.64826131082694801065289647168628707148530677317810e-1 * t1179 * t1037 + t915 * t218 * t1037 / 0.3e1 - 0.82970309059380511169770432617567371429298354135795e2 * t960 * t1228 * t962 + t1091 * t1054
  t3801 = 0.48e2 * t3458 * t675 + 0.960e3 * t2866 * t706 - t1861 * t2039 / 0.2e1 - t774 * t1908 / 0.2e1 - t774 * t3467 / 0.6e1 - 0.576e3 * t2866 * t3470 - t1865 * t754 * (t3510 + t3561 + t3668 + t3785) * t945 / 0.24e2 - t1897 * t820 / 0.6e1 - t2152 * t1857 * t145 * t819 / 0.24e2 - t2152 * t815 * t841 / 0.6e1 - t3113
  t3804 = t710 * t1945
  t3807 = t149 ** 2
  t3808 = 0.1e1 / t3807
  t3818 = t145 * t817
  t3820 = t818 * t2006 * t1929
  t3821 = t3818 * t3820
  t3823 = -t2137 * t942 * t673 * t3821 + 0.840e3 * t2025 * t710 * t3808 - 0.480e3 * t2866 * t3804 - 0.576e3 * t703 * t3470 - 0.480e3 * t703 * t3804 + t3123 + t3137 - t3139 + t3148 - t3154 + t3156
  t3824 = t773 * t673
  t3825 = t2137 * t3824
  t3857 = -t3825 * t3818 * t818 * t1811 * t1929 / 0.3e1 - t2880 * t3824 * t3821 + 0.3e1 / 0.2e1 * t2903 * t3824 * t3818 * t818 * t2085 * t2006 - t2137 * t773 * t140 * t3821 - t3825 * t145 * t840 * t3820 + t1938 * t944 * t1907 * t2006 / 0.4e1 - t2138 * t944 * t1907 * t2085 / 0.2e1 - t897 * t2136 * t773 * t2918 / 0.2e1 - t3177 + t3182 - t3187
  t3877 = t3192 - 0.48e2 * t3458 * t948 + 0.72e2 * t2861 * t2022 - 0.1920e4 * t2025 * t148 * t1945 + 0.4e1 * t666 * t140 * t1859 - 0.192e3 * t2020 * t152 + 0.144e3 * t141 * t2022 + t2068 * t2093 / 0.2e1 + t2068 * t2074 / 0.2e1 + t3292 + t3294
  t3902 = t3380 + t3382 + t3419 - t1897 * t3467 / 0.6e1 - t2152 * t1862 * t1949 / 0.6e1 - t2152 * t944 * (-0.1440e4 * t146 * t705 + 0.1920e4 * t147 * t1945 - 0.840e3 * t709 * t3808 + 0.384e3 * t1831 - 0.24e2 * t224) * t818 / 0.24e2 - t2044 * t2034 / 0.6e1 - t3437 * t751 * t773 * t945 / 0.24e2 + t3426 - t3428 - t3431 + t3433
  t3942 = t1938 * t1813 / 0.6e1 + t1938 * t2074 / 0.2e1 + t1938 * t2093 / 0.2e1 + t1938 * t2130 + t1938 * t1935 / 0.2e1 + 0.41454266666666666666666666666666666666666666666668e-1 * t308 - t2011 * t945 / 0.2e1 - t2044 * t945 / 0.6e1 - t1894 * t2012 / 0.2e1 + 0.27636177777777777777777777777777777777777777777779e-1 * t398 + 0.82908533333333333333333333333333333333333333333336e-1 * t401
  t3955 = 0.73578453447456598426849645372188715149258983353495e1 * t412 - 0.92120592592592592592592592592592592592592592592596e-2 * t433 + 0.27636177777777777777777777777777777777777777777779e-1 * t436 - 0.19441031218901976532597921525897358463476063416235e0 * t443 + 0.41454266666666666666666666666666666666666666666668e-1 * t446 + 0.10604198846673805381417048105034922798259670954310e0 * t486 - 0.93645304387672034361445003200967455644511433358993e1 * t494 + 0.20252531409700720680098755300074483620546362055085e3 * t504 - 0.42416795386695221525668192420139691193038683817240e0 * t510 + 0.49486261284477758446612891156829639725211797786780e0 * t514 - 0.33444751567025726557658929714631234158754083342496e0 * t519
  t3970 = 0.88368323722281711511808734208624356652163924619249e-2 * t524 + 0.16150379519240623689600657201760358175082247499085e-3 * t530 + 0.240e3 * t2866 * t711 + t2068 * t2124 / 0.2e1 + t2906 * t2901 - t2138 * t2888 - t2138 * t2883 - t2881 * t2918 - t2885 * t2918 + t2090 * t1931 + t2053 * t1931 / 0.2e1
  t4006 = 0.63625193080042832288502288630209536789558025725859e0 * t662 - t3825 * t3821 + t2068 * t2091 + t1288 * t2124 / 0.2e1 + 0.12e2 * t898 * t1859 - 0.96e2 * t141 * t948 + 0.144e3 * t2866 * t2022 + 0.96e2 * t2025 * t2867 - 0.576e3 * t2025 * t3470 + 0.960e3 * t2025 * t706 - 0.480e3 * t2025 * t3804
  t4030 = -0.384e3 * t703 * t152 + 0.144e3 * t703 * t2022 + 0.240e3 * t703 * t711 - 0.384e3 * t2866 * t152 + 0.48e2 * t2020 * t675 - 0.48e2 * t2020 * t948 - t952 * t2034 / 0.2e1 - t2033 * t945 / 0.2e1 - t774 * t2039 / 0.2e1 - t2152 * t3467 / 0.6e1 - t952 * t2012 / 0.2e1
  t4049 = -t1861 * t2012 - t1894 * t2034 / 0.2e1 - t1897 * t1863 - t1897 * t2039 / 0.2e1 - t774 * t953 / 0.2e1 - t1897 * t953 / 0.2e1 - t2152 * t820 / 0.6e1 - t2152 * t842 / 0.2e1 - t774 * t1863 - t2152 * t1908 / 0.2e1 - t1861 * t2034
  d1111 = t4049 - 0.86135357435949993011203505076055243600438653328453e-3 * t637 + t3942 + t4030 + 0.38760910846177496855041577284224859620197393997804e-2 * t260 + t4006 + 0.12920303615392498951680525761408286540065797999268e-2 * t634 + t1 * (t1190 + t1253 + t1816 + t2017 + t2057 + t2105 + t2146 + t2841 + t2878 + t2912 + t3457 + t3801 + t3823 + t3857 + t3877 + t3902) + t2068 * t2054 + t1288 * t2091 + t2077 * t1931 / 0.2e1 + t1288 * t2054 + t1938 * t2065 / 0.2e1 - t2047 * t945 / 0.6e1 + 0.96e2 * t141 * t675 + 0.48e2 * t2861 * t675 + 0.12e2 * t3458 * t1859 - 0.48e2 * t2861 * t948 + 0.4e1 * t2030 * t1859 + 0.4e1 * t674 * t1859 + 0.43067678717974996505601752538027621800219326664227e-3 * t645 + t3955 + t3970 + 0.77521821692354993710083154568449719240394787995608e-2 * t280 + 0.38760910846177496855041577284224859620197393997804e-2 * t282 + 0.12920303615392498951680525761408286540065797999268e-2 * t629

  res = {'v4rho4': d1111}
  return res
