"""Generated from lda_x_erf.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import scipy.special as sp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  lda_x_erf_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_erf = lambda rs, z: lda_x_erf_spin(rs, z) + lda_x_erf_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_erf(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  lda_x_erf_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_erf = lambda rs, z: lda_x_erf_spin(rs, z) + lda_x_erf_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_erf(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  lda_x_erf_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_erf = lambda rs, z: lda_x_erf_spin(rs, z) + lda_x_erf_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_erf(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 + t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t16 * f.p.zeta_threshold
  t18 = t14 ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t15, t17, t18 * t14)
  t21 = t9 * t20
  t22 = t11 ** (0.1e1 / 0.3e1)
  t23 = 9 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t3 ** 2
  t27 = t24 * t25 * f.p.cam_omega
  t29 = t1 / t22
  t30 = f.my_piecewise3(t15, t16, t18)
  t31 = 0.1e1 / t30
  t34 = t27 * t29 * t31 / 0.18e2
  t35 = 0.135e1 <= t34
  t36 = 0.135e1 < t34
  t37 = f.my_piecewise3(t36, t34, 0.135e1)
  t38 = t37 ** 2
  t41 = t38 ** 2
  t44 = t41 * t38
  t47 = t41 ** 2
  t59 = t47 ** 2
  t63 = f.my_piecewise3(t36, 0.135e1, t34)
  t64 = jnp.sqrt(jnp.pi)
  t65 = 0.1e1 / t63
  t67 = jax.lax.erf(t65 / 0.2e1)
  t69 = t63 ** 2
  t70 = 0.1e1 / t69
  t72 = jnp.exp(-t70 / 0.4e1)
  t73 = t72 - 0.1e1
  t76 = t72 - 0.3e1 / 0.2e1 - 0.2e1 * t69 * t73
  t79 = 0.2e1 * t63 * t76 + t64 * t67
  t83 = f.my_piecewise3(t35, 0.1e1 / t38 / 0.36e2 - 0.1e1 / t41 / 0.960e3 + 0.1e1 / t44 / 0.26880e5 - 0.1e1 / t47 / 0.829440e6 + 0.1e1 / t47 / t38 / 0.28385280e8 - 0.1e1 / t47 / t41 / 0.1073479680e10 + 0.1e1 / t47 / t44 / 0.44590694400e11 - 0.1e1 / t59 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t63 * t79)
  t84 = t22 * t83
  t87 = 0.3e1 / 0.32e2 * t7 * t21 * t84
  t88 = 0.1e1 - t13
  t89 = t88 <= f.p.zeta_threshold
  t90 = t88 ** (0.1e1 / 0.3e1)
  t92 = f.my_piecewise3(t89, t17, t90 * t88)
  t93 = t9 * t92
  t94 = f.my_piecewise3(t89, t16, t90)
  t95 = 0.1e1 / t94
  t98 = t27 * t29 * t95 / 0.18e2
  t99 = 0.135e1 <= t98
  t100 = 0.135e1 < t98
  t101 = f.my_piecewise3(t100, t98, 0.135e1)
  t102 = t101 ** 2
  t105 = t102 ** 2
  t108 = t105 * t102
  t111 = t105 ** 2
  t123 = t111 ** 2
  t127 = f.my_piecewise3(t100, 0.135e1, t98)
  t128 = 0.1e1 / t127
  t130 = jax.lax.erf(t128 / 0.2e1)
  t132 = t127 ** 2
  t133 = 0.1e1 / t132
  t135 = jnp.exp(-t133 / 0.4e1)
  t136 = t135 - 0.1e1
  t139 = t135 - 0.3e1 / 0.2e1 - 0.2e1 * t132 * t136
  t142 = 0.2e1 * t127 * t139 + t64 * t130
  t146 = f.my_piecewise3(t99, 0.1e1 / t102 / 0.36e2 - 0.1e1 / t105 / 0.960e3 + 0.1e1 / t108 / 0.26880e5 - 0.1e1 / t111 / 0.829440e6 + 0.1e1 / t111 / t102 / 0.28385280e8 - 0.1e1 / t111 / t105 / 0.1073479680e10 + 0.1e1 / t111 / t108 / 0.44590694400e11 - 0.1e1 / t123 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t127 * t142)
  t147 = t22 * t146
  t150 = 0.3e1 / 0.32e2 * t7 * t93 * t147
  t151 = t11 ** 2
  t153 = t10 / t151
  t154 = t12 - t153
  t157 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t154)
  t162 = t22 ** 2
  t163 = 0.1e1 / t162
  t167 = t7 * t21 * t163 * t83 / 0.32e2
  t168 = t38 * t37
  t169 = 0.1e1 / t168
  t172 = t1 / t22 / t11
  t175 = t27 * t172 * t31 / 0.54e2
  t176 = t30 ** 2
  t177 = 0.1e1 / t176
  t178 = t18 ** 2
  t179 = 0.1e1 / t178
  t182 = f.my_piecewise3(t15, 0, t179 * t154 / 0.3e1)
  t187 = -t175 - t27 * t29 * t177 * t182 / 0.18e2
  t188 = f.my_piecewise3(t36, t187, 0)
  t191 = t41 * t37
  t192 = 0.1e1 / t191
  t195 = t41 * t168
  t196 = 0.1e1 / t195
  t200 = 0.1e1 / t47 / t37
  t204 = 0.1e1 / t47 / t168
  t208 = 0.1e1 / t47 / t191
  t212 = 0.1e1 / t47 / t195
  t216 = 0.1e1 / t59 / t37
  t220 = f.my_piecewise3(t36, 0, t187)
  t222 = t72 * t70
  t227 = 0.1e1 / t69 / t63
  t231 = t63 * t73
  t243 = f.my_piecewise3(t35, -t169 * t188 / 0.18e2 + t192 * t188 / 0.240e3 - t196 * t188 / 0.4480e4 + t200 * t188 / 0.103680e6 - t204 * t188 / 0.2838528e7 + t208 * t188 / 0.89456640e8 - t212 * t188 / 0.3185049600e10 + t216 * t188 / 0.126340300800e12, -0.8e1 / 0.3e1 * t220 * t79 - 0.8e1 / 0.3e1 * t63 * (-t222 * t220 + 0.2e1 * t220 * t76 + 0.2e1 * t63 * (t227 * t220 * t72 / 0.2e1 - 0.4e1 * t231 * t220 - t65 * t220 * t72)))
  t248 = -t154
  t251 = f.my_piecewise3(t89, 0, 0.4e1 / 0.3e1 * t90 * t248)
  t259 = t7 * t93 * t163 * t146 / 0.32e2
  t260 = t102 * t101
  t261 = 0.1e1 / t260
  t264 = t27 * t172 * t95 / 0.54e2
  t265 = t94 ** 2
  t266 = 0.1e1 / t265
  t267 = t90 ** 2
  t268 = 0.1e1 / t267
  t271 = f.my_piecewise3(t89, 0, t268 * t248 / 0.3e1)
  t276 = -t264 - t27 * t29 * t266 * t271 / 0.18e2
  t277 = f.my_piecewise3(t100, t276, 0)
  t280 = t105 * t101
  t281 = 0.1e1 / t280
  t284 = t105 * t260
  t285 = 0.1e1 / t284
  t289 = 0.1e1 / t111 / t101
  t293 = 0.1e1 / t111 / t260
  t297 = 0.1e1 / t111 / t280
  t301 = 0.1e1 / t111 / t284
  t305 = 0.1e1 / t123 / t101
  t309 = f.my_piecewise3(t100, 0, t276)
  t311 = t135 * t133
  t316 = 0.1e1 / t132 / t127
  t320 = t127 * t136
  t332 = f.my_piecewise3(t99, -t261 * t277 / 0.18e2 + t281 * t277 / 0.240e3 - t285 * t277 / 0.4480e4 + t289 * t277 / 0.103680e6 - t293 * t277 / 0.2838528e7 + t297 * t277 / 0.89456640e8 - t301 * t277 / 0.3185049600e10 + t305 * t277 / 0.126340300800e12, -0.8e1 / 0.3e1 * t309 * t142 - 0.8e1 / 0.3e1 * t127 * (-t311 * t309 + 0.2e1 * t309 * t139 + 0.2e1 * t127 * (t316 * t309 * t135 / 0.2e1 - 0.4e1 * t320 * t309 - t128 * t309 * t135)))
  vrho_0_ = -t87 - t150 + t11 * (-0.3e1 / 0.32e2 * t7 * t9 * t157 * t84 - t167 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t243 - 0.3e1 / 0.32e2 * t7 * t9 * t251 * t147 - t259 - 0.3e1 / 0.32e2 * t7 * t93 * t22 * t332)
  t339 = -t12 - t153
  t342 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t339)
  t349 = f.my_piecewise3(t15, 0, t179 * t339 / 0.3e1)
  t354 = -t175 - t27 * t29 * t177 * t349 / 0.18e2
  t355 = f.my_piecewise3(t36, t354, 0)
  t373 = f.my_piecewise3(t36, 0, t354)
  t392 = f.my_piecewise3(t35, -t169 * t355 / 0.18e2 + t192 * t355 / 0.240e3 - t196 * t355 / 0.4480e4 + t200 * t355 / 0.103680e6 - t204 * t355 / 0.2838528e7 + t208 * t355 / 0.89456640e8 - t212 * t355 / 0.3185049600e10 + t216 * t355 / 0.126340300800e12, -0.8e1 / 0.3e1 * t373 * t79 - 0.8e1 / 0.3e1 * t63 * (-t222 * t373 + 0.2e1 * t373 * t76 + 0.2e1 * t63 * (t227 * t373 * t72 / 0.2e1 - 0.4e1 * t231 * t373 - t65 * t373 * t72)))
  t397 = -t339
  t400 = f.my_piecewise3(t89, 0, 0.4e1 / 0.3e1 * t90 * t397)
  t407 = f.my_piecewise3(t89, 0, t268 * t397 / 0.3e1)
  t412 = -t264 - t27 * t29 * t266 * t407 / 0.18e2
  t413 = f.my_piecewise3(t100, t412, 0)
  t431 = f.my_piecewise3(t100, 0, t412)
  t450 = f.my_piecewise3(t99, -t261 * t413 / 0.18e2 + t281 * t413 / 0.240e3 - t285 * t413 / 0.4480e4 + t289 * t413 / 0.103680e6 - t293 * t413 / 0.2838528e7 + t297 * t413 / 0.89456640e8 - t301 * t413 / 0.3185049600e10 + t305 * t413 / 0.126340300800e12, -0.8e1 / 0.3e1 * t431 * t142 - 0.8e1 / 0.3e1 * t127 * (-t311 * t431 + 0.2e1 * t431 * t139 + 0.2e1 * t127 * (t316 * t431 * t135 / 0.2e1 - 0.4e1 * t320 * t431 - t128 * t431 * t135)))
  vrho_1_ = -t87 - t150 + t11 * (-0.3e1 / 0.32e2 * t7 * t9 * t342 * t84 - t167 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t392 - 0.3e1 / 0.32e2 * t7 * t9 * t400 * t147 - t259 - 0.3e1 / 0.32e2 * t7 * t93 * t22 * t450)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  att_erf_aux1 = lambda a: jnp.sqrt(jnp.pi) * jax.lax.erf(1 / (2 * a))

  att_erf_aux2 = lambda a: jnp.exp(-1 / (4 * a ** 2)) - 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  att_erf_aux3 = lambda a: 2 * a ** 2 * att_erf_aux2(a) + 1 / 2

  attenuation_erf0 = lambda a: 1 - 8 / 3 * a * (att_erf_aux1(a) + 2 * a * (att_erf_aux2(a) - att_erf_aux3(a)))

  attenuation_erf = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.35, lambda _aval: -1 / 2021444812800 * (1.0 / jnp.maximum(_aval, 1.35)) ** 16 + 1 / 44590694400 * (1.0 / jnp.maximum(_aval, 1.35)) ** 14 - 1 / 1073479680 * (1.0 / jnp.maximum(_aval, 1.35)) ** 12 + 1 / 28385280 * (1.0 / jnp.maximum(_aval, 1.35)) ** 10 - 1 / 829440 * (1.0 / jnp.maximum(_aval, 1.35)) ** 8 + 1 / 26880 * (1.0 / jnp.maximum(_aval, 1.35)) ** 6 - 1 / 960 * (1.0 / jnp.maximum(_aval, 1.35)) ** 4 + 1 / 36 * (1.0 / jnp.maximum(_aval, 1.35)) ** 2, lambda _aval: attenuation_erf0(jnp.minimum(_aval, 1.35)))

  lda_x_erf_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_erf(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_erf = lambda rs, z: lda_x_erf_spin(rs, z) + lda_x_erf_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_erf(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = 0.1e1 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t10, t11 * f.p.zeta_threshold, 1)
  t15 = r0 ** (0.1e1 / 0.3e1)
  t16 = 9 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = t3 ** 2
  t20 = t17 * t18 * f.p.cam_omega
  t23 = f.my_piecewise3(t10, t11, 1)
  t24 = 0.1e1 / t23
  t27 = t20 * t1 / t15 * t24 / 0.18e2
  t28 = 0.135e1 <= t27
  t29 = 0.135e1 < t27
  t30 = f.my_piecewise3(t29, t27, 0.135e1)
  t31 = t30 ** 2
  t34 = t31 ** 2
  t37 = t34 * t31
  t40 = t34 ** 2
  t52 = t40 ** 2
  t56 = f.my_piecewise3(t29, 0.135e1, t27)
  t57 = jnp.sqrt(jnp.pi)
  t58 = 0.1e1 / t56
  t60 = jax.lax.erf(t58 / 0.2e1)
  t62 = t56 ** 2
  t63 = 0.1e1 / t62
  t65 = jnp.exp(-t63 / 0.4e1)
  t66 = t65 - 0.1e1
  t69 = t65 - 0.3e1 / 0.2e1 - 0.2e1 * t62 * t66
  t72 = 0.2e1 * t56 * t69 + t57 * t60
  t76 = f.my_piecewise3(t28, 0.1e1 / t31 / 0.36e2 - 0.1e1 / t34 / 0.960e3 + 0.1e1 / t37 / 0.26880e5 - 0.1e1 / t40 / 0.829440e6 + 0.1e1 / t40 / t31 / 0.28385280e8 - 0.1e1 / t40 / t34 / 0.1073479680e10 + 0.1e1 / t40 / t37 / 0.44590694400e11 - 0.1e1 / t52 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t56 * t72)
  t81 = t15 * r0
  t85 = t31 * t30
  t91 = t20 * t1 / t81 * t24 / 0.54e2
  t92 = f.my_piecewise3(t29, -t91, 0)
  t95 = t34 * t30
  t99 = t34 * t85
  t124 = f.my_piecewise3(t29, 0, -t91)
  t147 = f.my_piecewise3(t28, -0.1e1 / t85 * t92 / 0.18e2 + 0.1e1 / t95 * t92 / 0.240e3 - 0.1e1 / t99 * t92 / 0.4480e4 + 0.1e1 / t40 / t30 * t92 / 0.103680e6 - 0.1e1 / t40 / t85 * t92 / 0.2838528e7 + 0.1e1 / t40 / t95 * t92 / 0.89456640e8 - 0.1e1 / t40 / t99 * t92 / 0.3185049600e10 + 0.1e1 / t52 / t30 * t92 / 0.126340300800e12, -0.8e1 / 0.3e1 * t124 * t72 - 0.8e1 / 0.3e1 * t56 * (-t65 * t63 * t124 + 0.2e1 * t124 * t69 + 0.2e1 * t56 * (0.1e1 / t62 / t56 * t124 * t65 / 0.2e1 - 0.4e1 * t56 * t66 * t124 - t58 * t124 * t65)))
  vrho_0_ = -t1 * t3 * t6 * t9 * t13 * t15 * t76 / 0.4e1 - 0.3e1 / 0.16e2 * t81 * t1 * t3 * t6 * t9 * t13 * t147
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = 3 ** (0.1e1 / 0.3e1)
  t7 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = t10 * t12
  t14 = 0.1e1 <= f.p.zeta_threshold
  t15 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t14, t15 * f.p.zeta_threshold, 1)
  t18 = 9 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t7 ** 2
  t22 = t19 * t20 * f.p.cam_omega
  t25 = f.my_piecewise3(t14, t15, 1)
  t26 = 0.1e1 / t25
  t29 = t22 * t4 / t1 * t26 / 0.18e2
  t30 = 0.135e1 <= t29
  t31 = 0.135e1 < t29
  t32 = f.my_piecewise3(t31, t29, 0.135e1)
  t33 = t32 ** 2
  t36 = t33 ** 2
  t37 = 0.1e1 / t36
  t39 = t36 * t33
  t40 = 0.1e1 / t39
  t42 = t36 ** 2
  t43 = 0.1e1 / t42
  t46 = 0.1e1 / t42 / t33
  t49 = 0.1e1 / t42 / t36
  t52 = 0.1e1 / t42 / t39
  t54 = t42 ** 2
  t55 = 0.1e1 / t54
  t58 = f.my_piecewise3(t31, 0.135e1, t29)
  t59 = jnp.sqrt(jnp.pi)
  t60 = 0.1e1 / t58
  t62 = jax.lax.erf(t60 / 0.2e1)
  t64 = t58 ** 2
  t65 = 0.1e1 / t64
  t67 = jnp.exp(-t65 / 0.4e1)
  t68 = t67 - 0.1e1
  t71 = t67 - 0.3e1 / 0.2e1 - 0.2e1 * t64 * t68
  t74 = 0.2e1 * t58 * t71 + t59 * t62
  t78 = f.my_piecewise3(t30, 0.1e1 / t33 / 0.36e2 - t37 / 0.960e3 + t40 / 0.26880e5 - t43 / 0.829440e6 + t46 / 0.28385280e8 - t49 / 0.1073479680e10 + t52 / 0.44590694400e11 - t55 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t58 * t74)
  t85 = t33 * t32
  t86 = 0.1e1 / t85
  t87 = t1 * r0
  t92 = t22 * t4 / t87 * t26 / 0.54e2
  t93 = f.my_piecewise3(t31, -t92, 0)
  t96 = t36 * t32
  t97 = 0.1e1 / t96
  t100 = t36 * t85
  t101 = 0.1e1 / t100
  t105 = 0.1e1 / t42 / t32
  t109 = 0.1e1 / t42 / t85
  t113 = 0.1e1 / t42 / t96
  t117 = 0.1e1 / t42 / t100
  t121 = 0.1e1 / t54 / t32
  t125 = f.my_piecewise3(t31, 0, -t92)
  t127 = t67 * t65
  t132 = 0.1e1 / t64 / t58
  t136 = t58 * t68
  t141 = t132 * t125 * t67 / 0.2e1 - 0.4e1 * t136 * t125 - t60 * t125 * t67
  t144 = -t127 * t125 + 0.2e1 * t125 * t71 + 0.2e1 * t58 * t141
  t148 = f.my_piecewise3(t30, -t86 * t93 / 0.18e2 + t97 * t93 / 0.240e3 - t101 * t93 / 0.4480e4 + t105 * t93 / 0.103680e6 - t109 * t93 / 0.2838528e7 + t113 * t93 / 0.89456640e8 - t117 * t93 / 0.3185049600e10 + t121 * t93 / 0.126340300800e12, -0.8e1 / 0.3e1 * t125 * t74 - 0.8e1 / 0.3e1 * t58 * t144)
  t155 = t93 ** 2
  t158 = r0 ** 2
  t164 = 0.2e1 / 0.81e2 * t22 * t4 / t1 / t158 * t26
  t165 = f.my_piecewise3(t31, t164, 0)
  t198 = t37 * t155 / 0.6e1 - t86 * t165 / 0.18e2 - t40 * t155 / 0.48e2 + t97 * t165 / 0.240e3 + t43 * t155 / 0.640e3 - t101 * t165 / 0.4480e4 - t46 * t155 / 0.11520e5 + t105 * t165 / 0.103680e6 + t49 * t155 / 0.258048e6 - t109 * t165 / 0.2838528e7 - t52 * t155 / 0.6881280e7 + t113 * t165 / 0.89456640e8 + t55 * t155 / 0.212336640e9 - t117 * t165 / 0.3185049600e10 - 0.1e1 / t54 / t33 * t155 / 0.7431782400e10 + t121 * t165 / 0.126340300800e12
  t199 = f.my_piecewise3(t31, 0, t164)
  t204 = t64 ** 2
  t207 = t125 ** 2
  t246 = f.my_piecewise3(t30, t198, -0.8e1 / 0.3e1 * t199 * t74 - 0.16e2 / 0.3e1 * t125 * t144 - 0.8e1 / 0.3e1 * t58 * (-0.1e1 / t204 / t58 * t207 * t67 / 0.2e1 + 0.2e1 * t67 * t132 * t207 - t127 * t199 + 0.2e1 * t199 * t71 + 0.4e1 * t125 * t141 + 0.2e1 * t58 * (-0.2e1 / t204 * t207 * t67 + t132 * t199 * t67 / 0.2e1 + 0.1e1 / t204 / t64 * t207 * t67 / 0.4e1 - 0.4e1 * t207 * t68 - t65 * t207 * t67 - 0.4e1 * t136 * t199 - t60 * t199 * t67)))
  v2rho2_0_ = -0.1e1 / t2 * t4 * t7 * t13 * t17 * t78 / 0.12e2 - t1 * t4 * t7 * t13 * t17 * t148 / 0.2e1 - 0.3e1 / 0.16e2 * t87 * t4 * t7 * t13 * t17 * t246
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t5 = 3 ** (0.1e1 / 0.3e1)
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = 2 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t11 * t13
  t15 = 0.1e1 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = f.my_piecewise3(t15, t16 * f.p.zeta_threshold, 1)
  t19 = 9 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t8 ** 2
  t23 = t20 * t21 * f.p.cam_omega
  t26 = f.my_piecewise3(t15, t16, 1)
  t27 = 0.1e1 / t26
  t30 = t23 * t5 / t1 * t27 / 0.18e2
  t31 = 0.135e1 <= t30
  t32 = 0.135e1 < t30
  t33 = f.my_piecewise3(t32, t30, 0.135e1)
  t34 = t33 ** 2
  t37 = t34 ** 2
  t38 = 0.1e1 / t37
  t40 = t37 * t34
  t41 = 0.1e1 / t40
  t43 = t37 ** 2
  t44 = 0.1e1 / t43
  t47 = 0.1e1 / t43 / t34
  t50 = 0.1e1 / t43 / t37
  t53 = 0.1e1 / t43 / t40
  t55 = t43 ** 2
  t56 = 0.1e1 / t55
  t59 = f.my_piecewise3(t32, 0.135e1, t30)
  t60 = jnp.sqrt(jnp.pi)
  t61 = 0.1e1 / t59
  t63 = jnp.erf(t61 / 0.2e1)
  t65 = t59 ** 2
  t66 = 0.1e1 / t65
  t68 = jnp.exp(-t66 / 0.4e1)
  t69 = t68 - 0.1e1
  t72 = t68 - 0.3e1 / 0.2e1 - 0.2e1 * t65 * t69
  t75 = 0.2e1 * t59 * t72 + t60 * t63
  t79 = f.my_piecewise3(t31, 0.1e1 / t34 / 0.36e2 - t38 / 0.960e3 + t41 / 0.26880e5 - t44 / 0.829440e6 + t47 / 0.28385280e8 - t50 / 0.1073479680e10 + t53 / 0.44590694400e11 - t56 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t59 * t75)
  t87 = t34 * t33
  t88 = 0.1e1 / t87
  t89 = t1 * r0
  t94 = t23 * t5 / t89 * t27 / 0.54e2
  t95 = f.my_piecewise3(t32, -t94, 0)
  t98 = t37 * t33
  t99 = 0.1e1 / t98
  t102 = t37 * t87
  t103 = 0.1e1 / t102
  t107 = 0.1e1 / t43 / t33
  t111 = 0.1e1 / t43 / t87
  t115 = 0.1e1 / t43 / t98
  t119 = 0.1e1 / t43 / t102
  t123 = 0.1e1 / t55 / t33
  t127 = f.my_piecewise3(t32, 0, -t94)
  t129 = t68 * t66
  t133 = t65 * t59
  t134 = 0.1e1 / t133
  t138 = t59 * t69
  t143 = t134 * t127 * t68 / 0.2e1 - 0.4e1 * t138 * t127 - t61 * t127 * t68
  t146 = -t129 * t127 + 0.2e1 * t127 * t72 + 0.2e1 * t59 * t143
  t150 = f.my_piecewise3(t31, -t88 * t95 / 0.18e2 + t99 * t95 / 0.240e3 - t103 * t95 / 0.4480e4 + t107 * t95 / 0.103680e6 - t111 * t95 / 0.2838528e7 + t115 * t95 / 0.89456640e8 - t119 * t95 / 0.3185049600e10 + t123 * t95 / 0.126340300800e12, -0.8e1 / 0.3e1 * t127 * t75 - 0.8e1 / 0.3e1 * t59 * t146)
  t157 = t95 ** 2
  t160 = r0 ** 2
  t166 = 0.2e1 / 0.81e2 * t23 * t5 / t1 / t160 * t27
  t167 = f.my_piecewise3(t32, t166, 0)
  t195 = 0.1e1 / t55 / t34
  t200 = t38 * t157 / 0.6e1 - t88 * t167 / 0.18e2 - t41 * t157 / 0.48e2 + t99 * t167 / 0.240e3 + t44 * t157 / 0.640e3 - t103 * t167 / 0.4480e4 - t47 * t157 / 0.11520e5 + t107 * t167 / 0.103680e6 + t50 * t157 / 0.258048e6 - t111 * t167 / 0.2838528e7 - t53 * t157 / 0.6881280e7 + t115 * t167 / 0.89456640e8 + t56 * t157 / 0.212336640e9 - t119 * t167 / 0.3185049600e10 - t195 * t157 / 0.7431782400e10 + t123 * t167 / 0.126340300800e12
  t201 = f.my_piecewise3(t32, 0, t166)
  t206 = t65 ** 2
  t208 = 0.1e1 / t206 / t59
  t209 = t127 ** 2
  t213 = t68 * t134
  t221 = 0.1e1 / t206
  t229 = 0.1e1 / t206 / t65
  t241 = -0.2e1 * t221 * t209 * t68 + t134 * t201 * t68 / 0.2e1 + t229 * t209 * t68 / 0.4e1 - 0.4e1 * t209 * t69 - t66 * t209 * t68 - 0.4e1 * t138 * t201 - t61 * t201 * t68
  t244 = -t208 * t209 * t68 / 0.2e1 + 0.2e1 * t213 * t209 - t129 * t201 + 0.2e1 * t201 * t72 + 0.4e1 * t127 * t143 + 0.2e1 * t59 * t241
  t248 = f.my_piecewise3(t31, t200, -0.8e1 / 0.3e1 * t201 * t75 - 0.16e2 / 0.3e1 * t127 * t146 - 0.8e1 / 0.3e1 * t59 * t244)
  t261 = 0.14e2 / 0.243e3 * t23 * t5 / t1 / t160 / r0 * t27
  t262 = f.my_piecewise3(t32, -t261, 0)
  t279 = t157 * t95
  t290 = -t103 * t262 / 0.4480e4 + t107 * t262 / 0.103680e6 - t111 * t262 / 0.2838528e7 + t115 * t262 / 0.89456640e8 - t119 * t262 / 0.3185049600e10 + t123 * t262 / 0.126340300800e12 - t88 * t262 / 0.18e2 + t99 * t262 / 0.240e3 - 0.2e1 / 0.3e1 * t99 * t279 + t38 * t95 * t167 / 0.2e1 + t103 * t279 / 0.8e1 - t41 * t95 * t167 / 0.16e2
  t323 = -t107 * t279 / 0.80e2 + 0.3e1 / 0.640e3 * t44 * t95 * t167 + t111 * t279 / 0.1152e4 - t47 * t95 * t167 / 0.3840e4 - t115 * t279 / 0.21504e5 + t50 * t95 * t167 / 0.86016e5 + t119 * t279 / 0.491520e6 - t53 * t95 * t167 / 0.2293760e7 - t123 * t279 / 0.13271040e8 + t56 * t95 * t167 / 0.70778880e8 + 0.1e1 / t55 / t87 * t279 / 0.412876800e9 - t195 * t95 * t167 / 0.2477260800e10
  t325 = f.my_piecewise3(t32, 0, -t261)
  t332 = t209 * t127
  t337 = t68 * t201
  t340 = t206 ** 2
  t398 = f.my_piecewise3(t31, t290 + t323, -0.8e1 / 0.3e1 * t325 * t75 - 0.8e1 * t201 * t146 - 0.8e1 * t127 * t244 - 0.8e1 / 0.3e1 * t59 * (0.7e1 / 0.2e1 * t229 * t332 * t68 - 0.3e1 / 0.2e1 * t208 * t127 * t337 - 0.1e1 / t340 * t332 * t68 / 0.4e1 - 0.6e1 * t68 * t221 * t332 + 0.6e1 * t213 * t127 * t201 - t129 * t325 + 0.2e1 * t325 * t72 + 0.6e1 * t201 * t143 + 0.6e1 * t127 * t241 + 0.2e1 * t59 * (0.15e2 / 0.2e1 * t208 * t332 * t68 - 0.6e1 * t221 * t127 * t337 - 0.5e1 / 0.2e1 / t206 / t133 * t332 * t68 + t134 * t325 * t68 / 0.2e1 + 0.3e1 / 0.4e1 * t229 * t201 * t127 * t68 + 0.1e1 / t340 / t59 * t332 * t68 / 0.8e1 - 0.12e2 * t127 * t69 * t201 - 0.3e1 * t66 * t127 * t337 - 0.4e1 * t138 * t325 - t61 * t325 * t68)))
  v3rho3_0_ = 0.1e1 / t2 / r0 * t5 * t8 * t14 * t18 * t79 / 0.18e2 - 0.1e1 / t2 * t5 * t8 * t14 * t18 * t150 / 0.4e1 - 0.3e1 / 0.4e1 * t1 * t5 * t8 * t14 * t18 * t248 - 0.3e1 / 0.16e2 * t89 * t5 * t8 * t14 * t18 * t398

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t6 = 3 ** (0.1e1 / 0.3e1)
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = 2 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t15 = t12 * t14
  t16 = 0.1e1 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t16, t17 * f.p.zeta_threshold, 1)
  t20 = 9 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = t9 ** 2
  t24 = t21 * t22 * f.p.cam_omega
  t27 = f.my_piecewise3(t16, t17, 1)
  t28 = 0.1e1 / t27
  t31 = t24 * t6 / t2 * t28 / 0.18e2
  t32 = 0.135e1 <= t31
  t33 = 0.135e1 < t31
  t34 = f.my_piecewise3(t33, t31, 0.135e1)
  t35 = t34 ** 2
  t38 = t35 ** 2
  t39 = 0.1e1 / t38
  t41 = t38 * t35
  t42 = 0.1e1 / t41
  t44 = t38 ** 2
  t45 = 0.1e1 / t44
  t48 = 0.1e1 / t44 / t35
  t51 = 0.1e1 / t44 / t38
  t54 = 0.1e1 / t44 / t41
  t56 = t44 ** 2
  t57 = 0.1e1 / t56
  t60 = f.my_piecewise3(t33, 0.135e1, t31)
  t61 = jnp.sqrt(jnp.pi)
  t62 = 0.1e1 / t60
  t64 = jnp.erf(t62 / 0.2e1)
  t66 = t60 ** 2
  t67 = 0.1e1 / t66
  t69 = jnp.exp(-t67 / 0.4e1)
  t70 = t69 - 0.1e1
  t73 = t69 - 0.3e1 / 0.2e1 - 0.2e1 * t66 * t70
  t76 = 0.2e1 * t60 * t73 + t61 * t64
  t80 = f.my_piecewise3(t32, 0.1e1 / t35 / 0.36e2 - t39 / 0.960e3 + t42 / 0.26880e5 - t45 / 0.829440e6 + t48 / 0.28385280e8 - t51 / 0.1073479680e10 + t54 / 0.44590694400e11 - t57 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t60 * t76)
  t89 = t35 * t34
  t90 = 0.1e1 / t89
  t91 = t2 * r0
  t96 = t24 * t6 / t91 * t28 / 0.54e2
  t97 = f.my_piecewise3(t33, -t96, 0)
  t100 = t38 * t34
  t101 = 0.1e1 / t100
  t104 = t38 * t89
  t105 = 0.1e1 / t104
  t109 = 0.1e1 / t44 / t34
  t113 = 0.1e1 / t44 / t89
  t117 = 0.1e1 / t44 / t100
  t121 = 0.1e1 / t44 / t104
  t125 = 0.1e1 / t56 / t34
  t129 = f.my_piecewise3(t33, 0, -t96)
  t131 = t69 * t67
  t135 = t66 * t60
  t136 = 0.1e1 / t135
  t140 = t60 * t70
  t145 = t136 * t129 * t69 / 0.2e1 - 0.4e1 * t140 * t129 - t62 * t129 * t69
  t148 = -t131 * t129 + 0.2e1 * t129 * t73 + 0.2e1 * t60 * t145
  t152 = f.my_piecewise3(t32, -t90 * t97 / 0.18e2 + t101 * t97 / 0.240e3 - t105 * t97 / 0.4480e4 + t109 * t97 / 0.103680e6 - t113 * t97 / 0.2838528e7 + t117 * t97 / 0.89456640e8 - t121 * t97 / 0.3185049600e10 + t125 * t97 / 0.126340300800e12, -0.8e1 / 0.3e1 * t129 * t76 - 0.8e1 / 0.3e1 * t60 * t148)
  t160 = t97 ** 2
  t168 = 0.2e1 / 0.81e2 * t24 * t6 / t2 / t1 * t28
  t169 = f.my_piecewise3(t33, t168, 0)
  t197 = 0.1e1 / t56 / t35
  t202 = t39 * t160 / 0.6e1 - t90 * t169 / 0.18e2 - t42 * t160 / 0.48e2 + t101 * t169 / 0.240e3 + t45 * t160 / 0.640e3 - t105 * t169 / 0.4480e4 - t48 * t160 / 0.11520e5 + t109 * t169 / 0.103680e6 + t51 * t160 / 0.258048e6 - t113 * t169 / 0.2838528e7 - t54 * t160 / 0.6881280e7 + t117 * t169 / 0.89456640e8 + t57 * t160 / 0.212336640e9 - t121 * t169 / 0.3185049600e10 - t197 * t160 / 0.7431782400e10 + t125 * t169 / 0.126340300800e12
  t203 = f.my_piecewise3(t33, 0, t168)
  t208 = t66 ** 2
  t210 = 0.1e1 / t208 / t60
  t211 = t129 ** 2
  t212 = t210 * t211
  t215 = t69 * t136
  t223 = 0.1e1 / t208
  t231 = 0.1e1 / t208 / t66
  t232 = t231 * t211
  t243 = -0.2e1 * t223 * t211 * t69 + t136 * t203 * t69 / 0.2e1 + t232 * t69 / 0.4e1 - 0.4e1 * t211 * t70 - t67 * t211 * t69 - 0.4e1 * t140 * t203 - t62 * t203 * t69
  t246 = -t212 * t69 / 0.2e1 + 0.2e1 * t215 * t211 - t131 * t203 + 0.2e1 * t203 * t73 + 0.4e1 * t129 * t145 + 0.2e1 * t60 * t243
  t250 = f.my_piecewise3(t32, t202, -0.8e1 / 0.3e1 * t203 * t76 - 0.16e2 / 0.3e1 * t129 * t148 - 0.8e1 / 0.3e1 * t60 * t246)
  t263 = 0.14e2 / 0.243e3 * t24 * t6 / t2 / t1 / r0 * t28
  t264 = f.my_piecewise3(t33, -t263, 0)
  t281 = t160 * t97
  t292 = -t90 * t264 / 0.18e2 + t101 * t264 / 0.240e3 - t105 * t264 / 0.4480e4 + t109 * t264 / 0.103680e6 - t113 * t264 / 0.2838528e7 + t117 * t264 / 0.89456640e8 - t121 * t264 / 0.3185049600e10 + t125 * t264 / 0.126340300800e12 - 0.2e1 / 0.3e1 * t101 * t281 + t39 * t97 * t169 / 0.2e1 + t105 * t281 / 0.8e1 - t42 * t97 * t169 / 0.16e2
  t319 = 0.1e1 / t56 / t89
  t325 = -t109 * t281 / 0.80e2 + 0.3e1 / 0.640e3 * t45 * t97 * t169 + t113 * t281 / 0.1152e4 - t48 * t97 * t169 / 0.3840e4 - t117 * t281 / 0.21504e5 + t51 * t97 * t169 / 0.86016e5 + t121 * t281 / 0.491520e6 - t54 * t97 * t169 / 0.2293760e7 - t125 * t281 / 0.13271040e8 + t57 * t97 * t169 / 0.70778880e8 + t319 * t281 / 0.412876800e9 - t197 * t97 * t169 / 0.2477260800e10
  t327 = f.my_piecewise3(t33, 0, -t263)
  t334 = t211 * t129
  t338 = t210 * t129
  t339 = t69 * t203
  t342 = t208 ** 2
  t343 = 0.1e1 / t342
  t347 = t69 * t223
  t363 = t223 * t129
  t367 = 0.1e1 / t208 / t135
  t375 = t129 * t69
  t379 = 0.1e1 / t342 / t60
  t383 = t129 * t70
  t386 = t67 * t129
  t393 = 0.15e2 / 0.2e1 * t210 * t334 * t69 - 0.6e1 * t363 * t339 - 0.5e1 / 0.2e1 * t367 * t334 * t69 + t136 * t327 * t69 / 0.2e1 + 0.3e1 / 0.4e1 * t231 * t203 * t375 + t379 * t334 * t69 / 0.8e1 - 0.12e2 * t383 * t203 - 0.3e1 * t386 * t339 - 0.4e1 * t140 * t327 - t62 * t327 * t69
  t396 = 0.7e1 / 0.2e1 * t231 * t334 * t69 - 0.3e1 / 0.2e1 * t338 * t339 - t343 * t334 * t69 / 0.4e1 - 0.6e1 * t347 * t334 + 0.6e1 * t215 * t129 * t203 - t131 * t327 + 0.2e1 * t327 * t73 + 0.6e1 * t203 * t145 + 0.6e1 * t129 * t243 + 0.2e1 * t60 * t393
  t400 = f.my_piecewise3(t32, t292 + t325, -0.8e1 / 0.3e1 * t327 * t76 - 0.8e1 * t203 * t148 - 0.8e1 * t129 * t246 - 0.8e1 / 0.3e1 * t60 * t396)
  t454 = t169 ** 2
  t459 = t160 ** 2
  t464 = t1 ** 2
  t470 = 0.140e3 / 0.729e3 * t24 * t6 / t2 / t464 * t28
  t471 = f.my_piecewise3(t33, t470, 0)
  t474 = 0.2e1 / 0.3e1 * t39 * t264 * t97 - t42 * t264 * t97 / 0.12e2 + t45 * t264 * t97 / 0.160e3 - t48 * t264 * t97 / 0.2880e4 + t51 * t264 * t97 / 0.64512e5 - t54 * t264 * t97 / 0.1720320e7 + t57 * t264 * t97 / 0.53084160e8 - t197 * t264 * t97 / 0.1857945600e10 - 0.4e1 * t101 * t160 * t169 + 0.3e1 / 0.4e1 * t105 * t160 * t169 - 0.3e1 / 0.40e2 * t109 * t160 * t169 + t113 * t160 * t169 / 0.192e3 - t117 * t160 * t169 / 0.3584e4 + t121 * t160 * t169 / 0.81920e5 - t125 * t160 * t169 / 0.2211840e7 + t319 * t160 * t169 / 0.68812800e8 + t57 * t454 / 0.70778880e8 - 0.19e2 / 0.412876800e9 / t56 / t38 * t459 - t197 * t454 / 0.2477260800e10 - t121 * t471 / 0.3185049600e10
  t515 = t125 * t471 / 0.126340300800e12 - t90 * t471 / 0.18e2 + t101 * t471 / 0.240e3 - t105 * t471 / 0.4480e4 + t109 * t471 / 0.103680e6 - t113 * t471 / 0.2838528e7 + t117 * t471 / 0.89456640e8 + 0.10e2 / 0.3e1 * t42 * t459 + t39 * t454 / 0.2e1 - 0.7e1 / 0.8e1 * t45 * t459 - t42 * t454 / 0.16e2 + 0.9e1 / 0.80e2 * t48 * t459 + 0.3e1 / 0.640e3 * t45 * t454 - 0.11e2 / 0.1152e4 * t51 * t459 - t48 * t454 / 0.3840e4 + 0.13e2 / 0.21504e5 * t54 * t459 + t51 * t454 / 0.86016e5 - t57 * t459 / 0.32768e5 - t54 * t454 / 0.2293760e7 + 0.17e2 / 0.13271040e8 * t197 * t459
  t517 = f.my_piecewise3(t33, 0, t470)
  t526 = t211 ** 2
  t532 = t203 ** 2
  t536 = t69 * t327
  t580 = -0.75e2 / 0.2e1 * t231 * t526 * t69 + 0.45e2 * t212 * t339 - 0.6e1 * t223 * t532 * t69 - 0.8e1 * t363 * t536 - 0.15e2 * t367 * t211 * t339 + t231 * t327 * t375 + 0.3e1 / 0.4e1 * t231 * t532 * t69 + 0.3e1 / 0.4e1 * t379 * t203 * t211 * t69 - 0.3e1 * t67 * t532 * t69 - 0.4e1 * t386 * t536 + 0.85e2 / 0.4e1 * t343 * t526 * t69 - 0.19e2 / 0.8e1 / t342 / t66 * t526 * t69 + t136 * t517 * t69 / 0.2e1 + 0.1e1 / t342 / t208 * t526 * t69 / 0.16e2 - 0.12e2 * t532 * t70 - 0.16e2 * t383 * t327 - 0.4e1 * t140 * t517 - t62 * t517 * t69
  t624 = 0.2e1 * t60 * t580 + 0.2e1 * t517 * t73 + 0.8e1 * t327 * t145 + 0.12e2 * t203 * t243 + 0.8e1 * t129 * t393 - 0.24e2 * t367 * t526 * t69 + 0.21e2 * t232 * t339 - 0.3e1 / 0.2e1 * t210 * t532 * t69 - 0.2e1 * t338 * t536 - 0.3e1 / 0.2e1 * t343 * t211 * t339 + 0.24e2 * t69 * t210 * t526 - 0.36e2 * t347 * t211 * t203 + 0.6e1 * t215 * t532 + 0.8e1 * t215 * t129 * t327 + 0.15e2 / 0.4e1 * t379 * t526 * t69 - 0.1e1 / t342 / t135 * t526 * t69 / 0.8e1 - t131 * t517
  t628 = f.my_piecewise3(t32, t474 + t515, -0.8e1 / 0.3e1 * t517 * t76 - 0.32e2 / 0.3e1 * t327 * t148 - 0.16e2 * t203 * t246 - 0.32e2 / 0.3e1 * t129 * t396 - 0.8e1 / 0.3e1 * t60 * t624)
  v4rho4_0_ = -0.5e1 / 0.54e2 / t3 / t1 * t6 * t9 * t15 * t19 * t80 + 0.2e1 / 0.9e1 / t3 / r0 * t6 * t9 * t15 * t19 * t152 - 0.1e1 / t3 * t6 * t9 * t15 * t19 * t250 / 0.2e1 - t2 * t6 * t9 * t15 * t19 * t400 - 0.3e1 / 0.16e2 * t91 * t6 * t9 * t15 * t19 * t628

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 + t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = t14 ** (0.1e1 / 0.3e1)
  t17 = t11 ** 2
  t18 = 0.1e1 / t17
  t19 = t10 * t18
  t20 = t12 - t19
  t23 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t16 * t20)
  t24 = t9 * t23
  t25 = t11 ** (0.1e1 / 0.3e1)
  t26 = 9 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = t3 ** 2
  t29 = t27 * t28
  t30 = t29 * f.p.cam_omega
  t31 = 0.1e1 / t25
  t32 = t1 * t31
  t33 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t15, t33, t16)
  t35 = 0.1e1 / t34
  t38 = t30 * t32 * t35 / 0.18e2
  t39 = 0.135e1 <= t38
  t40 = 0.135e1 < t38
  t41 = f.my_piecewise3(t40, t38, 0.135e1)
  t42 = t41 ** 2
  t45 = t42 ** 2
  t46 = 0.1e1 / t45
  t48 = t45 * t42
  t49 = 0.1e1 / t48
  t51 = t45 ** 2
  t52 = 0.1e1 / t51
  t55 = 0.1e1 / t51 / t42
  t58 = 0.1e1 / t51 / t45
  t61 = 0.1e1 / t51 / t48
  t63 = t51 ** 2
  t64 = 0.1e1 / t63
  t67 = f.my_piecewise3(t40, 0.135e1, t38)
  t68 = jnp.sqrt(jnp.pi)
  t69 = 0.1e1 / t67
  t71 = jax.lax.erf(t69 / 0.2e1)
  t73 = t67 ** 2
  t74 = 0.1e1 / t73
  t76 = jnp.exp(-t74 / 0.4e1)
  t77 = t76 - 0.1e1
  t80 = t76 - 0.3e1 / 0.2e1 - 0.2e1 * t73 * t77
  t83 = 0.2e1 * t67 * t80 + t68 * t71
  t87 = f.my_piecewise3(t39, 0.1e1 / t42 / 0.36e2 - t46 / 0.960e3 + t49 / 0.26880e5 - t52 / 0.829440e6 + t55 / 0.28385280e8 - t58 / 0.1073479680e10 + t61 / 0.44590694400e11 - t64 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t67 * t83)
  t88 = t25 * t87
  t90 = t7 * t24 * t88
  t92 = t33 * f.p.zeta_threshold
  t94 = f.my_piecewise3(t15, t92, t16 * t14)
  t95 = t9 * t94
  t96 = t25 ** 2
  t97 = 0.1e1 / t96
  t98 = t97 * t87
  t101 = t7 * t95 * t98 / 0.16e2
  t102 = t42 * t41
  t103 = 0.1e1 / t102
  t106 = t1 / t25 / t11
  t109 = t30 * t106 * t35 / 0.54e2
  t110 = t34 ** 2
  t111 = 0.1e1 / t110
  t112 = t16 ** 2
  t113 = 0.1e1 / t112
  t116 = f.my_piecewise3(t15, 0, t113 * t20 / 0.3e1)
  t117 = t111 * t116
  t121 = -t109 - t30 * t32 * t117 / 0.18e2
  t122 = f.my_piecewise3(t40, t121, 0)
  t125 = t45 * t41
  t126 = 0.1e1 / t125
  t129 = t45 * t102
  t130 = 0.1e1 / t129
  t134 = 0.1e1 / t51 / t41
  t138 = 0.1e1 / t51 / t102
  t142 = 0.1e1 / t51 / t125
  t146 = 0.1e1 / t51 / t129
  t150 = 0.1e1 / t63 / t41
  t154 = f.my_piecewise3(t40, 0, t121)
  t156 = t76 * t74
  t161 = 0.1e1 / t73 / t67
  t165 = t67 * t77
  t170 = t161 * t154 * t76 / 0.2e1 - 0.4e1 * t165 * t154 - t69 * t154 * t76
  t173 = -t156 * t154 + 0.2e1 * t154 * t80 + 0.2e1 * t67 * t170
  t177 = f.my_piecewise3(t39, -t103 * t122 / 0.18e2 + t126 * t122 / 0.240e3 - t130 * t122 / 0.4480e4 + t134 * t122 / 0.103680e6 - t138 * t122 / 0.2838528e7 + t142 * t122 / 0.89456640e8 - t146 * t122 / 0.3185049600e10 + t150 * t122 / 0.126340300800e12, -0.8e1 / 0.3e1 * t154 * t83 - 0.8e1 / 0.3e1 * t67 * t173)
  t178 = t25 * t177
  t180 = t7 * t95 * t178
  t182 = 0.1e1 - t13
  t183 = t182 <= f.p.zeta_threshold
  t184 = t182 ** (0.1e1 / 0.3e1)
  t185 = -t20
  t188 = f.my_piecewise3(t183, 0, 0.4e1 / 0.3e1 * t184 * t185)
  t189 = t9 * t188
  t190 = f.my_piecewise3(t183, t33, t184)
  t191 = 0.1e1 / t190
  t194 = t30 * t32 * t191 / 0.18e2
  t195 = 0.135e1 <= t194
  t196 = 0.135e1 < t194
  t197 = f.my_piecewise3(t196, t194, 0.135e1)
  t198 = t197 ** 2
  t201 = t198 ** 2
  t202 = 0.1e1 / t201
  t204 = t201 * t198
  t205 = 0.1e1 / t204
  t207 = t201 ** 2
  t208 = 0.1e1 / t207
  t211 = 0.1e1 / t207 / t198
  t214 = 0.1e1 / t207 / t201
  t217 = 0.1e1 / t207 / t204
  t219 = t207 ** 2
  t220 = 0.1e1 / t219
  t223 = f.my_piecewise3(t196, 0.135e1, t194)
  t224 = 0.1e1 / t223
  t226 = jax.lax.erf(t224 / 0.2e1)
  t228 = t223 ** 2
  t229 = 0.1e1 / t228
  t231 = jnp.exp(-t229 / 0.4e1)
  t232 = t231 - 0.1e1
  t235 = t231 - 0.3e1 / 0.2e1 - 0.2e1 * t228 * t232
  t238 = 0.2e1 * t223 * t235 + t68 * t226
  t242 = f.my_piecewise3(t195, 0.1e1 / t198 / 0.36e2 - t202 / 0.960e3 + t205 / 0.26880e5 - t208 / 0.829440e6 + t211 / 0.28385280e8 - t214 / 0.1073479680e10 + t217 / 0.44590694400e11 - t220 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t223 * t238)
  t243 = t25 * t242
  t245 = t7 * t189 * t243
  t248 = f.my_piecewise3(t183, t92, t184 * t182)
  t249 = t9 * t248
  t250 = t97 * t242
  t253 = t7 * t249 * t250 / 0.16e2
  t254 = t198 * t197
  t255 = 0.1e1 / t254
  t258 = t30 * t106 * t191 / 0.54e2
  t259 = t190 ** 2
  t260 = 0.1e1 / t259
  t261 = t184 ** 2
  t262 = 0.1e1 / t261
  t265 = f.my_piecewise3(t183, 0, t262 * t185 / 0.3e1)
  t266 = t260 * t265
  t270 = -t258 - t30 * t32 * t266 / 0.18e2
  t271 = f.my_piecewise3(t196, t270, 0)
  t274 = t201 * t197
  t275 = 0.1e1 / t274
  t278 = t201 * t254
  t279 = 0.1e1 / t278
  t283 = 0.1e1 / t207 / t197
  t287 = 0.1e1 / t207 / t254
  t291 = 0.1e1 / t207 / t274
  t295 = 0.1e1 / t207 / t278
  t299 = 0.1e1 / t219 / t197
  t303 = f.my_piecewise3(t196, 0, t270)
  t305 = t231 * t229
  t310 = 0.1e1 / t228 / t223
  t314 = t223 * t232
  t319 = t310 * t303 * t231 / 0.2e1 - 0.4e1 * t314 * t303 - t224 * t303 * t231
  t322 = 0.2e1 * t223 * t319 + 0.2e1 * t303 * t235 - t305 * t303
  t326 = f.my_piecewise3(t195, -t255 * t271 / 0.18e2 + t275 * t271 / 0.240e3 - t279 * t271 / 0.4480e4 + t283 * t271 / 0.103680e6 - t287 * t271 / 0.2838528e7 + t291 * t271 / 0.89456640e8 - t295 * t271 / 0.3185049600e10 + t299 * t271 / 0.126340300800e12, -0.8e1 / 0.3e1 * t223 * t322 - 0.8e1 / 0.3e1 * t303 * t238)
  t327 = t25 * t326
  t329 = t7 * t249 * t327
  t331 = t20 ** 2
  t335 = 0.1e1 / t17 / t11
  t336 = t10 * t335
  t338 = -0.2e1 * t18 + 0.2e1 * t336
  t342 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t113 * t331 + 0.4e1 / 0.3e1 * t16 * t338)
  t348 = t7 * t24 * t98
  t354 = 0.1e1 / t96 / t11
  t358 = t7 * t95 * t354 * t87 / 0.48e2
  t361 = t7 * t95 * t97 * t177
  t363 = t122 ** 2
  t368 = t1 / t25 / t17
  t371 = 0.2e1 / 0.81e2 * t30 * t368 * t35
  t373 = t30 * t106 * t117
  t376 = 0.1e1 / t110 / t34
  t377 = t116 ** 2
  t383 = 0.1e1 / t112 / t14
  t389 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t383 * t331 + t113 * t338 / 0.3e1)
  t394 = t371 + t373 / 0.27e2 + t30 * t32 * t376 * t377 / 0.9e1 - t30 * t32 * t111 * t389 / 0.18e2
  t395 = f.my_piecewise3(t40, t394, 0)
  t423 = 0.1e1 / t63 / t42
  t428 = t46 * t363 / 0.6e1 - t103 * t395 / 0.18e2 - t49 * t363 / 0.48e2 + t126 * t395 / 0.240e3 + t52 * t363 / 0.640e3 - t130 * t395 / 0.4480e4 - t55 * t363 / 0.11520e5 + t134 * t395 / 0.103680e6 + t58 * t363 / 0.258048e6 - t138 * t395 / 0.2838528e7 - t61 * t363 / 0.6881280e7 + t142 * t395 / 0.89456640e8 + t64 * t363 / 0.212336640e9 - t146 * t395 / 0.3185049600e10 - t423 * t363 / 0.7431782400e10 + t150 * t395 / 0.126340300800e12
  t429 = f.my_piecewise3(t40, 0, t394)
  t434 = t73 ** 2
  t436 = 0.1e1 / t434 / t67
  t437 = t154 ** 2
  t441 = t76 * t161
  t449 = 0.1e1 / t434
  t457 = 0.1e1 / t434 / t73
  t476 = f.my_piecewise3(t39, t428, -0.8e1 / 0.3e1 * t429 * t83 - 0.16e2 / 0.3e1 * t154 * t173 - 0.8e1 / 0.3e1 * t67 * (-t436 * t437 * t76 / 0.2e1 + 0.2e1 * t441 * t437 - t156 * t429 + 0.2e1 * t429 * t80 + 0.4e1 * t154 * t170 + 0.2e1 * t67 * (-0.2e1 * t449 * t437 * t76 + t161 * t429 * t76 / 0.2e1 + t457 * t437 * t76 / 0.4e1 - 0.4e1 * t437 * t77 - t74 * t437 * t76 - 0.4e1 * t165 * t429 - t69 * t429 * t76)))
  t481 = t185 ** 2
  t484 = -t338
  t488 = f.my_piecewise3(t183, 0, 0.4e1 / 0.9e1 * t262 * t481 + 0.4e1 / 0.3e1 * t184 * t484)
  t494 = t7 * t189 * t250
  t502 = t7 * t249 * t354 * t242 / 0.48e2
  t505 = t7 * t249 * t97 * t326
  t507 = t271 ** 2
  t512 = 0.2e1 / 0.81e2 * t30 * t368 * t191
  t514 = t30 * t106 * t266
  t517 = 0.1e1 / t259 / t190
  t518 = t265 ** 2
  t524 = 0.1e1 / t261 / t182
  t530 = f.my_piecewise3(t183, 0, -0.2e1 / 0.9e1 * t524 * t481 + t262 * t484 / 0.3e1)
  t535 = t512 + t514 / 0.27e2 + t30 * t32 * t517 * t518 / 0.9e1 - t30 * t32 * t260 * t530 / 0.18e2
  t536 = f.my_piecewise3(t196, t535, 0)
  t564 = 0.1e1 / t219 / t198
  t569 = t202 * t507 / 0.6e1 - t255 * t536 / 0.18e2 - t205 * t507 / 0.48e2 + t275 * t536 / 0.240e3 + t208 * t507 / 0.640e3 - t279 * t536 / 0.4480e4 - t211 * t507 / 0.11520e5 + t283 * t536 / 0.103680e6 + t214 * t507 / 0.258048e6 - t287 * t536 / 0.2838528e7 - t217 * t507 / 0.6881280e7 + t291 * t536 / 0.89456640e8 + t220 * t507 / 0.212336640e9 - t295 * t536 / 0.3185049600e10 - t564 * t507 / 0.7431782400e10 + t299 * t536 / 0.126340300800e12
  t570 = f.my_piecewise3(t196, 0, t535)
  t575 = t228 ** 2
  t577 = 0.1e1 / t575 / t223
  t578 = t303 ** 2
  t582 = t231 * t310
  t590 = 0.1e1 / t575
  t598 = 0.1e1 / t575 / t228
  t617 = f.my_piecewise3(t195, t569, -0.8e1 / 0.3e1 * t570 * t238 - 0.16e2 / 0.3e1 * t303 * t322 - 0.8e1 / 0.3e1 * t223 * (-t577 * t578 * t231 / 0.2e1 + 0.2e1 * t582 * t578 - t305 * t570 + 0.2e1 * t570 * t235 + 0.4e1 * t303 * t319 + 0.2e1 * t223 * (-0.2e1 * t590 * t578 * t231 + t310 * t570 * t231 / 0.2e1 + t598 * t578 * t231 / 0.4e1 - 0.4e1 * t578 * t232 - t229 * t578 * t231 - 0.4e1 * t314 * t570 - t224 * t570 * t231)))
  t622 = -0.3e1 / 0.32e2 * t7 * t9 * t342 * t88 - t348 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t24 * t178 + t358 - t361 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t95 * t25 * t476 - 0.3e1 / 0.32e2 * t7 * t9 * t488 * t243 - t494 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t189 * t327 + t502 - t505 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t249 * t25 * t617
  d11 = -0.3e1 / 0.16e2 * t90 - t101 - 0.3e1 / 0.16e2 * t180 - 0.3e1 / 0.16e2 * t245 - t253 - 0.3e1 / 0.16e2 * t329 + t11 * t622
  t628 = -t12 - t19
  t631 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t16 * t628)
  t632 = t9 * t631
  t634 = t7 * t632 * t88
  t636 = t113 * t628
  t638 = f.my_piecewise3(t15, 0, t636 / 0.3e1)
  t639 = t111 * t638
  t643 = -t109 - t30 * t32 * t639 / 0.18e2
  t644 = f.my_piecewise3(t40, t643, 0)
  t662 = f.my_piecewise3(t40, 0, t643)
  t674 = t161 * t662 * t76 / 0.2e1 - 0.4e1 * t165 * t662 - t69 * t662 * t76
  t677 = -t156 * t662 + 0.2e1 * t662 * t80 + 0.2e1 * t67 * t674
  t681 = f.my_piecewise3(t39, -t103 * t644 / 0.18e2 + t126 * t644 / 0.240e3 - t130 * t644 / 0.4480e4 + t134 * t644 / 0.103680e6 - t138 * t644 / 0.2838528e7 + t142 * t644 / 0.89456640e8 - t146 * t644 / 0.3185049600e10 + t150 * t644 / 0.126340300800e12, -0.8e1 / 0.3e1 * t662 * t83 - 0.8e1 / 0.3e1 * t67 * t677)
  t682 = t25 * t681
  t684 = t7 * t95 * t682
  t686 = -t628
  t689 = f.my_piecewise3(t183, 0, 0.4e1 / 0.3e1 * t184 * t686)
  t690 = t9 * t689
  t692 = t7 * t690 * t243
  t694 = t262 * t686
  t696 = f.my_piecewise3(t183, 0, t694 / 0.3e1)
  t697 = t260 * t696
  t701 = -t258 - t30 * t32 * t697 / 0.18e2
  t702 = f.my_piecewise3(t196, t701, 0)
  t720 = f.my_piecewise3(t196, 0, t701)
  t732 = t310 * t720 * t231 / 0.2e1 - 0.4e1 * t314 * t720 - t224 * t720 * t231
  t735 = 0.2e1 * t223 * t732 + 0.2e1 * t720 * t235 - t305 * t720
  t739 = f.my_piecewise3(t195, -t255 * t702 / 0.18e2 + t275 * t702 / 0.240e3 - t279 * t702 / 0.4480e4 + t283 * t702 / 0.103680e6 - t287 * t702 / 0.2838528e7 + t291 * t702 / 0.89456640e8 - t295 * t702 / 0.3185049600e10 + t299 * t702 / 0.126340300800e12, -0.8e1 / 0.3e1 * t223 * t735 - 0.8e1 / 0.3e1 * t720 * t238)
  t740 = t25 * t739
  t742 = t7 * t249 * t740
  t750 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t636 * t20 + 0.8e1 / 0.3e1 * t16 * t10 * t335)
  t756 = t7 * t632 * t98
  t768 = t7 * t95 * t97 * t681
  t775 = t30 * t106 * t639
  t778 = t29 * f.p.cam_omega * t1
  t791 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t383 * t628 * t20 + 0.2e1 / 0.3e1 * t113 * t10 * t335)
  t796 = t371 + t373 / 0.54e2 + t775 / 0.54e2 + t778 * t31 * t376 * t638 * t116 / 0.9e1 - t30 * t32 * t111 * t791 / 0.18e2
  t797 = f.my_piecewise3(t40, t796, 0)
  t835 = t46 * t644 * t122 / 0.6e1 - t103 * t797 / 0.18e2 - t49 * t644 * t122 / 0.48e2 + t126 * t797 / 0.240e3 + t52 * t644 * t122 / 0.640e3 - t130 * t797 / 0.4480e4 - t55 * t644 * t122 / 0.11520e5 + t134 * t797 / 0.103680e6 + t58 * t644 * t122 / 0.258048e6 - t138 * t797 / 0.2838528e7 - t61 * t644 * t122 / 0.6881280e7 + t142 * t797 / 0.89456640e8 + t64 * t644 * t122 / 0.212336640e9 - t146 * t797 / 0.3185049600e10 - t423 * t644 * t122 / 0.7431782400e10 + t150 * t797 / 0.126340300800e12
  t836 = f.my_piecewise3(t40, 0, t796)
  t841 = t76 * t662
  t855 = t76 * t154
  t880 = f.my_piecewise3(t39, t835, -0.8e1 / 0.3e1 * t836 * t83 - 0.8e1 / 0.3e1 * t662 * t173 - 0.8e1 / 0.3e1 * t154 * t677 - 0.8e1 / 0.3e1 * t67 * (-t436 * t154 * t841 / 0.2e1 + 0.2e1 * t441 * t662 * t154 - t156 * t836 + 0.2e1 * t836 * t80 + 0.2e1 * t662 * t170 + 0.2e1 * t154 * t674 + 0.2e1 * t67 * (-0.2e1 * t449 * t662 * t855 + t161 * t836 * t76 / 0.2e1 + t457 * t662 * t855 / 0.4e1 - 0.4e1 * t154 * t77 * t662 - t74 * t154 * t841 - 0.4e1 * t165 * t836 - t69 * t836 * t76)))
  t891 = f.my_piecewise3(t183, 0, 0.4e1 / 0.9e1 * t694 * t185 - 0.8e1 / 0.3e1 * t184 * t10 * t335)
  t897 = t7 * t690 * t250
  t909 = t7 * t249 * t97 * t739
  t916 = t30 * t106 * t697
  t930 = f.my_piecewise3(t183, 0, -0.2e1 / 0.9e1 * t524 * t686 * t185 - 0.2e1 / 0.3e1 * t262 * t10 * t335)
  t935 = t512 + t514 / 0.54e2 + t916 / 0.54e2 + t778 * t31 * t517 * t696 * t265 / 0.9e1 - t30 * t32 * t260 * t930 / 0.18e2
  t936 = f.my_piecewise3(t196, t935, 0)
  t974 = t202 * t702 * t271 / 0.6e1 - t255 * t936 / 0.18e2 - t205 * t702 * t271 / 0.48e2 + t275 * t936 / 0.240e3 + t208 * t702 * t271 / 0.640e3 - t279 * t936 / 0.4480e4 - t211 * t702 * t271 / 0.11520e5 + t283 * t936 / 0.103680e6 + t214 * t702 * t271 / 0.258048e6 - t287 * t936 / 0.2838528e7 - t217 * t702 * t271 / 0.6881280e7 + t291 * t936 / 0.89456640e8 + t220 * t702 * t271 / 0.212336640e9 - t295 * t936 / 0.3185049600e10 - t564 * t702 * t271 / 0.7431782400e10 + t299 * t936 / 0.126340300800e12
  t975 = f.my_piecewise3(t196, 0, t935)
  t980 = t231 * t720
  t994 = t231 * t303
  t1019 = f.my_piecewise3(t195, t974, -0.8e1 / 0.3e1 * t975 * t238 - 0.8e1 / 0.3e1 * t720 * t322 - 0.8e1 / 0.3e1 * t303 * t735 - 0.8e1 / 0.3e1 * t223 * (-t577 * t303 * t980 / 0.2e1 + 0.2e1 * t582 * t720 * t303 - t305 * t975 + 0.2e1 * t975 * t235 + 0.2e1 * t720 * t319 + 0.2e1 * t303 * t732 + 0.2e1 * t223 * (-0.2e1 * t590 * t720 * t994 + t310 * t975 * t231 / 0.2e1 + t598 * t720 * t994 / 0.4e1 - 0.4e1 * t303 * t232 * t720 - t229 * t303 * t980 - 0.4e1 * t314 * t975 - t224 * t975 * t231)))
  t1024 = -0.3e1 / 0.32e2 * t7 * t9 * t750 * t88 - t756 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t632 * t178 - t348 / 0.32e2 + t358 - t361 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t24 * t682 - t768 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t95 * t25 * t880 - 0.3e1 / 0.32e2 * t7 * t9 * t891 * t243 - t897 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t690 * t327 - t494 / 0.32e2 + t502 - t505 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t189 * t740 - t909 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t249 * t25 * t1019
  d12 = -0.3e1 / 0.32e2 * t90 - t101 - 0.3e1 / 0.32e2 * t180 - 0.3e1 / 0.32e2 * t245 - t253 - 0.3e1 / 0.32e2 * t329 - 0.3e1 / 0.32e2 * t634 - 0.3e1 / 0.32e2 * t684 - 0.3e1 / 0.32e2 * t692 - 0.3e1 / 0.32e2 * t742 + t11 * t1024
  t1030 = t628 ** 2
  t1034 = 0.2e1 * t18 + 0.2e1 * t336
  t1038 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t113 * t1030 + 0.4e1 / 0.3e1 * t16 * t1034)
  t1048 = t644 ** 2
  t1052 = t638 ** 2
  t1062 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t383 * t1030 + t113 * t1034 / 0.3e1)
  t1067 = t371 + t775 / 0.27e2 + t30 * t32 * t376 * t1052 / 0.9e1 - t30 * t32 * t111 * t1062 / 0.18e2
  t1068 = f.my_piecewise3(t40, t1067, 0)
  t1099 = t46 * t1048 / 0.6e1 - t103 * t1068 / 0.18e2 - t49 * t1048 / 0.48e2 + t126 * t1068 / 0.240e3 + t52 * t1048 / 0.640e3 - t130 * t1068 / 0.4480e4 - t55 * t1048 / 0.11520e5 + t134 * t1068 / 0.103680e6 + t58 * t1048 / 0.258048e6 - t138 * t1068 / 0.2838528e7 - t61 * t1048 / 0.6881280e7 + t142 * t1068 / 0.89456640e8 + t64 * t1048 / 0.212336640e9 - t146 * t1068 / 0.3185049600e10 - t423 * t1048 / 0.7431782400e10 + t150 * t1068 / 0.126340300800e12
  t1100 = f.my_piecewise3(t40, 0, t1067)
  t1105 = t662 ** 2
  t1140 = f.my_piecewise3(t39, t1099, -0.8e1 / 0.3e1 * t1100 * t83 - 0.16e2 / 0.3e1 * t662 * t677 - 0.8e1 / 0.3e1 * t67 * (-t436 * t1105 * t76 / 0.2e1 + 0.2e1 * t441 * t1105 - t156 * t1100 + 0.2e1 * t1100 * t80 + 0.4e1 * t662 * t674 + 0.2e1 * t67 * (-0.2e1 * t449 * t1105 * t76 + t161 * t1100 * t76 / 0.2e1 + t457 * t1105 * t76 / 0.4e1 - 0.4e1 * t1105 * t77 - t74 * t1105 * t76 - 0.4e1 * t165 * t1100 - t69 * t1100 * t76)))
  t1145 = t686 ** 2
  t1148 = -t1034
  t1152 = f.my_piecewise3(t183, 0, 0.4e1 / 0.9e1 * t262 * t1145 + 0.4e1 / 0.3e1 * t184 * t1148)
  t1162 = t702 ** 2
  t1166 = t696 ** 2
  t1176 = f.my_piecewise3(t183, 0, -0.2e1 / 0.9e1 * t524 * t1145 + t262 * t1148 / 0.3e1)
  t1181 = t512 + t916 / 0.27e2 + t30 * t32 * t517 * t1166 / 0.9e1 - t30 * t32 * t260 * t1176 / 0.18e2
  t1182 = f.my_piecewise3(t196, t1181, 0)
  t1213 = t202 * t1162 / 0.6e1 - t255 * t1182 / 0.18e2 - t205 * t1162 / 0.48e2 + t275 * t1182 / 0.240e3 + t208 * t1162 / 0.640e3 - t279 * t1182 / 0.4480e4 - t211 * t1162 / 0.11520e5 + t283 * t1182 / 0.103680e6 + t214 * t1162 / 0.258048e6 - t287 * t1182 / 0.2838528e7 - t217 * t1162 / 0.6881280e7 + t291 * t1182 / 0.89456640e8 + t220 * t1162 / 0.212336640e9 - t295 * t1182 / 0.3185049600e10 - t564 * t1162 / 0.7431782400e10 + t299 * t1182 / 0.126340300800e12
  t1214 = f.my_piecewise3(t196, 0, t1181)
  t1219 = t720 ** 2
  t1254 = f.my_piecewise3(t195, t1213, -0.8e1 / 0.3e1 * t1214 * t238 - 0.16e2 / 0.3e1 * t720 * t735 - 0.8e1 / 0.3e1 * t223 * (-t577 * t1219 * t231 / 0.2e1 + 0.2e1 * t582 * t1219 - t305 * t1214 + 0.2e1 * t1214 * t235 + 0.4e1 * t720 * t732 + 0.2e1 * t223 * (-0.2e1 * t590 * t1219 * t231 + t310 * t1214 * t231 / 0.2e1 + t598 * t1219 * t231 / 0.4e1 - 0.4e1 * t1219 * t232 - t229 * t1219 * t231 - 0.4e1 * t314 * t1214 - t224 * t1214 * t231)))
  t1259 = -0.3e1 / 0.32e2 * t7 * t9 * t1038 * t88 - t756 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t632 * t682 + t358 - t768 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t95 * t25 * t1140 - 0.3e1 / 0.32e2 * t7 * t9 * t1152 * t243 - t897 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t690 * t740 + t502 - t909 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t249 * t25 * t1254
  d22 = -0.3e1 / 0.16e2 * t634 - t101 - 0.3e1 / 0.16e2 * t684 - 0.3e1 / 0.16e2 * t692 - t253 - 0.3e1 / 0.16e2 * t742 + t11 * t1259
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 + t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t16 * f.p.zeta_threshold
  t18 = t14 ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t15, t17, t18 * t14)
  t21 = t9 * t20
  t22 = t11 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = 9 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t3 ** 2
  t28 = t26 * t27
  t29 = t28 * f.p.cam_omega
  t30 = 0.1e1 / t22
  t31 = t1 * t30
  t32 = f.my_piecewise3(t15, t16, t18)
  t33 = 0.1e1 / t32
  t36 = t29 * t31 * t33 / 0.18e2
  t37 = 0.135e1 <= t36
  t38 = 0.135e1 < t36
  t39 = f.my_piecewise3(t38, t36, 0.135e1)
  t40 = t39 ** 2
  t41 = t40 * t39
  t42 = 0.1e1 / t41
  t45 = t1 / t22 / t11
  t49 = t32 ** 2
  t50 = 0.1e1 / t49
  t51 = t18 ** 2
  t52 = 0.1e1 / t51
  t53 = t11 ** 2
  t54 = 0.1e1 / t53
  t56 = -t10 * t54 + t12
  t57 = t52 * t56
  t59 = f.my_piecewise3(t15, 0, t57 / 0.3e1)
  t60 = t50 * t59
  t64 = -t29 * t45 * t33 / 0.54e2 - t29 * t31 * t60 / 0.18e2
  t65 = f.my_piecewise3(t38, t64, 0)
  t68 = t40 ** 2
  t69 = t68 * t39
  t70 = 0.1e1 / t69
  t73 = t68 * t41
  t74 = 0.1e1 / t73
  t77 = t68 ** 2
  t79 = 0.1e1 / t77 / t39
  t83 = 0.1e1 / t77 / t41
  t87 = 0.1e1 / t77 / t69
  t91 = 0.1e1 / t77 / t73
  t94 = t77 ** 2
  t96 = 0.1e1 / t94 / t39
  t100 = f.my_piecewise3(t38, 0, t64)
  t101 = jnp.sqrt(jnp.pi)
  t102 = f.my_piecewise3(t38, 0.135e1, t36)
  t103 = 0.1e1 / t102
  t105 = jnp.erf(t103 / 0.2e1)
  t107 = t102 ** 2
  t108 = 0.1e1 / t107
  t110 = jnp.exp(-t108 / 0.4e1)
  t111 = t110 - 0.1e1
  t114 = t110 - 0.3e1 / 0.2e1 - 0.2e1 * t107 * t111
  t117 = t101 * t105 + 0.2e1 * t102 * t114
  t119 = t110 * t108
  t123 = t107 * t102
  t124 = 0.1e1 / t123
  t128 = t102 * t111
  t133 = t124 * t100 * t110 / 0.2e1 - 0.4e1 * t128 * t100 - t103 * t100 * t110
  t136 = 0.2e1 * t100 * t114 - t119 * t100 + 0.2e1 * t102 * t133
  t140 = f.my_piecewise3(t37, -t42 * t65 / 0.18e2 + t70 * t65 / 0.240e3 - t74 * t65 / 0.4480e4 + t79 * t65 / 0.103680e6 - t83 * t65 / 0.2838528e7 + t87 * t65 / 0.89456640e8 - t91 * t65 / 0.3185049600e10 + t96 * t65 / 0.126340300800e12, -0.8e1 / 0.3e1 * t100 * t117 - 0.8e1 / 0.3e1 * t102 * t136)
  t141 = t24 * t140
  t146 = 0.1e1 / t23 / t11
  t149 = 0.1e1 / t68
  t151 = t68 * t40
  t152 = 0.1e1 / t151
  t154 = 0.1e1 / t77
  t157 = 0.1e1 / t77 / t40
  t160 = 0.1e1 / t77 / t68
  t163 = 0.1e1 / t77 / t151
  t165 = 0.1e1 / t94
  t171 = f.my_piecewise3(t37, 0.1e1 / t40 / 0.36e2 - t149 / 0.960e3 + t152 / 0.26880e5 - t154 / 0.829440e6 + t157 / 0.28385280e8 - t160 / 0.1073479680e10 + t163 / 0.44590694400e11 - t165 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t102 * t117)
  t172 = t146 * t171
  t178 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t56)
  t179 = t9 * t178
  t180 = t22 * t140
  t184 = t56 ** 2
  t187 = t53 * t11
  t188 = 0.1e1 / t187
  t191 = 0.2e1 * t10 * t188 - 0.2e1 * t54
  t195 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t52 * t184 + 0.4e1 / 0.3e1 * t18 * t191)
  t196 = t9 * t195
  t197 = t22 * t171
  t201 = t24 * t171
  t205 = 0.1e1 - t13
  t206 = t205 <= f.p.zeta_threshold
  t207 = t205 ** (0.1e1 / 0.3e1)
  t209 = f.my_piecewise3(t206, t17, t207 * t205)
  t210 = t9 * t209
  t211 = f.my_piecewise3(t206, t16, t207)
  t212 = 0.1e1 / t211
  t215 = t29 * t31 * t212 / 0.18e2
  t216 = 0.135e1 <= t215
  t217 = 0.135e1 < t215
  t218 = f.my_piecewise3(t217, t215, 0.135e1)
  t219 = t218 ** 2
  t222 = t219 ** 2
  t223 = 0.1e1 / t222
  t225 = t222 * t219
  t226 = 0.1e1 / t225
  t228 = t222 ** 2
  t229 = 0.1e1 / t228
  t232 = 0.1e1 / t228 / t219
  t235 = 0.1e1 / t228 / t222
  t238 = 0.1e1 / t228 / t225
  t240 = t228 ** 2
  t241 = 0.1e1 / t240
  t244 = f.my_piecewise3(t217, 0.135e1, t215)
  t245 = 0.1e1 / t244
  t247 = jnp.erf(t245 / 0.2e1)
  t249 = t244 ** 2
  t250 = 0.1e1 / t249
  t252 = jnp.exp(-t250 / 0.4e1)
  t253 = t252 - 0.1e1
  t256 = t252 - 0.3e1 / 0.2e1 - 0.2e1 * t249 * t253
  t259 = t101 * t247 + 0.2e1 * t244 * t256
  t263 = f.my_piecewise3(t216, 0.1e1 / t219 / 0.36e2 - t223 / 0.960e3 + t226 / 0.26880e5 - t229 / 0.829440e6 + t232 / 0.28385280e8 - t235 / 0.1073479680e10 + t238 / 0.44590694400e11 - t241 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t244 * t259)
  t264 = t146 * t263
  t268 = -t56
  t271 = f.my_piecewise3(t206, 0, 0.4e1 / 0.3e1 * t207 * t268)
  t272 = t9 * t271
  t273 = t219 * t218
  t274 = 0.1e1 / t273
  t278 = t211 ** 2
  t279 = 0.1e1 / t278
  t280 = t207 ** 2
  t281 = 0.1e1 / t280
  t282 = t281 * t268
  t284 = f.my_piecewise3(t206, 0, t282 / 0.3e1)
  t285 = t279 * t284
  t289 = -t29 * t45 * t212 / 0.54e2 - t29 * t31 * t285 / 0.18e2
  t290 = f.my_piecewise3(t217, t289, 0)
  t293 = t222 * t218
  t294 = 0.1e1 / t293
  t297 = t222 * t273
  t298 = 0.1e1 / t297
  t302 = 0.1e1 / t228 / t218
  t306 = 0.1e1 / t228 / t273
  t310 = 0.1e1 / t228 / t293
  t314 = 0.1e1 / t228 / t297
  t318 = 0.1e1 / t240 / t218
  t322 = f.my_piecewise3(t217, 0, t289)
  t324 = t252 * t250
  t328 = t249 * t244
  t329 = 0.1e1 / t328
  t333 = t244 * t253
  t338 = t329 * t322 * t252 / 0.2e1 - 0.4e1 * t333 * t322 - t245 * t322 * t252
  t341 = 0.2e1 * t244 * t338 + 0.2e1 * t322 * t256 - t324 * t322
  t345 = f.my_piecewise3(t216, -t274 * t290 / 0.18e2 + t294 * t290 / 0.240e3 - t298 * t290 / 0.4480e4 + t302 * t290 / 0.103680e6 - t306 * t290 / 0.2838528e7 + t310 * t290 / 0.89456640e8 - t314 * t290 / 0.3185049600e10 + t318 * t290 / 0.126340300800e12, -0.8e1 / 0.3e1 * t244 * t341 - 0.8e1 / 0.3e1 * t322 * t259)
  t346 = t22 * t345
  t356 = t268 ** 2
  t359 = -t191
  t363 = f.my_piecewise3(t206, 0, 0.4e1 / 0.9e1 * t281 * t356 + 0.4e1 / 0.3e1 * t207 * t359)
  t364 = t9 * t363
  t365 = t24 * t263
  t373 = 0.1e1 / t23 / t53
  t383 = 0.1e1 / t51 / t14
  t384 = t184 * t56
  t389 = t53 ** 2
  t393 = 0.6e1 * t188 - 0.6e1 * t10 / t389
  t397 = f.my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t383 * t384 + 0.4e1 / 0.3e1 * t57 * t191 + 0.4e1 / 0.3e1 * t18 * t393)
  t408 = t65 ** 2
  t413 = t1 / t22 / t53
  t421 = 0.1e1 / t49 / t32
  t422 = t59 ** 2
  t423 = t421 * t422
  t432 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t383 * t184 + t52 * t191 / 0.3e1)
  t433 = t50 * t432
  t437 = 0.2e1 / 0.81e2 * t29 * t413 * t33 + t29 * t45 * t60 / 0.27e2 + t29 * t31 * t423 / 0.9e1 - t29 * t31 * t433 / 0.18e2
  t438 = f.my_piecewise3(t38, t437, 0)
  t466 = 0.1e1 / t94 / t40
  t471 = t149 * t408 / 0.6e1 - t42 * t438 / 0.18e2 - t152 * t408 / 0.48e2 + t70 * t438 / 0.240e3 + t154 * t408 / 0.640e3 - t74 * t438 / 0.4480e4 - t157 * t408 / 0.11520e5 + t79 * t438 / 0.103680e6 + t160 * t408 / 0.258048e6 - t83 * t438 / 0.2838528e7 - t163 * t408 / 0.6881280e7 + t87 * t438 / 0.89456640e8 + t165 * t408 / 0.212336640e9 - t91 * t438 / 0.3185049600e10 - t466 * t408 / 0.7431782400e10 + t96 * t438 / 0.126340300800e12
  t472 = f.my_piecewise3(t38, 0, t437)
  t477 = t107 ** 2
  t479 = 0.1e1 / t477 / t102
  t480 = t100 ** 2
  t484 = t110 * t124
  t492 = 0.1e1 / t477
  t500 = 0.1e1 / t477 / t107
  t512 = -0.2e1 * t492 * t480 * t110 + t124 * t472 * t110 / 0.2e1 + t500 * t480 * t110 / 0.4e1 - 0.4e1 * t480 * t111 - t108 * t480 * t110 - 0.4e1 * t128 * t472 - t103 * t472 * t110
  t515 = -t479 * t480 * t110 / 0.2e1 + 0.2e1 * t484 * t480 - t119 * t472 + 0.2e1 * t472 * t114 + 0.4e1 * t100 * t133 + 0.2e1 * t102 * t512
  t519 = f.my_piecewise3(t37, t471, -0.8e1 / 0.3e1 * t472 * t117 - 0.16e2 / 0.3e1 * t100 * t136 - 0.8e1 / 0.3e1 * t102 * t515)
  t520 = t22 * t519
  t537 = t408 * t65
  t565 = t165 * t65 * t438 / 0.70778880e8 + 0.1e1 / t94 / t41 * t537 / 0.412876800e9 - t466 * t65 * t438 / 0.2477260800e10 - 0.2e1 / 0.3e1 * t70 * t537 + t149 * t65 * t438 / 0.2e1 + t74 * t537 / 0.8e1 - t152 * t65 * t438 / 0.16e2 - t79 * t537 / 0.80e2 + 0.3e1 / 0.640e3 * t154 * t65 * t438 + t83 * t537 / 0.1152e4 - t157 * t65 * t438 / 0.3840e4 - t87 * t537 / 0.21504e5
  t578 = t1 / t22 / t187
  t591 = t49 ** 2
  t599 = t28 * f.p.cam_omega * t1
  t605 = t14 ** 2
  t616 = f.my_piecewise3(t15, 0, 0.10e2 / 0.27e2 / t51 / t605 * t384 - 0.2e1 / 0.3e1 * t383 * t56 * t191 + t52 * t393 / 0.3e1)
  t621 = -0.14e2 / 0.243e3 * t29 * t578 * t33 - 0.2e1 / 0.27e2 * t29 * t413 * t60 - t29 * t45 * t423 / 0.9e1 + t29 * t45 * t433 / 0.18e2 - t29 * t31 / t591 * t422 * t59 / 0.3e1 + t599 * t30 * t421 * t59 * t432 / 0.3e1 - t29 * t31 * t50 * t616 / 0.18e2
  t622 = f.my_piecewise3(t38, t621, 0)
  t639 = t160 * t65 * t438 / 0.86016e5 + t91 * t537 / 0.491520e6 - t163 * t65 * t438 / 0.2293760e7 - t96 * t537 / 0.13271040e8 + t70 * t622 / 0.240e3 - t74 * t622 / 0.4480e4 + t79 * t622 / 0.103680e6 - t83 * t622 / 0.2838528e7 + t87 * t622 / 0.89456640e8 - t91 * t622 / 0.3185049600e10 + t96 * t622 / 0.126340300800e12 - t42 * t622 / 0.18e2
  t641 = f.my_piecewise3(t38, 0, t621)
  t648 = t480 * t100
  t653 = t110 * t472
  t656 = t477 ** 2
  t714 = f.my_piecewise3(t37, t565 + t639, -0.8e1 / 0.3e1 * t641 * t117 - 0.8e1 * t472 * t136 - 0.8e1 * t100 * t515 - 0.8e1 / 0.3e1 * t102 * (0.7e1 / 0.2e1 * t500 * t648 * t110 - 0.3e1 / 0.2e1 * t479 * t100 * t653 - 0.1e1 / t656 * t648 * t110 / 0.4e1 - 0.6e1 * t110 * t492 * t648 + 0.6e1 * t484 * t100 * t472 - t119 * t641 + 0.2e1 * t641 * t114 + 0.6e1 * t472 * t133 + 0.6e1 * t100 * t512 + 0.2e1 * t102 * (0.15e2 / 0.2e1 * t479 * t648 * t110 - 0.6e1 * t492 * t100 * t653 - 0.5e1 / 0.2e1 / t477 / t123 * t648 * t110 + t124 * t641 * t110 / 0.2e1 + 0.3e1 / 0.4e1 * t500 * t472 * t100 * t110 + 0.1e1 / t656 / t102 * t648 * t110 / 0.8e1 - 0.12e2 * t100 * t111 * t472 - 0.3e1 * t108 * t100 * t653 - 0.4e1 * t128 * t641 - t103 * t641 * t110)))
  t720 = 0.1e1 / t280 / t205
  t721 = t356 * t268
  t726 = -t393
  t730 = f.my_piecewise3(t206, 0, -0.8e1 / 0.27e2 * t720 * t721 + 0.4e1 / 0.3e1 * t282 * t359 + 0.4e1 / 0.3e1 * t207 * t726)
  t732 = t22 * t263
  t739 = t24 * t345
  t743 = t290 ** 2
  t753 = 0.1e1 / t278 / t211
  t754 = t284 ** 2
  t755 = t753 * t754
  t764 = f.my_piecewise3(t206, 0, -0.2e1 / 0.9e1 * t720 * t356 + t281 * t359 / 0.3e1)
  t765 = t279 * t764
  t769 = 0.2e1 / 0.81e2 * t29 * t413 * t212 + t29 * t45 * t285 / 0.27e2 + t29 * t31 * t755 / 0.9e1 - t29 * t31 * t765 / 0.18e2
  t770 = f.my_piecewise3(t217, t769, 0)
  t798 = 0.1e1 / t240 / t219
  t803 = t223 * t743 / 0.6e1 - t274 * t770 / 0.18e2 - t226 * t743 / 0.48e2 + t294 * t770 / 0.240e3 + t229 * t743 / 0.640e3 - t298 * t770 / 0.4480e4 - t232 * t743 / 0.11520e5 + t302 * t770 / 0.103680e6 + t235 * t743 / 0.258048e6 - t306 * t770 / 0.2838528e7 - t238 * t743 / 0.6881280e7 + t310 * t770 / 0.89456640e8 + t241 * t743 / 0.212336640e9 - t314 * t770 / 0.3185049600e10 - t798 * t743 / 0.7431782400e10 + t318 * t770 / 0.126340300800e12
  t804 = f.my_piecewise3(t217, 0, t769)
  t809 = t249 ** 2
  t811 = 0.1e1 / t809 / t244
  t812 = t322 ** 2
  t816 = t252 * t329
  t824 = 0.1e1 / t809
  t832 = 0.1e1 / t809 / t249
  t844 = -0.2e1 * t824 * t812 * t252 + t329 * t804 * t252 / 0.2e1 + t832 * t812 * t252 / 0.4e1 - 0.4e1 * t812 * t253 - t250 * t812 * t252 - 0.4e1 * t333 * t804 - t245 * t804 * t252
  t847 = -t811 * t812 * t252 / 0.2e1 + 0.2e1 * t816 * t812 - t324 * t804 + 0.2e1 * t804 * t256 + 0.4e1 * t322 * t338 + 0.2e1 * t244 * t844
  t851 = f.my_piecewise3(t216, t803, -0.8e1 / 0.3e1 * t804 * t259 - 0.16e2 / 0.3e1 * t322 * t341 - 0.8e1 / 0.3e1 * t244 * t847)
  t852 = t22 * t851
  t876 = t278 ** 2
  t888 = t205 ** 2
  t899 = f.my_piecewise3(t206, 0, 0.10e2 / 0.27e2 / t280 / t888 * t721 - 0.2e1 / 0.3e1 * t720 * t268 * t359 + t281 * t726 / 0.3e1)
  t904 = -0.14e2 / 0.243e3 * t29 * t578 * t212 - 0.2e1 / 0.27e2 * t29 * t413 * t285 - t29 * t45 * t755 / 0.9e1 + t29 * t45 * t765 / 0.18e2 - t29 * t31 / t876 * t754 * t284 / 0.3e1 + t599 * t30 * t753 * t284 * t764 / 0.3e1 - t29 * t31 * t279 * t899 / 0.18e2
  t905 = f.my_piecewise3(t217, t904, 0)
  t922 = t743 * t290
  t933 = -t274 * t905 / 0.18e2 + t294 * t905 / 0.240e3 - t298 * t905 / 0.4480e4 + t302 * t905 / 0.103680e6 - t306 * t905 / 0.2838528e7 + t310 * t905 / 0.89456640e8 - t314 * t905 / 0.3185049600e10 + t318 * t905 / 0.126340300800e12 - 0.2e1 / 0.3e1 * t294 * t922 + t223 * t290 * t770 / 0.2e1 + t298 * t922 / 0.8e1 - t226 * t290 * t770 / 0.16e2
  t966 = -t302 * t922 / 0.80e2 + 0.3e1 / 0.640e3 * t229 * t290 * t770 + t306 * t922 / 0.1152e4 - t232 * t290 * t770 / 0.3840e4 - t310 * t922 / 0.21504e5 + t235 * t290 * t770 / 0.86016e5 + t314 * t922 / 0.491520e6 - t238 * t290 * t770 / 0.2293760e7 - t318 * t922 / 0.13271040e8 + t241 * t290 * t770 / 0.70778880e8 + 0.1e1 / t240 / t273 * t922 / 0.412876800e9 - t798 * t290 * t770 / 0.2477260800e10
  t968 = f.my_piecewise3(t217, 0, t904)
  t975 = t812 * t322
  t980 = t252 * t804
  t983 = t809 ** 2
  t1041 = f.my_piecewise3(t216, t933 + t966, -0.8e1 / 0.3e1 * t968 * t259 - 0.8e1 * t804 * t341 - 0.8e1 * t322 * t847 - 0.8e1 / 0.3e1 * t244 * (0.7e1 / 0.2e1 * t832 * t975 * t252 - 0.3e1 / 0.2e1 * t811 * t322 * t980 - 0.1e1 / t983 * t975 * t252 / 0.4e1 - 0.6e1 * t252 * t824 * t975 + 0.6e1 * t816 * t322 * t804 - t324 * t968 + 0.2e1 * t968 * t256 + 0.6e1 * t804 * t338 + 0.6e1 * t322 * t844 + 0.2e1 * t244 * (0.15e2 / 0.2e1 * t811 * t975 * t252 - 0.6e1 * t824 * t322 * t980 - 0.5e1 / 0.2e1 / t809 / t328 * t975 * t252 + t329 * t968 * t252 / 0.2e1 + 0.3e1 / 0.4e1 * t832 * t804 * t322 * t252 + 0.1e1 / t983 / t244 * t975 * t252 / 0.8e1 - 0.12e2 * t322 * t253 * t804 - 0.3e1 * t250 * t322 * t980 - 0.4e1 * t333 * t968 - t245 * t968 * t252)))
  t1046 = -0.3e1 / 0.32e2 * t7 * t196 * t201 + t7 * t179 * t172 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t364 * t365 + t7 * t272 * t264 / 0.16e2 - 0.5e1 / 0.144e3 * t7 * t210 * t373 * t263 - 0.5e1 / 0.144e3 * t7 * t21 * t373 * t171 - 0.3e1 / 0.32e2 * t7 * t9 * t397 * t197 - 0.9e1 / 0.32e2 * t7 * t196 * t180 - 0.3e1 / 0.16e2 * t7 * t179 * t141 - 0.9e1 / 0.32e2 * t7 * t179 * t520 + t7 * t21 * t146 * t140 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t21 * t24 * t519 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t714 - 0.3e1 / 0.32e2 * t7 * t9 * t730 * t732 - 0.9e1 / 0.32e2 * t7 * t364 * t346 - 0.3e1 / 0.16e2 * t7 * t272 * t739 - 0.9e1 / 0.32e2 * t7 * t272 * t852 + t7 * t210 * t146 * t345 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t210 * t24 * t851 - 0.3e1 / 0.32e2 * t7 * t210 * t22 * t1041
  d111 = -0.3e1 / 0.16e2 * t7 * t21 * t141 + t7 * t21 * t172 / 0.16e2 - 0.9e1 / 0.16e2 * t7 * t179 * t180 - 0.9e1 / 0.32e2 * t7 * t196 * t197 - 0.3e1 / 0.16e2 * t7 * t179 * t201 + t7 * t210 * t264 / 0.16e2 - 0.9e1 / 0.16e2 * t7 * t272 * t346 + t11 * t1046 - 0.9e1 / 0.32e2 * t7 * t210 * t852 - 0.3e1 / 0.16e2 * t7 * t210 * t739 - 0.9e1 / 0.32e2 * t7 * t21 * t520 - 0.9e1 / 0.32e2 * t7 * t364 * t732 - 0.3e1 / 0.16e2 * t7 * t272 * t365

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 - t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t16 * f.p.zeta_threshold
  t18 = t14 ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t15, t17, t18 * t14)
  t21 = t9 * t20
  t22 = t11 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = 9 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t3 ** 2
  t28 = t26 * t27
  t29 = t28 * f.p.cam_omega
  t30 = 0.1e1 / t22
  t31 = t1 * t30
  t32 = f.my_piecewise3(t15, t16, t18)
  t33 = 0.1e1 / t32
  t36 = t29 * t31 * t33 / 0.18e2
  t37 = 0.135e1 <= t36
  t38 = 0.135e1 < t36
  t39 = f.my_piecewise3(t38, t36, 0.135e1)
  t40 = t39 ** 2
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t44 = 0.1e1 / t22 / t11
  t45 = t1 * t44
  t49 = t32 ** 2
  t50 = 0.1e1 / t49
  t51 = t18 ** 2
  t52 = 0.1e1 / t51
  t53 = t11 ** 2
  t54 = 0.1e1 / t53
  t56 = t10 * t54 - t12
  t57 = t52 * t56
  t59 = f.my_piecewise3(t15, 0, t57 / 0.3e1)
  t60 = t50 * t59
  t64 = -t29 * t45 * t33 / 0.54e2 - t29 * t31 * t60 / 0.18e2
  t65 = f.my_piecewise3(t38, t64, 0)
  t66 = t65 ** 2
  t69 = t40 * t39
  t70 = 0.1e1 / t69
  t73 = t1 / t22 / t53
  t81 = 0.1e1 / t49 / t32
  t82 = t59 ** 2
  t83 = t81 * t82
  t88 = 0.1e1 / t51 / t14
  t89 = t56 ** 2
  t90 = t88 * t89
  t92 = t53 * t11
  t93 = 0.1e1 / t92
  t96 = -0.2e1 * t10 * t93 + 0.2e1 * t54
  t100 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t90 + t52 * t96 / 0.3e1)
  t101 = t50 * t100
  t105 = 0.2e1 / 0.81e2 * t29 * t73 * t33 + t29 * t45 * t60 / 0.27e2 + t29 * t31 * t83 / 0.9e1 - t29 * t31 * t101 / 0.18e2
  t106 = f.my_piecewise3(t38, t105, 0)
  t109 = t41 * t40
  t110 = 0.1e1 / t109
  t113 = t41 * t39
  t114 = 0.1e1 / t113
  t117 = t41 ** 2
  t118 = 0.1e1 / t117
  t121 = t41 * t69
  t122 = 0.1e1 / t121
  t126 = 0.1e1 / t117 / t40
  t130 = 0.1e1 / t117 / t39
  t134 = 0.1e1 / t117 / t41
  t138 = 0.1e1 / t117 / t69
  t142 = 0.1e1 / t117 / t109
  t146 = 0.1e1 / t117 / t113
  t149 = t117 ** 2
  t150 = 0.1e1 / t149
  t154 = 0.1e1 / t117 / t121
  t158 = 0.1e1 / t149 / t40
  t162 = 0.1e1 / t149 / t39
  t165 = t42 * t66 / 0.6e1 - t70 * t106 / 0.18e2 - t110 * t66 / 0.48e2 + t114 * t106 / 0.240e3 + t118 * t66 / 0.640e3 - t122 * t106 / 0.4480e4 - t126 * t66 / 0.11520e5 + t130 * t106 / 0.103680e6 + t134 * t66 / 0.258048e6 - t138 * t106 / 0.2838528e7 - t142 * t66 / 0.6881280e7 + t146 * t106 / 0.89456640e8 + t150 * t66 / 0.212336640e9 - t154 * t106 / 0.3185049600e10 - t158 * t66 / 0.7431782400e10 + t162 * t106 / 0.126340300800e12
  t166 = f.my_piecewise3(t38, 0, t105)
  t167 = jnp.sqrt(jnp.pi)
  t168 = f.my_piecewise3(t38, 0.135e1, t36)
  t169 = 0.1e1 / t168
  t171 = jnp.erf(t169 / 0.2e1)
  t173 = t168 ** 2
  t174 = 0.1e1 / t173
  t176 = jnp.exp(-t174 / 0.4e1)
  t177 = t176 - 0.1e1
  t180 = t176 - 0.3e1 / 0.2e1 - 0.2e1 * t173 * t177
  t183 = t167 * t171 + 0.2e1 * t168 * t180
  t186 = f.my_piecewise3(t38, 0, t64)
  t187 = t176 * t174
  t191 = t173 * t168
  t192 = 0.1e1 / t191
  t196 = t168 * t177
  t201 = t192 * t186 * t176 / 0.2e1 - 0.4e1 * t196 * t186 - t169 * t186 * t176
  t204 = 0.2e1 * t168 * t201 + 0.2e1 * t186 * t180 - t187 * t186
  t207 = t173 ** 2
  t209 = 0.1e1 / t207 / t168
  t210 = t186 ** 2
  t211 = t209 * t210
  t214 = t176 * t192
  t222 = 0.1e1 / t207
  t230 = 0.1e1 / t207 / t173
  t231 = t230 * t210
  t242 = -0.2e1 * t222 * t210 * t176 + t192 * t166 * t176 / 0.2e1 + t231 * t176 / 0.4e1 - 0.4e1 * t210 * t177 - t174 * t210 * t176 - 0.4e1 * t196 * t166 - t169 * t166 * t176
  t245 = -t211 * t176 / 0.2e1 + 0.2e1 * t214 * t210 - t187 * t166 + 0.2e1 * t166 * t180 + 0.4e1 * t186 * t201 + 0.2e1 * t168 * t242
  t249 = f.my_piecewise3(t37, t165, -0.8e1 / 0.3e1 * t166 * t183 - 0.16e2 / 0.3e1 * t186 * t204 - 0.8e1 / 0.3e1 * t168 * t245)
  t250 = t24 * t249
  t254 = 0.1e1 + t13
  t255 = t254 <= f.p.zeta_threshold
  t256 = t254 ** (0.1e1 / 0.3e1)
  t258 = f.my_piecewise3(t255, t17, t256 * t254)
  t259 = t9 * t258
  t260 = f.my_piecewise3(t255, t16, t256)
  t261 = 0.1e1 / t260
  t264 = t29 * t31 * t261 / 0.18e2
  t265 = 0.135e1 <= t264
  t266 = 0.135e1 < t264
  t267 = f.my_piecewise3(t266, t264, 0.135e1)
  t268 = t267 ** 2
  t269 = t268 ** 2
  t270 = 0.1e1 / t269
  t274 = t260 ** 2
  t275 = 0.1e1 / t274
  t276 = t256 ** 2
  t277 = 0.1e1 / t276
  t278 = -t56
  t279 = t277 * t278
  t281 = f.my_piecewise3(t255, 0, t279 / 0.3e1)
  t282 = t275 * t281
  t286 = -t29 * t45 * t261 / 0.54e2 - t29 * t31 * t282 / 0.18e2
  t287 = f.my_piecewise3(t266, t286, 0)
  t288 = t287 ** 2
  t291 = t268 * t267
  t292 = 0.1e1 / t291
  t300 = 0.1e1 / t274 / t260
  t301 = t281 ** 2
  t302 = t300 * t301
  t307 = 0.1e1 / t276 / t254
  t308 = t278 ** 2
  t309 = t307 * t308
  t311 = -t96
  t315 = f.my_piecewise3(t255, 0, -0.2e1 / 0.9e1 * t309 + t277 * t311 / 0.3e1)
  t316 = t275 * t315
  t320 = 0.2e1 / 0.81e2 * t29 * t73 * t261 + t29 * t45 * t282 / 0.27e2 + t29 * t31 * t302 / 0.9e1 - t29 * t31 * t316 / 0.18e2
  t321 = f.my_piecewise3(t266, t320, 0)
  t324 = t269 * t268
  t325 = 0.1e1 / t324
  t328 = t269 * t267
  t329 = 0.1e1 / t328
  t332 = t269 ** 2
  t333 = 0.1e1 / t332
  t336 = t269 * t291
  t337 = 0.1e1 / t336
  t341 = 0.1e1 / t332 / t268
  t345 = 0.1e1 / t332 / t267
  t349 = 0.1e1 / t332 / t269
  t353 = 0.1e1 / t332 / t291
  t357 = 0.1e1 / t332 / t324
  t361 = 0.1e1 / t332 / t328
  t364 = t332 ** 2
  t365 = 0.1e1 / t364
  t369 = 0.1e1 / t332 / t336
  t373 = 0.1e1 / t364 / t268
  t377 = 0.1e1 / t364 / t267
  t380 = t270 * t288 / 0.6e1 - t292 * t321 / 0.18e2 - t325 * t288 / 0.48e2 + t329 * t321 / 0.240e3 + t333 * t288 / 0.640e3 - t337 * t321 / 0.4480e4 - t341 * t288 / 0.11520e5 + t345 * t321 / 0.103680e6 + t349 * t288 / 0.258048e6 - t353 * t321 / 0.2838528e7 - t357 * t288 / 0.6881280e7 + t361 * t321 / 0.89456640e8 + t365 * t288 / 0.212336640e9 - t369 * t321 / 0.3185049600e10 - t373 * t288 / 0.7431782400e10 + t377 * t321 / 0.126340300800e12
  t381 = f.my_piecewise3(t266, 0, t320)
  t382 = f.my_piecewise3(t266, 0.135e1, t264)
  t383 = 0.1e1 / t382
  t385 = jnp.erf(t383 / 0.2e1)
  t387 = t382 ** 2
  t388 = 0.1e1 / t387
  t390 = jnp.exp(-t388 / 0.4e1)
  t391 = t390 - 0.1e1
  t394 = t390 - 0.3e1 / 0.2e1 - 0.2e1 * t387 * t391
  t397 = t167 * t385 + 0.2e1 * t382 * t394
  t400 = f.my_piecewise3(t266, 0, t286)
  t401 = t390 * t388
  t405 = t387 * t382
  t406 = 0.1e1 / t405
  t410 = t382 * t391
  t415 = t406 * t400 * t390 / 0.2e1 - 0.4e1 * t410 * t400 - t383 * t400 * t390
  t418 = 0.2e1 * t382 * t415 + 0.2e1 * t400 * t394 - t401 * t400
  t421 = t387 ** 2
  t423 = 0.1e1 / t421 / t382
  t424 = t400 ** 2
  t425 = t423 * t424
  t428 = t390 * t406
  t436 = 0.1e1 / t421
  t444 = 0.1e1 / t421 / t387
  t445 = t444 * t424
  t456 = -0.2e1 * t436 * t424 * t390 + t406 * t381 * t390 / 0.2e1 + t445 * t390 / 0.4e1 - 0.4e1 * t424 * t391 - t388 * t424 * t390 - 0.4e1 * t410 * t381 - t383 * t381 * t390
  t459 = -t425 * t390 / 0.2e1 + 0.2e1 * t428 * t424 - t401 * t381 + 0.2e1 * t381 * t394 + 0.4e1 * t400 * t415 + 0.2e1 * t382 * t456
  t463 = f.my_piecewise3(t265, t380, -0.8e1 / 0.3e1 * t381 * t397 - 0.16e2 / 0.3e1 * t400 * t418 - 0.8e1 / 0.3e1 * t382 * t459)
  t464 = t24 * t463
  t473 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t52 * t89 + 0.4e1 / 0.3e1 * t18 * t96)
  t474 = t9 * t473
  t496 = f.my_piecewise3(t37, -t70 * t65 / 0.18e2 + t114 * t65 / 0.240e3 - t122 * t65 / 0.4480e4 + t130 * t65 / 0.103680e6 - t138 * t65 / 0.2838528e7 + t146 * t65 / 0.89456640e8 - t154 * t65 / 0.3185049600e10 + t162 * t65 / 0.126340300800e12, -0.8e1 / 0.3e1 * t168 * t204 - 0.8e1 / 0.3e1 * t186 * t183)
  t497 = t22 * t496
  t503 = t1 / t22 / t92
  t516 = t49 ** 2
  t517 = 0.1e1 / t516
  t519 = t517 * t82 * t59
  t524 = t28 * f.p.cam_omega * t1
  t525 = t30 * t81
  t526 = t59 * t100
  t530 = t14 ** 2
  t532 = 0.1e1 / t51 / t530
  t533 = t89 * t56
  t536 = t88 * t56
  t539 = t53 ** 2
  t540 = 0.1e1 / t539
  t543 = 0.6e1 * t10 * t540 - 0.6e1 * t93
  t547 = f.my_piecewise3(t15, 0, 0.10e2 / 0.27e2 * t532 * t533 - 0.2e1 / 0.3e1 * t536 * t96 + t52 * t543 / 0.3e1)
  t548 = t50 * t547
  t552 = -0.14e2 / 0.243e3 * t29 * t503 * t33 - 0.2e1 / 0.27e2 * t29 * t73 * t60 - t29 * t45 * t83 / 0.9e1 + t29 * t45 * t101 / 0.18e2 - t29 * t31 * t519 / 0.3e1 + t524 * t525 * t526 / 0.3e1 - t29 * t31 * t548 / 0.18e2
  t553 = f.my_piecewise3(t38, t552, 0)
  t570 = t66 * t65
  t581 = t130 * t553 / 0.103680e6 - t138 * t553 / 0.2838528e7 + t146 * t553 / 0.89456640e8 - t154 * t553 / 0.3185049600e10 + t162 * t553 / 0.126340300800e12 - t70 * t553 / 0.18e2 + t114 * t553 / 0.240e3 - t122 * t553 / 0.4480e4 - 0.2e1 / 0.3e1 * t114 * t570 + t42 * t65 * t106 / 0.2e1 + t122 * t570 / 0.8e1 - t110 * t65 * t106 / 0.16e2
  t608 = 0.1e1 / t149 / t69
  t614 = -t130 * t570 / 0.80e2 + 0.3e1 / 0.640e3 * t118 * t65 * t106 + t138 * t570 / 0.1152e4 - t126 * t65 * t106 / 0.3840e4 - t146 * t570 / 0.21504e5 + t134 * t65 * t106 / 0.86016e5 + t154 * t570 / 0.491520e6 - t142 * t65 * t106 / 0.2293760e7 - t162 * t570 / 0.13271040e8 + t150 * t65 * t106 / 0.70778880e8 + t608 * t570 / 0.412876800e9 - t158 * t65 * t106 / 0.2477260800e10
  t616 = f.my_piecewise3(t38, 0, t552)
  t623 = t210 * t186
  t627 = t209 * t186
  t628 = t176 * t166
  t631 = t207 ** 2
  t632 = 0.1e1 / t631
  t636 = t176 * t222
  t652 = t222 * t186
  t656 = 0.1e1 / t207 / t191
  t664 = t186 * t176
  t668 = 0.1e1 / t631 / t168
  t672 = t186 * t177
  t675 = t174 * t186
  t682 = 0.15e2 / 0.2e1 * t209 * t623 * t176 - 0.6e1 * t652 * t628 - 0.5e1 / 0.2e1 * t656 * t623 * t176 + t192 * t616 * t176 / 0.2e1 + 0.3e1 / 0.4e1 * t230 * t166 * t664 + t668 * t623 * t176 / 0.8e1 - 0.12e2 * t672 * t166 - 0.3e1 * t675 * t628 - 0.4e1 * t196 * t616 - t169 * t616 * t176
  t685 = 0.7e1 / 0.2e1 * t230 * t623 * t176 - 0.3e1 / 0.2e1 * t627 * t628 - t632 * t623 * t176 / 0.4e1 - 0.6e1 * t636 * t623 + 0.6e1 * t214 * t186 * t166 - t187 * t616 + 0.2e1 * t616 * t180 + 0.6e1 * t166 * t201 + 0.6e1 * t186 * t242 + 0.2e1 * t168 * t682
  t689 = f.my_piecewise3(t37, t581 + t614, -0.8e1 / 0.3e1 * t616 * t183 - 0.8e1 * t166 * t204 - 0.8e1 * t186 * t245 - 0.8e1 / 0.3e1 * t168 * t685)
  t690 = t22 * t689
  t694 = t308 * t278
  t699 = -t543
  t703 = f.my_piecewise3(t255, 0, -0.8e1 / 0.27e2 * t307 * t694 + 0.4e1 / 0.3e1 * t279 * t311 + 0.4e1 / 0.3e1 * t256 * t699)
  t704 = t9 * t703
  t718 = f.my_piecewise3(t265, 0.1e1 / t268 / 0.36e2 - t270 / 0.960e3 + t325 / 0.26880e5 - t333 / 0.829440e6 + t341 / 0.28385280e8 - t349 / 0.1073479680e10 + t357 / 0.44590694400e11 - t365 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t382 * t397)
  t719 = t22 * t718
  t724 = 0.1e1 / t23 / t11
  t746 = f.my_piecewise3(t265, -t292 * t287 / 0.18e2 + t329 * t287 / 0.240e3 - t337 * t287 / 0.4480e4 + t345 * t287 / 0.103680e6 - t353 * t287 / 0.2838528e7 + t361 * t287 / 0.89456640e8 - t369 * t287 / 0.3185049600e10 + t377 * t287 / 0.126340300800e12, -0.8e1 / 0.3e1 * t382 * t418 - 0.8e1 / 0.3e1 * t400 * t397)
  t747 = t724 * t746
  t753 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t56)
  t754 = t9 * t753
  t755 = t22 * t249
  t760 = 0.1e1 / t23 / t53
  t774 = f.my_piecewise3(t37, 0.1e1 / t40 / 0.36e2 - t42 / 0.960e3 + t110 / 0.26880e5 - t118 / 0.829440e6 + t126 / 0.28385280e8 - t134 / 0.1073479680e10 + t142 / 0.44590694400e11 - t150 / 0.2021444812800e13, 0.1e1 - 0.8e1 / 0.3e1 * t168 * t183)
  t775 = t760 * t774
  t784 = f.my_piecewise3(t255, 0, 0.4e1 / 0.9e1 * t277 * t308 + 0.4e1 / 0.3e1 * t256 * t311)
  t785 = t9 * t784
  t786 = t22 * t746
  t790 = t724 * t496
  t803 = t254 ** 2
  t805 = 0.1e1 / t276 / t803
  t806 = t308 ** 2
  t811 = t311 ** 2
  t820 = -0.24e2 * t540 + 0.24e2 * t10 / t539 / t11
  t824 = f.my_piecewise3(t255, 0, 0.40e2 / 0.81e2 * t805 * t806 - 0.16e2 / 0.9e1 * t309 * t311 + 0.4e1 / 0.3e1 * t277 * t811 + 0.16e2 / 0.9e1 * t279 * t699 + 0.4e1 / 0.3e1 * t256 * t820)
  t832 = t22 * t463
  t843 = t365 * t287
  t856 = t274 ** 2
  t857 = 0.1e1 / t856
  t859 = t857 * t301 * t281
  t863 = t30 * t300
  t864 = t281 * t315
  t870 = t307 * t278
  t876 = f.my_piecewise3(t255, 0, 0.10e2 / 0.27e2 * t805 * t694 - 0.2e1 / 0.3e1 * t870 * t311 + t277 * t699 / 0.3e1)
  t877 = t275 * t876
  t881 = -0.14e2 / 0.243e3 * t29 * t503 * t261 - 0.2e1 / 0.27e2 * t29 * t73 * t282 - t29 * t45 * t302 / 0.9e1 + t29 * t45 * t316 / 0.18e2 - t29 * t31 * t859 / 0.3e1 + t524 * t863 * t864 / 0.3e1 - t29 * t31 * t877 / 0.18e2
  t882 = f.my_piecewise3(t266, t881, 0)
  t889 = 0.1e1 / t364 / t291
  t896 = t270 * t287
  t902 = t325 * t287
  t908 = t333 * t287
  t914 = t341 * t287
  t920 = t349 * t287
  t926 = t357 * t287
  t931 = t1 / t22 / t539
  t956 = t301 ** 2
  t966 = t315 ** 2
  t990 = f.my_piecewise3(t255, 0, -0.80e2 / 0.81e2 / t276 / t803 / t254 * t806 + 0.20e2 / 0.9e1 * t805 * t308 * t311 - 0.2e1 / 0.3e1 * t307 * t811 - 0.8e1 / 0.9e1 * t870 * t699 + t277 * t820 / 0.3e1)
  t995 = 0.140e3 / 0.729e3 * t29 * t931 * t261 + 0.56e2 / 0.243e3 * t29 * t503 * t282 + 0.8e1 / 0.27e2 * t29 * t73 * t302 - 0.4e1 / 0.27e2 * t29 * t73 * t316 + 0.4e1 / 0.9e1 * t29 * t45 * t859 - 0.4e1 / 0.9e1 * t524 * t44 * t300 * t864 + 0.2e1 / 0.27e2 * t29 * t45 * t877 + 0.4e1 / 0.3e1 * t29 * t31 / t856 / t260 * t956 - 0.2e1 * t524 * t30 * t857 * t301 * t315 + t29 * t31 * t300 * t966 / 0.3e1 + 0.4e1 / 0.9e1 * t524 * t863 * t281 * t876 - t29 * t31 * t275 * t990 / 0.18e2
  t996 = f.my_piecewise3(t266, t995, 0)
  t999 = t288 ** 2
  t1004 = t321 ** 2
  t1007 = -t377 * t288 * t321 / 0.2211840e7 + t843 * t882 / 0.53084160e8 - t373 * t882 * t287 / 0.1857945600e10 + t889 * t288 * t321 / 0.68812800e8 - 0.4e1 * t329 * t288 * t321 + 0.2e1 / 0.3e1 * t896 * t882 + 0.3e1 / 0.4e1 * t337 * t288 * t321 - t902 * t882 / 0.12e2 - 0.3e1 / 0.40e2 * t345 * t288 * t321 + t908 * t882 / 0.160e3 + t353 * t288 * t321 / 0.192e3 - t914 * t882 / 0.2880e4 - t361 * t288 * t321 / 0.3584e4 + t920 * t882 / 0.64512e5 + t369 * t288 * t321 / 0.81920e5 - t926 * t882 / 0.1720320e7 - t353 * t996 / 0.2838528e7 + 0.17e2 / 0.13271040e8 * t373 * t999 - 0.7e1 / 0.8e1 * t333 * t999 + t365 * t1004 / 0.70778880e8
  t1050 = -t369 * t996 / 0.3185049600e10 + 0.3e1 / 0.640e3 * t333 * t1004 + t345 * t996 / 0.103680e6 + 0.9e1 / 0.80e2 * t341 * t999 - t341 * t1004 / 0.3840e4 + t329 * t996 / 0.240e3 + t361 * t996 / 0.89456640e8 - 0.19e2 / 0.412876800e9 / t364 / t269 * t999 + t270 * t1004 / 0.2e1 + 0.10e2 / 0.3e1 * t325 * t999 - t292 * t996 / 0.18e2 - t365 * t999 / 0.32768e5 + t377 * t996 / 0.126340300800e12 + 0.13e2 / 0.21504e5 * t357 * t999 + t349 * t1004 / 0.86016e5 - t373 * t1004 / 0.2477260800e10 - t357 * t1004 / 0.2293760e7 - 0.11e2 / 0.1152e4 * t349 * t999 - t337 * t996 / 0.4480e4 - t325 * t1004 / 0.16e2
  t1052 = f.my_piecewise3(t266, 0, t995)
  t1055 = f.my_piecewise3(t266, 0, t881)
  t1060 = t424 * t400
  t1064 = t423 * t400
  t1065 = t390 * t381
  t1068 = t421 ** 2
  t1069 = 0.1e1 / t1068
  t1073 = t390 * t436
  t1089 = t436 * t400
  t1093 = 0.1e1 / t421 / t405
  t1101 = t400 * t390
  t1105 = 0.1e1 / t1068 / t382
  t1109 = t400 * t391
  t1112 = t388 * t400
  t1119 = 0.15e2 / 0.2e1 * t423 * t1060 * t390 - 0.6e1 * t1089 * t1065 - 0.5e1 / 0.2e1 * t1093 * t1060 * t390 + t406 * t1055 * t390 / 0.2e1 + 0.3e1 / 0.4e1 * t444 * t381 * t1101 + t1105 * t1060 * t390 / 0.8e1 - 0.12e2 * t1109 * t381 - 0.3e1 * t1112 * t1065 - 0.4e1 * t410 * t1055 - t383 * t1055 * t390
  t1122 = 0.7e1 / 0.2e1 * t444 * t1060 * t390 - 0.3e1 / 0.2e1 * t1064 * t1065 - t1069 * t1060 * t390 / 0.4e1 - 0.6e1 * t1073 * t1060 + 0.6e1 * t428 * t400 * t381 - t401 * t1055 + 0.2e1 * t1055 * t394 + 0.6e1 * t381 * t415 + 0.6e1 * t400 * t456 + 0.2e1 * t382 * t1119
  t1126 = t424 ** 2
  t1132 = t381 ** 2
  t1146 = t390 * t1055
  t1207 = -0.19e2 / 0.8e1 / t1068 / t387 * t1126 * t390 + t406 * t1052 * t390 / 0.2e1 + 0.1e1 / t1068 / t421 * t1126 * t390 / 0.16e2 - 0.12e2 * t1132 * t391 - 0.16e2 * t1109 * t1055 - 0.4e1 * t410 * t1052 - t383 * t1052 * t390 + 0.85e2 / 0.4e1 * t1069 * t1126 * t390 - 0.75e2 / 0.2e1 * t444 * t1126 * t390 + 0.45e2 * t425 * t1065 - 0.6e1 * t436 * t1132 * t390 - 0.8e1 * t1089 * t1146 - 0.15e2 * t1093 * t424 * t1065 + t444 * t1055 * t1101 + 0.3e1 / 0.4e1 * t444 * t1132 * t390 + 0.3e1 / 0.4e1 * t1105 * t381 * t424 * t390 - 0.3e1 * t388 * t1132 * t390 - 0.4e1 * t1112 * t1146
  t1223 = 0.24e2 * t390 * t423 * t1126 - 0.36e2 * t1073 * t424 * t381 + 0.6e1 * t428 * t1132 + 0.8e1 * t428 * t400 * t1055 - 0.24e2 * t1093 * t1126 * t390 + 0.21e2 * t445 * t1065 - 0.3e1 / 0.2e1 * t423 * t1132 * t390 - 0.2e1 * t1064 * t1146 - 0.3e1 / 0.2e1 * t1069 * t424 * t1065 + 0.12e2 * t381 * t456 + 0.8e1 * t400 * t1119 + 0.2e1 * t382 * t1207 + 0.2e1 * t1052 * t394 + 0.8e1 * t1055 * t415 + 0.15e2 / 0.4e1 * t1105 * t1126 * t390 - 0.1e1 / t1068 / t405 * t1126 * t390 / 0.8e1 - t401 * t1052
  t1227 = f.my_piecewise3(t265, t1007 + t1050, -0.8e1 / 0.3e1 * t1052 * t397 - 0.32e2 / 0.3e1 * t1055 * t418 - 0.16e2 * t381 * t459 - 0.32e2 / 0.3e1 * t400 * t1122 - 0.8e1 / 0.3e1 * t382 * t1223)
  t1234 = f.my_piecewise3(t255, 0, 0.4e1 / 0.3e1 * t256 * t278)
  t1235 = t9 * t1234
  t1242 = t724 * t774
  t1249 = t724 * t718
  t1253 = t760 * t718
  t1258 = 0.1e1 / t23 / t92
  t1267 = -0.5e1 / 0.36e2 * t7 * t259 * t760 * t746 - 0.5e1 / 0.36e2 * t7 * t21 * t760 * t496 - 0.3e1 / 0.32e2 * t7 * t9 * t824 * t719 - 0.3e1 / 0.8e1 * t7 * t704 * t786 - 0.9e1 / 0.16e2 * t7 * t785 * t832 + t7 * t21 * t724 * t249 / 0.8e1 - 0.3e1 / 0.32e2 * t7 * t259 * t22 * t1227 + t7 * t1235 * t747 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t754 * t250 + t7 * t474 * t1242 / 0.8e1 - 0.5e1 / 0.36e2 * t7 * t754 * t775 + t7 * t785 * t1249 / 0.8e1 - 0.5e1 / 0.36e2 * t7 * t1235 * t1253 + 0.5e1 / 0.54e2 * t7 * t259 * t1258 * t718 + 0.5e1 / 0.54e2 * t7 * t21 * t1258 * t774
  t1268 = t89 ** 2
  t1273 = t96 ** 2
  t1278 = -t820
  t1282 = f.my_piecewise3(t15, 0, 0.40e2 / 0.81e2 * t532 * t1268 - 0.16e2 / 0.9e1 * t90 * t96 + 0.4e1 / 0.3e1 * t52 * t1273 + 0.16e2 / 0.9e1 * t57 * t543 + 0.4e1 / 0.3e1 * t18 * t1278)
  t1284 = t22 * t774
  t1295 = f.my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t88 * t533 + 0.4e1 / 0.3e1 * t57 * t96 + 0.4e1 / 0.3e1 * t18 * t543)
  t1296 = t9 * t1295
  t1300 = t24 * t718
  t1304 = t24 * t746
  t1308 = t288 * t287
  t1333 = -0.2e1 / 0.3e1 * t329 * t1308 + t896 * t321 / 0.2e1 + t337 * t1308 / 0.8e1 - t902 * t321 / 0.16e2 - t345 * t1308 / 0.80e2 + 0.3e1 / 0.640e3 * t908 * t321 + t353 * t1308 / 0.1152e4 - t914 * t321 / 0.3840e4 - t361 * t1308 / 0.21504e5 + t920 * t321 / 0.86016e5 + t369 * t1308 / 0.491520e6 - t926 * t321 / 0.2293760e7
  t1359 = -t377 * t1308 / 0.13271040e8 + t843 * t321 / 0.70778880e8 - t292 * t882 / 0.18e2 + t329 * t882 / 0.240e3 - t337 * t882 / 0.4480e4 + t345 * t882 / 0.103680e6 - t353 * t882 / 0.2838528e7 + t361 * t882 / 0.89456640e8 - t369 * t882 / 0.3185049600e10 + t377 * t882 / 0.126340300800e12 + t889 * t1308 / 0.412876800e9 - t373 * t287 * t321 / 0.2477260800e10
  t1370 = f.my_piecewise3(t265, t1333 + t1359, -0.8e1 / 0.3e1 * t1055 * t397 - 0.8e1 * t381 * t418 - 0.8e1 * t400 * t459 - 0.8e1 / 0.3e1 * t382 * t1122)
  t1371 = t22 * t1370
  t1378 = t24 * t774
  t1382 = t24 * t496
  t1390 = t106 ** 2
  t1393 = t66 ** 2
  t1470 = t82 ** 2
  t1480 = t100 ** 2
  t1504 = f.my_piecewise3(t15, 0, -0.80e2 / 0.81e2 / t51 / t530 / t14 * t1268 + 0.20e2 / 0.9e1 * t532 * t89 * t96 - 0.2e1 / 0.3e1 * t88 * t1273 - 0.8e1 / 0.9e1 * t536 * t543 + t52 * t1278 / 0.3e1)
  t1509 = 0.140e3 / 0.729e3 * t29 * t931 * t33 + 0.56e2 / 0.243e3 * t29 * t503 * t60 + 0.8e1 / 0.27e2 * t29 * t73 * t83 - 0.4e1 / 0.27e2 * t29 * t73 * t101 + 0.4e1 / 0.9e1 * t29 * t45 * t519 - 0.4e1 / 0.9e1 * t524 * t44 * t81 * t526 + 0.2e1 / 0.27e2 * t29 * t45 * t548 + 0.4e1 / 0.3e1 * t29 * t31 / t516 / t32 * t1470 - 0.2e1 * t524 * t30 * t517 * t82 * t100 + t29 * t31 * t81 * t1480 / 0.3e1 + 0.4e1 / 0.9e1 * t524 * t525 * t59 * t547 - t29 * t31 * t50 * t1504 / 0.18e2
  t1510 = f.my_piecewise3(t38, t1509, 0)
  t1513 = -t126 * t1390 / 0.3840e4 - 0.7e1 / 0.8e1 * t118 * t1393 + 0.13e2 / 0.21504e5 * t142 * t1393 - t146 * t66 * t106 / 0.3584e4 + t154 * t66 * t106 / 0.81920e5 - t162 * t66 * t106 / 0.2211840e7 + t608 * t66 * t106 / 0.68812800e8 - t126 * t553 * t65 / 0.2880e4 + t134 * t553 * t65 / 0.64512e5 - t142 * t553 * t65 / 0.1720320e7 + t150 * t553 * t65 / 0.53084160e8 - t158 * t553 * t65 / 0.1857945600e10 + 0.2e1 / 0.3e1 * t42 * t553 * t65 - t110 * t553 * t65 / 0.12e2 + t118 * t553 * t65 / 0.160e3 - 0.4e1 * t114 * t66 * t106 + 0.3e1 / 0.4e1 * t122 * t66 * t106 - 0.3e1 / 0.40e2 * t130 * t66 * t106 + t138 * t66 * t106 / 0.192e3 - t122 * t1510 / 0.4480e4
  t1556 = t162 * t1510 / 0.126340300800e12 + 0.17e2 / 0.13271040e8 * t158 * t1393 - t142 * t1390 / 0.2293760e7 + 0.3e1 / 0.640e3 * t118 * t1390 - t158 * t1390 / 0.2477260800e10 + t134 * t1390 / 0.86016e5 + t146 * t1510 / 0.89456640e8 + t42 * t1390 / 0.2e1 + 0.10e2 / 0.3e1 * t110 * t1393 + 0.9e1 / 0.80e2 * t126 * t1393 + t150 * t1390 / 0.70778880e8 - t70 * t1510 / 0.18e2 - t154 * t1510 / 0.3185049600e10 - t110 * t1390 / 0.16e2 - t150 * t1393 / 0.32768e5 + t114 * t1510 / 0.240e3 - t138 * t1510 / 0.2838528e7 - 0.11e2 / 0.1152e4 * t134 * t1393 + t130 * t1510 / 0.103680e6 - 0.19e2 / 0.412876800e9 / t149 / t41 * t1393
  t1558 = f.my_piecewise3(t38, 0, t1509)
  t1567 = t210 ** 2
  t1573 = t166 ** 2
  t1577 = t176 * t616
  t1653 = 0.1e1 / t631 / t207 * t1567 * t176 / 0.16e2 - 0.12e2 * t1573 * t177 - 0.16e2 * t672 * t616 - 0.4e1 * t196 * t1558 - t169 * t1558 * t176 - 0.3e1 * t174 * t1573 * t176 - 0.4e1 * t675 * t1577 - 0.75e2 / 0.2e1 * t230 * t1567 * t176 + 0.45e2 * t211 * t628 - 0.6e1 * t222 * t1573 * t176 - 0.8e1 * t652 * t1577 - 0.15e2 * t656 * t210 * t628 + t230 * t616 * t664 + 0.3e1 / 0.4e1 * t230 * t1573 * t176 + 0.3e1 / 0.4e1 * t668 * t166 * t210 * t176 + 0.85e2 / 0.4e1 * t632 * t1567 * t176 - 0.19e2 / 0.8e1 / t631 / t173 * t1567 * t176 + t192 * t1558 * t176 / 0.2e1
  t1665 = -0.24e2 * t656 * t1567 * t176 + 0.21e2 * t231 * t628 - 0.3e1 / 0.2e1 * t209 * t1573 * t176 - 0.2e1 * t627 * t1577 - 0.3e1 / 0.2e1 * t632 * t210 * t628 + 0.24e2 * t176 * t209 * t1567 - 0.36e2 * t636 * t210 * t166 + 0.6e1 * t214 * t1573 + 0.8e1 * t214 * t186 * t616 + 0.2e1 * t1558 * t180 + 0.8e1 * t616 * t201 + 0.12e2 * t166 * t242 + 0.8e1 * t186 * t682 + 0.2e1 * t168 * t1653 + 0.15e2 / 0.4e1 * t668 * t1567 * t176 - 0.1e1 / t631 / t191 * t1567 * t176 / 0.8e1 - t187 * t1558
  t1669 = f.my_piecewise3(t37, t1513 + t1556, -0.8e1 / 0.3e1 * t1558 * t183 - 0.32e2 / 0.3e1 * t616 * t204 - 0.16e2 * t166 * t245 - 0.32e2 / 0.3e1 * t186 * t685 - 0.8e1 / 0.3e1 * t168 * t1665)
  t1691 = -0.3e1 / 0.32e2 * t7 * t9 * t1282 * t1284 - 0.3e1 / 0.8e1 * t7 * t1296 * t497 - t7 * t704 * t1300 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t785 * t1304 - 0.3e1 / 0.8e1 * t7 * t1235 * t1371 - 0.9e1 / 0.16e2 * t7 * t474 * t755 - t7 * t1296 * t1378 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t474 * t1382 - t7 * t21 * t24 * t689 / 0.8e1 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t1669 + t7 * t259 * t724 * t463 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t1235 * t464 - t7 * t259 * t24 * t1370 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t754 * t690 + t7 * t754 * t790 / 0.4e1
  t1724 = t11 * (t1267 + t1691) - 0.3e1 / 0.4e1 * t7 * t754 * t1382 - 0.3e1 / 0.8e1 * t7 * t1296 * t1284 - 0.3e1 / 0.4e1 * t7 * t1235 * t1304 - 0.3e1 / 0.8e1 * t7 * t259 * t1371 - 0.3e1 / 0.8e1 * t7 * t474 * t1378 + t7 * t754 * t1242 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t785 * t1300 + t7 * t1235 * t1249 / 0.4e1 - 0.9e1 / 0.8e1 * t7 * t1235 * t832 - 0.5e1 / 0.36e2 * t7 * t259 * t1253
  d1111 = -0.3e1 / 0.8e1 * t7 * t21 * t250 - 0.3e1 / 0.8e1 * t7 * t259 * t464 - 0.9e1 / 0.8e1 * t7 * t474 * t497 - 0.3e1 / 0.8e1 * t7 * t21 * t690 - 0.3e1 / 0.8e1 * t7 * t704 * t719 + t7 * t259 * t747 / 0.4e1 - 0.9e1 / 0.8e1 * t7 * t754 * t755 - 0.5e1 / 0.36e2 * t7 * t21 * t775 - 0.9e1 / 0.8e1 * t7 * t785 * t786 + t7 * t21 * t790 / 0.4e1 + t1724

  res = {'v4rho4': d1111}
  return res
