"""Generated from lda_x_yukawa.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  lda_x_yukawa_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_yukawa(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_yukawa = lambda rs, z: lda_x_yukawa_spin(rs, z) + lda_x_yukawa_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_yukawa(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  lda_x_yukawa_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_yukawa(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_yukawa = lambda rs, z: lda_x_yukawa_spin(rs, z) + lda_x_yukawa_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_yukawa(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  lda_x_yukawa_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_yukawa(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_yukawa = lambda rs, z: lda_x_yukawa_spin(rs, z) + lda_x_yukawa_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_yukawa(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 + t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t16 * f.p.zeta_threshold
  t18 = t14 ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t15, t17, t18 * t14)
  t21 = t9 * t20
  t22 = t11 ** (0.1e1 / 0.3e1)
  t23 = 9 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t3 ** 2
  t27 = t24 * t25 * f.p.cam_omega
  t29 = t1 / t22
  t30 = f.my_piecewise3(t15, t16, t18)
  t31 = 0.1e1 / t30
  t34 = t27 * t29 * t31 / 0.18e2
  t35 = 0.192e1 <= t34
  t36 = 0.192e1 < t34
  t37 = f.my_piecewise3(t36, t34, 0.192e1)
  t38 = t37 ** 2
  t41 = t38 ** 2
  t44 = t41 * t38
  t47 = t41 ** 2
  t50 = t47 * t38
  t53 = t47 * t41
  t56 = t47 * t44
  t59 = t47 ** 2
  t83 = t59 ** 2
  t92 = 0.1e1 / t38 / 0.9e1 - 0.1e1 / t41 / 0.30e2 + 0.1e1 / t44 / 0.70e2 - 0.1e1 / t47 / 0.135e3 + 0.1e1 / t50 / 0.231e3 - 0.1e1 / t53 / 0.364e3 + 0.1e1 / t56 / 0.540e3 - 0.1e1 / t59 / 0.765e3 + 0.1e1 / t59 / t38 / 0.1045e4 - 0.1e1 / t59 / t41 / 0.1386e4 + 0.1e1 / t59 / t44 / 0.1794e4 - 0.1e1 / t59 / t47 / 0.2275e4 + 0.1e1 / t59 / t50 / 0.2835e4 - 0.1e1 / t59 / t53 / 0.3480e4 + 0.1e1 / t59 / t56 / 0.4216e4 - 0.1e1 / t83 / 0.5049e4 + 0.1e1 / t83 / t38 / 0.5985e4 - 0.1e1 / t83 / t41 / 0.7030e4
  t93 = f.my_piecewise3(t36, 0.192e1, t34)
  t94 = jnp.arctan2(0.1e1, t93)
  t95 = t93 ** 2
  t96 = t95 + 0.3e1
  t97 = 0.1e1 / t95
  t98 = 0.1e1 + t97
  t99 = jnp.log(t98)
  t101 = -t96 * t99 + 0.1e1
  t104 = t94 + t93 * t101 / 0.4e1
  t108 = f.my_piecewise3(t35, t92, 0.1e1 - 0.8e1 / 0.3e1 * t93 * t104)
  t109 = t22 * t108
  t112 = 0.3e1 / 0.32e2 * t7 * t21 * t109
  t113 = 0.1e1 - t13
  t114 = t113 <= f.p.zeta_threshold
  t115 = t113 ** (0.1e1 / 0.3e1)
  t117 = f.my_piecewise3(t114, t17, t115 * t113)
  t118 = t9 * t117
  t119 = f.my_piecewise3(t114, t16, t115)
  t120 = 0.1e1 / t119
  t123 = t27 * t29 * t120 / 0.18e2
  t124 = 0.192e1 <= t123
  t125 = 0.192e1 < t123
  t126 = f.my_piecewise3(t125, t123, 0.192e1)
  t127 = t126 ** 2
  t130 = t127 ** 2
  t133 = t130 * t127
  t136 = t130 ** 2
  t139 = t136 * t127
  t142 = t136 * t130
  t145 = t136 * t133
  t148 = t136 ** 2
  t172 = t148 ** 2
  t181 = 0.1e1 / t127 / 0.9e1 - 0.1e1 / t130 / 0.30e2 + 0.1e1 / t133 / 0.70e2 - 0.1e1 / t136 / 0.135e3 + 0.1e1 / t139 / 0.231e3 - 0.1e1 / t142 / 0.364e3 + 0.1e1 / t145 / 0.540e3 - 0.1e1 / t148 / 0.765e3 + 0.1e1 / t148 / t127 / 0.1045e4 - 0.1e1 / t148 / t130 / 0.1386e4 + 0.1e1 / t148 / t133 / 0.1794e4 - 0.1e1 / t148 / t136 / 0.2275e4 + 0.1e1 / t148 / t139 / 0.2835e4 - 0.1e1 / t148 / t142 / 0.3480e4 + 0.1e1 / t148 / t145 / 0.4216e4 - 0.1e1 / t172 / 0.5049e4 + 0.1e1 / t172 / t127 / 0.5985e4 - 0.1e1 / t172 / t130 / 0.7030e4
  t182 = f.my_piecewise3(t125, 0.192e1, t123)
  t183 = jnp.arctan2(0.1e1, t182)
  t184 = t182 ** 2
  t185 = t184 + 0.3e1
  t186 = 0.1e1 / t184
  t187 = 0.1e1 + t186
  t188 = jnp.log(t187)
  t190 = -t185 * t188 + 0.1e1
  t193 = t183 + t182 * t190 / 0.4e1
  t197 = f.my_piecewise3(t124, t181, 0.1e1 - 0.8e1 / 0.3e1 * t182 * t193)
  t198 = t22 * t197
  t201 = 0.3e1 / 0.32e2 * t7 * t118 * t198
  t202 = t11 ** 2
  t204 = t10 / t202
  t205 = t12 - t204
  t208 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t205)
  t213 = t22 ** 2
  t214 = 0.1e1 / t213
  t218 = t7 * t21 * t214 * t108 / 0.32e2
  t219 = t38 * t37
  t220 = 0.1e1 / t219
  t223 = t1 / t22 / t11
  t226 = t27 * t223 * t31 / 0.54e2
  t227 = t30 ** 2
  t228 = 0.1e1 / t227
  t229 = t18 ** 2
  t230 = 0.1e1 / t229
  t233 = f.my_piecewise3(t15, 0, t230 * t205 / 0.3e1)
  t238 = -t226 - t27 * t29 * t228 * t233 / 0.18e2
  t239 = f.my_piecewise3(t36, t238, 0)
  t242 = t41 * t37
  t243 = 0.1e1 / t242
  t246 = t41 * t219
  t247 = 0.1e1 / t246
  t250 = t47 * t37
  t251 = 0.1e1 / t250
  t254 = t47 * t219
  t255 = 0.1e1 / t254
  t258 = t47 * t242
  t259 = 0.1e1 / t258
  t262 = t47 * t246
  t263 = 0.1e1 / t262
  t267 = 0.1e1 / t59 / t37
  t271 = 0.1e1 / t59 / t219
  t275 = 0.1e1 / t59 / t242
  t279 = 0.1e1 / t59 / t246
  t283 = 0.1e1 / t59 / t250
  t287 = 0.1e1 / t59 / t254
  t291 = 0.1e1 / t59 / t258
  t295 = 0.1e1 / t59 / t262
  t299 = 0.1e1 / t83 / t37
  t303 = 0.1e1 / t83 / t219
  t307 = 0.1e1 / t83 / t242
  t310 = -0.2e1 / 0.9e1 * t220 * t239 + 0.2e1 / 0.15e2 * t243 * t239 - 0.3e1 / 0.35e2 * t247 * t239 + 0.8e1 / 0.135e3 * t251 * t239 - 0.10e2 / 0.231e3 * t255 * t239 + 0.3e1 / 0.91e2 * t259 * t239 - 0.7e1 / 0.270e3 * t263 * t239 + 0.16e2 / 0.765e3 * t267 * t239 - 0.18e2 / 0.1045e4 * t271 * t239 + 0.10e2 / 0.693e3 * t275 * t239 - 0.11e2 / 0.897e3 * t279 * t239 + 0.24e2 / 0.2275e4 * t283 * t239 - 0.26e2 / 0.2835e4 * t287 * t239 + 0.7e1 / 0.870e3 * t291 * t239 - 0.15e2 / 0.2108e4 * t295 * t239 + 0.32e2 / 0.5049e4 * t299 * t239 - 0.34e2 / 0.5985e4 * t303 * t239 + 0.18e2 / 0.3515e4 * t307 * t239
  t311 = f.my_piecewise3(t36, 0, t238)
  t314 = 0.1e1 / t98
  t322 = t96 / t95 / t93
  t333 = f.my_piecewise3(t35, t310, -0.8e1 / 0.3e1 * t311 * t104 - 0.8e1 / 0.3e1 * t93 * (-t97 * t311 * t314 + t311 * t101 / 0.4e1 + t93 * (0.2e1 * t322 * t311 * t314 - 0.2e1 * t93 * t311 * t99) / 0.4e1))
  t338 = -t205
  t341 = f.my_piecewise3(t114, 0, 0.4e1 / 0.3e1 * t115 * t338)
  t349 = t7 * t118 * t214 * t197 / 0.32e2
  t350 = t127 * t126
  t351 = 0.1e1 / t350
  t354 = t27 * t223 * t120 / 0.54e2
  t355 = t119 ** 2
  t356 = 0.1e1 / t355
  t357 = t115 ** 2
  t358 = 0.1e1 / t357
  t361 = f.my_piecewise3(t114, 0, t358 * t338 / 0.3e1)
  t366 = -t354 - t27 * t29 * t356 * t361 / 0.18e2
  t367 = f.my_piecewise3(t125, t366, 0)
  t370 = t130 * t126
  t371 = 0.1e1 / t370
  t374 = t130 * t350
  t375 = 0.1e1 / t374
  t378 = t136 * t126
  t379 = 0.1e1 / t378
  t382 = t136 * t350
  t383 = 0.1e1 / t382
  t386 = t136 * t370
  t387 = 0.1e1 / t386
  t390 = t136 * t374
  t391 = 0.1e1 / t390
  t395 = 0.1e1 / t148 / t126
  t399 = 0.1e1 / t148 / t350
  t403 = 0.1e1 / t148 / t370
  t407 = 0.1e1 / t148 / t374
  t411 = 0.1e1 / t148 / t378
  t415 = 0.1e1 / t148 / t382
  t419 = 0.1e1 / t148 / t386
  t423 = 0.1e1 / t148 / t390
  t427 = 0.1e1 / t172 / t126
  t431 = 0.1e1 / t172 / t350
  t435 = 0.1e1 / t172 / t370
  t438 = -0.2e1 / 0.9e1 * t351 * t367 + 0.2e1 / 0.15e2 * t371 * t367 - 0.3e1 / 0.35e2 * t375 * t367 + 0.8e1 / 0.135e3 * t379 * t367 - 0.10e2 / 0.231e3 * t383 * t367 + 0.3e1 / 0.91e2 * t387 * t367 - 0.7e1 / 0.270e3 * t391 * t367 + 0.16e2 / 0.765e3 * t395 * t367 - 0.18e2 / 0.1045e4 * t399 * t367 + 0.10e2 / 0.693e3 * t403 * t367 - 0.11e2 / 0.897e3 * t407 * t367 + 0.24e2 / 0.2275e4 * t411 * t367 - 0.26e2 / 0.2835e4 * t415 * t367 + 0.7e1 / 0.870e3 * t419 * t367 - 0.15e2 / 0.2108e4 * t423 * t367 + 0.32e2 / 0.5049e4 * t427 * t367 - 0.34e2 / 0.5985e4 * t431 * t367 + 0.18e2 / 0.3515e4 * t435 * t367
  t439 = f.my_piecewise3(t125, 0, t366)
  t442 = 0.1e1 / t187
  t450 = t185 / t184 / t182
  t461 = f.my_piecewise3(t124, t438, -0.8e1 / 0.3e1 * t439 * t193 - 0.8e1 / 0.3e1 * t182 * (-t186 * t439 * t442 + t439 * t190 / 0.4e1 + t182 * (-0.2e1 * t182 * t439 * t188 + 0.2e1 * t450 * t439 * t442) / 0.4e1))
  vrho_0_ = -t112 - t201 + t11 * (-0.3e1 / 0.32e2 * t7 * t9 * t208 * t109 - t218 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t333 - 0.3e1 / 0.32e2 * t7 * t9 * t341 * t198 - t349 - 0.3e1 / 0.32e2 * t7 * t118 * t22 * t461)
  t468 = -t12 - t204
  t471 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t468)
  t478 = f.my_piecewise3(t15, 0, t230 * t468 / 0.3e1)
  t483 = -t226 - t27 * t29 * t228 * t478 / 0.18e2
  t484 = f.my_piecewise3(t36, t483, 0)
  t521 = -0.2e1 / 0.9e1 * t220 * t484 + 0.2e1 / 0.15e2 * t243 * t484 - 0.3e1 / 0.35e2 * t247 * t484 + 0.8e1 / 0.135e3 * t251 * t484 - 0.10e2 / 0.231e3 * t255 * t484 + 0.3e1 / 0.91e2 * t259 * t484 - 0.7e1 / 0.270e3 * t263 * t484 + 0.16e2 / 0.765e3 * t267 * t484 - 0.18e2 / 0.1045e4 * t271 * t484 + 0.10e2 / 0.693e3 * t275 * t484 - 0.11e2 / 0.897e3 * t279 * t484 + 0.24e2 / 0.2275e4 * t283 * t484 - 0.26e2 / 0.2835e4 * t287 * t484 + 0.7e1 / 0.870e3 * t291 * t484 - 0.15e2 / 0.2108e4 * t295 * t484 + 0.32e2 / 0.5049e4 * t299 * t484 - 0.34e2 / 0.5985e4 * t303 * t484 + 0.18e2 / 0.3515e4 * t307 * t484
  t522 = f.my_piecewise3(t36, 0, t483)
  t540 = f.my_piecewise3(t35, t521, -0.8e1 / 0.3e1 * t522 * t104 - 0.8e1 / 0.3e1 * t93 * (-t97 * t522 * t314 + t522 * t101 / 0.4e1 + t93 * (0.2e1 * t322 * t522 * t314 - 0.2e1 * t93 * t522 * t99) / 0.4e1))
  t545 = -t468
  t548 = f.my_piecewise3(t114, 0, 0.4e1 / 0.3e1 * t115 * t545)
  t555 = f.my_piecewise3(t114, 0, t358 * t545 / 0.3e1)
  t560 = -t354 - t27 * t29 * t356 * t555 / 0.18e2
  t561 = f.my_piecewise3(t125, t560, 0)
  t598 = -0.2e1 / 0.9e1 * t351 * t561 + 0.2e1 / 0.15e2 * t371 * t561 - 0.3e1 / 0.35e2 * t375 * t561 + 0.8e1 / 0.135e3 * t379 * t561 - 0.10e2 / 0.231e3 * t383 * t561 + 0.3e1 / 0.91e2 * t387 * t561 - 0.7e1 / 0.270e3 * t391 * t561 + 0.16e2 / 0.765e3 * t395 * t561 - 0.18e2 / 0.1045e4 * t399 * t561 + 0.10e2 / 0.693e3 * t403 * t561 - 0.11e2 / 0.897e3 * t407 * t561 + 0.24e2 / 0.2275e4 * t411 * t561 - 0.26e2 / 0.2835e4 * t415 * t561 + 0.7e1 / 0.870e3 * t419 * t561 - 0.15e2 / 0.2108e4 * t423 * t561 + 0.32e2 / 0.5049e4 * t427 * t561 - 0.34e2 / 0.5985e4 * t431 * t561 + 0.18e2 / 0.3515e4 * t435 * t561
  t599 = f.my_piecewise3(t125, 0, t560)
  t617 = f.my_piecewise3(t124, t598, -0.8e1 / 0.3e1 * t599 * t193 - 0.8e1 / 0.3e1 * t182 * (-t186 * t599 * t442 + t599 * t190 / 0.4e1 + t182 * (-0.2e1 * t182 * t599 * t188 + 0.2e1 * t450 * t599 * t442) / 0.4e1))
  vrho_1_ = -t112 - t201 + t11 * (-0.3e1 / 0.32e2 * t7 * t9 * t471 * t109 - t218 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t540 - 0.3e1 / 0.32e2 * t7 * t9 * t548 * t198 - t349 - 0.3e1 / 0.32e2 * t7 * t118 * t22 * t617)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  lda_x_yukawa_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_yukawa(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_lda_x_yukawa = lambda rs, z: lda_x_yukawa_spin(rs, z) + lda_x_yukawa_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_yukawa(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = 0.1e1 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t10, t11 * f.p.zeta_threshold, 1)
  t15 = r0 ** (0.1e1 / 0.3e1)
  t16 = 9 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = t3 ** 2
  t20 = t17 * t18 * f.p.cam_omega
  t23 = f.my_piecewise3(t10, t11, 1)
  t24 = 0.1e1 / t23
  t27 = t20 * t1 / t15 * t24 / 0.18e2
  t28 = 0.192e1 <= t27
  t29 = 0.192e1 < t27
  t30 = f.my_piecewise3(t29, t27, 0.192e1)
  t31 = t30 ** 2
  t34 = t31 ** 2
  t37 = t34 * t31
  t40 = t34 ** 2
  t43 = t40 * t31
  t46 = t40 * t34
  t49 = t40 * t37
  t52 = t40 ** 2
  t76 = t52 ** 2
  t85 = 0.1e1 / t31 / 0.9e1 - 0.1e1 / t34 / 0.30e2 + 0.1e1 / t37 / 0.70e2 - 0.1e1 / t40 / 0.135e3 + 0.1e1 / t43 / 0.231e3 - 0.1e1 / t46 / 0.364e3 + 0.1e1 / t49 / 0.540e3 - 0.1e1 / t52 / 0.765e3 + 0.1e1 / t52 / t31 / 0.1045e4 - 0.1e1 / t52 / t34 / 0.1386e4 + 0.1e1 / t52 / t37 / 0.1794e4 - 0.1e1 / t52 / t40 / 0.2275e4 + 0.1e1 / t52 / t43 / 0.2835e4 - 0.1e1 / t52 / t46 / 0.3480e4 + 0.1e1 / t52 / t49 / 0.4216e4 - 0.1e1 / t76 / 0.5049e4 + 0.1e1 / t76 / t31 / 0.5985e4 - 0.1e1 / t76 / t34 / 0.7030e4
  t86 = f.my_piecewise3(t29, 0.192e1, t27)
  t87 = jnp.arctan2(0.1e1, t86)
  t88 = t86 ** 2
  t89 = t88 + 0.3e1
  t90 = 0.1e1 / t88
  t91 = 0.1e1 + t90
  t92 = jnp.log(t91)
  t94 = -t89 * t92 + 0.1e1
  t97 = t87 + t86 * t94 / 0.4e1
  t101 = f.my_piecewise3(t28, t85, 0.1e1 - 0.8e1 / 0.3e1 * t86 * t97)
  t106 = t15 * r0
  t110 = t31 * t30
  t116 = t20 * t1 / t106 * t24 / 0.54e2
  t117 = f.my_piecewise3(t29, -t116, 0)
  t120 = t34 * t30
  t124 = t34 * t110
  t128 = t40 * t30
  t132 = t40 * t110
  t136 = t40 * t120
  t140 = t40 * t124
  t188 = -0.2e1 / 0.9e1 / t110 * t117 + 0.2e1 / 0.15e2 / t120 * t117 - 0.3e1 / 0.35e2 / t124 * t117 + 0.8e1 / 0.135e3 / t128 * t117 - 0.10e2 / 0.231e3 / t132 * t117 + 0.3e1 / 0.91e2 / t136 * t117 - 0.7e1 / 0.270e3 / t140 * t117 + 0.16e2 / 0.765e3 / t52 / t30 * t117 - 0.18e2 / 0.1045e4 / t52 / t110 * t117 + 0.10e2 / 0.693e3 / t52 / t120 * t117 - 0.11e2 / 0.897e3 / t52 / t124 * t117 + 0.24e2 / 0.2275e4 / t52 / t128 * t117 - 0.26e2 / 0.2835e4 / t52 / t132 * t117 + 0.7e1 / 0.870e3 / t52 / t136 * t117 - 0.15e2 / 0.2108e4 / t52 / t140 * t117 + 0.32e2 / 0.5049e4 / t76 / t30 * t117 - 0.34e2 / 0.5985e4 / t76 / t110 * t117 + 0.18e2 / 0.3515e4 / t76 / t120 * t117
  t189 = f.my_piecewise3(t29, 0, -t116)
  t192 = 0.1e1 / t91
  t211 = f.my_piecewise3(t28, t188, -0.8e1 / 0.3e1 * t189 * t97 - 0.8e1 / 0.3e1 * t86 * (-t90 * t189 * t192 + t189 * t94 / 0.4e1 + t86 * (-0.2e1 * t86 * t189 * t92 + 0.2e1 * t89 / t88 / t86 * t189 * t192) / 0.4e1))
  vrho_0_ = -t1 * t3 * t6 * t9 * t13 * t15 * t101 / 0.4e1 - 0.3e1 / 0.16e2 * t106 * t1 * t3 * t6 * t9 * t13 * t211
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = 3 ** (0.1e1 / 0.3e1)
  t7 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = t10 * t12
  t14 = 0.1e1 <= f.p.zeta_threshold
  t15 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t14, t15 * f.p.zeta_threshold, 1)
  t18 = 9 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t7 ** 2
  t22 = t19 * t20 * f.p.cam_omega
  t25 = f.my_piecewise3(t14, t15, 1)
  t26 = 0.1e1 / t25
  t29 = t22 * t4 / t1 * t26 / 0.18e2
  t30 = 0.192e1 <= t29
  t31 = 0.192e1 < t29
  t32 = f.my_piecewise3(t31, t29, 0.192e1)
  t33 = t32 ** 2
  t36 = t33 ** 2
  t37 = 0.1e1 / t36
  t39 = t36 * t33
  t40 = 0.1e1 / t39
  t42 = t36 ** 2
  t43 = 0.1e1 / t42
  t45 = t42 * t33
  t46 = 0.1e1 / t45
  t48 = t42 * t36
  t49 = 0.1e1 / t48
  t51 = t42 * t39
  t52 = 0.1e1 / t51
  t54 = t42 ** 2
  t55 = 0.1e1 / t54
  t58 = 0.1e1 / t54 / t33
  t61 = 0.1e1 / t54 / t36
  t64 = 0.1e1 / t54 / t39
  t67 = 0.1e1 / t54 / t42
  t70 = 0.1e1 / t54 / t45
  t73 = 0.1e1 / t54 / t48
  t76 = 0.1e1 / t54 / t51
  t78 = t54 ** 2
  t79 = 0.1e1 / t78
  t82 = 0.1e1 / t78 / t33
  t85 = 0.1e1 / t78 / t36
  t87 = 0.1e1 / t33 / 0.9e1 - t37 / 0.30e2 + t40 / 0.70e2 - t43 / 0.135e3 + t46 / 0.231e3 - t49 / 0.364e3 + t52 / 0.540e3 - t55 / 0.765e3 + t58 / 0.1045e4 - t61 / 0.1386e4 + t64 / 0.1794e4 - t67 / 0.2275e4 + t70 / 0.2835e4 - t73 / 0.3480e4 + t76 / 0.4216e4 - t79 / 0.5049e4 + t82 / 0.5985e4 - t85 / 0.7030e4
  t88 = f.my_piecewise3(t31, 0.192e1, t29)
  t89 = jnp.arctan2(0.1e1, t88)
  t90 = t88 ** 2
  t91 = t90 + 0.3e1
  t92 = 0.1e1 / t90
  t93 = 0.1e1 + t92
  t94 = jnp.log(t93)
  t96 = -t91 * t94 + 0.1e1
  t99 = t89 + t88 * t96 / 0.4e1
  t103 = f.my_piecewise3(t30, t87, 0.1e1 - 0.8e1 / 0.3e1 * t88 * t99)
  t110 = t33 * t32
  t111 = 0.1e1 / t110
  t112 = t1 * r0
  t117 = t22 * t4 / t112 * t26 / 0.54e2
  t118 = f.my_piecewise3(t31, -t117, 0)
  t121 = t36 * t32
  t122 = 0.1e1 / t121
  t125 = t36 * t110
  t126 = 0.1e1 / t125
  t129 = t42 * t32
  t130 = 0.1e1 / t129
  t133 = t42 * t110
  t134 = 0.1e1 / t133
  t137 = t42 * t121
  t138 = 0.1e1 / t137
  t141 = t42 * t125
  t142 = 0.1e1 / t141
  t146 = 0.1e1 / t54 / t32
  t150 = 0.1e1 / t54 / t110
  t154 = 0.1e1 / t54 / t121
  t158 = 0.1e1 / t54 / t125
  t162 = 0.1e1 / t54 / t129
  t166 = 0.1e1 / t54 / t133
  t170 = 0.1e1 / t54 / t137
  t174 = 0.1e1 / t54 / t141
  t178 = 0.1e1 / t78 / t32
  t182 = 0.1e1 / t78 / t110
  t186 = 0.1e1 / t78 / t121
  t189 = -0.2e1 / 0.9e1 * t111 * t118 + 0.2e1 / 0.15e2 * t122 * t118 - 0.3e1 / 0.35e2 * t126 * t118 + 0.8e1 / 0.135e3 * t130 * t118 - 0.10e2 / 0.231e3 * t134 * t118 + 0.3e1 / 0.91e2 * t138 * t118 - 0.7e1 / 0.270e3 * t142 * t118 + 0.16e2 / 0.765e3 * t146 * t118 - 0.18e2 / 0.1045e4 * t150 * t118 + 0.10e2 / 0.693e3 * t154 * t118 - 0.11e2 / 0.897e3 * t158 * t118 + 0.24e2 / 0.2275e4 * t162 * t118 - 0.26e2 / 0.2835e4 * t166 * t118 + 0.7e1 / 0.870e3 * t170 * t118 - 0.15e2 / 0.2108e4 * t174 * t118 + 0.32e2 / 0.5049e4 * t178 * t118 - 0.34e2 / 0.5985e4 * t182 * t118 + 0.18e2 / 0.3515e4 * t186 * t118
  t190 = f.my_piecewise3(t31, 0, -t117)
  t193 = 0.1e1 / t93
  t200 = 0.1e1 / t90 / t88
  t201 = t91 * t200
  t205 = 0.2e1 * t201 * t190 * t193 - 0.2e1 * t88 * t190 * t94
  t208 = -t92 * t190 * t193 + t190 * t96 / 0.4e1 + t88 * t205 / 0.4e1
  t212 = f.my_piecewise3(t30, t189, -0.8e1 / 0.3e1 * t190 * t99 - 0.8e1 / 0.3e1 * t88 * t208)
  t219 = r0 ** 2
  t225 = 0.2e1 / 0.81e2 * t22 * t4 / t1 / t219 * t26
  t226 = f.my_piecewise3(t31, t225, 0)
  t247 = t118 ** 2
  t264 = 0.24e2 / 0.2275e4 * t162 * t226 - 0.26e2 / 0.2835e4 * t166 * t226 + 0.7e1 / 0.870e3 * t170 * t226 - 0.15e2 / 0.2108e4 * t174 * t226 + 0.32e2 / 0.5049e4 * t178 * t226 - 0.34e2 / 0.5985e4 * t182 * t226 + 0.18e2 / 0.3515e4 * t186 * t226 - 0.2e1 / 0.9e1 * t111 * t226 + 0.2e1 / 0.15e2 * t122 * t226 - 0.3e1 / 0.35e2 * t126 * t226 + 0.2e1 / 0.3e1 * t37 * t247 - 0.2e1 / 0.3e1 * t40 * t247 + 0.3e1 / 0.5e1 * t43 * t247 - 0.8e1 / 0.15e2 * t46 * t247 + 0.10e2 / 0.21e2 * t49 * t247 - 0.3e1 / 0.7e1 * t52 * t247 + 0.7e1 / 0.18e2 * t55 * t247 - 0.16e2 / 0.45e2 * t58 * t247
  t303 = 0.18e2 / 0.55e2 * t61 * t247 - 0.10e2 / 0.33e2 * t64 * t247 + 0.11e2 / 0.39e2 * t67 * t247 - 0.24e2 / 0.91e2 * t70 * t247 + 0.26e2 / 0.105e3 * t73 * t247 - 0.7e1 / 0.30e2 * t76 * t247 + 0.15e2 / 0.68e2 * t79 * t247 - 0.32e2 / 0.153e3 * t82 * t247 + 0.34e2 / 0.171e3 * t85 * t247 - 0.18e2 / 0.95e2 / t78 / t39 * t247 + 0.8e1 / 0.135e3 * t130 * t226 - 0.10e2 / 0.231e3 * t134 * t226 + 0.3e1 / 0.91e2 * t138 * t226 - 0.7e1 / 0.270e3 * t142 * t226 + 0.16e2 / 0.765e3 * t146 * t226 - 0.18e2 / 0.1045e4 * t150 * t226 + 0.10e2 / 0.693e3 * t154 * t226 - 0.11e2 / 0.897e3 * t158 * t226
  t305 = f.my_piecewise3(t31, 0, t225)
  t310 = t190 ** 2
  t316 = t90 ** 2
  t320 = t93 ** 2
  t321 = 0.1e1 / t320
  t357 = f.my_piecewise3(t30, t264 + t303, -0.8e1 / 0.3e1 * t305 * t99 - 0.16e2 / 0.3e1 * t190 * t208 - 0.8e1 / 0.3e1 * t88 * (0.2e1 * t200 * t310 * t193 - t92 * t305 * t193 - 0.2e1 / t316 / t88 * t310 * t321 + t305 * t96 / 0.4e1 + t190 * t205 / 0.2e1 + t88 * (-0.2e1 * t310 * t94 - 0.2e1 * t88 * t305 * t94 + 0.8e1 * t92 * t310 * t193 - 0.6e1 * t91 / t316 * t310 * t193 + 0.2e1 * t201 * t305 * t193 + 0.4e1 * t91 / t316 / t90 * t310 * t321) / 0.4e1))
  v2rho2_0_ = -0.1e1 / t2 * t4 * t7 * t13 * t17 * t103 / 0.12e2 - t1 * t4 * t7 * t13 * t17 * t212 / 0.2e1 - 0.3e1 / 0.16e2 * t112 * t4 * t7 * t13 * t17 * t357
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t5 = 3 ** (0.1e1 / 0.3e1)
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = 2 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t11 * t13
  t15 = 0.1e1 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = f.my_piecewise3(t15, t16 * f.p.zeta_threshold, 1)
  t19 = 9 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t8 ** 2
  t23 = t20 * t21 * f.p.cam_omega
  t26 = f.my_piecewise3(t15, t16, 1)
  t27 = 0.1e1 / t26
  t30 = t23 * t5 / t1 * t27 / 0.18e2
  t31 = 0.192e1 <= t30
  t32 = 0.192e1 < t30
  t33 = f.my_piecewise3(t32, t30, 0.192e1)
  t34 = t33 ** 2
  t37 = t34 ** 2
  t38 = 0.1e1 / t37
  t40 = t37 * t34
  t41 = 0.1e1 / t40
  t43 = t37 ** 2
  t44 = 0.1e1 / t43
  t46 = t43 * t34
  t47 = 0.1e1 / t46
  t49 = t43 * t37
  t50 = 0.1e1 / t49
  t52 = t43 * t40
  t53 = 0.1e1 / t52
  t55 = t43 ** 2
  t56 = 0.1e1 / t55
  t59 = 0.1e1 / t55 / t34
  t62 = 0.1e1 / t55 / t37
  t65 = 0.1e1 / t55 / t40
  t68 = 0.1e1 / t55 / t43
  t71 = 0.1e1 / t55 / t46
  t74 = 0.1e1 / t55 / t49
  t77 = 0.1e1 / t55 / t52
  t79 = t55 ** 2
  t80 = 0.1e1 / t79
  t83 = 0.1e1 / t79 / t34
  t86 = 0.1e1 / t79 / t37
  t88 = 0.1e1 / t34 / 0.9e1 - t38 / 0.30e2 + t41 / 0.70e2 - t44 / 0.135e3 + t47 / 0.231e3 - t50 / 0.364e3 + t53 / 0.540e3 - t56 / 0.765e3 + t59 / 0.1045e4 - t62 / 0.1386e4 + t65 / 0.1794e4 - t68 / 0.2275e4 + t71 / 0.2835e4 - t74 / 0.3480e4 + t77 / 0.4216e4 - t80 / 0.5049e4 + t83 / 0.5985e4 - t86 / 0.7030e4
  t89 = f.my_piecewise3(t32, 0.192e1, t30)
  t90 = jnp.atan2(0.1e1, t89)
  t91 = t89 ** 2
  t92 = t91 + 0.3e1
  t93 = 0.1e1 / t91
  t94 = 0.1e1 + t93
  t95 = jnp.log(t94)
  t97 = -t92 * t95 + 0.1e1
  t100 = t90 + t89 * t97 / 0.4e1
  t104 = f.my_piecewise3(t31, t88, 0.1e1 - 0.8e1 / 0.3e1 * t89 * t100)
  t112 = t34 * t33
  t113 = 0.1e1 / t112
  t114 = t1 * r0
  t119 = t23 * t5 / t114 * t27 / 0.54e2
  t120 = f.my_piecewise3(t32, -t119, 0)
  t123 = t37 * t33
  t124 = 0.1e1 / t123
  t127 = t37 * t112
  t128 = 0.1e1 / t127
  t131 = t43 * t33
  t132 = 0.1e1 / t131
  t135 = t43 * t112
  t136 = 0.1e1 / t135
  t139 = t43 * t123
  t140 = 0.1e1 / t139
  t143 = t43 * t127
  t144 = 0.1e1 / t143
  t148 = 0.1e1 / t55 / t33
  t152 = 0.1e1 / t55 / t112
  t156 = 0.1e1 / t55 / t123
  t160 = 0.1e1 / t55 / t127
  t164 = 0.1e1 / t55 / t131
  t168 = 0.1e1 / t55 / t135
  t172 = 0.1e1 / t55 / t139
  t176 = 0.1e1 / t55 / t143
  t180 = 0.1e1 / t79 / t33
  t184 = 0.1e1 / t79 / t112
  t188 = 0.1e1 / t79 / t123
  t191 = -0.2e1 / 0.9e1 * t113 * t120 + 0.2e1 / 0.15e2 * t124 * t120 - 0.3e1 / 0.35e2 * t128 * t120 + 0.8e1 / 0.135e3 * t132 * t120 - 0.10e2 / 0.231e3 * t136 * t120 + 0.3e1 / 0.91e2 * t140 * t120 - 0.7e1 / 0.270e3 * t144 * t120 + 0.16e2 / 0.765e3 * t148 * t120 - 0.18e2 / 0.1045e4 * t152 * t120 + 0.10e2 / 0.693e3 * t156 * t120 - 0.11e2 / 0.897e3 * t160 * t120 + 0.24e2 / 0.2275e4 * t164 * t120 - 0.26e2 / 0.2835e4 * t168 * t120 + 0.7e1 / 0.870e3 * t172 * t120 - 0.15e2 / 0.2108e4 * t176 * t120 + 0.32e2 / 0.5049e4 * t180 * t120 - 0.34e2 / 0.5985e4 * t184 * t120 + 0.18e2 / 0.3515e4 * t188 * t120
  t192 = f.my_piecewise3(t32, 0, -t119)
  t195 = 0.1e1 / t94
  t201 = t91 * t89
  t202 = 0.1e1 / t201
  t203 = t92 * t202
  t204 = t192 * t195
  t207 = -0.2e1 * t89 * t192 * t95 + 0.2e1 * t203 * t204
  t210 = -t93 * t192 * t195 + t192 * t97 / 0.4e1 + t89 * t207 / 0.4e1
  t214 = f.my_piecewise3(t31, t191, -0.8e1 / 0.3e1 * t192 * t100 - 0.8e1 / 0.3e1 * t89 * t210)
  t221 = r0 ** 2
  t227 = 0.2e1 / 0.81e2 * t23 * t5 / t1 / t221 * t27
  t228 = f.my_piecewise3(t32, t227, 0)
  t237 = t120 ** 2
  t266 = -0.11e2 / 0.897e3 * t160 * t228 + 0.24e2 / 0.2275e4 * t164 * t228 - 0.26e2 / 0.2835e4 * t168 * t228 + 0.7e1 / 0.870e3 * t172 * t228 + 0.2e1 / 0.3e1 * t38 * t237 - 0.2e1 / 0.3e1 * t41 * t237 + 0.3e1 / 0.5e1 * t44 * t237 - 0.8e1 / 0.15e2 * t47 * t237 + 0.10e2 / 0.21e2 * t50 * t237 - 0.3e1 / 0.7e1 * t53 * t237 + 0.7e1 / 0.18e2 * t56 * t237 - 0.16e2 / 0.45e2 * t59 * t237 + 0.18e2 / 0.55e2 * t62 * t237 - 0.10e2 / 0.33e2 * t65 * t237 + 0.11e2 / 0.39e2 * t68 * t237 - 0.24e2 / 0.91e2 * t71 * t237 + 0.26e2 / 0.105e3 * t74 * t237 - 0.7e1 / 0.30e2 * t77 * t237
  t274 = 0.1e1 / t79 / t40
  t305 = 0.15e2 / 0.68e2 * t80 * t237 - 0.32e2 / 0.153e3 * t83 * t237 + 0.34e2 / 0.171e3 * t86 * t237 - 0.18e2 / 0.95e2 * t274 * t237 - 0.15e2 / 0.2108e4 * t176 * t228 + 0.32e2 / 0.5049e4 * t180 * t228 - 0.34e2 / 0.5985e4 * t184 * t228 + 0.18e2 / 0.3515e4 * t188 * t228 - 0.2e1 / 0.9e1 * t113 * t228 + 0.2e1 / 0.15e2 * t124 * t228 - 0.3e1 / 0.35e2 * t128 * t228 + 0.8e1 / 0.135e3 * t132 * t228 - 0.10e2 / 0.231e3 * t136 * t228 + 0.3e1 / 0.91e2 * t140 * t228 - 0.7e1 / 0.270e3 * t144 * t228 + 0.16e2 / 0.765e3 * t148 * t228 - 0.18e2 / 0.1045e4 * t152 * t228 + 0.10e2 / 0.693e3 * t156 * t228
  t307 = f.my_piecewise3(t32, 0, t227)
  t312 = t192 ** 2
  t316 = t93 * t307
  t318 = t91 ** 2
  t320 = 0.1e1 / t318 / t89
  t322 = t94 ** 2
  t323 = 0.1e1 / t322
  t338 = 0.1e1 / t318
  t339 = t92 * t338
  t343 = t307 * t195
  t347 = 0.1e1 / t318 / t91
  t348 = t92 * t347
  t352 = -0.6e1 * t339 * t312 * t195 + 0.8e1 * t93 * t312 * t195 - 0.2e1 * t89 * t307 * t95 + 0.4e1 * t348 * t312 * t323 + 0.2e1 * t203 * t343 - 0.2e1 * t312 * t95
  t355 = 0.2e1 * t202 * t312 * t195 - t316 * t195 - 0.2e1 * t320 * t312 * t323 + t307 * t97 / 0.4e1 + t192 * t207 / 0.2e1 + t89 * t352 / 0.4e1
  t359 = f.my_piecewise3(t31, t266 + t305, -0.8e1 / 0.3e1 * t307 * t100 - 0.16e2 / 0.3e1 * t192 * t210 - 0.8e1 / 0.3e1 * t89 * t355)
  t405 = -0.54e2 / 0.95e2 * t274 * t120 * t228 + 0.34e2 / 0.57e2 * t86 * t120 * t228 - 0.32e2 / 0.51e2 * t83 * t120 * t228 + 0.45e2 / 0.68e2 * t80 * t120 * t228 - 0.7e1 / 0.10e2 * t77 * t120 * t228 + 0.26e2 / 0.35e2 * t74 * t120 * t228 - 0.72e2 / 0.91e2 * t71 * t120 * t228 + 0.11e2 / 0.13e2 * t68 * t120 * t228 - 0.10e2 / 0.11e2 * t65 * t120 * t228 + 0.54e2 / 0.55e2 * t62 * t120 * t228 - 0.16e2 / 0.15e2 * t59 * t120 * t228 + 0.7e1 / 0.6e1 * t56 * t120 * t228 - 0.9e1 / 0.7e1 * t53 * t120 * t228
  t427 = 0.14e2 / 0.243e3 * t23 * t5 / t1 / t221 / r0 * t27
  t428 = f.my_piecewise3(t32, -t427, 0)
  t447 = 0.10e2 / 0.7e1 * t50 * t120 * t228 - 0.8e1 / 0.5e1 * t47 * t120 * t228 + 0.9e1 / 0.5e1 * t44 * t120 * t228 - 0.2e1 * t41 * t120 * t228 + 0.2e1 * t38 * t120 * t228 + 0.32e2 / 0.5049e4 * t180 * t428 - 0.15e2 / 0.2108e4 * t176 * t428 + 0.7e1 / 0.870e3 * t172 * t428 - 0.26e2 / 0.2835e4 * t168 * t428 + 0.24e2 / 0.2275e4 * t164 * t428 - 0.11e2 / 0.897e3 * t160 * t428 + 0.10e2 / 0.693e3 * t156 * t428 - 0.18e2 / 0.1045e4 * t152 * t428 + 0.16e2 / 0.765e3 * t148 * t428
  t469 = t237 * t120
  t478 = -0.7e1 / 0.270e3 * t144 * t428 + 0.3e1 / 0.91e2 * t140 * t428 - 0.10e2 / 0.231e3 * t136 * t428 + 0.8e1 / 0.135e3 * t132 * t428 - 0.3e1 / 0.35e2 * t128 * t428 + 0.2e1 / 0.15e2 * t124 * t428 - 0.2e1 / 0.9e1 * t113 * t428 + 0.18e2 / 0.3515e4 * t188 * t428 - 0.34e2 / 0.5985e4 * t184 * t428 + 0.36e2 / 0.5e1 / t79 / t127 * t469 - 0.136e3 / 0.19e2 * t188 * t469 + 0.64e2 / 0.9e1 * t184 * t469 - 0.120e3 / 0.17e2 * t180 * t469
  t507 = 0.7e1 * t176 * t469 - 0.104e3 / 0.15e2 * t172 * t469 + 0.48e2 / 0.7e1 * t168 * t469 - 0.88e2 / 0.13e2 * t164 * t469 + 0.20e2 / 0.3e1 * t160 * t469 - 0.72e2 / 0.11e2 * t156 * t469 + 0.32e2 / 0.5e1 * t152 * t469 - 0.56e2 / 0.9e1 * t148 * t469 + 0.6e1 * t144 * t469 - 0.40e2 / 0.7e1 * t140 * t469 + 0.16e2 / 0.3e1 * t136 * t469 - 0.24e2 / 0.5e1 * t132 * t469 + 0.4e1 * t128 * t469 - 0.8e1 / 0.3e1 * t124 * t469
  t510 = f.my_piecewise3(t32, 0, -t427)
  t517 = t312 * t192
  t533 = t318 ** 2
  t537 = 0.1e1 / t322 / t94
  t586 = -0.6e1 * t192 * t95 * t307 - 0.24e2 * t517 * t202 * t195 - 0.2e1 * t89 * t510 * t95 + 0.24e2 * t316 * t204 + 0.24e2 * t320 * t517 * t323 + 0.24e2 * t92 * t320 * t517 * t195 - 0.18e2 * t339 * t204 * t307 - 0.36e2 * t92 / t318 / t201 * t517 * t323 + 0.2e1 * t203 * t510 * t195 + 0.12e2 * t348 * t307 * t323 * t192 + 0.16e2 * t92 / t533 / t89 * t517 * t537
  t593 = f.my_piecewise3(t31, t405 + t447 + t478 + t507, -0.8e1 / 0.3e1 * t510 * t100 - 0.8e1 * t307 * t210 - 0.8e1 * t192 * t355 - 0.8e1 / 0.3e1 * t89 * (-0.6e1 * t338 * t517 * t195 + 0.6e1 * t202 * t192 * t343 + 0.14e2 * t347 * t517 * t323 - t93 * t510 * t195 - 0.6e1 * t320 * t307 * t323 * t192 - 0.8e1 / t533 * t517 * t537 + t510 * t97 / 0.4e1 + 0.3e1 / 0.4e1 * t307 * t207 + 0.3e1 / 0.4e1 * t192 * t352 + t89 * t586 / 0.4e1))
  v3rho3_0_ = 0.1e1 / t2 / r0 * t5 * t8 * t14 * t18 * t104 / 0.18e2 - 0.1e1 / t2 * t5 * t8 * t14 * t18 * t214 / 0.4e1 - 0.3e1 / 0.4e1 * t1 * t5 * t8 * t14 * t18 * t359 - 0.3e1 / 0.16e2 * t114 * t5 * t8 * t14 * t18 * t593

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t6 = 3 ** (0.1e1 / 0.3e1)
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = 2 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t15 = t12 * t14
  t16 = 0.1e1 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t16, t17 * f.p.zeta_threshold, 1)
  t20 = 9 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = t9 ** 2
  t24 = t21 * t22 * f.p.cam_omega
  t27 = f.my_piecewise3(t16, t17, 1)
  t28 = 0.1e1 / t27
  t31 = t24 * t6 / t2 * t28 / 0.18e2
  t32 = 0.192e1 <= t31
  t33 = 0.192e1 < t31
  t34 = f.my_piecewise3(t33, t31, 0.192e1)
  t35 = t34 ** 2
  t38 = t35 ** 2
  t39 = 0.1e1 / t38
  t41 = t38 * t35
  t42 = 0.1e1 / t41
  t44 = t38 ** 2
  t45 = 0.1e1 / t44
  t47 = t44 * t35
  t48 = 0.1e1 / t47
  t50 = t44 * t38
  t51 = 0.1e1 / t50
  t53 = t44 * t41
  t54 = 0.1e1 / t53
  t56 = t44 ** 2
  t57 = 0.1e1 / t56
  t60 = 0.1e1 / t56 / t35
  t63 = 0.1e1 / t56 / t38
  t66 = 0.1e1 / t56 / t41
  t69 = 0.1e1 / t56 / t44
  t72 = 0.1e1 / t56 / t47
  t75 = 0.1e1 / t56 / t50
  t78 = 0.1e1 / t56 / t53
  t80 = t56 ** 2
  t81 = 0.1e1 / t80
  t84 = 0.1e1 / t80 / t35
  t87 = 0.1e1 / t80 / t38
  t89 = 0.1e1 / t35 / 0.9e1 - t39 / 0.30e2 + t42 / 0.70e2 - t45 / 0.135e3 + t48 / 0.231e3 - t51 / 0.364e3 + t54 / 0.540e3 - t57 / 0.765e3 + t60 / 0.1045e4 - t63 / 0.1386e4 + t66 / 0.1794e4 - t69 / 0.2275e4 + t72 / 0.2835e4 - t75 / 0.3480e4 + t78 / 0.4216e4 - t81 / 0.5049e4 + t84 / 0.5985e4 - t87 / 0.7030e4
  t90 = f.my_piecewise3(t33, 0.192e1, t31)
  t91 = jnp.atan2(0.1e1, t90)
  t92 = t90 ** 2
  t93 = t92 + 0.3e1
  t94 = 0.1e1 / t92
  t95 = 0.1e1 + t94
  t96 = jnp.log(t95)
  t98 = -t93 * t96 + 0.1e1
  t101 = t91 + t90 * t98 / 0.4e1
  t105 = f.my_piecewise3(t32, t89, 0.1e1 - 0.8e1 / 0.3e1 * t90 * t101)
  t114 = t35 * t34
  t115 = 0.1e1 / t114
  t116 = t2 * r0
  t121 = t24 * t6 / t116 * t28 / 0.54e2
  t122 = f.my_piecewise3(t33, -t121, 0)
  t125 = t38 * t34
  t126 = 0.1e1 / t125
  t129 = t38 * t114
  t130 = 0.1e1 / t129
  t133 = t44 * t34
  t134 = 0.1e1 / t133
  t137 = t44 * t114
  t138 = 0.1e1 / t137
  t141 = t44 * t125
  t142 = 0.1e1 / t141
  t145 = t44 * t129
  t146 = 0.1e1 / t145
  t150 = 0.1e1 / t56 / t34
  t154 = 0.1e1 / t56 / t114
  t158 = 0.1e1 / t56 / t125
  t162 = 0.1e1 / t56 / t129
  t166 = 0.1e1 / t56 / t133
  t170 = 0.1e1 / t56 / t137
  t174 = 0.1e1 / t56 / t141
  t178 = 0.1e1 / t56 / t145
  t182 = 0.1e1 / t80 / t34
  t186 = 0.1e1 / t80 / t114
  t190 = 0.1e1 / t80 / t125
  t193 = -0.2e1 / 0.9e1 * t115 * t122 + 0.2e1 / 0.15e2 * t126 * t122 - 0.3e1 / 0.35e2 * t130 * t122 + 0.8e1 / 0.135e3 * t134 * t122 - 0.10e2 / 0.231e3 * t138 * t122 + 0.3e1 / 0.91e2 * t142 * t122 - 0.7e1 / 0.270e3 * t146 * t122 + 0.16e2 / 0.765e3 * t150 * t122 - 0.18e2 / 0.1045e4 * t154 * t122 + 0.10e2 / 0.693e3 * t158 * t122 - 0.11e2 / 0.897e3 * t162 * t122 + 0.24e2 / 0.2275e4 * t166 * t122 - 0.26e2 / 0.2835e4 * t170 * t122 + 0.7e1 / 0.870e3 * t174 * t122 - 0.15e2 / 0.2108e4 * t178 * t122 + 0.32e2 / 0.5049e4 * t182 * t122 - 0.34e2 / 0.5985e4 * t186 * t122 + 0.18e2 / 0.3515e4 * t190 * t122
  t194 = f.my_piecewise3(t33, 0, -t121)
  t197 = 0.1e1 / t95
  t203 = t92 * t90
  t204 = 0.1e1 / t203
  t205 = t93 * t204
  t206 = t194 * t197
  t209 = -0.2e1 * t90 * t194 * t96 + 0.2e1 * t205 * t206
  t212 = -t94 * t194 * t197 + t194 * t98 / 0.4e1 + t90 * t209 / 0.4e1
  t216 = f.my_piecewise3(t32, t193, -0.8e1 / 0.3e1 * t194 * t101 - 0.8e1 / 0.3e1 * t90 * t212)
  t224 = t122 ** 2
  t240 = 0.1e1 / t80 / t41
  t248 = 0.2e1 / 0.81e2 * t24 * t6 / t2 / t1 * t28
  t249 = f.my_piecewise3(t33, t248, 0)
  t270 = 0.11e2 / 0.39e2 * t69 * t224 - 0.24e2 / 0.91e2 * t72 * t224 + 0.26e2 / 0.105e3 * t75 * t224 - 0.7e1 / 0.30e2 * t78 * t224 + 0.15e2 / 0.68e2 * t81 * t224 - 0.32e2 / 0.153e3 * t84 * t224 + 0.34e2 / 0.171e3 * t87 * t224 - 0.18e2 / 0.95e2 * t240 * t224 - 0.10e2 / 0.231e3 * t138 * t249 + 0.3e1 / 0.91e2 * t142 * t249 - 0.7e1 / 0.270e3 * t146 * t249 + 0.16e2 / 0.765e3 * t150 * t249 - 0.18e2 / 0.1045e4 * t154 * t249 + 0.10e2 / 0.693e3 * t158 * t249 - 0.11e2 / 0.897e3 * t162 * t249 + 0.24e2 / 0.2275e4 * t166 * t249 - 0.26e2 / 0.2835e4 * t170 * t249 + 0.7e1 / 0.870e3 * t174 * t249
  t307 = -0.15e2 / 0.2108e4 * t178 * t249 + 0.32e2 / 0.5049e4 * t182 * t249 - 0.34e2 / 0.5985e4 * t186 * t249 + 0.18e2 / 0.3515e4 * t190 * t249 - 0.2e1 / 0.9e1 * t115 * t249 + 0.2e1 / 0.15e2 * t126 * t249 - 0.3e1 / 0.35e2 * t130 * t249 + 0.8e1 / 0.135e3 * t134 * t249 + 0.2e1 / 0.3e1 * t39 * t224 - 0.2e1 / 0.3e1 * t42 * t224 + 0.3e1 / 0.5e1 * t45 * t224 - 0.8e1 / 0.15e2 * t48 * t224 + 0.10e2 / 0.21e2 * t51 * t224 - 0.3e1 / 0.7e1 * t54 * t224 + 0.7e1 / 0.18e2 * t57 * t224 - 0.16e2 / 0.45e2 * t60 * t224 + 0.18e2 / 0.55e2 * t63 * t224 - 0.10e2 / 0.33e2 * t66 * t224
  t309 = f.my_piecewise3(t33, 0, t248)
  t314 = t194 ** 2
  t315 = t204 * t314
  t318 = t94 * t309
  t320 = t92 ** 2
  t322 = 0.1e1 / t320 / t90
  t324 = t95 ** 2
  t325 = 0.1e1 / t324
  t340 = 0.1e1 / t320
  t341 = t93 * t340
  t342 = t314 * t197
  t345 = t309 * t197
  t349 = 0.1e1 / t320 / t92
  t350 = t93 * t349
  t351 = t314 * t325
  t354 = 0.8e1 * t94 * t314 * t197 - 0.2e1 * t90 * t309 * t96 + 0.2e1 * t205 * t345 - 0.2e1 * t314 * t96 - 0.6e1 * t341 * t342 + 0.4e1 * t350 * t351
  t357 = 0.2e1 * t315 * t197 - t318 * t197 - 0.2e1 * t322 * t314 * t325 + t309 * t98 / 0.4e1 + t194 * t209 / 0.2e1 + t90 * t354 / 0.4e1
  t361 = f.my_piecewise3(t32, t270 + t307, -0.8e1 / 0.3e1 * t309 * t101 - 0.16e2 / 0.3e1 * t194 * t212 - 0.8e1 / 0.3e1 * t90 * t357)
  t368 = t224 * t122
  t395 = -0.104e3 / 0.15e2 * t174 * t368 + 0.48e2 / 0.7e1 * t170 * t368 - 0.88e2 / 0.13e2 * t166 * t368 + 0.20e2 / 0.3e1 * t162 * t368 - 0.72e2 / 0.11e2 * t158 * t368 + 0.32e2 / 0.5e1 * t154 * t368 - 0.56e2 / 0.9e1 * t150 * t368 + 0.6e1 * t146 * t368 - 0.40e2 / 0.7e1 * t142 * t368 + 0.16e2 / 0.3e1 * t138 * t368 - 0.24e2 / 0.5e1 * t134 * t368 + 0.4e1 * t130 * t368 - 0.8e1 / 0.3e1 * t126 * t368
  t402 = 0.14e2 / 0.243e3 * t24 * t6 / t2 / t1 / r0 * t28
  t403 = f.my_piecewise3(t33, -t402, 0)
  t432 = 0.8e1 / 0.135e3 * t134 * t403 - 0.3e1 / 0.35e2 * t130 * t403 + 0.2e1 / 0.15e2 * t126 * t403 - 0.2e1 / 0.9e1 * t115 * t403 + 0.18e2 / 0.3515e4 * t190 * t403 - 0.34e2 / 0.5985e4 * t186 * t403 + 0.32e2 / 0.5049e4 * t182 * t403 - 0.15e2 / 0.2108e4 * t178 * t403 + 0.7e1 / 0.870e3 * t174 * t403 - 0.26e2 / 0.2835e4 * t170 * t403 + 0.24e2 / 0.2275e4 * t166 * t403 - 0.11e2 / 0.897e3 * t162 * t403 + 0.10e2 / 0.693e3 * t158 * t403 - 0.18e2 / 0.1045e4 * t154 * t403
  t443 = 0.1e1 / t80 / t129
  t466 = 0.16e2 / 0.765e3 * t150 * t403 - 0.7e1 / 0.270e3 * t146 * t403 + 0.3e1 / 0.91e2 * t142 * t403 - 0.10e2 / 0.231e3 * t138 * t403 + 0.36e2 / 0.5e1 * t443 * t368 - 0.136e3 / 0.19e2 * t190 * t368 + 0.64e2 / 0.9e1 * t186 * t368 - 0.120e3 / 0.17e2 * t182 * t368 + 0.7e1 * t178 * t368 + 0.45e2 / 0.68e2 * t81 * t249 * t122 - 0.7e1 / 0.10e2 * t78 * t249 * t122 + 0.26e2 / 0.35e2 * t75 * t249 * t122 - 0.72e2 / 0.91e2 * t72 * t249 * t122
  t509 = 0.11e2 / 0.13e2 * t69 * t249 * t122 - 0.10e2 / 0.11e2 * t66 * t249 * t122 + 0.54e2 / 0.55e2 * t63 * t249 * t122 - 0.16e2 / 0.15e2 * t60 * t249 * t122 + 0.7e1 / 0.6e1 * t57 * t249 * t122 - 0.9e1 / 0.7e1 * t54 * t249 * t122 + 0.10e2 / 0.7e1 * t51 * t249 * t122 - 0.54e2 / 0.95e2 * t240 * t122 * t249 + 0.34e2 / 0.57e2 * t87 * t122 * t249 - 0.32e2 / 0.51e2 * t84 * t122 * t249 - 0.8e1 / 0.5e1 * t48 * t122 * t249 + 0.9e1 / 0.5e1 * t45 * t122 * t249 - 0.2e1 * t42 * t122 * t249 + 0.2e1 * t39 * t122 * t249
  t512 = f.my_piecewise3(t33, 0, -t402)
  t519 = t314 * t194
  t523 = t204 * t194
  t529 = t94 * t512
  t531 = t322 * t309
  t532 = t325 * t194
  t535 = t320 ** 2
  t536 = 0.1e1 / t535
  t539 = 0.1e1 / t324 / t95
  t548 = t194 * t96
  t562 = t93 * t322
  t570 = 0.1e1 / t320 / t203
  t571 = t93 * t570
  t575 = t512 * t197
  t578 = t309 * t325
  t583 = 0.1e1 / t535 / t90
  t584 = t93 * t583
  t588 = 0.12e2 * t350 * t578 * t194 - 0.24e2 * t519 * t204 * t197 + 0.24e2 * t562 * t519 * t197 - 0.18e2 * t341 * t206 * t309 + 0.24e2 * t322 * t519 * t325 - 0.36e2 * t571 * t519 * t325 - 0.2e1 * t90 * t512 * t96 + 0.16e2 * t584 * t519 * t539 + 0.2e1 * t205 * t575 + 0.24e2 * t318 * t206 - 0.6e1 * t548 * t309
  t591 = -0.6e1 * t340 * t519 * t197 + 0.6e1 * t523 * t345 + 0.14e2 * t349 * t519 * t325 - t529 * t197 - 0.6e1 * t531 * t532 - 0.8e1 * t536 * t519 * t539 + t512 * t98 / 0.4e1 + 0.3e1 / 0.4e1 * t309 * t209 + 0.3e1 / 0.4e1 * t194 * t354 + t90 * t588 / 0.4e1
  t595 = f.my_piecewise3(t32, t395 + t432 + t466 + t509, -0.8e1 / 0.3e1 * t512 * t101 - 0.8e1 * t309 * t212 - 0.8e1 * t194 * t357 - 0.8e1 / 0.3e1 * t90 * t591)
  t601 = t224 ** 2
  t624 = 0.520e3 / 0.7e1 * t54 * t601 - 0.90e2 * t57 * t601 + 0.952e3 / 0.9e1 * t60 * t601 - 0.608e3 / 0.5e1 * t63 * t601 + 0.1512e4 / 0.11e2 * t66 * t601 - 0.460e3 / 0.3e1 * t69 * t601 + 0.2200e4 / 0.13e2 * t72 * t601 - 0.1296e4 / 0.7e1 * t75 * t601 + 0.3016e4 / 0.15e2 * t78 * t601 - 0.217e3 * t81 * t601 + 0.3960e4 / 0.17e2 * t84 * t601
  t633 = t249 ** 2
  t650 = -0.2240e4 / 0.9e1 * t87 * t601 + 0.5032e4 / 0.19e2 * t240 * t601 - 0.1404e4 / 0.5e1 / t80 / t44 * t601 + 0.45e2 / 0.68e2 * t81 * t633 - 0.7e1 / 0.10e2 * t78 * t633 + 0.26e2 / 0.35e2 * t75 * t633 - 0.72e2 / 0.91e2 * t72 * t633 + 0.11e2 / 0.13e2 * t69 * t633 - 0.10e2 / 0.11e2 * t66 * t633 + 0.54e2 / 0.55e2 * t63 * t633 - 0.16e2 / 0.15e2 * t60 * t633
  t672 = t1 ** 2
  t678 = 0.140e3 / 0.729e3 * t24 * t6 / t2 / t672 * t28
  t679 = f.my_piecewise3(t33, t678, 0)
  t682 = 0.7e1 / 0.6e1 * t57 * t633 - 0.9e1 / 0.7e1 * t54 * t633 + 0.10e2 / 0.7e1 * t51 * t633 - 0.54e2 / 0.95e2 * t240 * t633 + 0.34e2 / 0.57e2 * t87 * t633 - 0.32e2 / 0.51e2 * t84 * t633 - 0.8e1 / 0.5e1 * t48 * t633 + 0.9e1 / 0.5e1 * t45 * t633 - 0.2e1 * t42 * t633 + 0.2e1 * t39 * t633 - 0.10e2 / 0.231e3 * t138 * t679
  t707 = 0.3e1 / 0.91e2 * t142 * t679 - 0.7e1 / 0.270e3 * t146 * t679 - 0.18e2 / 0.1045e4 * t154 * t679 + 0.16e2 / 0.765e3 * t150 * t679 + 0.10e2 / 0.693e3 * t158 * t679 - 0.11e2 / 0.897e3 * t162 * t679 + 0.24e2 / 0.2275e4 * t166 * t679 - 0.26e2 / 0.2835e4 * t170 * t679 + 0.7e1 / 0.870e3 * t174 * t679 - 0.15e2 / 0.2108e4 * t178 * t679 + 0.32e2 / 0.5049e4 * t182 * t679 - 0.34e2 / 0.5985e4 * t186 * t679
  t734 = 0.18e2 / 0.3515e4 * t190 * t679 - 0.2e1 / 0.9e1 * t115 * t679 + 0.2e1 / 0.15e2 * t126 * t679 - 0.3e1 / 0.35e2 * t130 * t679 + 0.8e1 / 0.135e3 * t134 * t679 + 0.40e2 / 0.3e1 * t42 * t601 - 0.28e2 * t45 * t601 + 0.216e3 / 0.5e1 * t48 * t601 - 0.176e3 / 0.3e1 * t51 * t601 + 0.40e2 * t162 * t224 * t249 - 0.528e3 / 0.13e2 * t166 * t224 * t249
  t768 = 0.288e3 / 0.7e1 * t170 * t224 * t249 - 0.208e3 / 0.5e1 * t174 * t224 * t249 + 0.42e2 * t178 * t224 * t249 - 0.720e3 / 0.17e2 * t182 * t224 * t249 + 0.128e3 / 0.3e1 * t186 * t224 * t249 - 0.816e3 / 0.19e2 * t190 * t224 * t249 + 0.216e3 / 0.5e1 * t443 * t224 * t249 + 0.40e2 / 0.21e2 * t51 * t403 * t122 - 0.12e2 / 0.7e1 * t54 * t403 * t122 + 0.14e2 / 0.9e1 * t57 * t403 * t122 + 0.72e2 / 0.55e2 * t63 * t403 * t122
  t803 = -0.64e2 / 0.45e2 * t60 * t403 * t122 - 0.40e2 / 0.33e2 * t66 * t403 * t122 + 0.44e2 / 0.39e2 * t69 * t403 * t122 - 0.96e2 / 0.91e2 * t72 * t403 * t122 + 0.104e3 / 0.105e3 * t75 * t403 * t122 - 0.14e2 / 0.15e2 * t78 * t403 * t122 + 0.15e2 / 0.17e2 * t81 * t403 * t122 - 0.128e3 / 0.153e3 * t84 * t403 * t122 + 0.136e3 / 0.171e3 * t87 * t403 * t122 - 0.72e2 / 0.95e2 * t240 * t403 * t122 + 0.8e1 / 0.3e1 * t39 * t403 * t122
  t840 = -0.8e1 / 0.3e1 * t42 * t403 * t122 + 0.12e2 / 0.5e1 * t45 * t403 * t122 - 0.32e2 / 0.15e2 * t48 * t403 * t122 - 0.16e2 * t126 * t224 * t249 + 0.24e2 * t130 * t224 * t249 - 0.144e3 / 0.5e1 * t134 * t224 * t249 + 0.32e2 * t138 * t224 * t249 - 0.240e3 / 0.7e1 * t142 * t224 * t249 + 0.36e2 * t146 * t224 * t249 - 0.112e3 / 0.3e1 * t150 * t224 * t249 + 0.192e3 / 0.5e1 * t154 * t224 * t249 - 0.432e3 / 0.11e2 * t158 * t224 * t249
  t844 = f.my_piecewise3(t33, 0, t678)
  t858 = t314 ** 2
  t864 = t309 ** 2
  t886 = t324 ** 2
  t887 = 0.1e1 / t886
  t895 = -0.144e3 * t315 * t345 + 0.120e3 * t858 * t340 * t197 + 0.32e2 * t529 * t206 + 0.24e2 * t94 * t864 * t197 + 0.144e3 * t531 * t351 + 0.300e3 * t93 * t536 * t858 * t325 - 0.288e3 * t93 / t535 / t92 * t858 * t539 + 0.2e1 * t205 * t844 * t197 + 0.96e2 * t93 / t535 / t320 * t858 * t887 - 0.6e1 * t864 * t96 - 0.8e1 * t548 * t512
  t931 = 0.16e2 * t350 * t512 * t325 * t194 + 0.96e2 * t584 * t309 * t539 * t314 - 0.18e2 * t341 * t864 * t197 - 0.120e3 * t350 * t858 * t197 - 0.24e2 * t341 * t206 * t512 + 0.144e3 * t562 * t342 * t309 - 0.216e3 * t571 * t351 * t309 - 0.240e3 * t858 * t349 * t325 + 0.12e2 * t350 * t864 * t325 + 0.128e3 * t536 * t858 * t539 - 0.2e1 * t90 * t844 * t96
  t975 = 0.3e1 / 0.2e1 * t309 * t354 + t194 * t588 + t90 * (t895 + t931) / 0.4e1 + t844 * t98 / 0.4e1 + t512 * t209 + 0.24e2 * t322 * t858 * t197 - 0.36e2 * t340 * t314 * t345 + 0.6e1 * t204 * t864 * t197 + 0.8e1 * t523 * t575 + 0.84e2 * t349 * t314 * t578 - 0.8e1 * t322 * t512 * t532 - 0.6e1 * t322 * t864 * t325 - 0.48e2 * t536 * t309 * t539 * t314 - 0.96e2 * t570 * t858 * t325 + 0.120e3 * t583 * t858 * t539 - t94 * t844 * t197 - 0.48e2 / t535 / t203 * t858 * t887
  t979 = f.my_piecewise3(t32, t624 + t650 + t682 + t707 + t734 + t768 + t803 + t840, -0.8e1 / 0.3e1 * t844 * t101 - 0.32e2 / 0.3e1 * t512 * t212 - 0.16e2 * t309 * t357 - 0.32e2 / 0.3e1 * t194 * t591 - 0.8e1 / 0.3e1 * t90 * t975)
  v4rho4_0_ = -0.5e1 / 0.54e2 / t3 / t1 * t6 * t9 * t15 * t19 * t105 + 0.2e1 / 0.9e1 / t3 / r0 * t6 * t9 * t15 * t19 * t216 - 0.1e1 / t3 * t6 * t9 * t15 * t19 * t361 / 0.2e1 - t2 * t6 * t9 * t15 * t19 * t595 - 0.3e1 / 0.16e2 * t116 * t6 * t9 * t15 * t19 * t979

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 - t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = t14 ** (0.1e1 / 0.3e1)
  t17 = t11 ** 2
  t18 = 0.1e1 / t17
  t20 = t10 * t18 - t12
  t23 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t16 * t20)
  t24 = t9 * t23
  t25 = t11 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = 9 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = t3 ** 2
  t31 = t29 * t30
  t32 = t31 * f.p.cam_omega
  t33 = 0.1e1 / t25
  t34 = t1 * t33
  t35 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t36 = f.my_piecewise3(t15, t35, t16)
  t37 = 0.1e1 / t36
  t40 = t32 * t34 * t37 / 0.18e2
  t41 = 0.192e1 <= t40
  t42 = 0.192e1 < t40
  t43 = f.my_piecewise3(t42, t40, 0.192e1)
  t44 = t43 ** 2
  t47 = t44 ** 2
  t48 = 0.1e1 / t47
  t50 = t47 * t44
  t51 = 0.1e1 / t50
  t53 = t47 ** 2
  t54 = 0.1e1 / t53
  t56 = t53 * t44
  t57 = 0.1e1 / t56
  t59 = t53 * t47
  t60 = 0.1e1 / t59
  t62 = t53 * t50
  t63 = 0.1e1 / t62
  t65 = t53 ** 2
  t66 = 0.1e1 / t65
  t69 = 0.1e1 / t65 / t44
  t72 = 0.1e1 / t65 / t47
  t75 = 0.1e1 / t65 / t50
  t78 = 0.1e1 / t65 / t53
  t81 = 0.1e1 / t65 / t56
  t84 = 0.1e1 / t65 / t59
  t87 = 0.1e1 / t65 / t62
  t89 = t65 ** 2
  t90 = 0.1e1 / t89
  t93 = 0.1e1 / t89 / t44
  t96 = 0.1e1 / t89 / t47
  t98 = 0.1e1 / t44 / 0.9e1 - t48 / 0.30e2 + t51 / 0.70e2 - t54 / 0.135e3 + t57 / 0.231e3 - t60 / 0.364e3 + t63 / 0.540e3 - t66 / 0.765e3 + t69 / 0.1045e4 - t72 / 0.1386e4 + t75 / 0.1794e4 - t78 / 0.2275e4 + t81 / 0.2835e4 - t84 / 0.3480e4 + t87 / 0.4216e4 - t90 / 0.5049e4 + t93 / 0.5985e4 - t96 / 0.7030e4
  t99 = f.my_piecewise3(t42, 0.192e1, t40)
  t100 = jnp.atan2(0.1e1, t99)
  t101 = t99 ** 2
  t102 = t101 + 0.3e1
  t103 = 0.1e1 / t101
  t104 = 0.1e1 + t103
  t105 = jnp.log(t104)
  t107 = -t102 * t105 + 0.1e1
  t110 = t100 + t99 * t107 / 0.4e1
  t114 = f.my_piecewise3(t41, t98, 0.1e1 - 0.8e1 / 0.3e1 * t99 * t110)
  t115 = t27 * t114
  t119 = 0.1e1 + t13
  t120 = t119 <= f.p.zeta_threshold
  t121 = t119 ** (0.1e1 / 0.3e1)
  t122 = -t20
  t125 = f.my_piecewise3(t120, 0, 0.4e1 / 0.3e1 * t121 * t122)
  t126 = t9 * t125
  t127 = f.my_piecewise3(t120, t35, t121)
  t128 = 0.1e1 / t127
  t131 = t32 * t34 * t128 / 0.18e2
  t132 = 0.192e1 <= t131
  t133 = 0.192e1 < t131
  t134 = f.my_piecewise3(t133, t131, 0.192e1)
  t135 = t134 ** 2
  t138 = t135 ** 2
  t139 = 0.1e1 / t138
  t141 = t138 * t135
  t142 = 0.1e1 / t141
  t144 = t138 ** 2
  t145 = 0.1e1 / t144
  t147 = t144 * t135
  t148 = 0.1e1 / t147
  t150 = t144 * t138
  t151 = 0.1e1 / t150
  t153 = t144 * t141
  t154 = 0.1e1 / t153
  t156 = t144 ** 2
  t157 = 0.1e1 / t156
  t160 = 0.1e1 / t156 / t135
  t163 = 0.1e1 / t156 / t138
  t166 = 0.1e1 / t156 / t141
  t169 = 0.1e1 / t156 / t144
  t172 = 0.1e1 / t156 / t147
  t175 = 0.1e1 / t156 / t150
  t178 = 0.1e1 / t156 / t153
  t180 = t156 ** 2
  t181 = 0.1e1 / t180
  t184 = 0.1e1 / t180 / t135
  t187 = 0.1e1 / t180 / t138
  t189 = 0.1e1 / t135 / 0.9e1 - t139 / 0.30e2 + t142 / 0.70e2 - t145 / 0.135e3 + t148 / 0.231e3 - t151 / 0.364e3 + t154 / 0.540e3 - t157 / 0.765e3 + t160 / 0.1045e4 - t163 / 0.1386e4 + t166 / 0.1794e4 - t169 / 0.2275e4 + t172 / 0.2835e4 - t175 / 0.3480e4 + t178 / 0.4216e4 - t181 / 0.5049e4 + t184 / 0.5985e4 - t187 / 0.7030e4
  t190 = f.my_piecewise3(t133, 0.192e1, t131)
  t191 = jnp.atan2(0.1e1, t190)
  t192 = t190 ** 2
  t193 = t192 + 0.3e1
  t194 = 0.1e1 / t192
  t195 = 0.1e1 + t194
  t196 = jnp.log(t195)
  t198 = -t193 * t196 + 0.1e1
  t201 = t191 + t190 * t198 / 0.4e1
  t205 = f.my_piecewise3(t132, t189, 0.1e1 - 0.8e1 / 0.3e1 * t190 * t201)
  t206 = t27 * t205
  t210 = t16 ** 2
  t211 = 0.1e1 / t210
  t212 = t20 ** 2
  t215 = t17 * t11
  t216 = 0.1e1 / t215
  t219 = -0.2e1 * t10 * t216 + 0.2e1 * t18
  t223 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t211 * t212 + 0.4e1 / 0.3e1 * t16 * t219)
  t224 = t9 * t223
  t225 = t25 * t114
  t229 = t35 * f.p.zeta_threshold
  t231 = f.my_piecewise3(t15, t229, t16 * t14)
  t232 = t9 * t231
  t235 = t1 / t25 / t11
  t239 = t36 ** 2
  t240 = 0.1e1 / t239
  t241 = t211 * t20
  t243 = f.my_piecewise3(t15, 0, t241 / 0.3e1)
  t244 = t240 * t243
  t248 = -t32 * t235 * t37 / 0.54e2 - t32 * t34 * t244 / 0.18e2
  t249 = f.my_piecewise3(t42, t248, 0)
  t250 = t249 ** 2
  t260 = 0.1e1 / t89 / t50
  t263 = t53 * t43
  t264 = 0.1e1 / t263
  t267 = t1 / t25 / t17
  t275 = 0.1e1 / t239 / t36
  t276 = t243 ** 2
  t277 = t275 * t276
  t282 = 0.1e1 / t210 / t14
  t288 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t282 * t212 + t211 * t219 / 0.3e1)
  t289 = t240 * t288
  t293 = 0.2e1 / 0.81e2 * t32 * t267 * t37 + t32 * t235 * t244 / 0.27e2 + t32 * t34 * t277 / 0.9e1 - t32 * t34 * t289 / 0.18e2
  t294 = f.my_piecewise3(t42, t293, 0)
  t297 = t44 * t43
  t298 = t47 * t297
  t299 = t53 * t298
  t301 = 0.1e1 / t65 / t299
  t304 = t53 * t297
  t305 = 0.1e1 / t304
  t308 = t47 * t43
  t309 = t53 * t308
  t310 = 0.1e1 / t309
  t313 = 0.1e1 / t299
  t317 = 0.1e1 / t89 / t43
  t321 = 0.1e1 / t89 / t297
  t325 = 0.1e1 / t89 / t308
  t329 = 0.1e1 / t65 / t43
  t333 = 0.1e1 / t65 / t297
  t337 = 0.1e1 / t65 / t308
  t341 = 0.1e1 / t65 / t298
  t345 = 0.1e1 / t65 / t263
  t348 = -0.32e2 / 0.153e3 * t93 * t250 + 0.26e2 / 0.105e3 * t84 * t250 + 0.34e2 / 0.171e3 * t96 * t250 + 0.15e2 / 0.68e2 * t90 * t250 - 0.18e2 / 0.95e2 * t260 * t250 + 0.8e1 / 0.135e3 * t264 * t294 - 0.15e2 / 0.2108e4 * t301 * t294 - 0.10e2 / 0.231e3 * t305 * t294 + 0.3e1 / 0.91e2 * t310 * t294 - 0.7e1 / 0.270e3 * t313 * t294 + 0.32e2 / 0.5049e4 * t317 * t294 - 0.34e2 / 0.5985e4 * t321 * t294 + 0.18e2 / 0.3515e4 * t325 * t294 + 0.16e2 / 0.765e3 * t329 * t294 - 0.18e2 / 0.1045e4 * t333 * t294 + 0.10e2 / 0.693e3 * t337 * t294 - 0.11e2 / 0.897e3 * t341 * t294 + 0.24e2 / 0.2275e4 * t345 * t294
  t350 = 0.1e1 / t65 / t304
  t354 = 0.1e1 / t65 / t309
  t383 = 0.1e1 / t297
  t386 = 0.1e1 / t308
  t389 = 0.1e1 / t298
  t392 = -0.26e2 / 0.2835e4 * t350 * t294 + 0.7e1 / 0.870e3 * t354 * t294 + 0.2e1 / 0.3e1 * t48 * t250 - 0.2e1 / 0.3e1 * t51 * t250 - 0.8e1 / 0.15e2 * t57 * t250 + 0.10e2 / 0.21e2 * t60 * t250 + 0.3e1 / 0.5e1 * t54 * t250 - 0.3e1 / 0.7e1 * t63 * t250 + 0.7e1 / 0.18e2 * t66 * t250 + 0.18e2 / 0.55e2 * t72 * t250 + 0.11e2 / 0.39e2 * t78 * t250 - 0.16e2 / 0.45e2 * t69 * t250 - 0.24e2 / 0.91e2 * t81 * t250 - 0.10e2 / 0.33e2 * t75 * t250 - 0.7e1 / 0.30e2 * t87 * t250 - 0.2e1 / 0.9e1 * t383 * t294 + 0.2e1 / 0.15e2 * t386 * t294 - 0.3e1 / 0.35e2 * t389 * t294
  t394 = f.my_piecewise3(t42, 0, t293)
  t397 = f.my_piecewise3(t42, 0, t248)
  t399 = 0.1e1 / t104
  t405 = t101 * t99
  t406 = 0.1e1 / t405
  t407 = t102 * t406
  t408 = t397 * t399
  t411 = -0.2e1 * t99 * t397 * t105 + 0.2e1 * t407 * t408
  t414 = -t103 * t397 * t399 + t397 * t107 / 0.4e1 + t99 * t411 / 0.4e1
  t417 = t397 ** 2
  t421 = t103 * t394
  t423 = t101 ** 2
  t425 = 0.1e1 / t423 / t99
  t427 = t104 ** 2
  t428 = 0.1e1 / t427
  t443 = 0.1e1 / t423
  t444 = t102 * t443
  t448 = t394 * t399
  t452 = 0.1e1 / t423 / t101
  t453 = t102 * t452
  t457 = 0.8e1 * t103 * t417 * t399 - 0.2e1 * t99 * t394 * t105 - 0.6e1 * t444 * t417 * t399 + 0.4e1 * t453 * t417 * t428 - 0.2e1 * t417 * t105 + 0.2e1 * t407 * t448
  t460 = 0.2e1 * t406 * t417 * t399 - t421 * t399 - 0.2e1 * t425 * t417 * t428 + t394 * t107 / 0.4e1 + t397 * t411 / 0.2e1 + t99 * t457 / 0.4e1
  t464 = f.my_piecewise3(t41, t348 + t392, -0.8e1 / 0.3e1 * t394 * t110 - 0.16e2 / 0.3e1 * t397 * t414 - 0.8e1 / 0.3e1 * t99 * t460)
  t465 = t25 * t464
  t469 = t121 ** 2
  t470 = 0.1e1 / t469
  t471 = t122 ** 2
  t474 = -t219
  t478 = f.my_piecewise3(t120, 0, 0.4e1 / 0.9e1 * t470 * t471 + 0.4e1 / 0.3e1 * t121 * t474)
  t479 = t9 * t478
  t480 = t25 * t205
  t520 = -0.2e1 / 0.9e1 * t383 * t249 + 0.2e1 / 0.15e2 * t386 * t249 - 0.3e1 / 0.35e2 * t389 * t249 + 0.8e1 / 0.135e3 * t264 * t249 - 0.10e2 / 0.231e3 * t305 * t249 + 0.3e1 / 0.91e2 * t310 * t249 - 0.7e1 / 0.270e3 * t313 * t249 + 0.16e2 / 0.765e3 * t329 * t249 - 0.18e2 / 0.1045e4 * t333 * t249 + 0.10e2 / 0.693e3 * t337 * t249 - 0.11e2 / 0.897e3 * t341 * t249 + 0.24e2 / 0.2275e4 * t345 * t249 - 0.26e2 / 0.2835e4 * t350 * t249 + 0.7e1 / 0.870e3 * t354 * t249 - 0.15e2 / 0.2108e4 * t301 * t249 + 0.32e2 / 0.5049e4 * t317 * t249 - 0.34e2 / 0.5985e4 * t321 * t249 + 0.18e2 / 0.3515e4 * t325 * t249
  t525 = f.my_piecewise3(t41, t520, -0.8e1 / 0.3e1 * t397 * t110 - 0.8e1 / 0.3e1 * t99 * t414)
  t526 = t27 * t525
  t531 = f.my_piecewise3(t120, t229, t121 * t119)
  t532 = t9 * t531
  t536 = t127 ** 2
  t537 = 0.1e1 / t536
  t538 = t470 * t122
  t540 = f.my_piecewise3(t120, 0, t538 / 0.3e1)
  t541 = t537 * t540
  t545 = -t32 * t235 * t128 / 0.54e2 - t32 * t34 * t541 / 0.18e2
  t546 = f.my_piecewise3(t133, t545, 0)
  t547 = t546 ** 2
  t556 = t138 * t134
  t557 = t144 * t556
  t558 = 0.1e1 / t557
  t566 = 0.1e1 / t536 / t127
  t567 = t540 ** 2
  t568 = t566 * t567
  t573 = 0.1e1 / t469 / t119
  t579 = f.my_piecewise3(t120, 0, -0.2e1 / 0.9e1 * t573 * t471 + t470 * t474 / 0.3e1)
  t580 = t537 * t579
  t584 = 0.2e1 / 0.81e2 * t32 * t267 * t128 + t32 * t235 * t541 / 0.27e2 + t32 * t34 * t568 / 0.9e1 - t32 * t34 * t580 / 0.18e2
  t585 = f.my_piecewise3(t133, t584, 0)
  t595 = 0.1e1 / t180 / t134
  t598 = t135 * t134
  t600 = 0.1e1 / t180 / t598
  t604 = 0.1e1 / t180 / t556
  t608 = 0.1e1 / t156 / t598
  t611 = t144 * t134
  t612 = 0.1e1 / t611
  t624 = 0.1e1 / t156 / t556
  t627 = 0.10e2 / 0.21e2 * t151 * t547 - 0.3e1 / 0.7e1 * t154 * t547 + 0.7e1 / 0.18e2 * t157 * t547 + 0.34e2 / 0.171e3 * t187 * t547 + 0.3e1 / 0.91e2 * t558 * t585 - 0.2e1 / 0.3e1 * t142 * t547 + 0.3e1 / 0.5e1 * t145 * t547 - 0.8e1 / 0.15e2 * t148 * t547 + 0.32e2 / 0.5049e4 * t595 * t585 - 0.34e2 / 0.5985e4 * t600 * t585 + 0.18e2 / 0.3515e4 * t604 * t585 - 0.18e2 / 0.1045e4 * t608 * t585 + 0.8e1 / 0.135e3 * t612 * t585 - 0.16e2 / 0.45e2 * t160 * t547 + 0.18e2 / 0.55e2 * t163 * t547 - 0.10e2 / 0.33e2 * t166 * t547 + 0.11e2 / 0.39e2 * t169 * t547 + 0.10e2 / 0.693e3 * t624 * t585
  t628 = 0.1e1 / t598
  t632 = 0.1e1 / t180 / t141
  t635 = t138 * t598
  t637 = 0.1e1 / t156 / t635
  t641 = 0.1e1 / t156 / t611
  t644 = t144 * t598
  t646 = 0.1e1 / t156 / t644
  t650 = 0.1e1 / t156 / t557
  t653 = 0.1e1 / t556
  t656 = t144 * t635
  t657 = 0.1e1 / t656
  t661 = 0.1e1 / t156 / t134
  t675 = 0.1e1 / t156 / t656
  t678 = 0.1e1 / t644
  t681 = 0.1e1 / t635
  t686 = -0.2e1 / 0.9e1 * t628 * t585 - 0.18e2 / 0.95e2 * t632 * t547 - 0.11e2 / 0.897e3 * t637 * t585 + 0.24e2 / 0.2275e4 * t641 * t585 - 0.26e2 / 0.2835e4 * t646 * t585 + 0.7e1 / 0.870e3 * t650 * t585 + 0.2e1 / 0.15e2 * t653 * t585 - 0.7e1 / 0.270e3 * t657 * t585 + 0.16e2 / 0.765e3 * t661 * t585 - 0.24e2 / 0.91e2 * t172 * t547 + 0.26e2 / 0.105e3 * t175 * t547 - 0.7e1 / 0.30e2 * t178 * t547 + 0.15e2 / 0.68e2 * t181 * t547 - 0.32e2 / 0.153e3 * t184 * t547 - 0.15e2 / 0.2108e4 * t675 * t585 - 0.10e2 / 0.231e3 * t678 * t585 - 0.3e1 / 0.35e2 * t681 * t585 + 0.2e1 / 0.3e1 * t139 * t547
  t688 = f.my_piecewise3(t133, 0, t584)
  t691 = f.my_piecewise3(t133, 0, t545)
  t693 = 0.1e1 / t195
  t699 = t192 * t190
  t700 = 0.1e1 / t699
  t701 = t193 * t700
  t702 = t691 * t693
  t705 = -0.2e1 * t190 * t691 * t196 + 0.2e1 * t701 * t702
  t708 = -t194 * t691 * t693 + t691 * t198 / 0.4e1 + t190 * t705 / 0.4e1
  t711 = t691 ** 2
  t715 = t194 * t688
  t717 = t192 ** 2
  t719 = 0.1e1 / t717 / t190
  t721 = t195 ** 2
  t722 = 0.1e1 / t721
  t737 = 0.1e1 / t717
  t738 = t193 * t737
  t742 = t688 * t693
  t746 = 0.1e1 / t717 / t192
  t747 = t193 * t746
  t751 = -0.2e1 * t190 * t688 * t196 + 0.8e1 * t194 * t711 * t693 - 0.6e1 * t738 * t711 * t693 + 0.4e1 * t747 * t711 * t722 - 0.2e1 * t711 * t196 + 0.2e1 * t701 * t742
  t754 = 0.2e1 * t700 * t711 * t693 - t715 * t693 - 0.2e1 * t719 * t711 * t722 + t688 * t198 / 0.4e1 + t691 * t705 / 0.2e1 + t190 * t751 / 0.4e1
  t758 = f.my_piecewise3(t132, t627 + t686, -0.8e1 / 0.3e1 * t688 * t201 - 0.16e2 / 0.3e1 * t691 * t708 - 0.8e1 / 0.3e1 * t190 * t754)
  t759 = t25 * t758
  t799 = -0.2e1 / 0.9e1 * t628 * t546 + 0.2e1 / 0.15e2 * t653 * t546 - 0.3e1 / 0.35e2 * t681 * t546 + 0.8e1 / 0.135e3 * t612 * t546 - 0.10e2 / 0.231e3 * t678 * t546 + 0.3e1 / 0.91e2 * t558 * t546 - 0.7e1 / 0.270e3 * t657 * t546 + 0.16e2 / 0.765e3 * t661 * t546 - 0.18e2 / 0.1045e4 * t608 * t546 + 0.10e2 / 0.693e3 * t624 * t546 - 0.11e2 / 0.897e3 * t637 * t546 + 0.24e2 / 0.2275e4 * t641 * t546 - 0.26e2 / 0.2835e4 * t646 * t546 + 0.7e1 / 0.870e3 * t650 * t546 - 0.15e2 / 0.2108e4 * t675 * t546 + 0.32e2 / 0.5049e4 * t595 * t546 - 0.34e2 / 0.5985e4 * t600 * t546 + 0.18e2 / 0.3515e4 * t604 * t546
  t804 = f.my_piecewise3(t132, t799, -0.8e1 / 0.3e1 * t190 * t708 - 0.8e1 / 0.3e1 * t691 * t201)
  t805 = t27 * t804
  t810 = 0.1e1 / t26 / t11
  t811 = t810 * t114
  t815 = t25 * t525
  t835 = t1 / t25 / t215
  t848 = t239 ** 2
  t856 = t31 * f.p.cam_omega * t1
  t862 = t14 ** 2
  t865 = t212 * t20
  t871 = t17 ** 2
  t875 = -0.6e1 * t216 + 0.6e1 * t10 / t871
  t879 = f.my_piecewise3(t15, 0, 0.10e2 / 0.27e2 / t210 / t862 * t865 - 0.2e1 / 0.3e1 * t282 * t20 * t219 + t211 * t875 / 0.3e1)
  t884 = -0.14e2 / 0.243e3 * t32 * t835 * t37 - 0.2e1 / 0.27e2 * t32 * t267 * t244 - t32 * t235 * t277 / 0.9e1 + t32 * t235 * t289 / 0.18e2 - t32 * t34 / t848 * t276 * t243 / 0.3e1 + t856 * t33 * t275 * t243 * t288 / 0.3e1 - t32 * t34 * t240 * t879 / 0.18e2
  t885 = f.my_piecewise3(t42, t884, 0)
  t888 = t250 * t249
  t915 = -0.10e2 / 0.231e3 * t305 * t885 + 0.16e2 / 0.3e1 * t305 * t888 + 0.8e1 / 0.135e3 * t264 * t885 + 0.7e1 / 0.870e3 * t354 * t885 - 0.136e3 / 0.19e2 * t325 * t888 + 0.2e1 / 0.15e2 * t386 * t885 - 0.120e3 / 0.17e2 * t317 * t888 + 0.48e2 / 0.7e1 * t350 * t888 - 0.88e2 / 0.13e2 * t345 * t888 + 0.36e2 / 0.5e1 / t89 / t298 * t888 - 0.3e1 / 0.35e2 * t389 * t885 - 0.104e3 / 0.15e2 * t354 * t888 + 0.18e2 / 0.3515e4 * t325 * t885
  t944 = 0.4e1 * t389 * t888 + 0.16e2 / 0.765e3 * t329 * t885 - 0.72e2 / 0.11e2 * t337 * t888 - 0.8e1 / 0.3e1 * t386 * t888 + 0.32e2 / 0.5e1 * t333 * t888 + 0.10e2 / 0.693e3 * t337 * t885 + 0.64e2 / 0.9e1 * t321 * t888 + 0.7e1 * t301 * t888 - 0.24e2 / 0.5e1 * t264 * t888 + 0.6e1 * t313 * t888 - 0.56e2 / 0.9e1 * t329 * t888 + 0.20e2 / 0.3e1 * t341 * t888 - 0.2e1 / 0.9e1 * t383 * t885 - 0.26e2 / 0.2835e4 * t350 * t885
  t976 = 0.3e1 / 0.91e2 * t310 * t885 - 0.7e1 / 0.270e3 * t313 * t885 - 0.18e2 / 0.1045e4 * t333 * t885 - 0.34e2 / 0.5985e4 * t321 * t885 - 0.11e2 / 0.897e3 * t341 * t885 + 0.24e2 / 0.2275e4 * t345 * t885 - 0.40e2 / 0.7e1 * t310 * t888 - 0.15e2 / 0.2108e4 * t301 * t885 + 0.32e2 / 0.5049e4 * t317 * t885 + 0.26e2 / 0.35e2 * t84 * t294 * t249 - 0.54e2 / 0.95e2 * t260 * t294 * t249 + 0.11e2 / 0.13e2 * t78 * t294 * t249 - 0.2e1 * t51 * t294 * t249
  t1019 = 0.10e2 / 0.7e1 * t60 * t294 * t249 - 0.9e1 / 0.7e1 * t63 * t249 * t294 - 0.10e2 / 0.11e2 * t75 * t249 * t294 - 0.16e2 / 0.15e2 * t69 * t294 * t249 - 0.72e2 / 0.91e2 * t81 * t294 * t249 + 0.9e1 / 0.5e1 * t54 * t294 * t249 - 0.32e2 / 0.51e2 * t93 * t294 * t249 + 0.34e2 / 0.57e2 * t96 * t249 * t294 - 0.8e1 / 0.5e1 * t57 * t249 * t294 + 0.45e2 / 0.68e2 * t90 * t249 * t294 + 0.2e1 * t48 * t294 * t249 - 0.7e1 / 0.10e2 * t87 * t294 * t249 + 0.7e1 / 0.6e1 * t66 * t249 * t294 + 0.54e2 / 0.55e2 * t72 * t294 * t249
  t1022 = f.my_piecewise3(t42, 0, t884)
  t1029 = t417 * t397
  t1045 = t423 ** 2
  t1049 = 0.1e1 / t427 / t104
  t1098 = -0.6e1 * t397 * t105 * t394 - 0.24e2 * t1029 * t406 * t399 - 0.2e1 * t99 * t1022 * t105 + 0.24e2 * t421 * t408 + 0.24e2 * t425 * t1029 * t428 + 0.24e2 * t102 * t425 * t1029 * t399 - 0.18e2 * t444 * t408 * t394 - 0.36e2 * t102 / t423 / t405 * t1029 * t428 + 0.2e1 * t407 * t1022 * t399 + 0.12e2 * t453 * t394 * t428 * t397 + 0.16e2 * t102 / t1045 / t99 * t1029 * t1049
  t1105 = f.my_piecewise3(t41, t915 + t944 + t976 + t1019, -0.8e1 / 0.3e1 * t1022 * t110 - 0.8e1 * t394 * t414 - 0.8e1 * t397 * t460 - 0.8e1 / 0.3e1 * t99 * (-0.6e1 * t443 * t1029 * t399 + 0.6e1 * t406 * t397 * t448 + 0.14e2 * t452 * t1029 * t428 - t103 * t1022 * t399 - 0.6e1 * t425 * t394 * t428 * t397 - 0.8e1 / t1045 * t1029 * t1049 + t1022 * t107 / 0.4e1 + 0.3e1 / 0.4e1 * t394 * t411 + 0.3e1 / 0.4e1 * t397 * t457 + t99 * t1098 / 0.4e1))
  t1117 = f.my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t282 * t865 + 0.4e1 / 0.3e1 * t241 * t219 + 0.4e1 / 0.3e1 * t16 * t875)
  t1133 = t547 * t546
  t1152 = t536 ** 2
  t1164 = t119 ** 2
  t1167 = t471 * t122
  t1173 = -t875
  t1177 = f.my_piecewise3(t120, 0, 0.10e2 / 0.27e2 / t469 / t1164 * t1167 - 0.2e1 / 0.3e1 * t573 * t122 * t474 + t470 * t1173 / 0.3e1)
  t1182 = -0.14e2 / 0.243e3 * t32 * t835 * t128 - 0.2e1 / 0.27e2 * t32 * t267 * t541 - t32 * t235 * t568 / 0.9e1 + t32 * t235 * t580 / 0.18e2 - t32 * t34 / t1152 * t567 * t540 / 0.3e1 + t856 * t33 * t566 * t540 * t579 / 0.3e1 - t32 * t34 * t537 * t1177 / 0.18e2
  t1183 = f.my_piecewise3(t133, t1182, 0)
  t1204 = 0.64e2 / 0.9e1 * t600 * t1133 - 0.24e2 / 0.5e1 * t612 * t1133 - 0.136e3 / 0.19e2 * t604 * t1133 - 0.7e1 / 0.270e3 * t657 * t1183 - 0.72e2 / 0.11e2 * t624 * t1133 + 0.8e1 / 0.135e3 * t612 * t1183 + 0.10e2 / 0.693e3 * t624 * t1183 + 0.3e1 / 0.91e2 * t558 * t1183 - 0.10e2 / 0.231e3 * t678 * t1183 - 0.8e1 / 0.3e1 * t653 * t1133 + 0.16e2 / 0.765e3 * t661 * t1183 - 0.18e2 / 0.1045e4 * t608 * t1183 + 0.24e2 / 0.2275e4 * t641 * t1183
  t1235 = -0.26e2 / 0.2835e4 * t646 * t1183 - 0.88e2 / 0.13e2 * t641 * t1133 + 0.16e2 / 0.3e1 * t678 * t1133 - 0.120e3 / 0.17e2 * t595 * t1133 + 0.36e2 / 0.5e1 / t180 / t635 * t1133 + 0.18e2 / 0.3515e4 * t604 * t1183 - 0.15e2 / 0.2108e4 * t675 * t1183 + 0.2e1 / 0.15e2 * t653 * t1183 - 0.3e1 / 0.35e2 * t681 * t1183 - 0.11e2 / 0.897e3 * t637 * t1183 + 0.32e2 / 0.5049e4 * t595 * t1183 - 0.40e2 / 0.7e1 * t558 * t1133 - 0.34e2 / 0.5985e4 * t600 * t1183 + 0.48e2 / 0.7e1 * t646 * t1133
  t1267 = 0.7e1 * t675 * t1133 + 0.20e2 / 0.3e1 * t637 * t1133 - 0.56e2 / 0.9e1 * t661 * t1133 + 0.32e2 / 0.5e1 * t608 * t1133 - 0.104e3 / 0.15e2 * t650 * t1133 + 0.4e1 * t681 * t1133 + 0.6e1 * t657 * t1133 - 0.2e1 / 0.9e1 * t628 * t1183 + 0.7e1 / 0.870e3 * t650 * t1183 + 0.54e2 / 0.55e2 * t163 * t546 * t585 - 0.7e1 / 0.10e2 * t178 * t546 * t585 - 0.32e2 / 0.51e2 * t184 * t585 * t546 + 0.10e2 / 0.7e1 * t151 * t546 * t585
  t1310 = -0.54e2 / 0.95e2 * t632 * t585 * t546 + 0.11e2 / 0.13e2 * t169 * t546 * t585 + 0.9e1 / 0.5e1 * t145 * t585 * t546 + 0.45e2 / 0.68e2 * t181 * t546 * t585 - 0.8e1 / 0.5e1 * t148 * t546 * t585 - 0.10e2 / 0.11e2 * t166 * t585 * t546 - 0.72e2 / 0.91e2 * t172 * t546 * t585 - 0.9e1 / 0.7e1 * t154 * t585 * t546 + 0.26e2 / 0.35e2 * t175 * t585 * t546 + 0.2e1 * t139 * t585 * t546 - 0.16e2 / 0.15e2 * t160 * t585 * t546 + 0.7e1 / 0.6e1 * t157 * t546 * t585 - 0.2e1 * t142 * t546 * t585 + 0.34e2 / 0.57e2 * t187 * t585 * t546
  t1313 = f.my_piecewise3(t133, 0, t1182)
  t1320 = t711 * t691
  t1336 = t717 ** 2
  t1340 = 0.1e1 / t721 / t195
  t1389 = -0.6e1 * t691 * t196 * t688 - 0.24e2 * t1320 * t700 * t693 - 0.2e1 * t190 * t1313 * t196 + 0.24e2 * t715 * t702 + 0.24e2 * t719 * t1320 * t722 + 0.24e2 * t193 * t719 * t1320 * t693 - 0.18e2 * t738 * t702 * t688 - 0.36e2 * t193 / t717 / t699 * t1320 * t722 + 0.2e1 * t701 * t1313 * t693 + 0.12e2 * t747 * t688 * t722 * t691 + 0.16e2 * t193 / t1336 / t190 * t1320 * t1340
  t1396 = f.my_piecewise3(t132, t1204 + t1235 + t1267 + t1310, -0.8e1 / 0.3e1 * t1313 * t201 - 0.8e1 * t688 * t708 - 0.8e1 * t691 * t754 - 0.8e1 / 0.3e1 * t190 * (-0.6e1 * t737 * t1320 * t693 + 0.6e1 * t700 * t691 * t742 + 0.14e2 * t746 * t1320 * t722 - t194 * t1313 * t693 - 0.6e1 * t719 * t688 * t722 * t691 - 0.8e1 / t1336 * t1320 * t1340 + t1313 * t198 / 0.4e1 + 0.3e1 / 0.4e1 * t688 * t705 + 0.3e1 / 0.4e1 * t691 * t751 + t190 * t1389 / 0.4e1))
  t1408 = f.my_piecewise3(t120, 0, -0.8e1 / 0.27e2 * t573 * t1167 + 0.4e1 / 0.3e1 * t538 * t474 + 0.4e1 / 0.3e1 * t121 * t1173)
  t1413 = t25 * t804
  t1427 = 0.1e1 / t26 / t17
  t1435 = t810 * t205
  t1443 = -0.9e1 / 0.32e2 * t7 * t224 * t815 - 0.3e1 / 0.16e2 * t7 * t24 * t526 - 0.9e1 / 0.32e2 * t7 * t24 * t465 + t7 * t232 * t810 * t525 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t232 * t27 * t464 - 0.3e1 / 0.32e2 * t7 * t232 * t25 * t1105 - 0.3e1 / 0.32e2 * t7 * t9 * t1117 * t225 - 0.9e1 / 0.32e2 * t7 * t126 * t759 + t7 * t532 * t810 * t804 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t532 * t27 * t758 - 0.3e1 / 0.32e2 * t7 * t532 * t25 * t1396 - 0.3e1 / 0.32e2 * t7 * t9 * t1408 * t480 - 0.9e1 / 0.32e2 * t7 * t479 * t1413 - 0.3e1 / 0.16e2 * t7 * t126 * t805 - 0.3e1 / 0.32e2 * t7 * t224 * t115 + t7 * t24 * t811 / 0.16e2 - 0.5e1 / 0.144e3 * t7 * t232 * t1427 * t114 - 0.3e1 / 0.32e2 * t7 * t479 * t206 + t7 * t126 * t1435 / 0.16e2 - 0.5e1 / 0.144e3 * t7 * t532 * t1427 * t205
  d111 = -0.3e1 / 0.16e2 * t7 * t24 * t115 - 0.3e1 / 0.16e2 * t7 * t126 * t206 - 0.9e1 / 0.32e2 * t7 * t224 * t225 - 0.9e1 / 0.32e2 * t7 * t232 * t465 - 0.9e1 / 0.32e2 * t7 * t479 * t480 - 0.3e1 / 0.16e2 * t7 * t232 * t526 - 0.9e1 / 0.32e2 * t7 * t532 * t759 - 0.3e1 / 0.16e2 * t7 * t532 * t805 + t7 * t232 * t811 / 0.16e2 + t11 * t1443 - 0.9e1 / 0.16e2 * t7 * t126 * t1413 + t7 * t532 * t1435 / 0.16e2 - 0.9e1 / 0.16e2 * t7 * t24 * t815

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 - t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t16 * f.p.zeta_threshold
  t18 = t14 ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t15, t17, t18 * t14)
  t21 = t9 * t20
  t22 = t11 ** (0.1e1 / 0.3e1)
  t23 = 9 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t3 ** 2
  t26 = t24 * t25
  t27 = t26 * f.p.cam_omega
  t28 = 0.1e1 / t22
  t29 = t1 * t28
  t30 = f.my_piecewise3(t15, t16, t18)
  t31 = 0.1e1 / t30
  t34 = t27 * t29 * t31 / 0.18e2
  t35 = 0.192e1 <= t34
  t36 = 0.192e1 < t34
  t37 = f.my_piecewise3(t36, t34, 0.192e1)
  t38 = t37 ** 2
  t39 = t38 * t37
  t40 = t38 ** 2
  t41 = t40 * t39
  t42 = t40 ** 2
  t43 = t42 ** 2
  t45 = 0.1e1 / t43 / t41
  t46 = t11 ** 2
  t47 = t46 * t11
  t50 = t1 / t22 / t47
  t56 = t1 / t22 / t46
  t57 = t30 ** 2
  t58 = 0.1e1 / t57
  t59 = t18 ** 2
  t60 = 0.1e1 / t59
  t61 = 0.1e1 / t46
  t63 = t10 * t61 - t12
  t64 = t60 * t63
  t66 = f.my_piecewise3(t15, 0, t64 / 0.3e1)
  t67 = t58 * t66
  t72 = 0.1e1 / t22 / t11
  t73 = t1 * t72
  t75 = 0.1e1 / t57 / t30
  t76 = t66 ** 2
  t77 = t75 * t76
  t82 = 0.1e1 / t59 / t14
  t83 = t63 ** 2
  t84 = t82 * t83
  t86 = 0.1e1 / t47
  t89 = -0.2e1 * t10 * t86 + 0.2e1 * t61
  t93 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t84 + t60 * t89 / 0.3e1)
  t94 = t58 * t93
  t98 = t57 ** 2
  t99 = 0.1e1 / t98
  t101 = t99 * t76 * t66
  t106 = t26 * f.p.cam_omega * t1
  t107 = t28 * t75
  t108 = t66 * t93
  t112 = t14 ** 2
  t114 = 0.1e1 / t59 / t112
  t115 = t83 * t63
  t118 = t82 * t63
  t121 = t46 ** 2
  t122 = 0.1e1 / t121
  t125 = 0.6e1 * t10 * t122 - 0.6e1 * t86
  t129 = f.my_piecewise3(t15, 0, 0.10e2 / 0.27e2 * t114 * t115 - 0.2e1 / 0.3e1 * t118 * t89 + t60 * t125 / 0.3e1)
  t130 = t58 * t129
  t134 = -0.14e2 / 0.243e3 * t27 * t50 * t31 - 0.2e1 / 0.27e2 * t27 * t56 * t67 - t27 * t73 * t77 / 0.9e1 + t27 * t73 * t94 / 0.18e2 - t27 * t29 * t101 / 0.3e1 + t106 * t107 * t108 / 0.3e1 - t27 * t29 * t130 / 0.18e2
  t135 = f.my_piecewise3(t36, t134, 0)
  t138 = t40 * t37
  t139 = t42 * t138
  t140 = 0.1e1 / t139
  t143 = t42 * t39
  t144 = 0.1e1 / t143
  t147 = t42 * t41
  t148 = 0.1e1 / t147
  t152 = 0.1e1 / t43 / t147
  t155 = t42 * t37
  t157 = 0.1e1 / t43 / t155
  t160 = 0.1e1 / t41
  t163 = t43 ** 2
  t165 = 0.1e1 / t163 / t37
  t168 = 0.1e1 / t138
  t177 = -t27 * t73 * t31 / 0.54e2 - t27 * t29 * t67 / 0.18e2
  t178 = f.my_piecewise3(t36, t177, 0)
  t179 = t178 ** 2
  t180 = t179 * t178
  t186 = 0.1e1 / t163 / t138
  t190 = 0.1e1 / t163 / t41
  t193 = -0.11e2 / 0.897e3 * t45 * t135 + 0.3e1 / 0.91e2 * t140 * t135 - 0.10e2 / 0.231e3 * t144 * t135 - 0.7e1 / 0.270e3 * t148 * t135 - 0.15e2 / 0.2108e4 * t152 * t135 + 0.24e2 / 0.2275e4 * t157 * t135 - 0.3e1 / 0.35e2 * t160 * t135 + 0.32e2 / 0.5049e4 * t165 * t135 + 0.2e1 / 0.15e2 * t168 * t135 - 0.88e2 / 0.13e2 * t157 * t180 + 0.4e1 * t160 * t180 - 0.136e3 / 0.19e2 * t186 * t180 + 0.36e2 / 0.5e1 * t190 * t180
  t195 = 0.1e1 / t163 / t39
  t199 = 0.1e1 / t43 / t143
  t203 = 0.1e1 / t43 / t138
  t207 = 0.1e1 / t43 / t139
  t210 = 0.1e1 / t155
  t220 = 0.1e1 / t43 / t37
  t230 = 0.1e1 / t43 / t40
  t243 = 0.2e1 / 0.81e2 * t27 * t56 * t31 + t27 * t73 * t67 / 0.27e2 + t27 * t29 * t77 / 0.9e1 - t27 * t29 * t94 / 0.18e2
  t244 = f.my_piecewise3(t36, t243, 0)
  t248 = t40 * t38
  t250 = 0.1e1 / t163 / t248
  t254 = 0.64e2 / 0.9e1 * t195 * t180 + 0.48e2 / 0.7e1 * t199 * t180 - 0.72e2 / 0.11e2 * t203 * t180 - 0.104e3 / 0.15e2 * t207 * t180 - 0.24e2 / 0.5e1 * t210 * t180 + 0.6e1 * t148 * t180 - 0.8e1 / 0.3e1 * t168 * t180 - 0.120e3 / 0.17e2 * t165 * t180 - 0.56e2 / 0.9e1 * t220 * t180 + 0.16e2 / 0.3e1 * t144 * t180 + 0.20e2 / 0.3e1 * t45 * t180 - 0.40e2 / 0.7e1 * t140 * t180 + 0.54e2 / 0.55e2 * t230 * t244 * t178 - 0.54e2 / 0.95e2 * t250 * t244 * t178
  t257 = 0.1e1 / t43 / t42
  t258 = t257 * t178
  t262 = 0.1e1 / t163 / t40
  t266 = t42 * t38
  t268 = 0.1e1 / t43 / t266
  t269 = t268 * t178
  t273 = 0.1e1 / t163 / t38
  t277 = 0.1e1 / t163
  t281 = 0.1e1 / t42
  t285 = 0.1e1 / t248
  t290 = 0.1e1 / t43 / t248
  t294 = 0.1e1 / t266
  t295 = t294 * t178
  t298 = t42 * t248
  t299 = 0.1e1 / t298
  t303 = 0.1e1 / t43
  t304 = t303 * t178
  t307 = 0.1e1 / t40
  t311 = t42 * t40
  t312 = 0.1e1 / t311
  t313 = t312 * t178
  t316 = 0.11e2 / 0.13e2 * t258 * t244 + 0.34e2 / 0.57e2 * t262 * t178 * t244 - 0.72e2 / 0.91e2 * t269 * t244 - 0.32e2 / 0.51e2 * t273 * t244 * t178 + 0.45e2 / 0.68e2 * t277 * t178 * t244 + 0.9e1 / 0.5e1 * t281 * t244 * t178 - 0.2e1 * t285 * t244 * t178 - 0.10e2 / 0.11e2 * t290 * t178 * t244 - 0.8e1 / 0.5e1 * t295 * t244 - 0.9e1 / 0.7e1 * t299 * t244 * t178 + 0.7e1 / 0.6e1 * t304 * t244 + 0.2e1 * t307 * t244 * t178 + 0.10e2 / 0.7e1 * t313 * t244
  t318 = 0.1e1 / t43 / t311
  t323 = 0.1e1 / t43 / t38
  t324 = t323 * t178
  t328 = 0.1e1 / t43 / t298
  t335 = 0.1e1 / t43 / t39
  t340 = 0.1e1 / t39
  t357 = 0.26e2 / 0.35e2 * t318 * t244 * t178 - 0.16e2 / 0.15e2 * t324 * t244 - 0.7e1 / 0.10e2 * t328 * t178 * t244 + 0.7e1 * t152 * t180 + 0.32e2 / 0.5e1 * t335 * t180 - 0.34e2 / 0.5985e4 * t195 * t135 - 0.2e1 / 0.9e1 * t340 * t135 + 0.10e2 / 0.693e3 * t203 * t135 - 0.26e2 / 0.2835e4 * t199 * t135 + 0.8e1 / 0.135e3 * t210 * t135 - 0.18e2 / 0.1045e4 * t335 * t135 + 0.16e2 / 0.765e3 * t220 * t135 + 0.18e2 / 0.3515e4 * t186 * t135 + 0.7e1 / 0.870e3 * t207 * t135
  t360 = f.my_piecewise3(t36, 0, t134)
  t361 = f.my_piecewise3(t36, 0.192e1, t34)
  t362 = jnp.atan2(0.1e1, t361)
  t363 = t361 ** 2
  t364 = t363 + 0.3e1
  t365 = 0.1e1 / t363
  t366 = 0.1e1 + t365
  t367 = jnp.log(t366)
  t369 = -t364 * t367 + 0.1e1
  t372 = t362 + t361 * t369 / 0.4e1
  t375 = f.my_piecewise3(t36, 0, t243)
  t376 = f.my_piecewise3(t36, 0, t177)
  t378 = 0.1e1 / t366
  t384 = t363 * t361
  t385 = 0.1e1 / t384
  t386 = t364 * t385
  t387 = t376 * t378
  t390 = -0.2e1 * t361 * t376 * t367 + 0.2e1 * t386 * t387
  t393 = -t365 * t376 * t378 + t376 * t369 / 0.4e1 + t361 * t390 / 0.4e1
  t396 = t376 ** 2
  t397 = t385 * t396
  t400 = t365 * t375
  t402 = t363 ** 2
  t404 = 0.1e1 / t402 / t361
  t406 = t366 ** 2
  t407 = 0.1e1 / t406
  t422 = 0.1e1 / t402
  t423 = t364 * t422
  t424 = t396 * t378
  t427 = t375 * t378
  t431 = 0.1e1 / t402 / t363
  t432 = t364 * t431
  t433 = t396 * t407
  t436 = -0.2e1 * t361 * t375 * t367 + 0.8e1 * t365 * t396 * t378 - 0.2e1 * t396 * t367 + 0.2e1 * t386 * t427 - 0.6e1 * t423 * t424 + 0.4e1 * t432 * t433
  t439 = 0.2e1 * t397 * t378 - t400 * t378 - 0.2e1 * t404 * t396 * t407 + t375 * t369 / 0.4e1 + t376 * t390 / 0.2e1 + t361 * t436 / 0.4e1
  t442 = t396 * t376
  t446 = t385 * t376
  t452 = t365 * t360
  t454 = t404 * t375
  t455 = t407 * t376
  t458 = t402 ** 2
  t459 = 0.1e1 / t458
  t462 = 0.1e1 / t406 / t366
  t471 = t376 * t367
  t485 = t364 * t404
  t493 = 0.1e1 / t402 / t384
  t494 = t364 * t493
  t498 = t360 * t378
  t501 = t375 * t407
  t506 = 0.1e1 / t458 / t361
  t507 = t364 * t506
  t511 = -0.2e1 * t361 * t360 * t367 - 0.18e2 * t423 * t387 * t375 + 0.12e2 * t432 * t501 * t376 - 0.24e2 * t442 * t385 * t378 + 0.24e2 * t485 * t442 * t378 + 0.24e2 * t404 * t442 * t407 - 0.36e2 * t494 * t442 * t407 + 0.16e2 * t507 * t442 * t462 - 0.6e1 * t471 * t375 + 0.2e1 * t386 * t498 + 0.24e2 * t400 * t387
  t514 = -0.6e1 * t422 * t442 * t378 + 0.6e1 * t446 * t427 + 0.14e2 * t431 * t442 * t407 - t452 * t378 - 0.6e1 * t454 * t455 - 0.8e1 * t459 * t442 * t462 + t360 * t369 / 0.4e1 + 0.3e1 / 0.4e1 * t375 * t390 + 0.3e1 / 0.4e1 * t376 * t436 + t361 * t511 / 0.4e1
  t518 = f.my_piecewise3(t35, t193 + t254 + t316 + t357, -0.8e1 / 0.3e1 * t360 * t372 - 0.8e1 * t375 * t393 - 0.8e1 * t376 * t439 - 0.8e1 / 0.3e1 * t361 * t514)
  t519 = t22 * t518
  t523 = 0.1e1 + t13
  t524 = t523 <= f.p.zeta_threshold
  t525 = t523 ** (0.1e1 / 0.3e1)
  t526 = t525 ** 2
  t527 = 0.1e1 / t526
  t528 = -t63
  t529 = t528 ** 2
  t532 = -t89
  t536 = f.my_piecewise3(t524, 0, 0.4e1 / 0.9e1 * t527 * t529 + 0.4e1 / 0.3e1 * t525 * t532)
  t537 = t9 * t536
  t538 = f.my_piecewise3(t524, t16, t525)
  t539 = 0.1e1 / t538
  t542 = t27 * t29 * t539 / 0.18e2
  t543 = 0.192e1 <= t542
  t544 = 0.192e1 < t542
  t545 = f.my_piecewise3(t544, t542, 0.192e1)
  t546 = t545 ** 2
  t547 = t546 * t545
  t548 = 0.1e1 / t547
  t552 = t538 ** 2
  t553 = 0.1e1 / t552
  t554 = t527 * t528
  t556 = f.my_piecewise3(t524, 0, t554 / 0.3e1)
  t557 = t553 * t556
  t561 = -t27 * t73 * t539 / 0.54e2 - t27 * t29 * t557 / 0.18e2
  t562 = f.my_piecewise3(t544, t561, 0)
  t565 = t546 ** 2
  t566 = t565 * t545
  t567 = 0.1e1 / t566
  t570 = t565 * t547
  t571 = 0.1e1 / t570
  t574 = t565 ** 2
  t575 = t574 * t545
  t576 = 0.1e1 / t575
  t579 = t574 * t547
  t580 = 0.1e1 / t579
  t583 = t574 * t566
  t584 = 0.1e1 / t583
  t587 = t574 * t570
  t588 = 0.1e1 / t587
  t591 = t574 ** 2
  t593 = 0.1e1 / t591 / t545
  t597 = 0.1e1 / t591 / t547
  t601 = 0.1e1 / t591 / t566
  t605 = 0.1e1 / t591 / t570
  t609 = 0.1e1 / t591 / t575
  t613 = 0.1e1 / t591 / t579
  t617 = 0.1e1 / t591 / t583
  t621 = 0.1e1 / t591 / t587
  t624 = t591 ** 2
  t626 = 0.1e1 / t624 / t545
  t630 = 0.1e1 / t624 / t547
  t634 = 0.1e1 / t624 / t566
  t637 = -0.2e1 / 0.9e1 * t548 * t562 + 0.2e1 / 0.15e2 * t567 * t562 - 0.3e1 / 0.35e2 * t571 * t562 + 0.8e1 / 0.135e3 * t576 * t562 - 0.10e2 / 0.231e3 * t580 * t562 + 0.3e1 / 0.91e2 * t584 * t562 - 0.7e1 / 0.270e3 * t588 * t562 + 0.16e2 / 0.765e3 * t593 * t562 - 0.18e2 / 0.1045e4 * t597 * t562 + 0.10e2 / 0.693e3 * t601 * t562 - 0.11e2 / 0.897e3 * t605 * t562 + 0.24e2 / 0.2275e4 * t609 * t562 - 0.26e2 / 0.2835e4 * t613 * t562 + 0.7e1 / 0.870e3 * t617 * t562 - 0.15e2 / 0.2108e4 * t621 * t562 + 0.32e2 / 0.5049e4 * t626 * t562 - 0.34e2 / 0.5985e4 * t630 * t562 + 0.18e2 / 0.3515e4 * t634 * t562
  t638 = f.my_piecewise3(t544, 0, t561)
  t639 = f.my_piecewise3(t544, 0.192e1, t542)
  t640 = jnp.atan2(0.1e1, t639)
  t641 = t639 ** 2
  t642 = t641 + 0.3e1
  t643 = 0.1e1 / t641
  t644 = 0.1e1 + t643
  t645 = jnp.log(t644)
  t647 = -t642 * t645 + 0.1e1
  t650 = t640 + t639 * t647 / 0.4e1
  t653 = 0.1e1 / t644
  t659 = t641 * t639
  t660 = 0.1e1 / t659
  t661 = t642 * t660
  t662 = t638 * t653
  t665 = -0.2e1 * t639 * t638 * t645 + 0.2e1 * t661 * t662
  t668 = -t643 * t638 * t653 + t638 * t647 / 0.4e1 + t639 * t665 / 0.4e1
  t672 = f.my_piecewise3(t543, t637, -0.8e1 / 0.3e1 * t638 * t650 - 0.8e1 / 0.3e1 * t639 * t668)
  t673 = t22 * t672
  t678 = f.my_piecewise3(t524, t17, t525 * t523)
  t679 = t9 * t678
  t680 = t22 ** 2
  t682 = 0.1e1 / t680 / t11
  t683 = t682 * t672
  t723 = -0.2e1 / 0.9e1 * t340 * t178 + 0.2e1 / 0.15e2 * t168 * t178 - 0.3e1 / 0.35e2 * t160 * t178 + 0.8e1 / 0.135e3 * t210 * t178 - 0.10e2 / 0.231e3 * t144 * t178 + 0.3e1 / 0.91e2 * t140 * t178 - 0.7e1 / 0.270e3 * t148 * t178 + 0.16e2 / 0.765e3 * t220 * t178 - 0.18e2 / 0.1045e4 * t335 * t178 + 0.10e2 / 0.693e3 * t203 * t178 - 0.11e2 / 0.897e3 * t45 * t178 + 0.24e2 / 0.2275e4 * t157 * t178 - 0.26e2 / 0.2835e4 * t199 * t178 + 0.7e1 / 0.870e3 * t207 * t178 - 0.15e2 / 0.2108e4 * t152 * t178 + 0.32e2 / 0.5049e4 * t165 * t178 - 0.34e2 / 0.5985e4 * t195 * t178 + 0.18e2 / 0.3515e4 * t186 * t178
  t728 = f.my_piecewise3(t35, t723, -0.8e1 / 0.3e1 * t361 * t393 - 0.8e1 / 0.3e1 * t376 * t372)
  t729 = t682 * t728
  t734 = 0.1e1 / t526 / t523
  t735 = t529 * t528
  t740 = -t125
  t744 = f.my_piecewise3(t524, 0, -0.8e1 / 0.27e2 * t734 * t735 + 0.4e1 / 0.3e1 * t554 * t532 + 0.4e1 / 0.3e1 * t525 * t740)
  t745 = t9 * t744
  t748 = 0.1e1 / t565
  t750 = t565 * t546
  t751 = 0.1e1 / t750
  t753 = 0.1e1 / t574
  t755 = t574 * t546
  t756 = 0.1e1 / t755
  t758 = t574 * t565
  t759 = 0.1e1 / t758
  t761 = t574 * t750
  t762 = 0.1e1 / t761
  t764 = 0.1e1 / t591
  t767 = 0.1e1 / t591 / t546
  t770 = 0.1e1 / t591 / t565
  t773 = 0.1e1 / t591 / t750
  t776 = 0.1e1 / t591 / t574
  t779 = 0.1e1 / t591 / t755
  t782 = 0.1e1 / t591 / t758
  t785 = 0.1e1 / t591 / t761
  t787 = 0.1e1 / t624
  t790 = 0.1e1 / t624 / t546
  t793 = 0.1e1 / t624 / t565
  t795 = 0.1e1 / t546 / 0.9e1 - t748 / 0.30e2 + t751 / 0.70e2 - t753 / 0.135e3 + t756 / 0.231e3 - t759 / 0.364e3 + t762 / 0.540e3 - t764 / 0.765e3 + t767 / 0.1045e4 - t770 / 0.1386e4 + t773 / 0.1794e4 - t776 / 0.2275e4 + t779 / 0.2835e4 - t782 / 0.3480e4 + t785 / 0.4216e4 - t787 / 0.5049e4 + t790 / 0.5985e4 - t793 / 0.7030e4
  t799 = f.my_piecewise3(t543, t795, 0.1e1 - 0.8e1 / 0.3e1 * t639 * t650)
  t800 = t22 * t799
  t804 = 0.1e1 / t680
  t805 = t804 * t799
  t816 = 0.1e1 / t552 / t538
  t817 = t556 ** 2
  t818 = t816 * t817
  t822 = t734 * t529
  t827 = f.my_piecewise3(t524, 0, -0.2e1 / 0.9e1 * t822 + t527 * t532 / 0.3e1)
  t828 = t553 * t827
  t832 = 0.2e1 / 0.81e2 * t27 * t56 * t539 + t27 * t73 * t557 / 0.27e2 + t27 * t29 * t818 / 0.9e1 - t27 * t29 * t828 / 0.18e2
  t833 = f.my_piecewise3(t544, t832, 0)
  t838 = t562 ** 2
  t856 = 0.1e1 / t624 / t750
  t873 = 0.24e2 / 0.2275e4 * t609 * t833 + 0.2e1 / 0.15e2 * t567 * t833 - 0.24e2 / 0.91e2 * t779 * t838 + 0.18e2 / 0.55e2 * t770 * t838 - 0.16e2 / 0.45e2 * t767 * t838 - 0.3e1 / 0.7e1 * t762 * t838 + 0.32e2 / 0.5049e4 * t626 * t833 + 0.26e2 / 0.105e3 * t782 * t838 + 0.11e2 / 0.39e2 * t776 * t838 - 0.2e1 / 0.9e1 * t548 * t833 - 0.18e2 / 0.95e2 * t856 * t838 - 0.32e2 / 0.153e3 * t790 * t838 - 0.15e2 / 0.2108e4 * t621 * t833 + 0.3e1 / 0.5e1 * t753 * t838 + 0.2e1 / 0.3e1 * t748 * t838 - 0.2e1 / 0.3e1 * t751 * t838 - 0.7e1 / 0.270e3 * t588 * t833 - 0.3e1 / 0.35e2 * t571 * t833
  t910 = 0.18e2 / 0.3515e4 * t634 * t833 + 0.7e1 / 0.870e3 * t617 * t833 + 0.8e1 / 0.135e3 * t576 * t833 - 0.10e2 / 0.33e2 * t773 * t838 - 0.11e2 / 0.897e3 * t605 * t833 - 0.26e2 / 0.2835e4 * t613 * t833 - 0.10e2 / 0.231e3 * t580 * t833 + 0.7e1 / 0.18e2 * t764 * t838 - 0.8e1 / 0.15e2 * t756 * t838 + 0.34e2 / 0.171e3 * t793 * t838 - 0.7e1 / 0.30e2 * t785 * t838 + 0.10e2 / 0.21e2 * t759 * t838 + 0.10e2 / 0.693e3 * t601 * t833 + 0.3e1 / 0.91e2 * t584 * t833 + 0.16e2 / 0.765e3 * t593 * t833 - 0.18e2 / 0.1045e4 * t597 * t833 - 0.34e2 / 0.5985e4 * t630 * t833 + 0.15e2 / 0.68e2 * t787 * t838
  t912 = f.my_piecewise3(t544, 0, t832)
  t917 = t638 ** 2
  t918 = t660 * t917
  t921 = t643 * t912
  t923 = t641 ** 2
  t925 = 0.1e1 / t923 / t639
  t927 = t644 ** 2
  t928 = 0.1e1 / t927
  t943 = 0.1e1 / t923
  t944 = t642 * t943
  t945 = t917 * t653
  t948 = t912 * t653
  t952 = 0.1e1 / t923 / t641
  t953 = t642 * t952
  t954 = t917 * t928
  t957 = -0.2e1 * t639 * t912 * t645 + 0.8e1 * t643 * t917 * t653 - 0.2e1 * t917 * t645 + 0.2e1 * t661 * t948 - 0.6e1 * t944 * t945 + 0.4e1 * t953 * t954
  t960 = 0.2e1 * t918 * t653 - t921 * t653 - 0.2e1 * t925 * t917 * t928 + t912 * t647 / 0.4e1 + t638 * t665 / 0.2e1 + t639 * t957 / 0.4e1
  t964 = f.my_piecewise3(t543, t873 + t910, -0.8e1 / 0.3e1 * t912 * t650 - 0.16e2 / 0.3e1 * t638 * t668 - 0.8e1 / 0.3e1 * t639 * t960)
  t965 = t804 * t964
  t970 = 0.1e1 / t680 / t46
  t990 = 0.1e1 / t38 / 0.9e1 - t307 / 0.30e2 + t285 / 0.70e2 - t281 / 0.135e3 + t294 / 0.231e3 - t312 / 0.364e3 + t299 / 0.540e3 - t303 / 0.765e3 + t323 / 0.1045e4 - t230 / 0.1386e4 + t290 / 0.1794e4 - t257 / 0.2275e4 + t268 / 0.2835e4 - t318 / 0.3480e4 + t328 / 0.4216e4 - t277 / 0.5049e4 + t273 / 0.5985e4 - t262 / 0.7030e4
  t994 = f.my_piecewise3(t35, t990, 0.1e1 - 0.8e1 / 0.3e1 * t361 * t372)
  t995 = t970 * t994
  t1003 = t207 * t244
  t1009 = t210 * t244
  t1017 = t195 * t244
  t1035 = 0.18e2 / 0.3515e4 * t186 * t244 + 0.10e2 / 0.693e3 * t203 * t244 + 0.7e1 / 0.870e3 * t1003 + 0.24e2 / 0.2275e4 * t157 * t244 + 0.32e2 / 0.5049e4 * t165 * t244 + 0.8e1 / 0.135e3 * t1009 - 0.24e2 / 0.91e2 * t268 * t179 + 0.26e2 / 0.105e3 * t318 * t179 + 0.3e1 / 0.91e2 * t140 * t244 - 0.34e2 / 0.5985e4 * t1017 - 0.32e2 / 0.153e3 * t273 * t179 - 0.7e1 / 0.30e2 * t328 * t179 - 0.18e2 / 0.1045e4 * t335 * t244 - 0.11e2 / 0.897e3 * t45 * t244 - 0.26e2 / 0.2835e4 * t199 * t244 - 0.2e1 / 0.9e1 * t340 * t244 + 0.7e1 / 0.18e2 * t303 * t179 - 0.16e2 / 0.45e2 * t323 * t179
  t1072 = 0.34e2 / 0.171e3 * t262 * t179 - 0.18e2 / 0.95e2 * t250 * t179 - 0.7e1 / 0.270e3 * t148 * t244 - 0.10e2 / 0.33e2 * t290 * t179 - 0.3e1 / 0.7e1 * t299 * t179 + 0.11e2 / 0.39e2 * t257 * t179 + 0.18e2 / 0.55e2 * t230 * t179 - 0.10e2 / 0.231e3 * t144 * t244 - 0.3e1 / 0.35e2 * t160 * t244 + 0.16e2 / 0.765e3 * t220 * t244 - 0.2e1 / 0.3e1 * t285 * t179 + 0.3e1 / 0.5e1 * t281 * t179 + 0.15e2 / 0.68e2 * t277 * t179 + 0.2e1 / 0.3e1 * t307 * t179 - 0.15e2 / 0.2108e4 * t152 * t244 - 0.8e1 / 0.15e2 * t294 * t179 + 0.10e2 / 0.21e2 * t312 * t179 + 0.2e1 / 0.15e2 * t168 * t244
  t1081 = f.my_piecewise3(t35, t1035 + t1072, -0.8e1 / 0.3e1 * t375 * t372 - 0.16e2 / 0.3e1 * t376 * t393 - 0.8e1 / 0.3e1 * t361 * t439)
  t1082 = t804 * t1081
  t1088 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t63)
  t1089 = t9 * t1088
  t1090 = t682 * t994
  t1100 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t60 * t83 + 0.4e1 / 0.3e1 * t18 * t89)
  t1101 = t9 * t1100
  t1102 = t804 * t994
  t1108 = f.my_piecewise3(t524, 0, 0.4e1 / 0.3e1 * t525 * t528)
  t1109 = t9 * t1108
  t1110 = t804 * t672
  t1121 = f.my_piecewise3(t15, 0, -0.8e1 / 0.27e2 * t82 * t115 + 0.4e1 / 0.3e1 * t64 * t89 + 0.4e1 / 0.3e1 * t18 * t125)
  t1122 = t9 * t1121
  t1123 = t22 * t994
  t1127 = t22 * t728
  t1143 = t552 ** 2
  t1144 = 0.1e1 / t1143
  t1146 = t1144 * t817 * t556
  t1150 = t28 * t816
  t1151 = t556 * t827
  t1155 = t523 ** 2
  t1157 = 0.1e1 / t526 / t1155
  t1160 = t734 * t528
  t1166 = f.my_piecewise3(t524, 0, 0.10e2 / 0.27e2 * t1157 * t735 - 0.2e1 / 0.3e1 * t1160 * t532 + t527 * t740 / 0.3e1)
  t1167 = t553 * t1166
  t1171 = -0.14e2 / 0.243e3 * t27 * t50 * t539 - 0.2e1 / 0.27e2 * t27 * t56 * t557 - t27 * t73 * t818 / 0.9e1 + t27 * t73 * t828 / 0.18e2 - t27 * t29 * t1146 / 0.3e1 + t106 * t1150 * t1151 / 0.3e1 - t27 * t29 * t1167 / 0.18e2
  t1172 = f.my_piecewise3(t544, t1171, 0)
  t1206 = 0.104e3 / 0.105e3 * t782 * t1172 * t562 - 0.112e3 / 0.3e1 * t593 * t838 * t833 + 0.128e3 / 0.3e1 * t630 * t838 * t833 - 0.128e3 / 0.153e3 * t790 * t1172 * t562 + 0.42e2 * t621 * t838 * t833 + 0.32e2 * t580 * t838 * t833 - 0.14e2 / 0.15e2 * t785 * t1172 * t562 + 0.136e3 / 0.171e3 * t793 * t1172 * t562 + 0.288e3 / 0.7e1 * t613 * t838 * t833 - 0.32e2 / 0.15e2 * t756 * t1172 * t562 - 0.96e2 / 0.91e2 * t779 * t1172 * t562
  t1240 = -0.64e2 / 0.45e2 * t767 * t1172 * t562 - 0.40e2 / 0.33e2 * t773 * t1172 * t562 + 0.36e2 * t588 * t838 * t833 + 0.40e2 / 0.21e2 * t759 * t1172 * t562 + 0.12e2 / 0.5e1 * t753 * t1172 * t562 - 0.208e3 / 0.5e1 * t617 * t838 * t833 - 0.144e3 / 0.5e1 * t576 * t838 * t833 + 0.14e2 / 0.9e1 * t764 * t1172 * t562 + 0.44e2 / 0.39e2 * t776 * t1172 * t562 - 0.432e3 / 0.11e2 * t601 * t838 * t833 + 0.40e2 * t605 * t838 * t833
  t1258 = 0.1e1 / t624 / t570
  t1277 = -0.12e2 / 0.7e1 * t762 * t1172 * t562 - 0.528e3 / 0.13e2 * t609 * t838 * t833 - 0.720e3 / 0.17e2 * t626 * t838 * t833 - 0.16e2 * t567 * t838 * t833 - 0.240e3 / 0.7e1 * t584 * t838 * t833 + 0.216e3 / 0.5e1 * t1258 * t838 * t833 + 0.72e2 / 0.55e2 * t770 * t1172 * t562 + 0.192e3 / 0.5e1 * t597 * t838 * t833 + 0.15e2 / 0.17e2 * t787 * t1172 * t562 - 0.72e2 / 0.95e2 * t856 * t1172 * t562 - 0.8e1 / 0.3e1 * t751 * t1172 * t562
  t1287 = t838 ** 2
  t1294 = t833 ** 2
  t1305 = t1 / t22 / t121
  t1330 = t817 ** 2
  t1340 = t827 ** 2
  t1352 = t529 ** 2
  t1358 = t532 ** 2
  t1367 = -0.24e2 * t122 + 0.24e2 * t10 / t121 / t11
  t1371 = f.my_piecewise3(t524, 0, -0.80e2 / 0.81e2 / t526 / t1155 / t523 * t1352 + 0.20e2 / 0.9e1 * t1157 * t529 * t532 - 0.2e1 / 0.3e1 * t734 * t1358 - 0.8e1 / 0.9e1 * t1160 * t740 + t527 * t1367 / 0.3e1)
  t1376 = 0.140e3 / 0.729e3 * t27 * t1305 * t539 + 0.56e2 / 0.243e3 * t27 * t50 * t557 + 0.8e1 / 0.27e2 * t27 * t56 * t818 - 0.4e1 / 0.27e2 * t27 * t56 * t828 + 0.4e1 / 0.9e1 * t27 * t73 * t1146 - 0.4e1 / 0.9e1 * t106 * t72 * t816 * t1151 + 0.2e1 / 0.27e2 * t27 * t73 * t1167 + 0.4e1 / 0.3e1 * t27 * t29 / t1143 / t538 * t1330 - 0.2e1 * t106 * t28 * t1144 * t817 * t827 + t27 * t29 * t816 * t1340 / 0.3e1 + 0.4e1 / 0.9e1 * t106 * t1150 * t556 * t1166 - t27 * t29 * t553 * t1371 / 0.18e2
  t1377 = f.my_piecewise3(t544, t1376, 0)
  t1382 = 0.8e1 / 0.3e1 * t748 * t1172 * t562 - 0.816e3 / 0.19e2 * t634 * t838 * t833 + 0.24e2 * t571 * t838 * t833 + 0.3016e4 / 0.15e2 * t785 * t1287 - 0.2240e4 / 0.9e1 * t793 * t1287 - 0.90e2 * t764 * t1287 - 0.7e1 / 0.10e2 * t785 * t1294 - 0.2e1 * t751 * t1294 - 0.54e2 / 0.95e2 * t856 * t1294 + 0.40e2 / 0.3e1 * t751 * t1287 - 0.26e2 / 0.2835e4 * t613 * t1377 - 0.3e1 / 0.35e2 * t571 * t1377
  t1407 = 0.3960e4 / 0.17e2 * t790 * t1287 + 0.2e1 * t748 * t1294 + 0.54e2 / 0.55e2 * t770 * t1294 - 0.10e2 / 0.231e3 * t580 * t1377 + 0.2e1 / 0.15e2 * t567 * t1377 - 0.608e3 / 0.5e1 * t770 * t1287 + 0.45e2 / 0.68e2 * t787 * t1294 - 0.34e2 / 0.5985e4 * t630 * t1377 + 0.32e2 / 0.5049e4 * t626 * t1377 + 0.3e1 / 0.91e2 * t584 * t1377 - 0.7e1 / 0.270e3 * t588 * t1377
  t1430 = -0.32e2 / 0.51e2 * t790 * t1294 + 0.24e2 / 0.2275e4 * t609 * t1377 + 0.520e3 / 0.7e1 * t762 * t1287 - 0.8e1 / 0.5e1 * t756 * t1294 + 0.2200e4 / 0.13e2 * t779 * t1287 + 0.8e1 / 0.135e3 * t576 * t1377 - 0.16e2 / 0.15e2 * t767 * t1294 - 0.10e2 / 0.11e2 * t773 * t1294 + 0.10e2 / 0.693e3 * t601 * t1377 + 0.26e2 / 0.35e2 * t782 * t1294 - 0.1296e4 / 0.7e1 * t782 * t1287
  t1456 = -0.11e2 / 0.897e3 * t605 * t1377 - 0.18e2 / 0.1045e4 * t597 * t1377 + 0.34e2 / 0.57e2 * t793 * t1294 - 0.1404e4 / 0.5e1 / t624 / t574 * t1287 - 0.460e3 / 0.3e1 * t776 * t1287 + 0.18e2 / 0.3515e4 * t634 * t1377 + 0.10e2 / 0.7e1 * t759 * t1294 - 0.72e2 / 0.91e2 * t779 * t1294 - 0.28e2 * t753 * t1287 + 0.1512e4 / 0.11e2 * t773 * t1287 - 0.2e1 / 0.9e1 * t548 * t1377
  t1481 = 0.11e2 / 0.13e2 * t776 * t1294 + 0.9e1 / 0.5e1 * t753 * t1294 + 0.7e1 / 0.870e3 * t617 * t1377 - 0.217e3 * t787 * t1287 - 0.15e2 / 0.2108e4 * t621 * t1377 + 0.952e3 / 0.9e1 * t767 * t1287 + 0.5032e4 / 0.19e2 * t856 * t1287 - 0.9e1 / 0.7e1 * t762 * t1294 + 0.16e2 / 0.765e3 * t593 * t1377 - 0.176e3 / 0.3e1 * t759 * t1287 + 0.216e3 / 0.5e1 * t756 * t1287 + 0.7e1 / 0.6e1 * t764 * t1294
  t1485 = f.my_piecewise3(t544, 0, t1376)
  t1488 = f.my_piecewise3(t544, 0, t1171)
  t1493 = t917 * t638
  t1497 = t660 * t638
  t1503 = t643 * t1488
  t1505 = t925 * t912
  t1506 = t928 * t638
  t1509 = t923 ** 2
  t1510 = 0.1e1 / t1509
  t1513 = 0.1e1 / t927 / t644
  t1522 = t638 * t645
  t1536 = t642 * t925
  t1544 = 0.1e1 / t923 / t659
  t1545 = t642 * t1544
  t1549 = t1488 * t653
  t1552 = t912 * t928
  t1557 = 0.1e1 / t1509 / t639
  t1558 = t642 * t1557
  t1562 = -0.2e1 * t639 * t1488 * t645 + 0.16e2 * t1558 * t1493 * t1513 + 0.24e2 * t1536 * t1493 * t653 - 0.36e2 * t1545 * t1493 * t928 - 0.24e2 * t1493 * t660 * t653 + 0.24e2 * t925 * t1493 * t928 + 0.12e2 * t953 * t1552 * t638 - 0.18e2 * t944 * t662 * t912 - 0.6e1 * t1522 * t912 + 0.2e1 * t661 * t1549 + 0.24e2 * t921 * t662
  t1565 = -0.6e1 * t943 * t1493 * t653 + 0.6e1 * t1497 * t948 + 0.14e2 * t952 * t1493 * t928 - t1503 * t653 - 0.6e1 * t1505 * t1506 - 0.8e1 * t1510 * t1493 * t1513 + t1488 * t647 / 0.4e1 + 0.3e1 / 0.4e1 * t912 * t665 + 0.3e1 / 0.4e1 * t638 * t957 + t639 * t1562 / 0.4e1
  t1575 = t912 ** 2
  t1585 = t917 ** 2
  t1609 = 0.16e2 * t953 * t1488 * t928 * t638 + 0.12e2 * t953 * t1575 * t928 + 0.96e2 * t1558 * t912 * t1513 * t917 - 0.144e3 * t918 * t948 + 0.120e3 * t1585 * t943 * t653 + 0.32e2 * t1503 * t662 + 0.24e2 * t643 * t1575 * t653 + 0.144e3 * t1505 * t954 + 0.300e3 * t642 * t1510 * t1585 * t928 - 0.288e3 * t642 / t1509 / t641 * t1585 * t1513 + 0.2e1 * t661 * t1485 * t653
  t1613 = t927 ** 2
  t1614 = 0.1e1 / t1613
  t1646 = 0.96e2 * t642 / t1509 / t923 * t1585 * t1614 - 0.120e3 * t953 * t1585 * t653 + 0.144e3 * t1536 * t945 * t912 - 0.18e2 * t944 * t1575 * t653 - 0.24e2 * t944 * t662 * t1488 - 0.216e3 * t1545 * t954 * t912 - 0.6e1 * t1575 * t645 - 0.8e1 * t1522 * t1488 - 0.240e3 * t1585 * t952 * t928 - 0.2e1 * t639 * t1485 * t645 + 0.128e3 * t1510 * t1585 * t1513
  t1690 = 0.3e1 / 0.2e1 * t912 * t957 + t638 * t1562 + t639 * (t1609 + t1646) / 0.4e1 + t1485 * t647 / 0.4e1 + t1488 * t665 + 0.24e2 * t925 * t1585 * t653 - 0.36e2 * t943 * t917 * t948 + 0.6e1 * t660 * t1575 * t653 + 0.8e1 * t1497 * t1549 + 0.84e2 * t952 * t917 * t1552 - 0.8e1 * t925 * t1488 * t1506 - 0.6e1 * t925 * t1575 * t928 - 0.48e2 * t1510 * t912 * t1513 * t917 - 0.96e2 * t1544 * t1585 * t928 + 0.120e3 * t1557 * t1585 * t1513 - t643 * t1485 * t653 - 0.48e2 / t1509 / t659 * t1585 * t1614
  t1694 = f.my_piecewise3(t543, t1206 + t1240 + t1277 + t1382 + t1407 + t1430 + t1456 + t1481, -0.8e1 / 0.3e1 * t1485 * t650 - 0.32e2 / 0.3e1 * t1488 * t668 - 0.16e2 * t912 * t960 - 0.32e2 / 0.3e1 * t638 * t1565 - 0.8e1 / 0.3e1 * t639 * t1690)
  t1707 = 0.1e1 / t680 / t47
  t1712 = t682 * t799
  t1716 = t970 * t799
  t1724 = t804 * t728
  t1779 = 0.45e2 / 0.68e2 * t787 * t562 * t833 - 0.16e2 / 0.15e2 * t767 * t833 * t562 - 0.54e2 / 0.95e2 * t856 * t833 * t562 - 0.72e2 / 0.91e2 * t779 * t833 * t562 - 0.2e1 * t751 * t833 * t562 + 0.7e1 / 0.6e1 * t764 * t833 * t562 - 0.8e1 / 0.5e1 * t756 * t833 * t562 - 0.10e2 / 0.11e2 * t773 * t562 * t833 + 0.9e1 / 0.5e1 * t753 * t562 * t833 - 0.32e2 / 0.51e2 * t790 * t833 * t562 + 0.2e1 * t748 * t562 * t833 + 0.10e2 / 0.7e1 * t759 * t562 * t833 + 0.54e2 / 0.55e2 * t770 * t833 * t562
  t1795 = t838 * t562
  t1814 = -0.9e1 / 0.7e1 * t762 * t562 * t833 + 0.34e2 / 0.57e2 * t793 * t833 * t562 - 0.7e1 / 0.10e2 * t785 * t562 * t833 + 0.26e2 / 0.35e2 * t782 * t833 * t562 + 0.11e2 / 0.13e2 * t776 * t562 * t833 - 0.24e2 / 0.5e1 * t576 * t1795 - 0.10e2 / 0.231e3 * t580 * t1172 - 0.3e1 / 0.35e2 * t571 * t1172 + 0.24e2 / 0.2275e4 * t609 * t1172 - 0.72e2 / 0.11e2 * t601 * t1795 + 0.32e2 / 0.5e1 * t597 * t1795 - 0.2e1 / 0.9e1 * t548 * t1172 + 0.36e2 / 0.5e1 * t1258 * t1795 + 0.20e2 / 0.3e1 * t605 * t1795
  t1842 = 0.7e1 * t621 * t1795 + 0.18e2 / 0.3515e4 * t634 * t1172 + 0.3e1 / 0.91e2 * t584 * t1172 - 0.15e2 / 0.2108e4 * t621 * t1172 - 0.8e1 / 0.3e1 * t567 * t1795 + 0.8e1 / 0.135e3 * t576 * t1172 + 0.10e2 / 0.693e3 * t601 * t1172 + 0.7e1 / 0.870e3 * t617 * t1172 - 0.40e2 / 0.7e1 * t584 * t1795 - 0.88e2 / 0.13e2 * t609 * t1795 - 0.104e3 / 0.15e2 * t617 * t1795 + 0.16e2 / 0.765e3 * t593 * t1172 - 0.11e2 / 0.897e3 * t605 * t1172
  t1871 = -0.120e3 / 0.17e2 * t626 * t1795 - 0.34e2 / 0.5985e4 * t630 * t1172 + 0.32e2 / 0.5049e4 * t626 * t1172 + 0.64e2 / 0.9e1 * t630 * t1795 - 0.56e2 / 0.9e1 * t593 * t1795 - 0.7e1 / 0.270e3 * t588 * t1172 + 0.48e2 / 0.7e1 * t613 * t1795 + 0.16e2 / 0.3e1 * t580 * t1795 - 0.26e2 / 0.2835e4 * t613 * t1172 + 0.4e1 * t571 * t1795 - 0.136e3 / 0.19e2 * t634 * t1795 + 0.6e1 * t588 * t1795 + 0.2e1 / 0.15e2 * t567 * t1172 - 0.18e2 / 0.1045e4 * t597 * t1172
  t1883 = f.my_piecewise3(t543, t1779 + t1814 + t1842 + t1871, -0.8e1 / 0.3e1 * t1488 * t650 - 0.8e1 * t912 * t668 - 0.8e1 * t638 * t960 - 0.8e1 / 0.3e1 * t639 * t1565)
  t1884 = t22 * t1883
  t1899 = f.my_piecewise3(t524, 0, 0.40e2 / 0.81e2 * t1157 * t1352 - 0.16e2 / 0.9e1 * t822 * t532 + 0.4e1 / 0.3e1 * t527 * t1358 + 0.16e2 / 0.9e1 * t554 * t740 + 0.4e1 / 0.3e1 * t525 * t1367)
  t1907 = -0.3e1 / 0.32e2 * t7 * t679 * t22 * t1694 + t7 * t679 * t682 * t964 / 0.8e1 - 0.5e1 / 0.36e2 * t7 * t1089 * t995 + 0.5e1 / 0.54e2 * t7 * t21 * t1707 * t994 + t7 * t537 * t1712 / 0.8e1 - 0.5e1 / 0.36e2 * t7 * t1109 * t1716 + 0.5e1 / 0.54e2 * t7 * t679 * t1707 * t799 - 0.3e1 / 0.8e1 * t7 * t1101 * t1724 + t7 * t1109 * t683 / 0.4e1 - t7 * t745 * t805 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t537 * t1110 + t7 * t1101 * t1090 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t1109 * t1884 - 0.3e1 / 0.32e2 * t7 * t9 * t1899 * t800 - 0.3e1 / 0.8e1 * t7 * t745 * t673
  t1908 = t83 ** 2
  t1913 = t89 ** 2
  t1918 = -t1367
  t1922 = f.my_piecewise3(t15, 0, 0.40e2 / 0.81e2 * t114 * t1908 - 0.16e2 / 0.9e1 * t84 * t89 + 0.4e1 / 0.3e1 * t60 * t1913 + 0.16e2 / 0.9e1 * t64 * t125 + 0.4e1 / 0.3e1 * t18 * t1918)
  t1959 = -0.32e2 / 0.15e2 * t295 * t135 - 0.720e3 / 0.17e2 * t165 * t179 * t244 + 0.216e3 / 0.5e1 * t190 * t179 * t244 + 0.42e2 * t152 * t179 * t244 - 0.14e2 / 0.15e2 * t328 * t135 * t178 + 0.15e2 / 0.17e2 * t277 * t135 * t178 + 0.40e2 * t45 * t179 * t244 - 0.528e3 / 0.13e2 * t157 * t179 * t244 - 0.816e3 / 0.19e2 * t186 * t179 * t244 - 0.432e3 / 0.11e2 * t203 * t179 * t244 - 0.8e1 / 0.3e1 * t285 * t135 * t178
  t1988 = 0.44e2 / 0.39e2 * t258 * t135 - 0.12e2 / 0.7e1 * t299 * t135 * t178 + 0.14e2 / 0.9e1 * t304 * t135 + 0.136e3 / 0.171e3 * t262 * t135 * t178 - 0.40e2 / 0.33e2 * t290 * t135 * t178 + 0.72e2 / 0.55e2 * t230 * t135 * t178 + 0.24e2 * t160 * t179 * t244 + 0.192e3 / 0.5e1 * t335 * t179 * t244 - 0.144e3 / 0.5e1 * t1009 * t179 + 0.128e3 / 0.3e1 * t1017 * t179 - 0.208e3 / 0.5e1 * t1003 * t179
  t2021 = -0.240e3 / 0.7e1 * t140 * t179 * t244 + 0.288e3 / 0.7e1 * t199 * t179 * t244 + 0.32e2 * t144 * t179 * t244 - 0.96e2 / 0.91e2 * t269 * t135 - 0.112e3 / 0.3e1 * t220 * t179 * t244 + 0.36e2 * t148 * t179 * t244 - 0.64e2 / 0.45e2 * t324 * t135 - 0.128e3 / 0.153e3 * t273 * t135 * t178 + 0.104e3 / 0.105e3 * t318 * t135 * t178 + 0.12e2 / 0.5e1 * t281 * t135 * t178 - 0.72e2 / 0.95e2 * t250 * t135 * t178
  t2030 = t179 ** 2
  t2033 = t244 ** 2
  t2060 = t76 ** 2
  t2070 = t93 ** 2
  t2094 = f.my_piecewise3(t15, 0, -0.80e2 / 0.81e2 / t59 / t112 / t14 * t1908 + 0.20e2 / 0.9e1 * t114 * t83 * t89 - 0.2e1 / 0.3e1 * t82 * t1913 - 0.8e1 / 0.9e1 * t118 * t125 + t60 * t1918 / 0.3e1)
  t2099 = 0.140e3 / 0.729e3 * t27 * t1305 * t31 + 0.56e2 / 0.243e3 * t27 * t50 * t67 + 0.8e1 / 0.27e2 * t27 * t56 * t77 - 0.4e1 / 0.27e2 * t27 * t56 * t94 + 0.4e1 / 0.9e1 * t27 * t73 * t101 - 0.4e1 / 0.9e1 * t106 * t72 * t75 * t108 + 0.2e1 / 0.27e2 * t27 * t73 * t130 + 0.4e1 / 0.3e1 * t27 * t29 / t98 / t30 * t2060 - 0.2e1 * t106 * t28 * t99 * t76 * t93 + t27 * t29 * t75 * t2070 / 0.3e1 + 0.4e1 / 0.9e1 * t106 * t107 * t66 * t129 - t27 * t29 * t58 * t2094 / 0.18e2
  t2100 = f.my_piecewise3(t36, t2099, 0)
  t2115 = 0.8e1 / 0.3e1 * t307 * t135 * t178 - 0.16e2 * t168 * t179 * t244 + 0.40e2 / 0.21e2 * t313 * t135 + 0.2200e4 / 0.13e2 * t268 * t2030 - 0.8e1 / 0.5e1 * t294 * t2033 + 0.10e2 / 0.693e3 * t203 * t2100 - 0.176e3 / 0.3e1 * t312 * t2030 + 0.7e1 / 0.6e1 * t303 * t2033 - 0.7e1 / 0.270e3 * t148 * t2100 - 0.2e1 * t285 * t2033 + 0.24e2 / 0.2275e4 * t157 * t2100 + 0.2e1 / 0.15e2 * t168 * t2100
  t2140 = 0.11e2 / 0.13e2 * t257 * t2033 + 0.7e1 / 0.870e3 * t207 * t2100 - 0.608e3 / 0.5e1 * t230 * t2030 + 0.3016e4 / 0.15e2 * t328 * t2030 - 0.15e2 / 0.2108e4 * t152 * t2100 - 0.11e2 / 0.897e3 * t45 * t2100 + 0.16e2 / 0.765e3 * t220 * t2100 - 0.26e2 / 0.2835e4 * t199 * t2100 - 0.7e1 / 0.10e2 * t328 * t2033 + 0.34e2 / 0.57e2 * t262 * t2033 - 0.54e2 / 0.95e2 * t250 * t2033
  t2163 = -0.2e1 / 0.9e1 * t340 * t2100 - 0.2240e4 / 0.9e1 * t262 * t2030 + 0.5032e4 / 0.19e2 * t250 * t2030 + 0.216e3 / 0.5e1 * t294 * t2030 + 0.3e1 / 0.91e2 * t140 * t2100 + 0.54e2 / 0.55e2 * t230 * t2033 + 0.520e3 / 0.7e1 * t299 * t2030 - 0.28e2 * t281 * t2030 - 0.32e2 / 0.51e2 * t273 * t2033 - 0.34e2 / 0.5985e4 * t195 * t2100 + 0.18e2 / 0.3515e4 * t186 * t2100
  t2187 = 0.952e3 / 0.9e1 * t323 * t2030 + 0.1512e4 / 0.11e2 * t290 * t2030 + 0.9e1 / 0.5e1 * t281 * t2033 + 0.3960e4 / 0.17e2 * t273 * t2030 - 0.90e2 * t303 * t2030 - 0.9e1 / 0.7e1 * t299 * t2033 + 0.8e1 / 0.135e3 * t210 * t2100 + 0.40e2 / 0.3e1 * t285 * t2030 + 0.32e2 / 0.5049e4 * t165 * t2100 - 0.1296e4 / 0.7e1 * t318 * t2030 + 0.10e2 / 0.7e1 * t312 * t2033
  t2214 = -0.16e2 / 0.15e2 * t323 * t2033 - 0.10e2 / 0.231e3 * t144 * t2100 - 0.10e2 / 0.11e2 * t290 * t2033 - 0.18e2 / 0.1045e4 * t335 * t2100 - 0.72e2 / 0.91e2 * t268 * t2033 - 0.1404e4 / 0.5e1 / t163 / t42 * t2030 + 0.2e1 * t307 * t2033 - 0.217e3 * t277 * t2030 - 0.460e3 / 0.3e1 * t257 * t2030 - 0.3e1 / 0.35e2 * t160 * t2100 + 0.26e2 / 0.35e2 * t318 * t2033 + 0.45e2 / 0.68e2 * t277 * t2033
  t2218 = f.my_piecewise3(t36, 0, t2099)
  t2227 = t396 ** 2
  t2234 = t375 ** 2
  t2270 = t406 ** 2
  t2271 = 0.1e1 / t2270
  t2309 = -0.144e3 * t397 * t427 + 0.120e3 * t2227 * t422 * t378 + 0.32e2 * t452 * t387 + 0.24e2 * t365 * t2234 * t378 + 0.144e3 * t454 * t433 + 0.300e3 * t364 * t459 * t2227 * t407 - 0.288e3 * t364 / t458 / t363 * t2227 * t462 + 0.2e1 * t386 * t2218 * t378 + 0.96e2 * t364 / t458 / t402 * t2227 * t2271 - 0.6e1 * t2234 * t367 - 0.8e1 * t471 * t360
  t2345 = 0.16e2 * t432 * t360 * t407 * t376 + 0.96e2 * t507 * t375 * t462 * t396 - 0.2e1 * t361 * t2218 * t367 - 0.120e3 * t432 * t2227 * t378 - 0.240e3 * t2227 * t431 * t407 + 0.128e3 * t459 * t2227 * t462 - 0.18e2 * t423 * t2234 * t378 + 0.12e2 * t432 * t2234 * t407 - 0.24e2 * t423 * t387 * t360 + 0.144e3 * t485 * t424 * t375 - 0.216e3 * t494 * t433 * t375
  t2349 = 0.24e2 * t404 * t2227 * t378 - 0.36e2 * t422 * t396 * t427 + 0.6e1 * t385 * t2234 * t378 + 0.8e1 * t446 * t498 + 0.84e2 * t431 * t396 * t501 - 0.8e1 * t404 * t360 * t455 - 0.6e1 * t404 * t2234 * t407 - 0.48e2 * t459 * t375 * t462 * t396 + t2218 * t369 / 0.4e1 + t360 * t390 + 0.3e1 / 0.2e1 * t375 * t436 + t376 * t511 - 0.96e2 * t493 * t2227 * t407 + 0.120e3 * t506 * t2227 * t462 - t365 * t2218 * t378 - 0.48e2 / t458 / t384 * t2227 * t2271 + t361 * (t2309 + t2345) / 0.4e1
  t2353 = f.my_piecewise3(t35, t1959 + t1988 + t2021 + t2115 + t2140 + t2163 + t2187 + t2214, -0.8e1 / 0.3e1 * t2218 * t372 - 0.32e2 / 0.3e1 * t360 * t393 - 0.16e2 * t375 * t439 - 0.32e2 / 0.3e1 * t376 * t514 - 0.8e1 / 0.3e1 * t361 * t2349)
  t2368 = t22 * t964
  t2383 = t22 * t1081
  t2404 = -0.3e1 / 0.32e2 * t7 * t9 * t1922 * t1123 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t2353 - 0.3e1 / 0.8e1 * t7 * t1122 * t1127 - 0.5e1 / 0.36e2 * t7 * t679 * t970 * t672 - t7 * t1122 * t1102 / 0.8e1 - 0.9e1 / 0.16e2 * t7 * t537 * t2368 - t7 * t21 * t804 * t518 / 0.8e1 + t7 * t1089 * t729 / 0.4e1 - t7 * t679 * t804 * t1883 / 0.8e1 - 0.9e1 / 0.16e2 * t7 * t1101 * t2383 - 0.5e1 / 0.36e2 * t7 * t21 * t970 * t728 - 0.3e1 / 0.8e1 * t7 * t1109 * t965 - 0.3e1 / 0.8e1 * t7 * t1089 * t1082 + t7 * t21 * t682 * t1081 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t1089 * t519
  t2425 = -0.3e1 / 0.8e1 * t7 * t1101 * t1102 - 0.3e1 / 0.4e1 * t7 * t1109 * t1110 - 0.3e1 / 0.8e1 * t7 * t1122 * t1123 - 0.9e1 / 0.8e1 * t7 * t1101 * t1127 + t11 * (t1907 + t2404) - 0.3e1 / 0.4e1 * t7 * t1089 * t1724 + t7 * t1109 * t1712 / 0.4e1 - 0.5e1 / 0.36e2 * t7 * t679 * t1716 - 0.9e1 / 0.8e1 * t7 * t1089 * t2383 - 0.3e1 / 0.8e1 * t7 * t679 * t1884 - 0.9e1 / 0.8e1 * t7 * t1109 * t2368
  d1111 = -0.3e1 / 0.8e1 * t7 * t21 * t519 - 0.9e1 / 0.8e1 * t7 * t537 * t673 + t7 * t679 * t683 / 0.4e1 + t7 * t21 * t729 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t745 * t800 - 0.3e1 / 0.8e1 * t7 * t537 * t805 - 0.3e1 / 0.8e1 * t7 * t679 * t965 - 0.5e1 / 0.36e2 * t7 * t21 * t995 - 0.3e1 / 0.8e1 * t7 * t21 * t1082 + t7 * t1089 * t1090 / 0.4e1 + t2425

  res = {'v4rho4': d1111}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t1 * t3 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 + t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = t14 ** (0.1e1 / 0.3e1)
  t17 = t11 ** 2
  t18 = 0.1e1 / t17
  t19 = t10 * t18
  t20 = t12 - t19
  t23 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t16 * t20)
  t24 = t9 * t23
  t25 = t11 ** (0.1e1 / 0.3e1)
  t26 = 9 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = t3 ** 2
  t29 = t27 * t28
  t30 = t29 * f.p.cam_omega
  t31 = 0.1e1 / t25
  t32 = t1 * t31
  t33 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t15, t33, t16)
  t35 = 0.1e1 / t34
  t38 = t30 * t32 * t35 / 0.18e2
  t39 = 0.192e1 <= t38
  t40 = 0.192e1 < t38
  t41 = f.my_piecewise3(t40, t38, 0.192e1)
  t42 = t41 ** 2
  t45 = t42 ** 2
  t46 = 0.1e1 / t45
  t48 = t45 * t42
  t49 = 0.1e1 / t48
  t51 = t45 ** 2
  t52 = 0.1e1 / t51
  t54 = t51 * t42
  t55 = 0.1e1 / t54
  t57 = t51 * t45
  t58 = 0.1e1 / t57
  t60 = t51 * t48
  t61 = 0.1e1 / t60
  t63 = t51 ** 2
  t64 = 0.1e1 / t63
  t67 = 0.1e1 / t63 / t42
  t70 = 0.1e1 / t63 / t45
  t73 = 0.1e1 / t63 / t48
  t76 = 0.1e1 / t63 / t51
  t79 = 0.1e1 / t63 / t54
  t82 = 0.1e1 / t63 / t57
  t85 = 0.1e1 / t63 / t60
  t87 = t63 ** 2
  t88 = 0.1e1 / t87
  t91 = 0.1e1 / t87 / t42
  t94 = 0.1e1 / t87 / t45
  t96 = 0.1e1 / t42 / 0.9e1 - t46 / 0.30e2 + t49 / 0.70e2 - t52 / 0.135e3 + t55 / 0.231e3 - t58 / 0.364e3 + t61 / 0.540e3 - t64 / 0.765e3 + t67 / 0.1045e4 - t70 / 0.1386e4 + t73 / 0.1794e4 - t76 / 0.2275e4 + t79 / 0.2835e4 - t82 / 0.3480e4 + t85 / 0.4216e4 - t88 / 0.5049e4 + t91 / 0.5985e4 - t94 / 0.7030e4
  t97 = f.my_piecewise3(t40, 0.192e1, t38)
  t98 = jnp.arctan2(0.1e1, t97)
  t99 = t97 ** 2
  t100 = t99 + 0.3e1
  t101 = 0.1e1 / t99
  t102 = 0.1e1 + t101
  t103 = jnp.log(t102)
  t105 = -t100 * t103 + 0.1e1
  t108 = t98 + t97 * t105 / 0.4e1
  t112 = f.my_piecewise3(t39, t96, 0.1e1 - 0.8e1 / 0.3e1 * t97 * t108)
  t113 = t25 * t112
  t115 = t7 * t24 * t113
  t117 = t33 * f.p.zeta_threshold
  t119 = f.my_piecewise3(t15, t117, t16 * t14)
  t120 = t9 * t119
  t121 = t25 ** 2
  t122 = 0.1e1 / t121
  t123 = t122 * t112
  t126 = t7 * t120 * t123 / 0.16e2
  t127 = t42 * t41
  t128 = 0.1e1 / t127
  t131 = t1 / t25 / t11
  t134 = t30 * t131 * t35 / 0.54e2
  t135 = t34 ** 2
  t136 = 0.1e1 / t135
  t137 = t16 ** 2
  t138 = 0.1e1 / t137
  t141 = f.my_piecewise3(t15, 0, t138 * t20 / 0.3e1)
  t142 = t136 * t141
  t146 = -t134 - t30 * t32 * t142 / 0.18e2
  t147 = f.my_piecewise3(t40, t146, 0)
  t150 = t45 * t41
  t151 = 0.1e1 / t150
  t154 = t45 * t127
  t155 = 0.1e1 / t154
  t158 = t51 * t41
  t159 = 0.1e1 / t158
  t162 = t51 * t127
  t163 = 0.1e1 / t162
  t166 = t51 * t150
  t167 = 0.1e1 / t166
  t170 = t51 * t154
  t171 = 0.1e1 / t170
  t175 = 0.1e1 / t63 / t41
  t179 = 0.1e1 / t63 / t127
  t183 = 0.1e1 / t63 / t150
  t187 = 0.1e1 / t63 / t154
  t191 = 0.1e1 / t63 / t158
  t195 = 0.1e1 / t63 / t162
  t199 = 0.1e1 / t63 / t166
  t203 = 0.1e1 / t63 / t170
  t207 = 0.1e1 / t87 / t41
  t211 = 0.1e1 / t87 / t127
  t215 = 0.1e1 / t87 / t150
  t218 = -0.2e1 / 0.9e1 * t128 * t147 + 0.2e1 / 0.15e2 * t151 * t147 - 0.3e1 / 0.35e2 * t155 * t147 + 0.8e1 / 0.135e3 * t159 * t147 - 0.10e2 / 0.231e3 * t163 * t147 + 0.3e1 / 0.91e2 * t167 * t147 - 0.7e1 / 0.270e3 * t171 * t147 + 0.16e2 / 0.765e3 * t175 * t147 - 0.18e2 / 0.1045e4 * t179 * t147 + 0.10e2 / 0.693e3 * t183 * t147 - 0.11e2 / 0.897e3 * t187 * t147 + 0.24e2 / 0.2275e4 * t191 * t147 - 0.26e2 / 0.2835e4 * t195 * t147 + 0.7e1 / 0.870e3 * t199 * t147 - 0.15e2 / 0.2108e4 * t203 * t147 + 0.32e2 / 0.5049e4 * t207 * t147 - 0.34e2 / 0.5985e4 * t211 * t147 + 0.18e2 / 0.3515e4 * t215 * t147
  t219 = f.my_piecewise3(t40, 0, t146)
  t222 = 0.1e1 / t102
  t229 = 0.1e1 / t99 / t97
  t230 = t100 * t229
  t231 = t219 * t222
  t234 = -0.2e1 * t97 * t219 * t103 + 0.2e1 * t230 * t231
  t237 = -t101 * t219 * t222 + t219 * t105 / 0.4e1 + t97 * t234 / 0.4e1
  t241 = f.my_piecewise3(t39, t218, -0.8e1 / 0.3e1 * t219 * t108 - 0.8e1 / 0.3e1 * t97 * t237)
  t242 = t25 * t241
  t244 = t7 * t120 * t242
  t246 = 0.1e1 - t13
  t247 = t246 <= f.p.zeta_threshold
  t248 = t246 ** (0.1e1 / 0.3e1)
  t249 = -t20
  t252 = f.my_piecewise3(t247, 0, 0.4e1 / 0.3e1 * t248 * t249)
  t253 = t9 * t252
  t254 = f.my_piecewise3(t247, t33, t248)
  t255 = 0.1e1 / t254
  t258 = t30 * t32 * t255 / 0.18e2
  t259 = 0.192e1 <= t258
  t260 = 0.192e1 < t258
  t261 = f.my_piecewise3(t260, t258, 0.192e1)
  t262 = t261 ** 2
  t265 = t262 ** 2
  t266 = 0.1e1 / t265
  t268 = t265 * t262
  t269 = 0.1e1 / t268
  t271 = t265 ** 2
  t272 = 0.1e1 / t271
  t274 = t271 * t262
  t275 = 0.1e1 / t274
  t277 = t271 * t265
  t278 = 0.1e1 / t277
  t280 = t271 * t268
  t281 = 0.1e1 / t280
  t283 = t271 ** 2
  t284 = 0.1e1 / t283
  t287 = 0.1e1 / t283 / t262
  t290 = 0.1e1 / t283 / t265
  t293 = 0.1e1 / t283 / t268
  t296 = 0.1e1 / t283 / t271
  t299 = 0.1e1 / t283 / t274
  t302 = 0.1e1 / t283 / t277
  t305 = 0.1e1 / t283 / t280
  t307 = t283 ** 2
  t308 = 0.1e1 / t307
  t311 = 0.1e1 / t307 / t262
  t314 = 0.1e1 / t307 / t265
  t316 = 0.1e1 / t262 / 0.9e1 - t266 / 0.30e2 + t269 / 0.70e2 - t272 / 0.135e3 + t275 / 0.231e3 - t278 / 0.364e3 + t281 / 0.540e3 - t284 / 0.765e3 + t287 / 0.1045e4 - t290 / 0.1386e4 + t293 / 0.1794e4 - t296 / 0.2275e4 + t299 / 0.2835e4 - t302 / 0.3480e4 + t305 / 0.4216e4 - t308 / 0.5049e4 + t311 / 0.5985e4 - t314 / 0.7030e4
  t317 = f.my_piecewise3(t260, 0.192e1, t258)
  t318 = jnp.arctan2(0.1e1, t317)
  t319 = t317 ** 2
  t320 = t319 + 0.3e1
  t321 = 0.1e1 / t319
  t322 = 0.1e1 + t321
  t323 = jnp.log(t322)
  t325 = -t320 * t323 + 0.1e1
  t328 = t318 + t317 * t325 / 0.4e1
  t332 = f.my_piecewise3(t259, t316, 0.1e1 - 0.8e1 / 0.3e1 * t317 * t328)
  t333 = t25 * t332
  t335 = t7 * t253 * t333
  t338 = f.my_piecewise3(t247, t117, t248 * t246)
  t339 = t9 * t338
  t340 = t122 * t332
  t343 = t7 * t339 * t340 / 0.16e2
  t344 = t262 * t261
  t345 = 0.1e1 / t344
  t348 = t30 * t131 * t255 / 0.54e2
  t349 = t254 ** 2
  t350 = 0.1e1 / t349
  t351 = t248 ** 2
  t352 = 0.1e1 / t351
  t355 = f.my_piecewise3(t247, 0, t352 * t249 / 0.3e1)
  t356 = t350 * t355
  t360 = -t348 - t30 * t32 * t356 / 0.18e2
  t361 = f.my_piecewise3(t260, t360, 0)
  t364 = t265 * t261
  t365 = 0.1e1 / t364
  t368 = t265 * t344
  t369 = 0.1e1 / t368
  t372 = t271 * t261
  t373 = 0.1e1 / t372
  t376 = t271 * t344
  t377 = 0.1e1 / t376
  t380 = t271 * t364
  t381 = 0.1e1 / t380
  t384 = t271 * t368
  t385 = 0.1e1 / t384
  t389 = 0.1e1 / t283 / t261
  t393 = 0.1e1 / t283 / t344
  t397 = 0.1e1 / t283 / t364
  t401 = 0.1e1 / t283 / t368
  t405 = 0.1e1 / t283 / t372
  t409 = 0.1e1 / t283 / t376
  t413 = 0.1e1 / t283 / t380
  t417 = 0.1e1 / t283 / t384
  t421 = 0.1e1 / t307 / t261
  t425 = 0.1e1 / t307 / t344
  t429 = 0.1e1 / t307 / t364
  t432 = -0.2e1 / 0.9e1 * t345 * t361 + 0.2e1 / 0.15e2 * t365 * t361 - 0.3e1 / 0.35e2 * t369 * t361 + 0.8e1 / 0.135e3 * t373 * t361 - 0.10e2 / 0.231e3 * t377 * t361 + 0.3e1 / 0.91e2 * t381 * t361 - 0.7e1 / 0.270e3 * t385 * t361 + 0.16e2 / 0.765e3 * t389 * t361 - 0.18e2 / 0.1045e4 * t393 * t361 + 0.10e2 / 0.693e3 * t397 * t361 - 0.11e2 / 0.897e3 * t401 * t361 + 0.24e2 / 0.2275e4 * t405 * t361 - 0.26e2 / 0.2835e4 * t409 * t361 + 0.7e1 / 0.870e3 * t413 * t361 - 0.15e2 / 0.2108e4 * t417 * t361 + 0.32e2 / 0.5049e4 * t421 * t361 - 0.34e2 / 0.5985e4 * t425 * t361 + 0.18e2 / 0.3515e4 * t429 * t361
  t433 = f.my_piecewise3(t260, 0, t360)
  t436 = 0.1e1 / t322
  t443 = 0.1e1 / t319 / t317
  t444 = t320 * t443
  t445 = t433 * t436
  t448 = -0.2e1 * t317 * t433 * t323 + 0.2e1 * t444 * t445
  t451 = -t321 * t433 * t436 + t433 * t325 / 0.4e1 + t317 * t448 / 0.4e1
  t455 = f.my_piecewise3(t259, t432, -0.8e1 / 0.3e1 * t317 * t451 - 0.8e1 / 0.3e1 * t433 * t328)
  t456 = t25 * t455
  t458 = t7 * t339 * t456
  t460 = t20 ** 2
  t464 = 0.1e1 / t17 / t11
  t465 = t10 * t464
  t467 = -0.2e1 * t18 + 0.2e1 * t465
  t471 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t138 * t460 + 0.4e1 / 0.3e1 * t16 * t467)
  t477 = t7 * t24 * t123
  t483 = 0.1e1 / t121 / t11
  t487 = t7 * t120 * t483 * t112 / 0.48e2
  t490 = t7 * t120 * t122 * t241
  t494 = t1 / t25 / t17
  t497 = 0.2e1 / 0.81e2 * t30 * t494 * t35
  t499 = t30 * t131 * t142
  t502 = 0.1e1 / t135 / t34
  t503 = t141 ** 2
  t509 = 0.1e1 / t137 / t14
  t515 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t509 * t460 + t138 * t467 / 0.3e1)
  t520 = t497 + t499 / 0.27e2 + t30 * t32 * t502 * t503 / 0.9e1 - t30 * t32 * t136 * t515 / 0.18e2
  t521 = f.my_piecewise3(t40, t520, 0)
  t556 = t147 ** 2
  t559 = 0.3e1 / 0.91e2 * t167 * t521 - 0.7e1 / 0.270e3 * t171 * t521 + 0.16e2 / 0.765e3 * t175 * t521 - 0.18e2 / 0.1045e4 * t179 * t521 + 0.10e2 / 0.693e3 * t183 * t521 - 0.11e2 / 0.897e3 * t187 * t521 + 0.24e2 / 0.2275e4 * t191 * t521 - 0.26e2 / 0.2835e4 * t195 * t521 + 0.7e1 / 0.870e3 * t199 * t521 - 0.15e2 / 0.2108e4 * t203 * t521 + 0.32e2 / 0.5049e4 * t207 * t521 - 0.34e2 / 0.5985e4 * t211 * t521 + 0.18e2 / 0.3515e4 * t215 * t521 - 0.2e1 / 0.9e1 * t128 * t521 + 0.2e1 / 0.15e2 * t151 * t521 - 0.3e1 / 0.35e2 * t155 * t521 + 0.8e1 / 0.135e3 * t159 * t521 - 0.2e1 / 0.3e1 * t49 * t556
  t591 = 0.1e1 / t87 / t48
  t598 = -0.10e2 / 0.231e3 * t163 * t521 - 0.8e1 / 0.15e2 * t55 * t556 + 0.2e1 / 0.3e1 * t46 * t556 + 0.3e1 / 0.5e1 * t52 * t556 + 0.7e1 / 0.18e2 * t64 * t556 + 0.10e2 / 0.21e2 * t58 * t556 + 0.18e2 / 0.55e2 * t70 * t556 - 0.3e1 / 0.7e1 * t61 * t556 - 0.16e2 / 0.45e2 * t67 * t556 - 0.24e2 / 0.91e2 * t79 * t556 - 0.10e2 / 0.33e2 * t73 * t556 - 0.7e1 / 0.30e2 * t85 * t556 + 0.11e2 / 0.39e2 * t76 * t556 + 0.26e2 / 0.105e3 * t82 * t556 + 0.15e2 / 0.68e2 * t88 * t556 - 0.18e2 / 0.95e2 * t591 * t556 - 0.32e2 / 0.153e3 * t91 * t556 + 0.34e2 / 0.171e3 * t94 * t556
  t600 = f.my_piecewise3(t40, 0, t520)
  t605 = t219 ** 2
  t611 = t99 ** 2
  t613 = 0.1e1 / t611 / t97
  t615 = t102 ** 2
  t616 = 0.1e1 / t615
  t632 = t100 / t611
  t641 = t100 / t611 / t99
  t652 = f.my_piecewise3(t39, t559 + t598, -0.8e1 / 0.3e1 * t600 * t108 - 0.16e2 / 0.3e1 * t219 * t237 - 0.8e1 / 0.3e1 * t97 * (0.2e1 * t229 * t605 * t222 - t101 * t600 * t222 - 0.2e1 * t613 * t605 * t616 + t600 * t105 / 0.4e1 + t219 * t234 / 0.2e1 + t97 * (0.8e1 * t101 * t605 * t222 - 0.2e1 * t97 * t600 * t103 + 0.2e1 * t230 * t600 * t222 - 0.6e1 * t632 * t605 * t222 + 0.4e1 * t641 * t605 * t616 - 0.2e1 * t605 * t103) / 0.4e1))
  t657 = t249 ** 2
  t660 = -t467
  t664 = f.my_piecewise3(t247, 0, 0.4e1 / 0.9e1 * t352 * t657 + 0.4e1 / 0.3e1 * t248 * t660)
  t670 = t7 * t253 * t340
  t678 = t7 * t339 * t483 * t332 / 0.48e2
  t681 = t7 * t339 * t122 * t455
  t685 = 0.2e1 / 0.81e2 * t30 * t494 * t255
  t687 = t30 * t131 * t356
  t690 = 0.1e1 / t349 / t254
  t691 = t355 ** 2
  t697 = 0.1e1 / t351 / t246
  t703 = f.my_piecewise3(t247, 0, -0.2e1 / 0.9e1 * t697 * t657 + t352 * t660 / 0.3e1)
  t708 = t685 + t687 / 0.27e2 + t30 * t32 * t690 * t691 / 0.9e1 - t30 * t32 * t350 * t703 / 0.18e2
  t709 = f.my_piecewise3(t260, t708, 0)
  t746 = -0.11e2 / 0.897e3 * t401 * t709 + 0.24e2 / 0.2275e4 * t405 * t709 - 0.26e2 / 0.2835e4 * t409 * t709 + 0.7e1 / 0.870e3 * t413 * t709 - 0.15e2 / 0.2108e4 * t417 * t709 + 0.32e2 / 0.5049e4 * t421 * t709 - 0.34e2 / 0.5985e4 * t425 * t709 + 0.18e2 / 0.3515e4 * t429 * t709 - 0.2e1 / 0.9e1 * t345 * t709 + 0.2e1 / 0.15e2 * t365 * t709 - 0.3e1 / 0.35e2 * t369 * t709 + 0.8e1 / 0.135e3 * t373 * t709 - 0.10e2 / 0.231e3 * t377 * t709 + 0.3e1 / 0.91e2 * t381 * t709 - 0.7e1 / 0.270e3 * t385 * t709 + 0.16e2 / 0.765e3 * t389 * t709 - 0.18e2 / 0.1045e4 * t393 * t709 + 0.10e2 / 0.693e3 * t397 * t709
  t747 = t361 ** 2
  t779 = 0.1e1 / t307 / t268
  t786 = 0.3e1 / 0.5e1 * t272 * t747 + 0.2e1 / 0.3e1 * t266 * t747 - 0.8e1 / 0.15e2 * t275 * t747 - 0.2e1 / 0.3e1 * t269 * t747 - 0.3e1 / 0.7e1 * t281 * t747 - 0.16e2 / 0.45e2 * t287 * t747 + 0.10e2 / 0.21e2 * t278 * t747 + 0.18e2 / 0.55e2 * t290 * t747 + 0.7e1 / 0.18e2 * t284 * t747 + 0.11e2 / 0.39e2 * t296 * t747 + 0.26e2 / 0.105e3 * t302 * t747 - 0.10e2 / 0.33e2 * t293 * t747 - 0.7e1 / 0.30e2 * t305 * t747 - 0.24e2 / 0.91e2 * t299 * t747 - 0.32e2 / 0.153e3 * t311 * t747 - 0.18e2 / 0.95e2 * t779 * t747 + 0.15e2 / 0.68e2 * t308 * t747 + 0.34e2 / 0.171e3 * t314 * t747
  t788 = f.my_piecewise3(t260, 0, t708)
  t793 = t433 ** 2
  t799 = t319 ** 2
  t801 = 0.1e1 / t799 / t317
  t803 = t322 ** 2
  t804 = 0.1e1 / t803
  t820 = t320 / t799
  t829 = t320 / t799 / t319
  t840 = f.my_piecewise3(t259, t746 + t786, -0.8e1 / 0.3e1 * t788 * t328 - 0.16e2 / 0.3e1 * t433 * t451 - 0.8e1 / 0.3e1 * t317 * (0.2e1 * t443 * t793 * t436 - t321 * t788 * t436 - 0.2e1 * t801 * t793 * t804 + t788 * t325 / 0.4e1 + t433 * t448 / 0.2e1 + t317 * (-0.2e1 * t317 * t788 * t323 + 0.8e1 * t321 * t793 * t436 + 0.2e1 * t444 * t788 * t436 - 0.6e1 * t820 * t793 * t436 + 0.4e1 * t829 * t793 * t804 - 0.2e1 * t793 * t323) / 0.4e1))
  t845 = -0.3e1 / 0.32e2 * t7 * t9 * t471 * t113 - t477 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t24 * t242 + t487 - t490 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t120 * t25 * t652 - 0.3e1 / 0.32e2 * t7 * t9 * t664 * t333 - t670 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t253 * t456 + t678 - t681 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t339 * t25 * t840
  d11 = -0.3e1 / 0.16e2 * t115 - t126 - 0.3e1 / 0.16e2 * t244 - 0.3e1 / 0.16e2 * t335 - t343 - 0.3e1 / 0.16e2 * t458 + t11 * t845
  t851 = -t12 - t19
  t854 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t16 * t851)
  t855 = t9 * t854
  t857 = t7 * t855 * t113
  t859 = t138 * t851
  t861 = f.my_piecewise3(t15, 0, t859 / 0.3e1)
  t862 = t136 * t861
  t866 = -t134 - t30 * t32 * t862 / 0.18e2
  t867 = f.my_piecewise3(t40, t866, 0)
  t904 = -0.2e1 / 0.9e1 * t128 * t867 + 0.2e1 / 0.15e2 * t151 * t867 - 0.3e1 / 0.35e2 * t155 * t867 + 0.8e1 / 0.135e3 * t159 * t867 - 0.10e2 / 0.231e3 * t163 * t867 + 0.3e1 / 0.91e2 * t167 * t867 - 0.7e1 / 0.270e3 * t171 * t867 + 0.16e2 / 0.765e3 * t175 * t867 - 0.18e2 / 0.1045e4 * t179 * t867 + 0.10e2 / 0.693e3 * t183 * t867 - 0.11e2 / 0.897e3 * t187 * t867 + 0.24e2 / 0.2275e4 * t191 * t867 - 0.26e2 / 0.2835e4 * t195 * t867 + 0.7e1 / 0.870e3 * t199 * t867 - 0.15e2 / 0.2108e4 * t203 * t867 + 0.32e2 / 0.5049e4 * t207 * t867 - 0.34e2 / 0.5985e4 * t211 * t867 + 0.18e2 / 0.3515e4 * t215 * t867
  t905 = f.my_piecewise3(t40, 0, t866)
  t907 = t101 * t905
  t913 = t905 * t222
  t916 = -0.2e1 * t97 * t905 * t103 + 0.2e1 * t230 * t913
  t919 = -t907 * t222 + t905 * t105 / 0.4e1 + t97 * t916 / 0.4e1
  t923 = f.my_piecewise3(t39, t904, -0.8e1 / 0.3e1 * t905 * t108 - 0.8e1 / 0.3e1 * t97 * t919)
  t924 = t25 * t923
  t926 = t7 * t120 * t924
  t928 = -t851
  t931 = f.my_piecewise3(t247, 0, 0.4e1 / 0.3e1 * t248 * t928)
  t932 = t9 * t931
  t934 = t7 * t932 * t333
  t936 = t352 * t928
  t938 = f.my_piecewise3(t247, 0, t936 / 0.3e1)
  t939 = t350 * t938
  t943 = -t348 - t30 * t32 * t939 / 0.18e2
  t944 = f.my_piecewise3(t260, t943, 0)
  t981 = -0.2e1 / 0.9e1 * t345 * t944 + 0.2e1 / 0.15e2 * t365 * t944 - 0.3e1 / 0.35e2 * t369 * t944 + 0.8e1 / 0.135e3 * t373 * t944 - 0.10e2 / 0.231e3 * t377 * t944 + 0.3e1 / 0.91e2 * t381 * t944 - 0.7e1 / 0.270e3 * t385 * t944 + 0.16e2 / 0.765e3 * t389 * t944 - 0.18e2 / 0.1045e4 * t393 * t944 + 0.10e2 / 0.693e3 * t397 * t944 - 0.11e2 / 0.897e3 * t401 * t944 + 0.24e2 / 0.2275e4 * t405 * t944 - 0.26e2 / 0.2835e4 * t409 * t944 + 0.7e1 / 0.870e3 * t413 * t944 - 0.15e2 / 0.2108e4 * t417 * t944 + 0.32e2 / 0.5049e4 * t421 * t944 - 0.34e2 / 0.5985e4 * t425 * t944 + 0.18e2 / 0.3515e4 * t429 * t944
  t982 = f.my_piecewise3(t260, 0, t943)
  t984 = t321 * t982
  t990 = t982 * t436
  t993 = -0.2e1 * t317 * t982 * t323 + 0.2e1 * t444 * t990
  t996 = -t984 * t436 + t982 * t325 / 0.4e1 + t317 * t993 / 0.4e1
  t1000 = f.my_piecewise3(t259, t981, -0.8e1 / 0.3e1 * t317 * t996 - 0.8e1 / 0.3e1 * t982 * t328)
  t1001 = t25 * t1000
  t1003 = t7 * t339 * t1001
  t1011 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t859 * t20 + 0.8e1 / 0.3e1 * t16 * t10 * t464)
  t1017 = t7 * t855 * t123
  t1029 = t7 * t120 * t122 * t923
  t1085 = 0.34e2 / 0.171e3 * t94 * t867 * t147 - 0.18e2 / 0.95e2 * t591 * t867 * t147 + 0.2e1 / 0.3e1 * t46 * t867 * t147 - 0.2e1 / 0.3e1 * t49 * t867 * t147 + 0.3e1 / 0.5e1 * t52 * t867 * t147 - 0.8e1 / 0.15e2 * t55 * t867 * t147 + 0.10e2 / 0.21e2 * t58 * t867 * t147 - 0.3e1 / 0.7e1 * t61 * t867 * t147 + 0.7e1 / 0.18e2 * t64 * t867 * t147 - 0.16e2 / 0.45e2 * t67 * t867 * t147 + 0.18e2 / 0.55e2 * t70 * t867 * t147 - 0.10e2 / 0.33e2 * t73 * t867 * t147 + 0.11e2 / 0.39e2 * t76 * t867 * t147 - 0.24e2 / 0.91e2 * t79 * t867 * t147 + 0.26e2 / 0.105e3 * t82 * t867 * t147 - 0.7e1 / 0.30e2 * t85 * t867 * t147 + 0.15e2 / 0.68e2 * t88 * t867 * t147 - 0.32e2 / 0.153e3 * t91 * t867 * t147
  t1088 = t30 * t131 * t862
  t1091 = t29 * f.p.cam_omega * t1
  t1104 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t509 * t851 * t20 + 0.2e1 / 0.3e1 * t138 * t10 * t464)
  t1109 = t497 + t499 / 0.54e2 + t1088 / 0.54e2 + t1091 * t31 * t502 * t861 * t141 / 0.9e1 - t30 * t32 * t136 * t1104 / 0.18e2
  t1110 = f.my_piecewise3(t40, t1109, 0)
  t1147 = 0.3e1 / 0.91e2 * t167 * t1110 - 0.7e1 / 0.270e3 * t171 * t1110 + 0.16e2 / 0.765e3 * t175 * t1110 - 0.18e2 / 0.1045e4 * t179 * t1110 + 0.10e2 / 0.693e3 * t183 * t1110 - 0.11e2 / 0.897e3 * t187 * t1110 + 0.24e2 / 0.2275e4 * t191 * t1110 - 0.26e2 / 0.2835e4 * t195 * t1110 + 0.7e1 / 0.870e3 * t199 * t1110 - 0.15e2 / 0.2108e4 * t203 * t1110 + 0.32e2 / 0.5049e4 * t207 * t1110 - 0.34e2 / 0.5985e4 * t211 * t1110 + 0.18e2 / 0.3515e4 * t215 * t1110 - 0.2e1 / 0.9e1 * t128 * t1110 + 0.2e1 / 0.15e2 * t151 * t1110 - 0.3e1 / 0.35e2 * t155 * t1110 + 0.8e1 / 0.135e3 * t159 * t1110 - 0.10e2 / 0.231e3 * t163 * t1110
  t1149 = f.my_piecewise3(t40, 0, t1109)
  t1193 = f.my_piecewise3(t39, t1085 + t1147, -0.8e1 / 0.3e1 * t1149 * t108 - 0.8e1 / 0.3e1 * t905 * t237 - 0.8e1 / 0.3e1 * t219 * t919 - 0.8e1 / 0.3e1 * t97 * (0.2e1 * t229 * t905 * t231 - t101 * t1149 * t222 - 0.2e1 * t613 * t905 * t616 * t219 + t1149 * t105 / 0.4e1 + t905 * t234 / 0.4e1 + t219 * t916 / 0.4e1 + t97 * (0.4e1 * t641 * t905 * t616 * t219 - 0.2e1 * t97 * t1149 * t103 - 0.2e1 * t219 * t905 * t103 + 0.2e1 * t230 * t1149 * t222 - 0.6e1 * t632 * t913 * t219 + 0.8e1 * t907 * t231) / 0.4e1))
  t1204 = f.my_piecewise3(t247, 0, 0.4e1 / 0.9e1 * t936 * t249 - 0.8e1 / 0.3e1 * t248 * t10 * t464)
  t1210 = t7 * t932 * t340
  t1222 = t7 * t339 * t122 * t1000
  t1278 = 0.2e1 / 0.3e1 * t266 * t944 * t361 - 0.2e1 / 0.3e1 * t269 * t944 * t361 + 0.3e1 / 0.5e1 * t272 * t944 * t361 - 0.8e1 / 0.15e2 * t275 * t944 * t361 + 0.10e2 / 0.21e2 * t278 * t944 * t361 - 0.3e1 / 0.7e1 * t281 * t944 * t361 + 0.7e1 / 0.18e2 * t284 * t944 * t361 - 0.16e2 / 0.45e2 * t287 * t944 * t361 + 0.18e2 / 0.55e2 * t290 * t944 * t361 - 0.10e2 / 0.33e2 * t293 * t944 * t361 + 0.11e2 / 0.39e2 * t296 * t944 * t361 - 0.24e2 / 0.91e2 * t299 * t944 * t361 + 0.26e2 / 0.105e3 * t302 * t944 * t361 - 0.7e1 / 0.30e2 * t305 * t944 * t361 + 0.15e2 / 0.68e2 * t308 * t944 * t361 - 0.32e2 / 0.153e3 * t311 * t944 * t361 + 0.34e2 / 0.171e3 * t314 * t944 * t361 - 0.18e2 / 0.95e2 * t779 * t944 * t361
  t1281 = t30 * t131 * t939
  t1295 = f.my_piecewise3(t247, 0, -0.2e1 / 0.9e1 * t697 * t928 * t249 - 0.2e1 / 0.3e1 * t352 * t10 * t464)
  t1300 = t685 + t687 / 0.54e2 + t1281 / 0.54e2 + t1091 * t31 * t690 * t938 * t355 / 0.9e1 - t30 * t32 * t350 * t1295 / 0.18e2
  t1301 = f.my_piecewise3(t260, t1300, 0)
  t1338 = 0.24e2 / 0.2275e4 * t405 * t1301 - 0.26e2 / 0.2835e4 * t409 * t1301 + 0.7e1 / 0.870e3 * t413 * t1301 - 0.15e2 / 0.2108e4 * t417 * t1301 + 0.32e2 / 0.5049e4 * t421 * t1301 - 0.34e2 / 0.5985e4 * t425 * t1301 + 0.18e2 / 0.3515e4 * t429 * t1301 - 0.2e1 / 0.9e1 * t345 * t1301 + 0.2e1 / 0.15e2 * t365 * t1301 - 0.3e1 / 0.35e2 * t369 * t1301 + 0.8e1 / 0.135e3 * t373 * t1301 - 0.10e2 / 0.231e3 * t377 * t1301 + 0.3e1 / 0.91e2 * t381 * t1301 - 0.7e1 / 0.270e3 * t385 * t1301 + 0.16e2 / 0.765e3 * t389 * t1301 - 0.18e2 / 0.1045e4 * t393 * t1301 + 0.10e2 / 0.693e3 * t397 * t1301 - 0.11e2 / 0.897e3 * t401 * t1301
  t1340 = f.my_piecewise3(t260, 0, t1300)
  t1384 = f.my_piecewise3(t259, t1278 + t1338, -0.8e1 / 0.3e1 * t1340 * t328 - 0.8e1 / 0.3e1 * t982 * t451 - 0.8e1 / 0.3e1 * t433 * t996 - 0.8e1 / 0.3e1 * t317 * (0.2e1 * t443 * t982 * t445 - t321 * t1340 * t436 - 0.2e1 * t801 * t982 * t804 * t433 + t1340 * t325 / 0.4e1 + t982 * t448 / 0.4e1 + t433 * t993 / 0.4e1 + t317 * (0.4e1 * t829 * t982 * t804 * t433 - 0.2e1 * t317 * t1340 * t323 + 0.2e1 * t444 * t1340 * t436 - 0.2e1 * t433 * t982 * t323 - 0.6e1 * t820 * t990 * t433 + 0.8e1 * t984 * t445) / 0.4e1))
  t1389 = -0.3e1 / 0.32e2 * t7 * t9 * t1011 * t113 - t1017 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t855 * t242 - t477 / 0.32e2 + t487 - t490 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t24 * t924 - t1029 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t120 * t25 * t1193 - 0.3e1 / 0.32e2 * t7 * t9 * t1204 * t333 - t1210 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t932 * t456 - t670 / 0.32e2 + t678 - t681 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t253 * t1001 - t1222 / 0.32e2 - 0.3e1 / 0.32e2 * t7 * t339 * t25 * t1384
  d12 = -0.3e1 / 0.32e2 * t115 - t126 - 0.3e1 / 0.32e2 * t244 - 0.3e1 / 0.32e2 * t335 - t343 - 0.3e1 / 0.32e2 * t458 - 0.3e1 / 0.32e2 * t857 - 0.3e1 / 0.32e2 * t926 - 0.3e1 / 0.32e2 * t934 - 0.3e1 / 0.32e2 * t1003 + t11 * t1389
  t1395 = t851 ** 2
  t1399 = 0.2e1 * t18 + 0.2e1 * t465
  t1403 = f.my_piecewise3(t15, 0, 0.4e1 / 0.9e1 * t138 * t1395 + 0.4e1 / 0.3e1 * t16 * t1399)
  t1414 = t861 ** 2
  t1424 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t509 * t1395 + t138 * t1399 / 0.3e1)
  t1429 = t497 + t1088 / 0.27e2 + t30 * t32 * t502 * t1414 / 0.9e1 - t30 * t32 * t136 * t1424 / 0.18e2
  t1430 = f.my_piecewise3(t40, t1429, 0)
  t1441 = t867 ** 2
  t1468 = 0.32e2 / 0.5049e4 * t207 * t1430 - 0.34e2 / 0.5985e4 * t211 * t1430 + 0.18e2 / 0.3515e4 * t215 * t1430 - 0.2e1 / 0.9e1 * t128 * t1430 + 0.3e1 / 0.91e2 * t167 * t1430 - 0.3e1 / 0.7e1 * t61 * t1441 - 0.8e1 / 0.15e2 * t55 * t1441 + 0.7e1 / 0.18e2 * t64 * t1441 - 0.16e2 / 0.45e2 * t67 * t1441 - 0.10e2 / 0.33e2 * t73 * t1441 + 0.11e2 / 0.39e2 * t76 * t1441 + 0.18e2 / 0.55e2 * t70 * t1441 - 0.3e1 / 0.35e2 * t155 * t1430 + 0.8e1 / 0.135e3 * t159 * t1430 - 0.10e2 / 0.231e3 * t163 * t1430 - 0.7e1 / 0.270e3 * t171 * t1430 + 0.2e1 / 0.3e1 * t46 * t1441 + 0.2e1 / 0.15e2 * t151 * t1430
  t1505 = -0.2e1 / 0.3e1 * t49 * t1441 + 0.3e1 / 0.5e1 * t52 * t1441 + 0.10e2 / 0.21e2 * t58 * t1441 - 0.24e2 / 0.91e2 * t79 * t1441 + 0.26e2 / 0.105e3 * t82 * t1441 + 0.15e2 / 0.68e2 * t88 * t1441 - 0.32e2 / 0.153e3 * t91 * t1441 - 0.7e1 / 0.30e2 * t85 * t1441 + 0.34e2 / 0.171e3 * t94 * t1441 - 0.18e2 / 0.95e2 * t591 * t1441 + 0.16e2 / 0.765e3 * t175 * t1430 - 0.18e2 / 0.1045e4 * t179 * t1430 + 0.10e2 / 0.693e3 * t183 * t1430 - 0.11e2 / 0.897e3 * t187 * t1430 + 0.24e2 / 0.2275e4 * t191 * t1430 - 0.26e2 / 0.2835e4 * t195 * t1430 + 0.7e1 / 0.870e3 * t199 * t1430 - 0.15e2 / 0.2108e4 * t203 * t1430
  t1507 = f.my_piecewise3(t40, 0, t1429)
  t1512 = t905 ** 2
  t1549 = f.my_piecewise3(t39, t1468 + t1505, -0.8e1 / 0.3e1 * t1507 * t108 - 0.16e2 / 0.3e1 * t905 * t919 - 0.8e1 / 0.3e1 * t97 * (0.2e1 * t229 * t1512 * t222 - t101 * t1507 * t222 - 0.2e1 * t613 * t1512 * t616 + t1507 * t105 / 0.4e1 + t905 * t916 / 0.2e1 + t97 * (0.8e1 * t101 * t1512 * t222 - 0.2e1 * t97 * t1507 * t103 + 0.2e1 * t230 * t1507 * t222 - 0.6e1 * t632 * t1512 * t222 + 0.4e1 * t641 * t1512 * t616 - 0.2e1 * t1512 * t103) / 0.4e1))
  t1554 = t928 ** 2
  t1557 = -t1399
  t1561 = f.my_piecewise3(t247, 0, 0.4e1 / 0.9e1 * t352 * t1554 + 0.4e1 / 0.3e1 * t248 * t1557)
  t1572 = t938 ** 2
  t1582 = f.my_piecewise3(t247, 0, -0.2e1 / 0.9e1 * t697 * t1554 + t352 * t1557 / 0.3e1)
  t1587 = t685 + t1281 / 0.27e2 + t30 * t32 * t690 * t1572 / 0.9e1 - t30 * t32 * t350 * t1582 / 0.18e2
  t1588 = f.my_piecewise3(t260, t1587, 0)
  t1597 = t944 ** 2
  t1626 = -0.7e1 / 0.270e3 * t385 * t1588 - 0.26e2 / 0.2835e4 * t409 * t1588 + 0.7e1 / 0.870e3 * t413 * t1588 - 0.15e2 / 0.2108e4 * t417 * t1588 + 0.7e1 / 0.18e2 * t284 * t1597 - 0.16e2 / 0.45e2 * t287 * t1597 - 0.10e2 / 0.33e2 * t293 * t1597 + 0.18e2 / 0.55e2 * t290 * t1597 + 0.32e2 / 0.5049e4 * t421 * t1588 - 0.34e2 / 0.5985e4 * t425 * t1588 + 0.18e2 / 0.3515e4 * t429 * t1588 - 0.2e1 / 0.9e1 * t345 * t1588 + 0.2e1 / 0.15e2 * t365 * t1588 - 0.3e1 / 0.35e2 * t369 * t1588 + 0.8e1 / 0.135e3 * t373 * t1588 - 0.10e2 / 0.231e3 * t377 * t1588 + 0.3e1 / 0.91e2 * t381 * t1588 - 0.3e1 / 0.7e1 * t281 * t1597
  t1663 = -0.8e1 / 0.15e2 * t275 * t1597 + 0.26e2 / 0.105e3 * t302 * t1597 + 0.11e2 / 0.39e2 * t296 * t1597 + 0.15e2 / 0.68e2 * t308 * t1597 - 0.24e2 / 0.91e2 * t299 * t1597 + 0.2e1 / 0.3e1 * t266 * t1597 + 0.34e2 / 0.171e3 * t314 * t1597 + 0.10e2 / 0.21e2 * t278 * t1597 - 0.2e1 / 0.3e1 * t269 * t1597 - 0.7e1 / 0.30e2 * t305 * t1597 - 0.18e2 / 0.95e2 * t779 * t1597 - 0.32e2 / 0.153e3 * t311 * t1597 + 0.3e1 / 0.5e1 * t272 * t1597 + 0.16e2 / 0.765e3 * t389 * t1588 - 0.18e2 / 0.1045e4 * t393 * t1588 + 0.10e2 / 0.693e3 * t397 * t1588 - 0.11e2 / 0.897e3 * t401 * t1588 + 0.24e2 / 0.2275e4 * t405 * t1588
  t1665 = f.my_piecewise3(t260, 0, t1587)
  t1670 = t982 ** 2
  t1707 = f.my_piecewise3(t259, t1626 + t1663, -0.8e1 / 0.3e1 * t1665 * t328 - 0.16e2 / 0.3e1 * t982 * t996 - 0.8e1 / 0.3e1 * t317 * (0.2e1 * t443 * t1670 * t436 - t321 * t1665 * t436 - 0.2e1 * t801 * t1670 * t804 + t1665 * t325 / 0.4e1 + t982 * t993 / 0.2e1 + t317 * (-0.2e1 * t317 * t1665 * t323 + 0.2e1 * t444 * t1665 * t436 + 0.8e1 * t321 * t1670 * t436 - 0.6e1 * t820 * t1670 * t436 + 0.4e1 * t829 * t1670 * t804 - 0.2e1 * t1670 * t323) / 0.4e1))
  t1712 = -0.3e1 / 0.32e2 * t7 * t9 * t1403 * t113 - t1017 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t855 * t924 + t487 - t1029 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t120 * t25 * t1549 - 0.3e1 / 0.32e2 * t7 * t9 * t1561 * t333 - t1210 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t932 * t1001 + t678 - t1222 / 0.16e2 - 0.3e1 / 0.32e2 * t7 * t339 * t25 * t1707
  d22 = -0.3e1 / 0.16e2 * t857 - t126 - 0.3e1 / 0.16e2 * t926 - 0.3e1 / 0.16e2 * t934 - t343 - 0.3e1 / 0.16e2 * t1003 + t11 * t1712
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

