"""Generated from lda_xc_teter93.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a = np.array([np.nan, 0.4581652932831429, 2.217058676663745, 0.7405551735357053, 0.01968227878617998], dtype=np.float64)

  ap = np.array([np.nan, 0.119086804055547, 0.6157402568883344, 0.1574201515892867, 0.003532336663397157], dtype=np.float64)

  b = np.array([np.nan, 1.0, 4.504130959426697, 1.110667363742916, 0.02359291751427506], dtype=np.float64)

  bp = np.array([np.nan, 0.0, 0.2673612973836267, 0.2052004607777787, 0.004200005045691381], dtype=np.float64)

  functional_body = lambda rs, zeta: -jnp.sum(jnp.array([(a[i] + f.f_zeta(zeta) * ap[i]) * rs ** (i - 1) for i in range(1, 4 + 1)]), axis=0) / jnp.sum(jnp.array([(b[i] + f.f_zeta(zeta) * bp[i]) * rs ** i for i in range(1, 4 + 1)]), axis=0)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a = np.array([np.nan, 0.4581652932831429, 2.217058676663745, 0.7405551735357053, 0.01968227878617998], dtype=np.float64)

  ap = np.array([np.nan, 0.119086804055547, 0.6157402568883344, 0.1574201515892867, 0.003532336663397157], dtype=np.float64)

  b = np.array([np.nan, 1.0, 4.504130959426697, 1.110667363742916, 0.02359291751427506], dtype=np.float64)

  bp = np.array([np.nan, 0.0, 0.2673612973836267, 0.2052004607777787, 0.004200005045691381], dtype=np.float64)

  functional_body = lambda rs, zeta: -jnp.sum(jnp.array([(a[i] + f.f_zeta(zeta) * ap[i]) * rs ** (i - 1) for i in range(1, 4 + 1)]), axis=0) / jnp.sum(jnp.array([(b[i] + f.f_zeta(zeta) * bp[i]) * rs ** i for i in range(1, 4 + 1)]), axis=0)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a = np.array([np.nan, 0.4581652932831429, 2.217058676663745, 0.7405551735357053, 0.01968227878617998], dtype=np.float64)

  ap = np.array([np.nan, 0.119086804055547, 0.6157402568883344, 0.1574201515892867, 0.003532336663397157], dtype=np.float64)

  b = np.array([np.nan, 1.0, 4.504130959426697, 1.110667363742916, 0.02359291751427506], dtype=np.float64)

  bp = np.array([np.nan, 0.0, 0.2673612973836267, 0.2052004607777787, 0.004200005045691381], dtype=np.float64)

  functional_body = lambda rs, zeta: -jnp.sum(jnp.array([(a[i] + f.f_zeta(zeta) * ap[i]) * rs ** (i - 1) for i in range(1, 4 + 1)]), axis=0) / jnp.sum(jnp.array([(b[i] + f.f_zeta(zeta) * bp[i]) * rs ** i for i in range(1, 4 + 1)]), axis=0)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 * f.p.zeta_threshold
  t9 = t5 ** (0.1e1 / 0.3e1)
  t11 = f.my_piecewise3(t6, t8, t9 * t5)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t16 = f.my_piecewise3(t13, t8, t14 * t12)
  t18 = 2 ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / (0.2e1 * t18 - 0.2e1)
  t22 = (t11 + t16 - 0.2e1) * t21
  t26 = 3 ** (0.1e1 / 0.3e1)
  t27 = (0.2217058676663745e1 + 0.6157402568883345e0 * t22) * t26
  t28 = 0.1e1 / jnp.pi
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 4 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = t29 * t31
  t33 = t2 ** (0.1e1 / 0.3e1)
  t34 = 0.1e1 / t33
  t35 = t32 * t34
  t40 = t26 ** 2
  t41 = (0.7405551735357053e0 + 0.1574201515892867e0 * t22) * t40
  t42 = t29 ** 2
  t43 = t42 * t30
  t44 = t33 ** 2
  t46 = t43 / t44
  t51 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t22) * t28
  t54 = 0.4581652932831429e0 + 0.119086804055547e0 * t22 + t27 * t35 / 0.4e1 + t41 * t46 / 0.4e1 + 0.3e1 / 0.4e1 * t51 * t3
  t55 = t26 * t29
  t61 = (0.4504130959426697e1 + 0.2673612973836267e0 * t22) * t40
  t66 = (0.1110667363742916e1 + 0.2052004607777787e0 * t22) * t28
  t71 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t22) * t26
  t73 = t29 * t28 * t31
  t75 = 0.1e1 / t33 / t2
  t76 = t73 * t75
  t79 = 0.25000000000000000000000000000000000000000000000000e0 * t55 * t31 * t34 + t61 * t46 / 0.4e1 + 0.3e1 / 0.4e1 * t66 * t3 + 0.3e1 / 0.16e2 * t71 * t76
  t80 = 0.1e1 / t79
  t81 = t54 * t80
  t82 = t2 ** 2
  t83 = 0.1e1 / t82
  t84 = t1 * t83
  t85 = t3 - t84
  t88 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t85)
  t92 = f.my_piecewise3(t13, 0, -0.4e1 / 0.3e1 * t14 * t85)
  t94 = (t88 + t92) * t21
  t96 = t94 * t26
  t101 = t27 * t32 * t75 / 0.12e2
  t103 = t94 * t40 * t46
  t107 = t43 / t44 / t2
  t109 = t41 * t107 / 0.6e1
  t110 = t28 * t3
  t111 = t94 * t110
  t114 = 0.3e1 / 0.4e1 * t51 * t83
  t118 = t2 * t54
  t119 = t79 ** 2
  t120 = 0.1e1 / t119
  t123 = 0.83333333333333333333333333333333333333333333333333e-1 * t55 * t31 * t75
  t126 = t61 * t107 / 0.6e1
  t129 = 0.3e1 / 0.4e1 * t66 * t83
  t136 = t71 * t73 / t33 / t82 / 0.4e1
  vrho_0_ = -t81 - t2 * (0.119086804055547e0 * t94 + 0.15393506422208362500000000000000000000000000000000e0 * t96 * t35 - t101 + 0.39355037897321675000000000000000000000000000000000e-1 * t103 - t109 + 0.26492524975478677500000000000000000000000000000000e-2 * t111 - t114) * t80 + t118 * t120 * (-t123 + 0.66840324345906675000000000000000000000000000000000e-1 * t103 - t126 + 0.15390034558333402500000000000000000000000000000000e0 * t111 - t129 + 0.78750094606713393750000000000000000000000000000000e-3 * t96 * t76 - t136)
  t140 = -t3 - t84
  t143 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t140)
  t147 = f.my_piecewise3(t13, 0, -0.4e1 / 0.3e1 * t14 * t140)
  t149 = (t143 + t147) * t21
  t151 = t149 * t26
  t155 = t149 * t40 * t46
  t157 = t149 * t110
  vrho_1_ = -t81 - t2 * (0.119086804055547e0 * t149 + 0.15393506422208362500000000000000000000000000000000e0 * t151 * t35 - t101 + 0.39355037897321675000000000000000000000000000000000e-1 * t155 - t109 + 0.26492524975478677500000000000000000000000000000000e-2 * t157 - t114) * t80 + t118 * t120 * (-t123 + 0.66840324345906675000000000000000000000000000000000e-1 * t155 - t126 + 0.15390034558333402500000000000000000000000000000000e0 * t157 - t129 + 0.78750094606713393750000000000000000000000000000000e-3 * t151 * t76 - t136)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a = np.array([np.nan, 0.4581652932831429, 2.217058676663745, 0.7405551735357053, 0.01968227878617998], dtype=np.float64)

  ap = np.array([np.nan, 0.119086804055547, 0.6157402568883344, 0.1574201515892867, 0.003532336663397157], dtype=np.float64)

  b = np.array([np.nan, 1.0, 4.504130959426697, 1.110667363742916, 0.02359291751427506], dtype=np.float64)

  bp = np.array([np.nan, 0.0, 0.2673612973836267, 0.2052004607777787, 0.004200005045691381], dtype=np.float64)

  functional_body = lambda rs, zeta: -jnp.sum(jnp.array([(a[i] + f.f_zeta(zeta) * ap[i]) * rs ** (i - 1) for i in range(1, 4 + 1)]), axis=0) / jnp.sum(jnp.array([(b[i] + f.f_zeta(zeta) * bp[i]) * rs ** i for i in range(1, 4 + 1)]), axis=0)

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = (0.2217058676663745e1 + 0.6157402568883345e0 * t11) * t15
  t17 = 0.1e1 / jnp.pi
  t18 = t17 ** (0.1e1 / 0.3e1)
  t19 = 4 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t18 * t20
  t22 = r0 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t22
  t29 = t15 ** 2
  t30 = (0.7405551735357053e0 + 0.1574201515892867e0 * t11) * t29
  t31 = t18 ** 2
  t32 = t31 * t19
  t33 = t22 ** 2
  t35 = t32 / t33
  t40 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t11) * t17
  t41 = 0.1e1 / r0
  t44 = 0.4581652932831429e0 + 0.119086804055547e0 * t11 + t16 * t21 * t23 / 0.4e1 + t30 * t35 / 0.4e1 + 0.3e1 / 0.4e1 * t40 * t41
  t45 = t15 * t18
  t51 = (0.4504130959426697e1 + 0.2673612973836267e0 * t11) * t29
  t56 = (0.1110667363742916e1 + 0.2052004607777787e0 * t11) * t17
  t61 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t11) * t15
  t63 = t18 * t17 * t20
  t65 = 0.1e1 / t22 / r0
  t69 = 0.25000000000000000000000000000000000000000000000000e0 * t45 * t20 * t23 + t51 * t35 / 0.4e1 + 0.3e1 / 0.4e1 * t56 * t41 + 0.3e1 / 0.16e2 * t61 * t63 * t65
  t70 = 0.1e1 / t69
  t77 = t32 / t33 / r0
  t80 = r0 ** 2
  t81 = 0.1e1 / t80
  t88 = t69 ** 2
  vrho_0_ = -t44 * t70 - r0 * (-t16 * t21 * t65 / 0.12e2 - t30 * t77 / 0.6e1 - 0.3e1 / 0.4e1 * t40 * t81) * t70 + r0 * t44 / t88 * (-0.83333333333333333333333333333333333333333333333333e-1 * t45 * t20 * t65 - t51 * t77 / 0.6e1 - 0.3e1 / 0.4e1 * t56 * t81 - t61 * t63 / t22 / t80 / 0.4e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = (0.2217058676663745e1 + 0.6157402568883345e0 * t11) * t14
  t16 = 0.1e1 / jnp.pi
  t17 = t16 ** (0.1e1 / 0.3e1)
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t21 = r0 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t21 / r0
  t29 = t14 ** 2
  t30 = (0.7405551735357053e0 + 0.1574201515892867e0 * t11) * t29
  t31 = t17 ** 2
  t32 = t31 * t18
  t33 = t21 ** 2
  t36 = t32 / t33 / r0
  t41 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t11) * t16
  t42 = r0 ** 2
  t43 = 0.1e1 / t42
  t46 = -t15 * t20 * t23 / 0.12e2 - t30 * t36 / 0.6e1 - 0.3e1 / 0.4e1 * t41 * t43
  t47 = t14 * t17
  t48 = 0.1e1 / t21
  t54 = (0.4504130959426697e1 + 0.2673612973836267e0 * t11) * t29
  t56 = t32 / t33
  t61 = (0.1110667363742916e1 + 0.2052004607777787e0 * t11) * t16
  t62 = 0.1e1 / r0
  t67 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t11) * t14
  t69 = t17 * t16 * t19
  t73 = 0.25000000000000000000000000000000000000000000000000e0 * t47 * t19 * t48 + t54 * t56 / 0.4e1 + 0.3e1 / 0.4e1 * t61 * t62 + 0.3e1 / 0.16e2 * t67 * t69 * t23
  t74 = 0.1e1 / t73
  t85 = 0.4581652932831429e0 + 0.119086804055547e0 * t11 + t15 * t20 * t48 / 0.4e1 + t30 * t56 / 0.4e1 + 0.3e1 / 0.4e1 * t41 * t62
  t86 = t73 ** 2
  t87 = 0.1e1 / t86
  t97 = 0.1e1 / t21 / t42
  t101 = -0.83333333333333333333333333333333333333333333333333e-1 * t47 * t19 * t23 - t54 * t36 / 0.6e1 - 0.3e1 / 0.4e1 * t61 * t43 - t67 * t69 * t97 / 0.4e1
  t109 = t32 / t33 / t42
  t112 = t42 * r0
  t113 = 0.1e1 / t112
  t123 = r0 * t85
  t126 = t101 ** 2
  v2rho2_0_ = -0.2e1 * t46 * t74 + 0.2e1 * t85 * t87 * t101 - r0 * (t15 * t20 * t97 / 0.9e1 + 0.5e1 / 0.18e2 * t30 * t109 + 0.3e1 / 0.2e1 * t41 * t113) * t74 + 0.2e1 * r0 * t46 * t87 * t101 - 0.2e1 * t123 / t86 / t73 * t126 + t123 * t87 * (0.11111111111111111111111111111111111111111111111111e0 * t47 * t19 * t97 + 0.5e1 / 0.18e2 * t54 * t109 + 0.3e1 / 0.2e1 * t61 * t113 + 0.7e1 / 0.12e2 * t67 * t69 / t21 / t112)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = (0.2217058676663745e1 + 0.6157402568883345e0 * t11) * t14
  t16 = 0.1e1 / jnp.pi
  t17 = t16 ** (0.1e1 / 0.3e1)
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t21 = r0 ** 2
  t22 = r0 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t21
  t30 = t14 ** 2
  t31 = (0.7405551735357053e0 + 0.1574201515892867e0 * t11) * t30
  t32 = t17 ** 2
  t33 = t32 * t18
  t34 = t22 ** 2
  t37 = t33 / t34 / t21
  t42 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t11) * t16
  t43 = t21 * r0
  t44 = 0.1e1 / t43
  t47 = t15 * t20 * t24 / 0.9e1 + 0.5e1 / 0.18e2 * t31 * t37 + 0.3e1 / 0.2e1 * t42 * t44
  t48 = t14 * t17
  t49 = 0.1e1 / t22
  t55 = (0.4504130959426697e1 + 0.2673612973836267e0 * t11) * t30
  t57 = t33 / t34
  t62 = (0.1110667363742916e1 + 0.2052004607777787e0 * t11) * t16
  t63 = 0.1e1 / r0
  t68 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t11) * t14
  t70 = t17 * t16 * t19
  t72 = 0.1e1 / t22 / r0
  t76 = 0.25000000000000000000000000000000000000000000000000e0 * t48 * t19 * t49 + t55 * t57 / 0.4e1 + 0.3e1 / 0.4e1 * t62 * t63 + 0.3e1 / 0.16e2 * t68 * t70 * t72
  t77 = 0.1e1 / t76
  t85 = t33 / t34 / r0
  t88 = 0.1e1 / t21
  t91 = -t15 * t20 * t72 / 0.12e2 - t31 * t85 / 0.6e1 - 0.3e1 / 0.4e1 * t42 * t88
  t92 = t76 ** 2
  t93 = 0.1e1 / t92
  t105 = -0.83333333333333333333333333333333333333333333333333e-1 * t48 * t19 * t72 - t55 * t85 / 0.6e1 - 0.3e1 / 0.4e1 * t62 * t88 - t68 * t70 * t24 / 0.4e1
  t116 = 0.4581652932831429e0 + 0.119086804055547e0 * t11 + t15 * t20 * t49 / 0.4e1 + t31 * t57 / 0.4e1 + 0.3e1 / 0.4e1 * t42 * t63
  t118 = 0.1e1 / t92 / t76
  t120 = t105 ** 2
  t132 = 0.1e1 / t22 / t43
  t136 = 0.11111111111111111111111111111111111111111111111111e0 * t48 * t19 * t24 + 0.5e1 / 0.18e2 * t55 * t37 + 0.3e1 / 0.2e1 * t62 * t44 + 0.7e1 / 0.12e2 * t68 * t70 * t132
  t144 = t33 / t34 / t43
  t147 = t21 ** 2
  t148 = 0.1e1 / t147
  t158 = r0 * t91
  t165 = r0 * t116
  t166 = t92 ** 2
  v3rho3_0_ = -0.3e1 * t47 * t77 + 0.6e1 * t91 * t93 * t105 - 0.6e1 * t116 * t118 * t120 + 0.3e1 * t116 * t93 * t136 - r0 * (-0.7e1 / 0.27e2 * t15 * t20 * t132 - 0.20e2 / 0.27e2 * t31 * t144 - 0.9e1 / 0.2e1 * t42 * t148) * t77 + 0.3e1 * r0 * t47 * t93 * t105 - 0.6e1 * t158 * t118 * t120 + 0.3e1 * t158 * t93 * t136 + 0.6e1 * t165 / t166 * t120 * t105 - 0.6e1 * t165 * t118 * t105 * t136 + t165 * t93 * (-0.25925925925925925925925925925925925925925925925926e0 * t48 * t19 * t132 - 0.20e2 / 0.27e2 * t55 * t144 - 0.9e1 / 0.2e1 * t62 * t148 - 0.35e2 / 0.18e2 * t68 * t70 / t22 / t147)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = (0.2217058676663745e1 + 0.6157402568883345e0 * t11) * t14
  t16 = 0.1e1 / jnp.pi
  t17 = t16 ** (0.1e1 / 0.3e1)
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t21 = r0 ** 2
  t22 = t21 * r0
  t23 = r0 ** (0.1e1 / 0.3e1)
  t25 = 0.1e1 / t23 / t22
  t31 = t14 ** 2
  t32 = (0.7405551735357053e0 + 0.1574201515892867e0 * t11) * t31
  t33 = t17 ** 2
  t34 = t33 * t18
  t35 = t23 ** 2
  t38 = t34 / t35 / t22
  t43 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t11) * t16
  t44 = t21 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.7e1 / 0.27e2 * t15 * t20 * t25 - 0.20e2 / 0.27e2 * t32 * t38 - 0.9e1 / 0.2e1 * t43 * t45
  t49 = t14 * t17
  t50 = 0.1e1 / t23
  t56 = (0.4504130959426697e1 + 0.2673612973836267e0 * t11) * t31
  t58 = t34 / t35
  t63 = (0.1110667363742916e1 + 0.2052004607777787e0 * t11) * t16
  t64 = 0.1e1 / r0
  t69 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t11) * t14
  t71 = t17 * t16 * t19
  t73 = 0.1e1 / t23 / r0
  t77 = 0.25000000000000000000000000000000000000000000000000e0 * t49 * t19 * t50 + t56 * t58 / 0.4e1 + 0.3e1 / 0.4e1 * t63 * t64 + 0.3e1 / 0.16e2 * t69 * t71 * t73
  t78 = 0.1e1 / t77
  t86 = t34 / t35 / r0
  t89 = 0.1e1 / t21
  t92 = -t15 * t20 * t73 / 0.12e2 - t32 * t86 / 0.6e1 - 0.3e1 / 0.4e1 * t43 * t89
  t93 = r0 * t92
  t94 = t77 ** 2
  t96 = 0.1e1 / t94 / t77
  t105 = 0.1e1 / t23 / t21
  t109 = -0.83333333333333333333333333333333333333333333333333e-1 * t49 * t19 * t73 - t56 * t86 / 0.6e1 - 0.3e1 / 0.4e1 * t63 * t89 - t69 * t71 * t105 / 0.4e1
  t110 = t96 * t109
  t116 = t34 / t35 / t21
  t119 = 0.1e1 / t22
  t125 = 0.11111111111111111111111111111111111111111111111111e0 * t49 * t19 * t105 + 0.5e1 / 0.18e2 * t56 * t116 + 0.3e1 / 0.2e1 * t63 * t119 + 0.7e1 / 0.12e2 * t69 * t71 * t25
  t137 = 0.4581652932831429e0 + 0.119086804055547e0 * t11 + t15 * t20 * t50 / 0.4e1 + t32 * t58 / 0.4e1 + 0.3e1 / 0.4e1 * t43 * t64
  t138 = r0 * t137
  t139 = t94 ** 2
  t142 = t109 ** 2
  t143 = t142 ** 2
  t147 = 0.1e1 / t139
  t152 = t125 ** 2
  t164 = 0.1e1 / t23 / t44
  t168 = -0.25925925925925925925925925925925925925925925925926e0 * t49 * t19 * t25 - 0.20e2 / 0.27e2 * t56 * t38 - 0.9e1 / 0.2e1 * t63 * t45 - 0.35e2 / 0.18e2 * t69 * t71 * t164
  t179 = t15 * t20 * t105 / 0.9e1 + 0.5e1 / 0.18e2 * t32 * t116 + 0.3e1 / 0.2e1 * t43 * t119
  t180 = r0 * t179
  t184 = t142 * t109
  t188 = 0.1e1 / t94
  t203 = t34 / t35 / t44
  t206 = t44 * r0
  t207 = 0.1e1 / t206
  v4rho4_0_ = -0.4e1 * t48 * t78 - 0.24e2 * t93 * t110 * t125 - 0.24e2 * t138 / t139 / t77 * t143 + 0.36e2 * t138 * t147 * t142 * t125 - 0.6e1 * t138 * t96 * t152 - 0.8e1 * t138 * t110 * t168 - 0.12e2 * t180 * t96 * t142 + 0.24e2 * t93 * t147 * t184 + 0.12e2 * t179 * t188 * t109 + 0.12e2 * t92 * t188 * t125 + 0.4e1 * t137 * t188 * t168 - r0 * (0.70e2 / 0.81e2 * t15 * t20 * t164 + 0.220e3 / 0.81e2 * t32 * t203 + 0.18e2 * t43 * t207) * t78 - 0.24e2 * t92 * t96 * t142 + 0.24e2 * t137 * t147 * t184 - 0.24e2 * t137 * t96 * t109 * t125 + 0.4e1 * r0 * t48 * t188 * t109 + 0.6e1 * t180 * t188 * t125 + 0.4e1 * t93 * t188 * t168 + t138 * t188 * (0.86419753086419753086419753086419753086419753086420e0 * t49 * t19 * t164 + 0.220e3 / 0.81e2 * t56 * t203 + 0.18e2 * t63 * t207 + 0.455e3 / 0.54e2 * t69 * t71 / t23 / t206)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = t5 ** (0.1e1 / 0.3e1)
  t8 = t2 ** 2
  t9 = 0.1e1 / t8
  t10 = t1 * t9
  t11 = t3 - t10
  t14 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t11)
  t15 = 0.1e1 - t4
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = -t11
  t21 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t18)
  t23 = 2 ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t27 = (t14 + t21) * t26
  t29 = 3 ** (0.1e1 / 0.3e1)
  t30 = t27 * t29
  t31 = 0.1e1 / jnp.pi
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = t32 * t34
  t36 = t2 ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t36
  t38 = t35 * t37
  t41 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t42 = t41 * f.p.zeta_threshold
  t44 = f.my_piecewise3(t6, t42, t7 * t5)
  t46 = f.my_piecewise3(t16, t42, t17 * t15)
  t48 = (t44 + t46 - 0.2e1) * t26
  t51 = (0.2217058676663745e1 + 0.6157402568883345e0 * t48) * t29
  t53 = 0.1e1 / t36 / t2
  t54 = t35 * t53
  t56 = t51 * t54 / 0.12e2
  t57 = t29 ** 2
  t58 = t27 * t57
  t59 = t32 ** 2
  t60 = t59 * t33
  t61 = t36 ** 2
  t63 = t60 / t61
  t64 = t58 * t63
  t68 = (0.7405551735357053e0 + 0.1574201515892867e0 * t48) * t57
  t71 = t60 / t61 / t2
  t73 = t68 * t71 / 0.6e1
  t74 = t31 * t3
  t75 = t27 * t74
  t79 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t48) * t31
  t81 = 0.3e1 / 0.4e1 * t79 * t9
  t82 = 0.119086804055547e0 * t27 + 0.15393506422208362500000000000000000000000000000000e0 * t30 * t38 - t56 + 0.39355037897321675000000000000000000000000000000000e-1 * t64 - t73 + 0.26492524975478677500000000000000000000000000000000e-2 * t75 - t81
  t83 = t29 * t32
  t89 = (0.4504130959426697e1 + 0.2673612973836267e0 * t48) * t57
  t94 = (0.1110667363742916e1 + 0.2052004607777787e0 * t48) * t31
  t99 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t48) * t29
  t101 = t32 * t31 * t34
  t102 = t101 * t53
  t105 = 0.25000000000000000000000000000000000000000000000000e0 * t83 * t34 * t37 + t89 * t63 / 0.4e1 + 0.3e1 / 0.4e1 * t94 * t3 + 0.3e1 / 0.16e2 * t99 * t102
  t106 = 0.1e1 / t105
  t107 = t82 * t106
  t116 = 0.4581652932831429e0 + 0.119086804055547e0 * t48 + t51 * t38 / 0.4e1 + t68 * t63 / 0.4e1 + 0.3e1 / 0.4e1 * t79 * t3
  t117 = t105 ** 2
  t118 = 0.1e1 / t117
  t119 = t116 * t118
  t122 = 0.83333333333333333333333333333333333333333333333333e-1 * t83 * t34 * t53
  t125 = t89 * t71 / 0.6e1
  t128 = 0.3e1 / 0.4e1 * t94 * t9
  t132 = 0.1e1 / t36 / t8
  t133 = t101 * t132
  t135 = t99 * t133 / 0.4e1
  t136 = -t122 + 0.66840324345906675000000000000000000000000000000000e-1 * t64 - t125 + 0.15390034558333402500000000000000000000000000000000e0 * t75 - t128 + 0.78750094606713393750000000000000000000000000000000e-3 * t30 * t102 - t135
  t137 = t119 * t136
  t139 = t7 ** 2
  t140 = 0.1e1 / t139
  t141 = t11 ** 2
  t144 = t8 * t2
  t145 = 0.1e1 / t144
  t146 = t1 * t145
  t148 = -0.2e1 * t9 + 0.2e1 * t146
  t152 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t140 * t141 + 0.4e1 / 0.3e1 * t7 * t148)
  t153 = t17 ** 2
  t154 = 0.1e1 / t153
  t155 = t18 ** 2
  t162 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t154 * t155 - 0.4e1 / 0.3e1 * t17 * t148)
  t164 = (t152 + t162) * t26
  t166 = t164 * t29
  t169 = t30 * t54
  t173 = t51 * t35 * t132 / 0.9e1
  t175 = t164 * t57 * t63
  t177 = t58 * t71
  t181 = t60 / t61 / t8
  t183 = 0.5e1 / 0.18e2 * t68 * t181
  t184 = t164 * t74
  t186 = t31 * t9
  t187 = t27 * t186
  t190 = 0.3e1 / 0.2e1 * t79 * t145
  t194 = t2 * t82
  t195 = t118 * t136
  t198 = t2 * t116
  t200 = 0.1e1 / t117 / t105
  t201 = t136 ** 2
  t207 = 0.11111111111111111111111111111111111111111111111111e0 * t83 * t34 * t132
  t211 = 0.5e1 / 0.18e2 * t89 * t181
  t215 = 0.3e1 / 0.2e1 * t94 * t145
  t218 = t30 * t133
  t224 = 0.7e1 / 0.12e2 * t99 * t101 / t36 / t144
  d11 = -0.2e1 * t107 + 0.2e1 * t137 - t2 * (0.119086804055547e0 * t164 + 0.15393506422208362500000000000000000000000000000000e0 * t166 * t38 - 0.10262337614805575000000000000000000000000000000000e0 * t169 + t173 + 0.39355037897321675000000000000000000000000000000000e-1 * t175 - 0.52473383863095566666666666666666666666666666666666e-1 * t177 + t183 + 0.26492524975478677500000000000000000000000000000000e-2 * t184 - 0.52985049950957355000000000000000000000000000000000e-2 * t187 + t190) * t106 + 0.2e1 * t194 * t195 - 0.2e1 * t198 * t200 * t201 + t198 * t118 * (t207 + 0.66840324345906675000000000000000000000000000000000e-1 * t175 - 0.89120432461208900000000000000000000000000000000000e-1 * t177 + t211 + 0.15390034558333402500000000000000000000000000000000e0 * t184 - 0.30780069116666805000000000000000000000000000000000e0 * t187 + t215 + 0.78750094606713393750000000000000000000000000000000e-3 * t166 * t102 - 0.21000025228456905000000000000000000000000000000000e-2 * t218 + t224)
  t228 = -t3 - t10
  t231 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t228)
  t232 = -t228
  t235 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t232)
  t237 = (t231 + t235) * t26
  t239 = t237 * t29
  t242 = t237 * t57
  t243 = t242 * t63
  t245 = t237 * t74
  t247 = 0.119086804055547e0 * t237 + 0.15393506422208362500000000000000000000000000000000e0 * t239 * t38 - t56 + 0.39355037897321675000000000000000000000000000000000e-1 * t243 - t73 + 0.26492524975478677500000000000000000000000000000000e-2 * t245 - t81
  t248 = t247 * t106
  t256 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t140 * t228 * t11 + 0.8e1 / 0.3e1 * t7 * t1 * t145)
  t264 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t154 * t232 * t18 - 0.8e1 / 0.3e1 * t17 * t1 * t145)
  t266 = (t256 + t264) * t26
  t268 = t266 * t29
  t271 = t239 * t54
  t275 = t266 * t57 * t63
  t277 = t242 * t71
  t280 = t266 * t74
  t282 = t237 * t186
  t285 = 0.119086804055547e0 * t266 + 0.15393506422208362500000000000000000000000000000000e0 * t268 * t38 - 0.51311688074027875000000000000000000000000000000000e-1 * t271 - 0.51311688074027875000000000000000000000000000000000e-1 * t169 + t173 + 0.39355037897321675000000000000000000000000000000000e-1 * t275 - 0.26236691931547783333333333333333333333333333333333e-1 * t277 - 0.26236691931547783333333333333333333333333333333333e-1 * t177 + t183 + 0.26492524975478677500000000000000000000000000000000e-2 * t280 - 0.26492524975478677500000000000000000000000000000000e-2 * t282 - 0.26492524975478677500000000000000000000000000000000e-2 * t187 + t190
  t288 = t2 * t247
  t294 = -t122 + 0.66840324345906675000000000000000000000000000000000e-1 * t243 - t125 + 0.15390034558333402500000000000000000000000000000000e0 * t245 - t128 + 0.78750094606713393750000000000000000000000000000000e-3 * t239 * t102 - t135
  t295 = t119 * t294
  t296 = t118 * t294
  t310 = t239 * t133
  t313 = t207 + 0.66840324345906675000000000000000000000000000000000e-1 * t275 - 0.44560216230604450000000000000000000000000000000000e-1 * t277 - 0.44560216230604450000000000000000000000000000000000e-1 * t177 + t211 + 0.15390034558333402500000000000000000000000000000000e0 * t280 - 0.15390034558333402500000000000000000000000000000000e0 * t282 - 0.15390034558333402500000000000000000000000000000000e0 * t187 + t215 + 0.78750094606713393750000000000000000000000000000000e-3 * t268 * t102 - 0.10500012614228452500000000000000000000000000000000e-2 * t310 - 0.10500012614228452500000000000000000000000000000000e-2 * t218 + t224
  d12 = -0.2e1 * t198 * t200 * t294 * t136 - t2 * t285 * t106 + t198 * t118 * t313 + t194 * t296 + t288 * t195 - t107 + t137 - t248 + t295
  t318 = t228 ** 2
  t322 = 0.2e1 * t9 + 0.2e1 * t146
  t326 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t140 * t318 + 0.4e1 / 0.3e1 * t7 * t322)
  t327 = t232 ** 2
  t334 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t154 * t327 - 0.4e1 / 0.3e1 * t17 * t322)
  t336 = (t326 + t334) * t26
  t338 = t336 * t29
  t343 = t336 * t57 * t63
  t346 = t336 * t74
  t354 = t294 ** 2
  d22 = -0.2e1 * t248 + 0.2e1 * t295 - t2 * (0.119086804055547e0 * t336 + 0.15393506422208362500000000000000000000000000000000e0 * t338 * t38 - 0.10262337614805575000000000000000000000000000000000e0 * t271 + t173 + 0.39355037897321675000000000000000000000000000000000e-1 * t343 - 0.52473383863095566666666666666666666666666666666666e-1 * t277 + t183 + 0.26492524975478677500000000000000000000000000000000e-2 * t346 - 0.52985049950957355000000000000000000000000000000000e-2 * t282 + t190) * t106 + 0.2e1 * t288 * t296 - 0.2e1 * t198 * t200 * t354 + t198 * t118 * (t207 + 0.66840324345906675000000000000000000000000000000000e-1 * t343 - 0.89120432461208900000000000000000000000000000000000e-1 * t277 + t211 + 0.15390034558333402500000000000000000000000000000000e0 * t346 - 0.30780069116666805000000000000000000000000000000000e0 * t282 + t215 + 0.78750094606713393750000000000000000000000000000000e-3 * t338 * t102 - 0.21000025228456905000000000000000000000000000000000e-2 * t310 + t224)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = t5 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = 0.1e1 / t8
  t10 = t2 ** 2
  t11 = 0.1e1 / t10
  t13 = -t1 * t11 + t3
  t14 = t13 ** 2
  t17 = t10 * t2
  t18 = 0.1e1 / t17
  t21 = 0.2e1 * t1 * t18 - 0.2e1 * t11
  t25 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t9 * t14 + 0.4e1 / 0.3e1 * t7 * t21)
  t26 = 0.1e1 - t4
  t27 = t26 <= f.p.zeta_threshold
  t28 = t26 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = 0.1e1 / t29
  t31 = -t13
  t32 = t31 ** 2
  t35 = -t21
  t39 = f.my_piecewise3(t27, 0, 0.4e1 / 0.9e1 * t30 * t32 + 0.4e1 / 0.3e1 * t28 * t35)
  t41 = 2 ** (0.1e1 / 0.3e1)
  t44 = 0.1e1 / (0.2e1 * t41 - 0.2e1)
  t45 = (t25 + t39) * t44
  t47 = 3 ** (0.1e1 / 0.3e1)
  t48 = t45 * t47
  t49 = 0.1e1 / jnp.pi
  t50 = t49 ** (0.1e1 / 0.3e1)
  t51 = 4 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t53 = t50 * t52
  t54 = t2 ** (0.1e1 / 0.3e1)
  t55 = 0.1e1 / t54
  t56 = t53 * t55
  t61 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t13)
  t64 = f.my_piecewise3(t27, 0, 0.4e1 / 0.3e1 * t28 * t31)
  t66 = (t61 + t64) * t44
  t67 = t66 * t47
  t69 = 0.1e1 / t54 / t2
  t70 = t53 * t69
  t73 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t74 = t73 * f.p.zeta_threshold
  t76 = f.my_piecewise3(t6, t74, t7 * t5)
  t78 = f.my_piecewise3(t27, t74, t28 * t26)
  t80 = (t76 + t78 - 0.2e1) * t44
  t83 = (0.2217058676663745e1 + 0.6157402568883345e0 * t80) * t47
  t85 = 0.1e1 / t54 / t10
  t86 = t53 * t85
  t89 = t47 ** 2
  t90 = t45 * t89
  t91 = t50 ** 2
  t92 = t91 * t51
  t93 = t54 ** 2
  t95 = t92 / t93
  t96 = t90 * t95
  t98 = t66 * t89
  t101 = t92 / t93 / t2
  t102 = t98 * t101
  t106 = (0.7405551735357053e0 + 0.1574201515892867e0 * t80) * t89
  t109 = t92 / t93 / t10
  t112 = t49 * t3
  t113 = t45 * t112
  t115 = t49 * t11
  t116 = t66 * t115
  t120 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t80) * t49
  t123 = 0.119086804055547e0 * t45 + 0.15393506422208362500000000000000000000000000000000e0 * t48 * t56 - 0.10262337614805575000000000000000000000000000000000e0 * t67 * t70 + t83 * t86 / 0.9e1 + 0.39355037897321675000000000000000000000000000000000e-1 * t96 - 0.52473383863095566666666666666666666666666666666666e-1 * t102 + 0.5e1 / 0.18e2 * t106 * t109 + 0.26492524975478677500000000000000000000000000000000e-2 * t113 - 0.52985049950957355000000000000000000000000000000000e-2 * t116 + 0.3e1 / 0.2e1 * t120 * t18
  t124 = t47 * t50
  t130 = (0.4504130959426697e1 + 0.2673612973836267e0 * t80) * t89
  t135 = (0.1110667363742916e1 + 0.2052004607777787e0 * t80) * t49
  t140 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t80) * t47
  t142 = t50 * t49 * t52
  t143 = t142 * t69
  t146 = 0.25000000000000000000000000000000000000000000000000e0 * t124 * t52 * t55 + t130 * t95 / 0.4e1 + 0.3e1 / 0.4e1 * t135 * t3 + 0.3e1 / 0.16e2 * t140 * t143
  t147 = 0.1e1 / t146
  t155 = t98 * t95
  t159 = t66 * t112
  t163 = 0.119086804055547e0 * t66 + 0.15393506422208362500000000000000000000000000000000e0 * t67 * t56 - t83 * t70 / 0.12e2 + 0.39355037897321675000000000000000000000000000000000e-1 * t155 - t106 * t101 / 0.6e1 + 0.26492524975478677500000000000000000000000000000000e-2 * t159 - 0.3e1 / 0.4e1 * t120 * t11
  t164 = t146 ** 2
  t165 = 0.1e1 / t164
  t178 = t142 * t85
  t181 = -0.83333333333333333333333333333333333333333333333333e-1 * t124 * t52 * t69 + 0.66840324345906675000000000000000000000000000000000e-1 * t155 - t130 * t101 / 0.6e1 + 0.15390034558333402500000000000000000000000000000000e0 * t159 - 0.3e1 / 0.4e1 * t135 * t11 + 0.78750094606713393750000000000000000000000000000000e-3 * t67 * t143 - t140 * t178 / 0.4e1
  t191 = 0.4581652932831429e0 + 0.119086804055547e0 * t80 + t83 * t56 / 0.4e1 + t106 * t95 / 0.4e1 + 0.3e1 / 0.4e1 * t120 * t3
  t193 = 0.1e1 / t164 / t146
  t195 = t181 ** 2
  t215 = 0.1e1 / t54 / t17
  t216 = t142 * t215
  t219 = 0.11111111111111111111111111111111111111111111111111e0 * t124 * t52 * t85 + 0.66840324345906675000000000000000000000000000000000e-1 * t96 - 0.89120432461208900000000000000000000000000000000000e-1 * t102 + 0.5e1 / 0.18e2 * t130 * t109 + 0.15390034558333402500000000000000000000000000000000e0 * t113 - 0.30780069116666805000000000000000000000000000000000e0 * t116 + 0.3e1 / 0.2e1 * t135 * t18 + 0.78750094606713393750000000000000000000000000000000e-3 * t48 * t143 - 0.21000025228456905000000000000000000000000000000000e-2 * t67 * t178 + 0.7e1 / 0.12e2 * t140 * t216
  t230 = t10 ** 2
  t231 = 0.1e1 / t230
  t234 = -0.6e1 * t1 * t231 + 0.6e1 * t18
  t238 = f.my_piecewise3(t6, 0, -0.8e1 / 0.27e2 / t8 / t5 * t14 * t13 + 0.4e1 / 0.3e1 * t9 * t13 * t21 + 0.4e1 / 0.3e1 * t7 * t234)
  t251 = f.my_piecewise3(t27, 0, -0.8e1 / 0.27e2 / t29 / t26 * t32 * t31 + 0.4e1 / 0.3e1 * t30 * t31 * t35 - 0.4e1 / 0.3e1 * t28 * t234)
  t253 = (t238 + t251) * t44
  t255 = t253 * t47
  t266 = t253 * t89 * t95
  t268 = t90 * t101
  t270 = t98 * t109
  t274 = t92 / t93 / t17
  t277 = t253 * t112
  t279 = t45 * t115
  t282 = t66 * t49 * t18
  t286 = 0.119086804055547e0 * t253 + 0.15393506422208362500000000000000000000000000000000e0 * t255 * t56 - 0.15393506422208362500000000000000000000000000000000e0 * t48 * t70 + 0.20524675229611150000000000000000000000000000000000e0 * t67 * t86 - 0.7e1 / 0.27e2 * t83 * t53 * t215 + 0.39355037897321675000000000000000000000000000000000e-1 * t266 - 0.78710075794643349999999999999999999999999999999999e-1 * t268 + 0.13118345965773891666666666666666666666666666666667e0 * t270 - 0.20e2 / 0.27e2 * t106 * t274 + 0.26492524975478677500000000000000000000000000000000e-2 * t277 - 0.79477574926436032500000000000000000000000000000000e-2 * t279 + 0.15895514985287206500000000000000000000000000000000e-1 * t282 - 0.9e1 / 0.2e1 * t120 * t231
  t293 = t2 * t163
  t300 = t2 * t191
  t301 = t164 ** 2
  t335 = -0.25925925925925925925925925925925925925925925925926e0 * t124 * t52 * t215 + 0.66840324345906675000000000000000000000000000000000e-1 * t266 - 0.13368064869181335000000000000000000000000000000000e0 * t268 + 0.22280108115302225000000000000000000000000000000000e0 * t270 - 0.20e2 / 0.27e2 * t130 * t274 + 0.15390034558333402500000000000000000000000000000000e0 * t277 - 0.46170103675000207500000000000000000000000000000000e0 * t279 + 0.92340207350000415000000000000000000000000000000000e0 * t282 - 0.9e1 / 0.2e1 * t135 * t231 + 0.78750094606713393750000000000000000000000000000000e-3 * t255 * t143 - 0.31500037842685357500000000000000000000000000000000e-2 * t48 * t178 + 0.73500088299599167500000000000000000000000000000000e-2 * t67 * t216 - 0.35e2 / 0.18e2 * t140 * t142 / t54 / t230
  d111 = -0.3e1 * t123 * t147 + 0.6e1 * t163 * t165 * t181 - 0.6e1 * t191 * t193 * t195 + 0.3e1 * t191 * t165 * t219 - t2 * t286 * t147 + 0.3e1 * t2 * t123 * t165 * t181 - 0.6e1 * t293 * t193 * t195 + 0.3e1 * t293 * t165 * t219 + 0.6e1 * t300 / t301 * t195 * t181 - 0.6e1 * t300 * t193 * t181 * t219 + t300 * t165 * t335

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = t5 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t10 = 0.1e1 / t8 / t5
  t11 = t2 ** 2
  t12 = 0.1e1 / t11
  t14 = -t1 * t12 + t3
  t15 = t14 ** 2
  t19 = 0.1e1 / t8
  t20 = t19 * t14
  t21 = t11 * t2
  t22 = 0.1e1 / t21
  t25 = 0.2e1 * t1 * t22 - 0.2e1 * t12
  t28 = t11 ** 2
  t29 = 0.1e1 / t28
  t32 = -0.6e1 * t1 * t29 + 0.6e1 * t22
  t36 = f.my_piecewise3(t6, 0, -0.8e1 / 0.27e2 * t10 * t15 * t14 + 0.4e1 / 0.3e1 * t20 * t25 + 0.4e1 / 0.3e1 * t7 * t32)
  t37 = 0.1e1 - t4
  t38 = t37 <= f.p.zeta_threshold
  t39 = t37 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t37
  t43 = -t14
  t44 = t43 ** 2
  t48 = 0.1e1 / t40
  t49 = t48 * t43
  t50 = -t25
  t53 = -t32
  t57 = f.my_piecewise3(t38, 0, -0.8e1 / 0.27e2 * t42 * t44 * t43 + 0.4e1 / 0.3e1 * t49 * t50 + 0.4e1 / 0.3e1 * t39 * t53)
  t59 = 2 ** (0.1e1 / 0.3e1)
  t62 = 0.1e1 / (0.2e1 * t59 - 0.2e1)
  t63 = (t36 + t57) * t62
  t65 = 3 ** (0.1e1 / 0.3e1)
  t66 = t63 * t65
  t67 = 0.1e1 / jnp.pi
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = 4 ** (0.1e1 / 0.3e1)
  t70 = t69 ** 2
  t71 = t68 * t70
  t72 = t2 ** (0.1e1 / 0.3e1)
  t73 = 0.1e1 / t72
  t74 = t71 * t73
  t82 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t19 * t15 + 0.4e1 / 0.3e1 * t7 * t25)
  t88 = f.my_piecewise3(t38, 0, 0.4e1 / 0.9e1 * t48 * t44 + 0.4e1 / 0.3e1 * t39 * t50)
  t90 = (t82 + t88) * t62
  t91 = t90 * t65
  t93 = 0.1e1 / t72 / t2
  t94 = t71 * t93
  t99 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t14)
  t102 = f.my_piecewise3(t38, 0, 0.4e1 / 0.3e1 * t39 * t43)
  t104 = (t99 + t102) * t62
  t105 = t104 * t65
  t107 = 0.1e1 / t72 / t11
  t108 = t71 * t107
  t111 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t112 = t111 * f.p.zeta_threshold
  t114 = f.my_piecewise3(t6, t112, t7 * t5)
  t116 = f.my_piecewise3(t38, t112, t39 * t37)
  t118 = (t114 + t116 - 0.2e1) * t62
  t121 = (0.2217058676663745e1 + 0.6157402568883345e0 * t118) * t65
  t123 = 0.1e1 / t72 / t21
  t124 = t71 * t123
  t127 = t65 ** 2
  t128 = t63 * t127
  t129 = t68 ** 2
  t130 = t129 * t69
  t131 = t72 ** 2
  t133 = t130 / t131
  t134 = t128 * t133
  t136 = t90 * t127
  t139 = t130 / t131 / t2
  t140 = t136 * t139
  t142 = t104 * t127
  t145 = t130 / t131 / t11
  t146 = t142 * t145
  t150 = (0.7405551735357053e0 + 0.1574201515892867e0 * t118) * t127
  t153 = t130 / t131 / t21
  t156 = t67 * t3
  t157 = t63 * t156
  t159 = t67 * t12
  t160 = t90 * t159
  t162 = t67 * t22
  t163 = t104 * t162
  t167 = (0.1968227878617998e-1 + 0.3532336663397157e-2 * t118) * t67
  t170 = 0.119086804055547e0 * t63 + 0.15393506422208362500000000000000000000000000000000e0 * t66 * t74 - 0.15393506422208362500000000000000000000000000000000e0 * t91 * t94 + 0.20524675229611150000000000000000000000000000000000e0 * t105 * t108 - 0.7e1 / 0.27e2 * t121 * t124 + 0.39355037897321675000000000000000000000000000000000e-1 * t134 - 0.78710075794643349999999999999999999999999999999999e-1 * t140 + 0.13118345965773891666666666666666666666666666666667e0 * t146 - 0.20e2 / 0.27e2 * t150 * t153 + 0.26492524975478677500000000000000000000000000000000e-2 * t157 - 0.79477574926436032500000000000000000000000000000000e-2 * t160 + 0.15895514985287206500000000000000000000000000000000e-1 * t163 - 0.9e1 / 0.2e1 * t167 * t29
  t171 = t65 * t68
  t177 = (0.4504130959426697e1 + 0.2673612973836267e0 * t118) * t127
  t182 = (0.1110667363742916e1 + 0.2052004607777787e0 * t118) * t67
  t187 = (0.2359291751427506e-1 + 0.4200005045691381e-2 * t118) * t65
  t189 = t68 * t67 * t70
  t190 = t189 * t93
  t193 = 0.25000000000000000000000000000000000000000000000000e0 * t171 * t70 * t73 + t177 * t133 / 0.4e1 + 0.3e1 / 0.4e1 * t182 * t3 + 0.3e1 / 0.16e2 * t187 * t190
  t194 = 0.1e1 / t193
  t204 = 0.4581652932831429e0 + 0.119086804055547e0 * t118 + t121 * t74 / 0.4e1 + t150 * t133 / 0.4e1 + 0.3e1 / 0.4e1 * t167 * t3
  t205 = t2 * t204
  t206 = t193 ** 2
  t208 = 0.1e1 / t206 / t193
  t212 = t142 * t133
  t216 = t104 * t156
  t222 = t189 * t107
  t225 = -0.83333333333333333333333333333333333333333333333333e-1 * t171 * t70 * t93 + 0.66840324345906675000000000000000000000000000000000e-1 * t212 - t177 * t139 / 0.6e1 + 0.15390034558333402500000000000000000000000000000000e0 * t216 - 0.3e1 / 0.4e1 * t182 * t12 + 0.78750094606713393750000000000000000000000000000000e-3 * t105 * t190 - t187 * t222 / 0.4e1
  t226 = t208 * t225
  t244 = t189 * t123
  t248 = 0.1e1 / t72 / t28
  t249 = t189 * t248
  t252 = -0.25925925925925925925925925925925925925925925925926e0 * t171 * t70 * t123 + 0.66840324345906675000000000000000000000000000000000e-1 * t134 - 0.13368064869181335000000000000000000000000000000000e0 * t140 + 0.22280108115302225000000000000000000000000000000000e0 * t146 - 0.20e2 / 0.27e2 * t177 * t153 + 0.15390034558333402500000000000000000000000000000000e0 * t157 - 0.46170103675000207500000000000000000000000000000000e0 * t160 + 0.92340207350000415000000000000000000000000000000000e0 * t163 - 0.9e1 / 0.2e1 * t182 * t29 + 0.78750094606713393750000000000000000000000000000000e-3 * t66 * t190 - 0.31500037842685357500000000000000000000000000000000e-2 * t91 * t222 + 0.73500088299599167500000000000000000000000000000000e-2 * t105 * t244 - 0.35e2 / 0.18e2 * t187 * t249
  t256 = t206 ** 2
  t257 = 0.1e1 / t256
  t258 = t225 ** 2
  t263 = t136 * t133
  t265 = t142 * t139
  t269 = t90 * t156
  t271 = t104 * t159
  t281 = 0.11111111111111111111111111111111111111111111111111e0 * t171 * t70 * t107 + 0.66840324345906675000000000000000000000000000000000e-1 * t263 - 0.89120432461208900000000000000000000000000000000000e-1 * t265 + 0.5e1 / 0.18e2 * t177 * t145 + 0.15390034558333402500000000000000000000000000000000e0 * t269 - 0.30780069116666805000000000000000000000000000000000e0 * t271 + 0.3e1 / 0.2e1 * t182 * t22 + 0.78750094606713393750000000000000000000000000000000e-3 * t91 * t190 - 0.21000025228456905000000000000000000000000000000000e-2 * t105 * t222 + 0.7e1 / 0.12e2 * t187 * t244
  t285 = t281 ** 2
  t291 = t258 ** 2
  t306 = 0.119086804055547e0 * t104 + 0.15393506422208362500000000000000000000000000000000e0 * t105 * t74 - t121 * t94 / 0.12e2 + 0.39355037897321675000000000000000000000000000000000e-1 * t212 - t150 * t139 / 0.6e1 + 0.26492524975478677500000000000000000000000000000000e-2 * t216 - 0.3e1 / 0.4e1 * t167 * t12
  t307 = t2 * t306
  t308 = t258 * t225
  t330 = 0.119086804055547e0 * t90 + 0.15393506422208362500000000000000000000000000000000e0 * t91 * t74 - 0.10262337614805575000000000000000000000000000000000e0 * t105 * t94 + t121 * t108 / 0.9e1 + 0.39355037897321675000000000000000000000000000000000e-1 * t263 - 0.52473383863095566666666666666666666666666666666666e-1 * t265 + 0.5e1 / 0.18e2 * t150 * t145 + 0.26492524975478677500000000000000000000000000000000e-2 * t269 - 0.52985049950957355000000000000000000000000000000000e-2 * t271 + 0.3e1 / 0.2e1 * t167 * t22
  t331 = t2 * t330
  t335 = 0.1e1 / t206
  t348 = t5 ** 2
  t351 = t15 ** 2
  t357 = t25 ** 2
  t362 = t28 * t2
  t363 = 0.1e1 / t362
  t366 = 0.24e2 * t1 * t363 - 0.24e2 * t29
  t370 = f.my_piecewise3(t6, 0, 0.40e2 / 0.81e2 / t8 / t348 * t351 - 0.16e2 / 0.9e1 * t10 * t15 * t25 + 0.4e1 / 0.3e1 * t19 * t357 + 0.16e2 / 0.9e1 * t20 * t32 + 0.4e1 / 0.3e1 * t7 * t366)
  t371 = t37 ** 2
  t374 = t44 ** 2
  t380 = t50 ** 2
  t389 = f.my_piecewise3(t38, 0, 0.40e2 / 0.81e2 / t40 / t371 * t374 - 0.16e2 / 0.9e1 * t42 * t44 * t50 + 0.4e1 / 0.3e1 * t48 * t380 + 0.16e2 / 0.9e1 * t49 * t53 - 0.4e1 / 0.3e1 * t39 * t366)
  t391 = (t370 + t389) * t62
  t392 = t391 * t65
  t402 = t130 / t131 / t28
  t408 = t63 * t159
  t410 = t90 * t162
  t413 = t104 * t67 * t29
  t415 = t128 * t139
  t417 = t136 * t145
  t419 = t142 * t153
  t423 = t391 * t156
  t426 = t391 * t127 * t133
  t428 = -0.42000050456913810000000000000000000000000000000000e-2 * t66 * t222 + 0.14700017659919833500000000000000000000000000000000e-1 * t91 * t244 - 0.32666705910932963333333333333333333333333333333333e-1 * t105 * t249 + 0.78750094606713393750000000000000000000000000000000e-3 * t392 * t190 + 0.455e3 / 0.54e2 * t187 * t189 / t72 / t362 + 0.220e3 / 0.81e2 * t177 * t402 + 0.86419753086419753086419753086419753086419753086420e0 * t171 * t70 * t248 - 0.61560138233333610000000000000000000000000000000000e0 * t408 + 0.18468041470000083000000000000000000000000000000000e1 * t410 - 0.36936082940000166000000000000000000000000000000000e1 * t413 - 0.17824086492241780000000000000000000000000000000000e0 * t415 + 0.44560216230604450000000000000000000000000000000000e0 * t417 - 0.79218162187741244444444444444444444444444444444444e0 * t419 + 0.18e2 * t182 * t363 + 0.15390034558333402500000000000000000000000000000000e0 * t423 + 0.66840324345906675000000000000000000000000000000000e-1 * t426
  t478 = 0.119086804055547e0 * t391 - 0.10597009990191471000000000000000000000000000000000e-1 * t408 + 0.31791029970574413000000000000000000000000000000000e-1 * t410 - 0.63582059941148826000000000000000000000000000000000e-1 * t413 + 0.41049350459222300000000000000000000000000000000000e0 * t91 * t108 - 0.63854545158790244444444444444444444444444444444444e0 * t105 * t124 - 0.10494676772619113333333333333333333333333333333333e0 * t415 + 0.26236691931547783333333333333333333333333333333334e0 * t417 - 0.46643007878307170370370370370370370370370370370372e0 * t419 - 0.20524675229611150000000000000000000000000000000000e0 * t66 * t94 + 0.26492524975478677500000000000000000000000000000000e-2 * t423 + 0.18e2 * t167 * t363 + 0.15393506422208362500000000000000000000000000000000e0 * t392 * t74 + 0.70e2 / 0.81e2 * t121 * t71 * t248 + 0.39355037897321675000000000000000000000000000000000e-1 * t426 + 0.220e3 / 0.81e2 * t150 * t402
  d1111 = -0.4e1 * t170 * t194 - 0.8e1 * t205 * t226 * t252 + 0.36e2 * t205 * t257 * t258 * t281 - 0.6e1 * t205 * t208 * t285 - 0.24e2 * t205 / t256 / t193 * t291 + 0.24e2 * t307 * t257 * t308 - 0.24e2 * t307 * t226 * t281 - 0.12e2 * t331 * t208 * t258 + 0.6e1 * t331 * t335 * t281 + 0.4e1 * t307 * t335 * t252 + t205 * t335 * t428 - 0.24e2 * t306 * t208 * t258 + 0.24e2 * t204 * t257 * t308 - 0.24e2 * t204 * t208 * t225 * t281 + 0.4e1 * t2 * t170 * t335 * t225 + 0.12e2 * t330 * t335 * t225 + 0.12e2 * t306 * t335 * t281 + 0.4e1 * t204 * t335 * t252 - t2 * t478 * t194

  res = {'v4rho4': d1111}
  return res
