"""Generated from mgga_c_b88.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.00375 / X_FACTOR_C

  params_gamma = 0.007

  params_omega = 4 / 5

  cab = 0.63

  css = 0.96

  b86_f = lambda x: 1 + params_beta * x ** 2 / (1 + params_gamma * x ** 2) ** params_omega

  b88_css = lambda rs, z, xs, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b88_zss(f, params, css, b86_f, rs, z, xs) ** 4 * (1 - 2 * jnp.log(1 + b88_zss(f, params, css, b86_f, rs, z, xs) / 2) / b88_zss(f, params, css, b86_f, rs, z, xs))

  b88_cab = lambda rs, z, xs0, xs1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) * (b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) - jnp.log(1 + b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1)))

  b88_par = lambda rs, z, xs0, xs1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b88_css(rs, f.z_thr(z), xs0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b88_css(rs, f.z_thr(-z), xs1, ts1))

  b88_c_f = lambda rs, z, xs0, xs1, ts0, ts1: +b88_cab(rs, z, xs0, xs1) + b88_par(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b88_c_f(rs, z, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.00375 / X_FACTOR_C

  params_gamma = 0.007

  params_omega = 4 / 5

  cab = 0.63

  css = 0.96

  b86_f = lambda x: 1 + params_beta * x ** 2 / (1 + params_gamma * x ** 2) ** params_omega

  b88_css = lambda rs, z, xs, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b88_zss(f, params, css, b86_f, rs, z, xs) ** 4 * (1 - 2 * jnp.log(1 + b88_zss(f, params, css, b86_f, rs, z, xs) / 2) / b88_zss(f, params, css, b86_f, rs, z, xs))

  b88_cab = lambda rs, z, xs0, xs1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) * (b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) - jnp.log(1 + b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1)))

  b88_par = lambda rs, z, xs0, xs1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b88_css(rs, f.z_thr(z), xs0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b88_css(rs, f.z_thr(-z), xs1, ts1))

  b88_c_f = lambda rs, z, xs0, xs1, ts0, ts1: +b88_cab(rs, z, xs0, xs1) + b88_par(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b88_c_f(rs, z, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.00375 / X_FACTOR_C

  params_gamma = 0.007

  params_omega = 4 / 5

  cab = 0.63

  css = 0.96

  b86_f = lambda x: 1 + params_beta * x ** 2 / (1 + params_gamma * x ** 2) ** params_omega

  b88_css = lambda rs, z, xs, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b88_zss(f, params, css, b86_f, rs, z, xs) ** 4 * (1 - 2 * jnp.log(1 + b88_zss(f, params, css, b86_f, rs, z, xs) / 2) / b88_zss(f, params, css, b86_f, rs, z, xs))

  b88_cab = lambda rs, z, xs0, xs1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) * (b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) - jnp.log(1 + b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1)))

  b88_par = lambda rs, z, xs0, xs1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b88_css(rs, f.z_thr(z), xs0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b88_css(rs, f.z_thr(-z), xs1, ts1))

  b88_c_f = lambda rs, z, xs0, xs1, ts0, ts1: +b88_cab(rs, z, xs0, xs1) + b88_par(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b88_c_f(rs, z, xs0, xs1, ts0, ts1)

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t8 = 0.20000000000000000000000000000000000000000000000000e0 - 0.20000000000000000000000000000000000000000000000000e0 * t2 * t5
  t9 = t8 * t3
  t10 = r0 <= f.p.dens_threshold
  t11 = 3 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = 0.1e1 / jnp.pi
  t14 = t13 ** (0.1e1 / 0.3e1)
  t16 = t12 / t14
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t16 * t17
  t19 = 2 ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / t3
  t23 = 0.2e1 * r0 * t20 <= f.p.zeta_threshold
  t24 = f.p.zeta_threshold - 0.1e1
  t27 = 0.2e1 * r1 * t20 <= f.p.zeta_threshold
  t28 = -t24
  t29 = t1 * t20
  t30 = f.my_piecewise5(t23, t24, t27, t28, t29)
  t31 = 0.1e1 + t30
  t32 = t31 * t3
  t33 = t32 ** (0.1e1 / 0.3e1)
  t35 = t19 / t33
  t36 = r0 ** 2
  t37 = r0 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = 0.1e1 / t38 / t36
  t41 = s0 * t40
  t43 = 0.1e1 + 0.7e-2 * t41
  t44 = t43 ** (0.1e1 / 0.5e1)
  t45 = t44 ** 2
  t46 = t45 ** 2
  t47 = 0.1e1 / t46
  t51 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t18 * t41 * t47
  t52 = 0.1e1 / t51
  t54 = t18 * t35 * t52
  t56 = f.my_piecewise3(t10, 0, t54 / 0.9e1)
  t57 = 0.63e0 * t56
  t58 = r1 <= f.p.dens_threshold
  t59 = f.my_piecewise5(t27, t24, t23, t28, -t29)
  t60 = 0.1e1 + t59
  t61 = t60 * t3
  t62 = t61 ** (0.1e1 / 0.3e1)
  t64 = t19 / t62
  t65 = r1 ** 2
  t66 = r1 ** (0.1e1 / 0.3e1)
  t67 = t66 ** 2
  t69 = 0.1e1 / t67 / t65
  t70 = s2 * t69
  t72 = 0.1e1 + 0.7e-2 * t70
  t73 = t72 ** (0.1e1 / 0.5e1)
  t74 = t73 ** 2
  t75 = t74 ** 2
  t76 = 0.1e1 / t75
  t80 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t18 * t70 * t76
  t81 = 0.1e1 / t80
  t83 = t18 * t64 * t81
  t85 = f.my_piecewise3(t58, 0, t83 / 0.9e1)
  t86 = 0.63e0 * t85
  t87 = t57 + t86
  t88 = 0.1e1 + t57 + t86
  t89 = jnp.log(t88)
  t90 = t57 + t86 - t89
  t91 = t87 * t90
  t92 = t9 * t91
  t94 = 0.1e1 + t29 <= f.p.zeta_threshold
  t96 = 0.1e1 - t29 <= f.p.zeta_threshold
  t97 = f.my_piecewise5(t94, t24, t96, t28, t29)
  t98 = 0.1e1 + t97
  t99 = t98 ** 2
  t100 = t98 ** (0.1e1 / 0.3e1)
  t101 = t100 ** 2
  t103 = t19 ** 2
  t104 = t101 * t99 * t103
  t105 = t3 ** (0.1e1 / 0.3e1)
  t106 = t105 ** 2
  t107 = t106 * t3
  t109 = 0.1e1 / t38 / r0
  t113 = 0.2e1 * tau0 * t109 - t41 / 0.4e1
  t115 = t107 * t113 * t12
  t116 = t104 * t115
  t119 = 0.1e1 / t14 / t13 * t17
  t121 = 0.1e1 / t33 / t32
  t122 = t51 ** 2
  t123 = t122 ** 2
  t124 = 0.1e1 / t123
  t125 = t121 * t124
  t127 = 0.1e1 + 0.10666666666666666666666666666666666666666666666666e0 * t54
  t128 = jnp.log(t127)
  t129 = t128 * t11
  t130 = t129 * t14
  t131 = t17 ** 2
  t132 = t131 * t103
  t134 = t132 * t33 * t51
  t137 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t130 * t134
  t139 = t119 * t125 * t137
  t142 = f.my_piecewise3(t10, 0, -0.18641351111111111111111111111111111111111111111110e-3 * t116 * t139)
  t143 = f.my_piecewise5(t96, t24, t94, t28, -t29)
  t144 = 0.1e1 + t143
  t145 = t144 ** 2
  t146 = t144 ** (0.1e1 / 0.3e1)
  t147 = t146 ** 2
  t149 = t147 * t145 * t103
  t151 = 0.1e1 / t67 / r1
  t155 = 0.2e1 * tau1 * t151 - t70 / 0.4e1
  t157 = t107 * t155 * t12
  t158 = t149 * t157
  t160 = 0.1e1 / t62 / t61
  t161 = t80 ** 2
  t162 = t161 ** 2
  t163 = 0.1e1 / t162
  t164 = t160 * t163
  t166 = 0.1e1 + 0.10666666666666666666666666666666666666666666666666e0 * t83
  t167 = jnp.log(t166)
  t168 = t167 * t11
  t169 = t168 * t14
  t171 = t132 * t62 * t80
  t174 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t169 * t171
  t176 = t119 * t164 * t174
  t179 = f.my_piecewise3(t58, 0, -0.18641351111111111111111111111111111111111111111110e-3 * t158 * t176)
  t180 = t1 * t5
  t181 = 0.40000000000000000000000000000000000000000000000000e0 * t180
  t185 = 0.40000000000000000000000000000000000000000000000000e0 * t2 / t4 / t3
  t190 = t8 * t87 * t90
  t191 = t19 * t121
  t192 = t20 - t180
  t193 = f.my_piecewise5(t23, 0, t27, 0, t192)
  t195 = t193 * t3 + t30 + 0.1e1
  t198 = t18 * t191 * t52 * t195
  t200 = 0.1e1 / t122
  t204 = s0 / t38 / t36 / r0
  t208 = s0 ** 2
  t209 = t36 ** 2
  t215 = 0.1e1 / t46 / t43
  t219 = -0.22222222222222222222222222222222222222222222222222e-2 * t18 * t204 * t47 + 0.12444444444444444444444444444444444444444444444445e-4 * t18 * t208 / t37 / t209 / t36 * t215
  t222 = t18 * t35 * t200 * t219
  t225 = f.my_piecewise3(t10, 0, -t198 / 0.27e2 - t222 / 0.9e1)
  t226 = 0.63e0 * t225
  t227 = t19 * t160
  t228 = -t192
  t229 = f.my_piecewise5(t27, 0, t23, 0, t228)
  t231 = t229 * t3 + t59 + 0.1e1
  t236 = f.my_piecewise3(t58, 0, -t18 * t227 * t81 * t231 / 0.27e2)
  t237 = 0.63e0 * t236
  t238 = t226 + t237
  t241 = 0.1e1 / t88
  t248 = t101 * t98 * t103 * t115
  t249 = t119 * t121
  t250 = t124 * t137
  t251 = f.my_piecewise5(t94, 0, t96, 0, t192)
  t260 = 0.31068918518518518518518518518518518518518518518517e-3 * t104 * t106 * t113 * t12 * t139
  t270 = t31 ** 2
  t274 = t119 / t33 / t270 / t4
  t281 = 0.1e1 / t123 / t51 * t137
  t289 = 0.1e1 / t127
  t291 = t11 * t14
  t295 = t14 * t131
  t296 = t129 * t295
  t297 = t33 ** 2
  t299 = t103 / t297
  t314 = f.my_piecewise3(t10, 0, -0.49710269629629629629629629629629629629629629629627e-3 * t248 * t249 * t250 * t251 - t260 - 0.18641351111111111111111111111111111111111111111110e-3 * t104 * t107 * (-0.10e2 / 0.3e1 * tau0 * t40 + 0.2e1 / 0.3e1 * t204) * t12 * t139 + 0.24855134814814814814814814814814814814814814814813e-3 * t116 * t274 * t250 * t195 + 0.74565404444444444444444444444444444444444444444440e-3 * t116 * t249 * t281 * t219 - 0.18641351111111111111111111111111111111111111111110e-3 * t116 * t119 * t125 * (-0.39062500000000000000000000000000000000000000000000e0 * (-0.35555555555555555555555555555555555555555555555553e-1 * t198 - 0.10666666666666666666666666666666666666666666666666e0 * t222) * t289 * t291 * t134 - 0.13020833333333333333333333333333333333333333333333e0 * t296 * t299 * t51 * t195 - 0.39062500000000000000000000000000000000000000000000e0 * t130 * t132 * t33 * t219))
  t317 = t147 * t144 * t103 * t157
  t318 = t119 * t160
  t319 = t163 * t174
  t320 = f.my_piecewise5(t96, 0, t94, 0, t228)
  t329 = 0.31068918518518518518518518518518518518518518518517e-3 * t149 * t106 * t155 * t12 * t176
  t330 = t60 ** 2
  t334 = t119 / t62 / t330 / t4
  t341 = 0.1e1 / t166
  t345 = t168 * t295
  t346 = t62 ** 2
  t348 = t103 / t346
  t359 = f.my_piecewise3(t58, 0, -0.49710269629629629629629629629629629629629629629627e-3 * t317 * t318 * t319 * t320 - t329 + 0.24855134814814814814814814814814814814814814814813e-3 * t158 * t334 * t319 * t231 - 0.18641351111111111111111111111111111111111111111110e-3 * t158 * t119 * t164 * (0.33333333333333333333333333333333333333333333333331e0 / t60 * t20 * t231 * t341 - 0.13020833333333333333333333333333333333333333333333e0 * t345 * t348 * t80 * t231))
  vrho_0_ = -t92 + t142 + t179 + t3 * (-(-t181 + t185) * t3 * t91 - t190 - t9 * t238 * t90 - t9 * t87 * (-t238 * t241 + t226 + t237) + t314 + t359)
  t365 = -t20 - t180
  t366 = f.my_piecewise5(t23, 0, t27, 0, t365)
  t368 = t366 * t3 + t30 + 0.1e1
  t373 = f.my_piecewise3(t10, 0, -t18 * t191 * t52 * t368 / 0.27e2)
  t374 = 0.63e0 * t373
  t375 = -t365
  t376 = f.my_piecewise5(t27, 0, t23, 0, t375)
  t378 = t376 * t3 + t59 + 0.1e1
  t381 = t18 * t227 * t81 * t378
  t383 = 0.1e1 / t161
  t387 = s2 / t67 / t65 / r1
  t391 = s2 ** 2
  t392 = t65 ** 2
  t398 = 0.1e1 / t75 / t72
  t402 = -0.22222222222222222222222222222222222222222222222222e-2 * t18 * t387 * t76 + 0.12444444444444444444444444444444444444444444444445e-4 * t18 * t391 / t66 / t392 / t65 * t398
  t405 = t18 * t64 * t383 * t402
  t408 = f.my_piecewise3(t58, 0, -t381 / 0.27e2 - t405 / 0.9e1)
  t409 = 0.63e0 * t408
  t410 = t374 + t409
  t417 = f.my_piecewise5(t94, 0, t96, 0, t365)
  t441 = f.my_piecewise3(t10, 0, -0.49710269629629629629629629629629629629629629629627e-3 * t248 * t249 * t250 * t417 - t260 + 0.24855134814814814814814814814814814814814814814813e-3 * t116 * t274 * t250 * t368 - 0.18641351111111111111111111111111111111111111111110e-3 * t116 * t119 * t125 * (0.33333333333333333333333333333333333333333333333331e0 / t31 * t20 * t368 * t289 - 0.13020833333333333333333333333333333333333333333333e0 * t296 * t299 * t51 * t368))
  t442 = f.my_piecewise5(t96, 0, t94, 0, t375)
  t462 = 0.1e1 / t162 / t80 * t174
  t488 = f.my_piecewise3(t58, 0, -0.49710269629629629629629629629629629629629629629627e-3 * t317 * t318 * t319 * t442 - t329 - 0.18641351111111111111111111111111111111111111111110e-3 * t149 * t107 * (-0.10e2 / 0.3e1 * tau1 * t69 + 0.2e1 / 0.3e1 * t387) * t12 * t176 + 0.24855134814814814814814814814814814814814814814813e-3 * t158 * t334 * t319 * t378 + 0.74565404444444444444444444444444444444444444444440e-3 * t158 * t318 * t462 * t402 - 0.18641351111111111111111111111111111111111111111110e-3 * t158 * t119 * t164 * (-0.39062500000000000000000000000000000000000000000000e0 * (-0.35555555555555555555555555555555555555555555555553e-1 * t381 - 0.10666666666666666666666666666666666666666666666666e0 * t405) * t341 * t291 * t171 - 0.13020833333333333333333333333333333333333333333333e0 * t345 * t348 * t80 * t378 - 0.39062500000000000000000000000000000000000000000000e0 * t169 * t132 * t62 * t402))
  vrho_1_ = -t92 + t142 + t179 + t3 * (-(t181 + t185) * t3 * t91 - t190 - t9 * t410 * t90 - t9 * t87 * (-t410 * t241 + t374 + t409) + t441 + t488)
  t502 = 0.83333333333333333333333333333333333333333333333333e-3 * t16 * t17 * t40 * t47 - 0.46666666666666666666666666666666666666666666666666e-5 * t18 * s0 / t37 / t209 / r0 * t215
  t507 = f.my_piecewise3(t10, 0, -t18 * t35 * t200 * t502 / 0.9e1)
  t539 = f.my_piecewise3(t10, 0, 0.46603377777777777777777777777777777777777777777775e-4 * t104 * t107 * t40 * t12 * t139 + 0.74565404444444444444444444444444444444444444444440e-3 * t116 * t249 * t281 * t502 - 0.18641351111111111111111111111111111111111111111110e-3 * t116 * t119 * t125 * (0.99999999999999999999999999999999999999999999999992e0 * t52 * t502 * t289 - 0.39062500000000000000000000000000000000000000000000e0 * t130 * t132 * t33 * t502))
  vsigma_0_ = t3 * (-0.63e0 * t9 * t507 * t90 - t9 * t87 * (0.63e0 * t507 - 0.63e0 * t507 * t241) + t539)
  vsigma_1_ = 0.0e0
  t552 = 0.83333333333333333333333333333333333333333333333333e-3 * t16 * t17 * t69 * t76 - 0.46666666666666666666666666666666666666666666666666e-5 * t18 * s2 / t66 / t392 / r1 * t398
  t557 = f.my_piecewise3(t58, 0, -t18 * t64 * t383 * t552 / 0.9e1)
  t589 = f.my_piecewise3(t58, 0, 0.46603377777777777777777777777777777777777777777775e-4 * t149 * t107 * t69 * t12 * t176 + 0.74565404444444444444444444444444444444444444444440e-3 * t158 * t318 * t462 * t552 - 0.18641351111111111111111111111111111111111111111110e-3 * t158 * t119 * t164 * (0.99999999999999999999999999999999999999999999999992e0 * t81 * t552 * t341 - 0.39062500000000000000000000000000000000000000000000e0 * t169 * t132 * t62 * t552))
  vsigma_2_ = t3 * (-0.63e0 * t9 * t557 * t90 - t9 * t87 * (0.63e0 * t557 - 0.63e0 * t557 * t241) + t589)
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t596 = f.my_piecewise3(t10, 0, -0.37282702222222222222222222222222222222222222222220e-3 * t104 * t107 * t109 * t12 * t139)
  vtau_0_ = t3 * t596
  t602 = f.my_piecewise3(t58, 0, -0.37282702222222222222222222222222222222222222222220e-3 * t149 * t107 * t151 * t12 * t176)
  vtau_1_ = t3 * t602
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.00375 / X_FACTOR_C

  params_gamma = 0.007

  params_omega = 4 / 5

  cab = 0.63

  css = 0.96

  b86_f = lambda x: 1 + params_beta * x ** 2 / (1 + params_gamma * x ** 2) ** params_omega

  b88_css = lambda rs, z, xs, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b88_zss(f, params, css, b86_f, rs, z, xs) ** 4 * (1 - 2 * jnp.log(1 + b88_zss(f, params, css, b86_f, rs, z, xs) / 2) / b88_zss(f, params, css, b86_f, rs, z, xs))

  b88_cab = lambda rs, z, xs0, xs1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) * (b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1) - jnp.log(1 + b88_zab(f, params, cab, b86_f, rs, z, xs0, xs1)))

  b88_par = lambda rs, z, xs0, xs1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b88_css(rs, f.z_thr(z), xs0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b88_css(rs, f.z_thr(-z), xs1, ts1))

  b88_c_f = lambda rs, z, xs0, xs1, ts0, ts1: +b88_cab(rs, z, xs0, xs1) + b88_par(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b88_c_f(rs, z, xs0, xs1, ts0, ts1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = 0.1e1 / jnp.pi
  t6 = t5 ** (0.1e1 / 0.3e1)
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t4 / t6 * t9
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold - 0.1e1
  t15 = f.my_piecewise5(t12, t13, t12, -t13, 0)
  t16 = 0.1e1 + t15
  t17 = t16 * r0
  t18 = t17 ** (0.1e1 / 0.3e1)
  t20 = t11 / t18
  t21 = t11 ** 2
  t22 = s0 * t21
  t23 = r0 ** 2
  t24 = r0 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = 0.1e1 / t25 / t23
  t28 = t22 * t27
  t30 = 0.1e1 + 0.7e-2 * t28
  t31 = t30 ** (0.1e1 / 0.5e1)
  t32 = t31 ** 2
  t33 = t32 ** 2
  t34 = 0.1e1 / t33
  t39 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t10 * t22 * t27 * t34
  t40 = 0.1e1 / t39
  t42 = t10 * t20 * t40
  t44 = f.my_piecewise3(t2, 0, t42 / 0.9e1)
  t45 = r0 * t44
  t46 = 0.126e1 * t44
  t47 = 0.1e1 + t46
  t48 = jnp.log(t47)
  t49 = t46 - t48
  t52 = t16 ** 2
  t53 = t16 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t55 = t54 * t52
  t56 = t55 * t21
  t57 = t25 * r0
  t58 = tau0 * t21
  t63 = 0.2e1 * t58 / t57 - t28 / 0.4e1
  t65 = t57 * t63 * t4
  t66 = t56 * t65
  t68 = 0.1e1 / t6 / t5
  t69 = t68 * t9
  t71 = 0.1e1 / t18 / t17
  t72 = t39 ** 2
  t73 = t72 ** 2
  t74 = 0.1e1 / t73
  t75 = t71 * t74
  t77 = 0.1e1 + 0.10666666666666666666666666666666666666666666666666e0 * t42
  t78 = jnp.log(t77)
  t79 = t78 * t3
  t80 = t79 * t6
  t81 = t9 ** 2
  t82 = t81 * t21
  t84 = t82 * t18 * t39
  t87 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t80 * t84
  t89 = t69 * t75 * t87
  t92 = f.my_piecewise3(t2, 0, -0.18641351111111111111111111111111111111111111111110e-3 * t66 * t89)
  t99 = t10 * t11 * t71 * t40 * t16
  t101 = 0.1e1 / t72
  t104 = 0.1e1 / t25 / t23 / r0
  t109 = s0 ** 2
  t111 = t23 ** 2
  t116 = 0.1e1 / t33 / t30
  t121 = -0.22222222222222222222222222222222222222222222222222e-2 * t10 * t22 * t104 * t34 + 0.24888888888888888888888888888888888888888888888889e-4 * t10 * t109 * t11 / t24 / t111 / t23 * t116
  t124 = t10 * t20 * t101 * t121
  t127 = f.my_piecewise3(t2, 0, -t99 / 0.27e2 - t124 / 0.9e1)
  t132 = 0.1e1 / t47
  t165 = t69 * t71
  t168 = 0.1e1 / t73 / t39 * t87
  t176 = 0.1e1 / t77
  t184 = t18 ** 2
  t201 = f.my_piecewise3(t2, 0, -0.31068918518518518518518518518518518518518518518517e-3 * t56 * t25 * t63 * t4 * t89 - 0.18641351111111111111111111111111111111111111111110e-3 * t56 * t57 * (-0.10e2 / 0.3e1 * t58 * t27 + 0.2e1 / 0.3e1 * t22 * t104) * t4 * t89 + 0.24855134814814814814814814814814814814814814814813e-3 * t54 * t16 * t21 * t65 * t69 / t18 / t23 * t74 * t87 + 0.74565404444444444444444444444444444444444444444440e-3 * t66 * t165 * t168 * t121 - 0.18641351111111111111111111111111111111111111111110e-3 * t66 * t69 * t75 * (-0.39062500000000000000000000000000000000000000000000e0 * (-0.35555555555555555555555555555555555555555555555553e-1 * t99 - 0.10666666666666666666666666666666666666666666666666e0 * t124) * t176 * t3 * t6 * t84 - 0.13020833333333333333333333333333333333333333333333e0 * t79 * t6 * t81 * t21 / t184 * t39 * t16 - 0.39062500000000000000000000000000000000000000000000e0 * t80 * t82 * t18 * t121))
  vrho_0_ = -0.25200000000000000000000000000000000000000000000000e0 * t45 * t49 + 0.2e1 * t92 + r0 * (-0.25200000000000000000000000000000000000000000000000e0 * t44 * t49 - 0.25200000000000000000000000000000000000000000000000e0 * r0 * t127 * t49 - 0.25200000000000000000000000000000000000000000000000e0 * t45 * (0.126e1 * t127 - 0.126e1 * t127 * t132) + 0.2e1 * t201)
  t217 = 0.83333333333333333333333333333333333333333333333333e-3 * t10 * t21 * t27 * t34 - 0.93333333333333333333333333333333333333333333333333e-5 * t10 * s0 * t11 / t24 / t111 / r0 * t116
  t222 = f.my_piecewise3(t2, 0, -t10 * t20 * t101 * t217 / 0.9e1)
  t232 = t55 * t11
  t255 = f.my_piecewise3(t2, 0, 0.93206755555555555555555555555555555555555555555550e-4 * t232 / r0 * t4 * t89 + 0.74565404444444444444444444444444444444444444444440e-3 * t66 * t165 * t168 * t217 - 0.18641351111111111111111111111111111111111111111110e-3 * t66 * t69 * t75 * (0.99999999999999999999999999999999999999999999999992e0 * t40 * t217 * t176 - 0.39062500000000000000000000000000000000000000000000e0 * t80 * t82 * t18 * t217))
  vsigma_0_ = r0 * (-0.25200000000000000000000000000000000000000000000000e0 * r0 * t222 * t49 - 0.25200000000000000000000000000000000000000000000000e0 * t45 * (0.126e1 * t222 - 0.126e1 * t222 * t132) + 0.2e1 * t255)
  vlapl_0_ = 0.0e0
  t265 = f.my_piecewise3(t2, 0, -0.74565404444444444444444444444444444444444444444440e-3 * t232 * t4 * t68 * t9 * t71 * t74 * t87)
  vtau_0_ = 0.2e1 * r0 * t265
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = 0.1e1 / jnp.pi
  t6 = t5 ** (0.1e1 / 0.3e1)
  t8 = t4 / t6
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t8 * t9
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold - 0.1e1
  t15 = f.my_piecewise5(t12, t13, t12, -t13, 0)
  t16 = 0.1e1 + t15
  t17 = t16 * r0
  t18 = t17 ** (0.1e1 / 0.3e1)
  t20 = t11 / t18
  t21 = t11 ** 2
  t22 = s0 * t21
  t23 = r0 ** 2
  t24 = r0 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = 0.1e1 / t25 / t23
  t28 = t22 * t27
  t30 = 0.1e1 + 0.7e-2 * t28
  t31 = t30 ** (0.1e1 / 0.5e1)
  t32 = t31 ** 2
  t33 = t32 ** 2
  t34 = 0.1e1 / t33
  t39 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t10 * t22 * t27 * t34
  t40 = 0.1e1 / t39
  t42 = t10 * t20 * t40
  t44 = f.my_piecewise3(t2, 0, t42 / 0.9e1)
  t45 = 0.126e1 * t44
  t46 = 0.1e1 + t45
  t47 = jnp.log(t46)
  t48 = t45 - t47
  t52 = 0.1e1 / t18 / t17
  t56 = t10 * t11 * t52 * t40 * t16
  t58 = t39 ** 2
  t59 = 0.1e1 / t58
  t60 = t23 * r0
  t62 = 0.1e1 / t25 / t60
  t67 = s0 ** 2
  t68 = t67 * t11
  t69 = t23 ** 2
  t74 = 0.1e1 / t33 / t30
  t79 = -0.22222222222222222222222222222222222222222222222222e-2 * t10 * t22 * t62 * t34 + 0.24888888888888888888888888888888888888888888888889e-4 * t10 * t68 / t24 / t69 / t23 * t74
  t82 = t10 * t20 * t59 * t79
  t85 = f.my_piecewise3(t2, 0, -t56 / 0.27e2 - t82 / 0.9e1)
  t86 = r0 * t85
  t89 = r0 * t44
  t91 = 0.1e1 / t46
  t94 = 0.126e1 * t85 - 0.126e1 * t85 * t91
  t97 = t16 ** 2
  t98 = t16 ** (0.1e1 / 0.3e1)
  t99 = t98 ** 2
  t101 = t99 * t97 * t21
  t102 = tau0 * t21
  t103 = t25 * r0
  t108 = 0.2e1 * t102 / t103 - t28 / 0.4e1
  t110 = t25 * t108 * t4
  t111 = t101 * t110
  t114 = 0.1e1 / t6 / t5 * t9
  t115 = t58 ** 2
  t116 = 0.1e1 / t115
  t117 = t52 * t116
  t119 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t42
  t120 = jnp.log(t119)
  t121 = t120 * t3
  t122 = t121 * t6
  t123 = t9 ** 2
  t124 = t123 * t21
  t126 = t124 * t18 * t39
  t129 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t122 * t126
  t131 = t114 * t117 * t129
  t138 = -0.10e2 / 0.3e1 * t102 * t27 + 0.2e1 / 0.3e1 * t22 * t62
  t140 = t103 * t138 * t4
  t141 = t101 * t140
  t144 = t97 * t16
  t146 = t99 * t144 * t21
  t148 = t103 * t108 * t4
  t149 = t146 * t148
  t152 = 0.1e1 / t18 / t97 / t23
  t153 = t152 * t116
  t155 = t114 * t153 * t129
  t158 = t101 * t148
  t159 = t114 * t52
  t161 = 0.1e1 / t115 / t39
  t162 = t161 * t129
  t163 = t162 * t79
  t164 = t159 * t163
  t169 = -0.35555555555555555555555555555555555555555555555557e-1 * t56 - 0.10666666666666666666666666666666666666666666666667e0 * t82
  t170 = 0.1e1 / t119
  t172 = t3 * t6
  t173 = t169 * t170 * t172
  t177 = t121 * t6 * t123
  t178 = t18 ** 2
  t179 = 0.1e1 / t178
  t180 = t21 * t179
  t186 = t124 * t18 * t79
  t189 = -0.39062500000000000000000000000000000000000000000000e0 * t173 * t126 - 0.13020833333333333333333333333333333333333333333333e0 * t177 * t180 * t39 * t16 - 0.39062500000000000000000000000000000000000000000000e0 * t122 * t186
  t191 = t114 * t117 * t189
  t195 = f.my_piecewise3(t2, 0, -0.31068918518518518518518518518518518518518518518523e-3 * t111 * t131 - 0.18641351111111111111111111111111111111111111111114e-3 * t141 * t131 + 0.24855134814814814814814814814814814814814814814819e-3 * t149 * t155 + 0.74565404444444444444444444444444444444444444444456e-3 * t158 * t164 - 0.18641351111111111111111111111111111111111111111114e-3 * t158 * t191)
  t204 = t10 * t11 * t152 * t40 * t97
  t209 = t16 * t79
  t211 = t8 * t9 * t11 * t52 * t59 * t209
  t215 = t79 ** 2
  t218 = t10 * t20 / t58 / t39 * t215
  t221 = 0.1e1 / t25 / t69
  t234 = t69 ** 2
  t238 = t30 ** 2
  t244 = 0.81481481481481481481481481481481481481481481481481e-2 * t10 * t22 * t221 * t34 - 0.22400000000000000000000000000000000000000000000000e-3 * t10 * t68 / t24 / t69 / t60 * t74 + 0.16725333333333333333333333333333333333333333333334e-5 * t10 * t67 * s0 / t234 / t23 / t33 / t238
  t247 = t10 * t20 * t59 * t244
  t250 = f.my_piecewise3(t2, 0, 0.4e1 / 0.81e2 * t204 + 0.2e1 / 0.27e2 * t211 + 0.2e1 / 0.9e1 * t218 - t247 / 0.9e1)
  t259 = t85 ** 2
  t260 = t46 ** 2
  t287 = t169 ** 2
  t288 = t119 ** 2
  t320 = t97 ** 2
  t380 = -0.37282702222222222222222222222222222222222222222228e-2 * t158 * t159 / t115 / t58 * t129 * t215 + 0.49710269629629629629629629629629629629629629629638e-3 * t149 * t114 * t153 * t189 - 0.18641351111111111111111111111111111111111111111114e-3 * t158 * t114 * t117 * (-0.39062500000000000000000000000000000000000000000000e0 * (0.47407407407407407407407407407407407407407407407409e-1 * t204 + 0.71111111111111111111111111111111111111111111111114e-1 * t211 + 0.21333333333333333333333333333333333333333333333334e0 * t218 - 0.10666666666666666666666666666666666666666666666667e0 * t247) * t170 * t172 * t126 + 0.39062500000000000000000000000000000000000000000000e0 * t287 / t288 * t172 * t126 - 0.26041666666666666666666666666666666666666666666666e0 * t173 * t124 * t179 * t39 * t16 - 0.78125000000000000000000000000000000000000000000000e0 * t173 * t186 + 0.86805555555555555555555555555555555555555555555553e-1 * t177 * t21 / t178 / t17 * t39 * t97 - 0.26041666666666666666666666666666666666666666666666e0 * t177 * t180 * t209 - 0.39062500000000000000000000000000000000000000000000e0 * t122 * t124 * t18 * t244) - 0.57995314567901234567901234567901234567901234567911e-3 * t99 * t320 * t21 * t148 * t114 / t18 / t144 / t60 * t116 * t129 - 0.19884107851851851851851851851851851851851851851855e-2 * t149 * t114 * t152 * t163 + 0.14913080888888888888888888888888888888888888888891e-2 * t158 * t159 * t161 * t189 * t79 + 0.74565404444444444444444444444444444444444444444456e-3 * t158 * t159 * t162 * t244 + 0.82850449382716049382716049382716049382716049382729e-3 * t146 * t110 * t155 + 0.24855134814814814814814814814814814814814814814818e-2 * t111 * t164 + 0.49710269629629629629629629629629629629629629629638e-3 * t146 * t140 * t155 + 0.14913080888888888888888888888888888888888888888891e-2 * t141 * t164 - 0.20712612345679012345679012345679012345679012345682e-3 * t101 / t24 * t108 * t4 * t131 - 0.62137837037037037037037037037037037037037037037046e-3 * t101 * t25 * t138 * t4 * t131 - 0.62137837037037037037037037037037037037037037037046e-3 * t111 * t191 - 0.18641351111111111111111111111111111111111111111114e-3 * t101 * t103 * (0.80e2 / 0.9e1 * t102 * t62 - 0.22e2 / 0.9e1 * t22 * t221) * t4 * t131 - 0.37282702222222222222222222222222222222222222222228e-3 * t141 * t191
  t381 = f.my_piecewise3(t2, 0, t380)
  v2rho2_0_ = -0.50400000000000000000000000000000000000000000000000e0 * t44 * t48 - 0.50400000000000000000000000000000000000000000000000e0 * t86 * t48 - 0.50400000000000000000000000000000000000000000000000e0 * t89 * t94 + 0.4e1 * t195 + r0 * (-0.50400000000000000000000000000000000000000000000000e0 * t85 * t48 - 0.50400000000000000000000000000000000000000000000000e0 * t44 * t94 - 0.25200000000000000000000000000000000000000000000000e0 * r0 * t250 * t48 - 0.50400000000000000000000000000000000000000000000000e0 * t86 * t94 - 0.25200000000000000000000000000000000000000000000000e0 * t89 * (0.126e1 * t250 - 0.126e1 * t250 * t91 + 0.15876e1 * t259 / t260) + 0.2e1 * t381)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = 0.1e1 / jnp.pi
  t6 = t5 ** (0.1e1 / 0.3e1)
  t8 = t4 / t6
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t8 * t9
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold - 0.1e1
  t15 = f.my_piecewise5(t12, t13, t12, -t13, 0)
  t16 = 0.1e1 + t15
  t17 = t16 * r0
  t18 = t17 ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / t18 / t17
  t22 = t11 ** 2
  t23 = s0 * t22
  t24 = r0 ** 2
  t25 = r0 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = 0.1e1 / t26 / t24
  t29 = t23 * t28
  t31 = 0.1e1 + 0.7e-2 * t29
  t32 = t31 ** (0.1e1 / 0.5e1)
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = 0.1e1 / t34
  t40 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t10 * t23 * t28 * t35
  t41 = 0.1e1 / t40
  t44 = t10 * t11 * t20 * t41 * t16
  t46 = 0.1e1 / t18
  t47 = t11 * t46
  t48 = t40 ** 2
  t49 = 0.1e1 / t48
  t50 = t24 * r0
  t52 = 0.1e1 / t26 / t50
  t57 = s0 ** 2
  t58 = t57 * t11
  t59 = t24 ** 2
  t64 = 0.1e1 / t34 / t31
  t69 = -0.22222222222222222222222222222222222222222222222222e-2 * t10 * t23 * t52 * t35 + 0.24888888888888888888888888888888888888888888888889e-4 * t10 * t58 / t25 / t59 / t24 * t64
  t72 = t10 * t47 * t49 * t69
  t75 = f.my_piecewise3(t2, 0, -t44 / 0.27e2 - t72 / 0.9e1)
  t77 = t10 * t47 * t41
  t79 = f.my_piecewise3(t2, 0, t77 / 0.9e1)
  t80 = 0.126e1 * t79
  t81 = 0.1e1 + t80
  t82 = jnp.log(t81)
  t83 = t80 - t82
  t87 = 0.1e1 / t81
  t90 = 0.126e1 * t75 - 0.126e1 * t75 * t87
  t93 = t16 ** 2
  t94 = t93 * t24
  t96 = 0.1e1 / t18 / t94
  t100 = t10 * t11 * t96 * t41 * t93
  t103 = t8 * t9 * t11
  t104 = t20 * t49
  t105 = t16 * t69
  t107 = t103 * t104 * t105
  t109 = t48 * t40
  t110 = 0.1e1 / t109
  t111 = t69 ** 2
  t114 = t10 * t47 * t110 * t111
  t117 = 0.1e1 / t26 / t59
  t129 = t57 * s0
  t130 = t59 ** 2
  t134 = t31 ** 2
  t136 = 0.1e1 / t34 / t134
  t140 = 0.81481481481481481481481481481481481481481481481481e-2 * t10 * t23 * t117 * t35 - 0.22400000000000000000000000000000000000000000000000e-3 * t10 * t58 / t25 / t59 / t50 * t64 + 0.16725333333333333333333333333333333333333333333334e-5 * t10 * t129 / t130 / t24 * t136
  t143 = t10 * t47 * t49 * t140
  t146 = f.my_piecewise3(t2, 0, 0.4e1 / 0.81e2 * t100 + 0.2e1 / 0.27e2 * t107 + 0.2e1 / 0.9e1 * t114 - t143 / 0.9e1)
  t147 = r0 * t146
  t150 = r0 * t75
  t153 = r0 * t79
  t157 = t75 ** 2
  t158 = t81 ** 2
  t159 = 0.1e1 / t158
  t162 = 0.126e1 * t146 - 0.126e1 * t146 * t87 + 0.15876e1 * t157 * t159
  t165 = t16 ** (0.1e1 / 0.3e1)
  t166 = t165 ** 2
  t168 = t166 * t93 * t22
  t169 = t26 * r0
  t170 = tau0 * t22
  t175 = 0.2e1 * t170 / t169 - t29 / 0.4e1
  t177 = t169 * t175 * t4
  t178 = t168 * t177
  t180 = 0.1e1 / t6 / t5
  t181 = t180 * t9
  t182 = t181 * t20
  t183 = t48 ** 2
  t185 = 0.1e1 / t183 / t48
  t187 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t77
  t188 = jnp.log(t187)
  t189 = t188 * t3
  t190 = t189 * t6
  t191 = t9 ** 2
  t192 = t191 * t22
  t193 = t18 * t40
  t194 = t192 * t193
  t197 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t190 * t194
  t199 = t185 * t197 * t111
  t200 = t182 * t199
  t203 = t93 * t16
  t205 = t166 * t203 * t22
  t206 = t205 * t177
  t207 = 0.1e1 / t183
  t208 = t96 * t207
  t211 = -0.35555555555555555555555555555555555555555555555557e-1 * t44 - 0.10666666666666666666666666666666666666666666666667e0 * t72
  t212 = 0.1e1 / t187
  t214 = t3 * t6
  t215 = t211 * t212 * t214
  t219 = t189 * t6 * t191
  t220 = t18 ** 2
  t221 = 0.1e1 / t220
  t222 = t22 * t221
  t228 = t192 * t18 * t69
  t231 = -0.39062500000000000000000000000000000000000000000000e0 * t215 * t194 - 0.13020833333333333333333333333333333333333333333333e0 * t219 * t222 * t40 * t16 - 0.39062500000000000000000000000000000000000000000000e0 * t190 * t228
  t233 = t181 * t208 * t231
  t236 = t20 * t207
  t241 = 0.47407407407407407407407407407407407407407407407409e-1 * t100 + 0.71111111111111111111111111111111111111111111111114e-1 * t107 + 0.21333333333333333333333333333333333333333333333334e0 * t114 - 0.10666666666666666666666666666666666666666666666667e0 * t143
  t243 = t241 * t212 * t214
  t246 = t211 ** 2
  t247 = t187 ** 2
  t248 = 0.1e1 / t247
  t250 = t246 * t248 * t214
  t255 = t192 * t221 * t40 * t16
  t261 = 0.1e1 / t220 / t17
  t262 = t22 * t261
  t271 = t192 * t18 * t140
  t274 = -0.39062500000000000000000000000000000000000000000000e0 * t243 * t194 + 0.39062500000000000000000000000000000000000000000000e0 * t250 * t194 - 0.26041666666666666666666666666666666666666666666666e0 * t215 * t255 - 0.78125000000000000000000000000000000000000000000000e0 * t215 * t228 + 0.86805555555555555555555555555555555555555555555553e-1 * t219 * t262 * t40 * t93 - 0.26041666666666666666666666666666666666666666666666e0 * t219 * t222 * t105 - 0.39062500000000000000000000000000000000000000000000e0 * t190 * t271
  t276 = t181 * t236 * t274
  t279 = t93 ** 2
  t281 = t166 * t279 * t22
  t282 = t281 * t177
  t285 = 0.1e1 / t18 / t203 / t50
  t286 = t285 * t207
  t288 = t181 * t286 * t197
  t291 = t181 * t96
  t293 = 0.1e1 / t183 / t40
  t294 = t293 * t197
  t295 = t294 * t69
  t296 = t291 * t295
  t299 = t293 * t231
  t300 = t299 * t69
  t301 = t182 * t300
  t304 = t294 * t140
  t305 = t182 * t304
  t309 = t26 * t175 * t4
  t310 = t205 * t309
  t312 = t181 * t208 * t197
  t315 = t168 * t309
  t316 = t182 * t295
  t323 = -0.10e2 / 0.3e1 * t170 * t28 + 0.2e1 / 0.3e1 * t23 * t52
  t325 = t169 * t323 * t4
  t326 = t205 * t325
  t329 = t168 * t325
  t332 = 0.1e1 / t25
  t334 = t332 * t175 * t4
  t335 = t168 * t334
  t337 = t181 * t236 * t197
  t341 = t26 * t323 * t4
  t342 = t168 * t341
  t346 = t181 * t236 * t231
  t353 = 0.80e2 / 0.9e1 * t170 * t52 - 0.22e2 / 0.9e1 * t23 * t117
  t355 = t169 * t353 * t4
  t356 = t168 * t355
  t361 = -0.37282702222222222222222222222222222222222222222228e-2 * t178 * t200 + 0.49710269629629629629629629629629629629629629629638e-3 * t206 * t233 - 0.18641351111111111111111111111111111111111111111114e-3 * t178 * t276 - 0.57995314567901234567901234567901234567901234567911e-3 * t282 * t288 - 0.19884107851851851851851851851851851851851851851855e-2 * t206 * t296 + 0.14913080888888888888888888888888888888888888888891e-2 * t178 * t301 + 0.74565404444444444444444444444444444444444444444456e-3 * t178 * t305 + 0.82850449382716049382716049382716049382716049382729e-3 * t310 * t312 + 0.24855134814814814814814814814814814814814814814818e-2 * t315 * t316 + 0.49710269629629629629629629629629629629629629629638e-3 * t326 * t312 + 0.14913080888888888888888888888888888888888888888891e-2 * t329 * t316 - 0.20712612345679012345679012345679012345679012345682e-3 * t335 * t337 - 0.62137837037037037037037037037037037037037037037046e-3 * t342 * t337 - 0.62137837037037037037037037037037037037037037037046e-3 * t315 * t346 - 0.18641351111111111111111111111111111111111111111114e-3 * t356 * t337 - 0.37282702222222222222222222222222222222222222222228e-3 * t329 * t346
  t362 = f.my_piecewise3(t2, 0, t361)
  t373 = t10 * t11 * t285 * t41 * t203
  t376 = t93 * t69
  t378 = t103 * t96 * t49 * t376
  t383 = t103 * t20 * t110 * t16 * t111
  t385 = t16 * t140
  t387 = t103 * t104 * t385
  t389 = t111 * t69
  t392 = t10 * t47 * t207 * t389
  t397 = t103 * t46 * t110 * t69 * t140
  t399 = t59 * r0
  t401 = 0.1e1 / t26 / t399
  t418 = t57 ** 2
  t430 = -0.38024691358024691358024691358024691358024691358024e-1 * t10 * t23 * t401 * t35 + 0.18860246913580246913580246913580246913580246913581e-2 * t10 * t58 / t25 / t130 * t64 - 0.31778133333333333333333333333333333333333333333334e-4 * t10 * t129 / t130 / t50 * t136 + 0.87417742222222222222222222222222222222222222222228e-7 * t10 * t418 / t26 / t130 / t399 / t34 / t134 / t31 * t22
  t433 = t10 * t47 * t49 * t430
  t436 = f.my_piecewise3(t2, 0, -0.28e2 / 0.243e3 * t373 - 0.4e1 / 0.27e2 * t378 - 0.2e1 / 0.9e1 * t383 + t387 / 0.9e1 - 0.2e1 / 0.3e1 * t392 + 0.2e1 / 0.3e1 * t397 - t433 / 0.9e1)
  t518 = -0.29826161777777777777777777777777777777777777777782e-2 * t206 * t291 * t304 + 0.44739242666666666666666666666666666666666666666673e-2 * t329 * t301 + 0.69594377481481481481481481481481481481481481481492e-2 * t282 * t181 * t285 * t295 + 0.22369621333333333333333333333333333333333333333337e-2 * t178 * t182 * t293 * t274 * t69 - 0.59652323555555555555555555555555555555555555555565e-2 * t206 * t291 * t300 - 0.11184810666666666666666666666666666666666666666668e-1 * t329 * t200 - 0.11184810666666666666666666666666666666666666666668e-1 * t178 * t182 * t185 * t231 * t111 + 0.37282702222222222222222222222222222222222222222227e-2 * t315 * t305 + 0.24855134814814814814814814814814814814814814814818e-2 * t335 * t316 - 0.99420539259259259259259259259259259259259259259275e-2 * t310 * t296 + 0.74565404444444444444444444444444444444444444444454e-2 * t315 * t301 - 0.18641351111111111111111111111111111111111111111114e-1 * t315 * t200 + 0.14913080888888888888888888888888888888888888888891e-1 * t206 * t291 * t199 + 0.22369621333333333333333333333333333333333333333337e-1 * t178 * t182 / t183 / t109 * t197 * t389 + 0.22369621333333333333333333333333333333333333333337e-2 * t356 * t316 + 0.74565404444444444444444444444444444444444444444454e-2 * t342 * t316 + 0.22369621333333333333333333333333333333333333333337e-2 * t178 * t182 * t299 * t140 + 0.22369621333333333333333333333333333333333333333337e-2 * t329 * t305 + 0.74565404444444444444444444444444444444444444444456e-3 * t178 * t182 * t294 * t430 - 0.59652323555555555555555555555555555555555555555565e-2 * t326 * t296
  t600 = -0.39062499999999999999999999999999999999999999999999e0 * t219 * t222 * t385 + 0.26041666666666666666666666666666666666666666666666e0 * t219 * t262 * t376 - 0.14467592592592592592592592592592592592592592592592e0 * t219 * t22 / t220 / t94 * t40 * t203 - 0.78124999999999999999999999999999999999999999999999e0 * t215 * t192 * t221 * t69 * t16 - 0.78125000000000000000000000000000000000000000000000e0 * t246 * t211 / t247 / t187 * t214 * t194 + 0.39062499999999999999999999999999999999999999999999e0 * t250 * t255 - 0.39062499999999999999999999999999999999999999999999e0 * t243 * t255 + 0.11718750000000000000000000000000000000000000000000e1 * t241 * t248 * t214 * t192 * t193 * t211 - 0.39062500000000000000000000000000000000000000000000e0 * t190 * t192 * t18 * t430 - 0.11718750000000000000000000000000000000000000000000e1 * t215 * t271 + 0.11718750000000000000000000000000000000000000000000e1 * t250 * t228 - 0.11718750000000000000000000000000000000000000000000e1 * t243 * t228 - 0.39062500000000000000000000000000000000000000000000e0 * (-0.11061728395061728395061728395061728395061728395062e0 * t373 - 0.14222222222222222222222222222222222222222222222223e0 * t378 - 0.21333333333333333333333333333333333333333333333334e0 * t383 + 0.10666666666666666666666666666666666666666666666667e0 * t387 - 0.64000000000000000000000000000000000000000000000002e0 * t392 + 0.64000000000000000000000000000000000000000000000002e0 * t397 - 0.10666666666666666666666666666666666666666666666667e0 * t433) * t212 * t214 * t194 + 0.26041666666666666666666666666666666666666666666666e0 * t215 * t192 * t261 * t40 * t93
  t674 = 0.24855134814814814814814814814814814814814814814819e-2 * t310 * t233 - 0.17398594370370370370370370370370370370370370370373e-2 * t282 * t181 * t286 * t231 - 0.18641351111111111111111111111111111111111111111114e-3 * t168 * t169 * (-0.880e3 / 0.27e2 * t170 * t117 + 0.308e3 / 0.27e2 * t23 * t401) * t4 * t337 - 0.55924053333333333333333333333333333333333333333342e-3 * t356 * t346 + 0.24855134814814814814814814814814814814814814814819e-2 * t205 * t341 * t312 + 0.74565404444444444444444444444444444444444444444457e-3 * t205 * t355 * t312 - 0.62137837037037037037037037037037037037037037037046e-3 * t168 * t332 * t323 * t4 * t337 - 0.62137837037037037037037037037037037037037037037046e-3 * t335 * t346 - 0.93206755555555555555555555555555555555555555555569e-3 * t168 * t26 * t353 * t4 * t337 - 0.18641351111111111111111111111111111111111111111114e-2 * t342 * t346 - 0.17398594370370370370370370370370370370370370370373e-2 * t281 * t325 * t288
  t677 = f.my_piecewise3(t2, 0, t518 - 0.11184810666666666666666666666666666666666666666668e-1 * t168 * t169 * t175 * t4 * t180 * t9 * t20 * t185 * t197 * t69 * t140 + 0.14913080888888888888888888888888888888888888888891e-2 * t326 * t233 + 0.74565404444444444444444444444444444444444444444457e-3 * t206 * t181 * t208 * t274 - 0.55924053333333333333333333333333333333333333333342e-3 * t329 * t276 - 0.18641351111111111111111111111111111111111111111114e-3 * t178 * t181 * t236 * t600 + 0.69042041152263374485596707818930041152263374485607e-4 * t168 / t25 / r0 * t175 * t4 * t337 + 0.82850449382716049382716049382716049382716049382729e-3 * t205 * t334 * t312 - 0.28997657283950617283950617283950617283950617283955e-2 * t281 * t309 * t288 + 0.19331771522633744855967078189300411522633744855970e-2 * t166 * t16 * t22 * t177 * t181 / t18 / t59 * t207 * t197 - 0.93206755555555555555555555555555555555555555555569e-3 * t315 * t276 + t674)
  v3rho3_0_ = -0.15120000000000000000000000000000000000000000000000e1 * t75 * t83 - 0.15120000000000000000000000000000000000000000000000e1 * t79 * t90 - 0.75600000000000000000000000000000000000000000000000e0 * t147 * t83 - 0.15120000000000000000000000000000000000000000000000e1 * t150 * t90 - 0.75600000000000000000000000000000000000000000000000e0 * t153 * t162 + 0.6e1 * t362 + r0 * (-0.75600000000000000000000000000000000000000000000000e0 * t146 * t83 - 0.15120000000000000000000000000000000000000000000000e1 * t75 * t90 - 0.75600000000000000000000000000000000000000000000000e0 * t79 * t162 - 0.25200000000000000000000000000000000000000000000000e0 * r0 * t436 * t83 - 0.75600000000000000000000000000000000000000000000000e0 * t147 * t90 - 0.75600000000000000000000000000000000000000000000000e0 * t150 * t162 - 0.25200000000000000000000000000000000000000000000000e0 * t153 * (0.126e1 * t436 - 0.126e1 * t436 * t87 + 0.47628e1 * t146 * t159 * t75 - 0.4000752e1 * t157 * t75 / t158 / t81) + 0.2e1 * t677)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = 0.1e1 / jnp.pi
  t6 = t5 ** (0.1e1 / 0.3e1)
  t8 = t4 / t6
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t8 * t9
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold - 0.1e1
  t15 = f.my_piecewise5(t12, t13, t12, -t13, 0)
  t16 = 0.1e1 + t15
  t17 = t16 ** 2
  t18 = r0 ** 2
  t19 = t17 * t18
  t20 = t16 * r0
  t21 = t20 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t21 / t19
  t25 = t11 ** 2
  t26 = s0 * t25
  t27 = r0 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t30 = 0.1e1 / t28 / t18
  t31 = t26 * t30
  t33 = 0.1e1 + 0.7e-2 * t31
  t34 = t33 ** (0.1e1 / 0.5e1)
  t35 = t34 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t42 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t10 * t26 * t30 * t37
  t43 = 0.1e1 / t42
  t46 = t10 * t11 * t23 * t43 * t17
  t49 = t8 * t9 * t11
  t51 = 0.1e1 / t21 / t20
  t52 = t42 ** 2
  t53 = 0.1e1 / t52
  t54 = t51 * t53
  t55 = t18 * r0
  t57 = 0.1e1 / t28 / t55
  t62 = s0 ** 2
  t63 = t62 * t11
  t64 = t18 ** 2
  t65 = t64 * t18
  t69 = 0.1e1 / t36 / t33
  t74 = -0.22222222222222222222222222222222222222222222222222e-2 * t10 * t26 * t57 * t37 + 0.24888888888888888888888888888888888888888888888889e-4 * t10 * t63 / t27 / t65 * t69
  t75 = t16 * t74
  t77 = t49 * t54 * t75
  t79 = 0.1e1 / t21
  t80 = t11 * t79
  t81 = t52 * t42
  t82 = 0.1e1 / t81
  t83 = t74 ** 2
  t86 = t10 * t80 * t82 * t83
  t89 = 0.1e1 / t28 / t64
  t101 = t62 * s0
  t102 = t64 ** 2
  t106 = t33 ** 2
  t108 = 0.1e1 / t36 / t106
  t112 = 0.81481481481481481481481481481481481481481481481481e-2 * t10 * t26 * t89 * t37 - 0.22400000000000000000000000000000000000000000000000e-3 * t10 * t63 / t27 / t64 / t55 * t69 + 0.16725333333333333333333333333333333333333333333334e-5 * t10 * t101 / t102 / t18 * t108
  t115 = t10 * t80 * t53 * t112
  t118 = f.my_piecewise3(t2, 0, 0.4e1 / 0.81e2 * t46 + 0.2e1 / 0.27e2 * t77 + 0.2e1 / 0.9e1 * t86 - t115 / 0.9e1)
  t120 = t10 * t80 * t43
  t122 = f.my_piecewise3(t2, 0, t120 / 0.9e1)
  t123 = 0.126e1 * t122
  t124 = 0.1e1 + t123
  t125 = jnp.log(t124)
  t126 = t123 - t125
  t132 = t10 * t11 * t51 * t43 * t16
  t136 = t10 * t80 * t53 * t74
  t139 = f.my_piecewise3(t2, 0, -t132 / 0.27e2 - t136 / 0.9e1)
  t141 = 0.1e1 / t124
  t144 = 0.126e1 * t139 - 0.126e1 * t139 * t141
  t150 = t139 ** 2
  t151 = t124 ** 2
  t152 = 0.1e1 / t151
  t155 = 0.126e1 * t118 - 0.126e1 * t118 * t141 + 0.15876e1 * t150 * t152
  t158 = t17 * t16
  t159 = t158 * t55
  t161 = 0.1e1 / t21 / t159
  t165 = t10 * t11 * t161 * t43 * t158
  t167 = t23 * t53
  t168 = t17 * t74
  t170 = t49 * t167 * t168
  t172 = t51 * t82
  t175 = t49 * t172 * t16 * t83
  t177 = t16 * t112
  t179 = t49 * t54 * t177
  t181 = t52 ** 2
  t182 = 0.1e1 / t181
  t183 = t83 * t74
  t186 = t10 * t80 * t182 * t183
  t188 = t79 * t82
  t191 = t49 * t188 * t74 * t112
  t193 = t64 * r0
  t195 = 0.1e1 / t28 / t193
  t212 = t62 ** 2
  t220 = 0.1e1 / t36 / t106 / t33 * t25
  t224 = -0.38024691358024691358024691358024691358024691358024e-1 * t10 * t26 * t195 * t37 + 0.18860246913580246913580246913580246913580246913581e-2 * t10 * t63 / t27 / t102 * t69 - 0.31778133333333333333333333333333333333333333333334e-4 * t10 * t101 / t102 / t55 * t108 + 0.87417742222222222222222222222222222222222222222228e-7 * t10 * t212 / t28 / t102 / t193 * t220
  t227 = t10 * t80 * t53 * t224
  t230 = f.my_piecewise3(t2, 0, -0.28e2 / 0.243e3 * t165 - 0.4e1 / 0.27e2 * t170 - 0.2e1 / 0.9e1 * t175 + t179 / 0.9e1 - 0.2e1 / 0.3e1 * t186 + 0.2e1 / 0.3e1 * t191 - t227 / 0.9e1)
  t231 = r0 * t230
  t234 = r0 * t118
  t237 = r0 * t139
  t240 = r0 * t122
  t249 = 0.1e1 / t151 / t124
  t252 = 0.126e1 * t230 - 0.126e1 * t230 * t141 + 0.47628e1 * t118 * t152 * t139 - 0.4000752e1 * t150 * t139 * t249
  t255 = t16 ** (0.1e1 / 0.3e1)
  t256 = t255 ** 2
  t258 = t256 * t17 * t25
  t259 = tau0 * t25
  t264 = -0.10e2 / 0.3e1 * t259 * t30 + 0.2e1 / 0.3e1 * t26 * t57
  t266 = t28 * t264 * t4
  t267 = t258 * t266
  t269 = 0.1e1 / t6 / t5
  t270 = t269 * t9
  t271 = t270 * t51
  t273 = 0.1e1 / t181 / t42
  t275 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t120
  t276 = jnp.log(t275)
  t277 = t276 * t3
  t278 = t277 * t6
  t279 = t9 ** 2
  t280 = t279 * t25
  t281 = t21 * t42
  t282 = t280 * t281
  t285 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t278 * t282
  t286 = t273 * t285
  t287 = t286 * t74
  t288 = t271 * t287
  t291 = t28 * r0
  t296 = 0.2e1 * t259 / t291 - t31 / 0.4e1
  t298 = t291 * t296 * t4
  t299 = t258 * t298
  t302 = -0.35555555555555555555555555555555555555555555555557e-1 * t132 - 0.10666666666666666666666666666666666666666666666667e0 * t136
  t303 = 0.1e1 / t275
  t305 = t3 * t6
  t306 = t302 * t303 * t305
  t310 = t277 * t6 * t279
  t311 = t21 ** 2
  t312 = 0.1e1 / t311
  t313 = t25 * t312
  t314 = t42 * t16
  t318 = t21 * t74
  t319 = t280 * t318
  t322 = -0.39062500000000000000000000000000000000000000000000e0 * t306 * t282 - 0.13020833333333333333333333333333333333333333333333e0 * t310 * t313 * t314 - 0.39062500000000000000000000000000000000000000000000e0 * t278 * t319
  t323 = t273 * t322
  t324 = t323 * t112
  t325 = t271 * t324
  t329 = t291 * t264 * t4
  t330 = t258 * t329
  t331 = t286 * t112
  t332 = t271 * t331
  t335 = t286 * t224
  t336 = t271 * t335
  t340 = t256 * t158 * t25
  t341 = t340 * t329
  t342 = t270 * t23
  t343 = t342 * t287
  t346 = t340 * t298
  t347 = t342 * t331
  t350 = t323 * t74
  t351 = t271 * t350
  t354 = t17 ** 2
  t356 = t256 * t354 * t25
  t357 = t356 * t298
  t358 = t270 * t161
  t359 = t358 * t287
  t366 = 0.47407407407407407407407407407407407407407407407409e-1 * t46 + 0.71111111111111111111111111111111111111111111111114e-1 * t77 + 0.21333333333333333333333333333333333333333333333334e0 * t86 - 0.10666666666666666666666666666666666666666666666667e0 * t115
  t368 = t366 * t303 * t305
  t371 = t302 ** 2
  t372 = t275 ** 2
  t373 = 0.1e1 / t372
  t375 = t371 * t373 * t305
  t380 = t280 * t312 * t42 * t16
  t386 = 0.1e1 / t311 / t20
  t387 = t25 * t386
  t396 = t280 * t21 * t112
  t399 = -0.39062500000000000000000000000000000000000000000000e0 * t368 * t282 + 0.39062500000000000000000000000000000000000000000000e0 * t375 * t282 - 0.26041666666666666666666666666666666666666666666666e0 * t306 * t380 - 0.78125000000000000000000000000000000000000000000000e0 * t306 * t319 + 0.86805555555555555555555555555555555555555555555553e-1 * t310 * t387 * t42 * t17 - 0.26041666666666666666666666666666666666666666666666e0 * t310 * t313 * t75 - 0.39062500000000000000000000000000000000000000000000e0 * t278 * t396
  t400 = t273 * t399
  t401 = t400 * t74
  t402 = t271 * t401
  t405 = t342 * t350
  t409 = 0.1e1 / t181 / t52
  t410 = t409 * t285
  t411 = t410 * t83
  t412 = t271 * t411
  t416 = t409 * t322 * t83
  t417 = t271 * t416
  t421 = t28 * t296 * t4
  t422 = t258 * t421
  t425 = 0.1e1 / t27
  t427 = t425 * t296 * t4
  t428 = t258 * t427
  t431 = t340 * t421
  t438 = t342 * t411
  t442 = 0.1e1 / t181 / t81
  t444 = t442 * t285 * t183
  t445 = t271 * t444
  t452 = 0.80e2 / 0.9e1 * t259 * t57 - 0.22e2 / 0.9e1 * t26 * t89
  t454 = t291 * t452 * t4
  t455 = t258 * t454
  t458 = 0.74565404444444444444444444444444444444444444444454e-2 * t267 * t288 + 0.22369621333333333333333333333333333333333333333337e-2 * t299 * t325 + 0.22369621333333333333333333333333333333333333333337e-2 * t330 * t332 + 0.74565404444444444444444444444444444444444444444456e-3 * t299 * t336 - 0.59652323555555555555555555555555555555555555555565e-2 * t341 * t343 - 0.29826161777777777777777777777777777777777777777782e-2 * t346 * t347 + 0.44739242666666666666666666666666666666666666666673e-2 * t330 * t351 + 0.69594377481481481481481481481481481481481481481492e-2 * t357 * t359 + 0.22369621333333333333333333333333333333333333333337e-2 * t299 * t402 - 0.59652323555555555555555555555555555555555555555565e-2 * t346 * t405 - 0.11184810666666666666666666666666666666666666666668e-1 * t330 * t412 - 0.11184810666666666666666666666666666666666666666668e-1 * t299 * t417 + 0.37282702222222222222222222222222222222222222222227e-2 * t422 * t332 + 0.24855134814814814814814814814814814814814814814818e-2 * t428 * t288 - 0.99420539259259259259259259259259259259259259259275e-2 * t431 * t343 + 0.74565404444444444444444444444444444444444444444454e-2 * t422 * t351 - 0.18641351111111111111111111111111111111111111111114e-1 * t422 * t412 + 0.14913080888888888888888888888888888888888888888891e-1 * t346 * t438 + 0.22369621333333333333333333333333333333333333333337e-1 * t299 * t445 + 0.22369621333333333333333333333333333333333333333337e-2 * t455 * t288
  t459 = t51 * t182
  t461 = t270 * t459 * t399
  t471 = 0.1e1 / t311 / t19
  t472 = t25 * t471
  t479 = t280 * t312 * t74 * t16
  t484 = 0.1e1 / t372 / t275
  t486 = t371 * t302 * t484 * t305
  t494 = t366 * t373 * t305
  t496 = t280 * t281 * t302
  t500 = t280 * t21 * t224
  t516 = -0.11061728395061728395061728395061728395061728395062e0 * t165 - 0.14222222222222222222222222222222222222222222222223e0 * t170 - 0.21333333333333333333333333333333333333333333333334e0 * t175 + 0.10666666666666666666666666666666666666666666666667e0 * t179 - 0.64000000000000000000000000000000000000000000000002e0 * t186 + 0.64000000000000000000000000000000000000000000000002e0 * t191 - 0.10666666666666666666666666666666666666666666666667e0 * t227
  t518 = t516 * t303 * t305
  t523 = t280 * t386 * t42 * t17
  t526 = -0.39062499999999999999999999999999999999999999999999e0 * t310 * t313 * t177 + 0.26041666666666666666666666666666666666666666666666e0 * t310 * t387 * t168 - 0.14467592592592592592592592592592592592592592592592e0 * t310 * t472 * t42 * t158 - 0.78124999999999999999999999999999999999999999999999e0 * t306 * t479 - 0.78125000000000000000000000000000000000000000000000e0 * t486 * t282 + 0.39062499999999999999999999999999999999999999999999e0 * t375 * t380 - 0.39062499999999999999999999999999999999999999999999e0 * t368 * t380 + 0.11718750000000000000000000000000000000000000000000e1 * t494 * t496 - 0.39062500000000000000000000000000000000000000000000e0 * t278 * t500 - 0.11718750000000000000000000000000000000000000000000e1 * t306 * t396 + 0.11718750000000000000000000000000000000000000000000e1 * t375 * t319 - 0.11718750000000000000000000000000000000000000000000e1 * t368 * t319 - 0.39062500000000000000000000000000000000000000000000e0 * t518 * t282 + 0.26041666666666666666666666666666666666666666666666e0 * t306 * t523
  t528 = t270 * t459 * t526
  t532 = 0.1e1 / t27 / r0
  t534 = t532 * t296 * t4
  t535 = t258 * t534
  t537 = t270 * t459 * t285
  t540 = t340 * t427
  t541 = t23 * t182
  t543 = t270 * t541 * t285
  t546 = t356 * t421
  t547 = t161 * t182
  t549 = t270 * t547 * t285
  t552 = t354 * t16
  t554 = t256 * t552 * t25
  t555 = t554 * t298
  t558 = 0.1e1 / t21 / t354 / t64
  t559 = t558 * t182
  t561 = t270 * t559 * t285
  t567 = t270 * t541 * t322
  t571 = t270 * t547 * t322
  t578 = -0.880e3 / 0.27e2 * t259 * t89 + 0.308e3 / 0.27e2 * t26 * t195
  t580 = t291 * t578 * t4
  t581 = t258 * t580
  t586 = t270 * t459 * t322
  t589 = t340 * t266
  t592 = t340 * t454
  t596 = t425 * t264 * t4
  t597 = t258 * t596
  t603 = t28 * t452 * t4
  t604 = t258 * t603
  t609 = t356 * t329
  t615 = t270 * t541 * t399
  t618 = t258 * t291
  t620 = t296 * t4 * t269
  t621 = t618 * t620
  t622 = t9 * t51
  t623 = t622 * t409
  t625 = t285 * t74 * t112
  t626 = t623 * t625
  t629 = -0.55924053333333333333333333333333333333333333333342e-3 * t455 * t586 + 0.24855134814814814814814814814814814814814814814819e-2 * t589 * t543 + 0.74565404444444444444444444444444444444444444444457e-3 * t592 * t543 - 0.62137837037037037037037037037037037037037037037046e-3 * t597 * t537 - 0.62137837037037037037037037037037037037037037037046e-3 * t428 * t586 - 0.93206755555555555555555555555555555555555555555569e-3 * t604 * t537 - 0.18641351111111111111111111111111111111111111111114e-2 * t267 * t586 - 0.17398594370370370370370370370370370370370370370373e-2 * t609 * t549 + 0.14913080888888888888888888888888888888888888888891e-2 * t341 * t567 + 0.74565404444444444444444444444444444444444444444457e-3 * t346 * t615 - 0.11184810666666666666666666666666666666666666666668e-1 * t621 * t626
  t632 = f.my_piecewise3(t2, 0, t458 - 0.55924053333333333333333333333333333333333333333342e-3 * t330 * t461 - 0.18641351111111111111111111111111111111111111111114e-3 * t299 * t528 + 0.69042041152263374485596707818930041152263374485607e-4 * t535 * t537 + 0.82850449382716049382716049382716049382716049382729e-3 * t540 * t543 - 0.28997657283950617283950617283950617283950617283955e-2 * t546 * t549 + 0.19331771522633744855967078189300411522633744855970e-2 * t555 * t561 - 0.93206755555555555555555555555555555555555555555569e-3 * t422 * t461 + 0.24855134814814814814814814814814814814814814814819e-2 * t431 * t567 - 0.17398594370370370370370370370370370370370370370373e-2 * t357 * t571 - 0.18641351111111111111111111111111111111111111111114e-3 * t581 * t537 + t629)
  t645 = t10 * t11 * t558 * t43 * t354
  t648 = t158 * t74
  t650 = t49 * t161 * t53 * t648
  t655 = t49 * t23 * t82 * t17 * t83
  t657 = t17 * t112
  t659 = t49 * t167 * t657
  t663 = t49 * t459 * t16 * t183
  t667 = t49 * t172 * t75 * t112
  t669 = t16 * t224
  t671 = t49 * t54 * t669
  t673 = t83 ** 2
  t676 = t10 * t80 * t273 * t673
  t681 = t49 * t79 * t182 * t83 * t112
  t683 = t112 ** 2
  t686 = t10 * t80 * t82 * t683
  t690 = t49 * t188 * t74 * t224
  t693 = 0.1e1 / t28 / t65
  t719 = t102 ** 2
  t724 = t106 ** 2
  t731 = 0.21547325102880658436213991769547325102880658436214e0 * t10 * t26 * t693 * t37 - 0.16852543209876543209876543209876543209876543209877e-1 * t10 * t63 / t27 / t102 / r0 * t69 + 0.47630032592592592592592592592592592592592592592594e-3 * t10 * t101 / t102 / t64 * t108 - 0.28556462459259259259259259259259259259259259259261e-5 * t10 * t212 / t28 / t102 / t65 * t220 + 0.12401663696592592592592592592592592592592592592594e-7 * t10 * t212 * s0 / t27 / t719 / r0 / t36 / t724 * t11
  t734 = t10 * t80 * t53 * t731
  t736 = 0.280e3 / 0.729e3 * t645 + 0.112e3 / 0.243e3 * t650 + 0.16e2 / 0.27e2 * t655 - 0.8e1 / 0.27e2 * t659 + 0.8e1 / 0.9e1 * t663 - 0.8e1 / 0.9e1 * t667 + 0.4e1 / 0.27e2 * t671 + 0.8e1 / 0.3e1 * t676 - 0.4e1 * t681 + 0.2e1 / 0.3e1 * t686 + 0.8e1 / 0.9e1 * t690 - t734 / 0.9e1
  t737 = f.my_piecewise3(t2, 0, t736)
  t756 = t118 ** 2
  t759 = t150 ** 2
  t760 = t151 ** 2
  t791 = 0.49710269629629629629629629629629629629629629629636e-2 * t422 * t336 - 0.39768215703703703703703703703703703703703703703709e-2 * t346 * t342 * t335 + 0.27837750992592592592592592592592592592592592592596e-1 * t609 * t359 + 0.59652323555555555555555555555555555555555555555564e-1 * t341 * t438 - 0.19884107851851851851851851851851851851851851851855e-1 * t431 * t347 - 0.39768215703703703703703703703703703703703703703710e-1 * t589 * t343 - 0.74565404444444444444444444444444444444444444444454e-1 * t267 * t412 + 0.14913080888888888888888888888888888888888888888891e-1 * t422 * t325 - 0.11930464711111111111111111111111111111111111111113e-1 * t346 * t342 * t324 - 0.11930464711111111111111111111111111111111111111113e-1 * t341 * t347 + 0.99420539259259259259259259259259259259259259259272e-2 * t597 * t288
  t824 = 0.89478485333333333333333333333333333333333333333347e-2 * t455 * t351 + 0.99420539259259259259259259259259259259259259259272e-2 * t428 * t351 - 0.22369621333333333333333333333333333333333333333336e-1 * t455 * t412 - 0.11930464711111111111111111111111111111111111111113e-1 * t346 * t342 * t401 - 0.22369621333333333333333333333333333333333333333336e-1 * t299 * t271 * t409 * t399 * t83 - 0.39768215703703703703703703703703703703703703703710e-1 * t431 * t405 + 0.59652323555555555555555555555555555555555555555564e-1 * t346 * t342 * t416 + 0.13918875496296296296296296296296296296296296296298e-1 * t357 * t358 * t331 - 0.44739242666666666666666666666666666666666666666672e-1 * t330 * t417 + 0.46396251654320987654320987654320987654320987654328e-1 * t546 * t359 - 0.30930834436213991769547325102880658436213991769552e-1 * t555 * t270 * t558 * t287 + 0.29826161777777777777777777777777777777777777777783e-2 * t330 * t336
  t849 = t181 ** 2
  t860 = 0.14913080888888888888888888888888888888888888888891e-1 * t604 * t288 + 0.29826161777777777777777777777777777777777777777782e-1 * t267 * t351 + 0.14913080888888888888888888888888888888888888888891e-1 * t267 * t332 + 0.89478485333333333333333333333333333333333333333347e-2 * t330 * t325 + 0.27837750992592592592592592592592592592592592592596e-1 * t357 * t358 * t350 + 0.29826161777777777777777777777777777777777777777783e-2 * t299 * t271 * t273 * t526 * t74 - 0.11184810666666666666666666666666666666666666666668e-1 * t299 * t271 * t410 * t683 - 0.11930464711111111111111111111111111111111111111113e0 * t346 * t342 * t444 - 0.15658734933333333333333333333333333333333333333336e0 * t299 * t271 / t849 * t285 * t673 + 0.14913080888888888888888888888888888888888888888891e0 * t422 * t445 - 0.11046726584362139917695473251028806584362139917697e-2 * t535 * t288
  t891 = -0.13256071901234567901234567901234567901234567901237e-1 * t540 * t343 - 0.24855134814814814814814814814814814814814814814818e-1 * t428 * t412 + 0.99420539259259259259259259259259259259259259259275e-1 * t431 * t438 + 0.89478485333333333333333333333333333333333333333345e-1 * t330 * t445 - 0.74565404444444444444444444444444444444444444444454e-1 * t422 * t417 + 0.89478485333333333333333333333333333333333333333345e-1 * t299 * t271 * t442 * t322 * t183 + 0.49710269629629629629629629629629629629629629629636e-2 * t428 * t332 - 0.69594377481481481481481481481481481481481481481492e-1 * t357 * t358 * t411 + 0.14913080888888888888888888888888888888888888888891e-1 * t422 * t402 + 0.74565404444444444444444444444444444444444444444456e-3 * t299 * t271 * t286 * t731 - 0.11930464711111111111111111111111111111111111111113e-1 * t592 * t343 - 0.23860929422222222222222222222222222222222222222226e-1 * t341 * t405
  t925 = 0.44739242666666666666666666666666666666666666666674e-2 * t299 * t271 * t400 * t112 + 0.29826161777777777777777777777777777777777777777783e-2 * t299 * t271 * t323 * t224 + 0.89478485333333333333333333333333333333333333333347e-2 * t330 * t402 + 0.29826161777777777777777777777777777777777777777783e-2 * t581 * t288 + 0.44739242666666666666666666666666666666666666666674e-2 * t455 * t332 - 0.36822421947873799725651577503429355281207133058991e-3 * t340 * t534 * t543 + 0.33140179753086419753086419753086419753086419753092e-2 * t540 * t567 - 0.11599062913580246913580246913580246913580246913582e-1 * t356 * t266 * t549 - 0.11599062913580246913580246913580246913580246913582e-1 * t546 * t571 + 0.77327086090534979423868312757201646090534979423880e-2 * t554 * t329 * t561 + 0.77327086090534979423868312757201646090534979423880e-2 * t555 * t270 * t559 * t322
  t990 = -0.15625000000000000000000000000000000000000000000000e1 * t518 * t319 - 0.15625000000000000000000000000000000000000000000000e1 * t306 * t500 + 0.52083333333333333333333333333333333333333333333332e0 * t310 * t387 * t657 + 0.38580246913580246913580246913580246913580246913579e0 * t310 * t25 / t311 / t159 * t42 * t354 - 0.57870370370370370370370370370370370370370370370369e0 * t310 * t472 * t648 - 0.52083333333333333333333333333333333333333333333332e0 * t375 * t523 + 0.52083333333333333333333333333333333333333333333332e0 * t368 * t523 + 0.15625000000000000000000000000000000000000000000000e1 * t375 * t479 - 0.52083333333333333333333333333333333333333333333332e0 * t518 * t380 - 0.57870370370370370370370370370370370370370370370369e0 * t306 * t280 * t471 * t42 * t158 - 0.15625000000000000000000000000000000000000000000000e1 * t368 * t479 - 0.15625000000000000000000000000000000000000000000000e1 * t306 * t280 * t312 * t112 * t16 + 0.10416666666666666666666666666666666666666666666666e1 * t306 * t280 * t386 * t74 * t17
  t1013 = t366 ** 2
  t1030 = 0.36872427983539094650205761316872427983539094650207e0 * t645 + 0.44246913580246913580246913580246913580246913580249e0 * t650 + 0.56888888888888888888888888888888888888888888888891e0 * t655 - 0.28444444444444444444444444444444444444444444444446e0 * t659 + 0.85333333333333333333333333333333333333333333333336e0 * t663 - 0.85333333333333333333333333333333333333333333333336e0 * t667 + 0.14222222222222222222222222222222222222222222222223e0 * t671 + 0.25600000000000000000000000000000000000000000000001e1 * t676 - 0.38400000000000000000000000000000000000000000000002e1 * t681 + 0.64000000000000000000000000000000000000000000000002e0 * t686 + 0.85333333333333333333333333333333333333333333333336e0 * t690 - 0.10666666666666666666666666666666666666666666666667e0 * t734
  t1040 = t371 ** 2
  t1041 = t372 ** 2
  t1056 = -0.46875000000000000000000000000000000000000000000000e1 * t371 * t484 * t305 * t280 * t281 * t366 - 0.10416666666666666666666666666666666666666666666666e1 * t486 * t380 + 0.46875000000000000000000000000000000000000000000000e1 * t494 * t280 * t318 * t302 + 0.15625000000000000000000000000000000000000000000000e1 * t516 * t373 * t305 * t496 - 0.39062500000000000000000000000000000000000000000000e0 * t278 * t280 * t21 * t731 + 0.23437500000000000000000000000000000000000000000000e1 * t375 * t396 + 0.11718750000000000000000000000000000000000000000000e1 * t1013 * t373 * t305 * t282 - 0.39062500000000000000000000000000000000000000000000e0 * t1030 * t303 * t305 * t282 - 0.52083333333333333333333333333333333333333333333332e0 * t310 * t313 * t669 - 0.23437500000000000000000000000000000000000000000000e1 * t368 * t396 + 0.23437500000000000000000000000000000000000000000000e1 * t1040 / t1041 * t305 * t282 - 0.31250000000000000000000000000000000000000000000000e1 * t486 * t319 + 0.15625000000000000000000000000000000000000000000000e1 * t302 * t373 * t305 * t279 * t313 * t314 * t366
  t1076 = -0.37282702222222222222222222222222222222222222222228e-2 * t267 * t461 + 0.27616816460905349794238683127572016460905349794243e-3 * t258 * t532 * t264 * t4 * t537 + 0.27616816460905349794238683127572016460905349794243e-3 * t535 * t586 - 0.34797188740740740740740740740740740740740740740746e-2 * t356 * t454 * t549 - 0.12427567407407407407407407407407407407407407407409e-2 * t422 * t528 - 0.12427567407407407407407407407407407407407407407409e-2 * t428 * t461 + 0.99420539259259259259259259259259259259259259259276e-3 * t346 * t270 * t541 * t526 - 0.74565404444444444444444444444444444444444444444456e-3 * t330 * t528 - 0.18641351111111111111111111111111111111111111111114e-3 * t299 * t270 * t459 * (t990 + t1056) - 0.18641351111111111111111111111111111111111111111114e-3 * t258 * t291 * (0.12320e5 / 0.81e2 * t259 * t195 - 0.5236e4 / 0.81e2 * t26 * t693) * t4 * t537 - 0.74565404444444444444444444444444444444444444444456e-3 * t581 * t586 + 0.99420539259259259259259259259259259259259259259275e-2 * t589 * t567
  t1121 = 0.33140179753086419753086419753086419753086419753092e-2 * t340 * t596 * t543 + 0.49710269629629629629629629629629629629629629629638e-2 * t431 * t615 + 0.29826161777777777777777777777777777777777777777782e-2 * t592 * t567 + 0.29826161777777777777777777777777777777777777777783e-2 * t341 * t615 - 0.11184810666666666666666666666666666666666666666668e-2 * t455 * t461 + 0.49710269629629629629629629629629629629629629629638e-2 * t340 * t603 * t543 - 0.12427567407407407407407407407407407407407407407409e-2 * t258 * t425 * t452 * t4 * t537 - 0.24855134814814814814814814814814814814814814814818e-2 * t597 * t586 + 0.12887847681755829903978052126200274348422496570647e-1 * t554 * t421 * t561 - 0.83771009931412894375857338820301783264746227709203e-2 * t256 * t354 * t17 * t25 * t298 * t270 / t21 / t552 / t193 * t182 * t285 - 0.92056054869684499314128943758573388203017832647476e-4 * t258 / t27 / t18 * t296 * t4 * t537
  t1173 = -0.38663543045267489711934156378600823045267489711940e-2 * t356 * t427 * t549 - 0.12427567407407407407407407407407407407407407407409e-2 * t258 * t28 * t578 * t4 * t537 + 0.99420539259259259259259259259259259259259259259276e-3 * t340 * t580 * t543 - 0.37282702222222222222222222222222222222222222222228e-2 * t604 * t586 - 0.69594377481481481481481481481481481481481481481492e-2 * t609 * t571 - 0.34797188740740740740740740740740740740740740740746e-2 * t357 * t270 * t547 * t399 + 0.13421772800000000000000000000000000000000000000002e0 * t621 * t622 * t442 * t285 * t83 * t112 - 0.74565404444444444444444444444444444444444444444455e-1 * t258 * t28 * t620 * t626 + 0.59652323555555555555555555555555555555555555555564e-1 * t340 * t291 * t620 * t9 * t23 * t409 * t625 - 0.44739242666666666666666666666666666666666666666672e-1 * t618 * t264 * t4 * t269 * t626 - 0.14913080888888888888888888888888888888888888888891e-1 * t621 * t623 * t285 * t224 * t74 - 0.44739242666666666666666666666666666666666666666672e-1 * t621 * t623 * t322 * t112 * t74
  t1177 = f.my_piecewise3(t2, 0, t791 + t824 + t860 + t891 + t925 + t1076 + t1121 + t1173)
  v4rho4_0_ = -0.30240000000000000000000000000000000000000000000000e1 * t118 * t126 - 0.60480000000000000000000000000000000000000000000000e1 * t139 * t144 - 0.30240000000000000000000000000000000000000000000000e1 * t122 * t155 - 0.10080000000000000000000000000000000000000000000000e1 * t231 * t126 - 0.30240000000000000000000000000000000000000000000000e1 * t234 * t144 - 0.30240000000000000000000000000000000000000000000000e1 * t237 * t155 - 0.10080000000000000000000000000000000000000000000000e1 * t240 * t252 + 0.8e1 * t632 + r0 * (-0.10080000000000000000000000000000000000000000000000e1 * t230 * t126 - 0.30240000000000000000000000000000000000000000000000e1 * t118 * t144 - 0.30240000000000000000000000000000000000000000000000e1 * t139 * t155 - 0.10080000000000000000000000000000000000000000000000e1 * t122 * t252 - 0.25200000000000000000000000000000000000000000000000e0 * r0 * t737 * t126 - 0.10080000000000000000000000000000000000000000000000e1 * t231 * t144 - 0.15120000000000000000000000000000000000000000000000e1 * t234 * t155 - 0.10080000000000000000000000000000000000000000000000e1 * t237 * t252 - 0.25200000000000000000000000000000000000000000000000e0 * t240 * (0.126e1 * t737 - 0.126e1 * t737 * t141 + 0.63504e1 * t230 * t152 * t139 - 0.24004512e2 * t118 * t249 * t150 + 0.47628e1 * t756 * t152 + 0.1512284256e2 * t759 / t760) + 0.2e1 * t1177)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t5 = t1 * t4
  t6 = t1 ** 2
  t7 = t3 * t2
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t11 = -0.2e1 * t5 + 0.2e1 * t9
  t12 = t11 * t2
  t13 = r0 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = 0.1e1 / jnp.pi
  t17 = t16 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = t15 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t2
  t26 = 0.2e1 * r0 * t23 <= f.p.zeta_threshold
  t27 = f.p.zeta_threshold - 0.1e1
  t30 = 0.2e1 * r1 * t23 <= f.p.zeta_threshold
  t31 = -t27
  t32 = t1 * t23
  t33 = f.my_piecewise5(t26, t27, t30, t31, t32)
  t34 = 0.1e1 + t33
  t35 = t34 * t2
  t36 = t35 ** (0.1e1 / 0.3e1)
  t38 = t22 / t36
  t39 = r0 ** 2
  t40 = r0 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t43 = 0.1e1 / t41 / t39
  t44 = s0 * t43
  t46 = 0.1e1 + 0.7e-2 * t44
  t47 = t46 ** (0.1e1 / 0.5e1)
  t48 = t47 ** 2
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t54 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t21 * t44 * t50
  t55 = 0.1e1 / t54
  t57 = t21 * t38 * t55
  t59 = f.my_piecewise3(t13, 0, t57 / 0.9e1)
  t60 = 0.63e0 * t59
  t61 = r1 <= f.p.dens_threshold
  t62 = f.my_piecewise5(t30, t27, t26, t31, -t32)
  t63 = 0.1e1 + t62
  t64 = t63 * t2
  t65 = t64 ** (0.1e1 / 0.3e1)
  t67 = t22 / t65
  t68 = r1 ** 2
  t69 = r1 ** (0.1e1 / 0.3e1)
  t70 = t69 ** 2
  t72 = 0.1e1 / t70 / t68
  t73 = s2 * t72
  t75 = 0.1e1 + 0.7e-2 * t73
  t76 = t75 ** (0.1e1 / 0.5e1)
  t77 = t76 ** 2
  t78 = t77 ** 2
  t79 = 0.1e1 / t78
  t83 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t21 * t73 * t79
  t84 = 0.1e1 / t83
  t86 = t21 * t67 * t84
  t88 = f.my_piecewise3(t61, 0, t86 / 0.9e1)
  t89 = 0.63e0 * t88
  t90 = t60 + t89
  t91 = 0.1e1 + t60 + t89
  t92 = jnp.log(t91)
  t93 = t60 + t89 - t92
  t94 = t90 * t93
  t95 = t12 * t94
  t98 = -t6 * t4 + 0.1e1
  t99 = t98 * t90
  t101 = 0.40000000000000000000000000000000000000000000000000e0 * t99 * t93
  t102 = t98 * t2
  t104 = 0.1e1 / t36 / t35
  t105 = t22 * t104
  t106 = t23 - t5
  t107 = f.my_piecewise5(t26, 0, t30, 0, t106)
  t109 = t107 * t2 + t33 + 0.1e1
  t112 = t21 * t105 * t55 * t109
  t114 = t54 ** 2
  t115 = 0.1e1 / t114
  t116 = t39 * r0
  t118 = 0.1e1 / t41 / t116
  t119 = s0 * t118
  t123 = s0 ** 2
  t124 = t39 ** 2
  t130 = 0.1e1 / t49 / t46
  t134 = -0.22222222222222222222222222222222222222222222222222e-2 * t21 * t119 * t50 + 0.12444444444444444444444444444444444444444444444445e-4 * t21 * t123 / t40 / t124 / t39 * t130
  t137 = t21 * t38 * t115 * t134
  t140 = f.my_piecewise3(t13, 0, -t112 / 0.27e2 - t137 / 0.9e1)
  t141 = 0.63e0 * t140
  t143 = 0.1e1 / t65 / t64
  t144 = t22 * t143
  t145 = -t106
  t146 = f.my_piecewise5(t30, 0, t26, 0, t145)
  t148 = t146 * t2 + t62 + 0.1e1
  t153 = f.my_piecewise3(t61, 0, -t21 * t144 * t84 * t148 / 0.27e2)
  t154 = 0.63e0 * t153
  t155 = t141 + t154
  t156 = t155 * t93
  t157 = t102 * t156
  t159 = 0.1e1 / t91
  t161 = -t155 * t159 + t141 + t154
  t162 = t90 * t161
  t163 = t102 * t162
  t166 = 0.1e1 + t32 <= f.p.zeta_threshold
  t168 = 0.1e1 - t32 <= f.p.zeta_threshold
  t169 = f.my_piecewise5(t166, t27, t168, t31, t32)
  t170 = 0.1e1 + t169
  t171 = t170 ** (0.1e1 / 0.3e1)
  t172 = t171 ** 2
  t174 = t22 ** 2
  t175 = t172 * t170 * t174
  t176 = t2 ** (0.1e1 / 0.3e1)
  t177 = t176 ** 2
  t178 = t177 * t2
  t184 = 0.2e1 * tau0 / t41 / r0 - t44 / 0.4e1
  t186 = t178 * t184 * t15
  t187 = t175 * t186
  t189 = 0.1e1 / t17 / t16
  t190 = t189 * t20
  t191 = t190 * t104
  t192 = t114 ** 2
  t193 = 0.1e1 / t192
  t195 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t57
  t196 = jnp.log(t195)
  t197 = t196 * t14
  t198 = t197 * t17
  t199 = t20 ** 2
  t200 = t199 * t174
  t202 = t200 * t36 * t54
  t205 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t198 * t202
  t206 = t193 * t205
  t207 = f.my_piecewise5(t166, 0, t168, 0, t106)
  t209 = t191 * t206 * t207
  t212 = t170 ** 2
  t214 = t172 * t212 * t174
  t216 = t177 * t184 * t15
  t217 = t214 * t216
  t218 = t104 * t193
  t220 = t190 * t218 * t205
  t222 = 0.31068918518518518518518518518518518518518518518523e-3 * t217 * t220
  t226 = -0.10e2 / 0.3e1 * tau0 * t43 + 0.2e1 / 0.3e1 * t119
  t228 = t178 * t226 * t15
  t229 = t214 * t228
  t232 = t214 * t186
  t233 = t34 ** 2
  t236 = 0.1e1 / t36 / t233 / t3
  t237 = t190 * t236
  t239 = t237 * t206 * t109
  t243 = 0.1e1 / t192 / t54
  t244 = t243 * t205
  t246 = t191 * t244 * t134
  t251 = -0.35555555555555555555555555555555555555555555555557e-1 * t112 - 0.10666666666666666666666666666666666666666666666667e0 * t137
  t252 = 0.1e1 / t195
  t254 = t14 * t17
  t255 = t251 * t252 * t254
  t258 = t17 * t199
  t259 = t197 * t258
  t260 = t36 ** 2
  t261 = 0.1e1 / t260
  t262 = t174 * t261
  t268 = t200 * t36 * t134
  t271 = -0.39062500000000000000000000000000000000000000000000e0 * t255 * t202 - 0.13020833333333333333333333333333333333333333333333e0 * t259 * t262 * t54 * t109 - 0.39062500000000000000000000000000000000000000000000e0 * t198 * t268
  t273 = t190 * t218 * t271
  t277 = f.my_piecewise3(t13, 0, -0.49710269629629629629629629629629629629629629629637e-3 * t187 * t209 - t222 - 0.18641351111111111111111111111111111111111111111114e-3 * t229 * t220 + 0.24855134814814814814814814814814814814814814814819e-3 * t232 * t239 + 0.74565404444444444444444444444444444444444444444456e-3 * t232 * t246 - 0.18641351111111111111111111111111111111111111111114e-3 * t232 * t273)
  t279 = f.my_piecewise5(t168, t27, t166, t31, -t32)
  t280 = 0.1e1 + t279
  t281 = t280 ** (0.1e1 / 0.3e1)
  t282 = t281 ** 2
  t284 = t282 * t280 * t174
  t290 = 0.2e1 * tau1 / t70 / r1 - t73 / 0.4e1
  t292 = t178 * t290 * t15
  t293 = t284 * t292
  t294 = t190 * t143
  t295 = t83 ** 2
  t296 = t295 ** 2
  t297 = 0.1e1 / t296
  t299 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t86
  t300 = jnp.log(t299)
  t301 = t300 * t14
  t302 = t301 * t17
  t304 = t200 * t65 * t83
  t307 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t302 * t304
  t308 = t297 * t307
  t309 = f.my_piecewise5(t168, 0, t166, 0, t145)
  t311 = t294 * t308 * t309
  t314 = t280 ** 2
  t316 = t282 * t314 * t174
  t318 = t177 * t290 * t15
  t319 = t316 * t318
  t320 = t143 * t297
  t322 = t190 * t320 * t307
  t324 = 0.31068918518518518518518518518518518518518518518523e-3 * t319 * t322
  t325 = t316 * t292
  t326 = t63 ** 2
  t329 = 0.1e1 / t65 / t326 / t3
  t330 = t190 * t329
  t332 = t330 * t308 * t148
  t335 = 0.1e1 / t63
  t336 = t335 * t23
  t337 = 0.1e1 / t299
  t338 = t148 * t337
  t341 = t301 * t258
  t342 = t65 ** 2
  t343 = 0.1e1 / t342
  t344 = t174 * t343
  t349 = 0.33333333333333333333333333333333333333333333333334e0 * t336 * t338 - 0.13020833333333333333333333333333333333333333333333e0 * t341 * t344 * t83 * t148
  t351 = t190 * t320 * t349
  t355 = f.my_piecewise3(t61, 0, -0.49710269629629629629629629629629629629629629629637e-3 * t293 * t311 - t324 + 0.24855134814814814814814814814814814814814814814819e-3 * t325 * t332 - 0.18641351111111111111111111111111111111111111111114e-3 * t325 * t351)
  t357 = 0.2e1 * t4
  t358 = t1 * t8
  t359 = 0.8e1 * t358
  t360 = t3 ** 2
  t363 = 0.6e1 * t6 / t360
  t369 = t11 * t90 * t93
  t376 = t98 * t155 * t93
  t378 = t99 * t161
  t380 = t22 * t236
  t381 = t109 ** 2
  t384 = t21 * t380 * t55 * t381
  t387 = t19 * t20 * t22
  t388 = t104 * t115
  t389 = t109 * t134
  t391 = t387 * t388 * t389
  t394 = -0.2e1 * t4 + 0.2e1 * t358
  t395 = f.my_piecewise5(t26, 0, t30, 0, t394)
  t398 = t395 * t2 + 0.2e1 * t107
  t401 = t21 * t105 * t55 * t398
  t405 = t134 ** 2
  t408 = t21 * t38 / t114 / t54 * t405
  t412 = s0 / t41 / t124
  t424 = t124 ** 2
  t428 = t46 ** 2
  t434 = 0.81481481481481481481481481481481481481481481481481e-2 * t21 * t412 * t50 - 0.11200000000000000000000000000000000000000000000000e-3 * t21 * t123 / t40 / t124 / t116 * t130 + 0.41813333333333333333333333333333333333333333333336e-6 * t21 * t123 * s0 / t424 / t39 / t49 / t428
  t437 = t21 * t38 * t115 * t434
  t440 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t384 + 0.2e1 / 0.27e2 * t391 - t401 / 0.27e2 + 0.2e1 / 0.9e1 * t408 - t437 / 0.9e1)
  t441 = 0.63e0 * t440
  t442 = t22 * t329
  t443 = t148 ** 2
  t448 = -t394
  t449 = f.my_piecewise5(t30, 0, t26, 0, t448)
  t452 = t449 * t2 + 0.2e1 * t146
  t458 = f.my_piecewise3(t61, 0, 0.4e1 / 0.81e2 * t21 * t442 * t84 * t443 - t21 * t144 * t84 * t452 / 0.27e2)
  t459 = 0.63e0 * t458
  t460 = t441 + t459
  t468 = t155 ** 2
  t469 = t91 ** 2
  t470 = 0.1e1 / t469
  t479 = 0.1e1 / t36 / t233 / t34 / t7
  t480 = t190 * t479
  t487 = t184 * t15 * t189
  t488 = t214 * t178 * t487
  t489 = t20 * t236
  t490 = t489 * t243
  t503 = t172 * t174
  t504 = t503 * t186
  t505 = t207 ** 2
  t510 = t175 * t216
  t511 = t510 * t209
  t514 = t175 * t178 * t487
  t515 = t489 * t193
  t516 = t205 * t207
  t521 = t20 * t104
  t522 = t521 * t243
  t530 = t214 * t177 * t226 * t15 * t220
  t532 = t217 * t273
  t555 = t251 ** 2
  t556 = t195 ** 2
  t557 = 0.1e1 / t556
  t562 = t261 * t54
  t571 = t174 / t260 / t35
  t592 = -0.57995314567901234567901234567901234567901234567911e-3 * t232 * t480 * t206 * t381 - 0.19884107851851851851851851851851851851851851851855e-2 * t488 * t490 * t205 * t109 * t134 - 0.37282702222222222222222222222222222222222222222228e-2 * t232 * t191 / t192 / t114 * t205 * t405 - 0.82850449382716049382716049382716049382716049382728e-3 * t504 * t191 * t206 * t505 - 0.16570089876543209876543209876543209876543209876546e-2 * t511 + 0.13256071901234567901234567901234567901234567901237e-2 * t514 * t515 * t516 * t109 + 0.39768215703703703703703703703703703703703703703710e-2 * t514 * t522 * t516 * t134 - 0.62137837037037037037037037037037037037037037037046e-3 * t530 - 0.62137837037037037037037037037037037037037037037046e-3 * t532 - 0.18641351111111111111111111111111111111111111111114e-3 * t214 * t178 * (0.80e2 / 0.9e1 * tau0 * t118 - 0.22e2 / 0.9e1 * t412) * t15 * t220 - 0.37282702222222222222222222222222222222222222222228e-3 * t229 * t273 - 0.18641351111111111111111111111111111111111111111114e-3 * t232 * t190 * t218 * (-0.39062500000000000000000000000000000000000000000000e0 * (0.47407407407407407407407407407407407407407407407409e-1 * t384 + 0.71111111111111111111111111111111111111111111111114e-1 * t391 - 0.35555555555555555555555555555555555555555555555557e-1 * t401 + 0.21333333333333333333333333333333333333333333333334e0 * t408 - 0.10666666666666666666666666666666666666666666666667e0 * t437) * t252 * t254 * t202 + 0.39062500000000000000000000000000000000000000000000e0 * t555 * t557 * t254 * t202 - 0.26041666666666666666666666666666666666666666666666e0 * t255 * t200 * t562 * t109 - 0.78125000000000000000000000000000000000000000000000e0 * t255 * t268 + 0.86805555555555555555555555555555555555555555555553e-1 * t259 * t571 * t54 * t381 - 0.26041666666666666666666666666666666666666666666666e0 * t259 * t262 * t389 - 0.13020833333333333333333333333333333333333333333333e0 * t259 * t262 * t54 * t398 - 0.39062500000000000000000000000000000000000000000000e0 * t198 * t200 * t36 * t434)
  t597 = t193 * t271
  t615 = t175 * t228
  t622 = f.my_piecewise5(t166, 0, t168, 0, t394)
  t627 = 0.1e1 / t176
  t632 = 0.20712612345679012345679012345679012345679012345682e-3 * t214 * t627 * t184 * t15 * t220
  t633 = t217 * t239
  t635 = t217 * t246
  t637 = 0.49710269629629629629629629629629629629629629629638e-3 * t229 * t239 + 0.14913080888888888888888888888888888888888888888891e-2 * t229 * t246 + 0.49710269629629629629629629629629629629629629629638e-3 * t232 * t237 * t597 * t109 + 0.24855134814814814814814814814814814814814814814819e-3 * t232 * t237 * t206 * t398 + 0.14913080888888888888888888888888888888888888888891e-2 * t232 * t191 * t243 * t271 * t134 + 0.74565404444444444444444444444444444444444444444456e-3 * t232 * t191 * t244 * t434 - 0.99420539259259259259259259259259259259259259259274e-3 * t615 * t209 - 0.99420539259259259259259259259259259259259259259274e-3 * t187 * t191 * t597 * t207 - 0.49710269629629629629629629629629629629629629629637e-3 * t187 * t191 * t206 * t622 - t632 + 0.82850449382716049382716049382716049382716049382729e-3 * t633 + 0.24855134814814814814814814814814814814814814814818e-2 * t635
  t639 = f.my_piecewise3(t13, 0, t592 + t637)
  t640 = t282 * t174
  t641 = t640 * t292
  t642 = t309 ** 2
  t647 = t284 * t318
  t648 = t647 * t311
  t652 = t290 * t15 * t189
  t653 = t284 * t178 * t652
  t654 = t20 * t329
  t655 = t654 * t297
  t661 = t297 * t349
  t666 = f.my_piecewise5(t168, 0, t166, 0, t448)
  t675 = 0.20712612345679012345679012345679012345679012345682e-3 * t316 * t627 * t290 * t15 * t322
  t676 = t319 * t332
  t678 = t319 * t351
  t683 = 0.1e1 / t65 / t326 / t63 / t7
  t684 = t190 * t683
  t697 = 0.1e1 / t326
  t708 = t299 ** 2
  t709 = 0.1e1 / t708
  t713 = t18 * t20
  t718 = t697 * t4
  t724 = t174 / t342 / t64
  t738 = -0.82850449382716049382716049382716049382716049382728e-3 * t641 * t294 * t308 * t642 - 0.16570089876543209876543209876543209876543209876546e-2 * t648 + 0.13256071901234567901234567901234567901234567901237e-2 * t653 * t655 * t307 * t309 * t148 - 0.99420539259259259259259259259259259259259259259274e-3 * t293 * t294 * t661 * t309 - 0.49710269629629629629629629629629629629629629629637e-3 * t293 * t294 * t308 * t666 - t675 + 0.82850449382716049382716049382716049382716049382729e-3 * t676 - 0.62137837037037037037037037037037037037037037037046e-3 * t678 - 0.57995314567901234567901234567901234567901234567911e-3 * t325 * t684 * t308 * t443 + 0.49710269629629629629629629629629629629629629629638e-3 * t325 * t330 * t661 * t148 + 0.24855134814814814814814814814814814814814814814819e-3 * t325 * t330 * t308 * t452 - 0.18641351111111111111111111111111111111111111111114e-3 * t325 * t190 * t320 * (-0.33333333333333333333333333333333333333333333333334e0 * t697 * t23 * t338 * t146 - 0.33333333333333333333333333333333333333333333333334e0 * t335 * t4 * t338 + 0.33333333333333333333333333333333333333333333333334e0 * t336 * t452 * t337 + 0.11851851851851851851851851851851851851851851851853e-1 * t336 * t443 * t709 * t15 * t713 * t144 * t84 + 0.11111111111111111111111111111111111111111111111111e0 * t718 * t443 * t337 + 0.86805555555555555555555555555555555555555555555553e-1 * t341 * t724 * t83 * t443 - 0.13020833333333333333333333333333333333333333333333e0 * t341 * t344 * t83 * t452)
  t739 = f.my_piecewise3(t61, 0, t738)
  t740 = -0.20000000000000000000000000000000000000000000000000e0 * (-t357 + t359 - t363) * t2 * t94 - 0.40000000000000000000000000000000000000000000000000e0 * t369 - 0.40000000000000000000000000000000000000000000000000e0 * t12 * t156 - 0.40000000000000000000000000000000000000000000000000e0 * t12 * t162 - 0.40000000000000000000000000000000000000000000000000e0 * t376 - 0.40000000000000000000000000000000000000000000000000e0 * t378 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t460 * t93 - 0.40000000000000000000000000000000000000000000000000e0 * t102 * t155 * t161 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t90 * (-t460 * t159 + t468 * t470 + t441 + t459) + t639 + t739
  d11 = -0.40000000000000000000000000000000000000000000000000e0 * t95 - t101 - 0.40000000000000000000000000000000000000000000000000e0 * t157 - 0.40000000000000000000000000000000000000000000000000e0 * t163 + 0.2e1 * t277 + 0.2e1 * t355 + t2 * t740
  t746 = 0.2e1 * t5 + 0.2e1 * t9
  t747 = t746 * t2
  t748 = t747 * t94
  t750 = -t23 - t5
  t751 = f.my_piecewise5(t26, 0, t30, 0, t750)
  t753 = t751 * t2 + t33 + 0.1e1
  t758 = f.my_piecewise3(t13, 0, -t21 * t105 * t55 * t753 / 0.27e2)
  t759 = 0.63e0 * t758
  t760 = -t750
  t761 = f.my_piecewise5(t30, 0, t26, 0, t760)
  t763 = t761 * t2 + t62 + 0.1e1
  t766 = t21 * t144 * t84 * t763
  t768 = 0.1e1 / t295
  t769 = t68 * r1
  t771 = 0.1e1 / t70 / t769
  t772 = s2 * t771
  t776 = s2 ** 2
  t777 = t68 ** 2
  t783 = 0.1e1 / t78 / t75
  t787 = -0.22222222222222222222222222222222222222222222222222e-2 * t21 * t772 * t79 + 0.12444444444444444444444444444444444444444444444445e-4 * t21 * t776 / t69 / t777 / t68 * t783
  t790 = t21 * t67 * t768 * t787
  t793 = f.my_piecewise3(t61, 0, -t766 / 0.27e2 - t790 / 0.9e1)
  t794 = 0.63e0 * t793
  t795 = t759 + t794
  t796 = t795 * t93
  t797 = t102 * t796
  t800 = -t795 * t159 + t759 + t794
  t801 = t90 * t800
  t802 = t102 * t801
  t804 = f.my_piecewise5(t166, 0, t168, 0, t750)
  t806 = t191 * t206 * t804
  t810 = t237 * t206 * t753
  t813 = 0.1e1 / t34
  t814 = t813 * t23
  t815 = t753 * t252
  t818 = t54 * t753
  t822 = 0.33333333333333333333333333333333333333333333333334e0 * t814 * t815 - 0.13020833333333333333333333333333333333333333333333e0 * t259 * t262 * t818
  t824 = t190 * t218 * t822
  t828 = f.my_piecewise3(t13, 0, -0.49710269629629629629629629629629629629629629629637e-3 * t187 * t806 - t222 + 0.24855134814814814814814814814814814814814814814819e-3 * t232 * t810 - 0.18641351111111111111111111111111111111111111111114e-3 * t232 * t824)
  t829 = f.my_piecewise5(t168, 0, t166, 0, t760)
  t831 = t294 * t308 * t829
  t837 = -0.10e2 / 0.3e1 * tau1 * t72 + 0.2e1 / 0.3e1 * t772
  t839 = t178 * t837 * t15
  t840 = t316 * t839
  t844 = t330 * t308 * t763
  t848 = 0.1e1 / t296 / t83
  t849 = t848 * t307
  t851 = t294 * t849 * t787
  t856 = -0.35555555555555555555555555555555555555555555555557e-1 * t766 - 0.10666666666666666666666666666666666666666666666667e0 * t790
  t858 = t856 * t337 * t254
  t861 = t83 * t763
  t866 = t200 * t65 * t787
  t869 = -0.39062500000000000000000000000000000000000000000000e0 * t858 * t304 - 0.13020833333333333333333333333333333333333333333333e0 * t341 * t344 * t861 - 0.39062500000000000000000000000000000000000000000000e0 * t302 * t866
  t871 = t190 * t320 * t869
  t875 = f.my_piecewise3(t61, 0, -0.49710269629629629629629629629629629629629629629637e-3 * t293 * t831 - t324 - 0.18641351111111111111111111111111111111111111111114e-3 * t840 * t322 + 0.24855134814814814814814814814814814814814814814819e-3 * t325 * t844 + 0.74565404444444444444444444444444444444444444444456e-3 * t325 * t851 - 0.18641351111111111111111111111111111111111111111114e-3 * t325 * t871)
  t881 = t746 * t90 * t93
  t893 = t98 * t795 * t93
  t900 = t753 * t134
  t904 = 0.2e1 * t358
  t905 = f.my_piecewise5(t26, 0, t30, 0, t904)
  t907 = t905 * t2 + t107 + t751
  t913 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t387 * t236 * t55 * t753 * t109 + t387 * t388 * t900 / 0.27e2 - t21 * t105 * t55 * t907 / 0.27e2)
  t914 = 0.63e0 * t913
  t918 = t387 * t329 * t84 * t763 * t148
  t920 = f.my_piecewise5(t30, 0, t26, 0, -t904)
  t922 = t920 * t2 + t146 + t761
  t925 = t21 * t144 * t84 * t922
  t927 = t143 * t768
  t928 = t787 * t148
  t930 = t387 * t927 * t928
  t933 = f.my_piecewise3(t61, 0, 0.4e1 / 0.81e2 * t918 - t925 / 0.27e2 + t930 / 0.27e2)
  t934 = 0.63e0 * t933
  t935 = t914 + t934
  t944 = t99 * t800
  t956 = t205 * t753
  t964 = t205 * t804
  t989 = 0.1e1 / t233
  t990 = t989 * t23
  t996 = 0.33333333333333333333333333333333333333333333333334e0 * t813 * t4 * t815
  t1024 = t217 * t824
  t1028 = t217 * t810
  t1030 = -0.99420539259259259259259259259259259259259259259276e-3 * t488 * t490 * t956 * t134 - 0.82850449382716049382716049382716049382716049382728e-3 * t503 * t178 * t487 * t521 * t193 * t964 * t207 + 0.66280359506172839506172839506172839506172839506183e-3 * t514 * t515 * t964 * t109 + 0.19884107851851851851851851851851851851851851851855e-2 * t514 * t522 * t964 * t134 + 0.66280359506172839506172839506172839506172839506184e-3 * t514 * t515 * t956 * t207 - 0.57995314567901234567901234567901234567901234567911e-3 * t488 * t20 * t479 * t193 * t956 * t109 - 0.18641351111111111111111111111111111111111111111114e-3 * t229 * t824 - 0.18641351111111111111111111111111111111111111111114e-3 * t232 * t190 * t218 * (-0.33333333333333333333333333333333333333333333333334e0 * t990 * t815 * t107 - t996 + 0.33333333333333333333333333333333333333333333333334e0 * t814 * t907 * t252 - 0.33333333333333333333333333333333333333333333333334e0 * t814 * t753 * t557 * t251 - 0.13020833333333333333333333333333333333333333333333e0 * t255 * t200 * t562 * t753 + 0.86805555555555555555555555555555555555555555555553e-1 * t259 * t571 * t818 * t109 - 0.13020833333333333333333333333333333333333333333333e0 * t259 * t262 * t900 - 0.13020833333333333333333333333333333333333333333333e0 * t259 * t262 * t54 * t907) - 0.31068918518518518518518518518518518518518518518523e-3 * t1024 - 0.31068918518518518518518518518518518518518518518523e-3 * t530 - 0.31068918518518518518518518518518518518518518518523e-3 * t532 - t632 + 0.41425224691358024691358024691358024691358024691365e-3 * t1028
  t1031 = t510 * t806
  t1033 = t193 * t822
  t1049 = f.my_piecewise5(t166, 0, t168, 0, t904)
  t1071 = -0.82850449382716049382716049382716049382716049382728e-3 * t1031 + 0.24855134814814814814814814814814814814814814814819e-3 * t232 * t237 * t1033 * t109 + 0.74565404444444444444444444444444444444444444444456e-3 * t232 * t191 * t243 * t822 * t134 - 0.49710269629629629629629629629629629629629629629637e-3 * t615 * t806 - 0.49710269629629629629629629629629629629629629629637e-3 * t187 * t191 * t597 * t804 - 0.49710269629629629629629629629629629629629629629637e-3 * t187 * t191 * t206 * t1049 + 0.24855134814814814814814814814814814814814814814819e-3 * t229 * t810 + 0.24855134814814814814814814814814814814814814814819e-3 * t232 * t237 * t597 * t753 + 0.24855134814814814814814814814814814814814814814819e-3 * t232 * t237 * t206 * t907 - 0.49710269629629629629629629629629629629629629629637e-3 * t187 * t191 * t1033 * t207 + 0.41425224691358024691358024691358024691358024691364e-3 * t633 + 0.12427567407407407407407407407407407407407407407409e-2 * t635 - 0.82850449382716049382716049382716049382716049382728e-3 * t511
  t1073 = f.my_piecewise3(t13, 0, t1030 + t1071)
  t1075 = t316 * t178 * t652
  t1076 = t654 * t848
  t1077 = t307 * t787
  t1082 = t307 * t829
  t1087 = t307 * t763
  t1098 = t20 * t143
  t1099 = t1098 * t848
  t1125 = t343 * t83
  t1153 = t319 * t871
  t1158 = t316 * t177 * t837 * t15 * t322
  t1161 = t319 * t851
  t1163 = -0.99420539259259259259259259259259259259259259259274e-3 * t1075 * t1076 * t1077 * t148 + 0.66280359506172839506172839506172839506172839506183e-3 * t653 * t655 * t1082 * t148 + 0.66280359506172839506172839506172839506172839506184e-3 * t653 * t655 * t1087 * t309 - 0.57995314567901234567901234567901234567901234567911e-3 * t1075 * t20 * t683 * t297 * t1087 * t148 + 0.19884107851851851851851851851851851851851851851855e-2 * t653 * t1099 * t1077 * t309 - 0.82850449382716049382716049382716049382716049382728e-3 * t640 * t178 * t652 * t1098 * t297 * t1082 * t309 - 0.18641351111111111111111111111111111111111111111114e-3 * t840 * t351 - 0.18641351111111111111111111111111111111111111111114e-3 * t325 * t190 * t320 * (-0.39062500000000000000000000000000000000000000000000e0 * (0.47407407407407407407407407407407407407407407407409e-1 * t918 - 0.35555555555555555555555555555555555555555555555557e-1 * t925 + 0.35555555555555555555555555555555555555555555555557e-1 * t930) * t337 * t254 * t304 - 0.33333333333333333333333333333333333333333333333335e0 * t856 * t709 * t336 * t148 - 0.13020833333333333333333333333333333333333333333333e0 * t858 * t200 * t1125 * t148 + 0.11111111111111111111111111111111111111111111111111e0 * t718 * t338 * t763 + 0.86805555555555555555555555555555555555555555555553e-1 * t341 * t724 * t861 * t148 - 0.13020833333333333333333333333333333333333333333333e0 * t341 * t344 * t83 * t922 + 0.33333333333333333333333333333333333333333333333334e0 * t336 * t84 * t338 * t787 - 0.13020833333333333333333333333333333333333333333333e0 * t341 * t344 * t928) - 0.31068918518518518518518518518518518518518518518523e-3 * t1153 - 0.31068918518518518518518518518518518518518518518523e-3 * t1158 - t675 - 0.31068918518518518518518518518518518518518518518523e-3 * t678 + 0.12427567407407407407407407407407407407407407407409e-2 * t1161
  t1164 = t319 * t844
  t1166 = t647 * t831
  t1181 = t297 * t869
  t1194 = f.my_piecewise5(t168, 0, t166, 0, -t904)
  t1199 = t284 * t839
  t1206 = 0.41425224691358024691358024691358024691358024691365e-3 * t1164 - 0.82850449382716049382716049382716049382716049382728e-3 * t1166 + 0.24855134814814814814814814814814814814814814814819e-3 * t325 * t330 * t661 * t763 + 0.24855134814814814814814814814814814814814814814819e-3 * t325 * t330 * t308 * t922 + 0.74565404444444444444444444444444444444444444444456e-3 * t325 * t294 * t848 * t349 * t787 - 0.49710269629629629629629629629629629629629629629637e-3 * t293 * t294 * t1181 * t309 + 0.24855134814814814814814814814814814814814814814819e-3 * t325 * t330 * t1181 * t148 - 0.49710269629629629629629629629629629629629629629637e-3 * t293 * t294 * t661 * t829 - 0.49710269629629629629629629629629629629629629629637e-3 * t293 * t294 * t308 * t1194 - 0.49710269629629629629629629629629629629629629629637e-3 * t1199 * t311 + 0.24855134814814814814814814814814814814814814814819e-3 * t840 * t332 + 0.41425224691358024691358024691358024691358024691364e-3 * t676 - 0.82850449382716049382716049382716049382716049382728e-3 * t648
  t1208 = f.my_piecewise3(t61, 0, t1163 + t1206)
  t1209 = -0.20000000000000000000000000000000000000000000000000e0 * (t357 - t363) * t2 * t94 - 0.20000000000000000000000000000000000000000000000000e0 * t881 - 0.20000000000000000000000000000000000000000000000000e0 * t747 * t156 - 0.20000000000000000000000000000000000000000000000000e0 * t747 * t162 - 0.20000000000000000000000000000000000000000000000000e0 * t369 - 0.20000000000000000000000000000000000000000000000000e0 * t376 - 0.20000000000000000000000000000000000000000000000000e0 * t378 - 0.20000000000000000000000000000000000000000000000000e0 * t12 * t796 - 0.20000000000000000000000000000000000000000000000000e0 * t893 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t935 * t93 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t795 * t161 - 0.20000000000000000000000000000000000000000000000000e0 * t12 * t801 - 0.20000000000000000000000000000000000000000000000000e0 * t944 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t155 * t800 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t90 * (t795 * t470 * t155 - t935 * t159 + t914 + t934) + t1073 + t1208
  d12 = -0.20000000000000000000000000000000000000000000000000e0 * t95 - t101 - 0.20000000000000000000000000000000000000000000000000e0 * t157 - 0.20000000000000000000000000000000000000000000000000e0 * t163 + t277 + t355 - 0.20000000000000000000000000000000000000000000000000e0 * t748 - 0.20000000000000000000000000000000000000000000000000e0 * t797 - 0.20000000000000000000000000000000000000000000000000e0 * t802 + t828 + t875 + t2 * t1209
  t1227 = t753 ** 2
  t1233 = 0.2e1 * t4 + 0.2e1 * t358
  t1234 = f.my_piecewise5(t26, 0, t30, 0, t1233)
  t1237 = t1234 * t2 + 0.2e1 * t751
  t1243 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t380 * t55 * t1227 - t21 * t105 * t55 * t1237 / 0.27e2)
  t1244 = 0.63e0 * t1243
  t1245 = t763 ** 2
  t1248 = t21 * t442 * t84 * t1245
  t1250 = t763 * t787
  t1252 = t387 * t927 * t1250
  t1254 = -t1233
  t1255 = f.my_piecewise5(t30, 0, t26, 0, t1254)
  t1258 = t1255 * t2 + 0.2e1 * t761
  t1261 = t21 * t144 * t84 * t1258
  t1265 = t787 ** 2
  t1268 = t21 * t67 / t295 / t83 * t1265
  t1272 = s2 / t70 / t777
  t1284 = t777 ** 2
  t1288 = t75 ** 2
  t1294 = 0.81481481481481481481481481481481481481481481481481e-2 * t21 * t1272 * t79 - 0.11200000000000000000000000000000000000000000000000e-3 * t21 * t776 / t69 / t777 / t769 * t783 + 0.41813333333333333333333333333333333333333333333336e-6 * t21 * t776 * s2 / t1284 / t68 / t78 / t1288
  t1297 = t21 * t67 * t768 * t1294
  t1300 = f.my_piecewise3(t61, 0, 0.4e1 / 0.81e2 * t1248 + 0.2e1 / 0.27e2 * t1252 - t1261 / 0.27e2 + 0.2e1 / 0.9e1 * t1268 - t1297 / 0.9e1)
  t1301 = 0.63e0 * t1300
  t1302 = t1244 + t1301
  t1310 = t795 ** 2
  t1316 = t804 ** 2
  t1330 = f.my_piecewise5(t166, 0, t168, 0, t1233)
  t1379 = -0.82850449382716049382716049382716049382716049382728e-3 * t504 * t191 * t206 * t1316 - 0.16570089876543209876543209876543209876543209876546e-2 * t1031 + 0.13256071901234567901234567901234567901234567901237e-2 * t514 * t515 * t964 * t753 - 0.99420539259259259259259259259259259259259259259274e-3 * t187 * t191 * t1033 * t804 - 0.49710269629629629629629629629629629629629629629637e-3 * t187 * t191 * t206 * t1330 - t632 + 0.82850449382716049382716049382716049382716049382729e-3 * t1028 - 0.62137837037037037037037037037037037037037037037046e-3 * t1024 - 0.57995314567901234567901234567901234567901234567911e-3 * t232 * t480 * t206 * t1227 + 0.49710269629629629629629629629629629629629629629638e-3 * t232 * t237 * t1033 * t753 + 0.24855134814814814814814814814814814814814814814819e-3 * t232 * t237 * t206 * t1237 - 0.18641351111111111111111111111111111111111111111114e-3 * t232 * t190 * t218 * (-0.33333333333333333333333333333333333333333333333334e0 * t990 * t815 * t751 - t996 + 0.33333333333333333333333333333333333333333333333334e0 * t814 * t1237 * t252 + 0.11851851851851851851851851851851851851851851851853e-1 * t814 * t1227 * t557 * t15 * t713 * t105 * t55 + 0.11111111111111111111111111111111111111111111111111e0 * t989 * t4 * t1227 * t252 + 0.86805555555555555555555555555555555555555555555553e-1 * t259 * t571 * t54 * t1227 - 0.13020833333333333333333333333333333333333333333333e0 * t259 * t262 * t54 * t1237)
  t1380 = f.my_piecewise3(t13, 0, t1379)
  t1396 = t829 ** 2
  t1433 = t856 ** 2
  t1464 = -0.57995314567901234567901234567901234567901234567911e-3 * t325 * t684 * t308 * t1245 - 0.19884107851851851851851851851851851851851851851855e-2 * t1075 * t1076 * t1087 * t787 - 0.37282702222222222222222222222222222222222222222228e-2 * t325 * t294 / t296 / t295 * t307 * t1265 - 0.82850449382716049382716049382716049382716049382728e-3 * t641 * t294 * t308 * t1396 - 0.16570089876543209876543209876543209876543209876546e-2 * t1166 + 0.13256071901234567901234567901234567901234567901237e-2 * t653 * t655 * t1082 * t763 + 0.39768215703703703703703703703703703703703703703710e-2 * t653 * t1099 * t1082 * t787 - 0.62137837037037037037037037037037037037037037037046e-3 * t1158 - 0.62137837037037037037037037037037037037037037037046e-3 * t1153 - 0.18641351111111111111111111111111111111111111111114e-3 * t316 * t178 * (0.80e2 / 0.9e1 * tau1 * t771 - 0.22e2 / 0.9e1 * t1272) * t15 * t322 - 0.37282702222222222222222222222222222222222222222228e-3 * t840 * t871 - 0.18641351111111111111111111111111111111111111111114e-3 * t325 * t190 * t320 * (-0.39062500000000000000000000000000000000000000000000e0 * (0.47407407407407407407407407407407407407407407407409e-1 * t1248 + 0.71111111111111111111111111111111111111111111111114e-1 * t1252 - 0.35555555555555555555555555555555555555555555555557e-1 * t1261 + 0.21333333333333333333333333333333333333333333333334e0 * t1268 - 0.10666666666666666666666666666666666666666666666667e0 * t1297) * t337 * t254 * t304 + 0.39062500000000000000000000000000000000000000000000e0 * t1433 * t709 * t254 * t304 - 0.26041666666666666666666666666666666666666666666666e0 * t858 * t200 * t1125 * t763 - 0.78125000000000000000000000000000000000000000000000e0 * t858 * t866 + 0.86805555555555555555555555555555555555555555555553e-1 * t341 * t724 * t83 * t1245 - 0.26041666666666666666666666666666666666666666666666e0 * t341 * t344 * t1250 - 0.13020833333333333333333333333333333333333333333333e0 * t341 * t344 * t83 * t1258 - 0.39062500000000000000000000000000000000000000000000e0 * t302 * t200 * t65 * t1294)
  t1494 = f.my_piecewise5(t168, 0, t166, 0, t1254)
  t1499 = 0.82850449382716049382716049382716049382716049382729e-3 * t1164 + 0.24855134814814814814814814814814814814814814814818e-2 * t1161 + 0.49710269629629629629629629629629629629629629629638e-3 * t840 * t844 + 0.14913080888888888888888888888888888888888888888891e-2 * t840 * t851 + 0.49710269629629629629629629629629629629629629629638e-3 * t325 * t330 * t1181 * t763 + 0.24855134814814814814814814814814814814814814814819e-3 * t325 * t330 * t308 * t1258 + 0.14913080888888888888888888888888888888888888888891e-2 * t325 * t294 * t848 * t869 * t787 + 0.74565404444444444444444444444444444444444444444456e-3 * t325 * t294 * t849 * t1294 - 0.99420539259259259259259259259259259259259259259274e-3 * t1199 * t831 - 0.99420539259259259259259259259259259259259259259274e-3 * t293 * t294 * t1181 * t829 - 0.49710269629629629629629629629629629629629629629637e-3 * t293 * t294 * t308 * t1494 - t675
  t1501 = f.my_piecewise3(t61, 0, t1464 + t1499)
  t1502 = -0.20000000000000000000000000000000000000000000000000e0 * (-t357 - t359 - t363) * t2 * t94 - 0.40000000000000000000000000000000000000000000000000e0 * t881 - 0.40000000000000000000000000000000000000000000000000e0 * t747 * t796 - 0.40000000000000000000000000000000000000000000000000e0 * t747 * t801 - 0.40000000000000000000000000000000000000000000000000e0 * t893 - 0.40000000000000000000000000000000000000000000000000e0 * t944 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t1302 * t93 - 0.40000000000000000000000000000000000000000000000000e0 * t102 * t795 * t800 - 0.20000000000000000000000000000000000000000000000000e0 * t102 * t90 * (-t1302 * t159 + t1310 * t470 + t1244 + t1301) + t1380 + t1501
  d22 = -0.40000000000000000000000000000000000000000000000000e0 * t748 - t101 - 0.40000000000000000000000000000000000000000000000000e0 * t797 - 0.40000000000000000000000000000000000000000000000000e0 * t802 + 0.2e1 * t828 + 0.2e1 * t875 + t2 * t1502
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t7 = -t2 * t5 + 0.1e1
  t8 = r0 <= f.p.dens_threshold
  t9 = 3 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = 0.1e1 / jnp.pi
  t12 = t11 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / t12
  t14 = t10 * t13
  t15 = 4 ** (0.1e1 / 0.3e1)
  t16 = t14 * t15
  t17 = 2 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t3
  t21 = 0.2e1 * r0 * t18 <= f.p.zeta_threshold
  t22 = f.p.zeta_threshold - 0.1e1
  t25 = 0.2e1 * r1 * t18 <= f.p.zeta_threshold
  t26 = -t22
  t27 = t1 * t18
  t28 = f.my_piecewise5(t21, t22, t25, t26, t27)
  t29 = 0.1e1 + t28
  t30 = t29 * t3
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t31
  t33 = t17 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t41 = 0.1e1 + 0.7e-2 * t39
  t42 = t41 ** (0.1e1 / 0.5e1)
  t43 = t42 ** 2
  t44 = t43 ** 2
  t45 = 0.1e1 / t44
  t49 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t16 * t39 * t45
  t50 = 0.1e1 / t49
  t52 = t16 * t33 * t50
  t54 = f.my_piecewise3(t8, 0, t52 / 0.9e1)
  t55 = 0.63e0 * t54
  t56 = r1 <= f.p.dens_threshold
  t57 = f.my_piecewise5(t25, t22, t21, t26, -t27)
  t58 = 0.1e1 + t57
  t59 = t58 * t3
  t60 = t59 ** (0.1e1 / 0.3e1)
  t63 = r1 ** 2
  t64 = r1 ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t68 = s2 / t65 / t63
  t71 = (0.1e1 + 0.7e-2 * t68) ** (0.1e1 / 0.5e1)
  t72 = t71 ** 2
  t73 = t72 ** 2
  t78 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t16 * t68 / t73
  t79 = 0.1e1 / t78
  t81 = t16 * t17 / t60 * t79
  t83 = f.my_piecewise3(t56, 0, t81 / 0.9e1)
  t84 = 0.63e0 * t83
  t85 = t55 + t84
  t86 = t7 * t85
  t88 = 0.1e1 / t31 / t30
  t89 = t17 * t88
  t90 = t1 * t5
  t91 = t18 - t90
  t92 = f.my_piecewise5(t21, 0, t25, 0, t91)
  t94 = t92 * t3 + t28 + 0.1e1
  t97 = t16 * t89 * t50 * t94
  t99 = t49 ** 2
  t100 = 0.1e1 / t99
  t101 = t34 * r0
  t103 = 0.1e1 / t36 / t101
  t104 = s0 * t103
  t108 = s0 ** 2
  t109 = t34 ** 2
  t115 = 0.1e1 / t44 / t41
  t119 = -0.22222222222222222222222222222222222222222222222222e-2 * t16 * t104 * t45 + 0.12444444444444444444444444444444444444444444444445e-4 * t16 * t108 / t35 / t109 / t34 * t115
  t122 = t16 * t33 * t100 * t119
  t125 = f.my_piecewise3(t8, 0, -t97 / 0.27e2 - t122 / 0.9e1)
  t126 = 0.63e0 * t125
  t128 = 0.1e1 / t60 / t59
  t129 = t17 * t128
  t130 = -t91
  t131 = f.my_piecewise5(t25, 0, t21, 0, t130)
  t133 = t131 * t3 + t57 + 0.1e1
  t138 = f.my_piecewise3(t56, 0, -t16 * t129 * t79 * t133 / 0.27e2)
  t139 = 0.63e0 * t138
  t140 = t126 + t139
  t141 = 0.1e1 + t55 + t84
  t142 = 0.1e1 / t141
  t144 = -t140 * t142 + t126 + t139
  t147 = t7 * t140
  t148 = jnp.log(t141)
  t149 = t55 + t84 - t148
  t153 = 0.1e1 + t27 <= f.p.zeta_threshold
  t155 = 0.1e1 - t27 <= f.p.zeta_threshold
  t156 = f.my_piecewise5(t153, t22, t155, t26, t27)
  t157 = 0.1e1 + t156
  t158 = t157 ** 2
  t159 = t157 ** (0.1e1 / 0.3e1)
  t160 = t159 ** 2
  t162 = t17 ** 2
  t163 = t160 * t158 * t162
  t164 = t3 ** (0.1e1 / 0.3e1)
  t165 = t164 ** 2
  t166 = t165 * t3
  t172 = 0.2e1 * tau0 / t36 / r0 - t39 / 0.4e1
  t174 = t166 * t172 * t10
  t175 = t163 * t174
  t177 = 0.1e1 / t12 / t11
  t178 = t177 * t15
  t179 = t29 ** 2
  t181 = t4 * t3
  t184 = 0.1e1 / t31 / t179 / t29 / t181
  t185 = t178 * t184
  t186 = t99 ** 2
  t187 = 0.1e1 / t186
  t189 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t52
  t190 = jnp.log(t189)
  t191 = t190 * t9
  t192 = t191 * t12
  t193 = t15 ** 2
  t194 = t193 * t162
  t195 = t31 * t49
  t196 = t194 * t195
  t199 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t192 * t196
  t200 = t187 * t199
  t201 = t94 ** 2
  t203 = t185 * t200 * t201
  t206 = t163 * t166
  t208 = t172 * t10 * t177
  t209 = t206 * t208
  t210 = t179 * t4
  t212 = 0.1e1 / t31 / t210
  t213 = t15 * t212
  t215 = 0.1e1 / t186 / t49
  t216 = t213 * t215
  t217 = t199 * t94
  t219 = t216 * t217 * t119
  t222 = t178 * t88
  t224 = 0.1e1 / t186 / t99
  t226 = t119 ** 2
  t228 = t222 * t224 * t199 * t226
  t231 = t160 * t162
  t232 = t231 * t174
  t233 = f.my_piecewise5(t153, 0, t155, 0, t91)
  t234 = t233 ** 2
  t236 = t222 * t200 * t234
  t240 = t160 * t157 * t162
  t242 = t165 * t172 * t10
  t243 = t240 * t242
  t245 = t222 * t200 * t233
  t248 = t240 * t166
  t249 = t248 * t208
  t250 = t213 * t187
  t251 = t199 * t233
  t253 = t250 * t251 * t94
  t256 = t15 * t88
  t257 = t256 * t215
  t259 = t257 * t251 * t119
  t265 = -0.10e2 / 0.3e1 * tau0 * t38 + 0.2e1 / 0.3e1 * t104
  t267 = t165 * t265 * t10
  t268 = t163 * t267
  t269 = t88 * t187
  t271 = t178 * t269 * t199
  t274 = t163 * t242
  t277 = -0.35555555555555555555555555555555555555555555555557e-1 * t97 - 0.10666666666666666666666666666666666666666666666667e0 * t122
  t278 = 0.1e1 / t189
  t280 = t9 * t12
  t281 = t277 * t278 * t280
  t284 = t12 * t193
  t285 = t191 * t284
  t286 = t31 ** 2
  t287 = 0.1e1 / t286
  t288 = t162 * t287
  t289 = t49 * t94
  t294 = t194 * t31 * t119
  t297 = -0.39062500000000000000000000000000000000000000000000e0 * t281 * t196 - 0.13020833333333333333333333333333333333333333333333e0 * t285 * t288 * t289 - 0.39062500000000000000000000000000000000000000000000e0 * t192 * t294
  t299 = t178 * t269 * t297
  t305 = 0.1e1 / t36 / t109
  t306 = s0 * t305
  t308 = 0.80e2 / 0.9e1 * tau0 * t103 - 0.22e2 / 0.9e1 * t306
  t310 = t166 * t308 * t10
  t311 = t163 * t310
  t315 = t166 * t265 * t10
  t316 = t163 * t315
  t322 = t16 * t17 * t212 * t50 * t201
  t325 = t14 * t15 * t17
  t326 = t88 * t100
  t327 = t94 * t119
  t329 = t325 * t326 * t327
  t331 = 0.1e1 / t181
  t332 = t1 * t331
  t334 = -0.2e1 * t5 + 0.2e1 * t332
  t335 = f.my_piecewise5(t21, 0, t25, 0, t334)
  t338 = t335 * t3 + 0.2e1 * t92
  t341 = t16 * t89 * t50 * t338
  t343 = t99 * t49
  t344 = 0.1e1 / t343
  t347 = t16 * t33 * t344 * t226
  t359 = t108 * s0
  t360 = t109 ** 2
  t364 = t41 ** 2
  t366 = 0.1e1 / t44 / t364
  t370 = 0.81481481481481481481481481481481481481481481481481e-2 * t16 * t306 * t45 - 0.11200000000000000000000000000000000000000000000000e-3 * t16 * t108 / t35 / t109 / t101 * t115 + 0.41813333333333333333333333333333333333333333333336e-6 * t16 * t359 / t360 / t34 * t366
  t373 = t16 * t33 * t100 * t370
  t375 = 0.47407407407407407407407407407407407407407407407409e-1 * t322 + 0.71111111111111111111111111111111111111111111111114e-1 * t329 - 0.35555555555555555555555555555555555555555555555557e-1 * t341 + 0.21333333333333333333333333333333333333333333333334e0 * t347 - 0.10666666666666666666666666666666666666666666666667e0 * t373
  t377 = t375 * t278 * t280
  t380 = t277 ** 2
  t381 = t189 ** 2
  t382 = 0.1e1 / t381
  t384 = t380 * t382 * t280
  t387 = t287 * t49
  t389 = t194 * t387 * t94
  t395 = 0.1e1 / t286 / t30
  t396 = t162 * t395
  t409 = t194 * t31 * t370
  t412 = -0.39062500000000000000000000000000000000000000000000e0 * t377 * t196 + 0.39062500000000000000000000000000000000000000000000e0 * t384 * t196 - 0.26041666666666666666666666666666666666666666666666e0 * t281 * t389 - 0.78125000000000000000000000000000000000000000000000e0 * t281 * t294 + 0.86805555555555555555555555555555555555555555555553e-1 * t285 * t396 * t49 * t201 - 0.26041666666666666666666666666666666666666666666666e0 * t285 * t288 * t327 - 0.13020833333333333333333333333333333333333333333333e0 * t285 * t288 * t49 * t338 - 0.39062500000000000000000000000000000000000000000000e0 * t192 * t409
  t414 = t178 * t269 * t412
  t417 = -0.57995314567901234567901234567901234567901234567911e-3 * t175 * t203 - 0.19884107851851851851851851851851851851851851851855e-2 * t209 * t219 - 0.37282702222222222222222222222222222222222222222228e-2 * t175 * t228 - 0.82850449382716049382716049382716049382716049382728e-3 * t232 * t236 - 0.16570089876543209876543209876543209876543209876546e-2 * t243 * t245 + 0.13256071901234567901234567901234567901234567901237e-2 * t249 * t253 + 0.39768215703703703703703703703703703703703703703710e-2 * t249 * t259 - 0.62137837037037037037037037037037037037037037037046e-3 * t268 * t271 - 0.62137837037037037037037037037037037037037037037046e-3 * t274 * t299 - 0.18641351111111111111111111111111111111111111111114e-3 * t311 * t271 - 0.37282702222222222222222222222222222222222222222228e-3 * t316 * t299 - 0.18641351111111111111111111111111111111111111111114e-3 * t175 * t414
  t418 = t178 * t212
  t420 = t418 * t200 * t94
  t423 = t215 * t199
  t425 = t222 * t423 * t119
  t428 = t187 * t297
  t430 = t418 * t428 * t94
  t434 = t418 * t200 * t338
  t437 = t215 * t297
  t439 = t222 * t437 * t119
  t443 = t222 * t423 * t370
  t446 = t240 * t315
  t449 = t240 * t174
  t451 = t222 * t428 * t233
  t454 = f.my_piecewise5(t153, 0, t155, 0, t334)
  t456 = t222 * t200 * t454
  t459 = 0.1e1 / t164
  t461 = t459 * t172 * t10
  t462 = t163 * t461
  t469 = 0.49710269629629629629629629629629629629629629629638e-3 * t316 * t420 + 0.14913080888888888888888888888888888888888888888891e-2 * t316 * t425 + 0.49710269629629629629629629629629629629629629629638e-3 * t175 * t430 + 0.24855134814814814814814814814814814814814814814819e-3 * t175 * t434 + 0.14913080888888888888888888888888888888888888888891e-2 * t175 * t439 + 0.74565404444444444444444444444444444444444444444456e-3 * t175 * t443 - 0.99420539259259259259259259259259259259259259259274e-3 * t446 * t245 - 0.99420539259259259259259259259259259259259259259274e-3 * t449 * t451 - 0.49710269629629629629629629629629629629629629629637e-3 * t449 * t456 - 0.20712612345679012345679012345679012345679012345682e-3 * t462 * t271 + 0.82850449382716049382716049382716049382716049382729e-3 * t274 * t420 + 0.24855134814814814814814814814814814814814814814818e-2 * t274 * t425
  t471 = f.my_piecewise3(t8, 0, t417 + t469)
  t475 = 0.2e1 * t2 * t331 - 0.2e1 * t90
  t476 = t475 * t85
  t479 = t7 * t3
  t486 = f.my_piecewise3(t8, 0, 0.4e1 / 0.81e2 * t322 + 0.2e1 / 0.27e2 * t329 - t341 / 0.27e2 + 0.2e1 / 0.9e1 * t347 - t373 / 0.9e1)
  t487 = 0.63e0 * t486
  t488 = t58 ** 2
  t489 = t488 * t4
  t491 = 0.1e1 / t60 / t489
  t492 = t17 * t491
  t493 = t133 ** 2
  t498 = -t334
  t499 = f.my_piecewise5(t25, 0, t21, 0, t498)
  t502 = t499 * t3 + 0.2e1 * t131
  t508 = f.my_piecewise3(t56, 0, 0.4e1 / 0.81e2 * t16 * t492 * t79 * t493 - t16 * t129 * t79 * t502 / 0.27e2)
  t509 = 0.63e0 * t508
  t510 = t487 + t509
  t512 = t140 ** 2
  t513 = t141 ** 2
  t514 = 0.1e1 / t513
  t516 = -t510 * t142 + t512 * t514 + t487 + t509
  t521 = t201 * t94
  t524 = t16 * t17 * t184 * t50 * t521
  t527 = t201 * t119
  t529 = t325 * t212 * t100 * t527
  t534 = t325 * t212 * t50 * t94 * t338
  t539 = t325 * t88 * t344 * t94 * t226
  t541 = t338 * t119
  t543 = t325 * t326 * t541
  t545 = t94 * t370
  t547 = t325 * t326 * t545
  t549 = t4 ** 2
  t550 = 0.1e1 / t549
  t551 = t1 * t550
  t553 = 0.6e1 * t331 - 0.6e1 * t551
  t554 = f.my_piecewise5(t21, 0, t25, 0, t553)
  t557 = t554 * t3 + 0.3e1 * t335
  t560 = t16 * t89 * t50 * t557
  t562 = t226 * t119
  t565 = t16 * t33 * t187 * t562
  t570 = t325 * t32 * t344 * t119 * t370
  t572 = t109 * r0
  t575 = s0 / t36 / t572
  t591 = t108 ** 2
  t602 = -0.38024691358024691358024691358024691358024691358024e-1 * t16 * t575 * t45 + 0.94301234567901234567901234567901234567901234567901e-3 * t16 * t108 / t35 / t360 * t115 - 0.79445333333333333333333333333333333333333333333337e-5 * t16 * t359 / t360 / t101 * t366 + 0.21854435555555555555555555555555555555555555555558e-7 * t16 * t591 / t36 / t360 / t572 / t44 / t364 / t41
  t605 = t16 * t33 * t100 * t602
  t608 = f.my_piecewise3(t8, 0, -0.28e2 / 0.243e3 * t524 - 0.4e1 / 0.27e2 * t529 + 0.4e1 / 0.27e2 * t534 - 0.2e1 / 0.9e1 * t539 + t543 / 0.9e1 + t547 / 0.9e1 - t560 / 0.27e2 - 0.2e1 / 0.3e1 * t565 + 0.2e1 / 0.3e1 * t570 - t605 / 0.9e1)
  t609 = 0.63e0 * t608
  t610 = t488 * t58
  t613 = 0.1e1 / t60 / t610 / t181
  t615 = t493 * t133
  t625 = -t553
  t626 = f.my_piecewise5(t25, 0, t21, 0, t625)
  t629 = t626 * t3 + 0.3e1 * t499
  t635 = f.my_piecewise3(t56, 0, -0.28e2 / 0.243e3 * t16 * t17 * t613 * t79 * t615 + 0.4e1 / 0.27e2 * t325 * t491 * t79 * t133 * t502 - t16 * t129 * t79 * t629 / 0.27e2)
  t636 = 0.63e0 * t635
  t637 = t609 + t636
  t657 = t475 * t3
  t658 = t140 * t144
  t661 = t85 * t516
  t664 = f.my_piecewise5(t155, t22, t153, t26, -t27)
  t665 = 0.1e1 + t664
  t666 = t665 ** (0.1e1 / 0.3e1)
  t667 = t666 ** 2
  t668 = t667 * t162
  t675 = 0.2e1 * tau1 / t65 / r1 - t68 / 0.4e1
  t677 = t675 * t10 * t177
  t678 = t668 * t166 * t677
  t680 = t78 ** 2
  t681 = t680 ** 2
  t682 = 0.1e1 / t681
  t683 = t15 * t491 * t682
  t685 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t81
  t686 = jnp.log(t685)
  t687 = t686 * t9
  t693 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t687 * t12 * t194 * t60 * t78
  t694 = f.my_piecewise5(t155, 0, t153, 0, t130)
  t695 = t694 ** 2
  t703 = t693 * t694
  t704 = f.my_piecewise5(t155, 0, t153, 0, t498)
  t710 = t667 * t665 * t162
  t714 = t683 * t703 * t133
  t718 = t710 * t166 * t677
  t719 = 0.1e1 / t58
  t720 = t719 * t18
  t721 = 0.1e1 / t685
  t722 = t133 * t721
  t725 = t687 * t284
  t726 = t60 ** 2
  t728 = t162 / t726
  t729 = t78 * t133
  t733 = 0.33333333333333333333333333333333333333333333333334e0 * t720 * t722 - 0.13020833333333333333333333333333333333333333333333e0 * t725 * t728 * t729
  t749 = t15 * t613 * t682
  t754 = t665 ** 2
  t756 = t667 * t754 * t162
  t765 = t166 * t675 * t10
  t766 = t756 * t765
  t767 = t128 * t682
  t768 = 0.1e1 / t610
  t770 = t131 ** 2
  t774 = 0.1e1 / t488
  t775 = t774 * t5
  t776 = t722 * t131
  t779 = t719 * t5
  t780 = t685 ** 2
  t781 = 0.1e1 / t780
  t782 = t493 * t781
  t783 = t782 * t10
  t785 = t13 * t15
  t786 = t129 * t79
  t787 = t785 * t786
  t795 = t12 ** 2
  t800 = t162 / t726 / t489
  t807 = t615 * t781 * t10
  t817 = t162 / t726 / t59
  t822 = t502 * t721
  t841 = t774 * t18
  t866 = t493 * t721
  t876 = 0.66666666666666666666666666666666666666666666666668e0 * t768 * t18 * t722 * t770 + 0.66666666666666666666666666666666666666666666666668e0 * t775 * t776 - 0.23703703703703703703703703703703703703703703703706e-1 * t779 * t783 * t787 + 0.25283950617283950617283950617283950617283950617287e-2 * t720 * t615 / t780 / t685 * t9 / t795 * t193 * t800 / t680 + 0.39506172839506172839506172839506172839506172839507e-2 * t775 * t807 * t787 - 0.14467592592592592592592592592592592592592592592592e0 * t725 * t800 * t78 * t615 + 0.26041666666666666666666666666666666666666666666666e0 * t725 * t817 * t729 * t502 - 0.66666666666666666666666666666666666666666666666668e0 * t779 * t822 + 0.33333333333333333333333333333333333333333333333334e0 * t720 * t629 * t721 - 0.74074074074074074074074074074074074074074074074074e-1 * t768 * t331 * t615 * t721 - 0.13020833333333333333333333333333333333333333333333e0 * t725 * t728 * t78 * t629 - 0.15802469135802469135802469135802469135802469135804e-1 * t720 * t807 * t785 * t492 * t79 - 0.23703703703703703703703703703703703703703703703706e-1 * t841 * t782 * t131 * t16 * t786 + 0.35555555555555555555555555555555555555555555555559e-1 * t720 * t502 * t781 * t10 * t785 * t17 * t128 * t79 * t133 - 0.66666666666666666666666666666666666666666666666668e0 * t841 * t822 * t131 - 0.33333333333333333333333333333333333333333333333334e0 * t841 * t722 * t499 + 0.66666666666666666666666666666666666666666666666668e0 * t719 * t331 * t722 - 0.22222222222222222222222222222222222222222222222222e0 * t768 * t5 * t866 * t131 - 0.22222222222222222222222222222222222222222222222222e0 * t774 * t331 * t866 + 0.33333333333333333333333333333333333333333333333333e0 * t775 * t722 * t502
  t882 = t459 * t675 * t10
  t883 = t756 * t882
  t885 = t178 * t767 * t733
  t889 = t165 * t675 * t10
  t890 = t756 * t889
  t910 = -0.33333333333333333333333333333333333333333333333334e0 * t841 * t776 - 0.33333333333333333333333333333333333333333333333334e0 * t779 * t722 + 0.33333333333333333333333333333333333333333333333334e0 * t720 * t822 + 0.11851851851851851851851851851851851851851851851853e-1 * t720 * t783 * t787 + 0.11111111111111111111111111111111111111111111111111e0 * t775 * t866 + 0.86805555555555555555555555555555555555555555555553e-1 * t725 * t817 * t78 * t493 - 0.13020833333333333333333333333333333333333333333333e0 * t725 * t728 * t78 * t502
  t912 = t178 * t767 * t910
  t916 = 0.1e1 / t164 / t3
  t921 = t178 * t767 * t693
  t924 = t668 * t765
  t925 = t178 * t128
  t926 = t682 * t733
  t931 = t710 * t889
  t933 = t925 * t926 * t694
  t936 = t682 * t693
  t938 = t925 * t936 * t704
  t941 = 0.33140179753086419753086419753086419753086419753092e-2 * t678 * t683 * t693 * t695 * t133 - 0.24855134814814814814814814814814814814814814814819e-2 * t678 * t15 * t128 * t682 * t703 * t704 + 0.66280359506172839506172839506172839506172839506184e-2 * t710 * t165 * t677 * t714 + 0.39768215703703703703703703703703703703703703703711e-2 * t718 * t683 * t733 * t694 * t133 + 0.19884107851851851851851851851851851851851851851855e-2 * t718 * t683 * t693 * t704 * t133 + 0.19884107851851851851851851851851851851851851851855e-2 * t718 * t683 * t703 * t502 - 0.46396251654320987654320987654320987654320987654329e-2 * t718 * t749 * t703 * t493 - 0.17398594370370370370370370370370370370370370370373e-2 * t756 * t166 * t677 * t749 * t693 * t133 * t502 - 0.18641351111111111111111111111111111111111111111114e-3 * t766 * t178 * t767 * t876 - 0.62137837037037037037037037037037037037037037037046e-3 * t883 * t885 - 0.93206755555555555555555555555555555555555555555569e-3 * t890 * t912 + 0.69042041152263374485596707818930041152263374485607e-4 * t756 * t916 * t675 * t10 * t921 - 0.24855134814814814814814814814814814814814814814819e-2 * t924 * t925 * t926 * t695 - 0.49710269629629629629629629629629629629629629629638e-2 * t931 * t933 - 0.24855134814814814814814814814814814814814814814819e-2 * t931 * t938
  t942 = t710 * t765
  t943 = t682 * t910
  t952 = t178 * t613
  t954 = t952 * t936 * t493
  t957 = t488 ** 2
  t968 = t925 * t936 * t695
  t973 = t925 * t936 * t694
  t988 = t178 * t491
  t1001 = f.my_piecewise5(t155, 0, t153, 0, t625)
  t1007 = t988 * t936 * t133
  t1011 = t988 * t926 * t133
  t1015 = t988 * t936 * t502
  t1018 = -0.14913080888888888888888888888888888888888888888891e-2 * t942 * t925 * t943 * t694 - 0.14913080888888888888888888888888888888888888888891e-2 * t942 * t925 * t926 * t704 - 0.28997657283950617283950617283950617283950617283955e-2 * t890 * t954 + 0.19331771522633744855967078189300411522633744855970e-2 * t766 * t178 / t60 / t957 / t549 * t936 * t615 - 0.41425224691358024691358024691358024691358024691364e-2 * t668 * t889 * t968 - 0.16570089876543209876543209876543209876543209876546e-2 * t710 * t882 * t973 - 0.55233632921810699588477366255144032921810699588485e-3 / t666 * t162 * t765 * t925 * t936 * t695 * t694 - 0.17398594370370370370370370370370370370370370370373e-2 * t766 * t952 * t926 * t493 + 0.74565404444444444444444444444444444444444444444457e-3 * t766 * t988 * t943 * t133 + 0.74565404444444444444444444444444444444444444444457e-3 * t766 * t988 * t926 * t502 + 0.24855134814814814814814814814814814814814814814819e-3 * t766 * t988 * t936 * t629 - 0.49710269629629629629629629629629629629629629629637e-3 * t942 * t925 * t936 * t1001 + 0.82850449382716049382716049382716049382716049382729e-3 * t883 * t1007 + 0.24855134814814814814814814814814814814814814814819e-2 * t890 * t1011 + 0.12427567407407407407407407407407407407407407407409e-2 * t890 * t1015
  t1020 = f.my_piecewise3(t56, 0, t941 + t1018)
  t1021 = t297 * t233
  t1026 = t199 * t454
  t1032 = t231 * t166 * t208
  t1033 = t199 * t234
  t1048 = t240 * t165 * t208
  t1051 = t15 * t184
  t1052 = t1051 * t187
  t1053 = t199 * t201
  t1068 = t265 * t10 * t177
  t1086 = t256 * t224
  t1103 = t248 * t1068
  t1110 = 0.11930464711111111111111111111111111111111111111113e-1 * t249 * t257 * t1021 * t119 + 0.59652323555555555555555555555555555555555555555565e-2 * t249 * t257 * t1026 * t119 + 0.33140179753086419753086419753086419753086419753092e-2 * t1032 * t250 * t1033 * t94 + 0.99420539259259259259259259259259259259259259259274e-2 * t1032 * t257 * t1033 * t119 - 0.24855134814814814814814814814814814814814814814819e-2 * t1032 * t256 * t187 * t251 * t454 + 0.66280359506172839506172839506172839506172839506184e-2 * t1048 * t253 - 0.46396251654320987654320987654320987654320987654329e-2 * t249 * t1052 * t1053 * t233 + 0.69594377481481481481481481481481481481481481481492e-2 * t209 * t1051 * t215 * t1053 * t119 - 0.17398594370370370370370370370370370370370370370373e-2 * t209 * t1052 * t217 * t338 - 0.59652323555555555555555555555555555555555555555565e-2 * t206 * t1068 * t219 - 0.59652323555555555555555555555555555555555555555565e-2 * t209 * t216 * t297 * t94 * t119 - 0.29826161777777777777777777777777777777777777777783e-2 * t209 * t216 * t199 * t338 * t119 - 0.29826161777777777777777777777777777777777777777782e-2 * t209 * t216 * t217 * t370 - 0.29826161777777777777777777777777777777777777777782e-1 * t249 * t1086 * t199 * t226 * t233 - 0.99420539259259259259259259259259259259259259259275e-2 * t163 * t165 * t208 * t219 + 0.14913080888888888888888888888888888888888888888891e-1 * t209 * t213 * t224 * t217 * t226 + 0.19884107851851851851851851851851851851851851851855e-1 * t1048 * t259 + 0.39768215703703703703703703703703703703703703703711e-2 * t1103 * t253 + 0.39768215703703703703703703703703703703703703703711e-2 * t249 * t250 * t1021 * t94
  t1215 = -0.13020833333333333333333333333333333333333333333333e0 * t285 * t288 * t49 * t557 + 0.26041666666666666666666666666666666666666666666666e0 * t285 * t396 * t527 - 0.39062499999999999999999999999999999999999999999999e0 * t285 * t288 * t545 - 0.39062499999999999999999999999999999999999999999999e0 * t285 * t288 * t541 - 0.11718750000000000000000000000000000000000000000000e1 * t281 * t409 + 0.11718750000000000000000000000000000000000000000000e1 * t384 * t294 - 0.11718750000000000000000000000000000000000000000000e1 * t377 * t294 - 0.39062500000000000000000000000000000000000000000000e0 * (-0.11061728395061728395061728395061728395061728395062e0 * t524 - 0.14222222222222222222222222222222222222222222222223e0 * t529 + 0.14222222222222222222222222222222222222222222222223e0 * t534 - 0.21333333333333333333333333333333333333333333333334e0 * t539 + 0.10666666666666666666666666666666666666666666666667e0 * t543 + 0.10666666666666666666666666666666666666666666666667e0 * t547 - 0.35555555555555555555555555555555555555555555555557e-1 * t560 - 0.64000000000000000000000000000000000000000000000002e0 * t565 + 0.64000000000000000000000000000000000000000000000002e0 * t570 - 0.10666666666666666666666666666666666666666666666667e0 * t605) * t278 * t280 * t196 - 0.14467592592592592592592592592592592592592592592592e0 * t285 * t162 / t286 / t210 * t49 * t521 + 0.26041666666666666666666666666666666666666666666666e0 * t285 * t396 * t289 * t338 - 0.78124999999999999999999999999999999999999999999999e0 * t281 * t194 * t287 * t119 * t94 - 0.39062499999999999999999999999999999999999999999999e0 * t281 * t194 * t387 * t338 - 0.78125000000000000000000000000000000000000000000000e0 * t380 * t277 / t381 / t189 * t280 * t196 + 0.39062499999999999999999999999999999999999999999999e0 * t384 * t389 + 0.11718750000000000000000000000000000000000000000000e1 * t375 * t382 * t280 * t194 * t195 * t277 - 0.39062499999999999999999999999999999999999999999999e0 * t377 * t389 + 0.26041666666666666666666666666666666666666666666666e0 * t281 * t194 * t395 * t49 * t201 - 0.39062500000000000000000000000000000000000000000000e0 * t192 * t194 * t31 * t602
  t1260 = 0.19884107851851851851851851851851851851851851851855e-2 * t249 * t250 * t1026 * t94 + 0.19884107851851851851851851851851851851851851851855e-2 * t249 * t250 * t251 * t338 + 0.11930464711111111111111111111111111111111111111113e-1 * t1103 * t259 + 0.59652323555555555555555555555555555555555555555565e-2 * t249 * t257 * t251 * t370 - 0.11184810666666666666666666666666666666666666666668e-1 * t209 * t1086 * t199 * t119 * t370 - 0.15907286281481481481481481481481481481481481481485e-1 * t249 * t216 * t217 * t119 * t233 - 0.18641351111111111111111111111111111111111111111114e-3 * t175 * t178 * t269 * t1215 - 0.93206755555555555555555555555555555555555555555569e-3 * t163 * t165 * t308 * t10 * t271 - 0.18641351111111111111111111111111111111111111111114e-2 * t268 * t299 - 0.93206755555555555555555555555555555555555555555569e-3 * t274 * t414 - 0.18641351111111111111111111111111111111111111111114e-3 * t163 * t166 * (-0.880e3 / 0.27e2 * tau0 * t305 + 0.308e3 / 0.27e2 * t575) * t10 * t271 - 0.55924053333333333333333333333333333333333333333342e-3 * t311 * t299 - 0.55924053333333333333333333333333333333333333333342e-3 * t316 * t414 + 0.69042041152263374485596707818930041152263374485607e-4 * t163 * t916 * t172 * t10 * t271 - 0.62137837037037037037037037037037037037037037037046e-3 * t462 * t299 - 0.62137837037037037037037037037037037037037037037046e-3 * t163 * t459 * t265 * t10 * t271 + 0.74565404444444444444444444444444444444444444444457e-3 * t311 * t420 + 0.22369621333333333333333333333333333333333333333337e-2 * t311 * t425 - 0.29826161777777777777777777777777777777777777777782e-2 * t446 * t451
  t1314 = f.my_piecewise5(t153, 0, t155, 0, t553)
  t1323 = -0.17398594370370370370370370370370370370370370370373e-2 * t316 * t203 - 0.17398594370370370370370370370370370370370370370373e-2 * t175 * t185 * t428 * t201 - 0.11184810666666666666666666666666666666666666666668e-1 * t316 * t228 - 0.11184810666666666666666666666666666666666666666668e-1 * t175 * t222 * t224 * t297 * t226 - 0.24855134814814814814814814814814814814814814814819e-2 * t231 * t315 * t236 - 0.24855134814814814814814814814814814814814814814819e-2 * t232 * t222 * t428 * t234 - 0.49710269629629629629629629629629629629629629629638e-2 * t240 * t267 * t245 - 0.49710269629629629629629629629629629629629629629638e-2 * t243 * t451 - 0.24855134814814814814814814814814814814814814814819e-2 * t243 * t456 + 0.12427567407407407407407407407407407407407407407409e-2 * t274 * t434 + 0.22369621333333333333333333333333333333333333333337e-1 * t175 * t222 / t186 / t343 * t199 * t562 + 0.24855134814814814814814814814814814814814814814819e-3 * t175 * t418 * t200 * t557 + 0.22369621333333333333333333333333333333333333333337e-2 * t175 * t222 * t437 * t370 + 0.14913080888888888888888888888888888888888888888891e-2 * t316 * t430 - 0.14913080888888888888888888888888888888888888888891e-2 * t446 * t456 - 0.14913080888888888888888888888888888888888888888891e-2 * t449 * t222 * t428 * t454 - 0.49710269629629629629629629629629629629629629629637e-3 * t449 * t222 * t200 * t1314 + 0.82850449382716049382716049382716049382716049382729e-3 * t462 * t420 + 0.24855134814814814814814814814814814814814814814818e-2 * t462 * t425
  t1340 = t179 ** 2
  t1355 = t187 * t412
  t1392 = -0.55233632921810699588477366255144032921810699588485e-3 / t159 * t162 * t174 * t222 * t200 * t234 * t233 - 0.41425224691358024691358024691358024691358024691364e-2 * t231 * t242 * t236 - 0.16570089876543209876543209876543209876543209876546e-2 * t240 * t461 * t245 - 0.28997657283950617283950617283950617283950617283955e-2 * t274 * t203 + 0.19331771522633744855967078189300411522633744855970e-2 * t175 * t178 / t31 / t1340 / t549 * t200 * t521 - 0.18641351111111111111111111111111111111111111111114e-1 * t274 * t228 + 0.74565404444444444444444444444444444444444444444456e-3 * t175 * t222 * t423 * t602 + 0.74565404444444444444444444444444444444444444444457e-3 * t175 * t418 * t1355 * t94 + 0.22369621333333333333333333333333333333333333333337e-2 * t175 * t222 * t215 * t412 * t119 + 0.24855134814814814814814814814814814814814814814819e-2 * t268 * t420 + 0.74565404444444444444444444444444444444444444444454e-2 * t268 * t425 + 0.24855134814814814814814814814814814814814814814819e-2 * t274 * t430 + 0.74565404444444444444444444444444444444444444444454e-2 * t274 * t439 - 0.14913080888888888888888888888888888888888888888891e-2 * t240 * t310 * t245 + 0.44739242666666666666666666666666666666666666666673e-2 * t316 * t439 - 0.14913080888888888888888888888888888888888888888891e-2 * t449 * t222 * t1355 * t233 + 0.37282702222222222222222222222222222222222222222227e-2 * t274 * t443 + 0.74565404444444444444444444444444444444444444444457e-3 * t316 * t434 + 0.22369621333333333333333333333333333333333333333337e-2 * t316 * t443 + 0.74565404444444444444444444444444444444444444444457e-3 * t175 * t418 * t428 * t338
  t1395 = f.my_piecewise3(t8, 0, t1110 + t1260 + t1323 + t1392)
  t1404 = t85 * t149
  t1411 = -0.6e1 * t2 * t550 + 0.8e1 * t332 - 0.2e1 * t5
  t1415 = t1411 * t3
  t1416 = t140 * t149
  t1419 = t85 * t144
  t1422 = t510 * t149
  t1437 = -0.60000000000000000000000000000000000000000000000000e0 * t479 * t140 * t516 - 0.20000000000000000000000000000000000000000000000000e0 * t479 * t85 * (t609 + t636 - t637 * t142 + 0.3e1 * t510 * t514 * t140 - 0.2e1 * t512 * t140 / t513 / t141) - 0.60000000000000000000000000000000000000000000000000e0 * t479 * t510 * t144 - 0.20000000000000000000000000000000000000000000000000e0 * t479 * t637 * t149 - 0.12000000000000000000000000000000000000000000000000e1 * t657 * t658 - 0.60000000000000000000000000000000000000000000000000e0 * t657 * t661 + t1020 + t1395 - 0.20000000000000000000000000000000000000000000000000e0 * (0.12e2 * t331 - 0.36e2 * t551 + 0.24e2 * t2 / t549 / t3) * t3 * t1404 - 0.60000000000000000000000000000000000000000000000000e0 * t1411 * t85 * t149 - 0.60000000000000000000000000000000000000000000000000e0 * t1415 * t1416 - 0.60000000000000000000000000000000000000000000000000e0 * t1415 * t1419 - 0.60000000000000000000000000000000000000000000000000e0 * t657 * t1422 - 0.12000000000000000000000000000000000000000000000000e1 * t475 * t140 * t149 - 0.12000000000000000000000000000000000000000000000000e1 * t476 * t144 - 0.60000000000000000000000000000000000000000000000000e0 * t7 * t510 * t149 - 0.12000000000000000000000000000000000000000000000000e1 * t147 * t144 - 0.60000000000000000000000000000000000000000000000000e0 * t86 * t516
  t1463 = -0.82850449382716049382716049382716049382716049382728e-3 * t924 * t968 - 0.16570089876543209876543209876543209876543209876546e-2 * t931 * t973 + 0.13256071901234567901234567901234567901234567901237e-2 * t718 * t714 - 0.99420539259259259259259259259259259259259259259274e-3 * t942 * t933 - 0.49710269629629629629629629629629629629629629629637e-3 * t942 * t938 - 0.20712612345679012345679012345679012345679012345682e-3 * t883 * t921 + 0.82850449382716049382716049382716049382716049382729e-3 * t890 * t1007 - 0.62137837037037037037037037037037037037037037037046e-3 * t890 * t885 - 0.57995314567901234567901234567901234567901234567911e-3 * t766 * t954 + 0.49710269629629629629629629629629629629629629629638e-3 * t766 * t1011 + 0.24855134814814814814814814814814814814814814814819e-3 * t766 * t1015 - 0.18641351111111111111111111111111111111111111111114e-3 * t766 * t912
  t1464 = f.my_piecewise3(t56, 0, t1463)
  d111 = -0.12000000000000000000000000000000000000000000000000e1 * t86 * t144 - 0.12000000000000000000000000000000000000000000000000e1 * t147 * t149 + 0.3e1 * t471 - 0.12000000000000000000000000000000000000000000000000e1 * t476 * t149 + t3 * t1437 + 0.3e1 * t1464 - 0.12000000000000000000000000000000000000000000000000e1 * t479 * t658 - 0.60000000000000000000000000000000000000000000000000e0 * t479 * t661 - 0.60000000000000000000000000000000000000000000000000e0 * t1415 * t1404 - 0.12000000000000000000000000000000000000000000000000e1 * t657 * t1416 - 0.12000000000000000000000000000000000000000000000000e1 * t657 * t1419 - 0.60000000000000000000000000000000000000000000000000e0 * t479 * t1422

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r1 <= f.p.dens_threshold
  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t7 = 0.1e1 - t5 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = 0.1e1 + t5 <= f.p.zeta_threshold
  t11 = -t8
  t12 = f.my_piecewise5(t7, t8, t10, t11, -t5)
  t13 = 0.1e1 + t12
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = 2 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = t15 * t13 * t18
  t20 = t3 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = t21 * t3
  t24 = r1 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t30 = r1 ** 2
  t33 = s2 / t25 / t30
  t35 = 0.2e1 * tau1 / t25 / r1 - t33 / 0.4e1
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = 0.1e1 / jnp.pi
  t40 = t39 ** (0.1e1 / 0.3e1)
  t42 = 0.1e1 / t40 / t39
  t43 = t35 * t37 * t42
  t44 = t19 * t22 * t43
  t45 = 4 ** (0.1e1 / 0.3e1)
  t48 = 0.2e1 * r1 * t4 <= f.p.zeta_threshold
  t51 = 0.2e1 * r0 * t4 <= f.p.zeta_threshold
  t52 = f.my_piecewise5(t48, t8, t51, t11, -t5)
  t53 = 0.1e1 + t52
  t54 = t53 ** 2
  t55 = t3 ** 2
  t56 = t54 * t55
  t57 = t53 * t3
  t58 = t57 ** (0.1e1 / 0.3e1)
  t60 = 0.1e1 / t58 / t56
  t62 = 0.1e1 / t40
  t63 = t37 * t62
  t64 = t63 * t45
  t67 = (0.1e1 + 0.7e-2 * t33) ** (0.1e1 / 0.5e1)
  t68 = t67 ** 2
  t69 = t68 ** 2
  t74 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t64 * t33 / t69
  t75 = t74 ** 2
  t76 = t75 ** 2
  t77 = 0.1e1 / t76
  t78 = t45 * t60 * t77
  t81 = 0.1e1 / t74
  t83 = t64 * t17 / t58 * t81
  t85 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t83
  t86 = jnp.log(t85)
  t87 = t86 * t36
  t89 = t45 ** 2
  t90 = t89 * t18
  t95 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t87 * t40 * t90 * t58 * t74
  t96 = 0.1e1 / t55
  t97 = t2 * t96
  t98 = -t4 + t97
  t99 = f.my_piecewise5(t7, 0, t10, 0, t98)
  t100 = t95 * t99
  t101 = t55 * t3
  t102 = 0.1e1 / t101
  t103 = t2 * t102
  t105 = 0.2e1 * t96 - 0.2e1 * t103
  t106 = f.my_piecewise5(t48, 0, t51, 0, t105)
  t108 = f.my_piecewise5(t48, 0, t51, 0, t98)
  t110 = t106 * t3 + 0.2e1 * t108
  t112 = t78 * t100 * t110
  t115 = t54 * t53
  t116 = t115 * t101
  t118 = 0.1e1 / t58 / t116
  t120 = t45 * t118 * t77
  t122 = t108 * t3 + t52 + 0.1e1
  t123 = t122 ** 2
  t125 = t120 * t100 * t123
  t128 = t13 ** 2
  t130 = t15 * t128 * t18
  t132 = t130 * t22 * t43
  t133 = t95 * t122
  t135 = t120 * t133 * t110
  t138 = t15 * t18
  t140 = t138 * t22 * t43
  t141 = t99 ** 2
  t142 = t95 * t141
  t144 = t78 * t142 * t122
  t148 = 0.1e1 / t58 / t57
  t150 = t45 * t148 * t77
  t151 = f.my_piecewise5(t7, 0, t10, 0, t105)
  t153 = t150 * t100 * t151
  t157 = t19 * t21 * t43
  t159 = t78 * t100 * t122
  t162 = 0.1e1 / t53
  t163 = t162 * t4
  t164 = 0.1e1 / t85
  t165 = t122 * t164
  t168 = t40 * t89
  t169 = t87 * t168
  t170 = t58 ** 2
  t172 = t18 / t170
  t173 = t74 * t122
  t177 = 0.33333333333333333333333333333333333333333333333334e0 * t163 * t165 - 0.13020833333333333333333333333333333333333333333333e0 * t169 * t172 * t173
  t178 = t177 * t99
  t180 = t78 * t178 * t122
  t183 = t95 * t151
  t185 = t78 * t183 * t122
  t189 = t22 * t35 * t37
  t190 = t138 * t189
  t191 = t42 * t45
  t192 = t191 * t148
  t193 = t77 * t177
  t195 = t192 * t193 * t141
  t199 = t21 * t35 * t37
  t200 = t19 * t199
  t202 = t192 * t193 * t99
  t205 = t77 * t95
  t207 = t192 * t205 * t151
  t210 = t19 * t189
  t211 = 0.1e1 / t54
  t212 = t211 * t4
  t213 = t165 * t108
  t216 = t162 * t96
  t219 = t110 * t164
  t222 = t85 ** 2
  t223 = 0.1e1 / t222
  t224 = t123 * t223
  t225 = t224 * t37
  t226 = t163 * t225
  t227 = t62 * t45
  t228 = t17 * t148
  t229 = t228 * t81
  t230 = t227 * t229
  t233 = t211 * t96
  t234 = t123 * t164
  t239 = t18 / t170 / t57
  t240 = t74 * t123
  t248 = -0.33333333333333333333333333333333333333333333333334e0 * t212 * t213 - 0.33333333333333333333333333333333333333333333333334e0 * t216 * t165 + 0.33333333333333333333333333333333333333333333333334e0 * t163 * t219 + 0.11851851851851851851851851851851851851851851851853e-1 * t226 * t230 + 0.11111111111111111111111111111111111111111111111111e0 * t233 * t234 + 0.86805555555555555555555555555555555555555555555553e-1 * t169 * t239 * t240 - 0.13020833333333333333333333333333333333333333333333e0 * t169 * t172 * t74 * t110
  t249 = t77 * t248
  t251 = t192 * t249 * t99
  t255 = t192 * t193 * t151
  t258 = t130 * t199
  t259 = t191 * t118
  t261 = t259 * t205 * t123
  t264 = 0.1e1 / t20
  t266 = t264 * t35 * t37
  t267 = t19 * t266
  t269 = t192 * t205 * t99
  t272 = 0.19884107851851851851851851851851851851851851851855e-2 * t44 * t112 - 0.46396251654320987654320987654320987654320987654329e-2 * t44 * t125 - 0.17398594370370370370370370370370370370370370370373e-2 * t132 * t135 + 0.33140179753086419753086419753086419753086419753092e-2 * t140 * t144 - 0.24855134814814814814814814814814814814814814814819e-2 * t140 * t153 + 0.66280359506172839506172839506172839506172839506184e-2 * t157 * t159 + 0.39768215703703703703703703703703703703703703703711e-2 * t44 * t180 + 0.19884107851851851851851851851851851851851851851855e-2 * t44 * t185 - 0.24855134814814814814814814814814814814814814814819e-2 * t190 * t195 - 0.49710269629629629629629629629629629629629629629638e-2 * t200 * t202 - 0.24855134814814814814814814814814814814814814814819e-2 * t200 * t207 - 0.14913080888888888888888888888888888888888888888891e-2 * t210 * t251 - 0.14913080888888888888888888888888888888888888888891e-2 * t210 * t255 - 0.28997657283950617283950617283950617283950617283955e-2 * t258 * t261 - 0.16570089876543209876543209876543209876543209876546e-2 * t267 * t269
  t274 = 0.1e1 / t14 * t18
  t275 = t274 * t189
  t276 = t141 * t99
  t278 = t192 * t205 * t276
  t281 = t130 * t189
  t283 = t259 * t193 * t123
  t286 = t191 * t60
  t288 = t286 * t249 * t122
  t292 = t286 * t193 * t110
  t295 = t55 ** 2
  t296 = 0.1e1 / t295
  t297 = t2 * t296
  t299 = -0.6e1 * t102 + 0.6e1 * t297
  t300 = f.my_piecewise5(t48, 0, t51, 0, t299)
  t303 = t300 * t3 + 0.3e1 * t106
  t305 = t286 * t205 * t303
  t308 = f.my_piecewise5(t7, 0, t10, 0, t299)
  t310 = t192 * t205 * t308
  t313 = t130 * t266
  t315 = t286 * t205 * t122
  t319 = t286 * t193 * t122
  t323 = t286 * t205 * t110
  t326 = t54 ** 2
  t329 = 0.1e1 / t58 / t326 / t295
  t330 = t191 * t329
  t331 = t123 * t122
  t333 = t330 * t205 * t331
  t336 = t138 * t199
  t338 = t192 * t205 * t141
  t341 = t148 * t77
  t342 = 0.1e1 / t115
  t343 = t342 * t4
  t344 = t108 ** 2
  t345 = t165 * t344
  t354 = 0.1e1 / t222 / t85
  t356 = t331 * t354 * t36
  t358 = t40 ** 2
  t360 = 0.1e1 / t358 * t89
  t362 = 0.1e1 / t170 / t56
  t363 = t18 * t362
  t364 = 0.1e1 / t75
  t366 = t360 * t363 * t364
  t370 = t331 * t223 * t37
  t383 = t17 * t60
  t385 = t227 * t383 * t81
  t388 = t224 * t108
  t390 = t64 * t229
  t396 = t227 * t17
  t397 = t148 * t81
  t399 = t396 * t397 * t122
  t402 = t219 * t108
  t405 = t165 * t106
  t408 = t162 * t102
  t411 = t342 * t96
  t412 = t234 * t108
  t415 = t211 * t102
  t418 = t165 * t110
  t423 = t303 * t164
  t426 = t342 * t102
  t427 = t331 * t164
  t434 = 0.66666666666666666666666666666666666666666666666668e0 * t343 * t345 + 0.66666666666666666666666666666666666666666666666668e0 * t233 * t213 - 0.23703703703703703703703703703703703703703703703706e-1 * t216 * t225 * t230 + 0.25283950617283950617283950617283950617283950617287e-2 * t163 * t356 * t366 + 0.39506172839506172839506172839506172839506172839507e-2 * t233 * t370 * t230 - 0.14467592592592592592592592592592592592592592592592e0 * t169 * t363 * t74 * t331 + 0.26041666666666666666666666666666666666666666666666e0 * t169 * t239 * t173 * t110 - 0.15802469135802469135802469135802469135802469135804e-1 * t163 * t370 * t385 - 0.23703703703703703703703703703703703703703703703706e-1 * t212 * t388 * t390 + 0.35555555555555555555555555555555555555555555555559e-1 * t163 * t110 * t223 * t37 * t399 - 0.66666666666666666666666666666666666666666666666668e0 * t212 * t402 - 0.33333333333333333333333333333333333333333333333334e0 * t212 * t405 + 0.66666666666666666666666666666666666666666666666668e0 * t408 * t165 - 0.22222222222222222222222222222222222222222222222222e0 * t411 * t412 - 0.22222222222222222222222222222222222222222222222222e0 * t415 * t234 + 0.33333333333333333333333333333333333333333333333333e0 * t233 * t418 - 0.66666666666666666666666666666666666666666666666668e0 * t216 * t219 + 0.33333333333333333333333333333333333333333333333334e0 * t163 * t423 - 0.74074074074074074074074074074074074074074074074074e-1 * t426 * t427 - 0.13020833333333333333333333333333333333333333333333e0 * t169 * t172 * t74 * t303
  t436 = t191 * t341 * t434
  t440 = t191 * t341 * t177
  t444 = t191 * t341 * t248
  t448 = 0.1e1 / t20 / t3
  t450 = t448 * t35 * t37
  t451 = t130 * t450
  t453 = t191 * t341 * t95
  t456 = -0.55233632921810699588477366255144032921810699588485e-3 * t275 * t278 - 0.17398594370370370370370370370370370370370370370373e-2 * t281 * t283 + 0.74565404444444444444444444444444444444444444444457e-3 * t281 * t288 + 0.74565404444444444444444444444444444444444444444457e-3 * t281 * t292 + 0.24855134814814814814814814814814814814814814814819e-3 * t281 * t305 - 0.49710269629629629629629629629629629629629629629637e-3 * t210 * t310 + 0.82850449382716049382716049382716049382716049382729e-3 * t313 * t315 + 0.24855134814814814814814814814814814814814814814819e-2 * t258 * t319 + 0.12427567407407407407407407407407407407407407407409e-2 * t258 * t323 + 0.19331771522633744855967078189300411522633744855970e-2 * t281 * t333 - 0.41425224691358024691358024691358024691358024691364e-2 * t336 * t338 - 0.18641351111111111111111111111111111111111111111114e-3 * t281 * t436 - 0.62137837037037037037037037037037037037037037037046e-3 * t313 * t440 - 0.93206755555555555555555555555555555555555555555569e-3 * t258 * t444 + 0.69042041152263374485596707818930041152263374485607e-4 * t451 * t453
  t458 = f.my_piecewise3(t1, 0, t272 + t456)
  t460 = r0 <= f.p.dens_threshold
  t461 = f.my_piecewise5(t10, t8, t7, t11, t5)
  t462 = 0.1e1 + t461
  t463 = t462 ** 2
  t464 = t462 ** (0.1e1 / 0.3e1)
  t465 = t464 ** 2
  t467 = t465 * t463 * t18
  t468 = t467 * t22
  t469 = r0 ** (0.1e1 / 0.3e1)
  t470 = t469 ** 2
  t475 = r0 ** 2
  t477 = 0.1e1 / t470 / t475
  t478 = s0 * t477
  t480 = 0.2e1 * tau0 / t470 / r0 - t478 / 0.4e1
  t482 = t480 * t37 * t42
  t483 = t468 * t482
  t484 = f.my_piecewise5(t51, t8, t48, t11, t5)
  t485 = 0.1e1 + t484
  t486 = t485 ** 2
  t488 = t486 * t485 * t101
  t489 = t485 * t3
  t490 = t489 ** (0.1e1 / 0.3e1)
  t492 = 0.1e1 / t490 / t488
  t493 = t45 * t492
  t495 = 0.1e1 + 0.7e-2 * t478
  t496 = t495 ** (0.1e1 / 0.5e1)
  t497 = t496 ** 2
  t498 = t497 ** 2
  t499 = 0.1e1 / t498
  t503 = 0.1e1 + 0.83333333333333333333333333333333333333333333333333e-3 * t64 * t478 * t499
  t504 = t503 ** 2
  t505 = t504 ** 2
  t506 = 0.1e1 / t505
  t507 = t493 * t506
  t508 = 0.1e1 / t490
  t509 = t17 * t508
  t510 = 0.1e1 / t503
  t512 = t64 * t509 * t510
  t514 = 0.1e1 + 0.10666666666666666666666666666666666666666666666667e0 * t512
  t515 = jnp.log(t514)
  t516 = t515 * t36
  t517 = t516 * t40
  t518 = t490 * t503
  t519 = t90 * t518
  t522 = 0.1e1 - 0.39062500000000000000000000000000000000000000000000e0 * t517 * t519
  t523 = -t98
  t524 = f.my_piecewise5(t51, 0, t48, 0, t523)
  t526 = t524 * t3 + t484 + 0.1e1
  t527 = t522 * t526
  t528 = -t105
  t529 = f.my_piecewise5(t51, 0, t48, 0, t528)
  t532 = t529 * t3 + 0.2e1 * t524
  t534 = t507 * t527 * t532
  t539 = t475 * r0
  t541 = 0.1e1 / t470 / t539
  t542 = s0 * t541
  t544 = -0.10e2 / 0.3e1 * tau0 * t477 + 0.2e1 / 0.3e1 * t542
  t546 = t544 * t37 * t42
  t547 = t468 * t546
  t548 = t486 * t55
  t550 = 0.1e1 / t490 / t548
  t551 = t45 * t550
  t553 = 0.1e1 / t505 / t503
  t554 = t551 * t553
  t558 = s0 ** 2
  t559 = t475 ** 2
  t560 = t559 * t475
  t565 = 0.1e1 / t498 / t495
  t569 = -0.22222222222222222222222222222222222222222222222222e-2 * t64 * t542 * t499 + 0.12444444444444444444444444444444444444444444444445e-4 * t64 * t558 / t469 / t560 * t565
  t571 = t554 * t527 * t569
  t575 = 0.1e1 / t490 / t489
  t576 = t17 * t575
  t579 = t64 * t576 * t510 * t526
  t581 = 0.1e1 / t504
  t584 = t64 * t509 * t581 * t569
  t586 = -0.35555555555555555555555555555555555555555555555557e-1 * t579 - 0.10666666666666666666666666666666666666666666666667e0 * t584
  t587 = 0.1e1 / t514
  t588 = t586 * t587
  t589 = t36 * t40
  t590 = t588 * t589
  t593 = t516 * t168
  t594 = t490 ** 2
  t595 = 0.1e1 / t594
  t596 = t18 * t595
  t597 = t503 * t526
  t601 = t490 * t569
  t602 = t90 * t601
  t605 = -0.39062500000000000000000000000000000000000000000000e0 * t590 * t519 - 0.13020833333333333333333333333333333333333333333333e0 * t593 * t596 * t597 - 0.39062500000000000000000000000000000000000000000000e0 * t517 * t602
  t606 = t605 * t526
  t608 = t554 * t606 * t569
  t611 = t522 * t532
  t613 = t554 * t611 * t569
  t617 = 0.1e1 / t470 / t559
  t618 = s0 * t617
  t629 = t558 * s0
  t630 = t559 ** 2
  t634 = t495 ** 2
  t636 = 0.1e1 / t498 / t634
  t640 = 0.81481481481481481481481481481481481481481481481481e-2 * t64 * t618 * t499 - 0.11200000000000000000000000000000000000000000000000e-3 * t64 * t558 / t469 / t559 / t539 * t565 + 0.41813333333333333333333333333333333333333333333336e-6 * t64 * t629 / t630 / t475 * t636
  t642 = t554 * t527 * t640
  t646 = t465 * t462 * t18
  t647 = t646 * t22
  t648 = t647 * t482
  t649 = t45 * t575
  t651 = 0.1e1 / t505 / t504
  t652 = t649 * t651
  t653 = t569 ** 2
  t654 = t522 * t653
  t655 = f.my_piecewise5(t10, 0, t7, 0, t523)
  t657 = t652 * t654 * t655
  t660 = t467 * t21
  t661 = t660 * t482
  t664 = t569 * t655
  t666 = t554 * t527 * t664
  t670 = t22 * t480 * t37
  t671 = t467 * t670
  t672 = t575 * t506
  t673 = t559 * r0
  t675 = 0.1e1 / t470 / t673
  t676 = s0 * t675
  t692 = t558 ** 2
  t699 = 0.1e1 / t498 / t634 / t495
  t703 = -0.38024691358024691358024691358024691358024691358024e-1 * t64 * t676 * t499 + 0.94301234567901234567901234567901234567901234567901e-3 * t64 * t558 / t469 / t630 * t565 - 0.79445333333333333333333333333333333333333333333337e-5 * t64 * t629 / t630 / t539 * t636 + 0.21854435555555555555555555555555555555555555555558e-7 * t64 * t692 / t470 / t630 / t673 * t699
  t705 = t90 * t490 * t703
  t708 = t569 * t532
  t712 = -t299
  t713 = f.my_piecewise5(t51, 0, t48, 0, t712)
  t716 = t713 * t3 + 0.3e1 * t529
  t717 = t503 * t716
  t722 = 0.1e1 / t594 / t489
  t723 = t18 * t722
  t724 = t526 ** 2
  t725 = t569 * t724
  t729 = t640 * t526
  t734 = t90 * t490 * t640
  t737 = t586 ** 2
  t738 = t514 ** 2
  t739 = 0.1e1 / t738
  t741 = t737 * t739 * t589
  t744 = t17 * t550
  t747 = t64 * t744 * t510 * t724
  t750 = t63 * t45 * t17
  t751 = t575 * t581
  t752 = t526 * t569
  t754 = t750 * t751 * t752
  t758 = t64 * t576 * t510 * t532
  t760 = t504 * t503
  t761 = 0.1e1 / t760
  t764 = t64 * t509 * t761 * t653
  t768 = t64 * t509 * t581 * t640
  t770 = 0.47407407407407407407407407407407407407407407407409e-1 * t747 + 0.71111111111111111111111111111111111111111111111114e-1 * t754 - 0.35555555555555555555555555555555555555555555555557e-1 * t758 + 0.21333333333333333333333333333333333333333333333334e0 * t764 - 0.10666666666666666666666666666666666666666666666667e0 * t768
  t772 = t770 * t587 * t589
  t776 = t724 * t526
  t779 = t64 * t17 * t492 * t510 * t776
  t781 = t550 * t581
  t783 = t750 * t781 * t725
  t785 = t550 * t510
  t788 = t750 * t785 * t526 * t532
  t790 = t575 * t761
  t793 = t750 * t790 * t526 * t653
  t796 = t750 * t751 * t708
  t799 = t750 * t751 * t729
  t803 = t64 * t576 * t510 * t716
  t805 = t653 * t569
  t808 = t64 * t509 * t506 * t805
  t810 = t508 * t761
  t811 = t569 * t640
  t813 = t750 * t810 * t811
  t817 = t64 * t509 * t581 * t703
  t819 = -0.11061728395061728395061728395061728395061728395062e0 * t779 - 0.14222222222222222222222222222222222222222222222223e0 * t783 + 0.14222222222222222222222222222222222222222222222223e0 * t788 - 0.21333333333333333333333333333333333333333333333334e0 * t793 + 0.10666666666666666666666666666666666666666666666667e0 * t796 + 0.10666666666666666666666666666666666666666666666667e0 * t799 - 0.35555555555555555555555555555555555555555555555557e-1 * t803 - 0.64000000000000000000000000000000000000000000000002e0 * t808 + 0.64000000000000000000000000000000000000000000000002e0 * t813 - 0.10666666666666666666666666666666666666666666666667e0 * t817
  t821 = t819 * t587 * t589
  t825 = 0.1e1 / t594 / t548
  t826 = t18 * t825
  t832 = t723 * t597 * t532
  t835 = t595 * t569
  t837 = t90 * t835 * t526
  t840 = t595 * t503
  t842 = t90 * t840 * t532
  t847 = 0.1e1 / t738 / t514
  t849 = t737 * t586 * t847 * t589
  t853 = t90 * t840 * t526
  t859 = t90 * t518 * t586
  t866 = t90 * t722 * t503 * t724
  t869 = -0.39062500000000000000000000000000000000000000000000e0 * t517 * t705 - 0.39062499999999999999999999999999999999999999999999e0 * t593 * t596 * t708 - 0.13020833333333333333333333333333333333333333333333e0 * t593 * t596 * t717 + 0.26041666666666666666666666666666666666666666666666e0 * t593 * t723 * t725 - 0.39062499999999999999999999999999999999999999999999e0 * t593 * t596 * t729 - 0.11718750000000000000000000000000000000000000000000e1 * t590 * t734 + 0.11718750000000000000000000000000000000000000000000e1 * t741 * t602 - 0.11718750000000000000000000000000000000000000000000e1 * t772 * t602 - 0.39062500000000000000000000000000000000000000000000e0 * t821 * t519 - 0.14467592592592592592592592592592592592592592592592e0 * t593 * t826 * t503 * t776 + 0.26041666666666666666666666666666666666666666666666e0 * t593 * t832 - 0.78124999999999999999999999999999999999999999999999e0 * t590 * t837 - 0.39062499999999999999999999999999999999999999999999e0 * t590 * t842 - 0.78125000000000000000000000000000000000000000000000e0 * t849 * t519 + 0.39062499999999999999999999999999999999999999999999e0 * t741 * t853 + 0.11718750000000000000000000000000000000000000000000e1 * t770 * t739 * t589 * t859 - 0.39062499999999999999999999999999999999999999999999e0 * t772 * t853 + 0.26041666666666666666666666666666666666666666666666e0 * t590 * t866
  t871 = t191 * t672 * t869
  t874 = t551 * t506
  t875 = t605 * t655
  t877 = t874 * t875 * t526
  t880 = t551 * t651
  t882 = t880 * t527 * t653
  t885 = t646 * t21
  t886 = t885 * t482
  t887 = t649 * t553
  t888 = t522 * t655
  t890 = t887 * t888 * t569
  t893 = t647 * t546
  t895 = t874 * t888 * t526
  t898 = f.my_piecewise5(t10, 0, t7, 0, t528)
  t899 = t522 * t898
  t901 = t874 * t899 * t526
  t905 = t874 * t888 * t532
  t911 = t887 * t875 * t569
  t915 = t887 * t899 * t569
  t919 = t887 * t888 * t640
  t922 = -0.17398594370370370370370370370370370370370370370373e-2 * t483 * t534 - 0.59652323555555555555555555555555555555555555555565e-2 * t547 * t571 - 0.59652323555555555555555555555555555555555555555565e-2 * t483 * t608 - 0.29826161777777777777777777777777777777777777777783e-2 * t483 * t613 - 0.29826161777777777777777777777777777777777777777782e-2 * t483 * t642 - 0.29826161777777777777777777777777777777777777777782e-1 * t648 * t657 - 0.99420539259259259259259259259259259259259259259275e-2 * t661 * t571 - 0.15907286281481481481481481481481481481481481481485e-1 * t648 * t666 - 0.18641351111111111111111111111111111111111111111114e-3 * t671 * t871 + 0.39768215703703703703703703703703703703703703703711e-2 * t648 * t877 + 0.14913080888888888888888888888888888888888888888891e-1 * t483 * t882 + 0.19884107851851851851851851851851851851851851851855e-1 * t886 * t890 + 0.39768215703703703703703703703703703703703703703711e-2 * t893 * t895 + 0.19884107851851851851851851851851851851851851851855e-2 * t648 * t901 + 0.19884107851851851851851851851851851851851851851855e-2 * t648 * t905 + 0.11930464711111111111111111111111111111111111111113e-1 * t893 * t890 + 0.11930464711111111111111111111111111111111111111113e-1 * t648 * t911 + 0.59652323555555555555555555555555555555555555555565e-2 * t648 * t915 + 0.59652323555555555555555555555555555555555555555565e-2 * t648 * t919
  t923 = t522 * t569
  t925 = t652 * t923 * t640
  t928 = t465 * t18
  t929 = t928 * t22
  t930 = t929 * t482
  t931 = t655 ** 2
  t932 = t522 * t931
  t934 = t874 * t932 * t526
  t938 = t887 * t932 * t569
  t941 = t649 * t506
  t943 = t941 * t888 * t898
  t948 = t522 * t724
  t950 = t507 * t948 * t655
  t953 = t493 * t553
  t955 = t953 * t948 * t569
  t958 = t646 * t670
  t959 = t191 * t575
  t968 = t503 * t724
  t981 = -0.39062500000000000000000000000000000000000000000000e0 * t772 * t519 + 0.39062500000000000000000000000000000000000000000000e0 * t741 * t519 - 0.26041666666666666666666666666666666666666666666666e0 * t590 * t853 - 0.78125000000000000000000000000000000000000000000000e0 * t590 * t602 + 0.86805555555555555555555555555555555555555555555553e-1 * t593 * t723 * t968 - 0.26041666666666666666666666666666666666666666666666e0 * t593 * t596 * t752 - 0.13020833333333333333333333333333333333333333333333e0 * t593 * t596 * t503 * t532 - 0.39062500000000000000000000000000000000000000000000e0 * t517 * t734
  t982 = t506 * t981
  t984 = t959 * t982 * t655
  t987 = t191 * t550
  t989 = t987 * t982 * t526
  t992 = t553 * t981
  t994 = t959 * t992 * t569
  t998 = t21 * t544 * t37
  t999 = t467 * t998
  t1000 = t506 * t522
  t1002 = t987 * t1000 * t526
  t1005 = t553 * t522
  t1007 = t959 * t1005 * t569
  t1011 = t21 * t480 * t37
  t1012 = t467 * t1011
  t1013 = t506 * t605
  t1015 = t987 * t1013 * t526
  t1018 = t553 * t605
  t1020 = t959 * t1018 * t569
  t1026 = 0.80e2 / 0.9e1 * tau0 * t541 - 0.22e2 / 0.9e1 * t618
  t1028 = t22 * t1026 * t37
  t1029 = t646 * t1028
  t1031 = t959 * t1000 * t655
  t1034 = t467 * t1028
  t1040 = t22 * t544 * t37
  t1041 = t646 * t1040
  t1043 = t959 * t1013 * t655
  t1046 = t467 * t1040
  t1047 = t191 * t492
  t1049 = t1047 * t1000 * t724
  t1052 = -0.11184810666666666666666666666666666666666666666668e-1 * t483 * t925 + 0.33140179753086419753086419753086419753086419753092e-2 * t930 * t934 + 0.99420539259259259259259259259259259259259259259274e-2 * t930 * t938 - 0.24855134814814814814814814814814814814814814814819e-2 * t930 * t943 + 0.66280359506172839506172839506172839506172839506184e-2 * t886 * t895 - 0.46396251654320987654320987654320987654320987654329e-2 * t648 * t950 + 0.69594377481481481481481481481481481481481481481492e-2 * t483 * t955 - 0.14913080888888888888888888888888888888888888888891e-2 * t958 * t984 + 0.74565404444444444444444444444444444444444444444457e-3 * t671 * t989 + 0.22369621333333333333333333333333333333333333333337e-2 * t671 * t994 + 0.24855134814814814814814814814814814814814814814819e-2 * t999 * t1002 + 0.74565404444444444444444444444444444444444444444454e-2 * t999 * t1007 + 0.24855134814814814814814814814814814814814814814819e-2 * t1012 * t1015 + 0.74565404444444444444444444444444444444444444444454e-2 * t1012 * t1020 - 0.14913080888888888888888888888888888888888888888891e-2 * t1029 * t1031 + 0.74565404444444444444444444444444444444444444444457e-3 * t1034 * t1002 + 0.22369621333333333333333333333333333333333333333337e-2 * t1034 * t1007 - 0.29826161777777777777777777777777777777777777777782e-2 * t1041 * t1043 - 0.17398594370370370370370370370370370370370370370373e-2 * t1046 * t1049
  t1055 = t1047 * t1013 * t724
  t1058 = t651 * t522
  t1060 = t959 * t1058 * t653
  t1065 = t959 * t651 * t605 * t653
  t1068 = t928 * t670
  t1070 = t959 * t1013 * t931
  t1073 = t646 * t998
  t1076 = t646 * t1011
  t1080 = t959 * t1000 * t898
  t1084 = t959 * t1005 * t640
  t1088 = t987 * t1000 * t532
  t1092 = 0.1e1 / t505 / t760
  t1095 = t959 * t1092 * t522 * t805
  t1099 = 0.1e1 / t464 * t18
  t1100 = t1099 * t670
  t1101 = t931 * t655
  t1103 = t959 * t1000 * t1101
  t1106 = t928 * t1011
  t1108 = t959 * t1000 * t931
  t1112 = t264 * t480 * t37
  t1113 = t646 * t1112
  t1118 = t486 ** 2
  t1121 = 0.1e1 / t490 / t1118 / t295
  t1122 = t191 * t1121
  t1124 = t1122 * t1000 * t776
  t1130 = t959 * t1005 * t703
  t1136 = t959 * t1013 * t898
  t1139 = -0.17398594370370370370370370370370370370370370370373e-2 * t671 * t1055 - 0.11184810666666666666666666666666666666666666666668e-1 * t1046 * t1060 - 0.11184810666666666666666666666666666666666666666668e-1 * t671 * t1065 - 0.24855134814814814814814814814814814814814814814819e-2 * t1068 * t1070 - 0.49710269629629629629629629629629629629629629629638e-2 * t1073 * t1031 - 0.49710269629629629629629629629629629629629629629638e-2 * t1076 * t1043 - 0.24855134814814814814814814814814814814814814814819e-2 * t1076 * t1080 + 0.37282702222222222222222222222222222222222222222227e-2 * t1012 * t1084 + 0.12427567407407407407407407407407407407407407407409e-2 * t1012 * t1088 + 0.22369621333333333333333333333333333333333333333337e-1 * t671 * t1095 - 0.55233632921810699588477366255144032921810699588485e-3 * t1100 * t1103 - 0.41425224691358024691358024691358024691358024691364e-2 * t1106 * t1108 - 0.16570089876543209876543209876543209876543209876546e-2 * t1113 * t1031 - 0.28997657283950617283950617283950617283950617283955e-2 * t1012 * t1049 + 0.19331771522633744855967078189300411522633744855970e-2 * t671 * t1124 - 0.18641351111111111111111111111111111111111111111114e-1 * t1012 * t1060 + 0.74565404444444444444444444444444444444444444444456e-3 * t671 * t1130 - 0.14913080888888888888888888888888888888888888888891e-2 * t1041 * t1080 - 0.14913080888888888888888888888888888888888888888891e-2 * t958 * t1136
  t1140 = f.my_piecewise5(t10, 0, t7, 0, t712)
  t1142 = t959 * t1000 * t1140
  t1145 = t467 * t1112
  t1157 = t987 * t1013 * t532
  t1161 = t987 * t1000 * t716
  t1165 = t959 * t1018 * t640
  t1170 = t928 * t1040
  t1174 = t21 * t1026 * t37
  t1175 = t467 * t1174
  t1177 = t191 * t672 * t522
  t1181 = t191 * t672 * t605
  t1185 = t191 * t672 * t981
  t1191 = -0.880e3 / 0.27e2 * tau0 * t617 + 0.308e3 / 0.27e2 * t676
  t1193 = t22 * t1191 * t37
  t1194 = t467 * t1193
  t1202 = t448 * t480 * t37
  t1203 = t467 * t1202
  t1209 = t264 * t544 * t37
  t1210 = t467 * t1209
  t1213 = -0.49710269629629629629629629629629629629629629629637e-3 * t958 * t1142 + 0.82850449382716049382716049382716049382716049382729e-3 * t1145 * t1002 + 0.24855134814814814814814814814814814814814814814818e-2 * t1145 * t1007 + 0.74565404444444444444444444444444444444444444444457e-3 * t1046 * t1088 + 0.22369621333333333333333333333333333333333333333337e-2 * t1046 * t1084 + 0.44739242666666666666666666666666666666666666666673e-2 * t1046 * t1020 + 0.74565404444444444444444444444444444444444444444457e-3 * t671 * t1157 + 0.24855134814814814814814814814814814814814814814819e-3 * t671 * t1161 + 0.22369621333333333333333333333333333333333333333337e-2 * t671 * t1165 + 0.14913080888888888888888888888888888888888888888891e-2 * t1046 * t1015 - 0.24855134814814814814814814814814814814814814814819e-2 * t1170 * t1108 - 0.93206755555555555555555555555555555555555555555569e-3 * t1175 * t1177 - 0.18641351111111111111111111111111111111111111111114e-2 * t999 * t1181 - 0.93206755555555555555555555555555555555555555555569e-3 * t1012 * t1185 - 0.18641351111111111111111111111111111111111111111114e-3 * t1194 * t1177 - 0.55924053333333333333333333333333333333333333333342e-3 * t1034 * t1181 - 0.55924053333333333333333333333333333333333333333342e-3 * t1046 * t1185 + 0.69042041152263374485596707818930041152263374485607e-4 * t1203 * t1177 - 0.62137837037037037037037037037037037037037037037046e-3 * t1145 * t1181 - 0.62137837037037037037037037037037037037037037037046e-3 * t1210 * t1177
  t1216 = f.my_piecewise3(t460, 0, t922 + t1052 + t1139 + t1213)
  t1220 = t2 ** 2
  t1221 = t295 * t3
  t1222 = 0.1e1 / t1221
  t1225 = 0.24e2 * t1220 * t1222 + 0.12e2 * t102 - 0.36e2 * t297
  t1227 = f.my_piecewise3(t460, 0, t512 / 0.9e1)
  t1228 = 0.63e0 * t1227
  t1230 = f.my_piecewise3(t1, 0, t83 / 0.9e1)
  t1231 = 0.63e0 * t1230
  t1232 = t1228 + t1231
  t1234 = 0.1e1 + t1228 + t1231
  t1235 = jnp.log(t1234)
  t1236 = t1228 + t1231 - t1235
  t1241 = 0.2e1 * t1220 * t102 - 0.2e1 * t97
  t1245 = f.my_piecewise3(t460, 0, -t579 / 0.27e2 - t584 / 0.9e1)
  t1246 = 0.63e0 * t1245
  t1251 = f.my_piecewise3(t1, 0, -t64 * t228 * t81 * t122 / 0.27e2)
  t1252 = 0.63e0 * t1251
  t1253 = t1246 + t1252
  t1254 = t1241 * t1253
  t1255 = 0.1e1 / t1234
  t1257 = -t1253 * t1255 + t1246 + t1252
  t1260 = t1241 * t1232
  t1267 = f.my_piecewise3(t460, 0, 0.4e1 / 0.81e2 * t747 + 0.2e1 / 0.27e2 * t754 - t758 / 0.27e2 + 0.2e1 / 0.9e1 * t764 - t768 / 0.9e1)
  t1268 = 0.63e0 * t1267
  t1278 = f.my_piecewise3(t1, 0, 0.4e1 / 0.81e2 * t64 * t383 * t81 * t123 - t64 * t228 * t81 * t110 / 0.27e2)
  t1279 = 0.63e0 * t1278
  t1280 = t1268 + t1279
  t1282 = t1253 ** 2
  t1283 = t1234 ** 2
  t1284 = 0.1e1 / t1283
  t1286 = -t1280 * t1255 + t1282 * t1284 + t1268 + t1279
  t1293 = -0.6e1 * t1220 * t296 + 0.8e1 * t103 - 0.2e1 * t96
  t1294 = t1293 * t1232
  t1298 = -t1220 * t96 + 0.1e1
  t1299 = t1298 * t1232
  t1311 = f.my_piecewise3(t460, 0, -0.28e2 / 0.243e3 * t779 - 0.4e1 / 0.27e2 * t783 + 0.4e1 / 0.27e2 * t788 - 0.2e1 / 0.9e1 * t793 + t796 / 0.9e1 + t799 / 0.9e1 - t803 / 0.27e2 - 0.2e1 / 0.3e1 * t808 + 0.2e1 / 0.3e1 * t813 - t817 / 0.9e1)
  t1312 = 0.63e0 * t1311
  t1313 = t17 * t118
  t1318 = t60 * t81
  t1319 = t122 * t110
  t1328 = f.my_piecewise3(t1, 0, -0.28e2 / 0.243e3 * t64 * t1313 * t81 * t331 + 0.4e1 / 0.27e2 * t750 * t1318 * t1319 - t64 * t228 * t81 * t303 / 0.27e2)
  t1329 = 0.63e0 * t1328
  t1330 = t1312 + t1329
  t1337 = 0.1e1 / t1283 / t1234
  t1340 = 0.3e1 * t1280 * t1284 * t1253 - 0.2e1 * t1282 * t1253 * t1337 - t1330 * t1255 + t1312 + t1329
  t1362 = t1026 * t37 * t42
  t1363 = t647 * t1362
  t1372 = t981 * t655
  t1377 = t605 * t898
  t1386 = -0.11930464711111111111111111111111111111111111111113e-1 * t547 * t613 - 0.11930464711111111111111111111111111111111111111113e-1 * t547 * t642 - 0.11930464711111111111111111111111111111111111111113e-1 * t483 * t554 * t981 * t526 * t569 - 0.11930464711111111111111111111111111111111111111113e-1 * t483 * t554 * t605 * t532 * t569 - 0.11930464711111111111111111111111111111111111111113e-1 * t483 * t554 * t606 * t640 + 0.23860929422222222222222222222222222222222222222226e-1 * t1363 * t890 + 0.47721858844444444444444444444444444444444444444452e-1 * t893 * t911 + 0.23860929422222222222222222222222222222222222222226e-1 * t893 * t915 + 0.23860929422222222222222222222222222222222222222226e-1 * t893 * t919 + 0.23860929422222222222222222222222222222222222222226e-1 * t648 * t887 * t1372 * t569 + 0.23860929422222222222222222222222222222222222222226e-1 * t648 * t887 * t1377 * t569 + 0.26512143802469135802469135802469135802469135802473e-1 * t886 * t877 + 0.13256071901234567901234567901234567901234567901237e-1 * t886 * t901
  t1391 = t605 * t724
  t1417 = t1099 * t22 * t482
  t1418 = t522 * t1101
  t1424 = t928 * t21 * t482
  t1439 = 0.13256071901234567901234567901234567901234567901237e-1 * t886 * t905 - 0.18558500661728395061728395061728395061728395061732e-1 * t893 * t950 - 0.18558500661728395061728395061728395061728395061732e-1 * t648 * t507 * t1391 * t655 - 0.92792503308641975308641975308641975308641975308657e-2 * t648 * t507 * t948 * t898 + 0.27837750992592592592592592592592592592592592592596e-1 * t547 * t955 + 0.27837750992592592592592592592592592592592592592596e-1 * t483 * t953 * t1391 * t569 + 0.13918875496296296296296296296296296296296296296298e-1 * t483 * t953 * t948 * t640 - 0.30930834436213991769547325102880658436213991769552e-1 * t886 * t950 - 0.15465417218106995884773662551440329218106995884776e-1 * t930 * t507 * t948 * t931 + 0.88373812674897119341563786008230452674897119341577e-2 * t1417 * t887 * t1418 * t569 + 0.66280359506172839506172839506172839506172839506184e-1 * t1424 * t938 - 0.99420539259259259259259259259259259259259259259274e-1 * t930 * t652 * t932 * t653 - 0.33140179753086419753086419753086419753086419753092e-2 * t1417 * t941 * t932 * t898 - 0.23198125827160493827160493827160493827160493827164e-2 * t483 * t507 * t527 * t716
  t1446 = t655 * t640
  t1483 = t569 * t898
  t1492 = -0.11930464711111111111111111111111111111111111111113e-1 * t468 * t1362 * t571 - 0.23860929422222222222222222222222222222222222222225e-1 * t547 * t608 - 0.11930464711111111111111111111111111111111111111113e0 * t648 * t652 * t923 * t1446 + 0.59652323555555555555555555555555555555555555555564e-1 * t483 * t880 * t527 * t811 - 0.18558500661728395061728395061728395061728395061732e-1 * t648 * t507 * t527 * t655 * t532 + 0.27837750992592592592592592592592592592592592592596e-1 * t483 * t953 * t527 * t708 + 0.13256071901234567901234567901234567901234567901237e-1 * t930 * t874 * t888 * t898 * t526 - 0.63629145125925925925925925925925925925925925925937e-1 * t893 * t666 - 0.63629145125925925925925925925925925925925925925937e-1 * t648 * t554 * t606 * t664 - 0.31814572562962962962962962962962962962962962962969e-1 * t648 * t554 * t611 * t664 - 0.31814572562962962962962962962962962962962962962969e-1 * t648 * t554 * t527 * t1446 - 0.31814572562962962962962962962962962962962962962969e-1 * t648 * t554 * t527 * t1483 + 0.39768215703703703703703703703703703703703703703710e-1 * t930 * t887 * t888 * t1483
  t1532 = -0.53024287604938271604938271604938271604938271604949e-1 * t930 * t554 * t527 * t569 * t931 - 0.10604857520987654320987654320987654320987654320990e0 * t886 * t666 + 0.74234002646913580246913580246913580246913580246928e-1 * t648 * t953 * t948 * t664 + 0.15907286281481481481481481481481481481481481481484e0 * t648 * t880 * t527 * t653 * t655 + 0.49710269629629629629629629629629629629629629629638e-2 * t1012 * t989 + 0.14913080888888888888888888888888888888888888888891e-1 * t1012 * t994 - 0.19884107851851851851851851851851851851851851851855e-2 * t646 * t1193 * t1031 - 0.16570089876543209876543209876543209876543209876546e-1 * t1106 * t1070 - 0.33140179753086419753086419753086419753086419753092e-2 * t1113 * t1080 - 0.11599062913580246913580246913580246913580246913582e-1 * t999 * t1049 - 0.11599062913580246913580246913580246913580246913582e-1 * t1012 * t1055 + 0.77327086090534979423868312757201646090534979423880e-2 * t1046 * t1124 + 0.77327086090534979423868312757201646090534979423880e-2 * t671 * t1122 * t1013 * t776 - 0.74565404444444444444444444444444444444444444444454e-1 * t999 * t1060
  t1537 = t505 ** 2
  t1540 = t653 ** 2
  t1554 = t532 ** 2
  t1565 = t931 ** 2
  t1585 = -0.74565404444444444444444444444444444444444444444454e-1 * t1012 * t1065 - 0.15658734933333333333333333333333333333333333333336e0 * t671 * t959 / t1537 * t522 * t1540 - 0.38663543045267489711934156378600823045267489711940e-2 * t1145 * t1049 - 0.49710269629629629629629629629629629629629629629637e-2 * t1068 * t959 * t982 * t931 - 0.49710269629629629629629629629629629629629629629637e-2 * t928 * t1028 * t1108 - 0.17398594370370370370370370370370370370370370370373e-2 * t671 * t1047 * t1000 * t1554 - 0.69594377481481481481481481481481481481481481481492e-2 * t1046 * t1055 + 0.18411210973936899862825788751714677640603566529495e-3 / t464 / t462 * t18 * t670 * t959 * t1000 * t1565 - 0.36822421947873799725651577503429355281207133058990e-2 * t1099 * t1011 * t1103 - 0.55233632921810699588477366255144032921810699588486e-2 * t928 * t1112 * t1108 - 0.99420539259259259259259259259259259259259259259274e-2 * t1076 * t984 + 0.29826161777777777777777777777777777777777777777782e-2 * t1046 * t1157 + 0.29826161777777777777777777777777777777777777777783e-2 * t671 * t959 * t553 * t869 * t569
  t1609 = s0 / t470 / t560
  t1634 = t630 ** 2
  t1639 = t634 ** 2
  t1645 = 0.21547325102880658436213991769547325102880658436214e0 * t64 * t1609 * t499 - 0.84262716049382716049382716049382716049382716049383e-2 * t64 * t558 / t469 / t630 / r0 * t565 + 0.11907508148148148148148148148148148148148148148149e-3 * t64 * t629 / t630 / t559 * t636 - 0.71391156148148148148148148148148148148148148148155e-6 * t64 * t692 / t470 / t630 / t560 * t699 + 0.15502079620740740740740740740740740740740740740743e-8 * t64 * t692 * s0 / t469 / t1634 / r0 / t498 / t1639
  t1660 = -0.99420539259259259259259259259259259259259259259275e-2 * t1073 * t1080 - 0.99420539259259259259259259259259259259259259259275e-2 * t1076 * t1136 - 0.33140179753086419753086419753086419753086419753092e-2 * t1076 * t1142 - 0.24855134814814814814814814814814814814814814814818e-1 * t1145 * t1060 + 0.89478485333333333333333333333333333333333333333347e-2 * t1046 * t994 + 0.73644843895747599451303155006858710562414266117982e-3 * t646 * t1202 * t1031 + 0.49710269629629629629629629629629629629629629629638e-2 * t999 * t1088 + 0.14913080888888888888888888888888888888888888888891e-1 * t999 * t1084 + 0.49710269629629629629629629629629629629629629629638e-2 * t1012 * t1157 + 0.16570089876543209876543209876543209876543209876546e-2 * t1012 * t1161 + 0.74565404444444444444444444444444444444444444444456e-3 * t671 * t959 * t1005 * t1645 - 0.22093453168724279835390946502057613168724279835394e-2 * t1099 * t1040 * t1103 - 0.22093453168724279835390946502057613168724279835394e-2 * t1100 * t959 * t1013 * t1101 - 0.16570089876543209876543209876543209876543209876546e-1 * t928 * t998 * t1108
  t1681 = t506 * t869
  t1708 = t586 * t739
  t1745 = t708 * t526
  t1753 = -0.39062500000000000000000000000000000000000000000000e0 * t517 * t90 * t490 * t1645 + 0.15625000000000000000000000000000000000000000000000e1 * t819 * t739 * t589 * t859 - 0.15625000000000000000000000000000000000000000000000e1 * t772 * t837 + 0.15625000000000000000000000000000000000000000000000e1 * t741 * t837 - 0.10416666666666666666666666666666666666666666666666e1 * t849 * t853 - 0.78124999999999999999999999999999999999999999999998e0 * t772 * t842 - 0.46875000000000000000000000000000000000000000000000e1 * t737 * t847 * t589 * t90 * t518 * t770 + 0.46875000000000000000000000000000000000000000000000e1 * t1708 * t589 * t90 * t601 * t770 + 0.10416666666666666666666666666666666666666666666666e1 * t590 * t90 * t722 * t569 * t724 - 0.52083333333333333333333333333333333333333333333332e0 * t590 * t90 * t840 * t716 + 0.52083333333333333333333333333333333333333333333332e0 * t772 * t866 - 0.52083333333333333333333333333333333333333333333332e0 * t741 * t866 + 0.78124999999999999999999999999999999999999999999998e0 * t741 * t842 - 0.52083333333333333333333333333333333333333333333332e0 * t821 * t853 - 0.86805555555555555555555555555555555555555555555553e0 * t593 * t826 * t968 * t532 - 0.57870370370370370370370370370370370370370370370369e0 * t590 * t90 * t825 * t503 * t776 - 0.15625000000000000000000000000000000000000000000000e1 * t590 * t90 * t595 * t640 * t526 + 0.10416666666666666666666666666666666666666666666666e1 * t593 * t723 * t1745 - 0.15625000000000000000000000000000000000000000000000e1 * t590 * t90 * t835 * t532
  t1758 = t589 * t89
  t1767 = t770 ** 2
  t1772 = t737 ** 2
  t1773 = t738 ** 2
  t1783 = t569 * t776
  t1787 = t2 * t1222
  t1789 = -0.24e2 * t296 + 0.24e2 * t1787
  t1790 = f.my_piecewise5(t51, 0, t48, 0, t1789)
  t1793 = t1790 * t3 + 0.4e1 * t713
  t1798 = t640 * t724
  t1805 = t724 ** 2
  t1816 = t640 * t532
  t1820 = t569 * t716
  t1824 = t703 * t526
  t1829 = t750 * t751 * t1820
  t1832 = t750 * t751 * t1816
  t1835 = t750 * t751 * t1824
  t1840 = t750 * t492 * t510 * t724 * t532
  t1843 = t750 * t781 * t1798
  t1847 = t64 * t744 * t510 * t1554
  t1851 = t750 * t785 * t526 * t716
  t1855 = t750 * t790 * t532 * t653
  t1860 = t64 * t17 * t1121 * t510 * t1805
  t1864 = t750 * t492 * t581 * t1783
  t1868 = t64 * t509 * t581 * t1645
  t1872 = t64 * t576 * t510 * t1793
  t1876 = t750 * t810 * t569 * t703
  t1880 = t64 * t509 * t553 * t1540
  t1885 = t750 * t508 * t506 * t653 * t640
  t1887 = t640 ** 2
  t1890 = t64 * t509 * t761 * t1887
  t1895 = t750 * t550 * t761 * t724 * t653
  t1898 = t750 * t781 * t1745
  t1902 = t750 * t672 * t526 * t805
  t1906 = t750 * t790 * t752 * t640
  t1908 = 0.14222222222222222222222222222222222222222222222223e0 * t1829 + 0.21333333333333333333333333333333333333333333333334e0 * t1832 + 0.14222222222222222222222222222222222222222222222223e0 * t1835 - 0.66370370370370370370370370370370370370370370370373e0 * t1840 - 0.28444444444444444444444444444444444444444444444446e0 * t1843 + 0.14222222222222222222222222222222222222222222222223e0 * t1847 + 0.18962962962962962962962962962962962962962962962964e0 * t1851 - 0.42666666666666666666666666666666666666666666666668e0 * t1855 + 0.36872427983539094650205761316872427983539094650207e0 * t1860 + 0.44246913580246913580246913580246913580246913580249e0 * t1864 - 0.10666666666666666666666666666666666666666666666667e0 * t1868 - 0.35555555555555555555555555555555555555555555555557e-1 * t1872 + 0.85333333333333333333333333333333333333333333333336e0 * t1876 + 0.25600000000000000000000000000000000000000000000001e1 * t1880 - 0.38400000000000000000000000000000000000000000000002e1 * t1885 + 0.64000000000000000000000000000000000000000000000002e0 * t1890 + 0.56888888888888888888888888888888888888888888888891e0 * t1895 - 0.56888888888888888888888888888888888888888888888892e0 * t1898 + 0.85333333333333333333333333333333333333333333333336e0 * t1902 - 0.85333333333333333333333333333333333333333333333336e0 * t1906
  t1917 = 0.34722222222222222222222222222222222222222222222221e0 * t593 * t723 * t717 * t526 + 0.15625000000000000000000000000000000000000000000000e1 * t1708 * t1758 * t596 * t597 * t770 + 0.10416666666666666666666666666666666666666666666666e1 * t588 * t1758 * t832 + 0.11718750000000000000000000000000000000000000000000e1 * t1767 * t739 * t589 * t519 + 0.23437500000000000000000000000000000000000000000000e1 * t1772 / t1773 * t589 * t519 + 0.23437500000000000000000000000000000000000000000000e1 * t741 * t734 - 0.31250000000000000000000000000000000000000000000000e1 * t849 * t602 - 0.57870370370370370370370370370370370370370370370369e0 * t593 * t826 * t1783 - 0.13020833333333333333333333333333333333333333333333e0 * t593 * t596 * t503 * t1793 + 0.52083333333333333333333333333333333333333333333332e0 * t593 * t723 * t1798 + 0.38580246913580246913580246913580246913580246913579e0 * t593 * t18 / t594 / t488 * t503 * t1805 + 0.26041666666666666666666666666666666666666666666666e0 * t593 * t723 * t503 * t1554 - 0.15625000000000000000000000000000000000000000000000e1 * t590 * t705 - 0.78124999999999999999999999999999999999999999999998e0 * t593 * t596 * t1816 - 0.52083333333333333333333333333333333333333333333332e0 * t593 * t596 * t1820 - 0.52083333333333333333333333333333333333333333333332e0 * t593 * t596 * t1824 - 0.39062500000000000000000000000000000000000000000000e0 * t1908 * t587 * t589 * t519 - 0.15625000000000000000000000000000000000000000000000e1 * t821 * t602 - 0.23437500000000000000000000000000000000000000000000e1 * t772 * t734
  t1930 = 0.99420539259259259259259259259259259259259259259276e-3 * t1194 * t1002 + 0.29826161777777777777777777777777777777777777777783e-2 * t1194 * t1007 - 0.59652323555555555555555555555555555555555555555564e-2 * t1029 * t1043 - 0.99420539259259259259259259259259259259259259259274e-2 * t646 * t1174 * t1031 + 0.49710269629629629629629629629629629629629629629638e-2 * t1175 * t1002 + 0.14913080888888888888888888888888888888888888888891e-1 * t1175 * t1007 - 0.19884107851851851851851851851851851851851851851855e-1 * t1073 * t1043 + 0.99420539259259259259259259259259259259259259259275e-2 * t999 * t1015 + 0.29826161777777777777777777777777777777777777777782e-1 * t999 * t1020 + 0.99420539259259259259259259259259259259259259259276e-3 * t671 * t987 * t1681 * t526 - 0.18641351111111111111111111111111111111111111111114e-3 * t671 * t191 * t672 * (t1753 + t1917) + 0.27616816460905349794238683127572016460905349794243e-3 * t467 * t448 * t544 * t37 * t1177 + 0.27616816460905349794238683127572016460905349794243e-3 * t1203 * t1181
  t1946 = t649 * t1092
  t1970 = t45 * t1121
  t1972 = t522 * t776
  t1984 = -0.18641351111111111111111111111111111111111111111114e-3 * t467 * t22 * (0.12320e5 / 0.81e2 * tau0 * t675 - 0.5236e4 / 0.81e2 * t1609) * t37 * t1177 + 0.39768215703703703703703703703703703703703703703710e-1 * t886 * t915 + 0.39768215703703703703703703703703703703703703703709e-1 * t886 * t919 - 0.74565404444444444444444444444444444444444444444455e-1 * t661 * t925 + 0.13421772800000000000000000000000000000000000000002e0 * t483 * t1946 * t654 * t640 + 0.59652323555555555555555555555555555555555555555564e-1 * t547 * t882 - 0.69594377481481481481481481481481481481481481481492e-2 * t547 * t534 - 0.69594377481481481481481481481481481481481481481492e-2 * t483 * t507 * t606 * t532 - 0.44739242666666666666666666666666666666666666666672e-1 * t547 * t925 - 0.44739242666666666666666666666666666666666666666672e-1 * t483 * t652 * t605 * t569 * t640 - 0.14913080888888888888888888888888888888888888888891e-1 * t483 * t652 * t923 * t703 - 0.30930834436213991769547325102880658436213991769552e-1 * t483 * t1970 * t553 * t1972 * t569 - 0.69594377481481481481481481481481481481481481481492e-1 * t483 * t493 * t651 * t948 * t653 - 0.11599062913580246913580246913580246913580246913582e-1 * t661 * t534
  t1993 = t646 * t264 * t482
  t1996 = t929 * t546
  t1999 = t605 * t931
  t2027 = t885 * t546
  t2032 = -0.16570089876543209876543209876543209876543209876546e-1 * t1424 * t943 + 0.22093453168724279835390946502057613168724279835394e-1 * t1424 * t934 + 0.88373812674897119341563786008230452674897119341578e-2 * t1993 * t895 + 0.39768215703703703703703703703703703703703703703710e-1 * t1996 * t938 + 0.39768215703703703703703703703703703703703703703710e-1 * t930 * t887 * t1999 * t569 + 0.19884107851851851851851851851851851851851851851855e-1 * t930 * t887 * t932 * t640 - 0.39768215703703703703703703703703703703703703703711e-2 * t483 * t554 * t522 * t716 * t569 - 0.59652323555555555555555555555555555555555555555565e-2 * t483 * t554 * t611 * t640 - 0.99420539259259259259259259259259259259259259259275e-2 * t1996 * t943 - 0.99420539259259259259259259259259259259259259259275e-2 * t930 * t941 * t875 * t898 - 0.33140179753086419753086419753086419753086419753092e-2 * t930 * t941 * t888 * t1140 + 0.26512143802469135802469135802469135802469135802473e-1 * t2027 * t895 - 0.22369621333333333333333333333333333333333333333336e-1 * t1034 * t1060
  t2081 = -0.99420539259259259259259259259259259259259259259275e-2 * t1170 * t1070 - 0.11184810666666666666666666666666666666666666666668e-1 * t671 * t959 * t1058 * t1887 - 0.29826161777777777777777777777777777777777777777782e-2 * t1029 * t1080 - 0.59652323555555555555555555555555555555555555555564e-2 * t1041 * t1136 - 0.19884107851851851851851851851851851851851851851855e-2 * t1041 * t1142 - 0.29826161777777777777777777777777777777777777777782e-2 * t958 * t959 * t982 * t898 - 0.19884107851851851851851851851851851851851851851855e-2 * t958 * t959 * t1013 * t1140 + 0.44739242666666666666666666666666666666666666666674e-2 * t671 * t959 * t992 * t640 + 0.29826161777777777777777777777777777777777777777783e-2 * t671 * t959 * t1018 * t703 + 0.49710269629629629629629629629629629629629629629636e-2 * t1012 * t1130 - 0.22369621333333333333333333333333333333333333333336e-1 * t671 * t959 * t651 * t981 * t653 - 0.83771009931412894375857338820301783264746227709203e-2 * t671 * t191 / t490 / t1118 / t485 / t1221 * t1000 * t1805 + 0.14913080888888888888888888888888888888888888888891e0 * t1012 * t1095 + 0.12887847681755829903978052126200274348422496570647e-1 * t1012 * t1124
  t2115 = t898 ** 2
  t2120 = 0.89478485333333333333333333333333333333333333333345e-1 * t1046 * t1095 + 0.89478485333333333333333333333333333333333333333345e-1 * t671 * t959 * t1092 * t605 * t805 - 0.34797188740740740740740740740740740740740740740746e-2 * t671 * t1047 * t982 * t724 - 0.44739242666666666666666666666666666666666666666672e-1 * t1046 * t1065 - 0.66280359506172839506172839506172839506172839506184e-2 * t646 * t1209 * t1031 + 0.33140179753086419753086419753086419753086419753092e-2 * t1210 * t1002 + 0.29826161777777777777777777777777777777777777777783e-2 * t1046 * t989 + 0.99420539259259259259259259259259259259259259259272e-2 * t1210 * t1007 + 0.29826161777777777777777777777777777777777777777783e-2 * t1034 * t1015 + 0.89478485333333333333333333333333333333333333333347e-2 * t1034 * t1020 - 0.59652323555555555555555555555555555555555555555564e-2 * t1041 * t984 - 0.19884107851851851851851851851851851851851851851855e-2 * t958 * t959 * t1681 * t655 - 0.24855134814814814814814814814814814814814814814819e-2 * t1068 * t959 * t1000 * t2115
  t2128 = 0.1e1 / t20 / t55
  t2160 = -0.34797188740740740740740740740740740740740740740746e-2 * t1034 * t1049 - 0.37282702222222222222222222222222222222222222222228e-2 * t999 * t1185 - 0.12427567407407407407407407407407407407407407407409e-2 * t1012 * t871 - 0.92056054869684499314128943758573388203017832647476e-4 * t467 * t2128 * t480 * t37 * t1177 - 0.12427567407407407407407407407407407407407407407409e-2 * t467 * t21 * t1191 * t37 * t1177 - 0.37282702222222222222222222222222222222222222222228e-2 * t1175 * t1181 - 0.74565404444444444444444444444444444444444444444456e-3 * t1194 * t1181 - 0.11184810666666666666666666666666666666666666666668e-2 * t1034 * t1185 - 0.12427567407407407407407407407407407407407407407409e-2 * t1145 * t1185 - 0.12427567407407407407407407407407407407407407407409e-2 * t467 * t264 * t1026 * t37 * t1177 - 0.24855134814814814814814814814814814814814814814819e-2 * t1210 * t1181 + 0.99420539259259259259259259259259259259259259259276e-3 * t1046 * t1161 + 0.44739242666666666666666666666666666666666666666674e-2 * t1034 * t1084 + 0.89478485333333333333333333333333333333333333333347e-2 * t1046 * t1165
  t2179 = f.my_piecewise5(t10, 0, t7, 0, t1789)
  t2198 = 0.29826161777777777777777777777777777777777777777783e-2 * t1046 * t1130 + 0.14913080888888888888888888888888888888888888888891e-2 * t671 * t987 * t982 * t532 + 0.99420539259259259259259259259259259259259259259276e-3 * t671 * t987 * t1013 * t716 + 0.24855134814814814814814814814814814814814814814819e-3 * t671 * t987 * t1000 * t1793 + 0.14913080888888888888888888888888888888888888888891e-1 * t1012 * t1165 - 0.49710269629629629629629629629629629629629629629637e-3 * t958 * t959 * t1000 * t2179 + 0.16570089876543209876543209876543209876543209876546e-2 * t1145 * t1088 + 0.49710269629629629629629629629629629629629629629636e-2 * t1145 * t1084 + 0.14913080888888888888888888888888888888888888888891e-2 * t1034 * t1088 - 0.36822421947873799725651577503429355281207133058991e-3 * t1203 * t1002 - 0.11046726584362139917695473251028806584362139917697e-2 * t1203 * t1007 - 0.66280359506172839506172839506172839506172839506184e-2 * t1113 * t1043 + 0.33140179753086419753086419753086419753086419753092e-2 * t1145 * t1015
  t2201 = t522 * t1140
  t2248 = 0.99420539259259259259259259259259259259259259259272e-2 * t1145 * t1020 + 0.79536431407407407407407407407407407407407407407420e-2 * t648 * t887 * t2201 * t569 + 0.11930464711111111111111111111111111111111111111113e-1 * t648 * t887 * t899 * t640 + 0.79536431407407407407407407407407407407407407407420e-2 * t648 * t887 * t888 * t703 + 0.29457937558299039780521262002743484224965706447193e-2 * t1417 * t874 * t1418 * t526 + 0.66280359506172839506172839506172839506172839506184e-2 * t930 * t874 * t932 * t532 + 0.13256071901234567901234567901234567901234567901237e-1 * t930 * t874 * t1999 * t526 - 0.11930464711111111111111111111111111111111111111113e0 * t483 * t551 * t1092 * t527 * t805 + 0.26512143802469135802469135802469135802469135802473e-1 * t1993 * t890 + 0.13256071901234567901234567901234567901234567901237e-1 * t1996 * t934 - 0.19884107851851851851851851851851851851851851851855e0 * t886 * t657 + 0.23860929422222222222222222222222222222222222222226e0 * t648 * t1946 * t522 * t805 * t655 - 0.13256071901234567901234567901234567901234567901237e-1 * t467 * t264 * t482 * t571 + 0.99420539259259259259259259259259259259259259259275e-1 * t661 * t882
  t2262 = t1970 * t506
  t2286 = 0.59652323555555555555555555555555555555555555555564e-1 * t483 * t880 * t606 * t653 - 0.19884107851851851851851851851851851851851851851855e-1 * t661 * t613 + 0.29826161777777777777777777777777777777777777777783e-1 * t483 * t880 * t611 * t653 - 0.19884107851851851851851851851851851851851851851855e-1 * t661 * t642 + 0.11599062913580246913580246913580246913580246913582e-1 * t483 * t2262 * t948 * t532 - 0.39768215703703703703703703703703703703703703703710e-1 * t660 * t546 * t571 - 0.74565404444444444444444444444444444444444444444456e-3 * t1046 * t871 - 0.39768215703703703703703703703703703703703703703710e-1 * t661 * t608 + 0.20620556290809327846364883401920438957475994513035e-1 * t648 * t2262 * t1972 * t655 + 0.46396251654320987654320987654320987654320987654328e-1 * t661 * t955 + 0.79536431407407407407407407407407407407407407407421e-2 * t1363 * t895 + 0.15907286281481481481481481481481481481481481481484e-1 * t893 * t877 + 0.79536431407407407407407407407407407407407407407421e-2 * t893 * t901
  t2336 = 0.79536431407407407407407407407407407407407407407421e-2 * t893 * t905 + 0.79536431407407407407407407407407407407407407407421e-2 * t648 * t874 * t1372 * t526 + 0.79536431407407407407407407407407407407407407407421e-2 * t648 * t874 * t1377 * t526 + 0.79536431407407407407407407407407407407407407407421e-2 * t648 * t874 * t875 * t532 + 0.26512143802469135802469135802469135802469135802473e-2 * t648 * t874 * t2201 * t526 + 0.39768215703703703703703703703703703703703703703710e-2 * t648 * t874 * t899 * t532 + 0.26512143802469135802469135802469135802469135802473e-2 * t648 * t874 * t888 * t716 - 0.39768215703703703703703703703703703703703703703709e-2 * t483 * t554 * t527 * t703 - 0.11930464711111111111111111111111111111111111111113e0 * t893 * t657 - 0.11930464711111111111111111111111111111111111111113e0 * t648 * t652 * t605 * t653 * t655 - 0.59652323555555555555555555555555555555555555555564e-1 * t648 * t652 * t654 * t898 + 0.79536431407407407407407407407407407407407407407419e-1 * t2027 * t890 + 0.79536431407407407407407407407407407407407407407419e-1 * t886 * t911 + 0.23860929422222222222222222222222222222222222222226e-1 * t648 * t887 * t875 * t640
  t2341 = f.my_piecewise3(t460, 0, t1386 + t1439 + t1492 + t1532 + t1585 + t1660 + t1930 + t1984 + t2032 + t2081 + t2120 + t2160 + t2198 + t2248 + t2286 + t2336)
  t2342 = t1298 * t1253
  t2351 = t1298 * t1280
  t2415 = t45 * t329 * t77
  t2429 = 0.13256071901234567901234567901234567901234567901237e-1 * t140 * t78 * t100 * t122 * t151 - 0.18558500661728395061728395061728395061728395061732e-1 * t44 * t120 * t100 * t1319 - 0.92056054869684499314128943758573388203017832647476e-4 * t130 * t2128 * t35 * t37 * t453 + 0.79536431407407407407407407407407407407407407407421e-2 * t44 * t78 * t177 * t151 * t122 + 0.79536431407407407407407407407407407407407407407421e-2 * t44 * t78 * t178 * t110 + 0.26512143802469135802469135802469135802469135802473e-2 * t44 * t78 * t95 * t308 * t122 + 0.39768215703703703703703703703703703703703703703710e-2 * t44 * t78 * t183 * t110 + 0.26512143802469135802469135802469135802469135802473e-2 * t44 * t78 * t100 * t303 + 0.13256071901234567901234567901234567901234567901237e-1 * t140 * t78 * t177 * t141 * t122 + 0.66280359506172839506172839506172839506172839506184e-2 * t140 * t78 * t142 * t110 - 0.99420539259259259259259259259259259259259259259275e-2 * t140 * t150 * t178 * t151 - 0.33140179753086419753086419753086419753086419753092e-2 * t140 * t150 * t100 * t308 + 0.26512143802469135802469135802469135802469135802473e-1 * t157 * t180 + 0.13256071901234567901234567901234567901234567901237e-1 * t157 * t185 + 0.11599062913580246913580246913580246913580246913582e-1 * t132 * t2415 * t95 * t123 * t110 + 0.20620556290809327846364883401920438957475994513035e-1 * t44 * t2415 * t100 * t331 - 0.11599062913580246913580246913580246913580246913582e-1 * t130 * t21 * t43 * t135
  t2447 = 0.1e1 / t326
  t2485 = 0.66666666666666666666666666666666666666666666666666e0 * t2447 * t96 * t234 * t344 + 0.88888888888888888888888888888888888888888888888888e0 * t426 * t412 + 0.20000000000000000000000000000000000000000000000001e1 * t343 * t219 * t344 + 0.20000000000000000000000000000000000000000000000001e1 * t233 * t402 + 0.10000000000000000000000000000000000000000000000000e1 * t233 * t405 - 0.44444444444444444444444444444444444444444444444444e0 * t426 * t234 * t110 - 0.10000000000000000000000000000000000000000000000000e1 * t212 * t423 * t108 - 0.10000000000000000000000000000000000000000000000000e1 * t212 * t219 * t106 - 0.33333333333333333333333333333333333333333333333334e0 * t212 * t165 * t300 - 0.22222222222222222222222222222222222222222222222222e0 * t411 * t234 * t106 - 0.11111111111111111111111111111111111111111111111111e1 * t415 * t418 + 0.44444444444444444444444444444444444444444444444444e0 * t233 * t165 * t303 + 0.22222222222222222222222222222222222222222222222222e0 * t2447 * t102 * t427 * t108
  t2495 = -t1789
  t2496 = f.my_piecewise5(t48, 0, t51, 0, t2495)
  t2499 = t2496 * t3 + 0.4e1 * t300
  t2506 = t18 / t170 / t116
  t2507 = t123 ** 2
  t2512 = t110 ** 2
  t2520 = t326 * t53
  t2524 = t222 ** 2
  t2542 = t396 * t397 * t110
  t2546 = t2507 * t354 * t36
  t2551 = t2507 * t223 * t37
  t2563 = -0.20000000000000000000000000000000000000000000000000e1 * t2447 * t4 * t165 * t344 * t108 - 0.20000000000000000000000000000000000000000000000001e1 * t411 * t345 - 0.20000000000000000000000000000000000000000000000001e1 * t415 * t213 - 0.13020833333333333333333333333333333333333333333333e0 * t169 * t172 * t74 * t2499 + 0.38580246913580246913580246913580246913580246913579e0 * t169 * t2506 * t74 * t2507 + 0.26041666666666666666666666666666666666666666666666e0 * t169 * t239 * t74 * t2512 - 0.11111111111111111111111111111111111111111111111111e1 * t411 * t122 * t402 + 0.64726913580246913580246913580246913580246913580257e-2 / t2520 * t1222 * t2507 / t2524 * jnp.pi / t75 / t74 + 0.20000000000000000000000000000000000000000000000001e1 * t343 * t122 * t164 * t108 * t106 - 0.10666666666666666666666666666666666666666666666668e0 * t212 * t122 * t223 * t108 * t37 * t2542 + 0.84279835390946502057613168724279835390946502057618e-3 * t233 * t2546 * t366 - 0.52674897119341563786008230452674897119341563786009e-2 * t233 * t2551 * t385 + 0.36872427983539094650205761316872427983539094650209e-1 * t163 * t2551 * t227 * t1313 * t81 + 0.47407407407407407407407407407407407407407407407412e-1 * t216 * t370 * t385
  t2611 = t360 * t18
  t2612 = t362 * t364
  t2624 = -0.10113580246913580246913580246913580246913580246915e-1 * t163 * t2546 * t360 * t2506 * t364 - 0.15802469135802469135802469135802469135802469135803e-1 * t415 * t370 * t230 + 0.71111111111111111111111111111111111111111111111117e-1 * t408 * t225 * t230 - 0.26337448559670781893004115226337448559670781893005e-2 * t426 * t2551 * t230 + 0.35555555555555555555555555555555555555555555555559e-1 * t163 * t2512 * t223 * t37 * t230 - 0.75851851851851851851851851851851851851851851851861e-2 * t216 * t356 * t366 - 0.10666666666666666666666666666666666666666666666668e0 * t216 * t122 * t223 * t37 * t2542 + 0.47407407407407407407407407407407407407407407407412e-1 * t212 * t370 * t396 * t1318 * t108 - 0.94814814814814814814814814814814814814814814814824e-1 * t226 * t396 * t1318 * t110 - 0.35555555555555555555555555555555555555555555555559e-1 * t212 * t224 * t106 * t390 + 0.47407407407407407407407407407407407407407407407412e-1 * t163 * t303 * t223 * t37 * t399 - 0.75851851851851851851851851851851851851851851851861e-2 * t212 * t356 * t2611 * t2612 * t108 + 0.15170370370370370370370370370370370370370370370372e-1 * t163 * t123 * t354 * t36 * t2611 * t2612 * t110
  t2671 = -0.15802469135802469135802469135802469135802469135803e-1 * t411 * t370 * t396 * t397 * t108 + 0.23703703703703703703703703703703703703703703703704e-1 * t233 * t225 * t2542 + 0.71111111111111111111111111111111111111111111111117e-1 * t343 * t224 * t344 * t390 + 0.71111111111111111111111111111111111111111111111117e-1 * t233 * t388 * t390 - 0.86805555555555555555555555555555555555555555555553e0 * t169 * t363 * t240 * t110 + 0.34722222222222222222222222222222222222222222222221e0 * t169 * t239 * t173 * t303 + 0.12345679012345679012345679012345679012345679012346e0 * t2447 * t296 * t2507 * t164 + 0.20000000000000000000000000000000000000000000000001e1 * t408 * t219 - 0.10000000000000000000000000000000000000000000000000e1 * t216 * t423 + 0.33333333333333333333333333333333333333333333333334e0 * t163 * t2499 * t164 - 0.20000000000000000000000000000000000000000000000000e1 * t162 * t296 * t165 + 0.66666666666666666666666666666666666666666666666666e0 * t211 * t296 * t234 + 0.33333333333333333333333333333333333333333333333333e0 * t233 * t2512 * t164 + 0.22222222222222222222222222222222222222222222222222e0 * t342 * t296 * t427
  t2688 = t77 * t434
  t2709 = -0.18558500661728395061728395061728395061728395061732e-1 * t44 * t120 * t178 * t123 + 0.13256071901234567901234567901234567901234567901237e-1 * t157 * t112 + 0.79536431407407407407407407407407407407407407407421e-2 * t44 * t78 * t248 * t99 * t122 - 0.12427567407407407407407407407407407407407407407409e-2 * t258 * t436 - 0.12427567407407407407407407407407407407407407407409e-2 * t313 * t444 + 0.27616816460905349794238683127572016460905349794243e-3 * t451 * t440 - 0.18641351111111111111111111111111111111111111111114e-3 * t281 * t191 * t341 * (t2485 + t2563 + t2624 + t2671) - 0.19884107851851851851851851851851851851851851851855e-2 * t210 * t192 * t193 * t308 - 0.11599062913580246913580246913580246913580246913582e-1 * t258 * t283 + 0.12887847681755829903978052126200274348422496570647e-1 * t258 * t333 + 0.49710269629629629629629629629629629629629629629638e-2 * t258 * t288 + 0.99420539259259259259259259259259259259259259259276e-3 * t281 * t286 * t2688 * t122 - 0.17398594370370370370370370370370370370370370370373e-2 * t281 * t259 * t205 * t2512 + 0.49710269629629629629629629629629629629629629629638e-2 * t258 * t292 + 0.16570089876543209876543209876543209876543209876546e-2 * t258 * t305 - 0.34797188740740740740740740740740740740740740740746e-2 * t281 * t259 * t249 * t123 + 0.14913080888888888888888888888888888888888888888891e-2 * t281 * t286 * t249 * t110
  t2748 = f.my_piecewise5(t7, 0, t10, 0, t2495)
  t2759 = t141 ** 2
  t2766 = t151 ** 2
  t2773 = 0.99420539259259259259259259259259259259259259259276e-3 * t281 * t286 * t193 * t303 + 0.77327086090534979423868312757201646090534979423880e-2 * t281 * t330 * t193 * t331 - 0.16570089876543209876543209876543209876543209876546e-1 * t336 * t195 - 0.33140179753086419753086419753086419753086419753092e-2 * t200 * t310 - 0.22093453168724279835390946502057613168724279835394e-2 * t275 * t192 * t193 * t276 - 0.29826161777777777777777777777777777777777777777782e-2 * t210 * t192 * t249 * t151 - 0.49710269629629629629629629629629629629629629629637e-2 * t190 * t192 * t249 * t141 + 0.73644843895747599451303155006858710562414266117982e-3 * t19 * t450 * t269 - 0.36822421947873799725651577503429355281207133058991e-3 * t451 * t315 - 0.19884107851851851851851851851851851851851851851855e-2 * t210 * t192 * t2688 * t99 + 0.24855134814814814814814814814814814814814814814819e-3 * t281 * t286 * t205 * t2499 - 0.49710269629629629629629629629629629629629629629637e-3 * t210 * t192 * t205 * t2748 + 0.16570089876543209876543209876543209876543209876546e-2 * t313 * t323 + 0.18411210973936899862825788751714677640603566529495e-3 / t14 / t13 * t18 * t189 * t192 * t205 * t2759 - 0.33140179753086419753086419753086419753086419753092e-2 * t267 * t207 - 0.24855134814814814814814814814814814814814814814819e-2 * t190 * t192 * t205 * t2766 - 0.66280359506172839506172839506172839506172839506184e-2 * t267 * t202
  t2801 = t138 * t21 * t43
  t2811 = t274 * t22 * t43
  t2836 = 0.33140179753086419753086419753086419753086419753092e-2 * t313 * t319 - 0.99420539259259259259259259259259259259259259259274e-2 * t200 * t251 - 0.83771009931412894375857338820301783264746227709203e-2 * t281 * t191 / t58 / t2520 / t1221 * t205 * t2507 - 0.36822421947873799725651577503429355281207133058990e-2 * t274 * t199 * t278 - 0.55233632921810699588477366255144032921810699588486e-2 * t138 * t266 * t338 - 0.99420539259259259259259259259259259259259259259275e-2 * t200 * t255 - 0.38663543045267489711934156378600823045267489711940e-2 * t313 * t261 - 0.92792503308641975308641975308641975308641975308657e-2 * t44 * t120 * t183 * t123 - 0.16570089876543209876543209876543209876543209876546e-1 * t2801 * t153 + 0.88373812674897119341563786008230452674897119341578e-2 * t19 * t264 * t43 * t159 - 0.30930834436213991769547325102880658436213991769552e-1 * t157 * t125 + 0.29457937558299039780521262002743484224965706447193e-2 * t2811 * t78 * t95 * t276 * t122 + 0.22093453168724279835390946502057613168724279835394e-1 * t2801 * t144 - 0.15465417218106995884773662551440329218106995884776e-1 * t140 * t120 * t142 * t123 - 0.33140179753086419753086419753086419753086419753092e-2 * t2811 * t150 * t142 * t151 - 0.69594377481481481481481481481481481481481481481492e-2 * t132 * t120 * t177 * t122 * t110 - 0.23198125827160493827160493827160493827160493827164e-2 * t132 * t120 * t133 * t303
  t2839 = f.my_piecewise3(t1, 0, t2429 + t2709 + t2773 + t2836)
  t2840 = t1241 * t3
  t2841 = t1280 * t1257
  t2844 = -0.80000000000000000000000000000000000000000000000000e0 * t1225 * t1232 * t1236 - 0.48000000000000000000000000000000000000000000000000e1 * t1254 * t1257 - 0.24000000000000000000000000000000000000000000000000e1 * t1260 * t1286 - 0.24000000000000000000000000000000000000000000000000e1 * t1294 * t1257 - 0.80000000000000000000000000000000000000000000000000e0 * t1299 * t1340 + t2341 - 0.24000000000000000000000000000000000000000000000000e1 * t2342 * t1286 - 0.24000000000000000000000000000000000000000000000000e1 * t1241 * t1280 * t1236 - 0.24000000000000000000000000000000000000000000000000e1 * t1293 * t1253 * t1236 - 0.24000000000000000000000000000000000000000000000000e1 * t2351 * t1257 - 0.80000000000000000000000000000000000000000000000000e0 * t1298 * t1330 * t1236 + t2839 - 0.24000000000000000000000000000000000000000000000000e1 * t2840 * t2841
  t2845 = t1298 * t3
  t2849 = t1293 * t3
  t2850 = t1280 * t1236
  t2853 = t1253 * t1286
  t2862 = t1330 * t1236
  t2885 = 0.4e1 / 0.27e2 * t1829 + 0.2e1 / 0.9e1 * t1832 + 0.4e1 / 0.27e2 * t1835 - 0.56e2 / 0.81e2 * t1840 - 0.8e1 / 0.27e2 * t1843 + 0.4e1 / 0.27e2 * t1847 + 0.16e2 / 0.81e2 * t1851 - 0.4e1 / 0.9e1 * t1855 + 0.280e3 / 0.729e3 * t1860 + 0.112e3 / 0.243e3 * t1864 - t1868 / 0.9e1 - t1872 / 0.27e2 + 0.8e1 / 0.9e1 * t1876 + 0.8e1 / 0.3e1 * t1880 - 0.4e1 * t1885 + 0.2e1 / 0.3e1 * t1890 + 0.16e2 / 0.27e2 * t1895 - 0.16e2 / 0.27e2 * t1898 + 0.8e1 / 0.9e1 * t1902 - 0.8e1 / 0.9e1 * t1906
  t2886 = f.my_piecewise3(t460, 0, t2885)
  t2887 = 0.63e0 * t2886
  t2911 = f.my_piecewise3(t1, 0, 0.280e3 / 0.729e3 * t64 * t17 * t329 * t81 * t2507 - 0.56e2 / 0.81e2 * t750 * t118 * t81 * t123 * t110 + 0.4e1 / 0.27e2 * t64 * t383 * t81 * t2512 + 0.16e2 / 0.81e2 * t750 * t1318 * t122 * t303 - t64 * t228 * t81 * t2499 / 0.27e2)
  t2912 = 0.63e0 * t2911
  t2913 = t2887 + t2912
  t2925 = t1232 * t1236
  t2928 = t1225 * t3
  t2929 = t1253 * t1236
  t2932 = t1232 * t1257
  t2935 = t1253 * t1257
  t2938 = t1232 * t1286
  t2941 = t1232 * t1340
  t2951 = t1280 ** 2
  t2954 = t1282 ** 2
  t2955 = t1283 ** 2
  t2963 = -0.80000000000000000000000000000000000000000000000000e0 * t2845 * t1330 * t1257 - 0.12000000000000000000000000000000000000000000000000e1 * t2849 * t2850 - 0.24000000000000000000000000000000000000000000000000e1 * t2840 * t2853 - 0.12000000000000000000000000000000000000000000000000e1 * t2845 * t1280 * t1286 - 0.80000000000000000000000000000000000000000000000000e0 * t2845 * t1253 * t1340 - 0.80000000000000000000000000000000000000000000000000e0 * t2840 * t2862 - 0.20000000000000000000000000000000000000000000000000e0 * t2845 * t2913 * t1236 - 0.20000000000000000000000000000000000000000000000000e0 * (-0.72e2 * t296 + 0.192e3 * t1787 - 0.120e3 * t1220 / t295 / t55) * t3 * t2925 - 0.80000000000000000000000000000000000000000000000000e0 * t2928 * t2929 - 0.80000000000000000000000000000000000000000000000000e0 * t2928 * t2932 - 0.24000000000000000000000000000000000000000000000000e1 * t2849 * t2935 - 0.12000000000000000000000000000000000000000000000000e1 * t2849 * t2938 - 0.80000000000000000000000000000000000000000000000000e0 * t2840 * t2941 - 0.20000000000000000000000000000000000000000000000000e0 * t2845 * t1232 * (t2887 + t2912 - t2913 * t1255 + 0.4e1 * t1330 * t1284 * t1253 - 0.12e2 * t1280 * t1337 * t1282 + 0.3e1 * t2951 * t1284 + 0.6e1 * t2954 / t2955)
  d1111 = 0.4e1 * t458 + 0.4e1 * t1216 + t3 * (t2844 + t2963) - 0.24000000000000000000000000000000000000000000000000e1 * t1294 * t1236 - 0.24000000000000000000000000000000000000000000000000e1 * t2849 * t2929 - 0.24000000000000000000000000000000000000000000000000e1 * t2849 * t2932 - 0.24000000000000000000000000000000000000000000000000e1 * t2840 * t2850 - 0.48000000000000000000000000000000000000000000000000e1 * t1254 * t1236 - 0.24000000000000000000000000000000000000000000000000e1 * t2845 * t2853 - 0.80000000000000000000000000000000000000000000000000e0 * t2845 * t2941 - 0.24000000000000000000000000000000000000000000000000e1 * t2845 * t2841 - 0.80000000000000000000000000000000000000000000000000e0 * t2845 * t2862 - 0.48000000000000000000000000000000000000000000000000e1 * t2840 * t2935 - 0.24000000000000000000000000000000000000000000000000e1 * t2840 * t2938 - 0.48000000000000000000000000000000000000000000000000e1 * t1260 * t1257 - 0.24000000000000000000000000000000000000000000000000e1 * t2351 * t1236 - 0.48000000000000000000000000000000000000000000000000e1 * t2342 * t1257 - 0.24000000000000000000000000000000000000000000000000e1 * t1299 * t1286 - 0.80000000000000000000000000000000000000000000000000e0 * t2928 * t2925

  res = {'v4rho4': d1111}
  return res
