"""Generated from mgga_c_b94.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_cab_raw = params.cab
  if isinstance(params_cab_raw, (str, bytes, dict)):
    params_cab = params_cab_raw
  else:
    try:
      params_cab_seq = list(params_cab_raw)
    except TypeError:
      params_cab = params_cab_raw
    else:
      params_cab_seq = np.asarray(params_cab_seq, dtype=np.float64)
      params_cab = np.concatenate((np.array([np.nan], dtype=np.float64), params_cab_seq))
  params_css_raw = params.css
  if isinstance(params_css_raw, (str, bytes, dict)):
    params_css = params_css_raw
  else:
    try:
      params_css_seq = list(params_css_raw)
    except TypeError:
      params_css = params_css_raw
    else:
      params_css_seq = np.asarray(params_css_seq, dtype=np.float64)
      params_css = np.concatenate((np.array([np.nan], dtype=np.float64), params_css_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  b94_css = lambda rs, z, xs, us, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) ** 4 * (1 - 2 * jnp.log(1 + b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) / 2) / b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts))

  b94_cab = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) * (b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) - jnp.log(1 + b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1)))

  b94_par = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b94_css(rs, f.z_thr(z), xs0, us0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b94_css(rs, f.z_thr(-z), xs1, us1, ts1))

  b94_c_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +b94_cab(rs, z, xs0, xs1, us0, us1, ts0, ts1) + b94_par(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b94_c_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_cab_raw = params.cab
  if isinstance(params_cab_raw, (str, bytes, dict)):
    params_cab = params_cab_raw
  else:
    try:
      params_cab_seq = list(params_cab_raw)
    except TypeError:
      params_cab = params_cab_raw
    else:
      params_cab_seq = np.asarray(params_cab_seq, dtype=np.float64)
      params_cab = np.concatenate((np.array([np.nan], dtype=np.float64), params_cab_seq))
  params_css_raw = params.css
  if isinstance(params_css_raw, (str, bytes, dict)):
    params_css = params_css_raw
  else:
    try:
      params_css_seq = list(params_css_raw)
    except TypeError:
      params_css = params_css_raw
    else:
      params_css_seq = np.asarray(params_css_seq, dtype=np.float64)
      params_css = np.concatenate((np.array([np.nan], dtype=np.float64), params_css_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  b94_css = lambda rs, z, xs, us, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) ** 4 * (1 - 2 * jnp.log(1 + b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) / 2) / b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts))

  b94_cab = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) * (b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) - jnp.log(1 + b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1)))

  b94_par = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b94_css(rs, f.z_thr(z), xs0, us0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b94_css(rs, f.z_thr(-z), xs1, us1, ts1))

  b94_c_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +b94_cab(rs, z, xs0, xs1, us0, us1, ts0, ts1) + b94_par(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b94_c_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_cab_raw = params.cab
  if isinstance(params_cab_raw, (str, bytes, dict)):
    params_cab = params_cab_raw
  else:
    try:
      params_cab_seq = list(params_cab_raw)
    except TypeError:
      params_cab = params_cab_raw
    else:
      params_cab_seq = np.asarray(params_cab_seq, dtype=np.float64)
      params_cab = np.concatenate((np.array([np.nan], dtype=np.float64), params_cab_seq))
  params_css_raw = params.css
  if isinstance(params_css_raw, (str, bytes, dict)):
    params_css = params_css_raw
  else:
    try:
      params_css_seq = list(params_css_raw)
    except TypeError:
      params_css = params_css_raw
    else:
      params_css_seq = np.asarray(params_css_seq, dtype=np.float64)
      params_css = np.concatenate((np.array([np.nan], dtype=np.float64), params_css_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  b94_css = lambda rs, z, xs, us, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) ** 4 * (1 - 2 * jnp.log(1 + b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) / 2) / b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts))

  b94_cab = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) * (b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) - jnp.log(1 + b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1)))

  b94_par = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b94_css(rs, f.z_thr(z), xs0, us0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b94_css(rs, f.z_thr(-z), xs1, us1, ts1))

  b94_c_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +b94_cab(rs, z, xs0, xs1, us0, us1, ts0, ts1) + b94_par(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b94_c_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t8 = 0.20000000000000000000000000000000000000000000000000e0 - 0.20000000000000000000000000000000000000000000000000e0 * t2 * t5
  t9 = t8 * t3
  t10 = r0 <= f.p.dens_threshold
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 / t3
  t15 = 0.2e1 * r0 * t12 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold - 0.1e1
  t19 = 0.2e1 * r1 * t12 <= f.p.zeta_threshold
  t20 = -t16
  t21 = t1 * t12
  t22 = f.my_piecewise5(t15, t16, t19, t20, t21)
  t23 = 0.1e1 + t22
  t24 = t23 * t3
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t11 * t26
  t28 = jnp.pi ** (0.1e1 / 0.3e1)
  t29 = 0.1e1 / t28
  t30 = t27 * t29
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / r0
  t37 = params.gamma * tau0
  t40 = params.gamma * s0
  t41 = r0 ** 2
  t43 = 0.1e1 / t32 / t41
  t46 = l0 * t34 / 0.6e1 - 0.2e1 / 0.3e1 * t37 * t34 + t40 * t43 / 0.12e2
  t47 = abs(t46)
  t48 = t47 < 0.50e-12
  t49 = 0.0e0 < t46
  t50 = f.my_piecewise3(t49, 0.50e-12, -0.50e-12)
  t51 = f.my_piecewise3(t48, t50, t46)
  t52 = br89_x(t51)
  t54 = jnp.exp(t52 / 0.3e1)
  t55 = 0.1e1 / t54
  t56 = jnp.exp(-t52)
  t59 = t56 * (0.1e1 + t52 / 0.2e1)
  t60 = 0.1e1 - t59
  t61 = 0.1e1 / t60
  t62 = t55 * t61
  t66 = f.my_piecewise3(t10, 0, t30 * t62 * t52 / 0.2e1)
  t67 = r1 <= f.p.dens_threshold
  t68 = f.my_piecewise5(t19, t16, t15, t20, -t21)
  t69 = 0.1e1 + t68
  t70 = t69 * t3
  t71 = t70 ** (0.1e1 / 0.3e1)
  t72 = 0.1e1 / t71
  t73 = t11 * t72
  t74 = t73 * t29
  t75 = r1 ** (0.1e1 / 0.3e1)
  t76 = t75 ** 2
  t78 = 0.1e1 / t76 / r1
  t81 = params.gamma * tau1
  t84 = params.gamma * s2
  t85 = r1 ** 2
  t87 = 0.1e1 / t76 / t85
  t90 = l1 * t78 / 0.6e1 - 0.2e1 / 0.3e1 * t81 * t78 + t84 * t87 / 0.12e2
  t91 = abs(t90)
  t92 = t91 < 0.50e-12
  t93 = 0.0e0 < t90
  t94 = f.my_piecewise3(t93, 0.50e-12, -0.50e-12)
  t95 = f.my_piecewise3(t92, t94, t90)
  t96 = br89_x(t95)
  t98 = jnp.exp(t96 / 0.3e1)
  t99 = 0.1e1 / t98
  t100 = jnp.exp(-t96)
  t103 = t100 * (0.1e1 + t96 / 0.2e1)
  t104 = 0.1e1 - t103
  t105 = 0.1e1 / t104
  t106 = t99 * t105
  t110 = f.my_piecewise3(t67, 0, t74 * t106 * t96 / 0.2e1)
  t111 = t66 + t110
  t112 = params.cab * t111
  t113 = 0.1e1 + t112
  t114 = jnp.log(t113)
  t115 = t112 - t114
  t116 = t112 * t115
  t117 = t9 * t116
  t119 = 0.1e1 + t21 <= f.p.zeta_threshold
  t121 = 0.1e1 - t21 <= f.p.zeta_threshold
  t122 = f.my_piecewise5(t119, t16, t121, t20, t21)
  t123 = 0.1e1 + t122
  t124 = t123 ** 2
  t125 = t123 ** (0.1e1 / 0.3e1)
  t126 = t125 ** 2
  t128 = t11 ** 2
  t129 = t126 * t124 * t128
  t130 = t3 ** (0.1e1 / 0.3e1)
  t131 = t130 ** 2
  t132 = t131 * t3
  t137 = 0.2e1 * tau0 * t34 - s0 * t43 / 0.4e1
  t138 = t132 * t137
  t139 = params.css ** 2
  t140 = t139 ** 2
  t142 = t129 * t138 * t140
  t144 = 0.1e1 / t25 / t24
  t146 = 0.1e1 / t28 / jnp.pi
  t148 = t54 ** 2
  t149 = t148 ** 2
  t150 = 0.1e1 / t149
  t151 = t144 * t146 * t150
  t152 = t60 ** 2
  t153 = t152 ** 2
  t154 = 0.1e1 / t153
  t155 = t52 ** 2
  t156 = t155 ** 2
  t157 = t154 * t156
  t158 = params.css * t11
  t159 = t158 * t26
  t165 = 0.1e1 + t159 * t29 * t55 * t61 * t52 / 0.2e1
  t166 = jnp.log(t165)
  t167 = 0.1e1 / params.css
  t168 = t166 * t167
  t170 = t168 * t128 * t25
  t171 = t28 * t54
  t172 = 0.1e1 / t52
  t173 = t60 * t172
  t176 = -t170 * t171 * t173 + 0.1e1
  t178 = t151 * t157 * t176
  t181 = f.my_piecewise3(t10, 0, -0.25000000000000000000000000000000000000000000000000e-2 * t142 * t178)
  t182 = f.my_piecewise5(t121, t16, t119, t20, -t21)
  t183 = 0.1e1 + t182
  t184 = t183 ** 2
  t185 = t183 ** (0.1e1 / 0.3e1)
  t186 = t185 ** 2
  t188 = t186 * t184 * t128
  t193 = 0.2e1 * tau1 * t78 - s2 * t87 / 0.4e1
  t194 = t132 * t193
  t196 = t188 * t194 * t140
  t198 = 0.1e1 / t71 / t70
  t200 = t98 ** 2
  t201 = t200 ** 2
  t202 = 0.1e1 / t201
  t203 = t198 * t146 * t202
  t204 = t104 ** 2
  t205 = t204 ** 2
  t206 = 0.1e1 / t205
  t207 = t96 ** 2
  t208 = t207 ** 2
  t209 = t206 * t208
  t210 = t158 * t72
  t216 = 0.1e1 + t210 * t29 * t99 * t105 * t96 / 0.2e1
  t217 = jnp.log(t216)
  t218 = t217 * t167
  t220 = t218 * t128 * t71
  t221 = t28 * t98
  t222 = 0.1e1 / t96
  t223 = t104 * t222
  t226 = -t220 * t221 * t223 + 0.1e1
  t228 = t203 * t209 * t226
  t231 = f.my_piecewise3(t67, 0, -0.25000000000000000000000000000000000000000000000000e-2 * t196 * t228)
  t232 = t1 * t5
  t233 = 0.40000000000000000000000000000000000000000000000000e0 * t232
  t237 = 0.40000000000000000000000000000000000000000000000000e0 * t2 / t4 / t3
  t243 = t8 * params.cab * t111 * t115
  t245 = t11 * t144 * t29
  t246 = t12 - t232
  t247 = f.my_piecewise5(t15, 0, t19, 0, t246)
  t249 = t247 * t3 + t22 + 0.1e1
  t251 = t62 * t52 * t249
  t255 = t28 * t55 * t61
  t256 = t27 * t255
  t257 = f.my_piecewise3(t49, 0, 0)
  t264 = 0.1e1 / t32 / t41 / r0
  t268 = f.my_piecewise3(t48, t257, -0.5e1 / 0.18e2 * l0 * t43 + 0.10e2 / 0.9e1 * t37 * t43 - 0.2e1 / 0.9e1 * t40 * t264)
  t270 = t51 ** 2
  t271 = 0.1e1 / t270
  t274 = jnp.exp(-0.2e1 / 0.3e1 * t52)
  t275 = 0.1e1 / t274
  t278 = 0.1e1 / (t155 - 0.2e1 * t52 + 0.3e1)
  t279 = t275 * t278
  t281 = (t52 - 0.2e1) ** 2
  t282 = t279 * t281
  t283 = t52 * t268 * t271 * t282
  t287 = t55 / t152
  t288 = t28 ** 2
  t289 = t288 * t268
  t290 = t271 * t275
  t292 = t278 * t281
  t293 = t292 * t59
  t297 = t279 * t281 * t56
  t300 = t289 * t290 * t293 - t289 * t271 * t297 / 0.2e1
  t302 = t287 * t52 * t300
  t310 = f.my_piecewise3(t10, 0, -t245 * t251 / 0.6e1 - t256 * t283 / 0.6e1 - t30 * t302 / 0.2e1 + t256 * t268 * t271 * t282 / 0.2e1)
  t312 = t11 * t198 * t29
  t313 = -t246
  t314 = f.my_piecewise5(t19, 0, t15, 0, t313)
  t316 = t314 * t3 + t68 + 0.1e1
  t321 = f.my_piecewise3(t67, 0, -t312 * t106 * t96 * t316 / 0.6e1)
  t323 = params.cab * (t310 + t321)
  t326 = 0.1e1 / t113
  t334 = t137 * t140
  t335 = t334 * t144
  t336 = t126 * t123 * t128 * t132 * t335
  t337 = t146 * t150
  t338 = t337 * t154
  t339 = t156 * t176
  t340 = f.my_piecewise5(t119, 0, t121, 0, t246)
  t349 = 0.41666666666666666666666666666666666666666666666667e-2 * t129 * t131 * t137 * t140 * t178
  t360 = t129 * t132
  t361 = t23 ** 2
  t366 = t360 * t334 / t25 / t361 / t4
  t373 = 0.1e1 / t288
  t376 = t129 * t138 * t140 * t144 * t373 * t150
  t377 = t176 * t268
  t379 = t290 * t292
  t383 = t360 * t335
  t386 = t337 / t153 / t60
  t392 = t154 * t155 * t52
  t401 = t159 * t255
  t405 = t158 * t26 * t29
  t410 = t158 * t26 * t28 * t55
  t417 = 0.1e1 / t165
  t419 = t167 * t128
  t424 = t25 * t28 * t54 * t60 * t172
  t426 = t25 ** 2
  t429 = t168 * t128 / t426
  t434 = t168 * t128
  t435 = t25 * jnp.pi
  t441 = t290 * t278 * t281 * t54 * t173
  t448 = t434 * t435 * t54
  t450 = t60 / t155
  t460 = f.my_piecewise3(t10, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t336 * t338 * t339 * t340 - t349 - 0.25000000000000000000000000000000000000000000000000e-2 * t129 * t132 * (-0.10e2 / 0.3e1 * tau0 * t43 + 0.2e1 / 0.3e1 * s0 * t264) * t140 * t178 + 0.33333333333333333333333333333333333333333333333333e-2 * t366 * t338 * t339 * t249 + 0.33333333333333333333333333333333333333333333333333e-2 * t376 * t157 * t377 * t379 + 0.10000000000000000000000000000000000000000000000000e-1 * t383 * t386 * t339 * t300 - 0.10000000000000000000000000000000000000000000000000e-1 * t376 * t392 * t377 * t379 - 0.25000000000000000000000000000000000000000000000000e-2 * t142 * t151 * t157 * (-(-t158 * t144 * t29 * t251 / 0.6e1 - t401 * t283 / 0.6e1 - t405 * t302 / 0.2e1 + t410 * t61 * t268 * t271 * t282 / 0.2e1) * t417 * t419 * t424 - t429 * t171 * t173 * t249 / 0.3e1 - t434 * t435 * t268 * t441 / 0.3e1 - t170 * t171 * t300 * t172 + t448 * t450 * t268 * t379))
  t464 = t193 * t140
  t465 = t464 * t198
  t466 = t186 * t183 * t128 * t132 * t465
  t467 = t146 * t202
  t468 = t467 * t206
  t469 = t208 * t226
  t470 = f.my_piecewise5(t121, 0, t119, 0, t313)
  t479 = 0.41666666666666666666666666666666666666666666666667e-2 * t188 * t131 * t193 * t140 * t228
  t480 = t188 * t132
  t481 = t69 ** 2
  t486 = t480 * t464 / t71 / t481 / t4
  t493 = 0.1e1 / t216
  t496 = t71 ** 2
  t499 = t218 * t128 / t496
  t510 = f.my_piecewise3(t67, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t466 * t468 * t469 * t470 - t479 + 0.33333333333333333333333333333333333333333333333333e-2 * t486 * t468 * t469 * t316 - 0.25000000000000000000000000000000000000000000000000e-2 * t196 * t203 * t209 * (0.1e1 / t69 * t12 * t316 * t493 / 0.3e1 - t499 * t221 * t223 * t316 / 0.3e1))
  vrho_0_ = -t117 + t181 + t231 + t3 * (-(-t233 + t237) * t3 * t116 - t243 - t9 * t323 * t115 - t9 * t112 * (-t323 * t326 + t323) + t460 + t510)
  t516 = -t12 - t232
  t517 = f.my_piecewise5(t15, 0, t19, 0, t516)
  t519 = t517 * t3 + t22 + 0.1e1
  t524 = f.my_piecewise3(t10, 0, -t245 * t62 * t52 * t519 / 0.6e1)
  t525 = -t516
  t526 = f.my_piecewise5(t19, 0, t15, 0, t525)
  t528 = t526 * t3 + t68 + 0.1e1
  t530 = t106 * t96 * t528
  t534 = t28 * t99 * t105
  t535 = t73 * t534
  t536 = f.my_piecewise3(t93, 0, 0)
  t543 = 0.1e1 / t76 / t85 / r1
  t547 = f.my_piecewise3(t92, t536, -0.5e1 / 0.18e2 * l1 * t87 + 0.10e2 / 0.9e1 * t81 * t87 - 0.2e1 / 0.9e1 * t84 * t543)
  t549 = t95 ** 2
  t550 = 0.1e1 / t549
  t553 = jnp.exp(-0.2e1 / 0.3e1 * t96)
  t554 = 0.1e1 / t553
  t557 = 0.1e1 / (t207 - 0.2e1 * t96 + 0.3e1)
  t558 = t554 * t557
  t560 = (t96 - 0.2e1) ** 2
  t561 = t558 * t560
  t562 = t96 * t547 * t550 * t561
  t566 = t99 / t204
  t567 = t288 * t547
  t568 = t550 * t554
  t570 = t557 * t560
  t571 = t570 * t103
  t575 = t558 * t560 * t100
  t578 = t567 * t568 * t571 - t567 * t550 * t575 / 0.2e1
  t580 = t566 * t96 * t578
  t588 = f.my_piecewise3(t67, 0, -t312 * t530 / 0.6e1 - t535 * t562 / 0.6e1 - t74 * t580 / 0.2e1 + t535 * t547 * t550 * t561 / 0.2e1)
  t590 = params.cab * (t524 + t588)
  t597 = f.my_piecewise5(t119, 0, t121, 0, t516)
  t620 = f.my_piecewise3(t10, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t336 * t338 * t339 * t597 - t349 + 0.33333333333333333333333333333333333333333333333333e-2 * t366 * t338 * t339 * t519 - 0.25000000000000000000000000000000000000000000000000e-2 * t142 * t151 * t157 * (0.1e1 / t23 * t12 * t519 * t417 / 0.3e1 - t429 * t171 * t173 * t519 / 0.3e1))
  t621 = f.my_piecewise5(t121, 0, t119, 0, t525)
  t644 = t188 * t194 * t140 * t198 * t373 * t202
  t645 = t226 * t547
  t647 = t568 * t570
  t651 = t480 * t465
  t654 = t467 / t205 / t104
  t660 = t206 * t207 * t96
  t669 = t210 * t534
  t673 = t158 * t72 * t29
  t678 = t158 * t72 * t28 * t99
  t690 = t71 * t28 * t98 * t104 * t222
  t696 = t218 * t128
  t697 = t71 * jnp.pi
  t703 = t568 * t557 * t560 * t98 * t223
  t710 = t696 * t697 * t98
  t712 = t104 / t207
  t722 = f.my_piecewise3(t67, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t466 * t468 * t469 * t621 - t479 - 0.25000000000000000000000000000000000000000000000000e-2 * t188 * t132 * (-0.10e2 / 0.3e1 * tau1 * t87 + 0.2e1 / 0.3e1 * s2 * t543) * t140 * t228 + 0.33333333333333333333333333333333333333333333333333e-2 * t486 * t468 * t469 * t528 + 0.33333333333333333333333333333333333333333333333333e-2 * t644 * t209 * t645 * t647 + 0.10000000000000000000000000000000000000000000000000e-1 * t651 * t654 * t469 * t578 - 0.10000000000000000000000000000000000000000000000000e-1 * t644 * t660 * t645 * t647 - 0.25000000000000000000000000000000000000000000000000e-2 * t196 * t203 * t209 * (-(-t158 * t198 * t29 * t530 / 0.6e1 - t669 * t562 / 0.6e1 - t673 * t580 / 0.2e1 + t678 * t105 * t547 * t550 * t561 / 0.2e1) * t493 * t419 * t690 - t499 * t221 * t223 * t528 / 0.3e1 - t696 * t697 * t547 * t703 / 0.3e1 - t220 * t221 * t578 * t222 + t710 * t712 * t547 * t647))
  vrho_1_ = -t117 + t181 + t231 + t3 * (-(t233 + t237) * t3 * t116 - t243 - t9 * t590 * t115 - t9 * t112 * (-t590 * t326 + t590) + t620 + t722)
  t727 = f.my_piecewise3(t48, t257, params.gamma * t43 / 0.12e2)
  t730 = t52 * t727 * t271 * t282
  t733 = t288 * t727
  t739 = t733 * t290 * t293 - t733 * t271 * t297 / 0.2e1
  t741 = t287 * t52 * t739
  t749 = f.my_piecewise3(t10, 0, -t256 * t730 / 0.6e1 - t30 * t741 / 0.2e1 + t256 * t727 * t271 * t282 / 0.2e1)
  t750 = params.cab * t749
  t762 = t176 * t727
  t804 = f.my_piecewise3(t10, 0, 0.62500000000000000000000000000000000000000000000000e-3 * t129 * t132 * t43 * t140 * t178 + 0.33333333333333333333333333333333333333333333333333e-2 * t376 * t157 * t762 * t379 + 0.10000000000000000000000000000000000000000000000000e-1 * t383 * t386 * t339 * t739 - 0.10000000000000000000000000000000000000000000000000e-1 * t376 * t392 * t762 * t379 - 0.25000000000000000000000000000000000000000000000000e-2 * t142 * t151 * t157 * (-(-t401 * t730 / 0.6e1 - t405 * t741 / 0.2e1 + t410 * t61 * t727 * t271 * t282 / 0.2e1) * t417 * t419 * t424 - t434 * t435 * t727 * t441 / 0.3e1 - t170 * t171 * t739 * t172 + t448 * t450 * t727 * t379))
  vsigma_0_ = t3 * (-t9 * t750 * t115 - t9 * t112 * (-t750 * t326 + t750) + t804)
  vsigma_1_ = 0.0e0
  t808 = f.my_piecewise3(t92, t536, params.gamma * t87 / 0.12e2)
  t811 = t96 * t808 * t550 * t561
  t814 = t288 * t808
  t820 = t814 * t568 * t571 - t814 * t550 * t575 / 0.2e1
  t822 = t566 * t96 * t820
  t830 = f.my_piecewise3(t67, 0, -t535 * t811 / 0.6e1 - t74 * t822 / 0.2e1 + t535 * t808 * t550 * t561 / 0.2e1)
  t831 = params.cab * t830
  t843 = t226 * t808
  t885 = f.my_piecewise3(t67, 0, 0.62500000000000000000000000000000000000000000000000e-3 * t188 * t132 * t87 * t140 * t228 + 0.33333333333333333333333333333333333333333333333333e-2 * t644 * t209 * t843 * t647 + 0.10000000000000000000000000000000000000000000000000e-1 * t651 * t654 * t469 * t820 - 0.10000000000000000000000000000000000000000000000000e-1 * t644 * t660 * t843 * t647 - 0.25000000000000000000000000000000000000000000000000e-2 * t196 * t203 * t209 * (-(-t669 * t811 / 0.6e1 - t673 * t822 / 0.2e1 + t678 * t105 * t808 * t550 * t561 / 0.2e1) * t493 * t419 * t690 - t696 * t697 * t808 * t703 / 0.3e1 - t220 * t221 * t820 * t222 + t710 * t712 * t808 * t647))
  vsigma_2_ = t3 * (-t9 * t831 * t115 - t9 * t112 * (-t831 * t326 + t831) + t885)
  t888 = f.my_piecewise3(t48, t257, t34 / 0.6e1)
  t891 = t52 * t888 * t271 * t282
  t894 = t288 * t888
  t900 = t894 * t290 * t293 - t894 * t271 * t297 / 0.2e1
  t902 = t287 * t52 * t900
  t910 = f.my_piecewise3(t10, 0, -t256 * t891 / 0.6e1 - t30 * t902 / 0.2e1 + t256 * t888 * t271 * t282 / 0.2e1)
  t911 = params.cab * t910
  t918 = t176 * t888
  t960 = f.my_piecewise3(t10, 0, 0.33333333333333333333333333333333333333333333333333e-2 * t376 * t157 * t918 * t379 + 0.10000000000000000000000000000000000000000000000000e-1 * t383 * t386 * t339 * t900 - 0.10000000000000000000000000000000000000000000000000e-1 * t376 * t392 * t918 * t379 - 0.25000000000000000000000000000000000000000000000000e-2 * t142 * t151 * t157 * (-(-t401 * t891 / 0.6e1 - t405 * t902 / 0.2e1 + t410 * t61 * t888 * t271 * t282 / 0.2e1) * t417 * t419 * t424 - t434 * t435 * t888 * t441 / 0.3e1 - t170 * t171 * t900 * t172 + t448 * t450 * t888 * t379))
  vlapl_0_ = t3 * (-t9 * t911 * t115 - t9 * t112 * (-t911 * t326 + t911) + t960)
  t963 = f.my_piecewise3(t92, t536, t78 / 0.6e1)
  t966 = t96 * t963 * t550 * t561
  t969 = t288 * t963
  t975 = t969 * t568 * t571 - t969 * t550 * t575 / 0.2e1
  t977 = t566 * t96 * t975
  t985 = f.my_piecewise3(t67, 0, -t535 * t966 / 0.6e1 - t74 * t977 / 0.2e1 + t535 * t963 * t550 * t561 / 0.2e1)
  t986 = params.cab * t985
  t993 = t226 * t963
  t1035 = f.my_piecewise3(t67, 0, 0.33333333333333333333333333333333333333333333333333e-2 * t644 * t209 * t993 * t647 + 0.10000000000000000000000000000000000000000000000000e-1 * t651 * t654 * t469 * t975 - 0.10000000000000000000000000000000000000000000000000e-1 * t644 * t660 * t993 * t647 - 0.25000000000000000000000000000000000000000000000000e-2 * t196 * t203 * t209 * (-(-t669 * t966 / 0.6e1 - t673 * t977 / 0.2e1 + t678 * t105 * t963 * t550 * t561 / 0.2e1) * t493 * t419 * t690 - t696 * t697 * t963 * t703 / 0.3e1 - t220 * t221 * t975 * t222 + t710 * t712 * t963 * t647))
  vlapl_1_ = t3 * (-t9 * t986 * t115 - t9 * t112 * (-t986 * t326 + t986) + t1035)
  t1039 = f.my_piecewise3(t48, t257, -0.2e1 / 0.3e1 * params.gamma * t34)
  t1042 = t52 * t1039 * t271 * t282
  t1045 = t288 * t1039
  t1051 = t1045 * t290 * t293 - t1045 * t271 * t297 / 0.2e1
  t1053 = t287 * t52 * t1051
  t1061 = f.my_piecewise3(t10, 0, -t256 * t1042 / 0.6e1 - t30 * t1053 / 0.2e1 + t256 * t1039 * t271 * t282 / 0.2e1)
  t1062 = params.cab * t1061
  t1074 = t176 * t1039
  t1116 = f.my_piecewise3(t10, 0, -0.50000000000000000000000000000000000000000000000000e-2 * t129 * t132 * t34 * t140 * t178 + 0.33333333333333333333333333333333333333333333333333e-2 * t376 * t157 * t1074 * t379 + 0.10000000000000000000000000000000000000000000000000e-1 * t383 * t386 * t339 * t1051 - 0.10000000000000000000000000000000000000000000000000e-1 * t376 * t392 * t1074 * t379 - 0.25000000000000000000000000000000000000000000000000e-2 * t142 * t151 * t157 * (-(-t401 * t1042 / 0.6e1 - t405 * t1053 / 0.2e1 + t410 * t61 * t1039 * t271 * t282 / 0.2e1) * t417 * t419 * t424 - t434 * t435 * t1039 * t441 / 0.3e1 - t170 * t171 * t1051 * t172 + t448 * t450 * t1039 * t379))
  vtau_0_ = t3 * (-t9 * t1062 * t115 - t9 * t112 * (-t1062 * t326 + t1062) + t1116)
  t1120 = f.my_piecewise3(t92, t536, -0.2e1 / 0.3e1 * params.gamma * t78)
  t1123 = t96 * t1120 * t550 * t561
  t1126 = t288 * t1120
  t1132 = t1126 * t568 * t571 - t1126 * t550 * t575 / 0.2e1
  t1134 = t566 * t96 * t1132
  t1142 = f.my_piecewise3(t67, 0, -t535 * t1123 / 0.6e1 - t74 * t1134 / 0.2e1 + t535 * t1120 * t550 * t561 / 0.2e1)
  t1143 = params.cab * t1142
  t1155 = t226 * t1120
  t1197 = f.my_piecewise3(t67, 0, -0.50000000000000000000000000000000000000000000000000e-2 * t188 * t132 * t78 * t140 * t228 + 0.33333333333333333333333333333333333333333333333333e-2 * t644 * t209 * t1155 * t647 + 0.10000000000000000000000000000000000000000000000000e-1 * t651 * t654 * t469 * t1132 - 0.10000000000000000000000000000000000000000000000000e-1 * t644 * t660 * t1155 * t647 - 0.25000000000000000000000000000000000000000000000000e-2 * t196 * t203 * t209 * (-(-t669 * t1123 / 0.6e1 - t673 * t1134 / 0.2e1 + t678 * t105 * t1120 * t550 * t561 / 0.2e1) * t493 * t419 * t690 - t696 * t697 * t1120 * t703 / 0.3e1 - t220 * t221 * t1132 * t222 + t710 * t712 * t1120 * t647))
  vtau_1_ = t3 * (-t9 * t1143 * t115 - t9 * t112 * (-t1143 * t326 + t1143) + t1197)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_cab_raw = params.cab
  if isinstance(params_cab_raw, (str, bytes, dict)):
    params_cab = params_cab_raw
  else:
    try:
      params_cab_seq = list(params_cab_raw)
    except TypeError:
      params_cab = params_cab_raw
    else:
      params_cab_seq = np.asarray(params_cab_seq, dtype=np.float64)
      params_cab = np.concatenate((np.array([np.nan], dtype=np.float64), params_cab_seq))
  params_css_raw = params.css
  if isinstance(params_css_raw, (str, bytes, dict)):
    params_css = params_css_raw
  else:
    try:
      params_css_seq = list(params_css_raw)
    except TypeError:
      params_css = params_css_raw
    else:
      params_css_seq = np.asarray(params_css_seq, dtype=np.float64)
      params_css = np.concatenate((np.array([np.nan], dtype=np.float64), params_css_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  params_at = 0

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  b94_css = lambda rs, z, xs, us, ts: -0.01 * (1 + z) ** (8 / 3) * 2 ** (-8 / 3) * f.n_total(rs) ** (5 / 3) * (2 * ts - xs ** 2 / 4) * b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) ** 4 * (1 - 2 * jnp.log(1 + b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts) / 2) / b94_zss(f, params, params_css, br89_f, rs, z, xs, us, ts))

  b94_cab = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: -0.8 * (1 - z ** 2) / 4 * f.n_total(rs) * b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) * (b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1) - jnp.log(1 + b94_zab(f, params, params_cab, br89_f, rs, z, xs0, xs1, us0, us1, ts0, ts1)))

  b94_par = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.my_piecewise3(f.screen_dens(rs, z), 0, b94_css(rs, f.z_thr(z), xs0, us0, ts0)) + f.my_piecewise3(f.screen_dens(rs, -z), 0, b94_css(rs, f.z_thr(-z), xs1, us1, ts1))

  b94_c_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +b94_cab(rs, z, xs0, xs1, us0, us1, ts0, ts1) + b94_par(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b94_c_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  t1 = r0 * params.cab
  t3 = r0 / 0.2e1 <= f.p.dens_threshold
  t4 = 2 ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 <= f.p.zeta_threshold
  t6 = f.p.zeta_threshold - 0.1e1
  t8 = f.my_piecewise5(t5, t6, t5, -t6, 0)
  t9 = 0.1e1 + t8
  t10 = t9 * r0
  t11 = t10 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 / t11
  t13 = t4 * t12
  t14 = jnp.pi ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t14
  t16 = t13 * t15
  t17 = t4 ** 2
  t18 = l0 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t20 * r0
  t22 = 0.1e1 / t21
  t25 = params.gamma * tau0
  t26 = t17 * t22
  t29 = params.gamma * s0
  t30 = r0 ** 2
  t32 = 0.1e1 / t20 / t30
  t33 = t17 * t32
  t36 = t18 * t22 / 0.6e1 - 0.2e1 / 0.3e1 * t25 * t26 + t29 * t33 / 0.12e2
  t37 = abs(t36)
  t38 = t37 < 0.50e-12
  t39 = 0.0e0 < t36
  t40 = f.my_piecewise3(t39, 0.50e-12, -0.50e-12)
  t41 = f.my_piecewise3(t38, t40, t36)
  t42 = br89_x(t41)
  t44 = jnp.exp(t42 / 0.3e1)
  t45 = 0.1e1 / t44
  t46 = jnp.exp(-t42)
  t49 = t46 * (0.1e1 + t42 / 0.2e1)
  t50 = 0.1e1 - t49
  t51 = 0.1e1 / t50
  t52 = t45 * t51
  t56 = f.my_piecewise3(t3, 0, t16 * t52 * t42 / 0.2e1)
  t57 = params.cab * t56
  t58 = 0.2e1 * t57
  t59 = 0.1e1 + t58
  t60 = jnp.log(t59)
  t61 = t58 - t60
  t65 = t9 ** 2
  t66 = t9 ** (0.1e1 / 0.3e1)
  t67 = t66 ** 2
  t68 = t67 * t65
  t69 = t68 * t17
  t70 = tau0 * t17
  t73 = s0 * t17
  t76 = 0.2e1 * t70 * t22 - t73 * t32 / 0.4e1
  t77 = t21 * t76
  t78 = params.css ** 2
  t79 = t78 ** 2
  t80 = t77 * t79
  t81 = t69 * t80
  t83 = 0.1e1 / t11 / t10
  t85 = 0.1e1 / t14 / jnp.pi
  t87 = t44 ** 2
  t88 = t87 ** 2
  t89 = 0.1e1 / t88
  t90 = t83 * t85 * t89
  t91 = t50 ** 2
  t92 = t91 ** 2
  t93 = 0.1e1 / t92
  t94 = t42 ** 2
  t95 = t94 ** 2
  t96 = t93 * t95
  t97 = params.css * t4
  t98 = t97 * t12
  t104 = 0.1e1 + t98 * t15 * t45 * t51 * t42 / 0.2e1
  t105 = jnp.log(t104)
  t106 = 0.1e1 / params.css
  t107 = t105 * t106
  t109 = t107 * t17 * t11
  t110 = t14 * t44
  t111 = 0.1e1 / t42
  t112 = t50 * t111
  t115 = -t109 * t110 * t112 + 0.1e1
  t116 = t96 * t115
  t117 = t90 * t116
  t120 = f.my_piecewise3(t3, 0, -0.25000000000000000000000000000000000000000000000000e-2 * t81 * t117)
  t127 = t52 * t42 * t9
  t131 = t14 * t45 * t51
  t132 = t13 * t131
  t133 = f.my_piecewise3(t39, 0, 0)
  t140 = 0.1e1 / t20 / t30 / r0
  t145 = f.my_piecewise3(t38, t133, -0.5e1 / 0.18e2 * t18 * t32 + 0.10e2 / 0.9e1 * t25 * t33 - 0.2e1 / 0.9e1 * t29 * t17 * t140)
  t147 = t41 ** 2
  t148 = 0.1e1 / t147
  t151 = jnp.exp(-0.2e1 / 0.3e1 * t42)
  t152 = 0.1e1 / t151
  t155 = 0.1e1 / (t94 - 0.2e1 * t42 + 0.3e1)
  t156 = t152 * t155
  t158 = (t42 - 0.2e1) ** 2
  t159 = t156 * t158
  t160 = t42 * t145 * t148 * t159
  t164 = t45 / t91
  t165 = t14 ** 2
  t166 = t165 * t145
  t167 = t148 * t152
  t169 = t155 * t158
  t170 = t169 * t49
  t174 = t156 * t158 * t46
  t177 = t166 * t167 * t170 - t166 * t148 * t174 / 0.2e1
  t179 = t164 * t42 * t177
  t187 = f.my_piecewise3(t3, 0, -t4 * t83 * t15 * t127 / 0.6e1 - t132 * t160 / 0.6e1 - t16 * t179 / 0.2e1 + t132 * t145 * t148 * t159 / 0.2e1)
  t191 = params.cab * t187
  t192 = 0.1e1 / t59
  t227 = t79 * t83
  t231 = t69 * t77 * t227 / t165 * t89
  t232 = t115 * t145
  t234 = t167 * t169
  t241 = t69 * t21 * t76 * t79 * t83
  t242 = t85 * t89
  t245 = t242 / t92 / t50
  t246 = t95 * t115
  t252 = t93 * t94 * t42
  t261 = t98 * t131
  t265 = t97 * t12 * t15
  t270 = t97 * t12 * t14 * t45
  t277 = 0.1e1 / t104
  t279 = t106 * t17
  t284 = t11 * t14 * t44 * t50 * t111
  t286 = t11 ** 2
  t294 = t107 * t17
  t295 = t11 * jnp.pi
  t301 = t167 * t155 * t158 * t44 * t112
  t308 = t294 * t295 * t44
  t310 = t50 / t94
  t320 = f.my_piecewise3(t3, 0, -0.41666666666666666666666666666666666666666666666667e-2 * t69 * t20 * t76 * t79 * t117 - 0.25000000000000000000000000000000000000000000000000e-2 * t69 * t21 * (-0.10e2 / 0.3e1 * t70 * t32 + 0.2e1 / 0.3e1 * t73 * t140) * t79 * t117 + 0.33333333333333333333333333333333333333333333333333e-2 * t67 * t9 * t17 * t80 / t11 / t30 * t85 * t89 * t116 + 0.33333333333333333333333333333333333333333333333333e-2 * t231 * t96 * t232 * t234 + 0.10000000000000000000000000000000000000000000000000e-1 * t241 * t245 * t246 * t177 - 0.10000000000000000000000000000000000000000000000000e-1 * t231 * t252 * t232 * t234 - 0.25000000000000000000000000000000000000000000000000e-2 * t81 * t90 * t96 * (-(-t97 * t83 * t15 * t127 / 0.6e1 - t261 * t160 / 0.6e1 - t265 * t179 / 0.2e1 + t270 * t51 * t145 * t148 * t159 / 0.2e1) * t277 * t279 * t284 - t107 * t17 / t286 * t110 * t112 * t9 / 0.3e1 - t294 * t295 * t145 * t301 / 0.3e1 - t109 * t110 * t177 * t111 + t308 * t310 * t145 * t234))
  vrho_0_ = -0.40000000000000000000000000000000000000000000000000e0 * t1 * t56 * t61 + 0.2e1 * t120 + r0 * (-0.40000000000000000000000000000000000000000000000000e0 * t57 * t61 - 0.40000000000000000000000000000000000000000000000000e0 * t1 * t187 * t61 - 0.40000000000000000000000000000000000000000000000000e0 * t1 * t56 * (-0.2e1 * t191 * t192 + 0.2e1 * t191) + 0.2e1 * t320)
  t324 = params.gamma * t17
  t327 = f.my_piecewise3(t38, t133, t324 * t32 / 0.12e2)
  t330 = t42 * t327 * t148 * t159
  t333 = t165 * t327
  t339 = t333 * t167 * t170 - t333 * t148 * t174 / 0.2e1
  t341 = t164 * t42 * t339
  t349 = f.my_piecewise3(t3, 0, -t132 * t330 / 0.6e1 - t16 * t341 / 0.2e1 + t132 * t327 * t148 * t159 / 0.2e1)
  t353 = params.cab * t349
  t360 = t68 * t4
  t365 = t242 * t116
  t368 = t115 * t327
  t410 = f.my_piecewise3(t3, 0, 0.12500000000000000000000000000000000000000000000000e-2 * t360 / r0 * t79 * t83 * t365 + 0.33333333333333333333333333333333333333333333333333e-2 * t231 * t96 * t368 * t234 + 0.10000000000000000000000000000000000000000000000000e-1 * t241 * t245 * t246 * t339 - 0.10000000000000000000000000000000000000000000000000e-1 * t231 * t252 * t368 * t234 - 0.25000000000000000000000000000000000000000000000000e-2 * t81 * t90 * t96 * (-(-t261 * t330 / 0.6e1 - t265 * t341 / 0.2e1 + t270 * t51 * t327 * t148 * t159 / 0.2e1) * t277 * t279 * t284 - t294 * t295 * t327 * t301 / 0.3e1 - t109 * t110 * t339 * t111 + t308 * t310 * t327 * t234))
  vsigma_0_ = r0 * (-0.40000000000000000000000000000000000000000000000000e0 * t1 * t349 * t61 - 0.40000000000000000000000000000000000000000000000000e0 * t1 * t56 * (-0.2e1 * t353 * t192 + 0.2e1 * t353) + 0.2e1 * t410)
  t414 = f.my_piecewise3(t38, t133, t26 / 0.6e1)
  t417 = t42 * t414 * t148 * t159
  t420 = t165 * t414
  t426 = t420 * t167 * t170 - t420 * t148 * t174 / 0.2e1
  t428 = t164 * t42 * t426
  t436 = f.my_piecewise3(t3, 0, -t132 * t417 / 0.6e1 - t16 * t428 / 0.2e1 + t132 * t414 * t148 * t159 / 0.2e1)
  t440 = params.cab * t436
  t447 = t115 * t414
  t489 = f.my_piecewise3(t3, 0, 0.33333333333333333333333333333333333333333333333333e-2 * t231 * t96 * t447 * t234 + 0.10000000000000000000000000000000000000000000000000e-1 * t241 * t245 * t246 * t426 - 0.10000000000000000000000000000000000000000000000000e-1 * t231 * t252 * t447 * t234 - 0.25000000000000000000000000000000000000000000000000e-2 * t81 * t90 * t96 * (-(-t261 * t417 / 0.6e1 - t265 * t428 / 0.2e1 + t270 * t51 * t414 * t148 * t159 / 0.2e1) * t277 * t279 * t284 - t294 * t295 * t414 * t301 / 0.3e1 - t109 * t110 * t426 * t111 + t308 * t310 * t414 * t234))
  vlapl_0_ = r0 * (-0.40000000000000000000000000000000000000000000000000e0 * t1 * t436 * t61 - 0.40000000000000000000000000000000000000000000000000e0 * t1 * t56 * (-0.2e1 * t440 * t192 + 0.2e1 * t440) + 0.2e1 * t489)
  t494 = f.my_piecewise3(t38, t133, -0.2e1 / 0.3e1 * t324 * t22)
  t497 = t42 * t494 * t148 * t159
  t500 = t165 * t494
  t506 = t500 * t167 * t170 - t500 * t148 * t174 / 0.2e1
  t508 = t164 * t42 * t506
  t516 = f.my_piecewise3(t3, 0, -t132 * t497 / 0.6e1 - t16 * t508 / 0.2e1 + t132 * t494 * t148 * t159 / 0.2e1)
  t520 = params.cab * t516
  t530 = t115 * t494
  t572 = f.my_piecewise3(t3, 0, -0.10000000000000000000000000000000000000000000000000e-1 * t360 * t227 * t365 + 0.33333333333333333333333333333333333333333333333333e-2 * t231 * t96 * t530 * t234 + 0.10000000000000000000000000000000000000000000000000e-1 * t241 * t245 * t246 * t506 - 0.10000000000000000000000000000000000000000000000000e-1 * t231 * t252 * t530 * t234 - 0.25000000000000000000000000000000000000000000000000e-2 * t81 * t90 * t96 * (-(-t261 * t497 / 0.6e1 - t265 * t508 / 0.2e1 + t270 * t51 * t494 * t148 * t159 / 0.2e1) * t277 * t279 * t284 - t294 * t295 * t494 * t301 / 0.3e1 - t109 * t110 * t506 * t111 + t308 * t310 * t494 * t234))
  vtau_0_ = r0 * (-0.40000000000000000000000000000000000000000000000000e0 * t1 * t516 * t61 - 0.40000000000000000000000000000000000000000000000000e0 * t1 * t56 * (-0.2e1 * t520 * t192 + 0.2e1 * t520) + 0.2e1 * t572)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 2 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 <= f.p.zeta_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t7 = f.my_piecewise5(t4, t5, t4, -t5, 0)
  t8 = 0.1e1 + t7
  t9 = t8 * r0
  t10 = t9 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t10
  t12 = t3 * t11
  t13 = jnp.pi ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t13
  t15 = t12 * t14
  t16 = t3 ** 2
  t17 = l0 * t16
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t19 * r0
  t21 = 0.1e1 / t20
  t24 = params.gamma * tau0
  t28 = params.gamma * s0
  t29 = r0 ** 2
  t31 = 0.1e1 / t19 / t29
  t32 = t16 * t31
  t35 = t17 * t21 / 0.6e1 - 0.2e1 / 0.3e1 * t24 * t16 * t21 + t28 * t32 / 0.12e2
  t36 = abs(t35)
  t37 = t36 < 0.50e-12
  t38 = 0.0e0 < t35
  t39 = f.my_piecewise3(t38, 0.50e-12, -0.50e-12)
  t40 = f.my_piecewise3(t37, t39, t35)
  t41 = br89_x(t40)
  t43 = jnp.exp(t41 / 0.3e1)
  t44 = 0.1e1 / t43
  t45 = jnp.exp(-t41)
  t48 = t45 * (0.1e1 + t41 / 0.2e1)
  t49 = 0.1e1 - t48
  t50 = 0.1e1 / t49
  t51 = t44 * t50
  t52 = t51 * t41
  t55 = f.my_piecewise3(t2, 0, t15 * t52 / 0.2e1)
  t56 = params.cab * t55
  t57 = 0.2e1 * t56
  t58 = 0.1e1 + t57
  t59 = jnp.log(t58)
  t60 = t57 - t59
  t63 = r0 * params.cab
  t65 = 0.1e1 / t10 / t9
  t66 = t3 * t65
  t68 = t41 * t8
  t69 = t51 * t68
  t72 = t13 * t44
  t73 = t72 * t50
  t74 = t12 * t73
  t75 = f.my_piecewise3(t38, 0, 0)
  t80 = t29 * r0
  t82 = 0.1e1 / t19 / t80
  t83 = t16 * t82
  t87 = f.my_piecewise3(t37, t75, -0.5e1 / 0.18e2 * t17 * t31 + 0.10e2 / 0.9e1 * t24 * t32 - 0.2e1 / 0.9e1 * t28 * t83)
  t89 = t40 ** 2
  t90 = 0.1e1 / t89
  t91 = t41 * t87 * t90
  t93 = jnp.exp(-0.2e1 / 0.3e1 * t41)
  t94 = 0.1e1 / t93
  t95 = t41 ** 2
  t97 = t95 - 0.2e1 * t41 + 0.3e1
  t98 = 0.1e1 / t97
  t99 = t94 * t98
  t100 = t41 - 0.2e1
  t101 = t100 ** 2
  t102 = t99 * t101
  t103 = t91 * t102
  t106 = t49 ** 2
  t107 = 0.1e1 / t106
  t108 = t44 * t107
  t109 = t13 ** 2
  t110 = t109 * t87
  t111 = t90 * t94
  t112 = t110 * t111
  t113 = t98 * t101
  t114 = t113 * t48
  t116 = t110 * t90
  t118 = t99 * t101 * t45
  t121 = t112 * t114 - t116 * t118 / 0.2e1
  t123 = t108 * t41 * t121
  t126 = t87 * t90
  t127 = t126 * t102
  t131 = f.my_piecewise3(t2, 0, -t66 * t14 * t69 / 0.6e1 - t74 * t103 / 0.6e1 - t15 * t123 / 0.2e1 + t74 * t127 / 0.2e1)
  t135 = params.cab * t131
  t136 = 0.1e1 / t58
  t139 = -0.2e1 * t135 * t136 + 0.2e1 * t135
  t143 = t8 ** 2
  t144 = t8 ** (0.1e1 / 0.3e1)
  t145 = t144 ** 2
  t147 = t145 * t143 * t16
  t148 = tau0 * t16
  t151 = s0 * t16
  t154 = 0.2e1 * t148 * t21 - t151 * t31 / 0.4e1
  t155 = t19 * t154
  t156 = params.css ** 2
  t157 = t156 ** 2
  t158 = t155 * t157
  t159 = t147 * t158
  t160 = t13 * jnp.pi
  t161 = 0.1e1 / t160
  t163 = t43 ** 2
  t164 = t163 ** 2
  t165 = 0.1e1 / t164
  t166 = t65 * t161 * t165
  t167 = t106 ** 2
  t168 = 0.1e1 / t167
  t169 = t95 ** 2
  t170 = t168 * t169
  t171 = params.css * t3
  t172 = t171 * t11
  t173 = t14 * t44
  t178 = 0.1e1 + t172 * t173 * t50 * t41 / 0.2e1
  t179 = jnp.log(t178)
  t180 = 0.1e1 / params.css
  t181 = t179 * t180
  t182 = t16 * t10
  t183 = t181 * t182
  t184 = t13 * t43
  t185 = 0.1e1 / t41
  t186 = t49 * t185
  t189 = -t183 * t184 * t186 + 0.1e1
  t190 = t170 * t189
  t191 = t166 * t190
  t198 = -0.10e2 / 0.3e1 * t148 * t31 + 0.2e1 / 0.3e1 * t151 * t82
  t199 = t20 * t198
  t200 = t199 * t157
  t201 = t147 * t200
  t204 = t143 * t8
  t206 = t145 * t204 * t16
  t207 = t20 * t154
  t208 = t207 * t157
  t209 = t206 * t208
  t212 = 0.1e1 / t10 / t143 / t29
  t214 = t212 * t161 * t165
  t215 = t214 * t190
  t221 = 0.1e1 / t109 * t165
  t222 = t157 * t65 * t221
  t223 = t147 * t207 * t222
  t224 = t189 * t87
  t225 = t170 * t224
  t226 = t111 * t113
  t227 = t225 * t226
  t230 = t147 * t20
  t231 = t154 * t157
  t232 = t231 * t65
  t233 = t230 * t232
  t234 = t161 * t165
  t236 = 0.1e1 / t167 / t49
  t237 = t234 * t236
  t238 = t169 * t189
  t240 = t237 * t238 * t121
  t243 = t95 * t41
  t244 = t168 * t243
  t245 = t244 * t224
  t246 = t245 * t226
  t249 = t147 * t208
  t251 = t171 * t65 * t14
  t254 = t172 * t73
  t258 = t171 * t11 * t14
  t263 = t171 * t11 * t13 * t44
  t269 = -t251 * t69 / 0.6e1 - t254 * t103 / 0.6e1 - t258 * t123 / 0.2e1 + t263 * t50 * t87 * t90 * t102 / 0.2e1
  t270 = 0.1e1 / t178
  t271 = t269 * t270
  t272 = t180 * t16
  t273 = t271 * t272
  t274 = t10 * t13
  t275 = t43 * t49
  t277 = t274 * t275 * t185
  t279 = t10 ** 2
  t280 = 0.1e1 / t279
  t282 = t181 * t16 * t280
  t284 = t184 * t186 * t8
  t287 = t181 * t16
  t288 = t10 * jnp.pi
  t290 = t287 * t288 * t87
  t291 = t111 * t98
  t292 = t101 * t43
  t293 = t292 * t186
  t294 = t291 * t293
  t297 = t121 * t185
  t301 = t287 * t288 * t43
  t302 = 0.1e1 / t95
  t303 = t49 * t302
  t305 = t303 * t87 * t226
  t307 = -t273 * t277 - t282 * t284 / 0.3e1 - t290 * t294 / 0.3e1 - t183 * t184 * t297 + t301 * t305
  t308 = t170 * t307
  t309 = t166 * t308
  t313 = f.my_piecewise3(t2, 0, -0.41666666666666666666666666666666666666666666666667e-2 * t159 * t191 - 0.25000000000000000000000000000000000000000000000000e-2 * t201 * t191 + 0.33333333333333333333333333333333333333333333333333e-2 * t209 * t215 + 0.33333333333333333333333333333333333333333333333333e-2 * t223 * t227 + 0.10000000000000000000000000000000000000000000000000e-1 * t233 * t240 - 0.10000000000000000000000000000000000000000000000000e-1 * t223 * t246 - 0.25000000000000000000000000000000000000000000000000e-2 * t249 * t309)
  t322 = t51 * t41 * t143
  t329 = t8 * t87 * t90 * t102
  t342 = jnp.pi * t44 * t50
  t343 = t12 * t342
  t344 = t87 ** 2
  t345 = t41 * t344
  t346 = t89 ** 2
  t347 = 0.1e1 / t346
  t348 = t345 * t347
  t349 = t93 ** 2
  t350 = 0.1e1 / t349
  t351 = t97 ** 2
  t352 = 0.1e1 / t351
  t353 = t350 * t352
  t354 = t101 ** 2
  t356 = t348 * t353 * t354
  t359 = t12 * t13
  t362 = t126 * t94
  t363 = t113 * t121
  t364 = t362 * t363
  t371 = t29 ** 2
  t373 = 0.1e1 / t19 / t371
  t378 = f.my_piecewise3(t37, t75, 0.20e2 / 0.27e2 * t17 * t82 - 0.80e2 / 0.27e2 * t24 * t83 + 0.22e2 / 0.27e2 * t28 * t16 * t373)
  t381 = t41 * t378 * t90 * t102
  t385 = 0.1e1 / t89 / t40
  t387 = t345 * t385 * t102
  t391 = t352 * t101
  t397 = 0.2e1 * t41 * t109 * t87 * t226 - 0.2e1 * t116 * t102
  t398 = t391 * t397
  t399 = t362 * t398
  t402 = t101 * t100
  t403 = t353 * t402
  t404 = t348 * t403
  t410 = t121 ** 2
  t412 = t44 / t106 / t49 * t41 * t410
  t414 = t72 * t107
  t417 = t109 * t378
  t420 = t109 * t344
  t421 = t385 * t94
  t425 = t160 * t344
  t426 = t347 * t350
  t427 = t425 * t426
  t428 = t352 * t354
  t435 = t352 * t402
  t439 = t425 * t347
  t456 = t417 * t111 * t114 - 0.2e1 * t420 * t421 * t114 - t427 * t428 * t48 / 0.3e1 - t112 * t391 * t48 * t397 + 0.2e1 * t427 * t435 * t48 + 0.2e1 / 0.3e1 * t439 * t353 * t354 * t45 - t417 * t90 * t118 / 0.2e1 + t420 * t385 * t118 + t112 * t391 * t45 * t397 / 0.2e1 - t439 * t353 * t402 * t45
  t458 = t108 * t41 * t456
  t473 = 0.2e1 / 0.9e1 * t3 * t212 * t14 * t322 + t66 * t13 * t52 * t329 / 0.9e1 + t66 * t173 * t107 * t41 * t8 * t121 / 0.3e1 - t66 * t73 * t329 / 0.3e1 - t343 * t356 / 0.18e2 + t359 * t108 * t41 * t364 / 0.3e1 - t74 * t381 / 0.6e1 + t74 * t387 / 0.3e1 + t359 * t52 * t399 / 0.6e1 - t343 * t404 / 0.3e1 + t15 * t412 - t12 * t414 * t364 - t15 * t458 / 0.2e1 + t74 * t378 * t90 * t102 / 0.2e1 - t74 * t344 * t385 * t102 - t74 * t399 / 0.2e1 + t343 * t344 * t347 * t403
  t474 = f.my_piecewise3(t2, 0, t473)
  t481 = params.cab * t474
  t485 = params.cab ** 2
  t486 = t131 ** 2
  t488 = t58 ** 2
  t502 = t111 * t398
  t517 = t230 * t231 * t65 * t165
  t518 = t189 * t344
  t519 = t170 * t518
  t520 = t426 * t428
  t524 = t244 * t518
  t528 = t426 * t435
  t540 = t307 * t87
  t545 = t189 * t378
  t551 = t147 * t155 * t222
  t555 = t147 * t199 * t222
  t561 = t206 * t207 * t157 * t212 * t221
  t564 = t421 * t113
  t575 = -0.26666666666666666666666666666666666666666666666666e-1 * t223 * t236 * t169 * t224 * t111 * t363 - 0.33333333333333333333333333333333333333333333333333e-2 * t223 * t225 * t502 + 0.80000000000000000000000000000000000000000000000000e-1 * t223 * t236 * t243 * t189 * t121 * t127 + 0.10000000000000000000000000000000000000000000000000e-1 * t223 * t245 * t502 - 0.22222222222222222222222222222222222222222222222222e-2 * t517 * t519 * t520 + 0.20000000000000000000000000000000000000000000000000e-1 * t517 * t524 * t520 + 0.66666666666666666666666666666666666666666666666666e-2 * t517 * t519 * t528 - 0.30000000000000000000000000000000000000000000000000e-1 * t517 * t168 * t95 * t518 * t520 - 0.20000000000000000000000000000000000000000000000000e-1 * t517 * t524 * t528 - 0.20000000000000000000000000000000000000000000000000e-1 * t223 * t244 * t540 * t226 - 0.10000000000000000000000000000000000000000000000000e-1 * t223 * t244 * t545 * t226 - 0.33333333333333333333333333333333333333333333333334e-1 * t551 * t246 - 0.20000000000000000000000000000000000000000000000000e-1 * t555 * t246 + 0.26666666666666666666666666666666666666666666666666e-1 * t561 * t246 + 0.20000000000000000000000000000000000000000000000000e-1 * t223 * t524 * t564 - 0.66666666666666666666666666666666666666666666666666e-2 * t223 * t519 * t564 + 0.11111111111111111111111111111111111111111111111111e-1 * t551 * t227 + 0.66666666666666666666666666666666666666666666666666e-2 * t555 * t227
  t617 = t10 * t109 * jnp.pi
  t619 = t287 * t617 * t43
  t620 = t303 * t344
  t627 = t280 * jnp.pi
  t635 = t271 * t180
  t641 = t269 ** 2
  t642 = t178 ** 2
  t668 = t287 * t617 * t344
  t669 = t426 * t352
  t670 = t354 * t43
  t683 = 0.2e1 * t619 * t620 * t528 - t183 * t184 * t456 * t185 + 0.2e1 / 0.3e1 * t287 * t627 * t275 * t302 * t8 * t87 * t226 + 0.2e1 * t635 * t182 * jnp.pi * t43 * t305 + t641 / t642 * t272 * t277 - 0.2e1 / 0.3e1 * t271 * t272 * t280 * t284 + 0.2e1 / 0.9e1 * t181 * t16 / t279 / t9 * t184 * t186 * t143 - t287 * t288 * t378 * t294 / 0.3e1 - 0.2e1 / 0.3e1 * t290 * t291 * t292 * t297 - t668 * t669 * t670 * t186 / 0.3e1 + t301 * t303 * t378 * t226 - 0.2e1 * t273 * t274 * t43 * t121 * t185
  t693 = t171 * t65 * t73
  t704 = t172 * t342
  t707 = t172 * t414
  t717 = t94 * t352
  t719 = t717 * t101 * t397
  t734 = t50 * t344
  t746 = 0.2e1 / 0.9e1 * t171 * t212 * t14 * t322 + t693 * t68 * t87 * t226 / 0.9e1 + t251 * t108 * t68 * t121 / 0.3e1 - t693 * t329 / 0.3e1 - t704 * t356 / 0.18e2 + t707 * t91 * t99 * t101 * t121 / 0.3e1 - t254 * t381 / 0.6e1 + t254 * t387 / 0.3e1 + t254 * t91 * t719 / 0.6e1 - t704 * t404 / 0.3e1 + t258 * t412 - t707 * t364 - t258 * t458 / 0.2e1 + t263 * t50 * t378 * t90 * t102 / 0.2e1 - t263 * t734 * t385 * t102 - t254 * t399 / 0.2e1 + t171 * t11 * jnp.pi * t44 * t734 * t347 * t403
  t805 = -0.2e1 / 0.3e1 * t282 * t184 * t297 * t8 - t746 * t270 * t272 * t277 - 0.2e1 / 0.3e1 * t668 * t669 * t402 * t43 * t186 + 0.4e1 / 0.3e1 * t668 * t669 * t670 * t303 - 0.2e1 * t619 * t49 / t243 * t344 * t520 - 0.2e1 / 0.3e1 * t635 * t182 * jnp.pi * t87 * t294 - 0.2e1 / 0.9e1 * t287 * t627 * t126 * t102 * t275 * t185 * t8 + 0.2e1 / 0.3e1 * t287 * t288 * t344 * t421 * t98 * t293 + t287 * t288 * t126 * t717 * t101 * t275 * t185 * t397 / 0.3e1 + 0.2e1 * t301 * t121 * t302 * t87 * t226 - 0.2e1 * t301 * t620 * t564 - t287 * t288 * t275 * t302 * t87 * t90 * t719
  t814 = t143 ** 2
  t857 = -0.88888888888888888888888888888888888888888888888888e-2 * t561 * t227 + 0.66666666666666666666666666666666666666666666666666e-2 * t223 * t170 * t540 * t226 + 0.33333333333333333333333333333333333333333333333333e-2 * t223 * t170 * t545 * t226 + 0.20000000000000000000000000000000000000000000000000e-1 * t230 * t198 * t157 * t65 * t240 - 0.26666666666666666666666666666666666666666666666666e-1 * t206 * t20 * t231 * t212 * t240 + 0.33333333333333333333333333333333333333333333333334e-1 * t147 * t19 * t232 * t240 - 0.50000000000000000000000000000000000000000000000000e-1 * t233 * t234 / t167 / t106 * t238 * t410 + 0.20000000000000000000000000000000000000000000000000e-1 * t233 * t237 * t169 * t307 * t121 + 0.10000000000000000000000000000000000000000000000000e-1 * t233 * t237 * t238 * t456 - 0.25000000000000000000000000000000000000000000000000e-2 * t249 * t166 * t170 * (t683 + t805) + 0.66666666666666666666666666666666666666666666666666e-2 * t206 * t200 * t215 - 0.77777777777777777777777777777777777777777777777777e-2 * t145 * t814 * t16 * t208 / t10 / t204 / t80 * t161 * t165 * t190 - 0.27777777777777777777777777777777777777777777777778e-2 * t147 / t18 * t154 * t157 * t191 + 0.11111111111111111111111111111111111111111111111111e-1 * t206 * t158 * t215 - 0.83333333333333333333333333333333333333333333333334e-2 * t147 * t19 * t198 * t157 * t191 - 0.83333333333333333333333333333333333333333333333334e-2 * t159 * t309 - 0.25000000000000000000000000000000000000000000000000e-2 * t147 * t20 * (0.80e2 / 0.9e1 * t148 * t82 - 0.22e2 / 0.9e1 * t151 * t373) * t157 * t191 - 0.50000000000000000000000000000000000000000000000000e-2 * t201 * t309 + 0.66666666666666666666666666666666666666666666666666e-2 * t209 * t214 * t308
  t859 = f.my_piecewise3(t2, 0, t575 + t857)
  v2rho2_0_ = -0.80000000000000000000000000000000000000000000000000e0 * t56 * t60 - 0.80000000000000000000000000000000000000000000000000e0 * t63 * t131 * t60 - 0.80000000000000000000000000000000000000000000000000e0 * t63 * t55 * t139 + 0.4e1 * t313 + r0 * (-0.80000000000000000000000000000000000000000000000000e0 * t135 * t60 - 0.80000000000000000000000000000000000000000000000000e0 * t56 * t139 - 0.40000000000000000000000000000000000000000000000000e0 * t63 * t474 * t60 - 0.80000000000000000000000000000000000000000000000000e0 * t63 * t131 * t139 - 0.40000000000000000000000000000000000000000000000000e0 * t63 * t55 * (0.2e1 * t481 - 0.2e1 * t481 * t136 + 0.4e1 * t485 * t486 / t488) + 0.2e1 * t859)
  res = {'v2rho2': v2rho2_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t5 = t1 * t4
  t6 = t1 ** 2
  t7 = t3 * t2
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t11 = -0.2e1 * t5 + 0.2e1 * t9
  t12 = t11 * t2
  t13 = r0 <= f.p.dens_threshold
  t14 = 2 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t2
  t18 = 0.2e1 * r0 * t15 <= f.p.zeta_threshold
  t19 = f.p.zeta_threshold - 0.1e1
  t22 = 0.2e1 * r1 * t15 <= f.p.zeta_threshold
  t23 = -t19
  t24 = t1 * t15
  t25 = f.my_piecewise5(t18, t19, t22, t23, t24)
  t26 = 0.1e1 + t25
  t27 = t26 * t2
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = 0.1e1 / t28
  t30 = t14 * t29
  t31 = jnp.pi ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t31
  t33 = t30 * t32
  t34 = r0 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = 0.1e1 / t35 / r0
  t40 = params.gamma * tau0
  t43 = params.gamma * s0
  t44 = r0 ** 2
  t46 = 0.1e1 / t35 / t44
  t49 = l0 * t37 / 0.6e1 - 0.2e1 / 0.3e1 * t40 * t37 + t43 * t46 / 0.12e2
  t50 = abs(t49)
  t51 = t50 < 0.50e-12
  t52 = 0.0e0 < t49
  t53 = f.my_piecewise3(t52, 0.50e-12, -0.50e-12)
  t54 = f.my_piecewise3(t51, t53, t49)
  t55 = br89_x(t54)
  t57 = jnp.exp(t55 / 0.3e1)
  t58 = 0.1e1 / t57
  t59 = jnp.exp(-t55)
  t62 = t59 * (0.1e1 + t55 / 0.2e1)
  t63 = 0.1e1 - t62
  t64 = 0.1e1 / t63
  t65 = t58 * t64
  t66 = t65 * t55
  t69 = f.my_piecewise3(t13, 0, t33 * t66 / 0.2e1)
  t70 = r1 <= f.p.dens_threshold
  t71 = f.my_piecewise5(t22, t19, t18, t23, -t24)
  t72 = 0.1e1 + t71
  t73 = t72 * t2
  t74 = t73 ** (0.1e1 / 0.3e1)
  t75 = 0.1e1 / t74
  t76 = t14 * t75
  t77 = t76 * t32
  t78 = r1 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t81 = 0.1e1 / t79 / r1
  t84 = params.gamma * tau1
  t87 = params.gamma * s2
  t88 = r1 ** 2
  t90 = 0.1e1 / t79 / t88
  t93 = l1 * t81 / 0.6e1 - 0.2e1 / 0.3e1 * t84 * t81 + t87 * t90 / 0.12e2
  t94 = abs(t93)
  t95 = t94 < 0.50e-12
  t96 = 0.0e0 < t93
  t97 = f.my_piecewise3(t96, 0.50e-12, -0.50e-12)
  t98 = f.my_piecewise3(t95, t97, t93)
  t99 = br89_x(t98)
  t101 = jnp.exp(t99 / 0.3e1)
  t102 = 0.1e1 / t101
  t103 = jnp.exp(-t99)
  t106 = t103 * (0.1e1 + t99 / 0.2e1)
  t107 = 0.1e1 - t106
  t108 = 0.1e1 / t107
  t109 = t102 * t108
  t110 = t109 * t99
  t113 = f.my_piecewise3(t70, 0, t77 * t110 / 0.2e1)
  t114 = t69 + t113
  t115 = params.cab * t114
  t116 = 0.1e1 + t115
  t117 = jnp.log(t116)
  t118 = t115 - t117
  t119 = t115 * t118
  t120 = t12 * t119
  t123 = -t6 * t4 + 0.1e1
  t124 = t123 * params.cab
  t125 = t114 * t118
  t127 = 0.40000000000000000000000000000000000000000000000000e0 * t124 * t125
  t128 = t123 * t2
  t130 = 0.1e1 / t28 / t27
  t131 = t14 * t130
  t132 = t131 * t32
  t133 = t15 - t5
  t134 = f.my_piecewise5(t18, 0, t22, 0, t133)
  t136 = t134 * t2 + t25 + 0.1e1
  t137 = t55 * t136
  t138 = t65 * t137
  t141 = t31 * t58
  t142 = t141 * t64
  t143 = t30 * t142
  t144 = f.my_piecewise3(t52, 0, 0)
  t151 = 0.1e1 / t35 / t44 / r0
  t155 = f.my_piecewise3(t51, t144, -0.5e1 / 0.18e2 * l0 * t46 + 0.10e2 / 0.9e1 * t40 * t46 - 0.2e1 / 0.9e1 * t43 * t151)
  t157 = t54 ** 2
  t158 = 0.1e1 / t157
  t159 = t55 * t155 * t158
  t161 = jnp.exp(-0.2e1 / 0.3e1 * t55)
  t162 = 0.1e1 / t161
  t163 = t55 ** 2
  t165 = t163 - 0.2e1 * t55 + 0.3e1
  t166 = 0.1e1 / t165
  t167 = t162 * t166
  t168 = t55 - 0.2e1
  t169 = t168 ** 2
  t170 = t167 * t169
  t171 = t159 * t170
  t174 = t63 ** 2
  t175 = 0.1e1 / t174
  t176 = t58 * t175
  t177 = t31 ** 2
  t178 = t177 * t155
  t179 = t158 * t162
  t180 = t178 * t179
  t181 = t166 * t169
  t182 = t181 * t62
  t184 = t178 * t158
  t186 = t167 * t169 * t59
  t189 = t180 * t182 - t184 * t186 / 0.2e1
  t191 = t176 * t55 * t189
  t194 = t155 * t158
  t195 = t194 * t170
  t199 = f.my_piecewise3(t13, 0, -t132 * t138 / 0.6e1 - t143 * t171 / 0.6e1 - t33 * t191 / 0.2e1 + t143 * t195 / 0.2e1)
  t201 = 0.1e1 / t74 / t73
  t202 = t14 * t201
  t203 = t202 * t32
  t204 = -t133
  t205 = f.my_piecewise5(t22, 0, t18, 0, t204)
  t207 = t205 * t2 + t71 + 0.1e1
  t212 = f.my_piecewise3(t70, 0, -t203 * t109 * t99 * t207 / 0.6e1)
  t213 = t199 + t212
  t214 = params.cab * t213
  t215 = t214 * t118
  t216 = t128 * t215
  t218 = 0.1e1 / t116
  t220 = -t214 * t218 + t214
  t221 = t115 * t220
  t222 = t128 * t221
  t225 = 0.1e1 + t24 <= f.p.zeta_threshold
  t227 = 0.1e1 - t24 <= f.p.zeta_threshold
  t228 = f.my_piecewise5(t225, t19, t227, t23, t24)
  t229 = 0.1e1 + t228
  t230 = t229 ** (0.1e1 / 0.3e1)
  t231 = t230 ** 2
  t233 = t14 ** 2
  t234 = t231 * t229 * t233
  t235 = t2 ** (0.1e1 / 0.3e1)
  t236 = t235 ** 2
  t237 = t236 * t2
  t238 = t234 * t237
  t243 = 0.2e1 * tau0 * t37 - s0 * t46 / 0.4e1
  t244 = params.css ** 2
  t245 = t244 ** 2
  t246 = t243 * t245
  t247 = t246 * t130
  t248 = t238 * t247
  t249 = t31 * jnp.pi
  t250 = 0.1e1 / t249
  t251 = t57 ** 2
  t252 = t251 ** 2
  t253 = 0.1e1 / t252
  t254 = t250 * t253
  t255 = t174 ** 2
  t256 = 0.1e1 / t255
  t257 = t254 * t256
  t258 = t163 ** 2
  t259 = params.css * t14
  t260 = t259 * t29
  t261 = t32 * t58
  t262 = t64 * t55
  t266 = 0.1e1 + t260 * t261 * t262 / 0.2e1
  t267 = jnp.log(t266)
  t268 = 0.1e1 / params.css
  t269 = t267 * t268
  t270 = t233 * t28
  t271 = t269 * t270
  t272 = t31 * t57
  t273 = 0.1e1 / t55
  t274 = t63 * t273
  t277 = -t271 * t272 * t274 + 0.1e1
  t278 = t258 * t277
  t279 = f.my_piecewise5(t225, 0, t227, 0, t133)
  t281 = t257 * t278 * t279
  t284 = t229 ** 2
  t286 = t231 * t284 * t233
  t287 = t236 * t243
  t289 = t286 * t287 * t245
  t291 = t130 * t250 * t253
  t292 = t256 * t258
  t294 = t291 * t292 * t277
  t296 = 0.41666666666666666666666666666666666666666666666667e-2 * t289 * t294
  t301 = -0.10e2 / 0.3e1 * tau0 * t46 + 0.2e1 / 0.3e1 * s0 * t151
  t302 = t237 * t301
  t304 = t286 * t302 * t245
  t307 = t286 * t237
  t308 = t26 ** 2
  t311 = 0.1e1 / t28 / t308 / t3
  t312 = t246 * t311
  t313 = t307 * t312
  t315 = t257 * t278 * t136
  t318 = t237 * t243
  t319 = t286 * t318
  t321 = 0.1e1 / t177
  t322 = t321 * t253
  t323 = t245 * t130 * t322
  t324 = t319 * t323
  t325 = t277 * t155
  t326 = t292 * t325
  t327 = t179 * t181
  t328 = t326 * t327
  t331 = t307 * t247
  t333 = 0.1e1 / t255 / t63
  t334 = t254 * t333
  t336 = t334 * t278 * t189
  t339 = t163 * t55
  t340 = t256 * t339
  t341 = t340 * t325
  t342 = t341 * t327
  t346 = t286 * t318 * t245
  t348 = t259 * t130 * t32
  t351 = t260 * t142
  t355 = t259 * t29 * t32
  t360 = t259 * t29 * t31 * t58
  t366 = -t348 * t138 / 0.6e1 - t351 * t171 / 0.6e1 - t355 * t191 / 0.2e1 + t360 * t64 * t155 * t158 * t170 / 0.2e1
  t367 = 0.1e1 / t266
  t368 = t366 * t367
  t369 = t268 * t233
  t370 = t368 * t369
  t371 = t28 * t31
  t372 = t57 * t63
  t374 = t371 * t372 * t273
  t376 = t28 ** 2
  t377 = 0.1e1 / t376
  t379 = t269 * t233 * t377
  t381 = t272 * t274 * t136
  t384 = t269 * t233
  t385 = t28 * jnp.pi
  t387 = t384 * t385 * t155
  t388 = t179 * t166
  t389 = t169 * t57
  t390 = t389 * t274
  t391 = t388 * t390
  t394 = t189 * t273
  t398 = t384 * t385 * t57
  t399 = 0.1e1 / t163
  t400 = t63 * t399
  t402 = t400 * t155 * t327
  t404 = -t370 * t374 - t379 * t381 / 0.3e1 - t387 * t391 / 0.3e1 - t271 * t272 * t394 + t398 * t402
  t406 = t291 * t292 * t404
  t410 = f.my_piecewise3(t13, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t248 * t281 - t296 - 0.25000000000000000000000000000000000000000000000000e-2 * t304 * t294 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t315 + 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t328 + 0.10000000000000000000000000000000000000000000000000e-1 * t331 * t336 - 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t342 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t406)
  t412 = f.my_piecewise5(t227, t19, t225, t23, -t24)
  t413 = 0.1e1 + t412
  t414 = t413 ** (0.1e1 / 0.3e1)
  t415 = t414 ** 2
  t417 = t415 * t413 * t233
  t418 = t417 * t237
  t423 = 0.2e1 * tau1 * t81 - s2 * t90 / 0.4e1
  t424 = t423 * t245
  t425 = t424 * t201
  t426 = t418 * t425
  t427 = t101 ** 2
  t428 = t427 ** 2
  t429 = 0.1e1 / t428
  t430 = t250 * t429
  t431 = t107 ** 2
  t432 = t431 ** 2
  t433 = 0.1e1 / t432
  t434 = t430 * t433
  t435 = t99 ** 2
  t436 = t435 ** 2
  t437 = t259 * t75
  t438 = t32 * t102
  t439 = t108 * t99
  t443 = 0.1e1 + t437 * t438 * t439 / 0.2e1
  t444 = jnp.log(t443)
  t445 = t444 * t268
  t446 = t233 * t74
  t447 = t445 * t446
  t448 = t31 * t101
  t449 = 0.1e1 / t99
  t450 = t107 * t449
  t453 = -t447 * t448 * t450 + 0.1e1
  t454 = t436 * t453
  t455 = f.my_piecewise5(t227, 0, t225, 0, t204)
  t457 = t434 * t454 * t455
  t460 = t413 ** 2
  t462 = t415 * t460 * t233
  t463 = t236 * t423
  t465 = t462 * t463 * t245
  t467 = t201 * t250 * t429
  t468 = t433 * t436
  t470 = t467 * t468 * t453
  t472 = 0.41666666666666666666666666666666666666666666666667e-2 * t465 * t470
  t473 = t462 * t237
  t474 = t72 ** 2
  t477 = 0.1e1 / t74 / t474 / t3
  t478 = t424 * t477
  t479 = t473 * t478
  t481 = t434 * t454 * t207
  t484 = t237 * t423
  t486 = t462 * t484 * t245
  t487 = 0.1e1 / t72
  t488 = t487 * t15
  t489 = 0.1e1 / t443
  t490 = t207 * t489
  t492 = t74 ** 2
  t493 = 0.1e1 / t492
  t495 = t445 * t233 * t493
  t497 = t448 * t450 * t207
  t500 = t488 * t490 / 0.3e1 - t495 * t497 / 0.3e1
  t502 = t467 * t468 * t500
  t506 = f.my_piecewise3(t70, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t426 * t457 - t472 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t481 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t502)
  t508 = 0.2e1 * t4
  t509 = t1 * t8
  t510 = 0.8e1 * t509
  t511 = t3 ** 2
  t514 = 0.6e1 * t6 / t511
  t520 = t11 * params.cab * t125
  t527 = t124 * t213 * t118
  t530 = t124 * t114 * t220
  t536 = t44 ** 2
  t538 = 0.1e1 / t35 / t536
  t542 = f.my_piecewise3(t51, t144, 0.20e2 / 0.27e2 * l0 * t151 - 0.80e2 / 0.27e2 * t40 * t151 + 0.22e2 / 0.27e2 * t43 * t538)
  t545 = t55 * t542 * t158 * t170
  t549 = jnp.pi * t58 * t64
  t550 = t30 * t549
  t551 = t155 ** 2
  t552 = t55 * t551
  t553 = t157 ** 2
  t554 = 0.1e1 / t553
  t555 = t552 * t554
  t556 = t161 ** 2
  t557 = 0.1e1 / t556
  t558 = t165 ** 2
  t559 = 0.1e1 / t558
  t560 = t557 * t559
  t561 = t169 ** 2
  t563 = t555 * t560 * t561
  t567 = 0.1e1 / t157 / t54
  t571 = t194 * t162
  t572 = t559 * t169
  t578 = 0.2e1 * t55 * t177 * t155 * t327 - 0.2e1 * t184 * t170
  t579 = t572 * t578
  t580 = t571 * t579
  t583 = t30 * t31
  t586 = t181 * t189
  t587 = t571 * t586
  t591 = t552 * t567 * t170
  t597 = t141 * t175
  t601 = t131 * t31 * t66
  t604 = t136 * t155 * t158 * t170
  t607 = t131 * t142
  t615 = t169 * t168
  t616 = t560 * t615
  t619 = t555 * t616
  t622 = t14 * t311
  t623 = t622 * t32
  t624 = t136 ** 2
  t626 = t65 * t55 * t624
  t630 = -0.2e1 * t4 + 0.2e1 * t509
  t631 = f.my_piecewise5(t18, 0, t22, 0, t630)
  t634 = t631 * t2 + 0.2e1 * t134
  t636 = t65 * t55 * t634
  t639 = t177 * t542
  t642 = t177 * t551
  t643 = t567 * t162
  t647 = t249 * t551
  t648 = t554 * t557
  t649 = t647 * t648
  t650 = t559 * t561
  t657 = t559 * t615
  t661 = t647 * t554
  t678 = t639 * t179 * t182 - 0.2e1 * t642 * t643 * t182 - t649 * t650 * t62 / 0.3e1 - t180 * t572 * t62 * t578 + 0.2e1 * t649 * t657 * t62 + 0.2e1 / 0.3e1 * t661 * t560 * t561 * t59 - t639 * t158 * t186 / 0.2e1 + t642 * t567 * t186 + t180 * t572 * t59 * t578 / 0.2e1 - t661 * t560 * t615 * t59
  t680 = t176 * t55 * t678
  t683 = t131 * t261
  t684 = t175 * t55
  t685 = t136 * t189
  t692 = t189 ** 2
  t694 = t58 / t174 / t63 * t55 * t692
  t696 = -t143 * t545 / 0.6e1 - t550 * t563 / 0.18e2 - t143 * t551 * t567 * t170 - t143 * t580 / 0.2e1 + t583 * t176 * t55 * t587 / 0.3e1 + t143 * t591 / 0.3e1 + t583 * t66 * t580 / 0.6e1 - t30 * t597 * t587 + t601 * t604 / 0.9e1 - t607 * t604 / 0.3e1 + t143 * t542 * t158 * t170 / 0.2e1 + t550 * t551 * t554 * t616 - t550 * t619 / 0.3e1 + 0.2e1 / 0.9e1 * t623 * t626 - t132 * t636 / 0.6e1 - t33 * t680 / 0.2e1 + t683 * t684 * t685 / 0.3e1 + t33 * t694
  t697 = f.my_piecewise3(t13, 0, t696)
  t698 = t14 * t477
  t699 = t698 * t32
  t700 = t207 ** 2
  t705 = -t630
  t706 = f.my_piecewise5(t22, 0, t18, 0, t705)
  t709 = t706 * t2 + 0.2e1 * t205
  t715 = f.my_piecewise3(t70, 0, 0.2e1 / 0.9e1 * t699 * t109 * t99 * t700 - t203 * t109 * t99 * t709 / 0.6e1)
  t717 = params.cab * (t697 + t715)
  t725 = params.cab ** 2
  t726 = t213 ** 2
  t728 = t116 ** 2
  t729 = 0.1e1 / t728
  t736 = t286 * t287 * t323
  t737 = t736 * t328
  t740 = t286 * t302 * t323
  t743 = t404 * t155
  t748 = t277 * t542
  t761 = t277 * t551
  t762 = t340 * t761
  t763 = t643 * t181
  t769 = t292 * t761
  t773 = t736 * t342
  t780 = 0.11111111111111111111111111111111111111111111111111e-1 * t737 + 0.66666666666666666666666666666666666666666666666666e-2 * t740 * t328 + 0.66666666666666666666666666666666666666666666666666e-2 * t324 * t292 * t743 * t327 + 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t292 * t748 * t327 - 0.20000000000000000000000000000000000000000000000000e-1 * t324 * t340 * t743 * t327 - 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t340 * t748 * t327 + 0.20000000000000000000000000000000000000000000000000e-1 * t324 * t762 * t763 - 0.20000000000000000000000000000000000000000000000000e-1 * t740 * t342 - 0.66666666666666666666666666666666666666666666666666e-2 * t324 * t769 * t763 - 0.33333333333333333333333333333333333333333333333334e-1 * t773 + 0.53333333333333333333333333333333333333333333333334e-1 * t248 * t334 * t278 * t279 * t189
  t785 = t238 * t312
  t791 = t258 * t404
  t800 = t301 * t245
  t802 = t307 * t800 * t311
  t805 = t800 * t130
  t817 = t238 * t805
  t824 = f.my_piecewise5(t225, 0, t227, 0, t630)
  t829 = t286 * t236
  t830 = t829 * t312
  t831 = t830 * t315
  t833 = -0.26666666666666666666666666666666666666666666666666e-1 * t313 * t334 * t278 * t685 + 0.17777777777777777777777777777777777777777777777778e-1 * t785 * t257 * t278 * t279 * t136 + 0.20000000000000000000000000000000000000000000000000e-1 * t331 * t334 * t791 * t189 + 0.10000000000000000000000000000000000000000000000000e-1 * t331 * t334 * t278 * t678 + 0.66666666666666666666666666666666666666666666666666e-2 * t802 * t315 + 0.20000000000000000000000000000000000000000000000000e-1 * t307 * t805 * t336 + 0.66666666666666666666666666666666666666666666666666e-2 * t313 * t257 * t791 * t136 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t278 * t634 - 0.13333333333333333333333333333333333333333333333333e-1 * t817 * t281 - 0.13333333333333333333333333333333333333333333333333e-1 * t248 * t257 * t791 * t279 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t278 * t824 + 0.11111111111111111111111111111111111111111111111111e-1 * t831
  t836 = t829 * t247 * t336
  t850 = t307 * t246 / t28 / t308 / t26 / t7
  t857 = t231 * t233 * t237 * t247
  t858 = t279 ** 2
  t864 = t234 * t236 * t247
  t865 = t864 * t281
  t867 = t289 * t406
  t885 = t368 * t369 * t377
  t899 = t400 * t551
  t903 = t177 * jnp.pi
  t904 = t28 * t903
  t906 = t384 * t904 * t57
  t907 = t648 * t657
  t920 = t384 * t904 * t551
  t921 = t648 * t559
  t922 = t561 * t57
  t933 = t648 * t650
  t942 = -t271 * t272 * t678 * t273 - 0.2e1 / 0.3e1 * t885 * t381 + 0.2e1 / 0.3e1 * t384 * t385 * t551 * t643 * t166 * t390 + 0.2e1 * t398 * t189 * t399 * t155 * t327 - 0.2e1 * t398 * t899 * t763 + 0.2e1 * t906 * t899 * t907 - t384 * t385 * t542 * t391 / 0.3e1 - 0.2e1 / 0.3e1 * t387 * t388 * t389 * t394 - t920 * t921 * t922 * t274 / 0.3e1 + t398 * t400 * t542 * t327 - 0.2e1 * t906 * t63 / t339 * t551 * t933 - 0.2e1 / 0.3e1 * t920 * t921 * t615 * t57 * t274
  t956 = t260 * t597
  t964 = t162 * t559
  t966 = t964 * t169 * t578
  t972 = t259 * t130 * t142
  t979 = t260 * t549
  t990 = t64 * t551
  t1012 = -t355 * t680 / 0.2e1 - t348 * t636 / 0.6e1 + t956 * t159 * t167 * t169 * t189 / 0.3e1 + t351 * t591 / 0.3e1 + t351 * t159 * t966 / 0.6e1 - t956 * t587 + t972 * t137 * t155 * t327 / 0.9e1 - t972 * t604 / 0.3e1 - t979 * t619 / 0.3e1 + t360 * t64 * t542 * t158 * t170 / 0.2e1 + t259 * t29 * jnp.pi * t58 * t990 * t554 * t616 + t355 * t694 + 0.2e1 / 0.9e1 * t259 * t311 * t32 * t626 + t348 * t176 * t137 * t189 / 0.3e1 - t979 * t563 / 0.18e2 - t360 * t990 * t567 * t170 - t351 * t580 / 0.2e1 - t351 * t545 / 0.6e1
  t1018 = t233 / t376 / t27
  t1019 = t269 * t1018
  t1024 = t366 ** 2
  t1025 = t266 ** 2
  t1026 = 0.1e1 / t1025
  t1038 = t368 * t268
  t1044 = t377 * jnp.pi
  t1046 = t384 * t1044 * t372
  t1058 = t384 * t1044 * t194
  t1078 = 0.4e1 / 0.3e1 * t920 * t921 * t922 * t400 - 0.2e1 * t370 * t371 * t57 * t189 * t273 - t1012 * t367 * t369 * t374 + 0.2e1 / 0.9e1 * t1019 * t272 * t274 * t624 + t1024 * t1026 * t369 * t374 - 0.2e1 / 0.3e1 * t379 * t272 * t394 * t136 - t379 * t272 * t274 * t634 / 0.3e1 + 0.2e1 * t1038 * t270 * jnp.pi * t57 * t402 + 0.2e1 / 0.3e1 * t1046 * t399 * t136 * t155 * t327 - 0.2e1 / 0.3e1 * t1038 * t270 * jnp.pi * t155 * t391 - 0.2e1 / 0.9e1 * t1058 * t170 * t372 * t273 * t136 + t384 * t385 * t194 * t964 * t169 * t372 * t273 * t578 / 0.3e1 - t384 * t385 * t372 * t399 * t155 * t158 * t966
  t1084 = 0.1e1 / t235
  t1089 = 0.27777777777777777777777777777777777777777777777778e-2 * t286 * t1084 * t243 * t245 * t294
  t1093 = t286 * t236 * t301 * t245 * t294
  t1096 = t234 * t318 * t323
  t1097 = t277 * t279
  t1102 = 0.33333333333333333333333333333333333333333333333334e-1 * t836 - 0.50000000000000000000000000000000000000000000000000e-1 * t331 * t254 / t255 / t174 * t278 * t692 - 0.77777777777777777777777777777777777777777777777777e-2 * t850 * t257 * t278 * t624 - 0.11111111111111111111111111111111111111111111111111e-1 * t857 * t257 * t278 * t858 - 0.22222222222222222222222222222222222222222222222222e-1 * t865 - 0.83333333333333333333333333333333333333333333333334e-2 * t867 - 0.25000000000000000000000000000000000000000000000000e-2 * t286 * t237 * (0.80e2 / 0.9e1 * tau0 * t151 - 0.22e2 / 0.9e1 * s0 * t538) * t245 * t294 - 0.50000000000000000000000000000000000000000000000000e-2 * t304 * t406 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t291 * t292 * (t942 + t1078) - t1089 - 0.83333333333333333333333333333333333333333333333334e-2 * t1093 + 0.17777777777777777777777777777777777777777777777778e-1 * t1096 * t292 * t1097 * t195
  t1109 = t319 * t245 * t311 * t322
  t1110 = t277 * t136
  t1121 = t179 * t579
  t1140 = t307 * t246 * t130 * t253
  t1158 = -0.53333333333333333333333333333333333333333333333334e-1 * t1096 * t340 * t1097 * t195 + 0.26666666666666666666666666666666666666666666666666e-1 * t1109 * t340 * t1110 * t195 + 0.80000000000000000000000000000000000000000000000000e-1 * t324 * t333 * t339 * t277 * t189 * t195 + 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t341 * t1121 - 0.88888888888888888888888888888888888888888888888888e-2 * t1109 * t292 * t1110 * t195 - 0.26666666666666666666666666666666666666666666666666e-1 * t324 * t333 * t258 * t325 * t179 * t586 - 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t326 * t1121 + 0.20000000000000000000000000000000000000000000000000e-1 * t1140 * t762 * t933 + 0.66666666666666666666666666666666666666666666666666e-2 * t1140 * t769 * t907 - 0.30000000000000000000000000000000000000000000000000e-1 * t1140 * t256 * t163 * t761 * t933 - 0.20000000000000000000000000000000000000000000000000e-1 * t1140 * t762 * t907 - 0.22222222222222222222222222222222222222222222222222e-2 * t1140 * t769 * t933
  t1161 = f.my_piecewise3(t13, 0, t780 + t833 + t1102 + t1158)
  t1164 = t415 * t233 * t237 * t425
  t1165 = t455 ** 2
  t1171 = t417 * t236 * t425
  t1172 = t1171 * t457
  t1174 = t418 * t478
  t1180 = t436 * t500
  t1185 = f.my_piecewise5(t227, 0, t225, 0, t705)
  t1194 = 0.27777777777777777777777777777777777777777777777778e-2 * t462 * t1084 * t423 * t245 * t470
  t1195 = t462 * t236
  t1196 = t1195 * t478
  t1197 = t1196 * t481
  t1199 = t465 * t502
  t1206 = t473 * t424 / t74 / t474 / t72 / t7
  t1219 = 0.1e1 / t474
  t1230 = t443 ** 2
  t1231 = 0.1e1 / t1230
  t1238 = t1219 * t4
  t1244 = t233 / t492 / t73
  t1245 = t445 * t1244
  t1259 = -0.11111111111111111111111111111111111111111111111111e-1 * t1164 * t434 * t454 * t1165 - 0.22222222222222222222222222222222222222222222222222e-1 * t1172 + 0.17777777777777777777777777777777777777777777777778e-1 * t1174 * t434 * t454 * t455 * t207 - 0.13333333333333333333333333333333333333333333333333e-1 * t426 * t434 * t1180 * t455 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t454 * t1185 - t1194 + 0.11111111111111111111111111111111111111111111111111e-1 * t1197 - 0.83333333333333333333333333333333333333333333333334e-2 * t1199 - 0.77777777777777777777777777777777777777777777777777e-2 * t1206 * t434 * t454 * t700 + 0.66666666666666666666666666666666666666666666666666e-2 * t479 * t434 * t1180 * t207 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t454 * t709 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t467 * t468 * (-t1219 * t15 * t490 * t205 / 0.3e1 - t487 * t4 * t490 / 0.3e1 + t488 * t709 * t489 / 0.3e1 + t488 * t700 * t1231 * params.css * t203 * t110 / 0.18e2 + t1238 * t700 * t489 / 0.9e1 + 0.2e1 / 0.9e1 * t1245 * t448 * t450 * t700 - t495 * t448 * t450 * t709 / 0.3e1)
  t1260 = f.my_piecewise3(t70, 0, t1259)
  t1261 = -0.20000000000000000000000000000000000000000000000000e0 * (-t508 + t510 - t514) * t2 * t119 - 0.40000000000000000000000000000000000000000000000000e0 * t520 - 0.40000000000000000000000000000000000000000000000000e0 * t12 * t215 - 0.40000000000000000000000000000000000000000000000000e0 * t12 * t221 - 0.40000000000000000000000000000000000000000000000000e0 * t527 - 0.40000000000000000000000000000000000000000000000000e0 * t530 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t717 * t118 - 0.40000000000000000000000000000000000000000000000000e0 * t128 * t214 * t220 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t115 * (t725 * t726 * t729 - t717 * t218 + t717) + t1161 + t1260
  d11 = -0.40000000000000000000000000000000000000000000000000e0 * t120 - t127 - 0.40000000000000000000000000000000000000000000000000e0 * t216 - 0.40000000000000000000000000000000000000000000000000e0 * t222 + 0.2e1 * t410 + 0.2e1 * t506 + t2 * t1261
  t1267 = 0.2e1 * t5 + 0.2e1 * t9
  t1268 = t1267 * t2
  t1269 = t1268 * t119
  t1271 = -t15 - t5
  t1272 = f.my_piecewise5(t18, 0, t22, 0, t1271)
  t1274 = t1272 * t2 + t25 + 0.1e1
  t1279 = f.my_piecewise3(t13, 0, -t132 * t65 * t55 * t1274 / 0.6e1)
  t1280 = -t1271
  t1281 = f.my_piecewise5(t22, 0, t18, 0, t1280)
  t1283 = t1281 * t2 + t71 + 0.1e1
  t1284 = t99 * t1283
  t1285 = t109 * t1284
  t1288 = t31 * t102
  t1289 = t1288 * t108
  t1290 = t76 * t1289
  t1291 = f.my_piecewise3(t96, 0, 0)
  t1298 = 0.1e1 / t79 / t88 / r1
  t1302 = f.my_piecewise3(t95, t1291, -0.5e1 / 0.18e2 * l1 * t90 + 0.10e2 / 0.9e1 * t84 * t90 - 0.2e1 / 0.9e1 * t87 * t1298)
  t1304 = t98 ** 2
  t1305 = 0.1e1 / t1304
  t1306 = t99 * t1302 * t1305
  t1308 = jnp.exp(-0.2e1 / 0.3e1 * t99)
  t1309 = 0.1e1 / t1308
  t1311 = t435 - 0.2e1 * t99 + 0.3e1
  t1312 = 0.1e1 / t1311
  t1313 = t1309 * t1312
  t1314 = t99 - 0.2e1
  t1315 = t1314 ** 2
  t1316 = t1313 * t1315
  t1317 = t1306 * t1316
  t1320 = 0.1e1 / t431
  t1321 = t102 * t1320
  t1322 = t177 * t1302
  t1323 = t1305 * t1309
  t1324 = t1322 * t1323
  t1325 = t1312 * t1315
  t1326 = t1325 * t106
  t1328 = t1322 * t1305
  t1330 = t1313 * t1315 * t103
  t1333 = t1324 * t1326 - t1328 * t1330 / 0.2e1
  t1334 = t99 * t1333
  t1335 = t1321 * t1334
  t1338 = t1302 * t1305
  t1339 = t1338 * t1316
  t1343 = f.my_piecewise3(t70, 0, -t203 * t1285 / 0.6e1 - t1290 * t1317 / 0.6e1 - t77 * t1335 / 0.2e1 + t1290 * t1339 / 0.2e1)
  t1344 = t1279 + t1343
  t1345 = params.cab * t1344
  t1346 = t1345 * t118
  t1347 = t128 * t1346
  t1350 = -t1345 * t218 + t1345
  t1351 = t115 * t1350
  t1352 = t128 * t1351
  t1354 = f.my_piecewise5(t225, 0, t227, 0, t1271)
  t1356 = t257 * t278 * t1354
  t1360 = t257 * t278 * t1274
  t1363 = 0.1e1 / t26
  t1364 = t1363 * t15
  t1365 = t1274 * t367
  t1368 = t272 * t274 * t1274
  t1371 = t1364 * t1365 / 0.3e1 - t379 * t1368 / 0.3e1
  t1373 = t291 * t292 * t1371
  t1377 = f.my_piecewise3(t13, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t248 * t1356 - t296 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t1360 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t1373)
  t1378 = f.my_piecewise5(t227, 0, t225, 0, t1280)
  t1380 = t434 * t454 * t1378
  t1387 = -0.10e2 / 0.3e1 * tau1 * t90 + 0.2e1 / 0.3e1 * s2 * t1298
  t1388 = t237 * t1387
  t1390 = t462 * t1388 * t245
  t1394 = t434 * t454 * t1283
  t1397 = t462 * t484
  t1399 = t321 * t429
  t1400 = t245 * t201 * t1399
  t1401 = t1397 * t1400
  t1402 = t453 * t1302
  t1403 = t468 * t1402
  t1404 = t1323 * t1325
  t1405 = t1403 * t1404
  t1408 = t473 * t425
  t1410 = 0.1e1 / t432 / t107
  t1411 = t430 * t1410
  t1413 = t1411 * t454 * t1333
  t1416 = t435 * t99
  t1417 = t433 * t1416
  t1418 = t1417 * t1402
  t1419 = t1418 * t1404
  t1423 = t259 * t201 * t32
  t1426 = t437 * t1289
  t1430 = t259 * t75 * t32
  t1435 = t259 * t75 * t31 * t102
  t1441 = -t1423 * t1285 / 0.6e1 - t1426 * t1317 / 0.6e1 - t1430 * t1335 / 0.2e1 + t1435 * t108 * t1302 * t1305 * t1316 / 0.2e1
  t1442 = t1441 * t489
  t1443 = t1442 * t369
  t1444 = t74 * t31
  t1445 = t101 * t107
  t1447 = t1444 * t1445 * t449
  t1450 = t448 * t450 * t1283
  t1453 = t445 * t233
  t1454 = t74 * jnp.pi
  t1456 = t1453 * t1454 * t1302
  t1457 = t1323 * t1312
  t1458 = t1315 * t101
  t1459 = t1458 * t450
  t1460 = t1457 * t1459
  t1463 = t1333 * t449
  t1467 = t1453 * t1454 * t101
  t1468 = 0.1e1 / t435
  t1469 = t107 * t1468
  t1471 = t1469 * t1302 * t1404
  t1473 = -t1443 * t1447 - t495 * t1450 / 0.3e1 - t1456 * t1460 / 0.3e1 - t447 * t448 * t1463 + t1467 * t1471
  t1475 = t467 * t468 * t1473
  t1479 = f.my_piecewise3(t70, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t426 * t1380 - t472 - 0.25000000000000000000000000000000000000000000000000e-2 * t1390 * t470 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t1394 + 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t1405 + 0.10000000000000000000000000000000000000000000000000e-1 * t1408 * t1413 - 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1419 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t1475)
  t1485 = t1267 * params.cab * t125
  t1497 = t124 * t1344 * t118
  t1500 = t1274 * t136
  t1506 = t1274 * t155 * t158 * t170
  t1509 = t1274 * t189
  t1515 = 0.2e1 * t509
  t1516 = f.my_piecewise5(t18, 0, t22, 0, t1515)
  t1518 = t1516 * t2 + t1272 + t134
  t1524 = f.my_piecewise3(t13, 0, 0.2e1 / 0.9e1 * t622 * t261 * t262 * t1500 + t601 * t1506 / 0.18e2 + t683 * t684 * t1509 / 0.6e1 - t607 * t1506 / 0.6e1 - t132 * t65 * t55 * t1518 / 0.6e1)
  t1526 = t1283 * t207
  t1530 = f.my_piecewise5(t22, 0, t18, 0, -t1515)
  t1532 = t1530 * t2 + t1281 + t205
  t1534 = t109 * t99 * t1532
  t1538 = t202 * t31 * t110
  t1539 = t1338 * t1309
  t1540 = t1325 * t207
  t1541 = t1539 * t1540
  t1544 = t202 * t438
  t1545 = t1320 * t99
  t1546 = t1333 * t207
  t1550 = t202 * t1289
  t1554 = f.my_piecewise3(t70, 0, 0.2e1 / 0.9e1 * t698 * t438 * t439 * t1526 - t203 * t1534 / 0.6e1 + t1538 * t1541 / 0.18e2 + t1544 * t1545 * t1546 / 0.6e1 - t1550 * t1541 / 0.6e1)
  t1556 = params.cab * (t1524 + t1554)
  t1566 = t124 * t114 * t1350
  t1579 = t1371 * t155
  t1623 = 0.1e1 / t308
  t1624 = t1623 * t15
  t1630 = t1363 * t4 * t1365 / 0.3e1
  t1642 = t273 * t1274
  t1669 = t289 * t1373
  t1672 = 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t292 * t1579 * t327 - 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t340 * t1579 * t327 + 0.55555555555555555555555555555555555555555555555556e-2 * t737 - 0.16666666666666666666666666666666666666666666666667e-1 * t773 + 0.26666666666666666666666666666666666666666666666667e-1 * t248 * t334 * t278 * t1354 * t189 + 0.88888888888888888888888888888888888888888888888888e-2 * t785 * t257 * t278 * t1274 * t279 - 0.77777777777777777777777777777777777777777777777777e-2 * t850 * t257 * t278 * t1500 - 0.13333333333333333333333333333333333333333333333333e-1 * t313 * t334 * t278 * t1509 - 0.11111111111111111111111111111111111111111111111111e-1 * t857 * t257 * t278 * t1354 * t279 + 0.88888888888888888888888888888888888888888888888889e-2 * t785 * t257 * t278 * t1354 * t136 + 0.55555555555555555555555555555555555555555555555556e-2 * t831 + 0.16666666666666666666666666666666666666666666666667e-1 * t836 - 0.11111111111111111111111111111111111111111111111111e-1 * t865 - 0.25000000000000000000000000000000000000000000000000e-2 * t304 * t1373 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t291 * t292 * (-t1624 * t1365 * t134 / 0.3e1 - t1630 + t1364 * t1518 * t367 / 0.3e1 - t1364 * t1274 * t1026 * t366 / 0.3e1 - t885 * t1368 / 0.3e1 + 0.2e1 / 0.9e1 * t269 * t1018 * t31 * t372 * t1642 * t136 - t1058 * t170 * t372 * t1642 / 0.9e1 - t379 * t272 * t394 * t1274 / 0.3e1 + t1046 * t399 * t1274 * t155 * t327 / 0.3e1 - t379 * t272 * t274 * t1518 / 0.3e1) - 0.41666666666666666666666666666666666666666666666667e-2 * t1669 - 0.41666666666666666666666666666666666666666666666667e-2 * t867
  t1674 = t277 * t1274
  t1679 = t277 * t1354
  t1698 = t830 * t1360
  t1700 = t864 * t1356
  t1706 = t258 * t1371
  t1723 = f.my_piecewise5(t225, 0, t227, 0, t1515)
  t1730 = -t1089 - 0.41666666666666666666666666666666666666666666666667e-2 * t1093 + 0.13333333333333333333333333333333333333333333333333e-1 * t1109 * t340 * t1674 * t195 - 0.26666666666666666666666666666666666666666666666667e-1 * t1096 * t340 * t1679 * t195 + 0.88888888888888888888888888888888888888888888888889e-2 * t1096 * t292 * t1679 * t195 - 0.44444444444444444444444444444444444444444444444444e-2 * t1109 * t292 * t1674 * t195 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t791 * t1274 - 0.66666666666666666666666666666666666666666666666667e-2 * t817 * t1356 + 0.55555555555555555555555555555555555555555555555555e-2 * t1698 - 0.11111111111111111111111111111111111111111111111111e-1 * t1700 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t278 * t1518 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t1706 * t279 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t1706 * t136 + 0.10000000000000000000000000000000000000000000000000e-1 * t331 * t334 * t1706 * t189 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t791 * t1354 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t278 * t1723 + 0.33333333333333333333333333333333333333333333333333e-2 * t802 * t1360
  t1732 = f.my_piecewise3(t13, 0, t1672 + t1730)
  t1733 = t500 * t1302
  t1743 = t462 * t463 * t1400
  t1744 = t1743 * t1419
  t1746 = t1743 * t1405
  t1781 = t462 * t236 * t1387 * t245 * t470
  t1783 = t465 * t1475
  t1788 = t259 * t477 * t32
  t1796 = t259 * t201 * t1289
  t1798 = t1313 * t1315 * t207
  t1817 = t1442 * t369 * t493
  t1825 = t449 * t1283
  t1839 = t493 * jnp.pi
  t1841 = t1453 * t1839 * t1338
  t1864 = t1453 * t1839 * t1445
  t1866 = t1468 * t1302 * t1305
  t1870 = -(0.2e1 / 0.9e1 * t1788 * t109 * t1284 * t207 - t1423 * t1534 / 0.6e1 + t1796 * t1306 * t1798 / 0.18e2 + t1423 * t1321 * t1334 * t207 / 0.6e1 - t1796 * t1541 / 0.6e1) * t489 * t369 * t1447 - t1441 * t1231 * t488 * t207 / 0.3e1 - t1817 * t497 / 0.3e1 + t1238 * t490 * t1283 / 0.9e1 + 0.2e1 / 0.9e1 * t445 * t1244 * t31 * t1445 * t1825 * t207 - t495 * t448 * t450 * t1532 / 0.3e1 + t488 * t177 * t207 * t489 * t1339 / 0.9e1 - t1841 * t1316 * t1445 * t449 * t207 / 0.9e1 + t488 * t108 * t490 * t1333 / 0.3e1 - t495 * t448 * t1463 * t207 / 0.3e1 - t488 * t177 * t449 * t207 * t489 * t1302 * t1305 * t1316 / 0.3e1 + t1864 * t1866 * t1798 / 0.3e1
  t1875 = 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t468 * t1733 * t1404 - 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1417 * t1733 * t1404 - 0.16666666666666666666666666666666666666666666666667e-1 * t1744 + 0.55555555555555555555555555555555555555555555555555e-2 * t1746 - 0.11111111111111111111111111111111111111111111111111e-1 * t1172 + 0.55555555555555555555555555555555555555555555555556e-2 * t1197 - 0.13333333333333333333333333333333333333333333333333e-1 * t479 * t1411 * t454 * t1546 - 0.11111111111111111111111111111111111111111111111111e-1 * t1164 * t434 * t454 * t1378 * t455 + 0.88888888888888888888888888888888888888888888888889e-2 * t1174 * t434 * t454 * t1378 * t207 + 0.88888888888888888888888888888888888888888888888888e-2 * t1174 * t434 * t454 * t1283 * t455 - 0.77777777777777777777777777777777777777777777777777e-2 * t1206 * t434 * t454 * t1526 + 0.26666666666666666666666666666666666666666666666667e-1 * t426 * t1411 * t454 * t1333 * t455 - 0.41666666666666666666666666666666666666666666666667e-2 * t1781 - 0.41666666666666666666666666666666666666666666666667e-2 * t1783 - 0.25000000000000000000000000000000000000000000000000e-2 * t1390 * t502 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t467 * t468 * t1870 - t1194
  t1879 = t1397 * t245 * t477 * t1399
  t1880 = t1323 * t1540
  t1885 = t417 * t484 * t1400
  t1887 = t1323 * t1325 * t455
  t1901 = f.my_piecewise5(t227, 0, t225, 0, -t1515)
  t1910 = t436 * t1473
  t1919 = t1196 * t1394
  t1922 = t1195 * t425 * t1413
  t1924 = t1171 * t1380
  t1926 = t1387 * t245
  t1927 = t1926 * t201
  t1928 = t418 * t1927
  t1932 = t473 * t1926 * t477
  t1943 = -0.41666666666666666666666666666666666666666666666667e-2 * t1199 - 0.44444444444444444444444444444444444444444444444444e-2 * t1879 * t1403 * t1880 - 0.26666666666666666666666666666666666666666666666667e-1 * t1885 * t1418 * t1887 + 0.13333333333333333333333333333333333333333333333333e-1 * t1879 * t1418 * t1880 + 0.88888888888888888888888888888888888888888888888888e-2 * t1885 * t1403 * t1887 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t1180 * t1378 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t454 * t1901 + 0.10000000000000000000000000000000000000000000000000e-1 * t1408 * t1411 * t1180 * t1333 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t1910 * t455 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t1910 * t207 + 0.55555555555555555555555555555555555555555555555555e-2 * t1919 + 0.16666666666666666666666666666666666666666666666667e-1 * t1922 - 0.11111111111111111111111111111111111111111111111111e-1 * t1924 - 0.66666666666666666666666666666666666666666666666667e-2 * t1928 * t457 + 0.33333333333333333333333333333333333333333333333333e-2 * t1932 * t481 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t1180 * t1283 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t454 * t1532
  t1945 = f.my_piecewise3(t70, 0, t1875 + t1943)
  t1946 = -0.20000000000000000000000000000000000000000000000000e0 * (t508 - t514) * t2 * t119 - 0.20000000000000000000000000000000000000000000000000e0 * t1485 - 0.20000000000000000000000000000000000000000000000000e0 * t1268 * t215 - 0.20000000000000000000000000000000000000000000000000e0 * t1268 * t221 - 0.20000000000000000000000000000000000000000000000000e0 * t520 - 0.20000000000000000000000000000000000000000000000000e0 * t527 - 0.20000000000000000000000000000000000000000000000000e0 * t530 - 0.20000000000000000000000000000000000000000000000000e0 * t12 * t1346 - 0.20000000000000000000000000000000000000000000000000e0 * t1497 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t1556 * t118 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t1345 * t220 - 0.20000000000000000000000000000000000000000000000000e0 * t12 * t1351 - 0.20000000000000000000000000000000000000000000000000e0 * t1566 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t214 * t1350 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t115 * (t725 * t1344 * t729 * t213 - t1556 * t218 + t1556) + t1732 + t1945
  d12 = -0.20000000000000000000000000000000000000000000000000e0 * t120 - t127 - 0.20000000000000000000000000000000000000000000000000e0 * t216 - 0.20000000000000000000000000000000000000000000000000e0 * t222 + t410 + t506 - 0.20000000000000000000000000000000000000000000000000e0 * t1269 - 0.20000000000000000000000000000000000000000000000000e0 * t1347 - 0.20000000000000000000000000000000000000000000000000e0 * t1352 + t1377 + t1479 + t2 * t1946
  t1964 = t1274 ** 2
  t1970 = 0.2e1 * t4 + 0.2e1 * t509
  t1971 = f.my_piecewise5(t18, 0, t22, 0, t1970)
  t1974 = t1971 * t2 + 0.2e1 * t1272
  t1980 = f.my_piecewise3(t13, 0, 0.2e1 / 0.9e1 * t623 * t65 * t55 * t1964 - t132 * t65 * t55 * t1974 / 0.6e1)
  t1983 = t1283 * t1302 * t1305 * t1316
  t1988 = t76 * t31
  t1991 = t1325 * t1333
  t1992 = t1539 * t1991
  t1995 = t1302 ** 2
  t1996 = t99 * t1995
  t1998 = 0.1e1 / t1304 / t98
  t2000 = t1996 * t1998 * t1316
  t2004 = t1311 ** 2
  t2005 = 0.1e1 / t2004
  t2006 = t2005 * t1315
  t2012 = 0.2e1 * t99 * t177 * t1302 * t1404 - 0.2e1 * t1328 * t1316
  t2013 = t2006 * t2012
  t2014 = t1539 * t2013
  t2017 = t1288 * t1320
  t2021 = jnp.pi * t102 * t108
  t2022 = t76 * t2021
  t2023 = t1304 ** 2
  t2024 = 0.1e1 / t2023
  t2026 = t1308 ** 2
  t2027 = 0.1e1 / t2026
  t2028 = t2027 * t2005
  t2029 = t1315 * t1314
  t2030 = t2028 * t2029
  t2037 = t88 ** 2
  t2039 = 0.1e1 / t79 / t2037
  t2043 = f.my_piecewise3(t95, t1291, 0.20e2 / 0.27e2 * l1 * t1298 - 0.80e2 / 0.27e2 * t84 * t1298 + 0.22e2 / 0.27e2 * t87 * t2039)
  t2048 = t177 * t2043
  t2051 = t177 * t1995
  t2052 = t1998 * t1309
  t2056 = t249 * t1995
  t2057 = t2024 * t2027
  t2058 = t2056 * t2057
  t2059 = t1315 ** 2
  t2060 = t2005 * t2059
  t2067 = t2005 * t2029
  t2071 = t2056 * t2024
  t2088 = t2048 * t1323 * t1326 - 0.2e1 * t2051 * t2052 * t1326 - t2058 * t2060 * t106 / 0.3e1 - t1324 * t2006 * t106 * t2012 + 0.2e1 * t2058 * t2067 * t106 + 0.2e1 / 0.3e1 * t2071 * t2028 * t2059 * t103 - t2048 * t1305 * t1330 / 0.2e1 + t2051 * t1998 * t1330 + t1324 * t2006 * t103 * t2012 / 0.2e1 - t2071 * t2028 * t2029 * t103
  t2090 = t1321 * t99 * t2088
  t2093 = -t1970
  t2094 = f.my_piecewise5(t22, 0, t18, 0, t2093)
  t2097 = t2094 * t2 + 0.2e1 * t1281
  t2099 = t109 * t99 * t2097
  t2104 = t99 * t2043 * t1305 * t1316
  t2107 = t1996 * t2024
  t2109 = t2107 * t2028 * t2059
  t2117 = t2107 * t2030
  t2120 = t1283 ** 2
  t2122 = t109 * t99 * t2120
  t2125 = t1283 * t1333
  t2132 = t1333 ** 2
  t2134 = t102 / t431 / t107 * t99 * t2132
  t2136 = t1538 * t1983 / 0.9e1 - t1550 * t1983 / 0.3e1 + t1988 * t1321 * t99 * t1992 / 0.3e1 + t1290 * t2000 / 0.3e1 + t1988 * t110 * t2014 / 0.6e1 - t76 * t2017 * t1992 + t2022 * t1995 * t2024 * t2030 + t1290 * t2043 * t1305 * t1316 / 0.2e1 - t77 * t2090 / 0.2e1 - t203 * t2099 / 0.6e1 - t1290 * t2104 / 0.6e1 - t2022 * t2109 / 0.18e2 - t1290 * t1995 * t1998 * t1316 - t1290 * t2014 / 0.2e1 - t2022 * t2117 / 0.3e1 + 0.2e1 / 0.9e1 * t699 * t2122 + t1544 * t1545 * t2125 / 0.3e1 + t77 * t2134
  t2137 = f.my_piecewise3(t70, 0, t2136)
  t2139 = params.cab * (t1980 + t2137)
  t2147 = t1344 ** 2
  t2154 = t1354 ** 2
  t2169 = f.my_piecewise5(t225, 0, t227, 0, t1970)
  t2217 = -0.11111111111111111111111111111111111111111111111111e-1 * t857 * t257 * t278 * t2154 - 0.22222222222222222222222222222222222222222222222222e-1 * t1700 + 0.17777777777777777777777777777777777777777777777778e-1 * t785 * t257 * t278 * t1354 * t1274 - 0.13333333333333333333333333333333333333333333333333e-1 * t248 * t257 * t1706 * t1354 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t278 * t2169 - t1089 + 0.11111111111111111111111111111111111111111111111111e-1 * t1698 - 0.83333333333333333333333333333333333333333333333334e-2 * t1669 - 0.77777777777777777777777777777777777777777777777777e-2 * t850 * t257 * t278 * t1964 + 0.66666666666666666666666666666666666666666666666666e-2 * t313 * t257 * t1706 * t1274 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t278 * t1974 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t291 * t292 * (-t1624 * t1365 * t1272 / 0.3e1 - t1630 + t1364 * t1974 * t367 / 0.3e1 + t1364 * t1964 * t1026 * params.css * t132 * t66 / 0.18e2 + t1623 * t4 * t1964 * t367 / 0.9e1 + 0.2e1 / 0.9e1 * t1019 * t272 * t274 * t1964 - t379 * t272 * t274 * t1974 / 0.3e1)
  t2218 = f.my_piecewise3(t13, 0, t2217)
  t2219 = f.my_piecewise5(t227, 0, t225, 0, t2093)
  t2254 = t1378 ** 2
  t2260 = t462 * t1388 * t1400
  t2263 = t1473 * t1302
  t2268 = -0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t454 * t2219 + 0.20000000000000000000000000000000000000000000000000e-1 * t473 * t1927 * t1413 + 0.66666666666666666666666666666666666666666666666666e-2 * t479 * t434 * t1910 * t1283 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t454 * t2097 + 0.20000000000000000000000000000000000000000000000000e-1 * t1408 * t1411 * t1910 * t1333 + 0.10000000000000000000000000000000000000000000000000e-1 * t1408 * t1411 * t454 * t2088 - 0.50000000000000000000000000000000000000000000000000e-1 * t1408 * t430 / t432 / t431 * t454 * t2132 - 0.77777777777777777777777777777777777777777777777777e-2 * t1206 * t434 * t454 * t2120 - 0.11111111111111111111111111111111111111111111111111e-1 * t1164 * t434 * t454 * t2254 + 0.66666666666666666666666666666666666666666666666666e-2 * t2260 * t1405 + 0.66666666666666666666666666666666666666666666666666e-2 * t1401 * t468 * t2263 * t1404
  t2269 = t453 * t2043
  t2278 = t453 * t1995
  t2279 = t1417 * t2278
  t2280 = t2052 * t1325
  t2286 = t468 * t2278
  t2317 = 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t468 * t2269 * t1404 - 0.20000000000000000000000000000000000000000000000000e-1 * t1401 * t1417 * t2263 * t1404 + 0.20000000000000000000000000000000000000000000000000e-1 * t1401 * t2279 * t2280 - 0.33333333333333333333333333333333333333333333333334e-1 * t1744 + 0.11111111111111111111111111111111111111111111111111e-1 * t1746 - 0.66666666666666666666666666666666666666666666666666e-2 * t1401 * t2286 * t2280 - 0.20000000000000000000000000000000000000000000000000e-1 * t2260 * t1419 - 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1417 * t2269 * t1404 - 0.25000000000000000000000000000000000000000000000000e-2 * t462 * t237 * (0.80e2 / 0.9e1 * tau1 * t1298 - 0.22e2 / 0.9e1 * s2 * t2039) * t245 * t470 - 0.50000000000000000000000000000000000000000000000000e-2 * t1390 * t1475 - 0.26666666666666666666666666666666666666666666666666e-1 * t479 * t1411 * t454 * t2125 + 0.17777777777777777777777777777777777777777777777778e-1 * t1174 * t434 * t454 * t1378 * t1283
  t2343 = t74 * t903
  t2345 = t1453 * t2343 * t1995
  t2346 = t2057 * t2005
  t2347 = t2059 * t101
  t2360 = t1469 * t1995
  t2380 = t1453 * t2343 * t101
  t2384 = t2057 * t2060
  t2388 = t2057 * t2067
  t2392 = -t447 * t448 * t2088 * t449 - t1453 * t1454 * t2043 * t1460 / 0.3e1 - 0.2e1 / 0.3e1 * t1456 * t1457 * t1458 * t1463 - t2345 * t2346 * t2347 * t450 / 0.3e1 + t1467 * t1469 * t2043 * t1404 + 0.2e1 * t1467 * t1333 * t1468 * t1302 * t1404 - 0.2e1 * t1467 * t2360 * t2280 + 0.2e1 / 0.3e1 * t1453 * t1454 * t1995 * t2052 * t1312 * t1459 - 0.2e1 / 0.3e1 * t2345 * t2346 * t2029 * t101 * t450 + 0.4e1 / 0.3e1 * t2345 * t2346 * t2347 * t1469 - 0.2e1 * t2380 * t107 / t1416 * t1995 * t2384 + 0.2e1 * t2380 * t2360 * t2388
  t2395 = t1442 * t268
  t2408 = t1309 * t2005
  t2410 = t2408 * t1315 * t2012
  t2432 = t437 * t2021
  t2445 = t437 * t2017
  t2457 = t108 * t1995
  t2483 = -t1426 * t2104 / 0.6e1 - t2432 * t2109 / 0.18e2 - t1430 * t2090 / 0.2e1 - t1423 * t2099 / 0.6e1 + t1796 * t1284 * t1302 * t1404 / 0.9e1 - t1796 * t1983 / 0.3e1 + t2445 * t1306 * t1313 * t1315 * t1333 / 0.3e1 + t1426 * t2000 / 0.3e1 + t1426 * t1306 * t2410 / 0.6e1 - t2445 * t1992 - t1435 * t2457 * t1998 * t1316 - t1426 * t2014 / 0.2e1 - t2432 * t2117 / 0.3e1 + t1435 * t108 * t2043 * t1305 * t1316 / 0.2e1 + t259 * t75 * jnp.pi * t102 * t2457 * t2024 * t2030 + 0.2e1 / 0.9e1 * t1788 * t2122 + t1423 * t1321 * t1284 * t1333 / 0.3e1 + t1430 * t2134
  t2487 = t1441 ** 2
  t2508 = -0.2e1 / 0.3e1 * t1817 * t1450 + 0.2e1 * t2395 * t446 * jnp.pi * t101 * t1471 + 0.2e1 / 0.3e1 * t1864 * t1468 * t1283 * t1302 * t1404 - t1453 * t1454 * t1445 * t1866 * t2410 - 0.2e1 / 0.3e1 * t2395 * t446 * jnp.pi * t1302 * t1460 - 0.2e1 / 0.9e1 * t1841 * t1316 * t1445 * t1825 + t1453 * t1454 * t1338 * t2408 * t1315 * t1445 * t449 * t2012 / 0.3e1 - t2483 * t489 * t369 * t1447 + t2487 * t1231 * t369 * t1447 + 0.2e1 / 0.9e1 * t1245 * t448 * t450 * t2120 - 0.2e1 * t1443 * t1444 * t101 * t1333 * t449 - 0.2e1 / 0.3e1 * t495 * t448 * t1463 * t1283 - t495 * t448 * t450 * t2097 / 0.3e1
  t2516 = t453 * t1283
  t2527 = t453 * t1378
  t2536 = 0.53333333333333333333333333333333333333333333333334e-1 * t426 * t1411 * t454 * t1378 * t1333 + 0.66666666666666666666666666666666666666666666666666e-2 * t1932 * t1394 - 0.13333333333333333333333333333333333333333333333333e-1 * t1928 * t1380 - 0.13333333333333333333333333333333333333333333333333e-1 * t426 * t434 * t1910 * t1378 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t467 * t468 * (t2392 + t2508) - 0.83333333333333333333333333333333333333333333333334e-2 * t1781 - 0.83333333333333333333333333333333333333333333333334e-2 * t1783 - t1194 - 0.88888888888888888888888888888888888888888888888888e-2 * t1879 * t468 * t2516 * t1339 + 0.80000000000000000000000000000000000000000000000000e-1 * t1401 * t1410 * t1416 * t453 * t1333 * t1339 - 0.53333333333333333333333333333333333333333333333334e-1 * t1885 * t1417 * t2527 * t1339 + 0.26666666666666666666666666666666666666666666666666e-1 * t1879 * t1417 * t2516 * t1339
  t2537 = t1323 * t2013
  t2559 = t473 * t424 * t201 * t429
  t2577 = 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1418 * t2537 - 0.26666666666666666666666666666666666666666666666666e-1 * t1401 * t1410 * t436 * t1402 * t1323 * t1991 - 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t1403 * t2537 + 0.17777777777777777777777777777777777777777777777778e-1 * t1885 * t468 * t2527 * t1339 + 0.11111111111111111111111111111111111111111111111111e-1 * t1919 + 0.33333333333333333333333333333333333333333333333334e-1 * t1922 - 0.22222222222222222222222222222222222222222222222222e-1 * t1924 - 0.22222222222222222222222222222222222222222222222222e-2 * t2559 * t2286 * t2384 - 0.30000000000000000000000000000000000000000000000000e-1 * t2559 * t433 * t435 * t2278 * t2384 - 0.20000000000000000000000000000000000000000000000000e-1 * t2559 * t2279 * t2388 + 0.20000000000000000000000000000000000000000000000000e-1 * t2559 * t2279 * t2384 + 0.66666666666666666666666666666666666666666666666666e-2 * t2559 * t2286 * t2388
  t2580 = f.my_piecewise3(t70, 0, t2268 + t2317 + t2536 + t2577)
  t2581 = -0.20000000000000000000000000000000000000000000000000e0 * (-t508 - t510 - t514) * t2 * t119 - 0.40000000000000000000000000000000000000000000000000e0 * t1485 - 0.40000000000000000000000000000000000000000000000000e0 * t1268 * t1346 - 0.40000000000000000000000000000000000000000000000000e0 * t1268 * t1351 - 0.40000000000000000000000000000000000000000000000000e0 * t1497 - 0.40000000000000000000000000000000000000000000000000e0 * t1566 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t2139 * t118 - 0.40000000000000000000000000000000000000000000000000e0 * t128 * t1345 * t1350 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t115 * (t725 * t2147 * t729 - t2139 * t218 + t2139) + t2218 + t2580
  d22 = -0.40000000000000000000000000000000000000000000000000e0 * t1269 - t127 - 0.40000000000000000000000000000000000000000000000000e0 * t1347 - 0.40000000000000000000000000000000000000000000000000e0 * t1352 + 0.2e1 * t1377 + 0.2e1 * t1479 + t2 * t2581
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t5 = t1 * t4
  t6 = t1 ** 2
  t7 = t3 * t2
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t11 = -0.2e1 * t5 + 0.2e1 * t9
  t12 = t11 * t2
  t13 = r0 <= f.p.dens_threshold
  t14 = 2 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t2
  t18 = 0.2e1 * r0 * t15 <= f.p.zeta_threshold
  t19 = f.p.zeta_threshold - 0.1e1
  t22 = 0.2e1 * r1 * t15 <= f.p.zeta_threshold
  t23 = -t19
  t24 = t1 * t15
  t25 = f.my_piecewise5(t18, t19, t22, t23, t24)
  t26 = 0.1e1 + t25
  t27 = t26 * t2
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = 0.1e1 / t28
  t30 = t14 * t29
  t31 = jnp.pi ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t31
  t33 = t30 * t32
  t34 = r0 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = 0.1e1 / t35 / r0
  t40 = params.gamma * tau0
  t43 = params.gamma * s0
  t44 = r0 ** 2
  t46 = 0.1e1 / t35 / t44
  t49 = l0 * t37 / 0.6e1 - 0.2e1 / 0.3e1 * t40 * t37 + t43 * t46 / 0.12e2
  t50 = abs(t49)
  t51 = t50 < 0.50e-12
  t52 = 0.0e0 < t49
  t53 = f.my_piecewise3(t52, 0.50e-12, -0.50e-12)
  t54 = f.my_piecewise3(t51, t53, t49)
  t55 = br89_x(t54)
  t57 = jnp.exp(t55 / 0.3e1)
  t58 = 0.1e1 / t57
  t59 = jnp.exp(-t55)
  t62 = t59 * (0.1e1 + t55 / 0.2e1)
  t63 = 0.1e1 - t62
  t64 = 0.1e1 / t63
  t65 = t58 * t64
  t66 = t65 * t55
  t69 = f.my_piecewise3(t13, 0, t33 * t66 / 0.2e1)
  t70 = r1 <= f.p.dens_threshold
  t71 = f.my_piecewise5(t22, t19, t18, t23, -t24)
  t72 = 0.1e1 + t71
  t73 = t72 * t2
  t74 = t73 ** (0.1e1 / 0.3e1)
  t75 = 0.1e1 / t74
  t76 = t14 * t75
  t77 = t76 * t32
  t78 = r1 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t81 = 0.1e1 / t79 / r1
  t84 = params.gamma * tau1
  t87 = params.gamma * s2
  t88 = r1 ** 2
  t90 = 0.1e1 / t79 / t88
  t93 = l1 * t81 / 0.6e1 - 0.2e1 / 0.3e1 * t84 * t81 + t87 * t90 / 0.12e2
  t94 = abs(t93)
  t95 = t94 < 0.50e-12
  t96 = 0.0e0 < t93
  t97 = f.my_piecewise3(t96, 0.50e-12, -0.50e-12)
  t98 = f.my_piecewise3(t95, t97, t93)
  t99 = br89_x(t98)
  t101 = jnp.exp(t99 / 0.3e1)
  t102 = 0.1e1 / t101
  t103 = jnp.exp(-t99)
  t106 = t103 * (0.1e1 + t99 / 0.2e1)
  t107 = 0.1e1 - t106
  t108 = 0.1e1 / t107
  t109 = t102 * t108
  t110 = t109 * t99
  t113 = f.my_piecewise3(t70, 0, t77 * t110 / 0.2e1)
  t114 = t69 + t113
  t115 = params.cab * t114
  t116 = 0.1e1 + t115
  t117 = jnp.log(t116)
  t118 = t115 - t117
  t119 = t115 * t118
  t120 = t12 * t119
  t123 = -t6 * t4 + 0.1e1
  t124 = t123 * params.cab
  t125 = t114 * t118
  t127 = 0.40000000000000000000000000000000000000000000000000e0 * t124 * t125
  t128 = t123 * t2
  t130 = 0.1e1 / t28 / t27
  t131 = t14 * t130
  t132 = t131 * t32
  t133 = t15 - t5
  t134 = f.my_piecewise5(t18, 0, t22, 0, t133)
  t136 = t134 * t2 + t25 + 0.1e1
  t137 = t55 * t136
  t138 = t65 * t137
  t141 = t31 * t58
  t142 = t141 * t64
  t143 = t30 * t142
  t144 = f.my_piecewise3(t52, 0, 0)
  t151 = 0.1e1 / t35 / t44 / r0
  t155 = f.my_piecewise3(t51, t144, -0.5e1 / 0.18e2 * l0 * t46 + 0.10e2 / 0.9e1 * t40 * t46 - 0.2e1 / 0.9e1 * t43 * t151)
  t157 = t54 ** 2
  t158 = 0.1e1 / t157
  t159 = t55 * t155 * t158
  t161 = jnp.exp(-0.2e1 / 0.3e1 * t55)
  t162 = 0.1e1 / t161
  t163 = t55 ** 2
  t165 = t163 - 0.2e1 * t55 + 0.3e1
  t166 = 0.1e1 / t165
  t167 = t162 * t166
  t168 = t55 - 0.2e1
  t169 = t168 ** 2
  t170 = t167 * t169
  t171 = t159 * t170
  t174 = t63 ** 2
  t175 = 0.1e1 / t174
  t176 = t58 * t175
  t177 = t31 ** 2
  t178 = t177 * t155
  t179 = t158 * t162
  t180 = t178 * t179
  t181 = t166 * t169
  t182 = t181 * t62
  t184 = t178 * t158
  t186 = t167 * t169 * t59
  t189 = t180 * t182 - t184 * t186 / 0.2e1
  t191 = t176 * t55 * t189
  t194 = t155 * t158
  t195 = t194 * t170
  t199 = f.my_piecewise3(t13, 0, -t132 * t138 / 0.6e1 - t143 * t171 / 0.6e1 - t33 * t191 / 0.2e1 + t143 * t195 / 0.2e1)
  t201 = 0.1e1 / t74 / t73
  t202 = t14 * t201
  t203 = t202 * t32
  t204 = -t133
  t205 = f.my_piecewise5(t22, 0, t18, 0, t204)
  t207 = t205 * t2 + t71 + 0.1e1
  t212 = f.my_piecewise3(t70, 0, -t203 * t109 * t99 * t207 / 0.6e1)
  t213 = t199 + t212
  t214 = params.cab * t213
  t215 = t214 * t118
  t216 = t128 * t215
  t218 = 0.1e1 / t116
  t220 = -t214 * t218 + t214
  t221 = t115 * t220
  t222 = t128 * t221
  t225 = 0.1e1 + t24 <= f.p.zeta_threshold
  t227 = 0.1e1 - t24 <= f.p.zeta_threshold
  t228 = f.my_piecewise5(t225, t19, t227, t23, t24)
  t229 = 0.1e1 + t228
  t230 = t229 ** (0.1e1 / 0.3e1)
  t231 = t230 ** 2
  t233 = t14 ** 2
  t234 = t231 * t229 * t233
  t235 = t2 ** (0.1e1 / 0.3e1)
  t236 = t235 ** 2
  t237 = t236 * t2
  t238 = t234 * t237
  t243 = 0.2e1 * tau0 * t37 - s0 * t46 / 0.4e1
  t244 = params.css ** 2
  t245 = t244 ** 2
  t246 = t243 * t245
  t247 = t246 * t130
  t248 = t238 * t247
  t249 = t31 * jnp.pi
  t250 = 0.1e1 / t249
  t251 = t57 ** 2
  t252 = t251 ** 2
  t253 = 0.1e1 / t252
  t254 = t250 * t253
  t255 = t174 ** 2
  t256 = 0.1e1 / t255
  t257 = t254 * t256
  t258 = t163 ** 2
  t259 = params.css * t14
  t260 = t259 * t29
  t261 = t32 * t58
  t262 = t64 * t55
  t266 = 0.1e1 + t260 * t261 * t262 / 0.2e1
  t267 = jnp.log(t266)
  t268 = 0.1e1 / params.css
  t269 = t267 * t268
  t270 = t233 * t28
  t271 = t269 * t270
  t272 = t31 * t57
  t273 = 0.1e1 / t55
  t274 = t63 * t273
  t277 = -t271 * t272 * t274 + 0.1e1
  t278 = t258 * t277
  t279 = f.my_piecewise5(t225, 0, t227, 0, t133)
  t281 = t257 * t278 * t279
  t284 = t229 ** 2
  t286 = t231 * t284 * t233
  t287 = t236 * t243
  t289 = t286 * t287 * t245
  t291 = t130 * t250 * t253
  t292 = t256 * t258
  t294 = t291 * t292 * t277
  t296 = 0.41666666666666666666666666666666666666666666666667e-2 * t289 * t294
  t301 = -0.10e2 / 0.3e1 * tau0 * t46 + 0.2e1 / 0.3e1 * s0 * t151
  t302 = t237 * t301
  t304 = t286 * t302 * t245
  t307 = t286 * t237
  t308 = t26 ** 2
  t311 = 0.1e1 / t28 / t308 / t3
  t312 = t246 * t311
  t313 = t307 * t312
  t315 = t257 * t278 * t136
  t318 = t237 * t243
  t319 = t286 * t318
  t321 = 0.1e1 / t177
  t322 = t321 * t253
  t323 = t245 * t130 * t322
  t324 = t319 * t323
  t325 = t277 * t155
  t326 = t292 * t325
  t327 = t179 * t181
  t328 = t326 * t327
  t331 = t307 * t247
  t333 = 0.1e1 / t255 / t63
  t334 = t254 * t333
  t336 = t334 * t278 * t189
  t339 = t163 * t55
  t340 = t256 * t339
  t341 = t340 * t325
  t342 = t341 * t327
  t346 = t286 * t318 * t245
  t348 = t259 * t130 * t32
  t351 = t260 * t142
  t355 = t259 * t29 * t32
  t360 = t259 * t29 * t31 * t58
  t366 = -t348 * t138 / 0.6e1 - t351 * t171 / 0.6e1 - t355 * t191 / 0.2e1 + t360 * t64 * t155 * t158 * t170 / 0.2e1
  t367 = 0.1e1 / t266
  t368 = t366 * t367
  t369 = t268 * t233
  t370 = t368 * t369
  t371 = t28 * t31
  t372 = t57 * t63
  t374 = t371 * t372 * t273
  t376 = t28 ** 2
  t377 = 0.1e1 / t376
  t379 = t269 * t233 * t377
  t381 = t272 * t274 * t136
  t384 = t269 * t233
  t385 = t28 * jnp.pi
  t387 = t384 * t385 * t155
  t388 = t179 * t166
  t389 = t169 * t57
  t390 = t389 * t274
  t391 = t388 * t390
  t394 = t189 * t273
  t398 = t384 * t385 * t57
  t399 = 0.1e1 / t163
  t400 = t63 * t399
  t402 = t400 * t155 * t327
  t404 = -t370 * t374 - t379 * t381 / 0.3e1 - t387 * t391 / 0.3e1 - t271 * t272 * t394 + t398 * t402
  t406 = t291 * t292 * t404
  t410 = f.my_piecewise3(t13, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t248 * t281 - t296 - 0.25000000000000000000000000000000000000000000000000e-2 * t304 * t294 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t315 + 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t328 + 0.10000000000000000000000000000000000000000000000000e-1 * t331 * t336 - 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t342 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t406)
  t412 = f.my_piecewise5(t227, t19, t225, t23, -t24)
  t413 = 0.1e1 + t412
  t414 = t413 ** (0.1e1 / 0.3e1)
  t415 = t414 ** 2
  t417 = t415 * t413 * t233
  t418 = t417 * t237
  t423 = 0.2e1 * tau1 * t81 - s2 * t90 / 0.4e1
  t424 = t423 * t245
  t425 = t424 * t201
  t426 = t418 * t425
  t427 = t101 ** 2
  t428 = t427 ** 2
  t429 = 0.1e1 / t428
  t430 = t250 * t429
  t431 = t107 ** 2
  t432 = t431 ** 2
  t433 = 0.1e1 / t432
  t434 = t430 * t433
  t435 = t99 ** 2
  t436 = t435 ** 2
  t437 = t259 * t75
  t438 = t32 * t102
  t439 = t108 * t99
  t443 = 0.1e1 + t437 * t438 * t439 / 0.2e1
  t444 = jnp.log(t443)
  t445 = t444 * t268
  t446 = t233 * t74
  t447 = t445 * t446
  t448 = t31 * t101
  t449 = 0.1e1 / t99
  t450 = t107 * t449
  t453 = -t447 * t448 * t450 + 0.1e1
  t454 = t436 * t453
  t455 = f.my_piecewise5(t227, 0, t225, 0, t204)
  t457 = t434 * t454 * t455
  t460 = t413 ** 2
  t462 = t415 * t460 * t233
  t463 = t236 * t423
  t465 = t462 * t463 * t245
  t467 = t201 * t250 * t429
  t468 = t433 * t436
  t470 = t467 * t468 * t453
  t472 = 0.41666666666666666666666666666666666666666666666667e-2 * t465 * t470
  t473 = t462 * t237
  t474 = t72 ** 2
  t477 = 0.1e1 / t74 / t474 / t3
  t478 = t424 * t477
  t479 = t473 * t478
  t481 = t434 * t454 * t207
  t484 = t237 * t423
  t486 = t462 * t484 * t245
  t487 = 0.1e1 / t72
  t488 = t487 * t15
  t489 = 0.1e1 / t443
  t490 = t207 * t489
  t492 = t74 ** 2
  t493 = 0.1e1 / t492
  t495 = t445 * t233 * t493
  t497 = t448 * t450 * t207
  t500 = t488 * t490 / 0.3e1 - t495 * t497 / 0.3e1
  t502 = t467 * t468 * t500
  t506 = f.my_piecewise3(t70, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t426 * t457 - t472 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t481 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t502)
  t508 = 0.2e1 * t4
  t509 = t1 * t8
  t510 = 0.8e1 * t509
  t511 = t3 ** 2
  t514 = 0.6e1 * t6 / t511
  t520 = t11 * params.cab * t125
  t527 = t124 * t213 * t118
  t530 = t124 * t114 * t220
  t536 = t44 ** 2
  t538 = 0.1e1 / t35 / t536
  t542 = f.my_piecewise3(t51, t144, 0.20e2 / 0.27e2 * l0 * t151 - 0.80e2 / 0.27e2 * t40 * t151 + 0.22e2 / 0.27e2 * t43 * t538)
  t545 = t55 * t542 * t158 * t170
  t549 = jnp.pi * t58 * t64
  t550 = t30 * t549
  t551 = t155 ** 2
  t552 = t55 * t551
  t553 = t157 ** 2
  t554 = 0.1e1 / t553
  t555 = t552 * t554
  t556 = t161 ** 2
  t557 = 0.1e1 / t556
  t558 = t165 ** 2
  t559 = 0.1e1 / t558
  t560 = t557 * t559
  t561 = t169 ** 2
  t563 = t555 * t560 * t561
  t567 = 0.1e1 / t157 / t54
  t571 = t194 * t162
  t572 = t559 * t169
  t578 = 0.2e1 * t55 * t177 * t155 * t327 - 0.2e1 * t184 * t170
  t579 = t572 * t578
  t580 = t571 * t579
  t583 = t30 * t31
  t586 = t181 * t189
  t587 = t571 * t586
  t591 = t552 * t567 * t170
  t597 = t141 * t175
  t601 = t131 * t31 * t66
  t604 = t136 * t155 * t158 * t170
  t607 = t131 * t142
  t615 = t169 * t168
  t616 = t560 * t615
  t619 = t555 * t616
  t622 = t14 * t311
  t623 = t622 * t32
  t624 = t136 ** 2
  t626 = t65 * t55 * t624
  t630 = -0.2e1 * t4 + 0.2e1 * t509
  t631 = f.my_piecewise5(t18, 0, t22, 0, t630)
  t634 = t631 * t2 + 0.2e1 * t134
  t636 = t65 * t55 * t634
  t639 = t177 * t542
  t642 = t177 * t551
  t643 = t567 * t162
  t647 = t249 * t551
  t648 = t554 * t557
  t649 = t647 * t648
  t650 = t559 * t561
  t657 = t559 * t615
  t661 = t647 * t554
  t678 = t639 * t179 * t182 - 0.2e1 * t642 * t643 * t182 - t649 * t650 * t62 / 0.3e1 - t180 * t572 * t62 * t578 + 0.2e1 * t649 * t657 * t62 + 0.2e1 / 0.3e1 * t661 * t560 * t561 * t59 - t639 * t158 * t186 / 0.2e1 + t642 * t567 * t186 + t180 * t572 * t59 * t578 / 0.2e1 - t661 * t560 * t615 * t59
  t680 = t176 * t55 * t678
  t683 = t131 * t261
  t684 = t175 * t55
  t685 = t136 * t189
  t692 = t189 ** 2
  t694 = t58 / t174 / t63 * t55 * t692
  t696 = -t143 * t545 / 0.6e1 - t550 * t563 / 0.18e2 - t143 * t551 * t567 * t170 - t143 * t580 / 0.2e1 + t583 * t176 * t55 * t587 / 0.3e1 + t143 * t591 / 0.3e1 + t583 * t66 * t580 / 0.6e1 - t30 * t597 * t587 + t601 * t604 / 0.9e1 - t607 * t604 / 0.3e1 + t143 * t542 * t158 * t170 / 0.2e1 + t550 * t551 * t554 * t616 - t550 * t619 / 0.3e1 + 0.2e1 / 0.9e1 * t623 * t626 - t132 * t636 / 0.6e1 - t33 * t680 / 0.2e1 + t683 * t684 * t685 / 0.3e1 + t33 * t694
  t697 = f.my_piecewise3(t13, 0, t696)
  t698 = t14 * t477
  t699 = t698 * t32
  t700 = t207 ** 2
  t705 = -t630
  t706 = f.my_piecewise5(t22, 0, t18, 0, t705)
  t709 = t706 * t2 + 0.2e1 * t205
  t715 = f.my_piecewise3(t70, 0, 0.2e1 / 0.9e1 * t699 * t109 * t99 * t700 - t203 * t109 * t99 * t709 / 0.6e1)
  t717 = params.cab * (t697 + t715)
  t725 = params.cab ** 2
  t726 = t213 ** 2
  t728 = t116 ** 2
  t729 = 0.1e1 / t728
  t736 = t286 * t287 * t323
  t737 = t736 * t328
  t740 = t286 * t302 * t323
  t743 = t404 * t155
  t748 = t277 * t542
  t761 = t277 * t551
  t762 = t340 * t761
  t763 = t643 * t181
  t769 = t292 * t761
  t773 = t736 * t342
  t780 = 0.11111111111111111111111111111111111111111111111111e-1 * t737 + 0.66666666666666666666666666666666666666666666666666e-2 * t740 * t328 + 0.66666666666666666666666666666666666666666666666666e-2 * t324 * t292 * t743 * t327 + 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t292 * t748 * t327 - 0.20000000000000000000000000000000000000000000000000e-1 * t324 * t340 * t743 * t327 - 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t340 * t748 * t327 + 0.20000000000000000000000000000000000000000000000000e-1 * t324 * t762 * t763 - 0.20000000000000000000000000000000000000000000000000e-1 * t740 * t342 - 0.66666666666666666666666666666666666666666666666666e-2 * t324 * t769 * t763 - 0.33333333333333333333333333333333333333333333333334e-1 * t773 + 0.53333333333333333333333333333333333333333333333334e-1 * t248 * t334 * t278 * t279 * t189
  t785 = t238 * t312
  t791 = t258 * t404
  t800 = t301 * t245
  t802 = t307 * t800 * t311
  t805 = t800 * t130
  t817 = t238 * t805
  t824 = f.my_piecewise5(t225, 0, t227, 0, t630)
  t829 = t286 * t236
  t830 = t829 * t312
  t831 = t830 * t315
  t833 = -0.26666666666666666666666666666666666666666666666666e-1 * t313 * t334 * t278 * t685 + 0.17777777777777777777777777777777777777777777777778e-1 * t785 * t257 * t278 * t279 * t136 + 0.20000000000000000000000000000000000000000000000000e-1 * t331 * t334 * t791 * t189 + 0.10000000000000000000000000000000000000000000000000e-1 * t331 * t334 * t278 * t678 + 0.66666666666666666666666666666666666666666666666666e-2 * t802 * t315 + 0.20000000000000000000000000000000000000000000000000e-1 * t307 * t805 * t336 + 0.66666666666666666666666666666666666666666666666666e-2 * t313 * t257 * t791 * t136 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t278 * t634 - 0.13333333333333333333333333333333333333333333333333e-1 * t817 * t281 - 0.13333333333333333333333333333333333333333333333333e-1 * t248 * t257 * t791 * t279 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t278 * t824 + 0.11111111111111111111111111111111111111111111111111e-1 * t831
  t836 = t829 * t247 * t336
  t850 = t307 * t246 / t28 / t308 / t26 / t7
  t857 = t231 * t233 * t237 * t247
  t858 = t279 ** 2
  t864 = t234 * t236 * t247
  t865 = t864 * t281
  t879 = t368 * t268
  t885 = t377 * jnp.pi
  t887 = t384 * t885 * t372
  t899 = t384 * t885 * t194
  t907 = t162 * t559
  t919 = t907 * t169 * t578
  t923 = t368 * t369 * t377
  t937 = t400 * t551
  t949 = 0.2e1 * t879 * t270 * jnp.pi * t57 * t402 + 0.2e1 / 0.3e1 * t887 * t399 * t136 * t155 * t327 - 0.2e1 / 0.3e1 * t879 * t270 * jnp.pi * t155 * t391 - 0.2e1 / 0.9e1 * t899 * t170 * t372 * t273 * t136 + t384 * t385 * t194 * t907 * t169 * t372 * t273 * t578 / 0.3e1 - t384 * t385 * t372 * t399 * t155 * t158 * t919 - 0.2e1 / 0.3e1 * t923 * t381 + 0.2e1 / 0.3e1 * t384 * t385 * t551 * t643 * t166 * t390 + 0.2e1 * t398 * t189 * t399 * t155 * t327 - 0.2e1 * t398 * t937 * t763 - t384 * t385 * t542 * t391 / 0.3e1 - 0.2e1 / 0.3e1 * t387 * t388 * t389 * t394
  t950 = t177 * jnp.pi
  t951 = t28 * t950
  t953 = t384 * t951 * t551
  t954 = t648 * t559
  t955 = t561 * t57
  t964 = t384 * t951 * t57
  t968 = t648 * t650
  t981 = t648 * t657
  t988 = t260 * t597
  t1001 = t259 * t130 * t142
  t1008 = t260 * t549
  t1019 = t64 * t551
  t1045 = t988 * t159 * t167 * t169 * t189 / 0.3e1 + t351 * t591 / 0.3e1 + t351 * t159 * t919 / 0.6e1 - t988 * t587 + t1001 * t137 * t155 * t327 / 0.9e1 - t1001 * t604 / 0.3e1 - t1008 * t619 / 0.3e1 + t360 * t64 * t542 * t158 * t170 / 0.2e1 + t259 * t29 * jnp.pi * t58 * t1019 * t554 * t616 + t355 * t694 + 0.2e1 / 0.9e1 * t259 * t311 * t32 * t626 + t348 * t176 * t137 * t189 / 0.3e1 - t1008 * t563 / 0.18e2 - t360 * t1019 * t567 * t170 - t351 * t580 / 0.2e1 - t351 * t545 / 0.6e1 - t355 * t680 / 0.2e1 - t348 * t636 / 0.6e1
  t1051 = t233 / t376 / t27
  t1052 = t269 * t1051
  t1057 = t366 ** 2
  t1058 = t266 ** 2
  t1059 = 0.1e1 / t1058
  t1076 = -t953 * t954 * t955 * t274 / 0.3e1 + t398 * t400 * t542 * t327 - 0.2e1 * t964 * t63 / t339 * t551 * t968 - 0.2e1 / 0.3e1 * t953 * t954 * t615 * t57 * t274 + 0.4e1 / 0.3e1 * t953 * t954 * t955 * t400 + 0.2e1 * t964 * t937 * t981 - t271 * t272 * t678 * t273 - t1045 * t367 * t369 * t374 + 0.2e1 / 0.9e1 * t1052 * t272 * t274 * t624 + t1057 * t1059 * t369 * t374 - 0.2e1 / 0.3e1 * t379 * t272 * t394 * t136 - t379 * t272 * t274 * t634 / 0.3e1 - 0.2e1 * t370 * t371 * t57 * t189 * t273
  t1082 = 0.1e1 / t235
  t1087 = 0.27777777777777777777777777777777777777777777777778e-2 * t286 * t1082 * t243 * t245 * t294
  t1091 = t286 * t236 * t301 * t245 * t294
  t1093 = t289 * t406
  t1096 = t234 * t318 * t323
  t1097 = t277 * t279
  t1102 = 0.33333333333333333333333333333333333333333333333334e-1 * t836 - 0.50000000000000000000000000000000000000000000000000e-1 * t331 * t254 / t255 / t174 * t278 * t692 - 0.77777777777777777777777777777777777777777777777777e-2 * t850 * t257 * t278 * t624 - 0.11111111111111111111111111111111111111111111111111e-1 * t857 * t257 * t278 * t858 - 0.22222222222222222222222222222222222222222222222222e-1 * t865 - 0.25000000000000000000000000000000000000000000000000e-2 * t286 * t237 * (0.80e2 / 0.9e1 * tau0 * t151 - 0.22e2 / 0.9e1 * s0 * t538) * t245 * t294 - 0.50000000000000000000000000000000000000000000000000e-2 * t304 * t406 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t291 * t292 * (t949 + t1076) - t1087 - 0.83333333333333333333333333333333333333333333333334e-2 * t1091 - 0.83333333333333333333333333333333333333333333333334e-2 * t1093 + 0.17777777777777777777777777777777777777777777777778e-1 * t1096 * t292 * t1097 * t195
  t1109 = t319 * t245 * t311 * t322
  t1110 = t277 * t136
  t1121 = t179 * t579
  t1140 = t307 * t246 * t130 * t253
  t1158 = -0.53333333333333333333333333333333333333333333333334e-1 * t1096 * t340 * t1097 * t195 + 0.26666666666666666666666666666666666666666666666666e-1 * t1109 * t340 * t1110 * t195 + 0.80000000000000000000000000000000000000000000000000e-1 * t324 * t333 * t339 * t277 * t189 * t195 + 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t341 * t1121 - 0.88888888888888888888888888888888888888888888888888e-2 * t1109 * t292 * t1110 * t195 - 0.26666666666666666666666666666666666666666666666666e-1 * t324 * t333 * t258 * t325 * t179 * t586 - 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t326 * t1121 + 0.20000000000000000000000000000000000000000000000000e-1 * t1140 * t762 * t968 + 0.66666666666666666666666666666666666666666666666666e-2 * t1140 * t769 * t981 - 0.30000000000000000000000000000000000000000000000000e-1 * t1140 * t256 * t163 * t761 * t968 - 0.20000000000000000000000000000000000000000000000000e-1 * t1140 * t762 * t981 - 0.22222222222222222222222222222222222222222222222222e-2 * t1140 * t769 * t968
  t1161 = f.my_piecewise3(t13, 0, t780 + t833 + t1102 + t1158)
  t1164 = t415 * t233 * t237 * t425
  t1165 = t455 ** 2
  t1171 = t417 * t236 * t425
  t1172 = t1171 * t457
  t1174 = t418 * t478
  t1180 = t436 * t500
  t1185 = f.my_piecewise5(t227, 0, t225, 0, t705)
  t1194 = 0.27777777777777777777777777777777777777777777777778e-2 * t462 * t1082 * t423 * t245 * t470
  t1195 = t462 * t236
  t1196 = t1195 * t478
  t1197 = t1196 * t481
  t1199 = t465 * t502
  t1206 = t473 * t424 / t74 / t474 / t72 / t7
  t1219 = 0.1e1 / t474
  t1230 = t443 ** 2
  t1231 = 0.1e1 / t1230
  t1238 = t1219 * t4
  t1244 = t233 / t492 / t73
  t1245 = t445 * t1244
  t1259 = -0.11111111111111111111111111111111111111111111111111e-1 * t1164 * t434 * t454 * t1165 - 0.22222222222222222222222222222222222222222222222222e-1 * t1172 + 0.17777777777777777777777777777777777777777777777778e-1 * t1174 * t434 * t454 * t455 * t207 - 0.13333333333333333333333333333333333333333333333333e-1 * t426 * t434 * t1180 * t455 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t454 * t1185 - t1194 + 0.11111111111111111111111111111111111111111111111111e-1 * t1197 - 0.83333333333333333333333333333333333333333333333334e-2 * t1199 - 0.77777777777777777777777777777777777777777777777777e-2 * t1206 * t434 * t454 * t700 + 0.66666666666666666666666666666666666666666666666666e-2 * t479 * t434 * t1180 * t207 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t454 * t709 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t467 * t468 * (-t1219 * t15 * t490 * t205 / 0.3e1 - t487 * t4 * t490 / 0.3e1 + t488 * t709 * t489 / 0.3e1 + t488 * t700 * t1231 * params.css * t203 * t110 / 0.18e2 + t1238 * t700 * t489 / 0.9e1 + 0.2e1 / 0.9e1 * t1245 * t448 * t450 * t700 - t495 * t448 * t450 * t709 / 0.3e1)
  t1260 = f.my_piecewise3(t70, 0, t1259)
  t1261 = -0.20000000000000000000000000000000000000000000000000e0 * (-t508 + t510 - t514) * t2 * t119 - 0.40000000000000000000000000000000000000000000000000e0 * t520 - 0.40000000000000000000000000000000000000000000000000e0 * t12 * t215 - 0.40000000000000000000000000000000000000000000000000e0 * t12 * t221 - 0.40000000000000000000000000000000000000000000000000e0 * t527 - 0.40000000000000000000000000000000000000000000000000e0 * t530 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t717 * t118 - 0.40000000000000000000000000000000000000000000000000e0 * t128 * t214 * t220 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t115 * (t725 * t726 * t729 - t717 * t218 + t717) + t1161 + t1260
  d11 = -0.40000000000000000000000000000000000000000000000000e0 * t120 - t127 - 0.40000000000000000000000000000000000000000000000000e0 * t216 - 0.40000000000000000000000000000000000000000000000000e0 * t222 + 0.2e1 * t410 + 0.2e1 * t506 + t2 * t1261
  t1267 = 0.2e1 * t5 + 0.2e1 * t9
  t1268 = t1267 * t2
  t1269 = t1268 * t119
  t1271 = -t15 - t5
  t1272 = f.my_piecewise5(t18, 0, t22, 0, t1271)
  t1274 = t1272 * t2 + t25 + 0.1e1
  t1279 = f.my_piecewise3(t13, 0, -t132 * t65 * t55 * t1274 / 0.6e1)
  t1280 = -t1271
  t1281 = f.my_piecewise5(t22, 0, t18, 0, t1280)
  t1283 = t1281 * t2 + t71 + 0.1e1
  t1284 = t99 * t1283
  t1285 = t109 * t1284
  t1288 = t31 * t102
  t1289 = t1288 * t108
  t1290 = t76 * t1289
  t1291 = f.my_piecewise3(t96, 0, 0)
  t1298 = 0.1e1 / t79 / t88 / r1
  t1302 = f.my_piecewise3(t95, t1291, -0.5e1 / 0.18e2 * l1 * t90 + 0.10e2 / 0.9e1 * t84 * t90 - 0.2e1 / 0.9e1 * t87 * t1298)
  t1304 = t98 ** 2
  t1305 = 0.1e1 / t1304
  t1306 = t99 * t1302 * t1305
  t1308 = jnp.exp(-0.2e1 / 0.3e1 * t99)
  t1309 = 0.1e1 / t1308
  t1311 = t435 - 0.2e1 * t99 + 0.3e1
  t1312 = 0.1e1 / t1311
  t1313 = t1309 * t1312
  t1314 = t99 - 0.2e1
  t1315 = t1314 ** 2
  t1316 = t1313 * t1315
  t1317 = t1306 * t1316
  t1320 = 0.1e1 / t431
  t1321 = t102 * t1320
  t1322 = t177 * t1302
  t1323 = t1305 * t1309
  t1324 = t1322 * t1323
  t1325 = t1312 * t1315
  t1326 = t1325 * t106
  t1328 = t1322 * t1305
  t1330 = t1313 * t1315 * t103
  t1333 = t1324 * t1326 - t1328 * t1330 / 0.2e1
  t1334 = t99 * t1333
  t1335 = t1321 * t1334
  t1338 = t1302 * t1305
  t1339 = t1338 * t1316
  t1343 = f.my_piecewise3(t70, 0, -t203 * t1285 / 0.6e1 - t1290 * t1317 / 0.6e1 - t77 * t1335 / 0.2e1 + t1290 * t1339 / 0.2e1)
  t1344 = t1279 + t1343
  t1345 = params.cab * t1344
  t1346 = t1345 * t118
  t1347 = t128 * t1346
  t1350 = -t1345 * t218 + t1345
  t1351 = t115 * t1350
  t1352 = t128 * t1351
  t1354 = f.my_piecewise5(t225, 0, t227, 0, t1271)
  t1356 = t257 * t278 * t1354
  t1360 = t257 * t278 * t1274
  t1363 = 0.1e1 / t26
  t1364 = t1363 * t15
  t1365 = t1274 * t367
  t1368 = t272 * t274 * t1274
  t1371 = t1364 * t1365 / 0.3e1 - t379 * t1368 / 0.3e1
  t1373 = t291 * t292 * t1371
  t1377 = f.my_piecewise3(t13, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t248 * t1356 - t296 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t1360 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t1373)
  t1378 = f.my_piecewise5(t227, 0, t225, 0, t1280)
  t1380 = t434 * t454 * t1378
  t1387 = -0.10e2 / 0.3e1 * tau1 * t90 + 0.2e1 / 0.3e1 * s2 * t1298
  t1388 = t237 * t1387
  t1390 = t462 * t1388 * t245
  t1394 = t434 * t454 * t1283
  t1397 = t462 * t484
  t1399 = t321 * t429
  t1400 = t245 * t201 * t1399
  t1401 = t1397 * t1400
  t1402 = t453 * t1302
  t1403 = t468 * t1402
  t1404 = t1323 * t1325
  t1405 = t1403 * t1404
  t1408 = t473 * t425
  t1410 = 0.1e1 / t432 / t107
  t1411 = t430 * t1410
  t1413 = t1411 * t454 * t1333
  t1416 = t435 * t99
  t1417 = t433 * t1416
  t1418 = t1417 * t1402
  t1419 = t1418 * t1404
  t1423 = t259 * t201 * t32
  t1426 = t437 * t1289
  t1430 = t259 * t75 * t32
  t1435 = t259 * t75 * t31 * t102
  t1441 = -t1423 * t1285 / 0.6e1 - t1426 * t1317 / 0.6e1 - t1430 * t1335 / 0.2e1 + t1435 * t108 * t1302 * t1305 * t1316 / 0.2e1
  t1442 = t1441 * t489
  t1443 = t1442 * t369
  t1444 = t74 * t31
  t1445 = t101 * t107
  t1447 = t1444 * t1445 * t449
  t1450 = t448 * t450 * t1283
  t1453 = t445 * t233
  t1454 = t74 * jnp.pi
  t1456 = t1453 * t1454 * t1302
  t1457 = t1323 * t1312
  t1458 = t1315 * t101
  t1459 = t1458 * t450
  t1460 = t1457 * t1459
  t1463 = t1333 * t449
  t1467 = t1453 * t1454 * t101
  t1468 = 0.1e1 / t435
  t1469 = t107 * t1468
  t1471 = t1469 * t1302 * t1404
  t1473 = -t1443 * t1447 - t495 * t1450 / 0.3e1 - t1456 * t1460 / 0.3e1 - t447 * t448 * t1463 + t1467 * t1471
  t1475 = t467 * t468 * t1473
  t1479 = f.my_piecewise3(t70, 0, -0.66666666666666666666666666666666666666666666666667e-2 * t426 * t1380 - t472 - 0.25000000000000000000000000000000000000000000000000e-2 * t1390 * t470 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t1394 + 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t1405 + 0.10000000000000000000000000000000000000000000000000e-1 * t1408 * t1413 - 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1419 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t1475)
  t1485 = t1267 * params.cab * t125
  t1497 = t124 * t1344 * t118
  t1500 = t1274 * t136
  t1506 = t1274 * t155 * t158 * t170
  t1509 = t1274 * t189
  t1515 = 0.2e1 * t509
  t1516 = f.my_piecewise5(t18, 0, t22, 0, t1515)
  t1518 = t1516 * t2 + t1272 + t134
  t1524 = f.my_piecewise3(t13, 0, 0.2e1 / 0.9e1 * t622 * t261 * t262 * t1500 + t601 * t1506 / 0.18e2 + t683 * t684 * t1509 / 0.6e1 - t607 * t1506 / 0.6e1 - t132 * t65 * t55 * t1518 / 0.6e1)
  t1526 = t1283 * t207
  t1530 = f.my_piecewise5(t22, 0, t18, 0, -t1515)
  t1532 = t1530 * t2 + t1281 + t205
  t1534 = t109 * t99 * t1532
  t1538 = t202 * t31 * t110
  t1539 = t1338 * t1309
  t1540 = t1325 * t207
  t1541 = t1539 * t1540
  t1544 = t202 * t438
  t1545 = t1320 * t99
  t1546 = t1333 * t207
  t1550 = t202 * t1289
  t1554 = f.my_piecewise3(t70, 0, 0.2e1 / 0.9e1 * t698 * t438 * t439 * t1526 - t203 * t1534 / 0.6e1 + t1538 * t1541 / 0.18e2 + t1544 * t1545 * t1546 / 0.6e1 - t1550 * t1541 / 0.6e1)
  t1556 = params.cab * (t1524 + t1554)
  t1566 = t124 * t114 * t1350
  t1579 = t1371 * t155
  t1621 = t277 * t1274
  t1626 = t277 * t1354
  t1639 = 0.33333333333333333333333333333333333333333333333333e-2 * t324 * t292 * t1579 * t327 - 0.10000000000000000000000000000000000000000000000000e-1 * t324 * t340 * t1579 * t327 + 0.55555555555555555555555555555555555555555555555556e-2 * t737 - 0.16666666666666666666666666666666666666666666666667e-1 * t773 + 0.26666666666666666666666666666666666666666666666667e-1 * t248 * t334 * t278 * t1354 * t189 + 0.88888888888888888888888888888888888888888888888888e-2 * t785 * t257 * t278 * t1274 * t279 - 0.77777777777777777777777777777777777777777777777777e-2 * t850 * t257 * t278 * t1500 - 0.13333333333333333333333333333333333333333333333333e-1 * t313 * t334 * t278 * t1509 - 0.11111111111111111111111111111111111111111111111111e-1 * t857 * t257 * t278 * t1354 * t279 + 0.88888888888888888888888888888888888888888888888889e-2 * t785 * t257 * t278 * t1354 * t136 + 0.55555555555555555555555555555555555555555555555556e-2 * t831 + 0.16666666666666666666666666666666666666666666666667e-1 * t836 - 0.11111111111111111111111111111111111111111111111111e-1 * t865 + 0.13333333333333333333333333333333333333333333333333e-1 * t1109 * t340 * t1621 * t195 - 0.26666666666666666666666666666666666666666666666667e-1 * t1096 * t340 * t1626 * t195 + 0.88888888888888888888888888888888888888888888888889e-2 * t1096 * t292 * t1626 * t195 - 0.44444444444444444444444444444444444444444444444444e-2 * t1109 * t292 * t1621 * t195
  t1642 = 0.1e1 / t308
  t1643 = t1642 * t15
  t1649 = t1363 * t4 * t1365 / 0.3e1
  t1661 = t273 * t1274
  t1688 = t289 * t1373
  t1692 = f.my_piecewise5(t225, 0, t227, 0, t1515)
  t1705 = t830 * t1360
  t1707 = t864 * t1356
  t1713 = t258 * t1371
  t1730 = -0.25000000000000000000000000000000000000000000000000e-2 * t304 * t1373 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t291 * t292 * (-t1643 * t1365 * t134 / 0.3e1 - t1649 + t1364 * t1518 * t367 / 0.3e1 - t1364 * t1274 * t1059 * t366 / 0.3e1 - t923 * t1368 / 0.3e1 + 0.2e1 / 0.9e1 * t269 * t1051 * t31 * t372 * t1661 * t136 - t899 * t170 * t372 * t1661 / 0.9e1 - t379 * t272 * t394 * t1274 / 0.3e1 + t887 * t399 * t1274 * t155 * t327 / 0.3e1 - t379 * t272 * t274 * t1518 / 0.3e1) - 0.41666666666666666666666666666666666666666666666667e-2 * t1688 - t1087 - 0.41666666666666666666666666666666666666666666666667e-2 * t1091 - 0.41666666666666666666666666666666666666666666666667e-2 * t1093 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t278 * t1692 + 0.33333333333333333333333333333333333333333333333333e-2 * t802 * t1360 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t791 * t1274 - 0.66666666666666666666666666666666666666666666666667e-2 * t817 * t1356 + 0.55555555555555555555555555555555555555555555555555e-2 * t1705 - 0.11111111111111111111111111111111111111111111111111e-1 * t1707 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t278 * t1518 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t1713 * t279 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t1713 * t136 + 0.10000000000000000000000000000000000000000000000000e-1 * t331 * t334 * t1713 * t189 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t791 * t1354
  t1732 = f.my_piecewise3(t13, 0, t1639 + t1730)
  t1733 = t500 * t1302
  t1743 = t462 * t463 * t1400
  t1744 = t1743 * t1419
  t1746 = t1743 * t1405
  t1778 = t1397 * t245 * t477 * t1399
  t1779 = t1323 * t1540
  t1784 = t417 * t484 * t1400
  t1786 = t1323 * t1325 * t455
  t1796 = t465 * t1475
  t1801 = t259 * t477 * t32
  t1809 = t259 * t201 * t1289
  t1811 = t1313 * t1315 * t207
  t1830 = t1442 * t369 * t493
  t1838 = t449 * t1283
  t1852 = t493 * jnp.pi
  t1854 = t1453 * t1852 * t1338
  t1877 = t1453 * t1852 * t1445
  t1879 = t1468 * t1302 * t1305
  t1883 = -(0.2e1 / 0.9e1 * t1801 * t109 * t1284 * t207 - t1423 * t1534 / 0.6e1 + t1809 * t1306 * t1811 / 0.18e2 + t1423 * t1321 * t1334 * t207 / 0.6e1 - t1809 * t1541 / 0.6e1) * t489 * t369 * t1447 - t1441 * t1231 * t488 * t207 / 0.3e1 - t1830 * t497 / 0.3e1 + t1238 * t490 * t1283 / 0.9e1 + 0.2e1 / 0.9e1 * t445 * t1244 * t31 * t1445 * t1838 * t207 - t495 * t448 * t450 * t1532 / 0.3e1 + t488 * t177 * t207 * t489 * t1339 / 0.9e1 - t1854 * t1316 * t1445 * t449 * t207 / 0.9e1 + t488 * t108 * t490 * t1333 / 0.3e1 - t495 * t448 * t1463 * t207 / 0.3e1 - t488 * t177 * t449 * t207 * t489 * t1302 * t1305 * t1316 / 0.3e1 + t1877 * t1879 * t1811 / 0.3e1
  t1888 = 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t468 * t1733 * t1404 - 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1417 * t1733 * t1404 - 0.16666666666666666666666666666666666666666666666667e-1 * t1744 + 0.55555555555555555555555555555555555555555555555555e-2 * t1746 + 0.88888888888888888888888888888888888888888888888888e-2 * t1174 * t434 * t454 * t1283 * t455 - 0.77777777777777777777777777777777777777777777777777e-2 * t1206 * t434 * t454 * t1526 + 0.26666666666666666666666666666666666666666666666667e-1 * t426 * t1411 * t454 * t1333 * t455 - 0.13333333333333333333333333333333333333333333333333e-1 * t479 * t1411 * t454 * t1546 - 0.11111111111111111111111111111111111111111111111111e-1 * t1164 * t434 * t454 * t1378 * t455 + 0.88888888888888888888888888888888888888888888888889e-2 * t1174 * t434 * t454 * t1378 * t207 - 0.44444444444444444444444444444444444444444444444444e-2 * t1778 * t1403 * t1779 - 0.26666666666666666666666666666666666666666666666667e-1 * t1784 * t1418 * t1786 + 0.13333333333333333333333333333333333333333333333333e-1 * t1778 * t1418 * t1779 + 0.88888888888888888888888888888888888888888888888888e-2 * t1784 * t1403 * t1786 - 0.41666666666666666666666666666666666666666666666667e-2 * t1796 - 0.25000000000000000000000000000000000000000000000000e-2 * t1390 * t502 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t467 * t468 * t1883
  t1892 = t462 * t236 * t1387 * t245 * t470
  t1895 = t436 * t1473
  t1904 = t1196 * t1394
  t1907 = t1195 * t425 * t1413
  t1909 = t1171 * t1380
  t1911 = t1387 * t245
  t1912 = t1911 * t201
  t1913 = t418 * t1912
  t1917 = t473 * t1911 * t477
  t1932 = f.my_piecewise5(t227, 0, t225, 0, -t1515)
  t1943 = -0.41666666666666666666666666666666666666666666666667e-2 * t1892 - 0.41666666666666666666666666666666666666666666666667e-2 * t1199 - t1194 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t1895 * t455 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t1895 * t207 + 0.55555555555555555555555555555555555555555555555555e-2 * t1904 + 0.16666666666666666666666666666666666666666666666667e-1 * t1907 - 0.11111111111111111111111111111111111111111111111111e-1 * t1909 - 0.66666666666666666666666666666666666666666666666667e-2 * t1913 * t457 + 0.33333333333333333333333333333333333333333333333333e-2 * t1917 * t481 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t1180 * t1283 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t454 * t1532 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t1180 * t1378 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t454 * t1932 + 0.10000000000000000000000000000000000000000000000000e-1 * t1408 * t1411 * t1180 * t1333 - 0.11111111111111111111111111111111111111111111111111e-1 * t1172 + 0.55555555555555555555555555555555555555555555555556e-2 * t1197
  t1945 = f.my_piecewise3(t70, 0, t1888 + t1943)
  t1946 = -0.20000000000000000000000000000000000000000000000000e0 * (t508 - t514) * t2 * t119 - 0.20000000000000000000000000000000000000000000000000e0 * t1485 - 0.20000000000000000000000000000000000000000000000000e0 * t1268 * t215 - 0.20000000000000000000000000000000000000000000000000e0 * t1268 * t221 - 0.20000000000000000000000000000000000000000000000000e0 * t520 - 0.20000000000000000000000000000000000000000000000000e0 * t527 - 0.20000000000000000000000000000000000000000000000000e0 * t530 - 0.20000000000000000000000000000000000000000000000000e0 * t12 * t1346 - 0.20000000000000000000000000000000000000000000000000e0 * t1497 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t1556 * t118 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t1345 * t220 - 0.20000000000000000000000000000000000000000000000000e0 * t12 * t1351 - 0.20000000000000000000000000000000000000000000000000e0 * t1566 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t214 * t1350 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t115 * (t725 * t1344 * t729 * t213 - t1556 * t218 + t1556) + t1732 + t1945
  d12 = -0.20000000000000000000000000000000000000000000000000e0 * t120 - t127 - 0.20000000000000000000000000000000000000000000000000e0 * t216 - 0.20000000000000000000000000000000000000000000000000e0 * t222 + t410 + t506 - 0.20000000000000000000000000000000000000000000000000e0 * t1269 - 0.20000000000000000000000000000000000000000000000000e0 * t1347 - 0.20000000000000000000000000000000000000000000000000e0 * t1352 + t1377 + t1479 + t2 * t1946
  t1964 = t1274 ** 2
  t1970 = 0.2e1 * t4 + 0.2e1 * t509
  t1971 = f.my_piecewise5(t18, 0, t22, 0, t1970)
  t1974 = t1971 * t2 + 0.2e1 * t1272
  t1980 = f.my_piecewise3(t13, 0, 0.2e1 / 0.9e1 * t623 * t65 * t55 * t1964 - t132 * t65 * t55 * t1974 / 0.6e1)
  t1982 = jnp.pi * t102 * t108
  t1983 = t76 * t1982
  t1984 = t1302 ** 2
  t1985 = t1304 ** 2
  t1986 = 0.1e1 / t1985
  t1988 = t1308 ** 2
  t1989 = 0.1e1 / t1988
  t1990 = t1311 ** 2
  t1991 = 0.1e1 / t1990
  t1992 = t1989 * t1991
  t1993 = t1315 * t1314
  t1994 = t1992 * t1993
  t2001 = t88 ** 2
  t2003 = 0.1e1 / t79 / t2001
  t2007 = f.my_piecewise3(t95, t1291, 0.20e2 / 0.27e2 * l1 * t1298 - 0.80e2 / 0.27e2 * t84 * t1298 + 0.22e2 / 0.27e2 * t87 * t2003)
  t2014 = t1283 * t1302 * t1305 * t1316
  t2019 = t76 * t31
  t2022 = t1325 * t1333
  t2023 = t1539 * t2022
  t2026 = t99 * t1984
  t2028 = 0.1e1 / t1304 / t98
  t2030 = t2026 * t2028 * t1316
  t2034 = t1991 * t1315
  t2040 = 0.2e1 * t99 * t177 * t1302 * t1404 - 0.2e1 * t1328 * t1316
  t2041 = t2034 * t2040
  t2042 = t1539 * t2041
  t2045 = t1288 * t1320
  t2048 = t177 * t2007
  t2051 = t177 * t1984
  t2052 = t2028 * t1309
  t2056 = t249 * t1984
  t2057 = t1986 * t1989
  t2058 = t2056 * t2057
  t2059 = t1315 ** 2
  t2060 = t1991 * t2059
  t2067 = t1991 * t1993
  t2071 = t2056 * t1986
  t2088 = t2048 * t1323 * t1326 - 0.2e1 * t2051 * t2052 * t1326 - t2058 * t2060 * t106 / 0.3e1 - t1324 * t2034 * t106 * t2040 + 0.2e1 * t2058 * t2067 * t106 + 0.2e1 / 0.3e1 * t2071 * t1992 * t2059 * t103 - t2048 * t1305 * t1330 / 0.2e1 + t2051 * t2028 * t1330 + t1324 * t2034 * t103 * t2040 / 0.2e1 - t2071 * t1992 * t1993 * t103
  t2090 = t1321 * t99 * t2088
  t2093 = -t1970
  t2094 = f.my_piecewise5(t22, 0, t18, 0, t2093)
  t2097 = t2094 * t2 + 0.2e1 * t1281
  t2099 = t109 * t99 * t2097
  t2102 = t1283 ** 2
  t2104 = t109 * t99 * t2102
  t2107 = t1283 * t1333
  t2114 = t1333 ** 2
  t2116 = t102 / t431 / t107 * t99 * t2114
  t2120 = t99 * t2007 * t1305 * t1316
  t2123 = t2026 * t1986
  t2125 = t2123 * t1992 * t2059
  t2133 = t2123 * t1994
  t2136 = t1983 * t1984 * t1986 * t1994 + t1290 * t2007 * t1305 * t1316 / 0.2e1 + t1538 * t2014 / 0.9e1 - t1550 * t2014 / 0.3e1 + t2019 * t1321 * t99 * t2023 / 0.3e1 + t1290 * t2030 / 0.3e1 + t2019 * t110 * t2042 / 0.6e1 - t76 * t2045 * t2023 - t77 * t2090 / 0.2e1 - t203 * t2099 / 0.6e1 + 0.2e1 / 0.9e1 * t699 * t2104 + t1544 * t1545 * t2107 / 0.3e1 + t77 * t2116 - t1290 * t2120 / 0.6e1 - t1983 * t2125 / 0.18e2 - t1290 * t1984 * t2028 * t1316 - t1290 * t2042 / 0.2e1 - t1983 * t2133 / 0.3e1
  t2137 = f.my_piecewise3(t70, 0, t2136)
  t2139 = params.cab * (t1980 + t2137)
  t2147 = t1344 ** 2
  t2154 = t1354 ** 2
  t2169 = f.my_piecewise5(t225, 0, t227, 0, t1970)
  t2217 = -0.11111111111111111111111111111111111111111111111111e-1 * t857 * t257 * t278 * t2154 - 0.22222222222222222222222222222222222222222222222222e-1 * t1707 + 0.17777777777777777777777777777777777777777777777778e-1 * t785 * t257 * t278 * t1354 * t1274 - 0.13333333333333333333333333333333333333333333333333e-1 * t248 * t257 * t1713 * t1354 - 0.66666666666666666666666666666666666666666666666667e-2 * t248 * t257 * t278 * t2169 - t1087 + 0.11111111111111111111111111111111111111111111111111e-1 * t1705 - 0.83333333333333333333333333333333333333333333333334e-2 * t1688 - 0.77777777777777777777777777777777777777777777777777e-2 * t850 * t257 * t278 * t1964 + 0.66666666666666666666666666666666666666666666666666e-2 * t313 * t257 * t1713 * t1274 + 0.33333333333333333333333333333333333333333333333333e-2 * t313 * t257 * t278 * t1974 - 0.25000000000000000000000000000000000000000000000000e-2 * t346 * t291 * t292 * (-t1643 * t1365 * t1272 / 0.3e1 - t1649 + t1364 * t1974 * t367 / 0.3e1 + t1364 * t1964 * t1059 * params.css * t132 * t66 / 0.18e2 + t1642 * t4 * t1964 * t367 / 0.9e1 + 0.2e1 / 0.9e1 * t1052 * t272 * t274 * t1964 - t379 * t272 * t274 * t1974 / 0.3e1)
  t2218 = f.my_piecewise3(t13, 0, t2217)
  t2233 = t462 * t1388 * t1400
  t2236 = t1473 * t1302
  t2241 = t453 * t2007
  t2250 = t453 * t1984
  t2251 = t1417 * t2250
  t2252 = t2052 * t1325
  t2258 = -0.13333333333333333333333333333333333333333333333333e-1 * t1913 * t1380 - 0.13333333333333333333333333333333333333333333333333e-1 * t426 * t434 * t1895 * t1378 + 0.20000000000000000000000000000000000000000000000000e-1 * t473 * t1912 * t1413 + 0.66666666666666666666666666666666666666666666666666e-2 * t479 * t434 * t1895 * t1283 + 0.66666666666666666666666666666666666666666666666666e-2 * t2233 * t1405 + 0.66666666666666666666666666666666666666666666666666e-2 * t1401 * t468 * t2236 * t1404 + 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t468 * t2241 * t1404 - 0.20000000000000000000000000000000000000000000000000e-1 * t1401 * t1417 * t2236 * t1404 + 0.20000000000000000000000000000000000000000000000000e-1 * t1401 * t2251 * t2252 - 0.33333333333333333333333333333333333333333333333334e-1 * t1744 + 0.11111111111111111111111111111111111111111111111111e-1 * t1746
  t2259 = t468 * t2250
  t2292 = t437 * t2045
  t2300 = t1309 * t1991
  t2302 = t2300 * t1315 * t2040
  t2307 = t437 * t1982
  t2329 = t108 * t1984
  t2342 = t1809 * t1284 * t1302 * t1404 / 0.9e1 - t1809 * t2014 / 0.3e1 + t2292 * t1306 * t1313 * t1315 * t1333 / 0.3e1 + t1426 * t2030 / 0.3e1 + t1426 * t1306 * t2302 / 0.6e1 - t2292 * t2023 - t2307 * t2133 / 0.3e1 - t1430 * t2090 / 0.2e1 - t1423 * t2099 / 0.6e1 + 0.2e1 / 0.9e1 * t1801 * t2104 + t1423 * t1321 * t1284 * t1333 / 0.3e1 + t1430 * t2116 + t1435 * t108 * t2007 * t1305 * t1316 / 0.2e1 + t259 * t75 * jnp.pi * t102 * t2329 * t1986 * t1994 - t1435 * t2329 * t2028 * t1316 - t1426 * t2042 / 0.2e1 - t1426 * t2120 / 0.6e1 - t2307 * t2125 / 0.18e2
  t2346 = t1441 ** 2
  t2350 = t74 * t950
  t2352 = t1453 * t2350 * t101
  t2356 = t2057 * t2060
  t2360 = t1469 * t1984
  t2361 = t2057 * t2067
  t2376 = t1453 * t2350 * t1984
  t2377 = t2057 * t1991
  t2378 = t2059 * t101
  t2383 = 0.2e1 / 0.9e1 * t1245 * t448 * t450 * t2102 - 0.2e1 * t1443 * t1444 * t101 * t1333 * t449 - 0.2e1 / 0.3e1 * t495 * t448 * t1463 * t1283 - t495 * t448 * t450 * t2097 / 0.3e1 - t2342 * t489 * t369 * t1447 + t2346 * t1231 * t369 * t1447 - 0.2e1 * t2352 * t107 / t1416 * t1984 * t2356 + 0.2e1 * t2352 * t2360 * t2361 - 0.2e1 / 0.3e1 * t1830 * t1450 - t1453 * t1454 * t2007 * t1460 / 0.3e1 - 0.2e1 / 0.3e1 * t1456 * t1457 * t1458 * t1463 - t2376 * t2377 * t2378 * t450 / 0.3e1
  t2413 = t1442 * t268
  t2445 = t1467 * t1469 * t2007 * t1404 + 0.2e1 * t1467 * t1333 * t1468 * t1302 * t1404 - 0.2e1 * t1467 * t2360 * t2252 + 0.2e1 / 0.3e1 * t1453 * t1454 * t1984 * t2052 * t1312 * t1459 - 0.2e1 / 0.3e1 * t2376 * t2377 * t1993 * t101 * t450 + 0.4e1 / 0.3e1 * t2376 * t2377 * t2378 * t1469 - t447 * t448 * t2088 * t449 + 0.2e1 * t2413 * t446 * jnp.pi * t101 * t1471 + 0.2e1 / 0.3e1 * t1877 * t1468 * t1283 * t1302 * t1404 - t1453 * t1454 * t1445 * t1879 * t2302 - 0.2e1 / 0.3e1 * t2413 * t446 * jnp.pi * t1302 * t1460 - 0.2e1 / 0.9e1 * t1854 * t1316 * t1445 * t1838 + t1453 * t1454 * t1338 * t2300 * t1315 * t1445 * t449 * t2040 / 0.3e1
  t2477 = f.my_piecewise5(t227, 0, t225, 0, t2093)
  t2484 = -0.66666666666666666666666666666666666666666666666666e-2 * t1401 * t2259 * t2252 - 0.20000000000000000000000000000000000000000000000000e-1 * t2233 * t1419 - 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1417 * t2241 * t1404 - 0.25000000000000000000000000000000000000000000000000e-2 * t486 * t467 * t468 * (t2383 + t2445) + 0.53333333333333333333333333333333333333333333333334e-1 * t426 * t1411 * t454 * t1378 * t1333 - 0.26666666666666666666666666666666666666666666666666e-1 * t479 * t1411 * t454 * t2107 + 0.17777777777777777777777777777777777777777777777778e-1 * t1174 * t434 * t454 * t1378 * t1283 + 0.33333333333333333333333333333333333333333333333333e-2 * t479 * t434 * t454 * t2097 + 0.20000000000000000000000000000000000000000000000000e-1 * t1408 * t1411 * t1895 * t1333 + 0.10000000000000000000000000000000000000000000000000e-1 * t1408 * t1411 * t454 * t2088 - 0.66666666666666666666666666666666666666666666666667e-2 * t426 * t434 * t454 * t2477 + 0.66666666666666666666666666666666666666666666666666e-2 * t1917 * t1394
  t2497 = t1378 ** 2
  t2502 = t453 * t1283
  t2513 = t453 * t1378
  t2522 = t1323 * t2041
  t2540 = -0.50000000000000000000000000000000000000000000000000e-1 * t1408 * t430 / t432 / t431 * t454 * t2114 - 0.77777777777777777777777777777777777777777777777777e-2 * t1206 * t434 * t454 * t2102 - 0.11111111111111111111111111111111111111111111111111e-1 * t1164 * t434 * t454 * t2497 - 0.88888888888888888888888888888888888888888888888888e-2 * t1778 * t468 * t2502 * t1339 + 0.80000000000000000000000000000000000000000000000000e-1 * t1401 * t1410 * t1416 * t453 * t1333 * t1339 - 0.53333333333333333333333333333333333333333333333334e-1 * t1784 * t1417 * t2513 * t1339 + 0.26666666666666666666666666666666666666666666666666e-1 * t1778 * t1417 * t2502 * t1339 + 0.10000000000000000000000000000000000000000000000000e-1 * t1401 * t1418 * t2522 - 0.26666666666666666666666666666666666666666666666666e-1 * t1401 * t1410 * t436 * t1402 * t1323 * t2022 - 0.33333333333333333333333333333333333333333333333333e-2 * t1401 * t1403 * t2522 + 0.17777777777777777777777777777777777777777777777778e-1 * t1784 * t468 * t2513 * t1339 - 0.83333333333333333333333333333333333333333333333334e-2 * t1796
  t2547 = t473 * t424 * t201 * t429
  t2577 = -0.83333333333333333333333333333333333333333333333334e-2 * t1892 - t1194 + 0.11111111111111111111111111111111111111111111111111e-1 * t1904 + 0.33333333333333333333333333333333333333333333333334e-1 * t1907 - 0.22222222222222222222222222222222222222222222222222e-1 * t1909 - 0.22222222222222222222222222222222222222222222222222e-2 * t2547 * t2259 * t2356 - 0.30000000000000000000000000000000000000000000000000e-1 * t2547 * t433 * t435 * t2250 * t2356 - 0.20000000000000000000000000000000000000000000000000e-1 * t2547 * t2251 * t2361 + 0.20000000000000000000000000000000000000000000000000e-1 * t2547 * t2251 * t2356 + 0.66666666666666666666666666666666666666666666666666e-2 * t2547 * t2259 * t2361 - 0.25000000000000000000000000000000000000000000000000e-2 * t462 * t237 * (0.80e2 / 0.9e1 * tau1 * t1298 - 0.22e2 / 0.9e1 * s2 * t2003) * t245 * t470 - 0.50000000000000000000000000000000000000000000000000e-2 * t1390 * t1475
  t2580 = f.my_piecewise3(t70, 0, t2258 + t2484 + t2540 + t2577)
  t2581 = -0.20000000000000000000000000000000000000000000000000e0 * (-t508 - t510 - t514) * t2 * t119 - 0.40000000000000000000000000000000000000000000000000e0 * t1485 - 0.40000000000000000000000000000000000000000000000000e0 * t1268 * t1346 - 0.40000000000000000000000000000000000000000000000000e0 * t1268 * t1351 - 0.40000000000000000000000000000000000000000000000000e0 * t1497 - 0.40000000000000000000000000000000000000000000000000e0 * t1566 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t2139 * t118 - 0.40000000000000000000000000000000000000000000000000e0 * t128 * t1345 * t1350 - 0.20000000000000000000000000000000000000000000000000e0 * t128 * t115 * (t725 * t2147 * t729 - t2139 * t218 + t2139) + t2218 + t2580
  d22 = -0.40000000000000000000000000000000000000000000000000e0 * t1269 - t127 - 0.40000000000000000000000000000000000000000000000000e0 * t1347 - 0.40000000000000000000000000000000000000000000000000e0 * t1352 + 0.2e1 * t1377 + 0.2e1 * t1479 + t2 * t2581
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

