"""Generated from mgga_c_cc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_cc(rs, z, xt, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_cc(rs, z, xt, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_cc(rs, z, xt, ts0, ts1)

  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t4 ** 2
  t6 = t3 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t10 = t2 / t7 / t5
  t11 = r0 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t14 = 0.1e1 / t12 / r0
  t15 = tau0 * t14
  t16 = r0 - r1
  t17 = 0.1e1 / t3
  t18 = t16 * t17
  t19 = 0.1e1 + t18
  t20 = t19 / 0.2e1
  t21 = t20 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = t22 * t20
  t25 = r1 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = 0.1e1 / t26 / r1
  t29 = tau1 * t28
  t30 = 0.1e1 - t18
  t31 = t30 / 0.2e1
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t33 * t31
  t37 = 0.8e1 * t15 * t23 + 0.8e1 * t29 * t34
  t38 = 0.1e1 / t37
  t39 = t16 ** 2
  t40 = t38 * t39
  t42 = -t10 * t40 + 0.1e1
  t43 = 3 ** (0.1e1 / 0.3e1)
  t45 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t46 = t43 * t45
  t47 = 4 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t51 = t46 * t48 / t6
  t53 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t51
  t54 = jnp.sqrt(t51)
  t57 = t51 ** 0.15e1
  t59 = t43 ** 2
  t60 = t45 ** 2
  t61 = t59 * t60
  t64 = t61 * t47 / t7
  t66 = 0.23615562999000000000000000000000000000000000000000e0 * t54 + 0.55770497660000000000000000000000000000000000000000e-1 * t51 + 0.12733196185000000000000000000000000000000000000000e-1 * t57 + 0.76629248290000000000000000000000000000000000000000e-2 * t64
  t68 = 0.1e1 + 0.1e1 / t66
  t69 = jnp.log(t68)
  t70 = t53 * t69
  t71 = t39 ** 2
  t72 = 0.1e1 / t5
  t73 = t71 * t72
  t74 = t19 <= f.p.zeta_threshold
  t75 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t76 = t75 * f.p.zeta_threshold
  t77 = t19 ** (0.1e1 / 0.3e1)
  t79 = f.my_piecewise3(t74, t76, t77 * t19)
  t80 = t30 <= f.p.zeta_threshold
  t81 = t30 ** (0.1e1 / 0.3e1)
  t83 = f.my_piecewise3(t80, t76, t81 * t30)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t79 + t83 - 0.2e1) * t88
  t91 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t51
  t96 = 0.21948324211500000000000000000000000000000000000000e0 * t54 + 0.48172707847500000000000000000000000000000000000000e-1 * t51 + 0.13082189292500000000000000000000000000000000000000e-1 * t57 + 0.48592432297500000000000000000000000000000000000000e-2 * t64
  t98 = 0.1e1 + 0.1e1 / t96
  t99 = jnp.log(t98)
  t102 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t51
  t107 = 0.17489762330000000000000000000000000000000000000000e0 * t54 + 0.30591463695000000000000000000000000000000000000000e-1 * t51 + 0.37162156485000000000000000000000000000000000000000e-2 * t57 + 0.41939460495000000000000000000000000000000000000000e-2 * t64
  t109 = 0.1e1 + 0.1e1 / t107
  t110 = jnp.log(t109)
  t111 = t102 * t110
  t113 = -t91 * t99 + t70 - 0.58482236226346462072622386637590534819724553404281e0 * t111
  t114 = t89 * t113
  t118 = -t70 + t73 * t114 + 0.58482236226346462072622386637590534819724553404281e0 * t89 * t111
  t119 = t42 * t118
  t120 = t5 * t3
  t125 = 0.14e2 / 0.3e1 * t2 / t7 / t120 * t40
  t126 = t37 ** 2
  t127 = 0.1e1 / t126
  t128 = t127 * t39
  t129 = r0 ** 2
  t135 = t16 / t4
  t136 = t17 - t135
  t137 = t136 / 0.2e1
  t149 = 0.2e1 * t10 * t38 * t16
  t153 = t3 * t42
  t155 = 0.1e1 / t6 / t3
  t156 = t48 * t155
  t159 = 0.11073470983333333333333333333333333333333333333333e-2 * t46 * t156 * t69
  t160 = t66 ** 2
  t165 = t45 * t48
  t166 = t165 * t155
  t167 = 0.1e1 / t54 * t43 * t166
  t169 = t46 * t156
  t171 = t51 ** 0.5e0
  t173 = t171 * t43 * t166
  t178 = t61 * t47 / t7 / t3
  t183 = t53 / t160 * (-0.39359271665000000000000000000000000000000000000000e-1 * t167 - 0.18590165886666666666666666666666666666666666666667e-1 * t169 - 0.63665980925000000000000000000000000000000000000000e-2 * t173 - 0.51086165526666666666666666666666666666666666666667e-2 * t178) / t68
  t187 = 0.4e1 * t39 * t16 * t72 * t114
  t191 = 0.4e1 * t71 / t120 * t114
  t194 = f.my_piecewise3(t74, 0, 0.4e1 / 0.3e1 * t77 * t136)
  t198 = f.my_piecewise3(t80, 0, -0.4e1 / 0.3e1 * t81 * t136)
  t200 = (t194 + t198) * t88
  t206 = t96 ** 2
  t220 = t107 ** 2
  t221 = 0.1e1 / t220
  t227 = -0.29149603883333333333333333333333333333333333333333e-1 * t167 - 0.10197154565000000000000000000000000000000000000000e-1 * t169 - 0.18581078242500000000000000000000000000000000000000e-2 * t173 - 0.27959640330000000000000000000000000000000000000000e-2 * t178
  t228 = 0.1e1 / t109
  t234 = t73 * t89 * (0.53237641966666666666666666666666666666666666666667e-3 * t46 * t156 * t99 + t91 / t206 * (-0.36580540352500000000000000000000000000000000000000e-1 * t167 - 0.16057569282500000000000000000000000000000000000000e-1 * t169 - 0.65410946462500000000000000000000000000000000000000e-2 * t173 - 0.32394954865000000000000000000000000000000000000000e-2 * t178) / t98 - t159 - t183 + 0.18311447306006545054854346104378990962041954983034e-3 * t46 * t156 * t110 + 0.58482236226346462072622386637590534819724553404281e0 * t102 * t221 * t227 * t228)
  t241 = 0.18311447306006545054854346104378990962041954983034e-3 * t89 * t43 * t165 * t155 * t110
  t246 = 0.58482236226346462072622386637590534819724553404281e0 * t89 * t102 * t221 * t227 * t228
  vrho_0_ = t119 + t3 * (t125 + t10 * t128 * (-0.40e2 / 0.3e1 * tau0 / t12 / t129 * t23 + 0.40e2 / 0.3e1 * t15 * t22 * t137 - 0.40e2 / 0.3e1 * t29 * t33 * t137) - t149) * t118 + t153 * (t159 + t183 + t187 - t191 + t73 * t200 * t113 + t234 + 0.58482236226346462072622386637590534819724553404281e0 * t200 * t111 - t241 - t246)
  t249 = -t17 - t135
  t250 = t249 / 0.2e1
  t253 = r1 ** 2
  t270 = f.my_piecewise3(t74, 0, 0.4e1 / 0.3e1 * t77 * t249)
  t274 = f.my_piecewise3(t80, 0, -0.4e1 / 0.3e1 * t81 * t249)
  t276 = (t270 + t274) * t88
  vrho_1_ = t119 + t3 * (t125 + t10 * t128 * (0.40e2 / 0.3e1 * t15 * t22 * t250 - 0.40e2 / 0.3e1 * tau1 / t26 / t253 * t34 - 0.40e2 / 0.3e1 * t29 * t33 * t250) + t149) * t118 + t153 * (t159 + t183 - t187 - t191 + t73 * t276 * t113 + t234 + 0.58482236226346462072622386637590534819724553404281e0 * t276 * t111 - t241 - t246)
  t285 = 0.1e1 / t7 / t4 / t3
  t288 = t285 * t38 * t39 * t118
  vsigma_0_ = -t288
  vsigma_1_ = -0.2e1 * t288
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t291 = t285 * t2 * t127
  vtau_0_ = 0.8e1 * t291 * t39 * t14 * t23 * t118
  vtau_1_ = 0.8e1 * t291 * t39 * t28 * t34 * t118
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_cc(rs, z, xt, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t56 = 0.1e1 / t7 / r0
  t57 = t6 * t56
  t61 = t26 ** 2
  t66 = t3 * t6
  t67 = t66 * t56
  t68 = 0.1e1 / t13 * t1 * t67
  t70 = t4 * t57
  t72 = t10 ** 0.5e0
  t74 = t72 * t1 * t67
  t79 = t20 * t5 / t21 / r0
  t91 = t48 ** 2
  vrho_0_ = -t12 * t29 + 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51 + r0 * (0.11073470983333333333333333333333333333333333333333e-2 * t4 * t57 * t29 + t12 / t61 * (-0.39359271665000000000000000000000000000000000000000e-1 * t68 - 0.18590165886666666666666666666666666666666666666667e-1 * t70 - 0.63665980925000000000000000000000000000000000000000e-2 * t74 - 0.51086165526666666666666666666666666666666666666667e-2 * t79) / t28 - 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t66 * t56 * t51 - 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t91 * (-0.29149603883333333333333333333333333333333333333333e-1 * t68 - 0.10197154565000000000000000000000000000000000000000e-1 * t70 - 0.18581078242500000000000000000000000000000000000000e-2 * t74 - 0.27959640330000000000000000000000000000000000000000e-2 * t79) / t50)
  vsigma_0_ = 0.0e0
  vlapl_0_ = 0.0e0
  vtau_0_ = 0.0e0
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t89 = t72 * (0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13)
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t102 = r0 ** 2
  t104 = 0.1e1 / t7 / t102
  t105 = t6 * t104
  t117 = t57 ** 2
  t126 = 0.1e1 / t22 / t102
  t127 = t20 * t5 * t126
  t128 = 0.1e1 / t14 / t13 * t19 * t127
  t130 = t42 * t104
  t131 = t41 * t130
  t133 = t4 * t105
  t135 = t13 ** (-0.5e0)
  t137 = t135 * t19 * t127
  t139 = t49 * t130
  t142 = t21 * t5 * t126
  t148 = t37 ** 2
  t151 = t30 ** 2
  t166 = t96 ** 2
  t182 = t90 ** 2
  t185 = t81 ** 2
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t4 * t10 * t31 + 0.20000000000000000000000000000000000000000000000000e1 * t39 * t59 - 0.36622894612013090109708692208757981924083909966068e-3 * t73 * t42 * t9 * t82 - 0.11696447245269292414524477327518106963944910680856e1 * t89 * t99 + r0 * (-0.14764627977777777777777777777777777777777777777777e-2 * t4 * t105 * t31 - 0.35616666666666666666666666666666666666666666666666e-1 * t4 * t6 * t9 * t38 * t59 - 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t117 * t58 + 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t128 + 0.84396666666666666666666666666666666666666666666666e0 * t131 + 0.39862222222222222222222222222222222222222222222223e0 * t133 + 0.68258333333333333333333333333333333333333333333333e-1 * t137 + 0.13651666666666666666666666666666666666666666666667e0 * t139 + 0.13692777777777777777777777777777777777777777777778e0 * t142) * t58 + 0.16081979498692535066756296899072713062105388428051e2 * t36 / t148 * t117 / t151 + 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t104 * t82 + 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99 + 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t166 * t98 - 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t128 + 0.11507777777777777777777777777777777777777777777778e1 * t131 + 0.40256666666666666666666666666666666666666666666667e0 * t133 + 0.36677500000000000000000000000000000000000000000000e-1 * t137 + 0.73355000000000000000000000000000000000000000000000e-1 * t139 + 0.13797500000000000000000000000000000000000000000000e0 * t142) * t98 - 0.17315859105681463759666483083807725165579399831905e2 * t89 / t182 * t166 / t185)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t36 = t4 * t6
  t38 = 0.1e1 / t8 / r0
  t39 = t28 ** 2
  t40 = 0.1e1 / t39
  t41 = t38 * t40
  t43 = 0.1e1 / t15 * t1
  t44 = t3 * t6
  t45 = t44 * t38
  t46 = t43 * t45
  t48 = t6 * t38
  t49 = t4 * t48
  t51 = t14 ** 0.5e0
  t52 = t51 * t1
  t53 = t52 * t45
  t58 = t22 * t5 / t23 / r0
  t60 = -0.63297500000000000000000000000000000000000000000000e0 * t46 - 0.29896666666666666666666666666666666666666666666667e0 * t49 - 0.10238750000000000000000000000000000000000000000000e0 * t53 - 0.82156666666666666666666666666666666666666666666667e-1 * t58
  t61 = 0.1e1 / t31
  t62 = t60 * t61
  t67 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t69 = 0.1e1 / t39 / t28
  t70 = t67 * t69
  t71 = t60 ** 2
  t72 = t71 * t61
  t75 = t67 * t40
  t78 = 0.1e1 / t15 / t14 * t20
  t79 = t21 * t5
  t81 = 0.1e1 / t23 / t7
  t82 = t79 * t81
  t83 = t78 * t82
  t85 = t44 * t10
  t86 = t43 * t85
  t88 = t4 * t11
  t90 = t14 ** (-0.5e0)
  t91 = t90 * t20
  t92 = t91 * t82
  t94 = t52 * t85
  t97 = t22 * t5 * t81
  t99 = -0.42198333333333333333333333333333333333333333333333e0 * t83 + 0.84396666666666666666666666666666666666666666666666e0 * t86 + 0.39862222222222222222222222222222222222222222222223e0 * t88 + 0.68258333333333333333333333333333333333333333333333e-1 * t92 + 0.13651666666666666666666666666666666666666666666667e0 * t94 + 0.13692777777777777777777777777777777777777777777778e0 * t97
  t100 = t99 * t61
  t103 = t39 ** 2
  t104 = 0.1e1 / t103
  t105 = t67 * t104
  t106 = t31 ** 2
  t107 = 0.1e1 / t106
  t108 = t71 * t107
  t112 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t114 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t112 * f.p.zeta_threshold, 1)
  t117 = 2 ** (0.1e1 / 0.3e1)
  t121 = (0.2e1 * t114 - 0.2e1) / (0.2e1 * t117 - 0.2e1)
  t122 = t121 * t1
  t127 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t130 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t127
  t131 = jnp.log(t130)
  t136 = t121 * t4
  t137 = t127 ** 2
  t138 = 0.1e1 / t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t46 - 0.30192500000000000000000000000000000000000000000000e0 * t49 - 0.55016250000000000000000000000000000000000000000000e-1 * t53 - 0.82785000000000000000000000000000000000000000000000e-1 * t58
  t145 = 0.1e1 / t130
  t146 = t138 * t143 * t145
  t152 = t121 * (0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14)
  t154 = 0.1e1 / t137 / t127
  t155 = t143 ** 2
  t157 = t154 * t155 * t145
  t166 = -0.57538888888888888888888888888888888888888888888889e0 * t83 + 0.11507777777777777777777777777777777777777777777778e1 * t86 + 0.40256666666666666666666666666666666666666666666667e0 * t88 + 0.36677500000000000000000000000000000000000000000000e-1 * t92 + 0.73355000000000000000000000000000000000000000000000e-1 * t94 + 0.13797500000000000000000000000000000000000000000000e0 * t97
  t168 = t138 * t166 * t145
  t171 = t137 ** 2
  t172 = 0.1e1 / t171
  t174 = t130 ** 2
  t175 = 0.1e1 / t174
  t176 = t172 * t155 * t175
  t185 = t71 * t60
  t209 = t155 * t143
  t226 = 0.48159733137676571081572406076840235616767705782485e0 * t136 * t48 * t176 + 0.51726012919273400298984252201052768390886626637712e3 * t67 / t103 / t39 * t185 / t106 / t31 - 0.32530743900905219527896202567159734993471782831130e-1 * t136 * t48 * t157 + 0.48245938496077605200268890697218139186316165284153e2 * t105 * t99 * t107 * t60 + 0.60000000000000000000000000000000000000000000000000e1 * t105 * t185 * t61 - 0.60000000000000000000000000000000000000000000000000e1 * t70 * t62 * t99 - 0.51947577317044391278999449251423175496738199495715e2 * t152 * t172 * t166 * t175 * t143 - 0.35089341735807877243573431982554320891834732042568e1 * t152 * t172 * t209 * t145 + 0.35089341735807877243573431982554320891834732042568e1 * t152 * t154 * t143 * t145 * t166 + 0.71233333333333333333333333333333333333333333333331e-1 * t36 * t10 * t40 * t62 - 0.53424999999999999999999999999999999999999999999999e-1 * t36 * t41 * t100
  t247 = t7 ** 2
  t248 = 0.1e1 / t247
  t249 = 0.1e1 / t15 / t26 * t2 * t248 / 0.4e1
  t251 = t7 * r0
  t253 = 0.1e1 / t23 / t251
  t254 = t79 * t253
  t255 = t78 * t254
  t258 = 0.1e1 / t8 / t251
  t259 = t44 * t258
  t260 = t43 * t259
  t262 = t6 * t258
  t263 = t4 * t262
  t265 = t14 ** (-0.15e1)
  t267 = t265 * t2 * t248
  t269 = t91 * t254
  t271 = t52 * t259
  t274 = t22 * t5 * t253
  t318 = -0.85917975471764868594145516183295969534298037676861e0 * t36 * t38 * t104 * t108 - 0.21687162600603479685264135044773156662314521887420e-1 * t136 * t11 * t146 + 0.16265371950452609763948101283579867496735891415565e-1 * t136 * t48 * t168 - 0.96491876992155210400537781394436278372632330568306e2 * t67 / t103 / t28 * t185 * t107 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * (-0.25319000000000000000000000000000000000000000000000e1 * t249 + 0.16879333333333333333333333333333333333333333333333e1 * t255 - 0.19692555555555555555555555555555555555555555555555e1 * t260 - 0.93011851851851851851851851851851851851851851851854e0 * t263 + 0.13651666666666666666666666666666666666666666666667e0 * t267 - 0.27303333333333333333333333333333333333333333333333e0 * t269 - 0.31853888888888888888888888888888888888888888888890e0 * t271 - 0.36514074074074074074074074074074074074074074074075e0 * t274) * t61 + 0.10685000000000000000000000000000000000000000000000e0 * t36 * t38 * t69 * t72 - 0.56968947174242584615102410102512416326352748836105e-3 * t122 * t44 * t258 * t131 + 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t262 * t32 + 0.10389515463408878255799889850284635099347639899143e3 * t152 / t171 / t127 * t209 * t175 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t138 * (-0.34523333333333333333333333333333333333333333333333e1 * t249 + 0.23015555555555555555555555555555555555555555555556e1 * t255 - 0.26851481481481481481481481481481481481481481481482e1 * t260 - 0.93932222222222222222222222222222222222222222222223e0 * t263 + 0.73355000000000000000000000000000000000000000000000e-1 * t267 - 0.14671000000000000000000000000000000000000000000000e0 * t269 - 0.17116166666666666666666666666666666666666666666667e0 * t271 - 0.36793333333333333333333333333333333333333333333333e0 * t274) * t145 - 0.10254018858216406658218194626490193680059335835414e4 * t152 / t171 / t137 * t209 / t174 / t130
  v3rho3_0_ = -0.44293883933333333333333333333333333333333333333332e-2 * t4 * t11 * t32 - 0.10685000000000000000000000000000000000000000000000e0 * t36 * t41 * t62 - 0.60000000000000000000000000000000000000000000000000e1 * t70 * t72 + 0.30000000000000000000000000000000000000000000000000e1 * t75 * t100 + 0.48245938496077605200268890697218139186316165284153e2 * t105 * t108 + 0.73245789224026180219417384417515963848167819932136e-3 * t122 * t44 * t10 * t131 + 0.32530743900905219527896202567159734993471782831130e-1 * t136 * t48 * t146 + 0.35089341735807877243573431982554320891834732042568e1 * t152 * t157 - 0.17544670867903938621786715991277160445917366021284e1 * t152 * t168 - 0.51947577317044391278999449251423175496738199495715e2 * t152 * t176 + r0 * (t226 + t318)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t12 = 3 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / jnp.pi
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t12 * t14
  t16 = 4 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = r0 ** (0.1e1 / 0.3e1)
  t21 = t15 * t17 / t18
  t24 = t11 * (0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t21)
  t25 = jnp.sqrt(t21)
  t28 = t21 ** 0.15e1
  t30 = t12 ** 2
  t31 = t14 ** 2
  t32 = t30 * t31
  t33 = t18 ** 2
  t36 = t32 * t16 / t33
  t38 = 0.51785000000000000000000000000000000000000000000000e1 * t25 + 0.90577500000000000000000000000000000000000000000000e0 * t21 + 0.11003250000000000000000000000000000000000000000000e0 * t28 + 0.12417750000000000000000000000000000000000000000000e0 * t36
  t39 = t38 ** 2
  t40 = t39 ** 2
  t41 = 0.1e1 / t40
  t44 = 0.1e1 / t25 / t21 * t30
  t45 = t31 * t16
  t46 = r0 ** 2
  t48 = 0.1e1 / t33 / t46
  t49 = t45 * t48
  t50 = t44 * t49
  t53 = 0.1e1 / t25 * t12
  t54 = t14 * t17
  t56 = 0.1e1 / t18 / t46
  t57 = t54 * t56
  t58 = t53 * t57
  t60 = t17 * t56
  t61 = t15 * t60
  t63 = t21 ** (-0.5e0)
  t64 = t63 * t30
  t65 = t64 * t49
  t67 = t21 ** 0.5e0
  t68 = t67 * t12
  t69 = t68 * t57
  t72 = t32 * t16 * t48
  t74 = -0.57538888888888888888888888888888888888888888888889e0 * t50 + 0.11507777777777777777777777777777777777777777777778e1 * t58 + 0.40256666666666666666666666666666666666666666666667e0 * t61 + 0.36677500000000000000000000000000000000000000000000e-1 * t65 + 0.73355000000000000000000000000000000000000000000000e-1 * t69 + 0.13797500000000000000000000000000000000000000000000e0 * t72
  t75 = t74 ** 2
  t79 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t38
  t80 = t79 ** 2
  t81 = 0.1e1 / t80
  t85 = t40 ** 2
  t88 = 0.1e1 / t18 / r0
  t89 = t54 * t88
  t90 = t53 * t89
  t92 = t17 * t88
  t93 = t15 * t92
  t95 = t68 * t89
  t100 = t32 * t16 / t33 / r0
  t102 = -0.86308333333333333333333333333333333333333333333334e0 * t90 - 0.30192500000000000000000000000000000000000000000000e0 * t93 - 0.55016250000000000000000000000000000000000000000000e-1 * t95 - 0.82785000000000000000000000000000000000000000000000e-1 * t100
  t103 = t102 ** 2
  t104 = t103 ** 2
  t106 = t80 ** 2
  t111 = 0.1e1 / t39
  t118 = t46 ** 2
  t119 = t118 * r0
  t121 = 0.1e1 / t18 / t119
  t123 = t15 * t17
  t124 = 0.1e1 / t25 * r0 * t121 * t123 / 0.48e2
  t129 = 0.1e1 / t25 / t36 * t13 / 0.4e1
  t130 = 0.1e1 / t119
  t131 = t129 * t130
  t134 = 0.1e1 / t33 / t118
  t135 = t45 * t134
  t136 = t44 * t135
  t139 = 0.1e1 / t18 / t118
  t140 = t54 * t139
  t141 = t53 * t140
  t143 = t17 * t139
  t144 = t15 * t143
  t146 = t21 ** (-0.25e1)
  t149 = t146 * t13 * t121 * t123
  t151 = t21 ** (-0.15e1)
  t152 = t151 * t13
  t153 = t152 * t130
  t155 = t64 * t135
  t157 = t68 * t140
  t160 = t32 * t16 * t134
  t164 = 0.1e1 / t79
  t168 = t39 * t38
  t173 = 0.1e1 / t80 / t79
  t178 = 0.1e1 / t40 / t39
  t184 = 0.1e1 / t40 / t38
  t189 = 0.1e1 / t168
  t195 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t21
  t200 = 0.37978500000000000000000000000000000000000000000000e1 * t25 + 0.89690000000000000000000000000000000000000000000000e0 * t21 + 0.20477500000000000000000000000000000000000000000000e0 * t28 + 0.12323500000000000000000000000000000000000000000000e0 * t36
  t201 = t200 ** 2
  t202 = t201 * t200
  t203 = 0.1e1 / t202
  t204 = t195 * t203
  t209 = -0.63297500000000000000000000000000000000000000000000e0 * t90 - 0.29896666666666666666666666666666666666666666666667e0 * t93 - 0.10238750000000000000000000000000000000000000000000e0 * t95 - 0.82156666666666666666666666666666666666666666666667e-1 * t100
  t212 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t200
  t213 = 0.1e1 / t212
  t214 = t209 * t213
  t215 = 0.1e1 / t118
  t216 = t129 * t215
  t218 = t46 * r0
  t220 = 0.1e1 / t33 / t218
  t221 = t45 * t220
  t222 = t44 * t221
  t225 = 0.1e1 / t18 / t218
  t226 = t54 * t225
  t227 = t53 * t226
  t229 = t17 * t225
  t230 = t15 * t229
  t232 = t152 * t215
  t234 = t64 * t221
  t236 = t68 * t226
  t239 = t32 * t16 * t220
  t241 = -0.25319000000000000000000000000000000000000000000000e1 * t216 + 0.16879333333333333333333333333333333333333333333333e1 * t222 - 0.19692555555555555555555555555555555555555555555555e1 * t227 - 0.93011851851851851851851851851851851851851851851854e0 * t230 + 0.13651666666666666666666666666666666666666666666667e0 * t232 - 0.27303333333333333333333333333333333333333333333333e0 * t234 - 0.31853888888888888888888888888888888888888888888890e0 * t236 - 0.36514074074074074074074074074074074074074074074075e0 * t239
  t245 = t201 ** 2
  t247 = 0.1e1 / t245 / t200
  t248 = t195 * t247
  t255 = -0.42198333333333333333333333333333333333333333333333e0 * t50 + 0.84396666666666666666666666666666666666666666666666e0 * t58 + 0.39862222222222222222222222222222222222222222222223e0 * t61 + 0.68258333333333333333333333333333333333333333333333e-1 * t65 + 0.13651666666666666666666666666666666666666666666667e0 * t69 + 0.13692777777777777777777777777777777777777777777778e0 * t72
  t256 = t212 ** 2
  t257 = 0.1e1 / t256
  t258 = t255 * t257
  t259 = t209 ** 2
  t263 = 0.1e1 / t245
  t264 = t195 * t263
  t270 = 0.1e1 / t245 / t201
  t271 = t195 * t270
  t273 = 0.1e1 / t256 / t212
  t278 = -0.51947577317044391278999449251423175496738199495715e2 * t24 * t41 * t75 * t81 - 0.91082604192152556048340974007871726131433263376469e5 * t24 / t85 * t104 / t106 - 0.58482236226346462072622386637590534819724553404280e0 * t24 * t111 * (-0.28769444444444444444444444444444444444444444444444e1 * t124 + 0.27618666666666666666666666666666666666666666666667e2 * t131 - 0.10229135802469135802469135802469135802469135802469e2 * t136 + 0.89504938271604938271604938271604938271604938271607e1 * t141 + 0.31310740740740740740740740740740740740740740740741e1 * t144 + 0.36677500000000000000000000000000000000000000000000e-1 * t149 - 0.58684000000000000000000000000000000000000000000000e0 * t153 + 0.65204444444444444444444444444444444444444444444445e0 * t155 + 0.57053888888888888888888888888888888888888888888890e0 * t157 + 0.13490888888888888888888888888888888888888888888889e1 * t160) * t164 + 0.12304822629859687989861833551788232416071203002497e5 * t24 / t40 / t168 * t104 * t173 - 0.62337092780453269534799339101707810596085839394858e3 * t24 * t178 * t104 * t81 + 0.14035736694323150897429372793021728356733892817027e2 * t24 * t184 * t104 * t164 + 0.35089341735807877243573431982554320891834732042568e1 * t24 * t189 * t75 * t164 - 0.80000000000000000000000000000000000000000000000000e1 * t204 * t214 * t241 - 0.57895126195293126240322668836661767023579398340984e3 * t248 * t258 * t259 + 0.64327917994770140267025187596290852248421553712204e2 * t264 * t241 * t257 * t209 + 0.31035607751564040179390551320631661034531975982628e4 * t271 * t259 * t273 * t255
  t279 = jnp.log(t212)
  t283 = t259 * t213
  t293 = t213 * t255
  t297 = t259 ** 2
  t301 = t245 ** 2
  t304 = t256 ** 2
  t309 = t255 ** 2
  t325 = 0.1e1 / t201
  t326 = t195 * t325
  t342 = t259 * t209
  t343 = t342 * t273
  t347 = -0.11483599538271604938271604938271604938271604938271e-1 * t15 * t143 * t279 + 0.36000000000000000000000000000000000000000000000000e2 * t264 * t283 * t255 - 0.34367190188705947437658206473318387813719215070744e1 * t93 * t263 * t255 * t257 * t209 + 0.42740000000000000000000000000000000000000000000000e0 * t93 * t203 * t209 * t293 + 0.57895126195293126240322668836661767023579398340984e3 * t271 * t297 * t257 + 0.24955700379505800914252936827276051226357058527653e5 * t195 / t301 * t297 / t304 - 0.60000000000000000000000000000000000000000000000000e1 * t204 * t309 * t213 - 0.62071215503128080358781102641263322069063951965254e4 * t195 / t245 / t202 * t297 * t273 + 0.48245938496077605200268890697218139186316165284153e2 * t264 * t309 * t257 - 0.24000000000000000000000000000000000000000000000000e2 * t248 * t297 * t213 + 0.10000000000000000000000000000000000000000000000000e1 * t326 * (-0.21099166666666666666666666666666666666666666666667e1 * t124 + 0.20255200000000000000000000000000000000000000000000e2 * t131 - 0.75019259259259259259259259259259259259259259259258e1 * t136 + 0.65641851851851851851851851851851851851851851851850e1 * t141 + 0.31003950617283950617283950617283950617283950617285e1 * t144 + 0.68258333333333333333333333333333333333333333333335e-1 * t149 - 0.10921333333333333333333333333333333333333333333333e1 * t153 + 0.12134814814814814814814814814814814814814814814815e1 * t155 + 0.10617962962962962962962962962962962962962962962963e1 * t157 + 0.13388493827160493827160493827160493827160493827161e1 * t160) * t213 - 0.36846163202829085479643115651216588683774907041596e2 * t123 * t88 * t270 * t343
  t363 = t342 * t257
  t367 = t11 * t12
  t368 = jnp.log(t79)
  t373 = t56 * t325
  t378 = t259 * t257
  t382 = t88 * t325
  t383 = t241 * t213
  t392 = t41 * t103
  t393 = t164 * t74
  t397 = t189 * t102
  t406 = -0.34523333333333333333333333333333333333333333333333e1 * t216 + 0.23015555555555555555555555555555555555555555555556e1 * t222 - 0.26851481481481481481481481481481481481481481481482e1 * t227 - 0.93932222222222222222222222222222222222222222222223e0 * t230 + 0.73355000000000000000000000000000000000000000000000e-1 * t232 - 0.14671000000000000000000000000000000000000000000000e0 * t234 - 0.17116166666666666666666666666666666666666666666667e0 * t236 - 0.36793333333333333333333333333333333333333333333333e0 * t239
  t411 = 0.62337092780453269534799339101707810596085839394858e3 * t24 * t184 * t74 * t81 * t103 - 0.22161481481481481481481481481481481481481481481481e0 * t123 * t225 * t325 * t214 - 0.28493333333333333333333333333333333333333333333333e0 * t123 * t56 * t203 * t283 + 0.68734380377411894875316412946636775627438430141488e1 * t123 * t88 * t247 * t363 + 0.18989649058080861538367470034170805442117582945368e-2 * t367 * t54 * t139 * t368 + 0.14246666666666666666666666666666666666666666666666e0 * t123 * t373 * t293 + 0.22911460125803964958438804315545591875812810047162e1 * t123 * t56 * t263 * t378 - 0.71233333333333333333333333333333333333333333333332e-1 * t123 * t382 * t383 - 0.61524113149298439949309167758941162080356015012483e4 * t24 * t178 * t74 * t173 * t103 - 0.21053605041484726346144059189532592535100839225540e2 * t24 * t392 * t393 + 0.46785788981077169658097909310072427855779642723424e1 * t24 * t397 * t164 * t406
  t413 = t81 * t102
  t417 = t88 * t263
  t418 = t342 * t213
  t422 = t11 * t15
  t424 = t111 * t102 * t164
  t428 = t392 * t81
  t432 = t103 * t102
  t434 = t184 * t432 * t81
  t439 = t189 * t103 * t164
  t444 = t41 * t432 * t164
  t449 = t111 * t74 * t164
  t454 = t111 * t406 * t164
  t459 = t178 * t432 * t173
  t463 = t11 * t123
  t475 = -0.69263436422725855038665932335230900662317599327620e2 * t24 * t41 * t406 * t413 - 0.42740000000000000000000000000000000000000000000000e0 * t123 * t417 * t418 + 0.67471172535210825687488420139294265171645179205307e-1 * t422 * t229 * t424 - 0.12842595503380418955085974953824062831138054875329e1 * t422 * t60 * t428 - 0.38527786510141256865257924861472188493414164625988e1 * t422 * t92 * t434 + 0.86748650402413918741056540179092626649258087549680e-1 * t422 * t60 * t439 + 0.13012297560362087811158481026863893997388713132452e0 * t422 * t92 * t444 - 0.43374325201206959370528270089546313324629043774840e-1 * t422 * t60 * t449 + 0.21687162600603479685264135044773156662314521887420e-1 * t422 * t92 * t454 + 0.38025319932552508024225805073234468230220037056326e2 * t422 * t92 * t459 + 0.19263893255070628432628962430736094246707082312994e1 * t463 * t88 * t41 * t413 * t74 - 0.13012297560362087811158481026863893997388713132452e0 * t463 * t88 * t189 * t102 * t164 * t74
  t505 = r0 * (t278 + t347 + t411 + t475) + 0.13780319445925925925925925925925925925925925925925e-1 * t15 * t229 * t279 - 0.24000000000000000000000000000000000000000000000000e2 * t204 * t214 * t255 - 0.38596750796862084160215112557774511349052932227323e3 * t248 * t363 + 0.40000000000000000000000000000000000000000000000000e1 * t326 * t383 + 0.24000000000000000000000000000000000000000000000000e2 * t264 * t418 + 0.19263893255070628432628962430736094246707082312994e1 * t422 * t92 * t428 - 0.13012297560362087811158481026863893997388713132452e0 * t422 * t92 * t439 - 0.86748650402413918741056540179092626649258087549680e-1 * t422 * t60 * t424 + 0.65061487801810439055792405134319469986943565662260e-1 * t422 * t92 * t449 + 0.20690405167709360119593700880421107356354650655085e4 * t271 * t343
  t541 = 0.19298375398431042080107556278887255674526466113661e3 * t264 * t258 * t209 - 0.20779030926817756511599779700569270198695279798286e3 * t24 * t41 * t74 * t413 + 0.14035736694323150897429372793021728356733892817027e2 * t24 * t397 * t393 + 0.28493333333333333333333333333333333333333333333333e0 * t123 * t373 * t214 - 0.21370000000000000000000000000000000000000000000000e0 * t123 * t382 * t293 - 0.34367190188705947437658206473318387813719215070744e1 * t123 * t417 * t378 + 0.42740000000000000000000000000000000000000000000000e0 * t123 * t88 * t203 * t283 - 0.22787578869697033846040964041004966530541099534442e-2 * t367 * t54 * t225 * t368 - 0.41016075432865626632872778505960774720237343341655e4 * t24 * t459 - 0.14035736694323150897429372793021728356733892817027e2 * t24 * t444 + 0.41558061853635513023199559401138540397390559596572e3 * t24 * t434 - 0.23392894490538584829048954655036213927889821361712e1 * t24 * t454
  v4rho4_0_ = t505 + t541

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t4 ** 2
  t6 = t5 * t3
  t7 = t3 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t11 = t2 / t8 / t6
  t12 = r0 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t16 = tau0 / t13 / r0
  t17 = r0 - r1
  t18 = 0.1e1 / t3
  t19 = t17 * t18
  t20 = 0.1e1 + t19
  t21 = t20 / 0.2e1
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * t21
  t26 = r1 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t30 = tau1 / t27 / r1
  t31 = 0.1e1 - t19
  t32 = t31 / 0.2e1
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = t34 * t32
  t37 = t16 * t24 + t30 * t35
  t38 = 0.1e1 / t37
  t39 = t17 ** 2
  t40 = t38 * t39
  t42 = 0.7e1 / 0.12e2 * t11 * t40
  t45 = t2 / t8 / t5
  t46 = t37 ** 2
  t47 = 0.1e1 / t46
  t48 = t47 * t39
  t49 = r0 ** 2
  t52 = tau0 / t13 / t49
  t54 = 0.1e1 / t4
  t55 = t17 * t54
  t56 = t18 - t55
  t57 = t56 / 0.2e1
  t58 = t23 * t57
  t60 = -t57
  t61 = t34 * t60
  t64 = 0.5e1 / 0.3e1 * t16 * t58 - 0.5e1 / 0.3e1 * t52 * t24 + 0.5e1 / 0.3e1 * t30 * t61
  t65 = t48 * t64
  t68 = t38 * t17
  t70 = t45 * t68 / 0.4e1
  t71 = t42 + t45 * t65 / 0.8e1 - t70
  t72 = 3 ** (0.1e1 / 0.3e1)
  t74 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t75 = t72 * t74
  t76 = 4 ** (0.1e1 / 0.3e1)
  t77 = t76 ** 2
  t80 = t75 * t77 / t7
  t82 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t80
  t83 = jnp.sqrt(t80)
  t86 = t80 ** 0.15e1
  t88 = t72 ** 2
  t89 = t74 ** 2
  t90 = t88 * t89
  t93 = t90 * t76 / t8
  t95 = 0.37978500000000000000000000000000000000000000000000e1 * t83 + 0.89690000000000000000000000000000000000000000000000e0 * t80 + 0.20477500000000000000000000000000000000000000000000e0 * t86 + 0.12323500000000000000000000000000000000000000000000e0 * t93
  t98 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t95
  t99 = jnp.log(t98)
  t101 = 0.621814e-1 * t82 * t99
  t102 = t39 ** 2
  t103 = 0.1e1 / t5
  t104 = t102 * t103
  t105 = t20 <= f.p.zeta_threshold
  t106 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t107 = t106 * f.p.zeta_threshold
  t108 = t20 ** (0.1e1 / 0.3e1)
  t110 = f.my_piecewise3(t105, t107, t108 * t20)
  t111 = t31 <= f.p.zeta_threshold
  t112 = t31 ** (0.1e1 / 0.3e1)
  t114 = f.my_piecewise3(t111, t107, t112 * t31)
  t116 = 2 ** (0.1e1 / 0.3e1)
  t119 = 0.1e1 / (0.2e1 * t116 - 0.2e1)
  t120 = (t110 + t114 - 0.2e1) * t119
  t122 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t80
  t127 = 0.70594500000000000000000000000000000000000000000000e1 * t83 + 0.15494250000000000000000000000000000000000000000000e1 * t80 + 0.42077500000000000000000000000000000000000000000000e0 * t86 + 0.15629250000000000000000000000000000000000000000000e0 * t93
  t130 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t127
  t131 = jnp.log(t130)
  t135 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t80
  t140 = 0.51785000000000000000000000000000000000000000000000e1 * t83 + 0.90577500000000000000000000000000000000000000000000e0 * t80 + 0.11003250000000000000000000000000000000000000000000e0 * t86 + 0.12417750000000000000000000000000000000000000000000e0 * t93
  t143 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t140
  t144 = jnp.log(t143)
  t145 = t135 * t144
  t147 = -0.3109070e-1 * t122 * t131 + t101 - 0.19751673498613801407483339618206552048944131217655e-1 * t145
  t148 = t120 * t147
  t152 = -t101 + t104 * t148 + 0.19751673498613801407483339618206552048944131217655e-1 * t120 * t145
  t153 = t71 * t152
  t157 = 0.1e1 - t45 * t40 / 0.8e1
  t159 = 0.1e1 / t7 / t3
  t160 = t77 * t159
  t163 = 0.11073470983333333333333333333333333333333333333333e-2 * t75 * t160 * t99
  t164 = t95 ** 2
  t165 = 0.1e1 / t164
  t166 = t82 * t165
  t168 = 0.1e1 / t83 * t72
  t169 = t74 * t77
  t170 = t169 * t159
  t171 = t168 * t170
  t173 = t75 * t160
  t175 = t80 ** 0.5e0
  t176 = t175 * t72
  t177 = t176 * t170
  t182 = t90 * t76 / t8 / t3
  t184 = -0.63297500000000000000000000000000000000000000000000e0 * t171 - 0.29896666666666666666666666666666666666666666666667e0 * t173 - 0.10238750000000000000000000000000000000000000000000e0 * t177 - 0.82156666666666666666666666666666666666666666666667e-1 * t182
  t185 = 0.1e1 / t98
  t186 = t184 * t185
  t188 = 0.10000000000000000000000000000000000000000000000000e1 * t166 * t186
  t189 = t39 * t17
  t190 = t189 * t103
  t192 = 0.4e1 * t190 * t148
  t193 = 0.1e1 / t6
  t194 = t102 * t193
  t196 = 0.4e1 * t194 * t148
  t199 = f.my_piecewise3(t105, 0, 0.4e1 / 0.3e1 * t108 * t56)
  t200 = -t56
  t203 = f.my_piecewise3(t111, 0, 0.4e1 / 0.3e1 * t112 * t200)
  t205 = (t199 + t203) * t119
  t206 = t205 * t147
  t211 = t127 ** 2
  t212 = 0.1e1 / t211
  t213 = t122 * t212
  t218 = -0.11765750000000000000000000000000000000000000000000e1 * t171 - 0.51647500000000000000000000000000000000000000000000e0 * t173 - 0.21038750000000000000000000000000000000000000000000e0 * t177 - 0.10419500000000000000000000000000000000000000000000e0 * t182
  t219 = 0.1e1 / t130
  t220 = t218 * t219
  t226 = t140 ** 2
  t227 = 0.1e1 / t226
  t228 = t135 * t227
  t233 = -0.86308333333333333333333333333333333333333333333334e0 * t171 - 0.30192500000000000000000000000000000000000000000000e0 * t173 - 0.55016250000000000000000000000000000000000000000000e-1 * t177 - 0.82785000000000000000000000000000000000000000000000e-1 * t182
  t234 = 0.1e1 / t143
  t235 = t233 * t234
  t238 = 0.53237641966666666666666666666666666666666666666666e-3 * t75 * t160 * t131 + 0.10000000000000000000000000000000000000000000000000e1 * t213 * t220 - t163 - t188 + 0.18311447306006545054854346104378990962041954983034e-3 * t75 * t160 * t144 + 0.58482236226346462072622386637590534819724553404280e0 * t228 * t235
  t239 = t120 * t238
  t240 = t104 * t239
  t243 = t120 * t72
  t245 = t169 * t159 * t144
  t247 = 0.18311447306006545054854346104378990962041954983034e-3 * t243 * t245
  t248 = t120 * t135
  t250 = t227 * t233 * t234
  t252 = 0.58482236226346462072622386637590534819724553404280e0 * t248 * t250
  t253 = t163 + t188 + t192 - t196 + t104 * t206 + t240 + 0.19751673498613801407483339618206552048944131217655e-1 * t205 * t145 - t247 - t252
  t254 = t157 * t253
  t256 = t5 * t4
  t261 = 0.119e3 / 0.36e2 * t2 / t8 / t256 * t40
  t262 = t11 * t65
  t265 = 0.7e1 / 0.3e1 * t11 * t68
  t267 = 0.1e1 / t46 / t37
  t268 = t267 * t39
  t269 = t64 ** 2
  t273 = t47 * t17
  t275 = t45 * t273 * t64
  t285 = 0.1e1 / t22
  t286 = t57 ** 2
  t291 = 0.1e1 / t4 / t3
  t292 = t17 * t291
  t293 = -t54 + t292
  t297 = 0.1e1 / t33
  t298 = t60 ** 2
  t311 = t45 * t38 / 0.4e1
  t315 = t3 * t71
  t318 = t3 * t157
  t320 = t205 * t72 * t245
  t323 = 0.1e1 / t226 / t140
  t324 = t233 ** 2
  t328 = 0.11696447245269292414524477327518106963944910680856e1 * t248 * t323 * t324 * t234
  t329 = t108 ** 2
  t330 = 0.1e1 / t329
  t331 = t56 ** 2
  t334 = 0.2e1 * t293
  t338 = f.my_piecewise3(t105, 0, 0.4e1 / 0.9e1 * t330 * t331 + 0.4e1 / 0.3e1 * t108 * t334)
  t339 = t112 ** 2
  t340 = 0.1e1 / t339
  t341 = t200 ** 2
  t348 = f.my_piecewise3(t111, 0, 0.4e1 / 0.9e1 * t340 * t341 - 0.4e1 / 0.3e1 * t112 * t334)
  t350 = (t338 + t348) * t119
  t358 = 0.1e1 / t8 / t4
  t359 = t89 * t76 * t358
  t360 = 0.1e1 / t83 / t80 * t88 * t359
  t363 = 0.1e1 / t7 / t4
  t364 = t169 * t363
  t365 = t168 * t364
  t367 = t77 * t363
  t368 = t75 * t367
  t370 = t80 ** (-0.5e0)
  t372 = t370 * t88 * t359
  t374 = t176 * t364
  t377 = t90 * t76 * t358
  t379 = -0.57538888888888888888888888888888888888888888888889e0 * t360 + 0.11507777777777777777777777777777777777777777777778e1 * t365 + 0.40256666666666666666666666666666666666666666666667e0 * t368 + 0.36677500000000000000000000000000000000000000000000e-1 * t372 + 0.73355000000000000000000000000000000000000000000000e-1 * t374 + 0.13797500000000000000000000000000000000000000000000e0 * t377
  t383 = 0.58482236226346462072622386637590534819724553404280e0 * t248 * t227 * t379 * t234
  t384 = t75 * t77
  t388 = 0.35616666666666666666666666666666666666666666666666e-1 * t384 * t159 * t165 * t186
  t392 = 0.10843581300301739842632067522386578331157260943710e-1 * t120 * t75 * t160 * t250
  t403 = t218 ** 2
  t417 = t211 ** 2
  t420 = t130 ** 2
  t427 = 0.14764627977777777777777777777777777777777777777777e-2 * t75 * t367 * t99
  t431 = t184 ** 2
  t434 = 0.20000000000000000000000000000000000000000000000000e1 * t82 / t164 / t95 * t431 * t185
  t444 = 0.10000000000000000000000000000000000000000000000000e1 * t166 * (-0.42198333333333333333333333333333333333333333333333e0 * t360 + 0.84396666666666666666666666666666666666666666666666e0 * t365 + 0.39862222222222222222222222222222222222222222222223e0 * t368 + 0.68258333333333333333333333333333333333333333333333e-1 * t372 + 0.13651666666666666666666666666666666666666666666667e0 * t374 + 0.13692777777777777777777777777777777777777777777778e0 * t377) * t185
  t445 = t164 ** 2
  t448 = t98 ** 2
  t452 = 0.16081979498692535066756296899072713062105388428051e2 * t82 / t445 * t431 / t448
  t467 = t226 ** 2
  t468 = 0.1e1 / t467
  t470 = t143 ** 2
  t471 = 0.1e1 / t470
  t475 = -0.70983522622222222222222222222222222222222222222221e-3 * t75 * t367 * t131 - 0.34246666666666666666666666666666666666666666666666e-1 * t384 * t159 * t212 * t220 - 0.20000000000000000000000000000000000000000000000000e1 * t122 / t211 / t127 * t403 * t219 + 0.10000000000000000000000000000000000000000000000000e1 * t213 * (-0.78438333333333333333333333333333333333333333333333e0 * t360 + 0.15687666666666666666666666666666666666666666666667e1 * t365 + 0.68863333333333333333333333333333333333333333333333e0 * t368 + 0.14025833333333333333333333333333333333333333333333e0 * t372 + 0.28051666666666666666666666666666666666666666666667e0 * t374 + 0.17365833333333333333333333333333333333333333333333e0 * t377) * t219 + 0.32163958997385070133512593798145426124210776856102e2 * t122 / t417 * t403 / t420 + t427 + t388 + t434 - t444 - t452 - 0.24415263074675393406472461472505321282722606644045e-3 * t75 * t367 * t144 - 0.10843581300301739842632067522386578331157260943710e-1 * t384 * t159 * t227 * t235 - 0.11696447245269292414524477327518106963944910680856e1 * t135 * t323 * t324 * t234 + 0.58482236226346462072622386637590534819724553404280e0 * t228 * t379 * t234 + 0.17315859105681463759666483083807725165579399831905e2 * t135 * t468 * t324 * t471
  t477 = t104 * t120 * t475
  t481 = 0.24415263074675393406472461472505321282722606644045e-3 * t243 * t169 * t363 * t144
  t485 = 0.17315859105681463759666483083807725165579399831905e2 * t248 * t468 * t324 * t471
  t486 = -0.36622894612013090109708692208757981924083909966068e-3 * t320 + t328 + 0.19751673498613801407483339618206552048944131217655e-1 * t350 * t145 - t383 - t388 + t392 + t477 + t444 + t452 + t481 - t485
  t489 = 0.12e2 * t39 * t103 * t148
  t492 = 0.32e2 * t189 * t193 * t148
  t496 = 0.20e2 * t102 / t256 * t148
  t498 = t205 * t135 * t250
  t500 = t190 * t206
  t503 = 0.8e1 * t190 * t239
  t504 = t194 * t206
  t507 = 0.8e1 * t194 * t239
  t511 = t104 * t205 * t238
  t513 = -t427 + t489 - t492 + t496 - 0.11696447245269292414524477327518106963944910680856e1 * t498 - t434 + 0.8e1 * t500 + t503 - 0.8e1 * t504 - t507 + t104 * t350 * t147 + 0.2e1 * t511
  d11 = 0.2e1 * t153 + 0.2e1 * t254 + t3 * (-t261 - 0.7e1 / 0.6e1 * t262 + t265 - t45 * t268 * t269 / 0.4e1 + t275 / 0.2e1 + t45 * t48 * (0.40e2 / 0.9e1 * tau0 / t13 / t49 / r0 * t24 - 0.50e2 / 0.9e1 * t52 * t58 + 0.10e2 / 0.9e1 * t16 * t285 * t286 + 0.5e1 / 0.3e1 * t16 * t23 * t293 + 0.10e2 / 0.9e1 * t30 * t297 * t298 - 0.5e1 / 0.3e1 * t30 * t34 * t293) / 0.8e1 - t311) * t152 + 0.2e1 * t315 * t253 + t318 * (t486 + t513)
  t516 = -t18 - t55
  t517 = t516 / 0.2e1
  t518 = t23 * t517
  t520 = r1 ** 2
  t523 = tau1 / t27 / t520
  t525 = -t517
  t526 = t34 * t525
  t529 = 0.5e1 / 0.3e1 * t16 * t518 + 0.5e1 / 0.3e1 * t30 * t526 - 0.5e1 / 0.3e1 * t523 * t35
  t530 = t48 * t529
  t533 = t42 + t45 * t530 / 0.8e1 + t70
  t534 = t533 * t152
  t536 = t11 * t530
  t544 = t45 * t273 * t529
  t574 = t3 * t533
  t578 = f.my_piecewise3(t105, 0, 0.4e1 / 0.3e1 * t108 * t516)
  t579 = -t516
  t582 = f.my_piecewise3(t111, 0, 0.4e1 / 0.3e1 * t112 * t579)
  t584 = (t578 + t582) * t119
  t585 = t584 * t147
  t589 = t163 + t188 - t192 - t196 + t104 * t585 + t240 + 0.19751673498613801407483339618206552048944131217655e-1 * t584 * t145 - t247 - t252
  t590 = t157 * t589
  t599 = f.my_piecewise3(t105, 0, 0.4e1 / 0.9e1 * t330 * t516 * t56 + 0.8e1 / 0.3e1 * t108 * t17 * t291)
  t607 = f.my_piecewise3(t111, 0, 0.4e1 / 0.9e1 * t340 * t579 * t200 - 0.8e1 / 0.3e1 * t112 * t17 * t291)
  t609 = (t599 + t607) * t119
  t612 = t190 * t585
  t614 = t194 * t585
  t619 = t104 * t584 * t238
  t622 = 0.19751673498613801407483339618206552048944131217655e-1 * t609 * t145 + 0.4e1 * t612 - 0.4e1 * t614 + t104 * t609 * t147 + t619 - t507 + t511 - 0.4e1 * t504 + t496 - 0.4e1 * t500 - t489 - t427 + t477
  t624 = t584 * t135 * t250
  t628 = t584 * t72 * t245
  t631 = -t434 + t444 + t452 - 0.58482236226346462072622386637590534819724553404280e0 * t624 - t485 - 0.58482236226346462072622386637590534819724553404280e0 * t498 + t328 - t383 + t392 - 0.18311447306006545054854346104378990962041954983034e-3 * t628 - 0.18311447306006545054854346104378990962041954983034e-3 * t320 - t388 + t481
  d12 = t153 + t254 + t534 + t3 * (-t261 - 0.7e1 / 0.12e2 * t262 - 0.7e1 / 0.12e2 * t536 - t45 * t267 * t39 * t529 * t64 / 0.4e1 + t544 / 0.4e1 + t45 * t48 * (-0.25e2 / 0.9e1 * t52 * t518 + 0.10e2 / 0.9e1 * t16 * t285 * t517 * t57 + 0.5e1 / 0.3e1 * t16 * t23 * t17 * t291 - 0.25e2 / 0.9e1 * t523 * t61 + 0.10e2 / 0.9e1 * t30 * t297 * t525 * t60 - 0.5e1 / 0.3e1 * t30 * t34 * t17 * t291) / 0.8e1 - t275 / 0.4e1 + t311) * t152 + t574 * t253 + t590 + t315 * t589 + t318 * (t622 + t631)
  t637 = t529 ** 2
  t642 = t517 ** 2
  t646 = t54 + t292
  t658 = t525 ** 2
  t676 = t516 ** 2
  t679 = 0.2e1 * t646
  t683 = f.my_piecewise3(t105, 0, 0.4e1 / 0.9e1 * t330 * t676 + 0.4e1 / 0.3e1 * t108 * t679)
  t684 = t579 ** 2
  t691 = f.my_piecewise3(t111, 0, 0.4e1 / 0.9e1 * t340 * t684 - 0.4e1 / 0.3e1 * t112 * t679)
  t693 = (t683 + t691) * t119
  t700 = -t485 - t383 - 0.11696447245269292414524477327518106963944910680856e1 * t624 + t477 + t104 * t693 * t147 + 0.2e1 * t619 + t489 - 0.8e1 * t614 - t507 + 0.19751673498613801407483339618206552048944131217655e-1 * t693 * t145 + t444
  t703 = t452 - 0.8e1 * t612 - t503 - t434 + t392 + t496 + t492 - t427 - 0.36622894612013090109708692208757981924083909966068e-3 * t628 + t328 - t388 + t481
  d22 = 0.2e1 * t534 + 0.2e1 * t590 + t3 * (-t261 - 0.7e1 / 0.6e1 * t536 - t265 - t45 * t268 * t637 / 0.4e1 - t544 / 0.2e1 + t45 * t48 * (0.10e2 / 0.9e1 * t16 * t285 * t642 + 0.5e1 / 0.3e1 * t16 * t23 * t646 + 0.40e2 / 0.9e1 * tau1 / t27 / t520 / r1 * t35 - 0.50e2 / 0.9e1 * t523 * t526 + 0.10e2 / 0.9e1 * t30 * t297 * t658 - 0.5e1 / 0.3e1 * t30 * t34 * t646) / 0.8e1 - t311) * t152 + 0.2e1 * t574 * t589 + t318 * (t700 + t703)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = t3 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t11 = t2 / t8 / t6
  t12 = r0 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t16 = tau0 / t13 / r0
  t17 = r0 - r1
  t18 = 0.1e1 / t3
  t19 = t17 * t18
  t20 = 0.1e1 + t19
  t21 = t20 / 0.2e1
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * t21
  t26 = r1 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t30 = tau1 / t27 / r1
  t31 = 0.1e1 - t19
  t32 = t31 / 0.2e1
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t37 = t30 * t34 * t32 + t16 * t24
  t38 = 0.1e1 / t37
  t39 = t17 ** 2
  t40 = t38 * t39
  t43 = t5 * t3
  t46 = t2 / t8 / t43
  t47 = t37 ** 2
  t48 = 0.1e1 / t47
  t49 = t48 * t39
  t50 = r0 ** 2
  t53 = tau0 / t13 / t50
  t55 = 0.1e1 / t4
  t57 = -t17 * t55 + t18
  t58 = t57 / 0.2e1
  t59 = t23 * t58
  t61 = -t58
  t65 = 0.5e1 / 0.3e1 * t30 * t34 * t61 + 0.5e1 / 0.3e1 * t16 * t59 - 0.5e1 / 0.3e1 * t53 * t24
  t66 = t49 * t65
  t69 = t38 * t17
  t74 = t2 / t8 / t5
  t76 = 0.1e1 / t47 / t37
  t78 = t65 ** 2
  t79 = t76 * t39 * t78
  t82 = t48 * t17
  t83 = t82 * t65
  t89 = tau0 / t13 / t50 / r0
  t94 = 0.1e1 / t22
  t95 = t58 ** 2
  t96 = t94 * t95
  t99 = t4 * t3
  t100 = 0.1e1 / t99
  t102 = t17 * t100 - t55
  t103 = t23 * t102
  t106 = 0.1e1 / t33
  t107 = t61 ** 2
  t111 = -t102
  t115 = 0.40e2 / 0.9e1 * t89 * t24 - 0.50e2 / 0.9e1 * t53 * t59 + 0.10e2 / 0.9e1 * t16 * t96 + 0.5e1 / 0.3e1 * t16 * t103 + 0.10e2 / 0.9e1 * t30 * t106 * t107 + 0.5e1 / 0.3e1 * t30 * t34 * t111
  t116 = t49 * t115
  t121 = -0.119e3 / 0.36e2 * t11 * t40 - 0.7e1 / 0.6e1 * t46 * t66 + 0.7e1 / 0.3e1 * t46 * t69 - t74 * t79 / 0.4e1 + t74 * t83 / 0.2e1 + t74 * t116 / 0.8e1 - t74 * t38 / 0.4e1
  t122 = 3 ** (0.1e1 / 0.3e1)
  t123 = 0.1e1 / jnp.pi
  t124 = t123 ** (0.1e1 / 0.3e1)
  t125 = t122 * t124
  t126 = 4 ** (0.1e1 / 0.3e1)
  t127 = t126 ** 2
  t130 = t125 * t127 / t7
  t132 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t130
  t133 = jnp.sqrt(t130)
  t136 = t130 ** 0.15e1
  t138 = t122 ** 2
  t139 = t124 ** 2
  t140 = t138 * t139
  t143 = t140 * t126 / t8
  t145 = 0.37978500000000000000000000000000000000000000000000e1 * t133 + 0.89690000000000000000000000000000000000000000000000e0 * t130 + 0.20477500000000000000000000000000000000000000000000e0 * t136 + 0.12323500000000000000000000000000000000000000000000e0 * t143
  t148 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t145
  t149 = jnp.log(t148)
  t151 = 0.621814e-1 * t132 * t149
  t152 = t39 ** 2
  t153 = 0.1e1 / t5
  t154 = t152 * t153
  t155 = t20 <= f.p.zeta_threshold
  t156 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t157 = t156 * f.p.zeta_threshold
  t158 = t20 ** (0.1e1 / 0.3e1)
  t160 = f.my_piecewise3(t155, t157, t158 * t20)
  t161 = t31 <= f.p.zeta_threshold
  t162 = t31 ** (0.1e1 / 0.3e1)
  t164 = f.my_piecewise3(t161, t157, t162 * t31)
  t166 = 2 ** (0.1e1 / 0.3e1)
  t169 = 0.1e1 / (0.2e1 * t166 - 0.2e1)
  t170 = (t160 + t164 - 0.2e1) * t169
  t172 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t130
  t177 = 0.70594500000000000000000000000000000000000000000000e1 * t133 + 0.15494250000000000000000000000000000000000000000000e1 * t130 + 0.42077500000000000000000000000000000000000000000000e0 * t136 + 0.15629250000000000000000000000000000000000000000000e0 * t143
  t180 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t177
  t181 = jnp.log(t180)
  t185 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t130
  t190 = 0.51785000000000000000000000000000000000000000000000e1 * t133 + 0.90577500000000000000000000000000000000000000000000e0 * t130 + 0.11003250000000000000000000000000000000000000000000e0 * t136 + 0.12417750000000000000000000000000000000000000000000e0 * t143
  t193 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t190
  t194 = jnp.log(t193)
  t195 = t185 * t194
  t197 = -0.3109070e-1 * t172 * t181 + t151 - 0.19751673498613801407483339618206552048944131217655e-1 * t195
  t198 = t170 * t197
  t202 = -t151 + t154 * t198 + 0.19751673498613801407483339618206552048944131217655e-1 * t170 * t195
  t211 = 0.7e1 / 0.12e2 * t46 * t40 + t74 * t66 / 0.8e1 - t74 * t69 / 0.4e1
  t213 = 0.1e1 / t7 / t3
  t214 = t127 * t213
  t217 = 0.11073470983333333333333333333333333333333333333333e-2 * t125 * t214 * t149
  t218 = t145 ** 2
  t219 = 0.1e1 / t218
  t220 = t132 * t219
  t222 = 0.1e1 / t133 * t122
  t223 = t124 * t127
  t224 = t223 * t213
  t225 = t222 * t224
  t227 = t125 * t214
  t229 = t130 ** 0.5e0
  t230 = t229 * t122
  t231 = t230 * t224
  t236 = t140 * t126 / t8 / t3
  t238 = -0.63297500000000000000000000000000000000000000000000e0 * t225 - 0.29896666666666666666666666666666666666666666666667e0 * t227 - 0.10238750000000000000000000000000000000000000000000e0 * t231 - 0.82156666666666666666666666666666666666666666666667e-1 * t236
  t239 = 0.1e1 / t148
  t240 = t238 * t239
  t242 = 0.10000000000000000000000000000000000000000000000000e1 * t220 * t240
  t243 = t39 * t17
  t244 = t243 * t153
  t247 = 0.1e1 / t43
  t248 = t152 * t247
  t253 = f.my_piecewise3(t155, 0, 0.4e1 / 0.3e1 * t158 * t57)
  t254 = -t57
  t257 = f.my_piecewise3(t161, 0, 0.4e1 / 0.3e1 * t162 * t254)
  t259 = (t253 + t257) * t169
  t260 = t259 * t197
  t265 = t177 ** 2
  t266 = 0.1e1 / t265
  t267 = t172 * t266
  t272 = -0.11765750000000000000000000000000000000000000000000e1 * t225 - 0.51647500000000000000000000000000000000000000000000e0 * t227 - 0.21038750000000000000000000000000000000000000000000e0 * t231 - 0.10419500000000000000000000000000000000000000000000e0 * t236
  t273 = 0.1e1 / t180
  t274 = t272 * t273
  t280 = t190 ** 2
  t281 = 0.1e1 / t280
  t282 = t185 * t281
  t287 = -0.86308333333333333333333333333333333333333333333334e0 * t225 - 0.30192500000000000000000000000000000000000000000000e0 * t227 - 0.55016250000000000000000000000000000000000000000000e-1 * t231 - 0.82785000000000000000000000000000000000000000000000e-1 * t236
  t288 = 0.1e1 / t193
  t289 = t287 * t288
  t292 = 0.53237641966666666666666666666666666666666666666666e-3 * t125 * t214 * t181 + 0.10000000000000000000000000000000000000000000000000e1 * t267 * t274 - t217 - t242 + 0.18311447306006545054854346104378990962041954983034e-3 * t125 * t214 * t194 + 0.58482236226346462072622386637590534819724553404280e0 * t282 * t289
  t293 = t170 * t292
  t297 = t170 * t122
  t299 = t223 * t213 * t194
  t302 = t170 * t185
  t304 = t281 * t287 * t288
  t307 = t217 + t242 + 0.4e1 * t244 * t198 - 0.4e1 * t248 * t198 + t154 * t260 + t154 * t293 + 0.19751673498613801407483339618206552048944131217655e-1 * t259 * t195 - 0.18311447306006545054854346104378990962041954983034e-3 * t297 * t299 - 0.58482236226346462072622386637590534819724553404280e0 * t302 * t304
  t312 = 0.1e1 - t74 * t40 / 0.8e1
  t313 = t158 ** 2
  t314 = 0.1e1 / t313
  t315 = t57 ** 2
  t318 = 0.2e1 * t102
  t322 = f.my_piecewise3(t155, 0, 0.4e1 / 0.9e1 * t314 * t315 + 0.4e1 / 0.3e1 * t158 * t318)
  t323 = t162 ** 2
  t324 = 0.1e1 / t323
  t325 = t254 ** 2
  t328 = -t318
  t332 = f.my_piecewise3(t161, 0, 0.4e1 / 0.9e1 * t324 * t325 + 0.4e1 / 0.3e1 * t162 * t328)
  t334 = (t322 + t332) * t169
  t337 = t259 * t122
  t341 = 0.1e1 / t280 / t190
  t342 = t287 ** 2
  t344 = t341 * t342 * t288
  t347 = t125 * t127
  t348 = t213 * t219
  t351 = 0.35616666666666666666666666666666666666666666666666e-1 * t347 * t348 * t240
  t352 = t170 * t125
  t353 = t214 * t304
  t357 = 0.1e1 / t7 / t4
  t358 = t127 * t357
  t362 = t213 * t266
  t367 = 0.1e1 / t265 / t177
  t368 = t172 * t367
  t369 = t272 ** 2
  t370 = t369 * t273
  t375 = 0.1e1 / t133 / t130 * t138
  t376 = t139 * t126
  t378 = 0.1e1 / t8 / t4
  t379 = t376 * t378
  t380 = t375 * t379
  t382 = t223 * t357
  t383 = t222 * t382
  t385 = t125 * t358
  t387 = t130 ** (-0.5e0)
  t388 = t387 * t138
  t389 = t388 * t379
  t391 = t230 * t382
  t394 = t140 * t126 * t378
  t396 = -0.78438333333333333333333333333333333333333333333333e0 * t380 + 0.15687666666666666666666666666666666666666666666667e1 * t383 + 0.68863333333333333333333333333333333333333333333333e0 * t385 + 0.14025833333333333333333333333333333333333333333333e0 * t389 + 0.28051666666666666666666666666666666666666666666667e0 * t391 + 0.17365833333333333333333333333333333333333333333333e0 * t394
  t397 = t396 * t273
  t400 = t265 ** 2
  t401 = 0.1e1 / t400
  t402 = t172 * t401
  t403 = t180 ** 2
  t404 = 0.1e1 / t403
  t405 = t369 * t404
  t410 = 0.14764627977777777777777777777777777777777777777777e-2 * t125 * t358 * t149
  t412 = 0.1e1 / t218 / t145
  t413 = t132 * t412
  t414 = t238 ** 2
  t415 = t414 * t239
  t417 = 0.20000000000000000000000000000000000000000000000000e1 * t413 * t415
  t424 = -0.42198333333333333333333333333333333333333333333333e0 * t380 + 0.84396666666666666666666666666666666666666666666666e0 * t383 + 0.39862222222222222222222222222222222222222222222223e0 * t385 + 0.68258333333333333333333333333333333333333333333333e-1 * t389 + 0.13651666666666666666666666666666666666666666666667e0 * t391 + 0.13692777777777777777777777777777777777777777777778e0 * t394
  t425 = t424 * t239
  t427 = 0.10000000000000000000000000000000000000000000000000e1 * t220 * t425
  t428 = t218 ** 2
  t429 = 0.1e1 / t428
  t430 = t132 * t429
  t431 = t148 ** 2
  t432 = 0.1e1 / t431
  t433 = t414 * t432
  t435 = 0.16081979498692535066756296899072713062105388428051e2 * t430 * t433
  t439 = t213 * t281
  t443 = t185 * t341
  t444 = t342 * t288
  t453 = -0.57538888888888888888888888888888888888888888888889e0 * t380 + 0.11507777777777777777777777777777777777777777777778e1 * t383 + 0.40256666666666666666666666666666666666666666666667e0 * t385 + 0.36677500000000000000000000000000000000000000000000e-1 * t389 + 0.73355000000000000000000000000000000000000000000000e-1 * t391 + 0.13797500000000000000000000000000000000000000000000e0 * t394
  t454 = t453 * t288
  t457 = t280 ** 2
  t458 = 0.1e1 / t457
  t459 = t185 * t458
  t460 = t193 ** 2
  t461 = 0.1e1 / t460
  t462 = t342 * t461
  t465 = -0.70983522622222222222222222222222222222222222222221e-3 * t125 * t358 * t181 - 0.34246666666666666666666666666666666666666666666666e-1 * t347 * t362 * t274 - 0.20000000000000000000000000000000000000000000000000e1 * t368 * t370 + 0.10000000000000000000000000000000000000000000000000e1 * t267 * t397 + 0.32163958997385070133512593798145426124210776856102e2 * t402 * t405 + t410 + t351 + t417 - t427 - t435 - 0.24415263074675393406472461472505321282722606644045e-3 * t125 * t358 * t194 - 0.10843581300301739842632067522386578331157260943710e-1 * t347 * t439 * t289 - 0.11696447245269292414524477327518106963944910680856e1 * t443 * t444 + 0.58482236226346462072622386637590534819724553404280e0 * t282 * t454 + 0.17315859105681463759666483083807725165579399831905e2 * t459 * t462
  t466 = t170 * t465
  t469 = t223 * t357 * t194
  t473 = t281 * t453 * t288
  t477 = t458 * t342 * t461
  t480 = 0.19751673498613801407483339618206552048944131217655e-1 * t334 * t195 - 0.36622894612013090109708692208757981924083909966068e-3 * t337 * t299 + 0.11696447245269292414524477327518106963944910680856e1 * t302 * t344 - t351 + 0.10843581300301739842632067522386578331157260943710e-1 * t352 * t353 + t154 * t466 + t427 + t435 + 0.24415263074675393406472461472505321282722606644045e-3 * t297 * t469 - 0.58482236226346462072622386637590534819724553404280e0 * t302 * t473 - 0.17315859105681463759666483083807725165579399831905e2 * t302 * t477
  t481 = t39 * t153
  t484 = t243 * t247
  t487 = 0.1e1 / t6
  t488 = t152 * t487
  t491 = t259 * t185
  t502 = t334 * t197
  t504 = t259 * t292
  t507 = -t410 + 0.12e2 * t481 * t198 - 0.32e2 * t484 * t198 + 0.20e2 * t488 * t198 - 0.11696447245269292414524477327518106963944910680856e1 * t491 * t304 - t417 + 0.8e1 * t244 * t260 + 0.8e1 * t244 * t293 - 0.8e1 * t248 * t260 - 0.8e1 * t248 * t293 + t154 * t502 + 0.2e1 * t154 * t504
  t508 = t480 + t507
  t511 = t5 * t99
  t529 = t47 ** 2
  t551 = t50 ** 2
  t573 = t17 * t153
  t574 = t100 - t573
  t575 = 0.3e1 * t574
  t597 = 0.595e3 / 0.27e2 * t2 / t8 / t511 * t40 + 0.119e3 / 0.12e2 * t11 * t66 - 0.119e3 / 0.6e1 * t11 * t69 + 0.7e1 / 0.2e1 * t46 * t79 - 0.7e1 * t46 * t83 - 0.7e1 / 0.4e1 * t46 * t116 + 0.7e1 / 0.2e1 * t46 * t38 + 0.3e1 / 0.4e1 * t74 / t529 * t39 * t78 * t65 - 0.3e1 / 0.2e1 * t74 * t76 * t17 * t78 - 0.3e1 / 0.4e1 * t74 * t76 * t39 * t65 * t115 + 0.3e1 / 0.4e1 * t74 * t48 * t65 + 0.3e1 / 0.4e1 * t74 * t82 * t115 + t74 * t49 * (-0.440e3 / 0.27e2 * tau0 / t13 / t551 * t24 + 0.200e3 / 0.9e1 * t89 * t59 - 0.50e2 / 0.9e1 * t53 * t96 - 0.25e2 / 0.3e1 * t53 * t103 - 0.10e2 / 0.27e2 * t16 / t22 / t21 * t95 * t58 + 0.10e2 / 0.3e1 * t16 * t94 * t58 * t102 + 0.5e1 / 0.3e1 * t16 * t23 * t575 - 0.10e2 / 0.27e2 * t30 / t33 / t32 * t107 * t61 + 0.10e2 / 0.3e1 * t30 * t106 * t61 * t111 - 0.5e1 / 0.3e1 * t30 * t34 * t575) / 0.8e1
  t607 = t342 * t287
  t623 = 0.1e1 / t133 / t143 * t123 * t153 / 0.4e1
  t626 = 0.1e1 / t8 / t99
  t627 = t376 * t626
  t628 = t375 * t627
  t631 = 0.1e1 / t7 / t99
  t632 = t223 * t631
  t633 = t222 * t632
  t635 = t127 * t631
  t636 = t125 * t635
  t638 = t130 ** (-0.15e1)
  t640 = t638 * t123 * t153
  t642 = t388 * t627
  t644 = t230 * t632
  t647 = t140 * t126 * t626
  t649 = -0.34523333333333333333333333333333333333333333333333e1 * t623 + 0.23015555555555555555555555555555555555555555555556e1 * t628 - 0.26851481481481481481481481481481481481481481481482e1 * t633 - 0.93932222222222222222222222222222222222222222222223e0 * t636 + 0.73355000000000000000000000000000000000000000000000e-1 * t640 - 0.14671000000000000000000000000000000000000000000000e0 * t642 - 0.17116166666666666666666666666666666666666666666667e0 * t644 - 0.36793333333333333333333333333333333333333333333333e0 * t647
  t655 = 0.1e1 / t457 / t190
  t661 = 0.1e1 / t457 / t280
  t664 = 0.1e1 / t460 / t193
  t681 = -0.35089341735807877243573431982554320891834732042568e1 * t302 * t458 * t607 * t288 + 0.35089341735807877243573431982554320891834732042568e1 * t491 * t344 - 0.17544670867903938621786715991277160445917366021284e1 * t334 * t185 * t304 - 0.17544670867903938621786715991277160445917366021284e1 * t491 * t473 - 0.58482236226346462072622386637590534819724553404280e0 * t302 * t281 * t649 * t288 + 0.10389515463408878255799889850284635099347639899143e3 * t302 * t655 * t607 * t461 - 0.10254018858216406658218194626490193680059335835414e4 * t302 * t661 * t607 * t664 - 0.51947577317044391278999449251423175496738199495715e2 * t491 * t477 - 0.24e2 * t248 * t504 - 0.120e3 * t152 / t511 * t198 + 0.240e3 * t243 * t487 * t198 + 0.24e2 * t573 * t198
  t697 = 0.6e1 * t574
  t701 = f.my_piecewise3(t155, 0, -0.8e1 / 0.27e2 / t313 / t20 * t315 * t57 + 0.4e1 / 0.3e1 * t314 * t57 * t318 + 0.4e1 / 0.3e1 * t158 * t697)
  t714 = f.my_piecewise3(t161, 0, -0.8e1 / 0.27e2 / t323 / t31 * t325 * t254 + 0.4e1 / 0.3e1 * t324 * t254 * t328 - 0.4e1 / 0.3e1 * t162 * t697)
  t716 = (t701 + t714) * t169
  t741 = -0.144e3 * t39 * t247 * t198 - 0.12e2 * t248 * t502 - 0.96e2 * t484 * t293 + t154 * t716 * t197 + 0.3e1 * t154 * t334 * t292 + 0.36e2 * t481 * t293 - 0.96e2 * t484 * t260 + 0.60e2 * t488 * t293 + 0.36e2 * t481 * t260 + 0.3e1 * t154 * t259 * t465 + 0.60e2 * t488 * t260 - 0.32530743900905219527896202567159734993471782831130e-1 * t352 * t214 * t344 + 0.16265371950452609763948101283579867496735891415565e-1 * t352 * t214 * t473
  t758 = 0.60000000000000000000000000000000000000000000000000e1 * t413 * t240 * t424
  t762 = t369 * t272
  t793 = 0.34450798614814814814814814814814814814814814814813e-2 * t125 * t635 * t149
  t797 = 0.48245938496077605200268890697218139186316165284153e2 * t430 * t424 * t432 * t238
  t826 = 0.20690405167709360119593700880421107356354650655085e4 * t172 / t400 / t265 * t762 / t403 / t180 + 0.58482236226346462072622386637590534819724553404280e0 * t282 * t649 * t288 - 0.35089341735807877243573431982554320891834732042568e1 * t443 * t289 * t453 + 0.96491876992155210400537781394436278372632330568306e2 * t402 * t396 * t404 * t272 - 0.60000000000000000000000000000000000000000000000000e1 * t368 * t274 * t396 + 0.16562821945185185185185185185185185185185185185185e-2 * t125 * t635 * t181 + 0.51947577317044391278999449251423175496738199495715e2 * t459 * t453 * t461 * t287 + 0.56968947174242584615102410102512416326352748836105e-3 * t125 * t635 * t194 + t758 - t793 - t797 + 0.35089341735807877243573431982554320891834732042568e1 * t459 * t607 * t288 + 0.10254018858216406658218194626490193680059335835414e4 * t185 * t661 * t607 * t664 + 0.10000000000000000000000000000000000000000000000000e1 * t267 * (-0.47063000000000000000000000000000000000000000000000e1 * t623 + 0.31375333333333333333333333333333333333333333333334e1 * t628 - 0.36604555555555555555555555555555555555555555555556e1 * t633 - 0.16068111111111111111111111111111111111111111111111e1 * t636 + 0.28051666666666666666666666666666666666666666666666e0 * t640 - 0.56103333333333333333333333333333333333333333333332e0 * t642 - 0.65453888888888888888888888888888888888888888888890e0 * t644 - 0.46308888888888888888888888888888888888888888888888e0 * t647) * t273 + 0.60000000000000000000000000000000000000000000000000e1 * t402 * t762 * t273 - 0.19298375398431042080107556278887255674526466113661e3 * t172 / t400 / t177 * t762 * t404
  t834 = t414 * t238
  t837 = 0.96491876992155210400537781394436278372632330568306e2 * t132 / t428 / t145 * t834 * t432
  t840 = 0.60000000000000000000000000000000000000000000000000e1 * t430 * t834 * t239
  t848 = 0.51726012919273400298984252201052768390886626637712e3 * t132 / t428 / t218 * t834 / t431 / t148
  t860 = 0.10000000000000000000000000000000000000000000000000e1 * t220 * (-0.25319000000000000000000000000000000000000000000000e1 * t623 + 0.16879333333333333333333333333333333333333333333333e1 * t628 - 0.19692555555555555555555555555555555555555555555555e1 * t633 - 0.93011851851851851851851851851851851851851851851854e0 * t636 + 0.13651666666666666666666666666666666666666666666667e0 * t640 - 0.27303333333333333333333333333333333333333333333333e0 * t642 - 0.31853888888888888888888888888888888888888888888890e0 * t644 - 0.36514074074074074074074074074074074074074074074075e0 * t647) * t239
  t863 = 0.53424999999999999999999999999999999999999999999999e-1 * t347 * t348 * t425
  t867 = 0.85917975471764868594145516183295969534298037676861e0 * t347 * t213 * t429 * t433
  t871 = 0.71233333333333333333333333333333333333333333333331e-1 * t347 * t357 * t219 * t240
  t875 = 0.10685000000000000000000000000000000000000000000000e0 * t347 * t213 * t412 * t415
  t906 = -0.10389515463408878255799889850284635099347639899143e3 * t185 * t655 * t607 * t461 + t837 - t840 - t848 - t860 + t863 + t867 - t871 - t875 + 0.10274000000000000000000000000000000000000000000000e0 * t347 * t213 * t367 * t370 + 0.32530743900905219527896202567159734993471782831130e-1 * t347 * t213 * t341 * t444 + 0.21687162600603479685264135044773156662314521887420e-1 * t347 * t357 * t281 * t289 - 0.16265371950452609763948101283579867496735891415565e-1 * t347 * t439 * t454 - 0.48159733137676571081572406076840235616767705782485e0 * t347 * t213 * t458 * t462 + 0.68493333333333333333333333333333333333333333333332e-1 * t347 * t357 * t266 * t274 - 0.51369999999999999999999999999999999999999999999999e-1 * t347 * t362 * t397 - 0.16522625736956710527585419434107305400007076070979e1 * t347 * t213 * t401 * t405
  t914 = 0.48159733137676571081572406076840235616767705782485e0 * t352 * t214 * t477 - 0.21687162600603479685264135044773156662314521887420e-1 * t352 * t358 * t304 + 0.32530743900905219527896202567159734993471782831130e-1 * t259 * t125 * t353 + 0.12e2 * t244 * t502 + 0.24e2 * t244 * t504 - t758 + t154 * t170 * (t826 + t906) + 0.12e2 * t244 * t466 + t793 + t797 - 0.12e2 * t248 * t466 - t837
  t935 = t840 + 0.19751673498613801407483339618206552048944131217655e-1 * t716 * t195 + t848 + t860 - 0.51947577317044391278999449251423175496738199495715e2 * t302 * t458 * t453 * t461 * t287 - 0.54934341918019635164563038313136972886125864949102e-3 * t334 * t122 * t299 + 0.35089341735807877243573431982554320891834732042568e1 * t302 * t341 * t287 * t454 + 0.73245789224026180219417384417515963848167819932136e-3 * t337 * t469 - 0.56968947174242584615102410102512416326352748836105e-3 * t297 * t223 * t631 * t194 - t863 - t867 + t871 + t875
  d111 = 0.3e1 * t121 * t202 + 0.6e1 * t211 * t307 + 0.3e1 * t312 * t508 + t3 * t597 * t202 + 0.3e1 * t3 * t121 * t307 + 0.3e1 * t3 * t211 * t508 + t3 * t312 * (t681 + t741 + t914 + t935)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t4 * t3
  t6 = t4 ** 2
  t7 = t6 * t5
  t8 = t3 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t12 = t2 / t9 / t7
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t17 = tau0 / t14 / r0
  t18 = r0 - r1
  t19 = 0.1e1 / t3
  t20 = t18 * t19
  t21 = 0.1e1 + t20
  t22 = t21 / 0.2e1
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t24 * t22
  t27 = r1 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t31 = tau1 / t28 / r1
  t32 = 0.1e1 - t20
  t33 = t32 / 0.2e1
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t38 = t31 * t35 * t33 + t17 * t25
  t39 = 0.1e1 / t38
  t40 = t18 ** 2
  t41 = t39 * t40
  t44 = t6 * t4
  t47 = t2 / t9 / t44
  t48 = t38 ** 2
  t49 = 0.1e1 / t48
  t50 = t49 * t40
  t51 = r0 ** 2
  t54 = tau0 / t14 / t51
  t56 = 0.1e1 / t4
  t58 = -t18 * t56 + t19
  t59 = t58 / 0.2e1
  t60 = t24 * t59
  t62 = -t59
  t66 = 0.5e1 / 0.3e1 * t31 * t35 * t62 + 0.5e1 / 0.3e1 * t17 * t60 - 0.5e1 / 0.3e1 * t54 * t25
  t67 = t50 * t66
  t70 = t39 * t18
  t73 = t6 * t3
  t76 = t2 / t9 / t73
  t78 = 0.1e1 / t48 / t38
  t79 = t78 * t40
  t80 = t66 ** 2
  t81 = t79 * t80
  t84 = t49 * t18
  t85 = t84 * t66
  t91 = tau0 / t14 / t51 / r0
  t96 = 0.1e1 / t23
  t97 = t59 ** 2
  t98 = t96 * t97
  t101 = 0.1e1 / t5
  t103 = t18 * t101 - t56
  t104 = t24 * t103
  t107 = 0.1e1 / t34
  t108 = t62 ** 2
  t112 = -t103
  t116 = 0.40e2 / 0.9e1 * t91 * t25 - 0.50e2 / 0.9e1 * t54 * t60 + 0.10e2 / 0.9e1 * t17 * t98 + 0.5e1 / 0.3e1 * t17 * t104 + 0.10e2 / 0.9e1 * t31 * t107 * t108 + 0.5e1 / 0.3e1 * t31 * t35 * t112
  t117 = t50 * t116
  t123 = 0.1e1 / t9 / t6
  t124 = t2 * t123
  t125 = t48 ** 2
  t126 = 0.1e1 / t125
  t128 = t80 * t66
  t129 = t126 * t40 * t128
  t133 = t78 * t18 * t80
  t136 = t124 * t78
  t137 = t40 * t66
  t138 = t137 * t116
  t141 = t49 * t66
  t144 = t84 * t116
  t147 = t51 ** 2
  t150 = tau0 / t14 / t147
  t160 = 0.1e1 / t23 / t22
  t162 = t160 * t97 * t59
  t165 = t96 * t59
  t166 = t165 * t103
  t169 = 0.1e1 / t6
  t170 = t18 * t169
  t171 = t101 - t170
  t172 = 0.3e1 * t171
  t173 = t24 * t172
  t177 = 0.1e1 / t34 / t33
  t182 = t107 * t62
  t186 = -t172
  t190 = -0.440e3 / 0.27e2 * t150 * t25 + 0.200e3 / 0.9e1 * t91 * t60 - 0.50e2 / 0.9e1 * t54 * t98 - 0.25e2 / 0.3e1 * t54 * t104 - 0.10e2 / 0.27e2 * t17 * t162 + 0.10e2 / 0.3e1 * t17 * t166 + 0.5e1 / 0.3e1 * t17 * t173 - 0.10e2 / 0.27e2 * t31 * t177 * t108 * t62 + 0.10e2 / 0.3e1 * t31 * t182 * t112 + 0.5e1 / 0.3e1 * t31 * t35 * t186
  t191 = t50 * t190
  t194 = 0.595e3 / 0.27e2 * t12 * t41 + 0.119e3 / 0.12e2 * t47 * t67 - 0.119e3 / 0.6e1 * t47 * t70 + 0.7e1 / 0.2e1 * t76 * t81 - 0.7e1 * t76 * t85 - 0.7e1 / 0.4e1 * t76 * t117 + 0.7e1 / 0.2e1 * t76 * t39 + 0.3e1 / 0.4e1 * t124 * t129 - 0.3e1 / 0.2e1 * t124 * t133 - 0.3e1 / 0.4e1 * t136 * t138 + 0.3e1 / 0.4e1 * t124 * t141 + 0.3e1 / 0.4e1 * t124 * t144 + t124 * t191 / 0.8e1
  t195 = 3 ** (0.1e1 / 0.3e1)
  t196 = 0.1e1 / jnp.pi
  t197 = t196 ** (0.1e1 / 0.3e1)
  t198 = t195 * t197
  t199 = 4 ** (0.1e1 / 0.3e1)
  t200 = t199 ** 2
  t203 = t198 * t200 / t8
  t205 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t203
  t206 = jnp.sqrt(t203)
  t209 = t203 ** 0.15e1
  t211 = t195 ** 2
  t212 = t197 ** 2
  t213 = t211 * t212
  t216 = t213 * t199 / t9
  t218 = 0.37978500000000000000000000000000000000000000000000e1 * t206 + 0.89690000000000000000000000000000000000000000000000e0 * t203 + 0.20477500000000000000000000000000000000000000000000e0 * t209 + 0.12323500000000000000000000000000000000000000000000e0 * t216
  t221 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t218
  t222 = jnp.log(t221)
  t224 = 0.621814e-1 * t205 * t222
  t225 = t40 ** 2
  t226 = t225 * t169
  t227 = t21 <= f.p.zeta_threshold
  t228 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t229 = t228 * f.p.zeta_threshold
  t230 = t21 ** (0.1e1 / 0.3e1)
  t232 = f.my_piecewise3(t227, t229, t230 * t21)
  t233 = t32 <= f.p.zeta_threshold
  t234 = t32 ** (0.1e1 / 0.3e1)
  t236 = f.my_piecewise3(t233, t229, t234 * t32)
  t237 = t232 + t236 - 0.2e1
  t238 = 2 ** (0.1e1 / 0.3e1)
  t241 = 0.1e1 / (0.2e1 * t238 - 0.2e1)
  t242 = t237 * t241
  t244 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t203
  t249 = 0.70594500000000000000000000000000000000000000000000e1 * t206 + 0.15494250000000000000000000000000000000000000000000e1 * t203 + 0.42077500000000000000000000000000000000000000000000e0 * t209 + 0.15629250000000000000000000000000000000000000000000e0 * t216
  t252 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t249
  t253 = jnp.log(t252)
  t257 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t203
  t262 = 0.51785000000000000000000000000000000000000000000000e1 * t206 + 0.90577500000000000000000000000000000000000000000000e0 * t203 + 0.11003250000000000000000000000000000000000000000000e0 * t209 + 0.12417750000000000000000000000000000000000000000000e0 * t216
  t265 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t262
  t266 = jnp.log(t265)
  t267 = t257 * t266
  t269 = -0.3109070e-1 * t244 * t253 + t224 - 0.19751673498613801407483339618206552048944131217655e-1 * t267
  t270 = t242 * t269
  t274 = -t224 + t226 * t270 + 0.19751673498613801407483339618206552048944131217655e-1 * t242 * t267
  t291 = -0.119e3 / 0.36e2 * t47 * t41 - 0.7e1 / 0.6e1 * t76 * t67 + 0.7e1 / 0.3e1 * t76 * t70 - t124 * t81 / 0.4e1 + t124 * t85 / 0.2e1 + t124 * t117 / 0.8e1 - t124 * t39 / 0.4e1
  t293 = 0.1e1 / t8 / t3
  t294 = t200 * t293
  t297 = 0.11073470983333333333333333333333333333333333333333e-2 * t198 * t294 * t222
  t298 = t218 ** 2
  t299 = 0.1e1 / t298
  t300 = t205 * t299
  t302 = 0.1e1 / t206 * t195
  t303 = t197 * t200
  t304 = t303 * t293
  t305 = t302 * t304
  t307 = t198 * t294
  t309 = t203 ** 0.5e0
  t310 = t309 * t195
  t311 = t310 * t304
  t316 = t213 * t199 / t9 / t3
  t318 = -0.63297500000000000000000000000000000000000000000000e0 * t305 - 0.29896666666666666666666666666666666666666666666667e0 * t307 - 0.10238750000000000000000000000000000000000000000000e0 * t311 - 0.82156666666666666666666666666666666666666666666667e-1 * t316
  t319 = 0.1e1 / t221
  t320 = t318 * t319
  t322 = 0.10000000000000000000000000000000000000000000000000e1 * t300 * t320
  t323 = t40 * t18
  t324 = t323 * t169
  t327 = 0.1e1 / t73
  t328 = t225 * t327
  t333 = f.my_piecewise3(t227, 0, 0.4e1 / 0.3e1 * t230 * t58)
  t334 = -t58
  t337 = f.my_piecewise3(t233, 0, 0.4e1 / 0.3e1 * t234 * t334)
  t339 = (t333 + t337) * t241
  t340 = t339 * t269
  t345 = t249 ** 2
  t346 = 0.1e1 / t345
  t347 = t244 * t346
  t352 = -0.11765750000000000000000000000000000000000000000000e1 * t305 - 0.51647500000000000000000000000000000000000000000000e0 * t307 - 0.21038750000000000000000000000000000000000000000000e0 * t311 - 0.10419500000000000000000000000000000000000000000000e0 * t316
  t353 = 0.1e1 / t252
  t354 = t352 * t353
  t360 = t262 ** 2
  t361 = 0.1e1 / t360
  t362 = t257 * t361
  t367 = -0.86308333333333333333333333333333333333333333333334e0 * t305 - 0.30192500000000000000000000000000000000000000000000e0 * t307 - 0.55016250000000000000000000000000000000000000000000e-1 * t311 - 0.82785000000000000000000000000000000000000000000000e-1 * t316
  t368 = 0.1e1 / t265
  t369 = t367 * t368
  t372 = 0.53237641966666666666666666666666666666666666666666e-3 * t198 * t294 * t253 + 0.10000000000000000000000000000000000000000000000000e1 * t347 * t354 - t297 - t322 + 0.18311447306006545054854346104378990962041954983034e-3 * t198 * t294 * t266 + 0.58482236226346462072622386637590534819724553404280e0 * t362 * t369
  t373 = t242 * t372
  t377 = t242 * t195
  t379 = t303 * t293 * t266
  t382 = t242 * t257
  t384 = t361 * t367 * t368
  t387 = t297 + t322 + 0.4e1 * t324 * t270 - 0.4e1 * t328 * t270 + t226 * t340 + t226 * t373 + 0.19751673498613801407483339618206552048944131217655e-1 * t339 * t267 - 0.18311447306006545054854346104378990962041954983034e-3 * t377 * t379 - 0.58482236226346462072622386637590534819724553404280e0 * t382 * t384
  t396 = 0.7e1 / 0.12e2 * t76 * t41 + t124 * t67 / 0.8e1 - t124 * t70 / 0.4e1
  t397 = t360 ** 2
  t398 = 0.1e1 / t397
  t399 = t367 ** 2
  t400 = t398 * t399
  t401 = t265 ** 2
  t402 = 0.1e1 / t401
  t403 = t400 * t402
  t406 = t230 ** 2
  t407 = 0.1e1 / t406
  t408 = t58 ** 2
  t411 = 0.2e1 * t103
  t415 = f.my_piecewise3(t227, 0, 0.4e1 / 0.9e1 * t407 * t408 + 0.4e1 / 0.3e1 * t230 * t411)
  t416 = t234 ** 2
  t417 = 0.1e1 / t416
  t418 = t334 ** 2
  t421 = -t411
  t425 = f.my_piecewise3(t233, 0, 0.4e1 / 0.9e1 * t417 * t418 + 0.4e1 / 0.3e1 * t234 * t421)
  t427 = (t415 + t425) * t241
  t430 = t339 * t195
  t433 = t360 * t262
  t434 = 0.1e1 / t433
  t436 = t434 * t399 * t368
  t439 = t198 * t200
  t440 = t293 * t299
  t443 = 0.35616666666666666666666666666666666666666666666666e-1 * t439 * t440 * t320
  t444 = t242 * t198
  t445 = t294 * t384
  t449 = 0.1e1 / t8 / t4
  t450 = t200 * t449
  t454 = t293 * t346
  t458 = t345 * t249
  t459 = 0.1e1 / t458
  t460 = t244 * t459
  t461 = t352 ** 2
  t462 = t461 * t353
  t467 = 0.1e1 / t206 / t203 * t211
  t468 = t212 * t199
  t470 = 0.1e1 / t9 / t4
  t471 = t468 * t470
  t472 = t467 * t471
  t474 = t303 * t449
  t475 = t302 * t474
  t477 = t198 * t450
  t479 = t203 ** (-0.5e0)
  t480 = t479 * t211
  t481 = t480 * t471
  t483 = t310 * t474
  t486 = t213 * t199 * t470
  t488 = -0.78438333333333333333333333333333333333333333333333e0 * t472 + 0.15687666666666666666666666666666666666666666666667e1 * t475 + 0.68863333333333333333333333333333333333333333333333e0 * t477 + 0.14025833333333333333333333333333333333333333333333e0 * t481 + 0.28051666666666666666666666666666666666666666666667e0 * t483 + 0.17365833333333333333333333333333333333333333333333e0 * t486
  t489 = t488 * t353
  t492 = t345 ** 2
  t493 = 0.1e1 / t492
  t494 = t244 * t493
  t495 = t252 ** 2
  t496 = 0.1e1 / t495
  t497 = t461 * t496
  t502 = 0.14764627977777777777777777777777777777777777777777e-2 * t198 * t450 * t222
  t503 = t298 * t218
  t504 = 0.1e1 / t503
  t505 = t205 * t504
  t506 = t318 ** 2
  t507 = t506 * t319
  t509 = 0.20000000000000000000000000000000000000000000000000e1 * t505 * t507
  t516 = -0.42198333333333333333333333333333333333333333333333e0 * t472 + 0.84396666666666666666666666666666666666666666666666e0 * t475 + 0.39862222222222222222222222222222222222222222222223e0 * t477 + 0.68258333333333333333333333333333333333333333333333e-1 * t481 + 0.13651666666666666666666666666666666666666666666667e0 * t483 + 0.13692777777777777777777777777777777777777777777778e0 * t486
  t517 = t516 * t319
  t519 = 0.10000000000000000000000000000000000000000000000000e1 * t300 * t517
  t520 = t298 ** 2
  t521 = 0.1e1 / t520
  t522 = t205 * t521
  t523 = t221 ** 2
  t524 = 0.1e1 / t523
  t525 = t506 * t524
  t527 = 0.16081979498692535066756296899072713062105388428051e2 * t522 * t525
  t531 = t293 * t361
  t535 = t257 * t434
  t536 = t399 * t368
  t545 = -0.57538888888888888888888888888888888888888888888889e0 * t472 + 0.11507777777777777777777777777777777777777777777778e1 * t475 + 0.40256666666666666666666666666666666666666666666667e0 * t477 + 0.36677500000000000000000000000000000000000000000000e-1 * t481 + 0.73355000000000000000000000000000000000000000000000e-1 * t483 + 0.13797500000000000000000000000000000000000000000000e0 * t486
  t546 = t545 * t368
  t549 = t257 * t398
  t550 = t399 * t402
  t553 = -0.70983522622222222222222222222222222222222222222221e-3 * t198 * t450 * t253 - 0.34246666666666666666666666666666666666666666666666e-1 * t439 * t454 * t354 - 0.20000000000000000000000000000000000000000000000000e1 * t460 * t462 + 0.10000000000000000000000000000000000000000000000000e1 * t347 * t489 + 0.32163958997385070133512593798145426124210776856102e2 * t494 * t497 + t502 + t443 + t509 - t519 - t527 - 0.24415263074675393406472461472505321282722606644045e-3 * t198 * t450 * t266 - 0.10843581300301739842632067522386578331157260943710e-1 * t439 * t531 * t369 - 0.11696447245269292414524477327518106963944910680856e1 * t535 * t536 + 0.58482236226346462072622386637590534819724553404280e0 * t362 * t546 + 0.17315859105681463759666483083807725165579399831905e2 * t549 * t550
  t554 = t242 * t553
  t557 = t303 * t449 * t266
  t561 = t361 * t545 * t368
  t564 = -0.17315859105681463759666483083807725165579399831905e2 * t382 * t403 + 0.19751673498613801407483339618206552048944131217655e-1 * t427 * t267 - 0.36622894612013090109708692208757981924083909966068e-3 * t430 * t379 + 0.11696447245269292414524477327518106963944910680856e1 * t382 * t436 - t443 + 0.10843581300301739842632067522386578331157260943710e-1 * t444 * t445 + t226 * t554 + t519 + t527 + 0.24415263074675393406472461472505321282722606644045e-3 * t377 * t557 - 0.58482236226346462072622386637590534819724553404280e0 * t382 * t561
  t565 = t40 * t169
  t568 = t323 * t327
  t571 = 0.1e1 / t44
  t572 = t225 * t571
  t575 = t339 * t257
  t586 = t427 * t269
  t588 = t339 * t372
  t591 = -t502 + 0.12e2 * t565 * t270 - 0.32e2 * t568 * t270 + 0.20e2 * t572 * t270 - 0.11696447245269292414524477327518106963944910680856e1 * t575 * t384 - t509 + 0.8e1 * t324 * t340 + 0.8e1 * t324 * t373 - 0.8e1 * t328 * t340 - 0.8e1 * t328 * t373 + t226 * t586 + 0.2e1 * t226 * t588
  t592 = t564 + t591
  t597 = 0.1e1 - t124 * t41 / 0.8e1
  t598 = t339 * t553
  t602 = 0.1e1 / t492 / t345
  t603 = t244 * t602
  t604 = t461 * t352
  t606 = 0.1e1 / t495 / t252
  t607 = t604 * t606
  t613 = 0.1e1 / t206 / t216 * t196 / 0.4e1
  t614 = t613 * t169
  t617 = 0.1e1 / t9 / t5
  t618 = t468 * t617
  t619 = t467 * t618
  t622 = 0.1e1 / t8 / t5
  t623 = t303 * t622
  t624 = t302 * t623
  t626 = t200 * t622
  t627 = t198 * t626
  t629 = t203 ** (-0.15e1)
  t630 = t629 * t196
  t631 = t630 * t169
  t633 = t480 * t618
  t635 = t310 * t623
  t638 = t213 * t199 * t617
  t640 = -0.47063000000000000000000000000000000000000000000000e1 * t614 + 0.31375333333333333333333333333333333333333333333334e1 * t619 - 0.36604555555555555555555555555555555555555555555556e1 * t624 - 0.16068111111111111111111111111111111111111111111111e1 * t627 + 0.28051666666666666666666666666666666666666666666666e0 * t631 - 0.56103333333333333333333333333333333333333333333332e0 * t633 - 0.65453888888888888888888888888888888888888888888890e0 * t635 - 0.46308888888888888888888888888888888888888888888888e0 * t638
  t641 = t640 * t353
  t645 = 0.1e1 / t397 / t360
  t646 = t257 * t645
  t647 = t399 * t367
  t649 = 0.1e1 / t401 / t265
  t650 = t647 * t649
  t653 = t647 * t368
  t657 = 0.1e1 / t397 / t262
  t658 = t257 * t657
  t659 = t647 * t402
  t670 = -0.34523333333333333333333333333333333333333333333333e1 * t614 + 0.23015555555555555555555555555555555555555555555556e1 * t619 - 0.26851481481481481481481481481481481481481481481482e1 * t624 - 0.93932222222222222222222222222222222222222222222223e0 * t627 + 0.73355000000000000000000000000000000000000000000000e-1 * t631 - 0.14671000000000000000000000000000000000000000000000e0 * t633 - 0.17116166666666666666666666666666666666666666666667e0 * t635 - 0.36793333333333333333333333333333333333333333333333e0 * t638
  t671 = t670 * t368
  t682 = -0.25319000000000000000000000000000000000000000000000e1 * t614 + 0.16879333333333333333333333333333333333333333333333e1 * t619 - 0.19692555555555555555555555555555555555555555555555e1 * t624 - 0.93011851851851851851851851851851851851851851851854e0 * t627 + 0.13651666666666666666666666666666666666666666666667e0 * t631 - 0.27303333333333333333333333333333333333333333333333e0 * t633 - 0.31853888888888888888888888888888888888888888888890e0 * t635 - 0.36514074074074074074074074074074074074074074074075e0 * t638
  t683 = t682 * t319
  t685 = 0.10000000000000000000000000000000000000000000000000e1 * t300 * t683
  t686 = t506 * t318
  t687 = t686 * t319
  t689 = 0.60000000000000000000000000000000000000000000000000e1 * t522 * t687
  t691 = 0.1e1 / t492 / t249
  t692 = t244 * t691
  t693 = t604 * t496
  t696 = t604 * t353
  t700 = 0.1e1 / t520 / t298
  t701 = t205 * t700
  t703 = 0.1e1 / t523 / t221
  t704 = t686 * t703
  t706 = 0.51726012919273400298984252201052768390886626637712e3 * t701 * t704
  t708 = 0.1e1 / t520 / t218
  t709 = t205 * t708
  t710 = t686 * t524
  t712 = 0.96491876992155210400537781394436278372632330568306e2 * t709 * t710
  t717 = t293 * t434
  t721 = t449 * t361
  t728 = 0.20690405167709360119593700880421107356354650655085e4 * t603 * t607 + 0.10000000000000000000000000000000000000000000000000e1 * t347 * t641 + 0.10254018858216406658218194626490193680059335835414e4 * t646 * t650 + 0.35089341735807877243573431982554320891834732042568e1 * t549 * t653 - 0.10389515463408878255799889850284635099347639899143e3 * t658 * t659 + 0.58482236226346462072622386637590534819724553404280e0 * t362 * t671 - t685 - t689 - 0.19298375398431042080107556278887255674526466113661e3 * t692 * t693 + 0.60000000000000000000000000000000000000000000000000e1 * t494 * t696 - t706 + t712 + 0.10274000000000000000000000000000000000000000000000e0 * t439 * t293 * t459 * t462 + 0.32530743900905219527896202567159734993471782831130e-1 * t439 * t717 * t536 + 0.21687162600603479685264135044773156662314521887420e-1 * t439 * t721 * t369 - 0.16265371950452609763948101283579867496735891415565e-1 * t439 * t531 * t546
  t729 = t293 * t398
  t733 = t449 * t346
  t740 = t293 * t493
  t746 = 0.53424999999999999999999999999999999999999999999999e-1 * t439 * t440 * t517
  t747 = t293 * t521
  t750 = 0.85917975471764868594145516183295969534298037676861e0 * t439 * t747 * t525
  t751 = t449 * t299
  t754 = 0.71233333333333333333333333333333333333333333333331e-1 * t439 * t751 * t320
  t758 = 0.10685000000000000000000000000000000000000000000000e0 * t439 * t293 * t504 * t507
  t759 = t516 * t524
  t762 = 0.48245938496077605200268890697218139186316165284153e2 * t522 * t759 * t318
  t765 = 0.60000000000000000000000000000000000000000000000000e1 * t505 * t320 * t516
  t773 = t369 * t545
  t778 = 0.34450798614814814814814814814814814814814814814813e-2 * t198 * t626 * t222
  t779 = t545 * t402
  t780 = t779 * t367
  t789 = -0.48159733137676571081572406076840235616767705782485e0 * t439 * t729 * t550 + 0.68493333333333333333333333333333333333333333333332e-1 * t439 * t733 * t354 - 0.51369999999999999999999999999999999999999999999999e-1 * t439 * t454 * t489 - 0.16522625736956710527585419434107305400007076070979e1 * t439 * t740 * t497 + t746 + t750 - t754 - t758 - t762 + t765 + 0.96491876992155210400537781394436278372632330568306e2 * t494 * t488 * t496 * t352 - 0.60000000000000000000000000000000000000000000000000e1 * t460 * t354 * t488 - 0.35089341735807877243573431982554320891834732042568e1 * t535 * t773 - t778 + 0.51947577317044391278999449251423175496738199495715e2 * t549 * t780 + 0.16562821945185185185185185185185185185185185185185e-2 * t198 * t626 * t253 + 0.56968947174242584615102410102512416326352748836105e-3 * t198 * t626 * t266
  t790 = t728 + t789
  t791 = t242 * t790
  t794 = t361 * t670 * t368
  t797 = t427 * t257
  t803 = t657 * t647 * t402
  t807 = t398 * t647 * t368
  t811 = t645 * t647 * t649
  t818 = t427 * t372
  t823 = 0.3e1 * t226 * t598 + t226 * t791 - 0.58482236226346462072622386637590534819724553404280e0 * t382 * t794 - 0.17544670867903938621786715991277160445917366021284e1 * t797 * t384 + 0.35089341735807877243573431982554320891834732042568e1 * t575 * t436 + 0.10389515463408878255799889850284635099347639899143e3 * t382 * t803 - 0.35089341735807877243573431982554320891834732042568e1 * t382 * t807 - 0.10254018858216406658218194626490193680059335835414e4 * t382 * t811 - 0.51947577317044391278999449251423175496738199495715e2 * t575 * t403 - 0.17544670867903938621786715991277160445917366021284e1 * t575 * t561 + 0.3e1 * t226 * t818 - 0.24e2 * t328 * t588
  t825 = 0.1e1 / t406 / t21
  t829 = t407 * t58
  t832 = 0.6e1 * t171
  t836 = f.my_piecewise3(t227, 0, -0.8e1 / 0.27e2 * t825 * t408 * t58 + 0.4e1 / 0.3e1 * t829 * t411 + 0.4e1 / 0.3e1 * t230 * t832)
  t838 = 0.1e1 / t416 / t32
  t842 = t417 * t334
  t845 = -t832
  t849 = f.my_piecewise3(t233, 0, -0.8e1 / 0.27e2 * t838 * t418 * t334 + 0.4e1 / 0.3e1 * t842 * t421 + 0.4e1 / 0.3e1 * t234 * t845)
  t851 = (t836 + t849) * t241
  t852 = t851 * t269
  t858 = t40 * t327
  t861 = t323 * t571
  t868 = 0.1e1 / t7
  t869 = t225 * t868
  t878 = 0.24e2 * t170 * t270 + t226 * t852 - 0.144e3 * t858 * t270 + 0.240e3 * t861 * t270 - 0.120e3 * t869 * t270 + 0.12e2 * t324 * t586 + 0.24e2 * t324 * t588 - 0.12e2 * t328 * t586 + 0.36e2 * t565 * t340 + 0.36e2 * t565 * t373 - 0.96e2 * t568 * t373 + t685 + t689
  t883 = t398 * t367 * t779
  t886 = t427 * t195
  t890 = t434 * t367 * t546
  t896 = t303 * t622 * t266
  t899 = t706 - t712 + 0.19751673498613801407483339618206552048944131217655e-1 * t851 * t267 - 0.51947577317044391278999449251423175496738199495715e2 * t382 * t883 - 0.54934341918019635164563038313136972886125864949102e-3 * t886 * t379 + 0.35089341735807877243573431982554320891834732042568e1 * t382 * t890 + 0.73245789224026180219417384417515963848167819932136e-3 * t430 * t557 - 0.56968947174242584615102410102512416326352748836105e-3 * t377 * t896 - t746 - t750 + t754 + t758
  t900 = t450 * t384
  t903 = t294 * t403
  t906 = t339 * t198
  t909 = t294 * t436
  t912 = t294 * t561
  t925 = -0.21687162600603479685264135044773156662314521887420e-1 * t444 * t900 + 0.48159733137676571081572406076840235616767705782485e0 * t444 * t903 + 0.32530743900905219527896202567159734993471782831130e-1 * t906 * t445 - 0.32530743900905219527896202567159734993471782831130e-1 * t444 * t909 + 0.16265371950452609763948101283579867496735891415565e-1 * t444 * t912 - 0.96e2 * t568 * t340 - 0.12e2 * t328 * t554 + 0.12e2 * t324 * t554 + 0.60e2 * t572 * t373 + t762 - t765 + 0.60e2 * t572 * t340 + t778
  t927 = t823 + t878 + t899 + t925
  t943 = t80 ** 2
  t960 = t116 ** 2
  t968 = 0.3e1 / 0.2e1 * t124 * t49 * t116 - 0.119e3 / 0.3e1 * t47 * t39 + 0.28e2 * t76 * t133 + 0.14e2 * t76 * t78 * t138 - 0.3e1 * t124 / t125 / t38 * t40 * t943 + 0.6e1 * t124 * t126 * t18 * t128 + 0.9e1 / 0.2e1 * t124 * t126 * t40 * t80 * t116 - 0.6e1 * t136 * t18 * t66 * t116 - 0.3e1 / 0.4e1 * t124 * t79 * t960 - t136 * t137 * t190 - 0.119e3 / 0.3e1 * t47 * t81
  t983 = t6 ** 2
  t1008 = t18 * t327
  t1009 = -t169 + t1008
  t1010 = 0.12e2 * t1009
  t1024 = t22 ** 2
  t1027 = t97 ** 2
  t1035 = t103 ** 2
  t1042 = t33 ** 2
  t1045 = t108 ** 2
  t1053 = t112 ** 2
  t1060 = 0.6160e4 / 0.81e2 * tau0 / t14 / t147 / r0 * t25 - 0.8800e4 / 0.81e2 * t150 * t60 + 0.400e3 / 0.9e1 * t91 * t104 - 0.100e3 / 0.9e1 * t54 * t173 + 0.5e1 / 0.3e1 * t17 * t24 * t1010 - 0.5e1 / 0.3e1 * t31 * t35 * t1010 + 0.800e3 / 0.27e2 * t91 * t98 + 0.200e3 / 0.81e2 * t54 * t162 - 0.200e3 / 0.9e1 * t54 * t166 + 0.40e2 / 0.81e2 * t17 / t23 / t1024 * t1027 - 0.20e2 / 0.9e1 * t17 * t160 * t97 * t103 + 0.10e2 / 0.3e1 * t17 * t96 * t1035 + 0.40e2 / 0.9e1 * t17 * t165 * t172 + 0.40e2 / 0.81e2 * t31 / t34 / t1042 * t1045 - 0.20e2 / 0.9e1 * t31 * t177 * t108 * t112 + 0.10e2 / 0.3e1 * t31 * t107 * t1053 + 0.40e2 / 0.9e1 * t31 * t182 * t186
  t1064 = 0.238e3 / 0.3e1 * t47 * t85 - 0.14e2 * t76 * t129 + 0.4760e4 / 0.27e2 * t12 * t70 + 0.119e3 / 0.6e1 * t47 * t117 - 0.14e2 * t76 * t141 - 0.14e2 * t76 * t144 - 0.7e1 / 0.3e1 * t76 * t191 - 0.13685e5 / 0.81e2 * t2 / t9 / t983 * t41 - 0.2380e4 / 0.27e2 * t12 * t67 - 0.3e1 * t124 * t78 * t80 + t124 * t84 * t190 + t124 * t50 * t1060 / 0.8e1
  t1104 = 0.57895126195293126240322668836661767023579398340984e3 * t709 * t759 * t506
  t1116 = t461 ** 2
  t1120 = t399 ** 2
  t1127 = t545 ** 2
  t1131 = t488 ** 2
  t1136 = 0.1e1 / t397 / t433
  t1153 = 0.1e1 / t8 / t73
  t1155 = 0.1e1 / t206 / t19 * t1153 * t439 / 0.48e2
  t1157 = t613 * t327
  t1159 = t468 * t123
  t1160 = t467 * t1159
  t1163 = 0.1e1 / t8 / t6
  t1164 = t303 * t1163
  t1165 = t302 * t1164
  t1167 = t200 * t1163
  t1168 = t198 * t1167
  t1170 = t203 ** (-0.25e1)
  t1173 = t1170 * t196 * t1153 * t439
  t1175 = t630 * t327
  t1177 = t480 * t1159
  t1179 = t310 * t1164
  t1182 = t213 * t199 * t123
  t1184 = -0.28769444444444444444444444444444444444444444444444e1 * t1155 + 0.27618666666666666666666666666666666666666666666667e2 * t1157 - 0.10229135802469135802469135802469135802469135802469e2 * t1160 + 0.89504938271604938271604938271604938271604938271607e1 * t1165 + 0.31310740740740740740740740740740740740740740740741e1 * t1168 + 0.36677500000000000000000000000000000000000000000000e-1 * t1173 - 0.58684000000000000000000000000000000000000000000000e0 * t1175 + 0.65204444444444444444444444444444444444444444444445e0 * t1177 + 0.57053888888888888888888888888888888888888888888890e0 * t1179 + 0.13490888888888888888888888888888888888888888888889e1 * t1182
  t1207 = 0.11483599538271604938271604938271604938271604938271e-1 * t198 * t1167 * t222
  t1210 = 0.36000000000000000000000000000000000000000000000000e2 * t522 * t507 * t516
  t1211 = t506 ** 2
  t1214 = 0.57895126195293126240322668836661767023579398340984e3 * t701 * t1211 * t524
  t1215 = 0.12865583598954028053405037519258170449684310742441e3 * t494 * t640 * t496 * t352 + 0.69263436422725855038665932335230900662317599327620e2 * t549 * t670 * t402 * t367 - 0.24828486201251232143512441056505328827625580786102e5 * t244 / t492 / t458 * t1116 * t606 - 0.14035736694323150897429372793021728356733892817027e2 * t658 * t1120 * t368 - 0.24000000000000000000000000000000000000000000000000e2 * t692 * t1116 * t353 + 0.51947577317044391278999449251423175496738199495715e2 * t549 * t1127 * t402 + 0.96491876992155210400537781394436278372632330568306e2 * t494 * t1131 * t496 - 0.12304822629859687989861833551788232416071203002497e5 * t257 * t1136 * t1120 * t649 - 0.60000000000000000000000000000000000000000000000000e1 * t460 * t1131 * t353 - 0.35089341735807877243573431982554320891834732042568e1 * t535 * t1127 * t368 + 0.58482236226346462072622386637590534819724553404280e0 * t362 * t1184 * t368 + 0.10000000000000000000000000000000000000000000000000e1 * t347 * (-0.39219166666666666666666666666666666666666666666667e1 * t1155 + 0.37650400000000000000000000000000000000000000000000e2 * t1157 - 0.13944592592592592592592592592592592592592592592593e2 * t1160 + 0.12201518518518518518518518518518518518518518518519e2 * t1165 + 0.53560370370370370370370370370370370370370370370370e1 * t1168 + 0.14025833333333333333333333333333333333333333333333e0 * t1173 - 0.22441333333333333333333333333333333333333333333332e1 * t1175 + 0.24934814814814814814814814814814814814814814814815e1 * t1177 + 0.21817962962962962962962962962962962962962962962963e1 * t1179 + 0.16979925925925925925925925925925925925925925925926e1 * t1182) * t353 + t1104 + 0.11579025239058625248064533767332353404715879668197e4 * t603 * t1116 * t496 + t1207 - t1210 - t1214
  t1216 = t397 ** 2
  t1217 = 0.1e1 / t1216
  t1219 = t401 ** 2
  t1220 = 0.1e1 / t1219
  t1224 = t492 ** 2
  t1227 = t495 ** 2
  t1237 = 0.62071215503128080358781102641263322069063951965254e4 * t205 / t520 / t503 * t1211 * t703
  t1240 = 0.24000000000000000000000000000000000000000000000000e2 * t709 * t1211 * t319
  t1245 = 0.34367190188705947437658206473318387813719215070744e1 * t307 * t521 * t516 * t524 * t318
  t1249 = 0.42740000000000000000000000000000000000000000000000e0 * t307 * t504 * t318 * t517
  t1289 = 0.91082604192152556048340974007871726131433263376469e5 * t257 * t1217 * t1120 * t1220 + 0.19964560303604640731402349461820840981085646822122e6 * t244 / t1224 * t1116 / t1227 + t1237 + t1240 + t1245 - t1249 + 0.13012297560362087811158481026863893997388713132452e0 * t307 * t890 - 0.19263893255070628432628962430736094246707082312994e1 * t307 * t883 - 0.66090502947826842110341677736429221600028304283916e1 * t307 * t493 * t488 * t496 * t352 + 0.41096000000000000000000000000000000000000000000000e0 * t307 * t459 * t352 * t489 + 0.13218100589565368422068335547285844320005660856783e2 * t439 * t293 * t691 * t693 - 0.38025319932552508024225805073234468230220037056326e2 * t439 * t293 * t645 * t650 - 0.41096000000000000000000000000000000000000000000000e0 * t439 * t740 * t696 - 0.13012297560362087811158481026863893997388713132452e0 * t439 * t729 * t653 - 0.14171548179536397724580378856363097131945845388689e3 * t439 * t293 * t602 * t607 - 0.21309037037037037037037037037037037037037037037036e0 * t439 * t622 * t346 * t354 - 0.67471172535210825687488420139294265171645179205307e-1 * t439 * t622 * t361 * t369
  t1300 = 0.14246666666666666666666666666666666666666666666666e0 * t439 * t751 * t517
  t1304 = 0.22911460125803964958438804315545591875812810047162e1 * t439 * t449 * t521 * t525
  t1308 = 0.28493333333333333333333333333333333333333333333333e0 * t439 * t449 * t504 * t507
  t1312 = 0.68734380377411894875316412946636775627438430141488e1 * t439 * t293 * t708 * t710
  t1315 = 0.71233333333333333333333333333333333333333333333332e-1 * t439 * t440 * t683
  t1318 = 0.42740000000000000000000000000000000000000000000000e0 * t439 * t747 * t687
  t1322 = 0.36846163202829085479643115651216588683774907041596e2 * t439 * t293 * t700 * t704
  t1326 = 0.22161481481481481481481481481481481481481481481481e0 * t439 * t622 * t299 * t320
  t1352 = 0.13698666666666666666666666666666666666666666666666e0 * t439 * t733 * t489 + 0.44060335298551228073561118490952814400018869522611e1 * t439 * t449 * t493 * t497 - t1300 - t1304 + t1308 - t1312 + t1315 + t1318 + t1322 + t1326 - 0.86748650402413918741056540179092626649258087549680e-1 * t439 * t449 * t434 * t536 - 0.27397333333333333333333333333333333333333333333333e0 * t439 * t449 * t459 * t462 + 0.12842595503380418955085974953824062831138054875329e1 * t439 * t449 * t398 * t550 + 0.38527786510141256865257924861472188493414164625988e1 * t439 * t293 * t657 * t659 - 0.21687162600603479685264135044773156662314521887420e-1 * t439 * t531 * t671 + 0.43374325201206959370528270089546313324629043774840e-1 * t439 * t721 * t546 - 0.68493333333333333333333333333333333333333333333332e-1 * t439 * t454 * t641
  t1359 = t545 * t649
  t1387 = 0.80000000000000000000000000000000000000000000000000e1 * t505 * t320 * t682
  t1391 = 0.31035607751564040179390551320631661034531975982628e4 * t701 * t516 * t703 * t506
  t1395 = 0.64327917994770140267025187596290852248421553712204e2 * t522 * t682 * t524 * t318
  t1412 = 0.10000000000000000000000000000000000000000000000000e1 * t300 * (-0.21099166666666666666666666666666666666666666666667e1 * t1155 + 0.20255200000000000000000000000000000000000000000000e2 * t1157 - 0.75019259259259259259259259259259259259259259259258e1 * t1160 + 0.65641851851851851851851851851851851851851851851850e1 * t1165 + 0.31003950617283950617283950617283950617283950617285e1 * t1168 + 0.68258333333333333333333333333333333333333333333335e-1 * t1173 - 0.10921333333333333333333333333333333333333333333333e1 * t1175 + 0.12134814814814814814814814814814814814814814814815e1 * t1177 + 0.10617962962962962962962962962962962962962962962963e1 * t1179 + 0.13388493827160493827160493827160493827160493827161e1 * t1182) * t319
  t1413 = t520 ** 2
  t1416 = t523 ** 2
  t1420 = 0.24955700379505800914252936827276051226357058527653e5 * t205 / t1413 * t1211 / t1416
  t1421 = t516 ** 2
  t1424 = 0.60000000000000000000000000000000000000000000000000e1 * t505 * t1421 * t319
  t1427 = 0.48245938496077605200268890697218139186316165284153e2 * t522 * t1421 * t524
  t1428 = -0.80000000000000000000000000000000000000000000000000e1 * t460 * t354 * t640 - 0.11579025239058625248064533767332353404715879668197e4 * t692 * t497 * t488 + 0.61524113149298439949309167758941162080356015012483e4 * t646 * t1359 * t399 + 0.12414243100625616071756220528252664413812790393051e5 * t603 * t488 * t606 * t461 + 0.21053605041484726346144059189532592535100839225540e2 * t549 * t536 * t545 + 0.36000000000000000000000000000000000000000000000000e2 * t494 * t462 * t488 - 0.46785788981077169658097909310072427855779642723424e1 * t535 * t369 * t670 - 0.62337092780453269534799339101707810596085839394858e3 * t658 * t550 * t545 - 0.55209406483950617283950617283950617283950617283950e-2 * t198 * t1167 * t253 - 0.18989649058080861538367470034170805442117582945368e-2 * t198 * t1167 * t266 + t1387 - t1391 - t1395 + 0.62337092780453269534799339101707810596085839394858e3 * t646 * t1120 * t402 - t1412 - t1420 + t1424 - t1427
  t1433 = -0.480e3 * t869 * t340 - 0.1920e4 * t323 * t868 * t270 + 0.840e3 * t225 / t983 * t270 + 0.240e3 * t572 * t588 - 0.192e3 * t568 * t554 - 0.16e2 * t328 * t791 + 0.1440e4 * t40 * t571 * t270 - 0.384e3 * t1008 * t270 - 0.48e2 * t328 * t598 - 0.48e2 * t328 * t818 - t1104 + t226 * t242 * (t1215 + t1289 + t1352 + t1428)
  t1452 = 0.24e2 * t169 * t237 * t241 * t269 + 0.96e2 * t170 * t340 + 0.96e2 * t170 * t373 + 0.16e2 * t324 * t791 - 0.576e3 * t858 * t340 - 0.576e3 * t858 * t373 - 0.384e3 * t568 * t588 + 0.120e3 * t572 * t586 - t1207 + t1210 + t1214 - t1237 - t1240
  t1454 = t21 ** 2
  t1457 = t408 ** 2
  t1463 = t411 ** 2
  t1468 = 0.24e2 * t1009
  t1472 = f.my_piecewise3(t227, 0, 0.40e2 / 0.81e2 / t406 / t1454 * t1457 - 0.16e2 / 0.9e1 * t825 * t408 * t411 + 0.4e1 / 0.3e1 * t407 * t1463 + 0.16e2 / 0.9e1 * t829 * t832 + 0.4e1 / 0.3e1 * t230 * t1468)
  t1473 = t32 ** 2
  t1476 = t418 ** 2
  t1482 = t421 ** 2
  t1491 = f.my_piecewise3(t233, 0, 0.40e2 / 0.81e2 / t416 / t1473 * t1476 - 0.16e2 / 0.9e1 * t838 * t418 * t421 + 0.4e1 / 0.3e1 * t417 * t1482 + 0.16e2 / 0.9e1 * t842 * t845 - 0.4e1 / 0.3e1 * t234 * t1468)
  t1493 = (t1472 + t1491) * t241
  t1506 = 0.19751673498613801407483339618206552048944131217655e-1 * t1493 * t267 - t1245 + t1249 + 0.144e3 * t565 * t588 + 0.72e2 * t565 * t554 + 0.960e3 * t861 * t340 - 0.192e3 * t568 * t586 + 0.72e2 * t565 * t586 + t1300 + t1304 - t1308 + t1312
  t1537 = -t1315 - t1318 - t1322 - t1326 - 0.69263436422725855038665932335230900662317599327620e2 * t382 * t398 * t670 * t402 * t367 + 0.46785788981077169658097909310072427855779642723424e1 * t382 * t434 * t670 * t369 - 0.73245789224026180219417384417515963848167819932136e-3 * t851 * t195 * t379 + 0.14035736694323150897429372793021728356733892817027e2 * t575 * t890 - 0.20779030926817756511599779700569270198695279798286e3 * t575 * t883 - 0.61524113149298439949309167758941162080356015012483e4 * t382 * t645 * t399 * t1359 - 0.22787578869697033846040964041004966530541099534442e-2 * t430 * t896 + 0.18989649058080861538367470034170805442117582945368e-2 * t377 * t303 * t1163 * t266 + 0.62337092780453269534799339101707810596085839394858e3 * t382 * t657 * t399 * t779
  t1571 = 0.14649157844805236043883476883503192769633563986427e-2 * t886 * t557 - 0.21053605041484726346144059189532592535100839225540e2 * t382 * t400 * t546 + 0.38025319932552508024225805073234468230220037056326e2 * t444 * t294 * t811 - 0.43374325201206959370528270089546313324629043774840e-1 * t444 * t450 * t561 + 0.67471172535210825687488420139294265171645179205307e-1 * t444 * t626 * t384 - 0.86748650402413918741056540179092626649258087549680e-1 * t906 * t900 - 0.13012297560362087811158481026863893997388713132452e0 * t906 * t909 + 0.86748650402413918741056540179092626649258087549680e-1 * t444 * t450 * t436 + 0.13012297560362087811158481026863893997388713132452e0 * t444 * t294 * t807 + 0.65061487801810439055792405134319469986943565662260e-1 * t427 * t198 * t445 + 0.65061487801810439055792405134319469986943565662260e-1 * t906 * t912 + 0.19263893255070628432628962430736094246707082312995e1 * t906 * t903
  t1602 = -0.38527786510141256865257924861472188493414164625988e1 * t444 * t294 * t803 + 0.21687162600603479685264135044773156662314521887420e-1 * t444 * t294 * t794 - 0.12842595503380418955085974953824062831138054875329e1 * t444 * t450 * t403 - t1387 + t1391 + 0.48e2 * t324 * t598 + t1395 + 0.4e1 * t226 * t339 * t790 - 0.58482236226346462072622386637590534819724553404280e0 * t382 * t361 * t1184 * t368 + 0.70178683471615754487146863965108641783669464085136e1 * t797 * t436 + 0.14035736694323150897429372793021728356733892817027e2 * t382 * t657 * t1120 * t368 - 0.14035736694323150897429372793021728356733892817027e2 * t575 * t807 - 0.91082604192152556048340974007871726131433263376469e5 * t382 * t1217 * t1120 * t1220
  t1638 = -0.41016075432865626632872778505960774720237343341655e4 * t575 * t811 + 0.12304822629859687989861833551788232416071203002497e5 * t382 * t1136 * t1120 * t649 + 0.41558061853635513023199559401138540397390559596572e3 * t575 * t803 + 0.35089341735807877243573431982554320891834732042568e1 * t382 * t434 * t1127 * t368 - 0.51947577317044391278999449251423175496738199495715e2 * t382 * t398 * t1127 * t402 - 0.23392894490538584829048954655036213927889821361712e1 * t575 * t794 - 0.10389515463408878255799889850284635099347639899143e3 * t797 * t403 - 0.35089341735807877243573431982554320891834732042568e1 * t797 * t561 - 0.23392894490538584829048954655036213927889821361712e1 * t851 * t257 * t384 - 0.62337092780453269534799339101707810596085839394858e3 * t382 * t645 * t1120 * t402 + 0.6e1 * t226 * t427 * t553 + 0.48e2 * t324 * t818
  t1654 = t242 * t439
  t1661 = 0.4e1 * t226 * t851 * t372 + 0.960e3 * t861 * t373 + 0.16e2 * t324 * t852 - 0.16e2 * t328 * t852 + t226 * t1493 * t269 - 0.480e3 * t869 * t373 + t1412 + t1420 - t1424 + t1427 + 0.120e3 * t572 * t554 - 0.13012297560362087811158481026863893997388713132452e0 * t1654 * t717 * t773 + 0.19263893255070628432628962430736094246707082312995e1 * t1654 * t729 * t780
  d1111 = 0.4e1 * t194 * t274 + 0.12e2 * t291 * t387 + 0.12e2 * t396 * t592 + 0.4e1 * t597 * t927 + t3 * (t968 + t1064) * t274 + 0.4e1 * t3 * t194 * t387 + 0.6e1 * t3 * t291 * t592 + 0.4e1 * t3 * t396 * t927 + t3 * t597 * (t1433 + t1452 + t1506 + t1537 + t1571 + t1602 + t1638 + t1661)

  res = {'v4rho4': d1111}
  return res
