"""Generated from mgga_c_kcis.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcis_beta * jnp.log(1 + kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 0))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcis_beta * jnp.log(1 + 2 ** (-1 / 3) * kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 1))))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcis_beta * jnp.log(1 + kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 0))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcis_beta * jnp.log(1 + 2 ** (-1 / 3) * kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 1))))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcis_beta * jnp.log(1 + kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 0))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcis_beta * jnp.log(1 + 2 ** (-1 / 3) * kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 1))))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t13 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t23 = 0.1e1 / t22
  t24 = t5 * t23
  t25 = t21 * t24
  t27 = 0.23615790870000000000000000000000000000000000000000e0 * t14 + 0.55771035800000000000000000000000000000000000000000e-1 * t11 + 0.12733319050000000000000000000000000000000000000000e-1 * t17 + 0.76629987700000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t33 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = t33 * f.p.zeta_threshold
  t35 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t34, 1)
  t38 = 2 ** (0.1e1 / 0.3e1)
  t41 = 0.1e1 / (0.2e1 * t38 - 0.2e1)
  t42 = (0.2e1 * t35 - 0.2e1) * t41
  t44 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t11
  t49 = 0.17489865900000000000000000000000000000000000000000e0 * t14 + 0.30591644850000000000000000000000000000000000000000e-1 * t11 + 0.37162376550000000000000000000000000000000000000000e-2 * t17 + 0.41939708850000000000000000000000000000000000000000e-2 * t25
  t51 = 0.1e1 + 0.1e1 / t49
  t52 = jnp.log(t51)
  t53 = t44 * t52
  t54 = t42 * t53
  t56 = -t31 + 0.58482233974552040708313425006184496242808878304904e0 * t54
  t58 = s0 + 0.2e1 * s1 + s2
  t59 = t38 * t58
  t60 = t7 ** 2
  t62 = 0.1e1 / t8 / t60
  t64 = 0.1e1 / t3
  t65 = t19 * t64
  t66 = 0.0e0 < t56
  t68 = f.my_piecewise3(t66, t56, -t56)
  t70 = t5 / t68
  t71 = t65 * t70
  t74 = 0.1e1 + t59 * t62 * t71 / 0.96e2
  t75 = jnp.log(t74)
  t77 = 0.1e1 + 0.66725e-1 * t75
  t78 = 0.1e1 / t77
  t81 = t1 / t20
  t82 = t81 * t6
  t84 = 0.1e1 / t8 / t7
  t85 = 0.1e1 / t7
  t86 = t2 * t85
  t89 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t14 + 0.12382500000000000000000000000000000000000000000000e-1 * t11
  t92 = 0.1e1 + t14 * t89 / 0.2e1
  t93 = t92 ** 2
  t94 = 0.1e1 / t93
  t99 = t1 * t3 * t2
  t100 = t6 * t84
  t101 = t99 * t100
  t104 = t19 * t20 * t2
  t106 = 0.1e1 / t22 / t7
  t107 = t5 * t106
  t108 = t104 * t107
  t110 = jnp.pi ** 2
  t111 = 0.1e1 / t110
  t112 = 0.1e1 / t60
  t113 = t111 * t112
  t116 = t1 * t3 * t111
  t117 = t6 * t62
  t118 = t116 * t117
  t120 = -0.18780000000000000000000000000000000000000000000000e-1 * t86 + 0.13173750000000000000000000000000000000000000000000e-2 * t101 - 0.23775000000000000000000000000000000000000000000000e-3 * t108 + 0.63900000000000000000000000000000000000000000000000e-4 * t113 - 0.54014062500000000000000000000000000000000000000000e-6 * t118
  t122 = 0.36798313500000000000000000000000000000000000000000e-2 * t86 * t94 - t56 * t120
  t123 = t84 * t122
  t124 = 4 ** (0.1e1 / 0.6e1)
  t125 = t81 * t124
  t126 = t14 * t11
  t127 = t22 * t126
  t128 = 0.1e1 / t92
  t132 = t56 ** 2
  t134 = 0.19711289000000000000000000000000000000000000000000e-2 * t125 * t127 * t128 - 0.2e1 * t132
  t135 = 0.1e1 / t134
  t136 = t135 * t58
  t138 = t82 * t123 * t136
  t140 = t56 * t78 + 0.99491666666666666666666666666666666666666666666666e-2 * t138
  t143 = -0.2e1 * t31 + 0.11696446794910408141662685001236899248561775660981e1 * t54
  t144 = jnp.sqrt(0.4e1)
  t145 = t143 * t144
  t146 = t126 * t128
  t149 = t6 * t22
  t153 = 0.30956250000000000000000000000000000000000000000000e-2 * t145 * t146 - 0.79593333333333333333333333333333333333333333333333e-1 * t81 * t149 * t120
  t154 = t153 * t135
  t155 = t58 * t112
  t156 = t154 * t155
  t158 = t122 * t135
  t159 = t58 ** 2
  t160 = t60 ** 2
  t161 = 0.1e1 / t160
  t162 = t159 * t161
  t163 = t158 * t162
  t165 = 0.1e1 + t156 / 0.8e1 - t163 / 0.64e2
  t166 = 0.1e1 / t165
  t167 = t140 * t166
  t168 = r0 - r1
  t169 = t168 * t85
  t170 = 0.1e1 + t169
  t171 = t170 <= f.p.zeta_threshold
  t172 = t170 ** (0.1e1 / 0.3e1)
  t174 = f.my_piecewise3(t171, t34, t172 * t170)
  t175 = 0.1e1 - t169
  t176 = t175 <= f.p.zeta_threshold
  t177 = t175 ** (0.1e1 / 0.3e1)
  t179 = f.my_piecewise3(t176, t34, t177 * t175)
  t181 = (t174 + t179 - 0.2e1) * t41
  t184 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t34, 0.2e1 * t38)
  t186 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t34, 0)
  t188 = (t184 + t186 - 0.2e1) * t41
  t190 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t11
  t195 = 0.21947830050000000000000000000000000000000000000000e0 * t14 + 0.48171623250000000000000000000000000000000000000000e-1 * t11 + 0.13081894750000000000000000000000000000000000000000e-1 * t17 + 0.48591338250000000000000000000000000000000000000000e-2 * t25
  t197 = 0.1e1 + 0.1e1 / t195
  t198 = jnp.log(t197)
  t205 = -t31 + t188 * (-t190 * t198 + t31 - 0.58482233974552040708313425006184496242808878304904e0 * t53) + 0.58482233974552040708313425006184496242808878304904e0 * t188 * t53
  t207 = t58 * t62 * t19
  t208 = t64 * t5
  t209 = 0.0e0 < t205
  t211 = f.my_piecewise3(t209, t205, -t205)
  t212 = 0.1e1 / t211
  t213 = t208 * t212
  t216 = 0.1e1 + t207 * t213 / 0.96e2
  t217 = jnp.log(t216)
  t219 = 0.1e1 + 0.66725e-1 * t217
  t220 = 0.1e1 / t219
  t223 = t205 * t220 + 0.69644166666666666666666666666666666666666666666666e-2 * t138
  t226 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t156 - 0.40468750000000000000000000000000000000000000000000e-1 * t163
  t227 = 0.1e1 / t226
  t229 = t223 * t227 - t167
  t230 = t181 * t229
  t231 = 0.1e1 / r0
  t232 = s0 * t231
  t233 = 0.1e1 / tau0
  t234 = f.my_piecewise3(t171, f.p.zeta_threshold, t170)
  t235 = t233 * t234
  t236 = t4 * t6
  t237 = t9 * t38
  t238 = 0.1e1 / t170
  t239 = t238 ** (0.1e1 / 0.3e1)
  t241 = t236 * t237 * t239
  t243 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t241
  t244 = jnp.sqrt(t241)
  t247 = t241 ** 0.15e1
  t249 = t21 * t5
  t250 = t38 ** 2
  t251 = t23 * t250
  t252 = t239 ** 2
  t254 = t249 * t251 * t252
  t256 = 0.23615790870000000000000000000000000000000000000000e0 * t244 + 0.55771035800000000000000000000000000000000000000000e-1 * t241 + 0.12733319050000000000000000000000000000000000000000e-1 * t247 + 0.76629987700000000000000000000000000000000000000000e-2 * t254
  t258 = 0.1e1 + 0.1e1 / t256
  t259 = jnp.log(t258)
  t260 = t243 * t259
  t262 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t241
  t267 = 0.17489865900000000000000000000000000000000000000000e0 * t244 + 0.30591644850000000000000000000000000000000000000000e-1 * t241 + 0.37162376550000000000000000000000000000000000000000e-2 * t247 + 0.41939708850000000000000000000000000000000000000000e-2 * t254
  t269 = 0.1e1 + 0.1e1 / t267
  t270 = jnp.log(t269)
  t271 = t262 * t270
  t272 = t42 * t271
  t274 = -t260 + 0.58482233974552040708313425006184496242808878304904e0 * t272
  t275 = r0 ** 2
  t276 = r0 ** (0.1e1 / 0.3e1)
  t277 = t276 ** 2
  t279 = 0.1e1 / t277 / t275
  t280 = s0 * t279
  t281 = t280 * t65
  t282 = t5 * t8
  t283 = 0.1e1 / t239
  t284 = 0.0e0 < t274
  t286 = f.my_piecewise3(t284, t274, -t274)
  t287 = 0.1e1 / t286
  t288 = t283 * t287
  t289 = t282 * t288
  t292 = 0.1e1 + t281 * t289 / 0.96e2
  t293 = jnp.log(t292)
  t295 = 0.1e1 + 0.66725e-1 * t293
  t296 = 0.1e1 / t295
  t299 = t81 * t149 * t250
  t300 = 0.1e1 / t252
  t303 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t244 + 0.12382500000000000000000000000000000000000000000000e-1 * t241
  t306 = 0.1e1 + t244 * t303 / 0.2e1
  t307 = t306 ** 2
  t308 = 0.1e1 / t307
  t309 = t238 * t308
  t314 = t99 * t6
  t315 = t84 * t38
  t316 = t239 * t238
  t320 = t104 * t5
  t321 = t106 * t250
  t322 = t252 * t238
  t326 = t170 ** 2
  t327 = 0.1e1 / t326
  t330 = t116 * t6
  t331 = t62 * t38
  t332 = t239 * t327
  t336 = -0.37560000000000000000000000000000000000000000000000e-1 * t86 * t238 + 0.26347500000000000000000000000000000000000000000000e-2 * t314 * t315 * t316 - 0.47550000000000000000000000000000000000000000000000e-3 * t320 * t321 * t322 + 0.25560000000000000000000000000000000000000000000000e-3 * t113 * t327 - 0.21605625000000000000000000000000000000000000000000e-5 * t330 * t331 * t332
  t338 = 0.73596627000000000000000000000000000000000000000000e-2 * t86 * t309 - t274 * t336
  t339 = t300 * t338
  t340 = t124 * t22
  t341 = t81 * t340
  t342 = t38 * t300
  t343 = t244 * t241
  t344 = 0.1e1 / t306
  t345 = t343 * t344
  t346 = t342 * t345
  t349 = t274 ** 2
  t351 = 0.98556445000000000000000000000000000000000000000000e-3 * t341 * t346 - 0.2e1 * t349
  t352 = 0.1e1 / t351
  t353 = t339 * t352
  t354 = t7 * t170
  t355 = t354 ** (0.1e1 / 0.3e1)
  t356 = t355 ** 2
  t357 = t280 * t356
  t358 = t353 * t357
  t359 = t299 * t358
  t361 = t274 * t296 + 0.24872916666666666666666666666666666666666666666667e-2 * t359
  t365 = (-0.2e1 * t260 + 0.11696446794910408141662685001236899248561775660981e1 * t272) * t144
  t368 = t22 * t38
  t369 = t300 * t336
  t373 = 0.30956250000000000000000000000000000000000000000000e-2 * t365 * t345 - 0.39796666666666666666666666666666666666666666666667e-1 * t82 * t368 * t369
  t374 = t373 * t352
  t375 = t374 * s0
  t376 = t279 * t38
  t377 = t376 * t356
  t378 = t375 * t377
  t380 = t338 * t352
  t381 = s0 ** 2
  t382 = t380 * t381
  t383 = t275 ** 2
  t387 = 0.1e1 / t276 / t383 / r0 * t250
  t388 = t355 * t354
  t389 = t387 * t388
  t390 = t382 * t389
  t392 = 0.1e1 + t378 / 0.16e2 - t390 / 0.256e3
  t393 = 0.1e1 / t392
  t394 = t361 * t393
  t396 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t241
  t401 = 0.21947830050000000000000000000000000000000000000000e0 * t244 + 0.48171623250000000000000000000000000000000000000000e-1 * t241 + 0.13081894750000000000000000000000000000000000000000e-1 * t247 + 0.48591338250000000000000000000000000000000000000000e-2 * t254
  t403 = 0.1e1 + 0.1e1 / t401
  t404 = jnp.log(t403)
  t411 = -t260 + t188 * (-t396 * t404 + t260 - 0.58482233974552040708313425006184496242808878304904e0 * t271) + 0.58482233974552040708313425006184496242808878304904e0 * t188 * t271
  t412 = t250 * s0
  t413 = t279 * t19
  t414 = t412 * t413
  t416 = 0.0e0 < t411
  t418 = f.my_piecewise3(t416, t411, -t411)
  t419 = 0.1e1 / t418
  t421 = t208 * t8 * t283 * t419
  t424 = 0.1e1 + t414 * t421 / 0.192e3
  t425 = jnp.log(t424)
  t427 = 0.1e1 + 0.66725e-1 * t425
  t428 = 0.1e1 / t427
  t431 = t411 * t428 + 0.17411041666666666666666666666666666666666666666667e-2 * t359
  t434 = 0.1e1 + 0.93750000000000000000000000000000000000000000000000e-1 * t378 - 0.10117187500000000000000000000000000000000000000000e-1 * t390
  t435 = 0.1e1 / t434
  t439 = t394 + t188 * (t431 * t435 - t394)
  t440 = t235 * t439
  t442 = t232 * t440 / 0.16e2
  t443 = 0.1e1 / r1
  t444 = s2 * t443
  t445 = 0.1e1 / tau1
  t446 = f.my_piecewise3(t176, f.p.zeta_threshold, t175)
  t447 = t445 * t446
  t448 = 0.1e1 / t175
  t449 = t448 ** (0.1e1 / 0.3e1)
  t451 = t236 * t237 * t449
  t453 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t451
  t454 = jnp.sqrt(t451)
  t457 = t451 ** 0.15e1
  t459 = t449 ** 2
  t461 = t249 * t251 * t459
  t463 = 0.23615790870000000000000000000000000000000000000000e0 * t454 + 0.55771035800000000000000000000000000000000000000000e-1 * t451 + 0.12733319050000000000000000000000000000000000000000e-1 * t457 + 0.76629987700000000000000000000000000000000000000000e-2 * t461
  t465 = 0.1e1 + 0.1e1 / t463
  t466 = jnp.log(t465)
  t467 = t453 * t466
  t469 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t451
  t474 = 0.17489865900000000000000000000000000000000000000000e0 * t454 + 0.30591644850000000000000000000000000000000000000000e-1 * t451 + 0.37162376550000000000000000000000000000000000000000e-2 * t457 + 0.41939708850000000000000000000000000000000000000000e-2 * t461
  t476 = 0.1e1 + 0.1e1 / t474
  t477 = jnp.log(t476)
  t478 = t469 * t477
  t479 = t42 * t478
  t481 = -t467 + 0.58482233974552040708313425006184496242808878304904e0 * t479
  t482 = r1 ** 2
  t483 = r1 ** (0.1e1 / 0.3e1)
  t484 = t483 ** 2
  t486 = 0.1e1 / t484 / t482
  t487 = s2 * t486
  t488 = t487 * t65
  t489 = 0.1e1 / t449
  t490 = 0.0e0 < t481
  t492 = f.my_piecewise3(t490, t481, -t481)
  t493 = 0.1e1 / t492
  t494 = t489 * t493
  t495 = t282 * t494
  t498 = 0.1e1 + t488 * t495 / 0.96e2
  t499 = jnp.log(t498)
  t501 = 0.1e1 + 0.66725e-1 * t499
  t502 = 0.1e1 / t501
  t504 = 0.1e1 / t459
  t507 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t454 + 0.12382500000000000000000000000000000000000000000000e-1 * t451
  t510 = 0.1e1 + t454 * t507 / 0.2e1
  t511 = t510 ** 2
  t512 = 0.1e1 / t511
  t513 = t448 * t512
  t518 = t449 * t448
  t522 = t459 * t448
  t526 = t175 ** 2
  t527 = 0.1e1 / t526
  t530 = t449 * t527
  t534 = -0.37560000000000000000000000000000000000000000000000e-1 * t86 * t448 + 0.26347500000000000000000000000000000000000000000000e-2 * t314 * t315 * t518 - 0.47550000000000000000000000000000000000000000000000e-3 * t320 * t321 * t522 + 0.25560000000000000000000000000000000000000000000000e-3 * t113 * t527 - 0.21605625000000000000000000000000000000000000000000e-5 * t330 * t331 * t530
  t536 = 0.73596627000000000000000000000000000000000000000000e-2 * t86 * t513 - t481 * t534
  t537 = t504 * t536
  t538 = t38 * t504
  t539 = t454 * t451
  t540 = 0.1e1 / t510
  t541 = t539 * t540
  t542 = t538 * t541
  t545 = t481 ** 2
  t547 = 0.98556445000000000000000000000000000000000000000000e-3 * t341 * t542 - 0.2e1 * t545
  t548 = 0.1e1 / t547
  t549 = t537 * t548
  t550 = t7 * t175
  t551 = t550 ** (0.1e1 / 0.3e1)
  t552 = t551 ** 2
  t553 = t487 * t552
  t554 = t549 * t553
  t555 = t299 * t554
  t557 = t481 * t502 + 0.24872916666666666666666666666666666666666666666667e-2 * t555
  t561 = (-0.2e1 * t467 + 0.11696446794910408141662685001236899248561775660981e1 * t479) * t144
  t564 = t504 * t534
  t568 = 0.30956250000000000000000000000000000000000000000000e-2 * t561 * t541 - 0.39796666666666666666666666666666666666666666666667e-1 * t82 * t368 * t564
  t569 = t568 * t548
  t570 = t569 * s2
  t571 = t486 * t38
  t572 = t571 * t552
  t573 = t570 * t572
  t575 = t536 * t548
  t576 = s2 ** 2
  t577 = t575 * t576
  t578 = t482 ** 2
  t582 = 0.1e1 / t483 / t578 / r1 * t250
  t583 = t551 * t550
  t584 = t582 * t583
  t585 = t577 * t584
  t587 = 0.1e1 + t573 / 0.16e2 - t585 / 0.256e3
  t588 = 0.1e1 / t587
  t589 = t557 * t588
  t591 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t451
  t596 = 0.21947830050000000000000000000000000000000000000000e0 * t454 + 0.48171623250000000000000000000000000000000000000000e-1 * t451 + 0.13081894750000000000000000000000000000000000000000e-1 * t457 + 0.48591338250000000000000000000000000000000000000000e-2 * t461
  t598 = 0.1e1 + 0.1e1 / t596
  t599 = jnp.log(t598)
  t606 = -t467 + t188 * (-t591 * t599 + t467 - 0.58482233974552040708313425006184496242808878304904e0 * t478) + 0.58482233974552040708313425006184496242808878304904e0 * t188 * t478
  t607 = t250 * s2
  t608 = t486 * t19
  t609 = t607 * t608
  t611 = 0.0e0 < t606
  t613 = f.my_piecewise3(t611, t606, -t606)
  t614 = 0.1e1 / t613
  t616 = t208 * t8 * t489 * t614
  t619 = 0.1e1 + t609 * t616 / 0.192e3
  t620 = jnp.log(t619)
  t622 = 0.1e1 + 0.66725e-1 * t620
  t623 = 0.1e1 / t622
  t626 = t606 * t623 + 0.17411041666666666666666666666666666666666666666667e-2 * t555
  t629 = 0.1e1 + 0.93750000000000000000000000000000000000000000000000e-1 * t573 - 0.10117187500000000000000000000000000000000000000000e-1 * t585
  t630 = 0.1e1 / t629
  t634 = t589 + t188 * (t626 * t630 - t589)
  t635 = t447 * t634
  t637 = t444 * t635 / 0.16e2
  t639 = t4 * t100 * t30
  t640 = 0.11073577833333333333333333333333333333333333333333e-2 * t639
  t641 = t27 ** 2
  t644 = 0.1e1 / t14
  t646 = t3 * t6
  t647 = t646 * t84
  t648 = t644 * t1 * t647
  t650 = t4 * t100
  t652 = t11 ** 0.5e0
  t654 = t652 * t1 * t647
  t656 = t21 * t107
  t661 = t13 / t641 * (-0.39359651450000000000000000000000000000000000000000e-1 * t648 - 0.18590345266666666666666666666666666666666666666667e-1 * t650 - 0.63666595250000000000000000000000000000000000000000e-2 * t654 - 0.51086658466666666666666666666666666666666666666667e-2 * t656) / t29
  t664 = t646 * t84 * t52
  t665 = t42 * t1 * t664
  t668 = t49 ** 2
  t669 = 0.1e1 / t668
  t674 = -0.29149776500000000000000000000000000000000000000000e-1 * t648 - 0.10197214950000000000000000000000000000000000000000e-1 * t650 - 0.18581188275000000000000000000000000000000000000000e-2 * t654 - 0.27959805900000000000000000000000000000000000000000e-2 * t656
  t676 = 0.1e1 / t51
  t677 = t669 * t674 * t676
  t678 = t42 * t44 * t677
  t680 = t640 + t661 - 0.18311555036753159941307229983139571945136646663793e-3 * t665 - 0.58482233974552040708313425006184496242808878304904e0 * t678
  t682 = t77 ** 2
  t684 = t56 / t682
  t685 = t60 * t7
  t687 = 0.1e1 / t8 / t685
  t691 = t62 * t19
  t693 = t68 ** 2
  t696 = f.my_piecewise3(t66, t680, -t680)
  t702 = 0.1e1 / t74
  t708 = t82 * t62 * t122 * t136
  t710 = t2 * t112
  t724 = -t644 * t89 * t1 * t647 / 0.12e2 + t14 * (-0.66066666666666666666666666666666666666666666666667e-2 * t648 - 0.41275000000000000000000000000000000000000000000000e-2 * t650) / 0.2e1
  t733 = 0.1e1 / t22 / t60
  t737 = 0.1e1 / t685
  t738 = t111 * t737
  t743 = 0.18780000000000000000000000000000000000000000000000e-1 * t710 - 0.17565000000000000000000000000000000000000000000000e-2 * t99 * t117 + 0.39625000000000000000000000000000000000000000000000e-3 * t104 * t5 * t733 - 0.12780000000000000000000000000000000000000000000000e-3 * t738 + 0.12603281250000000000000000000000000000000000000000e-5 * t116 * t6 * t687
  t745 = -0.36798313500000000000000000000000000000000000000000e-2 * t710 * t94 - 0.73596627000000000000000000000000000000000000000000e-2 * t86 / t93 / t92 * t724 - t680 * t120 - t56 * t743
  t748 = t82 * t84 * t745 * t136
  t751 = t134 ** 2
  t752 = 0.1e1 / t751
  t753 = t122 * t752
  t758 = t124 ** 2
  t759 = t758 ** 2
  t772 = 0.13140859333333333333333333333333333333333333333333e-2 * t125 * t9 * t126 * t128 - 0.98556445000000000000000000000000000000000000000000e-3 * t65 * t759 * t124 * t23 * t14 * t128 - 0.19711289000000000000000000000000000000000000000000e-2 * t125 * t127 * t94 * t724 - 0.4e1 * t56 * t680
  t775 = t81 * t100 * t753 * t58 * t772
  t778 = (t680 * t78 - 0.66725e-1 * t684 * (-0.7e1 / 0.288e3 * t59 * t687 * t71 - t59 * t691 * t208 / t693 * t696 / 0.96e2) * t702 - 0.13265555555555555555555555555555555555555555555555e-1 * t708 + 0.99491666666666666666666666666666666666666666666666e-2 * t748 - 0.99491666666666666666666666666666666666666666666666e-2 * t775) * t166
  t779 = t165 ** 2
  t781 = t140 / t779
  t809 = (0.30956250000000000000000000000000000000000000000000e-2 * (0.22147155666666666666666666666666666666666666666666e-2 * t639 + 0.2e1 * t661 - 0.36623110073506319882614459966279143890273293327587e-3 * t665 - 0.11696446794910408141662685001236899248561775660981e1 * t678) * t144 * t146 - 0.61912500000000000000000000000000000000000000000000e-2 * t143 * t124 * t14 * t128 * t1 * t3 * t84 - 0.30956250000000000000000000000000000000000000000000e-2 * t145 * t126 * t94 * t724 - 0.53062222222222222222222222222222222222222222222222e-1 * t81 * t10 * t120 - 0.79593333333333333333333333333333333333333333333333e-1 * t81 * t149 * t743) * t135 * t155
  t813 = t153 * t752 * t155 * t772
  t816 = t154 * t58 * t737
  t819 = t745 * t135 * t162
  t822 = t753 * t162 * t772
  t827 = t158 * t159 / t160 / t7
  t830 = t781 * (t809 / 0.8e1 - t813 / 0.8e1 - t816 / 0.4e1 - t819 / 0.64e2 + t822 / 0.64e2 + t827 / 0.16e2)
  t831 = t168 * t112
  t832 = t85 - t831
  t835 = f.my_piecewise3(t171, 0, 0.4e1 / 0.3e1 * t172 * t832)
  t836 = -t832
  t839 = f.my_piecewise3(t176, 0, 0.4e1 / 0.3e1 * t177 * t836)
  t846 = t195 ** 2
  t872 = t640 + t661 + t188 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t100 * t198 + t190 / t846 * (-0.36579716750000000000000000000000000000000000000000e-1 * t648 - 0.16057207750000000000000000000000000000000000000000e-1 * t650 - 0.65409473750000000000000000000000000000000000000000e-2 * t654 - 0.32394225500000000000000000000000000000000000000000e-2 * t656) / t197 - t640 - t661 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t100 * t52 + 0.58482233974552040708313425006184496242808878304904e0 * t44 * t669 * t674 * t676) - 0.18311555036753159941307229983139571945136646663793e-3 * t188 * t1 * t664 - 0.58482233974552040708313425006184496242808878304904e0 * t188 * t44 * t677
  t874 = t219 ** 2
  t876 = t205 / t874
  t881 = t211 ** 2
  t884 = f.my_piecewise3(t209, t872, -t872)
  t890 = 0.1e1 / t216
  t899 = t226 ** 2
  t901 = t223 / t899
  t911 = t181 * ((t872 * t220 - 0.66725e-1 * t876 * (-0.7e1 / 0.288e3 * t58 * t687 * t19 * t213 - t207 * t208 / t881 * t884 / 0.96e2) * t890 - 0.92858888888888888888888888888888888888888888888888e-2 * t708 + 0.69644166666666666666666666666666666666666666666666e-2 * t748 - 0.69644166666666666666666666666666666666666666666666e-2 * t775) * t227 - t901 * (0.18750000000000000000000000000000000000000000000000e0 * t809 - 0.18750000000000000000000000000000000000000000000000e0 * t813 - 0.37500000000000000000000000000000000000000000000000e0 * t816 - 0.40468750000000000000000000000000000000000000000000e-1 * t819 + 0.40468750000000000000000000000000000000000000000000e-1 * t822 + 0.16187500000000000000000000000000000000000000000000e0 * t827) - t778 + t830)
  t916 = f.my_piecewise3(t171, 0, t832)
  t922 = t236 * t315 * t239
  t923 = 0.11073577833333333333333333333333333333333333333333e-2 * t922
  t924 = t327 * t832
  t926 = t11 * t342 * t924
  t929 = (-t923 - 0.11073577833333333333333333333333333333333333333333e-2 * t926) * t259
  t930 = t256 ** 2
  t932 = t243 / t930
  t933 = 0.1e1 / t244
  t935 = -t922 / 0.3e1 - t926 / 0.3e1
  t936 = t933 * t935
  t938 = 0.18590345266666666666666666666666666666666666666667e-1 * t922
  t940 = t241 ** 0.5e0
  t941 = t940 * t935
  t944 = t249 * t321 * t252
  t945 = 0.51086658466666666666666666666666666666666666666667e-2 * t944
  t946 = t250 * t283
  t948 = t25 * t946 * t924
  t951 = 0.1e1 / t258
  t953 = t932 * (0.11807895435000000000000000000000000000000000000000e0 * t936 - t938 - 0.18590345266666666666666666666666666666666666666667e-1 * t926 + 0.19099978575000000000000000000000000000000000000000e-1 * t941 - t945 - 0.51086658466666666666666666666666666666666666666667e-2 * t948) * t951
  t954 = 0.31311312500000000000000000000000000000000000000000e-3 * t922
  t957 = (-t954 - 0.31311312500000000000000000000000000000000000000000e-3 * t926) * t270
  t958 = t42 * t957
  t960 = t42 * t262
  t961 = t267 ** 2
  t962 = 0.1e1 / t961
  t964 = 0.10197214950000000000000000000000000000000000000000e-1 * t922
  t967 = 0.27959805900000000000000000000000000000000000000000e-2 * t944
  t969 = 0.87449329500000000000000000000000000000000000000000e-1 * t936 - t964 - 0.10197214950000000000000000000000000000000000000000e-1 * t926 + 0.55743564825000000000000000000000000000000000000000e-2 * t941 - t967 - 0.27959805900000000000000000000000000000000000000000e-2 * t948
  t971 = 0.1e1 / t269
  t972 = t962 * t969 * t971
  t973 = t960 * t972
  t975 = -t929 + t953 + 0.58482233974552040708313425006184496242808878304904e0 * t958 - 0.58482233974552040708313425006184496242808878304904e0 * t973
  t977 = t295 ** 2
  t979 = t274 / t977
  t982 = 0.1e1 / t277 / t275 / r0
  t983 = s0 * t982
  t989 = t281 * t24 * t288 / 0.288e3
  t990 = t65 * t5
  t991 = t280 * t990
  t992 = 0.1e1 / t316
  t993 = t8 * t992
  t994 = t287 * t327
  t999 = t286 ** 2
  t1001 = t283 / t999
  t1003 = f.my_piecewise3(t284, t975, -t975)
  t1009 = 0.1e1 / t292
  t1014 = t81 * t10 * t250
  t1015 = t1014 * t358
  t1016 = 0.16581944444444444444444444444444444444444444444445e-2 * t1015
  t1017 = t22 * t250
  t1018 = 0.1e1 / t322
  t1020 = t82 * t1017 * t1018
  t1021 = t380 * s0
  t1022 = t279 * t356
  t1025 = t1020 * t1021 * t1022 * t924
  t1028 = 0.73596627000000000000000000000000000000000000000000e-2 * t710 * t309
  t1029 = t327 * t308
  t1035 = t238 / t307 / t306
  t1036 = t933 * t303
  t1040 = 0.41275000000000000000000000000000000000000000000000e-2 * t922
  t1045 = t1036 * t935 / 0.4e1 + t244 * (0.19820000000000000000000000000000000000000000000000e-1 * t936 - t1040 - 0.41275000000000000000000000000000000000000000000000e-2 * t926) / 0.2e1
  t1051 = 0.37560000000000000000000000000000000000000000000000e-1 * t710 * t238
  t1056 = 0.35130000000000000000000000000000000000000000000000e-2 * t314 * t331 * t316
  t1057 = t38 * t239
  t1061 = t733 * t250
  t1064 = 0.79250000000000000000000000000000000000000000000000e-3 * t320 * t1061 * t322
  t1065 = t250 * t252
  t1070 = 0.51120000000000000000000000000000000000000000000000e-3 * t738 * t327
  t1072 = 0.1e1 / t326 / t170
  t1076 = t687 * t38
  t1079 = 0.50413125000000000000000000000000000000000000000000e-5 * t330 * t1076 * t332
  t1080 = t38 * t316
  t1084 = t1051 + 0.37560000000000000000000000000000000000000000000000e-1 * t86 * t924 - t1056 - 0.35130000000000000000000000000000000000000000000000e-2 * t101 * t1057 * t924 + t1064 + 0.79250000000000000000000000000000000000000000000000e-3 * t108 * t1065 * t924 - t1070 - 0.51120000000000000000000000000000000000000000000000e-3 * t113 * t1072 * t832 + t1079 + 0.50413125000000000000000000000000000000000000000000e-5 * t118 * t1080 * t924
  t1086 = -t1028 - 0.73596627000000000000000000000000000000000000000000e-2 * t86 * t1029 * t832 - 0.14719325400000000000000000000000000000000000000000e-1 * t86 * t1035 * t1045 - t975 * t336 - t274 * t1084
  t1090 = t299 * t300 * t1086 * t352 * t357
  t1093 = t82 * t1017 * t300
  t1094 = t351 ** 2
  t1095 = 0.1e1 / t1094
  t1096 = t338 * t1095
  t1097 = t1096 * s0
  t1099 = t81 * t124 * t9
  t1101 = 0.65704296666666666666666666666666666666666666666667e-3 * t1099 * t346
  t1103 = t81 * t340 * t38
  t1104 = t1018 * t343
  t1105 = t344 * t327
  t1110 = t244 * t344
  t1111 = t1110 * t935
  t1115 = t343 * t308
  t1116 = t1115 * t1045
  t1122 = t1101 + 0.65704296666666666666666666666666666666666666666667e-3 * t1103 * t1104 * t1105 * t832 + 0.14783466750000000000000000000000000000000000000000e-2 * t341 * t342 * t1111 - 0.98556445000000000000000000000000000000000000000000e-3 * t341 * t342 * t1116 - 0.4e1 * t274 * t975
  t1125 = t1093 * t1097 * t1022 * t1122
  t1129 = t299 * t353 * t983 * t356
  t1131 = 0.1e1 / t355
  t1132 = t279 * t1131
  t1134 = t7 * t832 + t169 + 0.1e1
  t1137 = t1093 * t1021 * t1132 * t1134
  t1140 = (t975 * t296 - 0.66725e-1 * t979 * (-t983 * t65 * t289 / 0.36e2 + t989 + t991 * t993 * t994 * t832 / 0.288e3 - t281 * t282 * t1001 * t1003 / 0.96e2) * t1009 + t1016 + 0.16581944444444444444444444444444444444444444444445e-2 * t1025 + 0.24872916666666666666666666666666666666666666666667e-2 * t1090 - 0.24872916666666666666666666666666666666666666666667e-2 * t1125 - 0.66327777777777777777777777777777777777777777777779e-2 * t1129 + 0.16581944444444444444444444444444444444444444444445e-2 * t1137) * t393
  t1141 = t392 ** 2
  t1143 = t361 / t1141
  t1158 = 0.26531111111111111111111111111111111111111111111111e-1 * t82 * t237 * t369
  t1159 = t81 * t149
  t1160 = t38 * t1018
  t1161 = t336 * t327
  t1173 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t929 + 0.2e1 * t953 + 0.11696446794910408141662685001236899248561775660981e1 * t958 - 0.11696446794910408141662685001236899248561775660981e1 * t973) * t144 * t345 + 0.46434375000000000000000000000000000000000000000000e-2 * t365 * t1111 - 0.30956250000000000000000000000000000000000000000000e-2 * t365 * t1116 - t1158 - 0.26531111111111111111111111111111111111111111111111e-1 * t1159 * t1160 * t1161 * t832 - 0.39796666666666666666666666666666666666666666666667e-1 * t82 * t368 * t300 * t1084) * t352 * s0 * t377
  t1176 = t373 * t1095 * s0
  t1179 = t1176 * t376 * t356 * t1122
  t1183 = t375 * t982 * t38 * t356
  t1187 = t375 * t376 * t1131 * t1134
  t1191 = t1086 * t352 * t381 * t389
  t1193 = t1096 * t381
  t1196 = t1193 * t387 * t388 * t1122
  t1203 = t382 / t276 / t383 / t275 * t250 * t388
  t1207 = t382 * t387 * t355 * t1134
  t1210 = t1143 * (t1173 / 0.16e2 - t1179 / 0.16e2 - t1183 / 0.6e1 + t1187 / 0.24e2 - t1191 / 0.256e3 + t1196 / 0.256e3 + t1203 / 0.48e2 - t1207 / 0.192e3)
  t1211 = 0.53236443333333333333333333333333333333333333333333e-3 * t922
  t1215 = t401 ** 2
  t1217 = t396 / t1215
  t1219 = 0.16057207750000000000000000000000000000000000000000e-1 * t922
  t1222 = 0.32394225500000000000000000000000000000000000000000e-2 * t944
  t1225 = 0.1e1 / t403
  t1229 = t262 * t962
  t1237 = t188 * t262
  t1240 = -t929 + t953 + t188 * (-(-t1211 - 0.53236443333333333333333333333333333333333333333333e-3 * t926) * t404 + t1217 * (0.10973915025000000000000000000000000000000000000000e0 * t936 - t1219 - 0.16057207750000000000000000000000000000000000000000e-1 * t926 + 0.19622842125000000000000000000000000000000000000000e-1 * t941 - t1222 - 0.32394225500000000000000000000000000000000000000000e-2 * t948) * t1225 + t929 - t953 - 0.58482233974552040708313425006184496242808878304904e0 * t957 + 0.58482233974552040708313425006184496242808878304904e0 * t1229 * t969 * t971) + 0.58482233974552040708313425006184496242808878304904e0 * t188 * t957 - 0.58482233974552040708313425006184496242808878304904e0 * t1237 * t972
  t1242 = t427 ** 2
  t1244 = t411 / t1242
  t1253 = t414 * t208 * t23 * t283 * t419 / 0.576e3
  t1254 = t413 * t64
  t1255 = t412 * t1254
  t1256 = t282 * t992
  t1257 = t419 * t327
  t1262 = t418 ** 2
  t1264 = t283 / t1262
  t1266 = f.my_piecewise3(t416, t1240, -t1240)
  t1272 = 0.1e1 / t424
  t1276 = 0.11607361111111111111111111111111111111111111111111e-2 * t1015
  t1284 = t434 ** 2
  t1286 = t431 / t1284
  t1303 = f.my_piecewise3(t176, 0, t836)
  t1309 = t236 * t315 * t449
  t1310 = 0.11073577833333333333333333333333333333333333333333e-2 * t1309
  t1311 = t527 * t836
  t1313 = t11 * t538 * t1311
  t1316 = (-t1310 - 0.11073577833333333333333333333333333333333333333333e-2 * t1313) * t466
  t1317 = t463 ** 2
  t1319 = t453 / t1317
  t1320 = 0.1e1 / t454
  t1322 = -t1309 / 0.3e1 - t1313 / 0.3e1
  t1323 = t1320 * t1322
  t1325 = 0.18590345266666666666666666666666666666666666666667e-1 * t1309
  t1327 = t451 ** 0.5e0
  t1328 = t1327 * t1322
  t1331 = t249 * t321 * t459
  t1332 = 0.51086658466666666666666666666666666666666666666667e-2 * t1331
  t1333 = t250 * t489
  t1335 = t25 * t1333 * t1311
  t1338 = 0.1e1 / t465
  t1340 = t1319 * (0.11807895435000000000000000000000000000000000000000e0 * t1323 - t1325 - 0.18590345266666666666666666666666666666666666666667e-1 * t1313 + 0.19099978575000000000000000000000000000000000000000e-1 * t1328 - t1332 - 0.51086658466666666666666666666666666666666666666667e-2 * t1335) * t1338
  t1341 = 0.31311312500000000000000000000000000000000000000000e-3 * t1309
  t1344 = (-t1341 - 0.31311312500000000000000000000000000000000000000000e-3 * t1313) * t477
  t1345 = t42 * t1344
  t1347 = t42 * t469
  t1348 = t474 ** 2
  t1349 = 0.1e1 / t1348
  t1351 = 0.10197214950000000000000000000000000000000000000000e-1 * t1309
  t1354 = 0.27959805900000000000000000000000000000000000000000e-2 * t1331
  t1356 = 0.87449329500000000000000000000000000000000000000000e-1 * t1323 - t1351 - 0.10197214950000000000000000000000000000000000000000e-1 * t1313 + 0.55743564825000000000000000000000000000000000000000e-2 * t1328 - t1354 - 0.27959805900000000000000000000000000000000000000000e-2 * t1335
  t1358 = 0.1e1 / t476
  t1359 = t1349 * t1356 * t1358
  t1360 = t1347 * t1359
  t1362 = -t1316 + t1340 + 0.58482233974552040708313425006184496242808878304904e0 * t1345 - 0.58482233974552040708313425006184496242808878304904e0 * t1360
  t1364 = t501 ** 2
  t1366 = t481 / t1364
  t1369 = t488 * t24 * t494 / 0.288e3
  t1370 = t487 * t990
  t1371 = 0.1e1 / t518
  t1372 = t8 * t1371
  t1373 = t493 * t527
  t1378 = t492 ** 2
  t1380 = t489 / t1378
  t1382 = f.my_piecewise3(t490, t1362, -t1362)
  t1388 = 0.1e1 / t498
  t1392 = t1014 * t554
  t1393 = 0.16581944444444444444444444444444444444444444444445e-2 * t1392
  t1394 = 0.1e1 / t522
  t1396 = t82 * t1017 * t1394
  t1397 = t575 * s2
  t1398 = t486 * t552
  t1401 = t1396 * t1397 * t1398 * t1311
  t1404 = 0.73596627000000000000000000000000000000000000000000e-2 * t710 * t513
  t1405 = t527 * t512
  t1411 = t448 / t511 / t510
  t1412 = t1320 * t507
  t1416 = 0.41275000000000000000000000000000000000000000000000e-2 * t1309
  t1421 = t1412 * t1322 / 0.4e1 + t454 * (0.19820000000000000000000000000000000000000000000000e-1 * t1323 - t1416 - 0.41275000000000000000000000000000000000000000000000e-2 * t1313) / 0.2e1
  t1427 = 0.37560000000000000000000000000000000000000000000000e-1 * t710 * t448
  t1432 = 0.35130000000000000000000000000000000000000000000000e-2 * t314 * t331 * t518
  t1433 = t38 * t449
  t1439 = 0.79250000000000000000000000000000000000000000000000e-3 * t320 * t1061 * t522
  t1440 = t250 * t459
  t1445 = 0.51120000000000000000000000000000000000000000000000e-3 * t738 * t527
  t1447 = 0.1e1 / t526 / t175
  t1453 = 0.50413125000000000000000000000000000000000000000000e-5 * t330 * t1076 * t530
  t1454 = t38 * t518
  t1458 = t1427 + 0.37560000000000000000000000000000000000000000000000e-1 * t86 * t1311 - t1432 - 0.35130000000000000000000000000000000000000000000000e-2 * t101 * t1433 * t1311 + t1439 + 0.79250000000000000000000000000000000000000000000000e-3 * t108 * t1440 * t1311 - t1445 - 0.51120000000000000000000000000000000000000000000000e-3 * t113 * t1447 * t836 + t1453 + 0.50413125000000000000000000000000000000000000000000e-5 * t118 * t1454 * t1311
  t1460 = -t1404 - 0.73596627000000000000000000000000000000000000000000e-2 * t86 * t1405 * t836 - 0.14719325400000000000000000000000000000000000000000e-1 * t86 * t1411 * t1421 - t1362 * t534 - t481 * t1458
  t1464 = t299 * t504 * t1460 * t548 * t553
  t1467 = t82 * t1017 * t504
  t1468 = t547 ** 2
  t1469 = 0.1e1 / t1468
  t1470 = t536 * t1469
  t1471 = t1470 * s2
  t1473 = 0.65704296666666666666666666666666666666666666666667e-3 * t1099 * t542
  t1474 = t1394 * t539
  t1475 = t540 * t527
  t1480 = t454 * t540
  t1481 = t1480 * t1322
  t1485 = t539 * t512
  t1486 = t1485 * t1421
  t1492 = t1473 + 0.65704296666666666666666666666666666666666666666667e-3 * t1103 * t1474 * t1475 * t836 + 0.14783466750000000000000000000000000000000000000000e-2 * t341 * t538 * t1481 - 0.98556445000000000000000000000000000000000000000000e-3 * t341 * t538 * t1486 - 0.4e1 * t481 * t1362
  t1495 = t1467 * t1471 * t1398 * t1492
  t1497 = 0.1e1 / t551
  t1498 = t486 * t1497
  t1500 = t7 * t836 - t169 + 0.1e1
  t1503 = t1467 * t1397 * t1498 * t1500
  t1506 = (t1362 * t502 - 0.66725e-1 * t1366 * (t1369 + t1370 * t1372 * t1373 * t836 / 0.288e3 - t488 * t282 * t1380 * t1382 / 0.96e2) * t1388 + t1393 + 0.16581944444444444444444444444444444444444444444445e-2 * t1401 + 0.24872916666666666666666666666666666666666666666667e-2 * t1464 - 0.24872916666666666666666666666666666666666666666667e-2 * t1495 + 0.16581944444444444444444444444444444444444444444445e-2 * t1503) * t588
  t1507 = t587 ** 2
  t1509 = t557 / t1507
  t1524 = 0.26531111111111111111111111111111111111111111111111e-1 * t82 * t237 * t564
  t1525 = t38 * t1394
  t1526 = t534 * t527
  t1538 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t1316 + 0.2e1 * t1340 + 0.11696446794910408141662685001236899248561775660981e1 * t1345 - 0.11696446794910408141662685001236899248561775660981e1 * t1360) * t144 * t541 + 0.46434375000000000000000000000000000000000000000000e-2 * t561 * t1481 - 0.30956250000000000000000000000000000000000000000000e-2 * t561 * t1486 - t1524 - 0.26531111111111111111111111111111111111111111111111e-1 * t1159 * t1525 * t1526 * t836 - 0.39796666666666666666666666666666666666666666666667e-1 * t82 * t368 * t504 * t1458) * t548 * s2 * t572
  t1541 = t568 * t1469 * s2
  t1544 = t1541 * t571 * t552 * t1492
  t1548 = t570 * t571 * t1497 * t1500
  t1552 = t1460 * t548 * t576 * t584
  t1554 = t1470 * t576
  t1557 = t1554 * t582 * t583 * t1492
  t1561 = t577 * t582 * t551 * t1500
  t1564 = t1509 * (t1538 / 0.16e2 - t1544 / 0.16e2 + t1548 / 0.24e2 - t1552 / 0.256e3 + t1557 / 0.256e3 - t1561 / 0.192e3)
  t1565 = 0.53236443333333333333333333333333333333333333333333e-3 * t1309
  t1569 = t596 ** 2
  t1571 = t591 / t1569
  t1573 = 0.16057207750000000000000000000000000000000000000000e-1 * t1309
  t1576 = 0.32394225500000000000000000000000000000000000000000e-2 * t1331
  t1579 = 0.1e1 / t598
  t1583 = t469 * t1349
  t1591 = t188 * t469
  t1594 = -t1316 + t1340 + t188 * (-(-t1565 - 0.53236443333333333333333333333333333333333333333333e-3 * t1313) * t599 + t1571 * (0.10973915025000000000000000000000000000000000000000e0 * t1323 - t1573 - 0.16057207750000000000000000000000000000000000000000e-1 * t1313 + 0.19622842125000000000000000000000000000000000000000e-1 * t1328 - t1576 - 0.32394225500000000000000000000000000000000000000000e-2 * t1335) * t1579 + t1316 - t1340 - 0.58482233974552040708313425006184496242808878304904e0 * t1344 + 0.58482233974552040708313425006184496242808878304904e0 * t1583 * t1356 * t1358) + 0.58482233974552040708313425006184496242808878304904e0 * t188 * t1344 - 0.58482233974552040708313425006184496242808878304904e0 * t1591 * t1359
  t1596 = t622 ** 2
  t1598 = t606 / t1596
  t1603 = t609 * t208 * t23 * t489 * t614 / 0.576e3
  t1604 = t608 * t64
  t1605 = t607 * t1604
  t1606 = t282 * t1371
  t1607 = t614 * t527
  t1612 = t613 ** 2
  t1614 = t489 / t1612
  t1616 = f.my_piecewise3(t611, t1594, -t1594)
  t1622 = 0.1e1 / t619
  t1626 = 0.11607361111111111111111111111111111111111111111111e-2 * t1392
  t1633 = t629 ** 2
  t1635 = t626 / t1633
  vrho_0_ = t167 + t230 - t442 - t637 + t7 * (t778 - t830 + (t835 + t839) * t41 * t229 + t911 + s0 / t275 * t440 / 0.16e2 - t232 * t233 * t916 * t439 / 0.16e2 - t232 * t235 * (t1140 - t1210 + t188 * ((t1240 * t428 - 0.66725e-1 * t1244 * (-t412 * t982 * t19 * t421 / 0.72e2 + t1253 + t1255 * t1256 * t1257 * t832 / 0.576e3 - t1255 * t282 * t1264 * t1266 / 0.192e3) * t1272 + t1276 + 0.11607361111111111111111111111111111111111111111111e-2 * t1025 + 0.17411041666666666666666666666666666666666666666667e-2 * t1090 - 0.17411041666666666666666666666666666666666666666667e-2 * t1125 - 0.46429444444444444444444444444444444444444444444445e-2 * t1129 + 0.11607361111111111111111111111111111111111111111111e-2 * t1137) * t435 - t1286 * (0.93750000000000000000000000000000000000000000000000e-1 * t1173 - 0.93750000000000000000000000000000000000000000000000e-1 * t1179 - 0.25000000000000000000000000000000000000000000000000e0 * t1183 + 0.62500000000000000000000000000000000000000000000000e-1 * t1187 - 0.10117187500000000000000000000000000000000000000000e-1 * t1191 + 0.10117187500000000000000000000000000000000000000000e-1 * t1196 + 0.53958333333333333333333333333333333333333333333333e-1 * t1203 - 0.13489583333333333333333333333333333333333333333333e-1 * t1207) - t1140 + t1210)) / 0.16e2 - t444 * t445 * t1303 * t634 / 0.16e2 - t444 * t447 * (t1506 - t1564 + t188 * ((t1594 * t623 - 0.66725e-1 * t1598 * (t1603 + t1605 * t1606 * t1607 * t836 / 0.576e3 - t1605 * t282 * t1614 * t1616 / 0.192e3) * t1622 + t1626 + 0.11607361111111111111111111111111111111111111111111e-2 * t1401 + 0.17411041666666666666666666666666666666666666666667e-2 * t1464 - 0.17411041666666666666666666666666666666666666666667e-2 * t1495 + 0.11607361111111111111111111111111111111111111111111e-2 * t1503) * t630 - t1635 * (0.93750000000000000000000000000000000000000000000000e-1 * t1538 - 0.93750000000000000000000000000000000000000000000000e-1 * t1544 + 0.62500000000000000000000000000000000000000000000000e-1 * t1548 - 0.10117187500000000000000000000000000000000000000000e-1 * t1552 + 0.10117187500000000000000000000000000000000000000000e-1 * t1557 - 0.13489583333333333333333333333333333333333333333333e-1 * t1561) - t1506 + t1564)) / 0.16e2)
  t1652 = -t85 - t831
  t1655 = f.my_piecewise3(t171, 0, 0.4e1 / 0.3e1 * t172 * t1652)
  t1656 = -t1652
  t1659 = f.my_piecewise3(t176, 0, 0.4e1 / 0.3e1 * t177 * t1656)
  t1663 = f.my_piecewise3(t171, 0, t1652)
  t1668 = t327 * t1652
  t1670 = t11 * t342 * t1668
  t1673 = (-t923 - 0.11073577833333333333333333333333333333333333333333e-2 * t1670) * t259
  t1675 = -t922 / 0.3e1 - t1670 / 0.3e1
  t1676 = t933 * t1675
  t1679 = t940 * t1675
  t1682 = t25 * t946 * t1668
  t1686 = t932 * (0.11807895435000000000000000000000000000000000000000e0 * t1676 - t938 - 0.18590345266666666666666666666666666666666666666667e-1 * t1670 + 0.19099978575000000000000000000000000000000000000000e-1 * t1679 - t945 - 0.51086658466666666666666666666666666666666666666667e-2 * t1682) * t951
  t1689 = (-t954 - 0.31311312500000000000000000000000000000000000000000e-3 * t1670) * t270
  t1690 = t42 * t1689
  t1696 = 0.87449329500000000000000000000000000000000000000000e-1 * t1676 - t964 - 0.10197214950000000000000000000000000000000000000000e-1 * t1670 + 0.55743564825000000000000000000000000000000000000000e-2 * t1679 - t967 - 0.27959805900000000000000000000000000000000000000000e-2 * t1682
  t1698 = t962 * t1696 * t971
  t1699 = t960 * t1698
  t1701 = -t1673 + t1686 + 0.58482233974552040708313425006184496242808878304904e0 * t1690 - 0.58482233974552040708313425006184496242808878304904e0 * t1699
  t1708 = f.my_piecewise3(t284, t1701, -t1701)
  t1719 = t1020 * t1021 * t1022 * t1668
  t1731 = t1036 * t1675 / 0.4e1 + t244 * (0.19820000000000000000000000000000000000000000000000e-1 * t1676 - t1040 - 0.41275000000000000000000000000000000000000000000000e-2 * t1670) / 0.2e1
  t1750 = t1051 + 0.37560000000000000000000000000000000000000000000000e-1 * t86 * t1668 - t1056 - 0.35130000000000000000000000000000000000000000000000e-2 * t101 * t1057 * t1668 + t1064 + 0.79250000000000000000000000000000000000000000000000e-3 * t108 * t1065 * t1668 - t1070 - 0.51120000000000000000000000000000000000000000000000e-3 * t113 * t1072 * t1652 + t1079 + 0.50413125000000000000000000000000000000000000000000e-5 * t118 * t1080 * t1668
  t1752 = -t1028 - 0.73596627000000000000000000000000000000000000000000e-2 * t86 * t1029 * t1652 - 0.14719325400000000000000000000000000000000000000000e-1 * t86 * t1035 * t1731 - t1701 * t336 - t274 * t1750
  t1756 = t299 * t300 * t1752 * t352 * t357
  t1762 = t1110 * t1675
  t1766 = t1115 * t1731
  t1772 = t1101 + 0.65704296666666666666666666666666666666666666666667e-3 * t1103 * t1104 * t1105 * t1652 + 0.14783466750000000000000000000000000000000000000000e-2 * t341 * t342 * t1762 - 0.98556445000000000000000000000000000000000000000000e-3 * t341 * t342 * t1766 - 0.4e1 * t274 * t1701
  t1775 = t1093 * t1097 * t1022 * t1772
  t1778 = t7 * t1652 + t169 + 0.1e1
  t1781 = t1093 * t1021 * t1132 * t1778
  t1784 = (t1701 * t296 - 0.66725e-1 * t979 * (t989 + t991 * t993 * t994 * t1652 / 0.288e3 - t281 * t282 * t1001 * t1708 / 0.96e2) * t1009 + t1016 + 0.16581944444444444444444444444444444444444444444445e-2 * t1719 + 0.24872916666666666666666666666666666666666666666667e-2 * t1756 - 0.24872916666666666666666666666666666666666666666667e-2 * t1775 + 0.16581944444444444444444444444444444444444444444445e-2 * t1781) * t393
  t1808 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t1673 + 0.2e1 * t1686 + 0.11696446794910408141662685001236899248561775660981e1 * t1690 - 0.11696446794910408141662685001236899248561775660981e1 * t1699) * t144 * t345 + 0.46434375000000000000000000000000000000000000000000e-2 * t365 * t1762 - 0.30956250000000000000000000000000000000000000000000e-2 * t365 * t1766 - t1158 - 0.26531111111111111111111111111111111111111111111111e-1 * t1159 * t1160 * t1161 * t1652 - 0.39796666666666666666666666666666666666666666666667e-1 * t82 * t368 * t300 * t1750) * t352 * s0 * t377
  t1812 = t1176 * t376 * t356 * t1772
  t1816 = t375 * t376 * t1131 * t1778
  t1820 = t1752 * t352 * t381 * t389
  t1824 = t1193 * t387 * t388 * t1772
  t1828 = t382 * t387 * t355 * t1778
  t1831 = t1143 * (t1808 / 0.16e2 - t1812 / 0.16e2 + t1816 / 0.24e2 - t1820 / 0.256e3 + t1824 / 0.256e3 - t1828 / 0.192e3)
  t1852 = -t1673 + t1686 + t188 * (-(-t1211 - 0.53236443333333333333333333333333333333333333333333e-3 * t1670) * t404 + t1217 * (0.10973915025000000000000000000000000000000000000000e0 * t1676 - t1219 - 0.16057207750000000000000000000000000000000000000000e-1 * t1670 + 0.19622842125000000000000000000000000000000000000000e-1 * t1679 - t1222 - 0.32394225500000000000000000000000000000000000000000e-2 * t1682) * t1225 + t1673 - t1686 - 0.58482233974552040708313425006184496242808878304904e0 * t1689 + 0.58482233974552040708313425006184496242808878304904e0 * t1229 * t1696 * t971) + 0.58482233974552040708313425006184496242808878304904e0 * t188 * t1689 - 0.58482233974552040708313425006184496242808878304904e0 * t1237 * t1698
  t1859 = f.my_piecewise3(t416, t1852, -t1852)
  t1892 = f.my_piecewise3(t176, 0, t1656)
  t1897 = t527 * t1656
  t1899 = t11 * t538 * t1897
  t1902 = (-t1310 - 0.11073577833333333333333333333333333333333333333333e-2 * t1899) * t466
  t1904 = -t1309 / 0.3e1 - t1899 / 0.3e1
  t1905 = t1320 * t1904
  t1908 = t1327 * t1904
  t1911 = t25 * t1333 * t1897
  t1915 = t1319 * (0.11807895435000000000000000000000000000000000000000e0 * t1905 - t1325 - 0.18590345266666666666666666666666666666666666666667e-1 * t1899 + 0.19099978575000000000000000000000000000000000000000e-1 * t1908 - t1332 - 0.51086658466666666666666666666666666666666666666667e-2 * t1911) * t1338
  t1918 = (-t1341 - 0.31311312500000000000000000000000000000000000000000e-3 * t1899) * t477
  t1919 = t42 * t1918
  t1925 = 0.87449329500000000000000000000000000000000000000000e-1 * t1905 - t1351 - 0.10197214950000000000000000000000000000000000000000e-1 * t1899 + 0.55743564825000000000000000000000000000000000000000e-2 * t1908 - t1354 - 0.27959805900000000000000000000000000000000000000000e-2 * t1911
  t1927 = t1349 * t1925 * t1358
  t1928 = t1347 * t1927
  t1930 = -t1902 + t1915 + 0.58482233974552040708313425006184496242808878304904e0 * t1919 - 0.58482233974552040708313425006184496242808878304904e0 * t1928
  t1934 = 0.1e1 / t484 / t482 / r1
  t1935 = s2 * t1934
  t1944 = f.my_piecewise3(t490, t1930, -t1930)
  t1955 = t1396 * t1397 * t1398 * t1897
  t1967 = t1412 * t1904 / 0.4e1 + t454 * (0.19820000000000000000000000000000000000000000000000e-1 * t1905 - t1416 - 0.41275000000000000000000000000000000000000000000000e-2 * t1899) / 0.2e1
  t1986 = t1427 + 0.37560000000000000000000000000000000000000000000000e-1 * t86 * t1897 - t1432 - 0.35130000000000000000000000000000000000000000000000e-2 * t101 * t1433 * t1897 + t1439 + 0.79250000000000000000000000000000000000000000000000e-3 * t108 * t1440 * t1897 - t1445 - 0.51120000000000000000000000000000000000000000000000e-3 * t113 * t1447 * t1656 + t1453 + 0.50413125000000000000000000000000000000000000000000e-5 * t118 * t1454 * t1897
  t1988 = -t1404 - 0.73596627000000000000000000000000000000000000000000e-2 * t86 * t1405 * t1656 - 0.14719325400000000000000000000000000000000000000000e-1 * t86 * t1411 * t1967 - t1930 * t534 - t481 * t1986
  t1992 = t299 * t504 * t1988 * t548 * t553
  t1998 = t1480 * t1904
  t2002 = t1485 * t1967
  t2008 = t1473 + 0.65704296666666666666666666666666666666666666666667e-3 * t1103 * t1474 * t1475 * t1656 + 0.14783466750000000000000000000000000000000000000000e-2 * t341 * t538 * t1998 - 0.98556445000000000000000000000000000000000000000000e-3 * t341 * t538 * t2002 - 0.4e1 * t481 * t1930
  t2011 = t1467 * t1471 * t1398 * t2008
  t2015 = t299 * t549 * t1935 * t552
  t2018 = t7 * t1656 - t169 + 0.1e1
  t2021 = t1467 * t1397 * t1498 * t2018
  t2024 = (t1930 * t502 - 0.66725e-1 * t1366 * (-t1935 * t65 * t495 / 0.36e2 + t1369 + t1370 * t1372 * t1373 * t1656 / 0.288e3 - t488 * t282 * t1380 * t1944 / 0.96e2) * t1388 + t1393 + 0.16581944444444444444444444444444444444444444444445e-2 * t1955 + 0.24872916666666666666666666666666666666666666666667e-2 * t1992 - 0.24872916666666666666666666666666666666666666666667e-2 * t2011 - 0.66327777777777777777777777777777777777777777777779e-2 * t2015 + 0.16581944444444444444444444444444444444444444444445e-2 * t2021) * t588
  t2048 = (0.30956250000000000000000000000000000000000000000000e-2 * (-0.2e1 * t1902 + 0.2e1 * t1915 + 0.11696446794910408141662685001236899248561775660981e1 * t1919 - 0.11696446794910408141662685001236899248561775660981e1 * t1928) * t144 * t541 + 0.46434375000000000000000000000000000000000000000000e-2 * t561 * t1998 - 0.30956250000000000000000000000000000000000000000000e-2 * t561 * t2002 - t1524 - 0.26531111111111111111111111111111111111111111111111e-1 * t1159 * t1525 * t1526 * t1656 - 0.39796666666666666666666666666666666666666666666667e-1 * t82 * t368 * t504 * t1986) * t548 * s2 * t572
  t2052 = t1541 * t571 * t552 * t2008
  t2056 = t570 * t1934 * t38 * t552
  t2060 = t570 * t571 * t1497 * t2018
  t2064 = t1988 * t548 * t576 * t584
  t2068 = t1554 * t582 * t583 * t2008
  t2075 = t577 / t483 / t578 / t482 * t250 * t583
  t2079 = t577 * t582 * t551 * t2018
  t2082 = t1509 * (t2048 / 0.16e2 - t2052 / 0.16e2 - t2056 / 0.6e1 + t2060 / 0.24e2 - t2064 / 0.256e3 + t2068 / 0.256e3 + t2075 / 0.48e2 - t2079 / 0.192e3)
  t2103 = -t1902 + t1915 + t188 * (-(-t1565 - 0.53236443333333333333333333333333333333333333333333e-3 * t1899) * t599 + t1571 * (0.10973915025000000000000000000000000000000000000000e0 * t1905 - t1573 - 0.16057207750000000000000000000000000000000000000000e-1 * t1899 + 0.19622842125000000000000000000000000000000000000000e-1 * t1908 - t1576 - 0.32394225500000000000000000000000000000000000000000e-2 * t1911) * t1579 + t1902 - t1915 - 0.58482233974552040708313425006184496242808878304904e0 * t1918 + 0.58482233974552040708313425006184496242808878304904e0 * t1583 * t1925 * t1358) + 0.58482233974552040708313425006184496242808878304904e0 * t188 * t1918 - 0.58482233974552040708313425006184496242808878304904e0 * t1591 * t1927
  t2114 = f.my_piecewise3(t611, t2103, -t2103)
  vrho_1_ = t167 + t230 - t442 - t637 + t7 * (t778 - t830 + (t1655 + t1659) * t41 * t229 + t911 - t232 * t233 * t1663 * t439 / 0.16e2 - t232 * t235 * (t1784 - t1831 + t188 * ((t1852 * t428 - 0.66725e-1 * t1244 * (t1253 + t1255 * t1256 * t1257 * t1652 / 0.576e3 - t1255 * t282 * t1264 * t1859 / 0.192e3) * t1272 + t1276 + 0.11607361111111111111111111111111111111111111111111e-2 * t1719 + 0.17411041666666666666666666666666666666666666666667e-2 * t1756 - 0.17411041666666666666666666666666666666666666666667e-2 * t1775 + 0.11607361111111111111111111111111111111111111111111e-2 * t1781) * t435 - t1286 * (0.93750000000000000000000000000000000000000000000000e-1 * t1808 - 0.93750000000000000000000000000000000000000000000000e-1 * t1812 + 0.62500000000000000000000000000000000000000000000000e-1 * t1816 - 0.10117187500000000000000000000000000000000000000000e-1 * t1820 + 0.10117187500000000000000000000000000000000000000000e-1 * t1824 - 0.13489583333333333333333333333333333333333333333333e-1 * t1828) - t1784 + t1831)) / 0.16e2 + s2 / t482 * t635 / 0.16e2 - t444 * t445 * t1892 * t634 / 0.16e2 - t444 * t447 * (t2024 - t2082 + t188 * ((t2103 * t623 - 0.66725e-1 * t1598 * (-t607 * t1934 * t19 * t616 / 0.72e2 + t1603 + t1605 * t1606 * t1607 * t1656 / 0.576e3 - t1605 * t282 * t1614 * t2114 / 0.192e3) * t1622 + t1626 + 0.11607361111111111111111111111111111111111111111111e-2 * t1955 + 0.17411041666666666666666666666666666666666666666667e-2 * t1992 - 0.17411041666666666666666666666666666666666666666667e-2 * t2011 - 0.46429444444444444444444444444444444444444444444445e-2 * t2015 + 0.11607361111111111111111111111111111111111111111111e-2 * t2021) * t630 - t1635 * (0.93750000000000000000000000000000000000000000000000e-1 * t2048 - 0.93750000000000000000000000000000000000000000000000e-1 * t2052 - 0.25000000000000000000000000000000000000000000000000e0 * t2056 + 0.62500000000000000000000000000000000000000000000000e-1 * t2060 - 0.10117187500000000000000000000000000000000000000000e-1 * t2064 + 0.10117187500000000000000000000000000000000000000000e-1 * t2068 + 0.53958333333333333333333333333333333333333333333333e-1 * t2075 - 0.13489583333333333333333333333333333333333333333333e-1 * t2079) - t2024 + t2082)) / 0.16e2)
  t2151 = t684 * t331 * t65 * t70 * t702
  t2154 = t82 * t123 * t135
  t2157 = (-0.69505208333333333333333333333333333333333333333333e-3 * t2151 + 0.99491666666666666666666666666666666666666666666666e-2 * t2154) * t166
  t2158 = t154 * t112
  t2161 = t158 * t58 * t161
  t2164 = t781 * (t2158 / 0.8e1 - t2161 / 0.32e2)
  t2168 = t876 * t691 * t208 * t212 * t890
  t2178 = t181 * ((-0.69505208333333333333333333333333333333333333333333e-3 * t2168 + 0.69644166666666666666666666666666666666666666666666e-2 * t2154) * t227 - t901 * (0.18750000000000000000000000000000000000000000000000e0 * t2158 - 0.80937500000000000000000000000000000000000000000000e-1 * t2161) - t2157 + t2164)
  t2191 = t299 * t339 * t352 * t279 * t356
  t2194 = (-0.69505208333333333333333333333333333333333333333333e-3 * t979 * t1254 * t282 * t288 * t1009 + 0.24872916666666666666666666666666666666666666666667e-2 * t2191) * t393
  t2195 = t374 * t377
  t2197 = t1021 * t389
  t2200 = t1143 * (t2195 / 0.16e2 - t2197 / 0.128e3)
  t2204 = t208 * t8
  vsigma_0_ = t7 * (t2157 - t2164 + t2178 - t231 * t233 * t234 * t439 / 0.16e2 - t232 * t235 * (t2194 - t2200 + t188 * ((-0.34752604166666666666666666666666666666666666666667e-3 * t1244 * t250 * t279 * t19 * t2204 * t283 * t419 * t1272 + 0.17411041666666666666666666666666666666666666666667e-2 * t2191) * t435 - t1286 * (0.93750000000000000000000000000000000000000000000000e-1 * t2195 - 0.20234375000000000000000000000000000000000000000000e-1 * t2197) - t2194 + t2200)) / 0.16e2)
  t2227 = (-0.13901041666666666666666666666666666666666666666667e-2 * t2151 + 0.19898333333333333333333333333333333333333333333333e-1 * t2154) * t166
  t2231 = t781 * (t2158 / 0.4e1 - t2161 / 0.16e2)
  vsigma_1_ = t7 * (t2227 - t2231 + t181 * ((-0.13901041666666666666666666666666666666666666666667e-2 * t2168 + 0.13928833333333333333333333333333333333333333333333e-1 * t2154) * t227 - t901 * (0.37500000000000000000000000000000000000000000000000e0 * t2158 - 0.16187500000000000000000000000000000000000000000000e0 * t2161) - t2227 + t2231))
  t2255 = t299 * t537 * t548 * t486 * t552
  t2258 = (-0.69505208333333333333333333333333333333333333333333e-3 * t1366 * t1604 * t282 * t494 * t1388 + 0.24872916666666666666666666666666666666666666666667e-2 * t2255) * t588
  t2259 = t569 * t572
  t2261 = t1397 * t584
  t2264 = t1509 * (t2259 / 0.16e2 - t2261 / 0.128e3)
  vsigma_2_ = t7 * (t2157 - t2164 + t2178 - t443 * t445 * t446 * t634 / 0.16e2 - t444 * t447 * (t2258 - t2264 + t188 * ((-0.34752604166666666666666666666666666666666666666667e-3 * t1598 * t250 * t486 * t19 * t2204 * t489 * t614 * t1622 + 0.17411041666666666666666666666666666666666666666667e-2 * t2255) * t630 - t1635 * (0.93750000000000000000000000000000000000000000000000e-1 * t2259 - 0.20234375000000000000000000000000000000000000000000e-1 * t2261) - t2258 + t2264)) / 0.16e2)
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t2289 = tau0 ** 2
  vtau_0_ = t7 * s0 * t231 / t2289 * t234 * t439 / 0.16e2
  t2296 = tau1 ** 2
  vtau_1_ = t7 * s2 * t443 / t2296 * t446 * t634 / 0.16e2
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  gap_par0 = np.array([np.nan, 0.04953, 1.07924, 0.07928, -0.02504, 0.007026, -0.001268, 0.0001136, -3.841e-06, 0.031091, 0.23878], dtype=np.float64)

  gap_eps_1 = lambda rs, par: par[1] * rs ** (3 / 2) / (1 + jnp.sqrt(rs) * (par[2] + par[3] * jnp.sqrt(rs) + par[1] * rs))

  gap_eps_2 = lambda rs, par: jnp.sum(jnp.array([par[i + 1] * rs ** i for i in range(3, 7 + 1)]), axis=0)

  gap_C = lambda rs, par: par[10] / rs ** 2

  kcis_G = lambda rs, xt: xt ** 2 * f.n_total(rs) ** (2 / 3) / 8

  kcis_t = lambda rs, xt: 2 ** (2 / 3) * xt / (8 * jnp.sqrt(rs))

  kcis_beta = 0.066725

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  gap_c2 = lambda rs, z, par: +(2 * f_pw(rs, z) * gap_eps_1(rs, par) - gap_C(rs, par) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  gap_c3 = lambda rs, z, par: -(2 * gap_eps_1(rs, par) ** 2 - f_pw(rs, z) * gap_eps_2(rs, par)) / (2 * (gap_C(rs, par) * gap_eps_1(rs, par) - f_pw(rs, z) ** 2))

  kcis_gga0 = lambda rs, xt: f_pw(rs, 0) / (1 + kcis_beta * jnp.log(1 + kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 0))))

  kcis_gga1 = lambda rs, xt: f_pw(rs, 1) / (1 + kcis_beta * jnp.log(1 + 2 ** (-1 / 3) * kcis_t(rs, xt) ** 2 / jnp.abs(f_pw(rs, 1))))

  gap_c1 = lambda rs, z, par: -gap_C(rs, par) * gap_c3(rs, z, par)

  kcis_eps_0 = lambda rs, xt: +(kcis_gga0(rs, xt) + gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  kcis_eps_1 = lambda rs, xt: +(kcis_gga1(rs, xt) + 0.7 * gap_c1(rs, 0, gap_par0) * kcis_G(rs, xt)) / (1 + 1.5 * gap_c2(rs, 0, gap_par0) * kcis_G(rs, xt) + 2.59 * gap_c3(rs, 0, gap_par0) * kcis_G(rs, xt) ** 2)

  gap_f = lambda rs, z, xt: +kcis_eps_0(rs, xt) + f.f_zeta(z) * (kcis_eps_1(rs, xt) - kcis_eps_0(rs, xt))

  kcis_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +gap_f(rs, z, xt) - xs0 ** 2 / (8 * ts0) * f.opz_pow_n(z, 1) / 2 * gap_f(rs * (2 / (1 + z)) ** (1 / 3), 1, xs0) - xs1 ** 2 / (8 * ts1) * f.opz_pow_n(-z, 1) / 2 * gap_f(rs * (2 / (1 - z)) ** (1 / 3), -1, xs1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: kcis_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t12 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t22 = 0.1e1 / t21
  t23 = t5 * t22
  t24 = t20 * t23
  t26 = 0.23615790870000000000000000000000000000000000000000e0 * t13 + 0.55771035800000000000000000000000000000000000000000e-1 * t10 + 0.12733319050000000000000000000000000000000000000000e-1 * t16 + 0.76629987700000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t33 = t32 * f.p.zeta_threshold
  t34 = f.my_piecewise3(t31, t33, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = (0.2e1 * t34 - 0.2e1) * t40
  t43 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489865900000000000000000000000000000000000000000e0 * t13 + 0.30591644850000000000000000000000000000000000000000e-1 * t10 + 0.37162376550000000000000000000000000000000000000000e-2 * t16 + 0.41939708850000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t52 = t43 * t51
  t53 = t41 * t52
  t55 = -t30 + 0.58482233974552040708313425006184496242808878304904e0 * t53
  t56 = t37 * s0
  t57 = r0 ** 2
  t59 = 0.1e1 / t7 / t57
  t60 = t56 * t59
  t61 = 0.1e1 / t3
  t62 = t18 * t61
  t63 = 0.0e0 < t55
  t65 = f.my_piecewise3(t63, t55, -t55)
  t67 = t5 / t65
  t68 = t62 * t67
  t71 = 0.1e1 + t60 * t68 / 0.96e2
  t72 = jnp.log(t71)
  t74 = 0.1e1 + 0.66725e-1 * t72
  t75 = 0.1e1 / t74
  t78 = t1 / t19
  t79 = t78 * t6
  t81 = 0.1e1 / t7 / r0
  t82 = 0.1e1 / r0
  t83 = t2 * t82
  t86 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t13 + 0.12382500000000000000000000000000000000000000000000e-1 * t10
  t89 = 0.1e1 + t13 * t86 / 0.2e1
  t90 = t89 ** 2
  t91 = 0.1e1 / t90
  t96 = t1 * t3 * t2
  t97 = t6 * t81
  t101 = t18 * t19 * t2
  t104 = t5 / t21 / r0
  t107 = jnp.pi ** 2
  t108 = 0.1e1 / t107
  t109 = 0.1e1 / t57
  t110 = t108 * t109
  t113 = t1 * t3 * t108
  t114 = t6 * t59
  t117 = -0.18780000000000000000000000000000000000000000000000e-1 * t83 + 0.13173750000000000000000000000000000000000000000000e-2 * t96 * t97 - 0.23775000000000000000000000000000000000000000000000e-3 * t101 * t104 + 0.63900000000000000000000000000000000000000000000000e-4 * t110 - 0.54014062500000000000000000000000000000000000000000e-6 * t113 * t114
  t119 = 0.36798313500000000000000000000000000000000000000000e-2 * t83 * t91 - t55 * t117
  t120 = t81 * t119
  t121 = 4 ** (0.1e1 / 0.6e1)
  t122 = t78 * t121
  t123 = t13 * t10
  t124 = t21 * t123
  t125 = 0.1e1 / t89
  t129 = t55 ** 2
  t131 = 0.19711289000000000000000000000000000000000000000000e-2 * t122 * t124 * t125 - 0.2e1 * t129
  t132 = 0.1e1 / t131
  t133 = t132 * s0
  t135 = t79 * t120 * t133
  t137 = t55 * t75 + 0.99491666666666666666666666666666666666666666666666e-2 * t135
  t140 = -0.2e1 * t30 + 0.11696446794910408141662685001236899248561775660981e1 * t53
  t141 = jnp.sqrt(0.4e1)
  t142 = t140 * t141
  t143 = t123 * t125
  t146 = t6 * t21
  t150 = 0.30956250000000000000000000000000000000000000000000e-2 * t142 * t143 - 0.79593333333333333333333333333333333333333333333333e-1 * t78 * t146 * t117
  t151 = t150 * t132
  t152 = s0 * t109
  t153 = t151 * t152
  t155 = t119 * t132
  t156 = s0 ** 2
  t157 = t57 ** 2
  t158 = 0.1e1 / t157
  t159 = t156 * t158
  t160 = t155 * t159
  t162 = 0.1e1 + t153 / 0.8e1 - t160 / 0.64e2
  t163 = 0.1e1 / t162
  t164 = t137 * t163
  t167 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t33, 0.2e1 * t37)
  t169 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t33, 0)
  t171 = (t167 + t169 - 0.2e1) * t40
  t173 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t10
  t178 = 0.21947830050000000000000000000000000000000000000000e0 * t13 + 0.48171623250000000000000000000000000000000000000000e-1 * t10 + 0.13081894750000000000000000000000000000000000000000e-1 * t16 + 0.48591338250000000000000000000000000000000000000000e-2 * t24
  t180 = 0.1e1 + 0.1e1 / t178
  t181 = jnp.log(t180)
  t188 = -t30 + t171 * (-t173 * t181 + t30 - 0.58482233974552040708313425006184496242808878304904e0 * t52) + 0.58482233974552040708313425006184496242808878304904e0 * t171 * t52
  t189 = s0 * t59
  t190 = t189 * t18
  t191 = t61 * t5
  t192 = 0.0e0 < t188
  t194 = f.my_piecewise3(t192, t188, -t188)
  t195 = 0.1e1 / t194
  t196 = t191 * t195
  t199 = 0.1e1 + t190 * t196 / 0.96e2
  t200 = jnp.log(t199)
  t202 = 0.1e1 + 0.66725e-1 * t200
  t203 = 0.1e1 / t202
  t206 = t188 * t203 + 0.69644166666666666666666666666666666666666666666666e-2 * t135
  t209 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t153 - 0.40468750000000000000000000000000000000000000000000e-1 * t160
  t210 = 0.1e1 / t209
  t214 = s0 * t82
  t215 = 0.1e1 / tau0
  t216 = f.my_piecewise3(t31, f.p.zeta_threshold, 1)
  t217 = t215 * t216
  t219 = t4 * t9 * t37
  t221 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t219
  t222 = jnp.sqrt(t219)
  t225 = t219 ** 0.15e1
  t227 = t37 ** 2
  t229 = t20 * t23 * t227
  t231 = 0.23615790870000000000000000000000000000000000000000e0 * t222 + 0.55771035800000000000000000000000000000000000000000e-1 * t219 + 0.12733319050000000000000000000000000000000000000000e-1 * t225 + 0.76629987700000000000000000000000000000000000000000e-2 * t229
  t233 = 0.1e1 + 0.1e1 / t231
  t234 = jnp.log(t233)
  t235 = t221 * t234
  t237 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t219
  t242 = 0.17489865900000000000000000000000000000000000000000e0 * t222 + 0.30591644850000000000000000000000000000000000000000e-1 * t219 + 0.37162376550000000000000000000000000000000000000000e-2 * t225 + 0.41939708850000000000000000000000000000000000000000e-2 * t229
  t244 = 0.1e1 + 0.1e1 / t242
  t245 = jnp.log(t244)
  t246 = t237 * t245
  t247 = t41 * t246
  t249 = -t235 + 0.58482233974552040708313425006184496242808878304904e0 * t247
  t250 = 0.0e0 < t249
  t252 = f.my_piecewise3(t250, t249, -t249)
  t254 = t227 / t252
  t255 = t191 * t254
  t258 = 0.1e1 + t190 * t255 / 0.96e2
  t259 = jnp.log(t258)
  t261 = 0.1e1 + 0.66725e-1 * t259
  t262 = 0.1e1 / t261
  t264 = t78 * t97
  t267 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t222 + 0.12382500000000000000000000000000000000000000000000e-1 * t219
  t270 = 0.1e1 + t222 * t267 / 0.2e1
  t271 = t270 ** 2
  t272 = 0.1e1 / t271
  t276 = t97 * t37
  t279 = t104 * t227
  t283 = t114 * t37
  t286 = -0.37560000000000000000000000000000000000000000000000e-1 * t83 + 0.26347500000000000000000000000000000000000000000000e-2 * t96 * t276 - 0.47550000000000000000000000000000000000000000000000e-3 * t101 * t279 + 0.25560000000000000000000000000000000000000000000000e-3 * t110 - 0.21605625000000000000000000000000000000000000000000e-5 * t113 * t283
  t288 = 0.73596627000000000000000000000000000000000000000000e-2 * t83 * t272 - t249 * t286
  t289 = t37 * t288
  t290 = t21 * t37
  t291 = t222 * t219
  t292 = 0.1e1 / t270
  t293 = t291 * t292
  t297 = t249 ** 2
  t299 = 0.98556445000000000000000000000000000000000000000000e-3 * t122 * t290 * t293 - 0.2e1 * t297
  t300 = 0.1e1 / t299
  t301 = t300 * s0
  t302 = t289 * t301
  t303 = t264 * t302
  t305 = t249 * t262 + 0.49745833333333333333333333333333333333333333333334e-2 * t303
  t308 = -0.2e1 * t235 + 0.11696446794910408141662685001236899248561775660981e1 * t247
  t309 = t308 * t141
  t315 = 0.30956250000000000000000000000000000000000000000000e-2 * t309 * t293 - 0.39796666666666666666666666666666666666666666666667e-1 * t79 * t290 * t286
  t316 = t315 * t300
  t317 = t316 * t152
  t319 = t288 * t300
  t320 = t319 * t159
  t322 = 0.1e1 + t317 / 0.8e1 - t320 / 0.64e2
  t323 = 0.1e1 / t322
  t324 = t305 * t323
  t326 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t219
  t331 = 0.21947830050000000000000000000000000000000000000000e0 * t222 + 0.48171623250000000000000000000000000000000000000000e-1 * t219 + 0.13081894750000000000000000000000000000000000000000e-1 * t225 + 0.48591338250000000000000000000000000000000000000000e-2 * t229
  t333 = 0.1e1 + 0.1e1 / t331
  t334 = jnp.log(t333)
  t341 = -t235 + t171 * (-t326 * t334 + t235 - 0.58482233974552040708313425006184496242808878304904e0 * t246) + 0.58482233974552040708313425006184496242808878304904e0 * t171 * t246
  t342 = 0.0e0 < t341
  t344 = f.my_piecewise3(t342, t341, -t341)
  t346 = t5 / t344
  t347 = t62 * t346
  t350 = 0.1e1 + t60 * t347 / 0.96e2
  t351 = jnp.log(t350)
  t353 = 0.1e1 + 0.66725e-1 * t351
  t354 = 0.1e1 / t353
  t357 = t341 * t354 + 0.34822083333333333333333333333333333333333333333334e-2 * t303
  t360 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t317 - 0.40468750000000000000000000000000000000000000000000e-1 * t320
  t361 = 0.1e1 / t360
  t365 = t324 + t171 * (t357 * t361 - t324)
  t366 = t217 * t365
  t370 = t4 * t97 * t29
  t371 = 0.11073577833333333333333333333333333333333333333333e-2 * t370
  t372 = t26 ** 2
  t375 = 0.1e1 / t13
  t377 = t3 * t6
  t378 = t377 * t81
  t379 = t375 * t1 * t378
  t381 = t4 * t97
  t383 = t10 ** 0.5e0
  t385 = t383 * t1 * t378
  t387 = t20 * t104
  t392 = t12 / t372 * (-0.39359651450000000000000000000000000000000000000000e-1 * t379 - 0.18590345266666666666666666666666666666666666666667e-1 * t381 - 0.63666595250000000000000000000000000000000000000000e-2 * t385 - 0.51086658466666666666666666666666666666666666666667e-2 * t387) / t28
  t395 = t377 * t81 * t51
  t396 = t41 * t1 * t395
  t399 = t48 ** 2
  t400 = 0.1e1 / t399
  t405 = -0.29149776500000000000000000000000000000000000000000e-1 * t379 - 0.10197214950000000000000000000000000000000000000000e-1 * t381 - 0.18581188275000000000000000000000000000000000000000e-2 * t385 - 0.27959805900000000000000000000000000000000000000000e-2 * t387
  t407 = 0.1e1 / t50
  t408 = t400 * t405 * t407
  t409 = t41 * t43 * t408
  t411 = t371 + t392 - 0.18311555036753159941307229983139571945136646663793e-3 * t396 - 0.58482233974552040708313425006184496242808878304904e0 * t409
  t413 = t74 ** 2
  t415 = t55 / t413
  t416 = t57 * r0
  t418 = 0.1e1 / t7 / t416
  t419 = t56 * t418
  t422 = t59 * t18
  t423 = t56 * t422
  t424 = t65 ** 2
  t427 = f.my_piecewise3(t63, t411, -t411)
  t433 = 0.1e1 / t71
  t439 = t79 * t59 * t119 * t133
  t441 = t2 * t109
  t455 = -t375 * t86 * t1 * t378 / 0.12e2 + t13 * (-0.66066666666666666666666666666666666666666666666667e-2 * t379 - 0.41275000000000000000000000000000000000000000000000e-2 * t381) / 0.2e1
  t465 = t5 / t21 / t57
  t468 = 0.1e1 / t416
  t469 = t108 * t468
  t471 = t6 * t418
  t474 = 0.18780000000000000000000000000000000000000000000000e-1 * t441 - 0.17565000000000000000000000000000000000000000000000e-2 * t96 * t114 + 0.39625000000000000000000000000000000000000000000000e-3 * t101 * t465 - 0.12780000000000000000000000000000000000000000000000e-3 * t469 + 0.12603281250000000000000000000000000000000000000000e-5 * t113 * t471
  t476 = -0.36798313500000000000000000000000000000000000000000e-2 * t441 * t91 - 0.73596627000000000000000000000000000000000000000000e-2 * t83 / t90 / t89 * t455 - t411 * t117 - t55 * t474
  t479 = t79 * t81 * t476 * t133
  t481 = t131 ** 2
  t482 = 0.1e1 / t481
  t483 = t119 * t482
  t488 = t121 ** 2
  t489 = t488 ** 2
  t491 = t62 * t489 * t121
  t502 = 0.13140859333333333333333333333333333333333333333333e-2 * t122 * t8 * t123 * t125 - 0.98556445000000000000000000000000000000000000000000e-3 * t491 * t22 * t13 * t125 - 0.19711289000000000000000000000000000000000000000000e-2 * t122 * t124 * t91 * t455 - 0.4e1 * t55 * t411
  t505 = t264 * t483 * s0 * t502
  t508 = (t411 * t75 - 0.66725e-1 * t415 * (-0.7e1 / 0.288e3 * t419 * t68 - t423 * t191 / t424 * t427 / 0.96e2) * t433 - 0.13265555555555555555555555555555555555555555555555e-1 * t439 + 0.99491666666666666666666666666666666666666666666666e-2 * t479 - 0.99491666666666666666666666666666666666666666666666e-2 * t505) * t163
  t509 = t162 ** 2
  t511 = t137 / t509
  t539 = (0.30956250000000000000000000000000000000000000000000e-2 * (0.22147155666666666666666666666666666666666666666666e-2 * t370 + 0.2e1 * t392 - 0.36623110073506319882614459966279143890273293327587e-3 * t396 - 0.11696446794910408141662685001236899248561775660981e1 * t409) * t141 * t143 - 0.61912500000000000000000000000000000000000000000000e-2 * t140 * t121 * t13 * t125 * t1 * t3 * t81 - 0.30956250000000000000000000000000000000000000000000e-2 * t142 * t123 * t91 * t455 - 0.53062222222222222222222222222222222222222222222222e-1 * t78 * t9 * t117 - 0.79593333333333333333333333333333333333333333333333e-1 * t78 * t146 * t474) * t132 * t152
  t543 = t150 * t482 * t152 * t502
  t545 = s0 * t468
  t546 = t151 * t545
  t549 = t476 * t132 * t159
  t552 = t483 * t159 * t502
  t556 = t156 / t157 / r0
  t557 = t155 * t556
  t560 = t511 * (t539 / 0.8e1 - t543 / 0.8e1 - t546 / 0.4e1 - t549 / 0.64e2 + t552 / 0.64e2 + t557 / 0.16e2)
  t564 = t178 ** 2
  t590 = t371 + t392 + t171 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t97 * t181 + t173 / t564 * (-0.36579716750000000000000000000000000000000000000000e-1 * t379 - 0.16057207750000000000000000000000000000000000000000e-1 * t381 - 0.65409473750000000000000000000000000000000000000000e-2 * t385 - 0.32394225500000000000000000000000000000000000000000e-2 * t387) / t180 - t371 - t392 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t97 * t51 + 0.58482233974552040708313425006184496242808878304904e0 * t43 * t400 * t405 * t407) - 0.18311555036753159941307229983139571945136646663793e-3 * t171 * t1 * t395 - 0.58482233974552040708313425006184496242808878304904e0 * t171 * t43 * t408
  t592 = t202 ** 2
  t594 = t188 / t592
  t596 = s0 * t418 * t18
  t599 = t194 ** 2
  t602 = f.my_piecewise3(t192, t590, -t590)
  t608 = 0.1e1 / t199
  t617 = t209 ** 2
  t619 = t206 / t617
  t632 = t4 * t6
  t633 = t81 * t37
  t635 = t632 * t633 * t234
  t636 = 0.11073577833333333333333333333333333333333333333333e-2 * t635
  t637 = t231 ** 2
  t640 = 0.1e1 / t222
  t643 = t640 * t1 * t3 * t276
  t645 = t4 * t276
  t647 = t219 ** 0.5e0
  t650 = t647 * t1 * t3 * t276
  t652 = t20 * t279
  t657 = t221 / t637 * (-0.39359651450000000000000000000000000000000000000000e-1 * t643 - 0.18590345266666666666666666666666666666666666666667e-1 * t645 - 0.63666595250000000000000000000000000000000000000000e-2 * t650 - 0.51086658466666666666666666666666666666666666666667e-2 * t652) / t233
  t660 = t97 * t37 * t245
  t661 = t41 * t4 * t660
  t664 = t242 ** 2
  t665 = 0.1e1 / t664
  t670 = -0.29149776500000000000000000000000000000000000000000e-1 * t643 - 0.10197214950000000000000000000000000000000000000000e-1 * t645 - 0.18581188275000000000000000000000000000000000000000e-2 * t650 - 0.27959805900000000000000000000000000000000000000000e-2 * t652
  t672 = 0.1e1 / t244
  t673 = t665 * t670 * t672
  t674 = t41 * t237 * t673
  t676 = t636 + t657 - 0.18311555036753159941307229983139571945136646663793e-3 * t661 - 0.58482233974552040708313425006184496242808878304904e0 * t674
  t678 = t261 ** 2
  t680 = t249 / t678
  t685 = t252 ** 2
  t688 = f.my_piecewise3(t250, t676, -t676)
  t694 = 0.1e1 / t258
  t699 = t78 * t114 * t302
  t715 = -t640 * t267 * t1 * t377 * t633 / 0.12e2 + t222 * (-0.66066666666666666666666666666666666666666666666667e-2 * t643 - 0.41275000000000000000000000000000000000000000000000e-2 * t645) / 0.2e1
  t730 = 0.37560000000000000000000000000000000000000000000000e-1 * t441 - 0.35130000000000000000000000000000000000000000000000e-2 * t96 * t283 + 0.79250000000000000000000000000000000000000000000000e-3 * t101 * t465 * t227 - 0.51120000000000000000000000000000000000000000000000e-3 * t469 + 0.50413125000000000000000000000000000000000000000000e-5 * t113 * t471 * t37
  t732 = -0.73596627000000000000000000000000000000000000000000e-2 * t441 * t272 - 0.14719325400000000000000000000000000000000000000000e-1 * t83 / t271 / t270 * t715 - t676 * t286 - t249 * t730
  t735 = t264 * t37 * t732 * t301
  t737 = t299 ** 2
  t738 = 0.1e1 / t737
  t740 = t8 * t37
  t745 = t222 * t292
  t758 = 0.65704296666666666666666666666666666666666666666667e-3 * t122 * t740 * t293 - 0.49278222500000000000000000000000000000000000000000e-3 * t491 * t22 * t227 * t745 - 0.98556445000000000000000000000000000000000000000000e-3 * t78 * t121 * t21 * t37 * t291 * t272 * t715 - 0.4e1 * t249 * t676
  t761 = t264 * t289 * t738 * s0 * t758
  t764 = (t676 * t262 - 0.66725e-1 * t680 * (-0.7e1 / 0.288e3 * t596 * t255 - t189 * t62 * t5 * t227 / t685 * t688 / 0.96e2) * t694 - 0.66327777777777777777777777777777777777777777777779e-2 * t699 + 0.49745833333333333333333333333333333333333333333334e-2 * t735 - 0.49745833333333333333333333333333333333333333333334e-2 * t761) * t323
  t765 = t322 ** 2
  t767 = t305 / t765
  t793 = (0.30956250000000000000000000000000000000000000000000e-2 * (0.22147155666666666666666666666666666666666666666666e-2 * t635 + 0.2e1 * t657 - 0.36623110073506319882614459966279143890273293327587e-3 * t661 - 0.11696446794910408141662685001236899248561775660981e1 * t674) * t141 * t293 - 0.61912500000000000000000000000000000000000000000000e-2 * t308 * t121 * t745 * t4 * t633 - 0.30956250000000000000000000000000000000000000000000e-2 * t309 * t291 * t272 * t715 - 0.26531111111111111111111111111111111111111111111111e-1 * t79 * t740 * t286 - 0.39796666666666666666666666666666666666666666666667e-1 * t79 * t290 * t730) * t300 * t152
  t797 = t315 * t738 * t152 * t758
  t799 = t316 * t545
  t802 = t732 * t300 * t159
  t806 = t288 * t738 * t159 * t758
  t808 = t319 * t556
  t811 = t767 * (t793 / 0.8e1 - t797 / 0.8e1 - t799 / 0.4e1 - t802 / 0.64e2 + t806 / 0.64e2 + t808 / 0.16e2)
  t815 = t331 ** 2
  t841 = t636 + t657 + t171 * (0.53236443333333333333333333333333333333333333333333e-3 * t632 * t633 * t334 + t326 / t815 * (-0.36579716750000000000000000000000000000000000000000e-1 * t643 - 0.16057207750000000000000000000000000000000000000000e-1 * t645 - 0.65409473750000000000000000000000000000000000000000e-2 * t650 - 0.32394225500000000000000000000000000000000000000000e-2 * t652) / t333 - t636 - t657 + 0.18311555036753159941307229983139571945136646663793e-3 * t632 * t633 * t245 + 0.58482233974552040708313425006184496242808878304904e0 * t237 * t665 * t670 * t672) - 0.18311555036753159941307229983139571945136646663793e-3 * t171 * t4 * t660 - 0.58482233974552040708313425006184496242808878304904e0 * t171 * t237 * t673
  t843 = t353 ** 2
  t845 = t341 / t843
  t848 = t344 ** 2
  t851 = f.my_piecewise3(t342, t841, -t841)
  t857 = 0.1e1 / t350
  t866 = t360 ** 2
  t868 = t357 / t866
  vrho_0_ = t164 + t41 * (t206 * t210 - t164) - t214 * t366 / 0.8e1 + r0 * (t508 - t560 + t41 * ((t590 * t203 - 0.66725e-1 * t594 * (-0.7e1 / 0.288e3 * t596 * t196 - t190 * t191 / t599 * t602 / 0.96e2) * t608 - 0.92858888888888888888888888888888888888888888888888e-2 * t439 + 0.69644166666666666666666666666666666666666666666666e-2 * t479 - 0.69644166666666666666666666666666666666666666666666e-2 * t505) * t210 - t619 * (0.18750000000000000000000000000000000000000000000000e0 * t539 - 0.18750000000000000000000000000000000000000000000000e0 * t543 - 0.37500000000000000000000000000000000000000000000000e0 * t546 - 0.40468750000000000000000000000000000000000000000000e-1 * t549 + 0.40468750000000000000000000000000000000000000000000e-1 * t552 + 0.16187500000000000000000000000000000000000000000000e0 * t557) - t508 + t560) + t152 * t366 / 0.8e1 - t214 * t217 * (t764 - t811 + t171 * ((t841 * t354 - 0.66725e-1 * t845 * (-0.7e1 / 0.288e3 * t419 * t347 - t423 * t191 / t848 * t851 / 0.96e2) * t857 - 0.46429444444444444444444444444444444444444444444445e-2 * t699 + 0.34822083333333333333333333333333333333333333333334e-2 * t735 - 0.34822083333333333333333333333333333333333333333334e-2 * t761) * t361 - t868 * (0.18750000000000000000000000000000000000000000000000e0 * t793 - 0.18750000000000000000000000000000000000000000000000e0 * t797 - 0.37500000000000000000000000000000000000000000000000e0 * t799 - 0.40468750000000000000000000000000000000000000000000e-1 * t802 + 0.40468750000000000000000000000000000000000000000000e-1 * t806 + 0.16187500000000000000000000000000000000000000000000e0 * t808) - t764 + t811)) / 0.8e1)
  t885 = t37 * t59
  t892 = t79 * t120 * t132
  t895 = (-0.69505208333333333333333333333333333333333333333333e-3 * t415 * t885 * t62 * t67 * t433 + 0.99491666666666666666666666666666666666666666666666e-2 * t892) * t163
  t896 = t151 * t109
  t898 = s0 * t158
  t899 = t155 * t898
  t902 = t511 * (t896 / 0.8e1 - t899 / 0.32e2)
  t918 = t216 * t365
  t927 = t79 * t633 * t319
  t930 = (-0.69505208333333333333333333333333333333333333333333e-3 * t680 * t422 * t191 * t254 * t694 + 0.49745833333333333333333333333333333333333333333334e-2 * t927) * t323
  t931 = t316 * t109
  t933 = t319 * t898
  t936 = t767 * (t931 / 0.8e1 - t933 / 0.32e2)
  vsigma_0_ = r0 * (t895 - t902 + t41 * ((-0.69505208333333333333333333333333333333333333333333e-3 * t594 * t422 * t191 * t195 * t608 + 0.69644166666666666666666666666666666666666666666666e-2 * t892) * t210 - t619 * (0.18750000000000000000000000000000000000000000000000e0 * t896 - 0.80937500000000000000000000000000000000000000000000e-1 * t899) - t895 + t902) - t82 * t215 * t918 / 0.8e1 - t214 * t217 * (t930 - t936 + t171 * ((-0.69505208333333333333333333333333333333333333333333e-3 * t845 * t885 * t62 * t346 * t857 + 0.34822083333333333333333333333333333333333333333334e-2 * t927) * t361 - t868 * (0.18750000000000000000000000000000000000000000000000e0 * t931 - 0.80937500000000000000000000000000000000000000000000e-1 * t933) - t930 + t936)) / 0.8e1)
  vlapl_0_ = 0.0e0
  t956 = tau0 ** 2
  vtau_0_ = s0 / t956 * t918 / 0.8e1
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t12 = t6 * t11
  t13 = t4 * t12
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t23 = 0.1e1 / t22
  t24 = t5 * t23
  t25 = t21 * t24
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t27
  t31 = jnp.log(t30)
  t34 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t40 = 0.1e1 / t14
  t41 = t40 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t53 = 0.1e1 / t22 / r0
  t54 = t5 * t53
  t55 = t21 * t54
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t61 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t64 = t63 * f.p.zeta_threshold
  t65 = f.my_piecewise3(t62, t64, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t71 = 0.1e1 / (0.2e1 * t68 - 0.2e1)
  t72 = (0.2e1 * t65 - 0.2e1) * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t78
  t82 = jnp.log(t81)
  t84 = t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t102 = t34 + t61 - 0.18311555036753159941307229983139571945136646663793e-3 * t73 * t84 - 0.58482233974552040708313425006184496242808878304903e0 * t89 * t99
  t103 = t68 * s0
  t104 = r0 ** 2
  t106 = 0.1e1 / t7 / t104
  t107 = t103 * t106
  t108 = 0.1e1 / t3
  t109 = t19 * t108
  t111 = 0.62182e-1 * t36 * t31
  t112 = t88 * t82
  t115 = -t111 + 0.19751789702565206228825776161588751761046270558698e-1 * t72 * t112
  t116 = 0.0e0 < t115
  t118 = f.my_piecewise3(t116, t115, -t115)
  t121 = t109 * t5 / t118
  t124 = 0.1e1 + t107 * t121 / 0.96e2
  t125 = jnp.log(t124)
  t127 = 0.1e1 + 0.66725e-1 * t125
  t128 = 0.1e1 / t127
  t130 = t127 ** 2
  t131 = 0.1e1 / t130
  t132 = t115 * t131
  t133 = t104 * r0
  t135 = 0.1e1 / t7 / t133
  t136 = t103 * t135
  t140 = t103 * t106 * t19
  t141 = t108 * t5
  t142 = t118 ** 2
  t143 = 0.1e1 / t142
  t145 = f.my_piecewise3(t116, t102, -t102)
  t147 = t141 * t143 * t145
  t150 = -0.7e1 / 0.288e3 * t136 * t121 - t140 * t147 / 0.96e2
  t151 = 0.1e1 / t124
  t152 = t150 * t151
  t156 = t1 / t20
  t157 = t156 * t6
  t158 = 0.1e1 / r0
  t159 = t2 * t158
  t162 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t14 + 0.12382500000000000000000000000000000000000000000000e-1 * t13
  t165 = 0.1e1 + t14 * t162 / 0.2e1
  t166 = t165 ** 2
  t167 = 0.1e1 / t166
  t172 = t1 * t3 * t2
  t176 = t19 * t20 * t2
  t179 = jnp.pi ** 2
  t180 = 0.1e1 / t179
  t181 = 0.1e1 / t104
  t182 = t180 * t181
  t185 = t1 * t3 * t180
  t186 = t6 * t106
  t189 = -0.18780000000000000000000000000000000000000000000000e-1 * t159 + 0.13173750000000000000000000000000000000000000000000e-2 * t172 * t10 - 0.23775000000000000000000000000000000000000000000000e-3 * t176 * t54 + 0.63900000000000000000000000000000000000000000000000e-4 * t182 - 0.54014062500000000000000000000000000000000000000000e-6 * t185 * t186
  t191 = 0.36798313500000000000000000000000000000000000000000e-2 * t159 * t167 - t115 * t189
  t193 = 4 ** (0.1e1 / 0.6e1)
  t194 = t156 * t193
  t195 = t14 * t13
  t196 = t22 * t195
  t197 = 0.1e1 / t165
  t201 = t115 ** 2
  t203 = 0.19711288999999999999999999999999999999999999999999e-2 * t194 * t196 * t197 - 0.2e1 * t201
  t204 = 0.1e1 / t203
  t205 = t204 * s0
  t207 = t157 * t106 * t191 * t205
  t209 = t2 * t181
  t213 = 0.1e1 / t166 / t165
  t215 = t40 * t162 * t1
  t220 = -0.66066666666666666666666666666666666666666666666667e-2 * t44 - 0.41275000000000000000000000000000000000000000000000e-2 * t46
  t223 = -t215 * t43 / 0.12e2 + t14 * t220 / 0.2e1
  t224 = t213 * t223
  t232 = 0.1e1 / t22 / t104
  t233 = t5 * t232
  t236 = 0.1e1 / t133
  t237 = t180 * t236
  t239 = t6 * t135
  t242 = 0.18780000000000000000000000000000000000000000000000e-1 * t209 - 0.17565000000000000000000000000000000000000000000000e-2 * t172 * t186 + 0.39625000000000000000000000000000000000000000000000e-3 * t176 * t233 - 0.12780000000000000000000000000000000000000000000000e-3 * t237 + 0.12603281250000000000000000000000000000000000000000e-5 * t185 * t239
  t244 = -0.36798313500000000000000000000000000000000000000000e-2 * t209 * t167 - 0.73596627000000000000000000000000000000000000000000e-2 * t159 * t224 - t102 * t189 - t115 * t242
  t247 = t157 * t9 * t244 * t205
  t249 = t156 * t10
  t250 = t203 ** 2
  t251 = 0.1e1 / t250
  t252 = t191 * t251
  t253 = t11 * t195
  t257 = t193 ** 2
  t258 = t257 ** 2
  t259 = t258 * t193
  t260 = t109 * t259
  t261 = t23 * t14
  t265 = t167 * t223
  t271 = 0.13140859333333333333333333333333333333333333333333e-2 * t194 * t253 * t197 - 0.98556444999999999999999999999999999999999999999995e-3 * t260 * t261 * t197 - 0.19711288999999999999999999999999999999999999999999e-2 * t194 * t196 * t265 - 0.4e1 * t115 * t102
  t272 = s0 * t271
  t273 = t252 * t272
  t274 = t249 * t273
  t276 = t102 * t128 - 0.66725e-1 * t132 * t152 - 0.13265555555555555555555555555555555555555555555555e-1 * t207 + 0.99491666666666666666666666666666666666666666666664e-2 * t247 - 0.99491666666666666666666666666666666666666666666664e-2 * t274
  t277 = jnp.sqrt(0.4e1)
  t278 = t115 * t277
  t279 = t195 * t197
  t282 = t6 * t22
  t286 = 0.61912500000000000000000000000000000000000000000000e-2 * t278 * t279 - 0.79593333333333333333333333333333333333333333333331e-1 * t156 * t282 * t189
  t287 = t286 * t204
  t288 = s0 * t181
  t289 = t287 * t288
  t291 = t191 * t204
  t292 = s0 ** 2
  t293 = t104 ** 2
  t294 = 0.1e1 / t293
  t295 = t292 * t294
  t296 = t291 * t295
  t298 = 0.1e1 + t289 / 0.8e1 - t296 / 0.64e2
  t299 = 0.1e1 / t298
  t300 = t276 * t299
  t305 = t157 * t9 * t191 * t205
  t307 = t115 * t128 + 0.99491666666666666666666666666666666666666666666664e-2 * t305
  t308 = t298 ** 2
  t309 = 0.1e1 / t308
  t310 = t307 * t309
  t311 = t102 * t277
  t314 = t115 * t193
  t315 = t314 * t14
  t316 = t197 * t1
  t318 = t316 * t3 * t9
  t321 = t195 * t167
  t322 = t321 * t223
  t331 = 0.61912500000000000000000000000000000000000000000000e-2 * t311 * t279 - 0.12382500000000000000000000000000000000000000000000e-1 * t315 * t318 - 0.61912500000000000000000000000000000000000000000000e-2 * t278 * t322 - 0.53062222222222222222222222222222222222222222222221e-1 * t156 * t12 * t189 - 0.79593333333333333333333333333333333333333333333331e-1 * t156 * t282 * t242
  t332 = t331 * t204
  t333 = t332 * t288
  t335 = t286 * t251
  t336 = t288 * t271
  t337 = t335 * t336
  t339 = s0 * t236
  t340 = t287 * t339
  t342 = t244 * t204
  t343 = t342 * t295
  t345 = t295 * t271
  t346 = t252 * t345
  t350 = t292 / t293 / r0
  t351 = t291 * t350
  t353 = t333 / 0.8e1 - t337 / 0.8e1 - t340 / 0.4e1 - t343 / 0.64e2 + t346 / 0.64e2 + t351 / 0.16e2
  t354 = t310 * t353
  t358 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t64, 0.2e1 * t68)
  t360 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t64, 0)
  t362 = (t358 + t360 - 0.2e1) * t71
  t367 = 0.70594500000000000000000000000000000000000000000000e1 * t14 + 0.15494250000000000000000000000000000000000000000000e1 * t13 + 0.42077500000000000000000000000000000000000000000000e0 * t17 + 0.15629250000000000000000000000000000000000000000000e0 * t25
  t370 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t367
  t371 = jnp.log(t370)
  t376 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t13
  t377 = t367 ** 2
  t378 = 0.1e1 / t377
  t379 = t376 * t378
  t384 = -0.11765750000000000000000000000000000000000000000000e1 * t44 - 0.51647500000000000000000000000000000000000000000000e0 * t46 - 0.21038750000000000000000000000000000000000000000000e0 * t50 - 0.10419500000000000000000000000000000000000000000000e0 * t55
  t385 = 0.1e1 / t370
  t386 = t384 * t385
  t392 = t88 * t91
  t393 = t96 * t98
  t398 = t362 * t1
  t401 = t362 * t88
  t404 = t34 + t61 + t362 * (0.53236443333333333333333333333333333333333333333332e-3 * t4 * t10 * t371 + 0.99999999999999999999999999999999999999999999999999e0 * t379 * t386 - t34 - t61 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t10 * t82 + 0.58482233974552040708313425006184496242808878304903e0 * t392 * t393) - 0.18311555036753159941307229983139571945136646663793e-3 * t398 * t84 - 0.58482233974552040708313425006184496242808878304903e0 * t401 * t99
  t405 = s0 * t106
  t406 = t405 * t19
  t414 = -t111 + t362 * (-0.31090e-1 * t376 * t371 + t111 - 0.19751789702565206228825776161588751761046270558698e-1 * t112) + 0.19751789702565206228825776161588751761046270558698e-1 * t362 * t112
  t415 = 0.0e0 < t414
  t417 = f.my_piecewise3(t415, t414, -t414)
  t419 = t141 / t417
  t422 = 0.1e1 + t406 * t419 / 0.96e2
  t423 = jnp.log(t422)
  t425 = 0.1e1 + 0.66725e-1 * t423
  t426 = 0.1e1 / t425
  t428 = t425 ** 2
  t429 = 0.1e1 / t428
  t430 = t414 * t429
  t431 = s0 * t135
  t432 = t431 * t19
  t435 = t417 ** 2
  t436 = 0.1e1 / t435
  t438 = f.my_piecewise3(t415, t404, -t404)
  t440 = t141 * t436 * t438
  t443 = -0.7e1 / 0.288e3 * t432 * t419 - t406 * t440 / 0.96e2
  t444 = 0.1e1 / t422
  t445 = t443 * t444
  t451 = t404 * t426 - 0.66725e-1 * t430 * t445 - 0.92858888888888888888888888888888888888888888888886e-2 * t207 + 0.69644166666666666666666666666666666666666666666665e-2 * t247 - 0.69644166666666666666666666666666666666666666666665e-2 * t274
  t454 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t289 - 0.40468750000000000000000000000000000000000000000000e-1 * t296
  t455 = 0.1e1 / t454
  t459 = t414 * t426 + 0.69644166666666666666666666666666666666666666666665e-2 * t305
  t460 = t454 ** 2
  t461 = 0.1e1 / t460
  t462 = t459 * t461
  t469 = 0.18750000000000000000000000000000000000000000000000e0 * t333 - 0.18750000000000000000000000000000000000000000000000e0 * t337 - 0.37500000000000000000000000000000000000000000000000e0 * t340 - 0.40468750000000000000000000000000000000000000000000e-1 * t343 + 0.40468750000000000000000000000000000000000000000000e-1 * t346 + 0.16187500000000000000000000000000000000000000000000e0 * t351
  t475 = f.my_piecewise3(t62, f.p.zeta_threshold, 1)
  t476 = 0.1e1 / tau0 * t475
  t478 = t4 * t12 * t68
  t480 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t478
  t481 = jnp.sqrt(t478)
  t484 = t478 ** 0.15e1
  t486 = t68 ** 2
  t488 = t21 * t24 * t486
  t490 = 0.37978500000000000000000000000000000000000000000000e1 * t481 + 0.89690000000000000000000000000000000000000000000000e0 * t478 + 0.20477500000000000000000000000000000000000000000000e0 * t484 + 0.12323500000000000000000000000000000000000000000000e0 * t488
  t493 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t490
  t494 = jnp.log(t493)
  t496 = 0.62182e-1 * t480 * t494
  t498 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t478
  t503 = 0.51785000000000000000000000000000000000000000000000e1 * t481 + 0.90577500000000000000000000000000000000000000000000e0 * t478 + 0.11003250000000000000000000000000000000000000000000e0 * t484 + 0.12417750000000000000000000000000000000000000000000e0 * t488
  t506 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t503
  t507 = jnp.log(t506)
  t508 = t498 * t507
  t511 = -t496 + 0.19751789702565206228825776161588751761046270558698e-1 * t72 * t508
  t512 = 0.0e0 < t511
  t514 = f.my_piecewise3(t512, t511, -t511)
  t517 = t141 * t486 / t514
  t520 = 0.1e1 + t406 * t517 / 0.96e2
  t521 = jnp.log(t520)
  t523 = 0.1e1 + 0.66725e-1 * t521
  t524 = 0.1e1 / t523
  t528 = 0.107924e1 + 0.39640000000000000000000000000000000000000000000000e-1 * t481 + 0.12382500000000000000000000000000000000000000000000e-1 * t478
  t531 = 0.1e1 + t481 * t528 / 0.2e1
  t532 = t531 ** 2
  t533 = 0.1e1 / t532
  t537 = t10 * t68
  t540 = t54 * t486
  t544 = t186 * t68
  t547 = -0.37560000000000000000000000000000000000000000000000e-1 * t159 + 0.26347500000000000000000000000000000000000000000000e-2 * t172 * t537 - 0.47550000000000000000000000000000000000000000000000e-3 * t176 * t540 + 0.25560000000000000000000000000000000000000000000000e-3 * t182 - 0.21605625000000000000000000000000000000000000000000e-5 * t185 * t544
  t549 = 0.73596627000000000000000000000000000000000000000000e-2 * t159 * t533 - t511 * t547
  t550 = t68 * t549
  t551 = t22 * t68
  t552 = t481 * t478
  t553 = 0.1e1 / t531
  t554 = t552 * t553
  t558 = t511 ** 2
  t560 = 0.98556445000000000000000000000000000000000000000000e-3 * t194 * t551 * t554 - 0.2e1 * t558
  t561 = 0.1e1 / t560
  t562 = t561 * s0
  t563 = t550 * t562
  t564 = t249 * t563
  t566 = t511 * t524 + 0.49745833333333333333333333333333333333333333333332e-2 * t564
  t567 = t511 * t277
  t573 = 0.61912500000000000000000000000000000000000000000000e-2 * t567 * t554 - 0.39796666666666666666666666666666666666666666666666e-1 * t157 * t551 * t547
  t574 = t573 * t561
  t575 = t574 * t288
  t577 = t549 * t561
  t578 = t577 * t295
  t580 = 0.1e1 + t575 / 0.8e1 - t578 / 0.64e2
  t581 = 0.1e1 / t580
  t582 = t566 * t581
  t584 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t478
  t589 = 0.70594500000000000000000000000000000000000000000000e1 * t481 + 0.15494250000000000000000000000000000000000000000000e1 * t478 + 0.42077500000000000000000000000000000000000000000000e0 * t484 + 0.15629250000000000000000000000000000000000000000000e0 * t488
  t592 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t589
  t593 = jnp.log(t592)
  t601 = -t496 + t362 * (-0.31090e-1 * t584 * t593 + t496 - 0.19751789702565206228825776161588751761046270558698e-1 * t508) + 0.19751789702565206228825776161588751761046270558698e-1 * t362 * t508
  t602 = 0.0e0 < t601
  t604 = f.my_piecewise3(t602, t601, -t601)
  t607 = t109 * t5 / t604
  t610 = 0.1e1 + t107 * t607 / 0.96e2
  t611 = jnp.log(t610)
  t613 = 0.1e1 + 0.66725e-1 * t611
  t614 = 0.1e1 / t613
  t617 = t601 * t614 + 0.34822083333333333333333333333333333333333333333332e-2 * t564
  t620 = 0.1e1 + 0.18750000000000000000000000000000000000000000000000e0 * t575 - 0.40468750000000000000000000000000000000000000000000e-1 * t578
  t621 = 0.1e1 / t620
  t626 = t476 * (t582 + t362 * (t617 * t621 - t582))
  t629 = s0 * t158
  t630 = t4 * t6
  t631 = t9 * t68
  t634 = 0.11073577833333333333333333333333333333333333333333e-2 * t630 * t631 * t494
  t635 = t490 ** 2
  t636 = 0.1e1 / t635
  t637 = t480 * t636
  t638 = 0.1e1 / t481
  t640 = t638 * t1 * t3
  t641 = t640 * t537
  t643 = t4 * t537
  t645 = t478 ** 0.5e0
  t647 = t645 * t1 * t3
  t648 = t647 * t537
  t650 = t21 * t540
  t652 = -0.63297500000000000000000000000000000000000000000000e0 * t641 - 0.29896666666666666666666666666666666666666666666667e0 * t643 - 0.10238750000000000000000000000000000000000000000000e0 * t648 - 0.82156666666666666666666666666666666666666666666667e-1 * t650
  t653 = 0.1e1 / t493
  t654 = t652 * t653
  t656 = 0.10000000000000000000000000000000000000000000000000e1 * t637 * t654
  t657 = t72 * t4
  t658 = t68 * t507
  t659 = t10 * t658
  t662 = t72 * t498
  t663 = t503 ** 2
  t664 = 0.1e1 / t663
  t669 = -0.86308333333333333333333333333333333333333333333334e0 * t641 - 0.30192500000000000000000000000000000000000000000000e0 * t643 - 0.55016250000000000000000000000000000000000000000000e-1 * t648 - 0.82785000000000000000000000000000000000000000000000e-1 * t650
  t671 = 0.1e1 / t506
  t672 = t664 * t669 * t671
  t675 = t634 + t656 - 0.18311555036753159941307229983139571945136646663793e-3 * t657 * t659 - 0.58482233974552040708313425006184496242808878304903e0 * t662 * t672
  t677 = t523 ** 2
  t678 = 0.1e1 / t677
  t679 = t511 * t678
  t682 = t405 * t109
  t683 = t5 * t486
  t684 = t514 ** 2
  t685 = 0.1e1 / t684
  t687 = f.my_piecewise3(t512, t675, -t675)
  t689 = t683 * t685 * t687
  t692 = -0.7e1 / 0.288e3 * t432 * t517 - t682 * t689 / 0.96e2
  t693 = 0.1e1 / t520
  t694 = t692 * t693
  t697 = t156 * t186
  t698 = t697 * t563
  t703 = 0.1e1 / t532 / t531
  t705 = t638 * t528 * t1
  t706 = t42 * t631
  t711 = -0.66066666666666666666666666666666666666666666666667e-2 * t641 - 0.41275000000000000000000000000000000000000000000000e-2 * t643
  t714 = -t705 * t706 / 0.12e2 + t481 * t711 / 0.2e1
  t715 = t703 * t714
  t722 = t233 * t486
  t726 = t239 * t68
  t729 = 0.37560000000000000000000000000000000000000000000000e-1 * t209 - 0.35130000000000000000000000000000000000000000000000e-2 * t172 * t544 + 0.79250000000000000000000000000000000000000000000000e-3 * t176 * t722 - 0.51120000000000000000000000000000000000000000000000e-3 * t237 + 0.50413125000000000000000000000000000000000000000000e-5 * t185 * t726
  t731 = -0.73596627000000000000000000000000000000000000000000e-2 * t209 * t533 - 0.14719325400000000000000000000000000000000000000000e-1 * t159 * t715 - t675 * t547 - t511 * t729
  t732 = t68 * t731
  t733 = t732 * t562
  t734 = t249 * t733
  t736 = t560 ** 2
  t737 = 0.1e1 / t736
  t738 = t737 * s0
  t739 = t11 * t68
  t744 = t481 * t553
  t749 = t156 * t193 * t22
  t750 = t68 * t552
  t751 = t533 * t714
  t752 = t750 * t751
  t757 = 0.65704296666666666666666666666666666666666666666667e-3 * t194 * t739 * t554 - 0.49278222500000000000000000000000000000000000000000e-3 * t260 * t23 * t486 * t744 - 0.98556445000000000000000000000000000000000000000000e-3 * t749 * t752 - 0.4e1 * t511 * t675
  t758 = t738 * t757
  t759 = t550 * t758
  t760 = t249 * t759
  t762 = t675 * t524 - 0.66725e-1 * t679 * t694 - 0.66327777777777777777777777777777777777777777777776e-2 * t698 + 0.49745833333333333333333333333333333333333333333332e-2 * t734 - 0.49745833333333333333333333333333333333333333333332e-2 * t760
  t763 = t762 * t581
  t764 = t580 ** 2
  t765 = 0.1e1 / t764
  t766 = t566 * t765
  t767 = t675 * t277
  t770 = t511 * t193
  t771 = t770 * t744
  t772 = t4 * t631
  t775 = t552 * t533
  t776 = t775 * t714
  t785 = 0.61912500000000000000000000000000000000000000000000e-2 * t767 * t554 - 0.12382500000000000000000000000000000000000000000000e-1 * t771 * t772 - 0.61912500000000000000000000000000000000000000000000e-2 * t567 * t776 - 0.26531111111111111111111111111111111111111111111111e-1 * t157 * t739 * t547 - 0.39796666666666666666666666666666666666666666666666e-1 * t157 * t551 * t729
  t786 = t785 * t561
  t787 = t786 * t288
  t789 = t573 * t737
  t790 = t288 * t757
  t791 = t789 * t790
  t793 = t574 * t339
  t795 = t731 * t561
  t796 = t795 * t295
  t798 = t549 * t737
  t799 = t295 * t757
  t800 = t798 * t799
  t802 = t577 * t350
  t804 = t787 / 0.8e1 - t791 / 0.8e1 - t793 / 0.4e1 - t796 / 0.64e2 + t800 / 0.64e2 + t802 / 0.16e2
  t805 = t766 * t804
  t809 = t589 ** 2
  t810 = 0.1e1 / t809
  t811 = t584 * t810
  t816 = -0.11765750000000000000000000000000000000000000000000e1 * t641 - 0.51647500000000000000000000000000000000000000000000e0 * t643 - 0.21038750000000000000000000000000000000000000000000e0 * t648 - 0.10419500000000000000000000000000000000000000000000e0 * t650
  t817 = 0.1e1 / t592
  t818 = t816 * t817
  t824 = t498 * t664
  t825 = t669 * t671
  t830 = t362 * t4
  t833 = t362 * t498
  t836 = t634 + t656 + t362 * (0.53236443333333333333333333333333333333333333333332e-3 * t630 * t631 * t593 + 0.99999999999999999999999999999999999999999999999999e0 * t811 * t818 - t634 - t656 + 0.18311555036753159941307229983139571945136646663793e-3 * t630 * t631 * t507 + 0.58482233974552040708313425006184496242808878304903e0 * t824 * t825) - 0.18311555036753159941307229983139571945136646663793e-3 * t830 * t659 - 0.58482233974552040708313425006184496242808878304903e0 * t833 * t672
  t838 = t613 ** 2
  t839 = 0.1e1 / t838
  t840 = t601 * t839
  t843 = t604 ** 2
  t844 = 0.1e1 / t843
  t846 = f.my_piecewise3(t602, t836, -t836)
  t848 = t141 * t844 * t846
  t851 = -0.7e1 / 0.288e3 * t136 * t607 - t140 * t848 / 0.96e2
  t852 = 0.1e1 / t610
  t853 = t851 * t852
  t859 = t836 * t614 - 0.66725e-1 * t840 * t853 - 0.46429444444444444444444444444444444444444444444443e-2 * t698 + 0.34822083333333333333333333333333333333333333333332e-2 * t734 - 0.34822083333333333333333333333333333333333333333332e-2 * t760
  t861 = t620 ** 2
  t862 = 0.1e1 / t861
  t863 = t617 * t862
  t870 = 0.18750000000000000000000000000000000000000000000000e0 * t787 - 0.18750000000000000000000000000000000000000000000000e0 * t791 - 0.37500000000000000000000000000000000000000000000000e0 * t793 - 0.40468750000000000000000000000000000000000000000000e-1 * t796 + 0.40468750000000000000000000000000000000000000000000e-1 * t800 + 0.16187500000000000000000000000000000000000000000000e0 * t802
  t875 = t476 * (t763 - t805 + t362 * (t859 * t621 - t863 * t870 - t763 + t805))
  t880 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t186 * t31
  t884 = 0.35616666666666666666666666666666666666666666666666e-1 * t630 * t9 * t38 * t59
  t888 = t57 ** 2
  t891 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t888 * t58
  t892 = 0.1e1 / t195
  t894 = t20 * t5
  t895 = t894 * t232
  t896 = t892 * t19 * t895
  t898 = t42 * t106
  t899 = t41 * t898
  t901 = t4 * t186
  t903 = t13 ** (-0.5e0)
  t905 = t903 * t19 * t895
  t907 = t49 * t898
  t909 = t21 * t233
  t914 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t896 + 0.84396666666666666666666666666666666666666666666666e0 * t899 + 0.39862222222222222222222222222222222222222222222223e0 * t901 + 0.68258333333333333333333333333333333333333333333333e-1 * t905 + 0.13651666666666666666666666666666666666666666666667e0 * t907 + 0.13692777777777777777777777777777777777777777777778e0 * t909) * t58
  t915 = t37 ** 2
  t918 = t30 ** 2
  t922 = 0.16081824322151104821330931780901225435013347914188e2 * t36 / t915 * t888 / t918
  t924 = t42 * t106 * t82
  t927 = t10 * t99
  t931 = 0.1e1 / t90 / t78
  t932 = t96 ** 2
  t934 = t931 * t932 * t98
  t943 = -0.57538888888888888888888888888888888888888888888889e0 * t896 + 0.11507777777777777777777777777777777777777777777778e1 * t899 + 0.40256666666666666666666666666666666666666666666667e0 * t901 + 0.36677500000000000000000000000000000000000000000000e-1 * t905 + 0.73355000000000000000000000000000000000000000000000e-1 * t907 + 0.13797500000000000000000000000000000000000000000000e0 * t909
  t945 = t91 * t943 * t98
  t948 = t90 ** 2
  t949 = 0.1e1 / t948
  t951 = t81 ** 2
  t952 = 0.1e1 / t951
  t953 = t949 * t932 * t952
  t956 = -t880 - t884 - t891 + t914 + t922 + 0.24415406715670879921742973310852762593515528885057e-3 * t73 * t924 + 0.10843580882781524214666447553230042011687479519034e-1 * t657 * t927 + 0.11696446794910408141662685001236899248561775660981e1 * t89 * t934 - 0.58482233974552040708313425006184496242808878304903e0 * t89 * t945 - 0.17315755899375863299672358916972966258900005419821e2 * t89 * t953
  t964 = t150 ** 2
  t965 = t124 ** 2
  t967 = t964 / t965
  t971 = 0.1e1 / t7 / t293
  t972 = t103 * t971
  t976 = t103 * t135 * t19
  t981 = t145 ** 2
  t987 = f.my_piecewise3(t116, t956, -t956)
  t1000 = t157 * t135 * t191 * t205
  t1004 = t157 * t106 * t244 * t205
  t1006 = t697 * t273
  t1008 = t2 * t236
  t1013 = t166 ** 2
  t1015 = t223 ** 2
  t1035 = -t892 * t162 * t19 * t895 / 0.18e2 - t40 * t220 * t1 * t43 / 0.6e1 + t215 * t898 / 0.9e1 + t14 * (-0.44044444444444444444444444444444444444444444444445e-2 * t896 + 0.88088888888888888888888888888888888888888888888889e-2 * t899 + 0.55033333333333333333333333333333333333333333333333e-2 * t901) / 0.2e1
  t1047 = t5 / t22 / t133
  t1050 = t180 * t294
  t1052 = t6 * t971
  t1055 = -0.37560000000000000000000000000000000000000000000000e-1 * t1008 + 0.40985000000000000000000000000000000000000000000000e-2 * t172 * t239 - 0.10566666666666666666666666666666666666666666666667e-2 * t176 * t1047 + 0.38340000000000000000000000000000000000000000000000e-3 * t1050 - 0.42010937500000000000000000000000000000000000000000e-5 * t185 * t1052
  t1057 = 0.73596627000000000000000000000000000000000000000000e-2 * t1008 * t167 + 0.14719325400000000000000000000000000000000000000000e-1 * t209 * t224 + 0.22078988100000000000000000000000000000000000000000e-1 * t159 / t1013 * t1015 - 0.73596627000000000000000000000000000000000000000000e-2 * t159 * t213 * t1035 - t956 * t189 - 0.2e1 * t102 * t242 - t115 * t1055
  t1060 = t157 * t9 * t1057 * t205
  t1062 = t244 * t251
  t1064 = t249 * t1062 * t272
  t1067 = 0.1e1 / t250 / t203
  t1068 = t191 * t1067
  t1069 = t271 ** 2
  t1072 = t249 * t1068 * s0 * t1069
  t1085 = t277 * t181
  t1100 = t102 ** 2
  t1104 = -0.43802864444444444444444444444444444444444444444443e-3 * t194 * t9 * t195 * t197 - 0.2e-52 * t260 * t53 * t14 * t197 - 0.26281718666666666666666666666666666666666666666666e-2 * t194 * t253 * t265 + 0.19711288999999999999999999999999999999999999999999e-2 * t1085 * t40 * t197 + 0.19711288999999999999999999999999999999999999999999e-2 * t260 * t261 * t265 + 0.39422577999999999999999999999999999999999999999998e-2 * t194 * t196 * t213 * t1015 - 0.19711288999999999999999999999999999999999999999999e-2 * t194 * t196 * t167 * t1035 - 0.4e1 * t1100 - 0.4e1 * t115 * t956
  t1107 = t249 * t252 * s0 * t1104
  t1109 = t956 * t128 - 0.133450e0 * t102 * t131 * t152 + 0.8904451250e-2 * t115 / t130 / t127 * t967 - 0.66725e-1 * t132 * (0.35e2 / 0.432e3 * t972 * t121 + 0.7e1 / 0.144e3 * t976 * t147 + t140 * t141 / t142 / t118 * t981 / 0.48e2 - t140 * t141 * t143 * t987 / 0.96e2) * t151 + 0.66725e-1 * t132 * t967 + 0.30952962962962962962962962962962962962962962962962e-1 * t1000 - 0.26531111111111111111111111111111111111111111111110e-1 * t1004 + 0.26531111111111111111111111111111111111111111111110e-1 * t1006 + 0.99491666666666666666666666666666666666666666666664e-2 * t1060 - 0.19898333333333333333333333333333333333333333333333e-1 * t1064 + 0.19898333333333333333333333333333333333333333333333e-1 * t1072 - 0.99491666666666666666666666666666666666666666666664e-2 * t1107
  t1110 = t1109 * t299
  t1113 = 0.2e1 * t276 * t309 * t353
  t1117 = t353 ** 2
  t1119 = 0.2e1 * t307 / t308 / t298 * t1117
  t1162 = 0.61912500000000000000000000000000000000000000000000e-2 * t956 * t277 * t279 - 0.24765000000000000000000000000000000000000000000000e-1 * t102 * t193 * t14 * t318 - 0.12382500000000000000000000000000000000000000000000e-1 * t311 * t322 + 0.20637500000000000000000000000000000000000000000000e-2 * t115 * t259 * t40 * t197 * t19 * t20 * t232 + 0.24765000000000000000000000000000000000000000000000e-1 * t314 * t14 * t167 * t4 * t9 * t223 + 0.16510000000000000000000000000000000000000000000000e-1 * t315 * t316 * t3 * t106 + 0.12382500000000000000000000000000000000000000000000e-1 * t278 * t195 * t213 * t1015 - 0.61912500000000000000000000000000000000000000000000e-2 * t278 * t321 * t1035 + 0.17687407407407407407407407407407407407407407407407e-1 * t156 * t10 * t189 - 0.10612444444444444444444444444444444444444444444444e0 * t156 * t12 * t242 - 0.79593333333333333333333333333333333333333333333331e-1 * t156 * t282 * t1055
  t1164 = t1162 * t204 * t288
  t1167 = t331 * t251 * t336
  t1169 = t332 * t339
  t1173 = t286 * t1067 * t288 * t1069
  t1176 = t335 * t339 * t271
  t1179 = t335 * t288 * t1104
  t1181 = s0 * t294
  t1182 = t287 * t1181
  t1185 = t1057 * t204 * t295
  t1187 = t1062 * t345
  t1189 = t342 * t350
  t1192 = t1068 * t295 * t1069
  t1195 = t252 * t350 * t271
  t1198 = t252 * t295 * t1104
  t1202 = t292 / t293 / t104
  t1203 = t291 * t1202
  t1205 = t1164 / 0.8e1 - t1167 / 0.4e1 - t1169 / 0.2e1 + t1173 / 0.4e1 + t1176 / 0.2e1 - t1179 / 0.8e1 + 0.3e1 / 0.4e1 * t1182 - t1185 / 0.64e2 + t1187 / 0.32e2 + t1189 / 0.8e1 - t1192 / 0.32e2 - t1195 / 0.8e1 + t1198 / 0.64e2 - 0.5e1 / 0.16e2 * t1203
  t1206 = t310 * t1205
  t1217 = t384 ** 2
  t1231 = t377 ** 2
  t1234 = t370 ** 2
  t1257 = -0.70981924444444444444444444444444444444444444444442e-3 * t4 * t186 * t371 - 0.34246666666666666666666666666666666666666666666666e-1 * t630 * t9 * t378 * t386 - 0.20000000000000000000000000000000000000000000000000e1 * t376 / t377 / t367 * t1217 * t385 + 0.99999999999999999999999999999999999999999999999999e0 * t379 * (-0.78438333333333333333333333333333333333333333333333e0 * t896 + 0.15687666666666666666666666666666666666666666666667e1 * t899 + 0.68863333333333333333333333333333333333333333333333e0 * t901 + 0.14025833333333333333333333333333333333333333333333e0 * t905 + 0.28051666666666666666666666666666666666666666666667e0 * t907 + 0.17365833333333333333333333333333333333333333333333e0 * t909) * t385 + 0.32164683177870697973624959794146027661627532968800e2 * t376 / t1231 * t1217 / t1234 + t880 + t884 + t891 - t914 - t922 - 0.24415406715670879921742973310852762593515528885057e-3 * t4 * t186 * t82 - 0.10843580882781524214666447553230042011687479519034e-1 * t630 * t9 * t91 * t393 - 0.11696446794910408141662685001236899248561775660981e1 * t88 * t931 * t932 * t98 + 0.58482233974552040708313425006184496242808878304903e0 * t392 * t943 * t98 + 0.17315755899375863299672358916972966258900005419821e2 * t88 * t949 * t932 * t952
  t1269 = -t880 - t884 - t891 + t914 + t922 + t362 * t1257 + 0.24415406715670879921742973310852762593515528885057e-3 * t398 * t924 + 0.10843580882781524214666447553230042011687479519034e-1 * t830 * t927 + 0.11696446794910408141662685001236899248561775660981e1 * t401 * t934 - 0.58482233974552040708313425006184496242808878304903e0 * t401 * t945 - 0.17315755899375863299672358916972966258900005419821e2 * t401 * t953
  t1277 = t443 ** 2
  t1278 = t422 ** 2
  t1280 = t1277 / t1278
  t1284 = s0 * t971 * t19
  t1291 = t438 ** 2
  t1297 = f.my_piecewise3(t415, t1269, -t1269)
  t1315 = t1269 * t426 - 0.133450e0 * t404 * t429 * t445 + 0.8904451250e-2 * t414 / t428 / t425 * t1280 - 0.66725e-1 * t430 * (0.35e2 / 0.432e3 * t1284 * t419 + 0.7e1 / 0.144e3 * t432 * t440 + t406 * t141 / t435 / t417 * t1291 / 0.48e2 - t406 * t141 * t436 * t1297 / 0.96e2) * t444 + 0.66725e-1 * t430 * t1280 + 0.21667074074074074074074074074074074074074074074073e-1 * t1000 - 0.18571777777777777777777777777777777777777777777777e-1 * t1004 + 0.18571777777777777777777777777777777777777777777777e-1 * t1006 + 0.69644166666666666666666666666666666666666666666665e-2 * t1060 - 0.13928833333333333333333333333333333333333333333333e-1 * t1064 + 0.13928833333333333333333333333333333333333333333333e-1 * t1072 - 0.69644166666666666666666666666666666666666666666665e-2 * t1107
  t1323 = t469 ** 2
  t1340 = 0.18750000000000000000000000000000000000000000000000e0 * t1164 - 0.37500000000000000000000000000000000000000000000000e0 * t1167 - 0.75000000000000000000000000000000000000000000000000e0 * t1169 + 0.37500000000000000000000000000000000000000000000000e0 * t1173 + 0.75000000000000000000000000000000000000000000000000e0 * t1176 - 0.18750000000000000000000000000000000000000000000000e0 * t1179 + 0.11250000000000000000000000000000000000000000000000e1 * t1182 - 0.40468750000000000000000000000000000000000000000000e-1 * t1185 + 0.80937500000000000000000000000000000000000000000000e-1 * t1187 + 0.32375000000000000000000000000000000000000000000000e0 * t1189 - 0.80937500000000000000000000000000000000000000000000e-1 * t1192 - 0.32375000000000000000000000000000000000000000000000e0 * t1195 + 0.40468750000000000000000000000000000000000000000000e-1 * t1198 - 0.80937500000000000000000000000000000000000000000000e0 * t1203
  t1348 = t106 * t68
  t1351 = 0.14764770444444444444444444444444444444444444444444e-2 * t630 * t1348 * t494
  t1355 = 0.35616666666666666666666666666666666666666666666666e-1 * t46 * t68 * t636 * t654
  t1359 = t652 ** 2
  t1362 = 0.20000000000000000000000000000000000000000000000000e1 * t480 / t635 / t490 * t1359 * t653
  t1363 = 0.1e1 / t552
  t1366 = t1363 * t19 * t20 * t722
  t1368 = t640 * t544
  t1370 = t4 * t544
  t1372 = t478 ** (-0.5e0)
  t1375 = t1372 * t19 * t20 * t722
  t1377 = t647 * t544
  t1379 = t21 * t722
  t1384 = 0.10000000000000000000000000000000000000000000000000e1 * t637 * (-0.42198333333333333333333333333333333333333333333333e0 * t1366 + 0.84396666666666666666666666666666666666666666666666e0 * t1368 + 0.39862222222222222222222222222222222222222222222223e0 * t1370 + 0.68258333333333333333333333333333333333333333333333e-1 * t1375 + 0.13651666666666666666666666666666666666666666666667e0 * t1377 + 0.13692777777777777777777777777777777777777777777778e0 * t1379) * t653
  t1385 = t635 ** 2
  t1388 = t493 ** 2
  t1392 = 0.16081824322151104821330931780901225435013347914188e2 * t480 / t1385 * t1359 / t1388
  t1393 = t186 * t658
  t1397 = t631 * t672
  t1401 = 0.1e1 / t663 / t503
  t1402 = t669 ** 2
  t1404 = t1401 * t1402 * t671
  t1413 = -0.57538888888888888888888888888888888888888888888889e0 * t1366 + 0.11507777777777777777777777777777777777777777777778e1 * t1368 + 0.40256666666666666666666666666666666666666666666667e0 * t1370 + 0.36677500000000000000000000000000000000000000000000e-1 * t1375 + 0.73355000000000000000000000000000000000000000000000e-1 * t1377 + 0.13797500000000000000000000000000000000000000000000e0 * t1379
  t1415 = t664 * t1413 * t671
  t1418 = t663 ** 2
  t1419 = 0.1e1 / t1418
  t1421 = t506 ** 2
  t1422 = 0.1e1 / t1421
  t1423 = t1419 * t1402 * t1422
  t1426 = -t1351 - t1355 - t1362 + t1384 + t1392 + 0.24415406715670879921742973310852762593515528885057e-3 * t657 * t1393 + 0.10843580882781524214666447553230042011687479519034e-1 * t72 * t630 * t1397 + 0.11696446794910408141662685001236899248561775660981e1 * t662 * t1404 - 0.58482233974552040708313425006184496242808878304903e0 * t662 * t1415 - 0.17315755899375863299672358916972966258900005419821e2 * t662 * t1423
  t1434 = t692 ** 2
  t1435 = t520 ** 2
  t1437 = t1434 / t1435
  t1447 = t687 ** 2
  t1453 = f.my_piecewise3(t512, t1426, -t1426)
  t1465 = t156 * t239 * t563
  t1467 = t697 * t733
  t1469 = t697 * t759
  t1475 = t532 ** 2
  t1477 = t714 ** 2
  t1483 = t232 * t486
  t1500 = -t1363 * t528 * t19 * t894 * t1483 / 0.18e2 - t638 * t711 * t1 * t706 / 0.6e1 + t705 * t42 * t1348 / 0.9e1 + t481 * (-0.44044444444444444444444444444444444444444444444445e-2 * t1366 + 0.88088888888888888888888888888888888888888888888889e-2 * t1368 + 0.55033333333333333333333333333333333333333333333333e-2 * t1370) / 0.2e1
  t1517 = -0.75120000000000000000000000000000000000000000000000e-1 * t1008 + 0.81970000000000000000000000000000000000000000000000e-2 * t172 * t726 - 0.21133333333333333333333333333333333333333333333333e-2 * t176 * t1047 * t486 + 0.15336000000000000000000000000000000000000000000000e-2 * t1050 - 0.16804375000000000000000000000000000000000000000000e-4 * t185 * t1052 * t68
  t1519 = 0.14719325400000000000000000000000000000000000000000e-1 * t1008 * t533 + 0.29438650800000000000000000000000000000000000000000e-1 * t209 * t715 + 0.44157976200000000000000000000000000000000000000000e-1 * t159 / t1475 * t1477 - 0.14719325400000000000000000000000000000000000000000e-1 * t159 * t703 * t1500 - t1426 * t547 - 0.2e1 * t675 * t729 - t511 * t1517
  t1522 = t249 * t68 * t1519 * t562
  t1525 = t249 * t732 * t758
  t1528 = 0.1e1 / t736 / t560
  t1530 = t757 ** 2
  t1533 = t249 * t550 * t1528 * s0 * t1530
  t1546 = t638 * t553
  t1563 = t675 ** 2
  t1567 = -0.21901432222222222222222222222222222222222222222222e-3 * t194 * t631 * t554 - 0.1e-52 * t260 * t53 * t486 * t744 - 0.13140859333333333333333333333333333333333333333333e-2 * t156 * t193 * t11 * t752 + 0.19711289000000000000000000000000000000000000000000e-2 * t1085 * t1546 + 0.98556445000000000000000000000000000000000000000000e-3 * t109 * t259 * t23 * t486 * t481 * t751 + 0.19711289000000000000000000000000000000000000000000e-2 * t749 * t750 * t703 * t1477 - 0.98556445000000000000000000000000000000000000000000e-3 * t749 * t750 * t533 * t1500 - 0.4e1 * t1563 - 0.4e1 * t511 * t1426
  t1570 = t249 * t550 * t738 * t1567
  t1572 = t1426 * t524 - 0.133450e0 * t675 * t678 * t694 + 0.8904451250e-2 * t511 / t677 / t523 * t1437 - 0.66725e-1 * t679 * (0.35e2 / 0.432e3 * t1284 * t517 + 0.7e1 / 0.144e3 * t431 * t109 * t689 + t682 * t683 / t684 / t514 * t1447 / 0.48e2 - t682 * t683 * t685 * t1453 / 0.96e2) * t693 + 0.66725e-1 * t679 * t1437 + 0.15476481481481481481481481481481481481481481481481e-1 * t1465 - 0.13265555555555555555555555555555555555555555555555e-1 * t1467 + 0.13265555555555555555555555555555555555555555555555e-1 * t1469 + 0.49745833333333333333333333333333333333333333333332e-2 * t1522 - 0.99491666666666666666666666666666666666666666666664e-2 * t1525 + 0.99491666666666666666666666666666666666666666666664e-2 * t1533 - 0.49745833333333333333333333333333333333333333333332e-2 * t1570
  t1573 = t1572 * t581
  t1576 = 0.2e1 * t762 * t765 * t804
  t1580 = t804 ** 2
  t1582 = 0.2e1 * t566 / t764 / t580 * t1580
  t1622 = 0.61912500000000000000000000000000000000000000000000e-2 * t1426 * t277 * t554 - 0.24765000000000000000000000000000000000000000000000e-1 * t675 * t193 * t744 * t772 - 0.12382500000000000000000000000000000000000000000000e-1 * t767 * t776 + 0.20637500000000000000000000000000000000000000000000e-2 * t511 * t259 * t1546 * t21 * t1483 + 0.24765000000000000000000000000000000000000000000000e-1 * t770 * t481 * t533 * t4 * t631 * t714 + 0.16510000000000000000000000000000000000000000000000e-1 * t771 * t4 * t1348 + 0.12382500000000000000000000000000000000000000000000e-1 * t567 * t552 * t703 * t1477 - 0.61912500000000000000000000000000000000000000000000e-2 * t567 * t775 * t1500 + 0.88437037037037037037037037037037037037037037037037e-2 * t157 * t631 * t547 - 0.53062222222222222222222222222222222222222222222222e-1 * t157 * t739 * t729 - 0.39796666666666666666666666666666666666666666666666e-1 * t157 * t551 * t1517
  t1624 = t1622 * t561 * t288
  t1627 = t785 * t737 * t790
  t1629 = t786 * t339
  t1633 = t573 * t1528 * t288 * t1530
  t1636 = t789 * t339 * t757
  t1639 = t789 * t288 * t1567
  t1641 = t574 * t1181
  t1644 = t1519 * t561 * t295
  t1647 = t731 * t737 * t799
  t1649 = t795 * t350
  t1653 = t549 * t1528 * t295 * t1530
  t1656 = t798 * t350 * t757
  t1659 = t798 * t295 * t1567
  t1661 = t577 * t1202
  t1663 = t1624 / 0.8e1 - t1627 / 0.4e1 - t1629 / 0.2e1 + t1633 / 0.4e1 + t1636 / 0.2e1 - t1639 / 0.8e1 + 0.3e1 / 0.4e1 * t1641 - t1644 / 0.64e2 + t1647 / 0.32e2 + t1649 / 0.8e1 - t1653 / 0.32e2 - t1656 / 0.8e1 + t1659 / 0.64e2 - 0.5e1 / 0.16e2 * t1661
  t1664 = t766 * t1663
  t1675 = t816 ** 2
  t1689 = t809 ** 2
  t1692 = t592 ** 2
  t1715 = -0.70981924444444444444444444444444444444444444444442e-3 * t630 * t1348 * t593 - 0.34246666666666666666666666666666666666666666666666e-1 * t46 * t68 * t810 * t818 - 0.20000000000000000000000000000000000000000000000000e1 * t584 / t809 / t589 * t1675 * t817 + 0.99999999999999999999999999999999999999999999999999e0 * t811 * (-0.78438333333333333333333333333333333333333333333333e0 * t1366 + 0.15687666666666666666666666666666666666666666666667e1 * t1368 + 0.68863333333333333333333333333333333333333333333333e0 * t1370 + 0.14025833333333333333333333333333333333333333333333e0 * t1375 + 0.28051666666666666666666666666666666666666666666667e0 * t1377 + 0.17365833333333333333333333333333333333333333333333e0 * t1379) * t817 + 0.32164683177870697973624959794146027661627532968800e2 * t584 / t1689 * t1675 / t1692 + t1351 + t1355 + t1362 - t1384 - t1392 - 0.24415406715670879921742973310852762593515528885057e-3 * t630 * t1348 * t507 - 0.10843580882781524214666447553230042011687479519034e-1 * t46 * t68 * t664 * t825 - 0.11696446794910408141662685001236899248561775660981e1 * t498 * t1401 * t1402 * t671 + 0.58482233974552040708313425006184496242808878304903e0 * t824 * t1413 * t671 + 0.17315755899375863299672358916972966258900005419821e2 * t498 * t1419 * t1402 * t1422
  t1728 = -t1351 - t1355 - t1362 + t1384 + t1392 + t362 * t1715 + 0.24415406715670879921742973310852762593515528885057e-3 * t830 * t1393 + 0.10843580882781524214666447553230042011687479519034e-1 * t362 * t630 * t1397 + 0.11696446794910408141662685001236899248561775660981e1 * t833 * t1404 - 0.58482233974552040708313425006184496242808878304903e0 * t833 * t1415 - 0.17315755899375863299672358916972966258900005419821e2 * t833 * t1423
  t1736 = t851 ** 2
  t1737 = t610 ** 2
  t1739 = t1736 / t1737
  t1748 = t846 ** 2
  t1754 = f.my_piecewise3(t602, t1728, -t1728)
  t1772 = t1728 * t614 - 0.133450e0 * t836 * t839 * t853 + 0.8904451250e-2 * t601 / t838 / t613 * t1739 - 0.66725e-1 * t840 * (0.35e2 / 0.432e3 * t972 * t607 + 0.7e1 / 0.144e3 * t976 * t848 + t140 * t141 / t843 / t604 * t1748 / 0.48e2 - t140 * t141 * t844 * t1754 / 0.96e2) * t852 + 0.66725e-1 * t840 * t1739 + 0.10833537037037037037037037037037037037037037037037e-1 * t1465 - 0.92858888888888888888888888888888888888888888888886e-2 * t1467 + 0.92858888888888888888888888888888888888888888888886e-2 * t1469 + 0.34822083333333333333333333333333333333333333333332e-2 * t1522 - 0.69644166666666666666666666666666666666666666666664e-2 * t1525 + 0.69644166666666666666666666666666666666666666666664e-2 * t1533 - 0.34822083333333333333333333333333333333333333333332e-2 * t1570
  t1780 = t870 ** 2
  t1797 = 0.18750000000000000000000000000000000000000000000000e0 * t1624 - 0.37500000000000000000000000000000000000000000000000e0 * t1627 - 0.75000000000000000000000000000000000000000000000000e0 * t1629 + 0.37500000000000000000000000000000000000000000000000e0 * t1633 + 0.75000000000000000000000000000000000000000000000000e0 * t1636 - 0.18750000000000000000000000000000000000000000000000e0 * t1639 + 0.11250000000000000000000000000000000000000000000000e1 * t1641 - 0.40468750000000000000000000000000000000000000000000e-1 * t1644 + 0.80937500000000000000000000000000000000000000000000e-1 * t1647 + 0.32375000000000000000000000000000000000000000000000e0 * t1649 - 0.80937500000000000000000000000000000000000000000000e-1 * t1653 - 0.32375000000000000000000000000000000000000000000000e0 * t1656 + 0.40468750000000000000000000000000000000000000000000e-1 * t1659 - 0.80937500000000000000000000000000000000000000000000e0 * t1661
  v2rho2_0_ = 0.2e1 * t300 - 0.2e1 * t354 + 0.2e1 * t72 * (t451 * t455 - t462 * t469 - t300 + t354) + t288 * t626 / 0.4e1 - t629 * t875 / 0.4e1 + r0 * (t1110 - t1113 + t1119 - t1206 + t72 * (t1315 * t455 - 0.2e1 * t451 * t461 * t469 + 0.2e1 * t459 / t460 / t454 * t1323 - t462 * t1340 - t1110 + t1113 - t1119 + t1206) - t339 * t626 / 0.4e1 + t288 * t875 / 0.4e1 - t629 * t476 * (t1573 - t1576 + t1582 - t1664 + t362 * (t1772 * t621 - 0.2e1 * t859 * t862 * t870 + 0.2e1 * t617 / t861 / t620 * t1780 - t863 * t1797 - t1573 + t1576 - t1582 + t1664)) / 0.8e1)

  res = {'v2rho2': v2rho2_0_}
  return res
