"""Generated from mgga_c_revscan.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.030197

  scan_b2c = 0.06623

  scan_b3c = 0.16672

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 1.131

  params_c2 = 1.7

  params_d = 1.37

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (2 * (1 + 8 * scan_chi_infty * s ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * scan_chi_infty ** 2 * s ** 4) ** (1 / 8))

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: 1 / (2 * (1 + 8 * A(rs, z, t) * t ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * A(rs, z, t) ** 2 * t ** 4) ** (1 / 8))

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.030197

  scan_b2c = 0.06623

  scan_b3c = 0.16672

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 1.131

  params_c2 = 1.7

  params_d = 1.37

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (2 * (1 + 8 * scan_chi_infty * s ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * scan_chi_infty ** 2 * s ** 4) ** (1 / 8))

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: 1 / (2 * (1 + 8 * A(rs, z, t) * t ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * A(rs, z, t) ** 2 * t ** 4) ** (1 / 8))

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.030197

  scan_b2c = 0.06623

  scan_b3c = 0.16672

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 1.131

  params_c2 = 1.7

  params_d = 1.37

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (2 * (1 + 8 * scan_chi_infty * s ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * scan_chi_infty ** 2 * s ** 4) ** (1 / 8))

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: 1 / (2 * (1 + 8 * A(rs, z, t) * t ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * A(rs, z, t) ** 2 * t ** 4) ** (1 / 8))

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t53 = t47 + t52 - 0.2e1
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = t53 * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = jnp.log(0.2e1)
  t88 = 0.1e1 - t87
  t89 = jnp.pi ** 2
  t91 = t88 / t89
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t11
  t104 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11
  t105 = 0.1e1 / t104
  t107 = 0.1e1 / t88
  t108 = t102 * t105 * t107
  t110 = (-t31 + t84 + t86) * t107
  t111 = 0.1e1 / t100
  t112 = t89 * t111
  t114 = jnp.exp(-t110 * t112)
  t115 = t114 - 0.1e1
  t116 = 0.1e1 / t115
  t119 = s0 + 0.2e1 * s1 + s2
  t121 = t108 * t89 * t116 * t119
  t123 = 0.1e1 / t8 / t35
  t124 = t123 * t54
  t125 = 0.1e1 / t99
  t127 = 0.1e1 / t3
  t128 = t19 * t127
  t129 = t128 * t5
  t130 = t124 * t125 * t129
  t133 = 0.1e1 + t121 * t130 / 0.12e2
  t134 = t133 ** (0.1e1 / 0.4e1)
  t137 = t102 ** 2
  t138 = t104 ** 2
  t139 = 0.1e1 / t138
  t141 = t88 ** 2
  t142 = 0.1e1 / t141
  t143 = t137 * t139 * t142
  t144 = t89 ** 2
  t145 = t115 ** 2
  t146 = 0.1e1 / t145
  t148 = t119 ** 2
  t149 = t144 * t146 * t148
  t150 = t143 * t149
  t152 = 0.1e1 / t22 / t36
  t153 = t54 ** 2
  t154 = t152 * t153
  t155 = t99 ** 2
  t156 = 0.1e1 / t155
  t158 = 0.1e1 / t20
  t159 = t1 * t158
  t160 = t159 * t6
  t164 = 0.1e1 + 0.5e1 / 0.192e3 * t150 * t154 * t156 * t160
  t165 = t164 ** (0.1e1 / 0.8e1)
  t168 = 0.1e1 - 0.1e1 / t134 / 0.2e1 - 0.1e1 / t165 / 0.2e1
  t170 = t168 * t115 + 0.1e1
  t171 = jnp.log(t170)
  t173 = t91 * t100 * t171
  t174 = r0 ** (0.1e1 / 0.3e1)
  t175 = t174 ** 2
  t177 = 0.1e1 / t175 / r0
  t178 = tau0 * t177
  t179 = t41 / 0.2e1
  t180 = t179 ** (0.1e1 / 0.3e1)
  t181 = t180 ** 2
  t182 = t181 * t179
  t184 = r1 ** (0.1e1 / 0.3e1)
  t185 = t184 ** 2
  t187 = 0.1e1 / t185 / r1
  t188 = tau1 * t187
  t189 = t48 / 0.2e1
  t190 = t189 ** (0.1e1 / 0.3e1)
  t191 = t190 ** 2
  t192 = t191 * t189
  t195 = 0.1e1 / t22 / t35
  t199 = 6 ** (0.1e1 / 0.3e1)
  t200 = (t178 * t182 + t188 * t192 - t119 * t195 / 0.8e1) * t199
  t201 = t89 ** (0.1e1 / 0.3e1)
  t202 = t201 ** 2
  t203 = 0.1e1 / t202
  t204 = t182 + t192
  t205 = 0.1e1 / t204
  t206 = t203 * t205
  t208 = 0.5e1 / 0.9e1 * t200 * t206
  t209 = t208 <= 0.1e1
  t210 = jnp.log(DBL_EPSILON)
  t213 = t210 / (-t210 + 0.1131e1)
  t214 = -t213 < t208
  t215 = t208 < -t213
  t216 = f.my_piecewise3(t215, t208, -t213)
  t217 = 0.1e1 - t216
  t218 = 0.1e1 / t217
  t221 = jnp.exp(-0.1131e1 * t216 * t218)
  t222 = f.my_piecewise3(t214, 0, t221)
  t224 = jnp.log(0.72992700729927007299270072992700729927007299270073e0 * DBL_EPSILON)
  t227 = (-t224 + 0.17e1) / t224
  t228 = t208 < -t227
  t229 = f.my_piecewise3(t228, -t227, t208)
  t230 = 0.1e1 - t229
  t233 = jnp.exp(0.17e1 / t230)
  t235 = f.my_piecewise3(t228, 0, -0.137e1 * t233)
  t236 = f.my_piecewise3(t209, t222, t235)
  t239 = 0.1e1 + 0.33115000000000000000000000000000000000000000000000e-1 * t14 + 0.41680000000000000000000000000000000000000000000000e-1 * t11
  t240 = 0.1e1 / t239
  t243 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t240)
  t244 = t243 - 0.1e1
  t245 = t199 * t203
  t246 = t153 * t119
  t250 = 0.1e1 + 0.42675284208752716666666666666666666666666666666667e-1 * t245 * t246 * t195
  t251 = t250 ** (0.1e1 / 0.4e1)
  t254 = t199 ** 2
  t256 = 0.1e1 / t201 / t89
  t258 = t54 * t148
  t259 = t36 * t7
  t261 = 0.1e1 / t8 / t259
  t265 = 0.1e1 + 0.45529497057445474565519084559506944444444444444444e-2 * t254 * t256 * t258 * t261
  t266 = t265 ** (0.1e1 / 0.8e1)
  t269 = 0.1e1 - 0.1e1 / t251 / 0.2e1 - 0.1e1 / t266 / 0.2e1
  t271 = t244 * t269 + 0.1e1
  t272 = jnp.log(t271)
  t274 = -0.30197e-1 * t240 + 0.30197e-1 * t272
  t276 = 0.2363e1 * t54 - 0.2363e1
  t279 = -t276 * t53 * t57 + 0.1e1
  t280 = t274 * t279
  t281 = t34 ** 2
  t282 = t281 * t34
  t283 = t36 ** 2
  t285 = 0.1e1 / t283 / t36
  t287 = -t282 * t285 + 0.1e1
  t289 = t280 * t287 - t173 + t31 - t84 - t86
  t290 = t236 * t289
  t292 = 0.1e1 / t8 / t7
  t293 = t6 * t292
  t296 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t293 * t30
  t297 = t27 ** 2
  t302 = t3 * t6
  t303 = t302 * t292
  t304 = 0.1e1 / t14 * t1 * t303
  t306 = t4 * t293
  t308 = t11 ** 0.5e0
  t310 = t308 * t1 * t303
  t315 = t21 * t5 / t22 / t7
  t320 = t13 / t297 * (-0.39359271665000000000000000000000000000000000000000e-1 * t304 - 0.18590165886666666666666666666666666666666666666667e-1 * t306 - 0.63665980925000000000000000000000000000000000000000e-2 * t310 - 0.51086165526666666666666666666666666666666666666667e-2 * t315) / t29
  t321 = t33 * t32
  t324 = 0.4e1 * t321 * t37 * t83
  t328 = 0.4e1 * t34 / t259 * t83
  t330 = t32 / t35
  t331 = t39 - t330
  t334 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t331)
  t335 = -t331
  t338 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t335)
  t340 = (t334 + t338) * t57
  t342 = t38 * t340 * t82
  t346 = t65 ** 2
  t360 = t76 ** 2
  t361 = 0.1e1 / t360
  t367 = -0.29149603883333333333333333333333333333333333333333e-1 * t304 - 0.10197154565000000000000000000000000000000000000000e-1 * t306 - 0.18581078242500000000000000000000000000000000000000e-2 * t310 - 0.27959640330000000000000000000000000000000000000000e-2 * t315
  t368 = 0.1e1 / t78
  t374 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t293 * t68 + t60 / t346 * (-0.36580540352500000000000000000000000000000000000000e-1 * t304 - 0.16057569282500000000000000000000000000000000000000e-1 * t306 - 0.65410946462500000000000000000000000000000000000000e-2 * t310 - 0.32394954865000000000000000000000000000000000000000e-2 * t315) / t67 - t296 - t320 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t293 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t361 * t367 * t368)
  t376 = 0.58482236226346462072622386637590534819724553404281e0 * t340 * t80
  t381 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t302 * t292 * t79
  t386 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t361 * t367 * t368
  t387 = t99 * t171
  t388 = 0.1e1 / t45
  t391 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t388 * t331)
  t392 = 0.1e1 / t50
  t395 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t392 * t335)
  t397 = t391 / 0.2e1 + t395 / 0.2e1
  t400 = 0.3e1 * t91 * t387 * t397
  t402 = 0.1e1 / t134 / t133
  t403 = t35 * t7
  t405 = 0.1e1 / t22 / t403
  t407 = t107 * t89
  t409 = t116 * t119
  t410 = t54 * t125
  t413 = 0.55603792169291016666666666666666666666666666666667e-3 * t405 * t105 * t407 * t409 * t410
  t414 = t102 * t139
  t420 = 0.14816666666666666666666666666666666666666666666667e-1 * t414 * t407 * t409 * t405 * t54 * t125
  t424 = t108 * t89 * t146 * t119 * t123
  t425 = t410 * t19
  t426 = t127 * t5
  t430 = t89 * t156
  t434 = -(t296 + t320 + t324 - t328 + t342 + t374 + t376 - t381 - t386) * t107 * t112 + 0.3e1 * t110 * t430 * t397
  t435 = t434 * t114
  t446 = 0.7e1 / 0.36e2 * t121 / t8 / t403 * t54 * t125 * t129
  t447 = t124 * t111
  t457 = 0.1e1 / t165 / t164
  t460 = t36 * t35
  t464 = 0.1e1 / t460 * t153 * t156 * t129
  t466 = 0.11584123368602295138888888888888888888888888888889e-3 * t414 * t142 * t149 * t464
  t473 = 0.30868055555555555555555555555555555555555555555557e-2 * t137 / t138 / t104 * t142 * t149 * t464
  t479 = t143 * t144 / t145 / t115 * t148 * t152
  t481 = t153 * t156 * t1
  t482 = t158 * t6
  t493 = 0.35e2 / 0.288e3 * t150 / t22 / t259 * t153 * t156 * t160
  t496 = t154 / t155 / t98
  t511 = 0.1e1 / t170
  t513 = t91 * t100 * ((t402 * (-t413 + t420 - t424 * t425 * t426 * t435 / 0.12e2 - t446 - t121 * t447 * t128 * t5 * t397 / 0.6e1) / 0.8e1 + t457 * (-t466 + t473 - 0.5e1 / 0.96e2 * t479 * t481 * t482 * t435 - t493 - 0.5e1 / 0.48e2 * t150 * t496 * t159 * t6 * t397) / 0.16e2) * t115 + t168 * t434 * t114) * t511
  t514 = r0 ** 2
  t520 = t331 / 0.2e1
  t521 = t181 * t520
  t525 = -t191 * t520
  t529 = t119 * t405 / 0.3e1
  t533 = t204 ** 2
  t535 = t203 / t533
  t541 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 / t175 / t514 * t182 + 0.5e1 / 0.3e1 * t178 * t521 + 0.5e1 / 0.3e1 * t188 * t525 + t529) * t199 * t206 - 0.5e1 / 0.9e1 * t200 * t535 * (0.5e1 / 0.3e1 * t521 + 0.5e1 / 0.3e1 * t525)
  t542 = f.my_piecewise3(t215, t541, 0)
  t545 = t217 ** 2
  t547 = t216 / t545
  t552 = f.my_piecewise3(t214, 0, (-0.1131e1 * t542 * t218 - 0.1131e1 * t547 * t542) * t221)
  t553 = t230 ** 2
  t554 = 0.1e1 / t553
  t555 = f.my_piecewise3(t228, 0, t541)
  t559 = f.my_piecewise3(t228, 0, -0.2329e1 * t554 * t555 * t233)
  t560 = f.my_piecewise3(t209, t552, t559)
  t562 = t239 ** 2
  t567 = 0.1e1 / t562 * (-0.55191666666666666666666666666666666666666666666667e-2 * t304 - 0.13893333333333333333333333333333333333333333333333e-1 * t306)
  t574 = 0.1e1 / t251 / t250 * t199
  t582 = 0.1e1 / t266 / t265 * t254 * t256
  t591 = 0.1e1 / t271
  t596 = (0.30197e-1 * t567 + 0.30197e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t567 * t243 * t269 + t244 * (-0.14225094736250905555555555555555555555555555555556e-1 * t574 * t203 * t246 * t405 - 0.15176499019148491521839694853168981481481481481481e-2 * t582 * t258 / t8 / t460)) * t591) * t279 * t287
  t597 = t274 * t276
  t601 = t281 * t321 * t285
  t604 = t282 / t283 / t259
  t608 = t596 - t597 * t340 * t287 + t280 * (-0.12e2 * t601 + 0.12e2 * t604) - t296 - t320 - t324 + t328 - t342 - t374 - t376 + t381 + t386 - t400 - t513
  t610 = t236 * t608 + t560 * t289 + t296 + t320 + t324 - t328 + t342 + t374 + t376 - t381 - t386 + t400 + t513
  vrho_0_ = t7 * t610 + t173 + t290 - t31 + t84 + t86
  t612 = -t39 - t330
  t615 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t612)
  t616 = -t612
  t619 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t616)
  t621 = (t615 + t619) * t57
  t623 = t38 * t621 * t82
  t625 = 0.58482236226346462072622386637590534819724553404281e0 * t621 * t80
  t628 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t388 * t612)
  t631 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t392 * t616)
  t633 = t628 / 0.2e1 + t631 / 0.2e1
  t636 = 0.3e1 * t91 * t387 * t633
  t643 = -(t296 + t320 - t324 - t328 + t623 + t374 + t625 - t381 - t386) * t107 * t112 + 0.3e1 * t110 * t430 * t633
  t644 = t643 * t114
  t676 = t91 * t100 * ((t402 * (-t413 + t420 - t424 * t425 * t426 * t644 / 0.12e2 - t446 - t121 * t447 * t128 * t5 * t633 / 0.6e1) / 0.8e1 + t457 * (-t466 + t473 - 0.5e1 / 0.96e2 * t479 * t481 * t482 * t644 - t493 - 0.5e1 / 0.48e2 * t150 * t496 * t159 * t6 * t633) / 0.16e2) * t115 + t168 * t643 * t114) * t511
  t677 = t612 / 0.2e1
  t678 = t181 * t677
  t681 = r1 ** 2
  t688 = -t191 * t677
  t699 = 0.5e1 / 0.9e1 * (0.5e1 / 0.3e1 * t178 * t678 - 0.5e1 / 0.3e1 * tau1 / t185 / t681 * t192 + 0.5e1 / 0.3e1 * t188 * t688 + t529) * t199 * t206 - 0.5e1 / 0.9e1 * t200 * t535 * (0.5e1 / 0.3e1 * t678 + 0.5e1 / 0.3e1 * t688)
  t700 = f.my_piecewise3(t215, t699, 0)
  t707 = f.my_piecewise3(t214, 0, (-0.1131e1 * t700 * t218 - 0.1131e1 * t547 * t700) * t221)
  t708 = f.my_piecewise3(t228, 0, t699)
  t712 = f.my_piecewise3(t228, 0, -0.2329e1 * t554 * t708 * t233)
  t713 = f.my_piecewise3(t209, t707, t712)
  t720 = t596 - t597 * t621 * t287 + t280 * (0.12e2 * t601 + 0.12e2 * t604) - t296 - t320 + t324 + t328 - t623 - t374 - t625 + t381 + t386 - t636 - t676
  t722 = t236 * t720 + t713 * t289 + t296 + t320 - t324 - t328 + t374 - t381 - t386 + t623 + t625 + t636 + t676
  vrho_1_ = t7 * t722 + t173 + t290 - t31 + t84 + t86
  t724 = t91 * t100
  t729 = t402 * t102 * t105 * t407 * t116 * t130
  t741 = t457 * t137 * t139 * t142 * t144 * t146 * t119 * t152 * t153 * t156 * t1 * t482
  t746 = t724 * (t729 / 0.96e2 + 0.5e1 / 0.1536e4 * t741) * t115 * t511
  t748 = t195 * t199 * t206
  t749 = 0.5e1 / 0.72e2 * t748
  t750 = f.my_piecewise3(t215, -t749, 0)
  t757 = f.my_piecewise3(t214, 0, (-0.1131e1 * t750 * t218 - 0.1131e1 * t547 * t750) * t221)
  t758 = f.my_piecewise3(t228, 0, -t749)
  t762 = f.my_piecewise3(t228, 0, -0.2329e1 * t554 * t758 * t233)
  t763 = f.my_piecewise3(t209, t757, t762)
  t767 = t574 * t203 * t153 * t195
  t771 = t582 * t54 * t119 * t261
  t776 = t591 * t279 * t287
  vsigma_0_ = t7 * (t746 + t763 * t289 + t236 * (0.30197e-1 * t244 * (0.53344105260940895833333333333333333333333333333335e-2 * t767 + 0.56911871321806843206898855699383680555555555555555e-3 * t771) * t776 - t746))
  t787 = t724 * (t729 / 0.48e2 + 0.5e1 / 0.768e3 * t741) * t115 * t511
  t788 = 0.5e1 / 0.36e2 * t748
  t789 = f.my_piecewise3(t215, -t788, 0)
  t796 = f.my_piecewise3(t214, 0, (-0.1131e1 * t789 * t218 - 0.1131e1 * t547 * t789) * t221)
  t797 = f.my_piecewise3(t228, 0, -t788)
  t801 = f.my_piecewise3(t228, 0, -0.2329e1 * t554 * t797 * t233)
  t802 = f.my_piecewise3(t209, t796, t801)
  vsigma_1_ = t7 * (t787 + t802 * t289 + t236 * (0.30197e-1 * t244 * (0.10668821052188179166666666666666666666666666666667e-1 * t767 + 0.11382374264361368641379771139876736111111111111111e-2 * t771) * t776 - t787))
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t814 = t245 * t205
  t816 = 0.5e1 / 0.9e1 * t177 * t182 * t814
  t817 = f.my_piecewise3(t215, t816, 0)
  t824 = f.my_piecewise3(t214, 0, (-0.1131e1 * t817 * t218 - 0.1131e1 * t547 * t817) * t221)
  t825 = f.my_piecewise3(t228, 0, t816)
  t829 = f.my_piecewise3(t228, 0, -0.2329e1 * t554 * t825 * t233)
  t830 = f.my_piecewise3(t209, t824, t829)
  vtau_0_ = t7 * t830 * t289
  t834 = 0.5e1 / 0.9e1 * t187 * t192 * t814
  t835 = f.my_piecewise3(t215, t834, 0)
  t842 = f.my_piecewise3(t214, 0, (-0.1131e1 * t835 * t218 - 0.1131e1 * t547 * t835) * t221)
  t843 = f.my_piecewise3(t228, 0, t834)
  t847 = f.my_piecewise3(t228, 0, -0.2329e1 * t554 * t843 * t233)
  t848 = f.my_piecewise3(t209, t842, t847)
  vtau_1_ = t7 * t848 * t289
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.030197

  scan_b2c = 0.06623

  scan_b3c = 0.16672

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 1.131

  params_c2 = 1.7

  params_d = 1.37

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (2 * (1 + 8 * scan_chi_infty * s ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * scan_chi_infty ** 2 * s ** 4) ** (1 / 8))

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: 1 / (2 * (1 + 8 * A(rs, z, t) * t ** 2) ** (1 / 4)) + 1 / (2 * (1 + 80 * A(rs, z, t) ** 2 * t ** 4) ** (1 / 8))

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t36 = 0.2e1 * t34 - 0.2e1
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = t36 * t40
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = jnp.log(0.2e1)
  t56 = 0.1e1 - t55
  t57 = jnp.pi ** 2
  t59 = t56 / t57
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t65 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t10
  t67 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t56
  t75 = t57 / t63
  t77 = jnp.exp(-(-t30 + t54) * t70 * t75)
  t78 = t77 - 0.1e1
  t79 = 0.1e1 / t78
  t82 = t69 * t70 * t57 * t79 * s0
  t83 = r0 ** 2
  t85 = 0.1e1 / t7 / t83
  t87 = 0.1e1 / t62
  t89 = 0.1e1 / t3
  t91 = t18 * t89 * t5
  t92 = t85 * t37 * t87 * t91
  t95 = 0.1e1 + t82 * t92 / 0.12e2
  t96 = t95 ** (0.1e1 / 0.4e1)
  t99 = t65 ** 2
  t100 = t67 ** 2
  t101 = 0.1e1 / t100
  t102 = t99 * t101
  t103 = t56 ** 2
  t104 = 0.1e1 / t103
  t106 = t57 ** 2
  t107 = t78 ** 2
  t108 = 0.1e1 / t107
  t109 = t106 * t108
  t110 = s0 ** 2
  t111 = t109 * t110
  t112 = t102 * t104 * t111
  t113 = t83 ** 2
  t115 = 0.1e1 / t21 / t113
  t116 = t37 ** 2
  t118 = t62 ** 2
  t119 = 0.1e1 / t118
  t121 = 0.1e1 / t19
  t123 = t1 * t121 * t6
  t127 = 0.1e1 + 0.5e1 / 0.192e3 * t112 * t115 * t116 * t119 * t123
  t128 = t127 ** (0.1e1 / 0.8e1)
  t131 = 0.1e1 - 0.1e1 / t96 / 0.2e1 - 0.1e1 / t128 / 0.2e1
  t133 = t131 * t78 + 0.1e1
  t134 = jnp.log(t133)
  t136 = t59 * t63 * t134
  t138 = 0.1e1 / t21 / r0
  t141 = 0.1e1 / t21 / t83
  t145 = 6 ** (0.1e1 / 0.3e1)
  t147 = t57 ** (0.1e1 / 0.3e1)
  t148 = t147 ** 2
  t149 = 0.1e1 / t148
  t150 = t149 * t116
  t152 = 0.5e1 / 0.9e1 * (tau0 * t138 - s0 * t141 / 0.8e1) * t145 * t150
  t153 = t152 <= 0.1e1
  t154 = jnp.log(DBL_EPSILON)
  t157 = t154 / (-t154 + 0.1131e1)
  t158 = -t157 < t152
  t159 = t152 < -t157
  t160 = f.my_piecewise3(t159, t152, -t157)
  t161 = 0.1e1 - t160
  t162 = 0.1e1 / t161
  t165 = jnp.exp(-0.1131e1 * t160 * t162)
  t166 = f.my_piecewise3(t158, 0, t165)
  t168 = jnp.log(0.72992700729927007299270072992700729927007299270073e0 * DBL_EPSILON)
  t171 = (-t168 + 0.17e1) / t168
  t172 = t152 < -t171
  t173 = f.my_piecewise3(t172, -t171, t152)
  t174 = 0.1e1 - t173
  t177 = jnp.exp(0.17e1 / t174)
  t179 = f.my_piecewise3(t172, 0, -0.137e1 * t177)
  t180 = f.my_piecewise3(t153, t166, t179)
  t183 = 0.1e1 + 0.33115000000000000000000000000000000000000000000000e-1 * t13 + 0.41680000000000000000000000000000000000000000000000e-1 * t10
  t184 = 0.1e1 / t183
  t187 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t184)
  t188 = t187 - 0.1e1
  t189 = t145 * t149
  t190 = t116 * s0
  t194 = 0.1e1 + 0.42675284208752716666666666666666666666666666666667e-1 * t189 * t190 * t141
  t195 = t194 ** (0.1e1 / 0.4e1)
  t198 = t145 ** 2
  t200 = 0.1e1 / t147 / t57
  t202 = t37 * t110
  t203 = t113 * r0
  t205 = 0.1e1 / t7 / t203
  t209 = 0.1e1 + 0.45529497057445474565519084559506944444444444444444e-2 * t198 * t200 * t202 * t205
  t210 = t209 ** (0.1e1 / 0.8e1)
  t213 = 0.1e1 - 0.1e1 / t195 / 0.2e1 - 0.1e1 / t210 / 0.2e1
  t215 = t188 * t213 + 0.1e1
  t216 = jnp.log(t215)
  t223 = 0.1e1 - (0.2363e1 * t37 - 0.2363e1) * t36 * t40
  t225 = (-0.30197e-1 * t184 + 0.30197e-1 * t216) * t223 + t30 - t54 - t136
  t228 = 0.1e1 / t7 / r0
  t229 = t6 * t228
  t232 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t229 * t29
  t233 = t26 ** 2
  t238 = t3 * t6
  t239 = t238 * t228
  t240 = 0.1e1 / t13 * t1 * t239
  t242 = t4 * t229
  t244 = t10 ** 0.5e0
  t246 = t244 * t1 * t239
  t249 = t20 * t5 * t138
  t254 = t12 / t233 * (-0.39359271665000000000000000000000000000000000000000e-1 * t240 - 0.18590165886666666666666666666666666666666666666667e-1 * t242 - 0.63665980925000000000000000000000000000000000000000e-2 * t246 - 0.51086165526666666666666666666666666666666666666667e-2 * t249) / t28
  t259 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t238 * t228 * t51
  t261 = t48 ** 2
  t272 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t261 * (-0.29149603883333333333333333333333333333333333333333e-1 * t240 - 0.10197154565000000000000000000000000000000000000000e-1 * t242 - 0.18581078242500000000000000000000000000000000000000e-2 * t246 - 0.27959640330000000000000000000000000000000000000000e-2 * t249) / t50
  t274 = 0.1e1 / t96 / t95
  t275 = t83 * r0
  t277 = 0.1e1 / t21 / t275
  t279 = t70 * t57
  t281 = t79 * s0
  t286 = t65 * t101
  t302 = t232 + t254 - t259 - t272
  t303 = t302 * t77
  t319 = 0.1e1 / t128 / t127
  t322 = t113 * t83
  t326 = 0.1e1 / t322 * t116 * t119 * t91
  t350 = t121 * t6
  t373 = 0.1e1 / t133
  t375 = t59 * t63 * ((t274 * (-0.55603792169291016666666666666666666666666666666667e-3 * t277 * t68 * t279 * t281 * t37 * t87 + 0.14816666666666666666666666666666666666666666666667e-1 * t286 * t279 * t281 * t277 * t37 * t87 + t69 * t104 * t109 * s0 * t85 * t37 / t118 / t61 * t18 * t89 * t5 * t303 / 0.12e2 - 0.7e1 / 0.36e2 * t82 / t7 / t275 * t37 * t87 * t91) / 0.8e1 + t319 * (-0.11584123368602295138888888888888888888888888888889e-3 * t286 * t104 * t111 * t326 + 0.30868055555555555555555555555555555555555555555557e-2 * t99 / t100 / t67 * t104 * t111 * t326 + 0.5e1 / 0.96e2 * t102 / t103 / t56 * t106 * t57 / t107 / t78 * t110 * t115 * t116 / t118 / t63 * t1 * t350 * t303 - 0.35e2 / 0.288e3 * t112 / t21 / t203 * t116 * t119 * t123) / 0.16e2) * t78 - t131 * t302 * t70 * t75 * t77) * t373
  t383 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t141 + s0 * t277 / 0.3e1) * t145 * t150
  t384 = f.my_piecewise3(t159, t383, 0)
  t387 = t161 ** 2
  t389 = t160 / t387
  t394 = f.my_piecewise3(t158, 0, (-0.1131e1 * t384 * t162 - 0.1131e1 * t389 * t384) * t165)
  t395 = t174 ** 2
  t396 = 0.1e1 / t395
  t397 = f.my_piecewise3(t172, 0, t383)
  t401 = f.my_piecewise3(t172, 0, -0.2329e1 * t396 * t397 * t177)
  t402 = f.my_piecewise3(t153, t394, t401)
  t404 = t183 ** 2
  t409 = 0.1e1 / t404 * (-0.55191666666666666666666666666666666666666666666667e-2 * t240 - 0.13893333333333333333333333333333333333333333333333e-1 * t242)
  t415 = 0.1e1 / t195 / t194
  t424 = 0.1e1 / t210 / t209 * t198 * t200
  t433 = 0.1e1 / t215
  vrho_0_ = -t30 + t54 + t136 + t180 * t225 + r0 * (t232 + t254 - t259 - t272 + t375 + t402 * t225 + t180 * ((0.30197e-1 * t409 + 0.30197e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t409 * t187 * t213 + t188 * (-0.14225094736250905555555555555555555555555555555556e-1 * t415 * t145 * t149 * t190 * t277 - 0.15176499019148491521839694853168981481481481481481e-2 * t424 * t202 / t7 / t322)) * t433) * t223 - t232 - t254 + t259 + t272 - t375))
  t464 = t59 * t63 * (t274 * t65 * t68 * t279 * t79 * t92 / 0.96e2 + 0.5e1 / 0.1536e4 * t319 * t99 * t101 * t104 * t106 * t108 * s0 * t115 * t116 * t119 * t1 * t350) * t78 * t373
  t467 = 0.5e1 / 0.72e2 * t141 * t145 * t150
  t468 = f.my_piecewise3(t159, -t467, 0)
  t475 = f.my_piecewise3(t158, 0, (-0.1131e1 * t468 * t162 - 0.1131e1 * t389 * t468) * t165)
  t476 = f.my_piecewise3(t172, 0, -t467)
  t480 = f.my_piecewise3(t172, 0, -0.2329e1 * t396 * t476 * t177)
  t481 = f.my_piecewise3(t153, t475, t480)
  vsigma_0_ = r0 * (t464 + t481 * t225 + t180 * (0.30197e-1 * t188 * (0.53344105260940895833333333333333333333333333333335e-2 * t415 * t141 * t189 * t116 + 0.56911871321806843206898855699383680555555555555555e-3 * t424 * t37 * s0 * t205) * t433 * t223 - t464))
  vlapl_0_ = 0.0e0
  t501 = 0.5e1 / 0.9e1 * t138 * t145 * t150
  t502 = f.my_piecewise3(t159, t501, 0)
  t509 = f.my_piecewise3(t158, 0, (-0.1131e1 * t502 * t162 - 0.1131e1 * t389 * t502) * t165)
  t510 = f.my_piecewise3(t172, 0, t501)
  t514 = f.my_piecewise3(t172, 0, -0.2329e1 * t396 * t510 * t177)
  t515 = f.my_piecewise3(t153, t509, t514)
  vtau_0_ = r0 * t515 * t225
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t53 = 0.1e1 / t22 / r0
  t55 = t21 * t5 * t53
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t67 = 0.2e1 * t65 - 0.2e1
  t68 = 2 ** (0.1e1 / 0.3e1)
  t69 = t68 - 0.1e1
  t71 = 0.1e1 / t69 / 0.2e1
  t72 = t67 * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.log(0.2e1)
  t103 = 0.1e1 - t102
  t104 = jnp.pi ** 2
  t106 = t103 / t104
  t107 = t63 ** 2
  t108 = f.my_piecewise3(t62, t107, 1)
  t109 = t108 ** 2
  t110 = t109 * t108
  t112 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t13
  t114 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13
  t115 = 0.1e1 / t114
  t116 = t112 * t115
  t117 = 0.1e1 / t103
  t120 = 0.621814e-1 * t36 * t31
  t123 = 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82
  t127 = t104 / t110
  t129 = jnp.exp(-(-t120 + t123) * t117 * t127)
  t130 = t129 - 0.1e1
  t131 = 0.1e1 / t130
  t133 = t104 * t131 * s0
  t134 = t116 * t117 * t133
  t135 = r0 ** 2
  t137 = 0.1e1 / t7 / t135
  t139 = 0.1e1 / t109
  t141 = 0.1e1 / t3
  t143 = t19 * t141 * t5
  t147 = 0.1e1 + 0.55603792169291016666666666666666666666666666666666e-2 * t134 * t137 * t68 * t139 * t143
  t148 = t147 ** (0.1e1 / 0.4e1)
  t150 = 0.1e1 / t148 / t147
  t151 = t135 * r0
  t153 = 0.1e1 / t22 / t151
  t154 = t153 * t115
  t155 = t117 * t104
  t157 = t131 * s0
  t159 = t157 * t68 * t139
  t162 = t114 ** 2
  t163 = 0.1e1 / t162
  t164 = t112 * t163
  t165 = t164 * t155
  t171 = t103 ** 2
  t172 = 0.1e1 / t171
  t173 = t116 * t172
  t174 = t104 ** 2
  t175 = t130 ** 2
  t176 = 0.1e1 / t175
  t177 = t174 * t176
  t178 = s0 * t137
  t180 = t173 * t177 * t178
  t181 = t109 ** 2
  t183 = 0.1e1 / t181 / t108
  t185 = t68 * t183 * t19
  t186 = t141 * t5
  t187 = 0.11073470983333333333333333333333333333333333333333e-2 * t33
  t188 = 0.10000000000000000000000000000000000000000000000000e1 * t60
  t189 = 0.18311447306006545054854346104378990962041954983034e-3 * t85
  t190 = 0.58482236226346462072622386637590534819724553404280e0 * t100
  t191 = t187 + t188 - t189 - t190
  t192 = t191 * t129
  t193 = t186 * t192
  t194 = t185 * t193
  t198 = 0.1e1 / t7 / t151
  t204 = -0.55603792169291016666666666666666666666666666666666e-3 * t154 * t155 * t159 + 0.98863542476999427633333333333333333333333333333332e-3 * t165 * t157 * t153 * t68 * t139 + 0.55603792169291016666666666666666666666666666666666e-2 * t180 * t194 - 0.12974218172834570555555555555555555555555555555555e-1 * t134 * t198 * t68 * t139 * t143
  t207 = t112 ** 2
  t208 = t207 * t163
  t210 = s0 ** 2
  t211 = t177 * t210
  t212 = t208 * t172 * t211
  t213 = t135 ** 2
  t215 = 0.1e1 / t22 / t213
  t216 = t68 ** 2
  t218 = 0.1e1 / t181
  t220 = 0.1e1 / t20
  t222 = t1 * t220 * t6
  t226 = 0.1e1 + 0.11594181388521408693986931215126041666666666666666e-3 * t212 * t215 * t216 * t218 * t222
  t227 = t226 ** (0.1e1 / 0.8e1)
  t229 = 0.1e1 / t227 / t226
  t231 = t164 * t172 * t211
  t232 = t213 * t135
  t233 = 0.1e1 / t232
  t236 = t233 * t216 * t218 * t143
  t240 = 0.1e1 / t162 / t114
  t241 = t207 * t240
  t243 = t241 * t172 * t211
  t247 = 0.1e1 / t171 / t103
  t248 = t208 * t247
  t249 = t174 * t104
  t251 = 0.1e1 / t175 / t130
  t252 = t249 * t251
  t253 = t210 * t215
  t255 = t248 * t252 * t253
  t258 = t216 / t181 / t110
  t259 = t258 * t1
  t260 = t220 * t6
  t262 = t259 * t260 * t192
  t265 = t213 * r0
  t267 = 0.1e1 / t22 / t265
  t273 = -0.77294542590142724626579541434173611111111111111106e-5 * t231 * t236 + 0.13742969672527376438605842466996068055555555555556e-4 * t243 * t236 + 0.23188362777042817387973862430252083333333333333332e-3 * t255 * t262 - 0.54106179813099907238605679003921527777777777777775e-3 * t212 * t267 * t216 * t218 * t222
  t276 = t150 * t204 / 0.8e1 + t229 * t273 / 0.16e2
  t283 = 0.1e1 - 0.1e1 / t148 / 0.2e1 - 0.1e1 / t227 / 0.2e1
  t286 = t127 * t129
  t289 = 0.10000000000000000000000000000000000000000000000000e1 * t276 * t130 - 0.10000000000000000000000000000000000000000000000000e1 * t283 * t191 * t117 * t286
  t293 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t283 * t130
  t294 = 0.1e1 / t293
  t296 = t106 * t110 * t289 * t294
  t300 = 0.1e1 / t22 / t135
  t304 = 6 ** (0.1e1 / 0.3e1)
  t306 = t104 ** (0.1e1 / 0.3e1)
  t307 = t306 ** 2
  t308 = 0.1e1 / t307
  t309 = t308 * t216
  t311 = 0.5e1 / 0.9e1 * (tau0 * t53 - s0 * t300 / 0.8e1) * t304 * t309
  t312 = t311 <= 0.1e1
  t313 = jnp.log(DBL_EPSILON)
  t316 = t313 / (-t313 + 0.1131e1)
  t317 = -t316 < t311
  t318 = t311 < -t316
  t321 = s0 * t153
  t326 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t300 + t321 / 0.3e1) * t304 * t309
  t327 = f.my_piecewise3(t318, t326, 0)
  t328 = f.my_piecewise3(t318, t311, -t316)
  t329 = 0.1e1 - t328
  t330 = 0.1e1 / t329
  t333 = t329 ** 2
  t334 = 0.1e1 / t333
  t335 = t328 * t334
  t338 = -0.1131e1 * t327 * t330 - 0.1131e1 * t335 * t327
  t341 = jnp.exp(-0.1131e1 * t328 * t330)
  t343 = f.my_piecewise3(t317, 0, t338 * t341)
  t345 = jnp.log(0.72992700729927007299270072992700729927007299270073e0 * DBL_EPSILON)
  t348 = (-t345 + 0.17e1) / t345
  t349 = t311 < -t348
  t350 = f.my_piecewise3(t349, -t348, t311)
  t351 = 0.1e1 - t350
  t352 = t351 ** 2
  t353 = 0.1e1 / t352
  t354 = f.my_piecewise3(t349, 0, t326)
  t358 = jnp.exp(0.17e1 / t351)
  t361 = f.my_piecewise3(t349, 0, -0.2329e1 * t353 * t354 * t358)
  t362 = f.my_piecewise3(t312, t343, t361)
  t365 = 0.1e1 + 0.33115000000000000000000000000000000000000000000000e-1 * t14 + 0.41680000000000000000000000000000000000000000000000e-1 * t13
  t366 = 0.1e1 / t365
  t369 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t366)
  t370 = t369 - 0.1e1
  t372 = t216 * s0
  t376 = 0.1e1 + 0.42675284208752716666666666666666666666666666666666e-1 * t304 * t308 * t372 * t300
  t377 = t376 ** (0.1e1 / 0.4e1)
  t380 = t304 ** 2
  t382 = 0.1e1 / t306 / t104
  t384 = t68 * t210
  t390 = 0.1e1 + 0.45529497057445474565519084559506944444444444444445e-2 * t380 * t382 * t384 / t7 / t265
  t391 = t390 ** (0.1e1 / 0.8e1)
  t394 = 0.1e1 - 0.1e1 / t377 / 0.2e1 - 0.1e1 / t391 / 0.2e1
  t396 = t370 * t394 + 0.1e1
  t397 = jnp.log(t396)
  t403 = 0.1e1 - 0.2363e1 * t69 * t67 * t71
  t405 = jnp.log(t293)
  t408 = (-0.30197e-1 * t366 + 0.30197e-1 * t397) * t403 + t120 - t123 - t106 * t110 * t405
  t411 = f.my_piecewise3(t317, 0, t341)
  t413 = f.my_piecewise3(t349, 0, -0.137e1 * t358)
  t414 = f.my_piecewise3(t312, t411, t413)
  t415 = t365 ** 2
  t416 = 0.1e1 / t415
  t419 = -0.55191666666666666666666666666666666666666666666667e-2 * t44 - 0.13893333333333333333333333333333333333333333333333e-1 * t46
  t420 = t416 * t419
  t422 = t369 * t394
  t428 = 0.1e1 / t377 / t376 * t304 * t308
  t435 = 0.1e1 / t391 / t390 * t380 * t382
  t441 = -0.14225094736250905555555555555555555555555555555555e-1 * t428 * t372 * t153 - 0.15176499019148491521839694853168981481481481481482e-2 * t435 * t384 / t7 / t232
  t443 = -0.10000000000000000000000000000000000000000000000000e1 * t420 * t422 + t370 * t441
  t444 = 0.1e1 / t396
  t449 = (0.30197e-1 * t420 + 0.30197e-1 * t443 * t444) * t403 - t187 - t188 + t189 + t190 - t296
  t452 = t6 * t137
  t455 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t452 * t31
  t456 = t4 * t6
  t460 = 0.35616666666666666666666666666666666666666666666666e-1 * t456 * t9 * t38 * t59
  t464 = t57 ** 2
  t467 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t464 * t58
  t472 = t20 * t5 * t300
  t473 = 0.1e1 / t14 / t13 * t19 * t472
  t475 = t42 * t137
  t476 = t41 * t475
  t478 = t4 * t452
  t480 = t13 ** (-0.5e0)
  t482 = t480 * t19 * t472
  t484 = t49 * t475
  t487 = t21 * t5 * t300
  t492 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t473 + 0.84396666666666666666666666666666666666666666666666e0 * t476 + 0.39862222222222222222222222222222222222222222222223e0 * t478 + 0.68258333333333333333333333333333333333333333333333e-1 * t482 + 0.13651666666666666666666666666666666666666666666667e0 * t484 + 0.13692777777777777777777777777777777777777777777778e0 * t487) * t58
  t493 = t37 ** 2
  t496 = t30 ** 2
  t500 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t493 * t464 / t496
  t504 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t137 * t82
  t508 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t511 = t96 ** 2
  t515 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t511 * t98
  t526 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t473 + 0.11507777777777777777777777777777777777777777777778e1 * t476 + 0.40256666666666666666666666666666666666666666666667e0 * t478 + 0.36677500000000000000000000000000000000000000000000e-1 * t482 + 0.73355000000000000000000000000000000000000000000000e-1 * t484 + 0.13797500000000000000000000000000000000000000000000e0 * t487) * t98
  t527 = t90 ** 2
  t530 = t81 ** 2
  t534 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t527 * t511 / t530
  t535 = t147 ** 2
  t538 = t204 ** 2
  t545 = 0.1e1 / t265
  t549 = s0 * t68
  t554 = t172 * t174
  t555 = t554 * t176
  t558 = t183 * t191 * t129
  t562 = t112 * t240
  t580 = t116 * t247
  t583 = t181 ** 2
  t586 = t68 / t583 * t19
  t587 = t191 ** 2
  t588 = t129 ** 2
  t589 = t587 * t588
  t599 = -t455 - t460 - t467 + t492 + t500 + t504 + t508 + t515 - t526 - t534
  t600 = t599 * t129
  t608 = t587 * t129
  t620 = 0.33362275301574609999999999999999999999999999999999e-2 * t215 * t115 * t155 * t159 - 0.16477257079499904605555555555555555555555555555556e-4 * t545 * t163 * t155 * t131 * t549 * t139 * t456 - 0.11120758433858203333333333333333333333333333333333e-2 * t154 * t555 * t549 * t558 + 0.29296563087350830388677777777777777777777777777778e-4 * t562 * t117 * t133 * t545 * t68 * t139 * t456 + 0.19772708495399885526666666666666666666666666666666e-2 * t164 * t555 * t321 * t68 * t558 - 0.59318125486199656579999999999999999999999999999999e-2 * t165 * t157 * t215 * t68 * t139 + 0.11120758433858203333333333333333333333333333333333e-1 * t580 * t252 * t178 * t586 * t186 * t589 - 0.25948436345669141111111111111111111111111111111110e-1 * t173 * t177 * s0 * t198 * t194 + 0.55603792169291016666666666666666666666666666666666e-2 * t180 * t185 * t186 * t600 - 0.55603792169291016666666666666666666666666666666666e-2 * t580 * t249 * t176 * t178 * t586 * t186 * t608 + 0.43247393909448568518518518518518518518518518518517e-1 * t134 / t7 / t213 * t68 * t139 * t143
  t623 = t226 ** 2
  t626 = t273 ** 2
  t629 = t213 * t151
  t631 = 0.1e1 / t7 / t629
  t634 = t176 * t210
  t642 = t634 * t631 * t216 * t218
  t647 = t252 * t210 * t233
  t650 = t258 * t19 * t193
  t656 = 0.1e1 / t629 * t216 * t218 * t143
  t659 = t162 ** 2
  t671 = t171 ** 2
  t673 = t208 / t671
  t674 = t174 ** 2
  t675 = t175 ** 2
  t683 = t216 / t583 / t109 * t1
  t711 = 0.77294542590142724626579541434173611111111111111106e-6 * t631 * t163 * t554 * t634 * t216 * t218 - 0.54971878690109505754423369867984272222222222222221e-5 * t562 * t554 * t642 - 0.30917817036057089850631816573669444444444444444442e-4 * t164 * t247 * t647 * t650 + 0.82447512096152239601684844196451851851851851851847e-4 * t231 * t656 + 0.73305000233261025923523563718957027008333333333336e-5 * t207 / t659 * t554 * t642 + 0.54971878690109505754423369867984272222222222222223e-4 * t241 * t247 * t647 * t650 - 0.14659167650695868201179565298129139259259259259260e-3 * t243 * t656 + 0.69565088331128452163921587290756249999999999999996e-3 * t673 * t674 / t675 * t253 * t683 * t260 * t589 - 0.21642471925239962895442271601568611111111111111110e-2 * t248 * t252 * t210 * t267 * t262 + 0.23188362777042817387973862430252083333333333333332e-3 * t255 * t259 * t260 * t600 - 0.23188362777042817387973862430252083333333333333332e-3 * t673 * t674 * t251 * t253 * t683 * t260 * t608 + 0.30660168560756614101876551435555532407407407407406e-2 * t212 / t22 / t232 * t216 * t218 * t222
  t736 = t106 * t110 * (0.10000000000000000000000000000000000000000000000000e1 * (-0.5e1 / 0.32e2 / t148 / t535 * t538 + t150 * t620 / 0.8e1 - 0.9e1 / 0.128e3 / t227 / t623 * t626 + t229 * t711 / 0.16e2) * t130 - 0.20000000000000000000000000000000000000000000000000e1 * t276 * t191 * t117 * t286 - 0.10000000000000000000000000000000000000000000000000e1 * t283 * t599 * t117 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t283 * t587 * t172 * t174 / t181 / t109 * t129) * t294
  t737 = t289 ** 2
  t739 = t293 ** 2
  t742 = t106 * t110 * t737 / t739
  t750 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t153 - 0.11e2 / 0.9e1 * s0 * t215) * t304 * t309
  t751 = f.my_piecewise3(t318, t750, 0)
  t754 = t327 ** 2
  t766 = t338 ** 2
  t769 = f.my_piecewise3(t317, 0, (-0.1131e1 * t751 * t330 - 0.2262e1 * t754 * t334 - 0.2262e1 * t328 / t333 / t329 * t754 - 0.1131e1 * t335 * t751) * t341 + t766 * t341)
  t772 = t354 ** 2
  t776 = f.my_piecewise3(t349, 0, t750)
  t780 = t352 ** 2
  t786 = f.my_piecewise3(t349, 0, -0.4658e1 / t352 / t351 * t772 * t358 - 0.2329e1 * t353 * t776 * t358 - 0.39593e1 / t780 * t772 * t358)
  t787 = f.my_piecewise3(t312, t769, t786)
  t793 = t419 ** 2
  t794 = 0.1e1 / t415 / t365 * t793
  t800 = t416 * (-0.36794444444444444444444444444444444444444444444445e-2 * t473 + 0.73588888888888888888888888888888888888888888888889e-2 * t476 + 0.18524444444444444444444444444444444444444444444444e-1 * t478)
  t806 = t415 ** 2
  t814 = t376 ** 2
  t819 = t384 * t631
  t825 = t390 ** 2
  t832 = t210 ** 2
  t834 = t213 ** 2
  t848 = t443 ** 2
  t849 = t396 ** 2
  t855 = (-0.60394e-1 * t794 + 0.30197e-1 * t800 + 0.30197e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t794 * t422 - 0.10000000000000000000000000000000000000000000000000e1 * t800 * t422 + 0.10000000000000000000000000000000000000000000000000e1 / t806 * t793 * t422 - 0.20000000000000000000000000000000000000000000000000e1 * t420 * t369 * t441 + t370 * (-0.40470664051062644058239186275117283950617283950614e-2 / t377 / t814 * t380 * t382 * t819 + 0.52158680699586653703703703703703703703703703703702e-1 * t428 * t372 * t215 - 0.24875221227647233525064849710168026648849003129942e-3 / t391 / t825 * t304 / t307 / t174 * t216 * t832 / t22 / t834 / t213 + 0.96117827121273779638318067403403549382716049382719e-2 * t435 * t819)) * t444 - 0.30197e-1 * t848 / t849) * t403 + t455 + t460 + t467 - t492 - t500 - t504 - t508 - t515 + t526 + t534 - t736 + t742
  t857 = 0.2e1 * t362 * t449 + t787 * t408 + t414 * t855 - t455 - t460 - t467 + t492 + t500 + t504 + t508 + t515 - t526 - t534 + t736 - t742
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t296 + 0.2e1 * t362 * t408 + 0.2e1 * t414 * t449 + r0 * t857
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t5 = t2 / t3
  t6 = 0.1e1 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = f.my_piecewise3(t6, t8, 1)
  t10 = t9 ** 2
  t11 = t10 * t9
  t12 = 3 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / jnp.pi
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t12 * t14
  t16 = 4 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = r0 ** (0.1e1 / 0.3e1)
  t21 = t15 * t17 / t18
  t23 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t21
  t25 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t21
  t26 = 0.1e1 / t25
  t27 = t23 * t26
  t28 = 0.1e1 / t2
  t31 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t21
  t32 = jnp.sqrt(t21)
  t35 = t21 ** 0.15e1
  t37 = t12 ** 2
  t38 = t14 ** 2
  t39 = t37 * t38
  t40 = t18 ** 2
  t43 = t39 * t16 / t40
  t45 = 0.37978500000000000000000000000000000000000000000000e1 * t32 + 0.89690000000000000000000000000000000000000000000000e0 * t21 + 0.20477500000000000000000000000000000000000000000000e0 * t35 + 0.12323500000000000000000000000000000000000000000000e0 * t43
  t48 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t45
  t49 = jnp.log(t48)
  t51 = 0.621814e-1 * t31 * t49
  t53 = f.my_piecewise3(t6, t7 * f.p.zeta_threshold, 1)
  t55 = 0.2e1 * t53 - 0.2e1
  t56 = 2 ** (0.1e1 / 0.3e1)
  t57 = t56 - 0.1e1
  t59 = 0.1e1 / t57 / 0.2e1
  t60 = t55 * t59
  t62 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t21
  t67 = 0.51785000000000000000000000000000000000000000000000e1 * t32 + 0.90577500000000000000000000000000000000000000000000e0 * t21 + 0.11003250000000000000000000000000000000000000000000e0 * t35 + 0.12417750000000000000000000000000000000000000000000e0 * t43
  t70 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t67
  t71 = jnp.log(t70)
  t74 = 0.19751673498613801407483339618206552048944131217655e-1 * t60 * t62 * t71
  t78 = t3 / t11
  t80 = jnp.exp(-(-t51 + t74) * t28 * t78)
  t81 = t80 - 0.1e1
  t82 = 0.1e1 / t81
  t84 = t3 * t82 * s0
  t85 = t27 * t28 * t84
  t86 = r0 ** 2
  t88 = 0.1e1 / t18 / t86
  t90 = 0.1e1 / t10
  t92 = 0.1e1 / t14
  t93 = t37 * t92
  t94 = t93 * t16
  t98 = 0.1e1 + 0.55603792169291016666666666666666666666666666666666e-2 * t85 * t88 * t56 * t90 * t94
  t99 = t98 ** 2
  t100 = t98 ** (0.1e1 / 0.4e1)
  t102 = 0.1e1 / t100 / t99
  t103 = t86 * r0
  t105 = 0.1e1 / t40 / t103
  t106 = t105 * t26
  t107 = t28 * t3
  t109 = t82 * s0
  t111 = t109 * t56 * t90
  t114 = t25 ** 2
  t115 = 0.1e1 / t114
  t116 = t23 * t115
  t117 = t116 * t107
  t123 = t2 ** 2
  t124 = 0.1e1 / t123
  t125 = t27 * t124
  t126 = t3 ** 2
  t127 = t81 ** 2
  t128 = 0.1e1 / t127
  t129 = t126 * t128
  t130 = s0 * t88
  t132 = t125 * t129 * t130
  t133 = t10 ** 2
  t134 = t133 * t9
  t135 = 0.1e1 / t134
  t136 = t56 * t135
  t137 = t136 * t37
  t138 = t92 * t16
  t140 = 0.1e1 / t18 / r0
  t141 = t17 * t140
  t144 = 0.11073470983333333333333333333333333333333333333333e-2 * t15 * t141 * t49
  t145 = t45 ** 2
  t146 = 0.1e1 / t145
  t147 = t31 * t146
  t149 = 0.1e1 / t32 * t12
  t150 = t14 * t17
  t151 = t150 * t140
  t152 = t149 * t151
  t154 = t15 * t141
  t156 = t21 ** 0.5e0
  t157 = t156 * t12
  t158 = t157 * t151
  t161 = 0.1e1 / t40 / r0
  t163 = t39 * t16 * t161
  t165 = -0.63297500000000000000000000000000000000000000000000e0 * t152 - 0.29896666666666666666666666666666666666666666666667e0 * t154 - 0.10238750000000000000000000000000000000000000000000e0 * t158 - 0.82156666666666666666666666666666666666666666666667e-1 * t163
  t166 = 0.1e1 / t48
  t167 = t165 * t166
  t169 = 0.10000000000000000000000000000000000000000000000000e1 * t147 * t167
  t170 = t60 * t12
  t174 = 0.18311447306006545054854346104378990962041954983034e-3 * t170 * t150 * t140 * t71
  t175 = t60 * t62
  t176 = t67 ** 2
  t177 = 0.1e1 / t176
  t182 = -0.86308333333333333333333333333333333333333333333334e0 * t152 - 0.30192500000000000000000000000000000000000000000000e0 * t154 - 0.55016250000000000000000000000000000000000000000000e-1 * t158 - 0.82785000000000000000000000000000000000000000000000e-1 * t163
  t184 = 0.1e1 / t70
  t185 = t177 * t182 * t184
  t187 = 0.58482236226346462072622386637590534819724553404280e0 * t175 * t185
  t188 = t144 + t169 - t174 - t187
  t189 = t188 * t80
  t190 = t138 * t189
  t191 = t137 * t190
  t195 = 0.1e1 / t18 / t103
  t201 = -0.55603792169291016666666666666666666666666666666666e-3 * t106 * t107 * t111 + 0.98863542476999427633333333333333333333333333333332e-3 * t117 * t109 * t105 * t56 * t90 + 0.55603792169291016666666666666666666666666666666666e-2 * t132 * t191 - 0.12974218172834570555555555555555555555555555555555e-1 * t85 * t195 * t56 * t90 * t94
  t202 = t201 ** 2
  t206 = 0.1e1 / t100 / t98
  t207 = t86 ** 2
  t209 = 0.1e1 / t40 / t207
  t210 = t209 * t26
  t214 = t207 * r0
  t215 = 0.1e1 / t214
  t216 = t215 * t115
  t217 = t107 * t82
  t219 = s0 * t56
  t220 = t219 * t90
  t221 = t15 * t17
  t222 = t220 * t221
  t225 = t124 * t126
  t226 = t225 * t128
  t227 = t106 * t226
  t229 = t135 * t188 * t80
  t230 = t219 * t229
  t234 = 0.1e1 / t114 / t25
  t235 = t23 * t234
  t237 = t235 * t28 * t84
  t243 = t116 * t226
  t244 = s0 * t105
  t245 = t244 * t56
  t255 = 0.1e1 / t123 / t2
  t256 = t27 * t255
  t257 = t126 * t3
  t259 = 0.1e1 / t127 / t81
  t260 = t257 * t259
  t262 = t256 * t260 * t130
  t263 = t133 ** 2
  t264 = 0.1e1 / t263
  t265 = t56 * t264
  t266 = t265 * t37
  t267 = t188 ** 2
  t268 = t80 ** 2
  t269 = t267 * t268
  t270 = t138 * t269
  t271 = t266 * t270
  t274 = s0 * t195
  t276 = t125 * t129 * t274
  t279 = t17 * t88
  t281 = t15 * t279 * t49
  t282 = 0.14764627977777777777777777777777777777777777777777e-2 * t281
  t283 = t140 * t146
  t285 = t221 * t283 * t167
  t286 = 0.35616666666666666666666666666666666666666666666666e-1 * t285
  t288 = 0.1e1 / t145 / t45
  t289 = t31 * t288
  t290 = t165 ** 2
  t291 = t290 * t166
  t292 = t289 * t291
  t293 = 0.20000000000000000000000000000000000000000000000000e1 * t292
  t296 = 0.1e1 / t32 / t21 * t37
  t297 = t38 * t16
  t299 = 0.1e1 / t40 / t86
  t300 = t297 * t299
  t301 = t296 * t300
  t303 = t150 * t88
  t304 = t149 * t303
  t306 = t15 * t279
  t308 = t21 ** (-0.5e0)
  t309 = t308 * t37
  t310 = t309 * t300
  t312 = t157 * t303
  t315 = t39 * t16 * t299
  t317 = -0.42198333333333333333333333333333333333333333333333e0 * t301 + 0.84396666666666666666666666666666666666666666666666e0 * t304 + 0.39862222222222222222222222222222222222222222222223e0 * t306 + 0.68258333333333333333333333333333333333333333333333e-1 * t310 + 0.13651666666666666666666666666666666666666666666667e0 * t312 + 0.13692777777777777777777777777777777777777777777778e0 * t315
  t318 = t317 * t166
  t319 = t147 * t318
  t320 = 0.10000000000000000000000000000000000000000000000000e1 * t319
  t321 = t145 ** 2
  t322 = 0.1e1 / t321
  t323 = t31 * t322
  t324 = t48 ** 2
  t325 = 0.1e1 / t324
  t326 = t290 * t325
  t327 = t323 * t326
  t328 = 0.16081979498692535066756296899072713062105388428051e2 * t327
  t331 = t170 * t150 * t88 * t71
  t332 = 0.24415263074675393406472461472505321282722606644045e-3 * t331
  t333 = t60 * t15
  t335 = t333 * t141 * t185
  t336 = 0.10843581300301739842632067522386578331157260943710e-1 * t335
  t338 = 0.1e1 / t176 / t67
  t339 = t182 ** 2
  t341 = t338 * t339 * t184
  t342 = t175 * t341
  t343 = 0.11696447245269292414524477327518106963944910680856e1 * t342
  t350 = -0.57538888888888888888888888888888888888888888888889e0 * t301 + 0.11507777777777777777777777777777777777777777777778e1 * t304 + 0.40256666666666666666666666666666666666666666666667e0 * t306 + 0.36677500000000000000000000000000000000000000000000e-1 * t310 + 0.73355000000000000000000000000000000000000000000000e-1 * t312 + 0.13797500000000000000000000000000000000000000000000e0 * t315
  t352 = t177 * t350 * t184
  t353 = t175 * t352
  t354 = 0.58482236226346462072622386637590534819724553404280e0 * t353
  t355 = t176 ** 2
  t356 = 0.1e1 / t355
  t358 = t70 ** 2
  t359 = 0.1e1 / t358
  t360 = t356 * t339 * t359
  t361 = t175 * t360
  t362 = 0.17315859105681463759666483083807725165579399831905e2 * t361
  t363 = -t282 - t286 - t293 + t320 + t328 + t332 + t336 + t343 - t354 - t362
  t364 = t363 * t80
  t365 = t138 * t364
  t366 = t137 * t365
  t369 = t257 * t128
  t371 = t256 * t369 * t130
  t372 = t267 * t80
  t373 = t138 * t372
  t374 = t266 * t373
  t378 = 0.1e1 / t18 / t207
  t384 = 0.33362275301574609999999999999999999999999999999999e-2 * t210 * t107 * t111 - 0.16477257079499904605555555555555555555555555555556e-4 * t216 * t217 * t222 - 0.11120758433858203333333333333333333333333333333333e-2 * t227 * t230 + 0.29296563087350830388677777777777777777777777777778e-4 * t237 * t215 * t56 * t90 * t221 + 0.19772708495399885526666666666666666666666666666666e-2 * t243 * t245 * t229 - 0.59318125486199656579999999999999999999999999999999e-2 * t117 * t109 * t209 * t56 * t90 + 0.11120758433858203333333333333333333333333333333333e-1 * t262 * t271 - 0.25948436345669141111111111111111111111111111111110e-1 * t276 * t191 + 0.55603792169291016666666666666666666666666666666666e-2 * t132 * t366 - 0.55603792169291016666666666666666666666666666666666e-2 * t371 * t374 + 0.43247393909448568518518518518518518518518518518517e-1 * t85 * t378 * t56 * t90 * t94
  t387 = t23 ** 2
  t388 = t387 * t115
  t390 = s0 ** 2
  t391 = t129 * t390
  t392 = t388 * t124 * t391
  t393 = t56 ** 2
  t395 = 0.1e1 / t133
  t397 = 0.1e1 / t38
  t398 = t12 * t397
  t399 = t398 * t17
  t403 = 0.1e1 + 0.11594181388521408693986931215126041666666666666666e-3 * t392 * t209 * t393 * t395 * t399
  t404 = t403 ** 2
  t405 = t403 ** (0.1e1 / 0.8e1)
  t407 = 0.1e1 / t405 / t404
  t409 = t116 * t124 * t391
  t410 = t207 * t86
  t411 = 0.1e1 / t410
  t414 = t411 * t393 * t395 * t94
  t417 = t387 * t234
  t419 = t417 * t124 * t391
  t422 = t388 * t255
  t423 = t390 * t209
  t425 = t422 * t260 * t423
  t427 = 0.1e1 / t133 / t11
  t428 = t393 * t427
  t429 = t428 * t12
  t430 = t397 * t17
  t432 = t429 * t430 * t189
  t436 = 0.1e1 / t40 / t214
  t442 = -0.77294542590142724626579541434173611111111111111106e-5 * t409 * t414 + 0.13742969672527376438605842466996068055555555555556e-4 * t419 * t414 + 0.23188362777042817387973862430252083333333333333332e-3 * t425 * t432 - 0.54106179813099907238605679003921527777777777777775e-3 * t392 * t436 * t393 * t395 * t399
  t443 = t442 ** 2
  t447 = 0.1e1 / t405 / t403
  t448 = t207 * t103
  t450 = 0.1e1 / t18 / t448
  t451 = t450 * t115
  t453 = t128 * t390
  t455 = t453 * t393 * t395
  t458 = t235 * t225
  t461 = t453 * t450 * t393 * t395
  t464 = t116 * t255
  t465 = t390 * t411
  t466 = t260 * t465
  t467 = t464 * t466
  t468 = t428 * t37
  t469 = t468 * t190
  t472 = 0.1e1 / t448
  t475 = t472 * t393 * t395 * t94
  t478 = t114 ** 2
  t479 = 0.1e1 / t478
  t480 = t387 * t479
  t481 = t480 * t225
  t484 = t417 * t255
  t485 = t484 * t466
  t490 = t123 ** 2
  t491 = 0.1e1 / t490
  t492 = t388 * t491
  t493 = t126 ** 2
  t494 = t127 ** 2
  t495 = 0.1e1 / t494
  t496 = t493 * t495
  t498 = t492 * t496 * t423
  t501 = t393 / t263 / t10
  t502 = t501 * t12
  t504 = t502 * t430 * t269
  t507 = t390 * t436
  t509 = t422 * t260 * t507
  t513 = t429 * t430 * t364
  t516 = t493 * t259
  t518 = t492 * t516 * t423
  t520 = t502 * t430 * t372
  t524 = 0.1e1 / t40 / t410
  t530 = 0.77294542590142724626579541434173611111111111111106e-6 * t451 * t225 * t455 - 0.54971878690109505754423369867984272222222222222221e-5 * t458 * t461 - 0.30917817036057089850631816573669444444444444444442e-4 * t467 * t469 + 0.82447512096152239601684844196451851851851851851847e-4 * t409 * t475 + 0.73305000233261025923523563718957027008333333333336e-5 * t481 * t461 + 0.54971878690109505754423369867984272222222222222223e-4 * t485 * t469 - 0.14659167650695868201179565298129139259259259259260e-3 * t419 * t475 + 0.69565088331128452163921587290756249999999999999996e-3 * t498 * t504 - 0.21642471925239962895442271601568611111111111111110e-2 * t509 * t432 + 0.23188362777042817387973862430252083333333333333332e-3 * t425 * t513 - 0.23188362777042817387973862430252083333333333333332e-3 * t518 * t520 + 0.30660168560756614101876551435555532407407407407406e-2 * t392 * t524 * t393 * t395 * t399
  t533 = -0.5e1 / 0.32e2 * t102 * t202 + t206 * t384 / 0.8e1 - 0.9e1 / 0.128e3 * t407 * t443 + t447 * t530 / 0.16e2
  t540 = t206 * t201 / 0.8e1 + t447 * t442 / 0.16e2
  t543 = t78 * t80
  t550 = 0.1e1 - 0.1e1 / t100 / 0.2e1 - 0.1e1 / t405 / 0.2e1
  t551 = t550 * t363
  t559 = t126 / t133 / t10
  t560 = t559 * t80
  t563 = 0.10000000000000000000000000000000000000000000000000e1 * t533 * t81 - 0.20000000000000000000000000000000000000000000000000e1 * t540 * t188 * t28 * t543 - 0.10000000000000000000000000000000000000000000000000e1 * t551 * t28 * t543 + 0.10000000000000000000000000000000000000000000000000e1 * t550 * t267 * t124 * t560
  t567 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t550 * t81
  t568 = 0.1e1 / t567
  t570 = t5 * t11 * t563 * t568
  t577 = 6 ** (0.1e1 / 0.3e1)
  t579 = t3 ** (0.1e1 / 0.3e1)
  t580 = t579 ** 2
  t581 = 0.1e1 / t580
  t582 = t581 * t393
  t584 = 0.5e1 / 0.9e1 * (tau0 * t161 - s0 * t299 / 0.8e1) * t577 * t582
  t585 = t584 <= 0.1e1
  t586 = jnp.log(DBL_EPSILON)
  t589 = t586 / (-t586 + 0.1131e1)
  t590 = -t589 < t584
  t591 = t584 < -t589
  t592 = f.my_piecewise3(t591, t584, -t589)
  t593 = 0.1e1 - t592
  t594 = 0.1e1 / t593
  t597 = jnp.exp(-0.1131e1 * t592 * t594)
  t598 = f.my_piecewise3(t590, 0, t597)
  t600 = jnp.log(0.72992700729927007299270072992700729927007299270073e0 * DBL_EPSILON)
  t603 = (-t600 + 0.17e1) / t600
  t604 = t584 < -t603
  t605 = f.my_piecewise3(t604, -t603, t584)
  t606 = 0.1e1 - t605
  t609 = jnp.exp(0.17e1 / t606)
  t611 = f.my_piecewise3(t604, 0, -0.137e1 * t609)
  t612 = f.my_piecewise3(t585, t598, t611)
  t615 = 0.1e1 + 0.33115000000000000000000000000000000000000000000000e-1 * t32 + 0.41680000000000000000000000000000000000000000000000e-1 * t21
  t616 = t615 ** 2
  t618 = 0.1e1 / t616 / t615
  t621 = -0.55191666666666666666666666666666666666666666666667e-2 * t152 - 0.13893333333333333333333333333333333333333333333333e-1 * t154
  t622 = t621 ** 2
  t623 = t618 * t622
  t625 = 0.1e1 / t616
  t629 = -0.36794444444444444444444444444444444444444444444445e-2 * t301 + 0.73588888888888888888888888888888888888888888888889e-2 * t304 + 0.18524444444444444444444444444444444444444444444444e-1 * t306
  t630 = t625 * t629
  t632 = 0.1e1 / t615
  t634 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t632)
  t636 = t393 * s0
  t640 = 0.1e1 + 0.42675284208752716666666666666666666666666666666666e-1 * t577 * t581 * t636 * t299
  t641 = t640 ** (0.1e1 / 0.4e1)
  t644 = t577 ** 2
  t646 = 0.1e1 / t579 / t3
  t648 = t56 * t390
  t650 = 0.1e1 / t18 / t214
  t654 = 0.1e1 + 0.45529497057445474565519084559506944444444444444445e-2 * t644 * t646 * t648 * t650
  t655 = t654 ** (0.1e1 / 0.8e1)
  t658 = 0.1e1 - 0.1e1 / t641 / 0.2e1 - 0.1e1 / t655 / 0.2e1
  t659 = t634 * t658
  t664 = t616 ** 2
  t665 = 0.1e1 / t664
  t666 = t665 * t622
  t669 = t625 * t621
  t673 = 0.1e1 / t641 / t640 * t577 * t581
  t680 = 0.1e1 / t655 / t654 * t644 * t646
  t682 = 0.1e1 / t18 / t410
  t686 = -0.14225094736250905555555555555555555555555555555555e-1 * t673 * t636 * t105 - 0.15176499019148491521839694853168981481481481481482e-2 * t680 * t648 * t682
  t687 = t634 * t686
  t690 = t634 - 0.1e1
  t691 = t640 ** 2
  t695 = 0.1e1 / t641 / t691 * t644 * t646
  t696 = t648 * t450
  t702 = t654 ** 2
  t708 = 0.1e1 / t655 / t702 * t577 / t580 / t126
  t709 = t390 ** 2
  t710 = t393 * t709
  t711 = t207 ** 2
  t720 = -0.40470664051062644058239186275117283950617283950614e-2 * t695 * t696 + 0.52158680699586653703703703703703703703703703703702e-1 * t673 * t636 * t209 - 0.24875221227647233525064849710168026648849003129942e-3 * t708 * t710 / t40 / t711 / t207 + 0.96117827121273779638318067403403549382716049382719e-2 * t680 * t696
  t722 = 0.20000000000000000000000000000000000000000000000000e1 * t623 * t659 - 0.10000000000000000000000000000000000000000000000000e1 * t630 * t659 + 0.10000000000000000000000000000000000000000000000000e1 * t666 * t659 - 0.20000000000000000000000000000000000000000000000000e1 * t669 * t687 + t690 * t720
  t724 = t690 * t658 + 0.1e1
  t725 = 0.1e1 / t724
  t731 = -0.10000000000000000000000000000000000000000000000000e1 * t669 * t659 + t690 * t686
  t732 = t731 ** 2
  t733 = t724 ** 2
  t734 = 0.1e1 / t733
  t741 = 0.1e1 - 0.2363e1 * t57 * t55 * t59
  t749 = 0.10000000000000000000000000000000000000000000000000e1 * t540 * t81 - 0.10000000000000000000000000000000000000000000000000e1 * t550 * t188 * t28 * t543
  t750 = t749 ** 2
  t752 = t567 ** 2
  t753 = 0.1e1 / t752
  t755 = t5 * t11 * t750 * t753
  t756 = (-0.60394e-1 * t623 + 0.30197e-1 * t630 + 0.30197e-1 * t722 * t725 - 0.30197e-1 * t732 * t734) * t741 + t282 + t286 + t293 - t320 - t328 - t332 - t336 - t343 + t354 + t362 - t570 + t755
  t765 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t299 + t244 / 0.3e1) * t577 * t582
  t766 = f.my_piecewise3(t591, t765, 0)
  t769 = t593 ** 2
  t770 = 0.1e1 / t769
  t771 = t592 * t770
  t774 = -0.1131e1 * t766 * t594 - 0.1131e1 * t771 * t766
  t776 = f.my_piecewise3(t590, 0, t774 * t597)
  t777 = t606 ** 2
  t778 = 0.1e1 / t777
  t779 = f.my_piecewise3(t604, 0, t765)
  t783 = f.my_piecewise3(t604, 0, -0.2329e1 * t778 * t779 * t609)
  t784 = f.my_piecewise3(t585, t776, t783)
  t793 = (0.30197e-1 * t669 + 0.30197e-1 * t731 * t725) * t741 - t144 - t169 + t174 + t187 - t5 * t11 * t749 * t568
  t798 = s0 * t209
  t803 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t105 - 0.11e2 / 0.9e1 * t798) * t577 * t582
  t804 = f.my_piecewise3(t591, t803, 0)
  t807 = t766 ** 2
  t811 = 0.1e1 / t769 / t593
  t812 = t592 * t811
  t817 = -0.1131e1 * t804 * t594 - 0.2262e1 * t807 * t770 - 0.2262e1 * t812 * t807 - 0.1131e1 * t771 * t804
  t819 = t774 ** 2
  t822 = f.my_piecewise3(t590, 0, t817 * t597 + t819 * t597)
  t824 = 0.1e1 / t777 / t606
  t825 = t779 ** 2
  t829 = f.my_piecewise3(t604, 0, t803)
  t833 = t777 ** 2
  t834 = 0.1e1 / t833
  t839 = f.my_piecewise3(t604, 0, -0.4658e1 * t824 * t825 * t609 - 0.2329e1 * t778 * t829 * t609 - 0.39593e1 * t834 * t825 * t609)
  t840 = f.my_piecewise3(t585, t822, t839)
  t847 = 0.3e1 * t5 * t11 * t563 * t753 * t749
  t851 = 0.48245938496077605200268890697218139186316165284153e2 * t323 * t317 * t325 * t165
  t854 = 0.60000000000000000000000000000000000000000000000000e1 * t289 * t167 * t317
  t855 = t17 * t195
  t858 = 0.34450798614814814814814814814814814814814814814813e-2 * t15 * t855 * t49
  t868 = t255 * t257
  t869 = t868 * t128
  t871 = t264 * t267
  t872 = t871 * t80
  t880 = t135 * t363 * t80
  t884 = t868 * t259
  t886 = t871 * t268
  t895 = t136 * t12 * t150 * t189
  t898 = t265 * t93
  t905 = t268 * t363
  t910 = t27 * t491
  t917 = t56 / t263 / t11 * t37
  t918 = t267 * t188
  t919 = t918 * t80
  t942 = t918 * t268 * t80
  t949 = t918 * t268
  t954 = 0.16681137650787305000000000000000000000000000000000e-2 * t106 * t869 * t219 * t872 + 0.10008682590472383000000000000000000000000000000000e-1 * t210 * t226 * t230 - 0.16681137650787305000000000000000000000000000000000e-2 * t227 * t219 * t880 - 0.33362275301574609999999999999999999999999999999999e-2 * t106 * t884 * t219 * t886 - 0.49431771238499713816666666666666666666666666666666e-4 * t216 * t124 * t129 * s0 * t895 - 0.16681137650787305000000000000000000000000000000000e-1 * t371 * t898 * t16 * t363 * t189 + 0.33362275301574609999999999999999999999999999999999e-1 * t262 * t898 * t16 * t188 * t905 + 0.55603792169291016666666666666666666666666666666666e-2 * t910 * t493 * t128 * t130 * t917 * t138 * t919 + 0.12974218172834570555555555555555555555555555555555e0 * t125 * t129 * s0 * t378 * t191 - 0.77845309037007423333333333333333333333333333333330e-1 * t256 * t260 * t274 * t271 + 0.87889689262052491166033333333333333333333333333333e-4 * t235 * t124 * t129 * s0 * t215 * t895 + 0.33362275301574609999999999999999999999999999999999e-1 * t910 * t496 * t130 * t917 * t138 * t942 - 0.33362275301574609999999999999999999999999999999999e-1 * t910 * t516 * t130 * t917 * t138 * t949
  t963 = 0.32530743900905219527896202567159734993471782831130e-1 * t333 * t141 * t341
  t966 = 0.16265371950452609763948101283579867496735891415565e-1 * t333 * t141 * t352
  t969 = 0.48159733137676571081572406076840235616767705782485e0 * t333 * t141 * t360
  t972 = 0.21687162600603479685264135044773156662314521887420e-1 * t333 * t279 * t185
  t976 = t290 * t165
  t981 = 0.51726012919273400298984252201052768390886626637712e3 * t31 / t321 / t145 * t976 / t324 / t48
  t987 = 0.96491876992155210400537781394436278372632330568306e2 * t31 / t321 / t45 * t976 * t325
  t992 = 0.1e1 / t207
  t993 = 0.1e1 / t32 / t43 * t13 * t992 / 0.4e1
  t995 = t297 * t105
  t996 = t296 * t995
  t998 = t150 * t195
  t999 = t149 * t998
  t1001 = t15 * t855
  t1003 = t21 ** (-0.15e1)
  t1005 = t1003 * t13 * t992
  t1007 = t309 * t995
  t1009 = t157 * t998
  t1012 = t39 * t16 * t105
  t1017 = 0.10000000000000000000000000000000000000000000000000e1 * t147 * (-0.25319000000000000000000000000000000000000000000000e1 * t993 + 0.16879333333333333333333333333333333333333333333333e1 * t996 - 0.19692555555555555555555555555555555555555555555555e1 * t999 - 0.93011851851851851851851851851851851851851851851854e0 * t1001 + 0.13651666666666666666666666666666666666666666666667e0 * t1005 - 0.27303333333333333333333333333333333333333333333333e0 * t1007 - 0.31853888888888888888888888888888888888888888888890e0 * t1009 - 0.36514074074074074074074074074074074074074074074075e0 * t1012) * t166
  t1020 = t339 * t182
  t1026 = 0.10254018858216406658218194626490193680059335835414e4 * t175 / t355 / t176 * t1020 / t358 / t70
  t1039 = 0.58482236226346462072622386637590534819724553404280e0 * t175 * t177 * (-0.34523333333333333333333333333333333333333333333333e1 * t993 + 0.23015555555555555555555555555555555555555555555556e1 * t996 - 0.26851481481481481481481481481481481481481481481482e1 * t999 - 0.93932222222222222222222222222222222222222222222223e0 * t1001 + 0.73355000000000000000000000000000000000000000000000e-1 * t1005 - 0.14671000000000000000000000000000000000000000000000e0 * t1007 - 0.17116166666666666666666666666666666666666666666667e0 * t1009 - 0.36793333333333333333333333333333333333333333333333e0 * t1012) * t184
  t1042 = 0.60000000000000000000000000000000000000000000000000e1 * t323 * t976 * t166
  t1043 = -t963 + t966 + t969 - t972 + t981 - t987 + t1017 - t1026 - t1039 + t851 + t1042
  t1049 = 0.10389515463408878255799889850284635099347639899143e3 * t175 / t355 / t67 * t1020 * t359
  t1054 = 0.51947577317044391278999449251423175496738199495715e2 * t175 * t356 * t350 * t359 * t182
  t1058 = 0.35089341735807877243573431982554320891834732042568e1 * t175 * t356 * t1020 * t184
  t1063 = 0.35089341735807877243573431982554320891834732042568e1 * t175 * t338 * t182 * t184 * t350
  t1067 = 0.71233333333333333333333333333333333333333333333331e-1 * t221 * t88 * t146 * t167
  t1070 = 0.53424999999999999999999999999999999999999999999999e-1 * t221 * t283 * t318
  t1074 = 0.85917975471764868594145516183295969534298037676861e0 * t221 * t140 * t322 * t326
  t1078 = 0.10685000000000000000000000000000000000000000000000e0 * t221 * t140 * t288 * t291
  t1082 = 0.56968947174242584615102410102512416326352748836105e-3 * t170 * t150 * t195 * t71
  t1083 = -t854 + t1049 + t858 - t1054 - t1058 + t1063 + t1067 - t1070 - t1074 + t1078 - t1082
  t1084 = t1043 + t1083
  t1085 = t1084 * t80
  t1111 = t39 * t16
  t1125 = t23 * t479
  t1142 = -0.38922654518503711666666666666666666666666666666665e-1 * t276 * t366 + 0.38922654518503711666666666666666666666666666666665e-1 * t256 * t369 * t274 * t374 + 0.55603792169291016666666666666666666666666666666666e-2 * t132 * t137 * t138 * t1085 - 0.17795437645859896973999999999999999999999999999999e-1 * t243 * t798 * t56 * t229 + 0.29659062743099828289999999999999999999999999999999e-2 * t243 * t245 * t880 + 0.59318125486199656579999999999999999999999999999998e-2 * t116 * t884 * t245 * t886 - 0.29659062743099828289999999999999999999999999999999e-2 * t116 * t869 * t245 * t872 + 0.18124982787449895066111111111111111111111111111112e-3 * t411 * t115 * t217 * t222 - 0.29296563087350830388677777777777777777777777777780e-5 * t682 * t234 * t217 * t220 * t1111 - 0.18740537360761046358024691358024691358024691358024e0 * t85 * t650 * t56 * t90 * t94 - 0.32226219396085913427545555555555555555555555555556e-3 * t237 * t411 * t56 * t90 * t221 + 0.52089289169309776431069088888888888888888888888889e-5 * t1125 * t28 * t84 * t682 * t56 * t90 * t1111 + 0.35371178530659795219925925925925925925925925925925e-1 * t117 * t109 * t436 * t56 * t90 - 0.19893801198346341518518518518518518518518518518518e-1 * t436 * t26 * t107 * t111
  t1155 = t501 * t398
  t1178 = t388 / t490 / t2
  t1179 = t493 * t3
  t1186 = t393 / t263 / t134 * t12
  t1191 = t468 * t365
  t1194 = t116 * t491
  t1195 = t496 * t465
  t1197 = t501 * t37
  t1198 = t1197 * t270
  t1201 = t516 * t465
  t1203 = t1197 * t373
  t1208 = t417 * t491
  t1221 = t260 * t390 * t472
  t1229 = -0.69565088331128452163921587290756249999999999999996e-3 * t518 * t1155 * t17 * t363 * t189 + 0.20869526499338535649176476187226874999999999999999e-2 * t498 * t1155 * t17 * t188 * t905 - 0.32463707887859944343163407402352916666666666666665e-2 * t509 * t513 + 0.32463707887859944343163407402352916666666666666665e-2 * t492 * t516 * t507 * t520 + 0.23188362777042817387973862430252083333333333333332e-3 * t425 * t429 * t430 * t1085 + 0.23188362777042817387973862430252083333333333333332e-3 * t1178 * t1179 * t259 * t423 * t1186 * t430 * t919 - 0.46376725554085634775947724860504166666666666666663e-4 * t467 * t1191 - 0.13913017666225690432784317458151249999999999999999e-3 * t1194 * t1195 * t1198 + 0.46376725554085634775947724860504166666666666666663e-4 * t1194 * t1201 * t1203 + 0.82457818035164258631635054801976408333333333333334e-4 * t485 * t1191 + 0.24737345410549277589490516440592922500000000000000e-3 * t1208 * t1195 * t1198 - 0.82457818035164258631635054801976408333333333333334e-4 * t1208 * t1201 * t1203 + 0.18396101136453968461125930861333319444444444444443e-1 * t422 * t260 * t390 * t524 * t432 - 0.87955005904175209207077391788774835555555555555558e-3 * t484 * t1221 * t469 - 0.97391123663579833029490222207058749999999999999995e-2 * t492 * t496 * t507 * t504
  t1252 = 0.1e1 / t40 / t711
  t1255 = t1252 * t393 * t395 * t221
  t1275 = 0.1e1 / t711 * t393 * t395 * t94
  t1284 = t427 * t188 * t80
  t1285 = t390 * t450 * t393 * t1284
  t1293 = t390 * t393
  t1299 = 0.1e1 / t18 / t711
  t1302 = t453 * t1299 * t393 * t395
  t1315 = 0.49468507257691343761010906517871111111111111111107e-3 * t464 * t1221 * t469 + 0.27826035332451380865568634916302499999999999999998e-2 * t1178 * t1179 / t494 / t81 * t423 * t1186 * t430 * t942 - 0.20869526499338535649176476187226874999999999999999e-2 * t1178 * t1179 * t495 * t423 * t1186 * t430 * t949 - 0.36652500116630512961761781859478513504166666666668e-6 * t1125 * t124 * t391 * t1255 + 0.43445430138246034697341632097435198006938888888891e-6 * t387 / t478 / t25 * t124 * t391 * t1255 - 0.20440112373837742734584367623703688271604938271604e-1 * t392 / t40 / t448 * t393 * t395 * t399 - 0.78153370841144310455763758561219984567901234567897e-3 * t409 * t1275 + 0.13895669335555458399034796272184913256172839506173e-2 * t419 * t1275 - 0.32983127214065703452654021920790563333333333333333e-4 * t235 * t884 * t1285 + 0.43983000139956615554114138231374216205000000000001e-4 * t480 * t884 * t1285 + 0.68714848362636882193029212334980340277777777777776e-7 * t1252 * t234 * t226 * t1293 * t395 * t221 - 0.13194900041986984666234241469412264861500000000001e-3 * t481 * t1302 + 0.98949381642197110357962065762371689999999999999999e-4 * t458 * t1302 + 0.46376725554085634775947724860504166666666666666663e-5 * t451 * t884 * t1293 * t1284 - 0.13913017666225690432784317458151249999999999999999e-4 * t1299 * t115 * t225 * t455
  t1353 = t5 * t11 * (0.10000000000000000000000000000000000000000000000000e1 * (0.45e2 / 0.128e3 / t100 / t99 / t98 * t202 * t201 - 0.15e2 / 0.32e2 * t102 * t201 * t384 + t206 * (t954 + t1142) / 0.8e1 + 0.153e3 / 0.1024e4 / t405 / t404 / t403 * t443 * t442 - 0.27e2 / 0.128e3 * t407 * t442 * t530 + t447 * (t1229 + t1315) / 0.16e2) * t81 - 0.30000000000000000000000000000000000000000000000000e1 * t533 * t188 * t28 * t543 - 0.30000000000000000000000000000000000000000000000000e1 * t540 * t363 * t28 * t543 + 0.30000000000000000000000000000000000000000000000000e1 * t540 * t267 * t124 * t560 - 0.10000000000000000000000000000000000000000000000000e1 * t550 * t1084 * t28 * t543 + 0.30000000000000000000000000000000000000000000000000e1 * t551 * t124 * t559 * t189 - 0.10000000000000000000000000000000000000000000000000e1 * t550 * t918 * t255 * t257 / t263 / t9 * t80) * t568
  t1354 = t847 - t851 + t854 - t858 - t1353 + t1054 - t1063 - t1067 + t1070 + t1074 - t1078 + t1082 + t1026
  t1361 = 0.2e1 * t5 * t11 * t750 * t749 / t752 / t567
  t1362 = t622 * t621
  t1363 = t665 * t1362
  t1365 = t618 * t621
  t1373 = t625 * (-0.22076666666666666666666666666666666666666666666667e-1 * t993 + 0.14717777777777777777777777777777777777777777777778e-1 * t996 - 0.17170740740740740740740740740740740740740740740741e-1 * t999 - 0.43223703703703703703703703703703703703703703703703e-1 * t1001)
  t1417 = t648 * t1299
  t1429 = t711 ** 2
  t1445 = -0.60000000000000000000000000000000000000000000000000e1 * t1363 * t659 + 0.60000000000000000000000000000000000000000000000000e1 * t1365 * t659 * t629 - 0.60000000000000000000000000000000000000000000000000e1 / t664 / t615 * t1362 * t659 + 0.60000000000000000000000000000000000000000000000000e1 * t623 * t687 - 0.10000000000000000000000000000000000000000000000000e1 * t1373 * t659 + 0.30000000000000000000000000000000000000000000000000e1 * t665 * t629 * t621 * t634 * t658 - 0.30000000000000000000000000000000000000000000000000e1 * t630 * t687 - 0.10000000000000000000000000000000000000000000000000e1 / t664 / t616 * t1362 * t659 + 0.30000000000000000000000000000000000000000000000000e1 * t666 * t687 - 0.30000000000000000000000000000000000000000000000000e1 * t669 * t634 * t720 + t690 * (-0.12435099051571559301165135467231908156473707960739e-1 / t641 / t691 / t640 / t126 * t390 * s0 / t711 / t103 + 0.44517730456168908464063104902629012345679012345675e-1 * t695 * t1417 - 0.24340717659807105061728395061728395061728395061728e0 * t673 * t636 * t436 - 0.15402765838949590968878043368250166867332965941869e-3 / t655 / t702 / t654 / t493 * t709 * t390 / t1429 / t103 + 0.47262920332529743697623214449319250632813105946890e-2 * t708 * t710 / t40 / t711 / t214 - 0.70486406555600771734766582762495936213991769547327e-1 * t680 * t1417)
  t1458 = t1039 - t1049 + t1058 - t1361 - t1042 - t1017 - t981 + t987 + t972 + t963 - t966 - t969 + (0.181182e0 * t1363 - 0.181182e0 * t1365 * t629 + 0.30197e-1 * t1373 + 0.30197e-1 * t1445 * t725 - 0.90591e-1 * t722 * t734 * t731 + 0.60394e-1 * t732 * t731 / t733 / t724) * t741
  t1468 = 0.5e1 / 0.9e1 * (-0.440e3 / 0.27e2 * tau0 * t209 + 0.154e3 / 0.27e2 * s0 * t436) * t577 * t582
  t1469 = f.my_piecewise3(t591, t1468, 0)
  t1475 = t807 * t766
  t1478 = t769 ** 2
  t1496 = f.my_piecewise3(t590, 0, (-0.1131e1 * t1469 * t594 - 0.6786e1 * t804 * t770 * t766 - 0.6786e1 * t1475 * t811 - 0.6786e1 * t592 / t1478 * t1475 - 0.6786e1 * t812 * t766 * t804 - 0.1131e1 * t771 * t1469) * t597 + 0.3e1 * t817 * t774 * t597 + t819 * t774 * t597)
  t1497 = t825 * t779
  t1510 = f.my_piecewise3(t604, 0, t1468)
  t1524 = f.my_piecewise3(t604, 0, -0.13974e2 * t834 * t1497 * t609 - 0.13974e2 * t824 * t779 * t609 * t829 - 0.237558e2 / t833 / t606 * t1497 * t609 - 0.2329e1 * t778 * t1510 * t609 - 0.118779e2 * t834 * t829 * t779 * t609 - 0.673081e1 / t833 / t777 * t1497 * t609)
  t1525 = f.my_piecewise3(t585, t1496, t1524)
  t1527 = jnp.log(t724)
  t1531 = jnp.log(t567)
  t1534 = (-0.30197e-1 * t632 + 0.30197e-1 * t1527) * t741 + t51 - t74 - t5 * t11 * t1531
  t1536 = 0.3e1 * t840 * t793 + t612 * (t1354 + t1458) - t847 + t851 - t854 + t858 + t1353 + t1525 * t1534 - t1054 + t1063 + t1067 - t1070 - t1074 + t1078
  t1539 = 0.3e1 * t784 * t756 + t1017 - t1026 - t1039 + t1042 + t1049 - t1058 - t1082 + t1361 - t963 + t966 + t969 - t972 + t981 - t987
  v3rho3_0_ = 0.3e1 * t570 + 0.32530743900905219527896202567159734993471782831130e-1 * t335 + 0.3e1 * t612 * t756 + 0.6e1 * t784 * t793 + r0 * (t1536 + t1539) + 0.3e1 * t840 * t1534 - 0.10685000000000000000000000000000000000000000000000e0 * t285 + 0.73245789224026180219417384417515963848167819932136e-3 * t331 + 0.48245938496077605200268890697218139186316165284153e2 * t327 - 0.60000000000000000000000000000000000000000000000000e1 * t292 + 0.30000000000000000000000000000000000000000000000000e1 * t319 + 0.35089341735807877243573431982554320891834732042568e1 * t342 - 0.17544670867903938621786715991277160445917366021284e1 * t353 - 0.51947577317044391278999449251423175496738199495715e2 * t361 - 0.3e1 * t755 - 0.44293883933333333333333333333333333333333333333332e-2 * t281

  res = {'v3rho3': v3rho3_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t5 = tau0 / t2 / r0
  t6 = r0 - r1
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = 0.1e1 + t9
  t11 = t10 / 0.2e1
  t12 = t11 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t13 * t11
  t16 = r1 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t20 = tau1 / t17 / r1
  t21 = 0.1e1 - t9
  t22 = t21 / 0.2e1
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t24 * t22
  t28 = s0 + 0.2e1 * s1 + s2
  t29 = t7 ** 2
  t30 = t7 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = 0.1e1 / t31 / t29
  t37 = 6 ** (0.1e1 / 0.3e1)
  t38 = (t5 * t14 + t20 * t25 - t28 * t33 / 0.8e1) * t37
  t39 = jnp.pi ** 2
  t40 = t39 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t43 = t14 + t25
  t45 = t42 / t43
  t47 = 0.5e1 / 0.9e1 * t38 * t45
  t48 = t47 <= 0.1e1
  t49 = jnp.log(DBL_EPSILON)
  t52 = t49 / (-t49 + 0.1131e1)
  t53 = -t52 < t47
  t54 = t47 < -t52
  t55 = r0 ** 2
  t58 = tau0 / t2 / t55
  t61 = 0.1e1 / t29
  t62 = t6 * t61
  t63 = t8 - t62
  t64 = t63 / 0.2e1
  t65 = t13 * t64
  t68 = -t64
  t69 = t24 * t68
  t72 = t29 * t7
  t74 = 0.1e1 / t31 / t72
  t75 = t28 * t74
  t76 = t75 / 0.3e1
  t78 = (-0.5e1 / 0.3e1 * t58 * t14 + 0.5e1 / 0.3e1 * t5 * t65 + 0.5e1 / 0.3e1 * t20 * t69 + t76) * t37
  t80 = t43 ** 2
  t82 = t42 / t80
  t84 = 0.5e1 / 0.3e1 * t65 + 0.5e1 / 0.3e1 * t69
  t85 = t82 * t84
  t88 = -0.5e1 / 0.9e1 * t38 * t85 + 0.5e1 / 0.9e1 * t78 * t45
  t89 = f.my_piecewise3(t54, t88, 0)
  t90 = f.my_piecewise3(t54, t47, -t52)
  t91 = 0.1e1 - t90
  t92 = 0.1e1 / t91
  t95 = t91 ** 2
  t96 = 0.1e1 / t95
  t97 = t90 * t96
  t100 = -0.1131e1 * t89 * t92 - 0.1131e1 * t97 * t89
  t103 = jnp.exp(-0.1131e1 * t90 * t92)
  t105 = f.my_piecewise3(t53, 0, t100 * t103)
  t107 = jnp.log(0.72992700729927007299270072992700729927007299270073e0 * DBL_EPSILON)
  t110 = (-t107 + 0.17e1) / t107
  t111 = t47 < -t110
  t112 = f.my_piecewise3(t111, -t110, t47)
  t113 = 0.1e1 - t112
  t114 = t113 ** 2
  t115 = 0.1e1 / t114
  t116 = f.my_piecewise3(t111, 0, t88)
  t120 = jnp.exp(0.17e1 / t113)
  t123 = f.my_piecewise3(t111, 0, -0.2329e1 * t115 * t116 * t120)
  t124 = f.my_piecewise3(t48, t105, t123)
  t125 = 3 ** (0.1e1 / 0.3e1)
  t127 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t128 = t125 * t127
  t129 = 4 ** (0.1e1 / 0.3e1)
  t130 = t129 ** 2
  t133 = t128 * t130 / t30
  t134 = jnp.sqrt(t133)
  t137 = 0.1e1 + 0.33115000000000000000000000000000000000000000000000e-1 * t134 + 0.41680000000000000000000000000000000000000000000000e-1 * t133
  t138 = 0.1e1 / t137
  t141 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t138)
  t142 = t141 - 0.1e1
  t144 = 2 ** (0.1e1 / 0.3e1)
  t145 = t144 ** 2
  t146 = t145 * t28
  t150 = 0.1e1 + 0.42675284208752716666666666666666666666666666666666e-1 * t37 * t42 * t146 * t33
  t151 = t150 ** (0.1e1 / 0.4e1)
  t154 = t37 ** 2
  t156 = 0.1e1 / t40 / t39
  t158 = t28 ** 2
  t159 = t144 * t158
  t160 = t29 ** 2
  t161 = t160 * t7
  t167 = 0.1e1 + 0.45529497057445474565519084559506944444444444444445e-2 * t154 * t156 * t159 / t30 / t161
  t168 = t167 ** (0.1e1 / 0.8e1)
  t171 = 0.1e1 - 0.1e1 / t151 / 0.2e1 - 0.1e1 / t168 / 0.2e1
  t173 = t142 * t171 + 0.1e1
  t174 = jnp.log(t173)
  t176 = -0.30197e-1 * t138 + 0.30197e-1 * t174
  t177 = t144 - 0.1e1
  t178 = t10 <= f.p.zeta_threshold
  t179 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t180 = t179 * f.p.zeta_threshold
  t181 = t10 ** (0.1e1 / 0.3e1)
  t182 = t181 * t10
  t183 = f.my_piecewise3(t178, t180, t182)
  t184 = t21 <= f.p.zeta_threshold
  t185 = t21 ** (0.1e1 / 0.3e1)
  t186 = t185 * t21
  t187 = f.my_piecewise3(t184, t180, t186)
  t188 = t183 + t187 - 0.2e1
  t191 = 0.1e1 / t177 / 0.2e1
  t194 = 0.1e1 - 0.2363e1 * t177 * t188 * t191
  t195 = t176 * t194
  t196 = t6 ** 2
  t197 = t196 ** 2
  t198 = t197 ** 2
  t199 = t198 * t197
  t200 = t160 ** 2
  t201 = t200 * t160
  t202 = 0.1e1 / t201
  t204 = -t199 * t202 + 0.1e1
  t207 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t133
  t210 = t133 ** 0.15e1
  t212 = t125 ** 2
  t213 = t127 ** 2
  t214 = t212 * t213
  t217 = t214 * t129 / t31
  t219 = 0.37978500000000000000000000000000000000000000000000e1 * t134 + 0.89690000000000000000000000000000000000000000000000e0 * t133 + 0.20477500000000000000000000000000000000000000000000e0 * t210 + 0.12323500000000000000000000000000000000000000000000e0 * t217
  t222 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t219
  t223 = jnp.log(t222)
  t225 = 0.621814e-1 * t207 * t223
  t226 = 0.1e1 / t160
  t227 = t197 * t226
  t228 = t188 * t191
  t230 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t133
  t235 = 0.70594500000000000000000000000000000000000000000000e1 * t134 + 0.15494250000000000000000000000000000000000000000000e1 * t133 + 0.42077500000000000000000000000000000000000000000000e0 * t210 + 0.15629250000000000000000000000000000000000000000000e0 * t217
  t238 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t235
  t239 = jnp.log(t238)
  t243 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t133
  t248 = 0.51785000000000000000000000000000000000000000000000e1 * t134 + 0.90577500000000000000000000000000000000000000000000e0 * t133 + 0.11003250000000000000000000000000000000000000000000e0 * t210 + 0.12417750000000000000000000000000000000000000000000e0 * t217
  t251 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t248
  t252 = jnp.log(t251)
  t253 = t243 * t252
  t255 = -0.3109070e-1 * t230 * t239 + t225 - 0.19751673498613801407483339618206552048944131217655e-1 * t253
  t256 = t228 * t255
  t257 = t227 * t256
  t259 = 0.19751673498613801407483339618206552048944131217655e-1 * t228 * t253
  t260 = jnp.log(0.2e1)
  t261 = 0.1e1 - t260
  t263 = t261 / t39
  t264 = t179 ** 2
  t265 = t181 ** 2
  t266 = f.my_piecewise3(t178, t264, t265)
  t267 = t185 ** 2
  t268 = f.my_piecewise3(t184, t264, t267)
  t270 = t266 / 0.2e1 + t268 / 0.2e1
  t271 = t270 ** 2
  t272 = t271 * t270
  t274 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t133
  t276 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t133
  t277 = 0.1e1 / t276
  t279 = 0.1e1 / t261
  t280 = t274 * t277 * t279
  t282 = (-t225 + t257 + t259) * t279
  t283 = 0.1e1 / t272
  t284 = t39 * t283
  t286 = jnp.exp(-t282 * t284)
  t287 = t286 - 0.1e1
  t288 = 0.1e1 / t287
  t289 = t39 * t288
  t290 = t289 * t28
  t291 = t280 * t290
  t293 = 0.1e1 / t30 / t29
  t294 = t293 * t144
  t295 = 0.1e1 / t271
  t297 = 0.1e1 / t127
  t298 = t212 * t297
  t299 = t298 * t129
  t303 = 0.1e1 + 0.55603792169291016666666666666666666666666666666666e-2 * t291 * t294 * t295 * t299
  t304 = t303 ** (0.1e1 / 0.4e1)
  t307 = t274 ** 2
  t308 = t276 ** 2
  t309 = 0.1e1 / t308
  t311 = t261 ** 2
  t312 = 0.1e1 / t311
  t313 = t307 * t309 * t312
  t314 = t39 ** 2
  t315 = t287 ** 2
  t316 = 0.1e1 / t315
  t317 = t314 * t316
  t318 = t317 * t158
  t319 = t313 * t318
  t321 = 0.1e1 / t31 / t160
  t322 = t321 * t145
  t323 = t271 ** 2
  t324 = 0.1e1 / t323
  t326 = 0.1e1 / t213
  t327 = t125 * t326
  t328 = t327 * t130
  t332 = 0.1e1 + 0.11594181388521408693986931215126041666666666666666e-3 * t319 * t322 * t324 * t328
  t333 = t332 ** (0.1e1 / 0.8e1)
  t336 = 0.1e1 - 0.1e1 / t304 / 0.2e1 - 0.1e1 / t333 / 0.2e1
  t339 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t287
  t340 = jnp.log(t339)
  t343 = -t263 * t272 * t340 + t195 * t204 + t225 - t257 - t259
  t344 = t124 * t343
  t348 = f.my_piecewise3(t178, 0, 0.4e1 / 0.3e1 * t181 * t63)
  t349 = -t63
  t352 = f.my_piecewise3(t184, 0, 0.4e1 / 0.3e1 * t185 * t349)
  t354 = (t348 + t352) * t191
  t355 = t354 * t253
  t357 = t219 ** 2
  t358 = 0.1e1 / t357
  t359 = t207 * t358
  t361 = 0.1e1 / t134 * t125
  t362 = t127 * t130
  t364 = 0.1e1 / t30 / t7
  t365 = t362 * t364
  t366 = t361 * t365
  t368 = t130 * t364
  t369 = t128 * t368
  t371 = t133 ** 0.5e0
  t372 = t371 * t125
  t373 = t372 * t365
  t378 = t214 * t129 / t31 / t7
  t380 = -0.63297500000000000000000000000000000000000000000000e0 * t366 - 0.29896666666666666666666666666666666666666666666667e0 * t369 - 0.10238750000000000000000000000000000000000000000000e0 * t373 - 0.82156666666666666666666666666666666666666666666667e-1 * t378
  t381 = 0.1e1 / t222
  t382 = t380 * t381
  t383 = t359 * t382
  t384 = 0.20000000000000000000000000000000000000000000000000e1 * t383
  t385 = t271 * t340
  t386 = 0.1e1 / t181
  t389 = f.my_piecewise3(t178, 0, 0.2e1 / 0.3e1 * t386 * t63)
  t390 = 0.1e1 / t185
  t393 = f.my_piecewise3(t184, 0, 0.2e1 / 0.3e1 * t390 * t349)
  t395 = t389 / 0.2e1 + t393 / 0.2e1
  t397 = t263 * t385 * t395
  t402 = t235 ** 2
  t403 = 0.1e1 / t402
  t404 = t230 * t403
  t409 = -0.11765750000000000000000000000000000000000000000000e1 * t366 - 0.51647500000000000000000000000000000000000000000000e0 * t369 - 0.21038750000000000000000000000000000000000000000000e0 * t373 - 0.10419500000000000000000000000000000000000000000000e0 * t378
  t410 = 0.1e1 / t238
  t411 = t409 * t410
  t415 = t128 * t368 * t223
  t416 = 0.11073470983333333333333333333333333333333333333333e-2 * t415
  t417 = 0.10000000000000000000000000000000000000000000000000e1 * t383
  t421 = t248 ** 2
  t422 = 0.1e1 / t421
  t423 = t243 * t422
  t428 = -0.86308333333333333333333333333333333333333333333334e0 * t366 - 0.30192500000000000000000000000000000000000000000000e0 * t369 - 0.55016250000000000000000000000000000000000000000000e-1 * t373 - 0.82785000000000000000000000000000000000000000000000e-1 * t378
  t429 = 0.1e1 / t251
  t430 = t428 * t429
  t433 = 0.53237641966666666666666666666666666666666666666666e-3 * t128 * t368 * t239 + 0.10000000000000000000000000000000000000000000000000e1 * t404 * t411 - t416 - t417 + 0.18311447306006545054854346104378990962041954983034e-3 * t128 * t368 * t252 + 0.58482236226346462072622386637590534819724553404280e0 * t423 * t430
  t434 = t228 * t433
  t435 = t227 * t434
  t436 = 0.2e1 * t435
  t437 = t354 * t255
  t438 = t227 * t437
  t441 = 0.1e1 / t304 / t303
  t442 = t74 * t277
  t443 = t279 * t39
  t444 = t442 * t443
  t445 = t288 * t28
  t446 = t144 * t295
  t447 = t445 * t446
  t449 = 0.55603792169291016666666666666666666666666666666666e-3 * t444 * t447
  t450 = t274 * t309
  t451 = t450 * t443
  t456 = 0.98863542476999427633333333333333333333333333333332e-3 * t451 * t445 * t74 * t144 * t295
  t457 = t39 * t316
  t458 = t28 * t293
  t460 = t280 * t457 * t458
  t461 = t446 * t212
  t462 = t297 * t129
  t463 = t196 * t6
  t464 = t463 * t226
  t465 = t464 * t256
  t466 = 0.4e1 * t465
  t467 = 0.1e1 / t161
  t468 = t197 * t467
  t469 = t468 * t256
  t470 = 0.4e1 * t469
  t471 = 0.19751673498613801407483339618206552048944131217655e-1 * t355
  t472 = t228 * t125
  t474 = t362 * t364 * t252
  t475 = t472 * t474
  t476 = 0.18311447306006545054854346104378990962041954983034e-3 * t475
  t477 = t228 * t243
  t479 = t422 * t428 * t429
  t480 = t477 * t479
  t481 = 0.58482236226346462072622386637590534819724553404280e0 * t480
  t483 = (t416 + t417 + t466 - t470 + t438 + t435 + t471 - t476 - t481) * t279
  t485 = t39 * t324
  t486 = t485 * t395
  t489 = 0.3e1 * t282 * t486 - t483 * t284
  t490 = t489 * t286
  t491 = t462 * t490
  t492 = t461 * t491
  t496 = 0.1e1 / t30 / t72
  t497 = t496 * t144
  t501 = 0.12974218172834570555555555555555555555555555555555e-1 * t291 * t497 * t295 * t299
  t502 = t294 * t283
  t504 = t298 * t129 * t395
  t508 = -t449 + t456 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t492 - t501 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t504
  t512 = 0.1e1 / t333 / t332
  t513 = t450 * t312
  t514 = t513 * t318
  t515 = t160 * t29
  t516 = 0.1e1 / t515
  t517 = t516 * t145
  t519 = t517 * t324 * t299
  t521 = 0.77294542590142724626579541434173611111111111111106e-5 * t514 * t519
  t523 = 0.1e1 / t308 / t276
  t525 = t307 * t523 * t312
  t526 = t525 * t318
  t528 = 0.13742969672527376438605842466996068055555555555556e-4 * t526 * t519
  t530 = 0.1e1 / t315 / t287
  t531 = t314 * t530
  t532 = t158 * t321
  t534 = t313 * t531 * t532
  t535 = t145 * t324
  t536 = t535 * t125
  t537 = t326 * t130
  t539 = t536 * t537 * t490
  t543 = 0.1e1 / t31 / t161
  t544 = t543 * t145
  t548 = 0.54106179813099907238605679003921527777777777777775e-3 * t319 * t544 * t324 * t328
  t550 = 0.1e1 / t323 / t270
  t551 = t322 * t550
  t553 = t327 * t130 * t395
  t557 = -t521 + t528 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t539 - t548 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t553
  t560 = t441 * t508 / 0.8e1 + t512 * t557 / 0.16e2
  t566 = 0.10000000000000000000000000000000000000000000000000e1 * t560 * t287 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t489 * t286
  t568 = 0.1e1 / t339
  t570 = t263 * t272 * t566 * t568
  t572 = 0.8e1 * t465
  t573 = 0.8e1 * t469
  t574 = 0.22146941966666666666666666666666666666666666666666e-2 * t415
  t575 = 0.36622894612013090109708692208757981924083909966068e-3 * t475
  t576 = 0.11696447245269292414524477327518106963944910680856e1 * t480
  t577 = t303 ** 2
  t579 = 0.1e1 / t304 / t577
  t580 = t508 ** 2
  t583 = t489 ** 2
  t584 = t583 * t286
  t592 = 0.33362275301574609999999999999999999999999999999999e-2 * t321 * t277 * t443 * t447
  t593 = t144 * t283
  t594 = t593 * t395
  t596 = t444 * t445 * t594
  t598 = t274 * t523
  t603 = t128 * t130
  t606 = 0.29296563087350830388677777777777777777777777777778e-4 * t598 * t279 * t290 * t467 * t144 * t295 * t603
  t607 = t443 * t316
  t608 = t442 * t607
  t609 = t28 * t144
  t611 = t295 * t489 * t286
  t613 = t608 * t609 * t611
  t619 = 0.59318125486199656579999999999999999999999999999999e-2 * t451 * t445 * t321 * t144 * t295
  t620 = t443 * t288
  t621 = t450 * t620
  t623 = t621 * t75 * t594
  t631 = 0.43247393909448568518518518518518518518518518518517e-1 * t291 / t30 / t160 * t144 * t295 * t299
  t632 = t497 * t283
  t634 = t291 * t632 * t504
  t636 = 0.1e1 / t182
  t637 = t63 ** 2
  t640 = 0.1e1 / t72
  t641 = t6 * t640
  t642 = -t61 + t641
  t643 = 0.2e1 * t642
  t647 = f.my_piecewise3(t178, 0, -0.2e1 / 0.9e1 * t636 * t637 + 0.2e1 / 0.3e1 * t386 * t643)
  t648 = 0.1e1 / t186
  t649 = t349 ** 2
  t652 = -t643
  t656 = f.my_piecewise3(t184, 0, -0.2e1 / 0.9e1 * t648 * t649 + 0.2e1 / 0.3e1 * t390 * t652)
  t658 = t647 / 0.2e1 + t656 / 0.2e1
  t669 = 0.16477257079499904605555555555555555555555555555556e-4 * t467 * t309 * t620 * t609 * t295 * t603
  t670 = t450 * t607
  t671 = t75 * t144
  t673 = t670 * t671 * t611
  t675 = t593 * t298
  t677 = t286 * t395
  t684 = t280 * t457 * t28 * t496
  t685 = t684 * t492
  t689 = t280 * t39 * t530 * t458
  t690 = t286 ** 2
  t691 = t583 * t690
  t697 = t354 * t125 * t474
  t698 = 0.36622894612013090109708692208757981924083909966068e-3 * t697
  t700 = 0.1e1 / t421 / t248
  t701 = t428 ** 2
  t705 = 0.11696447245269292414524477327518106963944910680856e1 * t477 * t700 * t701 * t429
  t709 = 0.35616666666666666666666666666666666666666666666666e-1 * t603 * t364 * t358 * t382
  t710 = t130 * t293
  t721 = t409 ** 2
  t729 = t213 * t129 * t33
  t730 = 0.1e1 / t134 / t133 * t212 * t729
  t732 = t362 * t293
  t733 = t361 * t732
  t735 = t128 * t710
  t737 = t133 ** (-0.5e0)
  t739 = t737 * t212 * t729
  t741 = t372 * t732
  t744 = t214 * t129 * t33
  t750 = t402 ** 2
  t753 = t238 ** 2
  t760 = 0.14764627977777777777777777777777777777777777777777e-2 * t128 * t710 * t223
  t764 = t380 ** 2
  t767 = 0.20000000000000000000000000000000000000000000000000e1 * t207 / t357 / t219 * t764 * t381
  t777 = 0.10000000000000000000000000000000000000000000000000e1 * t359 * (-0.42198333333333333333333333333333333333333333333333e0 * t730 + 0.84396666666666666666666666666666666666666666666666e0 * t733 + 0.39862222222222222222222222222222222222222222222223e0 * t735 + 0.68258333333333333333333333333333333333333333333333e-1 * t739 + 0.13651666666666666666666666666666666666666666666667e0 * t741 + 0.13692777777777777777777777777777777777777777777778e0 * t744) * t381
  t778 = t357 ** 2
  t781 = t222 ** 2
  t785 = 0.16081979498692535066756296899072713062105388428051e2 * t207 / t778 * t764 / t781
  t803 = -0.57538888888888888888888888888888888888888888888889e0 * t730 + 0.11507777777777777777777777777777777777777777777778e1 * t733 + 0.40256666666666666666666666666666666666666666666667e0 * t735 + 0.36677500000000000000000000000000000000000000000000e-1 * t739 + 0.73355000000000000000000000000000000000000000000000e-1 * t741 + 0.13797500000000000000000000000000000000000000000000e0 * t744
  t807 = t421 ** 2
  t808 = 0.1e1 / t807
  t810 = t251 ** 2
  t811 = 0.1e1 / t810
  t815 = -0.70983522622222222222222222222222222222222222222221e-3 * t128 * t710 * t239 - 0.34246666666666666666666666666666666666666666666666e-1 * t603 * t364 * t403 * t411 - 0.20000000000000000000000000000000000000000000000000e1 * t230 / t402 / t235 * t721 * t410 + 0.10000000000000000000000000000000000000000000000000e1 * t404 * (-0.78438333333333333333333333333333333333333333333333e0 * t730 + 0.15687666666666666666666666666666666666666666666667e1 * t733 + 0.68863333333333333333333333333333333333333333333333e0 * t735 + 0.14025833333333333333333333333333333333333333333333e0 * t739 + 0.28051666666666666666666666666666666666666666666667e0 * t741 + 0.17365833333333333333333333333333333333333333333333e0 * t744) * t410 + 0.32163958997385070133512593798145426124210776856102e2 * t230 / t750 * t721 / t753 + t760 + t709 + t767 - t777 - t785 - 0.24415263074675393406472461472505321282722606644045e-3 * t128 * t710 * t252 - 0.10843581300301739842632067522386578331157260943710e-1 * t603 * t364 * t422 * t430 - 0.11696447245269292414524477327518106963944910680856e1 * t243 * t700 * t701 * t429 + 0.58482236226346462072622386637590534819724553404280e0 * t423 * t803 * t429 + 0.17315859105681463759666483083807725165579399831905e2 * t243 * t808 * t701 * t811
  t817 = t227 * t228 * t815
  t818 = 0.1e1 / t265
  t824 = f.my_piecewise3(t178, 0, 0.4e1 / 0.9e1 * t818 * t637 + 0.4e1 / 0.3e1 * t181 * t643)
  t825 = 0.1e1 / t267
  t831 = f.my_piecewise3(t184, 0, 0.4e1 / 0.9e1 * t825 * t649 + 0.4e1 / 0.3e1 * t185 * t652)
  t833 = (t824 + t831) * t191
  t835 = t227 * t833 * t255
  t837 = t227 * t354 * t433
  t838 = 0.2e1 * t837
  t839 = t468 * t437
  t840 = 0.8e1 * t839
  t842 = 0.8e1 * t468 * t434
  t843 = t464 * t437
  t844 = 0.8e1 * t843
  t846 = 0.8e1 * t464 * t434
  t847 = -t698 + t705 - t709 + t817 + t835 + t838 - t840 - t842 + t844 + t846 - t767
  t851 = 0.17315859105681463759666483083807725165579399831905e2 * t477 * t808 * t701 * t811
  t853 = t354 * t243 * t479
  t854 = 0.11696447245269292414524477327518106963944910680856e1 * t853
  t858 = 0.58482236226346462072622386637590534819724553404280e0 * t477 * t422 * t803 * t429
  t861 = 0.20e2 * t197 * t516 * t256
  t864 = 0.12e2 * t196 * t226 * t256
  t867 = 0.32e2 * t463 * t467 * t256
  t871 = 0.10843581300301739842632067522386578331157260943710e-1 * t228 * t128 * t368 * t479
  t873 = 0.19751673498613801407483339618206552048944131217655e-1 * t833 * t253
  t877 = 0.24415263074675393406472461472505321282722606644045e-3 * t472 * t362 * t293 * t252
  t878 = -t851 - t854 - t858 + t861 + t864 - t867 - t760 + t871 + t777 + t785 + t873 + t877
  t884 = t39 * t550
  t885 = t395 ** 2
  t892 = -(t847 + t878) * t279 * t284 + 0.6e1 * t483 * t486 - 0.12e2 * t282 * t884 * t885 + 0.3e1 * t282 * t485 * t658
  t893 = t892 * t286
  t898 = t294 * t324
  t904 = -0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t584 + t592 + 0.22241516867716406666666666666666666666666666666666e-2 * t596 + t606 + 0.11120758433858203333333333333333333333333333333333e-2 * t613 - t619 - 0.39545416990799771053333333333333333333333333333332e-2 * t623 + t631 + 0.51896872691338282222222222222222222222222222222220e-1 * t634 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t298 * t129 * t658 - t669 - 0.19772708495399885526666666666666666666666666666666e-2 * t673 + 0.22241516867716406666666666666666666666666666666666e-1 * t460 * t675 * t129 * t489 * t677 + 0.25948436345669141111111111111111111111111111111110e-1 * t685 + 0.11120758433858203333333333333333333333333333333333e-1 * t689 * t461 * t462 * t691 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t893 + 0.33362275301574609999999999999999999999999999999999e-1 * t291 * t898 * t298 * t129 * t885
  t907 = t332 ** 2
  t909 = 0.1e1 / t333 / t907
  t910 = t557 ** 2
  t919 = t313 * t531 * t158 * t543
  t920 = t919 * t539
  t923 = t145 * t550 * t327
  t929 = t312 * t314
  t931 = t316 * t158
  t932 = t160 * t72
  t934 = 0.1e1 / t30 / t932
  t937 = t931 * t934 * t145 * t324
  t939 = 0.54971878690109505754423369867984272222222222222221e-5 * t598 * t929 * t937
  t940 = t308 ** 2
  t945 = 0.73305000233261025923523563718957027008333333333336e-5 * t307 / t940 * t929 * t937
  t952 = 0.30660168560756614101876551435555532407407407407406e-2 * t319 / t31 / t515 * t145 * t324 * t328
  t953 = t544 * t550
  t955 = t319 * t953 * t553
  t965 = 0.1e1 / t932 * t145 * t324 * t299
  t967 = 0.14659167650695868201179565298129139259259259259260e-3 * t526 * t965
  t968 = t517 * t550
  t969 = t968 * t504
  t970 = t526 * t969
  t973 = 0.82447512096152239601684844196451851851851851851847e-4 * t514 * t965
  t974 = t514 * t969
  t976 = t315 ** 2
  t980 = t313 * t314 / t976 * t532
  t986 = t531 * t158 * t516
  t987 = t513 * t986
  t988 = t535 * t212
  t989 = t988 * t491
  t990 = t987 * t989
  t992 = t525 * t986
  t993 = t992 * t989
  t1000 = 0.1e1 / t323 / t271
  t1001 = t322 * t1000
  t1011 = 0.77294542590142724626579541434173611111111111111106e-6 * t934 * t309 * t929 * t931 * t535
  t1012 = -0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t584 + 0.21642471925239962895442271601568611111111111111110e-2 * t920 + 0.18550690221634253910379089944201666666666666666666e-2 * t534 * t923 * t130 * t489 * t677 - t939 + t945 + t952 + 0.43284943850479925790884543203137222222222222222220e-2 * t955 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t327 * t130 * t658 - t967 - 0.10994375738021901150884673973596854444444444444445e-3 * t970 + t973 + 0.61835634072114179701263633147338888888888888888884e-4 * t974 + 0.69565088331128452163921587290756249999999999999996e-3 * t980 * t536 * t537 * t691 + 0.30917817036057089850631816573669444444444444444442e-4 * t990 - 0.54971878690109505754423369867984272222222222222223e-4 * t993 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t893 + 0.23188362777042817387973862430252083333333333333332e-2 * t319 * t1001 * t327 * t130 * t885 + t1011
  t1030 = t263 * t272 * (0.10000000000000000000000000000000000000000000000000e1 * (-0.5e1 / 0.32e2 * t579 * t580 + t441 * t904 / 0.8e1 - 0.9e1 / 0.128e3 * t909 * t910 + t512 * t1012 / 0.16e2) * t287 + 0.20000000000000000000000000000000000000000000000000e1 * t560 * t489 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t892 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t583 * t286) * t568
  t1031 = t270 * t340
  t1034 = 0.6e1 * t263 * t1031 * t885
  t1035 = t263 * t271
  t1036 = t566 * t568
  t1039 = 0.6e1 * t1035 * t1036 * t395
  t1040 = t1030 + t846 + t861 + t817 - t709 - t698 + t877 + t1034 + t785 - t767 + t777 + t1039 - t854 - t858 - t842
  t1041 = t566 ** 2
  t1043 = t339 ** 2
  t1044 = 0.1e1 / t1043
  t1046 = t263 * t272 * t1041 * t1044
  t1047 = f.my_piecewise3(t53, 0, t103)
  t1049 = f.my_piecewise3(t111, 0, -0.137e1 * t120)
  t1050 = f.my_piecewise3(t48, t1047, t1049)
  t1051 = t137 ** 2
  t1052 = 0.1e1 / t1051
  t1055 = -0.55191666666666666666666666666666666666666666666667e-2 * t366 - 0.13893333333333333333333333333333333333333333333333e-1 * t369
  t1056 = t1052 * t1055
  t1058 = t141 * t171
  t1064 = 0.1e1 / t151 / t150 * t37 * t42
  t1071 = 0.1e1 / t168 / t167 * t154 * t156
  t1077 = -0.14225094736250905555555555555555555555555555555555e-1 * t1064 * t146 * t74 - 0.15176499019148491521839694853168981481481481481482e-2 * t1071 * t159 / t30 / t515
  t1079 = -0.10000000000000000000000000000000000000000000000000e1 * t1056 * t1058 + t142 * t1077
  t1080 = 0.1e1 / t173
  t1083 = 0.30197e-1 * t1056 + 0.30197e-1 * t1079 * t1080
  t1084 = t1083 * t177
  t1085 = t354 * t204
  t1086 = t1084 * t1085
  t1088 = -t1030 - t846 - t861 - t817 + t709 + t698 - t877 - t1034 - t785 + t767 - t777 - t1039 + t854 + t858 + t842 - t844 - 0.4726e1 * t1086
  t1089 = t176 * t177
  t1093 = t198 * t463
  t1094 = t1093 * t202
  t1096 = 0.1e1 / t200 / t161
  t1097 = t199 * t1096
  t1099 = -0.12e2 * t1094 + 0.12e2 * t1097
  t1105 = 0.132e3 * t198 * t196 * t202
  t1107 = 0.288e3 * t1093 * t1096
  t1111 = 0.156e3 * t199 / t200 / t515
  t1114 = t1083 * t194
  t1115 = t1114 * t1099
  t1119 = t1055 ** 2
  t1120 = 0.1e1 / t1051 / t137 * t1119
  t1126 = t1052 * (-0.36794444444444444444444444444444444444444444444445e-2 * t730 + 0.73588888888888888888888888888888888888888888888889e-2 * t733 + 0.18524444444444444444444444444444444444444444444444e-1 * t735)
  t1132 = t1051 ** 2
  t1140 = t150 ** 2
  t1145 = t159 * t934
  t1151 = t167 ** 2
  t1158 = t158 ** 2
  t1172 = t1079 ** 2
  t1173 = t173 ** 2
  t1179 = (-0.60394e-1 * t1120 + 0.30197e-1 * t1126 + 0.30197e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t1120 * t1058 - 0.10000000000000000000000000000000000000000000000000e1 * t1126 * t1058 + 0.10000000000000000000000000000000000000000000000000e1 / t1132 * t1119 * t1058 - 0.20000000000000000000000000000000000000000000000000e1 * t1056 * t141 * t1077 + t142 * (-0.40470664051062644058239186275117283950617283950614e-2 / t151 / t1140 * t154 * t156 * t1145 + 0.52158680699586653703703703703703703703703703703702e-1 * t1064 * t146 * t321 - 0.24875221227647233525064849710168026648849003129942e-3 / t168 / t1151 * t37 / t41 / t314 * t145 * t1158 / t31 / t201 + 0.96117827121273779638318067403403549382716049382719e-2 * t1071 * t1145)) * t1080 - 0.30197e-1 * t1172 / t1173) * t194 * t204
  t1182 = 0.3e1 * t263 * t385 * t658
  t1183 = -0.2363e1 * t1089 * t833 * t204 - 0.4726e1 * t1089 * t354 * t1099 - t838 + t840 + t1046 - t864 + t867 - t835 + t195 * (-t1105 + t1107 - t1111) + 0.2e1 * t1115 + t1179 - t705 + t851 - t873 - t1182 - t871 + t760
  t1194 = 0.1e1 / t12
  t1195 = t64 ** 2
  t1196 = t1194 * t1195
  t1199 = t13 * t642
  t1202 = 0.1e1 / t23
  t1203 = t68 ** 2
  t1204 = t1202 * t1203
  t1208 = -t24 * t642
  t1212 = 0.11e2 / 0.9e1 * t28 * t321
  t1220 = 0.1e1 / t80 / t43
  t1221 = t42 * t1220
  t1222 = t84 ** 2
  t1234 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 / t2 / t55 / r0 * t14 - 0.50e2 / 0.9e1 * t58 * t65 + 0.10e2 / 0.9e1 * t5 * t1196 + 0.5e1 / 0.3e1 * t5 * t1199 + 0.10e2 / 0.9e1 * t20 * t1204 + 0.5e1 / 0.3e1 * t20 * t1208 - t1212) * t37 * t45 - 0.10e2 / 0.9e1 * t78 * t85 + 0.10e2 / 0.9e1 * t38 * t1221 * t1222 - 0.5e1 / 0.9e1 * t38 * t82 * (0.10e2 / 0.9e1 * t1196 + 0.5e1 / 0.3e1 * t1199 + 0.10e2 / 0.9e1 * t1204 + 0.5e1 / 0.3e1 * t1208)
  t1235 = f.my_piecewise3(t54, t1234, 0)
  t1238 = t89 ** 2
  t1243 = t90 / t95 / t91
  t1250 = t100 ** 2
  t1253 = f.my_piecewise3(t53, 0, (-0.1131e1 * t1235 * t92 - 0.2262e1 * t1238 * t96 - 0.2262e1 * t1243 * t1238 - 0.1131e1 * t97 * t1235) * t103 + t1250 * t103)
  t1255 = 0.1e1 / t114 / t113
  t1256 = t116 ** 2
  t1260 = f.my_piecewise3(t111, 0, t1234)
  t1264 = t114 ** 2
  t1265 = 0.1e1 / t1264
  t1270 = f.my_piecewise3(t111, 0, -0.4658e1 * t1255 * t1256 * t120 - 0.2329e1 * t115 * t1260 * t120 - 0.39593e1 * t1265 * t1256 * t120)
  t1271 = f.my_piecewise3(t48, t1253, t1270)
  t1273 = t1114 * t204
  t1277 = 0.3e1 * t397
  t1278 = t1273 - 0.2363e1 * t1089 * t1085 + t195 * t1099 - t416 - t417 - t466 + t470 - t438 - t435 - t471 + t476 + t481 - t1277 - t570
  t1281 = t844 + t838 - t840 - t1046 + t864 - t867 + t835 + t1050 * (t1088 + t1183) + t705 - t851 + t1271 * t343 + t873 + t1182 + 0.2e1 * t124 * t1278 + t871 - t760
  t1284 = t1050 * t1278
  d11 = 0.2e1 * t344 + 0.39503346997227602814966679236413104097888262435310e-1 * t355 + t384 + 0.6e1 * t397 + t436 + 0.2e1 * t438 + 0.2e1 * t570 + t572 - t573 + t574 - t575 - t576 + t7 * (t1040 + t1281) + 0.2e1 * t1284
  t1286 = -t8 - t62
  t1289 = f.my_piecewise3(t178, 0, 0.4e1 / 0.3e1 * t181 * t1286)
  t1290 = -t1286
  t1293 = f.my_piecewise3(t184, 0, 0.4e1 / 0.3e1 * t185 * t1290)
  t1295 = (t1289 + t1293) * t191
  t1296 = t1295 * t255
  t1297 = t227 * t1296
  t1298 = t1295 * t253
  t1299 = 0.19751673498613801407483339618206552048944131217655e-1 * t1298
  t1301 = (t416 + t417 - t466 - t470 + t1297 + t435 + t1299 - t476 - t481) * t279
  t1305 = f.my_piecewise3(t178, 0, 0.2e1 / 0.3e1 * t386 * t1286)
  t1308 = f.my_piecewise3(t184, 0, 0.2e1 / 0.3e1 * t390 * t1290)
  t1310 = t1305 / 0.2e1 + t1308 / 0.2e1
  t1311 = t485 * t1310
  t1314 = -t1301 * t284 + 0.3e1 * t282 * t1311
  t1315 = t1314 * t286
  t1316 = t462 * t1315
  t1317 = t461 * t1316
  t1320 = t129 * t1310
  t1321 = t298 * t1320
  t1325 = -t449 + t456 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t1317 - t501 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t1321
  t1329 = t536 * t537 * t1315
  t1332 = t130 * t1310
  t1333 = t327 * t1332
  t1337 = -t521 + t528 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t1329 - t548 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t1333
  t1340 = t441 * t1325 / 0.8e1 + t512 * t1337 / 0.16e2
  t1343 = t336 * t1314
  t1346 = 0.10000000000000000000000000000000000000000000000000e1 * t1340 * t287 + 0.10000000000000000000000000000000000000000000000000e1 * t1343 * t286
  t1349 = t263 * t272 * t1346 * t568
  t1350 = 0.18311447306006545054854346104378990962041954983034e-3 * t697
  t1358 = f.my_piecewise3(t178, 0, 0.4e1 / 0.9e1 * t818 * t1286 * t63 + 0.8e1 / 0.3e1 * t181 * t6 * t640)
  t1366 = f.my_piecewise3(t184, 0, 0.4e1 / 0.9e1 * t825 * t1290 * t349 - 0.8e1 / 0.3e1 * t185 * t6 * t640)
  t1368 = (t1358 + t1366) * t191
  t1370 = t227 * t1368 * t255
  t1378 = f.my_piecewise3(t178, 0, -0.2e1 / 0.9e1 * t636 * t1286 * t63 + 0.4e1 / 0.3e1 * t386 * t6 * t640)
  t1386 = f.my_piecewise3(t184, 0, -0.2e1 / 0.9e1 * t648 * t1290 * t349 - 0.4e1 / 0.3e1 * t390 * t6 * t640)
  t1388 = t1378 / 0.2e1 + t1386 / 0.2e1
  t1391 = 0.3e1 * t263 * t385 * t1388
  t1395 = t684 * t1317
  t1397 = t129 * t1314
  t1402 = t446 * t298
  t1415 = t1310 * t395
  t1420 = 0.58482236226346462072622386637590534819724553404280e0 * t853
  t1421 = 0.4e1 * t843
  t1422 = t861 + t817 - t709 - t1350 + t877 + t1370 + t785 - t767 + t777 - t1420 - t858 - t842 - t1421
  t1423 = 0.4e1 * t839
  t1425 = t1295 * t243 * t479
  t1426 = 0.58482236226346462072622386637590534819724553404280e0 * t1425
  t1428 = 0.19751673498613801407483339618206552048944131217655e-1 * t1368 * t253
  t1430 = t1295 * t125 * t474
  t1431 = 0.18311447306006545054854346104378990962041954983034e-3 * t1430
  t1432 = t464 * t1296
  t1433 = 0.4e1 * t1432
  t1434 = t468 * t1296
  t1435 = 0.4e1 * t1434
  t1437 = t227 * t1295 * t433
  t1438 = t837 - t1423 - t864 + t705 - t851 - t1426 + t1428 - t1431 + t1433 - t1435 + t1437 + t871 - t760
  t1454 = -(t1422 + t1438) * t279 * t284 + 0.3e1 * t1301 * t486 + 0.3e1 * t483 * t1311 - 0.12e2 * t282 * t39 * t550 * t1310 * t395 + 0.3e1 * t282 * t485 * t1388
  t1455 = t1454 * t286
  t1462 = t291 * t632 * t1321
  t1465 = t593 * t1310
  t1467 = t444 * t445 * t1465
  t1474 = 0.12974218172834570555555555555555555555555555555555e-1 * t1395 + 0.11120758433858203333333333333333333333333333333333e-1 * t460 * t675 * t1397 * t677 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t1402 * t1397 * t490 + 0.11120758433858203333333333333333333333333333333333e-1 * t460 * t675 * t1320 * t490 + 0.33362275301574609999999999999999999999999999999999e-1 * t280 * t289 * t458 * t144 * t324 * t212 * t462 * t1415 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t1455 + 0.12974218172834570555555555555555555555555555555555e-1 * t685 + 0.25948436345669141111111111111111111111111111111110e-1 * t1462 + 0.11120758433858203333333333333333333333333333333333e-2 * t596 + 0.11120758433858203333333333333333333333333333333333e-2 * t1467 + t592 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t298 * t129 * t1388
  t1477 = t295 * t1314 * t286
  t1479 = t608 * t609 * t1477
  t1482 = t621 * t75 * t1465
  t1486 = t690 * t489
  t1493 = t670 * t671 * t1477
  t1495 = t606 - 0.19772708495399885526666666666666666666666666666666e-2 * t623 + 0.55603792169291016666666666666666666666666666666666e-3 * t1479 - 0.19772708495399885526666666666666666666666666666666e-2 * t1482 + 0.55603792169291016666666666666666666666666666666666e-3 * t613 - t619 + t631 + 0.25948436345669141111111111111111111111111111111110e-1 * t634 + 0.11120758433858203333333333333333333333333333333333e-1 * t689 * t1402 * t1397 * t1486 - t669 - 0.98863542476999427633333333333333333333333333333332e-3 * t673 - 0.98863542476999427633333333333333333333333333333332e-3 * t1493
  t1502 = t968 * t1321
  t1503 = t526 * t1502
  t1506 = t319 * t953 * t1333
  t1513 = t514 * t1502
  t1530 = -t967 + t973 + t952 - 0.54971878690109505754423369867984272222222222222222e-4 * t1503 + 0.21642471925239962895442271601568611111111111111110e-2 * t1506 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t327 * t130 * t1388 + 0.30917817036057089850631816573669444444444444444442e-4 * t1513 + 0.10821235962619981447721135800784305555555555555555e-2 * t920 + 0.15458908518028544925315908286834722222222222222221e-4 * t990 - 0.27485939345054752877211684933992136111111111111112e-4 * t993 + 0.23188362777042817387973862430252083333333333333332e-2 * t313 * t317 * t532 * t145 * t1000 * t125 * t537 * t1415 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t1455
  t1531 = t988 * t1316
  t1532 = t987 * t1531
  t1534 = t992 * t1531
  t1536 = t919 * t1329
  t1538 = t535 * t327
  t1539 = t130 * t1314
  t1559 = 0.15458908518028544925315908286834722222222222222221e-4 * t1532 - 0.27485939345054752877211684933992136111111111111111e-4 * t1534 + 0.10821235962619981447721135800784305555555555555555e-2 * t1536 + 0.69565088331128452163921587290756249999999999999996e-3 * t980 * t1538 * t1539 * t1486 + 0.92753451108171269551895449721008333333333333333328e-3 * t534 * t923 * t1539 * t677 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t1538 * t1539 * t490 + 0.92753451108171269551895449721008333333333333333328e-3 * t534 * t923 * t1332 * t490 - t939 + t945 + t1011 + 0.21642471925239962895442271601568611111111111111110e-2 * t955 - 0.54971878690109505754423369867984272222222222222224e-4 * t970 + 0.30917817036057089850631816573669444444444444444442e-4 * t974
  t1580 = t263 * t272 * (0.10000000000000000000000000000000000000000000000000e1 * (-0.5e1 / 0.32e2 * t579 * t1325 * t508 + t441 * (t1474 + t1495) / 0.8e1 - 0.9e1 / 0.128e3 * t909 * t1337 * t557 + t512 * (t1530 + t1559) / 0.16e2) * t287 + 0.10000000000000000000000000000000000000000000000000e1 * t1340 * t489 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t560 * t1314 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t1454 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t1343 * t490) * t568
  t1584 = t263 * t272 * t1346 * t1044 * t566
  t1585 = t1295 * t204
  t1589 = 0.12e2 * t1094 + 0.12e2 * t1097
  t1592 = t263 * t385 * t1310
  t1593 = 0.3e1 * t1592
  t1594 = t1273 - 0.2363e1 * t1089 * t1585 + t195 * t1589 - t416 - t417 + t466 + t470 - t1297 - t435 - t1299 + t476 + t481 - t1593 - t1349
  t1596 = t124 * t1594 - t1350 + t1370 + t1391 - t1420 - t1421 + t1580 - t1584 - t709 - t767 + t777 + t785 + t817 + t837 - t842 - t858 + t861 + t877
  t1601 = 0.6e1 * t263 * t270 * t340 * t1310 * t395
  t1602 = t1286 / 0.2e1
  t1603 = t13 * t1602
  t1607 = t1194 * t1602 * t64
  t1611 = t13 * t6 * t640
  t1614 = r1 ** 2
  t1617 = tau1 / t17 / t1614
  t1620 = -t1602
  t1622 = t1202 * t1620 * t68
  t1626 = t24 * t6 * t640
  t1637 = t24 * t1620
  t1641 = (0.5e1 / 0.3e1 * t5 * t1603 - 0.5e1 / 0.3e1 * t1617 * t25 + 0.5e1 / 0.3e1 * t20 * t1637 + t76) * t37
  t1645 = 0.5e1 / 0.3e1 * t1603 + 0.5e1 / 0.3e1 * t1637
  t1646 = t82 * t1645
  t1662 = 0.5e1 / 0.9e1 * (-0.25e2 / 0.9e1 * t58 * t1603 + 0.10e2 / 0.9e1 * t5 * t1607 + 0.5e1 / 0.3e1 * t5 * t1611 - 0.25e2 / 0.9e1 * t1617 * t69 + 0.10e2 / 0.9e1 * t20 * t1622 - 0.5e1 / 0.3e1 * t20 * t1626 - t1212) * t37 * t45 - 0.5e1 / 0.9e1 * t1641 * t85 - 0.5e1 / 0.9e1 * t78 * t1646 + 0.10e2 / 0.9e1 * t38 * t42 * t1220 * t1645 * t84 - 0.5e1 / 0.9e1 * t38 * t82 * (0.10e2 / 0.9e1 * t1607 + 0.5e1 / 0.3e1 * t1611 + 0.10e2 / 0.9e1 * t1622 - 0.5e1 / 0.3e1 * t1626)
  t1663 = f.my_piecewise3(t54, t1662, 0)
  t1669 = 0.5e1 / 0.9e1 * t1641 * t45 - 0.5e1 / 0.9e1 * t38 * t1646
  t1670 = f.my_piecewise3(t54, t1669, 0)
  t1685 = -0.1131e1 * t1670 * t92 - 0.1131e1 * t97 * t1670
  t1689 = f.my_piecewise3(t53, 0, (-0.1131e1 * t1663 * t92 - 0.2262e1 * t1670 * t96 * t89 - 0.2262e1 * t1243 * t1670 * t89 - 0.1131e1 * t97 * t1663) * t103 + t1685 * t100 * t103)
  t1690 = f.my_piecewise3(t111, 0, t1669)
  t1692 = t120 * t116
  t1695 = f.my_piecewise3(t111, 0, t1662)
  t1703 = f.my_piecewise3(t111, 0, -0.4658e1 * t1255 * t1690 * t1692 - 0.2329e1 * t115 * t1695 * t120 - 0.39593e1 * t1265 * t1690 * t1692)
  t1704 = f.my_piecewise3(t48, t1689, t1703)
  t1707 = f.my_piecewise3(t53, 0, t1685 * t103)
  t1711 = f.my_piecewise3(t111, 0, -0.2329e1 * t115 * t1690 * t120)
  t1712 = f.my_piecewise3(t48, t1707, t1711)
  t1714 = t1084 * t1585
  t1722 = t1114 * t1589
  t1723 = -0.2363e1 * t1714 - 0.2363e1 * t1089 * t1368 * t204 - 0.2363e1 * t1089 * t1295 * t1099 - t861 - t817 + t709 + t1350 - t877 - t1370 + t1722 - t785 + t767 - t777 - t1391 - t1580 + t1420 + t858 + t1584 + t842 + t1421
  t1731 = t1346 * t568
  t1734 = 0.3e1 * t1035 * t1731 * t395
  t1737 = 0.3e1 * t1035 * t1036 * t1310
  t1738 = -t1428 + t1431 - t1601 + t195 * (t1105 - t1111) - t1433 + t1435 - t1437 - t871 + t760 - t1734 - t1737
  t1742 = -t1423 - t864 + t705 - t851 - t1426 + t1428 - t1431 + t1601 + t1704 * t343 + t1712 * t1278 + t1433 - t1435 + t1437 + t871 - t760 + t1050 * (t1723 - 0.2363e1 * t1089 * t354 * t1589 - 0.2363e1 * t1086 - t837 + t1423 + t864 + t1115 + t1179 - t705 + t851 + t1426 + t1738) + t1734 + t1737
  t1745 = t1050 * t1594
  t1746 = t1712 * t343
  d12 = -t575 + t1277 + t1349 + t438 + t471 + t384 + t7 * (t1596 + t1742) + t436 + t344 + t1284 - t573 + t1297 + t574 + t570 - t576 + t1593 + t1299 + t1745 + t1746
  t1748 = t1346 ** 2
  t1751 = t263 * t272 * t1748 * t1044
  t1752 = t1286 ** 2
  t1755 = t61 + t641
  t1756 = 0.2e1 * t1755
  t1760 = f.my_piecewise3(t178, 0, 0.4e1 / 0.9e1 * t818 * t1752 + 0.4e1 / 0.3e1 * t181 * t1756)
  t1761 = t1290 ** 2
  t1764 = -t1756
  t1768 = f.my_piecewise3(t184, 0, 0.4e1 / 0.9e1 * t825 * t1761 + 0.4e1 / 0.3e1 * t185 * t1764)
  t1770 = (t1760 + t1768) * t191
  t1772 = t227 * t1770 * t255
  t1773 = t1325 ** 2
  t1776 = t1310 ** 2
  t1782 = 0.36622894612013090109708692208757981924083909966068e-3 * t1430
  t1783 = 0.8e1 * t1434
  t1784 = 0.2e1 * t1437
  t1785 = -t1782 + t705 - t709 + t864 - t1783 - t842 + t867 + t817 + t1772 + t1784 - t858
  t1786 = 0.11696447245269292414524477327518106963944910680856e1 * t1425
  t1787 = 0.8e1 * t1432
  t1789 = 0.19751673498613801407483339618206552048944131217655e-1 * t1770 * t253
  t1790 = -t1786 - t760 - t1787 - t846 - t767 + t1789 - t851 + t871 + t777 + t785 + t861 + t877
  t1804 = f.my_piecewise3(t178, 0, -0.2e1 / 0.9e1 * t636 * t1752 + 0.2e1 / 0.3e1 * t386 * t1756)
  t1810 = f.my_piecewise3(t184, 0, -0.2e1 / 0.9e1 * t648 * t1761 + 0.2e1 / 0.3e1 * t390 * t1764)
  t1812 = t1804 / 0.2e1 + t1810 / 0.2e1
  t1816 = -(t1785 + t1790) * t279 * t284 + 0.6e1 * t1301 * t1311 - 0.12e2 * t282 * t884 * t1776 + 0.3e1 * t282 * t485 * t1812
  t1817 = t1816 * t286
  t1824 = t1314 ** 2
  t1825 = t1824 * t690
  t1830 = t1824 * t286
  t1836 = t286 * t1310
  t1849 = 0.33362275301574609999999999999999999999999999999999e-1 * t291 * t898 * t298 * t129 * t1776 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t1817 + t606 + 0.11120758433858203333333333333333333333333333333333e-2 * t1479 - t619 - 0.39545416990799771053333333333333333333333333333332e-2 * t1482 + t631 + 0.11120758433858203333333333333333333333333333333333e-1 * t689 * t461 * t462 * t1825 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t1830 + 0.25948436345669141111111111111111111111111111111110e-1 * t1395 + 0.22241516867716406666666666666666666666666666666666e-1 * t460 * t675 * t1397 * t1836 + t592 + 0.22241516867716406666666666666666666666666666666666e-2 * t1467 - t669 - 0.19772708495399885526666666666666666666666666666666e-2 * t1493 + 0.51896872691338282222222222222222222222222222222220e-1 * t1462 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t298 * t129 * t1812
  t1852 = t1337 ** 2
  t1887 = -0.54971878690109505754423369867984272222222222222223e-4 * t1534 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t1817 + 0.30917817036057089850631816573669444444444444444442e-4 * t1532 + t952 + 0.43284943850479925790884543203137222222222222222220e-2 * t1506 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t327 * t130 * t1812 + 0.18550690221634253910379089944201666666666666666666e-2 * t534 * t923 * t1539 * t1836 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t1830 + 0.69565088331128452163921587290756249999999999999996e-3 * t980 * t536 * t537 * t1825 + 0.21642471925239962895442271601568611111111111111110e-2 * t1536 - t939 + t945 + 0.23188362777042817387973862430252083333333333333332e-2 * t319 * t1001 * t327 * t130 * t1776 + 0.61835634072114179701263633147338888888888888888884e-4 * t1513 - t967 - 0.10994375738021901150884673973596854444444444444445e-3 * t1503 + t1011 + t973
  t1905 = t263 * t272 * (0.10000000000000000000000000000000000000000000000000e1 * (-0.5e1 / 0.32e2 * t579 * t1773 + t441 * t1849 / 0.8e1 - 0.9e1 / 0.128e3 * t909 * t1852 + t512 * t1887 / 0.16e2) * t287 + 0.20000000000000000000000000000000000000000000000000e1 * t1340 * t1314 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t1816 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t1824 * t286) * t568
  t1906 = -t1751 + t1772 - t846 + t861 + t817 - t709 + t877 + t785 - t767 + t777 + t1905 - t858 - t842 + t864 + t867
  t1909 = 0.6e1 * t1035 * t1731 * t1310
  t1912 = t1602 ** 2
  t1913 = t1194 * t1912
  t1916 = t13 * t1755
  t1927 = t1620 ** 2
  t1928 = t1202 * t1927
  t1932 = -t24 * t1755
  t1941 = t1645 ** 2
  t1953 = 0.5e1 / 0.9e1 * (0.10e2 / 0.9e1 * t5 * t1913 + 0.5e1 / 0.3e1 * t5 * t1916 + 0.40e2 / 0.9e1 * tau1 / t17 / t1614 / r1 * t25 - 0.50e2 / 0.9e1 * t1617 * t1637 + 0.10e2 / 0.9e1 * t20 * t1928 + 0.5e1 / 0.3e1 * t20 * t1932 - t1212) * t37 * t45 - 0.10e2 / 0.9e1 * t1641 * t1646 + 0.10e2 / 0.9e1 * t38 * t1221 * t1941 - 0.5e1 / 0.9e1 * t38 * t82 * (0.10e2 / 0.9e1 * t1913 + 0.5e1 / 0.3e1 * t1916 + 0.10e2 / 0.9e1 * t1928 + 0.5e1 / 0.3e1 * t1932)
  t1954 = f.my_piecewise3(t54, t1953, 0)
  t1957 = t1670 ** 2
  t1966 = t1685 ** 2
  t1969 = f.my_piecewise3(t53, 0, (-0.1131e1 * t1954 * t92 - 0.2262e1 * t1957 * t96 - 0.2262e1 * t1243 * t1957 - 0.1131e1 * t97 * t1954) * t103 + t1966 * t103)
  t1970 = t1690 ** 2
  t1974 = f.my_piecewise3(t111, 0, t1953)
  t1982 = f.my_piecewise3(t111, 0, -0.4658e1 * t1255 * t1970 * t120 - 0.2329e1 * t115 * t1974 * t120 - 0.39593e1 * t1265 * t1970 * t120)
  t1983 = f.my_piecewise3(t48, t1969, t1982)
  t1987 = t1751 - 0.4726e1 * t1714 - t1772 + t846 - t861 - t817 + t709 - t877 + 0.2e1 * t1722 - t785 + t767 - t777 - t1905 + t858 + t842 - t864 - t867
  t1998 = 0.6e1 * t263 * t1031 * t1776
  t2001 = 0.3e1 * t263 * t385 * t1812
  t2002 = t1179 - t1909 - t705 + t851 + t1786 + t1782 - t1789 + t1787 + t1783 - t1784 - t871 + t760 + t195 * (-t1105 - t1107 - t1111) - 0.2363e1 * t1089 * t1770 * t204 - 0.4726e1 * t1089 * t1295 * t1589 - t1998 - t2001
  t2005 = t1909 + t705 - t851 - t1786 - t1782 + 0.2e1 * t1712 * t1594 + t1983 * t343 + t1789 - t1787 - t1783 + t1784 + t871 - t760 + t1050 * (t1987 + t2002) + t1998 + t2001
  d22 = 0.2e1 * t1746 + t7 * (t1906 + t2005) + 0.2e1 * t1745 + 0.6e1 * t1592 - t576 + 0.39503346997227602814966679236413104097888262435310e-1 * t1298 + t384 - t575 + t574 - t572 + 0.2e1 * t1349 - t573 + 0.2e1 * t1297 + t436
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t5 = tau0 / t2 / r0
  t6 = r0 - r1
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = 0.1e1 + t9
  t11 = t10 / 0.2e1
  t12 = t11 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t13 * t11
  t16 = r1 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t20 = tau1 / t17 / r1
  t21 = 0.1e1 - t9
  t22 = t21 / 0.2e1
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t24 * t22
  t28 = s0 + 0.2e1 * s1 + s2
  t29 = t7 ** 2
  t30 = t7 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = 0.1e1 / t31 / t29
  t37 = 6 ** (0.1e1 / 0.3e1)
  t38 = (t5 * t14 + t20 * t25 - t28 * t33 / 0.8e1) * t37
  t39 = jnp.pi ** 2
  t40 = t39 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t43 = t14 + t25
  t45 = t42 / t43
  t47 = 0.5e1 / 0.9e1 * t38 * t45
  t48 = t47 <= 0.1e1
  t49 = jnp.log(DBL_EPSILON)
  t52 = t49 / (-t49 + 0.1131e1)
  t53 = -t52 < t47
  t54 = t47 < -t52
  t55 = r0 ** 2
  t58 = tau0 / t2 / t55
  t61 = 0.1e1 / t29
  t62 = t6 * t61
  t63 = t8 - t62
  t64 = t63 / 0.2e1
  t65 = t13 * t64
  t68 = -t64
  t69 = t24 * t68
  t72 = t29 * t7
  t74 = 0.1e1 / t31 / t72
  t75 = t28 * t74
  t76 = t75 / 0.3e1
  t78 = (-0.5e1 / 0.3e1 * t58 * t14 + 0.5e1 / 0.3e1 * t5 * t65 + 0.5e1 / 0.3e1 * t20 * t69 + t76) * t37
  t80 = t43 ** 2
  t82 = t42 / t80
  t84 = 0.5e1 / 0.3e1 * t65 + 0.5e1 / 0.3e1 * t69
  t85 = t82 * t84
  t88 = -0.5e1 / 0.9e1 * t38 * t85 + 0.5e1 / 0.9e1 * t78 * t45
  t89 = f.my_piecewise3(t54, t88, 0)
  t90 = f.my_piecewise3(t54, t47, -t52)
  t91 = 0.1e1 - t90
  t92 = 0.1e1 / t91
  t95 = t91 ** 2
  t96 = 0.1e1 / t95
  t97 = t90 * t96
  t100 = -0.1131e1 * t89 * t92 - 0.1131e1 * t97 * t89
  t103 = jnp.exp(-0.1131e1 * t90 * t92)
  t105 = f.my_piecewise3(t53, 0, t100 * t103)
  t107 = jnp.log(0.72992700729927007299270072992700729927007299270073e0 * DBL_EPSILON)
  t110 = (-t107 + 0.17e1) / t107
  t111 = t47 < -t110
  t112 = f.my_piecewise3(t111, -t110, t47)
  t113 = 0.1e1 - t112
  t114 = t113 ** 2
  t115 = 0.1e1 / t114
  t116 = f.my_piecewise3(t111, 0, t88)
  t120 = jnp.exp(0.17e1 / t113)
  t123 = f.my_piecewise3(t111, 0, -0.2329e1 * t115 * t116 * t120)
  t124 = f.my_piecewise3(t48, t105, t123)
  t125 = 3 ** (0.1e1 / 0.3e1)
  t127 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t128 = t125 * t127
  t129 = 4 ** (0.1e1 / 0.3e1)
  t130 = t129 ** 2
  t133 = t128 * t130 / t30
  t134 = jnp.sqrt(t133)
  t137 = 0.1e1 + 0.33115000000000000000000000000000000000000000000000e-1 * t134 + 0.41680000000000000000000000000000000000000000000000e-1 * t133
  t138 = 0.1e1 / t137
  t141 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t138)
  t142 = t141 - 0.1e1
  t144 = 2 ** (0.1e1 / 0.3e1)
  t145 = t144 ** 2
  t146 = t145 * t28
  t150 = 0.1e1 + 0.42675284208752716666666666666666666666666666666666e-1 * t37 * t42 * t146 * t33
  t151 = t150 ** (0.1e1 / 0.4e1)
  t154 = t37 ** 2
  t156 = 0.1e1 / t40 / t39
  t158 = t28 ** 2
  t159 = t144 * t158
  t160 = t29 ** 2
  t161 = t160 * t7
  t167 = 0.1e1 + 0.45529497057445474565519084559506944444444444444445e-2 * t154 * t156 * t159 / t30 / t161
  t168 = t167 ** (0.1e1 / 0.8e1)
  t171 = 0.1e1 - 0.1e1 / t151 / 0.2e1 - 0.1e1 / t168 / 0.2e1
  t173 = t142 * t171 + 0.1e1
  t174 = jnp.log(t173)
  t176 = -0.30197e-1 * t138 + 0.30197e-1 * t174
  t177 = t144 - 0.1e1
  t178 = t10 <= f.p.zeta_threshold
  t179 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t180 = t179 * f.p.zeta_threshold
  t181 = t10 ** (0.1e1 / 0.3e1)
  t182 = t181 * t10
  t183 = f.my_piecewise3(t178, t180, t182)
  t184 = t21 <= f.p.zeta_threshold
  t185 = t21 ** (0.1e1 / 0.3e1)
  t186 = t185 * t21
  t187 = f.my_piecewise3(t184, t180, t186)
  t188 = t183 + t187 - 0.2e1
  t191 = 0.1e1 / t177 / 0.2e1
  t194 = 0.1e1 - 0.2363e1 * t177 * t188 * t191
  t195 = t176 * t194
  t196 = t6 ** 2
  t197 = t196 ** 2
  t198 = t197 ** 2
  t199 = t198 * t197
  t200 = t160 ** 2
  t201 = t200 * t160
  t202 = 0.1e1 / t201
  t204 = -t199 * t202 + 0.1e1
  t207 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t133
  t210 = t133 ** 0.15e1
  t212 = t125 ** 2
  t213 = t127 ** 2
  t214 = t212 * t213
  t217 = t214 * t129 / t31
  t219 = 0.37978500000000000000000000000000000000000000000000e1 * t134 + 0.89690000000000000000000000000000000000000000000000e0 * t133 + 0.20477500000000000000000000000000000000000000000000e0 * t210 + 0.12323500000000000000000000000000000000000000000000e0 * t217
  t222 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t219
  t223 = jnp.log(t222)
  t225 = 0.621814e-1 * t207 * t223
  t226 = 0.1e1 / t160
  t227 = t197 * t226
  t228 = t188 * t191
  t230 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t133
  t235 = 0.70594500000000000000000000000000000000000000000000e1 * t134 + 0.15494250000000000000000000000000000000000000000000e1 * t133 + 0.42077500000000000000000000000000000000000000000000e0 * t210 + 0.15629250000000000000000000000000000000000000000000e0 * t217
  t238 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t235
  t239 = jnp.log(t238)
  t243 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t133
  t248 = 0.51785000000000000000000000000000000000000000000000e1 * t134 + 0.90577500000000000000000000000000000000000000000000e0 * t133 + 0.11003250000000000000000000000000000000000000000000e0 * t210 + 0.12417750000000000000000000000000000000000000000000e0 * t217
  t251 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t248
  t252 = jnp.log(t251)
  t253 = t243 * t252
  t255 = -0.3109070e-1 * t230 * t239 + t225 - 0.19751673498613801407483339618206552048944131217655e-1 * t253
  t256 = t228 * t255
  t257 = t227 * t256
  t259 = 0.19751673498613801407483339618206552048944131217655e-1 * t228 * t253
  t260 = jnp.log(0.2e1)
  t261 = 0.1e1 - t260
  t263 = t261 / t39
  t264 = t179 ** 2
  t265 = t181 ** 2
  t266 = f.my_piecewise3(t178, t264, t265)
  t267 = t185 ** 2
  t268 = f.my_piecewise3(t184, t264, t267)
  t270 = t266 / 0.2e1 + t268 / 0.2e1
  t271 = t270 ** 2
  t272 = t271 * t270
  t274 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t133
  t276 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t133
  t277 = 0.1e1 / t276
  t279 = 0.1e1 / t261
  t280 = t274 * t277 * t279
  t282 = (-t225 + t257 + t259) * t279
  t283 = 0.1e1 / t272
  t284 = t39 * t283
  t286 = jnp.exp(-t282 * t284)
  t287 = t286 - 0.1e1
  t288 = 0.1e1 / t287
  t289 = t39 * t288
  t290 = t289 * t28
  t291 = t280 * t290
  t293 = 0.1e1 / t30 / t29
  t294 = t293 * t144
  t295 = 0.1e1 / t271
  t297 = 0.1e1 / t127
  t298 = t212 * t297
  t299 = t298 * t129
  t303 = 0.1e1 + 0.55603792169291016666666666666666666666666666666666e-2 * t291 * t294 * t295 * t299
  t304 = t303 ** (0.1e1 / 0.4e1)
  t307 = t274 ** 2
  t308 = t276 ** 2
  t309 = 0.1e1 / t308
  t311 = t261 ** 2
  t312 = 0.1e1 / t311
  t313 = t307 * t309 * t312
  t314 = t39 ** 2
  t315 = t287 ** 2
  t316 = 0.1e1 / t315
  t317 = t314 * t316
  t318 = t317 * t158
  t319 = t313 * t318
  t321 = 0.1e1 / t31 / t160
  t322 = t321 * t145
  t323 = t271 ** 2
  t324 = 0.1e1 / t323
  t326 = 0.1e1 / t213
  t327 = t125 * t326
  t328 = t327 * t130
  t332 = 0.1e1 + 0.11594181388521408693986931215126041666666666666666e-3 * t319 * t322 * t324 * t328
  t333 = t332 ** (0.1e1 / 0.8e1)
  t336 = 0.1e1 - 0.1e1 / t304 / 0.2e1 - 0.1e1 / t333 / 0.2e1
  t339 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t287
  t340 = jnp.log(t339)
  t343 = -t263 * t272 * t340 + t195 * t204 + t225 - t257 - t259
  t344 = t124 * t343
  t348 = f.my_piecewise3(t178, 0, 0.4e1 / 0.3e1 * t181 * t63)
  t349 = -t63
  t352 = f.my_piecewise3(t184, 0, 0.4e1 / 0.3e1 * t185 * t349)
  t354 = (t348 + t352) * t191
  t355 = t354 * t253
  t357 = t219 ** 2
  t358 = 0.1e1 / t357
  t359 = t207 * t358
  t361 = 0.1e1 / t134 * t125
  t362 = t127 * t130
  t364 = 0.1e1 / t30 / t7
  t365 = t362 * t364
  t366 = t361 * t365
  t368 = t130 * t364
  t369 = t128 * t368
  t371 = t133 ** 0.5e0
  t372 = t371 * t125
  t373 = t372 * t365
  t378 = t214 * t129 / t31 / t7
  t380 = -0.63297500000000000000000000000000000000000000000000e0 * t366 - 0.29896666666666666666666666666666666666666666666667e0 * t369 - 0.10238750000000000000000000000000000000000000000000e0 * t373 - 0.82156666666666666666666666666666666666666666666667e-1 * t378
  t381 = 0.1e1 / t222
  t382 = t380 * t381
  t383 = t359 * t382
  t384 = 0.20000000000000000000000000000000000000000000000000e1 * t383
  t385 = t271 * t340
  t386 = 0.1e1 / t181
  t389 = f.my_piecewise3(t178, 0, 0.2e1 / 0.3e1 * t386 * t63)
  t390 = 0.1e1 / t185
  t393 = f.my_piecewise3(t184, 0, 0.2e1 / 0.3e1 * t390 * t349)
  t395 = t389 / 0.2e1 + t393 / 0.2e1
  t397 = t263 * t385 * t395
  t402 = t235 ** 2
  t403 = 0.1e1 / t402
  t404 = t230 * t403
  t409 = -0.11765750000000000000000000000000000000000000000000e1 * t366 - 0.51647500000000000000000000000000000000000000000000e0 * t369 - 0.21038750000000000000000000000000000000000000000000e0 * t373 - 0.10419500000000000000000000000000000000000000000000e0 * t378
  t410 = 0.1e1 / t238
  t411 = t409 * t410
  t415 = t128 * t368 * t223
  t416 = 0.11073470983333333333333333333333333333333333333333e-2 * t415
  t417 = 0.10000000000000000000000000000000000000000000000000e1 * t383
  t421 = t248 ** 2
  t422 = 0.1e1 / t421
  t423 = t243 * t422
  t428 = -0.86308333333333333333333333333333333333333333333334e0 * t366 - 0.30192500000000000000000000000000000000000000000000e0 * t369 - 0.55016250000000000000000000000000000000000000000000e-1 * t373 - 0.82785000000000000000000000000000000000000000000000e-1 * t378
  t429 = 0.1e1 / t251
  t430 = t428 * t429
  t433 = 0.53237641966666666666666666666666666666666666666666e-3 * t128 * t368 * t239 + 0.10000000000000000000000000000000000000000000000000e1 * t404 * t411 - t416 - t417 + 0.18311447306006545054854346104378990962041954983034e-3 * t128 * t368 * t252 + 0.58482236226346462072622386637590534819724553404280e0 * t423 * t430
  t434 = t228 * t433
  t435 = t227 * t434
  t436 = 0.2e1 * t435
  t437 = t354 * t255
  t438 = t227 * t437
  t441 = 0.1e1 / t304 / t303
  t442 = t74 * t277
  t443 = t279 * t39
  t444 = t442 * t443
  t445 = t288 * t28
  t446 = t144 * t295
  t447 = t445 * t446
  t449 = 0.55603792169291016666666666666666666666666666666666e-3 * t444 * t447
  t450 = t274 * t309
  t451 = t450 * t443
  t456 = 0.98863542476999427633333333333333333333333333333332e-3 * t451 * t445 * t74 * t144 * t295
  t457 = t39 * t316
  t458 = t28 * t293
  t460 = t280 * t457 * t458
  t461 = t446 * t212
  t462 = t297 * t129
  t463 = t196 * t6
  t464 = t463 * t226
  t465 = t464 * t256
  t466 = 0.4e1 * t465
  t467 = 0.1e1 / t161
  t468 = t197 * t467
  t469 = t468 * t256
  t470 = 0.4e1 * t469
  t471 = 0.19751673498613801407483339618206552048944131217655e-1 * t355
  t472 = t228 * t125
  t474 = t362 * t364 * t252
  t475 = t472 * t474
  t476 = 0.18311447306006545054854346104378990962041954983034e-3 * t475
  t477 = t228 * t243
  t479 = t422 * t428 * t429
  t480 = t477 * t479
  t481 = 0.58482236226346462072622386637590534819724553404280e0 * t480
  t483 = (t416 + t417 + t466 - t470 + t438 + t435 + t471 - t476 - t481) * t279
  t485 = t39 * t324
  t486 = t485 * t395
  t489 = 0.3e1 * t282 * t486 - t483 * t284
  t490 = t489 * t286
  t491 = t462 * t490
  t492 = t461 * t491
  t496 = 0.1e1 / t30 / t72
  t497 = t496 * t144
  t501 = 0.12974218172834570555555555555555555555555555555555e-1 * t291 * t497 * t295 * t299
  t502 = t294 * t283
  t504 = t298 * t129 * t395
  t508 = -t449 + t456 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t492 - t501 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t504
  t512 = 0.1e1 / t333 / t332
  t513 = t450 * t312
  t514 = t513 * t318
  t515 = t160 * t29
  t516 = 0.1e1 / t515
  t517 = t516 * t145
  t519 = t517 * t324 * t299
  t521 = 0.77294542590142724626579541434173611111111111111106e-5 * t514 * t519
  t523 = 0.1e1 / t308 / t276
  t525 = t307 * t523 * t312
  t526 = t525 * t318
  t528 = 0.13742969672527376438605842466996068055555555555556e-4 * t526 * t519
  t530 = 0.1e1 / t315 / t287
  t531 = t314 * t530
  t532 = t158 * t321
  t534 = t313 * t531 * t532
  t535 = t145 * t324
  t536 = t535 * t125
  t537 = t326 * t130
  t539 = t536 * t537 * t490
  t543 = 0.1e1 / t31 / t161
  t544 = t543 * t145
  t548 = 0.54106179813099907238605679003921527777777777777775e-3 * t319 * t544 * t324 * t328
  t550 = 0.1e1 / t323 / t270
  t551 = t322 * t550
  t553 = t327 * t130 * t395
  t557 = -t521 + t528 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t539 - t548 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t553
  t560 = t441 * t508 / 0.8e1 + t512 * t557 / 0.16e2
  t566 = 0.10000000000000000000000000000000000000000000000000e1 * t560 * t287 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t489 * t286
  t568 = 0.1e1 / t339
  t570 = t263 * t272 * t566 * t568
  t572 = 0.8e1 * t465
  t573 = 0.8e1 * t469
  t574 = 0.22146941966666666666666666666666666666666666666666e-2 * t415
  t575 = 0.36622894612013090109708692208757981924083909966068e-3 * t475
  t576 = 0.11696447245269292414524477327518106963944910680856e1 * t480
  t577 = f.my_piecewise3(t53, 0, t103)
  t579 = f.my_piecewise3(t111, 0, -0.137e1 * t120)
  t580 = f.my_piecewise3(t48, t577, t579)
  t581 = t137 ** 2
  t582 = 0.1e1 / t581
  t585 = -0.55191666666666666666666666666666666666666666666667e-2 * t366 - 0.13893333333333333333333333333333333333333333333333e-1 * t369
  t586 = t582 * t585
  t588 = t141 * t171
  t594 = 0.1e1 / t151 / t150 * t37 * t42
  t601 = 0.1e1 / t168 / t167 * t154 * t156
  t607 = -0.14225094736250905555555555555555555555555555555555e-1 * t594 * t146 * t74 - 0.15176499019148491521839694853168981481481481481482e-2 * t601 * t159 / t30 / t515
  t609 = -0.10000000000000000000000000000000000000000000000000e1 * t586 * t588 + t142 * t607
  t610 = 0.1e1 / t173
  t613 = 0.30197e-1 * t586 + 0.30197e-1 * t609 * t610
  t614 = t613 * t194
  t615 = t614 * t204
  t616 = t176 * t177
  t617 = t354 * t204
  t620 = t198 * t463
  t621 = t620 * t202
  t623 = 0.1e1 / t200 / t161
  t624 = t199 * t623
  t626 = -0.12e2 * t621 + 0.12e2 * t624
  t628 = 0.3e1 * t397
  t629 = t615 - 0.2363e1 * t616 * t617 + t195 * t626 - t416 - t417 - t466 + t470 - t438 - t435 - t471 + t476 + t481 - t628 - t570
  t630 = t580 * t629
  t632 = t263 * t271
  t633 = t566 * t568
  t636 = 0.6e1 * t632 * t633 * t395
  t638 = t354 * t125 * t474
  t639 = 0.36622894612013090109708692208757981924083909966068e-3 * t638
  t640 = t128 * t130
  t644 = 0.35616666666666666666666666666666666666666666666666e-1 * t640 * t364 * t358 * t382
  t648 = 0.24415263074675393406472461472505321282722606644045e-3 * t472 * t362 * t293 * t252
  t650 = t227 * t354 * t433
  t651 = 0.2e1 * t650
  t652 = t468 * t437
  t653 = 0.8e1 * t652
  t654 = t130 * t293
  t657 = 0.14764627977777777777777777777777777777777777777777e-2 * t128 * t654 * t223
  t661 = 0.10843581300301739842632067522386578331157260943710e-1 * t228 * t128 * t368 * t479
  t663 = 0.1e1 / t421 / t248
  t664 = t428 ** 2
  t668 = 0.11696447245269292414524477327518106963944910680856e1 * t477 * t663 * t664 * t429
  t669 = t421 ** 2
  t670 = 0.1e1 / t669
  t672 = t251 ** 2
  t673 = 0.1e1 / t672
  t676 = 0.17315859105681463759666483083807725165579399831905e2 * t477 * t670 * t664 * t673
  t678 = t354 * t243 * t479
  t679 = 0.11696447245269292414524477327518106963944910680856e1 * t678
  t684 = t213 * t129 * t33
  t685 = 0.1e1 / t134 / t133 * t212 * t684
  t687 = t362 * t293
  t688 = t361 * t687
  t690 = t128 * t654
  t692 = t133 ** (-0.5e0)
  t694 = t692 * t212 * t684
  t696 = t372 * t687
  t699 = t214 * t129 * t33
  t701 = -0.57538888888888888888888888888888888888888888888889e0 * t685 + 0.11507777777777777777777777777777777777777777777778e1 * t688 + 0.40256666666666666666666666666666666666666666666667e0 * t690 + 0.36677500000000000000000000000000000000000000000000e-1 * t694 + 0.73355000000000000000000000000000000000000000000000e-1 * t696 + 0.13797500000000000000000000000000000000000000000000e0 * t699
  t705 = 0.58482236226346462072622386637590534819724553404280e0 * t477 * t422 * t701 * t429
  t706 = t270 * t340
  t707 = t395 ** 2
  t710 = 0.6e1 * t263 * t706 * t707
  t711 = 0.1e1 / t265
  t712 = t63 ** 2
  t715 = 0.1e1 / t72
  t716 = t6 * t715
  t717 = -t61 + t716
  t718 = 0.2e1 * t717
  t722 = f.my_piecewise3(t178, 0, 0.4e1 / 0.9e1 * t711 * t712 + 0.4e1 / 0.3e1 * t181 * t718)
  t723 = 0.1e1 / t267
  t724 = t349 ** 2
  t727 = -t718
  t731 = f.my_piecewise3(t184, 0, 0.4e1 / 0.9e1 * t723 * t724 + 0.4e1 / 0.3e1 * t185 * t727)
  t733 = (t722 + t731) * t191
  t735 = 0.19751673498613801407483339618206552048944131217655e-1 * t733 * t253
  t736 = t566 ** 2
  t738 = t339 ** 2
  t739 = 0.1e1 / t738
  t741 = t263 * t272 * t736 * t739
  t742 = t636 - t639 - t644 + t648 + t651 - t653 - t657 + t661 + t668 - t676 - t679 - t705 + t710 + t735 - t741
  t744 = t227 * t733 * t255
  t753 = 0.1e1 / t12
  t754 = t64 ** 2
  t755 = t753 * t754
  t758 = t13 * t717
  t761 = 0.1e1 / t23
  t762 = t68 ** 2
  t763 = t761 * t762
  t767 = -t24 * t717
  t771 = 0.11e2 / 0.9e1 * t28 * t321
  t779 = 0.1e1 / t80 / t43
  t780 = t42 * t779
  t781 = t84 ** 2
  t793 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 / t2 / t55 / r0 * t14 - 0.50e2 / 0.9e1 * t58 * t65 + 0.10e2 / 0.9e1 * t5 * t755 + 0.5e1 / 0.3e1 * t5 * t758 + 0.10e2 / 0.9e1 * t20 * t763 + 0.5e1 / 0.3e1 * t20 * t767 - t771) * t37 * t45 - 0.10e2 / 0.9e1 * t78 * t85 + 0.10e2 / 0.9e1 * t38 * t780 * t781 - 0.5e1 / 0.9e1 * t38 * t82 * (0.10e2 / 0.9e1 * t755 + 0.5e1 / 0.3e1 * t758 + 0.10e2 / 0.9e1 * t763 + 0.5e1 / 0.3e1 * t767)
  t794 = f.my_piecewise3(t54, t793, 0)
  t797 = t89 ** 2
  t802 = t90 / t95 / t91
  t809 = t100 ** 2
  t812 = f.my_piecewise3(t53, 0, (-0.1131e1 * t794 * t92 - 0.2262e1 * t797 * t96 - 0.2262e1 * t802 * t797 - 0.1131e1 * t97 * t794) * t103 + t809 * t103)
  t814 = 0.1e1 / t114 / t113
  t815 = t116 ** 2
  t819 = f.my_piecewise3(t111, 0, t793)
  t823 = t114 ** 2
  t824 = 0.1e1 / t823
  t829 = f.my_piecewise3(t111, 0, -0.4658e1 * t814 * t815 * t120 - 0.2329e1 * t115 * t819 * t120 - 0.39593e1 * t824 * t815 * t120)
  t830 = f.my_piecewise3(t48, t812, t829)
  t834 = 0.1e1 / t182
  t840 = f.my_piecewise3(t178, 0, -0.2e1 / 0.9e1 * t834 * t712 + 0.2e1 / 0.3e1 * t386 * t718)
  t841 = 0.1e1 / t186
  t847 = f.my_piecewise3(t184, 0, -0.2e1 / 0.9e1 * t841 * t724 + 0.2e1 / 0.3e1 * t390 * t727)
  t849 = t840 / 0.2e1 + t847 / 0.2e1
  t852 = 0.3e1 * t263 * t385 * t849
  t853 = t303 ** 2
  t855 = 0.1e1 / t304 / t853
  t856 = t508 ** 2
  t862 = 0.33362275301574609999999999999999999999999999999999e-2 * t321 * t277 * t443 * t447
  t863 = t144 * t283
  t864 = t863 * t395
  t866 = t444 * t445 * t864
  t868 = t489 ** 2
  t869 = t868 * t286
  t874 = t274 * t523
  t881 = 0.29296563087350830388677777777777777777777777777778e-4 * t874 * t279 * t290 * t467 * t144 * t295 * t640
  t882 = t443 * t316
  t883 = t442 * t882
  t884 = t28 * t144
  t886 = t295 * t489 * t286
  t888 = t883 * t884 * t886
  t894 = 0.59318125486199656579999999999999999999999999999999e-2 * t451 * t445 * t321 * t144 * t295
  t895 = t443 * t288
  t896 = t450 * t895
  t898 = t896 * t75 * t864
  t906 = 0.43247393909448568518518518518518518518518518518517e-1 * t291 / t30 / t160 * t144 * t295 * t299
  t907 = t497 * t283
  t909 = t291 * t907 * t504
  t921 = 0.16477257079499904605555555555555555555555555555556e-4 * t467 * t309 * t895 * t884 * t295 * t640
  t922 = t450 * t882
  t923 = t75 * t144
  t925 = t922 * t923 * t886
  t927 = t863 * t298
  t929 = t286 * t395
  t936 = t280 * t457 * t28 * t496
  t937 = t936 * t492
  t941 = t280 * t39 * t530 * t458
  t942 = t286 ** 2
  t943 = t868 * t942
  t950 = 0.20e2 * t197 * t516 * t256
  t953 = 0.12e2 * t196 * t226 * t256
  t956 = 0.32e2 * t463 * t467 * t256
  t966 = 0.10000000000000000000000000000000000000000000000000e1 * t359 * (-0.42198333333333333333333333333333333333333333333333e0 * t685 + 0.84396666666666666666666666666666666666666666666666e0 * t688 + 0.39862222222222222222222222222222222222222222222223e0 * t690 + 0.68258333333333333333333333333333333333333333333333e-1 * t694 + 0.13651666666666666666666666666666666666666666666667e0 * t696 + 0.13692777777777777777777777777777777777777777777778e0 * t699) * t381
  t967 = t357 ** 2
  t970 = t380 ** 2
  t971 = t222 ** 2
  t975 = 0.16081979498692535066756296899072713062105388428051e2 * t207 / t967 * t970 / t971
  t986 = t409 ** 2
  t1000 = t402 ** 2
  t1003 = t238 ** 2
  t1013 = 0.20000000000000000000000000000000000000000000000000e1 * t207 / t357 / t219 * t970 * t381
  t1032 = -0.70983522622222222222222222222222222222222222222221e-3 * t128 * t654 * t239 - 0.34246666666666666666666666666666666666666666666666e-1 * t640 * t364 * t403 * t411 - 0.20000000000000000000000000000000000000000000000000e1 * t230 / t402 / t235 * t986 * t410 + 0.10000000000000000000000000000000000000000000000000e1 * t404 * (-0.78438333333333333333333333333333333333333333333333e0 * t685 + 0.15687666666666666666666666666666666666666666666667e1 * t688 + 0.68863333333333333333333333333333333333333333333333e0 * t690 + 0.14025833333333333333333333333333333333333333333333e0 * t694 + 0.28051666666666666666666666666666666666666666666667e0 * t696 + 0.17365833333333333333333333333333333333333333333333e0 * t699) * t410 + 0.32163958997385070133512593798145426124210776856102e2 * t230 / t1000 * t986 / t1003 + t657 + t644 + t1013 - t966 - t975 - 0.24415263074675393406472461472505321282722606644045e-3 * t128 * t654 * t252 - 0.10843581300301739842632067522386578331157260943710e-1 * t640 * t364 * t422 * t430 - 0.11696447245269292414524477327518106963944910680856e1 * t243 * t663 * t664 * t429 + 0.58482236226346462072622386637590534819724553404280e0 * t423 * t701 * t429 + 0.17315859105681463759666483083807725165579399831905e2 * t243 * t670 * t664 * t673
  t1034 = t227 * t228 * t1032
  t1035 = t950 + t953 - t956 - t657 + t735 + t966 + t975 - t639 + t668 - t644 + t1034
  t1037 = 0.8e1 * t468 * t434
  t1038 = t464 * t437
  t1039 = 0.8e1 * t1038
  t1041 = 0.8e1 * t464 * t434
  t1042 = t744 + t651 - t653 - t1037 + t1039 + t1041 - t1013 + t661 - t676 - t679 - t705 + t648
  t1048 = t39 * t550
  t1055 = -(t1035 + t1042) * t279 * t284 + 0.6e1 * t483 * t486 - 0.12e2 * t282 * t1048 * t707 + 0.3e1 * t282 * t485 * t849
  t1056 = t1055 * t286
  t1061 = t294 * t324
  t1067 = t862 + 0.22241516867716406666666666666666666666666666666666e-2 * t866 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t869 + t881 + 0.11120758433858203333333333333333333333333333333333e-2 * t888 - t894 - 0.39545416990799771053333333333333333333333333333332e-2 * t898 + t906 + 0.51896872691338282222222222222222222222222222222220e-1 * t909 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t298 * t129 * t849 - t921 - 0.19772708495399885526666666666666666666666666666666e-2 * t925 + 0.22241516867716406666666666666666666666666666666666e-1 * t460 * t927 * t129 * t489 * t929 + 0.25948436345669141111111111111111111111111111111110e-1 * t937 + 0.11120758433858203333333333333333333333333333333333e-1 * t941 * t461 * t462 * t943 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t1056 + 0.33362275301574609999999999999999999999999999999999e-1 * t291 * t1061 * t298 * t129 * t707
  t1070 = t332 ** 2
  t1072 = 0.1e1 / t333 / t1070
  t1073 = t557 ** 2
  t1080 = t312 * t314
  t1082 = t316 * t158
  t1083 = t160 * t72
  t1085 = 0.1e1 / t30 / t1083
  t1088 = t1082 * t1085 * t145 * t324
  t1090 = 0.54971878690109505754423369867984272222222222222221e-5 * t874 * t1080 * t1088
  t1091 = t308 ** 2
  t1096 = 0.73305000233261025923523563718957027008333333333336e-5 * t307 / t1091 * t1080 * t1088
  t1099 = t313 * t531 * t158 * t543
  t1100 = t1099 * t539
  t1103 = t145 * t550 * t327
  t1115 = 0.30660168560756614101876551435555532407407407407406e-2 * t319 / t31 / t515 * t145 * t324 * t328
  t1116 = t544 * t550
  t1118 = t319 * t1116 * t553
  t1128 = 0.1e1 / t1083 * t145 * t324 * t299
  t1130 = 0.14659167650695868201179565298129139259259259259260e-3 * t526 * t1128
  t1131 = t517 * t550
  t1132 = t1131 * t504
  t1133 = t526 * t1132
  t1136 = 0.82447512096152239601684844196451851851851851851847e-4 * t514 * t1128
  t1137 = t514 * t1132
  t1139 = t315 ** 2
  t1143 = t313 * t314 / t1139 * t532
  t1149 = t531 * t158 * t516
  t1150 = t513 * t1149
  t1151 = t535 * t212
  t1152 = t1151 * t491
  t1153 = t1150 * t1152
  t1155 = t525 * t1149
  t1156 = t1155 * t1152
  t1163 = 0.1e1 / t323 / t271
  t1164 = t322 * t1163
  t1174 = 0.77294542590142724626579541434173611111111111111106e-6 * t1085 * t309 * t1080 * t1082 * t535
  t1175 = -0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t869 - t1090 + t1096 + 0.21642471925239962895442271601568611111111111111110e-2 * t1100 + 0.18550690221634253910379089944201666666666666666666e-2 * t534 * t1103 * t130 * t489 * t929 + t1115 + 0.43284943850479925790884543203137222222222222222220e-2 * t1118 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t327 * t130 * t849 - t1130 - 0.10994375738021901150884673973596854444444444444445e-3 * t1133 + t1136 + 0.61835634072114179701263633147338888888888888888884e-4 * t1137 + 0.69565088331128452163921587290756249999999999999996e-3 * t1143 * t536 * t537 * t943 + 0.30917817036057089850631816573669444444444444444442e-4 * t1153 - 0.54971878690109505754423369867984272222222222222223e-4 * t1156 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t1056 + 0.23188362777042817387973862430252083333333333333332e-2 * t319 * t1164 * t327 * t130 * t707 + t1174
  t1193 = t263 * t272 * (0.10000000000000000000000000000000000000000000000000e1 * (-0.5e1 / 0.32e2 * t855 * t856 + t441 * t1067 / 0.8e1 - 0.9e1 / 0.128e3 * t1072 * t1073 + t512 * t1175 / 0.16e2) * t287 + 0.20000000000000000000000000000000000000000000000000e1 * t560 * t489 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t1055 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t868 * t286) * t568
  t1194 = t613 * t177
  t1195 = t1194 * t617
  t1197 = -t636 + t639 + t644 - t648 - t651 + t653 + t657 - t661 - t668 + t676 + t679 + t705 - t710 - t735 + t741 - t744 - 0.4726e1 * t1195
  t1206 = t585 ** 2
  t1207 = 0.1e1 / t581 / t137 * t1206
  t1213 = t582 * (-0.36794444444444444444444444444444444444444444444445e-2 * t685 + 0.73588888888888888888888888888888888888888888888889e-2 * t688 + 0.18524444444444444444444444444444444444444444444444e-1 * t690)
  t1219 = t581 ** 2
  t1227 = t150 ** 2
  t1232 = t159 * t1085
  t1238 = t167 ** 2
  t1245 = t158 ** 2
  t1259 = t609 ** 2
  t1260 = t173 ** 2
  t1266 = (-0.60394e-1 * t1207 + 0.30197e-1 * t1213 + 0.30197e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t1207 * t588 - 0.10000000000000000000000000000000000000000000000000e1 * t1213 * t588 + 0.10000000000000000000000000000000000000000000000000e1 / t1219 * t1206 * t588 - 0.20000000000000000000000000000000000000000000000000e1 * t586 * t141 * t607 + t142 * (-0.40470664051062644058239186275117283950617283950614e-2 / t151 / t1227 * t154 * t156 * t1232 + 0.52158680699586653703703703703703703703703703703702e-1 * t594 * t146 * t321 - 0.24875221227647233525064849710168026648849003129942e-3 / t168 / t1238 * t37 / t41 / t314 * t145 * t1245 / t31 / t201 + 0.96117827121273779638318067403403549382716049382719e-2 * t601 * t1232)) * t610 - 0.30197e-1 * t1259 / t1260) * t194 * t204
  t1269 = 0.132e3 * t198 * t196 * t202
  t1271 = 0.288e3 * t620 * t623
  t1275 = 0.156e3 * t199 / t200 / t515
  t1278 = t614 * t626
  t1280 = -0.2363e1 * t616 * t733 * t204 - 0.4726e1 * t616 * t354 * t626 - t852 - t1193 + t1013 - t966 - t975 - t1041 - t950 - t953 + t956 - t1034 + t1037 - t1039 + t1266 + t195 * (-t1269 + t1271 - t1275) + 0.2e1 * t1278
  t1283 = t744 + t830 * t343 + 0.2e1 * t124 * t629 + t852 + t1193 + t580 * (t1197 + t1280) - t1013 + t966 + t975 + t1041 + t950 + t953 - t956 + t1034 - t1037 + t1039
  d11 = 0.2e1 * t344 + 0.39503346997227602814966679236413104097888262435310e-1 * t355 + t384 + 0.6e1 * t397 + t436 + 0.2e1 * t438 + 0.2e1 * t570 + t572 - t573 + t574 - t575 - t576 + 0.2e1 * t630 + t7 * (t742 + t1283)
  t1286 = -t8 - t62
  t1289 = f.my_piecewise3(t178, 0, 0.4e1 / 0.3e1 * t181 * t1286)
  t1290 = -t1286
  t1293 = f.my_piecewise3(t184, 0, 0.4e1 / 0.3e1 * t185 * t1290)
  t1295 = (t1289 + t1293) * t191
  t1297 = t1295 * t243 * t479
  t1298 = 0.58482236226346462072622386637590534819724553404280e0 * t1297
  t1300 = t1295 * t125 * t474
  t1301 = 0.18311447306006545054854346104378990962041954983034e-3 * t1300
  t1302 = 0.18311447306006545054854346104378990962041954983034e-3 * t638
  t1303 = 0.4e1 * t652
  t1305 = 0.12e2 * t621 + 0.12e2 * t624
  t1309 = 0.58482236226346462072622386637590534819724553404280e0 * t678
  t1311 = t1295 * t255
  t1312 = t227 * t1311
  t1313 = t1295 * t253
  t1314 = 0.19751673498613801407483339618206552048944131217655e-1 * t1313
  t1316 = (t416 + t417 - t466 - t470 + t1312 + t435 + t1314 - t476 - t481) * t279
  t1320 = f.my_piecewise3(t178, 0, 0.2e1 / 0.3e1 * t386 * t1286)
  t1323 = f.my_piecewise3(t184, 0, 0.2e1 / 0.3e1 * t390 * t1290)
  t1325 = t1320 / 0.2e1 + t1323 / 0.2e1
  t1326 = t485 * t1325
  t1329 = -t1316 * t284 + 0.3e1 * t282 * t1326
  t1330 = t1329 * t286
  t1331 = t462 * t1330
  t1332 = t461 * t1331
  t1335 = t129 * t1325
  t1336 = t298 * t1335
  t1340 = -t449 + t456 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t1332 - t501 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t1336
  t1344 = t536 * t537 * t1330
  t1347 = t130 * t1325
  t1348 = t327 * t1347
  t1352 = -t521 + t528 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t1344 - t548 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t1348
  t1355 = t441 * t1340 / 0.8e1 + t512 * t1352 / 0.16e2
  t1358 = t336 * t1329
  t1361 = 0.10000000000000000000000000000000000000000000000000e1 * t1355 * t287 + 0.10000000000000000000000000000000000000000000000000e1 * t1358 * t286
  t1364 = t263 * t272 * t1361 * t739 * t566
  t1369 = 0.6e1 * t263 * t270 * t340 * t1325 * t395
  t1370 = t464 * t1311
  t1371 = 0.4e1 * t1370
  t1372 = t468 * t1311
  t1373 = 0.4e1 * t1372
  t1381 = f.my_piecewise3(t178, 0, 0.4e1 / 0.9e1 * t711 * t1286 * t63 + 0.8e1 / 0.3e1 * t181 * t6 * t715)
  t1389 = f.my_piecewise3(t184, 0, 0.4e1 / 0.9e1 * t723 * t1290 * t349 - 0.8e1 / 0.3e1 * t185 * t6 * t715)
  t1391 = (t1381 + t1389) * t191
  t1393 = 0.19751673498613801407483339618206552048944131217655e-1 * t1391 * t253
  t1395 = t227 * t1391 * t255
  t1396 = t1298 + t1301 + t1302 + t644 - t648 - 0.2363e1 * t616 * t354 * t1305 - t650 + t1303 + t657 - t661 - t668 + t676 + t1309 + t705 + t1364 - t1369 - t1371 + t1373 - t1393 - t1395
  t1398 = t227 * t1295 * t433
  t1402 = 0.3e1 * t632 * t633 * t1325
  t1410 = f.my_piecewise3(t178, 0, -0.2e1 / 0.9e1 * t834 * t1286 * t63 + 0.4e1 / 0.3e1 * t386 * t6 * t715)
  t1418 = f.my_piecewise3(t184, 0, -0.2e1 / 0.9e1 * t841 * t1290 * t349 - 0.4e1 / 0.3e1 * t390 * t6 * t715)
  t1420 = t1410 / 0.2e1 + t1418 / 0.2e1
  t1423 = 0.3e1 * t263 * t385 * t1420
  t1427 = t936 * t1332
  t1429 = t129 * t1329
  t1434 = t446 * t298
  t1444 = t863 * t1325
  t1446 = t444 * t445 * t1444
  t1450 = t295 * t1329 * t286
  t1452 = t883 * t884 * t1450
  t1455 = t896 * t75 * t1444
  t1458 = 0.12974218172834570555555555555555555555555555555555e-1 * t1427 + 0.11120758433858203333333333333333333333333333333333e-1 * t460 * t927 * t1429 * t929 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t1434 * t1429 * t490 + 0.11120758433858203333333333333333333333333333333333e-1 * t460 * t927 * t1335 * t490 + 0.11120758433858203333333333333333333333333333333333e-2 * t866 + 0.11120758433858203333333333333333333333333333333333e-2 * t1446 + t862 + t881 - 0.19772708495399885526666666666666666666666666666666e-2 * t898 + 0.55603792169291016666666666666666666666666666666666e-3 * t1452 - 0.19772708495399885526666666666666666666666666666666e-2 * t1455 + 0.55603792169291016666666666666666666666666666666666e-3 * t888
  t1460 = t942 * t489
  t1472 = t922 * t923 * t1450
  t1474 = -t1298 - t1301 - t1302 - t644 + t648 + t650 - t1303 - t657 + t661 + t668 - t676 - t1309 - t705
  t1475 = 0.4e1 * t1038
  t1476 = t1371 - t1373 + t1393 + t1395 + t1398 - t1013 + t966 + t975 + t950 - t953 + t1034 - t1037 - t1475
  t1492 = -(t1474 + t1476) * t279 * t284 + 0.3e1 * t1316 * t486 + 0.3e1 * t483 * t1326 - 0.12e2 * t282 * t39 * t550 * t1325 * t395 + 0.3e1 * t282 * t485 * t1420
  t1493 = t1492 * t286
  t1500 = t291 * t907 * t1336
  t1506 = t1325 * t395
  t1511 = -t894 + t906 + 0.25948436345669141111111111111111111111111111111110e-1 * t909 + 0.11120758433858203333333333333333333333333333333333e-1 * t941 * t1434 * t1429 * t1460 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t298 * t129 * t1420 - t921 - 0.98863542476999427633333333333333333333333333333332e-3 * t925 - 0.98863542476999427633333333333333333333333333333332e-3 * t1472 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t1493 + 0.12974218172834570555555555555555555555555555555555e-1 * t937 + 0.25948436345669141111111111111111111111111111111110e-1 * t1500 + 0.33362275301574609999999999999999999999999999999999e-1 * t280 * t289 * t458 * t144 * t324 * t212 * t462 * t1506
  t1528 = 0.21642471925239962895442271601568611111111111111110e-2 * t1118 - 0.54971878690109505754423369867984272222222222222224e-4 * t1133 + 0.30917817036057089850631816573669444444444444444442e-4 * t1137 + 0.10821235962619981447721135800784305555555555555555e-2 * t1100 + 0.15458908518028544925315908286834722222222222222221e-4 * t1153 - 0.27485939345054752877211684933992136111111111111112e-4 * t1156 + t1096 - t1090 + t1115 - t1130 + t1136 + 0.92753451108171269551895449721008333333333333333328e-3 * t534 * t1103 * t1347 * t490
  t1529 = t130 * t1329
  t1534 = t535 * t327
  t1544 = t319 * t1116 * t1348
  t1551 = t1131 * t1336
  t1552 = t514 * t1551
  t1554 = t526 * t1551
  t1556 = t1099 * t1344
  t1562 = t1151 * t1331
  t1563 = t1150 * t1562
  t1565 = t1155 * t1562
  t1575 = 0.92753451108171269551895449721008333333333333333328e-3 * t534 * t1103 * t1529 * t929 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t1534 * t1529 * t490 + 0.69565088331128452163921587290756249999999999999996e-3 * t1143 * t1534 * t1529 * t1460 + 0.21642471925239962895442271601568611111111111111110e-2 * t1544 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t327 * t130 * t1420 + 0.30917817036057089850631816573669444444444444444442e-4 * t1552 - 0.54971878690109505754423369867984272222222222222222e-4 * t1554 + 0.10821235962619981447721135800784305555555555555555e-2 * t1556 + t1174 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t1493 + 0.15458908518028544925315908286834722222222222222221e-4 * t1563 - 0.27485939345054752877211684933992136111111111111111e-4 * t1565 + 0.23188362777042817387973862430252083333333333333332e-2 * t313 * t317 * t532 * t145 * t1163 * t125 * t537 * t1506
  t1596 = t263 * t272 * (0.10000000000000000000000000000000000000000000000000e1 * (-0.5e1 / 0.32e2 * t855 * t1340 * t508 + t441 * (t1458 + t1511) / 0.8e1 - 0.9e1 / 0.128e3 * t1072 * t1352 * t557 + t512 * (t1528 + t1575) / 0.16e2) * t287 + 0.10000000000000000000000000000000000000000000000000e1 * t1355 * t489 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t560 * t1329 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t1492 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t1358 * t490) * t568
  t1597 = t1295 * t204
  t1598 = t1194 * t1597
  t1607 = t614 * t1305
  t1610 = t1361 * t568
  t1613 = 0.3e1 * t632 * t1610 * t395
  t1614 = -t975 - t950 + t953 - t1034 + t1037 + t1475 + t1266 + t1278 + t1607 + t195 * (t1269 - t1275) - t1613
  t1618 = -t1298 - t1301 - t1302 - t644 + t648 + t650 - t1303 - t657 + t580 * (t1396 - t1398 - 0.2363e1 * t1195 - t1402 - t1423 - t1596 - 0.2363e1 * t1598 - 0.2363e1 * t616 * t1391 * t204 - 0.2363e1 * t616 * t1295 * t626 + t1013 - t966 + t1614) + t661 + t668 - t676 - t1309 - t705 - t1364 + t1369 + t1371 - t1373
  t1623 = t263 * t385 * t1325
  t1624 = 0.3e1 * t1623
  t1627 = t263 * t272 * t1361 * t568
  t1628 = t615 - 0.2363e1 * t616 * t1597 + t195 * t1305 - t416 - t417 + t466 + t470 - t1312 - t435 - t1314 + t476 + t481 - t1624 - t1627
  t1630 = t1286 / 0.2e1
  t1631 = t13 * t1630
  t1635 = t753 * t1630 * t64
  t1639 = t13 * t6 * t715
  t1642 = r1 ** 2
  t1645 = tau1 / t17 / t1642
  t1648 = -t1630
  t1650 = t761 * t1648 * t68
  t1654 = t24 * t6 * t715
  t1665 = t24 * t1648
  t1669 = (0.5e1 / 0.3e1 * t5 * t1631 - 0.5e1 / 0.3e1 * t1645 * t25 + 0.5e1 / 0.3e1 * t20 * t1665 + t76) * t37
  t1673 = 0.5e1 / 0.3e1 * t1631 + 0.5e1 / 0.3e1 * t1665
  t1674 = t82 * t1673
  t1690 = 0.5e1 / 0.9e1 * (-0.25e2 / 0.9e1 * t58 * t1631 + 0.10e2 / 0.9e1 * t5 * t1635 + 0.5e1 / 0.3e1 * t5 * t1639 - 0.25e2 / 0.9e1 * t1645 * t69 + 0.10e2 / 0.9e1 * t20 * t1650 - 0.5e1 / 0.3e1 * t20 * t1654 - t771) * t37 * t45 - 0.5e1 / 0.9e1 * t1669 * t85 - 0.5e1 / 0.9e1 * t78 * t1674 + 0.10e2 / 0.9e1 * t38 * t42 * t779 * t1673 * t84 - 0.5e1 / 0.9e1 * t38 * t82 * (0.10e2 / 0.9e1 * t1635 + 0.5e1 / 0.3e1 * t1639 + 0.10e2 / 0.9e1 * t1650 - 0.5e1 / 0.3e1 * t1654)
  t1691 = f.my_piecewise3(t54, t1690, 0)
  t1697 = 0.5e1 / 0.9e1 * t1669 * t45 - 0.5e1 / 0.9e1 * t38 * t1674
  t1698 = f.my_piecewise3(t54, t1697, 0)
  t1713 = -0.1131e1 * t1698 * t92 - 0.1131e1 * t97 * t1698
  t1717 = f.my_piecewise3(t53, 0, (-0.1131e1 * t1691 * t92 - 0.2262e1 * t1698 * t96 * t89 - 0.2262e1 * t802 * t1698 * t89 - 0.1131e1 * t97 * t1691) * t103 + t1713 * t100 * t103)
  t1718 = f.my_piecewise3(t111, 0, t1697)
  t1720 = t120 * t116
  t1723 = f.my_piecewise3(t111, 0, t1690)
  t1731 = f.my_piecewise3(t111, 0, -0.4658e1 * t814 * t1718 * t1720 - 0.2329e1 * t115 * t1723 * t120 - 0.39593e1 * t824 * t1718 * t1720)
  t1732 = f.my_piecewise3(t48, t1717, t1731)
  t1735 = f.my_piecewise3(t53, 0, t1713 * t103)
  t1739 = f.my_piecewise3(t111, 0, -0.2329e1 * t115 * t1718 * t120)
  t1740 = f.my_piecewise3(t48, t1735, t1739)
  t1742 = t124 * t1628 + t1732 * t343 + t1740 * t629 - t1013 + t1034 - t1037 + t1393 + t1395 + t1398 + t1402 + t1423 - t1475 + t1596 + t1613 + t950 - t953 + t966 + t975
  t1745 = t1740 * t343
  t1746 = t580 * t1628
  d12 = -t575 + t570 + t7 * (t1618 + t1742) + t630 + t436 - t573 + t1312 + t1745 + t1746 + t574 + t628 + t1624 + t1314 + t384 + t344 - t576 + t471 + t438 + t1627
  t1747 = 0.11696447245269292414524477327518106963944910680856e1 * t1297
  t1748 = 0.36622894612013090109708692208757981924083909966068e-3 * t1300
  t1749 = t1325 ** 2
  t1752 = 0.6e1 * t263 * t706 * t1749
  t1755 = 0.6e1 * t632 * t1610 * t1325
  t1756 = t1286 ** 2
  t1759 = t61 + t716
  t1760 = 0.2e1 * t1759
  t1764 = f.my_piecewise3(t178, 0, 0.4e1 / 0.9e1 * t711 * t1756 + 0.4e1 / 0.3e1 * t181 * t1760)
  t1765 = t1290 ** 2
  t1768 = -t1760
  t1772 = f.my_piecewise3(t184, 0, 0.4e1 / 0.9e1 * t723 * t1765 + 0.4e1 / 0.3e1 * t185 * t1768)
  t1774 = (t1764 + t1772) * t191
  t1784 = t227 * t1774 * t255
  t1785 = 0.8e1 * t1370
  t1786 = 0.8e1 * t1372
  t1787 = t1747 + t1748 + t644 - t648 + t657 - t1752 - t661 - t1755 - 0.2363e1 * t616 * t1774 * t204 - 0.4726e1 * t616 * t1295 * t1305 + t195 * (-t1269 - t1271 - t1275) - t668 + t676 + t705 - t1784 + t1785 + t1786
  t1788 = 0.2e1 * t1398
  t1790 = 0.19751673498613801407483339618206552048944131217655e-1 * t1774 * t253
  t1791 = t1340 ** 2
  t1801 = f.my_piecewise3(t178, 0, -0.2e1 / 0.9e1 * t834 * t1756 + 0.2e1 / 0.3e1 * t386 * t1760)
  t1807 = f.my_piecewise3(t184, 0, -0.2e1 / 0.9e1 * t841 * t1765 + 0.2e1 / 0.3e1 * t390 * t1768)
  t1809 = t1801 / 0.2e1 + t1807 / 0.2e1
  t1820 = t956 - t1748 + t668 - t644 + t661 - t657 + t1784 + t1788 + t953 - t1786 - t1037
  t1821 = -t1013 - t1747 + t966 + t975 + t1034 - t676 - t705 - t1785 - t1041 + t1790 + t950 + t648
  t1833 = -(t1820 + t1821) * t279 * t284 + 0.6e1 * t1316 * t1326 - 0.12e2 * t282 * t1048 * t1749 + 0.3e1 * t282 * t485 * t1809
  t1834 = t1833 * t286
  t1841 = t1329 ** 2
  t1842 = t1841 * t942
  t1848 = t1841 * t286
  t1854 = t286 * t1325
  t1859 = t862 + 0.22241516867716406666666666666666666666666666666666e-2 * t1446 + 0.51896872691338282222222222222222222222222222222220e-1 * t1500 - 0.11120758433858203333333333333333333333333333333333e-1 * t291 * t502 * t298 * t129 * t1809 + t906 + 0.33362275301574609999999999999999999999999999999999e-1 * t291 * t1061 * t298 * t129 * t1749 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t1834 + 0.11120758433858203333333333333333333333333333333333e-2 * t1452 - t894 - 0.39545416990799771053333333333333333333333333333332e-2 * t1455 + 0.11120758433858203333333333333333333333333333333333e-1 * t941 * t461 * t462 * t1842 + t881 - t921 - 0.19772708495399885526666666666666666666666666666666e-2 * t1472 - 0.55603792169291016666666666666666666666666666666666e-2 * t460 * t461 * t462 * t1848 + 0.25948436345669141111111111111111111111111111111110e-1 * t1427 + 0.22241516867716406666666666666666666666666666666666e-1 * t460 * t927 * t1429 * t1854
  t1862 = t1352 ** 2
  t1897 = -t1090 + t1096 + 0.30917817036057089850631816573669444444444444444442e-4 * t1563 - 0.54971878690109505754423369867984272222222222222223e-4 * t1565 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t1834 + t1136 + 0.61835634072114179701263633147338888888888888888884e-4 * t1552 + t1115 + 0.43284943850479925790884543203137222222222222222220e-2 * t1544 - 0.46376725554085634775947724860504166666666666666664e-3 * t319 * t551 * t327 * t130 * t1809 + 0.69565088331128452163921587290756249999999999999996e-3 * t1143 * t536 * t537 * t1842 + 0.23188362777042817387973862430252083333333333333332e-2 * t319 * t1164 * t327 * t130 * t1749 + 0.18550690221634253910379089944201666666666666666666e-2 * t534 * t1103 * t1529 * t1854 - 0.23188362777042817387973862430252083333333333333332e-3 * t534 * t536 * t537 * t1848 + t1174 + 0.21642471925239962895442271601568611111111111111110e-2 * t1556 - t1130 - 0.10994375738021901150884673973596854444444444444445e-3 * t1554
  t1915 = t263 * t272 * (0.10000000000000000000000000000000000000000000000000e1 * (-0.5e1 / 0.32e2 * t855 * t1791 + t441 * t1859 / 0.8e1 - 0.9e1 / 0.128e3 * t1072 * t1862 + t512 * t1897 / 0.16e2) * t287 + 0.20000000000000000000000000000000000000000000000000e1 * t1355 * t1329 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t1833 * t286 + 0.10000000000000000000000000000000000000000000000000e1 * t336 * t1841 * t286) * t568
  t1916 = t1361 ** 2
  t1919 = t263 * t272 * t1916 * t739
  t1922 = 0.3e1 * t263 * t385 * t1809
  t1925 = -t1788 - t1790 - t1915 + t1919 - t1922 - 0.4726e1 * t1598 + t1013 - t966 - t975 + t1041 - t950 - t953 - t956 - t1034 + t1037 + t1266 + 0.2e1 * t1607
  t1928 = -t1747 - t1748 - t644 + t648 - t657 + t1752 + t661 + t1755 + t668 - t676 - t705 + t580 * (t1787 + t1925) + t1784 - t1785 - t1786
  t1931 = t1630 ** 2
  t1932 = t753 * t1931
  t1935 = t13 * t1759
  t1946 = t1648 ** 2
  t1947 = t761 * t1946
  t1951 = -t24 * t1759
  t1960 = t1673 ** 2
  t1972 = 0.5e1 / 0.9e1 * (0.10e2 / 0.9e1 * t5 * t1932 + 0.5e1 / 0.3e1 * t5 * t1935 + 0.40e2 / 0.9e1 * tau1 / t17 / t1642 / r1 * t25 - 0.50e2 / 0.9e1 * t1645 * t1665 + 0.10e2 / 0.9e1 * t20 * t1947 + 0.5e1 / 0.3e1 * t20 * t1951 - t771) * t37 * t45 - 0.10e2 / 0.9e1 * t1669 * t1674 + 0.10e2 / 0.9e1 * t38 * t780 * t1960 - 0.5e1 / 0.9e1 * t38 * t82 * (0.10e2 / 0.9e1 * t1932 + 0.5e1 / 0.3e1 * t1935 + 0.10e2 / 0.9e1 * t1947 + 0.5e1 / 0.3e1 * t1951)
  t1973 = f.my_piecewise3(t54, t1972, 0)
  t1976 = t1698 ** 2
  t1985 = t1713 ** 2
  t1988 = f.my_piecewise3(t53, 0, (-0.1131e1 * t1973 * t92 - 0.2262e1 * t1976 * t96 - 0.2262e1 * t802 * t1976 - 0.1131e1 * t97 * t1973) * t103 + t1985 * t103)
  t1989 = t1718 ** 2
  t1993 = f.my_piecewise3(t111, 0, t1972)
  t2001 = f.my_piecewise3(t111, 0, -0.4658e1 * t814 * t1989 * t120 - 0.2329e1 * t115 * t1993 * t120 - 0.39593e1 * t824 * t1989 * t120)
  t2002 = f.my_piecewise3(t48, t1988, t2001)
  t2004 = 0.2e1 * t1740 * t1628 + t2002 * t343 - t1013 + t1034 - t1037 - t1041 + t1788 + t1790 + t1915 - t1919 + t1922 + t950 + t953 + t956 + t966 + t975
  d22 = -t576 + t7 * (t1928 + t2004) + t436 + 0.6e1 * t1623 + 0.2e1 * t1745 + t574 + 0.2e1 * t1312 - t572 - t573 - t575 + 0.39503346997227602814966679236413104097888262435310e-1 * t1313 + 0.2e1 * t1746 + 0.2e1 * t1627 + t384
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

