"""Generated from mgga_c_rmggac.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  mbeta = lambda rs=None, t=None: 0.066725

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  rmggac_gamma1 = 0.08

  rmggac_gamma2 = 0.3

  rmggac_gamma = 0.031091

  rmggac_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 4) / (2 ** (1 / 3) * K_FACTOR_C)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rmggac_g = lambda alpha, s: (1 + rmggac_gamma1) * alpha / (rmggac_gamma1 + alpha + rmggac_gamma2 * s ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rmggac_f2 = lambda alpha, s: 3 * rmggac_g(alpha, s) ** 3 / (1 + rmggac_g(alpha, s) ** 3 + rmggac_g(alpha, s) ** 6)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  rmggac_f1 = lambda alpha, s: 1 - rmggac_f2(alpha, s)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  rmggac_w1 = lambda rs, z: jnp.exp(-f_pw(rs, z) / (rmggac_gamma * f.mphi(z) ** 3)) - 1

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  rmggac_H1 = lambda rs, z, t: rmggac_gamma * f.mphi(z) ** 3 * jnp.log(1 + rmggac_w1(rs, z) * (1 - scan_e0_g(rs, z, t)))

  rmggac_eps1 = lambda rs, z, t: f_pw(rs, z) + rmggac_H1(rs, z, t)

  rmggac_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) * rmggac_f1(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt) + rmggac_eps1(rs, z, tp(rs, z, xt)) * rmggac_f2(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rmggac_f(rs, z, xt, xs0, xs1, 2 * ts0, 2 * ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  mbeta = lambda rs=None, t=None: 0.066725

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  rmggac_gamma1 = 0.08

  rmggac_gamma2 = 0.3

  rmggac_gamma = 0.031091

  rmggac_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 4) / (2 ** (1 / 3) * K_FACTOR_C)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rmggac_g = lambda alpha, s: (1 + rmggac_gamma1) * alpha / (rmggac_gamma1 + alpha + rmggac_gamma2 * s ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rmggac_f2 = lambda alpha, s: 3 * rmggac_g(alpha, s) ** 3 / (1 + rmggac_g(alpha, s) ** 3 + rmggac_g(alpha, s) ** 6)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  rmggac_f1 = lambda alpha, s: 1 - rmggac_f2(alpha, s)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  rmggac_w1 = lambda rs, z: jnp.exp(-f_pw(rs, z) / (rmggac_gamma * f.mphi(z) ** 3)) - 1

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  rmggac_H1 = lambda rs, z, t: rmggac_gamma * f.mphi(z) ** 3 * jnp.log(1 + rmggac_w1(rs, z) * (1 - scan_e0_g(rs, z, t)))

  rmggac_eps1 = lambda rs, z, t: f_pw(rs, z) + rmggac_H1(rs, z, t)

  rmggac_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) * rmggac_f1(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt) + rmggac_eps1(rs, z, tp(rs, z, xt)) * rmggac_f2(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rmggac_f(rs, z, xt, xs0, xs1, 2 * ts0, 2 * ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  mbeta = lambda rs=None, t=None: 0.066725

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  rmggac_gamma1 = 0.08

  rmggac_gamma2 = 0.3

  rmggac_gamma = 0.031091

  rmggac_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 4) / (2 ** (1 / 3) * K_FACTOR_C)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rmggac_g = lambda alpha, s: (1 + rmggac_gamma1) * alpha / (rmggac_gamma1 + alpha + rmggac_gamma2 * s ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rmggac_f2 = lambda alpha, s: 3 * rmggac_g(alpha, s) ** 3 / (1 + rmggac_g(alpha, s) ** 3 + rmggac_g(alpha, s) ** 6)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  rmggac_f1 = lambda alpha, s: 1 - rmggac_f2(alpha, s)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  rmggac_w1 = lambda rs, z: jnp.exp(-f_pw(rs, z) / (rmggac_gamma * f.mphi(z) ** 3)) - 1

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  rmggac_H1 = lambda rs, z, t: rmggac_gamma * f.mphi(z) ** 3 * jnp.log(1 + rmggac_w1(rs, z) * (1 - scan_e0_g(rs, z, t)))

  rmggac_eps1 = lambda rs, z, t: f_pw(rs, z) + rmggac_H1(rs, z, t)

  rmggac_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) * rmggac_f1(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt) + rmggac_eps1(rs, z, tp(rs, z, xt)) * rmggac_f2(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rmggac_f(rs, z, xt, xs0, xs1, 2 * ts0, 2 * ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t12 = jnp.sqrt(t11)
  t15 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t12 + 0.31385250000000000000000000000000000000000000000000e-1 * t11
  t16 = 0.1e1 / t15
  t19 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t16)
  t20 = t19 - 0.1e1
  t21 = 6 ** (0.1e1 / 0.3e1)
  t22 = jnp.pi ** 2
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = 0.1e1 / t24
  t26 = t21 * t25
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t30 = s0 + 0.2e1 * s1 + s2
  t31 = t28 * t30
  t32 = t7 ** 2
  t33 = t8 ** 2
  t35 = 0.1e1 / t33 / t32
  t37 = t26 * t31 * t35
  t39 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t37
  t40 = t39 ** (0.1e1 / 0.4e1)
  t42 = 0.1e1 - 0.1e1 / t40
  t44 = t20 * t42 + 0.1e1
  t45 = jnp.log(t44)
  t47 = -0.285764e-1 * t16 + 0.285764e-1 * t45
  t49 = 0.2363e1 * t27 - 0.2363e1
  t50 = r0 - r1
  t51 = 0.1e1 / t7
  t52 = t50 * t51
  t53 = 0.1e1 + t52
  t54 = t53 <= f.p.zeta_threshold
  t55 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t56 = t55 * f.p.zeta_threshold
  t57 = t53 ** (0.1e1 / 0.3e1)
  t59 = f.my_piecewise3(t54, t56, t57 * t53)
  t60 = 0.1e1 - t52
  t61 = t60 <= f.p.zeta_threshold
  t62 = t60 ** (0.1e1 / 0.3e1)
  t64 = f.my_piecewise3(t61, t56, t62 * t60)
  t65 = t59 + t64 - 0.2e1
  t69 = 0.1e1 / (0.2e1 * t27 - 0.2e1)
  t71 = -t49 * t65 * t69 + 0.1e1
  t72 = t47 * t71
  t73 = t50 ** 2
  t74 = t73 ** 2
  t75 = t74 ** 2
  t76 = t75 * t74
  t77 = t32 ** 2
  t78 = t77 ** 2
  t80 = 0.1e1 / t78 / t77
  t82 = -t76 * t80 + 0.1e1
  t83 = r0 ** (0.1e1 / 0.3e1)
  t84 = t83 ** 2
  t86 = 0.1e1 / t84 / r0
  t87 = tau0 * t86
  t88 = t53 / 0.2e1
  t89 = t88 ** (0.1e1 / 0.3e1)
  t90 = t89 ** 2
  t91 = t90 * t88
  t94 = r1 ** (0.1e1 / 0.3e1)
  t95 = t94 ** 2
  t97 = 0.1e1 / t95 / r1
  t98 = tau1 * t97
  t99 = t60 / 0.2e1
  t100 = t99 ** (0.1e1 / 0.3e1)
  t101 = t100 ** 2
  t102 = t101 * t99
  t107 = 0.2e1 * t87 * t91 + 0.2e1 * t98 * t102 - t30 * t35 / 0.4e1
  t108 = t107 ** 2
  t109 = t108 * t107
  t110 = t22 ** 2
  t111 = 0.1e1 / t110
  t112 = t109 * t111
  t117 = 0.8e-1 + 0.5e1 / 0.18e2 * t107 * t28 * t26 + 0.12500000000000000000000000000000000000000000000000e-1 * t37
  t118 = t117 ** 2
  t119 = t118 * t117
  t120 = 0.1e1 / t119
  t123 = t108 ** 2
  t125 = t110 ** 2
  t126 = 0.1e1 / t125
  t127 = t123 * t108 * t126
  t128 = t118 ** 2
  t130 = 0.1e1 / t128 / t118
  t133 = 0.1e1 + 0.64800000000000000000000000000000000000000000000000e0 * t112 * t120 + 0.41990400000000000000000000000000000000000000000000e0 * t127 * t130
  t134 = 0.1e1 / t133
  t135 = t120 * t134
  t138 = 0.1e1 - 0.19440000000000000000000000000000000000000000000000e1 * t112 * t135
  t139 = t82 * t138
  t140 = t72 * t139
  t142 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t145 = t11 ** 0.15e1
  t147 = t1 ** 2
  t148 = t3 ** 2
  t149 = t147 * t148
  t152 = t149 * t5 / t33
  t154 = 0.23615562999000000000000000000000000000000000000000e0 * t12 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t145 + 0.76629248290000000000000000000000000000000000000000e-2 * t152
  t156 = 0.1e1 + 0.1e1 / t154
  t157 = jnp.log(t156)
  t158 = t142 * t157
  t159 = 0.1e1 / t77
  t160 = t74 * t159
  t161 = t65 * t69
  t163 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t168 = 0.21948324211500000000000000000000000000000000000000e0 * t12 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t145 + 0.48592432297500000000000000000000000000000000000000e-2 * t152
  t170 = 0.1e1 + 0.1e1 / t168
  t171 = jnp.log(t170)
  t174 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t179 = 0.17489762330000000000000000000000000000000000000000e0 * t12 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t145 + 0.41939460495000000000000000000000000000000000000000e-2 * t152
  t181 = 0.1e1 + 0.1e1 / t179
  t182 = jnp.log(t181)
  t183 = t174 * t182
  t185 = -t163 * t171 + t158 - 0.58482236226346462072622386637590534819724553404281e0 * t183
  t186 = t161 * t185
  t187 = t160 * t186
  t189 = 0.58482236226346462072622386637590534819724553404281e0 * t161 * t183
  t190 = t55 ** 2
  t191 = t57 ** 2
  t192 = f.my_piecewise3(t54, t190, t191)
  t193 = t62 ** 2
  t194 = f.my_piecewise3(t61, t190, t193)
  t196 = t192 / 0.2e1 + t194 / 0.2e1
  t197 = t196 ** 2
  t198 = t197 * t196
  t199 = -t158 + t187 + t189
  t200 = 0.1e1 / t198
  t203 = jnp.exp(-0.32163648644302209642661863561802450870026695828375e2 * t199 * t200)
  t204 = t203 - 0.1e1
  t205 = jnp.log(0.2e1)
  t207 = 0.1e1 / (0.1e1 - t205)
  t208 = t207 * t22
  t209 = t199 * t207
  t210 = t22 * t200
  t212 = jnp.exp(-t209 * t210)
  t213 = t212 - 0.1e1
  t214 = 0.1e1 / t213
  t215 = t214 * t30
  t217 = 0.1e1 / t8 / t32
  t219 = t208 * t215 * t217
  t220 = 0.1e1 / t197
  t222 = 0.1e1 / t3
  t225 = t27 * t220 * t147 * t222 * t5
  t228 = 0.1e1 + 0.27802083333333333333333333333333333333333333333333e-2 * t219 * t225
  t229 = t228 ** (0.1e1 / 0.4e1)
  t231 = 0.1e1 - 0.1e1 / t229
  t233 = t204 * t231 + 0.1e1
  t234 = jnp.log(t233)
  t237 = -t158 + t187 + t189 + 0.31091e-1 * t198 * t234
  t238 = t237 * t109
  t240 = t111 * t120 * t134
  t242 = 0.19440000000000000000000000000000000000000000000000e1 * t238 * t240
  t243 = t15 ** 2
  t247 = t3 * t6
  t249 = 0.1e1 / t8 / t7
  t250 = t247 * t249
  t251 = 0.1e1 / t12 * t1 * t250
  t253 = t6 * t249
  t254 = t4 * t253
  t257 = 0.1e1 / t243 * (-0.74083333333333333333333333333333333333333333333333e-2 * t251 - 0.10461750000000000000000000000000000000000000000000e-1 * t254)
  t264 = t20 / t40 / t39
  t266 = t25 * t28
  t267 = t32 * t7
  t269 = 0.1e1 / t33 / t267
  t270 = t30 * t269
  t275 = 0.1e1 / t44
  t280 = (0.285764e-1 * t257 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t257 * t19 * t42 - 0.14225094736250905555555555555555555555555555555555e-1 * t264 * t21 * t266 * t270) * t275) * t71 * t139
  t281 = t47 * t49
  t283 = t50 / t32
  t284 = t51 - t283
  t287 = f.my_piecewise3(t54, 0, 0.4e1 / 0.3e1 * t57 * t284)
  t288 = -t284
  t291 = f.my_piecewise3(t61, 0, 0.4e1 / 0.3e1 * t62 * t288)
  t292 = t287 + t291
  t295 = t69 * t82 * t138
  t297 = t73 * t50
  t299 = t75 * t297 * t80
  t300 = t77 * t7
  t303 = t76 / t78 / t300
  t308 = t108 * t111
  t309 = r0 ** 2
  t315 = t284 / 0.2e1
  t323 = 0.2e1 / 0.3e1 * t270
  t324 = -0.10e2 / 0.3e1 * tau0 / t84 / t309 * t91 + 0.10e2 / 0.3e1 * t87 * t90 * t315 - 0.10e2 / 0.3e1 * t98 * t101 * t315 + t323
  t325 = t135 * t324
  t328 = 0.1e1 / t128
  t329 = t328 * t134
  t335 = 0.33333333333333333333333333333333333333333333333333e-1 * t26 * t31 * t269
  t336 = 0.5e1 / 0.18e2 * t324 * t28 * t26 - t335
  t337 = t329 * t336
  t340 = t133 ** 2
  t342 = t120 / t340
  t350 = t123 * t107 * t126
  t355 = 0.1e1 / t128 / t119
  t360 = t342 * (0.19440000000000000000000000000000000000000000000000e1 * t308 * t120 * t324 - 0.19440000000000000000000000000000000000000000000000e1 * t112 * t328 * t336 + 0.25194240000000000000000000000000000000000000000000e1 * t350 * t130 * t324 - 0.25194240000000000000000000000000000000000000000000e1 * t127 * t355 * t336)
  t368 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t253 * t157
  t369 = t154 ** 2
  t374 = t11 ** 0.5e0
  t376 = t374 * t1 * t250
  t381 = t149 * t5 / t33 / t7
  t386 = t142 / t369 * (-0.39359271665000000000000000000000000000000000000000e-1 * t251 - 0.18590165886666666666666666666666666666666666666667e-1 * t254 - 0.63665980925000000000000000000000000000000000000000e-2 * t376 - 0.51086165526666666666666666666666666666666666666667e-2 * t381) / t156
  t389 = 0.4e1 * t297 * t159 * t186
  t393 = 0.4e1 * t74 / t300 * t186
  t394 = t292 * t69
  t396 = t160 * t394 * t185
  t400 = t168 ** 2
  t414 = t179 ** 2
  t415 = 0.1e1 / t414
  t421 = -0.29149603883333333333333333333333333333333333333333e-1 * t251 - 0.10197154565000000000000000000000000000000000000000e-1 * t254 - 0.18581078242500000000000000000000000000000000000000e-2 * t376 - 0.27959640330000000000000000000000000000000000000000e-2 * t381
  t422 = 0.1e1 / t181
  t428 = t160 * t161 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t253 * t171 + t163 / t400 * (-0.36580540352500000000000000000000000000000000000000e-1 * t251 - 0.16057569282500000000000000000000000000000000000000e-1 * t254 - 0.65410946462500000000000000000000000000000000000000e-2 * t376 - 0.32394954865000000000000000000000000000000000000000e-2 * t381) / t170 - t368 - t386 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t253 * t182 + 0.58482236226346462072622386637590534819724553404281e0 * t174 * t415 * t421 * t422)
  t430 = 0.58482236226346462072622386637590534819724553404281e0 * t394 * t183
  t435 = 0.18311447306006545054854346104378990962041954983034e-3 * t161 * t1 * t247 * t249 * t182
  t440 = 0.58482236226346462072622386637590534819724553404281e0 * t161 * t174 * t415 * t421 * t422
  t441 = t197 * t234
  t442 = 0.1e1 / t57
  t445 = f.my_piecewise3(t54, 0, 0.2e1 / 0.3e1 * t442 * t284)
  t446 = 0.1e1 / t62
  t449 = f.my_piecewise3(t61, 0, 0.2e1 / 0.3e1 * t446 * t288)
  t451 = t445 / 0.2e1 + t449 / 0.2e1
  t454 = t368 + t386 + t389 - t393 + t396 + t428 + t430 - t435 - t440
  t457 = t197 ** 2
  t458 = 0.1e1 / t457
  t459 = t199 * t458
  t466 = 0.1e1 / t229 / t228
  t467 = t204 * t466
  t468 = t213 ** 2
  t473 = t208 / t468 * t30 * t217 * t27
  t475 = t220 * t147 * t222
  t478 = t22 * t458
  t493 = 0.64871527777777777777777777777777777777777777777777e-2 * t208 * t215 / t8 / t267 * t225
  t495 = t27 * t200 * t147
  t496 = t222 * t5
  t506 = 0.1e1 / t233
  t509 = t368 + t386 + t389 - t393 + t396 + t428 + t430 - t435 - t440 + 0.93273e-1 * t441 * t451 + 0.31091e-1 * t198 * ((-0.32163648644302209642661863561802450870026695828375e2 * t454 * t200 + 0.96490945932906628927985590685407352610080087485125e2 * t459 * t451) * t203 * t231 + t467 * (-0.27802083333333333333333333333333333333333333333333e-2 * t473 * t475 * t5 * (-t454 * t207 * t210 + 0.3e1 * t209 * t478 * t451) * t212 - t493 - 0.55604166666666666666666666666666666666666666666666e-2 * t219 * t495 * t496 * t451) / 0.4e1) * t506
  t514 = t237 * t108 * t111
  t517 = t238 * t111
  vrho_0_ = t140 + t242 + t7 * (t280 - t281 * t292 * t295 + t72 * (-0.12e2 * t299 + 0.12e2 * t303) * t138 + t72 * t82 * (-0.58320000000000000000000000000000000000000000000000e1 * t308 * t325 + 0.58320000000000000000000000000000000000000000000000e1 * t112 * t337 + 0.19440000000000000000000000000000000000000000000000e1 * t112 * t360) + 0.19440000000000000000000000000000000000000000000000e1 * t509 * t109 * t240 + 0.58320000000000000000000000000000000000000000000000e1 * t514 * t325 - 0.58320000000000000000000000000000000000000000000000e1 * t517 * t337 - 0.19440000000000000000000000000000000000000000000000e1 * t517 * t360)
  t524 = -t51 - t283
  t527 = f.my_piecewise3(t54, 0, 0.4e1 / 0.3e1 * t57 * t524)
  t528 = -t524
  t531 = f.my_piecewise3(t61, 0, 0.4e1 / 0.3e1 * t62 * t528)
  t532 = t527 + t531
  t539 = t524 / 0.2e1
  t543 = r1 ** 2
  t553 = 0.10e2 / 0.3e1 * t87 * t90 * t539 - 0.10e2 / 0.3e1 * tau1 / t95 / t543 * t102 - 0.10e2 / 0.3e1 * t98 * t101 * t539 + t323
  t554 = t135 * t553
  t560 = 0.5e1 / 0.18e2 * t553 * t28 * t26 - t335
  t561 = t329 * t560
  t577 = t342 * (0.19440000000000000000000000000000000000000000000000e1 * t308 * t120 * t553 - 0.19440000000000000000000000000000000000000000000000e1 * t112 * t328 * t560 + 0.25194240000000000000000000000000000000000000000000e1 * t350 * t130 * t553 - 0.25194240000000000000000000000000000000000000000000e1 * t127 * t355 * t560)
  t583 = t532 * t69
  t585 = t160 * t583 * t185
  t587 = 0.58482236226346462072622386637590534819724553404281e0 * t583 * t183
  t590 = f.my_piecewise3(t54, 0, 0.2e1 / 0.3e1 * t442 * t524)
  t593 = f.my_piecewise3(t61, 0, 0.2e1 / 0.3e1 * t446 * t528)
  t595 = t590 / 0.2e1 + t593 / 0.2e1
  t598 = t368 + t386 - t389 - t393 + t585 + t428 + t587 - t435 - t440
  t628 = t368 + t386 - t389 - t393 + t585 + t428 + t587 - t435 - t440 + 0.93273e-1 * t441 * t595 + 0.31091e-1 * t198 * ((-0.32163648644302209642661863561802450870026695828375e2 * t598 * t200 + 0.96490945932906628927985590685407352610080087485125e2 * t459 * t595) * t203 * t231 + t467 * (-0.27802083333333333333333333333333333333333333333333e-2 * t473 * t475 * t5 * (-t598 * t207 * t210 + 0.3e1 * t209 * t478 * t595) * t212 - t493 - 0.55604166666666666666666666666666666666666666666666e-2 * t219 * t495 * t496 * t595) / 0.4e1) * t506
  vrho_1_ = t140 + t242 + t7 * (t280 - t281 * t532 * t295 + t72 * (0.12e2 * t299 + 0.12e2 * t303) * t138 + t72 * t82 * (-0.58320000000000000000000000000000000000000000000000e1 * t308 * t554 + 0.58320000000000000000000000000000000000000000000000e1 * t112 * t561 + 0.19440000000000000000000000000000000000000000000000e1 * t112 * t577) + 0.19440000000000000000000000000000000000000000000000e1 * t628 * t109 * t240 + 0.58320000000000000000000000000000000000000000000000e1 * t514 * t554 - 0.58320000000000000000000000000000000000000000000000e1 * t517 * t561 - 0.19440000000000000000000000000000000000000000000000e1 * t517 * t577)
  t640 = t26 * t28
  t646 = t264 * t640 * t35 * t275 * t71 * t82 * t138
  t648 = t135 * t35
  t649 = t308 * t648
  t651 = t112 * t329
  t653 = t26 * t28 * t35
  t654 = t651 * t653
  t657 = t308 * t120 * t35
  t660 = t112 * t328 * t653
  t663 = t350 * t130 * t35
  t666 = t127 * t355 * t653
  t669 = t342 * (-0.48600000000000000000000000000000000000000000000000e0 * t657 + 0.11070000000000000000000000000000000000000000000000e0 * t660 - 0.62985600000000000000000000000000000000000000000000e0 * t663 + 0.14346720000000000000000000000000000000000000000000e0 * t666)
  t687 = t196 * t204 * t466 * t207 / t22 * t214 * t217 * t27 * t147 * t496 * t506 * t109 * t135
  t689 = t514 * t648
  t691 = t111 * t328
  t696 = t238 * t691 * t134 * t21 * t266 * t35
  vsigma_0_ = t7 * (0.15243824895787514156916666666666666666666666666666e-3 * t646 + t72 * t82 * (0.14580000000000000000000000000000000000000000000000e1 * t649 - 0.33209999999999999999999999999999999999999999999999e0 * t654 + 0.19440000000000000000000000000000000000000000000000e1 * t112 * t669) + 0.42009576243749999999999999999999999999999999999999e-4 * t687 - 0.14580000000000000000000000000000000000000000000000e1 * t689 + 0.33209999999999999999999999999999999999999999999999e0 * t696 - 0.19440000000000000000000000000000000000000000000000e1 * t517 * t669)
  t709 = t342 * (-0.97200000000000000000000000000000000000000000000000e0 * t657 + 0.22140000000000000000000000000000000000000000000000e0 * t660 - 0.12597120000000000000000000000000000000000000000000e1 * t663 + 0.28693440000000000000000000000000000000000000000000e0 * t666)
  vsigma_1_ = t7 * (0.30487649791575028313833333333333333333333333333331e-3 * t646 + t72 * t82 * (0.29160000000000000000000000000000000000000000000000e1 * t649 - 0.66420000000000000000000000000000000000000000000001e0 * t654 + 0.19440000000000000000000000000000000000000000000000e1 * t112 * t709) + 0.84019152487499999999999999999999999999999999999995e-4 * t687 - 0.29160000000000000000000000000000000000000000000000e1 * t689 + 0.66420000000000000000000000000000000000000000000001e0 * t696 - 0.19440000000000000000000000000000000000000000000000e1 * t517 * t709)
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t721 = t308 * t120
  t726 = t86 * t91
  t727 = t726 * t640
  t737 = t91 * t28 * t26
  t749 = t342 * (0.38880000000000000000000000000000000000000000000000e1 * t308 * t120 * t86 * t91 - 0.10800000000000000000000000000000000000000000000000e1 * t112 * t328 * t86 * t737 + 0.50388480000000000000000000000000000000000000000000e1 * t350 * t130 * t86 * t91 - 0.13996800000000000000000000000000000000000000000000e1 * t127 * t355 * t86 * t737)
  t759 = t238 * t691 * t134
  vtau_0_ = t7 * (t72 * t82 * (-0.11664000000000000000000000000000000000000000000000e2 * t721 * t134 * t86 * t91 + 0.32400000000000000000000000000000000000000000000000e1 * t651 * t727 + 0.19440000000000000000000000000000000000000000000000e1 * t112 * t749) + 0.11664000000000000000000000000000000000000000000000e2 * t514 * t135 * t726 - 0.32400000000000000000000000000000000000000000000000e1 * t759 * t727 - 0.19440000000000000000000000000000000000000000000000e1 * t517 * t749)
  t769 = t97 * t102
  t770 = t769 * t640
  t780 = t102 * t28 * t26
  t792 = t342 * (0.38880000000000000000000000000000000000000000000000e1 * t308 * t120 * t97 * t102 - 0.10800000000000000000000000000000000000000000000000e1 * t112 * t328 * t97 * t780 + 0.50388480000000000000000000000000000000000000000000e1 * t350 * t130 * t97 * t102 - 0.13996800000000000000000000000000000000000000000000e1 * t127 * t355 * t97 * t780)
  vtau_1_ = t7 * (t72 * t82 * (-0.11664000000000000000000000000000000000000000000000e2 * t721 * t134 * t97 * t102 + 0.32400000000000000000000000000000000000000000000000e1 * t651 * t770 + 0.19440000000000000000000000000000000000000000000000e1 * t112 * t792) + 0.11664000000000000000000000000000000000000000000000e2 * t514 * t135 * t769 - 0.32400000000000000000000000000000000000000000000000e1 * t759 * t770 - 0.19440000000000000000000000000000000000000000000000e1 * t517 * t792)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  mbeta = lambda rs=None, t=None: 0.066725

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  rmggac_gamma1 = 0.08

  rmggac_gamma2 = 0.3

  rmggac_gamma = 0.031091

  rmggac_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 4) / (2 ** (1 / 3) * K_FACTOR_C)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rmggac_g = lambda alpha, s: (1 + rmggac_gamma1) * alpha / (rmggac_gamma1 + alpha + rmggac_gamma2 * s ** 2)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rmggac_f2 = lambda alpha, s: 3 * rmggac_g(alpha, s) ** 3 / (1 + rmggac_g(alpha, s) ** 3 + rmggac_g(alpha, s) ** 6)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  rmggac_f1 = lambda alpha, s: 1 - rmggac_f2(alpha, s)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  rmggac_w1 = lambda rs, z: jnp.exp(-f_pw(rs, z) / (rmggac_gamma * f.mphi(z) ** 3)) - 1

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  rmggac_H1 = lambda rs, z, t: rmggac_gamma * f.mphi(z) ** 3 * jnp.log(1 + rmggac_w1(rs, z) * (1 - scan_e0_g(rs, z, t)))

  rmggac_eps1 = lambda rs, z, t: f_pw(rs, z) + rmggac_H1(rs, z, t)

  rmggac_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: +scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) * rmggac_f1(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt) + rmggac_eps1(rs, z, tp(rs, z, xt)) * rmggac_f2(rmggac_alpha(z, xt, ts0, ts1), X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rmggac_f(rs, z, xt, xs0, xs1, 2 * ts0, 2 * ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t11 = jnp.sqrt(t10)
  t14 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11 + 0.31385250000000000000000000000000000000000000000000e-1 * t10
  t15 = 0.1e1 / t14
  t18 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t15)
  t19 = t18 - 0.1e1
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = t27 * s0
  t29 = r0 ** 2
  t30 = t7 ** 2
  t32 = 0.1e1 / t30 / t29
  t34 = t25 * t28 * t32
  t36 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t34
  t37 = t36 ** (0.1e1 / 0.4e1)
  t39 = 0.1e1 - 0.1e1 / t37
  t41 = t19 * t39 + 0.1e1
  t42 = jnp.log(t41)
  t47 = 0.1e1 <= f.p.zeta_threshold
  t48 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t50 = f.my_piecewise3(t47, t48 * f.p.zeta_threshold, 1)
  t52 = 0.2e1 * t50 - 0.2e1
  t56 = 0.1e1 / (0.2e1 * t26 - 0.2e1)
  t58 = 0.1e1 - (0.2363e1 * t26 - 0.2363e1) * t52 * t56
  t59 = (-0.285764e-1 * t15 + 0.285764e-1 * t42) * t58
  t61 = 0.1e1 / t30 / r0
  t66 = 0.2e1 * tau0 * t61 - s0 * t32 / 0.4e1
  t67 = t66 ** 2
  t68 = t67 * t66
  t69 = t21 ** 2
  t70 = 0.1e1 / t69
  t71 = t68 * t70
  t76 = 0.8e-1 + 0.5e1 / 0.18e2 * t66 * t27 * t25 + 0.12500000000000000000000000000000000000000000000000e-1 * t34
  t77 = t76 ** 2
  t78 = t77 * t76
  t79 = 0.1e1 / t78
  t82 = t67 ** 2
  t84 = t69 ** 2
  t85 = 0.1e1 / t84
  t86 = t82 * t67 * t85
  t87 = t77 ** 2
  t89 = 0.1e1 / t87 / t77
  t92 = 0.1e1 + 0.64800000000000000000000000000000000000000000000000e0 * t71 * t79 + 0.41990400000000000000000000000000000000000000000000e0 * t86 * t89
  t93 = 0.1e1 / t92
  t94 = t79 * t93
  t97 = 0.1e1 - 0.19440000000000000000000000000000000000000000000000e1 * t71 * t94
  t100 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t103 = t10 ** 0.15e1
  t105 = t1 ** 2
  t106 = t3 ** 2
  t107 = t105 * t106
  t110 = t107 * t5 / t30
  t112 = 0.23615562999000000000000000000000000000000000000000e0 * t11 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t103 + 0.76629248290000000000000000000000000000000000000000e-2 * t110
  t114 = 0.1e1 + 0.1e1 / t112
  t115 = jnp.log(t114)
  t116 = t100 * t115
  t117 = t52 * t56
  t119 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t124 = 0.17489762330000000000000000000000000000000000000000e0 * t11 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t103 + 0.41939460495000000000000000000000000000000000000000e-2 * t110
  t126 = 0.1e1 + 0.1e1 / t124
  t127 = jnp.log(t126)
  t130 = 0.58482236226346462072622386637590534819724553404281e0 * t117 * t119 * t127
  t131 = t48 ** 2
  t132 = f.my_piecewise3(t47, t131, 1)
  t133 = t132 ** 2
  t134 = t133 * t132
  t135 = -t116 + t130
  t136 = 0.1e1 / t134
  t139 = jnp.exp(-0.32163648644302209642661863561802450870026695828375e2 * t135 * t136)
  t140 = t139 - 0.1e1
  t141 = jnp.log(0.2e1)
  t142 = 0.1e1 - t141
  t143 = 0.1e1 / t142
  t144 = t143 * t21
  t148 = jnp.exp(-t135 * t143 * t21 * t136)
  t149 = t148 - 0.1e1
  t150 = 0.1e1 / t149
  t151 = t150 * s0
  t153 = 0.1e1 / t7 / t29
  t158 = 0.1e1 / t3
  t161 = t26 / t133 * t105 * t158 * t5
  t164 = 0.1e1 + 0.27802083333333333333333333333333333333333333333333e-2 * t144 * t151 * t153 * t161
  t165 = t164 ** (0.1e1 / 0.4e1)
  t167 = 0.1e1 - 0.1e1 / t165
  t169 = t140 * t167 + 0.1e1
  t170 = jnp.log(t169)
  t173 = -t116 + t130 + 0.31091e-1 * t134 * t170
  t174 = t173 * t68
  t176 = t70 * t79 * t93
  t179 = t14 ** 2
  t183 = t3 * t6
  t185 = 0.1e1 / t7 / r0
  t186 = t183 * t185
  t187 = 0.1e1 / t11 * t1 * t186
  t189 = t6 * t185
  t190 = t4 * t189
  t193 = 0.1e1 / t179 * (-0.74083333333333333333333333333333333333333333333333e-2 * t187 - 0.10461750000000000000000000000000000000000000000000e-1 * t190)
  t200 = t19 / t37 / t36
  t202 = t24 * t27
  t203 = t29 * r0
  t205 = 0.1e1 / t30 / t203
  t206 = s0 * t205
  t211 = 0.1e1 / t41
  t217 = t67 * t70
  t221 = -0.10e2 / 0.3e1 * tau0 * t32 + 0.2e1 / 0.3e1 * t206
  t222 = t94 * t221
  t225 = 0.1e1 / t87
  t226 = t225 * t93
  t233 = 0.5e1 / 0.18e2 * t221 * t27 * t25 - 0.33333333333333333333333333333333333333333333333333e-1 * t25 * t28 * t205
  t234 = t226 * t233
  t237 = t92 ** 2
  t239 = t79 / t237
  t247 = t82 * t66 * t85
  t252 = 0.1e1 / t87 / t78
  t257 = t239 * (0.19440000000000000000000000000000000000000000000000e1 * t217 * t79 * t221 - 0.19440000000000000000000000000000000000000000000000e1 * t71 * t225 * t233 + 0.25194240000000000000000000000000000000000000000000e1 * t247 * t89 * t221 - 0.25194240000000000000000000000000000000000000000000e1 * t86 * t252 * t233)
  t264 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t189 * t115
  t265 = t112 ** 2
  t270 = t10 ** 0.5e0
  t272 = t270 * t1 * t186
  t275 = t107 * t5 * t61
  t280 = t100 / t265 * (-0.39359271665000000000000000000000000000000000000000e-1 * t187 - 0.18590165886666666666666666666666666666666666666667e-1 * t190 - 0.63665980925000000000000000000000000000000000000000e-2 * t272 - 0.51086165526666666666666666666666666666666666666667e-2 * t275) / t114
  t285 = 0.18311447306006545054854346104378990962041954983034e-3 * t117 * t1 * t183 * t185 * t127
  t287 = t124 ** 2
  t298 = 0.58482236226346462072622386637590534819724553404281e0 * t117 * t119 / t287 * (-0.29149603883333333333333333333333333333333333333333e-1 * t187 - 0.10197154565000000000000000000000000000000000000000e-1 * t190 - 0.18581078242500000000000000000000000000000000000000e-2 * t272 - 0.27959640330000000000000000000000000000000000000000e-2 * t275) / t126
  t299 = t264 + t280 - t285 - t298
  t305 = 0.1e1 / t165 / t164
  t307 = t142 ** 2
  t310 = t149 ** 2
  t316 = t133 ** 2
  t337 = 0.1e1 / t169
  t345 = t173 * t67 * t70
  t348 = t174 * t70
  vrho_0_ = t59 * t97 + 0.19440000000000000000000000000000000000000000000000e1 * t174 * t176 + r0 * ((0.285764e-1 * t193 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t193 * t18 * t39 - 0.14225094736250905555555555555555555555555555555555e-1 * t200 * t20 * t202 * t206) * t211) * t58 * t97 + t59 * (-0.58320000000000000000000000000000000000000000000000e1 * t217 * t222 + 0.58320000000000000000000000000000000000000000000000e1 * t71 * t234 + 0.19440000000000000000000000000000000000000000000000e1 * t71 * t257) + 0.19440000000000000000000000000000000000000000000000e1 * (t264 + t280 - t285 - t298 + 0.31091e-1 * t134 * (-0.32163648644302209642661863561802450870026695828375e2 * t299 * t136 * t139 * t167 + t140 * t305 * (0.27802083333333333333333333333333333333333333333333e-2 / t307 * t69 / t310 * s0 * t153 * t26 / t316 / t132 * t105 * t158 * t5 * t299 * t148 - 0.64871527777777777777777777777777777777777777777777e-2 * t144 * t151 / t7 / t203 * t161) / 0.4e1) * t337) * t68 * t176 + 0.58320000000000000000000000000000000000000000000000e1 * t345 * t222 - 0.58320000000000000000000000000000000000000000000000e1 * t348 * t234 - 0.19440000000000000000000000000000000000000000000000e1 * t348 * t257)
  t356 = t27 * t32
  t362 = t94 * t32
  t365 = t71 * t226
  t366 = t25 * t356
  t372 = t71 * t225
  t378 = t86 * t252
  t382 = t239 * (-0.48600000000000000000000000000000000000000000000000e0 * t217 * t79 * t32 + 0.11070000000000000000000000000000000000000000000000e0 * t372 * t366 - 0.62985600000000000000000000000000000000000000000000e0 * t247 * t89 * t32 + 0.14346720000000000000000000000000000000000000000000e0 * t378 * t366)
  t405 = t174 * t70 * t225
  vsigma_0_ = r0 * (0.15243824895787514156916666666666666666666666666666e-3 * t200 * t25 * t356 * t211 * t58 * t97 + t59 * (0.14580000000000000000000000000000000000000000000000e1 * t217 * t362 - 0.33209999999999999999999999999999999999999999999999e0 * t365 * t366 + 0.19440000000000000000000000000000000000000000000000e1 * t71 * t382) + 0.42009576243749999999999999999999999999999999999999e-4 * t132 * t140 * t305 * t143 / t21 * t150 * t153 * t26 * t105 * t158 * t5 * t337 * t68 * t94 - 0.14580000000000000000000000000000000000000000000000e1 * t345 * t362 + 0.33209999999999999999999999999999999999999999999999e0 * t405 * t93 * t20 * t202 * t32 - 0.19440000000000000000000000000000000000000000000000e1 * t348 * t382)
  vlapl_0_ = 0.0e0
  t414 = t94 * t61
  t418 = t61 * t27 * t25
  t432 = t239 * (0.38880000000000000000000000000000000000000000000000e1 * t217 * t79 * t61 - 0.10800000000000000000000000000000000000000000000000e1 * t372 * t418 + 0.50388480000000000000000000000000000000000000000000e1 * t247 * t89 * t61 - 0.13996800000000000000000000000000000000000000000000e1 * t378 * t418)
  vtau_0_ = r0 * (t59 * (-0.11664000000000000000000000000000000000000000000000e2 * t217 * t414 + 0.32400000000000000000000000000000000000000000000000e1 * t365 * t418 + 0.19440000000000000000000000000000000000000000000000e1 * t71 * t432) + 0.11664000000000000000000000000000000000000000000000e2 * t345 * t414 - 0.32400000000000000000000000000000000000000000000000e1 * t405 * t93 * t61 * t27 * t20 * t24 - 0.19440000000000000000000000000000000000000000000000e1 * t348 * t432)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t11 = jnp.sqrt(t10)
  t14 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11 + 0.31385250000000000000000000000000000000000000000000e-1 * t10
  t15 = t14 ** 2
  t16 = 0.1e1 / t15
  t18 = 0.1e1 / t11 * t1
  t19 = t3 * t6
  t21 = 0.1e1 / t7 / r0
  t22 = t19 * t21
  t23 = t18 * t22
  t25 = t6 * t21
  t26 = t4 * t25
  t28 = -0.74083333333333333333333333333333333333333333333333e-2 * t23 - 0.10461750000000000000000000000000000000000000000000e-1 * t26
  t29 = t16 * t28
  t31 = 0.1e1 / t14
  t33 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t31)
  t34 = 6 ** (0.1e1 / 0.3e1)
  t35 = jnp.pi ** 2
  t36 = t35 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t38 = 0.1e1 / t37
  t39 = t34 * t38
  t40 = 2 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = t41 * s0
  t43 = r0 ** 2
  t44 = t7 ** 2
  t46 = 0.1e1 / t44 / t43
  t48 = t39 * t42 * t46
  t50 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t48
  t51 = t50 ** (0.1e1 / 0.4e1)
  t53 = 0.1e1 - 0.1e1 / t51
  t54 = t33 * t53
  t57 = t33 - 0.1e1
  t59 = 0.1e1 / t51 / t50
  t61 = t57 * t59 * t34
  t62 = t38 * t41
  t63 = t43 * r0
  t65 = 0.1e1 / t44 / t63
  t66 = s0 * t65
  t70 = -0.10000000000000000000000000000000000000000000000000e1 * t29 * t54 - 0.14225094736250905555555555555555555555555555555555e-1 * t61 * t62 * t66
  t72 = t57 * t53 + 0.1e1
  t73 = 0.1e1 / t72
  t77 = t40 - 0.1e1
  t78 = 0.1e1 <= f.p.zeta_threshold
  t79 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t81 = f.my_piecewise3(t78, t79 * f.p.zeta_threshold, 1)
  t83 = 0.2e1 * t81 - 0.2e1
  t86 = 0.1e1 / t77 / 0.2e1
  t89 = 0.1e1 - 0.2363e1 * t77 * t83 * t86
  t90 = (0.285764e-1 * t29 + 0.285764e-1 * t70 * t73) * t89
  t92 = 0.1e1 / t44 / r0
  t97 = 0.2e1 * tau0 * t92 - s0 * t46 / 0.4e1
  t98 = t97 ** 2
  t99 = t98 * t97
  t100 = t35 ** 2
  t101 = 0.1e1 / t100
  t102 = t99 * t101
  t107 = 0.8e-1 + 0.5e1 / 0.18e2 * t97 * t41 * t39 + 0.12500000000000000000000000000000000000000000000000e-1 * t48
  t108 = t107 ** 2
  t109 = t108 * t107
  t110 = 0.1e1 / t109
  t113 = t98 ** 2
  t115 = t100 ** 2
  t116 = 0.1e1 / t115
  t117 = t113 * t98 * t116
  t118 = t108 ** 2
  t120 = 0.1e1 / t118 / t108
  t123 = 0.1e1 + 0.64800000000000000000000000000000000000000000000000e0 * t102 * t110 + 0.41990400000000000000000000000000000000000000000000e0 * t117 * t120
  t124 = 0.1e1 / t123
  t125 = t110 * t124
  t128 = 0.1e1 - 0.19440000000000000000000000000000000000000000000000e1 * t102 * t125
  t132 = jnp.log(t72)
  t135 = (-0.285764e-1 * t31 + 0.285764e-1 * t132) * t89
  t136 = t98 * t101
  t140 = -0.10e2 / 0.3e1 * tau0 * t46 + 0.2e1 / 0.3e1 * t66
  t141 = t125 * t140
  t144 = 0.1e1 / t118
  t145 = t144 * t124
  t150 = t39 * t42 * t65
  t152 = 0.5e1 / 0.18e2 * t140 * t41 * t39 - 0.33333333333333333333333333333333333333333333333333e-1 * t150
  t153 = t145 * t152
  t156 = t123 ** 2
  t157 = 0.1e1 / t156
  t158 = t110 * t157
  t166 = t113 * t97 * t116
  t171 = 0.1e1 / t118 / t109
  t175 = 0.19440000000000000000000000000000000000000000000000e1 * t136 * t110 * t140 - 0.19440000000000000000000000000000000000000000000000e1 * t102 * t144 * t152 + 0.25194240000000000000000000000000000000000000000000e1 * t166 * t120 * t140 - 0.25194240000000000000000000000000000000000000000000e1 * t117 * t171 * t152
  t176 = t158 * t175
  t179 = -0.58320000000000000000000000000000000000000000000000e1 * t136 * t141 + 0.58320000000000000000000000000000000000000000000000e1 * t102 * t153 + 0.19440000000000000000000000000000000000000000000000e1 * t102 * t176
  t184 = t10 ** 0.15e1
  t186 = t1 ** 2
  t187 = t3 ** 2
  t188 = t186 * t187
  t191 = t188 * t5 / t44
  t193 = 0.37978500000000000000000000000000000000000000000000e1 * t11 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t184 + 0.12323500000000000000000000000000000000000000000000e0 * t191
  t196 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t193
  t197 = jnp.log(t196)
  t200 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t25 * t197
  t202 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t203 = t193 ** 2
  t204 = 0.1e1 / t203
  t205 = t202 * t204
  t208 = t10 ** 0.5e0
  t209 = t208 * t1
  t210 = t209 * t22
  t213 = t188 * t5 * t92
  t215 = -0.63297500000000000000000000000000000000000000000000e0 * t23 - 0.29896666666666666666666666666666666666666666666667e0 * t26 - 0.10238750000000000000000000000000000000000000000000e0 * t210 - 0.82156666666666666666666666666666666666666666666667e-1 * t213
  t216 = 0.1e1 / t196
  t217 = t215 * t216
  t219 = 0.10000000000000000000000000000000000000000000000000e1 * t205 * t217
  t220 = t83 * t86
  t221 = t220 * t1
  t226 = 0.51785000000000000000000000000000000000000000000000e1 * t11 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t184 + 0.12417750000000000000000000000000000000000000000000e0 * t191
  t229 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t226
  t230 = jnp.log(t229)
  t234 = 0.18311447306006545054854346104378990962041954983034e-3 * t221 * t19 * t21 * t230
  t236 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t237 = t220 * t236
  t238 = t226 ** 2
  t239 = 0.1e1 / t238
  t244 = -0.86308333333333333333333333333333333333333333333334e0 * t23 - 0.30192500000000000000000000000000000000000000000000e0 * t26 - 0.55016250000000000000000000000000000000000000000000e-1 * t210 - 0.82785000000000000000000000000000000000000000000000e-1 * t213
  t246 = 0.1e1 / t229
  t247 = t239 * t244 * t246
  t249 = 0.58482236226346462072622386637590534819724553404280e0 * t237 * t247
  t250 = t79 ** 2
  t251 = f.my_piecewise3(t78, t250, 1)
  t252 = t251 ** 2
  t253 = t252 * t251
  t254 = t200 + t219 - t234 - t249
  t255 = 0.1e1 / t253
  t256 = t254 * t255
  t258 = 0.621814e-1 * t202 * t197
  t261 = 0.19751673498613801407483339618206552048944131217655e-1 * t220 * t236 * t230
  t262 = -t258 + t261
  t265 = jnp.exp(-0.32163648644302209642661863561802450870026695828375e2 * t262 * t255)
  t266 = jnp.log(0.2e1)
  t267 = 0.1e1 - t266
  t268 = 0.1e1 / t267
  t269 = t268 * t35
  t273 = jnp.exp(-t262 * t268 * t35 * t255)
  t274 = t273 - 0.1e1
  t276 = 0.1e1 / t274 * s0
  t278 = 0.1e1 / t7 / t43
  t283 = 0.1e1 / t3
  t286 = t40 / t252 * t186 * t283 * t5
  t289 = 0.1e1 + 0.27802083333333333333333333333333333333333333333333e-2 * t269 * t276 * t278 * t286
  t290 = t289 ** (0.1e1 / 0.4e1)
  t292 = 0.1e1 - 0.1e1 / t290
  t293 = t265 * t292
  t296 = t265 - 0.1e1
  t298 = 0.1e1 / t290 / t289
  t299 = t296 * t298
  t300 = t267 ** 2
  t303 = t274 ** 2
  t304 = 0.1e1 / t303
  t305 = 0.1e1 / t300 * t100 * t304
  t307 = s0 * t278 * t40
  t308 = t305 * t307
  t309 = t252 ** 2
  t313 = 0.1e1 / t309 / t251 * t186 * t283
  t316 = t313 * t5 * t254 * t273
  t320 = 0.1e1 / t7 / t63
  t325 = 0.27802083333333333333333333333333333333333333333333e-2 * t308 * t316 - 0.64871527777777777777777777777777777777777777777777e-2 * t269 * t276 * t320 * t286
  t328 = -0.32163648644302209642661863561802450870026695828375e2 * t256 * t293 + t299 * t325 / 0.4e1
  t331 = t296 * t292 + 0.1e1
  t332 = 0.1e1 / t331
  t335 = t200 + t219 - t234 - t249 + 0.31091e-1 * t253 * t328 * t332
  t336 = t335 * t99
  t338 = t101 * t110 * t124
  t341 = jnp.log(t331)
  t344 = -t258 + t261 + 0.31091e-1 * t253 * t341
  t346 = t344 * t98 * t101
  t350 = t344 * t99 * t101
  t357 = t28 ** 2
  t358 = 0.1e1 / t15 / t14 * t357
  t364 = t187 * t5 * t46
  t365 = 0.1e1 / t11 / t10 * t186 * t364
  t367 = t19 * t278
  t368 = t18 * t367
  t370 = t6 * t278
  t371 = t4 * t370
  t374 = t16 * (-0.49388888888888888888888888888888888888888888888889e-2 * t365 + 0.98777777777777777777777777777777777777777777777777e-2 * t368 + 0.13949000000000000000000000000000000000000000000000e-1 * t371)
  t380 = t15 ** 2
  t389 = t50 ** 2
  t393 = t34 ** 2
  t398 = s0 ** 2
  t399 = t43 ** 2
  t408 = 0.1e1 / t44 / t399
  t409 = s0 * t408
  t416 = t70 ** 2
  t417 = t72 ** 2
  t426 = t97 * t101
  t427 = t140 ** 2
  t428 = t125 * t427
  t444 = 0.80e2 / 0.9e1 * tau0 * t65 - 0.22e2 / 0.9e1 * t409
  t445 = t125 * t444
  t449 = 0.1e1 / t118 / t107
  t451 = t152 ** 2
  t452 = t449 * t124 * t451
  t466 = 0.5e1 / 0.18e2 * t444 * t41 * t39 + 0.12222222222222222222222222222222222222222222222222e0 * t39 * t42 * t408
  t467 = t145 * t466
  t473 = t175 ** 2
  t474 = t110 / t156 / t123 * t473
  t504 = t118 ** 2
  t513 = t158 * (0.38880000000000000000000000000000000000000000000000e1 * t426 * t110 * t427 - 0.11664000000000000000000000000000000000000000000000e2 * t136 * t144 * t140 * t152 + 0.19440000000000000000000000000000000000000000000000e1 * t136 * t110 * t444 + 0.77760000000000000000000000000000000000000000000000e1 * t102 * t449 * t451 - 0.19440000000000000000000000000000000000000000000000e1 * t102 * t144 * t466 + 0.12597120000000000000000000000000000000000000000000e2 * t113 * t116 * t120 * t427 - 0.30233088000000000000000000000000000000000000000000e2 * t166 * t171 * t140 * t152 + 0.25194240000000000000000000000000000000000000000000e1 * t166 * t120 * t444 + 0.17635968000000000000000000000000000000000000000000e2 * t117 / t504 * t451 - 0.25194240000000000000000000000000000000000000000000e1 * t117 * t171 * t466)
  t520 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t370 * t197
  t525 = 0.35616666666666666666666666666666666666666666666666e-1 * t4 * t6 * t21 * t204 * t217
  t529 = t215 ** 2
  t532 = 0.20000000000000000000000000000000000000000000000000e1 * t202 / t203 / t193 * t529 * t216
  t536 = t10 ** (-0.5e0)
  t538 = t536 * t186 * t364
  t540 = t209 * t367
  t543 = t188 * t5 * t46
  t548 = 0.10000000000000000000000000000000000000000000000000e1 * t205 * (-0.42198333333333333333333333333333333333333333333333e0 * t365 + 0.84396666666666666666666666666666666666666666666666e0 * t368 + 0.39862222222222222222222222222222222222222222222223e0 * t371 + 0.68258333333333333333333333333333333333333333333333e-1 * t538 + 0.13651666666666666666666666666666666666666666666667e0 * t540 + 0.13692777777777777777777777777777777777777777777778e0 * t543) * t216
  t549 = t203 ** 2
  t552 = t196 ** 2
  t556 = 0.16081979498692535066756296899072713062105388428051e2 * t202 / t549 * t529 / t552
  t560 = 0.24415263074675393406472461472505321282722606644045e-3 * t221 * t19 * t278 * t230
  t564 = 0.10843581300301739842632067522386578331157260943710e-1 * t220 * t4 * t25 * t247
  t567 = t244 ** 2
  t571 = 0.11696447245269292414524477327518106963944910680856e1 * t237 / t238 / t226 * t567 * t246
  t582 = 0.58482236226346462072622386637590534819724553404280e0 * t237 * t239 * (-0.57538888888888888888888888888888888888888888888889e0 * t365 + 0.11507777777777777777777777777777777777777777777778e1 * t368 + 0.40256666666666666666666666666666666666666666666667e0 * t371 + 0.36677500000000000000000000000000000000000000000000e-1 * t538 + 0.73355000000000000000000000000000000000000000000000e-1 * t540 + 0.13797500000000000000000000000000000000000000000000e0 * t543) * t246
  t583 = t238 ** 2
  t586 = t229 ** 2
  t590 = 0.17315859105681463759666483083807725165579399831905e2 * t237 / t583 * t567 / t586
  t591 = -t520 - t525 - t532 + t548 + t556 + t560 + t564 + t571 - t582 - t590
  t595 = t254 ** 2
  t605 = t289 ** 2
  t609 = t325 ** 2
  t615 = 0.1e1 / t300 / t267 * t100 * t35
  t620 = t309 ** 2
  t623 = 0.1e1 / t620 * t186 * t283
  t624 = t5 * t595
  t625 = t273 ** 2
  t659 = t328 ** 2
  t661 = t331 ** 2
  t665 = -t520 - t525 - t532 + t548 + t556 + t560 + t564 + t571 - t582 - t590 + 0.31091e-1 * t253 * (-0.32163648644302209642661863561802450870026695828375e2 * t591 * t255 * t293 + 0.10345002941141233682629012756682786295077899015270e4 * t595 / t309 / t252 * t293 - 0.16081824322151104821330931780901225435013347914188e2 * t256 * t265 * t298 * t325 - 0.5e1 / 0.16e2 * t296 / t290 / t605 * t609 + t299 * (0.55604166666666666666666666666666666666666666666666e-2 * t615 / t303 / t274 * t307 * t623 * t624 * t625 - 0.12974305555555555555555555555555555555555555555555e-1 * t305 * s0 * t320 * t40 * t316 + 0.27802083333333333333333333333333333333333333333333e-2 * t308 * t313 * t5 * t591 * t273 - 0.27802083333333333333333333333333333333333333333333e-2 * t615 * t304 * t307 * t623 * t624 * t273 + 0.21623842592592592592592592592592592592592592592592e-1 * t269 * t276 / t7 / t399 * t286) / 0.4e1) * t332 - 0.31091e-1 * t253 * t659 / t661
  t673 = t336 * t101
  t705 = (-0.571528e-1 * t358 + 0.285764e-1 * t374 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t358 * t54 - 0.10000000000000000000000000000000000000000000000000e1 * t374 * t54 + 0.10000000000000000000000000000000000000000000000000e1 / t380 * t357 * t54 + 0.28450189472501811111111111111111111111111111111110e-1 * t29 * t33 * t59 * t150 - 0.20235332025531322029119593137558641975308641975307e-2 * t57 / t51 / t389 * t393 / t36 / t35 * t40 * t398 / t7 / t399 / t63 + 0.52158680699586653703703703703703703703703703703702e-1 * t61 * t62 * t409) * t73 - 0.285764e-1 * t416 / t417) * t89 * t128 + 0.2e1 * t90 * t179 + t135 * (-0.11664000000000000000000000000000000000000000000000e2 * t426 * t428 + 0.34992000000000000000000000000000000000000000000000e2 * t136 * t144 * t124 * t140 * t152 + 0.11664000000000000000000000000000000000000000000000e2 * t136 * t110 * t157 * t140 * t175 - 0.58320000000000000000000000000000000000000000000000e1 * t136 * t445 - 0.23328000000000000000000000000000000000000000000000e2 * t102 * t452 - 0.11664000000000000000000000000000000000000000000000e2 * t102 * t144 * t157 * t152 * t175 + 0.58320000000000000000000000000000000000000000000000e1 * t102 * t467 - 0.38880000000000000000000000000000000000000000000000e1 * t102 * t474 + 0.19440000000000000000000000000000000000000000000000e1 * t102 * t513) + 0.19440000000000000000000000000000000000000000000000e1 * t665 * t99 * t338 + 0.11664000000000000000000000000000000000000000000000e2 * t335 * t98 * t101 * t141 - 0.11664000000000000000000000000000000000000000000000e2 * t673 * t153 - 0.38880000000000000000000000000000000000000000000000e1 * t673 * t176 + 0.11664000000000000000000000000000000000000000000000e2 * t344 * t97 * t101 * t428 - 0.34992000000000000000000000000000000000000000000000e2 * t346 * t145 * t140 * t152 - 0.11664000000000000000000000000000000000000000000000e2 * t346 * t158 * t140 * t175 + 0.58320000000000000000000000000000000000000000000000e1 * t346 * t445 + 0.23328000000000000000000000000000000000000000000000e2 * t350 * t452 + 0.11664000000000000000000000000000000000000000000000e2 * t350 * t144 * t157 * t152 * t175 - 0.58320000000000000000000000000000000000000000000000e1 * t350 * t467 + 0.38880000000000000000000000000000000000000000000000e1 * t350 * t474 - 0.19440000000000000000000000000000000000000000000000e1 * t350 * t513
  v2rho2_0_ = 0.2e1 * t90 * t128 + 0.2e1 * t135 * t179 + 0.38880000000000000000000000000000000000000000000000e1 * t336 * t338 + 0.11664000000000000000000000000000000000000000000000e2 * t346 * t141 - 0.11664000000000000000000000000000000000000000000000e2 * t350 * t153 - 0.38880000000000000000000000000000000000000000000000e1 * t350 * t176 + r0 * t705
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t34 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t53 = 0.1e1 / t22 / r0
  t55 = t21 * t5 * t53
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t61 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t67 = 0.2e1 * t65 - 0.2e1
  t68 = 2 ** (0.1e1 / 0.3e1)
  t69 = t68 - 0.1e1
  t71 = 0.1e1 / t69 / 0.2e1
  t72 = t67 * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t86 = 0.18311447306006545054854346104378990962041954983034e-3 * t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t101 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t99
  t102 = t63 ** 2
  t103 = f.my_piecewise3(t62, t102, 1)
  t104 = t103 ** 2
  t105 = t104 * t103
  t106 = t34 + t61 - t86 - t101
  t107 = 0.1e1 / t105
  t108 = t106 * t107
  t110 = 0.621814e-1 * t36 * t31
  t113 = 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82
  t114 = -t110 + t113
  t117 = jnp.exp(-0.32163648644302209642661863561802450870026695828375e2 * t114 * t107)
  t118 = jnp.log(0.2e1)
  t119 = 0.1e1 - t118
  t120 = 0.1e1 / t119
  t121 = jnp.pi ** 2
  t122 = t120 * t121
  t126 = jnp.exp(-t114 * t120 * t121 * t107)
  t127 = t126 - 0.1e1
  t129 = 0.1e1 / t127 * s0
  t130 = r0 ** 2
  t132 = 0.1e1 / t7 / t130
  t137 = 0.1e1 / t3
  t140 = t68 / t104 * t19 * t137 * t5
  t143 = 0.1e1 + 0.27802083333333333333333333333333333333333333333333e-2 * t122 * t129 * t132 * t140
  t144 = t143 ** (0.1e1 / 0.4e1)
  t146 = 0.1e1 - 0.1e1 / t144
  t147 = t117 * t146
  t150 = t117 - 0.1e1
  t152 = 0.1e1 / t144 / t143
  t153 = t150 * t152
  t154 = t119 ** 2
  t156 = t121 ** 2
  t158 = t127 ** 2
  t159 = 0.1e1 / t158
  t160 = 0.1e1 / t154 * t156 * t159
  t162 = s0 * t132 * t68
  t163 = t160 * t162
  t164 = t104 ** 2
  t168 = 0.1e1 / t164 / t103 * t19 * t137
  t169 = t5 * t106
  t171 = t168 * t169 * t126
  t174 = t130 * r0
  t176 = 0.1e1 / t7 / t174
  t181 = 0.27802083333333333333333333333333333333333333333333e-2 * t163 * t171 - 0.64871527777777777777777777777777777777777777777777e-2 * t122 * t129 * t176 * t140
  t184 = -0.32163648644302209642661863561802450870026695828375e2 * t108 * t147 + t153 * t181 / 0.4e1
  t187 = t150 * t146 + 0.1e1
  t188 = 0.1e1 / t187
  t191 = t34 + t61 - t86 - t101 + 0.31091e-1 * t105 * t184 * t188
  t195 = 0.1e1 / t22 / t130
  t198 = 0.2e1 * tau0 * t53 - s0 * t195 / 0.4e1
  t200 = 0.1e1 / t156
  t201 = t191 * t198 * t200
  t202 = t68 ** 2
  t204 = 6 ** (0.1e1 / 0.3e1)
  t205 = t121 ** (0.1e1 / 0.3e1)
  t206 = t205 ** 2
  t207 = 0.1e1 / t206
  t208 = t204 * t207
  t211 = t202 * s0
  t213 = t208 * t211 * t195
  t215 = 0.8e-1 + 0.5e1 / 0.18e2 * t198 * t202 * t208 + 0.12500000000000000000000000000000000000000000000000e-1 * t213
  t216 = t215 ** 2
  t217 = t216 * t215
  t218 = 0.1e1 / t217
  t219 = t198 ** 2
  t220 = t219 * t198
  t221 = t220 * t200
  t222 = t221 * t218
  t224 = t219 ** 2
  t226 = t156 ** 2
  t227 = 0.1e1 / t226
  t228 = t224 * t219 * t227
  t229 = t216 ** 2
  t231 = 0.1e1 / t229 / t216
  t234 = 0.1e1 + 0.64800000000000000000000000000000000000000000000000e0 * t222 + 0.41990400000000000000000000000000000000000000000000e0 * t228 * t231
  t235 = 0.1e1 / t234
  t236 = t218 * t235
  t240 = 0.1e1 / t22 / t174
  t241 = s0 * t240
  t243 = -0.10e2 / 0.3e1 * tau0 * t195 + 0.2e1 / 0.3e1 * t241
  t244 = t243 ** 2
  t245 = t236 * t244
  t248 = jnp.log(t187)
  t251 = -t110 + t113 + 0.31091e-1 * t105 * t248
  t252 = t251 * t220
  t253 = t252 * t200
  t254 = 0.1e1 / t229
  t255 = t254 * t235
  t256 = t130 ** 2
  t258 = 0.1e1 / t22 / t256
  t261 = t256 * r0
  t263 = 0.1e1 / t22 / t261
  t264 = s0 * t263
  t266 = -0.880e3 / 0.27e2 * tau0 * t258 + 0.308e3 / 0.27e2 * t264
  t271 = t208 * t211 * t263
  t273 = 0.5e1 / 0.18e2 * t266 * t202 * t208 - 0.57037037037037037037037037037037037037037037037036e0 * t271
  t274 = t255 * t273
  t277 = t234 ** 2
  t278 = 0.1e1 / t277
  t279 = t218 * t278
  t280 = t254 * t273
  t284 = t224 * t198 * t227
  t285 = t231 * t266
  t289 = 0.1e1 / t229 / t217
  t290 = t289 * t273
  t293 = t244 * t243
  t294 = t293 * t200
  t297 = t219 * t200
  t298 = t218 * t266
  t301 = t289 * t243
  t304 = s0 * t258
  t306 = 0.80e2 / 0.9e1 * tau0 * t240 - 0.22e2 / 0.9e1 * t304
  t311 = t208 * t211 * t258
  t313 = 0.5e1 / 0.18e2 * t306 * t202 * t208 + 0.12222222222222222222222222222222222222222222222222e0 * t311
  t317 = t229 ** 2
  t319 = 0.1e1 / t317 / t215
  t324 = t208 * t211 * t240
  t326 = 0.5e1 / 0.18e2 * t243 * t202 * t208 - 0.33333333333333333333333333333333333333333333333333e-1 * t324
  t327 = t326 ** 2
  t328 = t327 * t326
  t329 = t319 * t328
  t332 = 0.1e1 / t317
  t337 = t231 * t328
  t341 = 0.1e1 / t229 / t215
  t346 = t220 * t227
  t350 = t224 * t227
  t351 = t289 * t244
  t355 = t231 * t243
  t359 = t289 * t306
  t363 = t198 * t200
  t364 = t254 * t244
  t368 = t218 * t243
  t372 = t254 * t306
  t376 = t254 * t243
  t388 = -0.19440000000000000000000000000000000000000000000000e1 * t221 * t280 + 0.25194240000000000000000000000000000000000000000000e1 * t284 * t285 - 0.25194240000000000000000000000000000000000000000000e1 * t228 * t290 + 0.38880000000000000000000000000000000000000000000000e1 * t294 * t218 + 0.19440000000000000000000000000000000000000000000000e1 * t297 * t298 - 0.45349632000000000000000000000000000000000000000000e2 * t284 * t301 * t313 - 0.14108774400000000000000000000000000000000000000000e3 * t228 * t329 + 0.52907904000000000000000000000000000000000000000000e2 * t228 * t332 * t326 * t313 - 0.38880000000000000000000000000000000000000000000000e2 * t221 * t337 + 0.23328000000000000000000000000000000000000000000000e2 * t221 * t341 * t326 * t313 + 0.50388480000000000000000000000000000000000000000000e2 * t346 * t231 * t293 - 0.22674816000000000000000000000000000000000000000000e3 * t350 * t351 * t326 + 0.37791360000000000000000000000000000000000000000000e2 * t350 * t355 * t306 - 0.45349632000000000000000000000000000000000000000000e2 * t284 * t359 * t326 - 0.34992000000000000000000000000000000000000000000000e2 * t363 * t364 * t326 + 0.11664000000000000000000000000000000000000000000000e2 * t363 * t368 * t306 - 0.17496000000000000000000000000000000000000000000000e2 * t297 * t372 * t326 - 0.17496000000000000000000000000000000000000000000000e2 * t297 * t376 * t313 + 0.31744742400000000000000000000000000000000000000000e3 * t284 * t332 * t243 * t327 + 0.69984000000000000000000000000000000000000000000000e2 * t297 * t341 * t243 * t327
  t389 = t279 * t388
  t392 = t6 * t132
  t395 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t392 * t31
  t396 = t4 * t6
  t397 = t9 * t38
  t400 = 0.35616666666666666666666666666666666666666666666666e-1 * t396 * t397 * t59
  t401 = t37 * t27
  t402 = 0.1e1 / t401
  t403 = t36 * t402
  t404 = t57 ** 2
  t405 = t404 * t58
  t407 = 0.20000000000000000000000000000000000000000000000000e1 * t403 * t405
  t410 = 0.1e1 / t14 / t13 * t19
  t411 = t20 * t5
  t412 = t411 * t195
  t413 = t410 * t412
  t415 = t42 * t132
  t416 = t41 * t415
  t418 = t4 * t392
  t420 = t13 ** (-0.5e0)
  t421 = t420 * t19
  t422 = t421 * t412
  t424 = t49 * t415
  t427 = t21 * t5 * t195
  t429 = -0.42198333333333333333333333333333333333333333333333e0 * t413 + 0.84396666666666666666666666666666666666666666666666e0 * t416 + 0.39862222222222222222222222222222222222222222222223e0 * t418 + 0.68258333333333333333333333333333333333333333333333e-1 * t422 + 0.13651666666666666666666666666666666666666666666667e0 * t424 + 0.13692777777777777777777777777777777777777777777778e0 * t427
  t430 = t429 * t58
  t432 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * t430
  t433 = t37 ** 2
  t434 = 0.1e1 / t433
  t435 = t36 * t434
  t436 = t30 ** 2
  t437 = 0.1e1 / t436
  t438 = t404 * t437
  t440 = 0.16081979498692535066756296899072713062105388428051e2 * t435 * t438
  t444 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t132 * t82
  t445 = t72 * t4
  t448 = 0.10843581300301739842632067522386578331157260943710e-1 * t445 * t10 * t99
  t449 = t90 * t78
  t450 = 0.1e1 / t449
  t451 = t96 ** 2
  t453 = t450 * t451 * t98
  t455 = 0.11696447245269292414524477327518106963944910680856e1 * t89 * t453
  t462 = -0.57538888888888888888888888888888888888888888888889e0 * t413 + 0.11507777777777777777777777777777777777777777777778e1 * t416 + 0.40256666666666666666666666666666666666666666666667e0 * t418 + 0.36677500000000000000000000000000000000000000000000e-1 * t422 + 0.73355000000000000000000000000000000000000000000000e-1 * t424 + 0.13797500000000000000000000000000000000000000000000e0 * t427
  t464 = t91 * t462 * t98
  t466 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t464
  t467 = t90 ** 2
  t468 = 0.1e1 / t467
  t469 = t468 * t451
  t470 = t81 ** 2
  t471 = 0.1e1 / t470
  t472 = t469 * t471
  t474 = 0.17315859105681463759666483083807725165579399831905e2 * t89 * t472
  t475 = -t395 - t400 - t407 + t432 + t440 + t444 + t448 + t455 - t466 - t474
  t476 = t475 * t107
  t479 = t106 ** 2
  t480 = t164 * t104
  t481 = 0.1e1 / t480
  t482 = t479 * t481
  t485 = t117 * t152
  t486 = t485 * t181
  t489 = t143 ** 2
  t491 = 0.1e1 / t144 / t489
  t492 = t150 * t491
  t493 = t181 ** 2
  t499 = 0.1e1 / t154 / t119 * t156 * t121
  t501 = 0.1e1 / t158 / t127
  t502 = t499 * t501
  t503 = t502 * t162
  t504 = t164 ** 2
  t507 = 0.1e1 / t504 * t19 * t137
  t508 = t5 * t479
  t509 = t126 ** 2
  t511 = t507 * t508 * t509
  t515 = s0 * t176 * t68
  t516 = t160 * t515
  t519 = t5 * t475
  t521 = t168 * t519 * t126
  t524 = t499 * t159
  t525 = t524 * t162
  t527 = t507 * t508 * t126
  t531 = 0.1e1 / t7 / t256
  t536 = 0.55604166666666666666666666666666666666666666666666e-2 * t503 * t511 - 0.12974305555555555555555555555555555555555555555555e-1 * t516 * t171 + 0.27802083333333333333333333333333333333333333333333e-2 * t163 * t521 - 0.27802083333333333333333333333333333333333333333333e-2 * t525 * t527 + 0.21623842592592592592592592592592592592592592592592e-1 * t122 * t129 * t531 * t140
  t539 = -0.32163648644302209642661863561802450870026695828375e2 * t476 * t147 + 0.10345002941141233682629012756682786295077899015270e4 * t482 * t147 - 0.16081824322151104821330931780901225435013347914188e2 * t108 * t486 - 0.5e1 / 0.16e2 * t492 * t493 + t153 * t536 / 0.4e1
  t540 = t105 * t539
  t543 = t184 ** 2
  t545 = t187 ** 2
  t546 = 0.1e1 / t545
  t549 = -t395 - t400 - t407 + t432 + t440 + t444 + t448 + t455 - t466 - t474 + 0.31091e-1 * t540 * t188 - 0.31091e-1 * t105 * t543 * t546
  t551 = t549 * t219 * t200
  t552 = t236 * t243
  t555 = t251 * t219
  t556 = t555 * t200
  t557 = t236 * t266
  t561 = t191 * t220 * t200
  t562 = t255 * t313
  t565 = t191 * t219
  t566 = t565 * t200
  t567 = t236 * t306
  t576 = t218 * t306
  t585 = t231 * t244
  t600 = 0.38880000000000000000000000000000000000000000000000e1 * t363 * t218 * t244 - 0.11664000000000000000000000000000000000000000000000e2 * t297 * t376 * t326 + 0.19440000000000000000000000000000000000000000000000e1 * t297 * t576 + 0.77760000000000000000000000000000000000000000000000e1 * t221 * t341 * t327 - 0.19440000000000000000000000000000000000000000000000e1 * t221 * t254 * t313 + 0.12597120000000000000000000000000000000000000000000e2 * t350 * t585 - 0.30233088000000000000000000000000000000000000000000e2 * t284 * t301 * t326 + 0.25194240000000000000000000000000000000000000000000e1 * t284 * t231 * t306 + 0.17635968000000000000000000000000000000000000000000e2 * t228 * t332 * t327 - 0.25194240000000000000000000000000000000000000000000e1 * t228 * t289 * t313
  t601 = t279 * t600
  t604 = t254 * t278
  t607 = t254 * t326
  t615 = 0.19440000000000000000000000000000000000000000000000e1 * t297 * t368 - 0.19440000000000000000000000000000000000000000000000e1 * t221 * t607 + 0.25194240000000000000000000000000000000000000000000e1 * t284 * t355 - 0.25194240000000000000000000000000000000000000000000e1 * t228 * t289 * t326
  t616 = t326 * t615
  t617 = t604 * t616
  t620 = t341 * t235
  t622 = t620 * t243 * t327
  t626 = 0.1e1 / t277 / t234
  t627 = t218 * t626
  t628 = t615 ** 2
  t630 = t627 * t243 * t628
  t633 = t254 * t626
  t634 = t326 * t628
  t635 = t633 * t634
  t638 = t243 * t615
  t639 = t279 * t638
  t643 = t627 * t615 * t600
  t646 = t341 * t278
  t648 = t646 * t327 * t615
  t651 = t326 * t313
  t652 = t620 * t651
  t655 = t313 * t615
  t656 = t604 * t655
  t659 = t326 * t600
  t660 = t604 * t659
  t663 = t251 * t198
  t664 = t663 * t200
  t666 = t255 * t244 * t326
  t670 = t279 * t244 * t615
  t673 = 0.13996800000000000000000000000000000000000000000000e3 * t201 * t245 - 0.23328000000000000000000000000000000000000000000000e2 * t253 * t274 - 0.77760000000000000000000000000000000000000000000000e1 * t253 * t389 + 0.69984000000000000000000000000000000000000000000000e2 * t551 * t552 + 0.23328000000000000000000000000000000000000000000000e2 * t556 * t557 - 0.69984000000000000000000000000000000000000000000000e2 * t561 * t562 + 0.69984000000000000000000000000000000000000000000000e2 * t566 * t567 - 0.23328000000000000000000000000000000000000000000000e2 * t561 * t601 + 0.13996800000000000000000000000000000000000000000000e3 * t561 * t617 + 0.83980800000000000000000000000000000000000000000000e3 * t556 * t622 + 0.13996800000000000000000000000000000000000000000000e3 * t556 * t630 - 0.13996800000000000000000000000000000000000000000000e3 * t253 * t635 - 0.13996800000000000000000000000000000000000000000000e3 * t566 * t639 + 0.46656000000000000000000000000000000000000000000000e2 * t253 * t643 - 0.27993600000000000000000000000000000000000000000000e3 * t253 * t648 + 0.27993600000000000000000000000000000000000000000000e3 * t253 * t652 + 0.69984000000000000000000000000000000000000000000000e2 * t253 * t656 + 0.69984000000000000000000000000000000000000000000000e2 * t253 * t660 - 0.41990400000000000000000000000000000000000000000000e3 * t664 * t666 - 0.13996800000000000000000000000000000000000000000000e3 * t664 * t670
  t675 = t236 * t243 * t306
  t678 = t306 * t326
  t679 = t255 * t678
  t682 = t243 * t313
  t683 = t255 * t682
  t687 = t279 * t306 * t615
  t690 = t243 * t600
  t691 = t279 * t690
  t695 = t549 * t220 * t200
  t696 = t255 * t326
  t699 = t279 * t615
  t702 = t277 ** 2
  t703 = 0.1e1 / t702
  t704 = t218 * t703
  t705 = t628 * t615
  t706 = t704 * t705
  t709 = t231 * t235
  t710 = t709 * t328
  t715 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14 + 0.31385250000000000000000000000000000000000000000000e-1 * t13
  t716 = t715 ** 2
  t717 = t716 * t715
  t718 = 0.1e1 / t717
  t721 = -0.74083333333333333333333333333333333333333333333333e-2 * t44 - 0.10461750000000000000000000000000000000000000000000e-1 * t46
  t722 = t721 ** 2
  t723 = t718 * t722
  t725 = 0.1e1 / t716
  t729 = -0.49388888888888888888888888888888888888888888888889e-2 * t413 + 0.98777777777777777777777777777777777777777777777777e-2 * t416 + 0.13949000000000000000000000000000000000000000000000e-1 * t418
  t730 = t725 * t729
  t732 = 0.1e1 / t715
  t734 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t732)
  t736 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t213
  t737 = t736 ** (0.1e1 / 0.4e1)
  t739 = 0.1e1 - 0.1e1 / t737
  t740 = t734 * t739
  t745 = t716 ** 2
  t746 = 0.1e1 / t745
  t747 = t746 * t722
  t750 = t725 * t721
  t752 = 0.1e1 / t737 / t736
  t753 = t734 * t752
  t754 = t750 * t753
  t757 = t734 - 0.1e1
  t758 = t736 ** 2
  t760 = 0.1e1 / t737 / t758
  t762 = t204 ** 2
  t763 = t757 * t760 * t762
  t765 = 0.1e1 / t205 / t121
  t766 = t765 * t68
  t767 = s0 ** 2
  t770 = 0.1e1 / t7 / t256 / t174
  t776 = t757 * t752 * t204
  t777 = t207 * t202
  t781 = 0.20000000000000000000000000000000000000000000000000e1 * t723 * t740 - 0.10000000000000000000000000000000000000000000000000e1 * t730 * t740 + 0.10000000000000000000000000000000000000000000000000e1 * t747 * t740 + 0.28450189472501811111111111111111111111111111111110e-1 * t754 * t324 - 0.20235332025531322029119593137558641975308641975307e-2 * t763 * t766 * t767 * t770 + 0.52158680699586653703703703703703703703703703703702e-1 * t776 * t777 * t304
  t783 = t757 * t739 + 0.1e1
  t784 = 0.1e1 / t783
  t792 = -0.10000000000000000000000000000000000000000000000000e1 * t750 * t740 - 0.14225094736250905555555555555555555555555555555555e-1 * t776 * t777 * t241
  t793 = t792 ** 2
  t794 = t783 ** 2
  t795 = 0.1e1 / t794
  t802 = 0.1e1 - 0.2363e1 * t69 * t67 * t71
  t803 = (-0.571528e-1 * t723 + 0.285764e-1 * t730 + 0.285764e-1 * t781 * t784 - 0.285764e-1 * t793 * t795) * t802
  t810 = -0.58320000000000000000000000000000000000000000000000e1 * t297 * t552 + 0.58320000000000000000000000000000000000000000000000e1 * t221 * t696 + 0.19440000000000000000000000000000000000000000000000e1 * t221 * t699
  t817 = t297 * t254
  t818 = t235 * t243
  t822 = t297 * t218
  t823 = t278 * t243
  t829 = t620 * t327
  t832 = t221 * t254
  t833 = t278 * t326
  t839 = t627 * t628
  t844 = -0.11664000000000000000000000000000000000000000000000e2 * t363 * t245 + 0.34992000000000000000000000000000000000000000000000e2 * t817 * t818 * t326 + 0.11664000000000000000000000000000000000000000000000e2 * t822 * t823 * t615 - 0.58320000000000000000000000000000000000000000000000e1 * t297 * t567 - 0.23328000000000000000000000000000000000000000000000e2 * t221 * t829 - 0.11664000000000000000000000000000000000000000000000e2 * t832 * t833 * t615 + 0.58320000000000000000000000000000000000000000000000e1 * t221 * t562 - 0.38880000000000000000000000000000000000000000000000e1 * t221 * t839 + 0.19440000000000000000000000000000000000000000000000e1 * t221 * t601
  t847 = t132 * t38
  t850 = 0.71233333333333333333333333333333333333333333333331e-1 * t396 * t847 * t59
  t852 = 0.1e1 / t467 / t78
  t853 = t451 * t96
  t855 = t852 * t853 * t471
  t857 = 0.10389515463408878255799889850284635099347639899143e3 * t89 * t855
  t859 = t468 * t853 * t98
  t861 = 0.35089341735807877243573431982554320891834732042568e1 * t89 * t859
  t863 = 0.1e1 / t467 / t90
  t866 = 0.1e1 / t470 / t81
  t867 = t863 * t853 * t866
  t869 = 0.10254018858216406658218194626490193680059335835414e4 * t89 * t867
  t873 = 0.1e1 / t14 / t25 * t2 / 0.4e1
  t874 = 0.1e1 / t256
  t875 = t873 * t874
  t877 = t411 * t240
  t878 = t410 * t877
  t880 = t42 * t176
  t881 = t41 * t880
  t883 = t6 * t176
  t884 = t4 * t883
  t886 = t13 ** (-0.15e1)
  t887 = t886 * t2
  t888 = t887 * t874
  t890 = t421 * t877
  t892 = t49 * t880
  t895 = t21 * t5 * t240
  t897 = -0.34523333333333333333333333333333333333333333333333e1 * t875 + 0.23015555555555555555555555555555555555555555555556e1 * t878 - 0.26851481481481481481481481481481481481481481481482e1 * t881 - 0.93932222222222222222222222222222222222222222222223e0 * t884 + 0.73355000000000000000000000000000000000000000000000e-1 * t888 - 0.14671000000000000000000000000000000000000000000000e0 * t890 - 0.17116166666666666666666666666666666666666666666667e0 * t892 - 0.36793333333333333333333333333333333333333333333333e0 * t895
  t899 = t91 * t897 * t98
  t901 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t899
  t902 = t404 * t57
  t903 = t902 * t58
  t905 = 0.60000000000000000000000000000000000000000000000000e1 * t435 * t903
  t908 = 0.21687162600603479685264135044773156662314521887420e-1 * t445 * t392 * t99
  t911 = 0.16265371950452609763948101283579867496735891415565e-1 * t445 * t10 * t464
  t914 = 0.48159733137676571081572406076840235616767705782485e0 * t445 * t10 * t472
  t917 = 0.32530743900905219527896202567159734993471782831130e-1 * t445 * t10 * t453
  t919 = 0.1e1 / t433 / t37
  t920 = t36 * t919
  t922 = 0.1e1 / t436 / t30
  t923 = t902 * t922
  t925 = 0.51726012919273400298984252201052768390886626637712e3 * t920 * t923
  t929 = 0.48245938496077605200268890697218139186316165284153e2 * t435 * t429 * t437 * t57
  t930 = t850 + t857 - t861 - t869 - t901 + t905 - t908 + t911 + t914 - t917 + t925 + t929
  t933 = 0.60000000000000000000000000000000000000000000000000e1 * t403 * t59 * t429
  t936 = 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t883 * t31
  t940 = 0.1e1 / t545 / t187
  t951 = -0.25319000000000000000000000000000000000000000000000e1 * t875 + 0.16879333333333333333333333333333333333333333333333e1 * t878 - 0.19692555555555555555555555555555555555555555555555e1 * t881 - 0.93011851851851851851851851851851851851851851851854e0 * t884 + 0.13651666666666666666666666666666666666666666666667e0 * t888 - 0.27303333333333333333333333333333333333333333333333e0 * t890 - 0.31853888888888888888888888888888888888888888888890e0 * t892 - 0.36514074074074074074074074074074074074074074074075e0 * t895
  t952 = t951 * t58
  t954 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * t952
  t956 = 0.1e1 / t433 / t27
  t957 = t36 * t956
  t958 = t902 * t437
  t960 = 0.96491876992155210400537781394436278372632330568306e2 * t957 * t958
  t961 = t925 + t954 - t960 + t929 - t933 + t905 - t869 - t901 + t857 + t936 - t908
  t964 = 0.53424999999999999999999999999999999999999999999999e-1 * t396 * t397 * t430
  t966 = t471 * t96
  t969 = 0.51947577317044391278999449251423175496738199495715e2 * t89 * t468 * t462 * t966
  t971 = t98 * t462
  t974 = 0.35089341735807877243573431982554320891834732042568e1 * t89 * t450 * t96 * t971
  t975 = t9 * t434
  t978 = 0.85917975471764868594145516183295969534298037676861e0 * t396 * t975 * t438
  t982 = 0.10685000000000000000000000000000000000000000000000e0 * t396 * t9 * t402 * t405
  t986 = 0.56968947174242584615102410102512416326352748836105e-3 * t73 * t42 * t176 * t82
  t987 = t911 + t914 - t917 + t850 - t964 - t969 - t861 + t974 - t978 + t982 - t986
  t988 = t961 + t987
  t989 = t988 * t107
  t992 = t475 * t481
  t994 = t106 * t117 * t146
  t999 = t479 * t106
  t1001 = 0.1e1 / t504 / t103
  t1002 = t999 * t1001
  t1008 = t117 * t491 * t493
  t1011 = t485 * t536
  t1016 = 0.1e1 / t144 / t489 / t143
  t1017 = t150 * t1016
  t1018 = t493 * t181
  t1024 = t154 ** 2
  t1026 = 0.1e1 / t1024 * t226
  t1027 = t158 ** 2
  t1028 = 0.1e1 / t1027
  t1029 = t1026 * t1028
  t1030 = t1029 * t162
  t1034 = 0.1e1 / t504 / t105 * t19 * t137
  t1035 = t5 * t999
  t1036 = t509 * t126
  t1038 = t1034 * t1035 * t1036
  t1041 = t502 * t515
  t1044 = t509 * t475
  t1046 = t507 * t169 * t1044
  t1049 = t1026 * t501
  t1050 = t1049 * t162
  t1052 = t1034 * t1035 * t509
  t1056 = s0 * t531 * t68
  t1057 = t160 * t1056
  t1062 = t524 * t515
  t1065 = t5 * t988
  t1067 = t168 * t1065 * t126
  t1070 = t106 * t126
  t1072 = t507 * t519 * t1070
  t1075 = t1026 * t159
  t1076 = t1075 * t162
  t1078 = t1034 * t1035 * t126
  t1082 = 0.1e1 / t7 / t261
  t1087 = 0.16681250000000000000000000000000000000000000000000e-1 * t1030 * t1038 - 0.38922916666666666666666666666666666666666666666665e-1 * t1041 * t511 + 0.16681250000000000000000000000000000000000000000000e-1 * t503 * t1046 - 0.16681250000000000000000000000000000000000000000000e-1 * t1050 * t1052 + 0.64871527777777777777777777777777777777777777777775e-1 * t1057 * t171 - 0.19461458333333333333333333333333333333333333333333e-1 * t516 * t521 + 0.19461458333333333333333333333333333333333333333333e-1 * t1062 * t527 + 0.27802083333333333333333333333333333333333333333333e-2 * t163 * t1067 - 0.83406249999999999999999999999999999999999999999999e-2 * t525 * t1072 + 0.27802083333333333333333333333333333333333333333333e-2 * t1076 * t1078 - 0.93703317901234567901234567901234567901234567901232e-1 * t122 * t129 * t1082 * t140
  t1091 = t105 * (-0.32163648644302209642661863561802450870026695828375e2 * t989 * t147 + 0.31035008823423701047887038270048358885233697045810e4 * t992 * t994 - 0.24122736483226657231996397671351838152520021871282e2 * t476 * t486 - 0.33273303982313961219095599230268522386150008090026e5 * t1002 * t147 + 0.77587522058559252619717595675120897213084242614525e3 * t482 * t486 + 0.30153420604033321539995497089189797690650027339102e2 * t108 * t1008 - 0.24122736483226657231996397671351838152520021871282e2 * t108 * t1011 + 0.45e2 / 0.64e2 * t1017 * t1018 - 0.15e2 / 0.16e2 * t492 * t181 * t536 + t153 * t1087 / 0.4e1)
  t1094 = t546 * t184
  t1097 = -t933 + t936 + 0.62182e-1 * t105 * t543 * t184 * t940 + 0.31091e-1 * t1091 * t188 - t964 - t969 + t974 - t978 + t982 - t986 - 0.93273e-1 * t540 * t1094 + t954 - t960
  t1098 = t930 + t1097
  t1099 = t1098 * t220
  t1100 = t1099 * t200
  t1106 = t327 ** 2
  t1107 = t289 * t235 * t1106
  t1113 = t628 ** 2
  t1114 = t218 / t702 / t234 * t1113
  t1117 = t251 * t293
  t1118 = t1117 * t200
  t1129 = t306 ** 2
  t1130 = t236 * t1129
  t1133 = -0.34992000000000000000000000000000000000000000000000e2 * t695 * t562 + 0.6e1 * t803 * t844 - 0.23328000000000000000000000000000000000000000000000e2 * t1100 * t696 + 0.34992000000000000000000000000000000000000000000000e2 * t551 * t567 + 0.69984000000000000000000000000000000000000000000000e3 * t253 * t1107 + 0.46656000000000000000000000000000000000000000000000e2 * t253 * t1114 - 0.46656000000000000000000000000000000000000000000000e2 * t1118 * t699 + 0.13996800000000000000000000000000000000000000000000e3 * t695 * t829 + 0.69984000000000000000000000000000000000000000000000e2 * t549 * t198 * t200 * t245 - 0.13996800000000000000000000000000000000000000000000e3 * t1118 * t696 + 0.34992000000000000000000000000000000000000000000000e2 * t664 * t1130
  t1138 = t256 * t130
  t1140 = 0.1e1 / t22 / t1138
  t1141 = s0 * t1140
  t1143 = 0.12320e5 / 0.81e2 * tau0 * t263 - 0.5236e4 / 0.81e2 * t1141
  t1144 = t236 * t1143
  t1147 = t722 * t721
  t1148 = t746 * t1147
  t1150 = t718 * t721
  t1157 = -0.29633333333333333333333333333333333333333333333333e-1 * t875 + 0.19755555555555555555555555555555555555555555555555e-1 * t878 - 0.23048148148148148148148148148148148148148148148148e-1 * t881 - 0.32547666666666666666666666666666666666666666666667e-1 * t884
  t1158 = t725 * t1157
  t1162 = t740 * t729
  t1166 = 0.1e1 / t745 / t715
  t1167 = t1166 * t1147
  t1170 = t723 * t753
  t1175 = t746 * t729
  t1176 = t721 * t734
  t1177 = t1176 * t739
  t1180 = t730 * t753
  t1184 = 0.1e1 / t745 / t716
  t1185 = t1184 * t1147
  t1188 = t747 * t753
  t1191 = t734 * t760
  t1192 = t750 * t1191
  t1193 = t762 * t765
  t1194 = t68 * t767
  t1196 = t1193 * t1194 * t770
  t1203 = 0.1e1 / t737 / t758 / t736
  t1204 = t757 * t1203
  t1205 = t767 * s0
  t1206 = t200 * t1205
  t1207 = t256 ** 2
  t1209 = 0.1e1 / t1207 / t174
  t1214 = 0.1e1 / t7 / t1207
  t1222 = -0.60000000000000000000000000000000000000000000000000e1 * t1148 * t740 + 0.60000000000000000000000000000000000000000000000000e1 * t1150 * t1162 - 0.60000000000000000000000000000000000000000000000000e1 * t1167 * t740 - 0.85350568417505433333333333333333333333333333333330e-1 * t1170 * t324 - 0.10000000000000000000000000000000000000000000000000e1 * t1158 * t740 + 0.30000000000000000000000000000000000000000000000000e1 * t1175 * t1177 + 0.42675284208752716666666666666666666666666666666665e-1 * t1180 * t324 - 0.10000000000000000000000000000000000000000000000000e1 * t1185 * t740 - 0.42675284208752716666666666666666666666666666666665e-1 * t1188 * t324 + 0.60705996076593966087358779412675925925925925925921e-2 * t1192 * t1196 - 0.15647604209875996111111111111111111111111111111110e0 * t754 * t311 - 0.31087747628928898252912838668079770391184269901849e-2 * t1204 * t1206 * t1209 + 0.22258865228084454232031552451314506172839506172838e-1 * t763 * t766 * t767 * t1214 - 0.24340717659807105061728395061728395061728395061728e0 * t776 * t777 * t264
  t1230 = 0.1e1 / t794 / t783
  t1234 = (0.1714584e0 * t1148 - 0.1714584e0 * t1150 * t729 + 0.285764e-1 * t1158 + 0.285764e-1 * t1222 * t784 - 0.857292e-1 * t781 * t795 * t792 + 0.571528e-1 * t793 * t792 * t1230) * t802
  t1240 = t200 * t218
  t1241 = t1240 * t235
  t1264 = -0.23328000000000000000000000000000000000000000000000e2 * t561 * t274 + 0.58320000000000000000000000000000000000000000000000e1 * t556 * t1144 + 0.4e1 * t1234 * t810 - 0.77760000000000000000000000000000000000000000000000e1 * t1100 * t699 + 0.46656000000000000000000000000000000000000000000000e2 * t191 * t293 * t1241 - 0.13996800000000000000000000000000000000000000000000e3 * t561 * t635 + 0.46656000000000000000000000000000000000000000000000e2 * t561 * t643 + 0.46656000000000000000000000000000000000000000000000e3 * t253 * t231 * t278 * t328 * t615 - 0.13996800000000000000000000000000000000000000000000e3 * t201 * t670 + 0.27993600000000000000000000000000000000000000000000e3 * t253 * t341 * t626 * t327 * t628 - 0.69984000000000000000000000000000000000000000000000e3 * t253 * t709 * t327 * t313
  t1305 = -0.69984000000000000000000000000000000000000000000000e2 * t253 * t633 * t313 * t628 + 0.23328000000000000000000000000000000000000000000000e2 * t1098 * t219 * t200 * t552 + 0.69984000000000000000000000000000000000000000000000e2 * t695 * t617 - 0.13996800000000000000000000000000000000000000000000e4 * t556 * t709 * t243 * t328 - 0.13996800000000000000000000000000000000000000000000e3 * t556 * t704 * t243 * t705 + 0.13996800000000000000000000000000000000000000000000e3 * t253 * t254 * t703 * t326 * t705 - 0.13996800000000000000000000000000000000000000000000e3 * t253 * t646 * t327 * t600 - 0.20995200000000000000000000000000000000000000000000e3 * t566 * t679 - 0.20995200000000000000000000000000000000000000000000e3 * t566 * t683 - 0.20995200000000000000000000000000000000000000000000e3 * t664 * t255 * t244 * t313 - 0.69984000000000000000000000000000000000000000000000e2 * t664 * t279 * t244 * t600
  t1346 = -0.41990400000000000000000000000000000000000000000000e3 * t201 * t666 + 0.41990400000000000000000000000000000000000000000000e3 * t556 * t620 * t306 * t327 - 0.69984000000000000000000000000000000000000000000000e2 * t566 * t691 + 0.46656000000000000000000000000000000000000000000000e2 * t664 * t236 * t243 * t266 + 0.13996800000000000000000000000000000000000000000000e3 * t566 * t630 - 0.23328000000000000000000000000000000000000000000000e2 * t556 * t279 * t388 * t243 + 0.23328000000000000000000000000000000000000000000000e2 * t253 * t604 * t388 * t326 + 0.15552000000000000000000000000000000000000000000000e2 * t253 * t627 * t388 * t615 - 0.69984000000000000000000000000000000000000000000000e2 * t556 * t255 * t273 * t243 + 0.13996800000000000000000000000000000000000000000000e3 * t201 * t675 - 0.69984000000000000000000000000000000000000000000000e2 * t556 * t255 * t266 * t326 - 0.10497600000000000000000000000000000000000000000000e3 * t556 * t255 * t306 * t313
  t1381 = -0.23328000000000000000000000000000000000000000000000e2 * t556 * t279 * t266 * t615 - 0.34992000000000000000000000000000000000000000000000e2 * t556 * t279 * t306 * t600 + 0.69984000000000000000000000000000000000000000000000e2 * t561 * t656 + 0.34992000000000000000000000000000000000000000000000e2 * t253 * t604 * t313 * t600 + 0.83980800000000000000000000000000000000000000000000e3 * t566 * t622 + 0.69984000000000000000000000000000000000000000000000e2 * t561 * t660 - 0.27993600000000000000000000000000000000000000000000e3 * t561 * t648 - 0.69984000000000000000000000000000000000000000000000e2 * t566 * t687 + 0.27993600000000000000000000000000000000000000000000e3 * t561 * t652 + 0.83980800000000000000000000000000000000000000000000e3 * t664 * t620 * t244 * t327 + 0.13996800000000000000000000000000000000000000000000e3 * t664 * t627 * t244 * t628
  t1382 = t363 * t254
  t1383 = t243 * t326
  t1384 = t1383 * t306
  t1387 = t297 * t341
  t1388 = t651 * t243
  t1405 = t313 ** 2
  t1419 = t244 ** 2
  t1432 = 0.5e1 / 0.18e2 * t1143 * t202 * t208 + 0.32320987654320987654320987654320987654320987654320e1 * t208 * t211 * t1140
  t1442 = t244 * t200
  t1455 = -0.13996800000000000000000000000000000000000000000000e3 * t1382 * t1384 + 0.27993600000000000000000000000000000000000000000000e3 * t1387 * t1388 - 0.90699264000000000000000000000000000000000000000000e3 * t350 * t289 * t1384 + 0.12697896960000000000000000000000000000000000000000e4 * t284 * t332 * t1388 + 0.19440000000000000000000000000000000000000000000000e1 * t297 * t218 * t1143 + 0.12697896960000000000000000000000000000000000000000e4 * t228 / t317 / t216 * t1106 + 0.52907904000000000000000000000000000000000000000000e2 * t228 * t332 * t1405 + 0.23328000000000000000000000000000000000000000000000e3 * t221 * t289 * t1106 + 0.11664000000000000000000000000000000000000000000000e2 * t363 * t218 * t1129 + 0.23328000000000000000000000000000000000000000000000e2 * t221 * t341 * t1405 + 0.15116544000000000000000000000000000000000000000000e3 * t219 * t227 * t231 * t1419 + 0.37791360000000000000000000000000000000000000000000e2 * t350 * t231 * t1129 - 0.19440000000000000000000000000000000000000000000000e1 * t221 * t254 * t1432 + 0.25194240000000000000000000000000000000000000000000e1 * t284 * t231 * t1143 - 0.25194240000000000000000000000000000000000000000000e1 * t228 * t289 * t1432 + 0.23328000000000000000000000000000000000000000000000e2 * t1442 * t576 - 0.46656000000000000000000000000000000000000000000000e2 * t294 * t607 - 0.84652646400000000000000000000000000000000000000000e3 * t228 * t319 * t327 * t313 - 0.12093235200000000000000000000000000000000000000000e4 * t346 * t289 * t293 * t326
  t1525 = 0.30233088000000000000000000000000000000000000000000e3 * t346 * t585 * t306 - 0.45349632000000000000000000000000000000000000000000e3 * t350 * t351 * t313 - 0.46656000000000000000000000000000000000000000000000e3 * t297 * t337 * t243 - 0.23328000000000000000000000000000000000000000000000e3 * t221 * t231 * t327 * t313 - 0.23328000000000000000000000000000000000000000000000e2 * t297 * t280 * t243 + 0.31104000000000000000000000000000000000000000000000e2 * t221 * t341 * t273 * t326 + 0.50388480000000000000000000000000000000000000000000e2 * t350 * t285 * t243 + 0.13996800000000000000000000000000000000000000000000e3 * t297 * t341 * t306 * t327 - 0.90699264000000000000000000000000000000000000000000e2 * t284 * t359 * t313 - 0.33861058560000000000000000000000000000000000000000e4 * t284 * t329 * t243 - 0.60466176000000000000000000000000000000000000000000e2 * t284 * t289 * t266 * t326 - 0.60466176000000000000000000000000000000000000000000e2 * t284 * t290 * t243 + 0.70543872000000000000000000000000000000000000000000e2 * t228 * t332 * t273 * t326 + 0.15552000000000000000000000000000000000000000000000e2 * t363 * t298 * t243 - 0.23328000000000000000000000000000000000000000000000e2 * t297 * t254 * t266 * t326 + 0.63489484800000000000000000000000000000000000000000e3 * t284 * t332 * t306 * t327 + 0.27993600000000000000000000000000000000000000000000e3 * t363 * t341 * t244 * t327 + 0.31744742400000000000000000000000000000000000000000e4 * t350 * t332 * t244 * t327 - 0.69984000000000000000000000000000000000000000000000e2 * t363 * t364 * t313 - 0.34992000000000000000000000000000000000000000000000e2 * t297 * t372 * t313
  t1527 = t279 * (t1455 + t1525)
  t1550 = t255 * t1383
  t1560 = 0.1e1 / t14 * r0 * t1082 * t396 / 0.48e2
  t1562 = 0.1e1 / t261
  t1563 = t873 * t1562
  t1565 = t411 * t258
  t1566 = t410 * t1565
  t1568 = t42 * t531
  t1569 = t41 * t1568
  t1571 = t6 * t531
  t1572 = t4 * t1571
  t1574 = t13 ** (-0.25e1)
  t1577 = t1574 * t2 * t1082 * t396
  t1579 = t887 * t1562
  t1581 = t421 * t1565
  t1583 = t49 * t1568
  t1586 = t21 * t5 * t258
  t1591 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.21099166666666666666666666666666666666666666666667e1 * t1560 + 0.20255200000000000000000000000000000000000000000000e2 * t1563 - 0.75019259259259259259259259259259259259259259259258e1 * t1566 + 0.65641851851851851851851851851851851851851851851850e1 * t1569 + 0.31003950617283950617283950617283950617283950617285e1 * t1572 + 0.68258333333333333333333333333333333333333333333335e-1 * t1577 - 0.10921333333333333333333333333333333333333333333333e1 * t1579 + 0.12134814814814814814814814814814814814814814814815e1 * t1581 + 0.10617962962962962962962962962962962962962962962963e1 * t1583 + 0.13388493827160493827160493827160493827160493827161e1 * t1586) * t58
  t1592 = t433 ** 2
  t1595 = t404 ** 2
  t1596 = t436 ** 2
  t1600 = 0.24955700379505800914252936827276051226357058527653e5 * t36 / t1592 * t1595 / t1596
  t1606 = 0.62071215503128080358781102641263322069063951965254e4 * t36 / t433 / t401 * t1595 * t922
  t1609 = 0.24000000000000000000000000000000000000000000000000e2 * t957 * t1595 * t58
  t1610 = t429 ** 2
  t1613 = 0.48245938496077605200268890697218139186316165284153e2 * t435 * t1610 * t437
  t1616 = t451 ** 2
  t1620 = 0.12304822629859687989861833551788232416071203002497e5 * t89 / t467 / t449 * t1616 * t866
  t1621 = t462 ** 2
  t1625 = 0.35089341735807877243573431982554320891834732042568e1 * t89 * t450 * t1621 * t98
  t1629 = 0.51947577317044391278999449251423175496738199495715e2 * t89 * t468 * t1621 * t471
  t1632 = 0.11483599538271604938271604938271604938271604938271e-1 * t4 * t1571 * t31
  t1636 = 0.31035607751564040179390551320631661034531975982628e4 * t920 * t404 * t922 * t429
  t1642 = t1591 + t1600 - t1606 - t1609 + t1613 + t1620 + t1625 - t1629 - t1632 + t1636 - 0.124364e0 * t1091 * t1094 + 0.373092e0 * t540 * t940 * t543
  t1645 = 0.80000000000000000000000000000000000000000000000000e1 * t403 * t952 * t57
  t1648 = 0.36000000000000000000000000000000000000000000000000e2 * t435 * t405 * t429
  t1652 = 0.64327917994770140267025187596290852248421553712204e2 * t435 * t951 * t437 * t57
  t1655 = 0.57895126195293126240322668836661767023579398340984e3 * t957 * t438 * t429
  t1658 = 0.60000000000000000000000000000000000000000000000000e1 * t403 * t1610 * t58
  t1661 = 0.57895126195293126240322668836661767023579398340984e3 * t920 * t1595 * t437
  t1665 = 0.1e1 / t1024 / t119 * t226 * t121
  t1671 = 0.1e1 / t504 / t480 * t19 * t137
  t1672 = t479 ** 2
  t1673 = t5 * t1672
  t1685 = t475 ** 2
  t1686 = t5 * t1685
  t1719 = -0.27802083333333333333333333333333333333333333333333e-2 * t1665 * t159 * t162 * t1671 * t1673 * t126 + 0.77845833333333333333333333333333333333333333333332e-1 * t1062 * t1072 - 0.37481327160493827160493827160493827160493827160492e0 * t160 * s0 * t1082 * t68 * t171 + 0.16681250000000000000000000000000000000000000000000e-1 * t503 * t507 * t1686 * t509 + 0.22241666666666666666666666666666666666666666666667e-1 * t503 * t507 * t169 * t509 * t988 - 0.10008750000000000000000000000000000000000000000000e0 * t1050 * t1034 * t508 * t1044 + 0.10008750000000000000000000000000000000000000000000e0 * t1030 * t1034 * t508 * t1036 * t475 + 0.25948611111111111111111111111111111111111111111110e0 * t502 * t1056 * t511 - 0.15569166666666666666666666666666666666666666666667e0 * t1041 * t1046 + 0.49975102880658436213991769547325102880658436213990e0 * t122 * t129 / t7 / t1138 * t140 - 0.15569166666666666666666666666666666666666666666667e0 * t1029 * t515 * t1038
  t1723 = t1591 + t1600 - t1606 - t1609 + t1613 + t1620 + t1625 - t1629 - t1632 + t1636 - t1645
  t1727 = 0.28493333333333333333333333333333333333333333333333e0 * t396 * t132 * t402 * t405
  t1730 = 0.42740000000000000000000000000000000000000000000000e0 * t396 * t975 * t903
  t1735 = 0.61524113149298439949309167758941162080356015012483e4 * t89 * t863 * t451 * t866 * t462
  t1740 = 0.46785788981077169658097909310072427855779642723424e1 * t89 * t450 * t897 * t98 * t96
  t1744 = 0.18989649058080861538367470034170805442117582945368e-2 * t73 * t42 * t531 * t82
  t1747 = 0.21053605041484726346144059189532592535100839225540e2 * t89 * t469 * t971
  t1750 = 0.14246666666666666666666666666666666666666666666666e0 * t396 * t847 * t430
  t1751 = t1648 + t1652 - t1655 - t1658 + t1661 - t1727 - t1730 - t1735 + t1740 + t1744 - t1747 + t1750
  t1756 = 0.22911460125803964958438804315545591875812810047162e1 * t396 * t132 * t434 * t438
  t1760 = 0.69263436422725855038665932335230900662317599327620e2 * t89 * t468 * t897 * t966
  t1762 = t471 * t462
  t1765 = 0.62337092780453269534799339101707810596085839394858e3 * t89 * t852 * t451 * t1762
  t1769 = 0.22161481481481481481481481481481481481481481481481e0 * t396 * t176 * t38 * t59
  t1773 = 0.36846163202829085479643115651216588683774907041596e2 * t396 * t9 * t919 * t923
  t1776 = 0.71233333333333333333333333333333333333333333333332e-1 * t396 * t397 * t952
  t1780 = 0.68734380377411894875316412946636775627438430141488e1 * t396 * t9 * t956 * t958
  t1781 = t72 * t396
  t1786 = 0.13012297560362087811158481026863893997388713132452e0 * t1781 * t9 * t450 * t971 * t96
  t1791 = 0.19263893255070628432628962430736094246707082312995e1 * t1781 * t9 * t468 * t1762 * t96
  t1795 = 0.14035736694323150897429372793021728356733892817027e2 * t89 * t852 * t1616 * t98
  t1799 = 0.62337092780453269534799339101707810596085839394858e3 * t89 * t863 * t1616 * t471
  t1800 = t1756 - t1760 + t1765 - t1769 - t1773 - t1776 + t1780 - t1786 + t1791 + t1795 - t1799
  t1801 = t467 ** 2
  t1804 = t470 ** 2
  t1808 = 0.91082604192152556048340974007871726131433263376469e5 * t89 / t1801 * t1616 / t1804
  t1823 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.28769444444444444444444444444444444444444444444444e1 * t1560 + 0.27618666666666666666666666666666666666666666666667e2 * t1563 - 0.10229135802469135802469135802469135802469135802469e2 * t1566 + 0.89504938271604938271604938271604938271604938271607e1 * t1569 + 0.31310740740740740740740740740740740740740740740741e1 * t1572 + 0.36677500000000000000000000000000000000000000000000e-1 * t1577 - 0.58684000000000000000000000000000000000000000000000e0 * t1579 + 0.65204444444444444444444444444444444444444444444445e0 * t1581 + 0.57053888888888888888888888888888888888888888888890e0 * t1583 + 0.13490888888888888888888888888888888888888888888889e1 * t1586) * t98
  t1826 = 0.43374325201206959370528270089546313324629043774840e-1 * t445 * t392 * t464
  t1829 = 0.12842595503380418955085974953824062831138054875329e1 * t445 * t392 * t472
  t1832 = 0.38025319932552508024225805073234468230220037056326e2 * t445 * t10 * t867
  t1835 = 0.21687162600603479685264135044773156662314521887420e-1 * t445 * t10 * t899
  t1838 = 0.38527786510141256865257924861472188493414164625988e1 * t445 * t10 * t855
  t1841 = 0.13012297560362087811158481026863893997388713132452e0 * t445 * t10 * t859
  t1844 = 0.67471172535210825687488420139294265171645179205307e-1 * t445 * t883 * t99
  t1847 = 0.86748650402413918741056540179092626649258087549680e-1 * t445 * t392 * t453
  t1852 = 0.34367190188705947437658206473318387813719215070744e1 * t46 * t434 * t429 * t437 * t57
  t1856 = 0.42740000000000000000000000000000000000000000000000e0 * t46 * t402 * t57 * t430
  t1857 = -t1808 - t1823 - t1826 - t1829 + t1832 + t1835 - t1838 + t1841 + t1844 + t1847 - t1852 + t1856
  t1859 = t1723 + t1751 + t1800 + t1857
  t1885 = t509 ** 2
  t1909 = -0.25948611111111111111111111111111111111111111111111e-1 * t1075 * t515 * t1078 + 0.27802083333333333333333333333333333333333333333333e-2 * t163 * t168 * t5 * t1859 * t126 + 0.15569166666666666666666666666666666666666666666667e0 * t1049 * t515 * t1052 + 0.38922916666666666666666666666666666666666666666667e-1 * t1665 * t501 * t162 * t1671 * t1673 * t509 + 0.12974305555555555555555555555555555555555555555555e0 * t1057 * t521 - 0.12974305555555555555555555555555555555555555555555e0 * t524 * t1056 * t527 - 0.25948611111111111111111111111111111111111111111111e-1 * t516 * t1067 + 0.66725000000000000000000000000000000000000000000000e-1 * t1665 / t1027 / t127 * t162 * t1671 * t1673 * t1885 - 0.10008750000000000000000000000000000000000000000000e0 * t1665 * t1028 * t162 * t1671 * t1673 * t1036 - 0.11120833333333333333333333333333333333333333333333e-1 * t525 * t507 * t1065 * t1070 - 0.83406249999999999999999999999999999999999999999999e-2 * t525 * t507 * t1686 * t126 + 0.16681250000000000000000000000000000000000000000000e-1 * t1076 * t1034 * t519 * t479 * t126
  t1916 = t536 ** 2
  t1932 = t489 ** 2
  t1936 = t493 ** 2
  t1975 = t153 * (t1719 + t1909) / 0.4e1 + 0.31035008823423701047887038270048358885233697045810e4 * t992 * t106 * t486 - 0.15e2 / 0.16e2 * t492 * t1916 - 0.32163648644302209642661863561802450870026695828376e2 * t108 * t485 * t1087 + 0.135e3 / 0.32e2 * t1017 * t493 * t536 + 0.60306841208066643079990994178379595381300054678204e2 * t476 * t1008 - 0.48245472966453314463992795342703676305040043742564e2 * t476 * t1011 + 0.31035008823423701047887038270048358885233697045810e4 * t1685 * t481 * t147 - 0.585e3 / 0.256e3 * t150 / t144 / t1932 * t1936 - 0.5e1 / 0.4e1 * t492 * t181 * t1087 - 0.32163648644302209642661863561802450870026695828375e2 * t1859 * t107 * t147 - 0.19396880514639813154929398918780224303271060653631e4 * t482 * t1008 - 0.33273303982313961219095599230268522386150008090026e5 * t1002 * t486 - 0.19963982389388376731457359538161113431690004854016e6 * t475 * t1001 * t479 * t117 * t146 + 0.41380011764564934730516051026731145180311596061080e4 * t988 * t481 * t994 - 0.32163648644302209642661863561802450870026695828376e2 * t989 * t486 + 0.12061368241613328615998198835675919076260010935641e3 * t108 * t117 * t491 * t181 * t536 + 0.10701908585222077520535074211272883595300893535115e7 * t1672 / t504 / t164 * t147 - 0.90460261812099964619986491267569393071950082017306e2 * t108 * t117 * t1016 * t1018 + 0.15517504411711850523943519135024179442616848522905e4 * t482 * t1011
  t1979 = t539 ** 2
  t1983 = t543 ** 2
  t1985 = t545 ** 2
  t1989 = -t1645 + t1648 + t1652 - t1655 - t1658 + t1661 + 0.31091e-1 * t105 * t1975 * t188 - 0.93273e-1 * t105 * t1979 * t546 - 0.186546e0 * t105 * t1983 / t1985 - t1727 - t1730 - t1735 + t1740
  t1991 = t1744 - t1747 + t1750 + t1756 - t1760 + t1765 - t1769 - t1773 - t1776 + t1780 - t1786 + t1791 + t1795
  t1992 = -t1799 - t1808 - t1823 - t1826 - t1829 + t1832 + t1835 - t1838 + t1841 + t1844 + t1847 - t1852 + t1856
  t2002 = -0.19440000000000000000000000000000000000000000000000e1 * t253 * t1527 - 0.69984000000000000000000000000000000000000000000000e2 * t551 * t639 - 0.69984000000000000000000000000000000000000000000000e2 * t253 * t704 * t628 * t600 + 0.93312000000000000000000000000000000000000000000000e2 * t253 * t620 * t273 * t326 + 0.23328000000000000000000000000000000000000000000000e2 * t253 * t604 * t273 * t615 + 0.69984000000000000000000000000000000000000000000000e2 * t556 * t627 * t306 * t628 + 0.23328000000000000000000000000000000000000000000000e2 * t566 * t557 - 0.20995200000000000000000000000000000000000000000000e3 * t551 * t1550 + 0.19440000000000000000000000000000000000000000000000e1 * (t1642 + t1989 + t1991 + t1992) * t220 * t1241 - 0.77760000000000000000000000000000000000000000000000e1 * t561 * t389 + 0.23328000000000000000000000000000000000000000000000e2 * t695 * t839
  t2004 = t722 ** 2
  t2005 = t1166 * t2004
  t2009 = t729 ** 2
  t2010 = t718 * t2009
  t2020 = t725 * (-0.24694444444444444444444444444444444444444444444444e-1 * t1560 + 0.23706666666666666666666666666666666666666666666666e0 * t1563 - 0.87802469135802469135802469135802469135802469135800e-1 * t1566 + 0.76827160493827160493827160493827160493827160493827e-1 * t1569 + 0.10849222222222222222222222222222222222222222222222e0 * t1572)
  t2037 = t745 ** 2
  t2066 = 0.30000000000000000000000000000000000000000000000000e1 * t746 * t2009 * t740 + 0.12000000000000000000000000000000000000000000000000e2 / t745 / t717 * t2004 * t740 - 0.10000000000000000000000000000000000000000000000000e1 * t2020 * t740 + 0.36000000000000000000000000000000000000000000000000e2 * t1184 * t2004 * t740 + 0.24000000000000000000000000000000000000000000000000e2 * t2005 * t740 + 0.10000000000000000000000000000000000000000000000000e1 / t2037 * t2004 * t740 + 0.60000000000000000000000000000000000000000000000000e1 * t2010 * t740 + 0.62590416839503984444444444444444444444444444444441e0 * t1170 * t311 - 0.31295208419751992222222222222222222222222222222221e0 * t1180 * t311 - 0.24282398430637586434943511765070370370370370370368e-1 * t723 * t1191 * t1196 + 0.56900378945003622222222222222222222222222222222220e-1 * t1158 * t753 * t324 + 0.12141199215318793217471755882535185185185185185184e-1 * t730 * t1191 * t1196 + 0.56900378945003622222222222222222222222222222222220e-1 * t1185 * t753 * t324 - 0.12141199215318793217471755882535185185185185185184e-1 * t747 * t1191 * t1196 + 0.34140227367002173333333333333333333333333333333332e0 * t1148 * t753 * t324
  t2125 = t758 ** 2
  t2129 = t767 ** 2
  t2139 = 0.34140227367002173333333333333333333333333333333332e0 * t1167 * t753 * t324 + 0.97362870639228420246913580246913580246913580246908e0 * t754 * t271 + 0.31295208419751992222222222222222222222222222222221e0 * t1188 * t311 - 0.89035460912337816928126209805258024691358024691350e-1 * t1192 * t1193 * t1194 * t1214 - 0.17070113683501086666666666666666666666666666666666e0 * t1175 * t1176 * t752 * t324 - 0.34140227367002173333333333333333333333333333333332e0 * t1150 * t753 * t204 * t777 * t241 * t729 - 0.22011544503327960296120090757411011659807956104251e0 * t763 * t766 * t767 / t7 / t1207 / r0 + 0.13793073340557359534979423868312757201646090534979e1 * t776 * t777 * t1141 + 0.12435099051571559301165135467231908156473707960740e-1 * t750 * t734 * t1203 * t200 * t1205 * t1209 + 0.40000000000000000000000000000000000000000000000000e1 * t746 * t1157 * t1177 - 0.36000000000000000000000000000000000000000000000000e2 * t747 * t1162 + 0.80000000000000000000000000000000000000000000000000e1 * t1150 * t740 * t1157 - 0.60000000000000000000000000000000000000000000000000e1 * t1184 * t729 * t722 * t734 * t739 + 0.68393044783643576156408245069775494860605393784069e-1 * t1204 * t1206 / t1207 / t256 - 0.36000000000000000000000000000000000000000000000000e2 * t1166 * t722 * t1162 - 0.57489400170562495257927652663499439366228807233633e-3 * t757 / t737 / t2125 * t200 * t2129 / t22 / t1207 / t1138 * t204 * t777
  t2149 = t781 ** 2
  t2152 = t793 ** 2
  t2153 = t794 ** 2
  t2161 = 0.1e1 - 0.19440000000000000000000000000000000000000000000000e1 * t221 * t236
  t2167 = (0.285764e-1 * t750 + 0.285764e-1 * t792 * t784) * t802
  t2176 = t626 * t615
  t2180 = t221 * t341
  t2181 = t235 * t326
  t2185 = t278 * t313
  t2192 = t278 * t306
  t2201 = 0.19440000000000000000000000000000000000000000000000e1 * t221 * t389 + 0.58320000000000000000000000000000000000000000000000e1 * t221 * t274 - 0.58320000000000000000000000000000000000000000000000e1 * t297 * t557 + 0.11664000000000000000000000000000000000000000000000e2 * t221 * t706 - 0.11664000000000000000000000000000000000000000000000e2 * t222 * t2176 * t600 - 0.69984000000000000000000000000000000000000000000000e2 * t2180 * t2181 * t313 - 0.17496000000000000000000000000000000000000000000000e2 * t832 * t2185 * t615 - 0.17496000000000000000000000000000000000000000000000e2 * t832 * t833 * t600 + 0.17496000000000000000000000000000000000000000000000e2 * t822 * t2192 * t615 + 0.17496000000000000000000000000000000000000000000000e2 * t822 * t823 * t600 + 0.11664000000000000000000000000000000000000000000000e3 * t221 * t710
  t2202 = t278 * t327
  t2208 = t235 * t244
  t2212 = t363 * t218
  t2213 = t278 * t244
  t2220 = t235 * t306
  t2230 = t823 * t616
  t2233 = t626 * t243
  t2241 = 0.69984000000000000000000000000000000000000000000000e2 * t2180 * t2202 * t615 - 0.11664000000000000000000000000000000000000000000000e2 * t294 * t236 + 0.10497600000000000000000000000000000000000000000000e3 * t1382 * t2208 * t326 + 0.34992000000000000000000000000000000000000000000000e2 * t2212 * t2213 * t615 - 0.34992000000000000000000000000000000000000000000000e2 * t2212 * t818 * t306 + 0.52488000000000000000000000000000000000000000000000e2 * t817 * t2220 * t326 + 0.52488000000000000000000000000000000000000000000000e2 * t817 * t818 * t313 - 0.20995200000000000000000000000000000000000000000000e3 * t1387 * t818 * t327 - 0.10497600000000000000000000000000000000000000000000e3 * t817 * t2230 - 0.34992000000000000000000000000000000000000000000000e2 * t822 * t2233 * t628 + 0.34992000000000000000000000000000000000000000000000e2 * t832 * t626 * t326 * t628
  t2242 = t2201 + t2241
  t2247 = t620 * t1405
  t2250 = t600 ** 2
  t2251 = t627 * t2250
  t2259 = jnp.log(t783)
  t2262 = (-0.285764e-1 * t732 + 0.285764e-1 * t2259) * t802
  t2269 = t703 * t705
  t2273 = t278 * t388
  t2285 = t221 * t231
  t2290 = t235 * t273
  t2305 = 0.46656000000000000000000000000000000000000000000000e2 * t294 * t699 + 0.23328000000000000000000000000000000000000000000000e2 * t822 * t278 * t266 * t615 + 0.13996800000000000000000000000000000000000000000000e3 * t822 * t2269 * t243 + 0.23328000000000000000000000000000000000000000000000e2 * t822 * t2273 * t243 + 0.34992000000000000000000000000000000000000000000000e2 * t822 * t2192 * t600 + 0.13996800000000000000000000000000000000000000000000e4 * t297 * t231 * t235 * t328 * t243 - 0.46656000000000000000000000000000000000000000000000e3 * t2285 * t278 * t328 * t615 + 0.69984000000000000000000000000000000000000000000000e2 * t817 * t2290 * t243 - 0.93312000000000000000000000000000000000000000000000e2 * t2180 * t2290 * t326 - 0.69984000000000000000000000000000000000000000000000e3 * t221 * t1107 - 0.23328000000000000000000000000000000000000000000000e2 * t832 * t2273 * t326 - 0.13996800000000000000000000000000000000000000000000e3 * t832 * t2269 * t326
  t2314 = t235 * t266
  t2325 = t2176 * t690
  t2328 = t2176 * t659
  t2331 = t2181 * t682
  t2334 = t833 * t655
  t2337 = t2185 * t638
  t2340 = t833 * t690
  t2343 = t2192 * t638
  t2346 = 0.69984000000000000000000000000000000000000000000000e2 * t222 * t703 * t628 * t600 - 0.23328000000000000000000000000000000000000000000000e2 * t832 * t278 * t273 * t615 - 0.46656000000000000000000000000000000000000000000000e2 * t2212 * t2314 * t243 + 0.69984000000000000000000000000000000000000000000000e2 * t817 * t2314 * t326 - 0.34992000000000000000000000000000000000000000000000e2 * t363 * t1130 - 0.69984000000000000000000000000000000000000000000000e2 * t221 * t2247 - 0.13996800000000000000000000000000000000000000000000e3 * t822 * t2325 + 0.13996800000000000000000000000000000000000000000000e3 * t832 * t2328 - 0.83980800000000000000000000000000000000000000000000e3 * t1387 * t2331 + 0.27993600000000000000000000000000000000000000000000e3 * t2180 * t2334 - 0.20995200000000000000000000000000000000000000000000e3 * t817 * t2337 - 0.20995200000000000000000000000000000000000000000000e3 * t817 * t2340 + 0.13996800000000000000000000000000000000000000000000e3 * t2212 * t2343
  t2348 = t2192 * t616
  t2351 = t2202 * t638
  t2354 = t2213 * t616
  t2357 = t818 * t678
  t2360 = t2233 * t634
  t2369 = t255 * t1432
  t2378 = -0.20995200000000000000000000000000000000000000000000e3 * t817 * t2348 + 0.83980800000000000000000000000000000000000000000000e3 * t1387 * t2351 - 0.41990400000000000000000000000000000000000000000000e3 * t1382 * t2354 + 0.41990400000000000000000000000000000000000000000000e3 * t1382 * t2357 + 0.41990400000000000000000000000000000000000000000000e3 * t817 * t2360 - 0.11664000000000000000000000000000000000000000000000e2 * t221 * t2251 + 0.13996800000000000000000000000000000000000000000000e3 * t294 * t696 - 0.58320000000000000000000000000000000000000000000000e1 * t297 * t1144 + 0.58320000000000000000000000000000000000000000000000e1 * t221 * t2369 + 0.19440000000000000000000000000000000000000000000000e1 * t221 * t1527 - 0.46656000000000000000000000000000000000000000000000e2 * t221 * t1114 - 0.69984000000000000000000000000000000000000000000000e2 * t1442 * t567
  t2425 = -0.15552000000000000000000000000000000000000000000000e2 * t222 * t626 * t388 * t615 + 0.10497600000000000000000000000000000000000000000000e3 * t817 * t2220 * t313 + 0.20995200000000000000000000000000000000000000000000e3 * t1382 * t2208 * t313 + 0.69984000000000000000000000000000000000000000000000e2 * t2212 * t2213 * t600 - 0.27993600000000000000000000000000000000000000000000e3 * t2180 * t626 * t327 * t628 - 0.83980800000000000000000000000000000000000000000000e3 * t363 * t341 * t2208 * t327 - 0.13996800000000000000000000000000000000000000000000e3 * t2212 * t626 * t244 * t628 + 0.13996800000000000000000000000000000000000000000000e3 * t2180 * t2202 * t600 - 0.69984000000000000000000000000000000000000000000000e2 * t822 * t626 * t306 * t628 - 0.34992000000000000000000000000000000000000000000000e2 * t832 * t2185 * t600 - 0.41990400000000000000000000000000000000000000000000e3 * t1387 * t2220 * t327 + 0.69984000000000000000000000000000000000000000000000e3 * t2285 * t235 * t327 * t313 + 0.69984000000000000000000000000000000000000000000000e2 * t832 * t626 * t313 * t628
  t2435 = t200 * t254
  t2436 = t555 * t2435
  t2439 = (-0.6858336e0 * t2005 + 0.10287504e1 * t747 * t729 - 0.1714584e0 * t2010 - 0.2286112e0 * t1150 * t1157 + 0.285764e-1 * t2020 + 0.285764e-1 * (t2066 + t2139) * t784 - 0.1143056e0 * t1222 * t795 * t792 + 0.3429168e0 * t781 * t1230 * t793 - 0.857292e-1 * t2149 * t795 - 0.1714584e0 * t2152 / t2153) * t802 * t2161 + 0.4e1 * t2167 * t2242 - 0.11664000000000000000000000000000000000000000000000e2 * t695 * t601 + 0.69984000000000000000000000000000000000000000000000e2 * t253 * t2247 + 0.11664000000000000000000000000000000000000000000000e2 * t253 * t2251 + 0.69984000000000000000000000000000000000000000000000e2 * t251 * t244 * t200 * t567 + t2262 * (t2305 + t2346 + t2378 + t2425) - 0.46656000000000000000000000000000000000000000000000e3 * t561 * t710 - 0.58320000000000000000000000000000000000000000000000e1 * t253 * t2369 - 0.46656000000000000000000000000000000000000000000000e2 * t561 * t706 + 0.20995200000000000000000000000000000000000000000000e3 * t2436 * t2340
  t2455 = t663 * t2435
  t2461 = t200 * t341
  t2465 = t555 * t2461
  t2472 = 0.41990400000000000000000000000000000000000000000000e3 * t565 * t2435 * t2230 + 0.20995200000000000000000000000000000000000000000000e3 * t2436 * t2348 + 0.20995200000000000000000000000000000000000000000000e3 * t2436 * t2337 - 0.41990400000000000000000000000000000000000000000000e3 * t2436 * t2360 + 0.13996800000000000000000000000000000000000000000000e3 * t555 * t1240 * t2325 - 0.13996800000000000000000000000000000000000000000000e3 * t252 * t2435 * t2328 - 0.41990400000000000000000000000000000000000000000000e3 * t2455 * t2357 - 0.13996800000000000000000000000000000000000000000000e3 * t663 * t1240 * t2343 - 0.27993600000000000000000000000000000000000000000000e3 * t252 * t2461 * t2334 + 0.83980800000000000000000000000000000000000000000000e3 * t2465 * t2331 + 0.41990400000000000000000000000000000000000000000000e3 * t2455 * t2354 - 0.83980800000000000000000000000000000000000000000000e3 * t2465 * t2351
  t2495 = 0.13996800000000000000000000000000000000000000000000e3 * t664 * t675 - 0.20995200000000000000000000000000000000000000000000e3 * t556 * t679 - 0.20995200000000000000000000000000000000000000000000e3 * t556 * t683 - 0.69984000000000000000000000000000000000000000000000e2 * t556 * t687 - 0.69984000000000000000000000000000000000000000000000e2 * t556 * t691 - 0.69984000000000000000000000000000000000000000000000e2 * t695 * t696 - 0.23328000000000000000000000000000000000000000000000e2 * t695 * t699 - 0.46656000000000000000000000000000000000000000000000e2 * t253 * t706 - 0.46656000000000000000000000000000000000000000000000e3 * t253 * t710 + 0.12e2 * t803 * t810 + r0 * (t1133 + t1264 + t1305 + t1346 + t1381 + t2002 + t2439 + t2472) - 0.41990400000000000000000000000000000000000000000000e3 * t566 * t1550 + 0.4e1 * t2262 * t2242 + 0.12e2 * t2167 * t844 + 0.4e1 * t1234 * t2161 + 0.46656000000000000000000000000000000000000000000000e2 * t1117 * t1241 + 0.77760000000000000000000000000000000000000000000000e1 * t1099 * t1241 + 0.41990400000000000000000000000000000000000000000000e3 * t2436 * t2230 + 0.27993600000000000000000000000000000000000000000000e3 * t561 * t829 + 0.46656000000000000000000000000000000000000000000000e2 * t561 * t839
  v4rho4_0_ = t673 + t2495

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t12 = jnp.sqrt(t11)
  t15 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t12 + 0.31385250000000000000000000000000000000000000000000e-1 * t11
  t16 = t15 ** 2
  t17 = 0.1e1 / t16
  t19 = 0.1e1 / t12 * t1
  t20 = t3 * t6
  t22 = 0.1e1 / t8 / t7
  t23 = t20 * t22
  t24 = t19 * t23
  t26 = t6 * t22
  t27 = t4 * t26
  t29 = -0.74083333333333333333333333333333333333333333333333e-2 * t24 - 0.10461750000000000000000000000000000000000000000000e-1 * t27
  t30 = t17 * t29
  t32 = 0.1e1 / t15
  t34 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t32)
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t40 = t35 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t44 = s0 + 0.2e1 * s1 + s2
  t45 = t42 * t44
  t46 = t7 ** 2
  t47 = t8 ** 2
  t49 = 0.1e1 / t47 / t46
  t51 = t40 * t45 * t49
  t53 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t51
  t54 = t53 ** (0.1e1 / 0.4e1)
  t56 = 0.1e1 - 0.1e1 / t54
  t57 = t34 * t56
  t60 = t34 - 0.1e1
  t62 = 0.1e1 / t54 / t53
  t64 = t60 * t62 * t35
  t65 = t39 * t42
  t66 = t46 * t7
  t68 = 0.1e1 / t47 / t66
  t69 = t44 * t68
  t73 = -0.10000000000000000000000000000000000000000000000000e1 * t30 * t57 - 0.14225094736250905555555555555555555555555555555555e-1 * t64 * t65 * t69
  t75 = t60 * t56 + 0.1e1
  t76 = 0.1e1 / t75
  t79 = 0.285764e-1 * t30 + 0.285764e-1 * t73 * t76
  t80 = t41 - 0.1e1
  t81 = r0 - r1
  t82 = 0.1e1 / t7
  t83 = t81 * t82
  t84 = 0.1e1 + t83
  t85 = t84 <= f.p.zeta_threshold
  t86 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t87 = t86 * f.p.zeta_threshold
  t88 = t84 ** (0.1e1 / 0.3e1)
  t89 = t88 * t84
  t90 = f.my_piecewise3(t85, t87, t89)
  t91 = 0.1e1 - t83
  t92 = t91 <= f.p.zeta_threshold
  t93 = t91 ** (0.1e1 / 0.3e1)
  t94 = t93 * t91
  t95 = f.my_piecewise3(t92, t87, t94)
  t96 = t90 + t95 - 0.2e1
  t99 = 0.1e1 / t80 / 0.2e1
  t102 = 0.1e1 - 0.2363e1 * t80 * t96 * t99
  t103 = t79 * t102
  t104 = t81 ** 2
  t105 = t104 ** 2
  t106 = t105 ** 2
  t107 = t106 * t105
  t108 = t46 ** 2
  t109 = t108 ** 2
  t111 = 0.1e1 / t109 / t108
  t113 = -t107 * t111 + 0.1e1
  t114 = r0 ** (0.1e1 / 0.3e1)
  t115 = t114 ** 2
  t118 = tau0 / t115 / r0
  t119 = t84 / 0.2e1
  t120 = t119 ** (0.1e1 / 0.3e1)
  t121 = t120 ** 2
  t122 = t121 * t119
  t125 = r1 ** (0.1e1 / 0.3e1)
  t126 = t125 ** 2
  t129 = tau1 / t126 / r1
  t130 = t91 / 0.2e1
  t131 = t130 ** (0.1e1 / 0.3e1)
  t132 = t131 ** 2
  t133 = t132 * t130
  t138 = 0.2e1 * t118 * t122 + 0.2e1 * t129 * t133 - t44 * t49 / 0.4e1
  t139 = t138 ** 2
  t140 = t139 * t138
  t141 = t36 ** 2
  t142 = 0.1e1 / t141
  t143 = t140 * t142
  t148 = 0.8e-1 + 0.5e1 / 0.18e2 * t138 * t42 * t40 + 0.12500000000000000000000000000000000000000000000000e-1 * t51
  t149 = t148 ** 2
  t150 = t149 * t148
  t151 = 0.1e1 / t150
  t152 = t143 * t151
  t154 = t139 ** 2
  t156 = t141 ** 2
  t157 = 0.1e1 / t156
  t158 = t154 * t139 * t157
  t159 = t149 ** 2
  t161 = 0.1e1 / t159 / t149
  t164 = 0.1e1 + 0.64800000000000000000000000000000000000000000000000e0 * t152 + 0.41990400000000000000000000000000000000000000000000e0 * t158 * t161
  t165 = 0.1e1 / t164
  t166 = t151 * t165
  t169 = 0.1e1 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t166
  t170 = t113 * t169
  t172 = 0.2e1 * t103 * t170
  t174 = jnp.log(t75)
  t176 = -0.285764e-1 * t32 + 0.285764e-1 * t174
  t177 = t176 * t80
  t178 = 0.1e1 / t46
  t179 = t81 * t178
  t180 = t82 - t179
  t183 = f.my_piecewise3(t85, 0, 0.4e1 / 0.3e1 * t88 * t180)
  t184 = -t180
  t187 = f.my_piecewise3(t92, 0, 0.4e1 / 0.3e1 * t93 * t184)
  t188 = t183 + t187
  t189 = t177 * t188
  t190 = t99 * t113
  t191 = t190 * t169
  t192 = t189 * t191
  t194 = t176 * t102
  t195 = t104 * t81
  t196 = t106 * t195
  t197 = t196 * t111
  t198 = t108 * t7
  t200 = 0.1e1 / t109 / t198
  t201 = t107 * t200
  t203 = -0.12e2 * t197 + 0.12e2 * t201
  t204 = t203 * t169
  t205 = t194 * t204
  t207 = t139 * t142
  t208 = r0 ** 2
  t211 = tau0 / t115 / t208
  t214 = t180 / 0.2e1
  t215 = t121 * t214
  t218 = -t214
  t219 = t132 * t218
  t222 = 0.2e1 / 0.3e1 * t69
  t223 = -0.10e2 / 0.3e1 * t211 * t122 + 0.10e2 / 0.3e1 * t118 * t215 + 0.10e2 / 0.3e1 * t129 * t219 + t222
  t224 = t166 * t223
  t227 = 0.1e1 / t159
  t228 = t227 * t165
  t233 = t40 * t45 * t68
  t234 = 0.33333333333333333333333333333333333333333333333333e-1 * t233
  t235 = 0.5e1 / 0.18e2 * t223 * t42 * t40 - t234
  t236 = t228 * t235
  t239 = t164 ** 2
  t240 = 0.1e1 / t239
  t241 = t151 * t240
  t249 = t154 * t138 * t157
  t254 = 0.1e1 / t159 / t150
  t258 = 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t223 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t235 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t223 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t235
  t259 = t241 * t258
  t262 = -0.58320000000000000000000000000000000000000000000000e1 * t207 * t224 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t236 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t259
  t263 = t113 * t262
  t264 = t194 * t263
  t268 = t11 ** 0.15e1
  t270 = t1 ** 2
  t271 = t3 ** 2
  t272 = t270 * t271
  t275 = t272 * t5 / t47
  t277 = 0.37978500000000000000000000000000000000000000000000e1 * t12 + 0.89690000000000000000000000000000000000000000000000e0 * t11 + 0.20477500000000000000000000000000000000000000000000e0 * t268 + 0.12323500000000000000000000000000000000000000000000e0 * t275
  t280 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t277
  t281 = jnp.log(t280)
  t284 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t26 * t281
  t286 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t11
  t287 = t277 ** 2
  t288 = 0.1e1 / t287
  t289 = t286 * t288
  t292 = t11 ** 0.5e0
  t293 = t292 * t1
  t294 = t293 * t23
  t299 = t272 * t5 / t47 / t7
  t301 = -0.63297500000000000000000000000000000000000000000000e0 * t24 - 0.29896666666666666666666666666666666666666666666667e0 * t27 - 0.10238750000000000000000000000000000000000000000000e0 * t294 - 0.82156666666666666666666666666666666666666666666667e-1 * t299
  t302 = 0.1e1 / t280
  t303 = t301 * t302
  t305 = 0.10000000000000000000000000000000000000000000000000e1 * t289 * t303
  t306 = 0.1e1 / t108
  t307 = t195 * t306
  t308 = t96 * t99
  t310 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t11
  t315 = 0.70594500000000000000000000000000000000000000000000e1 * t12 + 0.15494250000000000000000000000000000000000000000000e1 * t11 + 0.42077500000000000000000000000000000000000000000000e0 * t268 + 0.15629250000000000000000000000000000000000000000000e0 * t275
  t318 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t315
  t319 = jnp.log(t318)
  t323 = 0.621814e-1 * t286 * t281
  t325 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t11
  t330 = 0.51785000000000000000000000000000000000000000000000e1 * t12 + 0.90577500000000000000000000000000000000000000000000e0 * t11 + 0.11003250000000000000000000000000000000000000000000e0 * t268 + 0.12417750000000000000000000000000000000000000000000e0 * t275
  t333 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t330
  t334 = jnp.log(t333)
  t335 = t325 * t334
  t337 = -0.3109070e-1 * t310 * t319 + t323 - 0.19751673498613801407483339618206552048944131217655e-1 * t335
  t338 = t308 * t337
  t340 = 0.4e1 * t307 * t338
  t341 = 0.1e1 / t198
  t342 = t105 * t341
  t344 = 0.4e1 * t342 * t338
  t345 = t105 * t306
  t346 = t188 * t99
  t347 = t346 * t337
  t348 = t345 * t347
  t352 = t315 ** 2
  t353 = 0.1e1 / t352
  t354 = t310 * t353
  t359 = -0.11765750000000000000000000000000000000000000000000e1 * t24 - 0.51647500000000000000000000000000000000000000000000e0 * t27 - 0.21038750000000000000000000000000000000000000000000e0 * t294 - 0.10419500000000000000000000000000000000000000000000e0 * t299
  t360 = 0.1e1 / t318
  t361 = t359 * t360
  t367 = t330 ** 2
  t368 = 0.1e1 / t367
  t369 = t325 * t368
  t374 = -0.86308333333333333333333333333333333333333333333334e0 * t24 - 0.30192500000000000000000000000000000000000000000000e0 * t27 - 0.55016250000000000000000000000000000000000000000000e-1 * t294 - 0.82785000000000000000000000000000000000000000000000e-1 * t299
  t375 = 0.1e1 / t333
  t376 = t374 * t375
  t379 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t26 * t319 + 0.10000000000000000000000000000000000000000000000000e1 * t354 * t361 - t284 - t305 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t26 * t334 + 0.58482236226346462072622386637590534819724553404280e0 * t369 * t376
  t380 = t308 * t379
  t381 = t345 * t380
  t383 = 0.19751673498613801407483339618206552048944131217655e-1 * t346 * t335
  t384 = t308 * t1
  t386 = t20 * t22 * t334
  t388 = 0.18311447306006545054854346104378990962041954983034e-3 * t384 * t386
  t389 = t308 * t325
  t391 = t368 * t374 * t375
  t393 = 0.58482236226346462072622386637590534819724553404280e0 * t389 * t391
  t394 = t86 ** 2
  t395 = t88 ** 2
  t396 = f.my_piecewise3(t85, t394, t395)
  t397 = t93 ** 2
  t398 = f.my_piecewise3(t92, t394, t397)
  t400 = t396 / 0.2e1 + t398 / 0.2e1
  t401 = t400 ** 2
  t402 = t345 * t338
  t404 = 0.19751673498613801407483339618206552048944131217655e-1 * t308 * t335
  t405 = -t323 + t402 + t404
  t406 = t401 * t400
  t407 = 0.1e1 / t406
  t410 = jnp.exp(-0.32163648644302209642661863561802450870026695828375e2 * t405 * t407)
  t411 = t410 - 0.1e1
  t412 = jnp.log(0.2e1)
  t414 = 0.1e1 / (0.1e1 - t412)
  t415 = t414 * t36
  t416 = t405 * t414
  t417 = t36 * t407
  t419 = jnp.exp(-t416 * t417)
  t420 = t419 - 0.1e1
  t421 = 0.1e1 / t420
  t422 = t421 * t44
  t424 = 0.1e1 / t8 / t46
  t426 = t415 * t422 * t424
  t427 = 0.1e1 / t401
  t429 = 0.1e1 / t3
  t432 = t41 * t427 * t270 * t429 * t5
  t435 = 0.1e1 + 0.27802083333333333333333333333333333333333333333333e-2 * t426 * t432
  t436 = t435 ** (0.1e1 / 0.4e1)
  t438 = 0.1e1 - 0.1e1 / t436
  t440 = t411 * t438 + 0.1e1
  t441 = jnp.log(t440)
  t442 = t401 * t441
  t443 = 0.1e1 / t88
  t446 = f.my_piecewise3(t85, 0, 0.2e1 / 0.3e1 * t443 * t180)
  t447 = 0.1e1 / t93
  t450 = f.my_piecewise3(t92, 0, 0.2e1 / 0.3e1 * t447 * t184)
  t452 = t446 / 0.2e1 + t450 / 0.2e1
  t455 = t284 + t305 + t340 - t344 + t348 + t381 + t383 - t388 - t393
  t458 = t401 ** 2
  t459 = 0.1e1 / t458
  t460 = t405 * t459
  t463 = -0.32163648644302209642661863561802450870026695828375e2 * t455 * t407 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t452
  t464 = t463 * t410
  t467 = 0.1e1 / t436 / t435
  t468 = t411 * t467
  t469 = t420 ** 2
  t471 = t415 / t469
  t473 = t44 * t424 * t41
  t474 = t471 * t473
  t476 = t427 * t270 * t429
  t477 = t455 * t414
  t479 = t36 * t459
  t480 = t479 * t452
  t483 = 0.3e1 * t416 * t480 - t477 * t417
  t484 = t5 * t483
  t486 = t476 * t484 * t419
  t490 = 0.1e1 / t8 / t66
  t492 = t415 * t422 * t490
  t494 = 0.64871527777777777777777777777777777777777777777777e-2 * t492 * t432
  t496 = t41 * t407 * t270
  t497 = t429 * t5
  t499 = t496 * t497 * t452
  t502 = -0.27802083333333333333333333333333333333333333333333e-2 * t474 * t486 - t494 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t499
  t505 = t464 * t438 + t468 * t502 / 0.4e1
  t507 = 0.1e1 / t440
  t510 = t284 + t305 + t340 - t344 + t348 + t381 + t383 - t388 - t393 + 0.93273e-1 * t442 * t452 + 0.31091e-1 * t406 * t505 * t507
  t511 = t510 * t140
  t513 = t142 * t151 * t165
  t514 = t511 * t513
  t518 = -t323 + t402 + t404 + 0.31091e-1 * t406 * t441
  t520 = t518 * t139 * t142
  t521 = t520 * t224
  t524 = t518 * t140 * t142
  t525 = t524 * t236
  t527 = t524 * t259
  t529 = t138 * t142
  t530 = t223 ** 2
  t546 = 0.1e1 / t120
  t547 = t214 ** 2
  t551 = 0.1e1 / t66
  t552 = t81 * t551
  t553 = -t178 + t552
  t557 = 0.1e1 / t131
  t558 = t218 ** 2
  t567 = 0.1e1 / t47 / t108
  t568 = t44 * t567
  t569 = 0.22e2 / 0.9e1 * t568
  t570 = 0.80e2 / 0.9e1 * tau0 / t115 / t208 / r0 * t122 - 0.100e3 / 0.9e1 * t211 * t215 + 0.20e2 / 0.9e1 * t118 * t546 * t547 + 0.10e2 / 0.3e1 * t118 * t121 * t553 + 0.20e2 / 0.9e1 * t129 * t557 * t558 - 0.10e2 / 0.3e1 * t129 * t132 * t553 - t569
  t575 = 0.1e1 / t159 / t148
  t576 = t235 ** 2
  t585 = 0.12222222222222222222222222222222222222222222222222e0 * t40 * t45 * t567
  t586 = 0.5e1 / 0.18e2 * t570 * t42 * t40 + t585
  t590 = t154 * t157
  t601 = t159 ** 2
  t602 = 0.1e1 / t601
  t610 = t241 * (0.38880000000000000000000000000000000000000000000000e1 * t529 * t151 * t530 - 0.11664000000000000000000000000000000000000000000000e2 * t207 * t227 * t223 * t235 + 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t570 + 0.77760000000000000000000000000000000000000000000000e1 * t143 * t575 * t576 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t586 + 0.12597120000000000000000000000000000000000000000000e2 * t590 * t161 * t530 - 0.30233088000000000000000000000000000000000000000000e2 * t249 * t254 * t223 * t235 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t570 + 0.17635968000000000000000000000000000000000000000000e2 * t158 * t602 * t576 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t586)
  t613 = t228 * t586
  t616 = t166 * t570
  t619 = t511 * t142
  t623 = t510 * t139 * t142
  t628 = t166 * t530
  t631 = t207 * t227
  t636 = t207 * t151
  t643 = t575 * t165
  t644 = t643 * t576
  t647 = t143 * t227
  t655 = 0.1e1 / t239 / t164
  t656 = t151 * t655
  t657 = t258 ** 2
  t658 = t656 * t657
  t666 = 0.1e1 / t395
  t667 = t180 ** 2
  t670 = 0.2e1 * t553
  t674 = f.my_piecewise3(t85, 0, 0.4e1 / 0.9e1 * t666 * t667 + 0.4e1 / 0.3e1 * t88 * t670)
  t675 = 0.1e1 / t397
  t676 = t184 ** 2
  t679 = -t670
  t683 = f.my_piecewise3(t92, 0, 0.4e1 / 0.9e1 * t675 * t676 + 0.4e1 / 0.3e1 * t93 * t679)
  t684 = t674 + t683
  t689 = t99 * t203 * t169
  t692 = t190 * t262
  t699 = t271 * t5 * t49
  t700 = 0.1e1 / t12 / t11 * t270 * t699
  t702 = t20 * t424
  t703 = t19 * t702
  t705 = t6 * t424
  t706 = t4 * t705
  t708 = t11 ** (-0.5e0)
  t710 = t708 * t270 * t699
  t712 = t293 * t702
  t715 = t272 * t5 * t49
  t717 = -0.57538888888888888888888888888888888888888888888889e0 * t700 + 0.11507777777777777777777777777777777777777777777778e1 * t703 + 0.40256666666666666666666666666666666666666666666667e0 * t706 + 0.36677500000000000000000000000000000000000000000000e-1 * t710 + 0.73355000000000000000000000000000000000000000000000e-1 * t712 + 0.13797500000000000000000000000000000000000000000000e0 * t715
  t721 = 0.58482236226346462072622386637590534819724553404280e0 * t389 * t368 * t717 * t375
  t722 = t367 ** 2
  t723 = 0.1e1 / t722
  t724 = t374 ** 2
  t726 = t333 ** 2
  t727 = 0.1e1 / t726
  t730 = 0.17315859105681463759666483083807725165579399831905e2 * t389 * t723 * t724 * t727
  t732 = t346 * t325 * t391
  t733 = 0.11696447245269292414524477327518106963944910680856e1 * t732
  t735 = 0.1e1 / t367 / t330
  t739 = 0.11696447245269292414524477327518106963944910680856e1 * t389 * t735 * t724 * t375
  t741 = 0.8e1 * t342 * t380
  t742 = t307 * t347
  t743 = 0.8e1 * t742
  t745 = 0.8e1 * t307 * t380
  t746 = t287 ** 2
  t749 = t301 ** 2
  t750 = t280 ** 2
  t754 = 0.16081979498692535066756296899072713062105388428051e2 * t286 / t746 * t749 / t750
  t760 = 0.20000000000000000000000000000000000000000000000000e1 * t286 / t287 / t277 * t749 * t302
  t770 = 0.10000000000000000000000000000000000000000000000000e1 * t289 * (-0.42198333333333333333333333333333333333333333333333e0 * t700 + 0.84396666666666666666666666666666666666666666666666e0 * t703 + 0.39862222222222222222222222222222222222222222222223e0 * t706 + 0.68258333333333333333333333333333333333333333333333e-1 * t710 + 0.13651666666666666666666666666666666666666666666667e0 * t712 + 0.13692777777777777777777777777777777777777777777778e0 * t715) * t302
  t774 = 0.10843581300301739842632067522386578331157260943710e-1 * t308 * t4 * t26 * t391
  t776 = t345 * t346 * t379
  t777 = 0.2e1 * t776
  t778 = t342 * t347
  t779 = 0.8e1 * t778
  t780 = t684 * t99
  t782 = t345 * t780 * t337
  t783 = -t721 - t730 - t733 + t739 - t741 + t743 + t745 + t754 - t760 + t770 + t774 + t777 - t779 + t782
  t785 = 0.19751673498613801407483339618206552048944131217655e-1 * t780 * t335
  t788 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t705 * t281
  t789 = t108 * t46
  t793 = 0.20e2 * t105 / t789 * t338
  t796 = 0.12e2 * t104 * t306 * t338
  t799 = 0.32e2 * t195 * t341 * t338
  t803 = t4 * t6
  t811 = t359 ** 2
  t825 = t352 ** 2
  t828 = t318 ** 2
  t836 = 0.35616666666666666666666666666666666666666666666666e-1 * t803 * t22 * t288 * t303
  t855 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t705 * t319 - 0.34246666666666666666666666666666666666666666666666e-1 * t803 * t22 * t353 * t361 - 0.20000000000000000000000000000000000000000000000000e1 * t310 / t352 / t315 * t811 * t360 + 0.10000000000000000000000000000000000000000000000000e1 * t354 * (-0.78438333333333333333333333333333333333333333333333e0 * t700 + 0.15687666666666666666666666666666666666666666666667e1 * t703 + 0.68863333333333333333333333333333333333333333333333e0 * t706 + 0.14025833333333333333333333333333333333333333333333e0 * t710 + 0.28051666666666666666666666666666666666666666666667e0 * t712 + 0.17365833333333333333333333333333333333333333333333e0 * t715) * t360 + 0.32163958997385070133512593798145426124210776856102e2 * t310 / t825 * t811 / t828 + t788 + t836 + t760 - t770 - t754 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t705 * t334 - 0.10843581300301739842632067522386578331157260943710e-1 * t803 * t22 * t368 * t376 - 0.11696447245269292414524477327518106963944910680856e1 * t325 * t735 * t724 * t375 + 0.58482236226346462072622386637590534819724553404280e0 * t369 * t717 * t375 + 0.17315859105681463759666483083807725165579399831905e2 * t325 * t723 * t724 * t727
  t857 = t345 * t308 * t855
  t858 = t401 * t505
  t859 = t507 * t452
  t865 = 0.24415263074675393406472461472505321282722606644045e-3 * t384 * t20 * t424 * t334
  t867 = t346 * t1 * t386
  t868 = 0.36622894612013090109708692208757981924083909966068e-3 * t867
  t869 = t785 + t754 + t770 - t721 - t730 - t733 + t793 + t796 - t799 - t788 + t857
  t870 = t782 + t777 - t779 - t741 + t743 + t745 - t760 - t868 + t739 - t836 + t774 + t865
  t871 = t869 + t870
  t874 = t455 * t459
  t878 = 0.1e1 / t458 / t400
  t879 = t405 * t878
  t880 = t452 ** 2
  t883 = 0.1e1 / t89
  t889 = f.my_piecewise3(t85, 0, -0.2e1 / 0.9e1 * t883 * t667 + 0.2e1 / 0.3e1 * t443 * t670)
  t890 = 0.1e1 / t94
  t896 = f.my_piecewise3(t92, 0, -0.2e1 / 0.9e1 * t890 * t676 + 0.2e1 / 0.3e1 * t447 * t679)
  t898 = t889 / 0.2e1 + t896 / 0.2e1
  t904 = t463 ** 2
  t907 = t467 * t502
  t910 = t435 ** 2
  t913 = t411 / t436 / t910
  t914 = t502 ** 2
  t920 = t415 / t469 / t420 * t473
  t921 = t483 ** 2
  t922 = t5 * t921
  t923 = t419 ** 2
  t930 = t471 * t44 * t490 * t41
  t931 = t930 * t486
  t934 = t407 * t270 * t429
  t935 = t419 * t452
  t944 = t36 * t878
  t966 = 0.21623842592592592592592592592592592592592592592592e-1 * t415 * t422 / t8 / t108 * t432
  t967 = t492 * t499
  t970 = t41 * t459 * t270
  t986 = t505 ** 2
  t988 = t440 ** 2
  t989 = 0.1e1 / t988
  t992 = t400 * t441
  t997 = t785 - t788 + t793 + t796 - t799 + t857 + 0.186546e0 * t858 * t859 + t865 - t836 - t868 + 0.31091e-1 * t406 * ((-0.32163648644302209642661863561802450870026695828375e2 * t871 * t407 + 0.19298189186581325785597118137081470522016017497025e3 * t874 * t452 - 0.38596378373162651571194236274162941044032034994050e3 * t879 * t880 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t898) * t410 * t438 + t904 * t410 * t438 + t464 * t907 / 0.2e1 - 0.5e1 / 0.16e2 * t913 * t914 + t468 * (0.55604166666666666666666666666666666666666666666666e-2 * t920 * t476 * t922 * t923 + 0.12974305555555555555555555555555555555555555555555e-1 * t931 + 0.11120833333333333333333333333333333333333333333333e-1 * t474 * t934 * t484 * t935 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t5 * (-t871 * t414 * t417 + 0.3e1 * t416 * t479 * t898 - 0.12e2 * t416 * t944 * t880 + 0.6e1 * t477 * t480) * t419 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t922 * t419 + t966 + 0.25948611111111111111111111111111111111111111111110e-1 * t967 + 0.16681250000000000000000000000000000000000000000000e-1 * t426 * t970 * t497 * t880 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t496 * t497 * t898) / 0.4e1) * t507 - 0.31091e-1 * t406 * t986 * t989 + 0.186546e0 * t992 * t880 + 0.93273e-1 * t442 * t898
  t1002 = -0.19440000000000000000000000000000000000000000000000e1 * t524 * t610 - 0.58320000000000000000000000000000000000000000000000e1 * t524 * t613 + 0.58320000000000000000000000000000000000000000000000e1 * t520 * t616 - 0.38880000000000000000000000000000000000000000000000e1 * t619 * t259 + 0.11664000000000000000000000000000000000000000000000e2 * t623 * t224 - 0.11664000000000000000000000000000000000000000000000e2 * t619 * t236 + t194 * t113 * (-0.11664000000000000000000000000000000000000000000000e2 * t529 * t628 + 0.34992000000000000000000000000000000000000000000000e2 * t631 * t165 * t223 * t235 + 0.11664000000000000000000000000000000000000000000000e2 * t636 * t240 * t223 * t258 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t616 - 0.23328000000000000000000000000000000000000000000000e2 * t143 * t644 - 0.11664000000000000000000000000000000000000000000000e2 * t647 * t240 * t235 * t258 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t613 - 0.38880000000000000000000000000000000000000000000000e1 * t143 * t658 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t610) - 0.2363e1 * t177 * t684 * t191 - 0.4726e1 * t189 * t689 - 0.4726e1 * t189 * t692 + 0.19440000000000000000000000000000000000000000000000e1 * (t783 + t997) * t140 * t513
  t1005 = 0.132e3 * t106 * t104 * t111
  t1007 = 0.288e3 * t196 * t200
  t1011 = 0.156e3 * t107 / t109 / t789
  t1018 = t103 * t204
  t1020 = t103 * t263
  t1024 = t29 ** 2
  t1025 = 0.1e1 / t16 / t15 * t1024
  t1031 = t17 * (-0.49388888888888888888888888888888888888888888888889e-2 * t700 + 0.98777777777777777777777777777777777777777777777777e-2 * t703 + 0.13949000000000000000000000000000000000000000000000e-1 * t706)
  t1037 = t16 ** 2
  t1046 = t53 ** 2
  t1050 = t35 ** 2
  t1055 = t44 ** 2
  t1069 = t73 ** 2
  t1070 = t75 ** 2
  t1076 = (-0.571528e-1 * t1025 + 0.285764e-1 * t1031 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t1025 * t57 - 0.10000000000000000000000000000000000000000000000000e1 * t1031 * t57 + 0.10000000000000000000000000000000000000000000000000e1 / t1037 * t1024 * t57 + 0.28450189472501811111111111111111111111111111111110e-1 * t30 * t34 * t62 * t233 - 0.20235332025531322029119593137558641975308641975307e-2 * t60 / t54 / t1046 * t1050 / t37 / t36 * t41 * t1055 / t8 / t108 / t66 + 0.52158680699586653703703703703703703703703703703702e-1 * t64 * t65 * t568) * t76 - 0.285764e-1 * t1069 / t1070) * t102 * t170
  t1080 = t518 * t138 * t142
  t1093 = t227 * t240
  t1098 = t79 * t80
  t1100 = t1098 * t188 * t191
  t1102 = t194 * (-t1005 + t1007 - t1011) * t169 + 0.2e1 * t194 * t203 * t262 + 0.2e1 * t1018 + 0.2e1 * t1020 + t1076 + 0.38880000000000000000000000000000000000000000000000e1 * t524 * t658 + 0.11664000000000000000000000000000000000000000000000e2 * t1080 * t628 - 0.34992000000000000000000000000000000000000000000000e2 * t520 * t228 * t223 * t235 - 0.11664000000000000000000000000000000000000000000000e2 * t520 * t241 * t223 * t258 + 0.23328000000000000000000000000000000000000000000000e2 * t524 * t644 + 0.11664000000000000000000000000000000000000000000000e2 * t524 * t1093 * t235 * t258 - 0.4726e1 * t1100
  d11 = t172 - 0.4726e1 * t192 + 0.2e1 * t205 + 0.2e1 * t264 + 0.38880000000000000000000000000000000000000000000000e1 * t514 + 0.11664000000000000000000000000000000000000000000000e2 * t521 - 0.11664000000000000000000000000000000000000000000000e2 * t525 - 0.38880000000000000000000000000000000000000000000000e1 * t527 + t7 * (t1002 + t1102)
  t1110 = -t82 - t179
  t1113 = f.my_piecewise3(t85, 0, 0.4e1 / 0.3e1 * t88 * t1110)
  t1114 = -t1110
  t1117 = f.my_piecewise3(t92, 0, 0.4e1 / 0.3e1 * t93 * t1114)
  t1118 = t1113 + t1117
  t1119 = t177 * t1118
  t1120 = t1119 * t191
  t1123 = 0.12e2 * t197 + 0.12e2 * t201
  t1124 = t1123 * t169
  t1125 = t194 * t1124
  t1126 = t1110 / 0.2e1
  t1127 = t121 * t1126
  t1130 = r1 ** 2
  t1133 = tau1 / t126 / t1130
  t1136 = -t1126
  t1137 = t132 * t1136
  t1140 = 0.10e2 / 0.3e1 * t118 * t1127 - 0.10e2 / 0.3e1 * t1133 * t133 + 0.10e2 / 0.3e1 * t129 * t1137 + t222
  t1141 = t166 * t1140
  t1147 = 0.5e1 / 0.18e2 * t1140 * t42 * t40 - t234
  t1148 = t228 * t1147
  t1151 = t151 * t1140
  t1154 = t227 * t1147
  t1157 = t161 * t1140
  t1160 = t254 * t1147
  t1163 = 0.19440000000000000000000000000000000000000000000000e1 * t207 * t1151 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1154 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t1157 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t1160
  t1164 = t241 * t1163
  t1167 = -0.58320000000000000000000000000000000000000000000000e1 * t207 * t1141 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t1148 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1164
  t1168 = t113 * t1167
  t1169 = t194 * t1168
  t1170 = t1118 * t99
  t1171 = t1170 * t337
  t1172 = t345 * t1171
  t1174 = 0.19751673498613801407483339618206552048944131217655e-1 * t1170 * t335
  t1177 = f.my_piecewise3(t85, 0, 0.2e1 / 0.3e1 * t443 * t1110)
  t1180 = f.my_piecewise3(t92, 0, 0.2e1 / 0.3e1 * t447 * t1114)
  t1182 = t1177 / 0.2e1 + t1180 / 0.2e1
  t1185 = t284 + t305 - t340 - t344 + t1172 + t381 + t1174 - t388 - t393
  t1190 = -0.32163648644302209642661863561802450870026695828375e2 * t1185 * t407 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t1182
  t1191 = t1190 * t410
  t1193 = t1185 * t414
  t1195 = t479 * t1182
  t1198 = -t1193 * t417 + 0.3e1 * t416 * t1195
  t1199 = t5 * t1198
  t1201 = t476 * t1199 * t419
  t1205 = t496 * t497 * t1182
  t1208 = -0.27802083333333333333333333333333333333333333333333e-2 * t474 * t1201 - t494 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t1205
  t1211 = t1191 * t438 + t468 * t1208 / 0.4e1
  t1212 = t406 * t1211
  t1215 = t284 + t305 - t340 - t344 + t1172 + t381 + t1174 - t388 - t393 + 0.93273e-1 * t442 * t1182 + 0.31091e-1 * t1212 * t507
  t1216 = t1215 * t140
  t1217 = t1216 * t513
  t1219 = t520 * t1141
  t1221 = t524 * t1148
  t1223 = t524 * t1164
  t1226 = t99 * t1123 * t169
  t1229 = t1216 * t142
  t1232 = t190 * t1167
  t1260 = -0.50e2 / 0.9e1 * t211 * t1127 + 0.20e2 / 0.9e1 * t118 * t546 * t1126 * t214 + 0.10e2 / 0.3e1 * t118 * t121 * t81 * t551 - 0.50e2 / 0.9e1 * t1133 * t219 + 0.20e2 / 0.9e1 * t129 * t557 * t1136 * t218 - 0.10e2 / 0.3e1 * t129 * t132 * t81 * t551 - t569
  t1264 = 0.5e1 / 0.18e2 * t1260 * t42 * t40 + t585
  t1265 = t228 * t1264
  t1271 = t1215 * t139 * t142
  t1277 = t227 * t1140
  t1297 = t254 * t1140
  t1314 = 0.38880000000000000000000000000000000000000000000000e1 * t529 * t1151 * t223 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1277 * t235 + 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t1260 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1154 * t223 + 0.77760000000000000000000000000000000000000000000000e1 * t143 * t575 * t1147 * t235 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t1264 + 0.12597120000000000000000000000000000000000000000000e2 * t590 * t1157 * t223 - 0.15116544000000000000000000000000000000000000000000e2 * t249 * t1297 * t235 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t1260 - 0.15116544000000000000000000000000000000000000000000e2 * t249 * t1160 * t223 + 0.17635968000000000000000000000000000000000000000000e2 * t158 * t602 * t1147 * t235 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t1264
  t1315 = t241 * t1314
  t1319 = t1098 * t1118 * t191
  t1328 = f.my_piecewise3(t85, 0, 0.4e1 / 0.9e1 * t666 * t1110 * t180 + 0.8e1 / 0.3e1 * t88 * t81 * t551)
  t1336 = f.my_piecewise3(t92, 0, 0.4e1 / 0.9e1 * t675 * t1114 * t184 - 0.8e1 / 0.3e1 * t93 * t81 * t551)
  t1337 = t1328 + t1336
  t1343 = 0.58482236226346462072622386637590534819724553404280e0 * t732
  t1344 = 0.4e1 * t742
  t1345 = t307 * t1171
  t1346 = 0.4e1 * t1345
  t1347 = t342 * t1171
  t1348 = 0.4e1 * t1347
  t1349 = t1182 * t452
  t1352 = t401 * t1211
  t1355 = 0.4e1 * t778
  t1356 = -t721 - t730 - t1343 + t739 - t741 - t1344 + t1346 - t1348 + t754 + 0.186546e0 * t992 * t1349 - t760 + t770 + 0.93273e-1 * t1352 * t859 + t774 + t776 - t1355
  t1357 = t1337 * t99
  t1359 = 0.19751673498613801407483339618206552048944131217655e-1 * t1357 * t335
  t1361 = t1170 * t1 * t386
  t1362 = 0.18311447306006545054854346104378990962041954983034e-3 * t1361
  t1364 = t345 * t1357 * t337
  t1366 = t345 * t1170 * t379
  t1370 = -t721 - t730 - t1343 + t739 - t741 - t1344 + t1346 - t1348 + t754 - t760 + t770 + t774 + t776
  t1372 = t1170 * t325 * t391
  t1373 = 0.58482236226346462072622386637590534819724553404280e0 * t1372
  t1374 = 0.18311447306006545054854346104378990962041954983034e-3 * t867
  t1375 = -t1355 + t1359 - t1362 + t1364 + t1366 - t788 + t793 - t796 + t857 - t1373 + t865 - t836 - t1374
  t1376 = t1370 + t1375
  t1379 = t1185 * t459
  t1393 = f.my_piecewise3(t85, 0, -0.2e1 / 0.9e1 * t883 * t1110 * t180 + 0.4e1 / 0.3e1 * t443 * t81 * t551)
  t1401 = f.my_piecewise3(t92, 0, -0.2e1 / 0.9e1 * t890 * t1114 * t184 - 0.4e1 / 0.3e1 * t447 * t81 * t551)
  t1403 = t1393 / 0.2e1 + t1401 / 0.2e1
  t1414 = t467 * t1208
  t1425 = t930 * t1201
  t1451 = t483 * t419
  t1458 = t5 * t1182
  t1463 = t492 * t1205
  t1477 = 0.55604166666666666666666666666666666666666666666666e-2 * t920 * t476 * t1199 * t923 * t483 + 0.64871527777777777777777777777777777777777777777777e-2 * t1425 + 0.55604166666666666666666666666666666666666666666666e-2 * t474 * t934 * t1199 * t935 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t5 * (-0.12e2 * t416 * t36 * t878 * t1182 * t452 - t1376 * t414 * t417 + 0.3e1 * t416 * t479 * t1403 + 0.3e1 * t1193 * t480 + 0.3e1 * t477 * t1195) * t419 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t1199 * t1451 + 0.64871527777777777777777777777777777777777777777777e-2 * t931 + t966 + 0.12974305555555555555555555555555555555555555555555e-1 * t967 + 0.55604166666666666666666666666666666666666666666666e-2 * t474 * t934 * t1458 * t1451 + 0.12974305555555555555555555555555555555555555555555e-1 * t1463 + 0.16681250000000000000000000000000000000000000000000e-1 * t415 * t421 * t473 * t459 * t270 * t429 * t1458 * t452 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t496 * t497 * t1403
  t1486 = t507 * t1182
  t1489 = t1359 - t1362 + t1364 + t1366 - t788 + t793 - t796 + t857 - 0.31091e-1 * t1212 * t989 * t505 + 0.31091e-1 * t406 * ((-0.32163648644302209642661863561802450870026695828375e2 * t1376 * t407 + 0.96490945932906628927985590685407352610080087485125e2 * t1379 * t452 + 0.96490945932906628927985590685407352610080087485125e2 * t874 * t1182 - 0.38596378373162651571194236274162941044032034994050e3 * t879 * t1349 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t1403) * t410 * t438 + t1190 * t463 * t410 * t438 + t1191 * t907 / 0.4e1 + t464 * t1414 / 0.4e1 - 0.5e1 / 0.16e2 * t913 * t1208 * t502 + t468 * t1477 / 0.4e1) * t507 + 0.93273e-1 * t442 * t1403 - t1373 + t865 - t836 - t1374 + 0.93273e-1 * t858 * t1486
  t1495 = t165 * t1140
  t1502 = t240 * t1140
  t1506 = t166 * t1260
  t1509 = t165 * t1147
  t1517 = t240 * t1147
  t1523 = t240 * t1163
  t1536 = -0.11664000000000000000000000000000000000000000000000e2 * t529 * t151 * t1495 * t223 + 0.17496000000000000000000000000000000000000000000000e2 * t631 * t1495 * t235 + 0.58320000000000000000000000000000000000000000000000e1 * t636 * t1502 * t258 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1506 + 0.17496000000000000000000000000000000000000000000000e2 * t631 * t1509 * t223 - 0.23328000000000000000000000000000000000000000000000e2 * t143 * t575 * t1509 * t235 - 0.58320000000000000000000000000000000000000000000000e1 * t647 * t1517 * t258 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t1265 + 0.58320000000000000000000000000000000000000000000000e1 * t636 * t1523 * t223 - 0.58320000000000000000000000000000000000000000000000e1 * t647 * t1523 * t235 - 0.38880000000000000000000000000000000000000000000000e1 * t152 * t655 * t1163 * t258 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1315
  t1539 = -0.2363e1 * t189 * t1226 - 0.19440000000000000000000000000000000000000000000000e1 * t1229 * t259 - 0.2363e1 * t189 * t1232 - 0.2363e1 * t1100 - 0.2363e1 * t1119 * t692 - 0.19440000000000000000000000000000000000000000000000e1 * t619 * t1164 - 0.58320000000000000000000000000000000000000000000000e1 * t524 * t1265 - 0.58320000000000000000000000000000000000000000000000e1 * t1229 * t236 + 0.58320000000000000000000000000000000000000000000000e1 * t1271 * t224 - 0.19440000000000000000000000000000000000000000000000e1 * t524 * t1315 - 0.2363e1 * t1319 - 0.2363e1 * t177 * t1337 * t191 - 0.2363e1 * t1119 * t689 + 0.19440000000000000000000000000000000000000000000000e1 * (t1356 + t1489) * t140 * t513 + t194 * t113 * t1536 + t1020 + t1076
  t1540 = t103 * t1124
  t1548 = t103 * t1168
  t1591 = t1018 + t1540 + t194 * (t1005 - t1011) * t169 + t194 * t1123 * t262 + t194 * t203 * t1167 + t1548 - 0.58320000000000000000000000000000000000000000000000e1 * t619 * t1148 + 0.58320000000000000000000000000000000000000000000000e1 * t520 * t1506 + 0.58320000000000000000000000000000000000000000000000e1 * t623 * t1141 - 0.58320000000000000000000000000000000000000000000000e1 * t520 * t241 * t1163 * t223 + 0.58320000000000000000000000000000000000000000000000e1 * t524 * t1093 * t1163 * t235 + 0.38880000000000000000000000000000000000000000000000e1 * t524 * t656 * t1163 * t258 + 0.11664000000000000000000000000000000000000000000000e2 * t1080 * t166 * t1140 * t223 - 0.17496000000000000000000000000000000000000000000000e2 * t520 * t228 * t1140 * t235 - 0.58320000000000000000000000000000000000000000000000e1 * t520 * t241 * t1140 * t258 - 0.17496000000000000000000000000000000000000000000000e2 * t520 * t228 * t1147 * t223 + 0.23328000000000000000000000000000000000000000000000e2 * t524 * t643 * t1147 * t235 + 0.58320000000000000000000000000000000000000000000000e1 * t524 * t1093 * t1147 * t258
  d12 = t172 - 0.2363e1 * t192 + t205 + t264 + 0.19440000000000000000000000000000000000000000000000e1 * t514 + 0.58320000000000000000000000000000000000000000000000e1 * t521 - 0.58320000000000000000000000000000000000000000000000e1 * t525 - 0.19440000000000000000000000000000000000000000000000e1 * t527 - 0.2363e1 * t1120 + t1125 + t1169 + 0.19440000000000000000000000000000000000000000000000e1 * t1217 + 0.58320000000000000000000000000000000000000000000000e1 * t1219 - 0.58320000000000000000000000000000000000000000000000e1 * t1221 - 0.19440000000000000000000000000000000000000000000000e1 * t1223 + t7 * (t1539 + t1591)
  t1601 = t1126 ** 2
  t1605 = t178 + t552
  t1617 = t1136 ** 2
  t1625 = 0.20e2 / 0.9e1 * t118 * t546 * t1601 + 0.10e2 / 0.3e1 * t118 * t121 * t1605 + 0.80e2 / 0.9e1 * tau1 / t126 / t1130 / r1 * t133 - 0.100e3 / 0.9e1 * t1133 * t1137 + 0.20e2 / 0.9e1 * t129 * t557 * t1617 - 0.10e2 / 0.3e1 * t129 * t132 * t1605 - t569
  t1629 = 0.5e1 / 0.18e2 * t1625 * t42 * t40 + t585
  t1630 = t228 * t1629
  t1647 = t166 * t1625
  t1650 = t1140 ** 2
  t1660 = t1147 ** 2
  t1683 = t241 * (0.38880000000000000000000000000000000000000000000000e1 * t529 * t151 * t1650 - 0.11664000000000000000000000000000000000000000000000e2 * t207 * t1277 * t1147 + 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t1625 + 0.77760000000000000000000000000000000000000000000000e1 * t143 * t575 * t1660 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t1629 + 0.12597120000000000000000000000000000000000000000000e2 * t590 * t161 * t1650 - 0.30233088000000000000000000000000000000000000000000e2 * t249 * t1297 * t1147 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t1625 + 0.17635968000000000000000000000000000000000000000000e2 * t158 * t602 * t1660 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t1629)
  t1686 = -0.58320000000000000000000000000000000000000000000000e1 * t524 * t1630 - 0.11664000000000000000000000000000000000000000000000e2 * t1229 * t1148 - 0.38880000000000000000000000000000000000000000000000e1 * t1229 * t1164 + 0.11664000000000000000000000000000000000000000000000e2 * t1271 * t1141 + t194 * (-t1005 - t1007 - t1011) * t169 + 0.2e1 * t194 * t1123 * t1167 + 0.2e1 * t1540 + 0.2e1 * t1548 + t1076 + 0.58320000000000000000000000000000000000000000000000e1 * t520 * t1647 - 0.19440000000000000000000000000000000000000000000000e1 * t524 * t1683
  t1687 = 0.8e1 * t1345
  t1688 = 0.8e1 * t1347
  t1691 = t1110 ** 2
  t1694 = 0.2e1 * t1605
  t1698 = f.my_piecewise3(t85, 0, 0.4e1 / 0.9e1 * t666 * t1691 + 0.4e1 / 0.3e1 * t88 * t1694)
  t1699 = t1114 ** 2
  t1702 = -t1694
  t1706 = f.my_piecewise3(t92, 0, 0.4e1 / 0.9e1 * t675 * t1699 + 0.4e1 / 0.3e1 * t93 * t1702)
  t1707 = t1698 + t1706
  t1708 = t1707 * t99
  t1710 = 0.19751673498613801407483339618206552048944131217655e-1 * t1708 * t335
  t1711 = 0.36622894612013090109708692208757981924083909966068e-3 * t1361
  t1713 = t345 * t1708 * t337
  t1714 = 0.2e1 * t1366
  t1715 = t799 + t739 + t1710 - t1711 - t836 + t774 + t1713 + t1714 + t796 - t1688 - t741
  t1716 = 0.11696447245269292414524477327518106963944910680856e1 * t1372
  t1717 = t770 + t754 - t1687 - t745 - t760 - t788 + t857 - t1716 - t721 - t730 + t793 + t865
  t1718 = t1715 + t1717
  t1723 = t1182 ** 2
  t1731 = f.my_piecewise3(t85, 0, -0.2e1 / 0.9e1 * t883 * t1691 + 0.2e1 / 0.3e1 * t443 * t1694)
  t1737 = f.my_piecewise3(t92, 0, -0.2e1 / 0.9e1 * t890 * t1699 + 0.2e1 / 0.3e1 * t447 * t1702)
  t1739 = t1731 / 0.2e1 + t1737 / 0.2e1
  t1745 = t1190 ** 2
  t1750 = t1208 ** 2
  t1753 = t1198 ** 2
  t1754 = t5 * t1753
  t1801 = -t721 - t730 + t739 - t741 - t745 - t1687 - t1688 + t754 - t760 + t770 + 0.186546e0 * t1352 * t1486 + t774 + 0.31091e-1 * t406 * ((-0.32163648644302209642661863561802450870026695828375e2 * t1718 * t407 + 0.19298189186581325785597118137081470522016017497025e3 * t1379 * t1182 - 0.38596378373162651571194236274162941044032034994050e3 * t879 * t1723 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t1739) * t410 * t438 + t1745 * t410 * t438 + t1191 * t1414 / 0.2e1 - 0.5e1 / 0.16e2 * t913 * t1750 + t468 * (0.55604166666666666666666666666666666666666666666666e-2 * t920 * t476 * t1754 * t923 + 0.12974305555555555555555555555555555555555555555555e-1 * t1425 + 0.11120833333333333333333333333333333333333333333333e-1 * t474 * t934 * t1199 * t419 * t1182 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t5 * (-t1718 * t414 * t417 - 0.12e2 * t416 * t944 * t1723 + 0.3e1 * t416 * t479 * t1739 + 0.6e1 * t1193 * t1195) * t419 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t1754 * t419 + t966 + 0.25948611111111111111111111111111111111111111111110e-1 * t1463 + 0.16681250000000000000000000000000000000000000000000e-1 * t426 * t970 * t497 * t1723 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t496 * t497 * t1739) / 0.4e1) * t507 - t1711
  t1806 = t1211 ** 2
  t1810 = t1714 + t1713 - t788 + t793 + t796 + t799 + t857 + t1710 - t1716 + t865 - t836 + 0.186546e0 * t992 * t1723 + 0.93273e-1 * t442 * t1739 - 0.31091e-1 * t406 * t1806 * t989
  t1827 = t1163 ** 2
  t1828 = t656 * t1827
  t1831 = t166 * t1650
  t1842 = t643 * t1660
  t1869 = 0.19440000000000000000000000000000000000000000000000e1 * (t1801 + t1810) * t140 * t513 - 0.2363e1 * t177 * t1707 * t191 - 0.4726e1 * t1119 * t1226 - 0.4726e1 * t1119 * t1232 - 0.4726e1 * t1319 + 0.11664000000000000000000000000000000000000000000000e2 * t524 * t1093 * t1147 * t1163 + 0.38880000000000000000000000000000000000000000000000e1 * t524 * t1828 + t194 * t113 * (-0.11664000000000000000000000000000000000000000000000e2 * t529 * t1831 + 0.34992000000000000000000000000000000000000000000000e2 * t631 * t1495 * t1147 + 0.11664000000000000000000000000000000000000000000000e2 * t636 * t1502 * t1163 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1647 - 0.23328000000000000000000000000000000000000000000000e2 * t143 * t1842 - 0.11664000000000000000000000000000000000000000000000e2 * t647 * t1517 * t1163 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t1630 - 0.38880000000000000000000000000000000000000000000000e1 * t143 * t1828 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1683) + 0.11664000000000000000000000000000000000000000000000e2 * t1080 * t1831 - 0.34992000000000000000000000000000000000000000000000e2 * t520 * t228 * t1140 * t1147 - 0.11664000000000000000000000000000000000000000000000e2 * t520 * t241 * t1140 * t1163 + 0.23328000000000000000000000000000000000000000000000e2 * t524 * t1842
  d22 = t172 - 0.4726e1 * t1120 + 0.2e1 * t1125 + 0.2e1 * t1169 + 0.38880000000000000000000000000000000000000000000000e1 * t1217 + 0.11664000000000000000000000000000000000000000000000e2 * t1219 - 0.11664000000000000000000000000000000000000000000000e2 * t1221 - 0.38880000000000000000000000000000000000000000000000e1 * t1223 + t7 * (t1686 + t1869)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t12 = jnp.sqrt(t11)
  t15 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t12 + 0.31385250000000000000000000000000000000000000000000e-1 * t11
  t16 = t15 ** 2
  t17 = 0.1e1 / t16
  t19 = 0.1e1 / t12 * t1
  t20 = t3 * t6
  t22 = 0.1e1 / t8 / t7
  t23 = t20 * t22
  t24 = t19 * t23
  t26 = t6 * t22
  t27 = t4 * t26
  t29 = -0.74083333333333333333333333333333333333333333333333e-2 * t24 - 0.10461750000000000000000000000000000000000000000000e-1 * t27
  t30 = t17 * t29
  t32 = 0.1e1 / t15
  t34 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t32)
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t40 = t35 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t44 = s0 + 0.2e1 * s1 + s2
  t45 = t42 * t44
  t46 = t7 ** 2
  t47 = t8 ** 2
  t49 = 0.1e1 / t47 / t46
  t51 = t40 * t45 * t49
  t53 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t51
  t54 = t53 ** (0.1e1 / 0.4e1)
  t56 = 0.1e1 - 0.1e1 / t54
  t57 = t34 * t56
  t60 = t34 - 0.1e1
  t62 = 0.1e1 / t54 / t53
  t64 = t60 * t62 * t35
  t65 = t39 * t42
  t66 = t46 * t7
  t68 = 0.1e1 / t47 / t66
  t69 = t44 * t68
  t73 = -0.10000000000000000000000000000000000000000000000000e1 * t30 * t57 - 0.14225094736250905555555555555555555555555555555555e-1 * t64 * t65 * t69
  t75 = t60 * t56 + 0.1e1
  t76 = 0.1e1 / t75
  t79 = 0.285764e-1 * t30 + 0.285764e-1 * t73 * t76
  t80 = t41 - 0.1e1
  t81 = r0 - r1
  t82 = 0.1e1 / t7
  t83 = t81 * t82
  t84 = 0.1e1 + t83
  t85 = t84 <= f.p.zeta_threshold
  t86 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t87 = t86 * f.p.zeta_threshold
  t88 = t84 ** (0.1e1 / 0.3e1)
  t89 = t88 * t84
  t90 = f.my_piecewise3(t85, t87, t89)
  t91 = 0.1e1 - t83
  t92 = t91 <= f.p.zeta_threshold
  t93 = t91 ** (0.1e1 / 0.3e1)
  t94 = t93 * t91
  t95 = f.my_piecewise3(t92, t87, t94)
  t96 = t90 + t95 - 0.2e1
  t99 = 0.1e1 / t80 / 0.2e1
  t102 = 0.1e1 - 0.2363e1 * t80 * t96 * t99
  t103 = t79 * t102
  t104 = t81 ** 2
  t105 = t104 ** 2
  t106 = t105 ** 2
  t107 = t106 * t105
  t108 = t46 ** 2
  t109 = t108 ** 2
  t111 = 0.1e1 / t109 / t108
  t113 = -t107 * t111 + 0.1e1
  t114 = r0 ** (0.1e1 / 0.3e1)
  t115 = t114 ** 2
  t118 = tau0 / t115 / r0
  t119 = t84 / 0.2e1
  t120 = t119 ** (0.1e1 / 0.3e1)
  t121 = t120 ** 2
  t122 = t121 * t119
  t125 = r1 ** (0.1e1 / 0.3e1)
  t126 = t125 ** 2
  t129 = tau1 / t126 / r1
  t130 = t91 / 0.2e1
  t131 = t130 ** (0.1e1 / 0.3e1)
  t132 = t131 ** 2
  t133 = t132 * t130
  t138 = 0.2e1 * t118 * t122 + 0.2e1 * t129 * t133 - t44 * t49 / 0.4e1
  t139 = t138 ** 2
  t140 = t139 * t138
  t141 = t36 ** 2
  t142 = 0.1e1 / t141
  t143 = t140 * t142
  t148 = 0.8e-1 + 0.5e1 / 0.18e2 * t138 * t42 * t40 + 0.12500000000000000000000000000000000000000000000000e-1 * t51
  t149 = t148 ** 2
  t150 = t149 * t148
  t151 = 0.1e1 / t150
  t152 = t143 * t151
  t154 = t139 ** 2
  t156 = t141 ** 2
  t157 = 0.1e1 / t156
  t158 = t154 * t139 * t157
  t159 = t149 ** 2
  t161 = 0.1e1 / t159 / t149
  t164 = 0.1e1 + 0.64800000000000000000000000000000000000000000000000e0 * t152 + 0.41990400000000000000000000000000000000000000000000e0 * t158 * t161
  t165 = 0.1e1 / t164
  t166 = t151 * t165
  t169 = 0.1e1 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t166
  t170 = t113 * t169
  t172 = 0.2e1 * t103 * t170
  t174 = jnp.log(t75)
  t176 = -0.285764e-1 * t32 + 0.285764e-1 * t174
  t177 = t176 * t80
  t178 = 0.1e1 / t46
  t179 = t81 * t178
  t180 = t82 - t179
  t183 = f.my_piecewise3(t85, 0, 0.4e1 / 0.3e1 * t88 * t180)
  t184 = -t180
  t187 = f.my_piecewise3(t92, 0, 0.4e1 / 0.3e1 * t93 * t184)
  t188 = t183 + t187
  t189 = t177 * t188
  t190 = t99 * t113
  t191 = t190 * t169
  t192 = t189 * t191
  t194 = t176 * t102
  t195 = t104 * t81
  t196 = t106 * t195
  t197 = t196 * t111
  t198 = t108 * t7
  t200 = 0.1e1 / t109 / t198
  t201 = t107 * t200
  t203 = -0.12e2 * t197 + 0.12e2 * t201
  t204 = t203 * t169
  t205 = t194 * t204
  t207 = t139 * t142
  t208 = r0 ** 2
  t211 = tau0 / t115 / t208
  t214 = t180 / 0.2e1
  t215 = t121 * t214
  t218 = -t214
  t219 = t132 * t218
  t222 = 0.2e1 / 0.3e1 * t69
  t223 = -0.10e2 / 0.3e1 * t211 * t122 + 0.10e2 / 0.3e1 * t118 * t215 + 0.10e2 / 0.3e1 * t129 * t219 + t222
  t224 = t166 * t223
  t227 = 0.1e1 / t159
  t228 = t227 * t165
  t233 = t40 * t45 * t68
  t234 = 0.33333333333333333333333333333333333333333333333333e-1 * t233
  t235 = 0.5e1 / 0.18e2 * t223 * t42 * t40 - t234
  t236 = t228 * t235
  t239 = t164 ** 2
  t240 = 0.1e1 / t239
  t241 = t151 * t240
  t249 = t154 * t138 * t157
  t254 = 0.1e1 / t159 / t150
  t258 = 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t223 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t235 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t223 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t235
  t259 = t241 * t258
  t262 = -0.58320000000000000000000000000000000000000000000000e1 * t207 * t224 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t236 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t259
  t263 = t113 * t262
  t264 = t194 * t263
  t268 = t11 ** 0.15e1
  t270 = t1 ** 2
  t271 = t3 ** 2
  t272 = t270 * t271
  t275 = t272 * t5 / t47
  t277 = 0.37978500000000000000000000000000000000000000000000e1 * t12 + 0.89690000000000000000000000000000000000000000000000e0 * t11 + 0.20477500000000000000000000000000000000000000000000e0 * t268 + 0.12323500000000000000000000000000000000000000000000e0 * t275
  t280 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t277
  t281 = jnp.log(t280)
  t284 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t26 * t281
  t286 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t11
  t287 = t277 ** 2
  t288 = 0.1e1 / t287
  t289 = t286 * t288
  t292 = t11 ** 0.5e0
  t293 = t292 * t1
  t294 = t293 * t23
  t299 = t272 * t5 / t47 / t7
  t301 = -0.63297500000000000000000000000000000000000000000000e0 * t24 - 0.29896666666666666666666666666666666666666666666667e0 * t27 - 0.10238750000000000000000000000000000000000000000000e0 * t294 - 0.82156666666666666666666666666666666666666666666667e-1 * t299
  t302 = 0.1e1 / t280
  t303 = t301 * t302
  t305 = 0.10000000000000000000000000000000000000000000000000e1 * t289 * t303
  t306 = 0.1e1 / t108
  t307 = t195 * t306
  t308 = t96 * t99
  t310 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t11
  t315 = 0.70594500000000000000000000000000000000000000000000e1 * t12 + 0.15494250000000000000000000000000000000000000000000e1 * t11 + 0.42077500000000000000000000000000000000000000000000e0 * t268 + 0.15629250000000000000000000000000000000000000000000e0 * t275
  t318 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t315
  t319 = jnp.log(t318)
  t323 = 0.621814e-1 * t286 * t281
  t325 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t11
  t330 = 0.51785000000000000000000000000000000000000000000000e1 * t12 + 0.90577500000000000000000000000000000000000000000000e0 * t11 + 0.11003250000000000000000000000000000000000000000000e0 * t268 + 0.12417750000000000000000000000000000000000000000000e0 * t275
  t333 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t330
  t334 = jnp.log(t333)
  t335 = t325 * t334
  t337 = -0.3109070e-1 * t310 * t319 + t323 - 0.19751673498613801407483339618206552048944131217655e-1 * t335
  t338 = t308 * t337
  t340 = 0.4e1 * t307 * t338
  t341 = 0.1e1 / t198
  t342 = t105 * t341
  t344 = 0.4e1 * t342 * t338
  t345 = t105 * t306
  t346 = t188 * t99
  t347 = t346 * t337
  t348 = t345 * t347
  t352 = t315 ** 2
  t353 = 0.1e1 / t352
  t354 = t310 * t353
  t359 = -0.11765750000000000000000000000000000000000000000000e1 * t24 - 0.51647500000000000000000000000000000000000000000000e0 * t27 - 0.21038750000000000000000000000000000000000000000000e0 * t294 - 0.10419500000000000000000000000000000000000000000000e0 * t299
  t360 = 0.1e1 / t318
  t361 = t359 * t360
  t367 = t330 ** 2
  t368 = 0.1e1 / t367
  t369 = t325 * t368
  t374 = -0.86308333333333333333333333333333333333333333333334e0 * t24 - 0.30192500000000000000000000000000000000000000000000e0 * t27 - 0.55016250000000000000000000000000000000000000000000e-1 * t294 - 0.82785000000000000000000000000000000000000000000000e-1 * t299
  t375 = 0.1e1 / t333
  t376 = t374 * t375
  t379 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t26 * t319 + 0.10000000000000000000000000000000000000000000000000e1 * t354 * t361 - t284 - t305 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t26 * t334 + 0.58482236226346462072622386637590534819724553404280e0 * t369 * t376
  t380 = t308 * t379
  t381 = t345 * t380
  t383 = 0.19751673498613801407483339618206552048944131217655e-1 * t346 * t335
  t384 = t308 * t1
  t386 = t20 * t22 * t334
  t388 = 0.18311447306006545054854346104378990962041954983034e-3 * t384 * t386
  t389 = t308 * t325
  t391 = t368 * t374 * t375
  t393 = 0.58482236226346462072622386637590534819724553404280e0 * t389 * t391
  t394 = t86 ** 2
  t395 = t88 ** 2
  t396 = f.my_piecewise3(t85, t394, t395)
  t397 = t93 ** 2
  t398 = f.my_piecewise3(t92, t394, t397)
  t400 = t396 / 0.2e1 + t398 / 0.2e1
  t401 = t400 ** 2
  t402 = t345 * t338
  t404 = 0.19751673498613801407483339618206552048944131217655e-1 * t308 * t335
  t405 = -t323 + t402 + t404
  t406 = t401 * t400
  t407 = 0.1e1 / t406
  t410 = jnp.exp(-0.32163648644302209642661863561802450870026695828375e2 * t405 * t407)
  t411 = t410 - 0.1e1
  t412 = jnp.log(0.2e1)
  t414 = 0.1e1 / (0.1e1 - t412)
  t415 = t414 * t36
  t416 = t405 * t414
  t417 = t36 * t407
  t419 = jnp.exp(-t416 * t417)
  t420 = t419 - 0.1e1
  t421 = 0.1e1 / t420
  t422 = t421 * t44
  t424 = 0.1e1 / t8 / t46
  t426 = t415 * t422 * t424
  t427 = 0.1e1 / t401
  t429 = 0.1e1 / t3
  t432 = t41 * t427 * t270 * t429 * t5
  t435 = 0.1e1 + 0.27802083333333333333333333333333333333333333333333e-2 * t426 * t432
  t436 = t435 ** (0.1e1 / 0.4e1)
  t438 = 0.1e1 - 0.1e1 / t436
  t440 = t411 * t438 + 0.1e1
  t441 = jnp.log(t440)
  t442 = t401 * t441
  t443 = 0.1e1 / t88
  t446 = f.my_piecewise3(t85, 0, 0.2e1 / 0.3e1 * t443 * t180)
  t447 = 0.1e1 / t93
  t450 = f.my_piecewise3(t92, 0, 0.2e1 / 0.3e1 * t447 * t184)
  t452 = t446 / 0.2e1 + t450 / 0.2e1
  t455 = t284 + t305 + t340 - t344 + t348 + t381 + t383 - t388 - t393
  t458 = t401 ** 2
  t459 = 0.1e1 / t458
  t460 = t405 * t459
  t463 = -0.32163648644302209642661863561802450870026695828375e2 * t455 * t407 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t452
  t464 = t463 * t410
  t467 = 0.1e1 / t436 / t435
  t468 = t411 * t467
  t469 = t420 ** 2
  t471 = t415 / t469
  t473 = t44 * t424 * t41
  t474 = t471 * t473
  t476 = t427 * t270 * t429
  t477 = t455 * t414
  t479 = t36 * t459
  t480 = t479 * t452
  t483 = 0.3e1 * t416 * t480 - t477 * t417
  t484 = t5 * t483
  t486 = t476 * t484 * t419
  t490 = 0.1e1 / t8 / t66
  t492 = t415 * t422 * t490
  t494 = 0.64871527777777777777777777777777777777777777777777e-2 * t492 * t432
  t496 = t41 * t407 * t270
  t497 = t429 * t5
  t499 = t496 * t497 * t452
  t502 = -0.27802083333333333333333333333333333333333333333333e-2 * t474 * t486 - t494 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t499
  t505 = t464 * t438 + t468 * t502 / 0.4e1
  t507 = 0.1e1 / t440
  t510 = t284 + t305 + t340 - t344 + t348 + t381 + t383 - t388 - t393 + 0.93273e-1 * t442 * t452 + 0.31091e-1 * t406 * t505 * t507
  t511 = t510 * t140
  t513 = t142 * t151 * t165
  t514 = t511 * t513
  t518 = -t323 + t402 + t404 + 0.31091e-1 * t406 * t441
  t520 = t518 * t139 * t142
  t521 = t520 * t224
  t524 = t518 * t140 * t142
  t525 = t524 * t236
  t527 = t524 * t259
  t529 = t138 * t142
  t530 = t223 ** 2
  t546 = 0.1e1 / t120
  t547 = t214 ** 2
  t551 = 0.1e1 / t66
  t552 = t81 * t551
  t553 = -t178 + t552
  t557 = 0.1e1 / t131
  t558 = t218 ** 2
  t567 = 0.1e1 / t47 / t108
  t568 = t44 * t567
  t569 = 0.22e2 / 0.9e1 * t568
  t570 = 0.80e2 / 0.9e1 * tau0 / t115 / t208 / r0 * t122 - 0.100e3 / 0.9e1 * t211 * t215 + 0.20e2 / 0.9e1 * t118 * t546 * t547 + 0.10e2 / 0.3e1 * t118 * t121 * t553 + 0.20e2 / 0.9e1 * t129 * t557 * t558 - 0.10e2 / 0.3e1 * t129 * t132 * t553 - t569
  t575 = 0.1e1 / t159 / t148
  t576 = t235 ** 2
  t585 = 0.12222222222222222222222222222222222222222222222222e0 * t40 * t45 * t567
  t586 = 0.5e1 / 0.18e2 * t570 * t42 * t40 + t585
  t590 = t154 * t157
  t601 = t159 ** 2
  t602 = 0.1e1 / t601
  t610 = t241 * (0.38880000000000000000000000000000000000000000000000e1 * t529 * t151 * t530 - 0.11664000000000000000000000000000000000000000000000e2 * t207 * t227 * t223 * t235 + 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t570 + 0.77760000000000000000000000000000000000000000000000e1 * t143 * t575 * t576 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t586 + 0.12597120000000000000000000000000000000000000000000e2 * t590 * t161 * t530 - 0.30233088000000000000000000000000000000000000000000e2 * t249 * t254 * t223 * t235 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t570 + 0.17635968000000000000000000000000000000000000000000e2 * t158 * t602 * t576 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t586)
  t613 = t228 * t586
  t616 = t166 * t570
  t619 = t511 * t142
  t623 = t510 * t139 * t142
  t628 = t166 * t530
  t631 = t207 * t227
  t636 = t207 * t151
  t643 = t575 * t165
  t644 = t643 * t576
  t647 = t143 * t227
  t655 = 0.1e1 / t239 / t164
  t656 = t151 * t655
  t657 = t258 ** 2
  t658 = t656 * t657
  t666 = 0.1e1 / t395
  t667 = t180 ** 2
  t670 = 0.2e1 * t553
  t674 = f.my_piecewise3(t85, 0, 0.4e1 / 0.9e1 * t666 * t667 + 0.4e1 / 0.3e1 * t88 * t670)
  t675 = 0.1e1 / t397
  t676 = t184 ** 2
  t679 = -t670
  t683 = f.my_piecewise3(t92, 0, 0.4e1 / 0.9e1 * t675 * t676 + 0.4e1 / 0.3e1 * t93 * t679)
  t684 = t674 + t683
  t689 = t99 * t203 * t169
  t692 = t190 * t262
  t695 = t401 * t505
  t696 = t507 * t452
  t703 = t271 * t5 * t49
  t704 = 0.1e1 / t12 / t11 * t270 * t703
  t706 = t20 * t424
  t707 = t19 * t706
  t709 = t6 * t424
  t710 = t4 * t709
  t712 = t11 ** (-0.5e0)
  t714 = t712 * t270 * t703
  t716 = t293 * t706
  t719 = t272 * t5 * t49
  t721 = -0.57538888888888888888888888888888888888888888888889e0 * t704 + 0.11507777777777777777777777777777777777777777777778e1 * t707 + 0.40256666666666666666666666666666666666666666666667e0 * t710 + 0.36677500000000000000000000000000000000000000000000e-1 * t714 + 0.73355000000000000000000000000000000000000000000000e-1 * t716 + 0.13797500000000000000000000000000000000000000000000e0 * t719
  t725 = 0.58482236226346462072622386637590534819724553404280e0 * t389 * t368 * t721 * t375
  t726 = t367 ** 2
  t727 = 0.1e1 / t726
  t728 = t374 ** 2
  t730 = t333 ** 2
  t731 = 0.1e1 / t730
  t734 = 0.17315859105681463759666483083807725165579399831905e2 * t389 * t727 * t728 * t731
  t736 = t346 * t325 * t391
  t737 = 0.11696447245269292414524477327518106963944910680856e1 * t736
  t739 = 0.1e1 / t367 / t330
  t743 = 0.11696447245269292414524477327518106963944910680856e1 * t389 * t739 * t728 * t375
  t753 = 0.10000000000000000000000000000000000000000000000000e1 * t289 * (-0.42198333333333333333333333333333333333333333333333e0 * t704 + 0.84396666666666666666666666666666666666666666666666e0 * t707 + 0.39862222222222222222222222222222222222222222222223e0 * t710 + 0.68258333333333333333333333333333333333333333333333e-1 * t714 + 0.13651666666666666666666666666666666666666666666667e0 * t716 + 0.13692777777777777777777777777777777777777777777778e0 * t719) * t302
  t754 = t287 ** 2
  t757 = t301 ** 2
  t758 = t280 ** 2
  t762 = 0.16081979498692535066756296899072713062105388428051e2 * t286 / t754 * t757 / t758
  t768 = 0.20000000000000000000000000000000000000000000000000e1 * t286 / t287 / t277 * t757 * t302
  t769 = t684 * t99
  t771 = 0.19751673498613801407483339618206552048944131217655e-1 * t769 * t335
  t772 = t108 * t46
  t776 = 0.20e2 * t105 / t772 * t338
  t779 = 0.12e2 * t104 * t306 * t338
  t782 = 0.32e2 * t195 * t341 * t338
  t785 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t709 * t281
  t789 = t4 * t6
  t797 = t359 ** 2
  t811 = t352 ** 2
  t814 = t318 ** 2
  t822 = 0.35616666666666666666666666666666666666666666666666e-1 * t789 * t22 * t288 * t303
  t841 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t709 * t319 - 0.34246666666666666666666666666666666666666666666666e-1 * t789 * t22 * t353 * t361 - 0.20000000000000000000000000000000000000000000000000e1 * t310 / t352 / t315 * t797 * t360 + 0.10000000000000000000000000000000000000000000000000e1 * t354 * (-0.78438333333333333333333333333333333333333333333333e0 * t704 + 0.15687666666666666666666666666666666666666666666667e1 * t707 + 0.68863333333333333333333333333333333333333333333333e0 * t710 + 0.14025833333333333333333333333333333333333333333333e0 * t714 + 0.28051666666666666666666666666666666666666666666667e0 * t716 + 0.17365833333333333333333333333333333333333333333333e0 * t719) * t360 + 0.32163958997385070133512593798145426124210776856102e2 * t310 / t811 * t797 / t814 + t785 + t822 + t768 - t753 - t762 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t709 * t334 - 0.10843581300301739842632067522386578331157260943710e-1 * t789 * t22 * t368 * t376 - 0.11696447245269292414524477327518106963944910680856e1 * t325 * t739 * t728 * t375 + 0.58482236226346462072622386637590534819724553404280e0 * t369 * t721 * t375 + 0.17315859105681463759666483083807725165579399831905e2 * t325 * t727 * t728 * t731
  t843 = t345 * t308 * t841
  t844 = t771 + t762 + t753 - t725 - t734 - t737 + t776 + t779 - t782 - t785 + t843
  t846 = t345 * t769 * t337
  t848 = t345 * t346 * t379
  t849 = 0.2e1 * t848
  t850 = t342 * t347
  t851 = 0.8e1 * t850
  t853 = 0.8e1 * t342 * t380
  t854 = t307 * t347
  t855 = 0.8e1 * t854
  t857 = 0.8e1 * t307 * t380
  t859 = t346 * t1 * t386
  t860 = 0.36622894612013090109708692208757981924083909966068e-3 * t859
  t864 = 0.10843581300301739842632067522386578331157260943710e-1 * t308 * t4 * t26 * t391
  t868 = 0.24415263074675393406472461472505321282722606644045e-3 * t384 * t20 * t424 * t334
  t869 = t846 + t849 - t851 - t853 + t855 + t857 - t768 - t860 + t743 - t822 + t864 + t868
  t870 = t844 + t869
  t873 = t455 * t459
  t877 = 0.1e1 / t458 / t400
  t878 = t405 * t877
  t879 = t452 ** 2
  t882 = 0.1e1 / t89
  t888 = f.my_piecewise3(t85, 0, -0.2e1 / 0.9e1 * t882 * t667 + 0.2e1 / 0.3e1 * t443 * t670)
  t889 = 0.1e1 / t94
  t895 = f.my_piecewise3(t92, 0, -0.2e1 / 0.9e1 * t889 * t676 + 0.2e1 / 0.3e1 * t447 * t679)
  t897 = t888 / 0.2e1 + t895 / 0.2e1
  t903 = t463 ** 2
  t906 = t467 * t502
  t909 = t435 ** 2
  t912 = t411 / t436 / t909
  t913 = t502 ** 2
  t919 = t415 / t469 / t420 * t473
  t920 = t483 ** 2
  t921 = t5 * t920
  t922 = t419 ** 2
  t929 = t471 * t44 * t490 * t41
  t930 = t929 * t486
  t933 = t407 * t270 * t429
  t934 = t419 * t452
  t943 = t36 * t877
  t965 = 0.21623842592592592592592592592592592592592592592592e-1 * t415 * t422 / t8 / t108 * t432
  t966 = t492 * t499
  t969 = t41 * t459 * t270
  t985 = t505 ** 2
  t987 = t440 ** 2
  t988 = 0.1e1 / t987
  t991 = t400 * t441
  t996 = 0.186546e0 * t695 * t696 - t725 - t734 - t737 + t743 + t753 + t762 - t768 + 0.31091e-1 * t406 * ((-0.32163648644302209642661863561802450870026695828375e2 * t870 * t407 + 0.19298189186581325785597118137081470522016017497025e3 * t873 * t452 - 0.38596378373162651571194236274162941044032034994050e3 * t878 * t879 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t897) * t410 * t438 + t903 * t410 * t438 + t464 * t906 / 0.2e1 - 0.5e1 / 0.16e2 * t912 * t913 + t468 * (0.55604166666666666666666666666666666666666666666666e-2 * t919 * t476 * t921 * t922 + 0.12974305555555555555555555555555555555555555555555e-1 * t930 + 0.11120833333333333333333333333333333333333333333333e-1 * t474 * t933 * t484 * t934 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t5 * (-t870 * t414 * t417 + 0.3e1 * t416 * t479 * t897 - 0.12e2 * t416 * t943 * t879 + 0.6e1 * t477 * t480) * t419 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t921 * t419 + t965 + 0.25948611111111111111111111111111111111111111111110e-1 * t966 + 0.16681250000000000000000000000000000000000000000000e-1 * t426 * t969 * t497 * t879 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t496 * t497 * t897) / 0.4e1) * t507 - 0.31091e-1 * t406 * t985 * t988 + 0.186546e0 * t991 * t879 + 0.93273e-1 * t442 * t897 - t853 + t855
  t997 = t864 + t771 + t846 - t785 + t857 + t776 + t779 - t782 + t843 + t868 - t822 - t860 + t849 - t851
  t1002 = -0.19440000000000000000000000000000000000000000000000e1 * t524 * t610 - 0.58320000000000000000000000000000000000000000000000e1 * t524 * t613 + 0.58320000000000000000000000000000000000000000000000e1 * t520 * t616 - 0.38880000000000000000000000000000000000000000000000e1 * t619 * t259 + 0.11664000000000000000000000000000000000000000000000e2 * t623 * t224 - 0.11664000000000000000000000000000000000000000000000e2 * t619 * t236 + t194 * t113 * (-0.11664000000000000000000000000000000000000000000000e2 * t529 * t628 + 0.34992000000000000000000000000000000000000000000000e2 * t631 * t165 * t223 * t235 + 0.11664000000000000000000000000000000000000000000000e2 * t636 * t240 * t223 * t258 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t616 - 0.23328000000000000000000000000000000000000000000000e2 * t143 * t644 - 0.11664000000000000000000000000000000000000000000000e2 * t647 * t240 * t235 * t258 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t613 - 0.38880000000000000000000000000000000000000000000000e1 * t143 * t658 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t610) - 0.2363e1 * t177 * t684 * t191 - 0.4726e1 * t189 * t689 - 0.4726e1 * t189 * t692 + 0.19440000000000000000000000000000000000000000000000e1 * (t996 + t997) * t140 * t513
  t1005 = 0.132e3 * t106 * t104 * t111
  t1007 = 0.288e3 * t196 * t200
  t1011 = 0.156e3 * t107 / t109 / t772
  t1018 = t103 * t204
  t1020 = t103 * t263
  t1024 = t29 ** 2
  t1025 = 0.1e1 / t16 / t15 * t1024
  t1031 = t17 * (-0.49388888888888888888888888888888888888888888888889e-2 * t704 + 0.98777777777777777777777777777777777777777777777777e-2 * t707 + 0.13949000000000000000000000000000000000000000000000e-1 * t710)
  t1037 = t16 ** 2
  t1046 = t53 ** 2
  t1050 = t35 ** 2
  t1055 = t44 ** 2
  t1069 = t73 ** 2
  t1070 = t75 ** 2
  t1076 = (-0.571528e-1 * t1025 + 0.285764e-1 * t1031 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t1025 * t57 - 0.10000000000000000000000000000000000000000000000000e1 * t1031 * t57 + 0.10000000000000000000000000000000000000000000000000e1 / t1037 * t1024 * t57 + 0.28450189472501811111111111111111111111111111111110e-1 * t30 * t34 * t62 * t233 - 0.20235332025531322029119593137558641975308641975307e-2 * t60 / t54 / t1046 * t1050 / t37 / t36 * t41 * t1055 / t8 / t108 / t66 + 0.52158680699586653703703703703703703703703703703702e-1 * t64 * t65 * t568) * t76 - 0.285764e-1 * t1069 / t1070) * t102 * t170
  t1080 = t518 * t138 * t142
  t1093 = t227 * t240
  t1098 = t79 * t80
  t1100 = t1098 * t188 * t191
  t1102 = t194 * (-t1005 + t1007 - t1011) * t169 + 0.2e1 * t194 * t203 * t262 + 0.2e1 * t1018 + 0.2e1 * t1020 + t1076 + 0.38880000000000000000000000000000000000000000000000e1 * t524 * t658 + 0.11664000000000000000000000000000000000000000000000e2 * t1080 * t628 - 0.34992000000000000000000000000000000000000000000000e2 * t520 * t228 * t223 * t235 - 0.11664000000000000000000000000000000000000000000000e2 * t520 * t241 * t223 * t258 + 0.23328000000000000000000000000000000000000000000000e2 * t524 * t644 + 0.11664000000000000000000000000000000000000000000000e2 * t524 * t1093 * t235 * t258 - 0.4726e1 * t1100
  d11 = t172 - 0.4726e1 * t192 + 0.2e1 * t205 + 0.2e1 * t264 + 0.38880000000000000000000000000000000000000000000000e1 * t514 + 0.11664000000000000000000000000000000000000000000000e2 * t521 - 0.11664000000000000000000000000000000000000000000000e2 * t525 - 0.38880000000000000000000000000000000000000000000000e1 * t527 + t7 * (t1002 + t1102)
  t1110 = -t82 - t179
  t1113 = f.my_piecewise3(t85, 0, 0.4e1 / 0.3e1 * t88 * t1110)
  t1114 = -t1110
  t1117 = f.my_piecewise3(t92, 0, 0.4e1 / 0.3e1 * t93 * t1114)
  t1118 = t1113 + t1117
  t1119 = t177 * t1118
  t1120 = t1119 * t191
  t1123 = 0.12e2 * t197 + 0.12e2 * t201
  t1124 = t1123 * t169
  t1125 = t194 * t1124
  t1126 = t1110 / 0.2e1
  t1127 = t121 * t1126
  t1130 = r1 ** 2
  t1133 = tau1 / t126 / t1130
  t1136 = -t1126
  t1137 = t132 * t1136
  t1140 = 0.10e2 / 0.3e1 * t118 * t1127 - 0.10e2 / 0.3e1 * t1133 * t133 + 0.10e2 / 0.3e1 * t129 * t1137 + t222
  t1141 = t166 * t1140
  t1147 = 0.5e1 / 0.18e2 * t1140 * t42 * t40 - t234
  t1148 = t228 * t1147
  t1151 = t151 * t1140
  t1154 = t227 * t1147
  t1157 = t161 * t1140
  t1160 = t254 * t1147
  t1163 = 0.19440000000000000000000000000000000000000000000000e1 * t207 * t1151 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1154 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t1157 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t1160
  t1164 = t241 * t1163
  t1167 = -0.58320000000000000000000000000000000000000000000000e1 * t207 * t1141 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t1148 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1164
  t1168 = t113 * t1167
  t1169 = t194 * t1168
  t1170 = t1118 * t99
  t1171 = t1170 * t337
  t1172 = t345 * t1171
  t1174 = 0.19751673498613801407483339618206552048944131217655e-1 * t1170 * t335
  t1177 = f.my_piecewise3(t85, 0, 0.2e1 / 0.3e1 * t443 * t1110)
  t1180 = f.my_piecewise3(t92, 0, 0.2e1 / 0.3e1 * t447 * t1114)
  t1182 = t1177 / 0.2e1 + t1180 / 0.2e1
  t1185 = t284 + t305 - t340 - t344 + t1172 + t381 + t1174 - t388 - t393
  t1190 = -0.32163648644302209642661863561802450870026695828375e2 * t1185 * t407 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t1182
  t1191 = t1190 * t410
  t1193 = t1185 * t414
  t1195 = t479 * t1182
  t1198 = -t1193 * t417 + 0.3e1 * t416 * t1195
  t1199 = t5 * t1198
  t1201 = t476 * t1199 * t419
  t1205 = t496 * t497 * t1182
  t1208 = -0.27802083333333333333333333333333333333333333333333e-2 * t474 * t1201 - t494 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t1205
  t1211 = t1191 * t438 + t468 * t1208 / 0.4e1
  t1212 = t406 * t1211
  t1215 = t284 + t305 - t340 - t344 + t1172 + t381 + t1174 - t388 - t393 + 0.93273e-1 * t442 * t1182 + 0.31091e-1 * t1212 * t507
  t1216 = t1215 * t140
  t1217 = t1216 * t513
  t1219 = t520 * t1141
  t1221 = t524 * t1148
  t1223 = t524 * t1164
  t1228 = t227 * t1140
  t1252 = -0.50e2 / 0.9e1 * t211 * t1127 + 0.20e2 / 0.9e1 * t118 * t546 * t1126 * t214 + 0.10e2 / 0.3e1 * t118 * t121 * t81 * t551 - 0.50e2 / 0.9e1 * t1133 * t219 + 0.20e2 / 0.9e1 * t129 * t557 * t1136 * t218 - 0.10e2 / 0.3e1 * t129 * t132 * t81 * t551 - t569
  t1266 = 0.5e1 / 0.18e2 * t1252 * t42 * t40 + t585
  t1273 = t254 * t1140
  t1290 = 0.38880000000000000000000000000000000000000000000000e1 * t529 * t1151 * t223 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1228 * t235 + 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t1252 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1154 * t223 + 0.77760000000000000000000000000000000000000000000000e1 * t143 * t575 * t1147 * t235 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t1266 + 0.12597120000000000000000000000000000000000000000000e2 * t590 * t1157 * t223 - 0.15116544000000000000000000000000000000000000000000e2 * t249 * t1273 * t235 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t1252 - 0.15116544000000000000000000000000000000000000000000e2 * t249 * t1160 * t223 + 0.17635968000000000000000000000000000000000000000000e2 * t158 * t602 * t1147 * t235 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t1266
  t1291 = t241 * t1290
  t1296 = 0.58482236226346462072622386637590534819724553404280e0 * t736
  t1297 = t507 * t1182
  t1300 = 0.4e1 * t854
  t1311 = f.my_piecewise3(t85, 0, 0.4e1 / 0.9e1 * t666 * t1110 * t180 + 0.8e1 / 0.3e1 * t88 * t81 * t551)
  t1319 = f.my_piecewise3(t92, 0, 0.4e1 / 0.9e1 * t675 * t1114 * t184 - 0.8e1 / 0.3e1 * t93 * t81 * t551)
  t1320 = t1311 + t1319
  t1321 = t1320 * t99
  t1323 = 0.19751673498613801407483339618206552048944131217655e-1 * t1321 * t335
  t1324 = t1182 * t452
  t1328 = t1170 * t1 * t386
  t1329 = 0.18311447306006545054854346104378990962041954983034e-3 * t1328
  t1330 = -t725 - t734 - t1296 + t743 + 0.93273e-1 * t695 * t1297 + t753 + t762 - t768 - t853 - t1300 + t864 - 0.31091e-1 * t1212 * t988 * t505 + t1323 + 0.186546e0 * t991 * t1324 - t1329 - t785
  t1332 = t345 * t1321 * t337
  t1334 = t345 * t1170 * t379
  t1335 = t307 * t1171
  t1336 = 0.4e1 * t1335
  t1337 = t342 * t1171
  t1338 = 0.4e1 * t1337
  t1339 = 0.18311447306006545054854346104378990962041954983034e-3 * t859
  t1340 = t401 * t1211
  t1343 = 0.4e1 * t850
  t1345 = t1170 * t325 * t391
  t1346 = 0.58482236226346462072622386637590534819724553404280e0 * t1345
  t1354 = f.my_piecewise3(t85, 0, -0.2e1 / 0.9e1 * t882 * t1110 * t180 + 0.4e1 / 0.3e1 * t443 * t81 * t551)
  t1362 = f.my_piecewise3(t92, 0, -0.2e1 / 0.9e1 * t889 * t1114 * t184 - 0.4e1 / 0.3e1 * t447 * t81 * t551)
  t1364 = t1354 / 0.2e1 + t1362 / 0.2e1
  t1367 = -t725 - t734 - t1296 + t743 + t753 + t762 - t768 - t853 - t1300 + t864 + t1323 - t1329 - t785
  t1368 = t776 - t779 + t843 + t1332 + t1334 + t1336 - t1338 + t868 - t822 - t1339 + t848 - t1343 - t1346
  t1369 = t1367 + t1368
  t1372 = t1185 * t459
  t1389 = t467 * t1208
  t1400 = t929 * t1201
  t1426 = t483 * t419
  t1433 = t5 * t1182
  t1438 = t492 * t1205
  t1452 = 0.55604166666666666666666666666666666666666666666666e-2 * t919 * t476 * t1199 * t922 * t483 + 0.64871527777777777777777777777777777777777777777777e-2 * t1400 + 0.55604166666666666666666666666666666666666666666666e-2 * t474 * t933 * t1199 * t934 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t5 * (-0.12e2 * t416 * t36 * t877 * t1182 * t452 + 0.3e1 * t416 * t479 * t1364 - t1369 * t414 * t417 + 0.3e1 * t1193 * t480 + 0.3e1 * t477 * t1195) * t419 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t1199 * t1426 + 0.64871527777777777777777777777777777777777777777777e-2 * t930 + t965 + 0.12974305555555555555555555555555555555555555555555e-1 * t966 + 0.55604166666666666666666666666666666666666666666666e-2 * t474 * t933 * t1433 * t1426 + 0.12974305555555555555555555555555555555555555555555e-1 * t1438 + 0.16681250000000000000000000000000000000000000000000e-1 * t415 * t421 * t473 * t459 * t270 * t429 * t1433 * t452 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t496 * t497 * t1364
  t1459 = t776 - t779 + t843 + t1332 + t1334 + t1336 - t1338 + t868 - t822 - t1339 + 0.93273e-1 * t1340 * t696 + t848 - t1343 - t1346 + 0.93273e-1 * t442 * t1364 + 0.31091e-1 * t406 * ((-0.32163648644302209642661863561802450870026695828375e2 * t1369 * t407 + 0.96490945932906628927985590685407352610080087485125e2 * t1372 * t452 + 0.96490945932906628927985590685407352610080087485125e2 * t873 * t1182 - 0.38596378373162651571194236274162941044032034994050e3 * t878 * t1324 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t1364) * t410 * t438 + t1190 * t463 * t410 * t438 + t1191 * t906 / 0.4e1 + t464 * t1389 / 0.4e1 - 0.5e1 / 0.16e2 * t912 * t1208 * t502 + t468 * t1452 / 0.4e1) * t507
  t1466 = t103 * t1124
  t1506 = -0.19440000000000000000000000000000000000000000000000e1 * t524 * t1291 - 0.2363e1 * t1119 * t692 + 0.19440000000000000000000000000000000000000000000000e1 * (t1330 + t1459) * t140 * t513 + t194 * t1123 * t262 + t1466 + t194 * (t1005 - t1011) * t169 + 0.58320000000000000000000000000000000000000000000000e1 * t524 * t1093 * t1147 * t258 - 0.58320000000000000000000000000000000000000000000000e1 * t520 * t241 * t1163 * t223 + 0.58320000000000000000000000000000000000000000000000e1 * t524 * t1093 * t1163 * t235 + 0.38880000000000000000000000000000000000000000000000e1 * t524 * t656 * t1163 * t258 + 0.11664000000000000000000000000000000000000000000000e2 * t1080 * t166 * t1140 * t223 - 0.17496000000000000000000000000000000000000000000000e2 * t520 * t228 * t1140 * t235 - 0.58320000000000000000000000000000000000000000000000e1 * t520 * t241 * t1140 * t258 - 0.17496000000000000000000000000000000000000000000000e2 * t520 * t228 * t1147 * t223 + 0.23328000000000000000000000000000000000000000000000e2 * t524 * t643 * t1147 * t235 + t1020 + t1076
  t1508 = t165 * t1140
  t1515 = t240 * t1140
  t1519 = t166 * t1252
  t1522 = t165 * t1147
  t1530 = t240 * t1147
  t1534 = t228 * t1266
  t1537 = t240 * t1163
  t1550 = -0.11664000000000000000000000000000000000000000000000e2 * t529 * t151 * t1508 * t223 + 0.17496000000000000000000000000000000000000000000000e2 * t631 * t1508 * t235 + 0.58320000000000000000000000000000000000000000000000e1 * t636 * t1515 * t258 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1519 + 0.17496000000000000000000000000000000000000000000000e2 * t631 * t1522 * t223 - 0.23328000000000000000000000000000000000000000000000e2 * t143 * t575 * t1522 * t235 - 0.58320000000000000000000000000000000000000000000000e1 * t647 * t1530 * t258 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t1534 + 0.58320000000000000000000000000000000000000000000000e1 * t636 * t1537 * t223 - 0.58320000000000000000000000000000000000000000000000e1 * t647 * t1537 * t235 - 0.38880000000000000000000000000000000000000000000000e1 * t152 * t655 * t1163 * t258 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1291
  t1559 = t1216 * t142
  t1566 = t103 * t1168
  t1569 = t1215 * t139 * t142
  t1576 = t190 * t1167
  t1580 = t99 * t1123 * t169
  t1584 = t1098 * t1118 * t191
  t1591 = t194 * t113 * t1550 + t1018 + 0.58320000000000000000000000000000000000000000000000e1 * t623 * t1141 - 0.58320000000000000000000000000000000000000000000000e1 * t619 * t1148 + 0.58320000000000000000000000000000000000000000000000e1 * t520 * t1519 - 0.19440000000000000000000000000000000000000000000000e1 * t1559 * t259 - 0.58320000000000000000000000000000000000000000000000e1 * t1559 * t236 + t194 * t203 * t1167 + t1566 - 0.2363e1 * t1100 + 0.58320000000000000000000000000000000000000000000000e1 * t1569 * t224 - 0.19440000000000000000000000000000000000000000000000e1 * t619 * t1164 - 0.58320000000000000000000000000000000000000000000000e1 * t524 * t1534 - 0.2363e1 * t189 * t1576 - 0.2363e1 * t189 * t1580 - 0.2363e1 * t1584 - 0.2363e1 * t177 * t1320 * t191 - 0.2363e1 * t1119 * t689
  d12 = t172 - 0.2363e1 * t192 + t205 + t264 + 0.19440000000000000000000000000000000000000000000000e1 * t514 + 0.58320000000000000000000000000000000000000000000000e1 * t521 - 0.58320000000000000000000000000000000000000000000000e1 * t525 - 0.19440000000000000000000000000000000000000000000000e1 * t527 - 0.2363e1 * t1120 + t1125 + t1169 + 0.19440000000000000000000000000000000000000000000000e1 * t1217 + 0.58320000000000000000000000000000000000000000000000e1 * t1219 - 0.58320000000000000000000000000000000000000000000000e1 * t1221 - 0.19440000000000000000000000000000000000000000000000e1 * t1223 + t7 * (t1506 + t1591)
  t1605 = t1110 ** 2
  t1608 = t178 + t552
  t1609 = 0.2e1 * t1608
  t1613 = f.my_piecewise3(t85, 0, 0.4e1 / 0.9e1 * t666 * t1605 + 0.4e1 / 0.3e1 * t88 * t1609)
  t1614 = t1114 ** 2
  t1617 = -t1609
  t1621 = f.my_piecewise3(t92, 0, 0.4e1 / 0.9e1 * t675 * t1614 + 0.4e1 / 0.3e1 * t93 * t1617)
  t1622 = t1613 + t1621
  t1635 = t1163 ** 2
  t1636 = t656 * t1635
  t1646 = -0.11664000000000000000000000000000000000000000000000e2 * t1559 * t1148 - 0.38880000000000000000000000000000000000000000000000e1 * t1559 * t1164 - 0.2363e1 * t177 * t1622 * t191 - 0.4726e1 * t1119 * t1580 - 0.4726e1 * t1119 * t1576 - 0.4726e1 * t1584 + 0.11664000000000000000000000000000000000000000000000e2 * t524 * t1093 * t1147 * t1163 + 0.38880000000000000000000000000000000000000000000000e1 * t524 * t1636 + t194 * (-t1005 - t1007 - t1011) * t169 + 0.2e1 * t194 * t1123 * t1167 + 0.2e1 * t1466
  t1648 = t1622 * t99
  t1650 = t345 * t1648 * t337
  t1651 = 0.2e1 * t1334
  t1652 = 0.8e1 * t1337
  t1653 = 0.8e1 * t1335
  t1654 = t843 + t864 + t776 + t1650 + t1651 + t779 - t1652 - t853 - t1653 - t857 - t768
  t1655 = 0.11696447245269292414524477327518106963944910680856e1 * t1345
  t1657 = 0.19751673498613801407483339618206552048944131217655e-1 * t1648 * t335
  t1658 = 0.36622894612013090109708692208757981924083909966068e-3 * t1328
  t1659 = t762 + t753 + t782 - t1655 - t725 + t1657 - t785 + t743 - t1658 - t822 - t734 + t868
  t1660 = t1654 + t1659
  t1665 = t1182 ** 2
  t1673 = f.my_piecewise3(t85, 0, -0.2e1 / 0.9e1 * t882 * t1605 + 0.2e1 / 0.3e1 * t443 * t1609)
  t1679 = f.my_piecewise3(t92, 0, -0.2e1 / 0.9e1 * t889 * t1614 + 0.2e1 / 0.3e1 * t447 * t1617)
  t1681 = t1673 / 0.2e1 + t1679 / 0.2e1
  t1687 = t1190 ** 2
  t1692 = t1208 ** 2
  t1695 = t1198 ** 2
  t1696 = t5 * t1695
  t1743 = t1211 ** 2
  t1753 = 0.31091e-1 * t406 * ((-0.32163648644302209642661863561802450870026695828375e2 * t1660 * t407 + 0.19298189186581325785597118137081470522016017497025e3 * t1372 * t1182 - 0.38596378373162651571194236274162941044032034994050e3 * t878 * t1665 + 0.96490945932906628927985590685407352610080087485125e2 * t460 * t1681) * t410 * t438 + t1687 * t410 * t438 + t1191 * t1389 / 0.2e1 - 0.5e1 / 0.16e2 * t912 * t1692 + t468 * (0.55604166666666666666666666666666666666666666666666e-2 * t919 * t476 * t1696 * t922 + 0.12974305555555555555555555555555555555555555555555e-1 * t1400 + 0.11120833333333333333333333333333333333333333333333e-1 * t474 * t933 * t1199 * t419 * t1182 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t5 * (-t1660 * t414 * t417 - 0.12e2 * t416 * t943 * t1665 + 0.3e1 * t416 * t479 * t1681 + 0.6e1 * t1193 * t1195) * t419 - 0.27802083333333333333333333333333333333333333333333e-2 * t474 * t476 * t1696 * t419 + t965 + 0.25948611111111111111111111111111111111111111111110e-1 * t1438 + 0.16681250000000000000000000000000000000000000000000e-1 * t426 * t969 * t497 * t1665 - 0.55604166666666666666666666666666666666666666666666e-2 * t426 * t496 * t497 * t1681) / 0.4e1) * t507 - 0.31091e-1 * t406 * t1743 * t988 + 0.186546e0 * t991 * t1665 + 0.93273e-1 * t442 * t1681 + t1650 - t725 - t734 + t743 + t753 + t762 - t768 - t853 + t864 + 0.186546e0 * t1340 * t1297
  t1754 = -t1658 - t785 - t857 + t776 + t779 + t782 + t843 + t1651 - t1653 - t1652 + t868 - t822 + t1657 - t1655
  t1761 = t1126 ** 2
  t1776 = t1136 ** 2
  t1784 = 0.20e2 / 0.9e1 * t118 * t546 * t1761 + 0.10e2 / 0.3e1 * t118 * t121 * t1608 + 0.80e2 / 0.9e1 * tau1 / t126 / t1130 / r1 * t133 - 0.100e3 / 0.9e1 * t1133 * t1137 + 0.20e2 / 0.9e1 * t129 * t557 * t1776 - 0.10e2 / 0.3e1 * t129 * t132 * t1608 - t569
  t1785 = t166 * t1784
  t1788 = t1140 ** 2
  t1798 = t1147 ** 2
  t1805 = 0.5e1 / 0.18e2 * t1784 * t42 * t40 + t585
  t1825 = t241 * (0.38880000000000000000000000000000000000000000000000e1 * t529 * t151 * t1788 - 0.11664000000000000000000000000000000000000000000000e2 * t207 * t1228 * t1147 + 0.19440000000000000000000000000000000000000000000000e1 * t207 * t151 * t1784 + 0.77760000000000000000000000000000000000000000000000e1 * t143 * t575 * t1798 - 0.19440000000000000000000000000000000000000000000000e1 * t143 * t227 * t1805 + 0.12597120000000000000000000000000000000000000000000e2 * t590 * t161 * t1788 - 0.30233088000000000000000000000000000000000000000000e2 * t249 * t1273 * t1147 + 0.25194240000000000000000000000000000000000000000000e1 * t249 * t161 * t1784 + 0.17635968000000000000000000000000000000000000000000e2 * t158 * t602 * t1798 - 0.25194240000000000000000000000000000000000000000000e1 * t158 * t254 * t1805)
  t1828 = t228 * t1805
  t1831 = t166 * t1788
  t1842 = t643 * t1798
  t1869 = 0.2e1 * t1566 + t1076 + 0.19440000000000000000000000000000000000000000000000e1 * (t1753 + t1754) * t140 * t513 + 0.11664000000000000000000000000000000000000000000000e2 * t1569 * t1141 + 0.58320000000000000000000000000000000000000000000000e1 * t520 * t1785 - 0.19440000000000000000000000000000000000000000000000e1 * t524 * t1825 - 0.58320000000000000000000000000000000000000000000000e1 * t524 * t1828 + 0.11664000000000000000000000000000000000000000000000e2 * t1080 * t1831 - 0.34992000000000000000000000000000000000000000000000e2 * t520 * t228 * t1140 * t1147 - 0.11664000000000000000000000000000000000000000000000e2 * t520 * t241 * t1140 * t1163 + 0.23328000000000000000000000000000000000000000000000e2 * t524 * t1842 + t194 * t113 * (-0.11664000000000000000000000000000000000000000000000e2 * t529 * t1831 + 0.34992000000000000000000000000000000000000000000000e2 * t631 * t1508 * t1147 + 0.11664000000000000000000000000000000000000000000000e2 * t636 * t1515 * t1163 - 0.58320000000000000000000000000000000000000000000000e1 * t207 * t1785 - 0.23328000000000000000000000000000000000000000000000e2 * t143 * t1842 - 0.11664000000000000000000000000000000000000000000000e2 * t647 * t1530 * t1163 + 0.58320000000000000000000000000000000000000000000000e1 * t143 * t1828 - 0.38880000000000000000000000000000000000000000000000e1 * t143 * t1636 + 0.19440000000000000000000000000000000000000000000000e1 * t143 * t1825)
  d22 = t172 - 0.4726e1 * t1120 + 0.2e1 * t1125 + 0.2e1 * t1169 + 0.38880000000000000000000000000000000000000000000000e1 * t1217 + 0.11664000000000000000000000000000000000000000000000e2 * t1219 - 0.11664000000000000000000000000000000000000000000000e2 * t1221 - 0.38880000000000000000000000000000000000000000000000e1 * t1223 + t7 * (t1646 + t1869)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

