"""Generated from mgga_x_2d_js17.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  js17_lambda = 0.74

  js17_beta = 30.0

  js17_R = lambda s, t: 1 + 128 / 21 * (2 * js17_lambda - 1) ** 2 * s ** 2 + (3 * (js17_lambda ** 2 - js17_lambda + 1 / 2) * (t - 4 * jnp.pi) - t) / (4 * jnp.pi)

  js17_ff = lambda s: (1 + 90 * (2 * js17_lambda - 1) ** 2 * s ** 2 + js17_beta * (2 * js17_lambda - 1) ** 4 * s ** 4) ** (1 / 15)

  js17_f = lambda x, u, t: 1 / js17_ff(X2S_2D * x) + 2 / 5 * js17_R(X2S_2D * x, t) / js17_ff(X2S_2D * x) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, js17_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  js17_lambda = 0.74

  js17_beta = 30.0

  js17_R = lambda s, t: 1 + 128 / 21 * (2 * js17_lambda - 1) ** 2 * s ** 2 + (3 * (js17_lambda ** 2 - js17_lambda + 1 / 2) * (t - 4 * jnp.pi) - t) / (4 * jnp.pi)

  js17_ff = lambda s: (1 + 90 * (2 * js17_lambda - 1) ** 2 * s ** 2 + js17_beta * (2 * js17_lambda - 1) ** 4 * s ** 4) ** (1 / 15)

  js17_f = lambda x, u, t: 1 / js17_ff(X2S_2D * x) + 2 / 5 * js17_R(X2S_2D * x, t) / js17_ff(X2S_2D * x) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, js17_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  js17_lambda = 0.74

  js17_beta = 30.0

  js17_R = lambda s, t: 1 + 128 / 21 * (2 * js17_lambda - 1) ** 2 * s ** 2 + (3 * (js17_lambda ** 2 - js17_lambda + 1 / 2) * (t - 4 * jnp.pi) - t) / (4 * jnp.pi)

  js17_ff = lambda s: (1 + 90 * (2 * js17_lambda - 1) ** 2 * s ** 2 + js17_beta * (2 * js17_lambda - 1) ** 4 * s ** 4) ** (1 / 15)

  js17_f = lambda x, u, t: 1 / js17_ff(X2S_2D * x) + 2 / 5 * js17_R(X2S_2D * x, t) / js17_ff(X2S_2D * x) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, js17_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 0.1e1 / jnp.pi
  t29 = t28 * s0
  t30 = r0 ** 2
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / t30
  t35 = t29 * t34
  t37 = jnp.pi ** 2
  t38 = 0.1e1 / t37
  t39 = s0 ** 2
  t40 = t38 * t39
  t41 = t30 ** 2
  t44 = 0.1e1 / t31 / t41 / r0
  t47 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t35 + 0.62208000000000000000000000000000000000000000000000e-2 * t40 * t44
  t48 = t47 ** (0.1e1 / 0.15e2)
  t52 = 0.1e1 / t32 / r0
  t55 = 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi
  t59 = 0.2e1 / 0.5e1 + 0.35108571428571428571428571428571428571428571428572e-1 * t35 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau0 * t52 - t55) * t28 / 0.10e2
  t60 = t47 ** (0.1e1 / 0.5e1)
  t61 = 0.1e1 / t60
  t63 = 0.1e1 / t48 + t59 * t61
  t67 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t63)
  t68 = r1 <= f.p.dens_threshold
  t69 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t70 = 0.1e1 + t69
  t71 = t70 <= f.p.zeta_threshold
  t72 = t70 ** (0.1e1 / 0.3e1)
  t74 = f.my_piecewise3(t71, t22, t72 * t70)
  t75 = t74 * t26
  t76 = t28 * s2
  t77 = r1 ** 2
  t78 = r1 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t81 = 0.1e1 / t79 / t77
  t82 = t76 * t81
  t84 = s2 ** 2
  t85 = t38 * t84
  t86 = t77 ** 2
  t89 = 0.1e1 / t78 / t86 / r1
  t92 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t82 + 0.62208000000000000000000000000000000000000000000000e-2 * t85 * t89
  t93 = t92 ** (0.1e1 / 0.15e2)
  t97 = 0.1e1 / t79 / r1
  t103 = 0.2e1 / 0.5e1 + 0.35108571428571428571428571428571428571428571428572e-1 * t82 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau1 * t97 - t55) * t28 / 0.10e2
  t104 = t92 ** (0.1e1 / 0.5e1)
  t105 = 0.1e1 / t104
  t107 = 0.1e1 / t93 + t103 * t105
  t111 = f.my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t5 * t75 * t107)
  t112 = t6 ** 2
  t114 = t16 / t112
  t115 = t7 - t114
  t116 = f.my_piecewise5(t10, 0, t14, 0, t115)
  t119 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t116)
  t124 = t26 ** 2
  t125 = 0.1e1 / t124
  t129 = t5 * t25 * t125 * t63 / 0.8e1
  t131 = 0.1e1 / t48 / t47
  t135 = t29 / t32 / t30 / r0
  t142 = -0.34560000000000000000000000000000000000000000000000e1 * t135 - 0.33177600000000000000000000000000000000000000000000e-1 * t40 / t31 / t41 / t30
  t153 = t59 / t60 / t47
  t161 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t119 * t26 * t63 - t129 - 0.3e1 / 0.8e1 * t5 * t27 * (-t131 * t142 / 0.15e2 + (-0.93622857142857142857142857142857142857142857142859e-1 * t135 + 0.12866666666666666666666666666666666666666666666667e-1 * tau0 * t34 * t28) * t61 - t153 * t142 / 0.5e1))
  t163 = f.my_piecewise5(t14, 0, t10, 0, -t115)
  t166 = f.my_piecewise3(t71, 0, 0.4e1 / 0.3e1 * t72 * t163)
  t174 = t5 * t74 * t125 * t107 / 0.8e1
  t176 = f.my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t5 * t166 * t26 * t107 - t174)
  vrho_0_ = t67 + t111 + t6 * (t161 + t176)
  t179 = -t7 - t114
  t180 = f.my_piecewise5(t10, 0, t14, 0, t179)
  t183 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t180)
  t189 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t183 * t26 * t63 - t129)
  t191 = f.my_piecewise5(t14, 0, t10, 0, -t179)
  t194 = f.my_piecewise3(t71, 0, 0.4e1 / 0.3e1 * t72 * t191)
  t200 = 0.1e1 / t93 / t92
  t204 = t76 / t79 / t77 / r1
  t211 = -0.34560000000000000000000000000000000000000000000000e1 * t204 - 0.33177600000000000000000000000000000000000000000000e-1 * t85 / t78 / t86 / t77
  t222 = t103 / t104 / t92
  t230 = f.my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t5 * t194 * t26 * t107 - t174 - 0.3e1 / 0.8e1 * t5 * t75 * (-t200 * t211 / 0.15e2 + (-0.93622857142857142857142857142857142857142857142859e-1 * t204 + 0.12866666666666666666666666666666666666666666666667e-1 * tau1 * t81 * t28) * t105 - t222 * t211 / 0.5e1))
  vrho_1_ = t67 + t111 + t6 * (t189 + t230)
  t233 = t28 * t34
  t238 = 0.12960000000000000000000000000000000000000000000000e1 * t233 + 0.12441600000000000000000000000000000000000000000000e-1 * t38 * s0 * t44
  t249 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-t131 * t238 / 0.15e2 + 0.35108571428571428571428571428571428571428571428572e-1 * t233 * t61 - t153 * t238 / 0.5e1))
  vsigma_0_ = t6 * t249
  vsigma_1_ = 0.0e0
  t250 = t28 * t81
  t255 = 0.12960000000000000000000000000000000000000000000000e1 * t250 + 0.12441600000000000000000000000000000000000000000000e-1 * t38 * s2 * t89
  t266 = f.my_piecewise3(t68, 0, -0.3e1 / 0.8e1 * t5 * t75 * (-t200 * t255 / 0.15e2 + 0.35108571428571428571428571428571428571428571428572e-1 * t250 * t105 - t222 * t255 / 0.5e1))
  vsigma_2_ = t6 * t266
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t269 = t2 / t3 / jnp.pi
  t275 = f.my_piecewise3(t1, 0, 0.28950000000000000000000000000000000000000000000000e-2 * t269 * t25 * t26 * t52 * t61)
  vtau_0_ = t6 * t275
  t281 = f.my_piecewise3(t68, 0, 0.28950000000000000000000000000000000000000000000000e-2 * t269 * t74 * t26 * t97 * t105)
  vtau_1_ = t6 * t281
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  js17_lambda = 0.74

  js17_beta = 30.0

  js17_R = lambda s, t: 1 + 128 / 21 * (2 * js17_lambda - 1) ** 2 * s ** 2 + (3 * (js17_lambda ** 2 - js17_lambda + 1 / 2) * (t - 4 * jnp.pi) - t) / (4 * jnp.pi)

  js17_ff = lambda s: (1 + 90 * (2 * js17_lambda - 1) ** 2 * s ** 2 + js17_beta * (2 * js17_lambda - 1) ** 4 * s ** 4) ** (1 / 15)

  js17_f = lambda x, u, t: 1 / js17_ff(X2S_2D * x) + 2 / 5 * js17_R(X2S_2D * x, t) / js17_ff(X2S_2D * x) ** 3

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, js17_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 0.1e1 / jnp.pi
  t21 = t20 * s0
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = r0 ** 2
  t25 = t18 ** 2
  t27 = 0.1e1 / t25 / t24
  t29 = t21 * t23 * t27
  t31 = jnp.pi ** 2
  t32 = 0.1e1 / t31
  t33 = s0 ** 2
  t34 = t32 * t33
  t35 = t24 ** 2
  t39 = t22 / t18 / t35 / r0
  t42 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t29 + 0.12441600000000000000000000000000000000000000000000e-1 * t34 * t39
  t43 = t42 ** (0.1e1 / 0.15e2)
  t46 = tau0 * t23
  t55 = 0.2e1 / 0.5e1 + 0.35108571428571428571428571428571428571428571428572e-1 * t29 + (-0.7720000000000000000000000000000000000000000000000e-1 * t46 / t25 / r0 - 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi) * t20 / 0.10e2
  t56 = t42 ** (0.1e1 / 0.5e1)
  t57 = 0.1e1 / t56
  t59 = 0.1e1 / t43 + t55 * t57
  t63 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t59)
  t70 = 0.1e1 / t43 / t42
  t75 = t21 * t23 / t25 / t24 / r0
  t83 = -0.34560000000000000000000000000000000000000000000000e1 * t75 - 0.66355200000000000000000000000000000000000000000000e-1 * t34 * t22 / t18 / t35 / t24
  t94 = t55 / t56 / t42
  t102 = f.my_piecewise3(t2, 0, -t6 * t17 / t25 * t59 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-t70 * t83 / 0.15e2 + (-0.93622857142857142857142857142857142857142857142859e-1 * t75 + 0.12866666666666666666666666666666666666666666666667e-1 * t46 * t27 * t20) * t57 - t94 * t83 / 0.5e1))
  vrho_0_ = 0.2e1 * r0 * t102 + 0.2e1 * t63
  t105 = t20 * t23
  t111 = 0.12960000000000000000000000000000000000000000000000e1 * t105 * t27 + 0.24883200000000000000000000000000000000000000000000e-1 * t32 * s0 * t39
  t123 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-t70 * t111 / 0.15e2 + 0.35108571428571428571428571428571428571428571428572e-1 * t105 * t27 * t57 - t94 * t111 / 0.5e1))
  vsigma_0_ = 0.2e1 * r0 * t123
  vlapl_0_ = 0.0e0
  t135 = f.my_piecewise3(t2, 0, 0.28950000000000000000000000000000000000000000000000e-2 * t3 / t4 / jnp.pi * t17 / t18 / r0 * t23 * t57)
  vtau_0_ = 0.2e1 * r0 * t135
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 0.1e1 / jnp.pi
  t23 = t22 * s0
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = r0 ** 2
  t28 = 0.1e1 / t19 / t26
  t30 = t23 * t25 * t28
  t32 = jnp.pi ** 2
  t34 = s0 ** 2
  t35 = 0.1e1 / t32 * t34
  t36 = t26 ** 2
  t43 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t30 + 0.12441600000000000000000000000000000000000000000000e-1 * t35 * t24 / t18 / t36 / r0
  t44 = t43 ** (0.1e1 / 0.15e2)
  t47 = tau0 * t25
  t49 = 0.1e1 / t19 / r0
  t56 = 0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t30 + (-0.7720000000000000000000000000000000000000000000000e-1 * t47 * t49 - 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi) * t22 / 0.4e1
  t57 = t43 ** (0.1e1 / 0.5e1)
  t58 = 0.1e1 / t57
  t61 = 0.1e1 / t44 + 0.2e1 / 0.5e1 * t56 * t58
  t65 = t17 * t18
  t67 = 0.1e1 / t44 / t43
  t68 = t26 * r0
  t70 = 0.1e1 / t19 / t68
  t72 = t23 * t25 * t70
  t80 = -0.34560000000000000000000000000000000000000000000000e1 * t72 - 0.66355200000000000000000000000000000000000000000000e-1 * t35 * t24 / t18 / t36 / t26
  t87 = -0.23405714285714285714285714285714285714285714285714e0 * t72 + 0.32166666666666666666666666666666666666666666666668e-1 * t47 * t28 * t22
  t91 = 0.1e1 / t57 / t43
  t92 = t56 * t91
  t95 = -t67 * t80 / 0.15e2 + 0.2e1 / 0.5e1 * t87 * t58 - 0.2e1 / 0.25e2 * t92 * t80
  t100 = f.my_piecewise3(t2, 0, -t6 * t21 * t61 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t65 * t95)
  t109 = t43 ** 2
  t112 = t80 ** 2
  t118 = t23 * t25 / t19 / t36
  t126 = 0.12672000000000000000000000000000000000000000000000e2 * t118 + 0.42024960000000000000000000000000000000000000000000e0 * t35 * t24 / t18 / t36 / t68
  t151 = f.my_piecewise3(t2, 0, t6 * t17 * t49 * t61 / 0.12e2 - t6 * t21 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t65 * (0.16e2 / 0.225e3 / t44 / t109 * t112 - t67 * t126 / 0.15e2 + 0.2e1 / 0.5e1 * (0.85820952380952380952380952380952380952380952380951e0 * t118 - 0.85777777777777777777777777777777777777777777777781e-1 * t47 * t70 * t22) * t58 - 0.4e1 / 0.25e2 * t87 * t91 * t80 + 0.12e2 / 0.125e3 * t56 / t57 / t109 * t112 - 0.2e1 / 0.25e2 * t92 * t126))
  v2rho2_0_ = 0.2e1 * r0 * t151 + 0.4e1 * t100
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = 0.1e1 / jnp.pi
  t24 = t23 * s0
  t25 = 2 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = r0 ** 2
  t29 = 0.1e1 / t19 / t27
  t31 = t24 * t26 * t29
  t33 = jnp.pi ** 2
  t35 = s0 ** 2
  t36 = 0.1e1 / t33 * t35
  t37 = t27 ** 2
  t38 = t37 * r0
  t44 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t31 + 0.12441600000000000000000000000000000000000000000000e-1 * t36 * t25 / t18 / t38
  t45 = t44 ** (0.1e1 / 0.15e2)
  t48 = tau0 * t26
  t55 = 0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t31 + (-0.7720000000000000000000000000000000000000000000000e-1 * t48 * t21 - 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi) * t23 / 0.4e1
  t56 = t44 ** (0.1e1 / 0.5e1)
  t57 = 0.1e1 / t56
  t60 = 0.1e1 / t45 + 0.2e1 / 0.5e1 * t55 * t57
  t65 = t17 / t19
  t67 = 0.1e1 / t45 / t44
  t68 = t27 * r0
  t70 = 0.1e1 / t19 / t68
  t72 = t24 * t26 * t70
  t80 = -0.34560000000000000000000000000000000000000000000000e1 * t72 - 0.66355200000000000000000000000000000000000000000000e-1 * t36 * t25 / t18 / t37 / t27
  t87 = -0.23405714285714285714285714285714285714285714285714e0 * t72 + 0.32166666666666666666666666666666666666666666666668e-1 * t48 * t29 * t23
  t91 = 0.1e1 / t56 / t44
  t92 = t55 * t91
  t95 = -t67 * t80 / 0.15e2 + 0.2e1 / 0.5e1 * t87 * t57 - 0.2e1 / 0.25e2 * t92 * t80
  t99 = t17 * t18
  t100 = t44 ** 2
  t102 = 0.1e1 / t45 / t100
  t103 = t80 ** 2
  t107 = 0.1e1 / t19 / t37
  t109 = t24 * t26 * t107
  t117 = 0.12672000000000000000000000000000000000000000000000e2 * t109 + 0.42024960000000000000000000000000000000000000000000e0 * t36 * t25 / t18 / t37 / t68
  t124 = 0.85820952380952380952380952380952380952380952380951e0 * t109 - 0.85777777777777777777777777777777777777777777777781e-1 * t48 * t70 * t23
  t127 = t87 * t91
  t131 = 0.1e1 / t56 / t100
  t132 = t55 * t131
  t137 = 0.16e2 / 0.225e3 * t102 * t103 - t67 * t117 / 0.15e2 + 0.2e1 / 0.5e1 * t124 * t57 - 0.4e1 / 0.25e2 * t127 * t80 + 0.12e2 / 0.125e3 * t132 * t103 - 0.2e1 / 0.25e2 * t92 * t117
  t142 = f.my_piecewise3(t2, 0, t6 * t22 * t60 / 0.12e2 - t6 * t65 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t137)
  t154 = t100 * t44
  t157 = t103 * t80
  t166 = t24 * t26 / t19 / t38
  t168 = t37 ** 2
  t174 = -0.59136000000000000000000000000000000000000000000000e2 * t166 - 0.30818304000000000000000000000000000000000000000000e1 * t36 * t25 / t18 / t168
  t207 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t29 * t60 + t6 * t22 * t95 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t65 * t137 - 0.3e1 / 0.8e1 * t6 * t99 * (-0.496e3 / 0.3375e4 / t45 / t154 * t157 + 0.16e2 / 0.75e2 * t102 * t80 * t117 - t67 * t174 / 0.15e2 + 0.2e1 / 0.5e1 * (-0.40049777777777777777777777777777777777777777777777e1 * t166 + 0.31451851851851851851851851851851851851851851851853e0 * t48 * t107 * t23) * t57 - 0.6e1 / 0.25e2 * t124 * t91 * t80 + 0.36e2 / 0.125e3 * t87 * t131 * t103 - 0.6e1 / 0.25e2 * t127 * t117 - 0.132e3 / 0.625e3 * t55 / t56 / t154 * t157 + 0.36e2 / 0.125e3 * t132 * t80 * t117 - 0.2e1 / 0.25e2 * t92 * t174))
  v3rho3_0_ = 0.2e1 * r0 * t207 + 0.6e1 * t142

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 0.1e1 / jnp.pi
  t25 = t24 * s0
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t25 * t27 * t22
  t31 = jnp.pi ** 2
  t33 = s0 ** 2
  t34 = 0.1e1 / t31 * t33
  t35 = t18 ** 2
  t36 = t35 * r0
  t42 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t29 + 0.12441600000000000000000000000000000000000000000000e-1 * t34 * t26 / t19 / t36
  t43 = t42 ** (0.1e1 / 0.15e2)
  t46 = tau0 * t27
  t48 = 0.1e1 / t20 / r0
  t55 = 0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t29 + (-0.7720000000000000000000000000000000000000000000000e-1 * t46 * t48 - 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi) * t24 / 0.4e1
  t56 = t42 ** (0.1e1 / 0.5e1)
  t57 = 0.1e1 / t56
  t60 = 0.1e1 / t43 + 0.2e1 / 0.5e1 * t55 * t57
  t64 = t17 * t48
  t66 = 0.1e1 / t43 / t42
  t67 = t18 * r0
  t69 = 0.1e1 / t20 / t67
  t71 = t25 * t27 * t69
  t73 = t35 * t18
  t79 = -0.34560000000000000000000000000000000000000000000000e1 * t71 - 0.66355200000000000000000000000000000000000000000000e-1 * t34 * t26 / t19 / t73
  t86 = -0.23405714285714285714285714285714285714285714285714e0 * t71 + 0.32166666666666666666666666666666666666666666666668e-1 * t46 * t22 * t24
  t90 = 0.1e1 / t56 / t42
  t91 = t55 * t90
  t94 = -t66 * t79 / 0.15e2 + 0.2e1 / 0.5e1 * t86 * t57 - 0.2e1 / 0.25e2 * t91 * t79
  t99 = t17 / t20
  t100 = t42 ** 2
  t102 = 0.1e1 / t43 / t100
  t103 = t79 ** 2
  t107 = 0.1e1 / t20 / t35
  t109 = t25 * t27 * t107
  t117 = 0.12672000000000000000000000000000000000000000000000e2 * t109 + 0.42024960000000000000000000000000000000000000000000e0 * t34 * t26 / t19 / t35 / t67
  t124 = 0.85820952380952380952380952380952380952380952380951e0 * t109 - 0.85777777777777777777777777777777777777777777777781e-1 * t46 * t69 * t24
  t127 = t86 * t90
  t131 = 0.1e1 / t56 / t100
  t132 = t55 * t131
  t137 = 0.16e2 / 0.225e3 * t102 * t103 - t66 * t117 / 0.15e2 + 0.2e1 / 0.5e1 * t124 * t57 - 0.4e1 / 0.25e2 * t127 * t79 + 0.12e2 / 0.125e3 * t132 * t103 - 0.2e1 / 0.25e2 * t91 * t117
  t141 = t17 * t19
  t142 = t100 * t42
  t144 = 0.1e1 / t43 / t142
  t145 = t103 * t79
  t148 = t102 * t79
  t152 = 0.1e1 / t20 / t36
  t154 = t25 * t27 * t152
  t156 = t35 ** 2
  t162 = -0.59136000000000000000000000000000000000000000000000e2 * t154 - 0.30818304000000000000000000000000000000000000000000e1 * t34 * t26 / t19 / t156
  t169 = -0.40049777777777777777777777777777777777777777777777e1 * t154 + 0.31451851851851851851851851851851851851851851851853e0 * t46 * t107 * t24
  t172 = t124 * t90
  t175 = t86 * t131
  t181 = 0.1e1 / t56 / t142
  t182 = t55 * t181
  t185 = t79 * t117
  t190 = -0.496e3 / 0.3375e4 * t144 * t145 + 0.16e2 / 0.75e2 * t148 * t117 - t66 * t162 / 0.15e2 + 0.2e1 / 0.5e1 * t169 * t57 - 0.6e1 / 0.25e2 * t172 * t79 + 0.36e2 / 0.125e3 * t175 * t103 - 0.6e1 / 0.25e2 * t127 * t117 - 0.132e3 / 0.625e3 * t182 * t145 + 0.36e2 / 0.125e3 * t132 * t185 - 0.2e1 / 0.25e2 * t91 * t162
  t195 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t60 + t6 * t64 * t94 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t99 * t137 - 0.3e1 / 0.8e1 * t6 * t141 * t190)
  t213 = t25 * t27 / t20 / t73
  t221 = 0.33510400000000000000000000000000000000000000000000e3 * t213 + 0.25681920000000000000000000000000000000000000000000e2 * t34 * t26 / t19 / t156 / r0
  t231 = t100 ** 2
  t235 = t103 ** 2
  t241 = t117 ** 2
  t275 = -t66 * t221 / 0.15e2 + 0.2e1 / 0.5e1 * (0.22694874074074074074074074074074074074074074074074e2 * t213 - 0.14677530864197530864197530864197530864197530864198e1 * t46 * t152 * t24) * t57 + 0.2112e4 / 0.3125e4 * t55 / t56 / t231 * t235 - 0.792e3 / 0.625e3 * t182 * t103 * t117 + 0.36e2 / 0.125e3 * t132 * t241 + 0.48e2 / 0.125e3 * t132 * t79 * t162 + 0.72e2 / 0.125e3 * t124 * t131 * t103 - 0.528e3 / 0.625e3 * t86 * t181 * t145 + 0.144e3 / 0.125e3 * t175 * t185 - 0.2e1 / 0.25e2 * t91 * t221 + 0.64e2 / 0.225e3 * t148 * t162 - 0.8e1 / 0.25e2 * t169 * t90 * t79 - 0.12e2 / 0.25e2 * t172 * t117 - 0.8e1 / 0.25e2 * t127 * t162 + 0.22816e5 / 0.50625e5 / t43 / t231 * t235 - 0.992e3 / 0.1125e4 * t144 * t103 * t117 + 0.16e2 / 0.75e2 * t102 * t241
  t280 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t69 * t60 - 0.5e1 / 0.9e1 * t6 * t23 * t94 + t6 * t64 * t137 / 0.2e1 - t6 * t99 * t190 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t141 * t275)
  v4rho4_0_ = 0.2e1 * r0 * t280 + 0.8e1 * t195

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 0.1e1 / jnp.pi
  t33 = t32 * s0
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = t33 * t38
  t41 = jnp.pi ** 2
  t42 = 0.1e1 / t41
  t43 = s0 ** 2
  t44 = t42 * t43
  t45 = t34 ** 2
  t51 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t39 + 0.62208000000000000000000000000000000000000000000000e-2 * t44 / t35 / t45 / r0
  t52 = t51 ** (0.1e1 / 0.15e2)
  t59 = 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi
  t63 = 0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t39 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau0 / t36 / r0 - t59) * t32 / 0.4e1
  t64 = t51 ** (0.1e1 / 0.5e1)
  t65 = 0.1e1 / t64
  t68 = 0.1e1 / t52 + 0.2e1 / 0.5e1 * t63 * t65
  t72 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t73 = t72 * f.p.zeta_threshold
  t75 = f.my_piecewise3(t20, t73, t21 * t19)
  t76 = t30 ** 2
  t77 = 0.1e1 / t76
  t78 = t75 * t77
  t81 = t5 * t78 * t68 / 0.8e1
  t82 = t75 * t30
  t84 = 0.1e1 / t52 / t51
  t85 = t34 * r0
  t87 = 0.1e1 / t36 / t85
  t88 = t33 * t87
  t95 = -0.34560000000000000000000000000000000000000000000000e1 * t88 - 0.33177600000000000000000000000000000000000000000000e-1 * t44 / t35 / t45 / t34
  t102 = -0.23405714285714285714285714285714285714285714285714e0 * t88 + 0.32166666666666666666666666666666666666666666666668e-1 * tau0 * t38 * t32
  t106 = 0.1e1 / t64 / t51
  t107 = t63 * t106
  t110 = -t84 * t95 / 0.15e2 + 0.2e1 / 0.5e1 * t102 * t65 - 0.2e1 / 0.25e2 * t107 * t95
  t115 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t68 - t81 - 0.3e1 / 0.8e1 * t5 * t82 * t110)
  t117 = r1 <= f.p.dens_threshold
  t118 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t119 = 0.1e1 + t118
  t120 = t119 <= f.p.zeta_threshold
  t121 = t119 ** (0.1e1 / 0.3e1)
  t123 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t126 = f.my_piecewise3(t120, 0, 0.4e1 / 0.3e1 * t121 * t123)
  t127 = t126 * t30
  t128 = t32 * s2
  t129 = r1 ** 2
  t130 = r1 ** (0.1e1 / 0.3e1)
  t131 = t130 ** 2
  t133 = 0.1e1 / t131 / t129
  t134 = t128 * t133
  t136 = s2 ** 2
  t137 = t42 * t136
  t138 = t129 ** 2
  t144 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t134 + 0.62208000000000000000000000000000000000000000000000e-2 * t137 / t130 / t138 / r1
  t145 = t144 ** (0.1e1 / 0.15e2)
  t155 = 0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t134 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau1 / t131 / r1 - t59) * t32 / 0.4e1
  t156 = t144 ** (0.1e1 / 0.5e1)
  t157 = 0.1e1 / t156
  t160 = 0.1e1 / t145 + 0.2e1 / 0.5e1 * t155 * t157
  t165 = f.my_piecewise3(t120, t73, t121 * t119)
  t166 = t165 * t77
  t169 = t5 * t166 * t160 / 0.8e1
  t171 = f.my_piecewise3(t117, 0, -0.3e1 / 0.8e1 * t5 * t127 * t160 - t169)
  t173 = t21 ** 2
  t174 = 0.1e1 / t173
  t175 = t26 ** 2
  t180 = t16 / t22 / t6
  t182 = -0.2e1 * t23 + 0.2e1 * t180
  t183 = f.my_piecewise5(t10, 0, t14, 0, t182)
  t187 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t174 * t175 + 0.4e1 / 0.3e1 * t21 * t183)
  t194 = t5 * t29 * t77 * t68
  t200 = 0.1e1 / t76 / t6
  t204 = t5 * t75 * t200 * t68 / 0.12e2
  t206 = t5 * t78 * t110
  t208 = t51 ** 2
  t211 = t95 ** 2
  t216 = t33 / t36 / t45
  t223 = 0.12672000000000000000000000000000000000000000000000e2 * t216 + 0.21012480000000000000000000000000000000000000000000e0 * t44 / t35 / t45 / t85
  t248 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t187 * t30 * t68 - t194 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t110 + t204 - t206 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t82 * (0.16e2 / 0.225e3 / t52 / t208 * t211 - t84 * t223 / 0.15e2 + 0.2e1 / 0.5e1 * (0.85820952380952380952380952380952380952380952380951e0 * t216 - 0.85777777777777777777777777777777777777777777777781e-1 * tau0 * t87 * t32) * t65 - 0.4e1 / 0.25e2 * t102 * t106 * t95 + 0.12e2 / 0.125e3 * t63 / t64 / t208 * t211 - 0.2e1 / 0.25e2 * t107 * t223))
  t249 = t121 ** 2
  t250 = 0.1e1 / t249
  t251 = t123 ** 2
  t255 = f.my_piecewise5(t14, 0, t10, 0, -t182)
  t259 = f.my_piecewise3(t120, 0, 0.4e1 / 0.9e1 * t250 * t251 + 0.4e1 / 0.3e1 * t121 * t255)
  t266 = t5 * t126 * t77 * t160
  t271 = t5 * t165 * t200 * t160 / 0.12e2
  t273 = f.my_piecewise3(t117, 0, -0.3e1 / 0.8e1 * t5 * t259 * t30 * t160 - t266 / 0.4e1 + t271)
  d11 = 0.2e1 * t115 + 0.2e1 * t171 + t6 * (t248 + t273)
  t276 = -t7 - t24
  t277 = f.my_piecewise5(t10, 0, t14, 0, t276)
  t280 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t277)
  t281 = t280 * t30
  t286 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t281 * t68 - t81)
  t288 = f.my_piecewise5(t14, 0, t10, 0, -t276)
  t291 = f.my_piecewise3(t120, 0, 0.4e1 / 0.3e1 * t121 * t288)
  t292 = t291 * t30
  t296 = t165 * t30
  t298 = 0.1e1 / t145 / t144
  t299 = t129 * r1
  t301 = 0.1e1 / t131 / t299
  t302 = t128 * t301
  t309 = -0.34560000000000000000000000000000000000000000000000e1 * t302 - 0.33177600000000000000000000000000000000000000000000e-1 * t137 / t130 / t138 / t129
  t316 = -0.23405714285714285714285714285714285714285714285714e0 * t302 + 0.32166666666666666666666666666666666666666666666668e-1 * tau1 * t133 * t32
  t320 = 0.1e1 / t156 / t144
  t321 = t155 * t320
  t324 = -t298 * t309 / 0.15e2 + 0.2e1 / 0.5e1 * t316 * t157 - 0.2e1 / 0.25e2 * t321 * t309
  t329 = f.my_piecewise3(t117, 0, -0.3e1 / 0.8e1 * t5 * t292 * t160 - t169 - 0.3e1 / 0.8e1 * t5 * t296 * t324)
  t333 = 0.2e1 * t180
  t334 = f.my_piecewise5(t10, 0, t14, 0, t333)
  t338 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t174 * t277 * t26 + 0.4e1 / 0.3e1 * t21 * t334)
  t345 = t5 * t280 * t77 * t68
  t353 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t338 * t30 * t68 - t345 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t281 * t110 - t194 / 0.8e1 + t204 - t206 / 0.8e1)
  t357 = f.my_piecewise5(t14, 0, t10, 0, -t333)
  t361 = f.my_piecewise3(t120, 0, 0.4e1 / 0.9e1 * t250 * t288 * t123 + 0.4e1 / 0.3e1 * t121 * t357)
  t368 = t5 * t291 * t77 * t160
  t375 = t5 * t166 * t324
  t378 = f.my_piecewise3(t117, 0, -0.3e1 / 0.8e1 * t5 * t361 * t30 * t160 - t368 / 0.8e1 - t266 / 0.8e1 + t271 - 0.3e1 / 0.8e1 * t5 * t127 * t324 - t375 / 0.8e1)
  d12 = t115 + t171 + t286 + t329 + t6 * (t353 + t378)
  t383 = t277 ** 2
  t387 = 0.2e1 * t23 + 0.2e1 * t180
  t388 = f.my_piecewise5(t10, 0, t14, 0, t387)
  t392 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t174 * t383 + 0.4e1 / 0.3e1 * t21 * t388)
  t399 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t392 * t30 * t68 - t345 / 0.4e1 + t204)
  t400 = t288 ** 2
  t404 = f.my_piecewise5(t14, 0, t10, 0, -t387)
  t408 = f.my_piecewise3(t120, 0, 0.4e1 / 0.9e1 * t250 * t400 + 0.4e1 / 0.3e1 * t121 * t404)
  t418 = t144 ** 2
  t421 = t309 ** 2
  t426 = t128 / t131 / t138
  t433 = 0.12672000000000000000000000000000000000000000000000e2 * t426 + 0.21012480000000000000000000000000000000000000000000e0 * t137 / t130 / t138 / t299
  t458 = f.my_piecewise3(t117, 0, -0.3e1 / 0.8e1 * t5 * t408 * t30 * t160 - t368 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t292 * t324 + t271 - t375 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t296 * (0.16e2 / 0.225e3 / t145 / t418 * t421 - t298 * t433 / 0.15e2 + 0.2e1 / 0.5e1 * (0.85820952380952380952380952380952380952380952380951e0 * t426 - 0.85777777777777777777777777777777777777777777777781e-1 * tau1 * t301 * t32) * t157 - 0.4e1 / 0.25e2 * t316 * t320 * t309 + 0.12e2 / 0.125e3 * t155 / t156 / t418 * t421 - 0.2e1 / 0.25e2 * t321 * t433))
  d22 = 0.2e1 * t286 + 0.2e1 * t329 + t6 * (t399 + t458)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 0.1e1 / jnp.pi
  t45 = t44 * s0
  t46 = r0 ** 2
  t47 = r0 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t50 = 0.1e1 / t48 / t46
  t51 = t45 * t50
  t53 = jnp.pi ** 2
  t54 = 0.1e1 / t53
  t55 = s0 ** 2
  t56 = t54 * t55
  t57 = t46 ** 2
  t58 = t57 * r0
  t63 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t51 + 0.62208000000000000000000000000000000000000000000000e-2 * t56 / t47 / t58
  t64 = t63 ** (0.1e1 / 0.15e2)
  t71 = 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi
  t75 = 0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t51 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau0 / t48 / r0 - t71) * t44 / 0.4e1
  t76 = t63 ** (0.1e1 / 0.5e1)
  t77 = 0.1e1 / t76
  t80 = 0.1e1 / t64 + 0.2e1 / 0.5e1 * t75 * t77
  t86 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t87 = t42 ** 2
  t88 = 0.1e1 / t87
  t89 = t86 * t88
  t93 = t86 * t42
  t95 = 0.1e1 / t64 / t63
  t96 = t46 * r0
  t98 = 0.1e1 / t48 / t96
  t99 = t45 * t98
  t106 = -0.34560000000000000000000000000000000000000000000000e1 * t99 - 0.33177600000000000000000000000000000000000000000000e-1 * t56 / t47 / t57 / t46
  t113 = -0.23405714285714285714285714285714285714285714285714e0 * t99 + 0.32166666666666666666666666666666666666666666666668e-1 * tau0 * t50 * t44
  t117 = 0.1e1 / t76 / t63
  t118 = t75 * t117
  t121 = -t95 * t106 / 0.15e2 + 0.2e1 / 0.5e1 * t113 * t77 - 0.2e1 / 0.25e2 * t118 * t106
  t125 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t126 = t125 * f.p.zeta_threshold
  t128 = f.my_piecewise3(t20, t126, t21 * t19)
  t130 = 0.1e1 / t87 / t6
  t131 = t128 * t130
  t135 = t128 * t88
  t139 = t128 * t42
  t140 = t63 ** 2
  t142 = 0.1e1 / t64 / t140
  t143 = t106 ** 2
  t147 = 0.1e1 / t48 / t57
  t148 = t45 * t147
  t155 = 0.12672000000000000000000000000000000000000000000000e2 * t148 + 0.21012480000000000000000000000000000000000000000000e0 * t56 / t47 / t57 / t96
  t162 = 0.85820952380952380952380952380952380952380952380951e0 * t148 - 0.85777777777777777777777777777777777777777777777781e-1 * tau0 * t98 * t44
  t165 = t113 * t117
  t169 = 0.1e1 / t76 / t140
  t170 = t75 * t169
  t175 = 0.16e2 / 0.225e3 * t142 * t143 - t95 * t155 / 0.15e2 + 0.2e1 / 0.5e1 * t162 * t77 - 0.4e1 / 0.25e2 * t165 * t106 + 0.12e2 / 0.125e3 * t170 * t143 - 0.2e1 / 0.25e2 * t118 * t155
  t180 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t80 - t5 * t89 * t80 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t93 * t121 + t5 * t131 * t80 / 0.12e2 - t5 * t135 * t121 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t139 * t175)
  t182 = r1 <= f.p.dens_threshold
  t183 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t184 = 0.1e1 + t183
  t185 = t184 <= f.p.zeta_threshold
  t186 = t184 ** (0.1e1 / 0.3e1)
  t187 = t186 ** 2
  t188 = 0.1e1 / t187
  t190 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t191 = t190 ** 2
  t195 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t199 = f.my_piecewise3(t185, 0, 0.4e1 / 0.9e1 * t188 * t191 + 0.4e1 / 0.3e1 * t186 * t195)
  t202 = r1 ** 2
  t203 = r1 ** (0.1e1 / 0.3e1)
  t204 = t203 ** 2
  t207 = t44 * s2 / t204 / t202
  t209 = s2 ** 2
  t211 = t202 ** 2
  t217 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t207 + 0.62208000000000000000000000000000000000000000000000e-2 * t54 * t209 / t203 / t211 / r1
  t218 = t217 ** (0.1e1 / 0.15e2)
  t229 = t217 ** (0.1e1 / 0.5e1)
  t233 = 0.1e1 / t218 + 0.2e1 / 0.5e1 * (0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t207 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau1 / t204 / r1 - t71) * t44 / 0.4e1) / t229
  t239 = f.my_piecewise3(t185, 0, 0.4e1 / 0.3e1 * t186 * t190)
  t245 = f.my_piecewise3(t185, t126, t186 * t184)
  t251 = f.my_piecewise3(t182, 0, -0.3e1 / 0.8e1 * t5 * t199 * t42 * t233 - t5 * t239 * t88 * t233 / 0.4e1 + t5 * t245 * t130 * t233 / 0.12e2)
  t261 = t24 ** 2
  t265 = 0.6e1 * t33 - 0.6e1 * t16 / t261
  t266 = f.my_piecewise5(t10, 0, t14, 0, t265)
  t270 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t266)
  t293 = 0.1e1 / t87 / t24
  t304 = t140 * t63
  t307 = t143 * t106
  t315 = t45 / t48 / t58
  t317 = t57 ** 2
  t322 = -0.59136000000000000000000000000000000000000000000000e2 * t315 - 0.15409152000000000000000000000000000000000000000000e1 * t56 / t47 / t317
  t355 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t270 * t42 * t80 - 0.3e1 / 0.8e1 * t5 * t41 * t88 * t80 - 0.9e1 / 0.8e1 * t5 * t43 * t121 + t5 * t86 * t130 * t80 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t89 * t121 - 0.9e1 / 0.8e1 * t5 * t93 * t175 - 0.5e1 / 0.36e2 * t5 * t128 * t293 * t80 + t5 * t131 * t121 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t135 * t175 - 0.3e1 / 0.8e1 * t5 * t139 * (-0.496e3 / 0.3375e4 / t64 / t304 * t307 + 0.16e2 / 0.75e2 * t142 * t106 * t155 - t95 * t322 / 0.15e2 + 0.2e1 / 0.5e1 * (-0.40049777777777777777777777777777777777777777777777e1 * t315 + 0.31451851851851851851851851851851851851851851851853e0 * tau0 * t147 * t44) * t77 - 0.6e1 / 0.25e2 * t162 * t117 * t106 + 0.36e2 / 0.125e3 * t113 * t169 * t143 - 0.6e1 / 0.25e2 * t165 * t155 - 0.132e3 / 0.625e3 * t75 / t76 / t304 * t307 + 0.36e2 / 0.125e3 * t170 * t106 * t155 - 0.2e1 / 0.25e2 * t118 * t322))
  t365 = f.my_piecewise5(t14, 0, t10, 0, -t265)
  t369 = f.my_piecewise3(t185, 0, -0.8e1 / 0.27e2 / t187 / t184 * t191 * t190 + 0.4e1 / 0.3e1 * t188 * t190 * t195 + 0.4e1 / 0.3e1 * t186 * t365)
  t387 = f.my_piecewise3(t182, 0, -0.3e1 / 0.8e1 * t5 * t369 * t42 * t233 - 0.3e1 / 0.8e1 * t5 * t199 * t88 * t233 + t5 * t239 * t130 * t233 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t245 * t293 * t233)
  d111 = 0.3e1 * t180 + 0.3e1 * t251 + t6 * (t355 + t387)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 0.1e1 / jnp.pi
  t57 = t56 * s0
  t58 = r0 ** 2
  t59 = r0 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t62 = 0.1e1 / t60 / t58
  t63 = t57 * t62
  t65 = jnp.pi ** 2
  t66 = 0.1e1 / t65
  t67 = s0 ** 2
  t68 = t66 * t67
  t69 = t58 ** 2
  t70 = t69 * r0
  t75 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t63 + 0.62208000000000000000000000000000000000000000000000e-2 * t68 / t59 / t70
  t76 = t75 ** (0.1e1 / 0.15e2)
  t83 = 0.36912000000000000000000000000000000000000000000000e1 * jnp.pi
  t87 = 0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t63 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau0 / t60 / r0 - t83) * t56 / 0.4e1
  t88 = t75 ** (0.1e1 / 0.5e1)
  t89 = 0.1e1 / t88
  t92 = 0.1e1 / t76 + 0.2e1 / 0.5e1 * t87 * t89
  t101 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t102 = t54 ** 2
  t103 = 0.1e1 / t102
  t104 = t101 * t103
  t108 = t101 * t54
  t110 = 0.1e1 / t76 / t75
  t111 = t58 * r0
  t113 = 0.1e1 / t60 / t111
  t114 = t57 * t113
  t116 = t69 * t58
  t121 = -0.34560000000000000000000000000000000000000000000000e1 * t114 - 0.33177600000000000000000000000000000000000000000000e-1 * t68 / t59 / t116
  t128 = -0.23405714285714285714285714285714285714285714285714e0 * t114 + 0.32166666666666666666666666666666666666666666666668e-1 * tau0 * t62 * t56
  t132 = 0.1e1 / t88 / t75
  t133 = t87 * t132
  t136 = -t110 * t121 / 0.15e2 + 0.2e1 / 0.5e1 * t128 * t89 - 0.2e1 / 0.25e2 * t133 * t121
  t142 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t144 = 0.1e1 / t102 / t6
  t145 = t142 * t144
  t149 = t142 * t103
  t153 = t142 * t54
  t154 = t75 ** 2
  t156 = 0.1e1 / t76 / t154
  t157 = t121 ** 2
  t161 = 0.1e1 / t60 / t69
  t162 = t57 * t161
  t169 = 0.12672000000000000000000000000000000000000000000000e2 * t162 + 0.21012480000000000000000000000000000000000000000000e0 * t68 / t59 / t69 / t111
  t176 = 0.85820952380952380952380952380952380952380952380951e0 * t162 - 0.85777777777777777777777777777777777777777777777781e-1 * tau0 * t113 * t56
  t179 = t128 * t132
  t183 = 0.1e1 / t88 / t154
  t184 = t87 * t183
  t189 = 0.16e2 / 0.225e3 * t156 * t157 - t110 * t169 / 0.15e2 + 0.2e1 / 0.5e1 * t176 * t89 - 0.4e1 / 0.25e2 * t179 * t121 + 0.12e2 / 0.125e3 * t184 * t157 - 0.2e1 / 0.25e2 * t133 * t169
  t193 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t194 = t193 * f.p.zeta_threshold
  t196 = f.my_piecewise3(t20, t194, t21 * t19)
  t198 = 0.1e1 / t102 / t25
  t199 = t196 * t198
  t203 = t196 * t144
  t207 = t196 * t103
  t211 = t196 * t54
  t212 = t154 * t75
  t214 = 0.1e1 / t76 / t212
  t215 = t157 * t121
  t218 = t156 * t121
  t222 = 0.1e1 / t60 / t70
  t223 = t57 * t222
  t225 = t69 ** 2
  t230 = -0.59136000000000000000000000000000000000000000000000e2 * t223 - 0.15409152000000000000000000000000000000000000000000e1 * t68 / t59 / t225
  t237 = -0.40049777777777777777777777777777777777777777777777e1 * t223 + 0.31451851851851851851851851851851851851851851851853e0 * tau0 * t161 * t56
  t240 = t176 * t132
  t243 = t128 * t183
  t249 = 0.1e1 / t88 / t212
  t250 = t87 * t249
  t253 = t121 * t169
  t258 = -0.496e3 / 0.3375e4 * t214 * t215 + 0.16e2 / 0.75e2 * t218 * t169 - t110 * t230 / 0.15e2 + 0.2e1 / 0.5e1 * t237 * t89 - 0.6e1 / 0.25e2 * t240 * t121 + 0.36e2 / 0.125e3 * t243 * t157 - 0.6e1 / 0.25e2 * t179 * t169 - 0.132e3 / 0.625e3 * t250 * t215 + 0.36e2 / 0.125e3 * t184 * t253 - 0.2e1 / 0.25e2 * t133 * t230
  t263 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t92 - 0.3e1 / 0.8e1 * t5 * t104 * t92 - 0.9e1 / 0.8e1 * t5 * t108 * t136 + t5 * t145 * t92 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t149 * t136 - 0.9e1 / 0.8e1 * t5 * t153 * t189 - 0.5e1 / 0.36e2 * t5 * t199 * t92 + t5 * t203 * t136 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t207 * t189 - 0.3e1 / 0.8e1 * t5 * t211 * t258)
  t265 = r1 <= f.p.dens_threshold
  t266 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t267 = 0.1e1 + t266
  t268 = t267 <= f.p.zeta_threshold
  t269 = t267 ** (0.1e1 / 0.3e1)
  t270 = t269 ** 2
  t272 = 0.1e1 / t270 / t267
  t274 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t275 = t274 ** 2
  t279 = 0.1e1 / t270
  t280 = t279 * t274
  t282 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t286 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t290 = f.my_piecewise3(t268, 0, -0.8e1 / 0.27e2 * t272 * t275 * t274 + 0.4e1 / 0.3e1 * t280 * t282 + 0.4e1 / 0.3e1 * t269 * t286)
  t293 = r1 ** 2
  t294 = r1 ** (0.1e1 / 0.3e1)
  t295 = t294 ** 2
  t298 = t56 * s2 / t295 / t293
  t300 = s2 ** 2
  t302 = t293 ** 2
  t308 = 0.1e1 + 0.12960000000000000000000000000000000000000000000000e1 * t298 + 0.62208000000000000000000000000000000000000000000000e-2 * t66 * t300 / t294 / t302 / r1
  t309 = t308 ** (0.1e1 / 0.15e2)
  t320 = t308 ** (0.1e1 / 0.5e1)
  t324 = 0.1e1 / t309 + 0.2e1 / 0.5e1 * (0.1e1 + 0.87771428571428571428571428571428571428571428571429e-1 * t298 + (-0.7720000000000000000000000000000000000000000000000e-1 * tau1 / t295 / r1 - t83) * t56 / 0.4e1) / t320
  t333 = f.my_piecewise3(t268, 0, 0.4e1 / 0.9e1 * t279 * t275 + 0.4e1 / 0.3e1 * t269 * t282)
  t340 = f.my_piecewise3(t268, 0, 0.4e1 / 0.3e1 * t269 * t274)
  t346 = f.my_piecewise3(t268, t194, t269 * t267)
  t352 = f.my_piecewise3(t265, 0, -0.3e1 / 0.8e1 * t5 * t290 * t54 * t324 - 0.3e1 / 0.8e1 * t5 * t333 * t103 * t324 + t5 * t340 * t144 * t324 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t346 * t198 * t324)
  t379 = t57 / t60 / t116
  t386 = 0.33510400000000000000000000000000000000000000000000e3 * t379 + 0.12840960000000000000000000000000000000000000000000e2 * t68 / t59 / t225 / r0
  t391 = t169 ** 2
  t401 = t154 ** 2
  t404 = t157 ** 2
  t440 = -0.2e1 / 0.25e2 * t133 * t386 - 0.8e1 / 0.25e2 * t179 * t230 + 0.16e2 / 0.75e2 * t156 * t391 + 0.64e2 / 0.225e3 * t218 * t230 - 0.8e1 / 0.25e2 * t237 * t132 * t121 - 0.12e2 / 0.25e2 * t240 * t169 + 0.22816e5 / 0.50625e5 / t76 / t401 * t404 - 0.992e3 / 0.1125e4 * t214 * t157 * t169 - t110 * t386 / 0.15e2 + 0.2e1 / 0.5e1 * (0.22694874074074074074074074074074074074074074074074e2 * t379 - 0.14677530864197530864197530864197530864197530864198e1 * tau0 * t222 * t56) * t89 - 0.528e3 / 0.625e3 * t128 * t249 * t215 + 0.144e3 / 0.125e3 * t243 * t253 + 0.2112e4 / 0.3125e4 * t87 / t88 / t401 * t404 - 0.792e3 / 0.625e3 * t250 * t157 * t169 + 0.36e2 / 0.125e3 * t184 * t391 + 0.48e2 / 0.125e3 * t184 * t121 * t230 + 0.72e2 / 0.125e3 * t176 * t183 * t157
  t444 = t19 ** 2
  t447 = t30 ** 2
  t453 = t41 ** 2
  t462 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t463 = f.my_piecewise5(t10, 0, t14, 0, t462)
  t467 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t444 * t447 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t453 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t463)
  t488 = 0.1e1 / t102 / t36
  t493 = -0.3e1 / 0.2e1 * t5 * t104 * t136 - 0.9e1 / 0.4e1 * t5 * t108 * t189 + t5 * t145 * t136 - 0.3e1 / 0.2e1 * t5 * t149 * t189 - 0.3e1 / 0.2e1 * t5 * t153 * t258 - 0.5e1 / 0.9e1 * t5 * t199 * t136 + t5 * t203 * t189 / 0.2e1 - t5 * t207 * t258 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t211 * t440 - 0.3e1 / 0.8e1 * t5 * t467 * t54 * t92 - 0.3e1 / 0.2e1 * t5 * t55 * t136 - t5 * t53 * t103 * t92 / 0.2e1 + t5 * t101 * t144 * t92 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t142 * t198 * t92 + 0.10e2 / 0.27e2 * t5 * t196 * t488 * t92
  t494 = f.my_piecewise3(t1, 0, t493)
  t495 = t267 ** 2
  t498 = t275 ** 2
  t504 = t282 ** 2
  t510 = f.my_piecewise5(t14, 0, t10, 0, -t462)
  t514 = f.my_piecewise3(t268, 0, 0.40e2 / 0.81e2 / t270 / t495 * t498 - 0.16e2 / 0.9e1 * t272 * t275 * t282 + 0.4e1 / 0.3e1 * t279 * t504 + 0.16e2 / 0.9e1 * t280 * t286 + 0.4e1 / 0.3e1 * t269 * t510)
  t536 = f.my_piecewise3(t265, 0, -0.3e1 / 0.8e1 * t5 * t514 * t54 * t324 - t5 * t290 * t103 * t324 / 0.2e1 + t5 * t333 * t144 * t324 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t340 * t198 * t324 + 0.10e2 / 0.27e2 * t5 * t346 * t488 * t324)
  d1111 = 0.4e1 * t263 + 0.4e1 * t352 + t6 * (t494 + t536)

  res = {'v4rho4': d1111}
  return res
